/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.crl;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.io.IOException;
import java.math.BigInteger;
import org.dogtagpki.server.ca.CMSCRLExtension;
import org.mozilla.jss.netscape.security.x509.DeltaCRLIndicatorExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSDeltaCRLIndicatorExtension
extends CMSCRLExtension
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(CMSDeltaCRLIndicatorExtension.class);

    @Override
    public Extension setCRLExtensionCriticality(Extension ext, boolean critical) {
        BigInteger baseCRLNumber = null;
        DeltaCRLIndicatorExtension deltaCRLIndicatorExt = null;
        try {
            baseCRLNumber = (BigInteger)((DeltaCRLIndicatorExtension)ext).get("value");
            deltaCRLIndicatorExt = new DeltaCRLIndicatorExtension(Boolean.valueOf(critical), baseCRLNumber);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DELTA_CRL_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        return deltaCRLIndicatorExt;
    }

    @Override
    public Extension getCRLExtension(ConfigStore config, Object ip, boolean critical) {
        DeltaCRLIndicatorExtension deltaCRLIndicatorExt = null;
        CRLIssuingPoint crlIssuingPoint = (CRLIssuingPoint)ip;
        try {
            deltaCRLIndicatorExt = new DeltaCRLIndicatorExtension(Boolean.valueOf(critical), crlIssuingPoint.getCRLNumber());
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DELTA_CRL_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        return deltaCRLIndicatorExt;
    }

    @Override
    public String getCRLExtOID() {
        return PKIXExtensions.DeltaCRLIndicator_Id.toString();
    }

    @Override
    public void getConfigParams(ConfigStore config, NameValuePairs nvp) {
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"enable;boolean;Check to enable Delta CRL Indicator extension.", "critical;boolean;Set criticality for Delta CRL Indicator extension.", "HELP_TOKEN;configuration-ca-edit-crlextension-crlnumber", "HELP_TEXT;The Delta CRL Indicator is a critical CRL extension which identifies a delta-CRL."};
        return params;
    }
}

