/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.cms.profile.constraint.CAEnrollConstraint;
import com.netscape.cms.profile.def.CAValidityDefault;
import com.netscape.cms.profile.def.NoDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.profile.def.UserValidityDefault;
import com.netscape.cms.profile.def.ValidityDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAValidityConstraint
extends CAEnrollConstraint {
    public static Logger logger = LoggerFactory.getLogger(CAValidityConstraint.class);
    private Date mDefNotBefore = null;
    private Date mDefNotAfter = null;

    @Override
    public void init(ConfigStore config) throws EProfileException {
        X509CertImpl caCert;
        super.init(config);
        try {
            caCert = this.getCACert();
        }
        catch (EBaseException e) {
            throw new EProfileException((Throwable)e);
        }
        this.mDefNotBefore = caCert.getNotBefore();
        this.mDefNotAfter = caCert.getNotAfter();
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        logger.info("CAValidityConstraint: Validating cert validity:");
        CertificateValidity v = null;
        try {
            v = (CertificateValidity)info.get("validity");
        }
        catch (Exception e) {
            logger.error("CAValidityConstraint: Invalid cert validity: " + e.getMessage(), (Throwable)e);
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_VALIDITY_NOT_FOUND", (String[])new String[0]), (Throwable)e);
        }
        Date notBefore = null;
        try {
            notBefore = (Date)v.get("notBefore");
        }
        catch (IOException e) {
            logger.error("CAValidityConstraint: Invalid not before: " + e.getMessage(), (Throwable)e);
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_INVALID_NOT_BEFORE", (String[])new String[0]), (Throwable)e);
        }
        logger.info("CAValidityConstraint: - not before: " + notBefore);
        Date notAfter = null;
        try {
            notAfter = (Date)v.get("notAfter");
        }
        catch (IOException e) {
            logger.error("CAValidityConstraint: Invalid not after: " + e.getMessage(), (Throwable)e);
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_INVALID_NOT_AFTER", (String[])new String[0]), (Throwable)e);
        }
        logger.info("CAValidityConstraint: - not after: " + notAfter);
        logger.info("CAValidityConstraint: CA cert validity:");
        if (this.mDefNotBefore != null) {
            logger.info("CAValidityConstraint: - not before: " + this.mDefNotBefore);
            if (notBefore.before(this.mDefNotBefore)) {
                logger.error("CAValidityConstraint: Invalid not before: " + notBefore + " < " + this.mDefNotBefore);
                throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_INVALID_NOT_BEFORE", (String[])new String[0]));
            }
        }
        logger.info("CAValidityConstraint: - not after: " + this.mDefNotAfter);
        if (notAfter.after(this.mDefNotAfter)) {
            logger.error("CAValidityConstraint: Invalid not after: " + notAfter + " > " + this.mDefNotAfter);
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_INVALID_NOT_AFTER", (String[])new String[0]));
        }
        if (notAfter.getTime() < notBefore.getTime()) {
            logger.error("CAValidityConstraint: Invalid certificate validity: not after (" + notAfter + ") < not before (" + notBefore + ")");
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_NOT_AFTER_BEFORE_NOT_BEFORE", (String[])new String[0]));
        }
        logger.info("CAValidityConstraint: Certificate validity is valid");
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.mDefNotBefore.toString(), this.mDefNotAfter.toString()};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_CA_VALIDITY_CONSTRAINT_TEXT", (String[])params);
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        if (def instanceof NoDefault) {
            return true;
        }
        if (def instanceof UserValidityDefault) {
            return true;
        }
        if (def instanceof ValidityDefault) {
            return true;
        }
        return def instanceof CAValidityDefault;
    }
}

