/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.extensions.AccessDescription;
import org.mozilla.jss.netscape.security.extensions.SubjectInfoAccessExtension;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectInfoAccessExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(SubjectInfoAccessExtDefault.class);
    public static final String CONFIG_CRITICAL = "subjInfoAccessCritical";
    public static final String CONFIG_NUM_ADS = "subjInfoAccessNumADs";
    public static final String CONFIG_AD_ENABLE = "subjInfoAccessADEnable_";
    public static final String CONFIG_AD_METHOD = "subjInfoAccessADMethod_";
    public static final String CONFIG_AD_LOCATIONTYPE = "subjInfoAccessADLocationType_";
    public static final String CONFIG_AD_LOCATION = "subjInfoAccessADLocation_";
    public static final String VAL_CRITICAL = "subjInfoAccessCritical";
    public static final String VAL_GENERAL_NAMES = "subjInfoAccessGeneralNames";
    private static final String AD_METHOD = "Method";
    private static final String AD_LOCATION_TYPE = "Location Type";
    private static final String AD_LOCATION = "Location";
    private static final String AD_ENABLE = "Enable";
    private static final int DEF_NUM_AD = 1;
    private static final int MAX_NUM_AD = 100;

    protected int getNumAds() {
        int num = 1;
        String numAds = this.getConfig(CONFIG_NUM_ADS);
        if (numAds != null) {
            try {
                num = Integer.parseInt(numAds);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (num >= 100) {
            num = 1;
        }
        return num;
    }

    @Override
    public void init(CAEngineConfig engineConfig, ConfigStore config) throws EProfileException {
        super.init(engineConfig, config);
        this.refreshConfigAndValueNames();
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        int num = 0;
        if (name.equals(CONFIG_NUM_ADS)) {
            try {
                num = Integer.parseInt(value);
                if (num >= 100 || num < 0) {
                    throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_ADS}));
                }
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_ADS}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public Enumeration<String> getConfigNames() {
        this.refreshConfigAndValueNames();
        return super.getConfigNames();
    }

    @Override
    protected void refreshConfigAndValueNames() {
        super.refreshConfigAndValueNames();
        this.addValueName("subjInfoAccessCritical");
        this.addValueName(VAL_GENERAL_NAMES);
        this.addConfigName("subjInfoAccessCritical");
        int num = this.getNumAds();
        this.addConfigName(CONFIG_NUM_ADS);
        for (int i = 0; i < num; ++i) {
            this.addConfigName(CONFIG_AD_METHOD + i);
            this.addConfigName(CONFIG_AD_LOCATIONTYPE + i);
            this.addConfigName(CONFIG_AD_LOCATION + i);
            this.addConfigName(CONFIG_AD_ENABLE + i);
        }
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("subjInfoAccessCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_AD_METHOD)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_AD_METHOD", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_AD_LOCATIONTYPE)) {
            return new Descriptor("choice", "RFC822Name,DNSName,DirectoryName,EDIPartyName,URIName,IPAddress,OIDName", "URIName", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_AD_LOCATIONTYPE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_AD_LOCATION)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_AD_LOCATION", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_AD_ENABLE)) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_AD_ENABLE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_NUM_ADS)) {
            return new Descriptor("integer", null, "1", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NUM_ADS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("subjInfoAccessCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(VAL_GENERAL_NAMES)) {
            return new Descriptor("string_list", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_GENERAL_NAMES", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            SubjectInfoAccessExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            SubjectInfoAccessExtension a = new SubjectInfoAccessExtension(false);
            ObjectIdentifier oid = a.getExtensionId();
            ext = (SubjectInfoAccessExtension)this.getExtension(oid.toString(), info);
            if (ext == null) {
                this.populate(null, info);
            }
            if (name.equals("subjInfoAccessCritical")) {
                ext = (SubjectInfoAccessExtension)this.getExtension(oid.toString(), info);
                boolean val = Boolean.valueOf(value);
                if (ext == null) {
                    return;
                }
                ext.setCritical(val);
            } else if (name.equals(VAL_GENERAL_NAMES)) {
                ext = (SubjectInfoAccessExtension)this.getExtension(oid.toString(), info);
                if (ext == null) {
                    return;
                }
                boolean critical = ext.isCritical();
                Vector<NameValuePairs> v = this.parseRecords(value);
                int size = v.size();
                ext = new SubjectInfoAccessExtension(critical);
                String method = null;
                String locationType = null;
                String location = null;
                String enable = null;
                for (int i = 0; i < size; ++i) {
                    NameValuePairs nvps = v.elementAt(i);
                    for (String name1 : nvps.keySet()) {
                        if (name1.equals(AD_METHOD)) {
                            method = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (name1.equals(AD_LOCATION_TYPE)) {
                            locationType = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (name1.equals(AD_LOCATION)) {
                            location = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (!name1.equals(AD_ENABLE)) continue;
                        enable = (String)nvps.get((Object)name1);
                    }
                    if (enable == null || !enable.equals("true")) continue;
                    GeneralName gn = null;
                    if (locationType != null || location != null) {
                        GeneralNameInterface interface1 = this.parseGeneralName(locationType + ":" + location);
                        if (interface1 == null) {
                            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{locationType}));
                        }
                        gn = new GeneralName(interface1);
                    }
                    if (method == null) continue;
                    try {
                        ext.addAccessDescription(new ObjectIdentifier(method), gn);
                        continue;
                    }
                    catch (NumberFormatException ee) {
                        logger.error("SubjectInfoAccessExtDefault: " + ee.getMessage(), (Throwable)ee);
                        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_SIA_OID", (String[])new String[]{method}));
                    }
                }
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            this.replaceExtension(ext.getExtensionId().toString(), (Extension)ext, info);
        }
        catch (IOException e) {
            logger.error("SubjectInfoAccessExtDefault: " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        catch (EProfileException e) {
            logger.error("SubjectInfoAccessExtDefault: " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        SubjectInfoAccessExtension ext = null;
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        SubjectInfoAccessExtension a = new SubjectInfoAccessExtension(false);
        ObjectIdentifier oid = a.getExtensionId();
        ext = (SubjectInfoAccessExtension)this.getExtension(oid.toString(), info);
        if (ext == null) {
            try {
                this.populate(null, info);
            }
            catch (EProfileException e) {
                logger.error("SubjectInfoAccessExtDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("subjInfoAccessCritical")) {
            ext = (SubjectInfoAccessExtension)this.getExtension(oid.toString(), info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals(VAL_GENERAL_NAMES)) {
            ext = (SubjectInfoAccessExtension)this.getExtension(oid.toString(), info);
            if (ext == null) {
                return "";
            }
            int num = this.getNumAds();
            logger.debug("SubjectInfoAccess num=" + num);
            Vector<NameValuePairs> recs = new Vector<NameValuePairs>();
            for (int i = 0; i < num; ++i) {
                NameValuePairs np = new NameValuePairs();
                AccessDescription des = null;
                if (i < ext.numberOfAccessDescription()) {
                    des = ext.getAccessDescription(i);
                }
                if (des == null) {
                    np.put((Object)AD_METHOD, (Object)"");
                    np.put((Object)AD_LOCATION_TYPE, (Object)"");
                    np.put((Object)AD_LOCATION, (Object)"");
                    np.put((Object)AD_ENABLE, (Object)"false");
                } else {
                    ObjectIdentifier methodOid = des.getMethod();
                    GeneralName gn = des.getLocation();
                    np.put((Object)AD_METHOD, (Object)methodOid.toString());
                    np.put((Object)AD_LOCATION_TYPE, (Object)SubjectInfoAccessExtDefault.getGeneralNameType(gn));
                    np.put((Object)AD_LOCATION, (Object)SubjectInfoAccessExtDefault.getGeneralNameValue(gn));
                    np.put((Object)AD_ENABLE, (Object)"true");
                }
                recs.addElement(np);
            }
            return SubjectInfoAccessExtDefault.buildRecords(recs);
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        StringBuffer ads = new StringBuffer();
        int num = this.getNumAds();
        for (int i = 0; i < num; ++i) {
            ads.append("Record #");
            ads.append(i);
            ads.append("{");
            ads.append("Method:");
            ads.append(this.getConfig(CONFIG_AD_METHOD + i));
            ads.append(",");
            ads.append("Location Type:");
            ads.append(this.getConfig(CONFIG_AD_LOCATIONTYPE + i));
            ads.append(",");
            ads.append("Location:");
            ads.append(this.getConfig(CONFIG_AD_LOCATION + i));
            ads.append(",");
            ads.append("Enable:");
            ads.append(this.getConfig(CONFIG_AD_ENABLE + i));
            ads.append("}");
        }
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_SIA_TEXT", (String[])new String[]{this.getConfig("subjInfoAccessCritical"), ads.toString()});
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        SubjectInfoAccessExtension ext = this.createExtension();
        this.addExtension(ext.getExtensionId().toString(), (Extension)ext, info);
    }

    public SubjectInfoAccessExtension createExtension() {
        SubjectInfoAccessExtension ext = null;
        int num = this.getNumAds();
        try {
            boolean critical = this.getConfigBoolean("subjInfoAccessCritical");
            ext = new SubjectInfoAccessExtension(critical);
            for (int i = 0; i < num; ++i) {
                String s;
                GeneralNameInterface gn;
                Object location;
                String enable = this.getConfig(CONFIG_AD_ENABLE + i);
                if (enable == null || !enable.equals("true")) continue;
                logger.debug("SubjectInfoAccess: createExtension i=" + i);
                String method = this.getConfig(CONFIG_AD_METHOD + i);
                String locationType = this.getConfig(CONFIG_AD_LOCATIONTYPE + i);
                if (locationType == null || locationType.length() == 0) {
                    locationType = "URIName";
                }
                if (((location = this.getConfig(CONFIG_AD_LOCATION + i)) == null || ((String)location).equals("")) && method.equals("1.3.6.1.5.5.7.48.1")) {
                    CAEngine engine = CAEngine.getInstance();
                    CAEngineConfig cs = engine.getConfig();
                    String hostname = cs.getHostname();
                    String port = engine.getEENonSSLPort();
                    if (hostname != null && port != null) {
                        location = "http://" + hostname + ":" + port + "/ocsp";
                    }
                }
                if ((gn = this.parseGeneralName(s = locationType + ":" + (String)location)) == null) continue;
                ext.addAccessDescription(new ObjectIdentifier(method), new GeneralName(gn));
            }
        }
        catch (Exception e) {
            logger.warn("SubjectInfoAccessExtDefault: createExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }
}

