/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.ca.CMSCRLExtensions;
import com.netscape.ca.CRLConfig;
import com.netscape.ca.CRLExtensionConfig;
import com.netscape.ca.CRLExtensionsConfig;
import com.netscape.ca.CRLIssuingPoint;
import com.netscape.ca.CRLIssuingPointConfig;
import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.connector.ConnectorConfig;
import com.netscape.certsrv.connector.ConnectorsConfig;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cms.servlet.admin.AdminServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.logging.Auditor;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caca", urlPatterns={"/caadmin"}, initParams={@WebInitParam(name="ID", value="caca"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz")})
public class CAAdminServlet
extends AdminServlet {
    public static Logger logger = LoggerFactory.getLogger(CAAdminServlet.class);
    private static final long serialVersionUID = 6200983242040946840L;
    public static final String PROP_EMAIL_TEMPLATE = "emailTemplate";
    private static final String INFO = "CAAdminServlet";
    private CertificateAuthority mCA;
    protected static final String PROP_ENABLED = "enabled";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        CAEngine engine = CAEngine.getInstance();
        this.mCA = engine.getCA();
    }

    public String getServletInfo() {
        return INFO;
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
        String op = req.getParameter("OP_TYPE");
        String scope = req.getParameter("OP_SCOPE");
        if (op == null || scope == null) {
            this.sendResponse(1, "Invalid Protocol", null, resp);
            return;
        }
        super.authenticate(req);
        try {
            AUTHZ_RES_NAME = "certServer.ca.configuration";
            if (scope.equals("extendedPluginInfo")) {
                try {
                    this.mOp = "read";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                        return;
                    }
                    this.getExtendedPluginInfo(req, resp);
                    return;
                }
                catch (IOException e) {
                    this.sendResponse(ERROR, e.toString(), null, resp);
                }
            }
            if (op.equals("OP_READ")) {
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                    return;
                }
                if (scope.equals("general")) {
                    this.getGeneralConfig(resp);
                } else if (scope.equals("connector")) {
                    this.getConnectorConfig(req, resp);
                } else if (scope.equals("crlIPs")) {
                    this.getCRLIPsConfig(req, resp);
                } else if (scope.equals("crl")) {
                    this.getCRLConfig(req, resp);
                } else if (scope.equals("notificationREQC")) {
                    this.getNotificationReqCompConfig(req, resp);
                } else if (scope.equals("notificationREVC")) {
                    this.getNotificationRevCompConfig(req, resp);
                } else if (scope.equals("notificationRIQ")) {
                    this.getNotificationRIQConfig(req, resp);
                } else if (scope.equals("crlExtsRules")) {
                    this.getCRLExtsConfig(req, resp);
                }
            } else if (op.equals("OP_MODIFY")) {
                this.mOp = "modify";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                    return;
                }
                if (scope.equals("general")) {
                    this.setGeneralConfig(req, resp);
                } else if (scope.equals("connector")) {
                    this.setConnectorConfig(req, resp);
                } else if (scope.equals("crlIPs")) {
                    this.setCRLIPsConfig(req, resp);
                } else if (scope.equals("crl")) {
                    this.setCRLConfig(req, resp);
                } else if (scope.equals("notificationREQC")) {
                    this.setNotificationReqCompConfig(req, resp);
                } else if (scope.equals("notificationREVC")) {
                    this.setNotificationRevCompConfig(req, resp);
                } else if (scope.equals("notificationRIQ")) {
                    this.setNotificationRIQConfig(req, resp);
                } else if (scope.equals("crlExtsRules")) {
                    this.setCRLExtsConfig(req, resp);
                }
            } else if (op.equals("OP_SEARCH")) {
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                    return;
                }
                if (scope.equals("crlExtsRules")) {
                    this.listCRLExtsConfig(req, resp);
                } else if (scope.equals("crlIPs")) {
                    this.listCRLIPsConfig(resp);
                }
            } else if (op.equals("OP_ADD")) {
                this.mOp = "modify";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                    return;
                }
                if (scope.equals("crlIPs")) {
                    this.addCRLIPsConfig(req, resp);
                }
            } else if (op.equals("OP_DELETE")) {
                this.mOp = "modify";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                    return;
                }
                if (scope.equals("crlIPs")) {
                    this.deleteCRLIPsConfig(req, resp);
                }
            } else {
                this.sendResponse(1, "Unknown operation", null, resp);
            }
        }
        catch (Exception e) {
            this.sendResponse(1, e.toString(), null, resp);
            return;
        }
    }

    private void getNotificationCompConfig(HttpServletRequest req, HttpServletResponse resp, ConfigStore rc) throws IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE") || name.equals("enable")) continue;
            params.put((Object)name, (Object)rc.getString(name, ""));
        }
        params.put((Object)"enable", (Object)rc.getString(PROP_ENABLED, "false"));
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getNotificationRevCompConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CAConfig config = this.mCA.getConfigStore();
        ConfigStore nc = config.getSubStore("notification", ConfigStore.class);
        ConfigStore rc = nc.getSubStore("certRevoked", ConfigStore.class);
        this.getNotificationCompConfig(req, resp, rc);
    }

    private void getNotificationReqCompConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CAConfig config = this.mCA.getConfigStore();
        ConfigStore nc = config.getSubStore("notification", ConfigStore.class);
        ConfigStore rc = nc.getSubStore("certIssued", ConfigStore.class);
        this.getNotificationCompConfig(req, resp, rc);
    }

    private void getNotificationRIQConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        CAConfig config = this.mCA.getConfigStore();
        ConfigStore nc = config.getSubStore("notification", ConfigStore.class);
        ConfigStore riq = nc.getSubStore("requestInQ", ConfigStore.class);
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE") || name.equals("enable")) continue;
            params.put((Object)name, (Object)riq.getString(name, ""));
        }
        params.put((Object)"enable", (Object)riq.getString(PROP_ENABLED, "false"));
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void setNotificationRIQConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig engineConfig = engine.getConfig();
        CAConfig config = engineConfig.getCAConfig();
        ConfigStore nc = config.getSubStore("notification", ConfigStore.class);
        ConfigStore riq = nc.getSubStore("requestInQ", ConfigStore.class);
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            File template;
            String name = (String)e.nextElement();
            if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE") || name.equals("enable")) continue;
            String val = req.getParameter(name);
            if (name.equalsIgnoreCase(PROP_EMAIL_TEMPLATE) && (!(template = new File(val)).exists() || !template.canRead() || template.isDirectory())) {
                logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_INVALID_PATH", (Object[])new Object[0]));
                this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_INVALID_PATH", (String[])new String[0]), null, resp);
                return;
            }
            riq.putString(name, val);
            engine.getRequestInQueueListener().set(name, val);
        }
        String enabledString = req.getParameter("enable");
        riq.putString(PROP_ENABLED, enabledString);
        engine.getRequestInQueueListener().set(PROP_ENABLED, enabledString);
        this.commit(true);
        this.sendResponse(SUCCESS, null, null, resp);
    }

    private void setNotificationCompConfig(HttpServletRequest req, HttpServletResponse resp, ConfigStore rc, RequestListener thisListener) throws IOException, EBaseException {
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            File template;
            String name = (String)e.nextElement();
            if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE") || name.equals("enable")) continue;
            String val = req.getParameter(name);
            if (name.equalsIgnoreCase(PROP_EMAIL_TEMPLATE) && (!(template = new File(val)).exists() || !template.canRead() || template.isDirectory())) {
                logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_INVALID_PATH", (Object[])new Object[0]));
                this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_INVALID_PATH", (String[])new String[0]), null, resp);
                return;
            }
            rc.putString(name, val);
            thisListener.set(name, val);
        }
        String enabledString = req.getParameter("enable");
        rc.putString(PROP_ENABLED, enabledString);
        thisListener.set(PROP_ENABLED, enabledString);
        this.commit(true);
        this.sendResponse(SUCCESS, null, null, resp);
    }

    private void setNotificationRevCompConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig engineConfig = engine.getConfig();
        CAConfig config = engineConfig.getCAConfig();
        ConfigStore nc = config.getSubStore("notification", ConfigStore.class);
        ConfigStore rc = nc.getSubStore("certRevoked", ConfigStore.class);
        this.setNotificationCompConfig(req, resp, rc, engine.getCertRevokedListener());
    }

    private void setNotificationReqCompConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig engineConfig = engine.getConfig();
        CAConfig config = engineConfig.getCAConfig();
        ConfigStore nc = config.getSubStore("notification", ConfigStore.class);
        ConfigStore rc = nc.getSubStore("certIssued", ConfigStore.class);
        this.setNotificationCompConfig(req, resp, rc, engine.getCertIssuedListener());
    }

    private void listCRLIPsConfig(HttpServletResponse resp) throws IOException {
        NameValuePairs params = new NameValuePairs();
        CAEngine engine = CAEngine.getInstance();
        for (CRLIssuingPoint ip : engine.getCRLIssuingPoints()) {
            if (ip == null) continue;
            String ipId = ip.getId();
            if (ipId != null && ipId.length() > 0) {
                params.put((Object)ipId, (Object)ip.getDescription());
            }
            params.put((Object)(ipId + ".enable"), (Object)Boolean.valueOf(ip.isCRLIssuingPointEnabled()).toString());
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getCRLIPsConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        CRLIssuingPoint ip;
        CAEngine engine = CAEngine.getInstance();
        NameValuePairs params = new NameValuePairs();
        String id = req.getParameter("RS_ID");
        if (id != null && id.length() > 0 && (ip = engine.getCRLIssuingPoint(id)) != null) {
            Enumeration e = req.getParameterNames();
            String value = "";
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.equals("enable")) {
                    value = ip.isCRLIssuingPointEnabled() ? "true" : "false";
                }
                if (name.equals("id")) {
                    value = id;
                }
                if (name.equals("description")) {
                    value = ip.getDescription();
                }
                if (name.equals("class")) {
                    value = ip.getClass().getName();
                }
                params.put((Object)name, (Object)value);
            }
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void addCRLIPsConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            NameValuePairs params = new NameValuePairs();
            String ipId = req.getParameter("id");
            if (ipId == null || ipId.length() == 0) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, "Missing CRL IP name", null, resp);
                return;
            }
            params.put((Object)"id", (Object)ipId);
            String desc = req.getParameter("description");
            if (desc == null) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, "Missing CRL IP description", null, resp);
                return;
            }
            params.put((Object)"description", (Object)desc);
            String sEnable = req.getParameter("enable");
            boolean enable = true;
            if (sEnable != null && sEnable.length() > 0 && sEnable.equalsIgnoreCase("false")) {
                enable = false;
                params.put((Object)"enable", (Object)"false");
            } else {
                params.put((Object)"enable", (Object)"true");
            }
            CAConfig caConfig = this.mCA.getConfigStore();
            CRLConfig crlConfig = caConfig.getCRLConfig();
            Enumeration crlNames = crlConfig.getSubStoreNames().elements();
            while (crlNames.hasMoreElements()) {
                String name = (String)crlNames.nextElement();
                if (!ipId.equals(name)) continue;
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, ipId + " CRL IP already exists", null, resp);
                return;
            }
            if (!this.mCA.addCRLIssuingPoint(crlConfig, ipId, enable, desc)) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, "Cannot add or edit CRL IP", null, resp);
                return;
            }
            this.commit(true);
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, params, resp);
        }
        catch (EBaseException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit2;
        }
    }

    private void setCRLIPsConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            NameValuePairs params = new NameValuePairs();
            String ipId = req.getParameter("id");
            if (ipId == null || ipId.length() == 0) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, "Missing CRL IP name", null, resp);
                return;
            }
            params.put((Object)"id", (Object)ipId);
            String desc = req.getParameter("description");
            if (desc == null) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, "Missing CRL IP description", null, resp);
                return;
            }
            params.put((Object)"description", (Object)desc);
            String sEnable = req.getParameter("enable");
            boolean enable = true;
            if (sEnable != null && sEnable.length() > 0 && sEnable.equalsIgnoreCase("false")) {
                enable = false;
                params.put((Object)"enable", (Object)"false");
            } else {
                params.put((Object)"enable", (Object)"true");
            }
            CAConfig caConfig = this.mCA.getConfigStore();
            CRLConfig crlConfig = caConfig.getCRLConfig();
            boolean done = false;
            Enumeration crlNames = crlConfig.getSubStoreNames().elements();
            while (crlNames.hasMoreElements()) {
                CRLIssuingPointConfig ipConfig;
                String name = (String)crlNames.nextElement();
                if (!ipId.equals(name)) continue;
                CRLIssuingPoint ip = engine.getCRLIssuingPoint(ipId);
                if (ip != null) {
                    ip.setDescription(desc);
                    ip.enableCRLIssuingPoint(enable);
                }
                if ((ipConfig = crlConfig.getCRLIssuingPointConfig(ipId)) != null) {
                    ipConfig.putString("description", desc);
                    ipConfig.putString("enable", enable ? "true" : "false");
                }
                done = true;
                break;
            }
            if (!done) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                this.sendResponse(ERROR, "Missing CRL IP " + ipId, null, resp);
                return;
            }
            this.commit(true);
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, params, resp);
        }
        catch (EBaseException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit2;
        }
    }

    private void deleteCRLIPsConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            NameValuePairs params = new NameValuePairs();
            String id = req.getParameter("RS_ID");
            if (id != null && id.length() > 0) {
                CAConfig caConfig = this.mCA.getConfigStore();
                CRLConfig crlConfig = caConfig.getCRLConfig();
                boolean done = false;
                Enumeration crlNames = crlConfig.getSubStoreNames().elements();
                while (crlNames.hasMoreElements()) {
                    String name = (String)crlNames.nextElement();
                    if (!id.equals(name)) continue;
                    this.mCA.deleteCRLIssuingPoint(crlConfig, id);
                    done = true;
                    break;
                }
                if (!done) {
                    auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                    auditor.log(auditMessage);
                    this.sendResponse(ERROR, "Missing CRL IP " + id, null, resp);
                    return;
                }
                this.commit(true);
            }
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, params, resp);
        }
        catch (EBaseException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit2;
        }
    }

    private void getCRLExtsConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        CAEngine engine = CAEngine.getInstance();
        NameValuePairs params = new NameValuePairs();
        String ipId = null;
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE")) continue;
            ipId = name;
        }
        if (ipId == null || ipId.length() <= 0) {
            ipId = "MasterCRL";
        }
        CRLIssuingPoint ip = engine.getCRLIssuingPoint(ipId);
        CMSCRLExtensions crlExts = ip.getCRLExtensions();
        String id = req.getParameter("RS_ID");
        if (id != null) {
            params = crlExts.getConfigParams(id);
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void setCRLExtsConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            NameValuePairs params = new NameValuePairs();
            String ipId = req.getParameter("id");
            if (ipId == null || ipId.length() <= 0) {
                ipId = "MasterCRL";
            }
            CRLIssuingPoint ip = engine.getCRLIssuingPoint(ipId);
            CMSCRLExtensions crlExts = ip.getCRLExtensions();
            CAConfig caConfig = this.mCA.getConfigStore();
            CRLConfig crlConfig = caConfig.getCRLConfig();
            CRLIssuingPointConfig ipConfig = crlConfig.getCRLIssuingPointConfig(ipId);
            CRLExtensionsConfig crlExtsConfig = ipConfig.getExtensionsConfig();
            String id = req.getParameter("RS_ID");
            if (id != null) {
                CRLExtensionConfig crlExtSubStore = crlExtsConfig.getExtensionConfig(id);
                Enumeration e = req.getParameterNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE") || name.equals("implName") || name.equals("RULENAME")) continue;
                    String value = req.getParameter(name);
                    params.put((Object)name, (Object)value);
                }
                crlExts.setConfigParams(id, params, crlExtSubStore);
                this.commit(true);
                ip.clearCRLCache();
                ip.updateCRLCacheRepository();
            }
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, null, resp);
        }
        catch (EBaseException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit2;
        }
    }

    private void listCRLExtsConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CAConfig caConfig;
        CRLConfig crlConfig;
        CRLIssuingPointConfig ipConfig;
        CRLExtensionsConfig crlExtsConfig;
        NameValuePairs params = new NameValuePairs();
        String id = req.getParameter("id");
        if (id == null || id.length() <= 0) {
            id = "MasterCRL";
        }
        if ((crlExtsConfig = (ipConfig = (crlConfig = (caConfig = this.mCA.getConfigStore()).getCRLConfig()).getCRLIssuingPointConfig(id)).getExtensionsConfig()) != null) {
            Enumeration enumExts = crlExtsConfig.getSubStoreNames().elements();
            while (enumExts.hasMoreElements()) {
                String extName = (String)enumExts.nextElement();
                boolean crlExtEnabled = false;
                CRLExtensionConfig crlExtSubStore = crlExtsConfig.getExtensionConfig(extName);
                Enumeration properties = crlExtSubStore.getPropertyNames();
                while (properties.hasMoreElements()) {
                    String name = (String)properties.nextElement();
                    if (!name.equals("enable")) continue;
                    crlExtEnabled = crlExtSubStore.getBoolean(name, false);
                }
                params.put((Object)extName, (Object)(extName + ";visible;" + (crlExtEnabled ? PROP_ENABLED : "disabled")));
            }
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getExtendedPluginInfo(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String id = req.getParameter("RS_ID");
        int colon = id.indexOf(58);
        String implName = id.substring(colon + 1);
        NameValuePairs params = this.getExtendedPluginInfo(implName);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private NameValuePairs getExtendedPluginInfo(String implName) {
        CRLIssuingPoint ip;
        IExtendedPluginInfo ext_info = null;
        IExtendedPluginInfo impl = null;
        String ipId = null;
        String name = null;
        CAEngine engine = CAEngine.getInstance();
        Enumeration<CRLIssuingPoint> ips = Collections.enumeration(engine.getCRLIssuingPoints());
        if (ips.hasMoreElements() && (ip = ips.nextElement()) != null) {
            ipId = ip.getId();
        }
        if (ipId != null) {
            ip = engine.getCRLIssuingPoint(ipId);
            CMSCRLExtensions crlExts = ip.getCRLExtensions();
            name = crlExts.getClassPath(implName);
        }
        if (name != null) {
            impl = CAAdminServlet.getClassByNameAsExtendedPluginInfo(name);
        }
        if (impl != null && impl instanceof IExtendedPluginInfo) {
            ext_info = impl;
        }
        NameValuePairs nvps = null;
        nvps = ext_info == null ? new NameValuePairs() : this.convertStringArrayToNVPairs(ext_info.getExtendedPluginInfo());
        return nvps;
    }

    private void setCRLConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            NameValuePairs params = new NameValuePairs();
            String id = req.getParameter("RS_ID");
            if (id == null || id.length() <= 0 || id.equals("RS_ID_CONFIG")) {
                id = "MasterCRL";
            }
            CRLIssuingPoint ip = engine.getCRLIssuingPoint(id);
            CAConfig caConfig = this.mCA.getConfigStore();
            CRLConfig crlConfig = caConfig.getCRLConfig();
            CRLIssuingPointConfig ipConfig = crlConfig.getCRLIssuingPointConfig(id);
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE") || name.equals("enable")) continue;
                String value = req.getParameter(name);
                params.put((Object)name, (Object)value);
                ipConfig.putString(name, value);
            }
            boolean noRestart = ip.updateConfig(params);
            this.commit(true);
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            if (noRestart) {
                this.sendResponse(SUCCESS, null, null, resp);
            } else {
                this.sendResponse(RESTART, null, null, resp);
            }
        }
        catch (EBaseException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_CRL_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit2;
        }
    }

    private void getCRLConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        String id = req.getParameter("RS_ID");
        if (id == null || id.length() <= 0 || id.equals("RS_ID_CONFIG")) {
            id = "MasterCRL";
        }
        CAConfig caConfig = this.mCA.getConfigStore();
        CRLConfig crlConfig = caConfig.getCRLConfig();
        CRLIssuingPointConfig ipConfig = crlConfig.getCRLIssuingPointConfig(id);
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE") || name.equals("enable")) continue;
            params.put((Object)name, (Object)ipConfig.getString(name, ""));
        }
        this.getSigningAlgConfig(params);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getConnectorConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CAConfig caConfig = this.mCA.getConfigStore();
        ConnectorsConfig connectorsConfig = caConfig.getConnectorsConfig();
        ConnectorConfig caConnectorConfig = null;
        if (this.isKRAConnector(req)) {
            caConnectorConfig = connectorsConfig.getConnectorConfig("KRA");
        } else if (this.isCLAConnector(req)) {
            caConnectorConfig = connectorsConfig.getConnectorConfig("CLA");
        }
        Enumeration enum1 = req.getParameterNames();
        NameValuePairs params = new NameValuePairs();
        if (caConnectorConfig != null) {
            while (enum1.hasMoreElements()) {
                String name = (String)enum1.nextElement();
                if (name.equals("RS_ID") || name.equals("OP_SCOPE") || name.equals("OP_TYPE")) continue;
                params.put((Object)name, (Object)caConnectorConfig.getString(name, ""));
            }
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void setConnectorConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CAConfig caConfig = this.mCA.getConfigStore();
        ConnectorsConfig connectorsConfig = caConfig.getConnectorsConfig();
        ConnectorConfig caConnectorConfig = null;
        if (this.isKRAConnector(req)) {
            caConnectorConfig = connectorsConfig.getConnectorConfig("KRA");
        } else if (this.isCLAConnector(req)) {
            caConnectorConfig = connectorsConfig.getConnectorConfig("CLA");
        }
        Enumeration enum1 = req.getParameterNames();
        if (caConnectorConfig != null) {
            while (enum1.hasMoreElements()) {
                String name = (String)enum1.nextElement();
                if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE")) continue;
                if (name.equals("host")) {
                    try {
                        Utils.checkHost((String)req.getParameter("host"));
                    }
                    catch (UnknownHostException e) {
                        this.sendResponse(ERROR, "Unknown Host " + req.getParameter("host"), null, resp);
                        return;
                    }
                }
                caConnectorConfig.putString(name, req.getParameter(name));
            }
        }
        this.commit(true);
        this.sendResponse(RESTART, null, null, resp);
    }

    private boolean isKRAConnector(HttpServletRequest req) {
        Enumeration enum1 = req.getParameterNames();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            if (!key.equals("RS_ID")) continue;
            String val = req.getParameter(key);
            return val.equals("Data Recovery Manager Connector");
        }
        return false;
    }

    private boolean isCLAConnector(HttpServletRequest req) {
        Enumeration enum1 = req.getParameterNames();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            if (!key.equals("RS_ID")) continue;
            String val = req.getParameter(key);
            return val.equals("Clone Master Manager Connector");
        }
        return false;
    }

    private void getGeneralConfig(HttpServletResponse resp) throws IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        String value = "false";
        CAEngine engine = CAEngine.getInstance();
        DBSubsystem dbSubsystem = engine.getDBSubsystem();
        CertificateRepository cr = engine.getCertificateRepository();
        CAConfig caConfig = this.mCA.getConfigStore();
        value = caConfig.getString("enablePastCATime", "false");
        params.put((Object)"validity", (Object)value);
        this.getSigningAlgConfig(params);
        this.getSerialConfig(params);
        this.getMaxSerialConfig(params);
        params.put((Object)"serialNumberManagement", (Object)Boolean.toString(dbSubsystem.getEnableSerialMgmt()));
        params.put((Object)"randomSerialNumbers", (Object)Boolean.toString(cr.getEnableRandomSerialNumbers()));
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getSigningAlgConfig(NameValuePairs params) {
        params.put((Object)"defaultSigningAlgorithm", (Object)this.mCA.getDefaultAlgorithm());
        String[] algorithms = this.mCA.getCASigningAlgorithms();
        StringBuffer algorStr = new StringBuffer();
        for (int i = 0; i < algorithms.length; ++i) {
            if (i == 0) {
                algorStr.append(algorithms[i]);
                continue;
            }
            algorStr.append(":");
            algorStr.append(algorithms[i]);
        }
        params.put((Object)"allSigningAlgorithms", (Object)algorStr.toString());
    }

    private void getSerialConfig(NameValuePairs params) {
        CAEngine engine = CAEngine.getInstance();
        params.put((Object)"startSerialNumber", (Object)engine.getStartSerial());
    }

    private void getMaxSerialConfig(NameValuePairs params) {
        CAEngine engine = CAEngine.getInstance();
        params.put((Object)"maxSerialNumber", (Object)engine.getMaxSerial());
    }

    private void setGeneralConfig(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig engineConfig = engine.getConfig();
        CAConfig caConfig = engineConfig.getCAConfig();
        DBSubsystem dbSubsystem = engine.getDBSubsystem();
        CertificateRepository cr = engine.getCertificateRepository();
        Enumeration enum1 = req.getParameterNames();
        boolean restart = false;
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String value = req.getParameter(key);
            if (key.equals("eeEnabled")) continue;
            if (key.equals("validity")) {
                engine.setEnablePastCATime(value);
                caConfig.putString("enablePastCATime", value);
                continue;
            }
            if (key.equals("defaultSigningAlgorithm")) {
                this.mCA.setDefaultAlgorithm(value);
                continue;
            }
            if (key.equals("startSerialNumber")) {
                engine.setStartSerial(value);
                continue;
            }
            if (key.equals("maxSerialNumber")) {
                engine.setMaxSerial(value);
                continue;
            }
            if (key.equals("serialNumberManagement")) {
                dbSubsystem.setEnableSerialMgmt(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (!key.equals("randomSerialNumbers")) continue;
            cr.setEnableRandomSerialNumbers(Boolean.valueOf(value), true, false);
        }
        this.commit(true);
        if (restart) {
            this.sendResponse(RESTART, null, null, resp);
        } else {
            this.sendResponse(SUCCESS, null, null, resp);
        }
    }
}

