/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.admin.PolicyAdminServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import org.dogtagpki.server.ca.CAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="capolicy", urlPatterns={"/capolicy"}, initParams={@WebInitParam(name="ID", value="capolicy"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca")})
public class CAPolicyAdminServlet
extends PolicyAdminServlet {
    public static final Logger logger = LoggerFactory.getLogger(CAPolicyAdminServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        logger.debug("CAPolicyAdminServlet: In Policy Admin Servlet init");
        CAEngine engine = CAEngine.getInstance();
        String authority = config.getInitParameter("authority");
        CertificateAuthority ca = null;
        if (authority != null) {
            ca = (CertificateAuthority)engine.getSubsystem(authority);
        }
        if (ca == null) {
            throw new ServletException(authority + " does not have policy processor");
        }
        this.mProcessor = engine.getCAPolicy().getPolicyProcessor();
        String policyStatus = "ca.Policy.enable";
        try {
            if (this.mConfig.getBoolean(policyStatus, true)) {
                logger.debug("CAPolicyAdminServlet: Certificate Policy Framework (deprecated) is ENABLED");
            } else {
                logger.debug("CAPolicyAdminServlet: Certificate Policy Framework (deprecated) is DISABLED");
            }
        }
        catch (EBaseException e) {
            throw new ServletException(authority + " does not have a master policy switch called '" + policyStatus + "'");
        }
    }
}

