/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.ct;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmscore.cert.CertUtils;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.cmsutil.http.HttpClient;
import com.netscape.cmsutil.http.HttpRequest;
import com.netscape.cmsutil.http.HttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.net.ntp.TimeStamp;
import org.dogtagpki.ct.CTRequest;
import org.dogtagpki.ct.CTResponse;
import org.dogtagpki.ct.LogServer;
import org.dogtagpki.ct.sct.SCTProcessor;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTEngine {
    public static Logger logger = LoggerFactory.getLogger(CTEngine.class);
    SCTProcessor ctConfig = null;

    public void init() throws Exception {
        this.ctConfig = new SCTProcessor();
        this.ctConfig.init();
    }

    public void process(X509CertInfo certi, CertificateAuthority ctCA, AuthorityID aid, String algname) throws EBaseException {
        String method = "CTEngine.process: ";
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA(aid);
        Object errMsg = "";
        try {
            if (this.ctConfig == null) {
                this.init();
            }
            CertificateExtensions exts = (CertificateExtensions)certi.get("extensions");
            logger.debug(method + " about to check CT poison");
            Extension ctPoison = null;
            try {
                ctPoison = (Extension)exts.get("1.3.6.1.4.1.11129.2.4.3");
                logger.debug(method + " CT poison extension found");
            }
            catch (Exception e) {
                logger.debug(method + e.getMessage() + "-- continue");
                logger.debug(method + " CT poison extension not found");
            }
            boolean processCT = false;
            SCTProcessor.CTmode ct_mode = this.ctConfig.getCTmode();
            if (ct_mode == SCTProcessor.CTmode.enabled) {
                logger.debug(method + "ct_mode is enabled");
                if (ctPoison == null) {
                    logger.debug(method + " adding poison ext");
                    CertUtils.addCTv1PoisonExt((X509CertInfo)certi);
                    logger.debug(method + " returned from addCTpoisonExt");
                }
                processCT = true;
            } else if (ct_mode == SCTProcessor.CTmode.perProfile) {
                logger.debug(method + "ct_mode is perProfile");
                if (ctPoison != null) {
                    processCT = true;
                }
            } else if (ct_mode == SCTProcessor.CTmode.disabled) {
                logger.debug(method + "ct_mode is disabled");
                if (ctPoison != null) {
                    exts.delete("1.3.6.1.4.1.11129.2.4.3");
                    CertUtils.printExtensions((CertificateExtensions)exts);
                    certi.delete("extensions");
                    certi.set("extensions", (Object)exts);
                    logger.debug(method + " ctPoison ext deleted");
                }
            } else {
                errMsg = method + "unknown ct_mode: " + ct_mode;
                logger.error((String)errMsg);
                throw new EBaseException((String)errMsg);
            }
            if (!processCT) {
                logger.debug(method + " no CT processing needed");
                return;
            }
            logger.debug(method + " processing CT");
            CertUtils.printExtensions((CertificateExtensions)exts);
            logger.debug(method + " About to ca.sign CT pre-cert.");
            X509CertImpl cert = ca.sign(certi, algname);
            CTRequest ctRequest = this.createCTRequest(cert, ctCA);
            exts.delete("1.3.6.1.4.1.11129.2.4.3");
            logger.debug(method + " ctPoison deleted");
            CertUtils.printExtensions((CertificateExtensions)exts);
            certi.delete("extensions");
            certi.set("extensions", (Object)exts);
            byte[] tbsCert = certi.getEncodedInfo(true);
            List<LogServer> logServers = this.ctConfig.getLogServerConfig();
            ArrayList<String> ctResponses = new ArrayList<String>();
            for (LogServer ls : logServers) {
                logger.debug(method + "Processing log server ID: " + ls.getId());
                String ct_host = ls.getUrl().getHost();
                logger.debug(method + "Log server host: " + ct_host);
                int ct_port = ls.getUrl().getPort();
                logger.debug(method + "Log server port: " + ct_port);
                String ct_uri = ls.getUrl() + "ct/v1/add-pre-chain";
                logger.debug(method + "Log server URI: " + ct_uri);
                String respS = this.certTransSendReq(ct_host, ct_port, ct_uri, ctRequest);
                if (respS == null) {
                    errMsg = method + "Response from CT log server null";
                    logger.warn((String)errMsg);
                    continue;
                }
                logger.debug(method + "Response from CT log server " + respS);
                boolean allowFailedSCTVerification = true;
                CTResponse response = (CTResponse)JSONSerializer.fromJSON((String)respS, CTResponse.class);
                boolean verified = this.verifySCT(response, tbsCert, ls.getPublicKey(), ctCA);
                if (verified) {
                    logger.info(method + "verifySCT returned true; SCT is valid");
                } else {
                    logger.warn(method + "verifySCT returns false; SCT failed to verify");
                }
                if (verified || allowFailedSCTVerification) {
                    ctResponses.add(respS);
                    continue;
                }
                throw new EBaseException((String)errMsg);
            }
            Extension sctExt = this.createSCTextension(ctResponses);
            if (sctExt == null) {
                errMsg = " createSCTextension returns null";
                logger.debug(method + (String)errMsg);
                throw new EBaseException((String)errMsg);
            }
            exts.set(sctExt.getExtensionId().toString(), (Object)sctExt);
            certi.delete("extensions");
            certi.set("extensions", (Object)exts);
            CertUtils.printExtensions((CertificateExtensions)exts);
        }
        catch (Exception e) {
            logger.error(method + "Error occurred: " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e.getMessage());
        }
    }

    public static byte[] timeStampHexStringToByteArray(String timeStampString) {
        String method = "CTEngine.timeStampHexStringToByteArray: ";
        int len = timeStampString.length();
        logger.debug(method + "len =" + len);
        byte[] data = new byte[(len - 1) / 2];
        for (int i = 0; i < len; i += 2) {
            if (i == 8) {
                --i;
                continue;
            }
            data[i / 2] = (byte)((Character.digit(timeStampString.charAt(i), 16) << 4) + Character.digit(timeStampString.charAt(i + 1), 16));
        }
        return data;
    }

    Extension createSCTextension(List<String> ctResponses) {
        String method = "CTEngine.createSCTextension:";
        logger.debug(method + "begins");
        if (ctResponses.size() == 0) {
            logger.debug(method + "ctResponses size 0; returning null");
            return null;
        }
        boolean ct_sct_critical = false;
        ObjectIdentifier ct_sct_oid = new ObjectIdentifier("1.3.6.1.4.1.11129.2.4.2");
        try {
            int tls_len = 0;
            ByteArrayOutputStream sct_ostream = new ByteArrayOutputStream();
            for (int i = 0; i < ctResponses.size(); ++i) {
                CTResponse response = (CTResponse)JSONSerializer.fromJSON((String)ctResponses.get(i), CTResponse.class);
                byte[] ct_version = new byte[]{0};
                byte[] ct_id = CryptoUtil.base64Decode((String)response.getId());
                logger.debug(method + " ct_id: " + CertUtils.bytesToHex((byte[])ct_id));
                long timestamp_l = response.getTimestamp();
                TimeStamp timestamp_t = new TimeStamp(timestamp_l);
                String timestamp_s = timestamp_t.toString();
                logger.debug(method + " ct_timestamp: " + timestamp_s);
                byte[] ct_timestamp = CTEngine.timeStampHexStringToByteArray(timestamp_s);
                String extensions_s = response.getExtensions();
                if (extensions_s == null) {
                    extensions_s = "";
                }
                byte[] ct_extensions = CryptoUtil.base64Decode((String)extensions_s);
                byte[] ct_signature = CryptoUtil.base64Decode((String)response.getSignature());
                logger.debug(method + " ct_signature: " + CertUtils.bytesToHex((byte[])ct_signature));
                int sct_len = ct_version.length + ct_id.length + ct_timestamp.length + 2 + ct_extensions.length + ct_signature.length;
                logger.debug(method + " sct_len = " + sct_len);
                tls_len += 2 + sct_len;
                sct_ostream.write(CertUtils.intToFixedWidthBytes((int)sct_len, (int)2));
                sct_ostream.write(ct_version);
                sct_ostream.write(ct_id);
                sct_ostream.write(ct_timestamp);
                sct_ostream.write(CertUtils.intToFixedWidthBytes((int)ct_extensions.length, (int)2));
                sct_ostream.write(ct_extensions);
                sct_ostream.write(ct_signature);
            }
            ByteArrayOutputStream tls_sct_ostream = new ByteArrayOutputStream();
            tls_sct_ostream.write(CertUtils.intToFixedWidthBytes((int)tls_len, (int)2));
            sct_ostream.writeTo(tls_sct_ostream);
            byte[] tls_sct_bytes = tls_sct_ostream.toByteArray();
            Extension ct_sct_ext = new Extension();
            try (DerOutputStream out = new DerOutputStream();){
                out.putOctetString(tls_sct_bytes);
                ct_sct_ext.setExtensionId(ct_sct_oid);
                ct_sct_ext.setCritical(false);
                ct_sct_ext.setExtensionValue(out.toByteArray());
                logger.debug(method + " ct_sct_ext id = " + ct_sct_ext.getExtensionId().toString());
                logger.debug(method + " CT extension constructed");
            }
            catch (IOException e) {
                logger.debug(method + e.toString());
                return null;
            }
            catch (Exception e) {
                logger.debug(method + e.toString());
                return null;
            }
            return ct_sct_ext;
        }
        catch (Exception ex) {
            logger.debug(method + ex.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean verifySCT(CTResponse response, byte[] tbsCert, String logPublicKey, CertificateAuthority ctCA) {
        String method = "CTEngine.:verifySCT: ";
        String errMsg = "";
        logger.debug(method + "begins");
        try {
            long timestamp_l = response.getTimestamp();
            TimeStamp timestamp_t = new TimeStamp(timestamp_l);
            String timestamp_s = timestamp_t.toString();
            logger.debug(method + " ct_timestamp: " + timestamp_s);
            byte[] timestamp = CTEngine.timeStampHexStringToByteArray(timestamp_s);
            byte[] ct_signature = CryptoUtil.base64Decode((String)response.getSignature());
            byte[] signature = Arrays.copyOfRange(ct_signature, 4, ct_signature.length);
            String hashAlg = this.getHashAlgFromSig(ct_signature);
            if (hashAlg == null) {
                logger.debug(method + "invalid hashing algorithms");
                boolean bl = false;
                return bl;
            }
            String sigAlg = this.getSigAlgFromSig(ct_signature);
            if (sigAlg == null) {
                logger.debug(method + "invalid sig algorithms");
                boolean bl = false;
                return bl;
            }
            byte[] version = new byte[]{0};
            byte[] signature_type = new byte[]{0};
            byte[] entry_type = new byte[]{0, 1};
            logger.debug(method + "using CT log public key: " + logPublicKey);
            byte[] logPublicKey_b = CryptoUtil.base64Decode((String)logPublicKey);
            PublicKey log_pubKey = KeyFactory.getInstance("EC", "Mozilla-JSS").generatePublic(new X509EncodedKeySpec(logPublicKey_b));
            byte[] log_key_hash = null;
            MessageDigest SHA256Digest = MessageDigest.getInstance("SHA256");
            log_key_hash = SHA256Digest.digest(log_pubKey.getEncoded());
            String log_key_hash_s = CryptoUtil.base64Encode((byte[])log_key_hash);
            logger.debug(method + "CT log signer key hash: " + log_key_hash_s);
            if (log_key_hash_s.compareTo(response.getId()) != 0) {
                errMsg = "CT log signer key hash does not match key id!!";
                logger.error(method + errMsg);
                boolean bl = false;
                return bl;
            }
            logger.debug(method + "CT log signer key hash matches key id");
            X509CertImpl cacert = ctCA.getCACert();
            byte[] issuer_key = cacert.getPublicKey().getEncoded();
            byte[] issuer_key_hash = SHA256Digest.digest(issuer_key);
            String extensions_s = response.getExtensions();
            if (extensions_s == null) {
                extensions_s = "";
            }
            byte[] extensions = CryptoUtil.base64Decode((String)extensions_s);
            int data_len = version.length + signature_type.length + timestamp.length + entry_type.length + issuer_key_hash.length + 3 + tbsCert.length + 2 + extensions.length;
            logger.debug(method + " data_len = " + data_len);
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            ostream.write(version);
            ostream.write(signature_type);
            ostream.write(timestamp);
            ostream.write(entry_type);
            ostream.write(issuer_key_hash);
            ostream.write(CertUtils.intToFixedWidthBytes((int)tbsCert.length, (int)3));
            ostream.write(tbsCert);
            ostream.write(CertUtils.intToFixedWidthBytes((int)extensions.length, (int)2));
            ostream.write(extensions);
            byte[] data = ostream.toByteArray();
            logger.debug(method + "actual data len = " + data.length);
            Signature signer = Signature.getInstance(hashAlg + "with" + sigAlg, "Mozilla-JSS");
            signer.initVerify(log_pubKey);
            signer.update(data);
            boolean bl = signer.verify(signature);
            return bl;
        }
        catch (Throwable e) {
            logger.debug(method + "Exception thrown: " + e.toString(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            logger.debug(method + "ends");
        }
    }

    public String getHashAlgFromSig(byte[] ct_signature) {
        int hashingAlg = Byte.toUnsignedInt(ct_signature[0]);
        if (hashingAlg != 4) {
            return null;
        }
        return HashAlgorithm.values()[hashingAlg].name();
    }

    public String getSigAlgFromSig(byte[] ct_signature) {
        int signingAlg = Byte.toUnsignedInt(ct_signature[1]);
        if (signingAlg < 1 || signingAlg > 3) {
            return null;
        }
        return SignatureAlgorithm.values()[signingAlg].name();
    }

    CTRequest createCTRequest(X509CertImpl cert, CertificateAuthority ctCA) throws EBaseException {
        String method = "CTEngine.createCTRequest";
        CTRequest ctRequest = new CTRequest();
        ArrayList<String> certChain = new ArrayList<String>();
        ByteArrayOutputStream certOut = new ByteArrayOutputStream();
        CertificateChain caCertChain = ctCA.getCACertChain();
        X509Certificate[] caUnsortedCerts = caCertChain.getChain();
        try {
            cert.encode((OutputStream)certOut);
            byte[] certBytes = certOut.toByteArray();
            certOut.reset();
            certChain.add(Utils.base64encode((byte[])certBytes, (boolean)false));
            X509Certificate[] caSortedCerts = Cert.sortCertificateChain((X509Certificate[])caUnsortedCerts, (boolean)true);
            for (int n = 0; n < caSortedCerts.length; ++n) {
                X509CertImpl caCertInChain = (X509CertImpl)caSortedCerts[n];
                caCertInChain.encode((OutputStream)certOut);
                certBytes = certOut.toByteArray();
                certOut.reset();
                logger.debug(method + "caCertInChain " + n + " = " + Utils.base64encode((byte[])certBytes, (boolean)false));
                certChain.add(Utils.base64encode((byte[])certBytes, (boolean)false));
            }
            certOut.close();
            ctRequest.setCerts(certChain);
            logger.debug(method + " ct_json_request:" + ctRequest.toString());
        }
        catch (Exception e) {
            logger.debug(method + e.toString());
            throw new EBaseException(e.toString());
        }
        return ctRequest;
    }

    private String certTransSendReq(String ct_host, int ct_port, String ct_uri, CTRequest ctReq) {
        String method = "CTEngine.certTransSendReq: ";
        HttpClient client = new HttpClient();
        HttpRequest req = new HttpRequest();
        HttpResponse resp = null;
        logger.debug(method + "begins");
        try {
            client.connect(ct_host, ct_port);
            req.setMethod("POST");
            req.setURI(ct_uri);
            req.setHeader("Content-Type", "application/json");
            req.setContent(ctReq.toString());
            req.setHeader("Content-Length", Integer.toString(ctReq.toString().length()));
            resp = client.send(req);
            if (resp == null) {
                return null;
            }
            logger.debug("version " + resp.getHttpVers());
            logger.debug("status code " + resp.getStatusCode());
            logger.debug("reason " + resp.getReasonPhrase());
            logger.debug("content " + resp.getContent());
            logger.debug("CAService.certTransSendReq ends");
        }
        catch (Exception e) {
            logger.debug(method + e.toString());
            return null;
        }
        return resp.getContent();
    }

    static enum HashAlgorithm {
        none,
        MD5,
        SHA1,
        SHA224,
        SHA256,
        SHA384,
        SHA512;

    }

    static enum SignatureAlgorithm {
        anonymous,
        RSA,
        DSA,
        EC;

    }
}

