/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.config;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.config.ConfigCLI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.common.ConfigClient;
import org.dogtagpki.common.ConfigData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigExportCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ConfigExportCLI.class);
    public ConfigCLI configCLI;

    public ConfigExportCLI(ConfigCLI configCLI) {
        super("export", "Export configuration properties", (CLI)configCLI);
        this.configCLI = configCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] <type>", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "names", true, "Comma-separated list of configuration property names.");
        option.setArgName("names");
        this.options.addOption(option);
        option = new Option(null, "substores", true, "Comma-separated list of configuration property substores.");
        option.setArgName("substores");
        this.options.addOption(option);
        option = new Option(null, "session", true, "Session ID");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "install-token", true, "Install token");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "output-format", true, "Output format: text (default), json");
        option.setArgName("format");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String installToken = cmd.getOptionValue("install-token");
        String sessionID = installToken != null ? new String(Files.readAllBytes(Paths.get(installToken, new String[0]))) : cmd.getOptionValue("session");
        if (sessionID == null) {
            throw new Exception("Missing session ID or install token");
        }
        String names = cmd.getOptionValue("names", "");
        String substores = cmd.getOptionValue("substores", "");
        String outputFormat = cmd.getOptionValue("output-format", "text");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ConfigClient configClient = this.configCLI.getConfigClient();
        ConfigData config = configClient.getConfig(names, substores, sessionID);
        if ("json".equalsIgnoreCase(outputFormat)) {
            System.out.println(config.toJSON());
        } else {
            Map properties = config.getProperties();
            for (String name : properties.keySet()) {
                String value = (String)properties.get(name);
                System.out.println(name + ": " + value);
            }
        }
    }
}

