/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.nss;

import com.netscape.certsrv.client.ClientConfig;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.nss.NSSCertCLI;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.PublicKey;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.codec.binary.Hex;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.nss.NSSDatabase;
import org.dogtagpki.nss.NSSExtensionGenerator;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.x509.Extensions;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSCertRequestCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(NSSCertRequestCLI.class);

    public NSSCertRequestCLI(NSSCertCLI nssCertCLI) {
        super("request", "Generate certificate signing request", (CLI)nssCertCLI);
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "subject", true, "Subject name");
        option.setArgName("name");
        this.options.addOption(option);
        option = new Option(null, "key-id", true, "Key ID");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "key-type", true, "Key type: RSA (default), EC");
        option.setArgName("type");
        this.options.addOption(option);
        option = new Option(null, "key-size", true, "RSA key size (default: 2048)");
        option.setArgName("size");
        this.options.addOption(option);
        this.options.addOption(null, "key-wrap", false, "Generate RSA key for wrapping/unwrapping.");
        option = new Option(null, "curve", true, "Elliptic curve name (default: nistp256)");
        option.setArgName("name");
        this.options.addOption(option);
        this.options.addOption(null, "ssl-ecdh", false, "Generate EC key for SSL with ECDH ECDSA.");
        option = new Option(null, "hash", true, "Hash algorithm (default: SHA256)");
        option.setArgName("name");
        this.options.addOption(option);
        option = new Option(null, "ext", true, "Certificate extensions configuration");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "subjectAltName", true, "Subject alternative name");
        option.setArgName("value");
        this.options.addOption(option);
        option = new Option(null, "csr", true, "Certificate signing request");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "format", true, "Certificate signing request format: PEM (default), DER");
        option.setArgName("format");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        byte[] bytes;
        KeyPair keyPair;
        String subject = cmd.getOptionValue("subject");
        Object keyID = cmd.getOptionValue("key-id");
        String keyType = cmd.getOptionValue("key-type", "RSA");
        String keySize = cmd.getOptionValue("key-size", "2048");
        boolean keyWrap = cmd.hasOption("key-wrap");
        String curve = cmd.getOptionValue("curve", "nistp256");
        boolean sslECDH = cmd.hasOption("ssl-ecdh");
        String hash = cmd.getOptionValue("hash", "SHA256");
        String extConf = cmd.getOptionValue("ext");
        String subjectAltName = cmd.getOptionValue("subjectAltName");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ClientConfig clientConfig = mainCLI.getConfig();
        NSSDatabase nssdb = mainCLI.getNSSDatabase();
        String tokenName = clientConfig.getTokenName();
        CryptoToken token = CryptoUtil.getKeyStorageToken((String)tokenName);
        if (keyID != null) {
            if (((String)keyID).startsWith("0x")) {
                keyID = ((String)keyID).substring(2);
            }
            if (((String)keyID).length() % 2 == 1) {
                keyID = "0" + (String)keyID;
            }
            keyPair = nssdb.loadKeyPair(token, Hex.decodeHex((String)keyID));
        } else if ("RSA".equalsIgnoreCase(keyType)) {
            usages = keyWrap ? CryptoUtil.RSA_KEYPAIR_USAGES : null;
            usagesMask = keyWrap ? CryptoUtil.RSA_KEYPAIR_USAGES_MASK : null;
            keyPair = nssdb.createRSAKeyPair(token, Integer.parseInt(keySize), usages, usagesMask);
        } else if ("EC".equalsIgnoreCase(keyType)) {
            usages = null;
            usagesMask = sslECDH ? CryptoUtil.ECDH_USAGES_MASK : CryptoUtil.ECDHE_USAGES_MASK;
            keyPair = nssdb.createECKeyPair(token, curve, usages, usagesMask);
        } else {
            throw new Exception("Unsupported key type: " + keyType);
        }
        NSSExtensionGenerator generator = new NSSExtensionGenerator();
        Extensions extensions = null;
        if (extConf != null) {
            generator.init(extConf);
        }
        if (subjectAltName != null) {
            generator.setParameter("subjectAltName", subjectAltName);
        }
        X509Key subjectKey = CryptoUtil.createX509Key((PublicKey)keyPair.getPublic());
        extensions = generator.createExtensions(subjectKey);
        PK11PrivKey privateKey = (PK11PrivKey)keyPair.getPrivate();
        String keyAlgorithm = hash + "with" + privateKey.getType();
        PKCS10 pkcs10 = nssdb.createPKCS10Request(keyPair, subject, keyAlgorithm, extensions);
        String format = cmd.getOptionValue("format");
        if (format == null || "PEM".equalsIgnoreCase(format)) {
            bytes = CertUtil.toPEM((PKCS10)pkcs10).getBytes();
        } else if ("DER".equalsIgnoreCase(format)) {
            bytes = pkcs10.toByteArray();
        } else {
            throw new Exception("Unsupported format: " + format);
        }
        String filename = cmd.getOptionValue("csr");
        if (filename != null) {
            Files.write(Paths.get(filename, new String[0]), bytes, new OpenOption[0]);
        } else {
            System.out.write(bytes);
        }
    }
}

