/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.authenticator;

import com.netscape.certsrv.tps.authenticator.AuthenticatorClient;
import com.netscape.certsrv.tps.authenticator.AuthenticatorData;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.authenticator.AuthenticatorCLI;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatorModifyCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(AuthenticatorModifyCLI.class);
    public AuthenticatorCLI authenticatorCLI;

    public AuthenticatorModifyCLI(AuthenticatorCLI authenticatorCLI) {
        super("mod", "Modify authenticator", (CLI)authenticatorCLI);
        this.authenticatorCLI = authenticatorCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Authenticator ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "action", true, "Action: update (default), approve, reject, enable, disable.");
        option.setArgName("action");
        this.options.addOption(option);
        option = new Option(null, "input", true, "Input file containing authenticator properties.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        AuthenticatorData authenticatorData;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No Authenticator ID specified.");
        }
        String authenticatorID = cmdArgs[0];
        String action = cmd.getOptionValue("action", "update");
        String input = cmd.getOptionValue("input");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        AuthenticatorClient authenticatorClient = this.authenticatorCLI.getAuthenticatorClient();
        if (action.equals("update")) {
            if (input == null) {
                throw new Exception("Missing input file");
            }
            try (BufferedReader in = new BufferedReader(new FileReader(input));
                 StringWriter sw = new StringWriter();
                 PrintWriter out = new PrintWriter((Writer)sw, true);){
                String line;
                while ((line = in.readLine()) != null) {
                    out.println(line);
                }
                authenticatorData = (AuthenticatorData)JSONSerializer.fromJSON((String)sw.toString(), AuthenticatorData.class);
            }
            authenticatorData = authenticatorClient.updateAuthenticator(authenticatorID, authenticatorData);
        } else {
            authenticatorData = authenticatorClient.changeAuthenticatorStatus(authenticatorID, action);
        }
        MainCLI.printMessage("Modified authenticator \"" + authenticatorID + "\"");
        AuthenticatorCLI.printAuthenticatorData(authenticatorData, true);
    }
}

