/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.jobs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.notification.ENotificationException;
import com.netscape.cms.notification.MailNotification;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.jobs.JobConfig;
import com.netscape.cmscore.jobs.JobCron;
import com.netscape.cmscore.jobs.JobsScheduler;
import com.netscape.cmscore.notification.EmailTemplate;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Hashtable;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Job
implements Runnable {
    public static final Logger logger = LoggerFactory.getLogger(Job.class);
    protected static final String PROP_SUMMARY = "summary";
    protected static final String PROP_ENABLED = "enabled";
    protected static final String PROP_EMAIL_SUBJECT = "emailSubject";
    protected static final String PROP_EMAIL_TEMPLATE = "emailTemplate";
    protected static final String PROP_ITEM_TEMPLATE = "itemTemplate";
    protected static final String PROP_SENDER_EMAIL = "senderEmail";
    protected static final String PROP_RECEIVER_EMAIL = "recipientEmail";
    protected static final String STATUS_FAILURE = "failed";
    protected static final String STATUS_SUCCESS = "succeeded";
    protected CMSEngine engine;
    protected String mImplName = null;
    protected JobConfig mConfig;
    protected String mId = null;
    protected String mCron = null;
    protected JobCron mJobCron;
    protected static String[] mConfigParams = null;
    protected String mSummaryMailSubject = null;
    protected boolean mMailHTML = false;
    protected String mMailForm = null;
    protected String mItemForm = null;
    protected String mSummarySenderEmail = null;
    protected String mSummaryReceiverEmail = null;
    protected Hashtable<String, Object> mContentParams = new Hashtable();
    protected Hashtable<String, Object> mItemParams = new Hashtable();
    boolean stopped;

    protected Job() {
    }

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public abstract String[] getConfigParams();

    public boolean isEnabled() {
        boolean enabled = false;
        try {
            enabled = this.mConfig.isEnabled();
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        return enabled;
    }

    public void init(JobsScheduler scheduler, String id, String implName, JobConfig config) throws EBaseException {
        logger.info("Job: Initializing job {}", (Object)id);
        this.mId = id;
        this.mImplName = implName;
        logger.info("Job: - plugin: {}", (Object)implName);
        this.mConfig = config;
        this.mCron = config.getCron();
        logger.info("Job: - cron: {}", (Object)this.mCron);
        if (this.mCron != null) {
            this.mJobCron = scheduler.createJobCron(this.mCron);
        }
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String id) {
        this.mId = id;
    }

    public JobCron getJobCron() {
        return this.mJobCron;
    }

    public String getImplName() {
        return this.mImplName;
    }

    public JobConfig getConfigStore() {
        return this.mConfig;
    }

    protected String getTemplateContent(String templatePath) {
        String templateString = null;
        EmailTemplate template = new EmailTemplate(templatePath);
        if (!template.init()) {
            logger.warn("Job: {}", (Object)CMS.getLogMessage("JOBS_TEMPLATE_INIT_ERROR", new Object[0]));
            return null;
        }
        if (template.isHTML()) {
            this.mMailHTML = true;
        }
        templateString = template.toString();
        return templateString;
    }

    protected void mailSummary(String content) {
        logger.info("Job: Sending email to {}", (Object)this.mSummaryReceiverEmail);
        MailNotification mn = this.engine.getMailNotification();
        mn.setFrom(this.mSummarySenderEmail);
        mn.setTo(this.mSummaryReceiverEmail);
        mn.setSubject(this.mSummaryMailSubject);
        if (this.mMailHTML) {
            mn.setContentType("text/html");
        }
        mn.setContent(content);
        try {
            mn.sendNotification();
        }
        catch (ENotificationException | IOException e) {
            logger.warn("Job: {}", (Object)CMS.getLogMessage("JOBS_SEND_NOTIFICATION", e.toString()), (Object)e);
        }
    }

    protected void buildItemParams(X509CertImpl cert) {
        this.mItemParams.put("SerialNumber", cert.getSerialNumber().toString());
        this.mItemParams.put("HexSerialNumber", cert.getSerialNumber().toString(16));
        this.mItemParams.put("IssuerDN", cert.getIssuerName().toString());
        this.mItemParams.put("SubjectDN", cert.getSubjectName().toString());
        this.mItemParams.put("NotAfter", cert.getNotAfter().toString());
        this.mItemParams.put("NotBefore", cert.getNotBefore().toString());
    }

    protected void buildItemParams(Request r) {
        String rt;
        String ct;
        String re = r.getExtDataInString("HTTP_PARAMS", "csrRequestorEmail");
        if (re != null) {
            this.mItemParams.put("RequestorEmail", re);
        }
        if ((ct = r.getExtDataInString("HTTP_PARAMS", "certType")) != null) {
            this.mItemParams.put("CertType", ct);
        }
        if ((rt = r.getExtDataInString("requestType")) != null) {
            this.mItemParams.put("RequestType", rt);
        }
    }

    protected void buildItemParams(String name, String val) {
        if (val == null) {
            logger.debug("Job: buildItemParams: null value for name={}", (Object)name);
            val = "";
        }
        this.mContentParams.put(name, val);
    }

    protected void buildContentParams(String name, String val) {
        if (val == null) {
            logger.debug("Job: buildContentParams: null value for name={}", (Object)name);
            val = "";
        }
        this.mContentParams.put(name, val);
    }

    public void stop() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

