/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.apps;

import com.netscape.certsrv.base.PKIException;
import com.netscape.cms.realm.PKIRealm;
import com.netscape.cms.tomcat.ProxyRealm;
import com.netscape.cmscore.apps.CMSEngine;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.catalina.Realm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PKIWebListener
implements ServletContextListener {
    public static final Logger logger = LoggerFactory.getLogger(PKIWebListener.class);

    public abstract CMSEngine createEngine();

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        String path = servletContext.getContextPath();
        String id = "".equals(path) ? "ROOT" : path.substring(1);
        CMSEngine engine = this.createEngine();
        engine.setID(id);
        servletContext.setAttribute("engine", (Object)engine);
        String name = engine.getName();
        try {
            engine.start();
        }
        catch (Exception e) {
            logger.error("Unable to start " + name + " engine: " + e.getMessage(), (Throwable)e);
            engine.shutdown();
            throw new PKIException("Unable to start " + name + " engine: " + e.getMessage(), (Throwable)e);
        }
        PKIRealm realm = new PKIRealm();
        realm.setCMSEngine(engine);
        ProxyRealm.registerRealm((String)id, (Realm)realm);
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        CMSEngine engine = (CMSEngine)servletContext.getAttribute("engine");
        engine.shutdown();
    }
}

