/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.core.policy;

import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IExpression;
import org.dogtagpki.legacy.policy.IPolicyRule;
import org.dogtagpki.legacy.policy.IPolicySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicySet
implements IPolicySet {
    public static Logger logger = LoggerFactory.getLogger(PolicySet.class);
    private String mName;
    private Vector<String> mRuleNames = new Vector();
    private Vector<IPolicyRule> mRules = new Vector();

    public PolicySet(String name) {
        this.mName = name;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public int count() {
        return this.mRules.size();
    }

    @Override
    public void addRule(String ruleName, IPolicyRule rule) {
        if (this.mRuleNames.indexOf(ruleName) >= 0) {
            return;
        }
        if (ruleName != null && rule != null) {
            this.mRuleNames.addElement(ruleName);
            this.mRules.addElement(rule);
        }
    }

    public void replaceRule(String ruleName, IPolicyRule rule) {
        int index = this.mRuleNames.indexOf(ruleName);
        if (index < 0) {
            this.addRule(ruleName, rule);
            return;
        }
        this.mRuleNames.setElementAt(ruleName, index);
        this.mRules.setElementAt(rule, index);
    }

    @Override
    public void removeRule(String ruleName) {
        int index = this.mRuleNames.indexOf(ruleName);
        if (index < 0) {
            return;
        }
        this.mRuleNames.removeElementAt(index);
        this.mRules.removeElementAt(index);
    }

    @Override
    public IPolicyRule getRule(String ruleName) {
        int index = this.mRuleNames.indexOf(ruleName);
        if (index < 0) {
            return null;
        }
        return this.mRules.elementAt(index);
    }

    @Override
    public Enumeration<IPolicyRule> getRules() {
        return this.mRules.elements();
    }

    @Override
    public PolicyResult apply(Request req) {
        if (this.mRules.size() == 0) {
            return PolicyResult.ACCEPTED;
        }
        boolean rejected = false;
        boolean deferred = false;
        int size = this.mRules.size();
        for (int index = 0; index < size; ++index) {
            String name = this.mRuleNames.elementAt(index);
            IPolicyRule rule = this.mRules.elementAt(index);
            IExpression exp = rule.getPredicate();
            try {
                logger.debug("evaluating predicate for rule " + rule.getName());
                logger.debug("PolicySet: apply()- evaluating predicate for rule " + rule.getName());
                if (exp != null && !exp.evaluate(req)) {
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.typeMatched(rule, req)) continue;
            try {
                logger.debug("Policy " + name + " selected");
                logger.debug("Policy " + name + " selected");
                PolicyResult result = rule.apply(req);
                logger.debug("Policy applied");
                logger.debug("Policy " + name + " returned " + result);
                if (result == PolicyResult.REJECTED) {
                    logger.warn(CMS.getLogMessage("CMSCORE_POLICY_REJECT_RESULT", req.getRequestId().toString(), name));
                    rejected = true;
                    continue;
                }
                if (result == PolicyResult.DEFERRED) {
                    logger.warn(CMS.getLogMessage("CMSCORE_POLICY_DEFER_RESULT", req.getRequestId().toString(), name));
                    deferred = true;
                    continue;
                }
                if (result == PolicyResult.ACCEPTED) continue;
                logger.warn("policy: Request " + req.getRequestId() + " - Result of applying rule: " + name + " is: " + this.getPolicyResult(result));
                continue;
            }
            catch (Throwable ex) {
                logger.warn(CMS.getLogMessage("CMSCORE_POLICY_ERROR_RESULT", req.getRequestId().toString(), name, ex.toString()), ex);
                rejected = true;
                rule.setError(req, CMS.getUserMessage("CMS_POLICY_UNEXPECTED_POLICY_ERROR", rule.getName(), ex.toString()), null);
            }
        }
        if (rejected) {
            return PolicyResult.REJECTED;
        }
        if (deferred) {
            return PolicyResult.DEFERRED;
        }
        logger.info("Request " + req.getRequestId() + " Policy result: successful");
        return PolicyResult.ACCEPTED;
    }

    public void printPolicies() {
        if (this.mRules.size() == 0) {
            return;
        }
        System.out.println("Policy Set Name: " + this.mName);
        System.out.println();
        int size = this.mRules.size();
        for (int index = 0; index < size; ++index) {
            String ruleName = this.mRuleNames.elementAt(index);
            System.out.println("Rule Name: " + ruleName);
            System.out.println("Implementation: " + this.mRules.elementAt(index).getClass().getName());
        }
    }

    String getPolicyResult(PolicyResult res) {
        if (res == PolicyResult.ACCEPTED) {
            return "accepted";
        }
        if (res == PolicyResult.DEFERRED) {
            return "deferred";
        }
        if (res == PolicyResult.REJECTED) {
            return "rejected";
        }
        return "unknown";
    }

    boolean typeMatched(IPolicyRule rule, Request req) {
        if (req.getExtDataInCertInfoArray("CERT_INFO") != null) {
            return true;
        }
        return req.getExtDataInCertArray("OLD_CERTS") != null;
    }
}

