/*
 * Unix SMB/CIFS implementation.
 *
 * HRESULT Error definitions
 *
 * Copyright (C) Noel Power <noel.power@suse.com> 2014
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "includes.h"
#include "hresult.h"
/*
 * The following error codes and descriptions are autogenerated from [MS-ERREF]
 * see http://msdn.microsoft.com/en-us/library/cc704587.aspx
 */

static const struct {
	HRESULT error_code;
	const char *error_str;
	const char *error_message;
} hresult_errs[] = {
	{
		HRES_STG_S_CONVERTED,
		"HRES_STG_S_CONVERTED",
		"The underlying file was converted to compound file format."
	},
	{
		HRES_STG_S_BLOCK,
		"HRES_STG_S_BLOCK",
		"The storage operation should block until more data is available."
	},
	{
		HRES_STG_S_RETRYNOW,
		"HRES_STG_S_RETRYNOW",
		"The storage operation should retry immediately."
	},
	{
		HRES_STG_S_MONITORING,
		"HRES_STG_S_MONITORING",
		"The notified event sink will not influence the storage operation."
	},
	{
		HRES_STG_S_MULTIPLEOPENS,
		"HRES_STG_S_MULTIPLEOPENS",
		"Multiple opens prevent consolidated (commit succeeded)."
	},
	{
		HRES_STG_S_CONSOLIDATIONFAILED,
		"HRES_STG_S_CONSOLIDATIONFAILED",
		"Consolidation of the storage file failed (commit succeeded)."
	},
	{
		HRES_STG_S_CANNOTCONSOLIDATE,
		"HRES_STG_S_CANNOTCONSOLIDATE",
		"Consolidation of the storage file is inappropriate (commit succeeded)."
	},
	{
		HRES_OLE_S_USEREG,
		"HRES_OLE_S_USEREG",
		"Use the registry database to provide the requested information."
	},
	{
		HRES_OLE_S_STATIC,
		"HRES_OLE_S_STATIC",
		"Success, but static."
	},
	{
		HRES_OLE_S_MAC_CLIPFORMAT,
		"HRES_OLE_S_MAC_CLIPFORMAT",
		"Macintosh clipboard format."
	},
	{
		HRES_DRAGDROP_S_DROP,
		"HRES_DRAGDROP_S_DROP",
		"Successful drop took place."
	},
	{
		HRES_DRAGDROP_S_CANCEL,
		"HRES_DRAGDROP_S_CANCEL",
		"Drag-drop operation canceled."
	},
	{
		HRES_DRAGDROP_S_USEDEFAULTCURSORS,
		"HRES_DRAGDROP_S_USEDEFAULTCURSORS",
		"Use the default cursor."
	},
	{
		HRES_DATA_S_SAMEFORMATETC,
		"HRES_DATA_S_SAMEFORMATETC",
		"Data has same FORMATETC."
	},
	{
		HRES_VIEW_S_ALREADY_FROZEN,
		"HRES_VIEW_S_ALREADY_FROZEN",
		"View is already frozen."
	},
	{
		HRES_CACHE_S_FORMATETC_NOTSUPPORTED,
		"HRES_CACHE_S_FORMATETC_NOTSUPPORTED",
		"FORMATETC not supported."
	},
	{
		HRES_CACHE_S_SAMECACHE,
		"HRES_CACHE_S_SAMECACHE",
		"Same cache."
	},
	{
		HRES_CACHE_S_SOMECACHES_NOTUPDATED,
		"HRES_CACHE_S_SOMECACHES_NOTUPDATED",
		"Some caches are not updated."
	},
	{
		HRES_OLEOBJ_S_INVALIDVERB,
		"HRES_OLEOBJ_S_INVALIDVERB",
		"Invalid verb for OLE object."
	},
	{
		HRES_OLEOBJ_S_CANNOT_DOVERB_NOW,
		"HRES_OLEOBJ_S_CANNOT_DOVERB_NOW",
		"Verb number is valid but verb cannot be done now."
	},
	{
		HRES_OLEOBJ_S_INVALIDHWND,
		"HRES_OLEOBJ_S_INVALIDHWND",
		"Invalid window handle passed."
	},
	{
		HRES_INPLACE_S_TRUNCATED,
		"HRES_INPLACE_S_TRUNCATED",
		"Message is too long; some of it had to be truncated before displaying."
	},
	{
		HRES_CONVERT10_S_NO_PRESENTATION,
		"HRES_CONVERT10_S_NO_PRESENTATION",
		"Unable to convert OLESTREAM to IStorage."
	},
	{
		HRES_MK_S_REDUCED_TO_SELF,
		"HRES_MK_S_REDUCED_TO_SELF",
		"Moniker reduced to itself."
	},
	{
		HRES_MK_S_ME,
		"HRES_MK_S_ME",
		"Common prefix is this moniker."
	},
	{
		HRES_MK_S_HIM,
		"HRES_MK_S_HIM",
		"Common prefix is input moniker."
	},
	{
		HRES_MK_S_US,
		"HRES_MK_S_US",
		"Common prefix is both monikers."
	},
	{
		HRES_MK_S_MONIKERALREADYREGISTERED,
		"HRES_MK_S_MONIKERALREADYREGISTERED",
		"Moniker is already registered in running object table."
	},
	{
		HRES_EVENT_S_SOME_SUBSCRIBERS_FAILED,
		"HRES_EVENT_S_SOME_SUBSCRIBERS_FAILED",
		"An event was able to invoke some, but not all, of the subscribers."
	},
	{
		HRES_EVENT_S_NOSUBSCRIBERS,
		"HRES_EVENT_S_NOSUBSCRIBERS",
		"An event was delivered, but there were no subscribers."
	},
	{
		HRES_SCHED_S_TASK_READY,
		"HRES_SCHED_S_TASK_READY",
		"The task is ready to run at its next scheduled time."
	},
	{
		HRES_SCHED_S_TASK_RUNNING,
		"HRES_SCHED_S_TASK_RUNNING",
		"The task is currently running."
	},
	{
		HRES_SCHED_S_TASK_DISABLED,
		"HRES_SCHED_S_TASK_DISABLED",
		"The task will not run at the scheduled times because it has been disabled."
	},
	{
		HRES_SCHED_S_TASK_HAS_NOT_RUN,
		"HRES_SCHED_S_TASK_HAS_NOT_RUN",
		"The task has not yet run."
	},
	{
		HRES_SCHED_S_TASK_NO_MORE_RUNS,
		"HRES_SCHED_S_TASK_NO_MORE_RUNS",
		"There are no more runs scheduled for this task."
	},
	{
		HRES_SCHED_S_TASK_NOT_SCHEDULED,
		"HRES_SCHED_S_TASK_NOT_SCHEDULED",
		"One or more of the properties that are needed to run this task on a schedule have not been set."
	},
	{
		HRES_SCHED_S_TASK_TERMINATED,
		"HRES_SCHED_S_TASK_TERMINATED",
		"The last run of the task was terminated by the user."
	},
	{
		HRES_SCHED_S_TASK_NO_VALID_TRIGGERS,
		"HRES_SCHED_S_TASK_NO_VALID_TRIGGERS",
		"Either the task has no triggers, or the existing triggers are disabled or not set."
	},
	{
		HRES_SCHED_S_EVENT_TRIGGER,
		"HRES_SCHED_S_EVENT_TRIGGER",
		"Event triggers do not have set run times."
	},
	{
		HRES_SCHED_S_SOME_TRIGGERS_FAILED,
		"HRES_SCHED_S_SOME_TRIGGERS_FAILED",
		"The task is registered, but not all specified triggers will start the task."
	},
	{
		HRES_SCHED_S_BATCH_LOGON_PROBLEM,
		"HRES_SCHED_S_BATCH_LOGON_PROBLEM",
		"The task is registered, but it might fail to start. Batch logon privilege needs to be enabled for the task principal."
	},
	{
		HRES_XACT_S_ASYNC,
		"HRES_XACT_S_ASYNC",
		"An asynchronous operation was specified. The operation has begun, but its outcome is not known yet."
	},
	{
		HRES_XACT_S_READONLY,
		"HRES_XACT_S_READONLY",
		"The method call succeeded because the transaction was read-only."
	},
	{
		HRES_XACT_S_SOMENORETAIN,
		"HRES_XACT_S_SOMENORETAIN",
		"The transaction was successfully aborted. However, this is a coordinated transaction, and a number of enlisted resources were aborted outright because they could not support abort-retaining semantics."
	},
	{
		HRES_XACT_S_OKINFORM,
		"HRES_XACT_S_OKINFORM",
		"No changes were made during this call, but the sink wants another chance to look if any other sinks make further changes."
	},
	{
		HRES_XACT_S_MADECHANGESCONTENT,
		"HRES_XACT_S_MADECHANGESCONTENT",
		"The sink is content and wants the transaction to proceed. Changes were made to one or more resources during this call."
	},
	{
		HRES_XACT_S_MADECHANGESINFORM,
		"HRES_XACT_S_MADECHANGESINFORM",
		"The sink is for the moment and wants the transaction to proceed, but if other changes are made following this return by other event sinks, this sink wants another chance to look."
	},
	{
		HRES_XACT_S_ALLNORETAIN,
		"HRES_XACT_S_ALLNORETAIN",
		"The transaction was successfully aborted. However, the abort was nonretaining."
	},
	{
		HRES_XACT_S_ABORTING,
		"HRES_XACT_S_ABORTING",
		"An abort operation was already in progress."
	},
	{
		HRES_XACT_S_SINGLEPHASE,
		"HRES_XACT_S_SINGLEPHASE",
		"The resource manager has performed a single-phase commit of the transaction."
	},
	{
		HRES_XACT_S_LOCALLY_OK,
		"HRES_XACT_S_LOCALLY_OK",
		"The local transaction has not aborted."
	},
	{
		HRES_XACT_S_LASTRESOURCEMANAGER,
		"HRES_XACT_S_LASTRESOURCEMANAGER",
		"The resource manager has requested to be the coordinator (last resource manager) for the transaction."
	},
	{
		HRES_CO_S_NOTALLINTERFACES,
		"HRES_CO_S_NOTALLINTERFACES",
		"Not all the requested interfaces were available."
	},
	{
		HRES_CO_S_MACHINENAMENOTFOUND,
		"HRES_CO_S_MACHINENAMENOTFOUND",
		"The specified machine name was not found in the cache."
	},
	{
		HRES_SEC_I_CONTINUE_NEEDED,
		"HRES_SEC_I_CONTINUE_NEEDED",
		"The function completed successfully, but it must be called again to complete the context."
	},
	{
		HRES_SEC_I_COMPLETE_NEEDED,
		"HRES_SEC_I_COMPLETE_NEEDED",
		"The function completed successfully, but CompleteToken must be called."
	},
	{
		HRES_SEC_I_COMPLETE_AND_CONTINUE,
		"HRES_SEC_I_COMPLETE_AND_CONTINUE",
		"The function completed successfully, but both CompleteToken and this function must be called to complete the context."
	},
	{
		HRES_SEC_I_LOCAL_LOGON,
		"HRES_SEC_I_LOCAL_LOGON",
		"The logon was completed, but no network authority was available. The logon was made using locally known information."
	},
	{
		HRES_SEC_I_CONTEXT_EXPIRED,
		"HRES_SEC_I_CONTEXT_EXPIRED",
		"The context has expired and can no longer be used."
	},
	{
		HRES_SEC_I_INCOMPLETE_CREDENTIALS,
		"HRES_SEC_I_INCOMPLETE_CREDENTIALS",
		"The credentials supplied were not complete and could not be verified. Additional information can be returned from the context."
	},
	{
		HRES_SEC_I_RENEGOTIATE,
		"HRES_SEC_I_RENEGOTIATE",
		"The context data must be renegotiated with the peer."
	},
	{
		HRES_SEC_I_NO_LSA_CONTEXT,
		"HRES_SEC_I_NO_LSA_CONTEXT",
		"There is no LSA mode context associated with this context."
	},
	{
		HRES_SEC_I_SIGNATURE_NEEDED,
		"HRES_SEC_I_SIGNATURE_NEEDED",
		"A signature operation must be performed before the user can authenticate."
	},
	{
		HRES_CRYPT_I_NEW_PROTECTION_REQUIRED,
		"HRES_CRYPT_I_NEW_PROTECTION_REQUIRED",
		"The protected data needs to be reprotected."
	},
	{
		HRES_NS_S_CALLPENDING,
		"HRES_NS_S_CALLPENDING",
		"The requested operation is pending completion."
	},
	{
		HRES_NS_S_CALLABORTED,
		"HRES_NS_S_CALLABORTED",
		"The requested operation was aborted by the client."
	},
	{
		HRES_NS_S_STREAM_TRUNCATED,
		"HRES_NS_S_STREAM_TRUNCATED",
		"The stream was purposefully stopped before completion."
	},
	{
		HRES_NS_S_REBUFFERING,
		"HRES_NS_S_REBUFFERING",
		"The requested operation has caused the source to rebuffer."
	},
	{
		HRES_NS_S_DEGRADING_QUALITY,
		"HRES_NS_S_DEGRADING_QUALITY",
		"The requested operation has caused the source to degrade codec quality."
	},
	{
		HRES_NS_S_TRANSCRYPTOR_EOF,
		"HRES_NS_S_TRANSCRYPTOR_EOF",
		"The transcryptor object has reached end of file."
	},
	{
		HRES_NS_S_WMP_UI_VERSIONMISMATCH,
		"HRES_NS_S_WMP_UI_VERSIONMISMATCH",
		"An upgrade is needed for the theme manager to correctly show this skin. Skin reports version: %.1f."
	},
	{
		HRES_NS_S_WMP_EXCEPTION,
		"HRES_NS_S_WMP_EXCEPTION",
		"An error occurred in one of the UI components."
	},
	{
		HRES_NS_S_WMP_LOADED_GIF_IMAGE,
		"HRES_NS_S_WMP_LOADED_GIF_IMAGE",
		"Successfully loaded a GIF file."
	},
	{
		HRES_NS_S_WMP_LOADED_PNG_IMAGE,
		"HRES_NS_S_WMP_LOADED_PNG_IMAGE",
		"Successfully loaded a PNG file."
	},
	{
		HRES_NS_S_WMP_LOADED_BMP_IMAGE,
		"HRES_NS_S_WMP_LOADED_BMP_IMAGE",
		"Successfully loaded a BMP file."
	},
	{
		HRES_NS_S_WMP_LOADED_JPG_IMAGE,
		"HRES_NS_S_WMP_LOADED_JPG_IMAGE",
		"Successfully loaded a JPG file."
	},
	{
		HRES_NS_S_WMG_FORCE_DROP_FRAME,
		"HRES_NS_S_WMG_FORCE_DROP_FRAME",
		"Drop this frame."
	},
	{
		HRES_NS_S_WMR_ALREADYRENDERED,
		"HRES_NS_S_WMR_ALREADYRENDERED",
		"The specified stream has already been rendered."
	},
	{
		HRES_NS_S_WMR_PINTYPEPARTIALMATCH,
		"HRES_NS_S_WMR_PINTYPEPARTIALMATCH",
		"The specified type partially matches this pin type."
	},
	{
		HRES_NS_S_WMR_PINTYPEFULLMATCH,
		"HRES_NS_S_WMR_PINTYPEFULLMATCH",
		"The specified type fully matches this pin type."
	},
	{
		HRES_NS_S_WMG_ADVISE_DROP_FRAME,
		"HRES_NS_S_WMG_ADVISE_DROP_FRAME",
		"The timestamp is late compared to the current render position. Advise dropping this frame."
	},
	{
		HRES_NS_S_WMG_ADVISE_DROP_TO_KEYFRAME,
		"HRES_NS_S_WMG_ADVISE_DROP_TO_KEYFRAME",
		"The timestamp is severely late compared to the current render position. Advise dropping everything up to the next key frame."
	},
	{
		HRES_NS_S_NEED_TO_BUY_BURN_RIGHTS,
		"HRES_NS_S_NEED_TO_BUY_BURN_RIGHTS",
		"No burn rights. You will be prompted to buy burn rights when you try to burn this file to an audio CD."
	},
	{
		HRES_NS_S_WMPCORE_PLAYLISTCLEARABORT,
		"HRES_NS_S_WMPCORE_PLAYLISTCLEARABORT",
		"Failed to clear playlist because it was aborted by user."
	},
	{
		HRES_NS_S_WMPCORE_PLAYLISTREMOVEITEMABORT,
		"HRES_NS_S_WMPCORE_PLAYLISTREMOVEITEMABORT",
		"Failed to remove item in the playlist since it was aborted by user."
	},
	{
		HRES_NS_S_WMPCORE_PLAYLIST_CREATION_PENDING,
		"HRES_NS_S_WMPCORE_PLAYLIST_CREATION_PENDING",
		"Playlist is being generated asynchronously."
	},
	{
		HRES_NS_S_WMPCORE_MEDIA_VALIDATION_PENDING,
		"HRES_NS_S_WMPCORE_MEDIA_VALIDATION_PENDING",
		"Validation of the media is pending."
	},
	{
		HRES_NS_S_WMPCORE_PLAYLIST_REPEAT_SECONDARY_SEGMENTS_IGNORED,
		"HRES_NS_S_WMPCORE_PLAYLIST_REPEAT_SECONDARY_SEGMENTS_IGNORED",
		"Encountered more than one Repeat block during ASX processing."
	},
	{
		HRES_NS_S_WMPCORE_COMMAND_NOT_AVAILABLE,
		"HRES_NS_S_WMPCORE_COMMAND_NOT_AVAILABLE",
		"Current state of WMP disallows calling this method or property."
	},
	{
		HRES_NS_S_WMPCORE_PLAYLIST_NAME_AUTO_GENERATED,
		"HRES_NS_S_WMPCORE_PLAYLIST_NAME_AUTO_GENERATED",
		"Name for the playlist has been auto generated."
	},
	{
		HRES_NS_S_WMPCORE_PLAYLIST_IMPORT_MISSING_ITEMS,
		"HRES_NS_S_WMPCORE_PLAYLIST_IMPORT_MISSING_ITEMS",
		"The imported playlist does not contain all items from the original."
	},
	{
		HRES_NS_S_WMPCORE_PLAYLIST_COLLAPSED_TO_SINGLE_MEDIA,
		"HRES_NS_S_WMPCORE_PLAYLIST_COLLAPSED_TO_SINGLE_MEDIA",
		"The M3U playlist has been ignored because it only contains one item."
	},
	{
		HRES_NS_S_WMPCORE_MEDIA_CHILD_PLAYLIST_OPEN_PENDING,
		"HRES_NS_S_WMPCORE_MEDIA_CHILD_PLAYLIST_OPEN_PENDING",
		"The open for the child playlist associated with this media is pending."
	},
	{
		HRES_NS_S_WMPCORE_MORE_NODES_AVAIABLE,
		"HRES_NS_S_WMPCORE_MORE_NODES_AVAIABLE",
		"More nodes support the interface requested, but the array for returning them is full."
	},
	{
		HRES_NS_S_WMPBR_SUCCESS,
		"HRES_NS_S_WMPBR_SUCCESS",
		"Backup or Restore successful!."
	},
	{
		HRES_NS_S_WMPBR_PARTIALSUCCESS,
		"HRES_NS_S_WMPBR_PARTIALSUCCESS",
		"Transfer complete with limitations."
	},
	{
		HRES_NS_S_WMPEFFECT_TRANSPARENT,
		"HRES_NS_S_WMPEFFECT_TRANSPARENT",
		"Request to the effects control to change transparency status to transparent."
	},
	{
		HRES_NS_S_WMPEFFECT_OPAQUE,
		"HRES_NS_S_WMPEFFECT_OPAQUE",
		"Request to the effects control to change transparency status to opaque."
	},
	{
		HRES_NS_S_OPERATION_PENDING,
		"HRES_NS_S_OPERATION_PENDING",
		"The requested application pane is performing an operation and will not be released."
	},
	{
		HRES_NS_S_TRACK_BUY_REQUIRES_ALBUM_PURCHASE,
		"HRES_NS_S_TRACK_BUY_REQUIRES_ALBUM_PURCHASE",
		"The file is only available for purchase when you buy the entire album."
	},
	{
		HRES_NS_S_NAVIGATION_COMPLETE_WITH_ERRORS,
		"HRES_NS_S_NAVIGATION_COMPLETE_WITH_ERRORS",
		"There were problems completing the requested navigation. There are identifiers missing in the catalog."
	},
	{
		HRES_NS_S_TRACK_ALREADY_DOWNLOADED,
		"HRES_NS_S_TRACK_ALREADY_DOWNLOADED",
		"Track already downloaded."
	},
	{
		HRES_NS_S_PUBLISHING_POINT_STARTED_WITH_FAILED_SINKS,
		"HRES_NS_S_PUBLISHING_POINT_STARTED_WITH_FAILED_SINKS",
		"The publishing point successfully started, but one or more of the requested data writer plug-ins failed."
	},
	{
		HRES_NS_S_DRM_LICENSE_ACQUIRED,
		"HRES_NS_S_DRM_LICENSE_ACQUIRED",
		"Status message: The license was acquired."
	},
	{
		HRES_NS_S_DRM_INDIVIDUALIZED,
		"HRES_NS_S_DRM_INDIVIDUALIZED",
		"Status message: The security upgrade has been completed."
	},
	{
		HRES_NS_S_DRM_MONITOR_CANCELLED,
		"HRES_NS_S_DRM_MONITOR_CANCELLED",
		"Status message: License monitoring has been canceled."
	},
	{
		HRES_NS_S_DRM_ACQUIRE_CANCELLED,
		"HRES_NS_S_DRM_ACQUIRE_CANCELLED",
		"Status message: License acquisition has been canceled."
	},
	{
		HRES_NS_S_DRM_BURNABLE_TRACK,
		"HRES_NS_S_DRM_BURNABLE_TRACK",
		"The track is burnable and had no playlist burn limit."
	},
	{
		HRES_NS_S_DRM_BURNABLE_TRACK_WITH_PLAYLIST_RESTRICTION,
		"HRES_NS_S_DRM_BURNABLE_TRACK_WITH_PLAYLIST_RESTRICTION",
		"The track is burnable but has a playlist burn limit."
	},
	{
		HRES_NS_S_DRM_NEEDS_INDIVIDUALIZATION,
		"HRES_NS_S_DRM_NEEDS_INDIVIDUALIZATION",
		"A security upgrade is required to perform the operation on this media file."
	},
	{
		HRES_NS_S_REBOOT_RECOMMENDED,
		"HRES_NS_S_REBOOT_RECOMMENDED",
		"Installation was successful; however, some file cleanup is not complete. For best results, restart your computer."
	},
	{
		HRES_NS_S_REBOOT_REQUIRED,
		"HRES_NS_S_REBOOT_REQUIRED",
		"Installation was successful; however, some file cleanup is not complete. To continue, you must restart your computer."
	},
	{
		HRES_NS_S_EOSRECEDING,
		"HRES_NS_S_EOSRECEDING",
		"EOS hit during rewinding."
	},
	{
		HRES_NS_S_CHANGENOTICE,
		"HRES_NS_S_CHANGENOTICE",
		"Internal."
	},
	{
		HRES_ERROR_FLT_IO_COMPLETE,
		"HRES_ERROR_FLT_IO_COMPLETE",
		"The IO was completed by a filter."
	},
	{
		HRES_ERROR_GRAPHICS_MODE_NOT_PINNED,
		"HRES_ERROR_GRAPHICS_MODE_NOT_PINNED",
		"No mode is pinned on the specified VidPN source or target."
	},
	{
		HRES_ERROR_GRAPHICS_NO_PREFERRED_MODE,
		"HRES_ERROR_GRAPHICS_NO_PREFERRED_MODE",
		"Specified mode set does not specify preference for one of its modes."
	},
	{
		HRES_ERROR_GRAPHICS_DATASET_IS_EMPTY,
		"HRES_ERROR_GRAPHICS_DATASET_IS_EMPTY",
		"Specified data set (for example, mode set, frequency range set, descriptor set, and topology) is empty."
	},
	{
		HRES_ERROR_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET,
		"HRES_ERROR_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET",
		"Specified data set (for example, mode set, frequency range set, descriptor set, and topology) does not contain any more elements."
	},
	{
		HRES_ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED,
		"HRES_ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED",
		"Specified content transformation is not pinned on the specified VidPN present path."
	},
	{
		HRES_PLA_S_PROPERTY_IGNORED,
		"HRES_PLA_S_PROPERTY_IGNORED",
		"Property value will be ignored."
	},
	{
		HRES_ERROR_NDIS_INDICATION_REQUIRED,
		"HRES_ERROR_NDIS_INDICATION_REQUIRED",
		"The request will be completed later by a Network Driver Interface Specification (NDIS) status indication."
	},
	{
		HRES_TRK_S_OUT_OF_SYNC,
		"HRES_TRK_S_OUT_OF_SYNC",
		"The VolumeSequenceNumber of a MOVE_NOTIFICATION request is incorrect."
	},
	{
		HRES_TRK_VOLUME_NOT_FOUND,
		"HRES_TRK_VOLUME_NOT_FOUND",
		"The VolumeID in a request was not found in the server's ServerVolumeTable."
	},
	{
		HRES_TRK_VOLUME_NOT_OWNED,
		"HRES_TRK_VOLUME_NOT_OWNED",
		"A notification was sent to the LnkSvrMessage method, but the RequestMachine for the request was not the VolumeOwner for a VolumeID in the request."
	},
	{
		HRES_TRK_S_NOTIFICATION_QUOTA_EXCEEDED,
		"HRES_TRK_S_NOTIFICATION_QUOTA_EXCEEDED",
		"The server received a MOVE_NOTIFICATION request, but the FileTable size limit has already been reached."
	},
	{
		HRES_NS_I_TIGER_START,
		"HRES_NS_I_TIGER_START",
		"The Title Server %1 is running."
	},
	{
		HRES_NS_I_CUB_START,
		"HRES_NS_I_CUB_START",
		"Content Server %1 (%2) is starting."
	},
	{
		HRES_NS_I_CUB_RUNNING,
		"HRES_NS_I_CUB_RUNNING",
		"Content Server %1 (%2) is running."
	},
	{
		HRES_NS_I_DISK_START,
		"HRES_NS_I_DISK_START",
		"Disk %1 ( %2 ) on Content Server %3, is running."
	},
	{
		HRES_NS_I_DISK_REBUILD_STARTED,
		"HRES_NS_I_DISK_REBUILD_STARTED",
		"Started rebuilding disk %1 ( %2 ) on Content Server %3."
	},
	{
		HRES_NS_I_DISK_REBUILD_FINISHED,
		"HRES_NS_I_DISK_REBUILD_FINISHED",
		"Finished rebuilding disk %1 ( %2 ) on Content Server %3."
	},
	{
		HRES_NS_I_DISK_REBUILD_ABORTED,
		"HRES_NS_I_DISK_REBUILD_ABORTED",
		"Aborted rebuilding disk %1 ( %2 ) on Content Server %3."
	},
	{
		HRES_NS_I_LIMIT_FUNNELS,
		"HRES_NS_I_LIMIT_FUNNELS",
		"A NetShow administrator at network location %1 set the data stream limit to %2 streams."
	},
	{
		HRES_NS_I_START_DISK,
		"HRES_NS_I_START_DISK",
		"A NetShow administrator at network location %1 started disk %2."
	},
	{
		HRES_NS_I_STOP_DISK,
		"HRES_NS_I_STOP_DISK",
		"A NetShow administrator at network location %1 stopped disk %2."
	},
	{
		HRES_NS_I_STOP_CUB,
		"HRES_NS_I_STOP_CUB",
		"A NetShow administrator at network location %1 stopped Content Server %2."
	},
	{
		HRES_NS_I_KILL_USERSESSION,
		"HRES_NS_I_KILL_USERSESSION",
		"A NetShow administrator at network location %1 aborted user session %2 from the system."
	},
	{
		HRES_NS_I_KILL_CONNECTION,
		"HRES_NS_I_KILL_CONNECTION",
		"A NetShow administrator at network location %1 aborted obsolete connection %2 from the system."
	},
	{
		HRES_NS_I_REBUILD_DISK,
		"HRES_NS_I_REBUILD_DISK",
		"A NetShow administrator at network location %1 started rebuilding disk %2."
	},
	{
		HRES_MCMADM_I_NO_EVENTS,
		"HRES_MCMADM_I_NO_EVENTS",
		"Event initialization failed, there will be no MCM events."
	},
	{
		HRES_NS_I_LOGGING_FAILED,
		"HRES_NS_I_LOGGING_FAILED",
		"The logging operation failed."
	},
	{
		HRES_NS_I_LIMIT_BANDWIDTH,
		"HRES_NS_I_LIMIT_BANDWIDTH",
		"A NetShow administrator at network location %1 set the maximum bandwidth limit to %2 bps."
	},
	{
		HRES_NS_I_CUB_UNFAIL_LINK,
		"HRES_NS_I_CUB_UNFAIL_LINK",
		"Content Server %1 (%2) has established its link to Content Server %3."
	},
	{
		HRES_NS_I_RESTRIPE_START,
		"HRES_NS_I_RESTRIPE_START",
		"Restripe operation has started."
	},
	{
		HRES_NS_I_RESTRIPE_DONE,
		"HRES_NS_I_RESTRIPE_DONE",
		"Restripe operation has completed."
	},
	{
		HRES_NS_I_RESTRIPE_DISK_OUT,
		"HRES_NS_I_RESTRIPE_DISK_OUT",
		"Content disk %1 (%2) on Content Server %3 has been restriped out."
	},
	{
		HRES_NS_I_RESTRIPE_CUB_OUT,
		"HRES_NS_I_RESTRIPE_CUB_OUT",
		"Content server %1 (%2) has been restriped out."
	},
	{
		HRES_NS_I_DISK_STOP,
		"HRES_NS_I_DISK_STOP",
		"Disk %1 ( %2 ) on Content Server %3, has been offlined."
	},
	{
		HRES_NS_I_PLAYLIST_CHANGE_RECEDING,
		"HRES_NS_I_PLAYLIST_CHANGE_RECEDING",
		"The playlist change occurred while receding."
	},
	{
		HRES_NS_I_RECONNECTED,
		"HRES_NS_I_RECONNECTED",
		"The client is reconnected."
	},
	{
		HRES_NS_I_NOLOG_STOP,
		"HRES_NS_I_NOLOG_STOP",
		"Forcing a switch to a pending header on start."
	},
	{
		HRES_NS_I_EXISTING_PACKETIZER,
		"HRES_NS_I_EXISTING_PACKETIZER",
		"There is already an existing packetizer plugin for the stream."
	},
	{
		HRES_NS_I_MANUAL_PROXY,
		"HRES_NS_I_MANUAL_PROXY",
		"The proxy setting is manual."
	},
	{
		HRES_ERROR_GRAPHICS_DRIVER_MISMATCH,
		"HRES_ERROR_GRAPHICS_DRIVER_MISMATCH",
		"The kernel driver detected a version mismatch between it and the user mode driver."
	},
	{
		HRES_ERROR_GRAPHICS_UNKNOWN_CHILD_STATUS,
		"HRES_ERROR_GRAPHICS_UNKNOWN_CHILD_STATUS",
		"Child device presence was not reliably detected."
	},
	{
		HRES_ERROR_GRAPHICS_LEADLINK_START_DEFERRED,
		"HRES_ERROR_GRAPHICS_LEADLINK_START_DEFERRED",
		"Starting the lead-link adapter has been deferred temporarily."
	},
	{
		HRES_ERROR_GRAPHICS_POLLING_TOO_FREQUENTLY,
		"HRES_ERROR_GRAPHICS_POLLING_TOO_FREQUENTLY",
		"The display adapter is being polled for children too frequently at the same polling level."
	},
	{
		HRES_ERROR_GRAPHICS_START_DEFERRED,
		"HRES_ERROR_GRAPHICS_START_DEFERRED",
		"Starting the adapter has been deferred temporarily."
	},
	{
		HRES_E_PENDING,
		"HRES_E_PENDING",
		"The data necessary to complete this operation is not yet available."
	},
	{
		HRES_E_NOTIMPL,
		"HRES_E_NOTIMPL",
		"Not implemented."
	},
	{
		HRES_E_NOINTERFACE,
		"HRES_E_NOINTERFACE",
		"No such interface supported."
	},
	{
		HRES_E_POINTER,
		"HRES_E_POINTER",
		"Invalid pointer."
	},
	{
		HRES_E_ABORT,
		"HRES_E_ABORT",
		"Operation aborted."
	},
	{
		HRES_E_FAIL,
		"HRES_E_FAIL",
		"Unspecified error."
	},
	{
		HRES_CO_E_INIT_TLS,
		"HRES_CO_E_INIT_TLS",
		"Thread local storage failure."
	},
	{
		HRES_CO_E_INIT_SHARED_ALLOCATOR,
		"HRES_CO_E_INIT_SHARED_ALLOCATOR",
		"Get shared memory allocator failure."
	},
	{
		HRES_CO_E_INIT_MEMORY_ALLOCATOR,
		"HRES_CO_E_INIT_MEMORY_ALLOCATOR",
		"Get memory allocator failure."
	},
	{
		HRES_CO_E_INIT_CLASS_CACHE,
		"HRES_CO_E_INIT_CLASS_CACHE",
		"Unable to initialize class cache."
	},
	{
		HRES_CO_E_INIT_RPC_CHANNEL,
		"HRES_CO_E_INIT_RPC_CHANNEL",
		"Unable to initialize remote procedure call (RPC) services."
	},
	{
		HRES_CO_E_INIT_TLS_SET_CHANNEL_CONTROL,
		"HRES_CO_E_INIT_TLS_SET_CHANNEL_CONTROL",
		"Cannot set thread local storage channel control."
	},
	{
		HRES_CO_E_INIT_TLS_CHANNEL_CONTROL,
		"HRES_CO_E_INIT_TLS_CHANNEL_CONTROL",
		"Could not allocate thread local storage channel control."
	},
	{
		HRES_CO_E_INIT_UNACCEPTED_USER_ALLOCATOR,
		"HRES_CO_E_INIT_UNACCEPTED_USER_ALLOCATOR",
		"The user-supplied memory allocator is unacceptable."
	},
	{
		HRES_CO_E_INIT_SCM_MUTEX_EXISTS,
		"HRES_CO_E_INIT_SCM_MUTEX_EXISTS",
		"The OLE service mutex already exists."
	},
	{
		HRES_CO_E_INIT_SCM_FILE_MAPPING_EXISTS,
		"HRES_CO_E_INIT_SCM_FILE_MAPPING_EXISTS",
		"The OLE service file mapping already exists."
	},
	{
		HRES_CO_E_INIT_SCM_MAP_VIEW_OF_FILE,
		"HRES_CO_E_INIT_SCM_MAP_VIEW_OF_FILE",
		"Unable to map view of file for OLE service."
	},
	{
		HRES_CO_E_INIT_SCM_EXEC_FAILURE,
		"HRES_CO_E_INIT_SCM_EXEC_FAILURE",
		"Failure attempting to launch OLE service."
	},
	{
		HRES_CO_E_INIT_ONLY_SINGLE_THREADED,
		"HRES_CO_E_INIT_ONLY_SINGLE_THREADED",
		"There was an attempt to call CoInitialize a second time while single-threaded."
	},
	{
		HRES_CO_E_CANT_REMOTE,
		"HRES_CO_E_CANT_REMOTE",
		"A Remote activation was necessary but was not allowed."
	},
	{
		HRES_CO_E_BAD_SERVER_NAME,
		"HRES_CO_E_BAD_SERVER_NAME",
		"A Remote activation was necessary, but the server name provided was invalid."
	},
	{
		HRES_CO_E_WRONG_SERVER_IDENTITY,
		"HRES_CO_E_WRONG_SERVER_IDENTITY",
		"The class is configured to run as a security ID different from the caller."
	},
	{
		HRES_CO_E_OLE1DDE_DISABLED,
		"HRES_CO_E_OLE1DDE_DISABLED",
		"Use of OLE1 services requiring Dynamic Data Exchange (DDE) Windows is disabled."
	},
	{
		HRES_CO_E_RUNAS_SYNTAX,
		"HRES_CO_E_RUNAS_SYNTAX",
		"A RunAs specification must be <domain name>\\<user name> or simply <user name>."
	},
	{
		HRES_CO_E_CREATEPROCESS_FAILURE,
		"HRES_CO_E_CREATEPROCESS_FAILURE",
		"The server process could not be started. The path name might be incorrect."
	},
	{
		HRES_CO_E_RUNAS_CREATEPROCESS_FAILURE,
		"HRES_CO_E_RUNAS_CREATEPROCESS_FAILURE",
		"The server process could not be started as the configured identity. The path name might be incorrect or unavailable."
	},
	{
		HRES_CO_E_RUNAS_LOGON_FAILURE,
		"HRES_CO_E_RUNAS_LOGON_FAILURE",
		"The server process could not be started because the configured identity is incorrect. Check the user name and password."
	},
	{
		HRES_CO_E_LAUNCH_PERMSSION_DENIED,
		"HRES_CO_E_LAUNCH_PERMSSION_DENIED",
		"The client is not allowed to launch this server."
	},
	{
		HRES_CO_E_START_SERVICE_FAILURE,
		"HRES_CO_E_START_SERVICE_FAILURE",
		"The service providing this server could not be started."
	},
	{
		HRES_CO_E_REMOTE_COMMUNICATION_FAILURE,
		"HRES_CO_E_REMOTE_COMMUNICATION_FAILURE",
		"This computer was unable to communicate with the computer providing the server."
	},
	{
		HRES_CO_E_SERVER_START_TIMEOUT,
		"HRES_CO_E_SERVER_START_TIMEOUT",
		"The server did not respond after being launched."
	},
	{
		HRES_CO_E_CLSREG_INCONSISTENT,
		"HRES_CO_E_CLSREG_INCONSISTENT",
		"The registration information for this server is inconsistent or incomplete."
	},
	{
		HRES_CO_E_IIDREG_INCONSISTENT,
		"HRES_CO_E_IIDREG_INCONSISTENT",
		"The registration information for this interface is inconsistent or incomplete."
	},
	{
		HRES_CO_E_NOT_SUPPORTED,
		"HRES_CO_E_NOT_SUPPORTED",
		"The operation attempted is not supported."
	},
	{
		HRES_CO_E_RELOAD_DLL,
		"HRES_CO_E_RELOAD_DLL",
		"A DLL must be loaded."
	},
	{
		HRES_CO_E_MSI_ERROR,
		"HRES_CO_E_MSI_ERROR",
		"A Microsoft Software Installer error was encountered."
	},
	{
		HRES_CO_E_ATTEMPT_TO_CREATE_OUTSIDE_CLIENT_CONTEXT,
		"HRES_CO_E_ATTEMPT_TO_CREATE_OUTSIDE_CLIENT_CONTEXT",
		"The specified activation could not occur in the client context as specified."
	},
	{
		HRES_CO_E_SERVER_PAUSED,
		"HRES_CO_E_SERVER_PAUSED",
		"Activations on the server are paused."
	},
	{
		HRES_CO_E_SERVER_NOT_PAUSED,
		"HRES_CO_E_SERVER_NOT_PAUSED",
		"Activations on the server are not paused."
	},
	{
		HRES_CO_E_CLASS_DISABLED,
		"HRES_CO_E_CLASS_DISABLED",
		"The component or application containing the component has been disabled."
	},
	{
		HRES_CO_E_CLRNOTAVAILABLE,
		"HRES_CO_E_CLRNOTAVAILABLE",
		"The common language runtime is not available."
	},
	{
		HRES_CO_E_ASYNC_WORK_REJECTED,
		"HRES_CO_E_ASYNC_WORK_REJECTED",
		"The thread-pool rejected the submitted asynchronous work."
	},
	{
		HRES_CO_E_SERVER_INIT_TIMEOUT,
		"HRES_CO_E_SERVER_INIT_TIMEOUT",
		"The server started, but it did not finish initializing in a timely fashion."
	},
	{
		HRES_CO_E_NO_SECCTX_IN_ACTIVATE,
		"HRES_CO_E_NO_SECCTX_IN_ACTIVATE",
		"Unable to complete the call because there is no COM+ security context inside IObjectControl.Activate."
	},
	{
		HRES_CO_E_TRACKER_CONFIG,
		"HRES_CO_E_TRACKER_CONFIG",
		"The provided tracker configuration is invalid."
	},
	{
		HRES_CO_E_THREADPOOL_CONFIG,
		"HRES_CO_E_THREADPOOL_CONFIG",
		"The provided thread pool configuration is invalid."
	},
	{
		HRES_CO_E_SXS_CONFIG,
		"HRES_CO_E_SXS_CONFIG",
		"The provided side-by-side configuration is invalid."
	},
	{
		HRES_CO_E_MALFORMED_SPN,
		"HRES_CO_E_MALFORMED_SPN",
		"The server principal name (SPN) obtained during security negotiation is malformed."
	},
	{
		HRES_E_UNEXPECTED,
		"HRES_E_UNEXPECTED",
		"Catastrophic failure."
	},
	{
		HRES_RPC_E_CALL_REJECTED,
		"HRES_RPC_E_CALL_REJECTED",
		"Call was rejected by callee."
	},
	{
		HRES_RPC_E_CALL_CANCELED,
		"HRES_RPC_E_CALL_CANCELED",
		"Call was canceled by the message filter."
	},
	{
		HRES_RPC_E_CANTPOST_INSENDCALL,
		"HRES_RPC_E_CANTPOST_INSENDCALL",
		"The caller is dispatching an intertask SendMessage call and cannot call out via PostMessage."
	},
	{
		HRES_RPC_E_CANTCALLOUT_INASYNCCALL,
		"HRES_RPC_E_CANTCALLOUT_INASYNCCALL",
		"The caller is dispatching an asynchronous call and cannot make an outgoing call on behalf of this call."
	},
	{
		HRES_RPC_E_CANTCALLOUT_INEXTERNALCALL,
		"HRES_RPC_E_CANTCALLOUT_INEXTERNALCALL",
		"It is illegal to call out while inside message filter."
	},
	{
		HRES_RPC_E_CONNECTION_TERMINATED,
		"HRES_RPC_E_CONNECTION_TERMINATED",
		"The connection terminated or is in a bogus state and can no longer be used. Other connections are still valid."
	},
	{
		HRES_RPC_E_SERVER_DIED,
		"HRES_RPC_E_SERVER_DIED",
		"The callee (the server, not the server application) is not available and disappeared; all connections are invalid. The call might have executed."
	},
	{
		HRES_RPC_E_CLIENT_DIED,
		"HRES_RPC_E_CLIENT_DIED",
		"The caller (client) disappeared while the callee (server) was processing a call."
	},
	{
		HRES_RPC_E_INVALID_DATAPACKET,
		"HRES_RPC_E_INVALID_DATAPACKET",
		"The data packet with the marshaled parameter data is incorrect."
	},
	{
		HRES_RPC_E_CANTTRANSMIT_CALL,
		"HRES_RPC_E_CANTTRANSMIT_CALL",
		"The call was not transmitted properly; the message queue was full and was not emptied after yielding."
	},
	{
		HRES_RPC_E_CLIENT_CANTMARSHAL_DATA,
		"HRES_RPC_E_CLIENT_CANTMARSHAL_DATA",
		"The client RPC caller cannot marshal the parameter data due to errors (such as low memory)."
	},
	{
		HRES_RPC_E_CLIENT_CANTUNMARSHAL_DATA,
		"HRES_RPC_E_CLIENT_CANTUNMARSHAL_DATA",
		"The client RPC caller cannot unmarshal the return data due to errors (such as low memory)."
	},
	{
		HRES_RPC_E_SERVER_CANTMARSHAL_DATA,
		"HRES_RPC_E_SERVER_CANTMARSHAL_DATA",
		"The server RPC callee cannot marshal the return data due to errors (such as low memory)."
	},
	{
		HRES_RPC_E_SERVER_CANTUNMARSHAL_DATA,
		"HRES_RPC_E_SERVER_CANTUNMARSHAL_DATA",
		"The server RPC callee cannot unmarshal the parameter data due to errors (such as low memory)."
	},
	{
		HRES_RPC_E_INVALID_DATA,
		"HRES_RPC_E_INVALID_DATA",
		"Received data is invalid. The data might be server or client data."
	},
	{
		HRES_RPC_E_INVALID_PARAMETER,
		"HRES_RPC_E_INVALID_PARAMETER",
		"A particular parameter is invalid and cannot be (un)marshaled."
	},
	{
		HRES_RPC_E_CANTCALLOUT_AGAIN,
		"HRES_RPC_E_CANTCALLOUT_AGAIN",
		"There is no second outgoing call on same channel in DDE conversation."
	},
	{
		HRES_RPC_E_SERVER_DIED_DNE,
		"HRES_RPC_E_SERVER_DIED_DNE",
		"The callee (the server, not the server application) is not available and disappeared; all connections are invalid. The call did not execute."
	},
	{
		HRES_RPC_E_SYS_CALL_FAILED,
		"HRES_RPC_E_SYS_CALL_FAILED",
		"System call failed."
	},
	{
		HRES_RPC_E_OUT_OF_RESOURCES,
		"HRES_RPC_E_OUT_OF_RESOURCES",
		"Could not allocate some required resource (such as memory or events)"
	},
	{
		HRES_RPC_E_ATTEMPTED_MULTITHREAD,
		"HRES_RPC_E_ATTEMPTED_MULTITHREAD",
		"Attempted to make calls on more than one thread in single-threaded mode."
	},
	{
		HRES_RPC_E_NOT_REGISTERED,
		"HRES_RPC_E_NOT_REGISTERED",
		"The requested interface is not registered on the server object."
	},
	{
		HRES_RPC_E_FAULT,
		"HRES_RPC_E_FAULT",
		"RPC could not call the server or could not return the results of calling the server."
	},
	{
		HRES_RPC_E_SERVERFAULT,
		"HRES_RPC_E_SERVERFAULT",
		"The server threw an exception."
	},
	{
		HRES_RPC_E_CHANGED_MODE,
		"HRES_RPC_E_CHANGED_MODE",
		"Cannot change thread mode after it is set."
	},
	{
		HRES_RPC_E_INVALIDMETHOD,
		"HRES_RPC_E_INVALIDMETHOD",
		"The method called does not exist on the server."
	},
	{
		HRES_RPC_E_DISCONNECTED,
		"HRES_RPC_E_DISCONNECTED",
		"The object invoked has disconnected from its clients."
	},
	{
		HRES_RPC_E_RETRY,
		"HRES_RPC_E_RETRY",
		"The object invoked chose not to process the call now. Try again later."
	},
	{
		HRES_RPC_E_SERVERCALL_RETRYLATER,
		"HRES_RPC_E_SERVERCALL_RETRYLATER",
		"The message filter indicated that the application is busy."
	},
	{
		HRES_RPC_E_SERVERCALL_REJECTED,
		"HRES_RPC_E_SERVERCALL_REJECTED",
		"The message filter rejected the call."
	},
	{
		HRES_RPC_E_INVALID_CALLDATA,
		"HRES_RPC_E_INVALID_CALLDATA",
		"A call control interface was called with invalid data."
	},
	{
		HRES_RPC_E_CANTCALLOUT_ININPUTSYNCCALL,
		"HRES_RPC_E_CANTCALLOUT_ININPUTSYNCCALL",
		"An outgoing call cannot be made because the application is dispatching an input-synchronous call."
	},
	{
		HRES_RPC_E_WRONG_THREAD,
		"HRES_RPC_E_WRONG_THREAD",
		"The application called an interface that was marshaled for a different thread."
	},
	{
		HRES_RPC_E_THREAD_NOT_INIT,
		"HRES_RPC_E_THREAD_NOT_INIT",
		"CoInitialize has not been called on the current thread."
	},
	{
		HRES_RPC_E_VERSION_MISMATCH,
		"HRES_RPC_E_VERSION_MISMATCH",
		"The version of OLE on the client and server machines does not match."
	},
	{
		HRES_RPC_E_INVALID_HEADER,
		"HRES_RPC_E_INVALID_HEADER",
		"OLE received a packet with an invalid header."
	},
	{
		HRES_RPC_E_INVALID_EXTENSION,
		"HRES_RPC_E_INVALID_EXTENSION",
		"OLE received a packet with an invalid extension."
	},
	{
		HRES_RPC_E_INVALID_IPID,
		"HRES_RPC_E_INVALID_IPID",
		"The requested object or interface does not exist."
	},
	{
		HRES_RPC_E_INVALID_OBJECT,
		"HRES_RPC_E_INVALID_OBJECT",
		"The requested object does not exist."
	},
	{
		HRES_RPC_S_CALLPENDING,
		"HRES_RPC_S_CALLPENDING",
		"OLE has sent a request and is waiting for a reply."
	},
	{
		HRES_RPC_S_WAITONTIMER,
		"HRES_RPC_S_WAITONTIMER",
		"OLE is waiting before retrying a request."
	},
	{
		HRES_RPC_E_CALL_COMPLETE,
		"HRES_RPC_E_CALL_COMPLETE",
		"Call context cannot be accessed after call completed."
	},
	{
		HRES_RPC_E_UNSECURE_CALL,
		"HRES_RPC_E_UNSECURE_CALL",
		"Impersonate on unsecure calls is not supported."
	},
	{
		HRES_RPC_E_TOO_LATE,
		"HRES_RPC_E_TOO_LATE",
		"Security must be initialized before any interfaces are marshaled or unmarshaled. It cannot be changed after initialized."
	},
	{
		HRES_RPC_E_NO_GOOD_SECURITY_PACKAGES,
		"HRES_RPC_E_NO_GOOD_SECURITY_PACKAGES",
		"No security packages are installed on this machine, the user is not logged on, or there are no compatible security packages between the client and server."
	},
	{
		HRES_RPC_E_ACCESS_DENIED,
		"HRES_RPC_E_ACCESS_DENIED",
		"Access is denied."
	},
	{
		HRES_RPC_E_REMOTE_DISABLED,
		"HRES_RPC_E_REMOTE_DISABLED",
		"Remote calls are not allowed for this process."
	},
	{
		HRES_RPC_E_INVALID_OBJREF,
		"HRES_RPC_E_INVALID_OBJREF",
		"The marshaled interface data packet (OBJREF) has an invalid or unknown format."
	},
	{
		HRES_RPC_E_NO_CONTEXT,
		"HRES_RPC_E_NO_CONTEXT",
		"No context is associated with this call. This happens for some custom marshaled calls and on the client side of the call."
	},
	{
		HRES_RPC_E_TIMEOUT,
		"HRES_RPC_E_TIMEOUT",
		"This operation returned because the time-out period expired."
	},
	{
		HRES_RPC_E_NO_SYNC,
		"HRES_RPC_E_NO_SYNC",
		"There are no synchronize objects to wait on."
	},
	{
		HRES_RPC_E_FULLSIC_REQUIRED,
		"HRES_RPC_E_FULLSIC_REQUIRED",
		"Full subject issuer chain Secure Sockets Layer (SSL) principal name expected from the server."
	},
	{
		HRES_RPC_E_INVALID_STD_NAME,
		"HRES_RPC_E_INVALID_STD_NAME",
		"Principal name is not a valid Microsoft standard (msstd) name."
	},
	{
		HRES_CO_E_FAILEDTOIMPERSONATE,
		"HRES_CO_E_FAILEDTOIMPERSONATE",
		"Unable to impersonate DCOM client."
	},
	{
		HRES_CO_E_FAILEDTOGETSECCTX,
		"HRES_CO_E_FAILEDTOGETSECCTX",
		"Unable to obtain server's security context."
	},
	{
		HRES_CO_E_FAILEDTOOPENTHREADTOKEN,
		"HRES_CO_E_FAILEDTOOPENTHREADTOKEN",
		"Unable to open the access token of the current thread."
	},
	{
		HRES_CO_E_FAILEDTOGETTOKENINFO,
		"HRES_CO_E_FAILEDTOGETTOKENINFO",
		"Unable to obtain user information from an access token."
	},
	{
		HRES_CO_E_TRUSTEEDOESNTMATCHCLIENT,
		"HRES_CO_E_TRUSTEEDOESNTMATCHCLIENT",
		"The client who called IAccessControl::IsAccessPermitted was not the trustee provided to the method."
	},
	{
		HRES_CO_E_FAILEDTOQUERYCLIENTBLANKET,
		"HRES_CO_E_FAILEDTOQUERYCLIENTBLANKET",
		"Unable to obtain the client's security blanket."
	},
	{
		HRES_CO_E_FAILEDTOSETDACL,
		"HRES_CO_E_FAILEDTOSETDACL",
		"Unable to set a discretionary access control list (ACL) into a security descriptor."
	},
	{
		HRES_CO_E_ACCESSCHECKFAILED,
		"HRES_CO_E_ACCESSCHECKFAILED",
		"The system function AccessCheck returned false."
	},
	{
		HRES_CO_E_NETACCESSAPIFAILED,
		"HRES_CO_E_NETACCESSAPIFAILED",
		"Either NetAccessDel or NetAccessAdd returned an error code."
	},
	{
		HRES_CO_E_WRONGTRUSTEENAMESYNTAX,
		"HRES_CO_E_WRONGTRUSTEENAMESYNTAX",
		"One of the trustee strings provided by the user did not conform to the <Domain>\\<Name> syntax and it was not the *\" string\"."
	},
	{
		HRES_CO_E_INVALIDSID,
		"HRES_CO_E_INVALIDSID",
		"One of the security identifiers provided by the user was invalid."
	},
	{
		HRES_CO_E_CONVERSIONFAILED,
		"HRES_CO_E_CONVERSIONFAILED",
		"Unable to convert a wide character trustee string to a multiple-byte trustee string."
	},
	{
		HRES_CO_E_NOMATCHINGSIDFOUND,
		"HRES_CO_E_NOMATCHINGSIDFOUND",
		"Unable to find a security identifier that corresponds to a trustee string provided by the user."
	},
	{
		HRES_CO_E_LOOKUPACCSIDFAILED,
		"HRES_CO_E_LOOKUPACCSIDFAILED",
		"The system function LookupAccountSID failed."
	},
	{
		HRES_CO_E_NOMATCHINGNAMEFOUND,
		"HRES_CO_E_NOMATCHINGNAMEFOUND",
		"Unable to find a trustee name that corresponds to a security identifier provided by the user."
	},
	{
		HRES_CO_E_LOOKUPACCNAMEFAILED,
		"HRES_CO_E_LOOKUPACCNAMEFAILED",
		"The system function LookupAccountName failed."
	},
	{
		HRES_CO_E_SETSERLHNDLFAILED,
		"HRES_CO_E_SETSERLHNDLFAILED",
		"Unable to set or reset a serialization handle."
	},
	{
		HRES_CO_E_FAILEDTOGETWINDIR,
		"HRES_CO_E_FAILEDTOGETWINDIR",
		"Unable to obtain the Windows directory."
	},
	{
		HRES_CO_E_PATHTOOLONG,
		"HRES_CO_E_PATHTOOLONG",
		"Path too long."
	},
	{
		HRES_CO_E_FAILEDTOGENUUID,
		"HRES_CO_E_FAILEDTOGENUUID",
		"Unable to generate a UUID."
	},
	{
		HRES_CO_E_FAILEDTOCREATEFILE,
		"HRES_CO_E_FAILEDTOCREATEFILE",
		"Unable to create file."
	},
	{
		HRES_CO_E_FAILEDTOCLOSEHANDLE,
		"HRES_CO_E_FAILEDTOCLOSEHANDLE",
		"Unable to close a serialization handle or a file handle."
	},
	{
		HRES_CO_E_EXCEEDSYSACLLIMIT,
		"HRES_CO_E_EXCEEDSYSACLLIMIT",
		"The number of access control entries (ACEs) in an ACL exceeds the system limit."
	},
	{
		HRES_CO_E_ACESINWRONGORDER,
		"HRES_CO_E_ACESINWRONGORDER",
		"Not all the DENY_ACCESS ACEs are arranged in front of the GRANT_ACCESS ACEs in the stream."
	},
	{
		HRES_CO_E_INCOMPATIBLESTREAMVERSION,
		"HRES_CO_E_INCOMPATIBLESTREAMVERSION",
		"The version of ACL format in the stream is not supported by this implementation of IAccessControl."
	},
	{
		HRES_CO_E_FAILEDTOOPENPROCESSTOKEN,
		"HRES_CO_E_FAILEDTOOPENPROCESSTOKEN",
		"Unable to open the access token of the server process."
	},
	{
		HRES_CO_E_DECODEFAILED,
		"HRES_CO_E_DECODEFAILED",
		"Unable to decode the ACL in the stream provided by the user."
	},
	{
		HRES_CO_E_ACNOTINITIALIZED,
		"HRES_CO_E_ACNOTINITIALIZED",
		"The COM IAccessControl object is not initialized."
	},
	{
		HRES_CO_E_CANCEL_DISABLED,
		"HRES_CO_E_CANCEL_DISABLED",
		"Call Cancellation is disabled."
	},
	{
		HRES_RPC_E_UNEXPECTED,
		"HRES_RPC_E_UNEXPECTED",
		"An internal error occurred."
	},
	{
		HRES_DISP_E_UNKNOWNINTERFACE,
		"HRES_DISP_E_UNKNOWNINTERFACE",
		"Unknown interface."
	},
	{
		HRES_DISP_E_MEMBERNOTFOUND,
		"HRES_DISP_E_MEMBERNOTFOUND",
		"Member not found."
	},
	{
		HRES_DISP_E_PARAMNOTFOUND,
		"HRES_DISP_E_PARAMNOTFOUND",
		"Parameter not found."
	},
	{
		HRES_DISP_E_TYPEMISMATCH,
		"HRES_DISP_E_TYPEMISMATCH",
		"Type mismatch."
	},
	{
		HRES_DISP_E_UNKNOWNNAME,
		"HRES_DISP_E_UNKNOWNNAME",
		"Unknown name."
	},
	{
		HRES_DISP_E_NONAMEDARGS,
		"HRES_DISP_E_NONAMEDARGS",
		"No named arguments."
	},
	{
		HRES_DISP_E_BADVARTYPE,
		"HRES_DISP_E_BADVARTYPE",
		"Bad variable type."
	},
	{
		HRES_DISP_E_EXCEPTION,
		"HRES_DISP_E_EXCEPTION",
		"Exception occurred."
	},
	{
		HRES_DISP_E_OVERFLOW,
		"HRES_DISP_E_OVERFLOW",
		"Out of present range."
	},
	{
		HRES_DISP_E_BADINDEX,
		"HRES_DISP_E_BADINDEX",
		"Invalid index."
	},
	{
		HRES_DISP_E_UNKNOWNLCID,
		"HRES_DISP_E_UNKNOWNLCID",
		"Unknown language."
	},
	{
		HRES_DISP_E_ARRAYISLOCKED,
		"HRES_DISP_E_ARRAYISLOCKED",
		"Memory is locked."
	},
	{
		HRES_DISP_E_BADPARAMCOUNT,
		"HRES_DISP_E_BADPARAMCOUNT",
		"Invalid number of parameters."
	},
	{
		HRES_DISP_E_PARAMNOTOPTIONAL,
		"HRES_DISP_E_PARAMNOTOPTIONAL",
		"Parameter not optional."
	},
	{
		HRES_DISP_E_BADCALLEE,
		"HRES_DISP_E_BADCALLEE",
		"Invalid callee."
	},
	{
		HRES_DISP_E_NOTACOLLECTION,
		"HRES_DISP_E_NOTACOLLECTION",
		"Does not support a collection."
	},
	{
		HRES_DISP_E_DIVBYZERO,
		"HRES_DISP_E_DIVBYZERO",
		"Division by zero."
	},
	{
		HRES_DISP_E_BUFFERTOOSMALL,
		"HRES_DISP_E_BUFFERTOOSMALL",
		"Buffer too small."
	},
	{
		HRES_TYPE_E_BUFFERTOOSMALL,
		"HRES_TYPE_E_BUFFERTOOSMALL",
		"Buffer too small."
	},
	{
		HRES_TYPE_E_FIELDNOTFOUND,
		"HRES_TYPE_E_FIELDNOTFOUND",
		"Field name not defined in the record."
	},
	{
		HRES_TYPE_E_INVDATAREAD,
		"HRES_TYPE_E_INVDATAREAD",
		"Old format or invalid type library."
	},
	{
		HRES_TYPE_E_UNSUPFORMAT,
		"HRES_TYPE_E_UNSUPFORMAT",
		"Old format or invalid type library."
	},
	{
		HRES_TYPE_E_REGISTRYACCESS,
		"HRES_TYPE_E_REGISTRYACCESS",
		"Error accessing the OLE registry."
	},
	{
		HRES_TYPE_E_LIBNOTREGISTERED,
		"HRES_TYPE_E_LIBNOTREGISTERED",
		"Library not registered."
	},
	{
		HRES_TYPE_E_UNDEFINEDTYPE,
		"HRES_TYPE_E_UNDEFINEDTYPE",
		"Bound to unknown type."
	},
	{
		HRES_TYPE_E_QUALIFIEDNAMEDISALLOWED,
		"HRES_TYPE_E_QUALIFIEDNAMEDISALLOWED",
		"Qualified name disallowed."
	},
	{
		HRES_TYPE_E_INVALIDSTATE,
		"HRES_TYPE_E_INVALIDSTATE",
		"Invalid forward reference, or reference to uncompiled type."
	},
	{
		HRES_TYPE_E_WRONGTYPEKIND,
		"HRES_TYPE_E_WRONGTYPEKIND",
		"Type mismatch."
	},
	{
		HRES_TYPE_E_ELEMENTNOTFOUND,
		"HRES_TYPE_E_ELEMENTNOTFOUND",
		"Element not found."
	},
	{
		HRES_TYPE_E_AMBIGUOUSNAME,
		"HRES_TYPE_E_AMBIGUOUSNAME",
		"Ambiguous name."
	},
	{
		HRES_TYPE_E_NAMECONFLICT,
		"HRES_TYPE_E_NAMECONFLICT",
		"Name already exists in the library."
	},
	{
		HRES_TYPE_E_UNKNOWNLCID,
		"HRES_TYPE_E_UNKNOWNLCID",
		"Unknown language code identifier (LCID)."
	},
	{
		HRES_TYPE_E_DLLFUNCTIONNOTFOUND,
		"HRES_TYPE_E_DLLFUNCTIONNOTFOUND",
		"Function not defined in specified DLL."
	},
	{
		HRES_TYPE_E_BADMODULEKIND,
		"HRES_TYPE_E_BADMODULEKIND",
		"Wrong module kind for the operation."
	},
	{
		HRES_TYPE_E_SIZETOOBIG,
		"HRES_TYPE_E_SIZETOOBIG",
		"Size cannot exceed 64 KB."
	},
	{
		HRES_TYPE_E_DUPLICATEID,
		"HRES_TYPE_E_DUPLICATEID",
		"Duplicate ID in inheritance hierarchy."
	},
	{
		HRES_TYPE_E_INVALIDID,
		"HRES_TYPE_E_INVALIDID",
		"Incorrect inheritance depth in standard OLE hmember."
	},
	{
		HRES_TYPE_E_TYPEMISMATCH,
		"HRES_TYPE_E_TYPEMISMATCH",
		"Type mismatch."
	},
	{
		HRES_TYPE_E_OUTOFBOUNDS,
		"HRES_TYPE_E_OUTOFBOUNDS",
		"Invalid number of arguments."
	},
	{
		HRES_TYPE_E_IOERROR,
		"HRES_TYPE_E_IOERROR",
		"I/O error."
	},
	{
		HRES_TYPE_E_CANTCREATETMPFILE,
		"HRES_TYPE_E_CANTCREATETMPFILE",
		"Error creating unique .tmp file."
	},
	{
		HRES_TYPE_E_CANTLOADLIBRARY,
		"HRES_TYPE_E_CANTLOADLIBRARY",
		"Error loading type library or DLL."
	},
	{
		HRES_TYPE_E_INCONSISTENTPROPFUNCS,
		"HRES_TYPE_E_INCONSISTENTPROPFUNCS",
		"Inconsistent property functions."
	},
	{
		HRES_TYPE_E_CIRCULARTYPE,
		"HRES_TYPE_E_CIRCULARTYPE",
		"Circular dependency between types and modules."
	},
	{
		HRES_STG_E_INVALIDFUNCTION,
		"HRES_STG_E_INVALIDFUNCTION",
		"Unable to perform requested operation."
	},
	{
		HRES_STG_E_FILENOTFOUND,
		"HRES_STG_E_FILENOTFOUND",
		"%1 could not be found."
	},
	{
		HRES_STG_E_PATHNOTFOUND,
		"HRES_STG_E_PATHNOTFOUND",
		"The path %1 could not be found."
	},
	{
		HRES_STG_E_TOOMANYOPENFILES,
		"HRES_STG_E_TOOMANYOPENFILES",
		"There are insufficient resources to open another file."
	},
	{
		HRES_STG_E_ACCESSDENIED,
		"HRES_STG_E_ACCESSDENIED",
		"Access denied."
	},
	{
		HRES_STG_E_INVALIDHANDLE,
		"HRES_STG_E_INVALIDHANDLE",
		"Attempted an operation on an invalid object."
	},
	{
		HRES_STG_E_INSUFFICIENTMEMORY,
		"HRES_STG_E_INSUFFICIENTMEMORY",
		"There is insufficient memory available to complete operation."
	},
	{
		HRES_STG_E_INVALIDPOINTER,
		"HRES_STG_E_INVALIDPOINTER",
		"Invalid pointer error."
	},
	{
		HRES_STG_E_NOMOREFILES,
		"HRES_STG_E_NOMOREFILES",
		"There are no more entries to return."
	},
	{
		HRES_STG_E_DISKISWRITEPROTECTED,
		"HRES_STG_E_DISKISWRITEPROTECTED",
		"Disk is write-protected."
	},
	{
		HRES_STG_E_SEEKERROR,
		"HRES_STG_E_SEEKERROR",
		"An error occurred during a seek operation."
	},
	{
		HRES_STG_E_WRITEFAULT,
		"HRES_STG_E_WRITEFAULT",
		"A disk error occurred during a write operation."
	},
	{
		HRES_STG_E_READFAULT,
		"HRES_STG_E_READFAULT",
		"A disk error occurred during a read operation."
	},
	{
		HRES_STG_E_SHAREVIOLATION,
		"HRES_STG_E_SHAREVIOLATION",
		"A share violation has occurred."
	},
	{
		HRES_STG_E_LOCKVIOLATION,
		"HRES_STG_E_LOCKVIOLATION",
		"A lock violation has occurred."
	},
	{
		HRES_STG_E_FILEALREADYEXISTS,
		"HRES_STG_E_FILEALREADYEXISTS",
		"%1 already exists."
	},
	{
		HRES_STG_E_INVALIDPARAMETER,
		"HRES_STG_E_INVALIDPARAMETER",
		"Invalid parameter error."
	},
	{
		HRES_STG_E_MEDIUMFULL,
		"HRES_STG_E_MEDIUMFULL",
		"There is insufficient disk space to complete operation."
	},
	{
		HRES_STG_E_PROPSETMISMATCHED,
		"HRES_STG_E_PROPSETMISMATCHED",
		"Illegal write of non-simple property to simple property set."
	},
	{
		HRES_STG_E_ABNORMALAPIEXIT,
		"HRES_STG_E_ABNORMALAPIEXIT",
		"An application programming interface (API) call exited abnormally."
	},
	{
		HRES_STG_E_INVALIDHEADER,
		"HRES_STG_E_INVALIDHEADER",
		"The file %1 is not a valid compound file."
	},
	{
		HRES_STG_E_INVALIDNAME,
		"HRES_STG_E_INVALIDNAME",
		"The name %1 is not valid."
	},
	{
		HRES_STG_E_UNKNOWN,
		"HRES_STG_E_UNKNOWN",
		"An unexpected error occurred."
	},
	{
		HRES_STG_E_UNIMPLEMENTEDFUNCTION,
		"HRES_STG_E_UNIMPLEMENTEDFUNCTION",
		"That function is not implemented."
	},
	{
		HRES_STG_E_INVALIDFLAG,
		"HRES_STG_E_INVALIDFLAG",
		"Invalid flag error."
	},
	{
		HRES_STG_E_INUSE,
		"HRES_STG_E_INUSE",
		"Attempted to use an object that is busy."
	},
	{
		HRES_STG_E_NOTCURRENT,
		"HRES_STG_E_NOTCURRENT",
		"The storage has been changed since the last commit."
	},
	{
		HRES_STG_E_REVERTED,
		"HRES_STG_E_REVERTED",
		"Attempted to use an object that has ceased to exist."
	},
	{
		HRES_STG_E_CANTSAVE,
		"HRES_STG_E_CANTSAVE",
		"Cannot save."
	},
	{
		HRES_STG_E_OLDFORMAT,
		"HRES_STG_E_OLDFORMAT",
		"The compound file %1 was produced with an incompatible version of storage."
	},
	{
		HRES_STG_E_OLDDLL,
		"HRES_STG_E_OLDDLL",
		"The compound file %1 was produced with a newer version of storage."
	},
	{
		HRES_STG_E_SHAREREQUIRED,
		"HRES_STG_E_SHAREREQUIRED",
		"Share.exe or equivalent is required for operation."
	},
	{
		HRES_STG_E_NOTFILEBASEDSTORAGE,
		"HRES_STG_E_NOTFILEBASEDSTORAGE",
		"Illegal operation called on non-file based storage."
	},
	{
		HRES_STG_E_EXTANTMARSHALLINGS,
		"HRES_STG_E_EXTANTMARSHALLINGS",
		"Illegal operation called on object with extant marshalings."
	},
	{
		HRES_STG_E_DOCFILECORRUPT,
		"HRES_STG_E_DOCFILECORRUPT",
		"The docfile has been corrupted."
	},
	{
		HRES_STG_E_BADBASEADDRESS,
		"HRES_STG_E_BADBASEADDRESS",
		"OLE32.DLL has been loaded at the wrong address."
	},
	{
		HRES_STG_E_DOCFILETOOLARGE,
		"HRES_STG_E_DOCFILETOOLARGE",
		"The compound file is too large for the current implementation."
	},
	{
		HRES_STG_E_NOTSIMPLEFORMAT,
		"HRES_STG_E_NOTSIMPLEFORMAT",
		"The compound file was not created with the STGM_SIMPLE flag."
	},
	{
		HRES_STG_E_INCOMPLETE,
		"HRES_STG_E_INCOMPLETE",
		"The file download was aborted abnormally. The file is incomplete."
	},
	{
		HRES_STG_E_TERMINATED,
		"HRES_STG_E_TERMINATED",
		"The file download has been terminated."
	},
	{
		HRES_STG_E_STATUS_COPY_PROTECTION_FAILURE,
		"HRES_STG_E_STATUS_COPY_PROTECTION_FAILURE",
		"Generic Copy Protection Error."
	},
	{
		HRES_STG_E_CSS_AUTHENTICATION_FAILURE,
		"HRES_STG_E_CSS_AUTHENTICATION_FAILURE",
		"Copy Protection Error—DVD CSS Authentication failed."
	},
	{
		HRES_STG_E_CSS_KEY_NOT_PRESENT,
		"HRES_STG_E_CSS_KEY_NOT_PRESENT",
		"Copy Protection Error—The given sector does not have a valid CSS key."
	},
	{
		HRES_STG_E_CSS_KEY_NOT_ESTABLISHED,
		"HRES_STG_E_CSS_KEY_NOT_ESTABLISHED",
		"Copy Protection Error—DVD session key not established."
	},
	{
		HRES_STG_E_CSS_SCRAMBLED_SECTOR,
		"HRES_STG_E_CSS_SCRAMBLED_SECTOR",
		"Copy Protection Error—The read failed because the sector is encrypted."
	},
	{
		HRES_STG_E_CSS_REGION_MISMATCH,
		"HRES_STG_E_CSS_REGION_MISMATCH",
		"Copy Protection Error—The current DVD's region does not correspond to the region setting of the drive."
	},
	{
		HRES_STG_E_RESETS_EXHAUSTED,
		"HRES_STG_E_RESETS_EXHAUSTED",
		"Copy Protection Error—The drive's region setting might be permanent or the number of user resets has been exhausted."
	},
	{
		HRES_OLE_E_OLEVERB,
		"HRES_OLE_E_OLEVERB",
		"Invalid OLEVERB structure."
	},
	{
		HRES_OLE_E_ADVF,
		"HRES_OLE_E_ADVF",
		"Invalid advise flags."
	},
	{
		HRES_OLE_E_ENUM_NOMORE,
		"HRES_OLE_E_ENUM_NOMORE",
		"Cannot enumerate any more because the associated data is missing."
	},
	{
		HRES_OLE_E_ADVISENOTSUPPORTED,
		"HRES_OLE_E_ADVISENOTSUPPORTED",
		"This implementation does not take advises."
	},
	{
		HRES_OLE_E_NOCONNECTION,
		"HRES_OLE_E_NOCONNECTION",
		"There is no connection for this connection ID."
	},
	{
		HRES_OLE_E_NOTRUNNING,
		"HRES_OLE_E_NOTRUNNING",
		"Need to run the object to perform this operation."
	},
	{
		HRES_OLE_E_NOCACHE,
		"HRES_OLE_E_NOCACHE",
		"There is no cache to operate on."
	},
	{
		HRES_OLE_E_BLANK,
		"HRES_OLE_E_BLANK",
		"Uninitialized object."
	},
	{
		HRES_OLE_E_CLASSDIFF,
		"HRES_OLE_E_CLASSDIFF",
		"Linked object's source class has changed."
	},
	{
		HRES_OLE_E_CANT_GETMONIKER,
		"HRES_OLE_E_CANT_GETMONIKER",
		"Not able to get the moniker of the object."
	},
	{
		HRES_OLE_E_CANT_BINDTOSOURCE,
		"HRES_OLE_E_CANT_BINDTOSOURCE",
		"Not able to bind to the source."
	},
	{
		HRES_OLE_E_STATIC,
		"HRES_OLE_E_STATIC",
		"Object is static; operation not allowed."
	},
	{
		HRES_OLE_E_PROMPTSAVECANCELLED,
		"HRES_OLE_E_PROMPTSAVECANCELLED",
		"User canceled out of the Save dialog box."
	},
	{
		HRES_OLE_E_INVALIDRECT,
		"HRES_OLE_E_INVALIDRECT",
		"Invalid rectangle."
	},
	{
		HRES_OLE_E_WRONGCOMPOBJ,
		"HRES_OLE_E_WRONGCOMPOBJ",
		"compobj.dll is too old for the ole2.dll initialized."
	},
	{
		HRES_OLE_E_INVALIDHWND,
		"HRES_OLE_E_INVALIDHWND",
		"Invalid window handle."
	},
	{
		HRES_OLE_E_NOT_INPLACEACTIVE,
		"HRES_OLE_E_NOT_INPLACEACTIVE",
		"Object is not in any of the inplace active states."
	},
	{
		HRES_OLE_E_CANTCONVERT,
		"HRES_OLE_E_CANTCONVERT",
		"Not able to convert object."
	},
	{
		HRES_OLE_E_NOSTORAGE,
		"HRES_OLE_E_NOSTORAGE",
		"Not able to perform the operation because object is not given storage yet."
	},
	{
		HRES_DV_E_FORMATETC,
		"HRES_DV_E_FORMATETC",
		"Invalid FORMATETC structure."
	},
	{
		HRES_DV_E_DVTARGETDEVICE,
		"HRES_DV_E_DVTARGETDEVICE",
		"Invalid DVTARGETDEVICE structure."
	},
	{
		HRES_DV_E_STGMEDIUM,
		"HRES_DV_E_STGMEDIUM",
		"Invalid STDGMEDIUM structure."
	},
	{
		HRES_DV_E_STATDATA,
		"HRES_DV_E_STATDATA",
		"Invalid STATDATA structure."
	},
	{
		HRES_DV_E_LINDEX,
		"HRES_DV_E_LINDEX",
		"Invalid lindex."
	},
	{
		HRES_DV_E_TYMED,
		"HRES_DV_E_TYMED",
		"Invalid TYMED structure."
	},
	{
		HRES_DV_E_CLIPFORMAT,
		"HRES_DV_E_CLIPFORMAT",
		"Invalid clipboard format."
	},
	{
		HRES_DV_E_DVASPECT,
		"HRES_DV_E_DVASPECT",
		"Invalid aspects."
	},
	{
		HRES_DV_E_DVTARGETDEVICE_SIZE,
		"HRES_DV_E_DVTARGETDEVICE_SIZE",
		"The tdSize parameter of the DVTARGETDEVICE structure is invalid."
	},
	{
		HRES_DV_E_NOIVIEWOBJECT,
		"HRES_DV_E_NOIVIEWOBJECT",
		"Object does not support IViewObject interface."
	},
	{
		HRES_DRAGDROP_E_NOTREGISTERED,
		"HRES_DRAGDROP_E_NOTREGISTERED",
		"Trying to revoke a drop target that has not been registered."
	},
	{
		HRES_DRAGDROP_E_ALREADYREGISTERED,
		"HRES_DRAGDROP_E_ALREADYREGISTERED",
		"This window has already been registered as a drop target."
	},
	{
		HRES_DRAGDROP_E_INVALIDHWND,
		"HRES_DRAGDROP_E_INVALIDHWND",
		"Invalid window handle."
	},
	{
		HRES_CLASS_E_NOAGGREGATION,
		"HRES_CLASS_E_NOAGGREGATION",
		"Class does not support aggregation (or class object is remote)."
	},
	{
		HRES_CLASS_E_CLASSNOTAVAILABLE,
		"HRES_CLASS_E_CLASSNOTAVAILABLE",
		"ClassFactory cannot supply requested class."
	},
	{
		HRES_CLASS_E_NOTLICENSED,
		"HRES_CLASS_E_NOTLICENSED",
		"Class is not licensed for use."
	},
	{
		HRES_VIEW_E_DRAW,
		"HRES_VIEW_E_DRAW",
		"Error drawing view."
	},
	{
		HRES_REGDB_E_READREGDB,
		"HRES_REGDB_E_READREGDB",
		"Could not read key from registry."
	},
	{
		HRES_REGDB_E_WRITEREGDB,
		"HRES_REGDB_E_WRITEREGDB",
		"Could not write key to registry."
	},
	{
		HRES_REGDB_E_KEYMISSING,
		"HRES_REGDB_E_KEYMISSING",
		"Could not find the key in the registry."
	},
	{
		HRES_REGDB_E_INVALIDVALUE,
		"HRES_REGDB_E_INVALIDVALUE",
		"Invalid value for registry."
	},
	{
		HRES_REGDB_E_CLASSNOTREG,
		"HRES_REGDB_E_CLASSNOTREG",
		"Class not registered."
	},
	{
		HRES_REGDB_E_IIDNOTREG,
		"HRES_REGDB_E_IIDNOTREG",
		"Interface not registered."
	},
	{
		HRES_REGDB_E_BADTHREADINGMODEL,
		"HRES_REGDB_E_BADTHREADINGMODEL",
		"Threading model entry is not valid."
	},
	{
		HRES_CAT_E_CATIDNOEXIST,
		"HRES_CAT_E_CATIDNOEXIST",
		"CATID does not exist."
	},
	{
		HRES_CAT_E_NODESCRIPTION,
		"HRES_CAT_E_NODESCRIPTION",
		"Description not found."
	},
	{
		HRES_CS_E_PACKAGE_NOTFOUND,
		"HRES_CS_E_PACKAGE_NOTFOUND",
		"No package in the software installation data in Active Directory meets this criteria."
	},
	{
		HRES_CS_E_NOT_DELETABLE,
		"HRES_CS_E_NOT_DELETABLE",
		"Deleting this will break the referential integrity of the software installation data in Active Directory."
	},
	{
		HRES_CS_E_CLASS_NOTFOUND,
		"HRES_CS_E_CLASS_NOTFOUND",
		"The CLSID was not found in the software installation data in Active Directory."
	},
	{
		HRES_CS_E_INVALID_VERSION,
		"HRES_CS_E_INVALID_VERSION",
		"The software installation data in Active Directory is corrupt."
	},
	{
		HRES_CS_E_NO_CLASSSTORE,
		"HRES_CS_E_NO_CLASSSTORE",
		"There is no software installation data in Active Directory."
	},
	{
		HRES_CS_E_OBJECT_NOTFOUND,
		"HRES_CS_E_OBJECT_NOTFOUND",
		"There is no software installation data object in Active Directory."
	},
	{
		HRES_CS_E_OBJECT_ALREADY_EXISTS,
		"HRES_CS_E_OBJECT_ALREADY_EXISTS",
		"The software installation data object in Active Directory already exists."
	},
	{
		HRES_CS_E_INVALID_PATH,
		"HRES_CS_E_INVALID_PATH",
		"The path to the software installation data in Active Directory is not correct."
	},
	{
		HRES_CS_E_NETWORK_ERROR,
		"HRES_CS_E_NETWORK_ERROR",
		"A network error interrupted the operation."
	},
	{
		HRES_CS_E_ADMIN_LIMIT_EXCEEDED,
		"HRES_CS_E_ADMIN_LIMIT_EXCEEDED",
		"The size of this object exceeds the maximum size set by the administrator."
	},
	{
		HRES_CS_E_SCHEMA_MISMATCH,
		"HRES_CS_E_SCHEMA_MISMATCH",
		"The schema for the software installation data in Active Directory does not match the required schema."
	},
	{
		HRES_CS_E_INTERNAL_ERROR,
		"HRES_CS_E_INTERNAL_ERROR",
		"An error occurred in the software installation data in Active Directory."
	},
	{
		HRES_CACHE_E_NOCACHE_UPDATED,
		"HRES_CACHE_E_NOCACHE_UPDATED",
		"Cache not updated."
	},
	{
		HRES_OLEOBJ_E_NOVERBS,
		"HRES_OLEOBJ_E_NOVERBS",
		"No verbs for OLE object."
	},
	{
		HRES_OLEOBJ_E_INVALIDVERB,
		"HRES_OLEOBJ_E_INVALIDVERB",
		"Invalid verb for OLE object."
	},
	{
		HRES_INPLACE_E_NOTUNDOABLE,
		"HRES_INPLACE_E_NOTUNDOABLE",
		"Undo is not available."
	},
	{
		HRES_INPLACE_E_NOTOOLSPACE,
		"HRES_INPLACE_E_NOTOOLSPACE",
		"Space for tools is not available."
	},
	{
		HRES_CONVERT10_E_OLESTREAM_GET,
		"HRES_CONVERT10_E_OLESTREAM_GET",
		"OLESTREAM Get method failed."
	},
	{
		HRES_CONVERT10_E_OLESTREAM_PUT,
		"HRES_CONVERT10_E_OLESTREAM_PUT",
		"OLESTREAM Put method failed."
	},
	{
		HRES_CONVERT10_E_OLESTREAM_FMT,
		"HRES_CONVERT10_E_OLESTREAM_FMT",
		"Contents of the OLESTREAM not in correct format."
	},
	{
		HRES_CONVERT10_E_OLESTREAM_BITMAP_TO_DIB,
		"HRES_CONVERT10_E_OLESTREAM_BITMAP_TO_DIB",
		"There was an error in a Windows GDI call while converting the bitmap to a device-independent bitmap (DIB)."
	},
	{
		HRES_CONVERT10_E_STG_FMT,
		"HRES_CONVERT10_E_STG_FMT",
		"Contents of the IStorage not in correct format."
	},
	{
		HRES_CONVERT10_E_STG_NO_STD_STREAM,
		"HRES_CONVERT10_E_STG_NO_STD_STREAM",
		"Contents of IStorage is missing one of the standard streams."
	},
	{
		HRES_CONVERT10_E_STG_DIB_TO_BITMAP,
		"HRES_CONVERT10_E_STG_DIB_TO_BITMAP",
		"There was an error in a Windows Graphics Device Interface (GDI) call while converting the DIB to a bitmap."
	},
	{
		HRES_CLIPBRD_E_CANT_OPEN,
		"HRES_CLIPBRD_E_CANT_OPEN",
		"OpenClipboard failed."
	},
	{
		HRES_CLIPBRD_E_CANT_EMPTY,
		"HRES_CLIPBRD_E_CANT_EMPTY",
		"EmptyClipboard failed."
	},
	{
		HRES_CLIPBRD_E_CANT_SET,
		"HRES_CLIPBRD_E_CANT_SET",
		"SetClipboard failed."
	},
	{
		HRES_CLIPBRD_E_BAD_DATA,
		"HRES_CLIPBRD_E_BAD_DATA",
		"Data on clipboard is invalid."
	},
	{
		HRES_CLIPBRD_E_CANT_CLOSE,
		"HRES_CLIPBRD_E_CANT_CLOSE",
		"CloseClipboard failed."
	},
	{
		HRES_MK_E_CONNECTMANUALLY,
		"HRES_MK_E_CONNECTMANUALLY",
		"Moniker needs to be connected manually."
	},
	{
		HRES_MK_E_EXCEEDEDDEADLINE,
		"HRES_MK_E_EXCEEDEDDEADLINE",
		"Operation exceeded deadline."
	},
	{
		HRES_MK_E_NEEDGENERIC,
		"HRES_MK_E_NEEDGENERIC",
		"Moniker needs to be generic."
	},
	{
		HRES_MK_E_UNAVAILABLE,
		"HRES_MK_E_UNAVAILABLE",
		"Operation unavailable."
	},
	{
		HRES_MK_E_SYNTAX,
		"HRES_MK_E_SYNTAX",
		"Invalid syntax."
	},
	{
		HRES_MK_E_NOOBJECT,
		"HRES_MK_E_NOOBJECT",
		"No object for moniker."
	},
	{
		HRES_MK_E_INVALIDEXTENSION,
		"HRES_MK_E_INVALIDEXTENSION",
		"Bad extension for file."
	},
	{
		HRES_MK_E_INTERMEDIATEINTERFACENOTSUPPORTED,
		"HRES_MK_E_INTERMEDIATEINTERFACENOTSUPPORTED",
		"Intermediate operation failed."
	},
	{
		HRES_MK_E_NOTBINDABLE,
		"HRES_MK_E_NOTBINDABLE",
		"Moniker is not bindable."
	},
	{
		HRES_MK_E_NOTBOUND,
		"HRES_MK_E_NOTBOUND",
		"Moniker is not bound."
	},
	{
		HRES_MK_E_CANTOPENFILE,
		"HRES_MK_E_CANTOPENFILE",
		"Moniker cannot open file."
	},
	{
		HRES_MK_E_MUSTBOTHERUSER,
		"HRES_MK_E_MUSTBOTHERUSER",
		"User input required for operation to succeed."
	},
	{
		HRES_MK_E_NOINVERSE,
		"HRES_MK_E_NOINVERSE",
		"Moniker class has no inverse."
	},
	{
		HRES_MK_E_NOSTORAGE,
		"HRES_MK_E_NOSTORAGE",
		"Moniker does not refer to storage."
	},
	{
		HRES_MK_E_NOPREFIX,
		"HRES_MK_E_NOPREFIX",
		"No common prefix."
	},
	{
		HRES_MK_E_ENUMERATION_FAILED,
		"HRES_MK_E_ENUMERATION_FAILED",
		"Moniker could not be enumerated."
	},
	{
		HRES_CO_E_NOTINITIALIZED,
		"HRES_CO_E_NOTINITIALIZED",
		"CoInitialize has not been called."
	},
	{
		HRES_CO_E_ALREADYINITIALIZED,
		"HRES_CO_E_ALREADYINITIALIZED",
		"CoInitialize has already been called."
	},
	{
		HRES_CO_E_CANTDETERMINECLASS,
		"HRES_CO_E_CANTDETERMINECLASS",
		"Class of object cannot be determined."
	},
	{
		HRES_CO_E_CLASSSTRING,
		"HRES_CO_E_CLASSSTRING",
		"Invalid class string."
	},
	{
		HRES_CO_E_IIDSTRING,
		"HRES_CO_E_IIDSTRING",
		"Invalid interface string."
	},
	{
		HRES_CO_E_APPNOTFOUND,
		"HRES_CO_E_APPNOTFOUND",
		"Application not found."
	},
	{
		HRES_CO_E_APPSINGLEUSE,
		"HRES_CO_E_APPSINGLEUSE",
		"Application cannot be run more than once."
	},
	{
		HRES_CO_E_ERRORINAPP,
		"HRES_CO_E_ERRORINAPP",
		"Some error in application."
	},
	{
		HRES_CO_E_DLLNOTFOUND,
		"HRES_CO_E_DLLNOTFOUND",
		"DLL for class not found."
	},
	{
		HRES_CO_E_ERRORINDLL,
		"HRES_CO_E_ERRORINDLL",
		"Error in the DLL."
	},
	{
		HRES_CO_E_WRONGOSFORAPP,
		"HRES_CO_E_WRONGOSFORAPP",
		"Wrong operating system or operating system version for application."
	},
	{
		HRES_CO_E_OBJNOTREG,
		"HRES_CO_E_OBJNOTREG",
		"Object is not registered."
	},
	{
		HRES_CO_E_OBJISREG,
		"HRES_CO_E_OBJISREG",
		"Object is already registered."
	},
	{
		HRES_CO_E_OBJNOTCONNECTED,
		"HRES_CO_E_OBJNOTCONNECTED",
		"Object is not connected to server."
	},
	{
		HRES_CO_E_APPDIDNTREG,
		"HRES_CO_E_APPDIDNTREG",
		"Application was launched, but it did not register a class factory."
	},
	{
		HRES_CO_E_RELEASED,
		"HRES_CO_E_RELEASED",
		"Object has been released."
	},
	{
		HRES_EVENT_E_ALL_SUBSCRIBERS_FAILED,
		"HRES_EVENT_E_ALL_SUBSCRIBERS_FAILED",
		"An event was unable to invoke any of the subscribers."
	},
	{
		HRES_EVENT_E_QUERYSYNTAX,
		"HRES_EVENT_E_QUERYSYNTAX",
		"A syntax error occurred trying to evaluate a query string."
	},
	{
		HRES_EVENT_E_QUERYFIELD,
		"HRES_EVENT_E_QUERYFIELD",
		"An invalid field name was used in a query string."
	},
	{
		HRES_EVENT_E_INTERNALEXCEPTION,
		"HRES_EVENT_E_INTERNALEXCEPTION",
		"An unexpected exception was raised."
	},
	{
		HRES_EVENT_E_INTERNALERROR,
		"HRES_EVENT_E_INTERNALERROR",
		"An unexpected internal error was detected."
	},
	{
		HRES_EVENT_E_INVALID_PER_USER_SID,
		"HRES_EVENT_E_INVALID_PER_USER_SID",
		"The owner security identifier (SID) on a per-user subscription does not exist."
	},
	{
		HRES_EVENT_E_USER_EXCEPTION,
		"HRES_EVENT_E_USER_EXCEPTION",
		"A user-supplied component or subscriber raised an exception."
	},
	{
		HRES_EVENT_E_TOO_MANY_METHODS,
		"HRES_EVENT_E_TOO_MANY_METHODS",
		"An interface has too many methods to fire events from."
	},
	{
		HRES_EVENT_E_MISSING_EVENTCLASS,
		"HRES_EVENT_E_MISSING_EVENTCLASS",
		"A subscription cannot be stored unless its event class already exists."
	},
	{
		HRES_EVENT_E_NOT_ALL_REMOVED,
		"HRES_EVENT_E_NOT_ALL_REMOVED",
		"Not all the objects requested could be removed."
	},
	{
		HRES_EVENT_E_COMPLUS_NOT_INSTALLED,
		"HRES_EVENT_E_COMPLUS_NOT_INSTALLED",
		"COM+ is required for this operation, but it is not installed."
	},
	{
		HRES_EVENT_E_CANT_MODIFY_OR_DELETE_UNCONFIGURED_OBJECT,
		"HRES_EVENT_E_CANT_MODIFY_OR_DELETE_UNCONFIGURED_OBJECT",
		"Cannot modify or delete an object that was not added using the COM+ Administrative SDK."
	},
	{
		HRES_EVENT_E_CANT_MODIFY_OR_DELETE_CONFIGURED_OBJECT,
		"HRES_EVENT_E_CANT_MODIFY_OR_DELETE_CONFIGURED_OBJECT",
		"Cannot modify or delete an object that was added using the COM+ Administrative SDK."
	},
	{
		HRES_EVENT_E_INVALID_EVENT_CLASS_PARTITION,
		"HRES_EVENT_E_INVALID_EVENT_CLASS_PARTITION",
		"The event class for this subscription is in an invalid partition."
	},
	{
		HRES_EVENT_E_PER_USER_SID_NOT_LOGGED_ON,
		"HRES_EVENT_E_PER_USER_SID_NOT_LOGGED_ON",
		"The owner of the PerUser subscription is not logged on to the system specified."
	},
	{
		HRES_SCHED_E_TRIGGER_NOT_FOUND,
		"HRES_SCHED_E_TRIGGER_NOT_FOUND",
		"Trigger not found."
	},
	{
		HRES_SCHED_E_TASK_NOT_READY,
		"HRES_SCHED_E_TASK_NOT_READY",
		"One or more of the properties that are needed to run this task have not been set."
	},
	{
		HRES_SCHED_E_TASK_NOT_RUNNING,
		"HRES_SCHED_E_TASK_NOT_RUNNING",
		"There is no running instance of the task."
	},
	{
		HRES_SCHED_E_SERVICE_NOT_INSTALLED,
		"HRES_SCHED_E_SERVICE_NOT_INSTALLED",
		"The Task Scheduler service is not installed on this computer."
	},
	{
		HRES_SCHED_E_CANNOT_OPEN_TASK,
		"HRES_SCHED_E_CANNOT_OPEN_TASK",
		"The task object could not be opened."
	},
	{
		HRES_SCHED_E_INVALID_TASK,
		"HRES_SCHED_E_INVALID_TASK",
		"The object is either an invalid task object or is not a task object."
	},
	{
		HRES_SCHED_E_ACCOUNT_INFORMATION_NOT_SET,
		"HRES_SCHED_E_ACCOUNT_INFORMATION_NOT_SET",
		"No account information could be found in the Task Scheduler security database for the task indicated."
	},
	{
		HRES_SCHED_E_ACCOUNT_NAME_NOT_FOUND,
		"HRES_SCHED_E_ACCOUNT_NAME_NOT_FOUND",
		"Unable to establish existence of the account specified."
	},
	{
		HRES_SCHED_E_ACCOUNT_DBASE_CORRUPT,
		"HRES_SCHED_E_ACCOUNT_DBASE_CORRUPT",
		"Corruption was detected in the Task Scheduler security database; the database has been reset."
	},
	{
		HRES_SCHED_E_NO_SECURITY_SERVICES,
		"HRES_SCHED_E_NO_SECURITY_SERVICES",
		"Task Scheduler security services are available only on Windows NT operating system."
	},
	{
		HRES_SCHED_E_UNKNOWN_OBJECT_VERSION,
		"HRES_SCHED_E_UNKNOWN_OBJECT_VERSION",
		"The task object version is either unsupported or invalid."
	},
	{
		HRES_SCHED_E_UNSUPPORTED_ACCOUNT_OPTION,
		"HRES_SCHED_E_UNSUPPORTED_ACCOUNT_OPTION",
		"The task has been configured with an unsupported combination of account settings and run-time options."
	},
	{
		HRES_SCHED_E_SERVICE_NOT_RUNNING,
		"HRES_SCHED_E_SERVICE_NOT_RUNNING",
		"The Task Scheduler service is not running."
	},
	{
		HRES_SCHED_E_UNEXPECTEDNODE,
		"HRES_SCHED_E_UNEXPECTEDNODE",
		"The task XML contains an unexpected node."
	},
	{
		HRES_SCHED_E_NAMESPACE,
		"HRES_SCHED_E_NAMESPACE",
		"The task XML contains an element or attribute from an unexpected namespace."
	},
	{
		HRES_SCHED_E_INVALIDVALUE,
		"HRES_SCHED_E_INVALIDVALUE",
		"The task XML contains a value that is incorrectly formatted or out of range."
	},
	{
		HRES_SCHED_E_MISSINGNODE,
		"HRES_SCHED_E_MISSINGNODE",
		"The task XML is missing a required element or attribute."
	},
	{
		HRES_SCHED_E_MALFORMEDXML,
		"HRES_SCHED_E_MALFORMEDXML",
		"The task XML is malformed."
	},
	{
		HRES_SCHED_E_TOO_MANY_NODES,
		"HRES_SCHED_E_TOO_MANY_NODES",
		"The task XML contains too many nodes of the same type."
	},
	{
		HRES_SCHED_E_PAST_END_BOUNDARY,
		"HRES_SCHED_E_PAST_END_BOUNDARY",
		"The task cannot be started after the trigger's end boundary."
	},
	{
		HRES_SCHED_E_ALREADY_RUNNING,
		"HRES_SCHED_E_ALREADY_RUNNING",
		"An instance of this task is already running."
	},
	{
		HRES_SCHED_E_USER_NOT_LOGGED_ON,
		"HRES_SCHED_E_USER_NOT_LOGGED_ON",
		"The task will not run because the user is not logged on."
	},
	{
		HRES_SCHED_E_INVALID_TASK_HASH,
		"HRES_SCHED_E_INVALID_TASK_HASH",
		"The task image is corrupt or has been tampered with."
	},
	{
		HRES_SCHED_E_SERVICE_NOT_AVAILABLE,
		"HRES_SCHED_E_SERVICE_NOT_AVAILABLE",
		"The Task Scheduler service is not available."
	},
	{
		HRES_SCHED_E_SERVICE_TOO_BUSY,
		"HRES_SCHED_E_SERVICE_TOO_BUSY",
		"The Task Scheduler service is too busy to handle your request. Try again later."
	},
	{
		HRES_SCHED_E_TASK_ATTEMPTED,
		"HRES_SCHED_E_TASK_ATTEMPTED",
		"The Task Scheduler service attempted to run the task, but the task did not run due to one of the constraints in the task definition."
	},
	{
		HRES_XACT_E_ALREADYOTHERSINGLEPHASE,
		"HRES_XACT_E_ALREADYOTHERSINGLEPHASE",
		"Another single phase resource manager has already been enlisted in this transaction."
	},
	{
		HRES_XACT_E_CANTRETAIN,
		"HRES_XACT_E_CANTRETAIN",
		"A retaining commit or abort is not supported."
	},
	{
		HRES_XACT_E_COMMITFAILED,
		"HRES_XACT_E_COMMITFAILED",
		"The transaction failed to commit for an unknown reason. The transaction was aborted."
	},
	{
		HRES_XACT_E_COMMITPREVENTED,
		"HRES_XACT_E_COMMITPREVENTED",
		"Cannot call commit on this transaction object because the calling application did not initiate the transaction."
	},
	{
		HRES_XACT_E_HEURISTICABORT,
		"HRES_XACT_E_HEURISTICABORT",
		"Instead of committing, the resource heuristically aborted."
	},
	{
		HRES_XACT_E_HEURISTICCOMMIT,
		"HRES_XACT_E_HEURISTICCOMMIT",
		"Instead of aborting, the resource heuristically committed."
	},
	{
		HRES_XACT_E_HEURISTICDAMAGE,
		"HRES_XACT_E_HEURISTICDAMAGE",
		"Some of the states of the resource were committed while others were aborted, likely because of heuristic decisions."
	},
	{
		HRES_XACT_E_HEURISTICDANGER,
		"HRES_XACT_E_HEURISTICDANGER",
		"Some of the states of the resource might have been committed while others were aborted, likely because of heuristic decisions."
	},
	{
		HRES_XACT_E_ISOLATIONLEVEL,
		"HRES_XACT_E_ISOLATIONLEVEL",
		"The requested isolation level is not valid or supported."
	},
	{
		HRES_XACT_E_NOASYNC,
		"HRES_XACT_E_NOASYNC",
		"The transaction manager does not support an asynchronous operation for this method."
	},
	{
		HRES_XACT_E_NOENLIST,
		"HRES_XACT_E_NOENLIST",
		"Unable to enlist in the transaction."
	},
	{
		HRES_XACT_E_NOISORETAIN,
		"HRES_XACT_E_NOISORETAIN",
		"The requested semantics of retention of isolation across retaining commit and abort boundaries cannot be supported by this transaction implementation, or isoFlags was not equal to 0."
	},
	{
		HRES_XACT_E_NORESOURCE,
		"HRES_XACT_E_NORESOURCE",
		"There is no resource presently associated with this enlistment."
	},
	{
		HRES_XACT_E_NOTCURRENT,
		"HRES_XACT_E_NOTCURRENT",
		"The transaction failed to commit due to the failure of optimistic concurrency control in at least one of the resource managers."
	},
	{
		HRES_XACT_E_NOTRANSACTION,
		"HRES_XACT_E_NOTRANSACTION",
		"The transaction has already been implicitly or explicitly committed or aborted."
	},
	{
		HRES_XACT_E_NOTSUPPORTED,
		"HRES_XACT_E_NOTSUPPORTED",
		"An invalid combination of flags was specified."
	},
	{
		HRES_XACT_E_UNKNOWNRMGRID,
		"HRES_XACT_E_UNKNOWNRMGRID",
		"The resource manager ID is not associated with this transaction or the transaction manager."
	},
	{
		HRES_XACT_E_WRONGSTATE,
		"HRES_XACT_E_WRONGSTATE",
		"This method was called in the wrong state."
	},
	{
		HRES_XACT_E_WRONGUOW,
		"HRES_XACT_E_WRONGUOW",
		"The indicated unit of work does not match the unit of work expected by the resource manager."
	},
	{
		HRES_XACT_E_XTIONEXISTS,
		"HRES_XACT_E_XTIONEXISTS",
		"An enlistment in a transaction already exists."
	},
	{
		HRES_XACT_E_NOIMPORTOBJECT,
		"HRES_XACT_E_NOIMPORTOBJECT",
		"An import object for the transaction could not be found."
	},
	{
		HRES_XACT_E_INVALIDCOOKIE,
		"HRES_XACT_E_INVALIDCOOKIE",
		"The transaction cookie is invalid."
	},
	{
		HRES_XACT_E_INDOUBT,
		"HRES_XACT_E_INDOUBT",
		"The transaction status is in doubt. A communication failure occurred, or a transaction manager or resource manager has failed."
	},
	{
		HRES_XACT_E_NOTIMEOUT,
		"HRES_XACT_E_NOTIMEOUT",
		"A time-out was specified, but time-outs are not supported."
	},
	{
		HRES_XACT_E_ALREADYINPROGRESS,
		"HRES_XACT_E_ALREADYINPROGRESS",
		"The requested operation is already in progress for the transaction."
	},
	{
		HRES_XACT_E_ABORTED,
		"HRES_XACT_E_ABORTED",
		"The transaction has already been aborted."
	},
	{
		HRES_XACT_E_LOGFULL,
		"HRES_XACT_E_LOGFULL",
		"The Transaction Manager returned a log full error."
	},
	{
		HRES_XACT_E_TMNOTAVAILABLE,
		"HRES_XACT_E_TMNOTAVAILABLE",
		"The transaction manager is not available."
	},
	{
		HRES_XACT_E_CONNECTION_DOWN,
		"HRES_XACT_E_CONNECTION_DOWN",
		"A connection with the transaction manager was lost."
	},
	{
		HRES_XACT_E_CONNECTION_DENIED,
		"HRES_XACT_E_CONNECTION_DENIED",
		"A request to establish a connection with the transaction manager was denied."
	},
	{
		HRES_XACT_E_REENLISTTIMEOUT,
		"HRES_XACT_E_REENLISTTIMEOUT",
		"Resource manager reenlistment to determine transaction status timed out."
	},
	{
		HRES_XACT_E_TIP_CONNECT_FAILED,
		"HRES_XACT_E_TIP_CONNECT_FAILED",
		"The transaction manager failed to establish a connection with another Transaction Internet Protocol (TIP) transaction manager."
	},
	{
		HRES_XACT_E_TIP_PROTOCOL_ERROR,
		"HRES_XACT_E_TIP_PROTOCOL_ERROR",
		"The transaction manager encountered a protocol error with another TIP transaction manager."
	},
	{
		HRES_XACT_E_TIP_PULL_FAILED,
		"HRES_XACT_E_TIP_PULL_FAILED",
		"The transaction manager could not propagate a transaction from another TIP transaction manager."
	},
	{
		HRES_XACT_E_DEST_TMNOTAVAILABLE,
		"HRES_XACT_E_DEST_TMNOTAVAILABLE",
		"The transaction manager on the destination machine is not available."
	},
	{
		HRES_XACT_E_TIP_DISABLED,
		"HRES_XACT_E_TIP_DISABLED",
		"The transaction manager has disabled its support for TIP."
	},
	{
		HRES_XACT_E_NETWORK_TX_DISABLED,
		"HRES_XACT_E_NETWORK_TX_DISABLED",
		"The transaction manager has disabled its support for remote or network transactions."
	},
	{
		HRES_XACT_E_PARTNER_NETWORK_TX_DISABLED,
		"HRES_XACT_E_PARTNER_NETWORK_TX_DISABLED",
		"The partner transaction manager has disabled its support for remote or network transactions."
	},
	{
		HRES_XACT_E_XA_TX_DISABLED,
		"HRES_XACT_E_XA_TX_DISABLED",
		"The transaction manager has disabled its support for XA transactions."
	},
	{
		HRES_XACT_E_UNABLE_TO_READ_DTC_CONFIG,
		"HRES_XACT_E_UNABLE_TO_READ_DTC_CONFIG",
		"Microsoft Distributed Transaction Coordinator (MSDTC) was unable to read its configuration information."
	},
	{
		HRES_XACT_E_UNABLE_TO_LOAD_DTC_PROXY,
		"HRES_XACT_E_UNABLE_TO_LOAD_DTC_PROXY",
		"MSDTC was unable to load the DTC proxy DLL."
	},
	{
		HRES_XACT_E_ABORTING,
		"HRES_XACT_E_ABORTING",
		"The local transaction has aborted."
	},
	{
		HRES_XACT_E_CLERKNOTFOUND,
		"HRES_XACT_E_CLERKNOTFOUND",
		"The specified CRM clerk was not found. It might have completed before it could be held."
	},
	{
		HRES_XACT_E_CLERKEXISTS,
		"HRES_XACT_E_CLERKEXISTS",
		"The specified CRM clerk does not exist."
	},
	{
		HRES_XACT_E_RECOVERYINPROGRESS,
		"HRES_XACT_E_RECOVERYINPROGRESS",
		"Recovery of the CRM log file is still in progress."
	},
	{
		HRES_XACT_E_TRANSACTIONCLOSED,
		"HRES_XACT_E_TRANSACTIONCLOSED",
		"The transaction has completed, and the log records have been discarded from the log file. They are no longer available."
	},
	{
		HRES_XACT_E_INVALIDLSN,
		"HRES_XACT_E_INVALIDLSN",
		"lsnToRead is outside of the current limits of the log"
	},
	{
		HRES_XACT_E_REPLAYREQUEST,
		"HRES_XACT_E_REPLAYREQUEST",
		"The COM+ Compensating Resource Manager has records it wishes to replay."
	},
	{
		HRES_XACT_E_CONNECTION_REQUEST_DENIED,
		"HRES_XACT_E_CONNECTION_REQUEST_DENIED",
		"The request to connect to the specified transaction coordinator was denied."
	},
	{
		HRES_XACT_E_TOOMANY_ENLISTMENTS,
		"HRES_XACT_E_TOOMANY_ENLISTMENTS",
		"The maximum number of enlistments for the specified transaction has been reached."
	},
	{
		HRES_XACT_E_DUPLICATE_GUID,
		"HRES_XACT_E_DUPLICATE_GUID",
		"A resource manager with the same identifier is already registered with the specified transaction coordinator."
	},
	{
		HRES_XACT_E_NOTSINGLEPHASE,
		"HRES_XACT_E_NOTSINGLEPHASE",
		"The prepare request given was not eligible for single-phase optimizations."
	},
	{
		HRES_XACT_E_RECOVERYALREADYDONE,
		"HRES_XACT_E_RECOVERYALREADYDONE",
		"RecoveryComplete has already been called for the given resource manager."
	},
	{
		HRES_XACT_E_PROTOCOL,
		"HRES_XACT_E_PROTOCOL",
		"The interface call made was incorrect for the current state of the protocol."
	},
	{
		HRES_XACT_E_RM_FAILURE,
		"HRES_XACT_E_RM_FAILURE",
		"The xa_open call failed for the XA resource."
	},
	{
		HRES_XACT_E_RECOVERY_FAILED,
		"HRES_XACT_E_RECOVERY_FAILED",
		"The xa_recover call failed for the XA resource."
	},
	{
		HRES_XACT_E_LU_NOT_FOUND,
		"HRES_XACT_E_LU_NOT_FOUND",
		"The logical unit of work specified cannot be found."
	},
	{
		HRES_XACT_E_DUPLICATE_LU,
		"HRES_XACT_E_DUPLICATE_LU",
		"The specified logical unit of work already exists."
	},
	{
		HRES_XACT_E_LU_NOT_CONNECTED,
		"HRES_XACT_E_LU_NOT_CONNECTED",
		"Subordinate creation failed. The specified logical unit of work was not connected."
	},
	{
		HRES_XACT_E_DUPLICATE_TRANSID,
		"HRES_XACT_E_DUPLICATE_TRANSID",
		"A transaction with the given identifier already exists."
	},
	{
		HRES_XACT_E_LU_BUSY,
		"HRES_XACT_E_LU_BUSY",
		"The resource is in use."
	},
	{
		HRES_XACT_E_LU_NO_RECOVERY_PROCESS,
		"HRES_XACT_E_LU_NO_RECOVERY_PROCESS",
		"The LU Recovery process is down."
	},
	{
		HRES_XACT_E_LU_DOWN,
		"HRES_XACT_E_LU_DOWN",
		"The remote session was lost."
	},
	{
		HRES_XACT_E_LU_RECOVERING,
		"HRES_XACT_E_LU_RECOVERING",
		"The resource is currently recovering."
	},
	{
		HRES_XACT_E_LU_RECOVERY_MISMATCH,
		"HRES_XACT_E_LU_RECOVERY_MISMATCH",
		"There was a mismatch in driving recovery."
	},
	{
		HRES_XACT_E_RM_UNAVAILABLE,
		"HRES_XACT_E_RM_UNAVAILABLE",
		"An error occurred with the XA resource."
	},
	{
		HRES_CONTEXT_E_ABORTED,
		"HRES_CONTEXT_E_ABORTED",
		"The root transaction wanted to commit, but the transaction aborted."
	},
	{
		HRES_CONTEXT_E_ABORTING,
		"HRES_CONTEXT_E_ABORTING",
		"The COM+ component on which the method call was made has a transaction that has already aborted or is in the process of aborting."
	},
	{
		HRES_CONTEXT_E_NOCONTEXT,
		"HRES_CONTEXT_E_NOCONTEXT",
		"There is no Microsoft Transaction Server (MTS) object context."
	},
	{
		HRES_CONTEXT_E_WOULD_DEADLOCK,
		"HRES_CONTEXT_E_WOULD_DEADLOCK",
		"The component is configured to use synchronization, and this method call would cause a deadlock to occur."
	},
	{
		HRES_CONTEXT_E_SYNCH_TIMEOUT,
		"HRES_CONTEXT_E_SYNCH_TIMEOUT",
		"The component is configured to use synchronization, and a thread has timed out waiting to enter the context."
	},
	{
		HRES_CONTEXT_E_OLDREF,
		"HRES_CONTEXT_E_OLDREF",
		"You made a method call on a COM+ component that has a transaction that has already committed or aborted."
	},
	{
		HRES_CONTEXT_E_ROLENOTFOUND,
		"HRES_CONTEXT_E_ROLENOTFOUND",
		"The specified role was not configured for the application."
	},
	{
		HRES_CONTEXT_E_TMNOTAVAILABLE,
		"HRES_CONTEXT_E_TMNOTAVAILABLE",
		"COM+ was unable to talk to the MSDTC."
	},
	{
		HRES_CO_E_ACTIVATIONFAILED,
		"HRES_CO_E_ACTIVATIONFAILED",
		"An unexpected error occurred during COM+ activation."
	},
	{
		HRES_CO_E_ACTIVATIONFAILED_EVENTLOGGED,
		"HRES_CO_E_ACTIVATIONFAILED_EVENTLOGGED",
		"COM+ activation failed. Check the event log for more information."
	},
	{
		HRES_CO_E_ACTIVATIONFAILED_CATALOGERROR,
		"HRES_CO_E_ACTIVATIONFAILED_CATALOGERROR",
		"COM+ activation failed due to a catalog or configuration error."
	},
	{
		HRES_CO_E_ACTIVATIONFAILED_TIMEOUT,
		"HRES_CO_E_ACTIVATIONFAILED_TIMEOUT",
		"COM+ activation failed because the activation could not be completed in the specified amount of time."
	},
	{
		HRES_CO_E_INITIALIZATIONFAILED,
		"HRES_CO_E_INITIALIZATIONFAILED",
		"COM+ activation failed because an initialization function failed. Check the event log for more information."
	},
	{
		HRES_CONTEXT_E_NOJIT,
		"HRES_CONTEXT_E_NOJIT",
		"The requested operation requires that just-in-time (JIT) be in the current context, and it is not."
	},
	{
		HRES_CONTEXT_E_NOTRANSACTION,
		"HRES_CONTEXT_E_NOTRANSACTION",
		"The requested operation requires that the current context have a transaction, and it does not."
	},
	{
		HRES_CO_E_THREADINGMODEL_CHANGED,
		"HRES_CO_E_THREADINGMODEL_CHANGED",
		"The components threading model has changed after install into a COM+ application. Re-install component."
	},
	{
		HRES_CO_E_NOIISINTRINSICS,
		"HRES_CO_E_NOIISINTRINSICS",
		"Internet Information Services (IIS) intrinsics not available. Start your work with IIS."
	},
	{
		HRES_CO_E_NOCOOKIES,
		"HRES_CO_E_NOCOOKIES",
		"An attempt to write a cookie failed."
	},
	{
		HRES_CO_E_DBERROR,
		"HRES_CO_E_DBERROR",
		"An attempt to use a database generated a database-specific error."
	},
	{
		HRES_CO_E_NOTPOOLED,
		"HRES_CO_E_NOTPOOLED",
		"The COM+ component you created must use object pooling to work."
	},
	{
		HRES_CO_E_NOTCONSTRUCTED,
		"HRES_CO_E_NOTCONSTRUCTED",
		"The COM+ component you created must use object construction to work correctly."
	},
	{
		HRES_CO_E_NOSYNCHRONIZATION,
		"HRES_CO_E_NOSYNCHRONIZATION",
		"The COM+ component requires synchronization, and it is not configured for it."
	},
	{
		HRES_CO_E_ISOLEVELMISMATCH,
		"HRES_CO_E_ISOLEVELMISMATCH",
		"The TxIsolation Level property for the COM+ component being created is stronger than the TxIsolationLevel for the root."
	},
	{
		HRES_CO_E_CALL_OUT_OF_TX_SCOPE_NOT_ALLOWED,
		"HRES_CO_E_CALL_OUT_OF_TX_SCOPE_NOT_ALLOWED",
		"The component attempted to make a cross-context call between invocations of EnterTransactionScope and ExitTransactionScope. This is not allowed. Cross-context calls cannot be made while inside a transaction scope."
	},
	{
		HRES_CO_E_EXIT_TRANSACTION_SCOPE_NOT_CALLED,
		"HRES_CO_E_EXIT_TRANSACTION_SCOPE_NOT_CALLED",
		"The component made a call to EnterTransactionScope, but did not make a corresponding call to ExitTransactionScope before returning."
	},
	{
		HRES_E_ACCESSDENIED,
		"HRES_E_ACCESSDENIED",
		"General access denied error."
	},
	{
		HRES_E_OUTOFMEMORY,
		"HRES_E_OUTOFMEMORY",
		"The server does not have enough memory for the new channel."
	},
	{
		HRES_ERROR_NOT_SUPPORTED,
		"HRES_ERROR_NOT_SUPPORTED",
		"The server cannot support a client request for a dynamic virtual channel."
	},
	{
		HRES_E_INVALIDARG,
		"HRES_E_INVALIDARG",
		"One or more arguments are invalid."
	},
	{
		HRES_ERROR_DISK_FULL,
		"HRES_ERROR_DISK_FULL",
		"There is not enough space on the disk."
	},
	{
		HRES_CO_E_CLASS_CREATE_FAILED,
		"HRES_CO_E_CLASS_CREATE_FAILED",
		"Attempt to create a class object failed."
	},
	{
		HRES_CO_E_SCM_ERROR,
		"HRES_CO_E_SCM_ERROR",
		"OLE service could not bind object."
	},
	{
		HRES_CO_E_SCM_RPC_FAILURE,
		"HRES_CO_E_SCM_RPC_FAILURE",
		"RPC communication failed with OLE service."
	},
	{
		HRES_CO_E_BAD_PATH,
		"HRES_CO_E_BAD_PATH",
		"Bad path to object."
	},
	{
		HRES_CO_E_SERVER_EXEC_FAILURE,
		"HRES_CO_E_SERVER_EXEC_FAILURE",
		"Server execution failed."
	},
	{
		HRES_CO_E_OBJSRV_RPC_FAILURE,
		"HRES_CO_E_OBJSRV_RPC_FAILURE",
		"OLE service could not communicate with the object server."
	},
	{
		HRES_MK_E_NO_NORMALIZED,
		"HRES_MK_E_NO_NORMALIZED",
		"Moniker path could not be normalized."
	},
	{
		HRES_CO_E_SERVER_STOPPING,
		"HRES_CO_E_SERVER_STOPPING",
		"Object server is stopping when OLE service contacts it."
	},
	{
		HRES_MEM_E_INVALID_ROOT,
		"HRES_MEM_E_INVALID_ROOT",
		"An invalid root block pointer was specified."
	},
	{
		HRES_MEM_E_INVALID_LINK,
		"HRES_MEM_E_INVALID_LINK",
		"An allocation chain contained an invalid link pointer."
	},
	{
		HRES_MEM_E_INVALID_SIZE,
		"HRES_MEM_E_INVALID_SIZE",
		"The requested allocation size was too large."
	},
	{
		HRES_CO_E_MISSING_DISPLAYNAME,
		"HRES_CO_E_MISSING_DISPLAYNAME",
		"The activation requires a display name to be present under the class identifier (CLSID) key."
	},
	{
		HRES_CO_E_RUNAS_VALUE_MUST_BE_AAA,
		"HRES_CO_E_RUNAS_VALUE_MUST_BE_AAA",
		"The activation requires that the RunAs value for the application is Activate As Activator."
	},
	{
		HRES_CO_E_ELEVATION_DISABLED,
		"HRES_CO_E_ELEVATION_DISABLED",
		"The class is not configured to support elevated activation."
	},
	{
		HRES_NTE_BAD_UID,
		"HRES_NTE_BAD_UID",
		"Bad UID."
	},
	{
		HRES_NTE_BAD_HASH,
		"HRES_NTE_BAD_HASH",
		"Bad hash."
	},
	{
		HRES_NTE_BAD_KEY,
		"HRES_NTE_BAD_KEY",
		"Bad key."
	},
	{
		HRES_NTE_BAD_LEN,
		"HRES_NTE_BAD_LEN",
		"Bad length."
	},
	{
		HRES_NTE_BAD_DATA,
		"HRES_NTE_BAD_DATA",
		"Bad data."
	},
	{
		HRES_NTE_BAD_SIGNATURE,
		"HRES_NTE_BAD_SIGNATURE",
		"Invalid signature."
	},
	{
		HRES_NTE_BAD_VER,
		"HRES_NTE_BAD_VER",
		"Bad version of provider."
	},
	{
		HRES_NTE_BAD_ALGID,
		"HRES_NTE_BAD_ALGID",
		"Invalid algorithm specified."
	},
	{
		HRES_NTE_BAD_FLAGS,
		"HRES_NTE_BAD_FLAGS",
		"Invalid flags specified."
	},
	{
		HRES_NTE_BAD_TYPE,
		"HRES_NTE_BAD_TYPE",
		"Invalid type specified."
	},
	{
		HRES_NTE_BAD_KEY_STATE,
		"HRES_NTE_BAD_KEY_STATE",
		"Key not valid for use in specified state."
	},
	{
		HRES_NTE_BAD_HASH_STATE,
		"HRES_NTE_BAD_HASH_STATE",
		"Hash not valid for use in specified state."
	},
	{
		HRES_NTE_NO_KEY,
		"HRES_NTE_NO_KEY",
		"Key does not exist."
	},
	{
		HRES_NTE_NO_MEMORY,
		"HRES_NTE_NO_MEMORY",
		"Insufficient memory available for the operation."
	},
	{
		HRES_NTE_EXISTS,
		"HRES_NTE_EXISTS",
		"Object already exists."
	},
	{
		HRES_NTE_PERM,
		"HRES_NTE_PERM",
		"Access denied."
	},
	{
		HRES_NTE_NOT_FOUND,
		"HRES_NTE_NOT_FOUND",
		"Object was not found."
	},
	{
		HRES_NTE_DOUBLE_ENCRYPT,
		"HRES_NTE_DOUBLE_ENCRYPT",
		"Data already encrypted."
	},
	{
		HRES_NTE_BAD_PROVIDER,
		"HRES_NTE_BAD_PROVIDER",
		"Invalid provider specified."
	},
	{
		HRES_NTE_BAD_PROV_TYPE,
		"HRES_NTE_BAD_PROV_TYPE",
		"Invalid provider type specified."
	},
	{
		HRES_NTE_BAD_PUBLIC_KEY,
		"HRES_NTE_BAD_PUBLIC_KEY",
		"Provider's public key is invalid."
	},
	{
		HRES_NTE_BAD_KEYSET,
		"HRES_NTE_BAD_KEYSET",
		"Key set does not exist."
	},
	{
		HRES_NTE_PROV_TYPE_NOT_DEF,
		"HRES_NTE_PROV_TYPE_NOT_DEF",
		"Provider type not defined."
	},
	{
		HRES_NTE_PROV_TYPE_ENTRY_BAD,
		"HRES_NTE_PROV_TYPE_ENTRY_BAD",
		"The provider type, as registered, is invalid."
	},
	{
		HRES_NTE_KEYSET_NOT_DEF,
		"HRES_NTE_KEYSET_NOT_DEF",
		"The key set is not defined."
	},
	{
		HRES_NTE_KEYSET_ENTRY_BAD,
		"HRES_NTE_KEYSET_ENTRY_BAD",
		"The key set, as registered, is invalid."
	},
	{
		HRES_NTE_PROV_TYPE_NO_MATCH,
		"HRES_NTE_PROV_TYPE_NO_MATCH",
		"Provider type does not match registered value."
	},
	{
		HRES_NTE_SIGNATURE_FILE_BAD,
		"HRES_NTE_SIGNATURE_FILE_BAD",
		"The digital signature file is corrupt."
	},
	{
		HRES_NTE_PROVIDER_DLL_FAIL,
		"HRES_NTE_PROVIDER_DLL_FAIL",
		"Provider DLL failed to initialize correctly."
	},
	{
		HRES_NTE_PROV_DLL_NOT_FOUND,
		"HRES_NTE_PROV_DLL_NOT_FOUND",
		"Provider DLL could not be found."
	},
	{
		HRES_NTE_BAD_KEYSET_PARAM,
		"HRES_NTE_BAD_KEYSET_PARAM",
		"The keyset parameter is invalid."
	},
	{
		HRES_NTE_FAIL,
		"HRES_NTE_FAIL",
		"An internal error occurred."
	},
	{
		HRES_NTE_SYS_ERR,
		"HRES_NTE_SYS_ERR",
		"A base error occurred."
	},
	{
		HRES_NTE_SILENT_CONTEXT,
		"HRES_NTE_SILENT_CONTEXT",
		"Provider could not perform the action because the context was acquired as silent."
	},
	{
		HRES_NTE_TOKEN_KEYSET_STORAGE_FULL,
		"HRES_NTE_TOKEN_KEYSET_STORAGE_FULL",
		"The security token does not have storage space available for an additional container."
	},
	{
		HRES_NTE_TEMPORARY_PROFILE,
		"HRES_NTE_TEMPORARY_PROFILE",
		"The profile for the user is a temporary profile."
	},
	{
		HRES_NTE_FIXEDPARAMETER,
		"HRES_NTE_FIXEDPARAMETER",
		"The key parameters could not be set because the configuration service provider (CSP) uses fixed parameters."
	},
	{
		HRES_NTE_INVALID_HANDLE,
		"HRES_NTE_INVALID_HANDLE",
		"The supplied handle is invalid."
	},
	{
		HRES_NTE_INVALID_PARAMETER,
		"HRES_NTE_INVALID_PARAMETER",
		"The parameter is incorrect."
	},
	{
		HRES_NTE_BUFFER_TOO_SMALL,
		"HRES_NTE_BUFFER_TOO_SMALL",
		"The buffer supplied to a function was too small."
	},
	{
		HRES_NTE_NOT_SUPPORTED,
		"HRES_NTE_NOT_SUPPORTED",
		"The requested operation is not supported."
	},
	{
		HRES_NTE_NO_MORE_ITEMS,
		"HRES_NTE_NO_MORE_ITEMS",
		"No more data is available."
	},
	{
		HRES_NTE_BUFFERS_OVERLAP,
		"HRES_NTE_BUFFERS_OVERLAP",
		"The supplied buffers overlap incorrectly."
	},
	{
		HRES_NTE_DECRYPTION_FAILURE,
		"HRES_NTE_DECRYPTION_FAILURE",
		"The specified data could not be decrypted."
	},
	{
		HRES_NTE_INTERNAL_ERROR,
		"HRES_NTE_INTERNAL_ERROR",
		"An internal consistency check failed."
	},
	{
		HRES_NTE_UI_REQUIRED,
		"HRES_NTE_UI_REQUIRED",
		"This operation requires input from the user."
	},
	{
		HRES_NTE_HMAC_NOT_SUPPORTED,
		"HRES_NTE_HMAC_NOT_SUPPORTED",
		"The cryptographic provider does not support Hash Message Authentication Code (HMAC)."
	},
	{
		HRES_SEC_E_INSUFFICIENT_MEMORY,
		"HRES_SEC_E_INSUFFICIENT_MEMORY",
		"Not enough memory is available to complete this request."
	},
	{
		HRES_SEC_E_INVALID_HANDLE,
		"HRES_SEC_E_INVALID_HANDLE",
		"The handle specified is invalid."
	},
	{
		HRES_SEC_E_UNSUPPORTED_FUNCTION,
		"HRES_SEC_E_UNSUPPORTED_FUNCTION",
		"The function requested is not supported."
	},
	{
		HRES_SEC_E_TARGET_UNKNOWN,
		"HRES_SEC_E_TARGET_UNKNOWN",
		"The specified target is unknown or unreachable."
	},
	{
		HRES_SEC_E_INTERNAL_ERROR,
		"HRES_SEC_E_INTERNAL_ERROR",
		"The Local Security Authority (LSA) cannot be contacted."
	},
	{
		HRES_SEC_E_SECPKG_NOT_FOUND,
		"HRES_SEC_E_SECPKG_NOT_FOUND",
		"The requested security package does not exist."
	},
	{
		HRES_SEC_E_NOT_OWNER,
		"HRES_SEC_E_NOT_OWNER",
		"The caller is not the owner of the desired credentials."
	},
	{
		HRES_SEC_E_CANNOT_INSTALL,
		"HRES_SEC_E_CANNOT_INSTALL",
		"The security package failed to initialize and cannot be installed."
	},
	{
		HRES_SEC_E_INVALID_TOKEN,
		"HRES_SEC_E_INVALID_TOKEN",
		"The token supplied to the function is invalid."
	},
	{
		HRES_SEC_E_CANNOT_PACK,
		"HRES_SEC_E_CANNOT_PACK",
		"The security package is not able to marshal the logon buffer, so the logon attempt has failed."
	},
	{
		HRES_SEC_E_QOP_NOT_SUPPORTED,
		"HRES_SEC_E_QOP_NOT_SUPPORTED",
		"The per-message quality of protection is not supported by the security package."
	},
	{
		HRES_SEC_E_NO_IMPERSONATION,
		"HRES_SEC_E_NO_IMPERSONATION",
		"The security context does not allow impersonation of the client."
	},
	{
		HRES_SEC_E_LOGON_DENIED,
		"HRES_SEC_E_LOGON_DENIED",
		"The logon attempt failed."
	},
	{
		HRES_SEC_E_UNKNOWN_CREDENTIALS,
		"HRES_SEC_E_UNKNOWN_CREDENTIALS",
		"The credentials supplied to the package were not recognized."
	},
	{
		HRES_SEC_E_NO_CREDENTIALS,
		"HRES_SEC_E_NO_CREDENTIALS",
		"No credentials are available in the security package."
	},
	{
		HRES_SEC_E_MESSAGE_ALTERED,
		"HRES_SEC_E_MESSAGE_ALTERED",
		"The message or signature supplied for verification has been altered."
	},
	{
		HRES_SEC_E_OUT_OF_SEQUENCE,
		"HRES_SEC_E_OUT_OF_SEQUENCE",
		"The message supplied for verification is out of sequence."
	},
	{
		HRES_SEC_E_NO_AUTHENTICATING_AUTHORITY,
		"HRES_SEC_E_NO_AUTHENTICATING_AUTHORITY",
		"No authority could be contacted for authentication."
	},
	{
		HRES_SEC_E_BAD_PKGID,
		"HRES_SEC_E_BAD_PKGID",
		"The requested security package does not exist."
	},
	{
		HRES_SEC_E_CONTEXT_EXPIRED,
		"HRES_SEC_E_CONTEXT_EXPIRED",
		"The context has expired and can no longer be used."
	},
	{
		HRES_SEC_E_INCOMPLETE_MESSAGE,
		"HRES_SEC_E_INCOMPLETE_MESSAGE",
		"The supplied message is incomplete. The signature was not verified."
	},
	{
		HRES_SEC_E_INCOMPLETE_CREDENTIALS,
		"HRES_SEC_E_INCOMPLETE_CREDENTIALS",
		"The credentials supplied were not complete and could not be verified. The context could not be initialized."
	},
	{
		HRES_SEC_E_BUFFER_TOO_SMALL,
		"HRES_SEC_E_BUFFER_TOO_SMALL",
		"The buffers supplied to a function was too small."
	},
	{
		HRES_SEC_E_WRONG_PRINCIPAL,
		"HRES_SEC_E_WRONG_PRINCIPAL",
		"The target principal name is incorrect."
	},
	{
		HRES_SEC_E_TIME_SKEW,
		"HRES_SEC_E_TIME_SKEW",
		"The clocks on the client and server machines are skewed."
	},
	{
		HRES_SEC_E_UNTRUSTED_ROOT,
		"HRES_SEC_E_UNTRUSTED_ROOT",
		"The certificate chain was issued by an authority that is not trusted."
	},
	{
		HRES_SEC_E_ILLEGAL_MESSAGE,
		"HRES_SEC_E_ILLEGAL_MESSAGE",
		"The message received was unexpected or badly formatted."
	},
	{
		HRES_SEC_E_CERT_UNKNOWN,
		"HRES_SEC_E_CERT_UNKNOWN",
		"An unknown error occurred while processing the certificate."
	},
	{
		HRES_SEC_E_CERT_EXPIRED,
		"HRES_SEC_E_CERT_EXPIRED",
		"The received certificate has expired."
	},
	{
		HRES_SEC_E_ENCRYPT_FAILURE,
		"HRES_SEC_E_ENCRYPT_FAILURE",
		"The specified data could not be encrypted."
	},
	{
		HRES_SEC_E_DECRYPT_FAILURE,
		"HRES_SEC_E_DECRYPT_FAILURE",
		"The specified data could not be decrypted."
	},
	{
		HRES_SEC_E_ALGORITHM_MISMATCH,
		"HRES_SEC_E_ALGORITHM_MISMATCH",
		"The client and server cannot communicate because they do not possess a common algorithm."
	},
	{
		HRES_SEC_E_SECURITY_QOS_FAILED,
		"HRES_SEC_E_SECURITY_QOS_FAILED",
		"The security context could not be established due to a failure in the requested quality of service (for example, mutual authentication or delegation)."
	},
	{
		HRES_SEC_E_UNFINISHED_CONTEXT_DELETED,
		"HRES_SEC_E_UNFINISHED_CONTEXT_DELETED",
		"A security context was deleted before the context was completed. This is considered a logon failure."
	},
	{
		HRES_SEC_E_NO_TGT_REPLY,
		"HRES_SEC_E_NO_TGT_REPLY",
		"The client is trying to negotiate a context and the server requires user-to-user but did not send a ticket granting ticket (TGT) reply."
	},
	{
		HRES_SEC_E_NO_IP_ADDRESSES,
		"HRES_SEC_E_NO_IP_ADDRESSES",
		"Unable to accomplish the requested task because the local machine does not have an IP addresses."
	},
	{
		HRES_SEC_E_WRONG_CREDENTIAL_HANDLE,
		"HRES_SEC_E_WRONG_CREDENTIAL_HANDLE",
		"The supplied credential handle does not match the credential associated with the security context."
	},
	{
		HRES_SEC_E_CRYPTO_SYSTEM_INVALID,
		"HRES_SEC_E_CRYPTO_SYSTEM_INVALID",
		"The cryptographic system or checksum function is invalid because a required function is unavailable."
	},
	{
		HRES_SEC_E_MAX_REFERRALS_EXCEEDED,
		"HRES_SEC_E_MAX_REFERRALS_EXCEEDED",
		"The number of maximum ticket referrals has been exceeded."
	},
	{
		HRES_SEC_E_MUST_BE_KDC,
		"HRES_SEC_E_MUST_BE_KDC",
		"The local machine must be a Kerberos domain controller (KDC), and it is not."
	},
	{
		HRES_SEC_E_STRONG_CRYPTO_NOT_SUPPORTED,
		"HRES_SEC_E_STRONG_CRYPTO_NOT_SUPPORTED",
		"The other end of the security negotiation requires strong cryptographics, but it is not supported on the local machine."
	},
	{
		HRES_SEC_E_TOO_MANY_PRINCIPALS,
		"HRES_SEC_E_TOO_MANY_PRINCIPALS",
		"The KDC reply contained more than one principal name."
	},
	{
		HRES_SEC_E_NO_PA_DATA,
		"HRES_SEC_E_NO_PA_DATA",
		"Expected to find PA data for a hint of what etype to use, but it was not found."
	},
	{
		HRES_SEC_E_PKINIT_NAME_MISMATCH,
		"HRES_SEC_E_PKINIT_NAME_MISMATCH",
		"The client certificate does not contain a valid user principal name (UPN), or does not match the client name in the logon request. Contact your administrator."
	},
	{
		HRES_SEC_E_SMARTCARD_LOGON_REQUIRED,
		"HRES_SEC_E_SMARTCARD_LOGON_REQUIRED",
		"Smart card logon is required and was not used."
	},
	{
		HRES_SEC_E_SHUTDOWN_IN_PROGRESS,
		"HRES_SEC_E_SHUTDOWN_IN_PROGRESS",
		"A system shutdown is in progress."
	},
	{
		HRES_SEC_E_KDC_INVALID_REQUEST,
		"HRES_SEC_E_KDC_INVALID_REQUEST",
		"An invalid request was sent to the KDC."
	},
	{
		HRES_SEC_E_KDC_UNABLE_TO_REFER,
		"HRES_SEC_E_KDC_UNABLE_TO_REFER",
		"The KDC was unable to generate a referral for the service requested."
	},
	{
		HRES_SEC_E_KDC_UNKNOWN_ETYPE,
		"HRES_SEC_E_KDC_UNKNOWN_ETYPE",
		"The encryption type requested is not supported by the KDC."
	},
	{
		HRES_SEC_E_UNSUPPORTED_PREAUTH,
		"HRES_SEC_E_UNSUPPORTED_PREAUTH",
		"An unsupported pre-authentication mechanism was presented to the Kerberos package."
	},
	{
		HRES_SEC_E_DELEGATION_REQUIRED,
		"HRES_SEC_E_DELEGATION_REQUIRED",
		"The requested operation cannot be completed. The computer must be trusted for delegation, and the current user account must be configured to allow delegation."
	},
	{
		HRES_SEC_E_BAD_BINDINGS,
		"HRES_SEC_E_BAD_BINDINGS",
		"Client's supplied Security Support Provider Interface (SSPI) channel bindings were incorrect."
	},
	{
		HRES_SEC_E_MULTIPLE_ACCOUNTS,
		"HRES_SEC_E_MULTIPLE_ACCOUNTS",
		"The received certificate was mapped to multiple accounts."
	},
	{
		HRES_SEC_E_NO_KERB_KEY,
		"HRES_SEC_E_NO_KERB_KEY",
		"No Kerberos key was found."
	},
	{
		HRES_SEC_E_CERT_WRONG_USAGE,
		"HRES_SEC_E_CERT_WRONG_USAGE",
		"The certificate is not valid for the requested usage."
	},
	{
		HRES_SEC_E_DOWNGRADE_DETECTED,
		"HRES_SEC_E_DOWNGRADE_DETECTED",
		"The system detected a possible attempt to compromise security. Ensure that you can contact the server that authenticated you."
	},
	{
		HRES_SEC_E_SMARTCARD_CERT_REVOKED,
		"HRES_SEC_E_SMARTCARD_CERT_REVOKED",
		"The smart card certificate used for authentication has been revoked. Contact your system administrator. The event log might contain additional information."
	},
	{
		HRES_SEC_E_ISSUING_CA_UNTRUSTED,
		"HRES_SEC_E_ISSUING_CA_UNTRUSTED",
		"An untrusted certification authority (CA) was detected while processing the smart card certificate used for authentication. Contact your system administrator."
	},
	{
		HRES_SEC_E_REVOCATION_OFFLINE_C,
		"HRES_SEC_E_REVOCATION_OFFLINE_C",
		"The revocation status of the smart card certificate used for authentication could not be determined. Contact your system administrator."
	},
	{
		HRES_SEC_E_PKINIT_CLIENT_FAILURE,
		"HRES_SEC_E_PKINIT_CLIENT_FAILURE",
		"The smart card certificate used for authentication was not trusted. Contact your system administrator."
	},
	{
		HRES_SEC_E_SMARTCARD_CERT_EXPIRED,
		"HRES_SEC_E_SMARTCARD_CERT_EXPIRED",
		"The smart card certificate used for authentication has expired. Contact your system administrator."
	},
	{
		HRES_SEC_E_NO_S4U_PROT_SUPPORT,
		"HRES_SEC_E_NO_S4U_PROT_SUPPORT",
		"The Kerberos subsystem encountered an error. A service for user protocol requests was made against a domain controller that does not support services for users."
	},
	{
		HRES_SEC_E_CROSSREALM_DELEGATION_FAILURE,
		"HRES_SEC_E_CROSSREALM_DELEGATION_FAILURE",
		"An attempt was made by this server to make a Kerberos-constrained delegation request for a target outside the server's realm. This is not supported and indicates a misconfiguration on this server's allowed-to-delegate-to list. Contact your administrator."
	},
	{
		HRES_SEC_E_REVOCATION_OFFLINE_KDC,
		"HRES_SEC_E_REVOCATION_OFFLINE_KDC",
		"The revocation status of the domain controller certificate used for smart card authentication could not be determined. The system event log contains additional information. Contact your system administrator."
	},
	{
		HRES_SEC_E_ISSUING_CA_UNTRUSTED_KDC,
		"HRES_SEC_E_ISSUING_CA_UNTRUSTED_KDC",
		"An untrusted CA was detected while processing the domain controller certificate used for authentication. The system event log contains additional information. Contact your system administrator."
	},
	{
		HRES_SEC_E_KDC_CERT_EXPIRED,
		"HRES_SEC_E_KDC_CERT_EXPIRED",
		"The domain controller certificate used for smart card logon has expired. Contact your system administrator with the contents of your system event log."
	},
	{
		HRES_SEC_E_KDC_CERT_REVOKED,
		"HRES_SEC_E_KDC_CERT_REVOKED",
		"The domain controller certificate used for smart card logon has been revoked. Contact your system administrator with the contents of your system event log."
	},
	{
		HRES_SEC_E_INVALID_PARAMETER,
		"HRES_SEC_E_INVALID_PARAMETER",
		"One or more of the parameters passed to the function were invalid."
	},
	{
		HRES_SEC_E_DELEGATION_POLICY,
		"HRES_SEC_E_DELEGATION_POLICY",
		"The client policy does not allow credential delegation to the target server."
	},
	{
		HRES_SEC_E_POLICY_NLTM_ONLY,
		"HRES_SEC_E_POLICY_NLTM_ONLY",
		"The client policy does not allow credential delegation to the target server with NLTM only authentication."
	},
	{
		HRES_CRYPT_E_MSG_ERROR,
		"HRES_CRYPT_E_MSG_ERROR",
		"An error occurred while performing an operation on a cryptographic message."
	},
	{
		HRES_CRYPT_E_UNKNOWN_ALGO,
		"HRES_CRYPT_E_UNKNOWN_ALGO",
		"Unknown cryptographic algorithm."
	},
	{
		HRES_CRYPT_E_OID_FORMAT,
		"HRES_CRYPT_E_OID_FORMAT",
		"The object identifier is poorly formatted."
	},
	{
		HRES_CRYPT_E_INVALID_MSG_TYPE,
		"HRES_CRYPT_E_INVALID_MSG_TYPE",
		"Invalid cryptographic message type."
	},
	{
		HRES_CRYPT_E_UNEXPECTED_ENCODING,
		"HRES_CRYPT_E_UNEXPECTED_ENCODING",
		"Unexpected cryptographic message encoding."
	},
	{
		HRES_CRYPT_E_AUTH_ATTR_MISSING,
		"HRES_CRYPT_E_AUTH_ATTR_MISSING",
		"The cryptographic message does not contain an expected authenticated attribute."
	},
	{
		HRES_CRYPT_E_HASH_VALUE,
		"HRES_CRYPT_E_HASH_VALUE",
		"The hash value is not correct."
	},
	{
		HRES_CRYPT_E_INVALID_INDEX,
		"HRES_CRYPT_E_INVALID_INDEX",
		"The index value is not valid."
	},
	{
		HRES_CRYPT_E_ALREADY_DECRYPTED,
		"HRES_CRYPT_E_ALREADY_DECRYPTED",
		"The content of the cryptographic message has already been decrypted."
	},
	{
		HRES_CRYPT_E_NOT_DECRYPTED,
		"HRES_CRYPT_E_NOT_DECRYPTED",
		"The content of the cryptographic message has not been decrypted yet."
	},
	{
		HRES_CRYPT_E_RECIPIENT_NOT_FOUND,
		"HRES_CRYPT_E_RECIPIENT_NOT_FOUND",
		"The enveloped-data message does not contain the specified recipient."
	},
	{
		HRES_CRYPT_E_CONTROL_TYPE,
		"HRES_CRYPT_E_CONTROL_TYPE",
		"Invalid control type."
	},
	{
		HRES_CRYPT_E_ISSUER_SERIALNUMBER,
		"HRES_CRYPT_E_ISSUER_SERIALNUMBER",
		"Invalid issuer or serial number."
	},
	{
		HRES_CRYPT_E_SIGNER_NOT_FOUND,
		"HRES_CRYPT_E_SIGNER_NOT_FOUND",
		"Cannot find the original signer."
	},
	{
		HRES_CRYPT_E_ATTRIBUTES_MISSING,
		"HRES_CRYPT_E_ATTRIBUTES_MISSING",
		"The cryptographic message does not contain all of the requested attributes."
	},
	{
		HRES_CRYPT_E_STREAM_MSG_NOT_READY,
		"HRES_CRYPT_E_STREAM_MSG_NOT_READY",
		"The streamed cryptographic message is not ready to return data."
	},
	{
		HRES_CRYPT_E_STREAM_INSUFFICIENT_DATA,
		"HRES_CRYPT_E_STREAM_INSUFFICIENT_DATA",
		"The streamed cryptographic message requires more data to complete the decode operation."
	},
	{
		HRES_CRYPT_E_BAD_LEN,
		"HRES_CRYPT_E_BAD_LEN",
		"The length specified for the output data was insufficient."
	},
	{
		HRES_CRYPT_E_BAD_ENCODE,
		"HRES_CRYPT_E_BAD_ENCODE",
		"An error occurred during the encode or decode operation."
	},
	{
		HRES_CRYPT_E_FILE_ERROR,
		"HRES_CRYPT_E_FILE_ERROR",
		"An error occurred while reading or writing to a file."
	},
	{
		HRES_CRYPT_E_NOT_FOUND,
		"HRES_CRYPT_E_NOT_FOUND",
		"Cannot find object or property."
	},
	{
		HRES_CRYPT_E_EXISTS,
		"HRES_CRYPT_E_EXISTS",
		"The object or property already exists."
	},
	{
		HRES_CRYPT_E_NO_PROVIDER,
		"HRES_CRYPT_E_NO_PROVIDER",
		"No provider was specified for the store or object."
	},
	{
		HRES_CRYPT_E_SELF_SIGNED,
		"HRES_CRYPT_E_SELF_SIGNED",
		"The specified certificate is self-signed."
	},
	{
		HRES_CRYPT_E_DELETED_PREV,
		"HRES_CRYPT_E_DELETED_PREV",
		"The previous certificate or certificate revocation list (CRL) context was deleted."
	},
	{
		HRES_CRYPT_E_NO_MATCH,
		"HRES_CRYPT_E_NO_MATCH",
		"Cannot find the requested object."
	},
	{
		HRES_CRYPT_E_UNEXPECTED_MSG_TYPE,
		"HRES_CRYPT_E_UNEXPECTED_MSG_TYPE",
		"The certificate does not have a property that references a private key."
	},
	{
		HRES_CRYPT_E_NO_KEY_PROPERTY,
		"HRES_CRYPT_E_NO_KEY_PROPERTY",
		"Cannot find the certificate and private key for decryption."
	},
	{
		HRES_CRYPT_E_NO_DECRYPT_CERT,
		"HRES_CRYPT_E_NO_DECRYPT_CERT",
		"Cannot find the certificate and private key to use for decryption."
	},
	{
		HRES_CRYPT_E_BAD_MSG,
		"HRES_CRYPT_E_BAD_MSG",
		"Not a cryptographic message or the cryptographic message is not formatted correctly."
	},
	{
		HRES_CRYPT_E_NO_SIGNER,
		"HRES_CRYPT_E_NO_SIGNER",
		"The signed cryptographic message does not have a signer for the specified signer index."
	},
	{
		HRES_CRYPT_E_PENDING_CLOSE,
		"HRES_CRYPT_E_PENDING_CLOSE",
		"Final closure is pending until additional frees or closes."
	},
	{
		HRES_CRYPT_E_REVOKED,
		"HRES_CRYPT_E_REVOKED",
		"The certificate is revoked."
	},
	{
		HRES_CRYPT_E_NO_REVOCATION_DLL,
		"HRES_CRYPT_E_NO_REVOCATION_DLL",
		"No DLL or exported function was found to verify revocation."
	},
	{
		HRES_CRYPT_E_NO_REVOCATION_CHECK,
		"HRES_CRYPT_E_NO_REVOCATION_CHECK",
		"The revocation function was unable to check revocation for the certificate."
	},
	{
		HRES_CRYPT_E_REVOCATION_OFFLINE,
		"HRES_CRYPT_E_REVOCATION_OFFLINE",
		"The revocation function was unable to check revocation because the revocation server was offline."
	},
	{
		HRES_CRYPT_E_NOT_IN_REVOCATION_DATABASE,
		"HRES_CRYPT_E_NOT_IN_REVOCATION_DATABASE",
		"The certificate is not in the revocation server's database."
	},
	{
		HRES_CRYPT_E_INVALID_NUMERIC_STRING,
		"HRES_CRYPT_E_INVALID_NUMERIC_STRING",
		"The string contains a non-numeric character."
	},
	{
		HRES_CRYPT_E_INVALID_PRINTABLE_STRING,
		"HRES_CRYPT_E_INVALID_PRINTABLE_STRING",
		"The string contains a nonprintable character."
	},
	{
		HRES_CRYPT_E_INVALID_IA5_STRING,
		"HRES_CRYPT_E_INVALID_IA5_STRING",
		"The string contains a character not in the 7-bit ASCII character set."
	},
	{
		HRES_CRYPT_E_INVALID_X500_STRING,
		"HRES_CRYPT_E_INVALID_X500_STRING",
		"The string contains an invalid X500 name attribute key, object identifier (OID), value, or delimiter."
	},
	{
		HRES_CRYPT_E_NOT_CHAR_STRING,
		"HRES_CRYPT_E_NOT_CHAR_STRING",
		"The dwValueType for the CERT_NAME_VALUE is not one of the character strings. Most likely it is either a CERT_RDN_ENCODED_BLOB or CERT_TDN_OCTED_STRING."
	},
	{
		HRES_CRYPT_E_FILERESIZED,
		"HRES_CRYPT_E_FILERESIZED",
		"The Put operation cannot continue. The file needs to be resized. However, there is already a signature present. A complete signing operation must be done."
	},
	{
		HRES_CRYPT_E_SECURITY_SETTINGS,
		"HRES_CRYPT_E_SECURITY_SETTINGS",
		"The cryptographic operation failed due to a local security option setting."
	},
	{
		HRES_CRYPT_E_NO_VERIFY_USAGE_DLL,
		"HRES_CRYPT_E_NO_VERIFY_USAGE_DLL",
		"No DLL or exported function was found to verify subject usage."
	},
	{
		HRES_CRYPT_E_NO_VERIFY_USAGE_CHECK,
		"HRES_CRYPT_E_NO_VERIFY_USAGE_CHECK",
		"The called function was unable to perform a usage check on the subject."
	},
	{
		HRES_CRYPT_E_VERIFY_USAGE_OFFLINE,
		"HRES_CRYPT_E_VERIFY_USAGE_OFFLINE",
		"The called function was unable to complete the usage check because the server was offline."
	},
	{
		HRES_CRYPT_E_NOT_IN_CTL,
		"HRES_CRYPT_E_NOT_IN_CTL",
		"The subject was not found in a certificate trust list (CTL)."
	},
	{
		HRES_CRYPT_E_NO_TRUSTED_SIGNER,
		"HRES_CRYPT_E_NO_TRUSTED_SIGNER",
		"None of the signers of the cryptographic message or certificate trust list is trusted."
	},
	{
		HRES_CRYPT_E_MISSING_PUBKEY_PARA,
		"HRES_CRYPT_E_MISSING_PUBKEY_PARA",
		"The public key's algorithm parameters are missing."
	},
	{
		HRES_CRYPT_E_OSS_ERROR,
		"HRES_CRYPT_E_OSS_ERROR",
		"OSS Certificate encode/decode error code base."
	},
	{
		HRES_OSS_MORE_BUF,
		"HRES_OSS_MORE_BUF",
		"OSS ASN.1 Error: Output Buffer is too small."
	},
	{
		HRES_OSS_NEGATIVE_UINTEGER,
		"HRES_OSS_NEGATIVE_UINTEGER",
		"OSS ASN.1 Error: Signed integer is encoded as a unsigned integer."
	},
	{
		HRES_OSS_PDU_RANGE,
		"HRES_OSS_PDU_RANGE",
		"OSS ASN.1 Error: Unknown ASN.1 data type."
	},
	{
		HRES_OSS_MORE_INPUT,
		"HRES_OSS_MORE_INPUT",
		"OSS ASN.1 Error: Output buffer is too small; the decoded data has been truncated."
	},
	{
		HRES_OSS_DATA_ERROR,
		"HRES_OSS_DATA_ERROR",
		"OSS ASN.1 Error: Invalid data."
	},
	{
		HRES_OSS_BAD_ARG,
		"HRES_OSS_BAD_ARG",
		"OSS ASN.1 Error: Invalid argument."
	},
	{
		HRES_OSS_BAD_VERSION,
		"HRES_OSS_BAD_VERSION",
		"OSS ASN.1 Error: Encode/Decode version mismatch."
	},
	{
		HRES_OSS_OUT_MEMORY,
		"HRES_OSS_OUT_MEMORY",
		"OSS ASN.1 Error: Out of memory."
	},
	{
		HRES_OSS_PDU_MISMATCH,
		"HRES_OSS_PDU_MISMATCH",
		"OSS ASN.1 Error: Encode/Decode error."
	},
	{
		HRES_OSS_LIMITED,
		"HRES_OSS_LIMITED",
		"OSS ASN.1 Error: Internal error."
	},
	{
		HRES_OSS_BAD_PTR,
		"HRES_OSS_BAD_PTR",
		"OSS ASN.1 Error: Invalid data."
	},
	{
		HRES_OSS_BAD_TIME,
		"HRES_OSS_BAD_TIME",
		"OSS ASN.1 Error: Invalid data."
	},
	{
		HRES_OSS_INDEFINITE_NOT_SUPPORTED,
		"HRES_OSS_INDEFINITE_NOT_SUPPORTED",
		"OSS ASN.1 Error: Unsupported BER indefinite-length encoding."
	},
	{
		HRES_OSS_MEM_ERROR,
		"HRES_OSS_MEM_ERROR",
		"OSS ASN.1 Error: Access violation."
	},
	{
		HRES_OSS_BAD_TABLE,
		"HRES_OSS_BAD_TABLE",
		"OSS ASN.1 Error: Invalid data."
	},
	{
		HRES_OSS_TOO_LONG,
		"HRES_OSS_TOO_LONG",
		"OSS ASN.1 Error: Invalid data."
	},
	{
		HRES_OSS_CONSTRAINT_VIOLATED,
		"HRES_OSS_CONSTRAINT_VIOLATED",
		"OSS ASN.1 Error: Invalid data."
	},
	{
		HRES_OSS_FATAL_ERROR,
		"HRES_OSS_FATAL_ERROR",
		"OSS ASN.1 Error: Internal error."
	},
	{
		HRES_OSS_ACCESS_SERIALIZATION_ERROR,
		"HRES_OSS_ACCESS_SERIALIZATION_ERROR",
		"OSS ASN.1 Error: Multithreading conflict."
	},
	{
		HRES_OSS_NULL_TBL,
		"HRES_OSS_NULL_TBL",
		"OSS ASN.1 Error: Invalid data."
	},
	{
		HRES_OSS_NULL_FCN,
		"HRES_OSS_NULL_FCN",
		"OSS ASN.1 Error: Invalid data."
	},
	{
		HRES_OSS_BAD_ENCRULES,
		"HRES_OSS_BAD_ENCRULES",
		"OSS ASN.1 Error: Invalid data."
	},
	{
		HRES_OSS_UNAVAIL_ENCRULES,
		"HRES_OSS_UNAVAIL_ENCRULES",
		"OSS ASN.1 Error: Encode/Decode function not implemented."
	},
	{
		HRES_OSS_CANT_OPEN_TRACE_WINDOW,
		"HRES_OSS_CANT_OPEN_TRACE_WINDOW",
		"OSS ASN.1 Error: Trace file error."
	},
	{
		HRES_OSS_UNIMPLEMENTED,
		"HRES_OSS_UNIMPLEMENTED",
		"OSS ASN.1 Error: Function not implemented."
	},
	{
		HRES_OSS_OID_DLL_NOT_LINKED,
		"HRES_OSS_OID_DLL_NOT_LINKED",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_CANT_OPEN_TRACE_FILE,
		"HRES_OSS_CANT_OPEN_TRACE_FILE",
		"OSS ASN.1 Error: Trace file error."
	},
	{
		HRES_OSS_TRACE_FILE_ALREADY_OPEN,
		"HRES_OSS_TRACE_FILE_ALREADY_OPEN",
		"OSS ASN.1 Error: Trace file error."
	},
	{
		HRES_OSS_TABLE_MISMATCH,
		"HRES_OSS_TABLE_MISMATCH",
		"OSS ASN.1 Error: Invalid data."
	},
	{
		HRES_OSS_TYPE_NOT_SUPPORTED,
		"HRES_OSS_TYPE_NOT_SUPPORTED",
		"OSS ASN.1 Error: Invalid data."
	},
	{
		HRES_OSS_REAL_DLL_NOT_LINKED,
		"HRES_OSS_REAL_DLL_NOT_LINKED",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_REAL_CODE_NOT_LINKED,
		"HRES_OSS_REAL_CODE_NOT_LINKED",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_OUT_OF_RANGE,
		"HRES_OSS_OUT_OF_RANGE",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_COPIER_DLL_NOT_LINKED,
		"HRES_OSS_COPIER_DLL_NOT_LINKED",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_CONSTRAINT_DLL_NOT_LINKED,
		"HRES_OSS_CONSTRAINT_DLL_NOT_LINKED",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_COMPARATOR_DLL_NOT_LINKED,
		"HRES_OSS_COMPARATOR_DLL_NOT_LINKED",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_COMPARATOR_CODE_NOT_LINKED,
		"HRES_OSS_COMPARATOR_CODE_NOT_LINKED",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_MEM_MGR_DLL_NOT_LINKED,
		"HRES_OSS_MEM_MGR_DLL_NOT_LINKED",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_PDV_DLL_NOT_LINKED,
		"HRES_OSS_PDV_DLL_NOT_LINKED",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_PDV_CODE_NOT_LINKED,
		"HRES_OSS_PDV_CODE_NOT_LINKED",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_API_DLL_NOT_LINKED,
		"HRES_OSS_API_DLL_NOT_LINKED",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_BERDER_DLL_NOT_LINKED,
		"HRES_OSS_BERDER_DLL_NOT_LINKED",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_PER_DLL_NOT_LINKED,
		"HRES_OSS_PER_DLL_NOT_LINKED",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_OPEN_TYPE_ERROR,
		"HRES_OSS_OPEN_TYPE_ERROR",
		"OSS ASN.1 Error: Program link error."
	},
	{
		HRES_OSS_MUTEX_NOT_CREATED,
		"HRES_OSS_MUTEX_NOT_CREATED",
		"OSS ASN.1 Error: System resource error."
	},
	{
		HRES_OSS_CANT_CLOSE_TRACE_FILE,
		"HRES_OSS_CANT_CLOSE_TRACE_FILE",
		"OSS ASN.1 Error: Trace file error."
	},
	{
		HRES_CRYPT_E_ASN1_ERROR,
		"HRES_CRYPT_E_ASN1_ERROR",
		"ASN1 Certificate encode/decode error code base."
	},
	{
		HRES_CRYPT_E_ASN1_INTERNAL,
		"HRES_CRYPT_E_ASN1_INTERNAL",
		"ASN1 internal encode or decode error."
	},
	{
		HRES_CRYPT_E_ASN1_EOD,
		"HRES_CRYPT_E_ASN1_EOD",
		"ASN1 unexpected end of data."
	},
	{
		HRES_CRYPT_E_ASN1_CORRUPT,
		"HRES_CRYPT_E_ASN1_CORRUPT",
		"ASN1 corrupted data."
	},
	{
		HRES_CRYPT_E_ASN1_LARGE,
		"HRES_CRYPT_E_ASN1_LARGE",
		"ASN1 value too large."
	},
	{
		HRES_CRYPT_E_ASN1_CONSTRAINT,
		"HRES_CRYPT_E_ASN1_CONSTRAINT",
		"ASN1 constraint violated."
	},
	{
		HRES_CRYPT_E_ASN1_MEMORY,
		"HRES_CRYPT_E_ASN1_MEMORY",
		"ASN1 out of memory."
	},
	{
		HRES_CRYPT_E_ASN1_OVERFLOW,
		"HRES_CRYPT_E_ASN1_OVERFLOW",
		"ASN1 buffer overflow."
	},
	{
		HRES_CRYPT_E_ASN1_BADPDU,
		"HRES_CRYPT_E_ASN1_BADPDU",
		"ASN1 function not supported for this protocol data unit (PDU)."
	},
	{
		HRES_CRYPT_E_ASN1_BADARGS,
		"HRES_CRYPT_E_ASN1_BADARGS",
		"ASN1 bad arguments to function call."
	},
	{
		HRES_CRYPT_E_ASN1_BADREAL,
		"HRES_CRYPT_E_ASN1_BADREAL",
		"ASN1 bad real value."
	},
	{
		HRES_CRYPT_E_ASN1_BADTAG,
		"HRES_CRYPT_E_ASN1_BADTAG",
		"ASN1 bad tag value met."
	},
	{
		HRES_CRYPT_E_ASN1_CHOICE,
		"HRES_CRYPT_E_ASN1_CHOICE",
		"ASN1 bad choice value."
	},
	{
		HRES_CRYPT_E_ASN1_RULE,
		"HRES_CRYPT_E_ASN1_RULE",
		"ASN1 bad encoding rule."
	},
	{
		HRES_CRYPT_E_ASN1_UTF8,
		"HRES_CRYPT_E_ASN1_UTF8",
		"ASN1 bad Unicode (UTF8)."
	},
	{
		HRES_CRYPT_E_ASN1_PDU_TYPE,
		"HRES_CRYPT_E_ASN1_PDU_TYPE",
		"ASN1 bad PDU type."
	},
	{
		HRES_CRYPT_E_ASN1_NYI,
		"HRES_CRYPT_E_ASN1_NYI",
		"ASN1 not yet implemented."
	},
	{
		HRES_CRYPT_E_ASN1_EXTENDED,
		"HRES_CRYPT_E_ASN1_EXTENDED",
		"ASN1 skipped unknown extensions."
	},
	{
		HRES_CRYPT_E_ASN1_NOEOD,
		"HRES_CRYPT_E_ASN1_NOEOD",
		"ASN1 end of data expected."
	},
	{
		HRES_CERTSRV_E_BAD_REQUESTSUBJECT,
		"HRES_CERTSRV_E_BAD_REQUESTSUBJECT",
		"The request subject name is invalid or too long."
	},
	{
		HRES_CERTSRV_E_NO_REQUEST,
		"HRES_CERTSRV_E_NO_REQUEST",
		"The request does not exist."
	},
	{
		HRES_CERTSRV_E_BAD_REQUESTSTATUS,
		"HRES_CERTSRV_E_BAD_REQUESTSTATUS",
		"The request's current status does not allow this operation."
	},
	{
		HRES_CERTSRV_E_PROPERTY_EMPTY,
		"HRES_CERTSRV_E_PROPERTY_EMPTY",
		"The requested property value is empty."
	},
	{
		HRES_CERTSRV_E_INVALID_CA_CERTIFICATE,
		"HRES_CERTSRV_E_INVALID_CA_CERTIFICATE",
		"The CA's certificate contains invalid data."
	},
	{
		HRES_CERTSRV_E_SERVER_SUSPENDED,
		"HRES_CERTSRV_E_SERVER_SUSPENDED",
		"Certificate service has been suspended for a database restore operation."
	},
	{
		HRES_CERTSRV_E_ENCODING_LENGTH,
		"HRES_CERTSRV_E_ENCODING_LENGTH",
		"The certificate contains an encoded length that is potentially incompatible with older enrollment software."
	},
	{
		HRES_CERTSRV_E_ROLECONFLICT,
		"HRES_CERTSRV_E_ROLECONFLICT",
		"The operation is denied. The user has multiple roles assigned, and the CA is configured to enforce role separation."
	},
	{
		HRES_CERTSRV_E_RESTRICTEDOFFICER,
		"HRES_CERTSRV_E_RESTRICTEDOFFICER",
		"The operation is denied. It can only be performed by a certificate manager that is allowed to manage certificates for the current requester."
	},
	{
		HRES_CERTSRV_E_KEY_ARCHIVAL_NOT_CONFIGURED,
		"HRES_CERTSRV_E_KEY_ARCHIVAL_NOT_CONFIGURED",
		"Cannot archive private key. The CA is not configured for key archival."
	},
	{
		HRES_CERTSRV_E_NO_VALID_KRA,
		"HRES_CERTSRV_E_NO_VALID_KRA",
		"Cannot archive private key. The CA could not verify one or more key recovery certificates."
	},
	{
		HRES_CERTSRV_E_BAD_REQUEST_KEY_ARCHIVAL,
		"HRES_CERTSRV_E_BAD_REQUEST_KEY_ARCHIVAL",
		"The request is incorrectly formatted. The encrypted private key must be in an unauthenticated attribute in an outermost signature."
	},
	{
		HRES_CERTSRV_E_NO_CAADMIN_DEFINED,
		"HRES_CERTSRV_E_NO_CAADMIN_DEFINED",
		"At least one security principal must have the permission to manage this CA."
	},
	{
		HRES_CERTSRV_E_BAD_RENEWAL_CERT_ATTRIBUTE,
		"HRES_CERTSRV_E_BAD_RENEWAL_CERT_ATTRIBUTE",
		"The request contains an invalid renewal certificate attribute."
	},
	{
		HRES_CERTSRV_E_NO_DB_SESSIONS,
		"HRES_CERTSRV_E_NO_DB_SESSIONS",
		"An attempt was made to open a CA database session, but there are already too many active sessions. The server needs to be configured to allow additional sessions."
	},
	{
		HRES_CERTSRV_E_ALIGNMENT_FAULT,
		"HRES_CERTSRV_E_ALIGNMENT_FAULT",
		"A memory reference caused a data alignment fault."
	},
	{
		HRES_CERTSRV_E_ENROLL_DENIED,
		"HRES_CERTSRV_E_ENROLL_DENIED",
		"The permissions on this CA do not allow the current user to enroll for certificates."
	},
	{
		HRES_CERTSRV_E_TEMPLATE_DENIED,
		"HRES_CERTSRV_E_TEMPLATE_DENIED",
		"The permissions on the certificate template do not allow the current user to enroll for this type of certificate."
	},
	{
		HRES_CERTSRV_E_DOWNLEVEL_DC_SSL_OR_UPGRADE,
		"HRES_CERTSRV_E_DOWNLEVEL_DC_SSL_OR_UPGRADE",
		"The contacted domain controller cannot support signed Lightweight Directory Access Protocol (LDAP) traffic. Update the domain controller or configure Certificate Services to use SSL for Active Directory access."
	},
	{
		HRES_CERTSRV_E_UNSUPPORTED_CERT_TYPE,
		"HRES_CERTSRV_E_UNSUPPORTED_CERT_TYPE",
		"The requested certificate template is not supported by this CA."
	},
	{
		HRES_CERTSRV_E_NO_CERT_TYPE,
		"HRES_CERTSRV_E_NO_CERT_TYPE",
		"The request contains no certificate template information."
	},
	{
		HRES_CERTSRV_E_TEMPLATE_CONFLICT,
		"HRES_CERTSRV_E_TEMPLATE_CONFLICT",
		"The request contains conflicting template information."
	},
	{
		HRES_CERTSRV_E_SUBJECT_ALT_NAME_REQUIRED,
		"HRES_CERTSRV_E_SUBJECT_ALT_NAME_REQUIRED",
		"The request is missing a required Subject Alternate name extension."
	},
	{
		HRES_CERTSRV_E_ARCHIVED_KEY_REQUIRED,
		"HRES_CERTSRV_E_ARCHIVED_KEY_REQUIRED",
		"The request is missing a required private key for archival by the server."
	},
	{
		HRES_CERTSRV_E_SMIME_REQUIRED,
		"HRES_CERTSRV_E_SMIME_REQUIRED",
		"The request is missing a required SMIME capabilities extension."
	},
	{
		HRES_CERTSRV_E_BAD_RENEWAL_SUBJECT,
		"HRES_CERTSRV_E_BAD_RENEWAL_SUBJECT",
		"The request was made on behalf of a subject other than the caller. The certificate template must be configured to require at least one signature to authorize the request."
	},
	{
		HRES_CERTSRV_E_BAD_TEMPLATE_VERSION,
		"HRES_CERTSRV_E_BAD_TEMPLATE_VERSION",
		"The request template version is newer than the supported template version."
	},
	{
		HRES_CERTSRV_E_TEMPLATE_POLICY_REQUIRED,
		"HRES_CERTSRV_E_TEMPLATE_POLICY_REQUIRED",
		"The template is missing a required signature policy attribute."
	},
	{
		HRES_CERTSRV_E_SIGNATURE_POLICY_REQUIRED,
		"HRES_CERTSRV_E_SIGNATURE_POLICY_REQUIRED",
		"The request is missing required signature policy information."
	},
	{
		HRES_CERTSRV_E_SIGNATURE_COUNT,
		"HRES_CERTSRV_E_SIGNATURE_COUNT",
		"The request is missing one or more required signatures."
	},
	{
		HRES_CERTSRV_E_SIGNATURE_REJECTED,
		"HRES_CERTSRV_E_SIGNATURE_REJECTED",
		"One or more signatures did not include the required application or issuance policies. The request is missing one or more required valid signatures."
	},
	{
		HRES_CERTSRV_E_ISSUANCE_POLICY_REQUIRED,
		"HRES_CERTSRV_E_ISSUANCE_POLICY_REQUIRED",
		"The request is missing one or more required signature issuance policies."
	},
	{
		HRES_CERTSRV_E_SUBJECT_UPN_REQUIRED,
		"HRES_CERTSRV_E_SUBJECT_UPN_REQUIRED",
		"The UPN is unavailable and cannot be added to the Subject Alternate name."
	},
	{
		HRES_CERTSRV_E_SUBJECT_DIRECTORY_GUID_REQUIRED,
		"HRES_CERTSRV_E_SUBJECT_DIRECTORY_GUID_REQUIRED",
		"The Active Directory GUID is unavailable and cannot be added to the Subject Alternate name."
	},
	{
		HRES_CERTSRV_E_SUBJECT_DNS_REQUIRED,
		"HRES_CERTSRV_E_SUBJECT_DNS_REQUIRED",
		"The Domain Name System (DNS) name is unavailable and cannot be added to the Subject Alternate name."
	},
	{
		HRES_CERTSRV_E_ARCHIVED_KEY_UNEXPECTED,
		"HRES_CERTSRV_E_ARCHIVED_KEY_UNEXPECTED",
		"The request includes a private key for archival by the server, but key archival is not enabled for the specified certificate template."
	},
	{
		HRES_CERTSRV_E_KEY_LENGTH,
		"HRES_CERTSRV_E_KEY_LENGTH",
		"The public key does not meet the minimum size required by the specified certificate template."
	},
	{
		HRES_CERTSRV_E_SUBJECT_EMAIL_REQUIRED,
		"HRES_CERTSRV_E_SUBJECT_EMAIL_REQUIRED",
		"The email name is unavailable and cannot be added to the Subject or Subject Alternate name."
	},
	{
		HRES_CERTSRV_E_UNKNOWN_CERT_TYPE,
		"HRES_CERTSRV_E_UNKNOWN_CERT_TYPE",
		"One or more certificate templates to be enabled on this CA could not be found."
	},
	{
		HRES_CERTSRV_E_CERT_TYPE_OVERLAP,
		"HRES_CERTSRV_E_CERT_TYPE_OVERLAP",
		"The certificate template renewal period is longer than the certificate validity period. The template should be reconfigured or the CA certificate renewed."
	},
	{
		HRES_CERTSRV_E_TOO_MANY_SIGNATURES,
		"HRES_CERTSRV_E_TOO_MANY_SIGNATURES",
		"The certificate template requires too many return authorization (RA) signatures. Only one RA signature is allowed."
	},
	{
		HRES_CERTSRV_E_RENEWAL_BAD_PUBLIC_KEY,
		"HRES_CERTSRV_E_RENEWAL_BAD_PUBLIC_KEY",
		"The key used in a renewal request does not match one of the certificates being renewed."
	},
	{
		HRES_CERTSRV_E_INVALID_EK,
		"HRES_CERTSRV_E_INVALID_EK",
		"The endorsement key certificate is not valid."
	},
	{
		HRES_CERTSRV_E_KEY_ATTESTATION,
		"HRES_CERTSRV_E_KEY_ATTESTATION",
		"Key attestation did not succeed."
	},
	{
		HRES_XENROLL_E_KEY_NOT_EXPORTABLE,
		"HRES_XENROLL_E_KEY_NOT_EXPORTABLE",
		"The key is not exportable."
	},
	{
		HRES_XENROLL_E_CANNOT_ADD_ROOT_CERT,
		"HRES_XENROLL_E_CANNOT_ADD_ROOT_CERT",
		"You cannot add the root CA certificate into your local store."
	},
	{
		HRES_XENROLL_E_RESPONSE_KA_HASH_NOT_FOUND,
		"HRES_XENROLL_E_RESPONSE_KA_HASH_NOT_FOUND",
		"The key archival hash attribute was not found in the response."
	},
	{
		HRES_XENROLL_E_RESPONSE_UNEXPECTED_KA_HASH,
		"HRES_XENROLL_E_RESPONSE_UNEXPECTED_KA_HASH",
		"An unexpected key archival hash attribute was found in the response."
	},
	{
		HRES_XENROLL_E_RESPONSE_KA_HASH_MISMATCH,
		"HRES_XENROLL_E_RESPONSE_KA_HASH_MISMATCH",
		"There is a key archival hash mismatch between the request and the response."
	},
	{
		HRES_XENROLL_E_KEYSPEC_SMIME_MISMATCH,
		"HRES_XENROLL_E_KEYSPEC_SMIME_MISMATCH",
		"Signing certificate cannot include SMIME extension."
	},
	{
		HRES_TRUST_E_SYSTEM_ERROR,
		"HRES_TRUST_E_SYSTEM_ERROR",
		"A system-level error occurred while verifying trust."
	},
	{
		HRES_TRUST_E_NO_SIGNER_CERT,
		"HRES_TRUST_E_NO_SIGNER_CERT",
		"The certificate for the signer of the message is invalid or not found."
	},
	{
		HRES_TRUST_E_COUNTER_SIGNER,
		"HRES_TRUST_E_COUNTER_SIGNER",
		"One of the counter signatures was invalid."
	},
	{
		HRES_TRUST_E_CERT_SIGNATURE,
		"HRES_TRUST_E_CERT_SIGNATURE",
		"The signature of the certificate cannot be verified."
	},
	{
		HRES_TRUST_E_TIME_STAMP,
		"HRES_TRUST_E_TIME_STAMP",
		"The time-stamp signature or certificate could not be verified or is malformed."
	},
	{
		HRES_TRUST_E_BAD_DIGEST,
		"HRES_TRUST_E_BAD_DIGEST",
		"The digital signature of the object did not verify."
	},
	{
		HRES_TRUST_E_BASIC_CONSTRAINTS,
		"HRES_TRUST_E_BASIC_CONSTRAINTS",
		"A certificate's basic constraint extension has not been observed."
	},
	{
		HRES_TRUST_E_FINANCIAL_CRITERIA,
		"HRES_TRUST_E_FINANCIAL_CRITERIA",
		"The certificate does not meet or contain the Authenticode financial extensions."
	},
	{
		HRES_MSSIPOTF_E_OUTOFMEMRANGE,
		"HRES_MSSIPOTF_E_OUTOFMEMRANGE",
		"Tried to reference a part of the file outside the proper range."
	},
	{
		HRES_MSSIPOTF_E_CANTGETOBJECT,
		"HRES_MSSIPOTF_E_CANTGETOBJECT",
		"Could not retrieve an object from the file."
	},
	{
		HRES_MSSIPOTF_E_NOHEADTABLE,
		"HRES_MSSIPOTF_E_NOHEADTABLE",
		"Could not find the head table in the file."
	},
	{
		HRES_MSSIPOTF_E_BAD_MAGICNUMBER,
		"HRES_MSSIPOTF_E_BAD_MAGICNUMBER",
		"The magic number in the head table is incorrect."
	},
	{
		HRES_MSSIPOTF_E_BAD_OFFSET_TABLE,
		"HRES_MSSIPOTF_E_BAD_OFFSET_TABLE",
		"The offset table has incorrect values."
	},
	{
		HRES_MSSIPOTF_E_TABLE_TAGORDER,
		"HRES_MSSIPOTF_E_TABLE_TAGORDER",
		"Duplicate table tags or the tags are out of alphabetical order."
	},
	{
		HRES_MSSIPOTF_E_TABLE_LONGWORD,
		"HRES_MSSIPOTF_E_TABLE_LONGWORD",
		"A table does not start on a long word boundary."
	},
	{
		HRES_MSSIPOTF_E_BAD_FIRST_TABLE_PLACEMENT,
		"HRES_MSSIPOTF_E_BAD_FIRST_TABLE_PLACEMENT",
		"First table does not appear after header information."
	},
	{
		HRES_MSSIPOTF_E_TABLES_OVERLAP,
		"HRES_MSSIPOTF_E_TABLES_OVERLAP",
		"Two or more tables overlap."
	},
	{
		HRES_MSSIPOTF_E_TABLE_PADBYTES,
		"HRES_MSSIPOTF_E_TABLE_PADBYTES",
		"Too many pad bytes between tables, or pad bytes are not 0."
	},
	{
		HRES_MSSIPOTF_E_FILETOOSMALL,
		"HRES_MSSIPOTF_E_FILETOOSMALL",
		"File is too small to contain the last table."
	},
	{
		HRES_MSSIPOTF_E_TABLE_CHECKSUM,
		"HRES_MSSIPOTF_E_TABLE_CHECKSUM",
		"A table checksum is incorrect."
	},
	{
		HRES_MSSIPOTF_E_FILE_CHECKSUM,
		"HRES_MSSIPOTF_E_FILE_CHECKSUM",
		"The file checksum is incorrect."
	},
	{
		HRES_MSSIPOTF_E_FAILED_POLICY,
		"HRES_MSSIPOTF_E_FAILED_POLICY",
		"The signature does not have the correct attributes for the policy."
	},
	{
		HRES_MSSIPOTF_E_FAILED_HINTS_CHECK,
		"HRES_MSSIPOTF_E_FAILED_HINTS_CHECK",
		"The file did not pass the hints check."
	},
	{
		HRES_MSSIPOTF_E_NOT_OPENTYPE,
		"HRES_MSSIPOTF_E_NOT_OPENTYPE",
		"The file is not an OpenType file."
	},
	{
		HRES_MSSIPOTF_E_FILE,
		"HRES_MSSIPOTF_E_FILE",
		"Failed on a file operation (such as open, map, read, or write)."
	},
	{
		HRES_MSSIPOTF_E_CRYPT,
		"HRES_MSSIPOTF_E_CRYPT",
		"A call to a CryptoAPI function failed."
	},
	{
		HRES_MSSIPOTF_E_BADVERSION,
		"HRES_MSSIPOTF_E_BADVERSION",
		"There is a bad version number in the file."
	},
	{
		HRES_MSSIPOTF_E_DSIG_STRUCTURE,
		"HRES_MSSIPOTF_E_DSIG_STRUCTURE",
		"The structure of the DSIG table is incorrect."
	},
	{
		HRES_MSSIPOTF_E_PCONST_CHECK,
		"HRES_MSSIPOTF_E_PCONST_CHECK",
		"A check failed in a partially constant table."
	},
	{
		HRES_MSSIPOTF_E_STRUCTURE,
		"HRES_MSSIPOTF_E_STRUCTURE",
		"Some kind of structural error."
	},
	{
		HRES_ERROR_CRED_REQUIRES_CONFIRMATION,
		"HRES_ERROR_CRED_REQUIRES_CONFIRMATION",
		"The requested credential requires confirmation."
	},
	{
		HRES_TRUST_E_PROVIDER_UNKNOWN,
		"HRES_TRUST_E_PROVIDER_UNKNOWN",
		"Unknown trust provider."
	},
	{
		HRES_TRUST_E_ACTION_UNKNOWN,
		"HRES_TRUST_E_ACTION_UNKNOWN",
		"The trust verification action specified is not supported by the specified trust provider."
	},
	{
		HRES_TRUST_E_SUBJECT_FORM_UNKNOWN,
		"HRES_TRUST_E_SUBJECT_FORM_UNKNOWN",
		"The form specified for the subject is not one supported or known by the specified trust provider."
	},
	{
		HRES_TRUST_E_SUBJECT_NOT_TRUSTED,
		"HRES_TRUST_E_SUBJECT_NOT_TRUSTED",
		"The subject is not trusted for the specified action."
	},
	{
		HRES_DIGSIG_E_ENCODE,
		"HRES_DIGSIG_E_ENCODE",
		"Error due to problem in ASN.1 encoding process."
	},
	{
		HRES_DIGSIG_E_DECODE,
		"HRES_DIGSIG_E_DECODE",
		"Error due to problem in ASN.1 decoding process."
	},
	{
		HRES_DIGSIG_E_EXTENSIBILITY,
		"HRES_DIGSIG_E_EXTENSIBILITY",
		"Reading/writing extensions where attributes are appropriate, and vice versa."
	},
	{
		HRES_DIGSIG_E_CRYPTO,
		"HRES_DIGSIG_E_CRYPTO",
		"Unspecified cryptographic failure."
	},
	{
		HRES_PERSIST_E_SIZEDEFINITE,
		"HRES_PERSIST_E_SIZEDEFINITE",
		"The size of the data could not be determined."
	},
	{
		HRES_PERSIST_E_SIZEINDEFINITE,
		"HRES_PERSIST_E_SIZEINDEFINITE",
		"The size of the indefinite-sized data could not be determined."
	},
	{
		HRES_PERSIST_E_NOTSELFSIZING,
		"HRES_PERSIST_E_NOTSELFSIZING",
		"This object does not read and write self-sizing data."
	},
	{
		HRES_TRUST_E_NOSIGNATURE,
		"HRES_TRUST_E_NOSIGNATURE",
		"No signature was present in the subject."
	},
	{
		HRES_CERT_E_EXPIRED,
		"HRES_CERT_E_EXPIRED",
		"A required certificate is not within its validity period when verifying against the current system clock or the time stamp in the signed file."
	},
	{
		HRES_CERT_E_VALIDITYPERIODNESTING,
		"HRES_CERT_E_VALIDITYPERIODNESTING",
		"The validity periods of the certification chain do not nest correctly."
	},
	{
		HRES_CERT_E_ROLE,
		"HRES_CERT_E_ROLE",
		"A certificate that can only be used as an end entity is being used as a CA or vice versa."
	},
	{
		HRES_CERT_E_PATHLENCONST,
		"HRES_CERT_E_PATHLENCONST",
		"A path length constraint in the certification chain has been violated."
	},
	{
		HRES_CERT_E_CRITICAL,
		"HRES_CERT_E_CRITICAL",
		"A certificate contains an unknown extension that is marked \"critical\"."
	},
	{
		HRES_CERT_E_PURPOSE,
		"HRES_CERT_E_PURPOSE",
		"A certificate is being used for a purpose other than the ones specified by its CA."
	},
	{
		HRES_CERT_E_ISSUERCHAINING,
		"HRES_CERT_E_ISSUERCHAINING",
		"A parent of a given certificate did not issue that child certificate."
	},
	{
		HRES_CERT_E_MALFORMED,
		"HRES_CERT_E_MALFORMED",
		"A certificate is missing or has an empty value for an important field, such as a subject or issuer name."
	},
	{
		HRES_CERT_E_UNTRUSTEDROOT,
		"HRES_CERT_E_UNTRUSTEDROOT",
		"A certificate chain processed, but terminated in a root certificate that is not trusted by the trust provider."
	},
	{
		HRES_CERT_E_CHAINING,
		"HRES_CERT_E_CHAINING",
		"A certificate chain could not be built to a trusted root authority."
	},
	{
		HRES_TRUST_E_FAIL,
		"HRES_TRUST_E_FAIL",
		"Generic trust failure."
	},
	{
		HRES_CERT_E_REVOKED,
		"HRES_CERT_E_REVOKED",
		"A certificate was explicitly revoked by its issuer."
	},
	{
		HRES_CERT_E_UNTRUSTEDTESTROOT,
		"HRES_CERT_E_UNTRUSTEDTESTROOT",
		"The certification path terminates with the test root that is not trusted with the current policy settings."
	},
	{
		HRES_CERT_E_REVOCATION_FAILURE,
		"HRES_CERT_E_REVOCATION_FAILURE",
		"The revocation process could not continue—the certificates could not be checked."
	},
	{
		HRES_CERT_E_CN_NO_MATCH,
		"HRES_CERT_E_CN_NO_MATCH",
		"The certificate's CN name does not match the passed value."
	},
	{
		HRES_CERT_E_WRONG_USAGE,
		"HRES_CERT_E_WRONG_USAGE",
		"The certificate is not valid for the requested usage."
	},
	{
		HRES_TRUST_E_EXPLICIT_DISTRUST,
		"HRES_TRUST_E_EXPLICIT_DISTRUST",
		"The certificate was explicitly marked as untrusted by the user."
	},
	{
		HRES_CERT_E_UNTRUSTEDCA,
		"HRES_CERT_E_UNTRUSTEDCA",
		"A certification chain processed correctly, but one of the CA certificates is not trusted by the policy provider."
	},
	{
		HRES_CERT_E_INVALID_POLICY,
		"HRES_CERT_E_INVALID_POLICY",
		"The certificate has invalid policy."
	},
	{
		HRES_CERT_E_INVALID_NAME,
		"HRES_CERT_E_INVALID_NAME",
		"The certificate has an invalid name. The name is not included in the permitted list or is explicitly excluded."
	},
	{
		HRES_NS_W_SERVER_BANDWIDTH_LIMIT,
		"HRES_NS_W_SERVER_BANDWIDTH_LIMIT",
		"The maximum filebitrate value specified is greater than the server's configured maximum bandwidth."
	},
	{
		HRES_NS_W_FILE_BANDWIDTH_LIMIT,
		"HRES_NS_W_FILE_BANDWIDTH_LIMIT",
		"The maximum bandwidth value specified is less than the maximum filebitrate."
	},
	{
		HRES_NS_W_UNKNOWN_EVENT,
		"HRES_NS_W_UNKNOWN_EVENT",
		"Unknown %1 event encountered."
	},
	{
		HRES_NS_I_CATATONIC_FAILURE,
		"HRES_NS_I_CATATONIC_FAILURE",
		"Disk %1 ( %2 ) on Content Server %3, will be failed because it is catatonic."
	},
	{
		HRES_NS_I_CATATONIC_AUTO_UNFAIL,
		"HRES_NS_I_CATATONIC_AUTO_UNFAIL",
		"Disk %1 ( %2 ) on Content Server %3, auto online from catatonic state."
	},
	{
		HRES_SPAPI_E_EXPECTED_SECTION_NAME,
		"HRES_SPAPI_E_EXPECTED_SECTION_NAME",
		"A non-empty line was encountered in the INF before the start of a section."
	},
	{
		HRES_SPAPI_E_BAD_SECTION_NAME_LINE,
		"HRES_SPAPI_E_BAD_SECTION_NAME_LINE",
		"A section name marker in the information file (INF) is not complete or does not exist on a line by itself."
	},
	{
		HRES_SPAPI_E_SECTION_NAME_TOO_LONG,
		"HRES_SPAPI_E_SECTION_NAME_TOO_LONG",
		"An INF section was encountered whose name exceeds the maximum section name length."
	},
	{
		HRES_SPAPI_E_GENERAL_SYNTAX,
		"HRES_SPAPI_E_GENERAL_SYNTAX",
		"The syntax of the INF is invalid."
	},
	{
		HRES_SPAPI_E_WRONG_INF_STYLE,
		"HRES_SPAPI_E_WRONG_INF_STYLE",
		"The style of the INF is different than what was requested."
	},
	{
		HRES_SPAPI_E_SECTION_NOT_FOUND,
		"HRES_SPAPI_E_SECTION_NOT_FOUND",
		"The required section was not found in the INF."
	},
	{
		HRES_SPAPI_E_LINE_NOT_FOUND,
		"HRES_SPAPI_E_LINE_NOT_FOUND",
		"The required line was not found in the INF."
	},
	{
		HRES_SPAPI_E_NO_BACKUP,
		"HRES_SPAPI_E_NO_BACKUP",
		"The files affected by the installation of this file queue have not been backed up for uninstall."
	},
	{
		HRES_SPAPI_E_NO_ASSOCIATED_CLASS,
		"HRES_SPAPI_E_NO_ASSOCIATED_CLASS",
		"The INF or the device information set or element does not have an associated install class."
	},
	{
		HRES_SPAPI_E_CLASS_MISMATCH,
		"HRES_SPAPI_E_CLASS_MISMATCH",
		"The INF or the device information set or element does not match the specified install class."
	},
	{
		HRES_SPAPI_E_DUPLICATE_FOUND,
		"HRES_SPAPI_E_DUPLICATE_FOUND",
		"An existing device was found that is a duplicate of the device being manually installed."
	},
	{
		HRES_SPAPI_E_NO_DRIVER_SELECTED,
		"HRES_SPAPI_E_NO_DRIVER_SELECTED",
		"There is no driver selected for the device information set or element."
	},
	{
		HRES_SPAPI_E_KEY_DOES_NOT_EXIST,
		"HRES_SPAPI_E_KEY_DOES_NOT_EXIST",
		"The requested device registry key does not exist."
	},
	{
		HRES_SPAPI_E_INVALID_DEVINST_NAME,
		"HRES_SPAPI_E_INVALID_DEVINST_NAME",
		"The device instance name is invalid."
	},
	{
		HRES_SPAPI_E_INVALID_CLASS,
		"HRES_SPAPI_E_INVALID_CLASS",
		"The install class is not present or is invalid."
	},
	{
		HRES_SPAPI_E_DEVINST_ALREADY_EXISTS,
		"HRES_SPAPI_E_DEVINST_ALREADY_EXISTS",
		"The device instance cannot be created because it already exists."
	},
	{
		HRES_SPAPI_E_DEVINFO_NOT_REGISTERED,
		"HRES_SPAPI_E_DEVINFO_NOT_REGISTERED",
		"The operation cannot be performed on a device information element that has not been registered."
	},
	{
		HRES_SPAPI_E_INVALID_REG_PROPERTY,
		"HRES_SPAPI_E_INVALID_REG_PROPERTY",
		"The device property code is invalid."
	},
	{
		HRES_SPAPI_E_NO_INF,
		"HRES_SPAPI_E_NO_INF",
		"The INF from which a driver list is to be built does not exist."
	},
	{
		HRES_SPAPI_E_NO_SUCH_DEVINST,
		"HRES_SPAPI_E_NO_SUCH_DEVINST",
		"The device instance does not exist in the hardware tree."
	},
	{
		HRES_SPAPI_E_CANT_LOAD_CLASS_ICON,
		"HRES_SPAPI_E_CANT_LOAD_CLASS_ICON",
		"The icon representing this install class cannot be loaded."
	},
	{
		HRES_SPAPI_E_INVALID_CLASS_INSTALLER,
		"HRES_SPAPI_E_INVALID_CLASS_INSTALLER",
		"The class installer registry entry is invalid."
	},
	{
		HRES_SPAPI_E_DI_DO_DEFAULT,
		"HRES_SPAPI_E_DI_DO_DEFAULT",
		"The class installer has indicated that the default action should be performed for this installation request."
	},
	{
		HRES_SPAPI_E_DI_NOFILECOPY,
		"HRES_SPAPI_E_DI_NOFILECOPY",
		"The operation does not require any files to be copied."
	},
	{
		HRES_SPAPI_E_INVALID_HWPROFILE,
		"HRES_SPAPI_E_INVALID_HWPROFILE",
		"The specified hardware profile does not exist."
	},
	{
		HRES_SPAPI_E_NO_DEVICE_SELECTED,
		"HRES_SPAPI_E_NO_DEVICE_SELECTED",
		"There is no device information element currently selected for this device information set."
	},
	{
		HRES_SPAPI_E_DEVINFO_LIST_LOCKED,
		"HRES_SPAPI_E_DEVINFO_LIST_LOCKED",
		"The operation cannot be performed because the device information set is locked."
	},
	{
		HRES_SPAPI_E_DEVINFO_DATA_LOCKED,
		"HRES_SPAPI_E_DEVINFO_DATA_LOCKED",
		"The operation cannot be performed because the device information element is locked."
	},
	{
		HRES_SPAPI_E_DI_BAD_PATH,
		"HRES_SPAPI_E_DI_BAD_PATH",
		"The specified path does not contain any applicable device INFs."
	},
	{
		HRES_SPAPI_E_NO_CLASSINSTALL_PARAMS,
		"HRES_SPAPI_E_NO_CLASSINSTALL_PARAMS",
		"No class installer parameters have been set for the device information set or element."
	},
	{
		HRES_SPAPI_E_FILEQUEUE_LOCKED,
		"HRES_SPAPI_E_FILEQUEUE_LOCKED",
		"The operation cannot be performed because the file queue is locked."
	},
	{
		HRES_SPAPI_E_BAD_SERVICE_INSTALLSECT,
		"HRES_SPAPI_E_BAD_SERVICE_INSTALLSECT",
		"A service installation section in this INF is invalid."
	},
	{
		HRES_SPAPI_E_NO_CLASS_DRIVER_LIST,
		"HRES_SPAPI_E_NO_CLASS_DRIVER_LIST",
		"There is no class driver list for the device information element."
	},
	{
		HRES_SPAPI_E_NO_ASSOCIATED_SERVICE,
		"HRES_SPAPI_E_NO_ASSOCIATED_SERVICE",
		"The installation failed because a function driver was not specified for this device instance."
	},
	{
		HRES_SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE,
		"HRES_SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE",
		"There is presently no default device interface designated for this interface class."
	},
	{
		HRES_SPAPI_E_DEVICE_INTERFACE_ACTIVE,
		"HRES_SPAPI_E_DEVICE_INTERFACE_ACTIVE",
		"The operation cannot be performed because the device interface is currently active."
	},
	{
		HRES_SPAPI_E_DEVICE_INTERFACE_REMOVED,
		"HRES_SPAPI_E_DEVICE_INTERFACE_REMOVED",
		"The operation cannot be performed because the device interface has been removed from the system."
	},
	{
		HRES_SPAPI_E_BAD_INTERFACE_INSTALLSECT,
		"HRES_SPAPI_E_BAD_INTERFACE_INSTALLSECT",
		"An interface installation section in this INF is invalid."
	},
	{
		HRES_SPAPI_E_NO_SUCH_INTERFACE_CLASS,
		"HRES_SPAPI_E_NO_SUCH_INTERFACE_CLASS",
		"This interface class does not exist in the system."
	},
	{
		HRES_SPAPI_E_INVALID_REFERENCE_STRING,
		"HRES_SPAPI_E_INVALID_REFERENCE_STRING",
		"The reference string supplied for this interface device is invalid."
	},
	{
		HRES_SPAPI_E_INVALID_MACHINENAME,
		"HRES_SPAPI_E_INVALID_MACHINENAME",
		"The specified machine name does not conform to Universal Naming Convention (UNCs)."
	},
	{
		HRES_SPAPI_E_REMOTE_COMM_FAILURE,
		"HRES_SPAPI_E_REMOTE_COMM_FAILURE",
		"A general remote communication error occurred."
	},
	{
		HRES_SPAPI_E_MACHINE_UNAVAILABLE,
		"HRES_SPAPI_E_MACHINE_UNAVAILABLE",
		"The machine selected for remote communication is not available at this time."
	},
	{
		HRES_SPAPI_E_NO_CONFIGMGR_SERVICES,
		"HRES_SPAPI_E_NO_CONFIGMGR_SERVICES",
		"The Plug and Play service is not available on the remote machine."
	},
	{
		HRES_SPAPI_E_INVALID_PROPPAGE_PROVIDER,
		"HRES_SPAPI_E_INVALID_PROPPAGE_PROVIDER",
		"The property page provider registry entry is invalid."
	},
	{
		HRES_SPAPI_E_NO_SUCH_DEVICE_INTERFACE,
		"HRES_SPAPI_E_NO_SUCH_DEVICE_INTERFACE",
		"The requested device interface is not present in the system."
	},
	{
		HRES_SPAPI_E_DI_POSTPROCESSING_REQUIRED,
		"HRES_SPAPI_E_DI_POSTPROCESSING_REQUIRED",
		"The device's co-installer has additional work to perform after installation is complete."
	},
	{
		HRES_SPAPI_E_INVALID_COINSTALLER,
		"HRES_SPAPI_E_INVALID_COINSTALLER",
		"The device's co-installer is invalid."
	},
	{
		HRES_SPAPI_E_NO_COMPAT_DRIVERS,
		"HRES_SPAPI_E_NO_COMPAT_DRIVERS",
		"There are no compatible drivers for this device."
	},
	{
		HRES_SPAPI_E_NO_DEVICE_ICON,
		"HRES_SPAPI_E_NO_DEVICE_ICON",
		"There is no icon that represents this device or device type."
	},
	{
		HRES_SPAPI_E_INVALID_INF_LOGCONFIG,
		"HRES_SPAPI_E_INVALID_INF_LOGCONFIG",
		"A logical configuration specified in this INF is invalid."
	},
	{
		HRES_SPAPI_E_DI_DONT_INSTALL,
		"HRES_SPAPI_E_DI_DONT_INSTALL",
		"The class installer has denied the request to install or upgrade this device."
	},
	{
		HRES_SPAPI_E_INVALID_FILTER_DRIVER,
		"HRES_SPAPI_E_INVALID_FILTER_DRIVER",
		"One of the filter drivers installed for this device is invalid."
	},
	{
		HRES_SPAPI_E_NON_WINDOWS_NT_DRIVER,
		"HRES_SPAPI_E_NON_WINDOWS_NT_DRIVER",
		"The driver selected for this device does not support Windows XP operating system."
	},
	{
		HRES_SPAPI_E_NON_WINDOWS_DRIVER,
		"HRES_SPAPI_E_NON_WINDOWS_DRIVER",
		"The driver selected for this device does not support Windows."
	},
	{
		HRES_SPAPI_E_NO_CATALOG_FOR_OEM_INF,
		"HRES_SPAPI_E_NO_CATALOG_FOR_OEM_INF",
		"The third-party INF does not contain digital signature information."
	},
	{
		HRES_SPAPI_E_DEVINSTALL_QUEUE_NONNATIVE,
		"HRES_SPAPI_E_DEVINSTALL_QUEUE_NONNATIVE",
		"An invalid attempt was made to use a device installation file queue for verification of digital signatures relative to other platforms."
	},
	{
		HRES_SPAPI_E_NOT_DISABLEABLE,
		"HRES_SPAPI_E_NOT_DISABLEABLE",
		"The device cannot be disabled."
	},
	{
		HRES_SPAPI_E_CANT_REMOVE_DEVINST,
		"HRES_SPAPI_E_CANT_REMOVE_DEVINST",
		"The device could not be dynamically removed."
	},
	{
		HRES_SPAPI_E_INVALID_TARGET,
		"HRES_SPAPI_E_INVALID_TARGET",
		"Cannot copy to specified target."
	},
	{
		HRES_SPAPI_E_DRIVER_NONNATIVE,
		"HRES_SPAPI_E_DRIVER_NONNATIVE",
		"Driver is not intended for this platform."
	},
	{
		HRES_SPAPI_E_IN_WOW64,
		"HRES_SPAPI_E_IN_WOW64",
		"Operation not allowed in WOW64."
	},
	{
		HRES_SPAPI_E_SET_SYSTEM_RESTORE_POINT,
		"HRES_SPAPI_E_SET_SYSTEM_RESTORE_POINT",
		"The operation involving unsigned file copying was rolled back, so that a system restore point could be set."
	},
	{
		HRES_SPAPI_E_INCORRECTLY_COPIED_INF,
		"HRES_SPAPI_E_INCORRECTLY_COPIED_INF",
		"An INF was copied into the Windows INF directory in an improper manner."
	},
	{
		HRES_SPAPI_E_SCE_DISABLED,
		"HRES_SPAPI_E_SCE_DISABLED",
		"The Security Configuration Editor (SCE) APIs have been disabled on this embedded product."
	},
	{
		HRES_SPAPI_E_UNKNOWN_EXCEPTION,
		"HRES_SPAPI_E_UNKNOWN_EXCEPTION",
		"An unknown exception was encountered."
	},
	{
		HRES_SPAPI_E_PNP_REGISTRY_ERROR,
		"HRES_SPAPI_E_PNP_REGISTRY_ERROR",
		"A problem was encountered when accessing the Plug and Play registry database."
	},
	{
		HRES_SPAPI_E_REMOTE_REQUEST_UNSUPPORTED,
		"HRES_SPAPI_E_REMOTE_REQUEST_UNSUPPORTED",
		"The requested operation is not supported for a remote machine."
	},
	{
		HRES_SPAPI_E_NOT_AN_INSTALLED_OEM_INF,
		"HRES_SPAPI_E_NOT_AN_INSTALLED_OEM_INF",
		"The specified file is not an installed original equipment manufacturer (OEM) INF."
	},
	{
		HRES_SPAPI_E_INF_IN_USE_BY_DEVICES,
		"HRES_SPAPI_E_INF_IN_USE_BY_DEVICES",
		"One or more devices are presently installed using the specified INF."
	},
	{
		HRES_SPAPI_E_DI_FUNCTION_OBSOLETE,
		"HRES_SPAPI_E_DI_FUNCTION_OBSOLETE",
		"The requested device install operation is obsolete."
	},
	{
		HRES_SPAPI_E_NO_AUTHENTICODE_CATALOG,
		"HRES_SPAPI_E_NO_AUTHENTICODE_CATALOG",
		"A file could not be verified because it does not have an associated catalog signed via Authenticode."
	},
	{
		HRES_SPAPI_E_AUTHENTICODE_DISALLOWED,
		"HRES_SPAPI_E_AUTHENTICODE_DISALLOWED",
		"Authenticode signature verification is not supported for the specified INF."
	},
	{
		HRES_SPAPI_E_AUTHENTICODE_TRUSTED_PUBLISHER,
		"HRES_SPAPI_E_AUTHENTICODE_TRUSTED_PUBLISHER",
		"The INF was signed with an Authenticode catalog from a trusted publisher."
	},
	{
		HRES_SPAPI_E_AUTHENTICODE_TRUST_NOT_ESTABLISHED,
		"HRES_SPAPI_E_AUTHENTICODE_TRUST_NOT_ESTABLISHED",
		"The publisher of an Authenticode-signed catalog has not yet been established as trusted."
	},
	{
		HRES_SPAPI_E_AUTHENTICODE_PUBLISHER_NOT_TRUSTED,
		"HRES_SPAPI_E_AUTHENTICODE_PUBLISHER_NOT_TRUSTED",
		"The publisher of an Authenticode-signed catalog was not established as trusted."
	},
	{
		HRES_SPAPI_E_SIGNATURE_OSATTRIBUTE_MISMATCH,
		"HRES_SPAPI_E_SIGNATURE_OSATTRIBUTE_MISMATCH",
		"The software was tested for compliance with Windows logo requirements on a different version of Windows and might not be compatible with this version."
	},
	{
		HRES_SPAPI_E_ONLY_VALIDATE_VIA_AUTHENTICODE,
		"HRES_SPAPI_E_ONLY_VALIDATE_VIA_AUTHENTICODE",
		"The file can be validated only by a catalog signed via Authenticode."
	},
	{
		HRES_SPAPI_E_DEVICE_INSTALLER_NOT_READY,
		"HRES_SPAPI_E_DEVICE_INSTALLER_NOT_READY",
		"One of the installers for this device cannot perform the installation at this time."
	},
	{
		HRES_SPAPI_E_DRIVER_STORE_ADD_FAILED,
		"HRES_SPAPI_E_DRIVER_STORE_ADD_FAILED",
		"A problem was encountered while attempting to add the driver to the store."
	},
	{
		HRES_SPAPI_E_DEVICE_INSTALL_BLOCKED,
		"HRES_SPAPI_E_DEVICE_INSTALL_BLOCKED",
		"The installation of this device is forbidden by system policy. Contact your system administrator."
	},
	{
		HRES_SPAPI_E_DRIVER_INSTALL_BLOCKED,
		"HRES_SPAPI_E_DRIVER_INSTALL_BLOCKED",
		"The installation of this driver is forbidden by system policy. Contact your system administrator."
	},
	{
		HRES_SPAPI_E_WRONG_INF_TYPE,
		"HRES_SPAPI_E_WRONG_INF_TYPE",
		"The specified INF is the wrong type for this operation."
	},
	{
		HRES_SPAPI_E_FILE_HASH_NOT_IN_CATALOG,
		"HRES_SPAPI_E_FILE_HASH_NOT_IN_CATALOG",
		"The hash for the file is not present in the specified catalog file. The file is likely corrupt or the victim of tampering."
	},
	{
		HRES_SPAPI_E_DRIVER_STORE_DELETE_FAILED,
		"HRES_SPAPI_E_DRIVER_STORE_DELETE_FAILED",
		"A problem was encountered while attempting to delete the driver from the store."
	},
	{
		HRES_SPAPI_E_UNRECOVERABLE_STACK_OVERFLOW,
		"HRES_SPAPI_E_UNRECOVERABLE_STACK_OVERFLOW",
		"An unrecoverable stack overflow was encountered."
	},
	{
		HRES_SPAPI_E_ERROR_NOT_INSTALLED,
		"HRES_SPAPI_E_ERROR_NOT_INSTALLED",
		"No installed components were detected."
	},
	{
		HRES_SCARD_F_INTERNAL_ERROR,
		"HRES_SCARD_F_INTERNAL_ERROR",
		"An internal consistency check failed."
	},
	{
		HRES_SCARD_E_CANCELLED,
		"HRES_SCARD_E_CANCELLED",
		"The action was canceled by an SCardCancel request."
	},
	{
		HRES_SCARD_E_INVALID_HANDLE,
		"HRES_SCARD_E_INVALID_HANDLE",
		"The supplied handle was invalid."
	},
	{
		HRES_SCARD_E_INVALID_PARAMETER,
		"HRES_SCARD_E_INVALID_PARAMETER",
		"One or more of the supplied parameters could not be properly interpreted."
	},
	{
		HRES_SCARD_E_INVALID_TARGET,
		"HRES_SCARD_E_INVALID_TARGET",
		"Registry startup information is missing or invalid."
	},
	{
		HRES_SCARD_E_NO_MEMORY,
		"HRES_SCARD_E_NO_MEMORY",
		"Not enough memory available to complete this command."
	},
	{
		HRES_SCARD_F_WAITED_TOO_LONG,
		"HRES_SCARD_F_WAITED_TOO_LONG",
		"An internal consistency timer has expired."
	},
	{
		HRES_SCARD_E_INSUFFICIENT_BUFFER,
		"HRES_SCARD_E_INSUFFICIENT_BUFFER",
		"The data buffer to receive returned data is too small for the returned data."
	},
	{
		HRES_SCARD_E_UNKNOWN_READER,
		"HRES_SCARD_E_UNKNOWN_READER",
		"The specified reader name is not recognized."
	},
	{
		HRES_SCARD_E_TIMEOUT,
		"HRES_SCARD_E_TIMEOUT",
		"The user-specified time-out value has expired."
	},
	{
		HRES_SCARD_E_SHARING_VIOLATION,
		"HRES_SCARD_E_SHARING_VIOLATION",
		"The smart card cannot be accessed because of other connections outstanding."
	},
	{
		HRES_SCARD_E_NO_SMARTCARD,
		"HRES_SCARD_E_NO_SMARTCARD",
		"The operation requires a smart card, but no smart card is currently in the device."
	},
	{
		HRES_SCARD_E_UNKNOWN_CARD,
		"HRES_SCARD_E_UNKNOWN_CARD",
		"The specified smart card name is not recognized."
	},
	{
		HRES_SCARD_E_CANT_DISPOSE,
		"HRES_SCARD_E_CANT_DISPOSE",
		"The system could not dispose of the media in the requested manner."
	},
	{
		HRES_SCARD_E_PROTO_MISMATCH,
		"HRES_SCARD_E_PROTO_MISMATCH",
		"The requested protocols are incompatible with the protocol currently in use with the smart card."
	},
	{
		HRES_SCARD_E_NOT_READY,
		"HRES_SCARD_E_NOT_READY",
		"The reader or smart card is not ready to accept commands."
	},
	{
		HRES_SCARD_E_INVALID_VALUE,
		"HRES_SCARD_E_INVALID_VALUE",
		"One or more of the supplied parameters values could not be properly interpreted."
	},
	{
		HRES_SCARD_E_SYSTEM_CANCELLED,
		"HRES_SCARD_E_SYSTEM_CANCELLED",
		"The action was canceled by the system, presumably to log off or shut down."
	},
	{
		HRES_SCARD_F_COMM_ERROR,
		"HRES_SCARD_F_COMM_ERROR",
		"An internal communications error has been detected."
	},
	{
		HRES_SCARD_F_UNKNOWN_ERROR,
		"HRES_SCARD_F_UNKNOWN_ERROR",
		"An internal error has been detected, but the source is unknown."
	},
	{
		HRES_SCARD_E_INVALID_ATR,
		"HRES_SCARD_E_INVALID_ATR",
		"An automatic terminal recognition (ATR) obtained from the registry is not a valid ATR string."
	},
	{
		HRES_SCARD_E_NOT_TRANSACTED,
		"HRES_SCARD_E_NOT_TRANSACTED",
		"An attempt was made to end a nonexistent transaction."
	},
	{
		HRES_SCARD_E_READER_UNAVAILABLE,
		"HRES_SCARD_E_READER_UNAVAILABLE",
		"The specified reader is not currently available for use."
	},
	{
		HRES_SCARD_P_SHUTDOWN,
		"HRES_SCARD_P_SHUTDOWN",
		"The operation has been aborted to allow the server application to exit."
	},
	{
		HRES_SCARD_E_PCI_TOO_SMALL,
		"HRES_SCARD_E_PCI_TOO_SMALL",
		"The peripheral component interconnect (PCI) Receive buffer was too small."
	},
	{
		HRES_SCARD_E_READER_UNSUPPORTED,
		"HRES_SCARD_E_READER_UNSUPPORTED",
		"The reader driver does not meet minimal requirements for support."
	},
	{
		HRES_SCARD_E_DUPLICATE_READER,
		"HRES_SCARD_E_DUPLICATE_READER",
		"The reader driver did not produce a unique reader name."
	},
	{
		HRES_SCARD_E_CARD_UNSUPPORTED,
		"HRES_SCARD_E_CARD_UNSUPPORTED",
		"The smart card does not meet minimal requirements for support."
	},
	{
		HRES_SCARD_E_NO_SERVICE,
		"HRES_SCARD_E_NO_SERVICE",
		"The smart card resource manager is not running."
	},
	{
		HRES_SCARD_E_SERVICE_STOPPED,
		"HRES_SCARD_E_SERVICE_STOPPED",
		"The smart card resource manager has shut down."
	},
	{
		HRES_SCARD_E_UNEXPECTED,
		"HRES_SCARD_E_UNEXPECTED",
		"An unexpected card error has occurred."
	},
	{
		HRES_SCARD_E_ICC_INSTALLATION,
		"HRES_SCARD_E_ICC_INSTALLATION",
		"No primary provider can be found for the smart card."
	},
	{
		HRES_SCARD_E_ICC_CREATEORDER,
		"HRES_SCARD_E_ICC_CREATEORDER",
		"The requested order of object creation is not supported."
	},
	{
		HRES_SCARD_E_UNSUPPORTED_FEATURE,
		"HRES_SCARD_E_UNSUPPORTED_FEATURE",
		"This smart card does not support the requested feature."
	},
	{
		HRES_SCARD_E_DIR_NOT_FOUND,
		"HRES_SCARD_E_DIR_NOT_FOUND",
		"The identified directory does not exist in the smart card."
	},
	{
		HRES_SCARD_E_FILE_NOT_FOUND,
		"HRES_SCARD_E_FILE_NOT_FOUND",
		"The identified file does not exist in the smart card."
	},
	{
		HRES_SCARD_E_NO_DIR,
		"HRES_SCARD_E_NO_DIR",
		"The supplied path does not represent a smart card directory."
	},
	{
		HRES_SCARD_E_NO_FILE,
		"HRES_SCARD_E_NO_FILE",
		"The supplied path does not represent a smart card file."
	},
	{
		HRES_SCARD_E_NO_ACCESS,
		"HRES_SCARD_E_NO_ACCESS",
		"Access is denied to this file."
	},
	{
		HRES_SCARD_E_WRITE_TOO_MANY,
		"HRES_SCARD_E_WRITE_TOO_MANY",
		"The smart card does not have enough memory to store the information."
	},
	{
		HRES_SCARD_E_BAD_SEEK,
		"HRES_SCARD_E_BAD_SEEK",
		"There was an error trying to set the smart card file object pointer."
	},
	{
		HRES_SCARD_E_INVALID_CHV,
		"HRES_SCARD_E_INVALID_CHV",
		"The supplied PIN is incorrect."
	},
	{
		HRES_SCARD_E_UNKNOWN_RES_MNG,
		"HRES_SCARD_E_UNKNOWN_RES_MNG",
		"An unrecognized error code was returned from a layered component."
	},
	{
		HRES_SCARD_E_NO_SUCH_CERTIFICATE,
		"HRES_SCARD_E_NO_SUCH_CERTIFICATE",
		"The requested certificate does not exist."
	},
	{
		HRES_SCARD_E_CERTIFICATE_UNAVAILABLE,
		"HRES_SCARD_E_CERTIFICATE_UNAVAILABLE",
		"The requested certificate could not be obtained."
	},
	{
		HRES_SCARD_E_NO_READERS_AVAILABLE,
		"HRES_SCARD_E_NO_READERS_AVAILABLE",
		"Cannot find a smart card reader."
	},
	{
		HRES_SCARD_E_COMM_DATA_LOST,
		"HRES_SCARD_E_COMM_DATA_LOST",
		"A communications error with the smart card has been detected. Retry the operation."
	},
	{
		HRES_SCARD_E_NO_KEY_CONTAINER,
		"HRES_SCARD_E_NO_KEY_CONTAINER",
		"The requested key container does not exist on the smart card."
	},
	{
		HRES_SCARD_E_SERVER_TOO_BUSY,
		"HRES_SCARD_E_SERVER_TOO_BUSY",
		"The smart card resource manager is too busy to complete this operation."
	},
	{
		HRES_SCARD_W_UNSUPPORTED_CARD,
		"HRES_SCARD_W_UNSUPPORTED_CARD",
		"The reader cannot communicate with the smart card, due to ATR configuration conflicts."
	},
	{
		HRES_SCARD_W_UNRESPONSIVE_CARD,
		"HRES_SCARD_W_UNRESPONSIVE_CARD",
		"The smart card is not responding to a reset."
	},
	{
		HRES_SCARD_W_UNPOWERED_CARD,
		"HRES_SCARD_W_UNPOWERED_CARD",
		"Power has been removed from the smart card, so that further communication is not possible."
	},
	{
		HRES_SCARD_W_RESET_CARD,
		"HRES_SCARD_W_RESET_CARD",
		"The smart card has been reset, so any shared state information is invalid."
	},
	{
		HRES_SCARD_W_REMOVED_CARD,
		"HRES_SCARD_W_REMOVED_CARD",
		"The smart card has been removed, so that further communication is not possible."
	},
	{
		HRES_SCARD_W_SECURITY_VIOLATION,
		"HRES_SCARD_W_SECURITY_VIOLATION",
		"Access was denied because of a security violation."
	},
	{
		HRES_SCARD_W_WRONG_CHV,
		"HRES_SCARD_W_WRONG_CHV",
		"The card cannot be accessed because the wrong PIN was presented."
	},
	{
		HRES_SCARD_W_CHV_BLOCKED,
		"HRES_SCARD_W_CHV_BLOCKED",
		"The card cannot be accessed because the maximum number of PIN entry attempts has been reached."
	},
	{
		HRES_SCARD_W_EOF,
		"HRES_SCARD_W_EOF",
		"The end of the smart card file has been reached."
	},
	{
		HRES_SCARD_W_CANCELLED_BY_USER,
		"HRES_SCARD_W_CANCELLED_BY_USER",
		"The action was canceled by the user."
	},
	{
		HRES_SCARD_W_CARD_NOT_AUTHENTICATED,
		"HRES_SCARD_W_CARD_NOT_AUTHENTICATED",
		"No PIN was presented to the smart card."
	},
	{
		HRES_COMADMIN_E_OBJECTERRORS,
		"HRES_COMADMIN_E_OBJECTERRORS",
		"Errors occurred accessing one or more objects—the ErrorInfo collection contains more detail."
	},
	{
		HRES_COMADMIN_E_OBJECTINVALID,
		"HRES_COMADMIN_E_OBJECTINVALID",
		"One or more of the object's properties are missing or invalid."
	},
	{
		HRES_COMADMIN_E_KEYMISSING,
		"HRES_COMADMIN_E_KEYMISSING",
		"The object was not found in the catalog."
	},
	{
		HRES_COMADMIN_E_ALREADYINSTALLED,
		"HRES_COMADMIN_E_ALREADYINSTALLED",
		"The object is already registered."
	},
	{
		HRES_COMADMIN_E_APP_FILE_WRITEFAIL,
		"HRES_COMADMIN_E_APP_FILE_WRITEFAIL",
		"An error occurred writing to the application file."
	},
	{
		HRES_COMADMIN_E_APP_FILE_READFAIL,
		"HRES_COMADMIN_E_APP_FILE_READFAIL",
		"An error occurred reading the application file."
	},
	{
		HRES_COMADMIN_E_APP_FILE_VERSION,
		"HRES_COMADMIN_E_APP_FILE_VERSION",
		"Invalid version number in application file."
	},
	{
		HRES_COMADMIN_E_BADPATH,
		"HRES_COMADMIN_E_BADPATH",
		"The file path is invalid."
	},
	{
		HRES_COMADMIN_E_APPLICATIONEXISTS,
		"HRES_COMADMIN_E_APPLICATIONEXISTS",
		"The application is already installed."
	},
	{
		HRES_COMADMIN_E_ROLEEXISTS,
		"HRES_COMADMIN_E_ROLEEXISTS",
		"The role already exists."
	},
	{
		HRES_COMADMIN_E_CANTCOPYFILE,
		"HRES_COMADMIN_E_CANTCOPYFILE",
		"An error occurred copying the file."
	},
	{
		HRES_COMADMIN_E_NOUSER,
		"HRES_COMADMIN_E_NOUSER",
		"One or more users are not valid."
	},
	{
		HRES_COMADMIN_E_INVALIDUSERIDS,
		"HRES_COMADMIN_E_INVALIDUSERIDS",
		"One or more users in the application file are not valid."
	},
	{
		HRES_COMADMIN_E_NOREGISTRYCLSID,
		"HRES_COMADMIN_E_NOREGISTRYCLSID",
		"The component's CLSID is missing or corrupt."
	},
	{
		HRES_COMADMIN_E_BADREGISTRYPROGID,
		"HRES_COMADMIN_E_BADREGISTRYPROGID",
		"The component's programmatic ID is missing or corrupt."
	},
	{
		HRES_COMADMIN_E_AUTHENTICATIONLEVEL,
		"HRES_COMADMIN_E_AUTHENTICATIONLEVEL",
		"Unable to set required authentication level for update request."
	},
	{
		HRES_COMADMIN_E_USERPASSWDNOTVALID,
		"HRES_COMADMIN_E_USERPASSWDNOTVALID",
		"The identity or password set on the application is not valid."
	},
	{
		HRES_COMADMIN_E_CLSIDORIIDMISMATCH,
		"HRES_COMADMIN_E_CLSIDORIIDMISMATCH",
		"Application file CLSIDs or instance identifiers (IIDs) do not match corresponding DLLs."
	},
	{
		HRES_COMADMIN_E_REMOTEINTERFACE,
		"HRES_COMADMIN_E_REMOTEINTERFACE",
		"Interface information is either missing or changed."
	},
	{
		HRES_COMADMIN_E_DLLREGISTERSERVER,
		"HRES_COMADMIN_E_DLLREGISTERSERVER",
		"DllRegisterServer failed on component install."
	},
	{
		HRES_COMADMIN_E_NOSERVERSHARE,
		"HRES_COMADMIN_E_NOSERVERSHARE",
		"No server file share available."
	},
	{
		HRES_COMADMIN_E_DLLLOADFAILED,
		"HRES_COMADMIN_E_DLLLOADFAILED",
		"DLL could not be loaded."
	},
	{
		HRES_COMADMIN_E_BADREGISTRYLIBID,
		"HRES_COMADMIN_E_BADREGISTRYLIBID",
		"The registered TypeLib ID is not valid."
	},
	{
		HRES_COMADMIN_E_APPDIRNOTFOUND,
		"HRES_COMADMIN_E_APPDIRNOTFOUND",
		"Application install directory not found."
	},
	{
		HRES_COMADMIN_E_REGISTRARFAILED,
		"HRES_COMADMIN_E_REGISTRARFAILED",
		"Errors occurred while in the component registrar."
	},
	{
		HRES_COMADMIN_E_COMPFILE_DOESNOTEXIST,
		"HRES_COMADMIN_E_COMPFILE_DOESNOTEXIST",
		"The file does not exist."
	},
	{
		HRES_COMADMIN_E_COMPFILE_LOADDLLFAIL,
		"HRES_COMADMIN_E_COMPFILE_LOADDLLFAIL",
		"The DLL could not be loaded."
	},
	{
		HRES_COMADMIN_E_COMPFILE_GETCLASSOBJ,
		"HRES_COMADMIN_E_COMPFILE_GETCLASSOBJ",
		"GetClassObject failed in the DLL."
	},
	{
		HRES_COMADMIN_E_COMPFILE_CLASSNOTAVAIL,
		"HRES_COMADMIN_E_COMPFILE_CLASSNOTAVAIL",
		"The DLL does not support the components listed in the TypeLib."
	},
	{
		HRES_COMADMIN_E_COMPFILE_BADTLB,
		"HRES_COMADMIN_E_COMPFILE_BADTLB",
		"The TypeLib could not be loaded."
	},
	{
		HRES_COMADMIN_E_COMPFILE_NOTINSTALLABLE,
		"HRES_COMADMIN_E_COMPFILE_NOTINSTALLABLE",
		"The file does not contain components or component information."
	},
	{
		HRES_COMADMIN_E_NOTCHANGEABLE,
		"HRES_COMADMIN_E_NOTCHANGEABLE",
		"Changes to this object and its subobjects have been disabled."
	},
	{
		HRES_COMADMIN_E_NOTDELETEABLE,
		"HRES_COMADMIN_E_NOTDELETEABLE",
		"The delete function has been disabled for this object."
	},
	{
		HRES_COMADMIN_E_SESSION,
		"HRES_COMADMIN_E_SESSION",
		"The server catalog version is not supported."
	},
	{
		HRES_COMADMIN_E_COMP_MOVE_LOCKED,
		"HRES_COMADMIN_E_COMP_MOVE_LOCKED",
		"The component move was disallowed because the source or destination application is either a system application or currently locked against changes."
	},
	{
		HRES_COMADMIN_E_COMP_MOVE_BAD_DEST,
		"HRES_COMADMIN_E_COMP_MOVE_BAD_DEST",
		"The component move failed because the destination application no longer exists."
	},
	{
		HRES_COMADMIN_E_REGISTERTLB,
		"HRES_COMADMIN_E_REGISTERTLB",
		"The system was unable to register the TypeLib."
	},
	{
		HRES_COMADMIN_E_SYSTEMAPP,
		"HRES_COMADMIN_E_SYSTEMAPP",
		"This operation cannot be performed on the system application."
	},
	{
		HRES_COMADMIN_E_COMPFILE_NOREGISTRAR,
		"HRES_COMADMIN_E_COMPFILE_NOREGISTRAR",
		"The component registrar referenced in this file is not available."
	},
	{
		HRES_COMADMIN_E_COREQCOMPINSTALLED,
		"HRES_COMADMIN_E_COREQCOMPINSTALLED",
		"A component in the same DLL is already installed."
	},
	{
		HRES_COMADMIN_E_SERVICENOTINSTALLED,
		"HRES_COMADMIN_E_SERVICENOTINSTALLED",
		"The service is not installed."
	},
	{
		HRES_COMADMIN_E_PROPERTYSAVEFAILED,
		"HRES_COMADMIN_E_PROPERTYSAVEFAILED",
		"One or more property settings are either invalid or in conflict with each other."
	},
	{
		HRES_COMADMIN_E_OBJECTEXISTS,
		"HRES_COMADMIN_E_OBJECTEXISTS",
		"The object you are attempting to add or rename already exists."
	},
	{
		HRES_COMADMIN_E_COMPONENTEXISTS,
		"HRES_COMADMIN_E_COMPONENTEXISTS",
		"The component already exists."
	},
	{
		HRES_COMADMIN_E_REGFILE_CORRUPT,
		"HRES_COMADMIN_E_REGFILE_CORRUPT",
		"The registration file is corrupt."
	},
	{
		HRES_COMADMIN_E_PROPERTY_OVERFLOW,
		"HRES_COMADMIN_E_PROPERTY_OVERFLOW",
		"The property value is too large."
	},
	{
		HRES_COMADMIN_E_NOTINREGISTRY,
		"HRES_COMADMIN_E_NOTINREGISTRY",
		"Object was not found in registry."
	},
	{
		HRES_COMADMIN_E_OBJECTNOTPOOLABLE,
		"HRES_COMADMIN_E_OBJECTNOTPOOLABLE",
		"This object cannot be pooled."
	},
	{
		HRES_COMADMIN_E_APPLID_MATCHES_CLSID,
		"HRES_COMADMIN_E_APPLID_MATCHES_CLSID",
		"A CLSID with the same GUID as the new application ID is already installed on this machine."
	},
	{
		HRES_COMADMIN_E_ROLE_DOES_NOT_EXIST,
		"HRES_COMADMIN_E_ROLE_DOES_NOT_EXIST",
		"A role assigned to a component, interface, or method did not exist in the application."
	},
	{
		HRES_COMADMIN_E_START_APP_NEEDS_COMPONENTS,
		"HRES_COMADMIN_E_START_APP_NEEDS_COMPONENTS",
		"You must have components in an application to start the application."
	},
	{
		HRES_COMADMIN_E_REQUIRES_DIFFERENT_PLATFORM,
		"HRES_COMADMIN_E_REQUIRES_DIFFERENT_PLATFORM",
		"This operation is not enabled on this platform."
	},
	{
		HRES_COMADMIN_E_CAN_NOT_EXPORT_APP_PROXY,
		"HRES_COMADMIN_E_CAN_NOT_EXPORT_APP_PROXY",
		"Application proxy is not exportable."
	},
	{
		HRES_COMADMIN_E_CAN_NOT_START_APP,
		"HRES_COMADMIN_E_CAN_NOT_START_APP",
		"Failed to start application because it is either a library application or an application proxy."
	},
	{
		HRES_COMADMIN_E_CAN_NOT_EXPORT_SYS_APP,
		"HRES_COMADMIN_E_CAN_NOT_EXPORT_SYS_APP",
		"System application is not exportable."
	},
	{
		HRES_COMADMIN_E_CANT_SUBSCRIBE_TO_COMPONENT,
		"HRES_COMADMIN_E_CANT_SUBSCRIBE_TO_COMPONENT",
		"Cannot subscribe to this component (the component might have been imported)."
	},
	{
		HRES_COMADMIN_E_EVENTCLASS_CANT_BE_SUBSCRIBER,
		"HRES_COMADMIN_E_EVENTCLASS_CANT_BE_SUBSCRIBER",
		"An event class cannot also be a subscriber component."
	},
	{
		HRES_COMADMIN_E_LIB_APP_PROXY_INCOMPATIBLE,
		"HRES_COMADMIN_E_LIB_APP_PROXY_INCOMPATIBLE",
		"Library applications and application proxies are incompatible."
	},
	{
		HRES_COMADMIN_E_BASE_PARTITION_ONLY,
		"HRES_COMADMIN_E_BASE_PARTITION_ONLY",
		"This function is valid for the base partition only."
	},
	{
		HRES_COMADMIN_E_START_APP_DISABLED,
		"HRES_COMADMIN_E_START_APP_DISABLED",
		"You cannot start an application that has been disabled."
	},
	{
		HRES_COMADMIN_E_CAT_DUPLICATE_PARTITION_NAME,
		"HRES_COMADMIN_E_CAT_DUPLICATE_PARTITION_NAME",
		"The specified partition name is already in use on this computer."
	},
	{
		HRES_COMADMIN_E_CAT_INVALID_PARTITION_NAME,
		"HRES_COMADMIN_E_CAT_INVALID_PARTITION_NAME",
		"The specified partition name is invalid. Check that the name contains at least one visible character."
	},
	{
		HRES_COMADMIN_E_CAT_PARTITION_IN_USE,
		"HRES_COMADMIN_E_CAT_PARTITION_IN_USE",
		"The partition cannot be deleted because it is the default partition for one or more users."
	},
	{
		HRES_COMADMIN_E_FILE_PARTITION_DUPLICATE_FILES,
		"HRES_COMADMIN_E_FILE_PARTITION_DUPLICATE_FILES",
		"The partition cannot be exported because one or more components in the partition have the same file name."
	},
	{
		HRES_COMADMIN_E_CAT_IMPORTED_COMPONENTS_NOT_ALLOWED,
		"HRES_COMADMIN_E_CAT_IMPORTED_COMPONENTS_NOT_ALLOWED",
		"Applications that contain one or more imported components cannot be installed into a nonbase partition."
	},
	{
		HRES_COMADMIN_E_AMBIGUOUS_APPLICATION_NAME,
		"HRES_COMADMIN_E_AMBIGUOUS_APPLICATION_NAME",
		"The application name is not unique and cannot be resolved to an application ID."
	},
	{
		HRES_COMADMIN_E_AMBIGUOUS_PARTITION_NAME,
		"HRES_COMADMIN_E_AMBIGUOUS_PARTITION_NAME",
		"The partition name is not unique and cannot be resolved to a partition ID."
	},
	{
		HRES_COMADMIN_E_REGDB_NOTINITIALIZED,
		"HRES_COMADMIN_E_REGDB_NOTINITIALIZED",
		"The COM+ registry database has not been initialized."
	},
	{
		HRES_COMADMIN_E_REGDB_NOTOPEN,
		"HRES_COMADMIN_E_REGDB_NOTOPEN",
		"The COM+ registry database is not open."
	},
	{
		HRES_COMADMIN_E_REGDB_SYSTEMERR,
		"HRES_COMADMIN_E_REGDB_SYSTEMERR",
		"The COM+ registry database detected a system error."
	},
	{
		HRES_COMADMIN_E_REGDB_ALREADYRUNNING,
		"HRES_COMADMIN_E_REGDB_ALREADYRUNNING",
		"The COM+ registry database is already running."
	},
	{
		HRES_COMADMIN_E_MIG_VERSIONNOTSUPPORTED,
		"HRES_COMADMIN_E_MIG_VERSIONNOTSUPPORTED",
		"This version of the COM+ registry database cannot be migrated."
	},
	{
		HRES_COMADMIN_E_MIG_SCHEMANOTFOUND,
		"HRES_COMADMIN_E_MIG_SCHEMANOTFOUND",
		"The schema version to be migrated could not be found in the COM+ registry database."
	},
	{
		HRES_COMADMIN_E_CAT_BITNESSMISMATCH,
		"HRES_COMADMIN_E_CAT_BITNESSMISMATCH",
		"There was a type mismatch between binaries."
	},
	{
		HRES_COMADMIN_E_CAT_UNACCEPTABLEBITNESS,
		"HRES_COMADMIN_E_CAT_UNACCEPTABLEBITNESS",
		"A binary of unknown or invalid type was provided."
	},
	{
		HRES_COMADMIN_E_CAT_WRONGAPPBITNESS,
		"HRES_COMADMIN_E_CAT_WRONGAPPBITNESS",
		"There was a type mismatch between a binary and an application."
	},
	{
		HRES_COMADMIN_E_CAT_PAUSE_RESUME_NOT_SUPPORTED,
		"HRES_COMADMIN_E_CAT_PAUSE_RESUME_NOT_SUPPORTED",
		"The application cannot be paused or resumed."
	},
	{
		HRES_COMADMIN_E_CAT_SERVERFAULT,
		"HRES_COMADMIN_E_CAT_SERVERFAULT",
		"The COM+ catalog server threw an exception during execution."
	},
	{
		HRES_COMQC_E_APPLICATION_NOT_QUEUED,
		"HRES_COMQC_E_APPLICATION_NOT_QUEUED",
		"Only COM+ applications marked \"queued\" can be invoked using the \"queue\" moniker."
	},
	{
		HRES_COMQC_E_NO_QUEUEABLE_INTERFACES,
		"HRES_COMQC_E_NO_QUEUEABLE_INTERFACES",
		"At least one interface must be marked \"queued\" to create a queued component instance with the \"queue\" moniker."
	},
	{
		HRES_COMQC_E_QUEUING_SERVICE_NOT_AVAILABLE,
		"HRES_COMQC_E_QUEUING_SERVICE_NOT_AVAILABLE",
		"Message Queuing is required for the requested operation and is not installed."
	},
	{
		HRES_COMQC_E_NO_IPERSISTSTREAM,
		"HRES_COMQC_E_NO_IPERSISTSTREAM",
		"Unable to marshal an interface that does not support IPersistStream."
	},
	{
		HRES_COMQC_E_BAD_MESSAGE,
		"HRES_COMQC_E_BAD_MESSAGE",
		"The message is improperly formatted or was damaged in transit."
	},
	{
		HRES_COMQC_E_UNAUTHENTICATED,
		"HRES_COMQC_E_UNAUTHENTICATED",
		"An unauthenticated message was received by an application that accepts only authenticated messages."
	},
	{
		HRES_COMQC_E_UNTRUSTED_ENQUEUER,
		"HRES_COMQC_E_UNTRUSTED_ENQUEUER",
		"The message was requeued or moved by a user not in the QC Trusted User \"role\"."
	},
	{
		HRES_MSDTC_E_DUPLICATE_RESOURCE,
		"HRES_MSDTC_E_DUPLICATE_RESOURCE",
		"Cannot create a duplicate resource of type Distributed Transaction Coordinator."
	},
	{
		HRES_COMADMIN_E_OBJECT_PARENT_MISSING,
		"HRES_COMADMIN_E_OBJECT_PARENT_MISSING",
		"One of the objects being inserted or updated does not belong to a valid parent collection."
	},
	{
		HRES_COMADMIN_E_OBJECT_DOES_NOT_EXIST,
		"HRES_COMADMIN_E_OBJECT_DOES_NOT_EXIST",
		"One of the specified objects cannot be found."
	},
	{
		HRES_COMADMIN_E_APP_NOT_RUNNING,
		"HRES_COMADMIN_E_APP_NOT_RUNNING",
		"The specified application is not currently running."
	},
	{
		HRES_COMADMIN_E_INVALID_PARTITION,
		"HRES_COMADMIN_E_INVALID_PARTITION",
		"The partitions specified are not valid."
	},
	{
		HRES_COMADMIN_E_SVCAPP_NOT_POOLABLE_OR_RECYCLABLE,
		"HRES_COMADMIN_E_SVCAPP_NOT_POOLABLE_OR_RECYCLABLE",
		"COM+ applications that run as Windows NT service cannot be pooled or recycled."
	},
	{
		HRES_COMADMIN_E_USER_IN_SET,
		"HRES_COMADMIN_E_USER_IN_SET",
		"One or more users are already assigned to a local partition set."
	},
	{
		HRES_COMADMIN_E_CANTRECYCLELIBRARYAPPS,
		"HRES_COMADMIN_E_CANTRECYCLELIBRARYAPPS",
		"Library applications cannot be recycled."
	},
	{
		HRES_COMADMIN_E_CANTRECYCLESERVICEAPPS,
		"HRES_COMADMIN_E_CANTRECYCLESERVICEAPPS",
		"Applications running as Windows NT services cannot be recycled."
	},
	{
		HRES_COMADMIN_E_PROCESSALREADYRECYCLED,
		"HRES_COMADMIN_E_PROCESSALREADYRECYCLED",
		"The process has already been recycled."
	},
	{
		HRES_COMADMIN_E_PAUSEDPROCESSMAYNOTBERECYCLED,
		"HRES_COMADMIN_E_PAUSEDPROCESSMAYNOTBERECYCLED",
		"A paused process cannot be recycled."
	},
	{
		HRES_COMADMIN_E_CANTMAKEINPROCSERVICE,
		"HRES_COMADMIN_E_CANTMAKEINPROCSERVICE",
		"Library applications cannot be Windows NT services."
	},
	{
		HRES_COMADMIN_E_PROGIDINUSEBYCLSID,
		"HRES_COMADMIN_E_PROGIDINUSEBYCLSID",
		"The ProgID provided to the copy operation is invalid. The ProgID is in use by another registered CLSID."
	},
	{
		HRES_COMADMIN_E_DEFAULT_PARTITION_NOT_IN_SET,
		"HRES_COMADMIN_E_DEFAULT_PARTITION_NOT_IN_SET",
		"The partition specified as the default is not a member of the partition set."
	},
	{
		HRES_COMADMIN_E_RECYCLEDPROCESSMAYNOTBEPAUSED,
		"HRES_COMADMIN_E_RECYCLEDPROCESSMAYNOTBEPAUSED",
		"A recycled process cannot be paused."
	},
	{
		HRES_COMADMIN_E_PARTITION_ACCESSDENIED,
		"HRES_COMADMIN_E_PARTITION_ACCESSDENIED",
		"Access to the specified partition is denied."
	},
	{
		HRES_COMADMIN_E_PARTITION_MSI_ONLY,
		"HRES_COMADMIN_E_PARTITION_MSI_ONLY",
		"Only application files (*.msi files) can be installed into partitions."
	},
	{
		HRES_COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_1_0_FORMAT,
		"HRES_COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_1_0_FORMAT",
		"Applications containing one or more legacy components cannot be exported to 1.0 format."
	},
	{
		HRES_COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_NONBASE_PARTITIONS,
		"HRES_COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_NONBASE_PARTITIONS",
		"Legacy components cannot exist in nonbase partitions."
	},
	{
		HRES_COMADMIN_E_COMP_MOVE_SOURCE,
		"HRES_COMADMIN_E_COMP_MOVE_SOURCE",
		"A component cannot be moved (or copied) from the System Application, an application proxy, or a nonchangeable application."
	},
	{
		HRES_COMADMIN_E_COMP_MOVE_DEST,
		"HRES_COMADMIN_E_COMP_MOVE_DEST",
		"A component cannot be moved (or copied) to the System Application, an application proxy or a nonchangeable application."
	},
	{
		HRES_COMADMIN_E_COMP_MOVE_PRIVATE,
		"HRES_COMADMIN_E_COMP_MOVE_PRIVATE",
		"A private component cannot be moved (or copied) to a library application or to the base partition."
	},
	{
		HRES_COMADMIN_E_BASEPARTITION_REQUIRED_IN_SET,
		"HRES_COMADMIN_E_BASEPARTITION_REQUIRED_IN_SET",
		"The Base Application Partition exists in all partition sets and cannot be removed."
	},
	{
		HRES_COMADMIN_E_CANNOT_ALIAS_EVENTCLASS,
		"HRES_COMADMIN_E_CANNOT_ALIAS_EVENTCLASS",
		"Alas, Event Class components cannot be aliased."
	},
	{
		HRES_COMADMIN_E_PRIVATE_ACCESSDENIED,
		"HRES_COMADMIN_E_PRIVATE_ACCESSDENIED",
		"Access is denied because the component is private."
	},
	{
		HRES_COMADMIN_E_SAFERINVALID,
		"HRES_COMADMIN_E_SAFERINVALID",
		"The specified SAFER level is invalid."
	},
	{
		HRES_COMADMIN_E_REGISTRY_ACCESSDENIED,
		"HRES_COMADMIN_E_REGISTRY_ACCESSDENIED",
		"The specified user cannot write to the system registry."
	},
	{
		HRES_COMADMIN_E_PARTITIONS_DISABLED,
		"HRES_COMADMIN_E_PARTITIONS_DISABLED",
		"COM+ partitions are currently disabled."
	},
	{
		HRES_ERROR_FLT_NO_HANDLER_DEFINED,
		"HRES_ERROR_FLT_NO_HANDLER_DEFINED",
		"A handler was not defined by the filter for this operation."
	},
	{
		HRES_ERROR_FLT_CONTEXT_ALREADY_DEFINED,
		"HRES_ERROR_FLT_CONTEXT_ALREADY_DEFINED",
		"A context is already defined for this object."
	},
	{
		HRES_ERROR_FLT_INVALID_ASYNCHRONOUS_REQUEST,
		"HRES_ERROR_FLT_INVALID_ASYNCHRONOUS_REQUEST",
		"Asynchronous requests are not valid for this operation."
	},
	{
		HRES_ERROR_FLT_DISALLOW_FAST_IO,
		"HRES_ERROR_FLT_DISALLOW_FAST_IO",
		"Disallow the Fast IO path for this operation."
	},
	{
		HRES_ERROR_FLT_INVALID_NAME_REQUEST,
		"HRES_ERROR_FLT_INVALID_NAME_REQUEST",
		"An invalid name request was made. The name requested cannot be retrieved at this time."
	},
	{
		HRES_ERROR_FLT_NOT_SAFE_TO_POST_OPERATION,
		"HRES_ERROR_FLT_NOT_SAFE_TO_POST_OPERATION",
		"Posting this operation to a worker thread for further processing is not safe at this time because it could lead to a system deadlock."
	},
	{
		HRES_ERROR_FLT_NOT_INITIALIZED,
		"HRES_ERROR_FLT_NOT_INITIALIZED",
		"The Filter Manager was not initialized when a filter tried to register. Be sure that the Filter Manager is being loaded as a driver."
	},
	{
		HRES_ERROR_FLT_FILTER_NOT_READY,
		"HRES_ERROR_FLT_FILTER_NOT_READY",
		"The filter is not ready for attachment to volumes because it has not finished initializing (FltStartFiltering has not been called)."
	},
	{
		HRES_ERROR_FLT_POST_OPERATION_CLEANUP,
		"HRES_ERROR_FLT_POST_OPERATION_CLEANUP",
		"The filter must clean up any operation-specific context at this time because it is being removed from the system before the operation is completed by the lower drivers."
	},
	{
		HRES_ERROR_FLT_INTERNAL_ERROR,
		"HRES_ERROR_FLT_INTERNAL_ERROR",
		"The Filter Manager had an internal error from which it cannot recover; therefore, the operation has been failed. This is usually the result of a filter returning an invalid value from a preoperation callback."
	},
	{
		HRES_ERROR_FLT_DELETING_OBJECT,
		"HRES_ERROR_FLT_DELETING_OBJECT",
		"The object specified for this action is in the process of being deleted; therefore, the action requested cannot be completed at this time."
	},
	{
		HRES_ERROR_FLT_MUST_BE_NONPAGED_POOL,
		"HRES_ERROR_FLT_MUST_BE_NONPAGED_POOL",
		"Nonpaged pool must be used for this type of context."
	},
	{
		HRES_ERROR_FLT_DUPLICATE_ENTRY,
		"HRES_ERROR_FLT_DUPLICATE_ENTRY",
		"A duplicate handler definition has been provided for an operation."
	},
	{
		HRES_ERROR_FLT_CBDQ_DISABLED,
		"HRES_ERROR_FLT_CBDQ_DISABLED",
		"The callback data queue has been disabled."
	},
	{
		HRES_ERROR_FLT_DO_NOT_ATTACH,
		"HRES_ERROR_FLT_DO_NOT_ATTACH",
		"Do not attach the filter to the volume at this time."
	},
	{
		HRES_ERROR_FLT_DO_NOT_DETACH,
		"HRES_ERROR_FLT_DO_NOT_DETACH",
		"Do not detach the filter from the volume at this time."
	},
	{
		HRES_ERROR_FLT_INSTANCE_ALTITUDE_COLLISION,
		"HRES_ERROR_FLT_INSTANCE_ALTITUDE_COLLISION",
		"An instance already exists at this altitude on the volume specified."
	},
	{
		HRES_ERROR_FLT_INSTANCE_NAME_COLLISION,
		"HRES_ERROR_FLT_INSTANCE_NAME_COLLISION",
		"An instance already exists with this name on the volume specified."
	},
	{
		HRES_ERROR_FLT_FILTER_NOT_FOUND,
		"HRES_ERROR_FLT_FILTER_NOT_FOUND",
		"The system could not find the filter specified."
	},
	{
		HRES_ERROR_FLT_VOLUME_NOT_FOUND,
		"HRES_ERROR_FLT_VOLUME_NOT_FOUND",
		"The system could not find the volume specified."
	},
	{
		HRES_ERROR_FLT_INSTANCE_NOT_FOUND,
		"HRES_ERROR_FLT_INSTANCE_NOT_FOUND",
		"The system could not find the instance specified."
	},
	{
		HRES_ERROR_FLT_CONTEXT_ALLOCATION_NOT_FOUND,
		"HRES_ERROR_FLT_CONTEXT_ALLOCATION_NOT_FOUND",
		"No registered context allocation definition was found for the given request."
	},
	{
		HRES_ERROR_FLT_INVALID_CONTEXT_REGISTRATION,
		"HRES_ERROR_FLT_INVALID_CONTEXT_REGISTRATION",
		"An invalid parameter was specified during context registration."
	},
	{
		HRES_ERROR_FLT_NAME_CACHE_MISS,
		"HRES_ERROR_FLT_NAME_CACHE_MISS",
		"The name requested was not found in the Filter Manager name cache and could not be retrieved from the file system."
	},
	{
		HRES_ERROR_FLT_NO_DEVICE_OBJECT,
		"HRES_ERROR_FLT_NO_DEVICE_OBJECT",
		"The requested device object does not exist for the given volume."
	},
	{
		HRES_ERROR_FLT_VOLUME_ALREADY_MOUNTED,
		"HRES_ERROR_FLT_VOLUME_ALREADY_MOUNTED",
		"The specified volume is already mounted."
	},
	{
		HRES_ERROR_FLT_ALREADY_ENLISTED,
		"HRES_ERROR_FLT_ALREADY_ENLISTED",
		"The specified Transaction Context is already enlisted in a transaction."
	},
	{
		HRES_ERROR_FLT_CONTEXT_ALREADY_LINKED,
		"HRES_ERROR_FLT_CONTEXT_ALREADY_LINKED",
		"The specified context is already attached to another object."
	},
	{
		HRES_ERROR_FLT_NO_WAITER_FOR_REPLY,
		"HRES_ERROR_FLT_NO_WAITER_FOR_REPLY",
		"No waiter is present for the filter's reply to this message."
	},
	{
		HRES_ERROR_HUNG_DISPLAY_DRIVER_THREAD,
		"HRES_ERROR_HUNG_DISPLAY_DRIVER_THREAD",
		"{Display Driver Stopped Responding} The %hs display driver has stopped working normally. Save your work and reboot the system to restore full display functionality. The next time you reboot the machine a dialog will be displayed giving you a chance to report this failure to Microsoft."
	},
	{
		HRES_ERROR_MONITOR_NO_DESCRIPTOR,
		"HRES_ERROR_MONITOR_NO_DESCRIPTOR",
		"Monitor descriptor could not be obtained."
	},
	{
		HRES_ERROR_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT,
		"HRES_ERROR_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT",
		"Format of the obtained monitor descriptor is not supported by this release."
	},
	{
		HRES_DWM_E_COMPOSITIONDISABLED,
		"HRES_DWM_E_COMPOSITIONDISABLED",
		"{Desktop Composition is Disabled} The operation could not be completed because desktop composition is disabled."
	},
	{
		HRES_DWM_E_REMOTING_NOT_SUPPORTED,
		"HRES_DWM_E_REMOTING_NOT_SUPPORTED",
		"{Some Desktop Composition APIs Are Not Supported While Remoting} Some desktop composition APIs are not supported while remoting. The operation is not supported while running in a remote session."
	},
	{
		HRES_DWM_E_NO_REDIRECTION_SURFACE_AVAILABLE,
		"HRES_DWM_E_NO_REDIRECTION_SURFACE_AVAILABLE",
		"{No DWM Redirection Surface is Available} The Desktop Window Manager (DWM) was unable to provide a redirection surface to complete the DirectX present."
	},
	{
		HRES_DWM_E_NOT_QUEUING_PRESENTS,
		"HRES_DWM_E_NOT_QUEUING_PRESENTS",
		"{DWM Is Not Queuing Presents for the Specified Window} The window specified is not currently using queued presents."
	},
	{
		HRES_TPM_E_ERROR_MASK,
		"HRES_TPM_E_ERROR_MASK",
		"This is an error mask to convert Trusted Platform Module (TPM) hardware errors to Win32 errors."
	},
	{
		HRES_TPM_E_AUTHFAIL,
		"HRES_TPM_E_AUTHFAIL",
		"Authentication failed."
	},
	{
		HRES_TPM_E_BADINDEX,
		"HRES_TPM_E_BADINDEX",
		"The index to a Platform Configuration Register (PCR), DIR, or other register is incorrect."
	},
	{
		HRES_TPM_E_BAD_PARAMETER,
		"HRES_TPM_E_BAD_PARAMETER",
		"One or more parameters are bad."
	},
	{
		HRES_TPM_E_AUDITFAILURE,
		"HRES_TPM_E_AUDITFAILURE",
		"An operation completed successfully but the auditing of that operation failed."
	},
	{
		HRES_TPM_E_CLEAR_DISABLED,
		"HRES_TPM_E_CLEAR_DISABLED",
		"The clear disable flag is set and all clear operations now require physical access."
	},
	{
		HRES_TPM_E_DEACTIVATED,
		"HRES_TPM_E_DEACTIVATED",
		"The TPM is deactivated."
	},
	{
		HRES_TPM_E_DISABLED,
		"HRES_TPM_E_DISABLED",
		"The TPM is disabled."
	},
	{
		HRES_TPM_E_DISABLED_CMD,
		"HRES_TPM_E_DISABLED_CMD",
		"The target command has been disabled."
	},
	{
		HRES_TPM_E_FAIL,
		"HRES_TPM_E_FAIL",
		"The operation failed."
	},
	{
		HRES_TPM_E_BAD_ORDINAL,
		"HRES_TPM_E_BAD_ORDINAL",
		"The ordinal was unknown or inconsistent."
	},
	{
		HRES_TPM_E_INSTALL_DISABLED,
		"HRES_TPM_E_INSTALL_DISABLED",
		"The ability to install an owner is disabled."
	},
	{
		HRES_TPM_E_INVALID_KEYHANDLE,
		"HRES_TPM_E_INVALID_KEYHANDLE",
		"The key handle cannot be interpreted."
	},
	{
		HRES_TPM_E_KEYNOTFOUND,
		"HRES_TPM_E_KEYNOTFOUND",
		"The key handle points to an invalid key."
	},
	{
		HRES_TPM_E_INAPPROPRIATE_ENC,
		"HRES_TPM_E_INAPPROPRIATE_ENC",
		"Unacceptable encryption scheme."
	},
	{
		HRES_TPM_E_MIGRATEFAIL,
		"HRES_TPM_E_MIGRATEFAIL",
		"Migration authorization failed."
	},
	{
		HRES_TPM_E_INVALID_PCR_INFO,
		"HRES_TPM_E_INVALID_PCR_INFO",
		"PCR information could not be interpreted."
	},
	{
		HRES_TPM_E_NOSPACE,
		"HRES_TPM_E_NOSPACE",
		"No room to load key."
	},
	{
		HRES_TPM_E_NOSRK,
		"HRES_TPM_E_NOSRK",
		"There is no storage root key (SRK) set."
	},
	{
		HRES_TPM_E_NOTSEALED_BLOB,
		"HRES_TPM_E_NOTSEALED_BLOB",
		"An encrypted blob is invalid or was not created by this TPM."
	},
	{
		HRES_TPM_E_OWNER_SET,
		"HRES_TPM_E_OWNER_SET",
		"There is already an owner."
	},
	{
		HRES_TPM_E_RESOURCES,
		"HRES_TPM_E_RESOURCES",
		"The TPM has insufficient internal resources to perform the requested action."
	},
	{
		HRES_TPM_E_SHORTRANDOM,
		"HRES_TPM_E_SHORTRANDOM",
		"A random string was too short."
	},
	{
		HRES_TPM_E_SIZE,
		"HRES_TPM_E_SIZE",
		"The TPM does not have the space to perform the operation."
	},
	{
		HRES_TPM_E_WRONGPCRVAL,
		"HRES_TPM_E_WRONGPCRVAL",
		"The named PCR value does not match the current PCR value."
	},
	{
		HRES_TPM_E_BAD_PARAM_SIZE,
		"HRES_TPM_E_BAD_PARAM_SIZE",
		"The paramSize argument to the command has the incorrect value."
	},
	{
		HRES_TPM_E_SHA_THREAD,
		"HRES_TPM_E_SHA_THREAD",
		"There is no existing SHA-1 thread."
	},
	{
		HRES_TPM_E_SHA_ERROR,
		"HRES_TPM_E_SHA_ERROR",
		"The calculation is unable to proceed because the existing SHA-1 thread has already encountered an error."
	},
	{
		HRES_TPM_E_FAILEDSELFTEST,
		"HRES_TPM_E_FAILEDSELFTEST",
		"Self-test has failed and the TPM has shut down."
	},
	{
		HRES_TPM_E_AUTH2FAIL,
		"HRES_TPM_E_AUTH2FAIL",
		"The authorization for the second key in a two-key function failed authorization."
	},
	{
		HRES_TPM_E_BADTAG,
		"HRES_TPM_E_BADTAG",
		"The tag value sent to for a command is invalid."
	},
	{
		HRES_TPM_E_IOERROR,
		"HRES_TPM_E_IOERROR",
		"An I/O error occurred transmitting information to the TPM."
	},
	{
		HRES_TPM_E_ENCRYPT_ERROR,
		"HRES_TPM_E_ENCRYPT_ERROR",
		"The encryption process had a problem."
	},
	{
		HRES_TPM_E_DECRYPT_ERROR,
		"HRES_TPM_E_DECRYPT_ERROR",
		"The decryption process did not complete."
	},
	{
		HRES_TPM_E_INVALID_AUTHHANDLE,
		"HRES_TPM_E_INVALID_AUTHHANDLE",
		"An invalid handle was used."
	},
	{
		HRES_TPM_E_NO_ENDORSEMENT,
		"HRES_TPM_E_NO_ENDORSEMENT",
		"The TPM does not have an endorsement key (EK) installed."
	},
	{
		HRES_TPM_E_INVALID_KEYUSAGE,
		"HRES_TPM_E_INVALID_KEYUSAGE",
		"The usage of a key is not allowed."
	},
	{
		HRES_TPM_E_WRONG_ENTITYTYPE,
		"HRES_TPM_E_WRONG_ENTITYTYPE",
		"The submitted entity type is not allowed."
	},
	{
		HRES_TPM_E_INVALID_POSTINIT,
		"HRES_TPM_E_INVALID_POSTINIT",
		"The command was received in the wrong sequence relative to TPM_Init and a subsequent TPM_Startup."
	},
	{
		HRES_TPM_E_INAPPROPRIATE_SIG,
		"HRES_TPM_E_INAPPROPRIATE_SIG",
		"Signed data cannot include additional DER information."
	},
	{
		HRES_TPM_E_BAD_KEY_PROPERTY,
		"HRES_TPM_E_BAD_KEY_PROPERTY",
		"The key properties in TPM_KEY_PARMs are not supported by this TPM."
	},
	{
		HRES_TPM_E_BAD_MIGRATION,
		"HRES_TPM_E_BAD_MIGRATION",
		"The migration properties of this key are incorrect."
	},
	{
		HRES_TPM_E_BAD_SCHEME,
		"HRES_TPM_E_BAD_SCHEME",
		"The signature or encryption scheme for this key is incorrect or not permitted in this situation."
	},
	{
		HRES_TPM_E_BAD_DATASIZE,
		"HRES_TPM_E_BAD_DATASIZE",
		"The size of the data (or blob) parameter is bad or inconsistent with the referenced key."
	},
	{
		HRES_TPM_E_BAD_MODE,
		"HRES_TPM_E_BAD_MODE",
		"A mode parameter is bad, such as capArea or subCapArea for TPM_GetCapability, physicalPresence parameter for TPM_PhysicalPresence, or migrationType for TPM_CreateMigrationBlob."
	},
	{
		HRES_TPM_E_BAD_PRESENCE,
		"HRES_TPM_E_BAD_PRESENCE",
		"Either the physicalPresence or physicalPresenceLock bits have the wrong value."
	},
	{
		HRES_TPM_E_BAD_VERSION,
		"HRES_TPM_E_BAD_VERSION",
		"The TPM cannot perform this version of the capability."
	},
	{
		HRES_TPM_E_NO_WRAP_TRANSPORT,
		"HRES_TPM_E_NO_WRAP_TRANSPORT",
		"The TPM does not allow for wrapped transport sessions."
	},
	{
		HRES_TPM_E_AUDITFAIL_UNSUCCESSFUL,
		"HRES_TPM_E_AUDITFAIL_UNSUCCESSFUL",
		"TPM audit construction failed and the underlying command was returning a failure code also."
	},
	{
		HRES_TPM_E_AUDITFAIL_SUCCESSFUL,
		"HRES_TPM_E_AUDITFAIL_SUCCESSFUL",
		"TPM audit construction failed and the underlying command was returning success."
	},
	{
		HRES_TPM_E_NOTRESETABLE,
		"HRES_TPM_E_NOTRESETABLE",
		"Attempt to reset a PCR that does not have the resettable attribute."
	},
	{
		HRES_TPM_E_NOTLOCAL,
		"HRES_TPM_E_NOTLOCAL",
		"Attempt to reset a PCR register that requires locality and the locality modifier not part of command transport."
	},
	{
		HRES_TPM_E_BAD_TYPE,
		"HRES_TPM_E_BAD_TYPE",
		"Make identity blob not properly typed."
	},
	{
		HRES_TPM_E_INVALID_RESOURCE,
		"HRES_TPM_E_INVALID_RESOURCE",
		"When saving context identified resource type does not match actual resource."
	},
	{
		HRES_TPM_E_NOTFIPS,
		"HRES_TPM_E_NOTFIPS",
		"The TPM is attempting to execute a command only available when in Federal Information Processing Standards (FIPS) mode."
	},
	{
		HRES_TPM_E_INVALID_FAMILY,
		"HRES_TPM_E_INVALID_FAMILY",
		"The command is attempting to use an invalid family ID."
	},
	{
		HRES_TPM_E_NO_NV_PERMISSION,
		"HRES_TPM_E_NO_NV_PERMISSION",
		"The permission to manipulate the NV storage is not available."
	},
	{
		HRES_TPM_E_REQUIRES_SIGN,
		"HRES_TPM_E_REQUIRES_SIGN",
		"The operation requires a signed command."
	},
	{
		HRES_TPM_E_KEY_NOTSUPPORTED,
		"HRES_TPM_E_KEY_NOTSUPPORTED",
		"Wrong operation to load an NV key."
	},
	{
		HRES_TPM_E_AUTH_CONFLICT,
		"HRES_TPM_E_AUTH_CONFLICT",
		"NV_LoadKey blob requires both owner and blob authorization."
	},
	{
		HRES_TPM_E_AREA_LOCKED,
		"HRES_TPM_E_AREA_LOCKED",
		"The NV area is locked and not writable."
	},
	{
		HRES_TPM_E_BAD_LOCALITY,
		"HRES_TPM_E_BAD_LOCALITY",
		"The locality is incorrect for the attempted operation."
	},
	{
		HRES_TPM_E_READ_ONLY,
		"HRES_TPM_E_READ_ONLY",
		"The NV area is read-only and cannot be written to."
	},
	{
		HRES_TPM_E_PER_NOWRITE,
		"HRES_TPM_E_PER_NOWRITE",
		"There is no protection on the write to the NV area."
	},
	{
		HRES_TPM_E_FAMILYCOUNT,
		"HRES_TPM_E_FAMILYCOUNT",
		"The family count value does not match."
	},
	{
		HRES_TPM_E_WRITE_LOCKED,
		"HRES_TPM_E_WRITE_LOCKED",
		"The NV area has already been written to."
	},
	{
		HRES_TPM_E_BAD_ATTRIBUTES,
		"HRES_TPM_E_BAD_ATTRIBUTES",
		"The NV area attributes conflict."
	},
	{
		HRES_TPM_E_INVALID_STRUCTURE,
		"HRES_TPM_E_INVALID_STRUCTURE",
		"The structure tag and version are invalid or inconsistent."
	},
	{
		HRES_TPM_E_KEY_OWNER_CONTROL,
		"HRES_TPM_E_KEY_OWNER_CONTROL",
		"The key is under control of the TPM owner and can only be evicted by the TPM owner."
	},
	{
		HRES_TPM_E_BAD_COUNTER,
		"HRES_TPM_E_BAD_COUNTER",
		"The counter handle is incorrect."
	},
	{
		HRES_TPM_E_NOT_FULLWRITE,
		"HRES_TPM_E_NOT_FULLWRITE",
		"The write is not a complete write of the area."
	},
	{
		HRES_TPM_E_CONTEXT_GAP,
		"HRES_TPM_E_CONTEXT_GAP",
		"The gap between saved context counts is too large."
	},
	{
		HRES_TPM_E_MAXNVWRITES,
		"HRES_TPM_E_MAXNVWRITES",
		"The maximum number of NV writes without an owner has been exceeded."
	},
	{
		HRES_TPM_E_NOOPERATOR,
		"HRES_TPM_E_NOOPERATOR",
		"No operator AuthData value is set."
	},
	{
		HRES_TPM_E_RESOURCEMISSING,
		"HRES_TPM_E_RESOURCEMISSING",
		"The resource pointed to by context is not loaded."
	},
	{
		HRES_TPM_E_DELEGATE_LOCK,
		"HRES_TPM_E_DELEGATE_LOCK",
		"The delegate administration is locked."
	},
	{
		HRES_TPM_E_DELEGATE_FAMILY,
		"HRES_TPM_E_DELEGATE_FAMILY",
		"Attempt to manage a family other then the delegated family."
	},
	{
		HRES_TPM_E_DELEGATE_ADMIN,
		"HRES_TPM_E_DELEGATE_ADMIN",
		"Delegation table management not enabled."
	},
	{
		HRES_TPM_E_TRANSPORT_NOTEXCLUSIVE,
		"HRES_TPM_E_TRANSPORT_NOTEXCLUSIVE",
		"There was a command executed outside an exclusive transport session."
	},
	{
		HRES_TPM_E_OWNER_CONTROL,
		"HRES_TPM_E_OWNER_CONTROL",
		"Attempt to context save an owner evict controlled key."
	},
	{
		HRES_TPM_E_DAA_RESOURCES,
		"HRES_TPM_E_DAA_RESOURCES",
		"The DAA command has no resources available to execute the command."
	},
	{
		HRES_TPM_E_DAA_INPUT_DATA0,
		"HRES_TPM_E_DAA_INPUT_DATA0",
		"The consistency check on DAA parameter inputData0 has failed."
	},
	{
		HRES_TPM_E_DAA_INPUT_DATA1,
		"HRES_TPM_E_DAA_INPUT_DATA1",
		"The consistency check on DAA parameter inputData1 has failed."
	},
	{
		HRES_TPM_E_DAA_ISSUER_SETTINGS,
		"HRES_TPM_E_DAA_ISSUER_SETTINGS",
		"The consistency check on DAA_issuerSettings has failed."
	},
	{
		HRES_TPM_E_DAA_TPM_SETTINGS,
		"HRES_TPM_E_DAA_TPM_SETTINGS",
		"The consistency check on DAA_tpmSpecific has failed."
	},
	{
		HRES_TPM_E_DAA_STAGE,
		"HRES_TPM_E_DAA_STAGE",
		"The atomic process indicated by the submitted DAA command is not the expected process."
	},
	{
		HRES_TPM_E_DAA_ISSUER_VALIDITY,
		"HRES_TPM_E_DAA_ISSUER_VALIDITY",
		"The issuer's validity check has detected an inconsistency."
	},
	{
		HRES_TPM_E_DAA_WRONG_W,
		"HRES_TPM_E_DAA_WRONG_W",
		"The consistency check on w has failed."
	},
	{
		HRES_TPM_E_BAD_HANDLE,
		"HRES_TPM_E_BAD_HANDLE",
		"The handle is incorrect."
	},
	{
		HRES_TPM_E_BAD_DELEGATE,
		"HRES_TPM_E_BAD_DELEGATE",
		"Delegation is not correct."
	},
	{
		HRES_TPM_E_BADCONTEXT,
		"HRES_TPM_E_BADCONTEXT",
		"The context blob is invalid."
	},
	{
		HRES_TPM_E_TOOMANYCONTEXTS,
		"HRES_TPM_E_TOOMANYCONTEXTS",
		"Too many contexts held by the TPM."
	},
	{
		HRES_TPM_E_MA_TICKET_SIGNATURE,
		"HRES_TPM_E_MA_TICKET_SIGNATURE",
		"Migration authority signature validation failure."
	},
	{
		HRES_TPM_E_MA_DESTINATION,
		"HRES_TPM_E_MA_DESTINATION",
		"Migration destination not authenticated."
	},
	{
		HRES_TPM_E_MA_SOURCE,
		"HRES_TPM_E_MA_SOURCE",
		"Migration source incorrect."
	},
	{
		HRES_TPM_E_MA_AUTHORITY,
		"HRES_TPM_E_MA_AUTHORITY",
		"Incorrect migration authority."
	},
	{
		HRES_TPM_E_PERMANENTEK,
		"HRES_TPM_E_PERMANENTEK",
		"Attempt to revoke the EK and the EK is not revocable."
	},
	{
		HRES_TPM_E_BAD_SIGNATURE,
		"HRES_TPM_E_BAD_SIGNATURE",
		"Bad signature of CMK ticket."
	},
	{
		HRES_TPM_E_NOCONTEXTSPACE,
		"HRES_TPM_E_NOCONTEXTSPACE",
		"There is no room in the context list for additional contexts."
	},
	{
		HRES_TPM_E_COMMAND_BLOCKED,
		"HRES_TPM_E_COMMAND_BLOCKED",
		"The command was blocked."
	},
	{
		HRES_TPM_E_INVALID_HANDLE,
		"HRES_TPM_E_INVALID_HANDLE",
		"The specified handle was not found."
	},
	{
		HRES_TPM_E_DUPLICATE_VHANDLE,
		"HRES_TPM_E_DUPLICATE_VHANDLE",
		"The TPM returned a duplicate handle and the command needs to be resubmitted."
	},
	{
		HRES_TPM_E_EMBEDDED_COMMAND_BLOCKED,
		"HRES_TPM_E_EMBEDDED_COMMAND_BLOCKED",
		"The command within the transport was blocked."
	},
	{
		HRES_TPM_E_EMBEDDED_COMMAND_UNSUPPORTED,
		"HRES_TPM_E_EMBEDDED_COMMAND_UNSUPPORTED",
		"The command within the transport is not supported."
	},
	{
		HRES_TPM_E_RETRY,
		"HRES_TPM_E_RETRY",
		"The TPM is too busy to respond to the command immediately, but the command could be resubmitted at a later time."
	},
	{
		HRES_TPM_E_NEEDS_SELFTEST,
		"HRES_TPM_E_NEEDS_SELFTEST",
		"SelfTestFull has not been run."
	},
	{
		HRES_TPM_E_DOING_SELFTEST,
		"HRES_TPM_E_DOING_SELFTEST",
		"The TPM is currently executing a full self-test."
	},
	{
		HRES_TPM_E_DEFEND_LOCK_RUNNING,
		"HRES_TPM_E_DEFEND_LOCK_RUNNING",
		"The TPM is defending against dictionary attacks and is in a time-out period."
	},
	{
		HRES_TBS_E_INTERNAL_ERROR,
		"HRES_TBS_E_INTERNAL_ERROR",
		"An internal software error has been detected."
	},
	{
		HRES_TBS_E_BAD_PARAMETER,
		"HRES_TBS_E_BAD_PARAMETER",
		"One or more input parameters are bad."
	},
	{
		HRES_TBS_E_INVALID_OUTPUT_POINTER,
		"HRES_TBS_E_INVALID_OUTPUT_POINTER",
		"A specified output pointer is bad."
	},
	{
		HRES_TBS_E_INVALID_CONTEXT,
		"HRES_TBS_E_INVALID_CONTEXT",
		"The specified context handle does not refer to a valid context."
	},
	{
		HRES_TBS_E_INSUFFICIENT_BUFFER,
		"HRES_TBS_E_INSUFFICIENT_BUFFER",
		"A specified output buffer is too small."
	},
	{
		HRES_TBS_E_IOERROR,
		"HRES_TBS_E_IOERROR",
		"An error occurred while communicating with the TPM."
	},
	{
		HRES_TBS_E_INVALID_CONTEXT_PARAM,
		"HRES_TBS_E_INVALID_CONTEXT_PARAM",
		"One or more context parameters are invalid."
	},
	{
		HRES_TBS_E_SERVICE_NOT_RUNNING,
		"HRES_TBS_E_SERVICE_NOT_RUNNING",
		"The TPM Base Services (TBS) is not running and could not be started."
	},
	{
		HRES_TBS_E_TOO_MANY_TBS_CONTEXTS,
		"HRES_TBS_E_TOO_MANY_TBS_CONTEXTS",
		"A new context could not be created because there are too many open contexts."
	},
	{
		HRES_TBS_E_TOO_MANY_RESOURCES,
		"HRES_TBS_E_TOO_MANY_RESOURCES",
		"A new virtual resource could not be created because there are too many open virtual resources."
	},
	{
		HRES_TBS_E_SERVICE_START_PENDING,
		"HRES_TBS_E_SERVICE_START_PENDING",
		"The TBS service has been started but is not yet running."
	},
	{
		HRES_TBS_E_PPI_NOT_SUPPORTED,
		"HRES_TBS_E_PPI_NOT_SUPPORTED",
		"The physical presence interface is not supported."
	},
	{
		HRES_TBS_E_COMMAND_CANCELED,
		"HRES_TBS_E_COMMAND_CANCELED",
		"The command was canceled."
	},
	{
		HRES_TBS_E_BUFFER_TOO_LARGE,
		"HRES_TBS_E_BUFFER_TOO_LARGE",
		"The input or output buffer is too large."
	},
	{
		HRES_TPMAPI_E_INVALID_STATE,
		"HRES_TPMAPI_E_INVALID_STATE",
		"The command buffer is not in the correct state."
	},
	{
		HRES_TPMAPI_E_NOT_ENOUGH_DATA,
		"HRES_TPMAPI_E_NOT_ENOUGH_DATA",
		"The command buffer does not contain enough data to satisfy the request."
	},
	{
		HRES_TPMAPI_E_TOO_MUCH_DATA,
		"HRES_TPMAPI_E_TOO_MUCH_DATA",
		"The command buffer cannot contain any more data."
	},
	{
		HRES_TPMAPI_E_INVALID_OUTPUT_POINTER,
		"HRES_TPMAPI_E_INVALID_OUTPUT_POINTER",
		"One or more output parameters was null or invalid."
	},
	{
		HRES_TPMAPI_E_INVALID_PARAMETER,
		"HRES_TPMAPI_E_INVALID_PARAMETER",
		"One or more input parameters are invalid."
	},
	{
		HRES_TPMAPI_E_OUT_OF_MEMORY,
		"HRES_TPMAPI_E_OUT_OF_MEMORY",
		"Not enough memory was available to satisfy the request."
	},
	{
		HRES_TPMAPI_E_BUFFER_TOO_SMALL,
		"HRES_TPMAPI_E_BUFFER_TOO_SMALL",
		"The specified buffer was too small."
	},
	{
		HRES_TPMAPI_E_INTERNAL_ERROR,
		"HRES_TPMAPI_E_INTERNAL_ERROR",
		"An internal error was detected."
	},
	{
		HRES_TPMAPI_E_ACCESS_DENIED,
		"HRES_TPMAPI_E_ACCESS_DENIED",
		"The caller does not have the appropriate rights to perform the requested operation."
	},
	{
		HRES_TPMAPI_E_AUTHORIZATION_FAILED,
		"HRES_TPMAPI_E_AUTHORIZATION_FAILED",
		"The specified authorization information was invalid."
	},
	{
		HRES_TPMAPI_E_INVALID_CONTEXT_HANDLE,
		"HRES_TPMAPI_E_INVALID_CONTEXT_HANDLE",
		"The specified context handle was not valid."
	},
	{
		HRES_TPMAPI_E_TBS_COMMUNICATION_ERROR,
		"HRES_TPMAPI_E_TBS_COMMUNICATION_ERROR",
		"An error occurred while communicating with the TBS."
	},
	{
		HRES_TPMAPI_E_TPM_COMMAND_ERROR,
		"HRES_TPMAPI_E_TPM_COMMAND_ERROR",
		"The TPM returned an unexpected result."
	},
	{
		HRES_TPMAPI_E_MESSAGE_TOO_LARGE,
		"HRES_TPMAPI_E_MESSAGE_TOO_LARGE",
		"The message was too large for the encoding scheme."
	},
	{
		HRES_TPMAPI_E_INVALID_ENCODING,
		"HRES_TPMAPI_E_INVALID_ENCODING",
		"The encoding in the binary large object (BLOB) was not recognized."
	},
	{
		HRES_TPMAPI_E_INVALID_KEY_SIZE,
		"HRES_TPMAPI_E_INVALID_KEY_SIZE",
		"The key size is not valid."
	},
	{
		HRES_TPMAPI_E_ENCRYPTION_FAILED,
		"HRES_TPMAPI_E_ENCRYPTION_FAILED",
		"The encryption operation failed."
	},
	{
		HRES_TPMAPI_E_INVALID_KEY_PARAMS,
		"HRES_TPMAPI_E_INVALID_KEY_PARAMS",
		"The key parameters structure was not valid."
	},
	{
		HRES_TPMAPI_E_INVALID_MIGRATION_AUTHORIZATION_BLOB,
		"HRES_TPMAPI_E_INVALID_MIGRATION_AUTHORIZATION_BLOB",
		"The requested supplied data does not appear to be a valid migration authorization BLOB."
	},
	{
		HRES_TPMAPI_E_INVALID_PCR_INDEX,
		"HRES_TPMAPI_E_INVALID_PCR_INDEX",
		"The specified PCR index was invalid."
	},
	{
		HRES_TPMAPI_E_INVALID_DELEGATE_BLOB,
		"HRES_TPMAPI_E_INVALID_DELEGATE_BLOB",
		"The data given does not appear to be a valid delegate BLOB."
	},
	{
		HRES_TPMAPI_E_INVALID_CONTEXT_PARAMS,
		"HRES_TPMAPI_E_INVALID_CONTEXT_PARAMS",
		"One or more of the specified context parameters was not valid."
	},
	{
		HRES_TPMAPI_E_INVALID_KEY_BLOB,
		"HRES_TPMAPI_E_INVALID_KEY_BLOB",
		"The data given does not appear to be a valid key BLOB."
	},
	{
		HRES_TPMAPI_E_INVALID_PCR_DATA,
		"HRES_TPMAPI_E_INVALID_PCR_DATA",
		"The specified PCR data was invalid."
	},
	{
		HRES_TPMAPI_E_INVALID_OWNER_AUTH,
		"HRES_TPMAPI_E_INVALID_OWNER_AUTH",
		"The format of the owner authorization data was invalid."
	},
	{
		HRES_TBSIMP_E_BUFFER_TOO_SMALL,
		"HRES_TBSIMP_E_BUFFER_TOO_SMALL",
		"The specified buffer was too small."
	},
	{
		HRES_TBSIMP_E_CLEANUP_FAILED,
		"HRES_TBSIMP_E_CLEANUP_FAILED",
		"The context could not be cleaned up."
	},
	{
		HRES_TBSIMP_E_INVALID_CONTEXT_HANDLE,
		"HRES_TBSIMP_E_INVALID_CONTEXT_HANDLE",
		"The specified context handle is invalid."
	},
	{
		HRES_TBSIMP_E_INVALID_CONTEXT_PARAM,
		"HRES_TBSIMP_E_INVALID_CONTEXT_PARAM",
		"An invalid context parameter was specified."
	},
	{
		HRES_TBSIMP_E_TPM_ERROR,
		"HRES_TBSIMP_E_TPM_ERROR",
		"An error occurred while communicating with the TPM."
	},
	{
		HRES_TBSIMP_E_HASH_BAD_KEY,
		"HRES_TBSIMP_E_HASH_BAD_KEY",
		"No entry with the specified key was found."
	},
	{
		HRES_TBSIMP_E_DUPLICATE_VHANDLE,
		"HRES_TBSIMP_E_DUPLICATE_VHANDLE",
		"The specified virtual handle matches a virtual handle already in use."
	},
	{
		HRES_TBSIMP_E_INVALID_OUTPUT_POINTER,
		"HRES_TBSIMP_E_INVALID_OUTPUT_POINTER",
		"The pointer to the returned handle location was null or invalid."
	},
	{
		HRES_TBSIMP_E_INVALID_PARAMETER,
		"HRES_TBSIMP_E_INVALID_PARAMETER",
		"One or more parameters are invalid."
	},
	{
		HRES_TBSIMP_E_RPC_INIT_FAILED,
		"HRES_TBSIMP_E_RPC_INIT_FAILED",
		"The RPC subsystem could not be initialized."
	},
	{
		HRES_TBSIMP_E_SCHEDULER_NOT_RUNNING,
		"HRES_TBSIMP_E_SCHEDULER_NOT_RUNNING",
		"The TBS scheduler is not running."
	},
	{
		HRES_TBSIMP_E_COMMAND_CANCELED,
		"HRES_TBSIMP_E_COMMAND_CANCELED",
		"The command was canceled."
	},
	{
		HRES_TBSIMP_E_OUT_OF_MEMORY,
		"HRES_TBSIMP_E_OUT_OF_MEMORY",
		"There was not enough memory to fulfill the request."
	},
	{
		HRES_TBSIMP_E_LIST_NO_MORE_ITEMS,
		"HRES_TBSIMP_E_LIST_NO_MORE_ITEMS",
		"The specified list is empty, or the iteration has reached the end of the list."
	},
	{
		HRES_TBSIMP_E_LIST_NOT_FOUND,
		"HRES_TBSIMP_E_LIST_NOT_FOUND",
		"The specified item was not found in the list."
	},
	{
		HRES_TBSIMP_E_NOT_ENOUGH_SPACE,
		"HRES_TBSIMP_E_NOT_ENOUGH_SPACE",
		"The TPM does not have enough space to load the requested resource."
	},
	{
		HRES_TBSIMP_E_NOT_ENOUGH_TPM_CONTEXTS,
		"HRES_TBSIMP_E_NOT_ENOUGH_TPM_CONTEXTS",
		"There are too many TPM contexts in use."
	},
	{
		HRES_TBSIMP_E_COMMAND_FAILED,
		"HRES_TBSIMP_E_COMMAND_FAILED",
		"The TPM command failed."
	},
	{
		HRES_TBSIMP_E_UNKNOWN_ORDINAL,
		"HRES_TBSIMP_E_UNKNOWN_ORDINAL",
		"The TBS does not recognize the specified ordinal."
	},
	{
		HRES_TBSIMP_E_RESOURCE_EXPIRED,
		"HRES_TBSIMP_E_RESOURCE_EXPIRED",
		"The requested resource is no longer available."
	},
	{
		HRES_TBSIMP_E_INVALID_RESOURCE,
		"HRES_TBSIMP_E_INVALID_RESOURCE",
		"The resource type did not match."
	},
	{
		HRES_TBSIMP_E_NOTHING_TO_UNLOAD,
		"HRES_TBSIMP_E_NOTHING_TO_UNLOAD",
		"No resources can be unloaded."
	},
	{
		HRES_TBSIMP_E_HASH_TABLE_FULL,
		"HRES_TBSIMP_E_HASH_TABLE_FULL",
		"No new entries can be added to the hash table."
	},
	{
		HRES_TBSIMP_E_TOO_MANY_TBS_CONTEXTS,
		"HRES_TBSIMP_E_TOO_MANY_TBS_CONTEXTS",
		"A new TBS context could not be created because there are too many open contexts."
	},
	{
		HRES_TBSIMP_E_TOO_MANY_RESOURCES,
		"HRES_TBSIMP_E_TOO_MANY_RESOURCES",
		"A new virtual resource could not be created because there are too many open virtual resources."
	},
	{
		HRES_TBSIMP_E_PPI_NOT_SUPPORTED,
		"HRES_TBSIMP_E_PPI_NOT_SUPPORTED",
		"The physical presence interface is not supported."
	},
	{
		HRES_TBSIMP_E_TPM_INCOMPATIBLE,
		"HRES_TBSIMP_E_TPM_INCOMPATIBLE",
		"TBS is not compatible with the version of TPM found on the system."
	},
	{
		HRES_TPM_E_PPI_ACPI_FAILURE,
		"HRES_TPM_E_PPI_ACPI_FAILURE",
		"A general error was detected when attempting to acquire the BIOS response to a physical presence command."
	},
	{
		HRES_TPM_E_PPI_USER_ABORT,
		"HRES_TPM_E_PPI_USER_ABORT",
		"The user failed to confirm the TPM operation request."
	},
	{
		HRES_TPM_E_PPI_BIOS_FAILURE,
		"HRES_TPM_E_PPI_BIOS_FAILURE",
		"The BIOS failure prevented the successful execution of the requested TPM operation (for example, invalid TPM operation request, BIOS communication error with the TPM)."
	},
	{
		HRES_TPM_E_PPI_NOT_SUPPORTED,
		"HRES_TPM_E_PPI_NOT_SUPPORTED",
		"The BIOS does not support the physical presence interface."
	},
	{
		HRES_PLA_E_DCS_NOT_FOUND,
		"HRES_PLA_E_DCS_NOT_FOUND",
		"A Data Collector Set was not found."
	},
	{
		HRES_PLA_E_TOO_MANY_FOLDERS,
		"HRES_PLA_E_TOO_MANY_FOLDERS",
		"Unable to start Data Collector Set because there are too many folders."
	},
	{
		HRES_PLA_E_NO_MIN_DISK,
		"HRES_PLA_E_NO_MIN_DISK",
		"Not enough free disk space to start Data Collector Set."
	},
	{
		HRES_PLA_E_DCS_IN_USE,
		"HRES_PLA_E_DCS_IN_USE",
		"Data Collector Set is in use."
	},
	{
		HRES_PLA_E_DCS_ALREADY_EXISTS,
		"HRES_PLA_E_DCS_ALREADY_EXISTS",
		"Data Collector Set already exists."
	},
	{
		HRES_PLA_E_PROPERTY_CONFLICT,
		"HRES_PLA_E_PROPERTY_CONFLICT",
		"Property value conflict."
	},
	{
		HRES_PLA_E_DCS_SINGLETON_REQUIRED,
		"HRES_PLA_E_DCS_SINGLETON_REQUIRED",
		"The current configuration for this Data Collector Set requires that it contain exactly one Data Collector."
	},
	{
		HRES_PLA_E_CREDENTIALS_REQUIRED,
		"HRES_PLA_E_CREDENTIALS_REQUIRED",
		"A user account is required to commit the current Data Collector Set properties."
	},
	{
		HRES_PLA_E_DCS_NOT_RUNNING,
		"HRES_PLA_E_DCS_NOT_RUNNING",
		"Data Collector Set is not running."
	},
	{
		HRES_PLA_E_CONFLICT_INCL_EXCL_API,
		"HRES_PLA_E_CONFLICT_INCL_EXCL_API",
		"A conflict was detected in the list of include and exclude APIs. Do not specify the same API in both the include list and the exclude list."
	},
	{
		HRES_PLA_E_NETWORK_EXE_NOT_VALID,
		"HRES_PLA_E_NETWORK_EXE_NOT_VALID",
		"The executable path specified refers to a network share or UNC path."
	},
	{
		HRES_PLA_E_EXE_ALREADY_CONFIGURED,
		"HRES_PLA_E_EXE_ALREADY_CONFIGURED",
		"The executable path specified is already configured for API tracing."
	},
	{
		HRES_PLA_E_EXE_PATH_NOT_VALID,
		"HRES_PLA_E_EXE_PATH_NOT_VALID",
		"The executable path specified does not exist. Verify that the specified path is correct."
	},
	{
		HRES_PLA_E_DC_ALREADY_EXISTS,
		"HRES_PLA_E_DC_ALREADY_EXISTS",
		"Data Collector already exists."
	},
	{
		HRES_PLA_E_DCS_START_WAIT_TIMEOUT,
		"HRES_PLA_E_DCS_START_WAIT_TIMEOUT",
		"The wait for the Data Collector Set start notification has timed out."
	},
	{
		HRES_PLA_E_DC_START_WAIT_TIMEOUT,
		"HRES_PLA_E_DC_START_WAIT_TIMEOUT",
		"The wait for the Data Collector to start has timed out."
	},
	{
		HRES_PLA_E_REPORT_WAIT_TIMEOUT,
		"HRES_PLA_E_REPORT_WAIT_TIMEOUT",
		"The wait for the report generation tool to finish has timed out."
	},
	{
		HRES_PLA_E_NO_DUPLICATES,
		"HRES_PLA_E_NO_DUPLICATES",
		"Duplicate items are not allowed."
	},
	{
		HRES_PLA_E_EXE_FULL_PATH_REQUIRED,
		"HRES_PLA_E_EXE_FULL_PATH_REQUIRED",
		"When specifying the executable to trace, you must specify a full path to the executable and not just a file name."
	},
	{
		HRES_PLA_E_INVALID_SESSION_NAME,
		"HRES_PLA_E_INVALID_SESSION_NAME",
		"The session name provided is invalid."
	},
	{
		HRES_PLA_E_PLA_CHANNEL_NOT_ENABLED,
		"HRES_PLA_E_PLA_CHANNEL_NOT_ENABLED",
		"The Event Log channel Microsoft-Windows-Diagnosis-PLA/Operational must be enabled to perform this operation."
	},
	{
		HRES_PLA_E_TASKSCHED_CHANNEL_NOT_ENABLED,
		"HRES_PLA_E_TASKSCHED_CHANNEL_NOT_ENABLED",
		"The Event Log channel Microsoft-Windows-TaskScheduler must be enabled to perform this operation."
	},
	{
		HRES_FVE_E_LOCKED_VOLUME,
		"HRES_FVE_E_LOCKED_VOLUME",
		"The volume must be unlocked before it can be used."
	},
	{
		HRES_FVE_E_NOT_ENCRYPTED,
		"HRES_FVE_E_NOT_ENCRYPTED",
		"The volume is fully decrypted and no key is available."
	},
	{
		HRES_FVE_E_NO_TPM_BIOS,
		"HRES_FVE_E_NO_TPM_BIOS",
		"The firmware does not support using a TPM during boot."
	},
	{
		HRES_FVE_E_NO_MBR_METRIC,
		"HRES_FVE_E_NO_MBR_METRIC",
		"The firmware does not use a TPM to perform initial program load (IPL) measurement."
	},
	{
		HRES_FVE_E_NO_BOOTSECTOR_METRIC,
		"HRES_FVE_E_NO_BOOTSECTOR_METRIC",
		"The master boot record (MBR) is not TPM-aware."
	},
	{
		HRES_FVE_E_NO_BOOTMGR_METRIC,
		"HRES_FVE_E_NO_BOOTMGR_METRIC",
		"The BOOTMGR is not being measured by the TPM."
	},
	{
		HRES_FVE_E_WRONG_BOOTMGR,
		"HRES_FVE_E_WRONG_BOOTMGR",
		"The BOOTMGR component does not perform expected TPM measurements."
	},
	{
		HRES_FVE_E_SECURE_KEY_REQUIRED,
		"HRES_FVE_E_SECURE_KEY_REQUIRED",
		"No secure key protection mechanism has been defined."
	},
	{
		HRES_FVE_E_NOT_ACTIVATED,
		"HRES_FVE_E_NOT_ACTIVATED",
		"This volume has not been provisioned for encryption."
	},
	{
		HRES_FVE_E_ACTION_NOT_ALLOWED,
		"HRES_FVE_E_ACTION_NOT_ALLOWED",
		"Requested action was denied by the full-volume encryption (FVE) control engine."
	},
	{
		HRES_FVE_E_AD_SCHEMA_NOT_INSTALLED,
		"HRES_FVE_E_AD_SCHEMA_NOT_INSTALLED",
		"The Active Directory forest does not contain the required attributes and classes to host FVE or TPM information."
	},
	{
		HRES_FVE_E_AD_INVALID_DATATYPE,
		"HRES_FVE_E_AD_INVALID_DATATYPE",
		"The type of data obtained from Active Directory was not expected."
	},
	{
		HRES_FVE_E_AD_INVALID_DATASIZE,
		"HRES_FVE_E_AD_INVALID_DATASIZE",
		"The size of the data obtained from Active Directory was not expected."
	},
	{
		HRES_FVE_E_AD_NO_VALUES,
		"HRES_FVE_E_AD_NO_VALUES",
		"The attribute read from Active Directory has no (zero) values."
	},
	{
		HRES_FVE_E_AD_ATTR_NOT_SET,
		"HRES_FVE_E_AD_ATTR_NOT_SET",
		"The attribute was not set."
	},
	{
		HRES_FVE_E_AD_GUID_NOT_FOUND,
		"HRES_FVE_E_AD_GUID_NOT_FOUND",
		"The specified GUID could not be found."
	},
	{
		HRES_FVE_E_BAD_INFORMATION,
		"HRES_FVE_E_BAD_INFORMATION",
		"The control block for the encrypted volume is not valid."
	},
	{
		HRES_FVE_E_TOO_SMALL,
		"HRES_FVE_E_TOO_SMALL",
		"Not enough free space remaining on volume to allow encryption."
	},
	{
		HRES_FVE_E_SYSTEM_VOLUME,
		"HRES_FVE_E_SYSTEM_VOLUME",
		"The volume cannot be encrypted because it is required to boot the operating system."
	},
	{
		HRES_FVE_E_FAILED_WRONG_FS,
		"HRES_FVE_E_FAILED_WRONG_FS",
		"The volume cannot be encrypted because the file system is not supported."
	},
	{
		HRES_FVE_E_FAILED_BAD_FS,
		"HRES_FVE_E_FAILED_BAD_FS",
		"The file system is inconsistent. Run CHKDSK."
	},
	{
		HRES_FVE_E_NOT_SUPPORTED,
		"HRES_FVE_E_NOT_SUPPORTED",
		"This volume cannot be encrypted."
	},
	{
		HRES_FVE_E_BAD_DATA,
		"HRES_FVE_E_BAD_DATA",
		"Data supplied is malformed."
	},
	{
		HRES_FVE_E_VOLUME_NOT_BOUND,
		"HRES_FVE_E_VOLUME_NOT_BOUND",
		"Volume is not bound to the system."
	},
	{
		HRES_FVE_E_TPM_NOT_OWNED,
		"HRES_FVE_E_TPM_NOT_OWNED",
		"TPM must be owned before a volume can be bound to it."
	},
	{
		HRES_FVE_E_NOT_DATA_VOLUME,
		"HRES_FVE_E_NOT_DATA_VOLUME",
		"The volume specified is not a data volume."
	},
	{
		HRES_FVE_E_AD_INSUFFICIENT_BUFFER,
		"HRES_FVE_E_AD_INSUFFICIENT_BUFFER",
		"The buffer supplied to a function was insufficient to contain the returned data."
	},
	{
		HRES_FVE_E_CONV_READ,
		"HRES_FVE_E_CONV_READ",
		"A read operation failed while converting the volume."
	},
	{
		HRES_FVE_E_CONV_WRITE,
		"HRES_FVE_E_CONV_WRITE",
		"A write operation failed while converting the volume."
	},
	{
		HRES_FVE_E_KEY_REQUIRED,
		"HRES_FVE_E_KEY_REQUIRED",
		"One or more key protection mechanisms are required for this volume."
	},
	{
		HRES_FVE_E_CLUSTERING_NOT_SUPPORTED,
		"HRES_FVE_E_CLUSTERING_NOT_SUPPORTED",
		"Cluster configurations are not supported."
	},
	{
		HRES_FVE_E_VOLUME_BOUND_ALREADY,
		"HRES_FVE_E_VOLUME_BOUND_ALREADY",
		"The volume is already bound to the system."
	},
	{
		HRES_FVE_E_OS_NOT_PROTECTED,
		"HRES_FVE_E_OS_NOT_PROTECTED",
		"The boot OS volume is not being protected via FVE."
	},
	{
		HRES_FVE_E_PROTECTION_DISABLED,
		"HRES_FVE_E_PROTECTION_DISABLED",
		"All protection mechanisms are effectively disabled (clear key exists)."
	},
	{
		HRES_FVE_E_RECOVERY_KEY_REQUIRED,
		"HRES_FVE_E_RECOVERY_KEY_REQUIRED",
		"A recovery key protection mechanism is required."
	},
	{
		HRES_FVE_E_FOREIGN_VOLUME,
		"HRES_FVE_E_FOREIGN_VOLUME",
		"This volume cannot be bound to a TPM."
	},
	{
		HRES_FVE_E_OVERLAPPED_UPDATE,
		"HRES_FVE_E_OVERLAPPED_UPDATE",
		"The control block for the encrypted volume was updated by another thread. Try again."
	},
	{
		HRES_FVE_E_TPM_SRK_AUTH_NOT_ZERO,
		"HRES_FVE_E_TPM_SRK_AUTH_NOT_ZERO",
		"The SRK authentication of the TPM is not zero and, therefore, is not compatible."
	},
	{
		HRES_FVE_E_FAILED_SECTOR_SIZE,
		"HRES_FVE_E_FAILED_SECTOR_SIZE",
		"The volume encryption algorithm cannot be used on this sector size."
	},
	{
		HRES_FVE_E_FAILED_AUTHENTICATION,
		"HRES_FVE_E_FAILED_AUTHENTICATION",
		"BitLocker recovery authentication failed."
	},
	{
		HRES_FVE_E_NOT_OS_VOLUME,
		"HRES_FVE_E_NOT_OS_VOLUME",
		"The volume specified is not the boot OS volume."
	},
	{
		HRES_FVE_E_AUTOUNLOCK_ENABLED,
		"HRES_FVE_E_AUTOUNLOCK_ENABLED",
		"Auto-unlock information for data volumes is present on the boot OS volume."
	},
	{
		HRES_FVE_E_WRONG_BOOTSECTOR,
		"HRES_FVE_E_WRONG_BOOTSECTOR",
		"The system partition boot sector does not perform TPM measurements."
	},
	{
		HRES_FVE_E_WRONG_SYSTEM_FS,
		"HRES_FVE_E_WRONG_SYSTEM_FS",
		"The system partition file system must be NTFS."
	},
	{
		HRES_FVE_E_POLICY_PASSWORD_REQUIRED,
		"HRES_FVE_E_POLICY_PASSWORD_REQUIRED",
		"Group policy requires a recovery password before encryption can begin."
	},
	{
		HRES_FVE_E_CANNOT_SET_FVEK_ENCRYPTED,
		"HRES_FVE_E_CANNOT_SET_FVEK_ENCRYPTED",
		"The volume encryption algorithm and key cannot be set on an encrypted volume."
	},
	{
		HRES_FVE_E_CANNOT_ENCRYPT_NO_KEY,
		"HRES_FVE_E_CANNOT_ENCRYPT_NO_KEY",
		"A key must be specified before encryption can begin."
	},
	{
		HRES_FVE_E_BOOTABLE_CDDVD,
		"HRES_FVE_E_BOOTABLE_CDDVD",
		"A bootable CD/DVD is in the system. Remove the CD/DVD and reboot the system."
	},
	{
		HRES_FVE_E_PROTECTOR_EXISTS,
		"HRES_FVE_E_PROTECTOR_EXISTS",
		"An instance of this key protector already exists on the volume."
	},
	{
		HRES_FVE_E_RELATIVE_PATH,
		"HRES_FVE_E_RELATIVE_PATH",
		"The file cannot be saved to a relative path."
	},
	{
		HRES_FWP_E_CALLOUT_NOT_FOUND,
		"HRES_FWP_E_CALLOUT_NOT_FOUND",
		"The callout does not exist."
	},
	{
		HRES_FWP_E_CONDITION_NOT_FOUND,
		"HRES_FWP_E_CONDITION_NOT_FOUND",
		"The filter condition does not exist."
	},
	{
		HRES_FWP_E_FILTER_NOT_FOUND,
		"HRES_FWP_E_FILTER_NOT_FOUND",
		"The filter does not exist."
	},
	{
		HRES_FWP_E_LAYER_NOT_FOUND,
		"HRES_FWP_E_LAYER_NOT_FOUND",
		"The layer does not exist."
	},
	{
		HRES_FWP_E_PROVIDER_NOT_FOUND,
		"HRES_FWP_E_PROVIDER_NOT_FOUND",
		"The provider does not exist."
	},
	{
		HRES_FWP_E_PROVIDER_CONTEXT_NOT_FOUND,
		"HRES_FWP_E_PROVIDER_CONTEXT_NOT_FOUND",
		"The provider context does not exist."
	},
	{
		HRES_FWP_E_SUBLAYER_NOT_FOUND,
		"HRES_FWP_E_SUBLAYER_NOT_FOUND",
		"The sublayer does not exist."
	},
	{
		HRES_FWP_E_NOT_FOUND,
		"HRES_FWP_E_NOT_FOUND",
		"The object does not exist."
	},
	{
		HRES_FWP_E_ALREADY_EXISTS,
		"HRES_FWP_E_ALREADY_EXISTS",
		"An object with that GUID or LUID already exists."
	},
	{
		HRES_FWP_E_IN_USE,
		"HRES_FWP_E_IN_USE",
		"The object is referenced by other objects and, therefore, cannot be deleted."
	},
	{
		HRES_FWP_E_DYNAMIC_SESSION_IN_PROGRESS,
		"HRES_FWP_E_DYNAMIC_SESSION_IN_PROGRESS",
		"The call is not allowed from within a dynamic session."
	},
	{
		HRES_FWP_E_WRONG_SESSION,
		"HRES_FWP_E_WRONG_SESSION",
		"The call was made from the wrong session and, therefore, cannot be completed."
	},
	{
		HRES_FWP_E_NO_TXN_IN_PROGRESS,
		"HRES_FWP_E_NO_TXN_IN_PROGRESS",
		"The call must be made from within an explicit transaction."
	},
	{
		HRES_FWP_E_TXN_IN_PROGRESS,
		"HRES_FWP_E_TXN_IN_PROGRESS",
		"The call is not allowed from within an explicit transaction."
	},
	{
		HRES_FWP_E_TXN_ABORTED,
		"HRES_FWP_E_TXN_ABORTED",
		"The explicit transaction has been forcibly canceled."
	},
	{
		HRES_FWP_E_SESSION_ABORTED,
		"HRES_FWP_E_SESSION_ABORTED",
		"The session has been canceled."
	},
	{
		HRES_FWP_E_INCOMPATIBLE_TXN,
		"HRES_FWP_E_INCOMPATIBLE_TXN",
		"The call is not allowed from within a read-only transaction."
	},
	{
		HRES_FWP_E_TIMEOUT,
		"HRES_FWP_E_TIMEOUT",
		"The call timed out while waiting to acquire the transaction lock."
	},
	{
		HRES_FWP_E_NET_EVENTS_DISABLED,
		"HRES_FWP_E_NET_EVENTS_DISABLED",
		"Collection of network diagnostic events is disabled."
	},
	{
		HRES_FWP_E_INCOMPATIBLE_LAYER,
		"HRES_FWP_E_INCOMPATIBLE_LAYER",
		"The operation is not supported by the specified layer."
	},
	{
		HRES_FWP_E_KM_CLIENTS_ONLY,
		"HRES_FWP_E_KM_CLIENTS_ONLY",
		"The call is allowed for kernel-mode callers only."
	},
	{
		HRES_FWP_E_LIFETIME_MISMATCH,
		"HRES_FWP_E_LIFETIME_MISMATCH",
		"The call tried to associate two objects with incompatible lifetimes."
	},
	{
		HRES_FWP_E_BUILTIN_OBJECT,
		"HRES_FWP_E_BUILTIN_OBJECT",
		"The object is built in and, therefore, cannot be deleted."
	},
	{
		HRES_FWP_E_TOO_MANY_BOOTTIME_FILTERS,
		"HRES_FWP_E_TOO_MANY_BOOTTIME_FILTERS",
		"The maximum number of boot-time filters has been reached."
	},
	{
		HRES_FWP_E_NOTIFICATION_DROPPED,
		"HRES_FWP_E_NOTIFICATION_DROPPED",
		"A notification could not be delivered because a message queue is at its maximum capacity."
	},
	{
		HRES_FWP_E_TRAFFIC_MISMATCH,
		"HRES_FWP_E_TRAFFIC_MISMATCH",
		"The traffic parameters do not match those for the security association context."
	},
	{
		HRES_FWP_E_INCOMPATIBLE_SA_STATE,
		"HRES_FWP_E_INCOMPATIBLE_SA_STATE",
		"The call is not allowed for the current security association state."
	},
	{
		HRES_FWP_E_NULL_POINTER,
		"HRES_FWP_E_NULL_POINTER",
		"A required pointer is null."
	},
	{
		HRES_FWP_E_INVALID_ENUMERATOR,
		"HRES_FWP_E_INVALID_ENUMERATOR",
		"An enumerator is not valid."
	},
	{
		HRES_FWP_E_INVALID_FLAGS,
		"HRES_FWP_E_INVALID_FLAGS",
		"The flags field contains an invalid value."
	},
	{
		HRES_FWP_E_INVALID_NET_MASK,
		"HRES_FWP_E_INVALID_NET_MASK",
		"A network mask is not valid."
	},
	{
		HRES_FWP_E_INVALID_RANGE,
		"HRES_FWP_E_INVALID_RANGE",
		"An FWP_RANGE is not valid."
	},
	{
		HRES_FWP_E_INVALID_INTERVAL,
		"HRES_FWP_E_INVALID_INTERVAL",
		"The time interval is not valid."
	},
	{
		HRES_FWP_E_ZERO_LENGTH_ARRAY,
		"HRES_FWP_E_ZERO_LENGTH_ARRAY",
		"An array that must contain at least one element that is zero-length."
	},
	{
		HRES_FWP_E_NULL_DISPLAY_NAME,
		"HRES_FWP_E_NULL_DISPLAY_NAME",
		"The displayData.name field cannot be null."
	},
	{
		HRES_FWP_E_INVALID_ACTION_TYPE,
		"HRES_FWP_E_INVALID_ACTION_TYPE",
		"The action type is not one of the allowed action types for a filter."
	},
	{
		HRES_FWP_E_INVALID_WEIGHT,
		"HRES_FWP_E_INVALID_WEIGHT",
		"The filter weight is not valid."
	},
	{
		HRES_FWP_E_MATCH_TYPE_MISMATCH,
		"HRES_FWP_E_MATCH_TYPE_MISMATCH",
		"A filter condition contains a match type that is not compatible with the operands."
	},
	{
		HRES_FWP_E_TYPE_MISMATCH,
		"HRES_FWP_E_TYPE_MISMATCH",
		"An FWP_VALUE or FWPM_CONDITION_VALUE is of the wrong type."
	},
	{
		HRES_FWP_E_OUT_OF_BOUNDS,
		"HRES_FWP_E_OUT_OF_BOUNDS",
		"An integer value is outside the allowed range."
	},
	{
		HRES_FWP_E_RESERVED,
		"HRES_FWP_E_RESERVED",
		"A reserved field is nonzero."
	},
	{
		HRES_FWP_E_DUPLICATE_CONDITION,
		"HRES_FWP_E_DUPLICATE_CONDITION",
		"A filter cannot contain multiple conditions operating on a single field."
	},
	{
		HRES_FWP_E_DUPLICATE_KEYMOD,
		"HRES_FWP_E_DUPLICATE_KEYMOD",
		"A policy cannot contain the same keying module more than once."
	},
	{
		HRES_FWP_E_ACTION_INCOMPATIBLE_WITH_LAYER,
		"HRES_FWP_E_ACTION_INCOMPATIBLE_WITH_LAYER",
		"The action type is not compatible with the layer."
	},
	{
		HRES_FWP_E_ACTION_INCOMPATIBLE_WITH_SUBLAYER,
		"HRES_FWP_E_ACTION_INCOMPATIBLE_WITH_SUBLAYER",
		"The action type is not compatible with the sublayer."
	},
	{
		HRES_FWP_E_CONTEXT_INCOMPATIBLE_WITH_LAYER,
		"HRES_FWP_E_CONTEXT_INCOMPATIBLE_WITH_LAYER",
		"The raw context or the provider context is not compatible with the layer."
	},
	{
		HRES_FWP_E_CONTEXT_INCOMPATIBLE_WITH_CALLOUT,
		"HRES_FWP_E_CONTEXT_INCOMPATIBLE_WITH_CALLOUT",
		"The raw context or the provider context is not compatible with the callout."
	},
	{
		HRES_FWP_E_INCOMPATIBLE_AUTH_METHOD,
		"HRES_FWP_E_INCOMPATIBLE_AUTH_METHOD",
		"The authentication method is not compatible with the policy type."
	},
	{
		HRES_FWP_E_INCOMPATIBLE_DH_GROUP,
		"HRES_FWP_E_INCOMPATIBLE_DH_GROUP",
		"The Diffie-Hellman group is not compatible with the policy type."
	},
	{
		HRES_FWP_E_EM_NOT_SUPPORTED,
		"HRES_FWP_E_EM_NOT_SUPPORTED",
		"An Internet Key Exchange (IKE) policy cannot contain an Extended Mode policy."
	},
	{
		HRES_FWP_E_NEVER_MATCH,
		"HRES_FWP_E_NEVER_MATCH",
		"The enumeration template or subscription will never match any objects."
	},
	{
		HRES_FWP_E_PROVIDER_CONTEXT_MISMATCH,
		"HRES_FWP_E_PROVIDER_CONTEXT_MISMATCH",
		"The provider context is of the wrong type."
	},
	{
		HRES_FWP_E_INVALID_PARAMETER,
		"HRES_FWP_E_INVALID_PARAMETER",
		"The parameter is incorrect."
	},
	{
		HRES_FWP_E_TOO_MANY_SUBLAYERS,
		"HRES_FWP_E_TOO_MANY_SUBLAYERS",
		"The maximum number of sublayers has been reached."
	},
	{
		HRES_FWP_E_CALLOUT_NOTIFICATION_FAILED,
		"HRES_FWP_E_CALLOUT_NOTIFICATION_FAILED",
		"The notification function for a callout returned an error."
	},
	{
		HRES_FWP_E_INCOMPATIBLE_AUTH_CONFIG,
		"HRES_FWP_E_INCOMPATIBLE_AUTH_CONFIG",
		"The IPsec authentication configuration is not compatible with the authentication type."
	},
	{
		HRES_FWP_E_INCOMPATIBLE_CIPHER_CONFIG,
		"HRES_FWP_E_INCOMPATIBLE_CIPHER_CONFIG",
		"The IPsec cipher configuration is not compatible with the cipher type."
	},
	{
		HRES_ERROR_NDIS_INTERFACE_CLOSING,
		"HRES_ERROR_NDIS_INTERFACE_CLOSING",
		"The binding to the network interface is being closed."
	},
	{
		HRES_ERROR_NDIS_BAD_VERSION,
		"HRES_ERROR_NDIS_BAD_VERSION",
		"An invalid version was specified."
	},
	{
		HRES_ERROR_NDIS_BAD_CHARACTERISTICS,
		"HRES_ERROR_NDIS_BAD_CHARACTERISTICS",
		"An invalid characteristics table was used."
	},
	{
		HRES_ERROR_NDIS_ADAPTER_NOT_FOUND,
		"HRES_ERROR_NDIS_ADAPTER_NOT_FOUND",
		"Failed to find the network interface, or the network interface is not ready."
	},
	{
		HRES_ERROR_NDIS_OPEN_FAILED,
		"HRES_ERROR_NDIS_OPEN_FAILED",
		"Failed to open the network interface."
	},
	{
		HRES_ERROR_NDIS_DEVICE_FAILED,
		"HRES_ERROR_NDIS_DEVICE_FAILED",
		"The network interface has encountered an internal unrecoverable failure."
	},
	{
		HRES_ERROR_NDIS_MULTICAST_FULL,
		"HRES_ERROR_NDIS_MULTICAST_FULL",
		"The multicast list on the network interface is full."
	},
	{
		HRES_ERROR_NDIS_MULTICAST_EXISTS,
		"HRES_ERROR_NDIS_MULTICAST_EXISTS",
		"An attempt was made to add a duplicate multicast address to the list."
	},
	{
		HRES_ERROR_NDIS_MULTICAST_NOT_FOUND,
		"HRES_ERROR_NDIS_MULTICAST_NOT_FOUND",
		"At attempt was made to remove a multicast address that was never added."
	},
	{
		HRES_ERROR_NDIS_REQUEST_ABORTED,
		"HRES_ERROR_NDIS_REQUEST_ABORTED",
		"The network interface aborted the request."
	},
	{
		HRES_ERROR_NDIS_RESET_IN_PROGRESS,
		"HRES_ERROR_NDIS_RESET_IN_PROGRESS",
		"The network interface cannot process the request because it is being reset."
	},
	{
		HRES_ERROR_NDIS_INVALID_PACKET,
		"HRES_ERROR_NDIS_INVALID_PACKET",
		"An attempt was made to send an invalid packet on a network interface."
	},
	{
		HRES_ERROR_NDIS_INVALID_DEVICE_REQUEST,
		"HRES_ERROR_NDIS_INVALID_DEVICE_REQUEST",
		"The specified request is not a valid operation for the target device."
	},
	{
		HRES_ERROR_NDIS_ADAPTER_NOT_READY,
		"HRES_ERROR_NDIS_ADAPTER_NOT_READY",
		"The network interface is not ready to complete this operation."
	},
	{
		HRES_ERROR_NDIS_INVALID_LENGTH,
		"HRES_ERROR_NDIS_INVALID_LENGTH",
		"The length of the buffer submitted for this operation is not valid."
	},
	{
		HRES_ERROR_NDIS_INVALID_DATA,
		"HRES_ERROR_NDIS_INVALID_DATA",
		"The data used for this operation is not valid."
	},
	{
		HRES_ERROR_NDIS_BUFFER_TOO_SHORT,
		"HRES_ERROR_NDIS_BUFFER_TOO_SHORT",
		"The length of the buffer submitted for this operation is too small."
	},
	{
		HRES_ERROR_NDIS_INVALID_OID,
		"HRES_ERROR_NDIS_INVALID_OID",
		"The network interface does not support this OID."
	},
	{
		HRES_ERROR_NDIS_ADAPTER_REMOVED,
		"HRES_ERROR_NDIS_ADAPTER_REMOVED",
		"The network interface has been removed."
	},
	{
		HRES_ERROR_NDIS_UNSUPPORTED_MEDIA,
		"HRES_ERROR_NDIS_UNSUPPORTED_MEDIA",
		"The network interface does not support this media type."
	},
	{
		HRES_ERROR_NDIS_GROUP_ADDRESS_IN_USE,
		"HRES_ERROR_NDIS_GROUP_ADDRESS_IN_USE",
		"An attempt was made to remove a token ring group address that is in use by other components."
	},
	{
		HRES_ERROR_NDIS_FILE_NOT_FOUND,
		"HRES_ERROR_NDIS_FILE_NOT_FOUND",
		"An attempt was made to map a file that cannot be found."
	},
	{
		HRES_ERROR_NDIS_ERROR_READING_FILE,
		"HRES_ERROR_NDIS_ERROR_READING_FILE",
		"An error occurred while the NDIS tried to map the file."
	},
	{
		HRES_ERROR_NDIS_ALREADY_MAPPED,
		"HRES_ERROR_NDIS_ALREADY_MAPPED",
		"An attempt was made to map a file that is already mapped."
	},
	{
		HRES_ERROR_NDIS_RESOURCE_CONFLICT,
		"HRES_ERROR_NDIS_RESOURCE_CONFLICT",
		"An attempt to allocate a hardware resource failed because the resource is used by another component."
	},
	{
		HRES_ERROR_NDIS_MEDIA_DISCONNECTED,
		"HRES_ERROR_NDIS_MEDIA_DISCONNECTED",
		"The I/O operation failed because network media is disconnected or the wireless access point is out of range."
	},
	{
		HRES_ERROR_NDIS_INVALID_ADDRESS,
		"HRES_ERROR_NDIS_INVALID_ADDRESS",
		"The network address used in the request is invalid."
	},
	{
		HRES_ERROR_NDIS_PAUSED,
		"HRES_ERROR_NDIS_PAUSED",
		"The offload operation on the network interface has been paused."
	},
	{
		HRES_ERROR_NDIS_INTERFACE_NOT_FOUND,
		"HRES_ERROR_NDIS_INTERFACE_NOT_FOUND",
		"The network interface was not found."
	},
	{
		HRES_ERROR_NDIS_UNSUPPORTED_REVISION,
		"HRES_ERROR_NDIS_UNSUPPORTED_REVISION",
		"The revision number specified in the structure is not supported."
	},
	{
		HRES_ERROR_NDIS_INVALID_PORT,
		"HRES_ERROR_NDIS_INVALID_PORT",
		"The specified port does not exist on this network interface."
	},
	{
		HRES_ERROR_NDIS_INVALID_PORT_STATE,
		"HRES_ERROR_NDIS_INVALID_PORT_STATE",
		"The current state of the specified port on this network interface does not support the requested operation."
	},
	{
		HRES_ERROR_NDIS_NOT_SUPPORTED,
		"HRES_ERROR_NDIS_NOT_SUPPORTED",
		"The network interface does not support this request."
	},
	{
		HRES_ERROR_NDIS_DOT11_AUTO_CONFIG_ENABLED,
		"HRES_ERROR_NDIS_DOT11_AUTO_CONFIG_ENABLED",
		"The wireless local area network (LAN) interface is in auto-configuration mode and does not support the requested parameter change operation."
	},
	{
		HRES_ERROR_NDIS_DOT11_MEDIA_IN_USE,
		"HRES_ERROR_NDIS_DOT11_MEDIA_IN_USE",
		"The wireless LAN interface is busy and cannot perform the requested operation."
	},
	{
		HRES_ERROR_NDIS_DOT11_POWER_STATE_INVALID,
		"HRES_ERROR_NDIS_DOT11_POWER_STATE_INVALID",
		"The wireless LAN interface is shutting down and does not support the requested operation."
	},
	{
		HRES_TRK_E_NOT_FOUND,
		"HRES_TRK_E_NOT_FOUND",
		"A requested object was not found."
	},
	{
		HRES_TRK_E_VOLUME_QUOTA_EXCEEDED,
		"HRES_TRK_E_VOLUME_QUOTA_EXCEEDED",
		"The server received a CREATE_VOLUME subrequest of a SYNC_VOLUMES request, but the ServerVolumeTable size limit for the RequestMachine has already been reached."
	},
	{
		HRES_TRK_SERVER_TOO_BUSY,
		"HRES_TRK_SERVER_TOO_BUSY",
		"The server is busy, and the client should retry the request at a later time."
	},
	{
		HRES_ERROR_AUDITING_DISABLED,
		"HRES_ERROR_AUDITING_DISABLED",
		"The specified event is currently not being audited."
	},
	{
		HRES_ERROR_ALL_SIDS_FILTERED,
		"HRES_ERROR_ALL_SIDS_FILTERED",
		"The SID filtering operation removed all SIDs."
	},
	{
		HRES_ERROR_BIZRULES_NOT_ENABLED,
		"HRES_ERROR_BIZRULES_NOT_ENABLED",
		"Business rule scripts are disabled for the calling application."
	},
	{
		HRES_NS_E_NOCONNECTION,
		"HRES_NS_E_NOCONNECTION",
		"There is no connection established with the Windows Media server. The operation failed."
	},
	{
		HRES_NS_E_CANNOTCONNECT,
		"HRES_NS_E_CANNOTCONNECT",
		"Unable to establish a connection to the server."
	},
	{
		HRES_NS_E_CANNOTDESTROYTITLE,
		"HRES_NS_E_CANNOTDESTROYTITLE",
		"Unable to destroy the title."
	},
	{
		HRES_NS_E_CANNOTRENAMETITLE,
		"HRES_NS_E_CANNOTRENAMETITLE",
		"Unable to rename the title."
	},
	{
		HRES_NS_E_CANNOTOFFLINEDISK,
		"HRES_NS_E_CANNOTOFFLINEDISK",
		"Unable to offline disk."
	},
	{
		HRES_NS_E_CANNOTONLINEDISK,
		"HRES_NS_E_CANNOTONLINEDISK",
		"Unable to online disk."
	},
	{
		HRES_NS_E_NOREGISTEREDWALKER,
		"HRES_NS_E_NOREGISTEREDWALKER",
		"There is no file parser registered for this type of file."
	},
	{
		HRES_NS_E_NOFUNNEL,
		"HRES_NS_E_NOFUNNEL",
		"There is no data connection established."
	},
	{
		HRES_NS_E_NO_LOCALPLAY,
		"HRES_NS_E_NO_LOCALPLAY",
		"Failed to load the local play DLL."
	},
	{
		HRES_NS_E_NETWORK_BUSY,
		"HRES_NS_E_NETWORK_BUSY",
		"The network is busy."
	},
	{
		HRES_NS_E_TOO_MANY_SESS,
		"HRES_NS_E_TOO_MANY_SESS",
		"The server session limit was exceeded."
	},
	{
		HRES_NS_E_ALREADY_CONNECTED,
		"HRES_NS_E_ALREADY_CONNECTED",
		"The network connection already exists."
	},
	{
		HRES_NS_E_INVALID_INDEX,
		"HRES_NS_E_INVALID_INDEX",
		"Index %1 is invalid."
	},
	{
		HRES_NS_E_PROTOCOL_MISMATCH,
		"HRES_NS_E_PROTOCOL_MISMATCH",
		"There is no protocol or protocol version supported by both the client and the server."
	},
	{
		HRES_NS_E_TIMEOUT,
		"HRES_NS_E_TIMEOUT",
		"The server, a computer set up to offer multimedia content to other computers, could not handle your request for multimedia content in a timely manner. Please try again later."
	},
	{
		HRES_NS_E_NET_WRITE,
		"HRES_NS_E_NET_WRITE",
		"Error writing to the network."
	},
	{
		HRES_NS_E_NET_READ,
		"HRES_NS_E_NET_READ",
		"Error reading from the network."
	},
	{
		HRES_NS_E_DISK_WRITE,
		"HRES_NS_E_DISK_WRITE",
		"Error writing to a disk."
	},
	{
		HRES_NS_E_DISK_READ,
		"HRES_NS_E_DISK_READ",
		"Error reading from a disk."
	},
	{
		HRES_NS_E_FILE_WRITE,
		"HRES_NS_E_FILE_WRITE",
		"Error writing to a file."
	},
	{
		HRES_NS_E_FILE_READ,
		"HRES_NS_E_FILE_READ",
		"Error reading from a file."
	},
	{
		HRES_NS_E_FILE_NOT_FOUND,
		"HRES_NS_E_FILE_NOT_FOUND",
		"The system cannot find the file specified."
	},
	{
		HRES_NS_E_FILE_EXISTS,
		"HRES_NS_E_FILE_EXISTS",
		"The file already exists."
	},
	{
		HRES_NS_E_INVALID_NAME,
		"HRES_NS_E_INVALID_NAME",
		"The file name, directory name, or volume label syntax is incorrect."
	},
	{
		HRES_NS_E_FILE_OPEN_FAILED,
		"HRES_NS_E_FILE_OPEN_FAILED",
		"Failed to open a file."
	},
	{
		HRES_NS_E_FILE_ALLOCATION_FAILED,
		"HRES_NS_E_FILE_ALLOCATION_FAILED",
		"Unable to allocate a file."
	},
	{
		HRES_NS_E_FILE_INIT_FAILED,
		"HRES_NS_E_FILE_INIT_FAILED",
		"Unable to initialize a file."
	},
	{
		HRES_NS_E_FILE_PLAY_FAILED,
		"HRES_NS_E_FILE_PLAY_FAILED",
		"Unable to play a file."
	},
	{
		HRES_NS_E_SET_DISK_UID_FAILED,
		"HRES_NS_E_SET_DISK_UID_FAILED",
		"Could not set the disk UID."
	},
	{
		HRES_NS_E_INDUCED,
		"HRES_NS_E_INDUCED",
		"An error was induced for testing purposes."
	},
	{
		HRES_NS_E_CCLINK_DOWN,
		"HRES_NS_E_CCLINK_DOWN",
		"Two Content Servers failed to communicate."
	},
	{
		HRES_NS_E_INTERNAL,
		"HRES_NS_E_INTERNAL",
		"An unknown error occurred."
	},
	{
		HRES_NS_E_BUSY,
		"HRES_NS_E_BUSY",
		"The requested resource is in use."
	},
	{
		HRES_NS_E_UNRECOGNIZED_STREAM_TYPE,
		"HRES_NS_E_UNRECOGNIZED_STREAM_TYPE",
		"The specified protocol is not recognized. Be sure that the file name and syntax, such as slashes, are correct for the protocol."
	},
	{
		HRES_NS_E_NETWORK_SERVICE_FAILURE,
		"HRES_NS_E_NETWORK_SERVICE_FAILURE",
		"The network service provider failed."
	},
	{
		HRES_NS_E_NETWORK_RESOURCE_FAILURE,
		"HRES_NS_E_NETWORK_RESOURCE_FAILURE",
		"An attempt to acquire a network resource failed."
	},
	{
		HRES_NS_E_CONNECTION_FAILURE,
		"HRES_NS_E_CONNECTION_FAILURE",
		"The network connection has failed."
	},
	{
		HRES_NS_E_SHUTDOWN,
		"HRES_NS_E_SHUTDOWN",
		"The session is being terminated locally."
	},
	{
		HRES_NS_E_INVALID_REQUEST,
		"HRES_NS_E_INVALID_REQUEST",
		"The request is invalid in the current state."
	},
	{
		HRES_NS_E_INSUFFICIENT_BANDWIDTH,
		"HRES_NS_E_INSUFFICIENT_BANDWIDTH",
		"There is insufficient bandwidth available to fulfill the request."
	},
	{
		HRES_NS_E_NOT_REBUILDING,
		"HRES_NS_E_NOT_REBUILDING",
		"The disk is not rebuilding."
	},
	{
		HRES_NS_E_LATE_OPERATION,
		"HRES_NS_E_LATE_OPERATION",
		"An operation requested for a particular time could not be carried out on schedule."
	},
	{
		HRES_NS_E_INVALID_DATA,
		"HRES_NS_E_INVALID_DATA",
		"Invalid or corrupt data was encountered."
	},
	{
		HRES_NS_E_FILE_BANDWIDTH_LIMIT,
		"HRES_NS_E_FILE_BANDWIDTH_LIMIT",
		"The bandwidth required to stream a file is higher than the maximum file bandwidth allowed on the server."
	},
	{
		HRES_NS_E_OPEN_FILE_LIMIT,
		"HRES_NS_E_OPEN_FILE_LIMIT",
		"The client cannot have any more files open simultaneously."
	},
	{
		HRES_NS_E_BAD_CONTROL_DATA,
		"HRES_NS_E_BAD_CONTROL_DATA",
		"The server received invalid data from the client on the control connection."
	},
	{
		HRES_NS_E_NO_STREAM,
		"HRES_NS_E_NO_STREAM",
		"There is no stream available."
	},
	{
		HRES_NS_E_STREAM_END,
		"HRES_NS_E_STREAM_END",
		"There is no more data in the stream."
	},
	{
		HRES_NS_E_SERVER_NOT_FOUND,
		"HRES_NS_E_SERVER_NOT_FOUND",
		"The specified server could not be found."
	},
	{
		HRES_NS_E_DUPLICATE_NAME,
		"HRES_NS_E_DUPLICATE_NAME",
		"The specified name is already in use."
	},
	{
		HRES_NS_E_DUPLICATE_ADDRESS,
		"HRES_NS_E_DUPLICATE_ADDRESS",
		"The specified address is already in use."
	},
	{
		HRES_NS_E_BAD_MULTICAST_ADDRESS,
		"HRES_NS_E_BAD_MULTICAST_ADDRESS",
		"The specified address is not a valid multicast address."
	},
	{
		HRES_NS_E_BAD_ADAPTER_ADDRESS,
		"HRES_NS_E_BAD_ADAPTER_ADDRESS",
		"The specified adapter address is invalid."
	},
	{
		HRES_NS_E_BAD_DELIVERY_MODE,
		"HRES_NS_E_BAD_DELIVERY_MODE",
		"The specified delivery mode is invalid."
	},
	{
		HRES_NS_E_INVALID_CHANNEL,
		"HRES_NS_E_INVALID_CHANNEL",
		"The specified station does not exist."
	},
	{
		HRES_NS_E_INVALID_STREAM,
		"HRES_NS_E_INVALID_STREAM",
		"The specified stream does not exist."
	},
	{
		HRES_NS_E_INVALID_ARCHIVE,
		"HRES_NS_E_INVALID_ARCHIVE",
		"The specified archive could not be opened."
	},
	{
		HRES_NS_E_NOTITLES,
		"HRES_NS_E_NOTITLES",
		"The system cannot find any titles on the server."
	},
	{
		HRES_NS_E_INVALID_CLIENT,
		"HRES_NS_E_INVALID_CLIENT",
		"The system cannot find the client specified."
	},
	{
		HRES_NS_E_INVALID_BLACKHOLE_ADDRESS,
		"HRES_NS_E_INVALID_BLACKHOLE_ADDRESS",
		"The Blackhole Address is not initialized."
	},
	{
		HRES_NS_E_INCOMPATIBLE_FORMAT,
		"HRES_NS_E_INCOMPATIBLE_FORMAT",
		"The station does not support the stream format."
	},
	{
		HRES_NS_E_INVALID_KEY,
		"HRES_NS_E_INVALID_KEY",
		"The specified key is not valid."
	},
	{
		HRES_NS_E_INVALID_PORT,
		"HRES_NS_E_INVALID_PORT",
		"The specified port is not valid."
	},
	{
		HRES_NS_E_INVALID_TTL,
		"HRES_NS_E_INVALID_TTL",
		"The specified TTL is not valid."
	},
	{
		HRES_NS_E_STRIDE_REFUSED,
		"HRES_NS_E_STRIDE_REFUSED",
		"The request to fast forward or rewind could not be fulfilled."
	},
	{
		HRES_NS_E_MMSAUTOSERVER_CANTFINDWALKER,
		"HRES_NS_E_MMSAUTOSERVER_CANTFINDWALKER",
		"Unable to load the appropriate file parser."
	},
	{
		HRES_NS_E_MAX_BITRATE,
		"HRES_NS_E_MAX_BITRATE",
		"Cannot exceed the maximum bandwidth limit."
	},
	{
		HRES_NS_E_LOGFILEPERIOD,
		"HRES_NS_E_LOGFILEPERIOD",
		"Invalid value for LogFilePeriod."
	},
	{
		HRES_NS_E_MAX_CLIENTS,
		"HRES_NS_E_MAX_CLIENTS",
		"Cannot exceed the maximum client limit."
	},
	{
		HRES_NS_E_LOG_FILE_SIZE,
		"HRES_NS_E_LOG_FILE_SIZE",
		"The maximum log file size has been reached."
	},
	{
		HRES_NS_E_MAX_FILERATE,
		"HRES_NS_E_MAX_FILERATE",
		"Cannot exceed the maximum file rate."
	},
	{
		HRES_NS_E_WALKER_UNKNOWN,
		"HRES_NS_E_WALKER_UNKNOWN",
		"Unknown file type."
	},
	{
		HRES_NS_E_WALKER_SERVER,
		"HRES_NS_E_WALKER_SERVER",
		"The specified file, %1, cannot be loaded onto the specified server, %2."
	},
	{
		HRES_NS_E_WALKER_USAGE,
		"HRES_NS_E_WALKER_USAGE",
		"There was a usage error with file parser."
	},
	{
		HRES_NS_E_TIGER_FAIL,
		"HRES_NS_E_TIGER_FAIL",
		"The Title Server %1 has failed."
	},
	{
		HRES_NS_E_CUB_FAIL,
		"HRES_NS_E_CUB_FAIL",
		"Content Server %1 (%2) has failed."
	},
	{
		HRES_NS_E_DISK_FAIL,
		"HRES_NS_E_DISK_FAIL",
		"Disk %1 ( %2 ) on Content Server %3, has failed."
	},
	{
		HRES_NS_E_MAX_FUNNELS_ALERT,
		"HRES_NS_E_MAX_FUNNELS_ALERT",
		"The NetShow data stream limit of %1 streams was reached."
	},
	{
		HRES_NS_E_ALLOCATE_FILE_FAIL,
		"HRES_NS_E_ALLOCATE_FILE_FAIL",
		"The NetShow Video Server was unable to allocate a %1 block file named %2."
	},
	{
		HRES_NS_E_PAGING_ERROR,
		"HRES_NS_E_PAGING_ERROR",
		"A Content Server was unable to page a block."
	},
	{
		HRES_NS_E_BAD_BLOCK0_VERSION,
		"HRES_NS_E_BAD_BLOCK0_VERSION",
		"Disk %1 has unrecognized control block version %2."
	},
	{
		HRES_NS_E_BAD_DISK_UID,
		"HRES_NS_E_BAD_DISK_UID",
		"Disk %1 has incorrect uid %2."
	},
	{
		HRES_NS_E_BAD_FSMAJOR_VERSION,
		"HRES_NS_E_BAD_FSMAJOR_VERSION",
		"Disk %1 has unsupported file system major version %2."
	},
	{
		HRES_NS_E_BAD_STAMPNUMBER,
		"HRES_NS_E_BAD_STAMPNUMBER",
		"Disk %1 has bad stamp number in control block."
	},
	{
		HRES_NS_E_PARTIALLY_REBUILT_DISK,
		"HRES_NS_E_PARTIALLY_REBUILT_DISK",
		"Disk %1 is partially reconstructed."
	},
	{
		HRES_NS_E_ENACTPLAN_GIVEUP,
		"HRES_NS_E_ENACTPLAN_GIVEUP",
		"EnactPlan gives up."
	},
	{
		HRES_MCMADM_E_REGKEY_NOT_FOUND,
		"HRES_MCMADM_E_REGKEY_NOT_FOUND",
		"The key was not found in the registry."
	},
	{
		HRES_NS_E_NO_FORMATS,
		"HRES_NS_E_NO_FORMATS",
		"The publishing point cannot be started because the server does not have the appropriate stream formats. Use the Multicast Announcement Wizard to create a new announcement for this publishing point."
	},
	{
		HRES_NS_E_NO_REFERENCES,
		"HRES_NS_E_NO_REFERENCES",
		"No reference URLs were found in an ASX file."
	},
	{
		HRES_NS_E_WAVE_OPEN,
		"HRES_NS_E_WAVE_OPEN",
		"Error opening wave device, the device might be in use."
	},
	{
		HRES_NS_E_CANNOTCONNECTEVENTS,
		"HRES_NS_E_CANNOTCONNECTEVENTS",
		"Unable to establish a connection to the NetShow event monitor service."
	},
	{
		HRES_NS_E_NO_DEVICE,
		"HRES_NS_E_NO_DEVICE",
		"No device driver is present on the system."
	},
	{
		HRES_NS_E_NO_SPECIFIED_DEVICE,
		"HRES_NS_E_NO_SPECIFIED_DEVICE",
		"No specified device driver is present."
	},
	{
		HRES_NS_E_MONITOR_GIVEUP,
		"HRES_NS_E_MONITOR_GIVEUP",
		"Netshow Events Monitor is not operational and has been disconnected."
	},
	{
		HRES_NS_E_REMIRRORED_DISK,
		"HRES_NS_E_REMIRRORED_DISK",
		"Disk %1 is remirrored."
	},
	{
		HRES_NS_E_INSUFFICIENT_DATA,
		"HRES_NS_E_INSUFFICIENT_DATA",
		"Insufficient data found."
	},
	{
		HRES_NS_E_ASSERT,
		"HRES_NS_E_ASSERT",
		"1 failed in file %2 line %3."
	},
	{
		HRES_NS_E_BAD_ADAPTER_NAME,
		"HRES_NS_E_BAD_ADAPTER_NAME",
		"The specified adapter name is invalid."
	},
	{
		HRES_NS_E_NOT_LICENSED,
		"HRES_NS_E_NOT_LICENSED",
		"The application is not licensed for this feature."
	},
	{
		HRES_NS_E_NO_SERVER_CONTACT,
		"HRES_NS_E_NO_SERVER_CONTACT",
		"Unable to contact the server."
	},
	{
		HRES_NS_E_TOO_MANY_TITLES,
		"HRES_NS_E_TOO_MANY_TITLES",
		"Maximum number of titles exceeded."
	},
	{
		HRES_NS_E_TITLE_SIZE_EXCEEDED,
		"HRES_NS_E_TITLE_SIZE_EXCEEDED",
		"Maximum size of a title exceeded."
	},
	{
		HRES_NS_E_UDP_DISABLED,
		"HRES_NS_E_UDP_DISABLED",
		"UDP protocol not enabled. Not trying %1!ls!."
	},
	{
		HRES_NS_E_TCP_DISABLED,
		"HRES_NS_E_TCP_DISABLED",
		"TCP protocol not enabled. Not trying %1!ls!."
	},
	{
		HRES_NS_E_HTTP_DISABLED,
		"HRES_NS_E_HTTP_DISABLED",
		"HTTP protocol not enabled. Not trying %1!ls!."
	},
	{
		HRES_NS_E_LICENSE_EXPIRED,
		"HRES_NS_E_LICENSE_EXPIRED",
		"The product license has expired."
	},
	{
		HRES_NS_E_TITLE_BITRATE,
		"HRES_NS_E_TITLE_BITRATE",
		"Source file exceeds the per title maximum bitrate. See NetShow Theater documentation for more information."
	},
	{
		HRES_NS_E_EMPTY_PROGRAM_NAME,
		"HRES_NS_E_EMPTY_PROGRAM_NAME",
		"The program name cannot be empty."
	},
	{
		HRES_NS_E_MISSING_CHANNEL,
		"HRES_NS_E_MISSING_CHANNEL",
		"Station %1 does not exist."
	},
	{
		HRES_NS_E_NO_CHANNELS,
		"HRES_NS_E_NO_CHANNELS",
		"You need to define at least one station before this operation can complete."
	},
	{
		HRES_NS_E_INVALID_INDEX2,
		"HRES_NS_E_INVALID_INDEX2",
		"The index specified is invalid."
	},
	{
		HRES_NS_E_CUB_FAIL_LINK,
		"HRES_NS_E_CUB_FAIL_LINK",
		"Content Server %1 (%2) has failed its link to Content Server %3."
	},
	{
		HRES_NS_E_BAD_CUB_UID,
		"HRES_NS_E_BAD_CUB_UID",
		"Content Server %1 (%2) has incorrect uid %3."
	},
	{
		HRES_NS_E_GLITCH_MODE,
		"HRES_NS_E_GLITCH_MODE",
		"Server unreliable because multiple components failed."
	},
	{
		HRES_NS_E_NO_MEDIA_PROTOCOL,
		"HRES_NS_E_NO_MEDIA_PROTOCOL",
		"Content Server %1 (%2) is unable to communicate with the Media System Network Protocol."
	},
	{
		HRES_NS_E_NOTHING_TO_DO,
		"HRES_NS_E_NOTHING_TO_DO",
		"Nothing to do."
	},
	{
		HRES_NS_E_NO_MULTICAST,
		"HRES_NS_E_NO_MULTICAST",
		"Not receiving data from the server."
	},
	{
		HRES_NS_E_INVALID_INPUT_FORMAT,
		"HRES_NS_E_INVALID_INPUT_FORMAT",
		"The input media format is invalid."
	},
	{
		HRES_NS_E_MSAUDIO_NOT_INSTALLED,
		"HRES_NS_E_MSAUDIO_NOT_INSTALLED",
		"The MSAudio codec is not installed on this system."
	},
	{
		HRES_NS_E_UNEXPECTED_MSAUDIO_ERROR,
		"HRES_NS_E_UNEXPECTED_MSAUDIO_ERROR",
		"An unexpected error occurred with the MSAudio codec."
	},
	{
		HRES_NS_E_INVALID_OUTPUT_FORMAT,
		"HRES_NS_E_INVALID_OUTPUT_FORMAT",
		"The output media format is invalid."
	},
	{
		HRES_NS_E_NOT_CONFIGURED,
		"HRES_NS_E_NOT_CONFIGURED",
		"The object must be fully configured before audio samples can be processed."
	},
	{
		HRES_NS_E_PROTECTED_CONTENT,
		"HRES_NS_E_PROTECTED_CONTENT",
		"You need a license to perform the requested operation on this media file."
	},
	{
		HRES_NS_E_LICENSE_REQUIRED,
		"HRES_NS_E_LICENSE_REQUIRED",
		"You need a license to perform the requested operation on this media file."
	},
	{
		HRES_NS_E_TAMPERED_CONTENT,
		"HRES_NS_E_TAMPERED_CONTENT",
		"This media file is corrupted or invalid. Contact the content provider for a new file."
	},
	{
		HRES_NS_E_LICENSE_OUTOFDATE,
		"HRES_NS_E_LICENSE_OUTOFDATE",
		"The license for this media file has expired. Get a new license or contact the content provider for further assistance."
	},
	{
		HRES_NS_E_LICENSE_INCORRECT_RIGHTS,
		"HRES_NS_E_LICENSE_INCORRECT_RIGHTS",
		"You are not allowed to open this file. Contact the content provider for further assistance."
	},
	{
		HRES_NS_E_AUDIO_CODEC_NOT_INSTALLED,
		"HRES_NS_E_AUDIO_CODEC_NOT_INSTALLED",
		"The requested audio codec is not installed on this system."
	},
	{
		HRES_NS_E_AUDIO_CODEC_ERROR,
		"HRES_NS_E_AUDIO_CODEC_ERROR",
		"An unexpected error occurred with the audio codec."
	},
	{
		HRES_NS_E_VIDEO_CODEC_NOT_INSTALLED,
		"HRES_NS_E_VIDEO_CODEC_NOT_INSTALLED",
		"The requested video codec is not installed on this system."
	},
	{
		HRES_NS_E_VIDEO_CODEC_ERROR,
		"HRES_NS_E_VIDEO_CODEC_ERROR",
		"An unexpected error occurred with the video codec."
	},
	{
		HRES_NS_E_INVALIDPROFILE,
		"HRES_NS_E_INVALIDPROFILE",
		"The Profile is invalid."
	},
	{
		HRES_NS_E_INCOMPATIBLE_VERSION,
		"HRES_NS_E_INCOMPATIBLE_VERSION",
		"A new version of the SDK is needed to play the requested content."
	},
	{
		HRES_NS_E_OFFLINE_MODE,
		"HRES_NS_E_OFFLINE_MODE",
		"The requested URL is not available in offline mode."
	},
	{
		HRES_NS_E_NOT_CONNECTED,
		"HRES_NS_E_NOT_CONNECTED",
		"The requested URL cannot be accessed because there is no network connection."
	},
	{
		HRES_NS_E_TOO_MUCH_DATA,
		"HRES_NS_E_TOO_MUCH_DATA",
		"The encoding process was unable to keep up with the amount of supplied data."
	},
	{
		HRES_NS_E_UNSUPPORTED_PROPERTY,
		"HRES_NS_E_UNSUPPORTED_PROPERTY",
		"The given property is not supported."
	},
	{
		HRES_NS_E_8BIT_WAVE_UNSUPPORTED,
		"HRES_NS_E_8BIT_WAVE_UNSUPPORTED",
		"Windows Media Player cannot copy the files to the CD because they are 8-bit. Convert the files to 16-bit, 44-kHz stereo files by using Sound Recorder or another audio-processing program, and then try again."
	},
	{
		HRES_NS_E_NO_MORE_SAMPLES,
		"HRES_NS_E_NO_MORE_SAMPLES",
		"There are no more samples in the current range."
	},
	{
		HRES_NS_E_INVALID_SAMPLING_RATE,
		"HRES_NS_E_INVALID_SAMPLING_RATE",
		"The given sampling rate is invalid."
	},
	{
		HRES_NS_E_MAX_PACKET_SIZE_TOO_SMALL,
		"HRES_NS_E_MAX_PACKET_SIZE_TOO_SMALL",
		"The given maximum packet size is too small to accommodate this profile.)"
	},
	{
		HRES_NS_E_LATE_PACKET,
		"HRES_NS_E_LATE_PACKET",
		"The packet arrived too late to be of use."
	},
	{
		HRES_NS_E_DUPLICATE_PACKET,
		"HRES_NS_E_DUPLICATE_PACKET",
		"The packet is a duplicate of one received before."
	},
	{
		HRES_NS_E_SDK_BUFFERTOOSMALL,
		"HRES_NS_E_SDK_BUFFERTOOSMALL",
		"Supplied buffer is too small."
	},
	{
		HRES_NS_E_INVALID_NUM_PASSES,
		"HRES_NS_E_INVALID_NUM_PASSES",
		"The wrong number of preprocessing passes was used for the stream's output type."
	},
	{
		HRES_NS_E_ATTRIBUTE_READ_ONLY,
		"HRES_NS_E_ATTRIBUTE_READ_ONLY",
		"An attempt was made to add, modify, or delete a read only attribute."
	},
	{
		HRES_NS_E_ATTRIBUTE_NOT_ALLOWED,
		"HRES_NS_E_ATTRIBUTE_NOT_ALLOWED",
		"An attempt was made to add attribute that is not allowed for the given media type."
	},
	{
		HRES_NS_E_INVALID_EDL,
		"HRES_NS_E_INVALID_EDL",
		"The EDL provided is invalid."
	},
	{
		HRES_NS_E_DATA_UNIT_EXTENSION_TOO_LARGE,
		"HRES_NS_E_DATA_UNIT_EXTENSION_TOO_LARGE",
		"The Data Unit Extension data was too large to be used."
	},
	{
		HRES_NS_E_CODEC_DMO_ERROR,
		"HRES_NS_E_CODEC_DMO_ERROR",
		"An unexpected error occurred with a DMO codec."
	},
	{
		HRES_NS_E_FEATURE_DISABLED_BY_GROUP_POLICY,
		"HRES_NS_E_FEATURE_DISABLED_BY_GROUP_POLICY",
		"This feature has been disabled by group policy."
	},
	{
		HRES_NS_E_FEATURE_DISABLED_IN_SKU,
		"HRES_NS_E_FEATURE_DISABLED_IN_SKU",
		"This feature is disabled in this SKU."
	},
	{
		HRES_NS_E_NO_CD,
		"HRES_NS_E_NO_CD",
		"There is no CD in the CD drive. Insert a CD, and then try again."
	},
	{
		HRES_NS_E_CANT_READ_DIGITAL,
		"HRES_NS_E_CANT_READ_DIGITAL",
		"Windows Media Player could not use digital playback to play the CD. To switch to analog playback, on the Tools menu, click Options, and then click the Devices tab. Double-click the CD drive, and then in the Playback area, click Analog. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_DEVICE_DISCONNECTED,
		"HRES_NS_E_DEVICE_DISCONNECTED",
		"Windows Media Player no longer detects a connected portable device. Reconnect your portable device, and then try synchronizing the file again."
	},
	{
		HRES_NS_E_DEVICE_NOT_SUPPORT_FORMAT,
		"HRES_NS_E_DEVICE_NOT_SUPPORT_FORMAT",
		"Windows Media Player cannot play the file. The portable device does not support the specified file type."
	},
	{
		HRES_NS_E_SLOW_READ_DIGITAL,
		"HRES_NS_E_SLOW_READ_DIGITAL",
		"Windows Media Player could not use digital playback to play the CD. The Player has automatically switched the CD drive to analog playback. To switch back to digital CD playback, use the Devices tab. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_MIXER_INVALID_LINE,
		"HRES_NS_E_MIXER_INVALID_LINE",
		"An invalid line error occurred in the mixer."
	},
	{
		HRES_NS_E_MIXER_INVALID_CONTROL,
		"HRES_NS_E_MIXER_INVALID_CONTROL",
		"An invalid control error occurred in the mixer."
	},
	{
		HRES_NS_E_MIXER_INVALID_VALUE,
		"HRES_NS_E_MIXER_INVALID_VALUE",
		"An invalid value error occurred in the mixer."
	},
	{
		HRES_NS_E_MIXER_UNKNOWN_MMRESULT,
		"HRES_NS_E_MIXER_UNKNOWN_MMRESULT",
		"An unrecognized MMRESULT occurred in the mixer."
	},
	{
		HRES_NS_E_USER_STOP,
		"HRES_NS_E_USER_STOP",
		"User has stopped the operation."
	},
	{
		HRES_NS_E_MP3_FORMAT_NOT_FOUND,
		"HRES_NS_E_MP3_FORMAT_NOT_FOUND",
		"Windows Media Player cannot rip the track because a compatible MP3 encoder is not installed on your computer. Install a compatible MP3 encoder or choose a different format to rip to (such as Windows Media Audio)."
	},
	{
		HRES_NS_E_CD_READ_ERROR_NO_CORRECTION,
		"HRES_NS_E_CD_READ_ERROR_NO_CORRECTION",
		"Windows Media Player cannot read the CD. The disc might be dirty or damaged. Turn on error correction, and then try again."
	},
	{
		HRES_NS_E_CD_READ_ERROR,
		"HRES_NS_E_CD_READ_ERROR",
		"Windows Media Player cannot read the CD. The disc might be dirty or damaged or the CD drive might be malfunctioning."
	},
	{
		HRES_NS_E_CD_SLOW_COPY,
		"HRES_NS_E_CD_SLOW_COPY",
		"For best performance, do not play CD tracks while ripping them."
	},
	{
		HRES_NS_E_CD_COPYTO_CD,
		"HRES_NS_E_CD_COPYTO_CD",
		"It is not possible to directly burn tracks from one CD to another CD. You must first rip the tracks from the CD to your computer, and then burn the files to a blank CD."
	},
	{
		HRES_NS_E_MIXER_NODRIVER,
		"HRES_NS_E_MIXER_NODRIVER",
		"Could not open a sound mixer driver."
	},
	{
		HRES_NS_E_REDBOOK_ENABLED_WHILE_COPYING,
		"HRES_NS_E_REDBOOK_ENABLED_WHILE_COPYING",
		"Windows Media Player cannot rip tracks from the CD correctly because the CD drive settings in Device Manager do not match the CD drive settings in the Player."
	},
	{
		HRES_NS_E_CD_REFRESH,
		"HRES_NS_E_CD_REFRESH",
		"Windows Media Player is busy reading the CD."
	},
	{
		HRES_NS_E_CD_DRIVER_PROBLEM,
		"HRES_NS_E_CD_DRIVER_PROBLEM",
		"Windows Media Player could not use digital playback to play the CD. The Player has automatically switched the CD drive to analog playback. To switch back to digital CD playback, use the Devices tab. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WONT_DO_DIGITAL,
		"HRES_NS_E_WONT_DO_DIGITAL",
		"Windows Media Player could not use digital playback to play the CD. The Player has automatically switched the CD drive to analog playback. To switch back to digital CD playback, use the Devices tab. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMPXML_NOERROR,
		"HRES_NS_E_WMPXML_NOERROR",
		"A call was made to GetParseError on the XML parser but there was no error to retrieve."
	},
	{
		HRES_NS_E_WMPXML_ENDOFDATA,
		"HRES_NS_E_WMPXML_ENDOFDATA",
		"The XML Parser ran out of data while parsing."
	},
	{
		HRES_NS_E_WMPXML_PARSEERROR,
		"HRES_NS_E_WMPXML_PARSEERROR",
		"A generic parse error occurred in the XML parser but no information is available."
	},
	{
		HRES_NS_E_WMPXML_ATTRIBUTENOTFOUND,
		"HRES_NS_E_WMPXML_ATTRIBUTENOTFOUND",
		"A call get GetNamedAttribute or GetNamedAttributeIndex on the XML parser resulted in the index not being found."
	},
	{
		HRES_NS_E_WMPXML_PINOTFOUND,
		"HRES_NS_E_WMPXML_PINOTFOUND",
		"A call was made go GetNamedPI on the XML parser, but the requested Processing Instruction was not found."
	},
	{
		HRES_NS_E_WMPXML_EMPTYDOC,
		"HRES_NS_E_WMPXML_EMPTYDOC",
		"Persist was called on the XML parser, but the parser has no data to persist."
	},
	{
		HRES_NS_E_WMP_PATH_ALREADY_IN_LIBRARY,
		"HRES_NS_E_WMP_PATH_ALREADY_IN_LIBRARY",
		"This file path is already in the library."
	},
	{
		HRES_NS_E_WMP_FILESCANALREADYSTARTED,
		"HRES_NS_E_WMP_FILESCANALREADYSTARTED",
		"Windows Media Player is already searching for files to add to your library. Wait for the current process to finish before attempting to search again."
	},
	{
		HRES_NS_E_WMP_HME_INVALIDOBJECTID,
		"HRES_NS_E_WMP_HME_INVALIDOBJECTID",
		"Windows Media Player is unable to find the media you are looking for."
	},
	{
		HRES_NS_E_WMP_MF_CODE_EXPIRED,
		"HRES_NS_E_WMP_MF_CODE_EXPIRED",
		"A component of Windows Media Player is out-of-date. If you are running a pre-release version of Windows, try upgrading to a more recent version."
	},
	{
		HRES_NS_E_WMP_HME_NOTSEARCHABLEFORITEMS,
		"HRES_NS_E_WMP_HME_NOTSEARCHABLEFORITEMS",
		"This container does not support search on items."
	},
	{
		HRES_NS_E_WMP_ADDTOLIBRARY_FAILED,
		"HRES_NS_E_WMP_ADDTOLIBRARY_FAILED",
		"Windows Media Player encountered a problem while adding one or more files to the library. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMP_WINDOWSAPIFAILURE,
		"HRES_NS_E_WMP_WINDOWSAPIFAILURE",
		"A Windows API call failed but no error information was available."
	},
	{
		HRES_NS_E_WMP_RECORDING_NOT_ALLOWED,
		"HRES_NS_E_WMP_RECORDING_NOT_ALLOWED",
		"This file does not have burn rights. If you obtained this file from an online store, go to the online store to get burn rights."
	},
	{
		HRES_NS_E_DEVICE_NOT_READY,
		"HRES_NS_E_DEVICE_NOT_READY",
		"Windows Media Player no longer detects a connected portable device. Reconnect your portable device, and then try to sync the file again."
	},
	{
		HRES_NS_E_DAMAGED_FILE,
		"HRES_NS_E_DAMAGED_FILE",
		"Windows Media Player cannot play the file because it is corrupted."
	},
	{
		HRES_NS_E_MPDB_GENERIC,
		"HRES_NS_E_MPDB_GENERIC",
		"Windows Media Player encountered an error while attempting to access information in the library. Try restarting the Player."
	},
	{
		HRES_NS_E_FILE_FAILED_CHECKS,
		"HRES_NS_E_FILE_FAILED_CHECKS",
		"The file cannot be added to the library because it is smaller than the \"Skip files smaller than\" setting. To add the file, change the setting on the Library tab. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_MEDIA_LIBRARY_FAILED,
		"HRES_NS_E_MEDIA_LIBRARY_FAILED",
		"Windows Media Player cannot create the library. You must be logged on as an administrator or a member of the Administrators group to install the Player. For more information, contact your system administrator."
	},
	{
		HRES_NS_E_SHARING_VIOLATION,
		"HRES_NS_E_SHARING_VIOLATION",
		"The file is already in use. Close other programs that might be using the file, or stop playing the file, and then try again."
	},
	{
		HRES_NS_E_NO_ERROR_STRING_FOUND,
		"HRES_NS_E_NO_ERROR_STRING_FOUND",
		"Windows Media Player has encountered an unknown error."
	},
	{
		HRES_NS_E_WMPOCX_NO_REMOTE_CORE,
		"HRES_NS_E_WMPOCX_NO_REMOTE_CORE",
		"The Windows Media Player ActiveX control cannot connect to remote media services, but will continue with local media services."
	},
	{
		HRES_NS_E_WMPOCX_NO_ACTIVE_CORE,
		"HRES_NS_E_WMPOCX_NO_ACTIVE_CORE",
		"The requested method or property is not available because the Windows Media Player ActiveX control has not been properly activated."
	},
	{
		HRES_NS_E_WMPOCX_NOT_RUNNING_REMOTELY,
		"HRES_NS_E_WMPOCX_NOT_RUNNING_REMOTELY",
		"The Windows Media Player ActiveX control is not running in remote mode."
	},
	{
		HRES_NS_E_WMPOCX_NO_REMOTE_WINDOW,
		"HRES_NS_E_WMPOCX_NO_REMOTE_WINDOW",
		"An error occurred while trying to get the remote Windows Media Player window."
	},
	{
		HRES_NS_E_WMPOCX_ERRORMANAGERNOTAVAILABLE,
		"HRES_NS_E_WMPOCX_ERRORMANAGERNOTAVAILABLE",
		"Windows Media Player has encountered an unknown error."
	},
	{
		HRES_NS_E_PLUGIN_NOTSHUTDOWN,
		"HRES_NS_E_PLUGIN_NOTSHUTDOWN",
		"Windows Media Player was not closed properly. A damaged or incompatible plug-in might have caused the problem to occur. As a precaution, all optional plug-ins have been disabled."
	},
	{
		HRES_NS_E_WMP_CANNOT_FIND_FOLDER,
		"HRES_NS_E_WMP_CANNOT_FIND_FOLDER",
		"Windows Media Player cannot find the specified path. Verify that the path is typed correctly. If it is, the path does not exist in the specified location, or the computer where the path is located is not available."
	},
	{
		HRES_NS_E_WMP_STREAMING_RECORDING_NOT_ALLOWED,
		"HRES_NS_E_WMP_STREAMING_RECORDING_NOT_ALLOWED",
		"Windows Media Player cannot save a file that is being streamed."
	},
	{
		HRES_NS_E_WMP_PLUGINDLL_NOTFOUND,
		"HRES_NS_E_WMP_PLUGINDLL_NOTFOUND",
		"Windows Media Player cannot find the selected plug-in. The Player will try to remove it from the menu. To use this plug-in, install it again."
	},
	{
		HRES_NS_E_NEED_TO_ASK_USER,
		"HRES_NS_E_NEED_TO_ASK_USER",
		"Action requires input from the user."
	},
	{
		HRES_NS_E_WMPOCX_PLAYER_NOT_DOCKED,
		"HRES_NS_E_WMPOCX_PLAYER_NOT_DOCKED",
		"The Windows Media Player ActiveX control must be in a docked state for this action to be performed."
	},
	{
		HRES_NS_E_WMP_EXTERNAL_NOTREADY,
		"HRES_NS_E_WMP_EXTERNAL_NOTREADY",
		"The Windows Media Player external object is not ready."
	},
	{
		HRES_NS_E_WMP_MLS_STALE_DATA,
		"HRES_NS_E_WMP_MLS_STALE_DATA",
		"Windows Media Player cannot perform the requested action. Your computer's time and date might not be set correctly."
	},
	{
		HRES_NS_E_WMP_UI_SUBCONTROLSNOTSUPPORTED,
		"HRES_NS_E_WMP_UI_SUBCONTROLSNOTSUPPORTED",
		"The control (%s) does not support creation of sub-controls, yet (%d) sub-controls have been specified."
	},
	{
		HRES_NS_E_WMP_UI_VERSIONMISMATCH,
		"HRES_NS_E_WMP_UI_VERSIONMISMATCH",
		"Version mismatch: (%.1f required, %.1f found)."
	},
	{
		HRES_NS_E_WMP_UI_NOTATHEMEFILE,
		"HRES_NS_E_WMP_UI_NOTATHEMEFILE",
		"The layout manager was given valid XML that wasn't a theme file."
	},
	{
		HRES_NS_E_WMP_UI_SUBELEMENTNOTFOUND,
		"HRES_NS_E_WMP_UI_SUBELEMENTNOTFOUND",
		"The %s subelement could not be found on the %s object."
	},
	{
		HRES_NS_E_WMP_UI_VERSIONPARSE,
		"HRES_NS_E_WMP_UI_VERSIONPARSE",
		"An error occurred parsing the version tag. Valid version tags are of the form: <?wmp version='1.0'?>."
	},
	{
		HRES_NS_E_WMP_UI_VIEWIDNOTFOUND,
		"HRES_NS_E_WMP_UI_VIEWIDNOTFOUND",
		"The view specified in for the 'currentViewID' property (%s) was not found in this theme file."
	},
	{
		HRES_NS_E_WMP_UI_PASSTHROUGH,
		"HRES_NS_E_WMP_UI_PASSTHROUGH",
		"This error used internally for hit testing."
	},
	{
		HRES_NS_E_WMP_UI_OBJECTNOTFOUND,
		"HRES_NS_E_WMP_UI_OBJECTNOTFOUND",
		"Attributes were specified for the %s object, but the object was not available to send them to."
	},
	{
		HRES_NS_E_WMP_UI_SECONDHANDLER,
		"HRES_NS_E_WMP_UI_SECONDHANDLER",
		"The %s event already has a handler, the second handler was ignored."
	},
	{
		HRES_NS_E_WMP_UI_NOSKININZIP,
		"HRES_NS_E_WMP_UI_NOSKININZIP",
		"No .wms file found in skin archive."
	},
	{
		HRES_NS_E_WMP_URLDOWNLOADFAILED,
		"HRES_NS_E_WMP_URLDOWNLOADFAILED",
		"Windows Media Player encountered a problem while downloading the file. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMPOCX_UNABLE_TO_LOAD_SKIN,
		"HRES_NS_E_WMPOCX_UNABLE_TO_LOAD_SKIN",
		"The Windows Media Player ActiveX control cannot load the requested uiMode and cannot roll back to the existing uiMode."
	},
	{
		HRES_NS_E_WMP_INVALID_SKIN,
		"HRES_NS_E_WMP_INVALID_SKIN",
		"Windows Media Player encountered a problem with the skin file. The skin file might not be valid."
	},
	{
		HRES_NS_E_WMP_SENDMAILFAILED,
		"HRES_NS_E_WMP_SENDMAILFAILED",
		"Windows Media Player cannot send the link because your email program is not responding. Verify that your email program is configured properly, and then try again. For more information about email, see Windows Help."
	},
	{
		HRES_NS_E_WMP_LOCKEDINSKINMODE,
		"HRES_NS_E_WMP_LOCKEDINSKINMODE",
		"Windows Media Player cannot switch to full mode because your computer administrator has locked this skin."
	},
	{
		HRES_NS_E_WMP_FAILED_TO_SAVE_FILE,
		"HRES_NS_E_WMP_FAILED_TO_SAVE_FILE",
		"Windows Media Player encountered a problem while saving the file. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMP_SAVEAS_READONLY,
		"HRES_NS_E_WMP_SAVEAS_READONLY",
		"Windows Media Player cannot overwrite a read-only file. Try using a different file name."
	},
	{
		HRES_NS_E_WMP_FAILED_TO_SAVE_PLAYLIST,
		"HRES_NS_E_WMP_FAILED_TO_SAVE_PLAYLIST",
		"Windows Media Player encountered a problem while creating or saving the playlist. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMP_FAILED_TO_OPEN_WMD,
		"HRES_NS_E_WMP_FAILED_TO_OPEN_WMD",
		"Windows Media Player cannot open the Windows Media Download file. The file might be damaged."
	},
	{
		HRES_NS_E_WMP_CANT_PLAY_PROTECTED,
		"HRES_NS_E_WMP_CANT_PLAY_PROTECTED",
		"The file cannot be added to the library because it is a protected DVR-MS file. This content cannot be played back by Windows Media Player."
	},
	{
		HRES_NS_E_SHARING_STATE_OUT_OF_SYNC,
		"HRES_NS_E_SHARING_STATE_OUT_OF_SYNC",
		"Media sharing has been turned off because a required Windows setting or component has changed. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMPOCX_REMOTE_PLAYER_ALREADY_RUNNING,
		"HRES_NS_E_WMPOCX_REMOTE_PLAYER_ALREADY_RUNNING",
		"Exclusive Services launch failed because the Windows Media Player is already running."
	},
	{
		HRES_NS_E_WMP_RBC_JPGMAPPINGIMAGE,
		"HRES_NS_E_WMP_RBC_JPGMAPPINGIMAGE",
		"JPG Images are not recommended for use as a mappingImage."
	},
	{
		HRES_NS_E_WMP_JPGTRANSPARENCY,
		"HRES_NS_E_WMP_JPGTRANSPARENCY",
		"JPG Images are not recommended when using a transparencyColor."
	},
	{
		HRES_NS_E_WMP_INVALID_MAX_VAL,
		"HRES_NS_E_WMP_INVALID_MAX_VAL",
		"The Max property cannot be less than Min property."
	},
	{
		HRES_NS_E_WMP_INVALID_MIN_VAL,
		"HRES_NS_E_WMP_INVALID_MIN_VAL",
		"The Min property cannot be greater than Max property."
	},
	{
		HRES_NS_E_WMP_CS_JPGPOSITIONIMAGE,
		"HRES_NS_E_WMP_CS_JPGPOSITIONIMAGE",
		"JPG Images are not recommended for use as a positionImage."
	},
	{
		HRES_NS_E_WMP_CS_NOTEVENLYDIVISIBLE,
		"HRES_NS_E_WMP_CS_NOTEVENLYDIVISIBLE",
		"The (%s) image's size is not evenly divisible by the positionImage's size."
	},
	{
		HRES_NS_E_WMPZIP_NOTAZIPFILE,
		"HRES_NS_E_WMPZIP_NOTAZIPFILE",
		"The ZIP reader opened a file and its signature did not match that of the ZIP files."
	},
	{
		HRES_NS_E_WMPZIP_CORRUPT,
		"HRES_NS_E_WMPZIP_CORRUPT",
		"The ZIP reader has detected that the file is corrupted."
	},
	{
		HRES_NS_E_WMPZIP_FILENOTFOUND,
		"HRES_NS_E_WMPZIP_FILENOTFOUND",
		"GetFileStream, SaveToFile, or SaveTemp file was called on the ZIP reader with a file name that was not found in the ZIP file."
	},
	{
		HRES_NS_E_WMP_IMAGE_FILETYPE_UNSUPPORTED,
		"HRES_NS_E_WMP_IMAGE_FILETYPE_UNSUPPORTED",
		"Image type not supported."
	},
	{
		HRES_NS_E_WMP_IMAGE_INVALID_FORMAT,
		"HRES_NS_E_WMP_IMAGE_INVALID_FORMAT",
		"Image file might be corrupt."
	},
	{
		HRES_NS_E_WMP_GIF_UNEXPECTED_ENDOFFILE,
		"HRES_NS_E_WMP_GIF_UNEXPECTED_ENDOFFILE",
		"Unexpected end of file. GIF file might be corrupt."
	},
	{
		HRES_NS_E_WMP_GIF_INVALID_FORMAT,
		"HRES_NS_E_WMP_GIF_INVALID_FORMAT",
		"Invalid GIF file."
	},
	{
		HRES_NS_E_WMP_GIF_BAD_VERSION_NUMBER,
		"HRES_NS_E_WMP_GIF_BAD_VERSION_NUMBER",
		"Invalid GIF version. Only 87a or 89a supported."
	},
	{
		HRES_NS_E_WMP_GIF_NO_IMAGE_IN_FILE,
		"HRES_NS_E_WMP_GIF_NO_IMAGE_IN_FILE",
		"No images found in GIF file."
	},
	{
		HRES_NS_E_WMP_PNG_INVALIDFORMAT,
		"HRES_NS_E_WMP_PNG_INVALIDFORMAT",
		"Invalid PNG image file format."
	},
	{
		HRES_NS_E_WMP_PNG_UNSUPPORTED_BITDEPTH,
		"HRES_NS_E_WMP_PNG_UNSUPPORTED_BITDEPTH",
		"PNG bitdepth not supported."
	},
	{
		HRES_NS_E_WMP_PNG_UNSUPPORTED_COMPRESSION,
		"HRES_NS_E_WMP_PNG_UNSUPPORTED_COMPRESSION",
		"Compression format defined in PNG file not supported,"
	},
	{
		HRES_NS_E_WMP_PNG_UNSUPPORTED_FILTER,
		"HRES_NS_E_WMP_PNG_UNSUPPORTED_FILTER",
		"Filter method defined in PNG file not supported."
	},
	{
		HRES_NS_E_WMP_PNG_UNSUPPORTED_INTERLACE,
		"HRES_NS_E_WMP_PNG_UNSUPPORTED_INTERLACE",
		"Interlace method defined in PNG file not supported."
	},
	{
		HRES_NS_E_WMP_PNG_UNSUPPORTED_BAD_CRC,
		"HRES_NS_E_WMP_PNG_UNSUPPORTED_BAD_CRC",
		"Bad CRC in PNG file."
	},
	{
		HRES_NS_E_WMP_BMP_INVALID_BITMASK,
		"HRES_NS_E_WMP_BMP_INVALID_BITMASK",
		"Invalid bitmask in BMP file."
	},
	{
		HRES_NS_E_WMP_BMP_TOPDOWN_DIB_UNSUPPORTED,
		"HRES_NS_E_WMP_BMP_TOPDOWN_DIB_UNSUPPORTED",
		"Topdown DIB not supported."
	},
	{
		HRES_NS_E_WMP_BMP_BITMAP_NOT_CREATED,
		"HRES_NS_E_WMP_BMP_BITMAP_NOT_CREATED",
		"Bitmap could not be created."
	},
	{
		HRES_NS_E_WMP_BMP_COMPRESSION_UNSUPPORTED,
		"HRES_NS_E_WMP_BMP_COMPRESSION_UNSUPPORTED",
		"Compression format defined in BMP not supported."
	},
	{
		HRES_NS_E_WMP_BMP_INVALID_FORMAT,
		"HRES_NS_E_WMP_BMP_INVALID_FORMAT",
		"Invalid Bitmap format."
	},
	{
		HRES_NS_E_WMP_JPG_JERR_ARITHCODING_NOTIMPL,
		"HRES_NS_E_WMP_JPG_JERR_ARITHCODING_NOTIMPL",
		"JPEG Arithmetic coding not supported."
	},
	{
		HRES_NS_E_WMP_JPG_INVALID_FORMAT,
		"HRES_NS_E_WMP_JPG_INVALID_FORMAT",
		"Invalid JPEG format."
	},
	{
		HRES_NS_E_WMP_JPG_BAD_DCTSIZE,
		"HRES_NS_E_WMP_JPG_BAD_DCTSIZE",
		"Invalid JPEG format."
	},
	{
		HRES_NS_E_WMP_JPG_BAD_VERSION_NUMBER,
		"HRES_NS_E_WMP_JPG_BAD_VERSION_NUMBER",
		"Internal version error. Unexpected JPEG library version."
	},
	{
		HRES_NS_E_WMP_JPG_BAD_PRECISION,
		"HRES_NS_E_WMP_JPG_BAD_PRECISION",
		"Internal JPEG Library error. Unsupported JPEG data precision."
	},
	{
		HRES_NS_E_WMP_JPG_CCIR601_NOTIMPL,
		"HRES_NS_E_WMP_JPG_CCIR601_NOTIMPL",
		"JPEG CCIR601 not supported."
	},
	{
		HRES_NS_E_WMP_JPG_NO_IMAGE_IN_FILE,
		"HRES_NS_E_WMP_JPG_NO_IMAGE_IN_FILE",
		"No image found in JPEG file."
	},
	{
		HRES_NS_E_WMP_JPG_READ_ERROR,
		"HRES_NS_E_WMP_JPG_READ_ERROR",
		"Could not read JPEG file."
	},
	{
		HRES_NS_E_WMP_JPG_FRACT_SAMPLE_NOTIMPL,
		"HRES_NS_E_WMP_JPG_FRACT_SAMPLE_NOTIMPL",
		"JPEG Fractional sampling not supported."
	},
	{
		HRES_NS_E_WMP_JPG_IMAGE_TOO_BIG,
		"HRES_NS_E_WMP_JPG_IMAGE_TOO_BIG",
		"JPEG image too large. Maximum image size supported is 65500 X 65500."
	},
	{
		HRES_NS_E_WMP_JPG_UNEXPECTED_ENDOFFILE,
		"HRES_NS_E_WMP_JPG_UNEXPECTED_ENDOFFILE",
		"Unexpected end of file reached in JPEG file."
	},
	{
		HRES_NS_E_WMP_JPG_SOF_UNSUPPORTED,
		"HRES_NS_E_WMP_JPG_SOF_UNSUPPORTED",
		"Unsupported JPEG SOF marker found."
	},
	{
		HRES_NS_E_WMP_JPG_UNKNOWN_MARKER,
		"HRES_NS_E_WMP_JPG_UNKNOWN_MARKER",
		"Unknown JPEG marker found."
	},
	{
		HRES_NS_E_WMP_FAILED_TO_OPEN_IMAGE,
		"HRES_NS_E_WMP_FAILED_TO_OPEN_IMAGE",
		"Windows Media Player cannot display the picture file. The player either does not support the picture type or the picture is corrupted."
	},
	{
		HRES_NS_E_WMP_DAI_SONGTOOSHORT,
		"HRES_NS_E_WMP_DAI_SONGTOOSHORT",
		"Windows Media Player cannot compute a Digital Audio Id for the song. It is too short."
	},
	{
		HRES_NS_E_WMG_RATEUNAVAILABLE,
		"HRES_NS_E_WMG_RATEUNAVAILABLE",
		"Windows Media Player cannot play the file at the requested speed."
	},
	{
		HRES_NS_E_WMG_PLUGINUNAVAILABLE,
		"HRES_NS_E_WMG_PLUGINUNAVAILABLE",
		"The rendering or digital signal processing plug-in cannot be instantiated."
	},
	{
		HRES_NS_E_WMG_CANNOTQUEUE,
		"HRES_NS_E_WMG_CANNOTQUEUE",
		"The file cannot be queued for seamless playback."
	},
	{
		HRES_NS_E_WMG_PREROLLLICENSEACQUISITIONNOTALLOWED,
		"HRES_NS_E_WMG_PREROLLLICENSEACQUISITIONNOTALLOWED",
		"Windows Media Player cannot download media usage rights for a file in the playlist."
	},
	{
		HRES_NS_E_WMG_UNEXPECTEDPREROLLSTATUS,
		"HRES_NS_E_WMG_UNEXPECTEDPREROLLSTATUS",
		"Windows Media Player encountered an error while trying to queue a file."
	},
	{
		HRES_NS_E_WMG_INVALID_COPP_CERTIFICATE,
		"HRES_NS_E_WMG_INVALID_COPP_CERTIFICATE",
		"Windows Media Player cannot play the protected file. The Player cannot verify that the connection to your video card is secure. Try installing an updated device driver for your video card."
	},
	{
		HRES_NS_E_WMG_COPP_SECURITY_INVALID,
		"HRES_NS_E_WMG_COPP_SECURITY_INVALID",
		"Windows Media Player cannot play the protected file. The Player detected that the connection to your hardware might not be secure."
	},
	{
		HRES_NS_E_WMG_COPP_UNSUPPORTED,
		"HRES_NS_E_WMG_COPP_UNSUPPORTED",
		"Windows Media Player output link protection is unsupported on this system."
	},
	{
		HRES_NS_E_WMG_INVALIDSTATE,
		"HRES_NS_E_WMG_INVALIDSTATE",
		"Operation attempted in an invalid graph state."
	},
	{
		HRES_NS_E_WMG_SINKALREADYEXISTS,
		"HRES_NS_E_WMG_SINKALREADYEXISTS",
		"A renderer cannot be inserted in a stream while one already exists."
	},
	{
		HRES_NS_E_WMG_NOSDKINTERFACE,
		"HRES_NS_E_WMG_NOSDKINTERFACE",
		"The Windows Media SDK interface needed to complete the operation does not exist at this time."
	},
	{
		HRES_NS_E_WMG_NOTALLOUTPUTSRENDERED,
		"HRES_NS_E_WMG_NOTALLOUTPUTSRENDERED",
		"Windows Media Player cannot play a portion of the file because it requires a codec that either could not be downloaded or that is not supported by the Player."
	},
	{
		HRES_NS_E_WMG_FILETRANSFERNOTALLOWED,
		"HRES_NS_E_WMG_FILETRANSFERNOTALLOWED",
		"File transfer streams are not allowed in the standalone Player."
	},
	{
		HRES_NS_E_WMR_UNSUPPORTEDSTREAM,
		"HRES_NS_E_WMR_UNSUPPORTEDSTREAM",
		"Windows Media Player cannot play the file. The Player does not support the format you are trying to play."
	},
	{
		HRES_NS_E_WMR_PINNOTFOUND,
		"HRES_NS_E_WMR_PINNOTFOUND",
		"An operation was attempted on a pin that does not exist in the DirectShow filter graph."
	},
	{
		HRES_NS_E_WMR_WAITINGONFORMATSWITCH,
		"HRES_NS_E_WMR_WAITINGONFORMATSWITCH",
		"Specified operation cannot be completed while waiting for a media format change from the SDK."
	},
	{
		HRES_NS_E_WMR_NOSOURCEFILTER,
		"HRES_NS_E_WMR_NOSOURCEFILTER",
		"Specified operation cannot be completed because the source filter does not exist."
	},
	{
		HRES_NS_E_WMR_PINTYPENOMATCH,
		"HRES_NS_E_WMR_PINTYPENOMATCH",
		"The specified type does not match this pin."
	},
	{
		HRES_NS_E_WMR_NOCALLBACKAVAILABLE,
		"HRES_NS_E_WMR_NOCALLBACKAVAILABLE",
		"The WMR Source Filter does not have a callback available."
	},
	{
		HRES_NS_E_WMR_SAMPLEPROPERTYNOTSET,
		"HRES_NS_E_WMR_SAMPLEPROPERTYNOTSET",
		"The specified property has not been set on this sample."
	},
	{
		HRES_NS_E_WMR_CANNOT_RENDER_BINARY_STREAM,
		"HRES_NS_E_WMR_CANNOT_RENDER_BINARY_STREAM",
		"A plug-in is required to correctly play the file. To determine if the plug-in is available to download, click Web Help."
	},
	{
		HRES_NS_E_WMG_LICENSE_TAMPERED,
		"HRES_NS_E_WMG_LICENSE_TAMPERED",
		"Windows Media Player cannot play the file because your media usage rights are corrupted. If you previously backed up your media usage rights, try restoring them."
	},
	{
		HRES_NS_E_WMR_WILLNOT_RENDER_BINARY_STREAM,
		"HRES_NS_E_WMR_WILLNOT_RENDER_BINARY_STREAM",
		"Windows Media Player cannot play protected files that contain binary streams."
	},
	{
		HRES_NS_E_WMX_UNRECOGNIZED_PLAYLIST_FORMAT,
		"HRES_NS_E_WMX_UNRECOGNIZED_PLAYLIST_FORMAT",
		"Windows Media Player cannot play the playlist because it is not valid."
	},
	{
		HRES_NS_E_ASX_INVALIDFORMAT,
		"HRES_NS_E_ASX_INVALIDFORMAT",
		"Windows Media Player cannot play the playlist because it is not valid."
	},
	{
		HRES_NS_E_ASX_INVALIDVERSION,
		"HRES_NS_E_ASX_INVALIDVERSION",
		"A later version of Windows Media Player might be required to play this playlist."
	},
	{
		HRES_NS_E_ASX_INVALID_REPEAT_BLOCK,
		"HRES_NS_E_ASX_INVALID_REPEAT_BLOCK",
		"The format of a REPEAT loop within the current playlist file is not valid."
	},
	{
		HRES_NS_E_ASX_NOTHING_TO_WRITE,
		"HRES_NS_E_ASX_NOTHING_TO_WRITE",
		"Windows Media Player cannot save the playlist because it does not contain any items."
	},
	{
		HRES_NS_E_URLLIST_INVALIDFORMAT,
		"HRES_NS_E_URLLIST_INVALIDFORMAT",
		"Windows Media Player cannot play the playlist because it is not valid."
	},
	{
		HRES_NS_E_WMX_ATTRIBUTE_DOES_NOT_EXIST,
		"HRES_NS_E_WMX_ATTRIBUTE_DOES_NOT_EXIST",
		"The specified attribute does not exist."
	},
	{
		HRES_NS_E_WMX_ATTRIBUTE_ALREADY_EXISTS,
		"HRES_NS_E_WMX_ATTRIBUTE_ALREADY_EXISTS",
		"The specified attribute already exists."
	},
	{
		HRES_NS_E_WMX_ATTRIBUTE_UNRETRIEVABLE,
		"HRES_NS_E_WMX_ATTRIBUTE_UNRETRIEVABLE",
		"Cannot retrieve the specified attribute."
	},
	{
		HRES_NS_E_WMX_ITEM_DOES_NOT_EXIST,
		"HRES_NS_E_WMX_ITEM_DOES_NOT_EXIST",
		"The specified item does not exist in the current playlist."
	},
	{
		HRES_NS_E_WMX_ITEM_TYPE_ILLEGAL,
		"HRES_NS_E_WMX_ITEM_TYPE_ILLEGAL",
		"Items of the specified type cannot be created within the current playlist."
	},
	{
		HRES_NS_E_WMX_ITEM_UNSETTABLE,
		"HRES_NS_E_WMX_ITEM_UNSETTABLE",
		"The specified item cannot be set in the current playlist."
	},
	{
		HRES_NS_E_WMX_PLAYLIST_EMPTY,
		"HRES_NS_E_WMX_PLAYLIST_EMPTY",
		"Windows Media Player cannot perform the requested action because the playlist does not contain any items."
	},
	{
		HRES_NS_E_MLS_SMARTPLAYLIST_FILTER_NOT_REGISTERED,
		"HRES_NS_E_MLS_SMARTPLAYLIST_FILTER_NOT_REGISTERED",
		"The specified auto playlist contains a filter type that is either not valid or is not installed on this computer."
	},
	{
		HRES_NS_E_WMX_INVALID_FORMAT_OVER_NESTING,
		"HRES_NS_E_WMX_INVALID_FORMAT_OVER_NESTING",
		"Windows Media Player cannot play the file because the associated playlist contains too many nested playlists."
	},
	{
		HRES_NS_E_WMPCORE_NOSOURCEURLSTRING,
		"HRES_NS_E_WMPCORE_NOSOURCEURLSTRING",
		"Windows Media Player cannot find the file. Verify that the path is typed correctly. If it is, the file might not exist in the specified location, or the computer where the file is stored might not be available."
	},
	{
		HRES_NS_E_WMPCORE_COCREATEFAILEDFORGITOBJECT,
		"HRES_NS_E_WMPCORE_COCREATEFAILEDFORGITOBJECT",
		"Failed to create the Global Interface Table."
	},
	{
		HRES_NS_E_WMPCORE_FAILEDTOGETMARSHALLEDEVENTHANDLERINTERFACE,
		"HRES_NS_E_WMPCORE_FAILEDTOGETMARSHALLEDEVENTHANDLERINTERFACE",
		"Failed to get the marshaled graph event handler interface."
	},
	{
		HRES_NS_E_WMPCORE_BUFFERTOOSMALL,
		"HRES_NS_E_WMPCORE_BUFFERTOOSMALL",
		"Buffer is too small for copying media type."
	},
	{
		HRES_NS_E_WMPCORE_UNAVAILABLE,
		"HRES_NS_E_WMPCORE_UNAVAILABLE",
		"The current state of the Player does not allow this operation."
	},
	{
		HRES_NS_E_WMPCORE_INVALIDPLAYLISTMODE,
		"HRES_NS_E_WMPCORE_INVALIDPLAYLISTMODE",
		"The playlist manager does not understand the current play mode (for example, shuffle or normal)."
	},
	{
		HRES_NS_E_WMPCORE_ITEMNOTINPLAYLIST,
		"HRES_NS_E_WMPCORE_ITEMNOTINPLAYLIST",
		"Windows Media Player cannot play the file because it is not in the current playlist."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLISTEMPTY,
		"HRES_NS_E_WMPCORE_PLAYLISTEMPTY",
		"There are no items in the playlist. Add items to the playlist, and then try again."
	},
	{
		HRES_NS_E_WMPCORE_NOBROWSER,
		"HRES_NS_E_WMPCORE_NOBROWSER",
		"The web page cannot be displayed because no web browser is installed on your computer."
	},
	{
		HRES_NS_E_WMPCORE_UNRECOGNIZED_MEDIA_URL,
		"HRES_NS_E_WMPCORE_UNRECOGNIZED_MEDIA_URL",
		"Windows Media Player cannot find the specified file. Verify the path is typed correctly. If it is, the file does not exist in the specified location, or the computer where the file is stored is not available."
	},
	{
		HRES_NS_E_WMPCORE_GRAPH_NOT_IN_LIST,
		"HRES_NS_E_WMPCORE_GRAPH_NOT_IN_LIST",
		"Graph with the specified URL was not found in the prerolled graph list."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_EMPTY_OR_SINGLE_MEDIA,
		"HRES_NS_E_WMPCORE_PLAYLIST_EMPTY_OR_SINGLE_MEDIA",
		"Windows Media Player cannot perform the requested operation because there is only one item in the playlist."
	},
	{
		HRES_NS_E_WMPCORE_ERRORSINKNOTREGISTERED,
		"HRES_NS_E_WMPCORE_ERRORSINKNOTREGISTERED",
		"An error sink was never registered for the calling object."
	},
	{
		HRES_NS_E_WMPCORE_ERRORMANAGERNOTAVAILABLE,
		"HRES_NS_E_WMPCORE_ERRORMANAGERNOTAVAILABLE",
		"The error manager is not available to respond to errors."
	},
	{
		HRES_NS_E_WMPCORE_WEBHELPFAILED,
		"HRES_NS_E_WMPCORE_WEBHELPFAILED",
		"The Web Help URL cannot be opened."
	},
	{
		HRES_NS_E_WMPCORE_MEDIA_ERROR_RESUME_FAILED,
		"HRES_NS_E_WMPCORE_MEDIA_ERROR_RESUME_FAILED",
		"Could not resume playing next item in playlist."
	},
	{
		HRES_NS_E_WMPCORE_NO_REF_IN_ENTRY,
		"HRES_NS_E_WMPCORE_NO_REF_IN_ENTRY",
		"Windows Media Player cannot play the file because the associated playlist does not contain any items or the playlist is not valid."
	},
	{
		HRES_NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_NAME_EMPTY,
		"HRES_NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_NAME_EMPTY",
		"An empty string for playlist attribute name was found."
	},
	{
		HRES_NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_NAME_ILLEGAL,
		"HRES_NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_NAME_ILLEGAL",
		"A playlist attribute name that is not valid was found."
	},
	{
		HRES_NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_VALUE_EMPTY,
		"HRES_NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_VALUE_EMPTY",
		"An empty string for a playlist attribute value was found."
	},
	{
		HRES_NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_VALUE_ILLEGAL,
		"HRES_NS_E_WMPCORE_WMX_LIST_ATTRIBUTE_VALUE_ILLEGAL",
		"An illegal value for a playlist attribute was found."
	},
	{
		HRES_NS_E_WMPCORE_WMX_LIST_ITEM_ATTRIBUTE_NAME_EMPTY,
		"HRES_NS_E_WMPCORE_WMX_LIST_ITEM_ATTRIBUTE_NAME_EMPTY",
		"An empty string for a playlist item attribute name was found."
	},
	{
		HRES_NS_E_WMPCORE_WMX_LIST_ITEM_ATTRIBUTE_NAME_ILLEGAL,
		"HRES_NS_E_WMPCORE_WMX_LIST_ITEM_ATTRIBUTE_NAME_ILLEGAL",
		"An illegal value for a playlist item attribute name was found."
	},
	{
		HRES_NS_E_WMPCORE_WMX_LIST_ITEM_ATTRIBUTE_VALUE_EMPTY,
		"HRES_NS_E_WMPCORE_WMX_LIST_ITEM_ATTRIBUTE_VALUE_EMPTY",
		"An illegal value for a playlist item attribute was found."
	},
	{
		HRES_NS_E_WMPCORE_LIST_ENTRY_NO_REF,
		"HRES_NS_E_WMPCORE_LIST_ENTRY_NO_REF",
		"The playlist does not contain any items."
	},
	{
		HRES_NS_E_WMPCORE_MISNAMED_FILE,
		"HRES_NS_E_WMPCORE_MISNAMED_FILE",
		"Windows Media Player cannot play the file. The file is either corrupted or the Player does not support the format you are trying to play."
	},
	{
		HRES_NS_E_WMPCORE_CODEC_NOT_TRUSTED,
		"HRES_NS_E_WMPCORE_CODEC_NOT_TRUSTED",
		"The codec downloaded for this file does not appear to be properly signed, so it cannot be installed."
	},
	{
		HRES_NS_E_WMPCORE_CODEC_NOT_FOUND,
		"HRES_NS_E_WMPCORE_CODEC_NOT_FOUND",
		"Windows Media Player cannot play the file. One or more codecs required to play the file could not be found."
	},
	{
		HRES_NS_E_WMPCORE_CODEC_DOWNLOAD_NOT_ALLOWED,
		"HRES_NS_E_WMPCORE_CODEC_DOWNLOAD_NOT_ALLOWED",
		"Windows Media Player cannot play the file because a required codec is not installed on your computer. To try downloading the codec, turn on the \"Download codecs automatically\" option."
	},
	{
		HRES_NS_E_WMPCORE_ERROR_DOWNLOADING_PLAYLIST,
		"HRES_NS_E_WMPCORE_ERROR_DOWNLOADING_PLAYLIST",
		"Windows Media Player encountered a problem while downloading the playlist. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMPCORE_FAILED_TO_BUILD_PLAYLIST,
		"HRES_NS_E_WMPCORE_FAILED_TO_BUILD_PLAYLIST",
		"Failed to build the playlist."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_NONE,
		"HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_NONE",
		"Playlist has no alternates to switch into."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_EXHAUSTED,
		"HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_EXHAUSTED",
		"No more playlist alternates available to switch to."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_NAME_NOT_FOUND,
		"HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_NAME_NOT_FOUND",
		"Could not find the name of the alternate playlist to switch into."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_MORPH_FAILED,
		"HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_MORPH_FAILED",
		"Failed to switch to an alternate for this media."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_INIT_FAILED,
		"HRES_NS_E_WMPCORE_PLAYLIST_ITEM_ALTERNATE_INIT_FAILED",
		"Failed to initialize an alternate for the media."
	},
	{
		HRES_NS_E_WMPCORE_MEDIA_ALTERNATE_REF_EMPTY,
		"HRES_NS_E_WMPCORE_MEDIA_ALTERNATE_REF_EMPTY",
		"No URL specified for the roll over Refs in the playlist file."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_NO_EVENT_NAME,
		"HRES_NS_E_WMPCORE_PLAYLIST_NO_EVENT_NAME",
		"Encountered a playlist with no name."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_EVENT_ATTRIBUTE_ABSENT,
		"HRES_NS_E_WMPCORE_PLAYLIST_EVENT_ATTRIBUTE_ABSENT",
		"A required attribute in the event block of the playlist was not found."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_EVENT_EMPTY,
		"HRES_NS_E_WMPCORE_PLAYLIST_EVENT_EMPTY",
		"No items were found in the event block of the playlist."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_STACK_EMPTY,
		"HRES_NS_E_WMPCORE_PLAYLIST_STACK_EMPTY",
		"No playlist was found while returning from a nested playlist."
	},
	{
		HRES_NS_E_WMPCORE_CURRENT_MEDIA_NOT_ACTIVE,
		"HRES_NS_E_WMPCORE_CURRENT_MEDIA_NOT_ACTIVE",
		"The media item is not active currently."
	},
	{
		HRES_NS_E_WMPCORE_USER_CANCEL,
		"HRES_NS_E_WMPCORE_USER_CANCEL",
		"Windows Media Player cannot perform the requested action because you chose to cancel it."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_REPEAT_EMPTY,
		"HRES_NS_E_WMPCORE_PLAYLIST_REPEAT_EMPTY",
		"Windows Media Player encountered a problem with the playlist. The format of the playlist is not valid."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_REPEAT_START_MEDIA_NONE,
		"HRES_NS_E_WMPCORE_PLAYLIST_REPEAT_START_MEDIA_NONE",
		"Media object corresponding to start of a playlist repeat block was not found."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_REPEAT_END_MEDIA_NONE,
		"HRES_NS_E_WMPCORE_PLAYLIST_REPEAT_END_MEDIA_NONE",
		"Media object corresponding to the end of a playlist repeat block was not found."
	},
	{
		HRES_NS_E_WMPCORE_INVALID_PLAYLIST_URL,
		"HRES_NS_E_WMPCORE_INVALID_PLAYLIST_URL",
		"The playlist URL supplied to the playlist manager is not valid."
	},
	{
		HRES_NS_E_WMPCORE_MISMATCHED_RUNTIME,
		"HRES_NS_E_WMPCORE_MISMATCHED_RUNTIME",
		"Windows Media Player cannot play the file because it is corrupted."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_IMPORT_FAILED_NO_ITEMS,
		"HRES_NS_E_WMPCORE_PLAYLIST_IMPORT_FAILED_NO_ITEMS",
		"Windows Media Player cannot add the playlist to the library because the playlist does not contain any items."
	},
	{
		HRES_NS_E_WMPCORE_VIDEO_TRANSFORM_FILTER_INSERTION,
		"HRES_NS_E_WMPCORE_VIDEO_TRANSFORM_FILTER_INSERTION",
		"An error has occurred that could prevent the changing of the video contrast on this media."
	},
	{
		HRES_NS_E_WMPCORE_MEDIA_UNAVAILABLE,
		"HRES_NS_E_WMPCORE_MEDIA_UNAVAILABLE",
		"Windows Media Player cannot play the file. If the file is located on the Internet, connect to the Internet. If the file is located on a removable storage card, insert the storage card."
	},
	{
		HRES_NS_E_WMPCORE_WMX_ENTRYREF_NO_REF,
		"HRES_NS_E_WMPCORE_WMX_ENTRYREF_NO_REF",
		"The playlist contains an ENTRYREF for which no href was parsed. Check the syntax of playlist file."
	},
	{
		HRES_NS_E_WMPCORE_NO_PLAYABLE_MEDIA_IN_PLAYLIST,
		"HRES_NS_E_WMPCORE_NO_PLAYABLE_MEDIA_IN_PLAYLIST",
		"Windows Media Player cannot play any items in the playlist. To find information about the problem, click the Now Playing tab, and then click the icon next to each file in the List pane."
	},
	{
		HRES_NS_E_WMPCORE_PLAYLIST_EMPTY_NESTED_PLAYLIST_SKIPPED_ITEMS,
		"HRES_NS_E_WMPCORE_PLAYLIST_EMPTY_NESTED_PLAYLIST_SKIPPED_ITEMS",
		"Windows Media Player cannot play some or all of the items in the playlist because the playlist is nested."
	},
	{
		HRES_NS_E_WMPCORE_BUSY,
		"HRES_NS_E_WMPCORE_BUSY",
		"Windows Media Player cannot play the file at this time. Try again later."
	},
	{
		HRES_NS_E_WMPCORE_MEDIA_CHILD_PLAYLIST_UNAVAILABLE,
		"HRES_NS_E_WMPCORE_MEDIA_CHILD_PLAYLIST_UNAVAILABLE",
		"There is no child playlist available for this media item at this time."
	},
	{
		HRES_NS_E_WMPCORE_MEDIA_NO_CHILD_PLAYLIST,
		"HRES_NS_E_WMPCORE_MEDIA_NO_CHILD_PLAYLIST",
		"There is no child playlist for this media item."
	},
	{
		HRES_NS_E_WMPCORE_FILE_NOT_FOUND,
		"HRES_NS_E_WMPCORE_FILE_NOT_FOUND",
		"Windows Media Player cannot find the file. The link from the item in the library to its associated digital media file might be broken. To fix the problem, try repairing the link or removing the item from the library."
	},
	{
		HRES_NS_E_WMPCORE_TEMP_FILE_NOT_FOUND,
		"HRES_NS_E_WMPCORE_TEMP_FILE_NOT_FOUND",
		"The temporary file was not found."
	},
	{
		HRES_NS_E_WMDM_REVOKED,
		"HRES_NS_E_WMDM_REVOKED",
		"Windows Media Player cannot sync the file because the device needs to be updated."
	},
	{
		HRES_NS_E_DDRAW_GENERIC,
		"HRES_NS_E_DDRAW_GENERIC",
		"Windows Media Player cannot play the video because there is a problem with your video card."
	},
	{
		HRES_NS_E_DISPLAY_MODE_CHANGE_FAILED,
		"HRES_NS_E_DISPLAY_MODE_CHANGE_FAILED",
		"Windows Media Player failed to change the screen mode for full-screen video playback."
	},
	{
		HRES_NS_E_PLAYLIST_CONTAINS_ERRORS,
		"HRES_NS_E_PLAYLIST_CONTAINS_ERRORS",
		"Windows Media Player cannot play one or more files. For additional information, right-click an item that cannot be played, and then click Error Details."
	},
	{
		HRES_NS_E_CHANGING_PROXY_NAME,
		"HRES_NS_E_CHANGING_PROXY_NAME",
		"Cannot change the proxy name if the proxy setting is not set to custom."
	},
	{
		HRES_NS_E_CHANGING_PROXY_PORT,
		"HRES_NS_E_CHANGING_PROXY_PORT",
		"Cannot change the proxy port if the proxy setting is not set to custom."
	},
	{
		HRES_NS_E_CHANGING_PROXY_EXCEPTIONLIST,
		"HRES_NS_E_CHANGING_PROXY_EXCEPTIONLIST",
		"Cannot change the proxy exception list if the proxy setting is not set to custom."
	},
	{
		HRES_NS_E_CHANGING_PROXYBYPASS,
		"HRES_NS_E_CHANGING_PROXYBYPASS",
		"Cannot change the proxy bypass flag if the proxy setting is not set to custom."
	},
	{
		HRES_NS_E_CHANGING_PROXY_PROTOCOL_NOT_FOUND,
		"HRES_NS_E_CHANGING_PROXY_PROTOCOL_NOT_FOUND",
		"Cannot find the specified protocol."
	},
	{
		HRES_NS_E_GRAPH_NOAUDIOLANGUAGE,
		"HRES_NS_E_GRAPH_NOAUDIOLANGUAGE",
		"Cannot change the language settings. Either the graph has no audio or the audio only supports one language."
	},
	{
		HRES_NS_E_GRAPH_NOAUDIOLANGUAGESELECTED,
		"HRES_NS_E_GRAPH_NOAUDIOLANGUAGESELECTED",
		"The graph has no audio language selected."
	},
	{
		HRES_NS_E_CORECD_NOTAMEDIACD,
		"HRES_NS_E_CORECD_NOTAMEDIACD",
		"This is not a media CD."
	},
	{
		HRES_NS_E_WMPCORE_MEDIA_URL_TOO_LONG,
		"HRES_NS_E_WMPCORE_MEDIA_URL_TOO_LONG",
		"Windows Media Player cannot play the file because the URL is too long."
	},
	{
		HRES_NS_E_WMPFLASH_CANT_FIND_COM_SERVER,
		"HRES_NS_E_WMPFLASH_CANT_FIND_COM_SERVER",
		"To play the selected item, you must install the Macromedia Flash Player. To download the Macromedia Flash Player, go to the Adobe website."
	},
	{
		HRES_NS_E_WMPFLASH_INCOMPATIBLEVERSION,
		"HRES_NS_E_WMPFLASH_INCOMPATIBLEVERSION",
		"To play the selected item, you must install a later version of the Macromedia Flash Player. To download the Macromedia Flash Player, go to the Adobe website."
	},
	{
		HRES_NS_E_WMPOCXGRAPH_IE_DISALLOWS_ACTIVEX_CONTROLS,
		"HRES_NS_E_WMPOCXGRAPH_IE_DISALLOWS_ACTIVEX_CONTROLS",
		"Windows Media Player cannot play the file because your Internet security settings prohibit the use of ActiveX controls."
	},
	{
		HRES_NS_E_NEED_CORE_REFERENCE,
		"HRES_NS_E_NEED_CORE_REFERENCE",
		"The use of this method requires an existing reference to the Player object."
	},
	{
		HRES_NS_E_MEDIACD_READ_ERROR,
		"HRES_NS_E_MEDIACD_READ_ERROR",
		"Windows Media Player cannot play the CD. The disc might be dirty or damaged."
	},
	{
		HRES_NS_E_IE_DISALLOWS_ACTIVEX_CONTROLS,
		"HRES_NS_E_IE_DISALLOWS_ACTIVEX_CONTROLS",
		"Windows Media Player cannot play the file because your Internet security settings prohibit the use of ActiveX controls."
	},
	{
		HRES_NS_E_FLASH_PLAYBACK_NOT_ALLOWED,
		"HRES_NS_E_FLASH_PLAYBACK_NOT_ALLOWED",
		"Flash playback has been turned off in Windows Media Player."
	},
	{
		HRES_NS_E_UNABLE_TO_CREATE_RIP_LOCATION,
		"HRES_NS_E_UNABLE_TO_CREATE_RIP_LOCATION",
		"Windows Media Player cannot rip the CD because a valid rip location cannot be created."
	},
	{
		HRES_NS_E_WMPCORE_SOME_CODECS_MISSING,
		"HRES_NS_E_WMPCORE_SOME_CODECS_MISSING",
		"Windows Media Player cannot play the file because a required codec is not installed on your computer."
	},
	{
		HRES_NS_E_WMP_RIP_FAILED,
		"HRES_NS_E_WMP_RIP_FAILED",
		"Windows Media Player cannot rip one or more tracks from the CD."
	},
	{
		HRES_NS_E_WMP_FAILED_TO_RIP_TRACK,
		"HRES_NS_E_WMP_FAILED_TO_RIP_TRACK",
		"Windows Media Player encountered a problem while ripping the track from the CD. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMP_ERASE_FAILED,
		"HRES_NS_E_WMP_ERASE_FAILED",
		"Windows Media Player encountered a problem while erasing the disc. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMP_FORMAT_FAILED,
		"HRES_NS_E_WMP_FORMAT_FAILED",
		"Windows Media Player encountered a problem while formatting the device. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMP_CANNOT_BURN_NON_LOCAL_FILE,
		"HRES_NS_E_WMP_CANNOT_BURN_NON_LOCAL_FILE",
		"This file cannot be burned to a CD because it is not located on your computer."
	},
	{
		HRES_NS_E_WMP_FILE_TYPE_CANNOT_BURN_TO_AUDIO_CD,
		"HRES_NS_E_WMP_FILE_TYPE_CANNOT_BURN_TO_AUDIO_CD",
		"It is not possible to burn this file type to an audio CD. Windows Media Player can burn the following file types to an audio CD: WMA, MP3, or WAV."
	},
	{
		HRES_NS_E_WMP_FILE_DOES_NOT_FIT_ON_CD,
		"HRES_NS_E_WMP_FILE_DOES_NOT_FIT_ON_CD",
		"This file is too large to fit on a disc."
	},
	{
		HRES_NS_E_WMP_FILE_NO_DURATION,
		"HRES_NS_E_WMP_FILE_NO_DURATION",
		"It is not possible to determine if this file can fit on a disc because Windows Media Player cannot detect the length of the file. Playing the file before burning might enable the Player to detect the file length."
	},
	{
		HRES_NS_E_PDA_FAILED_TO_BURN,
		"HRES_NS_E_PDA_FAILED_TO_BURN",
		"Windows Media Player encountered a problem while burning the file to the disc. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_FAILED_DOWNLOAD_ABORT_BURN,
		"HRES_NS_E_FAILED_DOWNLOAD_ABORT_BURN",
		"Windows Media Player cannot burn the audio CD because some items in the list that you chose to buy could not be downloaded from the online store."
	},
	{
		HRES_NS_E_WMPCORE_DEVICE_DRIVERS_MISSING,
		"HRES_NS_E_WMPCORE_DEVICE_DRIVERS_MISSING",
		"Windows Media Player cannot play the file. Try using Windows Update or Device Manager to update the device drivers for your audio and video cards. For information about using Windows Update or Device Manager, see Windows Help."
	},
	{
		HRES_NS_E_WMPIM_USEROFFLINE,
		"HRES_NS_E_WMPIM_USEROFFLINE",
		"Windows Media Player has detected that you are not connected to the Internet. Connect to the Internet, and then try again."
	},
	{
		HRES_NS_E_WMPIM_USERCANCELED,
		"HRES_NS_E_WMPIM_USERCANCELED",
		"The attempt to connect to the Internet was canceled."
	},
	{
		HRES_NS_E_WMPIM_DIALUPFAILED,
		"HRES_NS_E_WMPIM_DIALUPFAILED",
		"The attempt to connect to the Internet failed."
	},
	{
		HRES_NS_E_WINSOCK_ERROR_STRING,
		"HRES_NS_E_WINSOCK_ERROR_STRING",
		"Windows Media Player has encountered an unknown network error."
	},
	{
		HRES_NS_E_WMPBR_NOLISTENER,
		"HRES_NS_E_WMPBR_NOLISTENER",
		"No window is currently listening to Backup and Restore events."
	},
	{
		HRES_NS_E_WMPBR_BACKUPCANCEL,
		"HRES_NS_E_WMPBR_BACKUPCANCEL",
		"Your media usage rights were not backed up because the backup was canceled."
	},
	{
		HRES_NS_E_WMPBR_RESTORECANCEL,
		"HRES_NS_E_WMPBR_RESTORECANCEL",
		"Your media usage rights were not restored because the restoration was canceled."
	},
	{
		HRES_NS_E_WMPBR_ERRORWITHURL,
		"HRES_NS_E_WMPBR_ERRORWITHURL",
		"An error occurred while backing up or restoring your media usage rights. A required web page cannot be displayed."
	},
	{
		HRES_NS_E_WMPBR_NAMECOLLISION,
		"HRES_NS_E_WMPBR_NAMECOLLISION",
		"Your media usage rights were not backed up because the backup was canceled."
	},
	{
		HRES_NS_E_WMPBR_DRIVE_INVALID,
		"HRES_NS_E_WMPBR_DRIVE_INVALID",
		"Windows Media Player cannot restore your media usage rights from the specified location. Choose another location, and then try again."
	},
	{
		HRES_NS_E_WMPBR_BACKUPRESTOREFAILED,
		"HRES_NS_E_WMPBR_BACKUPRESTOREFAILED",
		"Windows Media Player cannot backup or restore your media usage rights."
	},
	{
		HRES_NS_E_WMP_CONVERT_FILE_FAILED,
		"HRES_NS_E_WMP_CONVERT_FILE_FAILED",
		"Windows Media Player cannot add the file to the library."
	},
	{
		HRES_NS_E_WMP_CONVERT_NO_RIGHTS_ERRORURL,
		"HRES_NS_E_WMP_CONVERT_NO_RIGHTS_ERRORURL",
		"Windows Media Player cannot add the file to the library because the content provider prohibits it. For assistance, contact the company that provided the file."
	},
	{
		HRES_NS_E_WMP_CONVERT_NO_RIGHTS_NOERRORURL,
		"HRES_NS_E_WMP_CONVERT_NO_RIGHTS_NOERRORURL",
		"Windows Media Player cannot add the file to the library because the content provider prohibits it. For assistance, contact the company that provided the file."
	},
	{
		HRES_NS_E_WMP_CONVERT_FILE_CORRUPT,
		"HRES_NS_E_WMP_CONVERT_FILE_CORRUPT",
		"Windows Media Player cannot add the file to the library. The file might not be valid."
	},
	{
		HRES_NS_E_WMP_CONVERT_PLUGIN_UNAVAILABLE_ERRORURL,
		"HRES_NS_E_WMP_CONVERT_PLUGIN_UNAVAILABLE_ERRORURL",
		"Windows Media Player cannot add the file to the library. The plug-in required to add the file is not installed properly. For assistance, click Web Help to display the website of the company that provided the file."
	},
	{
		HRES_NS_E_WMP_CONVERT_PLUGIN_UNAVAILABLE_NOERRORURL,
		"HRES_NS_E_WMP_CONVERT_PLUGIN_UNAVAILABLE_NOERRORURL",
		"Windows Media Player cannot add the file to the library. The plug-in required to add the file is not installed properly. For assistance, contact the company that provided the file."
	},
	{
		HRES_NS_E_WMP_CONVERT_PLUGIN_UNKNOWN_FILE_OWNER,
		"HRES_NS_E_WMP_CONVERT_PLUGIN_UNKNOWN_FILE_OWNER",
		"Windows Media Player cannot add the file to the library. The plug-in required to add the file is not installed properly. For assistance, contact the company that provided the file."
	},
	{
		HRES_NS_E_DVD_DISC_COPY_PROTECT_OUTPUT_NS,
		"HRES_NS_E_DVD_DISC_COPY_PROTECT_OUTPUT_NS",
		"Windows Media Player cannot play this DVD. Try installing an updated driver for your video card or obtaining a newer video card."
	},
	{
		HRES_NS_E_DVD_DISC_COPY_PROTECT_OUTPUT_FAILED,
		"HRES_NS_E_DVD_DISC_COPY_PROTECT_OUTPUT_FAILED",
		"This DVD's resolution exceeds the maximum allowed by your component video outputs. Try reducing your screen resolution to 640 x 480, or turn off analog component outputs and use a VGA connection to your monitor."
	},
	{
		HRES_NS_E_DVD_NO_SUBPICTURE_STREAM,
		"HRES_NS_E_DVD_NO_SUBPICTURE_STREAM",
		"Windows Media Player cannot display subtitles or highlights in DVD menus. Reinstall the DVD decoder or contact the DVD drive manufacturer to obtain an updated decoder."
	},
	{
		HRES_NS_E_DVD_COPY_PROTECT,
		"HRES_NS_E_DVD_COPY_PROTECT",
		"Windows Media Player cannot play this DVD because there is a problem with digital copy protection between your DVD drive, decoder, and video card. Try installing an updated driver for your video card."
	},
	{
		HRES_NS_E_DVD_AUTHORING_PROBLEM,
		"HRES_NS_E_DVD_AUTHORING_PROBLEM",
		"Windows Media Player cannot play the DVD. The disc was created in a manner that the Player does not support."
	},
	{
		HRES_NS_E_DVD_INVALID_DISC_REGION,
		"HRES_NS_E_DVD_INVALID_DISC_REGION",
		"Windows Media Player cannot play the DVD because the disc prohibits playback in your region of the world. You must obtain a disc that is intended for your geographic region."
	},
	{
		HRES_NS_E_DVD_COMPATIBLE_VIDEO_CARD,
		"HRES_NS_E_DVD_COMPATIBLE_VIDEO_CARD",
		"Windows Media Player cannot play the DVD because your video card does not support DVD playback."
	},
	{
		HRES_NS_E_DVD_MACROVISION,
		"HRES_NS_E_DVD_MACROVISION",
		"Windows Media Player cannot play this DVD because it is not possible to turn on analog copy protection on the output display. Try installing an updated driver for your video card."
	},
	{
		HRES_NS_E_DVD_SYSTEM_DECODER_REGION,
		"HRES_NS_E_DVD_SYSTEM_DECODER_REGION",
		"Windows Media Player cannot play the DVD because the region assigned to your DVD drive does not match the region assigned to your DVD decoder."
	},
	{
		HRES_NS_E_DVD_DISC_DECODER_REGION,
		"HRES_NS_E_DVD_DISC_DECODER_REGION",
		"Windows Media Player cannot play the DVD because the disc prohibits playback in your region of the world. You must obtain a disc that is intended for your geographic region."
	},
	{
		HRES_NS_E_DVD_NO_VIDEO_STREAM,
		"HRES_NS_E_DVD_NO_VIDEO_STREAM",
		"Windows Media Player cannot play DVD video. You might need to adjust your Windows display settings. Open display settings in Control Panel, and then try lowering your screen resolution and color quality settings."
	},
	{
		HRES_NS_E_DVD_NO_AUDIO_STREAM,
		"HRES_NS_E_DVD_NO_AUDIO_STREAM",
		"Windows Media Player cannot play DVD audio. Verify that your sound card is set up correctly, and then try again."
	},
	{
		HRES_NS_E_DVD_GRAPH_BUILDING,
		"HRES_NS_E_DVD_GRAPH_BUILDING",
		"Windows Media Player cannot play DVD video. Close any open files and quit any other programs, and then try again. If the problem persists, restart your computer."
	},
	{
		HRES_NS_E_DVD_NO_DECODER,
		"HRES_NS_E_DVD_NO_DECODER",
		"Windows Media Player cannot play the DVD because a compatible DVD decoder is not installed on your computer."
	},
	{
		HRES_NS_E_DVD_PARENTAL,
		"HRES_NS_E_DVD_PARENTAL",
		"Windows Media Player cannot play the scene because it has a parental rating higher than the rating that you are authorized to view."
	},
	{
		HRES_NS_E_DVD_CANNOT_JUMP,
		"HRES_NS_E_DVD_CANNOT_JUMP",
		"Windows Media Player cannot skip to the requested location on the DVD."
	},
	{
		HRES_NS_E_DVD_DEVICE_CONTENTION,
		"HRES_NS_E_DVD_DEVICE_CONTENTION",
		"Windows Media Player cannot play the DVD because it is currently in use by another program. Quit the other program that is using the DVD, and then try again."
	},
	{
		HRES_NS_E_DVD_NO_VIDEO_MEMORY,
		"HRES_NS_E_DVD_NO_VIDEO_MEMORY",
		"Windows Media Player cannot play DVD video. You might need to adjust your Windows display settings. Open display settings in Control Panel, and then try lowering your screen resolution and color quality settings."
	},
	{
		HRES_NS_E_DVD_CANNOT_COPY_PROTECTED,
		"HRES_NS_E_DVD_CANNOT_COPY_PROTECTED",
		"Windows Media Player cannot rip the DVD because it is copy protected."
	},
	{
		HRES_NS_E_DVD_REQUIRED_PROPERTY_NOT_SET,
		"HRES_NS_E_DVD_REQUIRED_PROPERTY_NOT_SET",
		"One of more of the required properties has not been set."
	},
	{
		HRES_NS_E_DVD_INVALID_TITLE_CHAPTER,
		"HRES_NS_E_DVD_INVALID_TITLE_CHAPTER",
		"The specified title and/or chapter number does not exist on this DVD."
	},
	{
		HRES_NS_E_NO_CD_BURNER,
		"HRES_NS_E_NO_CD_BURNER",
		"Windows Media Player cannot burn the files because the Player cannot find a burner. If the burner is connected properly, try using Windows Update to install the latest device driver."
	},
	{
		HRES_NS_E_DEVICE_IS_NOT_READY,
		"HRES_NS_E_DEVICE_IS_NOT_READY",
		"Windows Media Player does not detect storage media in the selected device. Insert storage media into the device, and then try again."
	},
	{
		HRES_NS_E_PDA_UNSUPPORTED_FORMAT,
		"HRES_NS_E_PDA_UNSUPPORTED_FORMAT",
		"Windows Media Player cannot sync this file. The Player might not support the file type."
	},
	{
		HRES_NS_E_NO_PDA,
		"HRES_NS_E_NO_PDA",
		"Windows Media Player does not detect a portable device. Connect your portable device, and then try again."
	},
	{
		HRES_NS_E_PDA_UNSPECIFIED_ERROR,
		"HRES_NS_E_PDA_UNSPECIFIED_ERROR",
		"Windows Media Player encountered an error while communicating with the device. The storage card on the device might be full, the device might be turned off, or the device might not allow playlists or folders to be created on it."
	},
	{
		HRES_NS_E_MEMSTORAGE_BAD_DATA,
		"HRES_NS_E_MEMSTORAGE_BAD_DATA",
		"Windows Media Player encountered an error while burning a CD."
	},
	{
		HRES_NS_E_PDA_FAIL_SELECT_DEVICE,
		"HRES_NS_E_PDA_FAIL_SELECT_DEVICE",
		"Windows Media Player encountered an error while communicating with a portable device or CD drive."
	},
	{
		HRES_NS_E_PDA_FAIL_READ_WAVE_FILE,
		"HRES_NS_E_PDA_FAIL_READ_WAVE_FILE",
		"Windows Media Player cannot open the WAV file."
	},
	{
		HRES_NS_E_IMAPI_LOSSOFSTREAMING,
		"HRES_NS_E_IMAPI_LOSSOFSTREAMING",
		"Windows Media Player failed to burn all the files to the CD. Select a slower recording speed, and then try again."
	},
	{
		HRES_NS_E_PDA_DEVICE_FULL,
		"HRES_NS_E_PDA_DEVICE_FULL",
		"There is not enough storage space on the portable device to complete this operation. Delete some unneeded files on the portable device, and then try again."
	},
	{
		HRES_NS_E_FAIL_LAUNCH_ROXIO_PLUGIN,
		"HRES_NS_E_FAIL_LAUNCH_ROXIO_PLUGIN",
		"Windows Media Player cannot burn the files. Verify that your burner is connected properly, and then try again. If the problem persists, reinstall the Player."
	},
	{
		HRES_NS_E_PDA_DEVICE_FULL_IN_SESSION,
		"HRES_NS_E_PDA_DEVICE_FULL_IN_SESSION",
		"Windows Media Player did not sync some files to the device because there is not enough storage space on the device."
	},
	{
		HRES_NS_E_IMAPI_MEDIUM_INVALIDTYPE,
		"HRES_NS_E_IMAPI_MEDIUM_INVALIDTYPE",
		"The disc in the burner is not valid. Insert a blank disc into the burner, and then try again."
	},
	{
		HRES_NS_E_PDA_MANUALDEVICE,
		"HRES_NS_E_PDA_MANUALDEVICE",
		"Windows Media Player cannot perform the requested action because the device does not support sync."
	},
	{
		HRES_NS_E_PDA_PARTNERSHIPNOTEXIST,
		"HRES_NS_E_PDA_PARTNERSHIPNOTEXIST",
		"To perform the requested action, you must first set up sync with the device."
	},
	{
		HRES_NS_E_PDA_CANNOT_CREATE_ADDITIONAL_SYNC_RELATIONSHIP,
		"HRES_NS_E_PDA_CANNOT_CREATE_ADDITIONAL_SYNC_RELATIONSHIP",
		"You have already created sync partnerships with 16 devices. To create a new sync partnership, you must first end an existing partnership."
	},
	{
		HRES_NS_E_PDA_NO_TRANSCODE_OF_DRM,
		"HRES_NS_E_PDA_NO_TRANSCODE_OF_DRM",
		"Windows Media Player cannot sync the file because protected files cannot be converted to the required quality level or file format."
	},
	{
		HRES_NS_E_PDA_TRANSCODECACHEFULL,
		"HRES_NS_E_PDA_TRANSCODECACHEFULL",
		"The folder that stores converted files is full. Either empty the folder or increase its size, and then try again."
	},
	{
		HRES_NS_E_PDA_TOO_MANY_FILE_COLLISIONS,
		"HRES_NS_E_PDA_TOO_MANY_FILE_COLLISIONS",
		"There are too many files with the same name in the folder on the device. Change the file name or sync to a different folder."
	},
	{
		HRES_NS_E_PDA_CANNOT_TRANSCODE,
		"HRES_NS_E_PDA_CANNOT_TRANSCODE",
		"Windows Media Player cannot convert the file to the format required by the device."
	},
	{
		HRES_NS_E_PDA_TOO_MANY_FILES_IN_DIRECTORY,
		"HRES_NS_E_PDA_TOO_MANY_FILES_IN_DIRECTORY",
		"You have reached the maximum number of files your device allows in a folder. If your device supports playback from subfolders, try creating subfolders on the device and storing some files in them."
	},
	{
		HRES_NS_E_PROCESSINGSHOWSYNCWIZARD,
		"HRES_NS_E_PROCESSINGSHOWSYNCWIZARD",
		"Windows Media Player is already trying to start the Device Setup Wizard."
	},
	{
		HRES_NS_E_PDA_TRANSCODE_NOT_PERMITTED,
		"HRES_NS_E_PDA_TRANSCODE_NOT_PERMITTED",
		"Windows Media Player cannot convert this file format. If an updated version of the codec used to compress this file is available, install it and then try to sync the file again."
	},
	{
		HRES_NS_E_PDA_INITIALIZINGDEVICES,
		"HRES_NS_E_PDA_INITIALIZINGDEVICES",
		"Windows Media Player is busy setting up devices. Try again later."
	},
	{
		HRES_NS_E_PDA_OBSOLETE_SP,
		"HRES_NS_E_PDA_OBSOLETE_SP",
		"Your device is using an outdated driver that is no longer supported by Windows Media Player. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_PDA_TITLE_COLLISION,
		"HRES_NS_E_PDA_TITLE_COLLISION",
		"Windows Media Player cannot sync the file because a file with the same name already exists on the device. Change the file name or try to sync the file to a different folder."
	},
	{
		HRES_NS_E_PDA_DEVICESUPPORTDISABLED,
		"HRES_NS_E_PDA_DEVICESUPPORTDISABLED",
		"Automatic and manual sync have been turned off temporarily. To sync to a device, restart Windows Media Player."
	},
	{
		HRES_NS_E_PDA_NO_LONGER_AVAILABLE,
		"HRES_NS_E_PDA_NO_LONGER_AVAILABLE",
		"This device is not available. Connect the device to the computer, and then try again."
	},
	{
		HRES_NS_E_PDA_ENCODER_NOT_RESPONDING,
		"HRES_NS_E_PDA_ENCODER_NOT_RESPONDING",
		"Windows Media Player cannot sync the file because an error occurred while converting the file to another quality level or format. If the problem persists, remove the file from the list of files to sync."
	},
	{
		HRES_NS_E_PDA_CANNOT_SYNC_FROM_LOCATION,
		"HRES_NS_E_PDA_CANNOT_SYNC_FROM_LOCATION",
		"Windows Media Player cannot sync the file to your device. The file might be stored in a location that is not supported. Copy the file from its current location to your hard disk, add it to your library, and then try to sync the file again."
	},
	{
		HRES_NS_E_WMP_PROTOCOL_PROBLEM,
		"HRES_NS_E_WMP_PROTOCOL_PROBLEM",
		"Windows Media Player cannot open the specified URL. Verify that the Player is configured to use all available protocols, and then try again."
	},
	{
		HRES_NS_E_WMP_NO_DISK_SPACE,
		"HRES_NS_E_WMP_NO_DISK_SPACE",
		"Windows Media Player cannot perform the requested action because there is not enough storage space on your computer. Delete some unneeded files on your hard disk, and then try again."
	},
	{
		HRES_NS_E_WMP_LOGON_FAILURE,
		"HRES_NS_E_WMP_LOGON_FAILURE",
		"The server denied access to the file. Verify that you are using the correct user name and password."
	},
	{
		HRES_NS_E_WMP_CANNOT_FIND_FILE,
		"HRES_NS_E_WMP_CANNOT_FIND_FILE",
		"Windows Media Player cannot find the file. If you are trying to play, burn, or sync an item that is in your library, the item might point to a file that has been moved, renamed, or deleted."
	},
	{
		HRES_NS_E_WMP_SERVER_INACCESSIBLE,
		"HRES_NS_E_WMP_SERVER_INACCESSIBLE",
		"Windows Media Player cannot connect to the server. The server name might not be correct, the server might not be available, or your proxy settings might not be correct."
	},
	{
		HRES_NS_E_WMP_UNSUPPORTED_FORMAT,
		"HRES_NS_E_WMP_UNSUPPORTED_FORMAT",
		"Windows Media Player cannot play the file. The Player might not support the file type or might not support the codec that was used to compress the file."
	},
	{
		HRES_NS_E_WMP_DSHOW_UNSUPPORTED_FORMAT,
		"HRES_NS_E_WMP_DSHOW_UNSUPPORTED_FORMAT",
		"Windows Media Player cannot play the file. The Player might not support the file type or a required codec might not be installed on your computer."
	},
	{
		HRES_NS_E_WMP_PLAYLIST_EXISTS,
		"HRES_NS_E_WMP_PLAYLIST_EXISTS",
		"Windows Media Player cannot create the playlist because the name already exists. Type a different playlist name."
	},
	{
		HRES_NS_E_WMP_NONMEDIA_FILES,
		"HRES_NS_E_WMP_NONMEDIA_FILES",
		"Windows Media Player cannot delete the playlist because it contains items that are not digital media files. Any digital media files in the playlist were deleted."
	},
	{
		HRES_NS_E_WMP_INVALID_ASX,
		"HRES_NS_E_WMP_INVALID_ASX",
		"The playlist cannot be opened because it is stored in a shared folder on another computer. If possible, move the playlist to the playlists folder on your computer."
	},
	{
		HRES_NS_E_WMP_ALREADY_IN_USE,
		"HRES_NS_E_WMP_ALREADY_IN_USE",
		"Windows Media Player is already in use. Stop playing any items, close all Player dialog boxes, and then try again."
	},
	{
		HRES_NS_E_WMP_IMAPI_FAILURE,
		"HRES_NS_E_WMP_IMAPI_FAILURE",
		"Windows Media Player encountered an error while burning. Verify that the burner is connected properly and that the disc is clean and not damaged."
	},
	{
		HRES_NS_E_WMP_WMDM_FAILURE,
		"HRES_NS_E_WMP_WMDM_FAILURE",
		"Windows Media Player has encountered an unknown error with your portable device. Reconnect your portable device, and then try again."
	},
	{
		HRES_NS_E_WMP_CODEC_NEEDED_WITH_4CC,
		"HRES_NS_E_WMP_CODEC_NEEDED_WITH_4CC",
		"A codec is required to play this file. To determine if this codec is available to download from the web, click Web Help."
	},
	{
		HRES_NS_E_WMP_CODEC_NEEDED_WITH_FORMATTAG,
		"HRES_NS_E_WMP_CODEC_NEEDED_WITH_FORMATTAG",
		"An audio codec is needed to play this file. To determine if this codec is available to download from the web, click Web Help."
	},
	{
		HRES_NS_E_WMP_MSSAP_NOT_AVAILABLE,
		"HRES_NS_E_WMP_MSSAP_NOT_AVAILABLE",
		"To play the file, you must install the latest Windows service pack. To install the service pack from the Windows Update website, click Web Help."
	},
	{
		HRES_NS_E_WMP_WMDM_INTERFACEDEAD,
		"HRES_NS_E_WMP_WMDM_INTERFACEDEAD",
		"Windows Media Player no longer detects a portable device. Reconnect your portable device, and then try again."
	},
	{
		HRES_NS_E_WMP_WMDM_NOTCERTIFIED,
		"HRES_NS_E_WMP_WMDM_NOTCERTIFIED",
		"Windows Media Player cannot sync the file because the portable device does not support protected files."
	},
	{
		HRES_NS_E_WMP_WMDM_LICENSE_NOTEXIST,
		"HRES_NS_E_WMP_WMDM_LICENSE_NOTEXIST",
		"This file does not have sync rights. If you obtained this file from an online store, go to the online store to get sync rights."
	},
	{
		HRES_NS_E_WMP_WMDM_LICENSE_EXPIRED,
		"HRES_NS_E_WMP_WMDM_LICENSE_EXPIRED",
		"Windows Media Player cannot sync the file because the sync rights have expired. Go to the content provider's online store to get new sync rights."
	},
	{
		HRES_NS_E_WMP_WMDM_BUSY,
		"HRES_NS_E_WMP_WMDM_BUSY",
		"The portable device is already in use. Wait until the current task finishes or quit other programs that might be using the portable device, and then try again."
	},
	{
		HRES_NS_E_WMP_WMDM_NORIGHTS,
		"HRES_NS_E_WMP_WMDM_NORIGHTS",
		"Windows Media Player cannot sync the file because the content provider or device prohibits it. You might be able to resolve this problem by going to the content provider's online store to get sync rights."
	},
	{
		HRES_NS_E_WMP_WMDM_INCORRECT_RIGHTS,
		"HRES_NS_E_WMP_WMDM_INCORRECT_RIGHTS",
		"The content provider has not granted you the right to sync this file. Go to the content provider's online store to get sync rights."
	},
	{
		HRES_NS_E_WMP_IMAPI_GENERIC,
		"HRES_NS_E_WMP_IMAPI_GENERIC",
		"Windows Media Player cannot burn the files to the CD. Verify that the disc is clean and not damaged. If necessary, select a slower recording speed or try a different brand of blank discs."
	},
	{
		HRES_NS_E_WMP_IMAPI_DEVICE_NOTPRESENT,
		"HRES_NS_E_WMP_IMAPI_DEVICE_NOTPRESENT",
		"Windows Media Player cannot burn the files. Verify that the burner is connected properly, and then try again."
	},
	{
		HRES_NS_E_WMP_IMAPI_DEVICE_BUSY,
		"HRES_NS_E_WMP_IMAPI_DEVICE_BUSY",
		"Windows Media Player cannot burn the files. Verify that the burner is connected properly and that the disc is clean and not damaged. If the burner is already in use, wait until the current task finishes or quit other programs that might be using the burner."
	},
	{
		HRES_NS_E_WMP_IMAPI_LOSS_OF_STREAMING,
		"HRES_NS_E_WMP_IMAPI_LOSS_OF_STREAMING",
		"Windows Media Player cannot burn the files to the CD."
	},
	{
		HRES_NS_E_WMP_SERVER_UNAVAILABLE,
		"HRES_NS_E_WMP_SERVER_UNAVAILABLE",
		"Windows Media Player cannot play the file. The server might not be available or there might be a problem with your network or firewall settings."
	},
	{
		HRES_NS_E_WMP_FILE_OPEN_FAILED,
		"HRES_NS_E_WMP_FILE_OPEN_FAILED",
		"Windows Media Player encountered a problem while playing the file. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMP_VERIFY_ONLINE,
		"HRES_NS_E_WMP_VERIFY_ONLINE",
		"Windows Media Player must connect to the Internet to verify the file's media usage rights. Connect to the Internet, and then try again."
	},
	{
		HRES_NS_E_WMP_SERVER_NOT_RESPONDING,
		"HRES_NS_E_WMP_SERVER_NOT_RESPONDING",
		"Windows Media Player cannot play the file because a network error occurred. The server might not be available. Verify that you are connected to the network and that your proxy settings are correct."
	},
	{
		HRES_NS_E_WMP_DRM_CORRUPT_BACKUP,
		"HRES_NS_E_WMP_DRM_CORRUPT_BACKUP",
		"Windows Media Player cannot restore your media usage rights because it could not find any backed up rights on your computer."
	},
	{
		HRES_NS_E_WMP_DRM_LICENSE_SERVER_UNAVAILABLE,
		"HRES_NS_E_WMP_DRM_LICENSE_SERVER_UNAVAILABLE",
		"Windows Media Player cannot download media usage rights because the server is not available (for example, the server might be busy or not online)."
	},
	{
		HRES_NS_E_WMP_NETWORK_FIREWALL,
		"HRES_NS_E_WMP_NETWORK_FIREWALL",
		"Windows Media Player cannot play the file. A network firewall might be preventing the Player from opening the file by using the UDP transport protocol. If you typed a URL in the Open URL dialog box, try using a different transport protocol (for example, \"http:\")."
	},
	{
		HRES_NS_E_WMP_NO_REMOVABLE_MEDIA,
		"HRES_NS_E_WMP_NO_REMOVABLE_MEDIA",
		"Insert the removable media, and then try again."
	},
	{
		HRES_NS_E_WMP_PROXY_CONNECT_TIMEOUT,
		"HRES_NS_E_WMP_PROXY_CONNECT_TIMEOUT",
		"Windows Media Player cannot play the file because the proxy server is not responding. The proxy server might be temporarily unavailable or your Player proxy settings might not be valid."
	},
	{
		HRES_NS_E_WMP_NEED_UPGRADE,
		"HRES_NS_E_WMP_NEED_UPGRADE",
		"To play the file, you might need to install a later version of Windows Media Player. On the Help menu, click Check for Updates, and then follow the instructions. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMP_AUDIO_HW_PROBLEM,
		"HRES_NS_E_WMP_AUDIO_HW_PROBLEM",
		"Windows Media Player cannot play the file because there is a problem with your sound device. There might not be a sound device installed on your computer, it might be in use by another program, or it might not be functioning properly."
	},
	{
		HRES_NS_E_WMP_INVALID_PROTOCOL,
		"HRES_NS_E_WMP_INVALID_PROTOCOL",
		"Windows Media Player cannot play the file because the specified protocol is not supported. If you typed a URL in the Open URL dialog box, try using a different transport protocol (for example, \"http:\" or \"rtsp:\")."
	},
	{
		HRES_NS_E_WMP_INVALID_LIBRARY_ADD,
		"HRES_NS_E_WMP_INVALID_LIBRARY_ADD",
		"Windows Media Player cannot add the file to the library because the file format is not supported."
	},
	{
		HRES_NS_E_WMP_MMS_NOT_SUPPORTED,
		"HRES_NS_E_WMP_MMS_NOT_SUPPORTED",
		"Windows Media Player cannot play the file because the specified protocol is not supported. If you typed a URL in the Open URL dialog box, try using a different transport protocol (for example, \"mms:\")."
	},
	{
		HRES_NS_E_WMP_NO_PROTOCOLS_SELECTED,
		"HRES_NS_E_WMP_NO_PROTOCOLS_SELECTED",
		"Windows Media Player cannot play the file because there are no streaming protocols selected. Select one or more protocols, and then try again."
	},
	{
		HRES_NS_E_WMP_GOFULLSCREEN_FAILED,
		"HRES_NS_E_WMP_GOFULLSCREEN_FAILED",
		"Windows Media Player cannot switch to Full Screen. You might need to adjust your Windows display settings. Open display settings in Control Panel, and then try setting Hardware acceleration to Full."
	},
	{
		HRES_NS_E_WMP_NETWORK_ERROR,
		"HRES_NS_E_WMP_NETWORK_ERROR",
		"Windows Media Player cannot play the file because a network error occurred. The server might not be available (for example, the server is busy or not online) or you might not be connected to the network."
	},
	{
		HRES_NS_E_WMP_CONNECT_TIMEOUT,
		"HRES_NS_E_WMP_CONNECT_TIMEOUT",
		"Windows Media Player cannot play the file because the server is not responding. Verify that you are connected to the network, and then try again later."
	},
	{
		HRES_NS_E_WMP_MULTICAST_DISABLED,
		"HRES_NS_E_WMP_MULTICAST_DISABLED",
		"Windows Media Player cannot play the file because the multicast protocol is not enabled. On the Tools menu, click Options, click the Network tab, and then select the Multicast check box. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMP_SERVER_DNS_TIMEOUT,
		"HRES_NS_E_WMP_SERVER_DNS_TIMEOUT",
		"Windows Media Player cannot play the file because a network problem occurred. Verify that you are connected to the network, and then try again later."
	},
	{
		HRES_NS_E_WMP_PROXY_NOT_FOUND,
		"HRES_NS_E_WMP_PROXY_NOT_FOUND",
		"Windows Media Player cannot play the file because the network proxy server cannot be found. Verify that your proxy settings are correct, and then try again."
	},
	{
		HRES_NS_E_WMP_TAMPERED_CONTENT,
		"HRES_NS_E_WMP_TAMPERED_CONTENT",
		"Windows Media Player cannot play the file because it is corrupted."
	},
	{
		HRES_NS_E_WMP_OUTOFMEMORY,
		"HRES_NS_E_WMP_OUTOFMEMORY",
		"Your computer is running low on memory. Quit other programs, and then try again."
	},
	{
		HRES_NS_E_WMP_AUDIO_CODEC_NOT_INSTALLED,
		"HRES_NS_E_WMP_AUDIO_CODEC_NOT_INSTALLED",
		"Windows Media Player cannot play, burn, rip, or sync the file because a required audio codec is not installed on your computer."
	},
	{
		HRES_NS_E_WMP_VIDEO_CODEC_NOT_INSTALLED,
		"HRES_NS_E_WMP_VIDEO_CODEC_NOT_INSTALLED",
		"Windows Media Player cannot play the file because the required video codec is not installed on your computer."
	},
	{
		HRES_NS_E_WMP_IMAPI_DEVICE_INVALIDTYPE,
		"HRES_NS_E_WMP_IMAPI_DEVICE_INVALIDTYPE",
		"Windows Media Player cannot burn the files. If the burner is busy, wait for the current task to finish. If necessary, verify that the burner is connected properly and that you have installed the latest device driver."
	},
	{
		HRES_NS_E_WMP_DRM_DRIVER_AUTH_FAILURE,
		"HRES_NS_E_WMP_DRM_DRIVER_AUTH_FAILURE",
		"Windows Media Player cannot play the protected file because there is a problem with your sound device. Try installing a new device driver or use a different sound device."
	},
	{
		HRES_NS_E_WMP_NETWORK_RESOURCE_FAILURE,
		"HRES_NS_E_WMP_NETWORK_RESOURCE_FAILURE",
		"Windows Media Player encountered a network error. Restart the Player."
	},
	{
		HRES_NS_E_WMP_UPGRADE_APPLICATION,
		"HRES_NS_E_WMP_UPGRADE_APPLICATION",
		"Windows Media Player is not installed properly. Reinstall the Player."
	},
	{
		HRES_NS_E_WMP_UNKNOWN_ERROR,
		"HRES_NS_E_WMP_UNKNOWN_ERROR",
		"Windows Media Player encountered an unknown error. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMP_INVALID_KEY,
		"HRES_NS_E_WMP_INVALID_KEY",
		"Windows Media Player cannot play the file because the required codec is not valid."
	},
	{
		HRES_NS_E_WMP_CD_ANOTHER_USER,
		"HRES_NS_E_WMP_CD_ANOTHER_USER",
		"The CD drive is in use by another user. Wait for the task to complete, and then try again."
	},
	{
		HRES_NS_E_WMP_DRM_NEEDS_AUTHORIZATION,
		"HRES_NS_E_WMP_DRM_NEEDS_AUTHORIZATION",
		"Windows Media Player cannot play, sync, or burn the protected file because a problem occurred with the Windows Media Digital Rights Management (DRM) system. You might need to connect to the Internet to update your DRM components. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMP_BAD_DRIVER,
		"HRES_NS_E_WMP_BAD_DRIVER",
		"Windows Media Player cannot play the file because there might be a problem with your sound or video device. Try installing an updated device driver."
	},
	{
		HRES_NS_E_WMP_ACCESS_DENIED,
		"HRES_NS_E_WMP_ACCESS_DENIED",
		"Windows Media Player cannot access the file. The file might be in use, you might not have access to the computer where the file is stored, or your proxy settings might not be correct."
	},
	{
		HRES_NS_E_WMP_LICENSE_RESTRICTS,
		"HRES_NS_E_WMP_LICENSE_RESTRICTS",
		"The content provider prohibits this action. Go to the content provider's online store to get new media usage rights."
	},
	{
		HRES_NS_E_WMP_INVALID_REQUEST,
		"HRES_NS_E_WMP_INVALID_REQUEST",
		"Windows Media Player cannot perform the requested action at this time."
	},
	{
		HRES_NS_E_WMP_CD_STASH_NO_SPACE,
		"HRES_NS_E_WMP_CD_STASH_NO_SPACE",
		"Windows Media Player cannot burn the files because there is not enough free disk space to store the temporary files. Delete some unneeded files on your hard disk, and then try again."
	},
	{
		HRES_NS_E_WMP_DRM_NEW_HARDWARE,
		"HRES_NS_E_WMP_DRM_NEW_HARDWARE",
		"Your media usage rights have become corrupted or are no longer valid. This might happen if you have replaced hardware components in your computer."
	},
	{
		HRES_NS_E_WMP_DRM_INVALID_SIG,
		"HRES_NS_E_WMP_DRM_INVALID_SIG",
		"The required Windows Media Digital Rights Management (DRM) component cannot be validated. You might be able resolve the problem by reinstalling the Player."
	},
	{
		HRES_NS_E_WMP_DRM_CANNOT_RESTORE,
		"HRES_NS_E_WMP_DRM_CANNOT_RESTORE",
		"You have exceeded your restore limit for the day. Try restoring your media usage rights tomorrow."
	},
	{
		HRES_NS_E_WMP_BURN_DISC_OVERFLOW,
		"HRES_NS_E_WMP_BURN_DISC_OVERFLOW",
		"Some files might not fit on the CD. The required space cannot be calculated accurately because some files might be missing duration information. To ensure the calculation is accurate, play the files that are missing duration information."
	},
	{
		HRES_NS_E_WMP_DRM_GENERIC_LICENSE_FAILURE,
		"HRES_NS_E_WMP_DRM_GENERIC_LICENSE_FAILURE",
		"Windows Media Player cannot verify the file's media usage rights. If you obtained this file from an online store, go to the online store to get the necessary rights."
	},
	{
		HRES_NS_E_WMP_DRM_NO_SECURE_CLOCK,
		"HRES_NS_E_WMP_DRM_NO_SECURE_CLOCK",
		"It is not possible to sync because this device's internal clock is not set correctly. To set the clock, select the option to set the device clock on the Privacy tab of the Options dialog box, connect to the Internet, and then sync the device again. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_WMP_DRM_NO_RIGHTS,
		"HRES_NS_E_WMP_DRM_NO_RIGHTS",
		"Windows Media Player cannot play, burn, rip, or sync the protected file because you do not have the appropriate rights."
	},
	{
		HRES_NS_E_WMP_DRM_INDIV_FAILED,
		"HRES_NS_E_WMP_DRM_INDIV_FAILED",
		"Windows Media Player encountered an error during upgrade."
	},
	{
		HRES_NS_E_WMP_SERVER_NONEWCONNECTIONS,
		"HRES_NS_E_WMP_SERVER_NONEWCONNECTIONS",
		"Windows Media Player cannot connect to the server because it is not accepting any new connections. This could be because it has reached its maximum connection limit. Please try again later."
	},
	{
		HRES_NS_E_WMP_MULTIPLE_ERROR_IN_PLAYLIST,
		"HRES_NS_E_WMP_MULTIPLE_ERROR_IN_PLAYLIST",
		"A number of queued files cannot be played. To find information about the problem, click the Now Playing tab, and then click the icon next to each file in the List pane."
	},
	{
		HRES_NS_E_WMP_IMAPI2_ERASE_FAIL,
		"HRES_NS_E_WMP_IMAPI2_ERASE_FAIL",
		"Windows Media Player encountered an error while erasing the rewritable CD or DVD. Verify that the CD or DVD burner is connected properly and that the disc is clean and not damaged."
	},
	{
		HRES_NS_E_WMP_IMAPI2_ERASE_DEVICE_BUSY,
		"HRES_NS_E_WMP_IMAPI2_ERASE_DEVICE_BUSY",
		"Windows Media Player cannot erase the rewritable CD or DVD. Verify that the CD or DVD burner is connected properly and that the disc is clean and not damaged. If the burner is already in use, wait until the current task finishes or quit other programs that might be using the burner."
	},
	{
		HRES_NS_E_WMP_DRM_COMPONENT_FAILURE,
		"HRES_NS_E_WMP_DRM_COMPONENT_FAILURE",
		"A Windows Media Digital Rights Management (DRM) component encountered a problem. If you are trying to use a file that you obtained from an online store, try going to the online store and getting the appropriate usage rights."
	},
	{
		HRES_NS_E_WMP_DRM_NO_DEVICE_CERT,
		"HRES_NS_E_WMP_DRM_NO_DEVICE_CERT",
		"It is not possible to obtain device's certificate. Please contact the device manufacturer for a firmware update or for other steps to resolve this problem."
	},
	{
		HRES_NS_E_WMP_SERVER_SECURITY_ERROR,
		"HRES_NS_E_WMP_SERVER_SECURITY_ERROR",
		"Windows Media Player encountered an error when connecting to the server. The security information from the server could not be validated."
	},
	{
		HRES_NS_E_WMP_AUDIO_DEVICE_LOST,
		"HRES_NS_E_WMP_AUDIO_DEVICE_LOST",
		"An audio device was disconnected or reconfigured. Verify that the audio device is connected, and then try to play the item again."
	},
	{
		HRES_NS_E_WMP_IMAPI_MEDIA_INCOMPATIBLE,
		"HRES_NS_E_WMP_IMAPI_MEDIA_INCOMPATIBLE",
		"Windows Media Player could not complete burning because the disc is not compatible with your drive. Try inserting a different kind of recordable media or use a disc that supports a write speed that is compatible with your drive."
	},
	{
		HRES_NS_E_SYNCWIZ_DEVICE_FULL,
		"HRES_NS_E_SYNCWIZ_DEVICE_FULL",
		"Windows Media Player cannot save the sync settings because your device is full. Delete some unneeded files on your device and then try again."
	},
	{
		HRES_NS_E_SYNCWIZ_CANNOT_CHANGE_SETTINGS,
		"HRES_NS_E_SYNCWIZ_CANNOT_CHANGE_SETTINGS",
		"It is not possible to change sync settings at this time. Try again later."
	},
	{
		HRES_NS_E_TRANSCODE_DELETECACHEERROR,
		"HRES_NS_E_TRANSCODE_DELETECACHEERROR",
		"Windows Media Player cannot delete these files currently. If the Player is synchronizing, wait until it is complete and then try again."
	},
	{
		HRES_NS_E_CD_NO_BUFFERS_READ,
		"HRES_NS_E_CD_NO_BUFFERS_READ",
		"Windows Media Player could not use digital mode to read the CD. The Player has automatically switched the CD drive to analog mode. To switch back to digital mode, use the Devices tab. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_CD_EMPTY_TRACK_QUEUE,
		"HRES_NS_E_CD_EMPTY_TRACK_QUEUE",
		"No CD track was specified for playback."
	},
	{
		HRES_NS_E_CD_NO_READER,
		"HRES_NS_E_CD_NO_READER",
		"The CD filter was not able to create the CD reader."
	},
	{
		HRES_NS_E_CD_ISRC_INVALID,
		"HRES_NS_E_CD_ISRC_INVALID",
		"Invalid ISRC code."
	},
	{
		HRES_NS_E_CD_MEDIA_CATALOG_NUMBER_INVALID,
		"HRES_NS_E_CD_MEDIA_CATALOG_NUMBER_INVALID",
		"Invalid Media Catalog Number."
	},
	{
		HRES_NS_E_SLOW_READ_DIGITAL_WITH_ERRORCORRECTION,
		"HRES_NS_E_SLOW_READ_DIGITAL_WITH_ERRORCORRECTION",
		"Windows Media Player cannot play audio CDs correctly because the CD drive is slow and error correction is turned on. To increase performance, turn off playback error correction for this drive."
	},
	{
		HRES_NS_E_CD_SPEEDDETECT_NOT_ENOUGH_READS,
		"HRES_NS_E_CD_SPEEDDETECT_NOT_ENOUGH_READS",
		"Windows Media Player cannot estimate the CD drive's playback speed because the CD track is too short."
	},
	{
		HRES_NS_E_CD_QUEUEING_DISABLED,
		"HRES_NS_E_CD_QUEUEING_DISABLED",
		"Cannot queue the CD track because queuing is not enabled."
	},
	{
		HRES_NS_E_WMP_DRM_ACQUIRING_LICENSE,
		"HRES_NS_E_WMP_DRM_ACQUIRING_LICENSE",
		"Windows Media Player cannot download additional media usage rights until the current download is complete."
	},
	{
		HRES_NS_E_WMP_DRM_LICENSE_EXPIRED,
		"HRES_NS_E_WMP_DRM_LICENSE_EXPIRED",
		"The media usage rights for this file have expired or are no longer valid. If you obtained the file from an online store, sign in to the store, and then try again."
	},
	{
		HRES_NS_E_WMP_DRM_LICENSE_NOTACQUIRED,
		"HRES_NS_E_WMP_DRM_LICENSE_NOTACQUIRED",
		"Windows Media Player cannot download the media usage rights for the file. If you obtained the file from an online store, sign in to the store, and then try again."
	},
	{
		HRES_NS_E_WMP_DRM_LICENSE_NOTENABLED,
		"HRES_NS_E_WMP_DRM_LICENSE_NOTENABLED",
		"The media usage rights for this file are not yet valid. To see when they will become valid, right-click the file in the library, click Properties, and then click the Media Usage Rights tab."
	},
	{
		HRES_NS_E_WMP_DRM_LICENSE_UNUSABLE,
		"HRES_NS_E_WMP_DRM_LICENSE_UNUSABLE",
		"The media usage rights for this file are not valid. If you obtained this file from an online store, contact the store for assistance."
	},
	{
		HRES_NS_E_WMP_DRM_LICENSE_CONTENT_REVOKED,
		"HRES_NS_E_WMP_DRM_LICENSE_CONTENT_REVOKED",
		"The content provider has revoked the media usage rights for this file. If you obtained this file from an online store, ask the store if a new version of the file is available."
	},
	{
		HRES_NS_E_WMP_DRM_LICENSE_NOSAP,
		"HRES_NS_E_WMP_DRM_LICENSE_NOSAP",
		"The media usage rights for this file require a feature that is not supported in your current version of Windows Media Player or your current version of Windows. Try installing the latest version of the Player. If you obtained this file from an online store, contact the store for further assistance."
	},
	{
		HRES_NS_E_WMP_DRM_UNABLE_TO_ACQUIRE_LICENSE,
		"HRES_NS_E_WMP_DRM_UNABLE_TO_ACQUIRE_LICENSE",
		"Windows Media Player cannot download media usage rights at this time. Try again later."
	},
	{
		HRES_NS_E_WMP_LICENSE_REQUIRED,
		"HRES_NS_E_WMP_LICENSE_REQUIRED",
		"Windows Media Player cannot play, burn, or sync the file because the media usage rights are missing. If you obtained the file from an online store, sign in to the store, and then try again."
	},
	{
		HRES_NS_E_WMP_PROTECTED_CONTENT,
		"HRES_NS_E_WMP_PROTECTED_CONTENT",
		"Windows Media Player cannot play, burn, or sync the file because the media usage rights are missing. If you obtained the file from an online store, sign in to the store, and then try again."
	},
	{
		HRES_NS_E_WMP_POLICY_VALUE_NOT_CONFIGURED,
		"HRES_NS_E_WMP_POLICY_VALUE_NOT_CONFIGURED",
		"Windows Media Player cannot read a policy. This can occur when the policy does not exist in the registry or when the registry cannot be read."
	},
	{
		HRES_NS_E_PDA_CANNOT_SYNC_FROM_INTERNET,
		"HRES_NS_E_PDA_CANNOT_SYNC_FROM_INTERNET",
		"Windows Media Player cannot sync content streamed directly from the Internet. If possible, download the file to your computer, and then try to sync the file."
	},
	{
		HRES_NS_E_PDA_CANNOT_SYNC_INVALID_PLAYLIST,
		"HRES_NS_E_PDA_CANNOT_SYNC_INVALID_PLAYLIST",
		"This playlist is not valid or is corrupted. Create a new playlist using Windows Media Player, then sync the new playlist instead."
	},
	{
		HRES_NS_E_PDA_FAILED_TO_SYNCHRONIZE_FILE,
		"HRES_NS_E_PDA_FAILED_TO_SYNCHRONIZE_FILE",
		"Windows Media Player encountered a problem while synchronizing the file to the device. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_PDA_SYNC_FAILED,
		"HRES_NS_E_PDA_SYNC_FAILED",
		"Windows Media Player encountered an error while synchronizing to the device."
	},
	{
		HRES_NS_E_PDA_DELETE_FAILED,
		"HRES_NS_E_PDA_DELETE_FAILED",
		"Windows Media Player cannot delete a file from the device."
	},
	{
		HRES_NS_E_PDA_FAILED_TO_RETRIEVE_FILE,
		"HRES_NS_E_PDA_FAILED_TO_RETRIEVE_FILE",
		"Windows Media Player cannot copy a file from the device to your library."
	},
	{
		HRES_NS_E_PDA_DEVICE_NOT_RESPONDING,
		"HRES_NS_E_PDA_DEVICE_NOT_RESPONDING",
		"Windows Media Player cannot communicate with the device because the device is not responding. Try reconnecting the device, resetting the device, or contacting the device manufacturer for updated firmware."
	},
	{
		HRES_NS_E_PDA_FAILED_TO_TRANSCODE_PHOTO,
		"HRES_NS_E_PDA_FAILED_TO_TRANSCODE_PHOTO",
		"Windows Media Player cannot sync the picture to the device because a problem occurred while converting the file to another quality level or format. The original file might be damaged or corrupted."
	},
	{
		HRES_NS_E_PDA_FAILED_TO_ENCRYPT_TRANSCODED_FILE,
		"HRES_NS_E_PDA_FAILED_TO_ENCRYPT_TRANSCODED_FILE",
		"Windows Media Player cannot convert the file. The file might have been encrypted by the Encrypted File System (EFS). Try decrypting the file first and then synchronizing it. For information about how to decrypt a file, see Windows Help and Support."
	},
	{
		HRES_NS_E_PDA_CANNOT_TRANSCODE_TO_AUDIO,
		"HRES_NS_E_PDA_CANNOT_TRANSCODE_TO_AUDIO",
		"Your device requires that this file be converted in order to play on the device. However, the device either does not support playing audio, or Windows Media Player cannot convert the file to an audio format that is supported by the device."
	},
	{
		HRES_NS_E_PDA_CANNOT_TRANSCODE_TO_VIDEO,
		"HRES_NS_E_PDA_CANNOT_TRANSCODE_TO_VIDEO",
		"Your device requires that this file be converted in order to play on the device. However, the device either does not support playing video, or Windows Media Player cannot convert the file to a video format that is supported by the device."
	},
	{
		HRES_NS_E_PDA_CANNOT_TRANSCODE_TO_IMAGE,
		"HRES_NS_E_PDA_CANNOT_TRANSCODE_TO_IMAGE",
		"Your device requires that this file be converted in order to play on the device. However, the device either does not support displaying pictures, or Windows Media Player cannot convert the file to a picture format that is supported by the device."
	},
	{
		HRES_NS_E_PDA_RETRIEVED_FILE_FILENAME_TOO_LONG,
		"HRES_NS_E_PDA_RETRIEVED_FILE_FILENAME_TOO_LONG",
		"Windows Media Player cannot sync the file to your computer because the file name is too long. Try renaming the file on the device."
	},
	{
		HRES_NS_E_PDA_CEWMDM_DRM_ERROR,
		"HRES_NS_E_PDA_CEWMDM_DRM_ERROR",
		"Windows Media Player cannot sync the file because the device is not responding. This typically occurs when there is a problem with the device firmware. For additional assistance, click Web Help."
	},
	{
		HRES_NS_E_INCOMPLETE_PLAYLIST,
		"HRES_NS_E_INCOMPLETE_PLAYLIST",
		"Incomplete playlist."
	},
	{
		HRES_NS_E_PDA_SYNC_RUNNING,
		"HRES_NS_E_PDA_SYNC_RUNNING",
		"It is not possible to perform the requested action because sync is in progress. You can either stop sync or wait for it to complete, and then try again."
	},
	{
		HRES_NS_E_PDA_SYNC_LOGIN_ERROR,
		"HRES_NS_E_PDA_SYNC_LOGIN_ERROR",
		"Windows Media Player cannot sync the subscription content because you are not signed in to the online store that provided it. Sign in to the online store, and then try again."
	},
	{
		HRES_NS_E_PDA_TRANSCODE_CODEC_NOT_FOUND,
		"HRES_NS_E_PDA_TRANSCODE_CODEC_NOT_FOUND",
		"Windows Media Player cannot convert the file to the format required by the device. One or more codecs required to convert the file could not be found."
	},
	{
		HRES_NS_E_CANNOT_SYNC_DRM_TO_NON_JANUS_DEVICE,
		"HRES_NS_E_CANNOT_SYNC_DRM_TO_NON_JANUS_DEVICE",
		"It is not possible to sync subscription files to this device."
	},
	{
		HRES_NS_E_CANNOT_SYNC_PREVIOUS_SYNC_RUNNING,
		"HRES_NS_E_CANNOT_SYNC_PREVIOUS_SYNC_RUNNING",
		"Your device is operating slowly or is not responding. Until the device responds, it is not possible to sync again. To return the device to normal operation, try disconnecting it from the computer or resetting it."
	},
	{
		HRES_NS_E_WMP_HWND_NOTFOUND,
		"HRES_NS_E_WMP_HWND_NOTFOUND",
		"The Windows Media Player download manager cannot function properly because the Player main window cannot be found. Try restarting the Player."
	},
	{
		HRES_NS_E_BKGDOWNLOAD_WRONG_NO_FILES,
		"HRES_NS_E_BKGDOWNLOAD_WRONG_NO_FILES",
		"Windows Media Player encountered a download that has the wrong number of files. This might occur if another program is trying to create jobs with the same signature as the Player."
	},
	{
		HRES_NS_E_BKGDOWNLOAD_COMPLETECANCELLEDJOB,
		"HRES_NS_E_BKGDOWNLOAD_COMPLETECANCELLEDJOB",
		"Windows Media Player tried to complete a download that was already canceled. The file will not be available."
	},
	{
		HRES_NS_E_BKGDOWNLOAD_CANCELCOMPLETEDJOB,
		"HRES_NS_E_BKGDOWNLOAD_CANCELCOMPLETEDJOB",
		"Windows Media Player tried to cancel a download that was already completed. The file will not be removed."
	},
	{
		HRES_NS_E_BKGDOWNLOAD_NOJOBPOINTER,
		"HRES_NS_E_BKGDOWNLOAD_NOJOBPOINTER",
		"Windows Media Player is trying to access a download that is not valid."
	},
	{
		HRES_NS_E_BKGDOWNLOAD_INVALIDJOBSIGNATURE,
		"HRES_NS_E_BKGDOWNLOAD_INVALIDJOBSIGNATURE",
		"This download was not created by Windows Media Player."
	},
	{
		HRES_NS_E_BKGDOWNLOAD_FAILED_TO_CREATE_TEMPFILE,
		"HRES_NS_E_BKGDOWNLOAD_FAILED_TO_CREATE_TEMPFILE",
		"The Windows Media Player download manager cannot create a temporary file name. This might occur if the path is not valid or if the disk is full."
	},
	{
		HRES_NS_E_BKGDOWNLOAD_PLUGIN_FAILEDINITIALIZE,
		"HRES_NS_E_BKGDOWNLOAD_PLUGIN_FAILEDINITIALIZE",
		"The Windows Media Player download manager plug-in cannot start. This might occur if the system is out of resources."
	},
	{
		HRES_NS_E_BKGDOWNLOAD_PLUGIN_FAILEDTOMOVEFILE,
		"HRES_NS_E_BKGDOWNLOAD_PLUGIN_FAILEDTOMOVEFILE",
		"The Windows Media Player download manager cannot move the file."
	},
	{
		HRES_NS_E_BKGDOWNLOAD_CALLFUNCFAILED,
		"HRES_NS_E_BKGDOWNLOAD_CALLFUNCFAILED",
		"The Windows Media Player download manager cannot perform a task because the system has no resources to allocate."
	},
	{
		HRES_NS_E_BKGDOWNLOAD_CALLFUNCTIMEOUT,
		"HRES_NS_E_BKGDOWNLOAD_CALLFUNCTIMEOUT",
		"The Windows Media Player download manager cannot perform a task because the task took too long to run."
	},
	{
		HRES_NS_E_BKGDOWNLOAD_CALLFUNCENDED,
		"HRES_NS_E_BKGDOWNLOAD_CALLFUNCENDED",
		"The Windows Media Player download manager cannot perform a task because the Player is terminating the service. The task will be recovered when the Player restarts."
	},
	{
		HRES_NS_E_BKGDOWNLOAD_WMDUNPACKFAILED,
		"HRES_NS_E_BKGDOWNLOAD_WMDUNPACKFAILED",
		"The Windows Media Player download manager cannot expand a WMD file. The file will be deleted and the operation will not be completed successfully."
	},
	{
		HRES_NS_E_BKGDOWNLOAD_FAILEDINITIALIZE,
		"HRES_NS_E_BKGDOWNLOAD_FAILEDINITIALIZE",
		"The Windows Media Player download manager cannot start. This might occur if the system is out of resources."
	},
	{
		HRES_NS_E_INTERFACE_NOT_REGISTERED_IN_GIT,
		"HRES_NS_E_INTERFACE_NOT_REGISTERED_IN_GIT",
		"Windows Media Player cannot access a required functionality. This might occur if the wrong system files or Player DLLs are loaded."
	},
	{
		HRES_NS_E_BKGDOWNLOAD_INVALID_FILE_NAME,
		"HRES_NS_E_BKGDOWNLOAD_INVALID_FILE_NAME",
		"Windows Media Player cannot get the file name of the requested download. The requested download will be canceled."
	},
	{
		HRES_NS_E_IMAGE_DOWNLOAD_FAILED,
		"HRES_NS_E_IMAGE_DOWNLOAD_FAILED",
		"Windows Media Player encountered an error while downloading an image."
	},
	{
		HRES_NS_E_WMP_UDRM_NOUSERLIST,
		"HRES_NS_E_WMP_UDRM_NOUSERLIST",
		"Windows Media Player cannot update your media usage rights because the Player cannot verify the list of activated users of this computer."
	},
	{
		HRES_NS_E_WMP_DRM_NOT_ACQUIRING,
		"HRES_NS_E_WMP_DRM_NOT_ACQUIRING",
		"Windows Media Player is trying to acquire media usage rights for a file that is no longer being used. Rights acquisition will stop."
	},
	{
		HRES_NS_E_WMP_BSTR_TOO_LONG,
		"HRES_NS_E_WMP_BSTR_TOO_LONG",
		"The parameter is not valid."
	},
	{
		HRES_NS_E_WMP_AUTOPLAY_INVALID_STATE,
		"HRES_NS_E_WMP_AUTOPLAY_INVALID_STATE",
		"The state is not valid for this request."
	},
	{
		HRES_NS_E_WMP_COMPONENT_REVOKED,
		"HRES_NS_E_WMP_COMPONENT_REVOKED",
		"Windows Media Player cannot play this file until you complete the software component upgrade. After the component has been upgraded, try to play the file again."
	},
	{
		HRES_NS_E_CURL_NOTSAFE,
		"HRES_NS_E_CURL_NOTSAFE",
		"The URL is not safe for the operation specified."
	},
	{
		HRES_NS_E_CURL_INVALIDCHAR,
		"HRES_NS_E_CURL_INVALIDCHAR",
		"The URL contains one or more characters that are not valid."
	},
	{
		HRES_NS_E_CURL_INVALIDHOSTNAME,
		"HRES_NS_E_CURL_INVALIDHOSTNAME",
		"The URL contains a host name that is not valid."
	},
	{
		HRES_NS_E_CURL_INVALIDPATH,
		"HRES_NS_E_CURL_INVALIDPATH",
		"The URL contains a path that is not valid."
	},
	{
		HRES_NS_E_CURL_INVALIDSCHEME,
		"HRES_NS_E_CURL_INVALIDSCHEME",
		"The URL contains a scheme that is not valid."
	},
	{
		HRES_NS_E_CURL_INVALIDURL,
		"HRES_NS_E_CURL_INVALIDURL",
		"The URL is not valid."
	},
	{
		HRES_NS_E_CURL_CANTWALK,
		"HRES_NS_E_CURL_CANTWALK",
		"Windows Media Player cannot play the file. If you clicked a link on a web page, the link might not be valid."
	},
	{
		HRES_NS_E_CURL_INVALIDPORT,
		"HRES_NS_E_CURL_INVALIDPORT",
		"The URL port is not valid."
	},
	{
		HRES_NS_E_CURLHELPER_NOTADIRECTORY,
		"HRES_NS_E_CURLHELPER_NOTADIRECTORY",
		"The URL is not a directory."
	},
	{
		HRES_NS_E_CURLHELPER_NOTAFILE,
		"HRES_NS_E_CURLHELPER_NOTAFILE",
		"The URL is not a file."
	},
	{
		HRES_NS_E_CURL_CANTDECODE,
		"HRES_NS_E_CURL_CANTDECODE",
		"The URL contains characters that cannot be decoded. The URL might be truncated or incomplete."
	},
	{
		HRES_NS_E_CURLHELPER_NOTRELATIVE,
		"HRES_NS_E_CURLHELPER_NOTRELATIVE",
		"The specified URL is not a relative URL."
	},
	{
		HRES_NS_E_CURL_INVALIDBUFFERSIZE,
		"HRES_NS_E_CURL_INVALIDBUFFERSIZE",
		"The buffer is smaller than the size specified."
	},
	{
		HRES_NS_E_SUBSCRIPTIONSERVICE_PLAYBACK_DISALLOWED,
		"HRES_NS_E_SUBSCRIPTIONSERVICE_PLAYBACK_DISALLOWED",
		"The content provider has not granted you the right to play this file. Go to the content provider's online store to get play rights."
	},
	{
		HRES_NS_E_CANNOT_BUY_OR_DOWNLOAD_FROM_MULTIPLE_SERVICES,
		"HRES_NS_E_CANNOT_BUY_OR_DOWNLOAD_FROM_MULTIPLE_SERVICES",
		"Windows Media Player cannot purchase or download content from multiple online stores."
	},
	{
		HRES_NS_E_CANNOT_BUY_OR_DOWNLOAD_CONTENT,
		"HRES_NS_E_CANNOT_BUY_OR_DOWNLOAD_CONTENT",
		"The file cannot be purchased or downloaded. The file might not be available from the online store."
	},
	{
		HRES_NS_E_NOT_CONTENT_PARTNER_TRACK,
		"HRES_NS_E_NOT_CONTENT_PARTNER_TRACK",
		"The provider of this file cannot be identified."
	},
	{
		HRES_NS_E_TRACK_DOWNLOAD_REQUIRES_ALBUM_PURCHASE,
		"HRES_NS_E_TRACK_DOWNLOAD_REQUIRES_ALBUM_PURCHASE",
		"The file is only available for download when you buy the entire album."
	},
	{
		HRES_NS_E_TRACK_DOWNLOAD_REQUIRES_PURCHASE,
		"HRES_NS_E_TRACK_DOWNLOAD_REQUIRES_PURCHASE",
		"You must buy the file before you can download it."
	},
	{
		HRES_NS_E_TRACK_PURCHASE_MAXIMUM_EXCEEDED,
		"HRES_NS_E_TRACK_PURCHASE_MAXIMUM_EXCEEDED",
		"You have exceeded the maximum number of files that can be purchased in a single transaction."
	},
	{
		HRES_NS_E_SUBSCRIPTIONSERVICE_LOGIN_FAILED,
		"HRES_NS_E_SUBSCRIPTIONSERVICE_LOGIN_FAILED",
		"Windows Media Player cannot sign in to the online store. Verify that you are using the correct user name and password. If the problem persists, the store might be temporarily unavailable."
	},
	{
		HRES_NS_E_SUBSCRIPTIONSERVICE_DOWNLOAD_TIMEOUT,
		"HRES_NS_E_SUBSCRIPTIONSERVICE_DOWNLOAD_TIMEOUT",
		"Windows Media Player cannot download this item because the server is not responding. The server might be temporarily unavailable or the Internet connection might be lost."
	},
	{
		HRES_NS_E_CONTENT_PARTNER_STILL_INITIALIZING,
		"HRES_NS_E_CONTENT_PARTNER_STILL_INITIALIZING",
		"Content Partner still initializing."
	},
	{
		HRES_NS_E_OPEN_CONTAINING_FOLDER_FAILED,
		"HRES_NS_E_OPEN_CONTAINING_FOLDER_FAILED",
		"The folder could not be opened. The folder might have been moved or deleted."
	},
	{
		HRES_NS_E_ADVANCEDEDIT_TOO_MANY_PICTURES,
		"HRES_NS_E_ADVANCEDEDIT_TOO_MANY_PICTURES",
		"Windows Media Player could not add all of the images to the file because the images exceeded the 7 megabyte (MB) limit."
	},
	{
		HRES_NS_E_REDIRECT,
		"HRES_NS_E_REDIRECT",
		"The client redirected to another server."
	},
	{
		HRES_NS_E_STALE_PRESENTATION,
		"HRES_NS_E_STALE_PRESENTATION",
		"The streaming media description is no longer current."
	},
	{
		HRES_NS_E_NAMESPACE_WRONG_PERSIST,
		"HRES_NS_E_NAMESPACE_WRONG_PERSIST",
		"It is not possible to create a persistent namespace node under a transient parent node."
	},
	{
		HRES_NS_E_NAMESPACE_WRONG_TYPE,
		"HRES_NS_E_NAMESPACE_WRONG_TYPE",
		"It is not possible to store a value in a namespace node that has a different value type."
	},
	{
		HRES_NS_E_NAMESPACE_NODE_CONFLICT,
		"HRES_NS_E_NAMESPACE_NODE_CONFLICT",
		"It is not possible to remove the root namespace node."
	},
	{
		HRES_NS_E_NAMESPACE_NODE_NOT_FOUND,
		"HRES_NS_E_NAMESPACE_NODE_NOT_FOUND",
		"The specified namespace node could not be found."
	},
	{
		HRES_NS_E_NAMESPACE_BUFFER_TOO_SMALL,
		"HRES_NS_E_NAMESPACE_BUFFER_TOO_SMALL",
		"The buffer supplied to hold namespace node string is too small."
	},
	{
		HRES_NS_E_NAMESPACE_TOO_MANY_CALLBACKS,
		"HRES_NS_E_NAMESPACE_TOO_MANY_CALLBACKS",
		"The callback list on a namespace node is at the maximum size."
	},
	{
		HRES_NS_E_NAMESPACE_DUPLICATE_CALLBACK,
		"HRES_NS_E_NAMESPACE_DUPLICATE_CALLBACK",
		"It is not possible to register an already-registered callback on a namespace node."
	},
	{
		HRES_NS_E_NAMESPACE_CALLBACK_NOT_FOUND,
		"HRES_NS_E_NAMESPACE_CALLBACK_NOT_FOUND",
		"Cannot find the callback in the namespace when attempting to remove the callback."
	},
	{
		HRES_NS_E_NAMESPACE_NAME_TOO_LONG,
		"HRES_NS_E_NAMESPACE_NAME_TOO_LONG",
		"The namespace node name exceeds the allowed maximum length."
	},
	{
		HRES_NS_E_NAMESPACE_DUPLICATE_NAME,
		"HRES_NS_E_NAMESPACE_DUPLICATE_NAME",
		"Cannot create a namespace node that already exists."
	},
	{
		HRES_NS_E_NAMESPACE_EMPTY_NAME,
		"HRES_NS_E_NAMESPACE_EMPTY_NAME",
		"The namespace node name cannot be a null string."
	},
	{
		HRES_NS_E_NAMESPACE_INDEX_TOO_LARGE,
		"HRES_NS_E_NAMESPACE_INDEX_TOO_LARGE",
		"Finding a child namespace node by index failed because the index exceeded the number of children."
	},
	{
		HRES_NS_E_NAMESPACE_BAD_NAME,
		"HRES_NS_E_NAMESPACE_BAD_NAME",
		"The namespace node name is invalid."
	},
	{
		HRES_NS_E_NAMESPACE_WRONG_SECURITY,
		"HRES_NS_E_NAMESPACE_WRONG_SECURITY",
		"It is not possible to store a value in a namespace node that has a different security type."
	},
	{
		HRES_NS_E_CACHE_ARCHIVE_CONFLICT,
		"HRES_NS_E_CACHE_ARCHIVE_CONFLICT",
		"The archive request conflicts with other requests in progress."
	},
	{
		HRES_NS_E_CACHE_ORIGIN_SERVER_NOT_FOUND,
		"HRES_NS_E_CACHE_ORIGIN_SERVER_NOT_FOUND",
		"The specified origin server cannot be found."
	},
	{
		HRES_NS_E_CACHE_ORIGIN_SERVER_TIMEOUT,
		"HRES_NS_E_CACHE_ORIGIN_SERVER_TIMEOUT",
		"The specified origin server is not responding."
	},
	{
		HRES_NS_E_CACHE_NOT_BROADCAST,
		"HRES_NS_E_CACHE_NOT_BROADCAST",
		"The internal code for HTTP status code 412 Precondition Failed due to not broadcast type."
	},
	{
		HRES_NS_E_CACHE_CANNOT_BE_CACHED,
		"HRES_NS_E_CACHE_CANNOT_BE_CACHED",
		"The internal code for HTTP status code 403 Forbidden due to not cacheable."
	},
	{
		HRES_NS_E_CACHE_NOT_MODIFIED,
		"HRES_NS_E_CACHE_NOT_MODIFIED",
		"The internal code for HTTP status code 304 Not Modified."
	},
	{
		HRES_NS_E_CANNOT_REMOVE_PUBLISHING_POINT,
		"HRES_NS_E_CANNOT_REMOVE_PUBLISHING_POINT",
		"It is not possible to remove a cache or proxy publishing point."
	},
	{
		HRES_NS_E_CANNOT_REMOVE_PLUGIN,
		"HRES_NS_E_CANNOT_REMOVE_PLUGIN",
		"It is not possible to remove the last instance of a type of plug-in."
	},
	{
		HRES_NS_E_WRONG_PUBLISHING_POINT_TYPE,
		"HRES_NS_E_WRONG_PUBLISHING_POINT_TYPE",
		"Cache and proxy publishing points do not support this property or method."
	},
	{
		HRES_NS_E_UNSUPPORTED_LOAD_TYPE,
		"HRES_NS_E_UNSUPPORTED_LOAD_TYPE",
		"The plug-in does not support the specified load type."
	},
	{
		HRES_NS_E_INVALID_PLUGIN_LOAD_TYPE_CONFIGURATION,
		"HRES_NS_E_INVALID_PLUGIN_LOAD_TYPE_CONFIGURATION",
		"The plug-in does not support any load types. The plug-in must support at least one load type."
	},
	{
		HRES_NS_E_INVALID_PUBLISHING_POINT_NAME,
		"HRES_NS_E_INVALID_PUBLISHING_POINT_NAME",
		"The publishing point name is invalid."
	},
	{
		HRES_NS_E_TOO_MANY_MULTICAST_SINKS,
		"HRES_NS_E_TOO_MANY_MULTICAST_SINKS",
		"Only one multicast data writer plug-in can be enabled for a publishing point."
	},
	{
		HRES_NS_E_PUBLISHING_POINT_INVALID_REQUEST_WHILE_STARTED,
		"HRES_NS_E_PUBLISHING_POINT_INVALID_REQUEST_WHILE_STARTED",
		"The requested operation cannot be completed while the publishing point is started."
	},
	{
		HRES_NS_E_MULTICAST_PLUGIN_NOT_ENABLED,
		"HRES_NS_E_MULTICAST_PLUGIN_NOT_ENABLED",
		"A multicast data writer plug-in must be enabled in order for this operation to be completed."
	},
	{
		HRES_NS_E_INVALID_OPERATING_SYSTEM_VERSION,
		"HRES_NS_E_INVALID_OPERATING_SYSTEM_VERSION",
		"This feature requires Windows Server 2003, Enterprise Edition."
	},
	{
		HRES_NS_E_PUBLISHING_POINT_REMOVED,
		"HRES_NS_E_PUBLISHING_POINT_REMOVED",
		"The requested operation cannot be completed because the specified publishing point has been removed."
	},
	{
		HRES_NS_E_INVALID_PUSH_PUBLISHING_POINT_START_REQUEST,
		"HRES_NS_E_INVALID_PUSH_PUBLISHING_POINT_START_REQUEST",
		"Push publishing points are started when the encoder starts pushing the stream. This publishing point cannot be started by the server administrator."
	},
	{
		HRES_NS_E_UNSUPPORTED_LANGUAGE,
		"HRES_NS_E_UNSUPPORTED_LANGUAGE",
		"The specified language is not supported."
	},
	{
		HRES_NS_E_WRONG_OS_VERSION,
		"HRES_NS_E_WRONG_OS_VERSION",
		"Windows Media Services will only run on Windows Server 2003, Standard Edition and Windows Server 2003, Enterprise Edition."
	},
	{
		HRES_NS_E_PUBLISHING_POINT_STOPPED,
		"HRES_NS_E_PUBLISHING_POINT_STOPPED",
		"The operation cannot be completed because the publishing point has been stopped."
	},
	{
		HRES_NS_E_PLAYLIST_ENTRY_ALREADY_PLAYING,
		"HRES_NS_E_PLAYLIST_ENTRY_ALREADY_PLAYING",
		"The playlist entry is already playing."
	},
	{
		HRES_NS_E_EMPTY_PLAYLIST,
		"HRES_NS_E_EMPTY_PLAYLIST",
		"The playlist or directory you are requesting does not contain content."
	},
	{
		HRES_NS_E_PLAYLIST_PARSE_FAILURE,
		"HRES_NS_E_PLAYLIST_PARSE_FAILURE",
		"The server was unable to parse the requested playlist file."
	},
	{
		HRES_NS_E_PLAYLIST_UNSUPPORTED_ENTRY,
		"HRES_NS_E_PLAYLIST_UNSUPPORTED_ENTRY",
		"The requested operation is not supported for this type of playlist entry."
	},
	{
		HRES_NS_E_PLAYLIST_ENTRY_NOT_IN_PLAYLIST,
		"HRES_NS_E_PLAYLIST_ENTRY_NOT_IN_PLAYLIST",
		"Cannot jump to a playlist entry that is not inserted in the playlist."
	},
	{
		HRES_NS_E_PLAYLIST_ENTRY_SEEK,
		"HRES_NS_E_PLAYLIST_ENTRY_SEEK",
		"Cannot seek to the desired playlist entry."
	},
	{
		HRES_NS_E_PLAYLIST_RECURSIVE_PLAYLISTS,
		"HRES_NS_E_PLAYLIST_RECURSIVE_PLAYLISTS",
		"Cannot play recursive playlist."
	},
	{
		HRES_NS_E_PLAYLIST_TOO_MANY_NESTED_PLAYLISTS,
		"HRES_NS_E_PLAYLIST_TOO_MANY_NESTED_PLAYLISTS",
		"The number of nested playlists exceeded the limit the server can handle."
	},
	{
		HRES_NS_E_PLAYLIST_SHUTDOWN,
		"HRES_NS_E_PLAYLIST_SHUTDOWN",
		"Cannot execute the requested operation because the playlist has been shut down by the Media Server."
	},
	{
		HRES_NS_E_PLAYLIST_END_RECEDING,
		"HRES_NS_E_PLAYLIST_END_RECEDING",
		"The playlist has ended while receding."
	},
	{
		HRES_NS_E_DATAPATH_NO_SINK,
		"HRES_NS_E_DATAPATH_NO_SINK",
		"The data path does not have an associated data writer plug-in."
	},
	{
		HRES_NS_E_INVALID_PUSH_TEMPLATE,
		"HRES_NS_E_INVALID_PUSH_TEMPLATE",
		"The specified push template is invalid."
	},
	{
		HRES_NS_E_INVALID_PUSH_PUBLISHING_POINT,
		"HRES_NS_E_INVALID_PUSH_PUBLISHING_POINT",
		"The specified push publishing point is invalid."
	},
	{
		HRES_NS_E_CRITICAL_ERROR,
		"HRES_NS_E_CRITICAL_ERROR",
		"The requested operation cannot be performed because the server or publishing point is in a critical error state."
	},
	{
		HRES_NS_E_NO_NEW_CONNECTIONS,
		"HRES_NS_E_NO_NEW_CONNECTIONS",
		"The content cannot be played because the server is not currently accepting connections. Try connecting at a later time."
	},
	{
		HRES_NS_E_WSX_INVALID_VERSION,
		"HRES_NS_E_WSX_INVALID_VERSION",
		"The version of this playlist is not supported by the server."
	},
	{
		HRES_NS_E_HEADER_MISMATCH,
		"HRES_NS_E_HEADER_MISMATCH",
		"The command does not apply to the current media header user by a server component."
	},
	{
		HRES_NS_E_PUSH_DUPLICATE_PUBLISHING_POINT_NAME,
		"HRES_NS_E_PUSH_DUPLICATE_PUBLISHING_POINT_NAME",
		"The specified publishing point name is already in use."
	},
	{
		HRES_NS_E_NO_SCRIPT_ENGINE,
		"HRES_NS_E_NO_SCRIPT_ENGINE",
		"There is no script engine available for this file."
	},
	{
		HRES_NS_E_PLUGIN_ERROR_REPORTED,
		"HRES_NS_E_PLUGIN_ERROR_REPORTED",
		"The plug-in has reported an error. See the Troubleshooting tab or the NT Application Event Log for details."
	},
	{
		HRES_NS_E_SOURCE_PLUGIN_NOT_FOUND,
		"HRES_NS_E_SOURCE_PLUGIN_NOT_FOUND",
		"No enabled data source plug-in is available to access the requested content."
	},
	{
		HRES_NS_E_PLAYLIST_PLUGIN_NOT_FOUND,
		"HRES_NS_E_PLAYLIST_PLUGIN_NOT_FOUND",
		"No enabled playlist parser plug-in is available to access the requested content."
	},
	{
		HRES_NS_E_DATA_SOURCE_ENUMERATION_NOT_SUPPORTED,
		"HRES_NS_E_DATA_SOURCE_ENUMERATION_NOT_SUPPORTED",
		"The data source plug-in does not support enumeration."
	},
	{
		HRES_NS_E_MEDIA_PARSER_INVALID_FORMAT,
		"HRES_NS_E_MEDIA_PARSER_INVALID_FORMAT",
		"The server cannot stream the selected file because it is either damaged or corrupt. Select a different file."
	},
	{
		HRES_NS_E_SCRIPT_DEBUGGER_NOT_INSTALLED,
		"HRES_NS_E_SCRIPT_DEBUGGER_NOT_INSTALLED",
		"The plug-in cannot be enabled because a compatible script debugger is not installed on this system. Install a script debugger, or disable the script debugger option on the general tab of the plug-in's properties page and try again."
	},
	{
		HRES_NS_E_FEATURE_REQUIRES_ENTERPRISE_SERVER,
		"HRES_NS_E_FEATURE_REQUIRES_ENTERPRISE_SERVER",
		"The plug-in cannot be loaded because it requires Windows Server 2003, Enterprise Edition."
	},
	{
		HRES_NS_E_WIZARD_RUNNING,
		"HRES_NS_E_WIZARD_RUNNING",
		"Another wizard is currently running. Please close the other wizard or wait until it finishes before attempting to run this wizard again."
	},
	{
		HRES_NS_E_INVALID_LOG_URL,
		"HRES_NS_E_INVALID_LOG_URL",
		"Invalid log URL. Multicast logging URL must look like \"http://servername/isapibackend.dll\"."
	},
	{
		HRES_NS_E_INVALID_MTU_RANGE,
		"HRES_NS_E_INVALID_MTU_RANGE",
		"Invalid MTU specified. The valid range for maximum packet size is between 36 and 65507 bytes."
	},
	{
		HRES_NS_E_INVALID_PLAY_STATISTICS,
		"HRES_NS_E_INVALID_PLAY_STATISTICS",
		"Invalid play statistics for logging."
	},
	{
		HRES_NS_E_LOG_NEED_TO_BE_SKIPPED,
		"HRES_NS_E_LOG_NEED_TO_BE_SKIPPED",
		"The log needs to be skipped."
	},
	{
		HRES_NS_E_HTTP_TEXT_DATACONTAINER_SIZE_LIMIT_EXCEEDED,
		"HRES_NS_E_HTTP_TEXT_DATACONTAINER_SIZE_LIMIT_EXCEEDED",
		"The size of the data exceeded the limit the WMS HTTP Download Data Source plugin can handle."
	},
	{
		HRES_NS_E_PORT_IN_USE,
		"HRES_NS_E_PORT_IN_USE",
		"One usage of each socket address (protocol/network address/port) is permitted. Verify that other services or applications are not attempting to use the same port and then try to enable the plug-in again."
	},
	{
		HRES_NS_E_PORT_IN_USE_HTTP,
		"HRES_NS_E_PORT_IN_USE_HTTP",
		"One usage of each socket address (protocol/network address/port) is permitted. Verify that other services (such as IIS) or applications are not attempting to use the same port and then try to enable the plug-in again."
	},
	{
		HRES_NS_E_HTTP_TEXT_DATACONTAINER_INVALID_SERVER_RESPONSE,
		"HRES_NS_E_HTTP_TEXT_DATACONTAINER_INVALID_SERVER_RESPONSE",
		"The WMS HTTP Download Data Source plugin was unable to receive the remote server's response."
	},
	{
		HRES_NS_E_ARCHIVE_REACH_QUOTA,
		"HRES_NS_E_ARCHIVE_REACH_QUOTA",
		"The archive plug-in has reached its quota."
	},
	{
		HRES_NS_E_ARCHIVE_ABORT_DUE_TO_BCAST,
		"HRES_NS_E_ARCHIVE_ABORT_DUE_TO_BCAST",
		"The archive plug-in aborted because the source was from broadcast."
	},
	{
		HRES_NS_E_ARCHIVE_GAP_DETECTED,
		"HRES_NS_E_ARCHIVE_GAP_DETECTED",
		"The archive plug-in detected an interrupt in the source."
	},
	{
		HRES_NS_E_AUTHORIZATION_FILE_NOT_FOUND,
		"HRES_NS_E_AUTHORIZATION_FILE_NOT_FOUND",
		"The system cannot find the file specified."
	},
	{
		HRES_NS_E_BAD_MARKIN,
		"HRES_NS_E_BAD_MARKIN",
		"The mark-in time should be greater than 0 and less than the mark-out time."
	},
	{
		HRES_NS_E_BAD_MARKOUT,
		"HRES_NS_E_BAD_MARKOUT",
		"The mark-out time should be greater than the mark-in time and less than the file duration."
	},
	{
		HRES_NS_E_NOMATCHING_MEDIASOURCE,
		"HRES_NS_E_NOMATCHING_MEDIASOURCE",
		"No matching media type is found in the source %1."
	},
	{
		HRES_NS_E_UNSUPPORTED_SOURCETYPE,
		"HRES_NS_E_UNSUPPORTED_SOURCETYPE",
		"The specified source type is not supported."
	},
	{
		HRES_NS_E_TOO_MANY_AUDIO,
		"HRES_NS_E_TOO_MANY_AUDIO",
		"It is not possible to specify more than one audio input."
	},
	{
		HRES_NS_E_TOO_MANY_VIDEO,
		"HRES_NS_E_TOO_MANY_VIDEO",
		"It is not possible to specify more than two video inputs."
	},
	{
		HRES_NS_E_NOMATCHING_ELEMENT,
		"HRES_NS_E_NOMATCHING_ELEMENT",
		"No matching element is found in the list."
	},
	{
		HRES_NS_E_MISMATCHED_MEDIACONTENT,
		"HRES_NS_E_MISMATCHED_MEDIACONTENT",
		"The profile's media types must match the media types defined for the session."
	},
	{
		HRES_NS_E_CANNOT_DELETE_ACTIVE_SOURCEGROUP,
		"HRES_NS_E_CANNOT_DELETE_ACTIVE_SOURCEGROUP",
		"It is not possible to remove an active source while encoding."
	},
	{
		HRES_NS_E_AUDIODEVICE_BUSY,
		"HRES_NS_E_AUDIODEVICE_BUSY",
		"It is not possible to open the specified audio capture device because it is currently in use."
	},
	{
		HRES_NS_E_AUDIODEVICE_UNEXPECTED,
		"HRES_NS_E_AUDIODEVICE_UNEXPECTED",
		"It is not possible to open the specified audio capture device because an unexpected error has occurred."
	},
	{
		HRES_NS_E_AUDIODEVICE_BADFORMAT,
		"HRES_NS_E_AUDIODEVICE_BADFORMAT",
		"The audio capture device does not support the specified audio format."
	},
	{
		HRES_NS_E_VIDEODEVICE_BUSY,
		"HRES_NS_E_VIDEODEVICE_BUSY",
		"It is not possible to open the specified video capture device because it is currently in use."
	},
	{
		HRES_NS_E_VIDEODEVICE_UNEXPECTED,
		"HRES_NS_E_VIDEODEVICE_UNEXPECTED",
		"It is not possible to open the specified video capture device because an unexpected error has occurred."
	},
	{
		HRES_NS_E_INVALIDCALL_WHILE_ENCODER_RUNNING,
		"HRES_NS_E_INVALIDCALL_WHILE_ENCODER_RUNNING",
		"This operation is not allowed while encoding."
	},
	{
		HRES_NS_E_NO_PROFILE_IN_SOURCEGROUP,
		"HRES_NS_E_NO_PROFILE_IN_SOURCEGROUP",
		"No profile is set for the source."
	},
	{
		HRES_NS_E_VIDEODRIVER_UNSTABLE,
		"HRES_NS_E_VIDEODRIVER_UNSTABLE",
		"The video capture driver returned an unrecoverable error. It is now in an unstable state."
	},
	{
		HRES_NS_E_VIDCAPSTARTFAILED,
		"HRES_NS_E_VIDCAPSTARTFAILED",
		"It was not possible to start the video device."
	},
	{
		HRES_NS_E_VIDSOURCECOMPRESSION,
		"HRES_NS_E_VIDSOURCECOMPRESSION",
		"The video source does not support the requested output format or color depth."
	},
	{
		HRES_NS_E_VIDSOURCESIZE,
		"HRES_NS_E_VIDSOURCESIZE",
		"The video source does not support the requested capture size."
	},
	{
		HRES_NS_E_ICMQUERYFORMAT,
		"HRES_NS_E_ICMQUERYFORMAT",
		"It was not possible to obtain output information from the video compressor."
	},
	{
		HRES_NS_E_VIDCAPCREATEWINDOW,
		"HRES_NS_E_VIDCAPCREATEWINDOW",
		"It was not possible to create a video capture window."
	},
	{
		HRES_NS_E_VIDCAPDRVINUSE,
		"HRES_NS_E_VIDCAPDRVINUSE",
		"There is already a stream active on this video device."
	},
	{
		HRES_NS_E_NO_MEDIAFORMAT_IN_SOURCE,
		"HRES_NS_E_NO_MEDIAFORMAT_IN_SOURCE",
		"No media format is set in source."
	},
	{
		HRES_NS_E_NO_VALID_OUTPUT_STREAM,
		"HRES_NS_E_NO_VALID_OUTPUT_STREAM",
		"Cannot find a valid output stream from the source."
	},
	{
		HRES_NS_E_NO_VALID_SOURCE_PLUGIN,
		"HRES_NS_E_NO_VALID_SOURCE_PLUGIN",
		"It was not possible to find a valid source plug-in for the specified source."
	},
	{
		HRES_NS_E_NO_ACTIVE_SOURCEGROUP,
		"HRES_NS_E_NO_ACTIVE_SOURCEGROUP",
		"No source is currently active."
	},
	{
		HRES_NS_E_NO_SCRIPT_STREAM,
		"HRES_NS_E_NO_SCRIPT_STREAM",
		"No script stream is set in the current source."
	},
	{
		HRES_NS_E_INVALIDCALL_WHILE_ARCHIVAL_RUNNING,
		"HRES_NS_E_INVALIDCALL_WHILE_ARCHIVAL_RUNNING",
		"This operation is not allowed while archiving."
	},
	{
		HRES_NS_E_INVALIDPACKETSIZE,
		"HRES_NS_E_INVALIDPACKETSIZE",
		"The setting for the maximum packet size is not valid."
	},
	{
		HRES_NS_E_PLUGIN_CLSID_INVALID,
		"HRES_NS_E_PLUGIN_CLSID_INVALID",
		"The plug-in CLSID specified is not valid."
	},
	{
		HRES_NS_E_UNSUPPORTED_ARCHIVETYPE,
		"HRES_NS_E_UNSUPPORTED_ARCHIVETYPE",
		"This archive type is not supported."
	},
	{
		HRES_NS_E_UNSUPPORTED_ARCHIVEOPERATION,
		"HRES_NS_E_UNSUPPORTED_ARCHIVEOPERATION",
		"This archive operation is not supported."
	},
	{
		HRES_NS_E_ARCHIVE_FILENAME_NOTSET,
		"HRES_NS_E_ARCHIVE_FILENAME_NOTSET",
		"The local archive file name was not set."
	},
	{
		HRES_NS_E_SOURCEGROUP_NOTPREPARED,
		"HRES_NS_E_SOURCEGROUP_NOTPREPARED",
		"The source is not yet prepared."
	},
	{
		HRES_NS_E_PROFILE_MISMATCH,
		"HRES_NS_E_PROFILE_MISMATCH",
		"Profiles on the sources do not match."
	},
	{
		HRES_NS_E_INCORRECTCLIPSETTINGS,
		"HRES_NS_E_INCORRECTCLIPSETTINGS",
		"The specified crop values are not valid."
	},
	{
		HRES_NS_E_NOSTATSAVAILABLE,
		"HRES_NS_E_NOSTATSAVAILABLE",
		"No statistics are available at this time."
	},
	{
		HRES_NS_E_NOTARCHIVING,
		"HRES_NS_E_NOTARCHIVING",
		"The encoder is not archiving."
	},
	{
		HRES_NS_E_INVALIDCALL_WHILE_ENCODER_STOPPED,
		"HRES_NS_E_INVALIDCALL_WHILE_ENCODER_STOPPED",
		"This operation is only allowed during encoding."
	},
	{
		HRES_NS_E_NOSOURCEGROUPS,
		"HRES_NS_E_NOSOURCEGROUPS",
		"This SourceGroupCollection doesn't contain any SourceGroups."
	},
	{
		HRES_NS_E_INVALIDINPUTFPS,
		"HRES_NS_E_INVALIDINPUTFPS",
		"This source does not have a frame rate of 30 fps. Therefore, it is not possible to apply the inverse telecine filter to the source."
	},
	{
		HRES_NS_E_NO_DATAVIEW_SUPPORT,
		"HRES_NS_E_NO_DATAVIEW_SUPPORT",
		"It is not possible to display your source or output video in the Video panel."
	},
	{
		HRES_NS_E_CODEC_UNAVAILABLE,
		"HRES_NS_E_CODEC_UNAVAILABLE",
		"One or more codecs required to open this content could not be found."
	},
	{
		HRES_NS_E_ARCHIVE_SAME_AS_INPUT,
		"HRES_NS_E_ARCHIVE_SAME_AS_INPUT",
		"The archive file has the same name as an input file. Change one of the names before continuing."
	},
	{
		HRES_NS_E_SOURCE_NOTSPECIFIED,
		"HRES_NS_E_SOURCE_NOTSPECIFIED",
		"The source has not been set up completely."
	},
	{
		HRES_NS_E_NO_REALTIME_TIMECOMPRESSION,
		"HRES_NS_E_NO_REALTIME_TIMECOMPRESSION",
		"It is not possible to apply time compression to a broadcast session."
	},
	{
		HRES_NS_E_UNSUPPORTED_ENCODER_DEVICE,
		"HRES_NS_E_UNSUPPORTED_ENCODER_DEVICE",
		"It is not possible to open this device."
	},
	{
		HRES_NS_E_UNEXPECTED_DISPLAY_SETTINGS,
		"HRES_NS_E_UNEXPECTED_DISPLAY_SETTINGS",
		"It is not possible to start encoding because the display size or color has changed since the current session was defined. Restore the previous settings or create a new session."
	},
	{
		HRES_NS_E_NO_AUDIODATA,
		"HRES_NS_E_NO_AUDIODATA",
		"No audio data has been received for several seconds. Check the audio source and restart the encoder."
	},
	{
		HRES_NS_E_INPUTSOURCE_PROBLEM,
		"HRES_NS_E_INPUTSOURCE_PROBLEM",
		"One or all of the specified sources are not working properly. Check that the sources are configured correctly."
	},
	{
		HRES_NS_E_WME_VERSION_MISMATCH,
		"HRES_NS_E_WME_VERSION_MISMATCH",
		"The supplied configuration file is not supported by this version of the encoder."
	},
	{
		HRES_NS_E_NO_REALTIME_PREPROCESS,
		"HRES_NS_E_NO_REALTIME_PREPROCESS",
		"It is not possible to use image preprocessing with live encoding."
	},
	{
		HRES_NS_E_NO_REPEAT_PREPROCESS,
		"HRES_NS_E_NO_REPEAT_PREPROCESS",
		"It is not possible to use two-pass encoding when the source is set to loop."
	},
	{
		HRES_NS_E_CANNOT_PAUSE_LIVEBROADCAST,
		"HRES_NS_E_CANNOT_PAUSE_LIVEBROADCAST",
		"It is not possible to pause encoding during a broadcast."
	},
	{
		HRES_NS_E_DRM_PROFILE_NOT_SET,
		"HRES_NS_E_DRM_PROFILE_NOT_SET",
		"A DRM profile has not been set for the current session."
	},
	{
		HRES_NS_E_DUPLICATE_DRMPROFILE,
		"HRES_NS_E_DUPLICATE_DRMPROFILE",
		"The profile ID is already used by a DRM profile. Specify a different profile ID."
	},
	{
		HRES_NS_E_INVALID_DEVICE,
		"HRES_NS_E_INVALID_DEVICE",
		"The setting of the selected device does not support control for playing back tapes."
	},
	{
		HRES_NS_E_SPEECHEDL_ON_NON_MIXEDMODE,
		"HRES_NS_E_SPEECHEDL_ON_NON_MIXEDMODE",
		"You must specify a mixed voice and audio mode in order to use an optimization definition file."
	},
	{
		HRES_NS_E_DRM_PASSWORD_TOO_LONG,
		"HRES_NS_E_DRM_PASSWORD_TOO_LONG",
		"The specified password is too long. Type a password with fewer than 8 characters."
	},
	{
		HRES_NS_E_DEVCONTROL_FAILED_SEEK,
		"HRES_NS_E_DEVCONTROL_FAILED_SEEK",
		"It is not possible to seek to the specified mark-in point."
	},
	{
		HRES_NS_E_INTERLACE_REQUIRE_SAMESIZE,
		"HRES_NS_E_INTERLACE_REQUIRE_SAMESIZE",
		"When you choose to maintain the interlacing in your video, the output video size must match the input video size."
	},
	{
		HRES_NS_E_TOO_MANY_DEVICECONTROL,
		"HRES_NS_E_TOO_MANY_DEVICECONTROL",
		"Only one device control plug-in can control a device."
	},
	{
		HRES_NS_E_NO_MULTIPASS_FOR_LIVEDEVICE,
		"HRES_NS_E_NO_MULTIPASS_FOR_LIVEDEVICE",
		"You must also enable storing content to hard disk temporarily in order to use two-pass encoding with the input device."
	},
	{
		HRES_NS_E_MISSING_AUDIENCE,
		"HRES_NS_E_MISSING_AUDIENCE",
		"An audience is missing from the output stream configuration."
	},
	{
		HRES_NS_E_AUDIENCE_CONTENTTYPE_MISMATCH,
		"HRES_NS_E_AUDIENCE_CONTENTTYPE_MISMATCH",
		"All audiences in the output tree must have the same content type."
	},
	{
		HRES_NS_E_MISSING_SOURCE_INDEX,
		"HRES_NS_E_MISSING_SOURCE_INDEX",
		"A source index is missing from the output stream configuration."
	},
	{
		HRES_NS_E_NUM_LANGUAGE_MISMATCH,
		"HRES_NS_E_NUM_LANGUAGE_MISMATCH",
		"The same source index in different audiences should have the same number of languages."
	},
	{
		HRES_NS_E_LANGUAGE_MISMATCH,
		"HRES_NS_E_LANGUAGE_MISMATCH",
		"The same source index in different audiences should have the same languages."
	},
	{
		HRES_NS_E_VBRMODE_MISMATCH,
		"HRES_NS_E_VBRMODE_MISMATCH",
		"The same source index in different audiences should use the same VBR encoding mode."
	},
	{
		HRES_NS_E_INVALID_INPUT_AUDIENCE_INDEX,
		"HRES_NS_E_INVALID_INPUT_AUDIENCE_INDEX",
		"The bit rate index specified is not valid."
	},
	{
		HRES_NS_E_INVALID_INPUT_LANGUAGE,
		"HRES_NS_E_INVALID_INPUT_LANGUAGE",
		"The specified language is not valid."
	},
	{
		HRES_NS_E_INVALID_INPUT_STREAM,
		"HRES_NS_E_INVALID_INPUT_STREAM",
		"The specified source type is not valid."
	},
	{
		HRES_NS_E_EXPECT_MONO_WAV_INPUT,
		"HRES_NS_E_EXPECT_MONO_WAV_INPUT",
		"The source must be a mono channel .wav file."
	},
	{
		HRES_NS_E_INPUT_WAVFORMAT_MISMATCH,
		"HRES_NS_E_INPUT_WAVFORMAT_MISMATCH",
		"All the source .wav files must have the same format."
	},
	{
		HRES_NS_E_RECORDQ_DISK_FULL,
		"HRES_NS_E_RECORDQ_DISK_FULL",
		"The hard disk being used for temporary storage of content has reached the minimum allowed disk space. Create more space on the hard disk and restart encoding."
	},
	{
		HRES_NS_E_NO_PAL_INVERSE_TELECINE,
		"HRES_NS_E_NO_PAL_INVERSE_TELECINE",
		"It is not possible to apply the inverse telecine feature to PAL content."
	},
	{
		HRES_NS_E_ACTIVE_SG_DEVICE_DISCONNECTED,
		"HRES_NS_E_ACTIVE_SG_DEVICE_DISCONNECTED",
		"A capture device in the current active source is no longer available."
	},
	{
		HRES_NS_E_ACTIVE_SG_DEVICE_CONTROL_DISCONNECTED,
		"HRES_NS_E_ACTIVE_SG_DEVICE_CONTROL_DISCONNECTED",
		"A device used in the current active source for device control is no longer available."
	},
	{
		HRES_NS_E_NO_FRAMES_SUBMITTED_TO_ANALYZER,
		"HRES_NS_E_NO_FRAMES_SUBMITTED_TO_ANALYZER",
		"No frames have been submitted to the analyzer for analysis."
	},
	{
		HRES_NS_E_INPUT_DOESNOT_SUPPORT_SMPTE,
		"HRES_NS_E_INPUT_DOESNOT_SUPPORT_SMPTE",
		"The source video does not support time codes."
	},
	{
		HRES_NS_E_NO_SMPTE_WITH_MULTIPLE_SOURCEGROUPS,
		"HRES_NS_E_NO_SMPTE_WITH_MULTIPLE_SOURCEGROUPS",
		"It is not possible to generate a time code when there are multiple sources in a session."
	},
	{
		HRES_NS_E_BAD_CONTENTEDL,
		"HRES_NS_E_BAD_CONTENTEDL",
		"The voice codec optimization definition file cannot be found or is corrupted."
	},
	{
		HRES_NS_E_INTERLACEMODE_MISMATCH,
		"HRES_NS_E_INTERLACEMODE_MISMATCH",
		"The same source index in different audiences should have the same interlace mode."
	},
	{
		HRES_NS_E_NONSQUAREPIXELMODE_MISMATCH,
		"HRES_NS_E_NONSQUAREPIXELMODE_MISMATCH",
		"The same source index in different audiences should have the same nonsquare pixel mode."
	},
	{
		HRES_NS_E_SMPTEMODE_MISMATCH,
		"HRES_NS_E_SMPTEMODE_MISMATCH",
		"The same source index in different audiences should have the same time code mode."
	},
	{
		HRES_NS_E_END_OF_TAPE,
		"HRES_NS_E_END_OF_TAPE",
		"Either the end of the tape has been reached or there is no tape. Check the device and tape."
	},
	{
		HRES_NS_E_NO_MEDIA_IN_AUDIENCE,
		"HRES_NS_E_NO_MEDIA_IN_AUDIENCE",
		"No audio or video input has been specified."
	},
	{
		HRES_NS_E_NO_AUDIENCES,
		"HRES_NS_E_NO_AUDIENCES",
		"The profile must contain a bit rate."
	},
	{
		HRES_NS_E_NO_AUDIO_COMPAT,
		"HRES_NS_E_NO_AUDIO_COMPAT",
		"You must specify at least one audio stream to be compatible with Windows Media Player 7.1."
	},
	{
		HRES_NS_E_INVALID_VBR_COMPAT,
		"HRES_NS_E_INVALID_VBR_COMPAT",
		"Using a VBR encoding mode is not compatible with Windows Media Player 7.1."
	},
	{
		HRES_NS_E_NO_PROFILE_NAME,
		"HRES_NS_E_NO_PROFILE_NAME",
		"You must specify a profile name."
	},
	{
		HRES_NS_E_INVALID_VBR_WITH_UNCOMP,
		"HRES_NS_E_INVALID_VBR_WITH_UNCOMP",
		"It is not possible to use a VBR encoding mode with uncompressed audio or video."
	},
	{
		HRES_NS_E_MULTIPLE_VBR_AUDIENCES,
		"HRES_NS_E_MULTIPLE_VBR_AUDIENCES",
		"It is not possible to use MBR encoding with VBR encoding."
	},
	{
		HRES_NS_E_UNCOMP_COMP_COMBINATION,
		"HRES_NS_E_UNCOMP_COMP_COMBINATION",
		"It is not possible to mix uncompressed and compressed content in a session."
	},
	{
		HRES_NS_E_MULTIPLE_AUDIO_CODECS,
		"HRES_NS_E_MULTIPLE_AUDIO_CODECS",
		"All audiences must use the same audio codec."
	},
	{
		HRES_NS_E_MULTIPLE_AUDIO_FORMATS,
		"HRES_NS_E_MULTIPLE_AUDIO_FORMATS",
		"All audiences should use the same audio format to be compatible with Windows Media Player 7.1."
	},
	{
		HRES_NS_E_AUDIO_BITRATE_STEPDOWN,
		"HRES_NS_E_AUDIO_BITRATE_STEPDOWN",
		"The audio bit rate for an audience with a higher total bit rate must be greater than one with a lower total bit rate."
	},
	{
		HRES_NS_E_INVALID_AUDIO_PEAKRATE,
		"HRES_NS_E_INVALID_AUDIO_PEAKRATE",
		"The audio peak bit rate setting is not valid."
	},
	{
		HRES_NS_E_INVALID_AUDIO_PEAKRATE_2,
		"HRES_NS_E_INVALID_AUDIO_PEAKRATE_2",
		"The audio peak bit rate setting must be greater than the audio bit rate setting."
	},
	{
		HRES_NS_E_INVALID_AUDIO_BUFFERMAX,
		"HRES_NS_E_INVALID_AUDIO_BUFFERMAX",
		"The setting for the maximum buffer size for audio is not valid."
	},
	{
		HRES_NS_E_MULTIPLE_VIDEO_CODECS,
		"HRES_NS_E_MULTIPLE_VIDEO_CODECS",
		"All audiences must use the same video codec."
	},
	{
		HRES_NS_E_MULTIPLE_VIDEO_SIZES,
		"HRES_NS_E_MULTIPLE_VIDEO_SIZES",
		"All audiences should use the same video size to be compatible with Windows Media Player 7.1."
	},
	{
		HRES_NS_E_INVALID_VIDEO_BITRATE,
		"HRES_NS_E_INVALID_VIDEO_BITRATE",
		"The video bit rate setting is not valid."
	},
	{
		HRES_NS_E_VIDEO_BITRATE_STEPDOWN,
		"HRES_NS_E_VIDEO_BITRATE_STEPDOWN",
		"The video bit rate for an audience with a higher total bit rate must be greater than one with a lower total bit rate."
	},
	{
		HRES_NS_E_INVALID_VIDEO_PEAKRATE,
		"HRES_NS_E_INVALID_VIDEO_PEAKRATE",
		"The video peak bit rate setting is not valid."
	},
	{
		HRES_NS_E_INVALID_VIDEO_PEAKRATE_2,
		"HRES_NS_E_INVALID_VIDEO_PEAKRATE_2",
		"The video peak bit rate setting must be greater than the video bit rate setting."
	},
	{
		HRES_NS_E_INVALID_VIDEO_WIDTH,
		"HRES_NS_E_INVALID_VIDEO_WIDTH",
		"The video width setting is not valid."
	},
	{
		HRES_NS_E_INVALID_VIDEO_HEIGHT,
		"HRES_NS_E_INVALID_VIDEO_HEIGHT",
		"The video height setting is not valid."
	},
	{
		HRES_NS_E_INVALID_VIDEO_FPS,
		"HRES_NS_E_INVALID_VIDEO_FPS",
		"The video frame rate setting is not valid."
	},
	{
		HRES_NS_E_INVALID_VIDEO_KEYFRAME,
		"HRES_NS_E_INVALID_VIDEO_KEYFRAME",
		"The video key frame setting is not valid."
	},
	{
		HRES_NS_E_INVALID_VIDEO_IQUALITY,
		"HRES_NS_E_INVALID_VIDEO_IQUALITY",
		"The video image quality setting is not valid."
	},
	{
		HRES_NS_E_INVALID_VIDEO_CQUALITY,
		"HRES_NS_E_INVALID_VIDEO_CQUALITY",
		"The video codec quality setting is not valid."
	},
	{
		HRES_NS_E_INVALID_VIDEO_BUFFER,
		"HRES_NS_E_INVALID_VIDEO_BUFFER",
		"The video buffer setting is not valid."
	},
	{
		HRES_NS_E_INVALID_VIDEO_BUFFERMAX,
		"HRES_NS_E_INVALID_VIDEO_BUFFERMAX",
		"The setting for the maximum buffer size for video is not valid."
	},
	{
		HRES_NS_E_INVALID_VIDEO_BUFFERMAX_2,
		"HRES_NS_E_INVALID_VIDEO_BUFFERMAX_2",
		"The value of the video maximum buffer size setting must be greater than the video buffer size setting."
	},
	{
		HRES_NS_E_INVALID_VIDEO_WIDTH_ALIGN,
		"HRES_NS_E_INVALID_VIDEO_WIDTH_ALIGN",
		"The alignment of the video width is not valid."
	},
	{
		HRES_NS_E_INVALID_VIDEO_HEIGHT_ALIGN,
		"HRES_NS_E_INVALID_VIDEO_HEIGHT_ALIGN",
		"The alignment of the video height is not valid."
	},
	{
		HRES_NS_E_MULTIPLE_SCRIPT_BITRATES,
		"HRES_NS_E_MULTIPLE_SCRIPT_BITRATES",
		"All bit rates must have the same script bit rate."
	},
	{
		HRES_NS_E_INVALID_SCRIPT_BITRATE,
		"HRES_NS_E_INVALID_SCRIPT_BITRATE",
		"The script bit rate specified is not valid."
	},
	{
		HRES_NS_E_MULTIPLE_FILE_BITRATES,
		"HRES_NS_E_MULTIPLE_FILE_BITRATES",
		"All bit rates must have the same file transfer bit rate."
	},
	{
		HRES_NS_E_INVALID_FILE_BITRATE,
		"HRES_NS_E_INVALID_FILE_BITRATE",
		"The file transfer bit rate is not valid."
	},
	{
		HRES_NS_E_SAME_AS_INPUT_COMBINATION,
		"HRES_NS_E_SAME_AS_INPUT_COMBINATION",
		"All audiences in a profile should either be same as input or have video width and height specified."
	},
	{
		HRES_NS_E_SOURCE_CANNOT_LOOP,
		"HRES_NS_E_SOURCE_CANNOT_LOOP",
		"This source type does not support looping."
	},
	{
		HRES_NS_E_INVALID_FOLDDOWN_COEFFICIENTS,
		"HRES_NS_E_INVALID_FOLDDOWN_COEFFICIENTS",
		"The fold-down value needs to be between -144 and 0."
	},
	{
		HRES_NS_E_DRMPROFILE_NOTFOUND,
		"HRES_NS_E_DRMPROFILE_NOTFOUND",
		"The specified DRM profile does not exist in the system."
	},
	{
		HRES_NS_E_INVALID_TIMECODE,
		"HRES_NS_E_INVALID_TIMECODE",
		"The specified time code is not valid."
	},
	{
		HRES_NS_E_NO_AUDIO_TIMECOMPRESSION,
		"HRES_NS_E_NO_AUDIO_TIMECOMPRESSION",
		"It is not possible to apply time compression to a video-only session."
	},
	{
		HRES_NS_E_NO_TWOPASS_TIMECOMPRESSION,
		"HRES_NS_E_NO_TWOPASS_TIMECOMPRESSION",
		"It is not possible to apply time compression to a session that is using two-pass encoding."
	},
	{
		HRES_NS_E_TIMECODE_REQUIRES_VIDEOSTREAM,
		"HRES_NS_E_TIMECODE_REQUIRES_VIDEOSTREAM",
		"It is not possible to generate a time code for an audio-only session."
	},
	{
		HRES_NS_E_NO_MBR_WITH_TIMECODE,
		"HRES_NS_E_NO_MBR_WITH_TIMECODE",
		"It is not possible to generate a time code when you are encoding content at multiple bit rates."
	},
	{
		HRES_NS_E_INVALID_INTERLACEMODE,
		"HRES_NS_E_INVALID_INTERLACEMODE",
		"The video codec selected does not support maintaining interlacing in video."
	},
	{
		HRES_NS_E_INVALID_INTERLACE_COMPAT,
		"HRES_NS_E_INVALID_INTERLACE_COMPAT",
		"Maintaining interlacing in video is not compatible with Windows Media Player 7.1."
	},
	{
		HRES_NS_E_INVALID_NONSQUAREPIXEL_COMPAT,
		"HRES_NS_E_INVALID_NONSQUAREPIXEL_COMPAT",
		"Allowing nonsquare pixel output is not compatible with Windows Media Player 7.1."
	},
	{
		HRES_NS_E_INVALID_SOURCE_WITH_DEVICE_CONTROL,
		"HRES_NS_E_INVALID_SOURCE_WITH_DEVICE_CONTROL",
		"Only capture devices can be used with device control."
	},
	{
		HRES_NS_E_CANNOT_GENERATE_BROADCAST_INFO_FOR_QUALITYVBR,
		"HRES_NS_E_CANNOT_GENERATE_BROADCAST_INFO_FOR_QUALITYVBR",
		"It is not possible to generate the stream format file if you are using quality-based VBR encoding for the audio or video stream. Instead use the Windows Media file generated after encoding to create the announcement file."
	},
	{
		HRES_NS_E_EXCEED_MAX_DRM_PROFILE_LIMIT,
		"HRES_NS_E_EXCEED_MAX_DRM_PROFILE_LIMIT",
		"It is not possible to create a DRM profile because the maximum number of profiles has been reached. You must delete some DRM profiles before creating new ones."
	},
	{
		HRES_NS_E_DEVICECONTROL_UNSTABLE,
		"HRES_NS_E_DEVICECONTROL_UNSTABLE",
		"The device is in an unstable state. Check that the device is functioning properly and a tape is in place."
	},
	{
		HRES_NS_E_INVALID_PIXEL_ASPECT_RATIO,
		"HRES_NS_E_INVALID_PIXEL_ASPECT_RATIO",
		"The pixel aspect ratio value must be between 1 and 255."
	},
	{
		HRES_NS_E_AUDIENCE__LANGUAGE_CONTENTTYPE_MISMATCH,
		"HRES_NS_E_AUDIENCE__LANGUAGE_CONTENTTYPE_MISMATCH",
		"All streams with different languages in the same audience must have same properties."
	},
	{
		HRES_NS_E_INVALID_PROFILE_CONTENTTYPE,
		"HRES_NS_E_INVALID_PROFILE_CONTENTTYPE",
		"The profile must contain at least one audio or video stream."
	},
	{
		HRES_NS_E_TRANSFORM_PLUGIN_NOT_FOUND,
		"HRES_NS_E_TRANSFORM_PLUGIN_NOT_FOUND",
		"The transform plug-in could not be found."
	},
	{
		HRES_NS_E_TRANSFORM_PLUGIN_INVALID,
		"HRES_NS_E_TRANSFORM_PLUGIN_INVALID",
		"The transform plug-in is not valid. It might be damaged or you might not have the required permissions to access the plug-in."
	},
	{
		HRES_NS_E_EDL_REQUIRED_FOR_DEVICE_MULTIPASS,
		"HRES_NS_E_EDL_REQUIRED_FOR_DEVICE_MULTIPASS",
		"To use two-pass encoding, you must enable device control and setup an edit decision list (EDL) that has at least one entry."
	},
	{
		HRES_NS_E_INVALID_VIDEO_WIDTH_FOR_INTERLACED_ENCODING,
		"HRES_NS_E_INVALID_VIDEO_WIDTH_FOR_INTERLACED_ENCODING",
		"When you choose to maintain the interlacing in your video, the output video size must be a multiple of 4."
	},
	{
		HRES_NS_E_MARKIN_UNSUPPORTED,
		"HRES_NS_E_MARKIN_UNSUPPORTED",
		"Markin/Markout is unsupported with this source type."
	},
	{
		HRES_NS_E_DRM_INVALID_APPLICATION,
		"HRES_NS_E_DRM_INVALID_APPLICATION",
		"A problem has occurred in the Digital Rights Management component. Contact product support for this application."
	},
	{
		HRES_NS_E_DRM_LICENSE_STORE_ERROR,
		"HRES_NS_E_DRM_LICENSE_STORE_ERROR",
		"License storage is not working. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_SECURE_STORE_ERROR,
		"HRES_NS_E_DRM_SECURE_STORE_ERROR",
		"Secure storage is not working. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_LICENSE_STORE_SAVE_ERROR,
		"HRES_NS_E_DRM_LICENSE_STORE_SAVE_ERROR",
		"License acquisition did not work. Acquire a new license or contact the content provider for further assistance."
	},
	{
		HRES_NS_E_DRM_SECURE_STORE_UNLOCK_ERROR,
		"HRES_NS_E_DRM_SECURE_STORE_UNLOCK_ERROR",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_INVALID_CONTENT,
		"HRES_NS_E_DRM_INVALID_CONTENT",
		"The media file is corrupted. Contact the content provider to get a new file."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_OPEN_LICENSE,
		"HRES_NS_E_DRM_UNABLE_TO_OPEN_LICENSE",
		"The license is corrupted. Acquire a new license."
	},
	{
		HRES_NS_E_DRM_INVALID_LICENSE,
		"HRES_NS_E_DRM_INVALID_LICENSE",
		"The license is corrupted or invalid. Acquire a new license"
	},
	{
		HRES_NS_E_DRM_INVALID_MACHINE,
		"HRES_NS_E_DRM_INVALID_MACHINE",
		"Licenses cannot be copied from one computer to another. Use License Management to transfer licenses, or get a new license for the media file."
	},
	{
		HRES_NS_E_DRM_ENUM_LICENSE_FAILED,
		"HRES_NS_E_DRM_ENUM_LICENSE_FAILED",
		"License storage is not working. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_INVALID_LICENSE_REQUEST,
		"HRES_NS_E_DRM_INVALID_LICENSE_REQUEST",
		"The media file is corrupted. Contact the content provider to get a new file."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_INITIALIZE,
		"HRES_NS_E_DRM_UNABLE_TO_INITIALIZE",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_ACQUIRE_LICENSE,
		"HRES_NS_E_DRM_UNABLE_TO_ACQUIRE_LICENSE",
		"The license could not be acquired. Try again later."
	},
	{
		HRES_NS_E_DRM_INVALID_LICENSE_ACQUIRED,
		"HRES_NS_E_DRM_INVALID_LICENSE_ACQUIRED",
		"License acquisition did not work. Acquire a new license or contact the content provider for further assistance."
	},
	{
		HRES_NS_E_DRM_NO_RIGHTS,
		"HRES_NS_E_DRM_NO_RIGHTS",
		"The requested operation cannot be performed on this file."
	},
	{
		HRES_NS_E_DRM_KEY_ERROR,
		"HRES_NS_E_DRM_KEY_ERROR",
		"The requested action cannot be performed because a problem occurred with the Windows Media Digital Rights Management (DRM) components on your computer."
	},
	{
		HRES_NS_E_DRM_ENCRYPT_ERROR,
		"HRES_NS_E_DRM_ENCRYPT_ERROR",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_DECRYPT_ERROR,
		"HRES_NS_E_DRM_DECRYPT_ERROR",
		"The media file is corrupted. Contact the content provider to get a new file."
	},
	{
		HRES_NS_E_DRM_LICENSE_INVALID_XML,
		"HRES_NS_E_DRM_LICENSE_INVALID_XML",
		"The license is corrupted. Acquire a new license."
	},
	{
		HRES_NS_E_DRM_NEEDS_INDIVIDUALIZATION,
		"HRES_NS_E_DRM_NEEDS_INDIVIDUALIZATION",
		"A security upgrade is required to perform the operation on this media file."
	},
	{
		HRES_NS_E_DRM_ALREADY_INDIVIDUALIZED,
		"HRES_NS_E_DRM_ALREADY_INDIVIDUALIZED",
		"You already have the latest security components. No upgrade is necessary at this time."
	},
	{
		HRES_NS_E_DRM_ACTION_NOT_QUERIED,
		"HRES_NS_E_DRM_ACTION_NOT_QUERIED",
		"The application cannot perform this action. Contact product support for this application."
	},
	{
		HRES_NS_E_DRM_ACQUIRING_LICENSE,
		"HRES_NS_E_DRM_ACQUIRING_LICENSE",
		"You cannot begin a new license acquisition process until the current one has been completed."
	},
	{
		HRES_NS_E_DRM_INDIVIDUALIZING,
		"HRES_NS_E_DRM_INDIVIDUALIZING",
		"You cannot begin a new security upgrade until the current one has been completed."
	},
	{
		HRES_NS_E_BACKUP_RESTORE_FAILURE,
		"HRES_NS_E_BACKUP_RESTORE_FAILURE",
		"Failure in Backup-Restore."
	},
	{
		HRES_NS_E_BACKUP_RESTORE_BAD_REQUEST_ID,
		"HRES_NS_E_BACKUP_RESTORE_BAD_REQUEST_ID",
		"Bad Request ID in Backup-Restore."
	},
	{
		HRES_NS_E_DRM_PARAMETERS_MISMATCHED,
		"HRES_NS_E_DRM_PARAMETERS_MISMATCHED",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_LICENSE_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_LICENSE_OBJECT",
		"A license cannot be created for this media file. Reinstall the application."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_INDI_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_INDI_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_ENCRYPT_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_ENCRYPT_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_DECRYPT_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_DECRYPT_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_PROPERTIES_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_PROPERTIES_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_BACKUP_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_BACKUP_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_INDIVIDUALIZE_ERROR,
		"HRES_NS_E_DRM_INDIVIDUALIZE_ERROR",
		"The security upgrade failed. Try again later."
	},
	{
		HRES_NS_E_DRM_LICENSE_OPEN_ERROR,
		"HRES_NS_E_DRM_LICENSE_OPEN_ERROR",
		"License storage is not working. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_LICENSE_CLOSE_ERROR,
		"HRES_NS_E_DRM_LICENSE_CLOSE_ERROR",
		"License storage is not working. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_GET_LICENSE_ERROR,
		"HRES_NS_E_DRM_GET_LICENSE_ERROR",
		"License storage is not working. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_QUERY_ERROR,
		"HRES_NS_E_DRM_QUERY_ERROR",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_REPORT_ERROR,
		"HRES_NS_E_DRM_REPORT_ERROR",
		"A problem has occurred in the Digital Rights Management component. Contact product support for this application."
	},
	{
		HRES_NS_E_DRM_GET_LICENSESTRING_ERROR,
		"HRES_NS_E_DRM_GET_LICENSESTRING_ERROR",
		"License storage is not working. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_GET_CONTENTSTRING_ERROR,
		"HRES_NS_E_DRM_GET_CONTENTSTRING_ERROR",
		"The media file is corrupted. Contact the content provider to get a new file."
	},
	{
		HRES_NS_E_DRM_MONITOR_ERROR,
		"HRES_NS_E_DRM_MONITOR_ERROR",
		"A problem has occurred in the Digital Rights Management component. Try again later."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_SET_PARAMETER,
		"HRES_NS_E_DRM_UNABLE_TO_SET_PARAMETER",
		"The application has made an invalid call to the Digital Rights Management component. Contact product support for this application."
	},
	{
		HRES_NS_E_DRM_INVALID_APPDATA,
		"HRES_NS_E_DRM_INVALID_APPDATA",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_INVALID_APPDATA_VERSION,
		"HRES_NS_E_DRM_INVALID_APPDATA_VERSION",
		"A problem has occurred in the Digital Rights Management component. Contact product support for this application."
	},
	{
		HRES_NS_E_DRM_BACKUP_EXISTS,
		"HRES_NS_E_DRM_BACKUP_EXISTS",
		"Licenses are already backed up in this location."
	},
	{
		HRES_NS_E_DRM_BACKUP_CORRUPT,
		"HRES_NS_E_DRM_BACKUP_CORRUPT",
		"One or more backed-up licenses are missing or corrupt."
	},
	{
		HRES_NS_E_DRM_BACKUPRESTORE_BUSY,
		"HRES_NS_E_DRM_BACKUPRESTORE_BUSY",
		"You cannot begin a new backup process until the current process has been completed."
	},
	{
		HRES_NS_E_BACKUP_RESTORE_BAD_DATA,
		"HRES_NS_E_BACKUP_RESTORE_BAD_DATA",
		"Bad Data sent to Backup-Restore."
	},
	{
		HRES_NS_E_DRM_LICENSE_UNUSABLE,
		"HRES_NS_E_DRM_LICENSE_UNUSABLE",
		"The license is invalid. Contact the content provider for further assistance."
	},
	{
		HRES_NS_E_DRM_INVALID_PROPERTY,
		"HRES_NS_E_DRM_INVALID_PROPERTY",
		"A required property was not set by the application. Contact product support for this application."
	},
	{
		HRES_NS_E_DRM_SECURE_STORE_NOT_FOUND,
		"HRES_NS_E_DRM_SECURE_STORE_NOT_FOUND",
		"A problem has occurred in the Digital Rights Management component of this application. Try to acquire a license again."
	},
	{
		HRES_NS_E_DRM_CACHED_CONTENT_ERROR,
		"HRES_NS_E_DRM_CACHED_CONTENT_ERROR",
		"A license cannot be found for this media file. Use License Management to transfer a license for this file from the original computer, or acquire a new license."
	},
	{
		HRES_NS_E_DRM_INDIVIDUALIZATION_INCOMPLETE,
		"HRES_NS_E_DRM_INDIVIDUALIZATION_INCOMPLETE",
		"A problem occurred during the security upgrade. Try again later."
	},
	{
		HRES_NS_E_DRM_DRIVER_AUTH_FAILURE,
		"HRES_NS_E_DRM_DRIVER_AUTH_FAILURE",
		"Certified driver components are required to play this media file. Contact Windows Update to see whether updated drivers are available for your hardware."
	},
	{
		HRES_NS_E_DRM_NEED_UPGRADE_MSSAP,
		"HRES_NS_E_DRM_NEED_UPGRADE_MSSAP",
		"One or more of the Secure Audio Path components were not found or an entry point in those components was not found."
	},
	{
		HRES_NS_E_DRM_REOPEN_CONTENT,
		"HRES_NS_E_DRM_REOPEN_CONTENT",
		"Status message: Reopen the file."
	},
	{
		HRES_NS_E_DRM_DRIVER_DIGIOUT_FAILURE,
		"HRES_NS_E_DRM_DRIVER_DIGIOUT_FAILURE",
		"Certain driver functionality is required to play this media file. Contact Windows Update to see whether updated drivers are available for your hardware."
	},
	{
		HRES_NS_E_DRM_INVALID_SECURESTORE_PASSWORD,
		"HRES_NS_E_DRM_INVALID_SECURESTORE_PASSWORD",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_APPCERT_REVOKED,
		"HRES_NS_E_DRM_APPCERT_REVOKED",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_RESTORE_FRAUD,
		"HRES_NS_E_DRM_RESTORE_FRAUD",
		"You cannot restore your license(s)."
	},
	{
		HRES_NS_E_DRM_HARDWARE_INCONSISTENT,
		"HRES_NS_E_DRM_HARDWARE_INCONSISTENT",
		"The licenses for your media files are corrupted. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_SDMI_TRIGGER,
		"HRES_NS_E_DRM_SDMI_TRIGGER",
		"To transfer this media file, you must upgrade the application."
	},
	{
		HRES_NS_E_DRM_SDMI_NOMORECOPIES,
		"HRES_NS_E_DRM_SDMI_NOMORECOPIES",
		"You cannot make any more copies of this media file."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_HEADER_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_HEADER_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_KEYS_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_KEYS_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_LICENSE_NOTACQUIRED,
		"HRES_NS_E_DRM_LICENSE_NOTACQUIRED",
		"Unable to obtain license."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_CODING_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_CODING_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_STATE_DATA_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_STATE_DATA_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_BUFFER_TOO_SMALL,
		"HRES_NS_E_DRM_BUFFER_TOO_SMALL",
		"The buffer supplied is not sufficient."
	},
	{
		HRES_NS_E_DRM_UNSUPPORTED_PROPERTY,
		"HRES_NS_E_DRM_UNSUPPORTED_PROPERTY",
		"The property requested is not supported."
	},
	{
		HRES_NS_E_DRM_ERROR_BAD_NET_RESP,
		"HRES_NS_E_DRM_ERROR_BAD_NET_RESP",
		"The specified server cannot perform the requested operation."
	},
	{
		HRES_NS_E_DRM_STORE_NOTALLSTORED,
		"HRES_NS_E_DRM_STORE_NOTALLSTORED",
		"Some of the licenses could not be stored."
	},
	{
		HRES_NS_E_DRM_SECURITY_COMPONENT_SIGNATURE_INVALID,
		"HRES_NS_E_DRM_SECURITY_COMPONENT_SIGNATURE_INVALID",
		"The Digital Rights Management security upgrade component could not be validated. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_INVALID_DATA,
		"HRES_NS_E_DRM_INVALID_DATA",
		"Invalid or corrupt data was encountered."
	},
	{
		HRES_NS_E_DRM_POLICY_DISABLE_ONLINE,
		"HRES_NS_E_DRM_POLICY_DISABLE_ONLINE",
		"The Windows Media Digital Rights Management system cannot perform the requested action because your computer or network administrator has enabled the group policy Prevent Windows Media DRM Internet Access. For assistance, contact your administrator."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_AUTHENTICATION_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_AUTHENTICATION_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_NOT_CONFIGURED,
		"HRES_NS_E_DRM_NOT_CONFIGURED",
		"Not all of the necessary properties for DRM have been set."
	},
	{
		HRES_NS_E_DRM_DEVICE_ACTIVATION_CANCELED,
		"HRES_NS_E_DRM_DEVICE_ACTIVATION_CANCELED",
		"The portable device does not have the security required to copy protected files to it. To obtain the additional security, try to copy the file to your portable device again. When a message appears, click OK."
	},
	{
		HRES_NS_E_BACKUP_RESTORE_TOO_MANY_RESETS,
		"HRES_NS_E_BACKUP_RESTORE_TOO_MANY_RESETS",
		"Too many resets in Backup-Restore."
	},
	{
		HRES_NS_E_DRM_DEBUGGING_NOT_ALLOWED,
		"HRES_NS_E_DRM_DEBUGGING_NOT_ALLOWED",
		"Running this process under a debugger while using DRM content is not allowed."
	},
	{
		HRES_NS_E_DRM_OPERATION_CANCELED,
		"HRES_NS_E_DRM_OPERATION_CANCELED",
		"The user canceled the DRM operation."
	},
	{
		HRES_NS_E_DRM_RESTRICTIONS_NOT_RETRIEVED,
		"HRES_NS_E_DRM_RESTRICTIONS_NOT_RETRIEVED",
		"The license you are using has assocaited output restrictions. This license is unusable until these restrictions are queried."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_PLAYLIST_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_PLAYLIST_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_PLAYLIST_BURN_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_PLAYLIST_BURN_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_DEVICE_REGISTRATION_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_DEVICE_REGISTRATION_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_METERING_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_METERING_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_TRACK_EXCEEDED_PLAYLIST_RESTICTION,
		"HRES_NS_E_DRM_TRACK_EXCEEDED_PLAYLIST_RESTICTION",
		"The specified track has exceeded it's specified playlist burn limit in this playlist."
	},
	{
		HRES_NS_E_DRM_TRACK_EXCEEDED_TRACKBURN_RESTRICTION,
		"HRES_NS_E_DRM_TRACK_EXCEEDED_TRACKBURN_RESTRICTION",
		"The specified track has exceeded it's track burn limit."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_GET_DEVICE_CERT,
		"HRES_NS_E_DRM_UNABLE_TO_GET_DEVICE_CERT",
		"A problem has occurred in obtaining the device's certificate. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_GET_SECURE_CLOCK,
		"HRES_NS_E_DRM_UNABLE_TO_GET_SECURE_CLOCK",
		"A problem has occurred in obtaining the device's secure clock. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_SET_SECURE_CLOCK,
		"HRES_NS_E_DRM_UNABLE_TO_SET_SECURE_CLOCK",
		"A problem has occurred in setting the device's secure clock. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_GET_SECURE_CLOCK_FROM_SERVER,
		"HRES_NS_E_DRM_UNABLE_TO_GET_SECURE_CLOCK_FROM_SERVER",
		"A problem has occurred in obtaining the secure clock from server. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_POLICY_METERING_DISABLED,
		"HRES_NS_E_DRM_POLICY_METERING_DISABLED",
		"This content requires the metering policy to be enabled."
	},
	{
		HRES_NS_E_DRM_TRANSFER_CHAINED_LICENSES_UNSUPPORTED,
		"HRES_NS_E_DRM_TRANSFER_CHAINED_LICENSES_UNSUPPORTED",
		"Transfer of chained licenses unsupported."
	},
	{
		HRES_NS_E_DRM_SDK_VERSIONMISMATCH,
		"HRES_NS_E_DRM_SDK_VERSIONMISMATCH",
		"The Digital Rights Management component is not installed properly. Reinstall the Player."
	},
	{
		HRES_NS_E_DRM_LIC_NEEDS_DEVICE_CLOCK_SET,
		"HRES_NS_E_DRM_LIC_NEEDS_DEVICE_CLOCK_SET",
		"The file could not be transferred because the device clock is not set."
	},
	{
		HRES_NS_E_LICENSE_HEADER_MISSING_URL,
		"HRES_NS_E_LICENSE_HEADER_MISSING_URL",
		"The content header is missing an acquisition URL."
	},
	{
		HRES_NS_E_DEVICE_NOT_WMDRM_DEVICE,
		"HRES_NS_E_DEVICE_NOT_WMDRM_DEVICE",
		"The current attached device does not support WMDRM."
	},
	{
		HRES_NS_E_DRM_INVALID_APPCERT,
		"HRES_NS_E_DRM_INVALID_APPCERT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_PROTOCOL_FORCEFUL_TERMINATION_ON_PETITION,
		"HRES_NS_E_DRM_PROTOCOL_FORCEFUL_TERMINATION_ON_PETITION",
		"The client application has been forcefully terminated during a DRM petition."
	},
	{
		HRES_NS_E_DRM_PROTOCOL_FORCEFUL_TERMINATION_ON_CHALLENGE,
		"HRES_NS_E_DRM_PROTOCOL_FORCEFUL_TERMINATION_ON_CHALLENGE",
		"The client application has been forcefully terminated during a DRM challenge."
	},
	{
		HRES_NS_E_DRM_CHECKPOINT_FAILED,
		"HRES_NS_E_DRM_CHECKPOINT_FAILED",
		"Secure storage protection error. Restore your licenses from a previous backup and try again."
	},
	{
		HRES_NS_E_DRM_BB_UNABLE_TO_INITIALIZE,
		"HRES_NS_E_DRM_BB_UNABLE_TO_INITIALIZE",
		"A problem has occurred in the Digital Rights Management root of trust. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_LOAD_HARDWARE_ID,
		"HRES_NS_E_DRM_UNABLE_TO_LOAD_HARDWARE_ID",
		"A problem has occurred in retrieving the Digital Rights Management machine identification. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_OPEN_DATA_STORE,
		"HRES_NS_E_DRM_UNABLE_TO_OPEN_DATA_STORE",
		"A problem has occurred in opening the Digital Rights Management data storage file. Contact Microsoft product."
	},
	{
		HRES_NS_E_DRM_DATASTORE_CORRUPT,
		"HRES_NS_E_DRM_DATASTORE_CORRUPT",
		"The Digital Rights Management data storage is not functioning properly. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_INMEMORYSTORE_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_INMEMORYSTORE_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_STUBLIB_REQUIRED,
		"HRES_NS_E_DRM_STUBLIB_REQUIRED",
		"A secured library is required to access the requested functionality."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_CERTIFICATE_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_CERTIFICATE_OBJECT",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_MIGRATION_TARGET_NOT_ONLINE,
		"HRES_NS_E_DRM_MIGRATION_TARGET_NOT_ONLINE",
		"A problem has occurred in the Digital Rights Management component during license migration. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_INVALID_MIGRATION_IMAGE,
		"HRES_NS_E_DRM_INVALID_MIGRATION_IMAGE",
		"A problem has occurred in the Digital Rights Management component during license migration. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_MIGRATION_TARGET_STATES_CORRUPTED,
		"HRES_NS_E_DRM_MIGRATION_TARGET_STATES_CORRUPTED",
		"A problem has occurred in the Digital Rights Management component during license migration. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_MIGRATION_IMPORTER_NOT_AVAILABLE,
		"HRES_NS_E_DRM_MIGRATION_IMPORTER_NOT_AVAILABLE",
		"A problem has occurred in the Digital Rights Management component during license migration. Contact Microsoft product support."
	},
	{
		HRES_NS_DRM_E_MIGRATION_UPGRADE_WITH_DIFF_SID,
		"HRES_NS_DRM_E_MIGRATION_UPGRADE_WITH_DIFF_SID",
		"A problem has occurred in the Digital Rights Management component during license migration. Contact Microsoft product support."
	},
	{
		HRES_NS_DRM_E_MIGRATION_SOURCE_MACHINE_IN_USE,
		"HRES_NS_DRM_E_MIGRATION_SOURCE_MACHINE_IN_USE",
		"The Digital Rights Management component is in use during license migration. Contact Microsoft product support."
	},
	{
		HRES_NS_DRM_E_MIGRATION_TARGET_MACHINE_LESS_THAN_LH,
		"HRES_NS_DRM_E_MIGRATION_TARGET_MACHINE_LESS_THAN_LH",
		"Licenses are being migrated to a machine running XP or downlevel OS. This operation can only be performed on Windows Vista or a later OS. Contact Microsoft product support."
	},
	{
		HRES_NS_DRM_E_MIGRATION_IMAGE_ALREADY_EXISTS,
		"HRES_NS_DRM_E_MIGRATION_IMAGE_ALREADY_EXISTS",
		"Migration Image already exists. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_HARDWAREID_MISMATCH,
		"HRES_NS_E_DRM_HARDWAREID_MISMATCH",
		"The requested action cannot be performed because a hardware configuration change has been detected by the Windows Media Digital Rights Management (DRM) components on your computer."
	},
	{
		HRES_NS_E_INVALID_DRMV2CLT_STUBLIB,
		"HRES_NS_E_INVALID_DRMV2CLT_STUBLIB",
		"The wrong stublib has been linked to an application or DLL using drmv2clt.dll."
	},
	{
		HRES_NS_E_DRM_MIGRATION_INVALID_LEGACYV2_DATA,
		"HRES_NS_E_DRM_MIGRATION_INVALID_LEGACYV2_DATA",
		"The legacy V2 data being imported is invalid."
	},
	{
		HRES_NS_E_DRM_MIGRATION_LICENSE_ALREADY_EXISTS,
		"HRES_NS_E_DRM_MIGRATION_LICENSE_ALREADY_EXISTS",
		"The license being imported already exists."
	},
	{
		HRES_NS_E_DRM_MIGRATION_INVALID_LEGACYV2_SST_PASSWORD,
		"HRES_NS_E_DRM_MIGRATION_INVALID_LEGACYV2_SST_PASSWORD",
		"The password of the Legacy V2 SST entry being imported is incorrect."
	},
	{
		HRES_NS_E_DRM_MIGRATION_NOT_SUPPORTED,
		"HRES_NS_E_DRM_MIGRATION_NOT_SUPPORTED",
		"Migration is not supported by the plugin."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_CREATE_MIGRATION_IMPORTER_OBJECT,
		"HRES_NS_E_DRM_UNABLE_TO_CREATE_MIGRATION_IMPORTER_OBJECT",
		"A migration importer cannot be created for this media file. Reinstall the application."
	},
	{
		HRES_NS_E_DRM_CHECKPOINT_MISMATCH,
		"HRES_NS_E_DRM_CHECKPOINT_MISMATCH",
		"The requested action cannot be performed because a problem occurred with the Windows Media Digital Rights Management (DRM) components on your computer."
	},
	{
		HRES_NS_E_DRM_CHECKPOINT_CORRUPT,
		"HRES_NS_E_DRM_CHECKPOINT_CORRUPT",
		"The requested action cannot be performed because a problem occurred with the Windows Media Digital Rights Management (DRM) components on your computer."
	},
	{
		HRES_NS_E_REG_FLUSH_FAILURE,
		"HRES_NS_E_REG_FLUSH_FAILURE",
		"The requested action cannot be performed because a problem occurred with the Windows Media Digital Rights Management (DRM) components on your computer."
	},
	{
		HRES_NS_E_HDS_KEY_MISMATCH,
		"HRES_NS_E_HDS_KEY_MISMATCH",
		"The requested action cannot be performed because a problem occurred with the Windows Media Digital Rights Management (DRM) components on your computer."
	},
	{
		HRES_NS_E_DRM_MIGRATION_OPERATION_CANCELLED,
		"HRES_NS_E_DRM_MIGRATION_OPERATION_CANCELLED",
		"Migration was canceled by the user."
	},
	{
		HRES_NS_E_DRM_MIGRATION_OBJECT_IN_USE,
		"HRES_NS_E_DRM_MIGRATION_OBJECT_IN_USE",
		"Migration object is already in use and cannot be called until the current operation completes."
	},
	{
		HRES_NS_E_DRM_MALFORMED_CONTENT_HEADER,
		"HRES_NS_E_DRM_MALFORMED_CONTENT_HEADER",
		"The content header does not comply with DRM requirements and cannot be used."
	},
	{
		HRES_NS_E_DRM_LICENSE_EXPIRED,
		"HRES_NS_E_DRM_LICENSE_EXPIRED",
		"The license for this file has expired and is no longer valid. Contact your content provider for further assistance."
	},
	{
		HRES_NS_E_DRM_LICENSE_NOTENABLED,
		"HRES_NS_E_DRM_LICENSE_NOTENABLED",
		"The license for this file is not valid yet, but will be at a future date."
	},
	{
		HRES_NS_E_DRM_LICENSE_APPSECLOW,
		"HRES_NS_E_DRM_LICENSE_APPSECLOW",
		"The license for this file requires a higher level of security than the player you are currently using has. Try using a different player or download a newer version of your current player."
	},
	{
		HRES_NS_E_DRM_STORE_NEEDINDI,
		"HRES_NS_E_DRM_STORE_NEEDINDI",
		"The license cannot be stored as it requires security upgrade of Digital Rights Management component."
	},
	{
		HRES_NS_E_DRM_STORE_NOTALLOWED,
		"HRES_NS_E_DRM_STORE_NOTALLOWED",
		"Your machine does not meet the requirements for storing the license."
	},
	{
		HRES_NS_E_DRM_LICENSE_APP_NOTALLOWED,
		"HRES_NS_E_DRM_LICENSE_APP_NOTALLOWED",
		"The license for this file requires an upgraded version of your player or a different player."
	},
	{
		HRES_NS_E_DRM_LICENSE_CERT_EXPIRED,
		"HRES_NS_E_DRM_LICENSE_CERT_EXPIRED",
		"The license server's certificate expired. Make sure your system clock is set correctly. Contact your content provider for further assistance."
	},
	{
		HRES_NS_E_DRM_LICENSE_SECLOW,
		"HRES_NS_E_DRM_LICENSE_SECLOW",
		"The license for this file requires a higher level of security than the player you are currently using has. Try using a different player or download a newer version of your current player."
	},
	{
		HRES_NS_E_DRM_LICENSE_CONTENT_REVOKED,
		"HRES_NS_E_DRM_LICENSE_CONTENT_REVOKED",
		"The content owner for the license you just acquired is no longer supporting their content. Contact the content owner for a newer version of the content."
	},
	{
		HRES_NS_E_DRM_DEVICE_NOT_REGISTERED,
		"HRES_NS_E_DRM_DEVICE_NOT_REGISTERED",
		"The content owner for the license you just acquired requires your device to register to the current machine."
	},
	{
		HRES_NS_E_DRM_LICENSE_NOSAP,
		"HRES_NS_E_DRM_LICENSE_NOSAP",
		"The license for this file requires a feature that is not supported in your current player or operating system. You can try with newer version of your current player or contact your content provider for further assistance."
	},
	{
		HRES_NS_E_DRM_LICENSE_NOSVP,
		"HRES_NS_E_DRM_LICENSE_NOSVP",
		"The license for this file requires a feature that is not supported in your current player or operating system. You can try with newer version of your current player or contact your content provider for further assistance."
	},
	{
		HRES_NS_E_DRM_LICENSE_NOWDM,
		"HRES_NS_E_DRM_LICENSE_NOWDM",
		"The license for this file requires Windows Driver Model (WDM) audio drivers. Contact your sound card manufacturer for further assistance."
	},
	{
		HRES_NS_E_DRM_LICENSE_NOTRUSTEDCODEC,
		"HRES_NS_E_DRM_LICENSE_NOTRUSTEDCODEC",
		"The license for this file requires a higher level of security than the player you are currently using has. Try using a different player or download a newer version of your current player."
	},
	{
		HRES_NS_E_DRM_SOURCEID_NOT_SUPPORTED,
		"HRES_NS_E_DRM_SOURCEID_NOT_SUPPORTED",
		"The license for this file is not supported by your current player. You can try with newer version of your current player or contact your content provider for further assistance."
	},
	{
		HRES_NS_E_DRM_NEEDS_UPGRADE_TEMPFILE,
		"HRES_NS_E_DRM_NEEDS_UPGRADE_TEMPFILE",
		"An updated version of your media player is required to play the selected content."
	},
	{
		HRES_NS_E_DRM_NEED_UPGRADE_PD,
		"HRES_NS_E_DRM_NEED_UPGRADE_PD",
		"A new version of the Digital Rights Management component is required. Contact product support for this application to get the latest version."
	},
	{
		HRES_NS_E_DRM_SIGNATURE_FAILURE,
		"HRES_NS_E_DRM_SIGNATURE_FAILURE",
		"Failed to either create or verify the content header."
	},
	{
		HRES_NS_E_DRM_LICENSE_SERVER_INFO_MISSING,
		"HRES_NS_E_DRM_LICENSE_SERVER_INFO_MISSING",
		"Could not read the necessary information from the system registry."
	},
	{
		HRES_NS_E_DRM_BUSY,
		"HRES_NS_E_DRM_BUSY",
		"The DRM subsystem is currently locked by another application or user. Try again later."
	},
	{
		HRES_NS_E_DRM_PD_TOO_MANY_DEVICES,
		"HRES_NS_E_DRM_PD_TOO_MANY_DEVICES",
		"There are too many target devices registered on the portable media."
	},
	{
		HRES_NS_E_DRM_INDIV_FRAUD,
		"HRES_NS_E_DRM_INDIV_FRAUD",
		"The security upgrade cannot be completed because the allowed number of daily upgrades has been exceeded. Try again tomorrow."
	},
	{
		HRES_NS_E_DRM_INDIV_NO_CABS,
		"HRES_NS_E_DRM_INDIV_NO_CABS",
		"The security upgrade cannot be completed because the server is unable to perform the operation. Try again later."
	},
	{
		HRES_NS_E_DRM_INDIV_SERVICE_UNAVAILABLE,
		"HRES_NS_E_DRM_INDIV_SERVICE_UNAVAILABLE",
		"The security upgrade cannot be performed because the server is not available. Try again later."
	},
	{
		HRES_NS_E_DRM_RESTORE_SERVICE_UNAVAILABLE,
		"HRES_NS_E_DRM_RESTORE_SERVICE_UNAVAILABLE",
		"Windows Media Player cannot restore your licenses because the server is not available. Try again later."
	},
	{
		HRES_NS_E_DRM_CLIENT_CODE_EXPIRED,
		"HRES_NS_E_DRM_CLIENT_CODE_EXPIRED",
		"Windows Media Player cannot play the protected file. Verify that your computer's date is set correctly. If it is correct, on the Help menu, click Check for Player Updates to install the latest version of the Player."
	},
	{
		HRES_NS_E_DRM_NO_UPLINK_LICENSE,
		"HRES_NS_E_DRM_NO_UPLINK_LICENSE",
		"The chained license cannot be created because the referenced uplink license does not exist."
	},
	{
		HRES_NS_E_DRM_INVALID_KID,
		"HRES_NS_E_DRM_INVALID_KID",
		"The specified KID is invalid."
	},
	{
		HRES_NS_E_DRM_LICENSE_INITIALIZATION_ERROR,
		"HRES_NS_E_DRM_LICENSE_INITIALIZATION_ERROR",
		"License initialization did not work. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_CHAIN_TOO_LONG,
		"HRES_NS_E_DRM_CHAIN_TOO_LONG",
		"The uplink license of a chained license cannot itself be a chained license."
	},
	{
		HRES_NS_E_DRM_UNSUPPORTED_ALGORITHM,
		"HRES_NS_E_DRM_UNSUPPORTED_ALGORITHM",
		"The specified encryption algorithm is unsupported."
	},
	{
		HRES_NS_E_DRM_LICENSE_DELETION_ERROR,
		"HRES_NS_E_DRM_LICENSE_DELETION_ERROR",
		"License deletion did not work. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_INVALID_CERTIFICATE,
		"HRES_NS_E_DRM_INVALID_CERTIFICATE",
		"The client's certificate is corrupted or the signature cannot be verified."
	},
	{
		HRES_NS_E_DRM_CERTIFICATE_REVOKED,
		"HRES_NS_E_DRM_CERTIFICATE_REVOKED",
		"The client's certificate has been revoked."
	},
	{
		HRES_NS_E_DRM_LICENSE_UNAVAILABLE,
		"HRES_NS_E_DRM_LICENSE_UNAVAILABLE",
		"There is no license available for the requested action."
	},
	{
		HRES_NS_E_DRM_DEVICE_LIMIT_REACHED,
		"HRES_NS_E_DRM_DEVICE_LIMIT_REACHED",
		"The maximum number of devices in use has been reached. Unable to open additional devices."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_VERIFY_PROXIMITY,
		"HRES_NS_E_DRM_UNABLE_TO_VERIFY_PROXIMITY",
		"The proximity detection procedure could not confirm that the receiver is near the transmitter in the network."
	},
	{
		HRES_NS_E_DRM_MUST_REGISTER,
		"HRES_NS_E_DRM_MUST_REGISTER",
		"The client must be registered before executing the intended operation."
	},
	{
		HRES_NS_E_DRM_MUST_APPROVE,
		"HRES_NS_E_DRM_MUST_APPROVE",
		"The client must be approved before executing the intended operation."
	},
	{
		HRES_NS_E_DRM_MUST_REVALIDATE,
		"HRES_NS_E_DRM_MUST_REVALIDATE",
		"The client must be revalidated before executing the intended operation."
	},
	{
		HRES_NS_E_DRM_INVALID_PROXIMITY_RESPONSE,
		"HRES_NS_E_DRM_INVALID_PROXIMITY_RESPONSE",
		"The response to the proximity detection challenge is invalid."
	},
	{
		HRES_NS_E_DRM_INVALID_SESSION,
		"HRES_NS_E_DRM_INVALID_SESSION",
		"The requested session is invalid."
	},
	{
		HRES_NS_E_DRM_DEVICE_NOT_OPEN,
		"HRES_NS_E_DRM_DEVICE_NOT_OPEN",
		"The device must be opened before it can be used to receive content."
	},
	{
		HRES_NS_E_DRM_DEVICE_ALREADY_REGISTERED,
		"HRES_NS_E_DRM_DEVICE_ALREADY_REGISTERED",
		"Device registration failed because the device is already registered."
	},
	{
		HRES_NS_E_DRM_UNSUPPORTED_PROTOCOL_VERSION,
		"HRES_NS_E_DRM_UNSUPPORTED_PROTOCOL_VERSION",
		"Unsupported WMDRM-ND protocol version."
	},
	{
		HRES_NS_E_DRM_UNSUPPORTED_ACTION,
		"HRES_NS_E_DRM_UNSUPPORTED_ACTION",
		"The requested action is not supported."
	},
	{
		HRES_NS_E_DRM_CERTIFICATE_SECURITY_LEVEL_INADEQUATE,
		"HRES_NS_E_DRM_CERTIFICATE_SECURITY_LEVEL_INADEQUATE",
		"The certificate does not have an adequate security level for the requested action."
	},
	{
		HRES_NS_E_DRM_UNABLE_TO_OPEN_PORT,
		"HRES_NS_E_DRM_UNABLE_TO_OPEN_PORT",
		"Unable to open the specified port for receiving Proximity messages."
	},
	{
		HRES_NS_E_DRM_BAD_REQUEST,
		"HRES_NS_E_DRM_BAD_REQUEST",
		"The message format is invalid."
	},
	{
		HRES_NS_E_DRM_INVALID_CRL,
		"HRES_NS_E_DRM_INVALID_CRL",
		"The Certificate Revocation List is invalid or corrupted."
	},
	{
		HRES_NS_E_DRM_ATTRIBUTE_TOO_LONG,
		"HRES_NS_E_DRM_ATTRIBUTE_TOO_LONG",
		"The length of the attribute name or value is too long."
	},
	{
		HRES_NS_E_DRM_EXPIRED_LICENSEBLOB,
		"HRES_NS_E_DRM_EXPIRED_LICENSEBLOB",
		"The license blob passed in the cardea request is expired."
	},
	{
		HRES_NS_E_DRM_INVALID_LICENSEBLOB,
		"HRES_NS_E_DRM_INVALID_LICENSEBLOB",
		"The license blob passed in the cardea request is invalid. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_INCLUSION_LIST_REQUIRED,
		"HRES_NS_E_DRM_INCLUSION_LIST_REQUIRED",
		"The requested operation cannot be performed because the license does not contain an inclusion list."
	},
	{
		HRES_NS_E_DRM_DRMV2CLT_REVOKED,
		"HRES_NS_E_DRM_DRMV2CLT_REVOKED",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_DRM_RIV_TOO_SMALL,
		"HRES_NS_E_DRM_RIV_TOO_SMALL",
		"A problem has occurred in the Digital Rights Management component. Contact Microsoft product support."
	},
	{
		HRES_NS_E_OUTPUT_PROTECTION_LEVEL_UNSUPPORTED,
		"HRES_NS_E_OUTPUT_PROTECTION_LEVEL_UNSUPPORTED",
		"Windows Media Player does not support the level of output protection required by the content."
	},
	{
		HRES_NS_E_COMPRESSED_DIGITAL_VIDEO_PROTECTION_LEVEL_UNSUPPORTED,
		"HRES_NS_E_COMPRESSED_DIGITAL_VIDEO_PROTECTION_LEVEL_UNSUPPORTED",
		"Windows Media Player does not support the level of protection required for compressed digital video."
	},
	{
		HRES_NS_E_UNCOMPRESSED_DIGITAL_VIDEO_PROTECTION_LEVEL_UNSUPPORTED,
		"HRES_NS_E_UNCOMPRESSED_DIGITAL_VIDEO_PROTECTION_LEVEL_UNSUPPORTED",
		"Windows Media Player does not support the level of protection required for uncompressed digital video."
	},
	{
		HRES_NS_E_ANALOG_VIDEO_PROTECTION_LEVEL_UNSUPPORTED,
		"HRES_NS_E_ANALOG_VIDEO_PROTECTION_LEVEL_UNSUPPORTED",
		"Windows Media Player does not support the level of protection required for analog video."
	},
	{
		HRES_NS_E_COMPRESSED_DIGITAL_AUDIO_PROTECTION_LEVEL_UNSUPPORTED,
		"HRES_NS_E_COMPRESSED_DIGITAL_AUDIO_PROTECTION_LEVEL_UNSUPPORTED",
		"Windows Media Player does not support the level of protection required for compressed digital audio."
	},
	{
		HRES_NS_E_UNCOMPRESSED_DIGITAL_AUDIO_PROTECTION_LEVEL_UNSUPPORTED,
		"HRES_NS_E_UNCOMPRESSED_DIGITAL_AUDIO_PROTECTION_LEVEL_UNSUPPORTED",
		"Windows Media Player does not support the level of protection required for uncompressed digital audio."
	},
	{
		HRES_NS_E_OUTPUT_PROTECTION_SCHEME_UNSUPPORTED,
		"HRES_NS_E_OUTPUT_PROTECTION_SCHEME_UNSUPPORTED",
		"Windows Media Player does not support the scheme of output protection required by the content."
	},
	{
		HRES_NS_E_REBOOT_RECOMMENDED,
		"HRES_NS_E_REBOOT_RECOMMENDED",
		"Installation was not successful and some file cleanup is not complete. For best results, restart your computer."
	},
	{
		HRES_NS_E_REBOOT_REQUIRED,
		"HRES_NS_E_REBOOT_REQUIRED",
		"Installation was not successful. To continue, you must restart your computer."
	},
	{
		HRES_NS_E_SETUP_INCOMPLETE,
		"HRES_NS_E_SETUP_INCOMPLETE",
		"Installation was not successful."
	},
	{
		HRES_NS_E_SETUP_DRM_MIGRATION_FAILED,
		"HRES_NS_E_SETUP_DRM_MIGRATION_FAILED",
		"Setup cannot migrate the Windows Media Digital Rights Management (DRM) components."
	},
	{
		HRES_NS_E_SETUP_IGNORABLE_FAILURE,
		"HRES_NS_E_SETUP_IGNORABLE_FAILURE",
		"Some skin or playlist components cannot be installed."
	},
	{
		HRES_NS_E_SETUP_DRM_MIGRATION_FAILED_AND_IGNORABLE_FAILURE,
		"HRES_NS_E_SETUP_DRM_MIGRATION_FAILED_AND_IGNORABLE_FAILURE",
		"Setup cannot migrate the Windows Media Digital Rights Management (DRM) components. In addition, some skin or playlist components cannot be installed."
	},
	{
		HRES_NS_E_SETUP_BLOCKED,
		"HRES_NS_E_SETUP_BLOCKED",
		"Installation is blocked because your computer does not meet one or more of the setup requirements."
	},
	{
		HRES_NS_E_UNKNOWN_PROTOCOL,
		"HRES_NS_E_UNKNOWN_PROTOCOL",
		"The specified protocol is not supported."
	},
	{
		HRES_NS_E_REDIRECT_TO_PROXY,
		"HRES_NS_E_REDIRECT_TO_PROXY",
		"The client is redirected to a proxy server."
	},
	{
		HRES_NS_E_INTERNAL_SERVER_ERROR,
		"HRES_NS_E_INTERNAL_SERVER_ERROR",
		"The server encountered an unexpected condition which prevented it from fulfilling the request."
	},
	{
		HRES_NS_E_BAD_REQUEST,
		"HRES_NS_E_BAD_REQUEST",
		"The request could not be understood by the server."
	},
	{
		HRES_NS_E_ERROR_FROM_PROXY,
		"HRES_NS_E_ERROR_FROM_PROXY",
		"The proxy experienced an error while attempting to contact the media server."
	},
	{
		HRES_NS_E_PROXY_TIMEOUT,
		"HRES_NS_E_PROXY_TIMEOUT",
		"The proxy did not receive a timely response while attempting to contact the media server."
	},
	{
		HRES_NS_E_SERVER_UNAVAILABLE,
		"HRES_NS_E_SERVER_UNAVAILABLE",
		"The server is currently unable to handle the request due to a temporary overloading or maintenance of the server."
	},
	{
		HRES_NS_E_REFUSED_BY_SERVER,
		"HRES_NS_E_REFUSED_BY_SERVER",
		"The server is refusing to fulfill the requested operation."
	},
	{
		HRES_NS_E_INCOMPATIBLE_SERVER,
		"HRES_NS_E_INCOMPATIBLE_SERVER",
		"The server is not a compatible streaming media server."
	},
	{
		HRES_NS_E_MULTICAST_DISABLED,
		"HRES_NS_E_MULTICAST_DISABLED",
		"The content cannot be streamed because the Multicast protocol has been disabled."
	},
	{
		HRES_NS_E_INVALID_REDIRECT,
		"HRES_NS_E_INVALID_REDIRECT",
		"The server redirected the player to an invalid location."
	},
	{
		HRES_NS_E_ALL_PROTOCOLS_DISABLED,
		"HRES_NS_E_ALL_PROTOCOLS_DISABLED",
		"The content cannot be streamed because all protocols have been disabled."
	},
	{
		HRES_NS_E_MSBD_NO_LONGER_SUPPORTED,
		"HRES_NS_E_MSBD_NO_LONGER_SUPPORTED",
		"The MSBD protocol is no longer supported. Please use HTTP to connect to the Windows Media stream."
	},
	{
		HRES_NS_E_PROXY_NOT_FOUND,
		"HRES_NS_E_PROXY_NOT_FOUND",
		"The proxy server could not be located. Please check your proxy server configuration."
	},
	{
		HRES_NS_E_CANNOT_CONNECT_TO_PROXY,
		"HRES_NS_E_CANNOT_CONNECT_TO_PROXY",
		"Unable to establish a connection to the proxy server. Please check your proxy server configuration."
	},
	{
		HRES_NS_E_SERVER_DNS_TIMEOUT,
		"HRES_NS_E_SERVER_DNS_TIMEOUT",
		"Unable to locate the media server. The operation timed out."
	},
	{
		HRES_NS_E_PROXY_DNS_TIMEOUT,
		"HRES_NS_E_PROXY_DNS_TIMEOUT",
		"Unable to locate the proxy server. The operation timed out."
	},
	{
		HRES_NS_E_CLOSED_ON_SUSPEND,
		"HRES_NS_E_CLOSED_ON_SUSPEND",
		"Media closed because Windows was shut down."
	},
	{
		HRES_NS_E_CANNOT_READ_PLAYLIST_FROM_MEDIASERVER,
		"HRES_NS_E_CANNOT_READ_PLAYLIST_FROM_MEDIASERVER",
		"Unable to read the contents of a playlist file from a media server."
	},
	{
		HRES_NS_E_SESSION_NOT_FOUND,
		"HRES_NS_E_SESSION_NOT_FOUND",
		"Session not found."
	},
	{
		HRES_NS_E_REQUIRE_STREAMING_CLIENT,
		"HRES_NS_E_REQUIRE_STREAMING_CLIENT",
		"Content requires a streaming media client."
	},
	{
		HRES_NS_E_PLAYLIST_ENTRY_HAS_CHANGED,
		"HRES_NS_E_PLAYLIST_ENTRY_HAS_CHANGED",
		"A command applies to a previous playlist entry."
	},
	{
		HRES_NS_E_PROXY_ACCESSDENIED,
		"HRES_NS_E_PROXY_ACCESSDENIED",
		"The proxy server is denying access. The username and/or password might be incorrect."
	},
	{
		HRES_NS_E_PROXY_SOURCE_ACCESSDENIED,
		"HRES_NS_E_PROXY_SOURCE_ACCESSDENIED",
		"The proxy could not provide valid authentication credentials to the media server."
	},
	{
		HRES_NS_E_NETWORK_SINK_WRITE,
		"HRES_NS_E_NETWORK_SINK_WRITE",
		"The network sink failed to write data to the network."
	},
	{
		HRES_NS_E_FIREWALL,
		"HRES_NS_E_FIREWALL",
		"Packets are not being received from the server. The packets might be blocked by a filtering device, such as a network firewall."
	},
	{
		HRES_NS_E_MMS_NOT_SUPPORTED,
		"HRES_NS_E_MMS_NOT_SUPPORTED",
		"The MMS protocol is not supported. Please use HTTP or RTSP to connect to the Windows Media stream."
	},
	{
		HRES_NS_E_SERVER_ACCESSDENIED,
		"HRES_NS_E_SERVER_ACCESSDENIED",
		"The Windows Media server is denying access. The username and/or password might be incorrect."
	},
	{
		HRES_NS_E_RESOURCE_GONE,
		"HRES_NS_E_RESOURCE_GONE",
		"The Publishing Point or file on the Windows Media Server is no longer available."
	},
	{
		HRES_NS_E_NO_EXISTING_PACKETIZER,
		"HRES_NS_E_NO_EXISTING_PACKETIZER",
		"There is no existing packetizer plugin for a stream."
	},
	{
		HRES_NS_E_BAD_SYNTAX_IN_SERVER_RESPONSE,
		"HRES_NS_E_BAD_SYNTAX_IN_SERVER_RESPONSE",
		"The response from the media server could not be understood. This might be caused by an incompatible proxy server or media server."
	},
	{
		HRES_NS_E_RESET_SOCKET_CONNECTION,
		"HRES_NS_E_RESET_SOCKET_CONNECTION",
		"The Windows Media Server reset the network connection."
	},
	{
		HRES_NS_E_TOO_MANY_HOPS,
		"HRES_NS_E_TOO_MANY_HOPS",
		"The request could not reach the media server (too many hops)."
	},
	{
		HRES_NS_E_TOO_MUCH_DATA_FROM_SERVER,
		"HRES_NS_E_TOO_MUCH_DATA_FROM_SERVER",
		"The server is sending too much data. The connection has been terminated."
	},
	{
		HRES_NS_E_CONNECT_TIMEOUT,
		"HRES_NS_E_CONNECT_TIMEOUT",
		"It was not possible to establish a connection to the media server in a timely manner. The media server might be down for maintenance, or it might be necessary to use a proxy server to access this media server."
	},
	{
		HRES_NS_E_PROXY_CONNECT_TIMEOUT,
		"HRES_NS_E_PROXY_CONNECT_TIMEOUT",
		"It was not possible to establish a connection to the proxy server in a timely manner. Please check your proxy server configuration."
	},
	{
		HRES_NS_E_SESSION_INVALID,
		"HRES_NS_E_SESSION_INVALID",
		"Session not found."
	},
	{
		HRES_NS_E_PACKETSINK_UNKNOWN_FEC_STREAM,
		"HRES_NS_E_PACKETSINK_UNKNOWN_FEC_STREAM",
		"Unknown packet sink stream."
	},
	{
		HRES_NS_E_PUSH_CANNOTCONNECT,
		"HRES_NS_E_PUSH_CANNOTCONNECT",
		"Unable to establish a connection to the server. Ensure Windows Media Services is started and the HTTP Server control protocol is properly enabled."
	},
	{
		HRES_NS_E_INCOMPATIBLE_PUSH_SERVER,
		"HRES_NS_E_INCOMPATIBLE_PUSH_SERVER",
		"The Server service that received the HTTP push request is not a compatible version of Windows Media Services (WMS). This error might indicate the push request was received by IIS instead of WMS. Ensure WMS is started and has the HTTP Server control protocol properly enabled and try again."
	},
	{
		HRES_NS_E_END_OF_PLAYLIST,
		"HRES_NS_E_END_OF_PLAYLIST",
		"The playlist has reached its end."
	},
	{
		HRES_NS_E_USE_FILE_SOURCE,
		"HRES_NS_E_USE_FILE_SOURCE",
		"Use file source."
	},
	{
		HRES_NS_E_PROPERTY_NOT_FOUND,
		"HRES_NS_E_PROPERTY_NOT_FOUND",
		"The property was not found."
	},
	{
		HRES_NS_E_PROPERTY_READ_ONLY,
		"HRES_NS_E_PROPERTY_READ_ONLY",
		"The property is read only."
	},
	{
		HRES_NS_E_TABLE_KEY_NOT_FOUND,
		"HRES_NS_E_TABLE_KEY_NOT_FOUND",
		"The table key was not found."
	},
	{
		HRES_NS_E_INVALID_QUERY_OPERATOR,
		"HRES_NS_E_INVALID_QUERY_OPERATOR",
		"Invalid query operator."
	},
	{
		HRES_NS_E_INVALID_QUERY_PROPERTY,
		"HRES_NS_E_INVALID_QUERY_PROPERTY",
		"Invalid query property."
	},
	{
		HRES_NS_E_PROPERTY_NOT_SUPPORTED,
		"HRES_NS_E_PROPERTY_NOT_SUPPORTED",
		"The property is not supported."
	},
	{
		HRES_NS_E_SCHEMA_CLASSIFY_FAILURE,
		"HRES_NS_E_SCHEMA_CLASSIFY_FAILURE",
		"Schema classification failure."
	},
	{
		HRES_NS_E_METADATA_FORMAT_NOT_SUPPORTED,
		"HRES_NS_E_METADATA_FORMAT_NOT_SUPPORTED",
		"The metadata format is not supported."
	},
	{
		HRES_NS_E_METADATA_NO_EDITING_CAPABILITY,
		"HRES_NS_E_METADATA_NO_EDITING_CAPABILITY",
		"Cannot edit the metadata."
	},
	{
		HRES_NS_E_METADATA_CANNOT_SET_LOCALE,
		"HRES_NS_E_METADATA_CANNOT_SET_LOCALE",
		"Cannot set the locale id."
	},
	{
		HRES_NS_E_METADATA_LANGUAGE_NOT_SUPORTED,
		"HRES_NS_E_METADATA_LANGUAGE_NOT_SUPORTED",
		"The language is not supported in the format."
	},
	{
		HRES_NS_E_METADATA_NO_RFC1766_NAME_FOR_LOCALE,
		"HRES_NS_E_METADATA_NO_RFC1766_NAME_FOR_LOCALE",
		"There is no RFC1766 name translation for the supplied locale id."
	},
	{
		HRES_NS_E_METADATA_NOT_AVAILABLE,
		"HRES_NS_E_METADATA_NOT_AVAILABLE",
		"The metadata (or metadata item) is not available."
	},
	{
		HRES_NS_E_METADATA_CACHE_DATA_NOT_AVAILABLE,
		"HRES_NS_E_METADATA_CACHE_DATA_NOT_AVAILABLE",
		"The cached metadata (or metadata item) is not available."
	},
	{
		HRES_NS_E_METADATA_INVALID_DOCUMENT_TYPE,
		"HRES_NS_E_METADATA_INVALID_DOCUMENT_TYPE",
		"The metadata document is invalid."
	},
	{
		HRES_NS_E_METADATA_IDENTIFIER_NOT_AVAILABLE,
		"HRES_NS_E_METADATA_IDENTIFIER_NOT_AVAILABLE",
		"The metadata content identifier is not available."
	},
	{
		HRES_NS_E_METADATA_CANNOT_RETRIEVE_FROM_OFFLINE_CACHE,
		"HRES_NS_E_METADATA_CANNOT_RETRIEVE_FROM_OFFLINE_CACHE",
		"Cannot retrieve metadata from the offline metadata cache."
	},
	{
		HRES_ERROR_MONITOR_INVALID_DESCRIPTOR_CHECKSUM,
		"HRES_ERROR_MONITOR_INVALID_DESCRIPTOR_CHECKSUM",
		"Checksum of the obtained monitor descriptor is invalid."
	},
	{
		HRES_ERROR_MONITOR_INVALID_STANDARD_TIMING_BLOCK,
		"HRES_ERROR_MONITOR_INVALID_STANDARD_TIMING_BLOCK",
		"Monitor descriptor contains an invalid standard timing block."
	},
	{
		HRES_ERROR_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED,
		"HRES_ERROR_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED",
		"Windows Management Instrumentation (WMI) data block registration failed for one of the MSMonitorClass WMI subclasses."
	},
	{
		HRES_ERROR_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK,
		"HRES_ERROR_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK",
		"Provided monitor descriptor block is either corrupted or does not contain the monitor's detailed serial number."
	},
	{
		HRES_ERROR_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK,
		"HRES_ERROR_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK",
		"Provided monitor descriptor block is either corrupted or does not contain the monitor's user-friendly name."
	},
	{
		HRES_ERROR_MONITOR_NO_MORE_DESCRIPTOR_DATA,
		"HRES_ERROR_MONITOR_NO_MORE_DESCRIPTOR_DATA",
		"There is no monitor descriptor data at the specified (offset, size) region."
	},
	{
		HRES_ERROR_MONITOR_INVALID_DETAILED_TIMING_BLOCK,
		"HRES_ERROR_MONITOR_INVALID_DETAILED_TIMING_BLOCK",
		"Monitor descriptor contains an invalid detailed timing block."
	},
	{
		HRES_ERROR_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER,
		"HRES_ERROR_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER",
		"Exclusive mode ownership is needed to create unmanaged primary allocation."
	},
	{
		HRES_ERROR_GRAPHICS_INSUFFICIENT_DMA_BUFFER,
		"HRES_ERROR_GRAPHICS_INSUFFICIENT_DMA_BUFFER",
		"The driver needs more direct memory access (DMA) buffer space to complete the requested operation."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_DISPLAY_ADAPTER,
		"HRES_ERROR_GRAPHICS_INVALID_DISPLAY_ADAPTER",
		"Specified display adapter handle is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_ADAPTER_WAS_RESET,
		"HRES_ERROR_GRAPHICS_ADAPTER_WAS_RESET",
		"Specified display adapter and all of its state has been reset."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_DRIVER_MODEL,
		"HRES_ERROR_GRAPHICS_INVALID_DRIVER_MODEL",
		"The driver stack does not match the expected driver model."
	},
	{
		HRES_ERROR_GRAPHICS_PRESENT_MODE_CHANGED,
		"HRES_ERROR_GRAPHICS_PRESENT_MODE_CHANGED",
		"Present happened but ended up into the changed desktop mode."
	},
	{
		HRES_ERROR_GRAPHICS_PRESENT_OCCLUDED,
		"HRES_ERROR_GRAPHICS_PRESENT_OCCLUDED",
		"Nothing to present due to desktop occlusion."
	},
	{
		HRES_ERROR_GRAPHICS_PRESENT_DENIED,
		"HRES_ERROR_GRAPHICS_PRESENT_DENIED",
		"Not able to present due to denial of desktop access."
	},
	{
		HRES_ERROR_GRAPHICS_CANNOTCOLORCONVERT,
		"HRES_ERROR_GRAPHICS_CANNOTCOLORCONVERT",
		"Not able to present with color conversion."
	},
	{
		HRES_ERROR_GRAPHICS_NO_VIDEO_MEMORY,
		"HRES_ERROR_GRAPHICS_NO_VIDEO_MEMORY",
		"Not enough video memory available to complete the operation."
	},
	{
		HRES_ERROR_GRAPHICS_CANT_LOCK_MEMORY,
		"HRES_ERROR_GRAPHICS_CANT_LOCK_MEMORY",
		"Could not probe and lock the underlying memory of an allocation."
	},
	{
		HRES_ERROR_GRAPHICS_ALLOCATION_BUSY,
		"HRES_ERROR_GRAPHICS_ALLOCATION_BUSY",
		"The allocation is currently busy."
	},
	{
		HRES_ERROR_GRAPHICS_TOO_MANY_REFERENCES,
		"HRES_ERROR_GRAPHICS_TOO_MANY_REFERENCES",
		"An object being referenced has reach the maximum reference count already and cannot be referenced further."
	},
	{
		HRES_ERROR_GRAPHICS_TRY_AGAIN_LATER,
		"HRES_ERROR_GRAPHICS_TRY_AGAIN_LATER",
		"A problem could not be solved due to some currently existing condition. The problem should be tried again later."
	},
	{
		HRES_ERROR_GRAPHICS_TRY_AGAIN_NOW,
		"HRES_ERROR_GRAPHICS_TRY_AGAIN_NOW",
		"A problem could not be solved due to some currently existing condition. The problem should be tried again immediately."
	},
	{
		HRES_ERROR_GRAPHICS_ALLOCATION_INVALID,
		"HRES_ERROR_GRAPHICS_ALLOCATION_INVALID",
		"The allocation is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE,
		"HRES_ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE",
		"No more unswizzling apertures are currently available."
	},
	{
		HRES_ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED,
		"HRES_ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED",
		"The current allocation cannot be unswizzled by an aperture."
	},
	{
		HRES_ERROR_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION,
		"HRES_ERROR_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION",
		"The request failed because a pinned allocation cannot be evicted."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_ALLOCATION_USAGE,
		"HRES_ERROR_GRAPHICS_INVALID_ALLOCATION_USAGE",
		"The allocation cannot be used from its current segment location for the specified operation."
	},
	{
		HRES_ERROR_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION,
		"HRES_ERROR_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION",
		"A locked allocation cannot be used in the current command buffer."
	},
	{
		HRES_ERROR_GRAPHICS_ALLOCATION_CLOSED,
		"HRES_ERROR_GRAPHICS_ALLOCATION_CLOSED",
		"The allocation being referenced has been closed permanently."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_ALLOCATION_INSTANCE,
		"HRES_ERROR_GRAPHICS_INVALID_ALLOCATION_INSTANCE",
		"An invalid allocation instance is being referenced."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_ALLOCATION_HANDLE,
		"HRES_ERROR_GRAPHICS_INVALID_ALLOCATION_HANDLE",
		"An invalid allocation handle is being referenced."
	},
	{
		HRES_ERROR_GRAPHICS_WRONG_ALLOCATION_DEVICE,
		"HRES_ERROR_GRAPHICS_WRONG_ALLOCATION_DEVICE",
		"The allocation being referenced does not belong to the current device."
	},
	{
		HRES_ERROR_GRAPHICS_ALLOCATION_CONTENT_LOST,
		"HRES_ERROR_GRAPHICS_ALLOCATION_CONTENT_LOST",
		"The specified allocation lost its content."
	},
	{
		HRES_ERROR_GRAPHICS_GPU_EXCEPTION_ON_DEVICE,
		"HRES_ERROR_GRAPHICS_GPU_EXCEPTION_ON_DEVICE",
		"Graphics processing unit (GPU) exception is detected on the given device. The device is not able to be scheduled."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY,
		"HRES_ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY",
		"Specified video present network (VidPN) topology is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED,
		"HRES_ERROR_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED",
		"Specified VidPN topology is valid but is not supported by this model of the display adapter."
	},
	{
		HRES_ERROR_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED,
		"HRES_ERROR_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED",
		"Specified VidPN topology is valid but is not supported by the display adapter at this time, due to current allocation of its resources."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_VIDPN,
		"HRES_ERROR_GRAPHICS_INVALID_VIDPN",
		"Specified VidPN handle is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE,
		"HRES_ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE",
		"Specified video present source is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET,
		"HRES_ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET",
		"Specified video present target is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED,
		"HRES_ERROR_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED",
		"Specified VidPN modality is not supported (for example, at least two of the pinned modes are not cofunctional)."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_VIDPN_SOURCEMODESET,
		"HRES_ERROR_GRAPHICS_INVALID_VIDPN_SOURCEMODESET",
		"Specified VidPN source mode set is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_VIDPN_TARGETMODESET,
		"HRES_ERROR_GRAPHICS_INVALID_VIDPN_TARGETMODESET",
		"Specified VidPN target mode set is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_FREQUENCY,
		"HRES_ERROR_GRAPHICS_INVALID_FREQUENCY",
		"Specified video signal frequency is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_ACTIVE_REGION,
		"HRES_ERROR_GRAPHICS_INVALID_ACTIVE_REGION",
		"Specified video signal active region is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_TOTAL_REGION,
		"HRES_ERROR_GRAPHICS_INVALID_TOTAL_REGION",
		"Specified video signal total region is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE,
		"HRES_ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE",
		"Specified video present source mode is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE,
		"HRES_ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE",
		"Specified video present target mode is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET,
		"HRES_ERROR_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET",
		"Pinned mode must remain in the set on VidPN's cofunctional modality enumeration."
	},
	{
		HRES_ERROR_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY,
		"HRES_ERROR_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY",
		"Specified video present path is already in the VidPN topology."
	},
	{
		HRES_ERROR_GRAPHICS_MODE_ALREADY_IN_MODESET,
		"HRES_ERROR_GRAPHICS_MODE_ALREADY_IN_MODESET",
		"Specified mode is already in the mode set."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET,
		"HRES_ERROR_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET",
		"Specified video present source set is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET,
		"HRES_ERROR_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET",
		"Specified video present target set is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_SOURCE_ALREADY_IN_SET,
		"HRES_ERROR_GRAPHICS_SOURCE_ALREADY_IN_SET",
		"Specified video present source is already in the video present source set."
	},
	{
		HRES_ERROR_GRAPHICS_TARGET_ALREADY_IN_SET,
		"HRES_ERROR_GRAPHICS_TARGET_ALREADY_IN_SET",
		"Specified video present target is already in the video present target set."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_VIDPN_PRESENT_PATH,
		"HRES_ERROR_GRAPHICS_INVALID_VIDPN_PRESENT_PATH",
		"Specified VidPN present path is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY,
		"HRES_ERROR_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY",
		"Miniport has no recommendation for augmentation of the specified VidPN topology."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET,
		"HRES_ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET",
		"Specified monitor frequency range set is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE,
		"HRES_ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE",
		"Specified monitor frequency range is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET,
		"HRES_ERROR_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET",
		"Specified frequency range is not in the specified monitor frequency range set."
	},
	{
		HRES_ERROR_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET,
		"HRES_ERROR_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET",
		"Specified frequency range is already in the specified monitor frequency range set."
	},
	{
		HRES_ERROR_GRAPHICS_STALE_MODESET,
		"HRES_ERROR_GRAPHICS_STALE_MODESET",
		"Specified mode set is stale. Reacquire the new mode set."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_MONITOR_SOURCEMODESET,
		"HRES_ERROR_GRAPHICS_INVALID_MONITOR_SOURCEMODESET",
		"Specified monitor source mode set is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_MONITOR_SOURCE_MODE,
		"HRES_ERROR_GRAPHICS_INVALID_MONITOR_SOURCE_MODE",
		"Specified monitor source mode is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN,
		"HRES_ERROR_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN",
		"Miniport does not have any recommendation regarding the request to provide a functional VidPN given the current display adapter configuration."
	},
	{
		HRES_ERROR_GRAPHICS_MODE_ID_MUST_BE_UNIQUE,
		"HRES_ERROR_GRAPHICS_MODE_ID_MUST_BE_UNIQUE",
		"ID of the specified mode is already used by another mode in the set."
	},
	{
		HRES_ERROR_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION,
		"HRES_ERROR_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION",
		"System failed to determine a mode that is supported by both the display adapter and the monitor connected to it."
	},
	{
		HRES_ERROR_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES,
		"HRES_ERROR_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES",
		"Number of video present targets must be greater than or equal to the number of video present sources."
	},
	{
		HRES_ERROR_GRAPHICS_PATH_NOT_IN_TOPOLOGY,
		"HRES_ERROR_GRAPHICS_PATH_NOT_IN_TOPOLOGY",
		"Specified present path is not in the VidPN topology."
	},
	{
		HRES_ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE,
		"HRES_ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE",
		"Display adapter must have at least one video present source."
	},
	{
		HRES_ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET,
		"HRES_ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET",
		"Display adapter must have at least one video present target."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_MONITORDESCRIPTORSET,
		"HRES_ERROR_GRAPHICS_INVALID_MONITORDESCRIPTORSET",
		"Specified monitor descriptor set is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_MONITORDESCRIPTOR,
		"HRES_ERROR_GRAPHICS_INVALID_MONITORDESCRIPTOR",
		"Specified monitor descriptor is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET,
		"HRES_ERROR_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET",
		"Specified descriptor is not in the specified monitor descriptor set."
	},
	{
		HRES_ERROR_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET,
		"HRES_ERROR_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET",
		"Specified descriptor is already in the specified monitor descriptor set."
	},
	{
		HRES_ERROR_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE,
		"HRES_ERROR_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE",
		"ID of the specified monitor descriptor is already used by another descriptor in the set."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE,
		"HRES_ERROR_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE",
		"Specified video present target subset type is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_RESOURCES_NOT_RELATED,
		"HRES_ERROR_GRAPHICS_RESOURCES_NOT_RELATED",
		"Two or more of the specified resources are not related to each other, as defined by the interface semantics."
	},
	{
		HRES_ERROR_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE,
		"HRES_ERROR_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE",
		"ID of the specified video present source is already used by another source in the set."
	},
	{
		HRES_ERROR_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE,
		"HRES_ERROR_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE",
		"ID of the specified video present target is already used by another target in the set."
	},
	{
		HRES_ERROR_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET,
		"HRES_ERROR_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET",
		"Specified VidPN source cannot be used because there is no available VidPN target to connect it to."
	},
	{
		HRES_ERROR_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER,
		"HRES_ERROR_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER",
		"Newly arrived monitor could not be associated with a display adapter."
	},
	{
		HRES_ERROR_GRAPHICS_NO_VIDPNMGR,
		"HRES_ERROR_GRAPHICS_NO_VIDPNMGR",
		"Display adapter in question does not have an associated VidPN manager."
	},
	{
		HRES_ERROR_GRAPHICS_NO_ACTIVE_VIDPN,
		"HRES_ERROR_GRAPHICS_NO_ACTIVE_VIDPN",
		"VidPN manager of the display adapter in question does not have an active VidPN."
	},
	{
		HRES_ERROR_GRAPHICS_STALE_VIDPN_TOPOLOGY,
		"HRES_ERROR_GRAPHICS_STALE_VIDPN_TOPOLOGY",
		"Specified VidPN topology is stale. Re-acquire the new topology."
	},
	{
		HRES_ERROR_GRAPHICS_MONITOR_NOT_CONNECTED,
		"HRES_ERROR_GRAPHICS_MONITOR_NOT_CONNECTED",
		"There is no monitor connected on the specified video present target."
	},
	{
		HRES_ERROR_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY,
		"HRES_ERROR_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY",
		"Specified source is not part of the specified VidPN topology."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE,
		"HRES_ERROR_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE",
		"Specified primary surface size is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_VISIBLEREGION_SIZE,
		"HRES_ERROR_GRAPHICS_INVALID_VISIBLEREGION_SIZE",
		"Specified visible region size is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_STRIDE,
		"HRES_ERROR_GRAPHICS_INVALID_STRIDE",
		"Specified stride is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_PIXELFORMAT,
		"HRES_ERROR_GRAPHICS_INVALID_PIXELFORMAT",
		"Specified pixel format is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_COLORBASIS,
		"HRES_ERROR_GRAPHICS_INVALID_COLORBASIS",
		"Specified color basis is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_PIXELVALUEACCESSMODE,
		"HRES_ERROR_GRAPHICS_INVALID_PIXELVALUEACCESSMODE",
		"Specified pixel value access mode is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_TARGET_NOT_IN_TOPOLOGY,
		"HRES_ERROR_GRAPHICS_TARGET_NOT_IN_TOPOLOGY",
		"Specified target is not part of the specified VidPN topology."
	},
	{
		HRES_ERROR_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT,
		"HRES_ERROR_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT",
		"Failed to acquire display mode management interface."
	},
	{
		HRES_ERROR_GRAPHICS_VIDPN_SOURCE_IN_USE,
		"HRES_ERROR_GRAPHICS_VIDPN_SOURCE_IN_USE",
		"Specified VidPN source is already owned by a display mode manager (DMM) client and cannot be used until that client releases it."
	},
	{
		HRES_ERROR_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN,
		"HRES_ERROR_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN",
		"Specified VidPN is active and cannot be accessed."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL,
		"HRES_ERROR_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL",
		"Specified VidPN present path importance ordinal is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION,
		"HRES_ERROR_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION",
		"Specified VidPN present path content geometry transformation is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED,
		"HRES_ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED",
		"Specified content geometry transformation is not supported on the respective VidPN present path."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_GAMMA_RAMP,
		"HRES_ERROR_GRAPHICS_INVALID_GAMMA_RAMP",
		"Specified gamma ramp is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED,
		"HRES_ERROR_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED",
		"Specified gamma ramp is not supported on the respective VidPN present path."
	},
	{
		HRES_ERROR_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED,
		"HRES_ERROR_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED",
		"Multisampling is not supported on the respective VidPN present path."
	},
	{
		HRES_ERROR_GRAPHICS_MODE_NOT_IN_MODESET,
		"HRES_ERROR_GRAPHICS_MODE_NOT_IN_MODESET",
		"Specified mode is not in the specified mode set."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON,
		"HRES_ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON",
		"Specified VidPN topology recommendation reason is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_PATH_CONTENT_TYPE,
		"HRES_ERROR_GRAPHICS_INVALID_PATH_CONTENT_TYPE",
		"Specified VidPN present path content type is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_COPYPROTECTION_TYPE,
		"HRES_ERROR_GRAPHICS_INVALID_COPYPROTECTION_TYPE",
		"Specified VidPN present path copy protection type is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS,
		"HRES_ERROR_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS",
		"No more than one unassigned mode set can exist at any given time for a given VidPN source or target."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_SCANLINE_ORDERING,
		"HRES_ERROR_GRAPHICS_INVALID_SCANLINE_ORDERING",
		"The specified scan line ordering type is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED,
		"HRES_ERROR_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED",
		"Topology changes are not allowed for the specified VidPN."
	},
	{
		HRES_ERROR_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS,
		"HRES_ERROR_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS",
		"All available importance ordinals are already used in the specified topology."
	},
	{
		HRES_ERROR_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT,
		"HRES_ERROR_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT",
		"Specified primary surface has a different private format attribute than the current primary surface."
	},
	{
		HRES_ERROR_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM,
		"HRES_ERROR_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM",
		"Specified mode pruning algorithm is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED,
		"HRES_ERROR_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED",
		"Specified display adapter child device already has an external device connected to it."
	},
	{
		HRES_ERROR_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED,
		"HRES_ERROR_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED",
		"The display adapter child device does not support reporting a descriptor."
	},
	{
		HRES_ERROR_GRAPHICS_NOT_A_LINKED_ADAPTER,
		"HRES_ERROR_GRAPHICS_NOT_A_LINKED_ADAPTER",
		"The display adapter is not linked to any other adapters."
	},
	{
		HRES_ERROR_GRAPHICS_LEADLINK_NOT_ENUMERATED,
		"HRES_ERROR_GRAPHICS_LEADLINK_NOT_ENUMERATED",
		"Lead adapter in a linked configuration was not enumerated yet."
	},
	{
		HRES_ERROR_GRAPHICS_CHAINLINKS_NOT_ENUMERATED,
		"HRES_ERROR_GRAPHICS_CHAINLINKS_NOT_ENUMERATED",
		"Some chain adapters in a linked configuration were not enumerated yet."
	},
	{
		HRES_ERROR_GRAPHICS_ADAPTER_CHAIN_NOT_READY,
		"HRES_ERROR_GRAPHICS_ADAPTER_CHAIN_NOT_READY",
		"The chain of linked adapters is not ready to start because of an unknown failure."
	},
	{
		HRES_ERROR_GRAPHICS_CHAINLINKS_NOT_STARTED,
		"HRES_ERROR_GRAPHICS_CHAINLINKS_NOT_STARTED",
		"An attempt was made to start a lead link display adapter when the chain links were not started yet."
	},
	{
		HRES_ERROR_GRAPHICS_CHAINLINKS_NOT_POWERED_ON,
		"HRES_ERROR_GRAPHICS_CHAINLINKS_NOT_POWERED_ON",
		"An attempt was made to turn on a lead link display adapter when the chain links were turned off."
	},
	{
		HRES_ERROR_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE,
		"HRES_ERROR_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE",
		"The adapter link was found to be in an inconsistent state. Not all adapters are in an expected PNP or power state."
	},
	{
		HRES_ERROR_GRAPHICS_NOT_POST_DEVICE_DRIVER,
		"HRES_ERROR_GRAPHICS_NOT_POST_DEVICE_DRIVER",
		"The driver trying to start is not the same as the driver for the posted display adapter."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_NOT_SUPPORTED,
		"HRES_ERROR_GRAPHICS_OPM_NOT_SUPPORTED",
		"The driver does not support Output Protection Manager (OPM)."
	},
	{
		HRES_ERROR_GRAPHICS_COPP_NOT_SUPPORTED,
		"HRES_ERROR_GRAPHICS_COPP_NOT_SUPPORTED",
		"The driver does not support Certified Output Protection Protocol (COPP)."
	},
	{
		HRES_ERROR_GRAPHICS_UAB_NOT_SUPPORTED,
		"HRES_ERROR_GRAPHICS_UAB_NOT_SUPPORTED",
		"The driver does not support a user-accessible bus (UAB)."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS,
		"HRES_ERROR_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS",
		"The specified encrypted parameters are invalid."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_PARAMETER_ARRAY_TOO_SMALL,
		"HRES_ERROR_GRAPHICS_OPM_PARAMETER_ARRAY_TOO_SMALL",
		"An array passed to a function cannot hold all of the data that the function wants to put in it."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_NO_VIDEO_OUTPUTS_EXIST,
		"HRES_ERROR_GRAPHICS_OPM_NO_VIDEO_OUTPUTS_EXIST",
		"The GDI display device passed to this function does not have any active video outputs."
	},
	{
		HRES_ERROR_GRAPHICS_PVP_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME,
		"HRES_ERROR_GRAPHICS_PVP_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME",
		"The protected video path (PVP) cannot find an actual GDI display device that corresponds to the passed-in GDI display device name."
	},
	{
		HRES_ERROR_GRAPHICS_PVP_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP,
		"HRES_ERROR_GRAPHICS_PVP_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP",
		"This function failed because the GDI display device passed to it was not attached to the Windows desktop."
	},
	{
		HRES_ERROR_GRAPHICS_PVP_MIRRORING_DEVICES_NOT_SUPPORTED,
		"HRES_ERROR_GRAPHICS_PVP_MIRRORING_DEVICES_NOT_SUPPORTED",
		"The PVP does not support mirroring display devices because they do not have video outputs."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_INVALID_POINTER,
		"HRES_ERROR_GRAPHICS_OPM_INVALID_POINTER",
		"The function failed because an invalid pointer parameter was passed to it. A pointer parameter is invalid if it is null, it points to an invalid address, it points to a kernel mode address, or it is not correctly aligned."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_INTERNAL_ERROR,
		"HRES_ERROR_GRAPHICS_OPM_INTERNAL_ERROR",
		"An internal error caused this operation to fail."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_INVALID_HANDLE,
		"HRES_ERROR_GRAPHICS_OPM_INVALID_HANDLE",
		"The function failed because the caller passed in an invalid OPM user mode handle."
	},
	{
		HRES_ERROR_GRAPHICS_PVP_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE,
		"HRES_ERROR_GRAPHICS_PVP_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE",
		"This function failed because the GDI device passed to it did not have any monitors associated with it."
	},
	{
		HRES_ERROR_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH,
		"HRES_ERROR_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH",
		"A certificate could not be returned because the certificate buffer passed to the function was too small."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_SPANNING_MODE_ENABLED,
		"HRES_ERROR_GRAPHICS_OPM_SPANNING_MODE_ENABLED",
		"A video output could not be created because the frame buffer is in spanning mode."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_THEATER_MODE_ENABLED,
		"HRES_ERROR_GRAPHICS_OPM_THEATER_MODE_ENABLED",
		"A video output could not be created because the frame buffer is in theater mode."
	},
	{
		HRES_ERROR_GRAPHICS_PVP_HFS_FAILED,
		"HRES_ERROR_GRAPHICS_PVP_HFS_FAILED",
		"The function call failed because the display adapter's hardware functionality scan failed to validate the graphics hardware."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_INVALID_SRM,
		"HRES_ERROR_GRAPHICS_OPM_INVALID_SRM",
		"The High-Bandwidth Digital Content Protection (HDCP) System Renewability Message (SRM) passed to this function did not comply with section 5 of the HDCP 1.1 specification."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP,
		"HRES_ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP",
		"The video output cannot enable the HDCP system because it does not support it."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP,
		"HRES_ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP",
		"The video output cannot enable analog copy protection because it does not support it."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA,
		"HRES_ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA",
		"The video output cannot enable the Content Generation Management System Analog (CGMS-A) protection technology because it does not support it."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_HDCP_SRM_NEVER_SET,
		"HRES_ERROR_GRAPHICS_OPM_HDCP_SRM_NEVER_SET",
		"IOPMVideoOutput's GetInformation() method cannot return the version of the SRM being used because the application never successfully passed an SRM to the video output."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_RESOLUTION_TOO_HIGH,
		"HRES_ERROR_GRAPHICS_OPM_RESOLUTION_TOO_HIGH",
		"IOPMVideoOutput's Configure() method cannot enable the specified output protection technology because the output's screen resolution is too high."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE,
		"HRES_ERROR_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE",
		"IOPMVideoOutput's Configure() method cannot enable HDCP because the display adapter's HDCP hardware is already being used by other physical outputs."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_NO_LONGER_EXISTS,
		"HRES_ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_NO_LONGER_EXISTS",
		"The operating system asynchronously destroyed this OPM video output because the operating system's state changed. This error typically occurs because the monitor physical device object (PDO) associated with this video output was removed, the monitor PDO associated with this video output was stopped, the video output's session became a nonconsole session or the video output's desktop became an inactive desktop."
	},
	{
		HRES_ERROR_GRAPHICS_OPM_SESSION_TYPE_CHANGE_IN_PROGRESS,
		"HRES_ERROR_GRAPHICS_OPM_SESSION_TYPE_CHANGE_IN_PROGRESS",
		"IOPMVideoOutput's methods cannot be called when a session is changing its type. There are currently three types of sessions: console, disconnected and remote (remote desktop protocol [RDP] or Independent Computing Architecture [ICA])."
	},
	{
		HRES_ERROR_GRAPHICS_I2C_NOT_SUPPORTED,
		"HRES_ERROR_GRAPHICS_I2C_NOT_SUPPORTED",
		"The monitor connected to the specified video output does not have an I2C bus."
	},
	{
		HRES_ERROR_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST,
		"HRES_ERROR_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST",
		"No device on the I2C bus has the specified address."
	},
	{
		HRES_ERROR_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA,
		"HRES_ERROR_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA",
		"An error occurred while transmitting data to the device on the I2C bus."
	},
	{
		HRES_ERROR_GRAPHICS_I2C_ERROR_RECEIVING_DATA,
		"HRES_ERROR_GRAPHICS_I2C_ERROR_RECEIVING_DATA",
		"An error occurred while receiving data from the device on the I2C bus."
	},
	{
		HRES_ERROR_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED,
		"HRES_ERROR_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED",
		"The monitor does not support the specified Virtual Control Panel (VCP) code."
	},
	{
		HRES_ERROR_GRAPHICS_DDCCI_INVALID_DATA,
		"HRES_ERROR_GRAPHICS_DDCCI_INVALID_DATA",
		"The data received from the monitor is invalid."
	},
	{
		HRES_ERROR_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE,
		"HRES_ERROR_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE",
		"A function call failed because a monitor returned an invalid Timing Status byte when the operating system used the Display Data Channel Command Interface (DDC/CI) Get Timing Report and Timing Message command to get a timing report from a monitor."
	},
	{
		HRES_ERROR_GRAPHICS_MCA_INVALID_CAPABILITIES_STRING,
		"HRES_ERROR_GRAPHICS_MCA_INVALID_CAPABILITIES_STRING",
		"The monitor returned a DDC/CI capabilities string that did not comply with the ACCESS.bus 3.0, DDC/CI 1.1 or MCCS 2 Revision 1 specification."
	},
	{
		HRES_ERROR_GRAPHICS_MCA_INTERNAL_ERROR,
		"HRES_ERROR_GRAPHICS_MCA_INTERNAL_ERROR",
		"An internal Monitor Configuration API error occurred."
	},
	{
		HRES_ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND,
		"HRES_ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND",
		"An operation failed because a DDC/CI message had an invalid value in its command field."
	},
	{
		HRES_ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH,
		"HRES_ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH",
		"This error occurred because a DDC/CI message length field contained an invalid value."
	},
	{
		HRES_ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM,
		"HRES_ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM",
		"This error occurred because the value in a DDC/CI message checksum field did not match the message's computed checksum value. This error implies that the data was corrupted while it was being transmitted from a monitor to a computer."
	},
	{
		HRES_ERROR_GRAPHICS_PMEA_INVALID_MONITOR,
		"HRES_ERROR_GRAPHICS_PMEA_INVALID_MONITOR",
		"The HMONITOR no longer exists, is not attached to the desktop, or corresponds to a mirroring device."
	},
	{
		HRES_ERROR_GRAPHICS_PMEA_INVALID_D3D_DEVICE,
		"HRES_ERROR_GRAPHICS_PMEA_INVALID_D3D_DEVICE",
		"The Direct3D (D3D) device's GDI display device no longer exists, is not attached to the desktop, or is a mirroring display device."
	},
	{
		HRES_ERROR_GRAPHICS_DDCCI_CURRENT_CURRENT_VALUE_GREATER_THAN_MAXIMUM_VALUE,
		"HRES_ERROR_GRAPHICS_DDCCI_CURRENT_CURRENT_VALUE_GREATER_THAN_MAXIMUM_VALUE",
		"A continuous VCP code's current value is greater than its maximum value. This error code indicates that a monitor returned an invalid value."
	},
	{
		HRES_ERROR_GRAPHICS_MCA_INVALID_VCP_VERSION,
		"HRES_ERROR_GRAPHICS_MCA_INVALID_VCP_VERSION",
		"The monitor's VCP Version (0xDF) VCP code returned an invalid version value."
	},
	{
		HRES_ERROR_GRAPHICS_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION,
		"HRES_ERROR_GRAPHICS_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION",
		"The monitor does not comply with the Monitor Control Command Set (MCCS) specification it claims to support."
	},
	{
		HRES_ERROR_GRAPHICS_MCA_MCCS_VERSION_MISMATCH,
		"HRES_ERROR_GRAPHICS_MCA_MCCS_VERSION_MISMATCH",
		"The MCCS version in a monitor's mccs_ver capability does not match the MCCS version the monitor reports when the VCP Version (0xDF) VCP code is used."
	},
	{
		HRES_ERROR_GRAPHICS_MCA_UNSUPPORTED_MCCS_VERSION,
		"HRES_ERROR_GRAPHICS_MCA_UNSUPPORTED_MCCS_VERSION",
		"The Monitor Configuration API only works with monitors that support the MCCS 1.0 specification, the MCCS 2.0 specification, or the MCCS 2.0 Revision 1 specification."
	},
	{
		HRES_ERROR_GRAPHICS_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED,
		"HRES_ERROR_GRAPHICS_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED",
		"The monitor returned an invalid monitor technology type. CRT, plasma, and LCD (TFT) are examples of monitor technology types. This error implies that the monitor violated the MCCS 2.0 or MCCS 2.0 Revision 1 specification."
	},
	{
		HRES_ERROR_GRAPHICS_MCA_UNSUPPORTED_COLOR_TEMPERATURE,
		"HRES_ERROR_GRAPHICS_MCA_UNSUPPORTED_COLOR_TEMPERATURE",
		"The SetMonitorColorTemperature() caller passed a color temperature to it that the current monitor did not support. CRT, plasma, and LCD (TFT) are examples of monitor technology types. This error implies that the monitor violated the MCCS 2.0 or MCCS 2.0 Revision 1 specification."
	},
	{
		HRES_ERROR_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED,
		"HRES_ERROR_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED",
		"This function can be used only if a program is running in the local console session. It cannot be used if the program is running on a remote desktop session or on a terminal server session."
	},
};

const char *hresult_errstr_const(HRESULT err_code)
{
	const char *result = NULL;
	size_t i;
	for (i = 0; i < ARRAY_SIZE(hresult_errs); ++i) {
		if (HRES_IS_EQUAL(err_code, hresult_errs[i].error_code)) {
			result = hresult_errs[i].error_message;
			break;
		}
	}
	/* convert & check win32 error space? */
	if (result == NULL && HRESULT_IS_LIKELY_WERR(err_code)) {
		WERROR wErr = W_ERROR(WIN32_FROM_HRESULT(err_code));
		result = get_friendly_werror_msg(wErr);
	}
	return result;
};

const char *hresult_errstr(HRESULT err_code)
{
	static char msg[22];
	size_t i;

	for (i = 0; i < ARRAY_SIZE(hresult_errs); i++) {
		if (HRES_IS_EQUAL(err_code, hresult_errs[i].error_code)) {
			return hresult_errs[i].error_str;
		}
	}
	snprintf(msg, sizeof(msg), "HRES code 0x%08x", HRES_ERROR_V(err_code));
	return msg;
};
