## TFSA-2020-019: Crash due to invalid splits in SparseCountSparseOutput

### CVE Number
CVE-2020-15197

### Impact
The `SparseCountSparseOutput` implementation does not validate that the input
arguments form a valid sparse tensor. In particular, there is no validation that
the `indices` tensor has rank 2. This tensor must be a matrix because code
assumes its elements are [accessed as elements of a
matrix](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/core/kernels/count_ops.cc#L185):
```cc
    const auto indices_values = indices.matrix<int64>();
```

However, malicious users can pass in tensors of different rank, resulting in a
`CHECK` assertion failure and a crash. This can be used to cause denial of
service in serving installations, if users are allowed to control the components
of the input sparse tensor.

### Vulnerable Versions
TensorFlow 2.3.0.

### Patches
We have patched the issue in
[3cbb917b4714766030b28eba9fb41bb97ce9ee02](https://github.com/tensorflow/tensorflow/commit/3cbb917b4714766030b28eba9fb41bb97ce9ee02)
and will release a patch release.

We recommend users to upgrade to TensorFlow 2.3.1.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been discovered through a variant analysis of [a
vulnerability reported by members of the Aivul Team from Qihoo
360](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-015.md).
