import { isString } from '../utils';
import { TransportItemType } from './types';
export function initializeTransports(config) {
    const transports = [...config.transports];
    let paused = config.paused;
    const beforeSendHooks = [];
    if (config.beforeSend) {
        beforeSendHooks.push(config.beforeSend);
    }
    if (config.ignoreErrors) {
        beforeSendHooks.push(createBeforeSendHookFromIgnorePatterns(config.ignoreErrors));
    }
    const add = (...transports) => {
        transports.push(...transports);
    };
    const execute = (item) => {
        if (!paused) {
            let _item = item;
            for (const hook of beforeSendHooks) {
                const modified = hook(_item);
                if (modified === null) {
                    return;
                }
                _item = modified;
            }
            for (const transport of transports) {
                transport.send(_item);
            }
        }
    };
    const pause = () => {
        paused = true;
    };
    const unpause = () => {
        paused = false;
    };
    return {
        add,
        execute,
        transports,
        pause,
        unpause,
    };
}
function createBeforeSendHookFromIgnorePatterns(patterns) {
    return (item) => {
        if (item.type === TransportItemType.EXCEPTION && item.payload) {
            const event = item.payload;
            const msg = `${event.type}: ${event.value}`;
            if (patterns.find((pattern) => {
                return isString(pattern) ? msg.includes(pattern) : !!msg.match(pattern);
            })) {
                return null;
            }
        }
        return item;
    };
}
//# sourceMappingURL=initialize.js.map