import { allLogLevels, LogLevel, VERSION, BaseInstrumentation } from '@grafana/agent-core';
export class ConsoleInstrumentation extends BaseInstrumentation {
    constructor(options = {}) {
        super();
        this.options = options;
        this.version = VERSION;
        this.name = '@grafana/agent-web:instrumentation-console';
    }
    initialize() {
        allLogLevels
            .filter((level) => { var _a; return !((_a = this.options.disabledLevels) !== null && _a !== void 0 ? _a : ConsoleInstrumentation.defaultDisabledLevels).includes(level); })
            .forEach((level) => {
            /* eslint-disable-next-line no-console */
            console[level] = (...args) => {
                try {
                    this.agent.api.pushLog(args, { level });
                }
                catch (err) {
                }
                finally {
                    this.agent.api.callOriginalConsoleMethod(level, ...args);
                }
            };
        });
    }
}
ConsoleInstrumentation.defaultDisabledLevels = [LogLevel.DEBUG, LogLevel.TRACE, LogLevel.LOG];
//# sourceMappingURL=index.js.map