"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.saveManifest = exports.signManifest = exports.buildManifest = void 0;
const tslib_1 = require("tslib");
const crypto_1 = tslib_1.__importDefault(require("crypto"));
const fs_1 = tslib_1.__importDefault(require("fs"));
const path_1 = tslib_1.__importDefault(require("path"));
const MANIFEST_FILE = 'MANIFEST.txt';
function walk(dir, baseDir) {
    return tslib_1.__asyncGenerator(this, arguments, function* walk_1() {
        var e_1, _a;
        try {
            for (var _b = tslib_1.__asyncValues(yield tslib_1.__await(fs_1.default.promises.opendir(dir))), _c; _c = yield tslib_1.__await(_b.next()), !_c.done;) {
                const d = _c.value;
                const entry = path_1.default.posix.join(dir, d.name);
                if (d.isDirectory()) {
                    yield tslib_1.__await(yield* tslib_1.__asyncDelegator(tslib_1.__asyncValues(yield tslib_1.__await(walk(entry, baseDir)))));
                }
                else if (d.isFile()) {
                    yield yield tslib_1.__await(path_1.default.posix.relative(baseDir, entry));
                }
                else if (d.isSymbolicLink()) {
                    const realPath = yield tslib_1.__await(fs_1.default.promises.realpath(entry));
                    if (!realPath.startsWith(baseDir)) {
                        throw new Error(`symbolic link ${path_1.default.posix.relative(baseDir, entry)} targets a file outside of the base directory: ${baseDir}`);
                    }
                    // if resolved symlink target is a file include it in the manifest
                    const stats = yield tslib_1.__await(fs_1.default.promises.stat(realPath));
                    if (stats.isFile()) {
                        yield yield tslib_1.__await(path_1.default.posix.relative(baseDir, entry));
                    }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) yield tslib_1.__await(_a.call(_b));
            }
            finally { if (e_1) throw e_1.error; }
        }
    });
}
function buildManifest(dir) {
    var e_2, _a;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const pluginJson = JSON.parse(fs_1.default.readFileSync(path_1.default.join(dir, 'plugin.json'), { encoding: 'utf8' }));
        const manifest = {
            plugin: pluginJson.id,
            version: pluginJson.info.version,
            files: {},
        };
        try {
            for (var _b = tslib_1.__asyncValues(yield walk(dir, dir)), _c; _c = yield _b.next(), !_c.done;) {
                const p = _c.value;
                if (p === MANIFEST_FILE) {
                    continue;
                }
                manifest.files[p] = crypto_1.default
                    .createHash('sha256')
                    .update(fs_1.default.readFileSync(path_1.default.join(dir, p)))
                    .digest('hex');
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) yield _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return manifest;
    });
}
exports.buildManifest = buildManifest;
function signManifest(manifest) {
    var _a, _b;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const GRAFANA_API_KEY = process.env.GRAFANA_API_KEY;
        if (!GRAFANA_API_KEY) {
            throw new Error('You must enter a GRAFANA_API_KEY to sign the plugin manifest');
        }
        const GRAFANA_COM_URL = process.env.GRAFANA_COM_URL || 'https://grafana.com/api';
        const url = GRAFANA_COM_URL + '/plugins/ci/sign';
        const axios = require('axios');
        try {
            const info = yield axios.post(url, manifest, {
                headers: { Authorization: 'Bearer ' + GRAFANA_API_KEY },
            });
            if (info.status !== 200) {
                console.warn('Error: ', info);
                throw new Error('Error signing manifest');
            }
            return info.data;
        }
        catch (err) {
            if ((_b = (_a = err.response) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.message) {
                throw new Error('Error signing manifest: ' + err.response.data.message);
            }
            throw new Error('Error signing manifest: ' + err.message);
        }
    });
}
exports.signManifest = signManifest;
function saveManifest(dir, signedManifest) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        fs_1.default.writeFileSync(path_1.default.join(dir, MANIFEST_FILE), signedManifest);
        return true;
    });
}
exports.saveManifest = saveManifest;
//# sourceMappingURL=manifest.js.map