import { PureComponent } from 'react';
import { SelectableValue } from '@grafana/data';
import { ToolbarButtonVariant } from '../ToolbarButton';
export declare const defaultIntervals: string[];
export interface Props {
    intervals?: string[];
    onRefresh?: () => any;
    onIntervalChanged: (interval: string) => void;
    value?: string;
    tooltip?: string;
    isLoading?: boolean;
    isLive?: boolean;
    text?: string;
    noIntervalPicker?: boolean;
    width?: string;
    primary?: boolean;
    offOptionLabelMsg?: string;
    offOptionAriaLabelMsg?: string;
    offDescriptionAriaLabelMsg?: string;
    onDescriptionAriaLabelMsg?: (durationAriaLabel: string | undefined) => string;
}
export declare class RefreshPicker extends PureComponent<Props> {
    static offOption: {
        label: string;
        value: string;
        ariaLabel: string;
    };
    static liveOption: {
        label: string;
        value: string;
        ariaLabel: string;
    };
    static isLive: (refreshInterval?: string) => boolean;
    constructor(props: Props);
    onChangeSelect: (item: SelectableValue<string>) => void;
    getVariant(): ToolbarButtonVariant;
    render(): JSX.Element;
}
export declare function intervalsToOptions({ intervals, offOption, }?: {
    intervals?: string[];
    offOption?: SelectableValue<string>;
}): Array<SelectableValue<string>>;
