import { HrTime } from '@opentelemetry/api';
import { InstrumentationScope } from '@opentelemetry/core';
import { MetricCollectOptions } from '../export/MetricProducer';
import { ScopeMetrics } from '../export/MetricData';
import { InstrumentDescriptor } from '../InstrumentDescriptor';
import { Meter } from '../Meter';
import { AsyncMetricStorage } from './AsyncMetricStorage';
import { MeterProviderSharedState } from './MeterProviderSharedState';
import { MetricCollectorHandle } from './MetricCollector';
import { MultiMetricStorage } from './MultiWritableMetricStorage';
import { ObservableRegistry } from './ObservableRegistry';
import { SyncMetricStorage } from './SyncMetricStorage';
/**
 * An internal record for shared meter provider states.
 */
export declare class MeterSharedState {
    private _meterProviderSharedState;
    private _instrumentationScope;
    private _metricStorageRegistry;
    observableRegistry: ObservableRegistry;
    meter: Meter;
    constructor(_meterProviderSharedState: MeterProviderSharedState, _instrumentationScope: InstrumentationScope);
    registerMetricStorage(descriptor: InstrumentDescriptor): MultiMetricStorage | SyncMetricStorage<import("../utils").Maybe<import("../aggregator/types").Accumulation>>;
    registerAsyncMetricStorage(descriptor: InstrumentDescriptor): AsyncMetricStorage<import("../utils").Maybe<import("../aggregator/types").Accumulation>>[];
    /**
     * @param collector opaque handle of {@link MetricCollector} which initiated the collection.
     * @param collectionTime the HrTime at which the collection was initiated.
     * @returns the list of metric data collected.
     */
    collect(collector: MetricCollectorHandle, collectionTime: HrTime, options?: MetricCollectOptions): Promise<ScopeMetricsResult>;
}
interface ScopeMetricsResult {
    scopeMetrics: ScopeMetrics;
    errors: unknown[];
}
export {};
//# sourceMappingURL=MeterSharedState.d.ts.map