<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_auth_form - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_auth_form</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_auth_form.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_auth_form.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Authentification  l'aide d'un formulaire</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>auth_form_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_auth_form.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir d'Apache 2.3</td></tr></table>
<h3>Sommaire</h3>

    <div class="warning"><h3>Avertissement</h3>
      <p>L'authentification  base de formulaire dpend des modules
      <code class="module"><a href="../mod/mod_session.html">mod_session</a></code> qui utilisent les cookies HTTP, et en
      tant que tels s'exposent  des attaques de type Cross Site
      Scripting, ou risquent de divulguer des informations  caractre
      priv aux clients. Assurez-vous que ces risques ont bien t pris
      en compte avant d'activer les sessions sur votre serveur.</p>
    </div>

    <p>Ce module permet de restreindre les accs, au moyen d'un formulaire de
    connexion HTML, en recherchant les utilisateurs auprs des fournisseurs
    spcifis. Les formulaires HTML requirent
    davantage de configuration que les mthodes d'authentification
    alternatives, mais ils peuvent s'avrer beaucoup plus conviviaux
    pour les utilisateurs.
    </p>

    <p>L'authentification HTTP de base est fournie par le module
    <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code>, et l'authentification HTTP  base
    de condens par le module <code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code>. Le
    module <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code> doit tre utilis avec au
    moins un module d'authentification du style
    <code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code> et un module d'autorisation comme
    <code class="module"><a href="../mod/mod_authz_user.html">mod_authz_user</a></code>.</p>

    <p>Lorsque l'utilisateur a t authentifi avec succs, ses
    informations de connexion sont stocks dans une session fournie par
    le module <code class="module"><a href="../mod/mod_session.html">mod_session</a></code>.
    </p>

</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#authformauthoritative">AuthFormAuthoritative</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authformbody">AuthFormBody</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authformdisablenostore">AuthFormDisableNoStore</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authformfakebasicauth">AuthFormFakeBasicAuth</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authformlocation">AuthFormLocation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authformloginrequiredlocation">AuthFormLoginRequiredLocation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authformloginsuccesslocation">AuthFormLoginSuccessLocation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authformlogoutlocation">AuthFormLogoutLocation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authformmethod">AuthFormMethod</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authformmimetype">AuthFormMimetype</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authformpassword">AuthFormPassword</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authformprovider">AuthFormProvider</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authformsitepassphrase">AuthFormSitePassphrase</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authformsize">AuthFormSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authformusername">AuthFormUsername</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#basicconfig">Configuration de base</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#standalone">Page de connexion ddie</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#inline">Connexion  la vole</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#inlinepreservebody">Connexion  la vole avec
    conservation du contenu</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#loggingout">Dconnexion</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#urlencoding">Noms d'utilisateurs et mots de
    passe</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="module"><a href="../mod/mod_session.html">mod_session</a></code></li>
<li><code class="directive"><a href="../mod/mod_authn_core.html#authname">AuthName</a></code></li>
<li><code class="directive"><a href="../mod/mod_authn_core.html#authtype">AuthType</a></code></li>
<li><code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code></li>
<li><a href="../howto/auth.html">Mise en oeuvre de
l'authentification</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="basicconfig" id="basicconfig">Configuration de base</a></h2>

      <p>Pour protger une URL particulire avec le module
      <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code>, vous devez dterminer l'endroit o
      vous allez stocker votre <var>session</var>, ainsi que la mthode
      d'authentification. Dans cet exemple simple, les informations de
      connexion sont stockes dans une session  l'aide du module
      <code class="module"><a href="../mod/mod_session_cookie.html">mod_session_cookie</a></code>, et l'authentification utilise
      un fichier en s'appuyant sur le module
      <code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code>. Si l'authentification choue,
      l'utilisateur sera redirig vers la page du formulaire de
      connexion.</p>

      <div class="example"><h3>Exemple simple</h3><pre class="prettyprint lang-config">
AuthFormProvider file
AuthUserFile conf/passwd
AuthType form
AuthName realm
AuthFormLoginRequiredLocation http://example.com/login.html
Session On
SessionCookieName session path=/
SessionCryptoPassphrase secret
        </pre>
</div>

      <p>L'authentification <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code> est active
      en affectant la valeur <var>form</var>  la directive <code class="directive"><a href="../mod/mod_authn_core.html#authtype">AuthType</a></code>. Les directives
      <code class="directive"><a href="#authformprovider">AuthFormProvider</a></code> et
      <code class="directive"><a href="../mod/mod_authn_file.html#authuserfile">AuthUserFile</a></code>
      spcifient que les noms d'utilisateurs et mots de passe seront
      vrifis en utilisant le fichier choisi.</p>

      <p>Les directives <code class="directive"><a href="../mod/mod_session.html#session">Session</a></code>, <code class="directive"><a href="../mod/mod_session_cookie.html#sessioncookiename">SessionCookieName</a></code> et
      <code class="directive"><a href="../mod/mod_session_crypto.html#sessioncryptopassphrase">SessionCryptoPassphrase</a></code>
      crent une session chiffre stocke dans un cookie HTTP au niveau
      du navigateur. Pour plus d'informations  propos des diffrentes
      options de configuration des sessions, reportez-vous  la
      documentation du module <code class="module"><a href="../mod/mod_session.html">mod_session</a></code>.</p>

      <p>Dans l'exemple simple ci-dessus, une URL a t protge par
      <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code>, mais on doit maintenant fournir
       l'utilisateur un moyen de saisir un nom et un mot de passe.  cet
      effet, on peut soit crire une page de connexion indpendante
      ddie, soit inclure le formulaire de connexion dans la page
      courante.</p>
    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="standalone" id="standalone">Page de connexion ddie</a></h2>

      <p>Le formulaire de connexion peut tre contenu dans une page
      indpendante, ou tre inclus dans la page courante. </p>

      <p>Lorsque la connexion s'effectue  partir d'une page
      indpendante et si la tentative d'authentification choue,
      l'utilisateur doit tre redirig vers un formulaire de connexion,
      cr  cet effet sur le site web, en utilisant la directive
      <code class="directive"><a href="#authformloginrequiredlocation">AuthFormLoginRequiredLocation</a></code>.
      En gnral, la page de connexion contiendra un formulaire HTML
      demandant  l'utilisateur de fournir un nom et un mot de passe.</p>

      <div class="example"><h3>Exemple de formulaire de connexion</h3><p><code>
        &lt;form method="POST" action="/dologin.html"&gt;<br />
        Utilisateur : &lt;input type="text" name="httpd_username" value="" /&gt;<br />
        Mot de passe: &lt;input type="password" name="httpd_password" value="" /&gt;<br />
        &lt;input type="submit" name="login" value="Connexion" /&gt;<br />
        &lt;/form&gt;<br />
      </code></p></div>

      <p>La partie o s'effectue la connexion proprement dite est
      traite par le gestionnaire <var>form-login-handler</var>.
      L'action de ce formulaire doit pointer vers ce gestionnaire, ce
      que l'on configure dans Apache httpd comme suit :</p>

      <div class="example"><h3>Exemple de configuration du gestionnaire de
      formulaire de connexion</h3><pre class="prettyprint lang-config">
&lt;Location /dologin.html&gt;
    SetHandler form-login-handler
    AuthFormLoginRequiredLocation http://example.com/login.html
    AuthFormLoginSuccessLocation http://example.com/success.html
    AuthFormProvider file
    AuthUserFile conf/passwd
    AuthType form
    AuthName realm
    Session On
    SessionCookieName session path=/
    SessionCryptoPassphrase secret
&lt;/Location&gt;
        </pre>
</div>

      <p>L'URL spcifie par la directive <code class="directive"><a href="#authformloginrequiredlocation">AuthFormLoginRequiredLocation</a></code>
      rfrencera en gnral une page expliquant  l'utilisateur que sa
      tentative de connexion a chou, et qu'il doit la renouveler. La
      directive <code class="directive"><a href="#authformloginsuccesslocation">AuthFormLoginSuccessLocation</a></code>
      spcifie l'URL vers laquelle l'utilisateur doit tre redirig s'il
      s'est authentifi avec succs.</p>

      <p>Alternativement, l'URL vers laquelle doit tre redirig
      l'utilisateur s'il s'est authentifi avec succs peut tre
      intgre dans le formulaire de connexion, comme dans l'exemple
      ci-dessous. Il en dcoule que le mme gestionnaire
      <var>form-login-handler</var> pourra tre utilis pour diffrentes
      zones du site web.</p>

      <div class="example"><h3>Exemple de formulaire de login avec page cible</h3><p><code>
        &lt;form method="POST" action="/dologin.html"&gt;<br />
        <span class="indent">
          Utilisateur  : &lt;input type="text" name="httpd_username" value="" /&gt;<br />
          Mot de passe : &lt;input type="password" name="httpd_password" value="" /&gt;<br />
          &lt;input type="submit" name="login" value="Connexion" /&gt;<br />
          &lt;input type="hidden" name="httpd_location" value="http://example.com/success.html" /&gt;<br />
        </span>
        &lt;/form&gt;<br />
      </code></p></div>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="inline" id="inline">Connexion  la vole</a></h2>

      <div class="warning"><h3>Avertissement</h3>
        <p>Il existe un risque, dans certaines circonstances, que le
	formulaire de connexion configur pour une connexion  la vole
	soit soumis plusieurs fois, rvlant de ce fait les paramtres
	de connexion  l'application sous-jacente. L'administrateur doit
	s'assurer que cette dernire est correctement scurise afin
	d'viter les ventuels abus. En cas de doute, utilisez une page
	de connexion indpendante ddie.</p>
      </div>

      <p>Comme alternative  la page de connexion ddie pour un site
      web, il est possible de configurer <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code>
      pour authentifier les utilisateurs  la vole, sans les rediriger
      vers une autre page, ce qui permet de conserver l'tat de la page
      courante au cours de la tentative de connexion. Ceci peut s'avrer
      utile dans le cas d'une session limite dans le temps, si le dlai
      de la session a expir pendant la requte de l'utilisateur. Ce
      dernier peut alors se rauthentifier  la mme place, et
      poursuivre son activit  partir du point o il en tait rest.</p>

      <p>Si un utilisateur non authentifi tente d'accder  une page
      protge par <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code>, et si ce dernier
      n'est pas configur avec une directive <code class="directive"><a href="#authformloginrequiredlocation">AuthFormLoginRequiredLocation</a></code>,
      un code de statut <var>HTTP_UNAUTHORIZED</var> est renvoy vers le
      navigateur, indiquant  l'utilisateur qu'il n'est pas autoris 
      accder  cette page.</p>

      <p>Pour configurer l'authentification  la vole, l'administrateur
      remplace le message d'erreur renvoy par le code de statut
      <var>HTTP_UNAUTHORIZED</var> par un message d'erreur personnalis
      contenant le formulaire de connexion comme suit :</p>

      <div class="example"><h3>Exemple simple d'authentification  la vole</h3><pre class="prettyprint lang-config">
AuthFormProvider file
ErrorDocument 401 /login.shtml
AuthUserFile conf/passwd
AuthType form
AuthName realm
AuthFormLoginRequiredLocation http://example.com/login.html
Session On
SessionCookieName session path=/
SessionCryptoPassphrase secret
        </pre>
</div>

      <p>La page du message d'erreur doit contenir un formulaire de
      connexion dont la proprit action est vide, comme dans l'exemple
      ci-dessous. Ceci a pour effet de soumettre le formulaire  l'URL
      protge originale, cette dernire n'ayant pas besoin d'tre
      connue de la page en cours.</p>

      <div class="example"><h3>Exemple de formulaire de connexion  la vole</h3><p><code>
        &lt;form method="POST" <strong>action=""</strong>&gt;<br />
        <span class="indent">
          Utilisateur  : &lt;input type="text" name="httpd_username" value="" /&gt;<br />
          Mot de passe : &lt;input type="password" name="httpd_password" value="" /&gt;<br />
          &lt;input type="submit" name="login" value="Connexion" /&gt;<br />
        </span>
        &lt;/form&gt;<br />
      </code></p></div>

      <p>Lorsque l'utilisateur final a entr ses informations de
      connexion, le formulaire effectue une requte HTTP POST pour l'URL
      originale protge par mot de passe.
      <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code> va alors intercepter cette requte
      POST, et dans le cas o des champs HTML Utilisateur et Mot de
      passe corrects sont prsents, l'utilisateur sera connect, et
      l'URL originale protge par mot de passe lui sera retourne en
      tant que requte GET.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="inlinepreservebody" id="inlinepreservebody">Connexion  la vole avec
    conservation du contenu</a></h2>

      <p>Il existe une limite  la technique de connexion  la vole
      dcrite ci-dessus ; si un formulaire HTML POST entrane une
      demande d'authentification ou de rauthentification, le contenu du
      formulaire original envoy par le navigateur sera perdu. Cela peut
      s'avrer plus ou moins gnant pour l'utilisateur final selon la
      fonction du site web.</p>

      <p>Comme solution  ce problme, <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code>
      permet d'intgrer la mthode et le contenu de la requte originale
      dans le formulaire de connexion. Si l'authentification russit,
      Apache httpd pourra refaire une tentative avec la mthode et le contenu
      originaux, tout en conservant l'tat de la requte originale.</p>

      <p>Pour mettre en oeuvre la conservation du contenu, vous devez
      ajouter trois champs supplmentaires au formulaire de connexion
      comme dans l'exemple suivant :</p>

      <div class="example"><h3>Exemple de formulaire avec conservation du
      contenu</h3><p><code>
        &lt;form method="POST" action=""&gt;<br />
        <span class="indent">
          Utilisateur  : &lt;input type="text" name="httpd_username" value="" /&gt;<br />
          Mot de passe : &lt;input type="password" name="httpd_password" value="" /&gt;<br />
          &lt;input type="submit" name="login" value="Connexion" /&gt;<br />
          <strong>&lt;input type="hidden" name="httpd_method" value="POST" /&gt;<br />
          &lt;input type="hidden" name="httpd_mimetype" value="application/x-www-form-urlencoded" /&gt;<br />
          &lt;input type="hidden" name="httpd_body" value="name1=value1&amp;name2=value2" /&gt;</strong><br />
        </span>
        &lt;/form&gt;
      </code></p></div>

      <p>La manire dont la mthode, le type MIME et le contenu de la
      requte originale seront intgrs dans le formulaire de connexion
      vont dpendre de la plate-forme et de la technologie utilises au
      sein du site web.
      </p>

      <p>Une option consiste  utiliser le module
      <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> en association avec la directive
      <code class="directive"><a href="../mod/mod_request.html#keptbodysize">KeptBodySize</a></code>, ainsi
      qu'un script CGI adapt pour intgrer les variables dans le
      formulaire.</p>

      <p>Une autre option consiste  prsenter le formulaire de
      connexion en utilisant un script CGI ou une autre technologie
      dynamique.</p>

      <div class="example"><h3>Exemple avec script CGI</h3><pre class="prettyprint lang-config">
        AuthFormProvider file
        ErrorDocument 401 /cgi-bin/login.cgi
        ...
        </pre>
</div>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="loggingout" id="loggingout">Dconnexion</a></h2>

      <p>Pour permettre  un utilisateur de se dconnecter d'une session
      particulire, vous devez configurer une page pour qu'elle soit
      traite par le gestionnaire <var>form-logout-handler</var>. Tout
      accs  cette URL va entraner la suppression de l'Utilisateur et
      du Mot de passe de la session courante, ce qui aura pour effet de
      dconnecter l'utilisateur.</p>

      <p>Vous pouvez spcifier une URL vers laquelle le navigateur sera
      redirig en cas de dconnection russie, en dfinissant la
      directive <code class="directive"><a href="#authformlogoutlocation">AuthFormLogoutLocation</a></code>. Cette
      URL devra expliquer  l'utilisateur qu'il a t dconnect, et lui
      donner la possibilit de se connecter  nouveau.</p>

      <div class="example"><h3>Exemple simple de configuration de la
      dconnexion</h3><pre class="prettyprint lang-config">
SetHandler form-logout-handler
AuthName realm
AuthFormLogoutLocation http://example.com/loggedout.html
Session On
SessionCookieName session path=/
SessionCryptoPassphrase secret
        </pre>
</div>

      <p>Notez que la dconnexion d'un utilisateur ne supprime pas la
      session ; elle supprime seulement l'Utilisateur et le mot de passe
      de la session. Si la session qui en rsulte est vide, elle sera
      probablement supprime, mais ce n'est pas garanti. Si vous voulez
      tre sr que la session sera supprime, affectez une petite valeur
       la directive <code class="directive"><a href="../mod/mod_session.html#sessionmaxage">SessionMaxAge</a></code>, par exemple 1
      (affecter  cette directive la valeur zro signifie une session
      sans limite d'ge).
      </p>

      <div class="example"><h3>Exemple simple avec dure de validit de session
      limite</h3><pre class="prettyprint lang-config">
SetHandler form-logout-handler
AuthFormLogoutLocation http://example.com/loggedout.html
Session On
SessionMaxAge 1
SessionCookieName session path=/
SessionCryptoPassphrase secret
        </pre>
</div>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="urlencoding" id="urlencoding">Noms d'utilisateurs et mots de
    passe</a></h2>
    <p>Notez que la soumission d'un formulaire implique l'encodage URL
    (URLEncoding) des donnes du formulaire, ici le nom d'utilisateur et
    le mot de passe. Vous devez donc choisir des noms d'utilisateurs et
    mots de passe qui ne contiennent pas de caractres susceptibles
    d'tre encods URL lors de la soumission du formulaire, sous peine
    d'obtenir des rsultats inattendus.</p>
    </div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormAuthoritative" id="AuthFormAuthoritative">AuthFormAuthoritative</a> <a name="authformauthoritative" id="authformauthoritative">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine si l'autorisation et l'authentification sont confis 
des modules de plus bas niveau</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormAuthoritative On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthFormAuthoritative On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
</table>
    <p>Normalement, chacun des modules d'autorisation spcifis par la
    directive <code class="directive"><a href="#authformprovider">AuthFormProvider</a></code> va tenter de
    vrifier l'identit de l'utilisateur, et si ce dernier n'est trouv
    dans aucun fournisseur, l'accs sera refus. En dfinissant
    explicitement la directive
    <code class="directive">AuthFormAuthoritative</code>  <code>Off</code> on
    confie les processus d'authentification et d'autorisation  des
    modules ne s'appuyant pas sur des fournisseurs, si <strong>aucun
    identifiant utilisateur</strong> ou aucune <strong>rgle</strong> ne
    correspond  l'identifiant utilisateur fourni. Ceci ne peut s'avrer
    ncessaire que si l'on combine <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code> avec
    des modules tiers qui ne se configurent pas avec la directive
    <code class="directive"><a href="#authformprovider">AuthFormProvider</a></code>.
    Lorsqu'on utilise de tels modules, la chronologie du processus est
    dtermine dans leur code source, et n'est pas configurable.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormBody" id="AuthFormBody">AuthFormBody</a> <a name="authformbody" id="authformbody">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le nom du champ de formulaire contenant le corps de la
requte  effectuer en cas de connexion russie</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormBody <var>nom du champ</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>httpd_body</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.0 du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#authformbody">AuthFormBody</a></code> permet de
    spcifier le nom du champ HTML qui, s'il existe, contiendra le corps
    de la requte  effectuer en cas de connexion russie.</p>

    <p>En ajoutant au formulaire les champs dcrits dans <code class="directive"><a href="#authformmethod">AuthFormMethod</a></code>, <code class="directive"><a href="#authformmimetype">AuthFormMimetype</a></code> et <code class="directive"><a href="#authformbody">AuthFormBody</a></code>, un site web sera en
    mesure de relancer une requte qui a t ventuellement interrompue
    par l'cran de connexion, ou par l'expiration d'un dlai de
    session.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormDisableNoStore" id="AuthFormDisableNoStore">AuthFormDisableNoStore</a> <a name="authformdisablenostore" id="authformdisablenostore">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dsactive l'en-tte CacheControl no-store sur la page de
connexion</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormDisableNoStore <var>On|Off</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthFormDisableNoStore Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.0 du serveur HTTP Apache</td></tr>
</table>
    <p>Le drapeau <code class="directive"><a href="#authformdisablenostore">AuthFormDisableNoStore</a></code> supprime
    l'envoi d'un en-tte <code>Cache-Control no-store</code> lorsqu'une
    page avec code d'erreur 401 est renvoye si l'utilisateur n'est pas
    encore connect. Avec cet en-tte, il est plus difficile pour une
    application <code>ecmascript</code> de resoumettre un formulaire de connexion, et
    ainsi rvler le nom d'utilisateur et le mot de passe 
    l'application sous-jacente. Vous devez tre conscient des risques
    encourus si vous le dsactivez.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormFakeBasicAuth" id="AuthFormFakeBasicAuth">AuthFormFakeBasicAuth</a> <a name="authformfakebasicauth" id="authformfakebasicauth">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Simule un en-tte d'authentification de base</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormFakeBasicAuth <var>On|Off</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthFormFakeBasicAuth Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.0 du serveur HTTP Apache</td></tr>
</table>
    <p>Le drapeau <code class="directive"><a href="#authformfakebasicauth">AuthFormFakeBasicAuth</a></code> permet de
    dterminer si un en-tte d'<code>Authentification de base</code>
    sera ajout aux en-ttes de la requte. On peut utiliser cette
    mthode pour prsenter le nom d'utilisateur et le mot de passe 
    l'application sous-jacente, sans que cette dernire ait besoin de
    connatre la manire dont le processus de connexion a t men 
    bien.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormLocation" id="AuthFormLocation">AuthFormLocation</a> <a name="authformlocation" id="authformlocation">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le nom du champ de formulaire qui contiendra l'URL vers
laquelle l'utilisateur sera redirig en cas de connexion
russie</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormLocation <var>nom du champ</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>httpd_location</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.0 du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#authformlocation">AuthFormLocation</a></code> permet de
    spcifier le nom du champ HTML qui, s'il existe, contiendra l'URL
    vers laquelle rediriger le navigateur en cas de connexion
    russie.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormLoginRequiredLocation" id="AuthFormLoginRequiredLocation">AuthFormLoginRequiredLocation</a> <a name="authformloginrequiredlocation" id="authformloginrequiredlocation">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>L'URL de la page vers laquelle on doit tre redirig si une
authentification est requise</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormLoginRequiredLocation <var>url</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.0 du serveur HTTP
Apache. L'interprteur d'expressions a t ajout  partir de la version
2.4.4.</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#authformloginrequiredlocation">AuthFormLoginRequiredLocation</a></code>
    permet de spcifier l'URL vers laquelle l'utilisateur devra tre
    redirig s'il n'est pas autoris 
    accder  une page. L'argument pass  cette directive
    est lu au moyen de l'analyseur lexical <a href="../expr.html">ap_expr</a> avant d'tre
    envoy au client. Par dfaut,
    si un utilisateur n'est pas autoris  accder  une page, le code
    de rponse HTTP <code>HTTP_UNAUTHORIZED</code> est renvoy avec la
    page spcifie par la directive <code class="directive"><a href="../mod/core.html#errordocument">ErrorDocument</a></code>. La directive <code class="directive"><a href="#authformloginrequiredlocation">AuthFormLoginRequiredLocation</a></code>
    permet de remplacer cette valeur par dfaut.</p>

    <p>Vous pouvez utiliser cette directive si vous voulez prsenter une
    page de connexion personnalise  vos utilisateurs.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormLoginSuccessLocation" id="AuthFormLoginSuccessLocation">AuthFormLoginSuccessLocation</a> <a name="authformloginsuccesslocation" id="authformloginsuccesslocation">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>L'URL de la page vers laquelle on doit tre redirig en cas
de connexion russie</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormLoginSuccessLocation <var>url</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.0 du serveur HTTP
Apache. L'interprteur d'expressions a t ajout  partir de la version
2.4.4.</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#authformloginsuccesslocation">AuthFormLoginSuccessLocation</a></code>
    permet de spcifier l'URL vers laquelle l'utilisateur doit tre
    redirig en cas de connexion russie. L'argument pass  cette directive
    est lu au moyen de l'analyseur lexical <a href="../expr.html">ap_expr</a> avant d'tre
    envoy au client.  L'effet de cette directive
    peut tre annul si l'on a dfini un champ de formulaire contenant
    une autre URL  l'aide de la directive <code class="directive"><a href="#authformlocation">AuthFormLocation</a></code>.</p>

    <p>Vous pouvez utiliser cette directive si vous possdez une URL de
    connexion personnalise, et si vous n'avez pas intgr la page de
    destination dans le formulaire de connexion.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormLogoutLocation" id="AuthFormLogoutLocation">AuthFormLogoutLocation</a> <a name="authformlogoutlocation" id="authformlogoutlocation">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>L'URL vers laquelle un utilisateur devra tre redirig
aprs s'tre dconnect</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormLogoutLocation <var>uri</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.0 du serveur HTTP
Apache. L'interprteur d'expressions a t ajout  partir de la version
2.4.4.</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#authformlogoutlocation">AuthFormLogoutLocation</a></code> permet de
    spcifier l'URL de la page du serveur vers laquelle l'utilisateur
    devra tre redirig s'il se dconnecte.
    L'argument pass  cette directive
    est lu au moyen de l'analyseur lexical <a href="../expr.html">ap_expr</a> avant d'tre
    envoy au client.</p>

    <p>Lorsqu'un accs est tent sur un URI trait par le gestionnaire
    <code>form-logout-handler</code>, la page spcifie par cette
    directive sera prsente  l'utilisateur final. Par exemple :</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">
&lt;Location /logout&gt;
    SetHandler form-logout-handler
    AuthFormLogoutLocation http://example.com/loggedout.html
    Session on
    #...
&lt;/Location&gt;
      </pre>
</div>

    <p>Si un utilisateur tente d'accder  l'URI <var>/logout/</var>, il
    sera dconnect, et la page <var>/loggedout.html</var> lui sera
    prsente. Assurez-vous que la page <var>loggedout.html</var> n'est
    pas protge par mot de passe, car dans le cas contraire, elle ne
    serait pas affiche.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormMethod" id="AuthFormMethod">AuthFormMethod</a> <a name="authformmethod" id="authformmethod">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le nom du champ de formulaire contenant la mthode de la
requte  effectuer en cas de connexion russie</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormMethod <var>nom du champ</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>httpd_method</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.0 du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#authformmethod">AuthFormMethod</a></code> permet de
    spcifier le nom du champ HTML qui, s'il existe, contiendra le type
    MIME de la requte  effectuer en cas de connexion russie.</p>

    <p>En ajoutant au formulaire les champs dcrits dans <code class="directive"><a href="#authformmethod">AuthFormMethod</a></code>, <code class="directive"><a href="#authformmimetype">AuthFormMimetype</a></code> et <code class="directive"><a href="#authformbody">AuthFormBody</a></code>, un site web sera en
    mesure de relancer une requte qui a t ventuellement interrompue
    par l'cran de connexion, ou par l'expiration d'un dlai de
    session.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormMimetype" id="AuthFormMimetype">AuthFormMimetype</a> <a name="authformmimetype" id="authformmimetype">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le nom du champ de formulaire contenant le type MIME du
corps de la requte  effectuer en cas de connexion
russie</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormMimetype <var>nom du champ</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>httpd_mimetype</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.0 du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#authformmimetype">AuthFormMimetype</a></code> permet de
    spcifier le nom du champ HTML qui, s'il existe, contiendra le type
    MIME de la requte  effectuer en cas de connexion russie.</p>

    <p>En ajoutant au formulaire les champs dcrits dans <code class="directive"><a href="#authformmethod">AuthFormMethod</a></code>, <code class="directive"><a href="#authformmimetype">AuthFormMimetype</a></code> et <code class="directive"><a href="#authformbody">AuthFormBody</a></code>, un site web sera en
    mesure de relancer une requte qui a t ventuellement interrompue
    par l'cran de connexion, ou par l'expiration d'un dlai de
    session.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormPassword" id="AuthFormPassword">AuthFormPassword</a> <a name="authformpassword" id="authformpassword">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le nom du champ de formulaire qui contient le mot de passe
de connexion</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormPassword <var>nom du champ</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>httpd_password</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.0 du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#authformpassword">AuthFormPassword</a></code> permet de
    spcifier le nom du champ HTML qui, s'il existe, contiendra le mot
    de passe qui sera utilis pour la connexion.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormProvider" id="AuthFormProvider">AuthFormProvider</a> <a name="authformprovider" id="authformprovider">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit le(s) fournisseur(s) d'authentification pour la
zone concerne</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormProvider <var>nom fournisseur</var>
[<var>nom fournisseur</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthFormProvider file</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
</table>
    <p>La directive <code class="directive">AuthFormProvider</code> permet de
    dfinir quel fournisseur sera utilis pour authentifier les
    utilisateurs pour la zone concerne. Le fournisseur par dfaut
    <code>file</code> est implment par le module
    <code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code>. Assurez-vous que le fournisseur
    choisi soit bien prsent dans le serveur.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">
&lt;Location /secure&gt;
    AuthType form
    AuthName "private area"
    AuthFormProvider  dbm
    AuthDBMType        SDBM
    AuthDBMUserFile    /www/etc/dbmpasswd
    Require            valid-user
    #...
&lt;/Location&gt;
      </pre>
</div>

    <p>Les diffrents fournisseurs sont implments par les modules
    <code class="module"><a href="../mod/mod_authn_dbm.html">mod_authn_dbm</a></code>, <code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code>,
    <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code> et
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormSitePassphrase" id="AuthFormSitePassphrase">AuthFormSitePassphrase</a> <a name="authformsitepassphrase" id="authformsitepassphrase">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Court-circuite l'authentification pour les sites  fort
trafic</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormSitePassphrase <var>secret</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.0 du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#authformsitepassphrase">AuthFormSitePassphrase</a></code> permet de
    spcifier un mot de passe qui, s'il est prsent dans la session
    utilisateur, indique  Apache httpd de court-circuiter l'authentification
    pour l'URL considre. On peut l'utiliser dans le cas de sites web 
    fort trafic afin de rduire la charge induite sur l'infrastructure
    d'authentification.</p>

    <p>On peut insrer le mot de passe dans une session utilisateur en
    ajoutant cette directive  la configuration concernant le
    gestionnaire <var>form-login-handler</var>. Le gestionnaire
    <var>form-login-handler</var>, quant  lui, effectuera toujours les
    vrifications d'authentification, qu'un mot de passe soit spcifi
    ou non.</p>

    <div class="warning"><h3>Avertissement</h3>
      <p>Si la session est prsente  l'utilisateur  l'aide du module
      <code class="module"><a href="../mod/mod_session_cookie.html">mod_session_cookie</a></code>, et si la session n'est pas
      protge par le module <code class="module"><a href="../mod/mod_session_crypto.html">mod_session_crypto</a></code>, le mot
      de passe peut faire l'objet d'une attaque de type dictionnaire.
      Quelle que soit la configuration de la session, assurez-vous que
      cette directive n'est pas utilise dans un espace d'URLs contenant
      des donnes prives, ou  partir desquelles des transactions
      sensibles pourraient tre menes. En tout tat de cause, vous
      devez tre conscient des risques encourus avant de l'utiliser.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormSize" id="AuthFormSize">AuthFormSize</a> <a name="authformsize" id="authformsize">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>La taille maximale en octets du formulaire dont seront
extraites les informations de connexion</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormSize <var>taille</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>8192</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.0 du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#authformsize">AuthFormSize</a></code> permet de spcifier
    la taille maximale du corps de la requte qui sera utilise pour
    trouver le formulaire de connexion.</p>

    <p>Si une requte de connexion entrante possde une taille
    suprieure  cette valeur, elle sera rejete avec le code de rponse
    HTTP <code>HTTP_REQUEST_TOO_LARGE</code>.</p>

    <p>Si vous avez ajout au formulaire des champs dcrits dans <code class="directive"><a href="#authformmethod">AuthFormMethod</a></code>, <code class="directive"><a href="#authformmimetype">AuthFormMimetype</a></code> et <code class="directive"><a href="#authformbody">AuthFormBody</a></code>, il est recommand
    de dfinir cette directive  une valeur similaire  celle de la
    directive <code class="directive"><a href="../mod/mod_request.html#keptbodysize">KeptBodySize</a></code>.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthFormUsername" id="AuthFormUsername">AuthFormUsername</a> <a name="authformusername" id="authformusername">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le nom du champ de formulaire qui contient le nom de
connexion</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthFormUsername <var>nom du champ</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>httpd_username</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_form</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.3 du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#authformusername">AuthFormUsername</a></code> permet de
    spcifier le nom du champ HTML qui, s'il existe, contiendra le nom
    d'utilisateur qui sera utilis pour la connexion.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_auth_form.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_auth_form.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_auth_form.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2013 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>