// Copyright (c) 2016, 2018, 2021, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

package common

const (
	//RegionAPChuncheon1 region Chuncheon
	RegionAPChuncheon1 Region = "ap-chuncheon-1"
	//RegionAPHyderabad1 region Hyderabad
	RegionAPHyderabad1 Region = "ap-hyderabad-1"
	//RegionAPMelbourne1 region Melbourne
	RegionAPMelbourne1 Region = "ap-melbourne-1"
	//RegionAPMumbai1 region Mumbai
	RegionAPMumbai1 Region = "ap-mumbai-1"
	//RegionAPOsaka1 region Osaka
	RegionAPOsaka1 Region = "ap-osaka-1"
	//RegionAPSeoul1 region Seoul
	RegionAPSeoul1 Region = "ap-seoul-1"
	//RegionAPSydney1 region Sydney
	RegionAPSydney1 Region = "ap-sydney-1"
	//RegionAPTokyo1 region Tokyo
	RegionAPTokyo1 Region = "ap-tokyo-1"
	//RegionCAMontreal1 region Montreal
	RegionCAMontreal1 Region = "ca-montreal-1"
	//RegionCAToronto1 region Toronto
	RegionCAToronto1 Region = "ca-toronto-1"
	//RegionEUAmsterdam1 region Amsterdam
	RegionEUAmsterdam1 Region = "eu-amsterdam-1"
	//RegionFRA region Frankfurt
	RegionFRA Region = "eu-frankfurt-1"
	//RegionEUZurich1 region Zurich
	RegionEUZurich1 Region = "eu-zurich-1"
	//RegionMEJeddah1 region Jeddah
	RegionMEJeddah1 Region = "me-jeddah-1"
	//RegionMEDubai1 region Dubai
	RegionMEDubai1 Region = "me-dubai-1"
	//RegionSASaopaulo1 region Saopaulo
	RegionSASaopaulo1 Region = "sa-saopaulo-1"
	//RegionUKCardiff1 region Cardiff
	RegionUKCardiff1 Region = "uk-cardiff-1"
	//RegionLHR region London
	RegionLHR Region = "uk-london-1"
	//RegionIAD region Ashburn
	RegionIAD Region = "us-ashburn-1"
	//RegionPHX region Phoenix
	RegionPHX Region = "us-phoenix-1"
	//RegionSJC1 region Sanjose
	RegionSJC1 Region = "us-sanjose-1"
	//RegionSAVinhedo1 region Vinhedo
	RegionSAVinhedo1 Region = "sa-vinhedo-1"
	//RegionSASantiago1 region Santiago
	RegionSASantiago1 Region = "sa-santiago-1"
	//RegionILJerusalem1 region Jerusalem
	RegionILJerusalem1 Region = "il-jerusalem-1"
	//RegionEUMarseille1 region Marseille
	RegionEUMarseille1 Region = "eu-marseille-1"
	//RegionAPSingapore1 region Singapore
	RegionAPSingapore1 Region = "ap-singapore-1"
	//RegionMEAbudhabi1 region Abudhabi
	RegionMEAbudhabi1 Region = "me-abudhabi-1"
	//RegionEUMilan1 region Milan
	RegionEUMilan1 Region = "eu-milan-1"
	//RegionUSLangley1 region Langley
	RegionUSLangley1 Region = "us-langley-1"
	//RegionUSLuke1 region Luke
	RegionUSLuke1 Region = "us-luke-1"
	//RegionUSGovAshburn1 gov region Ashburn
	RegionUSGovAshburn1 Region = "us-gov-ashburn-1"
	//RegionUSGovChicago1 gov region Chicago
	RegionUSGovChicago1 Region = "us-gov-chicago-1"
	//RegionUSGovPhoenix1 gov region Phoenix
	RegionUSGovPhoenix1 Region = "us-gov-phoenix-1"
	//RegionUKGovLondon1 gov region London
	RegionUKGovLondon1 Region = "uk-gov-london-1"
	//RegionUKGovCardiff1 gov region Cardiff
	RegionUKGovCardiff1 Region = "uk-gov-cardiff-1"
	//RegionAPChiyoda1 region Chiyoda
	RegionAPChiyoda1 Region = "ap-chiyoda-1"
	//RegionAPIbaraki1 region Ibaraki
	RegionAPIbaraki1 Region = "ap-ibaraki-1"
)

var shortNameRegion = map[string]Region{
	"yny": RegionAPChuncheon1,
	"hyd": RegionAPHyderabad1,
	"mel": RegionAPMelbourne1,
	"bom": RegionAPMumbai1,
	"kix": RegionAPOsaka1,
	"icn": RegionAPSeoul1,
	"syd": RegionAPSydney1,
	"nrt": RegionAPTokyo1,
	"yul": RegionCAMontreal1,
	"yyz": RegionCAToronto1,
	"ams": RegionEUAmsterdam1,
	"fra": RegionFRA,
	"zrh": RegionEUZurich1,
	"jed": RegionMEJeddah1,
	"dxb": RegionMEDubai1,
	"gru": RegionSASaopaulo1,
	"cwl": RegionUKCardiff1,
	"lhr": RegionLHR,
	"iad": RegionIAD,
	"phx": RegionPHX,
	"sjc": RegionSJC1,
	"vcp": RegionSAVinhedo1,
	"scl": RegionSASantiago1,
	"mtz": RegionILJerusalem1,
	"mrs": RegionEUMarseille1,
	"sin": RegionAPSingapore1,
	"auh": RegionMEAbudhabi1,
	"lin": RegionEUMilan1,
	"lfi": RegionUSLangley1,
	"luf": RegionUSLuke1,
	"ric": RegionUSGovAshburn1,
	"pia": RegionUSGovChicago1,
	"tus": RegionUSGovPhoenix1,
	"ltn": RegionUKGovLondon1,
	"brs": RegionUKGovCardiff1,
	"nja": RegionAPChiyoda1,
	"ukb": RegionAPIbaraki1,
}

var realm = map[string]string{
	"oc1": "oraclecloud.com",
	"oc2": "oraclegovcloud.com",
	"oc3": "oraclegovcloud.com",
	"oc4": "oraclegovcloud.uk",
	"oc8": "oraclecloud8.com",
}

var regionRealm = map[Region]string{
	RegionAPChuncheon1: "oc1",
	RegionAPHyderabad1: "oc1",
	RegionAPMelbourne1: "oc1",
	RegionAPMumbai1:    "oc1",
	RegionAPOsaka1:     "oc1",
	RegionAPSeoul1:     "oc1",
	RegionAPSydney1:    "oc1",
	RegionAPTokyo1:     "oc1",
	RegionCAMontreal1:  "oc1",
	RegionCAToronto1:   "oc1",
	RegionEUAmsterdam1: "oc1",
	RegionFRA:          "oc1",
	RegionEUZurich1:    "oc1",
	RegionMEJeddah1:    "oc1",
	RegionMEDubai1:     "oc1",
	RegionSASaopaulo1:  "oc1",
	RegionUKCardiff1:   "oc1",
	RegionLHR:          "oc1",
	RegionIAD:          "oc1",
	RegionPHX:          "oc1",
	RegionSJC1:         "oc1",
	RegionSAVinhedo1:   "oc1",
	RegionSASantiago1:  "oc1",
	RegionILJerusalem1: "oc1",
	RegionEUMarseille1: "oc1",
	RegionAPSingapore1: "oc1",
	RegionMEAbudhabi1:  "oc1",
	RegionEUMilan1:     "oc1",

	RegionUSLangley1: "oc2",
	RegionUSLuke1:    "oc2",

	RegionUSGovAshburn1: "oc3",
	RegionUSGovChicago1: "oc3",
	RegionUSGovPhoenix1: "oc3",

	RegionUKGovLondon1:  "oc4",
	RegionUKGovCardiff1: "oc4",

	RegionAPChiyoda1: "oc8",
	RegionAPIbaraki1: "oc8",
}
