/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// DistributionsAnsibleAPIService DistributionsAnsibleAPI service
type DistributionsAnsibleAPIService service

type DistributionsAnsibleAPIDistributionsAnsibleAnsibleAddRoleRequest struct {
	ctx context.Context
	ApiService *DistributionsAnsibleAPIService
	ansibleAnsibleDistributionHref string
	nestedRole *NestedRole
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleAddRoleRequest) NestedRole(nestedRole NestedRole) DistributionsAnsibleAPIDistributionsAnsibleAnsibleAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.DistributionsAnsibleAnsibleAddRoleExecute(r)
}

/*
DistributionsAnsibleAnsibleAddRole Method for DistributionsAnsibleAnsibleAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleDistributionHref
 @return DistributionsAnsibleAPIDistributionsAnsibleAnsibleAddRoleRequest
*/
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleAddRole(ctx context.Context, ansibleAnsibleDistributionHref string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleAddRoleRequest {
	return DistributionsAnsibleAPIDistributionsAnsibleAnsibleAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleDistributionHref: ansibleAnsibleDistributionHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleAddRoleExecute(r DistributionsAnsibleAPIDistributionsAnsibleAnsibleAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsAnsibleAPIService.DistributionsAnsibleAnsibleAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_distribution_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_distribution_href"+"}", parameterValueToString(r.ansibleAnsibleDistributionHref, "ansibleAnsibleDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsAnsibleAPIDistributionsAnsibleAnsibleCreateRequest struct {
	ctx context.Context
	ApiService *DistributionsAnsibleAPIService
	ansibleAnsibleDistribution *AnsibleAnsibleDistribution
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleCreateRequest) AnsibleAnsibleDistribution(ansibleAnsibleDistribution AnsibleAnsibleDistribution) DistributionsAnsibleAPIDistributionsAnsibleAnsibleCreateRequest {
	r.ansibleAnsibleDistribution = &ansibleAnsibleDistribution
	return r
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleCreateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsAnsibleAnsibleCreateExecute(r)
}

/*
DistributionsAnsibleAnsibleCreate Create an ansible distribution

Trigger an asynchronous create task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return DistributionsAnsibleAPIDistributionsAnsibleAnsibleCreateRequest
*/
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleCreate(ctx context.Context) DistributionsAnsibleAPIDistributionsAnsibleAnsibleCreateRequest {
	return DistributionsAnsibleAPIDistributionsAnsibleAnsibleCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleCreateExecute(r DistributionsAnsibleAPIDistributionsAnsibleAnsibleCreateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsAnsibleAPIService.DistributionsAnsibleAnsibleCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/distributions/ansible/ansible/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleAnsibleDistribution == nil {
		return localVarReturnValue, nil, reportError("ansibleAnsibleDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleAnsibleDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsAnsibleAPIDistributionsAnsibleAnsibleDeleteRequest struct {
	ctx context.Context
	ApiService *DistributionsAnsibleAPIService
	ansibleAnsibleDistributionHref string
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsAnsibleAnsibleDeleteExecute(r)
}

/*
DistributionsAnsibleAnsibleDelete Delete an ansible distribution

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleDistributionHref
 @return DistributionsAnsibleAPIDistributionsAnsibleAnsibleDeleteRequest
*/
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleDelete(ctx context.Context, ansibleAnsibleDistributionHref string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleDeleteRequest {
	return DistributionsAnsibleAPIDistributionsAnsibleAnsibleDeleteRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleDistributionHref: ansibleAnsibleDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleDeleteExecute(r DistributionsAnsibleAPIDistributionsAnsibleAnsibleDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsAnsibleAPIService.DistributionsAnsibleAnsibleDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_distribution_href"+"}", parameterValueToString(r.ansibleAnsibleDistributionHref, "ansibleAnsibleDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest struct {
	ctx context.Context
	ApiService *DistributionsAnsibleAPIService
	basePath *string
	basePathContains *string
	basePathIcontains *string
	basePathIn *[]string
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	repository *string
	repositoryIn *[]string
	withContent *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where base_path matches value
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) BasePath(basePath string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.basePath = &basePath
	return r
}

// Filter results where base_path contains value
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) BasePathContains(basePathContains string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.basePathContains = &basePathContains
	return r
}

// Filter results where base_path contains value
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) BasePathIcontains(basePathIcontains string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.basePathIcontains = &basePathIcontains
	return r
}

// Filter results where base_path is in a comma-separated list of values
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) BasePathIn(basePathIn []string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.basePathIn = &basePathIn
	return r
}

// Number of results to return per page.
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) Limit(limit int32) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) Name(name string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) NameContains(nameContains string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) NameIcontains(nameIcontains string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) NameIn(nameIn []string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) NameStartswith(nameStartswith string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) Offset(offset int32) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;base_path&#x60; - Base path * &#x60;-base_path&#x60; - Base path (descending) * &#x60;hidden&#x60; - Hidden * &#x60;-hidden&#x60; - Hidden (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) Ordering(ordering []string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) PulpHrefIn(pulpHrefIn []string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) PulpIdIn(pulpIdIn []string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) PulpLabelSelect(pulpLabelSelect string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Filter results where repository matches value
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) Repository(repository string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.repository = &repository
	return r
}

// Filter results where repository is in a comma-separated list of values
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) RepositoryIn(repositoryIn []string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.repositoryIn = &repositoryIn
	return r
}

// Filter distributions based on the content served by them
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) WithContent(withContent string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.withContent = &withContent
	return r
}

// A list of fields to include in the response.
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) Fields(fields []string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) ExcludeFields(excludeFields []string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) Execute() (*PaginatedansibleAnsibleDistributionResponseList, *http.Response, error) {
	return r.ApiService.DistributionsAnsibleAnsibleListExecute(r)
}

/*
DistributionsAnsibleAnsibleList List ansible distributions

ViewSet for Ansible Distributions.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest
*/
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleList(ctx context.Context) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest {
	return DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedansibleAnsibleDistributionResponseList
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleListExecute(r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRequest) (*PaginatedansibleAnsibleDistributionResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedansibleAnsibleDistributionResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsAnsibleAPIService.DistributionsAnsibleAnsibleList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/distributions/ansible/ansible/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.basePath != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path", r.basePath, "")
	}
	if r.basePathContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__contains", r.basePathContains, "")
	}
	if r.basePathIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__icontains", r.basePathIcontains, "")
	}
	if r.basePathIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__in", r.basePathIn, "csv")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.repository != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository", r.repository, "")
	}
	if r.repositoryIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository__in", r.repositoryIn, "csv")
	}
	if r.withContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "with_content", r.withContent, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRolesRequest struct {
	ctx context.Context
	ApiService *DistributionsAnsibleAPIService
	ansibleAnsibleDistributionHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRolesRequest) Fields(fields []string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRolesRequest) ExcludeFields(excludeFields []string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.DistributionsAnsibleAnsibleListRolesExecute(r)
}

/*
DistributionsAnsibleAnsibleListRoles Method for DistributionsAnsibleAnsibleListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleDistributionHref
 @return DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRolesRequest
*/
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleListRoles(ctx context.Context, ansibleAnsibleDistributionHref string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRolesRequest {
	return DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRolesRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleDistributionHref: ansibleAnsibleDistributionHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleListRolesExecute(r DistributionsAnsibleAPIDistributionsAnsibleAnsibleListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsAnsibleAPIService.DistributionsAnsibleAnsibleListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_distribution_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_distribution_href"+"}", parameterValueToString(r.ansibleAnsibleDistributionHref, "ansibleAnsibleDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsAnsibleAPIDistributionsAnsibleAnsibleMyPermissionsRequest struct {
	ctx context.Context
	ApiService *DistributionsAnsibleAPIService
	ansibleAnsibleDistributionHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleMyPermissionsRequest) Fields(fields []string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleMyPermissionsRequest) ExcludeFields(excludeFields []string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.DistributionsAnsibleAnsibleMyPermissionsExecute(r)
}

/*
DistributionsAnsibleAnsibleMyPermissions Method for DistributionsAnsibleAnsibleMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleDistributionHref
 @return DistributionsAnsibleAPIDistributionsAnsibleAnsibleMyPermissionsRequest
*/
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleMyPermissions(ctx context.Context, ansibleAnsibleDistributionHref string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleMyPermissionsRequest {
	return DistributionsAnsibleAPIDistributionsAnsibleAnsibleMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleDistributionHref: ansibleAnsibleDistributionHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleMyPermissionsExecute(r DistributionsAnsibleAPIDistributionsAnsibleAnsibleMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsAnsibleAPIService.DistributionsAnsibleAnsibleMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_distribution_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_distribution_href"+"}", parameterValueToString(r.ansibleAnsibleDistributionHref, "ansibleAnsibleDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsAnsibleAPIDistributionsAnsibleAnsiblePartialUpdateRequest struct {
	ctx context.Context
	ApiService *DistributionsAnsibleAPIService
	ansibleAnsibleDistributionHref string
	patchedansibleAnsibleDistribution *PatchedansibleAnsibleDistribution
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsiblePartialUpdateRequest) PatchedansibleAnsibleDistribution(patchedansibleAnsibleDistribution PatchedansibleAnsibleDistribution) DistributionsAnsibleAPIDistributionsAnsibleAnsiblePartialUpdateRequest {
	r.patchedansibleAnsibleDistribution = &patchedansibleAnsibleDistribution
	return r
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsiblePartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsAnsibleAnsiblePartialUpdateExecute(r)
}

/*
DistributionsAnsibleAnsiblePartialUpdate Update an ansible distribution

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleDistributionHref
 @return DistributionsAnsibleAPIDistributionsAnsibleAnsiblePartialUpdateRequest
*/
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsiblePartialUpdate(ctx context.Context, ansibleAnsibleDistributionHref string) DistributionsAnsibleAPIDistributionsAnsibleAnsiblePartialUpdateRequest {
	return DistributionsAnsibleAPIDistributionsAnsibleAnsiblePartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleDistributionHref: ansibleAnsibleDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsiblePartialUpdateExecute(r DistributionsAnsibleAPIDistributionsAnsibleAnsiblePartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsAnsibleAPIService.DistributionsAnsibleAnsiblePartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_distribution_href"+"}", parameterValueToString(r.ansibleAnsibleDistributionHref, "ansibleAnsibleDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedansibleAnsibleDistribution == nil {
		return localVarReturnValue, nil, reportError("patchedansibleAnsibleDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedansibleAnsibleDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsAnsibleAPIDistributionsAnsibleAnsibleReadRequest struct {
	ctx context.Context
	ApiService *DistributionsAnsibleAPIService
	ansibleAnsibleDistributionHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleReadRequest) Fields(fields []string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleReadRequest) ExcludeFields(excludeFields []string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleReadRequest) Execute() (*AnsibleAnsibleDistributionResponse, *http.Response, error) {
	return r.ApiService.DistributionsAnsibleAnsibleReadExecute(r)
}

/*
DistributionsAnsibleAnsibleRead Inspect an ansible distribution

ViewSet for Ansible Distributions.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleDistributionHref
 @return DistributionsAnsibleAPIDistributionsAnsibleAnsibleReadRequest
*/
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleRead(ctx context.Context, ansibleAnsibleDistributionHref string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleReadRequest {
	return DistributionsAnsibleAPIDistributionsAnsibleAnsibleReadRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleDistributionHref: ansibleAnsibleDistributionHref,
	}
}

// Execute executes the request
//  @return AnsibleAnsibleDistributionResponse
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleReadExecute(r DistributionsAnsibleAPIDistributionsAnsibleAnsibleReadRequest) (*AnsibleAnsibleDistributionResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AnsibleAnsibleDistributionResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsAnsibleAPIService.DistributionsAnsibleAnsibleRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_distribution_href"+"}", parameterValueToString(r.ansibleAnsibleDistributionHref, "ansibleAnsibleDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsAnsibleAPIDistributionsAnsibleAnsibleRemoveRoleRequest struct {
	ctx context.Context
	ApiService *DistributionsAnsibleAPIService
	ansibleAnsibleDistributionHref string
	nestedRole *NestedRole
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleRemoveRoleRequest) NestedRole(nestedRole NestedRole) DistributionsAnsibleAPIDistributionsAnsibleAnsibleRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.DistributionsAnsibleAnsibleRemoveRoleExecute(r)
}

/*
DistributionsAnsibleAnsibleRemoveRole Method for DistributionsAnsibleAnsibleRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleDistributionHref
 @return DistributionsAnsibleAPIDistributionsAnsibleAnsibleRemoveRoleRequest
*/
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleRemoveRole(ctx context.Context, ansibleAnsibleDistributionHref string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleRemoveRoleRequest {
	return DistributionsAnsibleAPIDistributionsAnsibleAnsibleRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleDistributionHref: ansibleAnsibleDistributionHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleRemoveRoleExecute(r DistributionsAnsibleAPIDistributionsAnsibleAnsibleRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsAnsibleAPIService.DistributionsAnsibleAnsibleRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_distribution_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_distribution_href"+"}", parameterValueToString(r.ansibleAnsibleDistributionHref, "ansibleAnsibleDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsAnsibleAPIDistributionsAnsibleAnsibleUpdateRequest struct {
	ctx context.Context
	ApiService *DistributionsAnsibleAPIService
	ansibleAnsibleDistributionHref string
	ansibleAnsibleDistribution *AnsibleAnsibleDistribution
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleUpdateRequest) AnsibleAnsibleDistribution(ansibleAnsibleDistribution AnsibleAnsibleDistribution) DistributionsAnsibleAPIDistributionsAnsibleAnsibleUpdateRequest {
	r.ansibleAnsibleDistribution = &ansibleAnsibleDistribution
	return r
}

func (r DistributionsAnsibleAPIDistributionsAnsibleAnsibleUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsAnsibleAnsibleUpdateExecute(r)
}

/*
DistributionsAnsibleAnsibleUpdate Update an ansible distribution

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleDistributionHref
 @return DistributionsAnsibleAPIDistributionsAnsibleAnsibleUpdateRequest
*/
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleUpdate(ctx context.Context, ansibleAnsibleDistributionHref string) DistributionsAnsibleAPIDistributionsAnsibleAnsibleUpdateRequest {
	return DistributionsAnsibleAPIDistributionsAnsibleAnsibleUpdateRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleDistributionHref: ansibleAnsibleDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsAnsibleAPIService) DistributionsAnsibleAnsibleUpdateExecute(r DistributionsAnsibleAPIDistributionsAnsibleAnsibleUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsAnsibleAPIService.DistributionsAnsibleAnsibleUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_distribution_href"+"}", parameterValueToString(r.ansibleAnsibleDistributionHref, "ansibleAnsibleDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleAnsibleDistribution == nil {
		return localVarReturnValue, nil, reportError("ansibleAnsibleDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleAnsibleDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
