/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the Purge type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &Purge{}

// Purge struct for Purge
type Purge struct {
	// Purge tasks completed earlier than this timestamp. Format '%Y-%m-%d[T%H:%M:%S]'
	FinishedBefore *time.Time `json:"finished_before,omitempty"`
	// List of task-states to be purged. Only 'final' states are allowed.
	States []StatesEnum `json:"states,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _Purge Purge

// NewPurge instantiates a new Purge object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPurge() *Purge {
	this := Purge{}
	return &this
}

// NewPurgeWithDefaults instantiates a new Purge object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPurgeWithDefaults() *Purge {
	this := Purge{}
	return &this
}

// GetFinishedBefore returns the FinishedBefore field value if set, zero value otherwise.
func (o *Purge) GetFinishedBefore() time.Time {
	if o == nil || IsNil(o.FinishedBefore) {
		var ret time.Time
		return ret
	}
	return *o.FinishedBefore
}

// GetFinishedBeforeOk returns a tuple with the FinishedBefore field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Purge) GetFinishedBeforeOk() (*time.Time, bool) {
	if o == nil || IsNil(o.FinishedBefore) {
		return nil, false
	}
	return o.FinishedBefore, true
}

// HasFinishedBefore returns a boolean if a field has been set.
func (o *Purge) HasFinishedBefore() bool {
	if o != nil && !IsNil(o.FinishedBefore) {
		return true
	}

	return false
}

// SetFinishedBefore gets a reference to the given time.Time and assigns it to the FinishedBefore field.
func (o *Purge) SetFinishedBefore(v time.Time) {
	o.FinishedBefore = &v
}

// GetStates returns the States field value if set, zero value otherwise.
func (o *Purge) GetStates() []StatesEnum {
	if o == nil || IsNil(o.States) {
		var ret []StatesEnum
		return ret
	}
	return o.States
}

// GetStatesOk returns a tuple with the States field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Purge) GetStatesOk() ([]StatesEnum, bool) {
	if o == nil || IsNil(o.States) {
		return nil, false
	}
	return o.States, true
}

// HasStates returns a boolean if a field has been set.
func (o *Purge) HasStates() bool {
	if o != nil && !IsNil(o.States) {
		return true
	}

	return false
}

// SetStates gets a reference to the given []StatesEnum and assigns it to the States field.
func (o *Purge) SetStates(v []StatesEnum) {
	o.States = v
}

func (o Purge) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o Purge) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.FinishedBefore) {
		toSerialize["finished_before"] = o.FinishedBefore
	}
	if !IsNil(o.States) {
		toSerialize["states"] = o.States
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *Purge) UnmarshalJSON(bytes []byte) (err error) {
	varPurge := _Purge{}

	if err = json.Unmarshal(bytes, &varPurge); err == nil {
		*o = Purge(varPurge)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "finished_before")
		delete(additionalProperties, "states")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePurge struct {
	value *Purge
	isSet bool
}

func (v NullablePurge) Get() *Purge {
	return v.value
}

func (v *NullablePurge) Set(val *Purge) {
	v.value = val
	v.isSet = true
}

func (v NullablePurge) IsSet() bool {
	return v.isSet
}

func (v *NullablePurge) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePurge(val *Purge) *NullablePurge {
	return &NullablePurge{value: val, isSet: true}
}

func (v NullablePurge) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePurge) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


