/*! axe v4.0.2
 * Copyright (c) 2020 Deque Systems, Inc.
 *
 * Your use of this Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This entire copyright notice must appear in every copy of this file you
 * distribute or in any file that contains substantial portions of this source
 * code.
 */
(function axeFunction(window) {
  var global = window;
  var document = window.document;
  'use strict';
  function _typeof(obj) {
    '@babel/helpers - typeof';
    if (typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol') {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === 'function' && obj.constructor === Symbol && obj !== Symbol.prototype ? 'symbol' : typeof obj;
      };
    }
    return _typeof(obj);
  }
  var axe = axe || {};
  axe.version = '4.0.2';
  if (typeof define === 'function' && define.amd) {
    define('axe-core', [], function() {
      'use strict';
      return axe;
    });
  }
  if ((typeof module === 'undefined' ? 'undefined' : _typeof(module)) === 'object' && module.exports && typeof axeFunction.toString === 'function') {
    axe.source = '(' + axeFunction.toString() + ')(typeof window === "object" ? window : this);';
    module.exports = axe;
  }
  if (typeof window.getComputedStyle === 'function') {
    window.axe = axe;
  }
  var commons;
  function SupportError(error) {
    this.name = 'SupportError';
    this.cause = error.cause;
    this.message = '`'.concat(error.cause, '` - feature unsupported in your environment.');
    if (error.ruleId) {
      this.ruleId = error.ruleId;
      this.message += ' Skipping '.concat(this.ruleId, ' rule.');
    }
    this.stack = new Error().stack;
  }
  SupportError.prototype = Object.create(Error.prototype);
  SupportError.prototype.constructor = SupportError;
  'use strict';
  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  function _inherits(subClass, superClass) {
    if (typeof superClass !== 'function' && superClass !== null) {
      throw new TypeError('Super expression must either be null or a function');
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) {
      _setPrototypeOf(subClass, superClass);
    }
  }
  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };
    return _setPrototypeOf(o, p);
  }
  function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();
    return function _createSuperInternal() {
      var Super = _getPrototypeOf(Derived), result;
      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf(this).constructor;
        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }
      return _possibleConstructorReturn(this, result);
    };
  }
  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === 'object' || typeof call === 'function')) {
      return call;
    }
    return _assertThisInitialized(self);
  }
  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError('this hasn\'t been initialised - super() hasn\'t been called');
    }
    return self;
  }
  function _isNativeReflectConstruct() {
    if (typeof Reflect === 'undefined' || !Reflect.construct) {
      return false;
    }
    if (Reflect.construct.sham) {
      return false;
    }
    if (typeof Proxy === 'function') {
      return true;
    }
    try {
      Date.prototype.toString.call(Reflect.construct(Date, [], function() {}));
      return true;
    } catch (e) {
      return false;
    }
  }
  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }
  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError('Cannot call a class as a function');
    }
  }
  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ('value' in descriptor) {
        descriptor.writable = true;
      }
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) {
      _defineProperties(Constructor.prototype, protoProps);
    }
    if (staticProps) {
      _defineProperties(Constructor, staticProps);
    }
    return Constructor;
  }
  function _objectWithoutProperties(source, excluded) {
    if (source == null) {
      return {};
    }
    var target = _objectWithoutPropertiesLoose(source, excluded);
    var key, i;
    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) {
          continue;
        }
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) {
          continue;
        }
        target[key] = source[key];
      }
    }
    return target;
  }
  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) {
      return {};
    }
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;
    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) {
        continue;
      }
      target[key] = source[key];
    }
    return target;
  }
  function _extends() {
    _extends = Object.assign || function(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
    return _extends.apply(this, arguments);
  }
  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
  }
  function _nonIterableRest() {
    throw new TypeError('Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.');
  }
  function _iterableToArrayLimit(arr, i) {
    if (typeof Symbol === 'undefined' || !(Symbol.iterator in Object(arr))) {
      return;
    }
    var _arr = [];
    var _n = true;
    var _d = false;
    var _e = undefined;
    try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);
        if (i && _arr.length === i) {
          break;
        }
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i['return'] != null) {
          _i['return']();
        }
      } finally {
        if (_d) {
          throw _e;
        }
      }
    }
    return _arr;
  }
  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) {
      return arr;
    }
  }
  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }
  function _nonIterableSpread() {
    throw new TypeError('Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.');
  }
  function _unsupportedIterableToArray(o, minLen) {
    if (!o) {
      return;
    }
    if (typeof o === 'string') {
      return _arrayLikeToArray(o, minLen);
    }
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === 'Object' && o.constructor) {
      n = o.constructor.name;
    }
    if (n === 'Map' || n === 'Set') {
      return Array.from(o);
    }
    if (n === 'Arguments' || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
      return _arrayLikeToArray(o, minLen);
    }
  }
  function _iterableToArray(iter) {
    if (typeof Symbol !== 'undefined' && Symbol.iterator in Object(iter)) {
      return Array.from(iter);
    }
  }
  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      return _arrayLikeToArray(arr);
    }
  }
  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) {
      len = arr.length;
    }
    for (var i = 0, arr2 = new Array(len); i < len; i++) {
      arr2[i] = arr[i];
    }
    return arr2;
  }
  function _typeof(obj) {
    '@babel/helpers - typeof';
    if (typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol') {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === 'function' && obj.constructor === Symbol && obj !== Symbol.prototype ? 'symbol' : typeof obj;
      };
    }
    return _typeof(obj);
  }
  (function(modules) {
    var installedModules = {};
    function __webpack_require__(moduleId) {
      if (installedModules[moduleId]) {
        return installedModules[moduleId].exports;
      }
      var module = installedModules[moduleId] = {
        i: moduleId,
        l: false,
        exports: {}
      };
      modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
      module.l = true;
      return module.exports;
    }
    __webpack_require__.m = modules;
    __webpack_require__.c = installedModules;
    __webpack_require__.d = function(exports, name, getter) {
      if (!__webpack_require__.o(exports, name)) {
        Object.defineProperty(exports, name, {
          enumerable: true,
          get: getter
        });
      }
    };
    __webpack_require__.r = function(exports) {
      if (typeof Symbol !== 'undefined' && Symbol.toStringTag) {
        Object.defineProperty(exports, Symbol.toStringTag, {
          value: 'Module'
        });
      }
      Object.defineProperty(exports, '__esModule', {
        value: true
      });
    };
    __webpack_require__.t = function(value, mode) {
      if (mode & 1) {
        value = __webpack_require__(value);
      }
      if (mode & 8) {
        return value;
      }
      if (mode & 4 && _typeof(value) === 'object' && value && value.__esModule) {
        return value;
      }
      var ns = Object.create(null);
      __webpack_require__.r(ns);
      Object.defineProperty(ns, 'default', {
        enumerable: true,
        value: value
      });
      if (mode & 2 && typeof value != 'string') {
        for (var key in value) {
          __webpack_require__.d(ns, key, function(key) {
            return value[key];
          }.bind(null, key));
        }
      }
      return ns;
    };
    __webpack_require__.n = function(module) {
      var getter = module && module.__esModule ? function getDefault() {
        return module['default'];
      } : function getModuleExports() {
        return module;
      };
      __webpack_require__.d(getter, 'a', getter);
      return getter;
    };
    __webpack_require__.o = function(object, property) {
      return Object.prototype.hasOwnProperty.call(object, property);
    };
    __webpack_require__.p = '';
    return __webpack_require__(__webpack_require__.s = './lib/core/core.js');
  })({
    './lib/checks/aria/abstractrole-evaluate.js': function libChecksAriaAbstractroleEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/index.js');
      function abstractroleEvaluate(node, options, virtualNode) {
        var abstractRoles = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['tokenList'])(virtualNode.attr('role')).filter(function(role) {
          return Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['getRoleType'])(role) === 'abstract';
        });
        if (abstractRoles.length > 0) {
          this.data(abstractRoles);
          return true;
        }
        return false;
      }
      __webpack_exports__['default'] = abstractroleEvaluate;
    },
    './lib/checks/aria/aria-allowed-attr-evaluate.js': function libChecksAriaAriaAllowedAttrEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/index.js');
      function ariaAllowedAttrEvaluate(node, options) {
        var invalid = [];
        var role = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['getRole'])(node);
        var attrs = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['getNodeAttributes'])(node);
        var allowed = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['allowedAttr'])(role);
        if (Array.isArray(options[role])) {
          allowed = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['uniqueArray'])(options[role].concat(allowed));
        }
        if (role && allowed) {
          for (var i = 0; i < attrs.length; i++) {
            var attr = attrs[i];
            var attrName = attr.name;
            if (Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['validateAttr'])(attrName) && !allowed.includes(attrName)) {
              invalid.push(attrName + '="' + attr.nodeValue + '"');
            }
          }
        }
        if (invalid.length) {
          this.data(invalid);
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = ariaAllowedAttrEvaluate;
    },
    './lib/checks/aria/aria-allowed-role-evaluate.js': function libChecksAriaAriaAllowedRoleEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/index.js');
      function ariaAllowedRoledEvaluate(node) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var _options$allowImplici = options.allowImplicit, allowImplicit = _options$allowImplici === void 0 ? true : _options$allowImplici, _options$ignoredTags = options.ignoredTags, ignoredTags = _options$ignoredTags === void 0 ? [] : _options$ignoredTags;
        var tagName = node.nodeName.toUpperCase();
        if (ignoredTags.map(function(t) {
          return t.toUpperCase();
        }).includes(tagName)) {
          return true;
        }
        var unallowedRoles = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['getElementUnallowedRoles'])(node, allowImplicit);
        if (unallowedRoles.length) {
          this.data(unallowedRoles);
          if (!Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isVisible'])(node, true)) {
            return undefined;
          }
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = ariaAllowedRoledEvaluate;
    },
    './lib/checks/aria/aria-errormessage-evaluate.js': function libChecksAriaAriaErrormessageEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      var _commons_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function ariaErrormessageEvaluate(node, options) {
        options = Array.isArray(options) ? options : [];
        var attr = node.getAttribute('aria-errormessage');
        var hasAttr = node.hasAttribute('aria-errormessage');
        var doc = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_1__['getRootNode'])(node);
        function validateAttrValue(attr) {
          if (attr.trim() === '') {
            return _standards__WEBPACK_IMPORTED_MODULE_0__['default'].ariaAttrs['aria-errormessage'].allowEmpty;
          }
          var idref = attr && doc.getElementById(attr);
          if (idref) {
            return idref.getAttribute('role') === 'alert' || idref.getAttribute('aria-live') === 'assertive' || Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['tokenList'])(node.getAttribute('aria-describedby') || '').indexOf(attr) > -1;
          }
        }
        if (options.indexOf(attr) === -1 && hasAttr) {
          if (!validateAttrValue(attr)) {
            this.data(Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['tokenList'])(attr));
            return false;
          }
        }
        return true;
      }
      __webpack_exports__['default'] = ariaErrormessageEvaluate;
    },
    './lib/checks/aria/aria-hidden-body-evaluate.js': function libChecksAriaAriaHiddenBodyEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function ariaHiddenBodyEvaluate(node, options, virtualNode) {
        return virtualNode.attr('aria-hidden') !== 'true';
      }
      __webpack_exports__['default'] = ariaHiddenBodyEvaluate;
    },
    './lib/checks/aria/aria-required-attr-evaluate.js': function libChecksAriaAriaRequiredAttrEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      var _commons_standards__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/standards/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function ariaRequiredAttrEvaluate(node) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getNodeFromTree'])(node);
        var missing = [];
        if (node.hasAttributes()) {
          var role = node.getAttribute('role');
          var required = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['requiredAttr'])(role);
          var elmSpec = Object(_commons_standards__WEBPACK_IMPORTED_MODULE_1__['getElementSpec'])(vNode);
          if (Array.isArray(options[role])) {
            required = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['uniqueArray'])(options[role], required);
          }
          if (role && required) {
            for (var i = 0, l = required.length; i < l; i++) {
              var attr = required[i];
              if (!node.getAttribute(attr) && !(elmSpec.implicitAttrs && typeof elmSpec.implicitAttrs[attr] !== 'undefined')) {
                missing.push(attr);
              }
            }
          }
        }
        if (missing.length) {
          this.data(missing);
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = ariaRequiredAttrEvaluate;
    },
    './lib/checks/aria/aria-required-children-evaluate.js': function libChecksAriaAriaRequiredChildrenEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      var _commons_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/index.js');
      function getOwnedRoles(virtualNode) {
        var ownedRoles = [];
        var ownedElements = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['getOwnedVirtual'])(virtualNode);
        for (var i = 0; i < ownedElements.length; i++) {
          var ownedElement = ownedElements[i];
          var role = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['getRole'])(ownedElement);
          if ([ 'presentation', 'none', null ].includes(role)) {
            ownedElements.push.apply(ownedElements, _toConsumableArray(ownedElement.children));
          } else if (role) {
            ownedRoles.push(role);
          }
        }
        return ownedRoles;
      }
      function missingRequiredChildren(virtualNode, role, required, ownedRoles) {
        var isCombobox = role === 'combobox';
        if (isCombobox) {
          var textTypeInputs = [ 'text', 'search', 'email', 'url', 'tel' ];
          if (virtualNode.props.nodeName === 'input' && textTypeInputs.includes(virtualNode.props.type) || ownedRoles.includes('searchbox')) {
            required = required.filter(function(requiredRole) {
              return requiredRole !== 'textbox';
            });
          }
          var expandedChildRoles = [ 'listbox', 'tree', 'grid', 'dialog' ];
          var expandedValue = virtualNode.attr('aria-expanded');
          var expanded = expandedValue && expandedValue.toLowerCase() !== 'false';
          var popupRole = (virtualNode.attr('aria-haspopup') || 'listbox').toLowerCase();
          required = required.filter(function(requiredRole) {
            return !expandedChildRoles.includes(requiredRole) || expanded && requiredRole === popupRole;
          });
        }
        for (var i = 0; i < ownedRoles.length; i++) {
          var ownedRole = ownedRoles[i];
          if (required.includes(ownedRole)) {
            required = required.filter(function(requiredRole) {
              return requiredRole !== ownedRole;
            });
            if (!isCombobox) {
              return null;
            }
          }
        }
        if (required.length) {
          return required;
        }
        return null;
      }
      function ariaRequiredChildrenEvaluate(node, options, virtualNode) {
        var reviewEmpty = options && Array.isArray(options.reviewEmpty) ? options.reviewEmpty : [];
        var role = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['getExplicitRole'])(virtualNode, {
          dpub: true
        });
        var required = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['requiredOwned'])(role);
        if (!required) {
          return true;
        }
        var ownedRoles = getOwnedRoles(virtualNode);
        var missing = missingRequiredChildren(virtualNode, role, required, ownedRoles);
        if (!missing) {
          return true;
        }
        this.data(missing);
        if (reviewEmpty.includes(role) && !Object(_commons_dom__WEBPACK_IMPORTED_MODULE_1__['hasContentVirtual'])(virtualNode, false, true) && !ownedRoles.length && (!virtualNode.hasAttr('aria-owns') || !Object(_commons_dom__WEBPACK_IMPORTED_MODULE_1__['idrefs'])(node, 'aria-owns').length)) {
          return undefined;
        }
        return false;
      }
      __webpack_exports__['default'] = ariaRequiredChildrenEvaluate;
    },
    './lib/checks/aria/aria-required-parent-evaluate.js': function libChecksAriaAriaRequiredParentEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      var _commons_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function getMissingContext(virtualNode, reqContext, includeElement) {
        var explicitRole = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['getExplicitRole'])(virtualNode);
        if (!reqContext) {
          reqContext = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['requiredContext'])(explicitRole);
        }
        if (!reqContext) {
          return null;
        }
        var vNode = includeElement ? virtualNode : virtualNode.parent;
        while (vNode) {
          var parentRole = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['getRole'])(vNode);
          if (reqContext.includes(parentRole)) {
            return null;
          } else if (parentRole && ![ 'presentation', 'none' ].includes(parentRole)) {
            return reqContext;
          }
          vNode = vNode.parent;
        }
        return reqContext;
      }
      function getAriaOwners(element) {
        var owners = [], o = null;
        while (element) {
          if (element.getAttribute('id')) {
            var id = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['escapeSelector'])(element.getAttribute('id'));
            var doc = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_1__['getRootNode'])(element);
            o = doc.querySelector('[aria-owns~='.concat(id, ']'));
            if (o) {
              owners.push(o);
            }
          }
          element = element.parentElement;
        }
        return owners.length ? owners : null;
      }
      function ariaRequiredParentEvaluate(node, options, virtualNode) {
        var missingParents = getMissingContext(virtualNode);
        if (!missingParents) {
          return true;
        }
        var owners = getAriaOwners(node);
        if (owners) {
          for (var i = 0, l = owners.length; i < l; i++) {
            missingParents = getMissingContext(Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getNodeFromTree'])(owners[i]), missingParents, true);
            if (!missingParents) {
              return true;
            }
          }
        }
        this.data(missingParents);
        return false;
      }
      __webpack_exports__['default'] = ariaRequiredParentEvaluate;
    },
    './lib/checks/aria/aria-roledescription-evaluate.js': function libChecksAriaAriaRoledescriptionEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      function ariaRoledescriptionEvaluate(node) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var role = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['getRole'])(node);
        var supportedRoles = options.supportedRoles || [];
        if (supportedRoles.includes(role)) {
          return true;
        }
        if (role && role !== 'presentation' && role !== 'none') {
          return undefined;
        }
        return false;
      }
      __webpack_exports__['default'] = ariaRoledescriptionEvaluate;
    },
    './lib/checks/aria/aria-unsupported-attr-evaluate.js': function libChecksAriaAriaUnsupportedAttrEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      var _standards__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/standards/index.js');
      var _commons_matches__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/matches/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/index.js');
      function ariaUnsupportedAttrEvaluate(node) {
        var unsupportedAttrs = Array.from(Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['getNodeAttributes'])(node)).filter(function(_ref) {
          var name = _ref.name;
          var attribute = _standards__WEBPACK_IMPORTED_MODULE_1__['default'].ariaAttrs[name];
          if (!Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['validateAttr'])(name)) {
            return false;
          }
          var unsupported = attribute.unsupported;
          if (_typeof(unsupported) !== 'object') {
            return !!unsupported;
          }
          return !Object(_commons_matches__WEBPACK_IMPORTED_MODULE_2__['default'])(node, unsupported.exceptions);
        }).map(function(candidate) {
          return candidate.name.toString();
        });
        if (unsupportedAttrs.length) {
          this.data(unsupportedAttrs);
          return true;
        }
        return false;
      }
      __webpack_exports__['default'] = ariaUnsupportedAttrEvaluate;
    },
    './lib/checks/aria/aria-valid-attr-evaluate.js': function libChecksAriaAriaValidAttrEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function ariaValidAttrEvaluate(node, options) {
        options = Array.isArray(options.value) ? options.value : [];
        var invalid = [], aria = /^aria-/;
        var attr, attrs = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeAttributes'])(node);
        for (var i = 0, l = attrs.length; i < l; i++) {
          attr = attrs[i].name;
          if (options.indexOf(attr) === -1 && aria.test(attr) && !Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['validateAttr'])(attr)) {
            invalid.push(attr);
          }
        }
        if (invalid.length) {
          this.data(invalid);
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = ariaValidAttrEvaluate;
    },
    './lib/checks/aria/aria-valid-attr-value-evaluate.js': function libChecksAriaAriaValidAttrValueEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function ariaValidAttrValueEvaluate(node, options) {
        options = Array.isArray(options.value) ? options.value : [];
        var needsReview = '';
        var messageKey = '';
        var invalid = [];
        var aria = /^aria-/;
        var attrs = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeAttributes'])(node);
        var skipAttrs = [ 'aria-errormessage' ];
        var preChecks = {
          'aria-controls': function ariaControls() {
            return node.getAttribute('aria-expanded') !== 'false' && node.getAttribute('aria-selected') !== 'false';
          },
          'aria-current': function ariaCurrent() {
            if (!Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['validateAttrValue'])(node, 'aria-current')) {
              needsReview = 'aria-current="'.concat(node.getAttribute('aria-current'), '"');
              messageKey = 'ariaCurrent';
            }
            return;
          },
          'aria-owns': function ariaOwns() {
            return node.getAttribute('aria-expanded') !== 'false';
          },
          'aria-describedby': function ariaDescribedby() {
            if (!Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['validateAttrValue'])(node, 'aria-describedby')) {
              needsReview = 'aria-describedby="'.concat(node.getAttribute('aria-describedby'), '"');
              messageKey = 'noId';
            }
            return;
          }
        };
        for (var i = 0, l = attrs.length; i < l; i++) {
          var attr = attrs[i];
          var attrName = attr.name;
          if (!skipAttrs.includes(attrName) && options.indexOf(attrName) === -1 && aria.test(attrName) && (preChecks[attrName] ? preChecks[attrName]() : true) && !Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['validateAttrValue'])(node, attrName)) {
            invalid.push(''.concat(attrName, '="').concat(attr.nodeValue, '"'));
          }
        }
        if (needsReview) {
          this.data({
            messageKey: messageKey,
            needsReview: needsReview
          });
          return undefined;
        }
        if (invalid.length) {
          this.data(invalid);
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = ariaValidAttrValueEvaluate;
    },
    './lib/checks/aria/fallbackrole-evaluate.js': function libChecksAriaFallbackroleEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function fallbackroleEvaluate(node, options, virtualNode) {
        return Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['tokenList'])(virtualNode.attr('role')).length > 1;
      }
      __webpack_exports__['default'] = fallbackroleEvaluate;
    },
    './lib/checks/aria/has-widget-role-evaluate.js': function libChecksAriaHasWidgetRoleEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      function hasWidgetRoleEvaluate(node) {
        var role = node.getAttribute('role');
        if (role === null) {
          return false;
        }
        var roleType = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['getRoleType'])(role);
        return roleType === 'widget' || roleType === 'composite';
      }
      __webpack_exports__['default'] = hasWidgetRoleEvaluate;
    },
    './lib/checks/aria/invalidrole-evaluate.js': function libChecksAriaInvalidroleEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function invalidroleEvaluate(node, options, virtualNode) {
        var allRoles = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['tokenList'])(virtualNode.attr('role'));
        var allInvalid = allRoles.every(function(role) {
          return !Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['isValidRole'])(role, {
            allowAbstract: true
          });
        });
        if (allInvalid) {
          this.data(allRoles);
          return true;
        }
        return false;
      }
      __webpack_exports__['default'] = invalidroleEvaluate;
    },
    './lib/checks/aria/no-implicit-explicit-label-evaluate.js': function libChecksAriaNoImplicitExplicitLabelEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      var _commons_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/index.js');
      function noImplicitExplicitLabelEvaluate(node, options, virtualNode) {
        var role = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['getRole'])(virtualNode, {
          noImplicit: true
        });
        this.data(role);
        try {
          var label = Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['sanitize'])(Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['labelText'])(virtualNode)).toLowerCase();
          var accText = Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['sanitize'])(Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['accessibleTextVirtual'])(virtualNode)).toLowerCase();
          if (!accText && !label) {
            return false;
          }
          if (!accText && label) {
            return undefined;
          }
          if (!accText.includes(label)) {
            return undefined;
          }
          return false;
        } catch (e) {
          return undefined;
        }
      }
      __webpack_exports__['default'] = noImplicitExplicitLabelEvaluate;
    },
    './lib/checks/aria/unsupportedrole-evaluate.js': function libChecksAriaUnsupportedroleEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      function unsupportedroleEvaluate(node) {
        return Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['isUnsupportedRole'])(Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['getRole'])(node));
      }
      __webpack_exports__['default'] = unsupportedroleEvaluate;
    },
    './lib/checks/aria/valid-scrollable-semantics-evaluate.js': function libChecksAriaValidScrollableSemanticsEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var VALID_TAG_NAMES_FOR_SCROLLABLE_REGIONS = {
        ARTICLE: true,
        ASIDE: true,
        NAV: true,
        SECTION: true
      };
      var VALID_ROLES_FOR_SCROLLABLE_REGIONS = {
        application: true,
        banner: false,
        complementary: true,
        contentinfo: true,
        form: true,
        main: true,
        navigation: true,
        region: true,
        search: false
      };
      function validScrollableTagName(node) {
        var nodeName = node.nodeName.toUpperCase();
        return VALID_TAG_NAMES_FOR_SCROLLABLE_REGIONS[nodeName] || false;
      }
      function validScrollableRole(node) {
        var role = node.getAttribute('role');
        if (!role) {
          return false;
        }
        return VALID_ROLES_FOR_SCROLLABLE_REGIONS[role.toLowerCase()] || false;
      }
      function validScrollableSemanticsEvaluate(node) {
        return validScrollableRole(node) || validScrollableTagName(node);
      }
      __webpack_exports__['default'] = validScrollableSemanticsEvaluate;
    },
    './lib/checks/color/color-contrast-evaluate.js': function libChecksColorColorContrastEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/index.js');
      var _commons_color__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/color/index.js');
      function colorContrastEvaluate(node, options, virtualNode) {
        if (!Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isVisible'])(node, false)) {
          return true;
        }
        var ignoreUnicode = options.ignoreUnicode, ignoreLength = options.ignoreLength, boldValue = options.boldValue, boldTextPt = options.boldTextPt, largeTextPt = options.largeTextPt, contrastRatio = options.contrastRatio;
        var visibleText = Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['visibleVirtual'])(virtualNode, false, true);
        var textContainsOnlyUnicode = Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['hasUnicode'])(visibleText, {
          nonBmp: true
        }) && Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['sanitize'])(Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['removeUnicode'])(visibleText, {
          nonBmp: true
        })) === '';
        if (textContainsOnlyUnicode && ignoreUnicode) {
          this.data({
            messageKey: 'nonBmp'
          });
          return undefined;
        }
        var bgNodes = [];
        var bgColor = Object(_commons_color__WEBPACK_IMPORTED_MODULE_2__['getBackgroundColor'])(node, bgNodes);
        var fgColor = Object(_commons_color__WEBPACK_IMPORTED_MODULE_2__['getForegroundColor'])(node, false, bgColor);
        var nodeStyle = window.getComputedStyle(node);
        var fontSize = parseFloat(nodeStyle.getPropertyValue('font-size'));
        var fontWeight = nodeStyle.getPropertyValue('font-weight');
        var bold = parseFloat(fontWeight) >= boldValue || fontWeight === 'bold';
        var contrast = Object(_commons_color__WEBPACK_IMPORTED_MODULE_2__['getContrast'])(bgColor, fgColor);
        var ptSize = Math.ceil(fontSize * 72) / 96;
        var isSmallFont = bold && ptSize < boldTextPt || !bold && ptSize < largeTextPt;
        var _ref2 = isSmallFont ? contrastRatio.normal : contrastRatio.large, expected = _ref2.expected, minThreshold = _ref2.minThreshold, maxThreshold = _ref2.maxThreshold;
        var isValid = contrast > expected;
        if (typeof minThreshold === 'number' && contrast < minThreshold || typeof maxThreshold === 'number' && contrast > maxThreshold) {
          return true;
        }
        var truncatedResult = Math.floor(contrast * 100) / 100;
        var missing;
        if (bgColor === null) {
          missing = _commons_color__WEBPACK_IMPORTED_MODULE_2__['incompleteData'].get('bgColor');
        }
        var equalRatio = truncatedResult === 1;
        var shortTextContent = visibleText.length === 1;
        if (equalRatio) {
          missing = _commons_color__WEBPACK_IMPORTED_MODULE_2__['incompleteData'].set('bgColor', 'equalRatio');
        } else if (shortTextContent && !ignoreLength) {
          missing = 'shortTextContent';
        }
        var data = {
          fgColor: fgColor ? fgColor.toHexString() : undefined,
          bgColor: bgColor ? bgColor.toHexString() : undefined,
          contrastRatio: truncatedResult,
          fontSize: ''.concat((fontSize * 72 / 96).toFixed(1), 'pt (').concat(fontSize, 'px)'),
          fontWeight: bold ? 'bold' : 'normal',
          messageKey: missing,
          expectedContrastRatio: expected + ':1'
        };
        this.data(data);
        if (fgColor === null || bgColor === null || equalRatio || shortTextContent && !ignoreLength && !isValid) {
          missing = null;
          _commons_color__WEBPACK_IMPORTED_MODULE_2__['incompleteData'].clear();
          this.relatedNodes(bgNodes);
          return undefined;
        }
        if (!isValid) {
          this.relatedNodes(bgNodes);
        }
        return isValid;
      }
      __webpack_exports__['default'] = colorContrastEvaluate;
    },
    './lib/checks/color/link-in-text-block-evaluate.js': function libChecksColorLinkInTextBlockEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/color/index.js');
      function getContrast(color1, color2) {
        var c1lum = color1.getRelativeLuminance();
        var c2lum = color2.getRelativeLuminance();
        return (Math.max(c1lum, c2lum) + .05) / (Math.min(c1lum, c2lum) + .05);
      }
      var blockLike = [ 'block', 'list-item', 'table', 'flex', 'grid', 'inline-block' ];
      function isBlock(elm) {
        var display = window.getComputedStyle(elm).getPropertyValue('display');
        return blockLike.indexOf(display) !== -1 || display.substr(0, 6) === 'table-';
      }
      function linkInTextBlockEvaluate(node) {
        if (isBlock(node)) {
          return false;
        }
        var parentBlock = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getComposedParent'])(node);
        while (parentBlock.nodeType === 1 && !isBlock(parentBlock)) {
          parentBlock = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getComposedParent'])(parentBlock);
        }
        this.relatedNodes([ parentBlock ]);
        if (Object(_commons_color__WEBPACK_IMPORTED_MODULE_1__['elementIsDistinct'])(node, parentBlock)) {
          return true;
        } else {
          var nodeColor, parentColor;
          nodeColor = Object(_commons_color__WEBPACK_IMPORTED_MODULE_1__['getForegroundColor'])(node);
          parentColor = Object(_commons_color__WEBPACK_IMPORTED_MODULE_1__['getForegroundColor'])(parentBlock);
          if (!nodeColor || !parentColor) {
            return undefined;
          }
          var contrast = getContrast(nodeColor, parentColor);
          if (contrast === 1) {
            return true;
          } else if (contrast >= 3) {
            _commons_color__WEBPACK_IMPORTED_MODULE_1__['incompleteData'].set('fgColor', 'bgContrast');
            this.data({
              messageKey: _commons_color__WEBPACK_IMPORTED_MODULE_1__['incompleteData'].get('fgColor')
            });
            _commons_color__WEBPACK_IMPORTED_MODULE_1__['incompleteData'].clear();
            return undefined;
          }
          nodeColor = Object(_commons_color__WEBPACK_IMPORTED_MODULE_1__['getBackgroundColor'])(node);
          parentColor = Object(_commons_color__WEBPACK_IMPORTED_MODULE_1__['getBackgroundColor'])(parentBlock);
          if (!nodeColor || !parentColor || getContrast(nodeColor, parentColor) >= 3) {
            var reason;
            if (!nodeColor || !parentColor) {
              reason = _commons_color__WEBPACK_IMPORTED_MODULE_1__['incompleteData'].get('bgColor');
            } else {
              reason = 'bgContrast';
            }
            _commons_color__WEBPACK_IMPORTED_MODULE_1__['incompleteData'].set('fgColor', reason);
            this.data({
              messageKey: _commons_color__WEBPACK_IMPORTED_MODULE_1__['incompleteData'].get('fgColor')
            });
            _commons_color__WEBPACK_IMPORTED_MODULE_1__['incompleteData'].clear();
            return undefined;
          }
        }
        return false;
      }
      __webpack_exports__['default'] = linkInTextBlockEvaluate;
    },
    './lib/checks/forms/autocomplete-appropriate-evaluate.js': function libChecksFormsAutocompleteAppropriateEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function autocompleteAppropriateEvaluate(node, options, virtualNode) {
        if (virtualNode.props.nodeName !== 'input') {
          return true;
        }
        var number = [ 'text', 'search', 'number' ];
        var url = [ 'text', 'search', 'url' ];
        var allowedTypesMap = {
          bday: [ 'text', 'search', 'date' ],
          email: [ 'text', 'search', 'email' ],
          'cc-exp': [ 'text', 'search', 'month' ],
          'street-address': [ 'text' ],
          tel: [ 'text', 'search', 'tel' ],
          'tel-country-code': [ 'text', 'search', 'tel' ],
          'tel-national': [ 'text', 'search', 'tel' ],
          'tel-area-code': [ 'text', 'search', 'tel' ],
          'tel-local': [ 'text', 'search', 'tel' ],
          'tel-local-prefix': [ 'text', 'search', 'tel' ],
          'tel-local-suffix': [ 'text', 'search', 'tel' ],
          'tel-extension': [ 'text', 'search', 'tel' ],
          'cc-exp-month': number,
          'cc-exp-year': number,
          'transaction-amount': number,
          'bday-day': number,
          'bday-month': number,
          'bday-year': number,
          'new-password': [ 'text', 'search', 'password' ],
          'current-password': [ 'text', 'search', 'password' ],
          url: url,
          photo: url,
          impp: url
        };
        if (_typeof(options) === 'object') {
          Object.keys(options).forEach(function(key) {
            if (!allowedTypesMap[key]) {
              allowedTypesMap[key] = [];
            }
            allowedTypesMap[key] = allowedTypesMap[key].concat(options[key]);
          });
        }
        var autocompleteAttr = virtualNode.attr('autocomplete');
        var autocompleteTerms = autocompleteAttr.split(/\s+/g).map(function(term) {
          return term.toLowerCase();
        });
        var purposeTerm = autocompleteTerms[autocompleteTerms.length - 1];
        if (_commons_text__WEBPACK_IMPORTED_MODULE_0__['autocomplete'].stateTerms.includes(purposeTerm)) {
          return true;
        }
        var allowedTypes = allowedTypesMap[purposeTerm];
        var type = virtualNode.hasAttr('type') ? Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['sanitize'])(virtualNode.attr('type')).toLowerCase() : 'text';
        type = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['validInputTypes'])().includes(type) ? type : 'text';
        if (typeof allowedTypes === 'undefined') {
          return type === 'text';
        }
        return allowedTypes.includes(type);
      }
      __webpack_exports__['default'] = autocompleteAppropriateEvaluate;
    },
    './lib/checks/forms/autocomplete-valid-evaluate.js': function libChecksFormsAutocompleteValidEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      function autocompleteValidEvaluate(node, options, virtualNode) {
        var autocomplete = virtualNode.attr('autocomplete') || '';
        return Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['isValidAutocomplete'])(autocomplete, options);
      }
      __webpack_exports__['default'] = autocompleteValidEvaluate;
    },
    './lib/checks/generic/attr-non-space-content-evaluate.js': function libChecksGenericAttrNonSpaceContentEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      function attrNonSpaceContentEvaluate(node) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var vNode = arguments.length > 2 ? arguments[2] : undefined;
        if (!options.attribute || typeof options.attribute !== 'string') {
          throw new TypeError('attr-non-space-content requires options.attribute to be a string');
        }
        var attribute = vNode.attr(options.attribute) || '';
        return !!Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['sanitize'])(attribute.trim());
      }
      __webpack_exports__['default'] = attrNonSpaceContentEvaluate;
    },
    './lib/checks/generic/has-descendant-after.js': function libChecksGenericHasDescendantAfterJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function pageHasElmAfter(results) {
        var elmUsedAnywhere = results.some(function(frameResult) {
          return frameResult.result === true;
        });
        if (elmUsedAnywhere) {
          results.forEach(function(result) {
            result.result = true;
          });
        }
        return results;
      }
      __webpack_exports__['default'] = pageHasElmAfter;
    },
    './lib/checks/generic/has-descendant-evaluate.js': function libChecksGenericHasDescendantEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      var _commons_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/index.js');
      function hasDescendant(node, options, virtualNode) {
        if (!options || !options.selector || typeof options.selector !== 'string') {
          throw new TypeError('has-descendant requires options.selector to be a string');
        }
        var matchingElms = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['querySelectorAllFilter'])(virtualNode, options.selector, function(vNode) {
          return Object(_commons_dom__WEBPACK_IMPORTED_MODULE_1__['isVisible'])(vNode.actualNode, true);
        });
        this.relatedNodes(matchingElms.map(function(vNode) {
          return vNode.actualNode;
        }));
        return matchingElms.length > 0;
      }
      __webpack_exports__['default'] = hasDescendant;
    },
    './lib/checks/generic/has-text-content-evaluate.js': function libChecksGenericHasTextContentEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      function hasTextContentEvaluate(node, options, virtualNode) {
        try {
          return Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['sanitize'])(Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['subtreeText'])(virtualNode)) !== '';
        } catch (e) {
          return undefined;
        }
      }
      __webpack_exports__['default'] = hasTextContentEvaluate;
    },
    './lib/checks/generic/matches-definition-evaluate.js': function libChecksGenericMatchesDefinitionEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_matches__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/matches/index.js');
      function matchesDefinitionEvaluate(_, options, virtualNode) {
        return Object(_commons_matches__WEBPACK_IMPORTED_MODULE_0__['default'])(virtualNode, options.matcher);
      }
      __webpack_exports__['default'] = matchesDefinitionEvaluate;
    },
    './lib/checks/generic/page-no-duplicate-after.js': function libChecksGenericPageNoDuplicateAfterJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function pageNoDuplicateAfter(results) {
        return results.filter(function(checkResult) {
          return checkResult.data !== 'ignored';
        });
      }
      __webpack_exports__['default'] = pageNoDuplicateAfter;
    },
    './lib/checks/generic/page-no-duplicate-evaluate.js': function libChecksGenericPageNoDuplicateEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_base_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/cache.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      var _commons_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/dom/index.js');
      function pageNoDuplicateEvaluate(node, options, virtualNode) {
        if (!options || !options.selector || typeof options.selector !== 'string') {
          throw new TypeError('page-no-duplicate requires options.selector to be a string');
        }
        var key = 'page-no-duplicate;' + options.selector;
        if (_core_base_cache__WEBPACK_IMPORTED_MODULE_0__['default'].get(key)) {
          this.data('ignored');
          return;
        }
        _core_base_cache__WEBPACK_IMPORTED_MODULE_0__['default'].set(key, true);
        var elms = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['querySelectorAllFilter'])(axe._tree[0], options.selector, function(elm) {
          return Object(_commons_dom__WEBPACK_IMPORTED_MODULE_2__['isVisible'])(elm.actualNode);
        });
        if (typeof options.nativeScopeFilter === 'string') {
          elms = elms.filter(function(elm) {
            return elm.actualNode.hasAttribute('role') || !Object(_commons_dom__WEBPACK_IMPORTED_MODULE_2__['findUpVirtual'])(elm, options.nativeScopeFilter);
          });
        }
        this.relatedNodes(elms.filter(function(elm) {
          return elm !== virtualNode;
        }).map(function(elm) {
          return elm.actualNode;
        }));
        return elms.length <= 1;
      }
      __webpack_exports__['default'] = pageNoDuplicateEvaluate;
    },
    './lib/checks/keyboard/accesskeys-after.js': function libChecksKeyboardAccesskeysAfterJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function accesskeysAfter(results) {
        var seen = {};
        return results.filter(function(r) {
          if (!r.data) {
            return false;
          }
          var key = r.data.toUpperCase();
          if (!seen[key]) {
            seen[key] = r;
            r.relatedNodes = [];
            return true;
          }
          seen[key].relatedNodes.push(r.relatedNodes[0]);
          return false;
        }).map(function(r) {
          r.result = !!r.relatedNodes.length;
          return r;
        });
      }
      __webpack_exports__['default'] = accesskeysAfter;
    },
    './lib/checks/keyboard/accesskeys-evaluate.js': function libChecksKeyboardAccesskeysEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      function accesskeysEvaluate(node) {
        if (Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isVisible'])(node, false)) {
          this.data(node.getAttribute('accesskey'));
          this.relatedNodes([ node ]);
        }
        return true;
      }
      __webpack_exports__['default'] = accesskeysEvaluate;
    },
    './lib/checks/keyboard/focusable-content-evaluate.js': function libChecksKeyboardFocusableContentEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function focusableContentEvaluate(node, options, virtualNode) {
        var tabbableElements = virtualNode.tabbableElements;
        if (!tabbableElements) {
          return false;
        }
        var tabbableContentElements = tabbableElements.filter(function(el) {
          return el !== virtualNode;
        });
        return tabbableContentElements.length > 0;
      }
      __webpack_exports__['default'] = focusableContentEvaluate;
    },
    './lib/checks/keyboard/focusable-disabled-evaluate.js': function libChecksKeyboardFocusableDisabledEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      function focusableDisabledEvaluate(node, options, virtualNode) {
        var elementsThatCanBeDisabled = [ 'BUTTON', 'FIELDSET', 'INPUT', 'SELECT', 'TEXTAREA' ];
        var tabbableElements = virtualNode.tabbableElements;
        if (!tabbableElements || !tabbableElements.length) {
          return true;
        }
        var relatedNodes = tabbableElements.reduce(function(out, _ref3) {
          var el = _ref3.actualNode;
          var nodeName = el.nodeName.toUpperCase();
          if (elementsThatCanBeDisabled.includes(nodeName)) {
            out.push(el);
          }
          return out;
        }, []);
        this.relatedNodes(relatedNodes);
        if (relatedNodes.length && Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isModalOpen'])()) {
          return true;
        }
        return relatedNodes.length === 0;
      }
      __webpack_exports__['default'] = focusableDisabledEvaluate;
    },
    './lib/checks/keyboard/focusable-element-evaluate.js': function libChecksKeyboardFocusableElementEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function focusableElementEvaluate(node, options, virtualNode) {
        if (virtualNode.hasAttr('contenteditable') && isContenteditable(virtualNode)) {
          return true;
        }
        var isFocusable = virtualNode.isFocusable;
        var tabIndex = parseInt(virtualNode.attr('tabindex'), 10);
        tabIndex = !isNaN(tabIndex) ? tabIndex : null;
        return tabIndex ? isFocusable && tabIndex >= 0 : isFocusable;
        function isContenteditable(vNode) {
          var contenteditable = vNode.attr('contenteditable');
          if (contenteditable === 'true' || contenteditable === '') {
            return true;
          }
          if (contenteditable === 'false') {
            return false;
          }
          var ancestor = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['closest'])(virtualNode.parent, '[contenteditable]');
          if (!ancestor) {
            return false;
          }
          return isContenteditable(ancestor);
        }
      }
      __webpack_exports__['default'] = focusableElementEvaluate;
    },
    './lib/checks/keyboard/focusable-modal-open-evaluate.js': function libChecksKeyboardFocusableModalOpenEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      function focusableModalOpenEvaluate(node, options, virtualNode) {
        var tabbableElements = virtualNode.tabbableElements.map(function(_ref4) {
          var actualNode = _ref4.actualNode;
          return actualNode;
        });
        if (!tabbableElements || !tabbableElements.length) {
          return true;
        }
        if (Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isModalOpen'])()) {
          this.relatedNodes(tabbableElements);
          return undefined;
        }
        return true;
      }
      __webpack_exports__['default'] = focusableModalOpenEvaluate;
    },
    './lib/checks/keyboard/focusable-no-name-evaluate.js': function libChecksKeyboardFocusableNoNameEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/index.js');
      function focusableNoNameEvaluate(node, options, virtualNode) {
        var tabIndex = virtualNode.attr('tabindex');
        var inFocusOrder = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isFocusable'])(virtualNode) && tabIndex > -1;
        if (!inFocusOrder) {
          return false;
        }
        try {
          return !Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['accessibleTextVirtual'])(virtualNode);
        } catch (e) {
          return undefined;
        }
      }
      __webpack_exports__['default'] = focusableNoNameEvaluate;
    },
    './lib/checks/keyboard/focusable-not-tabbable-evaluate.js': function libChecksKeyboardFocusableNotTabbableEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      function focusableNotTabbableEvaluate(node, options, virtualNode) {
        var elementsThatCanBeDisabled = [ 'BUTTON', 'FIELDSET', 'INPUT', 'SELECT', 'TEXTAREA' ];
        var tabbableElements = virtualNode.tabbableElements;
        if (!tabbableElements || !tabbableElements.length) {
          return true;
        }
        var relatedNodes = tabbableElements.reduce(function(out, _ref5) {
          var el = _ref5.actualNode;
          var nodeName = el.nodeName.toUpperCase();
          if (!elementsThatCanBeDisabled.includes(nodeName)) {
            out.push(el);
          }
          return out;
        }, []);
        this.relatedNodes(relatedNodes);
        if (relatedNodes.length > 0 && Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isModalOpen'])()) {
          return true;
        }
        return relatedNodes.length === 0;
      }
      __webpack_exports__['default'] = focusableNotTabbableEvaluate;
    },
    './lib/checks/keyboard/landmark-is-top-level-evaluate.js': function libChecksKeyboardLandmarkIsTopLevelEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      var _commons_standards__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/standards/index.js');
      var _commons_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/dom/index.js');
      function landmarkIsTopLevelEvaluate(node) {
        var landmarks = Object(_commons_standards__WEBPACK_IMPORTED_MODULE_1__['getAriaRolesByType'])('landmark');
        var parent = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_2__['getComposedParent'])(node);
        this.data({
          role: node.getAttribute('role') || Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['implicitRole'])(node)
        });
        while (parent) {
          var role = parent.getAttribute('role');
          if (!role && parent.nodeName.toUpperCase() !== 'FORM') {
            role = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['implicitRole'])(parent);
          }
          if (role && landmarks.includes(role)) {
            return false;
          }
          parent = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_2__['getComposedParent'])(parent);
        }
        return true;
      }
      __webpack_exports__['default'] = landmarkIsTopLevelEvaluate;
    },
    './lib/checks/keyboard/tabindex-evaluate.js': function libChecksKeyboardTabindexEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function tabindexEvaluate(node, options, virtualNode) {
        var tabIndex = parseInt(virtualNode.attr('tabindex'), 10);
        return isNaN(tabIndex) ? true : tabIndex <= 0;
      }
      __webpack_exports__['default'] = tabindexEvaluate;
    },
    './lib/checks/label/alt-space-value-evaluate.js': function libChecksLabelAltSpaceValueEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function altSpaceValueEvaluate(node, options, virtualNode) {
        var alt = virtualNode.attr('alt');
        var isOnlySpace = /^\s+$/;
        return typeof alt === 'string' && isOnlySpace.test(alt);
      }
      __webpack_exports__['default'] = altSpaceValueEvaluate;
    },
    './lib/checks/label/duplicate-img-label-evaluate.js': function libChecksLabelDuplicateImgLabelEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      var _commons_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function duplicateImgLabelEvaluate(node, options, virtualNode) {
        if ([ 'none', 'presentation' ].includes(Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['getRole'])(virtualNode))) {
          return false;
        }
        var parentVNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['closest'])(virtualNode, options.parentSelector);
        if (!parentVNode) {
          return false;
        }
        var visibleText = Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['visibleVirtual'])(parentVNode, true).toLowerCase();
        if (visibleText === '') {
          return false;
        }
        return visibleText === Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['accessibleTextVirtual'])(virtualNode).toLowerCase();
      }
      __webpack_exports__['default'] = duplicateImgLabelEvaluate;
    },
    './lib/checks/label/explicit-evaluate.js': function libChecksLabelExplicitEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function explicitEvaluate(node, options, virtualNode) {
        try {
          if (virtualNode.attr('id')) {
            var root = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getRootNode'])(virtualNode.actualNode);
            var id = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['escapeSelector'])(virtualNode.attr('id'));
            var label = root.querySelector('label[for="'.concat(id, '"]'));
            if (label) {
              if (!Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isVisible'])(label)) {
                return true;
              } else {
                return !!Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['accessibleText'])(label);
              }
            }
          }
          return false;
        } catch (e) {
          return undefined;
        }
      }
      __webpack_exports__['default'] = explicitEvaluate;
    },
    './lib/checks/label/help-same-as-label-evaluate.js': function libChecksLabelHelpSameAsLabelEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      var _commons_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/index.js');
      function helpSameAsLabelEvaluate(node, options, virtualNode) {
        var labelText = Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['labelVirtual'])(virtualNode), check = node.getAttribute('title');
        if (!labelText) {
          return false;
        }
        if (!check) {
          check = '';
          if (node.getAttribute('aria-describedby')) {
            var ref = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_1__['idrefs'])(node, 'aria-describedby');
            check = ref.map(function(thing) {
              return thing ? Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['accessibleText'])(thing) : '';
            }).join('');
          }
        }
        return Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['sanitize'])(check) === Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['sanitize'])(labelText);
      }
      __webpack_exports__['default'] = helpSameAsLabelEvaluate;
    },
    './lib/checks/label/hidden-explicit-label-evaluate.js': function libChecksLabelHiddenExplicitLabelEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function hiddenExplicitLabelEvaluate(node, options, virtualNode) {
        try {
          if (virtualNode.hasAttr('id')) {
            var root = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getRootNode'])(node);
            var id = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['escapeSelector'])(node.getAttribute('id'));
            var label = root.querySelector('label[for="'.concat(id, '"]'));
            if (label && !Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isVisible'])(label, true)) {
              var name = Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['accessibleTextVirtual'])(virtualNode).trim();
              var isNameEmpty = name === '';
              return isNameEmpty;
            }
          }
          return false;
        } catch (e) {
          return undefined;
        }
      }
      __webpack_exports__['default'] = hiddenExplicitLabelEvaluate;
    },
    './lib/checks/label/implicit-evaluate.js': function libChecksLabelImplicitEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      var _commons_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/index.js');
      function implicitEvaluate(node, options, virtualNode) {
        try {
          var label = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['closest'])(virtualNode, 'label');
          if (label) {
            return !!Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['accessibleTextVirtual'])(label, {
              inControlContext: true
            });
          }
          return false;
        } catch (e) {
          return undefined;
        }
      }
      __webpack_exports__['default'] = implicitEvaluate;
    },
    './lib/checks/label/label-content-name-mismatch-evaluate.js': function libChecksLabelLabelContentNameMismatchEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      function isStringContained(compare, compareWith) {
        var curatedCompareWith = curateString(compareWith);
        var curatedCompare = curateString(compare);
        if (!curatedCompareWith || !curatedCompare) {
          return false;
        }
        return curatedCompareWith.includes(curatedCompare);
      }
      function curateString(str) {
        var noUnicodeStr = Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['removeUnicode'])(str, {
          emoji: true,
          nonBmp: true,
          punctuations: true
        });
        return Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['sanitize'])(noUnicodeStr);
      }
      function labelContentNameMismatchEvaluate(node, options, virtualNode) {
        var _ref6 = options || {}, pixelThreshold = _ref6.pixelThreshold, occuranceThreshold = _ref6.occuranceThreshold;
        var accText = Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['accessibleText'])(node).toLowerCase();
        if (Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['isHumanInterpretable'])(accText) < 1) {
          return undefined;
        }
        var textVNodes = Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['visibleTextNodes'])(virtualNode);
        var nonLigatureText = textVNodes.filter(function(textVNode) {
          return !Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['isIconLigature'])(textVNode, pixelThreshold, occuranceThreshold);
        }).map(function(textVNode) {
          return textVNode.actualNode.nodeValue;
        }).join('');
        var visibleText = Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['sanitize'])(nonLigatureText).toLowerCase();
        if (!visibleText) {
          return true;
        }
        if (Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['isHumanInterpretable'])(visibleText) < 1) {
          if (isStringContained(visibleText, accText)) {
            return true;
          }
          return undefined;
        }
        return isStringContained(visibleText, accText);
      }
      __webpack_exports__['default'] = labelContentNameMismatchEvaluate;
    },
    './lib/checks/label/multiple-label-evaluate.js': function libChecksLabelMultipleLabelEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function multipleLabelEvaluate(node) {
        var id = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['escapeSelector'])(node.getAttribute('id'));
        var parent = node.parentNode;
        var root = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getRootNode'])(node);
        root = root.documentElement || root;
        var labels = Array.from(root.querySelectorAll('label[for="'.concat(id, '"]')));
        if (labels.length) {
          labels = labels.filter(function(label) {
            return Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isVisible'])(label);
          });
        }
        while (parent) {
          if (parent.nodeName.toUpperCase() === 'LABEL' && labels.indexOf(parent) === -1) {
            labels.push(parent);
          }
          parent = parent.parentNode;
        }
        this.relatedNodes(labels);
        if (labels.length > 1) {
          var ATVisibleLabels = labels.filter(function(label) {
            return Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isVisible'])(label, true);
          });
          if (ATVisibleLabels.length > 1) {
            return undefined;
          }
          var labelledby = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['idrefs'])(node, 'aria-labelledby');
          return !labelledby.includes(ATVisibleLabels[0]) ? undefined : false;
        }
        return false;
      }
      __webpack_exports__['default'] = multipleLabelEvaluate;
    },
    './lib/checks/label/title-only-evaluate.js': function libChecksLabelTitleOnlyEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      function titleOnlyEvaluate(node, options, virtualNode) {
        var labelText = Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['labelVirtual'])(virtualNode);
        var title = Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['titleText'])(virtualNode);
        var ariaDescribedBy = virtualNode.attr('aria-describedby');
        return !labelText && !!(title || ariaDescribedBy);
      }
      __webpack_exports__['default'] = titleOnlyEvaluate;
    },
    './lib/checks/landmarks/landmark-is-unique-after.js': function libChecksLandmarksLandmarkIsUniqueAfterJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function landmarkIsUniqueAfter(results) {
        var uniqueLandmarks = [];
        return results.filter(function(currentResult) {
          var findMatch = function findMatch(someResult) {
            return currentResult.data.role === someResult.data.role && currentResult.data.accessibleText === someResult.data.accessibleText;
          };
          var matchedResult = uniqueLandmarks.find(findMatch);
          if (matchedResult) {
            matchedResult.result = false;
            matchedResult.relatedNodes.push(currentResult.relatedNodes[0]);
            return false;
          }
          uniqueLandmarks.push(currentResult);
          currentResult.relatedNodes = [];
          return true;
        });
      }
      __webpack_exports__['default'] = landmarkIsUniqueAfter;
    },
    './lib/checks/landmarks/landmark-is-unique-evaluate.js': function libChecksLandmarksLandmarkIsUniqueEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      var _commons_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/index.js');
      function landmarkIsUniqueEvaluate(node, options, virtualNode) {
        var role = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['getRole'])(node);
        var accessibleText = Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['accessibleTextVirtual'])(virtualNode);
        accessibleText = accessibleText ? accessibleText.toLowerCase() : null;
        this.data({
          role: role,
          accessibleText: accessibleText
        });
        this.relatedNodes([ node ]);
        return true;
      }
      __webpack_exports__['default'] = landmarkIsUniqueEvaluate;
    },
    './lib/checks/language/has-lang-evaluate.js': function libChecksLanguageHasLangEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function hasValue(value) {
        return (value || '').trim() !== '';
      }
      function hasLangEvaluate(node, options, virtualNode) {
        if (options.attributes.includes('xml:lang') && options.attributes.includes('lang') && hasValue(virtualNode.attr('xml:lang')) && !hasValue(virtualNode.attr('lang')) && !Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['isXHTML'])(document)) {
          this.data({
            messageKey: 'noXHTML'
          });
          return false;
        }
        var hasLang = options.attributes.some(function(name) {
          return hasValue(virtualNode.attr(name));
        });
        if (!hasLang) {
          this.data({
            messageKey: 'noLang'
          });
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = hasLangEvaluate;
    },
    './lib/checks/language/valid-lang-evaluate.js': function libChecksLanguageValidLangEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      var _commons_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/index.js');
      function validLangEvaluate(node, options, virtualNode) {
        var langs = (options.value ? options.value : Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['validLangs'])()).map(_core_utils__WEBPACK_IMPORTED_MODULE_0__['getBaseLang']);
        var invalid = [];
        options.attributes.forEach(function(langAttr) {
          var langVal = virtualNode.attr(langAttr);
          if (typeof langVal !== 'string') {
            return;
          }
          var baselangVal = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['getBaseLang'])(langVal);
          if (baselangVal !== '' && langs.indexOf(baselangVal) === -1 || langVal !== '' && !Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['sanitize'])(langVal)) {
            invalid.push(langAttr + '="' + virtualNode.attr(langAttr) + '"');
          }
        });
        if (invalid.length) {
          this.data(invalid);
          return true;
        }
        return false;
      }
      __webpack_exports__['default'] = validLangEvaluate;
    },
    './lib/checks/language/xml-lang-mismatch-evaluate.js': function libChecksLanguageXmlLangMismatchEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function xmlLangMismatchEvaluate(node, options, vNode) {
        var primaryLangValue = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['getBaseLang'])(vNode.attr('lang'));
        var primaryXmlLangValue = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['getBaseLang'])(vNode.attr('xml:lang'));
        return primaryLangValue === primaryXmlLangValue;
      }
      __webpack_exports__['default'] = xmlLangMismatchEvaluate;
    },
    './lib/checks/lists/dlitem-evaluate.js': function libChecksListsDlitemEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/index.js');
      function dlitemEvaluate(node) {
        var parent = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getComposedParent'])(node);
        var parentTagName = parent.nodeName.toUpperCase();
        var parentRole = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['getExplicitRole'])(parent);
        if (parentTagName === 'DIV' && [ 'presentation', 'none', null ].includes(parentRole)) {
          parent = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getComposedParent'])(parent);
          parentTagName = parent.nodeName.toUpperCase();
          parentRole = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['getExplicitRole'])(parent);
        }
        if (parentTagName !== 'DL') {
          return false;
        }
        if (!parentRole || [ 'presentation', 'none', 'list' ].includes(parentRole)) {
          return true;
        }
        return false;
      }
      __webpack_exports__['default'] = dlitemEvaluate;
    },
    './lib/checks/lists/listitem-evaluate.js': function libChecksListsListitemEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/index.js');
      function listitemEvaluate(node) {
        var parent = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getComposedParent'])(node);
        if (!parent) {
          return undefined;
        }
        var parentTagName = parent.nodeName.toUpperCase();
        var parentRole = (parent.getAttribute('role') || '').toLowerCase();
        if ([ 'presentation', 'none', 'list' ].includes(parentRole)) {
          return true;
        }
        if (parentRole && Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['isValidRole'])(parentRole)) {
          this.data({
            messageKey: 'roleNotValid'
          });
          return false;
        }
        return [ 'UL', 'OL' ].includes(parentTagName);
      }
      __webpack_exports__['default'] = listitemEvaluate;
    },
    './lib/checks/lists/only-dlitems-evaluate.js': function libChecksListsOnlyDlitemsEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/index.js');
      function onlyDlitemsEvaluate(node, options, virtualNode) {
        var ALLOWED_ROLES = [ 'definition', 'term', 'list' ];
        var base = {
          badNodes: [],
          hasNonEmptyTextNode: false
        };
        var content = virtualNode.children.reduce(function(content, child) {
          var actualNode = child.actualNode;
          if (actualNode.nodeName.toUpperCase() === 'DIV' && Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['getRole'])(actualNode) === null) {
            return content.concat(child.children);
          }
          return content.concat(child);
        }, []);
        var result = content.reduce(function(out, childNode) {
          var actualNode = childNode.actualNode;
          var tagName = actualNode.nodeName.toUpperCase();
          if (actualNode.nodeType === 1 && Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isVisible'])(actualNode, true, false)) {
            var explicitRole = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['getExplicitRole'])(actualNode);
            if (tagName !== 'DT' && tagName !== 'DD' || explicitRole) {
              if (!ALLOWED_ROLES.includes(explicitRole)) {
                out.badNodes.push(actualNode);
              }
            }
          } else if (actualNode.nodeType === 3 && actualNode.nodeValue.trim() !== '') {
            out.hasNonEmptyTextNode = true;
          }
          return out;
        }, base);
        if (result.badNodes.length) {
          this.relatedNodes(result.badNodes);
        }
        return !!result.badNodes.length || result.hasNonEmptyTextNode;
      }
      __webpack_exports__['default'] = onlyDlitemsEvaluate;
    },
    './lib/checks/lists/only-listitems-evaluate.js': function libChecksListsOnlyListitemsEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/index.js');
      function onlyListitemsEvaluate(node, options, virtualNode) {
        var hasNonEmptyTextNode = false;
        var atLeastOneListitem = false;
        var isEmpty = true;
        var badNodes = [];
        var badRoleNodes = [];
        var badRoles = [];
        virtualNode.children.forEach(function(vNode) {
          var actualNode = vNode.actualNode;
          if (actualNode.nodeType === 3 && actualNode.nodeValue.trim() !== '') {
            hasNonEmptyTextNode = true;
            return;
          }
          if (actualNode.nodeType !== 1 || !Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isVisible'])(actualNode, true, false)) {
            return;
          }
          isEmpty = false;
          var isLi = actualNode.nodeName.toUpperCase() === 'LI';
          var role = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['getRole'])(vNode);
          var isListItemRole = role === 'listitem';
          if (!isLi && !isListItemRole) {
            badNodes.push(actualNode);
          }
          if (isLi && !isListItemRole) {
            badRoleNodes.push(actualNode);
            if (!badRoles.includes(role)) {
              badRoles.push(role);
            }
          }
          if (isListItemRole) {
            atLeastOneListitem = true;
          }
        });
        if (hasNonEmptyTextNode || badNodes.length) {
          this.relatedNodes(badNodes);
          return true;
        }
        if (isEmpty || atLeastOneListitem) {
          return false;
        }
        this.relatedNodes(badRoleNodes);
        this.data({
          messageKey: 'roleNotValid',
          roles: badRoles.join(', ')
        });
        return true;
      }
      __webpack_exports__['default'] = onlyListitemsEvaluate;
    },
    './lib/checks/lists/structured-dlitems-evaluate.js': function libChecksListsStructuredDlitemsEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function structuredDlitemsEvaluate(node, options, virtualNode) {
        var children = virtualNode.children;
        if (!children || !children.length) {
          return false;
        }
        var hasDt = false, hasDd = false, nodeName;
        for (var i = 0; i < children.length; i++) {
          nodeName = children[i].props.nodeName.toUpperCase();
          if (nodeName === 'DT') {
            hasDt = true;
          }
          if (hasDt && nodeName === 'DD') {
            return false;
          }
          if (nodeName === 'DD') {
            hasDd = true;
          }
        }
        return hasDt || hasDd;
      }
      __webpack_exports__['default'] = structuredDlitemsEvaluate;
    },
    './lib/checks/media/caption-evaluate.js': function libChecksMediaCaptionEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function captionEvaluate(node, options, virtualNode) {
        var tracks = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['querySelectorAll'])(virtualNode, 'track');
        var hasCaptions = tracks.some(function(vNode) {
          return (vNode.attr('kind') || '').toLowerCase() === 'captions';
        });
        return hasCaptions ? false : undefined;
      }
      __webpack_exports__['default'] = captionEvaluate;
    },
    './lib/checks/media/frame-tested-evaluate.js': function libChecksMediaFrameTestedEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function frameTestedEvaluate(node, options) {
        var resolve = this.async();
        var _Object$assign = Object.assign({
          isViolation: false,
          timeout: 500
        }, options), isViolation = _Object$assign.isViolation, timeout = _Object$assign.timeout;
        var timer = setTimeout(function() {
          timer = setTimeout(function() {
            timer = null;
            resolve(isViolation ? false : undefined);
          }, 0);
        }, timeout);
        Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['respondable'])(node.contentWindow, 'axe.ping', null, undefined, function() {
          if (timer !== null) {
            clearTimeout(timer);
            resolve(true);
          }
        });
      }
      __webpack_exports__['default'] = frameTestedEvaluate;
    },
    './lib/checks/media/no-autoplay-audio-evaluate.js': function libChecksMediaNoAutoplayAudioEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function noAutoplayAudioEvaluate(node, options) {
        if (!node.duration) {
          console.warn('axe.utils.preloadMedia did not load metadata');
          return undefined;
        }
        var _options$allowedDurat = options.allowedDuration, allowedDuration = _options$allowedDurat === void 0 ? 3 : _options$allowedDurat;
        var playableDuration = getPlayableDuration(node);
        if (playableDuration <= allowedDuration && !node.hasAttribute('loop')) {
          return true;
        }
        if (!node.hasAttribute('controls')) {
          return false;
        }
        return true;
        function getPlayableDuration(elm) {
          if (!elm.currentSrc) {
            return 0;
          }
          var playbackRange = getPlaybackRange(elm.currentSrc);
          if (!playbackRange) {
            return Math.abs(elm.duration - (elm.currentTime || 0));
          }
          if (playbackRange.length === 1) {
            return Math.abs(elm.duration - playbackRange[0]);
          }
          return Math.abs(playbackRange[1] - playbackRange[0]);
        }
        function getPlaybackRange(src) {
          var match = src.match(/#t=(.*)/);
          if (!match) {
            return;
          }
          var _match = _slicedToArray(match, 2), value = _match[1];
          var ranges = value.split(',');
          return ranges.map(function(range) {
            if (/:/.test(range)) {
              return convertHourMinSecToSeconds(range);
            }
            return parseFloat(range);
          });
        }
        function convertHourMinSecToSeconds(hhMmSs) {
          var parts = hhMmSs.split(':');
          var secs = 0;
          var mins = 1;
          while (parts.length > 0) {
            secs += mins * parseInt(parts.pop(), 10);
            mins *= 60;
          }
          return parseFloat(secs);
        }
      }
      __webpack_exports__['default'] = noAutoplayAudioEvaluate;
    },
    './lib/checks/mobile/css-orientation-lock-evaluate.js': function libChecksMobileCssOrientationLockEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function cssOrientationLockEvaluate(node, options, virtualNode, context) {
        var _ref7 = context || {}, _ref7$cssom = _ref7.cssom, cssom = _ref7$cssom === void 0 ? undefined : _ref7$cssom;
        var _ref8 = options || {}, _ref8$degreeThreshold = _ref8.degreeThreshold, degreeThreshold = _ref8$degreeThreshold === void 0 ? 0 : _ref8$degreeThreshold;
        if (!cssom || !cssom.length) {
          return undefined;
        }
        var isLocked = false;
        var relatedElements = [];
        var rulesGroupByDocumentFragment = groupCssomByDocument(cssom);
        var _loop = function _loop() {
          var key = _Object$keys[_i2];
          var _rulesGroupByDocument = rulesGroupByDocumentFragment[key], root = _rulesGroupByDocument.root, rules = _rulesGroupByDocument.rules;
          var orientationRules = rules.filter(isMediaRuleWithOrientation);
          if (!orientationRules.length) {
            return 'continue';
          }
          orientationRules.forEach(function(_ref9) {
            var cssRules = _ref9.cssRules;
            Array.from(cssRules).forEach(function(cssRule) {
              var locked = getIsOrientationLocked(cssRule);
              if (locked && cssRule.selectorText.toUpperCase() !== 'HTML') {
                var elms = Array.from(root.querySelectorAll(cssRule.selectorText)) || [];
                relatedElements = relatedElements.concat(elms);
              }
              isLocked = isLocked || locked;
            });
          });
        };
        for (var _i2 = 0, _Object$keys = Object.keys(rulesGroupByDocumentFragment); _i2 < _Object$keys.length; _i2++) {
          var _ret = _loop();
          if (_ret === 'continue') {
            continue;
          }
        }
        if (!isLocked) {
          return true;
        }
        if (relatedElements.length) {
          this.relatedNodes(relatedElements);
        }
        return false;
        function groupCssomByDocument(cssObjectModel) {
          return cssObjectModel.reduce(function(out, _ref10) {
            var sheet = _ref10.sheet, root = _ref10.root, shadowId = _ref10.shadowId;
            var key = shadowId ? shadowId : 'topDocument';
            if (!out[key]) {
              out[key] = {
                root: root,
                rules: []
              };
            }
            if (!sheet || !sheet.cssRules) {
              return out;
            }
            var rules = Array.from(sheet.cssRules);
            out[key].rules = out[key].rules.concat(rules);
            return out;
          }, {});
        }
        function isMediaRuleWithOrientation(_ref11) {
          var type = _ref11.type, cssText = _ref11.cssText;
          if (type !== 4) {
            return false;
          }
          return /orientation:\s*landscape/i.test(cssText) || /orientation:\s*portrait/i.test(cssText);
        }
        function getIsOrientationLocked(_ref12) {
          var selectorText = _ref12.selectorText, style = _ref12.style;
          if (!selectorText || style.length <= 0) {
            return false;
          }
          var transformStyle = style.transform || style.webkitTransform || style.msTransform || false;
          if (!transformStyle) {
            return false;
          }
          var matches = transformStyle.match(/(rotate|rotateZ|rotate3d|matrix|matrix3d)\(([^)]+)\)(?!.*(rotate|rotateZ|rotate3d|matrix|matrix3d))/);
          if (!matches) {
            return false;
          }
          var _matches = _slicedToArray(matches, 3), transformFn = _matches[1], transformFnValue = _matches[2];
          var degrees = getRotationInDegrees(transformFn, transformFnValue);
          if (!degrees) {
            return false;
          }
          degrees = Math.abs(degrees);
          if (Math.abs(degrees - 180) % 180 <= degreeThreshold) {
            return false;
          }
          return Math.abs(degrees - 90) % 90 <= degreeThreshold;
        }
        function getRotationInDegrees(transformFunction, transformFnValue) {
          switch (transformFunction) {
           case 'rotate':
           case 'rotateZ':
            return getAngleInDegrees(transformFnValue);

           case 'rotate3d':
            var _transformFnValue$spl = transformFnValue.split(',').map(function(value) {
              return value.trim();
            }), _transformFnValue$spl2 = _slicedToArray(_transformFnValue$spl, 4), z = _transformFnValue$spl2[2], angleWithUnit = _transformFnValue$spl2[3];
            if (parseInt(z) === 0) {
              return;
            }
            return getAngleInDegrees(angleWithUnit);

           case 'matrix':
           case 'matrix3d':
            return getAngleInDegreesFromMatrixTransform(transformFnValue);

           default:
            return;
          }
        }
        function getAngleInDegrees(angleWithUnit) {
          var _ref13 = angleWithUnit.match(/(deg|grad|rad|turn)/) || [], _ref14 = _slicedToArray(_ref13, 1), unit = _ref14[0];
          if (!unit) {
            return;
          }
          var angle = parseFloat(angleWithUnit.replace(unit, ''));
          switch (unit) {
           case 'rad':
            return convertRadToDeg(angle);

           case 'grad':
            return convertGradToDeg(angle);

           case 'turn':
            return convertTurnToDeg(angle);

           case 'deg':
           default:
            return parseInt(angle);
          }
        }
        function getAngleInDegreesFromMatrixTransform(transformFnValue) {
          var values = transformFnValue.split(',');
          if (values.length <= 6) {
            var _values = _slicedToArray(values, 2), a = _values[0], _b = _values[1];
            var radians = Math.atan2(parseFloat(_b), parseFloat(a));
            return convertRadToDeg(radians);
          }
          var sinB = parseFloat(values[8]);
          var b = Math.asin(sinB);
          var cosB = Math.cos(b);
          var rotateZRadians = Math.acos(parseFloat(values[0]) / cosB);
          return convertRadToDeg(rotateZRadians);
        }
        function convertRadToDeg(radians) {
          return Math.round(radians * (180 / Math.PI));
        }
        function convertGradToDeg(grad) {
          grad = grad % 400;
          if (grad < 0) {
            grad += 400;
          }
          return Math.round(grad / 400 * 360);
        }
        function convertTurnToDeg(turn) {
          return Math.round(360 / (1 / turn));
        }
      }
      __webpack_exports__['default'] = cssOrientationLockEvaluate;
    },
    './lib/checks/mobile/meta-viewport-scale-evaluate.js': function libChecksMobileMetaViewportScaleEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function metaViewportScaleEvaluate(node, options) {
        var _ref15 = options || {}, _ref15$scaleMinimum = _ref15.scaleMinimum, scaleMinimum = _ref15$scaleMinimum === void 0 ? 2 : _ref15$scaleMinimum, _ref15$lowerBound = _ref15.lowerBound, lowerBound = _ref15$lowerBound === void 0 ? false : _ref15$lowerBound;
        var content = node.getAttribute('content') || '';
        if (!content) {
          return true;
        }
        var result = content.split(/[;,]/).reduce(function(out, item) {
          var contentValue = item.trim();
          if (!contentValue) {
            return out;
          }
          var _contentValue$split = contentValue.split('='), _contentValue$split2 = _slicedToArray(_contentValue$split, 2), key = _contentValue$split2[0], value = _contentValue$split2[1];
          if (!key || !value) {
            return out;
          }
          var curatedKey = key.toLowerCase().trim();
          var curatedValue = value.toLowerCase().trim();
          if (curatedKey === 'maximum-scale' && curatedValue === 'yes') {
            curatedValue = 1;
          }
          if (curatedKey === 'maximum-scale' && parseFloat(curatedValue) < 0) {
            return out;
          }
          out[curatedKey] = curatedValue;
          return out;
        }, {});
        if (lowerBound && result['maximum-scale'] && parseFloat(result['maximum-scale']) < lowerBound) {
          return true;
        }
        if (!lowerBound && result['user-scalable'] === 'no') {
          this.data('user-scalable=no');
          return false;
        }
        if (result['maximum-scale'] && parseFloat(result['maximum-scale']) < scaleMinimum) {
          this.data('maximum-scale');
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = metaViewportScaleEvaluate;
    },
    './lib/checks/navigation/heading-order-after.js': function libChecksNavigationHeadingOrderAfterJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function headingOrderAfter(results) {
        if (results.length < 2) {
          return results;
        }
        var prevLevel = results[0].data;
        for (var i = 1; i < results.length; i++) {
          if (results[i].result && results[i].data > prevLevel + 1) {
            results[i].result = false;
          }
          prevLevel = results[i].data;
        }
        return results;
      }
      __webpack_exports__['default'] = headingOrderAfter;
    },
    './lib/checks/navigation/heading-order-evaluate.js': function libChecksNavigationHeadingOrderEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function headingOrderEvaluate(node, options, virtualNode) {
        var ariaHeadingLevel = virtualNode.attr('aria-level');
        var nodeName = virtualNode.props.nodeName;
        if (ariaHeadingLevel !== null) {
          this.data(parseInt(ariaHeadingLevel, 10));
          return true;
        }
        var headingLevel = nodeName.toUpperCase().match(/H(\d)/);
        if (headingLevel) {
          this.data(parseInt(headingLevel[1], 10));
          return true;
        }
        return true;
      }
      __webpack_exports__['default'] = headingOrderEvaluate;
    },
    './lib/checks/navigation/identical-links-same-purpose-after.js': function libChecksNavigationIdenticalLinksSamePurposeAfterJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function isIdenticalObject(a, b) {
        if (!a || !b) {
          return false;
        }
        var aProps = Object.getOwnPropertyNames(a);
        var bProps = Object.getOwnPropertyNames(b);
        if (aProps.length !== bProps.length) {
          return false;
        }
        var result = aProps.every(function(propName) {
          var aValue = a[propName];
          var bValue = b[propName];
          if (_typeof(aValue) !== _typeof(bValue)) {
            return false;
          }
          if (typeof aValue === 'object' || typeof bValue === 'object') {
            return isIdenticalObject(aValue, bValue);
          }
          return aValue === bValue;
        });
        return result;
      }
      function identicalLinksSamePurposeAfter(results) {
        if (results.length < 2) {
          return results;
        }
        var incompleteResults = results.filter(function(_ref16) {
          var result = _ref16.result;
          return result !== undefined;
        });
        var uniqueResults = [];
        var nameMap = {};
        var _loop2 = function _loop2(index) {
          var _currentResult$relate;
          var currentResult = incompleteResults[index];
          var _currentResult$data = currentResult.data, name = _currentResult$data.name, urlProps = _currentResult$data.urlProps;
          if (nameMap[name]) {
            return 'continue';
          }
          var sameNameResults = incompleteResults.filter(function(_ref17, resultNum) {
            var data = _ref17.data;
            return data.name === name && resultNum !== index;
          });
          var isSameUrl = sameNameResults.every(function(_ref18) {
            var data = _ref18.data;
            return isIdenticalObject(data.urlProps, urlProps);
          });
          if (sameNameResults.length && !isSameUrl) {
            currentResult.result = undefined;
          }
          currentResult.relatedNodes = [];
          (_currentResult$relate = currentResult.relatedNodes).push.apply(_currentResult$relate, _toConsumableArray(sameNameResults.map(function(node) {
            return node.relatedNodes[0];
          })));
          nameMap[name] = sameNameResults;
          uniqueResults.push(currentResult);
        };
        for (var index = 0; index < incompleteResults.length; index++) {
          var _ret2 = _loop2(index);
          if (_ret2 === 'continue') {
            continue;
          }
        }
        return uniqueResults;
      }
      __webpack_exports__['default'] = identicalLinksSamePurposeAfter;
    },
    './lib/checks/navigation/identical-links-same-purpose-evaluate.js': function libChecksNavigationIdenticalLinksSamePurposeEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/index.js');
      function identicalLinksSamePurposeEvaluate(node, options, virtualNode) {
        var accText = _commons__WEBPACK_IMPORTED_MODULE_0__['text'].accessibleTextVirtual(virtualNode);
        var name = _commons__WEBPACK_IMPORTED_MODULE_0__['text'].sanitize(_commons__WEBPACK_IMPORTED_MODULE_0__['text'].removeUnicode(accText, {
          emoji: true,
          nonBmp: true,
          punctuations: true
        })).toLowerCase();
        if (!name) {
          return undefined;
        }
        var afterData = {
          name: name,
          urlProps: _commons__WEBPACK_IMPORTED_MODULE_0__['dom'].urlPropsFromAttribute(node, 'href')
        };
        this.data(afterData);
        this.relatedNodes([ node ]);
        return true;
      }
      __webpack_exports__['default'] = identicalLinksSamePurposeEvaluate;
    },
    './lib/checks/navigation/internal-link-present-evaluate.js': function libChecksNavigationInternalLinkPresentEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function internalLinkPresentEvaluate(node, options, virtualNode) {
        var links = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['querySelectorAll'])(virtualNode, 'a[href]');
        return links.some(function(vLink) {
          return /^#[^/!]/.test(vLink.actualNode.getAttribute('href'));
        });
      }
      __webpack_exports__['default'] = internalLinkPresentEvaluate;
    },
    './lib/checks/navigation/meta-refresh-evaluate.js': function libChecksNavigationMetaRefreshEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function metaRefreshEvaluate(node, options, virtualNode) {
        var content = virtualNode.attr('content') || '', parsedParams = content.split(/[;,]/);
        return content === '' || parsedParams[0] === '0';
      }
      __webpack_exports__['default'] = metaRefreshEvaluate;
    },
    './lib/checks/navigation/p-as-heading-evaluate.js': function libChecksNavigationPAsHeadingEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      function normalizeFontWeight(weight) {
        switch (weight) {
         case 'lighter':
          return 100;

         case 'normal':
          return 400;

         case 'bold':
          return 700;

         case 'bolder':
          return 900;
        }
        weight = parseInt(weight);
        return !isNaN(weight) ? weight : 400;
      }
      function getTextContainer(elm) {
        var nextNode = elm;
        var outerText = elm.textContent.trim();
        var innerText = outerText;
        while (innerText === outerText && nextNode !== undefined) {
          var i = -1;
          elm = nextNode;
          if (elm.children.length === 0) {
            return elm;
          }
          do {
            i++;
            innerText = elm.children[i].textContent.trim();
          } while (innerText === '' && i + 1 < elm.children.length);
          nextNode = elm.children[i];
        }
        return elm;
      }
      function getStyleValues(node) {
        var style = window.getComputedStyle(getTextContainer(node));
        return {
          fontWeight: normalizeFontWeight(style.getPropertyValue('font-weight')),
          fontSize: parseInt(style.getPropertyValue('font-size')),
          isItalic: style.getPropertyValue('font-style') === 'italic'
        };
      }
      function isHeaderStyle(styleA, styleB, margins) {
        return margins.reduce(function(out, margin) {
          return out || (!margin.size || styleA.fontSize / margin.size > styleB.fontSize) && (!margin.weight || styleA.fontWeight - margin.weight > styleB.fontWeight) && (!margin.italic || styleA.isItalic && !styleB.isItalic);
        }, false);
      }
      function pAsHeadingEvaluate(node, options, virtualNode) {
        var siblings = Array.from(node.parentNode.children);
        var currentIndex = siblings.indexOf(node);
        options = options || {};
        var margins = options.margins || [];
        var nextSibling = siblings.slice(currentIndex + 1).find(function(elm) {
          return elm.nodeName.toUpperCase() === 'P';
        });
        var prevSibling = siblings.slice(0, currentIndex).reverse().find(function(elm) {
          return elm.nodeName.toUpperCase() === 'P';
        });
        var currStyle = getStyleValues(node);
        var nextStyle = nextSibling ? getStyleValues(nextSibling) : null;
        var prevStyle = prevSibling ? getStyleValues(prevSibling) : null;
        if (!nextStyle || !isHeaderStyle(currStyle, nextStyle, margins)) {
          return true;
        }
        var blockquote = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['findUpVirtual'])(virtualNode, 'blockquote');
        if (blockquote && blockquote.nodeName.toUpperCase() === 'BLOCKQUOTE') {
          return undefined;
        }
        if (prevStyle && !isHeaderStyle(currStyle, prevStyle, margins)) {
          return undefined;
        }
        return false;
      }
      __webpack_exports__['default'] = pAsHeadingEvaluate;
    },
    './lib/checks/navigation/region-evaluate.js': function libChecksNavigationRegionEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/index.js');
      var _commons_standards__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/standards/index.js');
      var _commons_matches__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/matches/index.js');
      var _core_base_cache__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/core/base/cache.js');
      var landmarkRoles = _commons_standards__WEBPACK_IMPORTED_MODULE_2__['getAriaRolesByType']('landmark');
      var implicitAriaLiveRoles = [ 'alert', 'log', 'status' ];
      function isRegion(virtualNode, options) {
        var node = virtualNode.actualNode;
        var role = _commons_aria__WEBPACK_IMPORTED_MODULE_1__['getRole'](virtualNode);
        var ariaLive = (node.getAttribute('aria-live') || '').toLowerCase().trim();
        if ([ 'assertive', 'polite' ].includes(ariaLive) || implicitAriaLiveRoles.includes(role)) {
          return true;
        }
        if (landmarkRoles.includes(role)) {
          return true;
        }
        if (options.regionMatcher && Object(_commons_matches__WEBPACK_IMPORTED_MODULE_3__['default'])(virtualNode, options.regionMatcher)) {
          return true;
        }
        return false;
      }
      function findRegionlessElms(virtualNode, options) {
        var node = virtualNode.actualNode;
        if (isRegion(virtualNode, options) || _commons_dom__WEBPACK_IMPORTED_MODULE_0__['isSkipLink'](virtualNode.actualNode) && _commons_dom__WEBPACK_IMPORTED_MODULE_0__['getElementByReference'](virtualNode.actualNode, 'href') || !_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isVisible'](node, true)) {
          var vNode = virtualNode;
          while (vNode) {
            vNode._hasRegionDescendant = true;
            vNode = vNode.parent;
          }
          return [];
        } else if (node !== document.body && _commons_dom__WEBPACK_IMPORTED_MODULE_0__['hasContent'](node, true)) {
          return [ virtualNode ];
        } else {
          return virtualNode.children.filter(function(_ref19) {
            var actualNode = _ref19.actualNode;
            return actualNode.nodeType === 1;
          }).map(function(vNode) {
            return findRegionlessElms(vNode, options);
          }).reduce(function(a, b) {
            return a.concat(b);
          }, []);
        }
      }
      function regionEvaluate(node, options, virtualNode) {
        var regionlessNodes = _core_base_cache__WEBPACK_IMPORTED_MODULE_4__['default'].get('regionlessNodes');
        if (regionlessNodes) {
          return !regionlessNodes.includes(virtualNode);
        }
        var tree = axe._tree;
        regionlessNodes = findRegionlessElms(tree[0], options).map(function(vNode) {
          while (vNode.parent && !vNode.parent._hasRegionDescendant && vNode.parent.actualNode !== document.body) {
            vNode = vNode.parent;
          }
          return vNode;
        }).filter(function(vNode, index, array) {
          return array.indexOf(vNode) === index;
        });
        _core_base_cache__WEBPACK_IMPORTED_MODULE_4__['default'].set('regionlessNodes', regionlessNodes);
        return !regionlessNodes.includes(virtualNode);
      }
      __webpack_exports__['default'] = regionEvaluate;
    },
    './lib/checks/navigation/skip-link-evaluate.js': function libChecksNavigationSkipLinkEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      function skipLinkEvaluate(node) {
        var target = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getElementByReference'])(node, 'href');
        if (target) {
          return Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isVisible'])(target, true) || undefined;
        }
        return false;
      }
      __webpack_exports__['default'] = skipLinkEvaluate;
    },
    './lib/checks/navigation/unique-frame-title-after.js': function libChecksNavigationUniqueFrameTitleAfterJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function uniqueFrameTitleAfter(results) {
        var titles = {};
        results.forEach(function(r) {
          titles[r.data] = titles[r.data] !== undefined ? ++titles[r.data] : 0;
        });
        results.forEach(function(r) {
          r.result = !!titles[r.data];
        });
        return results;
      }
      __webpack_exports__['default'] = uniqueFrameTitleAfter;
    },
    './lib/checks/navigation/unique-frame-title-evaluate.js': function libChecksNavigationUniqueFrameTitleEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      function uniqueFrameTitleEvaluate(node, options, vNode) {
        var title = Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['sanitize'])(vNode.attr('title') || '').trim().toLowerCase();
        this.data(title);
        return true;
      }
      __webpack_exports__['default'] = uniqueFrameTitleEvaluate;
    },
    './lib/checks/parsing/duplicate-id-after.js': function libChecksParsingDuplicateIdAfterJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function duplicateIdAfter(results) {
        var uniqueIds = [];
        return results.filter(function(r) {
          if (uniqueIds.indexOf(r.data) === -1) {
            uniqueIds.push(r.data);
            return true;
          }
          return false;
        });
      }
      __webpack_exports__['default'] = duplicateIdAfter;
    },
    './lib/checks/parsing/duplicate-id-evaluate.js': function libChecksParsingDuplicateIdEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function duplicateIdEvaluate(node) {
        var id = node.getAttribute('id').trim();
        if (!id) {
          return true;
        }
        var root = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getRootNode'])(node);
        var matchingNodes = Array.from(root.querySelectorAll('[id="'.concat(Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['escapeSelector'])(id), '"]'))).filter(function(foundNode) {
          return foundNode !== node;
        });
        if (matchingNodes.length) {
          this.relatedNodes(matchingNodes);
        }
        this.data(id);
        return matchingNodes.length === 0;
      }
      __webpack_exports__['default'] = duplicateIdEvaluate;
    },
    './lib/checks/shared/aria-label-evaluate.js': function libChecksSharedAriaLabelEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/index.js');
      function ariaLabelEvaluate(node, options, virtualNode) {
        return !!Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['sanitize'])(Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['arialabelText'])(virtualNode));
      }
      __webpack_exports__['default'] = ariaLabelEvaluate;
    },
    './lib/checks/shared/aria-labelledby-evaluate.js': function libChecksSharedAriaLabelledbyEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/index.js');
      function ariaLabelledbyEvaluate(node, options, virtualNode) {
        try {
          return !!Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['sanitize'])(Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['arialabelledbyText'])(virtualNode));
        } catch (e) {
          return undefined;
        }
      }
      __webpack_exports__['default'] = ariaLabelledbyEvaluate;
    },
    './lib/checks/shared/avoid-inline-spacing-evaluate.js': function libChecksSharedAvoidInlineSpacingEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function avoidInlineSpacingEvaluate(node, options) {
        var overriddenProperties = options.cssProperties.filter(function(property) {
          if (node.style.getPropertyPriority(property) === 'important') {
            return property;
          }
        });
        if (overriddenProperties.length > 0) {
          this.data(overriddenProperties);
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = avoidInlineSpacingEvaluate;
    },
    './lib/checks/shared/doc-has-title-evaluate.js': function libChecksSharedDocHasTitleEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      function docHasTitleEvaluate() {
        var title = document.title;
        return !!(title ? Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['sanitize'])(title).trim() : '');
      }
      __webpack_exports__['default'] = docHasTitleEvaluate;
    },
    './lib/checks/shared/exists-evaluate.js': function libChecksSharedExistsEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function existsEvaluate() {
        return undefined;
      }
      __webpack_exports__['default'] = existsEvaluate;
    },
    './lib/checks/shared/has-alt-evaluate.js': function libChecksSharedHasAltEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function hasAltEvaluate(node, options, virtualNode) {
        var nodeName = virtualNode.props.nodeName;
        if (![ 'img', 'input', 'area' ].includes(nodeName)) {
          return false;
        }
        return virtualNode.hasAttr('alt');
      }
      __webpack_exports__['default'] = hasAltEvaluate;
    },
    './lib/checks/shared/is-on-screen-evaluate.js': function libChecksSharedIsOnScreenEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      function isOnScreenEvaluate(node) {
        return Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isVisible'])(node, false) && !Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isOffscreen'])(node);
      }
      __webpack_exports__['default'] = isOnScreenEvaluate;
    },
    './lib/checks/shared/non-empty-if-present-evaluate.js': function libChecksSharedNonEmptyIfPresentEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function nonEmptyIfPresentEvaluate(node, options, virtualNode) {
        var nodeName = virtualNode.props.nodeName;
        var type = (virtualNode.attr('type') || '').toLowerCase();
        var label = virtualNode.attr('value');
        if (label) {
          this.data({
            messageKey: 'has-label'
          });
        }
        if (nodeName === 'input' && [ 'submit', 'reset' ].includes(type)) {
          return label === null;
        }
        return false;
      }
      __webpack_exports__['default'] = nonEmptyIfPresentEvaluate;
    },
    './lib/checks/shared/svg-non-empty-title-evaluate.js': function libChecksSharedSvgNonEmptyTitleEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text_visible_virtual__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/visible-virtual.js');
      function svgNonEmptyTitleEvaluate(node, options, virtualNode) {
        try {
          var titleNode = virtualNode.children.find(function(_ref20) {
            var props = _ref20.props;
            return props.nodeName === 'title';
          });
          if (!titleNode) {
            this.data({
              messageKey: 'noTitle'
            });
            return false;
          }
          if (Object(_commons_text_visible_virtual__WEBPACK_IMPORTED_MODULE_0__['default'])(titleNode) === '') {
            this.data({
              messageKey: 'emptyTitle'
            });
            return false;
          }
          return true;
        } catch (e) {
          return undefined;
        }
      }
      __webpack_exports__['default'] = svgNonEmptyTitleEvaluate;
    },
    './lib/checks/tables/caption-faked-evaluate.js': function libChecksTablesCaptionFakedEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/table/index.js');
      function captionFakedEvaluate(node) {
        var table = Object(_commons_table__WEBPACK_IMPORTED_MODULE_0__['toGrid'])(node);
        var firstRow = table[0];
        if (table.length <= 1 || firstRow.length <= 1 || node.rows.length <= 1) {
          return true;
        }
        return firstRow.reduce(function(out, curr, i) {
          return out || curr !== firstRow[i + 1] && firstRow[i + 1] !== undefined;
        }, false);
      }
      __webpack_exports__['default'] = captionFakedEvaluate;
    },
    './lib/checks/tables/html5-scope-evaluate.js': function libChecksTablesHtml5ScopeEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      function html5ScopeEvaluate(node) {
        if (!Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isHTML5'])(document)) {
          return true;
        }
        return node.nodeName.toUpperCase() === 'TH';
      }
      __webpack_exports__['default'] = html5ScopeEvaluate;
    },
    './lib/checks/tables/same-caption-summary-evaluate.js': function libChecksTablesSameCaptionSummaryEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      function sameCaptionSummaryEvaluate(node) {
        return !!(node.summary && node.caption) && node.summary.toLowerCase() === Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['accessibleText'])(node.caption).toLowerCase();
      }
      __webpack_exports__['default'] = sameCaptionSummaryEvaluate;
    },
    './lib/checks/tables/scope-value-evaluate.js': function libChecksTablesScopeValueEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function scopeValueEvaluate(node, options) {
        var value = node.getAttribute('scope').toLowerCase();
        return options.values.indexOf(value) !== -1;
      }
      __webpack_exports__['default'] = scopeValueEvaluate;
    },
    './lib/checks/tables/td-has-header-evaluate.js': function libChecksTablesTdHasHeaderEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/table/index.js');
      var _commons_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/aria/index.js');
      function tdHasHeaderEvaluate(node) {
        var badCells = [];
        var cells = _commons_table__WEBPACK_IMPORTED_MODULE_0__['getAllCells'](node);
        var tableGrid = _commons_table__WEBPACK_IMPORTED_MODULE_0__['toGrid'](node);
        cells.forEach(function(cell) {
          if (Object(_commons_dom__WEBPACK_IMPORTED_MODULE_1__['hasContent'])(cell) && _commons_table__WEBPACK_IMPORTED_MODULE_0__['isDataCell'](cell) && !Object(_commons_aria__WEBPACK_IMPORTED_MODULE_2__['label'])(cell)) {
            var hasHeaders = _commons_table__WEBPACK_IMPORTED_MODULE_0__['getHeaders'](cell, tableGrid).some(function(header) {
              return header !== null && !!Object(_commons_dom__WEBPACK_IMPORTED_MODULE_1__['hasContent'])(header);
            });
            if (!hasHeaders) {
              badCells.push(cell);
            }
          }
        });
        if (badCells.length) {
          this.relatedNodes(badCells);
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = tdHasHeaderEvaluate;
    },
    './lib/checks/tables/td-headers-attr-evaluate.js': function libChecksTablesTdHeadersAttrEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function tdHeadersAttrEvaluate(node) {
        var cells = [];
        var reviewCells = [];
        var badCells = [];
        for (var rowIndex = 0; rowIndex < node.rows.length; rowIndex++) {
          var row = node.rows[rowIndex];
          for (var cellIndex = 0; cellIndex < row.cells.length; cellIndex++) {
            cells.push(row.cells[cellIndex]);
          }
        }
        var ids = cells.reduce(function(ids, cell) {
          if (cell.getAttribute('id')) {
            ids.push(cell.getAttribute('id'));
          }
          return ids;
        }, []);
        cells.forEach(function(cell) {
          var isSelf = false;
          var notOfTable = false;
          if (!cell.hasAttribute('headers')) {
            return;
          }
          var headersAttr = cell.getAttribute('headers').trim();
          if (!headersAttr) {
            return reviewCells.push(cell);
          }
          var headers = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['tokenList'])(headersAttr);
          if (headers.length !== 0) {
            if (cell.getAttribute('id')) {
              isSelf = headers.indexOf(cell.getAttribute('id').trim()) !== -1;
            }
            notOfTable = headers.some(function(header) {
              return !ids.includes(header);
            });
            if (isSelf || notOfTable) {
              badCells.push(cell);
            }
          }
        });
        if (badCells.length > 0) {
          this.relatedNodes(badCells);
          return false;
        }
        if (reviewCells.length) {
          this.relatedNodes(reviewCells);
          return undefined;
        }
        return true;
      }
      __webpack_exports__['default'] = tdHeadersAttrEvaluate;
    },
    './lib/checks/tables/th-has-data-cells-evaluate.js': function libChecksTablesThHasDataCellsEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/table/index.js');
      var _commons_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/index.js');
      function thHasDataCellsEvaluate(node) {
        var cells = _commons_table__WEBPACK_IMPORTED_MODULE_0__['getAllCells'](node);
        var checkResult = this;
        var reffedHeaders = [];
        cells.forEach(function(cell) {
          var headers = cell.getAttribute('headers');
          if (headers) {
            reffedHeaders = reffedHeaders.concat(headers.split(/\s+/));
          }
          var ariaLabel = cell.getAttribute('aria-labelledby');
          if (ariaLabel) {
            reffedHeaders = reffedHeaders.concat(ariaLabel.split(/\s+/));
          }
        });
        var headers = cells.filter(function(cell) {
          if (Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['sanitize'])(cell.textContent) === '') {
            return false;
          }
          return cell.nodeName.toUpperCase() === 'TH' || [ 'rowheader', 'columnheader' ].indexOf(cell.getAttribute('role')) !== -1;
        });
        var tableGrid = _commons_table__WEBPACK_IMPORTED_MODULE_0__['toGrid'](node);
        var out = true;
        headers.forEach(function(header) {
          if (header.getAttribute('id') && reffedHeaders.includes(header.getAttribute('id'))) {
            return;
          }
          var pos = _commons_table__WEBPACK_IMPORTED_MODULE_0__['getCellPosition'](header, tableGrid);
          var hasCell = false;
          if (_commons_table__WEBPACK_IMPORTED_MODULE_0__['isColumnHeader'](header)) {
            hasCell = _commons_table__WEBPACK_IMPORTED_MODULE_0__['traverse']('down', pos, tableGrid).find(function(cell) {
              return !_commons_table__WEBPACK_IMPORTED_MODULE_0__['isColumnHeader'](cell) && _commons_table__WEBPACK_IMPORTED_MODULE_0__['getHeaders'](cell, tableGrid).includes(header);
            });
          }
          if (!hasCell && _commons_table__WEBPACK_IMPORTED_MODULE_0__['isRowHeader'](header)) {
            hasCell = _commons_table__WEBPACK_IMPORTED_MODULE_0__['traverse']('right', pos, tableGrid).find(function(cell) {
              return !_commons_table__WEBPACK_IMPORTED_MODULE_0__['isRowHeader'](cell) && _commons_table__WEBPACK_IMPORTED_MODULE_0__['getHeaders'](cell, tableGrid).includes(header);
            });
          }
          if (!hasCell) {
            checkResult.relatedNodes(header);
          }
          out = out && hasCell;
        });
        return out ? true : undefined;
      }
      __webpack_exports__['default'] = thHasDataCellsEvaluate;
    },
    './lib/checks/visibility/hidden-content-evaluate.js': function libChecksVisibilityHiddenContentEvaluateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      function hiddenContentEvaluate(node, options, virtualNode) {
        var whitelist = [ 'SCRIPT', 'HEAD', 'TITLE', 'NOSCRIPT', 'STYLE', 'TEMPLATE' ];
        if (!whitelist.includes(node.nodeName.toUpperCase()) && Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['hasContentVirtual'])(virtualNode)) {
          var styles = window.getComputedStyle(node);
          if (styles.getPropertyValue('display') === 'none') {
            return undefined;
          } else if (styles.getPropertyValue('visibility') === 'hidden') {
            var parent = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getComposedParent'])(node);
            var parentStyle = parent && window.getComputedStyle(parent);
            if (!parentStyle || parentStyle.getPropertyValue('visibility') !== 'hidden') {
              return undefined;
            }
          }
        }
        return true;
      }
      __webpack_exports__['default'] = hiddenContentEvaluate;
    },
    './lib/commons/aria/allowed-attr.js': function libCommonsAriaAllowedAttrJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      var _standards_get_global_aria_attrs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/standards/get-global-aria-attrs.js');
      function allowedAttr(role) {
        var roleDef = _standards__WEBPACK_IMPORTED_MODULE_0__['default'].ariaRoles[role];
        var attrs = _toConsumableArray(Object(_standards_get_global_aria_attrs__WEBPACK_IMPORTED_MODULE_1__['default'])());
        if (!roleDef) {
          return attrs;
        }
        if (roleDef.allowedAttrs) {
          attrs.push.apply(attrs, _toConsumableArray(roleDef.allowedAttrs));
        }
        if (roleDef.requiredAttrs) {
          attrs.push.apply(attrs, _toConsumableArray(roleDef.requiredAttrs));
        }
        return attrs;
      }
      __webpack_exports__['default'] = allowedAttr;
    },
    './lib/commons/aria/arialabel-text.js': function libCommonsAriaArialabelTextJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function arialabelText(vNode) {
        if (!(vNode instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_0__['default'])) {
          if (vNode.nodeType !== 1) {
            return '';
          }
          vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeFromTree'])(vNode);
        }
        return vNode.attr('aria-label') || '';
      }
      __webpack_exports__['default'] = arialabelText;
    },
    './lib/commons/aria/arialabelledby-text.js': function libCommonsAriaArialabelledbyTextJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _dom_idrefs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/idrefs.js');
      var _text_accessible_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/accessible-text.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/index.js');
      function arialabelledbyText(vNode) {
        var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        if (!(vNode instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_2__['default'])) {
          if (vNode.nodeType !== 1) {
            return '';
          }
          vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['getNodeFromTree'])(vNode);
        }
        if (vNode.props.nodeType !== 1 || context.inLabelledByContext || context.inControlContext || !vNode.attr('aria-labelledby')) {
          return '';
        }
        var refs = Object(_dom_idrefs__WEBPACK_IMPORTED_MODULE_0__['default'])(vNode, 'aria-labelledby').filter(function(elm) {
          return elm;
        });
        return refs.reduce(function(accessibleName, elm) {
          var accessibleNameAdd = Object(_text_accessible_text__WEBPACK_IMPORTED_MODULE_1__['default'])(elm, _extends({
            inLabelledByContext: true,
            startNode: context.startNode || vNode
          }, context));
          if (!accessibleName) {
            return accessibleNameAdd;
          } else {
            return ''.concat(accessibleName, ' ').concat(accessibleNameAdd);
          }
        }, '');
      }
      __webpack_exports__['default'] = arialabelledbyText;
    },
    './lib/commons/aria/get-element-unallowed-roles.js': function libCommonsAriaGetElementUnallowedRolesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _is_valid_role__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/is-valid-role.js');
      var _implicit_role__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/implicit-role.js');
      var _get_role_type__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/aria/get-role-type.js');
      var _is_aria_role_allowed_on_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/aria/is-aria-role-allowed-on-element.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/core/utils/index.js');
      var dpubRoles = [ 'doc-backlink', 'doc-biblioentry', 'doc-biblioref', 'doc-cover', 'doc-endnote', 'doc-glossref', 'doc-noteref' ];
      function getRoleSegments(node) {
        var roles = [];
        if (!node) {
          return roles;
        }
        if (node.hasAttribute('role')) {
          var nodeRoles = Object(_core_utils__WEBPACK_IMPORTED_MODULE_4__['tokenList'])(node.getAttribute('role').toLowerCase());
          roles = roles.concat(nodeRoles);
        }
        if (node.hasAttributeNS('http://www.idpf.org/2007/ops', 'type')) {
          var epubRoles = Object(_core_utils__WEBPACK_IMPORTED_MODULE_4__['tokenList'])(node.getAttributeNS('http://www.idpf.org/2007/ops', 'type').toLowerCase()).map(function(role) {
            return 'doc-'.concat(role);
          });
          roles = roles.concat(epubRoles);
        }
        roles = roles.filter(function(role) {
          return Object(_is_valid_role__WEBPACK_IMPORTED_MODULE_0__['default'])(role);
        });
        return roles;
      }
      function getElementUnallowedRoles(node) {
        var allowImplicit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
        var tagName = node.nodeName.toUpperCase();
        if (!Object(_core_utils__WEBPACK_IMPORTED_MODULE_4__['isHtmlElement'])(node)) {
          return [];
        }
        var roleSegments = getRoleSegments(node);
        var implicitRole = Object(_implicit_role__WEBPACK_IMPORTED_MODULE_1__['default'])(node);
        var unallowedRoles = roleSegments.filter(function(role) {
          if (allowImplicit && role === implicitRole) {
            return false;
          }
          if (allowImplicit && dpubRoles.includes(role)) {
            var roleType = Object(_get_role_type__WEBPACK_IMPORTED_MODULE_2__['default'])(role);
            if (implicitRole !== roleType) {
              return true;
            }
          }
          if (!allowImplicit && !(role === 'row' && tagName === 'TR' && Object(_core_utils__WEBPACK_IMPORTED_MODULE_4__['matchesSelector'])(node, 'table[role="grid"] > tr'))) {
            return true;
          }
          return !Object(_is_aria_role_allowed_on_element__WEBPACK_IMPORTED_MODULE_3__['default'])(node, role);
        });
        return unallowedRoles;
      }
      __webpack_exports__['default'] = getElementUnallowedRoles;
    },
    './lib/commons/aria/get-explicit-role.js': function libCommonsAriaGetExplicitRoleJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _is_valid_role__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/is-valid-role.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      function getExplicitRole(vNode) {
        var _ref21 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, fallback = _ref21.fallback, abstracts = _ref21.abstracts, dpub = _ref21.dpub;
        vNode = vNode instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_2__['default'] ? vNode : Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeFromTree'])(vNode);
        if (vNode.props.nodeType !== 1) {
          return null;
        }
        var roleAttr = (vNode.attr('role') || '').trim().toLowerCase();
        var roleList = fallback ? Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['tokenList'])(roleAttr) : [ roleAttr ];
        var firstValidRole = roleList.find(function(role) {
          if (!dpub && role.substr(0, 4) === 'doc-') {
            return false;
          }
          return Object(_is_valid_role__WEBPACK_IMPORTED_MODULE_0__['default'])(role, {
            allowAbstract: abstracts
          });
        });
        return firstValidRole || null;
      }
      __webpack_exports__['default'] = getExplicitRole;
    },
    './lib/commons/aria/get-owned-virtual.js': function libCommonsAriaGetOwnedVirtualJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _dom_idrefs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/idrefs.js');
      function getOwnedVirtual(virtualNode) {
        var actualNode = virtualNode.actualNode, children = virtualNode.children;
        if (!children) {
          throw new Error('getOwnedVirtual requires a virtual node');
        }
        if (virtualNode.hasAttr('aria-owns')) {
          var owns = Object(_dom_idrefs__WEBPACK_IMPORTED_MODULE_0__['default'])(actualNode, 'aria-owns').filter(function(element) {
            return !!element;
          }).map(function(element) {
            return axe.utils.getNodeFromTree(element);
          });
          return [].concat(_toConsumableArray(children), _toConsumableArray(owns));
        }
        return _toConsumableArray(children);
      }
      __webpack_exports__['default'] = getOwnedVirtual;
    },
    './lib/commons/aria/get-role-type.js': function libCommonsAriaGetRoleTypeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      function getRoleType(role) {
        var roleDef = _standards__WEBPACK_IMPORTED_MODULE_0__['default'].ariaRoles[role];
        if (!roleDef) {
          return null;
        }
        return roleDef.type;
      }
      __webpack_exports__['default'] = getRoleType;
    },
    './lib/commons/aria/get-role.js': function libCommonsAriaGetRoleJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_explicit_role__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/get-explicit-role.js');
      var _implicit_role__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/implicit-role.js');
      var _standards_get_global_aria_attrs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/standards/get-global-aria-attrs.js');
      var _dom_is_focusable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/dom/is-focusable.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/core/utils/index.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var inheritsPresentationChain = {
        td: [ 'tr' ],
        th: [ 'tr' ],
        tr: [ 'thead', 'tbody', 'tfoot', 'table' ],
        thead: [ 'table' ],
        tbody: [ 'table' ],
        tfoot: [ 'table' ],
        li: [ 'ol', 'ul' ],
        dt: [ 'dl', 'div' ],
        dd: [ 'dl', 'div' ],
        div: [ 'dl' ]
      };
      function getInheritedRole(vNode, explicitRoleOptions) {
        var parentNodeNames = inheritsPresentationChain[vNode.props.nodeName];
        if (!parentNodeNames) {
          return null;
        }
        if (!vNode.parent) {
          throw new ReferenceError('Cannot determine role presentational inheritance of a required parent outside the current scope.');
        }
        if (!parentNodeNames.includes(vNode.parent.props.nodeName)) {
          return null;
        }
        var parentRole = Object(_get_explicit_role__WEBPACK_IMPORTED_MODULE_0__['default'])(vNode.parent, explicitRoleOptions);
        if ([ 'none', 'presentation' ].includes(parentRole) && !hasConflictResolution(vNode.parent)) {
          return parentRole;
        }
        if (parentRole) {
          return null;
        }
        return getInheritedRole(vNode.parent, explicitRoleOptions);
      }
      function resolveImplicitRole(vNode, explicitRoleOptions) {
        var implicitRole = Object(_implicit_role__WEBPACK_IMPORTED_MODULE_1__['default'])(vNode);
        if (!implicitRole) {
          return null;
        }
        var presentationalRole = getInheritedRole(vNode, explicitRoleOptions);
        if (presentationalRole) {
          return presentationalRole;
        }
        return implicitRole;
      }
      function hasConflictResolution(vNode) {
        var hasGlobalAria = Object(_standards_get_global_aria_attrs__WEBPACK_IMPORTED_MODULE_2__['default'])().some(function(attr) {
          return vNode.hasAttr(attr);
        });
        return hasGlobalAria || Object(_dom_is_focusable__WEBPACK_IMPORTED_MODULE_3__['default'])(vNode);
      }
      function getRole(node) {
        var _ref22 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var noImplicit = _ref22.noImplicit, explicitRoleOptions = _objectWithoutProperties(_ref22, [ 'noImplicit' ]);
        var vNode = node instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_5__['default'] ? node : Object(_core_utils__WEBPACK_IMPORTED_MODULE_4__['getNodeFromTree'])(node);
        if (vNode.props.nodeType !== 1) {
          return null;
        }
        var explicitRole = Object(_get_explicit_role__WEBPACK_IMPORTED_MODULE_0__['default'])(vNode, explicitRoleOptions);
        if (!explicitRole) {
          return noImplicit ? null : resolveImplicitRole(vNode, explicitRoleOptions);
        }
        if (![ 'presentation', 'none' ].includes(explicitRole)) {
          return explicitRole;
        }
        if (hasConflictResolution(vNode)) {
          return noImplicit ? null : resolveImplicitRole(vNode, explicitRoleOptions);
        }
        return explicitRole;
      }
      __webpack_exports__['default'] = getRole;
    },
    './lib/commons/aria/get-roles-by-type.js': function libCommonsAriaGetRolesByTypeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards_get_aria_roles_by_type__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/standards/get-aria-roles-by-type.js');
      function getRolesByType(roleType) {
        return Object(_standards_get_aria_roles_by_type__WEBPACK_IMPORTED_MODULE_0__['default'])(roleType);
      }
      __webpack_exports__['default'] = getRolesByType;
    },
    './lib/commons/aria/get-roles-with-name-from-contents.js': function libCommonsAriaGetRolesWithNameFromContentsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards_get_aria_roles_supporting_name_from_content__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/standards/get-aria-roles-supporting-name-from-content.js');
      function getRolesWithNameFromContents() {
        return Object(_standards_get_aria_roles_supporting_name_from_content__WEBPACK_IMPORTED_MODULE_0__['default'])();
      }
      __webpack_exports__['default'] = getRolesWithNameFromContents;
    },
    './lib/commons/aria/implicit-nodes.js': function libCommonsAriaImplicitNodesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      var _lookup_table__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/lookup-table.js');
      function implicitNodes(role) {
        'use strict';
        var implicit = null;
        var roles = _lookup_table__WEBPACK_IMPORTED_MODULE_1__['default'].role[role];
        if (roles && roles.implicit) {
          implicit = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['clone'])(roles.implicit);
        }
        return implicit;
      }
      __webpack_exports__['default'] = implicitNodes;
    },
    './lib/commons/aria/implicit-role.js': function libCommonsAriaImplicitRoleJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards_implicit_html_roles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/standards/implicit-html-roles.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      function implicitRole(node) {
        var vNode = node instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_2__['default'] ? node : Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeFromTree'])(node);
        node = vNode.actualNode;
        if (!vNode) {
          throw new ReferenceError('Cannot get implicit role of a node outside the current scope.');
        }
        if (node && node.namespaceURI === 'http://www.w3.org/2000/svg') {
          return null;
        }
        var nodeName = vNode.props.nodeName;
        var role = _standards_implicit_html_roles__WEBPACK_IMPORTED_MODULE_0__['default'][nodeName];
        if (!role) {
          return null;
        }
        if (typeof role === 'function') {
          return role(vNode);
        }
        return role;
      }
      __webpack_exports__['default'] = implicitRole;
    },
    './lib/commons/aria/index.js': function libCommonsAriaIndexJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _allowed_attr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/allowed-attr.js');
      __webpack_require__.d(__webpack_exports__, 'allowedAttr', function() {
        return _allowed_attr__WEBPACK_IMPORTED_MODULE_0__['default'];
      });
      var _arialabel_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/arialabel-text.js');
      __webpack_require__.d(__webpack_exports__, 'arialabelText', function() {
        return _arialabel_text__WEBPACK_IMPORTED_MODULE_1__['default'];
      });
      var _arialabelledby_text__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/aria/arialabelledby-text.js');
      __webpack_require__.d(__webpack_exports__, 'arialabelledbyText', function() {
        return _arialabelledby_text__WEBPACK_IMPORTED_MODULE_2__['default'];
      });
      var _get_element_unallowed_roles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/aria/get-element-unallowed-roles.js');
      __webpack_require__.d(__webpack_exports__, 'getElementUnallowedRoles', function() {
        return _get_element_unallowed_roles__WEBPACK_IMPORTED_MODULE_3__['default'];
      });
      var _get_explicit_role__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/aria/get-explicit-role.js');
      __webpack_require__.d(__webpack_exports__, 'getExplicitRole', function() {
        return _get_explicit_role__WEBPACK_IMPORTED_MODULE_4__['default'];
      });
      var _get_owned_virtual__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/aria/get-owned-virtual.js');
      __webpack_require__.d(__webpack_exports__, 'getOwnedVirtual', function() {
        return _get_owned_virtual__WEBPACK_IMPORTED_MODULE_5__['default'];
      });
      var _get_role_type__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/commons/aria/get-role-type.js');
      __webpack_require__.d(__webpack_exports__, 'getRoleType', function() {
        return _get_role_type__WEBPACK_IMPORTED_MODULE_6__['default'];
      });
      var _get_role__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/commons/aria/get-role.js');
      __webpack_require__.d(__webpack_exports__, 'getRole', function() {
        return _get_role__WEBPACK_IMPORTED_MODULE_7__['default'];
      });
      var _get_roles_by_type__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__('./lib/commons/aria/get-roles-by-type.js');
      __webpack_require__.d(__webpack_exports__, 'getRolesByType', function() {
        return _get_roles_by_type__WEBPACK_IMPORTED_MODULE_8__['default'];
      });
      var _get_roles_with_name_from_contents__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__('./lib/commons/aria/get-roles-with-name-from-contents.js');
      __webpack_require__.d(__webpack_exports__, 'getRolesWithNameFromContents', function() {
        return _get_roles_with_name_from_contents__WEBPACK_IMPORTED_MODULE_9__['default'];
      });
      var _implicit_nodes__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__('./lib/commons/aria/implicit-nodes.js');
      __webpack_require__.d(__webpack_exports__, 'implicitNodes', function() {
        return _implicit_nodes__WEBPACK_IMPORTED_MODULE_10__['default'];
      });
      var _implicit_role__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__('./lib/commons/aria/implicit-role.js');
      __webpack_require__.d(__webpack_exports__, 'implicitRole', function() {
        return _implicit_role__WEBPACK_IMPORTED_MODULE_11__['default'];
      });
      var _is_accessible_ref__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__('./lib/commons/aria/is-accessible-ref.js');
      __webpack_require__.d(__webpack_exports__, 'isAccessibleRef', function() {
        return _is_accessible_ref__WEBPACK_IMPORTED_MODULE_12__['default'];
      });
      var _is_aria_role_allowed_on_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__('./lib/commons/aria/is-aria-role-allowed-on-element.js');
      __webpack_require__.d(__webpack_exports__, 'isAriaRoleAllowedOnElement', function() {
        return _is_aria_role_allowed_on_element__WEBPACK_IMPORTED_MODULE_13__['default'];
      });
      var _is_unsupported_role__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__('./lib/commons/aria/is-unsupported-role.js');
      __webpack_require__.d(__webpack_exports__, 'isUnsupportedRole', function() {
        return _is_unsupported_role__WEBPACK_IMPORTED_MODULE_14__['default'];
      });
      var _is_valid_role__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__('./lib/commons/aria/is-valid-role.js');
      __webpack_require__.d(__webpack_exports__, 'isValidRole', function() {
        return _is_valid_role__WEBPACK_IMPORTED_MODULE_15__['default'];
      });
      var _label_virtual__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__('./lib/commons/aria/label-virtual.js');
      __webpack_require__.d(__webpack_exports__, 'labelVirtual', function() {
        return _label_virtual__WEBPACK_IMPORTED_MODULE_16__['default'];
      });
      var _label__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__('./lib/commons/aria/label.js');
      __webpack_require__.d(__webpack_exports__, 'label', function() {
        return _label__WEBPACK_IMPORTED_MODULE_17__['default'];
      });
      var _lookup_table__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__('./lib/commons/aria/lookup-table.js');
      __webpack_require__.d(__webpack_exports__, 'lookupTable', function() {
        return _lookup_table__WEBPACK_IMPORTED_MODULE_18__['default'];
      });
      var _named_from_contents__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__('./lib/commons/aria/named-from-contents.js');
      __webpack_require__.d(__webpack_exports__, 'namedFromContents', function() {
        return _named_from_contents__WEBPACK_IMPORTED_MODULE_19__['default'];
      });
      var _required_attr__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__('./lib/commons/aria/required-attr.js');
      __webpack_require__.d(__webpack_exports__, 'requiredAttr', function() {
        return _required_attr__WEBPACK_IMPORTED_MODULE_20__['default'];
      });
      var _required_context__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__('./lib/commons/aria/required-context.js');
      __webpack_require__.d(__webpack_exports__, 'requiredContext', function() {
        return _required_context__WEBPACK_IMPORTED_MODULE_21__['default'];
      });
      var _required_owned__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__('./lib/commons/aria/required-owned.js');
      __webpack_require__.d(__webpack_exports__, 'requiredOwned', function() {
        return _required_owned__WEBPACK_IMPORTED_MODULE_22__['default'];
      });
      var _validate_attr_value__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__('./lib/commons/aria/validate-attr-value.js');
      __webpack_require__.d(__webpack_exports__, 'validateAttrValue', function() {
        return _validate_attr_value__WEBPACK_IMPORTED_MODULE_23__['default'];
      });
      var _validate_attr__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__('./lib/commons/aria/validate-attr.js');
      __webpack_require__.d(__webpack_exports__, 'validateAttr', function() {
        return _validate_attr__WEBPACK_IMPORTED_MODULE_24__['default'];
      });
    },
    './lib/commons/aria/is-accessible-ref.js': function libCommonsAriaIsAccessibleRefJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      var _dom_get_root_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/get-root-node.js');
      var _core_base_cache__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/base/cache.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/index.js');
      var idRefsRegex = /^idrefs?$/;
      function cacheIdRefs(node, refAttrs) {
        if (node.hasAttribute) {
          var idRefs = _core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].get('idRefs');
          if (node.nodeName.toUpperCase() === 'LABEL' && node.hasAttribute('for')) {
            idRefs[node.getAttribute('for')] = true;
          }
          for (var i = 0; i < refAttrs.length; ++i) {
            var attr = refAttrs[i];
            if (!node.hasAttribute(attr)) {
              continue;
            }
            var attrValue = node.getAttribute(attr);
            var tokens = Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['tokenList'])(attrValue);
            for (var k = 0; k < tokens.length; ++k) {
              idRefs[tokens[k]] = true;
            }
          }
        }
        for (var _i3 = 0; _i3 < node.children.length; _i3++) {
          cacheIdRefs(node.children[_i3], refAttrs);
        }
      }
      function isAccessibleRef(node) {
        node = node.actualNode || node;
        var root = Object(_dom_get_root_node__WEBPACK_IMPORTED_MODULE_1__['default'])(node);
        root = root.documentElement || root;
        var id = node.id;
        if (!_core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].get('idRefs')) {
          _core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].set('idRefs', {});
          var refAttrs = Object.keys(_standards__WEBPACK_IMPORTED_MODULE_0__['default'].ariaAttrs).filter(function(attr) {
            var type = _standards__WEBPACK_IMPORTED_MODULE_0__['default'].ariaAttrs[attr].type;
            return idRefsRegex.test(type);
          });
          cacheIdRefs(root, refAttrs);
        }
        return _core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].get('idRefs')[id] === true;
      }
      __webpack_exports__['default'] = isAccessibleRef;
    },
    './lib/commons/aria/is-aria-role-allowed-on-element.js': function libCommonsAriaIsAriaRoleAllowedOnElementJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _implicit_role__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/aria/implicit-role.js');
      var _standards_get_element_spec__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/standards/get-element-spec.js');
      function isAriaRoleAllowedOnElement(node, role) {
        var vNode = node instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_1__['default'] ? node : Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['getNodeFromTree'])(node);
        var implicitRole = Object(_implicit_role__WEBPACK_IMPORTED_MODULE_2__['default'])(vNode);
        if (role === implicitRole) {
          return true;
        }
        var spec = Object(_standards_get_element_spec__WEBPACK_IMPORTED_MODULE_3__['default'])(vNode);
        if (Array.isArray(spec.allowedRoles)) {
          return spec.allowedRoles.includes(role);
        }
        return !!spec.allowedRoles;
      }
      __webpack_exports__['default'] = isAriaRoleAllowedOnElement;
    },
    './lib/commons/aria/is-unsupported-role.js': function libCommonsAriaIsUnsupportedRoleJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      function isUnsupportedRole(role) {
        var roleDefinition = _standards__WEBPACK_IMPORTED_MODULE_0__['default'].ariaRoles[role];
        return roleDefinition ? !!roleDefinition.unsupported : false;
      }
      __webpack_exports__['default'] = isUnsupportedRole;
    },
    './lib/commons/aria/is-valid-role.js': function libCommonsAriaIsValidRoleJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      var _is_unsupported_role__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/is-unsupported-role.js');
      function isValidRole(role) {
        var _ref23 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, allowAbstract = _ref23.allowAbstract, _ref23$flagUnsupporte = _ref23.flagUnsupported, flagUnsupported = _ref23$flagUnsupporte === void 0 ? false : _ref23$flagUnsupporte;
        var roleDefinition = _standards__WEBPACK_IMPORTED_MODULE_0__['default'].ariaRoles[role];
        var isRoleUnsupported = Object(_is_unsupported_role__WEBPACK_IMPORTED_MODULE_1__['default'])(role);
        if (!roleDefinition || flagUnsupported && isRoleUnsupported) {
          return false;
        }
        return allowAbstract ? true : roleDefinition.type !== 'abstract';
      }
      __webpack_exports__['default'] = isValidRole;
    },
    './lib/commons/aria/label-virtual.js': function libCommonsAriaLabelVirtualJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _dom_idrefs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/idrefs.js');
      var _text_visible_virtual__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/visible-virtual.js');
      var _text_sanitize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/text/sanitize.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/index.js');
      function labelVirtual(virtualNode) {
        var ref, candidate;
        if (virtualNode.attr('aria-labelledby')) {
          ref = Object(_dom_idrefs__WEBPACK_IMPORTED_MODULE_0__['default'])(virtualNode.actualNode, 'aria-labelledby');
          candidate = ref.map(function(thing) {
            var vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['getNodeFromTree'])(thing);
            return vNode ? Object(_text_visible_virtual__WEBPACK_IMPORTED_MODULE_1__['default'])(vNode, true) : '';
          }).join(' ').trim();
          if (candidate) {
            return candidate;
          }
        }
        candidate = virtualNode.attr('aria-label');
        if (candidate) {
          candidate = Object(_text_sanitize__WEBPACK_IMPORTED_MODULE_2__['default'])(candidate).trim();
          if (candidate) {
            return candidate;
          }
        }
        return null;
      }
      __webpack_exports__['default'] = labelVirtual;
    },
    './lib/commons/aria/label.js': function libCommonsAriaLabelJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _label_virtual__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/label-virtual.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function label(node) {
        node = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeFromTree'])(node);
        return Object(_label_virtual__WEBPACK_IMPORTED_MODULE_0__['default'])(node);
      }
      __webpack_exports__['default'] = label;
    },
    './lib/commons/aria/lookup-table.js': function libCommonsAriaLookupTableJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards_implicit_html_roles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/standards/implicit-html-roles.js');
      var isNull = function isNull(value) {
        return value === null;
      };
      var isNotNull = function isNotNull(value) {
        return value !== null;
      };
      var lookupTable = {};
      lookupTable.attributes = {
        'aria-activedescendant': {
          type: 'idref',
          allowEmpty: true,
          unsupported: false
        },
        'aria-atomic': {
          type: 'boolean',
          values: [ 'true', 'false' ],
          unsupported: false
        },
        'aria-autocomplete': {
          type: 'nmtoken',
          values: [ 'inline', 'list', 'both', 'none' ],
          unsupported: false
        },
        'aria-busy': {
          type: 'boolean',
          values: [ 'true', 'false' ],
          unsupported: false
        },
        'aria-checked': {
          type: 'nmtoken',
          values: [ 'true', 'false', 'mixed', 'undefined' ],
          unsupported: false
        },
        'aria-colcount': {
          type: 'int',
          unsupported: false
        },
        'aria-colindex': {
          type: 'int',
          unsupported: false
        },
        'aria-colspan': {
          type: 'int',
          unsupported: false
        },
        'aria-controls': {
          type: 'idrefs',
          allowEmpty: true,
          unsupported: false
        },
        'aria-current': {
          type: 'nmtoken',
          allowEmpty: true,
          values: [ 'page', 'step', 'location', 'date', 'time', 'true', 'false' ],
          unsupported: false
        },
        'aria-describedby': {
          type: 'idrefs',
          allowEmpty: true,
          unsupported: false
        },
        'aria-describedat': {
          unsupported: true,
          unstandardized: true
        },
        'aria-details': {
          type: 'idref',
          allowEmpty: true,
          unsupported: false
        },
        'aria-disabled': {
          type: 'boolean',
          values: [ 'true', 'false' ],
          unsupported: false
        },
        'aria-dropeffect': {
          type: 'nmtokens',
          values: [ 'copy', 'move', 'reference', 'execute', 'popup', 'none' ],
          unsupported: false
        },
        'aria-errormessage': {
          type: 'idref',
          allowEmpty: true,
          unsupported: false
        },
        'aria-expanded': {
          type: 'nmtoken',
          values: [ 'true', 'false', 'undefined' ],
          unsupported: false
        },
        'aria-flowto': {
          type: 'idrefs',
          allowEmpty: true,
          unsupported: false
        },
        'aria-grabbed': {
          type: 'nmtoken',
          values: [ 'true', 'false', 'undefined' ],
          unsupported: false
        },
        'aria-haspopup': {
          type: 'nmtoken',
          allowEmpty: true,
          values: [ 'true', 'false', 'menu', 'listbox', 'tree', 'grid', 'dialog' ],
          unsupported: false
        },
        'aria-hidden': {
          type: 'boolean',
          values: [ 'true', 'false' ],
          unsupported: false
        },
        'aria-invalid': {
          type: 'nmtoken',
          allowEmpty: true,
          values: [ 'true', 'false', 'spelling', 'grammar' ],
          unsupported: false
        },
        'aria-keyshortcuts': {
          type: 'string',
          allowEmpty: true,
          unsupported: false
        },
        'aria-label': {
          type: 'string',
          allowEmpty: true,
          unsupported: false
        },
        'aria-labelledby': {
          type: 'idrefs',
          allowEmpty: true,
          unsupported: false
        },
        'aria-level': {
          type: 'int',
          unsupported: false
        },
        'aria-live': {
          type: 'nmtoken',
          values: [ 'off', 'polite', 'assertive' ],
          unsupported: false
        },
        'aria-modal': {
          type: 'boolean',
          values: [ 'true', 'false' ],
          unsupported: false
        },
        'aria-multiline': {
          type: 'boolean',
          values: [ 'true', 'false' ],
          unsupported: false
        },
        'aria-multiselectable': {
          type: 'boolean',
          values: [ 'true', 'false' ],
          unsupported: false
        },
        'aria-orientation': {
          type: 'nmtoken',
          values: [ 'horizontal', 'vertical' ],
          unsupported: false
        },
        'aria-owns': {
          type: 'idrefs',
          allowEmpty: true,
          unsupported: false
        },
        'aria-placeholder': {
          type: 'string',
          allowEmpty: true,
          unsupported: false
        },
        'aria-posinset': {
          type: 'int',
          unsupported: false
        },
        'aria-pressed': {
          type: 'nmtoken',
          values: [ 'true', 'false', 'mixed', 'undefined' ],
          unsupported: false
        },
        'aria-readonly': {
          type: 'boolean',
          values: [ 'true', 'false' ],
          unsupported: false
        },
        'aria-relevant': {
          type: 'nmtokens',
          values: [ 'additions', 'removals', 'text', 'all' ],
          unsupported: false
        },
        'aria-required': {
          type: 'boolean',
          values: [ 'true', 'false' ],
          unsupported: false
        },
        'aria-roledescription': {
          type: 'string',
          allowEmpty: true,
          unsupported: false
        },
        'aria-rowcount': {
          type: 'int',
          unsupported: false
        },
        'aria-rowindex': {
          type: 'int',
          unsupported: false
        },
        'aria-rowspan': {
          type: 'int',
          unsupported: false
        },
        'aria-selected': {
          type: 'nmtoken',
          values: [ 'true', 'false', 'undefined' ],
          unsupported: false
        },
        'aria-setsize': {
          type: 'int',
          unsupported: false
        },
        'aria-sort': {
          type: 'nmtoken',
          values: [ 'ascending', 'descending', 'other', 'none' ],
          unsupported: false
        },
        'aria-valuemax': {
          type: 'decimal',
          unsupported: false
        },
        'aria-valuemin': {
          type: 'decimal',
          unsupported: false
        },
        'aria-valuenow': {
          type: 'decimal',
          unsupported: false
        },
        'aria-valuetext': {
          type: 'string',
          unsupported: false
        }
      };
      lookupTable.globalAttributes = [ 'aria-atomic', 'aria-busy', 'aria-controls', 'aria-current', 'aria-describedby', 'aria-details', 'aria-disabled', 'aria-dropeffect', 'aria-flowto', 'aria-grabbed', 'aria-haspopup', 'aria-hidden', 'aria-invalid', 'aria-keyshortcuts', 'aria-label', 'aria-labelledby', 'aria-live', 'aria-owns', 'aria-relevant', 'aria-roledescription' ];
      lookupTable.role = {
        alert: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        alertdialog: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-modal', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'dialog', 'section' ]
        },
        application: {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage', 'aria-activedescendant' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'article', 'audio', 'embed', 'iframe', 'object', 'section', 'svg', 'video' ]
        },
        article: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-posinset', 'aria-setsize', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'article' ],
          unsupported: false
        },
        banner: {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'header' ],
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        button: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-pressed', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: null,
          implicit: [ 'button', 'input[type="button"]', 'input[type="image"]', 'input[type="reset"]', 'input[type="submit"]', 'summary' ],
          unsupported: false,
          allowedElements: [ {
            nodeName: 'a',
            attributes: {
              href: isNotNull
            }
          } ]
        },
        cell: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-colindex', 'aria-colspan', 'aria-rowindex', 'aria-rowspan', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: [ 'row' ],
          implicit: [ 'td', 'th' ],
          unsupported: false
        },
        checkbox: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-checked', 'aria-required', 'aria-readonly', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: null,
          implicit: [ 'input[type="checkbox"]' ],
          unsupported: false,
          allowedElements: [ 'button' ]
        },
        columnheader: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-colindex', 'aria-colspan', 'aria-expanded', 'aria-rowindex', 'aria-rowspan', 'aria-required', 'aria-readonly', 'aria-selected', 'aria-sort', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: [ 'row' ],
          implicit: [ 'th' ],
          unsupported: false
        },
        combobox: {
          type: 'composite',
          attributes: {
            allowed: [ 'aria-autocomplete', 'aria-required', 'aria-activedescendant', 'aria-orientation', 'aria-errormessage' ],
            required: [ 'aria-expanded' ]
          },
          owned: {
            all: [ 'listbox', 'tree', 'grid', 'dialog', 'textbox' ]
          },
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ {
            nodeName: 'input',
            properties: {
              type: [ 'text', 'search', 'tel', 'url', 'email' ]
            }
          } ]
        },
        command: {
          nameFrom: [ 'author' ],
          type: 'abstract',
          unsupported: false
        },
        complementary: {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'aside' ],
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        composite: {
          nameFrom: [ 'author' ],
          type: 'abstract',
          unsupported: false
        },
        contentinfo: {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'footer' ],
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        definition: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'dd', 'dfn' ],
          unsupported: false
        },
        dialog: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-modal', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'dialog' ],
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        directory: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'ol', 'ul' ]
        },
        document: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'body' ],
          unsupported: false,
          allowedElements: [ 'article', 'embed', 'iframe', 'object', 'section', 'svg' ]
        },
        'doc-abstract': {
          type: 'section',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-acknowledgments': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-afterword': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-appendix': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-backlink': {
          type: 'link',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: null,
          unsupported: false,
          allowedElements: [ {
            nodeName: 'a',
            attributes: {
              href: isNotNull
            }
          } ]
        },
        'doc-biblioentry': {
          type: 'listitem',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-level', 'aria-posinset', 'aria-setsize', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: [ 'doc-bibliography' ],
          unsupported: false,
          allowedElements: [ 'li' ]
        },
        'doc-bibliography': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: {
            one: [ 'doc-biblioentry' ]
          },
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-biblioref': {
          type: 'link',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: null,
          unsupported: false,
          allowedElements: [ {
            nodeName: 'a',
            attributes: {
              href: isNotNull
            }
          } ]
        },
        'doc-chapter': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-colophon': {
          type: 'section',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-conclusion': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-cover': {
          type: 'img',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false
        },
        'doc-credit': {
          type: 'section',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-credits': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-dedication': {
          type: 'section',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-endnote': {
          type: 'listitem',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-level', 'aria-posinset', 'aria-setsize', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: [ 'doc-endnotes' ],
          unsupported: false,
          allowedElements: [ 'li' ]
        },
        'doc-endnotes': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: {
            one: [ 'doc-endnote' ]
          },
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-epigraph': {
          type: 'section',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false
        },
        'doc-epilogue': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-errata': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-example': {
          type: 'section',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'aside', 'section' ]
        },
        'doc-footnote': {
          type: 'section',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'aside', 'footer', 'header' ]
        },
        'doc-foreword': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-glossary': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: [ 'term', 'definition' ],
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'dl' ]
        },
        'doc-glossref': {
          type: 'link',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author', 'contents' ],
          context: null,
          unsupported: false,
          allowedElements: [ {
            nodeName: 'a',
            attributes: {
              href: isNotNull
            }
          } ]
        },
        'doc-index': {
          type: 'navigation',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'nav', 'section' ]
        },
        'doc-introduction': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-noteref': {
          type: 'link',
          attributes: {
            allowed: [ 'aria-expanded' ]
          },
          owned: null,
          namefrom: [ 'author', 'contents' ],
          context: null,
          unsupported: false,
          allowedElements: [ {
            nodeName: 'a',
            attributes: {
              href: isNotNull
            }
          } ]
        },
        'doc-notice': {
          type: 'note',
          attributes: {
            allowed: [ 'aria-expanded' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-pagebreak': {
          type: 'separator',
          attributes: {
            allowed: [ 'aria-expanded' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'hr' ]
        },
        'doc-pagelist': {
          type: 'navigation',
          attributes: {
            allowed: [ 'aria-expanded' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'nav', 'section' ]
        },
        'doc-part': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-preface': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-prologue': {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-pullquote': {
          type: 'none',
          attributes: {
            allowed: [ 'aria-expanded' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'aside', 'section' ]
        },
        'doc-qna': {
          type: 'section',
          attributes: {
            allowed: [ 'aria-expanded' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        'doc-subtitle': {
          type: 'sectionhead',
          attributes: {
            allowed: [ 'aria-expanded' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: {
            nodeName: [ 'h1', 'h2', 'h3', 'h4', 'h5', 'h6' ]
          }
        },
        'doc-tip': {
          type: 'note',
          attributes: {
            allowed: [ 'aria-expanded' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'aside' ]
        },
        'doc-toc': {
          type: 'navigation',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          namefrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'nav', 'section' ]
        },
        feed: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: {
            one: [ 'article' ]
          },
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'article', 'aside', 'section' ]
        },
        figure: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: null,
          implicit: [ 'figure' ],
          unsupported: false
        },
        form: {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'form' ],
          unsupported: false
        },
        grid: {
          type: 'composite',
          attributes: {
            allowed: [ 'aria-activedescendant', 'aria-expanded', 'aria-colcount', 'aria-level', 'aria-multiselectable', 'aria-readonly', 'aria-rowcount', 'aria-errormessage' ]
          },
          owned: {
            one: [ 'rowgroup', 'row' ]
          },
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'table' ],
          unsupported: false
        },
        gridcell: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-colindex', 'aria-colspan', 'aria-expanded', 'aria-rowindex', 'aria-rowspan', 'aria-selected', 'aria-readonly', 'aria-required', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: [ 'row' ],
          implicit: [ 'td', 'th' ],
          unsupported: false
        },
        group: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-activedescendant', 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'details', 'optgroup' ],
          unsupported: false,
          allowedElements: [ 'dl', 'figcaption', 'fieldset', 'figure', 'footer', 'header', 'ol', 'ul' ]
        },
        heading: {
          type: 'structure',
          attributes: {
            required: [ 'aria-level' ],
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: null,
          implicit: [ 'h1', 'h2', 'h3', 'h4', 'h5', 'h6' ],
          unsupported: false
        },
        img: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'img' ],
          unsupported: false,
          allowedElements: [ 'embed', 'iframe', 'object', 'svg' ]
        },
        input: {
          nameFrom: [ 'author' ],
          type: 'abstract',
          unsupported: false
        },
        landmark: {
          nameFrom: [ 'author' ],
          type: 'abstract',
          unsupported: false
        },
        link: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: null,
          implicit: [ 'a[href]', 'area[href]' ],
          unsupported: false,
          allowedElements: [ 'button', {
            nodeName: 'input',
            properties: {
              type: [ 'image', 'button' ]
            }
          } ]
        },
        list: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: {
            all: [ 'listitem' ]
          },
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'ol', 'ul', 'dl' ],
          unsupported: false
        },
        listbox: {
          type: 'composite',
          attributes: {
            allowed: [ 'aria-activedescendant', 'aria-multiselectable', 'aria-readonly', 'aria-required', 'aria-expanded', 'aria-orientation', 'aria-errormessage' ]
          },
          owned: {
            all: [ 'option' ]
          },
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'select' ],
          unsupported: false,
          allowedElements: [ 'ol', 'ul' ]
        },
        listitem: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-level', 'aria-posinset', 'aria-setsize', 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: [ 'list' ],
          implicit: [ 'li', 'dt' ],
          unsupported: false
        },
        log: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        main: {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'main' ],
          unsupported: false,
          allowedElements: [ 'article', 'section' ]
        },
        marquee: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        math: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'math' ],
          unsupported: false
        },
        menu: {
          type: 'composite',
          attributes: {
            allowed: [ 'aria-activedescendant', 'aria-expanded', 'aria-orientation', 'aria-errormessage' ]
          },
          owned: {
            one: [ 'menuitem', 'menuitemradio', 'menuitemcheckbox' ]
          },
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'menu[type="context"]' ],
          unsupported: false,
          allowedElements: [ 'ol', 'ul' ]
        },
        menubar: {
          type: 'composite',
          attributes: {
            allowed: [ 'aria-activedescendant', 'aria-expanded', 'aria-orientation', 'aria-errormessage' ]
          },
          owned: {
            one: [ 'menuitem', 'menuitemradio', 'menuitemcheckbox' ]
          },
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'ol', 'ul' ]
        },
        menuitem: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-posinset', 'aria-setsize', 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: [ 'menu', 'menubar' ],
          implicit: [ 'menuitem[type="command"]' ],
          unsupported: false,
          allowedElements: [ 'button', 'li', {
            nodeName: 'iput',
            properties: {
              type: [ 'image', 'button' ]
            }
          }, {
            nodeName: 'a',
            attributes: {
              href: isNotNull
            }
          } ]
        },
        menuitemcheckbox: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-checked', 'aria-posinset', 'aria-setsize', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: [ 'menu', 'menubar' ],
          implicit: [ 'menuitem[type="checkbox"]' ],
          unsupported: false,
          allowedElements: [ {
            nodeName: [ 'button', 'li' ]
          }, {
            nodeName: 'input',
            properties: {
              type: [ 'checkbox', 'image', 'button' ]
            }
          }, {
            nodeName: 'a',
            attributes: {
              href: isNotNull
            }
          } ]
        },
        menuitemradio: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-checked', 'aria-selected', 'aria-posinset', 'aria-setsize', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: [ 'menu', 'menubar' ],
          implicit: [ 'menuitem[type="radio"]' ],
          unsupported: false,
          allowedElements: [ {
            nodeName: [ 'button', 'li' ]
          }, {
            nodeName: 'input',
            properties: {
              type: [ 'image', 'button', 'radio' ]
            }
          }, {
            nodeName: 'a',
            attributes: {
              href: isNotNull
            }
          } ]
        },
        navigation: {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'nav' ],
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        none: {
          type: 'structure',
          attributes: null,
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ {
            nodeName: [ 'article', 'aside', 'dl', 'embed', 'figcaption', 'fieldset', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hr', 'iframe', 'li', 'ol', 'section', 'ul' ]
          }, {
            nodeName: 'img',
            attributes: {
              alt: isNotNull
            }
          } ]
        },
        note: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'aside' ]
        },
        option: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-selected', 'aria-posinset', 'aria-setsize', 'aria-checked', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: [ 'listbox' ],
          implicit: [ 'option' ],
          unsupported: false,
          allowedElements: [ {
            nodeName: [ 'button', 'li' ]
          }, {
            nodeName: 'input',
            properties: {
              type: [ 'checkbox', 'button' ]
            }
          }, {
            nodeName: 'a',
            attributes: {
              href: isNotNull
            }
          } ]
        },
        presentation: {
          type: 'structure',
          attributes: null,
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ {
            nodeName: [ 'article', 'aside', 'dl', 'embed', 'figcaption', 'fieldset', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hr', 'iframe', 'li', 'ol', 'section', 'ul' ]
          }, {
            nodeName: 'img',
            attributes: {
              alt: isNotNull
            }
          } ]
        },
        progressbar: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-valuetext', 'aria-valuenow', 'aria-valuemax', 'aria-valuemin', 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'progress' ],
          unsupported: false
        },
        radio: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-selected', 'aria-posinset', 'aria-setsize', 'aria-required', 'aria-errormessage', 'aria-checked' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: null,
          implicit: [ 'input[type="radio"]' ],
          unsupported: false,
          allowedElements: [ {
            nodeName: [ 'button', 'li' ]
          }, {
            nodeName: 'input',
            properties: {
              type: [ 'image', 'button' ]
            }
          } ]
        },
        radiogroup: {
          type: 'composite',
          attributes: {
            allowed: [ 'aria-activedescendant', 'aria-required', 'aria-expanded', 'aria-readonly', 'aria-errormessage', 'aria-orientation' ]
          },
          owned: {
            all: [ 'radio' ]
          },
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: {
            nodeName: [ 'ol', 'ul', 'fieldset' ]
          }
        },
        range: {
          nameFrom: [ 'author' ],
          type: 'abstract',
          unsupported: false
        },
        region: {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'section[aria-label]', 'section[aria-labelledby]', 'section[title]' ],
          unsupported: false,
          allowedElements: {
            nodeName: [ 'article', 'aside' ]
          }
        },
        roletype: {
          type: 'abstract',
          unsupported: false
        },
        row: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-activedescendant', 'aria-colindex', 'aria-expanded', 'aria-level', 'aria-selected', 'aria-rowindex', 'aria-errormessage' ]
          },
          owned: {
            one: [ 'cell', 'columnheader', 'rowheader', 'gridcell' ]
          },
          nameFrom: [ 'author', 'contents' ],
          context: [ 'rowgroup', 'grid', 'treegrid', 'table' ],
          implicit: [ 'tr' ],
          unsupported: false
        },
        rowgroup: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-activedescendant', 'aria-expanded', 'aria-errormessage' ]
          },
          owned: {
            all: [ 'row' ]
          },
          nameFrom: [ 'author', 'contents' ],
          context: [ 'grid', 'table', 'treegrid' ],
          implicit: [ 'tbody', 'thead', 'tfoot' ],
          unsupported: false
        },
        rowheader: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-colindex', 'aria-colspan', 'aria-expanded', 'aria-rowindex', 'aria-rowspan', 'aria-required', 'aria-readonly', 'aria-selected', 'aria-sort', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: [ 'row' ],
          implicit: [ 'th' ],
          unsupported: false
        },
        scrollbar: {
          type: 'widget',
          attributes: {
            required: [ 'aria-controls', 'aria-valuenow' ],
            allowed: [ 'aria-valuetext', 'aria-orientation', 'aria-errormessage', 'aria-valuemax', 'aria-valuemin' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false
        },
        search: {
          type: 'landmark',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: {
            nodeName: [ 'aside', 'form', 'section' ]
          }
        },
        searchbox: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-activedescendant', 'aria-autocomplete', 'aria-multiline', 'aria-readonly', 'aria-required', 'aria-placeholder', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'input[type="search"]' ],
          unsupported: false,
          allowedElements: {
            nodeName: 'input',
            properties: {
              type: 'text'
            }
          }
        },
        section: {
          nameFrom: [ 'author', 'contents' ],
          type: 'abstract',
          unsupported: false
        },
        sectionhead: {
          nameFrom: [ 'author', 'contents' ],
          type: 'abstract',
          unsupported: false
        },
        select: {
          nameFrom: [ 'author' ],
          type: 'abstract',
          unsupported: false
        },
        separator: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-orientation', 'aria-valuenow', 'aria-valuemax', 'aria-valuemin', 'aria-valuetext', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'hr' ],
          unsupported: false,
          allowedElements: [ 'li' ]
        },
        slider: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-valuetext', 'aria-orientation', 'aria-readonly', 'aria-errormessage', 'aria-valuemax', 'aria-valuemin' ],
            required: [ 'aria-valuenow' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'input[type="range"]' ],
          unsupported: false
        },
        spinbutton: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-valuetext', 'aria-required', 'aria-readonly', 'aria-errormessage', 'aria-valuemax', 'aria-valuemin' ],
            required: [ 'aria-valuenow' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'input[type="number"]' ],
          unsupported: false,
          allowedElements: {
            nodeName: 'input',
            properties: {
              type: [ 'text', 'tel' ]
            }
          }
        },
        status: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'output' ],
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        structure: {
          type: 'abstract',
          unsupported: false
        },
        switch: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-errormessage' ],
            required: [ 'aria-checked' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'button', {
            nodeName: 'input',
            properties: {
              type: [ 'checkbox', 'image', 'button' ]
            }
          }, {
            nodeName: 'a',
            attributes: {
              href: isNotNull
            }
          } ]
        },
        tab: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-selected', 'aria-expanded', 'aria-setsize', 'aria-posinset', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: [ 'tablist' ],
          unsupported: false,
          allowedElements: [ {
            nodeName: [ 'button', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'li' ]
          }, {
            nodeName: 'input',
            properties: {
              type: 'button'
            }
          }, {
            nodeName: 'a',
            attributes: {
              href: isNotNull
            }
          } ]
        },
        table: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-colcount', 'aria-rowcount', 'aria-errormessage' ]
          },
          owned: {
            one: [ 'rowgroup', 'row' ]
          },
          nameFrom: [ 'author', 'contents' ],
          context: null,
          implicit: [ 'table' ],
          unsupported: false
        },
        tablist: {
          type: 'composite',
          attributes: {
            allowed: [ 'aria-activedescendant', 'aria-expanded', 'aria-level', 'aria-multiselectable', 'aria-orientation', 'aria-errormessage' ]
          },
          owned: {
            all: [ 'tab' ]
          },
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'ol', 'ul' ]
        },
        tabpanel: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'section' ]
        },
        term: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: null,
          implicit: [ 'dt' ],
          unsupported: false
        },
        textbox: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-activedescendant', 'aria-autocomplete', 'aria-multiline', 'aria-readonly', 'aria-required', 'aria-placeholder', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'input[type="text"]', 'input[type="email"]', 'input[type="password"]', 'input[type="tel"]', 'input[type="url"]', 'input:not([type])', 'textarea' ],
          unsupported: false
        },
        timer: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false
        },
        toolbar: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-activedescendant', 'aria-expanded', 'aria-orientation', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author' ],
          context: null,
          implicit: [ 'menu[type="toolbar"]' ],
          unsupported: false,
          allowedElements: [ 'ol', 'ul' ]
        },
        tooltip: {
          type: 'structure',
          attributes: {
            allowed: [ 'aria-expanded', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: null,
          unsupported: false
        },
        tree: {
          type: 'composite',
          attributes: {
            allowed: [ 'aria-activedescendant', 'aria-multiselectable', 'aria-required', 'aria-expanded', 'aria-orientation', 'aria-errormessage' ]
          },
          owned: {
            all: [ 'treeitem' ]
          },
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false,
          allowedElements: [ 'ol', 'ul' ]
        },
        treegrid: {
          type: 'composite',
          attributes: {
            allowed: [ 'aria-activedescendant', 'aria-colcount', 'aria-expanded', 'aria-level', 'aria-multiselectable', 'aria-readonly', 'aria-required', 'aria-rowcount', 'aria-orientation', 'aria-errormessage' ]
          },
          owned: {
            one: [ 'rowgroup', 'row' ]
          },
          nameFrom: [ 'author' ],
          context: null,
          unsupported: false
        },
        treeitem: {
          type: 'widget',
          attributes: {
            allowed: [ 'aria-checked', 'aria-selected', 'aria-expanded', 'aria-level', 'aria-posinset', 'aria-setsize', 'aria-errormessage' ]
          },
          owned: null,
          nameFrom: [ 'author', 'contents' ],
          context: [ 'group', 'tree' ],
          unsupported: false,
          allowedElements: [ 'li', {
            nodeName: 'a',
            attributes: {
              href: isNotNull
            }
          } ]
        },
        widget: {
          type: 'abstract',
          unsupported: false
        },
        window: {
          nameFrom: [ 'author' ],
          type: 'abstract',
          unsupported: false
        }
      };
      lookupTable.implicitHtmlRole = _standards_implicit_html_roles__WEBPACK_IMPORTED_MODULE_0__['default'];
      lookupTable.elementsAllowedNoRole = [ {
        nodeName: [ 'base', 'body', 'caption', 'col', 'colgroup', 'datalist', 'dd', 'details', 'dt', 'head', 'html', 'keygen', 'label', 'legend', 'main', 'map', 'math', 'meta', 'meter', 'noscript', 'optgroup', 'param', 'picture', 'progress', 'script', 'source', 'style', 'template', 'textarea', 'title', 'track' ]
      }, {
        nodeName: 'area',
        attributes: {
          href: isNotNull
        }
      }, {
        nodeName: 'input',
        properties: {
          type: [ 'color', 'data', 'datatime', 'file', 'hidden', 'month', 'number', 'password', 'range', 'reset', 'submit', 'time', 'week' ]
        }
      }, {
        nodeName: 'link',
        attributes: {
          href: isNotNull
        }
      }, {
        nodeName: 'menu',
        attributes: {
          type: 'context'
        }
      }, {
        nodeName: 'menuitem',
        attributes: {
          type: [ 'command', 'checkbox', 'radio' ]
        }
      }, {
        nodeName: 'select',
        condition: function condition(vNode) {
          if (!(vNode instanceof axe.AbstractVirtualNode)) {
            vNode = axe.utils.getNodeFromTree(vNode);
          }
          return Number(vNode.attr('size')) > 1;
        },
        properties: {
          multiple: true
        }
      }, {
        nodeName: [ 'clippath', 'cursor', 'defs', 'desc', 'feblend', 'fecolormatrix', 'fecomponenttransfer', 'fecomposite', 'feconvolvematrix', 'fediffuselighting', 'fedisplacementmap', 'fedistantlight', 'fedropshadow', 'feflood', 'fefunca', 'fefuncb', 'fefuncg', 'fefuncr', 'fegaussianblur', 'feimage', 'femerge', 'femergenode', 'femorphology', 'feoffset', 'fepointlight', 'fespecularlighting', 'fespotlight', 'fetile', 'feturbulence', 'filter', 'hatch', 'hatchpath', 'lineargradient', 'marker', 'mask', 'meshgradient', 'meshpatch', 'meshrow', 'metadata', 'mpath', 'pattern', 'radialgradient', 'solidcolor', 'stop', 'switch', 'view' ]
      } ];
      lookupTable.elementsAllowedAnyRole = [ {
        nodeName: 'a',
        attributes: {
          href: isNull
        }
      }, {
        nodeName: 'img',
        attributes: {
          alt: isNull
        }
      }, {
        nodeName: [ 'abbr', 'address', 'canvas', 'div', 'p', 'pre', 'blockquote', 'ins', 'del', 'output', 'span', 'table', 'tbody', 'thead', 'tfoot', 'td', 'em', 'strong', 'small', 's', 'cite', 'q', 'dfn', 'abbr', 'time', 'code', 'var', 'samp', 'kbd', 'sub', 'sup', 'i', 'b', 'u', 'mark', 'ruby', 'rt', 'rp', 'bdi', 'bdo', 'br', 'wbr', 'th', 'tr' ]
      } ];
      lookupTable.evaluateRoleForElement = {
        A: function A(_ref24) {
          var node = _ref24.node, out = _ref24.out;
          if (node.namespaceURI === 'http://www.w3.org/2000/svg') {
            return true;
          }
          if (node.href.length) {
            return out;
          }
          return true;
        },
        AREA: function AREA(_ref25) {
          var node = _ref25.node;
          return !node.href;
        },
        BUTTON: function BUTTON(_ref26) {
          var node = _ref26.node, role = _ref26.role, out = _ref26.out;
          if (node.getAttribute('type') === 'menu') {
            return role === 'menuitem';
          }
          return out;
        },
        IMG: function IMG(_ref27) {
          var node = _ref27.node, role = _ref27.role, out = _ref27.out;
          switch (node.alt) {
           case null:
            return out;

           case '':
            return role === 'presentation' || role === 'none';

           default:
            return role !== 'presentation' && role !== 'none';
          }
        },
        INPUT: function INPUT(_ref28) {
          var node = _ref28.node, role = _ref28.role, out = _ref28.out;
          switch (node.type) {
           case 'button':
           case 'image':
            return out;

           case 'checkbox':
            if (role === 'button' && node.hasAttribute('aria-pressed')) {
              return true;
            }
            return out;

           case 'radio':
            return role === 'menuitemradio';

           case 'text':
            return role === 'combobox' || role === 'searchbox' || role === 'spinbutton';

           case 'tel':
            return role === 'combobox' || role === 'spinbutton';

           case 'url':
           case 'search':
           case 'email':
            return role === 'combobox';

           default:
            return false;
          }
        },
        LI: function LI(_ref29) {
          var node = _ref29.node, out = _ref29.out;
          var hasImplicitListitemRole = axe.utils.matchesSelector(node, 'ol li, ul li');
          if (hasImplicitListitemRole) {
            return out;
          }
          return true;
        },
        MENU: function MENU(_ref30) {
          var node = _ref30.node;
          if (node.getAttribute('type') === 'context') {
            return false;
          }
          return true;
        },
        OPTION: function OPTION(_ref31) {
          var node = _ref31.node;
          var withinOptionList = axe.utils.matchesSelector(node, 'select > option, datalist > option, optgroup > option');
          return !withinOptionList;
        },
        SELECT: function SELECT(_ref32) {
          var node = _ref32.node, role = _ref32.role;
          return !node.multiple && node.size <= 1 && role === 'menu';
        },
        SVG: function SVG(_ref33) {
          var node = _ref33.node, out = _ref33.out;
          if (node.parentNode && node.parentNode.namespaceURI === 'http://www.w3.org/2000/svg') {
            return true;
          }
          return out;
        }
      };
      lookupTable.rolesOfType = {
        widget: [ 'button', 'checkbox', 'dialog', 'gridcell', 'link', 'log', 'marquee', 'menuitem', 'menuitemcheckbox', 'menuitemradio', 'option', 'progressbar', 'radio', 'scrollbar', 'searchbox', 'slider', 'spinbutton', 'status', 'switch', 'tab', 'tabpanel', 'textbox', 'timer', 'tooltip', 'tree', 'treeitem' ]
      };
      __webpack_exports__['default'] = lookupTable;
    },
    './lib/commons/aria/named-from-contents.js': function libCommonsAriaNamedFromContentsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_role__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/get-role.js');
      var _standards__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/standards/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      function namedFromContents(vNode) {
        var _ref34 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, strict = _ref34.strict;
        vNode = vNode instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_3__['default'] ? vNode : Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getNodeFromTree'])(vNode);
        if (vNode.props.nodeType !== 1) {
          return false;
        }
        var role = Object(_get_role__WEBPACK_IMPORTED_MODULE_0__['default'])(vNode);
        var roleDef = _standards__WEBPACK_IMPORTED_MODULE_1__['default'].ariaRoles[role];
        if (roleDef && roleDef.nameFromContent) {
          return true;
        }
        if (strict) {
          return false;
        }
        return !roleDef || [ 'presentation', 'none' ].includes(role);
      }
      __webpack_exports__['default'] = namedFromContents;
    },
    './lib/commons/aria/required-attr.js': function libCommonsAriaRequiredAttrJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      function requiredAttr(role) {
        var roleDef = _standards__WEBPACK_IMPORTED_MODULE_0__['default'].ariaRoles[role];
        if (!roleDef || !Array.isArray(roleDef.requiredAttrs)) {
          return [];
        }
        return _toConsumableArray(roleDef.requiredAttrs);
      }
      __webpack_exports__['default'] = requiredAttr;
    },
    './lib/commons/aria/required-context.js': function libCommonsAriaRequiredContextJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      function requiredContext(role) {
        var roleDef = _standards__WEBPACK_IMPORTED_MODULE_0__['default'].ariaRoles[role];
        if (!roleDef || !Array.isArray(roleDef.requiredContext)) {
          return null;
        }
        return _toConsumableArray(roleDef.requiredContext);
      }
      __webpack_exports__['default'] = requiredContext;
    },
    './lib/commons/aria/required-owned.js': function libCommonsAriaRequiredOwnedJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      function requiredOwned(role) {
        var roleDef = _standards__WEBPACK_IMPORTED_MODULE_0__['default'].ariaRoles[role];
        if (!roleDef || !Array.isArray(roleDef.requiredOwned)) {
          return null;
        }
        return _toConsumableArray(roleDef.requiredOwned);
      }
      __webpack_exports__['default'] = requiredOwned;
    },
    './lib/commons/aria/validate-attr-value.js': function libCommonsAriaValidateAttrValueJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      var _dom_get_root_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/get-root-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function validateAttrValue(node, attr) {
        'use strict';
        var matches;
        var list;
        var value = node.getAttribute(attr);
        var attrInfo = _standards__WEBPACK_IMPORTED_MODULE_0__['default'].ariaAttrs[attr];
        var doc = Object(_dom_get_root_node__WEBPACK_IMPORTED_MODULE_1__['default'])(node);
        if (!attrInfo) {
          return true;
        }
        if (attrInfo.allowEmpty && (!value || value.trim() === '')) {
          return true;
        }
        switch (attrInfo.type) {
         case 'boolean':
          return [ 'true', 'false' ].includes(value.toLowerCase());

         case 'nmtoken':
          return typeof value === 'string' && attrInfo.values.includes(value.toLowerCase());

         case 'nmtokens':
          list = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['tokenList'])(value);
          return list.reduce(function(result, token) {
            return result && attrInfo.values.includes(token);
          }, list.length !== 0);

         case 'idref':
          return !!(value && doc.getElementById(value));

         case 'idrefs':
          list = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['tokenList'])(value);
          return list.some(function(token) {
            return doc.getElementById(token);
          });

         case 'string':
          return value.trim() !== '';

         case 'decimal':
          matches = value.match(/^[-+]?([0-9]*)\.?([0-9]*)$/);
          return !!(matches && (matches[1] || matches[2]));

         case 'int':
          return /^[-+]?[0-9]+$/.test(value);
        }
      }
      __webpack_exports__['default'] = validateAttrValue;
    },
    './lib/commons/aria/validate-attr.js': function libCommonsAriaValidateAttrJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      function validateAttr(att) {
        var attrDefinition = _standards__WEBPACK_IMPORTED_MODULE_0__['default'].ariaAttrs[att];
        return !!attrDefinition;
      }
      __webpack_exports__['default'] = validateAttr;
    },
    './lib/commons/color/center-point-of-rect.js': function libCommonsColorCenterPointOfRectJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function centerPointOfRect(rect) {
        if (rect.left > window.innerWidth) {
          return undefined;
        }
        if (rect.top > window.innerHeight) {
          return undefined;
        }
        var x = Math.min(Math.ceil(rect.left + rect.width / 2), window.innerWidth - 1);
        var y = Math.min(Math.ceil(rect.top + rect.height / 2), window.innerHeight - 1);
        return {
          x: x,
          y: y
        };
      }
      __webpack_exports__['default'] = centerPointOfRect;
    },
    './lib/commons/color/color.js': function libCommonsColorColorJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      function convertColorVal(colorFunc, value, index) {
        if (/%$/.test(value)) {
          if (index === 3) {
            return parseFloat(value) / 100;
          }
          return parseFloat(value) * 255 / 100;
        }
        if (colorFunc[index] === 'h') {
          if (/turn$/.test(value)) {
            return parseFloat(value) * 360;
          }
          if (/rad$/.test(value)) {
            return parseFloat(value) * 57.3;
          }
        }
        return parseFloat(value);
      }
      function hslToRgb(_ref35) {
        var _ref36 = _slicedToArray(_ref35, 4), hue = _ref36[0], saturation = _ref36[1], lightness = _ref36[2], alpha = _ref36[3];
        saturation /= 255;
        lightness /= 255;
        var high = (1 - Math.abs(2 * lightness - 1)) * saturation;
        var low = high * (1 - Math.abs(hue / 60 % 2 - 1));
        var base = lightness - high / 2;
        var colors;
        if (hue < 60) {
          colors = [ high, low, 0 ];
        } else if (hue < 120) {
          colors = [ low, high, 0 ];
        } else if (hue < 180) {
          colors = [ 0, high, low ];
        } else if (hue < 240) {
          colors = [ 0, low, high ];
        } else if (hue < 300) {
          colors = [ low, 0, high ];
        } else {
          colors = [ high, 0, low ];
        }
        return colors.map(function(color) {
          return Math.round((color + base) * 255);
        }).concat(alpha);
      }
      function Color(red, green, blue, alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.toHexString = function() {
          var redString = Math.round(this.red).toString(16);
          var greenString = Math.round(this.green).toString(16);
          var blueString = Math.round(this.blue).toString(16);
          return '#' + (this.red > 15.5 ? redString : '0' + redString) + (this.green > 15.5 ? greenString : '0' + greenString) + (this.blue > 15.5 ? blueString : '0' + blueString);
        };
        var hexRegex = /^#[0-9a-f]{3,8}$/i;
        var colorFnRegex = /^((?:rgb|hsl)a?)\s*\(([^\)]*)\)/i;
        this.parseString = function(colorString) {
          if (_standards__WEBPACK_IMPORTED_MODULE_0__['default'].cssColors[colorString] || colorString === 'transparent') {
            var _ref37 = _standards__WEBPACK_IMPORTED_MODULE_0__['default'].cssColors[colorString] || [ 0, 0, 0 ], _ref38 = _slicedToArray(_ref37, 3), _red = _ref38[0], _green = _ref38[1], _blue = _ref38[2];
            this.red = _red;
            this.green = _green;
            this.blue = _blue;
            this.alpha = colorString === 'transparent' ? 0 : 1;
            return;
          }
          if (colorString.match(colorFnRegex)) {
            this.parseColorFnString(colorString);
            return;
          }
          if (colorString.match(hexRegex)) {
            this.parseHexString(colorString);
            return;
          }
          throw new Error('Unable to parse color "'.concat(colorString, '"'));
        };
        this.parseRgbString = function(colorString) {
          if (colorString === 'transparent') {
            this.red = 0;
            this.green = 0;
            this.blue = 0;
            this.alpha = 0;
            return;
          }
          this.parseColorFnString(colorString);
        };
        this.parseHexString = function(colorString) {
          if (!colorString.match(hexRegex) || [ 6, 8 ].includes(colorString.length)) {
            return;
          }
          colorString = colorString.replace('#', '');
          if (colorString.length < 6) {
            var _colorString = colorString, _colorString2 = _slicedToArray(_colorString, 4), r = _colorString2[0], g = _colorString2[1], b = _colorString2[2], a = _colorString2[3];
            colorString = r + r + g + g + b + b;
            if (a) {
              colorString += a + a;
            }
          }
          var aRgbHex = colorString.match(/.{1,2}/g);
          this.red = parseInt(aRgbHex[0], 16);
          this.green = parseInt(aRgbHex[1], 16);
          this.blue = parseInt(aRgbHex[2], 16);
          if (aRgbHex[3]) {
            this.alpha = parseInt(aRgbHex[3], 16) / 255;
          } else {
            this.alpha = 1;
          }
        };
        this.parseColorFnString = function parseColorFnString(colorString) {
          var _ref39 = colorString.match(colorFnRegex) || [], _ref40 = _slicedToArray(_ref39, 3), colorFunc = _ref40[1], colorValStr = _ref40[2];
          if (!colorFunc || !colorValStr) {
            return;
          }
          var colorVals = colorValStr.split(/\s*[,\/\s]\s*/).map(function(str) {
            return str.replace(',', '').trim();
          }).filter(function(str) {
            return str !== '';
          });
          var colorNums = colorVals.map(function(val, index) {
            return convertColorVal(colorFunc, val, index);
          });
          if (colorFunc.substr(0, 3) === 'hsl') {
            colorNums = hslToRgb(colorNums);
          }
          this.red = colorNums[0];
          this.green = colorNums[1];
          this.blue = colorNums[2];
          this.alpha = typeof colorNums[3] === 'number' ? colorNums[3] : 1;
        };
        this.getRelativeLuminance = function() {
          var rSRGB = this.red / 255;
          var gSRGB = this.green / 255;
          var bSRGB = this.blue / 255;
          var r = rSRGB <= .03928 ? rSRGB / 12.92 : Math.pow((rSRGB + .055) / 1.055, 2.4);
          var g = gSRGB <= .03928 ? gSRGB / 12.92 : Math.pow((gSRGB + .055) / 1.055, 2.4);
          var b = bSRGB <= .03928 ? bSRGB / 12.92 : Math.pow((bSRGB + .055) / 1.055, 2.4);
          return .2126 * r + .7152 * g + .0722 * b;
        };
      }
      __webpack_exports__['default'] = Color;
    },
    './lib/commons/color/element-has-image.js': function libCommonsColorElementHasImageJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _incomplete_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/color/incomplete-data.js');
      function elementHasImage(elm, style) {
        var graphicNodes = [ 'IMG', 'CANVAS', 'OBJECT', 'IFRAME', 'VIDEO', 'SVG' ];
        var nodeName = elm.nodeName.toUpperCase();
        if (graphicNodes.includes(nodeName)) {
          _incomplete_data__WEBPACK_IMPORTED_MODULE_0__['default'].set('bgColor', 'imgNode');
          return true;
        }
        style = style || window.getComputedStyle(elm);
        var bgImageStyle = style.getPropertyValue('background-image');
        var hasBgImage = bgImageStyle !== 'none';
        if (hasBgImage) {
          var hasGradient = /gradient/.test(bgImageStyle);
          _incomplete_data__WEBPACK_IMPORTED_MODULE_0__['default'].set('bgColor', hasGradient ? 'bgGradient' : 'bgImage');
        }
        return hasBgImage;
      }
      __webpack_exports__['default'] = elementHasImage;
    },
    './lib/commons/color/element-is-distinct.js': function libCommonsColorElementIsDistinctJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/color/color.js');
      function _getFonts(style) {
        return style.getPropertyValue('font-family').split(/[,;]/g).map(function(font) {
          return font.trim().toLowerCase();
        });
      }
      function elementIsDistinct(node, ancestorNode) {
        var nodeStyle = window.getComputedStyle(node);
        if (nodeStyle.getPropertyValue('background-image') !== 'none') {
          return true;
        }
        var hasBorder = [ 'border-bottom', 'border-top', 'outline' ].reduce(function(result, edge) {
          var borderClr = new _color__WEBPACK_IMPORTED_MODULE_0__['default']();
          borderClr.parseString(nodeStyle.getPropertyValue(edge + '-color'));
          return result || nodeStyle.getPropertyValue(edge + '-style') !== 'none' && parseFloat(nodeStyle.getPropertyValue(edge + '-width')) > 0 && borderClr.alpha !== 0;
        }, false);
        if (hasBorder) {
          return true;
        }
        var parentStyle = window.getComputedStyle(ancestorNode);
        if (_getFonts(nodeStyle)[0] !== _getFonts(parentStyle)[0]) {
          return true;
        }
        var hasStyle = [ 'text-decoration-line', 'text-decoration-style', 'font-weight', 'font-style', 'font-size' ].reduce(function(result, cssProp) {
          return result || nodeStyle.getPropertyValue(cssProp) !== parentStyle.getPropertyValue(cssProp);
        }, false);
        var tDec = nodeStyle.getPropertyValue('text-decoration');
        if (tDec.split(' ').length < 3) {
          hasStyle = hasStyle || tDec !== parentStyle.getPropertyValue('text-decoration');
        }
        return hasStyle;
      }
      __webpack_exports__['default'] = elementIsDistinct;
    },
    './lib/commons/color/filtered-rect-stack.js': function libCommonsColorFilteredRectStackJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_rect_stack__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/color/get-rect-stack.js');
      var _incomplete_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/color/incomplete-data.js');
      function filteredRectStack(elm) {
        var rectStack = Object(_get_rect_stack__WEBPACK_IMPORTED_MODULE_0__['default'])(elm);
        if (rectStack && rectStack.length === 1) {
          return rectStack[0];
        }
        if (rectStack && rectStack.length > 1) {
          var boundingStack = rectStack.shift();
          var isSame;
          rectStack.forEach(function(rectList, index) {
            if (index === 0) {
              return;
            }
            var rectA = rectStack[index - 1], rectB = rectStack[index];
            isSame = rectA.every(function(element, elementIndex) {
              return element === rectB[elementIndex];
            }) || boundingStack.includes(elm);
          });
          if (!isSame) {
            _incomplete_data__WEBPACK_IMPORTED_MODULE_1__['default'].set('bgColor', 'elmPartiallyObscuring');
            return null;
          }
          return rectStack[0];
        }
        _incomplete_data__WEBPACK_IMPORTED_MODULE_1__['default'].set('bgColor', 'outsideViewport');
        return null;
      }
      __webpack_exports__['default'] = filteredRectStack;
    },
    './lib/commons/color/flatten-colors.js': function libCommonsColorFlattenColorsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/color/color.js');
      function flattenColors(fgColor, bgColor) {
        var alpha = fgColor.alpha;
        var r = (1 - alpha) * bgColor.red + alpha * fgColor.red;
        var g = (1 - alpha) * bgColor.green + alpha * fgColor.green;
        var b = (1 - alpha) * bgColor.blue + alpha * fgColor.blue;
        var a = fgColor.alpha + bgColor.alpha * (1 - fgColor.alpha);
        return new _color__WEBPACK_IMPORTED_MODULE_0__['default'](r, g, b, a);
      }
      __webpack_exports__['default'] = flattenColors;
    },
    './lib/commons/color/get-background-color.js': function libCommonsColorGetBackgroundColorJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _incomplete_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/color/incomplete-data.js');
      var _get_background_stack__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/color/get-background-stack.js');
      var _get_own_background_color__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/color/get-own-background-color.js');
      var _element_has_image__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/color/element-has-image.js');
      var _color__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/color/color.js');
      var _flatten_colors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/color/flatten-colors.js');
      var _get_text_shadow_colors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/commons/color/get-text-shadow-colors.js');
      var _dom_visually_contains__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/commons/dom/visually-contains.js');
      function elmPartiallyObscured(elm, bgElm, bgColor) {
        var obscured = elm !== bgElm && !Object(_dom_visually_contains__WEBPACK_IMPORTED_MODULE_7__['default'])(elm, bgElm) && bgColor.alpha !== 0;
        if (obscured) {
          _incomplete_data__WEBPACK_IMPORTED_MODULE_0__['default'].set('bgColor', 'elmPartiallyObscured');
        }
        return obscured;
      }
      function getBackgroundColor(elm) {
        var bgElms = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        var bgColors = Object(_get_text_shadow_colors__WEBPACK_IMPORTED_MODULE_6__['default'])(elm);
        var elmStack = Object(_get_background_stack__WEBPACK_IMPORTED_MODULE_1__['default'])(elm);
        (elmStack || []).some(function(bgElm) {
          var bgElmStyle = window.getComputedStyle(bgElm);
          var bgColor = Object(_get_own_background_color__WEBPACK_IMPORTED_MODULE_2__['default'])(bgElmStyle);
          if (elmPartiallyObscured(elm, bgElm, bgColor) || Object(_element_has_image__WEBPACK_IMPORTED_MODULE_3__['default'])(bgElm, bgElmStyle)) {
            bgColors = null;
            bgElms.push(bgElm);
            return true;
          }
          if (bgColor.alpha !== 0) {
            bgElms.push(bgElm);
            bgColors.push(bgColor);
            return bgColor.alpha === 1;
          } else {
            return false;
          }
        });
        if (bgColors === null || elmStack === null) {
          return null;
        }
        bgColors.push(new _color__WEBPACK_IMPORTED_MODULE_4__['default'](255, 255, 255, 1));
        var colors = bgColors.reduce(_flatten_colors__WEBPACK_IMPORTED_MODULE_5__['default']);
        return colors;
      }
      __webpack_exports__['default'] = getBackgroundColor;
    },
    './lib/commons/color/get-background-stack.js': function libCommonsColorGetBackgroundStackJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _filtered_rect_stack__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/color/filtered-rect-stack.js');
      var _element_has_image__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/color/element-has-image.js');
      var _get_own_background_color__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/color/get-own-background-color.js');
      var _incomplete_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/color/incomplete-data.js');
      var _dom_shadow_elements_from_point__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/dom/shadow-elements-from-point.js');
      var _dom_reduce_to_elements_below_floating__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/dom/reduce-to-elements-below-floating.js');
      function contentOverlapping(targetElement, bgNode) {
        var targetRect = targetElement.getClientRects()[0];
        var obscuringElements = Object(_dom_shadow_elements_from_point__WEBPACK_IMPORTED_MODULE_4__['default'])(targetRect.left, targetRect.top);
        if (obscuringElements) {
          for (var i = 0; i < obscuringElements.length; i++) {
            if (obscuringElements[i] !== targetElement && obscuringElements[i] === bgNode) {
              return true;
            }
          }
        }
        return false;
      }
      function calculateObscuringElement(elmIndex, elmStack, originalElm) {
        if (elmIndex > 0) {
          for (var i = elmIndex - 1; i >= 0; i--) {
            var bgElm = elmStack[i];
            if (contentOverlapping(originalElm, bgElm)) {
              return true;
            } else {
              elmStack.splice(i, 1);
            }
          }
        }
        return false;
      }
      function sortPageBackground(elmStack) {
        var bodyIndex = elmStack.indexOf(document.body);
        var bgNodes = elmStack;
        var sortBodyElement = bodyIndex > 1 || bodyIndex === -1;
        if (sortBodyElement && !Object(_element_has_image__WEBPACK_IMPORTED_MODULE_1__['default'])(document.documentElement) && Object(_get_own_background_color__WEBPACK_IMPORTED_MODULE_2__['default'])(window.getComputedStyle(document.documentElement)).alpha === 0) {
          if (bodyIndex > 1) {
            bgNodes.splice(bodyIndex, 1);
          }
          bgNodes.splice(elmStack.indexOf(document.documentElement), 1);
          bgNodes.push(document.body);
        }
        return bgNodes;
      }
      function getBackgroundStack(elm) {
        var elmStack = Object(_filtered_rect_stack__WEBPACK_IMPORTED_MODULE_0__['default'])(elm);
        if (elmStack === null) {
          return null;
        }
        elmStack = Object(_dom_reduce_to_elements_below_floating__WEBPACK_IMPORTED_MODULE_5__['default'])(elmStack, elm);
        elmStack = sortPageBackground(elmStack);
        var elmIndex = elmStack.indexOf(elm);
        if (calculateObscuringElement(elmIndex, elmStack, elm)) {
          _incomplete_data__WEBPACK_IMPORTED_MODULE_3__['default'].set('bgColor', 'bgOverlap');
          return null;
        }
        return elmIndex !== -1 ? elmStack : null;
      }
      __webpack_exports__['default'] = getBackgroundStack;
    },
    './lib/commons/color/get-contrast.js': function libCommonsColorGetContrastJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _flatten_colors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/color/flatten-colors.js');
      function getContrast(bgColor, fgColor) {
        if (!fgColor || !bgColor) {
          return null;
        }
        if (fgColor.alpha < 1) {
          fgColor = Object(_flatten_colors__WEBPACK_IMPORTED_MODULE_0__['default'])(fgColor, bgColor);
        }
        var bL = bgColor.getRelativeLuminance();
        var fL = fgColor.getRelativeLuminance();
        return (Math.max(fL, bL) + .05) / (Math.min(fL, bL) + .05);
      }
      __webpack_exports__['default'] = getContrast;
    },
    './lib/commons/color/get-foreground-color.js': function libCommonsColorGetForegroundColorJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/color/color.js');
      var _get_background_color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/color/get-background-color.js');
      var _incomplete_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/color/incomplete-data.js');
      var _flatten_colors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/color/flatten-colors.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/core/utils/index.js');
      function getOpacity(node) {
        if (!node) {
          return 1;
        }
        var vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_4__['getNodeFromTree'])(node);
        if (vNode && vNode._opacity !== undefined && vNode._opacity !== null) {
          return vNode._opacity;
        }
        var nodeStyle = window.getComputedStyle(node);
        var opacity = nodeStyle.getPropertyValue('opacity');
        var finalOpacity = opacity * getOpacity(node.parentElement);
        if (vNode) {
          vNode._opacity = finalOpacity;
        }
        return finalOpacity;
      }
      function getForegroundColor(node, _, bgColor) {
        var nodeStyle = window.getComputedStyle(node);
        var fgColor = new _color__WEBPACK_IMPORTED_MODULE_0__['default']();
        fgColor.parseString(nodeStyle.getPropertyValue('color'));
        var opacity = getOpacity(node);
        fgColor.alpha = fgColor.alpha * opacity;
        if (fgColor.alpha === 1) {
          return fgColor;
        }
        if (!bgColor) {
          bgColor = Object(_get_background_color__WEBPACK_IMPORTED_MODULE_1__['default'])(node, []);
        }
        if (bgColor === null) {
          var reason = _incomplete_data__WEBPACK_IMPORTED_MODULE_2__['default'].get('bgColor');
          _incomplete_data__WEBPACK_IMPORTED_MODULE_2__['default'].set('fgColor', reason);
          return null;
        }
        return Object(_flatten_colors__WEBPACK_IMPORTED_MODULE_3__['default'])(fgColor, bgColor);
      }
      __webpack_exports__['default'] = getForegroundColor;
    },
    './lib/commons/color/get-own-background-color.js': function libCommonsColorGetOwnBackgroundColorJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/color/color.js');
      function getOwnBackgroundColor(elmStyle) {
        var bgColor = new _color__WEBPACK_IMPORTED_MODULE_0__['default']();
        bgColor.parseString(elmStyle.getPropertyValue('background-color'));
        if (bgColor.alpha !== 0) {
          var opacity = elmStyle.getPropertyValue('opacity');
          bgColor.alpha = bgColor.alpha * opacity;
        }
        return bgColor;
      }
      __webpack_exports__['default'] = getOwnBackgroundColor;
    },
    './lib/commons/color/get-rect-stack.js': function libCommonsColorGetRectStackJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _dom_get_element_stack__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/get-element-stack.js');
      var _dom_get_text_element_stack__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/get-text-element-stack.js');
      function getRectStack(elm) {
        var boundingStack = Object(_dom_get_element_stack__WEBPACK_IMPORTED_MODULE_0__['default'])(elm);
        var filteredArr = Object(_dom_get_text_element_stack__WEBPACK_IMPORTED_MODULE_1__['default'])(elm);
        if (!filteredArr || filteredArr.length <= 1) {
          return [ boundingStack ];
        }
        if (filteredArr.some(function(stack) {
          return stack === undefined;
        })) {
          return null;
        }
        filteredArr.splice(0, 0, boundingStack);
        return filteredArr;
      }
      __webpack_exports__['default'] = getRectStack;
    },
    './lib/commons/color/get-text-shadow-colors.js': function libCommonsColorGetTextShadowColorsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/color/color.js');
      var _core_utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/assert.js');
      function getTextShadowColors(node) {
        var style = window.getComputedStyle(node);
        var textShadow = style.getPropertyValue('text-shadow');
        if (textShadow === 'none') {
          return [];
        }
        var shadows = parseTextShadows(textShadow);
        return shadows.map(function(_ref41) {
          var colorStr = _ref41.colorStr, pixels = _ref41.pixels;
          colorStr = colorStr || style.getPropertyValue('color');
          var _pixels = _slicedToArray(pixels, 3), offsetY = _pixels[0], offsetX = _pixels[1], _pixels$ = _pixels[2], blurRadius = _pixels$ === void 0 ? 0 : _pixels$;
          return textShadowColor({
            colorStr: colorStr,
            offsetY: offsetY,
            offsetX: offsetX,
            blurRadius: blurRadius
          });
        });
      }
      function parseTextShadows(textShadow) {
        var current = {
          pixels: []
        };
        var str = textShadow.trim();
        var shadows = [ current ];
        if (!str) {
          return [];
        }
        while (str) {
          var colorMatch = str.match(/^rgba?\([0-9,.\s]+\)/i) || str.match(/^[a-z]+/i) || str.match(/^#[0-9a-f]+/i);
          var pixelMatch = str.match(/^([0-9.-]+)px/i) || str.match(/^(0)/);
          if (colorMatch) {
            Object(_core_utils_assert__WEBPACK_IMPORTED_MODULE_1__['default'])(!current.colorStr, 'Multiple colors identified in text-shadow: '.concat(textShadow));
            str = str.replace(colorMatch[0], '').trim();
            current.colorStr = colorMatch[0];
          } else if (pixelMatch) {
            Object(_core_utils_assert__WEBPACK_IMPORTED_MODULE_1__['default'])(current.pixels.length < 3, 'Too many pixel units in text-shadow: '.concat(textShadow));
            str = str.replace(pixelMatch[0], '').trim();
            var pixelUnit = parseFloat((pixelMatch[1][0] === '.' ? '0' : '') + pixelMatch[1]);
            current.pixels.push(pixelUnit);
          } else if (str[0] === ',') {
            Object(_core_utils_assert__WEBPACK_IMPORTED_MODULE_1__['default'])(current.pixels.length >= 2, 'Missing pixel value in text-shadow: '.concat(textShadow));
            current = {
              pixels: []
            };
            shadows.push(current);
            str = str.substr(1).trim();
          } else {
            throw new Error('Unable to process text-shadows: '.concat(textShadow));
          }
        }
        return shadows;
      }
      function textShadowColor(_ref42) {
        var colorStr = _ref42.colorStr, offsetX = _ref42.offsetX, offsetY = _ref42.offsetY, blurRadius = _ref42.blurRadius;
        if (offsetX > blurRadius || offsetY > blurRadius) {
          return new _color__WEBPACK_IMPORTED_MODULE_0__['default'](0, 0, 0, 0);
        }
        var shadowColor = new _color__WEBPACK_IMPORTED_MODULE_0__['default']();
        shadowColor.parseString(colorStr);
        shadowColor.alpha *= blurRadiusToAlpha(blurRadius);
        return shadowColor;
      }
      function blurRadiusToAlpha(blurRadius) {
        return 3.7 / (blurRadius + 8);
      }
      __webpack_exports__['default'] = getTextShadowColors;
    },
    './lib/commons/color/has-valid-contrast-ratio.js': function libCommonsColorHasValidContrastRatioJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_contrast__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/color/get-contrast.js');
      function hasValidContrastRatio(bg, fg, fontSize, isBold) {
        var contrast = Object(_get_contrast__WEBPACK_IMPORTED_MODULE_0__['default'])(bg, fg);
        var isSmallFont = isBold && Math.ceil(fontSize * 72) / 96 < 14 || !isBold && Math.ceil(fontSize * 72) / 96 < 18;
        var expectedContrastRatio = isSmallFont ? 4.5 : 3;
        return {
          isValid: contrast > expectedContrastRatio,
          contrastRatio: contrast,
          expectedContrastRatio: expectedContrastRatio
        };
      }
      __webpack_exports__['default'] = hasValidContrastRatio;
    },
    './lib/commons/color/incomplete-data.js': function libCommonsColorIncompleteDataJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var data = {};
      var incompleteData = {
        set: function set(key, reason) {
          if (typeof key !== 'string') {
            throw new Error('Incomplete data: key must be a string');
          }
          if (reason) {
            data[key] = reason;
          }
          return data[key];
        },
        get: function get(key) {
          return data[key];
        },
        clear: function clear() {
          data = {};
        }
      };
      __webpack_exports__['default'] = incompleteData;
    },
    './lib/commons/color/index.js': function libCommonsColorIndexJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _center_point_of_rect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/color/center-point-of-rect.js');
      __webpack_require__.d(__webpack_exports__, 'centerPointOfRect', function() {
        return _center_point_of_rect__WEBPACK_IMPORTED_MODULE_0__['default'];
      });
      var _color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/color/color.js');
      __webpack_require__.d(__webpack_exports__, 'Color', function() {
        return _color__WEBPACK_IMPORTED_MODULE_1__['default'];
      });
      var _element_has_image__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/color/element-has-image.js');
      __webpack_require__.d(__webpack_exports__, 'elementHasImage', function() {
        return _element_has_image__WEBPACK_IMPORTED_MODULE_2__['default'];
      });
      var _element_is_distinct__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/color/element-is-distinct.js');
      __webpack_require__.d(__webpack_exports__, 'elementIsDistinct', function() {
        return _element_is_distinct__WEBPACK_IMPORTED_MODULE_3__['default'];
      });
      var _filtered_rect_stack__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/color/filtered-rect-stack.js');
      __webpack_require__.d(__webpack_exports__, 'filteredRectStack', function() {
        return _filtered_rect_stack__WEBPACK_IMPORTED_MODULE_4__['default'];
      });
      var _flatten_colors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/color/flatten-colors.js');
      __webpack_require__.d(__webpack_exports__, 'flattenColors', function() {
        return _flatten_colors__WEBPACK_IMPORTED_MODULE_5__['default'];
      });
      var _get_background_color__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/commons/color/get-background-color.js');
      __webpack_require__.d(__webpack_exports__, 'getBackgroundColor', function() {
        return _get_background_color__WEBPACK_IMPORTED_MODULE_6__['default'];
      });
      var _get_background_stack__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/commons/color/get-background-stack.js');
      __webpack_require__.d(__webpack_exports__, 'getBackgroundStack', function() {
        return _get_background_stack__WEBPACK_IMPORTED_MODULE_7__['default'];
      });
      var _get_contrast__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__('./lib/commons/color/get-contrast.js');
      __webpack_require__.d(__webpack_exports__, 'getContrast', function() {
        return _get_contrast__WEBPACK_IMPORTED_MODULE_8__['default'];
      });
      var _get_foreground_color__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__('./lib/commons/color/get-foreground-color.js');
      __webpack_require__.d(__webpack_exports__, 'getForegroundColor', function() {
        return _get_foreground_color__WEBPACK_IMPORTED_MODULE_9__['default'];
      });
      var _get_own_background_color__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__('./lib/commons/color/get-own-background-color.js');
      __webpack_require__.d(__webpack_exports__, 'getOwnBackgroundColor', function() {
        return _get_own_background_color__WEBPACK_IMPORTED_MODULE_10__['default'];
      });
      var _get_rect_stack__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__('./lib/commons/color/get-rect-stack.js');
      __webpack_require__.d(__webpack_exports__, 'getRectStack', function() {
        return _get_rect_stack__WEBPACK_IMPORTED_MODULE_11__['default'];
      });
      var _has_valid_contrast_ratio__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__('./lib/commons/color/has-valid-contrast-ratio.js');
      __webpack_require__.d(__webpack_exports__, 'hasValidContrastRatio', function() {
        return _has_valid_contrast_ratio__WEBPACK_IMPORTED_MODULE_12__['default'];
      });
      var _incomplete_data__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__('./lib/commons/color/incomplete-data.js');
      __webpack_require__.d(__webpack_exports__, 'incompleteData', function() {
        return _incomplete_data__WEBPACK_IMPORTED_MODULE_13__['default'];
      });
      var _get_text_shadow_colors__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__('./lib/commons/color/get-text-shadow-colors.js');
      __webpack_require__.d(__webpack_exports__, 'getTextShadowColors', function() {
        return _get_text_shadow_colors__WEBPACK_IMPORTED_MODULE_14__['default'];
      });
    },
    './lib/commons/dom/find-elms-in-context.js': function libCommonsDomFindElmsInContextJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_root_node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/get-root-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function findElmsInContext(_ref43) {
        var context = _ref43.context, value = _ref43.value, attr = _ref43.attr, _ref43$elm = _ref43.elm, elm = _ref43$elm === void 0 ? '' : _ref43$elm;
        var root;
        var escapedValue = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['escapeSelector'])(value);
        if (context.nodeType === 9 || context.nodeType === 11) {
          root = context;
        } else {
          root = Object(_get_root_node__WEBPACK_IMPORTED_MODULE_0__['default'])(context);
        }
        return Array.from(root.querySelectorAll(elm + '[' + attr + '=' + escapedValue + ']'));
      }
      __webpack_exports__['default'] = findElmsInContext;
    },
    './lib/commons/dom/find-up-virtual.js': function libCommonsDomFindUpVirtualJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function findUpVirtual(element, target) {
        var parent;
        parent = element.actualNode;
        if (!element.shadowId && typeof element.actualNode.closest === 'function') {
          var match = element.actualNode.closest(target);
          if (match) {
            return match;
          }
          return null;
        }
        do {
          parent = parent.assignedSlot ? parent.assignedSlot : parent.parentNode;
          if (parent && parent.nodeType === 11) {
            parent = parent.host;
          }
        } while (parent && !Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['matchesSelector'])(parent, target) && parent !== document.documentElement);
        if (!parent) {
          return null;
        }
        if (!Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['matchesSelector'])(parent, target)) {
          return null;
        }
        return parent;
      }
      __webpack_exports__['default'] = findUpVirtual;
    },
    './lib/commons/dom/find-up.js': function libCommonsDomFindUpJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _find_up_virtual__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/find-up-virtual.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function findUp(element, target) {
        return Object(_find_up_virtual__WEBPACK_IMPORTED_MODULE_0__['default'])(Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeFromTree'])(element), target);
      }
      __webpack_exports__['default'] = findUp;
    },
    './lib/commons/dom/focus-disabled.js': function libCommonsDomFocusDisabledJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      var _is_hidden_with_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/dom/is-hidden-with-css.js');
      function focusDisabled(el) {
        var vNode = el instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_0__['default'] ? el : Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeFromTree'])(el);
        if (vNode.hasAttr('disabled')) {
          return true;
        }
        if (vNode.props.nodeName !== 'area') {
          if (!vNode.actualNode) {
            return false;
          }
          return Object(_is_hidden_with_css__WEBPACK_IMPORTED_MODULE_2__['default'])(vNode.actualNode);
        }
        return false;
      }
      __webpack_exports__['default'] = focusDisabled;
    },
    './lib/commons/dom/get-composed-parent.js': function libCommonsDomGetComposedParentJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getComposedParent(element) {
        if (element.assignedSlot) {
          return getComposedParent(element.assignedSlot);
        } else if (element.parentNode) {
          var parentNode = element.parentNode;
          if (parentNode.nodeType === 1) {
            return parentNode;
          } else if (parentNode.host) {
            return parentNode.host;
          }
        }
        return null;
      }
      __webpack_exports__['default'] = getComposedParent;
    },
    './lib/commons/dom/get-element-by-reference.js': function libCommonsDomGetElementByReferenceJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getElementByReference(node, attr) {
        var fragment = node.getAttribute(attr);
        if (!fragment) {
          return null;
        }
        if (fragment.charAt(0) === '#') {
          fragment = decodeURIComponent(fragment.substring(1));
        } else if (fragment.substr(0, 2) === '/#') {
          fragment = decodeURIComponent(fragment.substring(2));
        }
        var candidate = document.getElementById(fragment);
        if (candidate) {
          return candidate;
        }
        candidate = document.getElementsByName(fragment);
        if (candidate.length) {
          return candidate[0];
        }
        return null;
      }
      __webpack_exports__['default'] = getElementByReference;
    },
    './lib/commons/dom/get-element-coordinates.js': function libCommonsDomGetElementCoordinatesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_scroll_offset__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/get-scroll-offset.js');
      function getElementCoordinates(element) {
        'use strict';
        var scrollOffset = Object(_get_scroll_offset__WEBPACK_IMPORTED_MODULE_0__['default'])(document), xOffset = scrollOffset.left, yOffset = scrollOffset.top, coords = element.getBoundingClientRect();
        return {
          top: coords.top + yOffset,
          right: coords.right + xOffset,
          bottom: coords.bottom + yOffset,
          left: coords.left + xOffset,
          width: coords.right - coords.left,
          height: coords.bottom - coords.top
        };
      }
      __webpack_exports__['default'] = getElementCoordinates;
    },
    './lib/commons/dom/get-element-stack.js': function libCommonsDomGetElementStackJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_rect_stack__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/get-rect-stack.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      var _core_base_cache__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/base/cache.js');
      function getElementStack(node) {
        if (!_core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].get('gridCreated')) {
          Object(_get_rect_stack__WEBPACK_IMPORTED_MODULE_0__['createGrid'])();
          _core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].set('gridCreated', true);
        }
        var vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeFromTree'])(node);
        var grid = vNode._grid;
        if (!grid) {
          return [];
        }
        return Object(_get_rect_stack__WEBPACK_IMPORTED_MODULE_0__['getRectStack'])(grid, vNode.boundingClientRect);
      }
      __webpack_exports__['default'] = getElementStack;
    },
    './lib/commons/dom/get-rect-stack.js': function libCommonsDomGetRectStackJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'createGrid', function() {
        return createGrid;
      });
      __webpack_require__.d(__webpack_exports__, 'getRectStack', function() {
        return getRectStack;
      });
      var _is_visible__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/is-visible.js');
      var _core_base_virtual_node_virtual_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/virtual-node/virtual-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      var gridSize = 200;
      function isStackingContext(vNode, parentVNode) {
        var position = vNode.getComputedStylePropertyValue('position');
        var zIndex = vNode.getComputedStylePropertyValue('z-index');
        if (position === 'fixed' || position === 'sticky') {
          return true;
        }
        if (zIndex !== 'auto' && position !== 'static') {
          return true;
        }
        if (vNode.getComputedStylePropertyValue('opacity') !== '1') {
          return true;
        }
        var transform = vNode.getComputedStylePropertyValue('-webkit-transform') || vNode.getComputedStylePropertyValue('-ms-transform') || vNode.getComputedStylePropertyValue('transform') || 'none';
        if (transform !== 'none') {
          return true;
        }
        var mixBlendMode = vNode.getComputedStylePropertyValue('mix-blend-mode');
        if (mixBlendMode && mixBlendMode !== 'normal') {
          return true;
        }
        var filter = vNode.getComputedStylePropertyValue('filter');
        if (filter && filter !== 'none') {
          return true;
        }
        var perspective = vNode.getComputedStylePropertyValue('perspective');
        if (perspective && perspective !== 'none') {
          return true;
        }
        var clipPath = vNode.getComputedStylePropertyValue('clip-path');
        if (clipPath && clipPath !== 'none') {
          return true;
        }
        var mask = vNode.getComputedStylePropertyValue('-webkit-mask') || vNode.getComputedStylePropertyValue('mask') || 'none';
        if (mask !== 'none') {
          return true;
        }
        var maskImage = vNode.getComputedStylePropertyValue('-webkit-mask-image') || vNode.getComputedStylePropertyValue('mask-image') || 'none';
        if (maskImage !== 'none') {
          return true;
        }
        var maskBorder = vNode.getComputedStylePropertyValue('-webkit-mask-border') || vNode.getComputedStylePropertyValue('mask-border') || 'none';
        if (maskBorder !== 'none') {
          return true;
        }
        if (vNode.getComputedStylePropertyValue('isolation') === 'isolate') {
          return true;
        }
        var willChange = vNode.getComputedStylePropertyValue('will-change');
        if (willChange === 'transform' || willChange === 'opacity') {
          return true;
        }
        if (vNode.getComputedStylePropertyValue('-webkit-overflow-scrolling') === 'touch') {
          return true;
        }
        var contain = vNode.getComputedStylePropertyValue('contain');
        if ([ 'layout', 'paint', 'strict', 'content' ].includes(contain)) {
          return true;
        }
        if (zIndex !== 'auto' && parentVNode) {
          var parentDsiplay = parentVNode.getComputedStylePropertyValue('display');
          if ([ 'flex', 'inline-flex', 'inline flex', 'grid', 'inline-grid', 'inline grid' ].includes(parentDsiplay)) {
            return true;
          }
        }
        return false;
      }
      function isFloated(vNode) {
        if (!vNode) {
          return false;
        }
        if (vNode._isFloated !== undefined) {
          return vNode._isFloated;
        }
        var floatStyle = vNode.getComputedStylePropertyValue('float');
        if (floatStyle !== 'none') {
          vNode._isFloated = true;
          return true;
        }
        var floated = isFloated(vNode.parent);
        vNode._isFloated = floated;
        return floated;
      }
      function getPositionOrder(vNode) {
        if (vNode.getComputedStylePropertyValue('position') === 'static') {
          if (vNode.getComputedStylePropertyValue('display').indexOf('inline') !== -1) {
            return 2;
          }
          if (isFloated(vNode)) {
            return 1;
          }
          return 0;
        }
        return 3;
      }
      function visuallySort(a, b) {
        for (var i = 0; i < a._stackingOrder.length; i++) {
          if (typeof b._stackingOrder[i] === 'undefined') {
            return -1;
          }
          if (b._stackingOrder[i] > a._stackingOrder[i]) {
            return 1;
          }
          if (b._stackingOrder[i] < a._stackingOrder[i]) {
            return -1;
          }
        }
        var aNode = a.actualNode;
        var bNode = b.actualNode;
        if (aNode.getRootNode && aNode.getRootNode() !== bNode.getRootNode()) {
          var boundaries = [];
          while (aNode) {
            boundaries.push({
              root: aNode.getRootNode(),
              node: aNode
            });
            aNode = aNode.getRootNode().host;
          }
          while (bNode && !boundaries.find(function(boundary) {
            return boundary.root === bNode.getRootNode();
          })) {
            bNode = bNode.getRootNode().host;
          }
          aNode = boundaries.find(function(boundary) {
            return boundary.root === bNode.getRootNode();
          }).node;
          if (aNode === bNode) {
            return a.actualNode.getRootNode() !== aNode.getRootNode() ? -1 : 1;
          }
        }
        var _window$Node = window.Node, DOCUMENT_POSITION_FOLLOWING = _window$Node.DOCUMENT_POSITION_FOLLOWING, DOCUMENT_POSITION_CONTAINS = _window$Node.DOCUMENT_POSITION_CONTAINS, DOCUMENT_POSITION_CONTAINED_BY = _window$Node.DOCUMENT_POSITION_CONTAINED_BY;
        var docPosition = aNode.compareDocumentPosition(bNode);
        var DOMOrder = docPosition & DOCUMENT_POSITION_FOLLOWING ? 1 : -1;
        var isDescendant = docPosition & DOCUMENT_POSITION_CONTAINS || docPosition & DOCUMENT_POSITION_CONTAINED_BY;
        var aPosition = getPositionOrder(a);
        var bPosition = getPositionOrder(b);
        if (aPosition === bPosition || isDescendant) {
          return DOMOrder;
        }
        return bPosition - aPosition;
      }
      function getStackingOrder(vNode, parentVNode) {
        var stackingOrder = parentVNode._stackingOrder.slice();
        var zIndex = vNode.getComputedStylePropertyValue('z-index');
        if (zIndex !== 'auto') {
          stackingOrder[stackingOrder.length - 1] = parseInt(zIndex);
        }
        if (isStackingContext(vNode, parentVNode)) {
          stackingOrder.push(0);
        }
        return stackingOrder;
      }
      function findScrollRegionParent(vNode, parentVNode) {
        var scrollRegionParent = null;
        var checkedNodes = [ vNode ];
        while (parentVNode) {
          if (parentVNode._scrollRegionParent) {
            scrollRegionParent = parentVNode._scrollRegionParent;
            break;
          }
          if (Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getScroll'])(parentVNode.actualNode)) {
            scrollRegionParent = parentVNode;
            break;
          }
          checkedNodes.push(parentVNode);
          parentVNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getNodeFromTree'])(parentVNode.actualNode.parentElement || parentVNode.actualNode.parentNode);
        }
        checkedNodes.forEach(function(vNode) {
          return vNode._scrollRegionParent = scrollRegionParent;
        });
        return scrollRegionParent;
      }
      function addNodeToGrid(grid, vNode) {
        vNode._grid = grid;
        vNode.clientRects.forEach(function(rect) {
          var x = rect.left;
          var y = rect.top;
          var startRow = y / gridSize | 0;
          var startCol = x / gridSize | 0;
          var endRow = (y + rect.height) / gridSize | 0;
          var endCol = (x + rect.width) / gridSize | 0;
          for (var row = startRow; row <= endRow; row++) {
            grid.cells[row] = grid.cells[row] || [];
            for (var col = startCol; col <= endCol; col++) {
              grid.cells[row][col] = grid.cells[row][col] || [];
              if (!grid.cells[row][col].includes(vNode)) {
                grid.cells[row][col].push(vNode);
              }
            }
          }
        });
      }
      function createGrid() {
        var root = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document.body;
        var rootGrid = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
          container: null,
          cells: []
        };
        var parentVNode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
        if (!parentVNode) {
          var vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getNodeFromTree'])(document.documentElement);
          if (!vNode) {
            vNode = new _core_base_virtual_node_virtual_node__WEBPACK_IMPORTED_MODULE_1__['default'](document.documentElement);
          }
          vNode._stackingOrder = [ 0 ];
          addNodeToGrid(rootGrid, vNode);
          if (Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getScroll'])(vNode.actualNode)) {
            var subGrid = {
              container: vNode,
              cells: []
            };
            vNode._subGrid = subGrid;
          }
        }
        var treeWalker = document.createTreeWalker(root, window.NodeFilter.SHOW_ELEMENT, null, false);
        var node = parentVNode ? treeWalker.nextNode() : treeWalker.currentNode;
        while (node) {
          var _vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getNodeFromTree'])(node);
          if (node.parentElement) {
            parentVNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getNodeFromTree'])(node.parentElement);
          } else if (node.parentNode && Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getNodeFromTree'])(node.parentNode)) {
            parentVNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getNodeFromTree'])(node.parentNode);
          }
          if (!_vNode) {
            _vNode = new axe.VirtualNode(node, parentVNode);
          }
          _vNode._stackingOrder = getStackingOrder(_vNode, parentVNode);
          var scrollRegionParent = findScrollRegionParent(_vNode, parentVNode);
          var grid = scrollRegionParent ? scrollRegionParent._subGrid : rootGrid;
          if (Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getScroll'])(_vNode.actualNode)) {
            var _subGrid = {
              container: _vNode,
              cells: []
            };
            _vNode._subGrid = _subGrid;
          }
          var rect = _vNode.boundingClientRect;
          if (rect.width !== 0 && rect.height !== 0 && Object(_is_visible__WEBPACK_IMPORTED_MODULE_0__['default'])(node)) {
            addNodeToGrid(grid, _vNode);
          }
          if (Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['isShadowRoot'])(node)) {
            createGrid(node.shadowRoot, grid, _vNode);
          }
          node = treeWalker.nextNode();
        }
      }
      function getRectStack(grid, rect) {
        var recursed = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
        var x = rect.left + rect.width / 2;
        var y = rect.top + rect.height / 2;
        var row = y / gridSize | 0;
        var col = x / gridSize | 0;
        var stack = grid.cells[row][col].filter(function(gridCellNode) {
          return gridCellNode.clientRects.find(function(clientRect) {
            var rectX = clientRect.left;
            var rectY = clientRect.top;
            return x <= rectX + clientRect.width && x >= rectX && y <= rectY + clientRect.height && y >= rectY;
          });
        });
        var gridContainer = grid.container;
        if (gridContainer) {
          stack = getRectStack(gridContainer._grid, gridContainer.boundingClientRect, true).concat(stack);
        }
        if (!recursed) {
          stack = stack.sort(visuallySort).map(function(vNode) {
            return vNode.actualNode;
          }).concat(document.documentElement).filter(function(node, index, array) {
            return array.indexOf(node) === index;
          });
        }
        return stack;
      }
    },
    './lib/commons/dom/get-root-node.js': function libCommonsDomGetRootNodeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils_get_root_node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/get-root-node.js');
      __webpack_exports__['default'] = _core_utils_get_root_node__WEBPACK_IMPORTED_MODULE_0__['default'];
    },
    './lib/commons/dom/get-scroll-offset.js': function libCommonsDomGetScrollOffsetJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getScrollOffset(element) {
        'use strict';
        if (!element.nodeType && element.document) {
          element = element.document;
        }
        if (element.nodeType === 9) {
          var docElement = element.documentElement, body = element.body;
          return {
            left: docElement && docElement.scrollLeft || body && body.scrollLeft || 0,
            top: docElement && docElement.scrollTop || body && body.scrollTop || 0
          };
        }
        return {
          left: element.scrollLeft,
          top: element.scrollTop
        };
      }
      __webpack_exports__['default'] = getScrollOffset;
    },
    './lib/commons/dom/get-tabbable-elements.js': function libCommonsDomGetTabbableElementsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function getTabbableElements(virtualNode) {
        var nodeAndDescendents = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['querySelectorAll'])(virtualNode, '*');
        var tabbableElements = nodeAndDescendents.filter(function(vNode) {
          var isFocusable = vNode.isFocusable;
          var tabIndex = vNode.actualNode.getAttribute('tabindex');
          tabIndex = tabIndex && !isNaN(parseInt(tabIndex, 10)) ? parseInt(tabIndex) : null;
          return tabIndex ? isFocusable && tabIndex >= 0 : isFocusable;
        });
        return tabbableElements;
      }
      __webpack_exports__['default'] = getTabbableElements;
    },
    './lib/commons/dom/get-text-element-stack.js': function libCommonsDomGetTextElementStackJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_element_stack__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/get-element-stack.js');
      var _get_rect_stack__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/get-rect-stack.js');
      var _text_sanitize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/text/sanitize.js');
      var _core_base_cache__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/base/cache.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/core/utils/index.js');
      function getTextElementStack(node) {
        if (!_core_base_cache__WEBPACK_IMPORTED_MODULE_3__['default'].get('gridCreated')) {
          Object(_get_rect_stack__WEBPACK_IMPORTED_MODULE_1__['createGrid'])();
          _core_base_cache__WEBPACK_IMPORTED_MODULE_3__['default'].set('gridCreated', true);
        }
        var vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_4__['getNodeFromTree'])(node);
        var grid = vNode._grid;
        if (!grid) {
          return [];
        }
        var whiteSpace = vNode.getComputedStylePropertyValue('white-space');
        var overflow = vNode.getComputedStylePropertyValue('overflow');
        if (whiteSpace === 'nowrap' && overflow === 'hidden') {
          return [ Object(_get_element_stack__WEBPACK_IMPORTED_MODULE_0__['default'])(node) ];
        }
        var clientRects = [];
        Array.from(node.childNodes).forEach(function(elm) {
          if (elm.nodeType === 3 && Object(_text_sanitize__WEBPACK_IMPORTED_MODULE_2__['default'])(elm.textContent) !== '') {
            var range = document.createRange();
            range.selectNodeContents(elm);
            var rects = range.getClientRects();
            for (var i = 0; i < rects.length; i++) {
              var rect = rects[i];
              if (rect.width >= 1 && rect.height >= 1) {
                clientRects.push(rect);
              }
            }
          }
        });
        return clientRects.map(function(rect) {
          return Object(_get_rect_stack__WEBPACK_IMPORTED_MODULE_1__['getRectStack'])(grid, rect);
        });
      }
      __webpack_exports__['default'] = getTextElementStack;
    },
    './lib/commons/dom/get-viewport-size.js': function libCommonsDomGetViewportSizeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getViewportSize(win) {
        'use strict';
        var doc = win.document;
        var docElement = doc.documentElement;
        if (win.innerWidth) {
          return {
            width: win.innerWidth,
            height: win.innerHeight
          };
        }
        if (docElement) {
          return {
            width: docElement.clientWidth,
            height: docElement.clientHeight
          };
        }
        var body = doc.body;
        return {
          width: body.clientWidth,
          height: body.clientHeight
        };
      }
      __webpack_exports__['default'] = getViewportSize;
    },
    './lib/commons/dom/has-content-virtual.js': function libCommonsDomHasContentVirtualJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _is_visual_content__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/is-visual-content.js');
      var _aria_label_virtual__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/label-virtual.js');
      var hiddenTextElms = [ 'HEAD', 'TITLE', 'TEMPLATE', 'SCRIPT', 'STYLE', 'IFRAME', 'OBJECT', 'VIDEO', 'AUDIO', 'NOSCRIPT' ];
      function hasChildTextNodes(elm) {
        if (!hiddenTextElms.includes(elm.actualNode.nodeName.toUpperCase())) {
          return elm.children.some(function(_ref44) {
            var actualNode = _ref44.actualNode;
            return actualNode.nodeType === 3 && actualNode.nodeValue.trim();
          });
        }
      }
      function hasContentVirtual(elm, noRecursion, ignoreAria) {
        return hasChildTextNodes(elm) || Object(_is_visual_content__WEBPACK_IMPORTED_MODULE_0__['default'])(elm.actualNode) || !ignoreAria && !!Object(_aria_label_virtual__WEBPACK_IMPORTED_MODULE_1__['default'])(elm) || !noRecursion && elm.children.some(function(child) {
          return child.actualNode.nodeType === 1 && hasContentVirtual(child);
        });
      }
      __webpack_exports__['default'] = hasContentVirtual;
    },
    './lib/commons/dom/has-content.js': function libCommonsDomHasContentJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _has_content_virtual__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/has-content-virtual.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function hasContent(elm, noRecursion, ignoreAria) {
        elm = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeFromTree'])(elm);
        return Object(_has_content_virtual__WEBPACK_IMPORTED_MODULE_0__['default'])(elm, noRecursion, ignoreAria);
      }
      __webpack_exports__['default'] = hasContent;
    },
    './lib/commons/dom/idrefs.js': function libCommonsDomIdrefsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_root_node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/get-root-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function idrefs(node, attr) {
        node = node.actualNode || node;
        try {
          var doc = Object(_get_root_node__WEBPACK_IMPORTED_MODULE_0__['default'])(node);
          var result = [];
          var attrValue = node.getAttribute(attr);
          if (attrValue) {
            attrValue = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['tokenList'])(attrValue);
            for (var index = 0; index < attrValue.length; index++) {
              result.push(doc.getElementById(attrValue[index]));
            }
          }
          return result;
        } catch (e) {
          throw new TypeError('Cannot resolve id references for non-DOM nodes');
        }
      }
      __webpack_exports__['default'] = idrefs;
    },
    './lib/commons/dom/index.js': function libCommonsDomIndexJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _find_elms_in_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/find-elms-in-context.js');
      __webpack_require__.d(__webpack_exports__, 'findElmsInContext', function() {
        return _find_elms_in_context__WEBPACK_IMPORTED_MODULE_0__['default'];
      });
      var _find_up_virtual__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/find-up-virtual.js');
      __webpack_require__.d(__webpack_exports__, 'findUpVirtual', function() {
        return _find_up_virtual__WEBPACK_IMPORTED_MODULE_1__['default'];
      });
      var _find_up__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/dom/find-up.js');
      __webpack_require__.d(__webpack_exports__, 'findUp', function() {
        return _find_up__WEBPACK_IMPORTED_MODULE_2__['default'];
      });
      var _get_composed_parent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/dom/get-composed-parent.js');
      __webpack_require__.d(__webpack_exports__, 'getComposedParent', function() {
        return _get_composed_parent__WEBPACK_IMPORTED_MODULE_3__['default'];
      });
      var _get_element_by_reference__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/dom/get-element-by-reference.js');
      __webpack_require__.d(__webpack_exports__, 'getElementByReference', function() {
        return _get_element_by_reference__WEBPACK_IMPORTED_MODULE_4__['default'];
      });
      var _get_element_coordinates__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/dom/get-element-coordinates.js');
      __webpack_require__.d(__webpack_exports__, 'getElementCoordinates', function() {
        return _get_element_coordinates__WEBPACK_IMPORTED_MODULE_5__['default'];
      });
      var _get_element_stack__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/commons/dom/get-element-stack.js');
      __webpack_require__.d(__webpack_exports__, 'getElementStack', function() {
        return _get_element_stack__WEBPACK_IMPORTED_MODULE_6__['default'];
      });
      var _get_root_node__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/commons/dom/get-root-node.js');
      __webpack_require__.d(__webpack_exports__, 'getRootNode', function() {
        return _get_root_node__WEBPACK_IMPORTED_MODULE_7__['default'];
      });
      var _get_scroll_offset__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__('./lib/commons/dom/get-scroll-offset.js');
      __webpack_require__.d(__webpack_exports__, 'getScrollOffset', function() {
        return _get_scroll_offset__WEBPACK_IMPORTED_MODULE_8__['default'];
      });
      var _get_tabbable_elements__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__('./lib/commons/dom/get-tabbable-elements.js');
      __webpack_require__.d(__webpack_exports__, 'getTabbableElements', function() {
        return _get_tabbable_elements__WEBPACK_IMPORTED_MODULE_9__['default'];
      });
      var _get_text_element_stack__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__('./lib/commons/dom/get-text-element-stack.js');
      __webpack_require__.d(__webpack_exports__, 'getTextElementStack', function() {
        return _get_text_element_stack__WEBPACK_IMPORTED_MODULE_10__['default'];
      });
      var _get_viewport_size__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__('./lib/commons/dom/get-viewport-size.js');
      __webpack_require__.d(__webpack_exports__, 'getViewportSize', function() {
        return _get_viewport_size__WEBPACK_IMPORTED_MODULE_11__['default'];
      });
      var _has_content_virtual__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__('./lib/commons/dom/has-content-virtual.js');
      __webpack_require__.d(__webpack_exports__, 'hasContentVirtual', function() {
        return _has_content_virtual__WEBPACK_IMPORTED_MODULE_12__['default'];
      });
      var _has_content__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__('./lib/commons/dom/has-content.js');
      __webpack_require__.d(__webpack_exports__, 'hasContent', function() {
        return _has_content__WEBPACK_IMPORTED_MODULE_13__['default'];
      });
      var _idrefs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__('./lib/commons/dom/idrefs.js');
      __webpack_require__.d(__webpack_exports__, 'idrefs', function() {
        return _idrefs__WEBPACK_IMPORTED_MODULE_14__['default'];
      });
      var _inserted_into_focus_order__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__('./lib/commons/dom/inserted-into-focus-order.js');
      __webpack_require__.d(__webpack_exports__, 'insertedIntoFocusOrder', function() {
        return _inserted_into_focus_order__WEBPACK_IMPORTED_MODULE_15__['default'];
      });
      var _is_focusable__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__('./lib/commons/dom/is-focusable.js');
      __webpack_require__.d(__webpack_exports__, 'isFocusable', function() {
        return _is_focusable__WEBPACK_IMPORTED_MODULE_16__['default'];
      });
      var _is_hidden_with_css__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__('./lib/commons/dom/is-hidden-with-css.js');
      __webpack_require__.d(__webpack_exports__, 'isHiddenWithCSS', function() {
        return _is_hidden_with_css__WEBPACK_IMPORTED_MODULE_17__['default'];
      });
      var _is_html5__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__('./lib/commons/dom/is-html5.js');
      __webpack_require__.d(__webpack_exports__, 'isHTML5', function() {
        return _is_html5__WEBPACK_IMPORTED_MODULE_18__['default'];
      });
      var _is_in_text_block__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__('./lib/commons/dom/is-in-text-block.js');
      __webpack_require__.d(__webpack_exports__, 'isInTextBlock', function() {
        return _is_in_text_block__WEBPACK_IMPORTED_MODULE_19__['default'];
      });
      var _is_modal_open__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__('./lib/commons/dom/is-modal-open.js');
      __webpack_require__.d(__webpack_exports__, 'isModalOpen', function() {
        return _is_modal_open__WEBPACK_IMPORTED_MODULE_20__['default'];
      });
      var _is_natively_focusable__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__('./lib/commons/dom/is-natively-focusable.js');
      __webpack_require__.d(__webpack_exports__, 'isNativelyFocusable', function() {
        return _is_natively_focusable__WEBPACK_IMPORTED_MODULE_21__['default'];
      });
      var _is_node__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__('./lib/commons/dom/is-node.js');
      __webpack_require__.d(__webpack_exports__, 'isNode', function() {
        return _is_node__WEBPACK_IMPORTED_MODULE_22__['default'];
      });
      var _is_offscreen__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__('./lib/commons/dom/is-offscreen.js');
      __webpack_require__.d(__webpack_exports__, 'isOffscreen', function() {
        return _is_offscreen__WEBPACK_IMPORTED_MODULE_23__['default'];
      });
      var _is_opaque__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__('./lib/commons/dom/is-opaque.js');
      __webpack_require__.d(__webpack_exports__, 'isOpaque', function() {
        return _is_opaque__WEBPACK_IMPORTED_MODULE_24__['default'];
      });
      var _is_skip_link__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__('./lib/commons/dom/is-skip-link.js');
      __webpack_require__.d(__webpack_exports__, 'isSkipLink', function() {
        return _is_skip_link__WEBPACK_IMPORTED_MODULE_25__['default'];
      });
      var _is_visible__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__('./lib/commons/dom/is-visible.js');
      __webpack_require__.d(__webpack_exports__, 'isVisible', function() {
        return _is_visible__WEBPACK_IMPORTED_MODULE_26__['default'];
      });
      var _is_visual_content__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__('./lib/commons/dom/is-visual-content.js');
      __webpack_require__.d(__webpack_exports__, 'isVisualContent', function() {
        return _is_visual_content__WEBPACK_IMPORTED_MODULE_27__['default'];
      });
      var _reduce_to_elements_below_floating__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__('./lib/commons/dom/reduce-to-elements-below-floating.js');
      __webpack_require__.d(__webpack_exports__, 'reduceToElementsBelowFloating', function() {
        return _reduce_to_elements_below_floating__WEBPACK_IMPORTED_MODULE_28__['default'];
      });
      var _shadow_elements_from_point__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__('./lib/commons/dom/shadow-elements-from-point.js');
      __webpack_require__.d(__webpack_exports__, 'shadowElementsFromPoint', function() {
        return _shadow_elements_from_point__WEBPACK_IMPORTED_MODULE_29__['default'];
      });
      var _url_props_from_attribute__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__('./lib/commons/dom/url-props-from-attribute.js');
      __webpack_require__.d(__webpack_exports__, 'urlPropsFromAttribute', function() {
        return _url_props_from_attribute__WEBPACK_IMPORTED_MODULE_30__['default'];
      });
      var _visually_contains__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__('./lib/commons/dom/visually-contains.js');
      __webpack_require__.d(__webpack_exports__, 'visuallyContains', function() {
        return _visually_contains__WEBPACK_IMPORTED_MODULE_31__['default'];
      });
      var _visually_overlaps__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__('./lib/commons/dom/visually-overlaps.js');
      __webpack_require__.d(__webpack_exports__, 'visuallyOverlaps', function() {
        return _visually_overlaps__WEBPACK_IMPORTED_MODULE_32__['default'];
      });
    },
    './lib/commons/dom/inserted-into-focus-order.js': function libCommonsDomInsertedIntoFocusOrderJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _is_focusable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/is-focusable.js');
      var _is_natively_focusable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/is-natively-focusable.js');
      function insertedIntoFocusOrder(el) {
        var tabIndex = parseInt(el.getAttribute('tabindex'), 10);
        return tabIndex > -1 && Object(_is_focusable__WEBPACK_IMPORTED_MODULE_0__['default'])(el) && !Object(_is_natively_focusable__WEBPACK_IMPORTED_MODULE_1__['default'])(el);
      }
      __webpack_exports__['default'] = insertedIntoFocusOrder;
    },
    './lib/commons/dom/is-focusable.js': function libCommonsDomIsFocusableJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _focus_disabled__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/focus-disabled.js');
      var _is_natively_focusable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/is-natively-focusable.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/index.js');
      function isFocusable(el) {
        var vNode = el instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_2__['default'] ? el : Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['getNodeFromTree'])(el);
        if (Object(_focus_disabled__WEBPACK_IMPORTED_MODULE_0__['default'])(vNode)) {
          return false;
        } else if (Object(_is_natively_focusable__WEBPACK_IMPORTED_MODULE_1__['default'])(vNode)) {
          return true;
        }
        var tabindex = vNode.attr('tabindex');
        if (tabindex && !isNaN(parseInt(tabindex, 10))) {
          return true;
        }
        return false;
      }
      __webpack_exports__['default'] = isFocusable;
    },
    './lib/commons/dom/is-hidden-with-css.js': function libCommonsDomIsHiddenWithCssJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_composed_parent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/get-composed-parent.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function isHiddenWithCSS(el, descendentVisibilityValue) {
        var vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeFromTree'])(el);
        if (!vNode) {
          return _isHiddenWithCSS(el, descendentVisibilityValue);
        }
        if (vNode._isHiddenWithCSS === void 0) {
          vNode._isHiddenWithCSS = _isHiddenWithCSS(el, descendentVisibilityValue);
        }
        return vNode._isHiddenWithCSS;
      }
      function _isHiddenWithCSS(el, descendentVisibilityValue) {
        if (el.nodeType === 9) {
          return false;
        }
        if (el.nodeType === 11) {
          el = el.host;
        }
        if ([ 'STYLE', 'SCRIPT' ].includes(el.nodeName.toUpperCase())) {
          return false;
        }
        var style = window.getComputedStyle(el, null);
        if (!style) {
          throw new Error('Style does not exist for the given element.');
        }
        var displayValue = style.getPropertyValue('display');
        if (displayValue === 'none') {
          return true;
        }
        var HIDDEN_VISIBILITY_VALUES = [ 'hidden', 'collapse' ];
        var visibilityValue = style.getPropertyValue('visibility');
        if (HIDDEN_VISIBILITY_VALUES.includes(visibilityValue) && !descendentVisibilityValue) {
          return true;
        }
        if (HIDDEN_VISIBILITY_VALUES.includes(visibilityValue) && descendentVisibilityValue && HIDDEN_VISIBILITY_VALUES.includes(descendentVisibilityValue)) {
          return true;
        }
        var parent = Object(_get_composed_parent__WEBPACK_IMPORTED_MODULE_0__['default'])(el);
        if (parent && !HIDDEN_VISIBILITY_VALUES.includes(visibilityValue)) {
          return isHiddenWithCSS(parent, visibilityValue);
        }
        return false;
      }
      __webpack_exports__['default'] = isHiddenWithCSS;
    },
    './lib/commons/dom/is-html5.js': function libCommonsDomIsHtml5Js(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function isHTML5(doc) {
        var node = doc.doctype;
        if (node === null) {
          return false;
        }
        return node.name === 'html' && !node.publicId && !node.systemId;
      }
      __webpack_exports__['default'] = isHTML5;
    },
    './lib/commons/dom/is-in-text-block.js': function libCommonsDomIsInTextBlockJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_composed_parent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/get-composed-parent.js');
      var _text_sanitize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/sanitize.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function walkDomNode(node, functor) {
        if (functor(node.actualNode) !== false) {
          node.children.forEach(function(child) {
            return walkDomNode(child, functor);
          });
        }
      }
      var blockLike = [ 'block', 'list-item', 'table', 'flex', 'grid', 'inline-block' ];
      function isBlock(elm) {
        var display = window.getComputedStyle(elm).getPropertyValue('display');
        return blockLike.includes(display) || display.substr(0, 6) === 'table-';
      }
      function getBlockParent(node) {
        var parentBlock = Object(_get_composed_parent__WEBPACK_IMPORTED_MODULE_0__['default'])(node);
        while (parentBlock && !isBlock(parentBlock)) {
          parentBlock = Object(_get_composed_parent__WEBPACK_IMPORTED_MODULE_0__['default'])(parentBlock);
        }
        return Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getNodeFromTree'])(parentBlock);
      }
      function isInTextBlock(node) {
        if (isBlock(node)) {
          return false;
        }
        var virtualParent = getBlockParent(node);
        var parentText = '';
        var linkText = '';
        var inBrBlock = 0;
        walkDomNode(virtualParent, function(currNode) {
          if (inBrBlock === 2) {
            return false;
          }
          if (currNode.nodeType === 3) {
            parentText += currNode.nodeValue;
          }
          if (currNode.nodeType !== 1) {
            return;
          }
          var nodeName = (currNode.nodeName || '').toUpperCase();
          if ([ 'BR', 'HR' ].includes(nodeName)) {
            if (inBrBlock === 0) {
              parentText = '';
              linkText = '';
            } else {
              inBrBlock = 2;
            }
          } else if (currNode.style.display === 'none' || currNode.style.overflow === 'hidden' || ![ '', null, 'none' ].includes(currNode.style['float']) || ![ '', null, 'relative' ].includes(currNode.style.position)) {
            return false;
          } else if (nodeName === 'A' && currNode.href || (currNode.getAttribute('role') || '').toLowerCase() === 'link') {
            if (currNode === node) {
              inBrBlock = 1;
            }
            linkText += currNode.textContent;
            return false;
          }
        });
        parentText = Object(_text_sanitize__WEBPACK_IMPORTED_MODULE_1__['default'])(parentText);
        linkText = Object(_text_sanitize__WEBPACK_IMPORTED_MODULE_1__['default'])(linkText);
        return parentText.length > linkText.length;
      }
      __webpack_exports__['default'] = isInTextBlock;
    },
    './lib/commons/dom/is-modal-open.js': function libCommonsDomIsModalOpenJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _is_visible__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/is-visible.js');
      var _get_viewport_size__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/get-viewport-size.js');
      var _core_base_cache__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/base/cache.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/index.js');
      function isModalOpen(options) {
        options = options || {};
        var modalPercent = options.modalPercent || .75;
        if (_core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].get('isModalOpen')) {
          return _core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].get('isModalOpen');
        }
        var definiteModals = Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['querySelectorAllFilter'])(axe._tree[0], 'dialog, [role=dialog], [aria-modal=true]', function(vNode) {
          return Object(_is_visible__WEBPACK_IMPORTED_MODULE_0__['default'])(vNode.actualNode);
        });
        if (definiteModals.length) {
          _core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].set('isModalOpen', true);
          return true;
        }
        var viewport = Object(_get_viewport_size__WEBPACK_IMPORTED_MODULE_1__['default'])(window);
        var percentWidth = viewport.width * modalPercent;
        var percentHeight = viewport.height * modalPercent;
        var x = (viewport.width - percentWidth) / 2;
        var y = (viewport.height - percentHeight) / 2;
        var points = [ {
          x: x,
          y: y
        }, {
          x: viewport.width - x,
          y: y
        }, {
          x: viewport.width / 2,
          y: viewport.height / 2
        }, {
          x: x,
          y: viewport.height - y
        }, {
          x: viewport.width - x,
          y: viewport.height - y
        } ];
        var stacks = points.map(function(point) {
          return Array.from(document.elementsFromPoint(point.x, point.y));
        });
        var _loop3 = function _loop3(i) {
          var modalElement = stacks[i].find(function(elm) {
            var style = window.getComputedStyle(elm);
            return parseInt(style.width, 10) >= percentWidth && parseInt(style.height, 10) >= percentHeight && style.getPropertyValue('pointer-events') !== 'none' && (style.position === 'absolute' || style.position === 'fixed');
          });
          if (modalElement && stacks.every(function(stack) {
            return stack.includes(modalElement);
          })) {
            _core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].set('isModalOpen', true);
            return {
              v: true
            };
          }
        };
        for (var i = 0; i < stacks.length; i++) {
          var _ret3 = _loop3(i);
          if (_typeof(_ret3) === 'object') {
            return _ret3.v;
          }
        }
        _core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].set('isModalOpen', undefined);
        return undefined;
      }
      __webpack_exports__['default'] = isModalOpen;
    },
    './lib/commons/dom/is-natively-focusable.js': function libCommonsDomIsNativelyFocusableJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      var _focus_disabled__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/dom/focus-disabled.js');
      function isNativelyFocusable(el) {
        var vNode = el instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_0__['default'] ? el : Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeFromTree'])(el);
        if (!vNode || Object(_focus_disabled__WEBPACK_IMPORTED_MODULE_2__['default'])(vNode)) {
          return false;
        }
        switch (vNode.props.nodeName) {
         case 'a':
         case 'area':
          if (vNode.hasAttr('href')) {
            return true;
          }
          break;

         case 'input':
          return vNode.props.type !== 'hidden';

         case 'textarea':
         case 'select':
         case 'summary':
         case 'button':
          return true;

         case 'details':
          return !Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['querySelectorAll'])(vNode, 'summary').length;
        }
        return false;
      }
      __webpack_exports__['default'] = isNativelyFocusable;
    },
    './lib/commons/dom/is-node.js': function libCommonsDomIsNodeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function isNode(element) {
        'use strict';
        return element instanceof window.Node;
      }
      __webpack_exports__['default'] = isNode;
    },
    './lib/commons/dom/is-offscreen.js': function libCommonsDomIsOffscreenJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_composed_parent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/get-composed-parent.js');
      var _get_element_coordinates__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/get-element-coordinates.js');
      var _get_viewport_size__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/dom/get-viewport-size.js');
      function noParentScrolled(element, offset) {
        element = Object(_get_composed_parent__WEBPACK_IMPORTED_MODULE_0__['default'])(element);
        while (element && element.nodeName.toLowerCase() !== 'html') {
          if (element.scrollTop) {
            offset += element.scrollTop;
            if (offset >= 0) {
              return false;
            }
          }
          element = Object(_get_composed_parent__WEBPACK_IMPORTED_MODULE_0__['default'])(element);
        }
        return true;
      }
      function isOffscreen(element) {
        var leftBoundary;
        var docElement = document.documentElement;
        var styl = window.getComputedStyle(element);
        var dir = window.getComputedStyle(document.body || docElement).getPropertyValue('direction');
        var coords = Object(_get_element_coordinates__WEBPACK_IMPORTED_MODULE_1__['default'])(element);
        if (coords.bottom < 0 && (noParentScrolled(element, coords.bottom) || styl.position === 'absolute')) {
          return true;
        }
        if (coords.left === 0 && coords.right === 0) {
          return false;
        }
        if (dir === 'ltr') {
          if (coords.right <= 0) {
            return true;
          }
        } else {
          leftBoundary = Math.max(docElement.scrollWidth, Object(_get_viewport_size__WEBPACK_IMPORTED_MODULE_2__['default'])(window).width);
          if (coords.left >= leftBoundary) {
            return true;
          }
        }
        return false;
      }
      __webpack_exports__['default'] = isOffscreen;
    },
    './lib/commons/dom/is-opaque.js': function libCommonsDomIsOpaqueJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _color_element_has_image__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/color/element-has-image.js');
      var _color_get_own_background_color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/color/get-own-background-color.js');
      function isOpaque(node) {
        var style = window.getComputedStyle(node);
        return Object(_color_element_has_image__WEBPACK_IMPORTED_MODULE_0__['default'])(node, style) || Object(_color_get_own_background_color__WEBPACK_IMPORTED_MODULE_1__['default'])(style).alpha === 1;
      }
      __webpack_exports__['default'] = isOpaque;
    },
    './lib/commons/dom/is-skip-link.js': function libCommonsDomIsSkipLinkJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_base_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/cache.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      var isInternalLinkRegex = /^\/?#[^/!]/;
      function isSkipLink(element) {
        if (!isInternalLinkRegex.test(element.getAttribute('href'))) {
          return false;
        }
        var firstPageLink;
        if (typeof _core_base_cache__WEBPACK_IMPORTED_MODULE_0__['default'].get('firstPageLink') !== 'undefined') {
          firstPageLink = _core_base_cache__WEBPACK_IMPORTED_MODULE_0__['default'].get('firstPageLink');
        } else {
          firstPageLink = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['querySelectorAll'])(axe._tree, 'a:not([href^="#"]):not([href^="/#"]):not([href^="javascript"])')[0];
          _core_base_cache__WEBPACK_IMPORTED_MODULE_0__['default'].set('firstPageLink', firstPageLink || null);
        }
        if (!firstPageLink) {
          return true;
        }
        return element.compareDocumentPosition(firstPageLink.actualNode) === element.DOCUMENT_POSITION_FOLLOWING;
      }
      __webpack_exports__['default'] = isSkipLink;
    },
    './lib/commons/dom/is-visible.js': function libCommonsDomIsVisibleJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_root_node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/get-root-node.js');
      var _is_offscreen__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/is-offscreen.js');
      var _find_up__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/dom/find-up.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/index.js');
      var clipRegex = /rect\s*\(([0-9]+)px,?\s*([0-9]+)px,?\s*([0-9]+)px,?\s*([0-9]+)px\s*\)/;
      var clipPathRegex = /(\w+)\((\d+)/;
      function isClipped(style) {
        'use strict';
        var matchesClip = style.getPropertyValue('clip').match(clipRegex);
        var matchesClipPath = style.getPropertyValue('clip-path').match(clipPathRegex);
        if (matchesClip && matchesClip.length === 5) {
          return matchesClip[3] - matchesClip[1] <= 0 && matchesClip[2] - matchesClip[4] <= 0;
        }
        if (matchesClipPath) {
          var type = matchesClipPath[1];
          var value = parseInt(matchesClipPath[2], 10);
          switch (type) {
           case 'inset':
            return value >= 50;

           case 'circle':
            return value === 0;

           default:
          }
        }
        return false;
      }
      function isAreaVisible(el, screenReader, recursed) {
        var mapEl = Object(_find_up__WEBPACK_IMPORTED_MODULE_2__['default'])(el, 'map');
        if (!mapEl) {
          return false;
        }
        var mapElName = mapEl.getAttribute('name');
        if (!mapElName) {
          return false;
        }
        var mapElRootNode = Object(_get_root_node__WEBPACK_IMPORTED_MODULE_0__['default'])(el);
        if (!mapElRootNode || mapElRootNode.nodeType !== 9) {
          return false;
        }
        var refs = Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['querySelectorAll'])(axe._tree, 'img[usemap="#'.concat(Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['escapeSelector'])(mapElName), '"]'));
        if (!refs || !refs.length) {
          return false;
        }
        return refs.some(function(_ref45) {
          var actualNode = _ref45.actualNode;
          return isVisible(actualNode, screenReader, recursed);
        });
      }
      function isVisible(el, screenReader, recursed) {
        if (!el) {
          throw new TypeError('Cannot determine if element is visible for non-DOM nodes');
        }
        var vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['getNodeFromTree'])(el);
        var cacheName = '_isVisible' + (screenReader ? 'ScreenReader' : '');
        if (el.nodeType === 9) {
          return true;
        }
        if (el.nodeType === 11) {
          el = el.host;
        }
        if (vNode && typeof vNode[cacheName] !== 'undefined') {
          return vNode[cacheName];
        }
        var style = window.getComputedStyle(el, null);
        if (style === null) {
          return false;
        }
        var nodeName = el.nodeName.toUpperCase();
        if (nodeName === 'AREA') {
          return isAreaVisible(el, screenReader, recursed);
        }
        if (style.getPropertyValue('display') === 'none' || [ 'STYLE', 'SCRIPT', 'NOSCRIPT', 'TEMPLATE' ].includes(nodeName)) {
          return false;
        }
        if (screenReader && el.getAttribute('aria-hidden') === 'true') {
          return false;
        }
        if (!screenReader && (isClipped(style) || style.getPropertyValue('opacity') === '0' || Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['getScroll'])(el) && parseInt(style.getPropertyValue('height')) === 0)) {
          return false;
        }
        if (!recursed && (style.getPropertyValue('visibility') === 'hidden' || !screenReader && Object(_is_offscreen__WEBPACK_IMPORTED_MODULE_1__['default'])(el))) {
          return false;
        }
        var parent = el.assignedSlot ? el.assignedSlot : el.parentNode;
        var visible = false;
        if (parent) {
          visible = isVisible(parent, screenReader, true);
        }
        if (vNode) {
          vNode[cacheName] = visible;
        }
        return visible;
      }
      __webpack_exports__['default'] = isVisible;
    },
    './lib/commons/dom/is-visual-content.js': function libCommonsDomIsVisualContentJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var visualRoles = [ 'checkbox', 'img', 'radio', 'range', 'slider', 'spinbutton', 'textbox' ];
      function isVisualContent(element) {
        var role = element.getAttribute('role');
        if (role) {
          return visualRoles.indexOf(role) !== -1;
        }
        switch (element.nodeName.toUpperCase()) {
         case 'IMG':
         case 'IFRAME':
         case 'OBJECT':
         case 'VIDEO':
         case 'AUDIO':
         case 'CANVAS':
         case 'SVG':
         case 'MATH':
         case 'BUTTON':
         case 'SELECT':
         case 'TEXTAREA':
         case 'KEYGEN':
         case 'PROGRESS':
         case 'METER':
          return true;

         case 'INPUT':
          return element.type !== 'hidden';

         default:
          return false;
        }
      }
      __webpack_exports__['default'] = isVisualContent;
    },
    './lib/commons/dom/reduce-to-elements-below-floating.js': function libCommonsDomReduceToElementsBelowFloatingJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function reduceToElementsBelowFloating(elements, targetNode) {
        var floatingPositions = [ 'fixed', 'sticky' ];
        var finalElements = [];
        var targetFound = false;
        for (var index = 0; index < elements.length; ++index) {
          var currentNode = elements[index];
          if (currentNode === targetNode) {
            targetFound = true;
          }
          var style = window.getComputedStyle(currentNode);
          if (!targetFound && floatingPositions.indexOf(style.position) !== -1) {
            finalElements = [];
            continue;
          }
          finalElements.push(currentNode);
        }
        return finalElements;
      }
      __webpack_exports__['default'] = reduceToElementsBelowFloating;
    },
    './lib/commons/dom/shadow-elements-from-point.js': function libCommonsDomShadowElementsFromPointJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_root_node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/get-root-node.js');
      var _visually_contains__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/visually-contains.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function shadowElementsFromPoint(nodeX, nodeY) {
        var root = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : document;
        var i = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
        if (i > 999) {
          throw new Error('Infinite loop detected');
        }
        return Array.from(root.elementsFromPoint(nodeX, nodeY) || []).filter(function(nodes) {
          return Object(_get_root_node__WEBPACK_IMPORTED_MODULE_0__['default'])(nodes) === root;
        }).reduce(function(stack, elm) {
          if (Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['isShadowRoot'])(elm)) {
            var shadowStack = shadowElementsFromPoint(nodeX, nodeY, elm.shadowRoot, i + 1);
            stack = stack.concat(shadowStack);
            if (stack.length && Object(_visually_contains__WEBPACK_IMPORTED_MODULE_1__['default'])(stack[0], elm)) {
              stack.push(elm);
            }
          } else {
            stack.push(elm);
          }
          return stack;
        }, []);
      }
      __webpack_exports__['default'] = shadowElementsFromPoint;
    },
    './lib/commons/dom/url-props-from-attribute.js': function libCommonsDomUrlPropsFromAttributeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function urlPropsFromAttribute(node, attribute) {
        if (!node.hasAttribute(attribute)) {
          return undefined;
        }
        var nodeName = node.nodeName.toUpperCase();
        var parser = node;
        if (![ 'A', 'AREA' ].includes(nodeName) || node.ownerSVGElement) {
          parser = document.createElement('a');
          parser.href = node.getAttribute(attribute);
        }
        var protocol = [ 'https:', 'ftps:' ].includes(parser.protocol) ? parser.protocol.replace(/s:$/, ':') : parser.protocol;
        var parserPathname = /^\//.test(parser.pathname) ? parser.pathname : '/'.concat(parser.pathname);
        var _getPathnameOrFilenam = getPathnameOrFilename(parserPathname), pathname = _getPathnameOrFilenam.pathname, filename = _getPathnameOrFilenam.filename;
        return {
          protocol: protocol,
          hostname: parser.hostname,
          port: getPort(parser.port),
          pathname: /\/$/.test(pathname) ? pathname : ''.concat(pathname, '/'),
          search: getSearchPairs(parser.search),
          hash: getHashRoute(parser.hash),
          filename: filename
        };
      }
      function getPort(port) {
        var excludePorts = [ '443', '80' ];
        return !excludePorts.includes(port) ? port : '';
      }
      function getPathnameOrFilename(pathname) {
        var filename = pathname.split('/').pop();
        if (!filename || filename.indexOf('.') === -1) {
          return {
            pathname: pathname,
            filename: ''
          };
        }
        return {
          pathname: pathname.replace(filename, ''),
          filename: /index./.test(filename) ? '' : filename
        };
      }
      function getSearchPairs(searchStr) {
        var query = {};
        if (!searchStr || !searchStr.length) {
          return query;
        }
        var pairs = searchStr.substring(1).split('&');
        if (!pairs || !pairs.length) {
          return query;
        }
        for (var index = 0; index < pairs.length; index++) {
          var pair = pairs[index];
          var _pair$split = pair.split('='), _pair$split2 = _slicedToArray(_pair$split, 2), key = _pair$split2[0], _pair$split2$ = _pair$split2[1], value = _pair$split2$ === void 0 ? '' : _pair$split2$;
          query[decodeURIComponent(key)] = decodeURIComponent(value);
        }
        return query;
      }
      function getHashRoute(hash) {
        if (!hash) {
          return '';
        }
        var hashRegex = /#!?\/?/g;
        var hasMatch = hash.match(hashRegex);
        if (!hasMatch) {
          return '';
        }
        var _hasMatch = _slicedToArray(hasMatch, 1), matchedStr = _hasMatch[0];
        if (matchedStr === '#') {
          return '';
        }
        return hash;
      }
      __webpack_exports__['default'] = urlPropsFromAttribute;
    },
    './lib/commons/dom/visually-contains.js': function libCommonsDomVisuallyContainsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function getScrollAncestor(node) {
        var vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['getNodeFromTree'])(node);
        var ancestor = vNode.parent;
        while (ancestor) {
          if (Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['getScroll'])(ancestor.actualNode)) {
            return ancestor.actualNode;
          }
          ancestor = ancestor.parent;
        }
      }
      function contains(node, parent) {
        var rectBound = node.getBoundingClientRect();
        var margin = .01;
        var rect = {
          top: rectBound.top + margin,
          bottom: rectBound.bottom - margin,
          left: rectBound.left + margin,
          right: rectBound.right - margin
        };
        var parentRect = parent.getBoundingClientRect();
        var parentTop = parentRect.top;
        var parentLeft = parentRect.left;
        var parentScrollArea = {
          top: parentTop - parent.scrollTop,
          bottom: parentTop - parent.scrollTop + parent.scrollHeight,
          left: parentLeft - parent.scrollLeft,
          right: parentLeft - parent.scrollLeft + parent.scrollWidth
        };
        var style = window.getComputedStyle(parent);
        if (style.getPropertyValue('display') === 'inline') {
          return true;
        }
        if (rect.left < parentScrollArea.left && rect.left < parentRect.left || rect.top < parentScrollArea.top && rect.top < parentRect.top || rect.right > parentScrollArea.right && rect.right > parentRect.right || rect.bottom > parentScrollArea.bottom && rect.bottom > parentRect.bottom) {
          return false;
        }
        if (rect.right > parentRect.right || rect.bottom > parentRect.bottom) {
          return style.overflow === 'scroll' || style.overflow === 'auto' || style.overflow === 'hidden' || parent instanceof window.HTMLBodyElement || parent instanceof window.HTMLHtmlElement;
        }
        return true;
      }
      function visuallyContains(node, parent) {
        var parentScrollAncestor = getScrollAncestor(parent);
        do {
          var nextScrollAncestor = getScrollAncestor(node);
          if (nextScrollAncestor === parentScrollAncestor || nextScrollAncestor === parent) {
            return contains(node, parent);
          }
          node = nextScrollAncestor;
        } while (node);
        return false;
      }
      __webpack_exports__['default'] = visuallyContains;
    },
    './lib/commons/dom/visually-overlaps.js': function libCommonsDomVisuallyOverlapsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function visuallyOverlaps(rect, parent) {
        var parentRect = parent.getBoundingClientRect();
        var parentTop = parentRect.top;
        var parentLeft = parentRect.left;
        var parentScrollArea = {
          top: parentTop - parent.scrollTop,
          bottom: parentTop - parent.scrollTop + parent.scrollHeight,
          left: parentLeft - parent.scrollLeft,
          right: parentLeft - parent.scrollLeft + parent.scrollWidth
        };
        if (rect.left > parentScrollArea.right && rect.left > parentRect.right || rect.top > parentScrollArea.bottom && rect.top > parentRect.bottom || rect.right < parentScrollArea.left && rect.right < parentRect.left || rect.bottom < parentScrollArea.top && rect.bottom < parentRect.top) {
          return false;
        }
        var style = window.getComputedStyle(parent);
        if (rect.left > parentRect.right || rect.top > parentRect.bottom) {
          return style.overflow === 'scroll' || style.overflow === 'auto' || parent instanceof window.HTMLBodyElement || parent instanceof window.HTMLHtmlElement;
        }
        return true;
      }
      __webpack_exports__['default'] = visuallyOverlaps;
    },
    './lib/commons/forms/index.js': function libCommonsFormsIndexJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _is_aria_combobox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/forms/is-aria-combobox.js');
      __webpack_require__.d(__webpack_exports__, 'isAriaCombobox', function() {
        return _is_aria_combobox__WEBPACK_IMPORTED_MODULE_0__['default'];
      });
      var _is_aria_listbox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/forms/is-aria-listbox.js');
      __webpack_require__.d(__webpack_exports__, 'isAriaListbox', function() {
        return _is_aria_listbox__WEBPACK_IMPORTED_MODULE_1__['default'];
      });
      var _is_aria_range__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/forms/is-aria-range.js');
      __webpack_require__.d(__webpack_exports__, 'isAriaRange', function() {
        return _is_aria_range__WEBPACK_IMPORTED_MODULE_2__['default'];
      });
      var _is_aria_textbox__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/forms/is-aria-textbox.js');
      __webpack_require__.d(__webpack_exports__, 'isAriaTextbox', function() {
        return _is_aria_textbox__WEBPACK_IMPORTED_MODULE_3__['default'];
      });
      var _is_native_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/forms/is-native-select.js');
      __webpack_require__.d(__webpack_exports__, 'isNativeSelect', function() {
        return _is_native_select__WEBPACK_IMPORTED_MODULE_4__['default'];
      });
      var _is_native_textbox__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/forms/is-native-textbox.js');
      __webpack_require__.d(__webpack_exports__, 'isNativeTextbox', function() {
        return _is_native_textbox__WEBPACK_IMPORTED_MODULE_5__['default'];
      });
      var _is_disabled__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/commons/forms/is-disabled.js');
      __webpack_require__.d(__webpack_exports__, 'isDisabled', function() {
        return _is_disabled__WEBPACK_IMPORTED_MODULE_6__['default'];
      });
    },
    './lib/commons/forms/is-aria-combobox.js': function libCommonsFormsIsAriaComboboxJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _aria_get_explicit_role__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/get-explicit-role.js');
      function isAriaCombobox(node) {
        var role = Object(_aria_get_explicit_role__WEBPACK_IMPORTED_MODULE_0__['default'])(node);
        return role === 'combobox';
      }
      __webpack_exports__['default'] = isAriaCombobox;
    },
    './lib/commons/forms/is-aria-listbox.js': function libCommonsFormsIsAriaListboxJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _aria_get_explicit_role__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/get-explicit-role.js');
      function isAriaListbox(node) {
        var role = Object(_aria_get_explicit_role__WEBPACK_IMPORTED_MODULE_0__['default'])(node);
        return role === 'listbox';
      }
      __webpack_exports__['default'] = isAriaListbox;
    },
    './lib/commons/forms/is-aria-range.js': function libCommonsFormsIsAriaRangeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _aria_get_explicit_role__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/get-explicit-role.js');
      var rangeRoles = [ 'progressbar', 'scrollbar', 'slider', 'spinbutton' ];
      function isAriaRange(node) {
        var role = Object(_aria_get_explicit_role__WEBPACK_IMPORTED_MODULE_0__['default'])(node);
        return rangeRoles.includes(role);
      }
      __webpack_exports__['default'] = isAriaRange;
    },
    './lib/commons/forms/is-aria-textbox.js': function libCommonsFormsIsAriaTextboxJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _aria_get_explicit_role__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/get-explicit-role.js');
      function isAriaTextbox(node) {
        var role = Object(_aria_get_explicit_role__WEBPACK_IMPORTED_MODULE_0__['default'])(node);
        return role === 'textbox';
      }
      __webpack_exports__['default'] = isAriaTextbox;
    },
    './lib/commons/forms/is-disabled.js': function libCommonsFormsIsDisabledJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var disabledNodeNames = [ 'fieldset', 'button', 'select', 'input', 'textarea' ];
      function isDisabled(virtualNode) {
        var disabledState = virtualNode._isDisabled;
        if (typeof disabledState === 'boolean') {
          return disabledState;
        }
        var nodeName = virtualNode.props.nodeName;
        var ariaDisabled = virtualNode.attr('aria-disabled');
        if (disabledNodeNames.includes(nodeName) && virtualNode.hasAttr('disabled')) {
          disabledState = true;
        } else if (ariaDisabled) {
          disabledState = ariaDisabled.toLowerCase() === 'true';
        } else if (virtualNode.parent) {
          disabledState = isDisabled(virtualNode.parent);
        } else {
          disabledState = false;
        }
        virtualNode._isDisabled = disabledState;
        return disabledState;
      }
      __webpack_exports__['default'] = isDisabled;
    },
    './lib/commons/forms/is-native-select.js': function libCommonsFormsIsNativeSelectJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      function isNativeSelect(node) {
        node = node instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_1__['default'] ? node : Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['getNodeFromTree'])(node);
        var nodeName = node.props.nodeName;
        return nodeName === 'select';
      }
      __webpack_exports__['default'] = isNativeSelect;
    },
    './lib/commons/forms/is-native-textbox.js': function libCommonsFormsIsNativeTextboxJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var nonTextInputTypes = [ 'button', 'checkbox', 'color', 'file', 'hidden', 'image', 'password', 'radio', 'reset', 'submit' ];
      function isNativeTextbox(node) {
        node = node instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_1__['default'] ? node : Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['getNodeFromTree'])(node);
        var nodeName = node.props.nodeName;
        return nodeName === 'textarea' || nodeName === 'input' && !nonTextInputTypes.includes((node.attr('type') || '').toLowerCase());
      }
      __webpack_exports__['default'] = isNativeTextbox;
    },
    './lib/commons/index.js': function libCommonsIndexJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      __webpack_require__.d(__webpack_exports__, 'aria', function() {
        return _aria__WEBPACK_IMPORTED_MODULE_0__;
      });
      var _color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/color/index.js');
      __webpack_require__.d(__webpack_exports__, 'color', function() {
        return _color__WEBPACK_IMPORTED_MODULE_1__;
      });
      var _dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/dom/index.js');
      __webpack_require__.d(__webpack_exports__, 'dom', function() {
        return _dom__WEBPACK_IMPORTED_MODULE_2__;
      });
      var _forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/forms/index.js');
      __webpack_require__.d(__webpack_exports__, 'forms', function() {
        return _forms__WEBPACK_IMPORTED_MODULE_3__;
      });
      var _matches__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/matches/index.js');
      __webpack_require__.d(__webpack_exports__, 'matches', function() {
        return _matches__WEBPACK_IMPORTED_MODULE_4__['default'];
      });
      var _standards__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/standards/index.js');
      __webpack_require__.d(__webpack_exports__, 'standards', function() {
        return _standards__WEBPACK_IMPORTED_MODULE_5__;
      });
      var _table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/commons/table/index.js');
      __webpack_require__.d(__webpack_exports__, 'table', function() {
        return _table__WEBPACK_IMPORTED_MODULE_6__;
      });
      var _text__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/commons/text/index.js');
      __webpack_require__.d(__webpack_exports__, 'text', function() {
        return _text__WEBPACK_IMPORTED_MODULE_7__;
      });
      var _core_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__('./lib/core/utils/index.js');
      __webpack_require__.d(__webpack_exports__, 'utils', function() {
        return _core_utils__WEBPACK_IMPORTED_MODULE_8__;
      });
      var commons = {
        aria: _aria__WEBPACK_IMPORTED_MODULE_0__,
        color: _color__WEBPACK_IMPORTED_MODULE_1__,
        dom: _dom__WEBPACK_IMPORTED_MODULE_2__,
        forms: _forms__WEBPACK_IMPORTED_MODULE_3__,
        matches: _matches__WEBPACK_IMPORTED_MODULE_4__['default'],
        standards: _standards__WEBPACK_IMPORTED_MODULE_5__,
        table: _table__WEBPACK_IMPORTED_MODULE_6__,
        text: _text__WEBPACK_IMPORTED_MODULE_7__,
        utils: _core_utils__WEBPACK_IMPORTED_MODULE_8__
      };
    },
    './lib/commons/matches/attributes.js': function libCommonsMatchesAttributesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _from_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/matches/from-function.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function attributes(vNode, matcher) {
        if (!(vNode instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_1__['default'])) {
          vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getNodeFromTree'])(vNode);
        }
        return Object(_from_function__WEBPACK_IMPORTED_MODULE_0__['default'])(function(attrName) {
          return vNode.attr(attrName);
        }, matcher);
      }
      __webpack_exports__['default'] = attributes;
    },
    './lib/commons/matches/condition.js': function libCommonsMatchesConditionJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function condition(arg, condition) {
        return !!condition(arg);
      }
      __webpack_exports__['default'] = condition;
    },
    './lib/commons/matches/explicit-role.js': function libCommonsMatchesExplicitRoleJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _from_primative__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/matches/from-primative.js');
      var _aria_get_explicit_role__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/get-explicit-role.js');
      function explicitRole(vNode, matcher) {
        return Object(_from_primative__WEBPACK_IMPORTED_MODULE_0__['default'])(Object(_aria_get_explicit_role__WEBPACK_IMPORTED_MODULE_1__['default'])(vNode), matcher);
      }
      __webpack_exports__['default'] = explicitRole;
    },
    './lib/commons/matches/from-definition.js': function libCommonsMatchesFromDefinitionJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _attributes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/matches/attributes.js');
      var _condition__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/matches/condition.js');
      var _explicit_role__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/matches/explicit-role.js');
      var _implicit_role__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/matches/implicit-role.js');
      var _node_name__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/matches/node-name.js');
      var _properties__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/matches/properties.js');
      var _semantic_role__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/commons/matches/semantic-role.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__('./lib/core/utils/index.js');
      var matchers = {
        attributes: _attributes__WEBPACK_IMPORTED_MODULE_0__['default'],
        condition: _condition__WEBPACK_IMPORTED_MODULE_1__['default'],
        explicitRole: _explicit_role__WEBPACK_IMPORTED_MODULE_2__['default'],
        implicitRole: _implicit_role__WEBPACK_IMPORTED_MODULE_3__['default'],
        nodeName: _node_name__WEBPACK_IMPORTED_MODULE_4__['default'],
        properties: _properties__WEBPACK_IMPORTED_MODULE_5__['default'],
        semanticRole: _semantic_role__WEBPACK_IMPORTED_MODULE_6__['default']
      };
      function fromDefinition(vNode, definition) {
        if (!(vNode instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_7__['default'])) {
          vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_8__['getNodeFromTree'])(vNode);
        }
        if (Array.isArray(definition)) {
          return definition.some(function(definitionItem) {
            return fromDefinition(vNode, definitionItem);
          });
        }
        if (typeof definition === 'string') {
          return Object(_core_utils__WEBPACK_IMPORTED_MODULE_8__['matches'])(vNode, definition);
        }
        return Object.keys(definition).every(function(matcherName) {
          if (!matchers[matcherName]) {
            throw new Error('Unknown matcher type "'.concat(matcherName, '"'));
          }
          var matchMethod = matchers[matcherName];
          var matcher = definition[matcherName];
          return matchMethod(vNode, matcher);
        });
      }
      __webpack_exports__['default'] = fromDefinition;
    },
    './lib/commons/matches/from-function.js': function libCommonsMatchesFromFunctionJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _from_primative__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/matches/from-primative.js');
      function fromFunction(getValue, matcher) {
        var matcherType = _typeof(matcher);
        if (matcherType !== 'object' || Array.isArray(matcher) || matcher instanceof RegExp) {
          throw new Error('Expect matcher to be an object');
        }
        return Object.keys(matcher).every(function(propName) {
          return Object(_from_primative__WEBPACK_IMPORTED_MODULE_0__['default'])(getValue(propName), matcher[propName]);
        });
      }
      __webpack_exports__['default'] = fromFunction;
    },
    './lib/commons/matches/from-primative.js': function libCommonsMatchesFromPrimativeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function fromPrimative(someString, matcher) {
        var matcherType = _typeof(matcher);
        if (Array.isArray(matcher) && typeof someString !== 'undefined') {
          return matcher.includes(someString);
        }
        if (matcherType === 'function') {
          return !!matcher(someString);
        }
        if (someString !== null && someString !== undefined) {
          if (matcher instanceof RegExp) {
            return matcher.test(someString);
          }
          if (/^\/.*\/$/.test(matcher)) {
            var pattern = matcher.substring(1, matcher.length - 1);
            return new RegExp(pattern).test(someString);
          }
        }
        return matcher === someString;
      }
      __webpack_exports__['default'] = fromPrimative;
    },
    './lib/commons/matches/implicit-role.js': function libCommonsMatchesImplicitRoleJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _from_primative__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/matches/from-primative.js');
      var _aria_implicit_role__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/implicit-role.js');
      function implicitRole(vNode, matcher) {
        return Object(_from_primative__WEBPACK_IMPORTED_MODULE_0__['default'])(Object(_aria_implicit_role__WEBPACK_IMPORTED_MODULE_1__['default'])(vNode), matcher);
      }
      __webpack_exports__['default'] = implicitRole;
    },
    './lib/commons/matches/index.js': function libCommonsMatchesIndexJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _attributes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/matches/attributes.js');
      var _condition__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/matches/condition.js');
      var _explicit_role__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/matches/explicit-role.js');
      var _from_definition__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/matches/from-definition.js');
      var _from_function__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/matches/from-function.js');
      var _from_primative__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/matches/from-primative.js');
      var _implicit_role__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/commons/matches/implicit-role.js');
      var _matches__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/commons/matches/matches.js');
      var _node_name__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__('./lib/commons/matches/node-name.js');
      var _properties__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__('./lib/commons/matches/properties.js');
      var _semantic_role__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__('./lib/commons/matches/semantic-role.js');
      _matches__WEBPACK_IMPORTED_MODULE_7__['default'].attributes = _attributes__WEBPACK_IMPORTED_MODULE_0__['default'];
      _matches__WEBPACK_IMPORTED_MODULE_7__['default'].condition = _condition__WEBPACK_IMPORTED_MODULE_1__['default'];
      _matches__WEBPACK_IMPORTED_MODULE_7__['default'].explicitRole = _explicit_role__WEBPACK_IMPORTED_MODULE_2__['default'];
      _matches__WEBPACK_IMPORTED_MODULE_7__['default'].fromDefinition = _from_definition__WEBPACK_IMPORTED_MODULE_3__['default'];
      _matches__WEBPACK_IMPORTED_MODULE_7__['default'].fromFunction = _from_function__WEBPACK_IMPORTED_MODULE_4__['default'];
      _matches__WEBPACK_IMPORTED_MODULE_7__['default'].fromPrimative = _from_primative__WEBPACK_IMPORTED_MODULE_5__['default'];
      _matches__WEBPACK_IMPORTED_MODULE_7__['default'].implicitRole = _implicit_role__WEBPACK_IMPORTED_MODULE_6__['default'];
      _matches__WEBPACK_IMPORTED_MODULE_7__['default'].nodeName = _node_name__WEBPACK_IMPORTED_MODULE_8__['default'];
      _matches__WEBPACK_IMPORTED_MODULE_7__['default'].properties = _properties__WEBPACK_IMPORTED_MODULE_9__['default'];
      _matches__WEBPACK_IMPORTED_MODULE_7__['default'].semanticRole = _semantic_role__WEBPACK_IMPORTED_MODULE_10__['default'];
      __webpack_exports__['default'] = _matches__WEBPACK_IMPORTED_MODULE_7__['default'];
    },
    './lib/commons/matches/matches.js': function libCommonsMatchesMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _from_definition__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/matches/from-definition.js');
      function matches(vNode, definition) {
        return Object(_from_definition__WEBPACK_IMPORTED_MODULE_0__['default'])(vNode, definition);
      }
      __webpack_exports__['default'] = matches;
    },
    './lib/commons/matches/node-name.js': function libCommonsMatchesNodeNameJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _from_primative__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/matches/from-primative.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function nodeName(vNode, matcher) {
        if (!(vNode instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_1__['default'])) {
          vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getNodeFromTree'])(vNode);
        }
        return Object(_from_primative__WEBPACK_IMPORTED_MODULE_0__['default'])(vNode.props.nodeName, matcher);
      }
      __webpack_exports__['default'] = nodeName;
    },
    './lib/commons/matches/properties.js': function libCommonsMatchesPropertiesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _from_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/matches/from-function.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function properties(vNode, matcher) {
        if (!(vNode instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_1__['default'])) {
          vNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['getNodeFromTree'])(vNode);
        }
        return Object(_from_function__WEBPACK_IMPORTED_MODULE_0__['default'])(function(propName) {
          return vNode.props[propName];
        }, matcher);
      }
      __webpack_exports__['default'] = properties;
    },
    './lib/commons/matches/semantic-role.js': function libCommonsMatchesSemanticRoleJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _from_primative__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/matches/from-primative.js');
      var _aria_get_role__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/get-role.js');
      function semanticRole(vNode, matcher) {
        return Object(_from_primative__WEBPACK_IMPORTED_MODULE_0__['default'])(Object(_aria_get_role__WEBPACK_IMPORTED_MODULE_1__['default'])(vNode), matcher);
      }
      __webpack_exports__['default'] = semanticRole;
    },
    './lib/commons/standards/get-aria-roles-by-type.js': function libCommonsStandardsGetAriaRolesByTypeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      function getAriaRolesByType(type) {
        return Object.keys(_standards__WEBPACK_IMPORTED_MODULE_0__['default'].ariaRoles).filter(function(roleName) {
          return _standards__WEBPACK_IMPORTED_MODULE_0__['default'].ariaRoles[roleName].type === type;
        });
      }
      __webpack_exports__['default'] = getAriaRolesByType;
    },
    './lib/commons/standards/get-aria-roles-supporting-name-from-content.js': function libCommonsStandardsGetAriaRolesSupportingNameFromContentJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_base_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/cache.js');
      var _standards__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/standards/index.js');
      function getAriaRolesSupportingNameFromContent() {
        if (_core_base_cache__WEBPACK_IMPORTED_MODULE_0__['default'].get('ariaRolesNameFromContent')) {
          return _core_base_cache__WEBPACK_IMPORTED_MODULE_0__['default'].get('ariaRolesNameFromContent');
        }
        var contentRoles = Object.keys(_standards__WEBPACK_IMPORTED_MODULE_1__['default'].ariaRoles).filter(function(roleName) {
          return _standards__WEBPACK_IMPORTED_MODULE_1__['default'].ariaRoles[roleName].nameFromContent;
        });
        _core_base_cache__WEBPACK_IMPORTED_MODULE_0__['default'].set('ariaRolesNameFromContent', contentRoles);
        return contentRoles;
      }
      __webpack_exports__['default'] = getAriaRolesSupportingNameFromContent;
    },
    './lib/commons/standards/get-element-spec.js': function libCommonsStandardsGetElementSpecJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      var _commons_matches__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/matches/index.js');
      function getElementSpec(vNode) {
        var standard = _standards__WEBPACK_IMPORTED_MODULE_0__['default'].htmlElms[vNode.props.nodeName];
        if (!standard) {
          return {};
        }
        if (!standard.variant) {
          return standard;
        }
        var variant = standard.variant, spec = _objectWithoutProperties(standard, [ 'variant' ]);
        for (var variantName in variant) {
          if (!variant.hasOwnProperty(variantName) || variantName === 'default') {
            continue;
          }
          var _variant$variantName = variant[variantName], matches = _variant$variantName.matches, props = _objectWithoutProperties(_variant$variantName, [ 'matches' ]);
          if (Object(_commons_matches__WEBPACK_IMPORTED_MODULE_1__['default'])(vNode, matches)) {
            for (var propName in props) {
              if (props.hasOwnProperty(propName)) {
                spec[propName] = props[propName];
              }
            }
          }
        }
        for (var _propName in variant['default']) {
          if (variant['default'].hasOwnProperty(_propName) && typeof spec[_propName] === 'undefined') {
            spec[_propName] = variant['default'][_propName];
          }
        }
        return spec;
      }
      __webpack_exports__['default'] = getElementSpec;
    },
    './lib/commons/standards/get-elements-by-content-type.js': function libCommonsStandardsGetElementsByContentTypeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      function getElementsByContentType(type) {
        return Object.keys(_standards__WEBPACK_IMPORTED_MODULE_0__['default'].htmlElms).filter(function(nodeName) {
          var elm = _standards__WEBPACK_IMPORTED_MODULE_0__['default'].htmlElms[nodeName];
          if (elm.contentTypes) {
            return elm.contentTypes.includes(type);
          }
          if (!elm.variant) {
            return false;
          }
          if (elm.variant['default'] && elm.variant['default'].contentTypes) {
            return elm.variant['default'].contentTypes.includes(type);
          }
          return false;
        });
      }
      __webpack_exports__['default'] = getElementsByContentType;
    },
    './lib/commons/standards/get-global-aria-attrs.js': function libCommonsStandardsGetGlobalAriaAttrsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_base_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/cache.js');
      var _standards__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/standards/index.js');
      function getGlobalAriaAttrs() {
        if (_core_base_cache__WEBPACK_IMPORTED_MODULE_0__['default'].get('globalAriaAttrs')) {
          return _core_base_cache__WEBPACK_IMPORTED_MODULE_0__['default'].get('globalAriaAttrs');
        }
        var globalAttrs = Object.keys(_standards__WEBPACK_IMPORTED_MODULE_1__['default'].ariaAttrs).filter(function(attrName) {
          return _standards__WEBPACK_IMPORTED_MODULE_1__['default'].ariaAttrs[attrName].global;
        });
        _core_base_cache__WEBPACK_IMPORTED_MODULE_0__['default'].set('globalAriaAttrs', globalAttrs);
        return globalAttrs;
      }
      __webpack_exports__['default'] = getGlobalAriaAttrs;
    },
    './lib/commons/standards/implicit-html-roles.js': function libCommonsStandardsImplicitHtmlRolesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_elements_by_content_type__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/standards/get-elements-by-content-type.js');
      var _get_global_aria_attrs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/standards/get-global-aria-attrs.js');
      var _aria_arialabelledby_text__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/aria/arialabelledby-text.js');
      var _aria_arialabel_text__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/aria/arialabel-text.js');
      var _dom_idrefs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/dom/idrefs.js');
      var _table_is_column_header__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/table/is-column-header.js');
      var _table_is_row_header__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/commons/table/is-row-header.js');
      var _text_sanitize__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/commons/text/sanitize.js');
      var _dom_is_focusable__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__('./lib/commons/dom/is-focusable.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__('./lib/core/utils/index.js');
      var _aria_get_explicit_role__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__('./lib/commons/aria/get-explicit-role.js');
      var sectioningElementSelector = Object(_get_elements_by_content_type__WEBPACK_IMPORTED_MODULE_0__['default'])('sectioning').map(function(nodeName) {
        return ''.concat(nodeName, ':not([role])');
      }).join(', ') + ' , main:not([role]), [role=article], [role=complementary], [role=main], [role=navigation], [role=region]';
      function hasAccessibleName(vNode) {
        var ariaLabelledby = Object(_text_sanitize__WEBPACK_IMPORTED_MODULE_7__['default'])(Object(_aria_arialabelledby_text__WEBPACK_IMPORTED_MODULE_2__['default'])(vNode));
        var ariaLabel = Object(_text_sanitize__WEBPACK_IMPORTED_MODULE_7__['default'])(Object(_aria_arialabel_text__WEBPACK_IMPORTED_MODULE_3__['default'])(vNode));
        return !!(ariaLabelledby || ariaLabel);
      }
      var implicitHtmlRoles = {
        a: function a(vNode) {
          return vNode.hasAttr('href') ? 'link' : null;
        },
        area: function area(vNode) {
          return vNode.hasAttr('href') ? 'link' : null;
        },
        article: 'article',
        aside: 'complementary',
        body: 'document',
        button: 'button',
        datalist: 'listbox',
        dd: 'definition',
        dfn: 'term',
        details: 'group',
        dialog: 'dialog',
        dt: 'term',
        fieldset: 'group',
        figure: 'figure',
        footer: function footer(vNode) {
          var sectioningElement = Object(_core_utils__WEBPACK_IMPORTED_MODULE_9__['closest'])(vNode, sectioningElementSelector);
          return !sectioningElement ? 'contentinfo' : null;
        },
        form: function form(vNode) {
          return hasAccessibleName(vNode) ? 'form' : null;
        },
        h1: 'heading',
        h2: 'heading',
        h3: 'heading',
        h4: 'heading',
        h5: 'heading',
        h6: 'heading',
        header: function header(vNode) {
          var sectioningElement = Object(_core_utils__WEBPACK_IMPORTED_MODULE_9__['closest'])(vNode, sectioningElementSelector);
          return !sectioningElement ? 'banner' : null;
        },
        hr: 'separator',
        img: function img(vNode) {
          var emptyAlt = vNode.hasAttr('alt') && !vNode.attr('alt');
          var hasGlobalAria = Object(_get_global_aria_attrs__WEBPACK_IMPORTED_MODULE_1__['default'])().find(function(attr) {
            return vNode.hasAttr(attr);
          });
          return emptyAlt && !hasGlobalAria && !Object(_dom_is_focusable__WEBPACK_IMPORTED_MODULE_8__['default'])(vNode) ? 'presentation' : 'img';
        },
        input: function input(vNode) {
          var suggestionsSourceElement;
          if (vNode.hasAttr('list')) {
            var listElement = Object(_dom_idrefs__WEBPACK_IMPORTED_MODULE_4__['default'])(vNode.actualNode, 'list').filter(function(node) {
              return !!node;
            })[0];
            suggestionsSourceElement = listElement && listElement.nodeName.toLowerCase() === 'datalist';
          }
          switch ((vNode.attr('type') || '').toLowerCase()) {
           case 'button':
           case 'image':
           case 'reset':
           case 'submit':
            return 'button';

           case 'checkbox':
            return 'checkbox';

           case 'email':
           case 'tel':
           case 'text':
           case 'url':
           case '':
            return !suggestionsSourceElement ? 'textbox' : 'combobox';

           case 'number':
            return 'spinbutton';

           case 'radio':
            return 'radio';

           case 'range':
            return 'slider';

           case 'search':
            return !suggestionsSourceElement ? 'searchbox' : 'combobox';
          }
        },
        li: 'listitem',
        main: 'main',
        math: 'math',
        menu: 'list',
        nav: 'navigation',
        ol: 'list',
        optgroup: 'group',
        option: 'option',
        output: 'status',
        progress: 'progressbar',
        section: function section(vNode) {
          return hasAccessibleName(vNode) ? 'region' : null;
        },
        select: function select(vNode) {
          return vNode.hasAttr('multiple') || parseInt(vNode.attr('size')) > 1 ? 'listbox' : 'combobox';
        },
        summary: 'button',
        table: 'table',
        tbody: 'rowgroup',
        td: function td(vNode) {
          var table = Object(_core_utils__WEBPACK_IMPORTED_MODULE_9__['closest'])(vNode, 'table');
          var role = Object(_aria_get_explicit_role__WEBPACK_IMPORTED_MODULE_10__['default'])(table);
          return [ 'grid', 'treegrid' ].includes(role) ? 'gridcell' : 'cell';
        },
        textarea: 'textbox',
        tfoot: 'rowgroup',
        th: function th(vNode) {
          if (Object(_table_is_column_header__WEBPACK_IMPORTED_MODULE_5__['default'])(vNode.actualNode)) {
            return 'columnheader';
          }
          if (Object(_table_is_row_header__WEBPACK_IMPORTED_MODULE_6__['default'])(vNode.actualNode)) {
            return 'rowheader';
          }
        },
        thead: 'rowgroup',
        tr: 'row',
        ul: 'list'
      };
      __webpack_exports__['default'] = implicitHtmlRoles;
    },
    './lib/commons/standards/index.js': function libCommonsStandardsIndexJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_aria_roles_by_type__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/standards/get-aria-roles-by-type.js');
      __webpack_require__.d(__webpack_exports__, 'getAriaRolesByType', function() {
        return _get_aria_roles_by_type__WEBPACK_IMPORTED_MODULE_0__['default'];
      });
      var _get_aria_roles_supporting_name_from_content__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/standards/get-aria-roles-supporting-name-from-content.js');
      __webpack_require__.d(__webpack_exports__, 'getAriaRolesSupportingNameFromContent', function() {
        return _get_aria_roles_supporting_name_from_content__WEBPACK_IMPORTED_MODULE_1__['default'];
      });
      var _get_global_aria_attrs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/standards/get-global-aria-attrs.js');
      __webpack_require__.d(__webpack_exports__, 'getGlobalAriaAttrs', function() {
        return _get_global_aria_attrs__WEBPACK_IMPORTED_MODULE_2__['default'];
      });
      var _get_element_spec__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/standards/get-element-spec.js');
      __webpack_require__.d(__webpack_exports__, 'getElementSpec', function() {
        return _get_element_spec__WEBPACK_IMPORTED_MODULE_3__['default'];
      });
      var _get_elements_by_content_type__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/standards/get-elements-by-content-type.js');
      __webpack_require__.d(__webpack_exports__, 'getElementsByContentType', function() {
        return _get_elements_by_content_type__WEBPACK_IMPORTED_MODULE_4__['default'];
      });
      var _implicit_html_roles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/standards/implicit-html-roles.js');
      __webpack_require__.d(__webpack_exports__, 'implicitHtmlRoles', function() {
        return _implicit_html_roles__WEBPACK_IMPORTED_MODULE_5__['default'];
      });
    },
    './lib/commons/table/get-all-cells.js': function libCommonsTableGetAllCellsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getAllCells(tableElm) {
        var rowIndex, cellIndex, rowLength, cellLength;
        var cells = [];
        for (rowIndex = 0, rowLength = tableElm.rows.length; rowIndex < rowLength; rowIndex++) {
          for (cellIndex = 0, cellLength = tableElm.rows[rowIndex].cells.length; cellIndex < cellLength; cellIndex++) {
            cells.push(tableElm.rows[rowIndex].cells[cellIndex]);
          }
        }
        return cells;
      }
      __webpack_exports__['default'] = getAllCells;
    },
    './lib/commons/table/get-cell-position.js': function libCommonsTableGetCellPositionJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _to_grid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/table/to-grid.js');
      var _dom_find_up__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/find-up.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function getCellPosition(cell, tableGrid) {
        var rowIndex, index;
        if (!tableGrid) {
          tableGrid = Object(_to_grid__WEBPACK_IMPORTED_MODULE_0__['default'])(Object(_dom_find_up__WEBPACK_IMPORTED_MODULE_1__['default'])(cell, 'table'));
        }
        for (rowIndex = 0; rowIndex < tableGrid.length; rowIndex++) {
          if (tableGrid[rowIndex]) {
            index = tableGrid[rowIndex].indexOf(cell);
            if (index !== -1) {
              return {
                x: index,
                y: rowIndex
              };
            }
          }
        }
      }
      __webpack_exports__['default'] = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['memoize'])(getCellPosition);
    },
    './lib/commons/table/get-headers.js': function libCommonsTableGetHeadersJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _is_row_header__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/table/is-row-header.js');
      var _is_column_header__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/table/is-column-header.js');
      var _to_grid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/table/to-grid.js');
      var _get_cell_position__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/table/get-cell-position.js');
      var _dom_idrefs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/dom/idrefs.js');
      var _dom_find_up__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/dom/find-up.js');
      function traverseForHeaders(headerType, position, tableGrid) {
        var property = headerType === 'row' ? '_rowHeaders' : '_colHeaders';
        var predicate = headerType === 'row' ? _is_row_header__WEBPACK_IMPORTED_MODULE_0__['default'] : _is_column_header__WEBPACK_IMPORTED_MODULE_1__['default'];
        var rowEnd = headerType === 'row' ? position.y : 0;
        var colEnd = headerType === 'row' ? 0 : position.x;
        var headers;
        var cells = [];
        for (var row = position.y; row >= rowEnd && !headers; row--) {
          for (var col = position.x; col >= colEnd; col--) {
            var cell = tableGrid[row] ? tableGrid[row][col] : undefined;
            if (!cell) {
              continue;
            }
            var vNode = axe.utils.getNodeFromTree(cell);
            if (vNode[property]) {
              headers = vNode[property];
              break;
            }
            cells.push(cell);
          }
        }
        headers = (headers || []).concat(cells.filter(predicate));
        cells.forEach(function(tableCell) {
          var vNode = axe.utils.getNodeFromTree(tableCell);
          vNode[property] = headers;
        });
        return headers;
      }
      function getHeaders(cell, tableGrid) {
        if (cell.getAttribute('headers')) {
          var headers = Object(_dom_idrefs__WEBPACK_IMPORTED_MODULE_4__['default'])(cell, 'headers');
          if (headers.filter(function(header) {
            return header;
          }).length) {
            return headers;
          }
        }
        if (!tableGrid) {
          tableGrid = Object(_to_grid__WEBPACK_IMPORTED_MODULE_2__['default'])(Object(_dom_find_up__WEBPACK_IMPORTED_MODULE_5__['default'])(cell, 'table'));
        }
        var position = Object(_get_cell_position__WEBPACK_IMPORTED_MODULE_3__['default'])(cell, tableGrid);
        var rowHeaders = traverseForHeaders('row', position, tableGrid);
        var colHeaders = traverseForHeaders('col', position, tableGrid);
        return [].concat(rowHeaders, colHeaders).reverse();
      }
      __webpack_exports__['default'] = getHeaders;
    },
    './lib/commons/table/get-scope.js': function libCommonsTableGetScopeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _to_grid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/table/to-grid.js');
      var _get_cell_position__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/table/get-cell-position.js');
      var _dom_find_up__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/dom/find-up.js');
      function getScope(cell) {
        var scope = cell.getAttribute('scope');
        var role = cell.getAttribute('role');
        if (cell instanceof window.Element === false || [ 'TD', 'TH' ].indexOf(cell.nodeName.toUpperCase()) === -1) {
          throw new TypeError('Expected TD or TH element');
        }
        if (role === 'columnheader') {
          return 'col';
        } else if (role === 'rowheader') {
          return 'row';
        } else if (scope === 'col' || scope === 'row') {
          return scope;
        } else if (cell.nodeName.toUpperCase() !== 'TH') {
          return false;
        }
        var tableGrid = Object(_to_grid__WEBPACK_IMPORTED_MODULE_0__['default'])(Object(_dom_find_up__WEBPACK_IMPORTED_MODULE_2__['default'])(cell, 'table'));
        var pos = Object(_get_cell_position__WEBPACK_IMPORTED_MODULE_1__['default'])(cell, tableGrid);
        var headerRow = tableGrid[pos.y].reduce(function(headerRow, cell) {
          return headerRow && cell.nodeName.toUpperCase() === 'TH';
        }, true);
        if (headerRow) {
          return 'col';
        }
        var headerCol = tableGrid.map(function(col) {
          return col[pos.x];
        }).reduce(function(headerCol, cell) {
          return headerCol && cell && cell.nodeName.toUpperCase() === 'TH';
        }, true);
        if (headerCol) {
          return 'row';
        }
        return 'auto';
      }
      __webpack_exports__['default'] = getScope;
    },
    './lib/commons/table/index.js': function libCommonsTableIndexJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_all_cells__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/table/get-all-cells.js');
      __webpack_require__.d(__webpack_exports__, 'getAllCells', function() {
        return _get_all_cells__WEBPACK_IMPORTED_MODULE_0__['default'];
      });
      var _get_cell_position__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/table/get-cell-position.js');
      __webpack_require__.d(__webpack_exports__, 'getCellPosition', function() {
        return _get_cell_position__WEBPACK_IMPORTED_MODULE_1__['default'];
      });
      var _get_headers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/table/get-headers.js');
      __webpack_require__.d(__webpack_exports__, 'getHeaders', function() {
        return _get_headers__WEBPACK_IMPORTED_MODULE_2__['default'];
      });
      var _get_scope__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/table/get-scope.js');
      __webpack_require__.d(__webpack_exports__, 'getScope', function() {
        return _get_scope__WEBPACK_IMPORTED_MODULE_3__['default'];
      });
      var _is_column_header__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/table/is-column-header.js');
      __webpack_require__.d(__webpack_exports__, 'isColumnHeader', function() {
        return _is_column_header__WEBPACK_IMPORTED_MODULE_4__['default'];
      });
      var _is_data_cell__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/table/is-data-cell.js');
      __webpack_require__.d(__webpack_exports__, 'isDataCell', function() {
        return _is_data_cell__WEBPACK_IMPORTED_MODULE_5__['default'];
      });
      var _is_data_table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/commons/table/is-data-table.js');
      __webpack_require__.d(__webpack_exports__, 'isDataTable', function() {
        return _is_data_table__WEBPACK_IMPORTED_MODULE_6__['default'];
      });
      var _is_header__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/commons/table/is-header.js');
      __webpack_require__.d(__webpack_exports__, 'isHeader', function() {
        return _is_header__WEBPACK_IMPORTED_MODULE_7__['default'];
      });
      var _is_row_header__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__('./lib/commons/table/is-row-header.js');
      __webpack_require__.d(__webpack_exports__, 'isRowHeader', function() {
        return _is_row_header__WEBPACK_IMPORTED_MODULE_8__['default'];
      });
      var _to_grid__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__('./lib/commons/table/to-grid.js');
      __webpack_require__.d(__webpack_exports__, 'toGrid', function() {
        return _to_grid__WEBPACK_IMPORTED_MODULE_9__['default'];
      });
      var _traverse__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__('./lib/commons/table/traverse.js');
      __webpack_require__.d(__webpack_exports__, 'traverse', function() {
        return _traverse__WEBPACK_IMPORTED_MODULE_10__['default'];
      });
      __webpack_require__.d(__webpack_exports__, 'toArray', function() {
        return _to_grid__WEBPACK_IMPORTED_MODULE_9__['default'];
      });
    },
    './lib/commons/table/is-column-header.js': function libCommonsTableIsColumnHeaderJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_scope__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/table/get-scope.js');
      function isColumnHeader(element) {
        return [ 'col', 'auto' ].indexOf(Object(_get_scope__WEBPACK_IMPORTED_MODULE_0__['default'])(element)) !== -1;
      }
      __webpack_exports__['default'] = isColumnHeader;
    },
    './lib/commons/table/is-data-cell.js': function libCommonsTableIsDataCellJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _aria_is_valid_role__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/is-valid-role.js');
      function isDataCell(cell) {
        if (!cell.children.length && !cell.textContent.trim()) {
          return false;
        }
        var role = cell.getAttribute('role');
        if (Object(_aria_is_valid_role__WEBPACK_IMPORTED_MODULE_0__['default'])(role)) {
          return [ 'cell', 'gridcell' ].includes(role);
        } else {
          return cell.nodeName.toUpperCase() === 'TD';
        }
      }
      __webpack_exports__['default'] = isDataCell;
    },
    './lib/commons/table/is-data-table.js': function libCommonsTableIsDataTableJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _aria_get_role_type__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/get-role-type.js');
      var _dom_is_focusable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/is-focusable.js');
      var _dom_find_up__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/dom/find-up.js');
      var _dom_get_element_coordinates__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/dom/get-element-coordinates.js');
      var _dom_get_viewport_size__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/dom/get-viewport-size.js');
      function isDataTable(node) {
        var role = (node.getAttribute('role') || '').toLowerCase();
        if ((role === 'presentation' || role === 'none') && !Object(_dom_is_focusable__WEBPACK_IMPORTED_MODULE_1__['default'])(node)) {
          return false;
        }
        if (node.getAttribute('contenteditable') === 'true' || Object(_dom_find_up__WEBPACK_IMPORTED_MODULE_2__['default'])(node, '[contenteditable="true"]')) {
          return true;
        }
        if (role === 'grid' || role === 'treegrid' || role === 'table') {
          return true;
        }
        if (Object(_aria_get_role_type__WEBPACK_IMPORTED_MODULE_0__['default'])(role) === 'landmark') {
          return true;
        }
        if (node.getAttribute('datatable') === '0') {
          return false;
        }
        if (node.getAttribute('summary')) {
          return true;
        }
        if (node.tHead || node.tFoot || node.caption) {
          return true;
        }
        for (var childIndex = 0, childLength = node.children.length; childIndex < childLength; childIndex++) {
          if (node.children[childIndex].nodeName.toUpperCase() === 'COLGROUP') {
            return true;
          }
        }
        var cells = 0;
        var rowLength = node.rows.length;
        var row, cell;
        var hasBorder = false;
        for (var rowIndex = 0; rowIndex < rowLength; rowIndex++) {
          row = node.rows[rowIndex];
          for (var cellIndex = 0, cellLength = row.cells.length; cellIndex < cellLength; cellIndex++) {
            cell = row.cells[cellIndex];
            if (cell.nodeName.toUpperCase() === 'TH') {
              return true;
            }
            if (!hasBorder && (cell.offsetWidth !== cell.clientWidth || cell.offsetHeight !== cell.clientHeight)) {
              hasBorder = true;
            }
            if (cell.getAttribute('scope') || cell.getAttribute('headers') || cell.getAttribute('abbr')) {
              return true;
            }
            if ([ 'columnheader', 'rowheader' ].includes((cell.getAttribute('role') || '').toLowerCase())) {
              return true;
            }
            if (cell.children.length === 1 && cell.children[0].nodeName.toUpperCase() === 'ABBR') {
              return true;
            }
            cells++;
          }
        }
        if (node.getElementsByTagName('table').length) {
          return false;
        }
        if (rowLength < 2) {
          return false;
        }
        var sampleRow = node.rows[Math.ceil(rowLength / 2)];
        if (sampleRow.cells.length === 1 && sampleRow.cells[0].colSpan === 1) {
          return false;
        }
        if (sampleRow.cells.length >= 5) {
          return true;
        }
        if (hasBorder) {
          return true;
        }
        var bgColor, bgImage;
        for (rowIndex = 0; rowIndex < rowLength; rowIndex++) {
          row = node.rows[rowIndex];
          if (bgColor && bgColor !== window.getComputedStyle(row).getPropertyValue('background-color')) {
            return true;
          } else {
            bgColor = window.getComputedStyle(row).getPropertyValue('background-color');
          }
          if (bgImage && bgImage !== window.getComputedStyle(row).getPropertyValue('background-image')) {
            return true;
          } else {
            bgImage = window.getComputedStyle(row).getPropertyValue('background-image');
          }
        }
        if (rowLength >= 20) {
          return true;
        }
        if (Object(_dom_get_element_coordinates__WEBPACK_IMPORTED_MODULE_3__['default'])(node).width > Object(_dom_get_viewport_size__WEBPACK_IMPORTED_MODULE_4__['default'])(window).width * .95) {
          return false;
        }
        if (cells < 10) {
          return false;
        }
        if (node.querySelector('object, embed, iframe, applet')) {
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = isDataTable;
    },
    './lib/commons/table/is-header.js': function libCommonsTableIsHeaderJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _is_column_header__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/table/is-column-header.js');
      var _is_row_header__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/table/is-row-header.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function isHeader(cell) {
        if (Object(_is_column_header__WEBPACK_IMPORTED_MODULE_0__['default'])(cell) || Object(_is_row_header__WEBPACK_IMPORTED_MODULE_1__['default'])(cell)) {
          return true;
        }
        if (cell.getAttribute('id')) {
          var id = Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['escapeSelector'])(cell.getAttribute('id'));
          return !!document.querySelector('[headers~="'.concat(id, '"]'));
        }
        return false;
      }
      __webpack_exports__['default'] = isHeader;
    },
    './lib/commons/table/is-row-header.js': function libCommonsTableIsRowHeaderJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_scope__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/table/get-scope.js');
      function isRowHeader(cell) {
        return [ 'row', 'auto' ].includes(Object(_get_scope__WEBPACK_IMPORTED_MODULE_0__['default'])(cell));
      }
      __webpack_exports__['default'] = isRowHeader;
    },
    './lib/commons/table/to-grid.js': function libCommonsTableToGridJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function toGrid(node) {
        var table = [];
        var rows = node.rows;
        for (var i = 0, rowLength = rows.length; i < rowLength; i++) {
          var cells = rows[i].cells;
          table[i] = table[i] || [];
          var columnIndex = 0;
          for (var j = 0, cellLength = cells.length; j < cellLength; j++) {
            for (var colSpan = 0; colSpan < cells[j].colSpan; colSpan++) {
              for (var rowSpan = 0; rowSpan < cells[j].rowSpan; rowSpan++) {
                table[i + rowSpan] = table[i + rowSpan] || [];
                while (table[i + rowSpan][columnIndex]) {
                  columnIndex++;
                }
                table[i + rowSpan][columnIndex] = cells[j];
              }
              columnIndex++;
            }
          }
        }
        return table;
      }
      __webpack_exports__['default'] = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['memoize'])(toGrid);
    },
    './lib/commons/table/traverse.js': function libCommonsTableTraverseJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function traverseTable(dir, position, tableGrid, callback) {
        var result;
        var cell = tableGrid[position.y] ? tableGrid[position.y][position.x] : undefined;
        if (!cell) {
          return [];
        }
        if (typeof callback === 'function') {
          result = callback(cell, position, tableGrid);
          if (result === true) {
            return [ cell ];
          }
        }
        result = traverseTable(dir, {
          x: position.x + dir.x,
          y: position.y + dir.y
        }, tableGrid, callback);
        result.unshift(cell);
        return result;
      }
      function traverse(dir, startPos, tableGrid, callback) {
        if (Array.isArray(startPos)) {
          callback = tableGrid;
          tableGrid = startPos;
          startPos = {
            x: 0,
            y: 0
          };
        }
        if (typeof dir === 'string') {
          switch (dir) {
           case 'left':
            dir = {
              x: -1,
              y: 0
            };
            break;

           case 'up':
            dir = {
              x: 0,
              y: -1
            };
            break;

           case 'right':
            dir = {
              x: 1,
              y: 0
            };
            break;

           case 'down':
            dir = {
              x: 0,
              y: 1
            };
            break;
          }
        }
        return traverseTable(dir, {
          x: startPos.x + dir.x,
          y: startPos.y + dir.y
        }, tableGrid, callback);
      }
      __webpack_exports__['default'] = traverse;
    },
    './lib/commons/text/accessible-text-virtual.js': function libCommonsTextAccessibleTextVirtualJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _aria_arialabelledby_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/arialabelledby-text.js');
      var _aria_arialabel_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/arialabel-text.js');
      var _native_text_alternative__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/text/native-text-alternative.js');
      var _form_control_value__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/text/form-control-value.js');
      var _subtree_text__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/text/subtree-text.js');
      var _title_text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/text/title-text.js');
      var _sanitize__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/commons/text/sanitize.js');
      var _dom_is_visible__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/commons/dom/is-visible.js');
      function accessibleTextVirtual(virtualNode) {
        var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var actualNode = virtualNode.actualNode;
        context = prepareContext(virtualNode, context);
        if (shouldIgnoreHidden(virtualNode, context)) {
          return '';
        }
        var computationSteps = [ _aria_arialabelledby_text__WEBPACK_IMPORTED_MODULE_0__['default'], _aria_arialabel_text__WEBPACK_IMPORTED_MODULE_1__['default'], _native_text_alternative__WEBPACK_IMPORTED_MODULE_2__['default'], _form_control_value__WEBPACK_IMPORTED_MODULE_3__['default'], _subtree_text__WEBPACK_IMPORTED_MODULE_4__['default'], textNodeValue, _title_text__WEBPACK_IMPORTED_MODULE_5__['default'] ];
        var accName = computationSteps.reduce(function(accName, step) {
          if (context.startNode === virtualNode) {
            accName = Object(_sanitize__WEBPACK_IMPORTED_MODULE_6__['default'])(accName);
          }
          if (accName !== '') {
            return accName;
          }
          return step(virtualNode, context);
        }, '');
        if (context.debug) {
          axe.log(accName || '{empty-value}', actualNode, context);
        }
        return accName;
      }
      function textNodeValue(virtualNode) {
        if (virtualNode.props.nodeType !== 3) {
          return '';
        }
        return virtualNode.props.nodeValue;
      }
      function shouldIgnoreHidden(_ref46, context) {
        var actualNode = _ref46.actualNode;
        if (!actualNode) {
          return false;
        }
        if (actualNode.nodeType !== 1 || context.includeHidden) {
          return false;
        }
        return !Object(_dom_is_visible__WEBPACK_IMPORTED_MODULE_7__['default'])(actualNode, true);
      }
      function prepareContext(virtualNode, context) {
        var actualNode = virtualNode.actualNode;
        if (!context.startNode) {
          context = _extends({
            startNode: virtualNode
          }, context);
        }
        if (!actualNode) {
          return context;
        }
        if (actualNode.nodeType === 1 && context.inLabelledByContext && context.includeHidden === undefined) {
          context = _extends({
            includeHidden: !Object(_dom_is_visible__WEBPACK_IMPORTED_MODULE_7__['default'])(actualNode, true)
          }, context);
        }
        return context;
      }
      accessibleTextVirtual.alreadyProcessed = function alreadyProcessed(virtualnode, context) {
        context.processed = context.processed || [];
        if (context.processed.includes(virtualnode)) {
          return true;
        }
        context.processed.push(virtualnode);
        return false;
      };
      __webpack_exports__['default'] = accessibleTextVirtual;
    },
    './lib/commons/text/accessible-text.js': function libCommonsTextAccessibleTextJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _accessible_text_virtual__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/accessible-text-virtual.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function accessibleText(element, context) {
        var virtualNode = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeFromTree'])(element);
        return Object(_accessible_text_virtual__WEBPACK_IMPORTED_MODULE_0__['default'])(virtualNode, context);
      }
      __webpack_exports__['default'] = accessibleText;
    },
    './lib/commons/text/form-control-value.js': function libCommonsTextFormControlValueJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'formControlValueMethods', function() {
        return formControlValueMethods;
      });
      var _aria_get_role__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/get-role.js');
      var _unsupported__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/unsupported.js');
      var _visible_virtual__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/text/visible-virtual.js');
      var _accessible_text_virtual__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/text/accessible-text-virtual.js');
      var _forms_is_native_textbox__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/forms/is-native-textbox.js');
      var _forms_is_native_select__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/forms/is-native-select.js');
      var _forms_is_aria_textbox__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/commons/forms/is-aria-textbox.js');
      var _forms_is_aria_listbox__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/commons/forms/is-aria-listbox.js');
      var _forms_is_aria_combobox__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__('./lib/commons/forms/is-aria-combobox.js');
      var _forms_is_aria_range__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__('./lib/commons/forms/is-aria-range.js');
      var _aria_get_owned_virtual__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__('./lib/commons/aria/get-owned-virtual.js');
      var _dom_is_hidden_with_css__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__('./lib/commons/dom/is-hidden-with-css.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__('./lib/core/utils/index.js');
      var _core_log__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__('./lib/core/log.js');
      var controlValueRoles = [ 'textbox', 'progressbar', 'scrollbar', 'slider', 'spinbutton', 'combobox', 'listbox' ];
      var formControlValueMethods = {
        nativeTextboxValue: nativeTextboxValue,
        nativeSelectValue: nativeSelectValue,
        ariaTextboxValue: ariaTextboxValue,
        ariaListboxValue: ariaListboxValue,
        ariaComboboxValue: ariaComboboxValue,
        ariaRangeValue: ariaRangeValue
      };
      function formControlValue(virtualNode) {
        var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var actualNode = virtualNode.actualNode;
        var unsupportedRoles = _unsupported__WEBPACK_IMPORTED_MODULE_1__['default'].accessibleNameFromFieldValue || [];
        var role = Object(_aria_get_role__WEBPACK_IMPORTED_MODULE_0__['default'])(virtualNode);
        if (context.startNode === virtualNode || !controlValueRoles.includes(role) || unsupportedRoles.includes(role)) {
          return '';
        }
        var valueMethods = Object.keys(formControlValueMethods).map(function(name) {
          return formControlValueMethods[name];
        });
        var valueString = valueMethods.reduce(function(accName, step) {
          return accName || step(virtualNode, context);
        }, '');
        if (context.debug) {
          Object(_core_log__WEBPACK_IMPORTED_MODULE_14__['default'])(valueString || '{empty-value}', actualNode, context);
        }
        return valueString;
      }
      function nativeTextboxValue(node) {
        var vNode = node instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_12__['default'] ? node : Object(_core_utils__WEBPACK_IMPORTED_MODULE_13__['getNodeFromTree'])(node);
        if (Object(_forms_is_native_textbox__WEBPACK_IMPORTED_MODULE_4__['default'])(vNode)) {
          return vNode.props.value || '';
        }
        return '';
      }
      function nativeSelectValue(node) {
        var vNode = node instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_12__['default'] ? node : Object(_core_utils__WEBPACK_IMPORTED_MODULE_13__['getNodeFromTree'])(node);
        if (!Object(_forms_is_native_select__WEBPACK_IMPORTED_MODULE_5__['default'])(vNode)) {
          return '';
        }
        var options = Object(_core_utils__WEBPACK_IMPORTED_MODULE_13__['querySelectorAll'])(vNode, 'option');
        var selectedOptions = options.filter(function(option) {
          return option.hasAttr('selected');
        });
        if (!selectedOptions.length) {
          selectedOptions.push(options[0]);
        }
        return selectedOptions.map(function(option) {
          return Object(_visible_virtual__WEBPACK_IMPORTED_MODULE_2__['default'])(option);
        }).join(' ') || '';
      }
      function ariaTextboxValue(node) {
        var vNode = node instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_12__['default'] ? node : Object(_core_utils__WEBPACK_IMPORTED_MODULE_13__['getNodeFromTree'])(node);
        var actualNode = vNode.actualNode;
        if (!Object(_forms_is_aria_textbox__WEBPACK_IMPORTED_MODULE_6__['default'])(vNode)) {
          return '';
        }
        if (!actualNode || actualNode && !Object(_dom_is_hidden_with_css__WEBPACK_IMPORTED_MODULE_11__['default'])(actualNode)) {
          return Object(_visible_virtual__WEBPACK_IMPORTED_MODULE_2__['default'])(vNode, true);
        } else {
          return actualNode.textContent;
        }
      }
      function ariaListboxValue(node, context) {
        var vNode = node instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_12__['default'] ? node : Object(_core_utils__WEBPACK_IMPORTED_MODULE_13__['getNodeFromTree'])(node);
        if (!Object(_forms_is_aria_listbox__WEBPACK_IMPORTED_MODULE_7__['default'])(vNode)) {
          return '';
        }
        var selected = Object(_aria_get_owned_virtual__WEBPACK_IMPORTED_MODULE_10__['default'])(vNode).filter(function(owned) {
          return Object(_aria_get_role__WEBPACK_IMPORTED_MODULE_0__['default'])(owned) === 'option' && owned.attr('aria-selected') === 'true';
        });
        if (selected.length === 0) {
          return '';
        }
        return Object(_accessible_text_virtual__WEBPACK_IMPORTED_MODULE_3__['default'])(selected[0], context);
      }
      function ariaComboboxValue(node, context) {
        var vNode = node instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_12__['default'] ? node : Object(_core_utils__WEBPACK_IMPORTED_MODULE_13__['getNodeFromTree'])(node);
        var listbox;
        if (!Object(_forms_is_aria_combobox__WEBPACK_IMPORTED_MODULE_8__['default'])(vNode)) {
          return '';
        }
        listbox = Object(_aria_get_owned_virtual__WEBPACK_IMPORTED_MODULE_10__['default'])(vNode).filter(function(elm) {
          return Object(_aria_get_role__WEBPACK_IMPORTED_MODULE_0__['default'])(elm) === 'listbox';
        })[0];
        return listbox ? ariaListboxValue(listbox, context) : '';
      }
      function ariaRangeValue(node) {
        var vNode = node instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_12__['default'] ? node : Object(_core_utils__WEBPACK_IMPORTED_MODULE_13__['getNodeFromTree'])(node);
        if (!Object(_forms_is_aria_range__WEBPACK_IMPORTED_MODULE_9__['default'])(vNode) || !vNode.hasAttr('aria-valuenow')) {
          return '';
        }
        var valueNow = +vNode.attr('aria-valuenow');
        return !isNaN(valueNow) ? String(valueNow) : '0';
      }
      __webpack_exports__['default'] = formControlValue;
    },
    './lib/commons/text/has-unicode.js': function libCommonsTextHasUnicodeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _unicode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/unicode.js');
      var emoji_regex__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./node_modules/emoji-regex/index.js');
      var emoji_regex__WEBPACK_IMPORTED_MODULE_1___default = __webpack_require__.n(emoji_regex__WEBPACK_IMPORTED_MODULE_1__);
      function hasUnicode(str, options) {
        var emoji = options.emoji, nonBmp = options.nonBmp, punctuations = options.punctuations;
        if (emoji) {
          return emoji_regex__WEBPACK_IMPORTED_MODULE_1___default()().test(str);
        }
        if (nonBmp) {
          return Object(_unicode__WEBPACK_IMPORTED_MODULE_0__['getUnicodeNonBmpRegExp'])().test(str) || Object(_unicode__WEBPACK_IMPORTED_MODULE_0__['getSupplementaryPrivateUseRegExp'])().test(str);
        }
        if (punctuations) {
          return Object(_unicode__WEBPACK_IMPORTED_MODULE_0__['getPunctuationRegExp'])().test(str);
        }
        return false;
      }
      __webpack_exports__['default'] = hasUnicode;
    },
    './lib/commons/text/index.js': function libCommonsTextIndexJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _accessible_text_virtual__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/accessible-text-virtual.js');
      __webpack_require__.d(__webpack_exports__, 'accessibleTextVirtual', function() {
        return _accessible_text_virtual__WEBPACK_IMPORTED_MODULE_0__['default'];
      });
      var _accessible_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/accessible-text.js');
      __webpack_require__.d(__webpack_exports__, 'accessibleText', function() {
        return _accessible_text__WEBPACK_IMPORTED_MODULE_1__['default'];
      });
      var _form_control_value__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/text/form-control-value.js');
      __webpack_require__.d(__webpack_exports__, 'formControlValue', function() {
        return _form_control_value__WEBPACK_IMPORTED_MODULE_2__['default'];
      });
      __webpack_require__.d(__webpack_exports__, 'formControlValueMethods', function() {
        return _form_control_value__WEBPACK_IMPORTED_MODULE_2__['formControlValueMethods'];
      });
      var _has_unicode__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/text/has-unicode.js');
      __webpack_require__.d(__webpack_exports__, 'hasUnicode', function() {
        return _has_unicode__WEBPACK_IMPORTED_MODULE_3__['default'];
      });
      var _is_human_interpretable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/commons/text/is-human-interpretable.js');
      __webpack_require__.d(__webpack_exports__, 'isHumanInterpretable', function() {
        return _is_human_interpretable__WEBPACK_IMPORTED_MODULE_4__['default'];
      });
      var _is_icon_ligature__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/commons/text/is-icon-ligature.js');
      __webpack_require__.d(__webpack_exports__, 'isIconLigature', function() {
        return _is_icon_ligature__WEBPACK_IMPORTED_MODULE_5__['default'];
      });
      var _is_valid_autocomplete__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/commons/text/is-valid-autocomplete.js');
      __webpack_require__.d(__webpack_exports__, 'isValidAutocomplete', function() {
        return _is_valid_autocomplete__WEBPACK_IMPORTED_MODULE_6__['default'];
      });
      __webpack_require__.d(__webpack_exports__, 'autocomplete', function() {
        return _is_valid_autocomplete__WEBPACK_IMPORTED_MODULE_6__['autocomplete'];
      });
      var _label_text__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/commons/text/label-text.js');
      __webpack_require__.d(__webpack_exports__, 'labelText', function() {
        return _label_text__WEBPACK_IMPORTED_MODULE_7__['default'];
      });
      var _label_virtual__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__('./lib/commons/text/label-virtual.js');
      __webpack_require__.d(__webpack_exports__, 'labelVirtual', function() {
        return _label_virtual__WEBPACK_IMPORTED_MODULE_8__['default'];
      });
      var _label__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__('./lib/commons/text/label.js');
      __webpack_require__.d(__webpack_exports__, 'label', function() {
        return _label__WEBPACK_IMPORTED_MODULE_9__['default'];
      });
      var _native_element_type__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__('./lib/commons/text/native-element-type.js');
      __webpack_require__.d(__webpack_exports__, 'nativeElementType', function() {
        return _native_element_type__WEBPACK_IMPORTED_MODULE_10__['default'];
      });
      var _native_text_alternative__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__('./lib/commons/text/native-text-alternative.js');
      __webpack_require__.d(__webpack_exports__, 'nativeTextAlternative', function() {
        return _native_text_alternative__WEBPACK_IMPORTED_MODULE_11__['default'];
      });
      var _native_text_methods__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__('./lib/commons/text/native-text-methods.js');
      __webpack_require__.d(__webpack_exports__, 'nativeTextMethods', function() {
        return _native_text_methods__WEBPACK_IMPORTED_MODULE_12__['default'];
      });
      var _remove_unicode__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__('./lib/commons/text/remove-unicode.js');
      __webpack_require__.d(__webpack_exports__, 'removeUnicode', function() {
        return _remove_unicode__WEBPACK_IMPORTED_MODULE_13__['default'];
      });
      var _sanitize__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__('./lib/commons/text/sanitize.js');
      __webpack_require__.d(__webpack_exports__, 'sanitize', function() {
        return _sanitize__WEBPACK_IMPORTED_MODULE_14__['default'];
      });
      var _subtree_text__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__('./lib/commons/text/subtree-text.js');
      __webpack_require__.d(__webpack_exports__, 'subtreeText', function() {
        return _subtree_text__WEBPACK_IMPORTED_MODULE_15__['default'];
      });
      var _title_text__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__('./lib/commons/text/title-text.js');
      __webpack_require__.d(__webpack_exports__, 'titleText', function() {
        return _title_text__WEBPACK_IMPORTED_MODULE_16__['default'];
      });
      var _unsupported__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__('./lib/commons/text/unsupported.js');
      __webpack_require__.d(__webpack_exports__, 'unsupported', function() {
        return _unsupported__WEBPACK_IMPORTED_MODULE_17__['default'];
      });
      var _visible_text_nodes__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__('./lib/commons/text/visible-text-nodes.js');
      __webpack_require__.d(__webpack_exports__, 'visibleTextNodes', function() {
        return _visible_text_nodes__WEBPACK_IMPORTED_MODULE_18__['default'];
      });
      var _visible_virtual__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__('./lib/commons/text/visible-virtual.js');
      __webpack_require__.d(__webpack_exports__, 'visibleVirtual', function() {
        return _visible_virtual__WEBPACK_IMPORTED_MODULE_19__['default'];
      });
      var _visible__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__('./lib/commons/text/visible.js');
      __webpack_require__.d(__webpack_exports__, 'visible', function() {
        return _visible__WEBPACK_IMPORTED_MODULE_20__['default'];
      });
    },
    './lib/commons/text/is-human-interpretable.js': function libCommonsTextIsHumanInterpretableJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _remove_unicode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/remove-unicode.js');
      var _sanitize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/sanitize.js');
      function isHumanInterpretable(str) {
        if (!str.length) {
          return 0;
        }
        var alphaNumericIconMap = [ 'x', 'i' ];
        if (alphaNumericIconMap.includes(str)) {
          return 0;
        }
        var noUnicodeStr = Object(_remove_unicode__WEBPACK_IMPORTED_MODULE_0__['default'])(str, {
          emoji: true,
          nonBmp: true,
          punctuations: true
        });
        if (!Object(_sanitize__WEBPACK_IMPORTED_MODULE_1__['default'])(noUnicodeStr)) {
          return 0;
        }
        return 1;
      }
      __webpack_exports__['default'] = isHumanInterpretable;
    },
    './lib/commons/text/is-icon-ligature.js': function libCommonsTextIsIconLigatureJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _sanitize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/sanitize.js');
      var _has_unicode__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/has-unicode.js');
      var _core_base_cache__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/base/cache.js');
      function isIconLigature(textVNode) {
        var differenceThreshold = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : .15;
        var occuranceThreshold = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 3;
        var nodeValue = textVNode.actualNode.nodeValue.trim();
        if (!Object(_sanitize__WEBPACK_IMPORTED_MODULE_0__['default'])(nodeValue) || Object(_has_unicode__WEBPACK_IMPORTED_MODULE_1__['default'])(nodeValue, {
          emoji: true,
          nonBmp: true
        })) {
          return false;
        }
        if (!_core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].get('canvasContext')) {
          _core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].set('canvasContext', document.createElement('canvas').getContext('2d'));
        }
        var canvasContext = _core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].get('canvasContext');
        var canvas = canvasContext.canvas;
        if (!_core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].get('fonts')) {
          _core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].set('fonts', {});
        }
        var fonts = _core_base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].get('fonts');
        var style = window.getComputedStyle(textVNode.parent.actualNode);
        var fontFamily = style.getPropertyValue('font-family');
        if (!fonts[fontFamily]) {
          fonts[fontFamily] = {
            occurances: 0,
            numLigatures: 0
          };
        }
        var font = fonts[fontFamily];
        if (font.occurances >= occuranceThreshold) {
          if (font.numLigatures / font.occurances === 1) {
            return true;
          } else if (font.numLigatures === 0) {
            return false;
          }
        }
        font.occurances++;
        var fontSize = 30;
        var fontStyle = ''.concat(fontSize, 'px ').concat(fontFamily);
        canvasContext.font = fontStyle;
        var firstChar = nodeValue.charAt(0);
        var width = canvasContext.measureText(firstChar).width;
        if (width < 30) {
          var diff = 30 / width;
          width *= diff;
          fontSize *= diff;
          fontStyle = ''.concat(fontSize, 'px ').concat(fontFamily);
        }
        canvas.width = width;
        canvas.height = fontSize;
        canvasContext.font = fontStyle;
        canvasContext.textAlign = 'left';
        canvasContext.textBaseline = 'top';
        canvasContext.fillText(firstChar, 0, 0);
        var compareData = new Uint32Array(canvasContext.getImageData(0, 0, width, fontSize).data.buffer);
        if (!compareData.some(function(pixel) {
          return pixel;
        })) {
          font.numLigatures++;
          return true;
        }
        canvasContext.clearRect(0, 0, width, fontSize);
        canvasContext.fillText(nodeValue, 0, 0);
        var compareWith = new Uint32Array(canvasContext.getImageData(0, 0, width, fontSize).data.buffer);
        var differences = compareData.reduce(function(diff, pixel, i) {
          if (pixel === 0 && compareWith[i] === 0) {
            return diff;
          }
          if (pixel !== 0 && compareWith[i] !== 0) {
            return diff;
          }
          return ++diff;
        }, 0);
        var expectedWidth = nodeValue.split('').reduce(function(width, _char) {
          return width + canvasContext.measureText(_char).width;
        }, 0);
        var actualWidth = canvasContext.measureText(nodeValue).width;
        var pixelDifference = differences / compareData.length;
        var sizeDifference = 1 - actualWidth / expectedWidth;
        if (pixelDifference >= differenceThreshold && sizeDifference >= differenceThreshold) {
          font.numLigatures++;
          return true;
        }
        return false;
      }
      __webpack_exports__['default'] = isIconLigature;
    },
    './lib/commons/text/is-valid-autocomplete.js': function libCommonsTextIsValidAutocompleteJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'autocomplete', function() {
        return autocomplete;
      });
      var autocomplete = {
        stateTerms: [ 'on', 'off' ],
        standaloneTerms: [ 'name', 'honorific-prefix', 'given-name', 'additional-name', 'family-name', 'honorific-suffix', 'nickname', 'username', 'new-password', 'current-password', 'organization-title', 'organization', 'street-address', 'address-line1', 'address-line2', 'address-line3', 'address-level4', 'address-level3', 'address-level2', 'address-level1', 'country', 'country-name', 'postal-code', 'cc-name', 'cc-given-name', 'cc-additional-name', 'cc-family-name', 'cc-number', 'cc-exp', 'cc-exp-month', 'cc-exp-year', 'cc-csc', 'cc-type', 'transaction-currency', 'transaction-amount', 'language', 'bday', 'bday-day', 'bday-month', 'bday-year', 'sex', 'url', 'photo', 'one-time-code' ],
        qualifiers: [ 'home', 'work', 'mobile', 'fax', 'pager' ],
        qualifiedTerms: [ 'tel', 'tel-country-code', 'tel-national', 'tel-area-code', 'tel-local', 'tel-local-prefix', 'tel-local-suffix', 'tel-extension', 'email', 'impp' ],
        locations: [ 'billing', 'shipping' ]
      };
      function isValidAutocomplete(autocompleteValue) {
        var _ref47 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, _ref47$looseTyped = _ref47.looseTyped, looseTyped = _ref47$looseTyped === void 0 ? false : _ref47$looseTyped, _ref47$stateTerms = _ref47.stateTerms, stateTerms = _ref47$stateTerms === void 0 ? [] : _ref47$stateTerms, _ref47$locations = _ref47.locations, locations = _ref47$locations === void 0 ? [] : _ref47$locations, _ref47$qualifiers = _ref47.qualifiers, qualifiers = _ref47$qualifiers === void 0 ? [] : _ref47$qualifiers, _ref47$standaloneTerm = _ref47.standaloneTerms, standaloneTerms = _ref47$standaloneTerm === void 0 ? [] : _ref47$standaloneTerm, _ref47$qualifiedTerms = _ref47.qualifiedTerms, qualifiedTerms = _ref47$qualifiedTerms === void 0 ? [] : _ref47$qualifiedTerms;
        autocompleteValue = autocompleteValue.toLowerCase().trim();
        stateTerms = stateTerms.concat(autocomplete.stateTerms);
        if (stateTerms.includes(autocompleteValue) || autocompleteValue === '') {
          return true;
        }
        qualifiers = qualifiers.concat(autocomplete.qualifiers);
        locations = locations.concat(autocomplete.locations);
        standaloneTerms = standaloneTerms.concat(autocomplete.standaloneTerms);
        qualifiedTerms = qualifiedTerms.concat(autocomplete.qualifiedTerms);
        var autocompleteTerms = autocompleteValue.split(/\s+/g);
        if (!looseTyped) {
          if (autocompleteTerms[0].length > 8 && autocompleteTerms[0].substr(0, 8) === 'section-') {
            autocompleteTerms.shift();
          }
          if (locations.includes(autocompleteTerms[0])) {
            autocompleteTerms.shift();
          }
          if (qualifiers.includes(autocompleteTerms[0])) {
            autocompleteTerms.shift();
            standaloneTerms = [];
          }
          if (autocompleteTerms.length !== 1) {
            return false;
          }
        }
        var purposeTerm = autocompleteTerms[autocompleteTerms.length - 1];
        return standaloneTerms.includes(purposeTerm) || qualifiedTerms.includes(purposeTerm);
      }
      __webpack_exports__['default'] = isValidAutocomplete;
    },
    './lib/commons/text/label-text.js': function libCommonsTextLabelTextJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _accessible_text_virtual__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/accessible-text-virtual.js');
      var _accessible_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/accessible-text.js');
      var _dom_find_elms_in_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/dom/find-elms-in-context.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/index.js');
      function labelText(virtualNode) {
        var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var alreadyProcessed = _accessible_text_virtual__WEBPACK_IMPORTED_MODULE_0__['default'].alreadyProcessed;
        if (context.inControlContext || context.inLabelledByContext || alreadyProcessed(virtualNode, context)) {
          return '';
        }
        if (!context.startNode) {
          context.startNode = virtualNode;
        }
        var labelContext = _extends({
          inControlContext: true
        }, context);
        var explicitLabels = getExplicitLabels(virtualNode);
        var implicitLabel = Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['closest'])(virtualNode, 'label');
        var labels;
        if (implicitLabel) {
          labels = [].concat(_toConsumableArray(explicitLabels), [ implicitLabel.actualNode ]);
          labels.sort(_core_utils__WEBPACK_IMPORTED_MODULE_3__['nodeSorter']);
        } else {
          labels = explicitLabels;
        }
        return labels.map(function(label) {
          return Object(_accessible_text__WEBPACK_IMPORTED_MODULE_1__['default'])(label, labelContext);
        }).filter(function(text) {
          return text !== '';
        }).join(' ');
      }
      function getExplicitLabels(virtualNode) {
        if (!virtualNode.attr('id')) {
          return [];
        }
        if (!virtualNode.actualNode) {
          throw new TypeError('Cannot resolve explicit label reference for non-DOM nodes');
        }
        return Object(_dom_find_elms_in_context__WEBPACK_IMPORTED_MODULE_2__['default'])({
          elm: 'label',
          attr: 'for',
          value: virtualNode.attr('id'),
          context: virtualNode.actualNode
        });
      }
      __webpack_exports__['default'] = labelText;
    },
    './lib/commons/text/label-virtual.js': function libCommonsTextLabelVirtualJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _aria_label_virtual__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/label-virtual.js');
      var _visible__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/visible.js');
      var _visible_virtual__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/text/visible-virtual.js');
      var _dom_get_root_node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/dom/get-root-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/core/utils/index.js');
      function labelVirtual(virtualNode) {
        var ref, candidate, doc;
        candidate = Object(_aria_label_virtual__WEBPACK_IMPORTED_MODULE_0__['default'])(virtualNode);
        if (candidate) {
          return candidate;
        }
        if (virtualNode.attr('id')) {
          if (!virtualNode.actualNode) {
            throw new TypeError('Cannot resolve explicit label reference for non-DOM nodes');
          }
          var id = Object(_core_utils__WEBPACK_IMPORTED_MODULE_4__['escapeSelector'])(virtualNode.attr('id'));
          doc = Object(_dom_get_root_node__WEBPACK_IMPORTED_MODULE_3__['default'])(virtualNode.actualNode);
          ref = doc.querySelector('label[for="' + id + '"]');
          candidate = ref && Object(_visible__WEBPACK_IMPORTED_MODULE_1__['default'])(ref, true);
          if (candidate) {
            return candidate;
          }
        }
        ref = Object(_core_utils__WEBPACK_IMPORTED_MODULE_4__['closest'])(virtualNode, 'label');
        candidate = ref && Object(_visible_virtual__WEBPACK_IMPORTED_MODULE_2__['default'])(ref, true);
        if (candidate) {
          return candidate;
        }
        return null;
      }
      __webpack_exports__['default'] = labelVirtual;
    },
    './lib/commons/text/label.js': function libCommonsTextLabelJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _label_virtual__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/label-virtual.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function label(node) {
        node = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeFromTree'])(node);
        return Object(_label_virtual__WEBPACK_IMPORTED_MODULE_0__['default'])(node);
      }
      __webpack_exports__['default'] = label;
    },
    './lib/commons/text/native-element-type.js': function libCommonsTextNativeElementTypeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var nativeElementType = [ {
        matches: [ {
          nodeName: 'textarea'
        }, {
          nodeName: 'input',
          properties: {
            type: [ 'text', 'password', 'search', 'tel', 'email', 'url' ]
          }
        } ],
        namingMethods: 'labelText'
      }, {
        matches: {
          nodeName: 'input',
          properties: {
            type: [ 'button', 'submit', 'reset' ]
          }
        },
        namingMethods: [ 'valueText', 'titleText', 'buttonDefaultText' ]
      }, {
        matches: {
          nodeName: 'input',
          properties: {
            type: 'image'
          }
        },
        namingMethods: [ 'altText', 'valueText', 'labelText', 'titleText', 'buttonDefaultText' ]
      }, {
        matches: 'button',
        namingMethods: 'subtreeText'
      }, {
        matches: 'fieldset',
        namingMethods: 'fieldsetLegendText'
      }, {
        matches: 'OUTPUT',
        namingMethods: 'subtreeText'
      }, {
        matches: [ {
          nodeName: 'select'
        }, {
          nodeName: 'input',
          properties: {
            type: /^(?!text|password|search|tel|email|url|button|submit|reset)/
          }
        } ],
        namingMethods: 'labelText'
      }, {
        matches: 'summary',
        namingMethods: 'subtreeText'
      }, {
        matches: 'figure',
        namingMethods: [ 'figureText', 'titleText' ]
      }, {
        matches: 'img',
        namingMethods: 'altText'
      }, {
        matches: 'table',
        namingMethods: [ 'tableCaptionText', 'tableSummaryText' ]
      }, {
        matches: [ 'hr', 'br' ],
        namingMethods: [ 'titleText', 'singleSpace' ]
      } ];
      __webpack_exports__['default'] = nativeElementType;
    },
    './lib/commons/text/native-text-alternative.js': function libCommonsTextNativeTextAlternativeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _aria_get_role__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/get-role.js');
      var _standards_get_element_spec__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/standards/get-element-spec.js');
      var _native_text_methods__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/text/native-text-methods.js');
      function nativeTextAlternative(virtualNode) {
        var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var actualNode = virtualNode.actualNode;
        if (virtualNode.props.nodeType !== 1 || [ 'presentation', 'none' ].includes(Object(_aria_get_role__WEBPACK_IMPORTED_MODULE_0__['default'])(virtualNode))) {
          return '';
        }
        var textMethods = findTextMethods(virtualNode);
        var accName = textMethods.reduce(function(accName, step) {
          return accName || step(virtualNode, context);
        }, '');
        if (context.debug) {
          axe.log(accName || '{empty-value}', actualNode, context);
        }
        return accName;
      }
      function findTextMethods(virtualNode) {
        var elmSpec = Object(_standards_get_element_spec__WEBPACK_IMPORTED_MODULE_1__['default'])(virtualNode);
        var methods = elmSpec.namingMethods || [];
        return methods.map(function(methodName) {
          return _native_text_methods__WEBPACK_IMPORTED_MODULE_2__['default'][methodName];
        });
      }
      __webpack_exports__['default'] = nativeTextAlternative;
    },
    './lib/commons/text/native-text-methods.js': function libCommonsTextNativeTextMethodsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _title_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/title-text.js');
      var _subtree_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/subtree-text.js');
      var _label_text__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/text/label-text.js');
      var _accessible_text__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/text/accessible-text.js');
      var defaultButtonValues = {
        submit: 'Submit',
        image: 'Submit',
        reset: 'Reset',
        button: ''
      };
      var nativeTextMethods = {
        valueText: function valueText(_ref48) {
          var actualNode = _ref48.actualNode;
          return actualNode.value || '';
        },
        buttonDefaultText: function buttonDefaultText(_ref49) {
          var actualNode = _ref49.actualNode;
          return defaultButtonValues[actualNode.type] || '';
        },
        tableCaptionText: descendantText.bind(null, 'caption'),
        figureText: descendantText.bind(null, 'figcaption'),
        fieldsetLegendText: descendantText.bind(null, 'legend'),
        altText: attrText.bind(null, 'alt'),
        tableSummaryText: attrText.bind(null, 'summary'),
        titleText: _title_text__WEBPACK_IMPORTED_MODULE_0__['default'],
        subtreeText: _subtree_text__WEBPACK_IMPORTED_MODULE_1__['default'],
        labelText: _label_text__WEBPACK_IMPORTED_MODULE_2__['default'],
        singleSpace: function singleSpace() {
          return ' ';
        }
      };
      function attrText(attr, _ref50) {
        var actualNode = _ref50.actualNode;
        return actualNode.getAttribute(attr) || '';
      }
      function descendantText(nodeName, _ref51, context) {
        var actualNode = _ref51.actualNode;
        nodeName = nodeName.toLowerCase();
        var nodeNames = [ nodeName, actualNode.nodeName.toLowerCase() ].join(',');
        var candidate = actualNode.querySelector(nodeNames);
        if (!candidate || candidate.nodeName.toLowerCase() !== nodeName) {
          return '';
        }
        return Object(_accessible_text__WEBPACK_IMPORTED_MODULE_3__['default'])(candidate, context);
      }
      __webpack_exports__['default'] = nativeTextMethods;
    },
    './lib/commons/text/remove-unicode.js': function libCommonsTextRemoveUnicodeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _unicode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/unicode.js');
      var emoji_regex__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./node_modules/emoji-regex/index.js');
      var emoji_regex__WEBPACK_IMPORTED_MODULE_1___default = __webpack_require__.n(emoji_regex__WEBPACK_IMPORTED_MODULE_1__);
      function removeUnicode(str, options) {
        var emoji = options.emoji, nonBmp = options.nonBmp, punctuations = options.punctuations;
        if (emoji) {
          str = str.replace(emoji_regex__WEBPACK_IMPORTED_MODULE_1___default()(), '');
        }
        if (nonBmp) {
          str = str.replace(Object(_unicode_js__WEBPACK_IMPORTED_MODULE_0__['getUnicodeNonBmpRegExp'])(), '');
          str = str.replace(Object(_unicode_js__WEBPACK_IMPORTED_MODULE_0__['getSupplementaryPrivateUseRegExp'])(), '');
        }
        if (punctuations) {
          str = str.replace(Object(_unicode_js__WEBPACK_IMPORTED_MODULE_0__['getPunctuationRegExp'])(), '');
        }
        return str;
      }
      __webpack_exports__['default'] = removeUnicode;
    },
    './lib/commons/text/sanitize.js': function libCommonsTextSanitizeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function sanitize(str) {
        'use strict';
        return str.replace(/\r\n/g, '\n').replace(/\u00A0/g, ' ').replace(/[\s]{2,}/g, ' ').trim();
      }
      __webpack_exports__['default'] = sanitize;
    },
    './lib/commons/text/subtree-text.js': function libCommonsTextSubtreeTextJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _accessible_text_virtual__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/accessible-text-virtual.js');
      var _aria_named_from_contents__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/named-from-contents.js');
      var _aria_get_owned_virtual__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/aria/get-owned-virtual.js');
      function subtreeText(virtualNode) {
        var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var alreadyProcessed = _accessible_text_virtual__WEBPACK_IMPORTED_MODULE_0__['default'].alreadyProcessed;
        context.startNode = context.startNode || virtualNode;
        var strict = context.strict;
        if (alreadyProcessed(virtualNode, context) || !Object(_aria_named_from_contents__WEBPACK_IMPORTED_MODULE_1__['default'])(virtualNode, {
          strict: strict
        })) {
          return '';
        }
        return Object(_aria_get_owned_virtual__WEBPACK_IMPORTED_MODULE_2__['default'])(virtualNode).reduce(function(contentText, child) {
          return appendAccessibleText(contentText, child, context);
        }, '');
      }
      var phrasingElements = [ '#text', 'a', 'abbr', 'area', 'b', 'bdi', 'bdo', 'button', 'canvas', 'cite', 'code', 'command', 'datalist', 'del', 'dfn', 'em', 'i', 'ins', 'kbd', 'keygen', 'label', 'map', 'mark', 'meter', 'noscript', 'output', 'progress', 'q', 'ruby', 's', 'samp', 'small', 'span', 'strong', 'sub', 'sup', 'time', 'u', 'var', 'wbr' ];
      function appendAccessibleText(contentText, virtualNode, context) {
        var nodeName = virtualNode.props.nodeName;
        var contentTextAdd = Object(_accessible_text_virtual__WEBPACK_IMPORTED_MODULE_0__['default'])(virtualNode, context);
        if (!contentTextAdd) {
          return contentText;
        }
        if (!phrasingElements.includes(nodeName)) {
          if (contentTextAdd[0] !== ' ') {
            contentTextAdd += ' ';
          }
          if (contentText && contentText[contentText.length - 1] !== ' ') {
            contentTextAdd = ' ' + contentTextAdd;
          }
        }
        return contentText + contentTextAdd;
      }
      __webpack_exports__['default'] = subtreeText;
    },
    './lib/commons/text/title-text.js': function libCommonsTextTitleTextJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _matches_matches__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/matches/matches.js');
      var _aria_get_role__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/get-role.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/index.js');
      var alwaysTitleElements = [ 'iframe' ];
      function titleText(node) {
        var vNode = node instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_2__['default'] ? node : Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['getNodeFromTree'])(node);
        if (vNode.props.nodeType !== 1 || !node.hasAttr('title')) {
          return '';
        }
        if (!Object(_matches_matches__WEBPACK_IMPORTED_MODULE_0__['default'])(vNode, alwaysTitleElements) && [ 'none', 'presentation' ].includes(Object(_aria_get_role__WEBPACK_IMPORTED_MODULE_1__['default'])(vNode))) {
          return '';
        }
        return vNode.attr('title');
      }
      __webpack_exports__['default'] = titleText;
    },
    './lib/commons/text/unicode.js': function libCommonsTextUnicodeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'getUnicodeNonBmpRegExp', function() {
        return getUnicodeNonBmpRegExp;
      });
      __webpack_require__.d(__webpack_exports__, 'getPunctuationRegExp', function() {
        return getPunctuationRegExp;
      });
      __webpack_require__.d(__webpack_exports__, 'getSupplementaryPrivateUseRegExp', function() {
        return getSupplementaryPrivateUseRegExp;
      });
      function getUnicodeNonBmpRegExp() {
        return /[\u1D00-\u1D7F\u1D80-\u1DBF\u1DC0-\u1DFF\u20A0-\u20CF\u20D0-\u20FF\u2100-\u214F\u2150-\u218F\u2190-\u21FF\u2200-\u22FF\u2300-\u23FF\u2400-\u243F\u2440-\u245F\u2460-\u24FF\u2500-\u257F\u2580-\u259F\u25A0-\u25FF\u2600-\u26FF\u2700-\u27BF\uE000-\uF8FF]/g;
      }
      function getPunctuationRegExp() {
        return /[\u2000-\u206F\u2E00-\u2E7F\\'!"#$%&\xa3\xa2\xa5\xa7\u20ac()*+,\-.\/:;<=>?@\[\]^_`{|}~\xb1]/g;
      }
      function getSupplementaryPrivateUseRegExp() {
        return /[\uDB80-\uDBBF][\uDC00-\uDFFF]/g;
      }
    },
    './lib/commons/text/unsupported.js': function libCommonsTextUnsupportedJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var unsupported = {
        accessibleNameFromFieldValue: [ 'combobox', 'listbox', 'progressbar' ]
      };
      __webpack_exports__['default'] = unsupported;
    },
    './lib/commons/text/visible-text-nodes.js': function libCommonsTextVisibleTextNodesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _dom_is_visible__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/is-visible.js');
      function visibleTextNodes(vNode) {
        var parentVisible = Object(_dom_is_visible__WEBPACK_IMPORTED_MODULE_0__['default'])(vNode.actualNode);
        var nodes = [];
        vNode.children.forEach(function(child) {
          if (child.actualNode.nodeType === 3) {
            if (parentVisible) {
              nodes.push(child);
            }
          } else {
            nodes = nodes.concat(visibleTextNodes(child));
          }
        });
        return nodes;
      }
      __webpack_exports__['default'] = visibleTextNodes;
    },
    './lib/commons/text/visible-virtual.js': function libCommonsTextVisibleVirtualJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _sanitize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/sanitize.js');
      var _dom_is_visible__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/is-visible.js');
      var _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/index.js');
      function visibleVirtual(element, screenReader, noRecursing) {
        var vNode = element instanceof _core_base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_2__['default'] ? element : Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['getNodeFromTree'])(element);
        var visible = !element.actualNode || element.actualNode && Object(_dom_is_visible__WEBPACK_IMPORTED_MODULE_1__['default'])(element.actualNode, screenReader);
        var result = vNode.children.map(function(child) {
          var _child$props = child.props, nodeType = _child$props.nodeType, nodeValue = _child$props.nodeValue;
          if (nodeType === 3) {
            if (nodeValue && visible) {
              return nodeValue;
            }
          } else if (!noRecursing) {
            return visibleVirtual(child, screenReader);
          }
        }).join('');
        return Object(_sanitize__WEBPACK_IMPORTED_MODULE_0__['default'])(result);
      }
      __webpack_exports__['default'] = visibleVirtual;
    },
    './lib/commons/text/visible.js': function libCommonsTextVisibleJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _visible_virtual__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/visible-virtual.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function visible(element, screenReader, noRecursing) {
        element = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getNodeFromTree'])(element);
        return Object(_visible_virtual__WEBPACK_IMPORTED_MODULE_0__['default'])(element, screenReader, noRecursing);
      }
      __webpack_exports__['default'] = visible;
    },
    './lib/core/base/audit.js': function libCoreBaseAuditJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _rule__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/rule.js');
      var _check__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/check.js');
      var _standards__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/standards/index.js');
      var _rule_result__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/base/rule-result.js');
      var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/core/utils/index.js');
      var _deque_dot__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./node_modules/@deque/dot/doT.js');
      var _deque_dot__WEBPACK_IMPORTED_MODULE_5___default = __webpack_require__.n(_deque_dot__WEBPACK_IMPORTED_MODULE_5__);
      var _log__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/core/log.js');
      var _constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/core/constants.js');
      var dotRegex = /\{\{.+?\}\}/g;
      function getDefaultConfiguration(audit) {
        var config;
        if (audit) {
          config = Object(_utils__WEBPACK_IMPORTED_MODULE_4__['clone'])(audit);
          config.commons = audit.commons;
        } else {
          config = {};
        }
        config.reporter = config.reporter || null;
        config.rules = config.rules || [];
        config.checks = config.checks || [];
        config.data = _extends({
          checks: {},
          rules: {}
        }, config.data);
        return config;
      }
      function unpackToObject(collection, audit, method) {
        var i, l;
        for (i = 0, l = collection.length; i < l; i++) {
          audit[method](collection[i]);
        }
      }
      var mergeCheckLocale = function mergeCheckLocale(a, b) {
        var pass = b.pass, fail = b.fail;
        if (typeof pass === 'string' && dotRegex.test(pass)) {
          pass = _deque_dot__WEBPACK_IMPORTED_MODULE_5___default.a.compile(pass);
        }
        if (typeof fail === 'string' && dotRegex.test(fail)) {
          fail = _deque_dot__WEBPACK_IMPORTED_MODULE_5___default.a.compile(fail);
        }
        return _extends({}, a, {
          messages: {
            pass: pass || a.messages.pass,
            fail: fail || a.messages.fail,
            incomplete: _typeof(a.messages.incomplete) === 'object' ? _extends({}, a.messages.incomplete, b.incomplete) : b.incomplete
          }
        });
      };
      var mergeRuleLocale = function mergeRuleLocale(a, b) {
        var help = b.help, description = b.description;
        if (typeof help === 'string' && dotRegex.test(help)) {
          help = _deque_dot__WEBPACK_IMPORTED_MODULE_5___default.a.compile(help);
        }
        if (typeof description === 'string' && dotRegex.test(description)) {
          description = _deque_dot__WEBPACK_IMPORTED_MODULE_5___default.a.compile(description);
        }
        return _extends({}, a, {
          help: help || a.help,
          description: description || a.description
        });
      };
      var mergeFailureMessage = function mergeFailureMessage(a, b) {
        var failureMessage = b.failureMessage;
        if (typeof failureMessage === 'string' && dotRegex.test(failureMessage)) {
          failureMessage = _deque_dot__WEBPACK_IMPORTED_MODULE_5___default.a.compile(failureMessage);
        }
        return _extends({}, a, {
          failureMessage: failureMessage || a.failureMessage
        });
      };
      var mergeFallbackMessage = function mergeFallbackMessage(a, b) {
        if (typeof b === 'string' && dotRegex.test(b)) {
          b = _deque_dot__WEBPACK_IMPORTED_MODULE_5___default.a.compile(b);
        }
        return b || a;
      };
      var Audit = function() {
        function Audit(audit) {
          _classCallCheck(this, Audit);
          this.brand = 'axe';
          this.application = 'axeAPI';
          this.tagExclude = [ 'experimental' ];
          this.lang = 'en';
          this.defaultConfig = audit;
          this.standards = _standards__WEBPACK_IMPORTED_MODULE_2__['default'];
          this._init();
          this._defaultLocale = null;
        }
        _createClass(Audit, [ {
          key: '_setDefaultLocale',
          value: function _setDefaultLocale() {
            if (this._defaultLocale) {
              return;
            }
            var locale = {
              checks: {},
              rules: {},
              failureSummaries: {},
              incompleteFallbackMessage: '',
              lang: this.lang
            };
            var checkIDs = Object.keys(this.data.checks);
            for (var i = 0; i < checkIDs.length; i++) {
              var id = checkIDs[i];
              var check = this.data.checks[id];
              var _check$messages = check.messages, pass = _check$messages.pass, fail = _check$messages.fail, incomplete = _check$messages.incomplete;
              locale.checks[id] = {
                pass: pass,
                fail: fail,
                incomplete: incomplete
              };
            }
            var ruleIDs = Object.keys(this.data.rules);
            for (var _i4 = 0; _i4 < ruleIDs.length; _i4++) {
              var _id = ruleIDs[_i4];
              var rule = this.data.rules[_id];
              var description = rule.description, help = rule.help;
              locale.rules[_id] = {
                description: description,
                help: help
              };
            }
            var failureSummaries = Object.keys(this.data.failureSummaries);
            for (var _i5 = 0; _i5 < failureSummaries.length; _i5++) {
              var type = failureSummaries[_i5];
              var failureSummary = this.data.failureSummaries[type];
              var failureMessage = failureSummary.failureMessage;
              locale.failureSummaries[type] = {
                failureMessage: failureMessage
              };
            }
            locale.incompleteFallbackMessage = this.data.incompleteFallbackMessage;
            this._defaultLocale = locale;
          }
        }, {
          key: '_resetLocale',
          value: function _resetLocale() {
            var defaultLocale = this._defaultLocale;
            if (!defaultLocale) {
              return;
            }
            this.applyLocale(defaultLocale);
          }
        }, {
          key: '_applyCheckLocale',
          value: function _applyCheckLocale(checks) {
            var keys = Object.keys(checks);
            for (var i = 0; i < keys.length; i++) {
              var id = keys[i];
              if (!this.data.checks[id]) {
                throw new Error('Locale provided for unknown check: "'.concat(id, '"'));
              }
              this.data.checks[id] = mergeCheckLocale(this.data.checks[id], checks[id]);
            }
          }
        }, {
          key: '_applyRuleLocale',
          value: function _applyRuleLocale(rules) {
            var keys = Object.keys(rules);
            for (var i = 0; i < keys.length; i++) {
              var id = keys[i];
              if (!this.data.rules[id]) {
                throw new Error('Locale provided for unknown rule: "'.concat(id, '"'));
              }
              this.data.rules[id] = mergeRuleLocale(this.data.rules[id], rules[id]);
            }
          }
        }, {
          key: '_applyFailureSummaries',
          value: function _applyFailureSummaries(messages) {
            var keys = Object.keys(messages);
            for (var i = 0; i < keys.length; i++) {
              var key = keys[i];
              if (!this.data.failureSummaries[key]) {
                throw new Error('Locale provided for unknown failureMessage: "'.concat(key, '"'));
              }
              this.data.failureSummaries[key] = mergeFailureMessage(this.data.failureSummaries[key], messages[key]);
            }
          }
        }, {
          key: 'applyLocale',
          value: function applyLocale(locale) {
            this._setDefaultLocale();
            if (locale.checks) {
              this._applyCheckLocale(locale.checks);
            }
            if (locale.rules) {
              this._applyRuleLocale(locale.rules);
            }
            if (locale.failureSummaries) {
              this._applyFailureSummaries(locale.failureSummaries, 'failureSummaries');
            }
            if (locale.incompleteFallbackMessage) {
              this.data.incompleteFallbackMessage = mergeFallbackMessage(this.data.incompleteFallbackMessage, locale.incompleteFallbackMessage);
            }
            if (locale.lang) {
              this.lang = locale.lang;
            }
          }
        }, {
          key: '_init',
          value: function _init() {
            var audit = getDefaultConfiguration(this.defaultConfig);
            this.lang = audit.lang || 'en';
            this.reporter = audit.reporter;
            this.commands = {};
            this.rules = [];
            this.checks = {};
            unpackToObject(audit.rules, this, 'addRule');
            unpackToObject(audit.checks, this, 'addCheck');
            this.data = {};
            this.data.checks = audit.data && audit.data.checks || {};
            this.data.rules = audit.data && audit.data.rules || {};
            this.data.failureSummaries = audit.data && audit.data.failureSummaries || {};
            this.data.incompleteFallbackMessage = audit.data && audit.data.incompleteFallbackMessage || '';
            this._constructHelpUrls();
          }
        }, {
          key: 'registerCommand',
          value: function registerCommand(command) {
            this.commands[command.id] = command.callback;
          }
        }, {
          key: 'addRule',
          value: function addRule(spec) {
            if (spec.metadata) {
              this.data.rules[spec.id] = spec.metadata;
            }
            var rule = this.getRule(spec.id);
            if (rule) {
              rule.configure(spec);
            } else {
              this.rules.push(new _rule__WEBPACK_IMPORTED_MODULE_0__['default'](spec, this));
            }
          }
        }, {
          key: 'addCheck',
          value: function addCheck(spec) {
            var metadata = spec.metadata;
            if (_typeof(metadata) === 'object') {
              this.data.checks[spec.id] = metadata;
              if (_typeof(metadata.messages) === 'object') {
                Object.keys(metadata.messages).filter(function(prop) {
                  return metadata.messages.hasOwnProperty(prop) && typeof metadata.messages[prop] === 'string';
                }).forEach(function(prop) {
                  if (metadata.messages[prop].indexOf('function') === 0) {
                    metadata.messages[prop] = new Function('return ' + metadata.messages[prop] + ';')();
                  }
                });
              }
            }
            if (this.checks[spec.id]) {
              this.checks[spec.id].configure(spec);
            } else {
              this.checks[spec.id] = new _check__WEBPACK_IMPORTED_MODULE_1__['default'](spec);
            }
          }
        }, {
          key: 'run',
          value: function run(context, options, resolve, reject) {
            this.normalizeOptions(options);
            axe._selectCache = [];
            var allRulesToRun = getRulesToRun(this.rules, context, options);
            var runNowRules = allRulesToRun.now;
            var runLaterRules = allRulesToRun.later;
            var nowRulesQueue = Object(_utils__WEBPACK_IMPORTED_MODULE_4__['queue'])();
            runNowRules.forEach(function(rule) {
              nowRulesQueue.defer(getDefferedRule(rule, context, options));
            });
            var preloaderQueue = Object(_utils__WEBPACK_IMPORTED_MODULE_4__['queue'])();
            if (runLaterRules.length) {
              preloaderQueue.defer(function(resolve) {
                Object(_utils__WEBPACK_IMPORTED_MODULE_4__['preload'])(options).then(function(assets) {
                  return resolve(assets);
                })['catch'](function(err) {
                  console.warn('Couldn\'t load preload assets: ', err);
                  resolve(undefined);
                });
              });
            }
            var queueForNowRulesAndPreloader = Object(_utils__WEBPACK_IMPORTED_MODULE_4__['queue'])();
            queueForNowRulesAndPreloader.defer(nowRulesQueue);
            queueForNowRulesAndPreloader.defer(preloaderQueue);
            queueForNowRulesAndPreloader.then(function(nowRulesAndPreloaderResults) {
              var assetsFromQueue = nowRulesAndPreloaderResults.pop();
              if (assetsFromQueue && assetsFromQueue.length) {
                var assets = assetsFromQueue[0];
                if (assets) {
                  context = _extends({}, context, assets);
                }
              }
              var nowRulesResults = nowRulesAndPreloaderResults[0];
              if (!runLaterRules.length) {
                axe._selectCache = undefined;
                resolve(nowRulesResults.filter(function(result) {
                  return !!result;
                }));
                return;
              }
              var laterRulesQueue = Object(_utils__WEBPACK_IMPORTED_MODULE_4__['queue'])();
              runLaterRules.forEach(function(rule) {
                var deferredRule = getDefferedRule(rule, context, options);
                laterRulesQueue.defer(deferredRule);
              });
              laterRulesQueue.then(function(laterRuleResults) {
                axe._selectCache = undefined;
                resolve(nowRulesResults.concat(laterRuleResults).filter(function(result) {
                  return !!result;
                }));
              })['catch'](reject);
            })['catch'](reject);
          }
        }, {
          key: 'after',
          value: function after(results, options) {
            var rules = this.rules;
            return results.map(function(ruleResult) {
              var rule = Object(_utils__WEBPACK_IMPORTED_MODULE_4__['findBy'])(rules, 'id', ruleResult.id);
              if (!rule) {
                throw new Error('Result for unknown rule. You may be running mismatch axe-core versions');
              }
              return rule.after(ruleResult, options);
            });
          }
        }, {
          key: 'getRule',
          value: function getRule(ruleId) {
            return this.rules.find(function(rule) {
              return rule.id === ruleId;
            });
          }
        }, {
          key: 'normalizeOptions',
          value: function normalizeOptions(options) {
            var audit = this;
            var tags = [];
            var ruleIds = [];
            audit.rules.forEach(function(rule) {
              ruleIds.push(rule.id);
              rule.tags.forEach(function(tag) {
                if (!tags.includes(tag)) {
                  tags.push(tag);
                }
              });
            });
            if (_typeof(options.runOnly) === 'object') {
              if (Array.isArray(options.runOnly)) {
                var hasTag = options.runOnly.find(function(value) {
                  return tags.includes(value);
                });
                var hasRule = options.runOnly.find(function(value) {
                  return ruleIds.includes(value);
                });
                if (hasTag && hasRule) {
                  throw new Error('runOnly cannot be both rules and tags');
                }
                if (hasRule) {
                  options.runOnly = {
                    type: 'rule',
                    values: options.runOnly
                  };
                } else {
                  options.runOnly = {
                    type: 'tag',
                    values: options.runOnly
                  };
                }
              }
              var only = options.runOnly;
              if (only.value && !only.values) {
                only.values = only.value;
                delete only.value;
              }
              if (!Array.isArray(only.values) || only.values.length === 0) {
                throw new Error('runOnly.values must be a non-empty array');
              }
              if ([ 'rule', 'rules' ].includes(only.type)) {
                only.type = 'rule';
                only.values.forEach(function(ruleId) {
                  if (!ruleIds.includes(ruleId)) {
                    throw new Error('unknown rule `' + ruleId + '` in options.runOnly');
                  }
                });
              } else if ([ 'tag', 'tags', undefined ].includes(only.type)) {
                only.type = 'tag';
                var unmatchedTags = only.values.filter(function(tag) {
                  return !tags.includes(tag);
                });
                if (unmatchedTags.length !== 0) {
                  Object(_log__WEBPACK_IMPORTED_MODULE_6__['default'])('Could not find tags `' + unmatchedTags.join('`, `') + '`');
                }
              } else {
                throw new Error('Unknown runOnly type \''.concat(only.type, '\''));
              }
            }
            if (_typeof(options.rules) === 'object') {
              Object.keys(options.rules).forEach(function(ruleId) {
                if (!ruleIds.includes(ruleId)) {
                  throw new Error('unknown rule `' + ruleId + '` in options.rules');
                }
              });
            }
            return options;
          }
        }, {
          key: 'setBranding',
          value: function setBranding(branding) {
            var previous = {
              brand: this.brand,
              application: this.application
            };
            if (branding && branding.hasOwnProperty('brand') && branding.brand && typeof branding.brand === 'string') {
              this.brand = branding.brand;
            }
            if (branding && branding.hasOwnProperty('application') && branding.application && typeof branding.application === 'string') {
              this.application = branding.application;
            }
            this._constructHelpUrls(previous);
          }
        }, {
          key: '_constructHelpUrls',
          value: function _constructHelpUrls() {
            var _this = this;
            var previous = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
            var version = (axe.version.match(/^[1-9][0-9]*\.[0-9]+/) || [ 'x.y' ])[0];
            this.rules.forEach(function(rule) {
              if (!_this.data.rules[rule.id]) {
                _this.data.rules[rule.id] = {};
              }
              var metaData = _this.data.rules[rule.id];
              if (typeof metaData.helpUrl !== 'string' || previous && metaData.helpUrl === getHelpUrl(previous, rule.id, version)) {
                metaData.helpUrl = getHelpUrl(_this, rule.id, version);
              }
            });
          }
        }, {
          key: 'resetRulesAndChecks',
          value: function resetRulesAndChecks() {
            this._init();
            this._resetLocale();
          }
        } ]);
        return Audit;
      }();
      function getRulesToRun(rules, context, options) {
        var base = {
          now: [],
          later: []
        };
        var splitRules = rules.reduce(function(out, rule) {
          if (!Object(_utils__WEBPACK_IMPORTED_MODULE_4__['ruleShouldRun'])(rule, context, options)) {
            return out;
          }
          if (rule.preload) {
            out.later.push(rule);
            return out;
          }
          out.now.push(rule);
          return out;
        }, base);
        return splitRules;
      }
      function getDefferedRule(rule, context, options) {
        if (options.performanceTimer) {
          _utils__WEBPACK_IMPORTED_MODULE_4__['performanceTimer'].mark('mark_rule_start_' + rule.id);
        }
        return function(resolve, reject) {
          rule.run(context, options, function(ruleResult) {
            resolve(ruleResult);
          }, function(err) {
            if (!options.debug) {
              var errResult = Object.assign(new _rule_result__WEBPACK_IMPORTED_MODULE_3__['default'](rule), {
                result: _constants__WEBPACK_IMPORTED_MODULE_7__['default'].CANTTELL,
                description: 'An error occured while running this rule',
                message: err.message,
                stack: err.stack,
                error: err,
                errorNode: err.errorNode
              });
              resolve(errResult);
            } else {
              reject(err);
            }
          });
        };
      }
      function getHelpUrl(_ref52, ruleId, version) {
        var brand = _ref52.brand, application = _ref52.application, lang = _ref52.lang;
        return _constants__WEBPACK_IMPORTED_MODULE_7__['default'].helpUrlBase + brand + '/' + (version || axe.version.substring(0, axe.version.lastIndexOf('.'))) + '/' + ruleId + '?application=' + encodeURIComponent(application) + (lang && lang !== 'en' ? '&lang=' + encodeURIComponent(lang) : '');
      }
      __webpack_exports__['default'] = Audit;
    },
    './lib/core/base/cache.js': function libCoreBaseCacheJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _cache = {};
      var cache = {
        set: function set(key, value) {
          _cache[key] = value;
        },
        get: function get(key) {
          return _cache[key];
        },
        clear: function clear() {
          _cache = {};
        }
      };
      __webpack_exports__['default'] = cache;
    },
    './lib/core/base/check-result.js': function libCoreBaseCheckResultJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function CheckResult(check) {
        this.id = check.id;
        this.data = null;
        this.relatedNodes = [];
        this.result = null;
      }
      __webpack_exports__['default'] = CheckResult;
    },
    './lib/core/base/check.js': function libCoreBaseCheckJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'createExecutionContext', function() {
        return createExecutionContext;
      });
      var _metadata_function_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/metadata-function-map.js');
      var _check_result__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/check-result.js');
      var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function createExecutionContext(spec) {
        if (typeof spec === 'string') {
          if (_metadata_function_map__WEBPACK_IMPORTED_MODULE_0__['default'][spec]) {
            return _metadata_function_map__WEBPACK_IMPORTED_MODULE_0__['default'][spec];
          }
          if (/^\s*function[\s\w]*\(/.test(spec)) {
            return new Function('return ' + spec + ';')();
          }
          throw new ReferenceError('Function ID does not exist in the metadata-function-map: '.concat(spec));
        }
        return spec;
      }
      function normalizeOptions() {
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        if (Array.isArray(options) || _typeof(options) !== 'object') {
          options = {
            value: options
          };
        }
        return options;
      }
      function Check(spec) {
        if (spec) {
          this.id = spec.id;
          this.configure(spec);
        }
      }
      Check.prototype.enabled = true;
      Check.prototype.run = function(node, options, context, resolve, reject) {
        'use strict';
        options = options || {};
        var enabled = options.hasOwnProperty('enabled') ? options.enabled : this.enabled;
        var checkOptions = this.getOptions(options.options);
        if (enabled) {
          var checkResult = new _check_result__WEBPACK_IMPORTED_MODULE_1__['default'](this);
          var helper = Object(_utils__WEBPACK_IMPORTED_MODULE_2__['checkHelper'])(checkResult, options, resolve, reject);
          var result;
          try {
            result = this.evaluate.call(helper, node.actualNode, checkOptions, node, context);
          } catch (e) {
            if (node && node.actualNode) {
              e.errorNode = new _utils__WEBPACK_IMPORTED_MODULE_2__['DqElement'](node.actualNode).toJSON();
            }
            reject(e);
            return;
          }
          if (!helper.isAsync) {
            checkResult.result = result;
            resolve(checkResult);
          }
        } else {
          resolve(null);
        }
      };
      Check.prototype.runSync = function(node, options, context) {
        options = options || {};
        var _options = options, _options$enabled = _options.enabled, enabled = _options$enabled === void 0 ? this.enabled : _options$enabled;
        if (!enabled) {
          return null;
        }
        var checkOptions = this.getOptions(options.options);
        var checkResult = new _check_result__WEBPACK_IMPORTED_MODULE_1__['default'](this);
        var helper = Object(_utils__WEBPACK_IMPORTED_MODULE_2__['checkHelper'])(checkResult, options);
        helper.async = function() {
          throw new Error('Cannot run async check while in a synchronous run');
        };
        var result;
        try {
          result = this.evaluate.call(helper, node.actualNode, checkOptions, node, context);
        } catch (e) {
          if (node && node.actualNode) {
            e.errorNode = new _utils__WEBPACK_IMPORTED_MODULE_2__['DqElement'](node.actualNode).toJSON();
          }
          throw e;
        }
        checkResult.result = result;
        return checkResult;
      };
      Check.prototype.configure = function(spec) {
        var _this2 = this;
        if (!spec.evaluate || _metadata_function_map__WEBPACK_IMPORTED_MODULE_0__['default'][spec.evaluate]) {
          this._internalCheck = true;
        }
        if (spec.hasOwnProperty('enabled')) {
          this.enabled = spec.enabled;
        }
        if (spec.hasOwnProperty('options')) {
          if (this._internalCheck) {
            this.options = normalizeOptions(spec.options);
          } else {
            this.options = spec.options;
          }
        }
        [ 'evaluate', 'after' ].filter(function(prop) {
          return spec.hasOwnProperty(prop);
        }).forEach(function(prop) {
          return _this2[prop] = createExecutionContext(spec[prop]);
        });
      };
      Check.prototype.getOptions = function getOptions(options) {
        if (this._internalCheck) {
          return Object(_utils__WEBPACK_IMPORTED_MODULE_2__['deepMerge'])(this.options, normalizeOptions(options || {}));
        } else {
          return options || this.options;
        }
      };
      __webpack_exports__['default'] = Check;
    },
    './lib/core/base/context.js': function libCoreBaseContextJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function pushUniqueFrame(collection, frame) {
        if (Object(_utils__WEBPACK_IMPORTED_MODULE_0__['isHidden'])(frame)) {
          return;
        }
        var fr = Object(_utils__WEBPACK_IMPORTED_MODULE_0__['findBy'])(collection, 'node', frame);
        if (!fr) {
          collection.push({
            node: frame,
            include: [],
            exclude: []
          });
        }
      }
      function pushUniqueFrameSelector(context, type, selectorArray) {
        context.frames = context.frames || [];
        var result, frame;
        var frames = document.querySelectorAll(selectorArray.shift());
        frameloop: for (var i = 0, l = frames.length; i < l; i++) {
          frame = frames[i];
          for (var j = 0, l2 = context.frames.length; j < l2; j++) {
            if (context.frames[j].node === frame) {
              context.frames[j][type].push(selectorArray);
              break frameloop;
            }
          }
          result = {
            node: frame,
            include: [],
            exclude: []
          };
          if (selectorArray) {
            result[type].push(selectorArray);
          }
          context.frames.push(result);
        }
      }
      function normalizeContext(context) {
        if (context && _typeof(context) === 'object' || context instanceof window.NodeList) {
          if (context instanceof window.Node) {
            return {
              include: [ context ],
              exclude: []
            };
          }
          if (context.hasOwnProperty('include') || context.hasOwnProperty('exclude')) {
            return {
              include: context.include && +context.include.length ? context.include : [ document ],
              exclude: context.exclude || []
            };
          }
          if (context.length === +context.length) {
            return {
              include: context,
              exclude: []
            };
          }
        }
        if (typeof context === 'string') {
          return {
            include: [ context ],
            exclude: []
          };
        }
        return {
          include: [ document ],
          exclude: []
        };
      }
      function parseSelectorArray(context, type) {
        var item, result = [], nodeList;
        for (var i = 0, l = context[type].length; i < l; i++) {
          item = context[type][i];
          if (typeof item === 'string') {
            nodeList = Array.from(document.querySelectorAll(item));
            result = result.concat(nodeList.map(function(node) {
              return Object(_utils__WEBPACK_IMPORTED_MODULE_0__['getNodeFromTree'])(node);
            }));
            break;
          } else if (item && item.length && !(item instanceof window.Node)) {
            if (item.length > 1) {
              pushUniqueFrameSelector(context, type, item);
            } else {
              nodeList = Array.from(document.querySelectorAll(item[0]));
              result = result.concat(nodeList.map(function(node) {
                return Object(_utils__WEBPACK_IMPORTED_MODULE_0__['getNodeFromTree'])(node);
              }));
            }
          } else if (item instanceof window.Node) {
            if (item.documentElement instanceof window.Node) {
              result.push(context.flatTree[0]);
            } else {
              result.push(Object(_utils__WEBPACK_IMPORTED_MODULE_0__['getNodeFromTree'])(item));
            }
          }
        }
        return result.filter(function(r) {
          return r;
        });
      }
      function validateContext(context) {
        if (context.include.length === 0) {
          if (context.frames.length === 0) {
            var env = _utils__WEBPACK_IMPORTED_MODULE_0__['respondable'].isInFrame() ? 'frame' : 'page';
            return new Error('No elements found for include in ' + env + ' Context');
          }
          context.frames.forEach(function(frame, i) {
            if (frame.include.length === 0) {
              return new Error('No elements found for include in Context of frame ' + i);
            }
          });
        }
      }
      function getRootNode(_ref53) {
        var include = _ref53.include, exclude = _ref53.exclude;
        var selectors = Array.from(include).concat(Array.from(exclude));
        for (var i = 0; i < selectors.length; ++i) {
          var item = selectors[i];
          if (item instanceof window.Element) {
            return item.ownerDocument.documentElement;
          }
          if (item instanceof window.Document) {
            return item.documentElement;
          }
        }
        return document.documentElement;
      }
      function Context(spec) {
        var _this3 = this;
        this.frames = [];
        this.initiator = spec && typeof spec.initiator === 'boolean' ? spec.initiator : true;
        this.page = false;
        spec = normalizeContext(spec);
        this.flatTree = Object(_utils__WEBPACK_IMPORTED_MODULE_0__['getFlattenedTree'])(getRootNode(spec));
        this.exclude = spec.exclude;
        this.include = spec.include;
        this.include = parseSelectorArray(this, 'include');
        this.exclude = parseSelectorArray(this, 'exclude');
        Object(_utils__WEBPACK_IMPORTED_MODULE_0__['select'])('frame, iframe', this).forEach(function(frame) {
          if (Object(_utils__WEBPACK_IMPORTED_MODULE_0__['isNodeInContext'])(frame, _this3)) {
            pushUniqueFrame(_this3.frames, frame.actualNode);
          }
        });
        if (this.include.length === 1 && this.include[0].actualNode === document.documentElement) {
          this.page = true;
        }
        var err = validateContext(this);
        if (err instanceof Error) {
          throw err;
        }
        if (!Array.isArray(this.include)) {
          this.include = Array.from(this.include);
        }
        this.include.sort(_utils__WEBPACK_IMPORTED_MODULE_0__['nodeSorter']);
      }
      __webpack_exports__['default'] = Context;
    },
    './lib/core/base/metadata-function-map.js': function libCoreBaseMetadataFunctionMapJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _checks_aria_abstractrole_evaluate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/checks/aria/abstractrole-evaluate.js');
      var _checks_aria_aria_allowed_attr_evaluate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/checks/aria/aria-allowed-attr-evaluate.js');
      var _checks_aria_aria_allowed_role_evaluate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/checks/aria/aria-allowed-role-evaluate.js');
      var _checks_aria_aria_errormessage_evaluate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/checks/aria/aria-errormessage-evaluate.js');
      var _checks_aria_aria_hidden_body_evaluate__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/checks/aria/aria-hidden-body-evaluate.js');
      var _checks_aria_aria_required_attr_evaluate__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/checks/aria/aria-required-attr-evaluate.js');
      var _checks_aria_aria_required_children_evaluate__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/checks/aria/aria-required-children-evaluate.js');
      var _checks_aria_aria_required_parent_evaluate__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/checks/aria/aria-required-parent-evaluate.js');
      var _checks_aria_aria_roledescription_evaluate__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__('./lib/checks/aria/aria-roledescription-evaluate.js');
      var _checks_aria_aria_unsupported_attr_evaluate__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__('./lib/checks/aria/aria-unsupported-attr-evaluate.js');
      var _checks_aria_aria_valid_attr_evaluate__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__('./lib/checks/aria/aria-valid-attr-evaluate.js');
      var _checks_aria_aria_valid_attr_value_evaluate__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__('./lib/checks/aria/aria-valid-attr-value-evaluate.js');
      var _checks_aria_fallbackrole_evaluate__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__('./lib/checks/aria/fallbackrole-evaluate.js');
      var _checks_aria_has_widget_role_evaluate__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__('./lib/checks/aria/has-widget-role-evaluate.js');
      var _checks_aria_invalidrole_evaluate__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__('./lib/checks/aria/invalidrole-evaluate.js');
      var _checks_aria_no_implicit_explicit_label_evaluate__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__('./lib/checks/aria/no-implicit-explicit-label-evaluate.js');
      var _checks_aria_unsupportedrole_evaluate__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__('./lib/checks/aria/unsupportedrole-evaluate.js');
      var _checks_aria_valid_scrollable_semantics_evaluate__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__('./lib/checks/aria/valid-scrollable-semantics-evaluate.js');
      var _checks_tables_caption_faked_evaluate__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__('./lib/checks/tables/caption-faked-evaluate.js');
      var _checks_tables_html5_scope_evaluate__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__('./lib/checks/tables/html5-scope-evaluate.js');
      var _checks_tables_same_caption_summary_evaluate__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__('./lib/checks/tables/same-caption-summary-evaluate.js');
      var _checks_tables_scope_value_evaluate__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__('./lib/checks/tables/scope-value-evaluate.js');
      var _checks_tables_td_has_header_evaluate__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__('./lib/checks/tables/td-has-header-evaluate.js');
      var _checks_tables_td_headers_attr_evaluate__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__('./lib/checks/tables/td-headers-attr-evaluate.js');
      var _checks_tables_th_has_data_cells_evaluate__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__('./lib/checks/tables/th-has-data-cells-evaluate.js');
      var _checks_visibility_hidden_content_evaluate__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__('./lib/checks/visibility/hidden-content-evaluate.js');
      var _checks_color_color_contrast_evaluate__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__('./lib/checks/color/color-contrast-evaluate.js');
      var _checks_color_link_in_text_block_evaluate__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__('./lib/checks/color/link-in-text-block-evaluate.js');
      var _checks_forms_autocomplete_appropriate_evaluate__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__('./lib/checks/forms/autocomplete-appropriate-evaluate.js');
      var _checks_forms_autocomplete_valid_evaluate__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__('./lib/checks/forms/autocomplete-valid-evaluate.js');
      var _checks_generic_attr_non_space_content_evaluate__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__('./lib/checks/generic/attr-non-space-content-evaluate.js');
      var _checks_generic_has_descendant_after__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__('./lib/checks/generic/has-descendant-after.js');
      var _checks_generic_has_descendant_evaluate__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__('./lib/checks/generic/has-descendant-evaluate.js');
      var _checks_generic_has_text_content_evaluate__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__('./lib/checks/generic/has-text-content-evaluate.js');
      var _checks_generic_matches_definition_evaluate__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__('./lib/checks/generic/matches-definition-evaluate.js');
      var _checks_generic_page_no_duplicate_after__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__('./lib/checks/generic/page-no-duplicate-after.js');
      var _checks_generic_page_no_duplicate_evaluate__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__('./lib/checks/generic/page-no-duplicate-evaluate.js');
      var _checks_navigation_heading_order_after__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__('./lib/checks/navigation/heading-order-after.js');
      var _checks_navigation_heading_order_evaluate__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__('./lib/checks/navigation/heading-order-evaluate.js');
      var _checks_navigation_identical_links_same_purpose_after__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__('./lib/checks/navigation/identical-links-same-purpose-after.js');
      var _checks_navigation_identical_links_same_purpose_evaluate__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__('./lib/checks/navigation/identical-links-same-purpose-evaluate.js');
      var _checks_navigation_internal_link_present_evaluate__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__('./lib/checks/navigation/internal-link-present-evaluate.js');
      var _checks_navigation_meta_refresh_evaluate__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__('./lib/checks/navigation/meta-refresh-evaluate.js');
      var _checks_navigation_p_as_heading_evaluate__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__('./lib/checks/navigation/p-as-heading-evaluate.js');
      var _checks_navigation_region_evaluate__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__('./lib/checks/navigation/region-evaluate.js');
      var _checks_navigation_skip_link_evaluate__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__('./lib/checks/navigation/skip-link-evaluate.js');
      var _checks_navigation_unique_frame_title_after__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__('./lib/checks/navigation/unique-frame-title-after.js');
      var _checks_navigation_unique_frame_title_evaluate__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__('./lib/checks/navigation/unique-frame-title-evaluate.js');
      var _checks_shared_aria_label_evaluate__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__('./lib/checks/shared/aria-label-evaluate.js');
      var _checks_shared_aria_labelledby_evaluate__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__('./lib/checks/shared/aria-labelledby-evaluate.js');
      var _checks_shared_avoid_inline_spacing_evaluate__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__('./lib/checks/shared/avoid-inline-spacing-evaluate.js');
      var _checks_shared_doc_has_title_evaluate__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__('./lib/checks/shared/doc-has-title-evaluate.js');
      var _checks_shared_exists_evaluate__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__('./lib/checks/shared/exists-evaluate.js');
      var _checks_shared_has_alt_evaluate__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__('./lib/checks/shared/has-alt-evaluate.js');
      var _checks_shared_is_on_screen_evaluate__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__('./lib/checks/shared/is-on-screen-evaluate.js');
      var _checks_shared_non_empty_if_present_evaluate__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__('./lib/checks/shared/non-empty-if-present-evaluate.js');
      var _checks_shared_svg_non_empty_title_evaluate__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__('./lib/checks/shared/svg-non-empty-title-evaluate.js');
      var _checks_mobile_css_orientation_lock_evaluate__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__('./lib/checks/mobile/css-orientation-lock-evaluate.js');
      var _checks_mobile_meta_viewport_scale_evaluate__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__('./lib/checks/mobile/meta-viewport-scale-evaluate.js');
      var _checks_parsing_duplicate_id_after__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__('./lib/checks/parsing/duplicate-id-after.js');
      var _checks_parsing_duplicate_id_evaluate__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__('./lib/checks/parsing/duplicate-id-evaluate.js');
      var _checks_keyboard_accesskeys_after__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__('./lib/checks/keyboard/accesskeys-after.js');
      var _checks_keyboard_accesskeys_evaluate__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__('./lib/checks/keyboard/accesskeys-evaluate.js');
      var _checks_keyboard_focusable_content_evaluate__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__('./lib/checks/keyboard/focusable-content-evaluate.js');
      var _checks_keyboard_focusable_disabled_evaluate__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__('./lib/checks/keyboard/focusable-disabled-evaluate.js');
      var _checks_keyboard_focusable_element_evaluate__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__('./lib/checks/keyboard/focusable-element-evaluate.js');
      var _checks_keyboard_focusable_modal_open_evaluate__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__('./lib/checks/keyboard/focusable-modal-open-evaluate.js');
      var _checks_keyboard_focusable_no_name_evaluate__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__('./lib/checks/keyboard/focusable-no-name-evaluate.js');
      var _checks_keyboard_focusable_not_tabbable_evaluate__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__('./lib/checks/keyboard/focusable-not-tabbable-evaluate.js');
      var _checks_keyboard_landmark_is_top_level_evaluate__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__('./lib/checks/keyboard/landmark-is-top-level-evaluate.js');
      var _checks_keyboard_tabindex_evaluate__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__('./lib/checks/keyboard/tabindex-evaluate.js');
      var _checks_label_alt_space_value_evaluate__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__('./lib/checks/label/alt-space-value-evaluate.js');
      var _checks_label_duplicate_img_label_evaluate__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__('./lib/checks/label/duplicate-img-label-evaluate.js');
      var _checks_label_explicit_evaluate__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__('./lib/checks/label/explicit-evaluate.js');
      var _checks_label_help_same_as_label_evaluate__WEBPACK_IMPORTED_MODULE_74__ = __webpack_require__('./lib/checks/label/help-same-as-label-evaluate.js');
      var _checks_label_hidden_explicit_label_evaluate__WEBPACK_IMPORTED_MODULE_75__ = __webpack_require__('./lib/checks/label/hidden-explicit-label-evaluate.js');
      var _checks_label_implicit_evaluate__WEBPACK_IMPORTED_MODULE_76__ = __webpack_require__('./lib/checks/label/implicit-evaluate.js');
      var _checks_label_label_content_name_mismatch_evaluate__WEBPACK_IMPORTED_MODULE_77__ = __webpack_require__('./lib/checks/label/label-content-name-mismatch-evaluate.js');
      var _checks_label_multiple_label_evaluate__WEBPACK_IMPORTED_MODULE_78__ = __webpack_require__('./lib/checks/label/multiple-label-evaluate.js');
      var _checks_label_title_only_evaluate__WEBPACK_IMPORTED_MODULE_79__ = __webpack_require__('./lib/checks/label/title-only-evaluate.js');
      var _checks_landmarks_landmark_is_unique_after__WEBPACK_IMPORTED_MODULE_80__ = __webpack_require__('./lib/checks/landmarks/landmark-is-unique-after.js');
      var _checks_landmarks_landmark_is_unique_evaluate__WEBPACK_IMPORTED_MODULE_81__ = __webpack_require__('./lib/checks/landmarks/landmark-is-unique-evaluate.js');
      var _checks_language_has_lang_evaluate__WEBPACK_IMPORTED_MODULE_82__ = __webpack_require__('./lib/checks/language/has-lang-evaluate.js');
      var _checks_language_valid_lang_evaluate__WEBPACK_IMPORTED_MODULE_83__ = __webpack_require__('./lib/checks/language/valid-lang-evaluate.js');
      var _checks_language_xml_lang_mismatch_evaluate__WEBPACK_IMPORTED_MODULE_84__ = __webpack_require__('./lib/checks/language/xml-lang-mismatch-evaluate.js');
      var _checks_lists_dlitem_evaluate__WEBPACK_IMPORTED_MODULE_85__ = __webpack_require__('./lib/checks/lists/dlitem-evaluate.js');
      var _checks_lists_listitem_evaluate__WEBPACK_IMPORTED_MODULE_86__ = __webpack_require__('./lib/checks/lists/listitem-evaluate.js');
      var _checks_lists_only_dlitems_evaluate__WEBPACK_IMPORTED_MODULE_87__ = __webpack_require__('./lib/checks/lists/only-dlitems-evaluate.js');
      var _checks_lists_only_listitems_evaluate__WEBPACK_IMPORTED_MODULE_88__ = __webpack_require__('./lib/checks/lists/only-listitems-evaluate.js');
      var _checks_lists_structured_dlitems_evaluate__WEBPACK_IMPORTED_MODULE_89__ = __webpack_require__('./lib/checks/lists/structured-dlitems-evaluate.js');
      var _checks_media_caption_evaluate__WEBPACK_IMPORTED_MODULE_90__ = __webpack_require__('./lib/checks/media/caption-evaluate.js');
      var _checks_media_frame_tested_evaluate__WEBPACK_IMPORTED_MODULE_91__ = __webpack_require__('./lib/checks/media/frame-tested-evaluate.js');
      var _checks_media_no_autoplay_audio_evaluate__WEBPACK_IMPORTED_MODULE_92__ = __webpack_require__('./lib/checks/media/no-autoplay-audio-evaluate.js');
      var _rules_aria_allowed_attr_matches__WEBPACK_IMPORTED_MODULE_93__ = __webpack_require__('./lib/rules/aria-allowed-attr-matches.js');
      var _rules_aria_allowed_role_matches__WEBPACK_IMPORTED_MODULE_94__ = __webpack_require__('./lib/rules/aria-allowed-role-matches.js');
      var _rules_aria_form_field_name_matches__WEBPACK_IMPORTED_MODULE_95__ = __webpack_require__('./lib/rules/aria-form-field-name-matches.js');
      var _rules_aria_has_attr_matches__WEBPACK_IMPORTED_MODULE_96__ = __webpack_require__('./lib/rules/aria-has-attr-matches.js');
      var _rules_aria_hidden_focus_matches__WEBPACK_IMPORTED_MODULE_97__ = __webpack_require__('./lib/rules/aria-hidden-focus-matches.js');
      var _rules_autocomplete_matches__WEBPACK_IMPORTED_MODULE_98__ = __webpack_require__('./lib/rules/autocomplete-matches.js');
      var _rules_bypass_matches__WEBPACK_IMPORTED_MODULE_99__ = __webpack_require__('./lib/rules/bypass-matches.js');
      var _rules_color_contrast_matches__WEBPACK_IMPORTED_MODULE_100__ = __webpack_require__('./lib/rules/color-contrast-matches.js');
      var _rules_data_table_large_matches__WEBPACK_IMPORTED_MODULE_101__ = __webpack_require__('./lib/rules/data-table-large-matches.js');
      var _rules_data_table_matches__WEBPACK_IMPORTED_MODULE_102__ = __webpack_require__('./lib/rules/data-table-matches.js');
      var _rules_duplicate_id_active_matches__WEBPACK_IMPORTED_MODULE_103__ = __webpack_require__('./lib/rules/duplicate-id-active-matches.js');
      var _rules_duplicate_id_aria_matches__WEBPACK_IMPORTED_MODULE_104__ = __webpack_require__('./lib/rules/duplicate-id-aria-matches.js');
      var _rules_duplicate_id_misc_matches__WEBPACK_IMPORTED_MODULE_105__ = __webpack_require__('./lib/rules/duplicate-id-misc-matches.js');
      var _rules_frame_title_has_text_matches__WEBPACK_IMPORTED_MODULE_106__ = __webpack_require__('./lib/rules/frame-title-has-text-matches.js');
      var _rules_heading_matches__WEBPACK_IMPORTED_MODULE_107__ = __webpack_require__('./lib/rules/heading-matches.js');
      var _rules_html_namespace_matches__WEBPACK_IMPORTED_MODULE_108__ = __webpack_require__('./lib/rules/html-namespace-matches.js');
      var _rules_identical_links_same_purpose_matches__WEBPACK_IMPORTED_MODULE_109__ = __webpack_require__('./lib/rules/identical-links-same-purpose-matches.js');
      var _rules_inserted_into_focus_order_matches__WEBPACK_IMPORTED_MODULE_110__ = __webpack_require__('./lib/rules/inserted-into-focus-order-matches.js');
      var _rules_label_content_name_mismatch_matches__WEBPACK_IMPORTED_MODULE_111__ = __webpack_require__('./lib/rules/label-content-name-mismatch-matches.js');
      var _rules_label_matches__WEBPACK_IMPORTED_MODULE_112__ = __webpack_require__('./lib/rules/label-matches.js');
      var _rules_landmark_has_body_context_matches__WEBPACK_IMPORTED_MODULE_113__ = __webpack_require__('./lib/rules/landmark-has-body-context-matches.js');
      var _rules_landmark_unique_matches__WEBPACK_IMPORTED_MODULE_114__ = __webpack_require__('./lib/rules/landmark-unique-matches.js');
      var _rules_layout_table_matches__WEBPACK_IMPORTED_MODULE_115__ = __webpack_require__('./lib/rules/layout-table-matches.js');
      var _rules_link_in_text_block_matches__WEBPACK_IMPORTED_MODULE_116__ = __webpack_require__('./lib/rules/link-in-text-block-matches.js');
      var _rules_no_autoplay_audio_matches__WEBPACK_IMPORTED_MODULE_117__ = __webpack_require__('./lib/rules/no-autoplay-audio-matches.js');
      var _rules_no_empty_role_matches__WEBPACK_IMPORTED_MODULE_118__ = __webpack_require__('./lib/rules/no-empty-role-matches.js');
      var _rules_no_role_matches__WEBPACK_IMPORTED_MODULE_119__ = __webpack_require__('./lib/rules/no-role-matches.js');
      var _rules_not_html_matches__WEBPACK_IMPORTED_MODULE_120__ = __webpack_require__('./lib/rules/not-html-matches.js');
      var _rules_p_as_heading_matches__WEBPACK_IMPORTED_MODULE_121__ = __webpack_require__('./lib/rules/p-as-heading-matches.js');
      var _rules_scrollable_region_focusable_matches__WEBPACK_IMPORTED_MODULE_122__ = __webpack_require__('./lib/rules/scrollable-region-focusable-matches.js');
      var _rules_skip_link_matches__WEBPACK_IMPORTED_MODULE_123__ = __webpack_require__('./lib/rules/skip-link-matches.js');
      var _rules_svg_namespace_matches__WEBPACK_IMPORTED_MODULE_124__ = __webpack_require__('./lib/rules/svg-namespace-matches.js');
      var _rules_window_is_top_matches__WEBPACK_IMPORTED_MODULE_125__ = __webpack_require__('./lib/rules/window-is-top-matches.js');
      var _rules_xml_lang_mismatch_matches__WEBPACK_IMPORTED_MODULE_126__ = __webpack_require__('./lib/rules/xml-lang-mismatch-matches.js');
      var metadataFunctionMap = {
        'abstractrole-evaluate': _checks_aria_abstractrole_evaluate__WEBPACK_IMPORTED_MODULE_0__['default'],
        'aria-allowed-attr-evaluate': _checks_aria_aria_allowed_attr_evaluate__WEBPACK_IMPORTED_MODULE_1__['default'],
        'aria-allowed-role-evaluate': _checks_aria_aria_allowed_role_evaluate__WEBPACK_IMPORTED_MODULE_2__['default'],
        'aria-errormessage-evaluate': _checks_aria_aria_errormessage_evaluate__WEBPACK_IMPORTED_MODULE_3__['default'],
        'aria-hidden-body-evaluate': _checks_aria_aria_hidden_body_evaluate__WEBPACK_IMPORTED_MODULE_4__['default'],
        'aria-required-attr-evaluate': _checks_aria_aria_required_attr_evaluate__WEBPACK_IMPORTED_MODULE_5__['default'],
        'aria-required-children-evaluate': _checks_aria_aria_required_children_evaluate__WEBPACK_IMPORTED_MODULE_6__['default'],
        'aria-required-parent-evaluate': _checks_aria_aria_required_parent_evaluate__WEBPACK_IMPORTED_MODULE_7__['default'],
        'aria-roledescription-evaluate': _checks_aria_aria_roledescription_evaluate__WEBPACK_IMPORTED_MODULE_8__['default'],
        'aria-unsupported-attr-evaluate': _checks_aria_aria_unsupported_attr_evaluate__WEBPACK_IMPORTED_MODULE_9__['default'],
        'aria-valid-attr-evaluate': _checks_aria_aria_valid_attr_evaluate__WEBPACK_IMPORTED_MODULE_10__['default'],
        'aria-valid-attr-value-evaluate': _checks_aria_aria_valid_attr_value_evaluate__WEBPACK_IMPORTED_MODULE_11__['default'],
        'fallbackrole-evaluate': _checks_aria_fallbackrole_evaluate__WEBPACK_IMPORTED_MODULE_12__['default'],
        'has-widget-role-evaluate': _checks_aria_has_widget_role_evaluate__WEBPACK_IMPORTED_MODULE_13__['default'],
        'invalidrole-evaluate': _checks_aria_invalidrole_evaluate__WEBPACK_IMPORTED_MODULE_14__['default'],
        'no-implicit-explicit-label-evaluate': _checks_aria_no_implicit_explicit_label_evaluate__WEBPACK_IMPORTED_MODULE_15__['default'],
        'unsupportedrole-evaluate': _checks_aria_unsupportedrole_evaluate__WEBPACK_IMPORTED_MODULE_16__['default'],
        'valid-scrollable-semantics-evaluate': _checks_aria_valid_scrollable_semantics_evaluate__WEBPACK_IMPORTED_MODULE_17__['default'],
        'caption-faked-evaluate': _checks_tables_caption_faked_evaluate__WEBPACK_IMPORTED_MODULE_18__['default'],
        'html5-scope-evaluate': _checks_tables_html5_scope_evaluate__WEBPACK_IMPORTED_MODULE_19__['default'],
        'same-caption-summary-evaluate': _checks_tables_same_caption_summary_evaluate__WEBPACK_IMPORTED_MODULE_20__['default'],
        'scope-value-evaluate': _checks_tables_scope_value_evaluate__WEBPACK_IMPORTED_MODULE_21__['default'],
        'td-has-header-evaluate': _checks_tables_td_has_header_evaluate__WEBPACK_IMPORTED_MODULE_22__['default'],
        'td-headers-attr-evaluate': _checks_tables_td_headers_attr_evaluate__WEBPACK_IMPORTED_MODULE_23__['default'],
        'th-has-data-cells-evaluate': _checks_tables_th_has_data_cells_evaluate__WEBPACK_IMPORTED_MODULE_24__['default'],
        'hidden-content-evaluate': _checks_visibility_hidden_content_evaluate__WEBPACK_IMPORTED_MODULE_25__['default'],
        'color-contrast-evaluate': _checks_color_color_contrast_evaluate__WEBPACK_IMPORTED_MODULE_26__['default'],
        'link-in-text-block-evaluate': _checks_color_link_in_text_block_evaluate__WEBPACK_IMPORTED_MODULE_27__['default'],
        'autocomplete-appropriate-evaluate': _checks_forms_autocomplete_appropriate_evaluate__WEBPACK_IMPORTED_MODULE_28__['default'],
        'autocomplete-valid-evaluate': _checks_forms_autocomplete_valid_evaluate__WEBPACK_IMPORTED_MODULE_29__['default'],
        'attr-non-space-content-evaluate': _checks_generic_attr_non_space_content_evaluate__WEBPACK_IMPORTED_MODULE_30__['default'],
        'has-descendant-after': _checks_generic_has_descendant_after__WEBPACK_IMPORTED_MODULE_31__['default'],
        'has-descendant-evaluate': _checks_generic_has_descendant_evaluate__WEBPACK_IMPORTED_MODULE_32__['default'],
        'has-text-content-evaluate': _checks_generic_has_text_content_evaluate__WEBPACK_IMPORTED_MODULE_33__['default'],
        'matches-definition-evaluate': _checks_generic_matches_definition_evaluate__WEBPACK_IMPORTED_MODULE_34__['default'],
        'page-no-duplicate-after': _checks_generic_page_no_duplicate_after__WEBPACK_IMPORTED_MODULE_35__['default'],
        'page-no-duplicate-evaluate': _checks_generic_page_no_duplicate_evaluate__WEBPACK_IMPORTED_MODULE_36__['default'],
        'heading-order-after': _checks_navigation_heading_order_after__WEBPACK_IMPORTED_MODULE_37__['default'],
        'heading-order-evaluate': _checks_navigation_heading_order_evaluate__WEBPACK_IMPORTED_MODULE_38__['default'],
        'identical-links-same-purpose-after': _checks_navigation_identical_links_same_purpose_after__WEBPACK_IMPORTED_MODULE_39__['default'],
        'identical-links-same-purpose-evaluate': _checks_navigation_identical_links_same_purpose_evaluate__WEBPACK_IMPORTED_MODULE_40__['default'],
        'internal-link-present-evaluate': _checks_navigation_internal_link_present_evaluate__WEBPACK_IMPORTED_MODULE_41__['default'],
        'meta-refresh-evaluate': _checks_navigation_meta_refresh_evaluate__WEBPACK_IMPORTED_MODULE_42__['default'],
        'p-as-heading-evaluate': _checks_navigation_p_as_heading_evaluate__WEBPACK_IMPORTED_MODULE_43__['default'],
        'region-evaluate': _checks_navigation_region_evaluate__WEBPACK_IMPORTED_MODULE_44__['default'],
        'skip-link-evaluate': _checks_navigation_skip_link_evaluate__WEBPACK_IMPORTED_MODULE_45__['default'],
        'unique-frame-title-after': _checks_navigation_unique_frame_title_after__WEBPACK_IMPORTED_MODULE_46__['default'],
        'unique-frame-title-evaluate': _checks_navigation_unique_frame_title_evaluate__WEBPACK_IMPORTED_MODULE_47__['default'],
        'aria-label-evaluate': _checks_shared_aria_label_evaluate__WEBPACK_IMPORTED_MODULE_48__['default'],
        'aria-labelledby-evaluate': _checks_shared_aria_labelledby_evaluate__WEBPACK_IMPORTED_MODULE_49__['default'],
        'avoid-inline-spacing-evaluate': _checks_shared_avoid_inline_spacing_evaluate__WEBPACK_IMPORTED_MODULE_50__['default'],
        'doc-has-title-evaluate': _checks_shared_doc_has_title_evaluate__WEBPACK_IMPORTED_MODULE_51__['default'],
        'exists-evaluate': _checks_shared_exists_evaluate__WEBPACK_IMPORTED_MODULE_52__['default'],
        'has-alt-evaluate': _checks_shared_has_alt_evaluate__WEBPACK_IMPORTED_MODULE_53__['default'],
        'is-on-screen-evaluate': _checks_shared_is_on_screen_evaluate__WEBPACK_IMPORTED_MODULE_54__['default'],
        'non-empty-if-present-evaluate': _checks_shared_non_empty_if_present_evaluate__WEBPACK_IMPORTED_MODULE_55__['default'],
        'svg-non-empty-title-evaluate': _checks_shared_svg_non_empty_title_evaluate__WEBPACK_IMPORTED_MODULE_56__['default'],
        'css-orientation-lock-evaluate': _checks_mobile_css_orientation_lock_evaluate__WEBPACK_IMPORTED_MODULE_57__['default'],
        'meta-viewport-scale-evaluate': _checks_mobile_meta_viewport_scale_evaluate__WEBPACK_IMPORTED_MODULE_58__['default'],
        'duplicate-id-after': _checks_parsing_duplicate_id_after__WEBPACK_IMPORTED_MODULE_59__['default'],
        'duplicate-id-evaluate': _checks_parsing_duplicate_id_evaluate__WEBPACK_IMPORTED_MODULE_60__['default'],
        'accesskeys-after': _checks_keyboard_accesskeys_after__WEBPACK_IMPORTED_MODULE_61__['default'],
        'accesskeys-evaluate': _checks_keyboard_accesskeys_evaluate__WEBPACK_IMPORTED_MODULE_62__['default'],
        'focusable-content-evaluate': _checks_keyboard_focusable_content_evaluate__WEBPACK_IMPORTED_MODULE_63__['default'],
        'focusable-disabled-evaluate': _checks_keyboard_focusable_disabled_evaluate__WEBPACK_IMPORTED_MODULE_64__['default'],
        'focusable-element-evaluate': _checks_keyboard_focusable_element_evaluate__WEBPACK_IMPORTED_MODULE_65__['default'],
        'focusable-modal-open-evaluate': _checks_keyboard_focusable_modal_open_evaluate__WEBPACK_IMPORTED_MODULE_66__['default'],
        'focusable-no-name-evaluate': _checks_keyboard_focusable_no_name_evaluate__WEBPACK_IMPORTED_MODULE_67__['default'],
        'focusable-not-tabbable-evaluate': _checks_keyboard_focusable_not_tabbable_evaluate__WEBPACK_IMPORTED_MODULE_68__['default'],
        'landmark-is-top-level-evaluate': _checks_keyboard_landmark_is_top_level_evaluate__WEBPACK_IMPORTED_MODULE_69__['default'],
        'tabindex-evaluate': _checks_keyboard_tabindex_evaluate__WEBPACK_IMPORTED_MODULE_70__['default'],
        'alt-space-value-evaluate': _checks_label_alt_space_value_evaluate__WEBPACK_IMPORTED_MODULE_71__['default'],
        'duplicate-img-label-evaluate': _checks_label_duplicate_img_label_evaluate__WEBPACK_IMPORTED_MODULE_72__['default'],
        'explicit-evaluate': _checks_label_explicit_evaluate__WEBPACK_IMPORTED_MODULE_73__['default'],
        'help-same-as-label-evaluate': _checks_label_help_same_as_label_evaluate__WEBPACK_IMPORTED_MODULE_74__['default'],
        'hidden-explicit-label-evaluate': _checks_label_hidden_explicit_label_evaluate__WEBPACK_IMPORTED_MODULE_75__['default'],
        'implicit-evaluate': _checks_label_implicit_evaluate__WEBPACK_IMPORTED_MODULE_76__['default'],
        'label-content-name-mismatch-evaluate': _checks_label_label_content_name_mismatch_evaluate__WEBPACK_IMPORTED_MODULE_77__['default'],
        'multiple-label-evaluate': _checks_label_multiple_label_evaluate__WEBPACK_IMPORTED_MODULE_78__['default'],
        'title-only-evaluate': _checks_label_title_only_evaluate__WEBPACK_IMPORTED_MODULE_79__['default'],
        'landmark-is-unique-after': _checks_landmarks_landmark_is_unique_after__WEBPACK_IMPORTED_MODULE_80__['default'],
        'landmark-is-unique-evaluate': _checks_landmarks_landmark_is_unique_evaluate__WEBPACK_IMPORTED_MODULE_81__['default'],
        'has-lang-evaluate': _checks_language_has_lang_evaluate__WEBPACK_IMPORTED_MODULE_82__['default'],
        'valid-lang-evaluate': _checks_language_valid_lang_evaluate__WEBPACK_IMPORTED_MODULE_83__['default'],
        'xml-lang-mismatch-evaluate': _checks_language_xml_lang_mismatch_evaluate__WEBPACK_IMPORTED_MODULE_84__['default'],
        'dlitem-evaluate': _checks_lists_dlitem_evaluate__WEBPACK_IMPORTED_MODULE_85__['default'],
        'listitem-evaluate': _checks_lists_listitem_evaluate__WEBPACK_IMPORTED_MODULE_86__['default'],
        'only-dlitems-evaluate': _checks_lists_only_dlitems_evaluate__WEBPACK_IMPORTED_MODULE_87__['default'],
        'only-listitems-evaluate': _checks_lists_only_listitems_evaluate__WEBPACK_IMPORTED_MODULE_88__['default'],
        'structured-dlitems-evaluate': _checks_lists_structured_dlitems_evaluate__WEBPACK_IMPORTED_MODULE_89__['default'],
        'caption-evaluate': _checks_media_caption_evaluate__WEBPACK_IMPORTED_MODULE_90__['default'],
        'frame-tested-evaluate': _checks_media_frame_tested_evaluate__WEBPACK_IMPORTED_MODULE_91__['default'],
        'no-autoplay-audio-evaluate': _checks_media_no_autoplay_audio_evaluate__WEBPACK_IMPORTED_MODULE_92__['default'],
        'aria-allowed-attr-matches': _rules_aria_allowed_attr_matches__WEBPACK_IMPORTED_MODULE_93__['default'],
        'aria-allowed-role-matches': _rules_aria_allowed_role_matches__WEBPACK_IMPORTED_MODULE_94__['default'],
        'aria-form-field-name-matches': _rules_aria_form_field_name_matches__WEBPACK_IMPORTED_MODULE_95__['default'],
        'aria-has-attr-matches': _rules_aria_has_attr_matches__WEBPACK_IMPORTED_MODULE_96__['default'],
        'aria-hidden-focus-matches': _rules_aria_hidden_focus_matches__WEBPACK_IMPORTED_MODULE_97__['default'],
        'autocomplete-matches': _rules_autocomplete_matches__WEBPACK_IMPORTED_MODULE_98__['default'],
        'bypass-matches': _rules_bypass_matches__WEBPACK_IMPORTED_MODULE_99__['default'],
        'color-contrast-matches': _rules_color_contrast_matches__WEBPACK_IMPORTED_MODULE_100__['default'],
        'data-table-large-matches': _rules_data_table_large_matches__WEBPACK_IMPORTED_MODULE_101__['default'],
        'data-table-matches': _rules_data_table_matches__WEBPACK_IMPORTED_MODULE_102__['default'],
        'duplicate-id-active-matches': _rules_duplicate_id_active_matches__WEBPACK_IMPORTED_MODULE_103__['default'],
        'duplicate-id-aria-matches': _rules_duplicate_id_aria_matches__WEBPACK_IMPORTED_MODULE_104__['default'],
        'duplicate-id-misc-matches': _rules_duplicate_id_misc_matches__WEBPACK_IMPORTED_MODULE_105__['default'],
        'frame-title-has-text-matches': _rules_frame_title_has_text_matches__WEBPACK_IMPORTED_MODULE_106__['default'],
        'heading-matches': _rules_heading_matches__WEBPACK_IMPORTED_MODULE_107__['default'],
        'html-namespace-matches': _rules_html_namespace_matches__WEBPACK_IMPORTED_MODULE_108__['default'],
        'identical-links-same-purpose-matches': _rules_identical_links_same_purpose_matches__WEBPACK_IMPORTED_MODULE_109__['default'],
        'inserted-into-focus-order-matches': _rules_inserted_into_focus_order_matches__WEBPACK_IMPORTED_MODULE_110__['default'],
        'label-content-name-mismatch-matches': _rules_label_content_name_mismatch_matches__WEBPACK_IMPORTED_MODULE_111__['default'],
        'label-matches': _rules_label_matches__WEBPACK_IMPORTED_MODULE_112__['default'],
        'landmark-has-body-context-matches': _rules_landmark_has_body_context_matches__WEBPACK_IMPORTED_MODULE_113__['default'],
        'landmark-unique-matches': _rules_landmark_unique_matches__WEBPACK_IMPORTED_MODULE_114__['default'],
        'layout-table-matches': _rules_layout_table_matches__WEBPACK_IMPORTED_MODULE_115__['default'],
        'link-in-text-block-matches': _rules_link_in_text_block_matches__WEBPACK_IMPORTED_MODULE_116__['default'],
        'no-autoplay-audio-matches': _rules_no_autoplay_audio_matches__WEBPACK_IMPORTED_MODULE_117__['default'],
        'no-empty-role-matches': _rules_no_empty_role_matches__WEBPACK_IMPORTED_MODULE_118__['default'],
        'no-role-matches': _rules_no_role_matches__WEBPACK_IMPORTED_MODULE_119__['default'],
        'not-html-matches': _rules_not_html_matches__WEBPACK_IMPORTED_MODULE_120__['default'],
        'p-as-heading-matches': _rules_p_as_heading_matches__WEBPACK_IMPORTED_MODULE_121__['default'],
        'scrollable-region-focusable-matches': _rules_scrollable_region_focusable_matches__WEBPACK_IMPORTED_MODULE_122__['default'],
        'skip-link-matches': _rules_skip_link_matches__WEBPACK_IMPORTED_MODULE_123__['default'],
        'svg-namespace-matches': _rules_svg_namespace_matches__WEBPACK_IMPORTED_MODULE_124__['default'],
        'window-is-top-matches': _rules_window_is_top_matches__WEBPACK_IMPORTED_MODULE_125__['default'],
        'xml-lang-mismatch-matches': _rules_xml_lang_mismatch_matches__WEBPACK_IMPORTED_MODULE_126__['default']
      };
      __webpack_exports__['default'] = metadataFunctionMap;
    },
    './lib/core/base/rule-result.js': function libCoreBaseRuleResultJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/constants.js');
      function RuleResult(rule) {
        this.id = rule.id;
        this.result = _constants__WEBPACK_IMPORTED_MODULE_0__['default'].NA;
        this.pageLevel = rule.pageLevel;
        this.impact = null;
        this.nodes = [];
      }
      __webpack_exports__['default'] = RuleResult;
    },
    './lib/core/base/rule.js': function libCoreBaseRuleJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _check__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/check.js');
      var _rule_result__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/rule-result.js');
      var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/constants.js');
      var _log__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/core/log.js');
      function Rule(spec, parentAudit) {
        this._audit = parentAudit;
        this.id = spec.id;
        this.selector = spec.selector || '*';
        if (spec.impact) {
          Object(_utils__WEBPACK_IMPORTED_MODULE_2__['assert'])(_constants__WEBPACK_IMPORTED_MODULE_3__['default'].impact.includes(spec.impact), 'Impact '.concat(spec.impact, ' is not a valid impact'));
          this.impact = spec.impact;
        }
        this.excludeHidden = typeof spec.excludeHidden === 'boolean' ? spec.excludeHidden : true;
        this.enabled = typeof spec.enabled === 'boolean' ? spec.enabled : true;
        this.pageLevel = typeof spec.pageLevel === 'boolean' ? spec.pageLevel : false;
        this.reviewOnFail = typeof spec.reviewOnFail === 'boolean' ? spec.reviewOnFail : false;
        this.any = spec.any || [];
        this.all = spec.all || [];
        this.none = spec.none || [];
        this.tags = spec.tags || [];
        this.preload = spec.preload ? true : false;
        if (spec.matches) {
          this.matches = Object(_check__WEBPACK_IMPORTED_MODULE_0__['createExecutionContext'])(spec.matches);
        }
      }
      Rule.prototype.matches = function() {
        return true;
      };
      Rule.prototype.gather = function(context) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var markStart = 'mark_gather_start_' + this.id;
        var markEnd = 'mark_gather_end_' + this.id;
        var markHiddenStart = 'mark_isHidden_start_' + this.id;
        var markHiddenEnd = 'mark_isHidden_end_' + this.id;
        if (options.performanceTimer) {
          _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].mark(markStart);
        }
        var elements = Object(_utils__WEBPACK_IMPORTED_MODULE_2__['select'])(this.selector, context);
        if (this.excludeHidden) {
          if (options.performanceTimer) {
            _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].mark(markHiddenStart);
          }
          elements = elements.filter(function(element) {
            return !Object(_utils__WEBPACK_IMPORTED_MODULE_2__['isHidden'])(element.actualNode);
          });
          if (options.performanceTimer) {
            _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].mark(markHiddenEnd);
            _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].measure('rule_' + this.id + '#gather_axe.utils.isHidden', markHiddenStart, markHiddenEnd);
          }
        }
        if (options.performanceTimer) {
          _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].mark(markEnd);
          _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].measure('rule_' + this.id + '#gather', markStart, markEnd);
        }
        return elements;
      };
      Rule.prototype.runChecks = function(type, node, options, context, resolve, reject) {
        var self = this;
        var checkQueue = Object(_utils__WEBPACK_IMPORTED_MODULE_2__['queue'])();
        this[type].forEach(function(c) {
          var check = self._audit.checks[c.id || c];
          var option = Object(_utils__WEBPACK_IMPORTED_MODULE_2__['getCheckOption'])(check, self.id, options);
          checkQueue.defer(function(res, rej) {
            check.run(node, option, context, res, rej);
          });
        });
        checkQueue.then(function(results) {
          results = results.filter(function(check) {
            return check;
          });
          resolve({
            type: type,
            results: results
          });
        })['catch'](reject);
      };
      Rule.prototype.runChecksSync = function(type, node, options, context) {
        var self = this;
        var results = [];
        this[type].forEach(function(c) {
          var check = self._audit.checks[c.id || c];
          var option = Object(_utils__WEBPACK_IMPORTED_MODULE_2__['getCheckOption'])(check, self.id, options);
          results.push(check.runSync(node, option, context));
        });
        results = results.filter(function(check) {
          return check;
        });
        return {
          type: type,
          results: results
        };
      };
      Rule.prototype.run = function(context) {
        var _this4 = this;
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var resolve = arguments.length > 2 ? arguments[2] : undefined;
        var reject = arguments.length > 3 ? arguments[3] : undefined;
        if (options.performanceTimer) {
          this._trackPerformance();
        }
        var q = Object(_utils__WEBPACK_IMPORTED_MODULE_2__['queue'])();
        var ruleResult = new _rule_result__WEBPACK_IMPORTED_MODULE_1__['default'](this);
        var nodes;
        try {
          nodes = this.gatherAndMatchNodes(context, options);
        } catch (error) {
          reject(new SupportError({
            cause: error,
            ruleId: this.id
          }));
          return;
        }
        if (options.performanceTimer) {
          this._logGatherPerformance(nodes);
        }
        nodes.forEach(function(node) {
          q.defer(function(resolveNode, rejectNode) {
            var checkQueue = Object(_utils__WEBPACK_IMPORTED_MODULE_2__['queue'])();
            [ 'any', 'all', 'none' ].forEach(function(type) {
              checkQueue.defer(function(res, rej) {
                _this4.runChecks(type, node, options, context, res, rej);
              });
            });
            checkQueue.then(function(results) {
              var result = getResult(results);
              if (result) {
                result.node = new _utils__WEBPACK_IMPORTED_MODULE_2__['DqElement'](node.actualNode, options);
                ruleResult.nodes.push(result);
                if (_this4.reviewOnFail) {
                  [ 'any', 'all' ].forEach(function(type) {
                    result[type].forEach(function(checkResult) {
                      if (checkResult.result === false) {
                        checkResult.result = undefined;
                      }
                    });
                  });
                  result.none.forEach(function(checkResult) {
                    if (checkResult.result === true) {
                      checkResult.result = undefined;
                    }
                  });
                }
              }
              resolveNode();
            })['catch'](function(err) {
              return rejectNode(err);
            });
          });
        });
        q.defer(function(resolve) {
          return setTimeout(resolve, 0);
        });
        if (options.performanceTimer) {
          this._logRulePerformance();
        }
        q.then(function() {
          return resolve(ruleResult);
        })['catch'](function(error) {
          return reject(error);
        });
      };
      Rule.prototype.runSync = function(context) {
        var _this5 = this;
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        if (options.performanceTimer) {
          this._trackPerformance();
        }
        var ruleResult = new _rule_result__WEBPACK_IMPORTED_MODULE_1__['default'](this);
        var nodes;
        try {
          nodes = this.gatherAndMatchNodes(context, options);
        } catch (error) {
          throw new SupportError({
            cause: error,
            ruleId: this.id
          });
        }
        if (options.performanceTimer) {
          this._logGatherPerformance(nodes);
        }
        nodes.forEach(function(node) {
          var results = [];
          [ 'any', 'all', 'none' ].forEach(function(type) {
            results.push(_this5.runChecksSync(type, node, options, context));
          });
          var result = getResult(results);
          if (result) {
            result.node = node.actualNode ? new _utils__WEBPACK_IMPORTED_MODULE_2__['DqElement'](node.actualNode, options) : null;
            ruleResult.nodes.push(result);
            if (_this5.reviewOnFail) {
              [ 'any', 'all' ].forEach(function(type) {
                result[type].forEach(function(checkResult) {
                  if (checkResult.result === false) {
                    checkResult.result = undefined;
                  }
                });
              });
              result.none.forEach(function(checkResult) {
                if (checkResult.result === true) {
                  checkResult.result = undefined;
                }
              });
            }
          }
        });
        if (options.performanceTimer) {
          this._logRulePerformance();
        }
        return ruleResult;
      };
      Rule.prototype._trackPerformance = function() {
        this._markStart = 'mark_rule_start_' + this.id;
        this._markEnd = 'mark_rule_end_' + this.id;
        this._markChecksStart = 'mark_runchecks_start_' + this.id;
        this._markChecksEnd = 'mark_runchecks_end_' + this.id;
      };
      Rule.prototype._logGatherPerformance = function(nodes) {
        Object(_log__WEBPACK_IMPORTED_MODULE_4__['default'])('gather (', nodes.length, '):', _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].timeElapsed() + 'ms');
        _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].mark(this._markChecksStart);
      };
      Rule.prototype._logRulePerformance = function() {
        _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].mark(this._markChecksEnd);
        _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].mark(this._markEnd);
        _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].measure('runchecks_' + this.id, this._markChecksStart, this._markChecksEnd);
        _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].measure('rule_' + this.id, this._markStart, this._markEnd);
      };
      function getResult(results) {
        if (results.length) {
          var hasResults = false, result = {};
          results.forEach(function(r) {
            var res = r.results.filter(function(result) {
              return result;
            });
            result[r.type] = res;
            if (res.length) {
              hasResults = true;
            }
          });
          if (hasResults) {
            return result;
          }
          return null;
        }
      }
      Rule.prototype.gatherAndMatchNodes = function(context, options) {
        var _this6 = this;
        var markMatchesStart = 'mark_matches_start_' + this.id;
        var markMatchesEnd = 'mark_matches_end_' + this.id;
        var nodes = this.gather(context, options);
        if (options.performanceTimer) {
          _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].mark(markMatchesStart);
        }
        nodes = nodes.filter(function(node) {
          return _this6.matches(node.actualNode, node, context);
        });
        if (options.performanceTimer) {
          _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].mark(markMatchesEnd);
          _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].measure('rule_' + this.id + '#matches', markMatchesStart, markMatchesEnd);
        }
        return nodes;
      };
      function findAfterChecks(rule) {
        return Object(_utils__WEBPACK_IMPORTED_MODULE_2__['getAllChecks'])(rule).map(function(c) {
          var check = rule._audit.checks[c.id || c];
          return check && typeof check.after === 'function' ? check : null;
        }).filter(Boolean);
      }
      function findCheckResults(nodes, checkID) {
        var checkResults = [];
        nodes.forEach(function(nodeResult) {
          var checks = Object(_utils__WEBPACK_IMPORTED_MODULE_2__['getAllChecks'])(nodeResult);
          checks.forEach(function(checkResult) {
            if (checkResult.id === checkID) {
              checkResults.push(checkResult);
            }
          });
        });
        return checkResults;
      }
      function filterChecks(checks) {
        return checks.filter(function(check) {
          return check.filtered !== true;
        });
      }
      function sanitizeNodes(result) {
        var checkTypes = [ 'any', 'all', 'none' ];
        var nodes = result.nodes.filter(function(detail) {
          var length = 0;
          checkTypes.forEach(function(type) {
            detail[type] = filterChecks(detail[type]);
            length += detail[type].length;
          });
          return length > 0;
        });
        if (result.pageLevel && nodes.length) {
          nodes = [ nodes.reduce(function(a, b) {
            if (a) {
              checkTypes.forEach(function(type) {
                a[type].push.apply(a[type], b[type]);
              });
              return a;
            }
          }) ];
        }
        return nodes;
      }
      Rule.prototype.after = function(result, options) {
        var afterChecks = findAfterChecks(this);
        var ruleID = this.id;
        afterChecks.forEach(function(check) {
          var beforeResults = findCheckResults(result.nodes, check.id);
          var option = Object(_utils__WEBPACK_IMPORTED_MODULE_2__['getCheckOption'])(check, ruleID, options);
          var afterResults = check.after(beforeResults, option);
          beforeResults.forEach(function(item) {
            if (afterResults.indexOf(item) === -1) {
              item.filtered = true;
            }
          });
        });
        result.nodes = sanitizeNodes(result);
        return result;
      };
      Rule.prototype.configure = function(spec) {
        if (spec.hasOwnProperty('selector')) {
          this.selector = spec.selector;
        }
        if (spec.hasOwnProperty('excludeHidden')) {
          this.excludeHidden = typeof spec.excludeHidden === 'boolean' ? spec.excludeHidden : true;
        }
        if (spec.hasOwnProperty('enabled')) {
          this.enabled = typeof spec.enabled === 'boolean' ? spec.enabled : true;
        }
        if (spec.hasOwnProperty('pageLevel')) {
          this.pageLevel = typeof spec.pageLevel === 'boolean' ? spec.pageLevel : false;
        }
        if (spec.hasOwnProperty('reviewOnFail')) {
          this.reviewOnFail = typeof spec.reviewOnFail === 'boolean' ? spec.reviewOnFail : false;
        }
        if (spec.hasOwnProperty('any')) {
          this.any = spec.any;
        }
        if (spec.hasOwnProperty('all')) {
          this.all = spec.all;
        }
        if (spec.hasOwnProperty('none')) {
          this.none = spec.none;
        }
        if (spec.hasOwnProperty('tags')) {
          this.tags = spec.tags;
        }
        if (spec.hasOwnProperty('matches')) {
          this.matches = Object(_check__WEBPACK_IMPORTED_MODULE_0__['createExecutionContext'])(spec.matches);
        }
        if (spec.impact) {
          Object(_utils__WEBPACK_IMPORTED_MODULE_2__['assert'])(_constants__WEBPACK_IMPORTED_MODULE_3__['default'].impact.includes(spec.impact), 'Impact '.concat(spec.impact, ' is not a valid impact'));
          this.impact = spec.impact;
        }
      };
      __webpack_exports__['default'] = Rule;
    },
    './lib/core/base/virtual-node/abstract-virtual-node.js': function libCoreBaseVirtualNodeAbstractVirtualNodeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var whitespaceRegex = /[\t\r\n\f]/g;
      var AbstractVirtualNode = function() {
        function AbstractVirtualNode() {
          _classCallCheck(this, AbstractVirtualNode);
          this.parent = undefined;
        }
        _createClass(AbstractVirtualNode, [ {
          key: 'attr',
          value: function attr() {
            throw new Error('VirtualNode class must have a "attr" function');
          }
        }, {
          key: 'hasAttr',
          value: function hasAttr() {
            throw new Error('VirtualNode class must have a "hasAttr" function');
          }
        }, {
          key: 'hasClass',
          value: function hasClass(className) {
            var classAttr = this.attr('class');
            if (!classAttr) {
              return false;
            }
            var selector = ' ' + className + ' ';
            return (' ' + classAttr + ' ').replace(whitespaceRegex, ' ').indexOf(selector) >= 0;
          }
        }, {
          key: 'props',
          get: function get() {
            throw new Error('VirtualNode class must have a "props" object consisting ' + 'of "nodeType" and "nodeName" properties');
          }
        } ]);
        return AbstractVirtualNode;
      }();
      __webpack_exports__['default'] = AbstractVirtualNode;
    },
    './lib/core/base/virtual-node/serial-virtual-node.js': function libCoreBaseVirtualNodeSerialVirtualNodeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _abstract_virtual_node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      var SerialVirtualNode = function(_abstract_virtual_nod) {
        _inherits(SerialVirtualNode, _abstract_virtual_nod);
        var _super = _createSuper(SerialVirtualNode);
        function SerialVirtualNode(serialNode) {
          var _this7;
          _classCallCheck(this, SerialVirtualNode);
          _this7 = _super.call(this);
          _this7._props = normaliseProps(serialNode);
          _this7._attrs = normaliseAttrs(serialNode);
          return _this7;
        }
        _createClass(SerialVirtualNode, [ {
          key: 'attr',
          value: function attr(attrName) {
            return this._attrs[attrName] || null;
          }
        }, {
          key: 'hasAttr',
          value: function hasAttr(attrName) {
            return this._attrs[attrName] !== undefined;
          }
        }, {
          key: 'props',
          get: function get() {
            return this._props;
          }
        } ]);
        return SerialVirtualNode;
      }(_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_0__['default']);
      function normaliseProps(serialNode) {
        var nodeName = serialNode.nodeName, _serialNode$nodeType = serialNode.nodeType, nodeType = _serialNode$nodeType === void 0 ? 1 : _serialNode$nodeType;
        Object(_utils__WEBPACK_IMPORTED_MODULE_1__['assert'])(typeof nodeType === 'number', 'nodeType has to be a number, got \''.concat(nodeType, '\''));
        Object(_utils__WEBPACK_IMPORTED_MODULE_1__['assert'])(typeof nodeName === 'string', 'nodeName has to be a string, got \''.concat(nodeName, '\''));
        nodeName = nodeName.toLowerCase();
        var type = null;
        if (nodeName === 'input') {
          type = (serialNode.type || serialNode.attributes && serialNode.attributes.type || '').toLowerCase();
          if (!Object(_utils__WEBPACK_IMPORTED_MODULE_1__['validInputTypes'])().includes(type)) {
            type = 'text';
          }
        }
        var props = _extends({}, serialNode, {
          nodeType: nodeType,
          nodeName: nodeName
        });
        if (type) {
          props.type = type;
        }
        delete props.attributes;
        return Object.freeze(props);
      }
      function normaliseAttrs(_ref54) {
        var _ref54$attributes = _ref54.attributes, attributes = _ref54$attributes === void 0 ? {} : _ref54$attributes;
        var attrMap = {
          htmlFor: 'for',
          className: 'class'
        };
        return Object.keys(attributes).reduce(function(attrs, attrName) {
          var value = attributes[attrName];
          Object(_utils__WEBPACK_IMPORTED_MODULE_1__['assert'])(_typeof(value) !== 'object' || value === null, 'expects attributes not to be an object, \''.concat(attrName, '\' was'));
          if (value !== undefined) {
            var mappedName = attrMap[attrName] || attrName;
            attrs[mappedName] = value !== null ? String(value) : null;
          }
          return attrs;
        }, {});
      }
      __webpack_exports__['default'] = SerialVirtualNode;
    },
    './lib/core/base/virtual-node/virtual-node.js': function libCoreBaseVirtualNodeVirtualNodeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _abstract_virtual_node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      var _commons_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/dom/index.js');
      var _cache__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/base/cache.js');
      var isXHTMLGlobal;
      var VirtualNode = function(_abstract_virtual_nod2) {
        _inherits(VirtualNode, _abstract_virtual_nod2);
        var _super2 = _createSuper(VirtualNode);
        function VirtualNode(node, parent, shadowId) {
          var _this8;
          _classCallCheck(this, VirtualNode);
          _this8 = _super2.call(this);
          _this8.shadowId = shadowId;
          _this8.children = [];
          _this8.actualNode = node;
          _this8.parent = parent;
          _this8._isHidden = null;
          _this8._cache = {};
          if (typeof isXHTMLGlobal === 'undefined') {
            isXHTMLGlobal = Object(_utils__WEBPACK_IMPORTED_MODULE_1__['isXHTML'])(node.ownerDocument);
          }
          _this8._isXHTML = isXHTMLGlobal;
          if (node.nodeName.toLowerCase() === 'input') {
            var type = node.getAttribute('type');
            type = _this8._isXHTML ? type : (type || '').toLowerCase();
            if (!Object(_utils__WEBPACK_IMPORTED_MODULE_1__['validInputTypes'])().includes(type)) {
              type = 'text';
            }
            _this8._type = type;
          }
          if (_cache__WEBPACK_IMPORTED_MODULE_3__['default'].get('nodeMap')) {
            _cache__WEBPACK_IMPORTED_MODULE_3__['default'].get('nodeMap').set(node, _assertThisInitialized(_this8));
          }
          return _this8;
        }
        _createClass(VirtualNode, [ {
          key: 'attr',
          value: function attr(attrName) {
            if (typeof this.actualNode.getAttribute !== 'function') {
              return null;
            }
            return this.actualNode.getAttribute(attrName);
          }
        }, {
          key: 'hasAttr',
          value: function hasAttr(attrName) {
            if (typeof this.actualNode.hasAttribute !== 'function') {
              return false;
            }
            return this.actualNode.hasAttribute(attrName);
          }
        }, {
          key: 'getComputedStylePropertyValue',
          value: function getComputedStylePropertyValue(property) {
            var key = 'computedStyle_' + property;
            if (!this._cache.hasOwnProperty(key)) {
              if (!this._cache.hasOwnProperty('computedStyle')) {
                this._cache.computedStyle = window.getComputedStyle(this.actualNode);
              }
              this._cache[key] = this._cache.computedStyle.getPropertyValue(property);
            }
            return this._cache[key];
          }
        }, {
          key: 'props',
          get: function get() {
            var _this$actualNode = this.actualNode, nodeType = _this$actualNode.nodeType, nodeName = _this$actualNode.nodeName, id = _this$actualNode.id, multiple = _this$actualNode.multiple, nodeValue = _this$actualNode.nodeValue, value = _this$actualNode.value;
            return {
              nodeType: nodeType,
              nodeName: this._isXHTML ? nodeName : nodeName.toLowerCase(),
              id: id,
              type: this._type,
              multiple: multiple,
              nodeValue: nodeValue,
              value: value
            };
          }
        }, {
          key: 'isFocusable',
          get: function get() {
            if (!this._cache.hasOwnProperty('isFocusable')) {
              this._cache.isFocusable = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_2__['isFocusable'])(this.actualNode);
            }
            return this._cache.isFocusable;
          }
        }, {
          key: 'tabbableElements',
          get: function get() {
            if (!this._cache.hasOwnProperty('tabbableElements')) {
              this._cache.tabbableElements = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_2__['getTabbableElements'])(this);
            }
            return this._cache.tabbableElements;
          }
        }, {
          key: 'clientRects',
          get: function get() {
            if (!this._cache.hasOwnProperty('clientRects')) {
              this._cache.clientRects = Array.from(this.actualNode.getClientRects()).filter(function(rect) {
                return rect.width > 0;
              });
            }
            return this._cache.clientRects;
          }
        }, {
          key: 'boundingClientRect',
          get: function get() {
            if (!this._cache.hasOwnProperty('boundingClientRect')) {
              this._cache.boundingClientRect = this.actualNode.getBoundingClientRect();
            }
            return this._cache.boundingClientRect;
          }
        } ]);
        return VirtualNode;
      }(_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_0__['default']);
      __webpack_exports__['default'] = VirtualNode;
    },
    './lib/core/constants.js': function libCoreConstantsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var definitions = [ {
        name: 'NA',
        value: 'inapplicable',
        priority: 0,
        group: 'inapplicable'
      }, {
        name: 'PASS',
        value: 'passed',
        priority: 1,
        group: 'passes'
      }, {
        name: 'CANTTELL',
        value: 'cantTell',
        priority: 2,
        group: 'incomplete'
      }, {
        name: 'FAIL',
        value: 'failed',
        priority: 3,
        group: 'violations'
      } ];
      var constants = {
        helpUrlBase: 'https://dequeuniversity.com/rules/',
        results: [],
        resultGroups: [],
        resultGroupMap: {},
        impact: Object.freeze([ 'minor', 'moderate', 'serious', 'critical' ]),
        preload: Object.freeze({
          assets: [ 'cssom', 'media' ],
          timeout: 1e4
        })
      };
      definitions.forEach(function(definition) {
        var name = definition.name;
        var value = definition.value;
        var priority = definition.priority;
        var group = definition.group;
        constants[name] = value;
        constants[name + '_PRIO'] = priority;
        constants[name + '_GROUP'] = group;
        constants.results[priority] = value;
        constants.resultGroups[priority] = group;
        constants.resultGroupMap[value] = group;
      });
      Object.freeze(constants.results);
      Object.freeze(constants.resultGroups);
      Object.freeze(constants.resultGroupMap);
      Object.freeze(constants);
      __webpack_exports__['default'] = constants;
    },
    './lib/core/core.js': function libCoreCoreJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/constants.js');
      var _log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/log.js');
      var _base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _base_virtual_node_serial_virtual_node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/base/virtual-node/serial-virtual-node.js');
      var _base_virtual_node_virtual_node__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/core/base/virtual-node/virtual-node.js');
      var _base_cache__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/core/base/cache.js');
      var _base_audit__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/core/base/audit.js');
      var _base_check_result__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/core/base/check-result.js');
      var _base_check__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__('./lib/core/base/check.js');
      var _base_context__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__('./lib/core/base/context.js');
      var _base_metadata_function_map__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__('./lib/core/base/metadata-function-map.js');
      var _base_rule_result__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__('./lib/core/base/rule-result.js');
      var _base_rule__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__('./lib/core/base/rule.js');
      var _imports__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__('./lib/core/imports/index.js');
      var _public_cleanup__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__('./lib/core/public/cleanup.js');
      var _public_configure__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__('./lib/core/public/configure.js');
      var _public_get_rules__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__('./lib/core/public/get-rules.js');
      var _public_load__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__('./lib/core/public/load.js');
      var _public_plugins__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__('./lib/core/public/plugins.js');
      var _public_reporter__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__('./lib/core/public/reporter.js');
      var _public_reset__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__('./lib/core/public/reset.js');
      var _public_run_rules__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__('./lib/core/public/run-rules.js');
      var _public_run_virtual_rule__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__('./lib/core/public/run-virtual-rule.js');
      var _public_run__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__('./lib/core/public/run.js');
      var _reporters_na__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__('./lib/core/reporters/na.js');
      var _reporters_no_passes__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__('./lib/core/reporters/no-passes.js');
      var _reporters_raw_env__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__('./lib/core/reporters/raw-env.js');
      var _reporters_raw__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__('./lib/core/reporters/raw.js');
      var _reporters_v1__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__('./lib/core/reporters/v1.js');
      var _reporters_v2__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__('./lib/core/reporters/v2.js');
      var _commons__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__('./lib/commons/index.js');
      var _utils__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__('./lib/core/utils/index.js');
      axe.constants = _constants__WEBPACK_IMPORTED_MODULE_0__['default'];
      axe.log = _log__WEBPACK_IMPORTED_MODULE_1__['default'];
      axe.AbstractVirtualNode = _base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_2__['default'];
      axe.SerialVirtualNode = _base_virtual_node_serial_virtual_node__WEBPACK_IMPORTED_MODULE_3__['default'];
      axe.VirtualNode = _base_virtual_node_virtual_node__WEBPACK_IMPORTED_MODULE_4__['default'];
      axe._cache = _base_cache__WEBPACK_IMPORTED_MODULE_5__['default'];
      axe._thisWillBeDeletedDoNotUse = axe._thisWillBeDeletedDoNotUse || {};
      axe._thisWillBeDeletedDoNotUse.base = {
        Audit: _base_audit__WEBPACK_IMPORTED_MODULE_6__['default'],
        CheckResult: _base_check_result__WEBPACK_IMPORTED_MODULE_7__['default'],
        Check: _base_check__WEBPACK_IMPORTED_MODULE_8__['default'],
        Context: _base_context__WEBPACK_IMPORTED_MODULE_9__['default'],
        RuleResult: _base_rule_result__WEBPACK_IMPORTED_MODULE_11__['default'],
        Rule: _base_rule__WEBPACK_IMPORTED_MODULE_12__['default'],
        metadataFunctionMap: _base_metadata_function_map__WEBPACK_IMPORTED_MODULE_10__['default']
      };
      axe.imports = _imports__WEBPACK_IMPORTED_MODULE_13__;
      axe.cleanup = _public_cleanup__WEBPACK_IMPORTED_MODULE_14__['default'];
      axe.configure = _public_configure__WEBPACK_IMPORTED_MODULE_15__['default'];
      axe.getRules = _public_get_rules__WEBPACK_IMPORTED_MODULE_16__['default'];
      axe._load = _public_load__WEBPACK_IMPORTED_MODULE_17__['default'];
      axe.plugins = {};
      axe.registerPlugin = _public_plugins__WEBPACK_IMPORTED_MODULE_18__['default'];
      axe.hasReporter = _public_reporter__WEBPACK_IMPORTED_MODULE_19__['hasReporter'];
      axe.getReporter = _public_reporter__WEBPACK_IMPORTED_MODULE_19__['getReporter'];
      axe.addReporter = _public_reporter__WEBPACK_IMPORTED_MODULE_19__['addReporter'];
      axe.reset = _public_reset__WEBPACK_IMPORTED_MODULE_20__['default'];
      axe._runRules = _public_run_rules__WEBPACK_IMPORTED_MODULE_21__['default'];
      axe.runVirtualRule = _public_run_virtual_rule__WEBPACK_IMPORTED_MODULE_22__['default'];
      axe.run = _public_run__WEBPACK_IMPORTED_MODULE_23__['default'];
      axe.commons = _commons__WEBPACK_IMPORTED_MODULE_30__;
      axe.utils = _utils__WEBPACK_IMPORTED_MODULE_31__;
      axe.addReporter('na', _reporters_na__WEBPACK_IMPORTED_MODULE_24__['default']);
      axe.addReporter('no-passes', _reporters_no_passes__WEBPACK_IMPORTED_MODULE_25__['default']);
      axe.addReporter('rawEnv', _reporters_raw_env__WEBPACK_IMPORTED_MODULE_26__['default']);
      axe.addReporter('raw', _reporters_raw__WEBPACK_IMPORTED_MODULE_27__['default']);
      axe.addReporter('v1', _reporters_v1__WEBPACK_IMPORTED_MODULE_28__['default']);
      axe.addReporter('v2', _reporters_v2__WEBPACK_IMPORTED_MODULE_29__['default'], true);
    },
    './lib/core/imports/index.js': function libCoreImportsIndexJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./node_modules/axios/index.js');
      var axios__WEBPACK_IMPORTED_MODULE_0___default = __webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);
      __webpack_require__.d(__webpack_exports__, 'axios', function() {
        return axios__WEBPACK_IMPORTED_MODULE_0___default.a;
      });
      var css_selector_parser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./node_modules/css-selector-parser/lib/index.js');
      var css_selector_parser__WEBPACK_IMPORTED_MODULE_1___default = __webpack_require__.n(css_selector_parser__WEBPACK_IMPORTED_MODULE_1__);
      __webpack_require__.d(__webpack_exports__, 'CssSelectorParser', function() {
        return css_selector_parser__WEBPACK_IMPORTED_MODULE_1__['CssSelectorParser'];
      });
      var _deque_dot__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./node_modules/@deque/dot/doT.js');
      var _deque_dot__WEBPACK_IMPORTED_MODULE_2___default = __webpack_require__.n(_deque_dot__WEBPACK_IMPORTED_MODULE_2__);
      __webpack_require__.d(__webpack_exports__, 'doT', function() {
        return _deque_dot__WEBPACK_IMPORTED_MODULE_2___default.a;
      });
      var emoji_regex__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./node_modules/emoji-regex/index.js');
      var emoji_regex__WEBPACK_IMPORTED_MODULE_3___default = __webpack_require__.n(emoji_regex__WEBPACK_IMPORTED_MODULE_3__);
      __webpack_require__.d(__webpack_exports__, 'emojiRegexText', function() {
        return emoji_regex__WEBPACK_IMPORTED_MODULE_3___default.a;
      });
      var memoizee__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./node_modules/memoizee/index.js');
      var memoizee__WEBPACK_IMPORTED_MODULE_4___default = __webpack_require__.n(memoizee__WEBPACK_IMPORTED_MODULE_4__);
      __webpack_require__.d(__webpack_exports__, 'memoize', function() {
        return memoizee__WEBPACK_IMPORTED_MODULE_4___default.a;
      });
      var core_js_pure_features_promise__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./node_modules/core-js-pure/features/promise/index.js');
      var core_js_pure_features_promise__WEBPACK_IMPORTED_MODULE_5___default = __webpack_require__.n(core_js_pure_features_promise__WEBPACK_IMPORTED_MODULE_5__);
      var core_js_pure_features_typed_array_uint32_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./node_modules/core-js-pure/features/typed-array/uint32-array.js');
      var core_js_pure_features_typed_array_uint32_array__WEBPACK_IMPORTED_MODULE_6___default = __webpack_require__.n(core_js_pure_features_typed_array_uint32_array__WEBPACK_IMPORTED_MODULE_6__);
      var core_js_pure_es_weak_map__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./node_modules/core-js-pure/es/weak-map/index.js');
      var core_js_pure_es_weak_map__WEBPACK_IMPORTED_MODULE_7___default = __webpack_require__.n(core_js_pure_es_weak_map__WEBPACK_IMPORTED_MODULE_7__);
      if (!('WeakMap' in window)) {
        window.WeakMap = core_js_pure_es_weak_map__WEBPACK_IMPORTED_MODULE_7___default.a;
      }
      if (!('Promise' in window)) {
        window.Promise = core_js_pure_features_promise__WEBPACK_IMPORTED_MODULE_5___default.a;
      }
      if (!('Uint32Array' in window)) {
        window.Uint32Array = core_js_pure_features_typed_array_uint32_array__WEBPACK_IMPORTED_MODULE_6___default.a;
      }
      if (window.Uint32Array) {
        if (!('some' in window.Uint32Array.prototype)) {
          Object.defineProperty(window.Uint32Array.prototype, 'some', {
            value: Array.prototype.some
          });
        }
        if (!('reduce' in window.Uint32Array.prototype)) {
          Object.defineProperty(window.Uint32Array.prototype, 'reduce', {
            value: Array.prototype.reduce
          });
        }
      }
    },
    './lib/core/log.js': function libCoreLogJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function log() {
        'use strict';
        if ((typeof console === 'undefined' ? 'undefined' : _typeof(console)) === 'object' && console.log) {
          Function.prototype.apply.call(console.log, console, arguments);
        }
      }
      __webpack_exports__['default'] = log;
    },
    './lib/core/public/cleanup.js': function libCorePublicCleanupJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function cleanup(resolve, reject) {
        'use strict';
        resolve = resolve || function() {};
        reject = reject || axe.log;
        if (!axe._audit) {
          throw new Error('No audit configured');
        }
        var q = axe.utils.queue();
        var cleanupErrors = [];
        Object.keys(axe.plugins).forEach(function(key) {
          q.defer(function(res) {
            var rej = function rej(err) {
              cleanupErrors.push(err);
              res();
            };
            try {
              axe.plugins[key].cleanup(res, rej);
            } catch (err) {
              rej(err);
            }
          });
        });
        var flattenedTree = axe.utils.getFlattenedTree(document.body);
        axe.utils.querySelectorAll(flattenedTree, 'iframe, frame').forEach(function(node) {
          q.defer(function(res, rej) {
            return axe.utils.sendCommandToFrame(node.actualNode, {
              command: 'cleanup-plugin'
            }, res, rej);
          });
        });
        q.then(function(results) {
          if (cleanupErrors.length === 0) {
            resolve(results);
          } else {
            reject(cleanupErrors);
          }
        })['catch'](reject);
      }
      __webpack_exports__['default'] = cleanup;
    },
    './lib/core/public/configure.js': function libCorePublicConfigureJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _reporter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/public/reporter.js');
      var _standards__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/standards/index.js');
      function configure(spec) {
        'use strict';
        var audit;
        audit = axe._audit;
        if (!audit) {
          throw new Error('No audit configured');
        }
        if (spec.axeVersion || spec.ver) {
          var specVersion = spec.axeVersion || spec.ver;
          if (!/^\d+\.\d+\.\d+(-canary)?/.test(specVersion)) {
            throw new Error('Invalid configured version '.concat(specVersion));
          }
          var _specVersion$split = specVersion.split('-'), _specVersion$split2 = _slicedToArray(_specVersion$split, 2), version = _specVersion$split2[0], canary = _specVersion$split2[1];
          var _version$split$map = version.split('.').map(Number), _version$split$map2 = _slicedToArray(_version$split$map, 3), major = _version$split$map2[0], minor = _version$split$map2[1], patch = _version$split$map2[2];
          var _axe$version$split = axe.version.split('-'), _axe$version$split2 = _slicedToArray(_axe$version$split, 2), axeVersion = _axe$version$split2[0], axeCanary = _axe$version$split2[1];
          var _axeVersion$split$map = axeVersion.split('.').map(Number), _axeVersion$split$map2 = _slicedToArray(_axeVersion$split$map, 3), axeMajor = _axeVersion$split$map2[0], axeMinor = _axeVersion$split$map2[1], axePatch = _axeVersion$split$map2[2];
          if (major !== axeMajor || axeMinor < minor || axeMinor === minor && axePatch < patch || major === axeMajor && minor === axeMinor && patch === axePatch && canary && canary !== axeCanary) {
            throw new Error('Configured version '.concat(specVersion, ' is not compatible with current axe version ').concat(axe.version));
          }
        }
        if (spec.reporter && (typeof spec.reporter === 'function' || Object(_reporter__WEBPACK_IMPORTED_MODULE_0__['hasReporter'])(spec.reporter))) {
          audit.reporter = spec.reporter;
        }
        if (spec.checks) {
          if (!Array.isArray(spec.checks)) {
            throw new TypeError('Checks property must be an array');
          }
          spec.checks.forEach(function(check) {
            if (!check.id) {
              throw new TypeError('Configured check '.concat(JSON.stringify(check), ' is invalid. Checks must be an object with at least an id property'));
            }
            audit.addCheck(check);
          });
        }
        var modifiedRules = [];
        if (spec.rules) {
          if (!Array.isArray(spec.rules)) {
            throw new TypeError('Rules property must be an array');
          }
          spec.rules.forEach(function(rule) {
            if (!rule.id) {
              throw new TypeError('Configured rule '.concat(JSON.stringify(rule), ' is invalid. Rules must be an object with at least an id property'));
            }
            modifiedRules.push(rule.id);
            audit.addRule(rule);
          });
        }
        if (spec.disableOtherRules) {
          audit.rules.forEach(function(rule) {
            if (modifiedRules.includes(rule.id) === false) {
              rule.enabled = false;
            }
          });
        }
        if (typeof spec.branding !== 'undefined') {
          audit.setBranding(spec.branding);
        } else {
          audit._constructHelpUrls();
        }
        if (spec.tagExclude) {
          audit.tagExclude = spec.tagExclude;
        }
        if (spec.locale) {
          audit.applyLocale(spec.locale);
        }
        if (spec.standards) {
          Object(_standards__WEBPACK_IMPORTED_MODULE_1__['configureStandards'])(spec.standards);
        }
      }
      __webpack_exports__['default'] = configure;
    },
    './lib/core/public/get-rules.js': function libCorePublicGetRulesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getRules(tags) {
        'use strict';
        tags = tags || [];
        var matchingRules = !tags.length ? axe._audit.rules : axe._audit.rules.filter(function(item) {
          return !!tags.filter(function(tag) {
            return item.tags.indexOf(tag) !== -1;
          }).length;
        });
        var ruleData = axe._audit.data.rules || {};
        return matchingRules.map(function(matchingRule) {
          var rd = ruleData[matchingRule.id] || {};
          return {
            ruleId: matchingRule.id,
            description: rd.description,
            help: rd.help,
            helpUrl: rd.helpUrl,
            tags: matchingRule.tags
          };
        });
      }
      __webpack_exports__['default'] = getRules;
    },
    './lib/core/public/load.js': function libCorePublicLoadJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _base_audit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/audit.js');
      var _cleanup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/public/cleanup.js');
      var _run_rules__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/public/run-rules.js');
      function runCommand(data, keepalive, callback) {
        'use strict';
        var resolve = callback;
        var reject = function reject(err) {
          if (err instanceof Error === false) {
            err = new Error(err);
          }
          callback(err);
        };
        var context = data && data.context || {};
        if (context.hasOwnProperty('include') && !context.include.length) {
          context.include = [ document ];
        }
        var options = data && data.options || {};
        switch (data.command) {
         case 'rules':
          return Object(_run_rules__WEBPACK_IMPORTED_MODULE_2__['default'])(context, options, function(results, cleanup) {
            resolve(results);
            cleanup();
          }, reject);

         case 'cleanup-plugin':
          return Object(_cleanup__WEBPACK_IMPORTED_MODULE_1__['default'])(resolve, reject);

         default:
          if (axe._audit && axe._audit.commands && axe._audit.commands[data.command]) {
            return axe._audit.commands[data.command](data, callback);
          }
        }
      }
      function load(audit) {
        'use strict';
        axe.utils.respondable.subscribe('axe.ping', function(data, keepalive, respond) {
          respond({
            axe: true
          });
        });
        axe.utils.respondable.subscribe('axe.start', runCommand);
        axe._audit = new _base_audit__WEBPACK_IMPORTED_MODULE_0__['default'](audit);
      }
      __webpack_exports__['default'] = load;
    },
    './lib/core/public/plugins.js': function libCorePublicPluginsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function Plugin(spec) {
        'use strict';
        this._run = spec.run;
        this._collect = spec.collect;
        this._registry = {};
        spec.commands.forEach(function(command) {
          axe._audit.registerCommand(command);
        });
      }
      Plugin.prototype.run = function() {
        'use strict';
        return this._run.apply(this, arguments);
      };
      Plugin.prototype.collect = function() {
        'use strict';
        return this._collect.apply(this, arguments);
      };
      Plugin.prototype.cleanup = function(done) {
        'use strict';
        var q = axe.utils.queue();
        var that = this;
        Object.keys(this._registry).forEach(function(key) {
          q.defer(function(done) {
            that._registry[key].cleanup(done);
          });
        });
        q.then(function() {
          done();
        });
      };
      Plugin.prototype.add = function(impl) {
        'use strict';
        this._registry[impl.id] = impl;
      };
      function registerPlugin(plugin) {
        'use strict';
        axe.plugins[plugin.id] = new Plugin(plugin);
      }
      __webpack_exports__['default'] = registerPlugin;
    },
    './lib/core/public/reporter.js': function libCorePublicReporterJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'hasReporter', function() {
        return hasReporter;
      });
      __webpack_require__.d(__webpack_exports__, 'getReporter', function() {
        return getReporter;
      });
      __webpack_require__.d(__webpack_exports__, 'addReporter', function() {
        return addReporter;
      });
      var reporters = {};
      var defaultReporter;
      function hasReporter(reporterName) {
        return reporters.hasOwnProperty(reporterName);
      }
      function getReporter(reporter) {
        'use strict';
        if (typeof reporter === 'string' && reporters[reporter]) {
          return reporters[reporter];
        }
        if (typeof reporter === 'function') {
          return reporter;
        }
        return defaultReporter;
      }
      function addReporter(name, cb, isDefault) {
        'use strict';
        reporters[name] = cb;
        if (isDefault) {
          defaultReporter = cb;
        }
      }
    },
    './lib/core/public/reset.js': function libCorePublicResetJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _standards__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/index.js');
      function reset() {
        'use strict';
        var audit = axe._audit;
        if (!audit) {
          throw new Error('No audit configured');
        }
        audit.resetRulesAndChecks();
        Object(_standards__WEBPACK_IMPORTED_MODULE_0__['resetStandards'])();
      }
      __webpack_exports__['default'] = reset;
    },
    './lib/core/public/run-rules.js': function libCorePublicRunRulesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _base_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/context.js');
      var _base_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/cache.js');
      var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      var _log__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/log.js');
      function cleanup() {
        if (_base_cache__WEBPACK_IMPORTED_MODULE_1__['default'].get('globalDocumentSet')) {
          document = null;
        }
        if (_base_cache__WEBPACK_IMPORTED_MODULE_1__['default'].get('globalWindowSet')) {
          window = null;
        }
        axe._memoizedFns.forEach(function(fn) {
          return fn.clear();
        });
        _base_cache__WEBPACK_IMPORTED_MODULE_1__['default'].clear();
        axe._tree = undefined;
        axe._selectorData = undefined;
      }
      function runRules(context, options, resolve, reject) {
        'use strict';
        try {
          context = new _base_context__WEBPACK_IMPORTED_MODULE_0__['default'](context);
          axe._tree = context.flatTree;
          axe._selectorData = Object(_utils__WEBPACK_IMPORTED_MODULE_2__['getSelectorData'])(context.flatTree);
        } catch (e) {
          cleanup();
          return reject(e);
        }
        var q = Object(_utils__WEBPACK_IMPORTED_MODULE_2__['queue'])();
        var audit = axe._audit;
        if (options.performanceTimer) {
          _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].auditStart();
        }
        if (context.frames.length && options.iframes !== false) {
          q.defer(function(res, rej) {
            Object(_utils__WEBPACK_IMPORTED_MODULE_2__['collectResultsFromFrames'])(context, options, 'rules', null, res, rej);
          });
        }
        q.defer(function(res, rej) {
          audit.run(context, options, res, rej);
        });
        q.then(function(data) {
          try {
            if (options.performanceTimer) {
              _utils__WEBPACK_IMPORTED_MODULE_2__['performanceTimer'].auditEnd();
            }
            var results = Object(_utils__WEBPACK_IMPORTED_MODULE_2__['mergeResults'])(data.map(function(results) {
              return {
                results: results
              };
            }));
            if (context.initiator) {
              results = audit.after(results, options);
              results.forEach(_utils__WEBPACK_IMPORTED_MODULE_2__['publishMetaData']);
              results = results.map(_utils__WEBPACK_IMPORTED_MODULE_2__['finalizeRuleResult']);
            }
            try {
              resolve(results, cleanup);
            } catch (e) {
              cleanup();
              Object(_log__WEBPACK_IMPORTED_MODULE_3__['default'])(e);
            }
          } catch (e) {
            cleanup();
            reject(e);
          }
        })['catch'](function(e) {
          cleanup();
          reject(e);
        });
      }
      __webpack_exports__['default'] = runRules;
    },
    './lib/core/public/run-virtual-rule.js': function libCorePublicRunVirtualRuleJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _base_virtual_node_serial_virtual_node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/virtual-node/serial-virtual-node.js');
      var _base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/virtual-node/abstract-virtual-node.js');
      var _reporters_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/reporters/helpers/index.js');
      var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/index.js');
      function runVirtualRule(ruleId, vNode) {
        var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        options.reporter = options.reporter || axe._audit.reporter || 'v1';
        axe._selectorData = {};
        if (!(vNode instanceof _base_virtual_node_abstract_virtual_node__WEBPACK_IMPORTED_MODULE_1__['default'])) {
          vNode = new _base_virtual_node_serial_virtual_node__WEBPACK_IMPORTED_MODULE_0__['default'](vNode);
        }
        var rule = axe._audit.rules.find(function(rule) {
          return rule.id === ruleId;
        });
        if (!rule) {
          throw new Error('unknown rule `' + ruleId + '`');
        }
        rule = Object.create(rule, {
          excludeHidden: {
            value: false
          }
        });
        var context = {
          include: [ vNode ]
        };
        var rawResults = rule.runSync(context, options);
        Object(_utils__WEBPACK_IMPORTED_MODULE_3__['publishMetaData'])(rawResults);
        Object(_utils__WEBPACK_IMPORTED_MODULE_3__['finalizeRuleResult'])(rawResults);
        var results = Object(_utils__WEBPACK_IMPORTED_MODULE_3__['aggregateResult'])([ rawResults ]);
        results.violations.forEach(function(result) {
          return result.nodes.forEach(function(nodeResult) {
            nodeResult.failureSummary = _reporters_helpers__WEBPACK_IMPORTED_MODULE_2__['failureSummary'](nodeResult);
          });
        });
        return _extends({}, _reporters_helpers__WEBPACK_IMPORTED_MODULE_2__['getEnvironmentData'](), results, {
          toolOptions: options
        });
      }
      __webpack_exports__['default'] = runVirtualRule;
    },
    './lib/core/public/run.js': function libCorePublicRunJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _reporter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/public/reporter.js');
      var _base_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/cache.js');
      function isContext(potential) {
        'use strict';
        switch (true) {
         case typeof potential === 'string':
         case Array.isArray(potential):
         case window.Node && potential instanceof window.Node:
         case window.NodeList && potential instanceof window.NodeList:
          return true;

         case _typeof(potential) !== 'object':
          return false;

         case potential.include !== undefined:
         case potential.exclude !== undefined:
         case typeof potential.length === 'number':
          return true;

         default:
          return false;
        }
      }
      var noop = function noop() {};
      function normalizeRunParams(context, options, callback) {
        'use strict';
        var typeErr = new TypeError('axe.run arguments are invalid');
        if (!isContext(context)) {
          if (callback !== undefined) {
            throw typeErr;
          }
          callback = options;
          options = context;
          context = document;
        }
        if (_typeof(options) !== 'object') {
          if (callback !== undefined) {
            throw typeErr;
          }
          callback = options;
          options = {};
        }
        if (typeof callback !== 'function' && callback !== undefined) {
          throw typeErr;
        }
        return {
          context: context,
          options: options,
          callback: callback || noop
        };
      }
      function run(context, options, callback) {
        'use strict';
        if (!axe._audit) {
          throw new Error('No audit configured');
        }
        var hasWindow = window && 'Node' in window && 'NodeList' in window;
        var hasDoc = !!document;
        if (!hasWindow || !hasDoc) {
          if (!context || !context.ownerDocument) {
            throw new Error('Required "window" or "document" globals not defined and cannot be deduced from the context. ' + 'Either set the globals before running or pass in a valid Element.');
          }
          if (!hasDoc) {
            _base_cache__WEBPACK_IMPORTED_MODULE_1__['default'].set('globalDocumentSet', true);
            document = context.ownerDocument;
          }
          if (!hasWindow) {
            _base_cache__WEBPACK_IMPORTED_MODULE_1__['default'].set('globalWindowSet', true);
            window = document.defaultView;
          }
        }
        var args = normalizeRunParams(context, options, callback);
        context = args.context;
        options = args.options;
        callback = args.callback;
        options.reporter = options.reporter || axe._audit.reporter || 'v1';
        if (options.performanceTimer) {
          axe.utils.performanceTimer.start();
        }
        var p;
        var reject = noop;
        var resolve = noop;
        if (typeof Promise === 'function' && callback === noop) {
          p = new Promise(function(_resolve, _reject) {
            reject = _reject;
            resolve = _resolve;
          });
        }
        if (axe._running) {
          var err = 'Axe is already running. Use `await axe.run()` to wait ' + 'for the previous run to finish before starting a new run.';
          callback(err);
          reject(err);
          return p;
        }
        axe._running = true;
        axe._runRules(context, options, function(rawResults, cleanup) {
          var respond = function respond(results) {
            axe._running = false;
            cleanup();
            try {
              callback(null, results);
            } catch (e) {
              axe.log(e);
            }
            resolve(results);
          };
          if (options.performanceTimer) {
            axe.utils.performanceTimer.end();
          }
          try {
            var reporter = Object(_reporter__WEBPACK_IMPORTED_MODULE_0__['getReporter'])(options.reporter);
            var results = reporter(rawResults, options, respond);
            if (results !== undefined) {
              respond(results);
            }
          } catch (err) {
            axe._running = false;
            cleanup();
            callback(err);
            reject(err);
          }
        }, function(err) {
          axe._running = false;
          callback(err);
          reject(err);
        });
        return p;
      }
      __webpack_exports__['default'] = run;
    },
    './lib/core/reporters/helpers/failure-summary.js': function libCoreReportersHelpersFailureSummaryJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function failureSummary(nodeData) {
        var failingChecks = {};
        failingChecks.none = nodeData.none.concat(nodeData.all);
        failingChecks.any = nodeData.any;
        return Object.keys(failingChecks).map(function(key) {
          if (!failingChecks[key].length) {
            return;
          }
          var sum = axe._audit.data.failureSummaries[key];
          if (sum && typeof sum.failureMessage === 'function') {
            return sum.failureMessage(failingChecks[key].map(function(check) {
              return check.message || '';
            }));
          }
        }).filter(function(i) {
          return i !== undefined;
        }).join('\n\n');
      }
      __webpack_exports__['default'] = failureSummary;
    },
    './lib/core/reporters/helpers/get-environment-data.js': function libCoreReportersHelpersGetEnvironmentDataJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getEnvironmentData() {
        var win = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : window;
        var _win$screen = win.screen, screen = _win$screen === void 0 ? {} : _win$screen, _win$navigator = win.navigator, navigator = _win$navigator === void 0 ? {} : _win$navigator, _win$location = win.location, location = _win$location === void 0 ? {} : _win$location, innerHeight = win.innerHeight, innerWidth = win.innerWidth;
        var orientation = screen.msOrientation || screen.orientation || screen.mozOrientation || {};
        return {
          testEngine: {
            name: 'axe-core',
            version: axe.version
          },
          testRunner: {
            name: axe._audit.brand
          },
          testEnvironment: {
            userAgent: navigator.userAgent,
            windowWidth: innerWidth,
            windowHeight: innerHeight,
            orientationAngle: orientation.angle,
            orientationType: orientation.type
          },
          timestamp: new Date().toISOString(),
          url: location.href
        };
      }
      __webpack_exports__['default'] = getEnvironmentData;
    },
    './lib/core/reporters/helpers/incomplete-fallback-msg.js': function libCoreReportersHelpersIncompleteFallbackMsgJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function incompleteFallbackMessage() {
        return typeof axe._audit.data.incompleteFallbackMessage === 'function' ? axe._audit.data.incompleteFallbackMessage() : axe._audit.data.incompleteFallbackMessage;
      }
      __webpack_exports__['default'] = incompleteFallbackMessage;
    },
    './lib/core/reporters/helpers/index.js': function libCoreReportersHelpersIndexJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _failure_summary__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/reporters/helpers/failure-summary.js');
      __webpack_require__.d(__webpack_exports__, 'failureSummary', function() {
        return _failure_summary__WEBPACK_IMPORTED_MODULE_0__['default'];
      });
      var _get_environment_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/reporters/helpers/get-environment-data.js');
      __webpack_require__.d(__webpack_exports__, 'getEnvironmentData', function() {
        return _get_environment_data__WEBPACK_IMPORTED_MODULE_1__['default'];
      });
      var _incomplete_fallback_msg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/reporters/helpers/incomplete-fallback-msg.js');
      __webpack_require__.d(__webpack_exports__, 'incompleteFallbackMessage', function() {
        return _incomplete_fallback_msg__WEBPACK_IMPORTED_MODULE_2__['default'];
      });
      var _process_aggregate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/reporters/helpers/process-aggregate.js');
      __webpack_require__.d(__webpack_exports__, 'processAggregate', function() {
        return _process_aggregate__WEBPACK_IMPORTED_MODULE_3__['default'];
      });
      axe._thisWillBeDeletedDoNotUse = axe._thisWillBeDeletedDoNotUse || {};
      axe._thisWillBeDeletedDoNotUse.helpers = {
        failureSummary: _failure_summary__WEBPACK_IMPORTED_MODULE_0__['default'],
        getEnvironmentData: _get_environment_data__WEBPACK_IMPORTED_MODULE_1__['default'],
        incompleteFallbackMessage: _incomplete_fallback_msg__WEBPACK_IMPORTED_MODULE_2__['default'],
        processAggregate: _process_aggregate__WEBPACK_IMPORTED_MODULE_3__['default']
      };
    },
    './lib/core/reporters/helpers/process-aggregate.js': function libCoreReportersHelpersProcessAggregateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/constants.js');
      function normalizeRelatedNodes(node, options) {
        [ 'any', 'all', 'none' ].forEach(function(type) {
          if (!Array.isArray(node[type])) {
            return;
          }
          node[type].filter(function(checkRes) {
            return Array.isArray(checkRes.relatedNodes);
          }).forEach(function(checkRes) {
            checkRes.relatedNodes = checkRes.relatedNodes.map(function(relatedNode) {
              var res = {
                html: relatedNode.source
              };
              if (options.elementRef && !relatedNode.fromFrame) {
                res.element = relatedNode.element;
              }
              if (options.selectors !== false || relatedNode.fromFrame) {
                res.target = relatedNode.selector;
              }
              if (options.ancestry) {
                res.ancestry = relatedNode.ancestry;
              }
              if (options.xpath) {
                res.xpath = relatedNode.xpath;
              }
              return res;
            });
          });
        });
      }
      var resultKeys = _constants__WEBPACK_IMPORTED_MODULE_0__['default'].resultGroups;
      function processAggregate(results, options) {
        var resultObject = axe.utils.aggregateResult(results);
        resultKeys.forEach(function(key) {
          if (options.resultTypes && !options.resultTypes.includes(key)) {
            (resultObject[key] || []).forEach(function(ruleResult) {
              if (Array.isArray(ruleResult.nodes) && ruleResult.nodes.length > 0) {
                ruleResult.nodes = [ ruleResult.nodes[0] ];
              }
            });
          }
          resultObject[key] = (resultObject[key] || []).map(function(ruleResult) {
            ruleResult = Object.assign({}, ruleResult);
            if (Array.isArray(ruleResult.nodes) && ruleResult.nodes.length > 0) {
              ruleResult.nodes = ruleResult.nodes.map(function(subResult) {
                if (_typeof(subResult.node) === 'object') {
                  subResult.html = subResult.node.source;
                  if (options.elementRef && !subResult.node.fromFrame) {
                    subResult.element = subResult.node.element;
                  }
                  if (options.selectors !== false || subResult.node.fromFrame) {
                    subResult.target = subResult.node.selector;
                  }
                  if (options.ancestry) {
                    subResult.ancestry = subResult.node.ancestry;
                  }
                  if (options.xpath) {
                    subResult.xpath = subResult.node.xpath;
                  }
                }
                delete subResult.result;
                delete subResult.node;
                normalizeRelatedNodes(subResult, options);
                return subResult;
              });
            }
            resultKeys.forEach(function(key) {
              return delete ruleResult[key];
            });
            delete ruleResult.pageLevel;
            delete ruleResult.result;
            return ruleResult;
          });
        });
        return resultObject;
      }
      __webpack_exports__['default'] = processAggregate;
    },
    './lib/core/reporters/na.js': function libCoreReportersNaJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/reporters/helpers/index.js');
      var naReporter = function naReporter(results, options, callback) {
        console.warn('"na" reporter will be deprecated in axe v4.0. Use the "v2" reporter instead.');
        if (typeof options === 'function') {
          callback = options;
          options = {};
        }
        var out = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__['processAggregate'])(results, options);
        callback(_extends({}, Object(_helpers__WEBPACK_IMPORTED_MODULE_0__['getEnvironmentData'])(), {
          toolOptions: options,
          violations: out.violations,
          passes: out.passes,
          incomplete: out.incomplete,
          inapplicable: out.inapplicable
        }));
      };
      __webpack_exports__['default'] = naReporter;
    },
    './lib/core/reporters/no-passes.js': function libCoreReportersNoPassesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/reporters/helpers/index.js');
      var noPassesReporter = function noPassesReporter(results, options, callback) {
        if (typeof options === 'function') {
          callback = options;
          options = {};
        }
        options.resultTypes = [ 'violations' ];
        var out = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__['processAggregate'])(results, options);
        callback(_extends({}, Object(_helpers__WEBPACK_IMPORTED_MODULE_0__['getEnvironmentData'])(), {
          toolOptions: options,
          violations: out.violations
        }));
      };
      __webpack_exports__['default'] = noPassesReporter;
    },
    './lib/core/reporters/raw-env.js': function libCoreReportersRawEnvJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/reporters/helpers/index.js');
      var _raw__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/reporters/raw.js');
      var rawEnvReporter = function rawEnvReporter(results, options, callback) {
        if (typeof options === 'function') {
          callback = options;
          options = {};
        }
        function rawCallback(raw) {
          var env = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__['getEnvironmentData'])();
          callback({
            raw: raw,
            env: env
          });
        }
        Object(_raw__WEBPACK_IMPORTED_MODULE_1__['default'])(results, options, rawCallback);
      };
      __webpack_exports__['default'] = rawEnvReporter;
    },
    './lib/core/reporters/raw.js': function libCoreReportersRawJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var rawReporter = function rawReporter(results, options, callback) {
        if (typeof options === 'function') {
          callback = options;
          options = {};
        }
        if (!results || !Array.isArray(results)) {
          return callback(results);
        }
        var transformedResults = results.map(function(result) {
          var transformedResult = _extends({}, result);
          var types = [ 'passes', 'violations', 'incomplete', 'inapplicable' ];
          for (var _i6 = 0, _types = types; _i6 < _types.length; _i6++) {
            var type = _types[_i6];
            if (transformedResult[type] && Array.isArray(transformedResult[type])) {
              transformedResult[type] = transformedResult[type].map(function(typeResult) {
                return _extends({}, typeResult, {
                  node: typeResult.node.toJSON()
                });
              });
            }
          }
          return transformedResult;
        });
        callback(transformedResults);
      };
      __webpack_exports__['default'] = rawReporter;
    },
    './lib/core/reporters/v1.js': function libCoreReportersV1Js(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/reporters/helpers/index.js');
      var v1Reporter = function v1Reporter(results, options, callback) {
        if (typeof options === 'function') {
          callback = options;
          options = {};
        }
        var out = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__['processAggregate'])(results, options);
        var addFailureSummaries = function addFailureSummaries(result) {
          result.nodes.forEach(function(nodeResult) {
            nodeResult.failureSummary = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__['failureSummary'])(nodeResult);
          });
        };
        out.incomplete.forEach(addFailureSummaries);
        out.violations.forEach(addFailureSummaries);
        callback(_extends({}, Object(_helpers__WEBPACK_IMPORTED_MODULE_0__['getEnvironmentData'])(), {
          toolOptions: options,
          violations: out.violations,
          passes: out.passes,
          incomplete: out.incomplete,
          inapplicable: out.inapplicable
        }));
      };
      __webpack_exports__['default'] = v1Reporter;
    },
    './lib/core/reporters/v2.js': function libCoreReportersV2Js(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/reporters/helpers/index.js');
      var v2Reporter = function v2Reporter(results, options, callback) {
        if (typeof options === 'function') {
          callback = options;
          options = {};
        }
        var out = Object(_helpers__WEBPACK_IMPORTED_MODULE_0__['processAggregate'])(results, options);
        callback(_extends({}, Object(_helpers__WEBPACK_IMPORTED_MODULE_0__['getEnvironmentData'])(), {
          toolOptions: options,
          violations: out.violations,
          passes: out.passes,
          incomplete: out.incomplete,
          inapplicable: out.inapplicable
        }));
      };
      __webpack_exports__['default'] = v2Reporter;
    },
    './lib/core/utils/aggregate-checks.js': function libCoreUtilsAggregateChecksJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/constants.js');
      var _aggregate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/aggregate.js');
      var _constants__WEBPACK_I = _constants__WEBPACK_IMPORTED_MODULE_0__['default'], CANTTELL_PRIO = _constants__WEBPACK_I.CANTTELL_PRIO, FAIL_PRIO = _constants__WEBPACK_I.FAIL_PRIO;
      var checkMap = [];
      checkMap[_constants__WEBPACK_IMPORTED_MODULE_0__['default'].PASS_PRIO] = true;
      checkMap[_constants__WEBPACK_IMPORTED_MODULE_0__['default'].CANTTELL_PRIO] = null;
      checkMap[_constants__WEBPACK_IMPORTED_MODULE_0__['default'].FAIL_PRIO] = false;
      var checkTypes = [ 'any', 'all', 'none' ];
      function anyAllNone(obj, functor) {
        return checkTypes.reduce(function(out, type) {
          out[type] = (obj[type] || []).map(function(val) {
            return functor(val, type);
          });
          return out;
        }, {});
      }
      function aggregateChecks(nodeResOriginal) {
        var nodeResult = Object.assign({}, nodeResOriginal);
        anyAllNone(nodeResult, function(check, type) {
          var i = typeof check.result === 'undefined' ? -1 : checkMap.indexOf(check.result);
          check.priority = i !== -1 ? i : _constants__WEBPACK_IMPORTED_MODULE_0__['default'].CANTTELL_PRIO;
          if (type === 'none') {
            if (check.priority === _constants__WEBPACK_IMPORTED_MODULE_0__['default'].PASS_PRIO) {
              check.priority = _constants__WEBPACK_IMPORTED_MODULE_0__['default'].FAIL_PRIO;
            } else if (check.priority === _constants__WEBPACK_IMPORTED_MODULE_0__['default'].FAIL_PRIO) {
              check.priority = _constants__WEBPACK_IMPORTED_MODULE_0__['default'].PASS_PRIO;
            }
          }
        });
        var priorities = {
          all: nodeResult.all.reduce(function(a, b) {
            return Math.max(a, b.priority);
          }, 0),
          none: nodeResult.none.reduce(function(a, b) {
            return Math.max(a, b.priority);
          }, 0),
          any: nodeResult.any.reduce(function(a, b) {
            return Math.min(a, b.priority);
          }, 4) % 4
        };
        nodeResult.priority = Math.max(priorities.all, priorities.none, priorities.any);
        var impacts = [];
        checkTypes.forEach(function(type) {
          nodeResult[type] = nodeResult[type].filter(function(check) {
            return check.priority === nodeResult.priority && check.priority === priorities[type];
          });
          nodeResult[type].forEach(function(check) {
            return impacts.push(check.impact);
          });
        });
        if ([ CANTTELL_PRIO, FAIL_PRIO ].includes(nodeResult.priority)) {
          nodeResult.impact = Object(_aggregate__WEBPACK_IMPORTED_MODULE_1__['default'])(_constants__WEBPACK_IMPORTED_MODULE_0__['default'].impact, impacts);
        } else {
          nodeResult.impact = null;
        }
        anyAllNone(nodeResult, function(c) {
          delete c.result;
          delete c.priority;
        });
        nodeResult.result = _constants__WEBPACK_IMPORTED_MODULE_0__['default'].results[nodeResult.priority];
        delete nodeResult.priority;
        return nodeResult;
      }
      __webpack_exports__['default'] = aggregateChecks;
    },
    './lib/core/utils/aggregate-node-results.js': function libCoreUtilsAggregateNodeResultsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _aggregate_checks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/aggregate-checks.js');
      var _aggregate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/aggregate.js');
      var _finalize_result__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/finalize-result.js');
      var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/constants.js');
      function aggregateNodeResults(nodeResults) {
        var ruleResult = {};
        nodeResults = nodeResults.map(function(nodeResult) {
          if (nodeResult.any && nodeResult.all && nodeResult.none) {
            return Object(_aggregate_checks__WEBPACK_IMPORTED_MODULE_0__['default'])(nodeResult);
          } else if (Array.isArray(nodeResult.node)) {
            return Object(_finalize_result__WEBPACK_IMPORTED_MODULE_2__['default'])(nodeResult);
          } else {
            throw new TypeError('Invalid Result type');
          }
        });
        if (nodeResults && nodeResults.length) {
          var resultList = nodeResults.map(function(node) {
            return node.result;
          });
          ruleResult.result = Object(_aggregate__WEBPACK_IMPORTED_MODULE_1__['default'])(_constants__WEBPACK_IMPORTED_MODULE_3__['default'].results, resultList, ruleResult.result);
        } else {
          ruleResult.result = 'inapplicable';
        }
        _constants__WEBPACK_IMPORTED_MODULE_3__['default'].resultGroups.forEach(function(group) {
          return ruleResult[group] = [];
        });
        nodeResults.forEach(function(nodeResult) {
          var groupName = _constants__WEBPACK_IMPORTED_MODULE_3__['default'].resultGroupMap[nodeResult.result];
          ruleResult[groupName].push(nodeResult);
        });
        var impactGroup = _constants__WEBPACK_IMPORTED_MODULE_3__['default'].FAIL_GROUP;
        if (ruleResult[impactGroup].length === 0) {
          impactGroup = _constants__WEBPACK_IMPORTED_MODULE_3__['default'].CANTTELL_GROUP;
        }
        if (ruleResult[impactGroup].length > 0) {
          var impactList = ruleResult[impactGroup].map(function(failure) {
            return failure.impact;
          });
          ruleResult.impact = Object(_aggregate__WEBPACK_IMPORTED_MODULE_1__['default'])(_constants__WEBPACK_IMPORTED_MODULE_3__['default'].impact, impactList) || null;
        } else {
          ruleResult.impact = null;
        }
        return ruleResult;
      }
      __webpack_exports__['default'] = aggregateNodeResults;
    },
    './lib/core/utils/aggregate-result.js': function libCoreUtilsAggregateResultJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/constants.js');
      function copyToGroup(resultObject, subResult, group) {
        var resultCopy = Object.assign({}, subResult);
        resultCopy.nodes = (resultCopy[group] || []).concat();
        _constants__WEBPACK_IMPORTED_MODULE_0__['default'].resultGroups.forEach(function(group) {
          delete resultCopy[group];
        });
        resultObject[group].push(resultCopy);
      }
      function aggregateResult(results) {
        var resultObject = {};
        _constants__WEBPACK_IMPORTED_MODULE_0__['default'].resultGroups.forEach(function(groupName) {
          return resultObject[groupName] = [];
        });
        results.forEach(function(subResult) {
          if (subResult.error) {
            copyToGroup(resultObject, subResult, _constants__WEBPACK_IMPORTED_MODULE_0__['default'].CANTTELL_GROUP);
          } else if (subResult.result === _constants__WEBPACK_IMPORTED_MODULE_0__['default'].NA) {
            copyToGroup(resultObject, subResult, _constants__WEBPACK_IMPORTED_MODULE_0__['default'].NA_GROUP);
          } else {
            _constants__WEBPACK_IMPORTED_MODULE_0__['default'].resultGroups.forEach(function(group) {
              if (Array.isArray(subResult[group]) && subResult[group].length > 0) {
                copyToGroup(resultObject, subResult, group);
              }
            });
          }
        });
        return resultObject;
      }
      __webpack_exports__['default'] = aggregateResult;
    },
    './lib/core/utils/aggregate.js': function libCoreUtilsAggregateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function aggregate(map, values, initial) {
        values = values.slice();
        if (initial) {
          values.push(initial);
        }
        var sorting = values.map(function(val) {
          return map.indexOf(val);
        }).sort();
        return map[sorting.pop()];
      }
      __webpack_exports__['default'] = aggregate;
    },
    './lib/core/utils/are-styles-set.js': function libCoreUtilsAreStylesSetJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function areStylesSet(el, styles, stopAt) {
        var styl = window.getComputedStyle(el, null);
        if (!styl) {
          return false;
        }
        for (var i = 0; i < styles.length; ++i) {
          var att = styles[i];
          if (styl.getPropertyValue(att.property) === att.value) {
            return true;
          }
        }
        if (!el.parentNode || el.nodeName.toUpperCase() === stopAt.toUpperCase()) {
          return false;
        }
        return areStylesSet(el.parentNode, styles, stopAt);
      }
      __webpack_exports__['default'] = areStylesSet;
    },
    './lib/core/utils/assert.js': function libCoreUtilsAssertJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function assert(bool, message) {
        if (!bool) {
          throw new Error(message);
        }
      }
      __webpack_exports__['default'] = assert;
    },
    './lib/core/utils/check-helper.js': function libCoreUtilsCheckHelperJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/to-array.js');
      var _dq_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/dq-element.js');
      function checkHelper(checkResult, options, resolve, reject) {
        return {
          isAsync: false,
          async: function async() {
            this.isAsync = true;
            return function(result) {
              if (result instanceof Error === false) {
                checkResult.result = result;
                resolve(checkResult);
              } else {
                reject(result);
              }
            };
          },
          data: function data(_data) {
            checkResult.data = _data;
          },
          relatedNodes: function relatedNodes(nodes) {
            nodes = nodes instanceof window.Node ? [ nodes ] : Object(_to_array__WEBPACK_IMPORTED_MODULE_0__['default'])(nodes);
            checkResult.relatedNodes = nodes.map(function(element) {
              return new _dq_element__WEBPACK_IMPORTED_MODULE_1__['default'](element, options);
            });
          }
        };
      }
      __webpack_exports__['default'] = checkHelper;
    },
    './lib/core/utils/clone.js': function libCoreUtilsCloneJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function clone(obj) {
        var index, length, out = obj;
        if (obj !== null && _typeof(obj) === 'object') {
          if (Array.isArray(obj)) {
            out = [];
            for (index = 0, length = obj.length; index < length; index++) {
              out[index] = clone(obj[index]);
            }
          } else {
            out = {};
            for (index in obj) {
              out[index] = clone(obj[index]);
            }
          }
        }
        return out;
      }
      __webpack_exports__['default'] = clone;
    },
    './lib/core/utils/closest.js': function libCoreUtilsClosestJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _matches__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/matches.js');
      function closest(vNode, selector) {
        while (vNode) {
          if (Object(_matches__WEBPACK_IMPORTED_MODULE_0__['default'])(vNode, selector)) {
            return vNode;
          }
          if (typeof vNode.parent === 'undefined') {
            throw new TypeError('Cannot resolve parent for non-DOM nodes');
          }
          vNode = vNode.parent;
        }
        return null;
      }
      __webpack_exports__['default'] = closest;
    },
    './lib/core/utils/collect-results-from-frames.js': function libCoreUtilsCollectResultsFromFramesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _queue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/queue.js');
      var _send_command_to_frame__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/send-command-to-frame.js');
      var _merge_results__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/merge-results.js');
      var _get_selector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/get-selector.js');
      function collectResultsFromFrames(context, options, command, parameter, resolve, reject) {
        var q = Object(_queue__WEBPACK_IMPORTED_MODULE_0__['default'])();
        var frames = context.frames;
        frames.forEach(function(frame) {
          var params = {
            options: options,
            command: command,
            parameter: parameter,
            context: {
              initiator: false,
              page: context.page,
              include: frame.include || [],
              exclude: frame.exclude || []
            }
          };
          q.defer(function(res, rej) {
            var node = frame.node;
            Object(_send_command_to_frame__WEBPACK_IMPORTED_MODULE_1__['default'])(node, params, function(data) {
              if (data) {
                return res({
                  results: data,
                  frameElement: node,
                  frame: Object(_get_selector__WEBPACK_IMPORTED_MODULE_3__['default'])(node)
                });
              }
              res(null);
            }, rej);
          });
        });
        q.then(function(data) {
          resolve(Object(_merge_results__WEBPACK_IMPORTED_MODULE_2__['default'])(data, options));
        })['catch'](reject);
      }
      __webpack_exports__['default'] = collectResultsFromFrames;
    },
    './lib/core/utils/contains.js': function libCoreUtilsContainsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function contains(vNode, otherVNode) {
        function containsShadowChild(vNode, otherVNode) {
          if (vNode.shadowId === otherVNode.shadowId) {
            return true;
          }
          return !!vNode.children.find(function(child) {
            return containsShadowChild(child, otherVNode);
          });
        }
        if (vNode.shadowId || otherVNode.shadowId) {
          return containsShadowChild(vNode, otherVNode);
        }
        if (vNode.actualNode) {
          if (typeof vNode.actualNode.contains === 'function') {
            return vNode.actualNode.contains(otherVNode.actualNode);
          }
          return !!(vNode.actualNode.compareDocumentPosition(otherVNode.actualNode) & 16);
        } else {
          do {
            if (otherVNode === vNode) {
              return true;
            }
          } while (otherVNode = otherVNode && otherVNode.parent);
        }
        return false;
      }
      __webpack_exports__['default'] = contains;
    },
    './lib/core/utils/css-parser.js': function libCoreUtilsCssParserJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var css_selector_parser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./node_modules/css-selector-parser/lib/index.js');
      var css_selector_parser__WEBPACK_IMPORTED_MODULE_0___default = __webpack_require__.n(css_selector_parser__WEBPACK_IMPORTED_MODULE_0__);
      var parser = new css_selector_parser__WEBPACK_IMPORTED_MODULE_0__['CssSelectorParser']();
      parser.registerSelectorPseudos('not');
      parser.registerNestingOperators('>');
      parser.registerAttrEqualityMods('^', '$', '*');
      __webpack_exports__['default'] = parser;
    },
    './lib/core/utils/deep-merge.js': function libCoreUtilsDeepMergeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function deepMerge() {
        var target = {};
        for (var _len = arguments.length, sources = new Array(_len), _key = 0; _key < _len; _key++) {
          sources[_key] = arguments[_key];
        }
        sources.forEach(function(source) {
          if (!source || _typeof(source) !== 'object' || Array.isArray(source)) {
            return;
          }
          for (var _i7 = 0, _Object$keys2 = Object.keys(source); _i7 < _Object$keys2.length; _i7++) {
            var key = _Object$keys2[_i7];
            if (!target.hasOwnProperty(key) || _typeof(source[key]) !== 'object' || Array.isArray(target[key])) {
              target[key] = source[key];
            } else {
              target[key] = deepMerge(target[key], source[key]);
            }
          }
        });
        return target;
      }
      __webpack_exports__['default'] = deepMerge;
    },
    './lib/core/utils/dq-element.js': function libCoreUtilsDqElementJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_selector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/get-selector.js');
      var _get_ancestry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/get-ancestry.js');
      var _get_xpath__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/get-xpath.js');
      function truncate(str, maxLength) {
        maxLength = maxLength || 300;
        if (str.length > maxLength) {
          var index = str.indexOf('>');
          str = str.substring(0, index + 1);
        }
        return str;
      }
      function getSource(element) {
        var source = element.outerHTML;
        if (!source && typeof XMLSerializer === 'function') {
          source = new XMLSerializer().serializeToString(element);
        }
        return truncate(source || '');
      }
      function DqElement(element, options, spec) {
        this._fromFrame = !!spec;
        this.spec = spec || {};
        if (options && options.absolutePaths) {
          this._options = {
            toRoot: true
          };
        }
        this.source = this.spec.source !== undefined ? this.spec.source : getSource(element);
        this._element = element;
      }
      DqElement.prototype = {
        get selector() {
          return this.spec.selector || [ Object(_get_selector__WEBPACK_IMPORTED_MODULE_0__['default'])(this.element, this._options) ];
        },
        get ancestry() {
          return this.spec.ancestry || [ Object(_get_ancestry__WEBPACK_IMPORTED_MODULE_1__['default'])(this.element) ];
        },
        get xpath() {
          return this.spec.xpath || [ Object(_get_xpath__WEBPACK_IMPORTED_MODULE_2__['default'])(this.element) ];
        },
        get element() {
          return this._element;
        },
        get fromFrame() {
          return this._fromFrame;
        },
        toJSON: function toJSON() {
          'use strict';
          return {
            selector: this.selector,
            source: this.source,
            xpath: this.xpath,
            ancestry: this.ancestry
          };
        }
      };
      DqElement.fromFrame = function(node, options, frame) {
        var spec = _extends({}, node, {
          selector: [].concat(_toConsumableArray(frame.selector), _toConsumableArray(node.selector)),
          ancestry: [].concat(_toConsumableArray(frame.ancestry), _toConsumableArray(node.ancestry)),
          xpath: [].concat(_toConsumableArray(frame.xpath), _toConsumableArray(node.xpath))
        });
        return new DqElement(frame.element, options, spec);
      };
      __webpack_exports__['default'] = DqElement;
    },
    './lib/core/utils/element-matches.js': function libCoreUtilsElementMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var matchesSelector = function() {
        var method;
        function getMethod(node) {
          var index, candidate, candidates = [ 'matches', 'matchesSelector', 'mozMatchesSelector', 'webkitMatchesSelector', 'msMatchesSelector' ], length = candidates.length;
          for (index = 0; index < length; index++) {
            candidate = candidates[index];
            if (node[candidate]) {
              return candidate;
            }
          }
        }
        return function(node, selector) {
          if (!method || !node[method]) {
            method = getMethod(node);
          }
          if (node[method]) {
            return node[method](selector);
          }
          return false;
        };
      }();
      __webpack_exports__['default'] = matchesSelector;
    },
    './lib/core/utils/escape-selector.js': function libCoreUtilsEscapeSelectorJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function escapeSelector(value) {
        var string = String(value);
        var length = string.length;
        var index = -1;
        var codeUnit;
        var result = '';
        var firstCodeUnit = string.charCodeAt(0);
        while (++index < length) {
          codeUnit = string.charCodeAt(index);
          if (codeUnit == 0) {
            result += '\ufffd';
            continue;
          }
          if (codeUnit >= 1 && codeUnit <= 31 || codeUnit == 127 || index == 0 && codeUnit >= 48 && codeUnit <= 57 || index == 1 && codeUnit >= 48 && codeUnit <= 57 && firstCodeUnit == 45) {
            result += '\\' + codeUnit.toString(16) + ' ';
            continue;
          }
          if (index == 0 && length == 1 && codeUnit == 45) {
            result += '\\' + string.charAt(index);
            continue;
          }
          if (codeUnit >= 128 || codeUnit == 45 || codeUnit == 95 || codeUnit >= 48 && codeUnit <= 57 || codeUnit >= 65 && codeUnit <= 90 || codeUnit >= 97 && codeUnit <= 122) {
            result += string.charAt(index);
            continue;
          }
          result += '\\' + string.charAt(index);
        }
        return result;
      }
      __webpack_exports__['default'] = escapeSelector;
    },
    './lib/core/utils/extend-meta-data.js': function libCoreUtilsExtendMetaDataJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function extendMetaData(to, from) {
        Object.assign(to, from);
        Object.keys(from).filter(function(prop) {
          return typeof from[prop] === 'function';
        }).forEach(function(prop) {
          to[prop] = null;
          try {
            to[prop] = from[prop](to);
          } catch (e) {}
        });
      }
      __webpack_exports__['default'] = extendMetaData;
    },
    './lib/core/utils/finalize-result.js': function libCoreUtilsFinalizeResultJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _aggregate_node_results__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/aggregate-node-results.js');
      function finalizeRuleResult(ruleResult) {
        var rule = axe._audit.rules.find(function(rule) {
          return rule.id === ruleResult.id;
        });
        if (rule && rule.impact) {
          ruleResult.nodes.forEach(function(node) {
            [ 'any', 'all', 'none' ].forEach(function(checkType) {
              (node[checkType] || []).forEach(function(checkResult) {
                checkResult.impact = rule.impact;
              });
            });
          });
        }
        Object.assign(ruleResult, Object(_aggregate_node_results__WEBPACK_IMPORTED_MODULE_0__['default'])(ruleResult.nodes));
        delete ruleResult.nodes;
        return ruleResult;
      }
      __webpack_exports__['default'] = finalizeRuleResult;
    },
    './lib/core/utils/find-by.js': function libCoreUtilsFindByJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function findBy(array, key, value) {
        if (Array.isArray(array)) {
          return array.find(function(obj) {
            return _typeof(obj) === 'object' && obj[key] === value;
          });
        }
      }
      __webpack_exports__['default'] = findBy;
    },
    './lib/core/utils/get-all-checks.js': function libCoreUtilsGetAllChecksJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getAllChecks(object) {
        var result = [];
        return result.concat(object.any || []).concat(object.all || []).concat(object.none || []);
      }
      __webpack_exports__['default'] = getAllChecks;
    },
    './lib/core/utils/get-ancestry.js': function libCoreUtilsGetAncestryJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'default', function() {
        return getAncestry;
      });
      var _get_shadow_selector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/get-shadow-selector.js');
      function generateAncestry(node) {
        var nodeName = node.nodeName.toLowerCase();
        var parent = node.parentElement;
        if (!parent) {
          return nodeName;
        }
        var nthChild = '';
        if (nodeName !== 'head' && nodeName !== 'body' && parent.children.length > 1) {
          var index = Array.prototype.indexOf.call(parent.children, node) + 1;
          nthChild = ':nth-child('.concat(index, ')');
        }
        return generateAncestry(parent) + ' > ' + nodeName + nthChild;
      }
      function getAncestry(elm, options) {
        return Object(_get_shadow_selector__WEBPACK_IMPORTED_MODULE_0__['default'])(generateAncestry, elm, options);
      }
    },
    './lib/core/utils/get-base-lang.js': function libCoreUtilsGetBaseLangJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getBaseLang(lang) {
        if (!lang) {
          return '';
        }
        return lang.trim().split('-')[0].toLowerCase();
      }
      __webpack_exports__['default'] = getBaseLang;
    },
    './lib/core/utils/get-check-message.js': function libCoreUtilsGetCheckMessageJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _process_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/process-message.js');
      function getCheckMessage(checkId, type, data) {
        var check = axe._audit.data.checks[checkId];
        if (!check) {
          throw new Error('Cannot get message for unknown check: '.concat(checkId, '.'));
        }
        if (!check.messages[type]) {
          throw new Error('Check "'.concat(checkId, '"" does not have a "').concat(type, '" message.'));
        }
        return Object(_process_message__WEBPACK_IMPORTED_MODULE_0__['default'])(check.messages[type], data);
      }
      __webpack_exports__['default'] = getCheckMessage;
    },
    './lib/core/utils/get-check-option.js': function libCoreUtilsGetCheckOptionJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getCheckOption(check, ruleID, options) {
        var ruleCheckOption = ((options.rules && options.rules[ruleID] || {}).checks || {})[check.id];
        var checkOption = (options.checks || {})[check.id];
        var enabled = check.enabled;
        var opts = check.options;
        if (checkOption) {
          if (checkOption.hasOwnProperty('enabled')) {
            enabled = checkOption.enabled;
          }
          if (checkOption.hasOwnProperty('options')) {
            opts = checkOption.options;
          }
        }
        if (ruleCheckOption) {
          if (ruleCheckOption.hasOwnProperty('enabled')) {
            enabled = ruleCheckOption.enabled;
          }
          if (ruleCheckOption.hasOwnProperty('options')) {
            opts = ruleCheckOption.options;
          }
        }
        return {
          enabled: enabled,
          options: opts,
          absolutePaths: options.absolutePaths
        };
      }
      __webpack_exports__['default'] = getCheckOption;
    },
    './lib/core/utils/get-flattened-tree.js': function libCoreUtilsGetFlattenedTreeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _is_shadow_root__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/is-shadow-root.js');
      var _base_virtual_node_virtual_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/virtual-node/virtual-node.js');
      var _base_cache__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/base/cache.js');
      function getSlotChildren(node) {
        var retVal = [];
        node = node.firstChild;
        while (node) {
          retVal.push(node);
          node = node.nextSibling;
        }
        return retVal;
      }
      function flattenTree(node, shadowId, parent) {
        var retVal, realArray, nodeName;
        function reduceShadowDOM(res, child, parent) {
          var replacements = flattenTree(child, shadowId, parent);
          if (replacements) {
            res = res.concat(replacements);
          }
          return res;
        }
        if (node.documentElement) {
          node = node.documentElement;
        }
        nodeName = node.nodeName.toLowerCase();
        if (Object(_is_shadow_root__WEBPACK_IMPORTED_MODULE_0__['default'])(node)) {
          retVal = new _base_virtual_node_virtual_node__WEBPACK_IMPORTED_MODULE_1__['default'](node, parent, shadowId);
          shadowId = 'a' + Math.random().toString().substring(2);
          realArray = Array.from(node.shadowRoot.childNodes);
          retVal.children = realArray.reduce(function(res, child) {
            return reduceShadowDOM(res, child, retVal);
          }, []);
          return [ retVal ];
        } else {
          if (nodeName === 'content' && typeof node.getDistributedNodes === 'function') {
            realArray = Array.from(node.getDistributedNodes());
            return realArray.reduce(function(res, child) {
              return reduceShadowDOM(res, child, parent);
            }, []);
          } else if (nodeName === 'slot' && typeof node.assignedNodes === 'function') {
            realArray = Array.from(node.assignedNodes());
            if (!realArray.length) {
              realArray = getSlotChildren(node);
            }
            var styl = window.getComputedStyle(node);
            if (false) {} else {
              return realArray.reduce(function(res, child) {
                return reduceShadowDOM(res, child, parent);
              }, []);
            }
          } else {
            if (node.nodeType === 1) {
              retVal = new _base_virtual_node_virtual_node__WEBPACK_IMPORTED_MODULE_1__['default'](node, parent, shadowId);
              realArray = Array.from(node.childNodes);
              retVal.children = realArray.reduce(function(res, child) {
                return reduceShadowDOM(res, child, retVal);
              }, []);
              return [ retVal ];
            } else if (node.nodeType === 3) {
              return [ new _base_virtual_node_virtual_node__WEBPACK_IMPORTED_MODULE_1__['default'](node, parent) ];
            }
            return undefined;
          }
        }
      }
      function getFlattenedTree() {
        var node = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document.documentElement;
        var shadowId = arguments.length > 1 ? arguments[1] : undefined;
        _base_cache__WEBPACK_IMPORTED_MODULE_2__['default'].set('nodeMap', new WeakMap());
        return flattenTree(node, shadowId, null);
      }
      __webpack_exports__['default'] = getFlattenedTree;
    },
    './lib/core/utils/get-friendly-uri-end.js': function libCoreUtilsGetFriendlyUriEndJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function isMostlyNumbers() {
        var str = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
        return str.length !== 0 && (str.match(/[0-9]/g) || '').length >= str.length / 2;
      }
      function splitString(str, splitIndex) {
        return [ str.substring(0, splitIndex), str.substring(splitIndex) ];
      }
      function trimRight(str) {
        return str.replace(/\s+$/, '');
      }
      function uriParser(url) {
        var original = url;
        var protocol = '', domain = '', port = '', path = '', query = '', hash = '';
        if (url.includes('#')) {
          var _splitString = splitString(url, url.indexOf('#'));
          var _splitString2 = _slicedToArray(_splitString, 2);
          url = _splitString2[0];
          hash = _splitString2[1];
        }
        if (url.includes('?')) {
          var _splitString3 = splitString(url, url.indexOf('?'));
          var _splitString4 = _slicedToArray(_splitString3, 2);
          url = _splitString4[0];
          query = _splitString4[1];
        }
        if (url.includes('://')) {
          var _url$split = url.split('://');
          var _url$split2 = _slicedToArray(_url$split, 2);
          protocol = _url$split2[0];
          url = _url$split2[1];
          var _splitString5 = splitString(url, url.indexOf('/'));
          var _splitString6 = _slicedToArray(_splitString5, 2);
          domain = _splitString6[0];
          url = _splitString6[1];
        } else if (url.substr(0, 2) === '//') {
          url = url.substr(2);
          var _splitString7 = splitString(url, url.indexOf('/'));
          var _splitString8 = _slicedToArray(_splitString7, 2);
          domain = _splitString8[0];
          url = _splitString8[1];
        }
        if (domain.substr(0, 4) === 'www.') {
          domain = domain.substr(4);
        }
        if (domain && domain.includes(':')) {
          var _splitString9 = splitString(domain, domain.indexOf(':'));
          var _splitString10 = _slicedToArray(_splitString9, 2);
          domain = _splitString10[0];
          port = _splitString10[1];
        }
        path = url;
        return {
          original: original,
          protocol: protocol,
          domain: domain,
          port: port,
          path: path,
          query: query,
          hash: hash
        };
      }
      function getFriendlyUriEnd() {
        var uri = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        if (uri.length <= 1 || uri.substr(0, 5) === 'data:' || uri.substr(0, 11) === 'javascript:' || uri.includes('?')) {
          return;
        }
        var currentDomain = options.currentDomain, _options$maxLength = options.maxLength, maxLength = _options$maxLength === void 0 ? 25 : _options$maxLength;
        var _uriParser = uriParser(uri), path = _uriParser.path, domain = _uriParser.domain, hash = _uriParser.hash;
        var pathEnd = path.substr(path.substr(0, path.length - 2).lastIndexOf('/') + 1);
        if (hash) {
          if (pathEnd && (pathEnd + hash).length <= maxLength) {
            return trimRight(pathEnd + hash);
          } else if (pathEnd.length < 2 && hash.length > 2 && hash.length <= maxLength) {
            return trimRight(hash);
          } else {
            return;
          }
        } else if (domain && domain.length < maxLength && path.length <= 1) {
          return trimRight(domain + path);
        }
        if (path === '/' + pathEnd && domain && currentDomain && domain !== currentDomain && (domain + path).length <= maxLength) {
          return trimRight(domain + path);
        }
        var lastDotIndex = pathEnd.lastIndexOf('.');
        if ((lastDotIndex === -1 || lastDotIndex > 1) && (lastDotIndex !== -1 || pathEnd.length > 2) && pathEnd.length <= maxLength && !pathEnd.match(/index(\.[a-zA-Z]{2-4})?/) && !isMostlyNumbers(pathEnd)) {
          return trimRight(pathEnd);
        }
      }
      __webpack_exports__['default'] = getFriendlyUriEnd;
    },
    './lib/core/utils/get-node-attributes.js': function libCoreUtilsGetNodeAttributesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getNodeAttributes(node) {
        if (node.attributes instanceof window.NamedNodeMap) {
          return node.attributes;
        }
        return node.cloneNode(false).attributes;
      }
      __webpack_exports__['default'] = getNodeAttributes;
    },
    './lib/core/utils/get-node-from-tree.js': function libCoreUtilsGetNodeFromTreeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _base_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/base/cache.js');
      function getNodeFromTree(vNode, node) {
        var el = node || vNode;
        return _base_cache__WEBPACK_IMPORTED_MODULE_0__['default'].get('nodeMap') ? _base_cache__WEBPACK_IMPORTED_MODULE_0__['default'].get('nodeMap').get(el) : null;
      }
      __webpack_exports__['default'] = getNodeFromTree;
    },
    './lib/core/utils/get-root-node.js': function libCoreUtilsGetRootNodeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getRootNode(node) {
        var doc = node.getRootNode && node.getRootNode() || document;
        if (doc === node) {
          doc = document;
        }
        return doc;
      }
      __webpack_exports__['default'] = getRootNode;
    },
    './lib/core/utils/get-scroll-state.js': function libCoreUtilsGetScrollStateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_scroll__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/get-scroll.js');
      function getElmScrollRecursive(root) {
        return Array.from(root.children || root.childNodes || []).reduce(function(scrolls, elm) {
          var scroll = Object(_get_scroll__WEBPACK_IMPORTED_MODULE_0__['default'])(elm);
          if (scroll) {
            scrolls.push(scroll);
          }
          return scrolls.concat(getElmScrollRecursive(elm));
        }, []);
      }
      function getScrollState() {
        var win = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : window;
        var root = win.document.documentElement;
        var windowScroll = [ win.pageXOffset !== undefined ? {
          elm: win,
          top: win.pageYOffset,
          left: win.pageXOffset
        } : {
          elm: root,
          top: root.scrollTop,
          left: root.scrollLeft
        } ];
        return windowScroll.concat(getElmScrollRecursive(document.body));
      }
      __webpack_exports__['default'] = getScrollState;
    },
    './lib/core/utils/get-scroll.js': function libCoreUtilsGetScrollJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getScroll(elm) {
        var buffer = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
        var overflowX = elm.scrollWidth > elm.clientWidth + buffer;
        var overflowY = elm.scrollHeight > elm.clientHeight + buffer;
        if (!(overflowX || overflowY)) {
          return;
        }
        var style = window.getComputedStyle(elm);
        var overflowXStyle = style.getPropertyValue('overflow-x');
        var overflowYStyle = style.getPropertyValue('overflow-y');
        var scrollableX = overflowXStyle !== 'visible' && overflowXStyle !== 'hidden';
        var scrollableY = overflowYStyle !== 'visible' && overflowYStyle !== 'hidden';
        if (overflowX && scrollableX || overflowY && scrollableY) {
          return {
            elm: elm,
            top: elm.scrollTop,
            left: elm.scrollLeft
          };
        }
      }
      __webpack_exports__['default'] = getScroll;
    },
    './lib/core/utils/get-selector.js': function libCoreUtilsGetSelectorJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'getSelectorData', function() {
        return getSelectorData;
      });
      __webpack_require__.d(__webpack_exports__, 'default', function() {
        return getSelector;
      });
      var _escape_selector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/escape-selector.js');
      var _get_friendly_uri_end__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/get-friendly-uri-end.js');
      var _get_node_attributes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/get-node-attributes.js');
      var _element_matches__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/element-matches.js');
      var _is_xhtml__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/core/utils/is-xhtml.js');
      var _get_shadow_selector__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/core/utils/get-shadow-selector.js');
      var xhtml;
      var ignoredAttributes = [ 'class', 'style', 'id', 'selected', 'checked', 'disabled', 'tabindex', 'aria-checked', 'aria-selected', 'aria-invalid', 'aria-activedescendant', 'aria-busy', 'aria-disabled', 'aria-expanded', 'aria-grabbed', 'aria-pressed', 'aria-valuenow' ];
      var MAXATTRIBUTELENGTH = 31;
      function getAttributeNameValue(node, at) {
        var name = at.name;
        var atnv;
        if (name.indexOf('href') !== -1 || name.indexOf('src') !== -1) {
          var friendly = Object(_get_friendly_uri_end__WEBPACK_IMPORTED_MODULE_1__['default'])(node.getAttribute(name));
          if (friendly) {
            var value = encodeURI(friendly);
            if (value) {
              atnv = Object(_escape_selector__WEBPACK_IMPORTED_MODULE_0__['default'])(at.name) + '$="' + Object(_escape_selector__WEBPACK_IMPORTED_MODULE_0__['default'])(value) + '"';
            } else {
              return;
            }
          } else {
            atnv = Object(_escape_selector__WEBPACK_IMPORTED_MODULE_0__['default'])(at.name) + '="' + Object(_escape_selector__WEBPACK_IMPORTED_MODULE_0__['default'])(node.getAttribute(name)) + '"';
          }
        } else {
          atnv = Object(_escape_selector__WEBPACK_IMPORTED_MODULE_0__['default'])(name) + '="' + Object(_escape_selector__WEBPACK_IMPORTED_MODULE_0__['default'])(at.value) + '"';
        }
        return atnv;
      }
      function countSort(a, b) {
        return a.count < b.count ? -1 : a.count === b.count ? 0 : 1;
      }
      function filterAttributes(at) {
        return !ignoredAttributes.includes(at.name) && at.name.indexOf(':') === -1 && (!at.value || at.value.length < MAXATTRIBUTELENGTH);
      }
      function getSelectorData(domTree) {
        var data = {
          classes: {},
          tags: {},
          attributes: {}
        };
        domTree = Array.isArray(domTree) ? domTree : [ domTree ];
        var currentLevel = domTree.slice();
        var stack = [];
        var _loop4 = function _loop4() {
          var current = currentLevel.pop();
          var node = current.actualNode;
          if (!!node.querySelectorAll) {
            var tag = node.nodeName;
            if (data.tags[tag]) {
              data.tags[tag]++;
            } else {
              data.tags[tag] = 1;
            }
            if (node.classList) {
              Array.from(node.classList).forEach(function(cl) {
                var ind = Object(_escape_selector__WEBPACK_IMPORTED_MODULE_0__['default'])(cl);
                if (data.classes[ind]) {
                  data.classes[ind]++;
                } else {
                  data.classes[ind] = 1;
                }
              });
            }
            if (node.hasAttributes()) {
              Array.from(Object(_get_node_attributes__WEBPACK_IMPORTED_MODULE_2__['default'])(node)).filter(filterAttributes).forEach(function(at) {
                var atnv = getAttributeNameValue(node, at);
                if (atnv) {
                  if (data.attributes[atnv]) {
                    data.attributes[atnv]++;
                  } else {
                    data.attributes[atnv] = 1;
                  }
                }
              });
            }
          }
          if (current.children.length) {
            stack.push(currentLevel);
            currentLevel = current.children.slice();
          }
          while (!currentLevel.length && stack.length) {
            currentLevel = stack.pop();
          }
        };
        while (currentLevel.length) {
          _loop4();
        }
        return data;
      }
      function uncommonClasses(node, selectorData) {
        var retVal = [];
        var classData = selectorData.classes;
        var tagData = selectorData.tags;
        if (node.classList) {
          Array.from(node.classList).forEach(function(cl) {
            var ind = Object(_escape_selector__WEBPACK_IMPORTED_MODULE_0__['default'])(cl);
            if (classData[ind] < tagData[node.nodeName]) {
              retVal.push({
                name: ind,
                count: classData[ind],
                species: 'class'
              });
            }
          });
        }
        return retVal.sort(countSort);
      }
      function getNthChildString(elm, selector) {
        var siblings = elm.parentNode && Array.from(elm.parentNode.children || '') || [];
        var hasMatchingSiblings = siblings.find(function(sibling) {
          return sibling !== elm && Object(_element_matches__WEBPACK_IMPORTED_MODULE_3__['default'])(sibling, selector);
        });
        if (hasMatchingSiblings) {
          var nthChild = 1 + siblings.indexOf(elm);
          return ':nth-child(' + nthChild + ')';
        } else {
          return '';
        }
      }
      function getElmId(elm) {
        if (!elm.getAttribute('id')) {
          return;
        }
        var doc = elm.getRootNode && elm.getRootNode() || document;
        var id = '#' + Object(_escape_selector__WEBPACK_IMPORTED_MODULE_0__['default'])(elm.getAttribute('id') || '');
        if (!id.match(/player_uid_/) && doc.querySelectorAll(id).length === 1) {
          return id;
        }
      }
      function getBaseSelector(elm) {
        if (typeof xhtml === 'undefined') {
          xhtml = Object(_is_xhtml__WEBPACK_IMPORTED_MODULE_4__['default'])(document);
        }
        return Object(_escape_selector__WEBPACK_IMPORTED_MODULE_0__['default'])(xhtml ? elm.localName : elm.nodeName.toLowerCase());
      }
      function uncommonAttributes(node, selectorData) {
        var retVal = [];
        var attData = selectorData.attributes;
        var tagData = selectorData.tags;
        if (node.hasAttributes()) {
          Array.from(Object(_get_node_attributes__WEBPACK_IMPORTED_MODULE_2__['default'])(node)).filter(filterAttributes).forEach(function(at) {
            var atnv = getAttributeNameValue(node, at);
            if (atnv && attData[atnv] < tagData[node.nodeName]) {
              retVal.push({
                name: atnv,
                count: attData[atnv],
                species: 'attribute'
              });
            }
          });
        }
        return retVal.sort(countSort);
      }
      function getThreeLeastCommonFeatures(elm, selectorData) {
        var selector = '';
        var features;
        var clss = uncommonClasses(elm, selectorData);
        var atts = uncommonAttributes(elm, selectorData);
        if (clss.length && clss[0].count === 1) {
          features = [ clss[0] ];
        } else if (atts.length && atts[0].count === 1) {
          features = [ atts[0] ];
          selector = getBaseSelector(elm);
        } else {
          features = clss.concat(atts);
          features.sort(countSort);
          features = features.slice(0, 3);
          if (!features.some(function(feat) {
            return feat.species === 'class';
          })) {
            selector = getBaseSelector(elm);
          } else {
            features.sort(function(a, b) {
              return a.species !== b.species && a.species === 'class' ? -1 : a.species === b.species ? 0 : 1;
            });
          }
        }
        return selector += features.reduce(function(val, feat) {
          switch (feat.species) {
           case 'class':
            return val + '.' + feat.name;

           case 'attribute':
            return val + '[' + feat.name + ']';
          }
          return val;
        }, '');
      }
      function generateSelector(elm, options, doc) {
        if (!axe._selectorData) {
          throw new Error('Expect axe._selectorData to be set up');
        }
        var _options$toRoot = options.toRoot, toRoot = _options$toRoot === void 0 ? false : _options$toRoot;
        var selector;
        var similar;
        do {
          var features = getElmId(elm);
          if (!features) {
            features = getThreeLeastCommonFeatures(elm, axe._selectorData);
            features += getNthChildString(elm, features);
          }
          if (selector) {
            selector = features + ' > ' + selector;
          } else {
            selector = features;
          }
          if (!similar) {
            similar = Array.from(doc.querySelectorAll(selector));
          } else {
            similar = similar.filter(function(item) {
              return Object(_element_matches__WEBPACK_IMPORTED_MODULE_3__['default'])(item, selector);
            });
          }
          elm = elm.parentElement;
        } while ((similar.length > 1 || toRoot) && elm && elm.nodeType !== 11);
        if (similar.length === 1) {
          return selector;
        } else if (selector.indexOf(' > ') !== -1) {
          return ':root' + selector.substring(selector.indexOf(' > '));
        }
        return ':root';
      }
      function getSelector(elm, options) {
        return Object(_get_shadow_selector__WEBPACK_IMPORTED_MODULE_5__['default'])(generateSelector, elm, options);
      }
    },
    './lib/core/utils/get-shadow-selector.js': function libCoreUtilsGetShadowSelectorJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getShadowSelector(generateSelector, elm) {
        var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        if (!elm) {
          return '';
        }
        var doc = elm.getRootNode && elm.getRootNode() || document;
        if (doc.nodeType !== 11) {
          return generateSelector(elm, options, doc);
        }
        var stack = [];
        while (doc.nodeType === 11) {
          if (!doc.host) {
            return '';
          }
          stack.unshift({
            elm: elm,
            doc: doc
          });
          elm = doc.host;
          doc = elm.getRootNode();
        }
        stack.unshift({
          elm: elm,
          doc: doc
        });
        return stack.map(function(_ref55) {
          var elm = _ref55.elm, doc = _ref55.doc;
          return generateSelector(elm, options, doc);
        });
      }
      __webpack_exports__['default'] = getShadowSelector;
    },
    './lib/core/utils/get-stylesheet-factory.js': function libCoreUtilsGetStylesheetFactoryJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function getStyleSheetFactory(dynamicDoc) {
        if (!dynamicDoc) {
          throw new Error('axe.utils.getStyleSheetFactory should be invoked with an argument');
        }
        return function(options) {
          var data = options.data, _options$isCrossOrigi = options.isCrossOrigin, isCrossOrigin = _options$isCrossOrigi === void 0 ? false : _options$isCrossOrigi, shadowId = options.shadowId, root = options.root, priority = options.priority, _options$isLink = options.isLink, isLink = _options$isLink === void 0 ? false : _options$isLink;
          var style = dynamicDoc.createElement('style');
          if (isLink) {
            var text = dynamicDoc.createTextNode('@import "'.concat(data.href, '"'));
            style.appendChild(text);
          } else {
            style.appendChild(dynamicDoc.createTextNode(data));
          }
          dynamicDoc.head.appendChild(style);
          return {
            sheet: style.sheet,
            isCrossOrigin: isCrossOrigin,
            shadowId: shadowId,
            root: root,
            priority: priority
          };
        };
      }
      __webpack_exports__['default'] = getStyleSheetFactory;
    },
    './lib/core/utils/get-xpath.js': function libCoreUtilsGetXpathJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _escape_selector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/escape-selector.js');
      function getXPathArray(node, path) {
        var sibling, count;
        if (!node) {
          return [];
        }
        if (!path && node.nodeType === 9) {
          path = [ {
            str: 'html'
          } ];
          return path;
        }
        path = path || [];
        if (node.parentNode && node.parentNode !== node) {
          path = getXPathArray(node.parentNode, path);
        }
        if (node.previousSibling) {
          count = 1;
          sibling = node.previousSibling;
          do {
            if (sibling.nodeType === 1 && sibling.nodeName === node.nodeName) {
              count++;
            }
            sibling = sibling.previousSibling;
          } while (sibling);
          if (count === 1) {
            count = null;
          }
        } else if (node.nextSibling) {
          sibling = node.nextSibling;
          do {
            if (sibling.nodeType === 1 && sibling.nodeName === node.nodeName) {
              count = 1;
              sibling = null;
            } else {
              count = null;
              sibling = sibling.previousSibling;
            }
          } while (sibling);
        }
        if (node.nodeType === 1) {
          var element = {};
          element.str = node.nodeName.toLowerCase();
          var id = node.getAttribute && Object(_escape_selector__WEBPACK_IMPORTED_MODULE_0__['default'])(node.getAttribute('id'));
          if (id && node.ownerDocument.querySelectorAll('#' + id).length === 1) {
            element.id = node.getAttribute('id');
          }
          if (count > 1) {
            element.count = count;
          }
          path.push(element);
        }
        return path;
      }
      function xpathToString(xpathArray) {
        return xpathArray.reduce(function(str, elm) {
          if (elm.id) {
            return '/'.concat(elm.str, '[@id=\'').concat(elm.id, '\']');
          } else {
            return str + '/'.concat(elm.str) + (elm.count > 0 ? '['.concat(elm.count, ']') : '');
          }
        }, '');
      }
      function getXpath(node) {
        var xpathArray = getXPathArray(node);
        return xpathToString(xpathArray);
      }
      __webpack_exports__['default'] = getXpath;
    },
    './lib/core/utils/index.js': function libCoreUtilsIndexJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _aggregate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/aggregate.js');
      __webpack_require__.d(__webpack_exports__, 'aggregate', function() {
        return _aggregate__WEBPACK_IMPORTED_MODULE_0__['default'];
      });
      var _aggregate_checks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/aggregate-checks.js');
      __webpack_require__.d(__webpack_exports__, 'aggregateChecks', function() {
        return _aggregate_checks__WEBPACK_IMPORTED_MODULE_1__['default'];
      });
      var _aggregate_node_results__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/aggregate-node-results.js');
      __webpack_require__.d(__webpack_exports__, 'aggregateNodeResults', function() {
        return _aggregate_node_results__WEBPACK_IMPORTED_MODULE_2__['default'];
      });
      var _aggregate_result__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/aggregate-result.js');
      __webpack_require__.d(__webpack_exports__, 'aggregateResult', function() {
        return _aggregate_result__WEBPACK_IMPORTED_MODULE_3__['default'];
      });
      var _are_styles_set__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/core/utils/are-styles-set.js');
      __webpack_require__.d(__webpack_exports__, 'areStylesSet', function() {
        return _are_styles_set__WEBPACK_IMPORTED_MODULE_4__['default'];
      });
      var _assert__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/core/utils/assert.js');
      __webpack_require__.d(__webpack_exports__, 'assert', function() {
        return _assert__WEBPACK_IMPORTED_MODULE_5__['default'];
      });
      var _check_helper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__('./lib/core/utils/check-helper.js');
      __webpack_require__.d(__webpack_exports__, 'checkHelper', function() {
        return _check_helper__WEBPACK_IMPORTED_MODULE_6__['default'];
      });
      var _clone__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__('./lib/core/utils/clone.js');
      __webpack_require__.d(__webpack_exports__, 'clone', function() {
        return _clone__WEBPACK_IMPORTED_MODULE_7__['default'];
      });
      var _closest__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__('./lib/core/utils/closest.js');
      __webpack_require__.d(__webpack_exports__, 'closest', function() {
        return _closest__WEBPACK_IMPORTED_MODULE_8__['default'];
      });
      var _collect_results_from_frames__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__('./lib/core/utils/collect-results-from-frames.js');
      __webpack_require__.d(__webpack_exports__, 'collectResultsFromFrames', function() {
        return _collect_results_from_frames__WEBPACK_IMPORTED_MODULE_9__['default'];
      });
      var _contains__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__('./lib/core/utils/contains.js');
      __webpack_require__.d(__webpack_exports__, 'contains', function() {
        return _contains__WEBPACK_IMPORTED_MODULE_10__['default'];
      });
      var _css_parser__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__('./lib/core/utils/css-parser.js');
      __webpack_require__.d(__webpack_exports__, 'cssParser', function() {
        return _css_parser__WEBPACK_IMPORTED_MODULE_11__['default'];
      });
      var _deep_merge__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__('./lib/core/utils/deep-merge.js');
      __webpack_require__.d(__webpack_exports__, 'deepMerge', function() {
        return _deep_merge__WEBPACK_IMPORTED_MODULE_12__['default'];
      });
      var _dq_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__('./lib/core/utils/dq-element.js');
      __webpack_require__.d(__webpack_exports__, 'DqElement', function() {
        return _dq_element__WEBPACK_IMPORTED_MODULE_13__['default'];
      });
      var _element_matches__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__('./lib/core/utils/element-matches.js');
      __webpack_require__.d(__webpack_exports__, 'matchesSelector', function() {
        return _element_matches__WEBPACK_IMPORTED_MODULE_14__['default'];
      });
      var _escape_selector__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__('./lib/core/utils/escape-selector.js');
      __webpack_require__.d(__webpack_exports__, 'escapeSelector', function() {
        return _escape_selector__WEBPACK_IMPORTED_MODULE_15__['default'];
      });
      var _extend_meta_data__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__('./lib/core/utils/extend-meta-data.js');
      __webpack_require__.d(__webpack_exports__, 'extendMetaData', function() {
        return _extend_meta_data__WEBPACK_IMPORTED_MODULE_16__['default'];
      });
      var _finalize_result__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__('./lib/core/utils/finalize-result.js');
      __webpack_require__.d(__webpack_exports__, 'finalizeRuleResult', function() {
        return _finalize_result__WEBPACK_IMPORTED_MODULE_17__['default'];
      });
      var _find_by__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__('./lib/core/utils/find-by.js');
      __webpack_require__.d(__webpack_exports__, 'findBy', function() {
        return _find_by__WEBPACK_IMPORTED_MODULE_18__['default'];
      });
      var _get_flattened_tree__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__('./lib/core/utils/get-flattened-tree.js');
      __webpack_require__.d(__webpack_exports__, 'getFlattenedTree', function() {
        return _get_flattened_tree__WEBPACK_IMPORTED_MODULE_19__['default'];
      });
      var _get_all_checks__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__('./lib/core/utils/get-all-checks.js');
      __webpack_require__.d(__webpack_exports__, 'getAllChecks', function() {
        return _get_all_checks__WEBPACK_IMPORTED_MODULE_20__['default'];
      });
      var _get_base_lang__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__('./lib/core/utils/get-base-lang.js');
      __webpack_require__.d(__webpack_exports__, 'getBaseLang', function() {
        return _get_base_lang__WEBPACK_IMPORTED_MODULE_21__['default'];
      });
      var _get_check_message__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__('./lib/core/utils/get-check-message.js');
      __webpack_require__.d(__webpack_exports__, 'getCheckMessage', function() {
        return _get_check_message__WEBPACK_IMPORTED_MODULE_22__['default'];
      });
      var _get_check_option__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__('./lib/core/utils/get-check-option.js');
      __webpack_require__.d(__webpack_exports__, 'getCheckOption', function() {
        return _get_check_option__WEBPACK_IMPORTED_MODULE_23__['default'];
      });
      var _get_friendly_uri_end__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__('./lib/core/utils/get-friendly-uri-end.js');
      __webpack_require__.d(__webpack_exports__, 'getFriendlyUriEnd', function() {
        return _get_friendly_uri_end__WEBPACK_IMPORTED_MODULE_24__['default'];
      });
      var _get_node_attributes__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__('./lib/core/utils/get-node-attributes.js');
      __webpack_require__.d(__webpack_exports__, 'getNodeAttributes', function() {
        return _get_node_attributes__WEBPACK_IMPORTED_MODULE_25__['default'];
      });
      var _get_node_from_tree__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__('./lib/core/utils/get-node-from-tree.js');
      __webpack_require__.d(__webpack_exports__, 'getNodeFromTree', function() {
        return _get_node_from_tree__WEBPACK_IMPORTED_MODULE_26__['default'];
      });
      var _get_root_node__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__('./lib/core/utils/get-root-node.js');
      __webpack_require__.d(__webpack_exports__, 'getRootNode', function() {
        return _get_root_node__WEBPACK_IMPORTED_MODULE_27__['default'];
      });
      var _get_scroll_state__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__('./lib/core/utils/get-scroll-state.js');
      __webpack_require__.d(__webpack_exports__, 'getScrollState', function() {
        return _get_scroll_state__WEBPACK_IMPORTED_MODULE_28__['default'];
      });
      var _get_scroll__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__('./lib/core/utils/get-scroll.js');
      __webpack_require__.d(__webpack_exports__, 'getScroll', function() {
        return _get_scroll__WEBPACK_IMPORTED_MODULE_29__['default'];
      });
      var _get_shadow_selector__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__('./lib/core/utils/get-shadow-selector.js');
      __webpack_require__.d(__webpack_exports__, 'getShadowSelector', function() {
        return _get_shadow_selector__WEBPACK_IMPORTED_MODULE_30__['default'];
      });
      var _get_selector__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__('./lib/core/utils/get-selector.js');
      __webpack_require__.d(__webpack_exports__, 'getSelector', function() {
        return _get_selector__WEBPACK_IMPORTED_MODULE_31__['default'];
      });
      __webpack_require__.d(__webpack_exports__, 'getSelectorData', function() {
        return _get_selector__WEBPACK_IMPORTED_MODULE_31__['getSelectorData'];
      });
      var _get_stylesheet_factory__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__('./lib/core/utils/get-stylesheet-factory.js');
      __webpack_require__.d(__webpack_exports__, 'getStyleSheetFactory', function() {
        return _get_stylesheet_factory__WEBPACK_IMPORTED_MODULE_32__['default'];
      });
      var _get_xpath__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__('./lib/core/utils/get-xpath.js');
      __webpack_require__.d(__webpack_exports__, 'getXpath', function() {
        return _get_xpath__WEBPACK_IMPORTED_MODULE_33__['default'];
      });
      var _get_ancestry__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__('./lib/core/utils/get-ancestry.js');
      __webpack_require__.d(__webpack_exports__, 'getAncestry', function() {
        return _get_ancestry__WEBPACK_IMPORTED_MODULE_34__['default'];
      });
      var _inject_style__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__('./lib/core/utils/inject-style.js');
      __webpack_require__.d(__webpack_exports__, 'injectStyle', function() {
        return _inject_style__WEBPACK_IMPORTED_MODULE_35__['default'];
      });
      var _is_hidden__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__('./lib/core/utils/is-hidden.js');
      __webpack_require__.d(__webpack_exports__, 'isHidden', function() {
        return _is_hidden__WEBPACK_IMPORTED_MODULE_36__['default'];
      });
      var _is_html_element__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__('./lib/core/utils/is-html-element.js');
      __webpack_require__.d(__webpack_exports__, 'isHtmlElement', function() {
        return _is_html_element__WEBPACK_IMPORTED_MODULE_37__['default'];
      });
      var _is_node_in_context__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__('./lib/core/utils/is-node-in-context.js');
      __webpack_require__.d(__webpack_exports__, 'isNodeInContext', function() {
        return _is_node_in_context__WEBPACK_IMPORTED_MODULE_38__['default'];
      });
      var _is_shadow_root__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__('./lib/core/utils/is-shadow-root.js');
      __webpack_require__.d(__webpack_exports__, 'isShadowRoot', function() {
        return _is_shadow_root__WEBPACK_IMPORTED_MODULE_39__['default'];
      });
      var _is_xhtml__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__('./lib/core/utils/is-xhtml.js');
      __webpack_require__.d(__webpack_exports__, 'isXHTML', function() {
        return _is_xhtml__WEBPACK_IMPORTED_MODULE_40__['default'];
      });
      var _matches__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__('./lib/core/utils/matches.js');
      __webpack_require__.d(__webpack_exports__, 'matches', function() {
        return _matches__WEBPACK_IMPORTED_MODULE_41__['default'];
      });
      __webpack_require__.d(__webpack_exports__, 'matchesExpression', function() {
        return _matches__WEBPACK_IMPORTED_MODULE_41__['matchesExpression'];
      });
      __webpack_require__.d(__webpack_exports__, 'convertSelector', function() {
        return _matches__WEBPACK_IMPORTED_MODULE_41__['convertSelector'];
      });
      var _memoize__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__('./lib/core/utils/memoize.js');
      __webpack_require__.d(__webpack_exports__, 'memoize', function() {
        return _memoize__WEBPACK_IMPORTED_MODULE_42__['default'];
      });
      var _merge_results__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__('./lib/core/utils/merge-results.js');
      __webpack_require__.d(__webpack_exports__, 'mergeResults', function() {
        return _merge_results__WEBPACK_IMPORTED_MODULE_43__['default'];
      });
      var _node_sorter__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__('./lib/core/utils/node-sorter.js');
      __webpack_require__.d(__webpack_exports__, 'nodeSorter', function() {
        return _node_sorter__WEBPACK_IMPORTED_MODULE_44__['default'];
      });
      var _parse_crossorigin_stylesheet__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__('./lib/core/utils/parse-crossorigin-stylesheet.js');
      __webpack_require__.d(__webpack_exports__, 'parseCrossOriginStylesheet', function() {
        return _parse_crossorigin_stylesheet__WEBPACK_IMPORTED_MODULE_45__['default'];
      });
      var _parse_sameorigin_stylesheet__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__('./lib/core/utils/parse-sameorigin-stylesheet.js');
      __webpack_require__.d(__webpack_exports__, 'parseSameOriginStylesheet', function() {
        return _parse_sameorigin_stylesheet__WEBPACK_IMPORTED_MODULE_46__['default'];
      });
      var _parse_stylesheet__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__('./lib/core/utils/parse-stylesheet.js');
      __webpack_require__.d(__webpack_exports__, 'parseStylesheet', function() {
        return _parse_stylesheet__WEBPACK_IMPORTED_MODULE_47__['default'];
      });
      var _performance_timer__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__('./lib/core/utils/performance-timer.js');
      __webpack_require__.d(__webpack_exports__, 'performanceTimer', function() {
        return _performance_timer__WEBPACK_IMPORTED_MODULE_48__['default'];
      });
      var _pollyfills__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__('./lib/core/utils/pollyfills.js');
      __webpack_require__.d(__webpack_exports__, 'pollyfillElementsFromPoint', function() {
        return _pollyfills__WEBPACK_IMPORTED_MODULE_49__['pollyfillElementsFromPoint'];
      });
      var _preload_cssom__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__('./lib/core/utils/preload-cssom.js');
      __webpack_require__.d(__webpack_exports__, 'preloadCssom', function() {
        return _preload_cssom__WEBPACK_IMPORTED_MODULE_50__['default'];
      });
      var _preload_media__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__('./lib/core/utils/preload-media.js');
      __webpack_require__.d(__webpack_exports__, 'preloadMedia', function() {
        return _preload_media__WEBPACK_IMPORTED_MODULE_51__['default'];
      });
      var _preload__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__('./lib/core/utils/preload.js');
      __webpack_require__.d(__webpack_exports__, 'preload', function() {
        return _preload__WEBPACK_IMPORTED_MODULE_52__['default'];
      });
      __webpack_require__.d(__webpack_exports__, 'shouldPreload', function() {
        return _preload__WEBPACK_IMPORTED_MODULE_52__['shouldPreload'];
      });
      __webpack_require__.d(__webpack_exports__, 'getPreloadConfig', function() {
        return _preload__WEBPACK_IMPORTED_MODULE_52__['getPreloadConfig'];
      });
      var _process_message__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__('./lib/core/utils/process-message.js');
      __webpack_require__.d(__webpack_exports__, 'processMessage', function() {
        return _process_message__WEBPACK_IMPORTED_MODULE_53__['default'];
      });
      var _publish_metadata__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__('./lib/core/utils/publish-metadata.js');
      __webpack_require__.d(__webpack_exports__, 'publishMetaData', function() {
        return _publish_metadata__WEBPACK_IMPORTED_MODULE_54__['default'];
      });
      var _query_selector_all_filter__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__('./lib/core/utils/query-selector-all-filter.js');
      __webpack_require__.d(__webpack_exports__, 'querySelectorAllFilter', function() {
        return _query_selector_all_filter__WEBPACK_IMPORTED_MODULE_55__['default'];
      });
      var _query_selector_all__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__('./lib/core/utils/query-selector-all.js');
      __webpack_require__.d(__webpack_exports__, 'querySelectorAll', function() {
        return _query_selector_all__WEBPACK_IMPORTED_MODULE_56__['default'];
      });
      var _queue__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__('./lib/core/utils/queue.js');
      __webpack_require__.d(__webpack_exports__, 'queue', function() {
        return _queue__WEBPACK_IMPORTED_MODULE_57__['default'];
      });
      var _respondable__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__('./lib/core/utils/respondable.js');
      __webpack_require__.d(__webpack_exports__, 'respondable', function() {
        return _respondable__WEBPACK_IMPORTED_MODULE_58__['default'];
      });
      var _rule_should_run__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__('./lib/core/utils/rule-should-run.js');
      __webpack_require__.d(__webpack_exports__, 'ruleShouldRun', function() {
        return _rule_should_run__WEBPACK_IMPORTED_MODULE_59__['default'];
      });
      var _select__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__('./lib/core/utils/select.js');
      __webpack_require__.d(__webpack_exports__, 'select', function() {
        return _select__WEBPACK_IMPORTED_MODULE_60__['default'];
      });
      var _send_command_to_frame__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__('./lib/core/utils/send-command-to-frame.js');
      __webpack_require__.d(__webpack_exports__, 'sendCommandToFrame', function() {
        return _send_command_to_frame__WEBPACK_IMPORTED_MODULE_61__['default'];
      });
      var _set_scroll_state__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__('./lib/core/utils/set-scroll-state.js');
      __webpack_require__.d(__webpack_exports__, 'setScrollState', function() {
        return _set_scroll_state__WEBPACK_IMPORTED_MODULE_62__['default'];
      });
      var _to_array__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__('./lib/core/utils/to-array.js');
      __webpack_require__.d(__webpack_exports__, 'toArray', function() {
        return _to_array__WEBPACK_IMPORTED_MODULE_63__['default'];
      });
      var _token_list__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__('./lib/core/utils/token-list.js');
      __webpack_require__.d(__webpack_exports__, 'tokenList', function() {
        return _token_list__WEBPACK_IMPORTED_MODULE_64__['default'];
      });
      var _unique_array__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__('./lib/core/utils/unique-array.js');
      __webpack_require__.d(__webpack_exports__, 'uniqueArray', function() {
        return _unique_array__WEBPACK_IMPORTED_MODULE_65__['default'];
      });
      var _valid_input_type__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__('./lib/core/utils/valid-input-type.js');
      __webpack_require__.d(__webpack_exports__, 'validInputTypes', function() {
        return _valid_input_type__WEBPACK_IMPORTED_MODULE_66__['default'];
      });
      var _valid_langs__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__('./lib/core/utils/valid-langs.js');
      __webpack_require__.d(__webpack_exports__, 'validLangs', function() {
        return _valid_langs__WEBPACK_IMPORTED_MODULE_67__['default'];
      });
    },
    './lib/core/utils/inject-style.js': function libCoreUtilsInjectStyleJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var styleSheet;
      function injectStyle(style) {
        if (styleSheet && styleSheet.parentNode) {
          if (styleSheet.styleSheet === undefined) {
            styleSheet.appendChild(document.createTextNode(style));
          } else {
            styleSheet.styleSheet.cssText += style;
          }
          return styleSheet;
        }
        if (!style) {
          return;
        }
        var head = document.head || document.getElementsByTagName('head')[0];
        styleSheet = document.createElement('style');
        styleSheet.type = 'text/css';
        if (styleSheet.styleSheet === undefined) {
          styleSheet.appendChild(document.createTextNode(style));
        } else {
          styleSheet.styleSheet.cssText = style;
        }
        head.appendChild(styleSheet);
        return styleSheet;
      }
      __webpack_exports__['default'] = injectStyle;
    },
    './lib/core/utils/is-hidden.js': function libCoreUtilsIsHiddenJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_node_from_tree__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/get-node-from-tree.js');
      function isHidden(el, recursed) {
        var node = Object(_get_node_from_tree__WEBPACK_IMPORTED_MODULE_0__['default'])(el);
        if (el.nodeType === 9) {
          return false;
        }
        if (el.nodeType === 11) {
          el = el.host;
        }
        if (node && node._isHidden !== null) {
          return node._isHidden;
        }
        var style = window.getComputedStyle(el, null);
        if (!style || !el.parentNode || style.getPropertyValue('display') === 'none' || !recursed && style.getPropertyValue('visibility') === 'hidden' || el.getAttribute('aria-hidden') === 'true') {
          return true;
        }
        var parent = el.assignedSlot ? el.assignedSlot : el.parentNode;
        var hidden = isHidden(parent, true);
        if (node) {
          node._isHidden = hidden;
        }
        return hidden;
      }
      __webpack_exports__['default'] = isHidden;
    },
    './lib/core/utils/is-html-element.js': function libCoreUtilsIsHtmlElementJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var htmlTags = [ 'a', 'abbr', 'address', 'area', 'article', 'aside', 'audio', 'b', 'base', 'bdi', 'bdo', 'blockquote', 'body', 'br', 'button', 'canvas', 'caption', 'cite', 'code', 'col', 'colgroup', 'data', 'datalist', 'dd', 'del', 'details', 'dfn', 'dialog', 'div', 'dl', 'dt', 'em', 'embed', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'head', 'header', 'hgroup', 'hr', 'html', 'i', 'iframe', 'img', 'input', 'ins', 'kbd', 'keygen', 'label', 'legend', 'li', 'link', 'main', 'map', 'mark', 'math', 'menu', 'menuitem', 'meta', 'meter', 'nav', 'noscript', 'object', 'ol', 'optgroup', 'option', 'output', 'p', 'param', 'picture', 'pre', 'progress', 'q', 'rb', 'rp', 'rt', 'rtc', 'ruby', 's', 'samp', 'script', 'section', 'select', 'slot', 'small', 'source', 'span', 'strong', 'style', 'sub', 'summary', 'sup', 'svg', 'table', 'tbody', 'td', 'template', 'textarea', 'tfoot', 'th', 'thead', 'time', 'title', 'tr', 'track', 'u', 'ul', 'var', 'video', 'wbr' ];
      function isHtmlElement(node) {
        if (node.namespaceURI === 'http://www.w3.org/2000/svg') {
          return false;
        }
        return htmlTags.includes(node.nodeName.toLowerCase());
      }
      __webpack_exports__['default'] = isHtmlElement;
    },
    './lib/core/utils/is-node-in-context.js': function libCoreUtilsIsNodeInContextJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _contains__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/contains.js');
      function getDeepest(collection) {
        return collection.sort(function(a, b) {
          if (Object(_contains__WEBPACK_IMPORTED_MODULE_0__['default'])(a, b)) {
            return 1;
          }
          return -1;
        })[0];
      }
      function isNodeInContext(node, context) {
        var include = context.include && getDeepest(context.include.filter(function(candidate) {
          return Object(_contains__WEBPACK_IMPORTED_MODULE_0__['default'])(candidate, node);
        }));
        var exclude = context.exclude && getDeepest(context.exclude.filter(function(candidate) {
          return Object(_contains__WEBPACK_IMPORTED_MODULE_0__['default'])(candidate, node);
        }));
        if (!exclude && include || exclude && Object(_contains__WEBPACK_IMPORTED_MODULE_0__['default'])(exclude, include)) {
          return true;
        }
        return false;
      }
      __webpack_exports__['default'] = isNodeInContext;
    },
    './lib/core/utils/is-shadow-root.js': function libCoreUtilsIsShadowRootJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var possibleShadowRoots = [ 'article', 'aside', 'blockquote', 'body', 'div', 'footer', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'main', 'nav', 'p', 'section', 'span' ];
      function isShadowRoot(node) {
        if (node.shadowRoot) {
          var nodeName = node.nodeName.toLowerCase();
          if (possibleShadowRoots.includes(nodeName) || /^[a-z][a-z0-9_.-]*-[a-z0-9_.-]*$/.test(nodeName)) {
            return true;
          }
        }
        return false;
      }
      __webpack_exports__['default'] = isShadowRoot;
    },
    './lib/core/utils/is-xhtml.js': function libCoreUtilsIsXhtmlJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function isXHTML(doc) {
        if (!doc.createElement) {
          return false;
        }
        return doc.createElement('A').localName === 'A';
      }
      __webpack_exports__['default'] = isXHTML;
    },
    './lib/core/utils/matches.js': function libCoreUtilsMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'convertSelector', function() {
        return convertSelector;
      });
      __webpack_require__.d(__webpack_exports__, 'matchesExpression', function() {
        return matchesExpression;
      });
      var _css_parser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/css-parser.js');
      function matchesTag(vNode, exp) {
        return vNode.props.nodeType === 1 && (exp.tag === '*' || vNode.props.nodeName === exp.tag);
      }
      function matchesClasses(vNode, exp) {
        return !exp.classes || exp.classes.every(function(cl) {
          return vNode.hasClass(cl.value);
        });
      }
      function matchesAttributes(vNode, exp) {
        return !exp.attributes || exp.attributes.every(function(att) {
          var nodeAtt = vNode.attr(att.key);
          return nodeAtt !== null && (!att.value || att.test(nodeAtt));
        });
      }
      function matchesId(vNode, exp) {
        return !exp.id || vNode.props.id === exp.id;
      }
      function matchesPseudos(target, exp) {
        if (!exp.pseudos || exp.pseudos.every(function(pseudo) {
          if (pseudo.name === 'not') {
            return !matchesExpression(target, pseudo.expressions[0]);
          }
          throw new Error('the pseudo selector ' + pseudo.name + ' has not yet been implemented');
        })) {
          return true;
        }
        return false;
      }
      function matchExpression(vNode, expression) {
        return matchesTag(vNode, expression) && matchesClasses(vNode, expression) && matchesAttributes(vNode, expression) && matchesId(vNode, expression) && matchesPseudos(vNode, expression);
      }
      var escapeRegExp = function() {
        var from = /(?=[\-\[\]{}()*+?.\\\^$|,#\s])/g;
        var to = '\\';
        return function(string) {
          return string.replace(from, to);
        };
      }();
      var reUnescape = /\\/g;
      function convertAttributes(atts) {
        if (!atts) {
          return;
        }
        return atts.map(function(att) {
          var attributeKey = att.name.replace(reUnescape, '');
          var attributeValue = (att.value || '').replace(reUnescape, '');
          var test, regexp;
          switch (att.operator) {
           case '^=':
            regexp = new RegExp('^' + escapeRegExp(attributeValue));
            break;

           case '$=':
            regexp = new RegExp(escapeRegExp(attributeValue) + '$');
            break;

           case '~=':
            regexp = new RegExp('(^|\\s)' + escapeRegExp(attributeValue) + '(\\s|$)');
            break;

           case '|=':
            regexp = new RegExp('^' + escapeRegExp(attributeValue) + '(-|$)');
            break;

           case '=':
            test = function test(value) {
              return attributeValue === value;
            };
            break;

           case '*=':
            test = function test(value) {
              return value && value.includes(attributeValue);
            };
            break;

           case '!=':
            test = function test(value) {
              return attributeValue !== value;
            };
            break;

           default:
            test = function test(value) {
              return !!value;
            };
          }
          if (attributeValue === '' && /^[*$^]=$/.test(att.operator)) {
            test = function test() {
              return false;
            };
          }
          if (!test) {
            test = function test(value) {
              return value && regexp.test(value);
            };
          }
          return {
            key: attributeKey,
            value: attributeValue,
            test: test
          };
        });
      }
      function convertClasses(classes) {
        if (!classes) {
          return;
        }
        return classes.map(function(className) {
          className = className.replace(reUnescape, '');
          return {
            value: className,
            regexp: new RegExp('(^|\\s)' + escapeRegExp(className) + '(\\s|$)')
          };
        });
      }
      function convertPseudos(pseudos) {
        if (!pseudos) {
          return;
        }
        return pseudos.map(function(p) {
          var expressions;
          if (p.name === 'not') {
            expressions = p.value;
            expressions = expressions.selectors ? expressions.selectors : [ expressions ];
            expressions = convertExpressions(expressions);
          }
          return {
            name: p.name,
            expressions: expressions,
            value: p.value
          };
        });
      }
      function convertExpressions(expressions) {
        return expressions.map(function(exp) {
          var newExp = [];
          var rule = exp.rule;
          while (rule) {
            newExp.push({
              tag: rule.tagName ? rule.tagName.toLowerCase() : '*',
              combinator: rule.nestingOperator ? rule.nestingOperator : ' ',
              id: rule.id,
              attributes: convertAttributes(rule.attrs),
              classes: convertClasses(rule.classNames),
              pseudos: convertPseudos(rule.pseudos)
            });
            rule = rule.rule;
          }
          return newExp;
        });
      }
      function convertSelector(selector) {
        var expressions = _css_parser__WEBPACK_IMPORTED_MODULE_0__['default'].parse(selector);
        expressions = expressions.selectors ? expressions.selectors : [ expressions ];
        return convertExpressions(expressions);
      }
      function matchesExpression(vNode, expressions, matchAnyParent) {
        var exps = [].concat(expressions);
        var expression = exps.pop();
        var matches = matchExpression(vNode, expression);
        while (!matches && matchAnyParent && vNode.parent) {
          vNode = vNode.parent;
          matches = matchExpression(vNode, expression);
        }
        if (exps.length) {
          if ([ ' ', '>' ].includes(expression.combinator) === false) {
            throw new Error('axe.utils.matchesExpression does not support the combinator: ' + expression.combinator);
          }
          matches = matches && matchesExpression(vNode.parent, exps, expression.combinator === ' ');
        }
        return matches;
      }
      function matches(vNode, selector) {
        var expressions = convertSelector(selector);
        return expressions.some(function(expression) {
          return matchesExpression(vNode, expression);
        });
      }
      __webpack_exports__['default'] = matches;
    },
    './lib/core/utils/memoize.js': function libCoreUtilsMemoizeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var memoizee__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./node_modules/memoizee/index.js');
      var memoizee__WEBPACK_IMPORTED_MODULE_0___default = __webpack_require__.n(memoizee__WEBPACK_IMPORTED_MODULE_0__);
      axe._memoizedFns = [];
      function memoizeImplementation(fn) {
        var memoized = memoizee__WEBPACK_IMPORTED_MODULE_0___default()(fn);
        axe._memoizedFns.push(memoized);
        return memoized;
      }
      __webpack_exports__['default'] = memoizeImplementation;
    },
    './lib/core/utils/merge-results.js': function libCoreUtilsMergeResultsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _dq_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/dq-element.js');
      var _get_all_checks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/get-all-checks.js');
      var _node_sorter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/node-sorter.js');
      var _find_by__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/find-by.js');
      function pushFrame(resultSet, dqFrame, options) {
        resultSet.forEach(function(res) {
          res.node = _dq_element__WEBPACK_IMPORTED_MODULE_0__['default'].fromFrame(res.node, options, dqFrame);
          var checks = Object(_get_all_checks__WEBPACK_IMPORTED_MODULE_1__['default'])(res);
          checks.forEach(function(check) {
            check.relatedNodes = check.relatedNodes.map(function(node) {
              return _dq_element__WEBPACK_IMPORTED_MODULE_0__['default'].fromFrame(node, options, dqFrame);
            });
          });
        });
      }
      function spliceNodes(target, to) {
        var firstFromFrame = to[0].node;
        for (var i = 0; i < target.length; i++) {
          var node = target[i].node;
          var sorterResult = Object(_node_sorter__WEBPACK_IMPORTED_MODULE_2__['default'])({
            actualNode: node.element
          }, {
            actualNode: firstFromFrame.element
          });
          if (sorterResult > 0 || sorterResult === 0 && firstFromFrame.selector.length < node.selector.length) {
            target.splice.apply(target, [ i, 0 ].concat(to));
            return;
          }
        }
        target.push.apply(target, to);
      }
      function normalizeResult(result) {
        if (!result || !result.results) {
          return null;
        }
        if (!Array.isArray(result.results)) {
          return [ result.results ];
        }
        if (!result.results.length) {
          return null;
        }
        return result.results;
      }
      function mergeResults(frameResults, options) {
        var mergedResult = [];
        frameResults.forEach(function(frameResult) {
          var results = normalizeResult(frameResult);
          if (!results || !results.length) {
            return;
          }
          var dqFrame;
          if (frameResult.frameElement) {
            var spec = {
              selector: [ frameResult.frame ]
            };
            dqFrame = new _dq_element__WEBPACK_IMPORTED_MODULE_0__['default'](frameResult.frameElement, options, spec);
          }
          results.forEach(function(ruleResult) {
            if (ruleResult.nodes && dqFrame) {
              pushFrame(ruleResult.nodes, dqFrame, options);
            }
            var res = Object(_find_by__WEBPACK_IMPORTED_MODULE_3__['default'])(mergedResult, 'id', ruleResult.id);
            if (!res) {
              mergedResult.push(ruleResult);
            } else {
              if (ruleResult.nodes.length) {
                spliceNodes(res.nodes, ruleResult.nodes);
              }
            }
          });
        });
        return mergedResult;
      }
      __webpack_exports__['default'] = mergeResults;
    },
    './lib/core/utils/node-sorter.js': function libCoreUtilsNodeSorterJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function nodeSorter(nodeA, nodeB) {
        nodeA = nodeA.actualNode || nodeA;
        nodeB = nodeB.actualNode || nodeB;
        if (nodeA === nodeB) {
          return 0;
        }
        if (nodeA.compareDocumentPosition(nodeB) & 4) {
          return -1;
        } else {
          return 1;
        }
      }
      __webpack_exports__['default'] = nodeSorter;
    },
    './lib/core/utils/parse-crossorigin-stylesheet.js': function libCoreUtilsParseCrossoriginStylesheetJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./node_modules/axios/index.js');
      var axios__WEBPACK_IMPORTED_MODULE_0___default = __webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);
      var _parse_stylesheet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/parse-stylesheet.js');
      var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/constants.js');
      function parseCrossOriginStylesheet(url, options, priority, importedUrls, isCrossOrigin) {
        var axiosOptions = {
          method: 'get',
          timeout: _constants__WEBPACK_IMPORTED_MODULE_2__['default'].preload.timeout,
          url: url
        };
        importedUrls.push(url);
        return axios__WEBPACK_IMPORTED_MODULE_0___default()(axiosOptions).then(function(_ref56) {
          var data = _ref56.data;
          var result = options.convertDataToStylesheet({
            data: data,
            isCrossOrigin: isCrossOrigin,
            priority: priority,
            root: options.rootNode,
            shadowId: options.shadowId
          });
          return Object(_parse_stylesheet__WEBPACK_IMPORTED_MODULE_1__['default'])(result.sheet, options, priority, importedUrls, result.isCrossOrigin);
        });
      }
      __webpack_exports__['default'] = parseCrossOriginStylesheet;
    },
    './lib/core/utils/parse-sameorigin-stylesheet.js': function libCoreUtilsParseSameoriginStylesheetJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _parse_crossorigin_stylesheet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/parse-crossorigin-stylesheet.js');
      function parseSameOriginStylesheet(sheet, options, priority, importedUrls) {
        var isCrossOrigin = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
        var rules = Array.from(sheet.cssRules);
        if (!rules) {
          return Promise.resolve();
        }
        var cssImportRules = rules.filter(function(r) {
          return r.type === 3;
        });
        if (!cssImportRules.length) {
          return Promise.resolve({
            isCrossOrigin: isCrossOrigin,
            priority: priority,
            root: options.rootNode,
            shadowId: options.shadowId,
            sheet: sheet
          });
        }
        var cssImportUrlsNotAlreadyImported = cssImportRules.filter(function(rule) {
          return rule.href;
        }).map(function(rule) {
          return rule.href;
        }).filter(function(url) {
          return !importedUrls.includes(url);
        });
        var promises = cssImportUrlsNotAlreadyImported.map(function(importUrl, cssRuleIndex) {
          var newPriority = [].concat(_toConsumableArray(priority), [ cssRuleIndex ]);
          var isCrossOriginRequest = /^https?:\/\/|^\/\//i.test(importUrl);
          return Object(_parse_crossorigin_stylesheet__WEBPACK_IMPORTED_MODULE_0__['default'])(importUrl, options, newPriority, importedUrls, isCrossOriginRequest);
        });
        var nonImportCSSRules = rules.filter(function(r) {
          return r.type !== 3;
        });
        if (!nonImportCSSRules.length) {
          return Promise.all(promises);
        }
        promises.push(Promise.resolve(options.convertDataToStylesheet({
          data: nonImportCSSRules.map(function(rule) {
            return rule.cssText;
          }).join(),
          isCrossOrigin: isCrossOrigin,
          priority: priority,
          root: options.rootNode,
          shadowId: options.shadowId
        })));
        return Promise.all(promises);
      }
      __webpack_exports__['default'] = parseSameOriginStylesheet;
    },
    './lib/core/utils/parse-stylesheet.js': function libCoreUtilsParseStylesheetJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _parse_sameorigin_stylesheet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/parse-sameorigin-stylesheet.js');
      var _parse_crossorigin_stylesheet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/parse-crossorigin-stylesheet.js');
      function parseStylesheet(sheet, options, priority, importedUrls) {
        var isCrossOrigin = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
        var isSameOrigin = isSameOriginStylesheet(sheet);
        if (isSameOrigin) {
          return Object(_parse_sameorigin_stylesheet__WEBPACK_IMPORTED_MODULE_0__['default'])(sheet, options, priority, importedUrls, isCrossOrigin);
        }
        return Object(_parse_crossorigin_stylesheet__WEBPACK_IMPORTED_MODULE_1__['default'])(sheet.href, options, priority, importedUrls, true);
      }
      function isSameOriginStylesheet(sheet) {
        try {
          var rules = sheet.cssRules;
          if (!rules && sheet.href) {
            return false;
          }
          return true;
        } catch (e) {
          return false;
        }
      }
      __webpack_exports__['default'] = parseStylesheet;
    },
    './lib/core/utils/performance-timer.js': function libCoreUtilsPerformanceTimerJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/log.js');
      var performanceTimer = function() {
        'use strict';
        function now() {
          if (window.performance && window.performance) {
            return window.performance.now();
          }
        }
        var originalTime = null;
        var lastRecordedTime = now();
        return {
          start: function start() {
            this.mark('mark_axe_start');
          },
          end: function end() {
            this.mark('mark_axe_end');
            this.measure('axe', 'mark_axe_start', 'mark_axe_end');
            this.logMeasures('axe');
          },
          auditStart: function auditStart() {
            this.mark('mark_audit_start');
          },
          auditEnd: function auditEnd() {
            this.mark('mark_audit_end');
            this.measure('audit_start_to_end', 'mark_audit_start', 'mark_audit_end');
            this.logMeasures();
          },
          mark: function mark(markName) {
            if (window.performance && window.performance.mark !== undefined) {
              window.performance.mark(markName);
            }
          },
          measure: function measure(measureName, startMark, endMark) {
            if (window.performance && window.performance.measure !== undefined) {
              window.performance.measure(measureName, startMark, endMark);
            }
          },
          logMeasures: function logMeasures(measureName) {
            function logMeasure(req) {
              Object(_log__WEBPACK_IMPORTED_MODULE_0__['default'])('Measure ' + req.name + ' took ' + req.duration + 'ms');
            }
            if (window.performance && window.performance.getEntriesByType !== undefined) {
              var axeStart = window.performance.getEntriesByName('mark_axe_start')[0];
              var measures = window.performance.getEntriesByType('measure').filter(function(measure) {
                return measure.startTime >= axeStart.startTime;
              });
              for (var i = 0; i < measures.length; ++i) {
                var req = measures[i];
                if (req.name === measureName) {
                  logMeasure(req);
                  return;
                }
                logMeasure(req);
              }
            }
          },
          timeElapsed: function timeElapsed() {
            return now() - lastRecordedTime;
          },
          reset: function reset() {
            if (!originalTime) {
              originalTime = now();
            }
            lastRecordedTime = now();
          }
        };
      }();
      __webpack_exports__['default'] = performanceTimer;
    },
    './lib/core/utils/pollyfills.js': function libCoreUtilsPollyfillsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'pollyfillElementsFromPoint', function() {
        return pollyfillElementsFromPoint;
      });
      if (typeof Object.assign !== 'function') {
        (function() {
          Object.assign = function(target) {
            if (target === undefined || target === null) {
              throw new TypeError('Cannot convert undefined or null to object');
            }
            var output = Object(target);
            for (var index = 1; index < arguments.length; index++) {
              var source = arguments[index];
              if (source !== undefined && source !== null) {
                for (var nextKey in source) {
                  if (source.hasOwnProperty(nextKey)) {
                    output[nextKey] = source[nextKey];
                  }
                }
              }
            }
            return output;
          };
        })();
      }
      if (!Array.prototype.find) {
        Object.defineProperty(Array.prototype, 'find', {
          value: function value(predicate) {
            if (this === null) {
              throw new TypeError('Array.prototype.find called on null or undefined');
            }
            if (typeof predicate !== 'function') {
              throw new TypeError('predicate must be a function');
            }
            var list = Object(this);
            var length = list.length >>> 0;
            var thisArg = arguments[1];
            var value;
            for (var i = 0; i < length; i++) {
              value = list[i];
              if (predicate.call(thisArg, value, i, list)) {
                return value;
              }
            }
            return undefined;
          }
        });
      }
      function pollyfillElementsFromPoint() {
        if (document.elementsFromPoint) {
          return document.elementsFromPoint;
        }
        if (document.msElementsFromPoint) {
          return document.msElementsFromPoint;
        }
        var usePointer = function() {
          var element = document.createElement('x');
          element.style.cssText = 'pointer-events:auto';
          return element.style.pointerEvents === 'auto';
        }();
        var cssProp = usePointer ? 'pointer-events' : 'visibility';
        var cssDisableVal = usePointer ? 'none' : 'hidden';
        var style = document.createElement('style');
        style.innerHTML = usePointer ? '* { pointer-events: all }' : '* { visibility: visible }';
        return function(x, y) {
          var current, i, d;
          var elements = [];
          var previousPointerEvents = [];
          document.head.appendChild(style);
          while ((current = document.elementFromPoint(x, y)) && elements.indexOf(current) === -1) {
            elements.push(current);
            previousPointerEvents.push({
              value: current.style.getPropertyValue(cssProp),
              priority: current.style.getPropertyPriority(cssProp)
            });
            current.style.setProperty(cssProp, cssDisableVal, 'important');
          }
          if (elements.indexOf(document.documentElement) < elements.length - 1) {
            elements.splice(elements.indexOf(document.documentElement), 1);
            elements.push(document.documentElement);
          }
          for (i = previousPointerEvents.length; !!(d = previousPointerEvents[--i]); ) {
            elements[i].style.setProperty(cssProp, d.value ? d.value : '', d.priority);
          }
          document.head.removeChild(style);
          return elements;
        };
      }
      if (typeof window.addEventListener === 'function') {
        document.elementsFromPoint = pollyfillElementsFromPoint();
      }
      if (!Array.prototype.includes) {
        Object.defineProperty(Array.prototype, 'includes', {
          value: function value(searchElement) {
            var O = Object(this);
            var len = parseInt(O.length, 10) || 0;
            if (len === 0) {
              return false;
            }
            var n = parseInt(arguments[1], 10) || 0;
            var k;
            if (n >= 0) {
              k = n;
            } else {
              k = len + n;
              if (k < 0) {
                k = 0;
              }
            }
            var currentElement;
            while (k < len) {
              currentElement = O[k];
              if (searchElement === currentElement || searchElement !== searchElement && currentElement !== currentElement) {
                return true;
              }
              k++;
            }
            return false;
          }
        });
      }
      if (!Array.prototype.some) {
        Object.defineProperty(Array.prototype, 'some', {
          value: function value(fun) {
            if (this == null) {
              throw new TypeError('Array.prototype.some called on null or undefined');
            }
            if (typeof fun !== 'function') {
              throw new TypeError();
            }
            var t = Object(this);
            var len = t.length >>> 0;
            var thisArg = arguments.length >= 2 ? arguments[1] : void 0;
            for (var i = 0; i < len; i++) {
              if (i in t && fun.call(thisArg, t[i], i, t)) {
                return true;
              }
            }
            return false;
          }
        });
      }
      if (!Array.from) {
        Object.defineProperty(Array, 'from', {
          value: function() {
            var toStr = Object.prototype.toString;
            var isCallable = function isCallable(fn) {
              return typeof fn === 'function' || toStr.call(fn) === '[object Function]';
            };
            var toInteger = function toInteger(value) {
              var number = Number(value);
              if (isNaN(number)) {
                return 0;
              }
              if (number === 0 || !isFinite(number)) {
                return number;
              }
              return (number > 0 ? 1 : -1) * Math.floor(Math.abs(number));
            };
            var maxSafeInteger = Math.pow(2, 53) - 1;
            var toLength = function toLength(value) {
              var len = toInteger(value);
              return Math.min(Math.max(len, 0), maxSafeInteger);
            };
            return function from(arrayLike) {
              var C = this;
              var items = Object(arrayLike);
              if (arrayLike == null) {
                throw new TypeError('Array.from requires an array-like object - not null or undefined');
              }
              var mapFn = arguments.length > 1 ? arguments[1] : void undefined;
              var T;
              if (typeof mapFn !== 'undefined') {
                if (!isCallable(mapFn)) {
                  throw new TypeError('Array.from: when provided, the second argument must be a function');
                }
                if (arguments.length > 2) {
                  T = arguments[2];
                }
              }
              var len = toLength(items.length);
              var A = isCallable(C) ? Object(new C(len)) : new Array(len);
              var k = 0;
              var kValue;
              while (k < len) {
                kValue = items[k];
                if (mapFn) {
                  A[k] = typeof T === 'undefined' ? mapFn(kValue, k) : mapFn.call(T, kValue, k);
                } else {
                  A[k] = kValue;
                }
                k += 1;
              }
              A.length = len;
              return A;
            };
          }()
        });
      }
      if (!String.prototype.includes) {
        String.prototype.includes = function(search, start) {
          if (typeof start !== 'number') {
            start = 0;
          }
          if (start + search.length > this.length) {
            return false;
          } else {
            return this.indexOf(search, start) !== -1;
          }
        };
      }
    },
    './lib/core/utils/preload-cssom.js': function libCoreUtilsPreloadCssomJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_stylesheet_factory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/get-stylesheet-factory.js');
      var _unique_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/unique-array.js');
      var _get_root_node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/get-root-node.js');
      var _parse_stylesheet__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/parse-stylesheet.js');
      var _query_selector_all_filter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/core/utils/query-selector-all-filter.js');
      function preloadCssom(_ref57) {
        var _ref57$treeRoot = _ref57.treeRoot, treeRoot = _ref57$treeRoot === void 0 ? axe._tree[0] : _ref57$treeRoot;
        var rootNodes = getAllRootNodesInTree(treeRoot);
        if (!rootNodes.length) {
          return Promise.resolve();
        }
        var dynamicDoc = document.implementation.createHTMLDocument('Dynamic document for loading cssom');
        var convertDataToStylesheet = Object(_get_stylesheet_factory__WEBPACK_IMPORTED_MODULE_0__['default'])(dynamicDoc);
        return getCssomForAllRootNodes(rootNodes, convertDataToStylesheet).then(function(assets) {
          return flattenAssets(assets);
        });
      }
      __webpack_exports__['default'] = preloadCssom;
      function getAllRootNodesInTree(tree) {
        var ids = [];
        var rootNodes = Object(_query_selector_all_filter__WEBPACK_IMPORTED_MODULE_4__['default'])(tree, '*', function(node) {
          if (ids.includes(node.shadowId)) {
            return false;
          }
          ids.push(node.shadowId);
          return true;
        }).map(function(node) {
          return {
            shadowId: node.shadowId,
            rootNode: Object(_get_root_node__WEBPACK_IMPORTED_MODULE_2__['default'])(node.actualNode)
          };
        });
        return Object(_unique_array__WEBPACK_IMPORTED_MODULE_1__['default'])(rootNodes, []);
      }
      function getCssomForAllRootNodes(rootNodes, convertDataToStylesheet) {
        var promises = [];
        rootNodes.forEach(function(_ref58, index) {
          var rootNode = _ref58.rootNode, shadowId = _ref58.shadowId;
          var sheets = getStylesheetsOfRootNode(rootNode, shadowId, convertDataToStylesheet);
          if (!sheets) {
            return Promise.all(promises);
          }
          var rootIndex = index + 1;
          var parseOptions = {
            rootNode: rootNode,
            shadowId: shadowId,
            convertDataToStylesheet: convertDataToStylesheet,
            rootIndex: rootIndex
          };
          var importedUrls = [];
          var p = Promise.all(sheets.map(function(sheet, sheetIndex) {
            var priority = [ rootIndex, sheetIndex ];
            return Object(_parse_stylesheet__WEBPACK_IMPORTED_MODULE_3__['default'])(sheet, parseOptions, priority, importedUrls);
          }));
          promises.push(p);
        });
        return Promise.all(promises);
      }
      function flattenAssets(assets) {
        return assets.reduce(function(acc, val) {
          return Array.isArray(val) ? acc.concat(flattenAssets(val)) : acc.concat(val);
        }, []);
      }
      function getStylesheetsOfRootNode(rootNode, shadowId, convertDataToStylesheet) {
        var sheets;
        if (rootNode.nodeType === 11 && shadowId) {
          sheets = getStylesheetsFromDocumentFragment(rootNode, convertDataToStylesheet);
        } else {
          sheets = getStylesheetsFromDocument(rootNode);
        }
        return filterStylesheetsWithSameHref(sheets);
      }
      function getStylesheetsFromDocumentFragment(rootNode, convertDataToStylesheet) {
        return Array.from(rootNode.children).filter(filerStyleAndLinkAttributesInDocumentFragment).reduce(function(out, node) {
          var nodeName = node.nodeName.toUpperCase();
          var data = nodeName === 'STYLE' ? node.textContent : node;
          var isLink = nodeName === 'LINK';
          var stylesheet = convertDataToStylesheet({
            data: data,
            isLink: isLink,
            root: rootNode
          });
          out.push(stylesheet.sheet);
          return out;
        }, []);
      }
      function getStylesheetsFromDocument(rootNode) {
        return Array.from(rootNode.styleSheets).filter(function(sheet) {
          return filterMediaIsPrint(sheet.media.mediaText);
        });
      }
      function filerStyleAndLinkAttributesInDocumentFragment(node) {
        var nodeName = node.nodeName.toUpperCase();
        var linkHref = node.getAttribute('href');
        var linkRel = node.getAttribute('rel');
        var isLink = nodeName === 'LINK' && linkHref && linkRel && node.rel.toUpperCase().includes('STYLESHEET');
        var isStyle = nodeName === 'STYLE';
        return isStyle || isLink && filterMediaIsPrint(node.media);
      }
      function filterMediaIsPrint(media) {
        if (!media) {
          return true;
        }
        return !media.toUpperCase().includes('PRINT');
      }
      function filterStylesheetsWithSameHref(sheets) {
        var hrefs = [];
        return sheets.filter(function(sheet) {
          if (!sheet.href) {
            return true;
          }
          if (hrefs.includes(sheet.href)) {
            return false;
          }
          hrefs.push(sheet.href);
          return true;
        });
      }
    },
    './lib/core/utils/preload-media.js': function libCoreUtilsPreloadMediaJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _query_selector_all_filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/query-selector-all-filter.js');
      function preloadMedia(_ref59) {
        var _ref59$treeRoot = _ref59.treeRoot, treeRoot = _ref59$treeRoot === void 0 ? axe._tree[0] : _ref59$treeRoot;
        var mediaVirtualNodes = Object(_query_selector_all_filter__WEBPACK_IMPORTED_MODULE_0__['default'])(treeRoot, 'video, audio', function(_ref60) {
          var actualNode = _ref60.actualNode;
          if (actualNode.hasAttribute('src')) {
            return !!actualNode.getAttribute('src');
          }
          var sourceWithSrc = Array.from(actualNode.getElementsByTagName('source')).filter(function(source) {
            return !!source.getAttribute('src');
          });
          if (sourceWithSrc.length <= 0) {
            return false;
          }
          return true;
        });
        return Promise.all(mediaVirtualNodes.map(function(_ref61) {
          var actualNode = _ref61.actualNode;
          return isMediaElementReady(actualNode);
        }));
      }
      __webpack_exports__['default'] = preloadMedia;
      function isMediaElementReady(elm) {
        return new Promise(function(resolve) {
          if (elm.readyState > 0) {
            resolve(elm);
          }
          function onMediaReady() {
            elm.removeEventListener('loadedmetadata', onMediaReady);
            resolve(elm);
          }
          elm.addEventListener('loadedmetadata', onMediaReady);
        });
      }
    },
    './lib/core/utils/preload.js': function libCoreUtilsPreloadJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'shouldPreload', function() {
        return shouldPreload;
      });
      __webpack_require__.d(__webpack_exports__, 'getPreloadConfig', function() {
        return getPreloadConfig;
      });
      var _preload_cssom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/preload-cssom.js');
      var _preload_media__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/preload-media.js');
      var _unique_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/unique-array.js');
      var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/constants.js');
      function isValidPreloadObject(preload) {
        return _typeof(preload) === 'object' && Array.isArray(preload.assets);
      }
      function shouldPreload(options) {
        if (!options || options.preload === undefined || options.preload === null) {
          return true;
        }
        if (typeof options.preload === 'boolean') {
          return options.preload;
        }
        return isValidPreloadObject(options.preload);
      }
      function getPreloadConfig(options) {
        var _constants__WEBPACK_I2 = _constants__WEBPACK_IMPORTED_MODULE_3__['default'].preload, assets = _constants__WEBPACK_I2.assets, timeout = _constants__WEBPACK_I2.timeout;
        var config = {
          assets: assets,
          timeout: timeout
        };
        if (!options.preload) {
          return config;
        }
        if (typeof options.preload === 'boolean') {
          return config;
        }
        var areRequestedAssetsValid = options.preload.assets.every(function(a) {
          return assets.includes(a.toLowerCase());
        });
        if (!areRequestedAssetsValid) {
          throw new Error('Requested assets, not supported. ' + 'Supported assets are: '.concat(assets.join(', '), '.'));
        }
        config.assets = Object(_unique_array__WEBPACK_IMPORTED_MODULE_2__['default'])(options.preload.assets.map(function(a) {
          return a.toLowerCase();
        }), []);
        if (options.preload.timeout && typeof options.preload.timeout === 'number' && !isNaN(options.preload.timeout)) {
          config.timeout = options.preload.timeout;
        }
        return config;
      }
      function preload(options) {
        var preloadFunctionsMap = {
          cssom: _preload_cssom__WEBPACK_IMPORTED_MODULE_0__['default'],
          media: _preload_media__WEBPACK_IMPORTED_MODULE_1__['default']
        };
        if (!shouldPreload(options)) {
          return Promise.resolve();
        }
        return new Promise(function(resolve, reject) {
          var _getPreloadConfig = getPreloadConfig(options), assets = _getPreloadConfig.assets, timeout = _getPreloadConfig.timeout;
          var preloadTimeout = setTimeout(function() {
            return reject(new Error('Preload assets timed out.'));
          }, timeout);
          Promise.all(assets.map(function(asset) {
            return preloadFunctionsMap[asset](options).then(function(results) {
              return _defineProperty({}, asset, results);
            });
          })).then(function(results) {
            var preloadAssets = results.reduce(function(out, result) {
              return _extends({}, out, result);
            }, {});
            clearTimeout(preloadTimeout);
            resolve(preloadAssets);
          })['catch'](function(err) {
            clearTimeout(preloadTimeout);
            reject(err);
          });
        });
      }
      __webpack_exports__['default'] = preload;
    },
    './lib/core/utils/process-message.js': function libCoreUtilsProcessMessageJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _reporters_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/reporters/helpers/index.js');
      var dataRegex = /\$\{\s?data\s?\}/g;
      function substitute(str, data) {
        if (typeof data === 'string') {
          return str.replace(dataRegex, data);
        }
        for (var prop in data) {
          if (data.hasOwnProperty(prop)) {
            var regex = new RegExp('\\${\\s?data\\.' + prop + '\\s?}', 'g');
            str = str.replace(regex, data[prop]);
          }
        }
        return str;
      }
      function processMessage(message, data) {
        if (!message) {
          return;
        }
        if (Array.isArray(data)) {
          data.values = data.join(', ');
          if (typeof message.singular === 'string' && typeof message.plural === 'string') {
            var _str = data.length === 1 ? message.singular : message.plural;
            return substitute(_str, data);
          }
          return substitute(message, data);
        }
        if (typeof message === 'string') {
          return substitute(message, data);
        }
        if (typeof data === 'string') {
          var _str2 = message[data];
          return substitute(_str2, data);
        }
        var str = message['default'] || Object(_reporters_helpers__WEBPACK_IMPORTED_MODULE_0__['incompleteFallbackMessage'])();
        if (data && data.messageKey && message[data.messageKey]) {
          str = message[data.messageKey];
        }
        return processMessage(str, data);
      }
      __webpack_exports__['default'] = processMessage;
    },
    './lib/core/utils/publish-metadata.js': function libCoreUtilsPublishMetadataJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _process_message__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/process-message.js');
      var _clone__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/clone.js');
      var _find_by__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/find-by.js');
      var _extend_meta_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/extend-meta-data.js');
      var _reporters_helpers_incomplete_fallback_msg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/core/reporters/helpers/incomplete-fallback-msg.js');
      function getIncompleteReason(checkData, messages) {
        function getDefaultMsg(messages) {
          if (messages.incomplete && messages.incomplete['default']) {
            return messages.incomplete['default'];
          } else {
            return Object(_reporters_helpers_incomplete_fallback_msg__WEBPACK_IMPORTED_MODULE_4__['default'])();
          }
        }
        if (checkData && checkData.missingData) {
          try {
            var msg = messages.incomplete[checkData.missingData[0].reason];
            if (!msg) {
              throw new Error();
            }
            return msg;
          } catch (e) {
            if (typeof checkData.missingData === 'string') {
              return messages.incomplete[checkData.missingData];
            } else {
              return getDefaultMsg(messages);
            }
          }
        } else if (checkData && checkData.messageKey) {
          return messages.incomplete[checkData.messageKey];
        } else {
          return getDefaultMsg(messages);
        }
      }
      function extender(checksData, shouldBeTrue) {
        return function(check) {
          var sourceData = checksData[check.id] || {};
          var messages = sourceData.messages || {};
          var data = Object.assign({}, sourceData);
          delete data.messages;
          if (check.result === undefined) {
            if (_typeof(messages.incomplete) === 'object' && !Array.isArray(check.data)) {
              data.message = getIncompleteReason(check.data, messages);
            }
            if (!data.message) {
              data.message = messages.incomplete;
            }
          } else {
            data.message = check.result === shouldBeTrue ? messages.pass : messages.fail;
          }
          if (typeof data.message !== 'function') {
            data.message = Object(_process_message__WEBPACK_IMPORTED_MODULE_0__['default'])(data.message, check.data);
          }
          Object(_extend_meta_data__WEBPACK_IMPORTED_MODULE_3__['default'])(check, data);
        };
      }
      function publishMetaData(ruleResult) {
        var checksData = axe._audit.data.checks || {};
        var rulesData = axe._audit.data.rules || {};
        var rule = Object(_find_by__WEBPACK_IMPORTED_MODULE_2__['default'])(axe._audit.rules, 'id', ruleResult.id) || {};
        ruleResult.tags = Object(_clone__WEBPACK_IMPORTED_MODULE_1__['default'])(rule.tags || []);
        var shouldBeTrue = extender(checksData, true);
        var shouldBeFalse = extender(checksData, false);
        ruleResult.nodes.forEach(function(detail) {
          detail.any.forEach(shouldBeTrue);
          detail.all.forEach(shouldBeTrue);
          detail.none.forEach(shouldBeFalse);
        });
        Object(_extend_meta_data__WEBPACK_IMPORTED_MODULE_3__['default'])(ruleResult, Object(_clone__WEBPACK_IMPORTED_MODULE_1__['default'])(rulesData[ruleResult.id] || {}));
      }
      __webpack_exports__['default'] = publishMetaData;
    },
    './lib/core/utils/query-selector-all-filter.js': function libCoreUtilsQuerySelectorAllFilterJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _matches__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/matches.js');
      function createLocalVariables(vNodes, anyLevel, thisLevel, parentShadowId) {
        var retVal = {
          vNodes: vNodes.slice(),
          anyLevel: anyLevel,
          thisLevel: thisLevel,
          parentShadowId: parentShadowId
        };
        retVal.vNodes.reverse();
        return retVal;
      }
      function matchExpressions(domTree, expressions, filter) {
        var stack = [];
        var vNodes = Array.isArray(domTree) ? domTree : [ domTree ];
        var currentLevel = createLocalVariables(vNodes, expressions, [], domTree[0].shadowId);
        var result = [];
        while (currentLevel.vNodes.length) {
          var vNode = currentLevel.vNodes.pop();
          var childOnly = [];
          var childAny = [];
          var combined = currentLevel.anyLevel.slice().concat(currentLevel.thisLevel);
          var added = false;
          for (var i = 0; i < combined.length; i++) {
            var exp = combined[i];
            if ((!exp[0].id || vNode.shadowId === currentLevel.parentShadowId) && Object(_matches__WEBPACK_IMPORTED_MODULE_0__['matchesExpression'])(vNode, exp[0])) {
              if (exp.length === 1) {
                if (!added && (!filter || filter(vNode))) {
                  result.push(vNode);
                  added = true;
                }
              } else {
                var rest = exp.slice(1);
                if ([ ' ', '>' ].includes(rest[0].combinator) === false) {
                  throw new Error('axe.utils.querySelectorAll does not support the combinator: ' + exp[1].combinator);
                }
                if (rest[0].combinator === '>') {
                  childOnly.push(rest);
                } else {
                  childAny.push(rest);
                }
              }
            }
            if ((!exp[0].id || vNode.shadowId === currentLevel.parentShadowId) && currentLevel.anyLevel.includes(exp)) {
              childAny.push(exp);
            }
          }
          if (vNode.children && vNode.children.length) {
            stack.push(currentLevel);
            currentLevel = createLocalVariables(vNode.children, childAny, childOnly, vNode.shadowId);
          }
          while (!currentLevel.vNodes.length && stack.length) {
            currentLevel = stack.pop();
          }
        }
        return result;
      }
      function querySelectorAllFilter(domTree, selector, filter) {
        domTree = Array.isArray(domTree) ? domTree : [ domTree ];
        var expressions = Object(_matches__WEBPACK_IMPORTED_MODULE_0__['convertSelector'])(selector);
        return matchExpressions(domTree, expressions, filter);
      }
      __webpack_exports__['default'] = querySelectorAllFilter;
    },
    './lib/core/utils/query-selector-all.js': function libCoreUtilsQuerySelectorAllJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'querySelectorAll', function() {
        return querySelectorAll;
      });
      var _query_selector_all_filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/query-selector-all-filter.js');
      function querySelectorAll(domTree, selector) {
        return Object(_query_selector_all_filter__WEBPACK_IMPORTED_MODULE_0__['default'])(domTree, selector);
      }
      __webpack_exports__['default'] = querySelectorAll;
    },
    './lib/core/utils/queue.js': function libCoreUtilsQueueJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/log.js');
      function noop() {}
      function funcGuard(f) {
        if (typeof f !== 'function') {
          throw new TypeError('Queue methods require functions as arguments');
        }
      }
      function queue() {
        var tasks = [];
        var started = 0;
        var remaining = 0;
        var completeQueue = noop;
        var complete = false;
        var err;
        var defaultFail = function defaultFail(e) {
          err = e;
          setTimeout(function() {
            if (err !== undefined && err !== null) {
              Object(_log__WEBPACK_IMPORTED_MODULE_0__['default'])('Uncaught error (of queue)', err);
            }
          }, 1);
        };
        var failed = defaultFail;
        function createResolve(i) {
          return function(r) {
            tasks[i] = r;
            remaining -= 1;
            if (!remaining && completeQueue !== noop) {
              complete = true;
              completeQueue(tasks);
            }
          };
        }
        function abort(msg) {
          completeQueue = noop;
          failed(msg);
          return tasks;
        }
        function pop() {
          var length = tasks.length;
          for (;started < length; started++) {
            var task = tasks[started];
            try {
              task.call(null, createResolve(started), abort);
            } catch (e) {
              abort(e);
            }
          }
        }
        var q = {
          defer: function defer(fn) {
            if (_typeof(fn) === 'object' && fn.then && fn['catch']) {
              var defer = fn;
              fn = function fn(resolve, reject) {
                defer.then(resolve)['catch'](reject);
              };
            }
            funcGuard(fn);
            if (err !== undefined) {
              return;
            } else if (complete) {
              throw new Error('Queue already completed');
            }
            tasks.push(fn);
            ++remaining;
            pop();
            return q;
          },
          then: function then(fn) {
            funcGuard(fn);
            if (completeQueue !== noop) {
              throw new Error('queue `then` already set');
            }
            if (!err) {
              completeQueue = fn;
              if (!remaining) {
                complete = true;
                completeQueue(tasks);
              }
            }
            return q;
          },
          catch: function _catch(fn) {
            funcGuard(fn);
            if (failed !== defaultFail) {
              throw new Error('queue `catch` already set');
            }
            if (!err) {
              failed = fn;
            } else {
              fn(err);
              err = null;
            }
            return q;
          },
          abort: abort
        };
        return q;
      }
      __webpack_exports__['default'] = queue;
    },
    './lib/core/utils/respondable.js': function libCoreUtilsRespondableJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _uuid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/uuid.js');
      var _base_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/base/cache.js');
      var messages = {};
      var subscribers = {};
      var errorTypes = Object.freeze([ 'EvalError', 'RangeError', 'ReferenceError', 'SyntaxError', 'TypeError', 'URIError' ]);
      function _getSource() {
        var application = 'axeAPI', version = '', src;
        if (typeof axe !== 'undefined' && axe._audit && axe._audit.application) {
          application = axe._audit.application;
        }
        if (typeof axe !== 'undefined') {
          version = axe.version;
        }
        src = application + '.' + version;
        return src;
      }
      function verify(postedMessage) {
        if (_typeof(postedMessage) === 'object' && typeof postedMessage.uuid === 'string' && postedMessage._respondable === true) {
          var messageSource = _getSource();
          return postedMessage._source === messageSource || postedMessage._source === 'axeAPI.x.y.z' || messageSource === 'axeAPI.x.y.z';
        }
        return false;
      }
      function post(win, topic, message, uuid, keepalive, callback) {
        var error;
        if (message instanceof Error) {
          error = {
            name: message.name,
            message: message.message,
            stack: message.stack
          };
          message = undefined;
        }
        var data = {
          uuid: uuid,
          topic: topic,
          message: message,
          error: error,
          _respondable: true,
          _source: _getSource(),
          _axeuuid: axe._uuid,
          _keepalive: keepalive
        };
        var axeRespondables = _base_cache__WEBPACK_IMPORTED_MODULE_1__['default'].get('axeRespondables');
        if (!axeRespondables) {
          axeRespondables = {};
          _base_cache__WEBPACK_IMPORTED_MODULE_1__['default'].set('axeRespondables', axeRespondables);
        }
        axeRespondables[uuid] = true;
        if (typeof callback === 'function') {
          messages[uuid] = callback;
        }
        win.postMessage(JSON.stringify(data), '*');
      }
      function respondable(win, topic, message, keepalive, callback) {
        var id = Object(_uuid__WEBPACK_IMPORTED_MODULE_0__['v1'])();
        post(win, topic, message, id, keepalive, callback);
      }
      respondable.subscribe = function subscribe(topic, callback) {
        subscribers[topic] = callback;
      };
      respondable.isInFrame = function isInFrame(win) {
        win = win || window;
        return !!win.frameElement;
      };
      function createResponder(source, topic, uuid) {
        return function(message, keepalive, callback) {
          post(source, topic, message, uuid, keepalive, callback);
        };
      }
      function publish(source, data, keepalive) {
        var topic = data.topic;
        var subscriber = subscribers[topic];
        if (subscriber) {
          var responder = createResponder(source, null, data.uuid);
          subscriber(data.message, keepalive, responder);
        }
      }
      respondable._publish = publish;
      function buildErrorObject(error) {
        var msg = error.message || 'Unknown error occurred';
        var errorName = errorTypes.includes(error.name) ? error.name : 'Error';
        var ErrConstructor = window[errorName] || Error;
        if (error.stack) {
          msg += '\n' + error.stack.replace(error.message, '');
        }
        return new ErrConstructor(msg);
      }
      function parseMessage(dataString) {
        var data;
        if (typeof dataString !== 'string') {
          return;
        }
        try {
          data = JSON.parse(dataString);
        } catch (ex) {}
        if (!verify(data)) {
          return;
        }
        if (_typeof(data.error) === 'object') {
          data.error = buildErrorObject(data.error);
        } else {
          data.error = undefined;
        }
        return data;
      }
      if (typeof window.addEventListener === 'function') {
        window.addEventListener('message', function(e) {
          var data = parseMessage(e.data);
          if (!data || !data._axeuuid) {
            return;
          }
          var uuid = data.uuid;
          var axeRespondables = _base_cache__WEBPACK_IMPORTED_MODULE_1__['default'].get('axeRespondables') || {};
          if (axeRespondables[uuid] && data._axeuuid === axe._uuid) {
            return;
          }
          var keepalive = data._keepalive;
          var callback = messages[uuid];
          if (callback) {
            var result = data.error || data.message;
            var responder = createResponder(e.source, data.topic, uuid);
            callback(result, keepalive, responder);
            if (!keepalive) {
              delete messages[uuid];
            }
          }
          if (!data.error) {
            try {
              publish(e.source, data, keepalive);
            } catch (err) {
              post(e.source, null, err, uuid, false);
            }
          }
        }, false);
      }
      __webpack_exports__['default'] = respondable;
    },
    './lib/core/utils/rule-should-run.js': function libCoreUtilsRuleShouldRunJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function matchTags(rule, runOnly) {
        var include, exclude, matching;
        var defaultExclude = axe._audit && axe._audit.tagExclude ? axe._audit.tagExclude : [];
        if (runOnly.hasOwnProperty('include') || runOnly.hasOwnProperty('exclude')) {
          include = runOnly.include || [];
          include = Array.isArray(include) ? include : [ include ];
          exclude = runOnly.exclude || [];
          exclude = Array.isArray(exclude) ? exclude : [ exclude ];
          exclude = exclude.concat(defaultExclude.filter(function(tag) {
            return include.indexOf(tag) === -1;
          }));
        } else {
          include = Array.isArray(runOnly) ? runOnly : [ runOnly ];
          exclude = defaultExclude.filter(function(tag) {
            return include.indexOf(tag) === -1;
          });
        }
        matching = include.some(function(tag) {
          return rule.tags.indexOf(tag) !== -1;
        });
        if (matching || include.length === 0 && rule.enabled !== false) {
          return exclude.every(function(tag) {
            return rule.tags.indexOf(tag) === -1;
          });
        } else {
          return false;
        }
      }
      function ruleShouldRun(rule, context, options) {
        var runOnly = options.runOnly || {};
        var ruleOptions = (options.rules || {})[rule.id];
        if (rule.pageLevel && !context.page) {
          return false;
        } else if (runOnly.type === 'rule') {
          return runOnly.values.indexOf(rule.id) !== -1;
        } else if (ruleOptions && typeof ruleOptions.enabled === 'boolean') {
          return ruleOptions.enabled;
        } else if (runOnly.type === 'tag' && runOnly.values) {
          return matchTags(rule, runOnly.values);
        } else {
          return matchTags(rule, []);
        }
      }
      __webpack_exports__['default'] = ruleShouldRun;
    },
    './lib/core/utils/select.js': function libCoreUtilsSelectJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _contains__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/contains.js');
      var _query_selector_all_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/query-selector-all-filter.js');
      var _is_node_in_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/is-node-in-context.js');
      function pushNode(result, nodes) {
        var temp;
        if (result.length === 0) {
          return nodes;
        }
        if (result.length < nodes.length) {
          temp = result;
          result = nodes;
          nodes = temp;
        }
        for (var i = 0, l = nodes.length; i < l; i++) {
          if (!result.includes(nodes[i])) {
            result.push(nodes[i]);
          }
        }
        return result;
      }
      function reduceIncludes(includes) {
        return includes.reduce(function(res, el) {
          if (!res.length || !Object(_contains__WEBPACK_IMPORTED_MODULE_0__['default'])(res[res.length - 1], el)) {
            res.push(el);
          }
          return res;
        }, []);
      }
      function select(selector, context) {
        var result = [];
        var candidate;
        if (axe._selectCache) {
          for (var j = 0, l = axe._selectCache.length; j < l; j++) {
            var item = axe._selectCache[j];
            if (item.selector === selector) {
              return item.result;
            }
          }
        }
        var curried = function(context) {
          return function(node) {
            return Object(_is_node_in_context__WEBPACK_IMPORTED_MODULE_2__['default'])(node, context);
          };
        }(context);
        var reducedIncludes = reduceIncludes(context.include);
        for (var i = 0; i < reducedIncludes.length; i++) {
          candidate = reducedIncludes[i];
          result = pushNode(result, Object(_query_selector_all_filter__WEBPACK_IMPORTED_MODULE_1__['default'])(candidate, selector, curried));
        }
        if (axe._selectCache) {
          axe._selectCache.push({
            selector: selector,
            result: result
          });
        }
        return result;
      }
      __webpack_exports__['default'] = select;
    },
    './lib/core/utils/send-command-to-frame.js': function libCoreUtilsSendCommandToFrameJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _get_selector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/get-selector.js');
      var _respondable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/respondable.js');
      var _log__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/log.js');
      function err(message, node) {
        var selector;
        if (axe._tree) {
          selector = Object(_get_selector__WEBPACK_IMPORTED_MODULE_0__['default'])(node);
        }
        return new Error(message + ': ' + (selector || node));
      }
      function sendCommandToFrame(node, parameters, resolve, reject) {
        var win = node.contentWindow;
        if (!win) {
          Object(_log__WEBPACK_IMPORTED_MODULE_2__['default'])('Frame does not have a content window', node);
          resolve(null);
          return;
        }
        var timeout = setTimeout(function() {
          timeout = setTimeout(function() {
            if (!parameters.debug) {
              resolve(null);
            } else {
              reject(err('No response from frame', node));
            }
          }, 0);
        }, 500);
        Object(_respondable__WEBPACK_IMPORTED_MODULE_1__['default'])(win, 'axe.ping', null, undefined, function() {
          clearTimeout(timeout);
          var frameWaitTime = parameters.options && parameters.options.frameWaitTime || 6e4;
          timeout = setTimeout(function collectResultFramesTimeout() {
            reject(err('Axe in frame timed out', node));
          }, frameWaitTime);
          Object(_respondable__WEBPACK_IMPORTED_MODULE_1__['default'])(win, 'axe.start', parameters, undefined, function(data) {
            clearTimeout(timeout);
            if (data instanceof Error === false) {
              resolve(data);
            } else {
              reject(data);
            }
          });
        });
      }
      __webpack_exports__['default'] = sendCommandToFrame;
    },
    './lib/core/utils/set-scroll-state.js': function libCoreUtilsSetScrollStateJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'setScrollState', function() {
        return setScrollState;
      });
      function setScroll(elm, top, left) {
        if (elm === window) {
          return elm.scroll(left, top);
        } else {
          elm.scrollTop = top;
          elm.scrollLeft = left;
        }
      }
      function setScrollState(scrollState) {
        scrollState.forEach(function(_ref63) {
          var elm = _ref63.elm, top = _ref63.top, left = _ref63.left;
          return setScroll(elm, top, left);
        });
      }
      __webpack_exports__['default'] = setScrollState;
    },
    './lib/core/utils/to-array.js': function libCoreUtilsToArrayJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function toArray(thing) {
        return Array.prototype.slice.call(thing);
      }
      __webpack_exports__['default'] = toArray;
    },
    './lib/core/utils/token-list.js': function libCoreUtilsTokenListJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function tokenList(str) {
        return str.trim().replace(/\s{2,}/g, ' ').split(' ');
      }
      __webpack_exports__['default'] = tokenList;
    },
    './lib/core/utils/unique-array.js': function libCoreUtilsUniqueArrayJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function uniqueArray(arr1, arr2) {
        return arr1.concat(arr2).filter(function(elem, pos, arr) {
          return arr.indexOf(elem) === pos;
        });
      }
      __webpack_exports__['default'] = uniqueArray;
    },
    './lib/core/utils/uuid.js': function libCoreUtilsUuidJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'v1', function() {
        return v1;
      });
      __webpack_require__.d(__webpack_exports__, 'v4', function() {
        return v4;
      });
      __webpack_require__.d(__webpack_exports__, 'parse', function() {
        return parse;
      });
      __webpack_require__.d(__webpack_exports__, 'unparse', function() {
        return unparse;
      });
      __webpack_require__.d(__webpack_exports__, 'BufferClass', function() {
        return BufferClass;
      });
      var uuid;
      var _rng;
      var _crypto = window.crypto || window.msCrypto;
      if (!_rng && _crypto && _crypto.getRandomValues) {
        var _rnds8 = new Uint8Array(16);
        _rng = function whatwgRNG() {
          _crypto.getRandomValues(_rnds8);
          return _rnds8;
        };
      }
      if (!_rng) {
        var _rnds = new Array(16);
        _rng = function _rng() {
          for (var i = 0, r; i < 16; i++) {
            if ((i & 3) === 0) {
              r = Math.random() * 4294967296;
            }
            _rnds[i] = r >>> ((i & 3) << 3) & 255;
          }
          return _rnds;
        };
      }
      var BufferClass = typeof window.Buffer == 'function' ? window.Buffer : Array;
      var _byteToHex = [];
      var _hexToByte = {};
      for (var i = 0; i < 256; i++) {
        _byteToHex[i] = (i + 256).toString(16).substr(1);
        _hexToByte[_byteToHex[i]] = i;
      }
      function parse(s, buf, offset) {
        var i = buf && offset || 0, ii = 0;
        buf = buf || [];
        s.toLowerCase().replace(/[0-9a-f]{2}/g, function(oct) {
          if (ii < 16) {
            buf[i + ii++] = _hexToByte[oct];
          }
        });
        while (ii < 16) {
          buf[i + ii++] = 0;
        }
        return buf;
      }
      function unparse(buf, offset) {
        var i = offset || 0, bth = _byteToHex;
        return bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]];
      }
      var _seedBytes = _rng();
      var _nodeId = [ _seedBytes[0] | 1, _seedBytes[1], _seedBytes[2], _seedBytes[3], _seedBytes[4], _seedBytes[5] ];
      var _clockseq = (_seedBytes[6] << 8 | _seedBytes[7]) & 16383;
      var _lastMSecs = 0, _lastNSecs = 0;
      function v1(options, buf, offset) {
        var i = buf && offset || 0;
        var b = buf || [];
        options = options || {};
        var clockseq = options.clockseq != null ? options.clockseq : _clockseq;
        var msecs = options.msecs != null ? options.msecs : new Date().getTime();
        var nsecs = options.nsecs != null ? options.nsecs : _lastNSecs + 1;
        var dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 1e4;
        if (dt < 0 && options.clockseq == null) {
          clockseq = clockseq + 1 & 16383;
        }
        if ((dt < 0 || msecs > _lastMSecs) && options.nsecs == null) {
          nsecs = 0;
        }
        if (nsecs >= 1e4) {
          throw new Error('uuid.v1(): Can\'t create more than 10M uuids/sec');
        }
        _lastMSecs = msecs;
        _lastNSecs = nsecs;
        _clockseq = clockseq;
        msecs += 122192928e5;
        var tl = ((msecs & 268435455) * 1e4 + nsecs) % 4294967296;
        b[i++] = tl >>> 24 & 255;
        b[i++] = tl >>> 16 & 255;
        b[i++] = tl >>> 8 & 255;
        b[i++] = tl & 255;
        var tmh = msecs / 4294967296 * 1e4 & 268435455;
        b[i++] = tmh >>> 8 & 255;
        b[i++] = tmh & 255;
        b[i++] = tmh >>> 24 & 15 | 16;
        b[i++] = tmh >>> 16 & 255;
        b[i++] = clockseq >>> 8 | 128;
        b[i++] = clockseq & 255;
        var node = options.node || _nodeId;
        for (var n = 0; n < 6; n++) {
          b[i + n] = node[n];
        }
        return buf ? buf : unparse(b);
      }
      function v4(options, buf, offset) {
        var i = buf && offset || 0;
        if (typeof options == 'string') {
          buf = options == 'binary' ? new BufferClass(16) : null;
          options = null;
        }
        options = options || {};
        var rnds = options.random || (options.rng || _rng)();
        rnds[6] = rnds[6] & 15 | 64;
        rnds[8] = rnds[8] & 63 | 128;
        if (buf) {
          for (var ii = 0; ii < 16; ii++) {
            buf[i + ii] = rnds[ii];
          }
        }
        return buf || unparse(rnds);
      }
      uuid = v4;
      uuid.v1 = v1;
      uuid.v4 = v4;
      uuid.parse = parse;
      uuid.unparse = unparse;
      uuid.BufferClass = BufferClass;
      axe._uuid = v1();
      __webpack_exports__['default'] = v4;
    },
    './lib/core/utils/valid-input-type.js': function libCoreUtilsValidInputTypeJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function validInputTypes() {
        return [ 'hidden', 'text', 'search', 'tel', 'url', 'email', 'password', 'date', 'month', 'week', 'time', 'datetime-local', 'number', 'range', 'color', 'checkbox', 'radio', 'file', 'submit', 'image', 'reset', 'button' ];
      }
      __webpack_exports__['default'] = validInputTypes;
    },
    './lib/core/utils/valid-langs.js': function libCoreUtilsValidLangsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var langs = [ 'aa', 'ab', 'ae', 'af', 'ak', 'am', 'an', 'ar', 'as', 'av', 'ay', 'az', 'ba', 'be', 'bg', 'bh', 'bi', 'bm', 'bn', 'bo', 'br', 'bs', 'ca', 'ce', 'ch', 'co', 'cr', 'cs', 'cu', 'cv', 'cy', 'da', 'de', 'dv', 'dz', 'ee', 'el', 'en', 'eo', 'es', 'et', 'eu', 'fa', 'ff', 'fi', 'fj', 'fo', 'fr', 'fy', 'ga', 'gd', 'gl', 'gn', 'gu', 'gv', 'ha', 'he', 'hi', 'ho', 'hr', 'ht', 'hu', 'hy', 'hz', 'ia', 'id', 'ie', 'ig', 'ii', 'ik', 'in', 'io', 'is', 'it', 'iu', 'iw', 'ja', 'ji', 'jv', 'jw', 'ka', 'kg', 'ki', 'kj', 'kk', 'kl', 'km', 'kn', 'ko', 'kr', 'ks', 'ku', 'kv', 'kw', 'ky', 'la', 'lb', 'lg', 'li', 'ln', 'lo', 'lt', 'lu', 'lv', 'mg', 'mh', 'mi', 'mk', 'ml', 'mn', 'mo', 'mr', 'ms', 'mt', 'my', 'na', 'nb', 'nd', 'ne', 'ng', 'nl', 'nn', 'no', 'nr', 'nv', 'ny', 'oc', 'oj', 'om', 'or', 'os', 'pa', 'pi', 'pl', 'ps', 'pt', 'qu', 'rm', 'rn', 'ro', 'ru', 'rw', 'sa', 'sc', 'sd', 'se', 'sg', 'sh', 'si', 'sk', 'sl', 'sm', 'sn', 'so', 'sq', 'sr', 'ss', 'st', 'su', 'sv', 'sw', 'ta', 'te', 'tg', 'th', 'ti', 'tk', 'tl', 'tn', 'to', 'tr', 'ts', 'tt', 'tw', 'ty', 'ug', 'uk', 'ur', 'uz', 've', 'vi', 'vo', 'wa', 'wo', 'xh', 'yi', 'yo', 'za', 'zh', 'zu', 'aaa', 'aab', 'aac', 'aad', 'aae', 'aaf', 'aag', 'aah', 'aai', 'aak', 'aal', 'aam', 'aan', 'aao', 'aap', 'aaq', 'aas', 'aat', 'aau', 'aav', 'aaw', 'aax', 'aaz', 'aba', 'abb', 'abc', 'abd', 'abe', 'abf', 'abg', 'abh', 'abi', 'abj', 'abl', 'abm', 'abn', 'abo', 'abp', 'abq', 'abr', 'abs', 'abt', 'abu', 'abv', 'abw', 'abx', 'aby', 'abz', 'aca', 'acb', 'acd', 'ace', 'acf', 'ach', 'aci', 'ack', 'acl', 'acm', 'acn', 'acp', 'acq', 'acr', 'acs', 'act', 'acu', 'acv', 'acw', 'acx', 'acy', 'acz', 'ada', 'adb', 'add', 'ade', 'adf', 'adg', 'adh', 'adi', 'adj', 'adl', 'adn', 'ado', 'adp', 'adq', 'adr', 'ads', 'adt', 'adu', 'adw', 'adx', 'ady', 'adz', 'aea', 'aeb', 'aec', 'aed', 'aee', 'aek', 'ael', 'aem', 'aen', 'aeq', 'aer', 'aes', 'aeu', 'aew', 'aey', 'aez', 'afa', 'afb', 'afd', 'afe', 'afg', 'afh', 'afi', 'afk', 'afn', 'afo', 'afp', 'afs', 'aft', 'afu', 'afz', 'aga', 'agb', 'agc', 'agd', 'age', 'agf', 'agg', 'agh', 'agi', 'agj', 'agk', 'agl', 'agm', 'agn', 'ago', 'agp', 'agq', 'agr', 'ags', 'agt', 'agu', 'agv', 'agw', 'agx', 'agy', 'agz', 'aha', 'ahb', 'ahg', 'ahh', 'ahi', 'ahk', 'ahl', 'ahm', 'ahn', 'aho', 'ahp', 'ahr', 'ahs', 'aht', 'aia', 'aib', 'aic', 'aid', 'aie', 'aif', 'aig', 'aih', 'aii', 'aij', 'aik', 'ail', 'aim', 'ain', 'aio', 'aip', 'aiq', 'air', 'ais', 'ait', 'aiw', 'aix', 'aiy', 'aja', 'ajg', 'aji', 'ajn', 'ajp', 'ajt', 'aju', 'ajw', 'ajz', 'akb', 'akc', 'akd', 'ake', 'akf', 'akg', 'akh', 'aki', 'akj', 'akk', 'akl', 'akm', 'ako', 'akp', 'akq', 'akr', 'aks', 'akt', 'aku', 'akv', 'akw', 'akx', 'aky', 'akz', 'ala', 'alc', 'ald', 'ale', 'alf', 'alg', 'alh', 'ali', 'alj', 'alk', 'all', 'alm', 'aln', 'alo', 'alp', 'alq', 'alr', 'als', 'alt', 'alu', 'alv', 'alw', 'alx', 'aly', 'alz', 'ama', 'amb', 'amc', 'ame', 'amf', 'amg', 'ami', 'amj', 'amk', 'aml', 'amm', 'amn', 'amo', 'amp', 'amq', 'amr', 'ams', 'amt', 'amu', 'amv', 'amw', 'amx', 'amy', 'amz', 'ana', 'anb', 'anc', 'and', 'ane', 'anf', 'ang', 'anh', 'ani', 'anj', 'ank', 'anl', 'anm', 'ann', 'ano', 'anp', 'anq', 'anr', 'ans', 'ant', 'anu', 'anv', 'anw', 'anx', 'any', 'anz', 'aoa', 'aob', 'aoc', 'aod', 'aoe', 'aof', 'aog', 'aoh', 'aoi', 'aoj', 'aok', 'aol', 'aom', 'aon', 'aor', 'aos', 'aot', 'aou', 'aox', 'aoz', 'apa', 'apb', 'apc', 'apd', 'ape', 'apf', 'apg', 'aph', 'api', 'apj', 'apk', 'apl', 'apm', 'apn', 'apo', 'app', 'apq', 'apr', 'aps', 'apt', 'apu', 'apv', 'apw', 'apx', 'apy', 'apz', 'aqa', 'aqc', 'aqd', 'aqg', 'aql', 'aqm', 'aqn', 'aqp', 'aqr', 'aqt', 'aqz', 'arb', 'arc', 'ard', 'are', 'arh', 'ari', 'arj', 'ark', 'arl', 'arn', 'aro', 'arp', 'arq', 'arr', 'ars', 'art', 'aru', 'arv', 'arw', 'arx', 'ary', 'arz', 'asa', 'asb', 'asc', 'asd', 'ase', 'asf', 'asg', 'ash', 'asi', 'asj', 'ask', 'asl', 'asn', 'aso', 'asp', 'asq', 'asr', 'ass', 'ast', 'asu', 'asv', 'asw', 'asx', 'asy', 'asz', 'ata', 'atb', 'atc', 'atd', 'ate', 'atg', 'ath', 'ati', 'atj', 'atk', 'atl', 'atm', 'atn', 'ato', 'atp', 'atq', 'atr', 'ats', 'att', 'atu', 'atv', 'atw', 'atx', 'aty', 'atz', 'aua', 'aub', 'auc', 'aud', 'aue', 'auf', 'aug', 'auh', 'aui', 'auj', 'auk', 'aul', 'aum', 'aun', 'auo', 'aup', 'auq', 'aur', 'aus', 'aut', 'auu', 'auw', 'aux', 'auy', 'auz', 'avb', 'avd', 'avi', 'avk', 'avl', 'avm', 'avn', 'avo', 'avs', 'avt', 'avu', 'avv', 'awa', 'awb', 'awc', 'awd', 'awe', 'awg', 'awh', 'awi', 'awk', 'awm', 'awn', 'awo', 'awr', 'aws', 'awt', 'awu', 'awv', 'aww', 'awx', 'awy', 'axb', 'axe', 'axg', 'axk', 'axl', 'axm', 'axx', 'aya', 'ayb', 'ayc', 'ayd', 'aye', 'ayg', 'ayh', 'ayi', 'ayk', 'ayl', 'ayn', 'ayo', 'ayp', 'ayq', 'ayr', 'ays', 'ayt', 'ayu', 'ayx', 'ayy', 'ayz', 'aza', 'azb', 'azc', 'azd', 'azg', 'azj', 'azm', 'azn', 'azo', 'azt', 'azz', 'baa', 'bab', 'bac', 'bad', 'bae', 'baf', 'bag', 'bah', 'bai', 'baj', 'bal', 'ban', 'bao', 'bap', 'bar', 'bas', 'bat', 'bau', 'bav', 'baw', 'bax', 'bay', 'baz', 'bba', 'bbb', 'bbc', 'bbd', 'bbe', 'bbf', 'bbg', 'bbh', 'bbi', 'bbj', 'bbk', 'bbl', 'bbm', 'bbn', 'bbo', 'bbp', 'bbq', 'bbr', 'bbs', 'bbt', 'bbu', 'bbv', 'bbw', 'bbx', 'bby', 'bbz', 'bca', 'bcb', 'bcc', 'bcd', 'bce', 'bcf', 'bcg', 'bch', 'bci', 'bcj', 'bck', 'bcl', 'bcm', 'bcn', 'bco', 'bcp', 'bcq', 'bcr', 'bcs', 'bct', 'bcu', 'bcv', 'bcw', 'bcy', 'bcz', 'bda', 'bdb', 'bdc', 'bdd', 'bde', 'bdf', 'bdg', 'bdh', 'bdi', 'bdj', 'bdk', 'bdl', 'bdm', 'bdn', 'bdo', 'bdp', 'bdq', 'bdr', 'bds', 'bdt', 'bdu', 'bdv', 'bdw', 'bdx', 'bdy', 'bdz', 'bea', 'beb', 'bec', 'bed', 'bee', 'bef', 'beg', 'beh', 'bei', 'bej', 'bek', 'bem', 'beo', 'bep', 'beq', 'ber', 'bes', 'bet', 'beu', 'bev', 'bew', 'bex', 'bey', 'bez', 'bfa', 'bfb', 'bfc', 'bfd', 'bfe', 'bff', 'bfg', 'bfh', 'bfi', 'bfj', 'bfk', 'bfl', 'bfm', 'bfn', 'bfo', 'bfp', 'bfq', 'bfr', 'bfs', 'bft', 'bfu', 'bfw', 'bfx', 'bfy', 'bfz', 'bga', 'bgb', 'bgc', 'bgd', 'bge', 'bgf', 'bgg', 'bgi', 'bgj', 'bgk', 'bgl', 'bgm', 'bgn', 'bgo', 'bgp', 'bgq', 'bgr', 'bgs', 'bgt', 'bgu', 'bgv', 'bgw', 'bgx', 'bgy', 'bgz', 'bha', 'bhb', 'bhc', 'bhd', 'bhe', 'bhf', 'bhg', 'bhh', 'bhi', 'bhj', 'bhk', 'bhl', 'bhm', 'bhn', 'bho', 'bhp', 'bhq', 'bhr', 'bhs', 'bht', 'bhu', 'bhv', 'bhw', 'bhx', 'bhy', 'bhz', 'bia', 'bib', 'bic', 'bid', 'bie', 'bif', 'big', 'bij', 'bik', 'bil', 'bim', 'bin', 'bio', 'bip', 'biq', 'bir', 'bit', 'biu', 'biv', 'biw', 'bix', 'biy', 'biz', 'bja', 'bjb', 'bjc', 'bjd', 'bje', 'bjf', 'bjg', 'bjh', 'bji', 'bjj', 'bjk', 'bjl', 'bjm', 'bjn', 'bjo', 'bjp', 'bjq', 'bjr', 'bjs', 'bjt', 'bju', 'bjv', 'bjw', 'bjx', 'bjy', 'bjz', 'bka', 'bkb', 'bkc', 'bkd', 'bkf', 'bkg', 'bkh', 'bki', 'bkj', 'bkk', 'bkl', 'bkm', 'bkn', 'bko', 'bkp', 'bkq', 'bkr', 'bks', 'bkt', 'bku', 'bkv', 'bkw', 'bkx', 'bky', 'bkz', 'bla', 'blb', 'blc', 'bld', 'ble', 'blf', 'blg', 'blh', 'bli', 'blj', 'blk', 'bll', 'blm', 'bln', 'blo', 'blp', 'blq', 'blr', 'bls', 'blt', 'blv', 'blw', 'blx', 'bly', 'blz', 'bma', 'bmb', 'bmc', 'bmd', 'bme', 'bmf', 'bmg', 'bmh', 'bmi', 'bmj', 'bmk', 'bml', 'bmm', 'bmn', 'bmo', 'bmp', 'bmq', 'bmr', 'bms', 'bmt', 'bmu', 'bmv', 'bmw', 'bmx', 'bmy', 'bmz', 'bna', 'bnb', 'bnc', 'bnd', 'bne', 'bnf', 'bng', 'bni', 'bnj', 'bnk', 'bnl', 'bnm', 'bnn', 'bno', 'bnp', 'bnq', 'bnr', 'bns', 'bnt', 'bnu', 'bnv', 'bnw', 'bnx', 'bny', 'bnz', 'boa', 'bob', 'boe', 'bof', 'bog', 'boh', 'boi', 'boj', 'bok', 'bol', 'bom', 'bon', 'boo', 'bop', 'boq', 'bor', 'bot', 'bou', 'bov', 'bow', 'box', 'boy', 'boz', 'bpa', 'bpb', 'bpd', 'bpg', 'bph', 'bpi', 'bpj', 'bpk', 'bpl', 'bpm', 'bpn', 'bpo', 'bpp', 'bpq', 'bpr', 'bps', 'bpt', 'bpu', 'bpv', 'bpw', 'bpx', 'bpy', 'bpz', 'bqa', 'bqb', 'bqc', 'bqd', 'bqf', 'bqg', 'bqh', 'bqi', 'bqj', 'bqk', 'bql', 'bqm', 'bqn', 'bqo', 'bqp', 'bqq', 'bqr', 'bqs', 'bqt', 'bqu', 'bqv', 'bqw', 'bqx', 'bqy', 'bqz', 'bra', 'brb', 'brc', 'brd', 'brf', 'brg', 'brh', 'bri', 'brj', 'brk', 'brl', 'brm', 'brn', 'bro', 'brp', 'brq', 'brr', 'brs', 'brt', 'bru', 'brv', 'brw', 'brx', 'bry', 'brz', 'bsa', 'bsb', 'bsc', 'bse', 'bsf', 'bsg', 'bsh', 'bsi', 'bsj', 'bsk', 'bsl', 'bsm', 'bsn', 'bso', 'bsp', 'bsq', 'bsr', 'bss', 'bst', 'bsu', 'bsv', 'bsw', 'bsx', 'bsy', 'bta', 'btb', 'btc', 'btd', 'bte', 'btf', 'btg', 'bth', 'bti', 'btj', 'btk', 'btl', 'btm', 'btn', 'bto', 'btp', 'btq', 'btr', 'bts', 'btt', 'btu', 'btv', 'btw', 'btx', 'bty', 'btz', 'bua', 'bub', 'buc', 'bud', 'bue', 'buf', 'bug', 'buh', 'bui', 'buj', 'buk', 'bum', 'bun', 'buo', 'bup', 'buq', 'bus', 'but', 'buu', 'buv', 'buw', 'bux', 'buy', 'buz', 'bva', 'bvb', 'bvc', 'bvd', 'bve', 'bvf', 'bvg', 'bvh', 'bvi', 'bvj', 'bvk', 'bvl', 'bvm', 'bvn', 'bvo', 'bvp', 'bvq', 'bvr', 'bvt', 'bvu', 'bvv', 'bvw', 'bvx', 'bvy', 'bvz', 'bwa', 'bwb', 'bwc', 'bwd', 'bwe', 'bwf', 'bwg', 'bwh', 'bwi', 'bwj', 'bwk', 'bwl', 'bwm', 'bwn', 'bwo', 'bwp', 'bwq', 'bwr', 'bws', 'bwt', 'bwu', 'bww', 'bwx', 'bwy', 'bwz', 'bxa', 'bxb', 'bxc', 'bxd', 'bxe', 'bxf', 'bxg', 'bxh', 'bxi', 'bxj', 'bxk', 'bxl', 'bxm', 'bxn', 'bxo', 'bxp', 'bxq', 'bxr', 'bxs', 'bxu', 'bxv', 'bxw', 'bxx', 'bxz', 'bya', 'byb', 'byc', 'byd', 'bye', 'byf', 'byg', 'byh', 'byi', 'byj', 'byk', 'byl', 'bym', 'byn', 'byo', 'byp', 'byq', 'byr', 'bys', 'byt', 'byv', 'byw', 'byx', 'byy', 'byz', 'bza', 'bzb', 'bzc', 'bzd', 'bze', 'bzf', 'bzg', 'bzh', 'bzi', 'bzj', 'bzk', 'bzl', 'bzm', 'bzn', 'bzo', 'bzp', 'bzq', 'bzr', 'bzs', 'bzt', 'bzu', 'bzv', 'bzw', 'bzx', 'bzy', 'bzz', 'caa', 'cab', 'cac', 'cad', 'cae', 'caf', 'cag', 'cah', 'cai', 'caj', 'cak', 'cal', 'cam', 'can', 'cao', 'cap', 'caq', 'car', 'cas', 'cau', 'cav', 'caw', 'cax', 'cay', 'caz', 'cba', 'cbb', 'cbc', 'cbd', 'cbe', 'cbg', 'cbh', 'cbi', 'cbj', 'cbk', 'cbl', 'cbn', 'cbo', 'cbq', 'cbr', 'cbs', 'cbt', 'cbu', 'cbv', 'cbw', 'cby', 'cca', 'ccc', 'ccd', 'cce', 'ccg', 'cch', 'ccj', 'ccl', 'ccm', 'ccn', 'cco', 'ccp', 'ccq', 'ccr', 'ccs', 'cda', 'cdc', 'cdd', 'cde', 'cdf', 'cdg', 'cdh', 'cdi', 'cdj', 'cdm', 'cdn', 'cdo', 'cdr', 'cds', 'cdy', 'cdz', 'cea', 'ceb', 'ceg', 'cek', 'cel', 'cen', 'cet', 'cfa', 'cfd', 'cfg', 'cfm', 'cga', 'cgc', 'cgg', 'cgk', 'chb', 'chc', 'chd', 'chf', 'chg', 'chh', 'chj', 'chk', 'chl', 'chm', 'chn', 'cho', 'chp', 'chq', 'chr', 'cht', 'chw', 'chx', 'chy', 'chz', 'cia', 'cib', 'cic', 'cid', 'cie', 'cih', 'cik', 'cim', 'cin', 'cip', 'cir', 'ciw', 'ciy', 'cja', 'cje', 'cjh', 'cji', 'cjk', 'cjm', 'cjn', 'cjo', 'cjp', 'cjr', 'cjs', 'cjv', 'cjy', 'cka', 'ckb', 'ckh', 'ckl', 'ckn', 'cko', 'ckq', 'ckr', 'cks', 'ckt', 'cku', 'ckv', 'ckx', 'cky', 'ckz', 'cla', 'clc', 'cld', 'cle', 'clh', 'cli', 'clj', 'clk', 'cll', 'clm', 'clo', 'clt', 'clu', 'clw', 'cly', 'cma', 'cmc', 'cme', 'cmg', 'cmi', 'cmk', 'cml', 'cmm', 'cmn', 'cmo', 'cmr', 'cms', 'cmt', 'cna', 'cnb', 'cnc', 'cng', 'cnh', 'cni', 'cnk', 'cnl', 'cno', 'cnr', 'cns', 'cnt', 'cnu', 'cnw', 'cnx', 'coa', 'cob', 'coc', 'cod', 'coe', 'cof', 'cog', 'coh', 'coj', 'cok', 'col', 'com', 'con', 'coo', 'cop', 'coq', 'cot', 'cou', 'cov', 'cow', 'cox', 'coy', 'coz', 'cpa', 'cpb', 'cpc', 'cpe', 'cpf', 'cpg', 'cpi', 'cpn', 'cpo', 'cpp', 'cps', 'cpu', 'cpx', 'cpy', 'cqd', 'cqu', 'cra', 'crb', 'crc', 'crd', 'crf', 'crg', 'crh', 'cri', 'crj', 'crk', 'crl', 'crm', 'crn', 'cro', 'crp', 'crq', 'crr', 'crs', 'crt', 'crv', 'crw', 'crx', 'cry', 'crz', 'csa', 'csb', 'csc', 'csd', 'cse', 'csf', 'csg', 'csh', 'csi', 'csj', 'csk', 'csl', 'csm', 'csn', 'cso', 'csq', 'csr', 'css', 'cst', 'csu', 'csv', 'csw', 'csy', 'csz', 'cta', 'ctc', 'ctd', 'cte', 'ctg', 'cth', 'ctl', 'ctm', 'ctn', 'cto', 'ctp', 'cts', 'ctt', 'ctu', 'ctz', 'cua', 'cub', 'cuc', 'cug', 'cuh', 'cui', 'cuj', 'cuk', 'cul', 'cum', 'cuo', 'cup', 'cuq', 'cur', 'cus', 'cut', 'cuu', 'cuv', 'cuw', 'cux', 'cuy', 'cvg', 'cvn', 'cwa', 'cwb', 'cwd', 'cwe', 'cwg', 'cwt', 'cya', 'cyb', 'cyo', 'czh', 'czk', 'czn', 'czo', 'czt', 'daa', 'dac', 'dad', 'dae', 'daf', 'dag', 'dah', 'dai', 'daj', 'dak', 'dal', 'dam', 'dao', 'dap', 'daq', 'dar', 'das', 'dau', 'dav', 'daw', 'dax', 'day', 'daz', 'dba', 'dbb', 'dbd', 'dbe', 'dbf', 'dbg', 'dbi', 'dbj', 'dbl', 'dbm', 'dbn', 'dbo', 'dbp', 'dbq', 'dbr', 'dbt', 'dbu', 'dbv', 'dbw', 'dby', 'dcc', 'dcr', 'dda', 'ddd', 'dde', 'ddg', 'ddi', 'ddj', 'ddn', 'ddo', 'ddr', 'dds', 'ddw', 'dec', 'ded', 'dee', 'def', 'deg', 'deh', 'dei', 'dek', 'del', 'dem', 'den', 'dep', 'deq', 'der', 'des', 'dev', 'dez', 'dga', 'dgb', 'dgc', 'dgd', 'dge', 'dgg', 'dgh', 'dgi', 'dgk', 'dgl', 'dgn', 'dgo', 'dgr', 'dgs', 'dgt', 'dgu', 'dgw', 'dgx', 'dgz', 'dha', 'dhd', 'dhg', 'dhi', 'dhl', 'dhm', 'dhn', 'dho', 'dhr', 'dhs', 'dhu', 'dhv', 'dhw', 'dhx', 'dia', 'dib', 'dic', 'did', 'dif', 'dig', 'dih', 'dii', 'dij', 'dik', 'dil', 'dim', 'din', 'dio', 'dip', 'diq', 'dir', 'dis', 'dit', 'diu', 'diw', 'dix', 'diy', 'diz', 'dja', 'djb', 'djc', 'djd', 'dje', 'djf', 'dji', 'djj', 'djk', 'djl', 'djm', 'djn', 'djo', 'djr', 'dju', 'djw', 'dka', 'dkk', 'dkl', 'dkr', 'dks', 'dkx', 'dlg', 'dlk', 'dlm', 'dln', 'dma', 'dmb', 'dmc', 'dmd', 'dme', 'dmg', 'dmk', 'dml', 'dmm', 'dmn', 'dmo', 'dmr', 'dms', 'dmu', 'dmv', 'dmw', 'dmx', 'dmy', 'dna', 'dnd', 'dne', 'dng', 'dni', 'dnj', 'dnk', 'dnn', 'dnr', 'dnt', 'dnu', 'dnv', 'dnw', 'dny', 'doa', 'dob', 'doc', 'doe', 'dof', 'doh', 'doi', 'dok', 'dol', 'don', 'doo', 'dop', 'doq', 'dor', 'dos', 'dot', 'dov', 'dow', 'dox', 'doy', 'doz', 'dpp', 'dra', 'drb', 'drc', 'drd', 'dre', 'drg', 'drh', 'dri', 'drl', 'drn', 'dro', 'drq', 'drr', 'drs', 'drt', 'dru', 'drw', 'dry', 'dsb', 'dse', 'dsh', 'dsi', 'dsl', 'dsn', 'dso', 'dsq', 'dta', 'dtb', 'dtd', 'dth', 'dti', 'dtk', 'dtm', 'dtn', 'dto', 'dtp', 'dtr', 'dts', 'dtt', 'dtu', 'dty', 'dua', 'dub', 'duc', 'dud', 'due', 'duf', 'dug', 'duh', 'dui', 'duj', 'duk', 'dul', 'dum', 'dun', 'duo', 'dup', 'duq', 'dur', 'dus', 'duu', 'duv', 'duw', 'dux', 'duy', 'duz', 'dva', 'dwa', 'dwl', 'dwr', 'dws', 'dwu', 'dww', 'dwy', 'dya', 'dyb', 'dyd', 'dyg', 'dyi', 'dym', 'dyn', 'dyo', 'dyu', 'dyy', 'dza', 'dzd', 'dze', 'dzg', 'dzl', 'dzn', 'eaa', 'ebg', 'ebk', 'ebo', 'ebr', 'ebu', 'ecr', 'ecs', 'ecy', 'eee', 'efa', 'efe', 'efi', 'ega', 'egl', 'ego', 'egx', 'egy', 'ehu', 'eip', 'eit', 'eiv', 'eja', 'eka', 'ekc', 'eke', 'ekg', 'eki', 'ekk', 'ekl', 'ekm', 'eko', 'ekp', 'ekr', 'eky', 'ele', 'elh', 'eli', 'elk', 'elm', 'elo', 'elp', 'elu', 'elx', 'ema', 'emb', 'eme', 'emg', 'emi', 'emk', 'emm', 'emn', 'emo', 'emp', 'ems', 'emu', 'emw', 'emx', 'emy', 'ena', 'enb', 'enc', 'end', 'enf', 'enh', 'enl', 'enm', 'enn', 'eno', 'enq', 'enr', 'enu', 'env', 'enw', 'enx', 'eot', 'epi', 'era', 'erg', 'erh', 'eri', 'erk', 'ero', 'err', 'ers', 'ert', 'erw', 'ese', 'esg', 'esh', 'esi', 'esk', 'esl', 'esm', 'esn', 'eso', 'esq', 'ess', 'esu', 'esx', 'esy', 'etb', 'etc', 'eth', 'etn', 'eto', 'etr', 'ets', 'ett', 'etu', 'etx', 'etz', 'euq', 'eve', 'evh', 'evn', 'ewo', 'ext', 'eya', 'eyo', 'eza', 'eze', 'faa', 'fab', 'fad', 'faf', 'fag', 'fah', 'fai', 'faj', 'fak', 'fal', 'fam', 'fan', 'fap', 'far', 'fat', 'fau', 'fax', 'fay', 'faz', 'fbl', 'fcs', 'fer', 'ffi', 'ffm', 'fgr', 'fia', 'fie', 'fil', 'fip', 'fir', 'fit', 'fiu', 'fiw', 'fkk', 'fkv', 'fla', 'flh', 'fli', 'fll', 'fln', 'flr', 'fly', 'fmp', 'fmu', 'fnb', 'fng', 'fni', 'fod', 'foi', 'fom', 'fon', 'for', 'fos', 'fox', 'fpe', 'fqs', 'frc', 'frd', 'frk', 'frm', 'fro', 'frp', 'frq', 'frr', 'frs', 'frt', 'fse', 'fsl', 'fss', 'fub', 'fuc', 'fud', 'fue', 'fuf', 'fuh', 'fui', 'fuj', 'fum', 'fun', 'fuq', 'fur', 'fut', 'fuu', 'fuv', 'fuy', 'fvr', 'fwa', 'fwe', 'gaa', 'gab', 'gac', 'gad', 'gae', 'gaf', 'gag', 'gah', 'gai', 'gaj', 'gak', 'gal', 'gam', 'gan', 'gao', 'gap', 'gaq', 'gar', 'gas', 'gat', 'gau', 'gav', 'gaw', 'gax', 'gay', 'gaz', 'gba', 'gbb', 'gbc', 'gbd', 'gbe', 'gbf', 'gbg', 'gbh', 'gbi', 'gbj', 'gbk', 'gbl', 'gbm', 'gbn', 'gbo', 'gbp', 'gbq', 'gbr', 'gbs', 'gbu', 'gbv', 'gbw', 'gbx', 'gby', 'gbz', 'gcc', 'gcd', 'gce', 'gcf', 'gcl', 'gcn', 'gcr', 'gct', 'gda', 'gdb', 'gdc', 'gdd', 'gde', 'gdf', 'gdg', 'gdh', 'gdi', 'gdj', 'gdk', 'gdl', 'gdm', 'gdn', 'gdo', 'gdq', 'gdr', 'gds', 'gdt', 'gdu', 'gdx', 'gea', 'geb', 'gec', 'ged', 'geg', 'geh', 'gei', 'gej', 'gek', 'gel', 'gem', 'geq', 'ges', 'gev', 'gew', 'gex', 'gey', 'gez', 'gfk', 'gft', 'gfx', 'gga', 'ggb', 'ggd', 'gge', 'ggg', 'ggk', 'ggl', 'ggn', 'ggo', 'ggr', 'ggt', 'ggu', 'ggw', 'gha', 'ghc', 'ghe', 'ghh', 'ghk', 'ghl', 'ghn', 'gho', 'ghr', 'ghs', 'ght', 'gia', 'gib', 'gic', 'gid', 'gie', 'gig', 'gih', 'gil', 'gim', 'gin', 'gio', 'gip', 'giq', 'gir', 'gis', 'git', 'giu', 'giw', 'gix', 'giy', 'giz', 'gji', 'gjk', 'gjm', 'gjn', 'gjr', 'gju', 'gka', 'gkd', 'gke', 'gkn', 'gko', 'gkp', 'gku', 'glc', 'gld', 'glh', 'gli', 'glj', 'glk', 'gll', 'glo', 'glr', 'glu', 'glw', 'gly', 'gma', 'gmb', 'gmd', 'gme', 'gmg', 'gmh', 'gml', 'gmm', 'gmn', 'gmq', 'gmu', 'gmv', 'gmw', 'gmx', 'gmy', 'gmz', 'gna', 'gnb', 'gnc', 'gnd', 'gne', 'gng', 'gnh', 'gni', 'gnj', 'gnk', 'gnl', 'gnm', 'gnn', 'gno', 'gnq', 'gnr', 'gnt', 'gnu', 'gnw', 'gnz', 'goa', 'gob', 'goc', 'god', 'goe', 'gof', 'gog', 'goh', 'goi', 'goj', 'gok', 'gol', 'gom', 'gon', 'goo', 'gop', 'goq', 'gor', 'gos', 'got', 'gou', 'gow', 'gox', 'goy', 'goz', 'gpa', 'gpe', 'gpn', 'gqa', 'gqi', 'gqn', 'gqr', 'gqu', 'gra', 'grb', 'grc', 'grd', 'grg', 'grh', 'gri', 'grj', 'grk', 'grm', 'gro', 'grq', 'grr', 'grs', 'grt', 'gru', 'grv', 'grw', 'grx', 'gry', 'grz', 'gse', 'gsg', 'gsl', 'gsm', 'gsn', 'gso', 'gsp', 'gss', 'gsw', 'gta', 'gti', 'gtu', 'gua', 'gub', 'guc', 'gud', 'gue', 'guf', 'gug', 'guh', 'gui', 'guk', 'gul', 'gum', 'gun', 'guo', 'gup', 'guq', 'gur', 'gus', 'gut', 'guu', 'guv', 'guw', 'gux', 'guz', 'gva', 'gvc', 'gve', 'gvf', 'gvj', 'gvl', 'gvm', 'gvn', 'gvo', 'gvp', 'gvr', 'gvs', 'gvy', 'gwa', 'gwb', 'gwc', 'gwd', 'gwe', 'gwf', 'gwg', 'gwi', 'gwj', 'gwm', 'gwn', 'gwr', 'gwt', 'gwu', 'gww', 'gwx', 'gxx', 'gya', 'gyb', 'gyd', 'gye', 'gyf', 'gyg', 'gyi', 'gyl', 'gym', 'gyn', 'gyo', 'gyr', 'gyy', 'gza', 'gzi', 'gzn', 'haa', 'hab', 'hac', 'had', 'hae', 'haf', 'hag', 'hah', 'hai', 'haj', 'hak', 'hal', 'ham', 'han', 'hao', 'hap', 'haq', 'har', 'has', 'hav', 'haw', 'hax', 'hay', 'haz', 'hba', 'hbb', 'hbn', 'hbo', 'hbu', 'hca', 'hch', 'hdn', 'hds', 'hdy', 'hea', 'hed', 'heg', 'heh', 'hei', 'hem', 'hgm', 'hgw', 'hhi', 'hhr', 'hhy', 'hia', 'hib', 'hid', 'hif', 'hig', 'hih', 'hii', 'hij', 'hik', 'hil', 'him', 'hio', 'hir', 'hit', 'hiw', 'hix', 'hji', 'hka', 'hke', 'hkk', 'hkn', 'hks', 'hla', 'hlb', 'hld', 'hle', 'hlt', 'hlu', 'hma', 'hmb', 'hmc', 'hmd', 'hme', 'hmf', 'hmg', 'hmh', 'hmi', 'hmj', 'hmk', 'hml', 'hmm', 'hmn', 'hmp', 'hmq', 'hmr', 'hms', 'hmt', 'hmu', 'hmv', 'hmw', 'hmx', 'hmy', 'hmz', 'hna', 'hnd', 'hne', 'hnh', 'hni', 'hnj', 'hnn', 'hno', 'hns', 'hnu', 'hoa', 'hob', 'hoc', 'hod', 'hoe', 'hoh', 'hoi', 'hoj', 'hok', 'hol', 'hom', 'hoo', 'hop', 'hor', 'hos', 'hot', 'hov', 'how', 'hoy', 'hoz', 'hpo', 'hps', 'hra', 'hrc', 'hre', 'hrk', 'hrm', 'hro', 'hrp', 'hrr', 'hrt', 'hru', 'hrw', 'hrx', 'hrz', 'hsb', 'hsh', 'hsl', 'hsn', 'hss', 'hti', 'hto', 'hts', 'htu', 'htx', 'hub', 'huc', 'hud', 'hue', 'huf', 'hug', 'huh', 'hui', 'huj', 'huk', 'hul', 'hum', 'huo', 'hup', 'huq', 'hur', 'hus', 'hut', 'huu', 'huv', 'huw', 'hux', 'huy', 'huz', 'hvc', 'hve', 'hvk', 'hvn', 'hvv', 'hwa', 'hwc', 'hwo', 'hya', 'hyw', 'hyx', 'iai', 'ian', 'iap', 'iar', 'iba', 'ibb', 'ibd', 'ibe', 'ibg', 'ibh', 'ibi', 'ibl', 'ibm', 'ibn', 'ibr', 'ibu', 'iby', 'ica', 'ich', 'icl', 'icr', 'ida', 'idb', 'idc', 'idd', 'ide', 'idi', 'idr', 'ids', 'idt', 'idu', 'ifa', 'ifb', 'ife', 'iff', 'ifk', 'ifm', 'ifu', 'ify', 'igb', 'ige', 'igg', 'igl', 'igm', 'ign', 'igo', 'igs', 'igw', 'ihb', 'ihi', 'ihp', 'ihw', 'iin', 'iir', 'ijc', 'ije', 'ijj', 'ijn', 'ijo', 'ijs', 'ike', 'iki', 'ikk', 'ikl', 'iko', 'ikp', 'ikr', 'iks', 'ikt', 'ikv', 'ikw', 'ikx', 'ikz', 'ila', 'ilb', 'ilg', 'ili', 'ilk', 'ill', 'ilm', 'ilo', 'ilp', 'ils', 'ilu', 'ilv', 'ilw', 'ima', 'ime', 'imi', 'iml', 'imn', 'imo', 'imr', 'ims', 'imy', 'inb', 'inc', 'ine', 'ing', 'inh', 'inj', 'inl', 'inm', 'inn', 'ino', 'inp', 'ins', 'int', 'inz', 'ior', 'iou', 'iow', 'ipi', 'ipo', 'iqu', 'iqw', 'ira', 'ire', 'irh', 'iri', 'irk', 'irn', 'iro', 'irr', 'iru', 'irx', 'iry', 'isa', 'isc', 'isd', 'ise', 'isg', 'ish', 'isi', 'isk', 'ism', 'isn', 'iso', 'isr', 'ist', 'isu', 'itb', 'itc', 'itd', 'ite', 'iti', 'itk', 'itl', 'itm', 'ito', 'itr', 'its', 'itt', 'itv', 'itw', 'itx', 'ity', 'itz', 'ium', 'ivb', 'ivv', 'iwk', 'iwm', 'iwo', 'iws', 'ixc', 'ixl', 'iya', 'iyo', 'iyx', 'izh', 'izi', 'izr', 'izz', 'jaa', 'jab', 'jac', 'jad', 'jae', 'jaf', 'jah', 'jaj', 'jak', 'jal', 'jam', 'jan', 'jao', 'jaq', 'jar', 'jas', 'jat', 'jau', 'jax', 'jay', 'jaz', 'jbe', 'jbi', 'jbj', 'jbk', 'jbn', 'jbo', 'jbr', 'jbt', 'jbu', 'jbw', 'jcs', 'jct', 'jda', 'jdg', 'jdt', 'jeb', 'jee', 'jeg', 'jeh', 'jei', 'jek', 'jel', 'jen', 'jer', 'jet', 'jeu', 'jgb', 'jge', 'jgk', 'jgo', 'jhi', 'jhs', 'jia', 'jib', 'jic', 'jid', 'jie', 'jig', 'jih', 'jii', 'jil', 'jim', 'jio', 'jiq', 'jit', 'jiu', 'jiv', 'jiy', 'jje', 'jjr', 'jka', 'jkm', 'jko', 'jkp', 'jkr', 'jku', 'jle', 'jls', 'jma', 'jmb', 'jmc', 'jmd', 'jmi', 'jml', 'jmn', 'jmr', 'jms', 'jmw', 'jmx', 'jna', 'jnd', 'jng', 'jni', 'jnj', 'jnl', 'jns', 'job', 'jod', 'jog', 'jor', 'jos', 'jow', 'jpa', 'jpr', 'jpx', 'jqr', 'jra', 'jrb', 'jrr', 'jrt', 'jru', 'jsl', 'jua', 'jub', 'juc', 'jud', 'juh', 'jui', 'juk', 'jul', 'jum', 'jun', 'juo', 'jup', 'jur', 'jus', 'jut', 'juu', 'juw', 'juy', 'jvd', 'jvn', 'jwi', 'jya', 'jye', 'jyy', 'kaa', 'kab', 'kac', 'kad', 'kae', 'kaf', 'kag', 'kah', 'kai', 'kaj', 'kak', 'kam', 'kao', 'kap', 'kaq', 'kar', 'kav', 'kaw', 'kax', 'kay', 'kba', 'kbb', 'kbc', 'kbd', 'kbe', 'kbf', 'kbg', 'kbh', 'kbi', 'kbj', 'kbk', 'kbl', 'kbm', 'kbn', 'kbo', 'kbp', 'kbq', 'kbr', 'kbs', 'kbt', 'kbu', 'kbv', 'kbw', 'kbx', 'kby', 'kbz', 'kca', 'kcb', 'kcc', 'kcd', 'kce', 'kcf', 'kcg', 'kch', 'kci', 'kcj', 'kck', 'kcl', 'kcm', 'kcn', 'kco', 'kcp', 'kcq', 'kcr', 'kcs', 'kct', 'kcu', 'kcv', 'kcw', 'kcx', 'kcy', 'kcz', 'kda', 'kdc', 'kdd', 'kde', 'kdf', 'kdg', 'kdh', 'kdi', 'kdj', 'kdk', 'kdl', 'kdm', 'kdn', 'kdo', 'kdp', 'kdq', 'kdr', 'kdt', 'kdu', 'kdv', 'kdw', 'kdx', 'kdy', 'kdz', 'kea', 'keb', 'kec', 'ked', 'kee', 'kef', 'keg', 'keh', 'kei', 'kej', 'kek', 'kel', 'kem', 'ken', 'keo', 'kep', 'keq', 'ker', 'kes', 'ket', 'keu', 'kev', 'kew', 'kex', 'key', 'kez', 'kfa', 'kfb', 'kfc', 'kfd', 'kfe', 'kff', 'kfg', 'kfh', 'kfi', 'kfj', 'kfk', 'kfl', 'kfm', 'kfn', 'kfo', 'kfp', 'kfq', 'kfr', 'kfs', 'kft', 'kfu', 'kfv', 'kfw', 'kfx', 'kfy', 'kfz', 'kga', 'kgb', 'kgc', 'kgd', 'kge', 'kgf', 'kgg', 'kgh', 'kgi', 'kgj', 'kgk', 'kgl', 'kgm', 'kgn', 'kgo', 'kgp', 'kgq', 'kgr', 'kgs', 'kgt', 'kgu', 'kgv', 'kgw', 'kgx', 'kgy', 'kha', 'khb', 'khc', 'khd', 'khe', 'khf', 'khg', 'khh', 'khi', 'khj', 'khk', 'khl', 'khn', 'kho', 'khp', 'khq', 'khr', 'khs', 'kht', 'khu', 'khv', 'khw', 'khx', 'khy', 'khz', 'kia', 'kib', 'kic', 'kid', 'kie', 'kif', 'kig', 'kih', 'kii', 'kij', 'kil', 'kim', 'kio', 'kip', 'kiq', 'kis', 'kit', 'kiu', 'kiv', 'kiw', 'kix', 'kiy', 'kiz', 'kja', 'kjb', 'kjc', 'kjd', 'kje', 'kjf', 'kjg', 'kjh', 'kji', 'kjj', 'kjk', 'kjl', 'kjm', 'kjn', 'kjo', 'kjp', 'kjq', 'kjr', 'kjs', 'kjt', 'kju', 'kjv', 'kjx', 'kjy', 'kjz', 'kka', 'kkb', 'kkc', 'kkd', 'kke', 'kkf', 'kkg', 'kkh', 'kki', 'kkj', 'kkk', 'kkl', 'kkm', 'kkn', 'kko', 'kkp', 'kkq', 'kkr', 'kks', 'kkt', 'kku', 'kkv', 'kkw', 'kkx', 'kky', 'kkz', 'kla', 'klb', 'klc', 'kld', 'kle', 'klf', 'klg', 'klh', 'kli', 'klj', 'klk', 'kll', 'klm', 'kln', 'klo', 'klp', 'klq', 'klr', 'kls', 'klt', 'klu', 'klv', 'klw', 'klx', 'kly', 'klz', 'kma', 'kmb', 'kmc', 'kmd', 'kme', 'kmf', 'kmg', 'kmh', 'kmi', 'kmj', 'kmk', 'kml', 'kmm', 'kmn', 'kmo', 'kmp', 'kmq', 'kmr', 'kms', 'kmt', 'kmu', 'kmv', 'kmw', 'kmx', 'kmy', 'kmz', 'kna', 'knb', 'knc', 'knd', 'kne', 'knf', 'kng', 'kni', 'knj', 'knk', 'knl', 'knm', 'knn', 'kno', 'knp', 'knq', 'knr', 'kns', 'knt', 'knu', 'knv', 'knw', 'knx', 'kny', 'knz', 'koa', 'koc', 'kod', 'koe', 'kof', 'kog', 'koh', 'koi', 'koj', 'kok', 'kol', 'koo', 'kop', 'koq', 'kos', 'kot', 'kou', 'kov', 'kow', 'kox', 'koy', 'koz', 'kpa', 'kpb', 'kpc', 'kpd', 'kpe', 'kpf', 'kpg', 'kph', 'kpi', 'kpj', 'kpk', 'kpl', 'kpm', 'kpn', 'kpo', 'kpp', 'kpq', 'kpr', 'kps', 'kpt', 'kpu', 'kpv', 'kpw', 'kpx', 'kpy', 'kpz', 'kqa', 'kqb', 'kqc', 'kqd', 'kqe', 'kqf', 'kqg', 'kqh', 'kqi', 'kqj', 'kqk', 'kql', 'kqm', 'kqn', 'kqo', 'kqp', 'kqq', 'kqr', 'kqs', 'kqt', 'kqu', 'kqv', 'kqw', 'kqx', 'kqy', 'kqz', 'kra', 'krb', 'krc', 'krd', 'kre', 'krf', 'krh', 'kri', 'krj', 'krk', 'krl', 'krm', 'krn', 'kro', 'krp', 'krr', 'krs', 'krt', 'kru', 'krv', 'krw', 'krx', 'kry', 'krz', 'ksa', 'ksb', 'ksc', 'ksd', 'kse', 'ksf', 'ksg', 'ksh', 'ksi', 'ksj', 'ksk', 'ksl', 'ksm', 'ksn', 'kso', 'ksp', 'ksq', 'ksr', 'kss', 'kst', 'ksu', 'ksv', 'ksw', 'ksx', 'ksy', 'ksz', 'kta', 'ktb', 'ktc', 'ktd', 'kte', 'ktf', 'ktg', 'kth', 'kti', 'ktj', 'ktk', 'ktl', 'ktm', 'ktn', 'kto', 'ktp', 'ktq', 'ktr', 'kts', 'ktt', 'ktu', 'ktv', 'ktw', 'ktx', 'kty', 'ktz', 'kub', 'kuc', 'kud', 'kue', 'kuf', 'kug', 'kuh', 'kui', 'kuj', 'kuk', 'kul', 'kum', 'kun', 'kuo', 'kup', 'kuq', 'kus', 'kut', 'kuu', 'kuv', 'kuw', 'kux', 'kuy', 'kuz', 'kva', 'kvb', 'kvc', 'kvd', 'kve', 'kvf', 'kvg', 'kvh', 'kvi', 'kvj', 'kvk', 'kvl', 'kvm', 'kvn', 'kvo', 'kvp', 'kvq', 'kvr', 'kvs', 'kvt', 'kvu', 'kvv', 'kvw', 'kvx', 'kvy', 'kvz', 'kwa', 'kwb', 'kwc', 'kwd', 'kwe', 'kwf', 'kwg', 'kwh', 'kwi', 'kwj', 'kwk', 'kwl', 'kwm', 'kwn', 'kwo', 'kwp', 'kwq', 'kwr', 'kws', 'kwt', 'kwu', 'kwv', 'kww', 'kwx', 'kwy', 'kwz', 'kxa', 'kxb', 'kxc', 'kxd', 'kxe', 'kxf', 'kxh', 'kxi', 'kxj', 'kxk', 'kxl', 'kxm', 'kxn', 'kxo', 'kxp', 'kxq', 'kxr', 'kxs', 'kxt', 'kxu', 'kxv', 'kxw', 'kxx', 'kxy', 'kxz', 'kya', 'kyb', 'kyc', 'kyd', 'kye', 'kyf', 'kyg', 'kyh', 'kyi', 'kyj', 'kyk', 'kyl', 'kym', 'kyn', 'kyo', 'kyp', 'kyq', 'kyr', 'kys', 'kyt', 'kyu', 'kyv', 'kyw', 'kyx', 'kyy', 'kyz', 'kza', 'kzb', 'kzc', 'kzd', 'kze', 'kzf', 'kzg', 'kzh', 'kzi', 'kzj', 'kzk', 'kzl', 'kzm', 'kzn', 'kzo', 'kzp', 'kzq', 'kzr', 'kzs', 'kzt', 'kzu', 'kzv', 'kzw', 'kzx', 'kzy', 'kzz', 'laa', 'lab', 'lac', 'lad', 'lae', 'laf', 'lag', 'lah', 'lai', 'laj', 'lak', 'lal', 'lam', 'lan', 'lap', 'laq', 'lar', 'las', 'lau', 'law', 'lax', 'lay', 'laz', 'lba', 'lbb', 'lbc', 'lbe', 'lbf', 'lbg', 'lbi', 'lbj', 'lbk', 'lbl', 'lbm', 'lbn', 'lbo', 'lbq', 'lbr', 'lbs', 'lbt', 'lbu', 'lbv', 'lbw', 'lbx', 'lby', 'lbz', 'lcc', 'lcd', 'lce', 'lcf', 'lch', 'lcl', 'lcm', 'lcp', 'lcq', 'lcs', 'lda', 'ldb', 'ldd', 'ldg', 'ldh', 'ldi', 'ldj', 'ldk', 'ldl', 'ldm', 'ldn', 'ldo', 'ldp', 'ldq', 'lea', 'leb', 'lec', 'led', 'lee', 'lef', 'leg', 'leh', 'lei', 'lej', 'lek', 'lel', 'lem', 'len', 'leo', 'lep', 'leq', 'ler', 'les', 'let', 'leu', 'lev', 'lew', 'lex', 'ley', 'lez', 'lfa', 'lfn', 'lga', 'lgb', 'lgg', 'lgh', 'lgi', 'lgk', 'lgl', 'lgm', 'lgn', 'lgq', 'lgr', 'lgt', 'lgu', 'lgz', 'lha', 'lhh', 'lhi', 'lhl', 'lhm', 'lhn', 'lhp', 'lhs', 'lht', 'lhu', 'lia', 'lib', 'lic', 'lid', 'lie', 'lif', 'lig', 'lih', 'lii', 'lij', 'lik', 'lil', 'lio', 'lip', 'liq', 'lir', 'lis', 'liu', 'liv', 'liw', 'lix', 'liy', 'liz', 'lja', 'lje', 'lji', 'ljl', 'ljp', 'ljw', 'ljx', 'lka', 'lkb', 'lkc', 'lkd', 'lke', 'lkh', 'lki', 'lkj', 'lkl', 'lkm', 'lkn', 'lko', 'lkr', 'lks', 'lkt', 'lku', 'lky', 'lla', 'llb', 'llc', 'lld', 'lle', 'llf', 'llg', 'llh', 'lli', 'llj', 'llk', 'lll', 'llm', 'lln', 'llo', 'llp', 'llq', 'lls', 'llu', 'llx', 'lma', 'lmb', 'lmc', 'lmd', 'lme', 'lmf', 'lmg', 'lmh', 'lmi', 'lmj', 'lmk', 'lml', 'lmm', 'lmn', 'lmo', 'lmp', 'lmq', 'lmr', 'lmu', 'lmv', 'lmw', 'lmx', 'lmy', 'lmz', 'lna', 'lnb', 'lnd', 'lng', 'lnh', 'lni', 'lnj', 'lnl', 'lnm', 'lnn', 'lno', 'lns', 'lnu', 'lnw', 'lnz', 'loa', 'lob', 'loc', 'loe', 'lof', 'log', 'loh', 'loi', 'loj', 'lok', 'lol', 'lom', 'lon', 'loo', 'lop', 'loq', 'lor', 'los', 'lot', 'lou', 'lov', 'low', 'lox', 'loy', 'loz', 'lpa', 'lpe', 'lpn', 'lpo', 'lpx', 'lra', 'lrc', 'lre', 'lrg', 'lri', 'lrk', 'lrl', 'lrm', 'lrn', 'lro', 'lrr', 'lrt', 'lrv', 'lrz', 'lsa', 'lsd', 'lse', 'lsg', 'lsh', 'lsi', 'lsl', 'lsm', 'lso', 'lsp', 'lsr', 'lss', 'lst', 'lsy', 'ltc', 'ltg', 'lth', 'lti', 'ltn', 'lto', 'lts', 'ltu', 'lua', 'luc', 'lud', 'lue', 'luf', 'lui', 'luj', 'luk', 'lul', 'lum', 'lun', 'luo', 'lup', 'luq', 'lur', 'lus', 'lut', 'luu', 'luv', 'luw', 'luy', 'luz', 'lva', 'lvk', 'lvs', 'lvu', 'lwa', 'lwe', 'lwg', 'lwh', 'lwl', 'lwm', 'lwo', 'lws', 'lwt', 'lwu', 'lww', 'lya', 'lyg', 'lyn', 'lzh', 'lzl', 'lzn', 'lzz', 'maa', 'mab', 'mad', 'mae', 'maf', 'mag', 'mai', 'maj', 'mak', 'mam', 'man', 'map', 'maq', 'mas', 'mat', 'mau', 'mav', 'maw', 'max', 'maz', 'mba', 'mbb', 'mbc', 'mbd', 'mbe', 'mbf', 'mbh', 'mbi', 'mbj', 'mbk', 'mbl', 'mbm', 'mbn', 'mbo', 'mbp', 'mbq', 'mbr', 'mbs', 'mbt', 'mbu', 'mbv', 'mbw', 'mbx', 'mby', 'mbz', 'mca', 'mcb', 'mcc', 'mcd', 'mce', 'mcf', 'mcg', 'mch', 'mci', 'mcj', 'mck', 'mcl', 'mcm', 'mcn', 'mco', 'mcp', 'mcq', 'mcr', 'mcs', 'mct', 'mcu', 'mcv', 'mcw', 'mcx', 'mcy', 'mcz', 'mda', 'mdb', 'mdc', 'mdd', 'mde', 'mdf', 'mdg', 'mdh', 'mdi', 'mdj', 'mdk', 'mdl', 'mdm', 'mdn', 'mdp', 'mdq', 'mdr', 'mds', 'mdt', 'mdu', 'mdv', 'mdw', 'mdx', 'mdy', 'mdz', 'mea', 'meb', 'mec', 'med', 'mee', 'mef', 'meg', 'meh', 'mei', 'mej', 'mek', 'mel', 'mem', 'men', 'meo', 'mep', 'meq', 'mer', 'mes', 'met', 'meu', 'mev', 'mew', 'mey', 'mez', 'mfa', 'mfb', 'mfc', 'mfd', 'mfe', 'mff', 'mfg', 'mfh', 'mfi', 'mfj', 'mfk', 'mfl', 'mfm', 'mfn', 'mfo', 'mfp', 'mfq', 'mfr', 'mfs', 'mft', 'mfu', 'mfv', 'mfw', 'mfx', 'mfy', 'mfz', 'mga', 'mgb', 'mgc', 'mgd', 'mge', 'mgf', 'mgg', 'mgh', 'mgi', 'mgj', 'mgk', 'mgl', 'mgm', 'mgn', 'mgo', 'mgp', 'mgq', 'mgr', 'mgs', 'mgt', 'mgu', 'mgv', 'mgw', 'mgx', 'mgy', 'mgz', 'mha', 'mhb', 'mhc', 'mhd', 'mhe', 'mhf', 'mhg', 'mhh', 'mhi', 'mhj', 'mhk', 'mhl', 'mhm', 'mhn', 'mho', 'mhp', 'mhq', 'mhr', 'mhs', 'mht', 'mhu', 'mhw', 'mhx', 'mhy', 'mhz', 'mia', 'mib', 'mic', 'mid', 'mie', 'mif', 'mig', 'mih', 'mii', 'mij', 'mik', 'mil', 'mim', 'min', 'mio', 'mip', 'miq', 'mir', 'mis', 'mit', 'miu', 'miw', 'mix', 'miy', 'miz', 'mja', 'mjb', 'mjc', 'mjd', 'mje', 'mjg', 'mjh', 'mji', 'mjj', 'mjk', 'mjl', 'mjm', 'mjn', 'mjo', 'mjp', 'mjq', 'mjr', 'mjs', 'mjt', 'mju', 'mjv', 'mjw', 'mjx', 'mjy', 'mjz', 'mka', 'mkb', 'mkc', 'mke', 'mkf', 'mkg', 'mkh', 'mki', 'mkj', 'mkk', 'mkl', 'mkm', 'mkn', 'mko', 'mkp', 'mkq', 'mkr', 'mks', 'mkt', 'mku', 'mkv', 'mkw', 'mkx', 'mky', 'mkz', 'mla', 'mlb', 'mlc', 'mld', 'mle', 'mlf', 'mlh', 'mli', 'mlj', 'mlk', 'mll', 'mlm', 'mln', 'mlo', 'mlp', 'mlq', 'mlr', 'mls', 'mlu', 'mlv', 'mlw', 'mlx', 'mlz', 'mma', 'mmb', 'mmc', 'mmd', 'mme', 'mmf', 'mmg', 'mmh', 'mmi', 'mmj', 'mmk', 'mml', 'mmm', 'mmn', 'mmo', 'mmp', 'mmq', 'mmr', 'mmt', 'mmu', 'mmv', 'mmw', 'mmx', 'mmy', 'mmz', 'mna', 'mnb', 'mnc', 'mnd', 'mne', 'mnf', 'mng', 'mnh', 'mni', 'mnj', 'mnk', 'mnl', 'mnm', 'mnn', 'mno', 'mnp', 'mnq', 'mnr', 'mns', 'mnt', 'mnu', 'mnv', 'mnw', 'mnx', 'mny', 'mnz', 'moa', 'moc', 'mod', 'moe', 'mof', 'mog', 'moh', 'moi', 'moj', 'mok', 'mom', 'moo', 'mop', 'moq', 'mor', 'mos', 'mot', 'mou', 'mov', 'mow', 'mox', 'moy', 'moz', 'mpa', 'mpb', 'mpc', 'mpd', 'mpe', 'mpg', 'mph', 'mpi', 'mpj', 'mpk', 'mpl', 'mpm', 'mpn', 'mpo', 'mpp', 'mpq', 'mpr', 'mps', 'mpt', 'mpu', 'mpv', 'mpw', 'mpx', 'mpy', 'mpz', 'mqa', 'mqb', 'mqc', 'mqe', 'mqf', 'mqg', 'mqh', 'mqi', 'mqj', 'mqk', 'mql', 'mqm', 'mqn', 'mqo', 'mqp', 'mqq', 'mqr', 'mqs', 'mqt', 'mqu', 'mqv', 'mqw', 'mqx', 'mqy', 'mqz', 'mra', 'mrb', 'mrc', 'mrd', 'mre', 'mrf', 'mrg', 'mrh', 'mrj', 'mrk', 'mrl', 'mrm', 'mrn', 'mro', 'mrp', 'mrq', 'mrr', 'mrs', 'mrt', 'mru', 'mrv', 'mrw', 'mrx', 'mry', 'mrz', 'msb', 'msc', 'msd', 'mse', 'msf', 'msg', 'msh', 'msi', 'msj', 'msk', 'msl', 'msm', 'msn', 'mso', 'msp', 'msq', 'msr', 'mss', 'mst', 'msu', 'msv', 'msw', 'msx', 'msy', 'msz', 'mta', 'mtb', 'mtc', 'mtd', 'mte', 'mtf', 'mtg', 'mth', 'mti', 'mtj', 'mtk', 'mtl', 'mtm', 'mtn', 'mto', 'mtp', 'mtq', 'mtr', 'mts', 'mtt', 'mtu', 'mtv', 'mtw', 'mtx', 'mty', 'mua', 'mub', 'muc', 'mud', 'mue', 'mug', 'muh', 'mui', 'muj', 'muk', 'mul', 'mum', 'mun', 'muo', 'mup', 'muq', 'mur', 'mus', 'mut', 'muu', 'muv', 'mux', 'muy', 'muz', 'mva', 'mvb', 'mvd', 'mve', 'mvf', 'mvg', 'mvh', 'mvi', 'mvk', 'mvl', 'mvm', 'mvn', 'mvo', 'mvp', 'mvq', 'mvr', 'mvs', 'mvt', 'mvu', 'mvv', 'mvw', 'mvx', 'mvy', 'mvz', 'mwa', 'mwb', 'mwc', 'mwd', 'mwe', 'mwf', 'mwg', 'mwh', 'mwi', 'mwj', 'mwk', 'mwl', 'mwm', 'mwn', 'mwo', 'mwp', 'mwq', 'mwr', 'mws', 'mwt', 'mwu', 'mwv', 'mww', 'mwx', 'mwy', 'mwz', 'mxa', 'mxb', 'mxc', 'mxd', 'mxe', 'mxf', 'mxg', 'mxh', 'mxi', 'mxj', 'mxk', 'mxl', 'mxm', 'mxn', 'mxo', 'mxp', 'mxq', 'mxr', 'mxs', 'mxt', 'mxu', 'mxv', 'mxw', 'mxx', 'mxy', 'mxz', 'myb', 'myc', 'myd', 'mye', 'myf', 'myg', 'myh', 'myi', 'myj', 'myk', 'myl', 'mym', 'myn', 'myo', 'myp', 'myq', 'myr', 'mys', 'myt', 'myu', 'myv', 'myw', 'myx', 'myy', 'myz', 'mza', 'mzb', 'mzc', 'mzd', 'mze', 'mzg', 'mzh', 'mzi', 'mzj', 'mzk', 'mzl', 'mzm', 'mzn', 'mzo', 'mzp', 'mzq', 'mzr', 'mzs', 'mzt', 'mzu', 'mzv', 'mzw', 'mzx', 'mzy', 'mzz', 'naa', 'nab', 'nac', 'nad', 'nae', 'naf', 'nag', 'nah', 'nai', 'naj', 'nak', 'nal', 'nam', 'nan', 'nao', 'nap', 'naq', 'nar', 'nas', 'nat', 'naw', 'nax', 'nay', 'naz', 'nba', 'nbb', 'nbc', 'nbd', 'nbe', 'nbf', 'nbg', 'nbh', 'nbi', 'nbj', 'nbk', 'nbm', 'nbn', 'nbo', 'nbp', 'nbq', 'nbr', 'nbs', 'nbt', 'nbu', 'nbv', 'nbw', 'nbx', 'nby', 'nca', 'ncb', 'ncc', 'ncd', 'nce', 'ncf', 'ncg', 'nch', 'nci', 'ncj', 'nck', 'ncl', 'ncm', 'ncn', 'nco', 'ncp', 'ncq', 'ncr', 'ncs', 'nct', 'ncu', 'ncx', 'ncz', 'nda', 'ndb', 'ndc', 'ndd', 'ndf', 'ndg', 'ndh', 'ndi', 'ndj', 'ndk', 'ndl', 'ndm', 'ndn', 'ndp', 'ndq', 'ndr', 'nds', 'ndt', 'ndu', 'ndv', 'ndw', 'ndx', 'ndy', 'ndz', 'nea', 'neb', 'nec', 'ned', 'nee', 'nef', 'neg', 'neh', 'nei', 'nej', 'nek', 'nem', 'nen', 'neo', 'neq', 'ner', 'nes', 'net', 'neu', 'nev', 'new', 'nex', 'ney', 'nez', 'nfa', 'nfd', 'nfl', 'nfr', 'nfu', 'nga', 'ngb', 'ngc', 'ngd', 'nge', 'ngf', 'ngg', 'ngh', 'ngi', 'ngj', 'ngk', 'ngl', 'ngm', 'ngn', 'ngo', 'ngp', 'ngq', 'ngr', 'ngs', 'ngt', 'ngu', 'ngv', 'ngw', 'ngx', 'ngy', 'ngz', 'nha', 'nhb', 'nhc', 'nhd', 'nhe', 'nhf', 'nhg', 'nhh', 'nhi', 'nhk', 'nhm', 'nhn', 'nho', 'nhp', 'nhq', 'nhr', 'nht', 'nhu', 'nhv', 'nhw', 'nhx', 'nhy', 'nhz', 'nia', 'nib', 'nic', 'nid', 'nie', 'nif', 'nig', 'nih', 'nii', 'nij', 'nik', 'nil', 'nim', 'nin', 'nio', 'niq', 'nir', 'nis', 'nit', 'niu', 'niv', 'niw', 'nix', 'niy', 'niz', 'nja', 'njb', 'njd', 'njh', 'nji', 'njj', 'njl', 'njm', 'njn', 'njo', 'njr', 'njs', 'njt', 'nju', 'njx', 'njy', 'njz', 'nka', 'nkb', 'nkc', 'nkd', 'nke', 'nkf', 'nkg', 'nkh', 'nki', 'nkj', 'nkk', 'nkm', 'nkn', 'nko', 'nkp', 'nkq', 'nkr', 'nks', 'nkt', 'nku', 'nkv', 'nkw', 'nkx', 'nkz', 'nla', 'nlc', 'nle', 'nlg', 'nli', 'nlj', 'nlk', 'nll', 'nlm', 'nln', 'nlo', 'nlq', 'nlr', 'nlu', 'nlv', 'nlw', 'nlx', 'nly', 'nlz', 'nma', 'nmb', 'nmc', 'nmd', 'nme', 'nmf', 'nmg', 'nmh', 'nmi', 'nmj', 'nmk', 'nml', 'nmm', 'nmn', 'nmo', 'nmp', 'nmq', 'nmr', 'nms', 'nmt', 'nmu', 'nmv', 'nmw', 'nmx', 'nmy', 'nmz', 'nna', 'nnb', 'nnc', 'nnd', 'nne', 'nnf', 'nng', 'nnh', 'nni', 'nnj', 'nnk', 'nnl', 'nnm', 'nnn', 'nnp', 'nnq', 'nnr', 'nns', 'nnt', 'nnu', 'nnv', 'nnw', 'nnx', 'nny', 'nnz', 'noa', 'noc', 'nod', 'noe', 'nof', 'nog', 'noh', 'noi', 'noj', 'nok', 'nol', 'nom', 'non', 'noo', 'nop', 'noq', 'nos', 'not', 'nou', 'nov', 'now', 'noy', 'noz', 'npa', 'npb', 'npg', 'nph', 'npi', 'npl', 'npn', 'npo', 'nps', 'npu', 'npx', 'npy', 'nqg', 'nqk', 'nql', 'nqm', 'nqn', 'nqo', 'nqq', 'nqy', 'nra', 'nrb', 'nrc', 'nre', 'nrf', 'nrg', 'nri', 'nrk', 'nrl', 'nrm', 'nrn', 'nrp', 'nrr', 'nrt', 'nru', 'nrx', 'nrz', 'nsa', 'nsc', 'nsd', 'nse', 'nsf', 'nsg', 'nsh', 'nsi', 'nsk', 'nsl', 'nsm', 'nsn', 'nso', 'nsp', 'nsq', 'nsr', 'nss', 'nst', 'nsu', 'nsv', 'nsw', 'nsx', 'nsy', 'nsz', 'ntd', 'nte', 'ntg', 'nti', 'ntj', 'ntk', 'ntm', 'nto', 'ntp', 'ntr', 'nts', 'ntu', 'ntw', 'ntx', 'nty', 'ntz', 'nua', 'nub', 'nuc', 'nud', 'nue', 'nuf', 'nug', 'nuh', 'nui', 'nuj', 'nuk', 'nul', 'num', 'nun', 'nuo', 'nup', 'nuq', 'nur', 'nus', 'nut', 'nuu', 'nuv', 'nuw', 'nux', 'nuy', 'nuz', 'nvh', 'nvm', 'nvo', 'nwa', 'nwb', 'nwc', 'nwe', 'nwg', 'nwi', 'nwm', 'nwo', 'nwr', 'nwx', 'nwy', 'nxa', 'nxd', 'nxe', 'nxg', 'nxi', 'nxk', 'nxl', 'nxm', 'nxn', 'nxo', 'nxq', 'nxr', 'nxu', 'nxx', 'nyb', 'nyc', 'nyd', 'nye', 'nyf', 'nyg', 'nyh', 'nyi', 'nyj', 'nyk', 'nyl', 'nym', 'nyn', 'nyo', 'nyp', 'nyq', 'nyr', 'nys', 'nyt', 'nyu', 'nyv', 'nyw', 'nyx', 'nyy', 'nza', 'nzb', 'nzd', 'nzi', 'nzk', 'nzm', 'nzs', 'nzu', 'nzy', 'nzz', 'oaa', 'oac', 'oar', 'oav', 'obi', 'obk', 'obl', 'obm', 'obo', 'obr', 'obt', 'obu', 'oca', 'och', 'oco', 'ocu', 'oda', 'odk', 'odt', 'odu', 'ofo', 'ofs', 'ofu', 'ogb', 'ogc', 'oge', 'ogg', 'ogo', 'ogu', 'oht', 'ohu', 'oia', 'oin', 'ojb', 'ojc', 'ojg', 'ojp', 'ojs', 'ojv', 'ojw', 'oka', 'okb', 'okd', 'oke', 'okg', 'okh', 'oki', 'okj', 'okk', 'okl', 'okm', 'okn', 'oko', 'okr', 'oks', 'oku', 'okv', 'okx', 'ola', 'old', 'ole', 'olk', 'olm', 'olo', 'olr', 'olt', 'olu', 'oma', 'omb', 'omc', 'ome', 'omg', 'omi', 'omk', 'oml', 'omn', 'omo', 'omp', 'omq', 'omr', 'omt', 'omu', 'omv', 'omw', 'omx', 'ona', 'onb', 'one', 'ong', 'oni', 'onj', 'onk', 'onn', 'ono', 'onp', 'onr', 'ons', 'ont', 'onu', 'onw', 'onx', 'ood', 'oog', 'oon', 'oor', 'oos', 'opa', 'opk', 'opm', 'opo', 'opt', 'opy', 'ora', 'orc', 'ore', 'org', 'orh', 'orn', 'oro', 'orr', 'ors', 'ort', 'oru', 'orv', 'orw', 'orx', 'ory', 'orz', 'osa', 'osc', 'osi', 'oso', 'osp', 'ost', 'osu', 'osx', 'ota', 'otb', 'otd', 'ote', 'oti', 'otk', 'otl', 'otm', 'otn', 'oto', 'otq', 'otr', 'ots', 'ott', 'otu', 'otw', 'otx', 'oty', 'otz', 'oua', 'oub', 'oue', 'oui', 'oum', 'oun', 'ovd', 'owi', 'owl', 'oyb', 'oyd', 'oym', 'oyy', 'ozm', 'paa', 'pab', 'pac', 'pad', 'pae', 'paf', 'pag', 'pah', 'pai', 'pak', 'pal', 'pam', 'pao', 'pap', 'paq', 'par', 'pas', 'pat', 'pau', 'pav', 'paw', 'pax', 'pay', 'paz', 'pbb', 'pbc', 'pbe', 'pbf', 'pbg', 'pbh', 'pbi', 'pbl', 'pbm', 'pbn', 'pbo', 'pbp', 'pbr', 'pbs', 'pbt', 'pbu', 'pbv', 'pby', 'pbz', 'pca', 'pcb', 'pcc', 'pcd', 'pce', 'pcf', 'pcg', 'pch', 'pci', 'pcj', 'pck', 'pcl', 'pcm', 'pcn', 'pcp', 'pcr', 'pcw', 'pda', 'pdc', 'pdi', 'pdn', 'pdo', 'pdt', 'pdu', 'pea', 'peb', 'ped', 'pee', 'pef', 'peg', 'peh', 'pei', 'pej', 'pek', 'pel', 'pem', 'peo', 'pep', 'peq', 'pes', 'pev', 'pex', 'pey', 'pez', 'pfa', 'pfe', 'pfl', 'pga', 'pgd', 'pgg', 'pgi', 'pgk', 'pgl', 'pgn', 'pgs', 'pgu', 'pgy', 'pgz', 'pha', 'phd', 'phg', 'phh', 'phi', 'phk', 'phl', 'phm', 'phn', 'pho', 'phq', 'phr', 'pht', 'phu', 'phv', 'phw', 'pia', 'pib', 'pic', 'pid', 'pie', 'pif', 'pig', 'pih', 'pii', 'pij', 'pil', 'pim', 'pin', 'pio', 'pip', 'pir', 'pis', 'pit', 'piu', 'piv', 'piw', 'pix', 'piy', 'piz', 'pjt', 'pka', 'pkb', 'pkc', 'pkg', 'pkh', 'pkn', 'pko', 'pkp', 'pkr', 'pks', 'pkt', 'pku', 'pla', 'plb', 'plc', 'pld', 'ple', 'plf', 'plg', 'plh', 'plj', 'plk', 'pll', 'pln', 'plo', 'plp', 'plq', 'plr', 'pls', 'plt', 'plu', 'plv', 'plw', 'ply', 'plz', 'pma', 'pmb', 'pmc', 'pmd', 'pme', 'pmf', 'pmh', 'pmi', 'pmj', 'pmk', 'pml', 'pmm', 'pmn', 'pmo', 'pmq', 'pmr', 'pms', 'pmt', 'pmu', 'pmw', 'pmx', 'pmy', 'pmz', 'pna', 'pnb', 'pnc', 'pne', 'png', 'pnh', 'pni', 'pnj', 'pnk', 'pnl', 'pnm', 'pnn', 'pno', 'pnp', 'pnq', 'pnr', 'pns', 'pnt', 'pnu', 'pnv', 'pnw', 'pnx', 'pny', 'pnz', 'poc', 'pod', 'poe', 'pof', 'pog', 'poh', 'poi', 'pok', 'pom', 'pon', 'poo', 'pop', 'poq', 'pos', 'pot', 'pov', 'pow', 'pox', 'poy', 'poz', 'ppa', 'ppe', 'ppi', 'ppk', 'ppl', 'ppm', 'ppn', 'ppo', 'ppp', 'ppq', 'ppr', 'pps', 'ppt', 'ppu', 'pqa', 'pqe', 'pqm', 'pqw', 'pra', 'prb', 'prc', 'prd', 'pre', 'prf', 'prg', 'prh', 'pri', 'prk', 'prl', 'prm', 'prn', 'pro', 'prp', 'prq', 'prr', 'prs', 'prt', 'pru', 'prw', 'prx', 'pry', 'prz', 'psa', 'psc', 'psd', 'pse', 'psg', 'psh', 'psi', 'psl', 'psm', 'psn', 'pso', 'psp', 'psq', 'psr', 'pss', 'pst', 'psu', 'psw', 'psy', 'pta', 'pth', 'pti', 'ptn', 'pto', 'ptp', 'ptq', 'ptr', 'ptt', 'ptu', 'ptv', 'ptw', 'pty', 'pua', 'pub', 'puc', 'pud', 'pue', 'puf', 'pug', 'pui', 'puj', 'puk', 'pum', 'puo', 'pup', 'puq', 'pur', 'put', 'puu', 'puw', 'pux', 'puy', 'puz', 'pwa', 'pwb', 'pwg', 'pwi', 'pwm', 'pwn', 'pwo', 'pwr', 'pww', 'pxm', 'pye', 'pym', 'pyn', 'pys', 'pyu', 'pyx', 'pyy', 'pzn', 'qaa..qtz', 'qua', 'qub', 'quc', 'qud', 'quf', 'qug', 'quh', 'qui', 'quk', 'qul', 'qum', 'qun', 'qup', 'quq', 'qur', 'qus', 'quv', 'quw', 'qux', 'quy', 'quz', 'qva', 'qvc', 'qve', 'qvh', 'qvi', 'qvj', 'qvl', 'qvm', 'qvn', 'qvo', 'qvp', 'qvs', 'qvw', 'qvy', 'qvz', 'qwa', 'qwc', 'qwe', 'qwh', 'qwm', 'qws', 'qwt', 'qxa', 'qxc', 'qxh', 'qxl', 'qxn', 'qxo', 'qxp', 'qxq', 'qxr', 'qxs', 'qxt', 'qxu', 'qxw', 'qya', 'qyp', 'raa', 'rab', 'rac', 'rad', 'raf', 'rag', 'rah', 'rai', 'raj', 'rak', 'ral', 'ram', 'ran', 'rao', 'rap', 'raq', 'rar', 'ras', 'rat', 'rau', 'rav', 'raw', 'rax', 'ray', 'raz', 'rbb', 'rbk', 'rbl', 'rbp', 'rcf', 'rdb', 'rea', 'reb', 'ree', 'reg', 'rei', 'rej', 'rel', 'rem', 'ren', 'rer', 'res', 'ret', 'rey', 'rga', 'rge', 'rgk', 'rgn', 'rgr', 'rgs', 'rgu', 'rhg', 'rhp', 'ria', 'rie', 'rif', 'ril', 'rim', 'rin', 'rir', 'rit', 'riu', 'rjg', 'rji', 'rjs', 'rka', 'rkb', 'rkh', 'rki', 'rkm', 'rkt', 'rkw', 'rma', 'rmb', 'rmc', 'rmd', 'rme', 'rmf', 'rmg', 'rmh', 'rmi', 'rmk', 'rml', 'rmm', 'rmn', 'rmo', 'rmp', 'rmq', 'rmr', 'rms', 'rmt', 'rmu', 'rmv', 'rmw', 'rmx', 'rmy', 'rmz', 'rna', 'rnd', 'rng', 'rnl', 'rnn', 'rnp', 'rnr', 'rnw', 'roa', 'rob', 'roc', 'rod', 'roe', 'rof', 'rog', 'rol', 'rom', 'roo', 'rop', 'ror', 'rou', 'row', 'rpn', 'rpt', 'rri', 'rro', 'rrt', 'rsb', 'rsi', 'rsl', 'rsm', 'rtc', 'rth', 'rtm', 'rts', 'rtw', 'rub', 'ruc', 'rue', 'ruf', 'rug', 'ruh', 'rui', 'ruk', 'ruo', 'rup', 'ruq', 'rut', 'ruu', 'ruy', 'ruz', 'rwa', 'rwk', 'rwm', 'rwo', 'rwr', 'rxd', 'rxw', 'ryn', 'rys', 'ryu', 'rzh', 'saa', 'sab', 'sac', 'sad', 'sae', 'saf', 'sah', 'sai', 'saj', 'sak', 'sal', 'sam', 'sao', 'sap', 'saq', 'sar', 'sas', 'sat', 'sau', 'sav', 'saw', 'sax', 'say', 'saz', 'sba', 'sbb', 'sbc', 'sbd', 'sbe', 'sbf', 'sbg', 'sbh', 'sbi', 'sbj', 'sbk', 'sbl', 'sbm', 'sbn', 'sbo', 'sbp', 'sbq', 'sbr', 'sbs', 'sbt', 'sbu', 'sbv', 'sbw', 'sbx', 'sby', 'sbz', 'sca', 'scb', 'sce', 'scf', 'scg', 'sch', 'sci', 'sck', 'scl', 'scn', 'sco', 'scp', 'scq', 'scs', 'sct', 'scu', 'scv', 'scw', 'scx', 'sda', 'sdb', 'sdc', 'sde', 'sdf', 'sdg', 'sdh', 'sdj', 'sdk', 'sdl', 'sdm', 'sdn', 'sdo', 'sdp', 'sdr', 'sds', 'sdt', 'sdu', 'sdv', 'sdx', 'sdz', 'sea', 'seb', 'sec', 'sed', 'see', 'sef', 'seg', 'seh', 'sei', 'sej', 'sek', 'sel', 'sem', 'sen', 'seo', 'sep', 'seq', 'ser', 'ses', 'set', 'seu', 'sev', 'sew', 'sey', 'sez', 'sfb', 'sfe', 'sfm', 'sfs', 'sfw', 'sga', 'sgb', 'sgc', 'sgd', 'sge', 'sgg', 'sgh', 'sgi', 'sgj', 'sgk', 'sgl', 'sgm', 'sgn', 'sgo', 'sgp', 'sgr', 'sgs', 'sgt', 'sgu', 'sgw', 'sgx', 'sgy', 'sgz', 'sha', 'shb', 'shc', 'shd', 'she', 'shg', 'shh', 'shi', 'shj', 'shk', 'shl', 'shm', 'shn', 'sho', 'shp', 'shq', 'shr', 'shs', 'sht', 'shu', 'shv', 'shw', 'shx', 'shy', 'shz', 'sia', 'sib', 'sid', 'sie', 'sif', 'sig', 'sih', 'sii', 'sij', 'sik', 'sil', 'sim', 'sio', 'sip', 'siq', 'sir', 'sis', 'sit', 'siu', 'siv', 'siw', 'six', 'siy', 'siz', 'sja', 'sjb', 'sjd', 'sje', 'sjg', 'sjk', 'sjl', 'sjm', 'sjn', 'sjo', 'sjp', 'sjr', 'sjs', 'sjt', 'sju', 'sjw', 'ska', 'skb', 'skc', 'skd', 'ske', 'skf', 'skg', 'skh', 'ski', 'skj', 'skk', 'skm', 'skn', 'sko', 'skp', 'skq', 'skr', 'sks', 'skt', 'sku', 'skv', 'skw', 'skx', 'sky', 'skz', 'sla', 'slc', 'sld', 'sle', 'slf', 'slg', 'slh', 'sli', 'slj', 'sll', 'slm', 'sln', 'slp', 'slq', 'slr', 'sls', 'slt', 'slu', 'slw', 'slx', 'sly', 'slz', 'sma', 'smb', 'smc', 'smd', 'smf', 'smg', 'smh', 'smi', 'smj', 'smk', 'sml', 'smm', 'smn', 'smp', 'smq', 'smr', 'sms', 'smt', 'smu', 'smv', 'smw', 'smx', 'smy', 'smz', 'snb', 'snc', 'sne', 'snf', 'sng', 'snh', 'sni', 'snj', 'snk', 'snl', 'snm', 'snn', 'sno', 'snp', 'snq', 'snr', 'sns', 'snu', 'snv', 'snw', 'snx', 'sny', 'snz', 'soa', 'sob', 'soc', 'sod', 'soe', 'sog', 'soh', 'soi', 'soj', 'sok', 'sol', 'son', 'soo', 'sop', 'soq', 'sor', 'sos', 'sou', 'sov', 'sow', 'sox', 'soy', 'soz', 'spb', 'spc', 'spd', 'spe', 'spg', 'spi', 'spk', 'spl', 'spm', 'spn', 'spo', 'spp', 'spq', 'spr', 'sps', 'spt', 'spu', 'spv', 'spx', 'spy', 'sqa', 'sqh', 'sqj', 'sqk', 'sqm', 'sqn', 'sqo', 'sqq', 'sqr', 'sqs', 'sqt', 'squ', 'sra', 'srb', 'src', 'sre', 'srf', 'srg', 'srh', 'sri', 'srk', 'srl', 'srm', 'srn', 'sro', 'srq', 'srr', 'srs', 'srt', 'sru', 'srv', 'srw', 'srx', 'sry', 'srz', 'ssa', 'ssb', 'ssc', 'ssd', 'sse', 'ssf', 'ssg', 'ssh', 'ssi', 'ssj', 'ssk', 'ssl', 'ssm', 'ssn', 'sso', 'ssp', 'ssq', 'ssr', 'sss', 'sst', 'ssu', 'ssv', 'ssx', 'ssy', 'ssz', 'sta', 'stb', 'std', 'ste', 'stf', 'stg', 'sth', 'sti', 'stj', 'stk', 'stl', 'stm', 'stn', 'sto', 'stp', 'stq', 'str', 'sts', 'stt', 'stu', 'stv', 'stw', 'sty', 'sua', 'sub', 'suc', 'sue', 'sug', 'sui', 'suj', 'suk', 'sul', 'sum', 'suq', 'sur', 'sus', 'sut', 'suv', 'suw', 'sux', 'suy', 'suz', 'sva', 'svb', 'svc', 'sve', 'svk', 'svm', 'svr', 'svs', 'svx', 'swb', 'swc', 'swf', 'swg', 'swh', 'swi', 'swj', 'swk', 'swl', 'swm', 'swn', 'swo', 'swp', 'swq', 'swr', 'sws', 'swt', 'swu', 'swv', 'sww', 'swx', 'swy', 'sxb', 'sxc', 'sxe', 'sxg', 'sxk', 'sxl', 'sxm', 'sxn', 'sxo', 'sxr', 'sxs', 'sxu', 'sxw', 'sya', 'syb', 'syc', 'syd', 'syi', 'syk', 'syl', 'sym', 'syn', 'syo', 'syr', 'sys', 'syw', 'syx', 'syy', 'sza', 'szb', 'szc', 'szd', 'sze', 'szg', 'szl', 'szn', 'szp', 'szs', 'szv', 'szw', 'taa', 'tab', 'tac', 'tad', 'tae', 'taf', 'tag', 'tai', 'taj', 'tak', 'tal', 'tan', 'tao', 'tap', 'taq', 'tar', 'tas', 'tau', 'tav', 'taw', 'tax', 'tay', 'taz', 'tba', 'tbb', 'tbc', 'tbd', 'tbe', 'tbf', 'tbg', 'tbh', 'tbi', 'tbj', 'tbk', 'tbl', 'tbm', 'tbn', 'tbo', 'tbp', 'tbq', 'tbr', 'tbs', 'tbt', 'tbu', 'tbv', 'tbw', 'tbx', 'tby', 'tbz', 'tca', 'tcb', 'tcc', 'tcd', 'tce', 'tcf', 'tcg', 'tch', 'tci', 'tck', 'tcl', 'tcm', 'tcn', 'tco', 'tcp', 'tcq', 'tcs', 'tct', 'tcu', 'tcw', 'tcx', 'tcy', 'tcz', 'tda', 'tdb', 'tdc', 'tdd', 'tde', 'tdf', 'tdg', 'tdh', 'tdi', 'tdj', 'tdk', 'tdl', 'tdm', 'tdn', 'tdo', 'tdq', 'tdr', 'tds', 'tdt', 'tdu', 'tdv', 'tdx', 'tdy', 'tea', 'teb', 'tec', 'ted', 'tee', 'tef', 'teg', 'teh', 'tei', 'tek', 'tem', 'ten', 'teo', 'tep', 'teq', 'ter', 'tes', 'tet', 'teu', 'tev', 'tew', 'tex', 'tey', 'tez', 'tfi', 'tfn', 'tfo', 'tfr', 'tft', 'tga', 'tgb', 'tgc', 'tgd', 'tge', 'tgf', 'tgg', 'tgh', 'tgi', 'tgj', 'tgn', 'tgo', 'tgp', 'tgq', 'tgr', 'tgs', 'tgt', 'tgu', 'tgv', 'tgw', 'tgx', 'tgy', 'tgz', 'thc', 'thd', 'the', 'thf', 'thh', 'thi', 'thk', 'thl', 'thm', 'thn', 'thp', 'thq', 'thr', 'ths', 'tht', 'thu', 'thv', 'thw', 'thx', 'thy', 'thz', 'tia', 'tic', 'tid', 'tie', 'tif', 'tig', 'tih', 'tii', 'tij', 'tik', 'til', 'tim', 'tin', 'tio', 'tip', 'tiq', 'tis', 'tit', 'tiu', 'tiv', 'tiw', 'tix', 'tiy', 'tiz', 'tja', 'tjg', 'tji', 'tjl', 'tjm', 'tjn', 'tjo', 'tjs', 'tju', 'tjw', 'tka', 'tkb', 'tkd', 'tke', 'tkf', 'tkg', 'tkk', 'tkl', 'tkm', 'tkn', 'tkp', 'tkq', 'tkr', 'tks', 'tkt', 'tku', 'tkv', 'tkw', 'tkx', 'tkz', 'tla', 'tlb', 'tlc', 'tld', 'tlf', 'tlg', 'tlh', 'tli', 'tlj', 'tlk', 'tll', 'tlm', 'tln', 'tlo', 'tlp', 'tlq', 'tlr', 'tls', 'tlt', 'tlu', 'tlv', 'tlw', 'tlx', 'tly', 'tma', 'tmb', 'tmc', 'tmd', 'tme', 'tmf', 'tmg', 'tmh', 'tmi', 'tmj', 'tmk', 'tml', 'tmm', 'tmn', 'tmo', 'tmp', 'tmq', 'tmr', 'tms', 'tmt', 'tmu', 'tmv', 'tmw', 'tmy', 'tmz', 'tna', 'tnb', 'tnc', 'tnd', 'tne', 'tnf', 'tng', 'tnh', 'tni', 'tnk', 'tnl', 'tnm', 'tnn', 'tno', 'tnp', 'tnq', 'tnr', 'tns', 'tnt', 'tnu', 'tnv', 'tnw', 'tnx', 'tny', 'tnz', 'tob', 'toc', 'tod', 'toe', 'tof', 'tog', 'toh', 'toi', 'toj', 'tol', 'tom', 'too', 'top', 'toq', 'tor', 'tos', 'tou', 'tov', 'tow', 'tox', 'toy', 'toz', 'tpa', 'tpc', 'tpe', 'tpf', 'tpg', 'tpi', 'tpj', 'tpk', 'tpl', 'tpm', 'tpn', 'tpo', 'tpp', 'tpq', 'tpr', 'tpt', 'tpu', 'tpv', 'tpw', 'tpx', 'tpy', 'tpz', 'tqb', 'tql', 'tqm', 'tqn', 'tqo', 'tqp', 'tqq', 'tqr', 'tqt', 'tqu', 'tqw', 'tra', 'trb', 'trc', 'trd', 'tre', 'trf', 'trg', 'trh', 'tri', 'trj', 'trk', 'trl', 'trm', 'trn', 'tro', 'trp', 'trq', 'trr', 'trs', 'trt', 'tru', 'trv', 'trw', 'trx', 'try', 'trz', 'tsa', 'tsb', 'tsc', 'tsd', 'tse', 'tsf', 'tsg', 'tsh', 'tsi', 'tsj', 'tsk', 'tsl', 'tsm', 'tsp', 'tsq', 'tsr', 'tss', 'tst', 'tsu', 'tsv', 'tsw', 'tsx', 'tsy', 'tsz', 'tta', 'ttb', 'ttc', 'ttd', 'tte', 'ttf', 'ttg', 'tth', 'tti', 'ttj', 'ttk', 'ttl', 'ttm', 'ttn', 'tto', 'ttp', 'ttq', 'ttr', 'tts', 'ttt', 'ttu', 'ttv', 'ttw', 'tty', 'ttz', 'tua', 'tub', 'tuc', 'tud', 'tue', 'tuf', 'tug', 'tuh', 'tui', 'tuj', 'tul', 'tum', 'tun', 'tuo', 'tup', 'tuq', 'tus', 'tut', 'tuu', 'tuv', 'tuw', 'tux', 'tuy', 'tuz', 'tva', 'tvd', 'tve', 'tvk', 'tvl', 'tvm', 'tvn', 'tvo', 'tvs', 'tvt', 'tvu', 'tvw', 'tvy', 'twa', 'twb', 'twc', 'twd', 'twe', 'twf', 'twg', 'twh', 'twl', 'twm', 'twn', 'two', 'twp', 'twq', 'twr', 'twt', 'twu', 'tww', 'twx', 'twy', 'txa', 'txb', 'txc', 'txe', 'txg', 'txh', 'txi', 'txj', 'txm', 'txn', 'txo', 'txq', 'txr', 'txs', 'txt', 'txu', 'txx', 'txy', 'tya', 'tye', 'tyh', 'tyi', 'tyj', 'tyl', 'tyn', 'typ', 'tyr', 'tys', 'tyt', 'tyu', 'tyv', 'tyx', 'tyz', 'tza', 'tzh', 'tzj', 'tzl', 'tzm', 'tzn', 'tzo', 'tzx', 'uam', 'uan', 'uar', 'uba', 'ubi', 'ubl', 'ubr', 'ubu', 'uby', 'uda', 'ude', 'udg', 'udi', 'udj', 'udl', 'udm', 'udu', 'ues', 'ufi', 'uga', 'ugb', 'uge', 'ugn', 'ugo', 'ugy', 'uha', 'uhn', 'uis', 'uiv', 'uji', 'uka', 'ukg', 'ukh', 'ukk', 'ukl', 'ukp', 'ukq', 'uks', 'uku', 'ukw', 'uky', 'ula', 'ulb', 'ulc', 'ule', 'ulf', 'uli', 'ulk', 'ull', 'ulm', 'uln', 'ulu', 'ulw', 'uma', 'umb', 'umc', 'umd', 'umg', 'umi', 'umm', 'umn', 'umo', 'ump', 'umr', 'ums', 'umu', 'una', 'und', 'une', 'ung', 'unk', 'unm', 'unn', 'unp', 'unr', 'unu', 'unx', 'unz', 'uok', 'upi', 'upv', 'ura', 'urb', 'urc', 'ure', 'urf', 'urg', 'urh', 'uri', 'urj', 'urk', 'url', 'urm', 'urn', 'uro', 'urp', 'urr', 'urt', 'uru', 'urv', 'urw', 'urx', 'ury', 'urz', 'usa', 'ush', 'usi', 'usk', 'usp', 'usu', 'uta', 'ute', 'utp', 'utr', 'utu', 'uum', 'uun', 'uur', 'uuu', 'uve', 'uvh', 'uvl', 'uwa', 'uya', 'uzn', 'uzs', 'vaa', 'vae', 'vaf', 'vag', 'vah', 'vai', 'vaj', 'val', 'vam', 'van', 'vao', 'vap', 'var', 'vas', 'vau', 'vav', 'vay', 'vbb', 'vbk', 'vec', 'ved', 'vel', 'vem', 'veo', 'vep', 'ver', 'vgr', 'vgt', 'vic', 'vid', 'vif', 'vig', 'vil', 'vin', 'vis', 'vit', 'viv', 'vka', 'vki', 'vkj', 'vkk', 'vkl', 'vkm', 'vko', 'vkp', 'vkt', 'vku', 'vlp', 'vls', 'vma', 'vmb', 'vmc', 'vmd', 'vme', 'vmf', 'vmg', 'vmh', 'vmi', 'vmj', 'vmk', 'vml', 'vmm', 'vmp', 'vmq', 'vmr', 'vms', 'vmu', 'vmv', 'vmw', 'vmx', 'vmy', 'vmz', 'vnk', 'vnm', 'vnp', 'vor', 'vot', 'vra', 'vro', 'vrs', 'vrt', 'vsi', 'vsl', 'vsv', 'vto', 'vum', 'vun', 'vut', 'vwa', 'waa', 'wab', 'wac', 'wad', 'wae', 'waf', 'wag', 'wah', 'wai', 'waj', 'wak', 'wal', 'wam', 'wan', 'wao', 'wap', 'waq', 'war', 'was', 'wat', 'wau', 'wav', 'waw', 'wax', 'way', 'waz', 'wba', 'wbb', 'wbe', 'wbf', 'wbh', 'wbi', 'wbj', 'wbk', 'wbl', 'wbm', 'wbp', 'wbq', 'wbr', 'wbs', 'wbt', 'wbv', 'wbw', 'wca', 'wci', 'wdd', 'wdg', 'wdj', 'wdk', 'wdu', 'wdy', 'wea', 'wec', 'wed', 'weg', 'weh', 'wei', 'wem', 'wen', 'weo', 'wep', 'wer', 'wes', 'wet', 'weu', 'wew', 'wfg', 'wga', 'wgb', 'wgg', 'wgi', 'wgo', 'wgu', 'wgw', 'wgy', 'wha', 'whg', 'whk', 'whu', 'wib', 'wic', 'wie', 'wif', 'wig', 'wih', 'wii', 'wij', 'wik', 'wil', 'wim', 'win', 'wir', 'wit', 'wiu', 'wiv', 'wiw', 'wiy', 'wja', 'wji', 'wka', 'wkb', 'wkd', 'wkl', 'wku', 'wkw', 'wky', 'wla', 'wlc', 'wle', 'wlg', 'wli', 'wlk', 'wll', 'wlm', 'wlo', 'wlr', 'wls', 'wlu', 'wlv', 'wlw', 'wlx', 'wly', 'wma', 'wmb', 'wmc', 'wmd', 'wme', 'wmh', 'wmi', 'wmm', 'wmn', 'wmo', 'wms', 'wmt', 'wmw', 'wmx', 'wnb', 'wnc', 'wnd', 'wne', 'wng', 'wni', 'wnk', 'wnm', 'wnn', 'wno', 'wnp', 'wnu', 'wnw', 'wny', 'woa', 'wob', 'woc', 'wod', 'woe', 'wof', 'wog', 'woi', 'wok', 'wom', 'won', 'woo', 'wor', 'wos', 'wow', 'woy', 'wpc', 'wra', 'wrb', 'wrd', 'wrg', 'wrh', 'wri', 'wrk', 'wrl', 'wrm', 'wrn', 'wro', 'wrp', 'wrr', 'wrs', 'wru', 'wrv', 'wrw', 'wrx', 'wry', 'wrz', 'wsa', 'wsg', 'wsi', 'wsk', 'wsr', 'wss', 'wsu', 'wsv', 'wtf', 'wth', 'wti', 'wtk', 'wtm', 'wtw', 'wua', 'wub', 'wud', 'wuh', 'wul', 'wum', 'wun', 'wur', 'wut', 'wuu', 'wuv', 'wux', 'wuy', 'wwa', 'wwb', 'wwo', 'wwr', 'www', 'wxa', 'wxw', 'wya', 'wyb', 'wyi', 'wym', 'wyr', 'wyy', 'xaa', 'xab', 'xac', 'xad', 'xae', 'xag', 'xai', 'xaj', 'xak', 'xal', 'xam', 'xan', 'xao', 'xap', 'xaq', 'xar', 'xas', 'xat', 'xau', 'xav', 'xaw', 'xay', 'xba', 'xbb', 'xbc', 'xbd', 'xbe', 'xbg', 'xbi', 'xbj', 'xbm', 'xbn', 'xbo', 'xbp', 'xbr', 'xbw', 'xbx', 'xby', 'xcb', 'xcc', 'xce', 'xcg', 'xch', 'xcl', 'xcm', 'xcn', 'xco', 'xcr', 'xct', 'xcu', 'xcv', 'xcw', 'xcy', 'xda', 'xdc', 'xdk', 'xdm', 'xdo', 'xdy', 'xeb', 'xed', 'xeg', 'xel', 'xem', 'xep', 'xer', 'xes', 'xet', 'xeu', 'xfa', 'xga', 'xgb', 'xgd', 'xgf', 'xgg', 'xgi', 'xgl', 'xgm', 'xgn', 'xgr', 'xgu', 'xgw', 'xha', 'xhc', 'xhd', 'xhe', 'xhr', 'xht', 'xhu', 'xhv', 'xia', 'xib', 'xii', 'xil', 'xin', 'xip', 'xir', 'xis', 'xiv', 'xiy', 'xjb', 'xjt', 'xka', 'xkb', 'xkc', 'xkd', 'xke', 'xkf', 'xkg', 'xkh', 'xki', 'xkj', 'xkk', 'xkl', 'xkn', 'xko', 'xkp', 'xkq', 'xkr', 'xks', 'xkt', 'xku', 'xkv', 'xkw', 'xkx', 'xky', 'xkz', 'xla', 'xlb', 'xlc', 'xld', 'xle', 'xlg', 'xli', 'xln', 'xlo', 'xlp', 'xls', 'xlu', 'xly', 'xma', 'xmb', 'xmc', 'xmd', 'xme', 'xmf', 'xmg', 'xmh', 'xmj', 'xmk', 'xml', 'xmm', 'xmn', 'xmo', 'xmp', 'xmq', 'xmr', 'xms', 'xmt', 'xmu', 'xmv', 'xmw', 'xmx', 'xmy', 'xmz', 'xna', 'xnb', 'xnd', 'xng', 'xnh', 'xni', 'xnk', 'xnn', 'xno', 'xnr', 'xns', 'xnt', 'xnu', 'xny', 'xnz', 'xoc', 'xod', 'xog', 'xoi', 'xok', 'xom', 'xon', 'xoo', 'xop', 'xor', 'xow', 'xpa', 'xpc', 'xpe', 'xpg', 'xpi', 'xpj', 'xpk', 'xpm', 'xpn', 'xpo', 'xpp', 'xpq', 'xpr', 'xps', 'xpt', 'xpu', 'xpy', 'xqa', 'xqt', 'xra', 'xrb', 'xrd', 'xre', 'xrg', 'xri', 'xrm', 'xrn', 'xrq', 'xrr', 'xrt', 'xru', 'xrw', 'xsa', 'xsb', 'xsc', 'xsd', 'xse', 'xsh', 'xsi', 'xsj', 'xsl', 'xsm', 'xsn', 'xso', 'xsp', 'xsq', 'xsr', 'xss', 'xsu', 'xsv', 'xsy', 'xta', 'xtb', 'xtc', 'xtd', 'xte', 'xtg', 'xth', 'xti', 'xtj', 'xtl', 'xtm', 'xtn', 'xto', 'xtp', 'xtq', 'xtr', 'xts', 'xtt', 'xtu', 'xtv', 'xtw', 'xty', 'xtz', 'xua', 'xub', 'xud', 'xug', 'xuj', 'xul', 'xum', 'xun', 'xuo', 'xup', 'xur', 'xut', 'xuu', 'xve', 'xvi', 'xvn', 'xvo', 'xvs', 'xwa', 'xwc', 'xwd', 'xwe', 'xwg', 'xwj', 'xwk', 'xwl', 'xwo', 'xwr', 'xwt', 'xww', 'xxb', 'xxk', 'xxm', 'xxr', 'xxt', 'xya', 'xyb', 'xyj', 'xyk', 'xyl', 'xyt', 'xyy', 'xzh', 'xzm', 'xzp', 'yaa', 'yab', 'yac', 'yad', 'yae', 'yaf', 'yag', 'yah', 'yai', 'yaj', 'yak', 'yal', 'yam', 'yan', 'yao', 'yap', 'yaq', 'yar', 'yas', 'yat', 'yau', 'yav', 'yaw', 'yax', 'yay', 'yaz', 'yba', 'ybb', 'ybd', 'ybe', 'ybh', 'ybi', 'ybj', 'ybk', 'ybl', 'ybm', 'ybn', 'ybo', 'ybx', 'yby', 'ych', 'ycl', 'ycn', 'ycp', 'yda', 'ydd', 'yde', 'ydg', 'ydk', 'yds', 'yea', 'yec', 'yee', 'yei', 'yej', 'yel', 'yen', 'yer', 'yes', 'yet', 'yeu', 'yev', 'yey', 'yga', 'ygi', 'ygl', 'ygm', 'ygp', 'ygr', 'ygs', 'ygu', 'ygw', 'yha', 'yhd', 'yhl', 'yhs', 'yia', 'yif', 'yig', 'yih', 'yii', 'yij', 'yik', 'yil', 'yim', 'yin', 'yip', 'yiq', 'yir', 'yis', 'yit', 'yiu', 'yiv', 'yix', 'yiy', 'yiz', 'yka', 'ykg', 'yki', 'ykk', 'ykl', 'ykm', 'ykn', 'yko', 'ykr', 'ykt', 'yku', 'yky', 'yla', 'ylb', 'yle', 'ylg', 'yli', 'yll', 'ylm', 'yln', 'ylo', 'ylr', 'ylu', 'yly', 'yma', 'ymb', 'ymc', 'ymd', 'yme', 'ymg', 'ymh', 'ymi', 'ymk', 'yml', 'ymm', 'ymn', 'ymo', 'ymp', 'ymq', 'ymr', 'yms', 'ymt', 'ymx', 'ymz', 'yna', 'ynd', 'yne', 'yng', 'ynh', 'ynk', 'ynl', 'ynn', 'yno', 'ynq', 'yns', 'ynu', 'yob', 'yog', 'yoi', 'yok', 'yol', 'yom', 'yon', 'yos', 'yot', 'yox', 'yoy', 'ypa', 'ypb', 'ypg', 'yph', 'ypk', 'ypm', 'ypn', 'ypo', 'ypp', 'ypz', 'yra', 'yrb', 'yre', 'yri', 'yrk', 'yrl', 'yrm', 'yrn', 'yro', 'yrs', 'yrw', 'yry', 'ysc', 'ysd', 'ysg', 'ysl', 'ysn', 'yso', 'ysp', 'ysr', 'yss', 'ysy', 'yta', 'ytl', 'ytp', 'ytw', 'yty', 'yua', 'yub', 'yuc', 'yud', 'yue', 'yuf', 'yug', 'yui', 'yuj', 'yuk', 'yul', 'yum', 'yun', 'yup', 'yuq', 'yur', 'yut', 'yuu', 'yuw', 'yux', 'yuy', 'yuz', 'yva', 'yvt', 'ywa', 'ywg', 'ywl', 'ywn', 'ywq', 'ywr', 'ywt', 'ywu', 'yww', 'yxa', 'yxg', 'yxl', 'yxm', 'yxu', 'yxy', 'yyr', 'yyu', 'yyz', 'yzg', 'yzk', 'zaa', 'zab', 'zac', 'zad', 'zae', 'zaf', 'zag', 'zah', 'zai', 'zaj', 'zak', 'zal', 'zam', 'zao', 'zap', 'zaq', 'zar', 'zas', 'zat', 'zau', 'zav', 'zaw', 'zax', 'zay', 'zaz', 'zbc', 'zbe', 'zbl', 'zbt', 'zbw', 'zca', 'zch', 'zdj', 'zea', 'zeg', 'zeh', 'zen', 'zga', 'zgb', 'zgh', 'zgm', 'zgn', 'zgr', 'zhb', 'zhd', 'zhi', 'zhn', 'zhw', 'zhx', 'zia', 'zib', 'zik', 'zil', 'zim', 'zin', 'zir', 'ziw', 'ziz', 'zka', 'zkb', 'zkd', 'zkg', 'zkh', 'zkk', 'zkn', 'zko', 'zkp', 'zkr', 'zkt', 'zku', 'zkv', 'zkz', 'zle', 'zlj', 'zlm', 'zln', 'zlq', 'zls', 'zlw', 'zma', 'zmb', 'zmc', 'zmd', 'zme', 'zmf', 'zmg', 'zmh', 'zmi', 'zmj', 'zmk', 'zml', 'zmm', 'zmn', 'zmo', 'zmp', 'zmq', 'zmr', 'zms', 'zmt', 'zmu', 'zmv', 'zmw', 'zmx', 'zmy', 'zmz', 'zna', 'znd', 'zne', 'zng', 'znk', 'zns', 'zoc', 'zoh', 'zom', 'zoo', 'zoq', 'zor', 'zos', 'zpa', 'zpb', 'zpc', 'zpd', 'zpe', 'zpf', 'zpg', 'zph', 'zpi', 'zpj', 'zpk', 'zpl', 'zpm', 'zpn', 'zpo', 'zpp', 'zpq', 'zpr', 'zps', 'zpt', 'zpu', 'zpv', 'zpw', 'zpx', 'zpy', 'zpz', 'zqe', 'zra', 'zrg', 'zrn', 'zro', 'zrp', 'zrs', 'zsa', 'zsk', 'zsl', 'zsm', 'zsr', 'zsu', 'zte', 'ztg', 'ztl', 'ztm', 'ztn', 'ztp', 'ztq', 'zts', 'ztt', 'ztu', 'ztx', 'zty', 'zua', 'zuh', 'zum', 'zun', 'zuy', 'zwa', 'zxx', 'zyb', 'zyg', 'zyj', 'zyn', 'zyp', 'zza', 'zzj' ];
      function validLangs() {
        return langs;
      }
      __webpack_exports__['default'] = validLangs;
    },
    './lib/rules/aria-allowed-attr-matches.js': function libRulesAriaAllowedAttrMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function ariaAllowedAttrMatches(node) {
        var aria = /^aria-/;
        if (node.hasAttributes()) {
          var attrs = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['getNodeAttributes'])(node);
          for (var i = 0, l = attrs.length; i < l; i++) {
            if (aria.test(attrs[i].name)) {
              return true;
            }
          }
        }
        return false;
      }
      __webpack_exports__['default'] = ariaAllowedAttrMatches;
    },
    './lib/rules/aria-allowed-role-matches.js': function libRulesAriaAllowedRoleMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      function ariaAllowedRoleMatches(node) {
        return Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['getExplicitRole'])(node, {
          dpub: true,
          fallback: true
        }) !== null;
      }
      __webpack_exports__['default'] = ariaAllowedRoleMatches;
    },
    './lib/rules/aria-form-field-name-matches.js': function libRulesAriaFormFieldNameMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function ariaFormFieldNameMatches(node, virtualNode) {
        var nodeName = virtualNode.props.nodeName;
        var role = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['getExplicitRole'])(virtualNode);
        if (nodeName === 'area' && !!virtualNode.attr('href')) {
          return false;
        }
        if ([ 'input', 'select', 'textarea' ].includes(nodeName)) {
          return false;
        }
        if (nodeName === 'img' || role === 'img' && nodeName !== 'svg') {
          return false;
        }
        if (nodeName === 'button' || role === 'button') {
          return false;
        }
        if (role === 'combobox' && Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['querySelectorAll'])(virtualNode, 'input:not([type="hidden"])').length) {
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = ariaFormFieldNameMatches;
    },
    './lib/rules/aria-has-attr-matches.js': function libRulesAriaHasAttrMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function ariaHasAttrMatches(node) {
        var aria = /^aria-/;
        if (node.hasAttributes()) {
          var attrs = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['getNodeAttributes'])(node);
          for (var i = 0, l = attrs.length; i < l; i++) {
            if (aria.test(attrs[i].name)) {
              return true;
            }
          }
        }
        return false;
      }
      __webpack_exports__['default'] = ariaHasAttrMatches;
    },
    './lib/rules/aria-hidden-focus-matches.js': function libRulesAriaHiddenFocusMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      function shouldMatchElement(el) {
        if (!el) {
          return true;
        }
        if (el.getAttribute('aria-hidden') === 'true') {
          return false;
        }
        return shouldMatchElement(Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getComposedParent'])(el));
      }
      function ariaHiddenFocusMatches(node) {
        return shouldMatchElement(Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getComposedParent'])(node));
      }
      __webpack_exports__['default'] = ariaHiddenFocusMatches;
    },
    './lib/rules/autocomplete-matches.js': function libRulesAutocompleteMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      var _standards__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/standards/index.js');
      var _commons_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/dom/index.js');
      function autocompleteMatches(node, virtualNode) {
        var autocomplete = virtualNode.attr('autocomplete');
        if (!autocomplete || Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['sanitize'])(autocomplete) === '') {
          return false;
        }
        var nodeName = virtualNode.props.nodeName;
        if ([ 'textarea', 'input', 'select' ].includes(nodeName) === false) {
          return false;
        }
        var excludedInputTypes = [ 'submit', 'reset', 'button', 'hidden' ];
        if (nodeName === 'input' && excludedInputTypes.includes(virtualNode.props.type)) {
          return false;
        }
        var ariaDisabled = virtualNode.attr('aria-disabled') || 'false';
        if (virtualNode.hasAttr('disabled') || ariaDisabled.toLowerCase() === 'true') {
          return false;
        }
        var role = virtualNode.attr('role');
        var tabIndex = virtualNode.attr('tabindex');
        if (tabIndex === '-1' && role) {
          var roleDef = _standards__WEBPACK_IMPORTED_MODULE_1__['default'].ariaRoles[role];
          if (roleDef === undefined || roleDef.type !== 'widget') {
            return false;
          }
        }
        if (tabIndex === '-1' && virtualNode.actualNode && !Object(_commons_dom__WEBPACK_IMPORTED_MODULE_2__['isVisible'])(virtualNode.actualNode, false) && !Object(_commons_dom__WEBPACK_IMPORTED_MODULE_2__['isVisible'])(virtualNode.actualNode, true)) {
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = autocompleteMatches;
    },
    './lib/rules/bypass-matches.js': function libRulesBypassMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _window_is_top_matches__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/rules/window-is-top-matches.js');
      function bypassMatches(node) {
        if (Object(_window_is_top_matches__WEBPACK_IMPORTED_MODULE_0__['default'])(node)) {
          return !!node.querySelector('a[href]');
        }
        return true;
      }
      __webpack_exports__['default'] = bypassMatches;
    },
    './lib/rules/color-contrast-matches.js': function libRulesColorContrastMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/text/index.js');
      var _commons_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/forms/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/core/utils/index.js');
      function colorContrastMatches(node, virtualNode) {
        var _virtualNode$props = virtualNode.props, nodeName = _virtualNode$props.nodeName, inputType = _virtualNode$props.type;
        if (nodeName === 'option') {
          return false;
        }
        if (nodeName === 'select' && !node.options.length) {
          return false;
        }
        var nonTextInput = [ 'hidden', 'range', 'color', 'checkbox', 'radio', 'image' ];
        if (nodeName === 'input' && nonTextInput.includes(inputType)) {
          return false;
        }
        if (Object(_commons_forms__WEBPACK_IMPORTED_MODULE_2__['isDisabled'])(virtualNode)) {
          return false;
        }
        var formElements = [ 'input', 'select', 'textarea' ];
        if (formElements.includes(nodeName)) {
          var style = window.getComputedStyle(node);
          var textIndent = parseInt(style.getPropertyValue('text-indent'), 10);
          if (textIndent) {
            var rect = node.getBoundingClientRect();
            rect = {
              top: rect.top,
              bottom: rect.bottom,
              left: rect.left + textIndent,
              right: rect.right + textIndent
            };
            if (!Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['visuallyOverlaps'])(rect, node)) {
              return false;
            }
          }
          return true;
        }
        var nodeParentLabel = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['findUpVirtual'])(virtualNode, 'label');
        if (nodeName === 'label' || nodeParentLabel) {
          var labelNode = nodeParentLabel || node;
          var labelVirtual = nodeParentLabel ? Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['getNodeFromTree'])(nodeParentLabel) : virtualNode;
          var doc = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getRootNode'])(labelNode);
          var explicitControl = doc.getElementById(labelNode.htmlFor || '');
          var explicitControlVirtual = explicitControl && Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['getNodeFromTree'])(explicitControl);
          if (explicitControlVirtual && Object(_commons_forms__WEBPACK_IMPORTED_MODULE_2__['isDisabled'])(explicitControlVirtual)) {
            return false;
          }
          var query = 'input:not([type="hidden"]):not([type="image"])' + ':not([type="button"]):not([type="submit"]):not([type="reset"]), select, textarea';
          var implicitControl = Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['querySelectorAll'])(labelVirtual, query)[0];
          if (implicitControl && Object(_commons_forms__WEBPACK_IMPORTED_MODULE_2__['isDisabled'])(implicitControl)) {
            return false;
          }
        }
        var ariaLabelledbyControls = [];
        var ancestorNode = virtualNode;
        while (ancestorNode) {
          if (ancestorNode.props.id) {
            var _doc = Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getRootNode'])(node);
            var escapedId = Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['escapeSelector'])(ancestorNode.props.id);
            var controls = Array.from(_doc.querySelectorAll('[aria-labelledby~="'.concat(escapedId, '"]')));
            var virtualControls = controls.map(function(control) {
              return Object(_core_utils__WEBPACK_IMPORTED_MODULE_3__['getNodeFromTree'])(control);
            });
            ariaLabelledbyControls.push.apply(ariaLabelledbyControls, _toConsumableArray(virtualControls));
          }
          ancestorNode = ancestorNode.parent;
        }
        if (ariaLabelledbyControls.length > 0 && ariaLabelledbyControls.every(_commons_forms__WEBPACK_IMPORTED_MODULE_2__['isDisabled'])) {
          return false;
        }
        var visibleText = Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['visibleVirtual'])(virtualNode, false, true);
        var removeUnicodeOptions = {
          emoji: true,
          nonBmp: false,
          punctuations: true
        };
        if (!visibleText || !Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['removeUnicode'])(visibleText, removeUnicodeOptions)) {
          return false;
        }
        var range = document.createRange();
        var childNodes = virtualNode.children;
        for (var index = 0; index < childNodes.length; index++) {
          var child = childNodes[index];
          if (child.actualNode.nodeType === 3 && Object(_commons_text__WEBPACK_IMPORTED_MODULE_1__['sanitize'])(child.actualNode.nodeValue) !== '') {
            range.selectNodeContents(child.actualNode);
          }
        }
        var rects = range.getClientRects();
        for (var _index = 0; _index < rects.length; _index++) {
          if (Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['visuallyOverlaps'])(rects[_index], node)) {
            return true;
          }
        }
        return false;
      }
      __webpack_exports__['default'] = colorContrastMatches;
    },
    './lib/rules/data-table-large-matches.js': function libRulesDataTableLargeMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/table/index.js');
      function dataTableLargeMatches(node) {
        if (Object(_commons_table__WEBPACK_IMPORTED_MODULE_0__['isDataTable'])(node)) {
          var tableArray = Object(_commons_table__WEBPACK_IMPORTED_MODULE_0__['toArray'])(node);
          return tableArray.length >= 3 && tableArray[0].length >= 3 && tableArray[1].length >= 3 && tableArray[2].length >= 3;
        }
        return false;
      }
      __webpack_exports__['default'] = dataTableLargeMatches;
    },
    './lib/rules/data-table-matches.js': function libRulesDataTableMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/table/index.js');
      function dataTableMatches(node) {
        return Object(_commons_table__WEBPACK_IMPORTED_MODULE_0__['isDataTable'])(node);
      }
      __webpack_exports__['default'] = dataTableMatches;
    },
    './lib/rules/duplicate-id-active-matches.js': function libRulesDuplicateIdActiveMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function duplicateIdActiveMatches(node) {
        var id = node.getAttribute('id').trim();
        var idSelector = '*[id="'.concat(Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['escapeSelector'])(id), '"]');
        var idMatchingElms = Array.from(Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getRootNode'])(node).querySelectorAll(idSelector));
        return !Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['isAccessibleRef'])(node) && idMatchingElms.some(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isFocusable']);
      }
      __webpack_exports__['default'] = duplicateIdActiveMatches;
    },
    './lib/rules/duplicate-id-aria-matches.js': function libRulesDuplicateIdAriaMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      function duplicateIdAriaMatches(node) {
        return Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['isAccessibleRef'])(node);
      }
      __webpack_exports__['default'] = duplicateIdAriaMatches;
    },
    './lib/rules/duplicate-id-misc-matches.js': function libRulesDuplicateIdMiscMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/core/utils/index.js');
      function duplicateIdMiscMatches(node) {
        var id = node.getAttribute('id').trim();
        var idSelector = '*[id="'.concat(Object(_core_utils__WEBPACK_IMPORTED_MODULE_2__['escapeSelector'])(id), '"]');
        var idMatchingElms = Array.from(Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['getRootNode'])(node).querySelectorAll(idSelector));
        return !Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['isAccessibleRef'])(node) && idMatchingElms.every(function(elm) {
          return !Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isFocusable'])(elm);
        });
      }
      __webpack_exports__['default'] = duplicateIdMiscMatches;
    },
    './lib/rules/frame-title-has-text-matches.js': function libRulesFrameTitleHasTextMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      function frameTitleHasTextMatches(node) {
        var title = node.getAttribute('title');
        return !!(title ? Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['sanitize'])(title).trim() : '');
      }
      __webpack_exports__['default'] = frameTitleHasTextMatches;
    },
    './lib/rules/heading-matches.js': function libRulesHeadingMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function headingMatches(node) {
        var explicitRoles;
        if (node.hasAttribute('role')) {
          explicitRoles = node.getAttribute('role').split(/\s+/i).filter(axe.commons.aria.isValidRole);
        }
        if (explicitRoles && explicitRoles.length > 0) {
          return explicitRoles.includes('heading');
        } else {
          return axe.commons.aria.implicitRole(node) === 'heading';
        }
      }
      __webpack_exports__['default'] = headingMatches;
    },
    './lib/rules/html-namespace-matches.js': function libRulesHtmlNamespaceMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _svg_namespace_matches__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/rules/svg-namespace-matches.js');
      function htmlNamespaceMatches(node, virtualNode) {
        return !Object(_svg_namespace_matches__WEBPACK_IMPORTED_MODULE_0__['default'])(node, virtualNode);
      }
      __webpack_exports__['default'] = htmlNamespaceMatches;
    },
    './lib/rules/identical-links-same-purpose-matches.js': function libRulesIdenticalLinksSamePurposeMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/index.js');
      function identicalLinksSamePurposeMatches(node, virtualNode) {
        var hasAccName = !!Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['accessibleTextVirtual'])(virtualNode);
        if (!hasAccName) {
          return false;
        }
        var role = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['getRole'])(node);
        if (role && role !== 'link') {
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = identicalLinksSamePurposeMatches;
    },
    './lib/rules/inserted-into-focus-order-matches.js': function libRulesInsertedIntoFocusOrderMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      function insertedIntoFocusOrderMatches(node) {
        return Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['insertedIntoFocusOrder'])(node);
      }
      __webpack_exports__['default'] = insertedIntoFocusOrderMatches;
    },
    './lib/rules/label-content-name-mismatch-matches.js': function libRulesLabelContentNameMismatchMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_aria__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/aria/index.js');
      var _commons_standards__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/standards/index.js');
      var _commons_text__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/text/index.js');
      function labelContentNameMismatchMatches(node, virtualNode) {
        var role = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['getRole'])(node);
        if (!role) {
          return false;
        }
        var widgetRoles = Object(_commons_standards__WEBPACK_IMPORTED_MODULE_1__['getAriaRolesByType'])('widget');
        var isWidgetType = widgetRoles.includes(role);
        if (!isWidgetType) {
          return false;
        }
        var rolesWithNameFromContents = Object(_commons_standards__WEBPACK_IMPORTED_MODULE_1__['getAriaRolesSupportingNameFromContent'])();
        if (!rolesWithNameFromContents.includes(role)) {
          return false;
        }
        if (!Object(_commons_text__WEBPACK_IMPORTED_MODULE_2__['sanitize'])(Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['arialabelText'])(virtualNode)) && !Object(_commons_text__WEBPACK_IMPORTED_MODULE_2__['sanitize'])(Object(_commons_aria__WEBPACK_IMPORTED_MODULE_0__['arialabelledbyText'])(node))) {
          return false;
        }
        if (!Object(_commons_text__WEBPACK_IMPORTED_MODULE_2__['sanitize'])(Object(_commons_text__WEBPACK_IMPORTED_MODULE_2__['visibleVirtual'])(virtualNode))) {
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = labelContentNameMismatchMatches;
    },
    './lib/rules/label-matches.js': function libRulesLabelMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function labelMatches(node, virtualNode) {
        if (virtualNode.props.nodeName !== 'input' || virtualNode.hasAttr('type') === false) {
          return true;
        }
        var type = virtualNode.attr('type').toLowerCase();
        return [ 'hidden', 'image', 'button', 'submit', 'reset' ].includes(type) === false;
      }
      __webpack_exports__['default'] = labelMatches;
    },
    './lib/rules/landmark-has-body-context-matches.js': function libRulesLandmarkHasBodyContextMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      function landmarkHasBodyContextMatches(node, virtualNode) {
        var nativeScopeFilter = 'article, aside, main, nav, section';
        return node.hasAttribute('role') || !Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['findUpVirtual'])(virtualNode, nativeScopeFilter);
      }
      __webpack_exports__['default'] = landmarkHasBodyContextMatches;
    },
    './lib/rules/landmark-unique-matches.js': function libRulesLandmarkUniqueMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _commons_aria__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/aria/index.js');
      var _commons_standards__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/commons/standards/index.js');
      var _commons_text__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/commons/text/index.js');
      function landmarkUniqueMatches(node, virtualNode) {
        var excludedParentsForHeaderFooterLandmarks = [ 'article', 'aside', 'main', 'nav', 'section' ].join(',');
        function isHeaderFooterLandmark(headerFooterElement) {
          return !Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['findUpVirtual'])(headerFooterElement, excludedParentsForHeaderFooterLandmarks);
        }
        function isLandmarkVirtual(virtualNode) {
          var actualNode = virtualNode.actualNode;
          var landmarkRoles = Object(_commons_standards__WEBPACK_IMPORTED_MODULE_2__['getAriaRolesByType'])('landmark');
          var role = Object(_commons_aria__WEBPACK_IMPORTED_MODULE_1__['getRole'])(actualNode);
          if (!role) {
            return false;
          }
          var nodeName = actualNode.nodeName.toUpperCase();
          if (nodeName === 'HEADER' || nodeName === 'FOOTER') {
            return isHeaderFooterLandmark(virtualNode);
          }
          if (nodeName === 'SECTION' || nodeName === 'FORM') {
            var accessibleText = Object(_commons_text__WEBPACK_IMPORTED_MODULE_3__['accessibleTextVirtual'])(virtualNode);
            return !!accessibleText;
          }
          return landmarkRoles.indexOf(role) >= 0 || role === 'region';
        }
        return isLandmarkVirtual(virtualNode) && Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isVisible'])(node, true);
      }
      __webpack_exports__['default'] = landmarkUniqueMatches;
    },
    './lib/rules/layout-table-matches.js': function libRulesLayoutTableMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/table/index.js');
      var _commons_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/index.js');
      function dataTableMatches(node) {
        return !Object(_commons_table__WEBPACK_IMPORTED_MODULE_0__['isDataTable'])(node) && !Object(_commons_dom__WEBPACK_IMPORTED_MODULE_1__['isFocusable'])(node);
      }
      __webpack_exports__['default'] = dataTableMatches;
    },
    './lib/rules/link-in-text-block-matches.js': function libRulesLinkInTextBlockMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/text/index.js');
      var _commons_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/commons/dom/index.js');
      function linkInTextBlockMatches(node) {
        var text = Object(_commons_text__WEBPACK_IMPORTED_MODULE_0__['sanitize'])(node.textContent);
        var role = node.getAttribute('role');
        if (role && role !== 'link') {
          return false;
        }
        if (!text) {
          return false;
        }
        if (!Object(_commons_dom__WEBPACK_IMPORTED_MODULE_1__['isVisible'])(node, false)) {
          return false;
        }
        return Object(_commons_dom__WEBPACK_IMPORTED_MODULE_1__['isInTextBlock'])(node);
      }
      __webpack_exports__['default'] = linkInTextBlockMatches;
    },
    './lib/rules/no-autoplay-audio-matches.js': function libRulesNoAutoplayAudioMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function noAutoplayAudioMatches(node) {
        if (!node.currentSrc) {
          return false;
        }
        if (node.hasAttribute('paused') || node.hasAttribute('muted')) {
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = noAutoplayAudioMatches;
    },
    './lib/rules/no-empty-role-matches.js': function libRulesNoEmptyRoleMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function noEmptyRoleMatches(node, virtualNode) {
        if (!virtualNode.hasAttr('role')) {
          return false;
        }
        if (!virtualNode.attr('role').trim()) {
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = noEmptyRoleMatches;
    },
    './lib/rules/no-role-matches.js': function libRulesNoRoleMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function noRoleMatches(node) {
        return !node.getAttribute('role');
      }
      __webpack_exports__['default'] = noRoleMatches;
    },
    './lib/rules/not-html-matches.js': function libRulesNotHtmlMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function notHtmlMatches(node) {
        return node.nodeName.toLowerCase() !== 'html';
      }
      __webpack_exports__['default'] = notHtmlMatches;
    },
    './lib/rules/p-as-heading-matches.js': function libRulesPAsHeadingMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function pAsHeadingMatches(node) {
        var children = Array.from(node.parentNode.childNodes);
        var nodeText = node.textContent.trim();
        var isSentence = /[.!?:;](?![.!?:;])/g;
        if (nodeText.length === 0 || (nodeText.match(isSentence) || []).length >= 2) {
          return false;
        }
        var siblingsAfter = children.slice(children.indexOf(node) + 1).filter(function(elm) {
          return elm.nodeName.toUpperCase() === 'P' && elm.textContent.trim() !== '';
        });
        return siblingsAfter.length !== 0;
      }
      __webpack_exports__['default'] = pAsHeadingMatches;
    },
    './lib/rules/scrollable-region-focusable-matches.js': function libRulesScrollableRegionFocusableMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/core/utils/index.js');
      function scrollableRegionFocusableMatches(node, virtualNode) {
        if (!!Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['getScroll'])(node, 13) === false) {
          return false;
        }
        var nodeAndDescendents = Object(_core_utils__WEBPACK_IMPORTED_MODULE_1__['querySelectorAll'])(virtualNode, '*');
        var hasVisibleChildren = nodeAndDescendents.some(function(elm) {
          return Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['hasContentVirtual'])(elm, true, true);
        });
        if (!hasVisibleChildren) {
          return false;
        }
        return true;
      }
      __webpack_exports__['default'] = scrollableRegionFocusableMatches;
    },
    './lib/rules/skip-link-matches.js': function libRulesSkipLinkMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _commons_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/commons/dom/index.js');
      function skipLinkMatches(node) {
        return Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isSkipLink'])(node) && Object(_commons_dom__WEBPACK_IMPORTED_MODULE_0__['isOffscreen'])(node);
      }
      __webpack_exports__['default'] = skipLinkMatches;
    },
    './lib/rules/svg-namespace-matches.js': function libRulesSvgNamespaceMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function svgNamespaceMatches(node, virtualNode) {
        try {
          var nodeName = virtualNode.props.nodeName;
          if (nodeName === 'svg') {
            return true;
          }
          return !!Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['closest'])(virtualNode, 'svg');
        } catch (e) {
          return false;
        }
      }
      __webpack_exports__['default'] = svgNamespaceMatches;
    },
    './lib/rules/window-is-top-matches.js': function libRulesWindowIsTopMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      function windowIsTopMatches(node) {
        return node.ownerDocument.defaultView.self === node.ownerDocument.defaultView.top;
      }
      __webpack_exports__['default'] = windowIsTopMatches;
    },
    './lib/rules/xml-lang-mismatch-matches.js': function libRulesXmlLangMismatchMatchesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var _core_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/core/utils/index.js');
      function xmlLangMismatchMatches(node) {
        var primaryLangValue = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['getBaseLang'])(node.getAttribute('lang'));
        var primaryXmlLangValue = Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['getBaseLang'])(node.getAttribute('xml:lang'));
        return Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['validLangs'])().includes(primaryLangValue) && Object(_core_utils__WEBPACK_IMPORTED_MODULE_0__['validLangs'])().includes(primaryXmlLangValue);
      }
      __webpack_exports__['default'] = xmlLangMismatchMatches;
    },
    './lib/standards/aria-attrs.js': function libStandardsAriaAttrsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var ariaAttrs = {
        'aria-activedescendant': {
          type: 'idref',
          allowEmpty: true
        },
        'aria-atomic': {
          type: 'boolean',
          global: true
        },
        'aria-autocomplete': {
          type: 'nmtoken',
          values: [ 'inline', 'list', 'both', 'none' ]
        },
        'aria-busy': {
          type: 'boolean',
          global: true
        },
        'aria-checked': {
          type: 'nmtoken',
          values: [ 'false', 'mixed', 'true', 'undefined' ]
        },
        'aria-colcount': {
          type: 'int'
        },
        'aria-colindex': {
          type: 'int'
        },
        'aria-colspan': {
          type: 'int'
        },
        'aria-controls': {
          type: 'idrefs',
          allowEmpty: true,
          global: true
        },
        'aria-current': {
          type: 'nmtoken',
          allowEmpty: true,
          values: [ 'page', 'step', 'location', 'date', 'time', 'true', 'false' ],
          global: true
        },
        'aria-describedby': {
          type: 'idrefs',
          allowEmpty: true,
          global: true
        },
        'aria-details': {
          type: 'idref',
          allowEmpty: true,
          global: true
        },
        'aria-disabled': {
          type: 'boolean',
          global: true
        },
        'aria-dropeffect': {
          type: 'nmtokens',
          values: [ 'copy', 'execute', 'link', 'move', 'none', 'popup' ],
          global: true
        },
        'aria-errormessage': {
          type: 'idref',
          allowEmpty: true,
          global: true
        },
        'aria-expanded': {
          type: 'nmtoken',
          values: [ 'true', 'false', 'undefined' ]
        },
        'aria-flowto': {
          type: 'idrefs',
          allowEmpty: true,
          global: true
        },
        'aria-grabbed': {
          type: 'nmtoken',
          values: [ 'true', 'false', 'undefined' ],
          global: true
        },
        'aria-haspopup': {
          type: 'nmtoken',
          allowEmpty: true,
          values: [ 'true', 'false', 'menu', 'listbox', 'tree', 'grid', 'dialog' ],
          global: true
        },
        'aria-hidden': {
          type: 'nmtoken',
          values: [ 'true', 'false', 'undefined' ],
          global: true
        },
        'aria-invalid': {
          type: 'nmtoken',
          allowEmpty: true,
          values: [ 'grammar', 'false', 'spelling', 'true' ],
          global: true
        },
        'aria-keyshortcuts': {
          type: 'string',
          allowEmpty: true,
          global: true
        },
        'aria-label': {
          type: 'string',
          allowEmpty: true,
          global: true
        },
        'aria-labelledby': {
          type: 'idrefs',
          allowEmpty: true,
          global: true
        },
        'aria-level': {
          type: 'int'
        },
        'aria-live': {
          type: 'nmtoken',
          values: [ 'assertive', 'off', 'polite' ],
          global: true
        },
        'aria-modal': {
          type: 'boolean'
        },
        'aria-multiline': {
          type: 'boolean'
        },
        'aria-multiselectable': {
          type: 'boolean'
        },
        'aria-orientation': {
          type: 'nmtoken',
          values: [ 'horizontal', 'undefined', 'vertical' ]
        },
        'aria-owns': {
          type: 'idrefs',
          allowEmpty: true,
          global: true
        },
        'aria-placeholder': {
          type: 'string',
          allowEmpty: true
        },
        'aria-posinset': {
          type: 'int'
        },
        'aria-pressed': {
          type: 'nmtoken',
          values: [ 'false', 'mixed', 'true', 'undefined' ]
        },
        'aria-readonly': {
          type: 'boolean'
        },
        'aria-relevant': {
          type: 'nmtokens',
          values: [ 'additions', 'all', 'removals', 'text' ],
          global: true
        },
        'aria-required': {
          type: 'boolean'
        },
        'aria-roledescription': {
          type: 'string',
          allowEmpty: true,
          global: true
        },
        'aria-rowcount': {
          type: 'int'
        },
        'aria-rowindex': {
          type: 'int'
        },
        'aria-rowspan': {
          type: 'int'
        },
        'aria-selected': {
          type: 'nmtoken',
          values: [ 'false', 'true', 'undefined' ]
        },
        'aria-setsize': {
          type: 'int'
        },
        'aria-sort': {
          type: 'nmtoken',
          values: [ 'ascending', 'descending', 'none', 'other' ]
        },
        'aria-valuemax': {
          type: 'decimal'
        },
        'aria-valuemin': {
          type: 'decimal'
        },
        'aria-valuenow': {
          type: 'decimal'
        },
        'aria-valuetext': {
          type: 'string'
        }
      };
      __webpack_exports__['default'] = ariaAttrs;
    },
    './lib/standards/aria-roles.js': function libStandardsAriaRolesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var ariaRoles = {
        alert: {
          type: 'widget',
          allowedAttrs: [ 'aria-expanded' ]
        },
        alertdialog: {
          type: 'widget',
          allowedAttrs: [ 'aria-expanded', 'aria-modal' ]
        },
        application: {
          type: 'landmark',
          allowedAttrs: [ 'aria-activedescendant', 'aria-expanded' ]
        },
        article: {
          type: 'structure',
          allowedAttrs: [ 'aria-posinset', 'aria-setsize', 'aria-expanded' ]
        },
        banner: {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        button: {
          type: 'widget',
          allowedAttrs: [ 'aria-expanded', 'aria-pressed' ],
          nameFromContent: true
        },
        cell: {
          type: 'structure',
          requiredContext: [ 'row' ],
          allowedAttrs: [ 'aria-colindex', 'aria-colspan', 'aria-rowindex', 'aria-rowspan', 'aria-expanded' ],
          nameFromContent: true
        },
        checkbox: {
          type: 'widget',
          allowedAttrs: [ 'aria-checked', 'aria-readonly', 'aria-required' ],
          nameFromContent: true
        },
        columnheader: {
          type: 'structure',
          requiredContext: [ 'row' ],
          allowedAttrs: [ 'aria-sort', 'aria-colindex', 'aria-colspan', 'aria-expanded', 'aria-readonly', 'aria-required', 'aria-rowindex', 'aria-rowspan', 'aria-selected' ],
          nameFromContent: true
        },
        combobox: {
          type: 'composite',
          requiredOwned: [ 'listbox', 'tree', 'grid', 'dialog', 'textbox' ],
          requiredAttrs: [ 'aria-expanded' ],
          allowedAttrs: [ 'aria-controls', 'aria-autocomplete', 'aria-readonly', 'aria-required', 'aria-activedescendant', 'aria-orientation' ]
        },
        command: {
          type: 'abstract'
        },
        complementary: {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        composite: {
          type: 'abstract'
        },
        contentinfo: {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        definition: {
          type: 'structure',
          allowedAttrs: [ 'aria-expanded' ]
        },
        dialog: {
          type: 'widget',
          allowedAttrs: [ 'aria-expanded', 'aria-modal' ]
        },
        directory: {
          type: 'structure',
          allowedAttrs: [ 'aria-expanded' ],
          nameFromContent: true
        },
        document: {
          type: 'structure',
          allowedAttrs: [ 'aria-expanded' ]
        },
        feed: {
          type: 'structure',
          requiredOwned: [ 'article' ],
          allowedAttrs: [ 'aria-expanded' ]
        },
        figure: {
          type: 'structure',
          allowedAttrs: [ 'aria-expanded' ],
          nameFromContent: true
        },
        form: {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        grid: {
          type: 'composite',
          requiredOwned: [ 'rowgroup', 'row' ],
          allowedAttrs: [ 'aria-level', 'aria-multiselectable', 'aria-readonly', 'aria-activedescendant', 'aria-colcount', 'aria-expanded', 'aria-rowcount' ]
        },
        gridcell: {
          type: 'widget',
          requiredContext: [ 'row' ],
          allowedAttrs: [ 'aria-readonly', 'aria-required', 'aria-selected', 'aria-colindex', 'aria-colspan', 'aria-expanded', 'aria-rowindex', 'aria-rowspan' ],
          nameFromContent: true
        },
        group: {
          type: 'structure',
          allowedAttrs: [ 'aria-activedescendant', 'aria-expanded' ]
        },
        heading: {
          type: 'structure',
          requiredAttrs: [ 'aria-level' ],
          allowedAttrs: [ 'aria-expanded' ],
          nameFromContent: true
        },
        img: {
          type: 'structure',
          allowedAttrs: [ 'aria-expanded' ]
        },
        input: {
          type: 'abstract'
        },
        landmark: {
          type: 'abstract'
        },
        link: {
          type: 'widget',
          allowedAttrs: [ 'aria-expanded' ],
          nameFromContent: true
        },
        list: {
          type: 'structure',
          requiredOwned: [ 'listitem' ],
          allowedAttrs: [ 'aria-expanded' ]
        },
        listbox: {
          type: 'composite',
          requiredOwned: [ 'option' ],
          allowedAttrs: [ 'aria-multiselectable', 'aria-readonly', 'aria-required', 'aria-activedescendant', 'aria-expanded', 'aria-orientation' ]
        },
        listitem: {
          type: 'structure',
          requiredContext: [ 'list' ],
          allowedAttrs: [ 'aria-level', 'aria-posinset', 'aria-setsize', 'aria-expanded' ],
          nameFromContent: true
        },
        log: {
          type: 'widget',
          allowedAttrs: [ 'aria-expanded' ]
        },
        main: {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        marquee: {
          type: 'widget',
          allowedAttrs: [ 'aria-expanded' ]
        },
        math: {
          type: 'structure',
          allowedAttrs: [ 'aria-expanded' ]
        },
        menu: {
          type: 'composite',
          requiredOwned: [ 'menuitemradio', 'menuitem', 'menuitemcheckbox' ],
          allowedAttrs: [ 'aria-activedescendant', 'aria-expanded', 'aria-orientation' ]
        },
        menubar: {
          type: 'composite',
          requiredOwned: [ 'menuitemradio', 'menuitem', 'menuitemcheckbox' ],
          allowedAttrs: [ 'aria-activedescendant', 'aria-expanded', 'aria-orientation' ]
        },
        menuitem: {
          type: 'widget',
          requiredContext: [ 'menu', 'menubar' ],
          allowedAttrs: [ 'aria-posinset', 'aria-setsize', 'aria-expanded' ],
          nameFromContent: true
        },
        menuitemcheckbox: {
          type: 'widget',
          requiredContext: [ 'menu', 'menubar' ],
          allowedAttrs: [ 'aria-checked', 'aria-posinset', 'aria-readonly', 'aria-setsize' ],
          nameFromContent: true
        },
        menuitemradio: {
          type: 'widget',
          requiredContext: [ 'menu', 'menubar' ],
          allowedAttrs: [ 'aria-checked', 'aria-posinset', 'aria-readonly', 'aria-setsize' ],
          nameFromContent: true
        },
        navigation: {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        none: {
          type: 'structure'
        },
        note: {
          type: 'structure',
          allowedAttrs: [ 'aria-expanded' ]
        },
        option: {
          type: 'widget',
          requiredContext: [ 'listbox' ],
          allowedAttrs: [ 'aria-selected', 'aria-checked', 'aria-posinset', 'aria-setsize' ],
          nameFromContent: true
        },
        presentation: {
          type: 'structure'
        },
        progressbar: {
          type: 'widget',
          allowedAttrs: [ 'aria-expanded', 'aria-valuemax', 'aria-valuemin', 'aria-valuenow', 'aria-valuetext' ]
        },
        radio: {
          type: 'widget',
          allowedAttrs: [ 'aria-checked', 'aria-posinset', 'aria-setsize', 'aria-required' ],
          nameFromContent: true
        },
        radiogroup: {
          type: 'composite',
          requiredOwned: [ 'radio' ],
          allowedAttrs: [ 'aria-readonly', 'aria-required', 'aria-activedescendant', 'aria-expanded', 'aria-orientation' ]
        },
        range: {
          type: 'abstract'
        },
        region: {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        roletype: {
          type: 'abstract'
        },
        row: {
          type: 'structure',
          requiredContext: [ 'grid', 'rowgroup', 'table', 'treegrid' ],
          requiredOwned: [ 'cell', 'columnheader', 'gridcell', 'rowheader' ],
          allowedAttrs: [ 'aria-colindex', 'aria-level', 'aria-rowindex', 'aria-selected', 'aria-activedescendant', 'aria-expanded' ],
          nameFromContent: true
        },
        rowgroup: {
          type: 'structure',
          requiredContext: [ 'grid', 'table', 'treegrid' ],
          requiredOwned: [ 'row' ],
          nameFromContent: true
        },
        rowheader: {
          type: 'structure',
          requiredContext: [ 'row' ],
          allowedAttrs: [ 'aria-sort', 'aria-colindex', 'aria-colspan', 'aria-expanded', 'aria-readonly', 'aria-required', 'aria-rowindex', 'aria-rowspan', 'aria-selected' ],
          nameFromContent: true
        },
        scrollbar: {
          type: 'widget',
          requiredAttrs: [ 'aria-valuenow' ],
          allowedAttrs: [ 'aria-controls', 'aria-orientation', 'aria-valuemax', 'aria-valuemin', 'aria-valuetext' ]
        },
        search: {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        searchbox: {
          type: 'widget',
          allowedAttrs: [ 'aria-activedescendant', 'aria-autocomplete', 'aria-multiline', 'aria-placeholder', 'aria-readonly', 'aria-required' ]
        },
        section: {
          type: 'abstract',
          nameFromContent: true
        },
        sectionhead: {
          type: 'abstract',
          nameFromContent: true
        },
        select: {
          type: 'abstract'
        },
        separator: {
          type: 'structure',
          allowedAttrs: [ 'aria-valuemax', 'aria-valuemin', 'aria-valuenow', 'aria-orientation', 'aria-valuetext' ]
        },
        slider: {
          type: 'widget',
          requiredAttrs: [ 'aria-valuenow' ],
          allowedAttrs: [ 'aria-valuemax', 'aria-valuemin', 'aria-orientation', 'aria-readonly', 'aria-valuetext' ]
        },
        spinbutton: {
          type: 'widget',
          requiredAttrs: [ 'aria-valuenow' ],
          allowedAttrs: [ 'aria-valuemax', 'aria-valuemin', 'aria-readonly', 'aria-required', 'aria-activedescendant', 'aria-valuetext' ]
        },
        status: {
          type: 'widget',
          allowedAttrs: [ 'aria-expanded' ]
        },
        structure: {
          type: 'abstract'
        },
        switch: {
          type: 'widget',
          requiredAttrs: [ 'aria-checked' ],
          allowedAttrs: [ 'aria-readonly' ],
          nameFromContent: true
        },
        tab: {
          type: 'widget',
          requiredContext: [ 'tablist' ],
          allowedAttrs: [ 'aria-posinset', 'aria-selected', 'aria-setsize', 'aria-expanded' ],
          nameFromContent: true
        },
        table: {
          type: 'structure',
          requiredOwned: [ 'rowgroup', 'row' ],
          allowedAttrs: [ 'aria-colcount', 'aria-rowcount', 'aria-expanded' ],
          nameFromContent: true
        },
        tablist: {
          type: 'composite',
          requiredOwned: [ 'tab' ],
          allowedAttrs: [ 'aria-level', 'aria-multiselectable', 'aria-orientation', 'aria-activedescendant', 'aria-expanded' ]
        },
        tabpanel: {
          type: 'widget',
          allowedAttrs: [ 'aria-expanded' ]
        },
        term: {
          type: 'structure',
          allowedAttrs: [ 'aria-expanded' ],
          nameFromContent: true
        },
        textbox: {
          type: 'widget',
          allowedAttrs: [ 'aria-activedescendant', 'aria-autocomplete', 'aria-multiline', 'aria-placeholder', 'aria-readonly', 'aria-required' ]
        },
        timer: {
          type: 'widget',
          allowedAttrs: [ 'aria-expanded' ]
        },
        toolbar: {
          type: 'structure',
          allowedAttrs: [ 'aria-orientation', 'aria-activedescendant', 'aria-expanded' ]
        },
        tooltip: {
          type: 'structure',
          allowedAttrs: [ 'aria-expanded' ],
          nameFromContent: true
        },
        tree: {
          type: 'composite',
          requiredOwned: [ 'treeitem' ],
          allowedAttrs: [ 'aria-multiselectable', 'aria-required', 'aria-activedescendant', 'aria-expanded', 'aria-orientation' ]
        },
        treegrid: {
          type: 'composite',
          requiredOwned: [ 'rowgroup', 'row' ],
          allowedAttrs: [ 'aria-activedescendant', 'aria-colcount', 'aria-expanded', 'aria-level', 'aria-multiselectable', 'aria-orientation', 'aria-readonly', 'aria-required', 'aria-rowcount' ]
        },
        treeitem: {
          type: 'widget',
          requiredContext: [ 'group', 'tree' ],
          allowedAttrs: [ 'aria-checked', 'aria-expanded', 'aria-level', 'aria-posinset', 'aria-selected', 'aria-setsize' ],
          nameFromContent: true
        },
        widget: {
          type: 'abstract'
        },
        window: {
          type: 'abstract'
        }
      };
      __webpack_exports__['default'] = ariaRoles;
    },
    './lib/standards/css-colors.js': function libStandardsCssColorsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var cssColors = {
        aliceblue: [ 240, 248, 255 ],
        antiquewhite: [ 250, 235, 215 ],
        aqua: [ 0, 255, 255 ],
        aquamarine: [ 127, 255, 212 ],
        azure: [ 240, 255, 255 ],
        beige: [ 245, 245, 220 ],
        bisque: [ 255, 228, 196 ],
        black: [ 0, 0, 0 ],
        blanchedalmond: [ 255, 235, 205 ],
        blue: [ 0, 0, 255 ],
        blueviolet: [ 138, 43, 226 ],
        brown: [ 165, 42, 42 ],
        burlywood: [ 222, 184, 135 ],
        cadetblue: [ 95, 158, 160 ],
        chartreuse: [ 127, 255, 0 ],
        chocolate: [ 210, 105, 30 ],
        coral: [ 255, 127, 80 ],
        cornflowerblue: [ 100, 149, 237 ],
        cornsilk: [ 255, 248, 220 ],
        crimson: [ 220, 20, 60 ],
        cyan: [ 0, 255, 255 ],
        darkblue: [ 0, 0, 139 ],
        darkcyan: [ 0, 139, 139 ],
        darkgoldenrod: [ 184, 134, 11 ],
        darkgray: [ 169, 169, 169 ],
        darkgreen: [ 0, 100, 0 ],
        darkgrey: [ 169, 169, 169 ],
        darkkhaki: [ 189, 183, 107 ],
        darkmagenta: [ 139, 0, 139 ],
        darkolivegreen: [ 85, 107, 47 ],
        darkorange: [ 255, 140, 0 ],
        darkorchid: [ 153, 50, 204 ],
        darkred: [ 139, 0, 0 ],
        darksalmon: [ 233, 150, 122 ],
        darkseagreen: [ 143, 188, 143 ],
        darkslateblue: [ 72, 61, 139 ],
        darkslategray: [ 47, 79, 79 ],
        darkslategrey: [ 47, 79, 79 ],
        darkturquoise: [ 0, 206, 209 ],
        darkviolet: [ 148, 0, 211 ],
        deeppink: [ 255, 20, 147 ],
        deepskyblue: [ 0, 191, 255 ],
        dimgray: [ 105, 105, 105 ],
        dimgrey: [ 105, 105, 105 ],
        dodgerblue: [ 30, 144, 255 ],
        firebrick: [ 178, 34, 34 ],
        floralwhite: [ 255, 250, 240 ],
        forestgreen: [ 34, 139, 34 ],
        fuchsia: [ 255, 0, 255 ],
        gainsboro: [ 220, 220, 220 ],
        ghostwhite: [ 248, 248, 255 ],
        gold: [ 255, 215, 0 ],
        goldenrod: [ 218, 165, 32 ],
        gray: [ 128, 128, 128 ],
        green: [ 0, 128, 0 ],
        greenyellow: [ 173, 255, 47 ],
        grey: [ 128, 128, 128 ],
        honeydew: [ 240, 255, 240 ],
        hotpink: [ 255, 105, 180 ],
        indianred: [ 205, 92, 92 ],
        indigo: [ 75, 0, 130 ],
        ivory: [ 255, 255, 240 ],
        khaki: [ 240, 230, 140 ],
        lavender: [ 230, 230, 250 ],
        lavenderblush: [ 255, 240, 245 ],
        lawngreen: [ 124, 252, 0 ],
        lemonchiffon: [ 255, 250, 205 ],
        lightblue: [ 173, 216, 230 ],
        lightcoral: [ 240, 128, 128 ],
        lightcyan: [ 224, 255, 255 ],
        lightgoldenrodyellow: [ 250, 250, 210 ],
        lightgray: [ 211, 211, 211 ],
        lightgreen: [ 144, 238, 144 ],
        lightgrey: [ 211, 211, 211 ],
        lightpink: [ 255, 182, 193 ],
        lightsalmon: [ 255, 160, 122 ],
        lightseagreen: [ 32, 178, 170 ],
        lightskyblue: [ 135, 206, 250 ],
        lightslategray: [ 119, 136, 153 ],
        lightslategrey: [ 119, 136, 153 ],
        lightsteelblue: [ 176, 196, 222 ],
        lightyellow: [ 255, 255, 224 ],
        lime: [ 0, 255, 0 ],
        limegreen: [ 50, 205, 50 ],
        linen: [ 250, 240, 230 ],
        magenta: [ 255, 0, 255 ],
        maroon: [ 128, 0, 0 ],
        mediumaquamarine: [ 102, 205, 170 ],
        mediumblue: [ 0, 0, 205 ],
        mediumorchid: [ 186, 85, 211 ],
        mediumpurple: [ 147, 112, 219 ],
        mediumseagreen: [ 60, 179, 113 ],
        mediumslateblue: [ 123, 104, 238 ],
        mediumspringgreen: [ 0, 250, 154 ],
        mediumturquoise: [ 72, 209, 204 ],
        mediumvioletred: [ 199, 21, 133 ],
        midnightblue: [ 25, 25, 112 ],
        mintcream: [ 245, 255, 250 ],
        mistyrose: [ 255, 228, 225 ],
        moccasin: [ 255, 228, 181 ],
        navajowhite: [ 255, 222, 173 ],
        navy: [ 0, 0, 128 ],
        oldlace: [ 253, 245, 230 ],
        olive: [ 128, 128, 0 ],
        olivedrab: [ 107, 142, 35 ],
        orange: [ 255, 165, 0 ],
        orangered: [ 255, 69, 0 ],
        orchid: [ 218, 112, 214 ],
        palegoldenrod: [ 238, 232, 170 ],
        palegreen: [ 152, 251, 152 ],
        paleturquoise: [ 175, 238, 238 ],
        palevioletred: [ 219, 112, 147 ],
        papayawhip: [ 255, 239, 213 ],
        peachpuff: [ 255, 218, 185 ],
        peru: [ 205, 133, 63 ],
        pink: [ 255, 192, 203 ],
        plum: [ 221, 160, 221 ],
        powderblue: [ 176, 224, 230 ],
        purple: [ 128, 0, 128 ],
        rebeccapurple: [ 102, 51, 153 ],
        red: [ 255, 0, 0 ],
        rosybrown: [ 188, 143, 143 ],
        royalblue: [ 65, 105, 225 ],
        saddlebrown: [ 139, 69, 19 ],
        salmon: [ 250, 128, 114 ],
        sandybrown: [ 244, 164, 96 ],
        seagreen: [ 46, 139, 87 ],
        seashell: [ 255, 245, 238 ],
        sienna: [ 160, 82, 45 ],
        silver: [ 192, 192, 192 ],
        skyblue: [ 135, 206, 235 ],
        slateblue: [ 106, 90, 205 ],
        slategray: [ 112, 128, 144 ],
        slategrey: [ 112, 128, 144 ],
        snow: [ 255, 250, 250 ],
        springgreen: [ 0, 255, 127 ],
        steelblue: [ 70, 130, 180 ],
        tan: [ 210, 180, 140 ],
        teal: [ 0, 128, 128 ],
        thistle: [ 216, 191, 216 ],
        tomato: [ 255, 99, 71 ],
        turquoise: [ 64, 224, 208 ],
        violet: [ 238, 130, 238 ],
        wheat: [ 245, 222, 179 ],
        white: [ 255, 255, 255 ],
        whitesmoke: [ 245, 245, 245 ],
        yellow: [ 255, 255, 0 ],
        yellowgreen: [ 154, 205, 50 ]
      };
      __webpack_exports__['default'] = cssColors;
    },
    './lib/standards/dpub-roles.js': function libStandardsDpubRolesJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var dpubRoles = {
        'doc-abstract': {
          type: 'section',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-acknowledgments': {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-afterword': {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-appendix': {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-backlink': {
          type: 'link',
          allowedAttrs: [ 'aria-expanded' ],
          nameFromContent: true
        },
        'doc-biblioentry': {
          type: 'listitem',
          requiredContext: [ 'doc-bibliography' ],
          allowedAttrs: [ 'aria-expanded', 'aria-level', 'aria-posinset', 'aria-setsize' ]
        },
        'doc-bibliography': {
          type: 'landmark',
          requiredOwned: [ 'doc-biblioentry' ],
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-biblioref': {
          type: 'link',
          allowedAttrs: [ 'aria-expanded' ],
          nameFromContent: true
        },
        'doc-chapter': {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-colophon': {
          type: 'section',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-conclusion': {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-cover': {
          type: 'img',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-credit': {
          type: 'section',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-credits': {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-dedication': {
          type: 'section',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-endnote': {
          type: 'listitem',
          requiredContext: [ 'doc-endnotes' ],
          allowedAttrs: [ 'aria-expanded', 'aria-level', 'aria-posinset', 'aria-setsize' ]
        },
        'doc-endnotes': {
          type: 'landmark',
          requiredOwned: [ 'doc-endnote' ],
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-epigraph': {
          type: 'section',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-epilogue': {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-errata': {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-example': {
          type: 'section',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-footnote': {
          type: 'section',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-foreword': {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-glossary': {
          type: 'landmark',
          requiredOwned: [ 'definition', 'term' ],
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-glossref': {
          type: 'link',
          allowedAttrs: [ 'aria-expanded' ],
          nameFromContent: true
        },
        'doc-index': {
          type: 'navigation',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-introduction': {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-noteref': {
          type: 'link',
          allowedAttrs: [ 'aria-expanded' ],
          nameFromContent: true
        },
        'doc-notice': {
          type: 'note',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-pagebreak': {
          type: 'separator',
          allowedAttrs: [ 'aria-expanded', 'aria-orientation' ]
        },
        'doc-pagelist': {
          type: 'navigation',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-part': {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-preface': {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-prologue': {
          type: 'landmark',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-pullquote': {
          type: 'none'
        },
        'doc-qna': {
          type: 'section',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-subtitle': {
          type: 'sectionhead',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-tip': {
          type: 'note',
          allowedAttrs: [ 'aria-expanded' ]
        },
        'doc-toc': {
          type: 'navigation',
          allowedAttrs: [ 'aria-expanded' ]
        }
      };
      __webpack_exports__['default'] = dpubRoles;
    },
    './lib/standards/html-elms.js': function libStandardsHtmlElmsJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      var htmlElms = {
        a: {
          variant: {
            href: {
              matches: '[href]',
              contentTypes: [ 'interactive', 'phrasing', 'flow' ],
              allowedRoles: [ 'button', 'checkbox', 'menuitem', 'menuitemcheckbox', 'menuitemradio', 'option', 'radio', 'switch', 'tab', 'treeitem', 'doc-backlink', 'doc-biblioref', 'doc-glossref', 'doc-noteref' ]
            },
            default: {
              contentTypes: [ 'phrasing', 'flow' ],
              allowedRoles: true
            }
          }
        },
        abbr: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        addres: {
          contentTypes: [ 'flow' ],
          allowedRoles: true
        },
        area: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: false
        },
        article: {
          contentTypes: [ 'sectioning', 'flow' ],
          allowedRoles: [ 'feed', 'presentation', 'none', 'document', 'application', 'main', 'region' ],
          shadowRoot: true
        },
        aside: {
          contentTypes: [ 'sectioning', 'flow' ],
          allowedRoles: [ 'feed', 'note', 'presentation', 'none', 'region', 'search', 'doc-dedication', 'doc-example', 'doc-footnote', 'doc-pullquote', 'doc-tip' ]
        },
        audio: {
          variant: {
            controls: {
              matches: '[controls]',
              contentTypes: [ 'interactive', 'embedded', 'phrasing', 'flow' ]
            },
            default: {
              contentTypes: [ 'embedded', 'phrasing', 'flow' ]
            }
          },
          allowedRoles: [ 'application' ]
        },
        b: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: false
        },
        base: {
          allowedRoles: false,
          noAriaAttrs: true
        },
        bdi: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        bdo: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        blockquote: {
          contentTypes: [ 'flow' ],
          allowedRoles: true,
          shadowRoot: true
        },
        body: {
          allowedRoles: false,
          shadowRoot: true
        },
        br: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: [ 'presentation', 'none' ],
          namingMethods: [ 'titleText', 'singleSpace' ]
        },
        button: {
          contentTypes: [ 'interactive', 'phrasing', 'flow' ],
          allowedRoles: [ 'checkbox', 'link', 'menuitem', 'menuitemcheckbox', 'menuitemradio', 'option', 'radio', 'switch', 'tab' ],
          namingMethods: [ 'subtreeText' ]
        },
        canvas: {
          allowedRoles: true,
          contentTypes: [ 'embedded', 'phrasing', 'flow' ]
        },
        caption: {
          allowedRoles: false
        },
        cite: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        code: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        col: {
          allowedRoles: false,
          noAriaAttrs: true
        },
        colgroup: {
          allowedRoles: false,
          noAriaAttrs: true
        },
        data: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        datalist: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: false,
          implicitAttrs: {
            'aria-multiselectable': 'false'
          }
        },
        dd: {
          allowedRoles: false
        },
        del: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        dfn: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        details: {
          contentTypes: [ 'interactive', 'flow' ],
          allowedRoles: false
        },
        dialog: {
          contentTypes: [ 'flow' ],
          allowedRoles: [ 'alertdialog' ]
        },
        div: {
          contentTypes: [ 'flow' ],
          allowedRoles: true,
          shadowRoot: true
        },
        dl: {
          contentTypes: [ 'flow' ],
          allowedRoles: [ 'group', 'list', 'presentation', 'none' ]
        },
        dt: {
          allowedRoles: [ 'listitem' ]
        },
        em: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        embed: {
          contentTypes: [ 'interactive', 'embedded', 'phrasing', 'flow' ],
          allowedRoles: [ 'application', 'document', 'img', 'presentation', 'none' ]
        },
        fieldset: {
          contentTypes: [ 'flow' ],
          allowedRoles: [ 'none', 'presentation', 'radiogroup' ],
          namingMethods: [ 'fieldsetLegendText' ]
        },
        figcaption: {
          allowedRoles: [ 'group', 'none', 'presentation' ]
        },
        figure: {
          contentTypes: [ 'flow' ],
          allowedRoles: true,
          namingMethods: [ 'figureText', 'titleText' ]
        },
        footer: {
          contentTypes: [ 'flow' ],
          allowedRoles: [ 'group', 'none', 'presentation', 'doc-footnote' ],
          shadowRoot: true
        },
        form: {
          contentTypes: [ 'flow' ],
          allowedRoles: [ 'search', 'none', 'presentation' ]
        },
        h1: {
          contentTypes: [ 'heading', 'flow' ],
          allowedRoles: [ 'none', 'presentation', 'tab', 'doc-subtitle' ],
          shadowRoot: true,
          implicitAttrs: {
            'aria-level': '1'
          }
        },
        h2: {
          contentTypes: [ 'heading', 'flow' ],
          allowedRoles: [ 'none', 'presentation', 'tab', 'doc-subtitle' ],
          shadowRoot: true,
          implicitAttrs: {
            'aria-level': '2'
          }
        },
        h3: {
          contentTypes: [ 'heading', 'flow' ],
          allowedRoles: [ 'none', 'presentation', 'tab', 'doc-subtitle' ],
          shadowRoot: true,
          implicitAttrs: {
            'aria-level': '3'
          }
        },
        h4: {
          contentTypes: [ 'heading', 'flow' ],
          allowedRoles: [ 'none', 'presentation', 'tab', 'doc-subtitle' ],
          shadowRoot: true,
          implicitAttrs: {
            'aria-level': '4'
          }
        },
        h5: {
          contentTypes: [ 'heading', 'flow' ],
          allowedRoles: [ 'none', 'presentation', 'tab', 'doc-subtitle' ],
          shadowRoot: true,
          implicitAttrs: {
            'aria-level': '5'
          }
        },
        h6: {
          contentTypes: [ 'heading', 'flow' ],
          allowedRoles: [ 'none', 'presentation', 'tab', 'doc-subtitle' ],
          shadowRoot: true,
          implicitAttrs: {
            'aria-level': '6'
          }
        },
        head: {
          allowedRoles: false,
          noAriaAttrs: true
        },
        header: {
          contentTypes: [ 'flow' ],
          allowedRoles: [ 'group', 'none', 'presentation', 'doc-footnote' ],
          shadowRoot: true
        },
        hgroup: {
          contentTypes: [ 'heading', 'flow' ],
          allowedRoles: true
        },
        hr: {
          contentTypes: [ 'flow' ],
          allowedRoles: [ 'none', 'presentation', 'doc-pagebreak' ],
          namingMethods: [ 'titleText', 'singleSpace' ]
        },
        html: {
          allowedRoles: false,
          noAriaAttrs: true
        },
        i: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        iframe: {
          contentTypes: [ 'interactive', 'embedded', 'phrasing', 'flow' ],
          allowedRoles: [ 'application', 'document', 'img', 'none', 'presentation' ]
        },
        img: {
          variant: {
            nonEmptyAlt: {
              matches: {
                attributes: {
                  alt: '/.+/'
                }
              },
              allowedRoles: [ 'button', 'checkbox', 'link', 'menuitem', 'menuitemcheckbox', 'menuitemradio', 'option', 'progressbar', 'scrollbar', 'separator', 'slider', 'switch', 'tab', 'treeitem', 'doc-cover' ]
            },
            usemap: {
              matches: '[usemap]',
              contentTypes: [ 'interactive', 'embedded', 'phrasing', 'flow' ]
            },
            default: {
              allowedRoles: [ 'presentation', 'none' ],
              contentTypes: [ 'embedded', 'phrasing', 'flow' ]
            }
          },
          namingMethods: [ 'altText' ]
        },
        input: {
          variant: {
            button: {
              matches: {
                properties: {
                  type: 'button'
                }
              },
              allowedRoles: [ 'link', 'menuitem', 'menuitemcheckbox', 'menuitemradio', 'option', 'radio', 'switch', 'tab' ]
            },
            buttonType: {
              matches: {
                properties: {
                  type: [ 'button', 'submit', 'reset' ]
                }
              },
              namingMethods: [ 'valueText', 'titleText', 'buttonDefaultText' ]
            },
            checkboxPressed: {
              matches: {
                properties: {
                  type: 'checkbox'
                },
                attributes: {
                  'aria-pressed': '/.*/'
                }
              },
              allowedRoles: [ 'button', 'menuitemcheckbox', 'option', 'switch' ],
              implicitAttrs: {
                'aria-checked': 'false'
              }
            },
            checkbox: {
              matches: {
                properties: {
                  type: 'checkbox'
                },
                attributes: {
                  'aria-pressed': null
                }
              },
              allowedRoles: [ 'menuitemcheckbox', 'option', 'switch' ],
              implicitAttrs: {
                'aria-checked': 'false'
              }
            },
            noRoles: {
              matches: {
                properties: {
                  type: [ 'color', 'date', 'datetime-local', 'file', 'month', 'number', 'password', 'range', 'reset', 'submit', 'time', 'week' ]
                }
              },
              allowedRoles: false
            },
            hidden: {
              matches: {
                properties: {
                  type: 'hidden'
                }
              },
              contentTypes: [ 'phrasing', 'flow' ],
              allowedRoles: false,
              noAriaAttrs: true
            },
            image: {
              matches: {
                properties: {
                  type: 'image'
                }
              },
              allowedRoles: [ 'link', 'menuitem', 'menuitemcheckbox', 'menuitemradio', 'radio', 'switch' ],
              namingMethods: [ 'altText', 'valueText', 'labelText', 'titleText', 'buttonDefaultText' ]
            },
            radio: {
              matches: {
                properties: {
                  type: 'radio'
                }
              },
              allowedRoles: [ 'menuitemradio' ],
              implicitAttrs: {
                'aria-checked': 'false'
              }
            },
            textWithList: {
              matches: {
                properties: {
                  type: 'text'
                },
                attributes: {
                  list: '/.*/'
                }
              },
              allowedRoles: false
            },
            default: {
              contentTypes: [ 'interactive', 'phrasing', 'flow' ],
              allowedRoles: [ 'combobox', 'searchbox', 'spinbutton' ],
              implicitAttrs: {
                'aria-valuenow': ''
              },
              namingMethods: [ 'labelText' ]
            }
          }
        },
        ins: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        kbd: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        label: {
          contentTypes: [ 'interactive', 'phrasing', 'flow' ],
          allowedRoles: false
        },
        legend: {
          allowedRoles: false
        },
        li: {
          allowedRoles: [ 'menuitem', 'menuitemcheckbox', 'menuitemradio', 'option', 'none', 'presentation', 'radio', 'separator', 'tab', 'treeitem', 'doc-biblioentry', 'doc-endnote' ],
          implicitAttrs: {
            'aria-setsize': '1',
            'aria-posinset': '1'
          }
        },
        link: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: false,
          noAriaAttrs: true
        },
        main: {
          contentTypes: [ 'flow' ],
          allowedRoles: false,
          shadowRoot: true
        },
        map: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: false,
          noAriaAttrs: true
        },
        math: {
          contentTypes: [ 'embedded', 'phrasing', 'flow' ],
          allowedRoles: false
        },
        mark: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        menu: {
          contentTypes: [ 'flow' ],
          allowedRoles: [ 'directory', 'group', 'listbox', 'menu', 'menubar', 'none', 'presentation', 'radiogroup', 'tablist', 'toolbar', 'tree' ]
        },
        meta: {
          variant: {
            itemprop: {
              matches: '[itemprop]',
              contentTypes: [ 'phrasing', 'flow' ]
            }
          },
          allowedRoles: false,
          noAriaAttrs: true
        },
        meter: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: false
        },
        nav: {
          contentTypes: [ 'sectioning', 'flow' ],
          allowedRoles: [ 'doc-index', 'doc-pagelist', 'doc-toc' ],
          shadowRoot: true
        },
        noscript: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: false,
          noAriaAttrs: true
        },
        object: {
          variant: {
            usemap: {
              matches: '[usemap]',
              contentTypes: [ 'interactive', 'embedded', 'phrasing', 'flow' ]
            },
            default: {
              contentTypes: [ 'embedded', 'phrasing', 'flow' ]
            }
          },
          allowedRoles: [ 'application', 'document', 'img' ]
        },
        ol: {
          contentTypes: [ 'flow' ],
          allowedRoles: [ 'directory', 'group', 'listbox', 'menu', 'menubar', 'none', 'presentation', 'radiogroup', 'tablist', 'toolbar', 'tree' ]
        },
        optgroup: {
          allowedRoles: false
        },
        option: {
          allowedRoles: false,
          implicitAttrs: {
            'aria-selected': 'false'
          }
        },
        output: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true,
          namingMethods: [ 'subtreeText' ]
        },
        p: {
          contentTypes: [ 'flow' ],
          allowedRoles: true,
          shadowRoot: true
        },
        param: {
          allowedRoles: false,
          noAriaAttrs: true
        },
        picture: {
          contentTypes: [ 'embedded', 'phrasing', 'flow' ],
          allowedRoles: false,
          noAriaAttrs: true
        },
        pre: {
          contentTypes: [ 'flow' ],
          allowedRoles: true
        },
        progress: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true,
          implicitAttrs: {
            'aria-valuemax': '100',
            'aria-valuemin': '0',
            'aria-valuenow': '0'
          }
        },
        q: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        rp: {
          allowedRoles: true
        },
        rt: {
          allowedRoles: true
        },
        ruby: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        s: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        samp: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        script: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: false,
          noAriaAttrs: true
        },
        section: {
          contentTypes: [ 'sectioning', 'flow' ],
          allowedRoles: [ 'alert', 'alertdialog', 'application', 'banner', 'complementary', 'contentinfo', 'dialog', 'document', 'feed', 'log', 'main', 'marquee', 'navigation', 'none', 'note', 'presentation', 'search', 'status', 'tabpanel', 'doc-abstract', 'doc-acknowledgments', 'doc-afterword', 'doc-appendix', 'doc-bibliography', 'doc-chapter', 'doc-colophon', 'doc-conclusion', 'doc-credit', 'doc-credits', 'doc-dedication', 'doc-endnotes', 'doc-epigraph', 'doc-epilogue', 'doc-errata', 'doc-example', 'doc-foreword', 'doc-glossary', 'doc-index', 'doc-introduction', 'doc-notice', 'doc-pagelist', 'doc-part', 'doc-preface', 'doc-prologue', 'doc-pullquote', 'doc-qna', 'doc-toc' ],
          shadowRoot: true
        },
        select: {
          variant: {
            combobox: {
              matches: {
                attributes: {
                  multiple: null,
                  size: [ null, '1' ]
                }
              },
              allowedRoles: [ 'menu' ]
            },
            default: {
              allowedRoles: false
            }
          },
          contentTypes: [ 'interactive', 'phrasing', 'flow' ],
          implicitAttrs: {
            'aria-valuenow': ''
          }
        },
        slot: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: false,
          noAriaAttrs: true
        },
        small: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        source: {
          allowedRoles: false,
          noAriaAttrs: true
        },
        span: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true,
          shadowRoot: true
        },
        strong: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        style: {
          allowedRoles: false,
          noAriaAttrs: true
        },
        svg: {
          contentTypes: [ 'embedded', 'phrasing', 'flow' ],
          allowedRoles: [ 'application', 'document', 'img' ]
        },
        sub: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        summary: {
          allowedRoles: false,
          namingMethods: [ 'subtreeText' ]
        },
        sup: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        table: {
          contentTypes: [ 'flow' ],
          allowedRoles: true,
          namingMethods: [ 'tableCaptionText', 'tableSummaryText' ]
        },
        tbody: {
          allowedRoles: true
        },
        template: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: false,
          noAriaAttrs: true
        },
        textarea: {
          contentTypes: [ 'interactive', 'phrasing', 'flow' ],
          allowedRoles: false,
          implicitAttrs: {
            'aria-valuenow': '',
            'aria-multiline': 'true'
          },
          namingMethods: [ 'labelText' ]
        },
        tfoot: {
          allowedRoles: true
        },
        thead: {
          allowedRoles: true
        },
        time: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        title: {
          allowedRoles: false,
          noAriaAttrs: true
        },
        td: {
          allowedRoles: true
        },
        th: {
          allowedRoles: true
        },
        tr: {
          allowedRoles: true
        },
        track: {
          allowedRoles: false,
          noAriaAttrs: true
        },
        u: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        ul: {
          contentTypes: [ 'flow' ],
          allowedRoles: [ 'directory', 'group', 'listbox', 'menu', 'menubar', 'none', 'presentation', 'radiogroup', 'tablist', 'toolbar', 'tree' ]
        },
        var: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        },
        video: {
          variant: {
            controls: {
              matches: '[controls]',
              contentTypes: [ 'interactive', 'embedded', 'phrasing', 'flow' ]
            },
            default: {
              contentTypes: [ 'embedded', 'phrasing', 'flow' ]
            }
          },
          allowedRoles: [ 'application' ]
        },
        wbr: {
          contentTypes: [ 'phrasing', 'flow' ],
          allowedRoles: true
        }
      };
      __webpack_exports__['default'] = htmlElms;
    },
    './lib/standards/index.js': function libStandardsIndexJs(module, __webpack_exports__, __webpack_require__) {
      'use strict';
      __webpack_require__.r(__webpack_exports__);
      __webpack_require__.d(__webpack_exports__, 'configureStandards', function() {
        return configureStandards;
      });
      __webpack_require__.d(__webpack_exports__, 'resetStandards', function() {
        return resetStandards;
      });
      var _aria_attrs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__('./lib/standards/aria-attrs.js');
      var _aria_roles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__('./lib/standards/aria-roles.js');
      var _dpub_roles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__('./lib/standards/dpub-roles.js');
      var _html_elms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__('./lib/standards/html-elms.js');
      var _core_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__('./lib/core/utils/index.js');
      var _css_colors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__('./lib/standards/css-colors.js');
      var originals = {
        ariaAttrs: _aria_attrs__WEBPACK_IMPORTED_MODULE_0__['default'],
        ariaRoles: _extends({}, _aria_roles__WEBPACK_IMPORTED_MODULE_1__['default'], _dpub_roles__WEBPACK_IMPORTED_MODULE_2__['default']),
        htmlElms: _html_elms__WEBPACK_IMPORTED_MODULE_3__['default'],
        cssColors: _css_colors__WEBPACK_IMPORTED_MODULE_5__['default']
      };
      var standards = _extends({}, originals);
      function configureStandards(config) {
        Object.keys(standards).forEach(function(propName) {
          if (config[propName]) {
            standards[propName] = Object(_core_utils__WEBPACK_IMPORTED_MODULE_4__['deepMerge'])(standards[propName], config[propName]);
          }
        });
      }
      function resetStandards() {
        Object.keys(standards).forEach(function(propName) {
          standards[propName] = originals[propName];
        });
      }
      __webpack_exports__['default'] = standards;
    },
    './node_modules/@deque/dot/doT.js': function node_modulesDequeDotDoTJs(module, exports, __webpack_require__) {
      (function(global) {
        var __WEBPACK_AMD_DEFINE_RESULT__;
        (function() {
          'use strict';
          var doT = {
            name: 'doT',
            version: '1.1.1',
            templateSettings: {
              evaluate: /\{\{([\s\S]+?(\}?)+)\}\}/g,
              interpolate: /\{\{=([\s\S]+?)\}\}/g,
              encode: /\{\{!([\s\S]+?)\}\}/g,
              use: /\{\{#([\s\S]+?)\}\}/g,
              useParams: /(^|[^\w$])def(?:\.|\[[\'\"])([\w$\.]+)(?:[\'\"]\])?\s*\:\s*([\w$\.]+|\"[^\"]+\"|\'[^\']+\'|\{[^\}]+\})/g,
              define: /\{\{##\s*([\w\.$]+)\s*(\:|=)([\s\S]+?)#\}\}/g,
              defineParams: /^\s*([\w$]+):([\s\S]+)/,
              conditional: /\{\{\?(\?)?\s*([\s\S]*?)\s*\}\}/g,
              iterate: /\{\{~\s*(?:\}\}|([\s\S]+?)\s*\:\s*([\w$]+)\s*(?:\:\s*([\w$]+))?\s*\}\})/g,
              varname: 'it',
              strip: true,
              append: true,
              selfcontained: false,
              doNotSkipEncoded: false
            },
            template: undefined,
            compile: undefined,
            log: true
          };
          (function() {
            if ((typeof globalThis === 'undefined' ? 'undefined' : _typeof(globalThis)) === 'object') {
              return;
            }
            try {
              Object.defineProperty(Object.prototype, '__magic__', {
                get: function get() {
                  return this;
                },
                configurable: true
              });
              __magic__.globalThis = __magic__;
              delete Object.prototype.__magic__;
            } catch (e) {
              window.globalThis = function() {
                if (typeof self !== 'undefined') {
                  return self;
                }
                if (typeof window !== 'undefined') {
                  return window;
                }
                if (typeof global !== 'undefined') {
                  return global;
                }
                if (typeof this !== 'undefined') {
                  return this;
                }
                throw new Error('Unable to locate global `this`');
              }();
            }
          })();
          doT.encodeHTMLSource = function(doNotSkipEncoded) {
            var encodeHTMLRules = {
              '&': '&#38;',
              '<': '&#60;',
              '>': '&#62;',
              '"': '&#34;',
              '\'': '&#39;',
              '/': '&#47;'
            }, matchHTML = doNotSkipEncoded ? /[&<>"'\/]/g : /&(?!#?\w+;)|<|>|"|'|\//g;
            return function(code) {
              return code ? code.toString().replace(matchHTML, function(m) {
                return encodeHTMLRules[m] || m;
              }) : '';
            };
          };
          if (true && module.exports) {
            module.exports = doT;
          } else if (true) {
            !(__WEBPACK_AMD_DEFINE_RESULT__ = function() {
              return doT;
            }.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
          } else {}
          var startend = {
            append: {
              start: '\'+(',
              end: ')+\'',
              startencode: '\'+encodeHTML('
            },
            split: {
              start: '\';out+=(',
              end: ');out+=\'',
              startencode: '\';out+=encodeHTML('
            }
          }, skip = /$^/;
          function resolveDefs(c, block, def) {
            return (typeof block === 'string' ? block : block.toString()).replace(c.define || skip, function(m, code, assign, value) {
              if (code.indexOf('def.') === 0) {
                code = code.substring(4);
              }
              if (!(code in def)) {
                if (assign === ':') {
                  if (c.defineParams) {
                    value.replace(c.defineParams, function(m, param, v) {
                      def[code] = {
                        arg: param,
                        text: v
                      };
                    });
                  }
                  if (!(code in def)) {
                    def[code] = value;
                  }
                } else {
                  new Function('def', 'def[\'' + code + '\']=' + value)(def);
                }
              }
              return '';
            }).replace(c.use || skip, function(m, code) {
              if (c.useParams) {
                code = code.replace(c.useParams, function(m, s, d, param) {
                  if (def[d] && def[d].arg && param) {
                    var rw = (d + ':' + param).replace(/'|\\/g, '_');
                    def.__exp = def.__exp || {};
                    def.__exp[rw] = def[d].text.replace(new RegExp('(^|[^\\w$])' + def[d].arg + '([^\\w$])', 'g'), '$1' + param + '$2');
                    return s + 'def.__exp[\'' + rw + '\']';
                  }
                });
              }
              var v = new Function('def', 'return ' + code)(def);
              return v ? resolveDefs(c, v, def) : v;
            });
          }
          function unescape(code) {
            return code.replace(/\\('|\\)/g, '$1').replace(/[\r\t\n]/g, ' ');
          }
          doT.template = function(tmpl, c, def) {
            c = c || doT.templateSettings;
            var cse = c.append ? startend.append : startend.split, needhtmlencode, sid = 0, indv, str = c.use || c.define ? resolveDefs(c, tmpl, def || {}) : tmpl;
            str = ('var out=\'' + (c.strip ? str.replace(/(^|\r|\n)\t* +| +\t*(\r|\n|$)/g, ' ').replace(/\r|\n|\t|\/\*[\s\S]*?\*\//g, '') : str).replace(/'|\\/g, '\\$&').replace(c.interpolate || skip, function(m, code) {
              return cse.start + unescape(code) + cse.end;
            }).replace(c.encode || skip, function(m, code) {
              needhtmlencode = true;
              return cse.startencode + unescape(code) + cse.end;
            }).replace(c.conditional || skip, function(m, elsecase, code) {
              return elsecase ? code ? '\';}else if(' + unescape(code) + '){out+=\'' : '\';}else{out+=\'' : code ? '\';if(' + unescape(code) + '){out+=\'' : '\';}out+=\'';
            }).replace(c.iterate || skip, function(m, iterate, vname, iname) {
              if (!iterate) {
                return '\';} } out+=\'';
              }
              sid += 1;
              indv = iname || 'i' + sid;
              iterate = unescape(iterate);
              return '\';var arr' + sid + '=' + iterate + ';if(arr' + sid + '){var ' + vname + ',' + indv + '=-1,l' + sid + '=arr' + sid + '.length-1;while(' + indv + '<l' + sid + '){' + vname + '=arr' + sid + '[' + indv + '+=1];out+=\'';
            }).replace(c.evaluate || skip, function(m, code) {
              return '\';' + unescape(code) + 'out+=\'';
            }) + '\';return out;').replace(/\n/g, '\\n').replace(/\t/g, '\\t').replace(/\r/g, '\\r').replace(/(\s|;|\}|^|\{)out\+='';/g, '$1').replace(/\+''/g, '');
            if (needhtmlencode) {
              if (!c.selfcontained && globalThis && !globalThis._encodeHTML) {
                globalThis._encodeHTML = doT.encodeHTMLSource(c.doNotSkipEncoded);
              }
              str = 'var encodeHTML = typeof _encodeHTML !== \'undefined\' ? _encodeHTML : (' + doT.encodeHTMLSource.toString() + '(' + (c.doNotSkipEncoded || '') + '));' + str;
            }
            try {
              return new Function(c.varname, str);
            } catch (e) {
              if (typeof console !== 'undefined') {
                console.log('Could not create a template function: ' + str);
              }
              throw e;
            }
          };
          doT.compile = function(tmpl, def) {
            return doT.template(tmpl, null, def);
          };
        })();
      }).call(this, __webpack_require__('./node_modules/webpack/buildin/global.js'));
    },
    './node_modules/axios/index.js': function node_modulesAxiosIndexJs(module, exports, __webpack_require__) {
      module.exports = __webpack_require__('./node_modules/axios/lib/axios.js');
    },
    './node_modules/axios/lib/adapters/xhr.js': function node_modulesAxiosLibAdaptersXhrJs(module, exports, __webpack_require__) {
      'use strict';
      var utils = __webpack_require__('./node_modules/axios/lib/utils.js');
      var settle = __webpack_require__('./node_modules/axios/lib/core/settle.js');
      var buildURL = __webpack_require__('./node_modules/axios/lib/helpers/buildURL.js');
      var buildFullPath = __webpack_require__('./node_modules/axios/lib/core/buildFullPath.js');
      var parseHeaders = __webpack_require__('./node_modules/axios/lib/helpers/parseHeaders.js');
      var isURLSameOrigin = __webpack_require__('./node_modules/axios/lib/helpers/isURLSameOrigin.js');
      var createError = __webpack_require__('./node_modules/axios/lib/core/createError.js');
      module.exports = function xhrAdapter(config) {
        return new Promise(function dispatchXhrRequest(resolve, reject) {
          var requestData = config.data;
          var requestHeaders = config.headers;
          if (utils.isFormData(requestData)) {
            delete requestHeaders['Content-Type'];
          }
          var request = new XMLHttpRequest();
          if (config.auth) {
            var username = config.auth.username || '';
            var password = config.auth.password || '';
            requestHeaders.Authorization = 'Basic ' + btoa(username + ':' + password);
          }
          var fullPath = buildFullPath(config.baseURL, config.url);
          request.open(config.method.toUpperCase(), buildURL(fullPath, config.params, config.paramsSerializer), true);
          request.timeout = config.timeout;
          request.onreadystatechange = function handleLoad() {
            if (!request || request.readyState !== 4) {
              return;
            }
            if (request.status === 0 && !(request.responseURL && request.responseURL.indexOf('file:') === 0)) {
              return;
            }
            var responseHeaders = 'getAllResponseHeaders' in request ? parseHeaders(request.getAllResponseHeaders()) : null;
            var responseData = !config.responseType || config.responseType === 'text' ? request.responseText : request.response;
            var response = {
              data: responseData,
              status: request.status,
              statusText: request.statusText,
              headers: responseHeaders,
              config: config,
              request: request
            };
            settle(resolve, reject, response);
            request = null;
          };
          request.onabort = function handleAbort() {
            if (!request) {
              return;
            }
            reject(createError('Request aborted', config, 'ECONNABORTED', request));
            request = null;
          };
          request.onerror = function handleError() {
            reject(createError('Network Error', config, null, request));
            request = null;
          };
          request.ontimeout = function handleTimeout() {
            var timeoutErrorMessage = 'timeout of ' + config.timeout + 'ms exceeded';
            if (config.timeoutErrorMessage) {
              timeoutErrorMessage = config.timeoutErrorMessage;
            }
            reject(createError(timeoutErrorMessage, config, 'ECONNABORTED', request));
            request = null;
          };
          if (utils.isStandardBrowserEnv()) {
            var cookies = __webpack_require__('./node_modules/axios/lib/helpers/cookies.js');
            var xsrfValue = (config.withCredentials || isURLSameOrigin(fullPath)) && config.xsrfCookieName ? cookies.read(config.xsrfCookieName) : undefined;
            if (xsrfValue) {
              requestHeaders[config.xsrfHeaderName] = xsrfValue;
            }
          }
          if ('setRequestHeader' in request) {
            utils.forEach(requestHeaders, function setRequestHeader(val, key) {
              if (typeof requestData === 'undefined' && key.toLowerCase() === 'content-type') {
                delete requestHeaders[key];
              } else {
                request.setRequestHeader(key, val);
              }
            });
          }
          if (!utils.isUndefined(config.withCredentials)) {
            request.withCredentials = !!config.withCredentials;
          }
          if (config.responseType) {
            try {
              request.responseType = config.responseType;
            } catch (e) {
              if (config.responseType !== 'json') {
                throw e;
              }
            }
          }
          if (typeof config.onDownloadProgress === 'function') {
            request.addEventListener('progress', config.onDownloadProgress);
          }
          if (typeof config.onUploadProgress === 'function' && request.upload) {
            request.upload.addEventListener('progress', config.onUploadProgress);
          }
          if (config.cancelToken) {
            config.cancelToken.promise.then(function onCanceled(cancel) {
              if (!request) {
                return;
              }
              request.abort();
              reject(cancel);
              request = null;
            });
          }
          if (requestData === undefined) {
            requestData = null;
          }
          request.send(requestData);
        });
      };
    },
    './node_modules/axios/lib/axios.js': function node_modulesAxiosLibAxiosJs(module, exports, __webpack_require__) {
      'use strict';
      var utils = __webpack_require__('./node_modules/axios/lib/utils.js');
      var bind = __webpack_require__('./node_modules/axios/lib/helpers/bind.js');
      var Axios = __webpack_require__('./node_modules/axios/lib/core/Axios.js');
      var mergeConfig = __webpack_require__('./node_modules/axios/lib/core/mergeConfig.js');
      var defaults = __webpack_require__('./node_modules/axios/lib/defaults.js');
      function createInstance(defaultConfig) {
        var context = new Axios(defaultConfig);
        var instance = bind(Axios.prototype.request, context);
        utils.extend(instance, Axios.prototype, context);
        utils.extend(instance, context);
        return instance;
      }
      var axios = createInstance(defaults);
      axios.Axios = Axios;
      axios.create = function create(instanceConfig) {
        return createInstance(mergeConfig(axios.defaults, instanceConfig));
      };
      axios.Cancel = __webpack_require__('./node_modules/axios/lib/cancel/Cancel.js');
      axios.CancelToken = __webpack_require__('./node_modules/axios/lib/cancel/CancelToken.js');
      axios.isCancel = __webpack_require__('./node_modules/axios/lib/cancel/isCancel.js');
      axios.all = function all(promises) {
        return Promise.all(promises);
      };
      axios.spread = __webpack_require__('./node_modules/axios/lib/helpers/spread.js');
      module.exports = axios;
      module.exports['default'] = axios;
    },
    './node_modules/axios/lib/cancel/Cancel.js': function node_modulesAxiosLibCancelCancelJs(module, exports, __webpack_require__) {
      'use strict';
      function Cancel(message) {
        this.message = message;
      }
      Cancel.prototype.toString = function toString() {
        return 'Cancel' + (this.message ? ': ' + this.message : '');
      };
      Cancel.prototype.__CANCEL__ = true;
      module.exports = Cancel;
    },
    './node_modules/axios/lib/cancel/CancelToken.js': function node_modulesAxiosLibCancelCancelTokenJs(module, exports, __webpack_require__) {
      'use strict';
      var Cancel = __webpack_require__('./node_modules/axios/lib/cancel/Cancel.js');
      function CancelToken(executor) {
        if (typeof executor !== 'function') {
          throw new TypeError('executor must be a function.');
        }
        var resolvePromise;
        this.promise = new Promise(function promiseExecutor(resolve) {
          resolvePromise = resolve;
        });
        var token = this;
        executor(function cancel(message) {
          if (token.reason) {
            return;
          }
          token.reason = new Cancel(message);
          resolvePromise(token.reason);
        });
      }
      CancelToken.prototype.throwIfRequested = function throwIfRequested() {
        if (this.reason) {
          throw this.reason;
        }
      };
      CancelToken.source = function source() {
        var cancel;
        var token = new CancelToken(function executor(c) {
          cancel = c;
        });
        return {
          token: token,
          cancel: cancel
        };
      };
      module.exports = CancelToken;
    },
    './node_modules/axios/lib/cancel/isCancel.js': function node_modulesAxiosLibCancelIsCancelJs(module, exports, __webpack_require__) {
      'use strict';
      module.exports = function isCancel(value) {
        return !!(value && value.__CANCEL__);
      };
    },
    './node_modules/axios/lib/core/Axios.js': function node_modulesAxiosLibCoreAxiosJs(module, exports, __webpack_require__) {
      'use strict';
      var utils = __webpack_require__('./node_modules/axios/lib/utils.js');
      var buildURL = __webpack_require__('./node_modules/axios/lib/helpers/buildURL.js');
      var InterceptorManager = __webpack_require__('./node_modules/axios/lib/core/InterceptorManager.js');
      var dispatchRequest = __webpack_require__('./node_modules/axios/lib/core/dispatchRequest.js');
      var mergeConfig = __webpack_require__('./node_modules/axios/lib/core/mergeConfig.js');
      function Axios(instanceConfig) {
        this.defaults = instanceConfig;
        this.interceptors = {
          request: new InterceptorManager(),
          response: new InterceptorManager()
        };
      }
      Axios.prototype.request = function request(config) {
        if (typeof config === 'string') {
          config = arguments[1] || {};
          config.url = arguments[0];
        } else {
          config = config || {};
        }
        config = mergeConfig(this.defaults, config);
        if (config.method) {
          config.method = config.method.toLowerCase();
        } else if (this.defaults.method) {
          config.method = this.defaults.method.toLowerCase();
        } else {
          config.method = 'get';
        }
        var chain = [ dispatchRequest, undefined ];
        var promise = Promise.resolve(config);
        this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
          chain.unshift(interceptor.fulfilled, interceptor.rejected);
        });
        this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
          chain.push(interceptor.fulfilled, interceptor.rejected);
        });
        while (chain.length) {
          promise = promise.then(chain.shift(), chain.shift());
        }
        return promise;
      };
      Axios.prototype.getUri = function getUri(config) {
        config = mergeConfig(this.defaults, config);
        return buildURL(config.url, config.params, config.paramsSerializer).replace(/^\?/, '');
      };
      utils.forEach([ 'delete', 'get', 'head', 'options' ], function forEachMethodNoData(method) {
        Axios.prototype[method] = function(url, config) {
          return this.request(utils.merge(config || {}, {
            method: method,
            url: url
          }));
        };
      });
      utils.forEach([ 'post', 'put', 'patch' ], function forEachMethodWithData(method) {
        Axios.prototype[method] = function(url, data, config) {
          return this.request(utils.merge(config || {}, {
            method: method,
            url: url,
            data: data
          }));
        };
      });
      module.exports = Axios;
    },
    './node_modules/axios/lib/core/InterceptorManager.js': function node_modulesAxiosLibCoreInterceptorManagerJs(module, exports, __webpack_require__) {
      'use strict';
      var utils = __webpack_require__('./node_modules/axios/lib/utils.js');
      function InterceptorManager() {
        this.handlers = [];
      }
      InterceptorManager.prototype.use = function use(fulfilled, rejected) {
        this.handlers.push({
          fulfilled: fulfilled,
          rejected: rejected
        });
        return this.handlers.length - 1;
      };
      InterceptorManager.prototype.eject = function eject(id) {
        if (this.handlers[id]) {
          this.handlers[id] = null;
        }
      };
      InterceptorManager.prototype.forEach = function forEach(fn) {
        utils.forEach(this.handlers, function forEachHandler(h) {
          if (h !== null) {
            fn(h);
          }
        });
      };
      module.exports = InterceptorManager;
    },
    './node_modules/axios/lib/core/buildFullPath.js': function node_modulesAxiosLibCoreBuildFullPathJs(module, exports, __webpack_require__) {
      'use strict';
      var isAbsoluteURL = __webpack_require__('./node_modules/axios/lib/helpers/isAbsoluteURL.js');
      var combineURLs = __webpack_require__('./node_modules/axios/lib/helpers/combineURLs.js');
      module.exports = function buildFullPath(baseURL, requestedURL) {
        if (baseURL && !isAbsoluteURL(requestedURL)) {
          return combineURLs(baseURL, requestedURL);
        }
        return requestedURL;
      };
    },
    './node_modules/axios/lib/core/createError.js': function node_modulesAxiosLibCoreCreateErrorJs(module, exports, __webpack_require__) {
      'use strict';
      var enhanceError = __webpack_require__('./node_modules/axios/lib/core/enhanceError.js');
      module.exports = function createError(message, config, code, request, response) {
        var error = new Error(message);
        return enhanceError(error, config, code, request, response);
      };
    },
    './node_modules/axios/lib/core/dispatchRequest.js': function node_modulesAxiosLibCoreDispatchRequestJs(module, exports, __webpack_require__) {
      'use strict';
      var utils = __webpack_require__('./node_modules/axios/lib/utils.js');
      var transformData = __webpack_require__('./node_modules/axios/lib/core/transformData.js');
      var isCancel = __webpack_require__('./node_modules/axios/lib/cancel/isCancel.js');
      var defaults = __webpack_require__('./node_modules/axios/lib/defaults.js');
      function throwIfCancellationRequested(config) {
        if (config.cancelToken) {
          config.cancelToken.throwIfRequested();
        }
      }
      module.exports = function dispatchRequest(config) {
        throwIfCancellationRequested(config);
        config.headers = config.headers || {};
        config.data = transformData(config.data, config.headers, config.transformRequest);
        config.headers = utils.merge(config.headers.common || {}, config.headers[config.method] || {}, config.headers);
        utils.forEach([ 'delete', 'get', 'head', 'post', 'put', 'patch', 'common' ], function cleanHeaderConfig(method) {
          delete config.headers[method];
        });
        var adapter = config.adapter || defaults.adapter;
        return adapter(config).then(function onAdapterResolution(response) {
          throwIfCancellationRequested(config);
          response.data = transformData(response.data, response.headers, config.transformResponse);
          return response;
        }, function onAdapterRejection(reason) {
          if (!isCancel(reason)) {
            throwIfCancellationRequested(config);
            if (reason && reason.response) {
              reason.response.data = transformData(reason.response.data, reason.response.headers, config.transformResponse);
            }
          }
          return Promise.reject(reason);
        });
      };
    },
    './node_modules/axios/lib/core/enhanceError.js': function node_modulesAxiosLibCoreEnhanceErrorJs(module, exports, __webpack_require__) {
      'use strict';
      module.exports = function enhanceError(error, config, code, request, response) {
        error.config = config;
        if (code) {
          error.code = code;
        }
        error.request = request;
        error.response = response;
        error.isAxiosError = true;
        error.toJSON = function() {
          return {
            message: this.message,
            name: this.name,
            description: this.description,
            number: this.number,
            fileName: this.fileName,
            lineNumber: this.lineNumber,
            columnNumber: this.columnNumber,
            stack: this.stack,
            config: this.config,
            code: this.code
          };
        };
        return error;
      };
    },
    './node_modules/axios/lib/core/mergeConfig.js': function node_modulesAxiosLibCoreMergeConfigJs(module, exports, __webpack_require__) {
      'use strict';
      var utils = __webpack_require__('./node_modules/axios/lib/utils.js');
      module.exports = function mergeConfig(config1, config2) {
        config2 = config2 || {};
        var config = {};
        var valueFromConfig2Keys = [ 'url', 'method', 'params', 'data' ];
        var mergeDeepPropertiesKeys = [ 'headers', 'auth', 'proxy' ];
        var defaultToConfig2Keys = [ 'baseURL', 'url', 'transformRequest', 'transformResponse', 'paramsSerializer', 'timeout', 'withCredentials', 'adapter', 'responseType', 'xsrfCookieName', 'xsrfHeaderName', 'onUploadProgress', 'onDownloadProgress', 'maxContentLength', 'validateStatus', 'maxRedirects', 'httpAgent', 'httpsAgent', 'cancelToken', 'socketPath' ];
        utils.forEach(valueFromConfig2Keys, function valueFromConfig2(prop) {
          if (typeof config2[prop] !== 'undefined') {
            config[prop] = config2[prop];
          }
        });
        utils.forEach(mergeDeepPropertiesKeys, function mergeDeepProperties(prop) {
          if (utils.isObject(config2[prop])) {
            config[prop] = utils.deepMerge(config1[prop], config2[prop]);
          } else if (typeof config2[prop] !== 'undefined') {
            config[prop] = config2[prop];
          } else if (utils.isObject(config1[prop])) {
            config[prop] = utils.deepMerge(config1[prop]);
          } else if (typeof config1[prop] !== 'undefined') {
            config[prop] = config1[prop];
          }
        });
        utils.forEach(defaultToConfig2Keys, function defaultToConfig2(prop) {
          if (typeof config2[prop] !== 'undefined') {
            config[prop] = config2[prop];
          } else if (typeof config1[prop] !== 'undefined') {
            config[prop] = config1[prop];
          }
        });
        var axiosKeys = valueFromConfig2Keys.concat(mergeDeepPropertiesKeys).concat(defaultToConfig2Keys);
        var otherKeys = Object.keys(config2).filter(function filterAxiosKeys(key) {
          return axiosKeys.indexOf(key) === -1;
        });
        utils.forEach(otherKeys, function otherKeysDefaultToConfig2(prop) {
          if (typeof config2[prop] !== 'undefined') {
            config[prop] = config2[prop];
          } else if (typeof config1[prop] !== 'undefined') {
            config[prop] = config1[prop];
          }
        });
        return config;
      };
    },
    './node_modules/axios/lib/core/settle.js': function node_modulesAxiosLibCoreSettleJs(module, exports, __webpack_require__) {
      'use strict';
      var createError = __webpack_require__('./node_modules/axios/lib/core/createError.js');
      module.exports = function settle(resolve, reject, response) {
        var validateStatus = response.config.validateStatus;
        if (!validateStatus || validateStatus(response.status)) {
          resolve(response);
        } else {
          reject(createError('Request failed with status code ' + response.status, response.config, null, response.request, response));
        }
      };
    },
    './node_modules/axios/lib/core/transformData.js': function node_modulesAxiosLibCoreTransformDataJs(module, exports, __webpack_require__) {
      'use strict';
      var utils = __webpack_require__('./node_modules/axios/lib/utils.js');
      module.exports = function transformData(data, headers, fns) {
        utils.forEach(fns, function transform(fn) {
          data = fn(data, headers);
        });
        return data;
      };
    },
    './node_modules/axios/lib/defaults.js': function node_modulesAxiosLibDefaultsJs(module, exports, __webpack_require__) {
      'use strict';
      (function(process) {
        var utils = __webpack_require__('./node_modules/axios/lib/utils.js');
        var normalizeHeaderName = __webpack_require__('./node_modules/axios/lib/helpers/normalizeHeaderName.js');
        var DEFAULT_CONTENT_TYPE = {
          'Content-Type': 'application/x-www-form-urlencoded'
        };
        function setContentTypeIfUnset(headers, value) {
          if (!utils.isUndefined(headers) && utils.isUndefined(headers['Content-Type'])) {
            headers['Content-Type'] = value;
          }
        }
        function getDefaultAdapter() {
          var adapter;
          if (typeof XMLHttpRequest !== 'undefined') {
            adapter = __webpack_require__('./node_modules/axios/lib/adapters/xhr.js');
          } else if (typeof process !== 'undefined' && Object.prototype.toString.call(process) === '[object process]') {
            adapter = __webpack_require__('./node_modules/axios/lib/adapters/xhr.js');
          }
          return adapter;
        }
        var defaults = {
          adapter: getDefaultAdapter(),
          transformRequest: [ function transformRequest(data, headers) {
            normalizeHeaderName(headers, 'Accept');
            normalizeHeaderName(headers, 'Content-Type');
            if (utils.isFormData(data) || utils.isArrayBuffer(data) || utils.isBuffer(data) || utils.isStream(data) || utils.isFile(data) || utils.isBlob(data)) {
              return data;
            }
            if (utils.isArrayBufferView(data)) {
              return data.buffer;
            }
            if (utils.isURLSearchParams(data)) {
              setContentTypeIfUnset(headers, 'application/x-www-form-urlencoded;charset=utf-8');
              return data.toString();
            }
            if (utils.isObject(data)) {
              setContentTypeIfUnset(headers, 'application/json;charset=utf-8');
              return JSON.stringify(data);
            }
            return data;
          } ],
          transformResponse: [ function transformResponse(data) {
            if (typeof data === 'string') {
              try {
                data = JSON.parse(data);
              } catch (e) {}
            }
            return data;
          } ],
          timeout: 0,
          xsrfCookieName: 'XSRF-TOKEN',
          xsrfHeaderName: 'X-XSRF-TOKEN',
          maxContentLength: -1,
          validateStatus: function validateStatus(status) {
            return status >= 200 && status < 300;
          }
        };
        defaults.headers = {
          common: {
            Accept: 'application/json, text/plain, */*'
          }
        };
        utils.forEach([ 'delete', 'get', 'head' ], function forEachMethodNoData(method) {
          defaults.headers[method] = {};
        });
        utils.forEach([ 'post', 'put', 'patch' ], function forEachMethodWithData(method) {
          defaults.headers[method] = utils.merge(DEFAULT_CONTENT_TYPE);
        });
        module.exports = defaults;
      }).call(this, __webpack_require__('./node_modules/process/browser.js'));
    },
    './node_modules/axios/lib/helpers/bind.js': function node_modulesAxiosLibHelpersBindJs(module, exports, __webpack_require__) {
      'use strict';
      module.exports = function bind(fn, thisArg) {
        return function wrap() {
          var args = new Array(arguments.length);
          for (var i = 0; i < args.length; i++) {
            args[i] = arguments[i];
          }
          return fn.apply(thisArg, args);
        };
      };
    },
    './node_modules/axios/lib/helpers/buildURL.js': function node_modulesAxiosLibHelpersBuildURLJs(module, exports, __webpack_require__) {
      'use strict';
      var utils = __webpack_require__('./node_modules/axios/lib/utils.js');
      function encode(val) {
        return encodeURIComponent(val).replace(/%40/gi, '@').replace(/%3A/gi, ':').replace(/%24/g, '$').replace(/%2C/gi, ',').replace(/%20/g, '+').replace(/%5B/gi, '[').replace(/%5D/gi, ']');
      }
      module.exports = function buildURL(url, params, paramsSerializer) {
        if (!params) {
          return url;
        }
        var serializedParams;
        if (paramsSerializer) {
          serializedParams = paramsSerializer(params);
        } else if (utils.isURLSearchParams(params)) {
          serializedParams = params.toString();
        } else {
          var parts = [];
          utils.forEach(params, function serialize(val, key) {
            if (val === null || typeof val === 'undefined') {
              return;
            }
            if (utils.isArray(val)) {
              key = key + '[]';
            } else {
              val = [ val ];
            }
            utils.forEach(val, function parseValue(v) {
              if (utils.isDate(v)) {
                v = v.toISOString();
              } else if (utils.isObject(v)) {
                v = JSON.stringify(v);
              }
              parts.push(encode(key) + '=' + encode(v));
            });
          });
          serializedParams = parts.join('&');
        }
        if (serializedParams) {
          var hashmarkIndex = url.indexOf('#');
          if (hashmarkIndex !== -1) {
            url = url.slice(0, hashmarkIndex);
          }
          url += (url.indexOf('?') === -1 ? '?' : '&') + serializedParams;
        }
        return url;
      };
    },
    './node_modules/axios/lib/helpers/combineURLs.js': function node_modulesAxiosLibHelpersCombineURLsJs(module, exports, __webpack_require__) {
      'use strict';
      module.exports = function combineURLs(baseURL, relativeURL) {
        return relativeURL ? baseURL.replace(/\/+$/, '') + '/' + relativeURL.replace(/^\/+/, '') : baseURL;
      };
    },
    './node_modules/axios/lib/helpers/cookies.js': function node_modulesAxiosLibHelpersCookiesJs(module, exports, __webpack_require__) {
      'use strict';
      var utils = __webpack_require__('./node_modules/axios/lib/utils.js');
      module.exports = utils.isStandardBrowserEnv() ? function standardBrowserEnv() {
        return {
          write: function write(name, value, expires, path, domain, secure) {
            var cookie = [];
            cookie.push(name + '=' + encodeURIComponent(value));
            if (utils.isNumber(expires)) {
              cookie.push('expires=' + new Date(expires).toGMTString());
            }
            if (utils.isString(path)) {
              cookie.push('path=' + path);
            }
            if (utils.isString(domain)) {
              cookie.push('domain=' + domain);
            }
            if (secure === true) {
              cookie.push('secure');
            }
            document.cookie = cookie.join('; ');
          },
          read: function read(name) {
            var match = document.cookie.match(new RegExp('(^|;\\s*)(' + name + ')=([^;]*)'));
            return match ? decodeURIComponent(match[3]) : null;
          },
          remove: function remove(name) {
            this.write(name, '', Date.now() - 864e5);
          }
        };
      }() : function nonStandardBrowserEnv() {
        return {
          write: function write() {},
          read: function read() {
            return null;
          },
          remove: function remove() {}
        };
      }();
    },
    './node_modules/axios/lib/helpers/isAbsoluteURL.js': function node_modulesAxiosLibHelpersIsAbsoluteURLJs(module, exports, __webpack_require__) {
      'use strict';
      module.exports = function isAbsoluteURL(url) {
        return /^([a-z][a-z\d\+\-\.]*:)?\/\//i.test(url);
      };
    },
    './node_modules/axios/lib/helpers/isURLSameOrigin.js': function node_modulesAxiosLibHelpersIsURLSameOriginJs(module, exports, __webpack_require__) {
      'use strict';
      var utils = __webpack_require__('./node_modules/axios/lib/utils.js');
      module.exports = utils.isStandardBrowserEnv() ? function standardBrowserEnv() {
        var msie = /(msie|trident)/i.test(navigator.userAgent);
        var urlParsingNode = document.createElement('a');
        var originURL;
        function resolveURL(url) {
          var href = url;
          if (msie) {
            urlParsingNode.setAttribute('href', href);
            href = urlParsingNode.href;
          }
          urlParsingNode.setAttribute('href', href);
          return {
            href: urlParsingNode.href,
            protocol: urlParsingNode.protocol ? urlParsingNode.protocol.replace(/:$/, '') : '',
            host: urlParsingNode.host,
            search: urlParsingNode.search ? urlParsingNode.search.replace(/^\?/, '') : '',
            hash: urlParsingNode.hash ? urlParsingNode.hash.replace(/^#/, '') : '',
            hostname: urlParsingNode.hostname,
            port: urlParsingNode.port,
            pathname: urlParsingNode.pathname.charAt(0) === '/' ? urlParsingNode.pathname : '/' + urlParsingNode.pathname
          };
        }
        originURL = resolveURL(window.location.href);
        return function isURLSameOrigin(requestURL) {
          var parsed = utils.isString(requestURL) ? resolveURL(requestURL) : requestURL;
          return parsed.protocol === originURL.protocol && parsed.host === originURL.host;
        };
      }() : function nonStandardBrowserEnv() {
        return function isURLSameOrigin() {
          return true;
        };
      }();
    },
    './node_modules/axios/lib/helpers/normalizeHeaderName.js': function node_modulesAxiosLibHelpersNormalizeHeaderNameJs(module, exports, __webpack_require__) {
      'use strict';
      var utils = __webpack_require__('./node_modules/axios/lib/utils.js');
      module.exports = function normalizeHeaderName(headers, normalizedName) {
        utils.forEach(headers, function processHeader(value, name) {
          if (name !== normalizedName && name.toUpperCase() === normalizedName.toUpperCase()) {
            headers[normalizedName] = value;
            delete headers[name];
          }
        });
      };
    },
    './node_modules/axios/lib/helpers/parseHeaders.js': function node_modulesAxiosLibHelpersParseHeadersJs(module, exports, __webpack_require__) {
      'use strict';
      var utils = __webpack_require__('./node_modules/axios/lib/utils.js');
      var ignoreDuplicateOf = [ 'age', 'authorization', 'content-length', 'content-type', 'etag', 'expires', 'from', 'host', 'if-modified-since', 'if-unmodified-since', 'last-modified', 'location', 'max-forwards', 'proxy-authorization', 'referer', 'retry-after', 'user-agent' ];
      module.exports = function parseHeaders(headers) {
        var parsed = {};
        var key;
        var val;
        var i;
        if (!headers) {
          return parsed;
        }
        utils.forEach(headers.split('\n'), function parser(line) {
          i = line.indexOf(':');
          key = utils.trim(line.substr(0, i)).toLowerCase();
          val = utils.trim(line.substr(i + 1));
          if (key) {
            if (parsed[key] && ignoreDuplicateOf.indexOf(key) >= 0) {
              return;
            }
            if (key === 'set-cookie') {
              parsed[key] = (parsed[key] ? parsed[key] : []).concat([ val ]);
            } else {
              parsed[key] = parsed[key] ? parsed[key] + ', ' + val : val;
            }
          }
        });
        return parsed;
      };
    },
    './node_modules/axios/lib/helpers/spread.js': function node_modulesAxiosLibHelpersSpreadJs(module, exports, __webpack_require__) {
      'use strict';
      module.exports = function spread(callback) {
        return function wrap(arr) {
          return callback.apply(null, arr);
        };
      };
    },
    './node_modules/axios/lib/utils.js': function node_modulesAxiosLibUtilsJs(module, exports, __webpack_require__) {
      'use strict';
      var bind = __webpack_require__('./node_modules/axios/lib/helpers/bind.js');
      var toString = Object.prototype.toString;
      function isArray(val) {
        return toString.call(val) === '[object Array]';
      }
      function isUndefined(val) {
        return typeof val === 'undefined';
      }
      function isBuffer(val) {
        return val !== null && !isUndefined(val) && val.constructor !== null && !isUndefined(val.constructor) && typeof val.constructor.isBuffer === 'function' && val.constructor.isBuffer(val);
      }
      function isArrayBuffer(val) {
        return toString.call(val) === '[object ArrayBuffer]';
      }
      function isFormData(val) {
        return typeof FormData !== 'undefined' && val instanceof FormData;
      }
      function isArrayBufferView(val) {
        var result;
        if (typeof ArrayBuffer !== 'undefined' && ArrayBuffer.isView) {
          result = ArrayBuffer.isView(val);
        } else {
          result = val && val.buffer && val.buffer instanceof ArrayBuffer;
        }
        return result;
      }
      function isString(val) {
        return typeof val === 'string';
      }
      function isNumber(val) {
        return typeof val === 'number';
      }
      function isObject(val) {
        return val !== null && _typeof(val) === 'object';
      }
      function isDate(val) {
        return toString.call(val) === '[object Date]';
      }
      function isFile(val) {
        return toString.call(val) === '[object File]';
      }
      function isBlob(val) {
        return toString.call(val) === '[object Blob]';
      }
      function isFunction(val) {
        return toString.call(val) === '[object Function]';
      }
      function isStream(val) {
        return isObject(val) && isFunction(val.pipe);
      }
      function isURLSearchParams(val) {
        return typeof URLSearchParams !== 'undefined' && val instanceof URLSearchParams;
      }
      function trim(str) {
        return str.replace(/^\s*/, '').replace(/\s*$/, '');
      }
      function isStandardBrowserEnv() {
        if (typeof navigator !== 'undefined' && (navigator.product === 'ReactNative' || navigator.product === 'NativeScript' || navigator.product === 'NS')) {
          return false;
        }
        return typeof window !== 'undefined' && typeof document !== 'undefined';
      }
      function forEach(obj, fn) {
        if (obj === null || typeof obj === 'undefined') {
          return;
        }
        if (_typeof(obj) !== 'object') {
          obj = [ obj ];
        }
        if (isArray(obj)) {
          for (var i = 0, l = obj.length; i < l; i++) {
            fn.call(null, obj[i], i, obj);
          }
        } else {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              fn.call(null, obj[key], key, obj);
            }
          }
        }
      }
      function merge() {
        var result = {};
        function assignValue(val, key) {
          if (_typeof(result[key]) === 'object' && _typeof(val) === 'object') {
            result[key] = merge(result[key], val);
          } else {
            result[key] = val;
          }
        }
        for (var i = 0, l = arguments.length; i < l; i++) {
          forEach(arguments[i], assignValue);
        }
        return result;
      }
      function deepMerge() {
        var result = {};
        function assignValue(val, key) {
          if (_typeof(result[key]) === 'object' && _typeof(val) === 'object') {
            result[key] = deepMerge(result[key], val);
          } else if (_typeof(val) === 'object') {
            result[key] = deepMerge({}, val);
          } else {
            result[key] = val;
          }
        }
        for (var i = 0, l = arguments.length; i < l; i++) {
          forEach(arguments[i], assignValue);
        }
        return result;
      }
      function extend(a, b, thisArg) {
        forEach(b, function assignValue(val, key) {
          if (thisArg && typeof val === 'function') {
            a[key] = bind(val, thisArg);
          } else {
            a[key] = val;
          }
        });
        return a;
      }
      module.exports = {
        isArray: isArray,
        isArrayBuffer: isArrayBuffer,
        isBuffer: isBuffer,
        isFormData: isFormData,
        isArrayBufferView: isArrayBufferView,
        isString: isString,
        isNumber: isNumber,
        isObject: isObject,
        isUndefined: isUndefined,
        isDate: isDate,
        isFile: isFile,
        isBlob: isBlob,
        isFunction: isFunction,
        isStream: isStream,
        isURLSearchParams: isURLSearchParams,
        isStandardBrowserEnv: isStandardBrowserEnv,
        forEach: forEach,
        merge: merge,
        deepMerge: deepMerge,
        extend: extend,
        trim: trim
      };
    },
    './node_modules/core-js-pure/es/promise/index.js': function node_modulesCoreJsPureEsPromiseIndexJs(module, exports, __webpack_require__) {
      __webpack_require__('./node_modules/core-js-pure/modules/es.object.to-string.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.string.iterator.js');
      __webpack_require__('./node_modules/core-js-pure/modules/web.dom-collections.iterator.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.promise.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.promise.all-settled.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.promise.finally.js');
      var path = __webpack_require__('./node_modules/core-js-pure/internals/path.js');
      module.exports = path.Promise;
    },
    './node_modules/core-js-pure/es/typed-array/methods.js': function node_modulesCoreJsPureEsTypedArrayMethodsJs(module, exports, __webpack_require__) {
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.from.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.of.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.copy-within.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.every.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.fill.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.filter.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.find.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.find-index.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.for-each.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.includes.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.index-of.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.join.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.last-index-of.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.map.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.reduce.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.reduce-right.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.reverse.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.set.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.slice.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.some.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.sort.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.subarray.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.to-locale-string.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.to-string.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.iterator.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.object.to-string.js');
    },
    './node_modules/core-js-pure/es/typed-array/uint32-array.js': function node_modulesCoreJsPureEsTypedArrayUint32ArrayJs(module, exports, __webpack_require__) {
      __webpack_require__('./node_modules/core-js-pure/modules/es.typed-array.uint32-array.js');
      __webpack_require__('./node_modules/core-js-pure/es/typed-array/methods.js');
      var global = __webpack_require__('./node_modules/core-js-pure/internals/global.js');
      module.exports = global.Uint32Array;
    },
    './node_modules/core-js-pure/es/weak-map/index.js': function node_modulesCoreJsPureEsWeakMapIndexJs(module, exports, __webpack_require__) {
      __webpack_require__('./node_modules/core-js-pure/modules/es.object.to-string.js');
      __webpack_require__('./node_modules/core-js-pure/modules/es.weak-map.js');
      __webpack_require__('./node_modules/core-js-pure/modules/web.dom-collections.iterator.js');
      var path = __webpack_require__('./node_modules/core-js-pure/internals/path.js');
      module.exports = path.WeakMap;
    },
    './node_modules/core-js-pure/features/promise/index.js': function node_modulesCoreJsPureFeaturesPromiseIndexJs(module, exports, __webpack_require__) {
      var parent = __webpack_require__('./node_modules/core-js-pure/es/promise/index.js');
      __webpack_require__('./node_modules/core-js-pure/modules/esnext.aggregate-error.js');
      __webpack_require__('./node_modules/core-js-pure/modules/esnext.promise.all-settled.js');
      __webpack_require__('./node_modules/core-js-pure/modules/esnext.promise.try.js');
      __webpack_require__('./node_modules/core-js-pure/modules/esnext.promise.any.js');
      module.exports = parent;
    },
    './node_modules/core-js-pure/features/typed-array/uint32-array.js': function node_modulesCoreJsPureFeaturesTypedArrayUint32ArrayJs(module, exports, __webpack_require__) {
      var parent = __webpack_require__('./node_modules/core-js-pure/es/typed-array/uint32-array.js');
      module.exports = parent;
    },
    './node_modules/core-js-pure/internals/a-function.js': function node_modulesCoreJsPureInternalsAFunctionJs(module, exports) {
      module.exports = function(it) {
        if (typeof it != 'function') {
          throw TypeError(String(it) + ' is not a function');
        }
        return it;
      };
    },
    './node_modules/core-js-pure/internals/a-possible-prototype.js': function node_modulesCoreJsPureInternalsAPossiblePrototypeJs(module, exports, __webpack_require__) {
      var isObject = __webpack_require__('./node_modules/core-js-pure/internals/is-object.js');
      module.exports = function(it) {
        if (!isObject(it) && it !== null) {
          throw TypeError('Can\'t set ' + String(it) + ' as a prototype');
        }
        return it;
      };
    },
    './node_modules/core-js-pure/internals/add-to-unscopables.js': function node_modulesCoreJsPureInternalsAddToUnscopablesJs(module, exports) {
      module.exports = function() {};
    },
    './node_modules/core-js-pure/internals/an-instance.js': function node_modulesCoreJsPureInternalsAnInstanceJs(module, exports) {
      module.exports = function(it, Constructor, name) {
        if (!(it instanceof Constructor)) {
          throw TypeError('Incorrect ' + (name ? name + ' ' : '') + 'invocation');
        }
        return it;
      };
    },
    './node_modules/core-js-pure/internals/an-object.js': function node_modulesCoreJsPureInternalsAnObjectJs(module, exports, __webpack_require__) {
      var isObject = __webpack_require__('./node_modules/core-js-pure/internals/is-object.js');
      module.exports = function(it) {
        if (!isObject(it)) {
          throw TypeError(String(it) + ' is not an object');
        }
        return it;
      };
    },
    './node_modules/core-js-pure/internals/array-includes.js': function node_modulesCoreJsPureInternalsArrayIncludesJs(module, exports, __webpack_require__) {
      var toIndexedObject = __webpack_require__('./node_modules/core-js-pure/internals/to-indexed-object.js');
      var toLength = __webpack_require__('./node_modules/core-js-pure/internals/to-length.js');
      var toAbsoluteIndex = __webpack_require__('./node_modules/core-js-pure/internals/to-absolute-index.js');
      var createMethod = function createMethod(IS_INCLUDES) {
        return function($this, el, fromIndex) {
          var O = toIndexedObject($this);
          var length = toLength(O.length);
          var index = toAbsoluteIndex(fromIndex, length);
          var value;
          if (IS_INCLUDES && el != el) {
            while (length > index) {
              value = O[index++];
              if (value != value) {
                return true;
              }
            }
          } else {
            for (;length > index; index++) {
              if ((IS_INCLUDES || index in O) && O[index] === el) {
                return IS_INCLUDES || index || 0;
              }
            }
          }
          return !IS_INCLUDES && -1;
        };
      };
      module.exports = {
        includes: createMethod(true),
        indexOf: createMethod(false)
      };
    },
    './node_modules/core-js-pure/internals/array-iteration.js': function node_modulesCoreJsPureInternalsArrayIterationJs(module, exports, __webpack_require__) {
      var bind = __webpack_require__('./node_modules/core-js-pure/internals/function-bind-context.js');
      var IndexedObject = __webpack_require__('./node_modules/core-js-pure/internals/indexed-object.js');
      var toObject = __webpack_require__('./node_modules/core-js-pure/internals/to-object.js');
      var toLength = __webpack_require__('./node_modules/core-js-pure/internals/to-length.js');
      var arraySpeciesCreate = __webpack_require__('./node_modules/core-js-pure/internals/array-species-create.js');
      var push = [].push;
      var createMethod = function createMethod(TYPE) {
        var IS_MAP = TYPE == 1;
        var IS_FILTER = TYPE == 2;
        var IS_SOME = TYPE == 3;
        var IS_EVERY = TYPE == 4;
        var IS_FIND_INDEX = TYPE == 6;
        var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
        return function($this, callbackfn, that, specificCreate) {
          var O = toObject($this);
          var self = IndexedObject(O);
          var boundFunction = bind(callbackfn, that, 3);
          var length = toLength(self.length);
          var index = 0;
          var create = specificCreate || arraySpeciesCreate;
          var target = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
          var value, result;
          for (;length > index; index++) {
            if (NO_HOLES || index in self) {
              value = self[index];
              result = boundFunction(value, index, O);
              if (TYPE) {
                if (IS_MAP) {
                  target[index] = result;
                } else if (result) {
                  switch (TYPE) {
                   case 3:
                    return true;

                   case 5:
                    return value;

                   case 6:
                    return index;

                   case 2:
                    push.call(target, value);
                  }
                } else if (IS_EVERY) {
                  return false;
                }
              }
            }
          }
          return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
        };
      };
      module.exports = {
        forEach: createMethod(0),
        map: createMethod(1),
        filter: createMethod(2),
        some: createMethod(3),
        every: createMethod(4),
        find: createMethod(5),
        findIndex: createMethod(6)
      };
    },
    './node_modules/core-js-pure/internals/array-species-create.js': function node_modulesCoreJsPureInternalsArraySpeciesCreateJs(module, exports, __webpack_require__) {
      var isObject = __webpack_require__('./node_modules/core-js-pure/internals/is-object.js');
      var isArray = __webpack_require__('./node_modules/core-js-pure/internals/is-array.js');
      var wellKnownSymbol = __webpack_require__('./node_modules/core-js-pure/internals/well-known-symbol.js');
      var SPECIES = wellKnownSymbol('species');
      module.exports = function(originalArray, length) {
        var C;
        if (isArray(originalArray)) {
          C = originalArray.constructor;
          if (typeof C == 'function' && (C === Array || isArray(C.prototype))) {
            C = undefined;
          } else if (isObject(C)) {
            C = C[SPECIES];
            if (C === null) {
              C = undefined;
            }
          }
        }
        return new (C === undefined ? Array : C)(length === 0 ? 0 : length);
      };
    },
    './node_modules/core-js-pure/internals/call-with-safe-iteration-closing.js': function node_modulesCoreJsPureInternalsCallWithSafeIterationClosingJs(module, exports, __webpack_require__) {
      var anObject = __webpack_require__('./node_modules/core-js-pure/internals/an-object.js');
      module.exports = function(iterator, fn, value, ENTRIES) {
        try {
          return ENTRIES ? fn(anObject(value)[0], value[1]) : fn(value);
        } catch (error) {
          var returnMethod = iterator['return'];
          if (returnMethod !== undefined) {
            anObject(returnMethod.call(iterator));
          }
          throw error;
        }
      };
    },
    './node_modules/core-js-pure/internals/check-correctness-of-iteration.js': function node_modulesCoreJsPureInternalsCheckCorrectnessOfIterationJs(module, exports, __webpack_require__) {
      var wellKnownSymbol = __webpack_require__('./node_modules/core-js-pure/internals/well-known-symbol.js');
      var ITERATOR = wellKnownSymbol('iterator');
      var SAFE_CLOSING = false;
      try {
        var called = 0;
        var iteratorWithReturn = {
          next: function next() {
            return {
              done: !!called++
            };
          },
          return: function _return() {
            SAFE_CLOSING = true;
          }
        };
        iteratorWithReturn[ITERATOR] = function() {
          return this;
        };
        Array.from(iteratorWithReturn, function() {
          throw 2;
        });
      } catch (error) {}
      module.exports = function(exec, SKIP_CLOSING) {
        if (!SKIP_CLOSING && !SAFE_CLOSING) {
          return false;
        }
        var ITERATION_SUPPORT = false;
        try {
          var object = {};
          object[ITERATOR] = function() {
            return {
              next: function next() {
                return {
                  done: ITERATION_SUPPORT = true
                };
              }
            };
          };
          exec(object);
        } catch (error) {}
        return ITERATION_SUPPORT;
      };
    },
    './node_modules/core-js-pure/internals/classof-raw.js': function node_modulesCoreJsPureInternalsClassofRawJs(module, exports) {
      var toString = {}.toString;
      module.exports = function(it) {
        return toString.call(it).slice(8, -1);
      };
    },
    './node_modules/core-js-pure/internals/classof.js': function node_modulesCoreJsPureInternalsClassofJs(module, exports, __webpack_require__) {
      var TO_STRING_TAG_SUPPORT = __webpack_require__('./node_modules/core-js-pure/internals/to-string-tag-support.js');
      var classofRaw = __webpack_require__('./node_modules/core-js-pure/internals/classof-raw.js');
      var wellKnownSymbol = __webpack_require__('./node_modules/core-js-pure/internals/well-known-symbol.js');
      var TO_STRING_TAG = wellKnownSymbol('toStringTag');
      var CORRECT_ARGUMENTS = classofRaw(function() {
        return arguments;
      }()) == 'Arguments';
      var tryGet = function tryGet(it, key) {
        try {
          return it[key];
        } catch (error) {}
      };
      module.exports = TO_STRING_TAG_SUPPORT ? classofRaw : function(it) {
        var O, tag, result;
        return it === undefined ? 'Undefined' : it === null ? 'Null' : typeof (tag = tryGet(O = Object(it), TO_STRING_TAG)) == 'string' ? tag : CORRECT_ARGUMENTS ? classofRaw(O) : (result = classofRaw(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : result;
      };
    },
    './node_modules/core-js-pure/internals/collection-weak.js': function node_modulesCoreJsPureInternalsCollectionWeakJs(module, exports, __webpack_require__) {
      'use strict';
      var redefineAll = __webpack_require__('./node_modules/core-js-pure/internals/redefine-all.js');
      var getWeakData = __webpack_require__('./node_modules/core-js-pure/internals/internal-metadata.js').getWeakData;
      var anObject = __webpack_require__('./node_modules/core-js-pure/internals/an-object.js');
      var isObject = __webpack_require__('./node_modules/core-js-pure/internals/is-object.js');
      var anInstance = __webpack_require__('./node_modules/core-js-pure/internals/an-instance.js');
      var iterate = __webpack_require__('./node_modules/core-js-pure/internals/iterate.js');
      var ArrayIterationModule = __webpack_require__('./node_modules/core-js-pure/internals/array-iteration.js');
      var $has = __webpack_require__('./node_modules/core-js-pure/internals/has.js');
      var InternalStateModule = __webpack_require__('./node_modules/core-js-pure/internals/internal-state.js');
      var setInternalState = InternalStateModule.set;
      var internalStateGetterFor = InternalStateModule.getterFor;
      var find = ArrayIterationModule.find;
      var findIndex = ArrayIterationModule.findIndex;
      var id = 0;
      var uncaughtFrozenStore = function uncaughtFrozenStore(store) {
        return store.frozen || (store.frozen = new UncaughtFrozenStore());
      };
      var UncaughtFrozenStore = function UncaughtFrozenStore() {
        this.entries = [];
      };
      var findUncaughtFrozen = function findUncaughtFrozen(store, key) {
        return find(store.entries, function(it) {
          return it[0] === key;
        });
      };
      UncaughtFrozenStore.prototype = {
        get: function get(key) {
          var entry = findUncaughtFrozen(this, key);
          if (entry) {
            return entry[1];
          }
        },
        has: function has(key) {
          return !!findUncaughtFrozen(this, key);
        },
        set: function set(key, value) {
          var entry = findUncaughtFrozen(this, key);
          if (entry) {
            entry[1] = value;
          } else {
            this.entries.push([ key, value ]);
          }
        },
        delete: function _delete(key) {
          var index = findIndex(this.entries, function(it) {
            return it[0] === key;
          });
          if (~index) {
            this.entries.splice(index, 1);
          }
          return !!~index;
        }
      };
      module.exports = {
        getConstructor: function getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
          var C = wrapper(function(that, iterable) {
            anInstance(that, C, CONSTRUCTOR_NAME);
            setInternalState(that, {
              type: CONSTRUCTOR_NAME,
              id: id++,
              frozen: undefined
            });
            if (iterable != undefined) {
              iterate(iterable, that[ADDER], that, IS_MAP);
            }
          });
          var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);
          var define = function define(that, key, value) {
            var state = getInternalState(that);
            var data = getWeakData(anObject(key), true);
            if (data === true) {
              uncaughtFrozenStore(state).set(key, value);
            } else {
              data[state.id] = value;
            }
            return that;
          };
          redefineAll(C.prototype, {
            delete: function _delete(key) {
              var state = getInternalState(this);
              if (!isObject(key)) {
                return false;
              }
              var data = getWeakData(key);
              if (data === true) {
                return uncaughtFrozenStore(state)['delete'](key);
              }
              return data && $has(data, state.id) && delete data[state.id];
            },
            has: function has(key) {
              var state = getInternalState(this);
              if (!isObject(key)) {
                return false;
              }
              var data = getWeakData(key);
              if (data === true) {
                return uncaughtFrozenStore(state).has(key);
              }
              return data && $has(data, state.id);
            }
          });
          redefineAll(C.prototype, IS_MAP ? {
            get: function get(key) {
              var state = getInternalState(this);
              if (isObject(key)) {
                var data = getWeakData(key);
                if (data === true) {
                  return uncaughtFrozenStore(state).get(key);
                }
                return data ? data[state.id] : undefined;
              }
            },
            set: function set(key, value) {
              return define(this, key, value);
            }
          } : {
            add: function add(value) {
              return define(this, value, true);
            }
          });
          return C;
        }
      };
    },
    './node_modules/core-js-pure/internals/collection.js': function node_modulesCoreJsPureInternalsCollectionJs(module, exports, __webpack_require__) {
      'use strict';
      var $ = __webpack_require__('./node_modules/core-js-pure/internals/export.js');
      var global = __webpack_require__('./node_modules/core-js-pure/internals/global.js');
      var InternalMetadataModule = __webpack_require__('./node_modules/core-js-pure/internals/internal-metadata.js');
      var fails = __webpack_require__('./node_modules/core-js-pure/internals/fails.js');
      var createNonEnumerableProperty = __webpack_require__('./node_modules/core-js-pure/internals/create-non-enumerable-property.js');
      var iterate = __webpack_require__('./node_modules/core-js-pure/internals/iterate.js');
      var anInstance = __webpack_require__('./node_modules/core-js-pure/internals/an-instance.js');
      var isObject = __webpack_require__('./node_modules/core-js-pure/internals/is-object.js');
      var setToStringTag = __webpack_require__('./node_modules/core-js-pure/internals/set-to-string-tag.js');
      var defineProperty = __webpack_require__('./node_modules/core-js-pure/internals/object-define-property.js').f;
      var forEach = __webpack_require__('./node_modules/core-js-pure/internals/array-iteration.js').forEach;
      var DESCRIPTORS = __webpack_require__('./node_modules/core-js-pure/internals/descriptors.js');
      var InternalStateModule = __webpack_require__('./node_modules/core-js-pure/internals/internal-state.js');
      var setInternalState = InternalStateModule.set;
      var internalStateGetterFor = InternalStateModule.getterFor;
      module.exports = function(CONSTRUCTOR_NAME, wrapper, common) {
        var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
        var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
        var ADDER = IS_MAP ? 'set' : 'add';
        var NativeConstructor = global[CONSTRUCTOR_NAME];
        var NativePrototype = NativeConstructor && NativeConstructor.prototype;
        var exported = {};
        var Constructor;
        if (!DESCRIPTORS || typeof NativeConstructor != 'function' || !(IS_WEAK || NativePrototype.forEach && !fails(function() {
          new NativeConstructor().entries().next();
        }))) {
          Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
          InternalMetadataModule.REQUIRED = true;
        } else {
          Constructor = wrapper(function(target, iterable) {
            setInternalState(anInstance(target, Constructor, CONSTRUCTOR_NAME), {
              type: CONSTRUCTOR_NAME,
              collection: new NativeConstructor()
            });
            if (iterable != undefined) {
              iterate(iterable, target[ADDER], target, IS_MAP);
            }
          });
          var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);
          forEach([ 'add', 'clear', 'delete', 'forEach', 'get', 'has', 'set', 'keys', 'values', 'entries' ], function(KEY) {
            var IS_ADDER = KEY == 'add' || KEY == 'set';
            if (KEY in NativePrototype && !(IS_WEAK && KEY == 'clear')) {
              createNonEnumerableProperty(Constructor.prototype, KEY, function(a, b) {
                var collection = getInternalState(this).collection;
                if (!IS_ADDER && IS_WEAK && !isObject(a)) {
                  return KEY == 'get' ? undefined : false;
                }
                var result = collection[KEY](a === 0 ? 0 : a, b);
                return IS_ADDER ? this : result;
              });
            }
          });
          IS_WEAK || defineProperty(Constructor.prototype, 'size', {
            configurable: true,
            get: function get() {
              return getInternalState(this).collection.size;
            }
          });
        }
        setToStringTag(Constructor, CONSTRUCTOR_NAME, false, true);
        exported[CONSTRUCTOR_NAME] = Constructor;
        $({
          global: true,
          forced: true
        }, exported);
        if (!IS_WEAK) {
          common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);
        }
        return Constructor;
      };
    },
    './node_modules/core-js-pure/internals/correct-prototype-getter.js': function node_modulesCoreJsPureInternalsCorrectPrototypeGetterJs(module, exports, __webpack_require__) {
      var fails = __webpack_require__('./node_modules/core-js-pure/internals/fails.js');
      module.exports = !fails(function() {
        function F() {}
        F.prototype.constructor = null;
        return Object.getPrototypeOf(new F()) !== F.prototype;
      });
    },
    './node_modules/core-js-pure/internals/create-iterator-constructor.js': function node_modulesCoreJsPureInternalsCreateIteratorConstructorJs(module, exports, __webpack_require__) {
      'use strict';
      var IteratorPrototype = __webpack_require__('./node_modules/core-js-pure/internals/iterators-core.js').IteratorPrototype;
      var create = __webpack_require__('./node_modules/core-js-pure/internals/object-create.js');
      var createPropertyDescriptor = __webpack_require__('./node_modules/core-js-pure/internals/create-property-descriptor.js');
      var setToStringTag = __webpack_require__('./node_modules/core-js-pure/internals/set-to-string-tag.js');
      var Iterators = __webpack_require__('./node_modules/core-js-pure/internals/iterators.js');
      var returnThis = function returnThis() {
        return this;
      };
      module.exports = function(IteratorConstructor, NAME, next) {
        var TO_STRING_TAG = NAME + ' Iterator';
        IteratorConstructor.prototype = create(IteratorPrototype, {
          next: createPropertyDescriptor(1, next)
        });
        setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
        Iterators[TO_STRING_TAG] = returnThis;
        return IteratorConstructor;
      };
    },
    './node_modules/core-js-pure/internals/create-non-enumerable-property.js': function node_modulesCoreJsPureInternalsCreateNonEnumerablePropertyJs(module, exports, __webpack_require__) {
      var DESCRIPTORS = __webpack_require__('./node_modules/core-js-pure/internals/descriptors.js');
      var definePropertyModule = __webpack_require__('./node_modules/core-js-pure/internals/object-define-property.js');
      var createPropertyDescriptor = __webpack_require__('./node_modules/core-js-pure/internals/create-property-descriptor.js');
      module.exports = DESCRIPTORS ? function(object, key, value) {
        return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
      } : function(object, key, value) {
        object[key] = value;
        return object;
      };
    },
    './node_modules/core-js-pure/internals/create-property-descriptor.js': function node_modulesCoreJsPureInternalsCreatePropertyDescriptorJs(module, exports) {
      module.exports = function(bitmap, value) {
        return {
          enumerable: !(bitmap & 1),
          configurable: !(bitmap & 2),
          writable: !(bitmap & 4),
          value: value
        };
      };
    },
    './node_modules/core-js-pure/internals/define-iterator.js': function node_modulesCoreJsPureInternalsDefineIteratorJs(module, exports, __webpack_require__) {
      'use strict';
      var $ = __webpack_require__('./node_modules/core-js-pure/internals/export.js');
      var createIteratorConstructor = __webpack_require__('./node_modules/core-js-pure/internals/create-iterator-constructor.js');
      var getPrototypeOf = __webpack_require__('./node_modules/core-js-pure/internals/object-get-prototype-of.js');
      var setPrototypeOf = __webpack_require__('./node_modules/core-js-pure/internals/object-set-prototype-of.js');
      var setToStringTag = __webpack_require__('./node_modules/core-js-pure/internals/set-to-string-tag.js');
      var createNonEnumerableProperty = __webpack_require__('./node_modules/core-js-pure/internals/create-non-enumerable-property.js');
      var redefine = __webpack_require__('./node_modules/core-js-pure/internals/redefine.js');
      var wellKnownSymbol = __webpack_require__('./node_modules/core-js-pure/internals/well-known-symbol.js');
      var IS_PURE = __webpack_require__('./node_modules/core-js-pure/internals/is-pure.js');
      var Iterators = __webpack_require__('./node_modules/core-js-pure/internals/iterators.js');
      var IteratorsCore = __webpack_require__('./node_modules/core-js-pure/internals/iterators-core.js');
      var IteratorPrototype = IteratorsCore.IteratorPrototype;
      var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
      var ITERATOR = wellKnownSymbol('iterator');
      var KEYS = 'keys';
      var VALUES = 'values';
      var ENTRIES = 'entries';
      var returnThis = function returnThis() {
        return this;
      };
      module.exports = function(Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
        createIteratorConstructor(IteratorConstructor, NAME, next);
        var getIterationMethod = function getIterationMethod(KIND) {
          if (KIND === DEFAULT && defaultIterator) {
            return defaultIterator;
          }
          if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) {
            return IterablePrototype[KIND];
          }
          switch (KIND) {
           case KEYS:
            return function keys() {
              return new IteratorConstructor(this, KIND);
            };

           case VALUES:
            return function values() {
              return new IteratorConstructor(this, KIND);
            };

           case ENTRIES:
            return function entries() {
              return new IteratorConstructor(this, KIND);
            };
          }
          return function() {
            return new IteratorConstructor(this);
          };
        };
        var TO_STRING_TAG = NAME + ' Iterator';
        var INCORRECT_VALUES_NAME = false;
        var IterablePrototype = Iterable.prototype;
        var nativeIterator = IterablePrototype[ITERATOR] || IterablePrototype['@@iterator'] || DEFAULT && IterablePrototype[DEFAULT];
        var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
        var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
        var CurrentIteratorPrototype, methods, KEY;
        if (anyNativeIterator) {
          CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
          if (IteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
            if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
              if (setPrototypeOf) {
                setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
              } else if (typeof CurrentIteratorPrototype[ITERATOR] != 'function') {
                createNonEnumerableProperty(CurrentIteratorPrototype, ITERATOR, returnThis);
              }
            }
            setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
            if (IS_PURE) {
              Iterators[TO_STRING_TAG] = returnThis;
            }
          }
        }
        if (DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
          INCORRECT_VALUES_NAME = true;
          defaultIterator = function values() {
            return nativeIterator.call(this);
          };
        }
        if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR] !== defaultIterator) {
          createNonEnumerableProperty(IterablePrototype, ITERATOR, defaultIterator);
        }
        Iterators[NAME] = defaultIterator;
        if (DEFAULT) {
          methods = {
            values: getIterationMethod(VALUES),
            keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
            entries: getIterationMethod(ENTRIES)
          };
          if (FORCED) {
            for (KEY in methods) {
              if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
                redefine(IterablePrototype, KEY, methods[KEY]);
              }
            }
          } else {
            $({
              target: NAME,
              proto: true,
              forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME
            }, methods);
          }
        }
        return methods;
      };
    },
    './node_modules/core-js-pure/internals/descriptors.js': function node_modulesCoreJsPureInternalsDescriptorsJs(module, exports, __webpack_require__) {
      var fails = __webpack_require__('./node_modules/core-js-pure/internals/fails.js');
      module.exports = !fails(function() {
        return Object.defineProperty({}, 1, {
          get: function get() {
            return 7;
          }
        })[1] != 7;
      });
    },
    './node_modules/core-js-pure/internals/document-create-element.js': function node_modulesCoreJsPureInternalsDocumentCreateElementJs(module, exports, __webpack_require__) {
      var global = __webpack_require__('./node_modules/core-js-pure/internals/global.js');
      var isObject = __webpack_require__('./node_modules/core-js-pure/internals/is-object.js');
      var document = global.document;
      var EXISTS = isObject(document) && isObject(document.createElement);
      module.exports = function(it) {
        return EXISTS ? document.createElement(it) : {};
      };
    },
    './node_modules/core-js-pure/internals/dom-iterables.js': function node_modulesCoreJsPureInternalsDomIterablesJs(module, exports) {
      module.exports = {
        CSSRuleList: 0,
        CSSStyleDeclaration: 0,
        CSSValueList: 0,
        ClientRectList: 0,
        DOMRectList: 0,
        DOMStringList: 0,
        DOMTokenList: 1,
        DataTransferItemList: 0,
        FileList: 0,
        HTMLAllCollection: 0,
        HTMLCollection: 0,
        HTMLFormElement: 0,
        HTMLSelectElement: 0,
        MediaList: 0,
        MimeTypeArray: 0,
        NamedNodeMap: 0,
        NodeList: 1,
        PaintRequestList: 0,
        Plugin: 0,
        PluginArray: 0,
        SVGLengthList: 0,
        SVGNumberList: 0,
        SVGPathSegList: 0,
        SVGPointList: 0,
        SVGStringList: 0,
        SVGTransformList: 0,
        SourceBufferList: 0,
        StyleSheetList: 0,
        TextTrackCueList: 0,
        TextTrackList: 0,
        TouchList: 0
      };
    },
    './node_modules/core-js-pure/internals/engine-is-ios.js': function node_modulesCoreJsPureInternalsEngineIsIosJs(module, exports, __webpack_require__) {
      var userAgent = __webpack_require__('./node_modules/core-js-pure/internals/engine-user-agent.js');
      module.exports = /(iphone|ipod|ipad).*applewebkit/i.test(userAgent);
    },
    './node_modules/core-js-pure/internals/engine-user-agent.js': function node_modulesCoreJsPureInternalsEngineUserAgentJs(module, exports, __webpack_require__) {
      var getBuiltIn = __webpack_require__('./node_modules/core-js-pure/internals/get-built-in.js');
      module.exports = getBuiltIn('navigator', 'userAgent') || '';
    },
    './node_modules/core-js-pure/internals/engine-v8-version.js': function node_modulesCoreJsPureInternalsEngineV8VersionJs(module, exports, __webpack_require__) {
      var global = __webpack_require__('./node_modules/core-js-pure/internals/global.js');
      var userAgent = __webpack_require__('./node_modules/core-js-pure/internals/engine-user-agent.js');
      var process = global.process;
      var versions = process && process.versions;
      var v8 = versions && versions.v8;
      var match, version;
      if (v8) {
        match = v8.split('.');
        version = match[0] + match[1];
      } else if (userAgent) {
        match = userAgent.match(/Edge\/(\d+)/);
        if (!match || match[1] >= 74) {
          match = userAgent.match(/Chrome\/(\d+)/);
          if (match) {
            version = match[1];
          }
        }
      }
      module.exports = version && +version;
    },
    './node_modules/core-js-pure/internals/enum-bug-keys.js': function node_modulesCoreJsPureInternalsEnumBugKeysJs(module, exports) {
      module.exports = [ 'constructor', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable', 'toLocaleString', 'toString', 'valueOf' ];
    },
    './node_modules/core-js-pure/internals/export.js': function node_modulesCoreJsPureInternalsExportJs(module, exports, __webpack_require__) {
      'use strict';
      var global = __webpack_require__('./node_modules/core-js-pure/internals/global.js');
      var getOwnPropertyDescriptor = __webpack_require__('./node_modules/core-js-pure/internals/object-get-own-property-descriptor.js').f;
      var isForced = __webpack_require__('./node_modules/core-js-pure/internals/is-forced.js');
      var path = __webpack_require__('./node_modules/core-js-pure/internals/path.js');
      var bind = __webpack_require__('./node_modules/core-js-pure/internals/function-bind-context.js');
      var createNonEnumerableProperty = __webpack_require__('./node_modules/core-js-pure/internals/create-non-enumerable-property.js');
      var has = __webpack_require__('./node_modules/core-js-pure/internals/has.js');
      var wrapConstructor = function wrapConstructor(NativeConstructor) {
        var Wrapper = function Wrapper(a, b, c) {
          if (this instanceof NativeConstructor) {
            switch (arguments.length) {
             case 0:
              return new NativeConstructor();

             case 1:
              return new NativeConstructor(a);

             case 2:
              return new NativeConstructor(a, b);
            }
            return new NativeConstructor(a, b, c);
          }
          return NativeConstructor.apply(this, arguments);
        };
        Wrapper.prototype = NativeConstructor.prototype;
        return Wrapper;
      };
      module.exports = function(options, source) {
        var TARGET = options.target;
        var GLOBAL = options.global;
        var STATIC = options.stat;
        var PROTO = options.proto;
        var nativeSource = GLOBAL ? global : STATIC ? global[TARGET] : (global[TARGET] || {}).prototype;
        var target = GLOBAL ? path : path[TARGET] || (path[TARGET] = {});
        var targetPrototype = target.prototype;
        var FORCED, USE_NATIVE, VIRTUAL_PROTOTYPE;
        var key, sourceProperty, targetProperty, nativeProperty, resultProperty, descriptor;
        for (key in source) {
          FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
          USE_NATIVE = !FORCED && nativeSource && has(nativeSource, key);
          targetProperty = target[key];
          if (USE_NATIVE) {
            if (options.noTargetGet) {
              descriptor = getOwnPropertyDescriptor(nativeSource, key);
              nativeProperty = descriptor && descriptor.value;
            } else {
              nativeProperty = nativeSource[key];
            }
          }
          sourceProperty = USE_NATIVE && nativeProperty ? nativeProperty : source[key];
          if (USE_NATIVE && _typeof(targetProperty) === _typeof(sourceProperty)) {
            continue;
          }
          if (options.bind && USE_NATIVE) {
            resultProperty = bind(sourceProperty, global);
          } else if (options.wrap && USE_NATIVE) {
            resultProperty = wrapConstructor(sourceProperty);
          } else if (PROTO && typeof sourceProperty == 'function') {
            resultProperty = bind(Function.call, sourceProperty);
          } else {
            resultProperty = sourceProperty;
          }
          if (options.sham || sourceProperty && sourceProperty.sham || targetProperty && targetProperty.sham) {
            createNonEnumerableProperty(resultProperty, 'sham', true);
          }
          target[key] = resultProperty;
          if (PROTO) {
            VIRTUAL_PROTOTYPE = TARGET + 'Prototype';
            if (!has(path, VIRTUAL_PROTOTYPE)) {
              createNonEnumerableProperty(path, VIRTUAL_PROTOTYPE, {});
            }
            path[VIRTUAL_PROTOTYPE][key] = sourceProperty;
            if (options.real && targetPrototype && !targetPrototype[key]) {
              createNonEnumerableProperty(targetPrototype, key, sourceProperty);
            }
          }
        }
      };
    },
    './node_modules/core-js-pure/internals/fails.js': function node_modulesCoreJsPureInternalsFailsJs(module, exports) {
      module.exports = function(exec) {
        try {
          return !!exec();
        } catch (error) {
          return true;
        }
      };
    },
    './node_modules/core-js-pure/internals/freezing.js': function node_modulesCoreJsPureInternalsFreezingJs(module, exports, __webpack_require__) {
      var fails = __webpack_require__('./node_modules/core-js-pure/internals/fails.js');
      module.exports = !fails(function() {
        return Object.isExtensible(Object.preventExtensions({}));
      });
    },
    './node_modules/core-js-pure/internals/function-bind-context.js': function node_modulesCoreJsPureInternalsFunctionBindContextJs(module, exports, __webpack_require__) {
      var aFunction = __webpack_require__('./node_modules/core-js-pure/internals/a-function.js');
      module.exports = function(fn, that, length) {
        aFunction(fn);
        if (that === undefined) {
          return fn;
        }
        switch (length) {
         case 0:
          return function() {
            return fn.call(that);
          };

         case 1:
          return function(a) {
            return fn.call(that, a);
          };

         case 2:
          return function(a, b) {
            return fn.call(that, a, b);
          };

         case 3:
          return function(a, b, c) {
            return fn.call(that, a, b, c);
          };
        }
        return function() {
          return fn.apply(that, arguments);
        };
      };
    },
    './node_modules/core-js-pure/internals/get-built-in.js': function node_modulesCoreJsPureInternalsGetBuiltInJs(module, exports, __webpack_require__) {
      var path = __webpack_require__('./node_modules/core-js-pure/internals/path.js');
      var global = __webpack_require__('./node_modules/core-js-pure/internals/global.js');
      var aFunction = function aFunction(variable) {
        return typeof variable == 'function' ? variable : undefined;
      };
      module.exports = function(namespace, method) {
        return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(global[namespace]) : path[namespace] && path[namespace][method] || global[namespace] && global[namespace][method];
      };
    },
    './node_modules/core-js-pure/internals/get-iterator-method.js': function node_modulesCoreJsPureInternalsGetIteratorMethodJs(module, exports, __webpack_require__) {
      var classof = __webpack_require__('./node_modules/core-js-pure/internals/classof.js');
      var Iterators = __webpack_require__('./node_modules/core-js-pure/internals/iterators.js');
      var wellKnownSymbol = __webpack_require__('./node_modules/core-js-pure/internals/well-known-symbol.js');
      var ITERATOR = wellKnownSymbol('iterator');
      module.exports = function(it) {
        if (it != undefined) {
          return it[ITERATOR] || it['@@iterator'] || Iterators[classof(it)];
        }
      };
    },
    './node_modules/core-js-pure/internals/global.js': function node_modulesCoreJsPureInternalsGlobalJs(module, exports, __webpack_require__) {
      (function(global) {
        var check = function check(it) {
          return it && it.Math == Math && it;
        };
        module.exports = check((typeof globalThis === 'undefined' ? 'undefined' : _typeof(globalThis)) == 'object' && globalThis) || check((typeof window === 'undefined' ? 'undefined' : _typeof(window)) == 'object' && window) || check((typeof self === 'undefined' ? 'undefined' : _typeof(self)) == 'object' && self) || check(_typeof(global) == 'object' && global) || Function('return this')();
      }).call(this, __webpack_require__('./node_modules/webpack/buildin/global.js'));
    },
    './node_modules/core-js-pure/internals/has.js': function node_modulesCoreJsPureInternalsHasJs(module, exports) {
      var hasOwnProperty = {}.hasOwnProperty;
      module.exports = function(it, key) {
        return hasOwnProperty.call(it, key);
      };
    },
    './node_modules/core-js-pure/internals/hidden-keys.js': function node_modulesCoreJsPureInternalsHiddenKeysJs(module, exports) {
      module.exports = {};
    },
    './node_modules/core-js-pure/internals/host-report-errors.js': function node_modulesCoreJsPureInternalsHostReportErrorsJs(module, exports, __webpack_require__) {
      var global = __webpack_require__('./node_modules/core-js-pure/internals/global.js');
      module.exports = function(a, b) {
        var console = global.console;
        if (console && console.error) {
          arguments.length === 1 ? console.error(a) : console.error(a, b);
        }
      };
    },
    './node_modules/core-js-pure/internals/html.js': function node_modulesCoreJsPureInternalsHtmlJs(module, exports, __webpack_require__) {
      var getBuiltIn = __webpack_require__('./node_modules/core-js-pure/internals/get-built-in.js');
      module.exports = getBuiltIn('document', 'documentElement');
    },
    './node_modules/core-js-pure/internals/ie8-dom-define.js': function node_modulesCoreJsPureInternalsIe8DomDefineJs(module, exports, __webpack_require__) {
      var DESCRIPTORS = __webpack_require__('./node_modules/core-js-pure/internals/descriptors.js');
      var fails = __webpack_require__('./node_modules/core-js-pure/internals/fails.js');
      var createElement = __webpack_require__('./node_modules/core-js-pure/internals/document-create-element.js');
      module.exports = !DESCRIPTORS && !fails(function() {
        return Object.defineProperty(createElement('div'), 'a', {
          get: function get() {
            return 7;
          }
        }).a != 7;
      });
    },
    './node_modules/core-js-pure/internals/indexed-object.js': function node_modulesCoreJsPureInternalsIndexedObjectJs(module, exports, __webpack_require__) {
      var fails = __webpack_require__('./node_modules/core-js-pure/internals/fails.js');
      var classof = __webpack_require__('./node_modules/core-js-pure/internals/classof-raw.js');
      var split = ''.split;
      module.exports = fails(function() {
        return !Object('z').propertyIsEnumerable(0);
      }) ? function(it) {
        return classof(it) == 'String' ? split.call(it, '') : Object(it);
      } : Object;
    },
    './node_modules/core-js-pure/internals/inspect-source.js': function node_modulesCoreJsPureInternalsInspectSourceJs(module, exports, __webpack_require__) {
      var store = __webpack_require__('./node_modules/core-js-pure/internals/shared-store.js');
      var functionToString = Function.toString;
      if (typeof store.inspectSource != 'function') {
        store.inspectSource = function(it) {
          return functionToString.call(it);
        };
      }
      module.exports = store.inspectSource;
    },
    './node_modules/core-js-pure/internals/internal-metadata.js': function node_modulesCoreJsPureInternalsInternalMetadataJs(module, exports, __webpack_require__) {
      var hiddenKeys = __webpack_require__('./node_modules/core-js-pure/internals/hidden-keys.js');
      var isObject = __webpack_require__('./node_modules/core-js-pure/internals/is-object.js');
      var has = __webpack_require__('./node_modules/core-js-pure/internals/has.js');
      var defineProperty = __webpack_require__('./node_modules/core-js-pure/internals/object-define-property.js').f;
      var uid = __webpack_require__('./node_modules/core-js-pure/internals/uid.js');
      var FREEZING = __webpack_require__('./node_modules/core-js-pure/internals/freezing.js');
      var METADATA = uid('meta');
      var id = 0;
      var isExtensible = Object.isExtensible || function() {
        return true;
      };
      var setMetadata = function setMetadata(it) {
        defineProperty(it, METADATA, {
          value: {
            objectID: 'O' + ++id,
            weakData: {}
          }
        });
      };
      var fastKey = function fastKey(it, create) {
        if (!isObject(it)) {
          return _typeof(it) == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
        }
        if (!has(it, METADATA)) {
          if (!isExtensible(it)) {
            return 'F';
          }
          if (!create) {
            return 'E';
          }
          setMetadata(it);
        }
        return it[METADATA].objectID;
      };
      var getWeakData = function getWeakData(it, create) {
        if (!has(it, METADATA)) {
          if (!isExtensible(it)) {
            return true;
          }
          if (!create) {
            return false;
          }
          setMetadata(it);
        }
        return it[METADATA].weakData;
      };
      var onFreeze = function onFreeze(it) {
        if (FREEZING && meta.REQUIRED && isExtensible(it) && !has(it, METADATA)) {
          setMetadata(it);
        }
        return it;
      };
      var meta = module.exports = {
        REQUIRED: false,
        fastKey: fastKey,
        getWeakData: getWeakData,
        onFreeze: onFreeze
      };
      hiddenKeys[METADATA] = true;
    },
    './node_modules/core-js-pure/internals/internal-state.js': function node_modulesCoreJsPureInternalsInternalStateJs(module, exports, __webpack_require__) {
      var NATIVE_WEAK_MAP = __webpack_require__('./node_modules/core-js-pure/internals/native-weak-map.js');
      var global = __webpack_require__('./node_modules/core-js-pure/internals/global.js');
      var isObject = __webpack_require__('./node_modules/core-js-pure/internals/is-object.js');
      var createNonEnumerableProperty = __webpack_require__('./node_modules/core-js-pure/internals/create-non-enumerable-property.js');
      var objectHas = __webpack_require__('./node_modules/core-js-pure/internals/has.js');
      var sharedKey = __webpack_require__('./node_modules/core-js-pure/internals/shared-key.js');
      var hiddenKeys = __webpack_require__('./node_modules/core-js-pure/internals/hidden-keys.js');
      var WeakMap = global.WeakMap;
      var set, get, has;
      var enforce = function enforce(it) {
        return has(it) ? get(it) : set(it, {});
      };
      var getterFor = function getterFor(TYPE) {
        return function(it) {
          var state;
          if (!isObject(it) || (state = get(it)).type !== TYPE) {
            throw TypeError('Incompatible receiver, ' + TYPE + ' required');
          }
          return state;
        };
      };
      if (NATIVE_WEAK_MAP) {
        var store = new WeakMap();
        var wmget = store.get;
        var wmhas = store.has;
        var wmset = store.set;
        set = function set(it, metadata) {
          wmset.call(store, it, metadata);
          return metadata;
        };
        get = function get(it) {
          return wmget.call(store, it) || {};
        };
        has = function has(it) {
          return wmhas.call(store, it);
        };
      } else {
        var STATE = sharedKey('state');
        hiddenKeys[STATE] = true;
        set = function set(it, metadata) {
          createNonEnumerableProperty(it, STATE, metadata);
          return metadata;
        };
        get = function get(it) {
          return objectHas(it, STATE) ? it[STATE] : {};
        };
        has = function has(it) {
          return objectHas(it, STATE);
        };
      }
      module.exports = {
        set: set,
        get: get,
        has: has,
        enforce: enforce,
        getterFor: getterFor
      };
    },
    './node_modules/core-js-pure/internals/is-array-iterator-method.js': function node_modulesCoreJsPureInternalsIsArrayIteratorMethodJs(module, exports, __webpack_require__) {
      var wellKnownSymbol = __webpack_require__('./node_modules/core-js-pure/internals/well-known-symbol.js');
      var Iterators = __webpack_require__('./node_modules/core-js-pure/internals/iterators.js');
      var ITERATOR = wellKnownSymbol('iterator');
      var ArrayPrototype = Array.prototype;
      module.exports = function(it) {
        return it !== undefined && (Iterators.Array === it || ArrayPrototype[ITERATOR] === it);
      };
    },
    './node_modules/core-js-pure/internals/is-array.js': function node_modulesCoreJsPureInternalsIsArrayJs(module, exports, __webpack_require__) {
      var classof = __webpack_require__('./node_modules/core-js-pure/internals/classof-raw.js');
      module.exports = Array.isArray || function isArray(arg) {
        return classof(arg) == 'Array';
      };
    },
    './node_modules/core-js-pure/internals/is-forced.js': function node_modulesCoreJsPureInternalsIsForcedJs(module, exports, __webpack_require__) {
      var fails = __webpack_require__('./node_modules/core-js-pure/internals/fails.js');
      var replacement = /#|\.prototype\./;
      var isForced = function isForced(feature, detection) {
        var value = data[normalize(feature)];
        return value == POLYFILL ? true : value == NATIVE ? false : typeof detection == 'function' ? fails(detection) : !!detection;
      };
      var normalize = isForced.normalize = function(string) {
        return String(string).replace(replacement, '.').toLowerCase();
      };
      var data = isForced.data = {};
      var NATIVE = isForced.NATIVE = 'N';
      var POLYFILL = isForced.POLYFILL = 'P';
      module.exports = isForced;
    },
    './node_modules/core-js-pure/internals/is-object.js': function node_modulesCoreJsPureInternalsIsObjectJs(module, exports) {
      module.exports = function(it) {
        return _typeof(it) === 'object' ? it !== null : typeof it === 'function';
      };
    },
    './node_modules/core-js-pure/internals/is-pure.js': function node_modulesCoreJsPureInternalsIsPureJs(module, exports) {
      module.exports = true;
    },
    './node_modules/core-js-pure/internals/iterate.js': function node_modulesCoreJsPureInternalsIterateJs(module, exports, __webpack_require__) {
      var anObject = __webpack_require__('./node_modules/core-js-pure/internals/an-object.js');
      var isArrayIteratorMethod = __webpack_require__('./node_modules/core-js-pure/internals/is-array-iterator-method.js');
      var toLength = __webpack_require__('./node_modules/core-js-pure/internals/to-length.js');
      var bind = __webpack_require__('./node_modules/core-js-pure/internals/function-bind-context.js');
      var getIteratorMethod = __webpack_require__('./node_modules/core-js-pure/internals/get-iterator-method.js');
      var callWithSafeIterationClosing = __webpack_require__('./node_modules/core-js-pure/internals/call-with-safe-iteration-closing.js');
      var Result = function Result(stopped, result) {
        this.stopped = stopped;
        this.result = result;
      };
      var iterate = module.exports = function(iterable, fn, that, AS_ENTRIES, IS_ITERATOR) {
        var boundFunction = bind(fn, that, AS_ENTRIES ? 2 : 1);
        var iterator, iterFn, index, length, result, next, step;
        if (IS_ITERATOR) {
          iterator = iterable;
        } else {
          iterFn = getIteratorMethod(iterable);
          if (typeof iterFn != 'function') {
            throw TypeError('Target is not iterable');
          }
          if (isArrayIteratorMethod(iterFn)) {
            for (index = 0, length = toLength(iterable.length); length > index; index++) {
              result = AS_ENTRIES ? boundFunction(anObject(step = iterable[index])[0], step[1]) : boundFunction(iterable[index]);
              if (result && result instanceof Result) {
                return result;
              }
            }
            return new Result(false);
          }
          iterator = iterFn.call(iterable);
        }
        next = iterator.next;
        while (!(step = next.call(iterator)).done) {
          result = callWithSafeIterationClosing(iterator, boundFunction, step.value, AS_ENTRIES);
          if (_typeof(result) == 'object' && result && result instanceof Result) {
            return result;
          }
        }
        return new Result(false);
      };
      iterate.stop = function(result) {
        return new Result(true, result);
      };
    },
    './node_modules/core-js-pure/internals/iterators-core.js': function node_modulesCoreJsPureInternalsIteratorsCoreJs(module, exports, __webpack_require__) {
      'use strict';
      var getPrototypeOf = __webpack_require__('./node_modules/core-js-pure/internals/object-get-prototype-of.js');
      var createNonEnumerableProperty = __webpack_require__('./node_modules/core-js-pure/internals/create-non-enumerable-property.js');
      var has = __webpack_require__('./node_modules/core-js-pure/internals/has.js');
      var wellKnownSymbol = __webpack_require__('./node_modules/core-js-pure/internals/well-known-symbol.js');
      var IS_PURE = __webpack_require__('./node_modules/core-js-pure/internals/is-pure.js');
      var ITERATOR = wellKnownSymbol('iterator');
      var BUGGY_SAFARI_ITERATORS = false;
      var returnThis = function returnThis() {
        return this;
      };
      var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;
      if ([].keys) {
        arrayIterator = [].keys();
        if (!('next' in arrayIterator)) {
          BUGGY_SAFARI_ITERATORS = true;
        } else {
          PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
          if (PrototypeOfArrayIteratorPrototype !== Object.prototype) {
            IteratorPrototype = PrototypeOfArrayIteratorPrototype;
          }
        }
      }
      if (IteratorPrototype == undefined) {
        IteratorPrototype = {};
      }
      if (!IS_PURE && !has(IteratorPrototype, ITERATOR)) {
        createNonEnumerableProperty(IteratorPrototype, ITERATOR, returnThis);
      }
      module.exports = {
        IteratorPrototype: IteratorPrototype,
        BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
      };
    },
    './node_modules/core-js-pure/internals/iterators.js': function node_modulesCoreJsPureInternalsIteratorsJs(module, exports) {
      module.exports = {};
    },
    './node_modules/core-js-pure/internals/microtask.js': function node_modulesCoreJsPureInternalsMicrotaskJs(module, exports, __webpack_require__) {
      var global = __webpack_require__('./node_modules/core-js-pure/internals/global.js');
      var getOwnPropertyDescriptor = __webpack_require__('./node_modules/core-js-pure/internals/object-get-own-property-descriptor.js').f;
      var classof = __webpack_require__('./node_modules/core-js-pure/internals/classof-raw.js');
      var macrotask = __webpack_require__('./node_modules/core-js-pure/internals/task.js').set;
      var IS_IOS = __webpack_require__('./node_modules/core-js-pure/internals/engine-is-ios.js');
      var MutationObserver = global.MutationObserver || global.WebKitMutationObserver;
      var process = global.process;
      var Promise = global.Promise;
      var IS_NODE = classof(process) == 'process';
      var queueMicrotaskDescriptor = getOwnPropertyDescriptor(global, 'queueMicrotask');
      var queueMicrotask = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;
      var flush, head, last, notify, toggle, node, promise, then;
      if (!queueMicrotask) {
        flush = function flush() {
          var parent, fn;
          if (IS_NODE && (parent = process.domain)) {
            parent.exit();
          }
          while (head) {
            fn = head.fn;
            head = head.next;
            try {
              fn();
            } catch (error) {
              if (head) {
                notify();
              } else {
                last = undefined;
              }
              throw error;
            }
          }
          last = undefined;
          if (parent) {
            parent.enter();
          }
        };
        if (IS_NODE) {
          notify = function notify() {
            process.nextTick(flush);
          };
        } else if (MutationObserver && !IS_IOS) {
          toggle = true;
          node = document.createTextNode('');
          new MutationObserver(flush).observe(node, {
            characterData: true
          });
          notify = function notify() {
            node.data = toggle = !toggle;
          };
        } else if (Promise && Promise.resolve) {
          promise = Promise.resolve(undefined);
          then = promise.then;
          notify = function notify() {
            then.call(promise, flush);
          };
        } else {
          notify = function notify() {
            macrotask.call(global, flush);
          };
        }
      }
      module.exports = queueMicr