/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetBackendSetIDResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String GET_BACKEND_SET_ID_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.34";
    @NotNull
    private static final String JSON_FIELD_BACKEND_SET_IDS = "backend-set-ids";
    @NotNull
    private static final String JSON_FIELD_REQUEST_PROCESSOR_ID = "request-processor-id";
    private static final long serialVersionUID = 117359364981309726L;
    @NotNull
    private final Set<String> backendSetIDs;
    @NotNull
    private final String entryBalancingRequestProcessorID;

    GetBackendSetIDResponseControl() {
        this.entryBalancingRequestProcessorID = null;
        this.backendSetIDs = null;
    }

    public GetBackendSetIDResponseControl(@NotNull String entryBalancingRequestProcessorID, @NotNull String backendSetID) {
        this(entryBalancingRequestProcessorID, Collections.singletonList(backendSetID));
    }

    public GetBackendSetIDResponseControl(@NotNull String entryBalancingRequestProcessorID, @NotNull Collection<String> backendSetIDs) {
        super(GET_BACKEND_SET_ID_RESPONSE_OID, false, GetBackendSetIDResponseControl.encodeValue(entryBalancingRequestProcessorID, backendSetIDs));
        this.entryBalancingRequestProcessorID = entryBalancingRequestProcessorID;
        this.backendSetIDs = Collections.unmodifiableSet(new LinkedHashSet<String>(backendSetIDs));
    }

    public GetBackendSetIDResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_BACKEND_SET_ID_RESPONSE_MISSING_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.entryBalancingRequestProcessorID = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            ASN1Element[] backendSetIDElements = ASN1Set.decodeAsSet(elements[1]).elements();
            LinkedHashSet<String> setIDs = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(backendSetIDElements.length));
            for (ASN1Element e : backendSetIDElements) {
                setIDs.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
            }
            this.backendSetIDs = Collections.unmodifiableSet(setIDs);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_BACKEND_SET_ID_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String entryBalancingRequestProcessorID, @NotNull Collection<String> backendSetIDs) {
        Validator.ensureNotNull(entryBalancingRequestProcessorID);
        Validator.ensureNotNull(backendSetIDs);
        Validator.ensureFalse(backendSetIDs.isEmpty());
        ArrayList<ASN1OctetString> backendSetIDElements = new ArrayList<ASN1OctetString>(backendSetIDs.size());
        for (String s : backendSetIDs) {
            backendSetIDElements.add(new ASN1OctetString(s));
        }
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1OctetString(entryBalancingRequestProcessorID), new ASN1Set(backendSetIDElements));
        return new ASN1OctetString(valueSequence.encode());
    }

    @Override
    @NotNull
    public GetBackendSetIDResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new GetBackendSetIDResponseControl(oid, isCritical, value);
    }

    @NotNull
    public String getEntryBalancingRequestProcessorID() {
        return this.entryBalancingRequestProcessorID;
    }

    @NotNull
    public Set<String> getBackendSetIDs() {
        return this.backendSetIDs;
    }

    @Nullable
    public static GetBackendSetIDResponseControl get(@NotNull LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(GET_BACKEND_SET_ID_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetBackendSetIDResponseControl) {
            return (GetBackendSetIDResponseControl)c;
        }
        return new GetBackendSetIDResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Nullable
    public static GetBackendSetIDResponseControl get(@NotNull SearchResultEntry entry) throws LDAPException {
        Control c = entry.getControl(GET_BACKEND_SET_ID_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetBackendSetIDResponseControl) {
            return (GetBackendSetIDResponseControl)c;
        }
        return new GetBackendSetIDResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    public static List<GetBackendSetIDResponseControl> get(@NotNull ExtendedResult result) throws LDAPException {
        Control[] controls = result.getResponseControls();
        if (controls.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<GetBackendSetIDResponseControl> decodedControls = new ArrayList<GetBackendSetIDResponseControl>(controls.length);
        for (Control c : controls) {
            if (c instanceof GetBackendSetIDResponseControl) {
                decodedControls.add((GetBackendSetIDResponseControl)c);
                continue;
            }
            if (!c.getOID().equals(GET_BACKEND_SET_ID_RESPONSE_OID)) continue;
            decodedControls.add(new GetBackendSetIDResponseControl(c.getOID(), c.isCritical(), c.getValue()));
        }
        return Collections.unmodifiableList(decodedControls);
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GET_BACKEND_SET_ID_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        ArrayList<JSONString> backendSetIDValues = new ArrayList<JSONString>();
        for (String backendSetID : this.backendSetIDs) {
            backendSetIDValues.add(new JSONString(backendSetID));
        }
        return new JSONObject(new JSONField("oid", GET_BACKEND_SET_ID_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_GET_BACKEND_SET_ID_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(new JSONField(JSON_FIELD_REQUEST_PROCESSOR_ID, this.entryBalancingRequestProcessorID), new JSONField(JSON_FIELD_BACKEND_SET_IDS, new JSONArray(backendSetIDValues)))));
    }

    @NotNull
    public static GetBackendSetIDResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new GetBackendSetIDResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String requestProcessorID = valueObject.getFieldAsString(JSON_FIELD_REQUEST_PROCESSOR_ID);
        if (requestProcessorID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_BACKEND_SET_ID_RESPONSE_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_REQUEST_PROCESSOR_ID));
        }
        List<JSONValue> backendSetIDValues = valueObject.getFieldAsArray(JSON_FIELD_BACKEND_SET_IDS);
        if (backendSetIDValues == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_BACKEND_SET_ID_RESPONSE_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_BACKEND_SET_IDS));
        }
        ArrayList<String> backendSetIDs = new ArrayList<String>(backendSetIDValues.size());
        for (JSONValue v : backendSetIDValues) {
            if (v instanceof JSONString) {
                backendSetIDs.add(((JSONString)v).stringValue());
                continue;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_BACKEND_SET_ID_RESPONSE_JSON_BACKEND_SET_ID_NOT_STRING.get(controlObject.getFields(), JSON_FIELD_BACKEND_SET_IDS));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_REQUEST_PROCESSOR_ID, JSON_FIELD_BACKEND_SET_IDS)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_BACKEND_SET_ID_RESPONSE_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new GetBackendSetIDResponseControl(requestProcessorID, backendSetIDs);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GetBackendSetIDResponseControl(entryBalancingRequestProcessorID='");
        buffer.append(this.entryBalancingRequestProcessorID);
        buffer.append("', backendSetIDs={");
        Iterator<String> iterator = this.backendSetIDs.iterator();
        while (iterator.hasNext()) {
            buffer.append('\'');
            buffer.append(iterator.next());
            buffer.append('\'');
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

