/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class EventDispatcher
implements ServiceListener {
    private static EventDispatcher m_dispatcher;
    private Map m_listeners;
    private BundleContext m_context;

    public EventDispatcher(BundleContext bc) {
        this.m_context = bc;
        this.m_listeners = new HashMap();
    }

    public static EventDispatcher getDispatcher() {
        return m_dispatcher;
    }

    public void start() {
        this.m_context.addServiceListener((ServiceListener)this);
        m_dispatcher = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            m_dispatcher = null;
            this.m_context.removeServiceListener((ServiceListener)this);
            this.m_listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        String[] itfs = (String[])event.getServiceReference().getProperty("objectClass");
        for (int s = 0; s < itfs.length; ++s) {
            ArrayList list;
            EventDispatcher eventDispatcher = this;
            synchronized (eventDispatcher) {
                List stored = (List)this.m_listeners.get(itfs[s]);
                if (stored == null) {
                    return;
                }
                list = new ArrayList(stored);
            }
            for (int i = 0; i < list.size(); ++i) {
                ((ServiceListener)list.get(i)).serviceChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(String itf, ServiceListener listener) {
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            ArrayList<ServiceListener> list = (ArrayList<ServiceListener>)this.m_listeners.get(itf);
            if (list == null) {
                list = new ArrayList<ServiceListener>(1);
                list.add(listener);
                this.m_listeners.put(itf, list);
            } else {
                list.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(ServiceListener listener) {
        boolean removed = false;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            Set keys = this.m_listeners.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String itf = (String)it.next();
                List list = (List)this.m_listeners.get(itf);
                removed = removed || list.remove(listener);
            }
        }
        return removed;
    }
}

