/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Indonesia
extends DelegateCalendar {
    private static final Indonesia BEJ_CALENDAR = new Indonesia(Market.BEJ);

    private Indonesia(Market market) {
        IndonesiaBEJCalendar delegate;
        switch (market) {
            case BEJ: 
            case JSX: {
                delegate = new IndonesiaBEJCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Indonesia getCalendar(Market market) {
        switch (market) {
            case BEJ: 
            case JSX: {
                return BEJ_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class IndonesiaBEJCalendar
    extends WesternCalendar {
        private IndonesiaBEJCalendar() {
        }

        @Override
        public String getName() {
            return "Jakarta stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            if (this.isWeekend(w) || d == 1 && m == Month.JANUARY || dd == em - 3 || dd == em + 38 || d == 17 && m == Month.AUGUST || d == 25 && m == Month.DECEMBER) {
                return false;
            }
            if (y == 2005 && (d == 21 && m == Month.JANUARY || d == 9 && m == Month.FEBRUARY || d == 10 && m == Month.FEBRUARY || d == 11 && m == Month.MARCH || d == 22 && m == Month.APRIL || d == 24 && m == Month.MAY || d == 2 && m == Month.SEPTEMBER || (d == 3 || d == 4) && m == Month.NOVEMBER || (d == 2 || d == 7 || d == 8) && m == Month.NOVEMBER || d == 26 && m == Month.DECEMBER)) {
                return false;
            }
            if (y == 2006 && (d == 10 && m == Month.JANUARY || d == 31 && m == Month.JANUARY || d == 30 && m == Month.MARCH || d == 10 && m == Month.APRIL || d == 21 && m == Month.AUGUST || (d == 24 || d == 25) && m == Month.OCTOBER || (d == 23 || d == 26 || d == 27) && m == Month.OCTOBER)) {
                return false;
            }
            if (y == 2007 && (d == 19 && m == Month.MARCH || d == 1 && m == Month.JUNE || d == 20 && m == Month.DECEMBER || d == 18 && m == Month.MAY || (d == 12 || d == 15 || d == 16) && m == Month.OCTOBER || (d == 21 || d == 24) && m == Month.OCTOBER)) {
                return false;
            }
            if (y == 2008 && (d == 10 && m == Month.JANUARY || d == 11 && m == Month.JANUARY || d == 7 && m == Month.FEBRUARY || d == 8 && m == Month.FEBRUARY || d == 7 && m == Month.MARCH || d == 20 && m == Month.MARCH || d == 20 && m == Month.MAY || d == 30 && m == Month.JULY || d == 18 && m == Month.AUGUST || d == 30 && m == Month.SEPTEMBER || d == 1 && m == Month.OCTOBER || d == 2 && m == Month.OCTOBER || d == 3 && m == Month.OCTOBER || d == 8 && m == Month.DECEMBER || d == 29 && m == Month.DECEMBER || d == 31 && m == Month.DECEMBER)) {
                return false;
            }
            return y != 2009 || !(d == 2 && m == Month.JANUARY || d == 26 && m == Month.JANUARY || d == 26 && m == Month.MARCH || d == 9 && m == Month.MARCH || d == 20 && m == Month.JULY || d == 18 && m == Month.SEPTEMBER || d == 23 && m == Month.SEPTEMBER || d == 21 && m == Month.SEPTEMBER || d == 22 && m == Month.SEPTEMBER || d == 27 && m == Month.NOVEMBER || d == 18 && m == Month.DECEMBER || d == 24 && m == Month.DECEMBER) && (d != 31 || m != Month.DECEMBER);
        }
    }

    public static enum Market {
        BEJ,
        JSX;

    }
}

