/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.equinox.ds.FrameworkHook;
import org.eclipse.equinox.ds.Log;
import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.model.ComponentDescriptionCache;
import org.eclipse.equinox.ds.parser.XMLParserNotAvailableException;
import org.eclipse.equinox.ds.resolver.Resolver;
import org.eclipse.equinox.ds.tracker.BundleTracker;
import org.eclipse.equinox.ds.tracker.BundleTrackerCustomizer;
import org.eclipse.equinox.ds.workqueue.WorkDispatcher;
import org.eclipse.equinox.ds.workqueue.WorkQueue;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator,
BundleTrackerCustomizer,
WorkDispatcher,
SynchronousBundleListener {
    public BundleContext context;
    private FrameworkHook framework;
    private ComponentDescriptionCache cache;
    private BundleTracker bundleTracker;
    public Resolver resolver;
    private ServiceTracker packageAdminTracker;
    public WorkQueue workQueue;
    private Hashtable bundleToComponentDescriptions;
    private Hashtable bundleToLastModified;
    public static final int ADD = 1;
    static /* synthetic */ Class class$0;

    public void start(BundleContext bundleContext) {
        this.context = bundleContext;
        this.framework = new FrameworkHook();
        Log.init(this.context);
        this.cache = new ComponentDescriptionCache(this);
        this.bundleToComponentDescriptions = new Hashtable();
        this.bundleToLastModified = new Hashtable();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.packageAdminTracker = new ServiceTracker(this.context, clazz.getName(), null);
        this.packageAdminTracker.open();
        this.bundleTracker = new BundleTracker(this.context, 32, this);
        this.workQueue = new WorkQueue("SCR Work Queue");
        this.workQueue.setDaemon(true);
        this.resolver = new Resolver(this);
        this.workQueue.start();
        bundleContext.addBundleListener((BundleListener)this);
        this.bundleTracker.open();
    }

    public void stop(BundleContext bundleContext) {
        this.bundleTracker.close();
        this.workQueue.closeAndJoin();
        this.resolver.dispose();
        this.packageAdminTracker.close();
        this.cache.dispose();
        Log.dispose();
        this.cache = null;
        this.framework = null;
        this.resolver = null;
        this.bundleToComponentDescriptions = null;
        this.bundleToLastModified = null;
        this.context = null;
    }

    public Object addingBundle(Bundle bundle) {
        ArrayList<ComponentDescription> enableComponentDescriptions = new ArrayList<ComponentDescription>();
        PackageAdmin packageAdmin = (PackageAdmin)this.packageAdminTracker.getService();
        if (packageAdmin.getBundleType(bundle) != 0) {
            return null;
        }
        Long bundleID = new Long(bundle.getBundleId());
        Long bundleLastModified = new Long(bundle.getLastModified());
        Long bundleOldLastModified = (Long)this.bundleToLastModified.get(bundleID);
        try {
            if (!bundleLastModified.equals(bundleOldLastModified) || bundleOldLastModified == null) {
                BundleContext bundleContext = this.framework.getBundleContext(bundle);
                List componentDescriptions = this.cache.getComponentDescriptions(bundleContext);
                this.bundleToComponentDescriptions.put(bundleID, componentDescriptions);
                this.bundleToLastModified.put(bundleID, bundleLastModified);
                Iterator it = componentDescriptions.iterator();
                while (it.hasNext()) {
                    ComponentDescription componentDescription = (ComponentDescription)it.next();
                    this.validate(componentDescription);
                    if (!componentDescription.isAutoenable() || !componentDescription.isValid()) continue;
                    componentDescription.setEnabled(true);
                    enableComponentDescriptions.add(componentDescription);
                }
            }
            if (!enableComponentDescriptions.isEmpty()) {
                this.workQueue.enqueueWork(this, 1, enableComponentDescriptions);
            }
        }
        catch (XMLParserNotAvailableException xMLParserNotAvailableException) {
            Log.log(3, "Declarative Services waiting for XML parser for bundle " + bundleID);
        }
        return bundleID;
    }

    public void modifiedBundle(Bundle bundle, Object object) {
        Long bundleID = new Long(bundle.getBundleId());
        this.bundleToComponentDescriptions.remove(bundleID);
        this.bundleToLastModified.remove(bundleID);
    }

    public void removedBundle(Bundle bundle, Object object) {
        ArrayList<ComponentDescription> disableComponentDescriptions = new ArrayList<ComponentDescription>();
        Long bundleID = new Long(bundle.getBundleId());
        List ComponentDescriptions = (List)this.bundleToComponentDescriptions.get(new Long(bundle.getBundleId()));
        if (ComponentDescriptions != null) {
            Iterator it = ComponentDescriptions.iterator();
            while (it.hasNext()) {
                ComponentDescription ComponentDescription2 = (ComponentDescription)it.next();
                if (!ComponentDescription2.isEnabled()) continue;
                disableComponentDescriptions.add(ComponentDescription2);
                ComponentDescription2.setEnabled(false);
            }
        }
        this.bundleToComponentDescriptions.remove(bundleID);
        this.bundleToLastModified.remove(bundleID);
        this.resolver.disableComponents(disableComponentDescriptions);
    }

    public void enableComponent(String name, Bundle bundle) {
        List componentDescriptions = (List)this.bundleToComponentDescriptions.get(new Long(bundle.getBundleId()));
        ArrayList<ComponentDescription> enableCDs = new ArrayList<ComponentDescription>();
        if (componentDescriptions != null) {
            Iterator it = componentDescriptions.iterator();
            while (it.hasNext()) {
                ComponentDescription componentDescription = (ComponentDescription)it.next();
                this.validate(componentDescription);
                if (name == null) {
                    if (!componentDescription.isValid() || componentDescription.isEnabled()) continue;
                    enableCDs.add(componentDescription);
                    componentDescription.setEnabled(true);
                    continue;
                }
                if (!componentDescription.getName().equals(name) || !componentDescription.isValid() || componentDescription.isEnabled()) continue;
                enableCDs.add(componentDescription);
                componentDescription.setEnabled(true);
            }
        }
        if (!enableCDs.isEmpty()) {
            this.workQueue.enqueueWork(this, 1, enableCDs);
        }
    }

    public void disableComponent(String name, Bundle bundle) {
        ArrayList<ComponentDescription> disableComponentDescriptions = new ArrayList<ComponentDescription>();
        List componentDescriptionsList = (List)this.bundleToComponentDescriptions.get(new Long(bundle.getBundleId()));
        if (componentDescriptionsList != null) {
            Iterator it = componentDescriptionsList.iterator();
            while (it.hasNext()) {
                ComponentDescription componentDescription = (ComponentDescription)it.next();
                if (!componentDescription.getName().equals(name) || !componentDescription.isEnabled()) continue;
                disableComponentDescriptions.add(componentDescription);
                componentDescription.setEnabled(false);
            }
        }
        this.resolver.disableComponents(disableComponentDescriptions);
    }

    public void dispatchWork(int workAction, Object workObject) {
        List descriptions = (List)workObject;
        switch (workAction) {
            case 1: {
                this.resolver.enableComponents(descriptions);
            }
        }
    }

    private void validate(ComponentDescription componentDescription) {
        if (componentDescription.getFactory() != null && componentDescription.getService() != null && componentDescription.getService().isServicefactory()) {
            componentDescription.setValid(false);
            Log.log(1, "validate cd: ", new Throwable("invalid to specify both ComponentFactory and ServiceFactory"));
        } else if (componentDescription.isImmediate() && componentDescription.getService() != null && componentDescription.getService().isServicefactory()) {
            componentDescription.setValid(false);
            Log.log(1, "validate cd: ", new Throwable("invalid to specify both immediate and ServiceFactory"));
        } else if (componentDescription.isImmediate() && componentDescription.getFactory() != null) {
            componentDescription.setValid(false);
            Log.log(1, "validate cd: ", new Throwable("invalid to specify both immediate and ComponentFactory"));
        } else if (!componentDescription.isImmediate() && componentDescription.getService() == null && componentDescription.getFactory() == null) {
            componentDescription.setValid(false);
            Log.log(1, "validate cd: ", new Throwable("invalid set immediate to false and provide no Service"));
        } else {
            componentDescription.setValid(true);
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 64) {
            List componentDescriptions = this.cache.getCachedComponentDescriptions(event.getBundle());
            Iterator itr = componentDescriptions.iterator();
            while (itr.hasNext()) {
                ComponentDescription componentDescription = (ComponentDescription)itr.next();
                componentDescription.clearReflectionMethods();
            }
        }
    }
}

