/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.repo.api;

import aQute.bnd.version.MavenVersion;
import aQute.maven.repo.api.Archive;
import aQute.maven.repo.api.Program;
import aQute.maven.repo.api.Revision;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class POM {
    static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    static XPathFactory xpf = XPathFactory.newInstance();
    private Revision revision;
    private String packaging;

    public POM(InputStream in) throws Exception {
        this(dbf.newDocumentBuilder().parse(in));
    }

    public POM(File file) throws Exception {
        this(dbf.newDocumentBuilder().parse(file));
    }

    public POM(Document doc) throws Exception {
        XPath xp = xpf.newXPath();
        String group = xp.evaluate("project/groupId", doc);
        String artifact = xp.evaluate("project/artifactId", doc);
        String version = xp.evaluate("project/version", doc);
        this.packaging = xp.evaluate("project/packaging", doc);
        if (this.packaging == null) {
            this.packaging = "jar";
        }
        Program p = Program.valueOf(group, artifact);
        this.revision = p.version(new MavenVersion(version));
    }

    public Revision getRevision() {
        return this.revision;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public Archive binaryArchive() {
        return this.revision.archive(this.packaging == null || this.packaging.isEmpty() ? "jar" : this.packaging, null);
    }
}

