/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.examples;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.calendars.JointCalendar;
import org.jquantlib.time.calendars.UnitedStates;
import org.jquantlib.util.Date;
import org.jquantlib.util.DateFactory;
import org.jquantlib.util.StopClock;

public class Calendars {
    public static void main(String[] args) {
        Date nextModified_PrecidingBusinessDay;
        Date nextPrecidingBusinessDay;
        Date nextModified_FollowingBusinessDay;
        Date nextFollowingBusinessDay;
        Date nextBusinessDay;
        System.out.println("\n\n::::: " + Calendars.class.getSimpleName() + " :::::");
        StopClock clock = new StopClock();
        clock.startClock();
        UnitedStates unitedStatesCalendar = UnitedStates.getCalendar(UnitedStates.Market.NYSE);
        System.out.println("The name of this calendar is = " + unitedStatesCalendar.getName());
        Date dateToday = DateFactory.getFactory().getTodaysDate();
        Date dateAdvanced = dateToday.getDateAfter(90);
        List<Date> holidayList = unitedStatesCalendar.getHolidayList(dateToday, dateAdvanced, true);
        System.out.println("The holidays between dateToday = " + dateToday + " till the date dateAdvanced = " + dateAdvanced + " are as shown below");
        StringBuffer bufferToHoldHolidays = new StringBuffer();
        for (Date date : holidayList) {
            bufferToHoldHolidays.append(date + "::");
        }
        System.out.println("The holidays separated by :: are = " + bufferToHoldHolidays);
        ArrayList<Date> businessDaysInBetweenUsingIsBusDay = new ArrayList<Date>();
        Date dateTodayTemp = DateFactory.getFactory().getTodaysDate();
        while (!dateTodayTemp.eq(dateAdvanced)) {
            if (unitedStatesCalendar.isBusinessDay(dateTodayTemp)) {
                businessDaysInBetweenUsingIsBusDay.add(dateTodayTemp);
            }
            dateTodayTemp.increment();
        }
        Long sizeOfBusinessDays = Long.parseLong(Integer.toString(businessDaysInBetweenUsingIsBusDay.size()));
        long sizeOfBusinessDaysUsingCalApi = unitedStatesCalendar.businessDaysBetween(dateToday, dateAdvanced, true, true);
        if (sizeOfBusinessDays == sizeOfBusinessDaysUsingCalApi) {
            System.out.println("The sizes are same");
        }
        ArrayList<Date> businessDaysInBetweenUsingIsHolDay = new ArrayList<Date>();
        dateTodayTemp = DateFactory.getFactory().getTodaysDate();
        while (!dateTodayTemp.eq(dateAdvanced)) {
            if (!unitedStatesCalendar.isHoliday(dateTodayTemp)) {
                businessDaysInBetweenUsingIsHolDay.add(dateTodayTemp);
            }
            dateTodayTemp.increment();
        }
        if (((Object)businessDaysInBetweenUsingIsBusDay).equals(businessDaysInBetweenUsingIsHolDay)) {
            System.out.println("The lists businessDaysInBetweenUsingIsBusDay and businessDaysInBetweenUsingIsHolDay are same");
        }
        Date firstHolidayDate = DateFactory.getFactory().getTodaysDate();
        while (!unitedStatesCalendar.isHoliday(firstHolidayDate)) {
            firstHolidayDate.increment();
        }
        if (unitedStatesCalendar.isHoliday(firstHolidayDate)) {
            System.out.println("FirstHolidayDate = " + firstHolidayDate + " is a holiday date");
        }
        if (unitedStatesCalendar.isBusinessDay(nextBusinessDay = unitedStatesCalendar.advance(firstHolidayDate))) {
            System.out.println("NextBusinessDayFromFirstHolidayFromToday = " + nextBusinessDay + " is a business date");
        }
        if (unitedStatesCalendar.isBusinessDay(nextFollowingBusinessDay = unitedStatesCalendar.adjust(dateToday, BusinessDayConvention.FOLLOWING))) {
            System.out.println("NextFollowingBusinessDate = " + nextFollowingBusinessDay + " from today is a business date");
        }
        if (unitedStatesCalendar.isBusinessDay(nextModified_FollowingBusinessDay = unitedStatesCalendar.adjust(dateToday, BusinessDayConvention.MODIFIED_FOLLOWING))) {
            System.out.println("NextModified_FollowingBusinessDate = " + nextModified_FollowingBusinessDay + " from today is a business date");
        }
        if (unitedStatesCalendar.isBusinessDay(nextPrecidingBusinessDay = unitedStatesCalendar.adjust(dateToday, BusinessDayConvention.PRECEDING))) {
            System.out.println("NextPrecidingBusinessDay = " + nextPrecidingBusinessDay + " from today is a business date");
        }
        if (unitedStatesCalendar.isBusinessDay(nextModified_PrecidingBusinessDay = unitedStatesCalendar.adjust(dateToday, BusinessDayConvention.MODIFIED_PRECEDING))) {
            System.out.println("NextModified_PrecidingBusinessDay = " + nextModified_PrecidingBusinessDay + " from today is a business date");
        }
        Date nextUnadjustedBusinessDay = unitedStatesCalendar.adjust(dateToday, BusinessDayConvention.UNADJUSTED);
        if (unitedStatesCalendar.isBusinessDay(nextModified_PrecidingBusinessDay)) {
            System.out.println("NextUnadjustedBusinessDay = " + nextUnadjustedBusinessDay + " from today is a business date and is same as today");
        }
        Date advancedDate = unitedStatesCalendar.advance(dateToday, 10, TimeUnit.DAYS);
        System.out.println("Next business date when today's date is advanced by 10 days = " + advancedDate);
        advancedDate = unitedStatesCalendar.advance(dateToday, 10, TimeUnit.WEEKS);
        System.out.println("Next business date when today's date is advanced by 10 weeks = " + advancedDate);
        advancedDate = unitedStatesCalendar.advance(dateToday, 10, TimeUnit.MONTHS);
        System.out.println("Next business date when today's date is advanced by 10 months = " + advancedDate);
        advancedDate = unitedStatesCalendar.advance(dateToday, 10, TimeUnit.YEARS);
        System.out.println("Next business date when today's date is advanced by 10 years = " + advancedDate);
        advancedDate = unitedStatesCalendar.advance(dateToday, new Period(1, TimeUnit.DAYS), BusinessDayConvention.FOLLOWING);
        System.out.println("Next business date when today's date is advanced 1 day = " + advancedDate);
        advancedDate = unitedStatesCalendar.advance(dateToday, new Period(1, TimeUnit.WEEKS), BusinessDayConvention.MODIFIED_FOLLOWING);
        System.out.println("Next business date when today's date is advanced 1 week = " + advancedDate);
        advancedDate = unitedStatesCalendar.advance(dateToday, new Period(1, TimeUnit.MONTHS), BusinessDayConvention.MODIFIED_PRECEDING);
        System.out.println("Next business date when today's date is advanced 1 month = " + advancedDate);
        advancedDate = unitedStatesCalendar.advance(dateToday, new Period(1, TimeUnit.YEARS), BusinessDayConvention.PRECEDING);
        System.out.println("Next business date when today's date is advanced 1 year = " + advancedDate);
        UnitedStates unitedStatesCalendarGvtBondCalendar = UnitedStates.getCalendar(UnitedStates.Market.GOVERNMENTBOND);
        JointCalendar jointCalendar = new JointCalendar(JointCalendar.JointCalendarRule.JOIN_BUSINESSDAYS, unitedStatesCalendar, unitedStatesCalendarGvtBondCalendar);
        List<Date> listOfHoliDays = jointCalendar.getHolidayList(dateToday, dateAdvanced, true);
        ArrayList<Date> holidayListObtainedUsingCalAPI = new ArrayList<Date>();
        Date start = DateFactory.getFactory().getTodaysDate();
        while (!start.eq(dateAdvanced)) {
            if (jointCalendar.isHoliday(start)) {
                holidayListObtainedUsingCalAPI.add(DateFactory.getFactory().getDate(start.getDayOfMonth(), start.getMonthEnum(), start.getYear()));
            }
            start.increment();
        }
        if (((Object)listOfHoliDays).equals(holidayListObtainedUsingCalAPI)) {
            System.out.println("Lists listOfHoliDays and holidayListObtainedUsingCalAPI of joint calendar are same");
        }
        clock.stopClock();
        clock.log();
    }
}

