/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.math.Array;
import org.jquantlib.math.Matrix;

public class BasisIncompleteOrdered {
    private final int euclideanDimension;
    private final List<double[]> currentBasis;

    public BasisIncompleteOrdered(int euclideanDimension) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("not implemented");
        }
        this.euclideanDimension = euclideanDimension;
        this.currentBasis = new ArrayList<double[]>();
    }

    public boolean addVector(Array newVector1) {
        if (newVector1.size() != this.euclideanDimension) {
            throw new RuntimeException("BasisIncompleteOrdered : missized vector passed");
        }
        if (this.currentBasis.size() == this.euclideanDimension) {
            return false;
        }
        for (int j = 0; j < this.currentBasis.size(); ++j) {
            double innerProd = Array.dotProduct(newVector1.getData(), this.currentBasis.get(j));
            double[] data = newVector1.getData();
            double[] currentBasisAtJ = this.currentBasis.get(j);
            for (int k = 0; k < this.euclideanDimension; ++k) {
                int n = k;
                data[n] = data[n] - innerProd * currentBasisAtJ[k];
            }
        }
        double norm = Math.sqrt(Array.dotProduct(newVector1.getData(), newVector1.getData()));
        if (norm < 1.0E-12) {
            return false;
        }
        double[] data = newVector1.getData();
        int l = 0;
        while (l < this.euclideanDimension) {
            int n = l++;
            data[n] = data[n] / norm;
        }
        this.currentBasis.add(newVector1.getData());
        return true;
    }

    public int basisSize() {
        return this.currentBasis.size();
    }

    public int euclideanDimension() {
        return this.euclideanDimension;
    }

    public Matrix getBasisAsRowsInMatrix() {
        Matrix basis = new Matrix(this.currentBasis.size(), this.euclideanDimension);
        for (int i = 0; i < basis.rows(); ++i) {
            double[] currentBasisRow = this.currentBasis.get(i);
            for (int j = 0; j < basis.columns(); ++j) {
                basis.set(i, j, currentBasisRow[j]);
            }
        }
        return basis;
    }
}

