/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.solvers1D;

import org.jquantlib.math.AbstractSolver1D;
import org.jquantlib.math.UnaryFunctionDouble;

public class Ridder
extends AbstractSolver1D<UnaryFunctionDouble> {
    @Override
    protected double solveImpl(UnaryFunctionDouble f, double xAccuracy) {
        double xAccuracy_ = xAccuracy / 100.0;
        this.root_ = Double.MIN_VALUE;
        while (this.evaluationNumber_ <= this.getMaxEvaluations()) {
            double xMid = 0.5 * (this.xMin_ + this.xMax_);
            double fxMid = f.evaluate(xMid);
            ++this.evaluationNumber_;
            double s = Math.sqrt(fxMid * fxMid - this.fxMin_ * this.fxMax_);
            if (s == 0.0) {
                return this.root_;
            }
            double nextRoot = xMid + (xMid - this.xMin_) * ((this.fxMin_ >= this.fxMax_ ? 1.0 : -1.0) * fxMid / s);
            if (Math.abs(nextRoot - this.root_) <= xAccuracy_) {
                return this.root_;
            }
            this.root_ = nextRoot;
            double froot = f.evaluate(this.root_);
            ++this.evaluationNumber_;
            if (froot == 0.0) {
                return this.root_;
            }
            if (this.sign(fxMid, froot) != fxMid) {
                this.xMin_ = xMid;
                this.fxMin_ = fxMid;
                this.xMax_ = this.root_;
                this.fxMax_ = froot;
            } else if (this.sign(this.fxMin_, froot) != this.fxMin_) {
                this.xMax_ = this.root_;
                this.fxMax_ = froot;
            } else if (this.sign(this.fxMax_, froot) != this.fxMax_) {
                this.xMin_ = this.root_;
                this.fxMin_ = froot;
            } else {
                throw new ArithmeticException("never get here.");
            }
            if (!(Math.abs(this.xMax_ - this.xMin_) <= xAccuracy_)) continue;
            return this.root_;
        }
        throw new ArithmeticException("maximum number of function evaluations (" + this.getMaxEvaluations() + ") exceeded");
    }

    private double sign(double a, double b) {
        return b >= 0.0 ? Math.abs(a) : -Math.abs(a);
    }
}

