/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Deserializer;
import netscape.util.Encoder;
import netscape.util.Hashtable;
import netscape.util.InconsistencyException;

public class HTMLParsingRules
implements Codable {
    private Hashtable rules = (Hashtable)Deserializer.deserializeObject("{  LI = { BeginTermination = ( LI ); EndTermination = (OL,UL,DIR,MENU); };     IMG= { IsContainer=false; };                                       DD = { BeginTermination = (DT,DD); EndTermination = (DL,A); };       DT = { BeginTermination = (DT,DD); EndTermination = (DL,A); };        P = { IsContainer=true; BeginTermination=(P,OL,UL,DIR,MENU,PRE,H1,H2,H3,H4,H5,H6);  };   BR = { IsContainer=false; };                                       HR = { IsContainer=false; };                                       PRE= { ShouldRetainFormatting=true; };                                  A= { IsContainer=true; BeginTermination = (A); };              }");
    private String defaultContainerClassName;
    private String defaultMarkerClassName;
    static final String RULES_KEY = "rules";
    static final String DEFAULT_CONTAINER_CLASS_NAME_KEY = "defaultContainerClass";
    static final String DEFAULT_MARKER_CLASS_NAME_KEY = "defaultMarkerClass";
    private static final String HTMLDefaultRules = "{  LI = { BeginTermination = ( LI ); EndTermination = (OL,UL,DIR,MENU); };     IMG= { IsContainer=false; };                                       DD = { BeginTermination = (DT,DD); EndTermination = (DL,A); };       DT = { BeginTermination = (DT,DD); EndTermination = (DL,A); };        P = { IsContainer=true; BeginTermination=(P,OL,UL,DIR,MENU,PRE,H1,H2,H3,H4,H5,H6);  };   BR = { IsContainer=false; };                                       HR = { IsContainer=false; };                                       PRE= { ShouldRetainFormatting=true; };                                  A= { IsContainer=true; BeginTermination = (A); };              }";
    public static final String STRING_MARKER_KEY = "IFCSTRING";
    public static final String COMMENT_MARKER_KEY = "IFCCOMMENT";
    public static final String REPRESENTATION_KEY = "Representation";
    public static final String BEGIN_TERMINATION_MARKERS_KEY = "BeginTermination";
    public static final String END_TERMINATION_MARKERS_KEY = "EndTermination";
    public static final String IS_CONTAINER_KEY = "IsContainer";
    public static final String SHOULD_RETAIN_FORMATTING_KEY = "ShouldRetainFormatting";
    public static final String SHOULD_IGNORE_END_KEY = "ShouldIgnoreEnd";

    public HTMLParsingRules() {
        if (this.rules == null) {
            throw new InconsistencyException("HTMLParsingRules: Cannot deserialize default rules");
        }
    }

    public void setRulesForMarker(Hashtable hashtable, String string) {
        this.rules.put(string, hashtable);
    }

    public Hashtable rulesForMarker(String string) {
        return (Hashtable)this.rules.get(string);
    }

    public void setRuleForMarker(String string, Object object, String string2) {
        Hashtable hashtable = this.rulesForMarker(string2);
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        hashtable.put(string, object);
        this.setRulesForMarker(hashtable, string2);
    }

    public void setClassNameForMarker(String string, String string2) {
        Hashtable hashtable = this.rulesForMarker(string2);
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        hashtable.put(REPRESENTATION_KEY, string);
        this.setRulesForMarker(hashtable, string2);
    }

    public String classNameForMarker(String string) {
        Hashtable hashtable = this.rulesForMarker(string);
        if (hashtable != null) {
            String string2 = (String)hashtable.get(REPRESENTATION_KEY);
            if (string2 == null) {
                string2 = this.isContainer(hashtable) ? this.defaultContainerClassName : this.defaultMarkerClassName;
            }
            return string2;
        }
        Hashtable hashtable2 = this.rulesForMarker(string);
        boolean bl = hashtable2 != null ? this.isContainer(hashtable2) : true;
        if (bl && this.defaultContainerClassName != null) {
            return this.defaultContainerClassName;
        }
        if (!bl && this.defaultMarkerClassName != null) {
            return this.defaultMarkerClassName;
        }
        return null;
    }

    public void setDefaultContainerClassName(String string) {
        this.defaultContainerClassName = string;
    }

    public String defaultContainerClassName() {
        return this.defaultContainerClassName;
    }

    public void setDefaultMarkerClassName(String string) {
        this.defaultMarkerClassName = string;
    }

    public String defaultMarkerClassName() {
        return this.defaultMarkerClassName;
    }

    public void setStringClassName(String string) {
        this.setClassNameForMarker(string, STRING_MARKER_KEY);
    }

    public String classNameForString() {
        return this.classNameForMarker(STRING_MARKER_KEY);
    }

    public void setClassNameForComment(String string) {
        this.setClassNameForMarker(string, COMMENT_MARKER_KEY);
    }

    public String classNameForComment() {
        return this.classNameForMarker(COMMENT_MARKER_KEY);
    }

    boolean shouldIgnoreEnd(Hashtable hashtable) {
        if (hashtable == null) {
            return false;
        }
        return hashtable.get(SHOULD_IGNORE_END_KEY) != null && ((String)hashtable.get(SHOULD_IGNORE_END_KEY)).toUpperCase().equals("TRUE");
    }

    boolean isContainer(Hashtable hashtable) {
        if (hashtable == null) {
            return true;
        }
        return hashtable.get(IS_CONTAINER_KEY) == null || !((String)hashtable.get(IS_CONTAINER_KEY)).toUpperCase().equals("FALSE");
    }

    boolean shouldFilterStringsForChildren(Hashtable hashtable) {
        if (hashtable == null) {
            return true;
        }
        return hashtable.get(SHOULD_RETAIN_FORMATTING_KEY) == null || !((String)hashtable.get(SHOULD_RETAIN_FORMATTING_KEY)).toUpperCase().equals("TRUE");
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.HTMLParsingRules", 1);
        classInfo.addField(RULES_KEY, (byte)18);
        classInfo.addField(DEFAULT_CONTAINER_CLASS_NAME_KEY, (byte)18);
        classInfo.addField(DEFAULT_MARKER_CLASS_NAME_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(RULES_KEY, this.rules);
        encoder.encodeObject(DEFAULT_CONTAINER_CLASS_NAME_KEY, this.defaultContainerClassName);
        encoder.encodeObject(DEFAULT_MARKER_CLASS_NAME_KEY, this.defaultMarkerClassName);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.rules = (Hashtable)decoder.decodeObject(RULES_KEY);
        this.defaultContainerClassName = (String)decoder.decodeObject(DEFAULT_CONTAINER_CLASS_NAME_KEY);
        this.defaultMarkerClassName = (String)decoder.decodeObject(DEFAULT_MARKER_CLASS_NAME_KEY);
    }

    public void finishDecoding() throws CodingException {
    }
}

