/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tenant;

import com.alibaba.tenant.FieldReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;

public class TenantData {
    private Map<Object, Map<String, FieldReference<?>>> dataMap = new WeakHashMap();

    private Map<String, FieldReference<?>> mapForObject(Object object) {
        Map<String, FieldReference<?>> map = null;
        if (object != null && null == (map = this.dataMap.get(object))) {
            map = new HashMap();
            this.dataMap.put(object, map);
        }
        return map;
    }

    public synchronized <K, T> T getFieldValue(K k, String string, Supplier<T> supplier) {
        T t;
        if (null == k || null == string || null == supplier) {
            throw new IllegalArgumentException("Failed to get the field value, argument is null.");
        }
        Map<String, FieldReference<?>> map = this.mapForObject(k);
        FieldReference<Object> fieldReference = map.get(string);
        if (null == fieldReference && (t = supplier.get()) != null) {
            fieldReference = new FieldReference<T>(t);
            map.put(string, fieldReference);
        }
        return fieldReference == null ? null : (T)fieldReference.get();
    }

    public synchronized <K, T> T getFieldValue(K k, String string) {
        return (T)this.getFieldValue(k, string, () -> null);
    }

    public synchronized <K, T> void setFieldValue(K k, String string, T t) {
        if (null == k || null == string) {
            throw new IllegalArgumentException("Failed to get the field value, argument is null.");
        }
        Map<String, FieldReference<?>> map = this.mapForObject(k);
        FieldReference<?> fieldReference = map.get(string);
        if (null != fieldReference) {
            fieldReference.set(t);
        } else {
            map.put(string, new FieldReference<T>(t));
        }
    }

    void clear() {
        this.dataMap.clear();
    }
}

