/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.rdma;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.channels.UnsupportedAddressTypeException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.SharedSecrets;
import sun.net.ext.RdmaSocketOptions;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Net;
import sun.nio.ch.NetAccess;
import sun.nio.ch.rdma.RdmaOptionKey;
import sun.nio.ch.rdma.RdmaSocketOptionRegistry;

public class RdmaNet {
    private static final NetAccess NET_ACCESS = SharedSecrets.getNetAccess();
    static final ProtocolFamily UNSPEC = new ProtocolFamily(){

        @Override
        public String name() {
            return "UNSPEC";
        }
    };
    private static volatile boolean checkedRdma;
    private static volatile boolean isRdmaAvailable;
    static final RdmaSocketOptions rdmaOptions;

    private RdmaNet() {
    }

    static boolean isReusePortAvailable() {
        return false;
    }

    public static boolean isRdmaAvailable() {
        if (!checkedRdma) {
            isRdmaAvailable = RdmaNet.isRdmaAvailable0();
            checkedRdma = true;
        }
        return isRdmaAvailable;
    }

    private static native boolean isRdmaAvailable0();

    static InetSocketAddress checkAddress(SocketAddress socketAddress, ProtocolFamily protocolFamily) {
        InetAddress inetAddress;
        InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
        if (protocolFamily == StandardProtocolFamily.INET && !((inetAddress = inetSocketAddress.getAddress()) instanceof Inet4Address)) {
            throw new UnsupportedAddressTypeException();
        }
        if (protocolFamily == StandardProtocolFamily.INET6 && !((inetAddress = inetSocketAddress.getAddress()) instanceof Inet6Address)) {
            throw new UnsupportedAddressTypeException();
        }
        return inetSocketAddress;
    }

    static void setSocketOption(FileDescriptor fileDescriptor, ProtocolFamily protocolFamily, SocketOption<?> socketOption, Object object) throws IOException {
        boolean bl;
        int n;
        int n2;
        if (object == null) {
            throw new IllegalArgumentException("Invalid option value");
        }
        Class<?> clazz = socketOption.type();
        if (rdmaOptions.isOptionSupported(socketOption)) {
            rdmaOptions.setOption(fileDescriptor, socketOption, object);
            return;
        }
        if (clazz != Integer.class && clazz != Boolean.class) {
            throw new AssertionError((Object)"Should not reach here");
        }
        if ((socketOption == StandardSocketOptions.SO_RCVBUF || socketOption == StandardSocketOptions.SO_SNDBUF) && (n2 = ((Integer)object).intValue()) < 0) {
            throw new IllegalArgumentException("Invalid send/receive buffer size");
        }
        RdmaOptionKey rdmaOptionKey = RdmaSocketOptionRegistry.findOption(socketOption, protocolFamily);
        if (rdmaOptionKey == null) {
            throw new AssertionError((Object)"Option not found");
        }
        int n3 = 0x3FFFFFFF;
        if (clazz == Integer.class) {
            n = (Integer)object;
            if (n > n3) {
                n = n3;
            }
        } else {
            bl = (Boolean)object;
            n = bl ? 1 : 0;
        }
        bl = protocolFamily == UNSPEC;
        RdmaNet.setIntOption0(fileDescriptor, bl, rdmaOptionKey.level(), rdmaOptionKey.name(), n);
    }

    static Object getSocketOption(FileDescriptor fileDescriptor, ProtocolFamily protocolFamily, SocketOption<?> socketOption) throws IOException {
        Class<?> clazz = socketOption.type();
        if (rdmaOptions.isOptionSupported(socketOption)) {
            return rdmaOptions.getOption(fileDescriptor, socketOption);
        }
        if (clazz != Integer.class && clazz != Boolean.class) {
            throw new AssertionError((Object)"Should not reach here");
        }
        RdmaOptionKey rdmaOptionKey = RdmaSocketOptionRegistry.findOption(socketOption, protocolFamily);
        if (rdmaOptionKey == null) {
            throw new AssertionError((Object)"Option not found");
        }
        boolean bl = protocolFamily == UNSPEC;
        int n = RdmaNet.getIntOption0(fileDescriptor, bl, rdmaOptionKey.level(), rdmaOptionKey.name());
        if (clazz == Integer.class) {
            return n;
        }
        return n == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    static FileDescriptor socket(ProtocolFamily protocolFamily, boolean bl) throws IOException {
        boolean bl2 = NET_ACCESS.isIPv6Available() && protocolFamily != StandardProtocolFamily.INET;
        return IOUtil.newFD(RdmaNet.socket0(bl2, bl, false));
    }

    static FileDescriptor serverSocket(ProtocolFamily protocolFamily, boolean bl) throws IOException {
        boolean bl2 = NET_ACCESS.isIPv6Available() && protocolFamily != StandardProtocolFamily.INET;
        return IOUtil.newFD(RdmaNet.socket0(bl2, bl, true));
    }

    private static native int socket0(boolean var0, boolean var1, boolean var2);

    static void bind(ProtocolFamily protocolFamily, FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        boolean bl = NET_ACCESS.isIPv6Available() && protocolFamily != StandardProtocolFamily.INET;
        RdmaNet.bind0(fileDescriptor, bl, inetAddress, n);
    }

    private static native void bind0(FileDescriptor var0, boolean var1, InetAddress var2, int var3) throws IOException;

    static native void listen(FileDescriptor var0, int var1) throws IOException;

    static int connect(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        return RdmaNet.connect(UNSPEC, fileDescriptor, inetAddress, n);
    }

    static int connect(ProtocolFamily protocolFamily, FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        boolean bl = NET_ACCESS.isIPv6Available() && protocolFamily != StandardProtocolFamily.INET;
        return RdmaNet.connect0(bl, fileDescriptor, inetAddress, n);
    }

    public static InetSocketAddress localAddress(FileDescriptor fileDescriptor) throws IOException {
        return new InetSocketAddress(RdmaNet.localInetAddress(fileDescriptor), RdmaNet.localPort(fileDescriptor));
    }

    private static native int connect0(boolean var0, FileDescriptor var1, InetAddress var2, int var3) throws IOException;

    static native void shutdown(FileDescriptor var0, int var1) throws IOException;

    private static native int localPort(FileDescriptor var0) throws IOException;

    private static native InetAddress localInetAddress(FileDescriptor var0) throws IOException;

    private static native int getIntOption0(FileDescriptor var0, boolean var1, int var2, int var3) throws IOException;

    private static native void setIntOption0(FileDescriptor var0, boolean var1, int var2, int var3, int var4) throws IOException;

    static native int poll(FileDescriptor var0, int var1, long var2) throws IOException;

    public static native void configureBlocking(FileDescriptor var0, boolean var1);

    private static native void initIDs();

    static {
        rdmaOptions = RdmaSocketOptions.getInstance();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                System.loadLibrary("extnet");
                return null;
            }
        });
        IOUtil.load();
        RdmaNet.initIDs();
    }
}

