/* Copyright (c) 2004, 2022, Oracle and/or its affiliates.
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; version 2
   of the License.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */

/* 
   UCA (Unicode Collation Algorithm) support. 
   Written by Alexander Barkov <bar@mysql.com>
   
   Currently supports only subset of the full UCA:
   - Only Primary level key comparison
   - Basic Latin letters contraction is implemented
   - Variable weighting is done for Non-ignorable option
   
   Features that are not implemented yet:
   - No Normalization From D is done
     + No decomposition is done
     + No Thai/Lao orderding is done
   - No combining marks processing is done
*/


#include <my_global.h>
#include "m_string.h"
#include "m_ctype.h"

#ifdef HAVE_UCA_COLLATIONS

#define MY_UCA_NPAGES 256
#define MY_UCA_NCHARS 256
#define MY_UCA_CMASK  255
#define MY_UCA_PSHIFT 8

uint16 page000data[]= { /* 0000 (4 weights per char) */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0201,0x0000,0x0000,0x0000,
0x0202,0x0000,0x0000,0x0000, 0x0203,0x0000,0x0000,0x0000,
0x0204,0x0000,0x0000,0x0000, 0x0205,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000, 0x0251,0x0000,0x0000,0x0000,
0x027E,0x0000,0x0000,0x0000, 0x02D2,0x0000,0x0000,0x0000,
0x0E0F,0x0000,0x0000,0x0000, 0x02D3,0x0000,0x0000,0x0000,
0x02CF,0x0000,0x0000,0x0000, 0x0277,0x0000,0x0000,0x0000,
0x0288,0x0000,0x0000,0x0000, 0x0289,0x0000,0x0000,0x0000,
0x02C8,0x0000,0x0000,0x0000, 0x0428,0x0000,0x0000,0x0000,
0x022F,0x0000,0x0000,0x0000, 0x0221,0x0000,0x0000,0x0000,
0x025D,0x0000,0x0000,0x0000, 0x02CC,0x0000,0x0000,0x0000,
0x0E29,0x0000,0x0000,0x0000, 0x0E2A,0x0000,0x0000,0x0000,
0x0E2B,0x0000,0x0000,0x0000, 0x0E2C,0x0000,0x0000,0x0000,
0x0E2D,0x0000,0x0000,0x0000, 0x0E2E,0x0000,0x0000,0x0000,
0x0E2F,0x0000,0x0000,0x0000, 0x0E30,0x0000,0x0000,0x0000,
0x0E31,0x0000,0x0000,0x0000, 0x0E32,0x0000,0x0000,0x0000,
0x023D,0x0000,0x0000,0x0000, 0x023A,0x0000,0x0000,0x0000,
0x042C,0x0000,0x0000,0x0000, 0x042D,0x0000,0x0000,0x0000,
0x042E,0x0000,0x0000,0x0000, 0x0255,0x0000,0x0000,0x0000,
0x02C7,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E4A,0x0000,0x0000,0x0000, 0x0E60,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000, 0x0E8B,0x0000,0x0000,0x0000,
0x0EB9,0x0000,0x0000,0x0000, 0x0EC1,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000, 0x0EFB,0x0000,0x0000,0x0000,
0x0F10,0x0000,0x0000,0x0000, 0x0F21,0x0000,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000, 0x0F5B,0x0000,0x0000,0x0000,
0x0F64,0x0000,0x0000,0x0000, 0x0F82,0x0000,0x0000,0x0000,
0x0FA7,0x0000,0x0000,0x0000, 0x0FB4,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000, 0x0FEA,0x0000,0x0000,0x0000,
0x1002,0x0000,0x0000,0x0000, 0x101F,0x0000,0x0000,0x0000,
0x1044,0x0000,0x0000,0x0000, 0x1051,0x0000,0x0000,0x0000,
0x105A,0x0000,0x0000,0x0000, 0x105E,0x0000,0x0000,0x0000,
0x106A,0x0000,0x0000,0x0000, 0x028A,0x0000,0x0000,0x0000,
0x02CE,0x0000,0x0000,0x0000, 0x028B,0x0000,0x0000,0x0000,
0x020F,0x0000,0x0000,0x0000, 0x021B,0x0000,0x0000,0x0000,
0x020C,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E4A,0x0000,0x0000,0x0000, 0x0E60,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000, 0x0E8B,0x0000,0x0000,0x0000,
0x0EB9,0x0000,0x0000,0x0000, 0x0EC1,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000, 0x0EFB,0x0000,0x0000,0x0000,
0x0F10,0x0000,0x0000,0x0000, 0x0F21,0x0000,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000, 0x0F5B,0x0000,0x0000,0x0000,
0x0F64,0x0000,0x0000,0x0000, 0x0F82,0x0000,0x0000,0x0000,
0x0FA7,0x0000,0x0000,0x0000, 0x0FB4,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000, 0x0FEA,0x0000,0x0000,0x0000,
0x1002,0x0000,0x0000,0x0000, 0x101F,0x0000,0x0000,0x0000,
0x1044,0x0000,0x0000,0x0000, 0x1051,0x0000,0x0000,0x0000,
0x105A,0x0000,0x0000,0x0000, 0x105E,0x0000,0x0000,0x0000,
0x106A,0x0000,0x0000,0x0000, 0x028C,0x0000,0x0000,0x0000,
0x0430,0x0000,0x0000,0x0000, 0x028D,0x0000,0x0000,0x0000,
0x0433,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0206,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000, 0x0252,0x0000,0x0000,0x0000,
0x0E0E,0x0000,0x0000,0x0000, 0x0E10,0x0000,0x0000,0x0000,
0x0E0D,0x0000,0x0000,0x0000, 0x0E11,0x0000,0x0000,0x0000,
0x0431,0x0000,0x0000,0x0000, 0x02C2,0x0000,0x0000,0x0000,
0x0214,0x0000,0x0000,0x0000, 0x02C5,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000, 0x0286,0x0000,0x0000,0x0000,
0x042F,0x0000,0x0000,0x0000, 0x0220,0x0000,0x0000,0x0000,
0x02C6,0x0000,0x0000,0x0000, 0x0210,0x0000,0x0000,0x0000,
0x034A,0x0000,0x0000,0x0000, 0x0429,0x0000,0x0000,0x0000,
0x0E2B,0x0000,0x0000,0x0000, 0x0E2C,0x0000,0x0000,0x0000,
0x020D,0x0000,0x0000,0x0000, 0x10F8,0x0000,0x0000,0x0000,
0x02C3,0x0000,0x0000,0x0000, 0x0267,0x0000,0x0000,0x0000,
0x0219,0x0000,0x0000,0x0000, 0x0E2A,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x0287,0x0000,0x0000,0x0000,
0x0E2A,0x02CD,0x0E2D,0x0000, 0x0E2A,0x02CD,0x0E2B,0x0000,
0x0E2C,0x02CD,0x0E2D,0x0000, 0x0256,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E38,0x0000,0x0000,0x0000, 0x0E60,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000, 0x0E8B,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000, 0x0E8B,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000, 0x0EFB,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000, 0x0EFB,0x0000,0x0000,0x0000,
0x0E86,0x0000,0x0000,0x0000, 0x0F64,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x0F82,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x0F82,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x042B,0x0000,0x0000,0x0000,
0x0F8D,0x0000,0x0000,0x0000, 0x101F,0x0000,0x0000,0x0000,
0x101F,0x0000,0x0000,0x0000, 0x101F,0x0000,0x0000,0x0000,
0x101F,0x0000,0x0000,0x0000, 0x105E,0x0000,0x0000,0x0000,
0x1094,0x0000,0x0000,0x0000, 0x0FEA,0x0FEA,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E38,0x0000,0x0000,0x0000, 0x0E60,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000, 0x0E8B,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000, 0x0E8B,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000, 0x0EFB,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000, 0x0EFB,0x0000,0x0000,0x0000,
0x0E86,0x0000,0x0000,0x0000, 0x0F64,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x0F82,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x0F82,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x042A,0x0000,0x0000,0x0000,
0x0F8D,0x0000,0x0000,0x0000, 0x101F,0x0000,0x0000,0x0000,
0x101F,0x0000,0x0000,0x0000, 0x101F,0x0000,0x0000,0x0000,
0x101F,0x0000,0x0000,0x0000, 0x105E,0x0000,0x0000,0x0000,
0x1094,0x0000,0x0000,0x0000, 0x105E,0x0000,0x0000,0x0000
};

uint16 page001data[]= { /* 0100 (3 weights per char) */
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E60,0x0000,0x0000, 0x0E60,0x0000,0x0000, 0x0E60,0x0000,0x0000,
0x0E60,0x0000,0x0000, 0x0E60,0x0000,0x0000, 0x0E60,0x0000,0x0000,
0x0E60,0x0000,0x0000, 0x0E60,0x0000,0x0000, 0x0E6D,0x0000,0x0000,
0x0E6D,0x0000,0x0000, 0x0E72,0x0000,0x0000, 0x0E72,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0EC1,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0EC1,0x0000,0x0000, 0x0EC1,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0EC1,0x0000,0x0000, 0x0EC1,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0EED,0x0000,0x0000,
0x0EED,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0EFB,0x0000,0x0000, 0x0EFF,0x0000,0x0000, 0x0EFB,0x0F10,0x0000,
0x0EFB,0x0F10,0x0000, 0x0F10,0x0000,0x0000, 0x0F10,0x0000,0x0000,
0x0F21,0x0000,0x0000, 0x0F21,0x0000,0x0000, 0x0FBC,0x0000,0x0000,
0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000,
0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000,
0x0F2E,0x0267,0x0000, 0x0F2E,0x0267,0x0000, 0x0F36,0x0000,0x0000,
0x0F36,0x0000,0x0000, 0x0F64,0x0000,0x0000, 0x0F64,0x0000,0x0000,
0x0F64,0x0000,0x0000, 0x0F64,0x0000,0x0000, 0x0F64,0x0000,0x0000,
0x0F64,0x0000,0x0000, 0x10B1,0x0F64,0x0000, 0x0F7E,0x0000,0x0000,
0x0F7E,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0E8B,0x0000, 0x0F82,0x0E8B,0x0000,
0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x1002,0x0000,0x0000,
0x1002,0x0000,0x0000, 0x1002,0x0000,0x0000, 0x1002,0x0000,0x0000,
0x1007,0x0000,0x0000, 0x1007,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x1051,0x0000,0x0000,
0x1051,0x0000,0x0000, 0x105E,0x0000,0x0000, 0x105E,0x0000,0x0000,
0x105E,0x0000,0x0000, 0x106A,0x0000,0x0000, 0x106A,0x0000,0x0000,
0x106A,0x0000,0x0000, 0x106A,0x0000,0x0000, 0x106A,0x0000,0x0000,
0x106A,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x0E52,0x0000,0x0000,
0x0E58,0x0000,0x0000, 0x0E5C,0x0000,0x0000, 0x0E5C,0x0000,0x0000,
0x10A8,0x0000,0x0000, 0x10A8,0x0000,0x0000, 0x0F92,0x0000,0x0000,
0x0E65,0x0000,0x0000, 0x0E65,0x0000,0x0000, 0x0E76,0x0000,0x0000,
0x0E7A,0x0000,0x0000, 0x0E7E,0x0000,0x0000, 0x0E7E,0x0000,0x0000,
0x106A,0x1051,0x0000, 0x0E90,0x0000,0x0000, 0x0E94,0x0000,0x0000,
0x0E98,0x0000,0x0000, 0x0EBD,0x0000,0x0000, 0x0EBD,0x0000,0x0000,
0x0ED1,0x0000,0x0000, 0x0ED9,0x0000,0x0000, 0x0EE9,0x0000,0x0000,
0x0F0C,0x0000,0x0000, 0x0F08,0x0000,0x0000, 0x0F26,0x0000,0x0000,
0x0F26,0x0000,0x0000, 0x0F3B,0x0000,0x0000, 0x0F53,0x0000,0x0000,
0x1037,0x0000,0x0000, 0x0F6E,0x0000,0x0000, 0x0F72,0x0000,0x0000,
0x0F9A,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0EDD,0x0000,0x0000, 0x0EDD,0x0000,0x0000, 0x0FAC,0x0000,0x0000,
0x0FAC,0x0000,0x0000, 0x0FC4,0x0000,0x0000, 0x10A0,0x0000,0x0000,
0x10A0,0x0000,0x0000, 0x0FF2,0x0000,0x0000, 0x0FF6,0x0000,0x0000,
0x100B,0x0000,0x0000, 0x100F,0x0000,0x0000, 0x100F,0x0000,0x0000,
0x1013,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x1040,0x0000,0x0000, 0x1049,0x0000,0x0000, 0x1066,0x0000,0x0000,
0x1066,0x0000,0x0000, 0x106F,0x0000,0x0000, 0x106F,0x0000,0x0000,
0x107F,0x0000,0x0000, 0x1084,0x0000,0x0000, 0x1084,0x0000,0x0000,
0x1088,0x0000,0x0000, 0x109C,0x0000,0x0000, 0x10A4,0x0000,0x0000,
0x10A4,0x0000,0x0000, 0x1002,0x0FEA,0x0000, 0x1098,0x0000,0x0000,
0x10C8,0x0000,0x0000, 0x10CC,0x0000,0x0000, 0x10D0,0x0000,0x0000,
0x10D4,0x0000,0x0000, 0x0E6D,0x106A,0x0000, 0x0E6D,0x106A,0x0000,
0x0E6D,0x106A,0x0000, 0x0F2E,0x0F10,0x0000, 0x0F2E,0x0F10,0x0000,
0x0F2E,0x0F10,0x0000, 0x0F64,0x0F10,0x0000, 0x0F64,0x0F10,0x0000,
0x0F64,0x0F10,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x0E90,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E38,0x0000,0x0000, 0x0E38,0x0000,0x0000,
0x0ECD,0x0000,0x0000, 0x0ECD,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0EC1,0x0000,0x0000, 0x0F21,0x0000,0x0000, 0x0F21,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x107F,0x0000,0x0000, 0x107F,0x0000,0x0000,
0x0F10,0x0000,0x0000, 0x0E6D,0x106A,0x0000, 0x0E6D,0x106A,0x0000,
0x0E6D,0x106A,0x0000, 0x0EC1,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0EE9,0x0000,0x0000, 0x1098,0x0000,0x0000, 0x0F64,0x0000,0x0000,
0x0F64,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E38,0x0000,0x0000, 0x0E38,0x0000,0x0000, 0x0F8D,0x0000,0x0000,
0x0F8D,0x0000,0x0000 };

uint16 page002data[]= { /* 0200 (3 weights per char) */
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x1002,0x0000,0x0000,
0x1002,0x0000,0x0000, 0x1090,0x0000,0x0000, 0x1090,0x0000,0x0000,
0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0F72,0x0000,0x0000,
0x0E82,0x0000,0x0000, 0x0FA2,0x0000,0x0000, 0x0FA2,0x0000,0x0000,
0x1073,0x0000,0x0000, 0x1073,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x105E,0x0000,0x0000,
0x105E,0x0000,0x0000, 0x0F4B,0x0000,0x0000, 0x0F7A,0x0000,0x0000,
0x1017,0x0000,0x0000, 0xFBC0,0x8237,0x0000, 0xFBC0,0x8238,0x0000,
0xFBC0,0x8239,0x0000, 0xFBC0,0x823A,0x0000, 0xFBC0,0x823B,0x0000,
0xFBC0,0x823C,0x0000, 0xFBC0,0x823D,0x0000, 0xFBC0,0x823E,0x0000,
0xFBC0,0x823F,0x0000, 0xFBC0,0x8240,0x0000, 0xFBC0,0x8241,0x0000,
0xFBC0,0x8242,0x0000, 0xFBC0,0x8243,0x0000, 0xFBC0,0x8244,0x0000,
0xFBC0,0x8245,0x0000, 0xFBC0,0x8246,0x0000, 0xFBC0,0x8247,0x0000,
0xFBC0,0x8248,0x0000, 0xFBC0,0x8249,0x0000, 0xFBC0,0x824A,0x0000,
0xFBC0,0x824B,0x0000, 0xFBC0,0x824C,0x0000, 0xFBC0,0x824D,0x0000,
0xFBC0,0x824E,0x0000, 0xFBC0,0x824F,0x0000, 0x0E3E,0x0000,0x0000,
0x0E42,0x0000,0x0000, 0x0E46,0x0000,0x0000, 0x0E58,0x0000,0x0000,
0x0F92,0x0000,0x0000, 0x0E69,0x0000,0x0000, 0x0E76,0x0000,0x0000,
0x0E7A,0x0000,0x0000, 0x0E9C,0x0000,0x0000, 0x0E94,0x0000,0x0000,
0x0EA0,0x0000,0x0000, 0x0E98,0x0000,0x0000, 0x0EA4,0x0000,0x0000,
0x0EA9,0x0000,0x0000, 0x0EAD,0x0000,0x0000, 0x0F19,0x0000,0x0000,
0x0ED1,0x0000,0x0000, 0x0EC5,0x0000,0x0000, 0x0EC9,0x0000,0x0000,
0x0ED9,0x0000,0x0000, 0x0EB5,0x0000,0x0000, 0x102B,0x0000,0x0000,
0x0EF1,0x0000,0x0000, 0x0EF5,0x0000,0x0000, 0x0F08,0x0000,0x0000,
0x0F0C,0x0000,0x0000, 0x0F03,0x0000,0x0000, 0x0F3F,0x0000,0x0000,
0x0F43,0x0000,0x0000, 0x0F47,0x0000,0x0000, 0x0F4F,0x0000,0x0000,
0x1037,0x0000,0x0000, 0x103C,0x0000,0x0000, 0x0F60,0x0000,0x0000,
0x0F6E,0x0000,0x0000, 0x0F76,0x0000,0x0000, 0x0F68,0x0000,0x0000,
0x0F9A,0x0000,0x0000, 0x0F88,0x0000,0x0000, 0x0F9E,0x0000,0x0000,
0x0FB0,0x0000,0x0000, 0x0FC9,0x0000,0x0000, 0x0FCE,0x0000,0x0000,
0x0FD2,0x0000,0x0000, 0x0FD6,0x0000,0x0000, 0x0FDA,0x0000,0x0000,
0x0FDE,0x0000,0x0000, 0x0FE2,0x0000,0x0000, 0x0FC4,0x0000,0x0000,
0x0FE6,0x0000,0x0000, 0x0FEE,0x0000,0x0000, 0x0FF2,0x0000,0x0000,
0x0F1D,0x0000,0x0000, 0x0FFA,0x0000,0x0000, 0x0FFE,0x0000,0x0000,
0x101B,0x0000,0x0000, 0x1013,0x0000,0x0000, 0x1027,0x0000,0x0000,
0x1040,0x0000,0x0000, 0x1049,0x0000,0x0000, 0x104D,0x0000,0x0000,
0x1056,0x0000,0x0000, 0x0F57,0x0000,0x0000, 0x1062,0x0000,0x0000,
0x1077,0x0000,0x0000, 0x107B,0x0000,0x0000, 0x107F,0x0000,0x0000,
0x108C,0x0000,0x0000, 0x10AC,0x0000,0x0000, 0x10B4,0x0000,0x0000,
0x10C4,0x0000,0x0000, 0x10D8,0x0000,0x0000, 0x10DC,0x0000,0x0000,
0x0E4E,0x0000,0x0000, 0x0EB1,0x0000,0x0000, 0x0ED5,0x0000,0x0000,
0x0EE5,0x0000,0x0000, 0x0F15,0x0000,0x0000, 0x0F2A,0x0000,0x0000,
0x0F32,0x0000,0x0000, 0x0FB8,0x0000,0x0000, 0x10BC,0x0000,0x0000,
0x10C0,0x0000,0x0000, 0x0E6D,0x106A,0x0000, 0x0E6D,0x107F,0x0000,
0x0E6D,0x107B,0x0000, 0x1002,0x0FEA,0x0000, 0x1002,0x0FF2,0x0000,
0x1002,0x0E69,0x0000, 0x0EB9,0x0F7E,0x0000, 0x0F2E,0x0FEA,0x0000,
0x0F2E,0x106A,0x0000, 0x10E0,0x0000,0x0000, 0x10E4,0x0000,0x0000,
0x102F,0x0000,0x0000, 0x1033,0x0000,0x0000, 0x0EE1,0x0000,0x0000,
0x0EF1,0x0000,0x0000, 0x0F10,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FC9,0x0000,0x0000, 0x0FD2,0x0000,0x0000, 0x0FE6,0x0000,0x0000,
0x1051,0x0000,0x0000, 0x105E,0x0000,0x0000, 0x0317,0x0000,0x0000,
0x0319,0x0000,0x0000, 0x0EF9,0x0000,0x0000, 0x10B1,0x0000,0x0000,
0x0EFA,0x0000,0x0000, 0x10B3,0x0000,0x0000, 0x10B8,0x0000,0x0000,
0x10B0,0x0000,0x0000, 0x10B9,0x0000,0x0000, 0x031A,0x0000,0x0000,
0x031B,0x0000,0x0000, 0x031C,0x0000,0x0000, 0x031D,0x0000,0x0000,
0x031E,0x0000,0x0000, 0x031F,0x0000,0x0000, 0x0320,0x0000,0x0000,
0x0321,0x0000,0x0000, 0x0322,0x0000,0x0000, 0x0323,0x0000,0x0000,
0x0324,0x0000,0x0000, 0x0325,0x0000,0x0000, 0x0326,0x0000,0x0000,
0x0327,0x0000,0x0000, 0x0E01,0x0000,0x0000, 0x0E02,0x0000,0x0000,
0x0328,0x0000,0x0000, 0x0329,0x0000,0x0000, 0x032A,0x0000,0x0000,
0x032B,0x0000,0x0000, 0x032C,0x0000,0x0000, 0x032D,0x0000,0x0000,
0x0212,0x0000,0x0000, 0x0213,0x0000,0x0000, 0x0215,0x0000,0x0000,
0x021A,0x0000,0x0000, 0x020E,0x0000,0x0000, 0x0216,0x0000,0x0000,
0x032E,0x0000,0x0000, 0x032F,0x0000,0x0000, 0x0ED9,0x0000,0x0000,
0x0F2E,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x105A,0x0000,0x0000,
0x10B4,0x0000,0x0000, 0x0330,0x0000,0x0000, 0x0331,0x0000,0x0000,
0x0332,0x0000,0x0000, 0x0333,0x0000,0x0000, 0x0334,0x0000,0x0000,
0x0335,0x0000,0x0000, 0x0336,0x0000,0x0000, 0x0337,0x0000,0x0000,
0x0338,0x0000,0x0000, 0x10B2,0x0000,0x0000, 0x0339,0x0000,0x0000,
0x033A,0x0000,0x0000, 0x033B,0x0000,0x0000, 0x033C,0x0000,0x0000,
0x033D,0x0000,0x0000, 0x033E,0x0000,0x0000, 0x033F,0x0000,0x0000,
0x0340,0x0000,0x0000, 0x0341,0x0000,0x0000, 0x0342,0x0000,0x0000,
0x0343,0x0000,0x0000, 0x0344,0x0000,0x0000, 0x0345,0x0000,0x0000,
0x0346,0x0000,0x0000, 0x0347,0x0000,0x0000, 0x0348,0x0000,0x0000,
0x0349,0x0000,0x0000 };

uint16 page003data[]= { /* 0300 (4 weights per char) */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0xFBC0,0x8358,0x0000,0x0000, 0xFBC0,0x8359,0x0000,0x0000,
0xFBC0,0x835A,0x0000,0x0000, 0xFBC0,0x835B,0x0000,0x0000,
0xFBC0,0x835C,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000, 0x0EFB,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x101F,0x0000,0x0000,0x0000,
0x0E60,0x0000,0x0000,0x0000, 0x0E6D,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000, 0x0F5B,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000, 0x1002,0x0000,0x0000,0x0000,
0x1044,0x0000,0x0000,0x0000, 0x105A,0x0000,0x0000,0x0000,
0xFBC0,0x8370,0x0000,0x0000, 0xFBC0,0x8371,0x0000,0x0000,
0xFBC0,0x8372,0x0000,0x0000, 0xFBC0,0x8373,0x0000,0x0000,
0x0317,0x0000,0x0000,0x0000, 0x0318,0x0000,0x0000,0x0000,
0xFBC0,0x8376,0x0000,0x0000, 0xFBC0,0x8377,0x0000,0x0000,
0xFBC0,0x8378,0x0000,0x0000, 0xFBC0,0x8379,0x0000,0x0000,
0x10F3,0x0000,0x0000,0x0000, 0xFBC0,0x837B,0x0000,0x0000,
0xFBC0,0x837C,0x0000,0x0000, 0xFBC0,0x837D,0x0000,0x0000,
0x023A,0x0000,0x0000,0x0000, 0xFBC0,0x837F,0x0000,0x0000,
0xFBC0,0x8380,0x0000,0x0000, 0xFBC0,0x8381,0x0000,0x0000,
0xFBC0,0x8382,0x0000,0x0000, 0xFBC0,0x8383,0x0000,0x0000,
0x020D,0x0000,0x0000,0x0000, 0x0214,0x0000,0x0000,0x0000,
0x10E8,0x0000,0x0000,0x0000, 0x0267,0x0000,0x0000,0x0000,
0x10ED,0x0000,0x0000,0x0000, 0x10F1,0x0000,0x0000,0x0000,
0x10F3,0x0000,0x0000,0x0000, 0xFBC0,0x838B,0x0000,0x0000,
0x10FB,0x0000,0x0000,0x0000, 0xFBC0,0x838D,0x0000,0x0000,
0x1104,0x0000,0x0000,0x0000, 0x1109,0x0000,0x0000,0x0000,
0x10F3,0x0000,0x0000,0x0000, 0x10E8,0x0000,0x0000,0x0000,
0x10E9,0x0000,0x0000,0x0000, 0x10EA,0x0000,0x0000,0x0000,
0x10EC,0x0000,0x0000,0x0000, 0x10ED,0x0000,0x0000,0x0000,
0x10F0,0x0000,0x0000,0x0000, 0x10F1,0x0000,0x0000,0x0000,
0x10F2,0x0000,0x0000,0x0000, 0x10F3,0x0000,0x0000,0x0000,
0x10F5,0x0000,0x0000,0x0000, 0x10F6,0x0000,0x0000,0x0000,
0x10F8,0x0000,0x0000,0x0000, 0x10F9,0x0000,0x0000,0x0000,
0x10FA,0x0000,0x0000,0x0000, 0x10FB,0x0000,0x0000,0x0000,
0x10FC,0x0000,0x0000,0x0000, 0x1100,0x0000,0x0000,0x0000,
0xFBC0,0x83A2,0x0000,0x0000, 0x1102,0x0000,0x0000,0x0000,
0x1103,0x0000,0x0000,0x0000, 0x1104,0x0000,0x0000,0x0000,
0x1105,0x0000,0x0000,0x0000, 0x1106,0x0000,0x0000,0x0000,
0x1107,0x0000,0x0000,0x0000, 0x1109,0x0000,0x0000,0x0000,
0x10F3,0x0000,0x0000,0x0000, 0x1104,0x0000,0x0000,0x0000,
0x10E8,0x0000,0x0000,0x0000, 0x10ED,0x0000,0x0000,0x0000,
0x10F1,0x0000,0x0000,0x0000, 0x10F3,0x0000,0x0000,0x0000,
0x1104,0x0000,0x0000,0x0000, 0x10E8,0x0000,0x0000,0x0000,
0x10E9,0x0000,0x0000,0x0000, 0x10EA,0x0000,0x0000,0x0000,
0x10EC,0x0000,0x0000,0x0000, 0x10ED,0x0000,0x0000,0x0000,
0x10F0,0x0000,0x0000,0x0000, 0x10F1,0x0000,0x0000,0x0000,
0x10F2,0x0000,0x0000,0x0000, 0x10F3,0x0000,0x0000,0x0000,
0x10F5,0x0000,0x0000,0x0000, 0x10F6,0x0000,0x0000,0x0000,
0x10F8,0x0000,0x0000,0x0000, 0x10F9,0x0000,0x0000,0x0000,
0x10FA,0x0000,0x0000,0x0000, 0x10FB,0x0000,0x0000,0x0000,
0x10FC,0x0000,0x0000,0x0000, 0x1100,0x0000,0x0000,0x0000,
0x1102,0x0000,0x0000,0x0000, 0x1102,0x0000,0x0000,0x0000,
0x1103,0x0000,0x0000,0x0000, 0x1104,0x0000,0x0000,0x0000,
0x1105,0x0000,0x0000,0x0000, 0x1106,0x0000,0x0000,0x0000,
0x1107,0x0000,0x0000,0x0000, 0x1109,0x0000,0x0000,0x0000,
0x10F3,0x0000,0x0000,0x0000, 0x1104,0x0000,0x0000,0x0000,
0x10FB,0x0000,0x0000,0x0000, 0x1104,0x0000,0x0000,0x0000,
0x1109,0x0000,0x0000,0x0000, 0xFBC0,0x83CF,0x0000,0x0000,
0x10E9,0x0000,0x0000,0x0000, 0x10F2,0x0000,0x0000,0x0000,
0x1104,0x0000,0x0000,0x0000, 0x1104,0x0000,0x0000,0x0000,
0x1104,0x0000,0x0000,0x0000, 0x1105,0x0000,0x0000,0x0000,
0x10FC,0x0000,0x0000,0x0000, 0x10F5,0x10E8,0x10F3,0x0000,
0x10FF,0x0000,0x0000,0x0000, 0x10FF,0x0000,0x0000,0x0000,
0x10EF,0x0000,0x0000,0x0000, 0x10EF,0x0000,0x0000,0x0000,
0x10EE,0x0000,0x0000,0x0000, 0x10EE,0x0000,0x0000,0x0000,
0x10FE,0x0000,0x0000,0x0000, 0x10FE,0x0000,0x0000,0x0000,
0x110A,0x0000,0x0000,0x0000, 0x110A,0x0000,0x0000,0x0000,
0x110D,0x0000,0x0000,0x0000, 0x110D,0x0000,0x0000,0x0000,
0x110E,0x0000,0x0000,0x0000, 0x110E,0x0000,0x0000,0x0000,
0x110F,0x0000,0x0000,0x0000, 0x110F,0x0000,0x0000,0x0000,
0x1110,0x0000,0x0000,0x0000, 0x1110,0x0000,0x0000,0x0000,
0x1111,0x0000,0x0000,0x0000, 0x1111,0x0000,0x0000,0x0000,
0x1112,0x0000,0x0000,0x0000, 0x1112,0x0000,0x0000,0x0000,
0x1113,0x0000,0x0000,0x0000, 0x1113,0x0000,0x0000,0x0000,
0x10F5,0x0000,0x0000,0x0000, 0x1100,0x0000,0x0000,0x0000,
0x1102,0x0000,0x0000,0x0000, 0x10F4,0x0000,0x0000,0x0000,
0x10F2,0x0000,0x0000,0x0000, 0x10ED,0x0000,0x0000,0x0000,
0x0423,0x0000,0x0000,0x0000, 0x110B,0x0000,0x0000,0x0000,
0x110B,0x0000,0x0000,0x0000, 0x1102,0x0000,0x0000,0x0000,
0x110C,0x0000,0x0000,0x0000, 0x110C,0x0000,0x0000,0x0000,
0xFBC0,0x83FC,0x0000,0x0000, 0xFBC0,0x83FD,0x0000,0x0000,
0xFBC0,0x83FE,0x0000,0x0000, 0xFBC0,0x83FF,0x0000,0x0000
};

uint16 page004data[]= { /* 0400 (3 weights per char) */
0x1152,0x0000,0x0000, 0x1152,0x0000,0x0000, 0x1145,0x0000,0x0000,
0x114A,0x0000,0x0000, 0x115A,0x0000,0x0000, 0x1173,0x0000,0x0000,
0x1188,0x0000,0x0000, 0x118C,0x0000,0x0000, 0x1194,0x0000,0x0000,
0x11B9,0x0000,0x0000, 0x11DA,0x0000,0x0000, 0x1215,0x0000,0x0000,
0x1219,0x0000,0x0000, 0x117C,0x0000,0x0000, 0x1221,0x0000,0x0000,
0x127D,0x0000,0x0000, 0x1114,0x0000,0x0000, 0x112C,0x0000,0x0000,
0x1130,0x0000,0x0000, 0x1134,0x0000,0x0000, 0x1140,0x0000,0x0000,
0x1152,0x0000,0x0000, 0x115E,0x0000,0x0000, 0x116A,0x0000,0x0000,
0x117C,0x0000,0x0000, 0x1190,0x0000,0x0000, 0x1198,0x0000,0x0000,
0x11B0,0x0000,0x0000, 0x11BE,0x0000,0x0000, 0x11C6,0x0000,0x0000,
0x11DF,0x0000,0x0000, 0x11EF,0x0000,0x0000, 0x11FB,0x0000,0x0000,
0x1203,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x121D,0x0000,0x0000,
0x1239,0x0000,0x0000, 0x123D,0x0000,0x0000, 0x1259,0x0000,0x0000,
0x1261,0x0000,0x0000, 0x1281,0x0000,0x0000, 0x1285,0x0000,0x0000,
0x1289,0x0000,0x0000, 0x128D,0x0000,0x0000, 0x1295,0x0000,0x0000,
0x12A1,0x0000,0x0000, 0x12A9,0x0000,0x0000, 0x12AD,0x0000,0x0000,
0x1114,0x0000,0x0000, 0x112C,0x0000,0x0000, 0x1130,0x0000,0x0000,
0x1134,0x0000,0x0000, 0x1140,0x0000,0x0000, 0x1152,0x0000,0x0000,
0x115E,0x0000,0x0000, 0x116A,0x0000,0x0000, 0x117C,0x0000,0x0000,
0x1190,0x0000,0x0000, 0x1198,0x0000,0x0000, 0x11B0,0x0000,0x0000,
0x11BE,0x0000,0x0000, 0x11C6,0x0000,0x0000, 0x11DF,0x0000,0x0000,
0x11EF,0x0000,0x0000, 0x11FB,0x0000,0x0000, 0x1203,0x0000,0x0000,
0x120C,0x0000,0x0000, 0x121D,0x0000,0x0000, 0x1239,0x0000,0x0000,
0x123D,0x0000,0x0000, 0x1259,0x0000,0x0000, 0x1261,0x0000,0x0000,
0x1281,0x0000,0x0000, 0x1285,0x0000,0x0000, 0x1289,0x0000,0x0000,
0x128D,0x0000,0x0000, 0x1295,0x0000,0x0000, 0x12A1,0x0000,0x0000,
0x12A9,0x0000,0x0000, 0x12AD,0x0000,0x0000, 0x1152,0x0000,0x0000,
0x1152,0x0000,0x0000, 0x1145,0x0000,0x0000, 0x114A,0x0000,0x0000,
0x115A,0x0000,0x0000, 0x1173,0x0000,0x0000, 0x1188,0x0000,0x0000,
0x118C,0x0000,0x0000, 0x1194,0x0000,0x0000, 0x11B9,0x0000,0x0000,
0x11DA,0x0000,0x0000, 0x1215,0x0000,0x0000, 0x1219,0x0000,0x0000,
0x117C,0x0000,0x0000, 0x1221,0x0000,0x0000, 0x127D,0x0000,0x0000,
0x1249,0x0000,0x0000, 0x1249,0x0000,0x0000, 0x129D,0x0000,0x0000,
0x129D,0x0000,0x0000, 0x12B1,0x0000,0x0000, 0x12B1,0x0000,0x0000,
0x12B5,0x0000,0x0000, 0x12B5,0x0000,0x0000, 0x12BD,0x0000,0x0000,
0x12BD,0x0000,0x0000, 0x12B9,0x0000,0x0000, 0x12B9,0x0000,0x0000,
0x12C1,0x0000,0x0000, 0x12C1,0x0000,0x0000, 0x12C5,0x0000,0x0000,
0x12C5,0x0000,0x0000, 0x12C9,0x0000,0x0000, 0x12C9,0x0000,0x0000,
0x12CD,0x0000,0x0000, 0x12CD,0x0000,0x0000, 0x12D1,0x0000,0x0000,
0x12D1,0x0000,0x0000, 0x12D5,0x0000,0x0000, 0x12D5,0x0000,0x0000,
0x1235,0x0000,0x0000, 0x1235,0x0000,0x0000, 0x1255,0x0000,0x0000,
0x1255,0x0000,0x0000, 0x1251,0x0000,0x0000, 0x1251,0x0000,0x0000,
0x124D,0x0000,0x0000, 0x124D,0x0000,0x0000, 0x11F7,0x0000,0x0000,
0x11F7,0x0000,0x0000, 0x034B,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x8487,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x1180,0x0000,0x0000, 0x1180,0x0000,0x0000, 0x1299,0x0000,0x0000,
0x1299,0x0000,0x0000, 0x11FF,0x0000,0x0000, 0x11FF,0x0000,0x0000,
0x1134,0x0000,0x0000, 0x1134,0x0000,0x0000, 0x1138,0x0000,0x0000,
0x1138,0x0000,0x0000, 0x113C,0x0000,0x0000, 0x113C,0x0000,0x0000,
0x1166,0x0000,0x0000, 0x1166,0x0000,0x0000, 0x114E,0x0000,0x0000,
0x114E,0x0000,0x0000, 0x119C,0x0000,0x0000, 0x119C,0x0000,0x0000,
0x11AC,0x0000,0x0000, 0x11AC,0x0000,0x0000, 0x11A8,0x0000,0x0000,
0x11A8,0x0000,0x0000, 0x11A4,0x0000,0x0000, 0x11A4,0x0000,0x0000,
0x11CE,0x0000,0x0000, 0x11CE,0x0000,0x0000, 0x11D6,0x0000,0x0000,
0x11D6,0x0000,0x0000, 0x11F3,0x0000,0x0000, 0x11F3,0x0000,0x0000,
0x12D9,0x0000,0x0000, 0x12D9,0x0000,0x0000, 0x1208,0x0000,0x0000,
0x1208,0x0000,0x0000, 0x1211,0x0000,0x0000, 0x1211,0x0000,0x0000,
0x122D,0x0000,0x0000, 0x122D,0x0000,0x0000, 0x1231,0x0000,0x0000,
0x1231,0x0000,0x0000, 0x1241,0x0000,0x0000, 0x1241,0x0000,0x0000,
0x125D,0x0000,0x0000, 0x125D,0x0000,0x0000, 0x1269,0x0000,0x0000,
0x1269,0x0000,0x0000, 0x1271,0x0000,0x0000, 0x1271,0x0000,0x0000,
0x1245,0x0000,0x0000, 0x1245,0x0000,0x0000, 0x1275,0x0000,0x0000,
0x1275,0x0000,0x0000, 0x1279,0x0000,0x0000, 0x1279,0x0000,0x0000,
0x12DD,0x0000,0x0000, 0x115E,0x0000,0x0000, 0x115E,0x0000,0x0000,
0x11A0,0x0000,0x0000, 0x11A0,0x0000,0x0000, 0x11B5,0x0000,0x0000,
0x11B5,0x0000,0x0000, 0x11D2,0x0000,0x0000, 0x11D2,0x0000,0x0000,
0x11CA,0x0000,0x0000, 0x11CA,0x0000,0x0000, 0x126D,0x0000,0x0000,
0x126D,0x0000,0x0000, 0x11C2,0x0000,0x0000, 0x11C2,0x0000,0x0000,
0xFBC0,0x84CF,0x0000, 0x1118,0x0000,0x0000, 0x1118,0x0000,0x0000,
0x111C,0x0000,0x0000, 0x111C,0x0000,0x0000, 0x1128,0x0000,0x0000,
0x1128,0x0000,0x0000, 0x1156,0x0000,0x0000, 0x1156,0x0000,0x0000,
0x1120,0x0000,0x0000, 0x1120,0x0000,0x0000, 0x1124,0x0000,0x0000,
0x1124,0x0000,0x0000, 0x1162,0x0000,0x0000, 0x1162,0x0000,0x0000,
0x116F,0x0000,0x0000, 0x116F,0x0000,0x0000, 0x1177,0x0000,0x0000,
0x1177,0x0000,0x0000, 0x117C,0x0000,0x0000, 0x117C,0x0000,0x0000,
0x1184,0x0000,0x0000, 0x1184,0x0000,0x0000, 0x11E3,0x0000,0x0000,
0x11E3,0x0000,0x0000, 0x11E7,0x0000,0x0000, 0x11E7,0x0000,0x0000,
0x11EB,0x0000,0x0000, 0x11EB,0x0000,0x0000, 0x12A5,0x0000,0x0000,
0x12A5,0x0000,0x0000, 0x121D,0x0000,0x0000, 0x121D,0x0000,0x0000,
0x1225,0x0000,0x0000, 0x1225,0x0000,0x0000, 0x1229,0x0000,0x0000,
0x1229,0x0000,0x0000, 0x1265,0x0000,0x0000, 0x1265,0x0000,0x0000,
0xFBC0,0x84F6,0x0000, 0xFBC0,0x84F7,0x0000, 0x1291,0x0000,0x0000,
0x1291,0x0000,0x0000, 0xFBC0,0x84FA,0x0000, 0xFBC0,0x84FB,0x0000,
0xFBC0,0x84FC,0x0000, 0xFBC0,0x84FD,0x0000, 0xFBC0,0x84FE,0x0000,
0xFBC0,0x84FF,0x0000 };

uint16 page005data[]= { /* 0500 (3 weights per char) */
0x1144,0x0000,0x0000, 0x1144,0x0000,0x0000, 0x1149,0x0000,0x0000,
0x1149,0x0000,0x0000, 0x116E,0x0000,0x0000, 0x116E,0x0000,0x0000,
0x117B,0x0000,0x0000, 0x117B,0x0000,0x0000, 0x11BD,0x0000,0x0000,
0x11BD,0x0000,0x0000, 0x11DE,0x0000,0x0000, 0x11DE,0x0000,0x0000,
0x1207,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1210,0x0000,0x0000,
0x1210,0x0000,0x0000, 0xFBC0,0x8510,0x0000, 0xFBC0,0x8511,0x0000,
0xFBC0,0x8512,0x0000, 0xFBC0,0x8513,0x0000, 0xFBC0,0x8514,0x0000,
0xFBC0,0x8515,0x0000, 0xFBC0,0x8516,0x0000, 0xFBC0,0x8517,0x0000,
0xFBC0,0x8518,0x0000, 0xFBC0,0x8519,0x0000, 0xFBC0,0x851A,0x0000,
0xFBC0,0x851B,0x0000, 0xFBC0,0x851C,0x0000, 0xFBC0,0x851D,0x0000,
0xFBC0,0x851E,0x0000, 0xFBC0,0x851F,0x0000, 0xFBC0,0x8520,0x0000,
0xFBC0,0x8521,0x0000, 0xFBC0,0x8522,0x0000, 0xFBC0,0x8523,0x0000,
0xFBC0,0x8524,0x0000, 0xFBC0,0x8525,0x0000, 0xFBC0,0x8526,0x0000,
0xFBC0,0x8527,0x0000, 0xFBC0,0x8528,0x0000, 0xFBC0,0x8529,0x0000,
0xFBC0,0x852A,0x0000, 0xFBC0,0x852B,0x0000, 0xFBC0,0x852C,0x0000,
0xFBC0,0x852D,0x0000, 0xFBC0,0x852E,0x0000, 0xFBC0,0x852F,0x0000,
0xFBC0,0x8530,0x0000, 0x130A,0x0000,0x0000, 0x130B,0x0000,0x0000,
0x130C,0x0000,0x0000, 0x130D,0x0000,0x0000, 0x130E,0x0000,0x0000,
0x130F,0x0000,0x0000, 0x1310,0x0000,0x0000, 0x1311,0x0000,0x0000,
0x1312,0x0000,0x0000, 0x1313,0x0000,0x0000, 0x1314,0x0000,0x0000,
0x1315,0x0000,0x0000, 0x1316,0x0000,0x0000, 0x1317,0x0000,0x0000,
0x1318,0x0000,0x0000, 0x1319,0x0000,0x0000, 0x131A,0x0000,0x0000,
0x131B,0x0000,0x0000, 0x131C,0x0000,0x0000, 0x131D,0x0000,0x0000,
0x131E,0x0000,0x0000, 0x131F,0x0000,0x0000, 0x1320,0x0000,0x0000,
0x1321,0x0000,0x0000, 0x1322,0x0000,0x0000, 0x1323,0x0000,0x0000,
0x1324,0x0000,0x0000, 0x1325,0x0000,0x0000, 0x1326,0x0000,0x0000,
0x1327,0x0000,0x0000, 0x1328,0x0000,0x0000, 0x1329,0x0000,0x0000,
0x132A,0x0000,0x0000, 0x132B,0x0000,0x0000, 0x132C,0x0000,0x0000,
0x132D,0x0000,0x0000, 0x132E,0x0000,0x0000, 0x132F,0x0000,0x0000,
0xFBC0,0x8557,0x0000, 0xFBC0,0x8558,0x0000, 0x1330,0x0000,0x0000,
0x02EC,0x0000,0x0000, 0x02ED,0x0000,0x0000, 0x0253,0x0000,0x0000,
0x0230,0x0000,0x0000, 0x0257,0x0000,0x0000, 0x02EE,0x0000,0x0000,
0xFBC0,0x8560,0x0000, 0x130A,0x0000,0x0000, 0x130B,0x0000,0x0000,
0x130C,0x0000,0x0000, 0x130D,0x0000,0x0000, 0x130E,0x0000,0x0000,
0x130F,0x0000,0x0000, 0x1310,0x0000,0x0000, 0x1311,0x0000,0x0000,
0x1312,0x0000,0x0000, 0x1313,0x0000,0x0000, 0x1314,0x0000,0x0000,
0x1315,0x0000,0x0000, 0x1316,0x0000,0x0000, 0x1317,0x0000,0x0000,
0x1318,0x0000,0x0000, 0x1319,0x0000,0x0000, 0x131A,0x0000,0x0000,
0x131B,0x0000,0x0000, 0x131C,0x0000,0x0000, 0x131D,0x0000,0x0000,
0x131E,0x0000,0x0000, 0x131F,0x0000,0x0000, 0x1320,0x0000,0x0000,
0x1321,0x0000,0x0000, 0x1322,0x0000,0x0000, 0x1323,0x0000,0x0000,
0x1324,0x0000,0x0000, 0x1325,0x0000,0x0000, 0x1326,0x0000,0x0000,
0x1327,0x0000,0x0000, 0x1328,0x0000,0x0000, 0x1329,0x0000,0x0000,
0x132A,0x0000,0x0000, 0x132B,0x0000,0x0000, 0x132C,0x0000,0x0000,
0x132D,0x0000,0x0000, 0x132E,0x0000,0x0000, 0x132F,0x0000,0x0000,
0x130E,0x132B,0x0000, 0xFBC0,0x8588,0x0000, 0x023E,0x0000,0x0000,
0x0222,0x0000,0x0000, 0xFBC0,0x858B,0x0000, 0xFBC0,0x858C,0x0000,
0xFBC0,0x858D,0x0000, 0xFBC0,0x858E,0x0000, 0xFBC0,0x858F,0x0000,
0xFBC0,0x8590,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x85A2,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x85BA,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x02EF,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x02F0,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x02F1,0x0000,0x0000, 0x0000,0x0000,0x0000, 0xFBC0,0x85C5,0x0000,
0xFBC0,0x85C6,0x0000, 0xFBC0,0x85C7,0x0000, 0xFBC0,0x85C8,0x0000,
0xFBC0,0x85C9,0x0000, 0xFBC0,0x85CA,0x0000, 0xFBC0,0x85CB,0x0000,
0xFBC0,0x85CC,0x0000, 0xFBC0,0x85CD,0x0000, 0xFBC0,0x85CE,0x0000,
0xFBC0,0x85CF,0x0000, 0x1331,0x0000,0x0000, 0x1332,0x0000,0x0000,
0x1333,0x0000,0x0000, 0x1334,0x0000,0x0000, 0x1335,0x0000,0x0000,
0x1336,0x0000,0x0000, 0x1337,0x0000,0x0000, 0x1338,0x0000,0x0000,
0x1339,0x0000,0x0000, 0x133A,0x0000,0x0000, 0x133B,0x0000,0x0000,
0x133B,0x0000,0x0000, 0x133C,0x0000,0x0000, 0x133D,0x0000,0x0000,
0x133D,0x0000,0x0000, 0x133E,0x0000,0x0000, 0x133E,0x0000,0x0000,
0x133F,0x0000,0x0000, 0x1340,0x0000,0x0000, 0x1341,0x0000,0x0000,
0x1341,0x0000,0x0000, 0x1342,0x0000,0x0000, 0x1342,0x0000,0x0000,
0x1343,0x0000,0x0000, 0x1344,0x0000,0x0000, 0x1345,0x0000,0x0000,
0x1346,0x0000,0x0000, 0xFBC0,0x85EB,0x0000, 0xFBC0,0x85EC,0x0000,
0xFBC0,0x85ED,0x0000, 0xFBC0,0x85EE,0x0000, 0xFBC0,0x85EF,0x0000,
0x1336,0x1336,0x0000, 0x1336,0x133A,0x0000, 0x133A,0x133A,0x0000,
0x02F2,0x0000,0x0000, 0x02F3,0x0000,0x0000, 0xFBC0,0x85F5,0x0000,
0xFBC0,0x85F6,0x0000, 0xFBC0,0x85F7,0x0000, 0xFBC0,0x85F8,0x0000,
0xFBC0,0x85F9,0x0000, 0xFBC0,0x85FA,0x0000, 0xFBC0,0x85FB,0x0000,
0xFBC0,0x85FC,0x0000, 0xFBC0,0x85FD,0x0000, 0xFBC0,0x85FE,0x0000,
0xFBC0,0x85FF,0x0000 };

uint16 page006data[]= { /* 0600 (3 weights per char) */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8604,0x0000, 0xFBC0,0x8605,0x0000,
0xFBC0,0x8606,0x0000, 0xFBC0,0x8607,0x0000, 0xFBC0,0x8608,0x0000,
0xFBC0,0x8609,0x0000, 0xFBC0,0x860A,0x0000, 0xFBC0,0x860B,0x0000,
0x0231,0x0000,0x0000, 0x0232,0x0000,0x0000, 0x034C,0x0000,0x0000,
0x034D,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8616,0x0000, 0xFBC0,0x8617,0x0000,
0xFBC0,0x8618,0x0000, 0xFBC0,0x8619,0x0000, 0xFBC0,0x861A,0x0000,
0x023B,0x0000,0x0000, 0xFBC0,0x861C,0x0000, 0xFBC0,0x861D,0x0000,
0xFBC0,0x861E,0x0000, 0x0258,0x0000,0x0000, 0xFBC0,0x8620,0x0000,
0x1347,0x0000,0x0000, 0x1348,0x0000,0x0000, 0x1349,0x0000,0x0000,
0x134C,0x0000,0x0000, 0x134D,0x0000,0x0000, 0x134F,0x0000,0x0000,
0x1350,0x0000,0x0000, 0x1352,0x0000,0x0000, 0x1356,0x0000,0x0000,
0x1357,0x0000,0x0000, 0x1358,0x0000,0x0000, 0x135E,0x0000,0x0000,
0x1364,0x0000,0x0000, 0x1365,0x0000,0x0000, 0x1369,0x0000,0x0000,
0x136A,0x0000,0x0000, 0x1375,0x0000,0x0000, 0x1376,0x0000,0x0000,
0x1381,0x0000,0x0000, 0x1382,0x0000,0x0000, 0x1387,0x0000,0x0000,
0x1388,0x0000,0x0000, 0x138C,0x0000,0x0000, 0x138D,0x0000,0x0000,
0x138F,0x0000,0x0000, 0x1390,0x0000,0x0000, 0xFBC0,0x863B,0x0000,
0xFBC0,0x863C,0x0000, 0xFBC0,0x863D,0x0000, 0xFBC0,0x863E,0x0000,
0xFBC0,0x863F,0x0000, 0x020B,0x0000,0x0000, 0x1393,0x0000,0x0000,
0x139B,0x0000,0x0000, 0x139E,0x0000,0x0000, 0x13AB,0x0000,0x0000,
0x13B0,0x0000,0x0000, 0x13B1,0x0000,0x0000, 0x13B7,0x0000,0x0000,
0x13BD,0x0000,0x0000, 0x13C7,0x0000,0x0000, 0x13C8,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0xFBC0,0x8659,0x0000,
0xFBC0,0x865A,0x0000, 0xFBC0,0x865B,0x0000, 0xFBC0,0x865C,0x0000,
0xFBC0,0x865D,0x0000, 0xFBC0,0x865E,0x0000, 0xFBC0,0x865F,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0x02D4,0x0000,0x0000, 0x0233,0x0000,0x0000,
0x0234,0x0000,0x0000, 0x02CB,0x0000,0x0000, 0x1351,0x0000,0x0000,
0x139A,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x134B,0x0000,0x0000,
0x134A,0x0000,0x0000, 0x134E,0x0000,0x0000, 0x1347,0x0000,0x0000,
0x1350,0x1347,0x0000, 0x13BD,0x1347,0x0000, 0x13C1,0x1347,0x0000,
0x13C8,0x1347,0x0000, 0x1359,0x0000,0x0000, 0x135A,0x0000,0x0000,
0x1353,0x0000,0x0000, 0x135B,0x0000,0x0000, 0x135C,0x0000,0x0000,
0x1354,0x0000,0x0000, 0x135D,0x0000,0x0000, 0x1355,0x0000,0x0000,
0x1366,0x0000,0x0000, 0x1367,0x0000,0x0000, 0x135F,0x0000,0x0000,
0x1360,0x0000,0x0000, 0x1368,0x0000,0x0000, 0x1361,0x0000,0x0000,
0x1363,0x0000,0x0000, 0x136B,0x0000,0x0000, 0x136C,0x0000,0x0000,
0x136D,0x0000,0x0000, 0x136E,0x0000,0x0000, 0x136F,0x0000,0x0000,
0x1370,0x0000,0x0000, 0x1371,0x0000,0x0000, 0x1372,0x0000,0x0000,
0x1373,0x0000,0x0000, 0x1377,0x0000,0x0000, 0x1378,0x0000,0x0000,
0x1379,0x0000,0x0000, 0x137A,0x0000,0x0000, 0x137B,0x0000,0x0000,
0x137C,0x0000,0x0000, 0x137D,0x0000,0x0000, 0x137E,0x0000,0x0000,
0x137F,0x0000,0x0000, 0x1383,0x0000,0x0000, 0x1384,0x0000,0x0000,
0x1385,0x0000,0x0000, 0x1389,0x0000,0x0000, 0x138A,0x0000,0x0000,
0x138E,0x0000,0x0000, 0x1391,0x0000,0x0000, 0x1394,0x0000,0x0000,
0x1395,0x0000,0x0000, 0x1396,0x0000,0x0000, 0x1397,0x0000,0x0000,
0x1398,0x0000,0x0000, 0x1399,0x0000,0x0000, 0x139C,0x0000,0x0000,
0x139D,0x0000,0x0000, 0x139F,0x0000,0x0000, 0x13A0,0x0000,0x0000,
0x13A1,0x0000,0x0000, 0x13A2,0x0000,0x0000, 0x13A3,0x0000,0x0000,
0x13A4,0x0000,0x0000, 0x13A5,0x0000,0x0000, 0x13A6,0x0000,0x0000,
0x13A7,0x0000,0x0000, 0x13A8,0x0000,0x0000, 0x13A9,0x0000,0x0000,
0x13AA,0x0000,0x0000, 0x13AC,0x0000,0x0000, 0x13AD,0x0000,0x0000,
0x13AE,0x0000,0x0000, 0x13AF,0x0000,0x0000, 0x13B6,0x0000,0x0000,
0x13B2,0x0000,0x0000, 0x13B3,0x0000,0x0000, 0x13B4,0x0000,0x0000,
0x13B5,0x0000,0x0000, 0x13B8,0x0000,0x0000, 0x1362,0x0000,0x0000,
0x13BC,0x0000,0x0000, 0x13B9,0x0000,0x0000, 0x13B9,0x0000,0x0000,
0x13BA,0x0000,0x0000, 0x13BE,0x0000,0x0000, 0x13BF,0x0000,0x0000,
0x13C0,0x0000,0x0000, 0x13C1,0x0000,0x0000, 0x13C2,0x0000,0x0000,
0x13C3,0x0000,0x0000, 0x13C4,0x0000,0x0000, 0x13C5,0x0000,0x0000,
0x13C9,0x0000,0x0000, 0x13CA,0x0000,0x0000, 0x13CB,0x0000,0x0000,
0x13C6,0x0000,0x0000, 0x13CC,0x0000,0x0000, 0x13CD,0x0000,0x0000,
0x13CE,0x0000,0x0000, 0x13CE,0x0000,0x0000, 0x025F,0x0000,0x0000,
0x13BC,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x13BD,0x0000,0x0000, 0x13C8,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x034E,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x1374,0x0000,0x0000, 0x1380,0x0000,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0x1386,0x0000,0x0000, 0x138B,0x0000,0x0000,
0x1392,0x0000,0x0000, 0x1347,0x0000,0x0000, 0x13B0,0x0000,0x0000,
0x13BB,0x0000,0x0000 };

uint16 page007data[]= { /* 0700 (3 weights per char) */
0x0270,0x0000,0x0000, 0x0260,0x0000,0x0000, 0x0261,0x0000,0x0000,
0x023F,0x0000,0x0000, 0x0240,0x0000,0x0000, 0x0241,0x0000,0x0000,
0x0242,0x0000,0x0000, 0x0243,0x0000,0x0000, 0x0244,0x0000,0x0000,
0x0259,0x0000,0x0000, 0x02F4,0x0000,0x0000, 0x02F5,0x0000,0x0000,
0x02F6,0x0000,0x0000, 0x02F7,0x0000,0x0000, 0xFBC0,0x870E,0x0000,
0x0000,0x0000,0x0000, 0x13CF,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x13D0,0x0000,0x0000, 0x13D1,0x0000,0x0000, 0x13D1,0x0000,0x0000,
0x13D3,0x0000,0x0000, 0x13D2,0x0000,0x0000, 0x13D4,0x0000,0x0000,
0x13D5,0x0000,0x0000, 0x13D6,0x0000,0x0000, 0x13D8,0x0000,0x0000,
0x13D9,0x0000,0x0000, 0x13D9,0x0000,0x0000, 0x13DA,0x0000,0x0000,
0x13DB,0x0000,0x0000, 0x13DC,0x0000,0x0000, 0x13DE,0x0000,0x0000,
0x13DF,0x0000,0x0000, 0x13E0,0x0000,0x0000, 0x13E1,0x0000,0x0000,
0x13E1,0x0000,0x0000, 0x13E2,0x0000,0x0000, 0x13E3,0x0000,0x0000,
0x13E3,0x0000,0x0000, 0x13E5,0x0000,0x0000, 0x13E6,0x0000,0x0000,
0x13E7,0x0000,0x0000, 0x13E8,0x0000,0x0000, 0x13E9,0x0000,0x0000,
0x13D0,0x0000,0x0000, 0x13D1,0x0000,0x0000, 0x13D3,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x874B,0x0000, 0xFBC0,0x874C,0x0000, 0x13D7,0x0000,0x0000,
0x13DD,0x0000,0x0000, 0x13E4,0x0000,0x0000, 0xFBC0,0x8750,0x0000,
0xFBC0,0x8751,0x0000, 0xFBC0,0x8752,0x0000, 0xFBC0,0x8753,0x0000,
0xFBC0,0x8754,0x0000, 0xFBC0,0x8755,0x0000, 0xFBC0,0x8756,0x0000,
0xFBC0,0x8757,0x0000, 0xFBC0,0x8758,0x0000, 0xFBC0,0x8759,0x0000,
0xFBC0,0x875A,0x0000, 0xFBC0,0x875B,0x0000, 0xFBC0,0x875C,0x0000,
0xFBC0,0x875D,0x0000, 0xFBC0,0x875E,0x0000, 0xFBC0,0x875F,0x0000,
0xFBC0,0x8760,0x0000, 0xFBC0,0x8761,0x0000, 0xFBC0,0x8762,0x0000,
0xFBC0,0x8763,0x0000, 0xFBC0,0x8764,0x0000, 0xFBC0,0x8765,0x0000,
0xFBC0,0x8766,0x0000, 0xFBC0,0x8767,0x0000, 0xFBC0,0x8768,0x0000,
0xFBC0,0x8769,0x0000, 0xFBC0,0x876A,0x0000, 0xFBC0,0x876B,0x0000,
0xFBC0,0x876C,0x0000, 0xFBC0,0x876D,0x0000, 0xFBC0,0x876E,0x0000,
0xFBC0,0x876F,0x0000, 0xFBC0,0x8770,0x0000, 0xFBC0,0x8771,0x0000,
0xFBC0,0x8772,0x0000, 0xFBC0,0x8773,0x0000, 0xFBC0,0x8774,0x0000,
0xFBC0,0x8775,0x0000, 0xFBC0,0x8776,0x0000, 0xFBC0,0x8777,0x0000,
0xFBC0,0x8778,0x0000, 0xFBC0,0x8779,0x0000, 0xFBC0,0x877A,0x0000,
0xFBC0,0x877B,0x0000, 0xFBC0,0x877C,0x0000, 0xFBC0,0x877D,0x0000,
0xFBC0,0x877E,0x0000, 0xFBC0,0x877F,0x0000, 0x13EA,0x0000,0x0000,
0x13ED,0x0000,0x0000, 0x13EE,0x0000,0x0000, 0x13EF,0x0000,0x0000,
0x13F1,0x0000,0x0000, 0x13F2,0x0000,0x0000, 0x13F3,0x0000,0x0000,
0x13F4,0x0000,0x0000, 0x13F7,0x0000,0x0000, 0x13F9,0x0000,0x0000,
0x13FA,0x0000,0x0000, 0x13FB,0x0000,0x0000, 0x13FD,0x0000,0x0000,
0x1401,0x0000,0x0000, 0x1402,0x0000,0x0000, 0x1404,0x0000,0x0000,
0x1405,0x0000,0x0000, 0x1409,0x0000,0x0000, 0x140A,0x0000,0x0000,
0x140B,0x0000,0x0000, 0x140C,0x0000,0x0000, 0x140D,0x0000,0x0000,
0x140E,0x0000,0x0000, 0x140F,0x0000,0x0000, 0x13FE,0x0000,0x0000,
0x13EB,0x0000,0x0000, 0x13EC,0x0000,0x0000, 0x13FC,0x0000,0x0000,
0x13F0,0x0000,0x0000, 0x1406,0x0000,0x0000, 0x1407,0x0000,0x0000,
0x1408,0x0000,0x0000, 0x13FF,0x0000,0x0000, 0x1400,0x0000,0x0000,
0x13F5,0x0000,0x0000, 0x13F6,0x0000,0x0000, 0x1403,0x0000,0x0000,
0x13F8,0x0000,0x0000, 0x1411,0x0000,0x0000, 0x1412,0x0000,0x0000,
0x1413,0x0000,0x0000, 0x1414,0x0000,0x0000, 0x1415,0x0000,0x0000,
0x1416,0x0000,0x0000, 0x1417,0x0000,0x0000, 0x1418,0x0000,0x0000,
0x1419,0x0000,0x0000, 0x141A,0x0000,0x0000, 0x141B,0x0000,0x0000,
0x1410,0x0000,0x0000, 0xFBC0,0x87B2,0x0000, 0xFBC0,0x87B3,0x0000,
0xFBC0,0x87B4,0x0000, 0xFBC0,0x87B5,0x0000, 0xFBC0,0x87B6,0x0000,
0xFBC0,0x87B7,0x0000, 0xFBC0,0x87B8,0x0000, 0xFBC0,0x87B9,0x0000,
0xFBC0,0x87BA,0x0000, 0xFBC0,0x87BB,0x0000, 0xFBC0,0x87BC,0x0000,
0xFBC0,0x87BD,0x0000, 0xFBC0,0x87BE,0x0000, 0xFBC0,0x87BF,0x0000,
0xFBC0,0x87C0,0x0000, 0xFBC0,0x87C1,0x0000, 0xFBC0,0x87C2,0x0000,
0xFBC0,0x87C3,0x0000, 0xFBC0,0x87C4,0x0000, 0xFBC0,0x87C5,0x0000,
0xFBC0,0x87C6,0x0000, 0xFBC0,0x87C7,0x0000, 0xFBC0,0x87C8,0x0000,
0xFBC0,0x87C9,0x0000, 0xFBC0,0x87CA,0x0000, 0xFBC0,0x87CB,0x0000,
0xFBC0,0x87CC,0x0000, 0xFBC0,0x87CD,0x0000, 0xFBC0,0x87CE,0x0000,
0xFBC0,0x87CF,0x0000, 0xFBC0,0x87D0,0x0000, 0xFBC0,0x87D1,0x0000,
0xFBC0,0x87D2,0x0000, 0xFBC0,0x87D3,0x0000, 0xFBC0,0x87D4,0x0000,
0xFBC0,0x87D5,0x0000, 0xFBC0,0x87D6,0x0000, 0xFBC0,0x87D7,0x0000,
0xFBC0,0x87D8,0x0000, 0xFBC0,0x87D9,0x0000, 0xFBC0,0x87DA,0x0000,
0xFBC0,0x87DB,0x0000, 0xFBC0,0x87DC,0x0000, 0xFBC0,0x87DD,0x0000,
0xFBC0,0x87DE,0x0000, 0xFBC0,0x87DF,0x0000, 0xFBC0,0x87E0,0x0000,
0xFBC0,0x87E1,0x0000, 0xFBC0,0x87E2,0x0000, 0xFBC0,0x87E3,0x0000,
0xFBC0,0x87E4,0x0000, 0xFBC0,0x87E5,0x0000, 0xFBC0,0x87E6,0x0000,
0xFBC0,0x87E7,0x0000, 0xFBC0,0x87E8,0x0000, 0xFBC0,0x87E9,0x0000,
0xFBC0,0x87EA,0x0000, 0xFBC0,0x87EB,0x0000, 0xFBC0,0x87EC,0x0000,
0xFBC0,0x87ED,0x0000, 0xFBC0,0x87EE,0x0000, 0xFBC0,0x87EF,0x0000,
0xFBC0,0x87F0,0x0000, 0xFBC0,0x87F1,0x0000, 0xFBC0,0x87F2,0x0000,
0xFBC0,0x87F3,0x0000, 0xFBC0,0x87F4,0x0000, 0xFBC0,0x87F5,0x0000,
0xFBC0,0x87F6,0x0000, 0xFBC0,0x87F7,0x0000, 0xFBC0,0x87F8,0x0000,
0xFBC0,0x87F9,0x0000, 0xFBC0,0x87FA,0x0000, 0xFBC0,0x87FB,0x0000,
0xFBC0,0x87FC,0x0000, 0xFBC0,0x87FD,0x0000, 0xFBC0,0x87FE,0x0000,
0xFBC0,0x87FF,0x0000 };

uint16 page009data[]= { /* 0900 (3 weights per char) */
0xFBC0,0x8900,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x155A,0x0000,0x0000, 0x155B,0x0000,0x0000,
0x155C,0x0000,0x0000, 0x155D,0x0000,0x0000, 0x155E,0x0000,0x0000,
0x155F,0x0000,0x0000, 0x1560,0x0000,0x0000, 0x1561,0x0000,0x0000,
0x1563,0x0000,0x0000, 0x1565,0x0000,0x0000, 0x1566,0x0000,0x0000,
0x1567,0x0000,0x0000, 0x1568,0x0000,0x0000, 0x1569,0x0000,0x0000,
0x156A,0x0000,0x0000, 0x156B,0x0000,0x0000, 0x156C,0x0000,0x0000,
0x156D,0x0000,0x0000, 0x156E,0x0000,0x0000, 0x156F,0x0000,0x0000,
0x1570,0x0000,0x0000, 0x1571,0x0000,0x0000, 0x1572,0x0000,0x0000,
0x1573,0x0000,0x0000, 0x1574,0x0000,0x0000, 0x1575,0x0000,0x0000,
0x1576,0x0000,0x0000, 0x1577,0x0000,0x0000, 0x1578,0x0000,0x0000,
0x1579,0x0000,0x0000, 0x157A,0x0000,0x0000, 0x157B,0x0000,0x0000,
0x157C,0x0000,0x0000, 0x157D,0x0000,0x0000, 0x157E,0x0000,0x0000,
0x157F,0x0000,0x0000, 0x1580,0x0000,0x0000, 0x1580,0x0000,0x0000,
0x1581,0x0000,0x0000, 0x1582,0x0000,0x0000, 0x1583,0x0000,0x0000,
0x1584,0x0000,0x0000, 0x1585,0x0000,0x0000, 0x1586,0x0000,0x0000,
0x1587,0x0000,0x0000, 0x1587,0x0000,0x0000, 0x1588,0x0000,0x0000,
0x1589,0x0000,0x0000, 0x1589,0x0000,0x0000, 0x158A,0x0000,0x0000,
0x158B,0x0000,0x0000, 0x158C,0x0000,0x0000, 0x158D,0x0000,0x0000,
0x158E,0x0000,0x0000, 0xFBC0,0x893A,0x0000, 0xFBC0,0x893B,0x0000,
0x0000,0x0000,0x0000, 0x158F,0x0000,0x0000, 0x1590,0x0000,0x0000,
0x1591,0x0000,0x0000, 0x1592,0x0000,0x0000, 0x1593,0x0000,0x0000,
0x1594,0x0000,0x0000, 0x1595,0x0000,0x0000, 0x1596,0x0000,0x0000,
0x1599,0x0000,0x0000, 0x159A,0x0000,0x0000, 0x159B,0x0000,0x0000,
0x159C,0x0000,0x0000, 0x159D,0x0000,0x0000, 0x159E,0x0000,0x0000,
0x159F,0x0000,0x0000, 0x15A0,0x0000,0x0000, 0x15A1,0x0000,0x0000,
0xFBC0,0x894E,0x0000, 0xFBC0,0x894F,0x0000, 0x1559,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8955,0x0000, 0xFBC0,0x8956,0x0000,
0xFBC0,0x8957,0x0000, 0x156D,0x0000,0x0000, 0x156E,0x0000,0x0000,
0x156F,0x0000,0x0000, 0x1574,0x0000,0x0000, 0x1579,0x0000,0x0000,
0x157A,0x0000,0x0000, 0x1582,0x0000,0x0000, 0x1586,0x0000,0x0000,
0x1562,0x0000,0x0000, 0x1564,0x0000,0x0000, 0x1597,0x0000,0x0000,
0x1598,0x0000,0x0000, 0x0268,0x0000,0x0000, 0x0269,0x0000,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0x02FA,0x0000,0x0000, 0xFBC0,0x8971,0x0000,
0xFBC0,0x8972,0x0000, 0xFBC0,0x8973,0x0000, 0xFBC0,0x8974,0x0000,
0xFBC0,0x8975,0x0000, 0xFBC0,0x8976,0x0000, 0xFBC0,0x8977,0x0000,
0xFBC0,0x8978,0x0000, 0xFBC0,0x8979,0x0000, 0xFBC0,0x897A,0x0000,
0xFBC0,0x897B,0x0000, 0xFBC0,0x897C,0x0000, 0xFBC0,0x897D,0x0000,
0xFBC0,0x897E,0x0000, 0xFBC0,0x897F,0x0000, 0xFBC0,0x8980,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x8984,0x0000, 0x15A2,0x0000,0x0000, 0x15A3,0x0000,0x0000,
0x15A4,0x0000,0x0000, 0x15A5,0x0000,0x0000, 0x15A6,0x0000,0x0000,
0x15A7,0x0000,0x0000, 0x15A8,0x0000,0x0000, 0x15AA,0x0000,0x0000,
0xFBC0,0x898D,0x0000, 0xFBC0,0x898E,0x0000, 0x15AC,0x0000,0x0000,
0x15AD,0x0000,0x0000, 0xFBC0,0x8991,0x0000, 0xFBC0,0x8992,0x0000,
0x15AE,0x0000,0x0000, 0x15AF,0x0000,0x0000, 0x15B0,0x0000,0x0000,
0x15B1,0x0000,0x0000, 0x15B2,0x0000,0x0000, 0x15B3,0x0000,0x0000,
0x15B4,0x0000,0x0000, 0x15B5,0x0000,0x0000, 0x15B6,0x0000,0x0000,
0x15B7,0x0000,0x0000, 0x15B8,0x0000,0x0000, 0x15B9,0x0000,0x0000,
0x15BA,0x0000,0x0000, 0x15BB,0x0000,0x0000, 0x15BC,0x0000,0x0000,
0x15BD,0x0000,0x0000, 0x15BE,0x0000,0x0000, 0x15BF,0x0000,0x0000,
0x15C0,0x0000,0x0000, 0x15C1,0x0000,0x0000, 0x15C2,0x0000,0x0000,
0x15C3,0x0000,0x0000, 0xFBC0,0x89A9,0x0000, 0x15C4,0x0000,0x0000,
0x15C5,0x0000,0x0000, 0x15C6,0x0000,0x0000, 0x15C7,0x0000,0x0000,
0x15C8,0x0000,0x0000, 0x15C9,0x0000,0x0000, 0x15CA,0x0000,0x0000,
0xFBC0,0x89B1,0x0000, 0x15CC,0x0000,0x0000, 0xFBC0,0x89B3,0x0000,
0xFBC0,0x89B4,0x0000, 0xFBC0,0x89B5,0x0000, 0x15CE,0x0000,0x0000,
0x15CF,0x0000,0x0000, 0x15D0,0x0000,0x0000, 0x15D1,0x0000,0x0000,
0xFBC0,0x89BA,0x0000, 0xFBC0,0x89BB,0x0000, 0x0000,0x0000,0x0000,
0x15D2,0x0000,0x0000, 0x15D3,0x0000,0x0000, 0x15D4,0x0000,0x0000,
0x15D5,0x0000,0x0000, 0x15D6,0x0000,0x0000, 0x15D7,0x0000,0x0000,
0x15D8,0x0000,0x0000, 0x15D9,0x0000,0x0000, 0xFBC0,0x89C5,0x0000,
0xFBC0,0x89C6,0x0000, 0x15DC,0x0000,0x0000, 0x15DD,0x0000,0x0000,
0xFBC0,0x89C9,0x0000, 0xFBC0,0x89CA,0x0000, 0x15DE,0x0000,0x0000,
0x15DF,0x0000,0x0000, 0x15E0,0x0000,0x0000, 0xFBC0,0x89CE,0x0000,
0xFBC0,0x89CF,0x0000, 0xFBC0,0x89D0,0x0000, 0xFBC0,0x89D1,0x0000,
0xFBC0,0x89D2,0x0000, 0xFBC0,0x89D3,0x0000, 0xFBC0,0x89D4,0x0000,
0xFBC0,0x89D5,0x0000, 0xFBC0,0x89D6,0x0000, 0x15E1,0x0000,0x0000,
0xFBC0,0x89D8,0x0000, 0xFBC0,0x89D9,0x0000, 0xFBC0,0x89DA,0x0000,
0xFBC0,0x89DB,0x0000, 0x15BC,0x0000,0x0000, 0x15BD,0x0000,0x0000,
0xFBC0,0x89DE,0x0000, 0x15C9,0x0000,0x0000, 0x15A9,0x0000,0x0000,
0x15AB,0x0000,0x0000, 0x15DA,0x0000,0x0000, 0x15DB,0x0000,0x0000,
0xFBC0,0x89E4,0x0000, 0xFBC0,0x89E5,0x0000, 0x0E29,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x15CB,0x0000,0x0000, 0x15CD,0x0000,0x0000, 0x0E12,0x0000,0x0000,
0x0E13,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0DC7,0x0000,0x0000,
0x0DC8,0x0000,0x0000, 0x0350,0x0000,0x0000, 0xFBC0,0x89FB,0x0000,
0xFBC0,0x89FC,0x0000, 0xFBC0,0x89FD,0x0000, 0xFBC0,0x89FE,0x0000,
0xFBC0,0x89FF,0x0000 };

uint16 page00Adata[]= { /* 0A00 (3 weights per char) */
0xFBC0,0x8A00,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8A04,0x0000, 0x15E7,0x0000,0x0000,
0x15E8,0x0000,0x0000, 0x15EC,0x0000,0x0000, 0x15ED,0x0000,0x0000,
0x15E4,0x0000,0x0000, 0x15E5,0x0000,0x0000, 0xFBC0,0x8A0B,0x0000,
0xFBC0,0x8A0C,0x0000, 0xFBC0,0x8A0D,0x0000, 0xFBC0,0x8A0E,0x0000,
0x15EE,0x0000,0x0000, 0x15E9,0x0000,0x0000, 0xFBC0,0x8A11,0x0000,
0xFBC0,0x8A12,0x0000, 0x15E6,0x0000,0x0000, 0x15EA,0x0000,0x0000,
0x15F1,0x0000,0x0000, 0x15F2,0x0000,0x0000, 0x15F3,0x0000,0x0000,
0x15F4,0x0000,0x0000, 0x15F5,0x0000,0x0000, 0x15F6,0x0000,0x0000,
0x15F7,0x0000,0x0000, 0x15F8,0x0000,0x0000, 0x15F9,0x0000,0x0000,
0x15FA,0x0000,0x0000, 0x15FB,0x0000,0x0000, 0x15FC,0x0000,0x0000,
0x15FD,0x0000,0x0000, 0x15FE,0x0000,0x0000, 0x15FF,0x0000,0x0000,
0x1600,0x0000,0x0000, 0x1601,0x0000,0x0000, 0x1602,0x0000,0x0000,
0x1603,0x0000,0x0000, 0x1604,0x0000,0x0000, 0xFBC0,0x8A29,0x0000,
0x1605,0x0000,0x0000, 0x1606,0x0000,0x0000, 0x1607,0x0000,0x0000,
0x1608,0x0000,0x0000, 0x1609,0x0000,0x0000, 0x160A,0x0000,0x0000,
0x160B,0x0000,0x0000, 0xFBC0,0x8A31,0x0000, 0x160C,0x0000,0x0000,
0x160C,0x0000,0x0000, 0xFBC0,0x8A34,0x0000, 0x160D,0x0000,0x0000,
0x15EF,0x0000,0x0000, 0xFBC0,0x8A37,0x0000, 0x15EF,0x0000,0x0000,
0x15F0,0x0000,0x0000, 0xFBC0,0x8A3A,0x0000, 0xFBC0,0x8A3B,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8A3D,0x0000, 0x160F,0x0000,0x0000,
0x1610,0x0000,0x0000, 0x1611,0x0000,0x0000, 0x1612,0x0000,0x0000,
0x1613,0x0000,0x0000, 0xFBC0,0x8A43,0x0000, 0xFBC0,0x8A44,0x0000,
0xFBC0,0x8A45,0x0000, 0xFBC0,0x8A46,0x0000, 0x1614,0x0000,0x0000,
0x1615,0x0000,0x0000, 0xFBC0,0x8A49,0x0000, 0xFBC0,0x8A4A,0x0000,
0x1616,0x0000,0x0000, 0x1617,0x0000,0x0000, 0x1618,0x0000,0x0000,
0xFBC0,0x8A4E,0x0000, 0xFBC0,0x8A4F,0x0000, 0xFBC0,0x8A50,0x0000,
0xFBC0,0x8A51,0x0000, 0xFBC0,0x8A52,0x0000, 0xFBC0,0x8A53,0x0000,
0xFBC0,0x8A54,0x0000, 0xFBC0,0x8A55,0x0000, 0xFBC0,0x8A56,0x0000,
0xFBC0,0x8A57,0x0000, 0xFBC0,0x8A58,0x0000, 0x15F2,0x0000,0x0000,
0x15F3,0x0000,0x0000, 0x15F8,0x0000,0x0000, 0x160E,0x0000,0x0000,
0xFBC0,0x8A5D,0x0000, 0x1606,0x0000,0x0000, 0xFBC0,0x8A5F,0x0000,
0xFBC0,0x8A60,0x0000, 0xFBC0,0x8A61,0x0000, 0xFBC0,0x8A62,0x0000,
0xFBC0,0x8A63,0x0000, 0xFBC0,0x8A64,0x0000, 0xFBC0,0x8A65,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x15EB,0x0000,0x0000, 0x15E3,0x0000,0x0000, 0x15E2,0x0000,0x0000,
0xFBC0,0x8A75,0x0000, 0xFBC0,0x8A76,0x0000, 0xFBC0,0x8A77,0x0000,
0xFBC0,0x8A78,0x0000, 0xFBC0,0x8A79,0x0000, 0xFBC0,0x8A7A,0x0000,
0xFBC0,0x8A7B,0x0000, 0xFBC0,0x8A7C,0x0000, 0xFBC0,0x8A7D,0x0000,
0xFBC0,0x8A7E,0x0000, 0xFBC0,0x8A7F,0x0000, 0xFBC0,0x8A80,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x8A84,0x0000, 0x161A,0x0000,0x0000, 0x161B,0x0000,0x0000,
0x161C,0x0000,0x0000, 0x161D,0x0000,0x0000, 0x161E,0x0000,0x0000,
0x161F,0x0000,0x0000, 0x1620,0x0000,0x0000, 0x1622,0x0000,0x0000,
0x1624,0x0000,0x0000, 0xFBC0,0x8A8E,0x0000, 0x1625,0x0000,0x0000,
0x1626,0x0000,0x0000, 0x1627,0x0000,0x0000, 0xFBC0,0x8A92,0x0000,
0x1628,0x0000,0x0000, 0x1629,0x0000,0x0000, 0x162A,0x0000,0x0000,
0x162B,0x0000,0x0000, 0x162C,0x0000,0x0000, 0x162D,0x0000,0x0000,
0x162E,0x0000,0x0000, 0x162F,0x0000,0x0000, 0x1630,0x0000,0x0000,
0x1631,0x0000,0x0000, 0x1632,0x0000,0x0000, 0x1633,0x0000,0x0000,
0x1634,0x0000,0x0000, 0x1635,0x0000,0x0000, 0x1636,0x0000,0x0000,
0x1637,0x0000,0x0000, 0x1638,0x0000,0x0000, 0x1639,0x0000,0x0000,
0x163A,0x0000,0x0000, 0x163B,0x0000,0x0000, 0x163C,0x0000,0x0000,
0x163D,0x0000,0x0000, 0xFBC0,0x8AA9,0x0000, 0x163E,0x0000,0x0000,
0x163F,0x0000,0x0000, 0x1640,0x0000,0x0000, 0x1641,0x0000,0x0000,
0x1642,0x0000,0x0000, 0x1643,0x0000,0x0000, 0x1644,0x0000,0x0000,
0xFBC0,0x8AB1,0x0000, 0x1645,0x0000,0x0000, 0x1646,0x0000,0x0000,
0xFBC0,0x8AB4,0x0000, 0x1647,0x0000,0x0000, 0x1648,0x0000,0x0000,
0x1649,0x0000,0x0000, 0x164A,0x0000,0x0000, 0x164B,0x0000,0x0000,
0xFBC0,0x8ABA,0x0000, 0xFBC0,0x8ABB,0x0000, 0x0000,0x0000,0x0000,
0x164C,0x0000,0x0000, 0x164D,0x0000,0x0000, 0x164E,0x0000,0x0000,
0x164F,0x0000,0x0000, 0x1650,0x0000,0x0000, 0x1651,0x0000,0x0000,
0x1652,0x0000,0x0000, 0x1653,0x0000,0x0000, 0x1656,0x0000,0x0000,
0xFBC0,0x8AC6,0x0000, 0x1657,0x0000,0x0000, 0x1658,0x0000,0x0000,
0x1659,0x0000,0x0000, 0xFBC0,0x8ACA,0x0000, 0x165A,0x0000,0x0000,
0x165B,0x0000,0x0000, 0x165C,0x0000,0x0000, 0xFBC0,0x8ACE,0x0000,
0xFBC0,0x8ACF,0x0000, 0x1619,0x0000,0x0000, 0xFBC0,0x8AD1,0x0000,
0xFBC0,0x8AD2,0x0000, 0xFBC0,0x8AD3,0x0000, 0xFBC0,0x8AD4,0x0000,
0xFBC0,0x8AD5,0x0000, 0xFBC0,0x8AD6,0x0000, 0xFBC0,0x8AD7,0x0000,
0xFBC0,0x8AD8,0x0000, 0xFBC0,0x8AD9,0x0000, 0xFBC0,0x8ADA,0x0000,
0xFBC0,0x8ADB,0x0000, 0xFBC0,0x8ADC,0x0000, 0xFBC0,0x8ADD,0x0000,
0xFBC0,0x8ADE,0x0000, 0xFBC0,0x8ADF,0x0000, 0x1621,0x0000,0x0000,
0x1623,0x0000,0x0000, 0x1654,0x0000,0x0000, 0x1655,0x0000,0x0000,
0xFBC0,0x8AE4,0x0000, 0xFBC0,0x8AE5,0x0000, 0x0E29,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0xFBC0,0x8AF0,0x0000, 0x0E14,0x0000,0x0000, 0xFBC0,0x8AF2,0x0000,
0xFBC0,0x8AF3,0x0000, 0xFBC0,0x8AF4,0x0000, 0xFBC0,0x8AF5,0x0000,
0xFBC0,0x8AF6,0x0000, 0xFBC0,0x8AF7,0x0000, 0xFBC0,0x8AF8,0x0000,
0xFBC0,0x8AF9,0x0000, 0xFBC0,0x8AFA,0x0000, 0xFBC0,0x8AFB,0x0000,
0xFBC0,0x8AFC,0x0000, 0xFBC0,0x8AFD,0x0000, 0xFBC0,0x8AFE,0x0000,
0xFBC0,0x8AFF,0x0000 };

uint16 page00Bdata[]= { /* 0B00 (3 weights per char) */
0xFBC0,0x8B00,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8B04,0x0000, 0x165D,0x0000,0x0000,
0x165E,0x0000,0x0000, 0x165F,0x0000,0x0000, 0x1660,0x0000,0x0000,
0x1661,0x0000,0x0000, 0x1662,0x0000,0x0000, 0x1663,0x0000,0x0000,
0x1665,0x0000,0x0000, 0xFBC0,0x8B0D,0x0000, 0xFBC0,0x8B0E,0x0000,
0x1667,0x0000,0x0000, 0x1668,0x0000,0x0000, 0xFBC0,0x8B11,0x0000,
0xFBC0,0x8B12,0x0000, 0x1669,0x0000,0x0000, 0x166A,0x0000,0x0000,
0x166B,0x0000,0x0000, 0x166C,0x0000,0x0000, 0x166D,0x0000,0x0000,
0x166E,0x0000,0x0000, 0x166F,0x0000,0x0000, 0x1670,0x0000,0x0000,
0x1671,0x0000,0x0000, 0x1672,0x0000,0x0000, 0x1673,0x0000,0x0000,
0x1674,0x0000,0x0000, 0x1675,0x0000,0x0000, 0x1676,0x0000,0x0000,
0x1677,0x0000,0x0000, 0x1678,0x0000,0x0000, 0x1679,0x0000,0x0000,
0x167A,0x0000,0x0000, 0x167B,0x0000,0x0000, 0x167C,0x0000,0x0000,
0x167D,0x0000,0x0000, 0x167E,0x0000,0x0000, 0xFBC0,0x8B29,0x0000,
0x167F,0x0000,0x0000, 0x1680,0x0000,0x0000, 0x1681,0x0000,0x0000,
0x1682,0x0000,0x0000, 0x1683,0x0000,0x0000, 0x1684,0x0000,0x0000,
0x1686,0x0000,0x0000, 0xFBC0,0x8B31,0x0000, 0x1687,0x0000,0x0000,
0x1688,0x0000,0x0000, 0xFBC0,0x8B34,0x0000, 0x1689,0x0000,0x0000,
0x168B,0x0000,0x0000, 0x168C,0x0000,0x0000, 0x168D,0x0000,0x0000,
0x168E,0x0000,0x0000, 0xFBC0,0x8B3A,0x0000, 0xFBC0,0x8B3B,0x0000,
0x0000,0x0000,0x0000, 0x168F,0x0000,0x0000, 0x1690,0x0000,0x0000,
0x1691,0x0000,0x0000, 0x1692,0x0000,0x0000, 0x1693,0x0000,0x0000,
0x1694,0x0000,0x0000, 0x1695,0x0000,0x0000, 0xFBC0,0x8B44,0x0000,
0xFBC0,0x8B45,0x0000, 0xFBC0,0x8B46,0x0000, 0x1696,0x0000,0x0000,
0x1697,0x0000,0x0000, 0xFBC0,0x8B49,0x0000, 0xFBC0,0x8B4A,0x0000,
0x1698,0x0000,0x0000, 0x1699,0x0000,0x0000, 0x169A,0x0000,0x0000,
0xFBC0,0x8B4E,0x0000, 0xFBC0,0x8B4F,0x0000, 0xFBC0,0x8B50,0x0000,
0xFBC0,0x8B51,0x0000, 0xFBC0,0x8B52,0x0000, 0xFBC0,0x8B53,0x0000,
0xFBC0,0x8B54,0x0000, 0xFBC0,0x8B55,0x0000, 0x169B,0x0000,0x0000,
0x169C,0x0000,0x0000, 0xFBC0,0x8B58,0x0000, 0xFBC0,0x8B59,0x0000,
0xFBC0,0x8B5A,0x0000, 0xFBC0,0x8B5B,0x0000, 0x1677,0x0000,0x0000,
0x1678,0x0000,0x0000, 0xFBC0,0x8B5E,0x0000, 0x1685,0x0000,0x0000,
0x1664,0x0000,0x0000, 0x1666,0x0000,0x0000, 0xFBC0,0x8B62,0x0000,
0xFBC0,0x8B63,0x0000, 0xFBC0,0x8B64,0x0000, 0xFBC0,0x8B65,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0x0351,0x0000,0x0000, 0x168A,0x0000,0x0000,
0xFBC0,0x8B72,0x0000, 0xFBC0,0x8B73,0x0000, 0xFBC0,0x8B74,0x0000,
0xFBC0,0x8B75,0x0000, 0xFBC0,0x8B76,0x0000, 0xFBC0,0x8B77,0x0000,
0xFBC0,0x8B78,0x0000, 0xFBC0,0x8B79,0x0000, 0xFBC0,0x8B7A,0x0000,
0xFBC0,0x8B7B,0x0000, 0xFBC0,0x8B7C,0x0000, 0xFBC0,0x8B7D,0x0000,
0xFBC0,0x8B7E,0x0000, 0xFBC0,0x8B7F,0x0000, 0xFBC0,0x8B80,0x0000,
0xFBC0,0x8B81,0x0000, 0x0000,0x0000,0x0000, 0x169D,0x0000,0x0000,
0xFBC0,0x8B84,0x0000, 0x169E,0x0000,0x0000, 0x169F,0x0000,0x0000,
0x16A0,0x0000,0x0000, 0x16A1,0x0000,0x0000, 0x16A2,0x0000,0x0000,
0x16A3,0x0000,0x0000, 0xFBC0,0x8B8B,0x0000, 0xFBC0,0x8B8C,0x0000,
0xFBC0,0x8B8D,0x0000, 0x16A4,0x0000,0x0000, 0x16A5,0x0000,0x0000,
0x16A6,0x0000,0x0000, 0xFBC0,0x8B91,0x0000, 0x16A7,0x0000,0x0000,
0x16A8,0x0000,0x0000, 0x16A9,0x0000,0x0000, 0x16AA,0x0000,0x0000,
0xFBC0,0x8B96,0x0000, 0xFBC0,0x8B97,0x0000, 0xFBC0,0x8B98,0x0000,
0x16AB,0x0000,0x0000, 0x16AC,0x0000,0x0000, 0xFBC0,0x8B9B,0x0000,
0x16AD,0x0000,0x0000, 0xFBC0,0x8B9D,0x0000, 0x16AE,0x0000,0x0000,
0x16AF,0x0000,0x0000, 0xFBC0,0x8BA0,0x0000, 0xFBC0,0x8BA1,0x0000,
0xFBC0,0x8BA2,0x0000, 0x16B0,0x0000,0x0000, 0x16B1,0x0000,0x0000,
0xFBC0,0x8BA5,0x0000, 0xFBC0,0x8BA6,0x0000, 0xFBC0,0x8BA7,0x0000,
0x16B2,0x0000,0x0000, 0x16B3,0x0000,0x0000, 0x16B4,0x0000,0x0000,
0xFBC0,0x8BAB,0x0000, 0xFBC0,0x8BAC,0x0000, 0xFBC0,0x8BAD,0x0000,
0x16B5,0x0000,0x0000, 0x16B6,0x0000,0x0000, 0x16B7,0x0000,0x0000,
0x16B8,0x0000,0x0000, 0x16B9,0x0000,0x0000, 0x16BA,0x0000,0x0000,
0x16BB,0x0000,0x0000, 0x16BC,0x0000,0x0000, 0xFBC0,0x8BB6,0x0000,
0x16BD,0x0000,0x0000, 0x16BE,0x0000,0x0000, 0x16BF,0x0000,0x0000,
0xFBC0,0x8BBA,0x0000, 0xFBC0,0x8BBB,0x0000, 0xFBC0,0x8BBC,0x0000,
0xFBC0,0x8BBD,0x0000, 0x16C0,0x0000,0x0000, 0x16C1,0x0000,0x0000,
0x16C2,0x0000,0x0000, 0x16C3,0x0000,0x0000, 0x16C4,0x0000,0x0000,
0xFBC0,0x8BC3,0x0000, 0xFBC0,0x8BC4,0x0000, 0xFBC0,0x8BC5,0x0000,
0x16C5,0x0000,0x0000, 0x16C6,0x0000,0x0000, 0x16C7,0x0000,0x0000,
0xFBC0,0x8BC9,0x0000, 0x16C8,0x0000,0x0000, 0x16C9,0x0000,0x0000,
0x16CA,0x0000,0x0000, 0x16CB,0x0000,0x0000, 0xFBC0,0x8BCE,0x0000,
0xFBC0,0x8BCF,0x0000, 0xFBC0,0x8BD0,0x0000, 0xFBC0,0x8BD1,0x0000,
0xFBC0,0x8BD2,0x0000, 0xFBC0,0x8BD3,0x0000, 0xFBC0,0x8BD4,0x0000,
0xFBC0,0x8BD5,0x0000, 0xFBC0,0x8BD6,0x0000, 0x16CC,0x0000,0x0000,
0xFBC0,0x8BD8,0x0000, 0xFBC0,0x8BD9,0x0000, 0xFBC0,0x8BDA,0x0000,
0xFBC0,0x8BDB,0x0000, 0xFBC0,0x8BDC,0x0000, 0xFBC0,0x8BDD,0x0000,
0xFBC0,0x8BDE,0x0000, 0xFBC0,0x8BDF,0x0000, 0xFBC0,0x8BE0,0x0000,
0xFBC0,0x8BE1,0x0000, 0xFBC0,0x8BE2,0x0000, 0xFBC0,0x8BE3,0x0000,
0xFBC0,0x8BE4,0x0000, 0xFBC0,0x8BE5,0x0000, 0xFBC0,0x8BE6,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x0DC9,0x0000,0x0000, 0x0DCA,0x0000,0x0000, 0x0DCB,0x0000,0x0000,
0x0352,0x0000,0x0000, 0x0353,0x0000,0x0000, 0x0354,0x0000,0x0000,
0x0355,0x0000,0x0000, 0x0356,0x0000,0x0000, 0x0357,0x0000,0x0000,
0x0E15,0x0000,0x0000, 0x0358,0x0000,0x0000, 0xFBC0,0x8BFB,0x0000,
0xFBC0,0x8BFC,0x0000, 0xFBC0,0x8BFD,0x0000, 0xFBC0,0x8BFE,0x0000,
0xFBC0,0x8BFF,0x0000 };

uint16 page00Cdata[]= { /* 0C00 (3 weights per char) */
0xFBC0,0x8C00,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8C04,0x0000, 0x16CD,0x0000,0x0000,
0x16CE,0x0000,0x0000, 0x16CF,0x0000,0x0000, 0x16D0,0x0000,0x0000,
0x16D1,0x0000,0x0000, 0x16D2,0x0000,0x0000, 0x16D3,0x0000,0x0000,
0x16D5,0x0000,0x0000, 0xFBC0,0x8C0D,0x0000, 0x16D7,0x0000,0x0000,
0x16D8,0x0000,0x0000, 0x16D9,0x0000,0x0000, 0xFBC0,0x8C11,0x0000,
0x16DA,0x0000,0x0000, 0x16DB,0x0000,0x0000, 0x16DC,0x0000,0x0000,
0x16DD,0x0000,0x0000, 0x16DE,0x0000,0x0000, 0x16DF,0x0000,0x0000,
0x16E0,0x0000,0x0000, 0x16E1,0x0000,0x0000, 0x16E2,0x0000,0x0000,
0x16E3,0x0000,0x0000, 0x16E4,0x0000,0x0000, 0x16E5,0x0000,0x0000,
0x16E6,0x0000,0x0000, 0x16E7,0x0000,0x0000, 0x16E8,0x0000,0x0000,
0x16E9,0x0000,0x0000, 0x16EA,0x0000,0x0000, 0x16EB,0x0000,0x0000,
0x16EC,0x0000,0x0000, 0x16ED,0x0000,0x0000, 0x16EE,0x0000,0x0000,
0x16EF,0x0000,0x0000, 0x16F0,0x0000,0x0000, 0xFBC0,0x8C29,0x0000,
0x16F1,0x0000,0x0000, 0x16F2,0x0000,0x0000, 0x16F3,0x0000,0x0000,
0x16F4,0x0000,0x0000, 0x16F5,0x0000,0x0000, 0x16F6,0x0000,0x0000,
0x16F7,0x0000,0x0000, 0x16F8,0x0000,0x0000, 0x16F9,0x0000,0x0000,
0x16FA,0x0000,0x0000, 0xFBC0,0x8C34,0x0000, 0x16FB,0x0000,0x0000,
0x16FC,0x0000,0x0000, 0x16FD,0x0000,0x0000, 0x16FE,0x0000,0x0000,
0x16FF,0x0000,0x0000, 0xFBC0,0x8C3A,0x0000, 0xFBC0,0x8C3B,0x0000,
0xFBC0,0x8C3C,0x0000, 0xFBC0,0x8C3D,0x0000, 0x1700,0x0000,0x0000,
0x1701,0x0000,0x0000, 0x1702,0x0000,0x0000, 0x1703,0x0000,0x0000,
0x1704,0x0000,0x0000, 0x1705,0x0000,0x0000, 0x1706,0x0000,0x0000,
0xFBC0,0x8C45,0x0000, 0x1707,0x0000,0x0000, 0x1708,0x0000,0x0000,
0x1709,0x0000,0x0000, 0xFBC0,0x8C49,0x0000, 0x170A,0x0000,0x0000,
0x170B,0x0000,0x0000, 0x170C,0x0000,0x0000, 0x170D,0x0000,0x0000,
0xFBC0,0x8C4E,0x0000, 0xFBC0,0x8C4F,0x0000, 0xFBC0,0x8C50,0x0000,
0xFBC0,0x8C51,0x0000, 0xFBC0,0x8C52,0x0000, 0xFBC0,0x8C53,0x0000,
0xFBC0,0x8C54,0x0000, 0x170E,0x0000,0x0000, 0x170F,0x0000,0x0000,
0xFBC0,0x8C57,0x0000, 0xFBC0,0x8C58,0x0000, 0xFBC0,0x8C59,0x0000,
0xFBC0,0x8C5A,0x0000, 0xFBC0,0x8C5B,0x0000, 0xFBC0,0x8C5C,0x0000,
0xFBC0,0x8C5D,0x0000, 0xFBC0,0x8C5E,0x0000, 0xFBC0,0x8C5F,0x0000,
0x16D4,0x0000,0x0000, 0x16D6,0x0000,0x0000, 0xFBC0,0x8C62,0x0000,
0xFBC0,0x8C63,0x0000, 0xFBC0,0x8C64,0x0000, 0xFBC0,0x8C65,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0xFBC0,0x8C70,0x0000, 0xFBC0,0x8C71,0x0000,
0xFBC0,0x8C72,0x0000, 0xFBC0,0x8C73,0x0000, 0xFBC0,0x8C74,0x0000,
0xFBC0,0x8C75,0x0000, 0xFBC0,0x8C76,0x0000, 0xFBC0,0x8C77,0x0000,
0xFBC0,0x8C78,0x0000, 0xFBC0,0x8C79,0x0000, 0xFBC0,0x8C7A,0x0000,
0xFBC0,0x8C7B,0x0000, 0xFBC0,0x8C7C,0x0000, 0xFBC0,0x8C7D,0x0000,
0xFBC0,0x8C7E,0x0000, 0xFBC0,0x8C7F,0x0000, 0xFBC0,0x8C80,0x0000,
0xFBC0,0x8C81,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x8C84,0x0000, 0x1710,0x0000,0x0000, 0x1711,0x0000,0x0000,
0x1712,0x0000,0x0000, 0x1713,0x0000,0x0000, 0x1714,0x0000,0x0000,
0x1715,0x0000,0x0000, 0x1716,0x0000,0x0000, 0x1718,0x0000,0x0000,
0xFBC0,0x8C8D,0x0000, 0x171A,0x0000,0x0000, 0x171B,0x0000,0x0000,
0x171C,0x0000,0x0000, 0xFBC0,0x8C91,0x0000, 0x171D,0x0000,0x0000,
0x171E,0x0000,0x0000, 0x171F,0x0000,0x0000, 0x1720,0x0000,0x0000,
0x1721,0x0000,0x0000, 0x1722,0x0000,0x0000, 0x1723,0x0000,0x0000,
0x1724,0x0000,0x0000, 0x1725,0x0000,0x0000, 0x1726,0x0000,0x0000,
0x1727,0x0000,0x0000, 0x1728,0x0000,0x0000, 0x1729,0x0000,0x0000,
0x172A,0x0000,0x0000, 0x172B,0x0000,0x0000, 0x172C,0x0000,0x0000,
0x172D,0x0000,0x0000, 0x172E,0x0000,0x0000, 0x172F,0x0000,0x0000,
0x1730,0x0000,0x0000, 0x1731,0x0000,0x0000, 0x1732,0x0000,0x0000,
0x1733,0x0000,0x0000, 0xFBC0,0x8CA9,0x0000, 0x1734,0x0000,0x0000,
0x1735,0x0000,0x0000, 0x1736,0x0000,0x0000, 0x1737,0x0000,0x0000,
0x1738,0x0000,0x0000, 0x1739,0x0000,0x0000, 0x173A,0x0000,0x0000,
0x173B,0x0000,0x0000, 0x173C,0x0000,0x0000, 0x1743,0x0000,0x0000,
0xFBC0,0x8CB4,0x0000, 0x173D,0x0000,0x0000, 0x173E,0x0000,0x0000,
0x173F,0x0000,0x0000, 0x1740,0x0000,0x0000, 0x1741,0x0000,0x0000,
0xFBC0,0x8CBA,0x0000, 0xFBC0,0x8CBB,0x0000, 0x0000,0x0000,0x0000,
0x1742,0x0000,0x0000, 0x1745,0x0000,0x0000, 0x1746,0x0000,0x0000,
0x1747,0x0000,0x0000, 0x1748,0x0000,0x0000, 0x1749,0x0000,0x0000,
0x174A,0x0000,0x0000, 0x174B,0x0000,0x0000, 0xFBC0,0x8CC5,0x0000,
0x174C,0x0000,0x0000, 0x174D,0x0000,0x0000, 0x174E,0x0000,0x0000,
0xFBC0,0x8CC9,0x0000, 0x174F,0x0000,0x0000, 0x1750,0x0000,0x0000,
0x1751,0x0000,0x0000, 0x1752,0x0000,0x0000, 0xFBC0,0x8CCE,0x0000,
0xFBC0,0x8CCF,0x0000, 0xFBC0,0x8CD0,0x0000, 0xFBC0,0x8CD1,0x0000,
0xFBC0,0x8CD2,0x0000, 0xFBC0,0x8CD3,0x0000, 0xFBC0,0x8CD4,0x0000,
0x1753,0x0000,0x0000, 0x1754,0x0000,0x0000, 0xFBC0,0x8CD7,0x0000,
0xFBC0,0x8CD8,0x0000, 0xFBC0,0x8CD9,0x0000, 0xFBC0,0x8CDA,0x0000,
0xFBC0,0x8CDB,0x0000, 0xFBC0,0x8CDC,0x0000, 0xFBC0,0x8CDD,0x0000,
0x1744,0x0000,0x0000, 0xFBC0,0x8CDF,0x0000, 0x1717,0x0000,0x0000,
0x1719,0x0000,0x0000, 0xFBC0,0x8CE2,0x0000, 0xFBC0,0x8CE3,0x0000,
0xFBC0,0x8CE4,0x0000, 0xFBC0,0x8CE5,0x0000, 0x0E29,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0xFBC0,0x8CF0,0x0000, 0xFBC0,0x8CF1,0x0000, 0xFBC0,0x8CF2,0x0000,
0xFBC0,0x8CF3,0x0000, 0xFBC0,0x8CF4,0x0000, 0xFBC0,0x8CF5,0x0000,
0xFBC0,0x8CF6,0x0000, 0xFBC0,0x8CF7,0x0000, 0xFBC0,0x8CF8,0x0000,
0xFBC0,0x8CF9,0x0000, 0xFBC0,0x8CFA,0x0000, 0xFBC0,0x8CFB,0x0000,
0xFBC0,0x8CFC,0x0000, 0xFBC0,0x8CFD,0x0000, 0xFBC0,0x8CFE,0x0000,
0xFBC0,0x8CFF,0x0000 };

uint16 page00Ddata[]= { /* 0D00 (3 weights per char) */
0xFBC0,0x8D00,0x0000, 0xFBC0,0x8D01,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8D04,0x0000, 0x1755,0x0000,0x0000,
0x1756,0x0000,0x0000, 0x1757,0x0000,0x0000, 0x1758,0x0000,0x0000,
0x1759,0x0000,0x0000, 0x175A,0x0000,0x0000, 0x175B,0x0000,0x0000,
0x175D,0x0000,0x0000, 0xFBC0,0x8D0D,0x0000, 0x175F,0x0000,0x0000,
0x1760,0x0000,0x0000, 0x1761,0x0000,0x0000, 0xFBC0,0x8D11,0x0000,
0x1762,0x0000,0x0000, 0x1763,0x0000,0x0000, 0x1764,0x0000,0x0000,
0x1765,0x0000,0x0000, 0x1766,0x0000,0x0000, 0x1767,0x0000,0x0000,
0x1768,0x0000,0x0000, 0x1769,0x0000,0x0000, 0x176A,0x0000,0x0000,
0x176B,0x0000,0x0000, 0x176C,0x0000,0x0000, 0x176D,0x0000,0x0000,
0x176E,0x0000,0x0000, 0x176F,0x0000,0x0000, 0x1770,0x0000,0x0000,
0x1771,0x0000,0x0000, 0x1772,0x0000,0x0000, 0x1773,0x0000,0x0000,
0x1774,0x0000,0x0000, 0x1775,0x0000,0x0000, 0x1776,0x0000,0x0000,
0x1777,0x0000,0x0000, 0x1778,0x0000,0x0000, 0xFBC0,0x8D29,0x0000,
0x1779,0x0000,0x0000, 0x177A,0x0000,0x0000, 0x177B,0x0000,0x0000,
0x177C,0x0000,0x0000, 0x177D,0x0000,0x0000, 0x177E,0x0000,0x0000,
0x177F,0x0000,0x0000, 0x1780,0x0000,0x0000, 0x1781,0x0000,0x0000,
0x1782,0x0000,0x0000, 0x1783,0x0000,0x0000, 0x1784,0x0000,0x0000,
0x1785,0x0000,0x0000, 0x1786,0x0000,0x0000, 0x1787,0x0000,0x0000,
0x1788,0x0000,0x0000, 0xFBC0,0x8D3A,0x0000, 0xFBC0,0x8D3B,0x0000,
0xFBC0,0x8D3C,0x0000, 0xFBC0,0x8D3D,0x0000, 0x1789,0x0000,0x0000,
0x178A,0x0000,0x0000, 0x178B,0x0000,0x0000, 0x178C,0x0000,0x0000,
0x178D,0x0000,0x0000, 0x178E,0x0000,0x0000, 0xFBC0,0x8D44,0x0000,
0xFBC0,0x8D45,0x0000, 0x178F,0x0000,0x0000, 0x1790,0x0000,0x0000,
0x1791,0x0000,0x0000, 0xFBC0,0x8D49,0x0000, 0x1792,0x0000,0x0000,
0x1793,0x0000,0x0000, 0x1794,0x0000,0x0000, 0x1795,0x0000,0x0000,
0xFBC0,0x8D4E,0x0000, 0xFBC0,0x8D4F,0x0000, 0xFBC0,0x8D50,0x0000,
0xFBC0,0x8D51,0x0000, 0xFBC0,0x8D52,0x0000, 0xFBC0,0x8D53,0x0000,
0xFBC0,0x8D54,0x0000, 0xFBC0,0x8D55,0x0000, 0xFBC0,0x8D56,0x0000,
0x1796,0x0000,0x0000, 0xFBC0,0x8D58,0x0000, 0xFBC0,0x8D59,0x0000,
0xFBC0,0x8D5A,0x0000, 0xFBC0,0x8D5B,0x0000, 0xFBC0,0x8D5C,0x0000,
0xFBC0,0x8D5D,0x0000, 0xFBC0,0x8D5E,0x0000, 0xFBC0,0x8D5F,0x0000,
0x175C,0x0000,0x0000, 0x175E,0x0000,0x0000, 0xFBC0,0x8D62,0x0000,
0xFBC0,0x8D63,0x0000, 0xFBC0,0x8D64,0x0000, 0xFBC0,0x8D65,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0xFBC0,0x8D70,0x0000, 0xFBC0,0x8D71,0x0000,
0xFBC0,0x8D72,0x0000, 0xFBC0,0x8D73,0x0000, 0xFBC0,0x8D74,0x0000,
0xFBC0,0x8D75,0x0000, 0xFBC0,0x8D76,0x0000, 0xFBC0,0x8D77,0x0000,
0xFBC0,0x8D78,0x0000, 0xFBC0,0x8D79,0x0000, 0xFBC0,0x8D7A,0x0000,
0xFBC0,0x8D7B,0x0000, 0xFBC0,0x8D7C,0x0000, 0xFBC0,0x8D7D,0x0000,
0xFBC0,0x8D7E,0x0000, 0xFBC0,0x8D7F,0x0000, 0xFBC0,0x8D80,0x0000,
0xFBC0,0x8D81,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x8D84,0x0000, 0x1797,0x0000,0x0000, 0x1798,0x0000,0x0000,
0x1799,0x0000,0x0000, 0x179A,0x0000,0x0000, 0x179B,0x0000,0x0000,
0x179C,0x0000,0x0000, 0x179D,0x0000,0x0000, 0x179E,0x0000,0x0000,
0x179F,0x0000,0x0000, 0x17A0,0x0000,0x0000, 0x17A1,0x0000,0x0000,
0x17A2,0x0000,0x0000, 0x17A3,0x0000,0x0000, 0x17A4,0x0000,0x0000,
0x17A5,0x0000,0x0000, 0x17A6,0x0000,0x0000, 0x17A7,0x0000,0x0000,
0x17A8,0x0000,0x0000, 0xFBC0,0x8D97,0x0000, 0xFBC0,0x8D98,0x0000,
0xFBC0,0x8D99,0x0000, 0x17A9,0x0000,0x0000, 0x17AA,0x0000,0x0000,
0x17AB,0x0000,0x0000, 0x17AC,0x0000,0x0000, 0x17AD,0x0000,0x0000,
0x17AE,0x0000,0x0000, 0x17AF,0x0000,0x0000, 0x17B0,0x0000,0x0000,
0x17B1,0x0000,0x0000, 0x17B2,0x0000,0x0000, 0x17B3,0x0000,0x0000,
0x17B4,0x0000,0x0000, 0x17B5,0x0000,0x0000, 0x17B6,0x0000,0x0000,
0x17B7,0x0000,0x0000, 0x17B8,0x0000,0x0000, 0x17B9,0x0000,0x0000,
0x17BA,0x0000,0x0000, 0x17BB,0x0000,0x0000, 0x17BC,0x0000,0x0000,
0x17BD,0x0000,0x0000, 0x17BE,0x0000,0x0000, 0x17BF,0x0000,0x0000,
0x17C0,0x0000,0x0000, 0xFBC0,0x8DB2,0x0000, 0x17C1,0x0000,0x0000,
0x17C2,0x0000,0x0000, 0x17C3,0x0000,0x0000, 0x17C4,0x0000,0x0000,
0x17C5,0x0000,0x0000, 0x17C6,0x0000,0x0000, 0x17C7,0x0000,0x0000,
0x17C8,0x0000,0x0000, 0x17C9,0x0000,0x0000, 0xFBC0,0x8DBC,0x0000,
0x17CA,0x0000,0x0000, 0xFBC0,0x8DBE,0x0000, 0xFBC0,0x8DBF,0x0000,
0x17CB,0x0000,0x0000, 0x17CC,0x0000,0x0000, 0x17CD,0x0000,0x0000,
0x17CE,0x0000,0x0000, 0x17CF,0x0000,0x0000, 0x17D0,0x0000,0x0000,
0x17D1,0x0000,0x0000, 0xFBC0,0x8DC7,0x0000, 0xFBC0,0x8DC8,0x0000,
0xFBC0,0x8DC9,0x0000, 0x17D2,0x0000,0x0000, 0xFBC0,0x8DCB,0x0000,
0xFBC0,0x8DCC,0x0000, 0xFBC0,0x8DCD,0x0000, 0xFBC0,0x8DCE,0x0000,
0x17D3,0x0000,0x0000, 0x17D4,0x0000,0x0000, 0x17D5,0x0000,0x0000,
0x17D6,0x0000,0x0000, 0x17D7,0x0000,0x0000, 0x17D8,0x0000,0x0000,
0xFBC0,0x8DD5,0x0000, 0x17D9,0x0000,0x0000, 0xFBC0,0x8DD7,0x0000,
0x17DA,0x0000,0x0000, 0x17DB,0x0000,0x0000, 0x17DC,0x0000,0x0000,
0x17DD,0x0000,0x0000, 0x17DE,0x0000,0x0000, 0x17DF,0x0000,0x0000,
0x17E0,0x0000,0x0000, 0x17E1,0x0000,0x0000, 0xFBC0,0x8DE0,0x0000,
0xFBC0,0x8DE1,0x0000, 0xFBC0,0x8DE2,0x0000, 0xFBC0,0x8DE3,0x0000,
0xFBC0,0x8DE4,0x0000, 0xFBC0,0x8DE5,0x0000, 0xFBC0,0x8DE6,0x0000,
0xFBC0,0x8DE7,0x0000, 0xFBC0,0x8DE8,0x0000, 0xFBC0,0x8DE9,0x0000,
0xFBC0,0x8DEA,0x0000, 0xFBC0,0x8DEB,0x0000, 0xFBC0,0x8DEC,0x0000,
0xFBC0,0x8DED,0x0000, 0xFBC0,0x8DEE,0x0000, 0xFBC0,0x8DEF,0x0000,
0xFBC0,0x8DF0,0x0000, 0xFBC0,0x8DF1,0x0000, 0x17E2,0x0000,0x0000,
0x17E3,0x0000,0x0000, 0x02FB,0x0000,0x0000, 0xFBC0,0x8DF5,0x0000,
0xFBC0,0x8DF6,0x0000, 0xFBC0,0x8DF7,0x0000, 0xFBC0,0x8DF8,0x0000,
0xFBC0,0x8DF9,0x0000, 0xFBC0,0x8DFA,0x0000, 0xFBC0,0x8DFB,0x0000,
0xFBC0,0x8DFC,0x0000, 0xFBC0,0x8DFD,0x0000, 0xFBC0,0x8DFE,0x0000,
0xFBC0,0x8DFF,0x0000 };

uint16 page00Edata[]= { /* 0E00 (3 weights per char) */
0xFBC0,0x8E00,0x0000, 0x17E4,0x0000,0x0000, 0x17E5,0x0000,0x0000,
0x17E6,0x0000,0x0000, 0x17E7,0x0000,0x0000, 0x17E8,0x0000,0x0000,
0x17E9,0x0000,0x0000, 0x17EA,0x0000,0x0000, 0x17EB,0x0000,0x0000,
0x17EC,0x0000,0x0000, 0x17ED,0x0000,0x0000, 0x17EE,0x0000,0x0000,
0x17EF,0x0000,0x0000, 0x17F0,0x0000,0x0000, 0x17F1,0x0000,0x0000,
0x17F2,0x0000,0x0000, 0x17F3,0x0000,0x0000, 0x17F4,0x0000,0x0000,
0x17F5,0x0000,0x0000, 0x17F6,0x0000,0x0000, 0x17F7,0x0000,0x0000,
0x17F8,0x0000,0x0000, 0x17F9,0x0000,0x0000, 0x17FA,0x0000,0x0000,
0x17FB,0x0000,0x0000, 0x17FC,0x0000,0x0000, 0x17FD,0x0000,0x0000,
0x17FE,0x0000,0x0000, 0x17FF,0x0000,0x0000, 0x1800,0x0000,0x0000,
0x1801,0x0000,0x0000, 0x1802,0x0000,0x0000, 0x1803,0x0000,0x0000,
0x1804,0x0000,0x0000, 0x1805,0x0000,0x0000, 0x1806,0x0000,0x0000,
0x1807,0x0000,0x0000, 0x1808,0x0000,0x0000, 0x1809,0x0000,0x0000,
0x180A,0x0000,0x0000, 0x180B,0x0000,0x0000, 0x180C,0x0000,0x0000,
0x180D,0x0000,0x0000, 0x180E,0x0000,0x0000, 0x180F,0x0000,0x0000,
0x1810,0x0000,0x0000, 0x1811,0x0000,0x0000, 0x1812,0x0000,0x0000,
0x1813,0x0000,0x0000, 0x1814,0x0000,0x0000, 0x1815,0x0000,0x0000,
0x1816,0x0000,0x0000, 0x1817,0x0000,0x0000, 0x1818,0x0000,0x0000,
0x1819,0x0000,0x0000, 0x181A,0x0000,0x0000, 0x181B,0x0000,0x0000,
0x181C,0x0000,0x0000, 0x181D,0x0000,0x0000, 0xFBC0,0x8E3B,0x0000,
0xFBC0,0x8E3C,0x0000, 0xFBC0,0x8E3D,0x0000, 0xFBC0,0x8E3E,0x0000,
0x0E16,0x0000,0x0000, 0x181E,0x0000,0x0000, 0x181F,0x0000,0x0000,
0x1820,0x0000,0x0000, 0x1821,0x0000,0x0000, 0x1822,0x0000,0x0000,
0x1823,0x0000,0x0000, 0x0E03,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x1824,0x0000,0x0000, 0x1825,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0359,0x0000,0x0000, 0x0E29,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x02FC,0x0000,0x0000, 0x02FD,0x0000,0x0000, 0xFBC0,0x8E5C,0x0000,
0xFBC0,0x8E5D,0x0000, 0xFBC0,0x8E5E,0x0000, 0xFBC0,0x8E5F,0x0000,
0xFBC0,0x8E60,0x0000, 0xFBC0,0x8E61,0x0000, 0xFBC0,0x8E62,0x0000,
0xFBC0,0x8E63,0x0000, 0xFBC0,0x8E64,0x0000, 0xFBC0,0x8E65,0x0000,
0xFBC0,0x8E66,0x0000, 0xFBC0,0x8E67,0x0000, 0xFBC0,0x8E68,0x0000,
0xFBC0,0x8E69,0x0000, 0xFBC0,0x8E6A,0x0000, 0xFBC0,0x8E6B,0x0000,
0xFBC0,0x8E6C,0x0000, 0xFBC0,0x8E6D,0x0000, 0xFBC0,0x8E6E,0x0000,
0xFBC0,0x8E6F,0x0000, 0xFBC0,0x8E70,0x0000, 0xFBC0,0x8E71,0x0000,
0xFBC0,0x8E72,0x0000, 0xFBC0,0x8E73,0x0000, 0xFBC0,0x8E74,0x0000,
0xFBC0,0x8E75,0x0000, 0xFBC0,0x8E76,0x0000, 0xFBC0,0x8E77,0x0000,
0xFBC0,0x8E78,0x0000, 0xFBC0,0x8E79,0x0000, 0xFBC0,0x8E7A,0x0000,
0xFBC0,0x8E7B,0x0000, 0xFBC0,0x8E7C,0x0000, 0xFBC0,0x8E7D,0x0000,
0xFBC0,0x8E7E,0x0000, 0xFBC0,0x8E7F,0x0000, 0xFBC0,0x8E80,0x0000,
0x1826,0x0000,0x0000, 0x1827,0x0000,0x0000, 0xFBC0,0x8E83,0x0000,
0x1828,0x0000,0x0000, 0xFBC0,0x8E85,0x0000, 0xFBC0,0x8E86,0x0000,
0x1829,0x0000,0x0000, 0x182A,0x0000,0x0000, 0xFBC0,0x8E89,0x0000,
0x182B,0x0000,0x0000, 0xFBC0,0x8E8B,0x0000, 0xFBC0,0x8E8C,0x0000,
0x182C,0x0000,0x0000, 0xFBC0,0x8E8E,0x0000, 0xFBC0,0x8E8F,0x0000,
0xFBC0,0x8E90,0x0000, 0xFBC0,0x8E91,0x0000, 0xFBC0,0x8E92,0x0000,
0xFBC0,0x8E93,0x0000, 0x182D,0x0000,0x0000, 0x182E,0x0000,0x0000,
0x182F,0x0000,0x0000, 0x1830,0x0000,0x0000, 0xFBC0,0x8E98,0x0000,
0x1831,0x0000,0x0000, 0x1832,0x0000,0x0000, 0x1833,0x0000,0x0000,
0x1834,0x0000,0x0000, 0x1835,0x0000,0x0000, 0x1836,0x0000,0x0000,
0x1837,0x0000,0x0000, 0xFBC0,0x8EA0,0x0000, 0x1838,0x0000,0x0000,
0x1839,0x0000,0x0000, 0x183A,0x0000,0x0000, 0xFBC0,0x8EA4,0x0000,
0x183B,0x0000,0x0000, 0xFBC0,0x8EA6,0x0000, 0x183C,0x0000,0x0000,
0xFBC0,0x8EA8,0x0000, 0xFBC0,0x8EA9,0x0000, 0x183D,0x0000,0x0000,
0x183E,0x0000,0x0000, 0xFBC0,0x8EAC,0x0000, 0x183F,0x0000,0x0000,
0x1840,0x0000,0x0000, 0x1841,0x0000,0x0000, 0x1842,0x0000,0x0000,
0x1843,0x0000,0x0000, 0x1844,0x0000,0x0000, 0x1845,0x0000,0x0000,
0x1846,0x0000,0x0000, 0x1847,0x0000,0x0000, 0x1848,0x0000,0x0000,
0x1849,0x0000,0x0000, 0x184A,0x0000,0x0000, 0x184B,0x0000,0x0000,
0xFBC0,0x8EBA,0x0000, 0x184C,0x0000,0x0000, 0x184D,0x0000,0x0000,
0x184E,0x0000,0x0000, 0xFBC0,0x8EBE,0x0000, 0xFBC0,0x8EBF,0x0000,
0x184F,0x0000,0x0000, 0x1850,0x0000,0x0000, 0x1851,0x0000,0x0000,
0x1852,0x0000,0x0000, 0x1853,0x0000,0x0000, 0xFBC0,0x8EC5,0x0000,
0x0E04,0x0000,0x0000, 0xFBC0,0x8EC7,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x1854,0x0000,0x0000, 0x1855,0x0000,0x0000, 0xFBC0,0x8ECE,0x0000,
0xFBC0,0x8ECF,0x0000, 0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000,
0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000,
0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000,
0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000, 0xFBC0,0x8EDA,0x0000,
0xFBC0,0x8EDB,0x0000, 0x183E,0x1831,0x0000, 0x183E,0x1838,0x0000,
0xFBC0,0x8EDE,0x0000, 0xFBC0,0x8EDF,0x0000, 0xFBC0,0x8EE0,0x0000,
0xFBC0,0x8EE1,0x0000, 0xFBC0,0x8EE2,0x0000, 0xFBC0,0x8EE3,0x0000,
0xFBC0,0x8EE4,0x0000, 0xFBC0,0x8EE5,0x0000, 0xFBC0,0x8EE6,0x0000,
0xFBC0,0x8EE7,0x0000, 0xFBC0,0x8EE8,0x0000, 0xFBC0,0x8EE9,0x0000,
0xFBC0,0x8EEA,0x0000, 0xFBC0,0x8EEB,0x0000, 0xFBC0,0x8EEC,0x0000,
0xFBC0,0x8EED,0x0000, 0xFBC0,0x8EEE,0x0000, 0xFBC0,0x8EEF,0x0000,
0xFBC0,0x8EF0,0x0000, 0xFBC0,0x8EF1,0x0000, 0xFBC0,0x8EF2,0x0000,
0xFBC0,0x8EF3,0x0000, 0xFBC0,0x8EF4,0x0000, 0xFBC0,0x8EF5,0x0000,
0xFBC0,0x8EF6,0x0000, 0xFBC0,0x8EF7,0x0000, 0xFBC0,0x8EF8,0x0000,
0xFBC0,0x8EF9,0x0000, 0xFBC0,0x8EFA,0x0000, 0xFBC0,0x8EFB,0x0000,
0xFBC0,0x8EFC,0x0000, 0xFBC0,0x8EFD,0x0000, 0xFBC0,0x8EFE,0x0000,
0xFBC0,0x8EFF,0x0000 };

uint16 page00Fdata[]= { /* 0F00 (3 weights per char) */
0x189A,0x18AD,0x0000, 0x035A,0x0000,0x0000, 0x035B,0x0000,0x0000,
0x035C,0x0000,0x0000, 0x02FE,0x0000,0x0000, 0x02FF,0x0000,0x0000,
0x0300,0x0000,0x0000, 0x0301,0x0000,0x0000, 0x0302,0x0000,0x0000,
0x0303,0x0000,0x0000, 0x0304,0x0000,0x0000, 0x0305,0x0000,0x0000,
0x0305,0x0000,0x0000, 0x0306,0x0000,0x0000, 0x0307,0x0000,0x0000,
0x0308,0x0000,0x0000, 0x0309,0x0000,0x0000, 0x030A,0x0000,0x0000,
0x030B,0x0000,0x0000, 0x035D,0x0000,0x0000, 0x024C,0x0000,0x0000,
0x035E,0x0000,0x0000, 0x035F,0x0000,0x0000, 0x0360,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0361,0x0000,0x0000,
0x0362,0x0000,0x0000, 0x0363,0x0000,0x0000, 0x0364,0x0000,0x0000,
0x0365,0x0000,0x0000, 0x0366,0x0000,0x0000, 0x0E29,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x0E29,0x0000,0x0000, 0x0367,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0368,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0369,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x028E,0x0000,0x0000, 0x028F,0x0000,0x0000,
0x0290,0x0000,0x0000, 0x0291,0x0000,0x0000, 0x036A,0x0000,0x0000,
0x036B,0x0000,0x0000, 0x1856,0x0000,0x0000, 0x1858,0x0000,0x0000,
0x185A,0x0000,0x0000, 0x185A,0x1899,0x0000, 0x185C,0x0000,0x0000,
0x185E,0x0000,0x0000, 0x1860,0x0000,0x0000, 0x1862,0x0000,0x0000,
0xFBC0,0x8F48,0x0000, 0x1864,0x0000,0x0000, 0x1866,0x0000,0x0000,
0x1868,0x0000,0x0000, 0x186A,0x0000,0x0000, 0x186A,0x1899,0x0000,
0x186C,0x0000,0x0000, 0x186E,0x0000,0x0000, 0x1870,0x0000,0x0000,
0x1872,0x0000,0x0000, 0x1872,0x1899,0x0000, 0x1874,0x0000,0x0000,
0x1876,0x0000,0x0000, 0x1878,0x0000,0x0000, 0x187A,0x0000,0x0000,
0x187A,0x1899,0x0000, 0x187C,0x0000,0x0000, 0x187E,0x0000,0x0000,
0x1880,0x0000,0x0000, 0x1882,0x0000,0x0000, 0x1882,0x1899,0x0000,
0x1884,0x0000,0x0000, 0x1886,0x0000,0x0000, 0x1888,0x0000,0x0000,
0x188A,0x0000,0x0000, 0x188C,0x0000,0x0000, 0x188E,0x0000,0x0000,
0x1890,0x0000,0x0000, 0x1892,0x0000,0x0000, 0x1894,0x0000,0x0000,
0x1896,0x0000,0x0000, 0x1898,0x0000,0x0000, 0x189A,0x0000,0x0000,
0x1856,0x1895,0x0000, 0x188E,0x0000,0x0000, 0xFBC0,0x8F6B,0x0000,
0xFBC0,0x8F6C,0x0000, 0xFBC0,0x8F6D,0x0000, 0xFBC0,0x8F6E,0x0000,
0xFBC0,0x8F6F,0x0000, 0xFBC0,0x8F70,0x0000, 0x18A0,0x0000,0x0000,
0x18A1,0x0000,0x0000, 0x18A2,0x0000,0x0000, 0x18A5,0x0000,0x0000,
0x18A6,0x0000,0x0000, 0x18A7,0x0000,0x0000, 0x18A8,0x0000,0x0000,
0x18A9,0x0000,0x0000, 0x18AA,0x0000,0x0000, 0x18AB,0x0000,0x0000,
0x18AC,0x0000,0x0000, 0x18AD,0x0000,0x0000, 0x18AE,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x18A3,0x0000,0x0000,
0x18A4,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x18AF,0x0000,0x0000, 0x030C,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x189C,0x0000,0x0000, 0x189D,0x0000,0x0000,
0x189E,0x0000,0x0000, 0x189F,0x0000,0x0000, 0xFBC0,0x8F8C,0x0000,
0xFBC0,0x8F8D,0x0000, 0xFBC0,0x8F8E,0x0000, 0xFBC0,0x8F8F,0x0000,
0x1857,0x0000,0x0000, 0x1859,0x0000,0x0000, 0x185B,0x0000,0x0000,
0x185B,0x1899,0x0000, 0x185D,0x0000,0x0000, 0x185F,0x0000,0x0000,
0x1861,0x0000,0x0000, 0x1863,0x0000,0x0000, 0xFBC0,0x8F98,0x0000,
0x1865,0x0000,0x0000, 0x1867,0x0000,0x0000, 0x1869,0x0000,0x0000,
0x186B,0x0000,0x0000, 0x186B,0x1899,0x0000, 0x186D,0x0000,0x0000,
0x186F,0x0000,0x0000, 0x1871,0x0000,0x0000, 0x1873,0x0000,0x0000,
0x1873,0x1899,0x0000, 0x1875,0x0000,0x0000, 0x1877,0x0000,0x0000,
0x1879,0x0000,0x0000, 0x187B,0x0000,0x0000, 0x187B,0x1899,0x0000,
0x187D,0x0000,0x0000, 0x187F,0x0000,0x0000, 0x1881,0x0000,0x0000,
0x1883,0x0000,0x0000, 0x1883,0x1899,0x0000, 0x1885,0x0000,0x0000,
0x1887,0x0000,0x0000, 0x1889,0x0000,0x0000, 0x188B,0x0000,0x0000,
0x188D,0x0000,0x0000, 0x188F,0x0000,0x0000, 0x1891,0x0000,0x0000,
0x1893,0x0000,0x0000, 0x1895,0x0000,0x0000, 0x1897,0x0000,0x0000,
0x1899,0x0000,0x0000, 0x189B,0x0000,0x0000, 0x1857,0x1895,0x0000,
0x1885,0x0000,0x0000, 0x188D,0x0000,0x0000, 0x188F,0x0000,0x0000,
0xFBC0,0x8FBD,0x0000, 0x036C,0x0000,0x0000, 0x036D,0x0000,0x0000,
0x036E,0x0000,0x0000, 0x036F,0x0000,0x0000, 0x0370,0x0000,0x0000,
0x0371,0x0000,0x0000, 0x0372,0x0000,0x0000, 0x0373,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0374,0x0000,0x0000, 0x0375,0x0000,0x0000,
0x0376,0x0000,0x0000, 0x0377,0x0000,0x0000, 0x0378,0x0000,0x0000,
0x0379,0x0000,0x0000, 0xFBC0,0x8FCD,0x0000, 0xFBC0,0x8FCE,0x0000,
0x037A,0x0000,0x0000, 0xFBC0,0x8FD0,0x0000, 0xFBC0,0x8FD1,0x0000,
0xFBC0,0x8FD2,0x0000, 0xFBC0,0x8FD3,0x0000, 0xFBC0,0x8FD4,0x0000,
0xFBC0,0x8FD5,0x0000, 0xFBC0,0x8FD6,0x0000, 0xFBC0,0x8FD7,0x0000,
0xFBC0,0x8FD8,0x0000, 0xFBC0,0x8FD9,0x0000, 0xFBC0,0x8FDA,0x0000,
0xFBC0,0x8FDB,0x0000, 0xFBC0,0x8FDC,0x0000, 0xFBC0,0x8FDD,0x0000,
0xFBC0,0x8FDE,0x0000, 0xFBC0,0x8FDF,0x0000, 0xFBC0,0x8FE0,0x0000,
0xFBC0,0x8FE1,0x0000, 0xFBC0,0x8FE2,0x0000, 0xFBC0,0x8FE3,0x0000,
0xFBC0,0x8FE4,0x0000, 0xFBC0,0x8FE5,0x0000, 0xFBC0,0x8FE6,0x0000,
0xFBC0,0x8FE7,0x0000, 0xFBC0,0x8FE8,0x0000, 0xFBC0,0x8FE9,0x0000,
0xFBC0,0x8FEA,0x0000, 0xFBC0,0x8FEB,0x0000, 0xFBC0,0x8FEC,0x0000,
0xFBC0,0x8FED,0x0000, 0xFBC0,0x8FEE,0x0000, 0xFBC0,0x8FEF,0x0000,
0xFBC0,0x8FF0,0x0000, 0xFBC0,0x8FF1,0x0000, 0xFBC0,0x8FF2,0x0000,
0xFBC0,0x8FF3,0x0000, 0xFBC0,0x8FF4,0x0000, 0xFBC0,0x8FF5,0x0000,
0xFBC0,0x8FF6,0x0000, 0xFBC0,0x8FF7,0x0000, 0xFBC0,0x8FF8,0x0000,
0xFBC0,0x8FF9,0x0000, 0xFBC0,0x8FFA,0x0000, 0xFBC0,0x8FFB,0x0000,
0xFBC0,0x8FFC,0x0000, 0xFBC0,0x8FFD,0x0000, 0xFBC0,0x8FFE,0x0000,
0xFBC0,0x8FFF,0x0000 };

uint16 page010data[]= { /* 1000 (3 weights per char) */
0x1931,0x0000,0x0000, 0x1932,0x0000,0x0000, 0x1933,0x0000,0x0000,
0x1934,0x0000,0x0000, 0x1935,0x0000,0x0000, 0x1936,0x0000,0x0000,
0x1937,0x0000,0x0000, 0x1938,0x0000,0x0000, 0x1939,0x0000,0x0000,
0x193A,0x0000,0x0000, 0x193B,0x0000,0x0000, 0x193C,0x0000,0x0000,
0x193D,0x0000,0x0000, 0x193E,0x0000,0x0000, 0x193F,0x0000,0x0000,
0x1940,0x0000,0x0000, 0x1941,0x0000,0x0000, 0x1942,0x0000,0x0000,
0x1943,0x0000,0x0000, 0x1944,0x0000,0x0000, 0x1945,0x0000,0x0000,
0x1946,0x0000,0x0000, 0x1947,0x0000,0x0000, 0x1948,0x0000,0x0000,
0x1949,0x0000,0x0000, 0x194A,0x0000,0x0000, 0x194B,0x0000,0x0000,
0x194C,0x0000,0x0000, 0x194D,0x0000,0x0000, 0x194E,0x0000,0x0000,
0x1951,0x0000,0x0000, 0x1952,0x0000,0x0000, 0x1953,0x0000,0x0000,
0x1954,0x0000,0x0000, 0xFBC0,0x9022,0x0000, 0x1955,0x0000,0x0000,
0x1956,0x0000,0x0000, 0x1957,0x0000,0x0000, 0x1958,0x0000,0x0000,
0x1959,0x0000,0x0000, 0xFBC0,0x9028,0x0000, 0x195A,0x0000,0x0000,
0x195B,0x0000,0x0000, 0xFBC0,0x902B,0x0000, 0x1960,0x0000,0x0000,
0x1961,0x0000,0x0000, 0x1962,0x0000,0x0000, 0x1963,0x0000,0x0000,
0x1964,0x0000,0x0000, 0x1965,0x0000,0x0000, 0x1966,0x0000,0x0000,
0xFBC0,0x9033,0x0000, 0xFBC0,0x9034,0x0000, 0xFBC0,0x9035,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x196B,0x0000,0x0000, 0xFBC0,0x903A,0x0000, 0xFBC0,0x903B,0x0000,
0xFBC0,0x903C,0x0000, 0xFBC0,0x903D,0x0000, 0xFBC0,0x903E,0x0000,
0xFBC0,0x903F,0x0000, 0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000,
0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000,
0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000,
0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000, 0x026C,0x0000,0x0000,
0x026D,0x0000,0x0000, 0x030E,0x0000,0x0000, 0x030F,0x0000,0x0000,
0x0310,0x0000,0x0000, 0x0311,0x0000,0x0000, 0x194F,0x0000,0x0000,
0x1950,0x0000,0x0000, 0x195C,0x0000,0x0000, 0x195D,0x0000,0x0000,
0x195E,0x0000,0x0000, 0x195F,0x0000,0x0000, 0x1967,0x0000,0x0000,
0x1968,0x0000,0x0000, 0x1969,0x0000,0x0000, 0x196A,0x0000,0x0000,
0xFBC0,0x905A,0x0000, 0xFBC0,0x905B,0x0000, 0xFBC0,0x905C,0x0000,
0xFBC0,0x905D,0x0000, 0xFBC0,0x905E,0x0000, 0xFBC0,0x905F,0x0000,
0xFBC0,0x9060,0x0000, 0xFBC0,0x9061,0x0000, 0xFBC0,0x9062,0x0000,
0xFBC0,0x9063,0x0000, 0xFBC0,0x9064,0x0000, 0xFBC0,0x9065,0x0000,
0xFBC0,0x9066,0x0000, 0xFBC0,0x9067,0x0000, 0xFBC0,0x9068,0x0000,
0xFBC0,0x9069,0x0000, 0xFBC0,0x906A,0x0000, 0xFBC0,0x906B,0x0000,
0xFBC0,0x906C,0x0000, 0xFBC0,0x906D,0x0000, 0xFBC0,0x906E,0x0000,
0xFBC0,0x906F,0x0000, 0xFBC0,0x9070,0x0000, 0xFBC0,0x9071,0x0000,
0xFBC0,0x9072,0x0000, 0xFBC0,0x9073,0x0000, 0xFBC0,0x9074,0x0000,
0xFBC0,0x9075,0x0000, 0xFBC0,0x9076,0x0000, 0xFBC0,0x9077,0x0000,
0xFBC0,0x9078,0x0000, 0xFBC0,0x9079,0x0000, 0xFBC0,0x907A,0x0000,
0xFBC0,0x907B,0x0000, 0xFBC0,0x907C,0x0000, 0xFBC0,0x907D,0x0000,
0xFBC0,0x907E,0x0000, 0xFBC0,0x907F,0x0000, 0xFBC0,0x9080,0x0000,
0xFBC0,0x9081,0x0000, 0xFBC0,0x9082,0x0000, 0xFBC0,0x9083,0x0000,
0xFBC0,0x9084,0x0000, 0xFBC0,0x9085,0x0000, 0xFBC0,0x9086,0x0000,
0xFBC0,0x9087,0x0000, 0xFBC0,0x9088,0x0000, 0xFBC0,0x9089,0x0000,
0xFBC0,0x908A,0x0000, 0xFBC0,0x908B,0x0000, 0xFBC0,0x908C,0x0000,
0xFBC0,0x908D,0x0000, 0xFBC0,0x908E,0x0000, 0xFBC0,0x908F,0x0000,
0xFBC0,0x9090,0x0000, 0xFBC0,0x9091,0x0000, 0xFBC0,0x9092,0x0000,
0xFBC0,0x9093,0x0000, 0xFBC0,0x9094,0x0000, 0xFBC0,0x9095,0x0000,
0xFBC0,0x9096,0x0000, 0xFBC0,0x9097,0x0000, 0xFBC0,0x9098,0x0000,
0xFBC0,0x9099,0x0000, 0xFBC0,0x909A,0x0000, 0xFBC0,0x909B,0x0000,
0xFBC0,0x909C,0x0000, 0xFBC0,0x909D,0x0000, 0xFBC0,0x909E,0x0000,
0xFBC0,0x909F,0x0000, 0x12E1,0x0000,0x0000, 0x12E2,0x0000,0x0000,
0x12E3,0x0000,0x0000, 0x12E4,0x0000,0x0000, 0x12E5,0x0000,0x0000,
0x12E6,0x0000,0x0000, 0x12E7,0x0000,0x0000, 0x12E9,0x0000,0x0000,
0x12EA,0x0000,0x0000, 0x12EB,0x0000,0x0000, 0x12EC,0x0000,0x0000,
0x12ED,0x0000,0x0000, 0x12EE,0x0000,0x0000, 0x12F0,0x0000,0x0000,
0x12F1,0x0000,0x0000, 0x12F2,0x0000,0x0000, 0x12F3,0x0000,0x0000,
0x12F4,0x0000,0x0000, 0x12F5,0x0000,0x0000, 0x12F7,0x0000,0x0000,
0x12F8,0x0000,0x0000, 0x12F9,0x0000,0x0000, 0x12FA,0x0000,0x0000,
0x12FB,0x0000,0x0000, 0x12FC,0x0000,0x0000, 0x12FD,0x0000,0x0000,
0x12FE,0x0000,0x0000, 0x12FF,0x0000,0x0000, 0x1300,0x0000,0x0000,
0x1301,0x0000,0x0000, 0x1302,0x0000,0x0000, 0x1304,0x0000,0x0000,
0x1305,0x0000,0x0000, 0x12E8,0x0000,0x0000, 0x12EF,0x0000,0x0000,
0x12F6,0x0000,0x0000, 0x1303,0x0000,0x0000, 0x1306,0x0000,0x0000,
0xFBC0,0x90C6,0x0000, 0xFBC0,0x90C7,0x0000, 0xFBC0,0x90C8,0x0000,
0xFBC0,0x90C9,0x0000, 0xFBC0,0x90CA,0x0000, 0xFBC0,0x90CB,0x0000,
0xFBC0,0x90CC,0x0000, 0xFBC0,0x90CD,0x0000, 0xFBC0,0x90CE,0x0000,
0xFBC0,0x90CF,0x0000, 0x12E1,0x0000,0x0000, 0x12E2,0x0000,0x0000,
0x12E3,0x0000,0x0000, 0x12E4,0x0000,0x0000, 0x12E5,0x0000,0x0000,
0x12E6,0x0000,0x0000, 0x12E7,0x0000,0x0000, 0x12E9,0x0000,0x0000,
0x12EA,0x0000,0x0000, 0x12EB,0x0000,0x0000, 0x12EC,0x0000,0x0000,
0x12ED,0x0000,0x0000, 0x12EE,0x0000,0x0000, 0x12F0,0x0000,0x0000,
0x12F1,0x0000,0x0000, 0x12F2,0x0000,0x0000, 0x12F3,0x0000,0x0000,
0x12F4,0x0000,0x0000, 0x12F5,0x0000,0x0000, 0x12F7,0x0000,0x0000,
0x12F8,0x0000,0x0000, 0x12F9,0x0000,0x0000, 0x12FA,0x0000,0x0000,
0x12FB,0x0000,0x0000, 0x12FC,0x0000,0x0000, 0x12FD,0x0000,0x0000,
0x12FE,0x0000,0x0000, 0x12FF,0x0000,0x0000, 0x1300,0x0000,0x0000,
0x1301,0x0000,0x0000, 0x1302,0x0000,0x0000, 0x1304,0x0000,0x0000,
0x1305,0x0000,0x0000, 0x12E8,0x0000,0x0000, 0x12EF,0x0000,0x0000,
0x12F6,0x0000,0x0000, 0x1303,0x0000,0x0000, 0x1306,0x0000,0x0000,
0x1307,0x0000,0x0000, 0x1308,0x0000,0x0000, 0x1309,0x0000,0x0000,
0xFBC0,0x90F9,0x0000, 0xFBC0,0x90FA,0x0000, 0x0271,0x0000,0x0000,
0xFBC0,0x90FC,0x0000, 0xFBC0,0x90FD,0x0000, 0xFBC0,0x90FE,0x0000,
0xFBC0,0x90FF,0x0000 };

uint16 page011data[]= { /* 1100 (3 weights per char) */
0x1D62,0x0000,0x0000, 0x1D63,0x0000,0x0000, 0x1D64,0x0000,0x0000,
0x1D65,0x0000,0x0000, 0x1D66,0x0000,0x0000, 0x1D67,0x0000,0x0000,
0x1D68,0x0000,0x0000, 0x1D69,0x0000,0x0000, 0x1D6A,0x0000,0x0000,
0x1D6B,0x0000,0x0000, 0x1D6C,0x0000,0x0000, 0x1D6D,0x0000,0x0000,
0x1D6E,0x0000,0x0000, 0x1D6F,0x0000,0x0000, 0x1D70,0x0000,0x0000,
0x1D71,0x0000,0x0000, 0x1D72,0x0000,0x0000, 0x1D73,0x0000,0x0000,
0x1D74,0x0000,0x0000, 0x1D75,0x0000,0x0000, 0x1D76,0x0000,0x0000,
0x1D77,0x0000,0x0000, 0x1D78,0x0000,0x0000, 0x1D79,0x0000,0x0000,
0x1D7A,0x0000,0x0000, 0x1D7B,0x0000,0x0000, 0x1D7C,0x0000,0x0000,
0x1D7D,0x0000,0x0000, 0x1D7E,0x0000,0x0000, 0x1D7F,0x0000,0x0000,
0x1D80,0x0000,0x0000, 0x1D81,0x0000,0x0000, 0x1D82,0x0000,0x0000,
0x1D83,0x0000,0x0000, 0x1D84,0x0000,0x0000, 0x1D85,0x0000,0x0000,
0x1D86,0x0000,0x0000, 0x1D87,0x0000,0x0000, 0x1D88,0x0000,0x0000,
0x1D89,0x0000,0x0000, 0x1D8A,0x0000,0x0000, 0x1D8B,0x0000,0x0000,
0x1D8C,0x0000,0x0000, 0x1D8D,0x0000,0x0000, 0x1D8E,0x0000,0x0000,
0x1D8F,0x0000,0x0000, 0x1D90,0x0000,0x0000, 0x1D91,0x0000,0x0000,
0x1D92,0x0000,0x0000, 0x1D93,0x0000,0x0000, 0x1D94,0x0000,0x0000,
0x1D95,0x0000,0x0000, 0x1D96,0x0000,0x0000, 0x1D97,0x0000,0x0000,
0x1D98,0x0000,0x0000, 0x1D99,0x0000,0x0000, 0x1D9A,0x0000,0x0000,
0x1D9B,0x0000,0x0000, 0x1D9C,0x0000,0x0000, 0x1D9D,0x0000,0x0000,
0x1D9E,0x0000,0x0000, 0x1D9F,0x0000,0x0000, 0x1DA0,0x0000,0x0000,
0x1DA1,0x0000,0x0000, 0x1DA2,0x0000,0x0000, 0x1DA3,0x0000,0x0000,
0x1DA4,0x0000,0x0000, 0x1DA5,0x0000,0x0000, 0x1DA6,0x0000,0x0000,
0x1DA7,0x0000,0x0000, 0x1DA8,0x0000,0x0000, 0x1DA9,0x0000,0x0000,
0x1DAA,0x0000,0x0000, 0x1DAB,0x0000,0x0000, 0x1DAC,0x0000,0x0000,
0x1DAD,0x0000,0x0000, 0x1DAE,0x0000,0x0000, 0x1DAF,0x0000,0x0000,
0x1DB0,0x0000,0x0000, 0x1DB1,0x0000,0x0000, 0x1DB2,0x0000,0x0000,
0x1DB3,0x0000,0x0000, 0x1DB4,0x0000,0x0000, 0x1DB5,0x0000,0x0000,
0x1DB6,0x0000,0x0000, 0x1DB7,0x0000,0x0000, 0x1DB8,0x0000,0x0000,
0x1DB9,0x0000,0x0000, 0x1DBA,0x0000,0x0000, 0x1DBB,0x0000,0x0000,
0xFBC0,0x915A,0x0000, 0xFBC0,0x915B,0x0000, 0xFBC0,0x915C,0x0000,
0xFBC0,0x915D,0x0000, 0xFBC0,0x915E,0x0000, 0x1DBC,0x0000,0x0000,
0x1DBD,0x0000,0x0000, 0x1DBE,0x0000,0x0000, 0x1DBF,0x0000,0x0000,
0x1DC0,0x0000,0x0000, 0x1DC1,0x0000,0x0000, 0x1DC2,0x0000,0x0000,
0x1DC3,0x0000,0x0000, 0x1DC4,0x0000,0x0000, 0x1DC5,0x0000,0x0000,
0x1DC6,0x0000,0x0000, 0x1DC7,0x0000,0x0000, 0x1DC8,0x0000,0x0000,
0x1DC9,0x0000,0x0000, 0x1DCA,0x0000,0x0000, 0x1DCB,0x0000,0x0000,
0x1DCC,0x0000,0x0000, 0x1DCD,0x0000,0x0000, 0x1DCE,0x0000,0x0000,
0x1DCF,0x0000,0x0000, 0x1DD0,0x0000,0x0000, 0x1DD1,0x0000,0x0000,
0x1DD2,0x0000,0x0000, 0x1DD3,0x0000,0x0000, 0x1DD4,0x0000,0x0000,
0x1DD5,0x0000,0x0000, 0x1DD6,0x0000,0x0000, 0x1DD7,0x0000,0x0000,
0x1DD8,0x0000,0x0000, 0x1DD9,0x0000,0x0000, 0x1DDA,0x0000,0x0000,
0x1DDB,0x0000,0x0000, 0x1DDC,0x0000,0x0000, 0x1DDD,0x0000,0x0000,
0x1DDE,0x0000,0x0000, 0x1DDF,0x0000,0x0000, 0x1DE0,0x0000,0x0000,
0x1DE1,0x0000,0x0000, 0x1DE2,0x0000,0x0000, 0x1DE3,0x0000,0x0000,
0x1DE4,0x0000,0x0000, 0x1DE5,0x0000,0x0000, 0x1DE6,0x0000,0x0000,
0x1DE7,0x0000,0x0000, 0x1DE8,0x0000,0x0000, 0x1DE9,0x0000,0x0000,
0x1DEA,0x0000,0x0000, 0x1DEB,0x0000,0x0000, 0x1DEC,0x0000,0x0000,
0x1DED,0x0000,0x0000, 0x1DEE,0x0000,0x0000, 0x1DEF,0x0000,0x0000,
0x1DF0,0x0000,0x0000, 0x1DF1,0x0000,0x0000, 0x1DF2,0x0000,0x0000,
0x1DF3,0x0000,0x0000, 0x1DF4,0x0000,0x0000, 0x1DF5,0x0000,0x0000,
0x1DF6,0x0000,0x0000, 0x1DF7,0x0000,0x0000, 0x1DF8,0x0000,0x0000,
0x1DF9,0x0000,0x0000, 0x1DFA,0x0000,0x0000, 0x1DFB,0x0000,0x0000,
0x1DFC,0x0000,0x0000, 0x1DFD,0x0000,0x0000, 0x1DFE,0x0000,0x0000,
0x1DFF,0x0000,0x0000, 0xFBC0,0x91A3,0x0000, 0xFBC0,0x91A4,0x0000,
0xFBC0,0x91A5,0x0000, 0xFBC0,0x91A6,0x0000, 0xFBC0,0x91A7,0x0000,
0x1E00,0x0000,0x0000, 0x1E01,0x0000,0x0000, 0x1E02,0x0000,0x0000,
0x1E03,0x0000,0x0000, 0x1E04,0x0000,0x0000, 0x1E05,0x0000,0x0000,
0x1E06,0x0000,0x0000, 0x1E07,0x0000,0x0000, 0x1E08,0x0000,0x0000,
0x1E09,0x0000,0x0000, 0x1E0A,0x0000,0x0000, 0x1E0B,0x0000,0x0000,
0x1E0C,0x0000,0x0000, 0x1E0D,0x0000,0x0000, 0x1E0E,0x0000,0x0000,
0x1E0F,0x0000,0x0000, 0x1E10,0x0000,0x0000, 0x1E11,0x0000,0x0000,
0x1E12,0x0000,0x0000, 0x1E13,0x0000,0x0000, 0x1E14,0x0000,0x0000,
0x1E15,0x0000,0x0000, 0x1E16,0x0000,0x0000, 0x1E17,0x0000,0x0000,
0x1E18,0x0000,0x0000, 0x1E19,0x0000,0x0000, 0x1E1A,0x0000,0x0000,
0x1E1B,0x0000,0x0000, 0x1E1C,0x0000,0x0000, 0x1E1D,0x0000,0x0000,
0x1E1E,0x0000,0x0000, 0x1E1F,0x0000,0x0000, 0x1E20,0x0000,0x0000,
0x1E21,0x0000,0x0000, 0x1E22,0x0000,0x0000, 0x1E23,0x0000,0x0000,
0x1E24,0x0000,0x0000, 0x1E25,0x0000,0x0000, 0x1E26,0x0000,0x0000,
0x1E27,0x0000,0x0000, 0x1E28,0x0000,0x0000, 0x1E29,0x0000,0x0000,
0x1E2A,0x0000,0x0000, 0x1E2B,0x0000,0x0000, 0x1E2C,0x0000,0x0000,
0x1E2D,0x0000,0x0000, 0x1E2E,0x0000,0x0000, 0x1E2F,0x0000,0x0000,
0x1E30,0x0000,0x0000, 0x1E31,0x0000,0x0000, 0x1E32,0x0000,0x0000,
0x1E33,0x0000,0x0000, 0x1E34,0x0000,0x0000, 0x1E35,0x0000,0x0000,
0x1E36,0x0000,0x0000, 0x1E37,0x0000,0x0000, 0x1E38,0x0000,0x0000,
0x1E39,0x0000,0x0000, 0x1E3A,0x0000,0x0000, 0x1E3B,0x0000,0x0000,
0x1E3C,0x0000,0x0000, 0x1E3D,0x0000,0x0000, 0x1E3E,0x0000,0x0000,
0x1E3F,0x0000,0x0000, 0x1E40,0x0000,0x0000, 0x1E41,0x0000,0x0000,
0x1E42,0x0000,0x0000, 0x1E43,0x0000,0x0000, 0x1E44,0x0000,0x0000,
0x1E45,0x0000,0x0000, 0x1E46,0x0000,0x0000, 0x1E47,0x0000,0x0000,
0x1E48,0x0000,0x0000, 0x1E49,0x0000,0x0000, 0x1E4A,0x0000,0x0000,
0x1E4B,0x0000,0x0000, 0x1E4C,0x0000,0x0000, 0x1E4D,0x0000,0x0000,
0x1E4E,0x0000,0x0000, 0x1E4F,0x0000,0x0000, 0x1E50,0x0000,0x0000,
0x1E51,0x0000,0x0000, 0xFBC0,0x91FA,0x0000, 0xFBC0,0x91FB,0x0000,
0xFBC0,0x91FC,0x0000, 0xFBC0,0x91FD,0x0000, 0xFBC0,0x91FE,0x0000,
0xFBC0,0x91FF,0x0000 };

uint16 page012data[]= { /* 1200 (3 weights per char) */
0x141C,0x0000,0x0000, 0x141D,0x0000,0x0000, 0x141E,0x0000,0x0000,
0x141F,0x0000,0x0000, 0x1420,0x0000,0x0000, 0x1421,0x0000,0x0000,
0x1422,0x0000,0x0000, 0xFBC0,0x9207,0x0000, 0x1423,0x0000,0x0000,
0x1424,0x0000,0x0000, 0x1425,0x0000,0x0000, 0x1426,0x0000,0x0000,
0x1427,0x0000,0x0000, 0x1428,0x0000,0x0000, 0x1429,0x0000,0x0000,
0x142A,0x0000,0x0000, 0x142B,0x0000,0x0000, 0x142C,0x0000,0x0000,
0x142D,0x0000,0x0000, 0x142E,0x0000,0x0000, 0x142F,0x0000,0x0000,
0x1430,0x0000,0x0000, 0x1431,0x0000,0x0000, 0x1432,0x0000,0x0000,
0x1433,0x0000,0x0000, 0x1434,0x0000,0x0000, 0x1435,0x0000,0x0000,
0x1436,0x0000,0x0000, 0x1437,0x0000,0x0000, 0x1438,0x0000,0x0000,
0x1439,0x0000,0x0000, 0x143A,0x0000,0x0000, 0x143B,0x0000,0x0000,
0x143C,0x0000,0x0000, 0x143D,0x0000,0x0000, 0x143E,0x0000,0x0000,
0x143F,0x0000,0x0000, 0x1440,0x0000,0x0000, 0x1441,0x0000,0x0000,
0x1442,0x0000,0x0000, 0x1443,0x0000,0x0000, 0x1444,0x0000,0x0000,
0x1445,0x0000,0x0000, 0x1446,0x0000,0x0000, 0x1447,0x0000,0x0000,
0x1448,0x0000,0x0000, 0x1449,0x0000,0x0000, 0x144A,0x0000,0x0000,
0x144B,0x0000,0x0000, 0x144C,0x0000,0x0000, 0x144D,0x0000,0x0000,
0x144E,0x0000,0x0000, 0x144F,0x0000,0x0000, 0x1450,0x0000,0x0000,
0x1451,0x0000,0x0000, 0x1452,0x0000,0x0000, 0x1453,0x0000,0x0000,
0x1454,0x0000,0x0000, 0x1455,0x0000,0x0000, 0x1456,0x0000,0x0000,
0x1457,0x0000,0x0000, 0x1458,0x0000,0x0000, 0x1459,0x0000,0x0000,
0x145A,0x0000,0x0000, 0x145B,0x0000,0x0000, 0x145C,0x0000,0x0000,
0x145D,0x0000,0x0000, 0x145E,0x0000,0x0000, 0x145F,0x0000,0x0000,
0x1460,0x0000,0x0000, 0x1461,0x0000,0x0000, 0xFBC0,0x9247,0x0000,
0x1462,0x0000,0x0000, 0xFBC0,0x9249,0x0000, 0x1463,0x0000,0x0000,
0x1464,0x0000,0x0000, 0x1465,0x0000,0x0000, 0x1466,0x0000,0x0000,
0xFBC0,0x924E,0x0000, 0xFBC0,0x924F,0x0000, 0x1467,0x0000,0x0000,
0x1468,0x0000,0x0000, 0x1469,0x0000,0x0000, 0x146A,0x0000,0x0000,
0x146B,0x0000,0x0000, 0x146C,0x0000,0x0000, 0x146D,0x0000,0x0000,
0xFBC0,0x9257,0x0000, 0x146E,0x0000,0x0000, 0xFBC0,0x9259,0x0000,
0x146F,0x0000,0x0000, 0x1470,0x0000,0x0000, 0x1471,0x0000,0x0000,
0x1472,0x0000,0x0000, 0xFBC0,0x925E,0x0000, 0xFBC0,0x925F,0x0000,
0x1473,0x0000,0x0000, 0x1474,0x0000,0x0000, 0x1475,0x0000,0x0000,
0x1476,0x0000,0x0000, 0x1477,0x0000,0x0000, 0x1478,0x0000,0x0000,
0x1479,0x0000,0x0000, 0x147A,0x0000,0x0000, 0x147B,0x0000,0x0000,
0x147C,0x0000,0x0000, 0x147D,0x0000,0x0000, 0x147E,0x0000,0x0000,
0x147F,0x0000,0x0000, 0x1480,0x0000,0x0000, 0x1481,0x0000,0x0000,
0x1482,0x0000,0x0000, 0x1483,0x0000,0x0000, 0x1484,0x0000,0x0000,
0x1485,0x0000,0x0000, 0x1486,0x0000,0x0000, 0x1487,0x0000,0x0000,
0x1488,0x0000,0x0000, 0x1489,0x0000,0x0000, 0x148A,0x0000,0x0000,
0x148B,0x0000,0x0000, 0x148C,0x0000,0x0000, 0x148D,0x0000,0x0000,
0x148E,0x0000,0x0000, 0x148F,0x0000,0x0000, 0x1490,0x0000,0x0000,
0x1491,0x0000,0x0000, 0x1492,0x0000,0x0000, 0x1493,0x0000,0x0000,
0x1494,0x0000,0x0000, 0x1495,0x0000,0x0000, 0x1496,0x0000,0x0000,
0x1497,0x0000,0x0000, 0x1498,0x0000,0x0000, 0x1499,0x0000,0x0000,
0xFBC0,0x9287,0x0000, 0x149A,0x0000,0x0000, 0xFBC0,0x9289,0x0000,
0x149B,0x0000,0x0000, 0x149C,0x0000,0x0000, 0x149D,0x0000,0x0000,
0x149E,0x0000,0x0000, 0xFBC0,0x928E,0x0000, 0xFBC0,0x928F,0x0000,
0x149F,0x0000,0x0000, 0x14A0,0x0000,0x0000, 0x14A1,0x0000,0x0000,
0x14A2,0x0000,0x0000, 0x14A3,0x0000,0x0000, 0x14A4,0x0000,0x0000,
0x14A5,0x0000,0x0000, 0x14A6,0x0000,0x0000, 0x14A7,0x0000,0x0000,
0x14A8,0x0000,0x0000, 0x14A9,0x0000,0x0000, 0x14AA,0x0000,0x0000,
0x14AB,0x0000,0x0000, 0x14AC,0x0000,0x0000, 0x14AD,0x0000,0x0000,
0x14AE,0x0000,0x0000, 0x14AF,0x0000,0x0000, 0x14B0,0x0000,0x0000,
0x14B1,0x0000,0x0000, 0x14B2,0x0000,0x0000, 0x14B3,0x0000,0x0000,
0x14B4,0x0000,0x0000, 0x14B5,0x0000,0x0000, 0x14B6,0x0000,0x0000,
0x14B7,0x0000,0x0000, 0x14B8,0x0000,0x0000, 0x14B9,0x0000,0x0000,
0x14BA,0x0000,0x0000, 0x14BB,0x0000,0x0000, 0x14BC,0x0000,0x0000,
0x14BD,0x0000,0x0000, 0xFBC0,0x92AF,0x0000, 0x14BE,0x0000,0x0000,
0xFBC0,0x92B1,0x0000, 0x14BF,0x0000,0x0000, 0x14C0,0x0000,0x0000,
0x14C1,0x0000,0x0000, 0x14C2,0x0000,0x0000, 0xFBC0,0x92B6,0x0000,
0xFBC0,0x92B7,0x0000, 0x14C3,0x0000,0x0000, 0x14C4,0x0000,0x0000,
0x14C5,0x0000,0x0000, 0x14C6,0x0000,0x0000, 0x14C7,0x0000,0x0000,
0x14C8,0x0000,0x0000, 0x14C9,0x0000,0x0000, 0xFBC0,0x92BF,0x0000,
0x14CA,0x0000,0x0000, 0xFBC0,0x92C1,0x0000, 0x14CB,0x0000,0x0000,
0x14CC,0x0000,0x0000, 0x14CD,0x0000,0x0000, 0x14CE,0x0000,0x0000,
0xFBC0,0x92C6,0x0000, 0xFBC0,0x92C7,0x0000, 0x14CF,0x0000,0x0000,
0x14D0,0x0000,0x0000, 0x14D1,0x0000,0x0000, 0x14D2,0x0000,0x0000,
0x14D3,0x0000,0x0000, 0x14D4,0x0000,0x0000, 0x14D5,0x0000,0x0000,
0xFBC0,0x92CF,0x0000, 0x14D6,0x0000,0x0000, 0x14D7,0x0000,0x0000,
0x14D8,0x0000,0x0000, 0x14D9,0x0000,0x0000, 0x14DA,0x0000,0x0000,
0x14DB,0x0000,0x0000, 0x14DC,0x0000,0x0000, 0xFBC0,0x92D7,0x0000,
0x14DD,0x0000,0x0000, 0x14DE,0x0000,0x0000, 0x14DF,0x0000,0x0000,
0x14E0,0x0000,0x0000, 0x14E1,0x0000,0x0000, 0x14E2,0x0000,0x0000,
0x14E3,0x0000,0x0000, 0x14E4,0x0000,0x0000, 0x14E5,0x0000,0x0000,
0x14E6,0x0000,0x0000, 0x14E7,0x0000,0x0000, 0x14E8,0x0000,0x0000,
0x14E9,0x0000,0x0000, 0x14EA,0x0000,0x0000, 0x14EB,0x0000,0x0000,
0x14EC,0x0000,0x0000, 0x14ED,0x0000,0x0000, 0x14EE,0x0000,0x0000,
0x14EF,0x0000,0x0000, 0x14F0,0x0000,0x0000, 0x14F1,0x0000,0x0000,
0x14F2,0x0000,0x0000, 0x14F3,0x0000,0x0000, 0xFBC0,0x92EF,0x0000,
0x14F4,0x0000,0x0000, 0x14F5,0x0000,0x0000, 0x14F6,0x0000,0x0000,
0x14F7,0x0000,0x0000, 0x14F8,0x0000,0x0000, 0x14F9,0x0000,0x0000,
0x14FA,0x0000,0x0000, 0x14FB,0x0000,0x0000, 0x14FC,0x0000,0x0000,
0x14FD,0x0000,0x0000, 0x14FE,0x0000,0x0000, 0x14FF,0x0000,0x0000,
0x1500,0x0000,0x0000, 0x1501,0x0000,0x0000, 0x1502,0x0000,0x0000,
0x1503,0x0000,0x0000 };

uint16 page013data[]= { /* 1300 (3 weights per char) */
0x1504,0x0000,0x0000, 0x1505,0x0000,0x0000, 0x1506,0x0000,0x0000,
0x1507,0x0000,0x0000, 0x1508,0x0000,0x0000, 0x1509,0x0000,0x0000,
0x150A,0x0000,0x0000, 0x150B,0x0000,0x0000, 0x150C,0x0000,0x0000,
0x150D,0x0000,0x0000, 0x150E,0x0000,0x0000, 0x150F,0x0000,0x0000,
0x1510,0x0000,0x0000, 0x1511,0x0000,0x0000, 0x1512,0x0000,0x0000,
0xFBC0,0x930F,0x0000, 0x1513,0x0000,0x0000, 0xFBC0,0x9311,0x0000,
0x1514,0x0000,0x0000, 0x1515,0x0000,0x0000, 0x1516,0x0000,0x0000,
0x1517,0x0000,0x0000, 0xFBC0,0x9316,0x0000, 0xFBC0,0x9317,0x0000,
0x1518,0x0000,0x0000, 0x1519,0x0000,0x0000, 0x151A,0x0000,0x0000,
0x151B,0x0000,0x0000, 0x151C,0x0000,0x0000, 0x151D,0x0000,0x0000,
0x151E,0x0000,0x0000, 0xFBC0,0x931F,0x0000, 0x151F,0x0000,0x0000,
0x1520,0x0000,0x0000, 0x1521,0x0000,0x0000, 0x1522,0x0000,0x0000,
0x1523,0x0000,0x0000, 0x1524,0x0000,0x0000, 0x1525,0x0000,0x0000,
0x1526,0x0000,0x0000, 0x1527,0x0000,0x0000, 0x1528,0x0000,0x0000,
0x1529,0x0000,0x0000, 0x152A,0x0000,0x0000, 0x152B,0x0000,0x0000,
0x152C,0x0000,0x0000, 0x152D,0x0000,0x0000, 0x152E,0x0000,0x0000,
0x152F,0x0000,0x0000, 0x1530,0x0000,0x0000, 0x1531,0x0000,0x0000,
0x1532,0x0000,0x0000, 0x1533,0x0000,0x0000, 0x1534,0x0000,0x0000,
0x1535,0x0000,0x0000, 0x1536,0x0000,0x0000, 0x1537,0x0000,0x0000,
0x1538,0x0000,0x0000, 0x1539,0x0000,0x0000, 0x153A,0x0000,0x0000,
0x153B,0x0000,0x0000, 0x153C,0x0000,0x0000, 0x153D,0x0000,0x0000,
0x153E,0x0000,0x0000, 0x153F,0x0000,0x0000, 0x1540,0x0000,0x0000,
0x1541,0x0000,0x0000, 0x1542,0x0000,0x0000, 0x1543,0x0000,0x0000,
0x1544,0x0000,0x0000, 0x1545,0x0000,0x0000, 0xFBC0,0x9347,0x0000,
0x1546,0x0000,0x0000, 0x1547,0x0000,0x0000, 0x1548,0x0000,0x0000,
0x1549,0x0000,0x0000, 0x154A,0x0000,0x0000, 0x154B,0x0000,0x0000,
0x154C,0x0000,0x0000, 0x154D,0x0000,0x0000, 0x154E,0x0000,0x0000,
0x154F,0x0000,0x0000, 0x1550,0x0000,0x0000, 0x1551,0x0000,0x0000,
0x1552,0x0000,0x0000, 0x1553,0x0000,0x0000, 0x1554,0x0000,0x0000,
0x1555,0x0000,0x0000, 0x1556,0x0000,0x0000, 0x1557,0x0000,0x0000,
0x1558,0x0000,0x0000, 0xFBC0,0x935B,0x0000, 0xFBC0,0x935C,0x0000,
0xFBC0,0x935D,0x0000, 0xFBC0,0x935E,0x0000, 0xFBC0,0x935F,0x0000,
0xFBC0,0x9360,0x0000, 0x0245,0x0000,0x0000, 0x0262,0x0000,0x0000,
0x0246,0x0000,0x0000, 0x0247,0x0000,0x0000, 0x0248,0x0000,0x0000,
0x0249,0x0000,0x0000, 0x025A,0x0000,0x0000, 0x0272,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x0DCC,0x0000,0x0000, 0x0DCD,0x0000,0x0000, 0x0DCE,0x0000,0x0000,
0x0DCF,0x0000,0x0000, 0x0DD0,0x0000,0x0000, 0x0DD1,0x0000,0x0000,
0x0DD2,0x0000,0x0000, 0x0DD3,0x0000,0x0000, 0x0DD4,0x0000,0x0000,
0x0DD5,0x0000,0x0000, 0x0DD6,0x0000,0x0000, 0xFBC0,0x937D,0x0000,
0xFBC0,0x937E,0x0000, 0xFBC0,0x937F,0x0000, 0xFBC0,0x9380,0x0000,
0xFBC0,0x9381,0x0000, 0xFBC0,0x9382,0x0000, 0xFBC0,0x9383,0x0000,
0xFBC0,0x9384,0x0000, 0xFBC0,0x9385,0x0000, 0xFBC0,0x9386,0x0000,
0xFBC0,0x9387,0x0000, 0xFBC0,0x9388,0x0000, 0xFBC0,0x9389,0x0000,
0xFBC0,0x938A,0x0000, 0xFBC0,0x938B,0x0000, 0xFBC0,0x938C,0x0000,
0xFBC0,0x938D,0x0000, 0xFBC0,0x938E,0x0000, 0xFBC0,0x938F,0x0000,
0xFBC0,0x9390,0x0000, 0xFBC0,0x9391,0x0000, 0xFBC0,0x9392,0x0000,
0xFBC0,0x9393,0x0000, 0xFBC0,0x9394,0x0000, 0xFBC0,0x9395,0x0000,
0xFBC0,0x9396,0x0000, 0xFBC0,0x9397,0x0000, 0xFBC0,0x9398,0x0000,
0xFBC0,0x9399,0x0000, 0xFBC0,0x939A,0x0000, 0xFBC0,0x939B,0x0000,
0xFBC0,0x939C,0x0000, 0xFBC0,0x939D,0x0000, 0xFBC0,0x939E,0x0000,
0xFBC0,0x939F,0x0000, 0x1A59,0x0000,0x0000, 0x1A5A,0x0000,0x0000,
0x1A5B,0x0000,0x0000, 0x1A5C,0x0000,0x0000, 0x1A5D,0x0000,0x0000,
0x1A5E,0x0000,0x0000, 0x1A5F,0x0000,0x0000, 0x1A60,0x0000,0x0000,
0x1A61,0x0000,0x0000, 0x1A62,0x0000,0x0000, 0x1A63,0x0000,0x0000,
0x1A64,0x0000,0x0000, 0x1A65,0x0000,0x0000, 0x1A66,0x0000,0x0000,
0x1A67,0x0000,0x0000, 0x1A68,0x0000,0x0000, 0x1A69,0x0000,0x0000,
0x1A6A,0x0000,0x0000, 0x1A6B,0x0000,0x0000, 0x1A6C,0x0000,0x0000,
0x1A6D,0x0000,0x0000, 0x1A6E,0x0000,0x0000, 0x1A6F,0x0000,0x0000,
0x1A70,0x0000,0x0000, 0x1A71,0x0000,0x0000, 0x1A72,0x0000,0x0000,
0x1A73,0x0000,0x0000, 0x1A74,0x0000,0x0000, 0x1A75,0x0000,0x0000,
0x1A76,0x0000,0x0000, 0x1A77,0x0000,0x0000, 0x1A78,0x0000,0x0000,
0x1A79,0x0000,0x0000, 0x1A7A,0x0000,0x0000, 0x1A7B,0x0000,0x0000,
0x1A7C,0x0000,0x0000, 0x1A7D,0x0000,0x0000, 0x1A7E,0x0000,0x0000,
0x1A7F,0x0000,0x0000, 0x1A80,0x0000,0x0000, 0x1A81,0x0000,0x0000,
0x1A82,0x0000,0x0000, 0x1A83,0x0000,0x0000, 0x1A84,0x0000,0x0000,
0x1A85,0x0000,0x0000, 0x1A86,0x0000,0x0000, 0x1A87,0x0000,0x0000,
0x1A88,0x0000,0x0000, 0x1A89,0x0000,0x0000, 0x1A8A,0x0000,0x0000,
0x1A8B,0x0000,0x0000, 0x1A8C,0x0000,0x0000, 0x1A8D,0x0000,0x0000,
0x1A8E,0x0000,0x0000, 0x1A8F,0x0000,0x0000, 0x1A90,0x0000,0x0000,
0x1A91,0x0000,0x0000, 0x1A92,0x0000,0x0000, 0x1A93,0x0000,0x0000,
0x1A94,0x0000,0x0000, 0x1A95,0x0000,0x0000, 0x1A96,0x0000,0x0000,
0x1A97,0x0000,0x0000, 0x1A98,0x0000,0x0000, 0x1A99,0x0000,0x0000,
0x1A9A,0x0000,0x0000, 0x1A9B,0x0000,0x0000, 0x1A9C,0x0000,0x0000,
0x1A9D,0x0000,0x0000, 0x1A9E,0x0000,0x0000, 0x1A9F,0x0000,0x0000,
0x1AA0,0x0000,0x0000, 0x1AA1,0x0000,0x0000, 0x1AA2,0x0000,0x0000,
0x1AA3,0x0000,0x0000, 0x1AA4,0x0000,0x0000, 0x1AA5,0x0000,0x0000,
0x1AA6,0x0000,0x0000, 0x1AA7,0x0000,0x0000, 0x1AA8,0x0000,0x0000,
0x1AA9,0x0000,0x0000, 0x1AAA,0x0000,0x0000, 0x1AAB,0x0000,0x0000,
0x1AAC,0x0000,0x0000, 0x1AAD,0x0000,0x0000, 0xFBC0,0x93F5,0x0000,
0xFBC0,0x93F6,0x0000, 0xFBC0,0x93F7,0x0000, 0xFBC0,0x93F8,0x0000,
0xFBC0,0x93F9,0x0000, 0xFBC0,0x93FA,0x0000, 0xFBC0,0x93FB,0x0000,
0xFBC0,0x93FC,0x0000, 0xFBC0,0x93FD,0x0000, 0xFBC0,0x93FE,0x0000,
0xFBC0,0x93FF,0x0000 };

uint16 page014data[]= { /* 1400 (3 weights per char) */
0xFBC0,0x9400,0x0000, 0x1AAE,0x0000,0x0000, 0x1AAF,0x0000,0x0000,
0x1AB0,0x0000,0x0000, 0x1AB1,0x0000,0x0000, 0x1AB2,0x0000,0x0000,
0x1AB3,0x0000,0x0000, 0x1AB4,0x0000,0x0000, 0x1AB5,0x0000,0x0000,
0x1AB6,0x0000,0x0000, 0x1AB7,0x0000,0x0000, 0x1AB8,0x0000,0x0000,
0x1AB9,0x0000,0x0000, 0x1ABA,0x0000,0x0000, 0x1ABB,0x0000,0x0000,
0x1ABC,0x0000,0x0000, 0x1ABD,0x0000,0x0000, 0x1ABE,0x0000,0x0000,
0x1ABF,0x0000,0x0000, 0x1AC0,0x0000,0x0000, 0x1AC1,0x0000,0x0000,
0x1AC2,0x0000,0x0000, 0x1AC3,0x0000,0x0000, 0x1AC4,0x0000,0x0000,
0x1AC5,0x0000,0x0000, 0x1AC6,0x0000,0x0000, 0x1AC7,0x0000,0x0000,
0x1AC8,0x0000,0x0000, 0x1AC9,0x0000,0x0000, 0x1ACA,0x0000,0x0000,
0x1ACB,0x0000,0x0000, 0x1ACC,0x0000,0x0000, 0x1ACD,0x0000,0x0000,
0x1ACE,0x0000,0x0000, 0x1ACF,0x0000,0x0000, 0x1AD0,0x0000,0x0000,
0x1AD1,0x0000,0x0000, 0x1AD2,0x0000,0x0000, 0x1AD3,0x0000,0x0000,
0x1AD4,0x0000,0x0000, 0x1AD5,0x0000,0x0000, 0x1AD6,0x0000,0x0000,
0x1AD7,0x0000,0x0000, 0x1AD8,0x0000,0x0000, 0x1AD9,0x0000,0x0000,
0x1ADA,0x0000,0x0000, 0x1ADB,0x0000,0x0000, 0x1ADC,0x0000,0x0000,
0x1ADD,0x0000,0x0000, 0x1ADE,0x0000,0x0000, 0x1ADF,0x0000,0x0000,
0x1AE0,0x0000,0x0000, 0x1AE1,0x0000,0x0000, 0x1AE2,0x0000,0x0000,
0x1AE3,0x0000,0x0000, 0x1AE4,0x0000,0x0000, 0x1AE5,0x0000,0x0000,
0x1AE6,0x0000,0x0000, 0x1AE7,0x0000,0x0000, 0x1AE8,0x0000,0x0000,
0x1AE9,0x0000,0x0000, 0x1AEA,0x0000,0x0000, 0x1AEB,0x0000,0x0000,
0x1AEC,0x0000,0x0000, 0x1AED,0x0000,0x0000, 0x1AEE,0x0000,0x0000,
0x1AEF,0x0000,0x0000, 0x1AF0,0x0000,0x0000, 0x1AF1,0x0000,0x0000,
0x1AF2,0x0000,0x0000, 0x1AF3,0x0000,0x0000, 0x1AF4,0x0000,0x0000,
0x1AF5,0x0000,0x0000, 0x1AF6,0x0000,0x0000, 0x1AF7,0x0000,0x0000,
0x1AF8,0x0000,0x0000, 0x1AF9,0x0000,0x0000, 0x1AFA,0x0000,0x0000,
0x1AFB,0x0000,0x0000, 0x1AFC,0x0000,0x0000, 0x1AFD,0x0000,0x0000,
0x1AFE,0x0000,0x0000, 0x1AFF,0x0000,0x0000, 0x1B00,0x0000,0x0000,
0x1B01,0x0000,0x0000, 0x1B02,0x0000,0x0000, 0x1B03,0x0000,0x0000,
0x1B04,0x0000,0x0000, 0x1B05,0x0000,0x0000, 0x1B06,0x0000,0x0000,
0x1B07,0x0000,0x0000, 0x1B08,0x0000,0x0000, 0x1B09,0x0000,0x0000,
0x1B0A,0x0000,0x0000, 0x1B0B,0x0000,0x0000, 0x1B0C,0x0000,0x0000,
0x1B0D,0x0000,0x0000, 0x1B0E,0x0000,0x0000, 0x1B0F,0x0000,0x0000,
0x1B10,0x0000,0x0000, 0x1B11,0x0000,0x0000, 0x1B12,0x0000,0x0000,
0x1B13,0x0000,0x0000, 0x1B14,0x0000,0x0000, 0x1B15,0x0000,0x0000,
0x1B16,0x0000,0x0000, 0x1B17,0x0000,0x0000, 0x1B18,0x0000,0x0000,
0x1B19,0x0000,0x0000, 0x1B1A,0x0000,0x0000, 0x1B1B,0x0000,0x0000,
0x1B1C,0x0000,0x0000, 0x1B1D,0x0000,0x0000, 0x1B1E,0x0000,0x0000,
0x1B1F,0x0000,0x0000, 0x1B20,0x0000,0x0000, 0x1B21,0x0000,0x0000,
0x1B22,0x0000,0x0000, 0x1B23,0x0000,0x0000, 0x1B24,0x0000,0x0000,
0x1B25,0x0000,0x0000, 0x1B26,0x0000,0x0000, 0x1B27,0x0000,0x0000,
0x1B28,0x0000,0x0000, 0x1B29,0x0000,0x0000, 0x1B2A,0x0000,0x0000,
0x1B2B,0x0000,0x0000, 0x1B2C,0x0000,0x0000, 0x1B2D,0x0000,0x0000,
0x1B2E,0x0000,0x0000, 0x1B2F,0x0000,0x0000, 0x1B30,0x0000,0x0000,
0x1B31,0x0000,0x0000, 0x1B32,0x0000,0x0000, 0x1B33,0x0000,0x0000,
0x1B34,0x0000,0x0000, 0x1B35,0x0000,0x0000, 0x1B36,0x0000,0x0000,
0x1B37,0x0000,0x0000, 0x1B38,0x0000,0x0000, 0x1B39,0x0000,0x0000,
0x1B3A,0x0000,0x0000, 0x1B3B,0x0000,0x0000, 0x1B3C,0x0000,0x0000,
0x1B3D,0x0000,0x0000, 0x1B3E,0x0000,0x0000, 0x1B3F,0x0000,0x0000,
0x1B40,0x0000,0x0000, 0x1B41,0x0000,0x0000, 0x1B42,0x0000,0x0000,
0x1B43,0x0000,0x0000, 0x1B44,0x0000,0x0000, 0x1B45,0x0000,0x0000,
0x1B46,0x0000,0x0000, 0x1B47,0x0000,0x0000, 0x1B48,0x0000,0x0000,
0x1B49,0x0000,0x0000, 0x1B4A,0x0000,0x0000, 0x1B4B,0x0000,0x0000,
0x1B4C,0x0000,0x0000, 0x1B4D,0x0000,0x0000, 0x1B4E,0x0000,0x0000,
0x1B4F,0x0000,0x0000, 0x1B50,0x0000,0x0000, 0x1B51,0x0000,0x0000,
0x1B52,0x0000,0x0000, 0x1B53,0x0000,0x0000, 0x1B54,0x0000,0x0000,
0x1B55,0x0000,0x0000, 0x1B56,0x0000,0x0000, 0x1B57,0x0000,0x0000,
0x1B58,0x0000,0x0000, 0x1B59,0x0000,0x0000, 0x1B5A,0x0000,0x0000,
0x1B5B,0x0000,0x0000, 0x1B5C,0x0000,0x0000, 0x1B5D,0x0000,0x0000,
0x1B5E,0x0000,0x0000, 0x1B5F,0x0000,0x0000, 0x1B60,0x0000,0x0000,
0x1B61,0x0000,0x0000, 0x1B62,0x0000,0x0000, 0x1B63,0x0000,0x0000,
0x1B64,0x0000,0x0000, 0x1B65,0x0000,0x0000, 0x1B66,0x0000,0x0000,
0x1B67,0x0000,0x0000, 0x1B68,0x0000,0x0000, 0x1B69,0x0000,0x0000,
0x1B6A,0x0000,0x0000, 0x1B6B,0x0000,0x0000, 0x1B6C,0x0000,0x0000,
0x1B6D,0x0000,0x0000, 0x1B6E,0x0000,0x0000, 0x1B6F,0x0000,0x0000,
0x1B70,0x0000,0x0000, 0x1B71,0x0000,0x0000, 0x1B72,0x0000,0x0000,
0x1B73,0x0000,0x0000, 0x1B74,0x0000,0x0000, 0x1B75,0x0000,0x0000,
0x1B76,0x0000,0x0000, 0x1B77,0x0000,0x0000, 0x1B78,0x0000,0x0000,
0x1B79,0x0000,0x0000, 0x1B7A,0x0000,0x0000, 0x1B7B,0x0000,0x0000,
0x1B7C,0x0000,0x0000, 0x1B7D,0x0000,0x0000, 0x1B7E,0x0000,0x0000,
0x1B7F,0x0000,0x0000, 0x1B80,0x0000,0x0000, 0x1B81,0x0000,0x0000,
0x1B82,0x0000,0x0000, 0x1B83,0x0000,0x0000, 0x1B84,0x0000,0x0000,
0x1B85,0x0000,0x0000, 0x1B86,0x0000,0x0000, 0x1B87,0x0000,0x0000,
0x1B88,0x0000,0x0000, 0x1B89,0x0000,0x0000, 0x1B8A,0x0000,0x0000,
0x1B8B,0x0000,0x0000, 0x1B8C,0x0000,0x0000, 0x1B8D,0x0000,0x0000,
0x1B8E,0x0000,0x0000, 0x1B8F,0x0000,0x0000, 0x1B90,0x0000,0x0000,
0x1B91,0x0000,0x0000, 0x1B92,0x0000,0x0000, 0x1B93,0x0000,0x0000,
0x1B94,0x0000,0x0000, 0x1B95,0x0000,0x0000, 0x1B96,0x0000,0x0000,
0x1B97,0x0000,0x0000, 0x1B98,0x0000,0x0000, 0x1B99,0x0000,0x0000,
0x1B9A,0x0000,0x0000, 0x1B9B,0x0000,0x0000, 0x1B9C,0x0000,0x0000,
0x1B9D,0x0000,0x0000, 0x1B9E,0x0000,0x0000, 0x1B9F,0x0000,0x0000,
0x1BA0,0x0000,0x0000, 0x1BA1,0x0000,0x0000, 0x1BA2,0x0000,0x0000,
0x1BA3,0x0000,0x0000, 0x1BA4,0x0000,0x0000, 0x1BA5,0x0000,0x0000,
0x1BA6,0x0000,0x0000, 0x1BA7,0x0000,0x0000, 0x1BA8,0x0000,0x0000,
0x1BA9,0x0000,0x0000, 0x1BAA,0x0000,0x0000, 0x1BAB,0x0000,0x0000,
0x1BAC,0x0000,0x0000 };

uint16 page015data[]= { /* 1500 (2 weights per char) */
0x1BAD,0x0000, 0x1BAE,0x0000, 0x1BAF,0x0000, 0x1BB0,0x0000,
0x1BB1,0x0000, 0x1BB2,0x0000, 0x1BB3,0x0000, 0x1BB4,0x0000,
0x1BB5,0x0000, 0x1BB6,0x0000, 0x1BB7,0x0000, 0x1BB8,0x0000,
0x1BB9,0x0000, 0x1BBA,0x0000, 0x1BBB,0x0000, 0x1BBC,0x0000,
0x1BBD,0x0000, 0x1BBE,0x0000, 0x1BBF,0x0000, 0x1BC0,0x0000,
0x1BC1,0x0000, 0x1BC2,0x0000, 0x1BC3,0x0000, 0x1BC4,0x0000,
0x1BC5,0x0000, 0x1BC6,0x0000, 0x1BC7,0x0000, 0x1BC8,0x0000,
0x1BC9,0x0000, 0x1BCA,0x0000, 0x1BCB,0x0000, 0x1BCC,0x0000,
0x1BCD,0x0000, 0x1BCE,0x0000, 0x1BCF,0x0000, 0x1BD0,0x0000,
0x1BD1,0x0000, 0x1BD2,0x0000, 0x1BD3,0x0000, 0x1BD4,0x0000,
0x1BD5,0x0000, 0x1BD6,0x0000, 0x1BD7,0x0000, 0x1BD8,0x0000,
0x1BD9,0x0000, 0x1BDA,0x0000, 0x1BDB,0x0000, 0x1BDC,0x0000,
0x1BDD,0x0000, 0x1BDE,0x0000, 0x1BDF,0x0000, 0x1BE0,0x0000,
0x1BE1,0x0000, 0x1BE2,0x0000, 0x1BE3,0x0000, 0x1BE4,0x0000,
0x1BE5,0x0000, 0x1BE6,0x0000, 0x1BE7,0x0000, 0x1BE8,0x0000,
0x1BE9,0x0000, 0x1BEA,0x0000, 0x1BEB,0x0000, 0x1BEC,0x0000,
0x1BED,0x0000, 0x1BEE,0x0000, 0x1BEF,0x0000, 0x1BF0,0x0000,
0x1BF1,0x0000, 0x1BF2,0x0000, 0x1BF3,0x0000, 0x1BF4,0x0000,
0x1BF5,0x0000, 0x1BF6,0x0000, 0x1BF7,0x0000, 0x1BF8,0x0000,
0x1BF9,0x0000, 0x1BFA,0x0000, 0x1BFB,0x0000, 0x1BFC,0x0000,
0x1BFD,0x0000, 0x1BFE,0x0000, 0x1BFF,0x0000, 0x1C00,0x0000,
0x1C01,0x0000, 0x1C02,0x0000, 0x1C03,0x0000, 0x1C04,0x0000,
0x1C05,0x0000, 0x1C06,0x0000, 0x1C07,0x0000, 0x1C08,0x0000,
0x1C09,0x0000, 0x1C0A,0x0000, 0x1C0B,0x0000, 0x1C0C,0x0000,
0x1C0D,0x0000, 0x1C0E,0x0000, 0x1C0F,0x0000, 0x1C10,0x0000,
0x1C11,0x0000, 0x1C12,0x0000, 0x1C13,0x0000, 0x1C14,0x0000,
0x1C15,0x0000, 0x1C16,0x0000, 0x1C17,0x0000, 0x1C18,0x0000,
0x1C19,0x0000, 0x1C1A,0x0000, 0x1C1B,0x0000, 0x1C1C,0x0000,
0x1C1D,0x0000, 0x1C1E,0x0000, 0x1C1F,0x0000, 0x1C20,0x0000,
0x1C21,0x0000, 0x1C22,0x0000, 0x1C23,0x0000, 0x1C24,0x0000,
0x1C25,0x0000, 0x1C26,0x0000, 0x1C27,0x0000, 0x1C28,0x0000,
0x1C5B,0x0000, 0x1C29,0x0000, 0x1C2B,0x0000, 0x1C2C,0x0000,
0x1C2D,0x0000, 0x1C2E,0x0000, 0x1C2F,0x0000, 0x1C30,0x0000,
0x1C31,0x0000, 0x1C32,0x0000, 0x1C33,0x0000, 0x1C34,0x0000,
0x1C35,0x0000, 0x1C36,0x0000, 0x1C37,0x0000, 0x1C38,0x0000,
0x1C39,0x0000, 0x1C3A,0x0000, 0x1C3C,0x0000, 0x1C3D,0x0000,
0x1C3E,0x0000, 0x1C3F,0x0000, 0x1C40,0x0000, 0x1C41,0x0000,
0x1C42,0x0000, 0x1C43,0x0000, 0x1C4A,0x0000, 0x1C4B,0x0000,
0x1C4C,0x0000, 0x1C4D,0x0000, 0x1C4E,0x0000, 0x1C4F,0x0000,
0x1C50,0x0000, 0x1C51,0x0000, 0x1C52,0x0000, 0x1C53,0x0000,
0x1C54,0x0000, 0x1C55,0x0000, 0x1C56,0x0000, 0x1C57,0x0000,
0x1C58,0x0000, 0x1C59,0x0000, 0x1C5A,0x0000, 0x1C5C,0x0000,
0x1C5D,0x0000, 0x1C5E,0x0000, 0x1C5F,0x0000, 0x1C60,0x0000,
0x1C61,0x0000, 0x1C62,0x0000, 0x1C63,0x0000, 0x1C64,0x0000,
0x1C65,0x0000, 0x1C66,0x0000, 0x1C67,0x0000, 0x1C68,0x0000,
0x1C69,0x0000, 0x1C6A,0x0000, 0x1C6B,0x0000, 0x1C6C,0x0000,
0x1C6D,0x0000, 0x1C6E,0x0000, 0x1C6F,0x0000, 0x1C70,0x0000,
0x1C71,0x0000, 0x1C72,0x0000, 0x1C73,0x0000, 0x1C74,0x0000,
0x1C75,0x0000, 0x1C76,0x0000, 0x1C77,0x0000, 0x1C78,0x0000,
0x1C79,0x0000, 0x1C7A,0x0000, 0x1C7B,0x0000, 0x1C7C,0x0000,
0x1C7D,0x0000, 0x1C7E,0x0000, 0x1C7F,0x0000, 0x1C80,0x0000,
0x1C81,0x0000, 0x1C82,0x0000, 0x1C83,0x0000, 0x1C84,0x0000,
0x1C85,0x0000, 0x1C86,0x0000, 0x1C87,0x0000, 0x1C88,0x0000,
0x1C89,0x0000, 0x1C8A,0x0000, 0x1C8B,0x0000, 0x1C8C,0x0000,
0x1C8D,0x0000, 0x1C8E,0x0000, 0x1C8F,0x0000, 0x1C90,0x0000,
0x1C91,0x0000, 0x1C92,0x0000, 0x1C93,0x0000, 0x1C94,0x0000,
0x1C95,0x0000, 0x1C96,0x0000, 0x1C97,0x0000, 0x1C98,0x0000,
0x1C99,0x0000, 0x1C9A,0x0000, 0x1C9B,0x0000, 0x1C9C,0x0000,
0x1C9D,0x0000, 0x1C9E,0x0000, 0x1C9F,0x0000, 0x1CA0,0x0000,
0x1CA1,0x0000, 0x1CA2,0x0000, 0x1CA3,0x0000, 0x1CA4,0x0000,
0x1CA5,0x0000, 0x1CA6,0x0000, 0x1CA7,0x0000, 0x1CA8,0x0000,
0x1CA9,0x0000, 0x1CAA,0x0000, 0x1CAB,0x0000, 0x1CAC,0x0000,
0x1CAD,0x0000, 0x1CAE,0x0000, 0x1CAF,0x0000, 0x1CB0,0x0000,
0x1CB1,0x0000, 0x1CB2,0x0000, 0x1CB3,0x0000, 0x1CB4,0x0000
};

uint16 page016data[]= { /* 1600 (3 weights per char) */
0x1CB5,0x0000,0x0000, 0x1CB6,0x0000,0x0000, 0x1CB7,0x0000,0x0000,
0x1CB8,0x0000,0x0000, 0x1CB9,0x0000,0x0000, 0x1CBA,0x0000,0x0000,
0x1CBB,0x0000,0x0000, 0x1CBC,0x0000,0x0000, 0x1CBD,0x0000,0x0000,
0x1CBE,0x0000,0x0000, 0x1CBF,0x0000,0x0000, 0x1CC0,0x0000,0x0000,
0x1CC1,0x0000,0x0000, 0x1CC2,0x0000,0x0000, 0x1CC3,0x0000,0x0000,
0x1CC4,0x0000,0x0000, 0x1CC5,0x0000,0x0000, 0x1CC6,0x0000,0x0000,
0x1CC7,0x0000,0x0000, 0x1CC8,0x0000,0x0000, 0x1CC9,0x0000,0x0000,
0x1CCA,0x0000,0x0000, 0x1CCB,0x0000,0x0000, 0x1CCC,0x0000,0x0000,
0x1CCD,0x0000,0x0000, 0x1CCE,0x0000,0x0000, 0x1CCF,0x0000,0x0000,
0x1CD0,0x0000,0x0000, 0x1CD1,0x0000,0x0000, 0x1CD2,0x0000,0x0000,
0x1CD3,0x0000,0x0000, 0x1CD4,0x0000,0x0000, 0x1CD5,0x0000,0x0000,
0x1CD6,0x0000,0x0000, 0x1CD7,0x0000,0x0000, 0x1CD8,0x0000,0x0000,
0x1CD9,0x0000,0x0000, 0x1CDA,0x0000,0x0000, 0x1CDB,0x0000,0x0000,
0x1CDC,0x0000,0x0000, 0x1CDD,0x0000,0x0000, 0x1CDE,0x0000,0x0000,
0x1CDF,0x0000,0x0000, 0x1CE0,0x0000,0x0000, 0x1CE1,0x0000,0x0000,
0x1CE2,0x0000,0x0000, 0x1CE3,0x0000,0x0000, 0x1CE4,0x0000,0x0000,
0x1CE5,0x0000,0x0000, 0x1CE6,0x0000,0x0000, 0x1CE7,0x0000,0x0000,
0x1CE8,0x0000,0x0000, 0x1CE9,0x0000,0x0000, 0x1CEA,0x0000,0x0000,
0x1CEB,0x0000,0x0000, 0x1CEC,0x0000,0x0000, 0x1CED,0x0000,0x0000,
0x1CEE,0x0000,0x0000, 0x1CEF,0x0000,0x0000, 0x1CF0,0x0000,0x0000,
0x1CF1,0x0000,0x0000, 0x1CF2,0x0000,0x0000, 0x1CF3,0x0000,0x0000,
0x1CF4,0x0000,0x0000, 0x1CF5,0x0000,0x0000, 0x1CF6,0x0000,0x0000,
0x1CF7,0x0000,0x0000, 0x1CF8,0x0000,0x0000, 0x1CF9,0x0000,0x0000,
0x1CFA,0x0000,0x0000, 0x1CFB,0x0000,0x0000, 0x1CFC,0x0000,0x0000,
0x1CFD,0x0000,0x0000, 0x1CFE,0x0000,0x0000, 0x1CFF,0x0000,0x0000,
0x1D00,0x0000,0x0000, 0x1D01,0x0000,0x0000, 0x1D02,0x0000,0x0000,
0x1D03,0x0000,0x0000, 0x1D04,0x0000,0x0000, 0x1D05,0x0000,0x0000,
0x1D06,0x0000,0x0000, 0x1D07,0x0000,0x0000, 0x1D08,0x0000,0x0000,
0x1D09,0x0000,0x0000, 0x1D0A,0x0000,0x0000, 0x1D0B,0x0000,0x0000,
0x1D0C,0x0000,0x0000, 0x1D0D,0x0000,0x0000, 0x1D0E,0x0000,0x0000,
0x1D0F,0x0000,0x0000, 0x1D10,0x0000,0x0000, 0x1D11,0x0000,0x0000,
0x1D12,0x0000,0x0000, 0x1D13,0x0000,0x0000, 0x1D14,0x0000,0x0000,
0x1D15,0x0000,0x0000, 0x1D16,0x0000,0x0000, 0x1D17,0x0000,0x0000,
0x1D18,0x0000,0x0000, 0x1D19,0x0000,0x0000, 0x1D1A,0x0000,0x0000,
0x1D1B,0x0000,0x0000, 0x1D1C,0x0000,0x0000, 0x1D1D,0x0000,0x0000,
0x1D1E,0x0000,0x0000, 0x1D1F,0x0000,0x0000, 0x1D20,0x0000,0x0000,
0x1D21,0x0000,0x0000, 0x0316,0x0000,0x0000, 0x0265,0x0000,0x0000,
0x1C2A,0x0000,0x0000, 0x1C3B,0x0000,0x0000, 0x1C44,0x0000,0x0000,
0x1C45,0x0000,0x0000, 0x1C46,0x0000,0x0000, 0x1C47,0x0000,0x0000,
0x1C48,0x0000,0x0000, 0x1C49,0x0000,0x0000, 0xFBC0,0x9677,0x0000,
0xFBC0,0x9678,0x0000, 0xFBC0,0x9679,0x0000, 0xFBC0,0x967A,0x0000,
0xFBC0,0x967B,0x0000, 0xFBC0,0x967C,0x0000, 0xFBC0,0x967D,0x0000,
0xFBC0,0x967E,0x0000, 0xFBC0,0x967F,0x0000, 0x020A,0x0000,0x0000,
0x1D22,0x0000,0x0000, 0x1D23,0x0000,0x0000, 0x1D24,0x0000,0x0000,
0x1D25,0x0000,0x0000, 0x1D26,0x0000,0x0000, 0x1D27,0x0000,0x0000,
0x1D28,0x0000,0x0000, 0x1D29,0x0000,0x0000, 0x1D2A,0x0000,0x0000,
0x1D2B,0x0000,0x0000, 0x1D2C,0x0000,0x0000, 0x1D2D,0x0000,0x0000,
0x1D2E,0x0000,0x0000, 0x1D2F,0x0000,0x0000, 0x1D30,0x0000,0x0000,
0x1D31,0x0000,0x0000, 0x1D32,0x0000,0x0000, 0x1D33,0x0000,0x0000,
0x1D34,0x0000,0x0000, 0x1D35,0x0000,0x0000, 0x1D36,0x0000,0x0000,
0x1D37,0x0000,0x0000, 0x1D38,0x0000,0x0000, 0x1D39,0x0000,0x0000,
0x1D3A,0x0000,0x0000, 0x1D3B,0x0000,0x0000, 0x0292,0x0000,0x0000,
0x0293,0x0000,0x0000, 0xFBC0,0x969D,0x0000, 0xFBC0,0x969E,0x0000,
0xFBC0,0x969F,0x0000, 0x1D3C,0x0000,0x0000, 0x1D3C,0x0000,0x0000,
0x1D3D,0x0000,0x0000, 0x1D59,0x0000,0x0000, 0x1D3D,0x0000,0x0000,
0x1D3D,0x0000,0x0000, 0x1D3E,0x0000,0x0000, 0x1D3E,0x0000,0x0000,
0x1D3F,0x0000,0x0000, 0x1D3F,0x0000,0x0000, 0x1D57,0x0000,0x0000,
0x1D58,0x0000,0x0000, 0x1D3F,0x0000,0x0000, 0x1D3F,0x0000,0x0000,
0x1D3F,0x0000,0x0000, 0x1D40,0x0000,0x0000, 0x1D41,0x0000,0x0000,
0x1D42,0x0000,0x0000, 0x1D43,0x0000,0x0000, 0x1D43,0x0000,0x0000,
0x1D43,0x0000,0x0000, 0x1D43,0x0000,0x0000, 0x1D43,0x0000,0x0000,
0x1D44,0x0000,0x0000, 0x1D5C,0x0000,0x0000, 0x1D45,0x0000,0x0000,
0x1D46,0x0000,0x0000, 0x1D46,0x0000,0x0000, 0x1D46,0x0000,0x0000,
0x1D46,0x0000,0x0000, 0x1D47,0x0000,0x0000, 0x1D47,0x0000,0x0000,
0x1D47,0x0000,0x0000, 0x1D48,0x0000,0x0000, 0x1D48,0x0000,0x0000,
0x1D49,0x0000,0x0000, 0x1D49,0x0000,0x0000, 0x1D4A,0x0000,0x0000,
0x1D4A,0x0000,0x0000, 0x1D4B,0x0000,0x0000, 0x1D4C,0x0000,0x0000,
0x1D4D,0x0000,0x0000, 0x1D4E,0x0000,0x0000, 0x1D4E,0x0000,0x0000,
0x1D4E,0x0000,0x0000, 0x1D4E,0x0000,0x0000, 0x1D4E,0x0000,0x0000,
0x1D4F,0x0000,0x0000, 0x1D4F,0x0000,0x0000, 0x1D4F,0x0000,0x0000,
0x1D50,0x0000,0x0000, 0x1D50,0x0000,0x0000, 0x1D50,0x0000,0x0000,
0x1D4C,0x0000,0x0000, 0x1D51,0x0000,0x0000, 0x1D52,0x0000,0x0000,
0x1D52,0x0000,0x0000, 0x1D52,0x0000,0x0000, 0x1D53,0x0000,0x0000,
0x1D53,0x0000,0x0000, 0x1D54,0x0000,0x0000, 0x1D54,0x0000,0x0000,
0x1D55,0x0000,0x0000, 0x1D56,0x0000,0x0000, 0x1D5A,0x0000,0x0000,
0x1D5E,0x0000,0x0000, 0x1D5F,0x0000,0x0000, 0x1D5B,0x0000,0x0000,
0x1D5D,0x0000,0x0000, 0x1D60,0x0000,0x0000, 0x1D61,0x0000,0x0000,
0x1D61,0x0000,0x0000, 0x1D61,0x0000,0x0000, 0x1D45,0x0000,0x0000,
0x1D4E,0x0000,0x0000, 0x024E,0x0000,0x0000, 0x024F,0x0000,0x0000,
0x0250,0x0000,0x0000, 0x1D4A,0x1D53,0x0000, 0x1D52,0x1D52,0x0000,
0x1D3E,0x1D3E,0x0000, 0xFBC0,0x96F1,0x0000, 0xFBC0,0x96F2,0x0000,
0xFBC0,0x96F3,0x0000, 0xFBC0,0x96F4,0x0000, 0xFBC0,0x96F5,0x0000,
0xFBC0,0x96F6,0x0000, 0xFBC0,0x96F7,0x0000, 0xFBC0,0x96F8,0x0000,
0xFBC0,0x96F9,0x0000, 0xFBC0,0x96FA,0x0000, 0xFBC0,0x96FB,0x0000,
0xFBC0,0x96FC,0x0000, 0xFBC0,0x96FD,0x0000, 0xFBC0,0x96FE,0x0000,
0xFBC0,0x96FF,0x0000 };

uint16 page017data[]= { /* 1700 (3 weights per char) */
0x18E2,0x0000,0x0000, 0x18E3,0x0000,0x0000, 0x18E4,0x0000,0x0000,
0x18E5,0x0000,0x0000, 0x18E6,0x0000,0x0000, 0x18E7,0x0000,0x0000,
0x18E8,0x0000,0x0000, 0x18E9,0x0000,0x0000, 0x18EA,0x0000,0x0000,
0x18EB,0x0000,0x0000, 0x18EC,0x0000,0x0000, 0x18ED,0x0000,0x0000,
0x18EE,0x0000,0x0000, 0xFBC0,0x970D,0x0000, 0x18EF,0x0000,0x0000,
0x18F0,0x0000,0x0000, 0x18F1,0x0000,0x0000, 0x18F2,0x0000,0x0000,
0x18F3,0x0000,0x0000, 0x18F4,0x0000,0x0000, 0x18F5,0x0000,0x0000,
0xFBC0,0x9715,0x0000, 0xFBC0,0x9716,0x0000, 0xFBC0,0x9717,0x0000,
0xFBC0,0x9718,0x0000, 0xFBC0,0x9719,0x0000, 0xFBC0,0x971A,0x0000,
0xFBC0,0x971B,0x0000, 0xFBC0,0x971C,0x0000, 0xFBC0,0x971D,0x0000,
0xFBC0,0x971E,0x0000, 0xFBC0,0x971F,0x0000, 0x18F6,0x0000,0x0000,
0x18F7,0x0000,0x0000, 0x18F8,0x0000,0x0000, 0x18F9,0x0000,0x0000,
0x18FA,0x0000,0x0000, 0x18FB,0x0000,0x0000, 0x18FC,0x0000,0x0000,
0x18FD,0x0000,0x0000, 0x18FE,0x0000,0x0000, 0x18FF,0x0000,0x0000,
0x1900,0x0000,0x0000, 0x1901,0x0000,0x0000, 0x1902,0x0000,0x0000,
0x1903,0x0000,0x0000, 0x1904,0x0000,0x0000, 0x1905,0x0000,0x0000,
0x1906,0x0000,0x0000, 0x1907,0x0000,0x0000, 0x1908,0x0000,0x0000,
0x1909,0x0000,0x0000, 0x190A,0x0000,0x0000, 0x026A,0x0000,0x0000,
0x026B,0x0000,0x0000, 0xFBC0,0x9737,0x0000, 0xFBC0,0x9738,0x0000,
0xFBC0,0x9739,0x0000, 0xFBC0,0x973A,0x0000, 0xFBC0,0x973B,0x0000,
0xFBC0,0x973C,0x0000, 0xFBC0,0x973D,0x0000, 0xFBC0,0x973E,0x0000,
0xFBC0,0x973F,0x0000, 0x190B,0x0000,0x0000, 0x190C,0x0000,0x0000,
0x190D,0x0000,0x0000, 0x190E,0x0000,0x0000, 0x190F,0x0000,0x0000,
0x1910,0x0000,0x0000, 0x1911,0x0000,0x0000, 0x1912,0x0000,0x0000,
0x1913,0x0000,0x0000, 0x1914,0x0000,0x0000, 0x1915,0x0000,0x0000,
0x1916,0x0000,0x0000, 0x1917,0x0000,0x0000, 0x1918,0x0000,0x0000,
0x1919,0x0000,0x0000, 0x191A,0x0000,0x0000, 0x191B,0x0000,0x0000,
0x191C,0x0000,0x0000, 0x191D,0x0000,0x0000, 0x191E,0x0000,0x0000,
0xFBC0,0x9754,0x0000, 0xFBC0,0x9755,0x0000, 0xFBC0,0x9756,0x0000,
0xFBC0,0x9757,0x0000, 0xFBC0,0x9758,0x0000, 0xFBC0,0x9759,0x0000,
0xFBC0,0x975A,0x0000, 0xFBC0,0x975B,0x0000, 0xFBC0,0x975C,0x0000,
0xFBC0,0x975D,0x0000, 0xFBC0,0x975E,0x0000, 0xFBC0,0x975F,0x0000,
0x191F,0x0000,0x0000, 0x1920,0x0000,0x0000, 0x1921,0x0000,0x0000,
0x1922,0x0000,0x0000, 0x1923,0x0000,0x0000, 0x1924,0x0000,0x0000,
0x1925,0x0000,0x0000, 0x1926,0x0000,0x0000, 0x1927,0x0000,0x0000,
0x1928,0x0000,0x0000, 0x1929,0x0000,0x0000, 0x192A,0x0000,0x0000,
0x192B,0x0000,0x0000, 0xFBC0,0x976D,0x0000, 0x192C,0x0000,0x0000,
0x192D,0x0000,0x0000, 0x192E,0x0000,0x0000, 0xFBC0,0x9771,0x0000,
0x192F,0x0000,0x0000, 0x1930,0x0000,0x0000, 0xFBC0,0x9774,0x0000,
0xFBC0,0x9775,0x0000, 0xFBC0,0x9776,0x0000, 0xFBC0,0x9777,0x0000,
0xFBC0,0x9778,0x0000, 0xFBC0,0x9779,0x0000, 0xFBC0,0x977A,0x0000,
0xFBC0,0x977B,0x0000, 0xFBC0,0x977C,0x0000, 0xFBC0,0x977D,0x0000,
0xFBC0,0x977E,0x0000, 0xFBC0,0x977F,0x0000, 0x196C,0x0000,0x0000,
0x196D,0x0000,0x0000, 0x196E,0x0000,0x0000, 0x196F,0x0000,0x0000,
0x1970,0x0000,0x0000, 0x1971,0x0000,0x0000, 0x1972,0x0000,0x0000,
0x1973,0x0000,0x0000, 0x1974,0x0000,0x0000, 0x1975,0x0000,0x0000,
0x1976,0x0000,0x0000, 0x1977,0x0000,0x0000, 0x1978,0x0000,0x0000,
0x1979,0x0000,0x0000, 0x197A,0x0000,0x0000, 0x197B,0x0000,0x0000,
0x197C,0x0000,0x0000, 0x197D,0x0000,0x0000, 0x197E,0x0000,0x0000,
0x197F,0x0000,0x0000, 0x1980,0x0000,0x0000, 0x1981,0x0000,0x0000,
0x1982,0x0000,0x0000, 0x1983,0x0000,0x0000, 0x1984,0x0000,0x0000,
0x1985,0x0000,0x0000, 0x1986,0x0000,0x0000, 0x1987,0x0000,0x0000,
0x1988,0x0000,0x0000, 0x1989,0x0000,0x0000, 0x198A,0x0000,0x0000,
0x198B,0x0000,0x0000, 0x198C,0x0000,0x0000, 0x198D,0x0000,0x0000,
0x198E,0x0000,0x0000, 0x1990,0x0000,0x0000, 0x1991,0x0000,0x0000,
0x1992,0x0000,0x0000, 0x1993,0x0000,0x0000, 0x1994,0x0000,0x0000,
0x1995,0x0000,0x0000, 0x1996,0x0000,0x0000, 0x1997,0x0000,0x0000,
0x1998,0x0000,0x0000, 0x1999,0x0000,0x0000, 0x199A,0x0000,0x0000,
0x199B,0x0000,0x0000, 0x199C,0x0000,0x0000, 0x199D,0x0000,0x0000,
0x199E,0x0000,0x0000, 0x199F,0x0000,0x0000, 0x19A0,0x0000,0x0000,
0x19A1,0x0000,0x0000, 0x19A2,0x0000,0x0000, 0x19A3,0x0000,0x0000,
0x19A4,0x0000,0x0000, 0x19A5,0x0000,0x0000, 0x19A6,0x0000,0x0000,
0x19A7,0x0000,0x0000, 0x19A8,0x0000,0x0000, 0x19A9,0x0000,0x0000,
0x19AA,0x0000,0x0000, 0x19AB,0x0000,0x0000, 0x19AC,0x0000,0x0000,
0x19AD,0x0000,0x0000, 0x19AE,0x0000,0x0000, 0x19AF,0x0000,0x0000,
0x19B0,0x0000,0x0000, 0x19B1,0x0000,0x0000, 0x19B2,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x19B3,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x026E,0x0000,0x0000,
0x026F,0x0000,0x0000, 0x024D,0x0000,0x0000, 0x0312,0x0000,0x0000,
0x0313,0x0000,0x0000, 0x0314,0x0000,0x0000, 0x0315,0x0000,0x0000,
0x0E17,0x0000,0x0000, 0x198F,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x97DE,0x0000, 0xFBC0,0x97DF,0x0000, 0x0E29,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0xFBC0,0x97EA,0x0000, 0xFBC0,0x97EB,0x0000, 0xFBC0,0x97EC,0x0000,
0xFBC0,0x97ED,0x0000, 0xFBC0,0x97EE,0x0000, 0xFBC0,0x97EF,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0xFBC0,0x97FA,0x0000, 0xFBC0,0x97FB,0x0000,
0xFBC0,0x97FC,0x0000, 0xFBC0,0x97FD,0x0000, 0xFBC0,0x97FE,0x0000,
0xFBC0,0x97FF,0x0000 };

uint16 page018data[]= { /* 1800 (3 weights per char) */
0x02F8,0x0000,0x0000, 0x025E,0x0000,0x0000, 0x0235,0x0000,0x0000,
0x0263,0x0000,0x0000, 0x024A,0x0000,0x0000, 0x024B,0x0000,0x0000,
0x0223,0x0000,0x0000, 0x0224,0x0000,0x0000, 0x0236,0x0000,0x0000,
0x0264,0x0000,0x0000, 0x02F9,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x980F,0x0000, 0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000,
0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000,
0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000,
0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000, 0xFBC0,0x981A,0x0000,
0xFBC0,0x981B,0x0000, 0xFBC0,0x981C,0x0000, 0xFBC0,0x981D,0x0000,
0xFBC0,0x981E,0x0000, 0xFBC0,0x981F,0x0000, 0x19DF,0x0000,0x0000,
0x19E1,0x0000,0x0000, 0x19E4,0x0000,0x0000, 0x19EA,0x0000,0x0000,
0x19EC,0x0000,0x0000, 0x19EF,0x0000,0x0000, 0x19F1,0x0000,0x0000,
0x19F4,0x0000,0x0000, 0x19F5,0x0000,0x0000, 0x19F6,0x0000,0x0000,
0x19FB,0x0000,0x0000, 0x19FD,0x0000,0x0000, 0x1A00,0x0000,0x0000,
0x1A02,0x0000,0x0000, 0x1A07,0x0000,0x0000, 0x1A09,0x0000,0x0000,
0x1A0A,0x0000,0x0000, 0x1A0B,0x0000,0x0000, 0x1A12,0x0000,0x0000,
0x1A15,0x0000,0x0000, 0x1A18,0x0000,0x0000, 0x1A1D,0x0000,0x0000,
0x1A21,0x0000,0x0000, 0x1A24,0x0000,0x0000, 0x1A26,0x0000,0x0000,
0x1A28,0x0000,0x0000, 0x1A2B,0x0000,0x0000, 0x1A30,0x0000,0x0000,
0x1A31,0x0000,0x0000, 0x1A34,0x0000,0x0000, 0x1A38,0x0000,0x0000,
0x1A3B,0x0000,0x0000, 0x1A3C,0x0000,0x0000, 0x1A3D,0x0000,0x0000,
0x1A3E,0x0000,0x0000, 0x19DE,0x0000,0x0000, 0x19E2,0x0000,0x0000,
0x19E5,0x0000,0x0000, 0x19EB,0x0000,0x0000, 0x19ED,0x0000,0x0000,
0x19F0,0x0000,0x0000, 0x19F2,0x0000,0x0000, 0x19F7,0x0000,0x0000,
0x19FC,0x0000,0x0000, 0x19FE,0x0000,0x0000, 0x1A01,0x0000,0x0000,
0x1A03,0x0000,0x0000, 0x1A08,0x0000,0x0000, 0x1A13,0x0000,0x0000,
0x1A16,0x0000,0x0000, 0x1A19,0x0000,0x0000, 0x1A1E,0x0000,0x0000,
0x1A32,0x0000,0x0000, 0x1A22,0x0000,0x0000, 0x1A27,0x0000,0x0000,
0x1A2C,0x0000,0x0000, 0x1A36,0x0000,0x0000, 0x1A39,0x0000,0x0000,
0x1A3F,0x0000,0x0000, 0x1A40,0x0000,0x0000, 0x1A1B,0x0000,0x0000,
0x19E3,0x0000,0x0000, 0x19E6,0x0000,0x0000, 0x19E9,0x0000,0x0000,
0x19F3,0x0000,0x0000, 0x19EE,0x0000,0x0000, 0x19F8,0x0000,0x0000,
0x1A2D,0x0000,0x0000, 0x1A04,0x0000,0x0000, 0x1A06,0x0000,0x0000,
0x19FF,0x0000,0x0000, 0x1A0C,0x0000,0x0000, 0x1A14,0x0000,0x0000,
0x1A17,0x0000,0x0000, 0x1A1F,0x0000,0x0000, 0x1A29,0x0000,0x0000,
0x1A37,0x0000,0x0000, 0x1A3A,0x0000,0x0000, 0x1A33,0x0000,0x0000,
0x1A35,0x0000,0x0000, 0x1A41,0x0000,0x0000, 0x1A1A,0x0000,0x0000,
0x1A23,0x0000,0x0000, 0x19E7,0x0000,0x0000, 0x1A2E,0x0000,0x0000,
0x1A25,0x0000,0x0000, 0x1A2A,0x0000,0x0000, 0x1A20,0x0000,0x0000,
0xFBC0,0x9878,0x0000, 0xFBC0,0x9879,0x0000, 0xFBC0,0x987A,0x0000,
0xFBC0,0x987B,0x0000, 0xFBC0,0x987C,0x0000, 0xFBC0,0x987D,0x0000,
0xFBC0,0x987E,0x0000, 0xFBC0,0x987F,0x0000, 0x19D7,0x0000,0x0000,
0x19D8,0x0000,0x0000, 0x19D9,0x0000,0x0000, 0x19DA,0x0000,0x0000,
0x19DB,0x0000,0x0000, 0x19DC,0x0000,0x0000, 0x19DD,0x0000,0x0000,
0x19E0,0x0000,0x0000, 0x19E8,0x0000,0x0000, 0x1A2F,0x0000,0x0000,
0x19F9,0x0000,0x0000, 0x1A1C,0x0000,0x0000, 0x1A42,0x0000,0x0000,
0x1A44,0x0000,0x0000, 0x1A45,0x0000,0x0000, 0x1A47,0x0000,0x0000,
0x1A48,0x0000,0x0000, 0x1A4B,0x0000,0x0000, 0x1A4D,0x0000,0x0000,
0x1A4E,0x0000,0x0000, 0x1A50,0x0000,0x0000, 0x1A52,0x0000,0x0000,
0x1A54,0x0000,0x0000, 0x1A55,0x0000,0x0000, 0x1A49,0x0000,0x0000,
0x1A53,0x0000,0x0000, 0x1A05,0x0000,0x0000, 0x19FA,0x0000,0x0000,
0x1A0D,0x0000,0x0000, 0x1A0E,0x0000,0x0000, 0x1A43,0x0000,0x0000,
0x1A46,0x0000,0x0000, 0x1A4A,0x0000,0x0000, 0x1A4C,0x0000,0x0000,
0x1A0F,0x0000,0x0000, 0x1A51,0x0000,0x0000, 0x1A10,0x0000,0x0000,
0x1A11,0x0000,0x0000, 0x1A56,0x0000,0x0000, 0x1A57,0x0000,0x0000,
0x1A4F,0x0000,0x0000, 0x1A58,0x0000,0x0000, 0xFBC0,0x98AA,0x0000,
0xFBC0,0x98AB,0x0000, 0xFBC0,0x98AC,0x0000, 0xFBC0,0x98AD,0x0000,
0xFBC0,0x98AE,0x0000, 0xFBC0,0x98AF,0x0000, 0xFBC0,0x98B0,0x0000,
0xFBC0,0x98B1,0x0000, 0xFBC0,0x98B2,0x0000, 0xFBC0,0x98B3,0x0000,
0xFBC0,0x98B4,0x0000, 0xFBC0,0x98B5,0x0000, 0xFBC0,0x98B6,0x0000,
0xFBC0,0x98B7,0x0000, 0xFBC0,0x98B8,0x0000, 0xFBC0,0x98B9,0x0000,
0xFBC0,0x98BA,0x0000, 0xFBC0,0x98BB,0x0000, 0xFBC0,0x98BC,0x0000,
0xFBC0,0x98BD,0x0000, 0xFBC0,0x98BE,0x0000, 0xFBC0,0x98BF,0x0000,
0xFBC0,0x98C0,0x0000, 0xFBC0,0x98C1,0x0000, 0xFBC0,0x98C2,0x0000,
0xFBC0,0x98C3,0x0000, 0xFBC0,0x98C4,0x0000, 0xFBC0,0x98C5,0x0000,
0xFBC0,0x98C6,0x0000, 0xFBC0,0x98C7,0x0000, 0xFBC0,0x98C8,0x0000,
0xFBC0,0x98C9,0x0000, 0xFBC0,0x98CA,0x0000, 0xFBC0,0x98CB,0x0000,
0xFBC0,0x98CC,0x0000, 0xFBC0,0x98CD,0x0000, 0xFBC0,0x98CE,0x0000,
0xFBC0,0x98CF,0x0000, 0xFBC0,0x98D0,0x0000, 0xFBC0,0x98D1,0x0000,
0xFBC0,0x98D2,0x0000, 0xFBC0,0x98D3,0x0000, 0xFBC0,0x98D4,0x0000,
0xFBC0,0x98D5,0x0000, 0xFBC0,0x98D6,0x0000, 0xFBC0,0x98D7,0x0000,
0xFBC0,0x98D8,0x0000, 0xFBC0,0x98D9,0x0000, 0xFBC0,0x98DA,0x0000,
0xFBC0,0x98DB,0x0000, 0xFBC0,0x98DC,0x0000, 0xFBC0,0x98DD,0x0000,
0xFBC0,0x98DE,0x0000, 0xFBC0,0x98DF,0x0000, 0xFBC0,0x98E0,0x0000,
0xFBC0,0x98E1,0x0000, 0xFBC0,0x98E2,0x0000, 0xFBC0,0x98E3,0x0000,
0xFBC0,0x98E4,0x0000, 0xFBC0,0x98E5,0x0000, 0xFBC0,0x98E6,0x0000,
0xFBC0,0x98E7,0x0000, 0xFBC0,0x98E8,0x0000, 0xFBC0,0x98E9,0x0000,
0xFBC0,0x98EA,0x0000, 0xFBC0,0x98EB,0x0000, 0xFBC0,0x98EC,0x0000,
0xFBC0,0x98ED,0x0000, 0xFBC0,0x98EE,0x0000, 0xFBC0,0x98EF,0x0000,
0xFBC0,0x98F0,0x0000, 0xFBC0,0x98F1,0x0000, 0xFBC0,0x98F2,0x0000,
0xFBC0,0x98F3,0x0000, 0xFBC0,0x98F4,0x0000, 0xFBC0,0x98F5,0x0000,
0xFBC0,0x98F6,0x0000, 0xFBC0,0x98F7,0x0000, 0xFBC0,0x98F8,0x0000,
0xFBC0,0x98F9,0x0000, 0xFBC0,0x98FA,0x0000, 0xFBC0,0x98FB,0x0000,
0xFBC0,0x98FC,0x0000, 0xFBC0,0x98FD,0x0000, 0xFBC0,0x98FE,0x0000,
0xFBC0,0x98FF,0x0000 };

uint16 page019data[]= { /* 1900 (3 weights per char) */
0x18B0,0x0000,0x0000, 0x18B1,0x0000,0x0000, 0x18B2,0x0000,0x0000,
0x18B3,0x0000,0x0000, 0x18B4,0x0000,0x0000, 0x18B5,0x0000,0x0000,
0x18B6,0x0000,0x0000, 0x18B7,0x0000,0x0000, 0x18B8,0x0000,0x0000,
0x18B9,0x0000,0x0000, 0x18BA,0x0000,0x0000, 0x18BB,0x0000,0x0000,
0x18BC,0x0000,0x0000, 0x18BD,0x0000,0x0000, 0x18BE,0x0000,0x0000,
0x18BF,0x0000,0x0000, 0x18C0,0x0000,0x0000, 0x18C1,0x0000,0x0000,
0x18C2,0x0000,0x0000, 0x18C3,0x0000,0x0000, 0x18C4,0x0000,0x0000,
0x18C5,0x0000,0x0000, 0x18C6,0x0000,0x0000, 0x18C7,0x0000,0x0000,
0x18C8,0x0000,0x0000, 0x18C9,0x0000,0x0000, 0x18CA,0x0000,0x0000,
0x18CB,0x0000,0x0000, 0x18CC,0x0000,0x0000, 0xFBC0,0x991D,0x0000,
0xFBC0,0x991E,0x0000, 0xFBC0,0x991F,0x0000, 0x18CD,0x0000,0x0000,
0x18CE,0x0000,0x0000, 0x18CF,0x0000,0x0000, 0x18D0,0x0000,0x0000,
0x18D1,0x0000,0x0000, 0x18D2,0x0000,0x0000, 0x18D3,0x0000,0x0000,
0x18D4,0x0000,0x0000, 0x18D5,0x0000,0x0000, 0x18D6,0x0000,0x0000,
0x18D7,0x0000,0x0000, 0x18D8,0x0000,0x0000, 0xFBC0,0x992C,0x0000,
0xFBC0,0x992D,0x0000, 0xFBC0,0x992E,0x0000, 0xFBC0,0x992F,0x0000,
0x18D9,0x0000,0x0000, 0x18DA,0x0000,0x0000, 0x18DB,0x0000,0x0000,
0x18DC,0x0000,0x0000, 0x18DD,0x0000,0x0000, 0x18DE,0x0000,0x0000,
0x18DF,0x0000,0x0000, 0x18E0,0x0000,0x0000, 0x18E1,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x993C,0x0000, 0xFBC0,0x993D,0x0000, 0xFBC0,0x993E,0x0000,
0xFBC0,0x993F,0x0000, 0x030D,0x0000,0x0000, 0xFBC0,0x9941,0x0000,
0xFBC0,0x9942,0x0000, 0xFBC0,0x9943,0x0000, 0x0254,0x0000,0x0000,
0x025B,0x0000,0x0000, 0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000,
0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000,
0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000,
0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000, 0x19B4,0x0000,0x0000,
0x19B5,0x0000,0x0000, 0x19B6,0x0000,0x0000, 0x19B7,0x0000,0x0000,
0x19B8,0x0000,0x0000, 0x19B9,0x0000,0x0000, 0x19BA,0x0000,0x0000,
0x19BB,0x0000,0x0000, 0x19BC,0x0000,0x0000, 0x19BD,0x0000,0x0000,
0x19BE,0x0000,0x0000, 0x19BF,0x0000,0x0000, 0x19C0,0x0000,0x0000,
0x19C1,0x0000,0x0000, 0x19C2,0x0000,0x0000, 0x19C3,0x0000,0x0000,
0x19C4,0x0000,0x0000, 0x19C5,0x0000,0x0000, 0x19C6,0x0000,0x0000,
0x19C7,0x0000,0x0000, 0x19C8,0x0000,0x0000, 0x19C9,0x0000,0x0000,
0x19CA,0x0000,0x0000, 0x19CB,0x0000,0x0000, 0x19CC,0x0000,0x0000,
0x19CD,0x0000,0x0000, 0x19CE,0x0000,0x0000, 0x19CF,0x0000,0x0000,
0x19D0,0x0000,0x0000, 0x19D1,0x0000,0x0000, 0xFBC0,0x996E,0x0000,
0xFBC0,0x996F,0x0000, 0x19D2,0x0000,0x0000, 0x19D3,0x0000,0x0000,
0x19D4,0x0000,0x0000, 0x19D5,0x0000,0x0000, 0x19D6,0x0000,0x0000,
0xFBC0,0x9975,0x0000, 0xFBC0,0x9976,0x0000, 0xFBC0,0x9977,0x0000,
0xFBC0,0x9978,0x0000, 0xFBC0,0x9979,0x0000, 0xFBC0,0x997A,0x0000,
0xFBC0,0x997B,0x0000, 0xFBC0,0x997C,0x0000, 0xFBC0,0x997D,0x0000,
0xFBC0,0x997E,0x0000, 0xFBC0,0x997F,0x0000, 0xFBC0,0x9980,0x0000,
0xFBC0,0x9981,0x0000, 0xFBC0,0x9982,0x0000, 0xFBC0,0x9983,0x0000,
0xFBC0,0x9984,0x0000, 0xFBC0,0x9985,0x0000, 0xFBC0,0x9986,0x0000,
0xFBC0,0x9987,0x0000, 0xFBC0,0x9988,0x0000, 0xFBC0,0x9989,0x0000,
0xFBC0,0x998A,0x0000, 0xFBC0,0x998B,0x0000, 0xFBC0,0x998C,0x0000,
0xFBC0,0x998D,0x0000, 0xFBC0,0x998E,0x0000, 0xFBC0,0x998F,0x0000,
0xFBC0,0x9990,0x0000, 0xFBC0,0x9991,0x0000, 0xFBC0,0x9992,0x0000,
0xFBC0,0x9993,0x0000, 0xFBC0,0x9994,0x0000, 0xFBC0,0x9995,0x0000,
0xFBC0,0x9996,0x0000, 0xFBC0,0x9997,0x0000, 0xFBC0,0x9998,0x0000,
0xFBC0,0x9999,0x0000, 0xFBC0,0x999A,0x0000, 0xFBC0,0x999B,0x0000,
0xFBC0,0x999C,0x0000, 0xFBC0,0x999D,0x0000, 0xFBC0,0x999E,0x0000,
0xFBC0,0x999F,0x0000, 0xFBC0,0x99A0,0x0000, 0xFBC0,0x99A1,0x0000,
0xFBC0,0x99A2,0x0000, 0xFBC0,0x99A3,0x0000, 0xFBC0,0x99A4,0x0000,
0xFBC0,0x99A5,0x0000, 0xFBC0,0x99A6,0x0000, 0xFBC0,0x99A7,0x0000,
0xFBC0,0x99A8,0x0000, 0xFBC0,0x99A9,0x0000, 0xFBC0,0x99AA,0x0000,
0xFBC0,0x99AB,0x0000, 0xFBC0,0x99AC,0x0000, 0xFBC0,0x99AD,0x0000,
0xFBC0,0x99AE,0x0000, 0xFBC0,0x99AF,0x0000, 0xFBC0,0x99B0,0x0000,
0xFBC0,0x99B1,0x0000, 0xFBC0,0x99B2,0x0000, 0xFBC0,0x99B3,0x0000,
0xFBC0,0x99B4,0x0000, 0xFBC0,0x99B5,0x0000, 0xFBC0,0x99B6,0x0000,
0xFBC0,0x99B7,0x0000, 0xFBC0,0x99B8,0x0000, 0xFBC0,0x99B9,0x0000,
0xFBC0,0x99BA,0x0000, 0xFBC0,0x99BB,0x0000, 0xFBC0,0x99BC,0x0000,
0xFBC0,0x99BD,0x0000, 0xFBC0,0x99BE,0x0000, 0xFBC0,0x99BF,0x0000,
0xFBC0,0x99C0,0x0000, 0xFBC0,0x99C1,0x0000, 0xFBC0,0x99C2,0x0000,
0xFBC0,0x99C3,0x0000, 0xFBC0,0x99C4,0x0000, 0xFBC0,0x99C5,0x0000,
0xFBC0,0x99C6,0x0000, 0xFBC0,0x99C7,0x0000, 0xFBC0,0x99C8,0x0000,
0xFBC0,0x99C9,0x0000, 0xFBC0,0x99CA,0x0000, 0xFBC0,0x99CB,0x0000,
0xFBC0,0x99CC,0x0000, 0xFBC0,0x99CD,0x0000, 0xFBC0,0x99CE,0x0000,
0xFBC0,0x99CF,0x0000, 0xFBC0,0x99D0,0x0000, 0xFBC0,0x99D1,0x0000,
0xFBC0,0x99D2,0x0000, 0xFBC0,0x99D3,0x0000, 0xFBC0,0x99D4,0x0000,
0xFBC0,0x99D5,0x0000, 0xFBC0,0x99D6,0x0000, 0xFBC0,0x99D7,0x0000,
0xFBC0,0x99D8,0x0000, 0xFBC0,0x99D9,0x0000, 0xFBC0,0x99DA,0x0000,
0xFBC0,0x99DB,0x0000, 0xFBC0,0x99DC,0x0000, 0xFBC0,0x99DD,0x0000,
0xFBC0,0x99DE,0x0000, 0xFBC0,0x99DF,0x0000, 0x037B,0x0000,0x0000,
0x037C,0x0000,0x0000, 0x037D,0x0000,0x0000, 0x037E,0x0000,0x0000,
0x037F,0x0000,0x0000, 0x0380,0x0000,0x0000, 0x0381,0x0000,0x0000,
0x0382,0x0000,0x0000, 0x0383,0x0000,0x0000, 0x0384,0x0000,0x0000,
0x0385,0x0000,0x0000, 0x0386,0x0000,0x0000, 0x0387,0x0000,0x0000,
0x0388,0x0000,0x0000, 0x0389,0x0000,0x0000, 0x038A,0x0000,0x0000,
0x038B,0x0000,0x0000, 0x038C,0x0000,0x0000, 0x038D,0x0000,0x0000,
0x038E,0x0000,0x0000, 0x038F,0x0000,0x0000, 0x0390,0x0000,0x0000,
0x0391,0x0000,0x0000, 0x0392,0x0000,0x0000, 0x0393,0x0000,0x0000,
0x0394,0x0000,0x0000, 0x0395,0x0000,0x0000, 0x0396,0x0000,0x0000,
0x0397,0x0000,0x0000, 0x0398,0x0000,0x0000, 0x0399,0x0000,0x0000,
0x039A,0x0000,0x0000 };

uint16 page01Ddata[]= { /* 1D00 (3 weights per char) */
0x0E37,0x0000,0x0000, 0x0E3C,0x0000,0x0000, 0x0E3D,0x0000,0x0000,
0x0E57,0x0000,0x0000, 0x0E64,0x0000,0x0000, 0x0E71,0x0000,0x0000,
0x0E8A,0x0000,0x0000, 0x0E8F,0x0000,0x0000, 0x0EA8,0x0000,0x0000,
0x0F07,0x0000,0x0000, 0x0F14,0x0000,0x0000, 0x0F25,0x0000,0x0000,
0x0F3A,0x0000,0x0000, 0x0F5F,0x0000,0x0000, 0x0F6D,0x0000,0x0000,
0x0F86,0x0000,0x0000, 0x0F96,0x0000,0x0000, 0x0F87,0x0000,0x0000,
0x0F97,0x0000,0x0000, 0x0F91,0x0000,0x0000, 0x0F8C,0x0000,0x0000,
0x0FA6,0x0000,0x0000, 0x0F98,0x0000,0x0000, 0x0F99,0x0000,0x0000,
0x0FAB,0x0000,0x0000, 0x0FC8,0x0000,0x0000, 0x0FCD,0x0000,0x0000,
0x1006,0x0000,0x0000, 0x1023,0x0000,0x0000, 0x1024,0x0000,0x0000,
0x1025,0x0000,0x0000, 0x103B,0x0000,0x0000, 0x1048,0x0000,0x0000,
0x1055,0x0000,0x0000, 0x106E,0x0000,0x0000, 0x1083,0x0000,0x0000,
0x10BA,0x0000,0x0000, 0x10BB,0x0000,0x0000, 0x10EB,0x0000,0x0000,
0x10F7,0x0000,0x0000, 0x10FD,0x0000,0x0000, 0x1101,0x0000,0x0000,
0x1108,0x0000,0x0000, 0x11B4,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E38,0x0000,0x0000, 0x0E4A,0x0000,0x0000, 0x0E56,0x0000,0x0000,
0x0E6D,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E90,0x0000,0x0000,
0x0EC1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0F10,0x0000,0x0000, 0x0F21,0x0000,0x0000, 0x0F2E,0x0000,0x0000,
0x0F5B,0x0000,0x0000, 0x0F64,0x0000,0x0000, 0x0F6C,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0FA2,0x0000,0x0000, 0x0FA7,0x0000,0x0000,
0x0FC0,0x0000,0x0000, 0x1002,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x1051,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E3E,0x0000,0x0000,
0x0E42,0x0000,0x0000, 0x0E3D,0x0000,0x0000, 0x0E4A,0x0000,0x0000,
0x0E6D,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E94,0x0000,0x0000,
0x0E98,0x0000,0x0000, 0x0EA8,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0F07,0x0000,0x0000, 0x0F21,0x0000,0x0000, 0x0F5B,0x0000,0x0000,
0x0F7E,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F92,0x0000,0x0000,
0x0F98,0x0000,0x0000, 0x0F99,0x0000,0x0000, 0x0FA7,0x0000,0x0000,
0x1002,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x1024,0x0000,0x0000,
0x1037,0x0000,0x0000, 0x1044,0x0000,0x0000, 0x10BB,0x0000,0x0000,
0x10E9,0x0000,0x0000, 0x10EA,0x0000,0x0000, 0x10EC,0x0000,0x0000,
0x1105,0x0000,0x0000, 0x1106,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0FC0,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x1044,0x0000,0x0000,
0x10E9,0x0000,0x0000, 0x10EA,0x0000,0x0000, 0x1100,0x0000,0x0000,
0x1105,0x0000,0x0000, 0x1106,0x0000,0x0000, 0x1026,0x0000,0x0000,
0xFBC0,0x9D6C,0x0000, 0xFBC0,0x9D6D,0x0000, 0xFBC0,0x9D6E,0x0000,
0xFBC0,0x9D6F,0x0000, 0xFBC0,0x9D70,0x0000, 0xFBC0,0x9D71,0x0000,
0xFBC0,0x9D72,0x0000, 0xFBC0,0x9D73,0x0000, 0xFBC0,0x9D74,0x0000,
0xFBC0,0x9D75,0x0000, 0xFBC0,0x9D76,0x0000, 0xFBC0,0x9D77,0x0000,
0xFBC0,0x9D78,0x0000, 0xFBC0,0x9D79,0x0000, 0xFBC0,0x9D7A,0x0000,
0xFBC0,0x9D7B,0x0000, 0xFBC0,0x9D7C,0x0000, 0xFBC0,0x9D7D,0x0000,
0xFBC0,0x9D7E,0x0000, 0xFBC0,0x9D7F,0x0000, 0xFBC0,0x9D80,0x0000,
0xFBC0,0x9D81,0x0000, 0xFBC0,0x9D82,0x0000, 0xFBC0,0x9D83,0x0000,
0xFBC0,0x9D84,0x0000, 0xFBC0,0x9D85,0x0000, 0xFBC0,0x9D86,0x0000,
0xFBC0,0x9D87,0x0000, 0xFBC0,0x9D88,0x0000, 0xFBC0,0x9D89,0x0000,
0xFBC0,0x9D8A,0x0000, 0xFBC0,0x9D8B,0x0000, 0xFBC0,0x9D8C,0x0000,
0xFBC0,0x9D8D,0x0000, 0xFBC0,0x9D8E,0x0000, 0xFBC0,0x9D8F,0x0000,
0xFBC0,0x9D90,0x0000, 0xFBC0,0x9D91,0x0000, 0xFBC0,0x9D92,0x0000,
0xFBC0,0x9D93,0x0000, 0xFBC0,0x9D94,0x0000, 0xFBC0,0x9D95,0x0000,
0xFBC0,0x9D96,0x0000, 0xFBC0,0x9D97,0x0000, 0xFBC0,0x9D98,0x0000,
0xFBC0,0x9D99,0x0000, 0xFBC0,0x9D9A,0x0000, 0xFBC0,0x9D9B,0x0000,
0xFBC0,0x9D9C,0x0000, 0xFBC0,0x9D9D,0x0000, 0xFBC0,0x9D9E,0x0000,
0xFBC0,0x9D9F,0x0000, 0xFBC0,0x9DA0,0x0000, 0xFBC0,0x9DA1,0x0000,
0xFBC0,0x9DA2,0x0000, 0xFBC0,0x9DA3,0x0000, 0xFBC0,0x9DA4,0x0000,
0xFBC0,0x9DA5,0x0000, 0xFBC0,0x9DA6,0x0000, 0xFBC0,0x9DA7,0x0000,
0xFBC0,0x9DA8,0x0000, 0xFBC0,0x9DA9,0x0000, 0xFBC0,0x9DAA,0x0000,
0xFBC0,0x9DAB,0x0000, 0xFBC0,0x9DAC,0x0000, 0xFBC0,0x9DAD,0x0000,
0xFBC0,0x9DAE,0x0000, 0xFBC0,0x9DAF,0x0000, 0xFBC0,0x9DB0,0x0000,
0xFBC0,0x9DB1,0x0000, 0xFBC0,0x9DB2,0x0000, 0xFBC0,0x9DB3,0x0000,
0xFBC0,0x9DB4,0x0000, 0xFBC0,0x9DB5,0x0000, 0xFBC0,0x9DB6,0x0000,
0xFBC0,0x9DB7,0x0000, 0xFBC0,0x9DB8,0x0000, 0xFBC0,0x9DB9,0x0000,
0xFBC0,0x9DBA,0x0000, 0xFBC0,0x9DBB,0x0000, 0xFBC0,0x9DBC,0x0000,
0xFBC0,0x9DBD,0x0000, 0xFBC0,0x9DBE,0x0000, 0xFBC0,0x9DBF,0x0000,
0xFBC0,0x9DC0,0x0000, 0xFBC0,0x9DC1,0x0000, 0xFBC0,0x9DC2,0x0000,
0xFBC0,0x9DC3,0x0000, 0xFBC0,0x9DC4,0x0000, 0xFBC0,0x9DC5,0x0000,
0xFBC0,0x9DC6,0x0000, 0xFBC0,0x9DC7,0x0000, 0xFBC0,0x9DC8,0x0000,
0xFBC0,0x9DC9,0x0000, 0xFBC0,0x9DCA,0x0000, 0xFBC0,0x9DCB,0x0000,
0xFBC0,0x9DCC,0x0000, 0xFBC0,0x9DCD,0x0000, 0xFBC0,0x9DCE,0x0000,
0xFBC0,0x9DCF,0x0000, 0xFBC0,0x9DD0,0x0000, 0xFBC0,0x9DD1,0x0000,
0xFBC0,0x9DD2,0x0000, 0xFBC0,0x9DD3,0x0000, 0xFBC0,0x9DD4,0x0000,
0xFBC0,0x9DD5,0x0000, 0xFBC0,0x9DD6,0x0000, 0xFBC0,0x9DD7,0x0000,
0xFBC0,0x9DD8,0x0000, 0xFBC0,0x9DD9,0x0000, 0xFBC0,0x9DDA,0x0000,
0xFBC0,0x9DDB,0x0000, 0xFBC0,0x9DDC,0x0000, 0xFBC0,0x9DDD,0x0000,
0xFBC0,0x9DDE,0x0000, 0xFBC0,0x9DDF,0x0000, 0xFBC0,0x9DE0,0x0000,
0xFBC0,0x9DE1,0x0000, 0xFBC0,0x9DE2,0x0000, 0xFBC0,0x9DE3,0x0000,
0xFBC0,0x9DE4,0x0000, 0xFBC0,0x9DE5,0x0000, 0xFBC0,0x9DE6,0x0000,
0xFBC0,0x9DE7,0x0000, 0xFBC0,0x9DE8,0x0000, 0xFBC0,0x9DE9,0x0000,
0xFBC0,0x9DEA,0x0000, 0xFBC0,0x9DEB,0x0000, 0xFBC0,0x9DEC,0x0000,
0xFBC0,0x9DED,0x0000, 0xFBC0,0x9DEE,0x0000, 0xFBC0,0x9DEF,0x0000,
0xFBC0,0x9DF0,0x0000, 0xFBC0,0x9DF1,0x0000, 0xFBC0,0x9DF2,0x0000,
0xFBC0,0x9DF3,0x0000, 0xFBC0,0x9DF4,0x0000, 0xFBC0,0x9DF5,0x0000,
0xFBC0,0x9DF6,0x0000, 0xFBC0,0x9DF7,0x0000, 0xFBC0,0x9DF8,0x0000,
0xFBC0,0x9DF9,0x0000, 0xFBC0,0x9DFA,0x0000, 0xFBC0,0x9DFB,0x0000,
0xFBC0,0x9DFC,0x0000, 0xFBC0,0x9DFD,0x0000, 0xFBC0,0x9DFE,0x0000,
0xFBC0,0x9DFF,0x0000 };

uint16 page01Edata[]= { /* 1E00 (3 weights per char) */
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E4A,0x0000,0x0000,
0x0E4A,0x0000,0x0000, 0x0E4A,0x0000,0x0000, 0x0E4A,0x0000,0x0000,
0x0E4A,0x0000,0x0000, 0x0E4A,0x0000,0x0000, 0x0E60,0x0000,0x0000,
0x0E60,0x0000,0x0000, 0x0E6D,0x0000,0x0000, 0x0E6D,0x0000,0x0000,
0x0E6D,0x0000,0x0000, 0x0E6D,0x0000,0x0000, 0x0E6D,0x0000,0x0000,
0x0E6D,0x0000,0x0000, 0x0E6D,0x0000,0x0000, 0x0E6D,0x0000,0x0000,
0x0E6D,0x0000,0x0000, 0x0E6D,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0EB9,0x0000,0x0000, 0x0EB9,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0EC1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000,
0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000,
0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000,
0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0F21,0x0000,0x0000, 0x0F21,0x0000,0x0000, 0x0F21,0x0000,0x0000,
0x0F21,0x0000,0x0000, 0x0F21,0x0000,0x0000, 0x0F21,0x0000,0x0000,
0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000,
0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000,
0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000, 0x0F5B,0x0000,0x0000,
0x0F5B,0x0000,0x0000, 0x0F5B,0x0000,0x0000, 0x0F5B,0x0000,0x0000,
0x0F5B,0x0000,0x0000, 0x0F5B,0x0000,0x0000, 0x0F64,0x0000,0x0000,
0x0F64,0x0000,0x0000, 0x0F64,0x0000,0x0000, 0x0F64,0x0000,0x0000,
0x0F64,0x0000,0x0000, 0x0F64,0x0000,0x0000, 0x0F64,0x0000,0x0000,
0x0F64,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0FA7,0x0000,0x0000, 0x0FA7,0x0000,0x0000, 0x0FA7,0x0000,0x0000,
0x0FA7,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x1002,0x0000,0x0000, 0x1002,0x0000,0x0000,
0x1002,0x0000,0x0000, 0x1002,0x0000,0x0000, 0x1002,0x0000,0x0000,
0x1002,0x0000,0x0000, 0x1002,0x0000,0x0000, 0x1002,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x1044,0x0000,0x0000, 0x1044,0x0000,0x0000,
0x1044,0x0000,0x0000, 0x1044,0x0000,0x0000, 0x1051,0x0000,0x0000,
0x1051,0x0000,0x0000, 0x1051,0x0000,0x0000, 0x1051,0x0000,0x0000,
0x1051,0x0000,0x0000, 0x1051,0x0000,0x0000, 0x1051,0x0000,0x0000,
0x1051,0x0000,0x0000, 0x1051,0x0000,0x0000, 0x1051,0x0000,0x0000,
0x105A,0x0000,0x0000, 0x105A,0x0000,0x0000, 0x105A,0x0000,0x0000,
0x105A,0x0000,0x0000, 0x105E,0x0000,0x0000, 0x105E,0x0000,0x0000,
0x106A,0x0000,0x0000, 0x106A,0x0000,0x0000, 0x106A,0x0000,0x0000,
0x106A,0x0000,0x0000, 0x106A,0x0000,0x0000, 0x106A,0x0000,0x0000,
0x0EE1,0x0000,0x0000, 0x1002,0x0000,0x0000, 0x1051,0x0000,0x0000,
0x105E,0x0000,0x0000, 0x0E33,0x10B3,0x0000, 0x0FEA,0x0000,0x0000,
0xFBC0,0x9E9C,0x0000, 0xFBC0,0x9E9D,0x0000, 0xFBC0,0x9E9E,0x0000,
0xFBC0,0x9E9F,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x105E,0x0000,0x0000,
0x105E,0x0000,0x0000, 0x105E,0x0000,0x0000, 0x105E,0x0000,0x0000,
0x105E,0x0000,0x0000, 0x105E,0x0000,0x0000, 0x105E,0x0000,0x0000,
0x105E,0x0000,0x0000, 0xFBC0,0x9EFA,0x0000, 0xFBC0,0x9EFB,0x0000,
0xFBC0,0x9EFC,0x0000, 0xFBC0,0x9EFD,0x0000, 0xFBC0,0x9EFE,0x0000,
0xFBC0,0x9EFF,0x0000 };

uint16 page01Fdata[]= { /* 1F00 (3 weights per char) */
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000,
0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000,
0x10ED,0x0000,0x0000, 0xFBC0,0x9F16,0x0000, 0xFBC0,0x9F17,0x0000,
0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000,
0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000,
0xFBC0,0x9F1E,0x0000, 0xFBC0,0x9F1F,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000,
0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000,
0x10FB,0x0000,0x0000, 0xFBC0,0x9F46,0x0000, 0xFBC0,0x9F47,0x0000,
0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000,
0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000,
0xFBC0,0x9F4E,0x0000, 0xFBC0,0x9F4F,0x0000, 0x1104,0x0000,0x0000,
0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000,
0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000,
0x1104,0x0000,0x0000, 0xFBC0,0x9F58,0x0000, 0x1104,0x0000,0x0000,
0xFBC0,0x9F5A,0x0000, 0x1104,0x0000,0x0000, 0xFBC0,0x9F5C,0x0000,
0x1104,0x0000,0x0000, 0xFBC0,0x9F5E,0x0000, 0x1104,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000, 0x1104,0x0000,0x0000,
0x1104,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0xFBC0,0x9F7E,0x0000, 0xFBC0,0x9F7F,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0xFBC0,0x9FB5,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x0217,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x0217,0x0000,0x0000,
0x021D,0x0000,0x0000, 0x0214,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0xFBC0,0x9FC5,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10ED,0x0000,0x0000,
0x10ED,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x0217,0x0000,0x0000, 0x0217,0x0000,0x0000,
0x0217,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0xFBC0,0x9FD4,0x0000,
0xFBC0,0x9FD5,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0xFBC0,0x9FDC,0x0000, 0x0218,0x0000,0x0000,
0x0218,0x0000,0x0000, 0x0218,0x0000,0x0000, 0x1104,0x0000,0x0000,
0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000,
0x1100,0x0000,0x0000, 0x1100,0x0000,0x0000, 0x1104,0x0000,0x0000,
0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000,
0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000, 0x1100,0x0000,0x0000,
0x0214,0x0000,0x0000, 0x0214,0x0000,0x0000, 0x020C,0x0000,0x0000,
0xFBC0,0x9FF0,0x0000, 0xFBC0,0x9FF1,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0xFBC0,0x9FF5,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x10FB,0x0000,0x0000,
0x10FB,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x020D,0x0000,0x0000, 0x0218,0x0000,0x0000,
0xFBC0,0x9FFF,0x0000 };

uint16 page020data[]= { /* 2000 (5 weights per char) */
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0225,0x0000,0x0000,0x0000,0x0000,
0x0225,0x0000,0x0000,0x0000,0x0000,
0x0226,0x0000,0x0000,0x0000,0x0000,
0x0227,0x0000,0x0000,0x0000,0x0000,
0x0228,0x0000,0x0000,0x0000,0x0000,
0x0229,0x0000,0x0000,0x0000,0x0000,
0x0432,0x0000,0x0000,0x0000,0x0000,
0x021C,0x0000,0x0000,0x0000,0x0000,
0x0278,0x0000,0x0000,0x0000,0x0000,
0x0279,0x0000,0x0000,0x0000,0x0000,
0x027A,0x0000,0x0000,0x0000,0x0000,
0x027B,0x0000,0x0000,0x0000,0x0000,
0x027F,0x0000,0x0000,0x0000,0x0000,
0x0280,0x0000,0x0000,0x0000,0x0000,
0x0281,0x0000,0x0000,0x0000,0x0000,
0x0282,0x0000,0x0000,0x0000,0x0000,
0x02D8,0x0000,0x0000,0x0000,0x0000,
0x02D9,0x0000,0x0000,0x0000,0x0000,
0x02DA,0x0000,0x0000,0x0000,0x0000,
0x02DB,0x0000,0x0000,0x0000,0x0000,
0x025D,0x0000,0x0000,0x0000,0x0000,
0x025D,0x025D,0x0000,0x0000,0x0000,
0x025D,0x025D,0x025D,0x0000,0x0000,
0x02DC,0x0000,0x0000,0x0000,0x0000,
0x0207,0x0000,0x0000,0x0000,0x0000,
0x0208,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x02D5,0x0000,0x0000,0x0000,0x0000,
0x02D6,0x0000,0x0000,0x0000,0x0000,
0x02E0,0x0000,0x0000,0x0000,0x0000,
0x02E0,0x02E0,0x0000,0x0000,0x0000,
0x02E0,0x02E0,0x02E0,0x0000,0x0000,
0x02E1,0x0000,0x0000,0x0000,0x0000,
0x02E1,0x02E1,0x0000,0x0000,0x0000,
0x02E1,0x02E1,0x02E1,0x0000,0x0000,
0x02E4,0x0000,0x0000,0x0000,0x0000,
0x027C,0x0000,0x0000,0x0000,0x0000,
0x027D,0x0000,0x0000,0x0000,0x0000,
0x02E5,0x0000,0x0000,0x0000,0x0000,
0x0251,0x0251,0x0000,0x0000,0x0000,
0x025C,0x0000,0x0000,0x0000,0x0000,
0x0211,0x0000,0x0000,0x0000,0x0000,
0x02E6,0x0000,0x0000,0x0000,0x0000,
0x02E8,0x0000,0x0000,0x0000,0x0000,
0x02EA,0x0000,0x0000,0x0000,0x0000,
0x02EB,0x0000,0x0000,0x0000,0x0000,
0x02DD,0x0000,0x0000,0x0000,0x0000,
0x02CD,0x0000,0x0000,0x0000,0x0000,
0x0294,0x0000,0x0000,0x0000,0x0000,
0x0295,0x0000,0x0000,0x0000,0x0000,
0x0255,0x0255,0x0000,0x0000,0x0000,
0x0255,0x0251,0x0000,0x0000,0x0000,
0x0251,0x0255,0x0000,0x0000,0x0000,
0x02D1,0x0000,0x0000,0x0000,0x0000,
0x02C4,0x0000,0x0000,0x0000,0x0000,
0x02DE,0x0000,0x0000,0x0000,0x0000,
0x02DF,0x0000,0x0000,0x0000,0x0000,
0x02C9,0x0000,0x0000,0x0000,0x0000,
0x023C,0x0000,0x0000,0x0000,0x0000,
0x02E9,0x0000,0x0000,0x0000,0x0000,
0x02CA,0x0000,0x0000,0x0000,0x0000,
0x02D7,0x0000,0x0000,0x0000,0x0000,
0x022A,0x0000,0x0000,0x0000,0x0000,
0x02E7,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA055,0x0000,0x0000,0x0000,
0xFBC0,0xA056,0x0000,0x0000,0x0000,
0x02E0,0x02E0,0x02E0,0x02E0,0x0000,
0xFBC0,0xA058,0x0000,0x0000,0x0000,
0xFBC0,0xA059,0x0000,0x0000,0x0000,
0xFBC0,0xA05A,0x0000,0x0000,0x0000,
0xFBC0,0xA05B,0x0000,0x0000,0x0000,
0xFBC0,0xA05C,0x0000,0x0000,0x0000,
0xFBC0,0xA05D,0x0000,0x0000,0x0000,
0xFBC0,0xA05E,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA064,0x0000,0x0000,0x0000,
0xFBC0,0xA065,0x0000,0x0000,0x0000,
0xFBC0,0xA066,0x0000,0x0000,0x0000,
0xFBC0,0xA067,0x0000,0x0000,0x0000,
0xFBC0,0xA068,0x0000,0x0000,0x0000,
0xFBC0,0xA069,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E29,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA072,0x0000,0x0000,0x0000,
0xFBC0,0xA073,0x0000,0x0000,0x0000,
0x0E2D,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0x0000,0x0000,0x0000,0x0000,
0x0E2F,0x0000,0x0000,0x0000,0x0000,
0x0E30,0x0000,0x0000,0x0000,0x0000,
0x0E31,0x0000,0x0000,0x0000,0x0000,
0x0E32,0x0000,0x0000,0x0000,0x0000,
0x0428,0x0000,0x0000,0x0000,0x0000,
0x0434,0x0000,0x0000,0x0000,0x0000,
0x042D,0x0000,0x0000,0x0000,0x0000,
0x0288,0x0000,0x0000,0x0000,0x0000,
0x0289,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0000,0x0000,0x0000,0x0000,
0x0E29,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0x0000,0x0000,0x0000,0x0000,
0x0E2F,0x0000,0x0000,0x0000,0x0000,
0x0E30,0x0000,0x0000,0x0000,0x0000,
0x0E31,0x0000,0x0000,0x0000,0x0000,
0x0E32,0x0000,0x0000,0x0000,0x0000,
0x0428,0x0000,0x0000,0x0000,0x0000,
0x0434,0x0000,0x0000,0x0000,0x0000,
0x042D,0x0000,0x0000,0x0000,0x0000,
0x0288,0x0000,0x0000,0x0000,0x0000,
0x0289,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA08F,0x0000,0x0000,0x0000,
0xFBC0,0xA090,0x0000,0x0000,0x0000,
0xFBC0,0xA091,0x0000,0x0000,0x0000,
0xFBC0,0xA092,0x0000,0x0000,0x0000,
0xFBC0,0xA093,0x0000,0x0000,0x0000,
0xFBC0,0xA094,0x0000,0x0000,0x0000,
0xFBC0,0xA095,0x0000,0x0000,0x0000,
0xFBC0,0xA096,0x0000,0x0000,0x0000,
0xFBC0,0xA097,0x0000,0x0000,0x0000,
0xFBC0,0xA098,0x0000,0x0000,0x0000,
0xFBC0,0xA099,0x0000,0x0000,0x0000,
0xFBC0,0xA09A,0x0000,0x0000,0x0000,
0xFBC0,0xA09B,0x0000,0x0000,0x0000,
0xFBC0,0xA09C,0x0000,0x0000,0x0000,
0xFBC0,0xA09D,0x0000,0x0000,0x0000,
0xFBC0,0xA09E,0x0000,0x0000,0x0000,
0xFBC0,0xA09F,0x0000,0x0000,0x0000,
0x0E18,0x0000,0x0000,0x0000,0x0000,
0x0E19,0x0000,0x0000,0x0000,0x0000,
0x0E1A,0x0000,0x0000,0x0000,0x0000,
0x0E1B,0x0000,0x0000,0x0000,0x0000,
0x0E1C,0x0000,0x0000,0x0000,0x0000,
0x0E1D,0x0000,0x0000,0x0000,0x0000,
0x0E1E,0x0000,0x0000,0x0000,0x0000,
0x0E1F,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0FEA,0x0000,0x0000,0x0000,
0x0E20,0x0000,0x0000,0x0000,0x0000,
0x0E21,0x0000,0x0000,0x0000,0x0000,
0x0E22,0x0000,0x0000,0x0000,0x0000,
0x0E23,0x0000,0x0000,0x0000,0x0000,
0x0E24,0x0000,0x0000,0x0000,0x0000,
0x0E25,0x0000,0x0000,0x0000,0x0000,
0x0E26,0x0000,0x0000,0x0000,0x0000,
0x0E27,0x0000,0x0000,0x0000,0x0000,
0x0E28,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA0B2,0x0000,0x0000,0x0000,
0xFBC0,0xA0B3,0x0000,0x0000,0x0000,
0xFBC0,0xA0B4,0x0000,0x0000,0x0000,
0xFBC0,0xA0B5,0x0000,0x0000,0x0000,
0xFBC0,0xA0B6,0x0000,0x0000,0x0000,
0xFBC0,0xA0B7,0x0000,0x0000,0x0000,
0xFBC0,0xA0B8,0x0000,0x0000,0x0000,
0xFBC0,0xA0B9,0x0000,0x0000,0x0000,
0xFBC0,0xA0BA,0x0000,0x0000,0x0000,
0xFBC0,0xA0BB,0x0000,0x0000,0x0000,
0xFBC0,0xA0BC,0x0000,0x0000,0x0000,
0xFBC0,0xA0BD,0x0000,0x0000,0x0000,
0xFBC0,0xA0BE,0x0000,0x0000,0x0000,
0xFBC0,0xA0BF,0x0000,0x0000,0x0000,
0xFBC0,0xA0C0,0x0000,0x0000,0x0000,
0xFBC0,0xA0C1,0x0000,0x0000,0x0000,
0xFBC0,0xA0C2,0x0000,0x0000,0x0000,
0xFBC0,0xA0C3,0x0000,0x0000,0x0000,
0xFBC0,0xA0C4,0x0000,0x0000,0x0000,
0xFBC0,0xA0C5,0x0000,0x0000,0x0000,
0xFBC0,0xA0C6,0x0000,0x0000,0x0000,
0xFBC0,0xA0C7,0x0000,0x0000,0x0000,
0xFBC0,0xA0C8,0x0000,0x0000,0x0000,
0xFBC0,0xA0C9,0x0000,0x0000,0x0000,
0xFBC0,0xA0CA,0x0000,0x0000,0x0000,
0xFBC0,0xA0CB,0x0000,0x0000,0x0000,
0xFBC0,0xA0CC,0x0000,0x0000,0x0000,
0xFBC0,0xA0CD,0x0000,0x0000,0x0000,
0xFBC0,0xA0CE,0x0000,0x0000,0x0000,
0xFBC0,0xA0CF,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA0EB,0x0000,0x0000,0x0000,
0xFBC0,0xA0EC,0x0000,0x0000,0x0000,
0xFBC0,0xA0ED,0x0000,0x0000,0x0000,
0xFBC0,0xA0EE,0x0000,0x0000,0x0000,
0xFBC0,0xA0EF,0x0000,0x0000,0x0000,
0xFBC0,0xA0F0,0x0000,0x0000,0x0000,
0xFBC0,0xA0F1,0x0000,0x0000,0x0000,
0xFBC0,0xA0F2,0x0000,0x0000,0x0000,
0xFBC0,0xA0F3,0x0000,0x0000,0x0000,
0xFBC0,0xA0F4,0x0000,0x0000,0x0000,
0xFBC0,0xA0F5,0x0000,0x0000,0x0000,
0xFBC0,0xA0F6,0x0000,0x0000,0x0000,
0xFBC0,0xA0F7,0x0000,0x0000,0x0000,
0xFBC0,0xA0F8,0x0000,0x0000,0x0000,
0xFBC0,0xA0F9,0x0000,0x0000,0x0000,
0xFBC0,0xA0FA,0x0000,0x0000,0x0000,
0xFBC0,0xA0FB,0x0000,0x0000,0x0000,
0xFBC0,0xA0FC,0x0000,0x0000,0x0000,
0xFBC0,0xA0FD,0x0000,0x0000,0x0000,
0xFBC0,0xA0FE,0x0000,0x0000,0x0000,
0xFBC0,0xA0FF,0x0000,0x0000,0x0000
};

uint16 page021data[]= { /* 2100 (5 weights per char) */
0x0E33,0x02CC,0x0E60,0x0000,0x0000,
0x0E33,0x02CC,0x0FEA,0x0000,0x0000,
0x0E60,0x0000,0x0000,0x0000,0x0000,
0x034A,0x0E60,0x0000,0x0000,0x0000,
0x039B,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x02CC,0x0F82,0x0000,0x0000,
0x0E60,0x02CC,0x101F,0x0000,0x0000,
0x0E98,0x0000,0x0000,0x0000,0x0000,
0x039C,0x0000,0x0000,0x0000,0x0000,
0x034A,0x0EB9,0x0000,0x0000,0x0000,
0x0EC1,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000,0x0000,
0x0EED,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000,0x0000,
0x039D,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0F82,0x0000,0x0000,0x0000,
0x039E,0x0000,0x0000,0x0000,0x0000,
0x039F,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0000,0x0000,0x0000,0x0000,
0x0FB4,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000,0x0000,
0x03A0,0x0000,0x0000,0x0000,0x0000,
0x03A1,0x0000,0x0000,0x0000,0x0000,
0x0FEA,0x0F5B,0x0000,0x0000,0x0000,
0x1002,0x0E8B,0x0F2E,0x0000,0x0000,
0x1002,0x0F5B,0x0000,0x0000,0x0000,
0x03A2,0x0000,0x0000,0x0000,0x0000,
0x106A,0x0000,0x0000,0x0000,0x0000,
0x03A3,0x0000,0x0000,0x0000,0x0000,
0x1109,0x0000,0x0000,0x0000,0x0000,
0x03A4,0x0000,0x0000,0x0000,0x0000,
0x106A,0x0000,0x0000,0x0000,0x0000,
0x03A5,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0000,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000,0x0000,
0x0E4A,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0000,0x0000,0x0000,0x0000,
0x03A6,0x0000,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000,0x0000,
0x0EB9,0x0000,0x0000,0x0000,0x0000,
0x03A7,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0000,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000,0x0000,
0x1331,0x0000,0x0000,0x0000,0x0000,
0x1332,0x0000,0x0000,0x0000,0x0000,
0x1333,0x0000,0x0000,0x0000,0x0000,
0x1334,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x03A8,0x0000,0x0000,0x0000,0x0000,
0x0EB9,0x0E33,0x105A,0x0000,0x0000,
0xFBC0,0xA13C,0x0000,0x0000,0x0000,
0x10EA,0x0000,0x0000,0x0000,0x0000,
0x10EA,0x0000,0x0000,0x0000,0x0000,
0x10FC,0x0000,0x0000,0x0000,0x0000,
0x0427,0x0000,0x0000,0x0000,0x0000,
0x03A9,0x0000,0x0000,0x0000,0x0000,
0x03AA,0x0000,0x0000,0x0000,0x0000,
0x03AB,0x0000,0x0000,0x0000,0x0000,
0x03AC,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x0F10,0x0000,0x0000,0x0000,0x0000,
0x03AD,0x0000,0x0000,0x0000,0x0000,
0x02D0,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA14C,0x0000,0x0000,0x0000,
0xFBC0,0xA14D,0x0000,0x0000,0x0000,
0xFBC0,0xA14E,0x0000,0x0000,0x0000,
0xFBC0,0xA14F,0x0000,0x0000,0x0000,
0xFBC0,0xA150,0x0000,0x0000,0x0000,
0xFBC0,0xA151,0x0000,0x0000,0x0000,
0xFBC0,0xA152,0x0000,0x0000,0x0000,
0x0E2A,0x02CD,0x0E2C,0x0000,0x0000,
0x0E2B,0x02CD,0x0E2C,0x0000,0x0000,
0x0E2A,0x02CD,0x0E2E,0x0000,0x0000,
0x0E2B,0x02CD,0x0E2E,0x0000,0x0000,
0x0E2C,0x02CD,0x0E2E,0x0000,0x0000,
0x0E2D,0x02CD,0x0E2E,0x0000,0x0000,
0x0E2A,0x02CD,0x0E2F,0x0000,0x0000,
0x0E2E,0x02CD,0x0E2F,0x0000,0x0000,
0x0E2A,0x02CD,0x0E31,0x0000,0x0000,
0x0E2C,0x02CD,0x0E31,0x0000,0x0000,
0x0E2E,0x02CD,0x0E31,0x0000,0x0000,
0x0E30,0x02CD,0x0E31,0x0000,0x0000,
0x0E2A,0x02CD,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0EFB,0x0000,0x0000,0x0000,
0x0EFB,0x0EFB,0x0EFB,0x0000,0x0000,
0x0EFB,0x1044,0x0000,0x0000,0x0000,
0x1044,0x0000,0x0000,0x0000,0x0000,
0x1044,0x0EFB,0x0000,0x0000,0x0000,
0x1044,0x0EFB,0x0EFB,0x0000,0x0000,
0x1044,0x0EFB,0x0EFB,0x0EFB,0x0000,
0x0EFB,0x105A,0x0000,0x0000,0x0000,
0x105A,0x0000,0x0000,0x0000,0x0000,
0x105A,0x0EFB,0x0000,0x0000,0x0000,
0x105A,0x0EFB,0x0EFB,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0EFB,0x0000,0x0000,0x0000,
0x0EFB,0x0EFB,0x0EFB,0x0000,0x0000,
0x0EFB,0x1044,0x0000,0x0000,0x0000,
0x1044,0x0000,0x0000,0x0000,0x0000,
0x1044,0x0EFB,0x0000,0x0000,0x0000,
0x1044,0x0EFB,0x0EFB,0x0000,0x0000,
0x1044,0x0EFB,0x0EFB,0x0EFB,0x0000,
0x0EFB,0x105A,0x0000,0x0000,0x0000,
0x105A,0x0000,0x0000,0x0000,0x0000,
0x105A,0x0EFB,0x0000,0x0000,0x0000,
0x105A,0x0EFB,0x0EFB,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0000,0x0000,0x0000,0x0000,
0x0DD7,0x0000,0x0000,0x0000,0x0000,
0x0DD8,0x0000,0x0000,0x0000,0x0000,
0x0DD9,0x0000,0x0000,0x0000,0x0000,
0x0DDA,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA184,0x0000,0x0000,0x0000,
0xFBC0,0xA185,0x0000,0x0000,0x0000,
0xFBC0,0xA186,0x0000,0x0000,0x0000,
0xFBC0,0xA187,0x0000,0x0000,0x0000,
0xFBC0,0xA188,0x0000,0x0000,0x0000,
0xFBC0,0xA189,0x0000,0x0000,0x0000,
0xFBC0,0xA18A,0x0000,0x0000,0x0000,
0xFBC0,0xA18B,0x0000,0x0000,0x0000,
0xFBC0,0xA18C,0x0000,0x0000,0x0000,
0xFBC0,0xA18D,0x0000,0x0000,0x0000,
0xFBC0,0xA18E,0x0000,0x0000,0x0000,
0xFBC0,0xA18F,0x0000,0x0000,0x0000,
0x03AE,0x0000,0x0000,0x0000,0x0000,
0x03B0,0x0000,0x0000,0x0000,0x0000,
0x03AF,0x0000,0x0000,0x0000,0x0000,
0x03B1,0x0000,0x0000,0x0000,0x0000,
0x03B2,0x0000,0x0000,0x0000,0x0000,
0x03B3,0x0000,0x0000,0x0000,0x0000,
0x03B4,0x0000,0x0000,0x0000,0x0000,
0x03B5,0x0000,0x0000,0x0000,0x0000,
0x03B6,0x0000,0x0000,0x0000,0x0000,
0x03B7,0x0000,0x0000,0x0000,0x0000,
0x03AE,0x0000,0x0000,0x0000,0x0000,
0x03AF,0x0000,0x0000,0x0000,0x0000,
0x03B8,0x0000,0x0000,0x0000,0x0000,
0x03B9,0x0000,0x0000,0x0000,0x0000,
0x03BA,0x0000,0x0000,0x0000,0x0000,
0x03BB,0x0000,0x0000,0x0000,0x0000,
0x03BC,0x0000,0x0000,0x0000,0x0000,
0x03BD,0x0000,0x0000,0x0000,0x0000,
0x03BE,0x0000,0x0000,0x0000,0x0000,
0x03BF,0x0000,0x0000,0x0000,0x0000,
0x03C0,0x0000,0x0000,0x0000,0x0000,
0x03C1,0x0000,0x0000,0x0000,0x0000,
0x03C2,0x0000,0x0000,0x0000,0x0000,
0x03C3,0x0000,0x0000,0x0000,0x0000,
0x03C4,0x0000,0x0000,0x0000,0x0000,
0x03C5,0x0000,0x0000,0x0000,0x0000,
0x03C6,0x0000,0x0000,0x0000,0x0000,
0x03C7,0x0000,0x0000,0x0000,0x0000,
0x03C8,0x0000,0x0000,0x0000,0x0000,
0x03C9,0x0000,0x0000,0x0000,0x0000,
0x03B2,0x0000,0x0000,0x0000,0x0000,
0x03CA,0x0000,0x0000,0x0000,0x0000,
0x03CB,0x0000,0x0000,0x0000,0x0000,
0x03CC,0x0000,0x0000,0x0000,0x0000,
0x03CD,0x0000,0x0000,0x0000,0x0000,
0x03CE,0x0000,0x0000,0x0000,0x0000,
0x03CF,0x0000,0x0000,0x0000,0x0000,
0x03D0,0x0000,0x0000,0x0000,0x0000,
0x03D1,0x0000,0x0000,0x0000,0x0000,
0x03D2,0x0000,0x0000,0x0000,0x0000,
0x03D3,0x0000,0x0000,0x0000,0x0000,
0x03D4,0x0000,0x0000,0x0000,0x0000,
0x03D5,0x0000,0x0000,0x0000,0x0000,
0x03D6,0x0000,0x0000,0x0000,0x0000,
0x03D7,0x0000,0x0000,0x0000,0x0000,
0x03D8,0x0000,0x0000,0x0000,0x0000,
0x03D9,0x0000,0x0000,0x0000,0x0000,
0x03DA,0x0000,0x0000,0x0000,0x0000,
0x03DB,0x0000,0x0000,0x0000,0x0000,
0x03DC,0x0000,0x0000,0x0000,0x0000,
0x03DD,0x0000,0x0000,0x0000,0x0000,
0x03DE,0x0000,0x0000,0x0000,0x0000,
0x03DF,0x0000,0x0000,0x0000,0x0000,
0x03E0,0x0000,0x0000,0x0000,0x0000,
0x03E1,0x0000,0x0000,0x0000,0x0000,
0x03E2,0x0000,0x0000,0x0000,0x0000,
0x03E3,0x0000,0x0000,0x0000,0x0000,
0x03E4,0x0000,0x0000,0x0000,0x0000,
0x03E5,0x0000,0x0000,0x0000,0x0000,
0x03E6,0x0000,0x0000,0x0000,0x0000,
0x03E7,0x0000,0x0000,0x0000,0x0000,
0x03E8,0x0000,0x0000,0x0000,0x0000,
0x03EC,0x0000,0x0000,0x0000,0x0000,
0x03EA,0x0000,0x0000,0x0000,0x0000,
0x03E8,0x0000,0x0000,0x0000,0x0000,
0x03E9,0x0000,0x0000,0x0000,0x0000,
0x03EA,0x0000,0x0000,0x0000,0x0000,
0x03EB,0x0000,0x0000,0x0000,0x0000,
0x03EC,0x0000,0x0000,0x0000,0x0000,
0x03ED,0x0000,0x0000,0x0000,0x0000,
0x03EE,0x0000,0x0000,0x0000,0x0000,
0x03EF,0x0000,0x0000,0x0000,0x0000,
0x03F0,0x0000,0x0000,0x0000,0x0000,
0x03F1,0x0000,0x0000,0x0000,0x0000,
0x03F2,0x0000,0x0000,0x0000,0x0000,
0x03F3,0x0000,0x0000,0x0000,0x0000,
0x03F4,0x0000,0x0000,0x0000,0x0000,
0x03F5,0x0000,0x0000,0x0000,0x0000,
0x03F6,0x0000,0x0000,0x0000,0x0000,
0x03F7,0x0000,0x0000,0x0000,0x0000,
0x03F8,0x0000,0x0000,0x0000,0x0000,
0x03F9,0x0000,0x0000,0x0000,0x0000,
0x03FA,0x0000,0x0000,0x0000,0x0000,
0x03FB,0x0000,0x0000,0x0000,0x0000,
0x03FC,0x0000,0x0000,0x0000,0x0000,
0x03FD,0x0000,0x0000,0x0000,0x0000,
0x03FE,0x0000,0x0000,0x0000,0x0000,
0x03FF,0x0000,0x0000,0x0000,0x0000,
0x0400,0x0000,0x0000,0x0000,0x0000,
0x0401,0x0000,0x0000,0x0000,0x0000,
0x0402,0x0000,0x0000,0x0000,0x0000,
0x0403,0x0000,0x0000,0x0000,0x0000,
0x0404,0x0000,0x0000,0x0000,0x0000,
0x0405,0x0000,0x0000,0x0000,0x0000,
0x0406,0x0000,0x0000,0x0000,0x0000,
0x0407,0x0000,0x0000,0x0000,0x0000,
0x0408,0x0000,0x0000,0x0000,0x0000,
0x0409,0x0000,0x0000,0x0000,0x0000,
0x040A,0x0000,0x0000,0x0000,0x0000,
0x040B,0x0000,0x0000,0x0000,0x0000,
0x040C,0x0000,0x0000,0x0000,0x0000,
0x040D,0x0000,0x0000,0x0000,0x0000,
0x040E,0x0000,0x0000,0x0000,0x0000,
0x040F,0x0000,0x0000,0x0000,0x0000,
0x0410,0x0000,0x0000,0x0000,0x0000,
0x0411,0x0000,0x0000,0x0000,0x0000,
0x0412,0x0000,0x0000,0x0000,0x0000,
0x0413,0x0000,0x0000,0x0000,0x0000,
0x0414,0x0000,0x0000,0x0000,0x0000,
0x0415,0x0000,0x0000,0x0000,0x0000,
0x0416,0x0000,0x0000,0x0000,0x0000,
0x0417,0x0000,0x0000,0x0000,0x0000
};

uint16 page022data[]= { /* 2200 (4 weights per char) */
0x0418,0x0000,0x0000,0x0000, 0x0419,0x0000,0x0000,0x0000,
0x041A,0x0000,0x0000,0x0000, 0x041B,0x0000,0x0000,0x0000,
0x041B,0x0000,0x0000,0x0000, 0x041C,0x0000,0x0000,0x0000,
0x041D,0x0000,0x0000,0x0000, 0x041E,0x0000,0x0000,0x0000,
0x041F,0x0000,0x0000,0x0000, 0x041F,0x0000,0x0000,0x0000,
0x0420,0x0000,0x0000,0x0000, 0x0421,0x0000,0x0000,0x0000,
0x0421,0x0000,0x0000,0x0000, 0x0422,0x0000,0x0000,0x0000,
0x0424,0x0000,0x0000,0x0000, 0x0425,0x0000,0x0000,0x0000,
0x0426,0x0000,0x0000,0x0000, 0x0427,0x0000,0x0000,0x0000,
0x0434,0x0000,0x0000,0x0000, 0x0435,0x0000,0x0000,0x0000,
0x0436,0x0000,0x0000,0x0000, 0x0437,0x0000,0x0000,0x0000,
0x0438,0x0000,0x0000,0x0000, 0x0439,0x0000,0x0000,0x0000,
0x043A,0x0000,0x0000,0x0000, 0x043B,0x0000,0x0000,0x0000,
0x043C,0x0000,0x0000,0x0000, 0x043D,0x0000,0x0000,0x0000,
0x043E,0x0000,0x0000,0x0000, 0x043F,0x0000,0x0000,0x0000,
0x0440,0x0000,0x0000,0x0000, 0x0441,0x0000,0x0000,0x0000,
0x0442,0x0000,0x0000,0x0000, 0x0443,0x0000,0x0000,0x0000,
0x0444,0x0000,0x0000,0x0000, 0x0445,0x0000,0x0000,0x0000,
0x0445,0x0000,0x0000,0x0000, 0x0446,0x0000,0x0000,0x0000,
0x0446,0x0000,0x0000,0x0000, 0x0447,0x0000,0x0000,0x0000,
0x0448,0x0000,0x0000,0x0000, 0x0449,0x0000,0x0000,0x0000,
0x044A,0x0000,0x0000,0x0000, 0x044B,0x0000,0x0000,0x0000,
0x044B,0x044B,0x0000,0x0000, 0x044B,0x044B,0x044B,0x0000,
0x044C,0x0000,0x0000,0x0000, 0x044C,0x044C,0x0000,0x0000,
0x044C,0x044C,0x044C,0x0000, 0x044D,0x0000,0x0000,0x0000,
0x044E,0x0000,0x0000,0x0000, 0x044F,0x0000,0x0000,0x0000,
0x0450,0x0000,0x0000,0x0000, 0x0451,0x0000,0x0000,0x0000,
0x0452,0x0000,0x0000,0x0000, 0x0453,0x0000,0x0000,0x0000,
0x0454,0x0000,0x0000,0x0000, 0x0455,0x0000,0x0000,0x0000,
0x0456,0x0000,0x0000,0x0000, 0x0457,0x0000,0x0000,0x0000,
0x0458,0x0000,0x0000,0x0000, 0x0459,0x0000,0x0000,0x0000,
0x045A,0x0000,0x0000,0x0000, 0x045B,0x0000,0x0000,0x0000,
0x045C,0x0000,0x0000,0x0000, 0x0458,0x0000,0x0000,0x0000,
0x045D,0x0000,0x0000,0x0000, 0x045E,0x0000,0x0000,0x0000,
0x045E,0x0000,0x0000,0x0000, 0x045F,0x0000,0x0000,0x0000,
0x0460,0x0000,0x0000,0x0000, 0x045F,0x0000,0x0000,0x0000,
0x0461,0x0000,0x0000,0x0000, 0x0461,0x0000,0x0000,0x0000,
0x0462,0x0000,0x0000,0x0000, 0x0463,0x0000,0x0000,0x0000,
0x0464,0x0000,0x0000,0x0000, 0x0465,0x0000,0x0000,0x0000,
0x0466,0x0000,0x0000,0x0000, 0x0467,0x0000,0x0000,0x0000,
0x0468,0x0000,0x0000,0x0000, 0x0469,0x0000,0x0000,0x0000,
0x046A,0x0000,0x0000,0x0000, 0x046B,0x0000,0x0000,0x0000,
0x046C,0x0000,0x0000,0x0000, 0x046D,0x0000,0x0000,0x0000,
0x046E,0x0000,0x0000,0x0000, 0x046F,0x0000,0x0000,0x0000,
0x0470,0x0000,0x0000,0x0000, 0x0471,0x0000,0x0000,0x0000,
0x0472,0x0000,0x0000,0x0000, 0x0473,0x0000,0x0000,0x0000,
0x0474,0x0000,0x0000,0x0000, 0x0475,0x0000,0x0000,0x0000,
0x0476,0x0000,0x0000,0x0000, 0x0477,0x0000,0x0000,0x0000,
0x042D,0x0000,0x0000,0x0000, 0x0478,0x0000,0x0000,0x0000,
0x0478,0x0000,0x0000,0x0000, 0x0479,0x0000,0x0000,0x0000,
0x047A,0x0000,0x0000,0x0000, 0x047B,0x0000,0x0000,0x0000,
0x047C,0x0000,0x0000,0x0000, 0x047D,0x0000,0x0000,0x0000,
0x047E,0x0000,0x0000,0x0000, 0x047F,0x0000,0x0000,0x0000,
0x0480,0x0000,0x0000,0x0000, 0x0481,0x0000,0x0000,0x0000,
0x0482,0x0000,0x0000,0x0000, 0x0465,0x0000,0x0000,0x0000,
0x042C,0x0000,0x0000,0x0000, 0x042E,0x0000,0x0000,0x0000,
0x047A,0x0000,0x0000,0x0000, 0x047B,0x0000,0x0000,0x0000,
0x0483,0x0000,0x0000,0x0000, 0x0484,0x0000,0x0000,0x0000,
0x0483,0x0000,0x0000,0x0000, 0x0484,0x0000,0x0000,0x0000,
0x0485,0x0000,0x0000,0x0000, 0x0486,0x0000,0x0000,0x0000,
0x0485,0x0000,0x0000,0x0000, 0x0486,0x0000,0x0000,0x0000,
0x0487,0x0000,0x0000,0x0000, 0x0488,0x0000,0x0000,0x0000,
0x0489,0x0000,0x0000,0x0000, 0x048A,0x0000,0x0000,0x0000,
0x048B,0x0000,0x0000,0x0000, 0x048C,0x0000,0x0000,0x0000,
0x0487,0x0000,0x0000,0x0000, 0x0488,0x0000,0x0000,0x0000,
0x048D,0x0000,0x0000,0x0000, 0x048E,0x0000,0x0000,0x0000,
0x048D,0x0000,0x0000,0x0000, 0x048E,0x0000,0x0000,0x0000,
0x048F,0x0000,0x0000,0x0000, 0x0490,0x0000,0x0000,0x0000,
0x048F,0x0000,0x0000,0x0000, 0x0490,0x0000,0x0000,0x0000,
0x0491,0x0000,0x0000,0x0000, 0x0492,0x0000,0x0000,0x0000,
0x0493,0x0000,0x0000,0x0000, 0x0494,0x0000,0x0000,0x0000,
0x0495,0x0000,0x0000,0x0000, 0x0496,0x0000,0x0000,0x0000,
0x0497,0x0000,0x0000,0x0000, 0x0498,0x0000,0x0000,0x0000,
0x0499,0x0000,0x0000,0x0000, 0x049A,0x0000,0x0000,0x0000,
0x049B,0x0000,0x0000,0x0000, 0x049C,0x0000,0x0000,0x0000,
0x049D,0x0000,0x0000,0x0000, 0x049E,0x0000,0x0000,0x0000,
0x049F,0x0000,0x0000,0x0000, 0x04A0,0x0000,0x0000,0x0000,
0x04A1,0x0000,0x0000,0x0000, 0x04A2,0x0000,0x0000,0x0000,
0x04A3,0x0000,0x0000,0x0000, 0x04A4,0x0000,0x0000,0x0000,
0x04A5,0x0000,0x0000,0x0000, 0x04A6,0x0000,0x0000,0x0000,
0x04A7,0x0000,0x0000,0x0000, 0x04A8,0x0000,0x0000,0x0000,
0x04A9,0x0000,0x0000,0x0000, 0x04AA,0x0000,0x0000,0x0000,
0x04AB,0x0000,0x0000,0x0000, 0x04AC,0x0000,0x0000,0x0000,
0x04AD,0x0000,0x0000,0x0000, 0x04AE,0x0000,0x0000,0x0000,
0x04AF,0x0000,0x0000,0x0000, 0x04B0,0x0000,0x0000,0x0000,
0x04B1,0x0000,0x0000,0x0000, 0x04B2,0x0000,0x0000,0x0000,
0x04A9,0x0000,0x0000,0x0000, 0x04AF,0x0000,0x0000,0x0000,
0x04B0,0x0000,0x0000,0x0000, 0x04B2,0x0000,0x0000,0x0000,
0x04B3,0x0000,0x0000,0x0000, 0x04B4,0x0000,0x0000,0x0000,
0x04B5,0x0000,0x0000,0x0000, 0x04B6,0x0000,0x0000,0x0000,
0x04B7,0x0000,0x0000,0x0000, 0x04B8,0x0000,0x0000,0x0000,
0x04B9,0x0000,0x0000,0x0000, 0x04BA,0x0000,0x0000,0x0000,
0x04BB,0x0000,0x0000,0x0000, 0x04BC,0x0000,0x0000,0x0000,
0x04BD,0x0000,0x0000,0x0000, 0x04BE,0x0000,0x0000,0x0000,
0x04BF,0x0000,0x0000,0x0000, 0x04C0,0x0000,0x0000,0x0000,
0x04C1,0x0000,0x0000,0x0000, 0x04C2,0x0000,0x0000,0x0000,
0x04C3,0x0000,0x0000,0x0000, 0x04C4,0x0000,0x0000,0x0000,
0x04C5,0x0000,0x0000,0x0000, 0x04C6,0x0000,0x0000,0x0000,
0x04C7,0x0000,0x0000,0x0000, 0x04C8,0x0000,0x0000,0x0000,
0x04C9,0x0000,0x0000,0x0000, 0x04CA,0x0000,0x0000,0x0000,
0x04CB,0x0000,0x0000,0x0000, 0x04CC,0x0000,0x0000,0x0000,
0x04CD,0x0000,0x0000,0x0000, 0x04CE,0x0000,0x0000,0x0000,
0x04CF,0x0000,0x0000,0x0000, 0x04D0,0x0000,0x0000,0x0000,
0x04D1,0x0000,0x0000,0x0000, 0x04D2,0x0000,0x0000,0x0000,
0x04D3,0x0000,0x0000,0x0000, 0x04D4,0x0000,0x0000,0x0000,
0x04D5,0x0000,0x0000,0x0000, 0x04D6,0x0000,0x0000,0x0000,
0x04D7,0x0000,0x0000,0x0000, 0x04D8,0x0000,0x0000,0x0000,
0x04D9,0x0000,0x0000,0x0000, 0x04DA,0x0000,0x0000,0x0000,
0x04DB,0x0000,0x0000,0x0000, 0x04DC,0x0000,0x0000,0x0000,
0x04DD,0x0000,0x0000,0x0000, 0x04DE,0x0000,0x0000,0x0000,
0x04DF,0x0000,0x0000,0x0000, 0x04E0,0x0000,0x0000,0x0000,
0x04E1,0x0000,0x0000,0x0000, 0x04E2,0x0000,0x0000,0x0000,
0x0489,0x0000,0x0000,0x0000, 0x048A,0x0000,0x0000,0x0000,
0x0498,0x0000,0x0000,0x0000, 0x0499,0x0000,0x0000,0x0000,
0x04E3,0x0000,0x0000,0x0000, 0x04E4,0x0000,0x0000,0x0000,
0x04E5,0x0000,0x0000,0x0000, 0x04E6,0x0000,0x0000,0x0000,
0x04E7,0x0000,0x0000,0x0000, 0x04E8,0x0000,0x0000,0x0000,
0x04B5,0x0000,0x0000,0x0000, 0x04B6,0x0000,0x0000,0x0000,
0x04B7,0x0000,0x0000,0x0000, 0x04B8,0x0000,0x0000,0x0000,
0x04E9,0x0000,0x0000,0x0000, 0x04EA,0x0000,0x0000,0x0000,
0x04EB,0x0000,0x0000,0x0000, 0x04EC,0x0000,0x0000,0x0000,
0x04ED,0x0000,0x0000,0x0000, 0x04EE,0x0000,0x0000,0x0000,
0x04EF,0x0000,0x0000,0x0000, 0x04F0,0x0000,0x0000,0x0000,
0x04F1,0x0000,0x0000,0x0000, 0x04F2,0x0000,0x0000,0x0000,
0x04F3,0x0000,0x0000,0x0000, 0x04F4,0x0000,0x0000,0x0000,
0x04F5,0x0000,0x0000,0x0000, 0x04F6,0x0000,0x0000,0x0000,
0x04F7,0x0000,0x0000,0x0000, 0x04F8,0x0000,0x0000,0x0000,
0x04F9,0x0000,0x0000,0x0000, 0x04FA,0x0000,0x0000,0x0000
};

uint16 page023data[]= { /* 2300 (3 weights per char) */
0x04FB,0x0000,0x0000, 0x04FC,0x0000,0x0000, 0x04FD,0x0000,0x0000,
0x04FE,0x0000,0x0000, 0x04FF,0x0000,0x0000, 0x0500,0x0000,0x0000,
0x0501,0x0000,0x0000, 0x0502,0x0000,0x0000, 0x0503,0x0000,0x0000,
0x0504,0x0000,0x0000, 0x0505,0x0000,0x0000, 0x0506,0x0000,0x0000,
0x0507,0x0000,0x0000, 0x0508,0x0000,0x0000, 0x0509,0x0000,0x0000,
0x050A,0x0000,0x0000, 0x050B,0x0000,0x0000, 0x050C,0x0000,0x0000,
0x050D,0x0000,0x0000, 0x050E,0x0000,0x0000, 0x050F,0x0000,0x0000,
0x0510,0x0000,0x0000, 0x0511,0x0000,0x0000, 0x0512,0x0000,0x0000,
0x0513,0x0000,0x0000, 0x0514,0x0000,0x0000, 0x0515,0x0000,0x0000,
0x0516,0x0000,0x0000, 0x0517,0x0000,0x0000, 0x0518,0x0000,0x0000,
0x0519,0x0000,0x0000, 0x051A,0x0000,0x0000, 0x051B,0x0000,0x0000,
0x051C,0x0000,0x0000, 0x051D,0x0000,0x0000, 0x051E,0x0000,0x0000,
0x051F,0x0000,0x0000, 0x0520,0x0000,0x0000, 0x0521,0x0000,0x0000,
0x0522,0x0000,0x0000, 0x0523,0x0000,0x0000, 0x02AE,0x0000,0x0000,
0x02AF,0x0000,0x0000, 0x0524,0x0000,0x0000, 0x0525,0x0000,0x0000,
0x0526,0x0000,0x0000, 0x0527,0x0000,0x0000, 0x0528,0x0000,0x0000,
0x0529,0x0000,0x0000, 0x052A,0x0000,0x0000, 0x052B,0x0000,0x0000,
0x052C,0x0000,0x0000, 0x052D,0x0000,0x0000, 0x052E,0x0000,0x0000,
0x052F,0x0000,0x0000, 0x0530,0x0000,0x0000, 0x0531,0x0000,0x0000,
0x0532,0x0000,0x0000, 0x0533,0x0000,0x0000, 0x0534,0x0000,0x0000,
0x0535,0x0000,0x0000, 0x0536,0x0000,0x0000, 0x0537,0x0000,0x0000,
0x0538,0x0000,0x0000, 0x0539,0x0000,0x0000, 0x053A,0x0000,0x0000,
0x053B,0x0000,0x0000, 0x053C,0x0000,0x0000, 0x053D,0x0000,0x0000,
0x053E,0x0000,0x0000, 0x053F,0x0000,0x0000, 0x0540,0x0000,0x0000,
0x0541,0x0000,0x0000, 0x0542,0x0000,0x0000, 0x0543,0x0000,0x0000,
0x0544,0x0000,0x0000, 0x0545,0x0000,0x0000, 0x0546,0x0000,0x0000,
0x0547,0x0000,0x0000, 0x0548,0x0000,0x0000, 0x0549,0x0000,0x0000,
0x054A,0x0000,0x0000, 0x054B,0x0000,0x0000, 0x054C,0x0000,0x0000,
0x054D,0x0000,0x0000, 0x054E,0x0000,0x0000, 0x054F,0x0000,0x0000,
0x0550,0x0000,0x0000, 0x0551,0x0000,0x0000, 0x0552,0x0000,0x0000,
0x0553,0x0000,0x0000, 0x0554,0x0000,0x0000, 0x0555,0x0000,0x0000,
0x0556,0x0000,0x0000, 0x0557,0x0000,0x0000, 0x0558,0x0000,0x0000,
0x0559,0x0000,0x0000, 0x055A,0x0000,0x0000, 0x055B,0x0000,0x0000,
0x055C,0x0000,0x0000, 0x055D,0x0000,0x0000, 0x055E,0x0000,0x0000,
0x055F,0x0000,0x0000, 0x0560,0x0000,0x0000, 0x0561,0x0000,0x0000,
0x0562,0x0000,0x0000, 0x0563,0x0000,0x0000, 0x0564,0x0000,0x0000,
0x0565,0x0000,0x0000, 0x0566,0x0000,0x0000, 0x0567,0x0000,0x0000,
0x0568,0x0000,0x0000, 0x0569,0x0000,0x0000, 0x056A,0x0000,0x0000,
0x056B,0x0000,0x0000, 0x056C,0x0000,0x0000, 0x056D,0x0000,0x0000,
0x056E,0x0000,0x0000, 0x056F,0x0000,0x0000, 0x0570,0x0000,0x0000,
0x0571,0x0000,0x0000, 0x0572,0x0000,0x0000, 0x0573,0x0000,0x0000,
0x0574,0x0000,0x0000, 0x0575,0x0000,0x0000, 0x0576,0x0000,0x0000,
0x0577,0x0000,0x0000, 0x0578,0x0000,0x0000, 0x0579,0x0000,0x0000,
0x057A,0x0000,0x0000, 0x057B,0x0000,0x0000, 0x057C,0x0000,0x0000,
0x057D,0x0000,0x0000, 0x057E,0x0000,0x0000, 0x057F,0x0000,0x0000,
0x0580,0x0000,0x0000, 0x0581,0x0000,0x0000, 0x0582,0x0000,0x0000,
0x0583,0x0000,0x0000, 0x0584,0x0000,0x0000, 0x0585,0x0000,0x0000,
0x0586,0x0000,0x0000, 0x0587,0x0000,0x0000, 0x0588,0x0000,0x0000,
0x0589,0x0000,0x0000, 0x058A,0x0000,0x0000, 0x058B,0x0000,0x0000,
0x058C,0x0000,0x0000, 0x058D,0x0000,0x0000, 0x058E,0x0000,0x0000,
0x058F,0x0000,0x0000, 0x0590,0x0000,0x0000, 0x0591,0x0000,0x0000,
0x0592,0x0000,0x0000, 0x0593,0x0000,0x0000, 0x0594,0x0000,0x0000,
0x0595,0x0000,0x0000, 0x0596,0x0000,0x0000, 0x0597,0x0000,0x0000,
0x0598,0x0000,0x0000, 0x0599,0x0000,0x0000, 0x059A,0x0000,0x0000,
0x059B,0x0000,0x0000, 0x059C,0x0000,0x0000, 0x059D,0x0000,0x0000,
0x059E,0x0000,0x0000, 0x059F,0x0000,0x0000, 0x05A0,0x0000,0x0000,
0x05A1,0x0000,0x0000, 0x05A2,0x0000,0x0000, 0x05A3,0x0000,0x0000,
0x05A4,0x0000,0x0000, 0x05A5,0x0000,0x0000, 0x05A6,0x0000,0x0000,
0x05A7,0x0000,0x0000, 0x05A8,0x0000,0x0000, 0x05A9,0x0000,0x0000,
0x05AA,0x0000,0x0000, 0x05AB,0x0000,0x0000, 0x05AC,0x0000,0x0000,
0x05AD,0x0000,0x0000, 0x05AE,0x0000,0x0000, 0x05AF,0x0000,0x0000,
0x05B0,0x0000,0x0000, 0x05B1,0x0000,0x0000, 0x05B2,0x0000,0x0000,
0x05B3,0x0000,0x0000, 0x05B4,0x0000,0x0000, 0x05B5,0x0000,0x0000,
0x05B6,0x0000,0x0000, 0x05B7,0x0000,0x0000, 0x05B8,0x0000,0x0000,
0x05B9,0x0000,0x0000, 0x05BA,0x0000,0x0000, 0x05BB,0x0000,0x0000,
0x05BC,0x0000,0x0000, 0x05BD,0x0000,0x0000, 0x05BE,0x0000,0x0000,
0x05BF,0x0000,0x0000, 0x05C0,0x0000,0x0000, 0x05C1,0x0000,0x0000,
0x05C2,0x0000,0x0000, 0x05C3,0x0000,0x0000, 0x05C4,0x0000,0x0000,
0x05C5,0x0000,0x0000, 0x05C6,0x0000,0x0000, 0x05C7,0x0000,0x0000,
0x05C8,0x0000,0x0000, 0x05C9,0x0000,0x0000, 0xFBC0,0xA3D1,0x0000,
0xFBC0,0xA3D2,0x0000, 0xFBC0,0xA3D3,0x0000, 0xFBC0,0xA3D4,0x0000,
0xFBC0,0xA3D5,0x0000, 0xFBC0,0xA3D6,0x0000, 0xFBC0,0xA3D7,0x0000,
0xFBC0,0xA3D8,0x0000, 0xFBC0,0xA3D9,0x0000, 0xFBC0,0xA3DA,0x0000,
0xFBC0,0xA3DB,0x0000, 0xFBC0,0xA3DC,0x0000, 0xFBC0,0xA3DD,0x0000,
0xFBC0,0xA3DE,0x0000, 0xFBC0,0xA3DF,0x0000, 0xFBC0,0xA3E0,0x0000,
0xFBC0,0xA3E1,0x0000, 0xFBC0,0xA3E2,0x0000, 0xFBC0,0xA3E3,0x0000,
0xFBC0,0xA3E4,0x0000, 0xFBC0,0xA3E5,0x0000, 0xFBC0,0xA3E6,0x0000,
0xFBC0,0xA3E7,0x0000, 0xFBC0,0xA3E8,0x0000, 0xFBC0,0xA3E9,0x0000,
0xFBC0,0xA3EA,0x0000, 0xFBC0,0xA3EB,0x0000, 0xFBC0,0xA3EC,0x0000,
0xFBC0,0xA3ED,0x0000, 0xFBC0,0xA3EE,0x0000, 0xFBC0,0xA3EF,0x0000,
0xFBC0,0xA3F0,0x0000, 0xFBC0,0xA3F1,0x0000, 0xFBC0,0xA3F2,0x0000,
0xFBC0,0xA3F3,0x0000, 0xFBC0,0xA3F4,0x0000, 0xFBC0,0xA3F5,0x0000,
0xFBC0,0xA3F6,0x0000, 0xFBC0,0xA3F7,0x0000, 0xFBC0,0xA3F8,0x0000,
0xFBC0,0xA3F9,0x0000, 0xFBC0,0xA3FA,0x0000, 0xFBC0,0xA3FB,0x0000,
0xFBC0,0xA3FC,0x0000, 0xFBC0,0xA3FD,0x0000, 0xFBC0,0xA3FE,0x0000,
0xFBC0,0xA3FF,0x0000 };

uint16 page024data[]= { /* 2400 (5 weights per char) */
0x05CA,0x0000,0x0000,0x0000,0x0000,
0x05CB,0x0000,0x0000,0x0000,0x0000,
0x05CC,0x0000,0x0000,0x0000,0x0000,
0x05CD,0x0000,0x0000,0x0000,0x0000,
0x05CE,0x0000,0x0000,0x0000,0x0000,
0x05CF,0x0000,0x0000,0x0000,0x0000,
0x05D0,0x0000,0x0000,0x0000,0x0000,
0x05D1,0x0000,0x0000,0x0000,0x0000,
0x05D2,0x0000,0x0000,0x0000,0x0000,
0x05D3,0x0000,0x0000,0x0000,0x0000,
0x05D4,0x0000,0x0000,0x0000,0x0000,
0x05D5,0x0000,0x0000,0x0000,0x0000,
0x05D6,0x0000,0x0000,0x0000,0x0000,
0x05D7,0x0000,0x0000,0x0000,0x0000,
0x05D8,0x0000,0x0000,0x0000,0x0000,
0x05D9,0x0000,0x0000,0x0000,0x0000,
0x05DA,0x0000,0x0000,0x0000,0x0000,
0x05DB,0x0000,0x0000,0x0000,0x0000,
0x05DC,0x0000,0x0000,0x0000,0x0000,
0x05DD,0x0000,0x0000,0x0000,0x0000,
0x05DE,0x0000,0x0000,0x0000,0x0000,
0x05DF,0x0000,0x0000,0x0000,0x0000,
0x05E0,0x0000,0x0000,0x0000,0x0000,
0x05E1,0x0000,0x0000,0x0000,0x0000,
0x05E2,0x0000,0x0000,0x0000,0x0000,
0x05E3,0x0000,0x0000,0x0000,0x0000,
0x05E4,0x0000,0x0000,0x0000,0x0000,
0x05E5,0x0000,0x0000,0x0000,0x0000,
0x05E6,0x0000,0x0000,0x0000,0x0000,
0x05E7,0x0000,0x0000,0x0000,0x0000,
0x05E8,0x0000,0x0000,0x0000,0x0000,
0x05E9,0x0000,0x0000,0x0000,0x0000,
0x05EA,0x0000,0x0000,0x0000,0x0000,
0x05EB,0x0000,0x0000,0x0000,0x0000,
0x05EC,0x0000,0x0000,0x0000,0x0000,
0x05ED,0x0000,0x0000,0x0000,0x0000,
0x05EE,0x0000,0x0000,0x0000,0x0000,
0x05EF,0x0000,0x0000,0x0000,0x0000,
0x05F0,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA427,0x0000,0x0000,0x0000,
0xFBC0,0xA428,0x0000,0x0000,0x0000,
0xFBC0,0xA429,0x0000,0x0000,0x0000,
0xFBC0,0xA42A,0x0000,0x0000,0x0000,
0xFBC0,0xA42B,0x0000,0x0000,0x0000,
0xFBC0,0xA42C,0x0000,0x0000,0x0000,
0xFBC0,0xA42D,0x0000,0x0000,0x0000,
0xFBC0,0xA42E,0x0000,0x0000,0x0000,
0xFBC0,0xA42F,0x0000,0x0000,0x0000,
0xFBC0,0xA430,0x0000,0x0000,0x0000,
0xFBC0,0xA431,0x0000,0x0000,0x0000,
0xFBC0,0xA432,0x0000,0x0000,0x0000,
0xFBC0,0xA433,0x0000,0x0000,0x0000,
0xFBC0,0xA434,0x0000,0x0000,0x0000,
0xFBC0,0xA435,0x0000,0x0000,0x0000,
0xFBC0,0xA436,0x0000,0x0000,0x0000,
0xFBC0,0xA437,0x0000,0x0000,0x0000,
0xFBC0,0xA438,0x0000,0x0000,0x0000,
0xFBC0,0xA439,0x0000,0x0000,0x0000,
0xFBC0,0xA43A,0x0000,0x0000,0x0000,
0xFBC0,0xA43B,0x0000,0x0000,0x0000,
0xFBC0,0xA43C,0x0000,0x0000,0x0000,
0xFBC0,0xA43D,0x0000,0x0000,0x0000,
0xFBC0,0xA43E,0x0000,0x0000,0x0000,
0xFBC0,0xA43F,0x0000,0x0000,0x0000,
0x05F1,0x0000,0x0000,0x0000,0x0000,
0x05F2,0x0000,0x0000,0x0000,0x0000,
0x05F3,0x0000,0x0000,0x0000,0x0000,
0x05F4,0x0000,0x0000,0x0000,0x0000,
0x05F5,0x0000,0x0000,0x0000,0x0000,
0x05F6,0x0000,0x0000,0x0000,0x0000,
0x05F7,0x0000,0x0000,0x0000,0x0000,
0x05F8,0x0000,0x0000,0x0000,0x0000,
0x05F9,0x0000,0x0000,0x0000,0x0000,
0x05FA,0x0000,0x0000,0x0000,0x0000,
0x05FB,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA44B,0x0000,0x0000,0x0000,
0xFBC0,0xA44C,0x0000,0x0000,0x0000,
0xFBC0,0xA44D,0x0000,0x0000,0x0000,
0xFBC0,0xA44E,0x0000,0x0000,0x0000,
0xFBC0,0xA44F,0x0000,0x0000,0x0000,
0xFBC0,0xA450,0x0000,0x0000,0x0000,
0xFBC0,0xA451,0x0000,0x0000,0x0000,
0xFBC0,0xA452,0x0000,0x0000,0x0000,
0xFBC0,0xA453,0x0000,0x0000,0x0000,
0xFBC0,0xA454,0x0000,0x0000,0x0000,
0xFBC0,0xA455,0x0000,0x0000,0x0000,
0xFBC0,0xA456,0x0000,0x0000,0x0000,
0xFBC0,0xA457,0x0000,0x0000,0x0000,
0xFBC0,0xA458,0x0000,0x0000,0x0000,
0xFBC0,0xA459,0x0000,0x0000,0x0000,
0xFBC0,0xA45A,0x0000,0x0000,0x0000,
0xFBC0,0xA45B,0x0000,0x0000,0x0000,
0xFBC0,0xA45C,0x0000,0x0000,0x0000,
0xFBC0,0xA45D,0x0000,0x0000,0x0000,
0xFBC0,0xA45E,0x0000,0x0000,0x0000,
0xFBC0,0xA45F,0x0000,0x0000,0x0000,
0x0E2A,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0x0000,0x0000,0x0000,0x0000,
0x0E2F,0x0000,0x0000,0x0000,0x0000,
0x0E30,0x0000,0x0000,0x0000,0x0000,
0x0E31,0x0000,0x0000,0x0000,0x0000,
0x0E32,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E29,0x0000,0x0000,0x0000,
0x0E2A,0x0E2A,0x0000,0x0000,0x0000,
0x0E2A,0x0E2B,0x0000,0x0000,0x0000,
0x0E2A,0x0E2C,0x0000,0x0000,0x0000,
0x0E2A,0x0E2D,0x0000,0x0000,0x0000,
0x0E2A,0x0E2E,0x0000,0x0000,0x0000,
0x0E2A,0x0E2F,0x0000,0x0000,0x0000,
0x0E2A,0x0E30,0x0000,0x0000,0x0000,
0x0E2A,0x0E31,0x0000,0x0000,0x0000,
0x0E2A,0x0E32,0x0000,0x0000,0x0000,
0x0E2B,0x0E29,0x0000,0x0000,0x0000,
0x0288,0x0E2A,0x0289,0x0000,0x0000,
0x0288,0x0E2B,0x0289,0x0000,0x0000,
0x0288,0x0E2C,0x0289,0x0000,0x0000,
0x0288,0x0E2D,0x0289,0x0000,0x0000,
0x0288,0x0E2E,0x0289,0x0000,0x0000,
0x0288,0x0E2F,0x0289,0x0000,0x0000,
0x0288,0x0E30,0x0289,0x0000,0x0000,
0x0288,0x0E31,0x0289,0x0000,0x0000,
0x0288,0x0E32,0x0289,0x0000,0x0000,
0x0288,0x0E2A,0x0E29,0x0289,0x0000,
0x0288,0x0E2A,0x0E2A,0x0289,0x0000,
0x0288,0x0E2A,0x0E2B,0x0289,0x0000,
0x0288,0x0E2A,0x0E2C,0x0289,0x0000,
0x0288,0x0E2A,0x0E2D,0x0289,0x0000,
0x0288,0x0E2A,0x0E2E,0x0289,0x0000,
0x0288,0x0E2A,0x0E2F,0x0289,0x0000,
0x0288,0x0E2A,0x0E30,0x0289,0x0000,
0x0288,0x0E2A,0x0E31,0x0289,0x0000,
0x0288,0x0E2A,0x0E32,0x0289,0x0000,
0x0288,0x0E2B,0x0E29,0x0289,0x0000,
0x0E2A,0x025D,0x0000,0x0000,0x0000,
0x0E2B,0x025D,0x0000,0x0000,0x0000,
0x0E2C,0x025D,0x0000,0x0000,0x0000,
0x0E2D,0x025D,0x0000,0x0000,0x0000,
0x0E2E,0x025D,0x0000,0x0000,0x0000,
0x0E2F,0x025D,0x0000,0x0000,0x0000,
0x0E30,0x025D,0x0000,0x0000,0x0000,
0x0E31,0x025D,0x0000,0x0000,0x0000,
0x0E32,0x025D,0x0000,0x0000,0x0000,
0x0E2A,0x0E29,0x025D,0x0000,0x0000,
0x0E2A,0x0E2A,0x025D,0x0000,0x0000,
0x0E2A,0x0E2B,0x025D,0x0000,0x0000,
0x0E2A,0x0E2C,0x025D,0x0000,0x0000,
0x0E2A,0x0E2D,0x025D,0x0000,0x0000,
0x0E2A,0x0E2E,0x025D,0x0000,0x0000,
0x0E2A,0x0E2F,0x025D,0x0000,0x0000,
0x0E2A,0x0E30,0x025D,0x0000,0x0000,
0x0E2A,0x0E31,0x025D,0x0000,0x0000,
0x0E2A,0x0E32,0x025D,0x0000,0x0000,
0x0E2B,0x0E29,0x025D,0x0000,0x0000,
0x0288,0x0E33,0x0289,0x0000,0x0000,
0x0288,0x0E4A,0x0289,0x0000,0x0000,
0x0288,0x0E60,0x0289,0x0000,0x0000,
0x0288,0x0E6D,0x0289,0x0000,0x0000,
0x0288,0x0E8B,0x0289,0x0000,0x0000,
0x0288,0x0EB9,0x0289,0x0000,0x0000,
0x0288,0x0EC1,0x0289,0x0000,0x0000,
0x0288,0x0EE1,0x0289,0x0000,0x0000,
0x0288,0x0EFB,0x0289,0x0000,0x0000,
0x0288,0x0F10,0x0289,0x0000,0x0000,
0x0288,0x0F21,0x0289,0x0000,0x0000,
0x0288,0x0F2E,0x0289,0x0000,0x0000,
0x0288,0x0F5B,0x0289,0x0000,0x0000,
0x0288,0x0F64,0x0289,0x0000,0x0000,
0x0288,0x0F82,0x0289,0x0000,0x0000,
0x0288,0x0FA7,0x0289,0x0000,0x0000,
0x0288,0x0FB4,0x0289,0x0000,0x0000,
0x0288,0x0FC0,0x0289,0x0000,0x0000,
0x0288,0x0FEA,0x0289,0x0000,0x0000,
0x0288,0x1002,0x0289,0x0000,0x0000,
0x0288,0x101F,0x0289,0x0000,0x0000,
0x0288,0x1044,0x0289,0x0000,0x0000,
0x0288,0x1051,0x0289,0x0000,0x0000,
0x0288,0x105A,0x0289,0x0000,0x0000,
0x0288,0x105E,0x0289,0x0000,0x0000,
0x0288,0x106A,0x0289,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000,0x0000,
0x0E4A,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000,0x0000,
0x0EB9,0x0000,0x0000,0x0000,0x0000,
0x0EC1,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x0F10,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0000,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0000,0x0000,0x0000,0x0000,
0x0FB4,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000,0x0000,
0x0FEA,0x0000,0x0000,0x0000,0x0000,
0x1002,0x0000,0x0000,0x0000,0x0000,
0x101F,0x0000,0x0000,0x0000,0x0000,
0x1044,0x0000,0x0000,0x0000,0x0000,
0x1051,0x0000,0x0000,0x0000,0x0000,
0x105A,0x0000,0x0000,0x0000,0x0000,
0x105E,0x0000,0x0000,0x0000,0x0000,
0x106A,0x0000,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000,0x0000,
0x0E4A,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000,0x0000,
0x0EB9,0x0000,0x0000,0x0000,0x0000,
0x0EC1,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x0F10,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0000,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0000,0x0000,0x0000,0x0000,
0x0FB4,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000,0x0000,
0x0FEA,0x0000,0x0000,0x0000,0x0000,
0x1002,0x0000,0x0000,0x0000,0x0000,
0x101F,0x0000,0x0000,0x0000,0x0000,
0x1044,0x0000,0x0000,0x0000,0x0000,
0x1051,0x0000,0x0000,0x0000,0x0000,
0x105A,0x0000,0x0000,0x0000,0x0000,
0x105E,0x0000,0x0000,0x0000,0x0000,
0x106A,0x0000,0x0000,0x0000,0x0000,
0x0E29,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2A,0x0000,0x0000,0x0000,
0x0E2A,0x0E2B,0x0000,0x0000,0x0000,
0x0E2A,0x0E2C,0x0000,0x0000,0x0000,
0x0E2A,0x0E2D,0x0000,0x0000,0x0000,
0x0E2A,0x0E2E,0x0000,0x0000,0x0000,
0x0E2A,0x0E2F,0x0000,0x0000,0x0000,
0x0E2A,0x0E30,0x0000,0x0000,0x0000,
0x0E2A,0x0E31,0x0000,0x0000,0x0000,
0x0E2A,0x0E32,0x0000,0x0000,0x0000,
0x0E2B,0x0E29,0x0000,0x0000,0x0000,
0x0E2A,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0x0000,0x0000,0x0000,0x0000,
0x0E2F,0x0000,0x0000,0x0000,0x0000,
0x0E30,0x0000,0x0000,0x0000,0x0000,
0x0E31,0x0000,0x0000,0x0000,0x0000,
0x0E32,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E29,0x0000,0x0000,0x0000,
0x0E29,0x0000,0x0000,0x0000,0x0000
};

uint16 page025data[]= { /* 2500 (2 weights per char) */
0x05FC,0x0000, 0x05FD,0x0000, 0x05FE,0x0000, 0x05FF,0x0000,
0x0600,0x0000, 0x0601,0x0000, 0x0602,0x0000, 0x0603,0x0000,
0x0604,0x0000, 0x0605,0x0000, 0x0606,0x0000, 0x0607,0x0000,
0x0608,0x0000, 0x0609,0x0000, 0x060A,0x0000, 0x060B,0x0000,
0x060C,0x0000, 0x060D,0x0000, 0x060E,0x0000, 0x060F,0x0000,
0x0610,0x0000, 0x0611,0x0000, 0x0612,0x0000, 0x0613,0x0000,
0x0614,0x0000, 0x0615,0x0000, 0x0616,0x0000, 0x0617,0x0000,
0x0618,0x0000, 0x0619,0x0000, 0x061A,0x0000, 0x061B,0x0000,
0x061C,0x0000, 0x061D,0x0000, 0x061E,0x0000, 0x061F,0x0000,
0x0620,0x0000, 0x0621,0x0000, 0x0622,0x0000, 0x0623,0x0000,
0x0624,0x0000, 0x0625,0x0000, 0x0626,0x0000, 0x0627,0x0000,
0x0628,0x0000, 0x0629,0x0000, 0x062A,0x0000, 0x062B,0x0000,
0x062C,0x0000, 0x062D,0x0000, 0x062E,0x0000, 0x062F,0x0000,
0x0630,0x0000, 0x0631,0x0000, 0x0632,0x0000, 0x0633,0x0000,
0x0634,0x0000, 0x0635,0x0000, 0x0636,0x0000, 0x0637,0x0000,
0x0638,0x0000, 0x0639,0x0000, 0x063A,0x0000, 0x063B,0x0000,
0x063C,0x0000, 0x063D,0x0000, 0x063E,0x0000, 0x063F,0x0000,
0x0640,0x0000, 0x0641,0x0000, 0x0642,0x0000, 0x0643,0x0000,
0x0644,0x0000, 0x0645,0x0000, 0x0646,0x0000, 0x0647,0x0000,
0x0648,0x0000, 0x0649,0x0000, 0x064A,0x0000, 0x064B,0x0000,
0x064C,0x0000, 0x064D,0x0000, 0x064E,0x0000, 0x064F,0x0000,
0x0650,0x0000, 0x0651,0x0000, 0x0652,0x0000, 0x0653,0x0000,
0x0654,0x0000, 0x0655,0x0000, 0x0656,0x0000, 0x0657,0x0000,
0x0658,0x0000, 0x0659,0x0000, 0x065A,0x0000, 0x065B,0x0000,
0x065C,0x0000, 0x065D,0x0000, 0x065E,0x0000, 0x065F,0x0000,
0x0660,0x0000, 0x0661,0x0000, 0x0662,0x0000, 0x0663,0x0000,
0x0664,0x0000, 0x0665,0x0000, 0x0666,0x0000, 0x0667,0x0000,
0x0668,0x0000, 0x0669,0x0000, 0x066A,0x0000, 0x066B,0x0000,
0x066C,0x0000, 0x066D,0x0000, 0x066E,0x0000, 0x066F,0x0000,
0x0670,0x0000, 0x0671,0x0000, 0x0672,0x0000, 0x0673,0x0000,
0x0674,0x0000, 0x0675,0x0000, 0x0676,0x0000, 0x0677,0x0000,
0x0678,0x0000, 0x0679,0x0000, 0x067A,0x0000, 0x067B,0x0000,
0x067C,0x0000, 0x067D,0x0000, 0x067E,0x0000, 0x067F,0x0000,
0x0680,0x0000, 0x0681,0x0000, 0x0682,0x0000, 0x0683,0x0000,
0x0684,0x0000, 0x0685,0x0000, 0x0686,0x0000, 0x0687,0x0000,
0x0688,0x0000, 0x0689,0x0000, 0x068A,0x0000, 0x068B,0x0000,
0x068C,0x0000, 0x068D,0x0000, 0x068E,0x0000, 0x068F,0x0000,
0x0690,0x0000, 0x0691,0x0000, 0x0692,0x0000, 0x0693,0x0000,
0x0694,0x0000, 0x0695,0x0000, 0x0696,0x0000, 0x0697,0x0000,
0x0698,0x0000, 0x0699,0x0000, 0x069A,0x0000, 0x069B,0x0000,
0x069C,0x0000, 0x069D,0x0000, 0x069E,0x0000, 0x069F,0x0000,
0x06A0,0x0000, 0x06A1,0x0000, 0x06A2,0x0000, 0x06A3,0x0000,
0x06A4,0x0000, 0x06A5,0x0000, 0x06A6,0x0000, 0x06A7,0x0000,
0x06A8,0x0000, 0x06A9,0x0000, 0x06AA,0x0000, 0x06AB,0x0000,
0x06AC,0x0000, 0x06AD,0x0000, 0x06AE,0x0000, 0x06AF,0x0000,
0x06B0,0x0000, 0x06B1,0x0000, 0x06B2,0x0000, 0x06B3,0x0000,
0x06B4,0x0000, 0x06B5,0x0000, 0x06B6,0x0000, 0x06B7,0x0000,
0x06B8,0x0000, 0x06B9,0x0000, 0x06BA,0x0000, 0x06BB,0x0000,
0x06BC,0x0000, 0x06BD,0x0000, 0x06BE,0x0000, 0x06BF,0x0000,
0x06C0,0x0000, 0x06C1,0x0000, 0x06C2,0x0000, 0x06C3,0x0000,
0x06C4,0x0000, 0x06C5,0x0000, 0x06C6,0x0000, 0x06C7,0x0000,
0x06C8,0x0000, 0x06C9,0x0000, 0x06CA,0x0000, 0x06CB,0x0000,
0x06CC,0x0000, 0x06CD,0x0000, 0x06CE,0x0000, 0x06CF,0x0000,
0x06D0,0x0000, 0x06D1,0x0000, 0x06D2,0x0000, 0x06D3,0x0000,
0x06D4,0x0000, 0x06D5,0x0000, 0x06D6,0x0000, 0x06D7,0x0000,
0x06D8,0x0000, 0x06D9,0x0000, 0x06DA,0x0000, 0x06DB,0x0000,
0x06DC,0x0000, 0x06DD,0x0000, 0x06DE,0x0000, 0x06DF,0x0000,
0x06E0,0x0000, 0x06E1,0x0000, 0x06E2,0x0000, 0x06E3,0x0000,
0x06E4,0x0000, 0x06E5,0x0000, 0x06E6,0x0000, 0x06E7,0x0000,
0x06E8,0x0000, 0x06E9,0x0000, 0x06EA,0x0000, 0x06EB,0x0000,
0x06EC,0x0000, 0x06ED,0x0000, 0x06EE,0x0000, 0x06EF,0x0000,
0x06F0,0x0000, 0x06F1,0x0000, 0x06F2,0x0000, 0x06F3,0x0000,
0x06F4,0x0000, 0x06F5,0x0000, 0x06F6,0x0000, 0x06F7,0x0000,
0x06F8,0x0000, 0x06F9,0x0000, 0x06FA,0x0000, 0x06FB,0x0000
};

uint16 page026data[]= { /* 2600 (3 weights per char) */
0x06FC,0x0000,0x0000, 0x06FD,0x0000,0x0000, 0x06FE,0x0000,0x0000,
0x06FF,0x0000,0x0000, 0x0700,0x0000,0x0000, 0x0701,0x0000,0x0000,
0x0702,0x0000,0x0000, 0x0703,0x0000,0x0000, 0x0704,0x0000,0x0000,
0x0705,0x0000,0x0000, 0x0706,0x0000,0x0000, 0x0707,0x0000,0x0000,
0x0708,0x0000,0x0000, 0x0709,0x0000,0x0000, 0x070A,0x0000,0x0000,
0x070B,0x0000,0x0000, 0x070C,0x0000,0x0000, 0x070D,0x0000,0x0000,
0x070E,0x0000,0x0000, 0x070F,0x0000,0x0000, 0x0710,0x0000,0x0000,
0x0711,0x0000,0x0000, 0x0712,0x0000,0x0000, 0x0713,0x0000,0x0000,
0xFBC0,0xA618,0x0000, 0x0714,0x0000,0x0000, 0x0715,0x0000,0x0000,
0x0716,0x0000,0x0000, 0x0717,0x0000,0x0000, 0x0718,0x0000,0x0000,
0x0719,0x0000,0x0000, 0x071A,0x0000,0x0000, 0x071B,0x0000,0x0000,
0x071C,0x0000,0x0000, 0x071D,0x0000,0x0000, 0x071E,0x0000,0x0000,
0x071F,0x0000,0x0000, 0x0720,0x0000,0x0000, 0x0721,0x0000,0x0000,
0x0722,0x0000,0x0000, 0x0723,0x0000,0x0000, 0x0724,0x0000,0x0000,
0x0725,0x0000,0x0000, 0x0726,0x0000,0x0000, 0x0727,0x0000,0x0000,
0x0728,0x0000,0x0000, 0x0729,0x0000,0x0000, 0x072A,0x0000,0x0000,
0x0B2F,0x0000,0x0000, 0x0B30,0x0000,0x0000, 0x0B31,0x0000,0x0000,
0x0B32,0x0000,0x0000, 0x0B33,0x0000,0x0000, 0x0B34,0x0000,0x0000,
0x0B35,0x0000,0x0000, 0x0B36,0x0000,0x0000, 0x072B,0x0000,0x0000,
0x072C,0x0000,0x0000, 0x072D,0x0000,0x0000, 0x072E,0x0000,0x0000,
0x072F,0x0000,0x0000, 0x0730,0x0000,0x0000, 0x0731,0x0000,0x0000,
0x0732,0x0000,0x0000, 0x0733,0x0000,0x0000, 0x0734,0x0000,0x0000,
0x0735,0x0000,0x0000, 0x0736,0x0000,0x0000, 0x0737,0x0000,0x0000,
0x0738,0x0000,0x0000, 0x0739,0x0000,0x0000, 0x073A,0x0000,0x0000,
0x073B,0x0000,0x0000, 0x073C,0x0000,0x0000, 0x073D,0x0000,0x0000,
0x073E,0x0000,0x0000, 0x073F,0x0000,0x0000, 0x0740,0x0000,0x0000,
0x0741,0x0000,0x0000, 0x0742,0x0000,0x0000, 0x0743,0x0000,0x0000,
0x0744,0x0000,0x0000, 0x0745,0x0000,0x0000, 0x0746,0x0000,0x0000,
0x0747,0x0000,0x0000, 0x0748,0x0000,0x0000, 0x0749,0x0000,0x0000,
0x074A,0x0000,0x0000, 0x074B,0x0000,0x0000, 0x074C,0x0000,0x0000,
0x074D,0x0000,0x0000, 0x074E,0x0000,0x0000, 0x074F,0x0000,0x0000,
0x0750,0x0000,0x0000, 0x0751,0x0000,0x0000, 0x0752,0x0000,0x0000,
0x0753,0x0000,0x0000, 0x0754,0x0000,0x0000, 0x0755,0x0000,0x0000,
0x0756,0x0000,0x0000, 0x0757,0x0000,0x0000, 0x0758,0x0000,0x0000,
0x0759,0x0000,0x0000, 0x075A,0x0000,0x0000, 0x075B,0x0000,0x0000,
0x075C,0x0000,0x0000, 0x075D,0x0000,0x0000, 0x075E,0x0000,0x0000,
0x075F,0x0000,0x0000, 0x0D2B,0x0000,0x0000, 0x0D2C,0x0000,0x0000,
0x0D2D,0x0000,0x0000, 0x0760,0x0000,0x0000, 0x0761,0x0000,0x0000,
0x0762,0x0000,0x0000, 0x0763,0x0000,0x0000, 0x0764,0x0000,0x0000,
0x0765,0x0000,0x0000, 0x0766,0x0000,0x0000, 0x0767,0x0000,0x0000,
0x0768,0x0000,0x0000, 0x0769,0x0000,0x0000, 0x076A,0x0000,0x0000,
0x076B,0x0000,0x0000, 0x076C,0x0000,0x0000, 0x076D,0x0000,0x0000,
0xFBC0,0xA67E,0x0000, 0xFBC0,0xA67F,0x0000, 0x076E,0x0000,0x0000,
0x076F,0x0000,0x0000, 0x0770,0x0000,0x0000, 0x0771,0x0000,0x0000,
0x0772,0x0000,0x0000, 0x0773,0x0000,0x0000, 0x0774,0x0000,0x0000,
0x0775,0x0000,0x0000, 0x0776,0x0000,0x0000, 0x0777,0x0000,0x0000,
0x0B29,0x0000,0x0000, 0x0B2A,0x0000,0x0000, 0x0B2B,0x0000,0x0000,
0x0B2C,0x0000,0x0000, 0x0B2D,0x0000,0x0000, 0x0B2E,0x0000,0x0000,
0x0778,0x0000,0x0000, 0x0779,0x0000,0x0000, 0xFBC0,0xA692,0x0000,
0xFBC0,0xA693,0x0000, 0xFBC0,0xA694,0x0000, 0xFBC0,0xA695,0x0000,
0xFBC0,0xA696,0x0000, 0xFBC0,0xA697,0x0000, 0xFBC0,0xA698,0x0000,
0xFBC0,0xA699,0x0000, 0xFBC0,0xA69A,0x0000, 0xFBC0,0xA69B,0x0000,
0xFBC0,0xA69C,0x0000, 0xFBC0,0xA69D,0x0000, 0xFBC0,0xA69E,0x0000,
0xFBC0,0xA69F,0x0000, 0x077A,0x0000,0x0000, 0x077B,0x0000,0x0000,
0xFBC0,0xA6A2,0x0000, 0xFBC0,0xA6A3,0x0000, 0xFBC0,0xA6A4,0x0000,
0xFBC0,0xA6A5,0x0000, 0xFBC0,0xA6A6,0x0000, 0xFBC0,0xA6A7,0x0000,
0xFBC0,0xA6A8,0x0000, 0xFBC0,0xA6A9,0x0000, 0xFBC0,0xA6AA,0x0000,
0xFBC0,0xA6AB,0x0000, 0xFBC0,0xA6AC,0x0000, 0xFBC0,0xA6AD,0x0000,
0xFBC0,0xA6AE,0x0000, 0xFBC0,0xA6AF,0x0000, 0xFBC0,0xA6B0,0x0000,
0xFBC0,0xA6B1,0x0000, 0xFBC0,0xA6B2,0x0000, 0xFBC0,0xA6B3,0x0000,
0xFBC0,0xA6B4,0x0000, 0xFBC0,0xA6B5,0x0000, 0xFBC0,0xA6B6,0x0000,
0xFBC0,0xA6B7,0x0000, 0xFBC0,0xA6B8,0x0000, 0xFBC0,0xA6B9,0x0000,
0xFBC0,0xA6BA,0x0000, 0xFBC0,0xA6BB,0x0000, 0xFBC0,0xA6BC,0x0000,
0xFBC0,0xA6BD,0x0000, 0xFBC0,0xA6BE,0x0000, 0xFBC0,0xA6BF,0x0000,
0xFBC0,0xA6C0,0x0000, 0xFBC0,0xA6C1,0x0000, 0xFBC0,0xA6C2,0x0000,
0xFBC0,0xA6C3,0x0000, 0xFBC0,0xA6C4,0x0000, 0xFBC0,0xA6C5,0x0000,
0xFBC0,0xA6C6,0x0000, 0xFBC0,0xA6C7,0x0000, 0xFBC0,0xA6C8,0x0000,
0xFBC0,0xA6C9,0x0000, 0xFBC0,0xA6CA,0x0000, 0xFBC0,0xA6CB,0x0000,
0xFBC0,0xA6CC,0x0000, 0xFBC0,0xA6CD,0x0000, 0xFBC0,0xA6CE,0x0000,
0xFBC0,0xA6CF,0x0000, 0xFBC0,0xA6D0,0x0000, 0xFBC0,0xA6D1,0x0000,
0xFBC0,0xA6D2,0x0000, 0xFBC0,0xA6D3,0x0000, 0xFBC0,0xA6D4,0x0000,
0xFBC0,0xA6D5,0x0000, 0xFBC0,0xA6D6,0x0000, 0xFBC0,0xA6D7,0x0000,
0xFBC0,0xA6D8,0x0000, 0xFBC0,0xA6D9,0x0000, 0xFBC0,0xA6DA,0x0000,
0xFBC0,0xA6DB,0x0000, 0xFBC0,0xA6DC,0x0000, 0xFBC0,0xA6DD,0x0000,
0xFBC0,0xA6DE,0x0000, 0xFBC0,0xA6DF,0x0000, 0xFBC0,0xA6E0,0x0000,
0xFBC0,0xA6E1,0x0000, 0xFBC0,0xA6E2,0x0000, 0xFBC0,0xA6E3,0x0000,
0xFBC0,0xA6E4,0x0000, 0xFBC0,0xA6E5,0x0000, 0xFBC0,0xA6E6,0x0000,
0xFBC0,0xA6E7,0x0000, 0xFBC0,0xA6E8,0x0000, 0xFBC0,0xA6E9,0x0000,
0xFBC0,0xA6EA,0x0000, 0xFBC0,0xA6EB,0x0000, 0xFBC0,0xA6EC,0x0000,
0xFBC0,0xA6ED,0x0000, 0xFBC0,0xA6EE,0x0000, 0xFBC0,0xA6EF,0x0000,
0xFBC0,0xA6F0,0x0000, 0xFBC0,0xA6F1,0x0000, 0xFBC0,0xA6F2,0x0000,
0xFBC0,0xA6F3,0x0000, 0xFBC0,0xA6F4,0x0000, 0xFBC0,0xA6F5,0x0000,
0xFBC0,0xA6F6,0x0000, 0xFBC0,0xA6F7,0x0000, 0xFBC0,0xA6F8,0x0000,
0xFBC0,0xA6F9,0x0000, 0xFBC0,0xA6FA,0x0000, 0xFBC0,0xA6FB,0x0000,
0xFBC0,0xA6FC,0x0000, 0xFBC0,0xA6FD,0x0000, 0xFBC0,0xA6FE,0x0000,
0xFBC0,0xA6FF,0x0000 };

uint16 page027data[]= { /* 2700 (3 weights per char) */
0xFBC0,0xA700,0x0000, 0x077C,0x0000,0x0000, 0x077D,0x0000,0x0000,
0x077E,0x0000,0x0000, 0x077F,0x0000,0x0000, 0xFBC0,0xA705,0x0000,
0x0780,0x0000,0x0000, 0x0781,0x0000,0x0000, 0x0782,0x0000,0x0000,
0x0783,0x0000,0x0000, 0xFBC0,0xA70A,0x0000, 0xFBC0,0xA70B,0x0000,
0x0784,0x0000,0x0000, 0x0785,0x0000,0x0000, 0x0786,0x0000,0x0000,
0x0787,0x0000,0x0000, 0x0788,0x0000,0x0000, 0x0789,0x0000,0x0000,
0x078A,0x0000,0x0000, 0x078B,0x0000,0x0000, 0x078C,0x0000,0x0000,
0x078D,0x0000,0x0000, 0x078E,0x0000,0x0000, 0x078F,0x0000,0x0000,
0x0790,0x0000,0x0000, 0x0791,0x0000,0x0000, 0x0792,0x0000,0x0000,
0x0793,0x0000,0x0000, 0x0794,0x0000,0x0000, 0x0795,0x0000,0x0000,
0x0796,0x0000,0x0000, 0x0797,0x0000,0x0000, 0x0798,0x0000,0x0000,
0x0799,0x0000,0x0000, 0x079A,0x0000,0x0000, 0x079B,0x0000,0x0000,
0x079C,0x0000,0x0000, 0x079D,0x0000,0x0000, 0x079E,0x0000,0x0000,
0x079F,0x0000,0x0000, 0xFBC0,0xA728,0x0000, 0x07A0,0x0000,0x0000,
0x07A1,0x0000,0x0000, 0x07A2,0x0000,0x0000, 0x07A3,0x0000,0x0000,
0x07A4,0x0000,0x0000, 0x07A5,0x0000,0x0000, 0x07A6,0x0000,0x0000,
0x07A7,0x0000,0x0000, 0x07A8,0x0000,0x0000, 0x07A9,0x0000,0x0000,
0x07AA,0x0000,0x0000, 0x07AB,0x0000,0x0000, 0x07AC,0x0000,0x0000,
0x07AD,0x0000,0x0000, 0x07AE,0x0000,0x0000, 0x07AF,0x0000,0x0000,
0x07B0,0x0000,0x0000, 0x07B1,0x0000,0x0000, 0x07B2,0x0000,0x0000,
0x07B3,0x0000,0x0000, 0x07B4,0x0000,0x0000, 0x07B5,0x0000,0x0000,
0x07B6,0x0000,0x0000, 0x07B7,0x0000,0x0000, 0x07B8,0x0000,0x0000,
0x07B9,0x0000,0x0000, 0x07BA,0x0000,0x0000, 0x07BB,0x0000,0x0000,
0x07BC,0x0000,0x0000, 0x07BD,0x0000,0x0000, 0x07BE,0x0000,0x0000,
0x07BF,0x0000,0x0000, 0x07C0,0x0000,0x0000, 0x07C1,0x0000,0x0000,
0x07C2,0x0000,0x0000, 0xFBC0,0xA74C,0x0000, 0x07C3,0x0000,0x0000,
0xFBC0,0xA74E,0x0000, 0x07C4,0x0000,0x0000, 0x07C5,0x0000,0x0000,
0x07C6,0x0000,0x0000, 0x07C7,0x0000,0x0000, 0xFBC0,0xA753,0x0000,
0xFBC0,0xA754,0x0000, 0xFBC0,0xA755,0x0000, 0x07C8,0x0000,0x0000,
0xFBC0,0xA757,0x0000, 0x07C9,0x0000,0x0000, 0x07CA,0x0000,0x0000,
0x07CB,0x0000,0x0000, 0x07CC,0x0000,0x0000, 0x07CD,0x0000,0x0000,
0x07CE,0x0000,0x0000, 0x07CF,0x0000,0x0000, 0xFBC0,0xA75F,0x0000,
0xFBC0,0xA760,0x0000, 0x07D0,0x0000,0x0000, 0x07D1,0x0000,0x0000,
0x07D2,0x0000,0x0000, 0x07D3,0x0000,0x0000, 0x07D4,0x0000,0x0000,
0x07D5,0x0000,0x0000, 0x07D6,0x0000,0x0000, 0x07D7,0x0000,0x0000,
0x07D8,0x0000,0x0000, 0x07D9,0x0000,0x0000, 0x07DA,0x0000,0x0000,
0x07DB,0x0000,0x0000, 0x07DC,0x0000,0x0000, 0x07DD,0x0000,0x0000,
0x07DE,0x0000,0x0000, 0x07DF,0x0000,0x0000, 0x07E0,0x0000,0x0000,
0x07E1,0x0000,0x0000, 0x07E2,0x0000,0x0000, 0x07E3,0x0000,0x0000,
0x07E4,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0x0E2A,0x0E29,0x0000, 0x0E2A,0x0000,0x0000,
0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000,
0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000,
0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000, 0x0E2A,0x0E29,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x0E2A,0x0E29,0x0000, 0x07E5,0x0000,0x0000, 0xFBC0,0xA795,0x0000,
0xFBC0,0xA796,0x0000, 0xFBC0,0xA797,0x0000, 0x07E6,0x0000,0x0000,
0x07E7,0x0000,0x0000, 0x07E8,0x0000,0x0000, 0x07E9,0x0000,0x0000,
0x07EA,0x0000,0x0000, 0x07EB,0x0000,0x0000, 0x07EC,0x0000,0x0000,
0x07ED,0x0000,0x0000, 0x07EE,0x0000,0x0000, 0x07EF,0x0000,0x0000,
0x07F0,0x0000,0x0000, 0x07F1,0x0000,0x0000, 0x07F2,0x0000,0x0000,
0x07F3,0x0000,0x0000, 0x07F4,0x0000,0x0000, 0x07F5,0x0000,0x0000,
0x07F6,0x0000,0x0000, 0x07F7,0x0000,0x0000, 0x07F8,0x0000,0x0000,
0x07F9,0x0000,0x0000, 0x07FA,0x0000,0x0000, 0x07FB,0x0000,0x0000,
0x07FC,0x0000,0x0000, 0x07FD,0x0000,0x0000, 0xFBC0,0xA7B0,0x0000,
0x07FE,0x0000,0x0000, 0x07FF,0x0000,0x0000, 0x0800,0x0000,0x0000,
0x0801,0x0000,0x0000, 0x0802,0x0000,0x0000, 0x0803,0x0000,0x0000,
0x0804,0x0000,0x0000, 0x0805,0x0000,0x0000, 0x0806,0x0000,0x0000,
0x0807,0x0000,0x0000, 0x0808,0x0000,0x0000, 0x0809,0x0000,0x0000,
0x080A,0x0000,0x0000, 0x080B,0x0000,0x0000, 0xFBC0,0xA7BF,0x0000,
0xFBC0,0xA7C0,0x0000, 0xFBC0,0xA7C1,0x0000, 0xFBC0,0xA7C2,0x0000,
0xFBC0,0xA7C3,0x0000, 0xFBC0,0xA7C4,0x0000, 0xFBC0,0xA7C5,0x0000,
0xFBC0,0xA7C6,0x0000, 0xFBC0,0xA7C7,0x0000, 0xFBC0,0xA7C8,0x0000,
0xFBC0,0xA7C9,0x0000, 0xFBC0,0xA7CA,0x0000, 0xFBC0,0xA7CB,0x0000,
0xFBC0,0xA7CC,0x0000, 0xFBC0,0xA7CD,0x0000, 0xFBC0,0xA7CE,0x0000,
0xFBC0,0xA7CF,0x0000, 0x080C,0x0000,0x0000, 0x080D,0x0000,0x0000,
0x080E,0x0000,0x0000, 0x080F,0x0000,0x0000, 0x0810,0x0000,0x0000,
0x0811,0x0000,0x0000, 0x0812,0x0000,0x0000, 0x0813,0x0000,0x0000,
0x0814,0x0000,0x0000, 0x0815,0x0000,0x0000, 0x0816,0x0000,0x0000,
0x0817,0x0000,0x0000, 0x0818,0x0000,0x0000, 0x0819,0x0000,0x0000,
0x081A,0x0000,0x0000, 0x081B,0x0000,0x0000, 0x081C,0x0000,0x0000,
0x081D,0x0000,0x0000, 0x081E,0x0000,0x0000, 0x081F,0x0000,0x0000,
0x0820,0x0000,0x0000, 0x0821,0x0000,0x0000, 0x0822,0x0000,0x0000,
0x0823,0x0000,0x0000, 0x0824,0x0000,0x0000, 0x0825,0x0000,0x0000,
0x0826,0x0000,0x0000, 0x0827,0x0000,0x0000, 0xFBC0,0xA7EC,0x0000,
0xFBC0,0xA7ED,0x0000, 0xFBC0,0xA7EE,0x0000, 0xFBC0,0xA7EF,0x0000,
0x0828,0x0000,0x0000, 0x0829,0x0000,0x0000, 0x082A,0x0000,0x0000,
0x082B,0x0000,0x0000, 0x082C,0x0000,0x0000, 0x082D,0x0000,0x0000,
0x082E,0x0000,0x0000, 0x082F,0x0000,0x0000, 0x0830,0x0000,0x0000,
0x0831,0x0000,0x0000, 0x0832,0x0000,0x0000, 0x0833,0x0000,0x0000,
0x0834,0x0000,0x0000, 0x0835,0x0000,0x0000, 0x0836,0x0000,0x0000,
0x0837,0x0000,0x0000 };

uint16 page028data[]= { /* 2800 (2 weights per char) */
0x0A29,0x0000, 0x0A2A,0x0000, 0x0A2B,0x0000, 0x0A2C,0x0000,
0x0A2D,0x0000, 0x0A2E,0x0000, 0x0A2F,0x0000, 0x0A30,0x0000,
0x0A31,0x0000, 0x0A32,0x0000, 0x0A33,0x0000, 0x0A34,0x0000,
0x0A35,0x0000, 0x0A36,0x0000, 0x0A37,0x0000, 0x0A38,0x0000,
0x0A39,0x0000, 0x0A3A,0x0000, 0x0A3B,0x0000, 0x0A3C,0x0000,
0x0A3D,0x0000, 0x0A3E,0x0000, 0x0A3F,0x0000, 0x0A40,0x0000,
0x0A41,0x0000, 0x0A42,0x0000, 0x0A43,0x0000, 0x0A44,0x0000,
0x0A45,0x0000, 0x0A46,0x0000, 0x0A47,0x0000, 0x0A48,0x0000,
0x0A49,0x0000, 0x0A4A,0x0000, 0x0A4B,0x0000, 0x0A4C,0x0000,
0x0A4D,0x0000, 0x0A4E,0x0000, 0x0A4F,0x0000, 0x0A50,0x0000,
0x0A51,0x0000, 0x0A52,0x0000, 0x0A53,0x0000, 0x0A54,0x0000,
0x0A55,0x0000, 0x0A56,0x0000, 0x0A57,0x0000, 0x0A58,0x0000,
0x0A59,0x0000, 0x0A5A,0x0000, 0x0A5B,0x0000, 0x0A5C,0x0000,
0x0A5D,0x0000, 0x0A5E,0x0000, 0x0A5F,0x0000, 0x0A60,0x0000,
0x0A61,0x0000, 0x0A62,0x0000, 0x0A63,0x0000, 0x0A64,0x0000,
0x0A65,0x0000, 0x0A66,0x0000, 0x0A67,0x0000, 0x0A68,0x0000,
0x0A69,0x0000, 0x0A6A,0x0000, 0x0A6B,0x0000, 0x0A6C,0x0000,
0x0A6D,0x0000, 0x0A6E,0x0000, 0x0A6F,0x0000, 0x0A70,0x0000,
0x0A71,0x0000, 0x0A72,0x0000, 0x0A73,0x0000, 0x0A74,0x0000,
0x0A75,0x0000, 0x0A76,0x0000, 0x0A77,0x0000, 0x0A78,0x0000,
0x0A79,0x0000, 0x0A7A,0x0000, 0x0A7B,0x0000, 0x0A7C,0x0000,
0x0A7D,0x0000, 0x0A7E,0x0000, 0x0A7F,0x0000, 0x0A80,0x0000,
0x0A81,0x0000, 0x0A82,0x0000, 0x0A83,0x0000, 0x0A84,0x0000,
0x0A85,0x0000, 0x0A86,0x0000, 0x0A87,0x0000, 0x0A88,0x0000,
0x0A89,0x0000, 0x0A8A,0x0000, 0x0A8B,0x0000, 0x0A8C,0x0000,
0x0A8D,0x0000, 0x0A8E,0x0000, 0x0A8F,0x0000, 0x0A90,0x0000,
0x0A91,0x0000, 0x0A92,0x0000, 0x0A93,0x0000, 0x0A94,0x0000,
0x0A95,0x0000, 0x0A96,0x0000, 0x0A97,0x0000, 0x0A98,0x0000,
0x0A99,0x0000, 0x0A9A,0x0000, 0x0A9B,0x0000, 0x0A9C,0x0000,
0x0A9D,0x0000, 0x0A9E,0x0000, 0x0A9F,0x0000, 0x0AA0,0x0000,
0x0AA1,0x0000, 0x0AA2,0x0000, 0x0AA3,0x0000, 0x0AA4,0x0000,
0x0AA5,0x0000, 0x0AA6,0x0000, 0x0AA7,0x0000, 0x0AA8,0x0000,
0x0AA9,0x0000, 0x0AAA,0x0000, 0x0AAB,0x0000, 0x0AAC,0x0000,
0x0AAD,0x0000, 0x0AAE,0x0000, 0x0AAF,0x0000, 0x0AB0,0x0000,
0x0AB1,0x0000, 0x0AB2,0x0000, 0x0AB3,0x0000, 0x0AB4,0x0000,
0x0AB5,0x0000, 0x0AB6,0x0000, 0x0AB7,0x0000, 0x0AB8,0x0000,
0x0AB9,0x0000, 0x0ABA,0x0000, 0x0ABB,0x0000, 0x0ABC,0x0000,
0x0ABD,0x0000, 0x0ABE,0x0000, 0x0ABF,0x0000, 0x0AC0,0x0000,
0x0AC1,0x0000, 0x0AC2,0x0000, 0x0AC3,0x0000, 0x0AC4,0x0000,
0x0AC5,0x0000, 0x0AC6,0x0000, 0x0AC7,0x0000, 0x0AC8,0x0000,
0x0AC9,0x0000, 0x0ACA,0x0000, 0x0ACB,0x0000, 0x0ACC,0x0000,
0x0ACD,0x0000, 0x0ACE,0x0000, 0x0ACF,0x0000, 0x0AD0,0x0000,
0x0AD1,0x0000, 0x0AD2,0x0000, 0x0AD3,0x0000, 0x0AD4,0x0000,
0x0AD5,0x0000, 0x0AD6,0x0000, 0x0AD7,0x0000, 0x0AD8,0x0000,
0x0AD9,0x0000, 0x0ADA,0x0000, 0x0ADB,0x0000, 0x0ADC,0x0000,
0x0ADD,0x0000, 0x0ADE,0x0000, 0x0ADF,0x0000, 0x0AE0,0x0000,
0x0AE1,0x0000, 0x0AE2,0x0000, 0x0AE3,0x0000, 0x0AE4,0x0000,
0x0AE5,0x0000, 0x0AE6,0x0000, 0x0AE7,0x0000, 0x0AE8,0x0000,
0x0AE9,0x0000, 0x0AEA,0x0000, 0x0AEB,0x0000, 0x0AEC,0x0000,
0x0AED,0x0000, 0x0AEE,0x0000, 0x0AEF,0x0000, 0x0AF0,0x0000,
0x0AF1,0x0000, 0x0AF2,0x0000, 0x0AF3,0x0000, 0x0AF4,0x0000,
0x0AF5,0x0000, 0x0AF6,0x0000, 0x0AF7,0x0000, 0x0AF8,0x0000,
0x0AF9,0x0000, 0x0AFA,0x0000, 0x0AFB,0x0000, 0x0AFC,0x0000,
0x0AFD,0x0000, 0x0AFE,0x0000, 0x0AFF,0x0000, 0x0B00,0x0000,
0x0B01,0x0000, 0x0B02,0x0000, 0x0B03,0x0000, 0x0B04,0x0000,
0x0B05,0x0000, 0x0B06,0x0000, 0x0B07,0x0000, 0x0B08,0x0000,
0x0B09,0x0000, 0x0B0A,0x0000, 0x0B0B,0x0000, 0x0B0C,0x0000,
0x0B0D,0x0000, 0x0B0E,0x0000, 0x0B0F,0x0000, 0x0B10,0x0000,
0x0B11,0x0000, 0x0B12,0x0000, 0x0B13,0x0000, 0x0B14,0x0000,
0x0B15,0x0000, 0x0B16,0x0000, 0x0B17,0x0000, 0x0B18,0x0000,
0x0B19,0x0000, 0x0B1A,0x0000, 0x0B1B,0x0000, 0x0B1C,0x0000,
0x0B1D,0x0000, 0x0B1E,0x0000, 0x0B1F,0x0000, 0x0B20,0x0000,
0x0B21,0x0000, 0x0B22,0x0000, 0x0B23,0x0000, 0x0B24,0x0000,
0x0B25,0x0000, 0x0B26,0x0000, 0x0B27,0x0000, 0x0B28,0x0000
};

uint16 page029data[]= { /* 2900 (2 weights per char) */
0x0838,0x0000, 0x0839,0x0000, 0x083A,0x0000, 0x083B,0x0000,
0x083C,0x0000, 0x083D,0x0000, 0x083E,0x0000, 0x083F,0x0000,
0x0840,0x0000, 0x0841,0x0000, 0x0842,0x0000, 0x0843,0x0000,
0x0844,0x0000, 0x0845,0x0000, 0x0846,0x0000, 0x0847,0x0000,
0x0848,0x0000, 0x0849,0x0000, 0x084A,0x0000, 0x084B,0x0000,
0x084C,0x0000, 0x084D,0x0000, 0x084E,0x0000, 0x084F,0x0000,
0x0850,0x0000, 0x0851,0x0000, 0x0852,0x0000, 0x0853,0x0000,
0x0854,0x0000, 0x0855,0x0000, 0x0856,0x0000, 0x0857,0x0000,
0x0858,0x0000, 0x0859,0x0000, 0x085A,0x0000, 0x085B,0x0000,
0x085C,0x0000, 0x085D,0x0000, 0x085E,0x0000, 0x085F,0x0000,
0x0860,0x0000, 0x0861,0x0000, 0x0862,0x0000, 0x0863,0x0000,
0x0864,0x0000, 0x0865,0x0000, 0x0866,0x0000, 0x0867,0x0000,
0x0868,0x0000, 0x0869,0x0000, 0x086A,0x0000, 0x086B,0x0000,
0x086C,0x0000, 0x086D,0x0000, 0x086E,0x0000, 0x086F,0x0000,
0x0870,0x0000, 0x0871,0x0000, 0x0872,0x0000, 0x0873,0x0000,
0x0874,0x0000, 0x0875,0x0000, 0x0876,0x0000, 0x0877,0x0000,
0x0878,0x0000, 0x0879,0x0000, 0x087A,0x0000, 0x087B,0x0000,
0x087C,0x0000, 0x087D,0x0000, 0x087E,0x0000, 0x087F,0x0000,
0x0880,0x0000, 0x0881,0x0000, 0x0882,0x0000, 0x0883,0x0000,
0x0884,0x0000, 0x0885,0x0000, 0x0886,0x0000, 0x0887,0x0000,
0x0888,0x0000, 0x0889,0x0000, 0x088A,0x0000, 0x088B,0x0000,
0x088C,0x0000, 0x088D,0x0000, 0x088E,0x0000, 0x088F,0x0000,
0x0890,0x0000, 0x0891,0x0000, 0x0892,0x0000, 0x0893,0x0000,
0x0894,0x0000, 0x0895,0x0000, 0x0896,0x0000, 0x0897,0x0000,
0x0898,0x0000, 0x0899,0x0000, 0x089A,0x0000, 0x089B,0x0000,
0x089C,0x0000, 0x089D,0x0000, 0x089E,0x0000, 0x089F,0x0000,
0x08A0,0x0000, 0x08A1,0x0000, 0x08A2,0x0000, 0x08A3,0x0000,
0x08A4,0x0000, 0x08A5,0x0000, 0x08A6,0x0000, 0x08A7,0x0000,
0x08A8,0x0000, 0x08A9,0x0000, 0x08AA,0x0000, 0x08AB,0x0000,
0x08AC,0x0000, 0x08AD,0x0000, 0x08AE,0x0000, 0x08AF,0x0000,
0x08B0,0x0000, 0x08B1,0x0000, 0x08B2,0x0000, 0x08B3,0x0000,
0x08B4,0x0000, 0x08B5,0x0000, 0x08B6,0x0000, 0x08B7,0x0000,
0x08B8,0x0000, 0x08B9,0x0000, 0x08BA,0x0000, 0x0298,0x0000,
0x0299,0x0000, 0x029A,0x0000, 0x029B,0x0000, 0x029C,0x0000,
0x029D,0x0000, 0x029E,0x0000, 0x029F,0x0000, 0x02A0,0x0000,
0x02A1,0x0000, 0x02A2,0x0000, 0x02A3,0x0000, 0x02A4,0x0000,
0x02A5,0x0000, 0x02A6,0x0000, 0x02A7,0x0000, 0x02A8,0x0000,
0x02A9,0x0000, 0x02AA,0x0000, 0x02AB,0x0000, 0x02AC,0x0000,
0x02AD,0x0000, 0x08BB,0x0000, 0x08BC,0x0000, 0x08BD,0x0000,
0x08BE,0x0000, 0x08BF,0x0000, 0x08C0,0x0000, 0x08C1,0x0000,
0x08C2,0x0000, 0x08C3,0x0000, 0x08C4,0x0000, 0x08C5,0x0000,
0x08C6,0x0000, 0x08C7,0x0000, 0x08C8,0x0000, 0x08C9,0x0000,
0x08CA,0x0000, 0x08CB,0x0000, 0x08CC,0x0000, 0x08CD,0x0000,
0x08CE,0x0000, 0x08CF,0x0000, 0x08D0,0x0000, 0x08D1,0x0000,
0x08D2,0x0000, 0x08D3,0x0000, 0x08D4,0x0000, 0x08D5,0x0000,
0x08D6,0x0000, 0x08D7,0x0000, 0x08D8,0x0000, 0x08D9,0x0000,
0x08DA,0x0000, 0x08DB,0x0000, 0x08DC,0x0000, 0x08DD,0x0000,
0x08DE,0x0000, 0x08DF,0x0000, 0x08E0,0x0000, 0x08E1,0x0000,
0x08E2,0x0000, 0x08E3,0x0000, 0x08E4,0x0000, 0x08E5,0x0000,
0x08E6,0x0000, 0x08E7,0x0000, 0x08E8,0x0000, 0x08E9,0x0000,
0x08EA,0x0000, 0x08EB,0x0000, 0x08EC,0x0000, 0x08ED,0x0000,
0x08EE,0x0000, 0x08EF,0x0000, 0x08F0,0x0000, 0x08F1,0x0000,
0x08F2,0x0000, 0x08F3,0x0000, 0x08F4,0x0000, 0x08F5,0x0000,
0x08F6,0x0000, 0x08F7,0x0000, 0x08F8,0x0000, 0x08F9,0x0000,
0x08FA,0x0000, 0x08FB,0x0000, 0x08FC,0x0000, 0x08FD,0x0000,
0x08FE,0x0000, 0x08FF,0x0000, 0x0900,0x0000, 0x0901,0x0000,
0x0902,0x0000, 0x0903,0x0000, 0x0904,0x0000, 0x0905,0x0000,
0x0906,0x0000, 0x0907,0x0000, 0x0908,0x0000, 0x0909,0x0000,
0x090A,0x0000, 0x090B,0x0000, 0x090C,0x0000, 0x090D,0x0000,
0x090E,0x0000, 0x090F,0x0000, 0x0910,0x0000, 0x0911,0x0000,
0x0912,0x0000, 0x0913,0x0000, 0x0914,0x0000, 0x0915,0x0000,
0x0916,0x0000, 0x0917,0x0000, 0x0918,0x0000, 0x0919,0x0000,
0x091A,0x0000, 0x091B,0x0000, 0x091C,0x0000, 0x091D,0x0000,
0x0296,0x0000, 0x0297,0x0000, 0x091E,0x0000, 0x091F,0x0000
};

uint16 page02Adata[]= { /* 2A00 (5 weights per char) */
0x0920,0x0000,0x0000,0x0000,0x0000,
0x0921,0x0000,0x0000,0x0000,0x0000,
0x0922,0x0000,0x0000,0x0000,0x0000,
0x0923,0x0000,0x0000,0x0000,0x0000,
0x0924,0x0000,0x0000,0x0000,0x0000,
0x0925,0x0000,0x0000,0x0000,0x0000,
0x0926,0x0000,0x0000,0x0000,0x0000,
0x0927,0x0000,0x0000,0x0000,0x0000,
0x0928,0x0000,0x0000,0x0000,0x0000,
0x0929,0x0000,0x0000,0x0000,0x0000,
0x092A,0x0000,0x0000,0x0000,0x0000,
0x092B,0x0000,0x0000,0x0000,0x0000,
0x044B,0x044B,0x044B,0x044B,0x0000,
0x092C,0x0000,0x0000,0x0000,0x0000,
0x092D,0x0000,0x0000,0x0000,0x0000,
0x092E,0x0000,0x0000,0x0000,0x0000,
0x092F,0x0000,0x0000,0x0000,0x0000,
0x0930,0x0000,0x0000,0x0000,0x0000,
0x0931,0x0000,0x0000,0x0000,0x0000,
0x0932,0x0000,0x0000,0x0000,0x0000,
0x0933,0x0000,0x0000,0x0000,0x0000,
0x0934,0x0000,0x0000,0x0000,0x0000,
0x0935,0x0000,0x0000,0x0000,0x0000,
0x0936,0x0000,0x0000,0x0000,0x0000,
0x0937,0x0000,0x0000,0x0000,0x0000,
0x0938,0x0000,0x0000,0x0000,0x0000,
0x0939,0x0000,0x0000,0x0000,0x0000,
0x093A,0x0000,0x0000,0x0000,0x0000,
0x093B,0x0000,0x0000,0x0000,0x0000,
0x093C,0x0000,0x0000,0x0000,0x0000,
0x093D,0x0000,0x0000,0x0000,0x0000,
0x093E,0x0000,0x0000,0x0000,0x0000,
0x093F,0x0000,0x0000,0x0000,0x0000,
0x0940,0x0000,0x0000,0x0000,0x0000,
0x0941,0x0000,0x0000,0x0000,0x0000,
0x0942,0x0000,0x0000,0x0000,0x0000,
0x0943,0x0000,0x0000,0x0000,0x0000,
0x0944,0x0000,0x0000,0x0000,0x0000,
0x0945,0x0000,0x0000,0x0000,0x0000,
0x0946,0x0000,0x0000,0x0000,0x0000,
0x0947,0x0000,0x0000,0x0000,0x0000,
0x0948,0x0000,0x0000,0x0000,0x0000,
0x0949,0x0000,0x0000,0x0000,0x0000,
0x094A,0x0000,0x0000,0x0000,0x0000,
0x094B,0x0000,0x0000,0x0000,0x0000,
0x094C,0x0000,0x0000,0x0000,0x0000,
0x094D,0x0000,0x0000,0x0000,0x0000,
0x094E,0x0000,0x0000,0x0000,0x0000,
0x094F,0x0000,0x0000,0x0000,0x0000,
0x0950,0x0000,0x0000,0x0000,0x0000,
0x0951,0x0000,0x0000,0x0000,0x0000,
0x0952,0x0000,0x0000,0x0000,0x0000,
0x0953,0x0000,0x0000,0x0000,0x0000,
0x0954,0x0000,0x0000,0x0000,0x0000,
0x0955,0x0000,0x0000,0x0000,0x0000,
0x0956,0x0000,0x0000,0x0000,0x0000,
0x0957,0x0000,0x0000,0x0000,0x0000,
0x0958,0x0000,0x0000,0x0000,0x0000,
0x0959,0x0000,0x0000,0x0000,0x0000,
0x095A,0x0000,0x0000,0x0000,0x0000,
0x095B,0x0000,0x0000,0x0000,0x0000,
0x095C,0x0000,0x0000,0x0000,0x0000,
0x095D,0x0000,0x0000,0x0000,0x0000,
0x095E,0x0000,0x0000,0x0000,0x0000,
0x095F,0x0000,0x0000,0x0000,0x0000,
0x0960,0x0000,0x0000,0x0000,0x0000,
0x0961,0x0000,0x0000,0x0000,0x0000,
0x0962,0x0000,0x0000,0x0000,0x0000,
0x0963,0x0000,0x0000,0x0000,0x0000,
0x0964,0x0000,0x0000,0x0000,0x0000,
0x0965,0x0000,0x0000,0x0000,0x0000,
0x0966,0x0000,0x0000,0x0000,0x0000,
0x0967,0x0000,0x0000,0x0000,0x0000,
0x0968,0x0000,0x0000,0x0000,0x0000,
0x0969,0x0000,0x0000,0x0000,0x0000,
0x096A,0x0000,0x0000,0x0000,0x0000,
0x096B,0x0000,0x0000,0x0000,0x0000,
0x096C,0x0000,0x0000,0x0000,0x0000,
0x096D,0x0000,0x0000,0x0000,0x0000,
0x096E,0x0000,0x0000,0x0000,0x0000,
0x096F,0x0000,0x0000,0x0000,0x0000,
0x0970,0x0000,0x0000,0x0000,0x0000,
0x0971,0x0000,0x0000,0x0000,0x0000,
0x0972,0x0000,0x0000,0x0000,0x0000,
0x0973,0x0000,0x0000,0x0000,0x0000,
0x0974,0x0000,0x0000,0x0000,0x0000,
0x0975,0x0000,0x0000,0x0000,0x0000,
0x0976,0x0000,0x0000,0x0000,0x0000,
0x0977,0x0000,0x0000,0x0000,0x0000,
0x0978,0x0000,0x0000,0x0000,0x0000,
0x0979,0x0000,0x0000,0x0000,0x0000,
0x097A,0x0000,0x0000,0x0000,0x0000,
0x097B,0x0000,0x0000,0x0000,0x0000,
0x097C,0x0000,0x0000,0x0000,0x0000,
0x097D,0x0000,0x0000,0x0000,0x0000,
0x097E,0x0000,0x0000,0x0000,0x0000,
0x097F,0x0000,0x0000,0x0000,0x0000,
0x0980,0x0000,0x0000,0x0000,0x0000,
0x0981,0x0000,0x0000,0x0000,0x0000,
0x0982,0x0000,0x0000,0x0000,0x0000,
0x0983,0x0000,0x0000,0x0000,0x0000,
0x0984,0x0000,0x0000,0x0000,0x0000,
0x0985,0x0000,0x0000,0x0000,0x0000,
0x0986,0x0000,0x0000,0x0000,0x0000,
0x0987,0x0000,0x0000,0x0000,0x0000,
0x0988,0x0000,0x0000,0x0000,0x0000,
0x0989,0x0000,0x0000,0x0000,0x0000,
0x098A,0x0000,0x0000,0x0000,0x0000,
0x098B,0x0000,0x0000,0x0000,0x0000,
0x098C,0x0000,0x0000,0x0000,0x0000,
0x098D,0x0000,0x0000,0x0000,0x0000,
0x098E,0x0000,0x0000,0x0000,0x0000,
0x098F,0x0000,0x0000,0x0000,0x0000,
0x0990,0x0000,0x0000,0x0000,0x0000,
0x0991,0x0000,0x0000,0x0000,0x0000,
0x0992,0x0000,0x0000,0x0000,0x0000,
0x023D,0x023D,0x042D,0x0000,0x0000,
0x042D,0x042D,0x0000,0x0000,0x0000,
0x042D,0x042D,0x042D,0x0000,0x0000,
0x0993,0x0000,0x0000,0x0000,0x0000,
0x0994,0x0000,0x0000,0x0000,0x0000,
0x0995,0x0000,0x0000,0x0000,0x0000,
0x0996,0x0000,0x0000,0x0000,0x0000,
0x0997,0x0000,0x0000,0x0000,0x0000,
0x0998,0x0000,0x0000,0x0000,0x0000,
0x0999,0x0000,0x0000,0x0000,0x0000,
0x099A,0x0000,0x0000,0x0000,0x0000,
0x099B,0x0000,0x0000,0x0000,0x0000,
0x099C,0x0000,0x0000,0x0000,0x0000,
0x099D,0x0000,0x0000,0x0000,0x0000,
0x099E,0x0000,0x0000,0x0000,0x0000,
0x099F,0x0000,0x0000,0x0000,0x0000,
0x09A0,0x0000,0x0000,0x0000,0x0000,
0x09A1,0x0000,0x0000,0x0000,0x0000,
0x09A2,0x0000,0x0000,0x0000,0x0000,
0x09A3,0x0000,0x0000,0x0000,0x0000,
0x09A4,0x0000,0x0000,0x0000,0x0000,
0x09A5,0x0000,0x0000,0x0000,0x0000,
0x09A6,0x0000,0x0000,0x0000,0x0000,
0x09A7,0x0000,0x0000,0x0000,0x0000,
0x09A8,0x0000,0x0000,0x0000,0x0000,
0x09A9,0x0000,0x0000,0x0000,0x0000,
0x09AA,0x0000,0x0000,0x0000,0x0000,
0x09AB,0x0000,0x0000,0x0000,0x0000,
0x09AC,0x0000,0x0000,0x0000,0x0000,
0x09AD,0x0000,0x0000,0x0000,0x0000,
0x09AE,0x0000,0x0000,0x0000,0x0000,
0x09AF,0x0000,0x0000,0x0000,0x0000,
0x09B0,0x0000,0x0000,0x0000,0x0000,
0x09B1,0x0000,0x0000,0x0000,0x0000,
0x09B2,0x0000,0x0000,0x0000,0x0000,
0x09B3,0x0000,0x0000,0x0000,0x0000,
0x09B4,0x0000,0x0000,0x0000,0x0000,
0x09B5,0x0000,0x0000,0x0000,0x0000,
0x09B6,0x0000,0x0000,0x0000,0x0000,
0x09B7,0x0000,0x0000,0x0000,0x0000,
0x09B8,0x0000,0x0000,0x0000,0x0000,
0x09B9,0x0000,0x0000,0x0000,0x0000,
0x09BA,0x0000,0x0000,0x0000,0x0000,
0x09BB,0x0000,0x0000,0x0000,0x0000,
0x09BC,0x0000,0x0000,0x0000,0x0000,
0x09BD,0x0000,0x0000,0x0000,0x0000,
0x09BE,0x0000,0x0000,0x0000,0x0000,
0x09BF,0x0000,0x0000,0x0000,0x0000,
0x09C0,0x0000,0x0000,0x0000,0x0000,
0x09C1,0x0000,0x0000,0x0000,0x0000,
0x09C2,0x0000,0x0000,0x0000,0x0000,
0x09C3,0x0000,0x0000,0x0000,0x0000,
0x09C4,0x0000,0x0000,0x0000,0x0000,
0x09C5,0x0000,0x0000,0x0000,0x0000,
0x09C6,0x0000,0x0000,0x0000,0x0000,
0x09C7,0x0000,0x0000,0x0000,0x0000,
0x09C8,0x0000,0x0000,0x0000,0x0000,
0x09C9,0x0000,0x0000,0x0000,0x0000,
0x09CA,0x0000,0x0000,0x0000,0x0000,
0x09CB,0x0000,0x0000,0x0000,0x0000,
0x09CC,0x0000,0x0000,0x0000,0x0000,
0x09CD,0x0000,0x0000,0x0000,0x0000,
0x09CE,0x0000,0x0000,0x0000,0x0000,
0x09CF,0x0000,0x0000,0x0000,0x0000,
0x09D0,0x0000,0x0000,0x0000,0x0000,
0x09D1,0x0000,0x0000,0x0000,0x0000,
0x09D2,0x0000,0x0000,0x0000,0x0000,
0x09D3,0x0000,0x0000,0x0000,0x0000,
0x09D4,0x0000,0x0000,0x0000,0x0000,
0x09D5,0x0000,0x0000,0x0000,0x0000,
0x09D6,0x0000,0x0000,0x0000,0x0000,
0x09D7,0x0000,0x0000,0x0000,0x0000,
0x09D8,0x0000,0x0000,0x0000,0x0000,
0x09D9,0x0000,0x0000,0x0000,0x0000,
0x09DA,0x0000,0x0000,0x0000,0x0000,
0x09DB,0x0000,0x0000,0x0000,0x0000,
0x09DC,0x0000,0x0000,0x0000,0x0000,
0x09DD,0x0000,0x0000,0x0000,0x0000,
0x09DE,0x0000,0x0000,0x0000,0x0000,
0x09DF,0x0000,0x0000,0x0000,0x0000,
0x09E0,0x0000,0x0000,0x0000,0x0000,
0x09E1,0x0000,0x0000,0x0000,0x0000,
0x09E2,0x0000,0x0000,0x0000,0x0000,
0x09E3,0x0000,0x0000,0x0000,0x0000,
0x09E4,0x0000,0x0000,0x0000,0x0000,
0x09E5,0x0000,0x0000,0x0000,0x0000,
0x09E6,0x0000,0x0000,0x0000,0x0000,
0x09E7,0x0000,0x0000,0x0000,0x0000,
0x09E8,0x0000,0x0000,0x0000,0x0000,
0x09E9,0x0000,0x0000,0x0000,0x0000,
0x09EA,0x0000,0x0000,0x0000,0x0000,
0x09EB,0x0000,0x0000,0x0000,0x0000,
0x09EC,0x0000,0x0000,0x0000,0x0000,
0x09ED,0x0000,0x0000,0x0000,0x0000,
0x09EE,0x0000,0x0000,0x0000,0x0000,
0x09EF,0x0000,0x0000,0x0000,0x0000,
0x09F0,0x0000,0x0000,0x0000,0x0000,
0x09F1,0x0000,0x0000,0x0000,0x0000,
0x09F2,0x0000,0x0000,0x0000,0x0000,
0x09F3,0x0000,0x0000,0x0000,0x0000,
0x09F4,0x0000,0x0000,0x0000,0x0000,
0x09F5,0x0000,0x0000,0x0000,0x0000,
0x09F6,0x0000,0x0000,0x0000,0x0000,
0x09F7,0x0000,0x0000,0x0000,0x0000,
0x09F8,0x0000,0x0000,0x0000,0x0000,
0x09F8,0x0000,0x0000,0x0000,0x0000,
0x09F9,0x0000,0x0000,0x0000,0x0000,
0x09FA,0x0000,0x0000,0x0000,0x0000,
0x09FB,0x0000,0x0000,0x0000,0x0000,
0x09FC,0x0000,0x0000,0x0000,0x0000,
0x09FD,0x0000,0x0000,0x0000,0x0000,
0x09FE,0x0000,0x0000,0x0000,0x0000,
0x09FF,0x0000,0x0000,0x0000,0x0000,
0x0A00,0x0000,0x0000,0x0000,0x0000,
0x0A01,0x0000,0x0000,0x0000,0x0000,
0x0A02,0x0000,0x0000,0x0000,0x0000,
0x0A03,0x0000,0x0000,0x0000,0x0000,
0x0A04,0x0000,0x0000,0x0000,0x0000,
0x0A05,0x0000,0x0000,0x0000,0x0000,
0x0A06,0x0000,0x0000,0x0000,0x0000,
0x0A07,0x0000,0x0000,0x0000,0x0000,
0x0A08,0x0000,0x0000,0x0000,0x0000,
0x0A09,0x0000,0x0000,0x0000,0x0000,
0x0A0A,0x0000,0x0000,0x0000,0x0000,
0x0A0B,0x0000,0x0000,0x0000,0x0000,
0x0A0C,0x0000,0x0000,0x0000,0x0000,
0x0A0D,0x0000,0x0000,0x0000,0x0000,
0x0A0E,0x0000,0x0000,0x0000,0x0000,
0x0A0F,0x0000,0x0000,0x0000,0x0000,
0x0A10,0x0000,0x0000,0x0000,0x0000,
0x0A11,0x0000,0x0000,0x0000,0x0000,
0x0A12,0x0000,0x0000,0x0000,0x0000,
0x0A13,0x0000,0x0000,0x0000,0x0000,
0x0A14,0x0000,0x0000,0x0000,0x0000,
0x0A15,0x0000,0x0000,0x0000,0x0000,
0x0A16,0x0000,0x0000,0x0000,0x0000,
0x0A17,0x0000,0x0000,0x0000,0x0000,
0x0A18,0x0000,0x0000,0x0000,0x0000,
0x0A19,0x0000,0x0000,0x0000,0x0000,
0x0A1A,0x0000,0x0000,0x0000,0x0000
};

uint16 page02Bdata[]= { /* 2B00 (3 weights per char) */
0x0A1B,0x0000,0x0000, 0x0A1C,0x0000,0x0000, 0x0A1D,0x0000,0x0000,
0x0A1E,0x0000,0x0000, 0x0A1F,0x0000,0x0000, 0x0A20,0x0000,0x0000,
0x0A21,0x0000,0x0000, 0x0A22,0x0000,0x0000, 0x0A23,0x0000,0x0000,
0x0A24,0x0000,0x0000, 0x0A25,0x0000,0x0000, 0x0A26,0x0000,0x0000,
0x0A27,0x0000,0x0000, 0x0A28,0x0000,0x0000, 0xFBC0,0xAB0E,0x0000,
0xFBC0,0xAB0F,0x0000, 0xFBC0,0xAB10,0x0000, 0xFBC0,0xAB11,0x0000,
0xFBC0,0xAB12,0x0000, 0xFBC0,0xAB13,0x0000, 0xFBC0,0xAB14,0x0000,
0xFBC0,0xAB15,0x0000, 0xFBC0,0xAB16,0x0000, 0xFBC0,0xAB17,0x0000,
0xFBC0,0xAB18,0x0000, 0xFBC0,0xAB19,0x0000, 0xFBC0,0xAB1A,0x0000,
0xFBC0,0xAB1B,0x0000, 0xFBC0,0xAB1C,0x0000, 0xFBC0,0xAB1D,0x0000,
0xFBC0,0xAB1E,0x0000, 0xFBC0,0xAB1F,0x0000, 0xFBC0,0xAB20,0x0000,
0xFBC0,0xAB21,0x0000, 0xFBC0,0xAB22,0x0000, 0xFBC0,0xAB23,0x0000,
0xFBC0,0xAB24,0x0000, 0xFBC0,0xAB25,0x0000, 0xFBC0,0xAB26,0x0000,
0xFBC0,0xAB27,0x0000, 0xFBC0,0xAB28,0x0000, 0xFBC0,0xAB29,0x0000,
0xFBC0,0xAB2A,0x0000, 0xFBC0,0xAB2B,0x0000, 0xFBC0,0xAB2C,0x0000,
0xFBC0,0xAB2D,0x0000, 0xFBC0,0xAB2E,0x0000, 0xFBC0,0xAB2F,0x0000,
0xFBC0,0xAB30,0x0000, 0xFBC0,0xAB31,0x0000, 0xFBC0,0xAB32,0x0000,
0xFBC0,0xAB33,0x0000, 0xFBC0,0xAB34,0x0000, 0xFBC0,0xAB35,0x0000,
0xFBC0,0xAB36,0x0000, 0xFBC0,0xAB37,0x0000, 0xFBC0,0xAB38,0x0000,
0xFBC0,0xAB39,0x0000, 0xFBC0,0xAB3A,0x0000, 0xFBC0,0xAB3B,0x0000,
0xFBC0,0xAB3C,0x0000, 0xFBC0,0xAB3D,0x0000, 0xFBC0,0xAB3E,0x0000,
0xFBC0,0xAB3F,0x0000, 0xFBC0,0xAB40,0x0000, 0xFBC0,0xAB41,0x0000,
0xFBC0,0xAB42,0x0000, 0xFBC0,0xAB43,0x0000, 0xFBC0,0xAB44,0x0000,
0xFBC0,0xAB45,0x0000, 0xFBC0,0xAB46,0x0000, 0xFBC0,0xAB47,0x0000,
0xFBC0,0xAB48,0x0000, 0xFBC0,0xAB49,0x0000, 0xFBC0,0xAB4A,0x0000,
0xFBC0,0xAB4B,0x0000, 0xFBC0,0xAB4C,0x0000, 0xFBC0,0xAB4D,0x0000,
0xFBC0,0xAB4E,0x0000, 0xFBC0,0xAB4F,0x0000, 0xFBC0,0xAB50,0x0000,
0xFBC0,0xAB51,0x0000, 0xFBC0,0xAB52,0x0000, 0xFBC0,0xAB53,0x0000,
0xFBC0,0xAB54,0x0000, 0xFBC0,0xAB55,0x0000, 0xFBC0,0xAB56,0x0000,
0xFBC0,0xAB57,0x0000, 0xFBC0,0xAB58,0x0000, 0xFBC0,0xAB59,0x0000,
0xFBC0,0xAB5A,0x0000, 0xFBC0,0xAB5B,0x0000, 0xFBC0,0xAB5C,0x0000,
0xFBC0,0xAB5D,0x0000, 0xFBC0,0xAB5E,0x0000, 0xFBC0,0xAB5F,0x0000,
0xFBC0,0xAB60,0x0000, 0xFBC0,0xAB61,0x0000, 0xFBC0,0xAB62,0x0000,
0xFBC0,0xAB63,0x0000, 0xFBC0,0xAB64,0x0000, 0xFBC0,0xAB65,0x0000,
0xFBC0,0xAB66,0x0000, 0xFBC0,0xAB67,0x0000, 0xFBC0,0xAB68,0x0000,
0xFBC0,0xAB69,0x0000, 0xFBC0,0xAB6A,0x0000, 0xFBC0,0xAB6B,0x0000,
0xFBC0,0xAB6C,0x0000, 0xFBC0,0xAB6D,0x0000, 0xFBC0,0xAB6E,0x0000,
0xFBC0,0xAB6F,0x0000, 0xFBC0,0xAB70,0x0000, 0xFBC0,0xAB71,0x0000,
0xFBC0,0xAB72,0x0000, 0xFBC0,0xAB73,0x0000, 0xFBC0,0xAB74,0x0000,
0xFBC0,0xAB75,0x0000, 0xFBC0,0xAB76,0x0000, 0xFBC0,0xAB77,0x0000,
0xFBC0,0xAB78,0x0000, 0xFBC0,0xAB79,0x0000, 0xFBC0,0xAB7A,0x0000,
0xFBC0,0xAB7B,0x0000, 0xFBC0,0xAB7C,0x0000, 0xFBC0,0xAB7D,0x0000,
0xFBC0,0xAB7E,0x0000, 0xFBC0,0xAB7F,0x0000, 0xFBC0,0xAB80,0x0000,
0xFBC0,0xAB81,0x0000, 0xFBC0,0xAB82,0x0000, 0xFBC0,0xAB83,0x0000,
0xFBC0,0xAB84,0x0000, 0xFBC0,0xAB85,0x0000, 0xFBC0,0xAB86,0x0000,
0xFBC0,0xAB87,0x0000, 0xFBC0,0xAB88,0x0000, 0xFBC0,0xAB89,0x0000,
0xFBC0,0xAB8A,0x0000, 0xFBC0,0xAB8B,0x0000, 0xFBC0,0xAB8C,0x0000,
0xFBC0,0xAB8D,0x0000, 0xFBC0,0xAB8E,0x0000, 0xFBC0,0xAB8F,0x0000,
0xFBC0,0xAB90,0x0000, 0xFBC0,0xAB91,0x0000, 0xFBC0,0xAB92,0x0000,
0xFBC0,0xAB93,0x0000, 0xFBC0,0xAB94,0x0000, 0xFBC0,0xAB95,0x0000,
0xFBC0,0xAB96,0x0000, 0xFBC0,0xAB97,0x0000, 0xFBC0,0xAB98,0x0000,
0xFBC0,0xAB99,0x0000, 0xFBC0,0xAB9A,0x0000, 0xFBC0,0xAB9B,0x0000,
0xFBC0,0xAB9C,0x0000, 0xFBC0,0xAB9D,0x0000, 0xFBC0,0xAB9E,0x0000,
0xFBC0,0xAB9F,0x0000, 0xFBC0,0xABA0,0x0000, 0xFBC0,0xABA1,0x0000,
0xFBC0,0xABA2,0x0000, 0xFBC0,0xABA3,0x0000, 0xFBC0,0xABA4,0x0000,
0xFBC0,0xABA5,0x0000, 0xFBC0,0xABA6,0x0000, 0xFBC0,0xABA7,0x0000,
0xFBC0,0xABA8,0x0000, 0xFBC0,0xABA9,0x0000, 0xFBC0,0xABAA,0x0000,
0xFBC0,0xABAB,0x0000, 0xFBC0,0xABAC,0x0000, 0xFBC0,0xABAD,0x0000,
0xFBC0,0xABAE,0x0000, 0xFBC0,0xABAF,0x0000, 0xFBC0,0xABB0,0x0000,
0xFBC0,0xABB1,0x0000, 0xFBC0,0xABB2,0x0000, 0xFBC0,0xABB3,0x0000,
0xFBC0,0xABB4,0x0000, 0xFBC0,0xABB5,0x0000, 0xFBC0,0xABB6,0x0000,
0xFBC0,0xABB7,0x0000, 0xFBC0,0xABB8,0x0000, 0xFBC0,0xABB9,0x0000,
0xFBC0,0xABBA,0x0000, 0xFBC0,0xABBB,0x0000, 0xFBC0,0xABBC,0x0000,
0xFBC0,0xABBD,0x0000, 0xFBC0,0xABBE,0x0000, 0xFBC0,0xABBF,0x0000,
0xFBC0,0xABC0,0x0000, 0xFBC0,0xABC1,0x0000, 0xFBC0,0xABC2,0x0000,
0xFBC0,0xABC3,0x0000, 0xFBC0,0xABC4,0x0000, 0xFBC0,0xABC5,0x0000,
0xFBC0,0xABC6,0x0000, 0xFBC0,0xABC7,0x0000, 0xFBC0,0xABC8,0x0000,
0xFBC0,0xABC9,0x0000, 0xFBC0,0xABCA,0x0000, 0xFBC0,0xABCB,0x0000,
0xFBC0,0xABCC,0x0000, 0xFBC0,0xABCD,0x0000, 0xFBC0,0xABCE,0x0000,
0xFBC0,0xABCF,0x0000, 0xFBC0,0xABD0,0x0000, 0xFBC0,0xABD1,0x0000,
0xFBC0,0xABD2,0x0000, 0xFBC0,0xABD3,0x0000, 0xFBC0,0xABD4,0x0000,
0xFBC0,0xABD5,0x0000, 0xFBC0,0xABD6,0x0000, 0xFBC0,0xABD7,0x0000,
0xFBC0,0xABD8,0x0000, 0xFBC0,0xABD9,0x0000, 0xFBC0,0xABDA,0x0000,
0xFBC0,0xABDB,0x0000, 0xFBC0,0xABDC,0x0000, 0xFBC0,0xABDD,0x0000,
0xFBC0,0xABDE,0x0000, 0xFBC0,0xABDF,0x0000, 0xFBC0,0xABE0,0x0000,
0xFBC0,0xABE1,0x0000, 0xFBC0,0xABE2,0x0000, 0xFBC0,0xABE3,0x0000,
0xFBC0,0xABE4,0x0000, 0xFBC0,0xABE5,0x0000, 0xFBC0,0xABE6,0x0000,
0xFBC0,0xABE7,0x0000, 0xFBC0,0xABE8,0x0000, 0xFBC0,0xABE9,0x0000,
0xFBC0,0xABEA,0x0000, 0xFBC0,0xABEB,0x0000, 0xFBC0,0xABEC,0x0000,
0xFBC0,0xABED,0x0000, 0xFBC0,0xABEE,0x0000, 0xFBC0,0xABEF,0x0000,
0xFBC0,0xABF0,0x0000, 0xFBC0,0xABF1,0x0000, 0xFBC0,0xABF2,0x0000,
0xFBC0,0xABF3,0x0000, 0xFBC0,0xABF4,0x0000, 0xFBC0,0xABF5,0x0000,
0xFBC0,0xABF6,0x0000, 0xFBC0,0xABF7,0x0000, 0xFBC0,0xABF8,0x0000,
0xFBC0,0xABF9,0x0000, 0xFBC0,0xABFA,0x0000, 0xFBC0,0xABFB,0x0000,
0xFBC0,0xABFC,0x0000, 0xFBC0,0xABFD,0x0000, 0xFBC0,0xABFE,0x0000,
0xFBC0,0xABFF,0x0000 };

uint16 page02Edata[]= { /* 2E00 (3 weights per char) */
0xFBC0,0xAE00,0x0000, 0xFBC0,0xAE01,0x0000, 0xFBC0,0xAE02,0x0000,
0xFBC0,0xAE03,0x0000, 0xFBC0,0xAE04,0x0000, 0xFBC0,0xAE05,0x0000,
0xFBC0,0xAE06,0x0000, 0xFBC0,0xAE07,0x0000, 0xFBC0,0xAE08,0x0000,
0xFBC0,0xAE09,0x0000, 0xFBC0,0xAE0A,0x0000, 0xFBC0,0xAE0B,0x0000,
0xFBC0,0xAE0C,0x0000, 0xFBC0,0xAE0D,0x0000, 0xFBC0,0xAE0E,0x0000,
0xFBC0,0xAE0F,0x0000, 0xFBC0,0xAE10,0x0000, 0xFBC0,0xAE11,0x0000,
0xFBC0,0xAE12,0x0000, 0xFBC0,0xAE13,0x0000, 0xFBC0,0xAE14,0x0000,
0xFBC0,0xAE15,0x0000, 0xFBC0,0xAE16,0x0000, 0xFBC0,0xAE17,0x0000,
0xFBC0,0xAE18,0x0000, 0xFBC0,0xAE19,0x0000, 0xFBC0,0xAE1A,0x0000,
0xFBC0,0xAE1B,0x0000, 0xFBC0,0xAE1C,0x0000, 0xFBC0,0xAE1D,0x0000,
0xFBC0,0xAE1E,0x0000, 0xFBC0,0xAE1F,0x0000, 0xFBC0,0xAE20,0x0000,
0xFBC0,0xAE21,0x0000, 0xFBC0,0xAE22,0x0000, 0xFBC0,0xAE23,0x0000,
0xFBC0,0xAE24,0x0000, 0xFBC0,0xAE25,0x0000, 0xFBC0,0xAE26,0x0000,
0xFBC0,0xAE27,0x0000, 0xFBC0,0xAE28,0x0000, 0xFBC0,0xAE29,0x0000,
0xFBC0,0xAE2A,0x0000, 0xFBC0,0xAE2B,0x0000, 0xFBC0,0xAE2C,0x0000,
0xFBC0,0xAE2D,0x0000, 0xFBC0,0xAE2E,0x0000, 0xFBC0,0xAE2F,0x0000,
0xFBC0,0xAE30,0x0000, 0xFBC0,0xAE31,0x0000, 0xFBC0,0xAE32,0x0000,
0xFBC0,0xAE33,0x0000, 0xFBC0,0xAE34,0x0000, 0xFBC0,0xAE35,0x0000,
0xFBC0,0xAE36,0x0000, 0xFBC0,0xAE37,0x0000, 0xFBC0,0xAE38,0x0000,
0xFBC0,0xAE39,0x0000, 0xFBC0,0xAE3A,0x0000, 0xFBC0,0xAE3B,0x0000,
0xFBC0,0xAE3C,0x0000, 0xFBC0,0xAE3D,0x0000, 0xFBC0,0xAE3E,0x0000,
0xFBC0,0xAE3F,0x0000, 0xFBC0,0xAE40,0x0000, 0xFBC0,0xAE41,0x0000,
0xFBC0,0xAE42,0x0000, 0xFBC0,0xAE43,0x0000, 0xFBC0,0xAE44,0x0000,
0xFBC0,0xAE45,0x0000, 0xFBC0,0xAE46,0x0000, 0xFBC0,0xAE47,0x0000,
0xFBC0,0xAE48,0x0000, 0xFBC0,0xAE49,0x0000, 0xFBC0,0xAE4A,0x0000,
0xFBC0,0xAE4B,0x0000, 0xFBC0,0xAE4C,0x0000, 0xFBC0,0xAE4D,0x0000,
0xFBC0,0xAE4E,0x0000, 0xFBC0,0xAE4F,0x0000, 0xFBC0,0xAE50,0x0000,
0xFBC0,0xAE51,0x0000, 0xFBC0,0xAE52,0x0000, 0xFBC0,0xAE53,0x0000,
0xFBC0,0xAE54,0x0000, 0xFBC0,0xAE55,0x0000, 0xFBC0,0xAE56,0x0000,
0xFBC0,0xAE57,0x0000, 0xFBC0,0xAE58,0x0000, 0xFBC0,0xAE59,0x0000,
0xFBC0,0xAE5A,0x0000, 0xFBC0,0xAE5B,0x0000, 0xFBC0,0xAE5C,0x0000,
0xFBC0,0xAE5D,0x0000, 0xFBC0,0xAE5E,0x0000, 0xFBC0,0xAE5F,0x0000,
0xFBC0,0xAE60,0x0000, 0xFBC0,0xAE61,0x0000, 0xFBC0,0xAE62,0x0000,
0xFBC0,0xAE63,0x0000, 0xFBC0,0xAE64,0x0000, 0xFBC0,0xAE65,0x0000,
0xFBC0,0xAE66,0x0000, 0xFBC0,0xAE67,0x0000, 0xFBC0,0xAE68,0x0000,
0xFBC0,0xAE69,0x0000, 0xFBC0,0xAE6A,0x0000, 0xFBC0,0xAE6B,0x0000,
0xFBC0,0xAE6C,0x0000, 0xFBC0,0xAE6D,0x0000, 0xFBC0,0xAE6E,0x0000,
0xFBC0,0xAE6F,0x0000, 0xFBC0,0xAE70,0x0000, 0xFBC0,0xAE71,0x0000,
0xFBC0,0xAE72,0x0000, 0xFBC0,0xAE73,0x0000, 0xFBC0,0xAE74,0x0000,
0xFBC0,0xAE75,0x0000, 0xFBC0,0xAE76,0x0000, 0xFBC0,0xAE77,0x0000,
0xFBC0,0xAE78,0x0000, 0xFBC0,0xAE79,0x0000, 0xFBC0,0xAE7A,0x0000,
0xFBC0,0xAE7B,0x0000, 0xFBC0,0xAE7C,0x0000, 0xFBC0,0xAE7D,0x0000,
0xFBC0,0xAE7E,0x0000, 0xFBC0,0xAE7F,0x0000, 0xFB40,0xCE36,0x0000,
0xFB40,0xD382,0x0000, 0xFB40,0xCE5B,0x0000, 0xFB40,0xCE5A,0x0000,
0xFB40,0xCE59,0x0000, 0xFB40,0xCEBB,0x0000, 0xFB40,0xD182,0x0000,
0xFB40,0xD1E0,0x0000, 0xFB40,0xD200,0x0000, 0xFB40,0xD202,0x0000,
0xFB40,0xD35C,0x0000, 0xFB40,0xD369,0x0000, 0xFB40,0xDC0F,0x0000,
0xFB40,0xDC0F,0x0000, 0xFB40,0xDC22,0x0000, 0xFB40,0xDC23,0x0000,
0xFB40,0xDC22,0x0000, 0xFB40,0xDC23,0x0000, 0xFB40,0xDDF3,0x0000,
0xFB40,0xDE7A,0x0000, 0xFB40,0xDF51,0x0000, 0xFB40,0xDF50,0x0000,
0xFB40,0xDFC4,0x0000, 0xFB40,0xDFC3,0x0000, 0xFB40,0xE24C,0x0000,
0xFB40,0xE535,0x0000, 0xFBC0,0xAE9A,0x0000, 0xFB40,0xE5E1,0x0000,
0xFB40,0xE5E5,0x0000, 0xFB40,0xE708,0x0000, 0xFB40,0xEB7A,0x0000,
0xFB40,0xEBCD,0x0000, 0xFB40,0xEC11,0x0000, 0xFB40,0xEC35,0x0000,
0xFB40,0xEC3A,0x0000, 0xFB40,0xF06C,0x0000, 0xFB40,0xF22B,0x0000,
0xFB40,0xF22B,0x0000, 0xFB40,0xCE2C,0x0000, 0xFB40,0xF25B,0x0000,
0xFB40,0xF2AD,0x0000, 0xFB40,0xF38B,0x0000, 0xFB40,0xF58B,0x0000,
0xFB40,0xF6EE,0x0000, 0xFB40,0xF93A,0x0000, 0xFB40,0xF93B,0x0000,
0xFB40,0xFAF9,0x0000, 0xFB40,0xFCF9,0x0000, 0xFB40,0xFE9F,0x0000,
0xFB40,0xFF53,0x0000, 0xFB40,0xFF52,0x0000, 0xFB40,0xFF53,0x0000,
0xFB40,0xFF53,0x0000, 0xFB40,0xFF52,0x0000, 0xFB40,0xFF8A,0x0000,
0xFB40,0xFF8A,0x0000, 0xFB40,0xFF8B,0x0000, 0xFB41,0x8002,0x0000,
0xFB41,0x8080,0x0000, 0xFB41,0x807F,0x0000, 0xFB41,0x8089,0x0000,
0xFB41,0x81FC,0x0000, 0xFB41,0x8279,0x0000, 0xFB41,0x8279,0x0000,
0xFB41,0x8279,0x0000, 0xFB41,0x864E,0x0000, 0xFB41,0x8864,0x0000,
0xFB41,0x8980,0x0000, 0xFB41,0x897F,0x0000, 0xFB41,0x89C1,0x0000,
0xFB41,0x89D2,0x0000, 0xFB41,0x89D2,0x0000, 0xFB41,0x8BA0,0x0000,
0xFB41,0x8D1D,0x0000, 0xFB41,0x8DB3,0x0000, 0xFB41,0x8F66,0x0000,
0xFB41,0x8FB6,0x0000, 0xFB41,0x8FB6,0x0000, 0xFB41,0x8FB6,0x0000,
0xFB41,0x9091,0x0000, 0xFB41,0x9485,0x0000, 0xFB41,0x9577,0x0000,
0xFB41,0x9578,0x0000, 0xFB41,0x957F,0x0000, 0xFB41,0x95E8,0x0000,
0xFB41,0x961C,0x0000, 0xFB41,0x961D,0x0000, 0xFB41,0x96E8,0x0000,
0xFB41,0x9752,0x0000, 0xFB41,0x97E6,0x0000, 0xFB41,0x9875,0x0000,
0xFB41,0x98CE,0x0000, 0xFB41,0x98DE,0x0000, 0xFB41,0x98DF,0x0000,
0xFB41,0x98E0,0x0000, 0xFB41,0x98E0,0x0000, 0xFB41,0x9963,0x0000,
0xFB41,0x9996,0x0000, 0xFB41,0x9A6C,0x0000, 0xFB41,0x9AA8,0x0000,
0xFB41,0x9B3C,0x0000, 0xFB41,0x9C7C,0x0000, 0xFB41,0x9E1F,0x0000,
0xFB41,0x9E75,0x0000, 0xFB41,0x9EA6,0x0000, 0xFB41,0x9EC4,0x0000,
0xFB41,0x9EFE,0x0000, 0xFB41,0x9F4A,0x0000, 0xFB41,0x9F50,0x0000,
0xFB41,0x9F52,0x0000, 0xFB41,0x9F7F,0x0000, 0xFB41,0x9F8D,0x0000,
0xFB41,0x9F99,0x0000, 0xFB41,0x9F9C,0x0000, 0xFB41,0x9F9C,0x0000,
0xFB41,0x9F9F,0x0000, 0xFBC0,0xAEF4,0x0000, 0xFBC0,0xAEF5,0x0000,
0xFBC0,0xAEF6,0x0000, 0xFBC0,0xAEF7,0x0000, 0xFBC0,0xAEF8,0x0000,
0xFBC0,0xAEF9,0x0000, 0xFBC0,0xAEFA,0x0000, 0xFBC0,0xAEFB,0x0000,
0xFBC0,0xAEFC,0x0000, 0xFBC0,0xAEFD,0x0000, 0xFBC0,0xAEFE,0x0000,
0xFBC0,0xAEFF,0x0000 };

uint16 page02Fdata[]= { /* 2F00 (3 weights per char) */
0xFB40,0xCE00,0x0000, 0xFB40,0xCE28,0x0000, 0xFB40,0xCE36,0x0000,
0xFB40,0xCE3F,0x0000, 0xFB40,0xCE59,0x0000, 0xFB40,0xCE85,0x0000,
0xFB40,0xCE8C,0x0000, 0xFB40,0xCEA0,0x0000, 0xFB40,0xCEBA,0x0000,
0xFB40,0xD13F,0x0000, 0xFB40,0xD165,0x0000, 0xFB40,0xD16B,0x0000,
0xFB40,0xD182,0x0000, 0xFB40,0xD196,0x0000, 0xFB40,0xD1AB,0x0000,
0xFB40,0xD1E0,0x0000, 0xFB40,0xD1F5,0x0000, 0xFB40,0xD200,0x0000,
0xFB40,0xD29B,0x0000, 0xFB40,0xD2F9,0x0000, 0xFB40,0xD315,0x0000,
0xFB40,0xD31A,0x0000, 0xFB40,0xD338,0x0000, 0xFB40,0xD341,0x0000,
0xFB40,0xD35C,0x0000, 0xFB40,0xD369,0x0000, 0xFB40,0xD382,0x0000,
0xFB40,0xD3B6,0x0000, 0xFB40,0xD3C8,0x0000, 0xFB40,0xD3E3,0x0000,
0xFB40,0xD6D7,0x0000, 0xFB40,0xD71F,0x0000, 0xFB40,0xD8EB,0x0000,
0xFB40,0xD902,0x0000, 0xFB40,0xD90A,0x0000, 0xFB40,0xD915,0x0000,
0xFB40,0xD927,0x0000, 0xFB40,0xD973,0x0000, 0xFB40,0xDB50,0x0000,
0xFB40,0xDB80,0x0000, 0xFB40,0xDBF8,0x0000, 0xFB40,0xDC0F,0x0000,
0xFB40,0xDC22,0x0000, 0xFB40,0xDC38,0x0000, 0xFB40,0xDC6E,0x0000,
0xFB40,0xDC71,0x0000, 0xFB40,0xDDDB,0x0000, 0xFB40,0xDDE5,0x0000,
0xFB40,0xDDF1,0x0000, 0xFB40,0xDDFE,0x0000, 0xFB40,0xDE72,0x0000,
0xFB40,0xDE7A,0x0000, 0xFB40,0xDE7F,0x0000, 0xFB40,0xDEF4,0x0000,
0xFB40,0xDEFE,0x0000, 0xFB40,0xDF0B,0x0000, 0xFB40,0xDF13,0x0000,
0xFB40,0xDF50,0x0000, 0xFB40,0xDF61,0x0000, 0xFB40,0xDF73,0x0000,
0xFB40,0xDFC3,0x0000, 0xFB40,0xE208,0x0000, 0xFB40,0xE236,0x0000,
0xFB40,0xE24B,0x0000, 0xFB40,0xE52F,0x0000, 0xFB40,0xE534,0x0000,
0xFB40,0xE587,0x0000, 0xFB40,0xE597,0x0000, 0xFB40,0xE5A4,0x0000,
0xFB40,0xE5B9,0x0000, 0xFB40,0xE5E0,0x0000, 0xFB40,0xE5E5,0x0000,
0xFB40,0xE6F0,0x0000, 0xFB40,0xE708,0x0000, 0xFB40,0xE728,0x0000,
0xFB40,0xEB20,0x0000, 0xFB40,0xEB62,0x0000, 0xFB40,0xEB79,0x0000,
0xFB40,0xEBB3,0x0000, 0xFB40,0xEBCB,0x0000, 0xFB40,0xEBD4,0x0000,
0xFB40,0xEBDB,0x0000, 0xFB40,0xEC0F,0x0000, 0xFB40,0xEC14,0x0000,
0xFB40,0xEC34,0x0000, 0xFB40,0xF06B,0x0000, 0xFB40,0xF22A,0x0000,
0xFB40,0xF236,0x0000, 0xFB40,0xF23B,0x0000, 0xFB40,0xF23F,0x0000,
0xFB40,0xF247,0x0000, 0xFB40,0xF259,0x0000, 0xFB40,0xF25B,0x0000,
0xFB40,0xF2AC,0x0000, 0xFB40,0xF384,0x0000, 0xFB40,0xF389,0x0000,
0xFB40,0xF4DC,0x0000, 0xFB40,0xF4E6,0x0000, 0xFB40,0xF518,0x0000,
0xFB40,0xF51F,0x0000, 0xFB40,0xF528,0x0000, 0xFB40,0xF530,0x0000,
0xFB40,0xF58B,0x0000, 0xFB40,0xF592,0x0000, 0xFB40,0xF676,0x0000,
0xFB40,0xF67D,0x0000, 0xFB40,0xF6AE,0x0000, 0xFB40,0xF6BF,0x0000,
0xFB40,0xF6EE,0x0000, 0xFB40,0xF7DB,0x0000, 0xFB40,0xF7E2,0x0000,
0xFB40,0xF7F3,0x0000, 0xFB40,0xF93A,0x0000, 0xFB40,0xF9B8,0x0000,
0xFB40,0xF9BE,0x0000, 0xFB40,0xFA74,0x0000, 0xFB40,0xFACB,0x0000,
0xFB40,0xFAF9,0x0000, 0xFB40,0xFC73,0x0000, 0xFB40,0xFCF8,0x0000,
0xFB40,0xFF36,0x0000, 0xFB40,0xFF51,0x0000, 0xFB40,0xFF8A,0x0000,
0xFB40,0xFFBD,0x0000, 0xFB41,0x8001,0x0000, 0xFB41,0x800C,0x0000,
0xFB41,0x8012,0x0000, 0xFB41,0x8033,0x0000, 0xFB41,0x807F,0x0000,
0xFB41,0x8089,0x0000, 0xFB41,0x81E3,0x0000, 0xFB41,0x81EA,0x0000,
0xFB41,0x81F3,0x0000, 0xFB41,0x81FC,0x0000, 0xFB41,0x820C,0x0000,
0xFB41,0x821B,0x0000, 0xFB41,0x821F,0x0000, 0xFB41,0x826E,0x0000,
0xFB41,0x8272,0x0000, 0xFB41,0x8278,0x0000, 0xFB41,0x864D,0x0000,
0xFB41,0x866B,0x0000, 0xFB41,0x8840,0x0000, 0xFB41,0x884C,0x0000,
0xFB41,0x8863,0x0000, 0xFB41,0x897E,0x0000, 0xFB41,0x898B,0x0000,
0xFB41,0x89D2,0x0000, 0xFB41,0x8A00,0x0000, 0xFB41,0x8C37,0x0000,
0xFB41,0x8C46,0x0000, 0xFB41,0x8C55,0x0000, 0xFB41,0x8C78,0x0000,
0xFB41,0x8C9D,0x0000, 0xFB41,0x8D64,0x0000, 0xFB41,0x8D70,0x0000,
0xFB41,0x8DB3,0x0000, 0xFB41,0x8EAB,0x0000, 0xFB41,0x8ECA,0x0000,
0xFB41,0x8F9B,0x0000, 0xFB41,0x8FB0,0x0000, 0xFB41,0x8FB5,0x0000,
0xFB41,0x9091,0x0000, 0xFB41,0x9149,0x0000, 0xFB41,0x91C6,0x0000,
0xFB41,0x91CC,0x0000, 0xFB41,0x91D1,0x0000, 0xFB41,0x9577,0x0000,
0xFB41,0x9580,0x0000, 0xFB41,0x961C,0x0000, 0xFB41,0x96B6,0x0000,
0xFB41,0x96B9,0x0000, 0xFB41,0x96E8,0x0000, 0xFB41,0x9751,0x0000,
0xFB41,0x975E,0x0000, 0xFB41,0x9762,0x0000, 0xFB41,0x9769,0x0000,
0xFB41,0x97CB,0x0000, 0xFB41,0x97ED,0x0000, 0xFB41,0x97F3,0x0000,
0xFB41,0x9801,0x0000, 0xFB41,0x98A8,0x0000, 0xFB41,0x98DB,0x0000,
0xFB41,0x98DF,0x0000, 0xFB41,0x9996,0x0000, 0xFB41,0x9999,0x0000,
0xFB41,0x99AC,0x0000, 0xFB41,0x9AA8,0x0000, 0xFB41,0x9AD8,0x0000,
0xFB41,0x9ADF,0x0000, 0xFB41,0x9B25,0x0000, 0xFB41,0x9B2F,0x0000,
0xFB41,0x9B32,0x0000, 0xFB41,0x9B3C,0x0000, 0xFB41,0x9B5A,0x0000,
0xFB41,0x9CE5,0x0000, 0xFB41,0x9E75,0x0000, 0xFB41,0x9E7F,0x0000,
0xFB41,0x9EA5,0x0000, 0xFB41,0x9EBB,0x0000, 0xFB41,0x9EC3,0x0000,
0xFB41,0x9ECD,0x0000, 0xFB41,0x9ED1,0x0000, 0xFB41,0x9EF9,0x0000,
0xFB41,0x9EFD,0x0000, 0xFB41,0x9F0E,0x0000, 0xFB41,0x9F13,0x0000,
0xFB41,0x9F20,0x0000, 0xFB41,0x9F3B,0x0000, 0xFB41,0x9F4A,0x0000,
0xFB41,0x9F52,0x0000, 0xFB41,0x9F8D,0x0000, 0xFB41,0x9F9C,0x0000,
0xFB41,0x9FA0,0x0000, 0xFBC0,0xAFD6,0x0000, 0xFBC0,0xAFD7,0x0000,
0xFBC0,0xAFD8,0x0000, 0xFBC0,0xAFD9,0x0000, 0xFBC0,0xAFDA,0x0000,
0xFBC0,0xAFDB,0x0000, 0xFBC0,0xAFDC,0x0000, 0xFBC0,0xAFDD,0x0000,
0xFBC0,0xAFDE,0x0000, 0xFBC0,0xAFDF,0x0000, 0xFBC0,0xAFE0,0x0000,
0xFBC0,0xAFE1,0x0000, 0xFBC0,0xAFE2,0x0000, 0xFBC0,0xAFE3,0x0000,
0xFBC0,0xAFE4,0x0000, 0xFBC0,0xAFE5,0x0000, 0xFBC0,0xAFE6,0x0000,
0xFBC0,0xAFE7,0x0000, 0xFBC0,0xAFE8,0x0000, 0xFBC0,0xAFE9,0x0000,
0xFBC0,0xAFEA,0x0000, 0xFBC0,0xAFEB,0x0000, 0xFBC0,0xAFEC,0x0000,
0xFBC0,0xAFED,0x0000, 0xFBC0,0xAFEE,0x0000, 0xFBC0,0xAFEF,0x0000,
0x0DAF,0x0000,0x0000, 0x0DB0,0x0000,0x0000, 0x0DB1,0x0000,0x0000,
0x0DB2,0x0000,0x0000, 0x0DB3,0x0000,0x0000, 0x0DB4,0x0000,0x0000,
0x0DB5,0x0000,0x0000, 0x0DB6,0x0000,0x0000, 0x0DB7,0x0000,0x0000,
0x0DB8,0x0000,0x0000, 0x0DB9,0x0000,0x0000, 0x0DBA,0x0000,0x0000,
0xFBC0,0xAFFC,0x0000, 0xFBC0,0xAFFD,0x0000, 0xFBC0,0xAFFE,0x0000,
0xFBC0,0xAFFF,0x0000 };

uint16 page030data[]= { /* 3000 (3 weights per char) */
0x0209,0x0000,0x0000, 0x0237,0x0000,0x0000, 0x0266,0x0000,0x0000,
0x02E2,0x0000,0x0000, 0x0DBB,0x0000,0x0000, 0x0E05,0x0000,0x0000,
0x1E5D,0x1E73,0x0000, 0x0E29,0x0000,0x0000, 0x02AE,0x0000,0x0000,
0x02AF,0x0000,0x0000, 0x02B0,0x0000,0x0000, 0x02B1,0x0000,0x0000,
0x02B2,0x0000,0x0000, 0x02B3,0x0000,0x0000, 0x02B4,0x0000,0x0000,
0x02B5,0x0000,0x0000, 0x02B6,0x0000,0x0000, 0x02B7,0x0000,0x0000,
0x0DBC,0x0000,0x0000, 0x0DBD,0x0000,0x0000, 0x02B8,0x0000,0x0000,
0x02B9,0x0000,0x0000, 0x02BA,0x0000,0x0000, 0x02BB,0x0000,0x0000,
0x02BC,0x0000,0x0000, 0x02BD,0x0000,0x0000, 0x02BE,0x0000,0x0000,
0x02BF,0x0000,0x0000, 0x022B,0x0000,0x0000, 0x0283,0x0000,0x0000,
0x0284,0x0000,0x0000, 0x0285,0x0000,0x0000, 0x0DBE,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x022C,0x0000,0x0000, 0x0E07,0x0000,0x0000, 0x0E07,0x0000,0x0000,
0x0E08,0x0000,0x0000, 0x0E08,0x0000,0x0000, 0x0E09,0x0000,0x0000,
0x0DBC,0x0000,0x0000, 0x0DBF,0x0000,0x0000, 0xFB40,0xD341,0x0000,
0xFB40,0xD344,0x0000, 0xFB40,0xD345,0x0000, 0x0E06,0x0000,0x0000,
0x1E70,0x1E5E,0x0000, 0x02E3,0x0000,0x0000, 0x0DC0,0x0000,0x0000,
0x0DC1,0x0000,0x0000, 0xFBC0,0xB040,0x0000, 0x1E52,0x0000,0x0000,
0x1E52,0x0000,0x0000, 0x1E53,0x0000,0x0000, 0x1E53,0x0000,0x0000,
0x1E54,0x0000,0x0000, 0x1E54,0x0000,0x0000, 0x1E55,0x0000,0x0000,
0x1E55,0x0000,0x0000, 0x1E56,0x0000,0x0000, 0x1E56,0x0000,0x0000,
0x1E57,0x0000,0x0000, 0x1E57,0x0000,0x0000, 0x1E58,0x0000,0x0000,
0x1E58,0x0000,0x0000, 0x1E59,0x0000,0x0000, 0x1E59,0x0000,0x0000,
0x1E5A,0x0000,0x0000, 0x1E5A,0x0000,0x0000, 0x1E5B,0x0000,0x0000,
0x1E5B,0x0000,0x0000, 0x1E5C,0x0000,0x0000, 0x1E5C,0x0000,0x0000,
0x1E5D,0x0000,0x0000, 0x1E5D,0x0000,0x0000, 0x1E5E,0x0000,0x0000,
0x1E5E,0x0000,0x0000, 0x1E5F,0x0000,0x0000, 0x1E5F,0x0000,0x0000,
0x1E60,0x0000,0x0000, 0x1E60,0x0000,0x0000, 0x1E61,0x0000,0x0000,
0x1E61,0x0000,0x0000, 0x1E62,0x0000,0x0000, 0x1E62,0x0000,0x0000,
0x1E63,0x0000,0x0000, 0x1E63,0x0000,0x0000, 0x1E63,0x0000,0x0000,
0x1E64,0x0000,0x0000, 0x1E64,0x0000,0x0000, 0x1E65,0x0000,0x0000,
0x1E65,0x0000,0x0000, 0x1E66,0x0000,0x0000, 0x1E67,0x0000,0x0000,
0x1E68,0x0000,0x0000, 0x1E69,0x0000,0x0000, 0x1E6A,0x0000,0x0000,
0x1E6B,0x0000,0x0000, 0x1E6B,0x0000,0x0000, 0x1E6B,0x0000,0x0000,
0x1E6C,0x0000,0x0000, 0x1E6C,0x0000,0x0000, 0x1E6C,0x0000,0x0000,
0x1E6D,0x0000,0x0000, 0x1E6D,0x0000,0x0000, 0x1E6D,0x0000,0x0000,
0x1E6E,0x0000,0x0000, 0x1E6E,0x0000,0x0000, 0x1E6E,0x0000,0x0000,
0x1E6F,0x0000,0x0000, 0x1E6F,0x0000,0x0000, 0x1E6F,0x0000,0x0000,
0x1E70,0x0000,0x0000, 0x1E71,0x0000,0x0000, 0x1E72,0x0000,0x0000,
0x1E73,0x0000,0x0000, 0x1E74,0x0000,0x0000, 0x1E75,0x0000,0x0000,
0x1E75,0x0000,0x0000, 0x1E76,0x0000,0x0000, 0x1E76,0x0000,0x0000,
0x1E77,0x0000,0x0000, 0x1E77,0x0000,0x0000, 0x1E78,0x0000,0x0000,
0x1E79,0x0000,0x0000, 0x1E7A,0x0000,0x0000, 0x1E7B,0x0000,0x0000,
0x1E7C,0x0000,0x0000, 0x1E7D,0x0000,0x0000, 0x1E7D,0x0000,0x0000,
0x1E7E,0x0000,0x0000, 0x1E7F,0x0000,0x0000, 0x1E80,0x0000,0x0000,
0x1E81,0x0000,0x0000, 0x1E54,0x0000,0x0000, 0x1E57,0x0000,0x0000,
0x1E5A,0x0000,0x0000, 0xFBC0,0xB097,0x0000, 0xFBC0,0xB098,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x021E,0x0000,0x0000,
0x021F,0x0000,0x0000, 0x0E0A,0x0000,0x0000, 0x0E0A,0x0000,0x0000,
0x1E77,0x1E79,0x0000, 0x022D,0x0000,0x0000, 0x1E52,0x0000,0x0000,
0x1E52,0x0000,0x0000, 0x1E53,0x0000,0x0000, 0x1E53,0x0000,0x0000,
0x1E54,0x0000,0x0000, 0x1E54,0x0000,0x0000, 0x1E55,0x0000,0x0000,
0x1E55,0x0000,0x0000, 0x1E56,0x0000,0x0000, 0x1E56,0x0000,0x0000,
0x1E57,0x0000,0x0000, 0x1E57,0x0000,0x0000, 0x1E58,0x0000,0x0000,
0x1E58,0x0000,0x0000, 0x1E59,0x0000,0x0000, 0x1E59,0x0000,0x0000,
0x1E5A,0x0000,0x0000, 0x1E5A,0x0000,0x0000, 0x1E5B,0x0000,0x0000,
0x1E5B,0x0000,0x0000, 0x1E5C,0x0000,0x0000, 0x1E5C,0x0000,0x0000,
0x1E5D,0x0000,0x0000, 0x1E5D,0x0000,0x0000, 0x1E5E,0x0000,0x0000,
0x1E5E,0x0000,0x0000, 0x1E5F,0x0000,0x0000, 0x1E5F,0x0000,0x0000,
0x1E60,0x0000,0x0000, 0x1E60,0x0000,0x0000, 0x1E61,0x0000,0x0000,
0x1E61,0x0000,0x0000, 0x1E62,0x0000,0x0000, 0x1E62,0x0000,0x0000,
0x1E63,0x0000,0x0000, 0x1E63,0x0000,0x0000, 0x1E63,0x0000,0x0000,
0x1E64,0x0000,0x0000, 0x1E64,0x0000,0x0000, 0x1E65,0x0000,0x0000,
0x1E65,0x0000,0x0000, 0x1E66,0x0000,0x0000, 0x1E67,0x0000,0x0000,
0x1E68,0x0000,0x0000, 0x1E69,0x0000,0x0000, 0x1E6A,0x0000,0x0000,
0x1E6B,0x0000,0x0000, 0x1E6B,0x0000,0x0000, 0x1E6B,0x0000,0x0000,
0x1E6C,0x0000,0x0000, 0x1E6C,0x0000,0x0000, 0x1E6C,0x0000,0x0000,
0x1E6D,0x0000,0x0000, 0x1E6D,0x0000,0x0000, 0x1E6D,0x0000,0x0000,
0x1E6E,0x0000,0x0000, 0x1E6E,0x0000,0x0000, 0x1E6E,0x0000,0x0000,
0x1E6F,0x0000,0x0000, 0x1E6F,0x0000,0x0000, 0x1E6F,0x0000,0x0000,
0x1E70,0x0000,0x0000, 0x1E71,0x0000,0x0000, 0x1E72,0x0000,0x0000,
0x1E73,0x0000,0x0000, 0x1E74,0x0000,0x0000, 0x1E75,0x0000,0x0000,
0x1E75,0x0000,0x0000, 0x1E76,0x0000,0x0000, 0x1E76,0x0000,0x0000,
0x1E77,0x0000,0x0000, 0x1E77,0x0000,0x0000, 0x1E78,0x0000,0x0000,
0x1E79,0x0000,0x0000, 0x1E7A,0x0000,0x0000, 0x1E7B,0x0000,0x0000,
0x1E7C,0x0000,0x0000, 0x1E7D,0x0000,0x0000, 0x1E7D,0x0000,0x0000,
0x1E7E,0x0000,0x0000, 0x1E7F,0x0000,0x0000, 0x1E80,0x0000,0x0000,
0x1E81,0x0000,0x0000, 0x1E54,0x0000,0x0000, 0x1E57,0x0000,0x0000,
0x1E5A,0x0000,0x0000, 0x1E7D,0x0000,0x0000, 0x1E7E,0x0000,0x0000,
0x1E7F,0x0000,0x0000, 0x1E80,0x0000,0x0000, 0x022E,0x0000,0x0000,
0x0E0B,0x0000,0x0000, 0x0E0C,0x0000,0x0000, 0x0E0C,0x0000,0x0000,
0x1E5B,0x1E65,0x0000 };

uint16 page031data[]= { /* 3100 (3 weights per char) */
0xFBC0,0xB100,0x0000, 0xFBC0,0xB101,0x0000, 0xFBC0,0xB102,0x0000,
0xFBC0,0xB103,0x0000, 0xFBC0,0xB104,0x0000, 0x1E82,0x0000,0x0000,
0x1E83,0x0000,0x0000, 0x1E84,0x0000,0x0000, 0x1E85,0x0000,0x0000,
0x1E87,0x0000,0x0000, 0x1E88,0x0000,0x0000, 0x1E89,0x0000,0x0000,
0x1E8A,0x0000,0x0000, 0x1E8B,0x0000,0x0000, 0x1E8C,0x0000,0x0000,
0x1E8F,0x0000,0x0000, 0x1E90,0x0000,0x0000, 0x1E91,0x0000,0x0000,
0x1E92,0x0000,0x0000, 0x1E94,0x0000,0x0000, 0x1E95,0x0000,0x0000,
0x1E96,0x0000,0x0000, 0x1E97,0x0000,0x0000, 0x1E98,0x0000,0x0000,
0x1E99,0x0000,0x0000, 0x1E9A,0x0000,0x0000, 0x1E9B,0x0000,0x0000,
0x1E9C,0x0000,0x0000, 0x1E9E,0x0000,0x0000, 0x1E9F,0x0000,0x0000,
0x1EA1,0x0000,0x0000, 0x1EA2,0x0000,0x0000, 0x1EA3,0x0000,0x0000,
0x1EA4,0x0000,0x0000, 0x1EA5,0x0000,0x0000, 0x1EA6,0x0000,0x0000,
0x1EA7,0x0000,0x0000, 0x1EA9,0x0000,0x0000, 0x1EAD,0x0000,0x0000,
0x1EAE,0x0000,0x0000, 0x1EAF,0x0000,0x0000, 0x1EB0,0x0000,0x0000,
0x1E86,0x0000,0x0000, 0x1E8D,0x0000,0x0000, 0x1E93,0x0000,0x0000,
0xFBC0,0xB12D,0x0000, 0xFBC0,0xB12E,0x0000, 0xFBC0,0xB12F,0x0000,
0xFBC0,0xB130,0x0000, 0x1D62,0x0000,0x0000, 0x1D63,0x0000,0x0000,
0x1E02,0x0000,0x0000, 0x1D64,0x0000,0x0000, 0x1E04,0x0000,0x0000,
0x1E05,0x0000,0x0000, 0x1D65,0x0000,0x0000, 0x1D66,0x0000,0x0000,
0x1D67,0x0000,0x0000, 0x1E08,0x0000,0x0000, 0x1E09,0x0000,0x0000,
0x1E0A,0x0000,0x0000, 0x1E0B,0x0000,0x0000, 0x1E0C,0x0000,0x0000,
0x1E0D,0x0000,0x0000, 0x1D7C,0x0000,0x0000, 0x1D68,0x0000,0x0000,
0x1D69,0x0000,0x0000, 0x1D6A,0x0000,0x0000, 0x1D83,0x0000,0x0000,
0x1D6B,0x0000,0x0000, 0x1D6C,0x0000,0x0000, 0x1D6D,0x0000,0x0000,
0x1D6E,0x0000,0x0000, 0x1D6F,0x0000,0x0000, 0x1D70,0x0000,0x0000,
0x1D71,0x0000,0x0000, 0x1D72,0x0000,0x0000, 0x1D73,0x0000,0x0000,
0x1D74,0x0000,0x0000, 0x1DBE,0x0000,0x0000, 0x1DBF,0x0000,0x0000,
0x1DC0,0x0000,0x0000, 0x1DC1,0x0000,0x0000, 0x1DC2,0x0000,0x0000,
0x1DC3,0x0000,0x0000, 0x1DC4,0x0000,0x0000, 0x1DC5,0x0000,0x0000,
0x1DC6,0x0000,0x0000, 0x1DC7,0x0000,0x0000, 0x1DC8,0x0000,0x0000,
0x1DC9,0x0000,0x0000, 0x1DCA,0x0000,0x0000, 0x1DCB,0x0000,0x0000,
0x1DCC,0x0000,0x0000, 0x1DCD,0x0000,0x0000, 0x1DCE,0x0000,0x0000,
0x1DCF,0x0000,0x0000, 0x1DD0,0x0000,0x0000, 0x1DD1,0x0000,0x0000,
0x1DD2,0x0000,0x0000, 0x1DBD,0x0000,0x0000, 0x1D76,0x0000,0x0000,
0x1D77,0x0000,0x0000, 0x1E1F,0x0000,0x0000, 0x1E20,0x0000,0x0000,
0x1E24,0x0000,0x0000, 0x1E26,0x0000,0x0000, 0x1E2B,0x0000,0x0000,
0x1E2F,0x0000,0x0000, 0x1E31,0x0000,0x0000, 0x1D7E,0x0000,0x0000,
0x1E35,0x0000,0x0000, 0x1E37,0x0000,0x0000, 0x1D7F,0x0000,0x0000,
0x1D80,0x0000,0x0000, 0x1D82,0x0000,0x0000, 0x1D84,0x0000,0x0000,
0x1D85,0x0000,0x0000, 0x1D89,0x0000,0x0000, 0x1D8B,0x0000,0x0000,
0x1D8D,0x0000,0x0000, 0x1D8E,0x0000,0x0000, 0x1D8F,0x0000,0x0000,
0x1D90,0x0000,0x0000, 0x1D91,0x0000,0x0000, 0x1D94,0x0000,0x0000,
0x1D98,0x0000,0x0000, 0x1DA2,0x0000,0x0000, 0x1DA9,0x0000,0x0000,
0x1DAE,0x0000,0x0000, 0x1E49,0x0000,0x0000, 0x1E4A,0x0000,0x0000,
0x1DB9,0x0000,0x0000, 0x1DBA,0x0000,0x0000, 0x1DBB,0x0000,0x0000,
0x1DE1,0x0000,0x0000, 0x1DE2,0x0000,0x0000, 0x1DE5,0x0000,0x0000,
0x1DEE,0x0000,0x0000, 0x1DEF,0x0000,0x0000, 0x1DF1,0x0000,0x0000,
0x1DFB,0x0000,0x0000, 0x1DFE,0x0000,0x0000, 0xFBC0,0xB18F,0x0000,
0x0DC2,0x0000,0x0000, 0x0DC3,0x0000,0x0000, 0xFB40,0xCE00,0x0000,
0xFB40,0xCE8C,0x0000, 0xFB40,0xCE09,0x0000, 0xFB40,0xD6DB,0x0000,
0xFB40,0xCE0A,0x0000, 0xFB40,0xCE2D,0x0000, 0xFB40,0xCE0B,0x0000,
0xFB40,0xF532,0x0000, 0xFB40,0xCE59,0x0000, 0xFB40,0xCE19,0x0000,
0xFB40,0xCE01,0x0000, 0xFB40,0xD929,0x0000, 0xFB40,0xD730,0x0000,
0xFB40,0xCEBA,0x0000, 0x1E82,0x0000,0x0000, 0x1E98,0x0000,0x0000,
0x1E90,0x0000,0x0000, 0x1E8B,0x0000,0x0000, 0x1EA0,0x0000,0x0000,
0x1EA0,0x0000,0x0000, 0x1E9D,0x0000,0x0000, 0x1E9C,0x0000,0x0000,
0x1EAF,0x0000,0x0000, 0x1E9B,0x0000,0x0000, 0x1EAE,0x0000,0x0000,
0x1EAF,0x0000,0x0000, 0x1EAC,0x0000,0x0000, 0x1E8E,0x0000,0x0000,
0x1EA1,0x0000,0x0000, 0x1EA3,0x0000,0x0000, 0x1EAA,0x0000,0x0000,
0x1EAB,0x0000,0x0000, 0x1EA8,0x0000,0x0000, 0x1EAE,0x0000,0x0000,
0x1E83,0x0000,0x0000, 0x1E88,0x0000,0x0000, 0x1E8C,0x0000,0x0000,
0x1E8F,0x0000,0x0000, 0xFBC0,0xB1B8,0x0000, 0xFBC0,0xB1B9,0x0000,
0xFBC0,0xB1BA,0x0000, 0xFBC0,0xB1BB,0x0000, 0xFBC0,0xB1BC,0x0000,
0xFBC0,0xB1BD,0x0000, 0xFBC0,0xB1BE,0x0000, 0xFBC0,0xB1BF,0x0000,
0xFBC0,0xB1C0,0x0000, 0xFBC0,0xB1C1,0x0000, 0xFBC0,0xB1C2,0x0000,
0xFBC0,0xB1C3,0x0000, 0xFBC0,0xB1C4,0x0000, 0xFBC0,0xB1C5,0x0000,
0xFBC0,0xB1C6,0x0000, 0xFBC0,0xB1C7,0x0000, 0xFBC0,0xB1C8,0x0000,
0xFBC0,0xB1C9,0x0000, 0xFBC0,0xB1CA,0x0000, 0xFBC0,0xB1CB,0x0000,
0xFBC0,0xB1CC,0x0000, 0xFBC0,0xB1CD,0x0000, 0xFBC0,0xB1CE,0x0000,
0xFBC0,0xB1CF,0x0000, 0xFBC0,0xB1D0,0x0000, 0xFBC0,0xB1D1,0x0000,
0xFBC0,0xB1D2,0x0000, 0xFBC0,0xB1D3,0x0000, 0xFBC0,0xB1D4,0x0000,
0xFBC0,0xB1D5,0x0000, 0xFBC0,0xB1D6,0x0000, 0xFBC0,0xB1D7,0x0000,
0xFBC0,0xB1D8,0x0000, 0xFBC0,0xB1D9,0x0000, 0xFBC0,0xB1DA,0x0000,
0xFBC0,0xB1DB,0x0000, 0xFBC0,0xB1DC,0x0000, 0xFBC0,0xB1DD,0x0000,
0xFBC0,0xB1DE,0x0000, 0xFBC0,0xB1DF,0x0000, 0xFBC0,0xB1E0,0x0000,
0xFBC0,0xB1E1,0x0000, 0xFBC0,0xB1E2,0x0000, 0xFBC0,0xB1E3,0x0000,
0xFBC0,0xB1E4,0x0000, 0xFBC0,0xB1E5,0x0000, 0xFBC0,0xB1E6,0x0000,
0xFBC0,0xB1E7,0x0000, 0xFBC0,0xB1E8,0x0000, 0xFBC0,0xB1E9,0x0000,
0xFBC0,0xB1EA,0x0000, 0xFBC0,0xB1EB,0x0000, 0xFBC0,0xB1EC,0x0000,
0xFBC0,0xB1ED,0x0000, 0xFBC0,0xB1EE,0x0000, 0xFBC0,0xB1EF,0x0000,
0x1E59,0x0000,0x0000, 0x1E5D,0x0000,0x0000, 0x1E5E,0x0000,0x0000,
0x1E65,0x0000,0x0000, 0x1E68,0x0000,0x0000, 0x1E6B,0x0000,0x0000,
0x1E6C,0x0000,0x0000, 0x1E6D,0x0000,0x0000, 0x1E6E,0x0000,0x0000,
0x1E6F,0x0000,0x0000, 0x1E72,0x0000,0x0000, 0x1E78,0x0000,0x0000,
0x1E79,0x0000,0x0000, 0x1E7A,0x0000,0x0000, 0x1E7B,0x0000,0x0000,
0x1E7C,0x0000,0x0000 };

uint16 page032data[]= { /* 3200 (8 weights per char) */
0x0288,0x1D62,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D64,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D65,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D67,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D68,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D69,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6B,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6D,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6E,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D70,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D71,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D72,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D73,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D74,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D62,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D64,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D65,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D67,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D68,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D69,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6B,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6D,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6E,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D70,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D71,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D72,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D73,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D74,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6E,0x1DCB,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6D,0x1DC6,0x1D6E,0x1DC2,0x1E03,0x0289,0x0000,
0x0288,0x1D6D,0x1DC6,0x1D74,0x1DCB,0x0289,0x0000,0x0000,
0xFBC0,0xB21F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCE00,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCE8C,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCE09,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD6DB,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCE94,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD16D,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCE03,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD16B,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCE5D,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD341,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xE708,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xF06B,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xEC34,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xE728,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB41,0x91D1,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD71F,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xE5E5,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xE82A,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xE709,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xF93E,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD40D,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xF279,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB41,0x8CA1,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xF95D,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD2B4,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCEE3,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD47C,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xDB66,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xF6E3,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCF01,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB41,0x8CC7,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD354,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xF96D,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCF11,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB41,0x81EA,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB41,0x81F3,0x0289,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB244,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB245,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB246,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB247,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB248,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB249,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB24A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB24B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB24C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB24D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB24E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB24F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x1002,0x0E8B,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E30,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E31,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E32,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E29,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E2A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E2D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D62,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D64,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D67,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D68,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D69,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D6B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D6D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D6E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D70,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D71,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D72,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D73,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D74,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D62,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D64,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D65,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D67,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D68,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D69,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D6B,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D6D,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D6E,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D70,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D71,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D72,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D73,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D74,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D70,0x1DBE,0x1E0F,0x1D62,0x1DC6,0x0000,0x0000,0x0000,
0x1D6E,0x1DCB,0x1D6D,0x1DD1,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB27E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0DC4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE8C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE09,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD6DB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE94,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD16D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE03,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD16B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE5D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD341,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xF06B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xEC34,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE728,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB41,0x91D1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD71F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE82A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE709,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xF93E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD40D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xF279,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB41,0x8CA1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xF95D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD2B4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xF9D8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xF537,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD973,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB41,0x9069,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD12A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD370,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xECE8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB41,0x9805,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCF11,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD199,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xEB63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE0A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE2D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE0B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xDDE6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD3F3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD33B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xDB97,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xDB66,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xF6E3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCF01,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB41,0x8CC7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD354,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD91C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E2F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E30,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E31,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E32,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E29,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E2A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E2D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E2F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E30,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E31,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E32,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0x0E29,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2F,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E30,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E31,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E32,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E29,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2A,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2B,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0EC1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E8B,0x0FC0,0x0EC1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E8B,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x1002,0x0E6D,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E52,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E53,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E54,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E55,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E56,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E57,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E59,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E60,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E61,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E62,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E64,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E66,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E67,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E68,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E69,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E70,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E71,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E72,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E73,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E74,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E75,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E76,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E77,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E78,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E79,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E80,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB2FF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

uint16 page033data[]= { /* 3300 (9 weights per char) */
0x1E52,0x1E6B,0x0E0B,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E52,0x1E7A,0x1E6D,0x1E52,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E52,0x1E81,0x1E6E,0x1E52,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E52,0x0E0B,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E53,0x1E67,0x1E81,0x1E59,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E53,0x1E81,0x1E62,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E54,0x1E56,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E55,0x1E5E,0x1E59,0x0E0B,0x1E65,0x0000,0x0000,0x0000,0x0000,
0x1E55,0x0E0B,0x1E57,0x0E0B,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E56,0x1E81,0x1E5E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E56,0x0E0B,0x1E72,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E57,0x1E53,0x1E79,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E57,0x1E78,0x1E63,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E57,0x1E7C,0x1E79,0x0E0B,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E57,0x1E7C,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E57,0x1E81,0x1E70,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x1E57,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x1E67,0x0E0B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x1E76,0x1E79,0x0E0B,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x1E7A,0x1E61,0x0E0B,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x1E7C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x1E7C,0x1E59,0x1E78,0x1E72,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x1E7C,0x1E73,0x0E0B,0x1E65,0x1E7A,0x0000,0x0000,0x0000,
0x1E58,0x1E7C,0x1E7D,0x1E63,0x1E65,0x0000,0x0000,0x0000,0x0000,
0x1E59,0x1E78,0x1E72,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E59,0x1E78,0x1E72,0x1E65,0x1E81,0x0000,0x0000,0x0000,0x0000,
0x1E59,0x1E7A,0x1E5F,0x1E53,0x1E7C,0x0000,0x0000,0x0000,0x0000,
0x1E59,0x1E7C,0x0E0B,0x1E69,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5A,0x0E0B,0x1E5E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5B,0x1E7A,0x1E66,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5B,0x0E0B,0x1E6F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5C,0x1E53,0x1E59,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5C,0x1E81,0x1E62,0x0E0B,0x1E72,0x0000,0x0000,0x0000,0x0000,
0x1E5D,0x1E79,0x1E81,0x1E59,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5F,0x1E81,0x1E62,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5F,0x1E81,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E61,0x0E0B,0x1E5E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E64,0x1E5D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E65,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E65,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E66,0x1E6A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6A,0x1E63,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6B,0x1E53,0x1E63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6B,0x0E0B,0x1E5F,0x1E81,0x1E65,0x0000,0x0000,0x0000,0x0000,
0x1E6B,0x0E0B,0x1E63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6B,0x0E0B,0x1E7B,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6C,0x1E52,0x1E5E,0x1E65,0x1E7A,0x0000,0x0000,0x0000,0x0000,
0x1E6C,0x1E59,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6C,0x1E5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6C,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6D,0x1E52,0x1E78,0x1E63,0x1E65,0x0000,0x0000,0x0000,0x0000,
0x1E6D,0x1E53,0x0E0B,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6D,0x1E63,0x1E5D,0x1E55,0x1E7A,0x0000,0x0000,0x0000,0x0000,
0x1E6D,0x1E78,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x1E59,0x1E61,0x0E0B,0x1E7A,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x1E60,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x1E67,0x1E6C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x1E7A,0x1E63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x1E81,0x1E5E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x0E0B,0x1E5D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x0E0B,0x1E61,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6F,0x1E53,0x1E81,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6F,0x1E7A,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6F,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6F,0x1E81,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6F,0x0E0B,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6F,0x0E0B,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E70,0x1E53,0x1E59,0x1E7C,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E70,0x1E53,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E70,0x1E63,0x1E6B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E70,0x1E7A,0x1E59,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E70,0x1E81,0x1E5D,0x1E77,0x1E81,0x0000,0x0000,0x0000,0x0000,
0x1E71,0x1E59,0x1E7C,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E71,0x1E79,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E71,0x1E79,0x1E6B,0x0E0B,0x1E7A,0x0000,0x0000,0x0000,0x0000,
0x1E73,0x1E57,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E73,0x1E57,0x1E65,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E73,0x0E0B,0x1E65,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E75,0x0E0B,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E75,0x0E0B,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E76,0x1E52,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E79,0x1E63,0x1E65,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E79,0x1E78,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7A,0x1E6C,0x0E0B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7A,0x0E0B,0x1E6D,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7B,0x1E72,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7B,0x1E81,0x1E65,0x1E5A,0x1E81,0x0000,0x0000,0x0000,0x0000,
0x1E7D,0x1E63,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E29,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2F,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E30,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E31,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E32,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E29,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2A,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2B,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2C,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2D,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2E,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2F,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E30,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E31,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E32,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E29,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2A,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2B,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2C,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2D,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0FA7,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E33,0x101F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E4A,0x0E33,0x0FC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F82,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0E60,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0F5B,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0F5B,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x101F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xDE73,0xFB40,0xE210,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE62D,0xFB40,0xD48C,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD927,0xFB40,0xEB63,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE60E,0xFB40,0xECBB,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE82A,0xFB40,0xDF0F,0xFB40,0xCF1A,0xFB40,0xF93E,0x0000,
0x0FA7,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0E4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0E4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EC1,0x0E4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0E33,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0E60,0x0E33,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0EB9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0EB9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x0EB9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x0EC1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0EC1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0EC1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x106A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0EE1,0x106A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0EE1,0x106A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EC1,0x0EE1,0x106A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1002,0x0EE1,0x106A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EB9,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0F5B,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0F5B,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0F5B,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0F5B,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0F5B,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0F5B,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0437,0x0FEA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0437,0x0FEA,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0FA7,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0FA7,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EC1,0x0FA7,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0E33,0x0E6D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0E33,0x0E6D,0x0437,0x0FEA,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0E33,0x0E6D,0x0437,0x0FEA,0x0E2B,0x0000,0x0000,0x0000,
0x0FA7,0x0FEA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0FEA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x0FEA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0FEA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x1051,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x1051,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x1051,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x1051,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x1051,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x1051,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x1109,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x1109,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E33,0x025D,0x0F5B,0x025D,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E4A,0x0FB4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0E60,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0E6D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0437,0x0F21,0x0EC1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0F82,0x025D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0E4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EC1,0x105E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0FA7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0F64,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0F21,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x1002,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x0F64,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x0F82,0x0EC1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x105A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0E4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0EFB,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0F82,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0EE1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x025D,0x0F5B,0x025D,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0FA7,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0FC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FEA,0x0FC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FEA,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1051,0x0E4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1044,0x0437,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E33,0x0437,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2F,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E30,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E31,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E32,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E29,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2A,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2B,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2C,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2D,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2E,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2F,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E30,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E31,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E32,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E29,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2A,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2B,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2C,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2D,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2E,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2F,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E30,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E31,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E32,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E29,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E2A,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EC1,0x0E33,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

uint16 page04Ddata[]= { /* 4D00 (3 weights per char) */
0xFB80,0xCD00,0x0000, 0xFB80,0xCD01,0x0000, 0xFB80,0xCD02,0x0000,
0xFB80,0xCD03,0x0000, 0xFB80,0xCD04,0x0000, 0xFB80,0xCD05,0x0000,
0xFB80,0xCD06,0x0000, 0xFB80,0xCD07,0x0000, 0xFB80,0xCD08,0x0000,
0xFB80,0xCD09,0x0000, 0xFB80,0xCD0A,0x0000, 0xFB80,0xCD0B,0x0000,
0xFB80,0xCD0C,0x0000, 0xFB80,0xCD0D,0x0000, 0xFB80,0xCD0E,0x0000,
0xFB80,0xCD0F,0x0000, 0xFB80,0xCD10,0x0000, 0xFB80,0xCD11,0x0000,
0xFB80,0xCD12,0x0000, 0xFB80,0xCD13,0x0000, 0xFB80,0xCD14,0x0000,
0xFB80,0xCD15,0x0000, 0xFB80,0xCD16,0x0000, 0xFB80,0xCD17,0x0000,
0xFB80,0xCD18,0x0000, 0xFB80,0xCD19,0x0000, 0xFB80,0xCD1A,0x0000,
0xFB80,0xCD1B,0x0000, 0xFB80,0xCD1C,0x0000, 0xFB80,0xCD1D,0x0000,
0xFB80,0xCD1E,0x0000, 0xFB80,0xCD1F,0x0000, 0xFB80,0xCD20,0x0000,
0xFB80,0xCD21,0x0000, 0xFB80,0xCD22,0x0000, 0xFB80,0xCD23,0x0000,
0xFB80,0xCD24,0x0000, 0xFB80,0xCD25,0x0000, 0xFB80,0xCD26,0x0000,
0xFB80,0xCD27,0x0000, 0xFB80,0xCD28,0x0000, 0xFB80,0xCD29,0x0000,
0xFB80,0xCD2A,0x0000, 0xFB80,0xCD2B,0x0000, 0xFB80,0xCD2C,0x0000,
0xFB80,0xCD2D,0x0000, 0xFB80,0xCD2E,0x0000, 0xFB80,0xCD2F,0x0000,
0xFB80,0xCD30,0x0000, 0xFB80,0xCD31,0x0000, 0xFB80,0xCD32,0x0000,
0xFB80,0xCD33,0x0000, 0xFB80,0xCD34,0x0000, 0xFB80,0xCD35,0x0000,
0xFB80,0xCD36,0x0000, 0xFB80,0xCD37,0x0000, 0xFB80,0xCD38,0x0000,
0xFB80,0xCD39,0x0000, 0xFB80,0xCD3A,0x0000, 0xFB80,0xCD3B,0x0000,
0xFB80,0xCD3C,0x0000, 0xFB80,0xCD3D,0x0000, 0xFB80,0xCD3E,0x0000,
0xFB80,0xCD3F,0x0000, 0xFB80,0xCD40,0x0000, 0xFB80,0xCD41,0x0000,
0xFB80,0xCD42,0x0000, 0xFB80,0xCD43,0x0000, 0xFB80,0xCD44,0x0000,
0xFB80,0xCD45,0x0000, 0xFB80,0xCD46,0x0000, 0xFB80,0xCD47,0x0000,
0xFB80,0xCD48,0x0000, 0xFB80,0xCD49,0x0000, 0xFB80,0xCD4A,0x0000,
0xFB80,0xCD4B,0x0000, 0xFB80,0xCD4C,0x0000, 0xFB80,0xCD4D,0x0000,
0xFB80,0xCD4E,0x0000, 0xFB80,0xCD4F,0x0000, 0xFB80,0xCD50,0x0000,
0xFB80,0xCD51,0x0000, 0xFB80,0xCD52,0x0000, 0xFB80,0xCD53,0x0000,
0xFB80,0xCD54,0x0000, 0xFB80,0xCD55,0x0000, 0xFB80,0xCD56,0x0000,
0xFB80,0xCD57,0x0000, 0xFB80,0xCD58,0x0000, 0xFB80,0xCD59,0x0000,
0xFB80,0xCD5A,0x0000, 0xFB80,0xCD5B,0x0000, 0xFB80,0xCD5C,0x0000,
0xFB80,0xCD5D,0x0000, 0xFB80,0xCD5E,0x0000, 0xFB80,0xCD5F,0x0000,
0xFB80,0xCD60,0x0000, 0xFB80,0xCD61,0x0000, 0xFB80,0xCD62,0x0000,
0xFB80,0xCD63,0x0000, 0xFB80,0xCD64,0x0000, 0xFB80,0xCD65,0x0000,
0xFB80,0xCD66,0x0000, 0xFB80,0xCD67,0x0000, 0xFB80,0xCD68,0x0000,
0xFB80,0xCD69,0x0000, 0xFB80,0xCD6A,0x0000, 0xFB80,0xCD6B,0x0000,
0xFB80,0xCD6C,0x0000, 0xFB80,0xCD6D,0x0000, 0xFB80,0xCD6E,0x0000,
0xFB80,0xCD6F,0x0000, 0xFB80,0xCD70,0x0000, 0xFB80,0xCD71,0x0000,
0xFB80,0xCD72,0x0000, 0xFB80,0xCD73,0x0000, 0xFB80,0xCD74,0x0000,
0xFB80,0xCD75,0x0000, 0xFB80,0xCD76,0x0000, 0xFB80,0xCD77,0x0000,
0xFB80,0xCD78,0x0000, 0xFB80,0xCD79,0x0000, 0xFB80,0xCD7A,0x0000,
0xFB80,0xCD7B,0x0000, 0xFB80,0xCD7C,0x0000, 0xFB80,0xCD7D,0x0000,
0xFB80,0xCD7E,0x0000, 0xFB80,0xCD7F,0x0000, 0xFB80,0xCD80,0x0000,
0xFB80,0xCD81,0x0000, 0xFB80,0xCD82,0x0000, 0xFB80,0xCD83,0x0000,
0xFB80,0xCD84,0x0000, 0xFB80,0xCD85,0x0000, 0xFB80,0xCD86,0x0000,
0xFB80,0xCD87,0x0000, 0xFB80,0xCD88,0x0000, 0xFB80,0xCD89,0x0000,
0xFB80,0xCD8A,0x0000, 0xFB80,0xCD8B,0x0000, 0xFB80,0xCD8C,0x0000,
0xFB80,0xCD8D,0x0000, 0xFB80,0xCD8E,0x0000, 0xFB80,0xCD8F,0x0000,
0xFB80,0xCD90,0x0000, 0xFB80,0xCD91,0x0000, 0xFB80,0xCD92,0x0000,
0xFB80,0xCD93,0x0000, 0xFB80,0xCD94,0x0000, 0xFB80,0xCD95,0x0000,
0xFB80,0xCD96,0x0000, 0xFB80,0xCD97,0x0000, 0xFB80,0xCD98,0x0000,
0xFB80,0xCD99,0x0000, 0xFB80,0xCD9A,0x0000, 0xFB80,0xCD9B,0x0000,
0xFB80,0xCD9C,0x0000, 0xFB80,0xCD9D,0x0000, 0xFB80,0xCD9E,0x0000,
0xFB80,0xCD9F,0x0000, 0xFB80,0xCDA0,0x0000, 0xFB80,0xCDA1,0x0000,
0xFB80,0xCDA2,0x0000, 0xFB80,0xCDA3,0x0000, 0xFB80,0xCDA4,0x0000,
0xFB80,0xCDA5,0x0000, 0xFB80,0xCDA6,0x0000, 0xFB80,0xCDA7,0x0000,
0xFB80,0xCDA8,0x0000, 0xFB80,0xCDA9,0x0000, 0xFB80,0xCDAA,0x0000,
0xFB80,0xCDAB,0x0000, 0xFB80,0xCDAC,0x0000, 0xFB80,0xCDAD,0x0000,
0xFB80,0xCDAE,0x0000, 0xFB80,0xCDAF,0x0000, 0xFB80,0xCDB0,0x0000,
0xFB80,0xCDB1,0x0000, 0xFB80,0xCDB2,0x0000, 0xFB80,0xCDB3,0x0000,
0xFB80,0xCDB4,0x0000, 0xFB80,0xCDB5,0x0000, 0xFBC0,0xCDB6,0x0000,
0xFBC0,0xCDB7,0x0000, 0xFBC0,0xCDB8,0x0000, 0xFBC0,0xCDB9,0x0000,
0xFBC0,0xCDBA,0x0000, 0xFBC0,0xCDBB,0x0000, 0xFBC0,0xCDBC,0x0000,
0xFBC0,0xCDBD,0x0000, 0xFBC0,0xCDBE,0x0000, 0xFBC0,0xCDBF,0x0000,
0x0B37,0x0000,0x0000, 0x0B38,0x0000,0x0000, 0x0B39,0x0000,0x0000,
0x0B3A,0x0000,0x0000, 0x0B3B,0x0000,0x0000, 0x0B3C,0x0000,0x0000,
0x0B3D,0x0000,0x0000, 0x0B3E,0x0000,0x0000, 0x0B3F,0x0000,0x0000,
0x0B40,0x0000,0x0000, 0x0B41,0x0000,0x0000, 0x0B42,0x0000,0x0000,
0x0B43,0x0000,0x0000, 0x0B44,0x0000,0x0000, 0x0B45,0x0000,0x0000,
0x0B46,0x0000,0x0000, 0x0B47,0x0000,0x0000, 0x0B48,0x0000,0x0000,
0x0B49,0x0000,0x0000, 0x0B4A,0x0000,0x0000, 0x0B4B,0x0000,0x0000,
0x0B4C,0x0000,0x0000, 0x0B4D,0x0000,0x0000, 0x0B4E,0x0000,0x0000,
0x0B4F,0x0000,0x0000, 0x0B50,0x0000,0x0000, 0x0B51,0x0000,0x0000,
0x0B52,0x0000,0x0000, 0x0B53,0x0000,0x0000, 0x0B54,0x0000,0x0000,
0x0B55,0x0000,0x0000, 0x0B56,0x0000,0x0000, 0x0B57,0x0000,0x0000,
0x0B58,0x0000,0x0000, 0x0B59,0x0000,0x0000, 0x0B5A,0x0000,0x0000,
0x0B5B,0x0000,0x0000, 0x0B5C,0x0000,0x0000, 0x0B5D,0x0000,0x0000,
0x0B5E,0x0000,0x0000, 0x0B5F,0x0000,0x0000, 0x0B60,0x0000,0x0000,
0x0B61,0x0000,0x0000, 0x0B62,0x0000,0x0000, 0x0B63,0x0000,0x0000,
0x0B64,0x0000,0x0000, 0x0B65,0x0000,0x0000, 0x0B66,0x0000,0x0000,
0x0B67,0x0000,0x0000, 0x0B68,0x0000,0x0000, 0x0B69,0x0000,0x0000,
0x0B6A,0x0000,0x0000, 0x0B6B,0x0000,0x0000, 0x0B6C,0x0000,0x0000,
0x0B6D,0x0000,0x0000, 0x0B6E,0x0000,0x0000, 0x0B6F,0x0000,0x0000,
0x0B70,0x0000,0x0000, 0x0B71,0x0000,0x0000, 0x0B72,0x0000,0x0000,
0x0B73,0x0000,0x0000, 0x0B74,0x0000,0x0000, 0x0B75,0x0000,0x0000,
0x0B76,0x0000,0x0000 };

uint16 page0A0data[]= { /* A000 (2 weights per char) */
0x1EB1,0x0000, 0x1EB2,0x0000, 0x1EB3,0x0000, 0x1EB4,0x0000,
0x1EB5,0x0000, 0x1EB6,0x0000, 0x1EB7,0x0000, 0x1EB8,0x0000,
0x1EB9,0x0000, 0x1EBA,0x0000, 0x1EBB,0x0000, 0x1EBC,0x0000,
0x1EBD,0x0000, 0x1EBE,0x0000, 0x1EBF,0x0000, 0x1EC0,0x0000,
0x1EC1,0x0000, 0x1EC2,0x0000, 0x1EC3,0x0000, 0x1EC4,0x0000,
0x1EC5,0x0000, 0x1EC6,0x0000, 0x1EC7,0x0000, 0x1EC8,0x0000,
0x1EC9,0x0000, 0x1ECA,0x0000, 0x1ECB,0x0000, 0x1ECC,0x0000,
0x1ECD,0x0000, 0x1ECE,0x0000, 0x1ECF,0x0000, 0x1ED0,0x0000,
0x1ED1,0x0000, 0x1ED2,0x0000, 0x1ED3,0x0000, 0x1ED4,0x0000,
0x1ED5,0x0000, 0x1ED6,0x0000, 0x1ED7,0x0000, 0x1ED8,0x0000,
0x1ED9,0x0000, 0x1EDA,0x0000, 0x1EDB,0x0000, 0x1EDC,0x0000,
0x1EDD,0x0000, 0x1EDE,0x0000, 0x1EDF,0x0000, 0x1EE0,0x0000,
0x1EE1,0x0000, 0x1EE2,0x0000, 0x1EE3,0x0000, 0x1EE4,0x0000,
0x1EE5,0x0000, 0x1EE6,0x0000, 0x1EE7,0x0000, 0x1EE8,0x0000,
0x1EE9,0x0000, 0x1EEA,0x0000, 0x1EEB,0x0000, 0x1EEC,0x0000,
0x1EED,0x0000, 0x1EEE,0x0000, 0x1EEF,0x0000, 0x1EF0,0x0000,
0x1EF1,0x0000, 0x1EF2,0x0000, 0x1EF3,0x0000, 0x1EF4,0x0000,
0x1EF5,0x0000, 0x1EF6,0x0000, 0x1EF7,0x0000, 0x1EF8,0x0000,
0x1EF9,0x0000, 0x1EFA,0x0000, 0x1EFB,0x0000, 0x1EFC,0x0000,
0x1EFD,0x0000, 0x1EFE,0x0000, 0x1EFF,0x0000, 0x1F00,0x0000,
0x1F01,0x0000, 0x1F02,0x0000, 0x1F03,0x0000, 0x1F04,0x0000,
0x1F05,0x0000, 0x1F06,0x0000, 0x1F07,0x0000, 0x1F08,0x0000,
0x1F09,0x0000, 0x1F0A,0x0000, 0x1F0B,0x0000, 0x1F0C,0x0000,
0x1F0D,0x0000, 0x1F0E,0x0000, 0x1F0F,0x0000, 0x1F10,0x0000,
0x1F11,0x0000, 0x1F12,0x0000, 0x1F13,0x0000, 0x1F14,0x0000,
0x1F15,0x0000, 0x1F16,0x0000, 0x1F17,0x0000, 0x1F18,0x0000,
0x1F19,0x0000, 0x1F1A,0x0000, 0x1F1B,0x0000, 0x1F1C,0x0000,
0x1F1D,0x0000, 0x1F1E,0x0000, 0x1F1F,0x0000, 0x1F20,0x0000,
0x1F21,0x0000, 0x1F22,0x0000, 0x1F23,0x0000, 0x1F24,0x0000,
0x1F25,0x0000, 0x1F26,0x0000, 0x1F27,0x0000, 0x1F28,0x0000,
0x1F29,0x0000, 0x1F2A,0x0000, 0x1F2B,0x0000, 0x1F2C,0x0000,
0x1F2D,0x0000, 0x1F2E,0x0000, 0x1F2F,0x0000, 0x1F30,0x0000,
0x1F31,0x0000, 0x1F32,0x0000, 0x1F33,0x0000, 0x1F34,0x0000,
0x1F35,0x0000, 0x1F36,0x0000, 0x1F37,0x0000, 0x1F38,0x0000,
0x1F39,0x0000, 0x1F3A,0x0000, 0x1F3B,0x0000, 0x1F3C,0x0000,
0x1F3D,0x0000, 0x1F3E,0x0000, 0x1F3F,0x0000, 0x1F40,0x0000,
0x1F41,0x0000, 0x1F42,0x0000, 0x1F43,0x0000, 0x1F44,0x0000,
0x1F45,0x0000, 0x1F46,0x0000, 0x1F47,0x0000, 0x1F48,0x0000,
0x1F49,0x0000, 0x1F4A,0x0000, 0x1F4B,0x0000, 0x1F4C,0x0000,
0x1F4D,0x0000, 0x1F4E,0x0000, 0x1F4F,0x0000, 0x1F50,0x0000,
0x1F51,0x0000, 0x1F52,0x0000, 0x1F53,0x0000, 0x1F54,0x0000,
0x1F55,0x0000, 0x1F56,0x0000, 0x1F57,0x0000, 0x1F58,0x0000,
0x1F59,0x0000, 0x1F5A,0x0000, 0x1F5B,0x0000, 0x1F5C,0x0000,
0x1F5D,0x0000, 0x1F5E,0x0000, 0x1F5F,0x0000, 0x1F60,0x0000,
0x1F61,0x0000, 0x1F62,0x0000, 0x1F63,0x0000, 0x1F64,0x0000,
0x1F65,0x0000, 0x1F66,0x0000, 0x1F67,0x0000, 0x1F68,0x0000,
0x1F69,0x0000, 0x1F6A,0x0000, 0x1F6B,0x0000, 0x1F6C,0x0000,
0x1F6D,0x0000, 0x1F6E,0x0000, 0x1F6F,0x0000, 0x1F70,0x0000,
0x1F71,0x0000, 0x1F72,0x0000, 0x1F73,0x0000, 0x1F74,0x0000,
0x1F75,0x0000, 0x1F76,0x0000, 0x1F77,0x0000, 0x1F78,0x0000,
0x1F79,0x0000, 0x1F7A,0x0000, 0x1F7B,0x0000, 0x1F7C,0x0000,
0x1F7D,0x0000, 0x1F7E,0x0000, 0x1F7F,0x0000, 0x1F80,0x0000,
0x1F81,0x0000, 0x1F82,0x0000, 0x1F83,0x0000, 0x1F84,0x0000,
0x1F85,0x0000, 0x1F86,0x0000, 0x1F87,0x0000, 0x1F88,0x0000,
0x1F89,0x0000, 0x1F8A,0x0000, 0x1F8B,0x0000, 0x1F8C,0x0000,
0x1F8D,0x0000, 0x1F8E,0x0000, 0x1F8F,0x0000, 0x1F90,0x0000,
0x1F91,0x0000, 0x1F92,0x0000, 0x1F93,0x0000, 0x1F94,0x0000,
0x1F95,0x0000, 0x1F96,0x0000, 0x1F97,0x0000, 0x1F98,0x0000,
0x1F99,0x0000, 0x1F9A,0x0000, 0x1F9B,0x0000, 0x1F9C,0x0000,
0x1F9D,0x0000, 0x1F9E,0x0000, 0x1F9F,0x0000, 0x1FA0,0x0000,
0x1FA1,0x0000, 0x1FA2,0x0000, 0x1FA3,0x0000, 0x1FA4,0x0000,
0x1FA5,0x0000, 0x1FA6,0x0000, 0x1FA7,0x0000, 0x1FA8,0x0000,
0x1FA9,0x0000, 0x1FAA,0x0000, 0x1FAB,0x0000, 0x1FAC,0x0000,
0x1FAD,0x0000, 0x1FAE,0x0000, 0x1FAF,0x0000, 0x1FB0,0x0000
};

uint16 page0A1data[]= { /* A100 (2 weights per char) */
0x1FB1,0x0000, 0x1FB2,0x0000, 0x1FB3,0x0000, 0x1FB4,0x0000,
0x1FB5,0x0000, 0x1FB6,0x0000, 0x1FB7,0x0000, 0x1FB8,0x0000,
0x1FB9,0x0000, 0x1FBA,0x0000, 0x1FBB,0x0000, 0x1FBC,0x0000,
0x1FBD,0x0000, 0x1FBE,0x0000, 0x1FBF,0x0000, 0x1FC0,0x0000,
0x1FC1,0x0000, 0x1FC2,0x0000, 0x1FC3,0x0000, 0x1FC4,0x0000,
0x1FC5,0x0000, 0x1FC6,0x0000, 0x1FC7,0x0000, 0x1FC8,0x0000,
0x1FC9,0x0000, 0x1FCA,0x0000, 0x1FCB,0x0000, 0x1FCC,0x0000,
0x1FCD,0x0000, 0x1FCE,0x0000, 0x1FCF,0x0000, 0x1FD0,0x0000,
0x1FD1,0x0000, 0x1FD2,0x0000, 0x1FD3,0x0000, 0x1FD4,0x0000,
0x1FD5,0x0000, 0x1FD6,0x0000, 0x1FD7,0x0000, 0x1FD8,0x0000,
0x1FD9,0x0000, 0x1FDA,0x0000, 0x1FDB,0x0000, 0x1FDC,0x0000,
0x1FDD,0x0000, 0x1FDE,0x0000, 0x1FDF,0x0000, 0x1FE0,0x0000,
0x1FE1,0x0000, 0x1FE2,0x0000, 0x1FE3,0x0000, 0x1FE4,0x0000,
0x1FE5,0x0000, 0x1FE6,0x0000, 0x1FE7,0x0000, 0x1FE8,0x0000,
0x1FE9,0x0000, 0x1FEA,0x0000, 0x1FEB,0x0000, 0x1FEC,0x0000,
0x1FED,0x0000, 0x1FEE,0x0000, 0x1FEF,0x0000, 0x1FF0,0x0000,
0x1FF1,0x0000, 0x1FF2,0x0000, 0x1FF3,0x0000, 0x1FF4,0x0000,
0x1FF5,0x0000, 0x1FF6,0x0000, 0x1FF7,0x0000, 0x1FF8,0x0000,
0x1FF9,0x0000, 0x1FFA,0x0000, 0x1FFB,0x0000, 0x1FFC,0x0000,
0x1FFD,0x0000, 0x1FFE,0x0000, 0x1FFF,0x0000, 0x2000,0x0000,
0x2001,0x0000, 0x2002,0x0000, 0x2003,0x0000, 0x2004,0x0000,
0x2005,0x0000, 0x2006,0x0000, 0x2007,0x0000, 0x2008,0x0000,
0x2009,0x0000, 0x200A,0x0000, 0x200B,0x0000, 0x200C,0x0000,
0x200D,0x0000, 0x200E,0x0000, 0x200F,0x0000, 0x2010,0x0000,
0x2011,0x0000, 0x2012,0x0000, 0x2013,0x0000, 0x2014,0x0000,
0x2015,0x0000, 0x2016,0x0000, 0x2017,0x0000, 0x2018,0x0000,
0x2019,0x0000, 0x201A,0x0000, 0x201B,0x0000, 0x201C,0x0000,
0x201D,0x0000, 0x201E,0x0000, 0x201F,0x0000, 0x2020,0x0000,
0x2021,0x0000, 0x2022,0x0000, 0x2023,0x0000, 0x2024,0x0000,
0x2025,0x0000, 0x2026,0x0000, 0x2027,0x0000, 0x2028,0x0000,
0x2029,0x0000, 0x202A,0x0000, 0x202B,0x0000, 0x202C,0x0000,
0x202D,0x0000, 0x202E,0x0000, 0x202F,0x0000, 0x2030,0x0000,
0x2031,0x0000, 0x2032,0x0000, 0x2033,0x0000, 0x2034,0x0000,
0x2035,0x0000, 0x2036,0x0000, 0x2037,0x0000, 0x2038,0x0000,
0x2039,0x0000, 0x203A,0x0000, 0x203B,0x0000, 0x203C,0x0000,
0x203D,0x0000, 0x203E,0x0000, 0x203F,0x0000, 0x2040,0x0000,
0x2041,0x0000, 0x2042,0x0000, 0x2043,0x0000, 0x2044,0x0000,
0x2045,0x0000, 0x2046,0x0000, 0x2047,0x0000, 0x2048,0x0000,
0x2049,0x0000, 0x204A,0x0000, 0x204B,0x0000, 0x204C,0x0000,
0x204D,0x0000, 0x204E,0x0000, 0x204F,0x0000, 0x2050,0x0000,
0x2051,0x0000, 0x2052,0x0000, 0x2053,0x0000, 0x2054,0x0000,
0x2055,0x0000, 0x2056,0x0000, 0x2057,0x0000, 0x2058,0x0000,
0x2059,0x0000, 0x205A,0x0000, 0x205B,0x0000, 0x205C,0x0000,
0x205D,0x0000, 0x205E,0x0000, 0x205F,0x0000, 0x2060,0x0000,
0x2061,0x0000, 0x2062,0x0000, 0x2063,0x0000, 0x2064,0x0000,
0x2065,0x0000, 0x2066,0x0000, 0x2067,0x0000, 0x2068,0x0000,
0x2069,0x0000, 0x206A,0x0000, 0x206B,0x0000, 0x206C,0x0000,
0x206D,0x0000, 0x206E,0x0000, 0x206F,0x0000, 0x2070,0x0000,
0x2071,0x0000, 0x2072,0x0000, 0x2073,0x0000, 0x2074,0x0000,
0x2075,0x0000, 0x2076,0x0000, 0x2077,0x0000, 0x2078,0x0000,
0x2079,0x0000, 0x207A,0x0000, 0x207B,0x0000, 0x207C,0x0000,
0x207D,0x0000, 0x207E,0x0000, 0x207F,0x0000, 0x2080,0x0000,
0x2081,0x0000, 0x2082,0x0000, 0x2083,0x0000, 0x2084,0x0000,
0x2085,0x0000, 0x2086,0x0000, 0x2087,0x0000, 0x2088,0x0000,
0x2089,0x0000, 0x208A,0x0000, 0x208B,0x0000, 0x208C,0x0000,
0x208D,0x0000, 0x208E,0x0000, 0x208F,0x0000, 0x2090,0x0000,
0x2091,0x0000, 0x2092,0x0000, 0x2093,0x0000, 0x2094,0x0000,
0x2095,0x0000, 0x2096,0x0000, 0x2097,0x0000, 0x2098,0x0000,
0x2099,0x0000, 0x209A,0x0000, 0x209B,0x0000, 0x209C,0x0000,
0x209D,0x0000, 0x209E,0x0000, 0x209F,0x0000, 0x20A0,0x0000,
0x20A1,0x0000, 0x20A2,0x0000, 0x20A3,0x0000, 0x20A4,0x0000,
0x20A5,0x0000, 0x20A6,0x0000, 0x20A7,0x0000, 0x20A8,0x0000,
0x20A9,0x0000, 0x20AA,0x0000, 0x20AB,0x0000, 0x20AC,0x0000,
0x20AD,0x0000, 0x20AE,0x0000, 0x20AF,0x0000, 0x20B0,0x0000
};

uint16 page0A2data[]= { /* A200 (2 weights per char) */
0x20B1,0x0000, 0x20B2,0x0000, 0x20B3,0x0000, 0x20B4,0x0000,
0x20B5,0x0000, 0x20B6,0x0000, 0x20B7,0x0000, 0x20B8,0x0000,
0x20B9,0x0000, 0x20BA,0x0000, 0x20BB,0x0000, 0x20BC,0x0000,
0x20BD,0x0000, 0x20BE,0x0000, 0x20BF,0x0000, 0x20C0,0x0000,
0x20C1,0x0000, 0x20C2,0x0000, 0x20C3,0x0000, 0x20C4,0x0000,
0x20C5,0x0000, 0x20C6,0x0000, 0x20C7,0x0000, 0x20C8,0x0000,
0x20C9,0x0000, 0x20CA,0x0000, 0x20CB,0x0000, 0x20CC,0x0000,
0x20CD,0x0000, 0x20CE,0x0000, 0x20CF,0x0000, 0x20D0,0x0000,
0x20D1,0x0000, 0x20D2,0x0000, 0x20D3,0x0000, 0x20D4,0x0000,
0x20D5,0x0000, 0x20D6,0x0000, 0x20D7,0x0000, 0x20D8,0x0000,
0x20D9,0x0000, 0x20DA,0x0000, 0x20DB,0x0000, 0x20DC,0x0000,
0x20DD,0x0000, 0x20DE,0x0000, 0x20DF,0x0000, 0x20E0,0x0000,
0x20E1,0x0000, 0x20E2,0x0000, 0x20E3,0x0000, 0x20E4,0x0000,
0x20E5,0x0000, 0x20E6,0x0000, 0x20E7,0x0000, 0x20E8,0x0000,
0x20E9,0x0000, 0x20EA,0x0000, 0x20EB,0x0000, 0x20EC,0x0000,
0x20ED,0x0000, 0x20EE,0x0000, 0x20EF,0x0000, 0x20F0,0x0000,
0x20F1,0x0000, 0x20F2,0x0000, 0x20F3,0x0000, 0x20F4,0x0000,
0x20F5,0x0000, 0x20F6,0x0000, 0x20F7,0x0000, 0x20F8,0x0000,
0x20F9,0x0000, 0x20FA,0x0000, 0x20FB,0x0000, 0x20FC,0x0000,
0x20FD,0x0000, 0x20FE,0x0000, 0x20FF,0x0000, 0x2100,0x0000,
0x2101,0x0000, 0x2102,0x0000, 0x2103,0x0000, 0x2104,0x0000,
0x2105,0x0000, 0x2106,0x0000, 0x2107,0x0000, 0x2108,0x0000,
0x2109,0x0000, 0x210A,0x0000, 0x210B,0x0000, 0x210C,0x0000,
0x210D,0x0000, 0x210E,0x0000, 0x210F,0x0000, 0x2110,0x0000,
0x2111,0x0000, 0x2112,0x0000, 0x2113,0x0000, 0x2114,0x0000,
0x2115,0x0000, 0x2116,0x0000, 0x2117,0x0000, 0x2118,0x0000,
0x2119,0x0000, 0x211A,0x0000, 0x211B,0x0000, 0x211C,0x0000,
0x211D,0x0000, 0x211E,0x0000, 0x211F,0x0000, 0x2120,0x0000,
0x2121,0x0000, 0x2122,0x0000, 0x2123,0x0000, 0x2124,0x0000,
0x2125,0x0000, 0x2126,0x0000, 0x2127,0x0000, 0x2128,0x0000,
0x2129,0x0000, 0x212A,0x0000, 0x212B,0x0000, 0x212C,0x0000,
0x212D,0x0000, 0x212E,0x0000, 0x212F,0x0000, 0x2130,0x0000,
0x2131,0x0000, 0x2132,0x0000, 0x2133,0x0000, 0x2134,0x0000,
0x2135,0x0000, 0x2136,0x0000, 0x2137,0x0000, 0x2138,0x0000,
0x2139,0x0000, 0x213A,0x0000, 0x213B,0x0000, 0x213C,0x0000,
0x213D,0x0000, 0x213E,0x0000, 0x213F,0x0000, 0x2140,0x0000,
0x2141,0x0000, 0x2142,0x0000, 0x2143,0x0000, 0x2144,0x0000,
0x2145,0x0000, 0x2146,0x0000, 0x2147,0x0000, 0x2148,0x0000,
0x2149,0x0000, 0x214A,0x0000, 0x214B,0x0000, 0x214C,0x0000,
0x214D,0x0000, 0x214E,0x0000, 0x214F,0x0000, 0x2150,0x0000,
0x2151,0x0000, 0x2152,0x0000, 0x2153,0x0000, 0x2154,0x0000,
0x2155,0x0000, 0x2156,0x0000, 0x2157,0x0000, 0x2158,0x0000,
0x2159,0x0000, 0x215A,0x0000, 0x215B,0x0000, 0x215C,0x0000,
0x215D,0x0000, 0x215E,0x0000, 0x215F,0x0000, 0x2160,0x0000,
0x2161,0x0000, 0x2162,0x0000, 0x2163,0x0000, 0x2164,0x0000,
0x2165,0x0000, 0x2166,0x0000, 0x2167,0x0000, 0x2168,0x0000,
0x2169,0x0000, 0x216A,0x0000, 0x216B,0x0000, 0x216C,0x0000,
0x216D,0x0000, 0x216E,0x0000, 0x216F,0x0000, 0x2170,0x0000,
0x2171,0x0000, 0x2172,0x0000, 0x2173,0x0000, 0x2174,0x0000,
0x2175,0x0000, 0x2176,0x0000, 0x2177,0x0000, 0x2178,0x0000,
0x2179,0x0000, 0x217A,0x0000, 0x217B,0x0000, 0x217C,0x0000,
0x217D,0x0000, 0x217E,0x0000, 0x217F,0x0000, 0x2180,0x0000,
0x2181,0x0000, 0x2182,0x0000, 0x2183,0x0000, 0x2184,0x0000,
0x2185,0x0000, 0x2186,0x0000, 0x2187,0x0000, 0x2188,0x0000,
0x2189,0x0000, 0x218A,0x0000, 0x218B,0x0000, 0x218C,0x0000,
0x218D,0x0000, 0x218E,0x0000, 0x218F,0x0000, 0x2190,0x0000,
0x2191,0x0000, 0x2192,0x0000, 0x2193,0x0000, 0x2194,0x0000,
0x2195,0x0000, 0x2196,0x0000, 0x2197,0x0000, 0x2198,0x0000,
0x2199,0x0000, 0x219A,0x0000, 0x219B,0x0000, 0x219C,0x0000,
0x219D,0x0000, 0x219E,0x0000, 0x219F,0x0000, 0x21A0,0x0000,
0x21A1,0x0000, 0x21A2,0x0000, 0x21A3,0x0000, 0x21A4,0x0000,
0x21A5,0x0000, 0x21A6,0x0000, 0x21A7,0x0000, 0x21A8,0x0000,
0x21A9,0x0000, 0x21AA,0x0000, 0x21AB,0x0000, 0x21AC,0x0000,
0x21AD,0x0000, 0x21AE,0x0000, 0x21AF,0x0000, 0x21B0,0x0000
};

uint16 page0A3data[]= { /* A300 (2 weights per char) */
0x21B1,0x0000, 0x21B2,0x0000, 0x21B3,0x0000, 0x21B4,0x0000,
0x21B5,0x0000, 0x21B6,0x0000, 0x21B7,0x0000, 0x21B8,0x0000,
0x21B9,0x0000, 0x21BA,0x0000, 0x21BB,0x0000, 0x21BC,0x0000,
0x21BD,0x0000, 0x21BE,0x0000, 0x21BF,0x0000, 0x21C0,0x0000,
0x21C1,0x0000, 0x21C2,0x0000, 0x21C3,0x0000, 0x21C4,0x0000,
0x21C5,0x0000, 0x21C6,0x0000, 0x21C7,0x0000, 0x21C8,0x0000,
0x21C9,0x0000, 0x21CA,0x0000, 0x21CB,0x0000, 0x21CC,0x0000,
0x21CD,0x0000, 0x21CE,0x0000, 0x21CF,0x0000, 0x21D0,0x0000,
0x21D1,0x0000, 0x21D2,0x0000, 0x21D3,0x0000, 0x21D4,0x0000,
0x21D5,0x0000, 0x21D6,0x0000, 0x21D7,0x0000, 0x21D8,0x0000,
0x21D9,0x0000, 0x21DA,0x0000, 0x21DB,0x0000, 0x21DC,0x0000,
0x21DD,0x0000, 0x21DE,0x0000, 0x21DF,0x0000, 0x21E0,0x0000,
0x21E1,0x0000, 0x21E2,0x0000, 0x21E3,0x0000, 0x21E4,0x0000,
0x21E5,0x0000, 0x21E6,0x0000, 0x21E7,0x0000, 0x21E8,0x0000,
0x21E9,0x0000, 0x21EA,0x0000, 0x21EB,0x0000, 0x21EC,0x0000,
0x21ED,0x0000, 0x21EE,0x0000, 0x21EF,0x0000, 0x21F0,0x0000,
0x21F1,0x0000, 0x21F2,0x0000, 0x21F3,0x0000, 0x21F4,0x0000,
0x21F5,0x0000, 0x21F6,0x0000, 0x21F7,0x0000, 0x21F8,0x0000,
0x21F9,0x0000, 0x21FA,0x0000, 0x21FB,0x0000, 0x21FC,0x0000,
0x21FD,0x0000, 0x21FE,0x0000, 0x21FF,0x0000, 0x2200,0x0000,
0x2201,0x0000, 0x2202,0x0000, 0x2203,0x0000, 0x2204,0x0000,
0x2205,0x0000, 0x2206,0x0000, 0x2207,0x0000, 0x2208,0x0000,
0x2209,0x0000, 0x220A,0x0000, 0x220B,0x0000, 0x220C,0x0000,
0x220D,0x0000, 0x220E,0x0000, 0x220F,0x0000, 0x2210,0x0000,
0x2211,0x0000, 0x2212,0x0000, 0x2213,0x0000, 0x2214,0x0000,
0x2215,0x0000, 0x2216,0x0000, 0x2217,0x0000, 0x2218,0x0000,
0x2219,0x0000, 0x221A,0x0000, 0x221B,0x0000, 0x221C,0x0000,
0x221D,0x0000, 0x221E,0x0000, 0x221F,0x0000, 0x2220,0x0000,
0x2221,0x0000, 0x2222,0x0000, 0x2223,0x0000, 0x2224,0x0000,
0x2225,0x0000, 0x2226,0x0000, 0x2227,0x0000, 0x2228,0x0000,
0x2229,0x0000, 0x222A,0x0000, 0x222B,0x0000, 0x222C,0x0000,
0x222D,0x0000, 0x222E,0x0000, 0x222F,0x0000, 0x2230,0x0000,
0x2231,0x0000, 0x2232,0x0000, 0x2233,0x0000, 0x2234,0x0000,
0x2235,0x0000, 0x2236,0x0000, 0x2237,0x0000, 0x2238,0x0000,
0x2239,0x0000, 0x223A,0x0000, 0x223B,0x0000, 0x223C,0x0000,
0x223D,0x0000, 0x223E,0x0000, 0x223F,0x0000, 0x2240,0x0000,
0x2241,0x0000, 0x2242,0x0000, 0x2243,0x0000, 0x2244,0x0000,
0x2245,0x0000, 0x2246,0x0000, 0x2247,0x0000, 0x2248,0x0000,
0x2249,0x0000, 0x224A,0x0000, 0x224B,0x0000, 0x224C,0x0000,
0x224D,0x0000, 0x224E,0x0000, 0x224F,0x0000, 0x2250,0x0000,
0x2251,0x0000, 0x2252,0x0000, 0x2253,0x0000, 0x2254,0x0000,
0x2255,0x0000, 0x2256,0x0000, 0x2257,0x0000, 0x2258,0x0000,
0x2259,0x0000, 0x225A,0x0000, 0x225B,0x0000, 0x225C,0x0000,
0x225D,0x0000, 0x225E,0x0000, 0x225F,0x0000, 0x2260,0x0000,
0x2261,0x0000, 0x2262,0x0000, 0x2263,0x0000, 0x2264,0x0000,
0x2265,0x0000, 0x2266,0x0000, 0x2267,0x0000, 0x2268,0x0000,
0x2269,0x0000, 0x226A,0x0000, 0x226B,0x0000, 0x226C,0x0000,
0x226D,0x0000, 0x226E,0x0000, 0x226F,0x0000, 0x2270,0x0000,
0x2271,0x0000, 0x2272,0x0000, 0x2273,0x0000, 0x2274,0x0000,
0x2275,0x0000, 0x2276,0x0000, 0x2277,0x0000, 0x2278,0x0000,
0x2279,0x0000, 0x227A,0x0000, 0x227B,0x0000, 0x227C,0x0000,
0x227D,0x0000, 0x227E,0x0000, 0x227F,0x0000, 0x2280,0x0000,
0x2281,0x0000, 0x2282,0x0000, 0x2283,0x0000, 0x2284,0x0000,
0x2285,0x0000, 0x2286,0x0000, 0x2287,0x0000, 0x2288,0x0000,
0x2289,0x0000, 0x228A,0x0000, 0x228B,0x0000, 0x228C,0x0000,
0x228D,0x0000, 0x228E,0x0000, 0x228F,0x0000, 0x2290,0x0000,
0x2291,0x0000, 0x2292,0x0000, 0x2293,0x0000, 0x2294,0x0000,
0x2295,0x0000, 0x2296,0x0000, 0x2297,0x0000, 0x2298,0x0000,
0x2299,0x0000, 0x229A,0x0000, 0x229B,0x0000, 0x229C,0x0000,
0x229D,0x0000, 0x229E,0x0000, 0x229F,0x0000, 0x22A0,0x0000,
0x22A1,0x0000, 0x22A2,0x0000, 0x22A3,0x0000, 0x22A4,0x0000,
0x22A5,0x0000, 0x22A6,0x0000, 0x22A7,0x0000, 0x22A8,0x0000,
0x22A9,0x0000, 0x22AA,0x0000, 0x22AB,0x0000, 0x22AC,0x0000,
0x22AD,0x0000, 0x22AE,0x0000, 0x22AF,0x0000, 0x22B0,0x0000
};

uint16 page0A4data[]= { /* A400 (3 weights per char) */
0x22B1,0x0000,0x0000, 0x22B2,0x0000,0x0000, 0x22B3,0x0000,0x0000,
0x22B4,0x0000,0x0000, 0x22B5,0x0000,0x0000, 0x22B6,0x0000,0x0000,
0x22B7,0x0000,0x0000, 0x22B8,0x0000,0x0000, 0x22B9,0x0000,0x0000,
0x22BA,0x0000,0x0000, 0x22BB,0x0000,0x0000, 0x22BC,0x0000,0x0000,
0x22BD,0x0000,0x0000, 0x22BE,0x0000,0x0000, 0x22BF,0x0000,0x0000,
0x22C0,0x0000,0x0000, 0x22C1,0x0000,0x0000, 0x22C2,0x0000,0x0000,
0x22C3,0x0000,0x0000, 0x22C4,0x0000,0x0000, 0x22C5,0x0000,0x0000,
0x22C6,0x0000,0x0000, 0x22C7,0x0000,0x0000, 0x22C8,0x0000,0x0000,
0x22C9,0x0000,0x0000, 0x22CA,0x0000,0x0000, 0x22CB,0x0000,0x0000,
0x22CC,0x0000,0x0000, 0x22CD,0x0000,0x0000, 0x22CE,0x0000,0x0000,
0x22CF,0x0000,0x0000, 0x22D0,0x0000,0x0000, 0x22D1,0x0000,0x0000,
0x22D2,0x0000,0x0000, 0x22D3,0x0000,0x0000, 0x22D4,0x0000,0x0000,
0x22D5,0x0000,0x0000, 0x22D6,0x0000,0x0000, 0x22D7,0x0000,0x0000,
0x22D8,0x0000,0x0000, 0x22D9,0x0000,0x0000, 0x22DA,0x0000,0x0000,
0x22DB,0x0000,0x0000, 0x22DC,0x0000,0x0000, 0x22DD,0x0000,0x0000,
0x22DE,0x0000,0x0000, 0x22DF,0x0000,0x0000, 0x22E0,0x0000,0x0000,
0x22E1,0x0000,0x0000, 0x22E2,0x0000,0x0000, 0x22E3,0x0000,0x0000,
0x22E4,0x0000,0x0000, 0x22E5,0x0000,0x0000, 0x22E6,0x0000,0x0000,
0x22E7,0x0000,0x0000, 0x22E8,0x0000,0x0000, 0x22E9,0x0000,0x0000,
0x22EA,0x0000,0x0000, 0x22EB,0x0000,0x0000, 0x22EC,0x0000,0x0000,
0x22ED,0x0000,0x0000, 0x22EE,0x0000,0x0000, 0x22EF,0x0000,0x0000,
0x22F0,0x0000,0x0000, 0x22F1,0x0000,0x0000, 0x22F2,0x0000,0x0000,
0x22F3,0x0000,0x0000, 0x22F4,0x0000,0x0000, 0x22F5,0x0000,0x0000,
0x22F6,0x0000,0x0000, 0x22F7,0x0000,0x0000, 0x22F8,0x0000,0x0000,
0x22F9,0x0000,0x0000, 0x22FA,0x0000,0x0000, 0x22FB,0x0000,0x0000,
0x22FC,0x0000,0x0000, 0x22FD,0x0000,0x0000, 0x22FE,0x0000,0x0000,
0x22FF,0x0000,0x0000, 0x2300,0x0000,0x0000, 0x2301,0x0000,0x0000,
0x2302,0x0000,0x0000, 0x2303,0x0000,0x0000, 0x2304,0x0000,0x0000,
0x2305,0x0000,0x0000, 0x2306,0x0000,0x0000, 0x2307,0x0000,0x0000,
0x2308,0x0000,0x0000, 0x2309,0x0000,0x0000, 0x230A,0x0000,0x0000,
0x230B,0x0000,0x0000, 0x230C,0x0000,0x0000, 0x230D,0x0000,0x0000,
0x230E,0x0000,0x0000, 0x230F,0x0000,0x0000, 0x2310,0x0000,0x0000,
0x2311,0x0000,0x0000, 0x2312,0x0000,0x0000, 0x2313,0x0000,0x0000,
0x2314,0x0000,0x0000, 0x2315,0x0000,0x0000, 0x2316,0x0000,0x0000,
0x2317,0x0000,0x0000, 0x2318,0x0000,0x0000, 0x2319,0x0000,0x0000,
0x231A,0x0000,0x0000, 0x231B,0x0000,0x0000, 0x231C,0x0000,0x0000,
0x231D,0x0000,0x0000, 0x231E,0x0000,0x0000, 0x231F,0x0000,0x0000,
0x2320,0x0000,0x0000, 0x2321,0x0000,0x0000, 0x2322,0x0000,0x0000,
0x2323,0x0000,0x0000, 0x2324,0x0000,0x0000, 0x2325,0x0000,0x0000,
0x2326,0x0000,0x0000, 0x2327,0x0000,0x0000, 0x2328,0x0000,0x0000,
0x2329,0x0000,0x0000, 0x232A,0x0000,0x0000, 0x232B,0x0000,0x0000,
0x232C,0x0000,0x0000, 0x232D,0x0000,0x0000, 0x232E,0x0000,0x0000,
0x232F,0x0000,0x0000, 0x2330,0x0000,0x0000, 0x2331,0x0000,0x0000,
0x2332,0x0000,0x0000, 0x2333,0x0000,0x0000, 0x2334,0x0000,0x0000,
0x2335,0x0000,0x0000, 0x2336,0x0000,0x0000, 0x2337,0x0000,0x0000,
0x2338,0x0000,0x0000, 0x2339,0x0000,0x0000, 0x233A,0x0000,0x0000,
0x233B,0x0000,0x0000, 0x233C,0x0000,0x0000, 0x233D,0x0000,0x0000,
0xFBC1,0xA48D,0x0000, 0xFBC1,0xA48E,0x0000, 0xFBC1,0xA48F,0x0000,
0x0BCE,0x0000,0x0000, 0x0BCF,0x0000,0x0000, 0x0BD0,0x0000,0x0000,
0x0BD1,0x0000,0x0000, 0x0BD2,0x0000,0x0000, 0x0BD3,0x0000,0x0000,
0x0BD4,0x0000,0x0000, 0x0BD5,0x0000,0x0000, 0x0BD6,0x0000,0x0000,
0x0BD7,0x0000,0x0000, 0x0BD8,0x0000,0x0000, 0x0BD9,0x0000,0x0000,
0x0BDA,0x0000,0x0000, 0x0BDB,0x0000,0x0000, 0x0BDC,0x0000,0x0000,
0x0BDD,0x0000,0x0000, 0x0BDE,0x0000,0x0000, 0x0BDF,0x0000,0x0000,
0x0BE0,0x0000,0x0000, 0x0BE1,0x0000,0x0000, 0x0BE2,0x0000,0x0000,
0x0BE3,0x0000,0x0000, 0x0BE4,0x0000,0x0000, 0x0BE5,0x0000,0x0000,
0x0BE6,0x0000,0x0000, 0x0BE7,0x0000,0x0000, 0x0BE8,0x0000,0x0000,
0x0BE9,0x0000,0x0000, 0x0BEA,0x0000,0x0000, 0x0BEB,0x0000,0x0000,
0x0BEC,0x0000,0x0000, 0x0BED,0x0000,0x0000, 0x0BEE,0x0000,0x0000,
0x0BEF,0x0000,0x0000, 0x0BF0,0x0000,0x0000, 0x0BF1,0x0000,0x0000,
0x0BF2,0x0000,0x0000, 0x0BF3,0x0000,0x0000, 0x0BF4,0x0000,0x0000,
0x0BF5,0x0000,0x0000, 0x0BF6,0x0000,0x0000, 0x0BF7,0x0000,0x0000,
0x0BF8,0x0000,0x0000, 0x0BF9,0x0000,0x0000, 0x0BFA,0x0000,0x0000,
0x0BFB,0x0000,0x0000, 0x0BFC,0x0000,0x0000, 0x0BFD,0x0000,0x0000,
0x0BFE,0x0000,0x0000, 0x0BFF,0x0000,0x0000, 0x0C00,0x0000,0x0000,
0x0C01,0x0000,0x0000, 0x0C02,0x0000,0x0000, 0x0C03,0x0000,0x0000,
0x0C04,0x0000,0x0000, 0xFBC1,0xA4C7,0x0000, 0xFBC1,0xA4C8,0x0000,
0xFBC1,0xA4C9,0x0000, 0xFBC1,0xA4CA,0x0000, 0xFBC1,0xA4CB,0x0000,
0xFBC1,0xA4CC,0x0000, 0xFBC1,0xA4CD,0x0000, 0xFBC1,0xA4CE,0x0000,
0xFBC1,0xA4CF,0x0000, 0xFBC1,0xA4D0,0x0000, 0xFBC1,0xA4D1,0x0000,
0xFBC1,0xA4D2,0x0000, 0xFBC1,0xA4D3,0x0000, 0xFBC1,0xA4D4,0x0000,
0xFBC1,0xA4D5,0x0000, 0xFBC1,0xA4D6,0x0000, 0xFBC1,0xA4D7,0x0000,
0xFBC1,0xA4D8,0x0000, 0xFBC1,0xA4D9,0x0000, 0xFBC1,0xA4DA,0x0000,
0xFBC1,0xA4DB,0x0000, 0xFBC1,0xA4DC,0x0000, 0xFBC1,0xA4DD,0x0000,
0xFBC1,0xA4DE,0x0000, 0xFBC1,0xA4DF,0x0000, 0xFBC1,0xA4E0,0x0000,
0xFBC1,0xA4E1,0x0000, 0xFBC1,0xA4E2,0x0000, 0xFBC1,0xA4E3,0x0000,
0xFBC1,0xA4E4,0x0000, 0xFBC1,0xA4E5,0x0000, 0xFBC1,0xA4E6,0x0000,
0xFBC1,0xA4E7,0x0000, 0xFBC1,0xA4E8,0x0000, 0xFBC1,0xA4E9,0x0000,
0xFBC1,0xA4EA,0x0000, 0xFBC1,0xA4EB,0x0000, 0xFBC1,0xA4EC,0x0000,
0xFBC1,0xA4ED,0x0000, 0xFBC1,0xA4EE,0x0000, 0xFBC1,0xA4EF,0x0000,
0xFBC1,0xA4F0,0x0000, 0xFBC1,0xA4F1,0x0000, 0xFBC1,0xA4F2,0x0000,
0xFBC1,0xA4F3,0x0000, 0xFBC1,0xA4F4,0x0000, 0xFBC1,0xA4F5,0x0000,
0xFBC1,0xA4F6,0x0000, 0xFBC1,0xA4F7,0x0000, 0xFBC1,0xA4F8,0x0000,
0xFBC1,0xA4F9,0x0000, 0xFBC1,0xA4FA,0x0000, 0xFBC1,0xA4FB,0x0000,
0xFBC1,0xA4FC,0x0000, 0xFBC1,0xA4FD,0x0000, 0xFBC1,0xA4FE,0x0000,
0xFBC1,0xA4FF,0x0000 };

uint16 page0F9data[]= { /* F900 (3 weights per char) */
0xFB41,0x8C48,0x0000, 0xFB40,0xE6F4,0x0000, 0xFB41,0x8ECA,0x0000,
0xFB41,0x8CC8,0x0000, 0xFB40,0xEED1,0x0000, 0xFB40,0xCE32,0x0000,
0xFB40,0xD3E5,0x0000, 0xFB41,0x9F9C,0x0000, 0xFB41,0x9F9C,0x0000,
0xFB40,0xD951,0x0000, 0xFB41,0x91D1,0x0000, 0xFB40,0xD587,0x0000,
0xFB40,0xD948,0x0000, 0xFB40,0xE1F6,0x0000, 0xFB40,0xF669,0x0000,
0xFB40,0xFF85,0x0000, 0xFB41,0x863F,0x0000, 0xFB41,0x87BA,0x0000,
0xFB41,0x88F8,0x0000, 0xFB41,0x908F,0x0000, 0xFB40,0xEA02,0x0000,
0xFB40,0xED1B,0x0000, 0xFB40,0xF0D9,0x0000, 0xFB40,0xF3DE,0x0000,
0xFB41,0x843D,0x0000, 0xFB41,0x916A,0x0000, 0xFB41,0x99F1,0x0000,
0xFB40,0xCE82,0x0000, 0xFB40,0xD375,0x0000, 0xFB40,0xEB04,0x0000,
0xFB40,0xF21B,0x0000, 0xFB41,0x862D,0x0000, 0xFB41,0x9E1E,0x0000,
0xFB40,0xDD50,0x0000, 0xFB40,0xEFEB,0x0000, 0xFB41,0x85CD,0x0000,
0xFB41,0x8964,0x0000, 0xFB40,0xE2C9,0x0000, 0xFB41,0x81D8,0x0000,
0xFB41,0x881F,0x0000, 0xFB40,0xDECA,0x0000, 0xFB40,0xE717,0x0000,
0xFB40,0xED6A,0x0000, 0xFB40,0xF2FC,0x0000, 0xFB41,0x90CE,0x0000,
0xFB40,0xCF86,0x0000, 0xFB40,0xD1B7,0x0000, 0xFB40,0xD2DE,0x0000,
0xFB40,0xE4C4,0x0000, 0xFB40,0xEAD3,0x0000, 0xFB40,0xF210,0x0000,
0xFB40,0xF6E7,0x0000, 0xFB41,0x8001,0x0000, 0xFB41,0x8606,0x0000,
0xFB41,0x865C,0x0000, 0xFB41,0x8DEF,0x0000, 0xFB41,0x9732,0x0000,
0xFB41,0x9B6F,0x0000, 0xFB41,0x9DFA,0x0000, 0xFB40,0xF88C,0x0000,
0xFB40,0xF97F,0x0000, 0xFB40,0xFDA0,0x0000, 0xFB41,0x83C9,0x0000,
0xFB41,0x9304,0x0000, 0xFB41,0x9E7F,0x0000, 0xFB41,0x8AD6,0x0000,
0xFB40,0xD8DF,0x0000, 0xFB40,0xDF04,0x0000, 0xFB40,0xFC60,0x0000,
0xFB41,0x807E,0x0000, 0xFB40,0xF262,0x0000, 0xFB40,0xF8CA,0x0000,
0xFB41,0x8CC2,0x0000, 0xFB41,0x96F7,0x0000, 0xFB40,0xD8D8,0x0000,
0xFB40,0xDC62,0x0000, 0xFB40,0xEA13,0x0000, 0xFB40,0xEDDA,0x0000,
0xFB40,0xEF0F,0x0000, 0xFB40,0xFD2F,0x0000, 0xFB40,0xFE37,0x0000,
0xFB41,0x964B,0x0000, 0xFB40,0xD2D2,0x0000, 0xFB41,0x808B,0x0000,
0xFB40,0xD1DC,0x0000, 0xFB40,0xD1CC,0x0000, 0xFB40,0xFA1C,0x0000,
0xFB40,0xFDBE,0x0000, 0xFB41,0x83F1,0x0000, 0xFB41,0x9675,0x0000,
0xFB41,0x8B80,0x0000, 0xFB40,0xE2CF,0x0000, 0xFB40,0xEA02,0x0000,
0xFB41,0x8AFE,0x0000, 0xFB40,0xCE39,0x0000, 0xFB40,0xDBE7,0x0000,
0xFB40,0xE012,0x0000, 0xFB40,0xF387,0x0000, 0xFB40,0xF570,0x0000,
0xFB40,0xD317,0x0000, 0xFB40,0xF8FB,0x0000, 0xFB40,0xCFBF,0x0000,
0xFB40,0xDFA9,0x0000, 0xFB40,0xCE0D,0x0000, 0xFB40,0xECCC,0x0000,
0xFB40,0xE578,0x0000, 0xFB40,0xFD22,0x0000, 0xFB40,0xD3C3,0x0000,
0xFB40,0xD85E,0x0000, 0xFB40,0xF701,0x0000, 0xFB41,0x8449,0x0000,
0xFB41,0x8AAA,0x0000, 0xFB40,0xEBBA,0x0000, 0xFB41,0x8FB0,0x0000,
0xFB40,0xEC88,0x0000, 0xFB40,0xE2FE,0x0000, 0xFB41,0x82E5,0x0000,
0xFB40,0xE3A0,0x0000, 0xFB40,0xF565,0x0000, 0xFB40,0xCEAE,0x0000,
0xFB40,0xD169,0x0000, 0xFB40,0xD1C9,0x0000, 0xFB40,0xE881,0x0000,
0xFB40,0xFCE7,0x0000, 0xFB41,0x826F,0x0000, 0xFB41,0x8AD2,0x0000,
0xFB41,0x91CF,0x0000, 0xFB40,0xD2F5,0x0000, 0xFB40,0xD442,0x0000,
0xFB40,0xD973,0x0000, 0xFB40,0xDEEC,0x0000, 0xFB40,0xE5C5,0x0000,
0xFB40,0xEFFE,0x0000, 0xFB40,0xF92A,0x0000, 0xFB41,0x95AD,0x0000,
0xFB41,0x9A6A,0x0000, 0xFB41,0x9E97,0x0000, 0xFB41,0x9ECE,0x0000,
0xFB40,0xD29B,0x0000, 0xFB40,0xE6C6,0x0000, 0xFB40,0xEB77,0x0000,
0xFB41,0x8F62,0x0000, 0xFB40,0xDE74,0x0000, 0xFB40,0xE190,0x0000,
0xFB40,0xE200,0x0000, 0xFB40,0xE49A,0x0000, 0xFB40,0xEF23,0x0000,
0xFB40,0xF149,0x0000, 0xFB40,0xF489,0x0000, 0xFB40,0xF9CA,0x0000,
0xFB40,0xFDF4,0x0000, 0xFB41,0x806F,0x0000, 0xFB41,0x8F26,0x0000,
0xFB41,0x84EE,0x0000, 0xFB41,0x9023,0x0000, 0xFB41,0x934A,0x0000,
0xFB40,0xD217,0x0000, 0xFB40,0xD2A3,0x0000, 0xFB40,0xD4BD,0x0000,
0xFB40,0xF0C8,0x0000, 0xFB41,0x88C2,0x0000, 0xFB41,0x8AAA,0x0000,
0xFB40,0xDEC9,0x0000, 0xFB40,0xDFF5,0x0000, 0xFB40,0xE37B,0x0000,
0xFB40,0xEBAE,0x0000, 0xFB40,0xFC3E,0x0000, 0xFB40,0xF375,0x0000,
0xFB40,0xCEE4,0x0000, 0xFB40,0xD6F9,0x0000, 0xFB40,0xDBE7,0x0000,
0xFB40,0xDDBA,0x0000, 0xFB40,0xE01C,0x0000, 0xFB40,0xF3B2,0x0000,
0xFB40,0xF469,0x0000, 0xFB40,0xFF9A,0x0000, 0xFB41,0x8046,0x0000,
0xFB41,0x9234,0x0000, 0xFB41,0x96F6,0x0000, 0xFB41,0x9748,0x0000,
0xFB41,0x9818,0x0000, 0xFB40,0xCF8B,0x0000, 0xFB40,0xF9AE,0x0000,
0xFB41,0x91B4,0x0000, 0xFB41,0x96B8,0x0000, 0xFB40,0xE0E1,0x0000,
0xFB40,0xCE86,0x0000, 0xFB40,0xD0DA,0x0000, 0xFB40,0xDBEE,0x0000,
0xFB40,0xDC3F,0x0000, 0xFB40,0xE599,0x0000, 0xFB40,0xEA02,0x0000,
0xFB40,0xF1CE,0x0000, 0xFB40,0xF642,0x0000, 0xFB41,0x84FC,0x0000,
0xFB41,0x907C,0x0000, 0xFB41,0x9F8D,0x0000, 0xFB40,0xE688,0x0000,
0xFB41,0x962E,0x0000, 0xFB40,0xD289,0x0000, 0xFB40,0xE77B,0x0000,
0xFB40,0xE7F3,0x0000, 0xFB40,0xED41,0x0000, 0xFB40,0xEE9C,0x0000,
0xFB40,0xF409,0x0000, 0xFB40,0xF559,0x0000, 0xFB40,0xF86B,0x0000,
0xFB40,0xFD10,0x0000, 0xFB41,0x985E,0x0000, 0xFB40,0xD16D,0x0000,
0xFB40,0xE22E,0x0000, 0xFB41,0x9678,0x0000, 0xFB40,0xD02B,0x0000,
0xFB40,0xDD19,0x0000, 0xFB40,0xEDEA,0x0000, 0xFB41,0x8F2A,0x0000,
0xFB40,0xDF8B,0x0000, 0xFB40,0xE144,0x0000, 0xFB40,0xE817,0x0000,
0xFB40,0xF387,0x0000, 0xFB41,0x9686,0x0000, 0xFB40,0xD229,0x0000,
0xFB40,0xD40F,0x0000, 0xFB40,0xDC65,0x0000, 0xFB40,0xE613,0x0000,
0xFB40,0xE74E,0x0000, 0xFB40,0xE8A8,0x0000, 0xFB40,0xECE5,0x0000,
0xFB40,0xF406,0x0000, 0xFB40,0xF5E2,0x0000, 0xFB40,0xFF79,0x0000,
0xFB41,0x88CF,0x0000, 0xFB41,0x88E1,0x0000, 0xFB41,0x91CC,0x0000,
0xFB41,0x96E2,0x0000, 0xFB40,0xD33F,0x0000, 0xFB40,0xEEBA,0x0000,
0xFB40,0xD41D,0x0000, 0xFB40,0xF1D0,0x0000, 0xFB40,0xF498,0x0000,
0xFB41,0x85FA,0x0000, 0xFB41,0x96A3,0x0000, 0xFB41,0x9C57,0x0000,
0xFB41,0x9E9F,0x0000, 0xFB40,0xE797,0x0000, 0xFB40,0xEDCB,0x0000,
0xFB41,0x81E8,0x0000, 0xFB40,0xFACB,0x0000, 0xFB40,0xFB20,0x0000,
0xFB40,0xFC92,0x0000, 0xFB40,0xF2C0,0x0000, 0xFB40,0xF099,0x0000,
0xFB41,0x8B58,0x0000, 0xFB40,0xCEC0,0x0000, 0xFB41,0x8336,0x0000,
0xFB40,0xD23A,0x0000 };

uint16 page0FAdata[]= { /* FA00 (3 weights per char) */
0xFB40,0xD207,0x0000, 0xFB40,0xDEA6,0x0000, 0xFB40,0xE2D3,0x0000,
0xFB40,0xFCD6,0x0000, 0xFB40,0xDB85,0x0000, 0xFB40,0xED1E,0x0000,
0xFB40,0xE6B4,0x0000, 0xFB41,0x8F3B,0x0000, 0xFB41,0x884C,0x0000,
0xFB41,0x964D,0x0000, 0xFB41,0x898B,0x0000, 0xFB40,0xDED3,0x0000,
0xFB40,0xD140,0x0000, 0xFB40,0xD5C0,0x0000, 0xFB41,0xFA0E,0x0000,
0xFB41,0xFA0F,0x0000, 0xFB40,0xD85A,0x0000, 0xFB41,0xFA11,0x0000,
0xFB40,0xE674,0x0000, 0xFB41,0xFA13,0x0000, 0xFB41,0xFA14,0x0000,
0xFB40,0xD1DE,0x0000, 0xFB40,0xF32A,0x0000, 0xFB40,0xF6CA,0x0000,
0xFB40,0xF93C,0x0000, 0xFB40,0xF95E,0x0000, 0xFB40,0xF965,0x0000,
0xFB40,0xF98F,0x0000, 0xFB41,0x9756,0x0000, 0xFB40,0xFCBE,0x0000,
0xFB40,0xFFBD,0x0000, 0xFB41,0xFA1F,0x0000, 0xFB41,0x8612,0x0000,
0xFB41,0xFA21,0x0000, 0xFB41,0x8AF8,0x0000, 0xFB41,0xFA23,0x0000,
0xFB41,0xFA24,0x0000, 0xFB41,0x9038,0x0000, 0xFB41,0x90FD,0x0000,
0xFB41,0xFA27,0x0000, 0xFB41,0xFA28,0x0000, 0xFB41,0xFA29,0x0000,
0xFB41,0x98EF,0x0000, 0xFB41,0x98FC,0x0000, 0xFB41,0x9928,0x0000,
0xFB41,0x9DB4,0x0000, 0xFBC1,0xFA2E,0x0000, 0xFBC1,0xFA2F,0x0000,
0xFB40,0xCFAE,0x0000, 0xFB40,0xD0E7,0x0000, 0xFB40,0xD14D,0x0000,
0xFB40,0xD2C9,0x0000, 0xFB40,0xD2E4,0x0000, 0xFB40,0xD351,0x0000,
0xFB40,0xD59D,0x0000, 0xFB40,0xD606,0x0000, 0xFB40,0xD668,0x0000,
0xFB40,0xD840,0x0000, 0xFB40,0xD8A8,0x0000, 0xFB40,0xDC64,0x0000,
0xFB40,0xDC6E,0x0000, 0xFB40,0xE094,0x0000, 0xFB40,0xE168,0x0000,
0xFB40,0xE18E,0x0000, 0xFB40,0xE1F2,0x0000, 0xFB40,0xE54F,0x0000,
0xFB40,0xE5E2,0x0000, 0xFB40,0xE691,0x0000, 0xFB40,0xE885,0x0000,
0xFB40,0xED77,0x0000, 0xFB40,0xEE1A,0x0000, 0xFB40,0xEF22,0x0000,
0xFB40,0xF16E,0x0000, 0xFB40,0xF22B,0x0000, 0xFB40,0xF422,0x0000,
0xFB40,0xF891,0x0000, 0xFB40,0xF93E,0x0000, 0xFB40,0xF949,0x0000,
0xFB40,0xF948,0x0000, 0xFB40,0xF950,0x0000, 0xFB40,0xF956,0x0000,
0xFB40,0xF95D,0x0000, 0xFB40,0xF98D,0x0000, 0xFB40,0xF98E,0x0000,
0xFB40,0xFA40,0x0000, 0xFB40,0xFA81,0x0000, 0xFB40,0xFBC0,0x0000,
0xFB40,0xFDF4,0x0000, 0xFB40,0xFE09,0x0000, 0xFB40,0xFE41,0x0000,
0xFB40,0xFF72,0x0000, 0xFB41,0x8005,0x0000, 0xFB41,0x81ED,0x0000,
0xFB41,0x8279,0x0000, 0xFB41,0x8279,0x0000, 0xFB41,0x8457,0x0000,
0xFB41,0x8910,0x0000, 0xFB41,0x8996,0x0000, 0xFB41,0x8B01,0x0000,
0xFB41,0x8B39,0x0000, 0xFB41,0x8CD3,0x0000, 0xFB41,0x8D08,0x0000,
0xFB41,0x8FB6,0x0000, 0xFB41,0x9038,0x0000, 0xFB41,0x96E3,0x0000,
0xFB41,0x97FF,0x0000, 0xFB41,0x983B,0x0000, 0xFBC1,0xFA6B,0x0000,
0xFBC1,0xFA6C,0x0000, 0xFBC1,0xFA6D,0x0000, 0xFBC1,0xFA6E,0x0000,
0xFBC1,0xFA6F,0x0000, 0xFBC1,0xFA70,0x0000, 0xFBC1,0xFA71,0x0000,
0xFBC1,0xFA72,0x0000, 0xFBC1,0xFA73,0x0000, 0xFBC1,0xFA74,0x0000,
0xFBC1,0xFA75,0x0000, 0xFBC1,0xFA76,0x0000, 0xFBC1,0xFA77,0x0000,
0xFBC1,0xFA78,0x0000, 0xFBC1,0xFA79,0x0000, 0xFBC1,0xFA7A,0x0000,
0xFBC1,0xFA7B,0x0000, 0xFBC1,0xFA7C,0x0000, 0xFBC1,0xFA7D,0x0000,
0xFBC1,0xFA7E,0x0000, 0xFBC1,0xFA7F,0x0000, 0xFBC1,0xFA80,0x0000,
0xFBC1,0xFA81,0x0000, 0xFBC1,0xFA82,0x0000, 0xFBC1,0xFA83,0x0000,
0xFBC1,0xFA84,0x0000, 0xFBC1,0xFA85,0x0000, 0xFBC1,0xFA86,0x0000,
0xFBC1,0xFA87,0x0000, 0xFBC1,0xFA88,0x0000, 0xFBC1,0xFA89,0x0000,
0xFBC1,0xFA8A,0x0000, 0xFBC1,0xFA8B,0x0000, 0xFBC1,0xFA8C,0x0000,
0xFBC1,0xFA8D,0x0000, 0xFBC1,0xFA8E,0x0000, 0xFBC1,0xFA8F,0x0000,
0xFBC1,0xFA90,0x0000, 0xFBC1,0xFA91,0x0000, 0xFBC1,0xFA92,0x0000,
0xFBC1,0xFA93,0x0000, 0xFBC1,0xFA94,0x0000, 0xFBC1,0xFA95,0x0000,
0xFBC1,0xFA96,0x0000, 0xFBC1,0xFA97,0x0000, 0xFBC1,0xFA98,0x0000,
0xFBC1,0xFA99,0x0000, 0xFBC1,0xFA9A,0x0000, 0xFBC1,0xFA9B,0x0000,
0xFBC1,0xFA9C,0x0000, 0xFBC1,0xFA9D,0x0000, 0xFBC1,0xFA9E,0x0000,
0xFBC1,0xFA9F,0x0000, 0xFBC1,0xFAA0,0x0000, 0xFBC1,0xFAA1,0x0000,
0xFBC1,0xFAA2,0x0000, 0xFBC1,0xFAA3,0x0000, 0xFBC1,0xFAA4,0x0000,
0xFBC1,0xFAA5,0x0000, 0xFBC1,0xFAA6,0x0000, 0xFBC1,0xFAA7,0x0000,
0xFBC1,0xFAA8,0x0000, 0xFBC1,0xFAA9,0x0000, 0xFBC1,0xFAAA,0x0000,
0xFBC1,0xFAAB,0x0000, 0xFBC1,0xFAAC,0x0000, 0xFBC1,0xFAAD,0x0000,
0xFBC1,0xFAAE,0x0000, 0xFBC1,0xFAAF,0x0000, 0xFBC1,0xFAB0,0x0000,
0xFBC1,0xFAB1,0x0000, 0xFBC1,0xFAB2,0x0000, 0xFBC1,0xFAB3,0x0000,
0xFBC1,0xFAB4,0x0000, 0xFBC1,0xFAB5,0x0000, 0xFBC1,0xFAB6,0x0000,
0xFBC1,0xFAB7,0x0000, 0xFBC1,0xFAB8,0x0000, 0xFBC1,0xFAB9,0x0000,
0xFBC1,0xFABA,0x0000, 0xFBC1,0xFABB,0x0000, 0xFBC1,0xFABC,0x0000,
0xFBC1,0xFABD,0x0000, 0xFBC1,0xFABE,0x0000, 0xFBC1,0xFABF,0x0000,
0xFBC1,0xFAC0,0x0000, 0xFBC1,0xFAC1,0x0000, 0xFBC1,0xFAC2,0x0000,
0xFBC1,0xFAC3,0x0000, 0xFBC1,0xFAC4,0x0000, 0xFBC1,0xFAC5,0x0000,
0xFBC1,0xFAC6,0x0000, 0xFBC1,0xFAC7,0x0000, 0xFBC1,0xFAC8,0x0000,
0xFBC1,0xFAC9,0x0000, 0xFBC1,0xFACA,0x0000, 0xFBC1,0xFACB,0x0000,
0xFBC1,0xFACC,0x0000, 0xFBC1,0xFACD,0x0000, 0xFBC1,0xFACE,0x0000,
0xFBC1,0xFACF,0x0000, 0xFBC1,0xFAD0,0x0000, 0xFBC1,0xFAD1,0x0000,
0xFBC1,0xFAD2,0x0000, 0xFBC1,0xFAD3,0x0000, 0xFBC1,0xFAD4,0x0000,
0xFBC1,0xFAD5,0x0000, 0xFBC1,0xFAD6,0x0000, 0xFBC1,0xFAD7,0x0000,
0xFBC1,0xFAD8,0x0000, 0xFBC1,0xFAD9,0x0000, 0xFBC1,0xFADA,0x0000,
0xFBC1,0xFADB,0x0000, 0xFBC1,0xFADC,0x0000, 0xFBC1,0xFADD,0x0000,
0xFBC1,0xFADE,0x0000, 0xFBC1,0xFADF,0x0000, 0xFBC1,0xFAE0,0x0000,
0xFBC1,0xFAE1,0x0000, 0xFBC1,0xFAE2,0x0000, 0xFBC1,0xFAE3,0x0000,
0xFBC1,0xFAE4,0x0000, 0xFBC1,0xFAE5,0x0000, 0xFBC1,0xFAE6,0x0000,
0xFBC1,0xFAE7,0x0000, 0xFBC1,0xFAE8,0x0000, 0xFBC1,0xFAE9,0x0000,
0xFBC1,0xFAEA,0x0000, 0xFBC1,0xFAEB,0x0000, 0xFBC1,0xFAEC,0x0000,
0xFBC1,0xFAED,0x0000, 0xFBC1,0xFAEE,0x0000, 0xFBC1,0xFAEF,0x0000,
0xFBC1,0xFAF0,0x0000, 0xFBC1,0xFAF1,0x0000, 0xFBC1,0xFAF2,0x0000,
0xFBC1,0xFAF3,0x0000, 0xFBC1,0xFAF4,0x0000, 0xFBC1,0xFAF5,0x0000,
0xFBC1,0xFAF6,0x0000, 0xFBC1,0xFAF7,0x0000, 0xFBC1,0xFAF8,0x0000,
0xFBC1,0xFAF9,0x0000, 0xFBC1,0xFAFA,0x0000, 0xFBC1,0xFAFB,0x0000,
0xFBC1,0xFAFC,0x0000, 0xFBC1,0xFAFD,0x0000, 0xFBC1,0xFAFE,0x0000,
0xFBC1,0xFAFF,0x0000 };

uint16 page0FBdata[]= { /* FB00 (4 weights per char) */
0x0EB9,0x0EB9,0x0000,0x0000, 0x0EB9,0x0EFB,0x0000,0x0000,
0x0EB9,0x0F2E,0x0000,0x0000, 0x0EB9,0x0EB9,0x0EFB,0x0000,
0x0EB9,0x0EB9,0x0F2E,0x0000, 0x0FEA,0x1002,0x0000,0x0000,
0x0FEA,0x1002,0x0000,0x0000, 0xFBC1,0xFB07,0x0000,0x0000,
0xFBC1,0xFB08,0x0000,0x0000, 0xFBC1,0xFB09,0x0000,0x0000,
0xFBC1,0xFB0A,0x0000,0x0000, 0xFBC1,0xFB0B,0x0000,0x0000,
0xFBC1,0xFB0C,0x0000,0x0000, 0xFBC1,0xFB0D,0x0000,0x0000,
0xFBC1,0xFB0E,0x0000,0x0000, 0xFBC1,0xFB0F,0x0000,0x0000,
0xFBC1,0xFB10,0x0000,0x0000, 0xFBC1,0xFB11,0x0000,0x0000,
0xFBC1,0xFB12,0x0000,0x0000, 0x131D,0x131F,0x0000,0x0000,
0x131D,0x130E,0x0000,0x0000, 0x131D,0x1314,0x0000,0x0000,
0x1327,0x131F,0x0000,0x0000, 0x131D,0x1316,0x0000,0x0000,
0xFBC1,0xFB18,0x0000,0x0000, 0xFBC1,0xFB19,0x0000,0x0000,
0xFBC1,0xFB1A,0x0000,0x0000, 0xFBC1,0xFB1B,0x0000,0x0000,
0xFBC1,0xFB1C,0x0000,0x0000, 0x133A,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x133A,0x133A,0x0000,0x0000,
0x1340,0x0000,0x0000,0x0000, 0x1331,0x0000,0x0000,0x0000,
0x1334,0x0000,0x0000,0x0000, 0x1335,0x0000,0x0000,0x0000,
0x133B,0x0000,0x0000,0x0000, 0x133C,0x0000,0x0000,0x0000,
0x133D,0x0000,0x0000,0x0000, 0x1344,0x0000,0x0000,0x0000,
0x1346,0x0000,0x0000,0x0000, 0x0428,0x0000,0x0000,0x0000,
0x1345,0x0000,0x0000,0x0000, 0x1345,0x0000,0x0000,0x0000,
0x1345,0x0000,0x0000,0x0000, 0x1345,0x0000,0x0000,0x0000,
0x1331,0x0000,0x0000,0x0000, 0x1331,0x0000,0x0000,0x0000,
0x1331,0x0000,0x0000,0x0000, 0x1332,0x0000,0x0000,0x0000,
0x1333,0x0000,0x0000,0x0000, 0x1334,0x0000,0x0000,0x0000,
0x1335,0x0000,0x0000,0x0000, 0x1336,0x0000,0x0000,0x0000,
0x1337,0x0000,0x0000,0x0000, 0xFBC1,0xFB37,0x0000,0x0000,
0x1339,0x0000,0x0000,0x0000, 0x133A,0x0000,0x0000,0x0000,
0x133B,0x0000,0x0000,0x0000, 0x133B,0x0000,0x0000,0x0000,
0x133C,0x0000,0x0000,0x0000, 0xFBC1,0xFB3D,0x0000,0x0000,
0x133D,0x0000,0x0000,0x0000, 0xFBC1,0xFB3F,0x0000,0x0000,
0x133E,0x0000,0x0000,0x0000, 0x133F,0x0000,0x0000,0x0000,
0xFBC1,0xFB42,0x0000,0x0000, 0x1341,0x0000,0x0000,0x0000,
0x1341,0x0000,0x0000,0x0000, 0xFBC1,0xFB45,0x0000,0x0000,
0x1342,0x0000,0x0000,0x0000, 0x1343,0x0000,0x0000,0x0000,
0x1344,0x0000,0x0000,0x0000, 0x1345,0x0000,0x0000,0x0000,
0x1346,0x0000,0x0000,0x0000, 0x1336,0x0000,0x0000,0x0000,
0x1332,0x0000,0x0000,0x0000, 0x133B,0x0000,0x0000,0x0000,
0x1341,0x0000,0x0000,0x0000, 0x1331,0x133C,0x0000,0x0000,
0x134B,0x0000,0x0000,0x0000, 0x134B,0x0000,0x0000,0x0000,
0x1353,0x0000,0x0000,0x0000, 0x1353,0x0000,0x0000,0x0000,
0x1353,0x0000,0x0000,0x0000, 0x1353,0x0000,0x0000,0x0000,
0x1354,0x0000,0x0000,0x0000, 0x1354,0x0000,0x0000,0x0000,
0x1354,0x0000,0x0000,0x0000, 0x1354,0x0000,0x0000,0x0000,
0x1355,0x0000,0x0000,0x0000, 0x1355,0x0000,0x0000,0x0000,
0x1355,0x0000,0x0000,0x0000, 0x1355,0x0000,0x0000,0x0000,
0x135A,0x0000,0x0000,0x0000, 0x135A,0x0000,0x0000,0x0000,
0x135A,0x0000,0x0000,0x0000, 0x135A,0x0000,0x0000,0x0000,
0x135D,0x0000,0x0000,0x0000, 0x135D,0x0000,0x0000,0x0000,
0x135D,0x0000,0x0000,0x0000, 0x135D,0x0000,0x0000,0x0000,
0x1359,0x0000,0x0000,0x0000, 0x1359,0x0000,0x0000,0x0000,
0x1359,0x0000,0x0000,0x0000, 0x1359,0x0000,0x0000,0x0000,
0x1397,0x0000,0x0000,0x0000, 0x1397,0x0000,0x0000,0x0000,
0x1397,0x0000,0x0000,0x0000, 0x1397,0x0000,0x0000,0x0000,
0x1399,0x0000,0x0000,0x0000, 0x1399,0x0000,0x0000,0x0000,
0x1399,0x0000,0x0000,0x0000, 0x1399,0x0000,0x0000,0x0000,
0x1360,0x0000,0x0000,0x0000, 0x1360,0x0000,0x0000,0x0000,
0x1360,0x0000,0x0000,0x0000, 0x1360,0x0000,0x0000,0x0000,
0x135F,0x0000,0x0000,0x0000, 0x135F,0x0000,0x0000,0x0000,
0x135F,0x0000,0x0000,0x0000, 0x135F,0x0000,0x0000,0x0000,
0x1361,0x0000,0x0000,0x0000, 0x1361,0x0000,0x0000,0x0000,
0x1361,0x0000,0x0000,0x0000, 0x1361,0x0000,0x0000,0x0000,
0x1363,0x0000,0x0000,0x0000, 0x1363,0x0000,0x0000,0x0000,
0x1363,0x0000,0x0000,0x0000, 0x1363,0x0000,0x0000,0x0000,
0x1370,0x0000,0x0000,0x0000, 0x1370,0x0000,0x0000,0x0000,
0x136F,0x0000,0x0000,0x0000, 0x136F,0x0000,0x0000,0x0000,
0x1371,0x0000,0x0000,0x0000, 0x1371,0x0000,0x0000,0x0000,
0x136B,0x0000,0x0000,0x0000, 0x136B,0x0000,0x0000,0x0000,
0x137E,0x0000,0x0000,0x0000, 0x137E,0x0000,0x0000,0x0000,
0x1377,0x0000,0x0000,0x0000, 0x1377,0x0000,0x0000,0x0000,
0x139F,0x0000,0x0000,0x0000, 0x139F,0x0000,0x0000,0x0000,
0x139F,0x0000,0x0000,0x0000, 0x139F,0x0000,0x0000,0x0000,
0x13A5,0x0000,0x0000,0x0000, 0x13A5,0x0000,0x0000,0x0000,
0x13A5,0x0000,0x0000,0x0000, 0x13A5,0x0000,0x0000,0x0000,
0x13A9,0x0000,0x0000,0x0000, 0x13A9,0x0000,0x0000,0x0000,
0x13A9,0x0000,0x0000,0x0000, 0x13A9,0x0000,0x0000,0x0000,
0x13A7,0x0000,0x0000,0x0000, 0x13A7,0x0000,0x0000,0x0000,
0x13A7,0x0000,0x0000,0x0000, 0x13A7,0x0000,0x0000,0x0000,
0x13B2,0x0000,0x0000,0x0000, 0x13B2,0x0000,0x0000,0x0000,
0x13B3,0x0000,0x0000,0x0000, 0x13B3,0x0000,0x0000,0x0000,
0x13B3,0x0000,0x0000,0x0000, 0x13B3,0x0000,0x0000,0x0000,
0x13BC,0x0000,0x0000,0x0000, 0x13BC,0x0000,0x0000,0x0000,
0x13B9,0x0000,0x0000,0x0000, 0x13B9,0x0000,0x0000,0x0000,
0x13B9,0x0000,0x0000,0x0000, 0x13B9,0x0000,0x0000,0x0000,
0x13B8,0x0000,0x0000,0x0000, 0x13B8,0x0000,0x0000,0x0000,
0x13B8,0x0000,0x0000,0x0000, 0x13B8,0x0000,0x0000,0x0000,
0x13CE,0x0000,0x0000,0x0000, 0x13CE,0x0000,0x0000,0x0000,
0x13CE,0x0000,0x0000,0x0000, 0x13CE,0x0000,0x0000,0x0000,
0xFBC1,0xFBB2,0x0000,0x0000, 0xFBC1,0xFBB3,0x0000,0x0000,
0xFBC1,0xFBB4,0x0000,0x0000, 0xFBC1,0xFBB5,0x0000,0x0000,
0xFBC1,0xFBB6,0x0000,0x0000, 0xFBC1,0xFBB7,0x0000,0x0000,
0xFBC1,0xFBB8,0x0000,0x0000, 0xFBC1,0xFBB9,0x0000,0x0000,
0xFBC1,0xFBBA,0x0000,0x0000, 0xFBC1,0xFBBB,0x0000,0x0000,
0xFBC1,0xFBBC,0x0000,0x0000, 0xFBC1,0xFBBD,0x0000,0x0000,
0xFBC1,0xFBBE,0x0000,0x0000, 0xFBC1,0xFBBF,0x0000,0x0000,
0xFBC1,0xFBC0,0x0000,0x0000, 0xFBC1,0xFBC1,0x0000,0x0000,
0xFBC1,0xFBC2,0x0000,0x0000, 0xFBC1,0xFBC3,0x0000,0x0000,
0xFBC1,0xFBC4,0x0000,0x0000, 0xFBC1,0xFBC5,0x0000,0x0000,
0xFBC1,0xFBC6,0x0000,0x0000, 0xFBC1,0xFBC7,0x0000,0x0000,
0xFBC1,0xFBC8,0x0000,0x0000, 0xFBC1,0xFBC9,0x0000,0x0000,
0xFBC1,0xFBCA,0x0000,0x0000, 0xFBC1,0xFBCB,0x0000,0x0000,
0xFBC1,0xFBCC,0x0000,0x0000, 0xFBC1,0xFBCD,0x0000,0x0000,
0xFBC1,0xFBCE,0x0000,0x0000, 0xFBC1,0xFBCF,0x0000,0x0000,
0xFBC1,0xFBD0,0x0000,0x0000, 0xFBC1,0xFBD1,0x0000,0x0000,
0xFBC1,0xFBD2,0x0000,0x0000, 0x13A3,0x0000,0x0000,0x0000,
0x13A3,0x0000,0x0000,0x0000, 0x13A3,0x0000,0x0000,0x0000,
0x13A3,0x0000,0x0000,0x0000, 0x13C1,0x0000,0x0000,0x0000,
0x13C1,0x0000,0x0000,0x0000, 0x13C0,0x0000,0x0000,0x0000,
0x13C0,0x0000,0x0000,0x0000, 0x13C2,0x0000,0x0000,0x0000,
0x13C2,0x0000,0x0000,0x0000, 0x13C1,0x1347,0x0000,0x0000,
0x13C5,0x0000,0x0000,0x0000, 0x13C5,0x0000,0x0000,0x0000,
0x13BF,0x0000,0x0000,0x0000, 0x13BF,0x0000,0x0000,0x0000,
0x13C3,0x0000,0x0000,0x0000, 0x13C3,0x0000,0x0000,0x0000,
0x13CC,0x0000,0x0000,0x0000, 0x13CC,0x0000,0x0000,0x0000,
0x13CC,0x0000,0x0000,0x0000, 0x13CC,0x0000,0x0000,0x0000,
0x13C7,0x0000,0x0000,0x0000, 0x13C7,0x0000,0x0000,0x0000,
0x134F,0x1350,0x0000,0x0000, 0x134F,0x1350,0x0000,0x0000,
0x134F,0x13BC,0x0000,0x0000, 0x134F,0x13BC,0x0000,0x0000,
0x134F,0x13BD,0x0000,0x0000, 0x134F,0x13BD,0x0000,0x0000,
0x134F,0x13C1,0x0000,0x0000, 0x134F,0x13C1,0x0000,0x0000,
0x134F,0x13C0,0x0000,0x0000, 0x134F,0x13C0,0x0000,0x0000,
0x134F,0x13C2,0x0000,0x0000, 0x134F,0x13C2,0x0000,0x0000,
0x134F,0x13CC,0x0000,0x0000, 0x134F,0x13CC,0x0000,0x0000,
0x134F,0x13CC,0x0000,0x0000, 0x134F,0x13C7,0x0000,0x0000,
0x134F,0x13C7,0x0000,0x0000, 0x134F,0x13C7,0x0000,0x0000,
0x13C9,0x0000,0x0000,0x0000, 0x13C9,0x0000,0x0000,0x0000,
0x13C9,0x0000,0x0000,0x0000, 0x13C9,0x0000,0x0000,0x0000
};

uint16 page0FCdata[]= { /* FC00 (3 weights per char) */
0x134F,0x135E,0x0000, 0x134F,0x1364,0x0000, 0x134F,0x13B0,0x0000,
0x134F,0x13C7,0x0000, 0x134F,0x13C8,0x0000, 0x1352,0x135E,0x0000,
0x1352,0x1364,0x0000, 0x1352,0x1365,0x0000, 0x1352,0x13B0,0x0000,
0x1352,0x13C7,0x0000, 0x1352,0x13C8,0x0000, 0x1357,0x135E,0x0000,
0x1357,0x1364,0x0000, 0x1357,0x1365,0x0000, 0x1357,0x13B0,0x0000,
0x1357,0x13C7,0x0000, 0x1357,0x13C8,0x0000, 0x1358,0x135E,0x0000,
0x1358,0x13B0,0x0000, 0x1358,0x13C7,0x0000, 0x1358,0x13C8,0x0000,
0x135E,0x1364,0x0000, 0x135E,0x13B0,0x0000, 0x1364,0x135E,0x0000,
0x1364,0x13B0,0x0000, 0x1365,0x135E,0x0000, 0x1365,0x1364,0x0000,
0x1365,0x13B0,0x0000, 0x1381,0x135E,0x0000, 0x1381,0x1364,0x0000,
0x1381,0x1365,0x0000, 0x1381,0x13B0,0x0000, 0x1387,0x1364,0x0000,
0x1387,0x13B0,0x0000, 0x1388,0x135E,0x0000, 0x1388,0x1364,0x0000,
0x1388,0x1365,0x0000, 0x1388,0x13B0,0x0000, 0x138C,0x1364,0x0000,
0x138C,0x13B0,0x0000, 0x138D,0x13B0,0x0000, 0x138F,0x135E,0x0000,
0x138F,0x13B0,0x0000, 0x1390,0x135E,0x0000, 0x1390,0x13B0,0x0000,
0x1393,0x135E,0x0000, 0x1393,0x1364,0x0000, 0x1393,0x1365,0x0000,
0x1393,0x13B0,0x0000, 0x1393,0x13C7,0x0000, 0x1393,0x13C8,0x0000,
0x139B,0x1364,0x0000, 0x139B,0x13B0,0x0000, 0x139B,0x13C7,0x0000,
0x139B,0x13C8,0x0000, 0x139E,0x1350,0x0000, 0x139E,0x135E,0x0000,
0x139E,0x1364,0x0000, 0x139E,0x1365,0x0000, 0x139E,0x13AB,0x0000,
0x139E,0x13B0,0x0000, 0x139E,0x13C7,0x0000, 0x139E,0x13C8,0x0000,
0x13AB,0x135E,0x0000, 0x13AB,0x1364,0x0000, 0x13AB,0x1365,0x0000,
0x13AB,0x13B0,0x0000, 0x13AB,0x13C7,0x0000, 0x13AB,0x13C8,0x0000,
0x13B0,0x135E,0x0000, 0x13B0,0x1364,0x0000, 0x13B0,0x1365,0x0000,
0x13B0,0x13B0,0x0000, 0x13B0,0x13C7,0x0000, 0x13B0,0x13C8,0x0000,
0x13B1,0x135E,0x0000, 0x13B1,0x1364,0x0000, 0x13B1,0x1365,0x0000,
0x13B1,0x13B0,0x0000, 0x13B1,0x13C7,0x0000, 0x13B1,0x13C8,0x0000,
0x13B7,0x135E,0x0000, 0x13B7,0x13B0,0x0000, 0x13B7,0x13C7,0x0000,
0x13B7,0x13C8,0x0000, 0x13C8,0x135E,0x0000, 0x13C8,0x1364,0x0000,
0x13C8,0x1365,0x0000, 0x13C8,0x13B0,0x0000, 0x13C8,0x13C7,0x0000,
0x13C8,0x13C8,0x0000, 0x136A,0x0000,0x0000, 0x1375,0x0000,0x0000,
0x13C7,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x134F,0x1375,0x0000, 0x134F,0x1376,0x0000,
0x134F,0x13B0,0x0000, 0x134F,0x13B1,0x0000, 0x134F,0x13C7,0x0000,
0x134F,0x13C8,0x0000, 0x1352,0x1375,0x0000, 0x1352,0x1376,0x0000,
0x1352,0x13B0,0x0000, 0x1352,0x13B1,0x0000, 0x1352,0x13C7,0x0000,
0x1352,0x13C8,0x0000, 0x1357,0x1375,0x0000, 0x1357,0x1376,0x0000,
0x1357,0x13B0,0x0000, 0x1357,0x13B1,0x0000, 0x1357,0x13C7,0x0000,
0x1357,0x13C8,0x0000, 0x1358,0x1375,0x0000, 0x1358,0x1376,0x0000,
0x1358,0x13B0,0x0000, 0x1358,0x13B1,0x0000, 0x1358,0x13C7,0x0000,
0x1358,0x13C8,0x0000, 0x1393,0x13C7,0x0000, 0x1393,0x13C8,0x0000,
0x139B,0x13C7,0x0000, 0x139B,0x13C8,0x0000, 0x139E,0x1350,0x0000,
0x139E,0x13AB,0x0000, 0x139E,0x13B0,0x0000, 0x139E,0x13C7,0x0000,
0x139E,0x13C8,0x0000, 0x13AB,0x13B0,0x0000, 0x13AB,0x13C7,0x0000,
0x13AB,0x13C8,0x0000, 0x13B0,0x1350,0x0000, 0x13B0,0x13B0,0x0000,
0x13B1,0x1375,0x0000, 0x13B1,0x1376,0x0000, 0x13B1,0x13B0,0x0000,
0x13B1,0x13B1,0x0000, 0x13B1,0x13C7,0x0000, 0x13B1,0x13C8,0x0000,
0x13C7,0x0000,0x0000, 0x13C8,0x1375,0x0000, 0x13C8,0x1376,0x0000,
0x13C8,0x13B0,0x0000, 0x13C8,0x13B1,0x0000, 0x13C8,0x13C7,0x0000,
0x13C8,0x13C8,0x0000, 0x134F,0x135E,0x0000, 0x134F,0x1364,0x0000,
0x134F,0x1365,0x0000, 0x134F,0x13B0,0x0000, 0x134F,0x13B7,0x0000,
0x1352,0x135E,0x0000, 0x1352,0x1364,0x0000, 0x1352,0x1365,0x0000,
0x1352,0x13B0,0x0000, 0x1352,0x13B7,0x0000, 0x1357,0x135E,0x0000,
0x1357,0x1364,0x0000, 0x1357,0x1365,0x0000, 0x1357,0x13B0,0x0000,
0x1357,0x13B7,0x0000, 0x1358,0x13B0,0x0000, 0x135E,0x1364,0x0000,
0x135E,0x13B0,0x0000, 0x1364,0x135E,0x0000, 0x1364,0x13B0,0x0000,
0x1365,0x135E,0x0000, 0x1365,0x13B0,0x0000, 0x1381,0x135E,0x0000,
0x1381,0x1364,0x0000, 0x1381,0x1365,0x0000, 0x1381,0x13B0,0x0000,
0x1387,0x1364,0x0000, 0x1387,0x1365,0x0000, 0x1387,0x13B0,0x0000,
0x1388,0x135E,0x0000, 0x1388,0x1364,0x0000, 0x1388,0x1365,0x0000,
0x1388,0x13B0,0x0000, 0x138C,0x1364,0x0000, 0x138D,0x13B0,0x0000,
0x138F,0x135E,0x0000, 0x138F,0x13B0,0x0000, 0x1390,0x135E,0x0000,
0x1390,0x13B0,0x0000, 0x1393,0x135E,0x0000, 0x1393,0x1364,0x0000,
0x1393,0x1365,0x0000, 0x1393,0x13B0,0x0000, 0x139B,0x1364,0x0000,
0x139B,0x13B0,0x0000, 0x139E,0x135E,0x0000, 0x139E,0x1364,0x0000,
0x139E,0x1365,0x0000, 0x139E,0x13AB,0x0000, 0x139E,0x13B0,0x0000,
0x13AB,0x135E,0x0000, 0x13AB,0x1364,0x0000, 0x13AB,0x1365,0x0000,
0x13AB,0x13B0,0x0000, 0x13AB,0x13B7,0x0000, 0x13B0,0x135E,0x0000,
0x13B0,0x1364,0x0000, 0x13B0,0x1365,0x0000, 0x13B0,0x13B0,0x0000,
0x13B1,0x135E,0x0000, 0x13B1,0x1364,0x0000, 0x13B1,0x1365,0x0000,
0x13B1,0x13B0,0x0000, 0x13B1,0x13B7,0x0000, 0x13B7,0x135E,0x0000,
0x13B7,0x13B0,0x0000, 0x13B7,0x0000,0x0000, 0x13C8,0x135E,0x0000,
0x13C8,0x1364,0x0000, 0x13C8,0x1365,0x0000, 0x13C8,0x13B0,0x0000,
0x13C8,0x13B7,0x0000, 0x134F,0x13B0,0x0000, 0x134F,0x13B7,0x0000,
0x1352,0x13B0,0x0000, 0x1352,0x13B7,0x0000, 0x1357,0x13B0,0x0000,
0x1357,0x13B7,0x0000, 0x1358,0x13B0,0x0000, 0x1358,0x13B7,0x0000,
0x1381,0x13B0,0x0000, 0x1381,0x13B7,0x0000, 0x1382,0x13B0,0x0000,
0x1382,0x13B7,0x0000, 0x139E,0x13AB,0x0000, 0x139E,0x13B0,0x0000,
0x13AB,0x13B0,0x0000, 0x13B1,0x13B0,0x0000, 0x13B1,0x13B7,0x0000,
0x13C8,0x13B0,0x0000, 0x13C8,0x13B7,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x138C,0x13C7,0x0000,
0x138C,0x13C8,0x0000, 0x138F,0x13C7,0x0000, 0x138F,0x13C8,0x0000,
0x1390,0x13C7,0x0000, 0x1390,0x13C8,0x0000, 0x1381,0x13C7,0x0000,
0x1381,0x13C8,0x0000, 0x1382,0x13C7,0x0000, 0x1382,0x13C8,0x0000,
0x1364,0x13C7,0x0000 };

uint16 page0FDdata[]= { /* FD00 (9 weights per char) */
0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1365,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1365,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1390,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1390,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1364,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1365,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1365,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13B7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138D,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1350,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1350,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x02C0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x02C1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD40,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD41,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD42,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD43,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD44,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD45,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD46,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD47,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD48,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD49,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD4B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD4C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD4D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD4E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD4F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x1364,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x1364,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x1364,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x13B0,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x13B0,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1364,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1364,0x13B0,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x1364,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x135E,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x135E,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13B0,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x1364,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x1364,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1364,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1364,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B0,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B0,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x1364,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x13B0,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1390,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1390,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1390,0x13B0,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1393,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1393,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139B,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139B,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x1364,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x1364,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x135E,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x135E,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x1364,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x1364,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x135E,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x1365,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD90,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD91,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x135E,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B7,0x13B0,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B7,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x1364,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x1364,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x135E,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x13B0,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13C8,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13C8,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1352,0x1365,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x135E,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x1365,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x1365,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x13B0,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x1364,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13B0,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x1365,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13C8,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13C8,0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13C8,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139B,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139B,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x1364,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139E,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x135E,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x1365,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139E,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x135E,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1364,0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1393,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1352,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139E,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x1365,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDC8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDC9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDCA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDCB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDCC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDCD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDCE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDCF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDDA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDDB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDDC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDDD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDDE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDDF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDEA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDEB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDEC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDED,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDEE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDEF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13AB,0x13CE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139B,0x13AB,0x13CE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1350,0x13AB,0x13AB,0x13B7,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1350,0x139E,0x1352,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x1364,0x13B0,0x1369,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13AB,0x138F,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1375,0x1381,0x13BD,0x13AB,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x13AB,0x13C8,0x13B7,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13BD,0x1381,0x13AB,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13AB,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDFA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13AB,0x0209,0x135E,0x13AB,0x1350,0x13AB,0x13B7,0x0000,
0x1375,0x13C9,0x1350,0x13AB,0x0000,0x0000,0x0000,0x0000,0x0000,
0x034F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDFE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDFF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

uint16 page0FEdata[]= { /* FE00 (3 weights per char) */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC1,0xFE10,0x0000, 0xFBC1,0xFE11,0x0000,
0xFBC1,0xFE12,0x0000, 0xFBC1,0xFE13,0x0000, 0xFBC1,0xFE14,0x0000,
0xFBC1,0xFE15,0x0000, 0xFBC1,0xFE16,0x0000, 0xFBC1,0xFE17,0x0000,
0xFBC1,0xFE18,0x0000, 0xFBC1,0xFE19,0x0000, 0xFBC1,0xFE1A,0x0000,
0xFBC1,0xFE1B,0x0000, 0xFBC1,0xFE1C,0x0000, 0xFBC1,0xFE1D,0x0000,
0xFBC1,0xFE1E,0x0000, 0xFBC1,0xFE1F,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC1,0xFE24,0x0000, 0xFBC1,0xFE25,0x0000, 0xFBC1,0xFE26,0x0000,
0xFBC1,0xFE27,0x0000, 0xFBC1,0xFE28,0x0000, 0xFBC1,0xFE29,0x0000,
0xFBC1,0xFE2A,0x0000, 0xFBC1,0xFE2B,0x0000, 0xFBC1,0xFE2C,0x0000,
0xFBC1,0xFE2D,0x0000, 0xFBC1,0xFE2E,0x0000, 0xFBC1,0xFE2F,0x0000,
0x025D,0x025D,0x0000, 0x0228,0x0000,0x0000, 0x0227,0x0000,0x0000,
0x021B,0x0000,0x0000, 0x021B,0x0000,0x0000, 0x0288,0x0000,0x0000,
0x0289,0x0000,0x0000, 0x028C,0x0000,0x0000, 0x028D,0x0000,0x0000,
0x02B8,0x0000,0x0000, 0x02B9,0x0000,0x0000, 0x02B6,0x0000,0x0000,
0x02B7,0x0000,0x0000, 0x02B0,0x0000,0x0000, 0x02B1,0x0000,0x0000,
0x02AE,0x0000,0x0000, 0x02AF,0x0000,0x0000, 0x02B2,0x0000,0x0000,
0x02B3,0x0000,0x0000, 0x02B4,0x0000,0x0000, 0x02B5,0x0000,0x0000,
0x0238,0x0000,0x0000, 0x0239,0x0000,0x0000, 0x028A,0x0000,0x0000,
0x028B,0x0000,0x0000, 0x0211,0x0000,0x0000, 0x0211,0x0000,0x0000,
0x0211,0x0000,0x0000, 0x0211,0x0000,0x0000, 0x021B,0x0000,0x0000,
0x021B,0x0000,0x0000, 0x021B,0x0000,0x0000, 0x022F,0x0000,0x0000,
0x0237,0x0000,0x0000, 0x025D,0x0000,0x0000, 0xFBC1,0xFE53,0x0000,
0x023A,0x0000,0x0000, 0x023D,0x0000,0x0000, 0x0255,0x0000,0x0000,
0x0251,0x0000,0x0000, 0x0228,0x0000,0x0000, 0x0288,0x0000,0x0000,
0x0289,0x0000,0x0000, 0x028C,0x0000,0x0000, 0x028D,0x0000,0x0000,
0x02B8,0x0000,0x0000, 0x02B9,0x0000,0x0000, 0x02D2,0x0000,0x0000,
0x02CF,0x0000,0x0000, 0x02C8,0x0000,0x0000, 0x0428,0x0000,0x0000,
0x0221,0x0000,0x0000, 0x042C,0x0000,0x0000, 0x042E,0x0000,0x0000,
0x042D,0x0000,0x0000, 0xFBC1,0xFE67,0x0000, 0x02CE,0x0000,0x0000,
0x0E0F,0x0000,0x0000, 0x02D3,0x0000,0x0000, 0x02C7,0x0000,0x0000,
0xFBC1,0xFE6C,0x0000, 0xFBC1,0xFE6D,0x0000, 0xFBC1,0xFE6E,0x0000,
0xFBC1,0xFE6F,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC1,0xFE75,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x1347,0x0000,0x0000,
0x1348,0x0000,0x0000, 0x1348,0x0000,0x0000, 0x1349,0x0000,0x0000,
0x1349,0x0000,0x0000, 0x134C,0x0000,0x0000, 0x134C,0x0000,0x0000,
0x134D,0x0000,0x0000, 0x134D,0x0000,0x0000, 0x134F,0x0000,0x0000,
0x134F,0x0000,0x0000, 0x134F,0x0000,0x0000, 0x134F,0x0000,0x0000,
0x1350,0x0000,0x0000, 0x1350,0x0000,0x0000, 0x1352,0x0000,0x0000,
0x1352,0x0000,0x0000, 0x1352,0x0000,0x0000, 0x1352,0x0000,0x0000,
0x1356,0x0000,0x0000, 0x1356,0x0000,0x0000, 0x1357,0x0000,0x0000,
0x1357,0x0000,0x0000, 0x1357,0x0000,0x0000, 0x1357,0x0000,0x0000,
0x1358,0x0000,0x0000, 0x1358,0x0000,0x0000, 0x1358,0x0000,0x0000,
0x1358,0x0000,0x0000, 0x135E,0x0000,0x0000, 0x135E,0x0000,0x0000,
0x135E,0x0000,0x0000, 0x135E,0x0000,0x0000, 0x1364,0x0000,0x0000,
0x1364,0x0000,0x0000, 0x1364,0x0000,0x0000, 0x1364,0x0000,0x0000,
0x1365,0x0000,0x0000, 0x1365,0x0000,0x0000, 0x1365,0x0000,0x0000,
0x1365,0x0000,0x0000, 0x1369,0x0000,0x0000, 0x1369,0x0000,0x0000,
0x136A,0x0000,0x0000, 0x136A,0x0000,0x0000, 0x1375,0x0000,0x0000,
0x1375,0x0000,0x0000, 0x1376,0x0000,0x0000, 0x1376,0x0000,0x0000,
0x1381,0x0000,0x0000, 0x1381,0x0000,0x0000, 0x1381,0x0000,0x0000,
0x1381,0x0000,0x0000, 0x1382,0x0000,0x0000, 0x1382,0x0000,0x0000,
0x1382,0x0000,0x0000, 0x1382,0x0000,0x0000, 0x1387,0x0000,0x0000,
0x1387,0x0000,0x0000, 0x1387,0x0000,0x0000, 0x1387,0x0000,0x0000,
0x1388,0x0000,0x0000, 0x1388,0x0000,0x0000, 0x1388,0x0000,0x0000,
0x1388,0x0000,0x0000, 0x138C,0x0000,0x0000, 0x138C,0x0000,0x0000,
0x138C,0x0000,0x0000, 0x138C,0x0000,0x0000, 0x138D,0x0000,0x0000,
0x138D,0x0000,0x0000, 0x138D,0x0000,0x0000, 0x138D,0x0000,0x0000,
0x138F,0x0000,0x0000, 0x138F,0x0000,0x0000, 0x138F,0x0000,0x0000,
0x138F,0x0000,0x0000, 0x1390,0x0000,0x0000, 0x1390,0x0000,0x0000,
0x1390,0x0000,0x0000, 0x1390,0x0000,0x0000, 0x1393,0x0000,0x0000,
0x1393,0x0000,0x0000, 0x1393,0x0000,0x0000, 0x1393,0x0000,0x0000,
0x139B,0x0000,0x0000, 0x139B,0x0000,0x0000, 0x139B,0x0000,0x0000,
0x139B,0x0000,0x0000, 0x139E,0x0000,0x0000, 0x139E,0x0000,0x0000,
0x139E,0x0000,0x0000, 0x139E,0x0000,0x0000, 0x13AB,0x0000,0x0000,
0x13AB,0x0000,0x0000, 0x13AB,0x0000,0x0000, 0x13AB,0x0000,0x0000,
0x13B0,0x0000,0x0000, 0x13B0,0x0000,0x0000, 0x13B0,0x0000,0x0000,
0x13B0,0x0000,0x0000, 0x13B1,0x0000,0x0000, 0x13B1,0x0000,0x0000,
0x13B1,0x0000,0x0000, 0x13B1,0x0000,0x0000, 0x13B7,0x0000,0x0000,
0x13B7,0x0000,0x0000, 0x13B7,0x0000,0x0000, 0x13B7,0x0000,0x0000,
0x13BD,0x0000,0x0000, 0x13BD,0x0000,0x0000, 0x13C7,0x0000,0x0000,
0x13C7,0x0000,0x0000, 0x13C8,0x0000,0x0000, 0x13C8,0x0000,0x0000,
0x13C8,0x0000,0x0000, 0x13C8,0x0000,0x0000, 0x13AB,0x1348,0x0000,
0x13AB,0x1348,0x0000, 0x13AB,0x1349,0x0000, 0x13AB,0x1349,0x0000,
0x13AB,0x134D,0x0000, 0x13AB,0x134D,0x0000, 0x13AB,0x1350,0x0000,
0x13AB,0x1350,0x0000, 0xFBC1,0xFEFD,0x0000, 0xFBC1,0xFEFE,0x0000,
0x0000,0x0000,0x0000 };

uint16 page0FFdata[]= { /* FF00 (3 weights per char) */
0xFBC1,0xFF00,0x0000, 0x0251,0x0000,0x0000, 0x027E,0x0000,0x0000,
0x02D2,0x0000,0x0000, 0x0E0F,0x0000,0x0000, 0x02D3,0x0000,0x0000,
0x02CF,0x0000,0x0000, 0x0277,0x0000,0x0000, 0x0288,0x0000,0x0000,
0x0289,0x0000,0x0000, 0x02C8,0x0000,0x0000, 0x0428,0x0000,0x0000,
0x022F,0x0000,0x0000, 0x0221,0x0000,0x0000, 0x025D,0x0000,0x0000,
0x02CC,0x0000,0x0000, 0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000,
0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000,
0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000,
0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000, 0x023D,0x0000,0x0000,
0x023A,0x0000,0x0000, 0x042C,0x0000,0x0000, 0x042D,0x0000,0x0000,
0x042E,0x0000,0x0000, 0x0255,0x0000,0x0000, 0x02C7,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E4A,0x0000,0x0000, 0x0E60,0x0000,0x0000,
0x0E6D,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0EB9,0x0000,0x0000,
0x0EC1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0F10,0x0000,0x0000, 0x0F21,0x0000,0x0000, 0x0F2E,0x0000,0x0000,
0x0F5B,0x0000,0x0000, 0x0F64,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0FA7,0x0000,0x0000, 0x0FB4,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x1002,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x1044,0x0000,0x0000, 0x1051,0x0000,0x0000, 0x105A,0x0000,0x0000,
0x105E,0x0000,0x0000, 0x106A,0x0000,0x0000, 0x028A,0x0000,0x0000,
0x02CE,0x0000,0x0000, 0x028B,0x0000,0x0000, 0x020F,0x0000,0x0000,
0x021B,0x0000,0x0000, 0x020C,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E4A,0x0000,0x0000, 0x0E60,0x0000,0x0000, 0x0E6D,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0EB9,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0EE1,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0F10,0x0000,0x0000,
0x0F21,0x0000,0x0000, 0x0F2E,0x0000,0x0000, 0x0F5B,0x0000,0x0000,
0x0F64,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0FA7,0x0000,0x0000,
0x0FB4,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x0FEA,0x0000,0x0000,
0x1002,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x1044,0x0000,0x0000,
0x1051,0x0000,0x0000, 0x105A,0x0000,0x0000, 0x105E,0x0000,0x0000,
0x106A,0x0000,0x0000, 0x028C,0x0000,0x0000, 0x0430,0x0000,0x0000,
0x028D,0x0000,0x0000, 0x0433,0x0000,0x0000, 0x029A,0x0000,0x0000,
0x029B,0x0000,0x0000, 0x0266,0x0000,0x0000, 0x02B2,0x0000,0x0000,
0x02B3,0x0000,0x0000, 0x0237,0x0000,0x0000, 0x022E,0x0000,0x0000,
0x1E80,0x0000,0x0000, 0x1E52,0x0000,0x0000, 0x1E53,0x0000,0x0000,
0x1E54,0x0000,0x0000, 0x1E55,0x0000,0x0000, 0x1E56,0x0000,0x0000,
0x1E75,0x0000,0x0000, 0x1E76,0x0000,0x0000, 0x1E77,0x0000,0x0000,
0x1E63,0x0000,0x0000, 0x0E0B,0x0000,0x0000, 0x1E52,0x0000,0x0000,
0x1E53,0x0000,0x0000, 0x1E54,0x0000,0x0000, 0x1E55,0x0000,0x0000,
0x1E56,0x0000,0x0000, 0x1E57,0x0000,0x0000, 0x1E58,0x0000,0x0000,
0x1E59,0x0000,0x0000, 0x1E5A,0x0000,0x0000, 0x1E5B,0x0000,0x0000,
0x1E5C,0x0000,0x0000, 0x1E5D,0x0000,0x0000, 0x1E5E,0x0000,0x0000,
0x1E5F,0x0000,0x0000, 0x1E60,0x0000,0x0000, 0x1E61,0x0000,0x0000,
0x1E62,0x0000,0x0000, 0x1E63,0x0000,0x0000, 0x1E64,0x0000,0x0000,
0x1E65,0x0000,0x0000, 0x1E66,0x0000,0x0000, 0x1E67,0x0000,0x0000,
0x1E68,0x0000,0x0000, 0x1E69,0x0000,0x0000, 0x1E6A,0x0000,0x0000,
0x1E6B,0x0000,0x0000, 0x1E6C,0x0000,0x0000, 0x1E6D,0x0000,0x0000,
0x1E6E,0x0000,0x0000, 0x1E6F,0x0000,0x0000, 0x1E70,0x0000,0x0000,
0x1E71,0x0000,0x0000, 0x1E72,0x0000,0x0000, 0x1E73,0x0000,0x0000,
0x1E74,0x0000,0x0000, 0x1E75,0x0000,0x0000, 0x1E76,0x0000,0x0000,
0x1E77,0x0000,0x0000, 0x1E78,0x0000,0x0000, 0x1E79,0x0000,0x0000,
0x1E7A,0x0000,0x0000, 0x1E7B,0x0000,0x0000, 0x1E7C,0x0000,0x0000,
0x1E7D,0x0000,0x0000, 0x1E81,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x1DBD,0x0000,0x0000, 0x1D62,0x0000,0x0000,
0x1D63,0x0000,0x0000, 0x1E02,0x0000,0x0000, 0x1D64,0x0000,0x0000,
0x1E04,0x0000,0x0000, 0x1E05,0x0000,0x0000, 0x1D65,0x0000,0x0000,
0x1D66,0x0000,0x0000, 0x1D67,0x0000,0x0000, 0x1E08,0x0000,0x0000,
0x1E09,0x0000,0x0000, 0x1E0A,0x0000,0x0000, 0x1E0B,0x0000,0x0000,
0x1E0C,0x0000,0x0000, 0x1E0D,0x0000,0x0000, 0x1D7C,0x0000,0x0000,
0x1D68,0x0000,0x0000, 0x1D69,0x0000,0x0000, 0x1D6A,0x0000,0x0000,
0x1D83,0x0000,0x0000, 0x1D6B,0x0000,0x0000, 0x1D6C,0x0000,0x0000,
0x1D6D,0x0000,0x0000, 0x1D6E,0x0000,0x0000, 0x1D6F,0x0000,0x0000,
0x1D70,0x0000,0x0000, 0x1D71,0x0000,0x0000, 0x1D72,0x0000,0x0000,
0x1D73,0x0000,0x0000, 0x1D74,0x0000,0x0000, 0xFBC1,0xFFBF,0x0000,
0xFBC1,0xFFC0,0x0000, 0xFBC1,0xFFC1,0x0000, 0x1DBE,0x0000,0x0000,
0x1DBF,0x0000,0x0000, 0x1DC0,0x0000,0x0000, 0x1DC1,0x0000,0x0000,
0x1DC2,0x0000,0x0000, 0x1DC3,0x0000,0x0000, 0xFBC1,0xFFC8,0x0000,
0xFBC1,0xFFC9,0x0000, 0x1DC4,0x0000,0x0000, 0x1DC5,0x0000,0x0000,
0x1DC6,0x0000,0x0000, 0x1DC7,0x0000,0x0000, 0x1DC8,0x0000,0x0000,
0x1DC9,0x0000,0x0000, 0xFBC1,0xFFD0,0x0000, 0xFBC1,0xFFD1,0x0000,
0x1DCA,0x0000,0x0000, 0x1DCB,0x0000,0x0000, 0x1DCC,0x0000,0x0000,
0x1DCD,0x0000,0x0000, 0x1DCE,0x0000,0x0000, 0x1DCF,0x0000,0x0000,
0xFBC1,0xFFD8,0x0000, 0xFBC1,0xFFD9,0x0000, 0x1DD0,0x0000,0x0000,
0x1DD1,0x0000,0x0000, 0x1DD2,0x0000,0x0000, 0xFBC1,0xFFDD,0x0000,
0xFBC1,0xFFDE,0x0000, 0xFBC1,0xFFDF,0x0000, 0x0E0E,0x0000,0x0000,
0x0E10,0x0000,0x0000, 0x042F,0x0000,0x0000, 0x0210,0x0000,0x0000,
0x0431,0x0000,0x0000, 0x0E11,0x0000,0x0000, 0x0E20,0x0000,0x0000,
0xFBC1,0xFFE7,0x0000, 0x05FE,0x0000,0x0000, 0x03AE,0x0000,0x0000,
0x03B0,0x0000,0x0000, 0x03AF,0x0000,0x0000, 0x03B1,0x0000,0x0000,
0x069C,0x0000,0x0000, 0x06C7,0x0000,0x0000, 0xFBC1,0xFFEF,0x0000,
0xFBC1,0xFFF0,0x0000, 0xFBC1,0xFFF1,0x0000, 0xFBC1,0xFFF2,0x0000,
0xFBC1,0xFFF3,0x0000, 0xFBC1,0xFFF4,0x0000, 0xFBC1,0xFFF5,0x0000,
0xFBC1,0xFFF6,0x0000, 0xFBC1,0xFFF7,0x0000, 0xFBC1,0xFFF8,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0DC5,0x0000,0x0000, 0x0DC6,0x0000,0x0000, 0xFBC1,0xFFFE,0x0000,
0xFBC1,0xFFFF,0x0000 };

uchar uca_length[256]={
4,3,3,4,3,3,3,3,0,3,3,3,3,3,3,3,
3,3,3,3,3,2,3,3,3,3,0,0,0,3,3,3,
5,5,4,3,5,2,3,3,2,2,5,3,0,0,3,3,
3,3,8,9,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,2,2,3,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,3,3,4,3,9,3,3
};
uint16 *uca_weight[256]={
page000data,page001data,page002data,page003data,
page004data,page005data,page006data,page007data,
NULL       ,page009data,page00Adata,page00Bdata,
page00Cdata,page00Ddata,page00Edata,page00Fdata,
page010data,page011data,page012data,page013data,
page014data,page015data,page016data,page017data,
page018data,page019data,NULL       ,NULL       ,
NULL       ,page01Ddata,page01Edata,page01Fdata,
page020data,page021data,page022data,page023data,
page024data,page025data,page026data,page027data,
page028data,page029data,page02Adata,page02Bdata,
NULL       ,NULL       ,page02Edata,page02Fdata,
page030data,page031data,page032data,page033data,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,page04Ddata,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
page0A0data,page0A1data,page0A2data,page0A3data,
page0A4data,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,page0F9data,page0FAdata,page0FBdata,
page0FCdata,page0FDdata,page0FEdata,page0FFdata
};


MY_UCA_INFO my_uca_v400=
{
  {
    {
      0xFFFF,    /* maxchar           */
      uca_length,
      uca_weight,
      {          /* Contractions:     */
        0,       /*   nitems          */
        NULL,    /*   item            */
        NULL     /*   flags           */
      }
    },
  },

  /* Logical positions */
  0x0009,    /* first_non_ignorable       p != ignore                  */
  0xA48C,    /* last_non_ignorable        Not a CJK and not UNASSIGNED */

  0x0332,    /* first_primary_ignorable   p == 0                       */
  0x20EA,    /* last_primary_ignorable                                 */

  0x0000,    /* first_secondary_ignorable p,s == 0                     */
  0xFE73,    /* last_secondary_ignorable  p,s == 0                     */

  0x0000,    /* first_tertiary_ignorable  p,s,t == 0                   */
  0xFE73,    /* last_tertiary_ignorable   p,s,t == 0                   */

  0x0000,    /* first_trailing            */
  0x0000,    /* last_trailing             */

  0x0009,    /* first_variable            */
  0x2183,    /* last_variable             */
};

/******************************************************/

#define MY_UCA_CMASK  255
#define MY_UCA_PSHIFT 8


/* Created from allkeys.txt. Unicode version '5.2.0'. */

uint16 uca520_p000[]= { /* 0000 (4 weights per char) */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0000 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0002 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0004 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0006 */
0x0000,0x0000,0x0000,0x0000, 0x0201,0x0000,0x0000,0x0000, /* 0008 */
0x0202,0x0000,0x0000,0x0000, 0x0203,0x0000,0x0000,0x0000, /* 000A */
0x0204,0x0000,0x0000,0x0000, 0x0205,0x0000,0x0000,0x0000, /* 000C */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 000E */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0010 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0012 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0014 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0016 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0018 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 001A */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 001C */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 001E */
0x020A,0x0000,0x0000,0x0000, 0x026E,0x0000,0x0000,0x0000, /* 0020 */
0x02F5,0x0000,0x0000,0x0000, 0x0362,0x0000,0x0000,0x0000, /* 0022 */
0x11E1,0x0000,0x0000,0x0000, 0x0363,0x0000,0x0000,0x0000, /* 0024 */
0x035F,0x0000,0x0000,0x0000, 0x02EE,0x0000,0x0000,0x0000, /* 0026 */
0x02FF,0x0000,0x0000,0x0000, 0x0300,0x0000,0x0000,0x0000, /* 0028 */
0x0357,0x0000,0x0000,0x0000, 0x0550,0x0000,0x0000,0x0000, /* 002A */
0x0234,0x0000,0x0000,0x0000, 0x0223,0x0000,0x0000,0x0000, /* 002C */
0x0281,0x0000,0x0000,0x0000, 0x035C,0x0000,0x0000,0x0000, /* 002E */
0x1205,0x0000,0x0000,0x0000, 0x1206,0x0000,0x0000,0x0000, /* 0030 */
0x1207,0x0000,0x0000,0x0000, 0x1208,0x0000,0x0000,0x0000, /* 0032 */
0x1209,0x0000,0x0000,0x0000, 0x120A,0x0000,0x0000,0x0000, /* 0034 */
0x120B,0x0000,0x0000,0x0000, 0x120C,0x0000,0x0000,0x0000, /* 0036 */
0x120D,0x0000,0x0000,0x0000, 0x120E,0x0000,0x0000,0x0000, /* 0038 */
0x0247,0x0000,0x0000,0x0000, 0x0243,0x0000,0x0000,0x0000, /* 003A */
0x0554,0x0000,0x0000,0x0000, 0x0555,0x0000,0x0000,0x0000, /* 003C */
0x0556,0x0000,0x0000,0x0000, 0x0273,0x0000,0x0000,0x0000, /* 003E */
0x0356,0x0000,0x0000,0x0000, 0x120F,0x0000,0x0000,0x0000, /* 0040 */
0x1225,0x0000,0x0000,0x0000, 0x123D,0x0000,0x0000,0x0000, /* 0042 */
0x1250,0x0000,0x0000,0x0000, 0x126B,0x0000,0x0000,0x0000, /* 0044 */
0x12A3,0x0000,0x0000,0x0000, 0x12B0,0x0000,0x0000,0x0000, /* 0046 */
0x12D3,0x0000,0x0000,0x0000, 0x12EC,0x0000,0x0000,0x0000, /* 0048 */
0x1305,0x0000,0x0000,0x0000, 0x131E,0x0000,0x0000,0x0000, /* 004A */
0x1330,0x0000,0x0000,0x0000, 0x135F,0x0000,0x0000,0x0000, /* 004C */
0x136D,0x0000,0x0000,0x0000, 0x138E,0x0000,0x0000,0x0000, /* 004E */
0x13B3,0x0000,0x0000,0x0000, 0x13C8,0x0000,0x0000,0x0000, /* 0050 */
0x13DA,0x0000,0x0000,0x0000, 0x1410,0x0000,0x0000,0x0000, /* 0052 */
0x1433,0x0000,0x0000,0x0000, 0x1453,0x0000,0x0000,0x0000, /* 0054 */
0x147B,0x0000,0x0000,0x0000, 0x148D,0x0000,0x0000,0x0000, /* 0056 */
0x1497,0x0000,0x0000,0x0000, 0x149C,0x0000,0x0000,0x0000, /* 0058 */
0x14AD,0x0000,0x0000,0x0000, 0x0301,0x0000,0x0000,0x0000, /* 005A */
0x035E,0x0000,0x0000,0x0000, 0x0302,0x0000,0x0000,0x0000, /* 005C */
0x0211,0x0000,0x0000,0x0000, 0x021D,0x0000,0x0000,0x0000, /* 005E */
0x020E,0x0000,0x0000,0x0000, 0x120F,0x0000,0x0000,0x0000, /* 0060 */
0x1225,0x0000,0x0000,0x0000, 0x123D,0x0000,0x0000,0x0000, /* 0062 */
0x1250,0x0000,0x0000,0x0000, 0x126B,0x0000,0x0000,0x0000, /* 0064 */
0x12A3,0x0000,0x0000,0x0000, 0x12B0,0x0000,0x0000,0x0000, /* 0066 */
0x12D3,0x0000,0x0000,0x0000, 0x12EC,0x0000,0x0000,0x0000, /* 0068 */
0x1305,0x0000,0x0000,0x0000, 0x131E,0x0000,0x0000,0x0000, /* 006A */
0x1330,0x0000,0x0000,0x0000, 0x135F,0x0000,0x0000,0x0000, /* 006C */
0x136D,0x0000,0x0000,0x0000, 0x138E,0x0000,0x0000,0x0000, /* 006E */
0x13B3,0x0000,0x0000,0x0000, 0x13C8,0x0000,0x0000,0x0000, /* 0070 */
0x13DA,0x0000,0x0000,0x0000, 0x1410,0x0000,0x0000,0x0000, /* 0072 */
0x1433,0x0000,0x0000,0x0000, 0x1453,0x0000,0x0000,0x0000, /* 0074 */
0x147B,0x0000,0x0000,0x0000, 0x148D,0x0000,0x0000,0x0000, /* 0076 */
0x1497,0x0000,0x0000,0x0000, 0x149C,0x0000,0x0000,0x0000, /* 0078 */
0x14AD,0x0000,0x0000,0x0000, 0x0303,0x0000,0x0000,0x0000, /* 007A */
0x0558,0x0000,0x0000,0x0000, 0x0304,0x0000,0x0000,0x0000, /* 007C */
0x055B,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 007E */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0080 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0082 */
0x0000,0x0000,0x0000,0x0000, 0x0206,0x0000,0x0000,0x0000, /* 0084 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0086 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0088 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 008A */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 008C */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 008E */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0090 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0092 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0094 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0096 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0098 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 009A */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 009C */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 009E */
0x020A,0x0000,0x0000,0x0000, 0x026F,0x0000,0x0000,0x0000, /* 00A0 */
0x11E0,0x0000,0x0000,0x0000, 0x11E2,0x0000,0x0000,0x0000, /* 00A2 */
0x11DF,0x0000,0x0000,0x0000, 0x11E3,0x0000,0x0000,0x0000, /* 00A4 */
0x0559,0x0000,0x0000,0x0000, 0x0351,0x0000,0x0000,0x0000, /* 00A6 */
0x0216,0x0000,0x0000,0x0000, 0x0354,0x0000,0x0000,0x0000, /* 00A8 */
0x120F,0x0000,0x0000,0x0000, 0x02FD,0x0000,0x0000,0x0000, /* 00AA */
0x0557,0x0000,0x0000,0x0000, 0x0222,0x0000,0x0000,0x0000, /* 00AC */
0x0355,0x0000,0x0000,0x0000, 0x0212,0x0000,0x0000,0x0000, /* 00AE */
0x044B,0x0000,0x0000,0x0000, 0x0551,0x0000,0x0000,0x0000, /* 00B0 */
0x1207,0x0000,0x0000,0x0000, 0x1208,0x0000,0x0000,0x0000, /* 00B2 */
0x020F,0x0000,0x0000,0x0000, 0x1557,0x0000,0x0000,0x0000, /* 00B4 */
0x0352,0x0000,0x0000,0x0000, 0x0292,0x0000,0x0000,0x0000, /* 00B6 */
0x021B,0x0000,0x0000,0x0000, 0x1206,0x0000,0x0000,0x0000, /* 00B8 */
0x138E,0x0000,0x0000,0x0000, 0x02FE,0x0000,0x0000,0x0000, /* 00BA */
0x1206,0x035D,0x1209,0x0000, 0x1206,0x035D,0x1207,0x0000, /* 00BC */
0x1208,0x035D,0x1209,0x0000, 0x0274,0x0000,0x0000,0x0000, /* 00BE */
0x120F,0x0000,0x0000,0x0000, 0x120F,0x0000,0x0000,0x0000, /* 00C0 */
0x120F,0x0000,0x0000,0x0000, 0x120F,0x0000,0x0000,0x0000, /* 00C2 */
0x120F,0x0000,0x0000,0x0000, 0x120F,0x0000,0x0000,0x0000, /* 00C4 */
0x120F,0x126B,0x0000,0x0000, 0x123D,0x0000,0x0000,0x0000, /* 00C6 */
0x126B,0x0000,0x0000,0x0000, 0x126B,0x0000,0x0000,0x0000, /* 00C8 */
0x126B,0x0000,0x0000,0x0000, 0x126B,0x0000,0x0000,0x0000, /* 00CA */
0x12EC,0x0000,0x0000,0x0000, 0x12EC,0x0000,0x0000,0x0000, /* 00CC */
0x12EC,0x0000,0x0000,0x0000, 0x12EC,0x0000,0x0000,0x0000, /* 00CE */
0x1250,0x0000,0x0000,0x0000, 0x136D,0x0000,0x0000,0x0000, /* 00D0 */
0x138E,0x0000,0x0000,0x0000, 0x138E,0x0000,0x0000,0x0000, /* 00D2 */
0x138E,0x0000,0x0000,0x0000, 0x138E,0x0000,0x0000,0x0000, /* 00D4 */
0x138E,0x0000,0x0000,0x0000, 0x0553,0x0000,0x0000,0x0000, /* 00D6 */
0x138E,0x0000,0x0000,0x0000, 0x1453,0x0000,0x0000,0x0000, /* 00D8 */
0x1453,0x0000,0x0000,0x0000, 0x1453,0x0000,0x0000,0x0000, /* 00DA */
0x1453,0x0000,0x0000,0x0000, 0x149C,0x0000,0x0000,0x0000, /* 00DC */
0x14E0,0x0000,0x0000,0x0000, 0x1410,0x1410,0x0000,0x0000, /* 00DE */
0x120F,0x0000,0x0000,0x0000, 0x120F,0x0000,0x0000,0x0000, /* 00E0 */
0x120F,0x0000,0x0000,0x0000, 0x120F,0x0000,0x0000,0x0000, /* 00E2 */
0x120F,0x0000,0x0000,0x0000, 0x120F,0x0000,0x0000,0x0000, /* 00E4 */
0x120F,0x126B,0x0000,0x0000, 0x123D,0x0000,0x0000,0x0000, /* 00E6 */
0x126B,0x0000,0x0000,0x0000, 0x126B,0x0000,0x0000,0x0000, /* 00E8 */
0x126B,0x0000,0x0000,0x0000, 0x126B,0x0000,0x0000,0x0000, /* 00EA */
0x12EC,0x0000,0x0000,0x0000, 0x12EC,0x0000,0x0000,0x0000, /* 00EC */
0x12EC,0x0000,0x0000,0x0000, 0x12EC,0x0000,0x0000,0x0000, /* 00EE */
0x1250,0x0000,0x0000,0x0000, 0x136D,0x0000,0x0000,0x0000, /* 00F0 */
0x138E,0x0000,0x0000,0x0000, 0x138E,0x0000,0x0000,0x0000, /* 00F2 */
0x138E,0x0000,0x0000,0x0000, 0x138E,0x0000,0x0000,0x0000, /* 00F4 */
0x138E,0x0000,0x0000,0x0000, 0x0552,0x0000,0x0000,0x0000, /* 00F6 */
0x138E,0x0000,0x0000,0x0000, 0x1453,0x0000,0x0000,0x0000, /* 00F8 */
0x1453,0x0000,0x0000,0x0000, 0x1453,0x0000,0x0000,0x0000, /* 00FA */
0x1453,0x0000,0x0000,0x0000, 0x149C,0x0000,0x0000,0x0000, /* 00FC */
0x14E0,0x0000,0x0000,0x0000, 0x149C,0x0000,0x0000,0x0000  /* 00FE */
};

uint16 uca520_p001[]= { /* 0100 (3 weights per char) */
0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 0100 */
0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 0103 */
0x123D,0x0000,0x0000, 0x123D,0x0000,0x0000, 0x123D,0x0000,0x0000, /* 0106 */
0x123D,0x0000,0x0000, 0x123D,0x0000,0x0000, 0x123D,0x0000,0x0000, /* 0109 */
0x123D,0x0000,0x0000, 0x123D,0x0000,0x0000, 0x1250,0x0000,0x0000, /* 010C */
0x1250,0x0000,0x0000, 0x1250,0x0000,0x0000, 0x1250,0x0000,0x0000, /* 010F */
0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, /* 0112 */
0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, /* 0115 */
0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, /* 0118 */
0x126B,0x0000,0x0000, 0x12B0,0x0000,0x0000, 0x12B0,0x0000,0x0000, /* 011B */
0x12B0,0x0000,0x0000, 0x12B0,0x0000,0x0000, 0x12B0,0x0000,0x0000, /* 011E */
0x12B0,0x0000,0x0000, 0x12B0,0x0000,0x0000, 0x12B0,0x0000,0x0000, /* 0121 */
0x12D3,0x0000,0x0000, 0x12D3,0x0000,0x0000, 0x12D3,0x0000,0x0000, /* 0124 */
0x12D3,0x0000,0x0000, 0x12EC,0x0000,0x0000, 0x12EC,0x0000,0x0000, /* 0127 */
0x12EC,0x0000,0x0000, 0x12EC,0x0000,0x0000, 0x12EC,0x0000,0x0000, /* 012A */
0x12EC,0x0000,0x0000, 0x12EC,0x0000,0x0000, 0x12EC,0x0000,0x0000, /* 012D */
0x12EC,0x0000,0x0000, 0x12F0,0x0000,0x0000, 0x12EC,0x1305,0x0000, /* 0130 */
0x12EC,0x1305,0x0000, 0x1305,0x0000,0x0000, 0x1305,0x0000,0x0000, /* 0133 */
0x131E,0x0000,0x0000, 0x131E,0x0000,0x0000, 0x13D6,0x0000,0x0000, /* 0136 */
0x1330,0x0000,0x0000, 0x1330,0x0000,0x0000, 0x1330,0x0000,0x0000, /* 0139 */
0x1330,0x0000,0x0000, 0x1330,0x0000,0x0000, 0x1330,0x0000,0x0000, /* 013C */
0x1330,0x0000,0x0000, 0x1330,0x0000,0x0000, 0x1330,0x0000,0x0000, /* 013F */
0x1330,0x0000,0x0000, 0x136D,0x0000,0x0000, 0x136D,0x0000,0x0000, /* 0142 */
0x136D,0x0000,0x0000, 0x136D,0x0000,0x0000, 0x136D,0x0000,0x0000, /* 0145 */
0x136D,0x0000,0x0000, 0x150B,0x136D,0x0000, 0x138A,0x0000,0x0000, /* 0148 */
0x138A,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 014B */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 014E */
0x138E,0x0000,0x0000, 0x138E,0x126B,0x0000, 0x138E,0x126B,0x0000, /* 0151 */
0x13DA,0x0000,0x0000, 0x13DA,0x0000,0x0000, 0x13DA,0x0000,0x0000, /* 0154 */
0x13DA,0x0000,0x0000, 0x13DA,0x0000,0x0000, 0x13DA,0x0000,0x0000, /* 0157 */
0x1410,0x0000,0x0000, 0x1410,0x0000,0x0000, 0x1410,0x0000,0x0000, /* 015A */
0x1410,0x0000,0x0000, 0x1410,0x0000,0x0000, 0x1410,0x0000,0x0000, /* 015D */
0x1410,0x0000,0x0000, 0x1410,0x0000,0x0000, 0x1433,0x0000,0x0000, /* 0160 */
0x1433,0x0000,0x0000, 0x1433,0x0000,0x0000, 0x1433,0x0000,0x0000, /* 0163 */
0x1438,0x0000,0x0000, 0x1438,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 0166 */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 0169 */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 016C */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 016F */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x148D,0x0000,0x0000, /* 0172 */
0x148D,0x0000,0x0000, 0x149C,0x0000,0x0000, 0x149C,0x0000,0x0000, /* 0175 */
0x149C,0x0000,0x0000, 0x14AD,0x0000,0x0000, 0x14AD,0x0000,0x0000, /* 0178 */
0x14AD,0x0000,0x0000, 0x14AD,0x0000,0x0000, 0x14AD,0x0000,0x0000, /* 017B */
0x14AD,0x0000,0x0000, 0x1410,0x0000,0x0000, 0x122D,0x0000,0x0000, /* 017E */
0x1235,0x0000,0x0000, 0x1239,0x0000,0x0000, 0x1239,0x0000,0x0000, /* 0181 */
0x14FE,0x0000,0x0000, 0x14FE,0x0000,0x0000, 0x139A,0x0000,0x0000, /* 0184 */
0x1246,0x0000,0x0000, 0x1246,0x0000,0x0000, 0x1258,0x0000,0x0000, /* 0187 */
0x125C,0x0000,0x0000, 0x1261,0x0000,0x0000, 0x1261,0x0000,0x0000, /* 018A */
0x14AD,0x148D,0x0000, 0x1276,0x0000,0x0000, 0x127B,0x0000,0x0000, /* 018D */
0x1280,0x0000,0x0000, 0x12AA,0x0000,0x0000, 0x12AA,0x0000,0x0000, /* 0190 */
0x12C1,0x0000,0x0000, 0x12CB,0x0000,0x0000, 0x12DB,0x0000,0x0000, /* 0193 */
0x1300,0x0000,0x0000, 0x12FA,0x0000,0x0000, 0x1324,0x0000,0x0000, /* 0196 */
0x1324,0x0000,0x0000, 0x133B,0x0000,0x0000, 0x1357,0x0000,0x0000, /* 0199 */
0x146D,0x0000,0x0000, 0x1378,0x0000,0x0000, 0x137C,0x0000,0x0000, /* 019C */
0x13A5,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 019F */
0x12CF,0x0000,0x0000, 0x12CF,0x0000,0x0000, 0x13BC,0x0000,0x0000, /* 01A2 */
0x13BC,0x0000,0x0000, 0x13DE,0x0000,0x0000, 0x14F6,0x0000,0x0000, /* 01A5 */
0x14F6,0x0000,0x0000, 0x1421,0x0000,0x0000, 0x1426,0x0000,0x0000, /* 01A8 */
0x143E,0x0000,0x0000, 0x1442,0x0000,0x0000, 0x1442,0x0000,0x0000, /* 01AB */
0x1446,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 01AE */
0x1476,0x0000,0x0000, 0x1482,0x0000,0x0000, 0x14A8,0x0000,0x0000, /* 01B1 */
0x14A8,0x0000,0x0000, 0x14B2,0x0000,0x0000, 0x14B2,0x0000,0x0000, /* 01B4 */
0x14CA,0x0000,0x0000, 0x14CF,0x0000,0x0000, 0x14CF,0x0000,0x0000, /* 01B7 */
0x14D4,0x0000,0x0000, 0x14EF,0x0000,0x0000, 0x14FA,0x0000,0x0000, /* 01BA */
0x14FA,0x0000,0x0000, 0x1433,0x1410,0x0000, 0x14E6,0x0000,0x0000, /* 01BD */
0x1525,0x0000,0x0000, 0x1529,0x0000,0x0000, 0x152D,0x0000,0x0000, /* 01C0 */
0x1531,0x0000,0x0000, 0x1250,0x14AD,0x0000, 0x1250,0x14AD,0x0000, /* 01C3 */
0x1250,0x14AD,0x0000, 0x1330,0x1305,0x0000, 0x1330,0x1305,0x0000, /* 01C6 */
0x1330,0x1305,0x0000, 0x136D,0x1305,0x0000, 0x136D,0x1305,0x0000, /* 01C9 */
0x136D,0x1305,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 01CC */
0x12EC,0x0000,0x0000, 0x12EC,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 01CF */
0x138E,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 01D2 */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 01D5 */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 01D8 */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1276,0x0000,0x0000, /* 01DB */
0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 01DE */
0x120F,0x0000,0x0000, 0x120F,0x126B,0x0000, 0x120F,0x126B,0x0000, /* 01E1 */
0x12BC,0x0000,0x0000, 0x12BC,0x0000,0x0000, 0x12B0,0x0000,0x0000, /* 01E4 */
0x12B0,0x0000,0x0000, 0x131E,0x0000,0x0000, 0x131E,0x0000,0x0000, /* 01E7 */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 01EA */
0x138E,0x0000,0x0000, 0x14CA,0x0000,0x0000, 0x14CA,0x0000,0x0000, /* 01ED */
0x1305,0x0000,0x0000, 0x1250,0x14AD,0x0000, 0x1250,0x14AD,0x0000, /* 01F0 */
0x1250,0x14AD,0x0000, 0x12B0,0x0000,0x0000, 0x12B0,0x0000,0x0000, /* 01F3 */
0x12DB,0x0000,0x0000, 0x14E6,0x0000,0x0000, 0x136D,0x0000,0x0000, /* 01F6 */
0x136D,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 01F9 */
0x120F,0x126B,0x0000, 0x120F,0x126B,0x0000, 0x138E,0x0000,0x0000, /* 01FC */
0x138E,0x0000,0x0000  };

uint16 uca520_p002[]= { /* 0200 (3 weights per char) */
0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 0200 */
0x120F,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, /* 0203 */
0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x12EC,0x0000,0x0000, /* 0206 */
0x12EC,0x0000,0x0000, 0x12EC,0x0000,0x0000, 0x12EC,0x0000,0x0000, /* 0209 */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 020C */
0x138E,0x0000,0x0000, 0x13DA,0x0000,0x0000, 0x13DA,0x0000,0x0000, /* 020F */
0x13DA,0x0000,0x0000, 0x13DA,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 0212 */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 0215 */
0x1410,0x0000,0x0000, 0x1410,0x0000,0x0000, 0x1433,0x0000,0x0000, /* 0218 */
0x1433,0x0000,0x0000, 0x14DC,0x0000,0x0000, 0x14DC,0x0000,0x0000, /* 021B */
0x12D3,0x0000,0x0000, 0x12D3,0x0000,0x0000, 0x137C,0x0000,0x0000, /* 021E */
0x1265,0x0000,0x0000, 0x13AE,0x0000,0x0000, 0x13AE,0x0000,0x0000, /* 0221 */
0x14B8,0x0000,0x0000, 0x14B8,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 0224 */
0x120F,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, /* 0227 */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 022A */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 022D */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x149C,0x0000,0x0000, /* 0230 */
0x149C,0x0000,0x0000, 0x134D,0x0000,0x0000, 0x1385,0x0000,0x0000, /* 0233 */
0x144A,0x0000,0x0000, 0x1309,0x0000,0x0000, 0x1250,0x1225,0x0000, /* 0236 */
0x13C8,0x13B3,0x0000, 0x1214,0x0000,0x0000, 0x1242,0x0000,0x0000, /* 0239 */
0x1242,0x0000,0x0000, 0x133B,0x0000,0x0000, 0x143C,0x0000,0x0000, /* 023C */
0x141B,0x0000,0x0000, 0x14C4,0x0000,0x0000, 0x1506,0x0000,0x0000, /* 023F */
0x1506,0x0000,0x0000, 0x122D,0x0000,0x0000, 0x145B,0x0000,0x0000, /* 0242 */
0x1489,0x0000,0x0000, 0x1270,0x0000,0x0000, 0x1270,0x0000,0x0000, /* 0245 */
0x130E,0x0000,0x0000, 0x130E,0x0000,0x0000, 0x13D2,0x0000,0x0000, /* 0248 */
0x13D2,0x0000,0x0000, 0x13E4,0x0000,0x0000, 0x13E4,0x0000,0x0000, /* 024B */
0x14A4,0x0000,0x0000, 0x14A4,0x0000,0x0000, 0x1218,0x0000,0x0000, /* 024E */
0x121C,0x0000,0x0000, 0x1221,0x0000,0x0000, 0x1235,0x0000,0x0000, /* 0251 */
0x139A,0x0000,0x0000, 0x124A,0x0000,0x0000, 0x1258,0x0000,0x0000, /* 0254 */
0x125C,0x0000,0x0000, 0x1285,0x0000,0x0000, 0x127B,0x0000,0x0000, /* 0257 */
0x1289,0x0000,0x0000, 0x1280,0x0000,0x0000, 0x128D,0x0000,0x0000, /* 025A */
0x1293,0x0000,0x0000, 0x1297,0x0000,0x0000, 0x1316,0x0000,0x0000, /* 025D */
0x12C1,0x0000,0x0000, 0x12B4,0x0000,0x0000, 0x12B8,0x0000,0x0000, /* 0260 */
0x12CB,0x0000,0x0000, 0x129F,0x0000,0x0000, 0x1461,0x0000,0x0000, /* 0263 */
0x12DF,0x0000,0x0000, 0x12E6,0x0000,0x0000, 0x12FA,0x0000,0x0000, /* 0266 */
0x1300,0x0000,0x0000, 0x12F4,0x0000,0x0000, 0x1340,0x0000,0x0000, /* 0269 */
0x1344,0x0000,0x0000, 0x1349,0x0000,0x0000, 0x1352,0x0000,0x0000, /* 026C */
0x146D,0x0000,0x0000, 0x1472,0x0000,0x0000, 0x1366,0x0000,0x0000, /* 026F */
0x1378,0x0000,0x0000, 0x1381,0x0000,0x0000, 0x1371,0x0000,0x0000, /* 0272 */
0x13A5,0x0000,0x0000, 0x1394,0x0000,0x0000, 0x13AA,0x0000,0x0000, /* 0275 */
0x13C3,0x0000,0x0000, 0x13E9,0x0000,0x0000, 0x13EE,0x0000,0x0000, /* 0278 */
0x13F3,0x0000,0x0000, 0x13F8,0x0000,0x0000, 0x13FC,0x0000,0x0000, /* 027B */
0x1400,0x0000,0x0000, 0x1405,0x0000,0x0000, 0x13DE,0x0000,0x0000, /* 027E */
0x1409,0x0000,0x0000, 0x1417,0x0000,0x0000, 0x1421,0x0000,0x0000, /* 0281 */
0x131A,0x0000,0x0000, 0x142A,0x0000,0x0000, 0x142F,0x0000,0x0000, /* 0284 */
0x144F,0x0000,0x0000, 0x1446,0x0000,0x0000, 0x145B,0x0000,0x0000, /* 0287 */
0x1476,0x0000,0x0000, 0x1482,0x0000,0x0000, 0x1489,0x0000,0x0000, /* 028A */
0x1493,0x0000,0x0000, 0x135B,0x0000,0x0000, 0x14A0,0x0000,0x0000, /* 028D */
0x14BC,0x0000,0x0000, 0x14C0,0x0000,0x0000, 0x14CA,0x0000,0x0000, /* 0290 */
0x14D8,0x0000,0x0000, 0x1502,0x0000,0x0000, 0x1510,0x0000,0x0000, /* 0293 */
0x1521,0x0000,0x0000, 0x1535,0x0000,0x0000, 0x1539,0x0000,0x0000, /* 0296 */
0x1229,0x0000,0x0000, 0x129B,0x0000,0x0000, 0x12C5,0x0000,0x0000, /* 0299 */
0x12D7,0x0000,0x0000, 0x1312,0x0000,0x0000, 0x132C,0x0000,0x0000, /* 029C */
0x1334,0x0000,0x0000, 0x13CE,0x0000,0x0000, 0x1519,0x0000,0x0000, /* 029F */
0x151D,0x0000,0x0000, 0x1250,0x14AD,0x0000, 0x1250,0x14CA,0x0000, /* 02A2 */
0x1250,0x14C0,0x0000, 0x1433,0x1410,0x0000, 0x1433,0x1421,0x0000, /* 02A5 */
0x1433,0x124A,0x0000, 0x12A3,0x138A,0x0000, 0x1330,0x1410,0x0000, /* 02A8 */
0x1330,0x14AD,0x0000, 0x153D,0x0000,0x0000, 0x1541,0x0000,0x0000, /* 02AB */
0x1465,0x0000,0x0000, 0x1469,0x0000,0x0000, 0x12D3,0x0000,0x0000, /* 02AE */
0x12DF,0x0000,0x0000, 0x1305,0x0000,0x0000, 0x13DA,0x0000,0x0000, /* 02B1 */
0x13E9,0x0000,0x0000, 0x13F3,0x0000,0x0000, 0x1409,0x0000,0x0000, /* 02B4 */
0x148D,0x0000,0x0000, 0x149C,0x0000,0x0000, 0x03E9,0x0000,0x0000, /* 02B7 */
0x03EB,0x0000,0x0000, 0x12EA,0x0000,0x0000, 0x150B,0x0000,0x0000, /* 02BA */
0x12EB,0x0000,0x0000, 0x150D,0x0000,0x0000, 0x1514,0x0000,0x0000, /* 02BD */
0x150A,0x0000,0x0000, 0x1515,0x0000,0x0000, 0x03EC,0x0000,0x0000, /* 02C0 */
0x03ED,0x0000,0x0000, 0x03EE,0x0000,0x0000, 0x03EF,0x0000,0x0000, /* 02C3 */
0x03F0,0x0000,0x0000, 0x03F1,0x0000,0x0000, 0x03F2,0x0000,0x0000, /* 02C6 */
0x03F3,0x0000,0x0000, 0x03F4,0x0000,0x0000, 0x03F5,0x0000,0x0000, /* 02C9 */
0x03F6,0x0000,0x0000, 0x03F7,0x0000,0x0000, 0x03F8,0x0000,0x0000, /* 02CC */
0x03F9,0x0000,0x0000, 0x11CE,0x0000,0x0000, 0x11CF,0x0000,0x0000, /* 02CF */
0x03FA,0x0000,0x0000, 0x03FB,0x0000,0x0000, 0x03FC,0x0000,0x0000, /* 02D2 */
0x03FD,0x0000,0x0000, 0x03FE,0x0000,0x0000, 0x03FF,0x0000,0x0000, /* 02D5 */
0x0214,0x0000,0x0000, 0x0215,0x0000,0x0000, 0x0217,0x0000,0x0000, /* 02D8 */
0x021C,0x0000,0x0000, 0x0210,0x0000,0x0000, 0x0218,0x0000,0x0000, /* 02DB */
0x0400,0x0000,0x0000, 0x0401,0x0000,0x0000, 0x12CB,0x0000,0x0000, /* 02DE */
0x1330,0x0000,0x0000, 0x1410,0x0000,0x0000, 0x1497,0x0000,0x0000, /* 02E1 */
0x1510,0x0000,0x0000, 0x0402,0x0000,0x0000, 0x0403,0x0000,0x0000, /* 02E4 */
0x0404,0x0000,0x0000, 0x0405,0x0000,0x0000, 0x0406,0x0000,0x0000, /* 02E7 */
0x0407,0x0000,0x0000, 0x0408,0x0000,0x0000, 0x0409,0x0000,0x0000, /* 02EA */
0x040A,0x0000,0x0000, 0x150C,0x0000,0x0000, 0x040B,0x0000,0x0000, /* 02ED */
0x040C,0x0000,0x0000, 0x040D,0x0000,0x0000, 0x040E,0x0000,0x0000, /* 02F0 */
0x040F,0x0000,0x0000, 0x0410,0x0000,0x0000, 0x0411,0x0000,0x0000, /* 02F3 */
0x0412,0x0000,0x0000, 0x0413,0x0000,0x0000, 0x0414,0x0000,0x0000, /* 02F6 */
0x0415,0x0000,0x0000, 0x0416,0x0000,0x0000, 0x0417,0x0000,0x0000, /* 02F9 */
0x0418,0x0000,0x0000, 0x0419,0x0000,0x0000, 0x041A,0x0000,0x0000, /* 02FC */
0x041B,0x0000,0x0000  };

uint16 uca520_p003[]= { /* 0300 (4 weights per char) */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0300 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0302 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0304 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0306 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0308 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 030A */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 030C */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 030E */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0310 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0312 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0314 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0316 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0318 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 031A */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 031C */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 031E */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0320 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0322 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0324 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0326 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0328 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 032A */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 032C */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 032E */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0330 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0332 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0334 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0336 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0338 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 033A */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 033C */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 033E */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0340 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0342 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0344 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0346 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0348 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 034A */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 034C */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 034E */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0350 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0352 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0354 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0356 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0358 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 035A */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 035C */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 035E */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 0360 */
0x0000,0x0000,0x0000,0x0000, 0x120F,0x0000,0x0000,0x0000, /* 0362 */
0x126B,0x0000,0x0000,0x0000, 0x12EC,0x0000,0x0000,0x0000, /* 0364 */
0x138E,0x0000,0x0000,0x0000, 0x1453,0x0000,0x0000,0x0000, /* 0366 */
0x123D,0x0000,0x0000,0x0000, 0x1250,0x0000,0x0000,0x0000, /* 0368 */
0x12D3,0x0000,0x0000,0x0000, 0x135F,0x0000,0x0000,0x0000, /* 036A */
0x13DA,0x0000,0x0000,0x0000, 0x1433,0x0000,0x0000,0x0000, /* 036C */
0x147B,0x0000,0x0000,0x0000, 0x1497,0x0000,0x0000,0x0000, /* 036E */
0x154F,0x0000,0x0000,0x0000, 0x154F,0x0000,0x0000,0x0000, /* 0370 */
0x156F,0x0000,0x0000,0x0000, 0x156F,0x0000,0x0000,0x0000, /* 0372 */
0x03E9,0x0000,0x0000,0x0000, 0x03EA,0x0000,0x0000,0x0000, /* 0374 */
0x154C,0x0000,0x0000,0x0000, 0x154C,0x0000,0x0000,0x0000, /* 0376 */
0xFBC0,0x8378,0x0000,0x0000, 0xFBC0,0x8379,0x0000,0x0000, /* 0378 */
0x1552,0x0000,0x0000,0x0000, 0x1565,0x0000,0x0000,0x0000, /* 037A */
0x1564,0x0000,0x0000,0x0000, 0x1566,0x0000,0x0000,0x0000, /* 037C */
0x0243,0x0000,0x0000,0x0000, 0xFBC0,0x837F,0x0000,0x0000, /* 037E */
0xFBC0,0x8380,0x0000,0x0000, 0xFBC0,0x8381,0x0000,0x0000, /* 0380 */
0xFBC0,0x8382,0x0000,0x0000, 0xFBC0,0x8383,0x0000,0x0000, /* 0382 */
0x020F,0x0000,0x0000,0x0000, 0x0216,0x0000,0x0000,0x0000, /* 0384 */
0x1545,0x0000,0x0000,0x0000, 0x0292,0x0000,0x0000,0x0000, /* 0386 */
0x154A,0x0000,0x0000,0x0000, 0x1550,0x0000,0x0000,0x0000, /* 0388 */
0x1552,0x0000,0x0000,0x0000, 0xFBC0,0x838B,0x0000,0x0000, /* 038A */
0x155A,0x0000,0x0000,0x0000, 0xFBC0,0x838D,0x0000,0x0000, /* 038C */
0x1568,0x0000,0x0000,0x0000, 0x156D,0x0000,0x0000,0x0000, /* 038E */
0x1552,0x0000,0x0000,0x0000, 0x1545,0x0000,0x0000,0x0000, /* 0390 */
0x1546,0x0000,0x0000,0x0000, 0x1547,0x0000,0x0000,0x0000, /* 0392 */
0x1549,0x0000,0x0000,0x0000, 0x154A,0x0000,0x0000,0x0000, /* 0394 */
0x154E,0x0000,0x0000,0x0000, 0x1550,0x0000,0x0000,0x0000, /* 0396 */
0x1551,0x0000,0x0000,0x0000, 0x1552,0x0000,0x0000,0x0000, /* 0398 */
0x1554,0x0000,0x0000,0x0000, 0x1555,0x0000,0x0000,0x0000, /* 039A */
0x1557,0x0000,0x0000,0x0000, 0x1558,0x0000,0x0000,0x0000, /* 039C */
0x1559,0x0000,0x0000,0x0000, 0x155A,0x0000,0x0000,0x0000, /* 039E */
0x155B,0x0000,0x0000,0x0000, 0x1560,0x0000,0x0000,0x0000, /* 03A0 */
0xFBC0,0x83A2,0x0000,0x0000, 0x1563,0x0000,0x0000,0x0000, /* 03A2 */
0x1567,0x0000,0x0000,0x0000, 0x1568,0x0000,0x0000,0x0000, /* 03A4 */
0x1569,0x0000,0x0000,0x0000, 0x156A,0x0000,0x0000,0x0000, /* 03A6 */
0x156B,0x0000,0x0000,0x0000, 0x156D,0x0000,0x0000,0x0000, /* 03A8 */
0x1552,0x0000,0x0000,0x0000, 0x1568,0x0000,0x0000,0x0000, /* 03AA */
0x1545,0x0000,0x0000,0x0000, 0x154A,0x0000,0x0000,0x0000, /* 03AC */
0x1550,0x0000,0x0000,0x0000, 0x1552,0x0000,0x0000,0x0000, /* 03AE */
0x1568,0x0000,0x0000,0x0000, 0x1545,0x0000,0x0000,0x0000, /* 03B0 */
0x1546,0x0000,0x0000,0x0000, 0x1547,0x0000,0x0000,0x0000, /* 03B2 */
0x1549,0x0000,0x0000,0x0000, 0x154A,0x0000,0x0000,0x0000, /* 03B4 */
0x154E,0x0000,0x0000,0x0000, 0x1550,0x0000,0x0000,0x0000, /* 03B6 */
0x1551,0x0000,0x0000,0x0000, 0x1552,0x0000,0x0000,0x0000, /* 03B8 */
0x1554,0x0000,0x0000,0x0000, 0x1555,0x0000,0x0000,0x0000, /* 03BA */
0x1557,0x0000,0x0000,0x0000, 0x1558,0x0000,0x0000,0x0000, /* 03BC */
0x1559,0x0000,0x0000,0x0000, 0x155A,0x0000,0x0000,0x0000, /* 03BE */
0x155B,0x0000,0x0000,0x0000, 0x1560,0x0000,0x0000,0x0000, /* 03C0 */
0x1563,0x0000,0x0000,0x0000, 0x1563,0x0000,0x0000,0x0000, /* 03C2 */
0x1567,0x0000,0x0000,0x0000, 0x1568,0x0000,0x0000,0x0000, /* 03C4 */
0x1569,0x0000,0x0000,0x0000, 0x156A,0x0000,0x0000,0x0000, /* 03C6 */
0x156B,0x0000,0x0000,0x0000, 0x156D,0x0000,0x0000,0x0000, /* 03C8 */
0x1552,0x0000,0x0000,0x0000, 0x1568,0x0000,0x0000,0x0000, /* 03CA */
0x155A,0x0000,0x0000,0x0000, 0x1568,0x0000,0x0000,0x0000, /* 03CC */
0x156D,0x0000,0x0000,0x0000, 0x1554,0x1545,0x1552,0x0000, /* 03CE */
0x1546,0x0000,0x0000,0x0000, 0x1551,0x0000,0x0000,0x0000, /* 03D0 */
0x1568,0x0000,0x0000,0x0000, 0x1568,0x0000,0x0000,0x0000, /* 03D2 */
0x1568,0x0000,0x0000,0x0000, 0x1569,0x0000,0x0000,0x0000, /* 03D4 */
0x155B,0x0000,0x0000,0x0000, 0x1554,0x1545,0x1552,0x0000, /* 03D6 */
0x155F,0x0000,0x0000,0x0000, 0x155F,0x0000,0x0000,0x0000, /* 03D8 */
0x154D,0x0000,0x0000,0x0000, 0x154D,0x0000,0x0000,0x0000, /* 03DA */
0x154B,0x0000,0x0000,0x0000, 0x154B,0x0000,0x0000,0x0000, /* 03DC */
0x155E,0x0000,0x0000,0x0000, 0x155E,0x0000,0x0000,0x0000, /* 03DE */
0x156E,0x0000,0x0000,0x0000, 0x156E,0x0000,0x0000,0x0000, /* 03E0 */
0x1590,0x0000,0x0000,0x0000, 0x1590,0x0000,0x0000,0x0000, /* 03E2 */
0x1595,0x0000,0x0000,0x0000, 0x1595,0x0000,0x0000,0x0000, /* 03E4 */
0x1596,0x0000,0x0000,0x0000, 0x1596,0x0000,0x0000,0x0000, /* 03E6 */
0x1598,0x0000,0x0000,0x0000, 0x1598,0x0000,0x0000,0x0000, /* 03E8 */
0x159F,0x0000,0x0000,0x0000, 0x159F,0x0000,0x0000,0x0000, /* 03EA */
0x15A2,0x0000,0x0000,0x0000, 0x15A2,0x0000,0x0000,0x0000, /* 03EC */
0x15A6,0x0000,0x0000,0x0000, 0x15A6,0x0000,0x0000,0x0000, /* 03EE */
0x1554,0x0000,0x0000,0x0000, 0x1560,0x0000,0x0000,0x0000, /* 03F0 */
0x1563,0x0000,0x0000,0x0000, 0x1553,0x0000,0x0000,0x0000, /* 03F2 */
0x1551,0x0000,0x0000,0x0000, 0x154A,0x0000,0x0000,0x0000, /* 03F4 */
0x054B,0x0000,0x0000,0x0000, 0x1570,0x0000,0x0000,0x0000, /* 03F6 */
0x1570,0x0000,0x0000,0x0000, 0x1563,0x0000,0x0000,0x0000, /* 03F8 */
0x155D,0x0000,0x0000,0x0000, 0x155D,0x0000,0x0000,0x0000, /* 03FA */
0x1562,0x0000,0x0000,0x0000, 0x1565,0x0000,0x0000,0x0000, /* 03FC */
0x1564,0x0000,0x0000,0x0000, 0x1566,0x0000,0x0000,0x0000  /* 03FE */
};

uint16 uca520_p004[]= { /* 0400 (2 weights per char) */
0x15F4,0x0000, 0x15F4,0x0000, 0x15E6,0x0000, 0x15EC,0x0000, /* 0400 */
0x15FC,0x0000, 0x1619,0x0000, 0x1631,0x0000, 0x1636,0x0000, /* 0404 */
0x163E,0x0000, 0x1668,0x0000, 0x168D,0x0000, 0x16CC,0x0000, /* 0408 */
0x16D0,0x0000, 0x1625,0x0000, 0x16D8,0x0000, 0x1743,0x0000, /* 040C */
0x15AC,0x0000, 0x15C4,0x0000, 0x15C8,0x0000, 0x15CC,0x0000, /* 0410 */
0x15E0,0x0000, 0x15F4,0x0000, 0x1600,0x0000, 0x160D,0x0000, /* 0414 */
0x1625,0x0000, 0x163A,0x0000, 0x1643,0x0000, 0x165D,0x0000, /* 0418 */
0x166F,0x0000, 0x1678,0x0000, 0x1692,0x0000, 0x16A2,0x0000, /* 041C */
0x16AF,0x0000, 0x16B8,0x0000, 0x16C1,0x0000, 0x16D4,0x0000, /* 0420 */
0x16F1,0x0000, 0x16F5,0x0000, 0x171B,0x0000, 0x1725,0x0000, /* 0424 */
0x1747,0x0000, 0x174C,0x0000, 0x1753,0x0000, 0x1758,0x0000, /* 0428 */
0x1760,0x0000, 0x176D,0x0000, 0x1775,0x0000, 0x177B,0x0000, /* 042C */
0x15AC,0x0000, 0x15C4,0x0000, 0x15C8,0x0000, 0x15CC,0x0000, /* 0430 */
0x15E0,0x0000, 0x15F4,0x0000, 0x1600,0x0000, 0x160D,0x0000, /* 0434 */
0x1625,0x0000, 0x163A,0x0000, 0x1643,0x0000, 0x165D,0x0000, /* 0438 */
0x166F,0x0000, 0x1678,0x0000, 0x1692,0x0000, 0x16A2,0x0000, /* 043C */
0x16AF,0x0000, 0x16B8,0x0000, 0x16C1,0x0000, 0x16D4,0x0000, /* 0440 */
0x16F1,0x0000, 0x16F5,0x0000, 0x171B,0x0000, 0x1725,0x0000, /* 0444 */
0x1747,0x0000, 0x174C,0x0000, 0x1753,0x0000, 0x1758,0x0000, /* 0448 */
0x1760,0x0000, 0x176D,0x0000, 0x1775,0x0000, 0x177B,0x0000, /* 044C */
0x15F4,0x0000, 0x15F4,0x0000, 0x15E6,0x0000, 0x15EC,0x0000, /* 0450 */
0x15FC,0x0000, 0x1619,0x0000, 0x1631,0x0000, 0x1636,0x0000, /* 0454 */
0x163E,0x0000, 0x1668,0x0000, 0x168D,0x0000, 0x16CC,0x0000, /* 0458 */
0x16D0,0x0000, 0x1625,0x0000, 0x16D8,0x0000, 0x1743,0x0000, /* 045C */
0x170A,0x0000, 0x170A,0x0000, 0x1768,0x0000, 0x1768,0x0000, /* 0460 */
0x1780,0x0000, 0x1780,0x0000, 0x1784,0x0000, 0x1784,0x0000, /* 0464 */
0x178E,0x0000, 0x178E,0x0000, 0x1789,0x0000, 0x1789,0x0000, /* 0468 */
0x1793,0x0000, 0x1793,0x0000, 0x1797,0x0000, 0x1797,0x0000, /* 046C */
0x179B,0x0000, 0x179B,0x0000, 0x179F,0x0000, 0x179F,0x0000, /* 0470 */
0x17A3,0x0000, 0x17A3,0x0000, 0x17A7,0x0000, 0x17A7,0x0000, /* 0474 */
0x16ED,0x0000, 0x16ED,0x0000, 0x1717,0x0000, 0x1717,0x0000, /* 0478 */
0x1713,0x0000, 0x1713,0x0000, 0x170E,0x0000, 0x170E,0x0000, /* 047C */
0x16AB,0x0000, 0x16AB,0x0000, 0x044C,0x0000, 0x0000,0x0000, /* 0480 */
0x0000,0x0000, 0x0000,0x0000, 0x0000,0x0000, 0x0000,0x0000, /* 0484 */
0x0000,0x0000, 0x0000,0x0000, 0x1629,0x0000, 0x1629,0x0000, /* 0488 */
0x1764,0x0000, 0x1764,0x0000, 0x16B3,0x0000, 0x16B3,0x0000, /* 048C */
0x15CC,0x0000, 0x15CC,0x0000, 0x15D0,0x0000, 0x15D0,0x0000, /* 0490 */
0x15D8,0x0000, 0x15D8,0x0000, 0x1609,0x0000, 0x1609,0x0000, /* 0494 */
0x15F0,0x0000, 0x15F0,0x0000, 0x1647,0x0000, 0x1647,0x0000, /* 0498 */
0x1657,0x0000, 0x1657,0x0000, 0x1653,0x0000, 0x1653,0x0000, /* 049C */
0x164F,0x0000, 0x164F,0x0000, 0x1680,0x0000, 0x1680,0x0000, /* 04A0 */
0x1689,0x0000, 0x1689,0x0000, 0x16A7,0x0000, 0x16A7,0x0000, /* 04A4 */
0x17AC,0x0000, 0x17AC,0x0000, 0x16BD,0x0000, 0x16BD,0x0000, /* 04A8 */
0x16C7,0x0000, 0x16C7,0x0000, 0x16E4,0x0000, 0x16E4,0x0000, /* 04AC */
0x16E8,0x0000, 0x16E8,0x0000, 0x1701,0x0000, 0x1701,0x0000, /* 04B0 */
0x1720,0x0000, 0x1720,0x0000, 0x172E,0x0000, 0x172E,0x0000, /* 04B4 */
0x1736,0x0000, 0x1736,0x0000, 0x1705,0x0000, 0x1705,0x0000, /* 04B8 */
0x173B,0x0000, 0x173B,0x0000, 0x173F,0x0000, 0x173F,0x0000, /* 04BC */
0x17B1,0x0000, 0x1600,0x0000, 0x1600,0x0000, 0x164B,0x0000, /* 04C0 */
0x164B,0x0000, 0x1662,0x0000, 0x1662,0x0000, 0x1684,0x0000, /* 04C4 */
0x1684,0x0000, 0x167C,0x0000, 0x167C,0x0000, 0x1732,0x0000, /* 04C8 */
0x1732,0x0000, 0x1673,0x0000, 0x1673,0x0000, 0x17B1,0x0000, /* 04CC */
0x15B0,0x0000, 0x15B0,0x0000, 0x15B4,0x0000, 0x15B4,0x0000, /* 04D0 */
0x15C0,0x0000, 0x15C0,0x0000, 0x15F8,0x0000, 0x15F8,0x0000, /* 04D4 */
0x15B8,0x0000, 0x15B8,0x0000, 0x15BC,0x0000, 0x15BC,0x0000, /* 04D8 */
0x1605,0x0000, 0x1605,0x0000, 0x1614,0x0000, 0x1614,0x0000, /* 04DC */
0x161E,0x0000, 0x161E,0x0000, 0x1625,0x0000, 0x1625,0x0000, /* 04E0 */
0x162D,0x0000, 0x162D,0x0000, 0x1696,0x0000, 0x1696,0x0000, /* 04E4 */
0x169A,0x0000, 0x169A,0x0000, 0x169E,0x0000, 0x169E,0x0000, /* 04E8 */
0x1771,0x0000, 0x1771,0x0000, 0x16D4,0x0000, 0x16D4,0x0000, /* 04EC */
0x16DC,0x0000, 0x16DC,0x0000, 0x16E0,0x0000, 0x16E0,0x0000, /* 04F0 */
0x172A,0x0000, 0x172A,0x0000, 0x15DC,0x0000, 0x15DC,0x0000, /* 04F4 */
0x175C,0x0000, 0x175C,0x0000, 0x15D4,0x0000, 0x15D4,0x0000, /* 04F8 */
0x16F9,0x0000, 0x16F9,0x0000, 0x16FD,0x0000, 0x16FD,0x0000  /* 04FC */
};

uint16 uca520_p005[]= { /* 0500 (3 weights per char) */
0x15E4,0x0000,0x0000, 0x15E4,0x0000,0x0000, 0x15EB,0x0000,0x0000, /* 0500 */
0x15EB,0x0000,0x0000, 0x1612,0x0000,0x0000, 0x1612,0x0000,0x0000, /* 0503 */
0x1623,0x0000,0x0000, 0x1623,0x0000,0x0000, 0x166D,0x0000,0x0000, /* 0506 */
0x166D,0x0000,0x0000, 0x1691,0x0000,0x0000, 0x1691,0x0000,0x0000, /* 0509 */
0x16BC,0x0000,0x0000, 0x16BC,0x0000,0x0000, 0x16C6,0x0000,0x0000, /* 050C */
0x16C6,0x0000,0x0000, 0x1613,0x0000,0x0000, 0x1613,0x0000,0x0000, /* 050F */
0x1666,0x0000,0x0000, 0x1666,0x0000,0x0000, 0x166E,0x0000,0x0000, /* 0512 */
0x166E,0x0000,0x0000, 0x16B7,0x0000,0x0000, 0x16B7,0x0000,0x0000, /* 0515 */
0x177F,0x0000,0x0000, 0x177F,0x0000,0x0000, 0x165C,0x0000,0x0000, /* 0518 */
0x165C,0x0000,0x0000, 0x17B0,0x0000,0x0000, 0x17B0,0x0000,0x0000, /* 051B */
0x165B,0x0000,0x0000, 0x165B,0x0000,0x0000, 0x1667,0x0000,0x0000, /* 051E */
0x1667,0x0000,0x0000, 0x1688,0x0000,0x0000, 0x1688,0x0000,0x0000, /* 0521 */
0x16A6,0x0000,0x0000, 0x16A6,0x0000,0x0000, 0xFBC0,0x8526,0x0000, /* 0524 */
0xFBC0,0x8527,0x0000, 0xFBC0,0x8528,0x0000, 0xFBC0,0x8529,0x0000, /* 0527 */
0xFBC0,0x852A,0x0000, 0xFBC0,0x852B,0x0000, 0xFBC0,0x852C,0x0000, /* 052A */
0xFBC0,0x852D,0x0000, 0xFBC0,0x852E,0x0000, 0xFBC0,0x852F,0x0000, /* 052D */
0xFBC0,0x8530,0x0000, 0x1835,0x0000,0x0000, 0x1836,0x0000,0x0000, /* 0530 */
0x1837,0x0000,0x0000, 0x1838,0x0000,0x0000, 0x1839,0x0000,0x0000, /* 0533 */
0x183A,0x0000,0x0000, 0x183B,0x0000,0x0000, 0x183C,0x0000,0x0000, /* 0536 */
0x183D,0x0000,0x0000, 0x183E,0x0000,0x0000, 0x183F,0x0000,0x0000, /* 0539 */
0x1840,0x0000,0x0000, 0x1841,0x0000,0x0000, 0x1842,0x0000,0x0000, /* 053C */
0x1843,0x0000,0x0000, 0x1844,0x0000,0x0000, 0x1845,0x0000,0x0000, /* 053F */
0x1846,0x0000,0x0000, 0x1847,0x0000,0x0000, 0x1848,0x0000,0x0000, /* 0542 */
0x1849,0x0000,0x0000, 0x184A,0x0000,0x0000, 0x184B,0x0000,0x0000, /* 0545 */
0x184C,0x0000,0x0000, 0x184D,0x0000,0x0000, 0x184E,0x0000,0x0000, /* 0548 */
0x184F,0x0000,0x0000, 0x1850,0x0000,0x0000, 0x1851,0x0000,0x0000, /* 054B */
0x1852,0x0000,0x0000, 0x1853,0x0000,0x0000, 0x1854,0x0000,0x0000, /* 054E */
0x1855,0x0000,0x0000, 0x1856,0x0000,0x0000, 0x1857,0x0000,0x0000, /* 0551 */
0x1858,0x0000,0x0000, 0x1859,0x0000,0x0000, 0x185A,0x0000,0x0000, /* 0554 */
0xFBC0,0x8557,0x0000, 0xFBC0,0x8558,0x0000, 0x185B,0x0000,0x0000, /* 0557 */
0x0392,0x0000,0x0000, 0x0393,0x0000,0x0000, 0x0270,0x0000,0x0000, /* 055A */
0x0235,0x0000,0x0000, 0x0276,0x0000,0x0000, 0x0394,0x0000,0x0000, /* 055D */
0xFBC0,0x8560,0x0000, 0x1835,0x0000,0x0000, 0x1836,0x0000,0x0000, /* 0560 */
0x1837,0x0000,0x0000, 0x1838,0x0000,0x0000, 0x1839,0x0000,0x0000, /* 0563 */
0x183A,0x0000,0x0000, 0x183B,0x0000,0x0000, 0x183C,0x0000,0x0000, /* 0566 */
0x183D,0x0000,0x0000, 0x183E,0x0000,0x0000, 0x183F,0x0000,0x0000, /* 0569 */
0x1840,0x0000,0x0000, 0x1841,0x0000,0x0000, 0x1842,0x0000,0x0000, /* 056C */
0x1843,0x0000,0x0000, 0x1844,0x0000,0x0000, 0x1845,0x0000,0x0000, /* 056F */
0x1846,0x0000,0x0000, 0x1847,0x0000,0x0000, 0x1848,0x0000,0x0000, /* 0572 */
0x1849,0x0000,0x0000, 0x184A,0x0000,0x0000, 0x184B,0x0000,0x0000, /* 0575 */
0x184C,0x0000,0x0000, 0x184D,0x0000,0x0000, 0x184E,0x0000,0x0000, /* 0578 */
0x184F,0x0000,0x0000, 0x1850,0x0000,0x0000, 0x1851,0x0000,0x0000, /* 057B */
0x1852,0x0000,0x0000, 0x1853,0x0000,0x0000, 0x1854,0x0000,0x0000, /* 057E */
0x1855,0x0000,0x0000, 0x1856,0x0000,0x0000, 0x1857,0x0000,0x0000, /* 0581 */
0x1858,0x0000,0x0000, 0x1859,0x0000,0x0000, 0x185A,0x0000,0x0000, /* 0584 */
0x1839,0x1856,0x0000, 0xFBC0,0x8588,0x0000, 0x0248,0x0000,0x0000, /* 0587 */
0x0224,0x0000,0x0000, 0xFBC0,0x858B,0x0000, 0xFBC0,0x858C,0x0000, /* 058A */
0xFBC0,0x858D,0x0000, 0xFBC0,0x858E,0x0000, 0xFBC0,0x858F,0x0000, /* 058D */
0xFBC0,0x8590,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0590 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0593 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0596 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0599 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 059C */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 059F */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 05A2 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 05A5 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 05A8 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 05AB */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 05AE */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 05B1 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 05B4 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 05B7 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 05BA */
0x0000,0x0000,0x0000, 0x0395,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 05BD */
0x0396,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 05C0 */
0x0397,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 05C3 */
0x0398,0x0000,0x0000, 0x0000,0x0000,0x0000, 0xFBC0,0x85C8,0x0000, /* 05C6 */
0xFBC0,0x85C9,0x0000, 0xFBC0,0x85CA,0x0000, 0xFBC0,0x85CB,0x0000, /* 05C9 */
0xFBC0,0x85CC,0x0000, 0xFBC0,0x85CD,0x0000, 0xFBC0,0x85CE,0x0000, /* 05CC */
0xFBC0,0x85CF,0x0000, 0x185C,0x0000,0x0000, 0x185D,0x0000,0x0000, /* 05CF */
0x185E,0x0000,0x0000, 0x185F,0x0000,0x0000, 0x1860,0x0000,0x0000, /* 05D2 */
0x1861,0x0000,0x0000, 0x1862,0x0000,0x0000, 0x1863,0x0000,0x0000, /* 05D5 */
0x1864,0x0000,0x0000, 0x1865,0x0000,0x0000, 0x1866,0x0000,0x0000, /* 05D8 */
0x1866,0x0000,0x0000, 0x1867,0x0000,0x0000, 0x1868,0x0000,0x0000, /* 05DB */
0x1868,0x0000,0x0000, 0x1869,0x0000,0x0000, 0x1869,0x0000,0x0000, /* 05DE */
0x186A,0x0000,0x0000, 0x186B,0x0000,0x0000, 0x186C,0x0000,0x0000, /* 05E1 */
0x186C,0x0000,0x0000, 0x186D,0x0000,0x0000, 0x186D,0x0000,0x0000, /* 05E4 */
0x186E,0x0000,0x0000, 0x186F,0x0000,0x0000, 0x1870,0x0000,0x0000, /* 05E7 */
0x1871,0x0000,0x0000, 0xFBC0,0x85EB,0x0000, 0xFBC0,0x85EC,0x0000, /* 05EA */
0xFBC0,0x85ED,0x0000, 0xFBC0,0x85EE,0x0000, 0xFBC0,0x85EF,0x0000, /* 05ED */
0x1861,0x1861,0x0000, 0x1861,0x1865,0x0000, 0x1865,0x1865,0x0000, /* 05F0 */
0x0399,0x0000,0x0000, 0x039A,0x0000,0x0000, 0xFBC0,0x85F5,0x0000, /* 05F3 */
0xFBC0,0x85F6,0x0000, 0xFBC0,0x85F7,0x0000, 0xFBC0,0x85F8,0x0000, /* 05F6 */
0xFBC0,0x85F9,0x0000, 0xFBC0,0x85FA,0x0000, 0xFBC0,0x85FB,0x0000, /* 05F9 */
0xFBC0,0x85FC,0x0000, 0xFBC0,0x85FD,0x0000, 0xFBC0,0x85FE,0x0000, /* 05FC */
0xFBC0,0x85FF,0x0000  };

uint16 uca520_p006[]= { /* 0600 (3 weights per char) */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0600 */
0x0000,0x0000,0x0000, 0xFBC0,0x8604,0x0000, 0xFBC0,0x8605,0x0000, /* 0603 */
0x0566,0x0000,0x0000, 0x0568,0x0000,0x0000, 0x044D,0x0000,0x0000, /* 0606 */
0x0366,0x0000,0x0000, 0x0368,0x0000,0x0000, 0x11E4,0x0000,0x0000, /* 0609 */
0x0236,0x0000,0x0000, 0x0237,0x0000,0x0000, 0x044E,0x0000,0x0000, /* 060C */
0x044F,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 060F */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0612 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0615 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0618 */
0x0244,0x0000,0x0000, 0xFBC0,0x861C,0x0000, 0xFBC0,0x861D,0x0000, /* 061B */
0x0249,0x0000,0x0000, 0x0277,0x0000,0x0000, 0xFBC0,0x8620,0x0000, /* 061E */
0x18A2,0x0000,0x0000, 0x18A3,0x0000,0x0000, 0x18A4,0x0000,0x0000, /* 0621 */
0x18A7,0x0000,0x0000, 0x18A8,0x0000,0x0000, 0x18AC,0x0000,0x0000, /* 0624 */
0x18AD,0x0000,0x0000, 0x18AF,0x0000,0x0000, 0x18BA,0x0000,0x0000, /* 0627 */
0x18BB,0x0000,0x0000, 0x18BC,0x0000,0x0000, 0x18C2,0x0000,0x0000, /* 062A */
0x18C8,0x0000,0x0000, 0x18C9,0x0000,0x0000, 0x18D3,0x0000,0x0000, /* 062D */
0x18D4,0x0000,0x0000, 0x18E1,0x0000,0x0000, 0x18E2,0x0000,0x0000, /* 0630 */
0x18F1,0x0000,0x0000, 0x18F2,0x0000,0x0000, 0x18FC,0x0000,0x0000, /* 0633 */
0x18FD,0x0000,0x0000, 0x1901,0x0000,0x0000, 0x1902,0x0000,0x0000, /* 0636 */
0x1904,0x0000,0x0000, 0x1905,0x0000,0x0000, 0x1927,0x0000,0x0000, /* 0639 */
0x1928,0x0000,0x0000, 0x1956,0x0000,0x0000, 0x1957,0x0000,0x0000, /* 063C */
0x1958,0x0000,0x0000, 0x020C,0x0000,0x0000, 0x190B,0x0000,0x0000, /* 063F */
0x1915,0x0000,0x0000, 0x1918,0x0000,0x0000, 0x192B,0x0000,0x0000, /* 0642 */
0x1931,0x0000,0x0000, 0x1934,0x0000,0x0000, 0x193D,0x0000,0x0000, /* 0645 */
0x1943,0x0000,0x0000, 0x194F,0x0000,0x0000, 0x1950,0x0000,0x0000, /* 0648 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 064B */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 064E */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0651 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0654 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0657 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 065A */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0xFBC0,0x865F,0x0000, /* 065D */
0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 0660 */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, /* 0663 */
0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, /* 0666 */
0x120E,0x0000,0x0000, 0x0364,0x0000,0x0000, 0x0238,0x0000,0x0000, /* 0669 */
0x0239,0x0000,0x0000, 0x035A,0x0000,0x0000, 0x18AE,0x0000,0x0000, /* 066C */
0x1914,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x18A6,0x0000,0x0000, /* 066F */
0x18A5,0x0000,0x0000, 0x18A9,0x0000,0x0000, 0x18A2,0x0000,0x0000, /* 0672 */
0x18AD,0x18A2,0x0000, 0x1943,0x18A2,0x0000, 0x1947,0x18A2,0x0000, /* 0675 */
0x1950,0x18A2,0x0000, 0x18BD,0x0000,0x0000, 0x18BE,0x0000,0x0000, /* 0678 */
0x18B0,0x0000,0x0000, 0x18BF,0x0000,0x0000, 0x18C0,0x0000,0x0000, /* 067B */
0x18B1,0x0000,0x0000, 0x18C1,0x0000,0x0000, 0x18B2,0x0000,0x0000, /* 067E */
0x18CA,0x0000,0x0000, 0x18CB,0x0000,0x0000, 0x18C3,0x0000,0x0000, /* 0681 */
0x18C4,0x0000,0x0000, 0x18CC,0x0000,0x0000, 0x18C5,0x0000,0x0000, /* 0684 */
0x18C7,0x0000,0x0000, 0x18D5,0x0000,0x0000, 0x18D6,0x0000,0x0000, /* 0687 */
0x18D7,0x0000,0x0000, 0x18D8,0x0000,0x0000, 0x18D9,0x0000,0x0000, /* 068A */
0x18DA,0x0000,0x0000, 0x18DB,0x0000,0x0000, 0x18DC,0x0000,0x0000, /* 068D */
0x18DD,0x0000,0x0000, 0x18E3,0x0000,0x0000, 0x18E4,0x0000,0x0000, /* 0690 */
0x18E5,0x0000,0x0000, 0x18E6,0x0000,0x0000, 0x18E7,0x0000,0x0000, /* 0693 */
0x18E8,0x0000,0x0000, 0x18E9,0x0000,0x0000, 0x18EA,0x0000,0x0000, /* 0696 */
0x18EB,0x0000,0x0000, 0x18F3,0x0000,0x0000, 0x18F4,0x0000,0x0000, /* 0699 */
0x18F5,0x0000,0x0000, 0x18FE,0x0000,0x0000, 0x18FF,0x0000,0x0000, /* 069C */
0x1903,0x0000,0x0000, 0x1906,0x0000,0x0000, 0x190C,0x0000,0x0000, /* 069F */
0x190D,0x0000,0x0000, 0x190E,0x0000,0x0000, 0x190F,0x0000,0x0000, /* 06A2 */
0x1910,0x0000,0x0000, 0x1911,0x0000,0x0000, 0x1916,0x0000,0x0000, /* 06A5 */
0x1917,0x0000,0x0000, 0x1919,0x0000,0x0000, 0x191A,0x0000,0x0000, /* 06A8 */
0x191B,0x0000,0x0000, 0x191C,0x0000,0x0000, 0x191E,0x0000,0x0000, /* 06AB */
0x191F,0x0000,0x0000, 0x1920,0x0000,0x0000, 0x1921,0x0000,0x0000, /* 06AE */
0x1922,0x0000,0x0000, 0x1923,0x0000,0x0000, 0x1924,0x0000,0x0000, /* 06B1 */
0x1925,0x0000,0x0000, 0x192C,0x0000,0x0000, 0x192D,0x0000,0x0000, /* 06B4 */
0x192E,0x0000,0x0000, 0x192F,0x0000,0x0000, 0x1939,0x0000,0x0000, /* 06B7 */
0x1935,0x0000,0x0000, 0x1936,0x0000,0x0000, 0x1937,0x0000,0x0000, /* 06BA */
0x1938,0x0000,0x0000, 0x193E,0x0000,0x0000, 0x18C6,0x0000,0x0000, /* 06BD */
0x1942,0x0000,0x0000, 0x193F,0x0000,0x0000, 0x193F,0x0000,0x0000, /* 06C0 */
0x1940,0x0000,0x0000, 0x1944,0x0000,0x0000, 0x1945,0x0000,0x0000, /* 06C3 */
0x1946,0x0000,0x0000, 0x1947,0x0000,0x0000, 0x1948,0x0000,0x0000, /* 06C6 */
0x1949,0x0000,0x0000, 0x194A,0x0000,0x0000, 0x194B,0x0000,0x0000, /* 06C9 */
0x1951,0x0000,0x0000, 0x1952,0x0000,0x0000, 0x1953,0x0000,0x0000, /* 06CC */
0x194C,0x0000,0x0000, 0x1954,0x0000,0x0000, 0x1955,0x0000,0x0000, /* 06CF */
0x195C,0x0000,0x0000, 0x195C,0x0000,0x0000, 0x0283,0x0000,0x0000, /* 06D2 */
0x1942,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 06D5 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 06D8 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 06DB */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 06DE */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 06E1 */
0x0000,0x0000,0x0000, 0x1943,0x0000,0x0000, 0x1950,0x0000,0x0000, /* 06E4 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0450,0x0000,0x0000, /* 06E7 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 06EA */
0x0000,0x0000,0x0000, 0x18DE,0x0000,0x0000, 0x18EC,0x0000,0x0000, /* 06ED */
0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 06F0 */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, /* 06F3 */
0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, /* 06F6 */
0x120E,0x0000,0x0000, 0x18F6,0x0000,0x0000, 0x1900,0x0000,0x0000, /* 06F9 */
0x1907,0x0000,0x0000, 0x18A2,0x0000,0x0000, 0x1931,0x0000,0x0000, /* 06FC */
0x1941,0x0000,0x0000  };

uint16 uca520_p007[]= { /* 0700 (3 weights per char) */
0x02B5,0x0000,0x0000, 0x0284,0x0000,0x0000, 0x0285,0x0000,0x0000, /* 0700 */
0x024A,0x0000,0x0000, 0x024B,0x0000,0x0000, 0x024C,0x0000,0x0000, /* 0703 */
0x024D,0x0000,0x0000, 0x024E,0x0000,0x0000, 0x024F,0x0000,0x0000, /* 0706 */
0x0278,0x0000,0x0000, 0x039B,0x0000,0x0000, 0x039C,0x0000,0x0000, /* 0709 */
0x039D,0x0000,0x0000, 0x039E,0x0000,0x0000, 0xFBC0,0x870E,0x0000, /* 070C */
0x0000,0x0000,0x0000, 0x195F,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 070F */
0x1960,0x0000,0x0000, 0x1961,0x0000,0x0000, 0x1961,0x0000,0x0000, /* 0712 */
0x1963,0x0000,0x0000, 0x1962,0x0000,0x0000, 0x1964,0x0000,0x0000, /* 0715 */
0x1965,0x0000,0x0000, 0x1966,0x0000,0x0000, 0x1968,0x0000,0x0000, /* 0718 */
0x1969,0x0000,0x0000, 0x1969,0x0000,0x0000, 0x196A,0x0000,0x0000, /* 071B */
0x196B,0x0000,0x0000, 0x196C,0x0000,0x0000, 0x196E,0x0000,0x0000, /* 071E */
0x196F,0x0000,0x0000, 0x1970,0x0000,0x0000, 0x1971,0x0000,0x0000, /* 0721 */
0x1971,0x0000,0x0000, 0x1972,0x0000,0x0000, 0x1973,0x0000,0x0000, /* 0724 */
0x1973,0x0000,0x0000, 0x1975,0x0000,0x0000, 0x1976,0x0000,0x0000, /* 0727 */
0x1977,0x0000,0x0000, 0x1978,0x0000,0x0000, 0x1979,0x0000,0x0000, /* 072A */
0x1960,0x0000,0x0000, 0x1961,0x0000,0x0000, 0x1963,0x0000,0x0000, /* 072D */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0730 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0733 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0736 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0739 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 073C */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 073F */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0742 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0745 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0748 */
0xFBC0,0x874B,0x0000, 0xFBC0,0x874C,0x0000, 0x1967,0x0000,0x0000, /* 074B */
0x196D,0x0000,0x0000, 0x1974,0x0000,0x0000, 0x18B3,0x0000,0x0000, /* 074E */
0x18B4,0x0000,0x0000, 0x18B5,0x0000,0x0000, 0x18B6,0x0000,0x0000, /* 0751 */
0x18B7,0x0000,0x0000, 0x18B8,0x0000,0x0000, 0x18B9,0x0000,0x0000, /* 0754 */
0x18CD,0x0000,0x0000, 0x18CE,0x0000,0x0000, 0x18DF,0x0000,0x0000, /* 0757 */
0x18E0,0x0000,0x0000, 0x18ED,0x0000,0x0000, 0x18F7,0x0000,0x0000, /* 075A */
0x1908,0x0000,0x0000, 0x1909,0x0000,0x0000, 0x190A,0x0000,0x0000, /* 075D */
0x1912,0x0000,0x0000, 0x1913,0x0000,0x0000, 0x1926,0x0000,0x0000, /* 0760 */
0x1929,0x0000,0x0000, 0x192A,0x0000,0x0000, 0x1932,0x0000,0x0000, /* 0763 */
0x1933,0x0000,0x0000, 0x193A,0x0000,0x0000, 0x193B,0x0000,0x0000, /* 0766 */
0x193C,0x0000,0x0000, 0x1930,0x0000,0x0000, 0x18EE,0x0000,0x0000, /* 0769 */
0x18EF,0x0000,0x0000, 0x18F8,0x0000,0x0000, 0x18CF,0x0000,0x0000, /* 076C */
0x18D0,0x0000,0x0000, 0x18F9,0x0000,0x0000, 0x18F0,0x0000,0x0000, /* 076F */
0x18D1,0x0000,0x0000, 0x18AA,0x0000,0x0000, 0x18AB,0x0000,0x0000, /* 0772 */
0x1959,0x0000,0x0000, 0x195A,0x0000,0x0000, 0x195B,0x0000,0x0000, /* 0775 */
0x194D,0x0000,0x0000, 0x194E,0x0000,0x0000, 0x195D,0x0000,0x0000, /* 0778 */
0x195E,0x0000,0x0000, 0x18D2,0x0000,0x0000, 0x18FA,0x0000,0x0000, /* 077B */
0x18FB,0x0000,0x0000, 0x191D,0x0000,0x0000, 0x197A,0x0000,0x0000, /* 077E */
0x197D,0x0000,0x0000, 0x197E,0x0000,0x0000, 0x197F,0x0000,0x0000, /* 0781 */
0x1981,0x0000,0x0000, 0x1982,0x0000,0x0000, 0x1983,0x0000,0x0000, /* 0784 */
0x1984,0x0000,0x0000, 0x1987,0x0000,0x0000, 0x1989,0x0000,0x0000, /* 0787 */
0x198A,0x0000,0x0000, 0x198B,0x0000,0x0000, 0x198D,0x0000,0x0000, /* 078A */
0x1991,0x0000,0x0000, 0x1992,0x0000,0x0000, 0x1994,0x0000,0x0000, /* 078D */
0x1995,0x0000,0x0000, 0x1999,0x0000,0x0000, 0x199A,0x0000,0x0000, /* 0790 */
0x199B,0x0000,0x0000, 0x199C,0x0000,0x0000, 0x199D,0x0000,0x0000, /* 0793 */
0x199E,0x0000,0x0000, 0x199F,0x0000,0x0000, 0x198E,0x0000,0x0000, /* 0796 */
0x197B,0x0000,0x0000, 0x197C,0x0000,0x0000, 0x198C,0x0000,0x0000, /* 0799 */
0x1980,0x0000,0x0000, 0x1996,0x0000,0x0000, 0x1997,0x0000,0x0000, /* 079C */
0x1998,0x0000,0x0000, 0x198F,0x0000,0x0000, 0x1990,0x0000,0x0000, /* 079F */
0x1985,0x0000,0x0000, 0x1986,0x0000,0x0000, 0x1993,0x0000,0x0000, /* 07A2 */
0x1988,0x0000,0x0000, 0x19A1,0x0000,0x0000, 0x19A2,0x0000,0x0000, /* 07A5 */
0x19A3,0x0000,0x0000, 0x19A4,0x0000,0x0000, 0x19A5,0x0000,0x0000, /* 07A8 */
0x19A6,0x0000,0x0000, 0x19A7,0x0000,0x0000, 0x19A8,0x0000,0x0000, /* 07AB */
0x19A9,0x0000,0x0000, 0x19AA,0x0000,0x0000, 0x19AB,0x0000,0x0000, /* 07AE */
0x19A0,0x0000,0x0000, 0xFBC0,0x87B2,0x0000, 0xFBC0,0x87B3,0x0000, /* 07B1 */
0xFBC0,0x87B4,0x0000, 0xFBC0,0x87B5,0x0000, 0xFBC0,0x87B6,0x0000, /* 07B4 */
0xFBC0,0x87B7,0x0000, 0xFBC0,0x87B8,0x0000, 0xFBC0,0x87B9,0x0000, /* 07B7 */
0xFBC0,0x87BA,0x0000, 0xFBC0,0x87BB,0x0000, 0xFBC0,0x87BC,0x0000, /* 07BA */
0xFBC0,0x87BD,0x0000, 0xFBC0,0x87BE,0x0000, 0xFBC0,0x87BF,0x0000, /* 07BD */
0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 07C0 */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, /* 07C3 */
0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, /* 07C6 */
0x120E,0x0000,0x0000, 0x19AC,0x0000,0x0000, 0x19AD,0x0000,0x0000, /* 07C9 */
0x19AE,0x0000,0x0000, 0x19AF,0x0000,0x0000, 0x19B0,0x0000,0x0000, /* 07CC */
0x19B1,0x0000,0x0000, 0x19B2,0x0000,0x0000, 0x19B3,0x0000,0x0000, /* 07CF */
0x19B4,0x0000,0x0000, 0x19B5,0x0000,0x0000, 0x19B6,0x0000,0x0000, /* 07D2 */
0x19B7,0x0000,0x0000, 0x19B8,0x0000,0x0000, 0x19B9,0x0000,0x0000, /* 07D5 */
0x19BA,0x0000,0x0000, 0x19BB,0x0000,0x0000, 0x19BC,0x0000,0x0000, /* 07D8 */
0x19BD,0x0000,0x0000, 0x19BE,0x0000,0x0000, 0x19BF,0x0000,0x0000, /* 07DB */
0x19C0,0x0000,0x0000, 0x19C1,0x0000,0x0000, 0x19C2,0x0000,0x0000, /* 07DE */
0x19C3,0x0000,0x0000, 0x19C4,0x0000,0x0000, 0x19C5,0x0000,0x0000, /* 07E1 */
0x19C6,0x0000,0x0000, 0x19C7,0x0000,0x0000, 0x19C8,0x0000,0x0000, /* 07E4 */
0x19C9,0x0000,0x0000, 0x19B8,0x0000,0x0000, 0x19B9,0x0000,0x0000, /* 07E7 */
0x19BB,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 07EA */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 07ED */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 07F0 */
0x0000,0x0000,0x0000, 0x19CA,0x0000,0x0000, 0x19CB,0x0000,0x0000, /* 07F3 */
0x0452,0x0000,0x0000, 0x02B6,0x0000,0x0000, 0x023A,0x0000,0x0000, /* 07F6 */
0x0271,0x0000,0x0000, 0x020D,0x0000,0x0000, 0xFBC0,0x87FB,0x0000, /* 07F9 */
0xFBC0,0x87FC,0x0000, 0xFBC0,0x87FD,0x0000, 0xFBC0,0x87FE,0x0000, /* 07FC */
0xFBC0,0x87FF,0x0000  };

uint16 uca520_p008[]= { /* 0800 (3 weights per char) */
0x1888,0x0000,0x0000, 0x1889,0x0000,0x0000, 0x188A,0x0000,0x0000, /* 0800 */
0x188B,0x0000,0x0000, 0x188C,0x0000,0x0000, 0x188D,0x0000,0x0000, /* 0803 */
0x188E,0x0000,0x0000, 0x188F,0x0000,0x0000, 0x1890,0x0000,0x0000, /* 0806 */
0x1891,0x0000,0x0000, 0x1892,0x0000,0x0000, 0x1893,0x0000,0x0000, /* 0809 */
0x1894,0x0000,0x0000, 0x1895,0x0000,0x0000, 0x1896,0x0000,0x0000, /* 080C */
0x1897,0x0000,0x0000, 0x1898,0x0000,0x0000, 0x1899,0x0000,0x0000, /* 080F */
0x189A,0x0000,0x0000, 0x189B,0x0000,0x0000, 0x189C,0x0000,0x0000, /* 0812 */
0x189D,0x0000,0x0000, 0x189E,0x0000,0x0000, 0x189F,0x0000,0x0000, /* 0815 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x18A0,0x0000,0x0000, /* 0818 */
0x18A1,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 081B */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 081E */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0821 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0824 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0827 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 082A */
0x0000,0x0000,0x0000, 0xFBC0,0x882E,0x0000, 0xFBC0,0x882F,0x0000, /* 082D */
0x0250,0x0000,0x0000, 0x0251,0x0000,0x0000, 0x0252,0x0000,0x0000, /* 0830 */
0x0253,0x0000,0x0000, 0x0254,0x0000,0x0000, 0x0255,0x0000,0x0000, /* 0833 */
0x0256,0x0000,0x0000, 0x0257,0x0000,0x0000, 0x0258,0x0000,0x0000, /* 0836 */
0x0259,0x0000,0x0000, 0x025A,0x0000,0x0000, 0x025B,0x0000,0x0000, /* 0839 */
0x025C,0x0000,0x0000, 0x025D,0x0000,0x0000, 0x025E,0x0000,0x0000, /* 083C */
0xFBC0,0x883F,0x0000, 0xFBC0,0x8840,0x0000, 0xFBC0,0x8841,0x0000, /* 083F */
0xFBC0,0x8842,0x0000, 0xFBC0,0x8843,0x0000, 0xFBC0,0x8844,0x0000, /* 0842 */
0xFBC0,0x8845,0x0000, 0xFBC0,0x8846,0x0000, 0xFBC0,0x8847,0x0000, /* 0845 */
0xFBC0,0x8848,0x0000, 0xFBC0,0x8849,0x0000, 0xFBC0,0x884A,0x0000, /* 0848 */
0xFBC0,0x884B,0x0000, 0xFBC0,0x884C,0x0000, 0xFBC0,0x884D,0x0000, /* 084B */
0xFBC0,0x884E,0x0000, 0xFBC0,0x884F,0x0000, 0xFBC0,0x8850,0x0000, /* 084E */
0xFBC0,0x8851,0x0000, 0xFBC0,0x8852,0x0000, 0xFBC0,0x8853,0x0000, /* 0851 */
0xFBC0,0x8854,0x0000, 0xFBC0,0x8855,0x0000, 0xFBC0,0x8856,0x0000, /* 0854 */
0xFBC0,0x8857,0x0000, 0xFBC0,0x8858,0x0000, 0xFBC0,0x8859,0x0000, /* 0857 */
0xFBC0,0x885A,0x0000, 0xFBC0,0x885B,0x0000, 0xFBC0,0x885C,0x0000, /* 085A */
0xFBC0,0x885D,0x0000, 0xFBC0,0x885E,0x0000, 0xFBC0,0x885F,0x0000, /* 085D */
0xFBC0,0x8860,0x0000, 0xFBC0,0x8861,0x0000, 0xFBC0,0x8862,0x0000, /* 0860 */
0xFBC0,0x8863,0x0000, 0xFBC0,0x8864,0x0000, 0xFBC0,0x8865,0x0000, /* 0863 */
0xFBC0,0x8866,0x0000, 0xFBC0,0x8867,0x0000, 0xFBC0,0x8868,0x0000, /* 0866 */
0xFBC0,0x8869,0x0000, 0xFBC0,0x886A,0x0000, 0xFBC0,0x886B,0x0000, /* 0869 */
0xFBC0,0x886C,0x0000, 0xFBC0,0x886D,0x0000, 0xFBC0,0x886E,0x0000, /* 086C */
0xFBC0,0x886F,0x0000, 0xFBC0,0x8870,0x0000, 0xFBC0,0x8871,0x0000, /* 086F */
0xFBC0,0x8872,0x0000, 0xFBC0,0x8873,0x0000, 0xFBC0,0x8874,0x0000, /* 0872 */
0xFBC0,0x8875,0x0000, 0xFBC0,0x8876,0x0000, 0xFBC0,0x8877,0x0000, /* 0875 */
0xFBC0,0x8878,0x0000, 0xFBC0,0x8879,0x0000, 0xFBC0,0x887A,0x0000, /* 0878 */
0xFBC0,0x887B,0x0000, 0xFBC0,0x887C,0x0000, 0xFBC0,0x887D,0x0000, /* 087B */
0xFBC0,0x887E,0x0000, 0xFBC0,0x887F,0x0000, 0xFBC0,0x8880,0x0000, /* 087E */
0xFBC0,0x8881,0x0000, 0xFBC0,0x8882,0x0000, 0xFBC0,0x8883,0x0000, /* 0881 */
0xFBC0,0x8884,0x0000, 0xFBC0,0x8885,0x0000, 0xFBC0,0x8886,0x0000, /* 0884 */
0xFBC0,0x8887,0x0000, 0xFBC0,0x8888,0x0000, 0xFBC0,0x8889,0x0000, /* 0887 */
0xFBC0,0x888A,0x0000, 0xFBC0,0x888B,0x0000, 0xFBC0,0x888C,0x0000, /* 088A */
0xFBC0,0x888D,0x0000, 0xFBC0,0x888E,0x0000, 0xFBC0,0x888F,0x0000, /* 088D */
0xFBC0,0x8890,0x0000, 0xFBC0,0x8891,0x0000, 0xFBC0,0x8892,0x0000, /* 0890 */
0xFBC0,0x8893,0x0000, 0xFBC0,0x8894,0x0000, 0xFBC0,0x8895,0x0000, /* 0893 */
0xFBC0,0x8896,0x0000, 0xFBC0,0x8897,0x0000, 0xFBC0,0x8898,0x0000, /* 0896 */
0xFBC0,0x8899,0x0000, 0xFBC0,0x889A,0x0000, 0xFBC0,0x889B,0x0000, /* 0899 */
0xFBC0,0x889C,0x0000, 0xFBC0,0x889D,0x0000, 0xFBC0,0x889E,0x0000, /* 089C */
0xFBC0,0x889F,0x0000, 0xFBC0,0x88A0,0x0000, 0xFBC0,0x88A1,0x0000, /* 089F */
0xFBC0,0x88A2,0x0000, 0xFBC0,0x88A3,0x0000, 0xFBC0,0x88A4,0x0000, /* 08A2 */
0xFBC0,0x88A5,0x0000, 0xFBC0,0x88A6,0x0000, 0xFBC0,0x88A7,0x0000, /* 08A5 */
0xFBC0,0x88A8,0x0000, 0xFBC0,0x88A9,0x0000, 0xFBC0,0x88AA,0x0000, /* 08A8 */
0xFBC0,0x88AB,0x0000, 0xFBC0,0x88AC,0x0000, 0xFBC0,0x88AD,0x0000, /* 08AB */
0xFBC0,0x88AE,0x0000, 0xFBC0,0x88AF,0x0000, 0xFBC0,0x88B0,0x0000, /* 08AE */
0xFBC0,0x88B1,0x0000, 0xFBC0,0x88B2,0x0000, 0xFBC0,0x88B3,0x0000, /* 08B1 */
0xFBC0,0x88B4,0x0000, 0xFBC0,0x88B5,0x0000, 0xFBC0,0x88B6,0x0000, /* 08B4 */
0xFBC0,0x88B7,0x0000, 0xFBC0,0x88B8,0x0000, 0xFBC0,0x88B9,0x0000, /* 08B7 */
0xFBC0,0x88BA,0x0000, 0xFBC0,0x88BB,0x0000, 0xFBC0,0x88BC,0x0000, /* 08BA */
0xFBC0,0x88BD,0x0000, 0xFBC0,0x88BE,0x0000, 0xFBC0,0x88BF,0x0000, /* 08BD */
0xFBC0,0x88C0,0x0000, 0xFBC0,0x88C1,0x0000, 0xFBC0,0x88C2,0x0000, /* 08C0 */
0xFBC0,0x88C3,0x0000, 0xFBC0,0x88C4,0x0000, 0xFBC0,0x88C5,0x0000, /* 08C3 */
0xFBC0,0x88C6,0x0000, 0xFBC0,0x88C7,0x0000, 0xFBC0,0x88C8,0x0000, /* 08C6 */
0xFBC0,0x88C9,0x0000, 0xFBC0,0x88CA,0x0000, 0xFBC0,0x88CB,0x0000, /* 08C9 */
0xFBC0,0x88CC,0x0000, 0xFBC0,0x88CD,0x0000, 0xFBC0,0x88CE,0x0000, /* 08CC */
0xFBC0,0x88CF,0x0000, 0xFBC0,0x88D0,0x0000, 0xFBC0,0x88D1,0x0000, /* 08CF */
0xFBC0,0x88D2,0x0000, 0xFBC0,0x88D3,0x0000, 0xFBC0,0x88D4,0x0000, /* 08D2 */
0xFBC0,0x88D5,0x0000, 0xFBC0,0x88D6,0x0000, 0xFBC0,0x88D7,0x0000, /* 08D5 */
0xFBC0,0x88D8,0x0000, 0xFBC0,0x88D9,0x0000, 0xFBC0,0x88DA,0x0000, /* 08D8 */
0xFBC0,0x88DB,0x0000, 0xFBC0,0x88DC,0x0000, 0xFBC0,0x88DD,0x0000, /* 08DB */
0xFBC0,0x88DE,0x0000, 0xFBC0,0x88DF,0x0000, 0xFBC0,0x88E0,0x0000, /* 08DE */
0xFBC0,0x88E1,0x0000, 0xFBC0,0x88E2,0x0000, 0xFBC0,0x88E3,0x0000, /* 08E1 */
0xFBC0,0x88E4,0x0000, 0xFBC0,0x88E5,0x0000, 0xFBC0,0x88E6,0x0000, /* 08E4 */
0xFBC0,0x88E7,0x0000, 0xFBC0,0x88E8,0x0000, 0xFBC0,0x88E9,0x0000, /* 08E7 */
0xFBC0,0x88EA,0x0000, 0xFBC0,0x88EB,0x0000, 0xFBC0,0x88EC,0x0000, /* 08EA */
0xFBC0,0x88ED,0x0000, 0xFBC0,0x88EE,0x0000, 0xFBC0,0x88EF,0x0000, /* 08ED */
0xFBC0,0x88F0,0x0000, 0xFBC0,0x88F1,0x0000, 0xFBC0,0x88F2,0x0000, /* 08F0 */
0xFBC0,0x88F3,0x0000, 0xFBC0,0x88F4,0x0000, 0xFBC0,0x88F5,0x0000, /* 08F3 */
0xFBC0,0x88F6,0x0000, 0xFBC0,0x88F7,0x0000, 0xFBC0,0x88F8,0x0000, /* 08F6 */
0xFBC0,0x88F9,0x0000, 0xFBC0,0x88FA,0x0000, 0xFBC0,0x88FB,0x0000, /* 08F9 */
0xFBC0,0x88FC,0x0000, 0xFBC0,0x88FD,0x0000, 0xFBC0,0x88FE,0x0000, /* 08FC */
0xFBC0,0x88FF,0x0000  };

uint16 uca520_p009[]= { /* 0900 (3 weights per char) */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0900 */
0x0000,0x0000,0x0000, 0x1BAA,0x0000,0x0000, 0x1BAB,0x0000,0x0000, /* 0903 */
0x1BAC,0x0000,0x0000, 0x1BAD,0x0000,0x0000, 0x1BAE,0x0000,0x0000, /* 0906 */
0x1BAF,0x0000,0x0000, 0x1BB0,0x0000,0x0000, 0x1BB1,0x0000,0x0000, /* 0909 */
0x1BB3,0x0000,0x0000, 0x1BB5,0x0000,0x0000, 0x1BB6,0x0000,0x0000, /* 090C */
0x1BB7,0x0000,0x0000, 0x1BB8,0x0000,0x0000, 0x1BB9,0x0000,0x0000, /* 090F */
0x1BBA,0x0000,0x0000, 0x1BBB,0x0000,0x0000, 0x1BBC,0x0000,0x0000, /* 0912 */
0x1BBD,0x0000,0x0000, 0x1BBE,0x0000,0x0000, 0x1BBF,0x0000,0x0000, /* 0915 */
0x1BC1,0x0000,0x0000, 0x1BC2,0x0000,0x0000, 0x1BC3,0x0000,0x0000, /* 0918 */
0x1BC4,0x0000,0x0000, 0x1BC5,0x0000,0x0000, 0x1BC8,0x0000,0x0000, /* 091B */
0x1BC9,0x0000,0x0000, 0x1BCA,0x0000,0x0000, 0x1BCB,0x0000,0x0000, /* 091E */
0x1BCC,0x0000,0x0000, 0x1BCE,0x0000,0x0000, 0x1BCF,0x0000,0x0000, /* 0921 */
0x1BD0,0x0000,0x0000, 0x1BD1,0x0000,0x0000, 0x1BD2,0x0000,0x0000, /* 0924 */
0x1BD3,0x0000,0x0000, 0x1BD4,0x0000,0x0000, 0x1BD4,0x0000,0x0000, /* 0927 */
0x1BD5,0x0000,0x0000, 0x1BD6,0x0000,0x0000, 0x1BD7,0x0000,0x0000, /* 092A */
0x1BD9,0x0000,0x0000, 0x1BDA,0x0000,0x0000, 0x1BDB,0x0000,0x0000, /* 092D */
0x1BDD,0x0000,0x0000, 0x1BDD,0x0000,0x0000, 0x1BDE,0x0000,0x0000, /* 0930 */
0x1BDF,0x0000,0x0000, 0x1BDF,0x0000,0x0000, 0x1BE0,0x0000,0x0000, /* 0933 */
0x1BE1,0x0000,0x0000, 0x1BE2,0x0000,0x0000, 0x1BE3,0x0000,0x0000, /* 0936 */
0x1BE4,0x0000,0x0000, 0xFBC0,0x893A,0x0000, 0xFBC0,0x893B,0x0000, /* 0939 */
0x0000,0x0000,0x0000, 0x1BE5,0x0000,0x0000, 0x1BEA,0x0000,0x0000, /* 093C */
0x1BEB,0x0000,0x0000, 0x1BEC,0x0000,0x0000, 0x1BED,0x0000,0x0000, /* 093F */
0x1BEE,0x0000,0x0000, 0x1BEF,0x0000,0x0000, 0x1BF0,0x0000,0x0000, /* 0942 */
0x1BF3,0x0000,0x0000, 0x1BF5,0x0000,0x0000, 0x1BF6,0x0000,0x0000, /* 0945 */
0x1BF8,0x0000,0x0000, 0x1BF9,0x0000,0x0000, 0x1BFA,0x0000,0x0000, /* 0948 */
0x1BFB,0x0000,0x0000, 0x1BFC,0x0000,0x0000, 0x1BFD,0x0000,0x0000, /* 094B */
0x1BF7,0x0000,0x0000, 0xFBC0,0x894F,0x0000, 0x1BA8,0x0000,0x0000, /* 094E */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0951 */
0x0000,0x0000,0x0000, 0x1BF4,0x0000,0x0000, 0xFBC0,0x8956,0x0000, /* 0954 */
0xFBC0,0x8957,0x0000, 0x1BBD,0x0000,0x0000, 0x1BBE,0x0000,0x0000, /* 0957 */
0x1BBF,0x0000,0x0000, 0x1BC5,0x0000,0x0000, 0x1BCC,0x0000,0x0000, /* 095A */
0x1BCE,0x0000,0x0000, 0x1BD6,0x0000,0x0000, 0x1BDB,0x0000,0x0000, /* 095D */
0x1BB2,0x0000,0x0000, 0x1BB4,0x0000,0x0000, 0x1BF1,0x0000,0x0000, /* 0960 */
0x1BF2,0x0000,0x0000, 0x0294,0x0000,0x0000, 0x0295,0x0000,0x0000, /* 0963 */
0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 0966 */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, /* 0969 */
0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, /* 096C */
0x120E,0x0000,0x0000, 0x03A1,0x0000,0x0000, 0x11D0,0x0000,0x0000, /* 096F */
0x1BA9,0x0000,0x0000, 0xFBC0,0x8973,0x0000, 0xFBC0,0x8974,0x0000, /* 0972 */
0xFBC0,0x8975,0x0000, 0xFBC0,0x8976,0x0000, 0xFBC0,0x8977,0x0000, /* 0975 */
0xFBC0,0x8978,0x0000, 0x1BC6,0x0000,0x0000, 0x1BDC,0x0000,0x0000, /* 0978 */
0x1BC0,0x0000,0x0000, 0x1BC7,0x0000,0x0000, 0x1BE6,0x0000,0x0000, /* 097B */
0x1BCD,0x0000,0x0000, 0x1BD8,0x0000,0x0000, 0xFBC0,0x8980,0x0000, /* 097E */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0981 */
0xFBC0,0x8984,0x0000, 0x1BFE,0x0000,0x0000, 0x1BFF,0x0000,0x0000, /* 0984 */
0x1C00,0x0000,0x0000, 0x1C01,0x0000,0x0000, 0x1C02,0x0000,0x0000, /* 0987 */
0x1C03,0x0000,0x0000, 0x1C04,0x0000,0x0000, 0x1C06,0x0000,0x0000, /* 098A */
0xFBC0,0x898D,0x0000, 0xFBC0,0x898E,0x0000, 0x1C08,0x0000,0x0000, /* 098D */
0x1C09,0x0000,0x0000, 0xFBC0,0x8991,0x0000, 0xFBC0,0x8992,0x0000, /* 0990 */
0x1C0A,0x0000,0x0000, 0x1C0B,0x0000,0x0000, 0x1C0C,0x0000,0x0000, /* 0993 */
0x1C0D,0x0000,0x0000, 0x1C0E,0x0000,0x0000, 0x1C0F,0x0000,0x0000, /* 0996 */
0x1C10,0x0000,0x0000, 0x1C11,0x0000,0x0000, 0x1C12,0x0000,0x0000, /* 0999 */
0x1C13,0x0000,0x0000, 0x1C14,0x0000,0x0000, 0x1C15,0x0000,0x0000, /* 099C */
0x1C16,0x0000,0x0000, 0x1C17,0x0000,0x0000, 0x1C18,0x0000,0x0000, /* 099F */
0x1C19,0x0000,0x0000, 0x1C1A,0x0000,0x0000, 0x1C1B,0x0000,0x0000, /* 09A2 */
0x1C1C,0x0000,0x0000, 0x1C1D,0x0000,0x0000, 0x1C1E,0x0000,0x0000, /* 09A5 */
0x1C1F,0x0000,0x0000, 0xFBC0,0x89A9,0x0000, 0x1C20,0x0000,0x0000, /* 09A8 */
0x1C21,0x0000,0x0000, 0x1C22,0x0000,0x0000, 0x1C23,0x0000,0x0000, /* 09AB */
0x1C24,0x0000,0x0000, 0x1C25,0x0000,0x0000, 0x1C26,0x0000,0x0000, /* 09AE */
0xFBC0,0x89B1,0x0000, 0x1C28,0x0000,0x0000, 0xFBC0,0x89B3,0x0000, /* 09B1 */
0xFBC0,0x89B4,0x0000, 0xFBC0,0x89B5,0x0000, 0x1C2A,0x0000,0x0000, /* 09B4 */
0x1C2B,0x0000,0x0000, 0x1C2C,0x0000,0x0000, 0x1C2D,0x0000,0x0000, /* 09B7 */
0xFBC0,0x89BA,0x0000, 0xFBC0,0x89BB,0x0000, 0x0000,0x0000,0x0000, /* 09BA */
0x1C2E,0x0000,0x0000, 0x1C2F,0x0000,0x0000, 0x1C30,0x0000,0x0000, /* 09BD */
0x1C31,0x0000,0x0000, 0x1C32,0x0000,0x0000, 0x1C33,0x0000,0x0000, /* 09C0 */
0x1C34,0x0000,0x0000, 0x1C35,0x0000,0x0000, 0xFBC0,0x89C5,0x0000, /* 09C3 */
0xFBC0,0x89C6,0x0000, 0x1C38,0x0000,0x0000, 0x1C39,0x0000,0x0000, /* 09C6 */
0xFBC0,0x89C9,0x0000, 0xFBC0,0x89CA,0x0000, 0x1C3A,0x0000,0x0000, /* 09C9 */
0x1C3B,0x0000,0x0000, 0x1C3C,0x0000,0x0000, 0x1C1B,0x1C3C,0x0000, /* 09CC */
0xFBC0,0x89CF,0x0000, 0xFBC0,0x89D0,0x0000, 0xFBC0,0x89D1,0x0000, /* 09CF */
0xFBC0,0x89D2,0x0000, 0xFBC0,0x89D3,0x0000, 0xFBC0,0x89D4,0x0000, /* 09D2 */
0xFBC0,0x89D5,0x0000, 0xFBC0,0x89D6,0x0000, 0x1C3D,0x0000,0x0000, /* 09D5 */
0xFBC0,0x89D8,0x0000, 0xFBC0,0x89D9,0x0000, 0xFBC0,0x89DA,0x0000, /* 09D8 */
0xFBC0,0x89DB,0x0000, 0x1C18,0x0000,0x0000, 0x1C19,0x0000,0x0000, /* 09DB */
0xFBC0,0x89DE,0x0000, 0x1C25,0x0000,0x0000, 0x1C05,0x0000,0x0000, /* 09DE */
0x1C07,0x0000,0x0000, 0x1C36,0x0000,0x0000, 0x1C37,0x0000,0x0000, /* 09E1 */
0xFBC0,0x89E4,0x0000, 0xFBC0,0x89E5,0x0000, 0x1205,0x0000,0x0000, /* 09E4 */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 09E7 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 09EA */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 09ED */
0x1C27,0x0000,0x0000, 0x1C29,0x0000,0x0000, 0x11E5,0x0000,0x0000, /* 09F0 */
0x11E6,0x0000,0x0000, 0x1110,0x0000,0x0000, 0x1111,0x0000,0x0000, /* 09F3 */
0x1112,0x0000,0x0000, 0x1113,0x0000,0x0000, 0x1114,0x0000,0x0000, /* 09F6 */
0x1115,0x0000,0x0000, 0x0453,0x0000,0x0000, 0x11E7,0x0000,0x0000, /* 09F9 */
0xFBC0,0x89FC,0x0000, 0xFBC0,0x89FD,0x0000, 0xFBC0,0x89FE,0x0000, /* 09FC */
0xFBC0,0x89FF,0x0000  };

uint16 uca520_p00A[]= { /* 0A00 (3 weights per char) */
0xFBC0,0x8A00,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0A00 */
0x0000,0x0000,0x0000, 0xFBC0,0x8A04,0x0000, 0x1C43,0x0000,0x0000, /* 0A03 */
0x1C44,0x0000,0x0000, 0x1C48,0x0000,0x0000, 0x1C49,0x0000,0x0000, /* 0A06 */
0x1C40,0x0000,0x0000, 0x1C41,0x0000,0x0000, 0xFBC0,0x8A0B,0x0000, /* 0A09 */
0xFBC0,0x8A0C,0x0000, 0xFBC0,0x8A0D,0x0000, 0xFBC0,0x8A0E,0x0000, /* 0A0C */
0x1C4A,0x0000,0x0000, 0x1C45,0x0000,0x0000, 0xFBC0,0x8A11,0x0000, /* 0A0F */
0xFBC0,0x8A12,0x0000, 0x1C42,0x0000,0x0000, 0x1C46,0x0000,0x0000, /* 0A12 */
0x1C4E,0x0000,0x0000, 0x1C4F,0x0000,0x0000, 0x1C50,0x0000,0x0000, /* 0A15 */
0x1C51,0x0000,0x0000, 0x1C52,0x0000,0x0000, 0x1C53,0x0000,0x0000, /* 0A18 */
0x1C54,0x0000,0x0000, 0x1C55,0x0000,0x0000, 0x1C56,0x0000,0x0000, /* 0A1B */
0x1C57,0x0000,0x0000, 0x1C58,0x0000,0x0000, 0x1C59,0x0000,0x0000, /* 0A1E */
0x1C5A,0x0000,0x0000, 0x1C5B,0x0000,0x0000, 0x1C5C,0x0000,0x0000, /* 0A21 */
0x1C5D,0x0000,0x0000, 0x1C5E,0x0000,0x0000, 0x1C5F,0x0000,0x0000, /* 0A24 */
0x1C60,0x0000,0x0000, 0x1C61,0x0000,0x0000, 0xFBC0,0x8A29,0x0000, /* 0A27 */
0x1C62,0x0000,0x0000, 0x1C63,0x0000,0x0000, 0x1C64,0x0000,0x0000, /* 0A2A */
0x1C65,0x0000,0x0000, 0x1C66,0x0000,0x0000, 0x1C67,0x0000,0x0000, /* 0A2D */
0x1C69,0x0000,0x0000, 0xFBC0,0x8A31,0x0000, 0x1C6A,0x0000,0x0000, /* 0A30 */
0x1C6A,0x0000,0x0000, 0xFBC0,0x8A34,0x0000, 0x1C6B,0x0000,0x0000, /* 0A33 */
0x1C4B,0x0000,0x0000, 0xFBC0,0x8A37,0x0000, 0x1C4B,0x0000,0x0000, /* 0A36 */
0x1C4C,0x0000,0x0000, 0xFBC0,0x8A3A,0x0000, 0xFBC0,0x8A3B,0x0000, /* 0A39 */
0x0000,0x0000,0x0000, 0xFBC0,0x8A3D,0x0000, 0x1C6D,0x0000,0x0000, /* 0A3C */
0x1C6E,0x0000,0x0000, 0x1C6F,0x0000,0x0000, 0x1C70,0x0000,0x0000, /* 0A3F */
0x1C71,0x0000,0x0000, 0xFBC0,0x8A43,0x0000, 0xFBC0,0x8A44,0x0000, /* 0A42 */
0xFBC0,0x8A45,0x0000, 0xFBC0,0x8A46,0x0000, 0x1C72,0x0000,0x0000, /* 0A45 */
0x1C73,0x0000,0x0000, 0xFBC0,0x8A49,0x0000, 0xFBC0,0x8A4A,0x0000, /* 0A48 */
0x1C74,0x0000,0x0000, 0x1C75,0x0000,0x0000, 0x1C76,0x0000,0x0000, /* 0A4B */
0xFBC0,0x8A4E,0x0000, 0xFBC0,0x8A4F,0x0000, 0xFBC0,0x8A50,0x0000, /* 0A4E */
0x1C4D,0x0000,0x0000, 0xFBC0,0x8A52,0x0000, 0xFBC0,0x8A53,0x0000, /* 0A51 */
0xFBC0,0x8A54,0x0000, 0xFBC0,0x8A55,0x0000, 0xFBC0,0x8A56,0x0000, /* 0A54 */
0xFBC0,0x8A57,0x0000, 0xFBC0,0x8A58,0x0000, 0x1C4F,0x0000,0x0000, /* 0A57 */
0x1C50,0x0000,0x0000, 0x1C55,0x0000,0x0000, 0x1C6C,0x0000,0x0000, /* 0A5A */
0xFBC0,0x8A5D,0x0000, 0x1C63,0x0000,0x0000, 0xFBC0,0x8A5F,0x0000, /* 0A5D */
0xFBC0,0x8A60,0x0000, 0xFBC0,0x8A61,0x0000, 0xFBC0,0x8A62,0x0000, /* 0A60 */
0xFBC0,0x8A63,0x0000, 0xFBC0,0x8A64,0x0000, 0xFBC0,0x8A65,0x0000, /* 0A63 */
0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 0A66 */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, /* 0A69 */
0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, /* 0A6C */
0x120E,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0A6F */
0x1C47,0x0000,0x0000, 0x1C3F,0x0000,0x0000, 0x1C3E,0x0000,0x0000, /* 0A72 */
0x1C68,0x0000,0x0000, 0xFBC0,0x8A76,0x0000, 0xFBC0,0x8A77,0x0000, /* 0A75 */
0xFBC0,0x8A78,0x0000, 0xFBC0,0x8A79,0x0000, 0xFBC0,0x8A7A,0x0000, /* 0A78 */
0xFBC0,0x8A7B,0x0000, 0xFBC0,0x8A7C,0x0000, 0xFBC0,0x8A7D,0x0000, /* 0A7B */
0xFBC0,0x8A7E,0x0000, 0xFBC0,0x8A7F,0x0000, 0xFBC0,0x8A80,0x0000, /* 0A7E */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0A81 */
0xFBC0,0x8A84,0x0000, 0x1C78,0x0000,0x0000, 0x1C79,0x0000,0x0000, /* 0A84 */
0x1C7A,0x0000,0x0000, 0x1C7B,0x0000,0x0000, 0x1C7C,0x0000,0x0000, /* 0A87 */
0x1C7D,0x0000,0x0000, 0x1C7E,0x0000,0x0000, 0x1C80,0x0000,0x0000, /* 0A8A */
0x1C82,0x0000,0x0000, 0xFBC0,0x8A8E,0x0000, 0x1C83,0x0000,0x0000, /* 0A8D */
0x1C84,0x0000,0x0000, 0x1C85,0x0000,0x0000, 0xFBC0,0x8A92,0x0000, /* 0A90 */
0x1C86,0x0000,0x0000, 0x1C87,0x0000,0x0000, 0x1C88,0x0000,0x0000, /* 0A93 */
0x1C89,0x0000,0x0000, 0x1C8A,0x0000,0x0000, 0x1C8B,0x0000,0x0000, /* 0A96 */
0x1C8C,0x0000,0x0000, 0x1C8D,0x0000,0x0000, 0x1C8E,0x0000,0x0000, /* 0A99 */
0x1C8F,0x0000,0x0000, 0x1C90,0x0000,0x0000, 0x1C91,0x0000,0x0000, /* 0A9C */
0x1C92,0x0000,0x0000, 0x1C93,0x0000,0x0000, 0x1C94,0x0000,0x0000, /* 0A9F */
0x1C95,0x0000,0x0000, 0x1C96,0x0000,0x0000, 0x1C97,0x0000,0x0000, /* 0AA2 */
0x1C98,0x0000,0x0000, 0x1C99,0x0000,0x0000, 0x1C9A,0x0000,0x0000, /* 0AA5 */
0x1C9B,0x0000,0x0000, 0xFBC0,0x8AA9,0x0000, 0x1C9C,0x0000,0x0000, /* 0AA8 */
0x1C9D,0x0000,0x0000, 0x1C9E,0x0000,0x0000, 0x1C9F,0x0000,0x0000, /* 0AAB */
0x1CA0,0x0000,0x0000, 0x1CA1,0x0000,0x0000, 0x1CA2,0x0000,0x0000, /* 0AAE */
0xFBC0,0x8AB1,0x0000, 0x1CA3,0x0000,0x0000, 0x1CA9,0x0000,0x0000, /* 0AB1 */
0xFBC0,0x8AB4,0x0000, 0x1CA4,0x0000,0x0000, 0x1CA5,0x0000,0x0000, /* 0AB4 */
0x1CA6,0x0000,0x0000, 0x1CA7,0x0000,0x0000, 0x1CA8,0x0000,0x0000, /* 0AB7 */
0xFBC0,0x8ABA,0x0000, 0xFBC0,0x8ABB,0x0000, 0x0000,0x0000,0x0000, /* 0ABA */
0x1CAA,0x0000,0x0000, 0x1CAB,0x0000,0x0000, 0x1CAC,0x0000,0x0000, /* 0ABD */
0x1CAD,0x0000,0x0000, 0x1CAE,0x0000,0x0000, 0x1CAF,0x0000,0x0000, /* 0AC0 */
0x1CB0,0x0000,0x0000, 0x1CB1,0x0000,0x0000, 0x1CB4,0x0000,0x0000, /* 0AC3 */
0xFBC0,0x8AC6,0x0000, 0x1CB5,0x0000,0x0000, 0x1CB6,0x0000,0x0000, /* 0AC6 */
0x1CB7,0x0000,0x0000, 0xFBC0,0x8ACA,0x0000, 0x1CB8,0x0000,0x0000, /* 0AC9 */
0x1CB9,0x0000,0x0000, 0x1CBA,0x0000,0x0000, 0xFBC0,0x8ACE,0x0000, /* 0ACC */
0xFBC0,0x8ACF,0x0000, 0x1C77,0x0000,0x0000, 0xFBC0,0x8AD1,0x0000, /* 0ACF */
0xFBC0,0x8AD2,0x0000, 0xFBC0,0x8AD3,0x0000, 0xFBC0,0x8AD4,0x0000, /* 0AD2 */
0xFBC0,0x8AD5,0x0000, 0xFBC0,0x8AD6,0x0000, 0xFBC0,0x8AD7,0x0000, /* 0AD5 */
0xFBC0,0x8AD8,0x0000, 0xFBC0,0x8AD9,0x0000, 0xFBC0,0x8ADA,0x0000, /* 0AD8 */
0xFBC0,0x8ADB,0x0000, 0xFBC0,0x8ADC,0x0000, 0xFBC0,0x8ADD,0x0000, /* 0ADB */
0xFBC0,0x8ADE,0x0000, 0xFBC0,0x8ADF,0x0000, 0x1C7F,0x0000,0x0000, /* 0ADE */
0x1C81,0x0000,0x0000, 0x1CB2,0x0000,0x0000, 0x1CB3,0x0000,0x0000, /* 0AE1 */
0xFBC0,0x8AE4,0x0000, 0xFBC0,0x8AE5,0x0000, 0x1205,0x0000,0x0000, /* 0AE4 */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 0AE7 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 0AEA */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 0AED */
0xFBC0,0x8AF0,0x0000, 0x11E8,0x0000,0x0000, 0xFBC0,0x8AF2,0x0000, /* 0AF0 */
0xFBC0,0x8AF3,0x0000, 0xFBC0,0x8AF4,0x0000, 0xFBC0,0x8AF5,0x0000, /* 0AF3 */
0xFBC0,0x8AF6,0x0000, 0xFBC0,0x8AF7,0x0000, 0xFBC0,0x8AF8,0x0000, /* 0AF6 */
0xFBC0,0x8AF9,0x0000, 0xFBC0,0x8AFA,0x0000, 0xFBC0,0x8AFB,0x0000, /* 0AF9 */
0xFBC0,0x8AFC,0x0000, 0xFBC0,0x8AFD,0x0000, 0xFBC0,0x8AFE,0x0000, /* 0AFC */
0xFBC0,0x8AFF,0x0000  };

uint16 uca520_p00B[]= { /* 0B00 (3 weights per char) */
0xFBC0,0x8B00,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0B00 */
0x0000,0x0000,0x0000, 0xFBC0,0x8B04,0x0000, 0x1CBB,0x0000,0x0000, /* 0B03 */
0x1CBC,0x0000,0x0000, 0x1CBD,0x0000,0x0000, 0x1CBE,0x0000,0x0000, /* 0B06 */
0x1CBF,0x0000,0x0000, 0x1CC0,0x0000,0x0000, 0x1CC1,0x0000,0x0000, /* 0B09 */
0x1CC3,0x0000,0x0000, 0xFBC0,0x8B0D,0x0000, 0xFBC0,0x8B0E,0x0000, /* 0B0C */
0x1CC5,0x0000,0x0000, 0x1CC6,0x0000,0x0000, 0xFBC0,0x8B11,0x0000, /* 0B0F */
0xFBC0,0x8B12,0x0000, 0x1CC7,0x0000,0x0000, 0x1CC8,0x0000,0x0000, /* 0B12 */
0x1CC9,0x0000,0x0000, 0x1CCA,0x0000,0x0000, 0x1CCB,0x0000,0x0000, /* 0B15 */
0x1CCC,0x0000,0x0000, 0x1CCD,0x0000,0x0000, 0x1CCE,0x0000,0x0000, /* 0B18 */
0x1CCF,0x0000,0x0000, 0x1CD0,0x0000,0x0000, 0x1CD1,0x0000,0x0000, /* 0B1B */
0x1CD2,0x0000,0x0000, 0x1CD3,0x0000,0x0000, 0x1CD4,0x0000,0x0000, /* 0B1E */
0x1CD5,0x0000,0x0000, 0x1CD6,0x0000,0x0000, 0x1CD7,0x0000,0x0000, /* 0B21 */
0x1CD8,0x0000,0x0000, 0x1CD9,0x0000,0x0000, 0x1CDA,0x0000,0x0000, /* 0B24 */
0x1CDB,0x0000,0x0000, 0x1CDC,0x0000,0x0000, 0xFBC0,0x8B29,0x0000, /* 0B27 */
0x1CDD,0x0000,0x0000, 0x1CDE,0x0000,0x0000, 0x1CDF,0x0000,0x0000, /* 0B2A */
0x1CE0,0x0000,0x0000, 0x1CE1,0x0000,0x0000, 0x1CE2,0x0000,0x0000, /* 0B2D */
0x1CE4,0x0000,0x0000, 0xFBC0,0x8B31,0x0000, 0x1CE5,0x0000,0x0000, /* 0B30 */
0x1CE6,0x0000,0x0000, 0xFBC0,0x8B34,0x0000, 0x1CE7,0x0000,0x0000, /* 0B33 */
0x1CE9,0x0000,0x0000, 0x1CEA,0x0000,0x0000, 0x1CEB,0x0000,0x0000, /* 0B36 */
0x1CEC,0x0000,0x0000, 0xFBC0,0x8B3A,0x0000, 0xFBC0,0x8B3B,0x0000, /* 0B39 */
0x0000,0x0000,0x0000, 0x1CED,0x0000,0x0000, 0x1CEE,0x0000,0x0000, /* 0B3C */
0x1CEF,0x0000,0x0000, 0x1CF0,0x0000,0x0000, 0x1CF1,0x0000,0x0000, /* 0B3F */
0x1CF2,0x0000,0x0000, 0x1CF3,0x0000,0x0000, 0x1CF4,0x0000,0x0000, /* 0B42 */
0xFBC0,0x8B45,0x0000, 0xFBC0,0x8B46,0x0000, 0x1CF7,0x0000,0x0000, /* 0B45 */
0x1CF8,0x0000,0x0000, 0xFBC0,0x8B49,0x0000, 0xFBC0,0x8B4A,0x0000, /* 0B48 */
0x1CF9,0x0000,0x0000, 0x1CFA,0x0000,0x0000, 0x1CFB,0x0000,0x0000, /* 0B4B */
0xFBC0,0x8B4E,0x0000, 0xFBC0,0x8B4F,0x0000, 0xFBC0,0x8B50,0x0000, /* 0B4E */
0xFBC0,0x8B51,0x0000, 0xFBC0,0x8B52,0x0000, 0xFBC0,0x8B53,0x0000, /* 0B51 */
0xFBC0,0x8B54,0x0000, 0xFBC0,0x8B55,0x0000, 0x1CFC,0x0000,0x0000, /* 0B54 */
0x1CFD,0x0000,0x0000, 0xFBC0,0x8B58,0x0000, 0xFBC0,0x8B59,0x0000, /* 0B57 */
0xFBC0,0x8B5A,0x0000, 0xFBC0,0x8B5B,0x0000, 0x1CD5,0x0000,0x0000, /* 0B5A */
0x1CD6,0x0000,0x0000, 0xFBC0,0x8B5E,0x0000, 0x1CE3,0x0000,0x0000, /* 0B5D */
0x1CC2,0x0000,0x0000, 0x1CC4,0x0000,0x0000, 0x1CF5,0x0000,0x0000, /* 0B60 */
0x1CF6,0x0000,0x0000, 0xFBC0,0x8B64,0x0000, 0xFBC0,0x8B65,0x0000, /* 0B63 */
0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 0B66 */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, /* 0B69 */
0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, /* 0B6C */
0x120E,0x0000,0x0000, 0x0454,0x0000,0x0000, 0x1CE8,0x0000,0x0000, /* 0B6F */
0xFBC0,0x8B72,0x0000, 0xFBC0,0x8B73,0x0000, 0xFBC0,0x8B74,0x0000, /* 0B72 */
0xFBC0,0x8B75,0x0000, 0xFBC0,0x8B76,0x0000, 0xFBC0,0x8B77,0x0000, /* 0B75 */
0xFBC0,0x8B78,0x0000, 0xFBC0,0x8B79,0x0000, 0xFBC0,0x8B7A,0x0000, /* 0B78 */
0xFBC0,0x8B7B,0x0000, 0xFBC0,0x8B7C,0x0000, 0xFBC0,0x8B7D,0x0000, /* 0B7B */
0xFBC0,0x8B7E,0x0000, 0xFBC0,0x8B7F,0x0000, 0xFBC0,0x8B80,0x0000, /* 0B7E */
0xFBC0,0x8B81,0x0000, 0x0000,0x0000,0x0000, 0x1D0B,0x0000,0x0000, /* 0B81 */
0xFBC0,0x8B84,0x0000, 0x1CFF,0x0000,0x0000, 0x1D00,0x0000,0x0000, /* 0B84 */
0x1D01,0x0000,0x0000, 0x1D02,0x0000,0x0000, 0x1D03,0x0000,0x0000, /* 0B87 */
0x1D04,0x0000,0x0000, 0xFBC0,0x8B8B,0x0000, 0xFBC0,0x8B8C,0x0000, /* 0B8A */
0xFBC0,0x8B8D,0x0000, 0x1D05,0x0000,0x0000, 0x1D06,0x0000,0x0000, /* 0B8D */
0x1D07,0x0000,0x0000, 0xFBC0,0x8B91,0x0000, 0x1D08,0x0000,0x0000, /* 0B90 */
0x1D09,0x0000,0x0000, 0x1D0A,0x0000,0x0000, 0x1D0C,0x0000,0x0000, /* 0B93 */
0xFBC0,0x8B96,0x0000, 0xFBC0,0x8B97,0x0000, 0xFBC0,0x8B98,0x0000, /* 0B96 */
0x1D0D,0x0000,0x0000, 0x1D0E,0x0000,0x0000, 0xFBC0,0x8B9B,0x0000, /* 0B99 */
0x1D1E,0x0000,0x0000, 0xFBC0,0x8B9D,0x0000, 0x1D0F,0x0000,0x0000, /* 0B9C */
0x1D10,0x0000,0x0000, 0xFBC0,0x8BA0,0x0000, 0xFBC0,0x8BA1,0x0000, /* 0B9F */
0xFBC0,0x8BA2,0x0000, 0x1D11,0x0000,0x0000, 0x1D12,0x0000,0x0000, /* 0BA2 */
0xFBC0,0x8BA5,0x0000, 0xFBC0,0x8BA6,0x0000, 0xFBC0,0x8BA7,0x0000, /* 0BA5 */
0x1D13,0x0000,0x0000, 0x1D1D,0x0000,0x0000, 0x1D14,0x0000,0x0000, /* 0BA8 */
0xFBC0,0x8BAB,0x0000, 0xFBC0,0x8BAC,0x0000, 0xFBC0,0x8BAD,0x0000, /* 0BAB */
0x1D15,0x0000,0x0000, 0x1D16,0x0000,0x0000, 0x1D17,0x0000,0x0000, /* 0BAE */
0x1D1C,0x0000,0x0000, 0x1D18,0x0000,0x0000, 0x1D1B,0x0000,0x0000, /* 0BB1 */
0x1D1A,0x0000,0x0000, 0x1D19,0x0000,0x0000, 0x1D1F,0x0000,0x0000, /* 0BB4 */
0x1D20,0x0000,0x0000, 0x1D21,0x0000,0x0000, 0x1D22,0x0000,0x0000, /* 0BB7 */
0xFBC0,0x8BBA,0x0000, 0xFBC0,0x8BBB,0x0000, 0xFBC0,0x8BBC,0x0000, /* 0BBA */
0xFBC0,0x8BBD,0x0000, 0x1D23,0x0000,0x0000, 0x1D24,0x0000,0x0000, /* 0BBD */
0x1D25,0x0000,0x0000, 0x1D26,0x0000,0x0000, 0x1D27,0x0000,0x0000, /* 0BC0 */
0xFBC0,0x8BC3,0x0000, 0xFBC0,0x8BC4,0x0000, 0xFBC0,0x8BC5,0x0000, /* 0BC3 */
0x1D28,0x0000,0x0000, 0x1D29,0x0000,0x0000, 0x1D2A,0x0000,0x0000, /* 0BC6 */
0xFBC0,0x8BC9,0x0000, 0x1D2B,0x0000,0x0000, 0x1D2C,0x0000,0x0000, /* 0BC9 */
0x1D2D,0x0000,0x0000, 0x1D2E,0x0000,0x0000, 0xFBC0,0x8BCE,0x0000, /* 0BCC */
0xFBC0,0x8BCF,0x0000, 0x1CFE,0x0000,0x0000, 0xFBC0,0x8BD1,0x0000, /* 0BCF */
0xFBC0,0x8BD2,0x0000, 0xFBC0,0x8BD3,0x0000, 0xFBC0,0x8BD4,0x0000, /* 0BD2 */
0xFBC0,0x8BD5,0x0000, 0xFBC0,0x8BD6,0x0000, 0x1D2F,0x0000,0x0000, /* 0BD5 */
0xFBC0,0x8BD8,0x0000, 0xFBC0,0x8BD9,0x0000, 0xFBC0,0x8BDA,0x0000, /* 0BD8 */
0xFBC0,0x8BDB,0x0000, 0xFBC0,0x8BDC,0x0000, 0xFBC0,0x8BDD,0x0000, /* 0BDB */
0xFBC0,0x8BDE,0x0000, 0xFBC0,0x8BDF,0x0000, 0xFBC0,0x8BE0,0x0000, /* 0BDE */
0xFBC0,0x8BE1,0x0000, 0xFBC0,0x8BE2,0x0000, 0xFBC0,0x8BE3,0x0000, /* 0BE1 */
0xFBC0,0x8BE4,0x0000, 0xFBC0,0x8BE5,0x0000, 0x1205,0x0000,0x0000, /* 0BE4 */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 0BE7 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 0BEA */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 0BED */
0x111C,0x0000,0x0000, 0x111D,0x0000,0x0000, 0x111E,0x0000,0x0000, /* 0BF0 */
0x0455,0x0000,0x0000, 0x0456,0x0000,0x0000, 0x0457,0x0000,0x0000, /* 0BF3 */
0x0458,0x0000,0x0000, 0x0459,0x0000,0x0000, 0x045A,0x0000,0x0000, /* 0BF6 */
0x11EA,0x0000,0x0000, 0x045B,0x0000,0x0000, 0xFBC0,0x8BFB,0x0000, /* 0BF9 */
0xFBC0,0x8BFC,0x0000, 0xFBC0,0x8BFD,0x0000, 0xFBC0,0x8BFE,0x0000, /* 0BFC */
0xFBC0,0x8BFF,0x0000  };

uint16 uca520_p00C[]= { /* 0C00 (3 weights per char) */
0xFBC0,0x8C00,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0C00 */
0x0000,0x0000,0x0000, 0xFBC0,0x8C04,0x0000, 0x1D30,0x0000,0x0000, /* 0C03 */
0x1D31,0x0000,0x0000, 0x1D32,0x0000,0x0000, 0x1D33,0x0000,0x0000, /* 0C06 */
0x1D34,0x0000,0x0000, 0x1D35,0x0000,0x0000, 0x1D36,0x0000,0x0000, /* 0C09 */
0x1D38,0x0000,0x0000, 0xFBC0,0x8C0D,0x0000, 0x1D3A,0x0000,0x0000, /* 0C0C */
0x1D3B,0x0000,0x0000, 0x1D3C,0x0000,0x0000, 0xFBC0,0x8C11,0x0000, /* 0C0F */
0x1D3D,0x0000,0x0000, 0x1D3E,0x0000,0x0000, 0x1D3F,0x0000,0x0000, /* 0C12 */
0x1D40,0x0000,0x0000, 0x1D41,0x0000,0x0000, 0x1D42,0x0000,0x0000, /* 0C15 */
0x1D43,0x0000,0x0000, 0x1D44,0x0000,0x0000, 0x1D45,0x0000,0x0000, /* 0C18 */
0x1D47,0x0000,0x0000, 0x1D48,0x0000,0x0000, 0x1D4A,0x0000,0x0000, /* 0C1B */
0x1D4B,0x0000,0x0000, 0x1D4C,0x0000,0x0000, 0x1D4D,0x0000,0x0000, /* 0C1E */
0x1D4E,0x0000,0x0000, 0x1D4F,0x0000,0x0000, 0x1D50,0x0000,0x0000, /* 0C21 */
0x1D51,0x0000,0x0000, 0x1D52,0x0000,0x0000, 0x1D53,0x0000,0x0000, /* 0C24 */
0x1D54,0x0000,0x0000, 0x1D55,0x0000,0x0000, 0xFBC0,0x8C29,0x0000, /* 0C27 */
0x1D56,0x0000,0x0000, 0x1D57,0x0000,0x0000, 0x1D58,0x0000,0x0000, /* 0C2A */
0x1D59,0x0000,0x0000, 0x1D5A,0x0000,0x0000, 0x1D5B,0x0000,0x0000, /* 0C2D */
0x1D5C,0x0000,0x0000, 0x1D5D,0x0000,0x0000, 0x1D5E,0x0000,0x0000, /* 0C30 */
0x1D64,0x0000,0x0000, 0xFBC0,0x8C34,0x0000, 0x1D5F,0x0000,0x0000, /* 0C33 */
0x1D60,0x0000,0x0000, 0x1D61,0x0000,0x0000, 0x1D62,0x0000,0x0000, /* 0C36 */
0x1D63,0x0000,0x0000, 0xFBC0,0x8C3A,0x0000, 0xFBC0,0x8C3B,0x0000, /* 0C39 */
0xFBC0,0x8C3C,0x0000, 0x1D65,0x0000,0x0000, 0x1D66,0x0000,0x0000, /* 0C3C */
0x1D67,0x0000,0x0000, 0x1D68,0x0000,0x0000, 0x1D69,0x0000,0x0000, /* 0C3F */
0x1D6A,0x0000,0x0000, 0x1D6B,0x0000,0x0000, 0x1D6C,0x0000,0x0000, /* 0C42 */
0xFBC0,0x8C45,0x0000, 0x1D6F,0x0000,0x0000, 0x1D70,0x0000,0x0000, /* 0C45 */
0x1D71,0x0000,0x0000, 0xFBC0,0x8C49,0x0000, 0x1D72,0x0000,0x0000, /* 0C48 */
0x1D73,0x0000,0x0000, 0x1D74,0x0000,0x0000, 0x1D75,0x0000,0x0000, /* 0C4B */
0xFBC0,0x8C4E,0x0000, 0xFBC0,0x8C4F,0x0000, 0xFBC0,0x8C50,0x0000, /* 0C4E */
0xFBC0,0x8C51,0x0000, 0xFBC0,0x8C52,0x0000, 0xFBC0,0x8C53,0x0000, /* 0C51 */
0xFBC0,0x8C54,0x0000, 0x1D76,0x0000,0x0000, 0x1D77,0x0000,0x0000, /* 0C54 */
0xFBC0,0x8C57,0x0000, 0x1D46,0x0000,0x0000, 0x1D49,0x0000,0x0000, /* 0C57 */
0xFBC0,0x8C5A,0x0000, 0xFBC0,0x8C5B,0x0000, 0xFBC0,0x8C5C,0x0000, /* 0C5A */
0xFBC0,0x8C5D,0x0000, 0xFBC0,0x8C5E,0x0000, 0xFBC0,0x8C5F,0x0000, /* 0C5D */
0x1D37,0x0000,0x0000, 0x1D39,0x0000,0x0000, 0x1D6D,0x0000,0x0000, /* 0C60 */
0x1D6E,0x0000,0x0000, 0xFBC0,0x8C64,0x0000, 0xFBC0,0x8C65,0x0000, /* 0C63 */
0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 0C66 */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, /* 0C69 */
0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, /* 0C6C */
0x120E,0x0000,0x0000, 0xFBC0,0x8C70,0x0000, 0xFBC0,0x8C71,0x0000, /* 0C6F */
0xFBC0,0x8C72,0x0000, 0xFBC0,0x8C73,0x0000, 0xFBC0,0x8C74,0x0000, /* 0C72 */
0xFBC0,0x8C75,0x0000, 0xFBC0,0x8C76,0x0000, 0xFBC0,0x8C77,0x0000, /* 0C75 */
0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 0C78 */
0x1208,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 0C7B */
0x1208,0x0000,0x0000, 0x045C,0x0000,0x0000, 0xFBC0,0x8C80,0x0000, /* 0C7E */
0xFBC0,0x8C81,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0C81 */
0xFBC0,0x8C84,0x0000, 0x1D78,0x0000,0x0000, 0x1D79,0x0000,0x0000, /* 0C84 */
0x1D7A,0x0000,0x0000, 0x1D7B,0x0000,0x0000, 0x1D7C,0x0000,0x0000, /* 0C87 */
0x1D7D,0x0000,0x0000, 0x1D7E,0x0000,0x0000, 0x1D80,0x0000,0x0000, /* 0C8A */
0xFBC0,0x8C8D,0x0000, 0x1D82,0x0000,0x0000, 0x1D83,0x0000,0x0000, /* 0C8D */
0x1D84,0x0000,0x0000, 0xFBC0,0x8C91,0x0000, 0x1D85,0x0000,0x0000, /* 0C90 */
0x1D86,0x0000,0x0000, 0x1D87,0x0000,0x0000, 0x1D88,0x0000,0x0000, /* 0C93 */
0x1D89,0x0000,0x0000, 0x1D8A,0x0000,0x0000, 0x1D8B,0x0000,0x0000, /* 0C96 */
0x1D8C,0x0000,0x0000, 0x1D8D,0x0000,0x0000, 0x1D8E,0x0000,0x0000, /* 0C99 */
0x1D8F,0x0000,0x0000, 0x1D90,0x0000,0x0000, 0x1D91,0x0000,0x0000, /* 0C9C */
0x1D92,0x0000,0x0000, 0x1D93,0x0000,0x0000, 0x1D94,0x0000,0x0000, /* 0C9F */
0x1D95,0x0000,0x0000, 0x1D96,0x0000,0x0000, 0x1D97,0x0000,0x0000, /* 0CA2 */
0x1D98,0x0000,0x0000, 0x1D99,0x0000,0x0000, 0x1D9A,0x0000,0x0000, /* 0CA5 */
0x1D9B,0x0000,0x0000, 0xFBC0,0x8CA9,0x0000, 0x1D9C,0x0000,0x0000, /* 0CA8 */
0x1D9D,0x0000,0x0000, 0x1D9E,0x0000,0x0000, 0x1D9F,0x0000,0x0000, /* 0CAB */
0x1DA0,0x0000,0x0000, 0x1DA1,0x0000,0x0000, 0x1DA2,0x0000,0x0000, /* 0CAE */
0x1DA3,0x0000,0x0000, 0x1DA4,0x0000,0x0000, 0x1DAA,0x0000,0x0000, /* 0CB1 */
0xFBC0,0x8CB4,0x0000, 0x1DA5,0x0000,0x0000, 0x1DA6,0x0000,0x0000, /* 0CB4 */
0x1DA7,0x0000,0x0000, 0x1DA8,0x0000,0x0000, 0x1DA9,0x0000,0x0000, /* 0CB7 */
0xFBC0,0x8CBA,0x0000, 0xFBC0,0x8CBB,0x0000, 0x0000,0x0000,0x0000, /* 0CBA */
0x1DAC,0x0000,0x0000, 0x1DAD,0x0000,0x0000, 0x1DAE,0x0000,0x0000, /* 0CBD */
0x1DAF,0x0000,0x0000, 0x1DB0,0x0000,0x0000, 0x1DB1,0x0000,0x0000, /* 0CC0 */
0x1DB2,0x0000,0x0000, 0x1DB3,0x0000,0x0000, 0xFBC0,0x8CC5,0x0000, /* 0CC3 */
0x1DB6,0x0000,0x0000, 0x1DB7,0x0000,0x0000, 0x1DB8,0x0000,0x0000, /* 0CC6 */
0xFBC0,0x8CC9,0x0000, 0x1DB9,0x0000,0x0000, 0x1DBA,0x0000,0x0000, /* 0CC9 */
0x1DBB,0x0000,0x0000, 0x1DBC,0x0000,0x0000, 0xFBC0,0x8CCE,0x0000, /* 0CCC */
0xFBC0,0x8CCF,0x0000, 0xFBC0,0x8CD0,0x0000, 0xFBC0,0x8CD1,0x0000, /* 0CCF */
0xFBC0,0x8CD2,0x0000, 0xFBC0,0x8CD3,0x0000, 0xFBC0,0x8CD4,0x0000, /* 0CD2 */
0x1DBD,0x0000,0x0000, 0x1DBE,0x0000,0x0000, 0xFBC0,0x8CD7,0x0000, /* 0CD5 */
0xFBC0,0x8CD8,0x0000, 0xFBC0,0x8CD9,0x0000, 0xFBC0,0x8CDA,0x0000, /* 0CD8 */
0xFBC0,0x8CDB,0x0000, 0xFBC0,0x8CDC,0x0000, 0xFBC0,0x8CDD,0x0000, /* 0CDB */
0x1DAB,0x0000,0x0000, 0xFBC0,0x8CDF,0x0000, 0x1D7F,0x0000,0x0000, /* 0CDE */
0x1D81,0x0000,0x0000, 0x1DB4,0x0000,0x0000, 0x1DB5,0x0000,0x0000, /* 0CE1 */
0xFBC0,0x8CE4,0x0000, 0xFBC0,0x8CE5,0x0000, 0x1205,0x0000,0x0000, /* 0CE4 */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 0CE7 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 0CEA */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 0CED */
0xFBC0,0x8CF0,0x0000, 0x045D,0x0000,0x0000, 0x045E,0x0000,0x0000, /* 0CF0 */
0xFBC0,0x8CF3,0x0000, 0xFBC0,0x8CF4,0x0000, 0xFBC0,0x8CF5,0x0000, /* 0CF3 */
0xFBC0,0x8CF6,0x0000, 0xFBC0,0x8CF7,0x0000, 0xFBC0,0x8CF8,0x0000, /* 0CF6 */
0xFBC0,0x8CF9,0x0000, 0xFBC0,0x8CFA,0x0000, 0xFBC0,0x8CFB,0x0000, /* 0CF9 */
0xFBC0,0x8CFC,0x0000, 0xFBC0,0x8CFD,0x0000, 0xFBC0,0x8CFE,0x0000, /* 0CFC */
0xFBC0,0x8CFF,0x0000  };

uint16 uca520_p00D[]= { /* 0D00 (3 weights per char) */
0xFBC0,0x8D00,0x0000, 0xFBC0,0x8D01,0x0000, 0x0000,0x0000,0x0000, /* 0D00 */
0x0000,0x0000,0x0000, 0xFBC0,0x8D04,0x0000, 0x1DBF,0x0000,0x0000, /* 0D03 */
0x1DC0,0x0000,0x0000, 0x1DC1,0x0000,0x0000, 0x1DC2,0x0000,0x0000, /* 0D06 */
0x1DC3,0x0000,0x0000, 0x1DC4,0x0000,0x0000, 0x1DC5,0x0000,0x0000, /* 0D09 */
0x1DC7,0x0000,0x0000, 0xFBC0,0x8D0D,0x0000, 0x1DC9,0x0000,0x0000, /* 0D0C */
0x1DCA,0x0000,0x0000, 0x1DCB,0x0000,0x0000, 0xFBC0,0x8D11,0x0000, /* 0D0F */
0x1DCC,0x0000,0x0000, 0x1DCD,0x0000,0x0000, 0x1DCE,0x0000,0x0000, /* 0D12 */
0x1DCF,0x0000,0x0000, 0x1DD0,0x0000,0x0000, 0x1DD1,0x0000,0x0000, /* 0D15 */
0x1DD2,0x0000,0x0000, 0x1DD3,0x0000,0x0000, 0x1DD4,0x0000,0x0000, /* 0D18 */
0x1DD5,0x0000,0x0000, 0x1DD6,0x0000,0x0000, 0x1DD7,0x0000,0x0000, /* 0D1B */
0x1DD8,0x0000,0x0000, 0x1DD9,0x0000,0x0000, 0x1DDA,0x0000,0x0000, /* 0D1E */
0x1DDB,0x0000,0x0000, 0x1DDC,0x0000,0x0000, 0x1DDD,0x0000,0x0000, /* 0D21 */
0x1DDE,0x0000,0x0000, 0x1DDF,0x0000,0x0000, 0x1DE0,0x0000,0x0000, /* 0D24 */
0x1DE1,0x0000,0x0000, 0x1DE2,0x0000,0x0000, 0xFBC0,0x8D29,0x0000, /* 0D27 */
0x1DE3,0x0000,0x0000, 0x1DE4,0x0000,0x0000, 0x1DE5,0x0000,0x0000, /* 0D2A */
0x1DE6,0x0000,0x0000, 0x1DE7,0x0000,0x0000, 0x1DE8,0x0000,0x0000, /* 0D2D */
0x1DE9,0x0000,0x0000, 0x1DF2,0x0000,0x0000, 0x1DEA,0x0000,0x0000, /* 0D30 */
0x1DF0,0x0000,0x0000, 0x1DF1,0x0000,0x0000, 0x1DEB,0x0000,0x0000, /* 0D33 */
0x1DEC,0x0000,0x0000, 0x1DED,0x0000,0x0000, 0x1DEE,0x0000,0x0000, /* 0D36 */
0x1DEF,0x0000,0x0000, 0xFBC0,0x8D3A,0x0000, 0xFBC0,0x8D3B,0x0000, /* 0D39 */
0xFBC0,0x8D3C,0x0000, 0x1DF3,0x0000,0x0000, 0x1DF4,0x0000,0x0000, /* 0D3C */
0x1DF5,0x0000,0x0000, 0x1DF6,0x0000,0x0000, 0x1DF7,0x0000,0x0000, /* 0D3F */
0x1DF8,0x0000,0x0000, 0x1DF9,0x0000,0x0000, 0x1DFA,0x0000,0x0000, /* 0D42 */
0xFBC0,0x8D45,0x0000, 0x1DFD,0x0000,0x0000, 0x1DFE,0x0000,0x0000, /* 0D45 */
0x1DFF,0x0000,0x0000, 0xFBC0,0x8D49,0x0000, 0x1E00,0x0000,0x0000, /* 0D48 */
0x1E01,0x0000,0x0000, 0x1E02,0x0000,0x0000, 0x1E04,0x0000,0x0000, /* 0D4B */
0xFBC0,0x8D4E,0x0000, 0xFBC0,0x8D4F,0x0000, 0xFBC0,0x8D50,0x0000, /* 0D4E */
0xFBC0,0x8D51,0x0000, 0xFBC0,0x8D52,0x0000, 0xFBC0,0x8D53,0x0000, /* 0D51 */
0xFBC0,0x8D54,0x0000, 0xFBC0,0x8D55,0x0000, 0xFBC0,0x8D56,0x0000, /* 0D54 */
0x1E03,0x0000,0x0000, 0xFBC0,0x8D58,0x0000, 0xFBC0,0x8D59,0x0000, /* 0D57 */
0xFBC0,0x8D5A,0x0000, 0xFBC0,0x8D5B,0x0000, 0xFBC0,0x8D5C,0x0000, /* 0D5A */
0xFBC0,0x8D5D,0x0000, 0xFBC0,0x8D5E,0x0000, 0xFBC0,0x8D5F,0x0000, /* 0D5D */
0x1DC6,0x0000,0x0000, 0x1DC8,0x0000,0x0000, 0x1DFB,0x0000,0x0000, /* 0D60 */
0x1DFC,0x0000,0x0000, 0xFBC0,0x8D64,0x0000, 0xFBC0,0x8D65,0x0000, /* 0D63 */
0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 0D66 */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, /* 0D69 */
0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, /* 0D6C */
0x120E,0x0000,0x0000, 0x111F,0x0000,0x0000, 0x1120,0x0000,0x0000, /* 0D6F */
0x1121,0x0000,0x0000, 0x1122,0x0000,0x0000, 0x1123,0x0000,0x0000, /* 0D72 */
0x1124,0x0000,0x0000, 0xFBC0,0x8D76,0x0000, 0xFBC0,0x8D77,0x0000, /* 0D75 */
0xFBC0,0x8D78,0x0000, 0x045F,0x0000,0x0000, 0x1DDD,0x1E04,0x0000, /* 0D78 */
0x1DE2,0x1E04,0x0000, 0x1DE9,0x1E04,0x0000, 0x1DEA,0x1E04,0x0000, /* 0D7B */
0x1DF0,0x1E04,0x0000, 0x1DCF,0x1E04,0x0000, 0xFBC0,0x8D80,0x0000, /* 0D7E */
0xFBC0,0x8D81,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0D81 */
0xFBC0,0x8D84,0x0000, 0x1E05,0x0000,0x0000, 0x1E06,0x0000,0x0000, /* 0D84 */
0x1E07,0x0000,0x0000, 0x1E08,0x0000,0x0000, 0x1E09,0x0000,0x0000, /* 0D87 */
0x1E0A,0x0000,0x0000, 0x1E0B,0x0000,0x0000, 0x1E0C,0x0000,0x0000, /* 0D8A */
0x1E0D,0x0000,0x0000, 0x1E0E,0x0000,0x0000, 0x1E0F,0x0000,0x0000, /* 0D8D */
0x1E10,0x0000,0x0000, 0x1E11,0x0000,0x0000, 0x1E12,0x0000,0x0000, /* 0D90 */
0x1E13,0x0000,0x0000, 0x1E14,0x0000,0x0000, 0x1E15,0x0000,0x0000, /* 0D93 */
0x1E16,0x0000,0x0000, 0xFBC0,0x8D97,0x0000, 0xFBC0,0x8D98,0x0000, /* 0D96 */
0xFBC0,0x8D99,0x0000, 0x1E17,0x0000,0x0000, 0x1E18,0x0000,0x0000, /* 0D99 */
0x1E19,0x0000,0x0000, 0x1E1A,0x0000,0x0000, 0x1E1B,0x0000,0x0000, /* 0D9C */
0x1E1C,0x0000,0x0000, 0x1E1D,0x0000,0x0000, 0x1E1E,0x0000,0x0000, /* 0D9F */
0x1E1F,0x0000,0x0000, 0x1E20,0x0000,0x0000, 0x1E21,0x0000,0x0000, /* 0DA2 */
0x1E22,0x0000,0x0000, 0x1E23,0x0000,0x0000, 0x1E24,0x0000,0x0000, /* 0DA5 */
0x1E25,0x0000,0x0000, 0x1E26,0x0000,0x0000, 0x1E27,0x0000,0x0000, /* 0DA8 */
0x1E28,0x0000,0x0000, 0x1E29,0x0000,0x0000, 0x1E2A,0x0000,0x0000, /* 0DAB */
0x1E2B,0x0000,0x0000, 0x1E2C,0x0000,0x0000, 0x1E2D,0x0000,0x0000, /* 0DAE */
0x1E2E,0x0000,0x0000, 0xFBC0,0x8DB2,0x0000, 0x1E2F,0x0000,0x0000, /* 0DB1 */
0x1E30,0x0000,0x0000, 0x1E31,0x0000,0x0000, 0x1E32,0x0000,0x0000, /* 0DB4 */
0x1E33,0x0000,0x0000, 0x1E34,0x0000,0x0000, 0x1E35,0x0000,0x0000, /* 0DB7 */
0x1E36,0x0000,0x0000, 0x1E37,0x0000,0x0000, 0xFBC0,0x8DBC,0x0000, /* 0DBA */
0x1E38,0x0000,0x0000, 0xFBC0,0x8DBE,0x0000, 0xFBC0,0x8DBF,0x0000, /* 0DBD */
0x1E39,0x0000,0x0000, 0x1E3A,0x0000,0x0000, 0x1E3B,0x0000,0x0000, /* 0DC0 */
0x1E3C,0x0000,0x0000, 0x1E3D,0x0000,0x0000, 0x1E3E,0x0000,0x0000, /* 0DC3 */
0x1E3F,0x0000,0x0000, 0xFBC0,0x8DC7,0x0000, 0xFBC0,0x8DC8,0x0000, /* 0DC6 */
0xFBC0,0x8DC9,0x0000, 0x1E51,0x0000,0x0000, 0xFBC0,0x8DCB,0x0000, /* 0DC9 */
0xFBC0,0x8DCC,0x0000, 0xFBC0,0x8DCD,0x0000, 0xFBC0,0x8DCE,0x0000, /* 0DCC */
0x1E40,0x0000,0x0000, 0x1E41,0x0000,0x0000, 0x1E42,0x0000,0x0000, /* 0DCF */
0x1E43,0x0000,0x0000, 0x1E44,0x0000,0x0000, 0x1E45,0x0000,0x0000, /* 0DD2 */
0xFBC0,0x8DD5,0x0000, 0x1E46,0x0000,0x0000, 0xFBC0,0x8DD7,0x0000, /* 0DD5 */
0x1E47,0x0000,0x0000, 0x1E4B,0x0000,0x0000, 0x1E4C,0x0000,0x0000, /* 0DD8 */
0x1E4D,0x0000,0x0000, 0x1E4E,0x0000,0x0000, 0x1E4F,0x0000,0x0000, /* 0DDB */
0x1E50,0x0000,0x0000, 0x1E49,0x0000,0x0000, 0xFBC0,0x8DE0,0x0000, /* 0DDE */
0xFBC0,0x8DE1,0x0000, 0xFBC0,0x8DE2,0x0000, 0xFBC0,0x8DE3,0x0000, /* 0DE1 */
0xFBC0,0x8DE4,0x0000, 0xFBC0,0x8DE5,0x0000, 0xFBC0,0x8DE6,0x0000, /* 0DE4 */
0xFBC0,0x8DE7,0x0000, 0xFBC0,0x8DE8,0x0000, 0xFBC0,0x8DE9,0x0000, /* 0DE7 */
0xFBC0,0x8DEA,0x0000, 0xFBC0,0x8DEB,0x0000, 0xFBC0,0x8DEC,0x0000, /* 0DEA */
0xFBC0,0x8DED,0x0000, 0xFBC0,0x8DEE,0x0000, 0xFBC0,0x8DEF,0x0000, /* 0DED */
0xFBC0,0x8DF0,0x0000, 0xFBC0,0x8DF1,0x0000, 0x1E48,0x0000,0x0000, /* 0DF0 */
0x1E4A,0x0000,0x0000, 0x03A5,0x0000,0x0000, 0xFBC0,0x8DF5,0x0000, /* 0DF3 */
0xFBC0,0x8DF6,0x0000, 0xFBC0,0x8DF7,0x0000, 0xFBC0,0x8DF8,0x0000, /* 0DF6 */
0xFBC0,0x8DF9,0x0000, 0xFBC0,0x8DFA,0x0000, 0xFBC0,0x8DFB,0x0000, /* 0DF9 */
0xFBC0,0x8DFC,0x0000, 0xFBC0,0x8DFD,0x0000, 0xFBC0,0x8DFE,0x0000, /* 0DFC */
0xFBC0,0x8DFF,0x0000  };

uint16 uca520_p00E[]= { /* 0E00 (3 weights per char) */
0xFBC0,0x8E00,0x0000, 0x1F70,0x0000,0x0000, 0x1F71,0x0000,0x0000, /* 0E00 */
0x1F72,0x0000,0x0000, 0x1F73,0x0000,0x0000, 0x1F74,0x0000,0x0000, /* 0E03 */
0x1F75,0x0000,0x0000, 0x1F76,0x0000,0x0000, 0x1F77,0x0000,0x0000, /* 0E06 */
0x1F78,0x0000,0x0000, 0x1F79,0x0000,0x0000, 0x1F7A,0x0000,0x0000, /* 0E09 */
0x1F7B,0x0000,0x0000, 0x1F7C,0x0000,0x0000, 0x1F7D,0x0000,0x0000, /* 0E0C */
0x1F7E,0x0000,0x0000, 0x1F7F,0x0000,0x0000, 0x1F80,0x0000,0x0000, /* 0E0F */
0x1F81,0x0000,0x0000, 0x1F82,0x0000,0x0000, 0x1F83,0x0000,0x0000, /* 0E12 */
0x1F84,0x0000,0x0000, 0x1F85,0x0000,0x0000, 0x1F86,0x0000,0x0000, /* 0E15 */
0x1F87,0x0000,0x0000, 0x1F88,0x0000,0x0000, 0x1F89,0x0000,0x0000, /* 0E18 */
0x1F8A,0x0000,0x0000, 0x1F8B,0x0000,0x0000, 0x1F8C,0x0000,0x0000, /* 0E1B */
0x1F8D,0x0000,0x0000, 0x1F8E,0x0000,0x0000, 0x1F8F,0x0000,0x0000, /* 0E1E */
0x1F90,0x0000,0x0000, 0x1F91,0x0000,0x0000, 0x1F92,0x0000,0x0000, /* 0E21 */
0x1F93,0x0000,0x0000, 0x1F94,0x0000,0x0000, 0x1F95,0x0000,0x0000, /* 0E24 */
0x1F96,0x0000,0x0000, 0x1F97,0x0000,0x0000, 0x1F98,0x0000,0x0000, /* 0E27 */
0x1F99,0x0000,0x0000, 0x1F9A,0x0000,0x0000, 0x1F9B,0x0000,0x0000, /* 0E2A */
0x1F9C,0x0000,0x0000, 0x1F9D,0x0000,0x0000, 0x1F9E,0x0000,0x0000, /* 0E2D */
0x1F9F,0x0000,0x0000, 0x1FA0,0x0000,0x0000, 0x1FA1,0x0000,0x0000, /* 0E30 */
0x1FA2,0x0000,0x0000, 0x1FA3,0x0000,0x0000, 0x1FA4,0x0000,0x0000, /* 0E33 */
0x1FA5,0x0000,0x0000, 0x1FA6,0x0000,0x0000, 0x1FA7,0x0000,0x0000, /* 0E36 */
0x1FA8,0x0000,0x0000, 0x1FA9,0x0000,0x0000, 0xFBC0,0x8E3B,0x0000, /* 0E39 */
0xFBC0,0x8E3C,0x0000, 0xFBC0,0x8E3D,0x0000, 0xFBC0,0x8E3E,0x0000, /* 0E3C */
0x11EB,0x0000,0x0000, 0x1FAA,0x0000,0x0000, 0x1FAB,0x0000,0x0000, /* 0E3F */
0x1FAC,0x0000,0x0000, 0x1FAD,0x0000,0x0000, 0x1FAE,0x0000,0x0000, /* 0E42 */
0x1FAF,0x0000,0x0000, 0x11D1,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0E45 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0E48 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0E4B */
0x0000,0x0000,0x0000, 0x0467,0x0000,0x0000, 0x1205,0x0000,0x0000, /* 0E4E */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 0E51 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 0E54 */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 0E57 */
0x03A6,0x0000,0x0000, 0x03A7,0x0000,0x0000, 0xFBC0,0x8E5C,0x0000, /* 0E5A */
0xFBC0,0x8E5D,0x0000, 0xFBC0,0x8E5E,0x0000, 0xFBC0,0x8E5F,0x0000, /* 0E5D */
0xFBC0,0x8E60,0x0000, 0xFBC0,0x8E61,0x0000, 0xFBC0,0x8E62,0x0000, /* 0E60 */
0xFBC0,0x8E63,0x0000, 0xFBC0,0x8E64,0x0000, 0xFBC0,0x8E65,0x0000, /* 0E63 */
0xFBC0,0x8E66,0x0000, 0xFBC0,0x8E67,0x0000, 0xFBC0,0x8E68,0x0000, /* 0E66 */
0xFBC0,0x8E69,0x0000, 0xFBC0,0x8E6A,0x0000, 0xFBC0,0x8E6B,0x0000, /* 0E69 */
0xFBC0,0x8E6C,0x0000, 0xFBC0,0x8E6D,0x0000, 0xFBC0,0x8E6E,0x0000, /* 0E6C */
0xFBC0,0x8E6F,0x0000, 0xFBC0,0x8E70,0x0000, 0xFBC0,0x8E71,0x0000, /* 0E6F */
0xFBC0,0x8E72,0x0000, 0xFBC0,0x8E73,0x0000, 0xFBC0,0x8E74,0x0000, /* 0E72 */
0xFBC0,0x8E75,0x0000, 0xFBC0,0x8E76,0x0000, 0xFBC0,0x8E77,0x0000, /* 0E75 */
0xFBC0,0x8E78,0x0000, 0xFBC0,0x8E79,0x0000, 0xFBC0,0x8E7A,0x0000, /* 0E78 */
0xFBC0,0x8E7B,0x0000, 0xFBC0,0x8E7C,0x0000, 0xFBC0,0x8E7D,0x0000, /* 0E7B */
0xFBC0,0x8E7E,0x0000, 0xFBC0,0x8E7F,0x0000, 0xFBC0,0x8E80,0x0000, /* 0E7E */
0x1FB0,0x0000,0x0000, 0x1FB1,0x0000,0x0000, 0xFBC0,0x8E83,0x0000, /* 0E81 */
0x1FB2,0x0000,0x0000, 0xFBC0,0x8E85,0x0000, 0xFBC0,0x8E86,0x0000, /* 0E84 */
0x1FB3,0x0000,0x0000, 0x1FB4,0x0000,0x0000, 0xFBC0,0x8E89,0x0000, /* 0E87 */
0x1FB6,0x0000,0x0000, 0xFBC0,0x8E8B,0x0000, 0xFBC0,0x8E8C,0x0000, /* 0E8A */
0x1FB7,0x0000,0x0000, 0xFBC0,0x8E8E,0x0000, 0xFBC0,0x8E8F,0x0000, /* 0E8D */
0xFBC0,0x8E90,0x0000, 0xFBC0,0x8E91,0x0000, 0xFBC0,0x8E92,0x0000, /* 0E90 */
0xFBC0,0x8E93,0x0000, 0x1FB8,0x0000,0x0000, 0x1FB9,0x0000,0x0000, /* 0E93 */
0x1FBA,0x0000,0x0000, 0x1FBB,0x0000,0x0000, 0xFBC0,0x8E98,0x0000, /* 0E96 */
0x1FBC,0x0000,0x0000, 0x1FBD,0x0000,0x0000, 0x1FBE,0x0000,0x0000, /* 0E99 */
0x1FBF,0x0000,0x0000, 0x1FC0,0x0000,0x0000, 0x1FC1,0x0000,0x0000, /* 0E9C */
0x1FC2,0x0000,0x0000, 0xFBC0,0x8EA0,0x0000, 0x1FC3,0x0000,0x0000, /* 0E9F */
0x1FC4,0x0000,0x0000, 0x1FC5,0x0000,0x0000, 0xFBC0,0x8EA4,0x0000, /* 0EA2 */
0x1FC6,0x0000,0x0000, 0xFBC0,0x8EA6,0x0000, 0x1FC7,0x0000,0x0000, /* 0EA5 */
0xFBC0,0x8EA8,0x0000, 0xFBC0,0x8EA9,0x0000, 0x1FB5,0x0000,0x0000, /* 0EA8 */
0x1FC8,0x0000,0x0000, 0xFBC0,0x8EAC,0x0000, 0x1FC9,0x0000,0x0000, /* 0EAB */
0x1FCA,0x0000,0x0000, 0x1FCB,0x0000,0x0000, 0x1FCC,0x0000,0x0000, /* 0EAE */
0x1FCD,0x0000,0x0000, 0x1FCE,0x0000,0x0000, 0x1FCF,0x0000,0x0000, /* 0EB1 */
0x1FD0,0x0000,0x0000, 0x1FD1,0x0000,0x0000, 0x1FD2,0x0000,0x0000, /* 0EB4 */
0x1FD3,0x0000,0x0000, 0x1FD4,0x0000,0x0000, 0x1FD5,0x0000,0x0000, /* 0EB7 */
0xFBC0,0x8EBA,0x0000, 0x1FD6,0x0000,0x0000, 0x1FD7,0x0000,0x0000, /* 0EBA */
0x1FD8,0x0000,0x0000, 0xFBC0,0x8EBE,0x0000, 0xFBC0,0x8EBF,0x0000, /* 0EBD */
0x1FD9,0x0000,0x0000, 0x1FDA,0x0000,0x0000, 0x1FDB,0x0000,0x0000, /* 0EC0 */
0x1FDC,0x0000,0x0000, 0x1FDD,0x0000,0x0000, 0xFBC0,0x8EC5,0x0000, /* 0EC3 */
0x11D2,0x0000,0x0000, 0xFBC0,0x8EC7,0x0000, 0x0000,0x0000,0x0000, /* 0EC6 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0EC9 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0xFBC0,0x8ECE,0x0000, /* 0ECC */
0xFBC0,0x8ECF,0x0000, 0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, /* 0ECF */
0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, /* 0ED2 */
0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, /* 0ED5 */
0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, 0xFBC0,0x8EDA,0x0000, /* 0ED8 */
0xFBC0,0x8EDB,0x0000, 0x1FC8,0x1FBC,0x0000, 0x1FC8,0x1FC3,0x0000, /* 0EDB */
0xFBC0,0x8EDE,0x0000, 0xFBC0,0x8EDF,0x0000, 0xFBC0,0x8EE0,0x0000, /* 0EDE */
0xFBC0,0x8EE1,0x0000, 0xFBC0,0x8EE2,0x0000, 0xFBC0,0x8EE3,0x0000, /* 0EE1 */
0xFBC0,0x8EE4,0x0000, 0xFBC0,0x8EE5,0x0000, 0xFBC0,0x8EE6,0x0000, /* 0EE4 */
0xFBC0,0x8EE7,0x0000, 0xFBC0,0x8EE8,0x0000, 0xFBC0,0x8EE9,0x0000, /* 0EE7 */
0xFBC0,0x8EEA,0x0000, 0xFBC0,0x8EEB,0x0000, 0xFBC0,0x8EEC,0x0000, /* 0EEA */
0xFBC0,0x8EED,0x0000, 0xFBC0,0x8EEE,0x0000, 0xFBC0,0x8EEF,0x0000, /* 0EED */
0xFBC0,0x8EF0,0x0000, 0xFBC0,0x8EF1,0x0000, 0xFBC0,0x8EF2,0x0000, /* 0EF0 */
0xFBC0,0x8EF3,0x0000, 0xFBC0,0x8EF4,0x0000, 0xFBC0,0x8EF5,0x0000, /* 0EF3 */
0xFBC0,0x8EF6,0x0000, 0xFBC0,0x8EF7,0x0000, 0xFBC0,0x8EF8,0x0000, /* 0EF6 */
0xFBC0,0x8EF9,0x0000, 0xFBC0,0x8EFA,0x0000, 0xFBC0,0x8EFB,0x0000, /* 0EF9 */
0xFBC0,0x8EFC,0x0000, 0xFBC0,0x8EFD,0x0000, 0xFBC0,0x8EFE,0x0000, /* 0EFC */
0xFBC0,0x8EFF,0x0000  };

uint16 uca520_p00F[]= { /* 0F00 (3 weights per char) */
0x2067,0x207A,0x0000, 0x0468,0x0000,0x0000, 0x0469,0x0000,0x0000, /* 0F00 */
0x046A,0x0000,0x0000, 0x03AA,0x0000,0x0000, 0x03AB,0x0000,0x0000, /* 0F03 */
0x03AC,0x0000,0x0000, 0x03AD,0x0000,0x0000, 0x03AE,0x0000,0x0000, /* 0F06 */
0x03AF,0x0000,0x0000, 0x03B0,0x0000,0x0000, 0x03B3,0x0000,0x0000, /* 0F09 */
0x03B3,0x0000,0x0000, 0x03B4,0x0000,0x0000, 0x03B5,0x0000,0x0000, /* 0F0C */
0x03B6,0x0000,0x0000, 0x03B7,0x0000,0x0000, 0x03B8,0x0000,0x0000, /* 0F0F */
0x03B9,0x0000,0x0000, 0x046B,0x0000,0x0000, 0x0266,0x0000,0x0000, /* 0F12 */
0x046C,0x0000,0x0000, 0x046D,0x0000,0x0000, 0x046E,0x0000,0x0000, /* 0F15 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x046F,0x0000,0x0000, /* 0F18 */
0x0470,0x0000,0x0000, 0x0471,0x0000,0x0000, 0x0472,0x0000,0x0000, /* 0F1B */
0x0473,0x0000,0x0000, 0x0474,0x0000,0x0000, 0x1205,0x0000,0x0000, /* 0F1E */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 0F21 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 0F24 */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 0F27 */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 0F2A */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 0F2D */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 0F30 */
0x1205,0x0000,0x0000, 0x0475,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0F33 */
0x0476,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0477,0x0000,0x0000, /* 0F36 */
0x0000,0x0000,0x0000, 0x0305,0x0000,0x0000, 0x0306,0x0000,0x0000, /* 0F39 */
0x0307,0x0000,0x0000, 0x0308,0x0000,0x0000, 0x0478,0x0000,0x0000, /* 0F3C */
0x0479,0x0000,0x0000, 0x2021,0x0000,0x0000, 0x2024,0x0000,0x0000, /* 0F3F */
0x2026,0x0000,0x0000, 0x2026,0x2066,0x0000, 0x2028,0x0000,0x0000, /* 0F42 */
0x202A,0x0000,0x0000, 0x202C,0x0000,0x0000, 0x202E,0x0000,0x0000, /* 0F45 */
0xFBC0,0x8F48,0x0000, 0x2030,0x0000,0x0000, 0x2032,0x0000,0x0000, /* 0F48 */
0x2034,0x0000,0x0000, 0x2036,0x0000,0x0000, 0x2036,0x2066,0x0000, /* 0F4B */
0x2038,0x0000,0x0000, 0x203A,0x0000,0x0000, 0x203C,0x0000,0x0000, /* 0F4E */
0x203E,0x0000,0x0000, 0x203E,0x2066,0x0000, 0x2040,0x0000,0x0000, /* 0F51 */
0x2042,0x0000,0x0000, 0x2044,0x0000,0x0000, 0x2046,0x0000,0x0000, /* 0F54 */
0x2046,0x2066,0x0000, 0x2048,0x0000,0x0000, 0x204A,0x0000,0x0000, /* 0F57 */
0x204C,0x0000,0x0000, 0x204E,0x0000,0x0000, 0x204E,0x2066,0x0000, /* 0F5A */
0x2050,0x0000,0x0000, 0x2052,0x0000,0x0000, 0x2054,0x0000,0x0000, /* 0F5D */
0x2056,0x0000,0x0000, 0x2058,0x0000,0x0000, 0x205A,0x0000,0x0000, /* 0F60 */
0x205D,0x0000,0x0000, 0x205F,0x0000,0x0000, 0x2061,0x0000,0x0000, /* 0F63 */
0x2063,0x0000,0x0000, 0x2065,0x0000,0x0000, 0x2067,0x0000,0x0000, /* 0F66 */
0x2021,0x2062,0x0000, 0x205A,0x0000,0x0000, 0x2023,0x0000,0x0000, /* 0F69 */
0x205C,0x0000,0x0000, 0xFBC0,0x8F6D,0x0000, 0xFBC0,0x8F6E,0x0000, /* 0F6C */
0xFBC0,0x8F6F,0x0000, 0xFBC0,0x8F70,0x0000, 0x206D,0x0000,0x0000, /* 0F6F */
0x206E,0x0000,0x0000, 0x206F,0x0000,0x0000, 0x2072,0x0000,0x0000, /* 0F72 */
0x2073,0x0000,0x0000, 0x2074,0x0000,0x0000, 0x2075,0x0000,0x0000, /* 0F75 */
0x2076,0x0000,0x0000, 0x2077,0x0000,0x0000, 0x2078,0x0000,0x0000, /* 0F78 */
0x2079,0x0000,0x0000, 0x207A,0x0000,0x0000, 0x207B,0x0000,0x0000, /* 0F7B */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x2070,0x0000,0x0000, /* 0F7E */
0x2071,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0F81 */
0x207C,0x0000,0x0000, 0x03BA,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 0F84 */
0x0000,0x0000,0x0000, 0x2069,0x0000,0x0000, 0x206A,0x0000,0x0000, /* 0F87 */
0x206B,0x0000,0x0000, 0x206C,0x0000,0x0000, 0xFBC0,0x8F8C,0x0000, /* 0F8A */
0xFBC0,0x8F8D,0x0000, 0xFBC0,0x8F8E,0x0000, 0xFBC0,0x8F8F,0x0000, /* 0F8D */
0x2022,0x0000,0x0000, 0x2025,0x0000,0x0000, 0x2027,0x0000,0x0000, /* 0F90 */
0x2027,0x2066,0x0000, 0x2029,0x0000,0x0000, 0x202B,0x0000,0x0000, /* 0F93 */
0x202D,0x0000,0x0000, 0x202F,0x0000,0x0000, 0xFBC0,0x8F98,0x0000, /* 0F96 */
0x2031,0x0000,0x0000, 0x2033,0x0000,0x0000, 0x2035,0x0000,0x0000, /* 0F99 */
0x2037,0x0000,0x0000, 0x2037,0x2066,0x0000, 0x2039,0x0000,0x0000, /* 0F9C */
0x203B,0x0000,0x0000, 0x203D,0x0000,0x0000, 0x203F,0x0000,0x0000, /* 0F9F */
0x203F,0x2066,0x0000, 0x2041,0x0000,0x0000, 0x2043,0x0000,0x0000, /* 0FA2 */
0x2045,0x0000,0x0000, 0x2047,0x0000,0x0000, 0x2047,0x2066,0x0000, /* 0FA5 */
0x2049,0x0000,0x0000, 0x204B,0x0000,0x0000, 0x204D,0x0000,0x0000, /* 0FA8 */
0x204F,0x0000,0x0000, 0x204F,0x2066,0x0000, 0x2051,0x0000,0x0000, /* 0FAB */
0x2053,0x0000,0x0000, 0x2055,0x0000,0x0000, 0x2057,0x0000,0x0000, /* 0FAE */
0x2059,0x0000,0x0000, 0x205B,0x0000,0x0000, 0x205E,0x0000,0x0000, /* 0FB1 */
0x2060,0x0000,0x0000, 0x2062,0x0000,0x0000, 0x2064,0x0000,0x0000, /* 0FB4 */
0x2066,0x0000,0x0000, 0x2068,0x0000,0x0000, 0x2022,0x2062,0x0000, /* 0FB7 */
0x2051,0x0000,0x0000, 0x2059,0x0000,0x0000, 0x205B,0x0000,0x0000, /* 0FBA */
0xFBC0,0x8FBD,0x0000, 0x047A,0x0000,0x0000, 0x047B,0x0000,0x0000, /* 0FBD */
0x047C,0x0000,0x0000, 0x047D,0x0000,0x0000, 0x047E,0x0000,0x0000, /* 0FC0 */
0x047F,0x0000,0x0000, 0x0480,0x0000,0x0000, 0x0481,0x0000,0x0000, /* 0FC3 */
0x0000,0x0000,0x0000, 0x0482,0x0000,0x0000, 0x0483,0x0000,0x0000, /* 0FC6 */
0x0484,0x0000,0x0000, 0x0485,0x0000,0x0000, 0x0486,0x0000,0x0000, /* 0FC9 */
0x0487,0x0000,0x0000, 0xFBC0,0x8FCD,0x0000, 0x0488,0x0000,0x0000, /* 0FCC */
0x0489,0x0000,0x0000, 0x03B1,0x0000,0x0000, 0x03B2,0x0000,0x0000, /* 0FCF */
0x03BB,0x0000,0x0000, 0x03BC,0x0000,0x0000, 0x03BD,0x0000,0x0000, /* 0FD2 */
0x048A,0x0000,0x0000, 0x048B,0x0000,0x0000, 0x048C,0x0000,0x0000, /* 0FD5 */
0x048D,0x0000,0x0000, 0xFBC0,0x8FD9,0x0000, 0xFBC0,0x8FDA,0x0000, /* 0FD8 */
0xFBC0,0x8FDB,0x0000, 0xFBC0,0x8FDC,0x0000, 0xFBC0,0x8FDD,0x0000, /* 0FDB */
0xFBC0,0x8FDE,0x0000, 0xFBC0,0x8FDF,0x0000, 0xFBC0,0x8FE0,0x0000, /* 0FDE */
0xFBC0,0x8FE1,0x0000, 0xFBC0,0x8FE2,0x0000, 0xFBC0,0x8FE3,0x0000, /* 0FE1 */
0xFBC0,0x8FE4,0x0000, 0xFBC0,0x8FE5,0x0000, 0xFBC0,0x8FE6,0x0000, /* 0FE4 */
0xFBC0,0x8FE7,0x0000, 0xFBC0,0x8FE8,0x0000, 0xFBC0,0x8FE9,0x0000, /* 0FE7 */
0xFBC0,0x8FEA,0x0000, 0xFBC0,0x8FEB,0x0000, 0xFBC0,0x8FEC,0x0000, /* 0FEA */
0xFBC0,0x8FED,0x0000, 0xFBC0,0x8FEE,0x0000, 0xFBC0,0x8FEF,0x0000, /* 0FED */
0xFBC0,0x8FF0,0x0000, 0xFBC0,0x8FF1,0x0000, 0xFBC0,0x8FF2,0x0000, /* 0FF0 */
0xFBC0,0x8FF3,0x0000, 0xFBC0,0x8FF4,0x0000, 0xFBC0,0x8FF5,0x0000, /* 0FF3 */
0xFBC0,0x8FF6,0x0000, 0xFBC0,0x8FF7,0x0000, 0xFBC0,0x8FF8,0x0000, /* 0FF6 */
0xFBC0,0x8FF9,0x0000, 0xFBC0,0x8FFA,0x0000, 0xFBC0,0x8FFB,0x0000, /* 0FF9 */
0xFBC0,0x8FFC,0x0000, 0xFBC0,0x8FFD,0x0000, 0xFBC0,0x8FFE,0x0000, /* 0FFC */
0xFBC0,0x8FFF,0x0000  };

uint16 uca520_p010[]= { /* 1000 (4 weights per char) */
0x21CD,0x0000,0x0000,0x0000, 0x21CF,0x0000,0x0000,0x0000, /* 1000 */
0x21D1,0x0000,0x0000,0x0000, 0x21D4,0x0000,0x0000,0x0000, /* 1002 */
0x21D5,0x0000,0x0000,0x0000, 0x21D7,0x0000,0x0000,0x0000, /* 1004 */
0x21DA,0x0000,0x0000,0x0000, 0x21DC,0x0000,0x0000,0x0000, /* 1006 */
0x21E0,0x0000,0x0000,0x0000, 0x21E4,0x0000,0x0000,0x0000, /* 1008 */
0x21E7,0x0000,0x0000,0x0000, 0x21E8,0x0000,0x0000,0x0000, /* 100A */
0x21EA,0x0000,0x0000,0x0000, 0x21EC,0x0000,0x0000,0x0000, /* 100C */
0x21EE,0x0000,0x0000,0x0000, 0x21F0,0x0000,0x0000,0x0000, /* 100E */
0x21F2,0x0000,0x0000,0x0000, 0x21F3,0x0000,0x0000,0x0000, /* 1010 */
0x21F4,0x0000,0x0000,0x0000, 0x21F6,0x0000,0x0000,0x0000, /* 1012 */
0x21F8,0x0000,0x0000,0x0000, 0x21FC,0x0000,0x0000,0x0000, /* 1014 */
0x21FD,0x0000,0x0000,0x0000, 0x2202,0x0000,0x0000,0x0000, /* 1016 */
0x2204,0x0000,0x0000,0x0000, 0x2205,0x0000,0x0000,0x0000, /* 1018 */
0x2207,0x0000,0x0000,0x0000, 0x2209,0x0000,0x0000,0x0000, /* 101A */
0x220D,0x0000,0x0000,0x0000, 0x220F,0x0000,0x0000,0x0000, /* 101C */
0x2216,0x0000,0x0000,0x0000, 0x2218,0x0000,0x0000,0x0000, /* 101E */
0x221E,0x0000,0x0000,0x0000, 0x2224,0x0000,0x0000,0x0000, /* 1020 */
0x2225,0x0000,0x0000,0x0000, 0x2226,0x0000,0x0000,0x0000, /* 1022 */
0x2227,0x0000,0x0000,0x0000, 0x2228,0x0000,0x0000,0x0000, /* 1024 */
0x2229,0x0000,0x0000,0x0000, 0x222E,0x0000,0x0000,0x0000, /* 1026 */
0x222F,0x0000,0x0000,0x0000, 0x2230,0x0000,0x0000,0x0000, /* 1028 */
0x2231,0x0000,0x0000,0x0000, 0x2232,0x0000,0x0000,0x0000, /* 102A */
0x2232,0x0000,0x0000,0x0000, 0x2236,0x0000,0x0000,0x0000, /* 102C */
0x2238,0x0000,0x0000,0x0000, 0x223A,0x0000,0x0000,0x0000, /* 102E */
0x223D,0x0000,0x0000,0x0000, 0x2242,0x0000,0x0000,0x0000, /* 1030 */
0x2246,0x0000,0x0000,0x0000, 0x2239,0x0000,0x0000,0x0000, /* 1032 */
0x2248,0x0000,0x0000,0x0000, 0x2244,0x0000,0x0000,0x0000, /* 1034 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 1036 */
0x0000,0x0000,0x0000,0x0000, 0x224D,0x0000,0x0000,0x0000, /* 1038 */
0x224E,0x0000,0x0000,0x0000, 0x2208,0x0000,0x0000,0x0000, /* 103A */
0x220C,0x0000,0x0000,0x0000, 0x2210,0x0000,0x0000,0x0000, /* 103C */
0x221B,0x0000,0x0000,0x0000, 0x2216,0x224D,0x2216,0x0000, /* 103E */
0x1205,0x0000,0x0000,0x0000, 0x1206,0x0000,0x0000,0x0000, /* 1040 */
0x1207,0x0000,0x0000,0x0000, 0x1208,0x0000,0x0000,0x0000, /* 1042 */
0x1209,0x0000,0x0000,0x0000, 0x120A,0x0000,0x0000,0x0000, /* 1044 */
0x120B,0x0000,0x0000,0x0000, 0x120C,0x0000,0x0000,0x0000, /* 1046 */
0x120D,0x0000,0x0000,0x0000, 0x120E,0x0000,0x0000,0x0000, /* 1048 */
0x029F,0x0000,0x0000,0x0000, 0x02A0,0x0000,0x0000,0x0000, /* 104A */
0x03C2,0x0000,0x0000,0x0000, 0x03C3,0x0000,0x0000,0x0000, /* 104C */
0x03C4,0x0000,0x0000,0x0000, 0x03C5,0x0000,0x0000,0x0000, /* 104E */
0x2213,0x0000,0x0000,0x0000, 0x2214,0x0000,0x0000,0x0000, /* 1050 */
0x222A,0x0000,0x0000,0x0000, 0x222B,0x0000,0x0000,0x0000, /* 1052 */
0x222C,0x0000,0x0000,0x0000, 0x222D,0x0000,0x0000,0x0000, /* 1054 */
0x223E,0x0000,0x0000,0x0000, 0x223F,0x0000,0x0000,0x0000, /* 1056 */
0x2240,0x0000,0x0000,0x0000, 0x2241,0x0000,0x0000,0x0000, /* 1058 */
0x21D6,0x0000,0x0000,0x0000, 0x21E1,0x0000,0x0000,0x0000, /* 105A */
0x221F,0x0000,0x0000,0x0000, 0x2220,0x0000,0x0000,0x0000, /* 105C */
0x21FB,0x0000,0x0000,0x0000, 0x2206,0x0000,0x0000,0x0000, /* 105E */
0x220E,0x0000,0x0000,0x0000, 0x21E3,0x0000,0x0000,0x0000, /* 1060 */
0x2249,0x0000,0x0000,0x0000, 0x224F,0x0000,0x0000,0x0000, /* 1062 */
0x2250,0x0000,0x0000,0x0000, 0x2215,0x0000,0x0000,0x0000, /* 1064 */
0x2223,0x0000,0x0000,0x0000, 0x224A,0x0000,0x0000,0x0000, /* 1066 */
0x224B,0x0000,0x0000,0x0000, 0x2251,0x0000,0x0000,0x0000, /* 1068 */
0x2252,0x0000,0x0000,0x0000, 0x2253,0x0000,0x0000,0x0000, /* 106A */
0x2254,0x0000,0x0000,0x0000, 0x2255,0x0000,0x0000,0x0000, /* 106C */
0x21F1,0x0000,0x0000,0x0000, 0x2221,0x0000,0x0000,0x0000, /* 106E */
0x2222,0x0000,0x0000,0x0000, 0x2237,0x0000,0x0000,0x0000, /* 1070 */
0x2234,0x0000,0x0000,0x0000, 0x223B,0x0000,0x0000,0x0000, /* 1072 */
0x223C,0x0000,0x0000,0x0000, 0x21CE,0x0000,0x0000,0x0000, /* 1074 */
0x21D0,0x0000,0x0000,0x0000, 0x21D2,0x0000,0x0000,0x0000, /* 1076 */
0x21D8,0x0000,0x0000,0x0000, 0x21DE,0x0000,0x0000,0x0000, /* 1078 */
0x21E5,0x0000,0x0000,0x0000, 0x21F5,0x0000,0x0000,0x0000, /* 107A */
0x21F9,0x0000,0x0000,0x0000, 0x21FE,0x0000,0x0000,0x0000, /* 107C */
0x21FF,0x0000,0x0000,0x0000, 0x2203,0x0000,0x0000,0x0000, /* 107E */
0x2212,0x0000,0x0000,0x0000, 0x2219,0x0000,0x0000,0x0000, /* 1080 */
0x2211,0x0000,0x0000,0x0000, 0x2233,0x0000,0x0000,0x0000, /* 1082 */
0x2243,0x0000,0x0000,0x0000, 0x2245,0x0000,0x0000,0x0000, /* 1084 */
0x224C,0x0000,0x0000,0x0000, 0x2256,0x0000,0x0000,0x0000, /* 1086 */
0x2258,0x0000,0x0000,0x0000, 0x225A,0x0000,0x0000,0x0000, /* 1088 */
0x225B,0x0000,0x0000,0x0000, 0x2257,0x0000,0x0000,0x0000, /* 108A */
0x2259,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 108C */
0x2201,0x0000,0x0000,0x0000, 0x225C,0x0000,0x0000,0x0000, /* 108E */
0x1205,0x0000,0x0000,0x0000, 0x1206,0x0000,0x0000,0x0000, /* 1090 */
0x1207,0x0000,0x0000,0x0000, 0x1208,0x0000,0x0000,0x0000, /* 1092 */
0x1209,0x0000,0x0000,0x0000, 0x120A,0x0000,0x0000,0x0000, /* 1094 */
0x120B,0x0000,0x0000,0x0000, 0x120C,0x0000,0x0000,0x0000, /* 1096 */
0x120D,0x0000,0x0000,0x0000, 0x120E,0x0000,0x0000,0x0000, /* 1098 */
0x225D,0x0000,0x0000,0x0000, 0x225E,0x0000,0x0000,0x0000, /* 109A */
0x2235,0x0000,0x0000,0x0000, 0x2247,0x0000,0x0000,0x0000, /* 109C */
0x03C6,0x0000,0x0000,0x0000, 0x03C7,0x0000,0x0000,0x0000, /* 109E */
0x17E5,0x0000,0x0000,0x0000, 0x17E7,0x0000,0x0000,0x0000, /* 10A0 */
0x17E9,0x0000,0x0000,0x0000, 0x17EB,0x0000,0x0000,0x0000, /* 10A2 */
0x17ED,0x0000,0x0000,0x0000, 0x17EF,0x0000,0x0000,0x0000, /* 10A4 */
0x17F1,0x0000,0x0000,0x0000, 0x17F5,0x0000,0x0000,0x0000, /* 10A6 */
0x17F7,0x0000,0x0000,0x0000, 0x17F9,0x0000,0x0000,0x0000, /* 10A8 */
0x17FB,0x0000,0x0000,0x0000, 0x17FD,0x0000,0x0000,0x0000, /* 10AA */
0x17FF,0x0000,0x0000,0x0000, 0x1803,0x0000,0x0000,0x0000, /* 10AC */
0x1805,0x0000,0x0000,0x0000, 0x1807,0x0000,0x0000,0x0000, /* 10AE */
0x1809,0x0000,0x0000,0x0000, 0x180B,0x0000,0x0000,0x0000, /* 10B0 */
0x180D,0x0000,0x0000,0x0000, 0x1811,0x0000,0x0000,0x0000, /* 10B2 */
0x1813,0x0000,0x0000,0x0000, 0x1815,0x0000,0x0000,0x0000, /* 10B4 */
0x1817,0x0000,0x0000,0x0000, 0x1819,0x0000,0x0000,0x0000, /* 10B6 */
0x181B,0x0000,0x0000,0x0000, 0x181D,0x0000,0x0000,0x0000, /* 10B8 */
0x181F,0x0000,0x0000,0x0000, 0x1821,0x0000,0x0000,0x0000, /* 10BA */
0x1823,0x0000,0x0000,0x0000, 0x1825,0x0000,0x0000,0x0000, /* 10BC */
0x1827,0x0000,0x0000,0x0000, 0x182B,0x0000,0x0000,0x0000, /* 10BE */
0x182D,0x0000,0x0000,0x0000, 0x17F3,0x0000,0x0000,0x0000, /* 10C0 */
0x1801,0x0000,0x0000,0x0000, 0x180F,0x0000,0x0000,0x0000, /* 10C2 */
0x1829,0x0000,0x0000,0x0000, 0x182F,0x0000,0x0000,0x0000, /* 10C4 */
0xFBC0,0x90C6,0x0000,0x0000, 0xFBC0,0x90C7,0x0000,0x0000, /* 10C6 */
0xFBC0,0x90C8,0x0000,0x0000, 0xFBC0,0x90C9,0x0000,0x0000, /* 10C8 */
0xFBC0,0x90CA,0x0000,0x0000, 0xFBC0,0x90CB,0x0000,0x0000, /* 10CA */
0xFBC0,0x90CC,0x0000,0x0000, 0xFBC0,0x90CD,0x0000,0x0000, /* 10CC */
0xFBC0,0x90CE,0x0000,0x0000, 0xFBC0,0x90CF,0x0000,0x0000, /* 10CE */
0x17E4,0x0000,0x0000,0x0000, 0x17E6,0x0000,0x0000,0x0000, /* 10D0 */
0x17E8,0x0000,0x0000,0x0000, 0x17EA,0x0000,0x0000,0x0000, /* 10D2 */
0x17EC,0x0000,0x0000,0x0000, 0x17EE,0x0000,0x0000,0x0000, /* 10D4 */
0x17F0,0x0000,0x0000,0x0000, 0x17F4,0x0000,0x0000,0x0000, /* 10D6 */
0x17F6,0x0000,0x0000,0x0000, 0x17F8,0x0000,0x0000,0x0000, /* 10D8 */
0x17FA,0x0000,0x0000,0x0000, 0x17FC,0x0000,0x0000,0x0000, /* 10DA */
0x17FE,0x0000,0x0000,0x0000, 0x1802,0x0000,0x0000,0x0000, /* 10DC */
0x1804,0x0000,0x0000,0x0000, 0x1806,0x0000,0x0000,0x0000, /* 10DE */
0x1808,0x0000,0x0000,0x0000, 0x180A,0x0000,0x0000,0x0000, /* 10E0 */
0x180C,0x0000,0x0000,0x0000, 0x1810,0x0000,0x0000,0x0000, /* 10E2 */
0x1812,0x0000,0x0000,0x0000, 0x1814,0x0000,0x0000,0x0000, /* 10E4 */
0x1816,0x0000,0x0000,0x0000, 0x1818,0x0000,0x0000,0x0000, /* 10E6 */
0x181A,0x0000,0x0000,0x0000, 0x181C,0x0000,0x0000,0x0000, /* 10E8 */
0x181E,0x0000,0x0000,0x0000, 0x1820,0x0000,0x0000,0x0000, /* 10EA */
0x1822,0x0000,0x0000,0x0000, 0x1824,0x0000,0x0000,0x0000, /* 10EC */
0x1826,0x0000,0x0000,0x0000, 0x182A,0x0000,0x0000,0x0000, /* 10EE */
0x182C,0x0000,0x0000,0x0000, 0x17F2,0x0000,0x0000,0x0000, /* 10F0 */
0x1800,0x0000,0x0000,0x0000, 0x180E,0x0000,0x0000,0x0000, /* 10F2 */
0x1828,0x0000,0x0000,0x0000, 0x182E,0x0000,0x0000,0x0000, /* 10F4 */
0x1830,0x0000,0x0000,0x0000, 0x1831,0x0000,0x0000,0x0000, /* 10F6 */
0x1832,0x0000,0x0000,0x0000, 0x1833,0x0000,0x0000,0x0000, /* 10F8 */
0x1834,0x0000,0x0000,0x0000, 0x02B7,0x0000,0x0000,0x0000, /* 10FA */
0x17FE,0x0000,0x0000,0x0000, 0xFBC0,0x90FD,0x0000,0x0000, /* 10FC */
0xFBC0,0x90FE,0x0000,0x0000, 0xFBC0,0x90FF,0x0000,0x0000  /* 10FE */
};

uint16 uca520_p011[]= { /* 1100 (2 weights per char) */
0x29B0,0x0000, 0x29B1,0x0000, 0x29B2,0x0000, 0x29B3,0x0000, /* 1100 */
0x29B4,0x0000, 0x29B5,0x0000, 0x29B6,0x0000, 0x29B7,0x0000, /* 1104 */
0x29B8,0x0000, 0x29B9,0x0000, 0x29BA,0x0000, 0x29BB,0x0000, /* 1108 */
0x29BC,0x0000, 0x29BD,0x0000, 0x29BE,0x0000, 0x29BF,0x0000, /* 110C */
0x29C0,0x0000, 0x29C1,0x0000, 0x29C2,0x0000, 0x29C3,0x0000, /* 1110 */
0x29C4,0x0000, 0x29C5,0x0000, 0x29C6,0x0000, 0x29C7,0x0000, /* 1114 */
0x29C8,0x0000, 0x29C9,0x0000, 0x29CA,0x0000, 0x29CB,0x0000, /* 1118 */
0x29CC,0x0000, 0x29CD,0x0000, 0x29CE,0x0000, 0x29CF,0x0000, /* 111C */
0x29D0,0x0000, 0x29D1,0x0000, 0x29D2,0x0000, 0x29D3,0x0000, /* 1120 */
0x29D4,0x0000, 0x29D5,0x0000, 0x29D6,0x0000, 0x29D7,0x0000, /* 1124 */
0x29D8,0x0000, 0x29D9,0x0000, 0x29DA,0x0000, 0x29DB,0x0000, /* 1128 */
0x29DC,0x0000, 0x29DD,0x0000, 0x29DE,0x0000, 0x29DF,0x0000, /* 112C */
0x29E0,0x0000, 0x29E1,0x0000, 0x29E2,0x0000, 0x29E3,0x0000, /* 1130 */
0x29E4,0x0000, 0x29E5,0x0000, 0x29E6,0x0000, 0x29E7,0x0000, /* 1134 */
0x29E8,0x0000, 0x29E9,0x0000, 0x29EA,0x0000, 0x29EB,0x0000, /* 1138 */
0x29EC,0x0000, 0x29ED,0x0000, 0x29EE,0x0000, 0x29EF,0x0000, /* 113C */
0x29F0,0x0000, 0x29F1,0x0000, 0x29F2,0x0000, 0x29F3,0x0000, /* 1140 */
0x29F4,0x0000, 0x29F5,0x0000, 0x29F6,0x0000, 0x29F7,0x0000, /* 1144 */
0x29F8,0x0000, 0x29F9,0x0000, 0x29FA,0x0000, 0x29FB,0x0000, /* 1148 */
0x29FC,0x0000, 0x29FD,0x0000, 0x29FE,0x0000, 0x29FF,0x0000, /* 114C */
0x2A00,0x0000, 0x2A01,0x0000, 0x2A02,0x0000, 0x2A03,0x0000, /* 1150 */
0x2A04,0x0000, 0x2A05,0x0000, 0x2A06,0x0000, 0x2A07,0x0000, /* 1154 */
0x2A08,0x0000, 0x2A09,0x0000, 0x2A0A,0x0000, 0x2A0B,0x0000, /* 1158 */
0x2A0C,0x0000, 0x2A0D,0x0000, 0x2A0E,0x0000, 0x2A2C,0x0000, /* 115C */
0x2A2D,0x0000, 0x2A2E,0x0000, 0x2A2F,0x0000, 0x2A30,0x0000, /* 1160 */
0x2A31,0x0000, 0x2A32,0x0000, 0x2A33,0x0000, 0x2A34,0x0000, /* 1164 */
0x2A35,0x0000, 0x2A36,0x0000, 0x2A37,0x0000, 0x2A38,0x0000, /* 1168 */
0x2A39,0x0000, 0x2A3A,0x0000, 0x2A3B,0x0000, 0x2A3C,0x0000, /* 116C */
0x2A3D,0x0000, 0x2A3E,0x0000, 0x2A3F,0x0000, 0x2A40,0x0000, /* 1170 */
0x2A41,0x0000, 0x2A42,0x0000, 0x2A43,0x0000, 0x2A44,0x0000, /* 1174 */
0x2A45,0x0000, 0x2A46,0x0000, 0x2A47,0x0000, 0x2A48,0x0000, /* 1178 */
0x2A49,0x0000, 0x2A4A,0x0000, 0x2A4B,0x0000, 0x2A4C,0x0000, /* 117C */
0x2A4D,0x0000, 0x2A4E,0x0000, 0x2A4F,0x0000, 0x2A50,0x0000, /* 1180 */
0x2A51,0x0000, 0x2A52,0x0000, 0x2A53,0x0000, 0x2A54,0x0000, /* 1184 */
0x2A55,0x0000, 0x2A56,0x0000, 0x2A57,0x0000, 0x2A58,0x0000, /* 1188 */
0x2A59,0x0000, 0x2A5A,0x0000, 0x2A5B,0x0000, 0x2A5C,0x0000, /* 118C */
0x2A5D,0x0000, 0x2A5E,0x0000, 0x2A5F,0x0000, 0x2A60,0x0000, /* 1190 */
0x2A61,0x0000, 0x2A62,0x0000, 0x2A63,0x0000, 0x2A64,0x0000, /* 1194 */
0x2A65,0x0000, 0x2A66,0x0000, 0x2A67,0x0000, 0x2A68,0x0000, /* 1198 */
0x2A69,0x0000, 0x2A6A,0x0000, 0x2A6B,0x0000, 0x2A6C,0x0000, /* 119C */
0x2A6D,0x0000, 0x2A6E,0x0000, 0x2A6F,0x0000, 0x2A70,0x0000, /* 11A0 */
0x2A71,0x0000, 0x2A72,0x0000, 0x2A73,0x0000, 0x2A74,0x0000, /* 11A4 */
0x2A8C,0x0000, 0x2A8D,0x0000, 0x2A8E,0x0000, 0x2A8F,0x0000, /* 11A8 */
0x2A90,0x0000, 0x2A91,0x0000, 0x2A92,0x0000, 0x2A93,0x0000, /* 11AC */
0x2A94,0x0000, 0x2A95,0x0000, 0x2A96,0x0000, 0x2A97,0x0000, /* 11B0 */
0x2A98,0x0000, 0x2A99,0x0000, 0x2A9A,0x0000, 0x2A9B,0x0000, /* 11B4 */
0x2A9C,0x0000, 0x2A9D,0x0000, 0x2A9E,0x0000, 0x2A9F,0x0000, /* 11B8 */
0x2AA0,0x0000, 0x2AA1,0x0000, 0x2AA2,0x0000, 0x2AA3,0x0000, /* 11BC */
0x2AA4,0x0000, 0x2AA5,0x0000, 0x2AA6,0x0000, 0x2AA7,0x0000, /* 11C0 */
0x2AA8,0x0000, 0x2AA9,0x0000, 0x2AAA,0x0000, 0x2AAB,0x0000, /* 11C4 */
0x2AAC,0x0000, 0x2AAD,0x0000, 0x2AAE,0x0000, 0x2AAF,0x0000, /* 11C8 */
0x2AB0,0x0000, 0x2AB1,0x0000, 0x2AB2,0x0000, 0x2AB3,0x0000, /* 11CC */
0x2AB4,0x0000, 0x2AB5,0x0000, 0x2AB6,0x0000, 0x2AB7,0x0000, /* 11D0 */
0x2AB8,0x0000, 0x2AB9,0x0000, 0x2ABA,0x0000, 0x2ABB,0x0000, /* 11D4 */
0x2ABC,0x0000, 0x2ABD,0x0000, 0x2ABE,0x0000, 0x2ABF,0x0000, /* 11D8 */
0x2AC0,0x0000, 0x2AC1,0x0000, 0x2AC2,0x0000, 0x2AC3,0x0000, /* 11DC */
0x2AC4,0x0000, 0x2AC5,0x0000, 0x2AC6,0x0000, 0x2AC7,0x0000, /* 11E0 */
0x2AC8,0x0000, 0x2AC9,0x0000, 0x2ACA,0x0000, 0x2ACB,0x0000, /* 11E4 */
0x2ACC,0x0000, 0x2ACD,0x0000, 0x2ACE,0x0000, 0x2ACF,0x0000, /* 11E8 */
0x2AD0,0x0000, 0x2AD1,0x0000, 0x2AD2,0x0000, 0x2AD3,0x0000, /* 11EC */
0x2AD4,0x0000, 0x2AD5,0x0000, 0x2AD6,0x0000, 0x2AD7,0x0000, /* 11F0 */
0x2AD8,0x0000, 0x2AD9,0x0000, 0x2ADA,0x0000, 0x2ADB,0x0000, /* 11F4 */
0x2ADC,0x0000, 0x2ADD,0x0000, 0x2ADE,0x0000, 0x2ADF,0x0000, /* 11F8 */
0x2AE0,0x0000, 0x2AE1,0x0000, 0x2AE2,0x0000, 0x2AE3,0x0000  /* 11FC */
};

uint16 uca520_p012[]= { /* 1200 (3 weights per char) */
0x1A03,0x0000,0x0000, 0x1A04,0x0000,0x0000, 0x1A05,0x0000,0x0000, /* 1200 */
0x1A06,0x0000,0x0000, 0x1A07,0x0000,0x0000, 0x1A08,0x0000,0x0000, /* 1203 */
0x1A09,0x0000,0x0000, 0x1A0A,0x0000,0x0000, 0x1A0B,0x0000,0x0000, /* 1206 */
0x1A0C,0x0000,0x0000, 0x1A0D,0x0000,0x0000, 0x1A0E,0x0000,0x0000, /* 1209 */
0x1A0F,0x0000,0x0000, 0x1A10,0x0000,0x0000, 0x1A11,0x0000,0x0000, /* 120C */
0x1A12,0x0000,0x0000, 0x1A14,0x0000,0x0000, 0x1A15,0x0000,0x0000, /* 120F */
0x1A16,0x0000,0x0000, 0x1A17,0x0000,0x0000, 0x1A18,0x0000,0x0000, /* 1212 */
0x1A19,0x0000,0x0000, 0x1A1A,0x0000,0x0000, 0x1A1B,0x0000,0x0000, /* 1215 */
0x1A1C,0x0000,0x0000, 0x1A1D,0x0000,0x0000, 0x1A1E,0x0000,0x0000, /* 1218 */
0x1A1F,0x0000,0x0000, 0x1A20,0x0000,0x0000, 0x1A21,0x0000,0x0000, /* 121B */
0x1A22,0x0000,0x0000, 0x1A23,0x0000,0x0000, 0x1A29,0x0000,0x0000, /* 121E */
0x1A2A,0x0000,0x0000, 0x1A2B,0x0000,0x0000, 0x1A2C,0x0000,0x0000, /* 1221 */
0x1A2D,0x0000,0x0000, 0x1A2E,0x0000,0x0000, 0x1A2F,0x0000,0x0000, /* 1224 */
0x1A30,0x0000,0x0000, 0x1A31,0x0000,0x0000, 0x1A32,0x0000,0x0000, /* 1227 */
0x1A33,0x0000,0x0000, 0x1A34,0x0000,0x0000, 0x1A35,0x0000,0x0000, /* 122A */
0x1A36,0x0000,0x0000, 0x1A37,0x0000,0x0000, 0x1A38,0x0000,0x0000, /* 122D */
0x1A3A,0x0000,0x0000, 0x1A3B,0x0000,0x0000, 0x1A3C,0x0000,0x0000, /* 1230 */
0x1A3D,0x0000,0x0000, 0x1A3E,0x0000,0x0000, 0x1A3F,0x0000,0x0000, /* 1233 */
0x1A40,0x0000,0x0000, 0x1A41,0x0000,0x0000, 0x1A43,0x0000,0x0000, /* 1236 */
0x1A44,0x0000,0x0000, 0x1A45,0x0000,0x0000, 0x1A46,0x0000,0x0000, /* 1239 */
0x1A47,0x0000,0x0000, 0x1A48,0x0000,0x0000, 0x1A49,0x0000,0x0000, /* 123C */
0x1A4A,0x0000,0x0000, 0x1A4C,0x0000,0x0000, 0x1A4D,0x0000,0x0000, /* 123F */
0x1A4E,0x0000,0x0000, 0x1A4F,0x0000,0x0000, 0x1A50,0x0000,0x0000, /* 1242 */
0x1A51,0x0000,0x0000, 0x1A52,0x0000,0x0000, 0x1A53,0x0000,0x0000, /* 1245 */
0x1A54,0x0000,0x0000, 0xFBC0,0x9249,0x0000, 0x1A55,0x0000,0x0000, /* 1248 */
0x1A56,0x0000,0x0000, 0x1A57,0x0000,0x0000, 0x1A58,0x0000,0x0000, /* 124B */
0xFBC0,0x924E,0x0000, 0xFBC0,0x924F,0x0000, 0x1A59,0x0000,0x0000, /* 124E */
0x1A5A,0x0000,0x0000, 0x1A5B,0x0000,0x0000, 0x1A5C,0x0000,0x0000, /* 1251 */
0x1A5D,0x0000,0x0000, 0x1A5E,0x0000,0x0000, 0x1A5F,0x0000,0x0000, /* 1254 */
0xFBC0,0x9257,0x0000, 0x1A60,0x0000,0x0000, 0xFBC0,0x9259,0x0000, /* 1257 */
0x1A61,0x0000,0x0000, 0x1A62,0x0000,0x0000, 0x1A63,0x0000,0x0000, /* 125A */
0x1A64,0x0000,0x0000, 0xFBC0,0x925E,0x0000, 0xFBC0,0x925F,0x0000, /* 125D */
0x1A65,0x0000,0x0000, 0x1A66,0x0000,0x0000, 0x1A67,0x0000,0x0000, /* 1260 */
0x1A68,0x0000,0x0000, 0x1A69,0x0000,0x0000, 0x1A6A,0x0000,0x0000, /* 1263 */
0x1A6B,0x0000,0x0000, 0x1A6C,0x0000,0x0000, 0x1A72,0x0000,0x0000, /* 1266 */
0x1A73,0x0000,0x0000, 0x1A74,0x0000,0x0000, 0x1A75,0x0000,0x0000, /* 1269 */
0x1A76,0x0000,0x0000, 0x1A77,0x0000,0x0000, 0x1A78,0x0000,0x0000, /* 126C */
0x1A79,0x0000,0x0000, 0x1A7A,0x0000,0x0000, 0x1A7B,0x0000,0x0000, /* 126F */
0x1A7C,0x0000,0x0000, 0x1A7D,0x0000,0x0000, 0x1A7E,0x0000,0x0000, /* 1272 */
0x1A7F,0x0000,0x0000, 0x1A80,0x0000,0x0000, 0x1A81,0x0000,0x0000, /* 1275 */
0x1A83,0x0000,0x0000, 0x1A84,0x0000,0x0000, 0x1A85,0x0000,0x0000, /* 1278 */
0x1A86,0x0000,0x0000, 0x1A87,0x0000,0x0000, 0x1A88,0x0000,0x0000, /* 127B */
0x1A89,0x0000,0x0000, 0x1A8A,0x0000,0x0000, 0x1A8C,0x0000,0x0000, /* 127E */
0x1A8D,0x0000,0x0000, 0x1A8E,0x0000,0x0000, 0x1A8F,0x0000,0x0000, /* 1281 */
0x1A90,0x0000,0x0000, 0x1A91,0x0000,0x0000, 0x1A92,0x0000,0x0000, /* 1284 */
0x1A93,0x0000,0x0000, 0x1A94,0x0000,0x0000, 0xFBC0,0x9289,0x0000, /* 1287 */
0x1A95,0x0000,0x0000, 0x1A96,0x0000,0x0000, 0x1A97,0x0000,0x0000, /* 128A */
0x1A98,0x0000,0x0000, 0xFBC0,0x928E,0x0000, 0xFBC0,0x928F,0x0000, /* 128D */
0x1A99,0x0000,0x0000, 0x1A9A,0x0000,0x0000, 0x1A9B,0x0000,0x0000, /* 1290 */
0x1A9C,0x0000,0x0000, 0x1A9D,0x0000,0x0000, 0x1A9E,0x0000,0x0000, /* 1293 */
0x1A9F,0x0000,0x0000, 0x1AA0,0x0000,0x0000, 0x1AA2,0x0000,0x0000, /* 1296 */
0x1AA3,0x0000,0x0000, 0x1AA4,0x0000,0x0000, 0x1AA5,0x0000,0x0000, /* 1299 */
0x1AA6,0x0000,0x0000, 0x1AA7,0x0000,0x0000, 0x1AA8,0x0000,0x0000, /* 129C */
0x1AA9,0x0000,0x0000, 0x1AAB,0x0000,0x0000, 0x1AAC,0x0000,0x0000, /* 129F */
0x1AAD,0x0000,0x0000, 0x1AAE,0x0000,0x0000, 0x1AAF,0x0000,0x0000, /* 12A2 */
0x1AB0,0x0000,0x0000, 0x1AB1,0x0000,0x0000, 0x1AB2,0x0000,0x0000, /* 12A5 */
0x1AB4,0x0000,0x0000, 0x1AB5,0x0000,0x0000, 0x1AB6,0x0000,0x0000, /* 12A8 */
0x1AB7,0x0000,0x0000, 0x1AB8,0x0000,0x0000, 0x1AB9,0x0000,0x0000, /* 12AB */
0x1ABA,0x0000,0x0000, 0x1ABB,0x0000,0x0000, 0x1ABC,0x0000,0x0000, /* 12AE */
0xFBC0,0x92B1,0x0000, 0x1ABD,0x0000,0x0000, 0x1ABE,0x0000,0x0000, /* 12B1 */
0x1ABF,0x0000,0x0000, 0x1AC0,0x0000,0x0000, 0xFBC0,0x92B6,0x0000, /* 12B4 */
0xFBC0,0x92B7,0x0000, 0x1AC1,0x0000,0x0000, 0x1AC2,0x0000,0x0000, /* 12B7 */
0x1AC3,0x0000,0x0000, 0x1AC4,0x0000,0x0000, 0x1AC5,0x0000,0x0000, /* 12BA */
0x1AC6,0x0000,0x0000, 0x1AC7,0x0000,0x0000, 0xFBC0,0x92BF,0x0000, /* 12BD */
0x1AC8,0x0000,0x0000, 0xFBC0,0x92C1,0x0000, 0x1AC9,0x0000,0x0000, /* 12C0 */
0x1ACA,0x0000,0x0000, 0x1ACB,0x0000,0x0000, 0x1ACC,0x0000,0x0000, /* 12C3 */
0xFBC0,0x92C6,0x0000, 0xFBC0,0x92C7,0x0000, 0x1ACD,0x0000,0x0000, /* 12C6 */
0x1ACE,0x0000,0x0000, 0x1ACF,0x0000,0x0000, 0x1AD0,0x0000,0x0000, /* 12C9 */
0x1AD1,0x0000,0x0000, 0x1AD2,0x0000,0x0000, 0x1AD3,0x0000,0x0000, /* 12CC */
0x1AD4,0x0000,0x0000, 0x1AD5,0x0000,0x0000, 0x1AD6,0x0000,0x0000, /* 12CF */
0x1AD7,0x0000,0x0000, 0x1AD8,0x0000,0x0000, 0x1AD9,0x0000,0x0000, /* 12D2 */
0x1ADA,0x0000,0x0000, 0x1ADB,0x0000,0x0000, 0xFBC0,0x92D7,0x0000, /* 12D5 */
0x1ADC,0x0000,0x0000, 0x1ADD,0x0000,0x0000, 0x1ADE,0x0000,0x0000, /* 12D8 */
0x1ADF,0x0000,0x0000, 0x1AE0,0x0000,0x0000, 0x1AE1,0x0000,0x0000, /* 12DB */
0x1AE2,0x0000,0x0000, 0x1AE3,0x0000,0x0000, 0x1AE5,0x0000,0x0000, /* 12DE */
0x1AE6,0x0000,0x0000, 0x1AE7,0x0000,0x0000, 0x1AE8,0x0000,0x0000, /* 12E1 */
0x1AE9,0x0000,0x0000, 0x1AEA,0x0000,0x0000, 0x1AEB,0x0000,0x0000, /* 12E4 */
0x1AEC,0x0000,0x0000, 0x1AED,0x0000,0x0000, 0x1AEE,0x0000,0x0000, /* 12E7 */
0x1AEF,0x0000,0x0000, 0x1AF0,0x0000,0x0000, 0x1AF1,0x0000,0x0000, /* 12EA */
0x1AF2,0x0000,0x0000, 0x1AF3,0x0000,0x0000, 0x1AF4,0x0000,0x0000, /* 12ED */
0x1AF5,0x0000,0x0000, 0x1AF6,0x0000,0x0000, 0x1AF7,0x0000,0x0000, /* 12F0 */
0x1AF8,0x0000,0x0000, 0x1AF9,0x0000,0x0000, 0x1AFA,0x0000,0x0000, /* 12F3 */
0x1AFB,0x0000,0x0000, 0x1AFC,0x0000,0x0000, 0x1AFE,0x0000,0x0000, /* 12F6 */
0x1AFF,0x0000,0x0000, 0x1B00,0x0000,0x0000, 0x1B01,0x0000,0x0000, /* 12F9 */
0x1B02,0x0000,0x0000, 0x1B03,0x0000,0x0000, 0x1B04,0x0000,0x0000, /* 12FC */
0x1B05,0x0000,0x0000  };

uint16 uca520_p013[]= { /* 1300 (3 weights per char) */
0x1B07,0x0000,0x0000, 0x1B08,0x0000,0x0000, 0x1B09,0x0000,0x0000, /* 1300 */
0x1B0A,0x0000,0x0000, 0x1B0B,0x0000,0x0000, 0x1B0C,0x0000,0x0000, /* 1303 */
0x1B0D,0x0000,0x0000, 0x1B0E,0x0000,0x0000, 0x1B10,0x0000,0x0000, /* 1306 */
0x1B11,0x0000,0x0000, 0x1B12,0x0000,0x0000, 0x1B13,0x0000,0x0000, /* 1309 */
0x1B14,0x0000,0x0000, 0x1B15,0x0000,0x0000, 0x1B16,0x0000,0x0000, /* 130C */
0x1B17,0x0000,0x0000, 0x1B18,0x0000,0x0000, 0xFBC0,0x9311,0x0000, /* 130F */
0x1B19,0x0000,0x0000, 0x1B1A,0x0000,0x0000, 0x1B1B,0x0000,0x0000, /* 1312 */
0x1B1C,0x0000,0x0000, 0xFBC0,0x9316,0x0000, 0xFBC0,0x9317,0x0000, /* 1315 */
0x1B1D,0x0000,0x0000, 0x1B1E,0x0000,0x0000, 0x1B1F,0x0000,0x0000, /* 1318 */
0x1B20,0x0000,0x0000, 0x1B21,0x0000,0x0000, 0x1B22,0x0000,0x0000, /* 131B */
0x1B23,0x0000,0x0000, 0x1B24,0x0000,0x0000, 0x1B29,0x0000,0x0000, /* 131E */
0x1B2A,0x0000,0x0000, 0x1B2B,0x0000,0x0000, 0x1B2C,0x0000,0x0000, /* 1321 */
0x1B2D,0x0000,0x0000, 0x1B2E,0x0000,0x0000, 0x1B2F,0x0000,0x0000, /* 1324 */
0x1B30,0x0000,0x0000, 0x1B32,0x0000,0x0000, 0x1B33,0x0000,0x0000, /* 1327 */
0x1B34,0x0000,0x0000, 0x1B35,0x0000,0x0000, 0x1B36,0x0000,0x0000, /* 132A */
0x1B37,0x0000,0x0000, 0x1B38,0x0000,0x0000, 0x1B39,0x0000,0x0000, /* 132D */
0x1B3B,0x0000,0x0000, 0x1B3C,0x0000,0x0000, 0x1B3D,0x0000,0x0000, /* 1330 */
0x1B3E,0x0000,0x0000, 0x1B3F,0x0000,0x0000, 0x1B40,0x0000,0x0000, /* 1333 */
0x1B41,0x0000,0x0000, 0x1B42,0x0000,0x0000, 0x1B44,0x0000,0x0000, /* 1336 */
0x1B45,0x0000,0x0000, 0x1B46,0x0000,0x0000, 0x1B47,0x0000,0x0000, /* 1339 */
0x1B48,0x0000,0x0000, 0x1B49,0x0000,0x0000, 0x1B4A,0x0000,0x0000, /* 133C */
0x1B4B,0x0000,0x0000, 0x1B4C,0x0000,0x0000, 0x1B4D,0x0000,0x0000, /* 133F */
0x1B4E,0x0000,0x0000, 0x1B4F,0x0000,0x0000, 0x1B50,0x0000,0x0000, /* 1342 */
0x1B51,0x0000,0x0000, 0x1B52,0x0000,0x0000, 0x1B53,0x0000,0x0000, /* 1345 */
0x1B54,0x0000,0x0000, 0x1B55,0x0000,0x0000, 0x1B56,0x0000,0x0000, /* 1348 */
0x1B57,0x0000,0x0000, 0x1B58,0x0000,0x0000, 0x1B59,0x0000,0x0000, /* 134B */
0x1B5A,0x0000,0x0000, 0x1B5B,0x0000,0x0000, 0x1B60,0x0000,0x0000, /* 134E */
0x1B61,0x0000,0x0000, 0x1B62,0x0000,0x0000, 0x1B63,0x0000,0x0000, /* 1351 */
0x1B64,0x0000,0x0000, 0x1B65,0x0000,0x0000, 0x1B66,0x0000,0x0000, /* 1354 */
0x1B67,0x0000,0x0000, 0x1B6D,0x0000,0x0000, 0x1B6E,0x0000,0x0000, /* 1357 */
0x1B6F,0x0000,0x0000, 0xFBC0,0x935B,0x0000, 0xFBC0,0x935C,0x0000, /* 135A */
0xFBC0,0x935D,0x0000, 0xFBC0,0x935E,0x0000, 0x0000,0x0000,0x0000, /* 135D */
0x02B8,0x0000,0x0000, 0x025F,0x0000,0x0000, 0x0286,0x0000,0x0000, /* 1360 */
0x0260,0x0000,0x0000, 0x0261,0x0000,0x0000, 0x0262,0x0000,0x0000, /* 1363 */
0x0263,0x0000,0x0000, 0x0279,0x0000,0x0000, 0x02B9,0x0000,0x0000, /* 1366 */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 1369 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 136C */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 136F */
0x1125,0x0000,0x0000, 0x1126,0x0000,0x0000, 0x1127,0x0000,0x0000, /* 1372 */
0x1128,0x0000,0x0000, 0x1129,0x0000,0x0000, 0x112A,0x0000,0x0000, /* 1375 */
0x112B,0x0000,0x0000, 0x112C,0x0000,0x0000, 0x112D,0x0000,0x0000, /* 1378 */
0x112E,0x0000,0x0000, 0x112F,0x0000,0x0000, 0xFBC0,0x937D,0x0000, /* 137B */
0xFBC0,0x937E,0x0000, 0xFBC0,0x937F,0x0000, 0x1A24,0x0000,0x0000, /* 137E */
0x1A25,0x0000,0x0000, 0x1A26,0x0000,0x0000, 0x1A27,0x0000,0x0000, /* 1381 */
0x1A6D,0x0000,0x0000, 0x1A6E,0x0000,0x0000, 0x1A6F,0x0000,0x0000, /* 1384 */
0x1A70,0x0000,0x0000, 0x1B5C,0x0000,0x0000, 0x1B5D,0x0000,0x0000, /* 1387 */
0x1B5E,0x0000,0x0000, 0x1B5F,0x0000,0x0000, 0x1B68,0x0000,0x0000, /* 138A */
0x1B69,0x0000,0x0000, 0x1B6A,0x0000,0x0000, 0x1B6B,0x0000,0x0000, /* 138D */
0x041C,0x0000,0x0000, 0x041D,0x0000,0x0000, 0x041E,0x0000,0x0000, /* 1390 */
0x041F,0x0000,0x0000, 0x0420,0x0000,0x0000, 0x0421,0x0000,0x0000, /* 1393 */
0x0422,0x0000,0x0000, 0x0423,0x0000,0x0000, 0x0424,0x0000,0x0000, /* 1396 */
0x0425,0x0000,0x0000, 0xFBC0,0x939A,0x0000, 0xFBC0,0x939B,0x0000, /* 1399 */
0xFBC0,0x939C,0x0000, 0xFBC0,0x939D,0x0000, 0xFBC0,0x939E,0x0000, /* 139C */
0xFBC0,0x939F,0x0000, 0x24CE,0x0000,0x0000, 0x24CF,0x0000,0x0000, /* 139F */
0x24D0,0x0000,0x0000, 0x24D1,0x0000,0x0000, 0x24D2,0x0000,0x0000, /* 13A2 */
0x24D3,0x0000,0x0000, 0x24D4,0x0000,0x0000, 0x24D5,0x0000,0x0000, /* 13A5 */
0x24D6,0x0000,0x0000, 0x24D7,0x0000,0x0000, 0x24D8,0x0000,0x0000, /* 13A8 */
0x24D9,0x0000,0x0000, 0x24DA,0x0000,0x0000, 0x24DB,0x0000,0x0000, /* 13AB */
0x24DC,0x0000,0x0000, 0x24DD,0x0000,0x0000, 0x24DE,0x0000,0x0000, /* 13AE */
0x24DF,0x0000,0x0000, 0x24E0,0x0000,0x0000, 0x24E1,0x0000,0x0000, /* 13B1 */
0x24E2,0x0000,0x0000, 0x24E3,0x0000,0x0000, 0x24E4,0x0000,0x0000, /* 13B4 */
0x24E5,0x0000,0x0000, 0x24E6,0x0000,0x0000, 0x24E7,0x0000,0x0000, /* 13B7 */
0x24E8,0x0000,0x0000, 0x24E9,0x0000,0x0000, 0x24EA,0x0000,0x0000, /* 13BA */
0x24EB,0x0000,0x0000, 0x24EC,0x0000,0x0000, 0x24ED,0x0000,0x0000, /* 13BD */
0x24EE,0x0000,0x0000, 0x24EF,0x0000,0x0000, 0x24F0,0x0000,0x0000, /* 13C0 */
0x24F1,0x0000,0x0000, 0x24F2,0x0000,0x0000, 0x24F3,0x0000,0x0000, /* 13C3 */
0x24F4,0x0000,0x0000, 0x24F5,0x0000,0x0000, 0x24F6,0x0000,0x0000, /* 13C6 */
0x24F7,0x0000,0x0000, 0x24F8,0x0000,0x0000, 0x24F9,0x0000,0x0000, /* 13C9 */
0x24FA,0x0000,0x0000, 0x24FB,0x0000,0x0000, 0x24FC,0x0000,0x0000, /* 13CC */
0x24FD,0x0000,0x0000, 0x24FE,0x0000,0x0000, 0x24FF,0x0000,0x0000, /* 13CF */
0x2500,0x0000,0x0000, 0x2501,0x0000,0x0000, 0x2502,0x0000,0x0000, /* 13D2 */
0x2503,0x0000,0x0000, 0x2504,0x0000,0x0000, 0x2505,0x0000,0x0000, /* 13D5 */
0x2506,0x0000,0x0000, 0x2507,0x0000,0x0000, 0x2508,0x0000,0x0000, /* 13D8 */
0x2509,0x0000,0x0000, 0x250A,0x0000,0x0000, 0x250B,0x0000,0x0000, /* 13DB */
0x250C,0x0000,0x0000, 0x250D,0x0000,0x0000, 0x250E,0x0000,0x0000, /* 13DE */
0x250F,0x0000,0x0000, 0x2510,0x0000,0x0000, 0x2511,0x0000,0x0000, /* 13E1 */
0x2512,0x0000,0x0000, 0x2513,0x0000,0x0000, 0x2514,0x0000,0x0000, /* 13E4 */
0x2515,0x0000,0x0000, 0x2516,0x0000,0x0000, 0x2517,0x0000,0x0000, /* 13E7 */
0x2518,0x0000,0x0000, 0x2519,0x0000,0x0000, 0x251A,0x0000,0x0000, /* 13EA */
0x251B,0x0000,0x0000, 0x251C,0x0000,0x0000, 0x251D,0x0000,0x0000, /* 13ED */
0x251E,0x0000,0x0000, 0x251F,0x0000,0x0000, 0x2520,0x0000,0x0000, /* 13F0 */
0x2521,0x0000,0x0000, 0x2522,0x0000,0x0000, 0xFBC0,0x93F5,0x0000, /* 13F3 */
0xFBC0,0x93F6,0x0000, 0xFBC0,0x93F7,0x0000, 0xFBC0,0x93F8,0x0000, /* 13F6 */
0xFBC0,0x93F9,0x0000, 0xFBC0,0x93FA,0x0000, 0xFBC0,0x93FB,0x0000, /* 13F9 */
0xFBC0,0x93FC,0x0000, 0xFBC0,0x93FD,0x0000, 0xFBC0,0x93FE,0x0000, /* 13FC */
0xFBC0,0x93FF,0x0000  };

uint16 uca520_p014[]= { /* 1400 (2 weights per char) */
0x0225,0x0000, 0x2523,0x0000, 0x2524,0x0000, 0x2525,0x0000, /* 1400 */
0x2526,0x0000, 0x2527,0x0000, 0x2528,0x0000, 0x2529,0x0000, /* 1404 */
0x252A,0x0000, 0x252B,0x0000, 0x252C,0x0000, 0x252D,0x0000, /* 1408 */
0x252E,0x0000, 0x252F,0x0000, 0x2530,0x0000, 0x2531,0x0000, /* 140C */
0x2532,0x0000, 0x2533,0x0000, 0x2534,0x0000, 0x2535,0x0000, /* 1410 */
0x2536,0x0000, 0x2537,0x0000, 0x2538,0x0000, 0x2539,0x0000, /* 1414 */
0x253A,0x0000, 0x253B,0x0000, 0x253C,0x0000, 0x253D,0x0000, /* 1418 */
0x253E,0x0000, 0x253F,0x0000, 0x2540,0x0000, 0x2541,0x0000, /* 141C */
0x2542,0x0000, 0x2543,0x0000, 0x2544,0x0000, 0x2545,0x0000, /* 1420 */
0x2546,0x0000, 0x2547,0x0000, 0x2548,0x0000, 0x2549,0x0000, /* 1424 */
0x254A,0x0000, 0x254B,0x0000, 0x254C,0x0000, 0x254D,0x0000, /* 1428 */
0x254E,0x0000, 0x254F,0x0000, 0x2550,0x0000, 0x2551,0x0000, /* 142C */
0x2552,0x0000, 0x2553,0x0000, 0x2554,0x0000, 0x2555,0x0000, /* 1430 */
0x2556,0x0000, 0x2557,0x0000, 0x2558,0x0000, 0x2559,0x0000, /* 1434 */
0x255A,0x0000, 0x255B,0x0000, 0x255C,0x0000, 0x255D,0x0000, /* 1438 */
0x255E,0x0000, 0x255F,0x0000, 0x2560,0x0000, 0x2561,0x0000, /* 143C */
0x2562,0x0000, 0x2563,0x0000, 0x2564,0x0000, 0x2565,0x0000, /* 1440 */
0x2566,0x0000, 0x2567,0x0000, 0x2568,0x0000, 0x2569,0x0000, /* 1444 */
0x256A,0x0000, 0x256B,0x0000, 0x256C,0x0000, 0x256D,0x0000, /* 1448 */
0x256E,0x0000, 0x256F,0x0000, 0x2570,0x0000, 0x2571,0x0000, /* 144C */
0x2572,0x0000, 0x2573,0x0000, 0x2574,0x0000, 0x2575,0x0000, /* 1450 */
0x2576,0x0000, 0x2577,0x0000, 0x2578,0x0000, 0x2579,0x0000, /* 1454 */
0x257A,0x0000, 0x257B,0x0000, 0x257C,0x0000, 0x257D,0x0000, /* 1458 */
0x257E,0x0000, 0x257F,0x0000, 0x2580,0x0000, 0x2581,0x0000, /* 145C */
0x2582,0x0000, 0x2583,0x0000, 0x2584,0x0000, 0x2585,0x0000, /* 1460 */
0x2586,0x0000, 0x2587,0x0000, 0x2588,0x0000, 0x2589,0x0000, /* 1464 */
0x258A,0x0000, 0x258B,0x0000, 0x258C,0x0000, 0x258D,0x0000, /* 1468 */
0x258E,0x0000, 0x258F,0x0000, 0x2590,0x0000, 0x2591,0x0000, /* 146C */
0x2592,0x0000, 0x2593,0x0000, 0x2594,0x0000, 0x2595,0x0000, /* 1470 */
0x2596,0x0000, 0x2597,0x0000, 0x2598,0x0000, 0x2599,0x0000, /* 1474 */
0x259A,0x0000, 0x259B,0x0000, 0x259C,0x0000, 0x259D,0x0000, /* 1478 */
0x259E,0x0000, 0x259F,0x0000, 0x25A0,0x0000, 0x25A1,0x0000, /* 147C */
0x25A2,0x0000, 0x25A3,0x0000, 0x25A4,0x0000, 0x25A5,0x0000, /* 1480 */
0x25A6,0x0000, 0x25A7,0x0000, 0x25A8,0x0000, 0x25A9,0x0000, /* 1484 */
0x25AA,0x0000, 0x25AB,0x0000, 0x25AC,0x0000, 0x25AD,0x0000, /* 1488 */
0x25AE,0x0000, 0x25AF,0x0000, 0x25B0,0x0000, 0x25B1,0x0000, /* 148C */
0x25B2,0x0000, 0x25B3,0x0000, 0x25B4,0x0000, 0x25B5,0x0000, /* 1490 */
0x25B6,0x0000, 0x25B7,0x0000, 0x25B8,0x0000, 0x25B9,0x0000, /* 1494 */
0x25BA,0x0000, 0x25BB,0x0000, 0x25BC,0x0000, 0x25BD,0x0000, /* 1498 */
0x25BE,0x0000, 0x25BF,0x0000, 0x25C0,0x0000, 0x25C1,0x0000, /* 149C */
0x25C2,0x0000, 0x25C3,0x0000, 0x25C4,0x0000, 0x25C5,0x0000, /* 14A0 */
0x25C6,0x0000, 0x25C7,0x0000, 0x25C8,0x0000, 0x25C9,0x0000, /* 14A4 */
0x25CA,0x0000, 0x25CB,0x0000, 0x25CC,0x0000, 0x25CD,0x0000, /* 14A8 */
0x25CE,0x0000, 0x25CF,0x0000, 0x25D0,0x0000, 0x25D1,0x0000, /* 14AC */
0x25D2,0x0000, 0x25D3,0x0000, 0x25D4,0x0000, 0x25D5,0x0000, /* 14B0 */
0x25D6,0x0000, 0x25D7,0x0000, 0x25D8,0x0000, 0x25D9,0x0000, /* 14B4 */
0x25DA,0x0000, 0x25DB,0x0000, 0x25DC,0x0000, 0x25DD,0x0000, /* 14B8 */
0x25DE,0x0000, 0x25DF,0x0000, 0x25E0,0x0000, 0x25E1,0x0000, /* 14BC */
0x25E2,0x0000, 0x25E3,0x0000, 0x25E4,0x0000, 0x25E5,0x0000, /* 14C0 */
0x25E6,0x0000, 0x25E7,0x0000, 0x25E8,0x0000, 0x25E9,0x0000, /* 14C4 */
0x25EA,0x0000, 0x25EB,0x0000, 0x25EC,0x0000, 0x25ED,0x0000, /* 14C8 */
0x25EE,0x0000, 0x25EF,0x0000, 0x25F0,0x0000, 0x25F1,0x0000, /* 14CC */
0x25F2,0x0000, 0x25F3,0x0000, 0x25F4,0x0000, 0x25F5,0x0000, /* 14D0 */
0x25F6,0x0000, 0x25F7,0x0000, 0x25F8,0x0000, 0x25F9,0x0000, /* 14D4 */
0x25FA,0x0000, 0x25FB,0x0000, 0x25FC,0x0000, 0x25FD,0x0000, /* 14D8 */
0x25FE,0x0000, 0x25FF,0x0000, 0x2600,0x0000, 0x2601,0x0000, /* 14DC */
0x2602,0x0000, 0x2603,0x0000, 0x2604,0x0000, 0x2605,0x0000, /* 14E0 */
0x2606,0x0000, 0x2607,0x0000, 0x2608,0x0000, 0x2609,0x0000, /* 14E4 */
0x260A,0x0000, 0x260B,0x0000, 0x260C,0x0000, 0x260D,0x0000, /* 14E8 */
0x260E,0x0000, 0x260F,0x0000, 0x2610,0x0000, 0x2611,0x0000, /* 14EC */
0x2612,0x0000, 0x2613,0x0000, 0x2614,0x0000, 0x2615,0x0000, /* 14F0 */
0x2616,0x0000, 0x2617,0x0000, 0x2618,0x0000, 0x2619,0x0000, /* 14F4 */
0x261A,0x0000, 0x261B,0x0000, 0x261C,0x0000, 0x261D,0x0000, /* 14F8 */
0x261E,0x0000, 0x261F,0x0000, 0x2620,0x0000, 0x2621,0x0000  /* 14FC */
};

uint16 uca520_p015[]= { /* 1500 (2 weights per char) */
0x2622,0x0000, 0x2623,0x0000, 0x2624,0x0000, 0x2625,0x0000, /* 1500 */
0x2626,0x0000, 0x2627,0x0000, 0x2628,0x0000, 0x2629,0x0000, /* 1504 */
0x262A,0x0000, 0x262B,0x0000, 0x262C,0x0000, 0x262D,0x0000, /* 1508 */
0x262E,0x0000, 0x262F,0x0000, 0x2630,0x0000, 0x2631,0x0000, /* 150C */
0x2632,0x0000, 0x2633,0x0000, 0x2634,0x0000, 0x2635,0x0000, /* 1510 */
0x2636,0x0000, 0x2637,0x0000, 0x2638,0x0000, 0x2639,0x0000, /* 1514 */
0x263A,0x0000, 0x263B,0x0000, 0x263C,0x0000, 0x263D,0x0000, /* 1518 */
0x263E,0x0000, 0x263F,0x0000, 0x2640,0x0000, 0x2641,0x0000, /* 151C */
0x2642,0x0000, 0x2643,0x0000, 0x2644,0x0000, 0x2645,0x0000, /* 1520 */
0x2646,0x0000, 0x2647,0x0000, 0x2648,0x0000, 0x2649,0x0000, /* 1524 */
0x264A,0x0000, 0x264B,0x0000, 0x264C,0x0000, 0x264D,0x0000, /* 1528 */
0x264E,0x0000, 0x264F,0x0000, 0x2650,0x0000, 0x2651,0x0000, /* 152C */
0x2652,0x0000, 0x2653,0x0000, 0x2654,0x0000, 0x2655,0x0000, /* 1530 */
0x2656,0x0000, 0x2657,0x0000, 0x2658,0x0000, 0x2659,0x0000, /* 1534 */
0x265A,0x0000, 0x265B,0x0000, 0x265C,0x0000, 0x265D,0x0000, /* 1538 */
0x265E,0x0000, 0x265F,0x0000, 0x2660,0x0000, 0x2661,0x0000, /* 153C */
0x2662,0x0000, 0x2663,0x0000, 0x2664,0x0000, 0x2665,0x0000, /* 1540 */
0x2666,0x0000, 0x2667,0x0000, 0x2668,0x0000, 0x2669,0x0000, /* 1544 */
0x266A,0x0000, 0x266B,0x0000, 0x266C,0x0000, 0x266D,0x0000, /* 1548 */
0x266E,0x0000, 0x266F,0x0000, 0x2670,0x0000, 0x2671,0x0000, /* 154C */
0x2672,0x0000, 0x2673,0x0000, 0x2674,0x0000, 0x2675,0x0000, /* 1550 */
0x2676,0x0000, 0x2677,0x0000, 0x2678,0x0000, 0x2679,0x0000, /* 1554 */
0x267A,0x0000, 0x267B,0x0000, 0x267C,0x0000, 0x267D,0x0000, /* 1558 */
0x267E,0x0000, 0x267F,0x0000, 0x2680,0x0000, 0x2681,0x0000, /* 155C */
0x2682,0x0000, 0x2683,0x0000, 0x2684,0x0000, 0x2685,0x0000, /* 1560 */
0x2686,0x0000, 0x2687,0x0000, 0x2688,0x0000, 0x2689,0x0000, /* 1564 */
0x268A,0x0000, 0x268B,0x0000, 0x268C,0x0000, 0x268D,0x0000, /* 1568 */
0x268E,0x0000, 0x268F,0x0000, 0x2690,0x0000, 0x2691,0x0000, /* 156C */
0x2692,0x0000, 0x2693,0x0000, 0x2694,0x0000, 0x2695,0x0000, /* 1570 */
0x2696,0x0000, 0x2697,0x0000, 0x2698,0x0000, 0x2699,0x0000, /* 1574 */
0x269A,0x0000, 0x269B,0x0000, 0x269C,0x0000, 0x269D,0x0000, /* 1578 */
0x26D0,0x0000, 0x269E,0x0000, 0x26A0,0x0000, 0x26A1,0x0000, /* 157C */
0x26A2,0x0000, 0x26A3,0x0000, 0x26A4,0x0000, 0x26A5,0x0000, /* 1580 */
0x26A6,0x0000, 0x26A7,0x0000, 0x26A8,0x0000, 0x26A9,0x0000, /* 1584 */
0x26AA,0x0000, 0x26AB,0x0000, 0x26AC,0x0000, 0x26AD,0x0000, /* 1588 */
0x26AE,0x0000, 0x26AF,0x0000, 0x26B1,0x0000, 0x26B2,0x0000, /* 158C */
0x26B3,0x0000, 0x26B4,0x0000, 0x26B5,0x0000, 0x26B6,0x0000, /* 1590 */
0x26B7,0x0000, 0x26B8,0x0000, 0x26BF,0x0000, 0x26C0,0x0000, /* 1594 */
0x26C1,0x0000, 0x26C2,0x0000, 0x26C3,0x0000, 0x26C4,0x0000, /* 1598 */
0x26C5,0x0000, 0x26C6,0x0000, 0x26C7,0x0000, 0x26C8,0x0000, /* 159C */
0x26C9,0x0000, 0x26CA,0x0000, 0x26CB,0x0000, 0x26CC,0x0000, /* 15A0 */
0x26CD,0x0000, 0x26CE,0x0000, 0x26CF,0x0000, 0x26D1,0x0000, /* 15A4 */
0x26D2,0x0000, 0x26D3,0x0000, 0x26D4,0x0000, 0x26D5,0x0000, /* 15A8 */
0x26D6,0x0000, 0x26D7,0x0000, 0x26D8,0x0000, 0x26D9,0x0000, /* 15AC */
0x26DA,0x0000, 0x26DB,0x0000, 0x26DC,0x0000, 0x26DD,0x0000, /* 15B0 */
0x26DE,0x0000, 0x26DF,0x0000, 0x26E0,0x0000, 0x26E1,0x0000, /* 15B4 */
0x26E2,0x0000, 0x26E3,0x0000, 0x26E4,0x0000, 0x26E5,0x0000, /* 15B8 */
0x26E6,0x0000, 0x26E7,0x0000, 0x26E8,0x0000, 0x26E9,0x0000, /* 15BC */
0x26EA,0x0000, 0x26EB,0x0000, 0x26EC,0x0000, 0x26ED,0x0000, /* 15C0 */
0x26EE,0x0000, 0x26EF,0x0000, 0x26F0,0x0000, 0x26F1,0x0000, /* 15C4 */
0x26F2,0x0000, 0x26F3,0x0000, 0x26F4,0x0000, 0x26F5,0x0000, /* 15C8 */
0x26F6,0x0000, 0x26F7,0x0000, 0x26F8,0x0000, 0x26F9,0x0000, /* 15CC */
0x26FA,0x0000, 0x26FB,0x0000, 0x26FC,0x0000, 0x26FD,0x0000, /* 15D0 */
0x26FE,0x0000, 0x26FF,0x0000, 0x2700,0x0000, 0x2701,0x0000, /* 15D4 */
0x2702,0x0000, 0x2703,0x0000, 0x2704,0x0000, 0x2705,0x0000, /* 15D8 */
0x2706,0x0000, 0x2707,0x0000, 0x2708,0x0000, 0x2709,0x0000, /* 15DC */
0x270A,0x0000, 0x270B,0x0000, 0x270C,0x0000, 0x270D,0x0000, /* 15E0 */
0x270E,0x0000, 0x270F,0x0000, 0x2710,0x0000, 0x2711,0x0000, /* 15E4 */
0x2712,0x0000, 0x2713,0x0000, 0x2714,0x0000, 0x2715,0x0000, /* 15E8 */
0x2716,0x0000, 0x2717,0x0000, 0x2718,0x0000, 0x2719,0x0000, /* 15EC */
0x271A,0x0000, 0x271B,0x0000, 0x271C,0x0000, 0x271D,0x0000, /* 15F0 */
0x271E,0x0000, 0x271F,0x0000, 0x2720,0x0000, 0x2721,0x0000, /* 15F4 */
0x2722,0x0000, 0x2723,0x0000, 0x2724,0x0000, 0x2725,0x0000, /* 15F8 */
0x2726,0x0000, 0x2727,0x0000, 0x2728,0x0000, 0x2729,0x0000  /* 15FC */
};

uint16 uca520_p016[]= { /* 1600 (3 weights per char) */
0x272A,0x0000,0x0000, 0x272B,0x0000,0x0000, 0x272C,0x0000,0x0000, /* 1600 */
0x272D,0x0000,0x0000, 0x272E,0x0000,0x0000, 0x272F,0x0000,0x0000, /* 1603 */
0x2730,0x0000,0x0000, 0x2731,0x0000,0x0000, 0x2732,0x0000,0x0000, /* 1606 */
0x2733,0x0000,0x0000, 0x2734,0x0000,0x0000, 0x2735,0x0000,0x0000, /* 1609 */
0x2736,0x0000,0x0000, 0x2737,0x0000,0x0000, 0x2738,0x0000,0x0000, /* 160C */
0x2739,0x0000,0x0000, 0x273A,0x0000,0x0000, 0x273B,0x0000,0x0000, /* 160F */
0x273C,0x0000,0x0000, 0x273D,0x0000,0x0000, 0x273E,0x0000,0x0000, /* 1612 */
0x273F,0x0000,0x0000, 0x2740,0x0000,0x0000, 0x2741,0x0000,0x0000, /* 1615 */
0x2742,0x0000,0x0000, 0x2743,0x0000,0x0000, 0x2744,0x0000,0x0000, /* 1618 */
0x2745,0x0000,0x0000, 0x2746,0x0000,0x0000, 0x2747,0x0000,0x0000, /* 161B */
0x2748,0x0000,0x0000, 0x2749,0x0000,0x0000, 0x274A,0x0000,0x0000, /* 161E */
0x274B,0x0000,0x0000, 0x274C,0x0000,0x0000, 0x274D,0x0000,0x0000, /* 1621 */
0x274E,0x0000,0x0000, 0x274F,0x0000,0x0000, 0x2750,0x0000,0x0000, /* 1624 */
0x2751,0x0000,0x0000, 0x2752,0x0000,0x0000, 0x2753,0x0000,0x0000, /* 1627 */
0x2754,0x0000,0x0000, 0x2755,0x0000,0x0000, 0x2756,0x0000,0x0000, /* 162A */
0x2757,0x0000,0x0000, 0x2758,0x0000,0x0000, 0x2759,0x0000,0x0000, /* 162D */
0x275A,0x0000,0x0000, 0x275B,0x0000,0x0000, 0x275C,0x0000,0x0000, /* 1630 */
0x275D,0x0000,0x0000, 0x275E,0x0000,0x0000, 0x275F,0x0000,0x0000, /* 1633 */
0x2760,0x0000,0x0000, 0x2761,0x0000,0x0000, 0x2762,0x0000,0x0000, /* 1636 */
0x2763,0x0000,0x0000, 0x2764,0x0000,0x0000, 0x2765,0x0000,0x0000, /* 1639 */
0x2766,0x0000,0x0000, 0x2767,0x0000,0x0000, 0x2768,0x0000,0x0000, /* 163C */
0x2769,0x0000,0x0000, 0x276A,0x0000,0x0000, 0x276B,0x0000,0x0000, /* 163F */
0x276C,0x0000,0x0000, 0x276D,0x0000,0x0000, 0x276E,0x0000,0x0000, /* 1642 */
0x276F,0x0000,0x0000, 0x2770,0x0000,0x0000, 0x2771,0x0000,0x0000, /* 1645 */
0x2772,0x0000,0x0000, 0x2773,0x0000,0x0000, 0x2774,0x0000,0x0000, /* 1648 */
0x2775,0x0000,0x0000, 0x2776,0x0000,0x0000, 0x2777,0x0000,0x0000, /* 164B */
0x2778,0x0000,0x0000, 0x2779,0x0000,0x0000, 0x277A,0x0000,0x0000, /* 164E */
0x277B,0x0000,0x0000, 0x277C,0x0000,0x0000, 0x277D,0x0000,0x0000, /* 1651 */
0x277E,0x0000,0x0000, 0x277F,0x0000,0x0000, 0x2780,0x0000,0x0000, /* 1654 */
0x2781,0x0000,0x0000, 0x2782,0x0000,0x0000, 0x2783,0x0000,0x0000, /* 1657 */
0x2784,0x0000,0x0000, 0x2785,0x0000,0x0000, 0x2786,0x0000,0x0000, /* 165A */
0x2787,0x0000,0x0000, 0x2788,0x0000,0x0000, 0x2789,0x0000,0x0000, /* 165D */
0x278A,0x0000,0x0000, 0x278B,0x0000,0x0000, 0x278C,0x0000,0x0000, /* 1660 */
0x278D,0x0000,0x0000, 0x278E,0x0000,0x0000, 0x278F,0x0000,0x0000, /* 1663 */
0x2790,0x0000,0x0000, 0x2791,0x0000,0x0000, 0x2792,0x0000,0x0000, /* 1666 */
0x2793,0x0000,0x0000, 0x2794,0x0000,0x0000, 0x2795,0x0000,0x0000, /* 1669 */
0x2796,0x0000,0x0000, 0x03D8,0x0000,0x0000, 0x0289,0x0000,0x0000, /* 166C */
0x269F,0x0000,0x0000, 0x26B0,0x0000,0x0000, 0x26B9,0x0000,0x0000, /* 166F */
0x26BA,0x0000,0x0000, 0x26BB,0x0000,0x0000, 0x26BC,0x0000,0x0000, /* 1672 */
0x26BD,0x0000,0x0000, 0x26BE,0x0000,0x0000, 0x2797,0x0000,0x0000, /* 1675 */
0x2798,0x0000,0x0000, 0x2799,0x0000,0x0000, 0x279A,0x0000,0x0000, /* 1678 */
0x279B,0x0000,0x0000, 0x279C,0x0000,0x0000, 0x279D,0x0000,0x0000, /* 167B */
0x279E,0x0000,0x0000, 0x279F,0x0000,0x0000, 0x020B,0x0000,0x0000, /* 167E */
0x27E6,0x0000,0x0000, 0x27E7,0x0000,0x0000, 0x27E8,0x0000,0x0000, /* 1681 */
0x27E9,0x0000,0x0000, 0x27EA,0x0000,0x0000, 0x27EB,0x0000,0x0000, /* 1684 */
0x27EC,0x0000,0x0000, 0x27ED,0x0000,0x0000, 0x27EE,0x0000,0x0000, /* 1687 */
0x27EF,0x0000,0x0000, 0x27F0,0x0000,0x0000, 0x27F1,0x0000,0x0000, /* 168A */
0x27F2,0x0000,0x0000, 0x27F3,0x0000,0x0000, 0x27F4,0x0000,0x0000, /* 168D */
0x27F5,0x0000,0x0000, 0x27F6,0x0000,0x0000, 0x27F7,0x0000,0x0000, /* 1690 */
0x27F8,0x0000,0x0000, 0x27F9,0x0000,0x0000, 0x27FA,0x0000,0x0000, /* 1693 */
0x27FB,0x0000,0x0000, 0x27FC,0x0000,0x0000, 0x27FD,0x0000,0x0000, /* 1696 */
0x27FE,0x0000,0x0000, 0x27FF,0x0000,0x0000, 0x0309,0x0000,0x0000, /* 1699 */
0x030A,0x0000,0x0000, 0xFBC0,0x969D,0x0000, 0xFBC0,0x969E,0x0000, /* 169C */
0xFBC0,0x969F,0x0000, 0x2800,0x0000,0x0000, 0x2800,0x0000,0x0000, /* 169F */
0x2801,0x0000,0x0000, 0x281D,0x0000,0x0000, 0x2801,0x0000,0x0000, /* 16A2 */
0x2801,0x0000,0x0000, 0x2802,0x0000,0x0000, 0x2802,0x0000,0x0000, /* 16A5 */
0x2803,0x0000,0x0000, 0x2803,0x0000,0x0000, 0x281B,0x0000,0x0000, /* 16A8 */
0x281C,0x0000,0x0000, 0x2803,0x0000,0x0000, 0x2803,0x0000,0x0000, /* 16AB */
0x2803,0x0000,0x0000, 0x2804,0x0000,0x0000, 0x2805,0x0000,0x0000, /* 16AE */
0x2806,0x0000,0x0000, 0x2807,0x0000,0x0000, 0x2807,0x0000,0x0000, /* 16B1 */
0x2807,0x0000,0x0000, 0x2807,0x0000,0x0000, 0x2807,0x0000,0x0000, /* 16B4 */
0x2808,0x0000,0x0000, 0x2820,0x0000,0x0000, 0x2809,0x0000,0x0000, /* 16B7 */
0x280A,0x0000,0x0000, 0x280A,0x0000,0x0000, 0x280A,0x0000,0x0000, /* 16BA */
0x280A,0x0000,0x0000, 0x280B,0x0000,0x0000, 0x280B,0x0000,0x0000, /* 16BD */
0x280B,0x0000,0x0000, 0x280C,0x0000,0x0000, 0x280C,0x0000,0x0000, /* 16C0 */
0x280D,0x0000,0x0000, 0x280D,0x0000,0x0000, 0x280E,0x0000,0x0000, /* 16C3 */
0x280E,0x0000,0x0000, 0x280F,0x0000,0x0000, 0x2810,0x0000,0x0000, /* 16C6 */
0x2811,0x0000,0x0000, 0x2812,0x0000,0x0000, 0x2812,0x0000,0x0000, /* 16C9 */
0x2812,0x0000,0x0000, 0x2812,0x0000,0x0000, 0x2812,0x0000,0x0000, /* 16CC */
0x2813,0x0000,0x0000, 0x2813,0x0000,0x0000, 0x2813,0x0000,0x0000, /* 16CF */
0x2814,0x0000,0x0000, 0x2814,0x0000,0x0000, 0x2814,0x0000,0x0000, /* 16D2 */
0x2810,0x0000,0x0000, 0x2815,0x0000,0x0000, 0x2816,0x0000,0x0000, /* 16D5 */
0x2816,0x0000,0x0000, 0x2816,0x0000,0x0000, 0x2817,0x0000,0x0000, /* 16D8 */
0x2817,0x0000,0x0000, 0x2818,0x0000,0x0000, 0x2818,0x0000,0x0000, /* 16DB */
0x2819,0x0000,0x0000, 0x281A,0x0000,0x0000, 0x281E,0x0000,0x0000, /* 16DE */
0x2822,0x0000,0x0000, 0x2823,0x0000,0x0000, 0x281F,0x0000,0x0000, /* 16E1 */
0x2821,0x0000,0x0000, 0x2824,0x0000,0x0000, 0x2825,0x0000,0x0000, /* 16E4 */
0x2825,0x0000,0x0000, 0x2825,0x0000,0x0000, 0x2809,0x0000,0x0000, /* 16E7 */
0x2812,0x0000,0x0000, 0x026A,0x0000,0x0000, 0x026B,0x0000,0x0000, /* 16EA */
0x026C,0x0000,0x0000, 0x280E,0x2817,0x0000, 0x2816,0x2816,0x0000, /* 16ED */
0x2802,0x2802,0x0000, 0xFBC0,0x96F1,0x0000, 0xFBC0,0x96F2,0x0000, /* 16F0 */
0xFBC0,0x96F3,0x0000, 0xFBC0,0x96F4,0x0000, 0xFBC0,0x96F5,0x0000, /* 16F3 */
0xFBC0,0x96F6,0x0000, 0xFBC0,0x96F7,0x0000, 0xFBC0,0x96F8,0x0000, /* 16F6 */
0xFBC0,0x96F9,0x0000, 0xFBC0,0x96FA,0x0000, 0xFBC0,0x96FB,0x0000, /* 16F9 */
0xFBC0,0x96FC,0x0000, 0xFBC0,0x96FD,0x0000, 0xFBC0,0x96FE,0x0000, /* 16FC */
0xFBC0,0x96FF,0x0000  };

uint16 uca520_p017[]= { /* 1700 (3 weights per char) */
0x211D,0x0000,0x0000, 0x211E,0x0000,0x0000, 0x211F,0x0000,0x0000, /* 1700 */
0x2120,0x0000,0x0000, 0x2121,0x0000,0x0000, 0x2122,0x0000,0x0000, /* 1703 */
0x2123,0x0000,0x0000, 0x2124,0x0000,0x0000, 0x2125,0x0000,0x0000, /* 1706 */
0x2126,0x0000,0x0000, 0x2127,0x0000,0x0000, 0x2128,0x0000,0x0000, /* 1709 */
0x2129,0x0000,0x0000, 0xFBC0,0x970D,0x0000, 0x212A,0x0000,0x0000, /* 170C */
0x212B,0x0000,0x0000, 0x212C,0x0000,0x0000, 0x212D,0x0000,0x0000, /* 170F */
0x212E,0x0000,0x0000, 0x212F,0x0000,0x0000, 0x2130,0x0000,0x0000, /* 1712 */
0xFBC0,0x9715,0x0000, 0xFBC0,0x9716,0x0000, 0xFBC0,0x9717,0x0000, /* 1715 */
0xFBC0,0x9718,0x0000, 0xFBC0,0x9719,0x0000, 0xFBC0,0x971A,0x0000, /* 1718 */
0xFBC0,0x971B,0x0000, 0xFBC0,0x971C,0x0000, 0xFBC0,0x971D,0x0000, /* 171B */
0xFBC0,0x971E,0x0000, 0xFBC0,0x971F,0x0000, 0x2131,0x0000,0x0000, /* 171E */
0x2132,0x0000,0x0000, 0x2133,0x0000,0x0000, 0x2134,0x0000,0x0000, /* 1721 */
0x2135,0x0000,0x0000, 0x2136,0x0000,0x0000, 0x2137,0x0000,0x0000, /* 1724 */
0x2138,0x0000,0x0000, 0x2139,0x0000,0x0000, 0x213A,0x0000,0x0000, /* 1727 */
0x213B,0x0000,0x0000, 0x213C,0x0000,0x0000, 0x213D,0x0000,0x0000, /* 172A */
0x213E,0x0000,0x0000, 0x213F,0x0000,0x0000, 0x2140,0x0000,0x0000, /* 172D */
0x2141,0x0000,0x0000, 0x2142,0x0000,0x0000, 0x2143,0x0000,0x0000, /* 1730 */
0x2144,0x0000,0x0000, 0x2145,0x0000,0x0000, 0x029C,0x0000,0x0000, /* 1733 */
0x029D,0x0000,0x0000, 0xFBC0,0x9737,0x0000, 0xFBC0,0x9738,0x0000, /* 1736 */
0xFBC0,0x9739,0x0000, 0xFBC0,0x973A,0x0000, 0xFBC0,0x973B,0x0000, /* 1739 */
0xFBC0,0x973C,0x0000, 0xFBC0,0x973D,0x0000, 0xFBC0,0x973E,0x0000, /* 173C */
0xFBC0,0x973F,0x0000, 0x2146,0x0000,0x0000, 0x2147,0x0000,0x0000, /* 173F */
0x2148,0x0000,0x0000, 0x2149,0x0000,0x0000, 0x214A,0x0000,0x0000, /* 1742 */
0x214B,0x0000,0x0000, 0x214C,0x0000,0x0000, 0x214D,0x0000,0x0000, /* 1745 */
0x214E,0x0000,0x0000, 0x214F,0x0000,0x0000, 0x2150,0x0000,0x0000, /* 1748 */
0x2151,0x0000,0x0000, 0x2152,0x0000,0x0000, 0x2153,0x0000,0x0000, /* 174B */
0x2154,0x0000,0x0000, 0x2155,0x0000,0x0000, 0x2156,0x0000,0x0000, /* 174E */
0x2157,0x0000,0x0000, 0x2158,0x0000,0x0000, 0x2159,0x0000,0x0000, /* 1751 */
0xFBC0,0x9754,0x0000, 0xFBC0,0x9755,0x0000, 0xFBC0,0x9756,0x0000, /* 1754 */
0xFBC0,0x9757,0x0000, 0xFBC0,0x9758,0x0000, 0xFBC0,0x9759,0x0000, /* 1757 */
0xFBC0,0x975A,0x0000, 0xFBC0,0x975B,0x0000, 0xFBC0,0x975C,0x0000, /* 175A */
0xFBC0,0x975D,0x0000, 0xFBC0,0x975E,0x0000, 0xFBC0,0x975F,0x0000, /* 175D */
0x215A,0x0000,0x0000, 0x215B,0x0000,0x0000, 0x215C,0x0000,0x0000, /* 1760 */
0x215D,0x0000,0x0000, 0x215E,0x0000,0x0000, 0x215F,0x0000,0x0000, /* 1763 */
0x2160,0x0000,0x0000, 0x2161,0x0000,0x0000, 0x2162,0x0000,0x0000, /* 1766 */
0x2163,0x0000,0x0000, 0x2164,0x0000,0x0000, 0x2165,0x0000,0x0000, /* 1769 */
0x2166,0x0000,0x0000, 0xFBC0,0x976D,0x0000, 0x2167,0x0000,0x0000, /* 176C */
0x2168,0x0000,0x0000, 0x2169,0x0000,0x0000, 0xFBC0,0x9771,0x0000, /* 176F */
0x216A,0x0000,0x0000, 0x216B,0x0000,0x0000, 0xFBC0,0x9774,0x0000, /* 1772 */
0xFBC0,0x9775,0x0000, 0xFBC0,0x9776,0x0000, 0xFBC0,0x9777,0x0000, /* 1775 */
0xFBC0,0x9778,0x0000, 0xFBC0,0x9779,0x0000, 0xFBC0,0x977A,0x0000, /* 1778 */
0xFBC0,0x977B,0x0000, 0xFBC0,0x977C,0x0000, 0xFBC0,0x977D,0x0000, /* 177B */
0xFBC0,0x977E,0x0000, 0xFBC0,0x977F,0x0000, 0x2263,0x0000,0x0000, /* 177E */
0x2264,0x0000,0x0000, 0x2265,0x0000,0x0000, 0x2266,0x0000,0x0000, /* 1781 */
0x2267,0x0000,0x0000, 0x2268,0x0000,0x0000, 0x2269,0x0000,0x0000, /* 1784 */
0x226A,0x0000,0x0000, 0x226B,0x0000,0x0000, 0x226C,0x0000,0x0000, /* 1787 */
0x226D,0x0000,0x0000, 0x226E,0x0000,0x0000, 0x226F,0x0000,0x0000, /* 178A */
0x2270,0x0000,0x0000, 0x2271,0x0000,0x0000, 0x2272,0x0000,0x0000, /* 178D */
0x2273,0x0000,0x0000, 0x2274,0x0000,0x0000, 0x2275,0x0000,0x0000, /* 1790 */
0x2276,0x0000,0x0000, 0x2277,0x0000,0x0000, 0x2278,0x0000,0x0000, /* 1793 */
0x2279,0x0000,0x0000, 0x227A,0x0000,0x0000, 0x227B,0x0000,0x0000, /* 1796 */
0x227C,0x0000,0x0000, 0x227D,0x0000,0x0000, 0x227E,0x0000,0x0000, /* 1799 */
0x227F,0x0000,0x0000, 0x2280,0x0000,0x0000, 0x2281,0x0000,0x0000, /* 179C */
0x2282,0x0000,0x0000, 0x2283,0x0000,0x0000, 0x2284,0x0000,0x0000, /* 179F */
0x2285,0x0000,0x0000, 0x2287,0x0000,0x0000, 0x2288,0x0000,0x0000, /* 17A2 */
0x2289,0x0000,0x0000, 0x228A,0x0000,0x0000, 0x228B,0x0000,0x0000, /* 17A5 */
0x228C,0x0000,0x0000, 0x228D,0x0000,0x0000, 0x228E,0x0000,0x0000, /* 17A8 */
0x228F,0x0000,0x0000, 0x2290,0x0000,0x0000, 0x2291,0x0000,0x0000, /* 17AB */
0x2292,0x0000,0x0000, 0x2293,0x0000,0x0000, 0x2294,0x0000,0x0000, /* 17AE */
0x2295,0x0000,0x0000, 0x2296,0x0000,0x0000, 0x2297,0x0000,0x0000, /* 17B1 */
0x2298,0x0000,0x0000, 0x2299,0x0000,0x0000, 0x229A,0x0000,0x0000, /* 17B4 */
0x229B,0x0000,0x0000, 0x229C,0x0000,0x0000, 0x229D,0x0000,0x0000, /* 17B7 */
0x229E,0x0000,0x0000, 0x229F,0x0000,0x0000, 0x22A0,0x0000,0x0000, /* 17BA */
0x22A1,0x0000,0x0000, 0x22A2,0x0000,0x0000, 0x22A3,0x0000,0x0000, /* 17BD */
0x22A4,0x0000,0x0000, 0x22A5,0x0000,0x0000, 0x22A6,0x0000,0x0000, /* 17C0 */
0x22A7,0x0000,0x0000, 0x22A8,0x0000,0x0000, 0x22A9,0x0000,0x0000, /* 17C3 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 17C6 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 17C9 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 17CC */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 17CF */
0x22AA,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x02A1,0x0000,0x0000, /* 17D2 */
0x02A2,0x0000,0x0000, 0x0267,0x0000,0x0000, 0x03CB,0x0000,0x0000, /* 17D5 */
0x03CC,0x0000,0x0000, 0x03CD,0x0000,0x0000, 0x03CE,0x0000,0x0000, /* 17D8 */
0x11EC,0x0000,0x0000, 0x2286,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 17DB */
0xFBC0,0x97DE,0x0000, 0xFBC0,0x97DF,0x0000, 0x1205,0x0000,0x0000, /* 17DE */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 17E1 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 17E4 */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 17E7 */
0xFBC0,0x97EA,0x0000, 0xFBC0,0x97EB,0x0000, 0xFBC0,0x97EC,0x0000, /* 17EA */
0xFBC0,0x97ED,0x0000, 0xFBC0,0x97EE,0x0000, 0xFBC0,0x97EF,0x0000, /* 17ED */
0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 17F0 */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, /* 17F3 */
0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, /* 17F6 */
0x120E,0x0000,0x0000, 0xFBC0,0x97FA,0x0000, 0xFBC0,0x97FB,0x0000, /* 17F9 */
0xFBC0,0x97FC,0x0000, 0xFBC0,0x97FD,0x0000, 0xFBC0,0x97FE,0x0000, /* 17FC */
0xFBC0,0x97FF,0x0000  };

uint16 uca520_p018[]= { /* 1800 (3 weights per char) */
0x039F,0x0000,0x0000, 0x0282,0x0000,0x0000, 0x023B,0x0000,0x0000, /* 1800 */
0x0287,0x0000,0x0000, 0x0264,0x0000,0x0000, 0x0265,0x0000,0x0000, /* 1803 */
0x0227,0x0000,0x0000, 0x0228,0x0000,0x0000, 0x023C,0x0000,0x0000, /* 1806 */
0x0288,0x0000,0x0000, 0x03A0,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1809 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0207,0x0000,0x0000, /* 180C */
0xFBC0,0x980F,0x0000, 0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, /* 180F */
0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, /* 1812 */
0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, /* 1815 */
0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, 0xFBC0,0x981A,0x0000, /* 1818 */
0xFBC0,0x981B,0x0000, 0xFBC0,0x981C,0x0000, 0xFBC0,0x981D,0x0000, /* 181B */
0xFBC0,0x981E,0x0000, 0xFBC0,0x981F,0x0000, 0x242F,0x0000,0x0000, /* 181E */
0x2431,0x0000,0x0000, 0x2434,0x0000,0x0000, 0x243A,0x0000,0x0000, /* 1821 */
0x243C,0x0000,0x0000, 0x243F,0x0000,0x0000, 0x2441,0x0000,0x0000, /* 1824 */
0x2444,0x0000,0x0000, 0x2445,0x0000,0x0000, 0x2446,0x0000,0x0000, /* 1827 */
0x244B,0x0000,0x0000, 0x244D,0x0000,0x0000, 0x2450,0x0000,0x0000, /* 182A */
0x2452,0x0000,0x0000, 0x2457,0x0000,0x0000, 0x2459,0x0000,0x0000, /* 182D */
0x245A,0x0000,0x0000, 0x245B,0x0000,0x0000, 0x2462,0x0000,0x0000, /* 1830 */
0x2465,0x0000,0x0000, 0x2468,0x0000,0x0000, 0x246D,0x0000,0x0000, /* 1833 */
0x2471,0x0000,0x0000, 0x2474,0x0000,0x0000, 0x2476,0x0000,0x0000, /* 1836 */
0x2478,0x0000,0x0000, 0x247B,0x0000,0x0000, 0x2480,0x0000,0x0000, /* 1839 */
0x2481,0x0000,0x0000, 0x2484,0x0000,0x0000, 0x2488,0x0000,0x0000, /* 183C */
0x248B,0x0000,0x0000, 0x248C,0x0000,0x0000, 0x248D,0x0000,0x0000, /* 183F */
0x248E,0x0000,0x0000, 0x242E,0x0000,0x0000, 0x2432,0x0000,0x0000, /* 1842 */
0x2435,0x0000,0x0000, 0x243B,0x0000,0x0000, 0x243D,0x0000,0x0000, /* 1845 */
0x2440,0x0000,0x0000, 0x2442,0x0000,0x0000, 0x2447,0x0000,0x0000, /* 1848 */
0x244C,0x0000,0x0000, 0x244E,0x0000,0x0000, 0x2451,0x0000,0x0000, /* 184B */
0x2453,0x0000,0x0000, 0x2458,0x0000,0x0000, 0x2463,0x0000,0x0000, /* 184E */
0x2466,0x0000,0x0000, 0x2469,0x0000,0x0000, 0x246E,0x0000,0x0000, /* 1851 */
0x2482,0x0000,0x0000, 0x2472,0x0000,0x0000, 0x2477,0x0000,0x0000, /* 1854 */
0x247C,0x0000,0x0000, 0x2486,0x0000,0x0000, 0x2489,0x0000,0x0000, /* 1857 */
0x248F,0x0000,0x0000, 0x2490,0x0000,0x0000, 0x246B,0x0000,0x0000, /* 185A */
0x2433,0x0000,0x0000, 0x2436,0x0000,0x0000, 0x2439,0x0000,0x0000, /* 185D */
0x2443,0x0000,0x0000, 0x243E,0x0000,0x0000, 0x2448,0x0000,0x0000, /* 1860 */
0x247D,0x0000,0x0000, 0x2454,0x0000,0x0000, 0x2456,0x0000,0x0000, /* 1863 */
0x244F,0x0000,0x0000, 0x245C,0x0000,0x0000, 0x2464,0x0000,0x0000, /* 1866 */
0x2467,0x0000,0x0000, 0x246F,0x0000,0x0000, 0x2479,0x0000,0x0000, /* 1869 */
0x2487,0x0000,0x0000, 0x248A,0x0000,0x0000, 0x2483,0x0000,0x0000, /* 186C */
0x2485,0x0000,0x0000, 0x2491,0x0000,0x0000, 0x246A,0x0000,0x0000, /* 186F */
0x2473,0x0000,0x0000, 0x2437,0x0000,0x0000, 0x247E,0x0000,0x0000, /* 1872 */
0x2475,0x0000,0x0000, 0x247A,0x0000,0x0000, 0x2470,0x0000,0x0000, /* 1875 */
0xFBC0,0x9878,0x0000, 0xFBC0,0x9879,0x0000, 0xFBC0,0x987A,0x0000, /* 1878 */
0xFBC0,0x987B,0x0000, 0xFBC0,0x987C,0x0000, 0xFBC0,0x987D,0x0000, /* 187B */
0xFBC0,0x987E,0x0000, 0xFBC0,0x987F,0x0000, 0x2427,0x0000,0x0000, /* 187E */
0x2428,0x0000,0x0000, 0x2429,0x0000,0x0000, 0x242A,0x0000,0x0000, /* 1881 */
0x242B,0x0000,0x0000, 0x242C,0x0000,0x0000, 0x242D,0x0000,0x0000, /* 1884 */
0x2430,0x0000,0x0000, 0x2438,0x0000,0x0000, 0x247F,0x0000,0x0000, /* 1887 */
0x2449,0x0000,0x0000, 0x246C,0x0000,0x0000, 0x2492,0x0000,0x0000, /* 188A */
0x2494,0x0000,0x0000, 0x2495,0x0000,0x0000, 0x2497,0x0000,0x0000, /* 188D */
0x2498,0x0000,0x0000, 0x249B,0x0000,0x0000, 0x249D,0x0000,0x0000, /* 1890 */
0x249E,0x0000,0x0000, 0x24A0,0x0000,0x0000, 0x24A2,0x0000,0x0000, /* 1893 */
0x24A4,0x0000,0x0000, 0x24A5,0x0000,0x0000, 0x2499,0x0000,0x0000, /* 1896 */
0x24A3,0x0000,0x0000, 0x2455,0x0000,0x0000, 0x244A,0x0000,0x0000, /* 1899 */
0x245D,0x0000,0x0000, 0x245E,0x0000,0x0000, 0x2493,0x0000,0x0000, /* 189C */
0x2496,0x0000,0x0000, 0x249A,0x0000,0x0000, 0x249C,0x0000,0x0000, /* 189F */
0x245F,0x0000,0x0000, 0x24A1,0x0000,0x0000, 0x2460,0x0000,0x0000, /* 18A2 */
0x2461,0x0000,0x0000, 0x24A6,0x0000,0x0000, 0x24A7,0x0000,0x0000, /* 18A5 */
0x249F,0x0000,0x0000, 0x24A9,0x0000,0x0000, 0x24A8,0x0000,0x0000, /* 18A8 */
0xFBC0,0x98AB,0x0000, 0xFBC0,0x98AC,0x0000, 0xFBC0,0x98AD,0x0000, /* 18AB */
0xFBC0,0x98AE,0x0000, 0xFBC0,0x98AF,0x0000, 0x27A0,0x0000,0x0000, /* 18AE */
0x27A1,0x0000,0x0000, 0x27A2,0x0000,0x0000, 0x27A3,0x0000,0x0000, /* 18B1 */
0x27A4,0x0000,0x0000, 0x27A5,0x0000,0x0000, 0x27A6,0x0000,0x0000, /* 18B4 */
0x27A7,0x0000,0x0000, 0x27A8,0x0000,0x0000, 0x27A9,0x0000,0x0000, /* 18B7 */
0x27AA,0x0000,0x0000, 0x27AB,0x0000,0x0000, 0x27AC,0x0000,0x0000, /* 18BA */
0x27AD,0x0000,0x0000, 0x27AE,0x0000,0x0000, 0x27AF,0x0000,0x0000, /* 18BD */
0x27B0,0x0000,0x0000, 0x27B1,0x0000,0x0000, 0x27B2,0x0000,0x0000, /* 18C0 */
0x27B3,0x0000,0x0000, 0x27B4,0x0000,0x0000, 0x27B5,0x0000,0x0000, /* 18C3 */
0x27B6,0x0000,0x0000, 0x27B7,0x0000,0x0000, 0x27B8,0x0000,0x0000, /* 18C6 */
0x27B9,0x0000,0x0000, 0x27BA,0x0000,0x0000, 0x27BB,0x0000,0x0000, /* 18C9 */
0x27BC,0x0000,0x0000, 0x27BD,0x0000,0x0000, 0x27BE,0x0000,0x0000, /* 18CC */
0x27BF,0x0000,0x0000, 0x27C0,0x0000,0x0000, 0x27C1,0x0000,0x0000, /* 18CF */
0x27C2,0x0000,0x0000, 0x27C3,0x0000,0x0000, 0x27C4,0x0000,0x0000, /* 18D2 */
0x27C5,0x0000,0x0000, 0x27C6,0x0000,0x0000, 0x27C7,0x0000,0x0000, /* 18D5 */
0x27C8,0x0000,0x0000, 0x27C9,0x0000,0x0000, 0x27CA,0x0000,0x0000, /* 18D8 */
0x27CB,0x0000,0x0000, 0x27CC,0x0000,0x0000, 0x27CD,0x0000,0x0000, /* 18DB */
0x27CE,0x0000,0x0000, 0x27CF,0x0000,0x0000, 0x27D0,0x0000,0x0000, /* 18DE */
0x27D1,0x0000,0x0000, 0x27D2,0x0000,0x0000, 0x27D3,0x0000,0x0000, /* 18E1 */
0x27D4,0x0000,0x0000, 0x27D5,0x0000,0x0000, 0x27D6,0x0000,0x0000, /* 18E4 */
0x27D7,0x0000,0x0000, 0x27D8,0x0000,0x0000, 0x27D9,0x0000,0x0000, /* 18E7 */
0x27DA,0x0000,0x0000, 0x27DB,0x0000,0x0000, 0x27DC,0x0000,0x0000, /* 18EA */
0x27DD,0x0000,0x0000, 0x27DE,0x0000,0x0000, 0x27DF,0x0000,0x0000, /* 18ED */
0x27E0,0x0000,0x0000, 0x27E1,0x0000,0x0000, 0x27E2,0x0000,0x0000, /* 18F0 */
0x27E3,0x0000,0x0000, 0x27E4,0x0000,0x0000, 0x27E5,0x0000,0x0000, /* 18F3 */
0xFBC0,0x98F6,0x0000, 0xFBC0,0x98F7,0x0000, 0xFBC0,0x98F8,0x0000, /* 18F6 */
0xFBC0,0x98F9,0x0000, 0xFBC0,0x98FA,0x0000, 0xFBC0,0x98FB,0x0000, /* 18F9 */
0xFBC0,0x98FC,0x0000, 0xFBC0,0x98FD,0x0000, 0xFBC0,0x98FE,0x0000, /* 18FC */
0xFBC0,0x98FF,0x0000  };

uint16 uca520_p019[]= { /* 1900 (4 weights per char) */
0x20EB,0x0000,0x0000,0x0000, 0x20EC,0x0000,0x0000,0x0000, /* 1900 */
0x20ED,0x0000,0x0000,0x0000, 0x20EE,0x0000,0x0000,0x0000, /* 1902 */
0x20EF,0x0000,0x0000,0x0000, 0x20F0,0x0000,0x0000,0x0000, /* 1904 */
0x20F1,0x0000,0x0000,0x0000, 0x20F2,0x0000,0x0000,0x0000, /* 1906 */
0x20F3,0x0000,0x0000,0x0000, 0x20F4,0x0000,0x0000,0x0000, /* 1908 */
0x20F5,0x0000,0x0000,0x0000, 0x20F6,0x0000,0x0000,0x0000, /* 190A */
0x20F7,0x0000,0x0000,0x0000, 0x20F8,0x0000,0x0000,0x0000, /* 190C */
0x20F9,0x0000,0x0000,0x0000, 0x20FA,0x0000,0x0000,0x0000, /* 190E */
0x20FB,0x0000,0x0000,0x0000, 0x20FC,0x0000,0x0000,0x0000, /* 1910 */
0x20FD,0x0000,0x0000,0x0000, 0x20FE,0x0000,0x0000,0x0000, /* 1912 */
0x20FF,0x0000,0x0000,0x0000, 0x2100,0x0000,0x0000,0x0000, /* 1914 */
0x2101,0x0000,0x0000,0x0000, 0x2102,0x0000,0x0000,0x0000, /* 1916 */
0x2103,0x0000,0x0000,0x0000, 0x2104,0x0000,0x0000,0x0000, /* 1918 */
0x2105,0x0000,0x0000,0x0000, 0x2106,0x0000,0x0000,0x0000, /* 191A */
0x2107,0x0000,0x0000,0x0000, 0xFBC0,0x991D,0x0000,0x0000, /* 191C */
0xFBC0,0x991E,0x0000,0x0000, 0xFBC0,0x991F,0x0000,0x0000, /* 191E */
0x2108,0x0000,0x0000,0x0000, 0x2109,0x0000,0x0000,0x0000, /* 1920 */
0x210A,0x0000,0x0000,0x0000, 0x210B,0x0000,0x0000,0x0000, /* 1922 */
0x210C,0x0000,0x0000,0x0000, 0x210D,0x0000,0x0000,0x0000, /* 1924 */
0x210E,0x0000,0x0000,0x0000, 0x210F,0x0000,0x0000,0x0000, /* 1926 */
0x2110,0x0000,0x0000,0x0000, 0x2111,0x0000,0x0000,0x0000, /* 1928 */
0x2112,0x0000,0x0000,0x0000, 0x2113,0x0000,0x0000,0x0000, /* 192A */
0xFBC0,0x992C,0x0000,0x0000, 0xFBC0,0x992D,0x0000,0x0000, /* 192C */
0xFBC0,0x992E,0x0000,0x0000, 0xFBC0,0x992F,0x0000,0x0000, /* 192E */
0x2114,0x0000,0x0000,0x0000, 0x2115,0x0000,0x0000,0x0000, /* 1930 */
0x2116,0x0000,0x0000,0x0000, 0x2117,0x0000,0x0000,0x0000, /* 1932 */
0x2118,0x0000,0x0000,0x0000, 0x2119,0x0000,0x0000,0x0000, /* 1934 */
0x211A,0x0000,0x0000,0x0000, 0x211B,0x0000,0x0000,0x0000, /* 1936 */
0x211C,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 1938 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 193A */
0xFBC0,0x993C,0x0000,0x0000, 0xFBC0,0x993D,0x0000,0x0000, /* 193C */
0xFBC0,0x993E,0x0000,0x0000, 0xFBC0,0x993F,0x0000,0x0000, /* 193E */
0x03C1,0x0000,0x0000,0x0000, 0xFBC0,0x9941,0x0000,0x0000, /* 1940 */
0xFBC0,0x9942,0x0000,0x0000, 0xFBC0,0x9943,0x0000,0x0000, /* 1942 */
0x0272,0x0000,0x0000,0x0000, 0x027A,0x0000,0x0000,0x0000, /* 1944 */
0x1205,0x0000,0x0000,0x0000, 0x1206,0x0000,0x0000,0x0000, /* 1946 */
0x1207,0x0000,0x0000,0x0000, 0x1208,0x0000,0x0000,0x0000, /* 1948 */
0x1209,0x0000,0x0000,0x0000, 0x120A,0x0000,0x0000,0x0000, /* 194A */
0x120B,0x0000,0x0000,0x0000, 0x120C,0x0000,0x0000,0x0000, /* 194C */
0x120D,0x0000,0x0000,0x0000, 0x120E,0x0000,0x0000,0x0000, /* 194E */
0x22AB,0x0000,0x0000,0x0000, 0x22AC,0x0000,0x0000,0x0000, /* 1950 */
0x22AD,0x0000,0x0000,0x0000, 0x22AE,0x0000,0x0000,0x0000, /* 1952 */
0x22AF,0x0000,0x0000,0x0000, 0x22B0,0x0000,0x0000,0x0000, /* 1954 */
0x22B1,0x0000,0x0000,0x0000, 0x22B2,0x0000,0x0000,0x0000, /* 1956 */
0x22B3,0x0000,0x0000,0x0000, 0x22B4,0x0000,0x0000,0x0000, /* 1958 */
0x22B5,0x0000,0x0000,0x0000, 0x22B6,0x0000,0x0000,0x0000, /* 195A */
0x22B7,0x0000,0x0000,0x0000, 0x22B8,0x0000,0x0000,0x0000, /* 195C */
0x22B9,0x0000,0x0000,0x0000, 0x22BA,0x0000,0x0000,0x0000, /* 195E */
0x22BB,0x0000,0x0000,0x0000, 0x22BC,0x0000,0x0000,0x0000, /* 1960 */
0x22BD,0x0000,0x0000,0x0000, 0x22BE,0x0000,0x0000,0x0000, /* 1962 */
0x22BF,0x0000,0x0000,0x0000, 0x22C0,0x0000,0x0000,0x0000, /* 1964 */
0x22C1,0x0000,0x0000,0x0000, 0x22C2,0x0000,0x0000,0x0000, /* 1966 */
0x22C3,0x0000,0x0000,0x0000, 0x22C4,0x0000,0x0000,0x0000, /* 1968 */
0x22C5,0x0000,0x0000,0x0000, 0x22C6,0x0000,0x0000,0x0000, /* 196A */
0x22C7,0x0000,0x0000,0x0000, 0x22C8,0x0000,0x0000,0x0000, /* 196C */
0xFBC0,0x996E,0x0000,0x0000, 0xFBC0,0x996F,0x0000,0x0000, /* 196E */
0x22C9,0x0000,0x0000,0x0000, 0x22CA,0x0000,0x0000,0x0000, /* 1970 */
0x22CB,0x0000,0x0000,0x0000, 0x22CC,0x0000,0x0000,0x0000, /* 1972 */
0x22CD,0x0000,0x0000,0x0000, 0xFBC0,0x9975,0x0000,0x0000, /* 1974 */
0xFBC0,0x9976,0x0000,0x0000, 0xFBC0,0x9977,0x0000,0x0000, /* 1976 */
0xFBC0,0x9978,0x0000,0x0000, 0xFBC0,0x9979,0x0000,0x0000, /* 1978 */
0xFBC0,0x997A,0x0000,0x0000, 0xFBC0,0x997B,0x0000,0x0000, /* 197A */
0xFBC0,0x997C,0x0000,0x0000, 0xFBC0,0x997D,0x0000,0x0000, /* 197C */
0xFBC0,0x997E,0x0000,0x0000, 0xFBC0,0x997F,0x0000,0x0000, /* 197E */
0x22CE,0x0000,0x0000,0x0000, 0x22CF,0x0000,0x0000,0x0000, /* 1980 */
0x22D0,0x0000,0x0000,0x0000, 0x22D1,0x0000,0x0000,0x0000, /* 1982 */
0x22D2,0x0000,0x0000,0x0000, 0x22D3,0x0000,0x0000,0x0000, /* 1984 */
0x22D4,0x0000,0x0000,0x0000, 0x22D5,0x0000,0x0000,0x0000, /* 1986 */
0x22D6,0x0000,0x0000,0x0000, 0x22D7,0x0000,0x0000,0x0000, /* 1988 */
0x22D8,0x0000,0x0000,0x0000, 0x22D9,0x0000,0x0000,0x0000, /* 198A */
0x22DA,0x0000,0x0000,0x0000, 0x22DB,0x0000,0x0000,0x0000, /* 198C */
0x22DC,0x0000,0x0000,0x0000, 0x22DD,0x0000,0x0000,0x0000, /* 198E */
0x22DE,0x0000,0x0000,0x0000, 0x22DF,0x0000,0x0000,0x0000, /* 1990 */
0x22E0,0x0000,0x0000,0x0000, 0x22E1,0x0000,0x0000,0x0000, /* 1992 */
0x22E2,0x0000,0x0000,0x0000, 0x22E3,0x0000,0x0000,0x0000, /* 1994 */
0x22E4,0x0000,0x0000,0x0000, 0x22E5,0x0000,0x0000,0x0000, /* 1996 */
0x22E6,0x0000,0x0000,0x0000, 0x22E7,0x0000,0x0000,0x0000, /* 1998 */
0x22E8,0x0000,0x0000,0x0000, 0x22E9,0x0000,0x0000,0x0000, /* 199A */
0x22EA,0x0000,0x0000,0x0000, 0x22EB,0x0000,0x0000,0x0000, /* 199C */
0x22EC,0x0000,0x0000,0x0000, 0x22ED,0x0000,0x0000,0x0000, /* 199E */
0x22EE,0x0000,0x0000,0x0000, 0x22EF,0x0000,0x0000,0x0000, /* 19A0 */
0x22F0,0x0000,0x0000,0x0000, 0x22F1,0x0000,0x0000,0x0000, /* 19A2 */
0x22F2,0x0000,0x0000,0x0000, 0x22F3,0x0000,0x0000,0x0000, /* 19A4 */
0x22F4,0x0000,0x0000,0x0000, 0x22F5,0x0000,0x0000,0x0000, /* 19A6 */
0x22F6,0x0000,0x0000,0x0000, 0x22F7,0x0000,0x0000,0x0000, /* 19A8 */
0x22F8,0x0000,0x0000,0x0000, 0x22F9,0x0000,0x0000,0x0000, /* 19AA */
0xFBC0,0x99AC,0x0000,0x0000, 0xFBC0,0x99AD,0x0000,0x0000, /* 19AC */
0xFBC0,0x99AE,0x0000,0x0000, 0xFBC0,0x99AF,0x0000,0x0000, /* 19AE */
0x22FA,0x0000,0x0000,0x0000, 0x22FB,0x0000,0x0000,0x0000, /* 19B0 */
0x22FC,0x0000,0x0000,0x0000, 0x22FD,0x0000,0x0000,0x0000, /* 19B2 */
0x22FE,0x0000,0x0000,0x0000, 0x22FF,0x0000,0x0000,0x0000, /* 19B4 */
0x2300,0x0000,0x0000,0x0000, 0x2301,0x0000,0x0000,0x0000, /* 19B6 */
0x2302,0x0000,0x0000,0x0000, 0x2303,0x0000,0x0000,0x0000, /* 19B8 */
0x2304,0x0000,0x0000,0x0000, 0x2305,0x0000,0x0000,0x0000, /* 19BA */
0x2306,0x0000,0x0000,0x0000, 0x2307,0x0000,0x0000,0x0000, /* 19BC */
0x2308,0x0000,0x0000,0x0000, 0x2309,0x0000,0x0000,0x0000, /* 19BE */
0x230A,0x0000,0x0000,0x0000, 0x230B,0x0000,0x0000,0x0000, /* 19C0 */
0x230C,0x0000,0x0000,0x0000, 0x230D,0x0000,0x0000,0x0000, /* 19C2 */
0x230E,0x0000,0x0000,0x0000, 0x230F,0x0000,0x0000,0x0000, /* 19C4 */
0x2310,0x0000,0x0000,0x0000, 0x2311,0x0000,0x0000,0x0000, /* 19C6 */
0x2312,0x0000,0x0000,0x0000, 0x2313,0x0000,0x0000,0x0000, /* 19C8 */
0xFBC0,0x99CA,0x0000,0x0000, 0xFBC0,0x99CB,0x0000,0x0000, /* 19CA */
0xFBC0,0x99CC,0x0000,0x0000, 0xFBC0,0x99CD,0x0000,0x0000, /* 19CC */
0xFBC0,0x99CE,0x0000,0x0000, 0xFBC0,0x99CF,0x0000,0x0000, /* 19CE */
0x1205,0x0000,0x0000,0x0000, 0x1206,0x0000,0x0000,0x0000, /* 19D0 */
0x1207,0x0000,0x0000,0x0000, 0x1208,0x0000,0x0000,0x0000, /* 19D2 */
0x1209,0x0000,0x0000,0x0000, 0x120A,0x0000,0x0000,0x0000, /* 19D4 */
0x120B,0x0000,0x0000,0x0000, 0x120C,0x0000,0x0000,0x0000, /* 19D6 */
0x120D,0x0000,0x0000,0x0000, 0x120E,0x0000,0x0000,0x0000, /* 19D8 */
0x1206,0x0000,0x0000,0x0000, 0xFBC0,0x99DB,0x0000,0x0000, /* 19DA */
0xFBC0,0x99DC,0x0000,0x0000, 0xFBC0,0x99DD,0x0000,0x0000, /* 19DC */
0x22EA,0x2300,0x0000,0x0000, 0x22EA,0x2300,0x230B,0x0000, /* 19DE */
0x048E,0x0000,0x0000,0x0000, 0x048F,0x0000,0x0000,0x0000, /* 19E0 */
0x0490,0x0000,0x0000,0x0000, 0x0491,0x0000,0x0000,0x0000, /* 19E2 */
0x0492,0x0000,0x0000,0x0000, 0x0493,0x0000,0x0000,0x0000, /* 19E4 */
0x0494,0x0000,0x0000,0x0000, 0x0495,0x0000,0x0000,0x0000, /* 19E6 */
0x0496,0x0000,0x0000,0x0000, 0x0497,0x0000,0x0000,0x0000, /* 19E8 */
0x0498,0x0000,0x0000,0x0000, 0x0499,0x0000,0x0000,0x0000, /* 19EA */
0x049A,0x0000,0x0000,0x0000, 0x049B,0x0000,0x0000,0x0000, /* 19EC */
0x049C,0x0000,0x0000,0x0000, 0x049D,0x0000,0x0000,0x0000, /* 19EE */
0x049E,0x0000,0x0000,0x0000, 0x049F,0x0000,0x0000,0x0000, /* 19F0 */
0x04A0,0x0000,0x0000,0x0000, 0x04A1,0x0000,0x0000,0x0000, /* 19F2 */
0x04A2,0x0000,0x0000,0x0000, 0x04A3,0x0000,0x0000,0x0000, /* 19F4 */
0x04A4,0x0000,0x0000,0x0000, 0x04A5,0x0000,0x0000,0x0000, /* 19F6 */
0x04A6,0x0000,0x0000,0x0000, 0x04A7,0x0000,0x0000,0x0000, /* 19F8 */
0x04A8,0x0000,0x0000,0x0000, 0x04A9,0x0000,0x0000,0x0000, /* 19FA */
0x04AA,0x0000,0x0000,0x0000, 0x04AB,0x0000,0x0000,0x0000, /* 19FC */
0x04AC,0x0000,0x0000,0x0000, 0x04AD,0x0000,0x0000,0x0000  /* 19FE */
};

uint16 uca520_p01A[]= { /* 1A00 (4 weights per char) */
0x216C,0x0000,0x0000,0x0000, 0x216D,0x0000,0x0000,0x0000, /* 1A00 */
0x216E,0x0000,0x0000,0x0000, 0x216F,0x0000,0x0000,0x0000, /* 1A02 */
0x2170,0x0000,0x0000,0x0000, 0x2171,0x0000,0x0000,0x0000, /* 1A04 */
0x2172,0x0000,0x0000,0x0000, 0x2173,0x0000,0x0000,0x0000, /* 1A06 */
0x2174,0x0000,0x0000,0x0000, 0x2175,0x0000,0x0000,0x0000, /* 1A08 */
0x2176,0x0000,0x0000,0x0000, 0x2177,0x0000,0x0000,0x0000, /* 1A0A */
0x2178,0x0000,0x0000,0x0000, 0x2179,0x0000,0x0000,0x0000, /* 1A0C */
0x217A,0x0000,0x0000,0x0000, 0x217B,0x0000,0x0000,0x0000, /* 1A0E */
0x217C,0x0000,0x0000,0x0000, 0x217D,0x0000,0x0000,0x0000, /* 1A10 */
0x217E,0x0000,0x0000,0x0000, 0x217F,0x0000,0x0000,0x0000, /* 1A12 */
0x2180,0x0000,0x0000,0x0000, 0x2181,0x0000,0x0000,0x0000, /* 1A14 */
0x2182,0x0000,0x0000,0x0000, 0x2183,0x0000,0x0000,0x0000, /* 1A16 */
0x2184,0x0000,0x0000,0x0000, 0x2185,0x0000,0x0000,0x0000, /* 1A18 */
0x2186,0x0000,0x0000,0x0000, 0x2187,0x0000,0x0000,0x0000, /* 1A1A */
0xFBC0,0x9A1C,0x0000,0x0000, 0xFBC0,0x9A1D,0x0000,0x0000, /* 1A1C */
0x02BA,0x0000,0x0000,0x0000, 0x02BB,0x0000,0x0000,0x0000, /* 1A1E */
0x2314,0x0000,0x0000,0x0000, 0x2315,0x0000,0x0000,0x0000, /* 1A20 */
0x2316,0x0000,0x0000,0x0000, 0x2317,0x0000,0x0000,0x0000, /* 1A22 */
0x2318,0x0000,0x0000,0x0000, 0x2319,0x0000,0x0000,0x0000, /* 1A24 */
0x231A,0x0000,0x0000,0x0000, 0x231B,0x0000,0x0000,0x0000, /* 1A26 */
0x231C,0x0000,0x0000,0x0000, 0x231D,0x0000,0x0000,0x0000, /* 1A28 */
0x231E,0x0000,0x0000,0x0000, 0x231F,0x0000,0x0000,0x0000, /* 1A2A */
0x2320,0x0000,0x0000,0x0000, 0x2321,0x0000,0x0000,0x0000, /* 1A2C */
0x2322,0x0000,0x0000,0x0000, 0x2323,0x0000,0x0000,0x0000, /* 1A2E */
0x2324,0x0000,0x0000,0x0000, 0x2325,0x0000,0x0000,0x0000, /* 1A30 */
0x2326,0x0000,0x0000,0x0000, 0x2327,0x0000,0x0000,0x0000, /* 1A32 */
0x2328,0x0000,0x0000,0x0000, 0x2329,0x0000,0x0000,0x0000, /* 1A34 */
0x232A,0x0000,0x0000,0x0000, 0x232B,0x0000,0x0000,0x0000, /* 1A36 */
0x232C,0x0000,0x0000,0x0000, 0x232D,0x0000,0x0000,0x0000, /* 1A38 */
0x232E,0x0000,0x0000,0x0000, 0x232F,0x0000,0x0000,0x0000, /* 1A3A */
0x2330,0x0000,0x0000,0x0000, 0x2331,0x0000,0x0000,0x0000, /* 1A3C */
0x2332,0x0000,0x0000,0x0000, 0x2333,0x0000,0x0000,0x0000, /* 1A3E */
0x2334,0x0000,0x0000,0x0000, 0x2335,0x0000,0x0000,0x0000, /* 1A40 */
0x2336,0x0000,0x0000,0x0000, 0x2337,0x0000,0x0000,0x0000, /* 1A42 */
0x2338,0x0000,0x0000,0x0000, 0x2339,0x0000,0x0000,0x0000, /* 1A44 */
0x233A,0x0000,0x0000,0x0000, 0x233B,0x0000,0x0000,0x0000, /* 1A46 */
0x233C,0x0000,0x0000,0x0000, 0x233D,0x0000,0x0000,0x0000, /* 1A48 */
0x233E,0x0000,0x0000,0x0000, 0x233F,0x0000,0x0000,0x0000, /* 1A4A */
0x2340,0x0000,0x0000,0x0000, 0x2349,0x0000,0x0000,0x0000, /* 1A4C */
0x234A,0x0000,0x0000,0x0000, 0x234B,0x0000,0x0000,0x0000, /* 1A4E */
0x234C,0x0000,0x0000,0x0000, 0x234D,0x0000,0x0000,0x0000, /* 1A50 */
0x234E,0x0000,0x0000,0x0000, 0x2341,0x0000,0x0000,0x0000, /* 1A52 */
0x233A,0x2360,0x233A,0x0000, 0x2343,0x0000,0x0000,0x0000, /* 1A54 */
0x2344,0x0000,0x0000,0x0000, 0x2345,0x0000,0x0000,0x0000, /* 1A56 */
0x231A,0x0000,0x0000,0x0000, 0x231A,0x0000,0x0000,0x0000, /* 1A58 */
0x232F,0x0000,0x0000,0x0000, 0x232F,0x0000,0x0000,0x0000, /* 1A5A */
0x2346,0x0000,0x0000,0x0000, 0x2347,0x0000,0x0000,0x0000, /* 1A5C */
0x2348,0x0000,0x0000,0x0000, 0xFBC0,0x9A5F,0x0000,0x0000, /* 1A5E */
0x2360,0x0000,0x0000,0x0000, 0x234F,0x0000,0x0000,0x0000, /* 1A60 */
0x2351,0x0000,0x0000,0x0000, 0x2352,0x0000,0x0000,0x0000, /* 1A62 */
0x2352,0x0000,0x0000,0x0000, 0x2353,0x0000,0x0000,0x0000, /* 1A64 */
0x2354,0x0000,0x0000,0x0000, 0x2355,0x0000,0x0000,0x0000, /* 1A66 */
0x2356,0x0000,0x0000,0x0000, 0x2357,0x0000,0x0000,0x0000, /* 1A68 */
0x2358,0x0000,0x0000,0x0000, 0x2342,0x0000,0x0000,0x0000, /* 1A6A */
0x2350,0x0000,0x0000,0x0000, 0x235F,0x0000,0x0000,0x0000, /* 1A6C */
0x2359,0x0000,0x0000,0x0000, 0x235A,0x0000,0x0000,0x0000, /* 1A6E */
0x235C,0x0000,0x0000,0x0000, 0x235D,0x0000,0x0000,0x0000, /* 1A70 */
0x235E,0x0000,0x0000,0x0000, 0x235B,0x0000,0x0000,0x0000, /* 1A72 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 1A74 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 1A76 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 1A78 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 1A7A */
0x0000,0x0000,0x0000,0x0000, 0xFBC0,0x9A7D,0x0000,0x0000, /* 1A7C */
0xFBC0,0x9A7E,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 1A7E */
0x1205,0x0000,0x0000,0x0000, 0x1206,0x0000,0x0000,0x0000, /* 1A80 */
0x1207,0x0000,0x0000,0x0000, 0x1208,0x0000,0x0000,0x0000, /* 1A82 */
0x1209,0x0000,0x0000,0x0000, 0x120A,0x0000,0x0000,0x0000, /* 1A84 */
0x120B,0x0000,0x0000,0x0000, 0x120C,0x0000,0x0000,0x0000, /* 1A86 */
0x120D,0x0000,0x0000,0x0000, 0x120E,0x0000,0x0000,0x0000, /* 1A88 */
0xFBC0,0x9A8A,0x0000,0x0000, 0xFBC0,0x9A8B,0x0000,0x0000, /* 1A8A */
0xFBC0,0x9A8C,0x0000,0x0000, 0xFBC0,0x9A8D,0x0000,0x0000, /* 1A8C */
0xFBC0,0x9A8E,0x0000,0x0000, 0xFBC0,0x9A8F,0x0000,0x0000, /* 1A8E */
0x1205,0x0000,0x0000,0x0000, 0x1206,0x0000,0x0000,0x0000, /* 1A90 */
0x1207,0x0000,0x0000,0x0000, 0x1208,0x0000,0x0000,0x0000, /* 1A92 */
0x1209,0x0000,0x0000,0x0000, 0x120A,0x0000,0x0000,0x0000, /* 1A94 */
0x120B,0x0000,0x0000,0x0000, 0x120C,0x0000,0x0000,0x0000, /* 1A96 */
0x120D,0x0000,0x0000,0x0000, 0x120E,0x0000,0x0000,0x0000, /* 1A98 */
0xFBC0,0x9A9A,0x0000,0x0000, 0xFBC0,0x9A9B,0x0000,0x0000, /* 1A9A */
0xFBC0,0x9A9C,0x0000,0x0000, 0xFBC0,0x9A9D,0x0000,0x0000, /* 1A9C */
0xFBC0,0x9A9E,0x0000,0x0000, 0xFBC0,0x9A9F,0x0000,0x0000, /* 1A9E */
0x03CF,0x0000,0x0000,0x0000, 0x03D0,0x0000,0x0000,0x0000, /* 1AA0 */
0x03D1,0x0000,0x0000,0x0000, 0x03D2,0x0000,0x0000,0x0000, /* 1AA2 */
0x03D3,0x0000,0x0000,0x0000, 0x03D4,0x0000,0x0000,0x0000, /* 1AA4 */
0x03D5,0x0000,0x0000,0x0000, 0x11D3,0x0000,0x0000,0x0000, /* 1AA6 */
0x02A3,0x0000,0x0000,0x0000, 0x02A4,0x0000,0x0000,0x0000, /* 1AA8 */
0x02A5,0x0000,0x0000,0x0000, 0x02A6,0x0000,0x0000,0x0000, /* 1AAA */
0x03D6,0x0000,0x0000,0x0000, 0x03D7,0x0000,0x0000,0x0000, /* 1AAC */
0xFBC0,0x9AAE,0x0000,0x0000, 0xFBC0,0x9AAF,0x0000,0x0000, /* 1AAE */
0xFBC0,0x9AB0,0x0000,0x0000, 0xFBC0,0x9AB1,0x0000,0x0000, /* 1AB0 */
0xFBC0,0x9AB2,0x0000,0x0000, 0xFBC0,0x9AB3,0x0000,0x0000, /* 1AB2 */
0xFBC0,0x9AB4,0x0000,0x0000, 0xFBC0,0x9AB5,0x0000,0x0000, /* 1AB4 */
0xFBC0,0x9AB6,0x0000,0x0000, 0xFBC0,0x9AB7,0x0000,0x0000, /* 1AB6 */
0xFBC0,0x9AB8,0x0000,0x0000, 0xFBC0,0x9AB9,0x0000,0x0000, /* 1AB8 */
0xFBC0,0x9ABA,0x0000,0x0000, 0xFBC0,0x9ABB,0x0000,0x0000, /* 1ABA */
0xFBC0,0x9ABC,0x0000,0x0000, 0xFBC0,0x9ABD,0x0000,0x0000, /* 1ABC */
0xFBC0,0x9ABE,0x0000,0x0000, 0xFBC0,0x9ABF,0x0000,0x0000, /* 1ABE */
0xFBC0,0x9AC0,0x0000,0x0000, 0xFBC0,0x9AC1,0x0000,0x0000, /* 1AC0 */
0xFBC0,0x9AC2,0x0000,0x0000, 0xFBC0,0x9AC3,0x0000,0x0000, /* 1AC2 */
0xFBC0,0x9AC4,0x0000,0x0000, 0xFBC0,0x9AC5,0x0000,0x0000, /* 1AC4 */
0xFBC0,0x9AC6,0x0000,0x0000, 0xFBC0,0x9AC7,0x0000,0x0000, /* 1AC6 */
0xFBC0,0x9AC8,0x0000,0x0000, 0xFBC0,0x9AC9,0x0000,0x0000, /* 1AC8 */
0xFBC0,0x9ACA,0x0000,0x0000, 0xFBC0,0x9ACB,0x0000,0x0000, /* 1ACA */
0xFBC0,0x9ACC,0x0000,0x0000, 0xFBC0,0x9ACD,0x0000,0x0000, /* 1ACC */
0xFBC0,0x9ACE,0x0000,0x0000, 0xFBC0,0x9ACF,0x0000,0x0000, /* 1ACE */
0xFBC0,0x9AD0,0x0000,0x0000, 0xFBC0,0x9AD1,0x0000,0x0000, /* 1AD0 */
0xFBC0,0x9AD2,0x0000,0x0000, 0xFBC0,0x9AD3,0x0000,0x0000, /* 1AD2 */
0xFBC0,0x9AD4,0x0000,0x0000, 0xFBC0,0x9AD5,0x0000,0x0000, /* 1AD4 */
0xFBC0,0x9AD6,0x0000,0x0000, 0xFBC0,0x9AD7,0x0000,0x0000, /* 1AD6 */
0xFBC0,0x9AD8,0x0000,0x0000, 0xFBC0,0x9AD9,0x0000,0x0000, /* 1AD8 */
0xFBC0,0x9ADA,0x0000,0x0000, 0xFBC0,0x9ADB,0x0000,0x0000, /* 1ADA */
0xFBC0,0x9ADC,0x0000,0x0000, 0xFBC0,0x9ADD,0x0000,0x0000, /* 1ADC */
0xFBC0,0x9ADE,0x0000,0x0000, 0xFBC0,0x9ADF,0x0000,0x0000, /* 1ADE */
0xFBC0,0x9AE0,0x0000,0x0000, 0xFBC0,0x9AE1,0x0000,0x0000, /* 1AE0 */
0xFBC0,0x9AE2,0x0000,0x0000, 0xFBC0,0x9AE3,0x0000,0x0000, /* 1AE2 */
0xFBC0,0x9AE4,0x0000,0x0000, 0xFBC0,0x9AE5,0x0000,0x0000, /* 1AE4 */
0xFBC0,0x9AE6,0x0000,0x0000, 0xFBC0,0x9AE7,0x0000,0x0000, /* 1AE6 */
0xFBC0,0x9AE8,0x0000,0x0000, 0xFBC0,0x9AE9,0x0000,0x0000, /* 1AE8 */
0xFBC0,0x9AEA,0x0000,0x0000, 0xFBC0,0x9AEB,0x0000,0x0000, /* 1AEA */
0xFBC0,0x9AEC,0x0000,0x0000, 0xFBC0,0x9AED,0x0000,0x0000, /* 1AEC */
0xFBC0,0x9AEE,0x0000,0x0000, 0xFBC0,0x9AEF,0x0000,0x0000, /* 1AEE */
0xFBC0,0x9AF0,0x0000,0x0000, 0xFBC0,0x9AF1,0x0000,0x0000, /* 1AF0 */
0xFBC0,0x9AF2,0x0000,0x0000, 0xFBC0,0x9AF3,0x0000,0x0000, /* 1AF2 */
0xFBC0,0x9AF4,0x0000,0x0000, 0xFBC0,0x9AF5,0x0000,0x0000, /* 1AF4 */
0xFBC0,0x9AF6,0x0000,0x0000, 0xFBC0,0x9AF7,0x0000,0x0000, /* 1AF6 */
0xFBC0,0x9AF8,0x0000,0x0000, 0xFBC0,0x9AF9,0x0000,0x0000, /* 1AF8 */
0xFBC0,0x9AFA,0x0000,0x0000, 0xFBC0,0x9AFB,0x0000,0x0000, /* 1AFA */
0xFBC0,0x9AFC,0x0000,0x0000, 0xFBC0,0x9AFD,0x0000,0x0000, /* 1AFC */
0xFBC0,0x9AFE,0x0000,0x0000, 0xFBC0,0x9AFF,0x0000,0x0000  /* 1AFE */
};

uint16 uca520_p01B[]= { /* 1B00 (3 weights per char) */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1B00 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x23A6,0x0000,0x0000, /* 1B03 */
0x23A7,0x0000,0x0000, 0x23A8,0x0000,0x0000, 0x23A9,0x0000,0x0000, /* 1B06 */
0x23AA,0x0000,0x0000, 0x23AB,0x0000,0x0000, 0x23AC,0x0000,0x0000, /* 1B09 */
0x23AD,0x0000,0x0000, 0x23AE,0x0000,0x0000, 0x23AF,0x0000,0x0000, /* 1B0C */
0x23B0,0x0000,0x0000, 0x23B1,0x0000,0x0000, 0x23B2,0x0000,0x0000, /* 1B0F */
0x23B3,0x0000,0x0000, 0x23B4,0x0000,0x0000, 0x23B7,0x0000,0x0000, /* 1B12 */
0x23B8,0x0000,0x0000, 0x23B9,0x0000,0x0000, 0x23BA,0x0000,0x0000, /* 1B15 */
0x23BB,0x0000,0x0000, 0x23BC,0x0000,0x0000, 0x23BD,0x0000,0x0000, /* 1B18 */
0x23BE,0x0000,0x0000, 0x23BF,0x0000,0x0000, 0x23C0,0x0000,0x0000, /* 1B1B */
0x23C1,0x0000,0x0000, 0x23C2,0x0000,0x0000, 0x23C3,0x0000,0x0000, /* 1B1E */
0x23C4,0x0000,0x0000, 0x23C5,0x0000,0x0000, 0x23C7,0x0000,0x0000, /* 1B21 */
0x23C8,0x0000,0x0000, 0x23C9,0x0000,0x0000, 0x23CA,0x0000,0x0000, /* 1B24 */
0x23CB,0x0000,0x0000, 0x23CD,0x0000,0x0000, 0x23CE,0x0000,0x0000, /* 1B27 */
0x23CF,0x0000,0x0000, 0x23D0,0x0000,0x0000, 0x23D1,0x0000,0x0000, /* 1B2A */
0x23D2,0x0000,0x0000, 0x23D3,0x0000,0x0000, 0x23D4,0x0000,0x0000, /* 1B2D */
0x23D6,0x0000,0x0000, 0x23D7,0x0000,0x0000, 0x23D8,0x0000,0x0000, /* 1B30 */
0x23DB,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x23DC,0x0000,0x0000, /* 1B33 */
0x23DD,0x0000,0x0000, 0x23DE,0x0000,0x0000, 0x23DF,0x0000,0x0000, /* 1B36 */
0x23E0,0x0000,0x0000, 0x23E1,0x0000,0x0000, 0x23E2,0x0000,0x0000, /* 1B39 */
0x23E3,0x0000,0x0000, 0x23E4,0x0000,0x0000, 0x23E5,0x0000,0x0000, /* 1B3C */
0x23E6,0x0000,0x0000, 0x23E7,0x0000,0x0000, 0x23E8,0x0000,0x0000, /* 1B3F */
0x23E9,0x0000,0x0000, 0x23EA,0x0000,0x0000, 0x23EB,0x0000,0x0000, /* 1B42 */
0x23B5,0x0000,0x0000, 0x23B6,0x0000,0x0000, 0x23C6,0x0000,0x0000, /* 1B45 */
0x23CC,0x0000,0x0000, 0x23D5,0x0000,0x0000, 0x23D9,0x0000,0x0000, /* 1B48 */
0x23DA,0x0000,0x0000, 0xFBC0,0x9B4C,0x0000, 0xFBC0,0x9B4D,0x0000, /* 1B4B */
0xFBC0,0x9B4E,0x0000, 0xFBC0,0x9B4F,0x0000, 0x1205,0x0000,0x0000, /* 1B4E */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 1B51 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 1B54 */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 1B57 */
0x02BC,0x0000,0x0000, 0x02BD,0x0000,0x0000, 0x028A,0x0000,0x0000, /* 1B5A */
0x0268,0x0000,0x0000, 0x02A7,0x0000,0x0000, 0x02A8,0x0000,0x0000, /* 1B5D */
0x0226,0x0000,0x0000, 0x04AE,0x0000,0x0000, 0x04AF,0x0000,0x0000, /* 1B60 */
0x04B0,0x0000,0x0000, 0x04B1,0x0000,0x0000, 0x04B2,0x0000,0x0000, /* 1B63 */
0x04B3,0x0000,0x0000, 0x04B4,0x0000,0x0000, 0x04B5,0x0000,0x0000, /* 1B66 */
0x04B6,0x0000,0x0000, 0x04B7,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1B69 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1B6C */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1B6F */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x04B8,0x0000,0x0000, /* 1B72 */
0x04B9,0x0000,0x0000, 0x04BA,0x0000,0x0000, 0x04BB,0x0000,0x0000, /* 1B75 */
0x04BC,0x0000,0x0000, 0x04BD,0x0000,0x0000, 0x04BE,0x0000,0x0000, /* 1B78 */
0x04BF,0x0000,0x0000, 0x04C0,0x0000,0x0000, 0xFBC0,0x9B7D,0x0000, /* 1B7B */
0xFBC0,0x9B7E,0x0000, 0xFBC0,0x9B7F,0x0000, 0x0000,0x0000,0x0000, /* 1B7E */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x1F1C,0x0000,0x0000, /* 1B81 */
0x1F1D,0x0000,0x0000, 0x1F1E,0x0000,0x0000, 0x1F1F,0x0000,0x0000, /* 1B84 */
0x1F20,0x0000,0x0000, 0x1F21,0x0000,0x0000, 0x1F22,0x0000,0x0000, /* 1B87 */
0x1F23,0x0000,0x0000, 0x1F25,0x0000,0x0000, 0x1F26,0x0000,0x0000, /* 1B8A */
0x1F27,0x0000,0x0000, 0x1F28,0x0000,0x0000, 0x1F29,0x0000,0x0000, /* 1B8D */
0x1F2A,0x0000,0x0000, 0x1F2B,0x0000,0x0000, 0x1F2C,0x0000,0x0000, /* 1B90 */
0x1F2D,0x0000,0x0000, 0x1F2E,0x0000,0x0000, 0x1F2F,0x0000,0x0000, /* 1B93 */
0x1F30,0x0000,0x0000, 0x1F31,0x0000,0x0000, 0x1F32,0x0000,0x0000, /* 1B96 */
0x1F33,0x0000,0x0000, 0x1F34,0x0000,0x0000, 0x1F36,0x0000,0x0000, /* 1B99 */
0x1F38,0x0000,0x0000, 0x1F3A,0x0000,0x0000, 0x1F3B,0x0000,0x0000, /* 1B9C */
0x1F3C,0x0000,0x0000, 0x1F3E,0x0000,0x0000, 0x1F35,0x0000,0x0000, /* 1B9F */
0x1F37,0x0000,0x0000, 0x1F39,0x0000,0x0000, 0x1F3F,0x0000,0x0000, /* 1BA2 */
0x1F40,0x0000,0x0000, 0x1F41,0x0000,0x0000, 0x1F42,0x0000,0x0000, /* 1BA5 */
0x1F43,0x0000,0x0000, 0x1F44,0x0000,0x0000, 0x1F45,0x0000,0x0000, /* 1BA8 */
0xFBC0,0x9BAB,0x0000, 0xFBC0,0x9BAC,0x0000, 0xFBC0,0x9BAD,0x0000, /* 1BAB */
0x1F24,0x0000,0x0000, 0x1F3D,0x0000,0x0000, 0x1205,0x0000,0x0000, /* 1BAE */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 1BB1 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 1BB4 */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 1BB7 */
0xFBC0,0x9BBA,0x0000, 0xFBC0,0x9BBB,0x0000, 0xFBC0,0x9BBC,0x0000, /* 1BBA */
0xFBC0,0x9BBD,0x0000, 0xFBC0,0x9BBE,0x0000, 0xFBC0,0x9BBF,0x0000, /* 1BBD */
0xFBC0,0x9BC0,0x0000, 0xFBC0,0x9BC1,0x0000, 0xFBC0,0x9BC2,0x0000, /* 1BC0 */
0xFBC0,0x9BC3,0x0000, 0xFBC0,0x9BC4,0x0000, 0xFBC0,0x9BC5,0x0000, /* 1BC3 */
0xFBC0,0x9BC6,0x0000, 0xFBC0,0x9BC7,0x0000, 0xFBC0,0x9BC8,0x0000, /* 1BC6 */
0xFBC0,0x9BC9,0x0000, 0xFBC0,0x9BCA,0x0000, 0xFBC0,0x9BCB,0x0000, /* 1BC9 */
0xFBC0,0x9BCC,0x0000, 0xFBC0,0x9BCD,0x0000, 0xFBC0,0x9BCE,0x0000, /* 1BCC */
0xFBC0,0x9BCF,0x0000, 0xFBC0,0x9BD0,0x0000, 0xFBC0,0x9BD1,0x0000, /* 1BCF */
0xFBC0,0x9BD2,0x0000, 0xFBC0,0x9BD3,0x0000, 0xFBC0,0x9BD4,0x0000, /* 1BD2 */
0xFBC0,0x9BD5,0x0000, 0xFBC0,0x9BD6,0x0000, 0xFBC0,0x9BD7,0x0000, /* 1BD5 */
0xFBC0,0x9BD8,0x0000, 0xFBC0,0x9BD9,0x0000, 0xFBC0,0x9BDA,0x0000, /* 1BD8 */
0xFBC0,0x9BDB,0x0000, 0xFBC0,0x9BDC,0x0000, 0xFBC0,0x9BDD,0x0000, /* 1BDB */
0xFBC0,0x9BDE,0x0000, 0xFBC0,0x9BDF,0x0000, 0xFBC0,0x9BE0,0x0000, /* 1BDE */
0xFBC0,0x9BE1,0x0000, 0xFBC0,0x9BE2,0x0000, 0xFBC0,0x9BE3,0x0000, /* 1BE1 */
0xFBC0,0x9BE4,0x0000, 0xFBC0,0x9BE5,0x0000, 0xFBC0,0x9BE6,0x0000, /* 1BE4 */
0xFBC0,0x9BE7,0x0000, 0xFBC0,0x9BE8,0x0000, 0xFBC0,0x9BE9,0x0000, /* 1BE7 */
0xFBC0,0x9BEA,0x0000, 0xFBC0,0x9BEB,0x0000, 0xFBC0,0x9BEC,0x0000, /* 1BEA */
0xFBC0,0x9BED,0x0000, 0xFBC0,0x9BEE,0x0000, 0xFBC0,0x9BEF,0x0000, /* 1BED */
0xFBC0,0x9BF0,0x0000, 0xFBC0,0x9BF1,0x0000, 0xFBC0,0x9BF2,0x0000, /* 1BF0 */
0xFBC0,0x9BF3,0x0000, 0xFBC0,0x9BF4,0x0000, 0xFBC0,0x9BF5,0x0000, /* 1BF3 */
0xFBC0,0x9BF6,0x0000, 0xFBC0,0x9BF7,0x0000, 0xFBC0,0x9BF8,0x0000, /* 1BF6 */
0xFBC0,0x9BF9,0x0000, 0xFBC0,0x9BFA,0x0000, 0xFBC0,0x9BFB,0x0000, /* 1BF9 */
0xFBC0,0x9BFC,0x0000, 0xFBC0,0x9BFD,0x0000, 0xFBC0,0x9BFE,0x0000, /* 1BFC */
0xFBC0,0x9BFF,0x0000  };

uint16 uca520_p01C[]= { /* 1C00 (3 weights per char) */
0x207D,0x0000,0x0000, 0x207E,0x0000,0x0000, 0x207F,0x0000,0x0000, /* 1C00 */
0x2080,0x0000,0x0000, 0x2081,0x0000,0x0000, 0x2082,0x0000,0x0000, /* 1C03 */
0x2083,0x0000,0x0000, 0x2084,0x0000,0x0000, 0x2085,0x0000,0x0000, /* 1C06 */
0x2086,0x0000,0x0000, 0x208A,0x0000,0x0000, 0x208B,0x0000,0x0000, /* 1C09 */
0x208C,0x0000,0x0000, 0x208D,0x0000,0x0000, 0x208E,0x0000,0x0000, /* 1C0C */
0x208F,0x0000,0x0000, 0x2090,0x0000,0x0000, 0x2091,0x0000,0x0000, /* 1C0F */
0x2092,0x0000,0x0000, 0x2093,0x0000,0x0000, 0x2094,0x0000,0x0000, /* 1C12 */
0x2095,0x0000,0x0000, 0x2096,0x0000,0x0000, 0x2097,0x0000,0x0000, /* 1C15 */
0x2098,0x0000,0x0000, 0x2099,0x0000,0x0000, 0x209A,0x0000,0x0000, /* 1C18 */
0x209C,0x0000,0x0000, 0x209E,0x0000,0x0000, 0x209F,0x0000,0x0000, /* 1C1B */
0x20A0,0x0000,0x0000, 0x20A1,0x0000,0x0000, 0x20A2,0x0000,0x0000, /* 1C1E */
0x20A3,0x0000,0x0000, 0x20A4,0x0000,0x0000, 0x20A5,0x0000,0x0000, /* 1C21 */
0x209B,0x0000,0x0000, 0x209D,0x0000,0x0000, 0x20A7,0x0000,0x0000, /* 1C24 */
0x20A8,0x0000,0x0000, 0x20A9,0x0000,0x0000, 0x20AA,0x0000,0x0000, /* 1C27 */
0x20AB,0x0000,0x0000, 0x20AC,0x0000,0x0000, 0x20AD,0x0000,0x0000, /* 1C2A */
0x20AE,0x0000,0x0000, 0x20AF,0x0000,0x0000, 0x20B0,0x0000,0x0000, /* 1C2D */
0x20B1,0x0000,0x0000, 0x20B2,0x0000,0x0000, 0x20B3,0x0000,0x0000, /* 1C30 */
0x20B4,0x0000,0x0000, 0x20B5,0x0000,0x0000, 0x20B6,0x0000,0x0000, /* 1C33 */
0x20A6,0x0000,0x0000, 0x0000,0x0000,0x0000, 0xFBC0,0x9C38,0x0000, /* 1C36 */
0xFBC0,0x9C39,0x0000, 0xFBC0,0x9C3A,0x0000, 0x0298,0x0000,0x0000, /* 1C39 */
0x0299,0x0000,0x0000, 0x03BE,0x0000,0x0000, 0x03BF,0x0000,0x0000, /* 1C3C */
0x03C0,0x0000,0x0000, 0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, /* 1C3F */
0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, /* 1C42 */
0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, /* 1C45 */
0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, 0xFBC0,0x9C4A,0x0000, /* 1C48 */
0xFBC0,0x9C4B,0x0000, 0xFBC0,0x9C4C,0x0000, 0x2087,0x0000,0x0000, /* 1C4B */
0x2088,0x0000,0x0000, 0x2089,0x0000,0x0000, 0x1205,0x0000,0x0000, /* 1C4E */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 1C51 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 1C54 */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 1C57 */
0x24AA,0x0000,0x0000, 0x24AB,0x0000,0x0000, 0x24AC,0x0000,0x0000, /* 1C5A */
0x24AD,0x0000,0x0000, 0x24AE,0x0000,0x0000, 0x24AF,0x0000,0x0000, /* 1C5D */
0x24B0,0x0000,0x0000, 0x24B1,0x0000,0x0000, 0x24B2,0x0000,0x0000, /* 1C60 */
0x24B3,0x0000,0x0000, 0x24B4,0x0000,0x0000, 0x24B5,0x0000,0x0000, /* 1C63 */
0x24B6,0x0000,0x0000, 0x24B7,0x0000,0x0000, 0x24B8,0x0000,0x0000, /* 1C66 */
0x24B9,0x0000,0x0000, 0x24BA,0x0000,0x0000, 0x24BB,0x0000,0x0000, /* 1C69 */
0x24BC,0x0000,0x0000, 0x24BD,0x0000,0x0000, 0x24BE,0x0000,0x0000, /* 1C6C */
0x24BF,0x0000,0x0000, 0x24C0,0x0000,0x0000, 0x24C1,0x0000,0x0000, /* 1C6F */
0x24C2,0x0000,0x0000, 0x24C3,0x0000,0x0000, 0x24C4,0x0000,0x0000, /* 1C72 */
0x24C5,0x0000,0x0000, 0x24C6,0x0000,0x0000, 0x24C7,0x0000,0x0000, /* 1C75 */
0x24C8,0x0000,0x0000, 0x24C9,0x0000,0x0000, 0x24CA,0x0000,0x0000, /* 1C78 */
0x24CB,0x0000,0x0000, 0x24CC,0x0000,0x0000, 0x24CD,0x0000,0x0000, /* 1C7B */
0x02B3,0x0000,0x0000, 0x02B4,0x0000,0x0000, 0xFBC0,0x9C80,0x0000, /* 1C7E */
0xFBC0,0x9C81,0x0000, 0xFBC0,0x9C82,0x0000, 0xFBC0,0x9C83,0x0000, /* 1C81 */
0xFBC0,0x9C84,0x0000, 0xFBC0,0x9C85,0x0000, 0xFBC0,0x9C86,0x0000, /* 1C84 */
0xFBC0,0x9C87,0x0000, 0xFBC0,0x9C88,0x0000, 0xFBC0,0x9C89,0x0000, /* 1C87 */
0xFBC0,0x9C8A,0x0000, 0xFBC0,0x9C8B,0x0000, 0xFBC0,0x9C8C,0x0000, /* 1C8A */
0xFBC0,0x9C8D,0x0000, 0xFBC0,0x9C8E,0x0000, 0xFBC0,0x9C8F,0x0000, /* 1C8D */
0xFBC0,0x9C90,0x0000, 0xFBC0,0x9C91,0x0000, 0xFBC0,0x9C92,0x0000, /* 1C90 */
0xFBC0,0x9C93,0x0000, 0xFBC0,0x9C94,0x0000, 0xFBC0,0x9C95,0x0000, /* 1C93 */
0xFBC0,0x9C96,0x0000, 0xFBC0,0x9C97,0x0000, 0xFBC0,0x9C98,0x0000, /* 1C96 */
0xFBC0,0x9C99,0x0000, 0xFBC0,0x9C9A,0x0000, 0xFBC0,0x9C9B,0x0000, /* 1C99 */
0xFBC0,0x9C9C,0x0000, 0xFBC0,0x9C9D,0x0000, 0xFBC0,0x9C9E,0x0000, /* 1C9C */
0xFBC0,0x9C9F,0x0000, 0xFBC0,0x9CA0,0x0000, 0xFBC0,0x9CA1,0x0000, /* 1C9F */
0xFBC0,0x9CA2,0x0000, 0xFBC0,0x9CA3,0x0000, 0xFBC0,0x9CA4,0x0000, /* 1CA2 */
0xFBC0,0x9CA5,0x0000, 0xFBC0,0x9CA6,0x0000, 0xFBC0,0x9CA7,0x0000, /* 1CA5 */
0xFBC0,0x9CA8,0x0000, 0xFBC0,0x9CA9,0x0000, 0xFBC0,0x9CAA,0x0000, /* 1CA8 */
0xFBC0,0x9CAB,0x0000, 0xFBC0,0x9CAC,0x0000, 0xFBC0,0x9CAD,0x0000, /* 1CAB */
0xFBC0,0x9CAE,0x0000, 0xFBC0,0x9CAF,0x0000, 0xFBC0,0x9CB0,0x0000, /* 1CAE */
0xFBC0,0x9CB1,0x0000, 0xFBC0,0x9CB2,0x0000, 0xFBC0,0x9CB3,0x0000, /* 1CB1 */
0xFBC0,0x9CB4,0x0000, 0xFBC0,0x9CB5,0x0000, 0xFBC0,0x9CB6,0x0000, /* 1CB4 */
0xFBC0,0x9CB7,0x0000, 0xFBC0,0x9CB8,0x0000, 0xFBC0,0x9CB9,0x0000, /* 1CB7 */
0xFBC0,0x9CBA,0x0000, 0xFBC0,0x9CBB,0x0000, 0xFBC0,0x9CBC,0x0000, /* 1CBA */
0xFBC0,0x9CBD,0x0000, 0xFBC0,0x9CBE,0x0000, 0xFBC0,0x9CBF,0x0000, /* 1CBD */
0xFBC0,0x9CC0,0x0000, 0xFBC0,0x9CC1,0x0000, 0xFBC0,0x9CC2,0x0000, /* 1CC0 */
0xFBC0,0x9CC3,0x0000, 0xFBC0,0x9CC4,0x0000, 0xFBC0,0x9CC5,0x0000, /* 1CC3 */
0xFBC0,0x9CC6,0x0000, 0xFBC0,0x9CC7,0x0000, 0xFBC0,0x9CC8,0x0000, /* 1CC6 */
0xFBC0,0x9CC9,0x0000, 0xFBC0,0x9CCA,0x0000, 0xFBC0,0x9CCB,0x0000, /* 1CC9 */
0xFBC0,0x9CCC,0x0000, 0xFBC0,0x9CCD,0x0000, 0xFBC0,0x9CCE,0x0000, /* 1CCC */
0xFBC0,0x9CCF,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1CCF */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1CD2 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1CD5 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1CD8 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1CDB */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1CDE */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1CE1 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1CE4 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x1BE7,0x0000,0x0000, /* 1CE7 */
0x1BE7,0x0000,0x0000, 0x1BE7,0x0000,0x0000, 0x1BE7,0x0000,0x0000, /* 1CEA */
0x0000,0x0000,0x0000, 0x1BE7,0x0000,0x0000, 0x1BE7,0x0000,0x0000, /* 1CED */
0x1BE7,0x0000,0x0000, 0x1BE7,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1CF0 */
0xFBC0,0x9CF3,0x0000, 0xFBC0,0x9CF4,0x0000, 0xFBC0,0x9CF5,0x0000, /* 1CF3 */
0xFBC0,0x9CF6,0x0000, 0xFBC0,0x9CF7,0x0000, 0xFBC0,0x9CF8,0x0000, /* 1CF6 */
0xFBC0,0x9CF9,0x0000, 0xFBC0,0x9CFA,0x0000, 0xFBC0,0x9CFB,0x0000, /* 1CF9 */
0xFBC0,0x9CFC,0x0000, 0xFBC0,0x9CFD,0x0000, 0xFBC0,0x9CFE,0x0000, /* 1CFC */
0xFBC0,0x9CFF,0x0000  };

uint16 uca520_p01D[]= { /* 1D00 (3 weights per char) */
0x1213,0x0000,0x0000, 0x1216,0x0000,0x0000, 0x1217,0x0000,0x0000, /* 1D00 */
0x1232,0x0000,0x0000, 0x1241,0x0000,0x0000, 0x1254,0x0000,0x0000, /* 1D03 */
0x1255,0x0000,0x0000, 0x126F,0x0000,0x0000, 0x1292,0x0000,0x0000, /* 1D06 */
0x12F9,0x0000,0x0000, 0x130D,0x0000,0x0000, 0x1322,0x0000,0x0000, /* 1D09 */
0x1339,0x0000,0x0000, 0x1363,0x0000,0x0000, 0x1376,0x0000,0x0000, /* 1D0C */
0x1392,0x0000,0x0000, 0x139E,0x0000,0x0000, 0x1393,0x0000,0x0000, /* 1D0F */
0x139F,0x0000,0x0000, 0x1399,0x0000,0x0000, 0x1398,0x0000,0x0000, /* 1D12 */
0x13B2,0x0000,0x0000, 0x13A2,0x0000,0x0000, 0x13A3,0x0000,0x0000, /* 1D15 */
0x13B7,0x0000,0x0000, 0x13E3,0x0000,0x0000, 0x13ED,0x0000,0x0000, /* 1D18 */
0x1437,0x0000,0x0000, 0x1457,0x0000,0x0000, 0x1458,0x0000,0x0000, /* 1D1B */
0x1459,0x0000,0x0000, 0x1471,0x0000,0x0000, 0x147F,0x0000,0x0000, /* 1D1E */
0x1491,0x0000,0x0000, 0x14B1,0x0000,0x0000, 0x14CE,0x0000,0x0000, /* 1D21 */
0x1516,0x0000,0x0000, 0x1517,0x0000,0x0000, 0x1548,0x0000,0x0000, /* 1D24 */
0x1556,0x0000,0x0000, 0x155C,0x0000,0x0000, 0x1561,0x0000,0x0000, /* 1D27 */
0x156C,0x0000,0x0000, 0x1661,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 1D2A */
0x120F,0x126B,0x0000, 0x1225,0x0000,0x0000, 0x1231,0x0000,0x0000, /* 1D2D */
0x1250,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x1276,0x0000,0x0000, /* 1D30 */
0x12B0,0x0000,0x0000, 0x12D3,0x0000,0x0000, 0x12EC,0x0000,0x0000, /* 1D33 */
0x1305,0x0000,0x0000, 0x131E,0x0000,0x0000, 0x1330,0x0000,0x0000, /* 1D36 */
0x135F,0x0000,0x0000, 0x136D,0x0000,0x0000, 0x1375,0x0000,0x0000, /* 1D39 */
0x138E,0x0000,0x0000, 0x13AE,0x0000,0x0000, 0x13B3,0x0000,0x0000, /* 1D3C */
0x13DA,0x0000,0x0000, 0x1433,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 1D3F */
0x148D,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x1218,0x0000,0x0000, /* 1D42 */
0x121C,0x0000,0x0000, 0x1217,0x0000,0x0000, 0x1225,0x0000,0x0000, /* 1D45 */
0x1250,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x127B,0x0000,0x0000, /* 1D48 */
0x1280,0x0000,0x0000, 0x1292,0x0000,0x0000, 0x12B0,0x0000,0x0000, /* 1D4B */
0x12F9,0x0000,0x0000, 0x131E,0x0000,0x0000, 0x135F,0x0000,0x0000, /* 1D4E */
0x138A,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x139A,0x0000,0x0000, /* 1D51 */
0x13A2,0x0000,0x0000, 0x13A3,0x0000,0x0000, 0x13B3,0x0000,0x0000, /* 1D54 */
0x1433,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1458,0x0000,0x0000, /* 1D57 */
0x146D,0x0000,0x0000, 0x147B,0x0000,0x0000, 0x1517,0x0000,0x0000, /* 1D5A */
0x1546,0x0000,0x0000, 0x1547,0x0000,0x0000, 0x1549,0x0000,0x0000, /* 1D5D */
0x1569,0x0000,0x0000, 0x156A,0x0000,0x0000, 0x12EC,0x0000,0x0000, /* 1D60 */
0x13DA,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x147B,0x0000,0x0000, /* 1D63 */
0x1546,0x0000,0x0000, 0x1547,0x0000,0x0000, 0x1560,0x0000,0x0000, /* 1D66 */
0x1569,0x0000,0x0000, 0x156A,0x0000,0x0000, 0x145A,0x0000,0x0000, /* 1D69 */
0x1233,0x0000,0x0000, 0x1256,0x0000,0x0000, 0x12A8,0x0000,0x0000, /* 1D6C */
0x1364,0x0000,0x0000, 0x1377,0x0000,0x0000, 0x13BA,0x0000,0x0000, /* 1D6F */
0x13E8,0x0000,0x0000, 0x1404,0x0000,0x0000, 0x1415,0x0000,0x0000, /* 1D72 */
0x143D,0x0000,0x0000, 0x14B6,0x0000,0x0000, 0x12C9,0x0000,0x0000, /* 1D75 */
0x1678,0x0000,0x0000, 0x12B0,0x0000,0x0000, 0x1433,0x12D3,0x0000, /* 1D78 */
0x12FE,0x0000,0x0000, 0x1304,0x0000,0x0000, 0x13B8,0x0000,0x0000, /* 1D7B */
0x145F,0x0000,0x0000, 0x147A,0x0000,0x0000, 0x1234,0x0000,0x0000, /* 1D7E */
0x1257,0x0000,0x0000, 0x12A9,0x0000,0x0000, 0x12C0,0x0000,0x0000, /* 1D81 */
0x1323,0x0000,0x0000, 0x1348,0x0000,0x0000, 0x1365,0x0000,0x0000, /* 1D84 */
0x1380,0x0000,0x0000, 0x13BB,0x0000,0x0000, 0x13F2,0x0000,0x0000, /* 1D87 */
0x1416,0x0000,0x0000, 0x1425,0x0000,0x0000, 0x1481,0x0000,0x0000, /* 1D8A */
0x149B,0x0000,0x0000, 0x14B7,0x0000,0x0000, 0x1215,0x0000,0x0000, /* 1D8D */
0x1220,0x0000,0x0000, 0x1260,0x0000,0x0000, 0x1274,0x0000,0x0000, /* 1D90 */
0x1284,0x0000,0x0000, 0x1291,0x0000,0x0000, 0x127F,0x0000,0x0000, /* 1D93 */
0x12FF,0x0000,0x0000, 0x13A0,0x0000,0x0000, 0x142E,0x0000,0x0000, /* 1D96 */
0x1460,0x0000,0x0000, 0x14D3,0x0000,0x0000, 0x1221,0x0000,0x0000, /* 1D99 */
0x123D,0x0000,0x0000, 0x124A,0x0000,0x0000, 0x1250,0x0000,0x0000, /* 1D9C */
0x128D,0x0000,0x0000, 0x12A3,0x0000,0x0000, 0x1316,0x0000,0x0000, /* 1D9F */
0x12B4,0x0000,0x0000, 0x1461,0x0000,0x0000, 0x12FA,0x0000,0x0000, /* 1DA2 */
0x1300,0x0000,0x0000, 0x12F4,0x0000,0x0000, 0x12FE,0x0000,0x0000, /* 1DA5 */
0x1312,0x0000,0x0000, 0x1349,0x0000,0x0000, 0x1348,0x0000,0x0000, /* 1DA8 */
0x1334,0x0000,0x0000, 0x1366,0x0000,0x0000, 0x1472,0x0000,0x0000, /* 1DAB */
0x1378,0x0000,0x0000, 0x1381,0x0000,0x0000, 0x1371,0x0000,0x0000, /* 1DAE */
0x13A5,0x0000,0x0000, 0x13C3,0x0000,0x0000, 0x1417,0x0000,0x0000, /* 1DB1 */
0x1421,0x0000,0x0000, 0x143E,0x0000,0x0000, 0x145B,0x0000,0x0000, /* 1DB4 */
0x1476,0x0000,0x0000, 0x1457,0x0000,0x0000, 0x1482,0x0000,0x0000, /* 1DB7 */
0x1489,0x0000,0x0000, 0x14AD,0x0000,0x0000, 0x14BC,0x0000,0x0000, /* 1DBA */
0x14C0,0x0000,0x0000, 0x14CA,0x0000,0x0000, 0x1551,0x0000,0x0000, /* 1DBD */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1DC0 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1DC3 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1DC6 */
0x0000,0x0000,0x0000, 0x13DA,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1DC9 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1DCC */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1DCF */
0x14ED,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x126B,0x0000, /* 1DD2 */
0x120F,0x138E,0x0000, 0x120F,0x147B,0x0000, 0x123D,0x0000,0x0000, /* 1DD5 */
0x1250,0x0000,0x0000, 0x1250,0x0000,0x0000, 0x12B0,0x0000,0x0000, /* 1DD8 */
0x12B8,0x0000,0x0000, 0x131E,0x0000,0x0000, 0x1330,0x0000,0x0000, /* 1DDB */
0x1334,0x0000,0x0000, 0x1363,0x0000,0x0000, 0x136D,0x0000,0x0000, /* 1DDE */
0x1371,0x0000,0x0000, 0x13DE,0x0000,0x0000, 0x13E2,0x0000,0x0000, /* 1DE1 */
0x1410,0x0000,0x0000, 0x1410,0x0000,0x0000, 0x14AD,0x0000,0x0000, /* 1DE4 */
0xFBC0,0x9DE7,0x0000, 0xFBC0,0x9DE8,0x0000, 0xFBC0,0x9DE9,0x0000, /* 1DE7 */
0xFBC0,0x9DEA,0x0000, 0xFBC0,0x9DEB,0x0000, 0xFBC0,0x9DEC,0x0000, /* 1DEA */
0xFBC0,0x9DED,0x0000, 0xFBC0,0x9DEE,0x0000, 0xFBC0,0x9DEF,0x0000, /* 1DED */
0xFBC0,0x9DF0,0x0000, 0xFBC0,0x9DF1,0x0000, 0xFBC0,0x9DF2,0x0000, /* 1DF0 */
0xFBC0,0x9DF3,0x0000, 0xFBC0,0x9DF4,0x0000, 0xFBC0,0x9DF5,0x0000, /* 1DF3 */
0xFBC0,0x9DF6,0x0000, 0xFBC0,0x9DF7,0x0000, 0xFBC0,0x9DF8,0x0000, /* 1DF6 */
0xFBC0,0x9DF9,0x0000, 0xFBC0,0x9DFA,0x0000, 0xFBC0,0x9DFB,0x0000, /* 1DF9 */
0xFBC0,0x9DFC,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 1DFC */
0x0000,0x0000,0x0000  };

uint16 uca520_p01E[]= { /* 1E00 (3 weights per char) */
0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x1225,0x0000,0x0000, /* 1E00 */
0x1225,0x0000,0x0000, 0x1225,0x0000,0x0000, 0x1225,0x0000,0x0000, /* 1E03 */
0x1225,0x0000,0x0000, 0x1225,0x0000,0x0000, 0x123D,0x0000,0x0000, /* 1E06 */
0x123D,0x0000,0x0000, 0x1250,0x0000,0x0000, 0x1250,0x0000,0x0000, /* 1E09 */
0x1250,0x0000,0x0000, 0x1250,0x0000,0x0000, 0x1250,0x0000,0x0000, /* 1E0C */
0x1250,0x0000,0x0000, 0x1250,0x0000,0x0000, 0x1250,0x0000,0x0000, /* 1E0F */
0x1250,0x0000,0x0000, 0x1250,0x0000,0x0000, 0x126B,0x0000,0x0000, /* 1E12 */
0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, /* 1E15 */
0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, /* 1E18 */
0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, /* 1E1B */
0x12A3,0x0000,0x0000, 0x12A3,0x0000,0x0000, 0x12B0,0x0000,0x0000, /* 1E1E */
0x12B0,0x0000,0x0000, 0x12D3,0x0000,0x0000, 0x12D3,0x0000,0x0000, /* 1E21 */
0x12D3,0x0000,0x0000, 0x12D3,0x0000,0x0000, 0x12D3,0x0000,0x0000, /* 1E24 */
0x12D3,0x0000,0x0000, 0x12D3,0x0000,0x0000, 0x12D3,0x0000,0x0000, /* 1E27 */
0x12D3,0x0000,0x0000, 0x12D3,0x0000,0x0000, 0x12EC,0x0000,0x0000, /* 1E2A */
0x12EC,0x0000,0x0000, 0x12EC,0x0000,0x0000, 0x12EC,0x0000,0x0000, /* 1E2D */
0x131E,0x0000,0x0000, 0x131E,0x0000,0x0000, 0x131E,0x0000,0x0000, /* 1E30 */
0x131E,0x0000,0x0000, 0x131E,0x0000,0x0000, 0x131E,0x0000,0x0000, /* 1E33 */
0x1330,0x0000,0x0000, 0x1330,0x0000,0x0000, 0x1330,0x0000,0x0000, /* 1E36 */
0x1330,0x0000,0x0000, 0x1330,0x0000,0x0000, 0x1330,0x0000,0x0000, /* 1E39 */
0x1330,0x0000,0x0000, 0x1330,0x0000,0x0000, 0x135F,0x0000,0x0000, /* 1E3C */
0x135F,0x0000,0x0000, 0x135F,0x0000,0x0000, 0x135F,0x0000,0x0000, /* 1E3F */
0x135F,0x0000,0x0000, 0x135F,0x0000,0x0000, 0x136D,0x0000,0x0000, /* 1E42 */
0x136D,0x0000,0x0000, 0x136D,0x0000,0x0000, 0x136D,0x0000,0x0000, /* 1E45 */
0x136D,0x0000,0x0000, 0x136D,0x0000,0x0000, 0x136D,0x0000,0x0000, /* 1E48 */
0x136D,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 1E4B */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 1E4E */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 1E51 */
0x13B3,0x0000,0x0000, 0x13B3,0x0000,0x0000, 0x13B3,0x0000,0x0000, /* 1E54 */
0x13B3,0x0000,0x0000, 0x13DA,0x0000,0x0000, 0x13DA,0x0000,0x0000, /* 1E57 */
0x13DA,0x0000,0x0000, 0x13DA,0x0000,0x0000, 0x13DA,0x0000,0x0000, /* 1E5A */
0x13DA,0x0000,0x0000, 0x13DA,0x0000,0x0000, 0x13DA,0x0000,0x0000, /* 1E5D */
0x1410,0x0000,0x0000, 0x1410,0x0000,0x0000, 0x1410,0x0000,0x0000, /* 1E60 */
0x1410,0x0000,0x0000, 0x1410,0x0000,0x0000, 0x1410,0x0000,0x0000, /* 1E63 */
0x1410,0x0000,0x0000, 0x1410,0x0000,0x0000, 0x1410,0x0000,0x0000, /* 1E66 */
0x1410,0x0000,0x0000, 0x1433,0x0000,0x0000, 0x1433,0x0000,0x0000, /* 1E69 */
0x1433,0x0000,0x0000, 0x1433,0x0000,0x0000, 0x1433,0x0000,0x0000, /* 1E6C */
0x1433,0x0000,0x0000, 0x1433,0x0000,0x0000, 0x1433,0x0000,0x0000, /* 1E6F */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 1E72 */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 1E75 */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 1E78 */
0x1453,0x0000,0x0000, 0x147B,0x0000,0x0000, 0x147B,0x0000,0x0000, /* 1E7B */
0x147B,0x0000,0x0000, 0x147B,0x0000,0x0000, 0x148D,0x0000,0x0000, /* 1E7E */
0x148D,0x0000,0x0000, 0x148D,0x0000,0x0000, 0x148D,0x0000,0x0000, /* 1E81 */
0x148D,0x0000,0x0000, 0x148D,0x0000,0x0000, 0x148D,0x0000,0x0000, /* 1E84 */
0x148D,0x0000,0x0000, 0x148D,0x0000,0x0000, 0x148D,0x0000,0x0000, /* 1E87 */
0x1497,0x0000,0x0000, 0x1497,0x0000,0x0000, 0x1497,0x0000,0x0000, /* 1E8A */
0x1497,0x0000,0x0000, 0x149C,0x0000,0x0000, 0x149C,0x0000,0x0000, /* 1E8D */
0x14AD,0x0000,0x0000, 0x14AD,0x0000,0x0000, 0x14AD,0x0000,0x0000, /* 1E90 */
0x14AD,0x0000,0x0000, 0x14AD,0x0000,0x0000, 0x14AD,0x0000,0x0000, /* 1E93 */
0x12D3,0x0000,0x0000, 0x1433,0x0000,0x0000, 0x148D,0x0000,0x0000, /* 1E96 */
0x149C,0x0000,0x0000, 0x120F,0x150D,0x0000, 0x1410,0x0000,0x0000, /* 1E99 */
0x141F,0x0000,0x0000, 0x1420,0x0000,0x0000, 0x1410,0x1410,0x0000, /* 1E9C */
0x126A,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 1E9F */
0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 1EA2 */
0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 1EA5 */
0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 1EA8 */
0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 1EAB */
0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 1EAE */
0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 1EB1 */
0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, 0x120F,0x0000,0x0000, /* 1EB4 */
0x120F,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, /* 1EB7 */
0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, /* 1EBA */
0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, /* 1EBD */
0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, /* 1EC0 */
0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, /* 1EC3 */
0x126B,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x12EC,0x0000,0x0000, /* 1EC6 */
0x12EC,0x0000,0x0000, 0x12EC,0x0000,0x0000, 0x12EC,0x0000,0x0000, /* 1EC9 */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 1ECC */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 1ECF */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 1ED2 */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 1ED5 */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 1ED8 */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 1EDB */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 1EDE */
0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x138E,0x0000,0x0000, /* 1EE1 */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 1EE4 */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 1EE7 */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 1EEA */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, /* 1EED */
0x1453,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x149C,0x0000,0x0000, /* 1EF0 */
0x149C,0x0000,0x0000, 0x149C,0x0000,0x0000, 0x149C,0x0000,0x0000, /* 1EF3 */
0x149C,0x0000,0x0000, 0x149C,0x0000,0x0000, 0x149C,0x0000,0x0000, /* 1EF6 */
0x149C,0x0000,0x0000, 0x1330,0x1330,0x0000, 0x1330,0x1330,0x0000, /* 1EF9 */
0x1488,0x0000,0x0000, 0x1488,0x0000,0x0000, 0x14AC,0x0000,0x0000, /* 1EFC */
0x14AC,0x0000,0x0000  };

uint16 uca520_p01F[]= { /* 1F00 (3 weights per char) */
0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1F00 */
0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1F03 */
0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1F06 */
0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1F09 */
0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1F0C */
0x1545,0x0000,0x0000, 0x154A,0x0000,0x0000, 0x154A,0x0000,0x0000, /* 1F0F */
0x154A,0x0000,0x0000, 0x154A,0x0000,0x0000, 0x154A,0x0000,0x0000, /* 1F12 */
0x154A,0x0000,0x0000, 0xFBC0,0x9F16,0x0000, 0xFBC0,0x9F17,0x0000, /* 1F15 */
0x154A,0x0000,0x0000, 0x154A,0x0000,0x0000, 0x154A,0x0000,0x0000, /* 1F18 */
0x154A,0x0000,0x0000, 0x154A,0x0000,0x0000, 0x154A,0x0000,0x0000, /* 1F1B */
0xFBC0,0x9F1E,0x0000, 0xFBC0,0x9F1F,0x0000, 0x1550,0x0000,0x0000, /* 1F1E */
0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, /* 1F21 */
0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, /* 1F24 */
0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, /* 1F27 */
0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, /* 1F2A */
0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, /* 1F2D */
0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, /* 1F30 */
0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, /* 1F33 */
0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, /* 1F36 */
0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, /* 1F39 */
0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, /* 1F3C */
0x1552,0x0000,0x0000, 0x155A,0x0000,0x0000, 0x155A,0x0000,0x0000, /* 1F3F */
0x155A,0x0000,0x0000, 0x155A,0x0000,0x0000, 0x155A,0x0000,0x0000, /* 1F42 */
0x155A,0x0000,0x0000, 0xFBC0,0x9F46,0x0000, 0xFBC0,0x9F47,0x0000, /* 1F45 */
0x155A,0x0000,0x0000, 0x155A,0x0000,0x0000, 0x155A,0x0000,0x0000, /* 1F48 */
0x155A,0x0000,0x0000, 0x155A,0x0000,0x0000, 0x155A,0x0000,0x0000, /* 1F4B */
0xFBC0,0x9F4E,0x0000, 0xFBC0,0x9F4F,0x0000, 0x1568,0x0000,0x0000, /* 1F4E */
0x1568,0x0000,0x0000, 0x1568,0x0000,0x0000, 0x1568,0x0000,0x0000, /* 1F51 */
0x1568,0x0000,0x0000, 0x1568,0x0000,0x0000, 0x1568,0x0000,0x0000, /* 1F54 */
0x1568,0x0000,0x0000, 0xFBC0,0x9F58,0x0000, 0x1568,0x0000,0x0000, /* 1F57 */
0xFBC0,0x9F5A,0x0000, 0x1568,0x0000,0x0000, 0xFBC0,0x9F5C,0x0000, /* 1F5A */
0x1568,0x0000,0x0000, 0xFBC0,0x9F5E,0x0000, 0x1568,0x0000,0x0000, /* 1F5D */
0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, /* 1F60 */
0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, /* 1F63 */
0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, /* 1F66 */
0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, /* 1F69 */
0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, /* 1F6C */
0x156D,0x0000,0x0000, 0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1F6F */
0x154A,0x0000,0x0000, 0x154A,0x0000,0x0000, 0x1550,0x0000,0x0000, /* 1F72 */
0x1550,0x0000,0x0000, 0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, /* 1F75 */
0x155A,0x0000,0x0000, 0x155A,0x0000,0x0000, 0x1568,0x0000,0x0000, /* 1F78 */
0x1568,0x0000,0x0000, 0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, /* 1F7B */
0xFBC0,0x9F7E,0x0000, 0xFBC0,0x9F7F,0x0000, 0x1545,0x0000,0x0000, /* 1F7E */
0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1F81 */
0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1F84 */
0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1F87 */
0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1F8A */
0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1F8D */
0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, /* 1F90 */
0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, /* 1F93 */
0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, /* 1F96 */
0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, /* 1F99 */
0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, /* 1F9C */
0x1550,0x0000,0x0000, 0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, /* 1F9F */
0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, /* 1FA2 */
0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, /* 1FA5 */
0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, /* 1FA8 */
0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, /* 1FAB */
0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1FAE */
0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1FB1 */
0x1545,0x0000,0x0000, 0xFBC0,0x9FB5,0x0000, 0x1545,0x0000,0x0000, /* 1FB4 */
0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1FB7 */
0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, 0x1545,0x0000,0x0000, /* 1FBA */
0x0219,0x0000,0x0000, 0x1552,0x0000,0x0000, 0x0219,0x0000,0x0000, /* 1FBD */
0x021F,0x0000,0x0000, 0x0216,0x0000,0x0000, 0x1550,0x0000,0x0000, /* 1FC0 */
0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, 0xFBC0,0x9FC5,0x0000, /* 1FC3 */
0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, 0x154A,0x0000,0x0000, /* 1FC6 */
0x154A,0x0000,0x0000, 0x1550,0x0000,0x0000, 0x1550,0x0000,0x0000, /* 1FC9 */
0x1550,0x0000,0x0000, 0x0219,0x0000,0x0000, 0x0219,0x0000,0x0000, /* 1FCC */
0x0219,0x0000,0x0000, 0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, /* 1FCF */
0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, 0xFBC0,0x9FD4,0x0000, /* 1FD2 */
0xFBC0,0x9FD5,0x0000, 0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, /* 1FD5 */
0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, 0x1552,0x0000,0x0000, /* 1FD8 */
0x1552,0x0000,0x0000, 0xFBC0,0x9FDC,0x0000, 0x021A,0x0000,0x0000, /* 1FDB */
0x021A,0x0000,0x0000, 0x021A,0x0000,0x0000, 0x1568,0x0000,0x0000, /* 1FDE */
0x1568,0x0000,0x0000, 0x1568,0x0000,0x0000, 0x1568,0x0000,0x0000, /* 1FE1 */
0x1560,0x0000,0x0000, 0x1560,0x0000,0x0000, 0x1568,0x0000,0x0000, /* 1FE4 */
0x1568,0x0000,0x0000, 0x1568,0x0000,0x0000, 0x1568,0x0000,0x0000, /* 1FE7 */
0x1568,0x0000,0x0000, 0x1568,0x0000,0x0000, 0x1560,0x0000,0x0000, /* 1FEA */
0x0216,0x0000,0x0000, 0x0216,0x0000,0x0000, 0x020E,0x0000,0x0000, /* 1FED */
0xFBC0,0x9FF0,0x0000, 0xFBC0,0x9FF1,0x0000, 0x156D,0x0000,0x0000, /* 1FF0 */
0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, 0xFBC0,0x9FF5,0x0000, /* 1FF3 */
0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, 0x155A,0x0000,0x0000, /* 1FF6 */
0x155A,0x0000,0x0000, 0x156D,0x0000,0x0000, 0x156D,0x0000,0x0000, /* 1FF9 */
0x156D,0x0000,0x0000, 0x020F,0x0000,0x0000, 0x021A,0x0000,0x0000, /* 1FFC */
0xFBC0,0x9FFF,0x0000  };

uint16 uca520_p020[]= { /* 2000 (5 weights per char) */
0x020A,0x0000,0x0000,0x0000,0x0000, /* 2000 */
0x020A,0x0000,0x0000,0x0000,0x0000, /* 2001 */
0x020A,0x0000,0x0000,0x0000,0x0000, /* 2002 */
0x020A,0x0000,0x0000,0x0000,0x0000, /* 2003 */
0x020A,0x0000,0x0000,0x0000,0x0000, /* 2004 */
0x020A,0x0000,0x0000,0x0000,0x0000, /* 2005 */
0x020A,0x0000,0x0000,0x0000,0x0000, /* 2006 */
0x020A,0x0000,0x0000,0x0000,0x0000, /* 2007 */
0x020A,0x0000,0x0000,0x0000,0x0000, /* 2008 */
0x020A,0x0000,0x0000,0x0000,0x0000, /* 2009 */
0x020A,0x0000,0x0000,0x0000,0x0000, /* 200A */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 200B */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 200C */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 200D */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 200E */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 200F */
0x0229,0x0000,0x0000,0x0000,0x0000, /* 2010 */
0x0229,0x0000,0x0000,0x0000,0x0000, /* 2011 */
0x022A,0x0000,0x0000,0x0000,0x0000, /* 2012 */
0x022B,0x0000,0x0000,0x0000,0x0000, /* 2013 */
0x022C,0x0000,0x0000,0x0000,0x0000, /* 2014 */
0x022D,0x0000,0x0000,0x0000,0x0000, /* 2015 */
0x055A,0x0000,0x0000,0x0000,0x0000, /* 2016 */
0x021E,0x0000,0x0000,0x0000,0x0000, /* 2017 */
0x02EF,0x0000,0x0000,0x0000,0x0000, /* 2018 */
0x02F0,0x0000,0x0000,0x0000,0x0000, /* 2019 */
0x02F1,0x0000,0x0000,0x0000,0x0000, /* 201A */
0x02F2,0x0000,0x0000,0x0000,0x0000, /* 201B */
0x02F6,0x0000,0x0000,0x0000,0x0000, /* 201C */
0x02F7,0x0000,0x0000,0x0000,0x0000, /* 201D */
0x02F8,0x0000,0x0000,0x0000,0x0000, /* 201E */
0x02F9,0x0000,0x0000,0x0000,0x0000, /* 201F */
0x036A,0x0000,0x0000,0x0000,0x0000, /* 2020 */
0x036B,0x0000,0x0000,0x0000,0x0000, /* 2021 */
0x036C,0x0000,0x0000,0x0000,0x0000, /* 2022 */
0x036D,0x0000,0x0000,0x0000,0x0000, /* 2023 */
0x0281,0x0000,0x0000,0x0000,0x0000, /* 2024 */
0x0281,0x0281,0x0000,0x0000,0x0000, /* 2025 */
0x0281,0x0281,0x0281,0x0000,0x0000, /* 2026 */
0x036E,0x0000,0x0000,0x0000,0x0000, /* 2027 */
0x0208,0x0000,0x0000,0x0000,0x0000, /* 2028 */
0x0209,0x0000,0x0000,0x0000,0x0000, /* 2029 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 202A */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 202B */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 202C */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 202D */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 202E */
0x020A,0x0000,0x0000,0x0000,0x0000, /* 202F */
0x0365,0x0000,0x0000,0x0000,0x0000, /* 2030 */
0x0367,0x0000,0x0000,0x0000,0x0000, /* 2031 */
0x0372,0x0000,0x0000,0x0000,0x0000, /* 2032 */
0x0372,0x0372,0x0000,0x0000,0x0000, /* 2033 */
0x0372,0x0372,0x0372,0x0000,0x0000, /* 2034 */
0x0373,0x0000,0x0000,0x0000,0x0000, /* 2035 */
0x0373,0x0373,0x0000,0x0000,0x0000, /* 2036 */
0x0373,0x0373,0x0373,0x0000,0x0000, /* 2037 */
0x0376,0x0000,0x0000,0x0000,0x0000, /* 2038 */
0x02F3,0x0000,0x0000,0x0000,0x0000, /* 2039 */
0x02F4,0x0000,0x0000,0x0000,0x0000, /* 203A */
0x0377,0x0000,0x0000,0x0000,0x0000, /* 203B */
0x026E,0x026E,0x0000,0x0000,0x0000, /* 203C */
0x027F,0x0000,0x0000,0x0000,0x0000, /* 203D */
0x0213,0x0000,0x0000,0x0000,0x0000, /* 203E */
0x0378,0x0000,0x0000,0x0000,0x0000, /* 203F */
0x037A,0x0000,0x0000,0x0000,0x0000, /* 2040 */
0x037C,0x0000,0x0000,0x0000,0x0000, /* 2041 */
0x037D,0x0000,0x0000,0x0000,0x0000, /* 2042 */
0x036F,0x0000,0x0000,0x0000,0x0000, /* 2043 */
0x035D,0x0000,0x0000,0x0000,0x0000, /* 2044 */
0x030B,0x0000,0x0000,0x0000,0x0000, /* 2045 */
0x030C,0x0000,0x0000,0x0000,0x0000, /* 2046 */
0x0273,0x0273,0x0000,0x0000,0x0000, /* 2047 */
0x0273,0x026E,0x0000,0x0000,0x0000, /* 2048 */
0x026E,0x0273,0x0000,0x0000,0x0000, /* 2049 */
0x0361,0x0000,0x0000,0x0000,0x0000, /* 204A */
0x0353,0x0000,0x0000,0x0000,0x0000, /* 204B */
0x0370,0x0000,0x0000,0x0000,0x0000, /* 204C */
0x0371,0x0000,0x0000,0x0000,0x0000, /* 204D */
0x0358,0x0000,0x0000,0x0000,0x0000, /* 204E */
0x0245,0x0000,0x0000,0x0000,0x0000, /* 204F */
0x037B,0x0000,0x0000,0x0000,0x0000, /* 2050 */
0x0359,0x0000,0x0000,0x0000,0x0000, /* 2051 */
0x0369,0x0000,0x0000,0x0000,0x0000, /* 2052 */
0x022E,0x0000,0x0000,0x0000,0x0000, /* 2053 */
0x0379,0x0000,0x0000,0x0000,0x0000, /* 2054 */
0x02D3,0x0000,0x0000,0x0000,0x0000, /* 2055 */
0x02D4,0x0000,0x0000,0x0000,0x0000, /* 2056 */
0x0372,0x0372,0x0372,0x0372,0x0000, /* 2057 */
0x02D5,0x0000,0x0000,0x0000,0x0000, /* 2058 */
0x02D6,0x0000,0x0000,0x0000,0x0000, /* 2059 */
0x02D7,0x0000,0x0000,0x0000,0x0000, /* 205A */
0x02D8,0x0000,0x0000,0x0000,0x0000, /* 205B */
0x02D9,0x0000,0x0000,0x0000,0x0000, /* 205C */
0x02DA,0x0000,0x0000,0x0000,0x0000, /* 205D */
0x02DB,0x0000,0x0000,0x0000,0x0000, /* 205E */
0x020A,0x0000,0x0000,0x0000,0x0000, /* 205F */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 2060 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 2061 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 2062 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 2063 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 2064 */
0xFBC0,0xA065,0x0000,0x0000,0x0000, /* 2065 */
0xFBC0,0xA066,0x0000,0x0000,0x0000, /* 2066 */
0xFBC0,0xA067,0x0000,0x0000,0x0000, /* 2067 */
0xFBC0,0xA068,0x0000,0x0000,0x0000, /* 2068 */
0xFBC0,0xA069,0x0000,0x0000,0x0000, /* 2069 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 206A */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 206B */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 206C */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 206D */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 206E */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 206F */
0x1205,0x0000,0x0000,0x0000,0x0000, /* 2070 */
0x12EC,0x0000,0x0000,0x0000,0x0000, /* 2071 */
0xFBC0,0xA072,0x0000,0x0000,0x0000, /* 2072 */
0xFBC0,0xA073,0x0000,0x0000,0x0000, /* 2073 */
0x1209,0x0000,0x0000,0x0000,0x0000, /* 2074 */
0x120A,0x0000,0x0000,0x0000,0x0000, /* 2075 */
0x120B,0x0000,0x0000,0x0000,0x0000, /* 2076 */
0x120C,0x0000,0x0000,0x0000,0x0000, /* 2077 */
0x120D,0x0000,0x0000,0x0000,0x0000, /* 2078 */
0x120E,0x0000,0x0000,0x0000,0x0000, /* 2079 */
0x0550,0x0000,0x0000,0x0000,0x0000, /* 207A */
0x055C,0x0000,0x0000,0x0000,0x0000, /* 207B */
0x0555,0x0000,0x0000,0x0000,0x0000, /* 207C */
0x02FF,0x0000,0x0000,0x0000,0x0000, /* 207D */
0x0300,0x0000,0x0000,0x0000,0x0000, /* 207E */
0x136D,0x0000,0x0000,0x0000,0x0000, /* 207F */
0x1205,0x0000,0x0000,0x0000,0x0000, /* 2080 */
0x1206,0x0000,0x0000,0x0000,0x0000, /* 2081 */
0x1207,0x0000,0x0000,0x0000,0x0000, /* 2082 */
0x1208,0x0000,0x0000,0x0000,0x0000, /* 2083 */
0x1209,0x0000,0x0000,0x0000,0x0000, /* 2084 */
0x120A,0x0000,0x0000,0x0000,0x0000, /* 2085 */
0x120B,0x0000,0x0000,0x0000,0x0000, /* 2086 */
0x120C,0x0000,0x0000,0x0000,0x0000, /* 2087 */
0x120D,0x0000,0x0000,0x0000,0x0000, /* 2088 */
0x120E,0x0000,0x0000,0x0000,0x0000, /* 2089 */
0x0550,0x0000,0x0000,0x0000,0x0000, /* 208A */
0x055C,0x0000,0x0000,0x0000,0x0000, /* 208B */
0x0555,0x0000,0x0000,0x0000,0x0000, /* 208C */
0x02FF,0x0000,0x0000,0x0000,0x0000, /* 208D */
0x0300,0x0000,0x0000,0x0000,0x0000, /* 208E */
0xFBC0,0xA08F,0x0000,0x0000,0x0000, /* 208F */
0x120F,0x0000,0x0000,0x0000,0x0000, /* 2090 */
0x126B,0x0000,0x0000,0x0000,0x0000, /* 2091 */
0x138E,0x0000,0x0000,0x0000,0x0000, /* 2092 */
0x1497,0x0000,0x0000,0x0000,0x0000, /* 2093 */
0x127B,0x0000,0x0000,0x0000,0x0000, /* 2094 */
0xFBC0,0xA095,0x0000,0x0000,0x0000, /* 2095 */
0xFBC0,0xA096,0x0000,0x0000,0x0000, /* 2096 */
0xFBC0,0xA097,0x0000,0x0000,0x0000, /* 2097 */
0xFBC0,0xA098,0x0000,0x0000,0x0000, /* 2098 */
0xFBC0,0xA099,0x0000,0x0000,0x0000, /* 2099 */
0xFBC0,0xA09A,0x0000,0x0000,0x0000, /* 209A */
0xFBC0,0xA09B,0x0000,0x0000,0x0000, /* 209B */
0xFBC0,0xA09C,0x0000,0x0000,0x0000, /* 209C */
0xFBC0,0xA09D,0x0000,0x0000,0x0000, /* 209D */
0xFBC0,0xA09E,0x0000,0x0000,0x0000, /* 209E */
0xFBC0,0xA09F,0x0000,0x0000,0x0000, /* 209F */
0x11ED,0x0000,0x0000,0x0000,0x0000, /* 20A0 */
0x11EE,0x0000,0x0000,0x0000,0x0000, /* 20A1 */
0x11EF,0x0000,0x0000,0x0000,0x0000, /* 20A2 */
0x11F0,0x0000,0x0000,0x0000,0x0000, /* 20A3 */
0x11F1,0x0000,0x0000,0x0000,0x0000, /* 20A4 */
0x11F2,0x0000,0x0000,0x0000,0x0000, /* 20A5 */
0x11F3,0x0000,0x0000,0x0000,0x0000, /* 20A6 */
0x11F4,0x0000,0x0000,0x0000,0x0000, /* 20A7 */
0x13DA,0x1410,0x0000,0x0000,0x0000, /* 20A8 */
0x11F5,0x0000,0x0000,0x0000,0x0000, /* 20A9 */
0x11F6,0x0000,0x0000,0x0000,0x0000, /* 20AA */
0x11F7,0x0000,0x0000,0x0000,0x0000, /* 20AB */
0x11F8,0x0000,0x0000,0x0000,0x0000, /* 20AC */
0x11F9,0x0000,0x0000,0x0000,0x0000, /* 20AD */
0x11FA,0x0000,0x0000,0x0000,0x0000, /* 20AE */
0x11FB,0x0000,0x0000,0x0000,0x0000, /* 20AF */
0x11FC,0x0000,0x0000,0x0000,0x0000, /* 20B0 */
0x11FD,0x0000,0x0000,0x0000,0x0000, /* 20B1 */
0x11FE,0x0000,0x0000,0x0000,0x0000, /* 20B2 */
0x11FF,0x0000,0x0000,0x0000,0x0000, /* 20B3 */
0x1200,0x0000,0x0000,0x0000,0x0000, /* 20B4 */
0x1201,0x0000,0x0000,0x0000,0x0000, /* 20B5 */
0x1202,0x0000,0x0000,0x0000,0x0000, /* 20B6 */
0x1203,0x0000,0x0000,0x0000,0x0000, /* 20B7 */
0x1204,0x0000,0x0000,0x0000,0x0000, /* 20B8 */
0xFBC0,0xA0B9,0x0000,0x0000,0x0000, /* 20B9 */
0xFBC0,0xA0BA,0x0000,0x0000,0x0000, /* 20BA */
0xFBC0,0xA0BB,0x0000,0x0000,0x0000, /* 20BB */
0xFBC0,0xA0BC,0x0000,0x0000,0x0000, /* 20BC */
0xFBC0,0xA0BD,0x0000,0x0000,0x0000, /* 20BD */
0xFBC0,0xA0BE,0x0000,0x0000,0x0000, /* 20BE */
0xFBC0,0xA0BF,0x0000,0x0000,0x0000, /* 20BF */
0xFBC0,0xA0C0,0x0000,0x0000,0x0000, /* 20C0 */
0xFBC0,0xA0C1,0x0000,0x0000,0x0000, /* 20C1 */
0xFBC0,0xA0C2,0x0000,0x0000,0x0000, /* 20C2 */
0xFBC0,0xA0C3,0x0000,0x0000,0x0000, /* 20C3 */
0xFBC0,0xA0C4,0x0000,0x0000,0x0000, /* 20C4 */
0xFBC0,0xA0C5,0x0000,0x0000,0x0000, /* 20C5 */
0xFBC0,0xA0C6,0x0000,0x0000,0x0000, /* 20C6 */
0xFBC0,0xA0C7,0x0000,0x0000,0x0000, /* 20C7 */
0xFBC0,0xA0C8,0x0000,0x0000,0x0000, /* 20C8 */
0xFBC0,0xA0C9,0x0000,0x0000,0x0000, /* 20C9 */
0xFBC0,0xA0CA,0x0000,0x0000,0x0000, /* 20CA */
0xFBC0,0xA0CB,0x0000,0x0000,0x0000, /* 20CB */
0xFBC0,0xA0CC,0x0000,0x0000,0x0000, /* 20CC */
0xFBC0,0xA0CD,0x0000,0x0000,0x0000, /* 20CD */
0xFBC0,0xA0CE,0x0000,0x0000,0x0000, /* 20CE */
0xFBC0,0xA0CF,0x0000,0x0000,0x0000, /* 20CF */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20D0 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20D1 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20D2 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20D3 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20D4 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20D5 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20D6 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20D7 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20D8 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20D9 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20DA */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20DB */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20DC */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20DD */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20DE */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20DF */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20E0 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20E1 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20E2 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20E3 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20E4 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20E5 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20E6 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20E7 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20E8 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20E9 */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20EA */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20EB */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20EC */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20ED */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20EE */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20EF */
0x0000,0x0000,0x0000,0x0000,0x0000, /* 20F0 */
0xFBC0,0xA0F1,0x0000,0x0000,0x0000, /* 20F1 */
0xFBC0,0xA0F2,0x0000,0x0000,0x0000, /* 20F2 */
0xFBC0,0xA0F3,0x0000,0x0000,0x0000, /* 20F3 */
0xFBC0,0xA0F4,0x0000,0x0000,0x0000, /* 20F4 */
0xFBC0,0xA0F5,0x0000,0x0000,0x0000, /* 20F5 */
0xFBC0,0xA0F6,0x0000,0x0000,0x0000, /* 20F6 */
0xFBC0,0xA0F7,0x0000,0x0000,0x0000, /* 20F7 */
0xFBC0,0xA0F8,0x0000,0x0000,0x0000, /* 20F8 */
0xFBC0,0xA0F9,0x0000,0x0000,0x0000, /* 20F9 */
0xFBC0,0xA0FA,0x0000,0x0000,0x0000, /* 20FA */
0xFBC0,0xA0FB,0x0000,0x0000,0x0000, /* 20FB */
0xFBC0,0xA0FC,0x0000,0x0000,0x0000, /* 20FC */
0xFBC0,0xA0FD,0x0000,0x0000,0x0000, /* 20FD */
0xFBC0,0xA0FE,0x0000,0x0000,0x0000, /* 20FE */
0xFBC0,0xA0FF,0x0000,0x0000,0x0000  /* 20FF */
};

uint16 uca520_p021[]= { /* 2100 (5 weights per char) */
0x120F,0x035C,0x123D,0x0000,0x0000, /* 2100 */
0x120F,0x035C,0x1410,0x0000,0x0000, /* 2101 */
0x123D,0x0000,0x0000,0x0000,0x0000, /* 2102 */
0x044B,0x123D,0x0000,0x0000,0x0000, /* 2103 */
0x04C1,0x0000,0x0000,0x0000,0x0000, /* 2104 */
0x123D,0x035C,0x138E,0x0000,0x0000, /* 2105 */
0x123D,0x035C,0x1453,0x0000,0x0000, /* 2106 */
0x1280,0x0000,0x0000,0x0000,0x0000, /* 2107 */
0x04C2,0x0000,0x0000,0x0000,0x0000, /* 2108 */
0x044B,0x12A3,0x0000,0x0000,0x0000, /* 2109 */
0x12B0,0x0000,0x0000,0x0000,0x0000, /* 210A */
0x12D3,0x0000,0x0000,0x0000,0x0000, /* 210B */
0x12D3,0x0000,0x0000,0x0000,0x0000, /* 210C */
0x12D3,0x0000,0x0000,0x0000,0x0000, /* 210D */
0x12D3,0x0000,0x0000,0x0000,0x0000, /* 210E */
0x12D3,0x0000,0x0000,0x0000,0x0000, /* 210F */
0x12EC,0x0000,0x0000,0x0000,0x0000, /* 2110 */
0x12EC,0x0000,0x0000,0x0000,0x0000, /* 2111 */
0x1330,0x0000,0x0000,0x0000,0x0000, /* 2112 */
0x1330,0x0000,0x0000,0x0000,0x0000, /* 2113 */
0x04C3,0x0000,0x0000,0x0000,0x0000, /* 2114 */
0x136D,0x0000,0x0000,0x0000,0x0000, /* 2115 */
0x136D,0x138E,0x0000,0x0000,0x0000, /* 2116 */
0x04C4,0x0000,0x0000,0x0000,0x0000, /* 2117 */
0x04C5,0x0000,0x0000,0x0000,0x0000, /* 2118 */
0x13B3,0x0000,0x0000,0x0000,0x0000, /* 2119 */
0x13C8,0x0000,0x0000,0x0000,0x0000, /* 211A */
0x13DA,0x0000,0x0000,0x0000,0x0000, /* 211B */
0x13DA,0x0000,0x0000,0x0000,0x0000, /* 211C */
0x13DA,0x0000,0x0000,0x0000,0x0000, /* 211D */
0x04C6,0x0000,0x0000,0x0000,0x0000, /* 211E */
0x04C7,0x0000,0x0000,0x0000,0x0000, /* 211F */
0x1410,0x135F,0x0000,0x0000,0x0000, /* 2120 */
0x1433,0x126B,0x1330,0x0000,0x0000, /* 2121 */
0x1433,0x135F,0x0000,0x0000,0x0000, /* 2122 */
0x04C8,0x0000,0x0000,0x0000,0x0000, /* 2123 */
0x14AD,0x0000,0x0000,0x0000,0x0000, /* 2124 */
0x04C9,0x0000,0x0000,0x0000,0x0000, /* 2125 */
0x156D,0x0000,0x0000,0x0000,0x0000, /* 2126 */
0x04CA,0x0000,0x0000,0x0000,0x0000, /* 2127 */
0x14AD,0x0000,0x0000,0x0000,0x0000, /* 2128 */
0x04CB,0x0000,0x0000,0x0000,0x0000, /* 2129 */
0x131E,0x0000,0x0000,0x0000,0x0000, /* 212A */
0x120F,0x0000,0x0000,0x0000,0x0000, /* 212B */
0x1225,0x0000,0x0000,0x0000,0x0000, /* 212C */
0x123D,0x0000,0x0000,0x0000,0x0000, /* 212D */
0x04CC,0x0000,0x0000,0x0000,0x0000, /* 212E */
0x126B,0x0000,0x0000,0x0000,0x0000, /* 212F */
0x126B,0x0000,0x0000,0x0000,0x0000, /* 2130 */
0x12A3,0x0000,0x0000,0x0000,0x0000, /* 2131 */
0x12AE,0x0000,0x0000,0x0000,0x0000, /* 2132 */
0x135F,0x0000,0x0000,0x0000,0x0000, /* 2133 */
0x138E,0x0000,0x0000,0x0000,0x0000, /* 2134 */
0x185C,0x0000,0x0000,0x0000,0x0000, /* 2135 */
0x185D,0x0000,0x0000,0x0000,0x0000, /* 2136 */
0x185E,0x0000,0x0000,0x0000,0x0000, /* 2137 */
0x185F,0x0000,0x0000,0x0000,0x0000, /* 2138 */
0x12EC,0x0000,0x0000,0x0000,0x0000, /* 2139 */
0x04CD,0x0000,0x0000,0x0000,0x0000, /* 213A */
0x12A3,0x120F,0x1497,0x0000,0x0000, /* 213B */
0x155B,0x0000,0x0000,0x0000,0x0000, /* 213C */
0x1547,0x0000,0x0000,0x0000,0x0000, /* 213D */
0x1547,0x0000,0x0000,0x0000,0x0000, /* 213E */
0x155B,0x0000,0x0000,0x0000,0x0000, /* 213F */
0x054F,0x0000,0x0000,0x0000,0x0000, /* 2140 */
0x04CE,0x0000,0x0000,0x0000,0x0000, /* 2141 */
0x04CF,0x0000,0x0000,0x0000,0x0000, /* 2142 */
0x04D0,0x0000,0x0000,0x0000,0x0000, /* 2143 */
0x04D1,0x0000,0x0000,0x0000,0x0000, /* 2144 */
0x1250,0x0000,0x0000,0x0000,0x0000, /* 2145 */
0x1250,0x0000,0x0000,0x0000,0x0000, /* 2146 */
0x126B,0x0000,0x0000,0x0000,0x0000, /* 2147 */
0x12EC,0x0000,0x0000,0x0000,0x0000, /* 2148 */
0x1305,0x0000,0x0000,0x0000,0x0000, /* 2149 */
0x04D2,0x0000,0x0000,0x0000,0x0000, /* 214A */
0x0360,0x0000,0x0000,0x0000,0x0000, /* 214B */
0x04D3,0x0000,0x0000,0x0000,0x0000, /* 214C */
0x04D4,0x0000,0x0000,0x0000,0x0000, /* 214D */
0x12AE,0x0000,0x0000,0x0000,0x0000, /* 214E */
0x04D5,0x0000,0x0000,0x0000,0x0000, /* 214F */
0x1206,0x035D,0x120C,0x0000,0x0000, /* 2150 */
0x1206,0x035D,0x120E,0x0000,0x0000, /* 2151 */
0x1206,0x035D,0x1206,0x1205,0x0000, /* 2152 */
0x1206,0x035D,0x1208,0x0000,0x0000, /* 2153 */
0x1207,0x035D,0x1208,0x0000,0x0000, /* 2154 */
0x1206,0x035D,0x120A,0x0000,0x0000, /* 2155 */
0x1207,0x035D,0x120A,0x0000,0x0000, /* 2156 */
0x1208,0x035D,0x120A,0x0000,0x0000, /* 2157 */
0x1209,0x035D,0x120A,0x0000,0x0000, /* 2158 */
0x1206,0x035D,0x120B,0x0000,0x0000, /* 2159 */
0x120A,0x035D,0x120B,0x0000,0x0000, /* 215A */
0x1206,0x035D,0x120D,0x0000,0x0000, /* 215B */
0x1208,0x035D,0x120D,0x0000,0x0000, /* 215C */
0x120A,0x035D,0x120D,0x0000,0x0000, /* 215D */
0x120C,0x035D,0x120D,0x0000,0x0000, /* 215E */
0x1206,0x035D,0x0000,0x0000,0x0000, /* 215F */
0x12EC,0x0000,0x0000,0x0000,0x0000, /* 2160 */
0x12EC,0x12EC,0x0000,0x0000,0x0000, /* 2161 */
0x12EC,0x12EC,0x12EC,0x0000,0x0000, /* 2162 */
0x12EC,0x147B,0x0000,0x0000,0x0000, /* 2163 */
0x147B,0x0000,0x0000,0x0000,0x0000, /* 2164 */
0x147B,0x12EC,0x0000,0x0000,0x0000, /* 2165 */
0x147B,0x12EC,0x12EC,0x0000,0x0000, /* 2166 */
0x147B,0x12EC,0x12EC,0x12EC,0x0000, /* 2167 */
0x12EC,0x1497,0x0000,0x0000,0x0000, /* 2168 */
0x1497,0x0000,0x0000,0x0000,0x0000, /* 2169 */
0x1497,0x12EC,0x0000,0x0000,0x0000, /* 216A */
0x1497,0x12EC,0x12EC,0x0000,0x0000, /* 216B */
0x1330,0x0000,0x0000,0x0000,0x0000, /* 216C */
0x123D,0x0000,0x0000,0x0000,0x0000, /* 216D */
0x1250,0x0000,0x0000,0x0000,0x0000, /* 216E */
0x135F,0x0000,0x0000,0x0000,0x0000, /* 216F */
0x12EC,0x0000,0x0000,0x0000,0x0000, /* 2170 */
0x12EC,0x12EC,0x0000,0x0000,0x0000, /* 2171 */
0x12EC,0x12EC,0x12EC,0x0000,0x0000, /* 2172 */
0x12EC,0x147B,0x0000,0x0000,0x0000, /* 2173 */
0x147B,0x0000,0x0000,0x0000,0x0000, /* 2174 */
0x147B,0x12EC,0x0000,0x0000,0x0000, /* 2175 */
0x147B,0x12EC,0x12EC,0x0000,0x0000, /* 2176 */
0x147B,0x12EC,0x12EC,0x12EC,0x0000, /* 2177 */
0x12EC,0x1497,0x0000,0x0000,0x0000, /* 2178 */
0x1497,0x0000,0x0000,0x0000,0x0000, /* 2179 */
0x1497,0x12EC,0x0000,0x0000,0x0000, /* 217A */
0x1497,0x12EC,0x12EC,0x0000,0x0000, /* 217B */
0x1330,0x0000,0x0000,0x0000,0x0000, /* 217C */
0x123D,0x0000,0x0000,0x0000,0x0000, /* 217D */
0x1250,0x0000,0x0000,0x0000,0x0000, /* 217E */
0x135F,0x0000,0x0000,0x0000,0x0000, /* 217F */
0x1130,0x0000,0x0000,0x0000,0x0000, /* 2180 */
0x1131,0x0000,0x0000,0x0000,0x0000, /* 2181 */
0x1132,0x0000,0x0000,0x0000,0x0000, /* 2182 */
0x124E,0x0000,0x0000,0x0000,0x0000, /* 2183 */
0x124E,0x0000,0x0000,0x0000,0x0000, /* 2184 */
0x120B,0x0000,0x0000,0x0000,0x0000, /* 2185 */
0x1133,0x0000,0x0000,0x0000,0x0000, /* 2186 */
0x1134,0x0000,0x0000,0x0000,0x0000, /* 2187 */
0x1135,0x0000,0x0000,0x0000,0x0000, /* 2188 */
0x1205,0x035D,0x1208,0x0000,0x0000, /* 2189 */
0xFBC0,0xA18A,0x0000,0x0000,0x0000, /* 218A */
0xFBC0,0xA18B,0x0000,0x0000,0x0000, /* 218B */
0xFBC0,0xA18C,0x0000,0x0000,0x0000, /* 218C */
0xFBC0,0xA18D,0x0000,0x0000,0x0000, /* 218D */
0xFBC0,0xA18E,0x0000,0x0000,0x0000, /* 218E */
0xFBC0,0xA18F,0x0000,0x0000,0x0000, /* 218F */
0x04D6,0x0000,0x0000,0x0000,0x0000, /* 2190 */
0x04D8,0x0000,0x0000,0x0000,0x0000, /* 2191 */
0x04D7,0x0000,0x0000,0x0000,0x0000, /* 2192 */
0x04D9,0x0000,0x0000,0x0000,0x0000, /* 2193 */
0x04DA,0x0000,0x0000,0x0000,0x0000, /* 2194 */
0x04DB,0x0000,0x0000,0x0000,0x0000, /* 2195 */
0x04DC,0x0000,0x0000,0x0000,0x0000, /* 2196 */
0x04DD,0x0000,0x0000,0x0000,0x0000, /* 2197 */
0x04DE,0x0000,0x0000,0x0000,0x0000, /* 2198 */
0x04DF,0x0000,0x0000,0x0000,0x0000, /* 2199 */
0x04D6,0x0000,0x0000,0x0000,0x0000, /* 219A */
0x04D7,0x0000,0x0000,0x0000,0x0000, /* 219B */
0x04E0,0x0000,0x0000,0x0000,0x0000, /* 219C */
0x04E1,0x0000,0x0000,0x0000,0x0000, /* 219D */
0x04E2,0x0000,0x0000,0x0000,0x0000, /* 219E */
0x04E3,0x0000,0x0000,0x0000,0x0000, /* 219F */
0x04E4,0x0000,0x0000,0x0000,0x0000, /* 21A0 */
0x04E5,0x0000,0x0000,0x0000,0x0000, /* 21A1 */
0x04E6,0x0000,0x0000,0x0000,0x0000, /* 21A2 */
0x04E7,0x0000,0x0000,0x0000,0x0000, /* 21A3 */
0x04E8,0x0000,0x0000,0x0000,0x0000, /* 21A4 */
0x04E9,0x0000,0x0000,0x0000,0x0000, /* 21A5 */
0x04EA,0x0000,0x0000,0x0000,0x0000, /* 21A6 */
0x04EB,0x0000,0x0000,0x0000,0x0000, /* 21A7 */
0x04EC,0x0000,0x0000,0x0000,0x0000, /* 21A8 */
0x04ED,0x0000,0x0000,0x0000,0x0000, /* 21A9 */
0x04EE,0x0000,0x0000,0x0000,0x0000, /* 21AA */
0x04EF,0x0000,0x0000,0x0000,0x0000, /* 21AB */
0x04F0,0x0000,0x0000,0x0000,0x0000, /* 21AC */
0x04F1,0x0000,0x0000,0x0000,0x0000, /* 21AD */
0x04DA,0x0000,0x0000,0x0000,0x0000, /* 21AE */
0x04F2,0x0000,0x0000,0x0000,0x0000, /* 21AF */
0x04F3,0x0000,0x0000,0x0000,0x0000, /* 21B0 */
0x04F4,0x0000,0x0000,0x0000,0x0000, /* 21B1 */
0x04F5,0x0000,0x0000,0x0000,0x0000, /* 21B2 */
0x04F6,0x0000,0x0000,0x0000,0x0000, /* 21B3 */
0x04F7,0x0000,0x0000,0x0000,0x0000, /* 21B4 */
0x04F8,0x0000,0x0000,0x0000,0x0000, /* 21B5 */
0x04F9,0x0000,0x0000,0x0000,0x0000, /* 21B6 */
0x04FA,0x0000,0x0000,0x0000,0x0000, /* 21B7 */
0x04FB,0x0000,0x0000,0x0000,0x0000, /* 21B8 */
0x04FC,0x0000,0x0000,0x0000,0x0000, /* 21B9 */
0x04FD,0x0000,0x0000,0x0000,0x0000, /* 21BA */
0x04FE,0x0000,0x0000,0x0000,0x0000, /* 21BB */
0x04FF,0x0000,0x0000,0x0000,0x0000, /* 21BC */
0x0500,0x0000,0x0000,0x0000,0x0000, /* 21BD */
0x0501,0x0000,0x0000,0x0000,0x0000, /* 21BE */
0x0502,0x0000,0x0000,0x0000,0x0000, /* 21BF */
0x0503,0x0000,0x0000,0x0000,0x0000, /* 21C0 */
0x0504,0x0000,0x0000,0x0000,0x0000, /* 21C1 */
0x0505,0x0000,0x0000,0x0000,0x0000, /* 21C2 */
0x0506,0x0000,0x0000,0x0000,0x0000, /* 21C3 */
0x0507,0x0000,0x0000,0x0000,0x0000, /* 21C4 */
0x0508,0x0000,0x0000,0x0000,0x0000, /* 21C5 */
0x0509,0x0000,0x0000,0x0000,0x0000, /* 21C6 */
0x050A,0x0000,0x0000,0x0000,0x0000, /* 21C7 */
0x050B,0x0000,0x0000,0x0000,0x0000, /* 21C8 */
0x050C,0x0000,0x0000,0x0000,0x0000, /* 21C9 */
0x050D,0x0000,0x0000,0x0000,0x0000, /* 21CA */
0x050E,0x0000,0x0000,0x0000,0x0000, /* 21CB */
0x050F,0x0000,0x0000,0x0000,0x0000, /* 21CC */
0x0510,0x0000,0x0000,0x0000,0x0000, /* 21CD */
0x0514,0x0000,0x0000,0x0000,0x0000, /* 21CE */
0x0512,0x0000,0x0000,0x0000,0x0000, /* 21CF */
0x0510,0x0000,0x0000,0x0000,0x0000, /* 21D0 */
0x0511,0x0000,0x0000,0x0000,0x0000, /* 21D1 */
0x0512,0x0000,0x0000,0x0000,0x0000, /* 21D2 */
0x0513,0x0000,0x0000,0x0000,0x0000, /* 21D3 */
0x0514,0x0000,0x0000,0x0000,0x0000, /* 21D4 */
0x0515,0x0000,0x0000,0x0000,0x0000, /* 21D5 */
0x0516,0x0000,0x0000,0x0000,0x0000, /* 21D6 */
0x0517,0x0000,0x0000,0x0000,0x0000, /* 21D7 */
0x0518,0x0000,0x0000,0x0000,0x0000, /* 21D8 */
0x0519,0x0000,0x0000,0x0000,0x0000, /* 21D9 */
0x051A,0x0000,0x0000,0x0000,0x0000, /* 21DA */
0x051B,0x0000,0x0000,0x0000,0x0000, /* 21DB */
0x051C,0x0000,0x0000,0x0000,0x0000, /* 21DC */
0x051D,0x0000,0x0000,0x0000,0x0000, /* 21DD */
0x051E,0x0000,0x0000,0x0000,0x0000, /* 21DE */
0x051F,0x0000,0x0000,0x0000,0x0000, /* 21DF */
0x0520,0x0000,0x0000,0x0000,0x0000, /* 21E0 */
0x0521,0x0000,0x0000,0x0000,0x0000, /* 21E1 */
0x0522,0x0000,0x0000,0x0000,0x0000, /* 21E2 */
0x0523,0x0000,0x0000,0x0000,0x0000, /* 21E3 */
0x0524,0x0000,0x0000,0x0000,0x0000, /* 21E4 */
0x0525,0x0000,0x0000,0x0000,0x0000, /* 21E5 */
0x0526,0x0000,0x0000,0x0000,0x0000, /* 21E6 */
0x0527,0x0000,0x0000,0x0000,0x0000, /* 21E7 */
0x0528,0x0000,0x0000,0x0000,0x0000, /* 21E8 */
0x0529,0x0000,0x0000,0x0000,0x0000, /* 21E9 */
0x052A,0x0000,0x0000,0x0000,0x0000, /* 21EA */
0x052B,0x0000,0x0000,0x0000,0x0000, /* 21EB */
0x052C,0x0000,0x0000,0x0000,0x0000, /* 21EC */
0x052D,0x0000,0x0000,0x0000,0x0000, /* 21ED */
0x052E,0x0000,0x0000,0x0000,0x0000, /* 21EE */
0x052F,0x0000,0x0000,0x0000,0x0000, /* 21EF */
0x0530,0x0000,0x0000,0x0000,0x0000, /* 21F0 */
0x0531,0x0000,0x0000,0x0000,0x0000, /* 21F1 */
0x0532,0x0000,0x0000,0x0000,0x0000, /* 21F2 */
0x0533,0x0000,0x0000,0x0000,0x0000, /* 21F3 */
0x0534,0x0000,0x0000,0x0000,0x0000, /* 21F4 */
0x0535,0x0000,0x0000,0x0000,0x0000, /* 21F5 */
0x0536,0x0000,0x0000,0x0000,0x0000, /* 21F6 */
0x0537,0x0000,0x0000,0x0000,0x0000, /* 21F7 */
0x0538,0x0000,0x0000,0x0000,0x0000, /* 21F8 */
0x0539,0x0000,0x0000,0x0000,0x0000, /* 21F9 */
0x053A,0x0000,0x0000,0x0000,0x0000, /* 21FA */
0x053B,0x0000,0x0000,0x0000,0x0000, /* 21FB */
0x053C,0x0000,0x0000,0x0000,0x0000, /* 21FC */
0x053D,0x0000,0x0000,0x0000,0x0000, /* 21FD */
0x053E,0x0000,0x0000,0x0000,0x0000, /* 21FE */
0x053F,0x0000,0x0000,0x0000,0x0000  /* 21FF */
};

uint16 uca520_p022[]= { /* 2200 (4 weights per char) */
0x0540,0x0000,0x0000,0x0000, 0x0541,0x0000,0x0000,0x0000, /* 2200 */
0x0542,0x0000,0x0000,0x0000, 0x0543,0x0000,0x0000,0x0000, /* 2202 */
0x0543,0x0000,0x0000,0x0000, 0x0544,0x0000,0x0000,0x0000, /* 2204 */
0x0545,0x0000,0x0000,0x0000, 0x0546,0x0000,0x0000,0x0000, /* 2206 */
0x0547,0x0000,0x0000,0x0000, 0x0547,0x0000,0x0000,0x0000, /* 2208 */
0x0548,0x0000,0x0000,0x0000, 0x0549,0x0000,0x0000,0x0000, /* 220A */
0x0549,0x0000,0x0000,0x0000, 0x054A,0x0000,0x0000,0x0000, /* 220C */
0x054C,0x0000,0x0000,0x0000, 0x054D,0x0000,0x0000,0x0000, /* 220E */
0x054E,0x0000,0x0000,0x0000, 0x054F,0x0000,0x0000,0x0000, /* 2210 */
0x055C,0x0000,0x0000,0x0000, 0x055D,0x0000,0x0000,0x0000, /* 2212 */
0x055E,0x0000,0x0000,0x0000, 0x055F,0x0000,0x0000,0x0000, /* 2214 */
0x0560,0x0000,0x0000,0x0000, 0x0561,0x0000,0x0000,0x0000, /* 2216 */
0x0562,0x0000,0x0000,0x0000, 0x0563,0x0000,0x0000,0x0000, /* 2218 */
0x0564,0x0000,0x0000,0x0000, 0x0565,0x0000,0x0000,0x0000, /* 221A */
0x0567,0x0000,0x0000,0x0000, 0x0569,0x0000,0x0000,0x0000, /* 221C */
0x056A,0x0000,0x0000,0x0000, 0x056B,0x0000,0x0000,0x0000, /* 221E */
0x056C,0x0000,0x0000,0x0000, 0x056D,0x0000,0x0000,0x0000, /* 2220 */
0x056E,0x0000,0x0000,0x0000, 0x056F,0x0000,0x0000,0x0000, /* 2222 */
0x056F,0x0000,0x0000,0x0000, 0x0570,0x0000,0x0000,0x0000, /* 2224 */
0x0570,0x0000,0x0000,0x0000, 0x0571,0x0000,0x0000,0x0000, /* 2226 */
0x0572,0x0000,0x0000,0x0000, 0x0573,0x0000,0x0000,0x0000, /* 2228 */
0x0574,0x0000,0x0000,0x0000, 0x0575,0x0000,0x0000,0x0000, /* 222A */
0x0575,0x0575,0x0000,0x0000, 0x0575,0x0575,0x0575,0x0000, /* 222C */
0x0576,0x0000,0x0000,0x0000, 0x0576,0x0576,0x0000,0x0000, /* 222E */
0x0576,0x0576,0x0576,0x0000, 0x0577,0x0000,0x0000,0x0000, /* 2230 */
0x0578,0x0000,0x0000,0x0000, 0x0579,0x0000,0x0000,0x0000, /* 2232 */
0x057A,0x0000,0x0000,0x0000, 0x057B,0x0000,0x0000,0x0000, /* 2234 */
0x057C,0x0000,0x0000,0x0000, 0x057D,0x0000,0x0000,0x0000, /* 2236 */
0x057E,0x0000,0x0000,0x0000, 0x057F,0x0000,0x0000,0x0000, /* 2238 */
0x0580,0x0000,0x0000,0x0000, 0x0581,0x0000,0x0000,0x0000, /* 223A */
0x0582,0x0000,0x0000,0x0000, 0x0583,0x0000,0x0000,0x0000, /* 223C */
0x0584,0x0000,0x0000,0x0000, 0x0585,0x0000,0x0000,0x0000, /* 223E */
0x0586,0x0000,0x0000,0x0000, 0x0582,0x0000,0x0000,0x0000, /* 2240 */
0x0587,0x0000,0x0000,0x0000, 0x0588,0x0000,0x0000,0x0000, /* 2242 */
0x0588,0x0000,0x0000,0x0000, 0x0589,0x0000,0x0000,0x0000, /* 2244 */
0x058A,0x0000,0x0000,0x0000, 0x0589,0x0000,0x0000,0x0000, /* 2246 */
0x058B,0x0000,0x0000,0x0000, 0x058B,0x0000,0x0000,0x0000, /* 2248 */
0x058C,0x0000,0x0000,0x0000, 0x058D,0x0000,0x0000,0x0000, /* 224A */
0x058E,0x0000,0x0000,0x0000, 0x058F,0x0000,0x0000,0x0000, /* 224C */
0x0590,0x0000,0x0000,0x0000, 0x0591,0x0000,0x0000,0x0000, /* 224E */
0x0592,0x0000,0x0000,0x0000, 0x0593,0x0000,0x0000,0x0000, /* 2250 */
0x0594,0x0000,0x0000,0x0000, 0x0595,0x0000,0x0000,0x0000, /* 2252 */
0x0596,0x0000,0x0000,0x0000, 0x0597,0x0000,0x0000,0x0000, /* 2254 */
0x0598,0x0000,0x0000,0x0000, 0x0599,0x0000,0x0000,0x0000, /* 2256 */
0x059A,0x0000,0x0000,0x0000, 0x059B,0x0000,0x0000,0x0000, /* 2258 */
0x059C,0x0000,0x0000,0x0000, 0x059D,0x0000,0x0000,0x0000, /* 225A */
0x059E,0x0000,0x0000,0x0000, 0x059F,0x0000,0x0000,0x0000, /* 225C */
0x05A0,0x0000,0x0000,0x0000, 0x05A1,0x0000,0x0000,0x0000, /* 225E */
0x0555,0x0000,0x0000,0x0000, 0x05A2,0x0000,0x0000,0x0000, /* 2260 */
0x05A2,0x0000,0x0000,0x0000, 0x05A3,0x0000,0x0000,0x0000, /* 2262 */
0x05A4,0x0000,0x0000,0x0000, 0x05A5,0x0000,0x0000,0x0000, /* 2264 */
0x05A6,0x0000,0x0000,0x0000, 0x05A7,0x0000,0x0000,0x0000, /* 2266 */
0x05A8,0x0000,0x0000,0x0000, 0x05A9,0x0000,0x0000,0x0000, /* 2268 */
0x05AA,0x0000,0x0000,0x0000, 0x05AB,0x0000,0x0000,0x0000, /* 226A */
0x05AC,0x0000,0x0000,0x0000, 0x058F,0x0000,0x0000,0x0000, /* 226C */
0x0554,0x0000,0x0000,0x0000, 0x0556,0x0000,0x0000,0x0000, /* 226E */
0x05A4,0x0000,0x0000,0x0000, 0x05A5,0x0000,0x0000,0x0000, /* 2270 */
0x05AD,0x0000,0x0000,0x0000, 0x05AE,0x0000,0x0000,0x0000, /* 2272 */
0x05AD,0x0000,0x0000,0x0000, 0x05AE,0x0000,0x0000,0x0000, /* 2274 */
0x05AF,0x0000,0x0000,0x0000, 0x05B0,0x0000,0x0000,0x0000, /* 2276 */
0x05AF,0x0000,0x0000,0x0000, 0x05B0,0x0000,0x0000,0x0000, /* 2278 */
0x05B1,0x0000,0x0000,0x0000, 0x05B2,0x0000,0x0000,0x0000, /* 227A */
0x05B3,0x0000,0x0000,0x0000, 0x05B4,0x0000,0x0000,0x0000, /* 227C */
0x05B5,0x0000,0x0000,0x0000, 0x05B6,0x0000,0x0000,0x0000, /* 227E */
0x05B1,0x0000,0x0000,0x0000, 0x05B2,0x0000,0x0000,0x0000, /* 2280 */
0x05B7,0x0000,0x0000,0x0000, 0x05B8,0x0000,0x0000,0x0000, /* 2282 */
0x05B7,0x0000,0x0000,0x0000, 0x05B8,0x0000,0x0000,0x0000, /* 2284 */
0x05B9,0x0000,0x0000,0x0000, 0x05BA,0x0000,0x0000,0x0000, /* 2286 */
0x05B9,0x0000,0x0000,0x0000, 0x05BA,0x0000,0x0000,0x0000, /* 2288 */
0x05BB,0x0000,0x0000,0x0000, 0x05BC,0x0000,0x0000,0x0000, /* 228A */
0x05BD,0x0000,0x0000,0x0000, 0x05BE,0x0000,0x0000,0x0000, /* 228C */
0x05BF,0x0000,0x0000,0x0000, 0x05C0,0x0000,0x0000,0x0000, /* 228E */
0x05C1,0x0000,0x0000,0x0000, 0x05C2,0x0000,0x0000,0x0000, /* 2290 */
0x05C3,0x0000,0x0000,0x0000, 0x05C4,0x0000,0x0000,0x0000, /* 2292 */
0x05C5,0x0000,0x0000,0x0000, 0x05C6,0x0000,0x0000,0x0000, /* 2294 */
0x05C7,0x0000,0x0000,0x0000, 0x05C8,0x0000,0x0000,0x0000, /* 2296 */
0x05C9,0x0000,0x0000,0x0000, 0x05CA,0x0000,0x0000,0x0000, /* 2298 */
0x05CB,0x0000,0x0000,0x0000, 0x05CC,0x0000,0x0000,0x0000, /* 229A */
0x05CD,0x0000,0x0000,0x0000, 0x05CE,0x0000,0x0000,0x0000, /* 229C */
0x05CF,0x0000,0x0000,0x0000, 0x05D0,0x0000,0x0000,0x0000, /* 229E */
0x05D1,0x0000,0x0000,0x0000, 0x05D2,0x0000,0x0000,0x0000, /* 22A0 */
0x05D3,0x0000,0x0000,0x0000, 0x05D4,0x0000,0x0000,0x0000, /* 22A2 */
0x05D5,0x0000,0x0000,0x0000, 0x05D6,0x0000,0x0000,0x0000, /* 22A4 */
0x05D7,0x0000,0x0000,0x0000, 0x05D8,0x0000,0x0000,0x0000, /* 22A6 */
0x05D9,0x0000,0x0000,0x0000, 0x05DA,0x0000,0x0000,0x0000, /* 22A8 */
0x05DB,0x0000,0x0000,0x0000, 0x05DC,0x0000,0x0000,0x0000, /* 22AA */
0x05D3,0x0000,0x0000,0x0000, 0x05D9,0x0000,0x0000,0x0000, /* 22AC */
0x05DA,0x0000,0x0000,0x0000, 0x05DC,0x0000,0x0000,0x0000, /* 22AE */
0x05DD,0x0000,0x0000,0x0000, 0x05DE,0x0000,0x0000,0x0000, /* 22B0 */
0x05DF,0x0000,0x0000,0x0000, 0x05E0,0x0000,0x0000,0x0000, /* 22B2 */
0x05E1,0x0000,0x0000,0x0000, 0x05E2,0x0000,0x0000,0x0000, /* 22B4 */
0x05E3,0x0000,0x0000,0x0000, 0x05E4,0x0000,0x0000,0x0000, /* 22B6 */
0x05E5,0x0000,0x0000,0x0000, 0x05E6,0x0000,0x0000,0x0000, /* 22B8 */
0x05E7,0x0000,0x0000,0x0000, 0x05E8,0x0000,0x0000,0x0000, /* 22BA */
0x05E9,0x0000,0x0000,0x0000, 0x05EA,0x0000,0x0000,0x0000, /* 22BC */
0x05EB,0x0000,0x0000,0x0000, 0x05EC,0x0000,0x0000,0x0000, /* 22BE */
0x05ED,0x0000,0x0000,0x0000, 0x05EE,0x0000,0x0000,0x0000, /* 22C0 */
0x05EF,0x0000,0x0000,0x0000, 0x05F0,0x0000,0x0000,0x0000, /* 22C2 */
0x05F1,0x0000,0x0000,0x0000, 0x05F2,0x0000,0x0000,0x0000, /* 22C4 */
0x05F3,0x0000,0x0000,0x0000, 0x05F4,0x0000,0x0000,0x0000, /* 22C6 */
0x05F5,0x0000,0x0000,0x0000, 0x05F6,0x0000,0x0000,0x0000, /* 22C8 */
0x05F7,0x0000,0x0000,0x0000, 0x05F8,0x0000,0x0000,0x0000, /* 22CA */
0x05F9,0x0000,0x0000,0x0000, 0x05FA,0x0000,0x0000,0x0000, /* 22CC */
0x05FB,0x0000,0x0000,0x0000, 0x05FC,0x0000,0x0000,0x0000, /* 22CE */
0x05FD,0x0000,0x0000,0x0000, 0x05FE,0x0000,0x0000,0x0000, /* 22D0 */
0x05FF,0x0000,0x0000,0x0000, 0x0600,0x0000,0x0000,0x0000, /* 22D2 */
0x0601,0x0000,0x0000,0x0000, 0x0602,0x0000,0x0000,0x0000, /* 22D4 */
0x0603,0x0000,0x0000,0x0000, 0x0604,0x0000,0x0000,0x0000, /* 22D6 */
0x0605,0x0000,0x0000,0x0000, 0x0606,0x0000,0x0000,0x0000, /* 22D8 */
0x0607,0x0000,0x0000,0x0000, 0x0608,0x0000,0x0000,0x0000, /* 22DA */
0x0609,0x0000,0x0000,0x0000, 0x060A,0x0000,0x0000,0x0000, /* 22DC */
0x060B,0x0000,0x0000,0x0000, 0x060C,0x0000,0x0000,0x0000, /* 22DE */
0x05B3,0x0000,0x0000,0x0000, 0x05B4,0x0000,0x0000,0x0000, /* 22E0 */
0x05C2,0x0000,0x0000,0x0000, 0x05C3,0x0000,0x0000,0x0000, /* 22E2 */
0x060D,0x0000,0x0000,0x0000, 0x060E,0x0000,0x0000,0x0000, /* 22E4 */
0x060F,0x0000,0x0000,0x0000, 0x0610,0x0000,0x0000,0x0000, /* 22E6 */
0x0611,0x0000,0x0000,0x0000, 0x0612,0x0000,0x0000,0x0000, /* 22E8 */
0x05DF,0x0000,0x0000,0x0000, 0x05E0,0x0000,0x0000,0x0000, /* 22EA */
0x05E1,0x0000,0x0000,0x0000, 0x05E2,0x0000,0x0000,0x0000, /* 22EC */
0x0613,0x0000,0x0000,0x0000, 0x0614,0x0000,0x0000,0x0000, /* 22EE */
0x0615,0x0000,0x0000,0x0000, 0x0616,0x0000,0x0000,0x0000, /* 22F0 */
0x0617,0x0000,0x0000,0x0000, 0x0618,0x0000,0x0000,0x0000, /* 22F2 */
0x0619,0x0000,0x0000,0x0000, 0x061A,0x0000,0x0000,0x0000, /* 22F4 */
0x061B,0x0000,0x0000,0x0000, 0x061C,0x0000,0x0000,0x0000, /* 22F6 */
0x061D,0x0000,0x0000,0x0000, 0x061E,0x0000,0x0000,0x0000, /* 22F8 */
0x061F,0x0000,0x0000,0x0000, 0x0620,0x0000,0x0000,0x0000, /* 22FA */
0x0621,0x0000,0x0000,0x0000, 0x0622,0x0000,0x0000,0x0000, /* 22FC */
0x0623,0x0000,0x0000,0x0000, 0x0624,0x0000,0x0000,0x0000  /* 22FE */
};

uint16 uca520_p023[]= { /* 2300 (3 weights per char) */
0x0625,0x0000,0x0000, 0x0626,0x0000,0x0000, 0x0627,0x0000,0x0000, /* 2300 */
0x0628,0x0000,0x0000, 0x0629,0x0000,0x0000, 0x062A,0x0000,0x0000, /* 2303 */
0x062B,0x0000,0x0000, 0x062C,0x0000,0x0000, 0x062D,0x0000,0x0000, /* 2306 */
0x062E,0x0000,0x0000, 0x062F,0x0000,0x0000, 0x0630,0x0000,0x0000, /* 2309 */
0x0631,0x0000,0x0000, 0x0632,0x0000,0x0000, 0x0633,0x0000,0x0000, /* 230C */
0x0634,0x0000,0x0000, 0x0635,0x0000,0x0000, 0x0636,0x0000,0x0000, /* 230F */
0x0637,0x0000,0x0000, 0x0638,0x0000,0x0000, 0x0639,0x0000,0x0000, /* 2312 */
0x063A,0x0000,0x0000, 0x063B,0x0000,0x0000, 0x063C,0x0000,0x0000, /* 2315 */
0x063D,0x0000,0x0000, 0x063E,0x0000,0x0000, 0x063F,0x0000,0x0000, /* 2318 */
0x0640,0x0000,0x0000, 0x0641,0x0000,0x0000, 0x0642,0x0000,0x0000, /* 231B */
0x0643,0x0000,0x0000, 0x0644,0x0000,0x0000, 0x0645,0x0000,0x0000, /* 231E */
0x0646,0x0000,0x0000, 0x0647,0x0000,0x0000, 0x0648,0x0000,0x0000, /* 2321 */
0x0649,0x0000,0x0000, 0x064A,0x0000,0x0000, 0x064B,0x0000,0x0000, /* 2324 */
0x064C,0x0000,0x0000, 0x064D,0x0000,0x0000, 0x033D,0x0000,0x0000, /* 2327 */
0x033E,0x0000,0x0000, 0x064E,0x0000,0x0000, 0x064F,0x0000,0x0000, /* 232A */
0x0650,0x0000,0x0000, 0x0651,0x0000,0x0000, 0x0652,0x0000,0x0000, /* 232D */
0x0653,0x0000,0x0000, 0x0654,0x0000,0x0000, 0x0655,0x0000,0x0000, /* 2330 */
0x0656,0x0000,0x0000, 0x0657,0x0000,0x0000, 0x0658,0x0000,0x0000, /* 2333 */
0x0659,0x0000,0x0000, 0x065A,0x0000,0x0000, 0x065B,0x0000,0x0000, /* 2336 */
0x065C,0x0000,0x0000, 0x065D,0x0000,0x0000, 0x065E,0x0000,0x0000, /* 2339 */
0x065F,0x0000,0x0000, 0x0660,0x0000,0x0000, 0x0661,0x0000,0x0000, /* 233C */
0x0662,0x0000,0x0000, 0x0663,0x0000,0x0000, 0x0664,0x0000,0x0000, /* 233F */
0x0665,0x0000,0x0000, 0x0666,0x0000,0x0000, 0x0667,0x0000,0x0000, /* 2342 */
0x0668,0x0000,0x0000, 0x0669,0x0000,0x0000, 0x066A,0x0000,0x0000, /* 2345 */
0x066B,0x0000,0x0000, 0x066C,0x0000,0x0000, 0x066D,0x0000,0x0000, /* 2348 */
0x066E,0x0000,0x0000, 0x066F,0x0000,0x0000, 0x0670,0x0000,0x0000, /* 234B */
0x0671,0x0000,0x0000, 0x0672,0x0000,0x0000, 0x0673,0x0000,0x0000, /* 234E */
0x0674,0x0000,0x0000, 0x0675,0x0000,0x0000, 0x0676,0x0000,0x0000, /* 2351 */
0x0677,0x0000,0x0000, 0x0678,0x0000,0x0000, 0x0679,0x0000,0x0000, /* 2354 */
0x067A,0x0000,0x0000, 0x067B,0x0000,0x0000, 0x067C,0x0000,0x0000, /* 2357 */
0x067D,0x0000,0x0000, 0x067E,0x0000,0x0000, 0x067F,0x0000,0x0000, /* 235A */
0x0680,0x0000,0x0000, 0x0681,0x0000,0x0000, 0x0682,0x0000,0x0000, /* 235D */
0x0683,0x0000,0x0000, 0x0684,0x0000,0x0000, 0x0685,0x0000,0x0000, /* 2360 */
0x0686,0x0000,0x0000, 0x0687,0x0000,0x0000, 0x0688,0x0000,0x0000, /* 2363 */
0x0689,0x0000,0x0000, 0x068A,0x0000,0x0000, 0x068B,0x0000,0x0000, /* 2366 */
0x068C,0x0000,0x0000, 0x068D,0x0000,0x0000, 0x068E,0x0000,0x0000, /* 2369 */
0x068F,0x0000,0x0000, 0x0690,0x0000,0x0000, 0x0691,0x0000,0x0000, /* 236C */
0x0692,0x0000,0x0000, 0x0693,0x0000,0x0000, 0x0694,0x0000,0x0000, /* 236F */
0x0695,0x0000,0x0000, 0x0696,0x0000,0x0000, 0x0697,0x0000,0x0000, /* 2372 */
0x0698,0x0000,0x0000, 0x0699,0x0000,0x0000, 0x069A,0x0000,0x0000, /* 2375 */
0x069B,0x0000,0x0000, 0x069C,0x0000,0x0000, 0x069D,0x0000,0x0000, /* 2378 */
0x069E,0x0000,0x0000, 0x069F,0x0000,0x0000, 0x06A0,0x0000,0x0000, /* 237B */
0x06A1,0x0000,0x0000, 0x06A2,0x0000,0x0000, 0x06A3,0x0000,0x0000, /* 237E */
0x06A4,0x0000,0x0000, 0x06A5,0x0000,0x0000, 0x06A6,0x0000,0x0000, /* 2381 */
0x06A7,0x0000,0x0000, 0x06A8,0x0000,0x0000, 0x06A9,0x0000,0x0000, /* 2384 */
0x06AA,0x0000,0x0000, 0x06AB,0x0000,0x0000, 0x06AC,0x0000,0x0000, /* 2387 */
0x06AD,0x0000,0x0000, 0x06AE,0x0000,0x0000, 0x06AF,0x0000,0x0000, /* 238A */
0x06B0,0x0000,0x0000, 0x06B1,0x0000,0x0000, 0x06B2,0x0000,0x0000, /* 238D */
0x06B3,0x0000,0x0000, 0x06B4,0x0000,0x0000, 0x06B5,0x0000,0x0000, /* 2390 */
0x06B6,0x0000,0x0000, 0x06B7,0x0000,0x0000, 0x06B8,0x0000,0x0000, /* 2393 */
0x06B9,0x0000,0x0000, 0x06BA,0x0000,0x0000, 0x06BB,0x0000,0x0000, /* 2396 */
0x06BC,0x0000,0x0000, 0x06BD,0x0000,0x0000, 0x06BE,0x0000,0x0000, /* 2399 */
0x06BF,0x0000,0x0000, 0x06C0,0x0000,0x0000, 0x06C1,0x0000,0x0000, /* 239C */
0x06C2,0x0000,0x0000, 0x06C3,0x0000,0x0000, 0x06C4,0x0000,0x0000, /* 239F */
0x06C5,0x0000,0x0000, 0x06C6,0x0000,0x0000, 0x06C7,0x0000,0x0000, /* 23A2 */
0x06C8,0x0000,0x0000, 0x06C9,0x0000,0x0000, 0x06CA,0x0000,0x0000, /* 23A5 */
0x06CB,0x0000,0x0000, 0x06CC,0x0000,0x0000, 0x06CD,0x0000,0x0000, /* 23A8 */
0x06CE,0x0000,0x0000, 0x06CF,0x0000,0x0000, 0x06D0,0x0000,0x0000, /* 23AB */
0x06D1,0x0000,0x0000, 0x06D2,0x0000,0x0000, 0x06D3,0x0000,0x0000, /* 23AE */
0x06D4,0x0000,0x0000, 0x06D5,0x0000,0x0000, 0x06D6,0x0000,0x0000, /* 23B1 */
0x06D7,0x0000,0x0000, 0x06D8,0x0000,0x0000, 0x06D9,0x0000,0x0000, /* 23B4 */
0x06DA,0x0000,0x0000, 0x06DB,0x0000,0x0000, 0x06DC,0x0000,0x0000, /* 23B7 */
0x06DD,0x0000,0x0000, 0x06DE,0x0000,0x0000, 0x06DF,0x0000,0x0000, /* 23BA */
0x06E0,0x0000,0x0000, 0x06E1,0x0000,0x0000, 0x06E2,0x0000,0x0000, /* 23BD */
0x06E3,0x0000,0x0000, 0x06E4,0x0000,0x0000, 0x06E5,0x0000,0x0000, /* 23C0 */
0x06E6,0x0000,0x0000, 0x06E7,0x0000,0x0000, 0x06E8,0x0000,0x0000, /* 23C3 */
0x06E9,0x0000,0x0000, 0x06EA,0x0000,0x0000, 0x06EB,0x0000,0x0000, /* 23C6 */
0x06EC,0x0000,0x0000, 0x06ED,0x0000,0x0000, 0x06EE,0x0000,0x0000, /* 23C9 */
0x06EF,0x0000,0x0000, 0x06F0,0x0000,0x0000, 0x06F1,0x0000,0x0000, /* 23CC */
0x06F2,0x0000,0x0000, 0x06F3,0x0000,0x0000, 0x06F4,0x0000,0x0000, /* 23CF */
0x06F5,0x0000,0x0000, 0x06F6,0x0000,0x0000, 0x06F7,0x0000,0x0000, /* 23D2 */
0x06F8,0x0000,0x0000, 0x06F9,0x0000,0x0000, 0x06FA,0x0000,0x0000, /* 23D5 */
0x06FB,0x0000,0x0000, 0x06FC,0x0000,0x0000, 0x06FD,0x0000,0x0000, /* 23D8 */
0x06FE,0x0000,0x0000, 0x06FF,0x0000,0x0000, 0x0700,0x0000,0x0000, /* 23DB */
0x0701,0x0000,0x0000, 0x0702,0x0000,0x0000, 0x0703,0x0000,0x0000, /* 23DE */
0x0704,0x0000,0x0000, 0x0705,0x0000,0x0000, 0x0706,0x0000,0x0000, /* 23E1 */
0x0707,0x0000,0x0000, 0x0708,0x0000,0x0000, 0x0709,0x0000,0x0000, /* 23E4 */
0x070A,0x0000,0x0000, 0x070B,0x0000,0x0000, 0xFBC0,0xA3E9,0x0000, /* 23E7 */
0xFBC0,0xA3EA,0x0000, 0xFBC0,0xA3EB,0x0000, 0xFBC0,0xA3EC,0x0000, /* 23EA */
0xFBC0,0xA3ED,0x0000, 0xFBC0,0xA3EE,0x0000, 0xFBC0,0xA3EF,0x0000, /* 23ED */
0xFBC0,0xA3F0,0x0000, 0xFBC0,0xA3F1,0x0000, 0xFBC0,0xA3F2,0x0000, /* 23F0 */
0xFBC0,0xA3F3,0x0000, 0xFBC0,0xA3F4,0x0000, 0xFBC0,0xA3F5,0x0000, /* 23F3 */
0xFBC0,0xA3F6,0x0000, 0xFBC0,0xA3F7,0x0000, 0xFBC0,0xA3F8,0x0000, /* 23F6 */
0xFBC0,0xA3F9,0x0000, 0xFBC0,0xA3FA,0x0000, 0xFBC0,0xA3FB,0x0000, /* 23F9 */
0xFBC0,0xA3FC,0x0000, 0xFBC0,0xA3FD,0x0000, 0xFBC0,0xA3FE,0x0000, /* 23FC */
0xFBC0,0xA3FF,0x0000  };

uint16 uca520_p024[]= { /* 2400 (5 weights per char) */
0x070C,0x0000,0x0000,0x0000,0x0000, /* 2400 */
0x070D,0x0000,0x0000,0x0000,0x0000, /* 2401 */
0x070E,0x0000,0x0000,0x0000,0x0000, /* 2402 */
0x070F,0x0000,0x0000,0x0000,0x0000, /* 2403 */
0x0710,0x0000,0x0000,0x0000,0x0000, /* 2404 */
0x0711,0x0000,0x0000,0x0000,0x0000, /* 2405 */
0x0712,0x0000,0x0000,0x0000,0x0000, /* 2406 */
0x0713,0x0000,0x0000,0x0000,0x0000, /* 2407 */
0x0714,0x0000,0x0000,0x0000,0x0000, /* 2408 */
0x0715,0x0000,0x0000,0x0000,0x0000, /* 2409 */
0x0716,0x0000,0x0000,0x0000,0x0000, /* 240A */
0x0717,0x0000,0x0000,0x0000,0x0000, /* 240B */
0x0718,0x0000,0x0000,0x0000,0x0000, /* 240C */
0x0719,0x0000,0x0000,0x0000,0x0000, /* 240D */
0x071A,0x0000,0x0000,0x0000,0x0000, /* 240E */
0x071B,0x0000,0x0000,0x0000,0x0000, /* 240F */
0x071C,0x0000,0x0000,0x0000,0x0000, /* 2410 */
0x071D,0x0000,0x0000,0x0000,0x0000, /* 2411 */
0x071E,0x0000,0x0000,0x0000,0x0000, /* 2412 */
0x071F,0x0000,0x0000,0x0000,0x0000, /* 2413 */
0x0720,0x0000,0x0000,0x0000,0x0000, /* 2414 */
0x0721,0x0000,0x0000,0x0000,0x0000, /* 2415 */
0x0722,0x0000,0x0000,0x0000,0x0000, /* 2416 */
0x0723,0x0000,0x0000,0x0000,0x0000, /* 2417 */
0x0724,0x0000,0x0000,0x0000,0x0000, /* 2418 */
0x0725,0x0000,0x0000,0x0000,0x0000, /* 2419 */
0x0726,0x0000,0x0000,0x0000,0x0000, /* 241A */
0x0727,0x0000,0x0000,0x0000,0x0000, /* 241B */
0x0728,0x0000,0x0000,0x0000,0x0000, /* 241C */
0x0729,0x0000,0x0000,0x0000,0x0000, /* 241D */
0x072A,0x0000,0x0000,0x0000,0x0000, /* 241E */
0x072B,0x0000,0x0000,0x0000,0x0000, /* 241F */
0x072C,0x0000,0x0000,0x0000,0x0000, /* 2420 */
0x072D,0x0000,0x0000,0x0000,0x0000, /* 2421 */
0x072E,0x0000,0x0000,0x0000,0x0000, /* 2422 */
0x072F,0x0000,0x0000,0x0000,0x0000, /* 2423 */
0x0730,0x0000,0x0000,0x0000,0x0000, /* 2424 */
0x0731,0x0000,0x0000,0x0000,0x0000, /* 2425 */
0x0732,0x0000,0x0000,0x0000,0x0000, /* 2426 */
0xFBC0,0xA427,0x0000,0x0000,0x0000, /* 2427 */
0xFBC0,0xA428,0x0000,0x0000,0x0000, /* 2428 */
0xFBC0,0xA429,0x0000,0x0000,0x0000, /* 2429 */
0xFBC0,0xA42A,0x0000,0x0000,0x0000, /* 242A */
0xFBC0,0xA42B,0x0000,0x0000,0x0000, /* 242B */
0xFBC0,0xA42C,0x0000,0x0000,0x0000, /* 242C */
0xFBC0,0xA42D,0x0000,0x0000,0x0000, /* 242D */
0xFBC0,0xA42E,0x0000,0x0000,0x0000, /* 242E */
0xFBC0,0xA42F,0x0000,0x0000,0x0000, /* 242F */
0xFBC0,0xA430,0x0000,0x0000,0x0000, /* 2430 */
0xFBC0,0xA431,0x0000,0x0000,0x0000, /* 2431 */
0xFBC0,0xA432,0x0000,0x0000,0x0000, /* 2432 */
0xFBC0,0xA433,0x0000,0x0000,0x0000, /* 2433 */
0xFBC0,0xA434,0x0000,0x0000,0x0000, /* 2434 */
0xFBC0,0xA435,0x0000,0x0000,0x0000, /* 2435 */
0xFBC0,0xA436,0x0000,0x0000,0x0000, /* 2436 */
0xFBC0,0xA437,0x0000,0x0000,0x0000, /* 2437 */
0xFBC0,0xA438,0x0000,0x0000,0x0000, /* 2438 */
0xFBC0,0xA439,0x0000,0x0000,0x0000, /* 2439 */
0xFBC0,0xA43A,0x0000,0x0000,0x0000, /* 243A */
0xFBC0,0xA43B,0x0000,0x0000,0x0000, /* 243B */
0xFBC0,0xA43C,0x0000,0x0000,0x0000, /* 243C */
0xFBC0,0xA43D,0x0000,0x0000,0x0000, /* 243D */
0xFBC0,0xA43E,0x0000,0x0000,0x0000, /* 243E */
0xFBC0,0xA43F,0x0000,0x0000,0x0000, /* 243F */
0x0733,0x0000,0x0000,0x0000,0x0000, /* 2440 */
0x0734,0x0000,0x0000,0x0000,0x0000, /* 2441 */
0x0735,0x0000,0x0000,0x0000,0x0000, /* 2442 */
0x0736,0x0000,0x0000,0x0000,0x0000, /* 2443 */
0x0737,0x0000,0x0000,0x0000,0x0000, /* 2444 */
0x0738,0x0000,0x0000,0x0000,0x0000, /* 2445 */
0x0739,0x0000,0x0000,0x0000,0x0000, /* 2446 */
0x073A,0x0000,0x0000,0x0000,0x0000, /* 2447 */
0x073B,0x0000,0x0000,0x0000,0x0000, /* 2448 */
0x073C,0x0000,0x0000,0x0000,0x0000, /* 2449 */
0x073D,0x0000,0x0000,0x0000,0x0000, /* 244A */
0xFBC0,0xA44B,0x0000,0x0000,0x0000, /* 244B */
0xFBC0,0xA44C,0x0000,0x0000,0x0000, /* 244C */
0xFBC0,0xA44D,0x0000,0x0000,0x0000, /* 244D */
0xFBC0,0xA44E,0x0000,0x0000,0x0000, /* 244E */
0xFBC0,0xA44F,0x0000,0x0000,0x0000, /* 244F */
0xFBC0,0xA450,0x0000,0x0000,0x0000, /* 2450 */
0xFBC0,0xA451,0x0000,0x0000,0x0000, /* 2451 */
0xFBC0,0xA452,0x0000,0x0000,0x0000, /* 2452 */
0xFBC0,0xA453,0x0000,0x0000,0x0000, /* 2453 */
0xFBC0,0xA454,0x0000,0x0000,0x0000, /* 2454 */
0xFBC0,0xA455,0x0000,0x0000,0x0000, /* 2455 */
0xFBC0,0xA456,0x0000,0x0000,0x0000, /* 2456 */
0xFBC0,0xA457,0x0000,0x0000,0x0000, /* 2457 */
0xFBC0,0xA458,0x0000,0x0000,0x0000, /* 2458 */
0xFBC0,0xA459,0x0000,0x0000,0x0000, /* 2459 */
0xFBC0,0xA45A,0x0000,0x0000,0x0000, /* 245A */
0xFBC0,0xA45B,0x0000,0x0000,0x0000, /* 245B */
0xFBC0,0xA45C,0x0000,0x0000,0x0000, /* 245C */
0xFBC0,0xA45D,0x0000,0x0000,0x0000, /* 245D */
0xFBC0,0xA45E,0x0000,0x0000,0x0000, /* 245E */
0xFBC0,0xA45F,0x0000,0x0000,0x0000, /* 245F */
0x1206,0x0000,0x0000,0x0000,0x0000, /* 2460 */
0x1207,0x0000,0x0000,0x0000,0x0000, /* 2461 */
0x1208,0x0000,0x0000,0x0000,0x0000, /* 2462 */
0x1209,0x0000,0x0000,0x0000,0x0000, /* 2463 */
0x120A,0x0000,0x0000,0x0000,0x0000, /* 2464 */
0x120B,0x0000,0x0000,0x0000,0x0000, /* 2465 */
0x120C,0x0000,0x0000,0x0000,0x0000, /* 2466 */
0x120D,0x0000,0x0000,0x0000,0x0000, /* 2467 */
0x120E,0x0000,0x0000,0x0000,0x0000, /* 2468 */
0x1206,0x1205,0x0000,0x0000,0x0000, /* 2469 */
0x1206,0x1206,0x0000,0x0000,0x0000, /* 246A */
0x1206,0x1207,0x0000,0x0000,0x0000, /* 246B */
0x1206,0x1208,0x0000,0x0000,0x0000, /* 246C */
0x1206,0x1209,0x0000,0x0000,0x0000, /* 246D */
0x1206,0x120A,0x0000,0x0000,0x0000, /* 246E */
0x1206,0x120B,0x0000,0x0000,0x0000, /* 246F */
0x1206,0x120C,0x0000,0x0000,0x0000, /* 2470 */
0x1206,0x120D,0x0000,0x0000,0x0000, /* 2471 */
0x1206,0x120E,0x0000,0x0000,0x0000, /* 2472 */
0x1207,0x1205,0x0000,0x0000,0x0000, /* 2473 */
0x02FF,0x1206,0x0300,0x0000,0x0000, /* 2474 */
0x02FF,0x1207,0x0300,0x0000,0x0000, /* 2475 */
0x02FF,0x1208,0x0300,0x0000,0x0000, /* 2476 */
0x02FF,0x1209,0x0300,0x0000,0x0000, /* 2477 */
0x02FF,0x120A,0x0300,0x0000,0x0000, /* 2478 */
0x02FF,0x120B,0x0300,0x0000,0x0000, /* 2479 */
0x02FF,0x120C,0x0300,0x0000,0x0000, /* 247A */
0x02FF,0x120D,0x0300,0x0000,0x0000, /* 247B */
0x02FF,0x120E,0x0300,0x0000,0x0000, /* 247C */
0x02FF,0x1206,0x1205,0x0300,0x0000, /* 247D */
0x02FF,0x1206,0x1206,0x0300,0x0000, /* 247E */
0x02FF,0x1206,0x1207,0x0300,0x0000, /* 247F */
0x02FF,0x1206,0x1208,0x0300,0x0000, /* 2480 */
0x02FF,0x1206,0x1209,0x0300,0x0000, /* 2481 */
0x02FF,0x1206,0x120A,0x0300,0x0000, /* 2482 */
0x02FF,0x1206,0x120B,0x0300,0x0000, /* 2483 */
0x02FF,0x1206,0x120C,0x0300,0x0000, /* 2484 */
0x02FF,0x1206,0x120D,0x0300,0x0000, /* 2485 */
0x02FF,0x1206,0x120E,0x0300,0x0000, /* 2486 */
0x02FF,0x1207,0x1205,0x0300,0x0000, /* 2487 */
0x1206,0x0281,0x0000,0x0000,0x0000, /* 2488 */
0x1207,0x0281,0x0000,0x0000,0x0000, /* 2489 */
0x1208,0x0281,0x0000,0x0000,0x0000, /* 248A */
0x1209,0x0281,0x0000,0x0000,0x0000, /* 248B */
0x120A,0x0281,0x0000,0x0000,0x0000, /* 248C */
0x120B,0x0281,0x0000,0x0000,0x0000, /* 248D */
0x120C,0x0281,0x0000,0x0000,0x0000, /* 248E */
0x120D,0x0281,0x0000,0x0000,0x0000, /* 248F */
0x120E,0x0281,0x0000,0x0000,0x0000, /* 2490 */
0x1206,0x1205,0x0281,0x0000,0x0000, /* 2491 */
0x1206,0x1206,0x0281,0x0000,0x0000, /* 2492 */
0x1206,0x1207,0x0281,0x0000,0x0000, /* 2493 */
0x1206,0x1208,0x0281,0x0000,0x0000, /* 2494 */
0x1206,0x1209,0x0281,0x0000,0x0000, /* 2495 */
0x1206,0x120A,0x0281,0x0000,0x0000, /* 2496 */
0x1206,0x120B,0x0281,0x0000,0x0000, /* 2497 */
0x1206,0x120C,0x0281,0x0000,0x0000, /* 2498 */
0x1206,0x120D,0x0281,0x0000,0x0000, /* 2499 */
0x1206,0x120E,0x0281,0x0000,0x0000, /* 249A */
0x1207,0x1205,0x0281,0x0000,0x0000, /* 249B */
0x02FF,0x120F,0x0300,0x0000,0x0000, /* 249C */
0x02FF,0x1225,0x0300,0x0000,0x0000, /* 249D */
0x02FF,0x123D,0x0300,0x0000,0x0000, /* 249E */
0x02FF,0x1250,0x0300,0x0000,0x0000, /* 249F */
0x02FF,0x126B,0x0300,0x0000,0x0000, /* 24A0 */
0x02FF,0x12A3,0x0300,0x0000,0x0000, /* 24A1 */
0x02FF,0x12B0,0x0300,0x0000,0x0000, /* 24A2 */
0x02FF,0x12D3,0x0300,0x0000,0x0000, /* 24A3 */
0x02FF,0x12EC,0x0300,0x0000,0x0000, /* 24A4 */
0x02FF,0x1305,0x0300,0x0000,0x0000, /* 24A5 */
0x02FF,0x131E,0x0300,0x0000,0x0000, /* 24A6 */
0x02FF,0x1330,0x0300,0x0000,0x0000, /* 24A7 */
0x02FF,0x135F,0x0300,0x0000,0x0000, /* 24A8 */
0x02FF,0x136D,0x0300,0x0000,0x0000, /* 24A9 */
0x02FF,0x138E,0x0300,0x0000,0x0000, /* 24AA */
0x02FF,0x13B3,0x0300,0x0000,0x0000, /* 24AB */
0x02FF,0x13C8,0x0300,0x0000,0x0000, /* 24AC */
0x02FF,0x13DA,0x0300,0x0000,0x0000, /* 24AD */
0x02FF,0x1410,0x0300,0x0000,0x0000, /* 24AE */
0x02FF,0x1433,0x0300,0x0000,0x0000, /* 24AF */
0x02FF,0x1453,0x0300,0x0000,0x0000, /* 24B0 */
0x02FF,0x147B,0x0300,0x0000,0x0000, /* 24B1 */
0x02FF,0x148D,0x0300,0x0000,0x0000, /* 24B2 */
0x02FF,0x1497,0x0300,0x0000,0x0000, /* 24B3 */
0x02FF,0x149C,0x0300,0x0000,0x0000, /* 24B4 */
0x02FF,0x14AD,0x0300,0x0000,0x0000, /* 24B5 */
0x120F,0x0000,0x0000,0x0000,0x0000, /* 24B6 */
0x1225,0x0000,0x0000,0x0000,0x0000, /* 24B7 */
0x123D,0x0000,0x0000,0x0000,0x0000, /* 24B8 */
0x1250,0x0000,0x0000,0x0000,0x0000, /* 24B9 */
0x126B,0x0000,0x0000,0x0000,0x0000, /* 24BA */
0x12A3,0x0000,0x0000,0x0000,0x0000, /* 24BB */
0x12B0,0x0000,0x0000,0x0000,0x0000, /* 24BC */
0x12D3,0x0000,0x0000,0x0000,0x0000, /* 24BD */
0x12EC,0x0000,0x0000,0x0000,0x0000, /* 24BE */
0x1305,0x0000,0x0000,0x0000,0x0000, /* 24BF */
0x131E,0x0000,0x0000,0x0000,0x0000, /* 24C0 */
0x1330,0x0000,0x0000,0x0000,0x0000, /* 24C1 */
0x135F,0x0000,0x0000,0x0000,0x0000, /* 24C2 */
0x136D,0x0000,0x0000,0x0000,0x0000, /* 24C3 */
0x138E,0x0000,0x0000,0x0000,0x0000, /* 24C4 */
0x13B3,0x0000,0x0000,0x0000,0x0000, /* 24C5 */
0x13C8,0x0000,0x0000,0x0000,0x0000, /* 24C6 */
0x13DA,0x0000,0x0000,0x0000,0x0000, /* 24C7 */
0x1410,0x0000,0x0000,0x0000,0x0000, /* 24C8 */
0x1433,0x0000,0x0000,0x0000,0x0000, /* 24C9 */
0x1453,0x0000,0x0000,0x0000,0x0000, /* 24CA */
0x147B,0x0000,0x0000,0x0000,0x0000, /* 24CB */
0x148D,0x0000,0x0000,0x0000,0x0000, /* 24CC */
0x1497,0x0000,0x0000,0x0000,0x0000, /* 24CD */
0x149C,0x0000,0x0000,0x0000,0x0000, /* 24CE */
0x14AD,0x0000,0x0000,0x0000,0x0000, /* 24CF */
0x120F,0x0000,0x0000,0x0000,0x0000, /* 24D0 */
0x1225,0x0000,0x0000,0x0000,0x0000, /* 24D1 */
0x123D,0x0000,0x0000,0x0000,0x0000, /* 24D2 */
0x1250,0x0000,0x0000,0x0000,0x0000, /* 24D3 */
0x126B,0x0000,0x0000,0x0000,0x0000, /* 24D4 */
0x12A3,0x0000,0x0000,0x0000,0x0000, /* 24D5 */
0x12B0,0x0000,0x0000,0x0000,0x0000, /* 24D6 */
0x12D3,0x0000,0x0000,0x0000,0x0000, /* 24D7 */
0x12EC,0x0000,0x0000,0x0000,0x0000, /* 24D8 */
0x1305,0x0000,0x0000,0x0000,0x0000, /* 24D9 */
0x131E,0x0000,0x0000,0x0000,0x0000, /* 24DA */
0x1330,0x0000,0x0000,0x0000,0x0000, /* 24DB */
0x135F,0x0000,0x0000,0x0000,0x0000, /* 24DC */
0x136D,0x0000,0x0000,0x0000,0x0000, /* 24DD */
0x138E,0x0000,0x0000,0x0000,0x0000, /* 24DE */
0x13B3,0x0000,0x0000,0x0000,0x0000, /* 24DF */
0x13C8,0x0000,0x0000,0x0000,0x0000, /* 24E0 */
0x13DA,0x0000,0x0000,0x0000,0x0000, /* 24E1 */
0x1410,0x0000,0x0000,0x0000,0x0000, /* 24E2 */
0x1433,0x0000,0x0000,0x0000,0x0000, /* 24E3 */
0x1453,0x0000,0x0000,0x0000,0x0000, /* 24E4 */
0x147B,0x0000,0x0000,0x0000,0x0000, /* 24E5 */
0x148D,0x0000,0x0000,0x0000,0x0000, /* 24E6 */
0x1497,0x0000,0x0000,0x0000,0x0000, /* 24E7 */
0x149C,0x0000,0x0000,0x0000,0x0000, /* 24E8 */
0x14AD,0x0000,0x0000,0x0000,0x0000, /* 24E9 */
0x1205,0x0000,0x0000,0x0000,0x0000, /* 24EA */
0x1206,0x1206,0x0000,0x0000,0x0000, /* 24EB */
0x1206,0x1207,0x0000,0x0000,0x0000, /* 24EC */
0x1206,0x1208,0x0000,0x0000,0x0000, /* 24ED */
0x1206,0x1209,0x0000,0x0000,0x0000, /* 24EE */
0x1206,0x120A,0x0000,0x0000,0x0000, /* 24EF */
0x1206,0x120B,0x0000,0x0000,0x0000, /* 24F0 */
0x1206,0x120C,0x0000,0x0000,0x0000, /* 24F1 */
0x1206,0x120D,0x0000,0x0000,0x0000, /* 24F2 */
0x1206,0x120E,0x0000,0x0000,0x0000, /* 24F3 */
0x1207,0x1205,0x0000,0x0000,0x0000, /* 24F4 */
0x1206,0x0000,0x0000,0x0000,0x0000, /* 24F5 */
0x1207,0x0000,0x0000,0x0000,0x0000, /* 24F6 */
0x1208,0x0000,0x0000,0x0000,0x0000, /* 24F7 */
0x1209,0x0000,0x0000,0x0000,0x0000, /* 24F8 */
0x120A,0x0000,0x0000,0x0000,0x0000, /* 24F9 */
0x120B,0x0000,0x0000,0x0000,0x0000, /* 24FA */
0x120C,0x0000,0x0000,0x0000,0x0000, /* 24FB */
0x120D,0x0000,0x0000,0x0000,0x0000, /* 24FC */
0x120E,0x0000,0x0000,0x0000,0x0000, /* 24FD */
0x1206,0x1205,0x0000,0x0000,0x0000, /* 24FE */
0x1205,0x0000,0x0000,0x0000,0x0000  /* 24FF */
};

uint16 uca520_p025[]= { /* 2500 (2 weights per char) */
0x073E,0x0000, 0x073F,0x0000, 0x0740,0x0000, 0x0741,0x0000, /* 2500 */
0x0742,0x0000, 0x0743,0x0000, 0x0744,0x0000, 0x0745,0x0000, /* 2504 */
0x0746,0x0000, 0x0747,0x0000, 0x0748,0x0000, 0x0749,0x0000, /* 2508 */
0x074A,0x0000, 0x074B,0x0000, 0x074C,0x0000, 0x074D,0x0000, /* 250C */
0x074E,0x0000, 0x074F,0x0000, 0x0750,0x0000, 0x0751,0x0000, /* 2510 */
0x0752,0x0000, 0x0753,0x0000, 0x0754,0x0000, 0x0755,0x0000, /* 2514 */
0x0756,0x0000, 0x0757,0x0000, 0x0758,0x0000, 0x0759,0x0000, /* 2518 */
0x075A,0x0000, 0x075B,0x0000, 0x075C,0x0000, 0x075D,0x0000, /* 251C */
0x075E,0x0000, 0x075F,0x0000, 0x0760,0x0000, 0x0761,0x0000, /* 2520 */
0x0762,0x0000, 0x0763,0x0000, 0x0764,0x0000, 0x0765,0x0000, /* 2524 */
0x0766,0x0000, 0x0767,0x0000, 0x0768,0x0000, 0x0769,0x0000, /* 2528 */
0x076A,0x0000, 0x076B,0x0000, 0x076C,0x0000, 0x076D,0x0000, /* 252C */
0x076E,0x0000, 0x076F,0x0000, 0x0770,0x0000, 0x0771,0x0000, /* 2530 */
0x0772,0x0000, 0x0773,0x0000, 0x0774,0x0000, 0x0775,0x0000, /* 2534 */
0x0776,0x0000, 0x0777,0x0000, 0x0778,0x0000, 0x0779,0x0000, /* 2538 */
0x077A,0x0000, 0x077B,0x0000, 0x077C,0x0000, 0x077D,0x0000, /* 253C */
0x077E,0x0000, 0x077F,0x0000, 0x0780,0x0000, 0x0781,0x0000, /* 2540 */
0x0782,0x0000, 0x0783,0x0000, 0x0784,0x0000, 0x0785,0x0000, /* 2544 */
0x0786,0x0000, 0x0787,0x0000, 0x0788,0x0000, 0x0789,0x0000, /* 2548 */
0x078A,0x0000, 0x078B,0x0000, 0x078C,0x0000, 0x078D,0x0000, /* 254C */
0x078E,0x0000, 0x078F,0x0000, 0x0790,0x0000, 0x0791,0x0000, /* 2550 */
0x0792,0x0000, 0x0793,0x0000, 0x0794,0x0000, 0x0795,0x0000, /* 2554 */
0x0796,0x0000, 0x0797,0x0000, 0x0798,0x0000, 0x0799,0x0000, /* 2558 */
0x079A,0x0000, 0x079B,0x0000, 0x079C,0x0000, 0x079D,0x0000, /* 255C */
0x079E,0x0000, 0x079F,0x0000, 0x07A0,0x0000, 0x07A1,0x0000, /* 2560 */
0x07A2,0x0000, 0x07A3,0x0000, 0x07A4,0x0000, 0x07A5,0x0000, /* 2564 */
0x07A6,0x0000, 0x07A7,0x0000, 0x07A8,0x0000, 0x07A9,0x0000, /* 2568 */
0x07AA,0x0000, 0x07AB,0x0000, 0x07AC,0x0000, 0x07AD,0x0000, /* 256C */
0x07AE,0x0000, 0x07AF,0x0000, 0x07B0,0x0000, 0x07B1,0x0000, /* 2570 */
0x07B2,0x0000, 0x07B3,0x0000, 0x07B4,0x0000, 0x07B5,0x0000, /* 2574 */
0x07B6,0x0000, 0x07B7,0x0000, 0x07B8,0x0000, 0x07B9,0x0000, /* 2578 */
0x07BA,0x0000, 0x07BB,0x0000, 0x07BC,0x0000, 0x07BD,0x0000, /* 257C */
0x07BE,0x0000, 0x07BF,0x0000, 0x07C0,0x0000, 0x07C1,0x0000, /* 2580 */
0x07C2,0x0000, 0x07C3,0x0000, 0x07C4,0x0000, 0x07C5,0x0000, /* 2584 */
0x07C6,0x0000, 0x07C7,0x0000, 0x07C8,0x0000, 0x07C9,0x0000, /* 2588 */
0x07CA,0x0000, 0x07CB,0x0000, 0x07CC,0x0000, 0x07CD,0x0000, /* 258C */
0x07CE,0x0000, 0x07CF,0x0000, 0x07D0,0x0000, 0x07D1,0x0000, /* 2590 */
0x07D2,0x0000, 0x07D3,0x0000, 0x07D4,0x0000, 0x07D5,0x0000, /* 2594 */
0x07D6,0x0000, 0x07D7,0x0000, 0x07D8,0x0000, 0x07D9,0x0000, /* 2598 */
0x07DA,0x0000, 0x07DB,0x0000, 0x07DC,0x0000, 0x07DD,0x0000, /* 259C */
0x07DE,0x0000, 0x07DF,0x0000, 0x07E0,0x0000, 0x07E1,0x0000, /* 25A0 */
0x07E2,0x0000, 0x07E3,0x0000, 0x07E4,0x0000, 0x07E5,0x0000, /* 25A4 */
0x07E6,0x0000, 0x07E7,0x0000, 0x07E8,0x0000, 0x07E9,0x0000, /* 25A8 */
0x07EA,0x0000, 0x07EB,0x0000, 0x07EC,0x0000, 0x07ED,0x0000, /* 25AC */
0x07EE,0x0000, 0x07EF,0x0000, 0x07F0,0x0000, 0x07F1,0x0000, /* 25B0 */
0x07F2,0x0000, 0x07F3,0x0000, 0x07F4,0x0000, 0x07F5,0x0000, /* 25B4 */
0x07F6,0x0000, 0x07F7,0x0000, 0x07F8,0x0000, 0x07F9,0x0000, /* 25B8 */
0x07FA,0x0000, 0x07FB,0x0000, 0x07FC,0x0000, 0x07FD,0x0000, /* 25BC */
0x07FE,0x0000, 0x07FF,0x0000, 0x0800,0x0000, 0x0801,0x0000, /* 25C0 */
0x0802,0x0000, 0x0803,0x0000, 0x0804,0x0000, 0x0805,0x0000, /* 25C4 */
0x0806,0x0000, 0x0807,0x0000, 0x0808,0x0000, 0x0809,0x0000, /* 25C8 */
0x080A,0x0000, 0x080B,0x0000, 0x080C,0x0000, 0x080D,0x0000, /* 25CC */
0x080E,0x0000, 0x080F,0x0000, 0x0810,0x0000, 0x0811,0x0000, /* 25D0 */
0x0812,0x0000, 0x0813,0x0000, 0x0814,0x0000, 0x0815,0x0000, /* 25D4 */
0x0816,0x0000, 0x0817,0x0000, 0x0818,0x0000, 0x0819,0x0000, /* 25D8 */
0x081A,0x0000, 0x081B,0x0000, 0x081C,0x0000, 0x081D,0x0000, /* 25DC */
0x081E,0x0000, 0x081F,0x0000, 0x0820,0x0000, 0x0821,0x0000, /* 25E0 */
0x0822,0x0000, 0x0823,0x0000, 0x0824,0x0000, 0x0825,0x0000, /* 25E4 */
0x0826,0x0000, 0x0827,0x0000, 0x0828,0x0000, 0x0829,0x0000, /* 25E8 */
0x082A,0x0000, 0x082B,0x0000, 0x082C,0x0000, 0x082D,0x0000, /* 25EC */
0x082E,0x0000, 0x082F,0x0000, 0x0830,0x0000, 0x0831,0x0000, /* 25F0 */
0x0832,0x0000, 0x0833,0x0000, 0x0834,0x0000, 0x0835,0x0000, /* 25F4 */
0x0836,0x0000, 0x0837,0x0000, 0x0838,0x0000, 0x0839,0x0000, /* 25F8 */
0x083A,0x0000, 0x083B,0x0000, 0x083C,0x0000, 0x083D,0x0000  /* 25FC */
};

uint16 uca520_p026[]= { /* 2600 (3 weights per char) */
0x083E,0x0000,0x0000, 0x083F,0x0000,0x0000, 0x0840,0x0000,0x0000, /* 2600 */
0x0841,0x0000,0x0000, 0x0842,0x0000,0x0000, 0x0843,0x0000,0x0000, /* 2603 */
0x0844,0x0000,0x0000, 0x0845,0x0000,0x0000, 0x0846,0x0000,0x0000, /* 2606 */
0x0847,0x0000,0x0000, 0x0848,0x0000,0x0000, 0x0849,0x0000,0x0000, /* 2609 */
0x084A,0x0000,0x0000, 0x084B,0x0000,0x0000, 0x084C,0x0000,0x0000, /* 260C */
0x084D,0x0000,0x0000, 0x084E,0x0000,0x0000, 0x084F,0x0000,0x0000, /* 260F */
0x0850,0x0000,0x0000, 0x0851,0x0000,0x0000, 0x0852,0x0000,0x0000, /* 2612 */
0x0853,0x0000,0x0000, 0x0854,0x0000,0x0000, 0x0855,0x0000,0x0000, /* 2615 */
0x0856,0x0000,0x0000, 0x0857,0x0000,0x0000, 0x0858,0x0000,0x0000, /* 2618 */
0x0859,0x0000,0x0000, 0x085A,0x0000,0x0000, 0x085B,0x0000,0x0000, /* 261B */
0x085C,0x0000,0x0000, 0x085D,0x0000,0x0000, 0x085E,0x0000,0x0000, /* 261E */
0x085F,0x0000,0x0000, 0x0860,0x0000,0x0000, 0x0861,0x0000,0x0000, /* 2621 */
0x0862,0x0000,0x0000, 0x0863,0x0000,0x0000, 0x0864,0x0000,0x0000, /* 2624 */
0x0865,0x0000,0x0000, 0x0866,0x0000,0x0000, 0x0867,0x0000,0x0000, /* 2627 */
0x0868,0x0000,0x0000, 0x0869,0x0000,0x0000, 0x086A,0x0000,0x0000, /* 262A */
0x086B,0x0000,0x0000, 0x086C,0x0000,0x0000, 0x086D,0x0000,0x0000, /* 262D */
0x0D36,0x0000,0x0000, 0x0D37,0x0000,0x0000, 0x0D38,0x0000,0x0000, /* 2630 */
0x0D39,0x0000,0x0000, 0x0D3A,0x0000,0x0000, 0x0D3B,0x0000,0x0000, /* 2633 */
0x0D3C,0x0000,0x0000, 0x0D3D,0x0000,0x0000, 0x086E,0x0000,0x0000, /* 2636 */
0x086F,0x0000,0x0000, 0x0870,0x0000,0x0000, 0x0871,0x0000,0x0000, /* 2639 */
0x0872,0x0000,0x0000, 0x0873,0x0000,0x0000, 0x0874,0x0000,0x0000, /* 263C */
0x0875,0x0000,0x0000, 0x0876,0x0000,0x0000, 0x0877,0x0000,0x0000, /* 263F */
0x0878,0x0000,0x0000, 0x0879,0x0000,0x0000, 0x087A,0x0000,0x0000, /* 2642 */
0x087B,0x0000,0x0000, 0x087C,0x0000,0x0000, 0x087D,0x0000,0x0000, /* 2645 */
0x087E,0x0000,0x0000, 0x087F,0x0000,0x0000, 0x0880,0x0000,0x0000, /* 2648 */
0x0881,0x0000,0x0000, 0x0882,0x0000,0x0000, 0x0883,0x0000,0x0000, /* 264B */
0x0884,0x0000,0x0000, 0x0885,0x0000,0x0000, 0x0886,0x0000,0x0000, /* 264E */
0x0887,0x0000,0x0000, 0x0888,0x0000,0x0000, 0x0889,0x0000,0x0000, /* 2651 */
0x088A,0x0000,0x0000, 0x088B,0x0000,0x0000, 0x088C,0x0000,0x0000, /* 2654 */
0x088D,0x0000,0x0000, 0x088E,0x0000,0x0000, 0x088F,0x0000,0x0000, /* 2657 */
0x0890,0x0000,0x0000, 0x0891,0x0000,0x0000, 0x0892,0x0000,0x0000, /* 265A */
0x0893,0x0000,0x0000, 0x0894,0x0000,0x0000, 0x0895,0x0000,0x0000, /* 265D */
0x0896,0x0000,0x0000, 0x0897,0x0000,0x0000, 0x0898,0x0000,0x0000, /* 2660 */
0x0899,0x0000,0x0000, 0x089A,0x0000,0x0000, 0x089B,0x0000,0x0000, /* 2663 */
0x089C,0x0000,0x0000, 0x089D,0x0000,0x0000, 0x089E,0x0000,0x0000, /* 2666 */
0x089F,0x0000,0x0000, 0x08A0,0x0000,0x0000, 0x08A1,0x0000,0x0000, /* 2669 */
0x08A2,0x0000,0x0000, 0x0F7C,0x0000,0x0000, 0x0F7D,0x0000,0x0000, /* 266C */
0x0F7E,0x0000,0x0000, 0x08A3,0x0000,0x0000, 0x08A4,0x0000,0x0000, /* 266F */
0x08A5,0x0000,0x0000, 0x08A6,0x0000,0x0000, 0x08A7,0x0000,0x0000, /* 2672 */
0x08A8,0x0000,0x0000, 0x08A9,0x0000,0x0000, 0x08AA,0x0000,0x0000, /* 2675 */
0x08AB,0x0000,0x0000, 0x08AC,0x0000,0x0000, 0x08AD,0x0000,0x0000, /* 2678 */
0x08AE,0x0000,0x0000, 0x08AF,0x0000,0x0000, 0x08B0,0x0000,0x0000, /* 267B */
0x08B1,0x0000,0x0000, 0x08B2,0x0000,0x0000, 0x08B3,0x0000,0x0000, /* 267E */
0x08B4,0x0000,0x0000, 0x08B5,0x0000,0x0000, 0x08B6,0x0000,0x0000, /* 2681 */
0x08B7,0x0000,0x0000, 0x08B8,0x0000,0x0000, 0x08B9,0x0000,0x0000, /* 2684 */
0x08BA,0x0000,0x0000, 0x08BB,0x0000,0x0000, 0x08BC,0x0000,0x0000, /* 2687 */
0x0D30,0x0000,0x0000, 0x0D31,0x0000,0x0000, 0x0D32,0x0000,0x0000, /* 268A */
0x0D33,0x0000,0x0000, 0x0D34,0x0000,0x0000, 0x0D35,0x0000,0x0000, /* 268D */
0x08BD,0x0000,0x0000, 0x08BE,0x0000,0x0000, 0x08BF,0x0000,0x0000, /* 2690 */
0x08C0,0x0000,0x0000, 0x08C1,0x0000,0x0000, 0x08C2,0x0000,0x0000, /* 2693 */
0x08C3,0x0000,0x0000, 0x08C4,0x0000,0x0000, 0x08C5,0x0000,0x0000, /* 2696 */
0x08C6,0x0000,0x0000, 0x08C7,0x0000,0x0000, 0x08C8,0x0000,0x0000, /* 2699 */
0x08C9,0x0000,0x0000, 0x08CA,0x0000,0x0000, 0x08CB,0x0000,0x0000, /* 269C */
0x08CC,0x0000,0x0000, 0x08CD,0x0000,0x0000, 0x08CE,0x0000,0x0000, /* 269F */
0x08CF,0x0000,0x0000, 0x08D0,0x0000,0x0000, 0x08D1,0x0000,0x0000, /* 26A2 */
0x08D2,0x0000,0x0000, 0x08D3,0x0000,0x0000, 0x08D4,0x0000,0x0000, /* 26A5 */
0x08D5,0x0000,0x0000, 0x08D6,0x0000,0x0000, 0x08D7,0x0000,0x0000, /* 26A8 */
0x08D8,0x0000,0x0000, 0x08D9,0x0000,0x0000, 0x08DA,0x0000,0x0000, /* 26AB */
0x08DB,0x0000,0x0000, 0x08DC,0x0000,0x0000, 0x08DD,0x0000,0x0000, /* 26AE */
0x08DE,0x0000,0x0000, 0x08DF,0x0000,0x0000, 0x08E0,0x0000,0x0000, /* 26B1 */
0x08E1,0x0000,0x0000, 0x08E2,0x0000,0x0000, 0x08E3,0x0000,0x0000, /* 26B4 */
0x08E4,0x0000,0x0000, 0x08E5,0x0000,0x0000, 0x08E6,0x0000,0x0000, /* 26B7 */
0x08E7,0x0000,0x0000, 0x08E8,0x0000,0x0000, 0x08E9,0x0000,0x0000, /* 26BA */
0x08EA,0x0000,0x0000, 0x08EB,0x0000,0x0000, 0x08EC,0x0000,0x0000, /* 26BD */
0x08ED,0x0000,0x0000, 0x08EE,0x0000,0x0000, 0x08EF,0x0000,0x0000, /* 26C0 */
0x08F0,0x0000,0x0000, 0x08F1,0x0000,0x0000, 0x08F2,0x0000,0x0000, /* 26C3 */
0x08F3,0x0000,0x0000, 0x08F4,0x0000,0x0000, 0x08F5,0x0000,0x0000, /* 26C6 */
0x08F6,0x0000,0x0000, 0x08F7,0x0000,0x0000, 0x08F8,0x0000,0x0000, /* 26C9 */
0x08F9,0x0000,0x0000, 0x08FA,0x0000,0x0000, 0xFBC0,0xA6CE,0x0000, /* 26CC */
0x08FB,0x0000,0x0000, 0x08FC,0x0000,0x0000, 0x08FD,0x0000,0x0000, /* 26CF */
0x08FE,0x0000,0x0000, 0x08FF,0x0000,0x0000, 0x0900,0x0000,0x0000, /* 26D2 */
0x0901,0x0000,0x0000, 0x0902,0x0000,0x0000, 0x0903,0x0000,0x0000, /* 26D5 */
0x0904,0x0000,0x0000, 0x0905,0x0000,0x0000, 0x0906,0x0000,0x0000, /* 26D8 */
0x0907,0x0000,0x0000, 0x0908,0x0000,0x0000, 0x0909,0x0000,0x0000, /* 26DB */
0x090A,0x0000,0x0000, 0x090B,0x0000,0x0000, 0x090C,0x0000,0x0000, /* 26DE */
0x090D,0x0000,0x0000, 0xFBC0,0xA6E2,0x0000, 0x090E,0x0000,0x0000, /* 26E1 */
0xFBC0,0xA6E4,0x0000, 0xFBC0,0xA6E5,0x0000, 0xFBC0,0xA6E6,0x0000, /* 26E4 */
0xFBC0,0xA6E7,0x0000, 0x090F,0x0000,0x0000, 0x0910,0x0000,0x0000, /* 26E7 */
0x0911,0x0000,0x0000, 0x0912,0x0000,0x0000, 0x0913,0x0000,0x0000, /* 26EA */
0x0914,0x0000,0x0000, 0x0915,0x0000,0x0000, 0x0916,0x0000,0x0000, /* 26ED */
0x0917,0x0000,0x0000, 0x0918,0x0000,0x0000, 0x0919,0x0000,0x0000, /* 26F0 */
0x091A,0x0000,0x0000, 0x091B,0x0000,0x0000, 0x091C,0x0000,0x0000, /* 26F3 */
0x091D,0x0000,0x0000, 0x091E,0x0000,0x0000, 0x091F,0x0000,0x0000, /* 26F6 */
0x0920,0x0000,0x0000, 0x0921,0x0000,0x0000, 0x0922,0x0000,0x0000, /* 26F9 */
0x0923,0x0000,0x0000, 0x0924,0x0000,0x0000, 0x0925,0x0000,0x0000, /* 26FC */
0x0926,0x0000,0x0000  };

uint16 uca520_p027[]= { /* 2700 (3 weights per char) */
0xFBC0,0xA700,0x0000, 0x0927,0x0000,0x0000, 0x0928,0x0000,0x0000, /* 2700 */
0x0929,0x0000,0x0000, 0x092A,0x0000,0x0000, 0xFBC0,0xA705,0x0000, /* 2703 */
0x092B,0x0000,0x0000, 0x092C,0x0000,0x0000, 0x092D,0x0000,0x0000, /* 2706 */
0x092E,0x0000,0x0000, 0xFBC0,0xA70A,0x0000, 0xFBC0,0xA70B,0x0000, /* 2709 */
0x092F,0x0000,0x0000, 0x0930,0x0000,0x0000, 0x0931,0x0000,0x0000, /* 270C */
0x0932,0x0000,0x0000, 0x0933,0x0000,0x0000, 0x0934,0x0000,0x0000, /* 270F */
0x0935,0x0000,0x0000, 0x0936,0x0000,0x0000, 0x0937,0x0000,0x0000, /* 2712 */
0x0938,0x0000,0x0000, 0x0939,0x0000,0x0000, 0x093A,0x0000,0x0000, /* 2715 */
0x093B,0x0000,0x0000, 0x093C,0x0000,0x0000, 0x093D,0x0000,0x0000, /* 2718 */
0x093E,0x0000,0x0000, 0x093F,0x0000,0x0000, 0x0940,0x0000,0x0000, /* 271B */
0x0941,0x0000,0x0000, 0x0942,0x0000,0x0000, 0x0943,0x0000,0x0000, /* 271E */
0x0944,0x0000,0x0000, 0x0945,0x0000,0x0000, 0x0946,0x0000,0x0000, /* 2721 */
0x0947,0x0000,0x0000, 0x0948,0x0000,0x0000, 0x0949,0x0000,0x0000, /* 2724 */
0x094A,0x0000,0x0000, 0xFBC0,0xA728,0x0000, 0x094B,0x0000,0x0000, /* 2727 */
0x094C,0x0000,0x0000, 0x094D,0x0000,0x0000, 0x094E,0x0000,0x0000, /* 272A */
0x094F,0x0000,0x0000, 0x0950,0x0000,0x0000, 0x0951,0x0000,0x0000, /* 272D */
0x0952,0x0000,0x0000, 0x0953,0x0000,0x0000, 0x0954,0x0000,0x0000, /* 2730 */
0x0955,0x0000,0x0000, 0x0956,0x0000,0x0000, 0x0957,0x0000,0x0000, /* 2733 */
0x0958,0x0000,0x0000, 0x0959,0x0000,0x0000, 0x095A,0x0000,0x0000, /* 2736 */
0x095B,0x0000,0x0000, 0x095C,0x0000,0x0000, 0x095D,0x0000,0x0000, /* 2739 */
0x095E,0x0000,0x0000, 0x095F,0x0000,0x0000, 0x0960,0x0000,0x0000, /* 273C */
0x0961,0x0000,0x0000, 0x0962,0x0000,0x0000, 0x0963,0x0000,0x0000, /* 273F */
0x0964,0x0000,0x0000, 0x0965,0x0000,0x0000, 0x0966,0x0000,0x0000, /* 2742 */
0x0967,0x0000,0x0000, 0x0968,0x0000,0x0000, 0x0969,0x0000,0x0000, /* 2745 */
0x096A,0x0000,0x0000, 0x096B,0x0000,0x0000, 0x096C,0x0000,0x0000, /* 2748 */
0x096D,0x0000,0x0000, 0xFBC0,0xA74C,0x0000, 0x096E,0x0000,0x0000, /* 274B */
0xFBC0,0xA74E,0x0000, 0x096F,0x0000,0x0000, 0x0970,0x0000,0x0000, /* 274E */
0x0971,0x0000,0x0000, 0x0972,0x0000,0x0000, 0xFBC0,0xA753,0x0000, /* 2751 */
0xFBC0,0xA754,0x0000, 0xFBC0,0xA755,0x0000, 0x0973,0x0000,0x0000, /* 2754 */
0x0974,0x0000,0x0000, 0x0975,0x0000,0x0000, 0x0976,0x0000,0x0000, /* 2757 */
0x0977,0x0000,0x0000, 0x0978,0x0000,0x0000, 0x0979,0x0000,0x0000, /* 275A */
0x097A,0x0000,0x0000, 0x097B,0x0000,0x0000, 0xFBC0,0xA75F,0x0000, /* 275D */
0xFBC0,0xA760,0x0000, 0x097C,0x0000,0x0000, 0x097D,0x0000,0x0000, /* 2760 */
0x097E,0x0000,0x0000, 0x097F,0x0000,0x0000, 0x0980,0x0000,0x0000, /* 2763 */
0x0981,0x0000,0x0000, 0x0982,0x0000,0x0000, 0x0983,0x0000,0x0000, /* 2766 */
0x0984,0x0000,0x0000, 0x0985,0x0000,0x0000, 0x0986,0x0000,0x0000, /* 2769 */
0x0987,0x0000,0x0000, 0x0988,0x0000,0x0000, 0x0989,0x0000,0x0000, /* 276C */
0x098A,0x0000,0x0000, 0x098B,0x0000,0x0000, 0x098C,0x0000,0x0000, /* 276F */
0x098D,0x0000,0x0000, 0x098E,0x0000,0x0000, 0x098F,0x0000,0x0000, /* 2772 */
0x0990,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 2775 */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, /* 2778 */
0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, /* 277B */
0x120E,0x0000,0x0000, 0x1206,0x1205,0x0000, 0x1206,0x0000,0x0000, /* 277E */
0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, /* 2781 */
0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, /* 2784 */
0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, 0x1206,0x1205,0x0000, /* 2787 */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 278A */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 278D */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 2790 */
0x1206,0x1205,0x0000, 0x0991,0x0000,0x0000, 0xFBC0,0xA795,0x0000, /* 2793 */
0xFBC0,0xA796,0x0000, 0xFBC0,0xA797,0x0000, 0x0992,0x0000,0x0000, /* 2796 */
0x0993,0x0000,0x0000, 0x0994,0x0000,0x0000, 0x0995,0x0000,0x0000, /* 2799 */
0x0996,0x0000,0x0000, 0x0997,0x0000,0x0000, 0x0998,0x0000,0x0000, /* 279C */
0x0999,0x0000,0x0000, 0x099A,0x0000,0x0000, 0x099B,0x0000,0x0000, /* 279F */
0x099C,0x0000,0x0000, 0x099D,0x0000,0x0000, 0x099E,0x0000,0x0000, /* 27A2 */
0x099F,0x0000,0x0000, 0x09A0,0x0000,0x0000, 0x09A1,0x0000,0x0000, /* 27A5 */
0x09A2,0x0000,0x0000, 0x09A3,0x0000,0x0000, 0x09A4,0x0000,0x0000, /* 27A8 */
0x09A5,0x0000,0x0000, 0x09A6,0x0000,0x0000, 0x09A7,0x0000,0x0000, /* 27AB */
0x09A8,0x0000,0x0000, 0x09A9,0x0000,0x0000, 0xFBC0,0xA7B0,0x0000, /* 27AE */
0x09AA,0x0000,0x0000, 0x09AB,0x0000,0x0000, 0x09AC,0x0000,0x0000, /* 27B1 */
0x09AD,0x0000,0x0000, 0x09AE,0x0000,0x0000, 0x09AF,0x0000,0x0000, /* 27B4 */
0x09B0,0x0000,0x0000, 0x09B1,0x0000,0x0000, 0x09B2,0x0000,0x0000, /* 27B7 */
0x09B3,0x0000,0x0000, 0x09B4,0x0000,0x0000, 0x09B5,0x0000,0x0000, /* 27BA */
0x09B6,0x0000,0x0000, 0x09B7,0x0000,0x0000, 0xFBC0,0xA7BF,0x0000, /* 27BD */
0x09B8,0x0000,0x0000, 0x09B9,0x0000,0x0000, 0x09BA,0x0000,0x0000, /* 27C0 */
0x09BB,0x0000,0x0000, 0x09BC,0x0000,0x0000, 0x09BD,0x0000,0x0000, /* 27C3 */
0x09BE,0x0000,0x0000, 0x09BF,0x0000,0x0000, 0x09C0,0x0000,0x0000, /* 27C6 */
0x09C1,0x0000,0x0000, 0x09C2,0x0000,0x0000, 0xFBC0,0xA7CB,0x0000, /* 27C9 */
0x09C3,0x0000,0x0000, 0xFBC0,0xA7CD,0x0000, 0xFBC0,0xA7CE,0x0000, /* 27CC */
0xFBC0,0xA7CF,0x0000, 0x09C4,0x0000,0x0000, 0x09C5,0x0000,0x0000, /* 27CF */
0x09C6,0x0000,0x0000, 0x09C7,0x0000,0x0000, 0x09C8,0x0000,0x0000, /* 27D2 */
0x09C9,0x0000,0x0000, 0x09CA,0x0000,0x0000, 0x09CB,0x0000,0x0000, /* 27D5 */
0x09CC,0x0000,0x0000, 0x09CD,0x0000,0x0000, 0x09CE,0x0000,0x0000, /* 27D8 */
0x09CF,0x0000,0x0000, 0x09D0,0x0000,0x0000, 0x09D1,0x0000,0x0000, /* 27DB */
0x09D2,0x0000,0x0000, 0x09D3,0x0000,0x0000, 0x09D4,0x0000,0x0000, /* 27DE */
0x09D5,0x0000,0x0000, 0x09D6,0x0000,0x0000, 0x09D7,0x0000,0x0000, /* 27E1 */
0x09D8,0x0000,0x0000, 0x09D9,0x0000,0x0000, 0x09DA,0x0000,0x0000, /* 27E4 */
0x09DB,0x0000,0x0000, 0x09DC,0x0000,0x0000, 0x09DD,0x0000,0x0000, /* 27E7 */
0x09DE,0x0000,0x0000, 0x09DF,0x0000,0x0000, 0x0325,0x0000,0x0000, /* 27EA */
0x0326,0x0000,0x0000, 0x0327,0x0000,0x0000, 0x0328,0x0000,0x0000, /* 27ED */
0x09E0,0x0000,0x0000, 0x09E1,0x0000,0x0000, 0x09E2,0x0000,0x0000, /* 27F0 */
0x09E3,0x0000,0x0000, 0x09E4,0x0000,0x0000, 0x09E5,0x0000,0x0000, /* 27F3 */
0x09E6,0x0000,0x0000, 0x09E7,0x0000,0x0000, 0x09E8,0x0000,0x0000, /* 27F6 */
0x09E9,0x0000,0x0000, 0x09EA,0x0000,0x0000, 0x09EB,0x0000,0x0000, /* 27F9 */
0x09EC,0x0000,0x0000, 0x09ED,0x0000,0x0000, 0x09EE,0x0000,0x0000, /* 27FC */
0x09EF,0x0000,0x0000  };

uint16 uca520_p028[]= { /* 2800 (2 weights per char) */
0x0C30,0x0000, 0x0C31,0x0000, 0x0C32,0x0000, 0x0C33,0x0000, /* 2800 */
0x0C34,0x0000, 0x0C35,0x0000, 0x0C36,0x0000, 0x0C37,0x0000, /* 2804 */
0x0C38,0x0000, 0x0C39,0x0000, 0x0C3A,0x0000, 0x0C3B,0x0000, /* 2808 */
0x0C3C,0x0000, 0x0C3D,0x0000, 0x0C3E,0x0000, 0x0C3F,0x0000, /* 280C */
0x0C40,0x0000, 0x0C41,0x0000, 0x0C42,0x0000, 0x0C43,0x0000, /* 2810 */
0x0C44,0x0000, 0x0C45,0x0000, 0x0C46,0x0000, 0x0C47,0x0000, /* 2814 */
0x0C48,0x0000, 0x0C49,0x0000, 0x0C4A,0x0000, 0x0C4B,0x0000, /* 2818 */
0x0C4C,0x0000, 0x0C4D,0x0000, 0x0C4E,0x0000, 0x0C4F,0x0000, /* 281C */
0x0C50,0x0000, 0x0C51,0x0000, 0x0C52,0x0000, 0x0C53,0x0000, /* 2820 */
0x0C54,0x0000, 0x0C55,0x0000, 0x0C56,0x0000, 0x0C57,0x0000, /* 2824 */
0x0C58,0x0000, 0x0C59,0x0000, 0x0C5A,0x0000, 0x0C5B,0x0000, /* 2828 */
0x0C5C,0x0000, 0x0C5D,0x0000, 0x0C5E,0x0000, 0x0C5F,0x0000, /* 282C */
0x0C60,0x0000, 0x0C61,0x0000, 0x0C62,0x0000, 0x0C63,0x0000, /* 2830 */
0x0C64,0x0000, 0x0C65,0x0000, 0x0C66,0x0000, 0x0C67,0x0000, /* 2834 */
0x0C68,0x0000, 0x0C69,0x0000, 0x0C6A,0x0000, 0x0C6B,0x0000, /* 2838 */
0x0C6C,0x0000, 0x0C6D,0x0000, 0x0C6E,0x0000, 0x0C6F,0x0000, /* 283C */
0x0C70,0x0000, 0x0C71,0x0000, 0x0C72,0x0000, 0x0C73,0x0000, /* 2840 */
0x0C74,0x0000, 0x0C75,0x0000, 0x0C76,0x0000, 0x0C77,0x0000, /* 2844 */
0x0C78,0x0000, 0x0C79,0x0000, 0x0C7A,0x0000, 0x0C7B,0x0000, /* 2848 */
0x0C7C,0x0000, 0x0C7D,0x0000, 0x0C7E,0x0000, 0x0C7F,0x0000, /* 284C */
0x0C80,0x0000, 0x0C81,0x0000, 0x0C82,0x0000, 0x0C83,0x0000, /* 2850 */
0x0C84,0x0000, 0x0C85,0x0000, 0x0C86,0x0000, 0x0C87,0x0000, /* 2854 */
0x0C88,0x0000, 0x0C89,0x0000, 0x0C8A,0x0000, 0x0C8B,0x0000, /* 2858 */
0x0C8C,0x0000, 0x0C8D,0x0000, 0x0C8E,0x0000, 0x0C8F,0x0000, /* 285C */
0x0C90,0x0000, 0x0C91,0x0000, 0x0C92,0x0000, 0x0C93,0x0000, /* 2860 */
0x0C94,0x0000, 0x0C95,0x0000, 0x0C96,0x0000, 0x0C97,0x0000, /* 2864 */
0x0C98,0x0000, 0x0C99,0x0000, 0x0C9A,0x0000, 0x0C9B,0x0000, /* 2868 */
0x0C9C,0x0000, 0x0C9D,0x0000, 0x0C9E,0x0000, 0x0C9F,0x0000, /* 286C */
0x0CA0,0x0000, 0x0CA1,0x0000, 0x0CA2,0x0000, 0x0CA3,0x0000, /* 2870 */
0x0CA4,0x0000, 0x0CA5,0x0000, 0x0CA6,0x0000, 0x0CA7,0x0000, /* 2874 */
0x0CA8,0x0000, 0x0CA9,0x0000, 0x0CAA,0x0000, 0x0CAB,0x0000, /* 2878 */
0x0CAC,0x0000, 0x0CAD,0x0000, 0x0CAE,0x0000, 0x0CAF,0x0000, /* 287C */
0x0CB0,0x0000, 0x0CB1,0x0000, 0x0CB2,0x0000, 0x0CB3,0x0000, /* 2880 */
0x0CB4,0x0000, 0x0CB5,0x0000, 0x0CB6,0x0000, 0x0CB7,0x0000, /* 2884 */
0x0CB8,0x0000, 0x0CB9,0x0000, 0x0CBA,0x0000, 0x0CBB,0x0000, /* 2888 */
0x0CBC,0x0000, 0x0CBD,0x0000, 0x0CBE,0x0000, 0x0CBF,0x0000, /* 288C */
0x0CC0,0x0000, 0x0CC1,0x0000, 0x0CC2,0x0000, 0x0CC3,0x0000, /* 2890 */
0x0CC4,0x0000, 0x0CC5,0x0000, 0x0CC6,0x0000, 0x0CC7,0x0000, /* 2894 */
0x0CC8,0x0000, 0x0CC9,0x0000, 0x0CCA,0x0000, 0x0CCB,0x0000, /* 2898 */
0x0CCC,0x0000, 0x0CCD,0x0000, 0x0CCE,0x0000, 0x0CCF,0x0000, /* 289C */
0x0CD0,0x0000, 0x0CD1,0x0000, 0x0CD2,0x0000, 0x0CD3,0x0000, /* 28A0 */
0x0CD4,0x0000, 0x0CD5,0x0000, 0x0CD6,0x0000, 0x0CD7,0x0000, /* 28A4 */
0x0CD8,0x0000, 0x0CD9,0x0000, 0x0CDA,0x0000, 0x0CDB,0x0000, /* 28A8 */
0x0CDC,0x0000, 0x0CDD,0x0000, 0x0CDE,0x0000, 0x0CDF,0x0000, /* 28AC */
0x0CE0,0x0000, 0x0CE1,0x0000, 0x0CE2,0x0000, 0x0CE3,0x0000, /* 28B0 */
0x0CE4,0x0000, 0x0CE5,0x0000, 0x0CE6,0x0000, 0x0CE7,0x0000, /* 28B4 */
0x0CE8,0x0000, 0x0CE9,0x0000, 0x0CEA,0x0000, 0x0CEB,0x0000, /* 28B8 */
0x0CEC,0x0000, 0x0CED,0x0000, 0x0CEE,0x0000, 0x0CEF,0x0000, /* 28BC */
0x0CF0,0x0000, 0x0CF1,0x0000, 0x0CF2,0x0000, 0x0CF3,0x0000, /* 28C0 */
0x0CF4,0x0000, 0x0CF5,0x0000, 0x0CF6,0x0000, 0x0CF7,0x0000, /* 28C4 */
0x0CF8,0x0000, 0x0CF9,0x0000, 0x0CFA,0x0000, 0x0CFB,0x0000, /* 28C8 */
0x0CFC,0x0000, 0x0CFD,0x0000, 0x0CFE,0x0000, 0x0CFF,0x0000, /* 28CC */
0x0D00,0x0000, 0x0D01,0x0000, 0x0D02,0x0000, 0x0D03,0x0000, /* 28D0 */
0x0D04,0x0000, 0x0D05,0x0000, 0x0D06,0x0000, 0x0D07,0x0000, /* 28D4 */
0x0D08,0x0000, 0x0D09,0x0000, 0x0D0A,0x0000, 0x0D0B,0x0000, /* 28D8 */
0x0D0C,0x0000, 0x0D0D,0x0000, 0x0D0E,0x0000, 0x0D0F,0x0000, /* 28DC */
0x0D10,0x0000, 0x0D11,0x0000, 0x0D12,0x0000, 0x0D13,0x0000, /* 28E0 */
0x0D14,0x0000, 0x0D15,0x0000, 0x0D16,0x0000, 0x0D17,0x0000, /* 28E4 */
0x0D18,0x0000, 0x0D19,0x0000, 0x0D1A,0x0000, 0x0D1B,0x0000, /* 28E8 */
0x0D1C,0x0000, 0x0D1D,0x0000, 0x0D1E,0x0000, 0x0D1F,0x0000, /* 28EC */
0x0D20,0x0000, 0x0D21,0x0000, 0x0D22,0x0000, 0x0D23,0x0000, /* 28F0 */
0x0D24,0x0000, 0x0D25,0x0000, 0x0D26,0x0000, 0x0D27,0x0000, /* 28F4 */
0x0D28,0x0000, 0x0D29,0x0000, 0x0D2A,0x0000, 0x0D2B,0x0000, /* 28F8 */
0x0D2C,0x0000, 0x0D2D,0x0000, 0x0D2E,0x0000, 0x0D2F,0x0000  /* 28FC */
};

uint16 uca520_p029[]= { /* 2900 (2 weights per char) */
0x09F0,0x0000, 0x09F1,0x0000, 0x09F2,0x0000, 0x09F3,0x0000, /* 2900 */
0x09F4,0x0000, 0x09F5,0x0000, 0x09F6,0x0000, 0x09F7,0x0000, /* 2904 */
0x09F8,0x0000, 0x09F9,0x0000, 0x09FA,0x0000, 0x09FB,0x0000, /* 2908 */
0x09FC,0x0000, 0x09FD,0x0000, 0x09FE,0x0000, 0x09FF,0x0000, /* 290C */
0x0A00,0x0000, 0x0A01,0x0000, 0x0A02,0x0000, 0x0A03,0x0000, /* 2910 */
0x0A04,0x0000, 0x0A05,0x0000, 0x0A06,0x0000, 0x0A07,0x0000, /* 2914 */
0x0A08,0x0000, 0x0A09,0x0000, 0x0A0A,0x0000, 0x0A0B,0x0000, /* 2918 */
0x0A0C,0x0000, 0x0A0D,0x0000, 0x0A0E,0x0000, 0x0A0F,0x0000, /* 291C */
0x0A10,0x0000, 0x0A11,0x0000, 0x0A12,0x0000, 0x0A13,0x0000, /* 2920 */
0x0A14,0x0000, 0x0A15,0x0000, 0x0A16,0x0000, 0x0A17,0x0000, /* 2924 */
0x0A18,0x0000, 0x0A19,0x0000, 0x0A1A,0x0000, 0x0A1B,0x0000, /* 2928 */
0x0A1C,0x0000, 0x0A1D,0x0000, 0x0A1E,0x0000, 0x0A1F,0x0000, /* 292C */
0x0A20,0x0000, 0x0A21,0x0000, 0x0A22,0x0000, 0x0A23,0x0000, /* 2930 */
0x0A24,0x0000, 0x0A25,0x0000, 0x0A26,0x0000, 0x0A27,0x0000, /* 2934 */
0x0A28,0x0000, 0x0A29,0x0000, 0x0A2A,0x0000, 0x0A2B,0x0000, /* 2938 */
0x0A2C,0x0000, 0x0A2D,0x0000, 0x0A2E,0x0000, 0x0A2F,0x0000, /* 293C */
0x0A30,0x0000, 0x0A31,0x0000, 0x0A32,0x0000, 0x0A33,0x0000, /* 2940 */
0x0A34,0x0000, 0x0A35,0x0000, 0x0A36,0x0000, 0x0A37,0x0000, /* 2944 */
0x0A38,0x0000, 0x0A39,0x0000, 0x0A3A,0x0000, 0x0A3B,0x0000, /* 2948 */
0x0A3C,0x0000, 0x0A3D,0x0000, 0x0A3E,0x0000, 0x0A3F,0x0000, /* 294C */
0x0A40,0x0000, 0x0A41,0x0000, 0x0A42,0x0000, 0x0A43,0x0000, /* 2950 */
0x0A44,0x0000, 0x0A45,0x0000, 0x0A46,0x0000, 0x0A47,0x0000, /* 2954 */
0x0A48,0x0000, 0x0A49,0x0000, 0x0A4A,0x0000, 0x0A4B,0x0000, /* 2958 */
0x0A4C,0x0000, 0x0A4D,0x0000, 0x0A4E,0x0000, 0x0A4F,0x0000, /* 295C */
0x0A50,0x0000, 0x0A51,0x0000, 0x0A52,0x0000, 0x0A53,0x0000, /* 2960 */
0x0A54,0x0000, 0x0A55,0x0000, 0x0A56,0x0000, 0x0A57,0x0000, /* 2964 */
0x0A58,0x0000, 0x0A59,0x0000, 0x0A5A,0x0000, 0x0A5B,0x0000, /* 2968 */
0x0A5C,0x0000, 0x0A5D,0x0000, 0x0A5E,0x0000, 0x0A5F,0x0000, /* 296C */
0x0A60,0x0000, 0x0A61,0x0000, 0x0A62,0x0000, 0x0A63,0x0000, /* 2970 */
0x0A64,0x0000, 0x0A65,0x0000, 0x0A66,0x0000, 0x0A67,0x0000, /* 2974 */
0x0A68,0x0000, 0x0A69,0x0000, 0x0A6A,0x0000, 0x0A6B,0x0000, /* 2978 */
0x0A6C,0x0000, 0x0A6D,0x0000, 0x0A6E,0x0000, 0x0A6F,0x0000, /* 297C */
0x0A70,0x0000, 0x0A71,0x0000, 0x0A72,0x0000, 0x030F,0x0000, /* 2980 */
0x0310,0x0000, 0x0311,0x0000, 0x0312,0x0000, 0x0313,0x0000, /* 2984 */
0x0314,0x0000, 0x0315,0x0000, 0x0316,0x0000, 0x0317,0x0000, /* 2988 */
0x0318,0x0000, 0x0319,0x0000, 0x031A,0x0000, 0x031B,0x0000, /* 298C */
0x031C,0x0000, 0x031D,0x0000, 0x031E,0x0000, 0x031F,0x0000, /* 2990 */
0x0320,0x0000, 0x0321,0x0000, 0x0322,0x0000, 0x0323,0x0000, /* 2994 */
0x0324,0x0000, 0x0A73,0x0000, 0x0A74,0x0000, 0x0A75,0x0000, /* 2998 */
0x0A76,0x0000, 0x0A77,0x0000, 0x0A78,0x0000, 0x0A79,0x0000, /* 299C */
0x0A7A,0x0000, 0x0A7B,0x0000, 0x0A7C,0x0000, 0x0A7D,0x0000, /* 29A0 */
0x0A7E,0x0000, 0x0A7F,0x0000, 0x0A80,0x0000, 0x0A81,0x0000, /* 29A4 */
0x0A82,0x0000, 0x0A83,0x0000, 0x0A84,0x0000, 0x0A85,0x0000, /* 29A8 */
0x0A86,0x0000, 0x0A87,0x0000, 0x0A88,0x0000, 0x0A89,0x0000, /* 29AC */
0x0A8A,0x0000, 0x0A8B,0x0000, 0x0A8C,0x0000, 0x0A8D,0x0000, /* 29B0 */
0x0A8E,0x0000, 0x0A8F,0x0000, 0x0A90,0x0000, 0x0A91,0x0000, /* 29B4 */
0x0A92,0x0000, 0x0A93,0x0000, 0x0A94,0x0000, 0x0A95,0x0000, /* 29B8 */
0x0A96,0x0000, 0x0A97,0x0000, 0x0A98,0x0000, 0x0A99,0x0000, /* 29BC */
0x0A9A,0x0000, 0x0A9B,0x0000, 0x0A9C,0x0000, 0x0A9D,0x0000, /* 29C0 */
0x0A9E,0x0000, 0x0A9F,0x0000, 0x0AA0,0x0000, 0x0AA1,0x0000, /* 29C4 */
0x0AA2,0x0000, 0x0AA3,0x0000, 0x0AA4,0x0000, 0x0AA5,0x0000, /* 29C8 */
0x0AA6,0x0000, 0x0AA7,0x0000, 0x0AA8,0x0000, 0x0AA9,0x0000, /* 29CC */
0x0AAA,0x0000, 0x0AAB,0x0000, 0x0AAC,0x0000, 0x0AAD,0x0000, /* 29D0 */
0x0AAE,0x0000, 0x0AAF,0x0000, 0x0AB0,0x0000, 0x0AB1,0x0000, /* 29D4 */
0x0AB2,0x0000, 0x0AB3,0x0000, 0x0AB4,0x0000, 0x0AB5,0x0000, /* 29D8 */
0x0AB6,0x0000, 0x0AB7,0x0000, 0x0AB8,0x0000, 0x0AB9,0x0000, /* 29DC */
0x0ABA,0x0000, 0x0ABB,0x0000, 0x0ABC,0x0000, 0x0ABD,0x0000, /* 29E0 */
0x0ABE,0x0000, 0x0ABF,0x0000, 0x0AC0,0x0000, 0x0AC1,0x0000, /* 29E4 */
0x0AC2,0x0000, 0x0AC3,0x0000, 0x0AC4,0x0000, 0x0AC5,0x0000, /* 29E8 */
0x0AC6,0x0000, 0x0AC7,0x0000, 0x0AC8,0x0000, 0x0AC9,0x0000, /* 29EC */
0x0ACA,0x0000, 0x0ACB,0x0000, 0x0ACC,0x0000, 0x0ACD,0x0000, /* 29F0 */
0x0ACE,0x0000, 0x0ACF,0x0000, 0x0AD0,0x0000, 0x0AD1,0x0000, /* 29F4 */
0x0AD2,0x0000, 0x0AD3,0x0000, 0x0AD4,0x0000, 0x0AD5,0x0000, /* 29F8 */
0x030D,0x0000, 0x030E,0x0000, 0x0AD6,0x0000, 0x0AD7,0x0000  /* 29FC */
};

uint16 uca520_p02A[]= { /* 2A00 (5 weights per char) */
0x0AD8,0x0000,0x0000,0x0000,0x0000, /* 2A00 */
0x0AD9,0x0000,0x0000,0x0000,0x0000, /* 2A01 */
0x0ADA,0x0000,0x0000,0x0000,0x0000, /* 2A02 */
0x0ADB,0x0000,0x0000,0x0000,0x0000, /* 2A03 */
0x0ADC,0x0000,0x0000,0x0000,0x0000, /* 2A04 */
0x0ADD,0x0000,0x0000,0x0000,0x0000, /* 2A05 */
0x0ADE,0x0000,0x0000,0x0000,0x0000, /* 2A06 */
0x0ADF,0x0000,0x0000,0x0000,0x0000, /* 2A07 */
0x0AE0,0x0000,0x0000,0x0000,0x0000, /* 2A08 */
0x0AE1,0x0000,0x0000,0x0000,0x0000, /* 2A09 */
0x0AE2,0x0000,0x0000,0x0000,0x0000, /* 2A0A */
0x0AE3,0x0000,0x0000,0x0000,0x0000, /* 2A0B */
0x0575,0x0575,0x0575,0x0575,0x0000, /* 2A0C */
0x0AE4,0x0000,0x0000,0x0000,0x0000, /* 2A0D */
0x0AE5,0x0000,0x0000,0x0000,0x0000, /* 2A0E */
0x0AE6,0x0000,0x0000,0x0000,0x0000, /* 2A0F */
0x0AE7,0x0000,0x0000,0x0000,0x0000, /* 2A10 */
0x0AE8,0x0000,0x0000,0x0000,0x0000, /* 2A11 */
0x0AE9,0x0000,0x0000,0x0000,0x0000, /* 2A12 */
0x0AEA,0x0000,0x0000,0x0000,0x0000, /* 2A13 */
0x0AEB,0x0000,0x0000,0x0000,0x0000, /* 2A14 */
0x0AEC,0x0000,0x0000,0x0000,0x0000, /* 2A15 */
0x0AED,0x0000,0x0000,0x0000,0x0000, /* 2A16 */
0x0AEE,0x0000,0x0000,0x0000,0x0000, /* 2A17 */
0x0AEF,0x0000,0x0000,0x0000,0x0000, /* 2A18 */
0x0AF0,0x0000,0x0000,0x0000,0x0000, /* 2A19 */
0x0AF1,0x0000,0x0000,0x0000,0x0000, /* 2A1A */
0x0AF2,0x0000,0x0000,0x0000,0x0000, /* 2A1B */
0x0AF3,0x0000,0x0000,0x0000,0x0000, /* 2A1C */
0x0AF4,0x0000,0x0000,0x0000,0x0000, /* 2A1D */
0x0AF5,0x0000,0x0000,0x0000,0x0000, /* 2A1E */
0x0AF6,0x0000,0x0000,0x0000,0x0000, /* 2A1F */
0x0AF7,0x0000,0x0000,0x0000,0x0000, /* 2A20 */
0x0AF8,0x0000,0x0000,0x0000,0x0000, /* 2A21 */
0x0AF9,0x0000,0x0000,0x0000,0x0000, /* 2A22 */
0x0AFA,0x0000,0x0000,0x0000,0x0000, /* 2A23 */
0x0AFB,0x0000,0x0000,0x0000,0x0000, /* 2A24 */
0x0AFC,0x0000,0x0000,0x0000,0x0000, /* 2A25 */
0x0AFD,0x0000,0x0000,0x0000,0x0000, /* 2A26 */
0x0AFE,0x0000,0x0000,0x0000,0x0000, /* 2A27 */
0x0AFF,0x0000,0x0000,0x0000,0x0000, /* 2A28 */
0x0B00,0x0000,0x0000,0x0000,0x0000, /* 2A29 */
0x0B01,0x0000,0x0000,0x0000,0x0000, /* 2A2A */
0x0B02,0x0000,0x0000,0x0000,0x0000, /* 2A2B */
0x0B03,0x0000,0x0000,0x0000,0x0000, /* 2A2C */
0x0B04,0x0000,0x0000,0x0000,0x0000, /* 2A2D */
0x0B05,0x0000,0x0000,0x0000,0x0000, /* 2A2E */
0x0B06,0x0000,0x0000,0x0000,0x0000, /* 2A2F */
0x0B07,0x0000,0x0000,0x0000,0x0000, /* 2A30 */
0x0B08,0x0000,0x0000,0x0000,0x0000, /* 2A31 */
0x0B09,0x0000,0x0000,0x0000,0x0000, /* 2A32 */
0x0B0A,0x0000,0x0000,0x0000,0x0000, /* 2A33 */
0x0B0B,0x0000,0x0000,0x0000,0x0000, /* 2A34 */
0x0B0C,0x0000,0x0000,0x0000,0x0000, /* 2A35 */
0x0B0D,0x0000,0x0000,0x0000,0x0000, /* 2A36 */
0x0B0E,0x0000,0x0000,0x0000,0x0000, /* 2A37 */
0x0B0F,0x0000,0x0000,0x0000,0x0000, /* 2A38 */
0x0B10,0x0000,0x0000,0x0000,0x0000, /* 2A39 */
0x0B11,0x0000,0x0000,0x0000,0x0000, /* 2A3A */
0x0B12,0x0000,0x0000,0x0000,0x0000, /* 2A3B */
0x0B13,0x0000,0x0000,0x0000,0x0000, /* 2A3C */
0x0B14,0x0000,0x0000,0x0000,0x0000, /* 2A3D */
0x0B15,0x0000,0x0000,0x0000,0x0000, /* 2A3E */
0x0B16,0x0000,0x0000,0x0000,0x0000, /* 2A3F */
0x0B17,0x0000,0x0000,0x0000,0x0000, /* 2A40 */
0x0B18,0x0000,0x0000,0x0000,0x0000, /* 2A41 */
0x0B19,0x0000,0x0000,0x0000,0x0000, /* 2A42 */
0x0B1A,0x0000,0x0000,0x0000,0x0000, /* 2A43 */
0x0B1B,0x0000,0x0000,0x0000,0x0000, /* 2A44 */
0x0B1C,0x0000,0x0000,0x0000,0x0000, /* 2A45 */
0x0B1D,0x0000,0x0000,0x0000,0x0000, /* 2A46 */
0x0B1E,0x0000,0x0000,0x0000,0x0000, /* 2A47 */
0x0B1F,0x0000,0x0000,0x0000,0x0000, /* 2A48 */
0x0B20,0x0000,0x0000,0x0000,0x0000, /* 2A49 */
0x0B21,0x0000,0x0000,0x0000,0x0000, /* 2A4A */
0x0B22,0x0000,0x0000,0x0000,0x0000, /* 2A4B */
0x0B23,0x0000,0x0000,0x0000,0x0000, /* 2A4C */
0x0B24,0x0000,0x0000,0x0000,0x0000, /* 2A4D */
0x0B25,0x0000,0x0000,0x0000,0x0000, /* 2A4E */
0x0B26,0x0000,0x0000,0x0000,0x0000, /* 2A4F */
0x0B27,0x0000,0x0000,0x0000,0x0000, /* 2A50 */
0x0B28,0x0000,0x0000,0x0000,0x0000, /* 2A51 */
0x0B29,0x0000,0x0000,0x0000,0x0000, /* 2A52 */
0x0B2A,0x0000,0x0000,0x0000,0x0000, /* 2A53 */
0x0B2B,0x0000,0x0000,0x0000,0x0000, /* 2A54 */
0x0B2C,0x0000,0x0000,0x0000,0x0000, /* 2A55 */
0x0B2D,0x0000,0x0000,0x0000,0x0000, /* 2A56 */
0x0B2E,0x0000,0x0000,0x0000,0x0000, /* 2A57 */
0x0B2F,0x0000,0x0000,0x0000,0x0000, /* 2A58 */
0x0B30,0x0000,0x0000,0x0000,0x0000, /* 2A59 */
0x0B31,0x0000,0x0000,0x0000,0x0000, /* 2A5A */
0x0B32,0x0000,0x0000,0x0000,0x0000, /* 2A5B */
0x0B33,0x0000,0x0000,0x0000,0x0000, /* 2A5C */
0x0B34,0x0000,0x0000,0x0000,0x0000, /* 2A5D */
0x0B35,0x0000,0x0000,0x0000,0x0000, /* 2A5E */
0x0B36,0x0000,0x0000,0x0000,0x0000, /* 2A5F */
0x0B37,0x0000,0x0000,0x0000,0x0000, /* 2A60 */
0x0B38,0x0000,0x0000,0x0000,0x0000, /* 2A61 */
0x0B39,0x0000,0x0000,0x0000,0x0000, /* 2A62 */
0x0B3A,0x0000,0x0000,0x0000,0x0000, /* 2A63 */
0x0B3B,0x0000,0x0000,0x0000,0x0000, /* 2A64 */
0x0B3C,0x0000,0x0000,0x0000,0x0000, /* 2A65 */
0x0B3D,0x0000,0x0000,0x0000,0x0000, /* 2A66 */
0x0B3E,0x0000,0x0000,0x0000,0x0000, /* 2A67 */
0x0B3F,0x0000,0x0000,0x0000,0x0000, /* 2A68 */
0x0B40,0x0000,0x0000,0x0000,0x0000, /* 2A69 */
0x0B41,0x0000,0x0000,0x0000,0x0000, /* 2A6A */
0x0B42,0x0000,0x0000,0x0000,0x0000, /* 2A6B */
0x0B43,0x0000,0x0000,0x0000,0x0000, /* 2A6C */
0x0B44,0x0000,0x0000,0x0000,0x0000, /* 2A6D */
0x0B45,0x0000,0x0000,0x0000,0x0000, /* 2A6E */
0x0B46,0x0000,0x0000,0x0000,0x0000, /* 2A6F */
0x0B47,0x0000,0x0000,0x0000,0x0000, /* 2A70 */
0x0B48,0x0000,0x0000,0x0000,0x0000, /* 2A71 */
0x0B49,0x0000,0x0000,0x0000,0x0000, /* 2A72 */
0x0B4A,0x0000,0x0000,0x0000,0x0000, /* 2A73 */
0x0247,0x0247,0x0555,0x0000,0x0000, /* 2A74 */
0x0555,0x0555,0x0000,0x0000,0x0000, /* 2A75 */
0x0555,0x0555,0x0555,0x0000,0x0000, /* 2A76 */
0x0B4B,0x0000,0x0000,0x0000,0x0000, /* 2A77 */
0x0B4C,0x0000,0x0000,0x0000,0x0000, /* 2A78 */
0x0B4D,0x0000,0x0000,0x0000,0x0000, /* 2A79 */
0x0B4E,0x0000,0x0000,0x0000,0x0000, /* 2A7A */
0x0B4F,0x0000,0x0000,0x0000,0x0000, /* 2A7B */
0x0B50,0x0000,0x0000,0x0000,0x0000, /* 2A7C */
0x0B51,0x0000,0x0000,0x0000,0x0000, /* 2A7D */
0x0B52,0x0000,0x0000,0x0000,0x0000, /* 2A7E */
0x0B53,0x0000,0x0000,0x0000,0x0000, /* 2A7F */
0x0B54,0x0000,0x0000,0x0000,0x0000, /* 2A80 */
0x0B55,0x0000,0x0000,0x0000,0x0000, /* 2A81 */
0x0B56,0x0000,0x0000,0x0000,0x0000, /* 2A82 */
0x0B57,0x0000,0x0000,0x0000,0x0000, /* 2A83 */
0x0B58,0x0000,0x0000,0x0000,0x0000, /* 2A84 */
0x0B59,0x0000,0x0000,0x0000,0x0000, /* 2A85 */
0x0B5A,0x0000,0x0000,0x0000,0x0000, /* 2A86 */
0x0B5B,0x0000,0x0000,0x0000,0x0000, /* 2A87 */
0x0B5C,0x0000,0x0000,0x0000,0x0000, /* 2A88 */
0x0B5D,0x0000,0x0000,0x0000,0x0000, /* 2A89 */
0x0B5E,0x0000,0x0000,0x0000,0x0000, /* 2A8A */
0x0B5F,0x0000,0x0000,0x0000,0x0000, /* 2A8B */
0x0B60,0x0000,0x0000,0x0000,0x0000, /* 2A8C */
0x0B61,0x0000,0x0000,0x0000,0x0000, /* 2A8D */
0x0B62,0x0000,0x0000,0x0000,0x0000, /* 2A8E */
0x0B63,0x0000,0x0000,0x0000,0x0000, /* 2A8F */
0x0B64,0x0000,0x0000,0x0000,0x0000, /* 2A90 */
0x0B65,0x0000,0x0000,0x0000,0x0000, /* 2A91 */
0x0B66,0x0000,0x0000,0x0000,0x0000, /* 2A92 */
0x0B67,0x0000,0x0000,0x0000,0x0000, /* 2A93 */
0x0B68,0x0000,0x0000,0x0000,0x0000, /* 2A94 */
0x0B69,0x0000,0x0000,0x0000,0x0000, /* 2A95 */
0x0B6A,0x0000,0x0000,0x0000,0x0000, /* 2A96 */
0x0B6B,0x0000,0x0000,0x0000,0x0000, /* 2A97 */
0x0B6C,0x0000,0x0000,0x0000,0x0000, /* 2A98 */
0x0B6D,0x0000,0x0000,0x0000,0x0000, /* 2A99 */
0x0B6E,0x0000,0x0000,0x0000,0x0000, /* 2A9A */
0x0B6F,0x0000,0x0000,0x0000,0x0000, /* 2A9B */
0x0B70,0x0000,0x0000,0x0000,0x0000, /* 2A9C */
0x0B71,0x0000,0x0000,0x0000,0x0000, /* 2A9D */
0x0B72,0x0000,0x0000,0x0000,0x0000, /* 2A9E */
0x0B73,0x0000,0x0000,0x0000,0x0000, /* 2A9F */
0x0B74,0x0000,0x0000,0x0000,0x0000, /* 2AA0 */
0x0B75,0x0000,0x0000,0x0000,0x0000, /* 2AA1 */
0x0B76,0x0000,0x0000,0x0000,0x0000, /* 2AA2 */
0x0B77,0x0000,0x0000,0x0000,0x0000, /* 2AA3 */
0x0B78,0x0000,0x0000,0x0000,0x0000, /* 2AA4 */
0x0B79,0x0000,0x0000,0x0000,0x0000, /* 2AA5 */
0x0B7A,0x0000,0x0000,0x0000,0x0000, /* 2AA6 */
0x0B7B,0x0000,0x0000,0x0000,0x0000, /* 2AA7 */
0x0B7C,0x0000,0x0000,0x0000,0x0000, /* 2AA8 */
0x0B7D,0x0000,0x0000,0x0000,0x0000, /* 2AA9 */
0x0B7E,0x0000,0x0000,0x0000,0x0000, /* 2AAA */
0x0B7F,0x0000,0x0000,0x0000,0x0000, /* 2AAB */
0x0B80,0x0000,0x0000,0x0000,0x0000, /* 2AAC */
0x0B81,0x0000,0x0000,0x0000,0x0000, /* 2AAD */
0x0B82,0x0000,0x0000,0x0000,0x0000, /* 2AAE */
0x0B83,0x0000,0x0000,0x0000,0x0000, /* 2AAF */
0x0B84,0x0000,0x0000,0x0000,0x0000, /* 2AB0 */
0x0B85,0x0000,0x0000,0x0000,0x0000, /* 2AB1 */
0x0B86,0x0000,0x0000,0x0000,0x0000, /* 2AB2 */
0x0B87,0x0000,0x0000,0x0000,0x0000, /* 2AB3 */
0x0B88,0x0000,0x0000,0x0000,0x0000, /* 2AB4 */
0x0B89,0x0000,0x0000,0x0000,0x0000, /* 2AB5 */
0x0B8A,0x0000,0x0000,0x0000,0x0000, /* 2AB6 */
0x0B8B,0x0000,0x0000,0x0000,0x0000, /* 2AB7 */
0x0B8C,0x0000,0x0000,0x0000,0x0000, /* 2AB8 */
0x0B8D,0x0000,0x0000,0x0000,0x0000, /* 2AB9 */
0x0B8E,0x0000,0x0000,0x0000,0x0000, /* 2ABA */
0x0B8F,0x0000,0x0000,0x0000,0x0000, /* 2ABB */
0x0B90,0x0000,0x0000,0x0000,0x0000, /* 2ABC */
0x0B91,0x0000,0x0000,0x0000,0x0000, /* 2ABD */
0x0B92,0x0000,0x0000,0x0000,0x0000, /* 2ABE */
0x0B93,0x0000,0x0000,0x0000,0x0000, /* 2ABF */
0x0B94,0x0000,0x0000,0x0000,0x0000, /* 2AC0 */
0x0B95,0x0000,0x0000,0x0000,0x0000, /* 2AC1 */
0x0B96,0x0000,0x0000,0x0000,0x0000, /* 2AC2 */
0x0B97,0x0000,0x0000,0x0000,0x0000, /* 2AC3 */
0x0B98,0x0000,0x0000,0x0000,0x0000, /* 2AC4 */
0x0B99,0x0000,0x0000,0x0000,0x0000, /* 2AC5 */
0x0B9A,0x0000,0x0000,0x0000,0x0000, /* 2AC6 */
0x0B9B,0x0000,0x0000,0x0000,0x0000, /* 2AC7 */
0x0B9C,0x0000,0x0000,0x0000,0x0000, /* 2AC8 */
0x0B9D,0x0000,0x0000,0x0000,0x0000, /* 2AC9 */
0x0B9E,0x0000,0x0000,0x0000,0x0000, /* 2ACA */
0x0B9F,0x0000,0x0000,0x0000,0x0000, /* 2ACB */
0x0BA0,0x0000,0x0000,0x0000,0x0000, /* 2ACC */
0x0BA1,0x0000,0x0000,0x0000,0x0000, /* 2ACD */
0x0BA2,0x0000,0x0000,0x0000,0x0000, /* 2ACE */
0x0BA3,0x0000,0x0000,0x0000,0x0000, /* 2ACF */
0x0BA4,0x0000,0x0000,0x0000,0x0000, /* 2AD0 */
0x0BA5,0x0000,0x0000,0x0000,0x0000, /* 2AD1 */
0x0BA6,0x0000,0x0000,0x0000,0x0000, /* 2AD2 */
0x0BA7,0x0000,0x0000,0x0000,0x0000, /* 2AD3 */
0x0BA8,0x0000,0x0000,0x0000,0x0000, /* 2AD4 */
0x0BA9,0x0000,0x0000,0x0000,0x0000, /* 2AD5 */
0x0BAA,0x0000,0x0000,0x0000,0x0000, /* 2AD6 */
0x0BAB,0x0000,0x0000,0x0000,0x0000, /* 2AD7 */
0x0BAC,0x0000,0x0000,0x0000,0x0000, /* 2AD8 */
0x0BAD,0x0000,0x0000,0x0000,0x0000, /* 2AD9 */
0x0BAE,0x0000,0x0000,0x0000,0x0000, /* 2ADA */
0x0BAF,0x0000,0x0000,0x0000,0x0000, /* 2ADB */
0x0BB0,0x0000,0x0000,0x0000,0x0000, /* 2ADC */
0x0BB0,0x0000,0x0000,0x0000,0x0000, /* 2ADD */
0x0BB1,0x0000,0x0000,0x0000,0x0000, /* 2ADE */
0x0BB2,0x0000,0x0000,0x0000,0x0000, /* 2ADF */
0x0BB3,0x0000,0x0000,0x0000,0x0000, /* 2AE0 */
0x0BB4,0x0000,0x0000,0x0000,0x0000, /* 2AE1 */
0x0BB5,0x0000,0x0000,0x0000,0x0000, /* 2AE2 */
0x0BB6,0x0000,0x0000,0x0000,0x0000, /* 2AE3 */
0x0BB7,0x0000,0x0000,0x0000,0x0000, /* 2AE4 */
0x0BB8,0x0000,0x0000,0x0000,0x0000, /* 2AE5 */
0x0BB9,0x0000,0x0000,0x0000,0x0000, /* 2AE6 */
0x0BBA,0x0000,0x0000,0x0000,0x0000, /* 2AE7 */
0x0BBB,0x0000,0x0000,0x0000,0x0000, /* 2AE8 */
0x0BBC,0x0000,0x0000,0x0000,0x0000, /* 2AE9 */
0x0BBD,0x0000,0x0000,0x0000,0x0000, /* 2AEA */
0x0BBE,0x0000,0x0000,0x0000,0x0000, /* 2AEB */
0x0BBF,0x0000,0x0000,0x0000,0x0000, /* 2AEC */
0x0BC0,0x0000,0x0000,0x0000,0x0000, /* 2AED */
0x0BC1,0x0000,0x0000,0x0000,0x0000, /* 2AEE */
0x0BC2,0x0000,0x0000,0x0000,0x0000, /* 2AEF */
0x0BC3,0x0000,0x0000,0x0000,0x0000, /* 2AF0 */
0x0BC4,0x0000,0x0000,0x0000,0x0000, /* 2AF1 */
0x0BC5,0x0000,0x0000,0x0000,0x0000, /* 2AF2 */
0x0BC6,0x0000,0x0000,0x0000,0x0000, /* 2AF3 */
0x0BC7,0x0000,0x0000,0x0000,0x0000, /* 2AF4 */
0x0BC8,0x0000,0x0000,0x0000,0x0000, /* 2AF5 */
0x0BC9,0x0000,0x0000,0x0000,0x0000, /* 2AF6 */
0x0BCA,0x0000,0x0000,0x0000,0x0000, /* 2AF7 */
0x0BCB,0x0000,0x0000,0x0000,0x0000, /* 2AF8 */
0x0BCC,0x0000,0x0000,0x0000,0x0000, /* 2AF9 */
0x0BCD,0x0000,0x0000,0x0000,0x0000, /* 2AFA */
0x0BCE,0x0000,0x0000,0x0000,0x0000, /* 2AFB */
0x0BCF,0x0000,0x0000,0x0000,0x0000, /* 2AFC */
0x0BD0,0x0000,0x0000,0x0000,0x0000, /* 2AFD */
0x0BD1,0x0000,0x0000,0x0000,0x0000, /* 2AFE */
0x0BD2,0x0000,0x0000,0x0000,0x0000  /* 2AFF */
};

uint16 uca520_p02B[]= { /* 2B00 (3 weights per char) */
0x0BD3,0x0000,0x0000, 0x0BD4,0x0000,0x0000, 0x0BD5,0x0000,0x0000, /* 2B00 */
0x0BD6,0x0000,0x0000, 0x0BD7,0x0000,0x0000, 0x0BD8,0x0000,0x0000, /* 2B03 */
0x0BD9,0x0000,0x0000, 0x0BDA,0x0000,0x0000, 0x0BDB,0x0000,0x0000, /* 2B06 */
0x0BDC,0x0000,0x0000, 0x0BDD,0x0000,0x0000, 0x0BDE,0x0000,0x0000, /* 2B09 */
0x0BDF,0x0000,0x0000, 0x0BE0,0x0000,0x0000, 0x0BE1,0x0000,0x0000, /* 2B0C */
0x0BE2,0x0000,0x0000, 0x0BE3,0x0000,0x0000, 0x0BE4,0x0000,0x0000, /* 2B0F */
0x0BE5,0x0000,0x0000, 0x0BE6,0x0000,0x0000, 0x0BE7,0x0000,0x0000, /* 2B12 */
0x0BE8,0x0000,0x0000, 0x0BE9,0x0000,0x0000, 0x0BEA,0x0000,0x0000, /* 2B15 */
0x0BEB,0x0000,0x0000, 0x0BEC,0x0000,0x0000, 0x0BED,0x0000,0x0000, /* 2B18 */
0x0BEE,0x0000,0x0000, 0x0BEF,0x0000,0x0000, 0x0BF0,0x0000,0x0000, /* 2B1B */
0x0BF1,0x0000,0x0000, 0x0BF2,0x0000,0x0000, 0x0BF3,0x0000,0x0000, /* 2B1E */
0x0BF4,0x0000,0x0000, 0x0BF5,0x0000,0x0000, 0x0BF6,0x0000,0x0000, /* 2B21 */
0x0BF7,0x0000,0x0000, 0x0BF8,0x0000,0x0000, 0x0BF9,0x0000,0x0000, /* 2B24 */
0x0BFA,0x0000,0x0000, 0x0BFB,0x0000,0x0000, 0x0BFC,0x0000,0x0000, /* 2B27 */
0x0BFD,0x0000,0x0000, 0x0BFE,0x0000,0x0000, 0x0BFF,0x0000,0x0000, /* 2B2A */
0x0C00,0x0000,0x0000, 0x0C01,0x0000,0x0000, 0x0C02,0x0000,0x0000, /* 2B2D */
0x0C03,0x0000,0x0000, 0x0C04,0x0000,0x0000, 0x0C05,0x0000,0x0000, /* 2B30 */
0x0C06,0x0000,0x0000, 0x0C07,0x0000,0x0000, 0x0C08,0x0000,0x0000, /* 2B33 */
0x0C09,0x0000,0x0000, 0x0C0A,0x0000,0x0000, 0x0C0B,0x0000,0x0000, /* 2B36 */
0x0C0C,0x0000,0x0000, 0x0C0D,0x0000,0x0000, 0x0C0E,0x0000,0x0000, /* 2B39 */
0x0C0F,0x0000,0x0000, 0x0C10,0x0000,0x0000, 0x0C11,0x0000,0x0000, /* 2B3C */
0x0C12,0x0000,0x0000, 0x0C13,0x0000,0x0000, 0x0C14,0x0000,0x0000, /* 2B3F */
0x0C15,0x0000,0x0000, 0x0C16,0x0000,0x0000, 0x0C17,0x0000,0x0000, /* 2B42 */
0x0C18,0x0000,0x0000, 0x0C19,0x0000,0x0000, 0x0C1A,0x0000,0x0000, /* 2B45 */
0x0C1B,0x0000,0x0000, 0x0C1C,0x0000,0x0000, 0x0C1D,0x0000,0x0000, /* 2B48 */
0x0C1E,0x0000,0x0000, 0x0C1F,0x0000,0x0000, 0xFBC0,0xAB4D,0x0000, /* 2B4B */
0xFBC0,0xAB4E,0x0000, 0xFBC0,0xAB4F,0x0000, 0x0C20,0x0000,0x0000, /* 2B4E */
0x0C21,0x0000,0x0000, 0x0C22,0x0000,0x0000, 0x0C23,0x0000,0x0000, /* 2B51 */
0x0C24,0x0000,0x0000, 0x0C25,0x0000,0x0000, 0x0C26,0x0000,0x0000, /* 2B54 */
0x0C27,0x0000,0x0000, 0x0C28,0x0000,0x0000, 0x0C29,0x0000,0x0000, /* 2B57 */
0xFBC0,0xAB5A,0x0000, 0xFBC0,0xAB5B,0x0000, 0xFBC0,0xAB5C,0x0000, /* 2B5A */
0xFBC0,0xAB5D,0x0000, 0xFBC0,0xAB5E,0x0000, 0xFBC0,0xAB5F,0x0000, /* 2B5D */
0xFBC0,0xAB60,0x0000, 0xFBC0,0xAB61,0x0000, 0xFBC0,0xAB62,0x0000, /* 2B60 */
0xFBC0,0xAB63,0x0000, 0xFBC0,0xAB64,0x0000, 0xFBC0,0xAB65,0x0000, /* 2B63 */
0xFBC0,0xAB66,0x0000, 0xFBC0,0xAB67,0x0000, 0xFBC0,0xAB68,0x0000, /* 2B66 */
0xFBC0,0xAB69,0x0000, 0xFBC0,0xAB6A,0x0000, 0xFBC0,0xAB6B,0x0000, /* 2B69 */
0xFBC0,0xAB6C,0x0000, 0xFBC0,0xAB6D,0x0000, 0xFBC0,0xAB6E,0x0000, /* 2B6C */
0xFBC0,0xAB6F,0x0000, 0xFBC0,0xAB70,0x0000, 0xFBC0,0xAB71,0x0000, /* 2B6F */
0xFBC0,0xAB72,0x0000, 0xFBC0,0xAB73,0x0000, 0xFBC0,0xAB74,0x0000, /* 2B72 */
0xFBC0,0xAB75,0x0000, 0xFBC0,0xAB76,0x0000, 0xFBC0,0xAB77,0x0000, /* 2B75 */
0xFBC0,0xAB78,0x0000, 0xFBC0,0xAB79,0x0000, 0xFBC0,0xAB7A,0x0000, /* 2B78 */
0xFBC0,0xAB7B,0x0000, 0xFBC0,0xAB7C,0x0000, 0xFBC0,0xAB7D,0x0000, /* 2B7B */
0xFBC0,0xAB7E,0x0000, 0xFBC0,0xAB7F,0x0000, 0xFBC0,0xAB80,0x0000, /* 2B7E */
0xFBC0,0xAB81,0x0000, 0xFBC0,0xAB82,0x0000, 0xFBC0,0xAB83,0x0000, /* 2B81 */
0xFBC0,0xAB84,0x0000, 0xFBC0,0xAB85,0x0000, 0xFBC0,0xAB86,0x0000, /* 2B84 */
0xFBC0,0xAB87,0x0000, 0xFBC0,0xAB88,0x0000, 0xFBC0,0xAB89,0x0000, /* 2B87 */
0xFBC0,0xAB8A,0x0000, 0xFBC0,0xAB8B,0x0000, 0xFBC0,0xAB8C,0x0000, /* 2B8A */
0xFBC0,0xAB8D,0x0000, 0xFBC0,0xAB8E,0x0000, 0xFBC0,0xAB8F,0x0000, /* 2B8D */
0xFBC0,0xAB90,0x0000, 0xFBC0,0xAB91,0x0000, 0xFBC0,0xAB92,0x0000, /* 2B90 */
0xFBC0,0xAB93,0x0000, 0xFBC0,0xAB94,0x0000, 0xFBC0,0xAB95,0x0000, /* 2B93 */
0xFBC0,0xAB96,0x0000, 0xFBC0,0xAB97,0x0000, 0xFBC0,0xAB98,0x0000, /* 2B96 */
0xFBC0,0xAB99,0x0000, 0xFBC0,0xAB9A,0x0000, 0xFBC0,0xAB9B,0x0000, /* 2B99 */
0xFBC0,0xAB9C,0x0000, 0xFBC0,0xAB9D,0x0000, 0xFBC0,0xAB9E,0x0000, /* 2B9C */
0xFBC0,0xAB9F,0x0000, 0xFBC0,0xABA0,0x0000, 0xFBC0,0xABA1,0x0000, /* 2B9F */
0xFBC0,0xABA2,0x0000, 0xFBC0,0xABA3,0x0000, 0xFBC0,0xABA4,0x0000, /* 2BA2 */
0xFBC0,0xABA5,0x0000, 0xFBC0,0xABA6,0x0000, 0xFBC0,0xABA7,0x0000, /* 2BA5 */
0xFBC0,0xABA8,0x0000, 0xFBC0,0xABA9,0x0000, 0xFBC0,0xABAA,0x0000, /* 2BA8 */
0xFBC0,0xABAB,0x0000, 0xFBC0,0xABAC,0x0000, 0xFBC0,0xABAD,0x0000, /* 2BAB */
0xFBC0,0xABAE,0x0000, 0xFBC0,0xABAF,0x0000, 0xFBC0,0xABB0,0x0000, /* 2BAE */
0xFBC0,0xABB1,0x0000, 0xFBC0,0xABB2,0x0000, 0xFBC0,0xABB3,0x0000, /* 2BB1 */
0xFBC0,0xABB4,0x0000, 0xFBC0,0xABB5,0x0000, 0xFBC0,0xABB6,0x0000, /* 2BB4 */
0xFBC0,0xABB7,0x0000, 0xFBC0,0xABB8,0x0000, 0xFBC0,0xABB9,0x0000, /* 2BB7 */
0xFBC0,0xABBA,0x0000, 0xFBC0,0xABBB,0x0000, 0xFBC0,0xABBC,0x0000, /* 2BBA */
0xFBC0,0xABBD,0x0000, 0xFBC0,0xABBE,0x0000, 0xFBC0,0xABBF,0x0000, /* 2BBD */
0xFBC0,0xABC0,0x0000, 0xFBC0,0xABC1,0x0000, 0xFBC0,0xABC2,0x0000, /* 2BC0 */
0xFBC0,0xABC3,0x0000, 0xFBC0,0xABC4,0x0000, 0xFBC0,0xABC5,0x0000, /* 2BC3 */
0xFBC0,0xABC6,0x0000, 0xFBC0,0xABC7,0x0000, 0xFBC0,0xABC8,0x0000, /* 2BC6 */
0xFBC0,0xABC9,0x0000, 0xFBC0,0xABCA,0x0000, 0xFBC0,0xABCB,0x0000, /* 2BC9 */
0xFBC0,0xABCC,0x0000, 0xFBC0,0xABCD,0x0000, 0xFBC0,0xABCE,0x0000, /* 2BCC */
0xFBC0,0xABCF,0x0000, 0xFBC0,0xABD0,0x0000, 0xFBC0,0xABD1,0x0000, /* 2BCF */
0xFBC0,0xABD2,0x0000, 0xFBC0,0xABD3,0x0000, 0xFBC0,0xABD4,0x0000, /* 2BD2 */
0xFBC0,0xABD5,0x0000, 0xFBC0,0xABD6,0x0000, 0xFBC0,0xABD7,0x0000, /* 2BD5 */
0xFBC0,0xABD8,0x0000, 0xFBC0,0xABD9,0x0000, 0xFBC0,0xABDA,0x0000, /* 2BD8 */
0xFBC0,0xABDB,0x0000, 0xFBC0,0xABDC,0x0000, 0xFBC0,0xABDD,0x0000, /* 2BDB */
0xFBC0,0xABDE,0x0000, 0xFBC0,0xABDF,0x0000, 0xFBC0,0xABE0,0x0000, /* 2BDE */
0xFBC0,0xABE1,0x0000, 0xFBC0,0xABE2,0x0000, 0xFBC0,0xABE3,0x0000, /* 2BE1 */
0xFBC0,0xABE4,0x0000, 0xFBC0,0xABE5,0x0000, 0xFBC0,0xABE6,0x0000, /* 2BE4 */
0xFBC0,0xABE7,0x0000, 0xFBC0,0xABE8,0x0000, 0xFBC0,0xABE9,0x0000, /* 2BE7 */
0xFBC0,0xABEA,0x0000, 0xFBC0,0xABEB,0x0000, 0xFBC0,0xABEC,0x0000, /* 2BEA */
0xFBC0,0xABED,0x0000, 0xFBC0,0xABEE,0x0000, 0xFBC0,0xABEF,0x0000, /* 2BED */
0xFBC0,0xABF0,0x0000, 0xFBC0,0xABF1,0x0000, 0xFBC0,0xABF2,0x0000, /* 2BF0 */
0xFBC0,0xABF3,0x0000, 0xFBC0,0xABF4,0x0000, 0xFBC0,0xABF5,0x0000, /* 2BF3 */
0xFBC0,0xABF6,0x0000, 0xFBC0,0xABF7,0x0000, 0xFBC0,0xABF8,0x0000, /* 2BF6 */
0xFBC0,0xABF9,0x0000, 0xFBC0,0xABFA,0x0000, 0xFBC0,0xABFB,0x0000, /* 2BF9 */
0xFBC0,0xABFC,0x0000, 0xFBC0,0xABFD,0x0000, 0xFBC0,0xABFE,0x0000, /* 2BFC */
0xFBC0,0xABFF,0x0000  };

uint16 uca520_p02C[]= { /* 2C00 (4 weights per char) */
0x17B5,0x0000,0x0000,0x0000, 0x17B6,0x0000,0x0000,0x0000, /* 2C00 */
0x17B7,0x0000,0x0000,0x0000, 0x17B8,0x0000,0x0000,0x0000, /* 2C02 */
0x17B9,0x0000,0x0000,0x0000, 0x17BA,0x0000,0x0000,0x0000, /* 2C04 */
0x17BB,0x0000,0x0000,0x0000, 0x17BC,0x0000,0x0000,0x0000, /* 2C06 */
0x17BD,0x0000,0x0000,0x0000, 0x17BE,0x0000,0x0000,0x0000, /* 2C08 */
0x17BF,0x0000,0x0000,0x0000, 0x17C0,0x0000,0x0000,0x0000, /* 2C0A */
0x17C1,0x0000,0x0000,0x0000, 0x17C2,0x0000,0x0000,0x0000, /* 2C0C */
0x17C3,0x0000,0x0000,0x0000, 0x17C4,0x0000,0x0000,0x0000, /* 2C0E */
0x17C5,0x0000,0x0000,0x0000, 0x17C6,0x0000,0x0000,0x0000, /* 2C10 */
0x17C7,0x0000,0x0000,0x0000, 0x17C8,0x0000,0x0000,0x0000, /* 2C12 */
0x17C9,0x0000,0x0000,0x0000, 0x17CA,0x0000,0x0000,0x0000, /* 2C14 */
0x17CB,0x0000,0x0000,0x0000, 0x17CC,0x0000,0x0000,0x0000, /* 2C16 */
0x17CD,0x0000,0x0000,0x0000, 0x17CE,0x0000,0x0000,0x0000, /* 2C18 */
0x17CF,0x0000,0x0000,0x0000, 0x17D0,0x0000,0x0000,0x0000, /* 2C1A */
0x17D1,0x0000,0x0000,0x0000, 0x17D2,0x0000,0x0000,0x0000, /* 2C1C */
0x17D3,0x0000,0x0000,0x0000, 0x17D4,0x0000,0x0000,0x0000, /* 2C1E */
0x17D5,0x0000,0x0000,0x0000, 0x17D6,0x0000,0x0000,0x0000, /* 2C20 */
0x17D7,0x0000,0x0000,0x0000, 0x17D8,0x0000,0x0000,0x0000, /* 2C22 */
0x17D9,0x0000,0x0000,0x0000, 0x17DA,0x0000,0x0000,0x0000, /* 2C24 */
0x17DB,0x0000,0x0000,0x0000, 0x17DC,0x0000,0x0000,0x0000, /* 2C26 */
0x17DD,0x0000,0x0000,0x0000, 0x17DE,0x0000,0x0000,0x0000, /* 2C28 */
0x17DF,0x0000,0x0000,0x0000, 0x17E0,0x0000,0x0000,0x0000, /* 2C2A */
0x17E1,0x0000,0x0000,0x0000, 0x17E2,0x0000,0x0000,0x0000, /* 2C2C */
0x17E3,0x0000,0x0000,0x0000, 0xFBC0,0xAC2F,0x0000,0x0000, /* 2C2E */
0x17B5,0x0000,0x0000,0x0000, 0x17B6,0x0000,0x0000,0x0000, /* 2C30 */
0x17B7,0x0000,0x0000,0x0000, 0x17B8,0x0000,0x0000,0x0000, /* 2C32 */
0x17B9,0x0000,0x0000,0x0000, 0x17BA,0x0000,0x0000,0x0000, /* 2C34 */
0x17BB,0x0000,0x0000,0x0000, 0x17BC,0x0000,0x0000,0x0000, /* 2C36 */
0x17BD,0x0000,0x0000,0x0000, 0x17BE,0x0000,0x0000,0x0000, /* 2C38 */
0x17BF,0x0000,0x0000,0x0000, 0x17C0,0x0000,0x0000,0x0000, /* 2C3A */
0x17C1,0x0000,0x0000,0x0000, 0x17C2,0x0000,0x0000,0x0000, /* 2C3C */
0x17C3,0x0000,0x0000,0x0000, 0x17C4,0x0000,0x0000,0x0000, /* 2C3E */
0x17C5,0x0000,0x0000,0x0000, 0x17C6,0x0000,0x0000,0x0000, /* 2C40 */
0x17C7,0x0000,0x0000,0x0000, 0x17C8,0x0000,0x0000,0x0000, /* 2C42 */
0x17C9,0x0000,0x0000,0x0000, 0x17CA,0x0000,0x0000,0x0000, /* 2C44 */
0x17CB,0x0000,0x0000,0x0000, 0x17CC,0x0000,0x0000,0x0000, /* 2C46 */
0x17CD,0x0000,0x0000,0x0000, 0x17CE,0x0000,0x0000,0x0000, /* 2C48 */
0x17CF,0x0000,0x0000,0x0000, 0x17D0,0x0000,0x0000,0x0000, /* 2C4A */
0x17D1,0x0000,0x0000,0x0000, 0x17D2,0x0000,0x0000,0x0000, /* 2C4C */
0x17D3,0x0000,0x0000,0x0000, 0x17D4,0x0000,0x0000,0x0000, /* 2C4E */
0x17D5,0x0000,0x0000,0x0000, 0x17D6,0x0000,0x0000,0x0000, /* 2C50 */
0x17D7,0x0000,0x0000,0x0000, 0x17D8,0x0000,0x0000,0x0000, /* 2C52 */
0x17D9,0x0000,0x0000,0x0000, 0x17DA,0x0000,0x0000,0x0000, /* 2C54 */
0x17DB,0x0000,0x0000,0x0000, 0x17DC,0x0000,0x0000,0x0000, /* 2C56 */
0x17DD,0x0000,0x0000,0x0000, 0x17DE,0x0000,0x0000,0x0000, /* 2C58 */
0x17DF,0x0000,0x0000,0x0000, 0x17E0,0x0000,0x0000,0x0000, /* 2C5A */
0x17E1,0x0000,0x0000,0x0000, 0x17E2,0x0000,0x0000,0x0000, /* 2C5C */
0x17E3,0x0000,0x0000,0x0000, 0xFBC0,0xAC5F,0x0000,0x0000, /* 2C5E */
0x133F,0x0000,0x0000,0x0000, 0x133F,0x0000,0x0000,0x0000, /* 2C60 */
0x1340,0x0000,0x0000,0x0000, 0x13B8,0x0000,0x0000,0x0000, /* 2C62 */
0x13FC,0x0000,0x0000,0x0000, 0x1214,0x0000,0x0000,0x0000, /* 2C64 */
0x143C,0x0000,0x0000,0x0000, 0x12E3,0x0000,0x0000,0x0000, /* 2C66 */
0x12E3,0x0000,0x0000,0x0000, 0x1328,0x0000,0x0000,0x0000, /* 2C68 */
0x1328,0x0000,0x0000,0x0000, 0x14C8,0x0000,0x0000,0x0000, /* 2C6A */
0x14C8,0x0000,0x0000,0x0000, 0x121C,0x0000,0x0000,0x0000, /* 2C6C */
0x1366,0x0000,0x0000,0x0000, 0x1218,0x0000,0x0000,0x0000, /* 2C6E */
0x1221,0x0000,0x0000,0x0000, 0x1486,0x0000,0x0000,0x0000, /* 2C70 */
0x1492,0x0000,0x0000,0x0000, 0x1492,0x0000,0x0000,0x0000, /* 2C72 */
0x1487,0x0000,0x0000,0x0000, 0x12E4,0x0000,0x0000,0x0000, /* 2C74 */
0x12E4,0x0000,0x0000,0x0000, 0x13C7,0x0000,0x0000,0x0000, /* 2C76 */
0x1275,0x0000,0x0000,0x0000, 0x13F7,0x0000,0x0000,0x0000, /* 2C78 */
0x13A4,0x0000,0x0000,0x0000, 0x127A,0x0000,0x0000,0x0000, /* 2C7A */
0x1305,0x0000,0x0000,0x0000, 0x147B,0x0000,0x0000,0x0000, /* 2C7C */
0x141B,0x0000,0x0000,0x0000, 0x14C4,0x0000,0x0000,0x0000, /* 2C7E */
0x1571,0x0000,0x0000,0x0000, 0x1571,0x0000,0x0000,0x0000, /* 2C80 */
0x1572,0x0000,0x0000,0x0000, 0x1572,0x0000,0x0000,0x0000, /* 2C82 */
0x1573,0x0000,0x0000,0x0000, 0x1573,0x0000,0x0000,0x0000, /* 2C84 */
0x1574,0x0000,0x0000,0x0000, 0x1574,0x0000,0x0000,0x0000, /* 2C86 */
0x1575,0x0000,0x0000,0x0000, 0x1575,0x0000,0x0000,0x0000, /* 2C88 */
0x1577,0x0000,0x0000,0x0000, 0x1577,0x0000,0x0000,0x0000, /* 2C8A */
0x1578,0x0000,0x0000,0x0000, 0x1578,0x0000,0x0000,0x0000, /* 2C8C */
0x1579,0x0000,0x0000,0x0000, 0x1579,0x0000,0x0000,0x0000, /* 2C8E */
0x157A,0x0000,0x0000,0x0000, 0x157A,0x0000,0x0000,0x0000, /* 2C90 */
0x157B,0x0000,0x0000,0x0000, 0x157B,0x0000,0x0000,0x0000, /* 2C92 */
0x157C,0x0000,0x0000,0x0000, 0x157C,0x0000,0x0000,0x0000, /* 2C94 */
0x157E,0x0000,0x0000,0x0000, 0x157E,0x0000,0x0000,0x0000, /* 2C96 */
0x157F,0x0000,0x0000,0x0000, 0x157F,0x0000,0x0000,0x0000, /* 2C98 */
0x1580,0x0000,0x0000,0x0000, 0x1580,0x0000,0x0000,0x0000, /* 2C9A */
0x1583,0x0000,0x0000,0x0000, 0x1583,0x0000,0x0000,0x0000, /* 2C9C */
0x1584,0x0000,0x0000,0x0000, 0x1584,0x0000,0x0000,0x0000, /* 2C9E */
0x1585,0x0000,0x0000,0x0000, 0x1585,0x0000,0x0000,0x0000, /* 2CA0 */
0x1586,0x0000,0x0000,0x0000, 0x1586,0x0000,0x0000,0x0000, /* 2CA2 */
0x1587,0x0000,0x0000,0x0000, 0x1587,0x0000,0x0000,0x0000, /* 2CA4 */
0x1588,0x0000,0x0000,0x0000, 0x1588,0x0000,0x0000,0x0000, /* 2CA6 */
0x1589,0x0000,0x0000,0x0000, 0x1589,0x0000,0x0000,0x0000, /* 2CA8 */
0x158A,0x0000,0x0000,0x0000, 0x158A,0x0000,0x0000,0x0000, /* 2CAA */
0x158B,0x0000,0x0000,0x0000, 0x158B,0x0000,0x0000,0x0000, /* 2CAC */
0x158C,0x0000,0x0000,0x0000, 0x158C,0x0000,0x0000,0x0000, /* 2CAE */
0x158D,0x0000,0x0000,0x0000, 0x158D,0x0000,0x0000,0x0000, /* 2CB0 */
0x15A7,0x0000,0x0000,0x0000, 0x15A7,0x0000,0x0000,0x0000, /* 2CB2 */
0x15A8,0x0000,0x0000,0x0000, 0x15A8,0x0000,0x0000,0x0000, /* 2CB4 */
0x1576,0x0000,0x0000,0x0000, 0x1576,0x0000,0x0000,0x0000, /* 2CB6 */
0x157D,0x0000,0x0000,0x0000, 0x157D,0x0000,0x0000,0x0000, /* 2CB8 */
0x1581,0x0000,0x0000,0x0000, 0x1581,0x0000,0x0000,0x0000, /* 2CBA */
0x1582,0x0000,0x0000,0x0000, 0x1582,0x0000,0x0000,0x0000, /* 2CBC */
0x158E,0x0000,0x0000,0x0000, 0x158E,0x0000,0x0000,0x0000, /* 2CBE */
0x158F,0x0000,0x0000,0x0000, 0x158F,0x0000,0x0000,0x0000, /* 2CC0 */
0x1592,0x0000,0x0000,0x0000, 0x1592,0x0000,0x0000,0x0000, /* 2CC2 */
0x1593,0x0000,0x0000,0x0000, 0x1593,0x0000,0x0000,0x0000, /* 2CC4 */
0x1594,0x0000,0x0000,0x0000, 0x1594,0x0000,0x0000,0x0000, /* 2CC6 */
0x1597,0x0000,0x0000,0x0000, 0x1597,0x0000,0x0000,0x0000, /* 2CC8 */
0x1599,0x0000,0x0000,0x0000, 0x1599,0x0000,0x0000,0x0000, /* 2CCA */
0x159A,0x0000,0x0000,0x0000, 0x159A,0x0000,0x0000,0x0000, /* 2CCC */
0x159B,0x0000,0x0000,0x0000, 0x159B,0x0000,0x0000,0x0000, /* 2CCE */
0x159C,0x0000,0x0000,0x0000, 0x159C,0x0000,0x0000,0x0000, /* 2CD0 */
0x159D,0x0000,0x0000,0x0000, 0x159D,0x0000,0x0000,0x0000, /* 2CD2 */
0x159E,0x0000,0x0000,0x0000, 0x159E,0x0000,0x0000,0x0000, /* 2CD4 */
0x15A1,0x0000,0x0000,0x0000, 0x15A1,0x0000,0x0000,0x0000, /* 2CD6 */
0x15A3,0x0000,0x0000,0x0000, 0x15A3,0x0000,0x0000,0x0000, /* 2CD8 */
0x15A4,0x0000,0x0000,0x0000, 0x15A4,0x0000,0x0000,0x0000, /* 2CDA */
0x15A5,0x0000,0x0000,0x0000, 0x15A5,0x0000,0x0000,0x0000, /* 2CDC */
0x15A9,0x0000,0x0000,0x0000, 0x15A9,0x0000,0x0000,0x0000, /* 2CDE */
0x15AA,0x0000,0x0000,0x0000, 0x15AA,0x0000,0x0000,0x0000, /* 2CE0 */
0x15AB,0x0000,0x0000,0x0000, 0x15AB,0x0000,0x0000,0x0000, /* 2CE2 */
0x157C,0x1571,0x157B,0x0000, 0x0C2A,0x0000,0x0000,0x0000, /* 2CE4 */
0x0C2B,0x0000,0x0000,0x0000, 0x0C2C,0x0000,0x0000,0x0000, /* 2CE6 */
0x0C2D,0x0000,0x0000,0x0000, 0x0C2E,0x0000,0x0000,0x0000, /* 2CE8 */
0x0C2F,0x0000,0x0000,0x0000, 0x1591,0x0000,0x0000,0x0000, /* 2CEA */
0x1591,0x0000,0x0000,0x0000, 0x15A0,0x0000,0x0000,0x0000, /* 2CEC */
0x15A0,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 2CEE */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* 2CF0 */
0xFBC0,0xACF2,0x0000,0x0000, 0xFBC0,0xACF3,0x0000,0x0000, /* 2CF2 */
0xFBC0,0xACF4,0x0000,0x0000, 0xFBC0,0xACF5,0x0000,0x0000, /* 2CF4 */
0xFBC0,0xACF6,0x0000,0x0000, 0xFBC0,0xACF7,0x0000,0x0000, /* 2CF6 */
0xFBC0,0xACF8,0x0000,0x0000, 0x028B,0x0000,0x0000,0x0000, /* 2CF8 */
0x027B,0x0000,0x0000,0x0000, 0x027C,0x0000,0x0000,0x0000, /* 2CFA */
0x02E0,0x0000,0x0000,0x0000, 0x114C,0x0000,0x0000,0x0000, /* 2CFC */
0x028C,0x0000,0x0000,0x0000, 0x02E1,0x0000,0x0000,0x0000  /* 2CFE */
};

uint16 uca520_p02D[]= { /* 2D00 (3 weights per char) */
0x17E5,0x0000,0x0000, 0x17E7,0x0000,0x0000, 0x17E9,0x0000,0x0000, /* 2D00 */
0x17EB,0x0000,0x0000, 0x17ED,0x0000,0x0000, 0x17EF,0x0000,0x0000, /* 2D03 */
0x17F1,0x0000,0x0000, 0x17F5,0x0000,0x0000, 0x17F7,0x0000,0x0000, /* 2D06 */
0x17F9,0x0000,0x0000, 0x17FB,0x0000,0x0000, 0x17FD,0x0000,0x0000, /* 2D09 */
0x17FF,0x0000,0x0000, 0x1803,0x0000,0x0000, 0x1805,0x0000,0x0000, /* 2D0C */
0x1807,0x0000,0x0000, 0x1809,0x0000,0x0000, 0x180B,0x0000,0x0000, /* 2D0F */
0x180D,0x0000,0x0000, 0x1811,0x0000,0x0000, 0x1813,0x0000,0x0000, /* 2D12 */
0x1815,0x0000,0x0000, 0x1817,0x0000,0x0000, 0x1819,0x0000,0x0000, /* 2D15 */
0x181B,0x0000,0x0000, 0x181D,0x0000,0x0000, 0x181F,0x0000,0x0000, /* 2D18 */
0x1821,0x0000,0x0000, 0x1823,0x0000,0x0000, 0x1825,0x0000,0x0000, /* 2D1B */
0x1827,0x0000,0x0000, 0x182B,0x0000,0x0000, 0x182D,0x0000,0x0000, /* 2D1E */
0x17F3,0x0000,0x0000, 0x1801,0x0000,0x0000, 0x180F,0x0000,0x0000, /* 2D21 */
0x1829,0x0000,0x0000, 0x182F,0x0000,0x0000, 0xFBC0,0xAD26,0x0000, /* 2D24 */
0xFBC0,0xAD27,0x0000, 0xFBC0,0xAD28,0x0000, 0xFBC0,0xAD29,0x0000, /* 2D27 */
0xFBC0,0xAD2A,0x0000, 0xFBC0,0xAD2B,0x0000, 0xFBC0,0xAD2C,0x0000, /* 2D2A */
0xFBC0,0xAD2D,0x0000, 0xFBC0,0xAD2E,0x0000, 0xFBC0,0xAD2F,0x0000, /* 2D2D */
0x19CC,0x0000,0x0000, 0x19CD,0x0000,0x0000, 0x19CE,0x0000,0x0000, /* 2D30 */
0x19CF,0x0000,0x0000, 0x19D0,0x0000,0x0000, 0x19D1,0x0000,0x0000, /* 2D33 */
0x19D2,0x0000,0x0000, 0x19D3,0x0000,0x0000, 0x19D4,0x0000,0x0000, /* 2D36 */
0x19D5,0x0000,0x0000, 0x19D6,0x0000,0x0000, 0x19D7,0x0000,0x0000, /* 2D39 */
0x19D8,0x0000,0x0000, 0x19D9,0x0000,0x0000, 0x19DA,0x0000,0x0000, /* 2D3C */
0x19DB,0x0000,0x0000, 0x19DC,0x0000,0x0000, 0x19DD,0x0000,0x0000, /* 2D3F */
0x19DE,0x0000,0x0000, 0x19DF,0x0000,0x0000, 0x19E0,0x0000,0x0000, /* 2D42 */
0x19E1,0x0000,0x0000, 0x19E2,0x0000,0x0000, 0x19E3,0x0000,0x0000, /* 2D45 */
0x19E4,0x0000,0x0000, 0x19E5,0x0000,0x0000, 0x19E6,0x0000,0x0000, /* 2D48 */
0x19E7,0x0000,0x0000, 0x19E8,0x0000,0x0000, 0x19E9,0x0000,0x0000, /* 2D4B */
0x19EA,0x0000,0x0000, 0x19EB,0x0000,0x0000, 0x19EC,0x0000,0x0000, /* 2D4E */
0x19ED,0x0000,0x0000, 0x19EE,0x0000,0x0000, 0x19EF,0x0000,0x0000, /* 2D51 */
0x19F0,0x0000,0x0000, 0x19F1,0x0000,0x0000, 0x19F2,0x0000,0x0000, /* 2D54 */
0x19F3,0x0000,0x0000, 0x19F4,0x0000,0x0000, 0x19F5,0x0000,0x0000, /* 2D57 */
0x19F6,0x0000,0x0000, 0x19F7,0x0000,0x0000, 0x19F8,0x0000,0x0000, /* 2D5A */
0x19F9,0x0000,0x0000, 0x19FA,0x0000,0x0000, 0x19FB,0x0000,0x0000, /* 2D5D */
0x19FC,0x0000,0x0000, 0x19FD,0x0000,0x0000, 0x19FE,0x0000,0x0000, /* 2D60 */
0x19FF,0x0000,0x0000, 0x1A00,0x0000,0x0000, 0x1A01,0x0000,0x0000, /* 2D63 */
0xFBC0,0xAD66,0x0000, 0xFBC0,0xAD67,0x0000, 0xFBC0,0xAD68,0x0000, /* 2D66 */
0xFBC0,0xAD69,0x0000, 0xFBC0,0xAD6A,0x0000, 0xFBC0,0xAD6B,0x0000, /* 2D69 */
0xFBC0,0xAD6C,0x0000, 0xFBC0,0xAD6D,0x0000, 0xFBC0,0xAD6E,0x0000, /* 2D6C */
0x1A02,0x0000,0x0000, 0xFBC0,0xAD70,0x0000, 0xFBC0,0xAD71,0x0000, /* 2D6F */
0xFBC0,0xAD72,0x0000, 0xFBC0,0xAD73,0x0000, 0xFBC0,0xAD74,0x0000, /* 2D72 */
0xFBC0,0xAD75,0x0000, 0xFBC0,0xAD76,0x0000, 0xFBC0,0xAD77,0x0000, /* 2D75 */
0xFBC0,0xAD78,0x0000, 0xFBC0,0xAD79,0x0000, 0xFBC0,0xAD7A,0x0000, /* 2D78 */
0xFBC0,0xAD7B,0x0000, 0xFBC0,0xAD7C,0x0000, 0xFBC0,0xAD7D,0x0000, /* 2D7B */
0xFBC0,0xAD7E,0x0000, 0xFBC0,0xAD7F,0x0000, 0x1A13,0x0000,0x0000, /* 2D7E */
0x1A28,0x0000,0x0000, 0x1A39,0x0000,0x0000, 0x1A42,0x0000,0x0000, /* 2D81 */
0x1A4B,0x0000,0x0000, 0x1A71,0x0000,0x0000, 0x1A82,0x0000,0x0000, /* 2D84 */
0x1A8B,0x0000,0x0000, 0x1AA1,0x0000,0x0000, 0x1AAA,0x0000,0x0000, /* 2D87 */
0x1AB3,0x0000,0x0000, 0x1AE4,0x0000,0x0000, 0x1AFD,0x0000,0x0000, /* 2D8A */
0x1B06,0x0000,0x0000, 0x1B0F,0x0000,0x0000, 0x1B31,0x0000,0x0000, /* 2D8D */
0x1B3A,0x0000,0x0000, 0x1B43,0x0000,0x0000, 0x1B6C,0x0000,0x0000, /* 2D90 */
0x1B25,0x0000,0x0000, 0x1B26,0x0000,0x0000, 0x1B27,0x0000,0x0000, /* 2D93 */
0x1B28,0x0000,0x0000, 0xFBC0,0xAD97,0x0000, 0xFBC0,0xAD98,0x0000, /* 2D96 */
0xFBC0,0xAD99,0x0000, 0xFBC0,0xAD9A,0x0000, 0xFBC0,0xAD9B,0x0000, /* 2D99 */
0xFBC0,0xAD9C,0x0000, 0xFBC0,0xAD9D,0x0000, 0xFBC0,0xAD9E,0x0000, /* 2D9C */
0xFBC0,0xAD9F,0x0000, 0x1B70,0x0000,0x0000, 0x1B71,0x0000,0x0000, /* 2D9F */
0x1B72,0x0000,0x0000, 0x1B73,0x0000,0x0000, 0x1B74,0x0000,0x0000, /* 2DA2 */
0x1B75,0x0000,0x0000, 0x1B76,0x0000,0x0000, 0xFBC0,0xADA7,0x0000, /* 2DA5 */
0x1B77,0x0000,0x0000, 0x1B78,0x0000,0x0000, 0x1B79,0x0000,0x0000, /* 2DA8 */
0x1B7A,0x0000,0x0000, 0x1B7B,0x0000,0x0000, 0x1B7C,0x0000,0x0000, /* 2DAB */
0x1B7D,0x0000,0x0000, 0xFBC0,0xADAF,0x0000, 0x1B7E,0x0000,0x0000, /* 2DAE */
0x1B7F,0x0000,0x0000, 0x1B80,0x0000,0x0000, 0x1B81,0x0000,0x0000, /* 2DB1 */
0x1B82,0x0000,0x0000, 0x1B83,0x0000,0x0000, 0x1B84,0x0000,0x0000, /* 2DB4 */
0xFBC0,0xADB7,0x0000, 0x1B85,0x0000,0x0000, 0x1B86,0x0000,0x0000, /* 2DB7 */
0x1B87,0x0000,0x0000, 0x1B88,0x0000,0x0000, 0x1B89,0x0000,0x0000, /* 2DBA */
0x1B8A,0x0000,0x0000, 0x1B8B,0x0000,0x0000, 0xFBC0,0xADBF,0x0000, /* 2DBD */
0x1B8C,0x0000,0x0000, 0x1B8D,0x0000,0x0000, 0x1B8E,0x0000,0x0000, /* 2DC0 */
0x1B8F,0x0000,0x0000, 0x1B90,0x0000,0x0000, 0x1B91,0x0000,0x0000, /* 2DC3 */
0x1B92,0x0000,0x0000, 0xFBC0,0xADC7,0x0000, 0x1B93,0x0000,0x0000, /* 2DC6 */
0x1B94,0x0000,0x0000, 0x1B95,0x0000,0x0000, 0x1B96,0x0000,0x0000, /* 2DC9 */
0x1B97,0x0000,0x0000, 0x1B98,0x0000,0x0000, 0x1B99,0x0000,0x0000, /* 2DCC */
0xFBC0,0xADCF,0x0000, 0x1B9A,0x0000,0x0000, 0x1B9B,0x0000,0x0000, /* 2DCF */
0x1B9C,0x0000,0x0000, 0x1B9D,0x0000,0x0000, 0x1B9E,0x0000,0x0000, /* 2DD2 */
0x1B9F,0x0000,0x0000, 0x1BA0,0x0000,0x0000, 0xFBC0,0xADD7,0x0000, /* 2DD5 */
0x1BA1,0x0000,0x0000, 0x1BA2,0x0000,0x0000, 0x1BA3,0x0000,0x0000, /* 2DD8 */
0x1BA4,0x0000,0x0000, 0x1BA5,0x0000,0x0000, 0x1BA6,0x0000,0x0000, /* 2DDB */
0x1BA7,0x0000,0x0000, 0xFBC0,0xADDF,0x0000, 0x15C4,0x0000,0x0000, /* 2DDE */
0x15C8,0x0000,0x0000, 0x15CC,0x0000,0x0000, 0x15E0,0x0000,0x0000, /* 2DE1 */
0x1600,0x0000,0x0000, 0x160D,0x0000,0x0000, 0x1643,0x0000,0x0000, /* 2DE4 */
0x165D,0x0000,0x0000, 0x166F,0x0000,0x0000, 0x1678,0x0000,0x0000, /* 2DE7 */
0x1692,0x0000,0x0000, 0x16A2,0x0000,0x0000, 0x16AF,0x0000,0x0000, /* 2DEA */
0x16B8,0x0000,0x0000, 0x16C1,0x0000,0x0000, 0x16F5,0x0000,0x0000, /* 2DED */
0x171B,0x0000,0x0000, 0x1725,0x0000,0x0000, 0x1747,0x0000,0x0000, /* 2DF0 */
0x174C,0x0000,0x0000, 0x179F,0x0000,0x0000, 0x16B8,0x16C1,0x0000, /* 2DF3 */
0x15AC,0x0000,0x0000, 0x15F4,0x0000,0x0000, 0x1642,0x0000,0x0000, /* 2DF6 */
0x16EC,0x0000,0x0000, 0x1768,0x0000,0x0000, 0x1775,0x0000,0x0000, /* 2DF9 */
0x177A,0x0000,0x0000, 0x1784,0x0000,0x0000, 0x1789,0x0000,0x0000, /* 2DFC */
0x1793,0x0000,0x0000  };

uint16 uca520_p02E[]= { /* 2E00 (3 weights per char) */
0x037E,0x0000,0x0000, 0x037F,0x0000,0x0000, 0x0329,0x0000,0x0000, /* 2E00 */
0x032A,0x0000,0x0000, 0x032B,0x0000,0x0000, 0x032C,0x0000,0x0000, /* 2E03 */
0x0380,0x0000,0x0000, 0x0381,0x0000,0x0000, 0x0382,0x0000,0x0000, /* 2E06 */
0x032D,0x0000,0x0000, 0x032E,0x0000,0x0000, 0x0383,0x0000,0x0000, /* 2E09 */
0x032F,0x0000,0x0000, 0x0330,0x0000,0x0000, 0x0384,0x0000,0x0000, /* 2E0C */
0x0385,0x0000,0x0000, 0x0386,0x0000,0x0000, 0x0387,0x0000,0x0000, /* 2E0F */
0x0388,0x0000,0x0000, 0x0389,0x0000,0x0000, 0x038A,0x0000,0x0000, /* 2E12 */
0x038B,0x0000,0x0000, 0x038C,0x0000,0x0000, 0x022F,0x0000,0x0000, /* 2E15 */
0x0280,0x0000,0x0000, 0x02E2,0x0000,0x0000, 0x038D,0x0000,0x0000, /* 2E18 */
0x038E,0x0000,0x0000, 0x0331,0x0000,0x0000, 0x0332,0x0000,0x0000, /* 2E1B */
0x038F,0x0000,0x0000, 0x0390,0x0000,0x0000, 0x0333,0x0000,0x0000, /* 2E1E */
0x0334,0x0000,0x0000, 0x0335,0x0000,0x0000, 0x0336,0x0000,0x0000, /* 2E21 */
0x0337,0x0000,0x0000, 0x0338,0x0000,0x0000, 0x0339,0x0000,0x0000, /* 2E24 */
0x033A,0x0000,0x0000, 0x033B,0x0000,0x0000, 0x033C,0x0000,0x0000, /* 2E27 */
0x02DC,0x0000,0x0000, 0x02DD,0x0000,0x0000, 0x02DE,0x0000,0x0000, /* 2E2A */
0x02DF,0x0000,0x0000, 0x0275,0x0000,0x0000, 0x1751,0x0000,0x0000, /* 2E2D */
0x028D,0x0000,0x0000, 0x0293,0x0000,0x0000, 0xFBC0,0xAE32,0x0000, /* 2E30 */
0xFBC0,0xAE33,0x0000, 0xFBC0,0xAE34,0x0000, 0xFBC0,0xAE35,0x0000, /* 2E33 */
0xFBC0,0xAE36,0x0000, 0xFBC0,0xAE37,0x0000, 0xFBC0,0xAE38,0x0000, /* 2E36 */
0xFBC0,0xAE39,0x0000, 0xFBC0,0xAE3A,0x0000, 0xFBC0,0xAE3B,0x0000, /* 2E39 */
0xFBC0,0xAE3C,0x0000, 0xFBC0,0xAE3D,0x0000, 0xFBC0,0xAE3E,0x0000, /* 2E3C */
0xFBC0,0xAE3F,0x0000, 0xFBC0,0xAE40,0x0000, 0xFBC0,0xAE41,0x0000, /* 2E3F */
0xFBC0,0xAE42,0x0000, 0xFBC0,0xAE43,0x0000, 0xFBC0,0xAE44,0x0000, /* 2E42 */
0xFBC0,0xAE45,0x0000, 0xFBC0,0xAE46,0x0000, 0xFBC0,0xAE47,0x0000, /* 2E45 */
0xFBC0,0xAE48,0x0000, 0xFBC0,0xAE49,0x0000, 0xFBC0,0xAE4A,0x0000, /* 2E48 */
0xFBC0,0xAE4B,0x0000, 0xFBC0,0xAE4C,0x0000, 0xFBC0,0xAE4D,0x0000, /* 2E4B */
0xFBC0,0xAE4E,0x0000, 0xFBC0,0xAE4F,0x0000, 0xFBC0,0xAE50,0x0000, /* 2E4E */
0xFBC0,0xAE51,0x0000, 0xFBC0,0xAE52,0x0000, 0xFBC0,0xAE53,0x0000, /* 2E51 */
0xFBC0,0xAE54,0x0000, 0xFBC0,0xAE55,0x0000, 0xFBC0,0xAE56,0x0000, /* 2E54 */
0xFBC0,0xAE57,0x0000, 0xFBC0,0xAE58,0x0000, 0xFBC0,0xAE59,0x0000, /* 2E57 */
0xFBC0,0xAE5A,0x0000, 0xFBC0,0xAE5B,0x0000, 0xFBC0,0xAE5C,0x0000, /* 2E5A */
0xFBC0,0xAE5D,0x0000, 0xFBC0,0xAE5E,0x0000, 0xFBC0,0xAE5F,0x0000, /* 2E5D */
0xFBC0,0xAE60,0x0000, 0xFBC0,0xAE61,0x0000, 0xFBC0,0xAE62,0x0000, /* 2E60 */
0xFBC0,0xAE63,0x0000, 0xFBC0,0xAE64,0x0000, 0xFBC0,0xAE65,0x0000, /* 2E63 */
0xFBC0,0xAE66,0x0000, 0xFBC0,0xAE67,0x0000, 0xFBC0,0xAE68,0x0000, /* 2E66 */
0xFBC0,0xAE69,0x0000, 0xFBC0,0xAE6A,0x0000, 0xFBC0,0xAE6B,0x0000, /* 2E69 */
0xFBC0,0xAE6C,0x0000, 0xFBC0,0xAE6D,0x0000, 0xFBC0,0xAE6E,0x0000, /* 2E6C */
0xFBC0,0xAE6F,0x0000, 0xFBC0,0xAE70,0x0000, 0xFBC0,0xAE71,0x0000, /* 2E6F */
0xFBC0,0xAE72,0x0000, 0xFBC0,0xAE73,0x0000, 0xFBC0,0xAE74,0x0000, /* 2E72 */
0xFBC0,0xAE75,0x0000, 0xFBC0,0xAE76,0x0000, 0xFBC0,0xAE77,0x0000, /* 2E75 */
0xFBC0,0xAE78,0x0000, 0xFBC0,0xAE79,0x0000, 0xFBC0,0xAE7A,0x0000, /* 2E78 */
0xFBC0,0xAE7B,0x0000, 0xFBC0,0xAE7C,0x0000, 0xFBC0,0xAE7D,0x0000, /* 2E7B */
0xFBC0,0xAE7E,0x0000, 0xFBC0,0xAE7F,0x0000, 0xFB40,0xCE36,0x0000, /* 2E7E */
0xFB40,0xD382,0x0000, 0xFB40,0xCE5B,0x0000, 0xFB40,0xCE5A,0x0000, /* 2E81 */
0xFB40,0xCE59,0x0000, 0xFB40,0xCEBB,0x0000, 0xFB40,0xD182,0x0000, /* 2E84 */
0xFB40,0xD1E0,0x0000, 0xFB40,0xD200,0x0000, 0xFB40,0xD202,0x0000, /* 2E87 */
0xFB40,0xD35C,0x0000, 0xFB40,0xD369,0x0000, 0xFB40,0xDC0F,0x0000, /* 2E8A */
0xFB40,0xDC0F,0x0000, 0xFB40,0xDC22,0x0000, 0xFB40,0xDC23,0x0000, /* 2E8D */
0xFB40,0xDC22,0x0000, 0xFB40,0xDC23,0x0000, 0xFB40,0xDDF3,0x0000, /* 2E90 */
0xFB40,0xDE7A,0x0000, 0xFB40,0xDF51,0x0000, 0xFB40,0xDF50,0x0000, /* 2E93 */
0xFB40,0xDFC4,0x0000, 0xFB40,0xDFC3,0x0000, 0xFB40,0xE24C,0x0000, /* 2E96 */
0xFB40,0xE535,0x0000, 0xFBC0,0xAE9A,0x0000, 0xFB40,0xE5E1,0x0000, /* 2E99 */
0xFB40,0xE5E5,0x0000, 0xFB40,0xE708,0x0000, 0xFB40,0xEB7A,0x0000, /* 2E9C */
0xFB40,0xEBCD,0x0000, 0xFB40,0xEC11,0x0000, 0xFB40,0xEC35,0x0000, /* 2E9F */
0xFB40,0xEC3A,0x0000, 0xFB40,0xF06C,0x0000, 0xFB40,0xF22B,0x0000, /* 2EA2 */
0xFB40,0xF22B,0x0000, 0xFB40,0xCE2C,0x0000, 0xFB40,0xF25B,0x0000, /* 2EA5 */
0xFB40,0xF2AD,0x0000, 0xFB40,0xF38B,0x0000, 0xFB40,0xF58B,0x0000, /* 2EA8 */
0xFB40,0xF6EE,0x0000, 0xFB40,0xF93A,0x0000, 0xFB40,0xF93B,0x0000, /* 2EAB */
0xFB40,0xFAF9,0x0000, 0xFB40,0xFCF9,0x0000, 0xFB40,0xFE9F,0x0000, /* 2EAE */
0xFB40,0xFF53,0x0000, 0xFB40,0xFF52,0x0000, 0xFB40,0xFF53,0x0000, /* 2EB1 */
0xFB40,0xFF53,0x0000, 0xFB40,0xFF52,0x0000, 0xFB40,0xFF8A,0x0000, /* 2EB4 */
0xFB40,0xFF8A,0x0000, 0xFB40,0xFF8B,0x0000, 0xFB41,0x8002,0x0000, /* 2EB7 */
0xFB41,0x8080,0x0000, 0xFB41,0x807F,0x0000, 0xFB41,0x8089,0x0000, /* 2EBA */
0xFB41,0x81FC,0x0000, 0xFB41,0x8279,0x0000, 0xFB41,0x8279,0x0000, /* 2EBD */
0xFB41,0x8279,0x0000, 0xFB41,0x864E,0x0000, 0xFB41,0x8864,0x0000, /* 2EC0 */
0xFB41,0x8980,0x0000, 0xFB41,0x897F,0x0000, 0xFB41,0x89C1,0x0000, /* 2EC3 */
0xFB41,0x89D2,0x0000, 0xFB41,0x89D2,0x0000, 0xFB41,0x8BA0,0x0000, /* 2EC6 */
0xFB41,0x8D1D,0x0000, 0xFB41,0x8DB3,0x0000, 0xFB41,0x8F66,0x0000, /* 2EC9 */
0xFB41,0x8FB6,0x0000, 0xFB41,0x8FB6,0x0000, 0xFB41,0x8FB6,0x0000, /* 2ECC */
0xFB41,0x9091,0x0000, 0xFB41,0x9485,0x0000, 0xFB41,0x9577,0x0000, /* 2ECF */
0xFB41,0x9578,0x0000, 0xFB41,0x957F,0x0000, 0xFB41,0x95E8,0x0000, /* 2ED2 */
0xFB41,0x961C,0x0000, 0xFB41,0x961D,0x0000, 0xFB41,0x96E8,0x0000, /* 2ED5 */
0xFB41,0x9752,0x0000, 0xFB41,0x97E6,0x0000, 0xFB41,0x9875,0x0000, /* 2ED8 */
0xFB41,0x98CE,0x0000, 0xFB41,0x98DE,0x0000, 0xFB41,0x98DF,0x0000, /* 2EDB */
0xFB41,0x98E0,0x0000, 0xFB41,0x98E0,0x0000, 0xFB41,0x9963,0x0000, /* 2EDE */
0xFB41,0x9996,0x0000, 0xFB41,0x9A6C,0x0000, 0xFB41,0x9AA8,0x0000, /* 2EE1 */
0xFB41,0x9B3C,0x0000, 0xFB41,0x9C7C,0x0000, 0xFB41,0x9E1F,0x0000, /* 2EE4 */
0xFB41,0x9E75,0x0000, 0xFB41,0x9EA6,0x0000, 0xFB41,0x9EC4,0x0000, /* 2EE7 */
0xFB41,0x9EFE,0x0000, 0xFB41,0x9F4A,0x0000, 0xFB41,0x9F50,0x0000, /* 2EEA */
0xFB41,0x9F52,0x0000, 0xFB41,0x9F7F,0x0000, 0xFB41,0x9F8D,0x0000, /* 2EED */
0xFB41,0x9F99,0x0000, 0xFB41,0x9F9C,0x0000, 0xFB41,0x9F9C,0x0000, /* 2EF0 */
0xFB41,0x9F9F,0x0000, 0xFBC0,0xAEF4,0x0000, 0xFBC0,0xAEF5,0x0000, /* 2EF3 */
0xFBC0,0xAEF6,0x0000, 0xFBC0,0xAEF7,0x0000, 0xFBC0,0xAEF8,0x0000, /* 2EF6 */
0xFBC0,0xAEF9,0x0000, 0xFBC0,0xAEFA,0x0000, 0xFBC0,0xAEFB,0x0000, /* 2EF9 */
0xFBC0,0xAEFC,0x0000, 0xFBC0,0xAEFD,0x0000, 0xFBC0,0xAEFE,0x0000, /* 2EFC */
0xFBC0,0xAEFF,0x0000  };

uint16 uca520_p02F[]= { /* 2F00 (3 weights per char) */
0xFB40,0xCE00,0x0000, 0xFB40,0xCE28,0x0000, 0xFB40,0xCE36,0x0000, /* 2F00 */
0xFB40,0xCE3F,0x0000, 0xFB40,0xCE59,0x0000, 0xFB40,0xCE85,0x0000, /* 2F03 */
0xFB40,0xCE8C,0x0000, 0xFB40,0xCEA0,0x0000, 0xFB40,0xCEBA,0x0000, /* 2F06 */
0xFB40,0xD13F,0x0000, 0xFB40,0xD165,0x0000, 0xFB40,0xD16B,0x0000, /* 2F09 */
0xFB40,0xD182,0x0000, 0xFB40,0xD196,0x0000, 0xFB40,0xD1AB,0x0000, /* 2F0C */
0xFB40,0xD1E0,0x0000, 0xFB40,0xD1F5,0x0000, 0xFB40,0xD200,0x0000, /* 2F0F */
0xFB40,0xD29B,0x0000, 0xFB40,0xD2F9,0x0000, 0xFB40,0xD315,0x0000, /* 2F12 */
0xFB40,0xD31A,0x0000, 0xFB40,0xD338,0x0000, 0xFB40,0xD341,0x0000, /* 2F15 */
0xFB40,0xD35C,0x0000, 0xFB40,0xD369,0x0000, 0xFB40,0xD382,0x0000, /* 2F18 */
0xFB40,0xD3B6,0x0000, 0xFB40,0xD3C8,0x0000, 0xFB40,0xD3E3,0x0000, /* 2F1B */
0xFB40,0xD6D7,0x0000, 0xFB40,0xD71F,0x0000, 0xFB40,0xD8EB,0x0000, /* 2F1E */
0xFB40,0xD902,0x0000, 0xFB40,0xD90A,0x0000, 0xFB40,0xD915,0x0000, /* 2F21 */
0xFB40,0xD927,0x0000, 0xFB40,0xD973,0x0000, 0xFB40,0xDB50,0x0000, /* 2F24 */
0xFB40,0xDB80,0x0000, 0xFB40,0xDBF8,0x0000, 0xFB40,0xDC0F,0x0000, /* 2F27 */
0xFB40,0xDC22,0x0000, 0xFB40,0xDC38,0x0000, 0xFB40,0xDC6E,0x0000, /* 2F2A */
0xFB40,0xDC71,0x0000, 0xFB40,0xDDDB,0x0000, 0xFB40,0xDDE5,0x0000, /* 2F2D */
0xFB40,0xDDF1,0x0000, 0xFB40,0xDDFE,0x0000, 0xFB40,0xDE72,0x0000, /* 2F30 */
0xFB40,0xDE7A,0x0000, 0xFB40,0xDE7F,0x0000, 0xFB40,0xDEF4,0x0000, /* 2F33 */
0xFB40,0xDEFE,0x0000, 0xFB40,0xDF0B,0x0000, 0xFB40,0xDF13,0x0000, /* 2F36 */
0xFB40,0xDF50,0x0000, 0xFB40,0xDF61,0x0000, 0xFB40,0xDF73,0x0000, /* 2F39 */
0xFB40,0xDFC3,0x0000, 0xFB40,0xE208,0x0000, 0xFB40,0xE236,0x0000, /* 2F3C */
0xFB40,0xE24B,0x0000, 0xFB40,0xE52F,0x0000, 0xFB40,0xE534,0x0000, /* 2F3F */
0xFB40,0xE587,0x0000, 0xFB40,0xE597,0x0000, 0xFB40,0xE5A4,0x0000, /* 2F42 */
0xFB40,0xE5B9,0x0000, 0xFB40,0xE5E0,0x0000, 0xFB40,0xE5E5,0x0000, /* 2F45 */
0xFB40,0xE6F0,0x0000, 0xFB40,0xE708,0x0000, 0xFB40,0xE728,0x0000, /* 2F48 */
0xFB40,0xEB20,0x0000, 0xFB40,0xEB62,0x0000, 0xFB40,0xEB79,0x0000, /* 2F4B */
0xFB40,0xEBB3,0x0000, 0xFB40,0xEBCB,0x0000, 0xFB40,0xEBD4,0x0000, /* 2F4E */
0xFB40,0xEBDB,0x0000, 0xFB40,0xEC0F,0x0000, 0xFB40,0xEC14,0x0000, /* 2F51 */
0xFB40,0xEC34,0x0000, 0xFB40,0xF06B,0x0000, 0xFB40,0xF22A,0x0000, /* 2F54 */
0xFB40,0xF236,0x0000, 0xFB40,0xF23B,0x0000, 0xFB40,0xF23F,0x0000, /* 2F57 */
0xFB40,0xF247,0x0000, 0xFB40,0xF259,0x0000, 0xFB40,0xF25B,0x0000, /* 2F5A */
0xFB40,0xF2AC,0x0000, 0xFB40,0xF384,0x0000, 0xFB40,0xF389,0x0000, /* 2F5D */
0xFB40,0xF4DC,0x0000, 0xFB40,0xF4E6,0x0000, 0xFB40,0xF518,0x0000, /* 2F60 */
0xFB40,0xF51F,0x0000, 0xFB40,0xF528,0x0000, 0xFB40,0xF530,0x0000, /* 2F63 */
0xFB40,0xF58B,0x0000, 0xFB40,0xF592,0x0000, 0xFB40,0xF676,0x0000, /* 2F66 */
0xFB40,0xF67D,0x0000, 0xFB40,0xF6AE,0x0000, 0xFB40,0xF6BF,0x0000, /* 2F69 */
0xFB40,0xF6EE,0x0000, 0xFB40,0xF7DB,0x0000, 0xFB40,0xF7E2,0x0000, /* 2F6C */
0xFB40,0xF7F3,0x0000, 0xFB40,0xF93A,0x0000, 0xFB40,0xF9B8,0x0000, /* 2F6F */
0xFB40,0xF9BE,0x0000, 0xFB40,0xFA74,0x0000, 0xFB40,0xFACB,0x0000, /* 2F72 */
0xFB40,0xFAF9,0x0000, 0xFB40,0xFC73,0x0000, 0xFB40,0xFCF8,0x0000, /* 2F75 */
0xFB40,0xFF36,0x0000, 0xFB40,0xFF51,0x0000, 0xFB40,0xFF8A,0x0000, /* 2F78 */
0xFB40,0xFFBD,0x0000, 0xFB41,0x8001,0x0000, 0xFB41,0x800C,0x0000, /* 2F7B */
0xFB41,0x8012,0x0000, 0xFB41,0x8033,0x0000, 0xFB41,0x807F,0x0000, /* 2F7E */
0xFB41,0x8089,0x0000, 0xFB41,0x81E3,0x0000, 0xFB41,0x81EA,0x0000, /* 2F81 */
0xFB41,0x81F3,0x0000, 0xFB41,0x81FC,0x0000, 0xFB41,0x820C,0x0000, /* 2F84 */
0xFB41,0x821B,0x0000, 0xFB41,0x821F,0x0000, 0xFB41,0x826E,0x0000, /* 2F87 */
0xFB41,0x8272,0x0000, 0xFB41,0x8278,0x0000, 0xFB41,0x864D,0x0000, /* 2F8A */
0xFB41,0x866B,0x0000, 0xFB41,0x8840,0x0000, 0xFB41,0x884C,0x0000, /* 2F8D */
0xFB41,0x8863,0x0000, 0xFB41,0x897E,0x0000, 0xFB41,0x898B,0x0000, /* 2F90 */
0xFB41,0x89D2,0x0000, 0xFB41,0x8A00,0x0000, 0xFB41,0x8C37,0x0000, /* 2F93 */
0xFB41,0x8C46,0x0000, 0xFB41,0x8C55,0x0000, 0xFB41,0x8C78,0x0000, /* 2F96 */
0xFB41,0x8C9D,0x0000, 0xFB41,0x8D64,0x0000, 0xFB41,0x8D70,0x0000, /* 2F99 */
0xFB41,0x8DB3,0x0000, 0xFB41,0x8EAB,0x0000, 0xFB41,0x8ECA,0x0000, /* 2F9C */
0xFB41,0x8F9B,0x0000, 0xFB41,0x8FB0,0x0000, 0xFB41,0x8FB5,0x0000, /* 2F9F */
0xFB41,0x9091,0x0000, 0xFB41,0x9149,0x0000, 0xFB41,0x91C6,0x0000, /* 2FA2 */
0xFB41,0x91CC,0x0000, 0xFB41,0x91D1,0x0000, 0xFB41,0x9577,0x0000, /* 2FA5 */
0xFB41,0x9580,0x0000, 0xFB41,0x961C,0x0000, 0xFB41,0x96B6,0x0000, /* 2FA8 */
0xFB41,0x96B9,0x0000, 0xFB41,0x96E8,0x0000, 0xFB41,0x9751,0x0000, /* 2FAB */
0xFB41,0x975E,0x0000, 0xFB41,0x9762,0x0000, 0xFB41,0x9769,0x0000, /* 2FAE */
0xFB41,0x97CB,0x0000, 0xFB41,0x97ED,0x0000, 0xFB41,0x97F3,0x0000, /* 2FB1 */
0xFB41,0x9801,0x0000, 0xFB41,0x98A8,0x0000, 0xFB41,0x98DB,0x0000, /* 2FB4 */
0xFB41,0x98DF,0x0000, 0xFB41,0x9996,0x0000, 0xFB41,0x9999,0x0000, /* 2FB7 */
0xFB41,0x99AC,0x0000, 0xFB41,0x9AA8,0x0000, 0xFB41,0x9AD8,0x0000, /* 2FBA */
0xFB41,0x9ADF,0x0000, 0xFB41,0x9B25,0x0000, 0xFB41,0x9B2F,0x0000, /* 2FBD */
0xFB41,0x9B32,0x0000, 0xFB41,0x9B3C,0x0000, 0xFB41,0x9B5A,0x0000, /* 2FC0 */
0xFB41,0x9CE5,0x0000, 0xFB41,0x9E75,0x0000, 0xFB41,0x9E7F,0x0000, /* 2FC3 */
0xFB41,0x9EA5,0x0000, 0xFB41,0x9EBB,0x0000, 0xFB41,0x9EC3,0x0000, /* 2FC6 */
0xFB41,0x9ECD,0x0000, 0xFB41,0x9ED1,0x0000, 0xFB41,0x9EF9,0x0000, /* 2FC9 */
0xFB41,0x9EFD,0x0000, 0xFB41,0x9F0E,0x0000, 0xFB41,0x9F13,0x0000, /* 2FCC */
0xFB41,0x9F20,0x0000, 0xFB41,0x9F3B,0x0000, 0xFB41,0x9F4A,0x0000, /* 2FCF */
0xFB41,0x9F52,0x0000, 0xFB41,0x9F8D,0x0000, 0xFB41,0x9F9C,0x0000, /* 2FD2 */
0xFB41,0x9FA0,0x0000, 0xFBC0,0xAFD6,0x0000, 0xFBC0,0xAFD7,0x0000, /* 2FD5 */
0xFBC0,0xAFD8,0x0000, 0xFBC0,0xAFD9,0x0000, 0xFBC0,0xAFDA,0x0000, /* 2FD8 */
0xFBC0,0xAFDB,0x0000, 0xFBC0,0xAFDC,0x0000, 0xFBC0,0xAFDD,0x0000, /* 2FDB */
0xFBC0,0xAFDE,0x0000, 0xFBC0,0xAFDF,0x0000, 0xFBC0,0xAFE0,0x0000, /* 2FDE */
0xFBC0,0xAFE1,0x0000, 0xFBC0,0xAFE2,0x0000, 0xFBC0,0xAFE3,0x0000, /* 2FE1 */
0xFBC0,0xAFE4,0x0000, 0xFBC0,0xAFE5,0x0000, 0xFBC0,0xAFE6,0x0000, /* 2FE4 */
0xFBC0,0xAFE7,0x0000, 0xFBC0,0xAFE8,0x0000, 0xFBC0,0xAFE9,0x0000, /* 2FE7 */
0xFBC0,0xAFEA,0x0000, 0xFBC0,0xAFEB,0x0000, 0xFBC0,0xAFEC,0x0000, /* 2FEA */
0xFBC0,0xAFED,0x0000, 0xFBC0,0xAFEE,0x0000, 0xFBC0,0xAFEF,0x0000, /* 2FED */
0x10D4,0x0000,0x0000, 0x10D5,0x0000,0x0000, 0x10D6,0x0000,0x0000, /* 2FF0 */
0x10D7,0x0000,0x0000, 0x10D8,0x0000,0x0000, 0x10D9,0x0000,0x0000, /* 2FF3 */
0x10DA,0x0000,0x0000, 0x10DB,0x0000,0x0000, 0x10DC,0x0000,0x0000, /* 2FF6 */
0x10DD,0x0000,0x0000, 0x10DE,0x0000,0x0000, 0x10DF,0x0000,0x0000, /* 2FF9 */
0xFBC0,0xAFFC,0x0000, 0xFBC0,0xAFFD,0x0000, 0xFBC0,0xAFFE,0x0000, /* 2FFC */
0xFBC0,0xAFFF,0x0000  };

uint16 uca520_p030[]= { /* 3000 (3 weights per char) */
0x020A,0x0000,0x0000, 0x0240,0x0000,0x0000, 0x0291,0x0000,0x0000, /* 3000 */
0x0374,0x0000,0x0000, 0x1104,0x0000,0x0000, 0x11D7,0x0000,0x0000, /* 3003 */
0x2B20,0x2B36,0x0000, 0x1205,0x0000,0x0000, 0x033D,0x0000,0x0000, /* 3006 */
0x033E,0x0000,0x0000, 0x033F,0x0000,0x0000, 0x0340,0x0000,0x0000, /* 3009 */
0x0341,0x0000,0x0000, 0x0342,0x0000,0x0000, 0x0343,0x0000,0x0000, /* 300C */
0x0344,0x0000,0x0000, 0x0345,0x0000,0x0000, 0x0346,0x0000,0x0000, /* 300F */
0x1105,0x0000,0x0000, 0x1106,0x0000,0x0000, 0x0347,0x0000,0x0000, /* 3012 */
0x0348,0x0000,0x0000, 0x0349,0x0000,0x0000, 0x034A,0x0000,0x0000, /* 3015 */
0x034B,0x0000,0x0000, 0x034C,0x0000,0x0000, 0x034D,0x0000,0x0000, /* 3018 */
0x034E,0x0000,0x0000, 0x0230,0x0000,0x0000, 0x02FA,0x0000,0x0000, /* 301B */
0x02FB,0x0000,0x0000, 0x02FC,0x0000,0x0000, 0x1107,0x0000,0x0000, /* 301E */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 3021 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 3024 */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 3027 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 302A */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 302D */
0x0231,0x0000,0x0000, 0x11D9,0x0000,0x0000, 0x11D9,0x0000,0x0000, /* 3030 */
0x11DA,0x0000,0x0000, 0x11DA,0x0000,0x0000, 0x11DB,0x0000,0x0000, /* 3033 */
0x1105,0x0000,0x0000, 0x1108,0x0000,0x0000, 0xFB40,0xD341,0x0000, /* 3036 */
0xFB40,0xD344,0x0000, 0xFB40,0xD345,0x0000, 0x11D8,0x0000,0x0000, /* 3039 */
0x2B33,0x2B21,0x0000, 0x0375,0x0000,0x0000, 0x1109,0x0000,0x0000, /* 303C */
0x110A,0x0000,0x0000, 0xFBC0,0xB040,0x0000, 0x2B15,0x0000,0x0000, /* 303F */
0x2B15,0x0000,0x0000, 0x2B16,0x0000,0x0000, 0x2B16,0x0000,0x0000, /* 3042 */
0x2B17,0x0000,0x0000, 0x2B17,0x0000,0x0000, 0x2B18,0x0000,0x0000, /* 3045 */
0x2B18,0x0000,0x0000, 0x2B19,0x0000,0x0000, 0x2B19,0x0000,0x0000, /* 3048 */
0x2B1A,0x0000,0x0000, 0x2B1A,0x0000,0x0000, 0x2B1B,0x0000,0x0000, /* 304B */
0x2B1B,0x0000,0x0000, 0x2B1C,0x0000,0x0000, 0x2B1C,0x0000,0x0000, /* 304E */
0x2B1D,0x0000,0x0000, 0x2B1D,0x0000,0x0000, 0x2B1E,0x0000,0x0000, /* 3051 */
0x2B1E,0x0000,0x0000, 0x2B1F,0x0000,0x0000, 0x2B1F,0x0000,0x0000, /* 3054 */
0x2B20,0x0000,0x0000, 0x2B20,0x0000,0x0000, 0x2B21,0x0000,0x0000, /* 3057 */
0x2B21,0x0000,0x0000, 0x2B22,0x0000,0x0000, 0x2B22,0x0000,0x0000, /* 305A */
0x2B23,0x0000,0x0000, 0x2B23,0x0000,0x0000, 0x2B24,0x0000,0x0000, /* 305D */
0x2B24,0x0000,0x0000, 0x2B25,0x0000,0x0000, 0x2B25,0x0000,0x0000, /* 3060 */
0x2B26,0x0000,0x0000, 0x2B26,0x0000,0x0000, 0x2B26,0x0000,0x0000, /* 3063 */
0x2B27,0x0000,0x0000, 0x2B27,0x0000,0x0000, 0x2B28,0x0000,0x0000, /* 3066 */
0x2B28,0x0000,0x0000, 0x2B29,0x0000,0x0000, 0x2B2A,0x0000,0x0000, /* 3069 */
0x2B2B,0x0000,0x0000, 0x2B2C,0x0000,0x0000, 0x2B2D,0x0000,0x0000, /* 306C */
0x2B2E,0x0000,0x0000, 0x2B2E,0x0000,0x0000, 0x2B2E,0x0000,0x0000, /* 306F */
0x2B2F,0x0000,0x0000, 0x2B2F,0x0000,0x0000, 0x2B2F,0x0000,0x0000, /* 3072 */
0x2B30,0x0000,0x0000, 0x2B30,0x0000,0x0000, 0x2B30,0x0000,0x0000, /* 3075 */
0x2B31,0x0000,0x0000, 0x2B31,0x0000,0x0000, 0x2B31,0x0000,0x0000, /* 3078 */
0x2B32,0x0000,0x0000, 0x2B32,0x0000,0x0000, 0x2B32,0x0000,0x0000, /* 307B */
0x2B33,0x0000,0x0000, 0x2B34,0x0000,0x0000, 0x2B35,0x0000,0x0000, /* 307E */
0x2B36,0x0000,0x0000, 0x2B37,0x0000,0x0000, 0x2B38,0x0000,0x0000, /* 3081 */
0x2B38,0x0000,0x0000, 0x2B39,0x0000,0x0000, 0x2B39,0x0000,0x0000, /* 3084 */
0x2B3A,0x0000,0x0000, 0x2B3A,0x0000,0x0000, 0x2B3B,0x0000,0x0000, /* 3087 */
0x2B3C,0x0000,0x0000, 0x2B3D,0x0000,0x0000, 0x2B3E,0x0000,0x0000, /* 308A */
0x2B3F,0x0000,0x0000, 0x2B40,0x0000,0x0000, 0x2B40,0x0000,0x0000, /* 308D */
0x2B41,0x0000,0x0000, 0x2B42,0x0000,0x0000, 0x2B43,0x0000,0x0000, /* 3090 */
0x2B44,0x0000,0x0000, 0x2B17,0x0000,0x0000, 0x2B1A,0x0000,0x0000, /* 3093 */
0x2B1D,0x0000,0x0000, 0xFBC0,0xB097,0x0000, 0xFBC0,0xB098,0x0000, /* 3096 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0220,0x0000,0x0000, /* 3099 */
0x0221,0x0000,0x0000, 0x11DC,0x0000,0x0000, 0x11DC,0x0000,0x0000, /* 309C */
0x2B3A,0x2B3C,0x0000, 0x0232,0x0000,0x0000, 0x2B15,0x0000,0x0000, /* 309F */
0x2B15,0x0000,0x0000, 0x2B16,0x0000,0x0000, 0x2B16,0x0000,0x0000, /* 30A2 */
0x2B17,0x0000,0x0000, 0x2B17,0x0000,0x0000, 0x2B18,0x0000,0x0000, /* 30A5 */
0x2B18,0x0000,0x0000, 0x2B19,0x0000,0x0000, 0x2B19,0x0000,0x0000, /* 30A8 */
0x2B1A,0x0000,0x0000, 0x2B1A,0x0000,0x0000, 0x2B1B,0x0000,0x0000, /* 30AB */
0x2B1B,0x0000,0x0000, 0x2B1C,0x0000,0x0000, 0x2B1C,0x0000,0x0000, /* 30AE */
0x2B1D,0x0000,0x0000, 0x2B1D,0x0000,0x0000, 0x2B1E,0x0000,0x0000, /* 30B1 */
0x2B1E,0x0000,0x0000, 0x2B1F,0x0000,0x0000, 0x2B1F,0x0000,0x0000, /* 30B4 */
0x2B20,0x0000,0x0000, 0x2B20,0x0000,0x0000, 0x2B21,0x0000,0x0000, /* 30B7 */
0x2B21,0x0000,0x0000, 0x2B22,0x0000,0x0000, 0x2B22,0x0000,0x0000, /* 30BA */
0x2B23,0x0000,0x0000, 0x2B23,0x0000,0x0000, 0x2B24,0x0000,0x0000, /* 30BD */
0x2B24,0x0000,0x0000, 0x2B25,0x0000,0x0000, 0x2B25,0x0000,0x0000, /* 30C0 */
0x2B26,0x0000,0x0000, 0x2B26,0x0000,0x0000, 0x2B26,0x0000,0x0000, /* 30C3 */
0x2B27,0x0000,0x0000, 0x2B27,0x0000,0x0000, 0x2B28,0x0000,0x0000, /* 30C6 */
0x2B28,0x0000,0x0000, 0x2B29,0x0000,0x0000, 0x2B2A,0x0000,0x0000, /* 30C9 */
0x2B2B,0x0000,0x0000, 0x2B2C,0x0000,0x0000, 0x2B2D,0x0000,0x0000, /* 30CC */
0x2B2E,0x0000,0x0000, 0x2B2E,0x0000,0x0000, 0x2B2E,0x0000,0x0000, /* 30CF */
0x2B2F,0x0000,0x0000, 0x2B2F,0x0000,0x0000, 0x2B2F,0x0000,0x0000, /* 30D2 */
0x2B30,0x0000,0x0000, 0x2B30,0x0000,0x0000, 0x2B30,0x0000,0x0000, /* 30D5 */
0x2B31,0x0000,0x0000, 0x2B31,0x0000,0x0000, 0x2B31,0x0000,0x0000, /* 30D8 */
0x2B32,0x0000,0x0000, 0x2B32,0x0000,0x0000, 0x2B32,0x0000,0x0000, /* 30DB */
0x2B33,0x0000,0x0000, 0x2B34,0x0000,0x0000, 0x2B35,0x0000,0x0000, /* 30DE */
0x2B36,0x0000,0x0000, 0x2B37,0x0000,0x0000, 0x2B38,0x0000,0x0000, /* 30E1 */
0x2B38,0x0000,0x0000, 0x2B39,0x0000,0x0000, 0x2B39,0x0000,0x0000, /* 30E4 */
0x2B3A,0x0000,0x0000, 0x2B3A,0x0000,0x0000, 0x2B3B,0x0000,0x0000, /* 30E7 */
0x2B3C,0x0000,0x0000, 0x2B3D,0x0000,0x0000, 0x2B3E,0x0000,0x0000, /* 30EA */
0x2B3F,0x0000,0x0000, 0x2B40,0x0000,0x0000, 0x2B40,0x0000,0x0000, /* 30ED */
0x2B41,0x0000,0x0000, 0x2B42,0x0000,0x0000, 0x2B43,0x0000,0x0000, /* 30F0 */
0x2B44,0x0000,0x0000, 0x2B17,0x0000,0x0000, 0x2B1A,0x0000,0x0000, /* 30F3 */
0x2B1D,0x0000,0x0000, 0x2B40,0x0000,0x0000, 0x2B41,0x0000,0x0000, /* 30F6 */
0x2B42,0x0000,0x0000, 0x2B43,0x0000,0x0000, 0x0233,0x0000,0x0000, /* 30F9 */
0x11DD,0x0000,0x0000, 0x11DE,0x0000,0x0000, 0x11DE,0x0000,0x0000, /* 30FC */
0x2B1E,0x2B28,0x0000  };

uint16 uca520_p031[]= { /* 3100 (3 weights per char) */
0xFBC0,0xB100,0x0000, 0xFBC0,0xB101,0x0000, 0xFBC0,0xB102,0x0000, /* 3100 */
0xFBC0,0xB103,0x0000, 0xFBC0,0xB104,0x0000, 0x2B45,0x0000,0x0000, /* 3103 */
0x2B46,0x0000,0x0000, 0x2B47,0x0000,0x0000, 0x2B48,0x0000,0x0000, /* 3106 */
0x2B4A,0x0000,0x0000, 0x2B4B,0x0000,0x0000, 0x2B4C,0x0000,0x0000, /* 3109 */
0x2B4D,0x0000,0x0000, 0x2B4E,0x0000,0x0000, 0x2B4F,0x0000,0x0000, /* 310C */
0x2B52,0x0000,0x0000, 0x2B53,0x0000,0x0000, 0x2B54,0x0000,0x0000, /* 310F */
0x2B55,0x0000,0x0000, 0x2B57,0x0000,0x0000, 0x2B58,0x0000,0x0000, /* 3112 */
0x2B59,0x0000,0x0000, 0x2B5A,0x0000,0x0000, 0x2B5B,0x0000,0x0000, /* 3115 */
0x2B5C,0x0000,0x0000, 0x2B5D,0x0000,0x0000, 0x2B5E,0x0000,0x0000, /* 3118 */
0x2B5F,0x0000,0x0000, 0x2B61,0x0000,0x0000, 0x2B62,0x0000,0x0000, /* 311B */
0x2B64,0x0000,0x0000, 0x2B65,0x0000,0x0000, 0x2B66,0x0000,0x0000, /* 311E */
0x2B67,0x0000,0x0000, 0x2B68,0x0000,0x0000, 0x2B69,0x0000,0x0000, /* 3121 */
0x2B6A,0x0000,0x0000, 0x2B6C,0x0000,0x0000, 0x2B70,0x0000,0x0000, /* 3124 */
0x2B71,0x0000,0x0000, 0x2B72,0x0000,0x0000, 0x2B73,0x0000,0x0000, /* 3127 */
0x2B49,0x0000,0x0000, 0x2B50,0x0000,0x0000, 0x2B56,0x0000,0x0000, /* 312A */
0x2B74,0x0000,0x0000, 0xFBC0,0xB12E,0x0000, 0xFBC0,0xB12F,0x0000, /* 312D */
0xFBC0,0xB130,0x0000, 0x29B0,0x0000,0x0000, 0x29B1,0x0000,0x0000, /* 3130 */
0x2A8E,0x0000,0x0000, 0x29B2,0x0000,0x0000, 0x2A90,0x0000,0x0000, /* 3133 */
0x2A91,0x0000,0x0000, 0x29B3,0x0000,0x0000, 0x29B4,0x0000,0x0000, /* 3136 */
0x29B5,0x0000,0x0000, 0x2A94,0x0000,0x0000, 0x2A95,0x0000,0x0000, /* 3139 */
0x2A96,0x0000,0x0000, 0x2A97,0x0000,0x0000, 0x2A98,0x0000,0x0000, /* 313C */
0x2A99,0x0000,0x0000, 0x29CA,0x0000,0x0000, 0x29B6,0x0000,0x0000, /* 313F */
0x29B7,0x0000,0x0000, 0x29B8,0x0000,0x0000, 0x29D1,0x0000,0x0000, /* 3142 */
0x29B9,0x0000,0x0000, 0x29BA,0x0000,0x0000, 0x29BB,0x0000,0x0000, /* 3145 */
0x29BC,0x0000,0x0000, 0x29BD,0x0000,0x0000, 0x29BE,0x0000,0x0000, /* 3148 */
0x29BF,0x0000,0x0000, 0x29C0,0x0000,0x0000, 0x29C1,0x0000,0x0000, /* 314B */
0x29C2,0x0000,0x0000, 0x2A2E,0x0000,0x0000, 0x2A2F,0x0000,0x0000, /* 314E */
0x2A30,0x0000,0x0000, 0x2A31,0x0000,0x0000, 0x2A32,0x0000,0x0000, /* 3151 */
0x2A33,0x0000,0x0000, 0x2A34,0x0000,0x0000, 0x2A35,0x0000,0x0000, /* 3154 */
0x2A36,0x0000,0x0000, 0x2A37,0x0000,0x0000, 0x2A38,0x0000,0x0000, /* 3157 */
0x2A39,0x0000,0x0000, 0x2A3A,0x0000,0x0000, 0x2A3B,0x0000,0x0000, /* 315A */
0x2A3C,0x0000,0x0000, 0x2A3D,0x0000,0x0000, 0x2A3E,0x0000,0x0000, /* 315D */
0x2A3F,0x0000,0x0000, 0x2A40,0x0000,0x0000, 0x2A41,0x0000,0x0000, /* 3160 */
0x2A42,0x0000,0x0000, 0x2A2D,0x0000,0x0000, 0x29C4,0x0000,0x0000, /* 3163 */
0x29C5,0x0000,0x0000, 0x2AAB,0x0000,0x0000, 0x2AAC,0x0000,0x0000, /* 3166 */
0x2AB0,0x0000,0x0000, 0x2AB2,0x0000,0x0000, 0x2AB7,0x0000,0x0000, /* 3169 */
0x2ABB,0x0000,0x0000, 0x2ABD,0x0000,0x0000, 0x29CC,0x0000,0x0000, /* 316C */
0x2AC1,0x0000,0x0000, 0x2AC3,0x0000,0x0000, 0x29CD,0x0000,0x0000, /* 316F */
0x29CE,0x0000,0x0000, 0x29D0,0x0000,0x0000, 0x29D2,0x0000,0x0000, /* 3172 */
0x29D3,0x0000,0x0000, 0x29D7,0x0000,0x0000, 0x29D9,0x0000,0x0000, /* 3175 */
0x29DB,0x0000,0x0000, 0x29DC,0x0000,0x0000, 0x29DD,0x0000,0x0000, /* 3178 */
0x29DE,0x0000,0x0000, 0x29DF,0x0000,0x0000, 0x29E2,0x0000,0x0000, /* 317B */
0x29E6,0x0000,0x0000, 0x29F0,0x0000,0x0000, 0x29F7,0x0000,0x0000, /* 317E */
0x29FC,0x0000,0x0000, 0x2AD5,0x0000,0x0000, 0x2AD6,0x0000,0x0000, /* 3181 */
0x2A07,0x0000,0x0000, 0x2A08,0x0000,0x0000, 0x2A09,0x0000,0x0000, /* 3184 */
0x2A51,0x0000,0x0000, 0x2A52,0x0000,0x0000, 0x2A55,0x0000,0x0000, /* 3187 */
0x2A5E,0x0000,0x0000, 0x2A5F,0x0000,0x0000, 0x2A61,0x0000,0x0000, /* 318A */
0x2A6B,0x0000,0x0000, 0x2A6E,0x0000,0x0000, 0xFBC0,0xB18F,0x0000, /* 318D */
0x110B,0x0000,0x0000, 0x110C,0x0000,0x0000, 0xFB40,0xCE00,0x0000, /* 3190 */
0xFB40,0xCE8C,0x0000, 0xFB40,0xCE09,0x0000, 0xFB40,0xD6DB,0x0000, /* 3193 */
0xFB40,0xCE0A,0x0000, 0xFB40,0xCE2D,0x0000, 0xFB40,0xCE0B,0x0000, /* 3196 */
0xFB40,0xF532,0x0000, 0xFB40,0xCE59,0x0000, 0xFB40,0xCE19,0x0000, /* 3199 */
0xFB40,0xCE01,0x0000, 0xFB40,0xD929,0x0000, 0xFB40,0xD730,0x0000, /* 319C */
0xFB40,0xCEBA,0x0000, 0x2B45,0x0000,0x0000, 0x2B5B,0x0000,0x0000, /* 319F */
0x2B53,0x0000,0x0000, 0x2B4E,0x0000,0x0000, 0x2B63,0x0000,0x0000, /* 31A2 */
0x2B63,0x0000,0x0000, 0x2B60,0x0000,0x0000, 0x2B5F,0x0000,0x0000, /* 31A5 */
0x2B72,0x0000,0x0000, 0x2B5E,0x0000,0x0000, 0x2B71,0x0000,0x0000, /* 31A8 */
0x2B72,0x0000,0x0000, 0x2B6F,0x0000,0x0000, 0x2B51,0x0000,0x0000, /* 31AB */
0x2B64,0x0000,0x0000, 0x2B66,0x0000,0x0000, 0x2B6D,0x0000,0x0000, /* 31AE */
0x2B6E,0x0000,0x0000, 0x2B6B,0x0000,0x0000, 0x2B71,0x0000,0x0000, /* 31B1 */
0x2B46,0x0000,0x0000, 0x2B4B,0x0000,0x0000, 0x2B4F,0x0000,0x0000, /* 31B4 */
0x2B52,0x0000,0x0000, 0xFBC0,0xB1B8,0x0000, 0xFBC0,0xB1B9,0x0000, /* 31B7 */
0xFBC0,0xB1BA,0x0000, 0xFBC0,0xB1BB,0x0000, 0xFBC0,0xB1BC,0x0000, /* 31BA */
0xFBC0,0xB1BD,0x0000, 0xFBC0,0xB1BE,0x0000, 0xFBC0,0xB1BF,0x0000, /* 31BD */
0x10E0,0x0000,0x0000, 0x10E1,0x0000,0x0000, 0x10E2,0x0000,0x0000, /* 31C0 */
0x10E3,0x0000,0x0000, 0x10E4,0x0000,0x0000, 0x10E5,0x0000,0x0000, /* 31C3 */
0x10E6,0x0000,0x0000, 0x10E7,0x0000,0x0000, 0x10E8,0x0000,0x0000, /* 31C6 */
0x10E9,0x0000,0x0000, 0x10EA,0x0000,0x0000, 0x10EB,0x0000,0x0000, /* 31C9 */
0x10EC,0x0000,0x0000, 0x10ED,0x0000,0x0000, 0x10EE,0x0000,0x0000, /* 31CC */
0x10EF,0x0000,0x0000, 0x10F0,0x0000,0x0000, 0x10F1,0x0000,0x0000, /* 31CF */
0x10F2,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F4,0x0000,0x0000, /* 31D2 */
0x10F5,0x0000,0x0000, 0x10F6,0x0000,0x0000, 0x10F7,0x0000,0x0000, /* 31D5 */
0x10F8,0x0000,0x0000, 0x10F9,0x0000,0x0000, 0x10FA,0x0000,0x0000, /* 31D8 */
0x10FB,0x0000,0x0000, 0x10FC,0x0000,0x0000, 0x10FD,0x0000,0x0000, /* 31DB */
0x10FE,0x0000,0x0000, 0x10FF,0x0000,0x0000, 0x1100,0x0000,0x0000, /* 31DE */
0x1101,0x0000,0x0000, 0x1102,0x0000,0x0000, 0x1103,0x0000,0x0000, /* 31E1 */
0xFBC0,0xB1E4,0x0000, 0xFBC0,0xB1E5,0x0000, 0xFBC0,0xB1E6,0x0000, /* 31E4 */
0xFBC0,0xB1E7,0x0000, 0xFBC0,0xB1E8,0x0000, 0xFBC0,0xB1E9,0x0000, /* 31E7 */
0xFBC0,0xB1EA,0x0000, 0xFBC0,0xB1EB,0x0000, 0xFBC0,0xB1EC,0x0000, /* 31EA */
0xFBC0,0xB1ED,0x0000, 0xFBC0,0xB1EE,0x0000, 0xFBC0,0xB1EF,0x0000, /* 31ED */
0x2B1C,0x0000,0x0000, 0x2B20,0x0000,0x0000, 0x2B21,0x0000,0x0000, /* 31F0 */
0x2B28,0x0000,0x0000, 0x2B2B,0x0000,0x0000, 0x2B2E,0x0000,0x0000, /* 31F3 */
0x2B2F,0x0000,0x0000, 0x2B30,0x0000,0x0000, 0x2B31,0x0000,0x0000, /* 31F6 */
0x2B32,0x0000,0x0000, 0x2B35,0x0000,0x0000, 0x2B3B,0x0000,0x0000, /* 31F9 */
0x2B3C,0x0000,0x0000, 0x2B3D,0x0000,0x0000, 0x2B3E,0x0000,0x0000, /* 31FC */
0x2B3F,0x0000,0x0000  };

uint16 uca520_p032[]= { /* 3200 (8 weights per char) */
0x02FF,0x29B0,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3200 */
0x02FF,0x29B2,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3201 */
0x02FF,0x29B3,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3202 */
0x02FF,0x29B5,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3203 */
0x02FF,0x29B6,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3204 */
0x02FF,0x29B7,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3205 */
0x02FF,0x29B9,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3206 */
0x02FF,0x29BB,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3207 */
0x02FF,0x29BC,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3208 */
0x02FF,0x29BE,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3209 */
0x02FF,0x29BF,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, /* 320A */
0x02FF,0x29C0,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, /* 320B */
0x02FF,0x29C1,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, /* 320C */
0x02FF,0x29C2,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, /* 320D */
0x02FF,0x29B0,0x2A2E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 320E */
0x02FF,0x29B2,0x2A2E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 320F */
0x02FF,0x29B3,0x2A2E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3210 */
0x02FF,0x29B5,0x2A2E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3211 */
0x02FF,0x29B6,0x2A2E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3212 */
0x02FF,0x29B7,0x2A2E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3213 */
0x02FF,0x29B9,0x2A2E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3214 */
0x02FF,0x29BB,0x2A2E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3215 */
0x02FF,0x29BC,0x2A2E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3216 */
0x02FF,0x29BE,0x2A2E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3217 */
0x02FF,0x29BF,0x2A2E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3218 */
0x02FF,0x29C0,0x2A2E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3219 */
0x02FF,0x29C1,0x2A2E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 321A */
0x02FF,0x29C2,0x2A2E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 321B */
0x02FF,0x29BC,0x2A3B,0x0300,0x0000,0x0000,0x0000,0x0000, /* 321C */
0x02FF,0x29BB,0x2A36,0x29BC,0x2A32,0x2A8F,0x0300,0x0000, /* 321D */
0x02FF,0x29BB,0x2A36,0x29C2,0x2A3B,0x0300,0x0000,0x0000, /* 321E */
0xFBC0,0xB21F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 321F */
0x02FF,0xFB40,0xCE00,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3220 */
0x02FF,0xFB40,0xCE8C,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3221 */
0x02FF,0xFB40,0xCE09,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3222 */
0x02FF,0xFB40,0xD6DB,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3223 */
0x02FF,0xFB40,0xCE94,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3224 */
0x02FF,0xFB40,0xD16D,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3225 */
0x02FF,0xFB40,0xCE03,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3226 */
0x02FF,0xFB40,0xD16B,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3227 */
0x02FF,0xFB40,0xCE5D,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3228 */
0x02FF,0xFB40,0xD341,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3229 */
0x02FF,0xFB40,0xE708,0x0300,0x0000,0x0000,0x0000,0x0000, /* 322A */
0x02FF,0xFB40,0xF06B,0x0300,0x0000,0x0000,0x0000,0x0000, /* 322B */
0x02FF,0xFB40,0xEC34,0x0300,0x0000,0x0000,0x0000,0x0000, /* 322C */
0x02FF,0xFB40,0xE728,0x0300,0x0000,0x0000,0x0000,0x0000, /* 322D */
0x02FF,0xFB41,0x91D1,0x0300,0x0000,0x0000,0x0000,0x0000, /* 322E */
0x02FF,0xFB40,0xD71F,0x0300,0x0000,0x0000,0x0000,0x0000, /* 322F */
0x02FF,0xFB40,0xE5E5,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3230 */
0x02FF,0xFB40,0xE82A,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3231 */
0x02FF,0xFB40,0xE709,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3232 */
0x02FF,0xFB40,0xF93E,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3233 */
0x02FF,0xFB40,0xD40D,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3234 */
0x02FF,0xFB40,0xF279,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3235 */
0x02FF,0xFB41,0x8CA1,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3236 */
0x02FF,0xFB40,0xF95D,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3237 */
0x02FF,0xFB40,0xD2B4,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3238 */
0x02FF,0xFB40,0xCEE3,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3239 */
0x02FF,0xFB40,0xD47C,0x0300,0x0000,0x0000,0x0000,0x0000, /* 323A */
0x02FF,0xFB40,0xDB66,0x0300,0x0000,0x0000,0x0000,0x0000, /* 323B */
0x02FF,0xFB40,0xF6E3,0x0300,0x0000,0x0000,0x0000,0x0000, /* 323C */
0x02FF,0xFB40,0xCF01,0x0300,0x0000,0x0000,0x0000,0x0000, /* 323D */
0x02FF,0xFB41,0x8CC7,0x0300,0x0000,0x0000,0x0000,0x0000, /* 323E */
0x02FF,0xFB40,0xD354,0x0300,0x0000,0x0000,0x0000,0x0000, /* 323F */
0x02FF,0xFB40,0xF96D,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3240 */
0x02FF,0xFB40,0xCF11,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3241 */
0x02FF,0xFB41,0x81EA,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3242 */
0x02FF,0xFB41,0x81F3,0x0300,0x0000,0x0000,0x0000,0x0000, /* 3243 */
0xFB40,0xD54F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3244 */
0xFB40,0xDE7C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3245 */
0xFB40,0xE587,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3246 */
0xFB40,0xFB8F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3247 */
0x1206,0x1205,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3248 */
0x1207,0x1205,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3249 */
0x1208,0x1205,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 324A */
0x1209,0x1205,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 324B */
0x120A,0x1205,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 324C */
0x120B,0x1205,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 324D */
0x120C,0x1205,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 324E */
0x120D,0x1205,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 324F */
0x13B3,0x1433,0x126B,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3250 */
0x1207,0x1206,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3251 */
0x1207,0x1207,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3252 */
0x1207,0x1208,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3253 */
0x1207,0x1209,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3254 */
0x1207,0x120A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3255 */
0x1207,0x120B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3256 */
0x1207,0x120C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3257 */
0x1207,0x120D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3258 */
0x1207,0x120E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3259 */
0x1208,0x1205,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 325A */
0x1208,0x1206,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 325B */
0x1208,0x1207,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 325C */
0x1208,0x1208,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 325D */
0x1208,0x1209,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 325E */
0x1208,0x120A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 325F */
0x29B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3260 */
0x29B2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3261 */
0x29B3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3262 */
0x29B5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3263 */
0x29B6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3264 */
0x29B7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3265 */
0x29B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3266 */
0x29BB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3267 */
0x29BC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3268 */
0x29BE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3269 */
0x29BF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 326A */
0x29C0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 326B */
0x29C1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 326C */
0x29C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 326D */
0x29B0,0x2A2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 326E */
0x29B2,0x2A2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 326F */
0x29B3,0x2A2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3270 */
0x29B5,0x2A2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3271 */
0x29B6,0x2A2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3272 */
0x29B7,0x2A2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3273 */
0x29B9,0x2A2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3274 */
0x29BB,0x2A2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3275 */
0x29BC,0x2A2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3276 */
0x29BE,0x2A2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3277 */
0x29BF,0x2A2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3278 */
0x29C0,0x2A2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3279 */
0x29C1,0x2A2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 327A */
0x29C2,0x2A2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 327B */
0x29BE,0x2A2E,0x2A9B,0x29B0,0x2A36,0x0000,0x0000,0x0000, /* 327C */
0x29BC,0x2A3B,0x29BB,0x2A41,0x0000,0x0000,0x0000,0x0000, /* 327D */
0x29BB,0x2A3B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 327E */
0x110D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 327F */
0xFB40,0xCE00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3280 */
0xFB40,0xCE8C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3281 */
0xFB40,0xCE09,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3282 */
0xFB40,0xD6DB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3283 */
0xFB40,0xCE94,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3284 */
0xFB40,0xD16D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3285 */
0xFB40,0xCE03,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3286 */
0xFB40,0xD16B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3287 */
0xFB40,0xCE5D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3288 */
0xFB40,0xD341,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3289 */
0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 328A */
0xFB40,0xF06B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 328B */
0xFB40,0xEC34,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 328C */
0xFB40,0xE728,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 328D */
0xFB41,0x91D1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 328E */
0xFB40,0xD71F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 328F */
0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3290 */
0xFB40,0xE82A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3291 */
0xFB40,0xE709,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3292 */
0xFB40,0xF93E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3293 */
0xFB40,0xD40D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3294 */
0xFB40,0xF279,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3295 */
0xFB41,0x8CA1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3296 */
0xFB40,0xF95D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3297 */
0xFB40,0xD2B4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3298 */
0xFB40,0xF9D8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3299 */
0xFB40,0xF537,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 329A */
0xFB40,0xD973,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 329B */
0xFB41,0x9069,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 329C */
0xFB40,0xD12A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 329D */
0xFB40,0xD370,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 329E */
0xFB40,0xECE8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 329F */
0xFB41,0x9805,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32A0 */
0xFB40,0xCF11,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32A1 */
0xFB40,0xD199,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32A2 */
0xFB40,0xEB63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32A3 */
0xFB40,0xCE0A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32A4 */
0xFB40,0xCE2D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32A5 */
0xFB40,0xCE0B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32A6 */
0xFB40,0xDDE6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32A7 */
0xFB40,0xD3F3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32A8 */
0xFB40,0xD33B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32A9 */
0xFB40,0xDB97,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32AA */
0xFB40,0xDB66,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32AB */
0xFB40,0xF6E3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32AC */
0xFB40,0xCF01,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32AD */
0xFB41,0x8CC7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32AE */
0xFB40,0xD354,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32AF */
0xFB40,0xD91C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32B0 */
0x1208,0x120B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32B1 */
0x1208,0x120C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32B2 */
0x1208,0x120D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32B3 */
0x1208,0x120E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32B4 */
0x1209,0x1205,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32B5 */
0x1209,0x1206,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32B6 */
0x1209,0x1207,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32B7 */
0x1209,0x1208,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32B8 */
0x1209,0x1209,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32B9 */
0x1209,0x120A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32BA */
0x1209,0x120B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32BB */
0x1209,0x120C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32BC */
0x1209,0x120D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32BD */
0x1209,0x120E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32BE */
0x120A,0x1205,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32BF */
0x1206,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32C0 */
0x1207,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32C1 */
0x1208,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32C2 */
0x1209,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32C3 */
0x120A,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32C4 */
0x120B,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32C5 */
0x120C,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32C6 */
0x120D,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32C7 */
0x120E,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32C8 */
0x1206,0x1205,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000, /* 32C9 */
0x1206,0x1206,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000, /* 32CA */
0x1206,0x1207,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000, /* 32CB */
0x12D3,0x12B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32CC */
0x126B,0x13DA,0x12B0,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32CD */
0x126B,0x147B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32CE */
0x1330,0x1433,0x1250,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32CF */
0x2B15,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32D0 */
0x2B16,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32D1 */
0x2B17,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32D2 */
0x2B18,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32D3 */
0x2B19,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32D4 */
0x2B1A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32D5 */
0x2B1B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32D6 */
0x2B1C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32D7 */
0x2B1D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32D8 */
0x2B1E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32D9 */
0x2B1F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32DA */
0x2B20,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32DB */
0x2B21,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32DC */
0x2B22,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32DD */
0x2B23,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32DE */
0x2B24,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32DF */
0x2B25,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32E0 */
0x2B26,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32E1 */
0x2B27,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32E2 */
0x2B28,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32E3 */
0x2B29,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32E4 */
0x2B2A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32E5 */
0x2B2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32E6 */
0x2B2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32E7 */
0x2B2D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32E8 */
0x2B2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32E9 */
0x2B2F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32EA */
0x2B30,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32EB */
0x2B31,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32EC */
0x2B32,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32ED */
0x2B33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32EE */
0x2B34,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32EF */
0x2B35,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32F0 */
0x2B36,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32F1 */
0x2B37,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32F2 */
0x2B38,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32F3 */
0x2B39,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32F4 */
0x2B3A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32F5 */
0x2B3B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32F6 */
0x2B3C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32F7 */
0x2B3D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32F8 */
0x2B3E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32F9 */
0x2B3F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32FA */
0x2B40,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32FB */
0x2B41,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32FC */
0x2B42,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32FD */
0x2B43,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 32FE */
0xFBC0,0xB2FF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000  /* 32FF */
};

uint16 uca520_p033[]= { /* 3300 (9 weights per char) */
0x2B15,0x2B2E,0x11DD,0x2B28,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3300 */
0x2B15,0x2B3D,0x2B30,0x2B15,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3301 */
0x2B15,0x2B44,0x2B31,0x2B15,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3302 */
0x2B15,0x11DD,0x2B3D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3303 */
0x2B16,0x2B2A,0x2B44,0x2B1C,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3304 */
0x2B16,0x2B44,0x2B25,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3305 */
0x2B17,0x2B19,0x2B44,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3306 */
0x2B18,0x2B21,0x2B1C,0x11DD,0x2B28,0x0000,0x0000,0x0000,0x0000, /* 3307 */
0x2B18,0x11DD,0x2B1A,0x11DD,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3308 */
0x2B19,0x2B44,0x2B21,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3309 */
0x2B19,0x11DD,0x2B35,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 330A */
0x2B1A,0x2B16,0x2B3C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 330B */
0x2B1A,0x2B3B,0x2B26,0x2B28,0x0000,0x0000,0x0000,0x0000,0x0000, /* 330C */
0x2B1A,0x2B3F,0x2B3C,0x11DD,0x0000,0x0000,0x0000,0x0000,0x0000, /* 330D */
0x2B1A,0x2B3F,0x2B44,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 330E */
0x2B1A,0x2B44,0x2B33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 330F */
0x2B1B,0x2B1A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3310 */
0x2B1B,0x2B2A,0x11DD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3311 */
0x2B1B,0x2B39,0x2B3C,0x11DD,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3312 */
0x2B1B,0x2B3D,0x2B24,0x11DD,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3313 */
0x2B1B,0x2B3F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3314 */
0x2B1B,0x2B3F,0x2B1C,0x2B3B,0x2B35,0x0000,0x0000,0x0000,0x0000, /* 3315 */
0x2B1B,0x2B3F,0x2B36,0x11DD,0x2B28,0x2B3D,0x0000,0x0000,0x0000, /* 3316 */
0x2B1B,0x2B3F,0x2B40,0x2B26,0x2B28,0x0000,0x0000,0x0000,0x0000, /* 3317 */
0x2B1C,0x2B3B,0x2B35,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3318 */
0x2B1C,0x2B3B,0x2B35,0x2B28,0x2B44,0x0000,0x0000,0x0000,0x0000, /* 3319 */
0x2B1C,0x2B3D,0x2B22,0x2B16,0x2B3F,0x0000,0x0000,0x0000,0x0000, /* 331A */
0x2B1C,0x2B3F,0x11DD,0x2B2C,0x0000,0x0000,0x0000,0x0000,0x0000, /* 331B */
0x2B1D,0x11DD,0x2B21,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 331C */
0x2B1E,0x2B3D,0x2B29,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 331D */
0x2B1E,0x11DD,0x2B32,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 331E */
0x2B1F,0x2B16,0x2B1C,0x2B3D,0x0000,0x0000,0x0000,0x0000,0x0000, /* 331F */
0x2B1F,0x2B44,0x2B25,0x11DD,0x2B35,0x0000,0x0000,0x0000,0x0000, /* 3320 */
0x2B20,0x2B3C,0x2B44,0x2B1C,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3321 */
0x2B22,0x2B44,0x2B25,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3322 */
0x2B22,0x2B44,0x2B28,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3323 */
0x2B24,0x11DD,0x2B21,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3324 */
0x2B27,0x2B20,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3325 */
0x2B28,0x2B3D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3326 */
0x2B28,0x2B44,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3327 */
0x2B29,0x2B2D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3328 */
0x2B2D,0x2B26,0x2B28,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3329 */
0x2B2E,0x2B16,0x2B26,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 332A */
0x2B2E,0x11DD,0x2B22,0x2B44,0x2B28,0x0000,0x0000,0x0000,0x0000, /* 332B */
0x2B2E,0x11DD,0x2B26,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 332C */
0x2B2E,0x11DD,0x2B3E,0x2B3D,0x0000,0x0000,0x0000,0x0000,0x0000, /* 332D */
0x2B2F,0x2B15,0x2B21,0x2B28,0x2B3D,0x0000,0x0000,0x0000,0x0000, /* 332E */
0x2B2F,0x2B1C,0x2B3D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 332F */
0x2B2F,0x2B1E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3330 */
0x2B2F,0x2B3D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3331 */
0x2B30,0x2B15,0x2B3B,0x2B26,0x2B28,0x0000,0x0000,0x0000,0x0000, /* 3332 */
0x2B30,0x2B16,0x11DD,0x2B28,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3333 */
0x2B30,0x2B26,0x2B20,0x2B18,0x2B3D,0x0000,0x0000,0x0000,0x0000, /* 3334 */
0x2B30,0x2B3B,0x2B44,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3335 */
0x2B31,0x2B1C,0x2B24,0x11DD,0x2B3D,0x0000,0x0000,0x0000,0x0000, /* 3336 */
0x2B31,0x2B23,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3337 */
0x2B31,0x2B2A,0x2B2F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3338 */
0x2B31,0x2B3D,0x2B26,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3339 */
0x2B31,0x2B44,0x2B21,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 333A */
0x2B31,0x11DD,0x2B20,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 333B */
0x2B31,0x11DD,0x2B24,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 333C */
0x2B32,0x2B16,0x2B44,0x2B28,0x0000,0x0000,0x0000,0x0000,0x0000, /* 333D */
0x2B32,0x2B3D,0x2B28,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 333E */
0x2B32,0x2B44,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 333F */
0x2B32,0x2B44,0x2B28,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3340 */
0x2B32,0x11DD,0x2B3D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3341 */
0x2B32,0x11DD,0x2B44,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3342 */
0x2B33,0x2B16,0x2B1C,0x2B3F,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3343 */
0x2B33,0x2B16,0x2B3D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3344 */
0x2B33,0x2B26,0x2B2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3345 */
0x2B33,0x2B3D,0x2B1C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3346 */
0x2B33,0x2B44,0x2B20,0x2B3A,0x2B44,0x0000,0x0000,0x0000,0x0000, /* 3347 */
0x2B34,0x2B1C,0x2B3F,0x2B44,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3348 */
0x2B34,0x2B3C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3349 */
0x2B34,0x2B3C,0x2B2E,0x11DD,0x2B3D,0x0000,0x0000,0x0000,0x0000, /* 334A */
0x2B36,0x2B1A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 334B */
0x2B36,0x2B1A,0x2B28,0x2B44,0x0000,0x0000,0x0000,0x0000,0x0000, /* 334C */
0x2B36,0x11DD,0x2B28,0x2B3D,0x0000,0x0000,0x0000,0x0000,0x0000, /* 334D */
0x2B38,0x11DD,0x2B28,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 334E */
0x2B38,0x11DD,0x2B3D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 334F */
0x2B39,0x2B15,0x2B44,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3350 */
0x2B3C,0x2B26,0x2B28,0x2B3D,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3351 */
0x2B3C,0x2B3B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3352 */
0x2B3D,0x2B2F,0x11DD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3353 */
0x2B3D,0x11DD,0x2B30,0x2B3D,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3354 */
0x2B3E,0x2B35,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3355 */
0x2B3E,0x2B44,0x2B28,0x2B1D,0x2B44,0x0000,0x0000,0x0000,0x0000, /* 3356 */
0x2B40,0x2B26,0x2B28,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3357 */
0x1205,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3358 */
0x1206,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3359 */
0x1207,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 335A */
0x1208,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 335B */
0x1209,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 335C */
0x120A,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 335D */
0x120B,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 335E */
0x120C,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 335F */
0x120D,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3360 */
0x120E,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3361 */
0x1206,0x1205,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3362 */
0x1206,0x1206,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3363 */
0x1206,0x1207,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3364 */
0x1206,0x1208,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3365 */
0x1206,0x1209,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3366 */
0x1206,0x120A,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3367 */
0x1206,0x120B,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3368 */
0x1206,0x120C,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3369 */
0x1206,0x120D,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 336A */
0x1206,0x120E,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 336B */
0x1207,0x1205,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 336C */
0x1207,0x1206,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 336D */
0x1207,0x1207,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 336E */
0x1207,0x1208,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 336F */
0x1207,0x1209,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3370 */
0x12D3,0x13B3,0x120F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3371 */
0x1250,0x120F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3372 */
0x120F,0x1453,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3373 */
0x1225,0x120F,0x13DA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3374 */
0x138E,0x147B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3375 */
0x13B3,0x123D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3376 */
0x1250,0x135F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3377 */
0x1250,0x135F,0x1207,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3378 */
0x1250,0x135F,0x1208,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3379 */
0x12EC,0x1453,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 337A */
0xFB40,0xDE73,0xFB40,0xE210,0x0000,0x0000,0x0000,0x0000,0x0000, /* 337B */
0xFB40,0xE62D,0xFB40,0xD48C,0x0000,0x0000,0x0000,0x0000,0x0000, /* 337C */
0xFB40,0xD927,0xFB40,0xEB63,0x0000,0x0000,0x0000,0x0000,0x0000, /* 337D */
0xFB40,0xE60E,0xFB40,0xECBB,0x0000,0x0000,0x0000,0x0000,0x0000, /* 337E */
0xFB40,0xE82A,0xFB40,0xDF0F,0xFB40,0xCF1A,0xFB40,0xF93E,0x0000, /* 337F */
0x13B3,0x120F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3380 */
0x136D,0x120F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3381 */
0x1557,0x120F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3382 */
0x135F,0x120F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3383 */
0x131E,0x120F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3384 */
0x131E,0x1225,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3385 */
0x135F,0x1225,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3386 */
0x12B0,0x1225,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3387 */
0x123D,0x120F,0x1330,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3388 */
0x131E,0x123D,0x120F,0x1330,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3389 */
0x13B3,0x12A3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 338A */
0x136D,0x12A3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 338B */
0x1557,0x12A3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 338C */
0x1557,0x12B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 338D */
0x135F,0x12B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 338E */
0x131E,0x12B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 338F */
0x12D3,0x14AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3390 */
0x131E,0x12D3,0x14AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3391 */
0x135F,0x12D3,0x14AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3392 */
0x12B0,0x12D3,0x14AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3393 */
0x1433,0x12D3,0x14AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3394 */
0x1557,0x1330,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3395 */
0x135F,0x1330,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3396 */
0x1250,0x1330,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3397 */
0x131E,0x1330,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3398 */
0x12A3,0x135F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 3399 */
0x136D,0x135F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 339A */
0x1557,0x135F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 339B */
0x135F,0x135F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 339C */
0x123D,0x135F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 339D */
0x131E,0x135F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 339E */
0x135F,0x135F,0x1207,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 339F */
0x123D,0x135F,0x1207,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33A0 */
0x135F,0x1207,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33A1 */
0x131E,0x135F,0x1207,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33A2 */
0x135F,0x135F,0x1208,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33A3 */
0x123D,0x135F,0x1208,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33A4 */
0x135F,0x1208,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33A5 */
0x131E,0x135F,0x1208,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33A6 */
0x135F,0x055F,0x1410,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33A7 */
0x135F,0x055F,0x1410,0x1207,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33A8 */
0x13B3,0x120F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33A9 */
0x131E,0x13B3,0x120F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33AA */
0x135F,0x13B3,0x120F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33AB */
0x12B0,0x13B3,0x120F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33AC */
0x13DA,0x120F,0x1250,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33AD */
0x13DA,0x120F,0x1250,0x055F,0x1410,0x0000,0x0000,0x0000,0x0000, /* 33AE */
0x13DA,0x120F,0x1250,0x055F,0x1410,0x1207,0x0000,0x0000,0x0000, /* 33AF */
0x13B3,0x1410,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33B0 */
0x136D,0x1410,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33B1 */
0x1557,0x1410,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33B2 */
0x135F,0x1410,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33B3 */
0x13B3,0x147B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33B4 */
0x136D,0x147B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33B5 */
0x1557,0x147B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33B6 */
0x135F,0x147B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33B7 */
0x131E,0x147B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33B8 */
0x135F,0x147B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33B9 */
0x13B3,0x148D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33BA */
0x136D,0x148D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33BB */
0x1557,0x148D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33BC */
0x135F,0x148D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33BD */
0x131E,0x148D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33BE */
0x135F,0x148D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33BF */
0x131E,0x156D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33C0 */
0x135F,0x156D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33C1 */
0x120F,0x0281,0x135F,0x0281,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33C2 */
0x1225,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33C3 */
0x123D,0x123D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33C4 */
0x123D,0x1250,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33C5 */
0x123D,0x055F,0x131E,0x12B0,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33C6 */
0x123D,0x138E,0x0281,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33C7 */
0x1250,0x1225,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33C8 */
0x12B0,0x149C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33C9 */
0x12D3,0x120F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33CA */
0x12D3,0x13B3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33CB */
0x12EC,0x136D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33CC */
0x131E,0x131E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33CD */
0x131E,0x135F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33CE */
0x131E,0x1433,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33CF */
0x1330,0x135F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33D0 */
0x1330,0x136D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33D1 */
0x1330,0x138E,0x12B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33D2 */
0x1330,0x1497,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33D3 */
0x135F,0x1225,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33D4 */
0x135F,0x12EC,0x1330,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33D5 */
0x135F,0x138E,0x1330,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33D6 */
0x13B3,0x12D3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33D7 */
0x13B3,0x0281,0x135F,0x0281,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33D8 */
0x13B3,0x13B3,0x135F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33D9 */
0x13B3,0x13DA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33DA */
0x1410,0x13DA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33DB */
0x1410,0x147B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33DC */
0x148D,0x1225,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33DD */
0x147B,0x055F,0x135F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33DE */
0x120F,0x055F,0x135F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33DF */
0x1206,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33E0 */
0x1207,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33E1 */
0x1208,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33E2 */
0x1209,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33E3 */
0x120A,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33E4 */
0x120B,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33E5 */
0x120C,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33E6 */
0x120D,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33E7 */
0x120E,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33E8 */
0x1206,0x1205,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33E9 */
0x1206,0x1206,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33EA */
0x1206,0x1207,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33EB */
0x1206,0x1208,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33EC */
0x1206,0x1209,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33ED */
0x1206,0x120A,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33EE */
0x1206,0x120B,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33EF */
0x1206,0x120C,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33F0 */
0x1206,0x120D,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33F1 */
0x1206,0x120E,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33F2 */
0x1207,0x1205,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33F3 */
0x1207,0x1206,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33F4 */
0x1207,0x1207,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33F5 */
0x1207,0x1208,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33F6 */
0x1207,0x1209,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33F7 */
0x1207,0x120A,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33F8 */
0x1207,0x120B,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33F9 */
0x1207,0x120C,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33FA */
0x1207,0x120D,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33FB */
0x1207,0x120E,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33FC */
0x1208,0x1205,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33FD */
0x1208,0x1206,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 33FE */
0x12B0,0x120F,0x1330,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000  /* 33FF */
};

uint16 uca520_p04D[]= { /* 4D00 (3 weights per char) */
0xFB80,0xCD00,0x0000, 0xFB80,0xCD01,0x0000, 0xFB80,0xCD02,0x0000, /* 4D00 */
0xFB80,0xCD03,0x0000, 0xFB80,0xCD04,0x0000, 0xFB80,0xCD05,0x0000, /* 4D03 */
0xFB80,0xCD06,0x0000, 0xFB80,0xCD07,0x0000, 0xFB80,0xCD08,0x0000, /* 4D06 */
0xFB80,0xCD09,0x0000, 0xFB80,0xCD0A,0x0000, 0xFB80,0xCD0B,0x0000, /* 4D09 */
0xFB80,0xCD0C,0x0000, 0xFB80,0xCD0D,0x0000, 0xFB80,0xCD0E,0x0000, /* 4D0C */
0xFB80,0xCD0F,0x0000, 0xFB80,0xCD10,0x0000, 0xFB80,0xCD11,0x0000, /* 4D0F */
0xFB80,0xCD12,0x0000, 0xFB80,0xCD13,0x0000, 0xFB80,0xCD14,0x0000, /* 4D12 */
0xFB80,0xCD15,0x0000, 0xFB80,0xCD16,0x0000, 0xFB80,0xCD17,0x0000, /* 4D15 */
0xFB80,0xCD18,0x0000, 0xFB80,0xCD19,0x0000, 0xFB80,0xCD1A,0x0000, /* 4D18 */
0xFB80,0xCD1B,0x0000, 0xFB80,0xCD1C,0x0000, 0xFB80,0xCD1D,0x0000, /* 4D1B */
0xFB80,0xCD1E,0x0000, 0xFB80,0xCD1F,0x0000, 0xFB80,0xCD20,0x0000, /* 4D1E */
0xFB80,0xCD21,0x0000, 0xFB80,0xCD22,0x0000, 0xFB80,0xCD23,0x0000, /* 4D21 */
0xFB80,0xCD24,0x0000, 0xFB80,0xCD25,0x0000, 0xFB80,0xCD26,0x0000, /* 4D24 */
0xFB80,0xCD27,0x0000, 0xFB80,0xCD28,0x0000, 0xFB80,0xCD29,0x0000, /* 4D27 */
0xFB80,0xCD2A,0x0000, 0xFB80,0xCD2B,0x0000, 0xFB80,0xCD2C,0x0000, /* 4D2A */
0xFB80,0xCD2D,0x0000, 0xFB80,0xCD2E,0x0000, 0xFB80,0xCD2F,0x0000, /* 4D2D */
0xFB80,0xCD30,0x0000, 0xFB80,0xCD31,0x0000, 0xFB80,0xCD32,0x0000, /* 4D30 */
0xFB80,0xCD33,0x0000, 0xFB80,0xCD34,0x0000, 0xFB80,0xCD35,0x0000, /* 4D33 */
0xFB80,0xCD36,0x0000, 0xFB80,0xCD37,0x0000, 0xFB80,0xCD38,0x0000, /* 4D36 */
0xFB80,0xCD39,0x0000, 0xFB80,0xCD3A,0x0000, 0xFB80,0xCD3B,0x0000, /* 4D39 */
0xFB80,0xCD3C,0x0000, 0xFB80,0xCD3D,0x0000, 0xFB80,0xCD3E,0x0000, /* 4D3C */
0xFB80,0xCD3F,0x0000, 0xFB80,0xCD40,0x0000, 0xFB80,0xCD41,0x0000, /* 4D3F */
0xFB80,0xCD42,0x0000, 0xFB80,0xCD43,0x0000, 0xFB80,0xCD44,0x0000, /* 4D42 */
0xFB80,0xCD45,0x0000, 0xFB80,0xCD46,0x0000, 0xFB80,0xCD47,0x0000, /* 4D45 */
0xFB80,0xCD48,0x0000, 0xFB80,0xCD49,0x0000, 0xFB80,0xCD4A,0x0000, /* 4D48 */
0xFB80,0xCD4B,0x0000, 0xFB80,0xCD4C,0x0000, 0xFB80,0xCD4D,0x0000, /* 4D4B */
0xFB80,0xCD4E,0x0000, 0xFB80,0xCD4F,0x0000, 0xFB80,0xCD50,0x0000, /* 4D4E */
0xFB80,0xCD51,0x0000, 0xFB80,0xCD52,0x0000, 0xFB80,0xCD53,0x0000, /* 4D51 */
0xFB80,0xCD54,0x0000, 0xFB80,0xCD55,0x0000, 0xFB80,0xCD56,0x0000, /* 4D54 */
0xFB80,0xCD57,0x0000, 0xFB80,0xCD58,0x0000, 0xFB80,0xCD59,0x0000, /* 4D57 */
0xFB80,0xCD5A,0x0000, 0xFB80,0xCD5B,0x0000, 0xFB80,0xCD5C,0x0000, /* 4D5A */
0xFB80,0xCD5D,0x0000, 0xFB80,0xCD5E,0x0000, 0xFB80,0xCD5F,0x0000, /* 4D5D */
0xFB80,0xCD60,0x0000, 0xFB80,0xCD61,0x0000, 0xFB80,0xCD62,0x0000, /* 4D60 */
0xFB80,0xCD63,0x0000, 0xFB80,0xCD64,0x0000, 0xFB80,0xCD65,0x0000, /* 4D63 */
0xFB80,0xCD66,0x0000, 0xFB80,0xCD67,0x0000, 0xFB80,0xCD68,0x0000, /* 4D66 */
0xFB80,0xCD69,0x0000, 0xFB80,0xCD6A,0x0000, 0xFB80,0xCD6B,0x0000, /* 4D69 */
0xFB80,0xCD6C,0x0000, 0xFB80,0xCD6D,0x0000, 0xFB80,0xCD6E,0x0000, /* 4D6C */
0xFB80,0xCD6F,0x0000, 0xFB80,0xCD70,0x0000, 0xFB80,0xCD71,0x0000, /* 4D6F */
0xFB80,0xCD72,0x0000, 0xFB80,0xCD73,0x0000, 0xFB80,0xCD74,0x0000, /* 4D72 */
0xFB80,0xCD75,0x0000, 0xFB80,0xCD76,0x0000, 0xFB80,0xCD77,0x0000, /* 4D75 */
0xFB80,0xCD78,0x0000, 0xFB80,0xCD79,0x0000, 0xFB80,0xCD7A,0x0000, /* 4D78 */
0xFB80,0xCD7B,0x0000, 0xFB80,0xCD7C,0x0000, 0xFB80,0xCD7D,0x0000, /* 4D7B */
0xFB80,0xCD7E,0x0000, 0xFB80,0xCD7F,0x0000, 0xFB80,0xCD80,0x0000, /* 4D7E */
0xFB80,0xCD81,0x0000, 0xFB80,0xCD82,0x0000, 0xFB80,0xCD83,0x0000, /* 4D81 */
0xFB80,0xCD84,0x0000, 0xFB80,0xCD85,0x0000, 0xFB80,0xCD86,0x0000, /* 4D84 */
0xFB80,0xCD87,0x0000, 0xFB80,0xCD88,0x0000, 0xFB80,0xCD89,0x0000, /* 4D87 */
0xFB80,0xCD8A,0x0000, 0xFB80,0xCD8B,0x0000, 0xFB80,0xCD8C,0x0000, /* 4D8A */
0xFB80,0xCD8D,0x0000, 0xFB80,0xCD8E,0x0000, 0xFB80,0xCD8F,0x0000, /* 4D8D */
0xFB80,0xCD90,0x0000, 0xFB80,0xCD91,0x0000, 0xFB80,0xCD92,0x0000, /* 4D90 */
0xFB80,0xCD93,0x0000, 0xFB80,0xCD94,0x0000, 0xFB80,0xCD95,0x0000, /* 4D93 */
0xFB80,0xCD96,0x0000, 0xFB80,0xCD97,0x0000, 0xFB80,0xCD98,0x0000, /* 4D96 */
0xFB80,0xCD99,0x0000, 0xFB80,0xCD9A,0x0000, 0xFB80,0xCD9B,0x0000, /* 4D99 */
0xFB80,0xCD9C,0x0000, 0xFB80,0xCD9D,0x0000, 0xFB80,0xCD9E,0x0000, /* 4D9C */
0xFB80,0xCD9F,0x0000, 0xFB80,0xCDA0,0x0000, 0xFB80,0xCDA1,0x0000, /* 4D9F */
0xFB80,0xCDA2,0x0000, 0xFB80,0xCDA3,0x0000, 0xFB80,0xCDA4,0x0000, /* 4DA2 */
0xFB80,0xCDA5,0x0000, 0xFB80,0xCDA6,0x0000, 0xFB80,0xCDA7,0x0000, /* 4DA5 */
0xFB80,0xCDA8,0x0000, 0xFB80,0xCDA9,0x0000, 0xFB80,0xCDAA,0x0000, /* 4DA8 */
0xFB80,0xCDAB,0x0000, 0xFB80,0xCDAC,0x0000, 0xFB80,0xCDAD,0x0000, /* 4DAB */
0xFB80,0xCDAE,0x0000, 0xFB80,0xCDAF,0x0000, 0xFB80,0xCDB0,0x0000, /* 4DAE */
0xFB80,0xCDB1,0x0000, 0xFB80,0xCDB2,0x0000, 0xFB80,0xCDB3,0x0000, /* 4DB1 */
0xFB80,0xCDB4,0x0000, 0xFB80,0xCDB5,0x0000, 0xFBC0,0xCDB6,0x0000, /* 4DB4 */
0xFBC0,0xCDB7,0x0000, 0xFBC0,0xCDB8,0x0000, 0xFBC0,0xCDB9,0x0000, /* 4DB7 */
0xFBC0,0xCDBA,0x0000, 0xFBC0,0xCDBB,0x0000, 0xFBC0,0xCDBC,0x0000, /* 4DBA */
0xFBC0,0xCDBD,0x0000, 0xFBC0,0xCDBE,0x0000, 0xFBC0,0xCDBF,0x0000, /* 4DBD */
0x0D3E,0x0000,0x0000, 0x0D3F,0x0000,0x0000, 0x0D40,0x0000,0x0000, /* 4DC0 */
0x0D41,0x0000,0x0000, 0x0D42,0x0000,0x0000, 0x0D43,0x0000,0x0000, /* 4DC3 */
0x0D44,0x0000,0x0000, 0x0D45,0x0000,0x0000, 0x0D46,0x0000,0x0000, /* 4DC6 */
0x0D47,0x0000,0x0000, 0x0D48,0x0000,0x0000, 0x0D49,0x0000,0x0000, /* 4DC9 */
0x0D4A,0x0000,0x0000, 0x0D4B,0x0000,0x0000, 0x0D4C,0x0000,0x0000, /* 4DCC */
0x0D4D,0x0000,0x0000, 0x0D4E,0x0000,0x0000, 0x0D4F,0x0000,0x0000, /* 4DCF */
0x0D50,0x0000,0x0000, 0x0D51,0x0000,0x0000, 0x0D52,0x0000,0x0000, /* 4DD2 */
0x0D53,0x0000,0x0000, 0x0D54,0x0000,0x0000, 0x0D55,0x0000,0x0000, /* 4DD5 */
0x0D56,0x0000,0x0000, 0x0D57,0x0000,0x0000, 0x0D58,0x0000,0x0000, /* 4DD8 */
0x0D59,0x0000,0x0000, 0x0D5A,0x0000,0x0000, 0x0D5B,0x0000,0x0000, /* 4DDB */
0x0D5C,0x0000,0x0000, 0x0D5D,0x0000,0x0000, 0x0D5E,0x0000,0x0000, /* 4DDE */
0x0D5F,0x0000,0x0000, 0x0D60,0x0000,0x0000, 0x0D61,0x0000,0x0000, /* 4DE1 */
0x0D62,0x0000,0x0000, 0x0D63,0x0000,0x0000, 0x0D64,0x0000,0x0000, /* 4DE4 */
0x0D65,0x0000,0x0000, 0x0D66,0x0000,0x0000, 0x0D67,0x0000,0x0000, /* 4DE7 */
0x0D68,0x0000,0x0000, 0x0D69,0x0000,0x0000, 0x0D6A,0x0000,0x0000, /* 4DEA */
0x0D6B,0x0000,0x0000, 0x0D6C,0x0000,0x0000, 0x0D6D,0x0000,0x0000, /* 4DED */
0x0D6E,0x0000,0x0000, 0x0D6F,0x0000,0x0000, 0x0D70,0x0000,0x0000, /* 4DF0 */
0x0D71,0x0000,0x0000, 0x0D72,0x0000,0x0000, 0x0D73,0x0000,0x0000, /* 4DF3 */
0x0D74,0x0000,0x0000, 0x0D75,0x0000,0x0000, 0x0D76,0x0000,0x0000, /* 4DF6 */
0x0D77,0x0000,0x0000, 0x0D78,0x0000,0x0000, 0x0D79,0x0000,0x0000, /* 4DF9 */
0x0D7A,0x0000,0x0000, 0x0D7B,0x0000,0x0000, 0x0D7C,0x0000,0x0000, /* 4DFC */
0x0D7D,0x0000,0x0000  };

uint16 uca520_p0A0[]= { /* A000 (2 weights per char) */
0x2B75,0x0000, 0x2B76,0x0000, 0x2B77,0x0000, 0x2B78,0x0000, /* A000 */
0x2B79,0x0000, 0x2B7A,0x0000, 0x2B7B,0x0000, 0x2B7C,0x0000, /* A004 */
0x2B7D,0x0000, 0x2B7E,0x0000, 0x2B7F,0x0000, 0x2B80,0x0000, /* A008 */
0x2B81,0x0000, 0x2B82,0x0000, 0x2B83,0x0000, 0x2B84,0x0000, /* A00C */
0x2B85,0x0000, 0x2B86,0x0000, 0x2B87,0x0000, 0x2B88,0x0000, /* A010 */
0x2B89,0x0000, 0x2B8A,0x0000, 0x2B8B,0x0000, 0x2B8C,0x0000, /* A014 */
0x2B8D,0x0000, 0x2B8E,0x0000, 0x2B8F,0x0000, 0x2B90,0x0000, /* A018 */
0x2B91,0x0000, 0x2B92,0x0000, 0x2B93,0x0000, 0x2B94,0x0000, /* A01C */
0x2B95,0x0000, 0x2B96,0x0000, 0x2B97,0x0000, 0x2B98,0x0000, /* A020 */
0x2B99,0x0000, 0x2B9A,0x0000, 0x2B9B,0x0000, 0x2B9C,0x0000, /* A024 */
0x2B9D,0x0000, 0x2B9E,0x0000, 0x2B9F,0x0000, 0x2BA0,0x0000, /* A028 */
0x2BA1,0x0000, 0x2BA2,0x0000, 0x2BA3,0x0000, 0x2BA4,0x0000, /* A02C */
0x2BA5,0x0000, 0x2BA6,0x0000, 0x2BA7,0x0000, 0x2BA8,0x0000, /* A030 */
0x2BA9,0x0000, 0x2BAA,0x0000, 0x2BAB,0x0000, 0x2BAC,0x0000, /* A034 */
0x2BAD,0x0000, 0x2BAE,0x0000, 0x2BAF,0x0000, 0x2BB0,0x0000, /* A038 */
0x2BB1,0x0000, 0x2BB2,0x0000, 0x2BB3,0x0000, 0x2BB4,0x0000, /* A03C */
0x2BB5,0x0000, 0x2BB6,0x0000, 0x2BB7,0x0000, 0x2BB8,0x0000, /* A040 */
0x2BB9,0x0000, 0x2BBA,0x0000, 0x2BBB,0x0000, 0x2BBC,0x0000, /* A044 */
0x2BBD,0x0000, 0x2BBE,0x0000, 0x2BBF,0x0000, 0x2BC0,0x0000, /* A048 */
0x2BC1,0x0000, 0x2BC2,0x0000, 0x2BC3,0x0000, 0x2BC4,0x0000, /* A04C */
0x2BC5,0x0000, 0x2BC6,0x0000, 0x2BC7,0x0000, 0x2BC8,0x0000, /* A050 */
0x2BC9,0x0000, 0x2BCA,0x0000, 0x2BCB,0x0000, 0x2BCC,0x0000, /* A054 */
0x2BCD,0x0000, 0x2BCE,0x0000, 0x2BCF,0x0000, 0x2BD0,0x0000, /* A058 */
0x2BD1,0x0000, 0x2BD2,0x0000, 0x2BD3,0x0000, 0x2BD4,0x0000, /* A05C */
0x2BD5,0x0000, 0x2BD6,0x0000, 0x2BD7,0x0000, 0x2BD8,0x0000, /* A060 */
0x2BD9,0x0000, 0x2BDA,0x0000, 0x2BDB,0x0000, 0x2BDC,0x0000, /* A064 */
0x2BDD,0x0000, 0x2BDE,0x0000, 0x2BDF,0x0000, 0x2BE0,0x0000, /* A068 */
0x2BE1,0x0000, 0x2BE2,0x0000, 0x2BE3,0x0000, 0x2BE4,0x0000, /* A06C */
0x2BE5,0x0000, 0x2BE6,0x0000, 0x2BE7,0x0000, 0x2BE8,0x0000, /* A070 */
0x2BE9,0x0000, 0x2BEA,0x0000, 0x2BEB,0x0000, 0x2BEC,0x0000, /* A074 */
0x2BED,0x0000, 0x2BEE,0x0000, 0x2BEF,0x0000, 0x2BF0,0x0000, /* A078 */
0x2BF1,0x0000, 0x2BF2,0x0000, 0x2BF3,0x0000, 0x2BF4,0x0000, /* A07C */
0x2BF5,0x0000, 0x2BF6,0x0000, 0x2BF7,0x0000, 0x2BF8,0x0000, /* A080 */
0x2BF9,0x0000, 0x2BFA,0x0000, 0x2BFB,0x0000, 0x2BFC,0x0000, /* A084 */
0x2BFD,0x0000, 0x2BFE,0x0000, 0x2BFF,0x0000, 0x2C00,0x0000, /* A088 */
0x2C01,0x0000, 0x2C02,0x0000, 0x2C03,0x0000, 0x2C04,0x0000, /* A08C */
0x2C05,0x0000, 0x2C06,0x0000, 0x2C07,0x0000, 0x2C08,0x0000, /* A090 */
0x2C09,0x0000, 0x2C0A,0x0000, 0x2C0B,0x0000, 0x2C0C,0x0000, /* A094 */
0x2C0D,0x0000, 0x2C0E,0x0000, 0x2C0F,0x0000, 0x2C10,0x0000, /* A098 */
0x2C11,0x0000, 0x2C12,0x0000, 0x2C13,0x0000, 0x2C14,0x0000, /* A09C */
0x2C15,0x0000, 0x2C16,0x0000, 0x2C17,0x0000, 0x2C18,0x0000, /* A0A0 */
0x2C19,0x0000, 0x2C1A,0x0000, 0x2C1B,0x0000, 0x2C1C,0x0000, /* A0A4 */
0x2C1D,0x0000, 0x2C1E,0x0000, 0x2C1F,0x0000, 0x2C20,0x0000, /* A0A8 */
0x2C21,0x0000, 0x2C22,0x0000, 0x2C23,0x0000, 0x2C24,0x0000, /* A0AC */
0x2C25,0x0000, 0x2C26,0x0000, 0x2C27,0x0000, 0x2C28,0x0000, /* A0B0 */
0x2C29,0x0000, 0x2C2A,0x0000, 0x2C2B,0x0000, 0x2C2C,0x0000, /* A0B4 */
0x2C2D,0x0000, 0x2C2E,0x0000, 0x2C2F,0x0000, 0x2C30,0x0000, /* A0B8 */
0x2C31,0x0000, 0x2C32,0x0000, 0x2C33,0x0000, 0x2C34,0x0000, /* A0BC */
0x2C35,0x0000, 0x2C36,0x0000, 0x2C37,0x0000, 0x2C38,0x0000, /* A0C0 */
0x2C39,0x0000, 0x2C3A,0x0000, 0x2C3B,0x0000, 0x2C3C,0x0000, /* A0C4 */
0x2C3D,0x0000, 0x2C3E,0x0000, 0x2C3F,0x0000, 0x2C40,0x0000, /* A0C8 */
0x2C41,0x0000, 0x2C42,0x0000, 0x2C43,0x0000, 0x2C44,0x0000, /* A0CC */
0x2C45,0x0000, 0x2C46,0x0000, 0x2C47,0x0000, 0x2C48,0x0000, /* A0D0 */
0x2C49,0x0000, 0x2C4A,0x0000, 0x2C4B,0x0000, 0x2C4C,0x0000, /* A0D4 */
0x2C4D,0x0000, 0x2C4E,0x0000, 0x2C4F,0x0000, 0x2C50,0x0000, /* A0D8 */
0x2C51,0x0000, 0x2C52,0x0000, 0x2C53,0x0000, 0x2C54,0x0000, /* A0DC */
0x2C55,0x0000, 0x2C56,0x0000, 0x2C57,0x0000, 0x2C58,0x0000, /* A0E0 */
0x2C59,0x0000, 0x2C5A,0x0000, 0x2C5B,0x0000, 0x2C5C,0x0000, /* A0E4 */
0x2C5D,0x0000, 0x2C5E,0x0000, 0x2C5F,0x0000, 0x2C60,0x0000, /* A0E8 */
0x2C61,0x0000, 0x2C62,0x0000, 0x2C63,0x0000, 0x2C64,0x0000, /* A0EC */
0x2C65,0x0000, 0x2C66,0x0000, 0x2C67,0x0000, 0x2C68,0x0000, /* A0F0 */
0x2C69,0x0000, 0x2C6A,0x0000, 0x2C6B,0x0000, 0x2C6C,0x0000, /* A0F4 */
0x2C6D,0x0000, 0x2C6E,0x0000, 0x2C6F,0x0000, 0x2C70,0x0000, /* A0F8 */
0x2C71,0x0000, 0x2C72,0x0000, 0x2C73,0x0000, 0x2C74,0x0000  /* A0FC */
};

uint16 uca520_p0A1[]= { /* A100 (2 weights per char) */
0x2C75,0x0000, 0x2C76,0x0000, 0x2C77,0x0000, 0x2C78,0x0000, /* A100 */
0x2C79,0x0000, 0x2C7A,0x0000, 0x2C7B,0x0000, 0x2C7C,0x0000, /* A104 */
0x2C7D,0x0000, 0x2C7E,0x0000, 0x2C7F,0x0000, 0x2C80,0x0000, /* A108 */
0x2C81,0x0000, 0x2C82,0x0000, 0x2C83,0x0000, 0x2C84,0x0000, /* A10C */
0x2C85,0x0000, 0x2C86,0x0000, 0x2C87,0x0000, 0x2C88,0x0000, /* A110 */
0x2C89,0x0000, 0x2C8A,0x0000, 0x2C8B,0x0000, 0x2C8C,0x0000, /* A114 */
0x2C8D,0x0000, 0x2C8E,0x0000, 0x2C8F,0x0000, 0x2C90,0x0000, /* A118 */
0x2C91,0x0000, 0x2C92,0x0000, 0x2C93,0x0000, 0x2C94,0x0000, /* A11C */
0x2C95,0x0000, 0x2C96,0x0000, 0x2C97,0x0000, 0x2C98,0x0000, /* A120 */
0x2C99,0x0000, 0x2C9A,0x0000, 0x2C9B,0x0000, 0x2C9C,0x0000, /* A124 */
0x2C9D,0x0000, 0x2C9E,0x0000, 0x2C9F,0x0000, 0x2CA0,0x0000, /* A128 */
0x2CA1,0x0000, 0x2CA2,0x0000, 0x2CA3,0x0000, 0x2CA4,0x0000, /* A12C */
0x2CA5,0x0000, 0x2CA6,0x0000, 0x2CA7,0x0000, 0x2CA8,0x0000, /* A130 */
0x2CA9,0x0000, 0x2CAA,0x0000, 0x2CAB,0x0000, 0x2CAC,0x0000, /* A134 */
0x2CAD,0x0000, 0x2CAE,0x0000, 0x2CAF,0x0000, 0x2CB0,0x0000, /* A138 */
0x2CB1,0x0000, 0x2CB2,0x0000, 0x2CB3,0x0000, 0x2CB4,0x0000, /* A13C */
0x2CB5,0x0000, 0x2CB6,0x0000, 0x2CB7,0x0000, 0x2CB8,0x0000, /* A140 */
0x2CB9,0x0000, 0x2CBA,0x0000, 0x2CBB,0x0000, 0x2CBC,0x0000, /* A144 */
0x2CBD,0x0000, 0x2CBE,0x0000, 0x2CBF,0x0000, 0x2CC0,0x0000, /* A148 */
0x2CC1,0x0000, 0x2CC2,0x0000, 0x2CC3,0x0000, 0x2CC4,0x0000, /* A14C */
0x2CC5,0x0000, 0x2CC6,0x0000, 0x2CC7,0x0000, 0x2CC8,0x0000, /* A150 */
0x2CC9,0x0000, 0x2CCA,0x0000, 0x2CCB,0x0000, 0x2CCC,0x0000, /* A154 */
0x2CCD,0x0000, 0x2CCE,0x0000, 0x2CCF,0x0000, 0x2CD0,0x0000, /* A158 */
0x2CD1,0x0000, 0x2CD2,0x0000, 0x2CD3,0x0000, 0x2CD4,0x0000, /* A15C */
0x2CD5,0x0000, 0x2CD6,0x0000, 0x2CD7,0x0000, 0x2CD8,0x0000, /* A160 */
0x2CD9,0x0000, 0x2CDA,0x0000, 0x2CDB,0x0000, 0x2CDC,0x0000, /* A164 */
0x2CDD,0x0000, 0x2CDE,0x0000, 0x2CDF,0x0000, 0x2CE0,0x0000, /* A168 */
0x2CE1,0x0000, 0x2CE2,0x0000, 0x2CE3,0x0000, 0x2CE4,0x0000, /* A16C */
0x2CE5,0x0000, 0x2CE6,0x0000, 0x2CE7,0x0000, 0x2CE8,0x0000, /* A170 */
0x2CE9,0x0000, 0x2CEA,0x0000, 0x2CEB,0x0000, 0x2CEC,0x0000, /* A174 */
0x2CED,0x0000, 0x2CEE,0x0000, 0x2CEF,0x0000, 0x2CF0,0x0000, /* A178 */
0x2CF1,0x0000, 0x2CF2,0x0000, 0x2CF3,0x0000, 0x2CF4,0x0000, /* A17C */
0x2CF5,0x0000, 0x2CF6,0x0000, 0x2CF7,0x0000, 0x2CF8,0x0000, /* A180 */
0x2CF9,0x0000, 0x2CFA,0x0000, 0x2CFB,0x0000, 0x2CFC,0x0000, /* A184 */
0x2CFD,0x0000, 0x2CFE,0x0000, 0x2CFF,0x0000, 0x2D00,0x0000, /* A188 */
0x2D01,0x0000, 0x2D02,0x0000, 0x2D03,0x0000, 0x2D04,0x0000, /* A18C */
0x2D05,0x0000, 0x2D06,0x0000, 0x2D07,0x0000, 0x2D08,0x0000, /* A190 */
0x2D09,0x0000, 0x2D0A,0x0000, 0x2D0B,0x0000, 0x2D0C,0x0000, /* A194 */
0x2D0D,0x0000, 0x2D0E,0x0000, 0x2D0F,0x0000, 0x2D10,0x0000, /* A198 */
0x2D11,0x0000, 0x2D12,0x0000, 0x2D13,0x0000, 0x2D14,0x0000, /* A19C */
0x2D15,0x0000, 0x2D16,0x0000, 0x2D17,0x0000, 0x2D18,0x0000, /* A1A0 */
0x2D19,0x0000, 0x2D1A,0x0000, 0x2D1B,0x0000, 0x2D1C,0x0000, /* A1A4 */
0x2D1D,0x0000, 0x2D1E,0x0000, 0x2D1F,0x0000, 0x2D20,0x0000, /* A1A8 */
0x2D21,0x0000, 0x2D22,0x0000, 0x2D23,0x0000, 0x2D24,0x0000, /* A1AC */
0x2D25,0x0000, 0x2D26,0x0000, 0x2D27,0x0000, 0x2D28,0x0000, /* A1B0 */
0x2D29,0x0000, 0x2D2A,0x0000, 0x2D2B,0x0000, 0x2D2C,0x0000, /* A1B4 */
0x2D2D,0x0000, 0x2D2E,0x0000, 0x2D2F,0x0000, 0x2D30,0x0000, /* A1B8 */
0x2D31,0x0000, 0x2D32,0x0000, 0x2D33,0x0000, 0x2D34,0x0000, /* A1BC */
0x2D35,0x0000, 0x2D36,0x0000, 0x2D37,0x0000, 0x2D38,0x0000, /* A1C0 */
0x2D39,0x0000, 0x2D3A,0x0000, 0x2D3B,0x0000, 0x2D3C,0x0000, /* A1C4 */
0x2D3D,0x0000, 0x2D3E,0x0000, 0x2D3F,0x0000, 0x2D40,0x0000, /* A1C8 */
0x2D41,0x0000, 0x2D42,0x0000, 0x2D43,0x0000, 0x2D44,0x0000, /* A1CC */
0x2D45,0x0000, 0x2D46,0x0000, 0x2D47,0x0000, 0x2D48,0x0000, /* A1D0 */
0x2D49,0x0000, 0x2D4A,0x0000, 0x2D4B,0x0000, 0x2D4C,0x0000, /* A1D4 */
0x2D4D,0x0000, 0x2D4E,0x0000, 0x2D4F,0x0000, 0x2D50,0x0000, /* A1D8 */
0x2D51,0x0000, 0x2D52,0x0000, 0x2D53,0x0000, 0x2D54,0x0000, /* A1DC */
0x2D55,0x0000, 0x2D56,0x0000, 0x2D57,0x0000, 0x2D58,0x0000, /* A1E0 */
0x2D59,0x0000, 0x2D5A,0x0000, 0x2D5B,0x0000, 0x2D5C,0x0000, /* A1E4 */
0x2D5D,0x0000, 0x2D5E,0x0000, 0x2D5F,0x0000, 0x2D60,0x0000, /* A1E8 */
0x2D61,0x0000, 0x2D62,0x0000, 0x2D63,0x0000, 0x2D64,0x0000, /* A1EC */
0x2D65,0x0000, 0x2D66,0x0000, 0x2D67,0x0000, 0x2D68,0x0000, /* A1F0 */
0x2D69,0x0000, 0x2D6A,0x0000, 0x2D6B,0x0000, 0x2D6C,0x0000, /* A1F4 */
0x2D6D,0x0000, 0x2D6E,0x0000, 0x2D6F,0x0000, 0x2D70,0x0000, /* A1F8 */
0x2D71,0x0000, 0x2D72,0x0000, 0x2D73,0x0000, 0x2D74,0x0000  /* A1FC */
};

uint16 uca520_p0A2[]= { /* A200 (2 weights per char) */
0x2D75,0x0000, 0x2D76,0x0000, 0x2D77,0x0000, 0x2D78,0x0000, /* A200 */
0x2D79,0x0000, 0x2D7A,0x0000, 0x2D7B,0x0000, 0x2D7C,0x0000, /* A204 */
0x2D7D,0x0000, 0x2D7E,0x0000, 0x2D7F,0x0000, 0x2D80,0x0000, /* A208 */
0x2D81,0x0000, 0x2D82,0x0000, 0x2D83,0x0000, 0x2D84,0x0000, /* A20C */
0x2D85,0x0000, 0x2D86,0x0000, 0x2D87,0x0000, 0x2D88,0x0000, /* A210 */
0x2D89,0x0000, 0x2D8A,0x0000, 0x2D8B,0x0000, 0x2D8C,0x0000, /* A214 */
0x2D8D,0x0000, 0x2D8E,0x0000, 0x2D8F,0x0000, 0x2D90,0x0000, /* A218 */
0x2D91,0x0000, 0x2D92,0x0000, 0x2D93,0x0000, 0x2D94,0x0000, /* A21C */
0x2D95,0x0000, 0x2D96,0x0000, 0x2D97,0x0000, 0x2D98,0x0000, /* A220 */
0x2D99,0x0000, 0x2D9A,0x0000, 0x2D9B,0x0000, 0x2D9C,0x0000, /* A224 */
0x2D9D,0x0000, 0x2D9E,0x0000, 0x2D9F,0x0000, 0x2DA0,0x0000, /* A228 */
0x2DA1,0x0000, 0x2DA2,0x0000, 0x2DA3,0x0000, 0x2DA4,0x0000, /* A22C */
0x2DA5,0x0000, 0x2DA6,0x0000, 0x2DA7,0x0000, 0x2DA8,0x0000, /* A230 */
0x2DA9,0x0000, 0x2DAA,0x0000, 0x2DAB,0x0000, 0x2DAC,0x0000, /* A234 */
0x2DAD,0x0000, 0x2DAE,0x0000, 0x2DAF,0x0000, 0x2DB0,0x0000, /* A238 */
0x2DB1,0x0000, 0x2DB2,0x0000, 0x2DB3,0x0000, 0x2DB4,0x0000, /* A23C */
0x2DB5,0x0000, 0x2DB6,0x0000, 0x2DB7,0x0000, 0x2DB8,0x0000, /* A240 */
0x2DB9,0x0000, 0x2DBA,0x0000, 0x2DBB,0x0000, 0x2DBC,0x0000, /* A244 */
0x2DBD,0x0000, 0x2DBE,0x0000, 0x2DBF,0x0000, 0x2DC0,0x0000, /* A248 */
0x2DC1,0x0000, 0x2DC2,0x0000, 0x2DC3,0x0000, 0x2DC4,0x0000, /* A24C */
0x2DC5,0x0000, 0x2DC6,0x0000, 0x2DC7,0x0000, 0x2DC8,0x0000, /* A250 */
0x2DC9,0x0000, 0x2DCA,0x0000, 0x2DCB,0x0000, 0x2DCC,0x0000, /* A254 */
0x2DCD,0x0000, 0x2DCE,0x0000, 0x2DCF,0x0000, 0x2DD0,0x0000, /* A258 */
0x2DD1,0x0000, 0x2DD2,0x0000, 0x2DD3,0x0000, 0x2DD4,0x0000, /* A25C */
0x2DD5,0x0000, 0x2DD6,0x0000, 0x2DD7,0x0000, 0x2DD8,0x0000, /* A260 */
0x2DD9,0x0000, 0x2DDA,0x0000, 0x2DDB,0x0000, 0x2DDC,0x0000, /* A264 */
0x2DDD,0x0000, 0x2DDE,0x0000, 0x2DDF,0x0000, 0x2DE0,0x0000, /* A268 */
0x2DE1,0x0000, 0x2DE2,0x0000, 0x2DE3,0x0000, 0x2DE4,0x0000, /* A26C */
0x2DE5,0x0000, 0x2DE6,0x0000, 0x2DE7,0x0000, 0x2DE8,0x0000, /* A270 */
0x2DE9,0x0000, 0x2DEA,0x0000, 0x2DEB,0x0000, 0x2DEC,0x0000, /* A274 */
0x2DED,0x0000, 0x2DEE,0x0000, 0x2DEF,0x0000, 0x2DF0,0x0000, /* A278 */
0x2DF1,0x0000, 0x2DF2,0x0000, 0x2DF3,0x0000, 0x2DF4,0x0000, /* A27C */
0x2DF5,0x0000, 0x2DF6,0x0000, 0x2DF7,0x0000, 0x2DF8,0x0000, /* A280 */
0x2DF9,0x0000, 0x2DFA,0x0000, 0x2DFB,0x0000, 0x2DFC,0x0000, /* A284 */
0x2DFD,0x0000, 0x2DFE,0x0000, 0x2DFF,0x0000, 0x2E00,0x0000, /* A288 */
0x2E01,0x0000, 0x2E02,0x0000, 0x2E03,0x0000, 0x2E04,0x0000, /* A28C */
0x2E05,0x0000, 0x2E06,0x0000, 0x2E07,0x0000, 0x2E08,0x0000, /* A290 */
0x2E09,0x0000, 0x2E0A,0x0000, 0x2E0B,0x0000, 0x2E0C,0x0000, /* A294 */
0x2E0D,0x0000, 0x2E0E,0x0000, 0x2E0F,0x0000, 0x2E10,0x0000, /* A298 */
0x2E11,0x0000, 0x2E12,0x0000, 0x2E13,0x0000, 0x2E14,0x0000, /* A29C */
0x2E15,0x0000, 0x2E16,0x0000, 0x2E17,0x0000, 0x2E18,0x0000, /* A2A0 */
0x2E19,0x0000, 0x2E1A,0x0000, 0x2E1B,0x0000, 0x2E1C,0x0000, /* A2A4 */
0x2E1D,0x0000, 0x2E1E,0x0000, 0x2E1F,0x0000, 0x2E20,0x0000, /* A2A8 */
0x2E21,0x0000, 0x2E22,0x0000, 0x2E23,0x0000, 0x2E24,0x0000, /* A2AC */
0x2E25,0x0000, 0x2E26,0x0000, 0x2E27,0x0000, 0x2E28,0x0000, /* A2B0 */
0x2E29,0x0000, 0x2E2A,0x0000, 0x2E2B,0x0000, 0x2E2C,0x0000, /* A2B4 */
0x2E2D,0x0000, 0x2E2E,0x0000, 0x2E2F,0x0000, 0x2E30,0x0000, /* A2B8 */
0x2E31,0x0000, 0x2E32,0x0000, 0x2E33,0x0000, 0x2E34,0x0000, /* A2BC */
0x2E35,0x0000, 0x2E36,0x0000, 0x2E37,0x0000, 0x2E38,0x0000, /* A2C0 */
0x2E39,0x0000, 0x2E3A,0x0000, 0x2E3B,0x0000, 0x2E3C,0x0000, /* A2C4 */
0x2E3D,0x0000, 0x2E3E,0x0000, 0x2E3F,0x0000, 0x2E40,0x0000, /* A2C8 */
0x2E41,0x0000, 0x2E42,0x0000, 0x2E43,0x0000, 0x2E44,0x0000, /* A2CC */
0x2E45,0x0000, 0x2E46,0x0000, 0x2E47,0x0000, 0x2E48,0x0000, /* A2D0 */
0x2E49,0x0000, 0x2E4A,0x0000, 0x2E4B,0x0000, 0x2E4C,0x0000, /* A2D4 */
0x2E4D,0x0000, 0x2E4E,0x0000, 0x2E4F,0x0000, 0x2E50,0x0000, /* A2D8 */
0x2E51,0x0000, 0x2E52,0x0000, 0x2E53,0x0000, 0x2E54,0x0000, /* A2DC */
0x2E55,0x0000, 0x2E56,0x0000, 0x2E57,0x0000, 0x2E58,0x0000, /* A2E0 */
0x2E59,0x0000, 0x2E5A,0x0000, 0x2E5B,0x0000, 0x2E5C,0x0000, /* A2E4 */
0x2E5D,0x0000, 0x2E5E,0x0000, 0x2E5F,0x0000, 0x2E60,0x0000, /* A2E8 */
0x2E61,0x0000, 0x2E62,0x0000, 0x2E63,0x0000, 0x2E64,0x0000, /* A2EC */
0x2E65,0x0000, 0x2E66,0x0000, 0x2E67,0x0000, 0x2E68,0x0000, /* A2F0 */
0x2E69,0x0000, 0x2E6A,0x0000, 0x2E6B,0x0000, 0x2E6C,0x0000, /* A2F4 */
0x2E6D,0x0000, 0x2E6E,0x0000, 0x2E6F,0x0000, 0x2E70,0x0000, /* A2F8 */
0x2E71,0x0000, 0x2E72,0x0000, 0x2E73,0x0000, 0x2E74,0x0000  /* A2FC */
};

uint16 uca520_p0A3[]= { /* A300 (2 weights per char) */
0x2E75,0x0000, 0x2E76,0x0000, 0x2E77,0x0000, 0x2E78,0x0000, /* A300 */
0x2E79,0x0000, 0x2E7A,0x0000, 0x2E7B,0x0000, 0x2E7C,0x0000, /* A304 */
0x2E7D,0x0000, 0x2E7E,0x0000, 0x2E7F,0x0000, 0x2E80,0x0000, /* A308 */
0x2E81,0x0000, 0x2E82,0x0000, 0x2E83,0x0000, 0x2E84,0x0000, /* A30C */
0x2E85,0x0000, 0x2E86,0x0000, 0x2E87,0x0000, 0x2E88,0x0000, /* A310 */
0x2E89,0x0000, 0x2E8A,0x0000, 0x2E8B,0x0000, 0x2E8C,0x0000, /* A314 */
0x2E8D,0x0000, 0x2E8E,0x0000, 0x2E8F,0x0000, 0x2E90,0x0000, /* A318 */
0x2E91,0x0000, 0x2E92,0x0000, 0x2E93,0x0000, 0x2E94,0x0000, /* A31C */
0x2E95,0x0000, 0x2E96,0x0000, 0x2E97,0x0000, 0x2E98,0x0000, /* A320 */
0x2E99,0x0000, 0x2E9A,0x0000, 0x2E9B,0x0000, 0x2E9C,0x0000, /* A324 */
0x2E9D,0x0000, 0x2E9E,0x0000, 0x2E9F,0x0000, 0x2EA0,0x0000, /* A328 */
0x2EA1,0x0000, 0x2EA2,0x0000, 0x2EA3,0x0000, 0x2EA4,0x0000, /* A32C */
0x2EA5,0x0000, 0x2EA6,0x0000, 0x2EA7,0x0000, 0x2EA8,0x0000, /* A330 */
0x2EA9,0x0000, 0x2EAA,0x0000, 0x2EAB,0x0000, 0x2EAC,0x0000, /* A334 */
0x2EAD,0x0000, 0x2EAE,0x0000, 0x2EAF,0x0000, 0x2EB0,0x0000, /* A338 */
0x2EB1,0x0000, 0x2EB2,0x0000, 0x2EB3,0x0000, 0x2EB4,0x0000, /* A33C */
0x2EB5,0x0000, 0x2EB6,0x0000, 0x2EB7,0x0000, 0x2EB8,0x0000, /* A340 */
0x2EB9,0x0000, 0x2EBA,0x0000, 0x2EBB,0x0000, 0x2EBC,0x0000, /* A344 */
0x2EBD,0x0000, 0x2EBE,0x0000, 0x2EBF,0x0000, 0x2EC0,0x0000, /* A348 */
0x2EC1,0x0000, 0x2EC2,0x0000, 0x2EC3,0x0000, 0x2EC4,0x0000, /* A34C */
0x2EC5,0x0000, 0x2EC6,0x0000, 0x2EC7,0x0000, 0x2EC8,0x0000, /* A350 */
0x2EC9,0x0000, 0x2ECA,0x0000, 0x2ECB,0x0000, 0x2ECC,0x0000, /* A354 */
0x2ECD,0x0000, 0x2ECE,0x0000, 0x2ECF,0x0000, 0x2ED0,0x0000, /* A358 */
0x2ED1,0x0000, 0x2ED2,0x0000, 0x2ED3,0x0000, 0x2ED4,0x0000, /* A35C */
0x2ED5,0x0000, 0x2ED6,0x0000, 0x2ED7,0x0000, 0x2ED8,0x0000, /* A360 */
0x2ED9,0x0000, 0x2EDA,0x0000, 0x2EDB,0x0000, 0x2EDC,0x0000, /* A364 */
0x2EDD,0x0000, 0x2EDE,0x0000, 0x2EDF,0x0000, 0x2EE0,0x0000, /* A368 */
0x2EE1,0x0000, 0x2EE2,0x0000, 0x2EE3,0x0000, 0x2EE4,0x0000, /* A36C */
0x2EE5,0x0000, 0x2EE6,0x0000, 0x2EE7,0x0000, 0x2EE8,0x0000, /* A370 */
0x2EE9,0x0000, 0x2EEA,0x0000, 0x2EEB,0x0000, 0x2EEC,0x0000, /* A374 */
0x2EED,0x0000, 0x2EEE,0x0000, 0x2EEF,0x0000, 0x2EF0,0x0000, /* A378 */
0x2EF1,0x0000, 0x2EF2,0x0000, 0x2EF3,0x0000, 0x2EF4,0x0000, /* A37C */
0x2EF5,0x0000, 0x2EF6,0x0000, 0x2EF7,0x0000, 0x2EF8,0x0000, /* A380 */
0x2EF9,0x0000, 0x2EFA,0x0000, 0x2EFB,0x0000, 0x2EFC,0x0000, /* A384 */
0x2EFD,0x0000, 0x2EFE,0x0000, 0x2EFF,0x0000, 0x2F00,0x0000, /* A388 */
0x2F01,0x0000, 0x2F02,0x0000, 0x2F03,0x0000, 0x2F04,0x0000, /* A38C */
0x2F05,0x0000, 0x2F06,0x0000, 0x2F07,0x0000, 0x2F08,0x0000, /* A390 */
0x2F09,0x0000, 0x2F0A,0x0000, 0x2F0B,0x0000, 0x2F0C,0x0000, /* A394 */
0x2F0D,0x0000, 0x2F0E,0x0000, 0x2F0F,0x0000, 0x2F10,0x0000, /* A398 */
0x2F11,0x0000, 0x2F12,0x0000, 0x2F13,0x0000, 0x2F14,0x0000, /* A39C */
0x2F15,0x0000, 0x2F16,0x0000, 0x2F17,0x0000, 0x2F18,0x0000, /* A3A0 */
0x2F19,0x0000, 0x2F1A,0x0000, 0x2F1B,0x0000, 0x2F1C,0x0000, /* A3A4 */
0x2F1D,0x0000, 0x2F1E,0x0000, 0x2F1F,0x0000, 0x2F20,0x0000, /* A3A8 */
0x2F21,0x0000, 0x2F22,0x0000, 0x2F23,0x0000, 0x2F24,0x0000, /* A3AC */
0x2F25,0x0000, 0x2F26,0x0000, 0x2F27,0x0000, 0x2F28,0x0000, /* A3B0 */
0x2F29,0x0000, 0x2F2A,0x0000, 0x2F2B,0x0000, 0x2F2C,0x0000, /* A3B4 */
0x2F2D,0x0000, 0x2F2E,0x0000, 0x2F2F,0x0000, 0x2F30,0x0000, /* A3B8 */
0x2F31,0x0000, 0x2F32,0x0000, 0x2F33,0x0000, 0x2F34,0x0000, /* A3BC */
0x2F35,0x0000, 0x2F36,0x0000, 0x2F37,0x0000, 0x2F38,0x0000, /* A3C0 */
0x2F39,0x0000, 0x2F3A,0x0000, 0x2F3B,0x0000, 0x2F3C,0x0000, /* A3C4 */
0x2F3D,0x0000, 0x2F3E,0x0000, 0x2F3F,0x0000, 0x2F40,0x0000, /* A3C8 */
0x2F41,0x0000, 0x2F42,0x0000, 0x2F43,0x0000, 0x2F44,0x0000, /* A3CC */
0x2F45,0x0000, 0x2F46,0x0000, 0x2F47,0x0000, 0x2F48,0x0000, /* A3D0 */
0x2F49,0x0000, 0x2F4A,0x0000, 0x2F4B,0x0000, 0x2F4C,0x0000, /* A3D4 */
0x2F4D,0x0000, 0x2F4E,0x0000, 0x2F4F,0x0000, 0x2F50,0x0000, /* A3D8 */
0x2F51,0x0000, 0x2F52,0x0000, 0x2F53,0x0000, 0x2F54,0x0000, /* A3DC */
0x2F55,0x0000, 0x2F56,0x0000, 0x2F57,0x0000, 0x2F58,0x0000, /* A3E0 */
0x2F59,0x0000, 0x2F5A,0x0000, 0x2F5B,0x0000, 0x2F5C,0x0000, /* A3E4 */
0x2F5D,0x0000, 0x2F5E,0x0000, 0x2F5F,0x0000, 0x2F60,0x0000, /* A3E8 */
0x2F61,0x0000, 0x2F62,0x0000, 0x2F63,0x0000, 0x2F64,0x0000, /* A3EC */
0x2F65,0x0000, 0x2F66,0x0000, 0x2F67,0x0000, 0x2F68,0x0000, /* A3F0 */
0x2F69,0x0000, 0x2F6A,0x0000, 0x2F6B,0x0000, 0x2F6C,0x0000, /* A3F4 */
0x2F6D,0x0000, 0x2F6E,0x0000, 0x2F6F,0x0000, 0x2F70,0x0000, /* A3F8 */
0x2F71,0x0000, 0x2F72,0x0000, 0x2F73,0x0000, 0x2F74,0x0000  /* A3FC */
};

uint16 uca520_p0A4[]= { /* A400 (3 weights per char) */
0x2F75,0x0000,0x0000, 0x2F76,0x0000,0x0000, 0x2F77,0x0000,0x0000, /* A400 */
0x2F78,0x0000,0x0000, 0x2F79,0x0000,0x0000, 0x2F7A,0x0000,0x0000, /* A403 */
0x2F7B,0x0000,0x0000, 0x2F7C,0x0000,0x0000, 0x2F7D,0x0000,0x0000, /* A406 */
0x2F7E,0x0000,0x0000, 0x2F7F,0x0000,0x0000, 0x2F80,0x0000,0x0000, /* A409 */
0x2F81,0x0000,0x0000, 0x2F82,0x0000,0x0000, 0x2F83,0x0000,0x0000, /* A40C */
0x2F84,0x0000,0x0000, 0x2F85,0x0000,0x0000, 0x2F86,0x0000,0x0000, /* A40F */
0x2F87,0x0000,0x0000, 0x2F88,0x0000,0x0000, 0x2F89,0x0000,0x0000, /* A412 */
0x2F8A,0x0000,0x0000, 0x2F8B,0x0000,0x0000, 0x2F8C,0x0000,0x0000, /* A415 */
0x2F8D,0x0000,0x0000, 0x2F8E,0x0000,0x0000, 0x2F8F,0x0000,0x0000, /* A418 */
0x2F90,0x0000,0x0000, 0x2F91,0x0000,0x0000, 0x2F92,0x0000,0x0000, /* A41B */
0x2F93,0x0000,0x0000, 0x2F94,0x0000,0x0000, 0x2F95,0x0000,0x0000, /* A41E */
0x2F96,0x0000,0x0000, 0x2F97,0x0000,0x0000, 0x2F98,0x0000,0x0000, /* A421 */
0x2F99,0x0000,0x0000, 0x2F9A,0x0000,0x0000, 0x2F9B,0x0000,0x0000, /* A424 */
0x2F9C,0x0000,0x0000, 0x2F9D,0x0000,0x0000, 0x2F9E,0x0000,0x0000, /* A427 */
0x2F9F,0x0000,0x0000, 0x2FA0,0x0000,0x0000, 0x2FA1,0x0000,0x0000, /* A42A */
0x2FA2,0x0000,0x0000, 0x2FA3,0x0000,0x0000, 0x2FA4,0x0000,0x0000, /* A42D */
0x2FA5,0x0000,0x0000, 0x2FA6,0x0000,0x0000, 0x2FA7,0x0000,0x0000, /* A430 */
0x2FA8,0x0000,0x0000, 0x2FA9,0x0000,0x0000, 0x2FAA,0x0000,0x0000, /* A433 */
0x2FAB,0x0000,0x0000, 0x2FAC,0x0000,0x0000, 0x2FAD,0x0000,0x0000, /* A436 */
0x2FAE,0x0000,0x0000, 0x2FAF,0x0000,0x0000, 0x2FB0,0x0000,0x0000, /* A439 */
0x2FB1,0x0000,0x0000, 0x2FB2,0x0000,0x0000, 0x2FB3,0x0000,0x0000, /* A43C */
0x2FB4,0x0000,0x0000, 0x2FB5,0x0000,0x0000, 0x2FB6,0x0000,0x0000, /* A43F */
0x2FB7,0x0000,0x0000, 0x2FB8,0x0000,0x0000, 0x2FB9,0x0000,0x0000, /* A442 */
0x2FBA,0x0000,0x0000, 0x2FBB,0x0000,0x0000, 0x2FBC,0x0000,0x0000, /* A445 */
0x2FBD,0x0000,0x0000, 0x2FBE,0x0000,0x0000, 0x2FBF,0x0000,0x0000, /* A448 */
0x2FC0,0x0000,0x0000, 0x2FC1,0x0000,0x0000, 0x2FC2,0x0000,0x0000, /* A44B */
0x2FC3,0x0000,0x0000, 0x2FC4,0x0000,0x0000, 0x2FC5,0x0000,0x0000, /* A44E */
0x2FC6,0x0000,0x0000, 0x2FC7,0x0000,0x0000, 0x2FC8,0x0000,0x0000, /* A451 */
0x2FC9,0x0000,0x0000, 0x2FCA,0x0000,0x0000, 0x2FCB,0x0000,0x0000, /* A454 */
0x2FCC,0x0000,0x0000, 0x2FCD,0x0000,0x0000, 0x2FCE,0x0000,0x0000, /* A457 */
0x2FCF,0x0000,0x0000, 0x2FD0,0x0000,0x0000, 0x2FD1,0x0000,0x0000, /* A45A */
0x2FD2,0x0000,0x0000, 0x2FD3,0x0000,0x0000, 0x2FD4,0x0000,0x0000, /* A45D */
0x2FD5,0x0000,0x0000, 0x2FD6,0x0000,0x0000, 0x2FD7,0x0000,0x0000, /* A460 */
0x2FD8,0x0000,0x0000, 0x2FD9,0x0000,0x0000, 0x2FDA,0x0000,0x0000, /* A463 */
0x2FDB,0x0000,0x0000, 0x2FDC,0x0000,0x0000, 0x2FDD,0x0000,0x0000, /* A466 */
0x2FDE,0x0000,0x0000, 0x2FDF,0x0000,0x0000, 0x2FE0,0x0000,0x0000, /* A469 */
0x2FE1,0x0000,0x0000, 0x2FE2,0x0000,0x0000, 0x2FE3,0x0000,0x0000, /* A46C */
0x2FE4,0x0000,0x0000, 0x2FE5,0x0000,0x0000, 0x2FE6,0x0000,0x0000, /* A46F */
0x2FE7,0x0000,0x0000, 0x2FE8,0x0000,0x0000, 0x2FE9,0x0000,0x0000, /* A472 */
0x2FEA,0x0000,0x0000, 0x2FEB,0x0000,0x0000, 0x2FEC,0x0000,0x0000, /* A475 */
0x2FED,0x0000,0x0000, 0x2FEE,0x0000,0x0000, 0x2FEF,0x0000,0x0000, /* A478 */
0x2FF0,0x0000,0x0000, 0x2FF1,0x0000,0x0000, 0x2FF2,0x0000,0x0000, /* A47B */
0x2FF3,0x0000,0x0000, 0x2FF4,0x0000,0x0000, 0x2FF5,0x0000,0x0000, /* A47E */
0x2FF6,0x0000,0x0000, 0x2FF7,0x0000,0x0000, 0x2FF8,0x0000,0x0000, /* A481 */
0x2FF9,0x0000,0x0000, 0x2FFA,0x0000,0x0000, 0x2FFB,0x0000,0x0000, /* A484 */
0x2FFC,0x0000,0x0000, 0x2FFD,0x0000,0x0000, 0x2FFE,0x0000,0x0000, /* A487 */
0x2FFF,0x0000,0x0000, 0x3000,0x0000,0x0000, 0x3001,0x0000,0x0000, /* A48A */
0xFBC1,0xA48D,0x0000, 0xFBC1,0xA48E,0x0000, 0xFBC1,0xA48F,0x0000, /* A48D */
0x0DD5,0x0000,0x0000, 0x0DD6,0x0000,0x0000, 0x0DD7,0x0000,0x0000, /* A490 */
0x0DD8,0x0000,0x0000, 0x0DD9,0x0000,0x0000, 0x0DDA,0x0000,0x0000, /* A493 */
0x0DDB,0x0000,0x0000, 0x0DDC,0x0000,0x0000, 0x0DDD,0x0000,0x0000, /* A496 */
0x0DDE,0x0000,0x0000, 0x0DDF,0x0000,0x0000, 0x0DE0,0x0000,0x0000, /* A499 */
0x0DE1,0x0000,0x0000, 0x0DE2,0x0000,0x0000, 0x0DE3,0x0000,0x0000, /* A49C */
0x0DE4,0x0000,0x0000, 0x0DE5,0x0000,0x0000, 0x0DE6,0x0000,0x0000, /* A49F */
0x0DE7,0x0000,0x0000, 0x0DE8,0x0000,0x0000, 0x0DE9,0x0000,0x0000, /* A4A2 */
0x0DEA,0x0000,0x0000, 0x0DEB,0x0000,0x0000, 0x0DEC,0x0000,0x0000, /* A4A5 */
0x0DED,0x0000,0x0000, 0x0DEE,0x0000,0x0000, 0x0DEF,0x0000,0x0000, /* A4A8 */
0x0DF0,0x0000,0x0000, 0x0DF1,0x0000,0x0000, 0x0DF2,0x0000,0x0000, /* A4AB */
0x0DF3,0x0000,0x0000, 0x0DF4,0x0000,0x0000, 0x0DF5,0x0000,0x0000, /* A4AE */
0x0DF6,0x0000,0x0000, 0x0DF7,0x0000,0x0000, 0x0DF8,0x0000,0x0000, /* A4B1 */
0x0DF9,0x0000,0x0000, 0x0DFA,0x0000,0x0000, 0x0DFB,0x0000,0x0000, /* A4B4 */
0x0DFC,0x0000,0x0000, 0x0DFD,0x0000,0x0000, 0x0DFE,0x0000,0x0000, /* A4B7 */
0x0DFF,0x0000,0x0000, 0x0E00,0x0000,0x0000, 0x0E01,0x0000,0x0000, /* A4BA */
0x0E02,0x0000,0x0000, 0x0E03,0x0000,0x0000, 0x0E04,0x0000,0x0000, /* A4BD */
0x0E05,0x0000,0x0000, 0x0E06,0x0000,0x0000, 0x0E07,0x0000,0x0000, /* A4C0 */
0x0E08,0x0000,0x0000, 0x0E09,0x0000,0x0000, 0x0E0A,0x0000,0x0000, /* A4C3 */
0x0E0B,0x0000,0x0000, 0xFBC1,0xA4C7,0x0000, 0xFBC1,0xA4C8,0x0000, /* A4C6 */
0xFBC1,0xA4C9,0x0000, 0xFBC1,0xA4CA,0x0000, 0xFBC1,0xA4CB,0x0000, /* A4C9 */
0xFBC1,0xA4CC,0x0000, 0xFBC1,0xA4CD,0x0000, 0xFBC1,0xA4CE,0x0000, /* A4CC */
0xFBC1,0xA4CF,0x0000, 0x3008,0x0000,0x0000, 0x3009,0x0000,0x0000, /* A4CF */
0x300A,0x0000,0x0000, 0x300B,0x0000,0x0000, 0x300C,0x0000,0x0000, /* A4D2 */
0x300D,0x0000,0x0000, 0x300E,0x0000,0x0000, 0x300F,0x0000,0x0000, /* A4D5 */
0x3010,0x0000,0x0000, 0x3011,0x0000,0x0000, 0x3012,0x0000,0x0000, /* A4D8 */
0x3013,0x0000,0x0000, 0x3014,0x0000,0x0000, 0x3015,0x0000,0x0000, /* A4DB */
0x3016,0x0000,0x0000, 0x3017,0x0000,0x0000, 0x3018,0x0000,0x0000, /* A4DE */
0x3019,0x0000,0x0000, 0x301A,0x0000,0x0000, 0x301B,0x0000,0x0000, /* A4E1 */
0x301C,0x0000,0x0000, 0x301D,0x0000,0x0000, 0x301E,0x0000,0x0000, /* A4E4 */
0x301F,0x0000,0x0000, 0x3020,0x0000,0x0000, 0x3021,0x0000,0x0000, /* A4E7 */
0x3024,0x0000,0x0000, 0x3022,0x0000,0x0000, 0x3025,0x0000,0x0000, /* A4EA */
0x3023,0x0000,0x0000, 0x3026,0x0000,0x0000, 0x3027,0x0000,0x0000, /* A4ED */
0x3028,0x0000,0x0000, 0x3029,0x0000,0x0000, 0x302A,0x0000,0x0000, /* A4F0 */
0x302B,0x0000,0x0000, 0x302C,0x0000,0x0000, 0x302D,0x0000,0x0000, /* A4F3 */
0x302E,0x0000,0x0000, 0x302F,0x0000,0x0000, 0x3002,0x0000,0x0000, /* A4F6 */
0x3003,0x0000,0x0000, 0x3004,0x0000,0x0000, 0x3005,0x0000,0x0000, /* A4F9 */
0x3007,0x0000,0x0000, 0x3006,0x0000,0x0000, 0x023D,0x0000,0x0000, /* A4FC */
0x028E,0x0000,0x0000  };

uint16 uca520_p0A5[]= { /* A500 (2 weights per char) */
0x2853,0x0000, 0x2854,0x0000, 0x2855,0x0000, 0x2856,0x0000, /* A500 */
0x2857,0x0000, 0x2858,0x0000, 0x2859,0x0000, 0x285A,0x0000, /* A504 */
0x285B,0x0000, 0x285C,0x0000, 0x285D,0x0000, 0x285E,0x0000, /* A508 */
0x285F,0x0000, 0x2860,0x0000, 0x2861,0x0000, 0x2862,0x0000, /* A50C */
0x2863,0x0000, 0x2864,0x0000, 0x2865,0x0000, 0x2866,0x0000, /* A510 */
0x2867,0x0000, 0x2868,0x0000, 0x2869,0x0000, 0x286A,0x0000, /* A514 */
0x286B,0x0000, 0x286C,0x0000, 0x286D,0x0000, 0x286E,0x0000, /* A518 */
0x286F,0x0000, 0x2870,0x0000, 0x2871,0x0000, 0x2872,0x0000, /* A51C */
0x2873,0x0000, 0x2874,0x0000, 0x2875,0x0000, 0x2876,0x0000, /* A520 */
0x2877,0x0000, 0x2878,0x0000, 0x2879,0x0000, 0x287A,0x0000, /* A524 */
0x287B,0x0000, 0x287C,0x0000, 0x287D,0x0000, 0x287E,0x0000, /* A528 */
0x287F,0x0000, 0x2880,0x0000, 0x2881,0x0000, 0x2882,0x0000, /* A52C */
0x2883,0x0000, 0x2884,0x0000, 0x2885,0x0000, 0x2886,0x0000, /* A530 */
0x2887,0x0000, 0x2888,0x0000, 0x2889,0x0000, 0x288A,0x0000, /* A534 */
0x288B,0x0000, 0x288C,0x0000, 0x288D,0x0000, 0x288E,0x0000, /* A538 */
0x288F,0x0000, 0x2890,0x0000, 0x2891,0x0000, 0x2892,0x0000, /* A53C */
0x2893,0x0000, 0x2894,0x0000, 0x2895,0x0000, 0x2896,0x0000, /* A540 */
0x2897,0x0000, 0x2898,0x0000, 0x2899,0x0000, 0x289A,0x0000, /* A544 */
0x289B,0x0000, 0x289C,0x0000, 0x289D,0x0000, 0x289E,0x0000, /* A548 */
0x289F,0x0000, 0x28A0,0x0000, 0x28A1,0x0000, 0x28A2,0x0000, /* A54C */
0x28A3,0x0000, 0x28A4,0x0000, 0x28A5,0x0000, 0x28A6,0x0000, /* A550 */
0x28A7,0x0000, 0x28A8,0x0000, 0x28A9,0x0000, 0x28AA,0x0000, /* A554 */
0x28AB,0x0000, 0x28AC,0x0000, 0x28AD,0x0000, 0x28AE,0x0000, /* A558 */
0x28AF,0x0000, 0x28B0,0x0000, 0x28B1,0x0000, 0x28B2,0x0000, /* A55C */
0x28B3,0x0000, 0x28B4,0x0000, 0x28B5,0x0000, 0x28B6,0x0000, /* A560 */
0x28B7,0x0000, 0x28B8,0x0000, 0x28B9,0x0000, 0x28BA,0x0000, /* A564 */
0x28BB,0x0000, 0x28BC,0x0000, 0x28BD,0x0000, 0x28BE,0x0000, /* A568 */
0x28BF,0x0000, 0x28C0,0x0000, 0x28C1,0x0000, 0x28C2,0x0000, /* A56C */
0x28C3,0x0000, 0x28C4,0x0000, 0x28C5,0x0000, 0x28C6,0x0000, /* A570 */
0x28C7,0x0000, 0x28C8,0x0000, 0x28C9,0x0000, 0x28CA,0x0000, /* A574 */
0x28CB,0x0000, 0x28CC,0x0000, 0x28CD,0x0000, 0x28CE,0x0000, /* A578 */
0x28CF,0x0000, 0x28D0,0x0000, 0x28D1,0x0000, 0x28D2,0x0000, /* A57C */
0x28D3,0x0000, 0x28D4,0x0000, 0x28D5,0x0000, 0x28D6,0x0000, /* A580 */
0x28D7,0x0000, 0x28D8,0x0000, 0x28D9,0x0000, 0x28DA,0x0000, /* A584 */
0x28DB,0x0000, 0x28DC,0x0000, 0x28DD,0x0000, 0x28DE,0x0000, /* A588 */
0x28DF,0x0000, 0x28E0,0x0000, 0x28E1,0x0000, 0x28E2,0x0000, /* A58C */
0x28E3,0x0000, 0x28E4,0x0000, 0x28E5,0x0000, 0x28E6,0x0000, /* A590 */
0x28E7,0x0000, 0x28E8,0x0000, 0x28E9,0x0000, 0x28EA,0x0000, /* A594 */
0x28EB,0x0000, 0x28EC,0x0000, 0x28ED,0x0000, 0x28EE,0x0000, /* A598 */
0x28EF,0x0000, 0x28F0,0x0000, 0x28F1,0x0000, 0x28F2,0x0000, /* A59C */
0x28F3,0x0000, 0x28F4,0x0000, 0x28F5,0x0000, 0x28F6,0x0000, /* A5A0 */
0x28F7,0x0000, 0x28F8,0x0000, 0x28F9,0x0000, 0x28FA,0x0000, /* A5A4 */
0x28FB,0x0000, 0x28FC,0x0000, 0x28FD,0x0000, 0x28FE,0x0000, /* A5A8 */
0x28FF,0x0000, 0x2900,0x0000, 0x2901,0x0000, 0x2902,0x0000, /* A5AC */
0x2903,0x0000, 0x2904,0x0000, 0x2905,0x0000, 0x2906,0x0000, /* A5B0 */
0x2907,0x0000, 0x2908,0x0000, 0x2909,0x0000, 0x290A,0x0000, /* A5B4 */
0x290B,0x0000, 0x290C,0x0000, 0x290D,0x0000, 0x290E,0x0000, /* A5B8 */
0x290F,0x0000, 0x2910,0x0000, 0x2911,0x0000, 0x2912,0x0000, /* A5BC */
0x2913,0x0000, 0x2914,0x0000, 0x2915,0x0000, 0x2916,0x0000, /* A5C0 */
0x2917,0x0000, 0x2918,0x0000, 0x2919,0x0000, 0x291A,0x0000, /* A5C4 */
0x291B,0x0000, 0x291C,0x0000, 0x291D,0x0000, 0x291E,0x0000, /* A5C8 */
0x291F,0x0000, 0x2920,0x0000, 0x2921,0x0000, 0x2922,0x0000, /* A5CC */
0x2923,0x0000, 0x2924,0x0000, 0x2925,0x0000, 0x2926,0x0000, /* A5D0 */
0x2927,0x0000, 0x2928,0x0000, 0x2929,0x0000, 0x292A,0x0000, /* A5D4 */
0x292B,0x0000, 0x292C,0x0000, 0x292D,0x0000, 0x292E,0x0000, /* A5D8 */
0x292F,0x0000, 0x2930,0x0000, 0x2931,0x0000, 0x2932,0x0000, /* A5DC */
0x2933,0x0000, 0x2934,0x0000, 0x2935,0x0000, 0x2936,0x0000, /* A5E0 */
0x2937,0x0000, 0x2938,0x0000, 0x2939,0x0000, 0x293A,0x0000, /* A5E4 */
0x293B,0x0000, 0x293C,0x0000, 0x293D,0x0000, 0x293E,0x0000, /* A5E8 */
0x293F,0x0000, 0x2940,0x0000, 0x2941,0x0000, 0x2942,0x0000, /* A5EC */
0x2943,0x0000, 0x2944,0x0000, 0x2945,0x0000, 0x2946,0x0000, /* A5F0 */
0x2947,0x0000, 0x2948,0x0000, 0x2949,0x0000, 0x294A,0x0000, /* A5F4 */
0x294B,0x0000, 0x294C,0x0000, 0x294D,0x0000, 0x294E,0x0000, /* A5F8 */
0x294F,0x0000, 0x2950,0x0000, 0x2951,0x0000, 0x2952,0x0000  /* A5FC */
};

uint16 uca520_p0A6[]= { /* A600 (3 weights per char) */
0x2953,0x0000,0x0000, 0x2954,0x0000,0x0000, 0x2955,0x0000,0x0000, /* A600 */
0x2956,0x0000,0x0000, 0x2957,0x0000,0x0000, 0x2958,0x0000,0x0000, /* A603 */
0x2959,0x0000,0x0000, 0x295A,0x0000,0x0000, 0x295B,0x0000,0x0000, /* A606 */
0x295C,0x0000,0x0000, 0x295D,0x0000,0x0000, 0x295E,0x0000,0x0000, /* A609 */
0x295F,0x0000,0x0000, 0x023E,0x0000,0x0000, 0x028F,0x0000,0x0000, /* A60C */
0x027D,0x0000,0x0000, 0x28AB,0x0000,0x0000, 0x28BD,0x0000,0x0000, /* A60F */
0x28DA,0x0000,0x0000, 0x285F,0x295E,0x0000, 0x2871,0x295E,0x0000, /* A612 */
0x2886,0x295E,0x0000, 0x289A,0x295F,0x0000, 0x28A5,0x295E,0x0000, /* A615 */
0x28AB,0x295F,0x0000, 0x28AD,0x295F,0x0000, 0x28B3,0x295E,0x0000, /* A618 */
0x28D8,0x295E,0x0000, 0x2907,0x295E,0x0000, 0x291E,0x295E,0x0000, /* A61B */
0x2924,0x295F,0x0000, 0x292B,0x295E,0x0000, 0x1205,0x0000,0x0000, /* A61E */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* A621 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* A624 */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* A627 */
0x28C1,0x0000,0x0000, 0x2924,0x0000,0x0000, 0xFBC1,0xA62C,0x0000, /* A62A */
0xFBC1,0xA62D,0x0000, 0xFBC1,0xA62E,0x0000, 0xFBC1,0xA62F,0x0000, /* A62D */
0xFBC1,0xA630,0x0000, 0xFBC1,0xA631,0x0000, 0xFBC1,0xA632,0x0000, /* A630 */
0xFBC1,0xA633,0x0000, 0xFBC1,0xA634,0x0000, 0xFBC1,0xA635,0x0000, /* A633 */
0xFBC1,0xA636,0x0000, 0xFBC1,0xA637,0x0000, 0xFBC1,0xA638,0x0000, /* A636 */
0xFBC1,0xA639,0x0000, 0xFBC1,0xA63A,0x0000, 0xFBC1,0xA63B,0x0000, /* A639 */
0xFBC1,0xA63C,0x0000, 0xFBC1,0xA63D,0x0000, 0xFBC1,0xA63E,0x0000, /* A63C */
0xFBC1,0xA63F,0x0000, 0x1611,0x0000,0x0000, 0x1611,0x0000,0x0000, /* A63F */
0x1618,0x0000,0x0000, 0x1618,0x0000,0x0000, 0x161D,0x0000,0x0000, /* A642 */
0x161D,0x0000,0x0000, 0x1635,0x0000,0x0000, 0x1635,0x0000,0x0000, /* A645 */
0x1642,0x0000,0x0000, 0x1642,0x0000,0x0000, 0x16EC,0x0000,0x0000, /* A648 */
0x16EC,0x0000,0x0000, 0x1712,0x0000,0x0000, 0x1712,0x0000,0x0000, /* A64B */
0x1750,0x0000,0x0000, 0x1750,0x0000,0x0000, 0x1757,0x0000,0x0000, /* A64E */
0x1757,0x0000,0x0000, 0x176C,0x0000,0x0000, 0x176C,0x0000,0x0000, /* A651 */
0x1779,0x0000,0x0000, 0x1779,0x0000,0x0000, 0x177A,0x0000,0x0000, /* A654 */
0x177A,0x0000,0x0000, 0x1788,0x0000,0x0000, 0x1788,0x0000,0x0000, /* A657 */
0x178D,0x0000,0x0000, 0x178D,0x0000,0x0000, 0x1792,0x0000,0x0000, /* A65A */
0x1792,0x0000,0x0000, 0x17AB,0x0000,0x0000, 0x17AB,0x0000,0x0000, /* A65D */
0xFBC1,0xA660,0x0000, 0xFBC1,0xA661,0x0000, 0x15EA,0x0000,0x0000, /* A660 */
0x15EA,0x0000,0x0000, 0x166C,0x0000,0x0000, 0x166C,0x0000,0x0000, /* A663 */
0x1677,0x0000,0x0000, 0x1677,0x0000,0x0000, 0x1692,0x0000,0x0000, /* A666 */
0x1692,0x0000,0x0000, 0x1692,0x0000,0x0000, 0x1692,0x0000,0x0000, /* A669 */
0x1692,0x0000,0x0000, 0x1692,0x0000,0x0000, 0x1692,0x0000,0x0000, /* A66C */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* A66F */
0x0000,0x0000,0x0000, 0x035B,0x0000,0x0000, 0xFBC1,0xA674,0x0000, /* A672 */
0xFBC1,0xA675,0x0000, 0xFBC1,0xA676,0x0000, 0xFBC1,0xA677,0x0000, /* A675 */
0xFBC1,0xA678,0x0000, 0xFBC1,0xA679,0x0000, 0xFBC1,0xA67A,0x0000, /* A678 */
0xFBC1,0xA67B,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* A67B */
0x0391,0x0000,0x0000, 0x1752,0x0000,0x0000, 0x15E5,0x0000,0x0000, /* A67E */
0x15E5,0x0000,0x0000, 0x1624,0x0000,0x0000, 0x1624,0x0000,0x0000, /* A681 */
0x1604,0x0000,0x0000, 0x1604,0x0000,0x0000, 0x173A,0x0000,0x0000, /* A684 */
0x173A,0x0000,0x0000, 0x1622,0x0000,0x0000, 0x1622,0x0000,0x0000, /* A687 */
0x16CB,0x0000,0x0000, 0x16CB,0x0000,0x0000, 0x16C5,0x0000,0x0000, /* A68A */
0x16C5,0x0000,0x0000, 0x171F,0x0000,0x0000, 0x171F,0x0000,0x0000, /* A68D */
0x1724,0x0000,0x0000, 0x1724,0x0000,0x0000, 0x1729,0x0000,0x0000, /* A690 */
0x1729,0x0000,0x0000, 0x1709,0x0000,0x0000, 0x1709,0x0000,0x0000, /* A693 */
0x174B,0x0000,0x0000, 0x174B,0x0000,0x0000, 0xFBC1,0xA698,0x0000, /* A696 */
0xFBC1,0xA699,0x0000, 0xFBC1,0xA69A,0x0000, 0xFBC1,0xA69B,0x0000, /* A699 */
0xFBC1,0xA69C,0x0000, 0xFBC1,0xA69D,0x0000, 0xFBC1,0xA69E,0x0000, /* A69C */
0xFBC1,0xA69F,0x0000, 0x2960,0x0000,0x0000, 0x2961,0x0000,0x0000, /* A69F */
0x2962,0x0000,0x0000, 0x2963,0x0000,0x0000, 0x2964,0x0000,0x0000, /* A6A2 */
0x2965,0x0000,0x0000, 0x2966,0x0000,0x0000, 0x2967,0x0000,0x0000, /* A6A5 */
0x2968,0x0000,0x0000, 0x2969,0x0000,0x0000, 0x296A,0x0000,0x0000, /* A6A8 */
0x296B,0x0000,0x0000, 0x296C,0x0000,0x0000, 0x296D,0x0000,0x0000, /* A6AB */
0x296E,0x0000,0x0000, 0x296F,0x0000,0x0000, 0x2970,0x0000,0x0000, /* A6AE */
0x2971,0x0000,0x0000, 0x2972,0x0000,0x0000, 0x2973,0x0000,0x0000, /* A6B1 */
0x2974,0x0000,0x0000, 0x2975,0x0000,0x0000, 0x2976,0x0000,0x0000, /* A6B4 */
0x2977,0x0000,0x0000, 0x2978,0x0000,0x0000, 0x2979,0x0000,0x0000, /* A6B7 */
0x297A,0x0000,0x0000, 0x297B,0x0000,0x0000, 0x297C,0x0000,0x0000, /* A6BA */
0x297D,0x0000,0x0000, 0x297E,0x0000,0x0000, 0x297F,0x0000,0x0000, /* A6BD */
0x2980,0x0000,0x0000, 0x2981,0x0000,0x0000, 0x2982,0x0000,0x0000, /* A6C0 */
0x2983,0x0000,0x0000, 0x2984,0x0000,0x0000, 0x2985,0x0000,0x0000, /* A6C3 */
0x2986,0x0000,0x0000, 0x2987,0x0000,0x0000, 0x2988,0x0000,0x0000, /* A6C6 */
0x2989,0x0000,0x0000, 0x298A,0x0000,0x0000, 0x298B,0x0000,0x0000, /* A6C9 */
0x298C,0x0000,0x0000, 0x298D,0x0000,0x0000, 0x298E,0x0000,0x0000, /* A6CC */
0x298F,0x0000,0x0000, 0x2990,0x0000,0x0000, 0x2991,0x0000,0x0000, /* A6CF */
0x2992,0x0000,0x0000, 0x2993,0x0000,0x0000, 0x2994,0x0000,0x0000, /* A6D2 */
0x2995,0x0000,0x0000, 0x2996,0x0000,0x0000, 0x2997,0x0000,0x0000, /* A6D5 */
0x2998,0x0000,0x0000, 0x2999,0x0000,0x0000, 0x299A,0x0000,0x0000, /* A6D8 */
0x299B,0x0000,0x0000, 0x299C,0x0000,0x0000, 0x299D,0x0000,0x0000, /* A6DB */
0x299E,0x0000,0x0000, 0x299F,0x0000,0x0000, 0x29A0,0x0000,0x0000, /* A6DE */
0x29A1,0x0000,0x0000, 0x29A2,0x0000,0x0000, 0x29A3,0x0000,0x0000, /* A6E1 */
0x29A4,0x0000,0x0000, 0x29A5,0x0000,0x0000, 0x29A6,0x0000,0x0000, /* A6E4 */
0x29A7,0x0000,0x0000, 0x29A8,0x0000,0x0000, 0x29A9,0x0000,0x0000, /* A6E7 */
0x29AA,0x0000,0x0000, 0x29AB,0x0000,0x0000, 0x29AC,0x0000,0x0000, /* A6EA */
0x29AD,0x0000,0x0000, 0x29AE,0x0000,0x0000, 0x29AF,0x0000,0x0000, /* A6ED */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x02C8,0x0000,0x0000, /* A6F0 */
0x0290,0x0000,0x0000, 0x026D,0x0000,0x0000, 0x023F,0x0000,0x0000, /* A6F3 */
0x0246,0x0000,0x0000, 0x027E,0x0000,0x0000, 0xFBC1,0xA6F8,0x0000, /* A6F6 */
0xFBC1,0xA6F9,0x0000, 0xFBC1,0xA6FA,0x0000, 0xFBC1,0xA6FB,0x0000, /* A6F9 */
0xFBC1,0xA6FC,0x0000, 0xFBC1,0xA6FD,0x0000, 0xFBC1,0xA6FE,0x0000, /* A6FC */
0xFBC1,0xA6FF,0x0000  };

uint16 uca520_p0A7[]= { /* A700 (3 weights per char) */
0x0426,0x0000,0x0000, 0x0427,0x0000,0x0000, 0x0428,0x0000,0x0000, /* A700 */
0x0429,0x0000,0x0000, 0x042A,0x0000,0x0000, 0x042B,0x0000,0x0000, /* A703 */
0x042C,0x0000,0x0000, 0x042D,0x0000,0x0000, 0x042E,0x0000,0x0000, /* A706 */
0x042F,0x0000,0x0000, 0x0430,0x0000,0x0000, 0x0431,0x0000,0x0000, /* A709 */
0x0432,0x0000,0x0000, 0x0433,0x0000,0x0000, 0x0434,0x0000,0x0000, /* A70C */
0x0435,0x0000,0x0000, 0x0436,0x0000,0x0000, 0x0437,0x0000,0x0000, /* A70F */
0x0438,0x0000,0x0000, 0x0439,0x0000,0x0000, 0x043A,0x0000,0x0000, /* A712 */
0x043B,0x0000,0x0000, 0x043C,0x0000,0x0000, 0x043D,0x0000,0x0000, /* A715 */
0x043E,0x0000,0x0000, 0x043F,0x0000,0x0000, 0x0440,0x0000,0x0000, /* A718 */
0x0441,0x0000,0x0000, 0x0442,0x0000,0x0000, 0x0443,0x0000,0x0000, /* A71B */
0x0444,0x0000,0x0000, 0x0445,0x0000,0x0000, 0x0446,0x0000,0x0000, /* A71E */
0x0447,0x0000,0x0000, 0x150E,0x0000,0x0000, 0x150E,0x0000,0x0000, /* A721 */
0x1518,0x0000,0x0000, 0x1518,0x0000,0x0000, 0x12E5,0x0000,0x0000, /* A724 */
0x12E5,0x0000,0x0000, 0x1433,0x14AD,0x0000, 0x1433,0x14AD,0x0000, /* A727 */
0x14F3,0x0000,0x0000, 0x14F3,0x0000,0x0000, 0x14F4,0x0000,0x0000, /* A72A */
0x14F4,0x0000,0x0000, 0x14F5,0x0000,0x0000, 0x14F5,0x0000,0x0000, /* A72D */
0x12A7,0x0000,0x0000, 0x1414,0x0000,0x0000, 0x120F,0x120F,0x0000, /* A730 */
0x120F,0x120F,0x0000, 0x120F,0x138E,0x0000, 0x120F,0x138E,0x0000, /* A733 */
0x120F,0x1453,0x0000, 0x120F,0x1453,0x0000, 0x120F,0x147B,0x0000, /* A736 */
0x120F,0x147B,0x0000, 0x120F,0x147B,0x0000, 0x120F,0x147B,0x0000, /* A739 */
0x120F,0x149C,0x0000, 0x120F,0x149C,0x0000, 0x124F,0x0000,0x0000, /* A73C */
0x124F,0x0000,0x0000, 0x1329,0x0000,0x0000, 0x1329,0x0000,0x0000, /* A73F */
0x132A,0x0000,0x0000, 0x132A,0x0000,0x0000, 0x132B,0x0000,0x0000, /* A742 */
0x132B,0x0000,0x0000, 0x1338,0x0000,0x0000, 0x1338,0x0000,0x0000, /* A745 */
0x133A,0x0000,0x0000, 0x133A,0x0000,0x0000, 0x13A9,0x0000,0x0000, /* A748 */
0x13A9,0x0000,0x0000, 0x13A1,0x0000,0x0000, 0x13A1,0x0000,0x0000, /* A74B */
0x138E,0x138E,0x0000, 0x138E,0x138E,0x0000, 0x13B9,0x0000,0x0000, /* A74E */
0x13B9,0x0000,0x0000, 0x13C0,0x0000,0x0000, 0x13C0,0x0000,0x0000, /* A751 */
0x13C1,0x0000,0x0000, 0x13C1,0x0000,0x0000, 0x13CC,0x0000,0x0000, /* A754 */
0x13CC,0x0000,0x0000, 0x13CD,0x0000,0x0000, 0x13CD,0x0000,0x0000, /* A757 */
0x13E2,0x0000,0x0000, 0x13E2,0x0000,0x0000, 0x140F,0x0000,0x0000, /* A75A */
0x140F,0x0000,0x0000, 0x1480,0x0000,0x0000, 0x1480,0x0000,0x0000, /* A75D */
0x147B,0x149C,0x0000, 0x147B,0x149C,0x0000, 0x14C9,0x0000,0x0000, /* A760 */
0x14C9,0x0000,0x0000, 0x14E4,0x0000,0x0000, 0x14E4,0x0000,0x0000, /* A763 */
0x14E5,0x0000,0x0000, 0x14E5,0x0000,0x0000, 0x14EA,0x0000,0x0000, /* A766 */
0x14EA,0x0000,0x0000, 0x14EB,0x0000,0x0000, 0x14EB,0x0000,0x0000, /* A769 */
0x14EC,0x0000,0x0000, 0x14EC,0x0000,0x0000, 0x14ED,0x0000,0x0000, /* A76C */
0x14ED,0x0000,0x0000, 0x14ED,0x0000,0x0000, 0x1269,0x0000,0x0000, /* A76F */
0x1351,0x0000,0x0000, 0x136C,0x0000,0x0000, 0x1389,0x0000,0x0000, /* A772 */
0x140D,0x0000,0x0000, 0x140E,0x0000,0x0000, 0x144E,0x0000,0x0000, /* A775 */
0x14EE,0x0000,0x0000, 0x1250,0x0000,0x0000, 0x1250,0x0000,0x0000, /* A778 */
0x12A3,0x0000,0x0000, 0x12A3,0x0000,0x0000, 0x12B0,0x0000,0x0000, /* A77B */
0x12CA,0x0000,0x0000, 0x12CA,0x0000,0x0000, 0x1356,0x0000,0x0000, /* A77E */
0x1356,0x0000,0x0000, 0x13DA,0x0000,0x0000, 0x13DA,0x0000,0x0000, /* A781 */
0x1410,0x0000,0x0000, 0x1410,0x0000,0x0000, 0x1433,0x0000,0x0000, /* A784 */
0x1433,0x0000,0x0000, 0x0448,0x0000,0x0000, 0x0449,0x0000,0x0000, /* A787 */
0x044A,0x0000,0x0000, 0x150F,0x0000,0x0000, 0x150F,0x0000,0x0000, /* A78A */
0xFBC1,0xA78D,0x0000, 0xFBC1,0xA78E,0x0000, 0xFBC1,0xA78F,0x0000, /* A78D */
0xFBC1,0xA790,0x0000, 0xFBC1,0xA791,0x0000, 0xFBC1,0xA792,0x0000, /* A790 */
0xFBC1,0xA793,0x0000, 0xFBC1,0xA794,0x0000, 0xFBC1,0xA795,0x0000, /* A793 */
0xFBC1,0xA796,0x0000, 0xFBC1,0xA797,0x0000, 0xFBC1,0xA798,0x0000, /* A796 */
0xFBC1,0xA799,0x0000, 0xFBC1,0xA79A,0x0000, 0xFBC1,0xA79B,0x0000, /* A799 */
0xFBC1,0xA79C,0x0000, 0xFBC1,0xA79D,0x0000, 0xFBC1,0xA79E,0x0000, /* A79C */
0xFBC1,0xA79F,0x0000, 0xFBC1,0xA7A0,0x0000, 0xFBC1,0xA7A1,0x0000, /* A79F */
0xFBC1,0xA7A2,0x0000, 0xFBC1,0xA7A3,0x0000, 0xFBC1,0xA7A4,0x0000, /* A7A2 */
0xFBC1,0xA7A5,0x0000, 0xFBC1,0xA7A6,0x0000, 0xFBC1,0xA7A7,0x0000, /* A7A5 */
0xFBC1,0xA7A8,0x0000, 0xFBC1,0xA7A9,0x0000, 0xFBC1,0xA7AA,0x0000, /* A7A8 */
0xFBC1,0xA7AB,0x0000, 0xFBC1,0xA7AC,0x0000, 0xFBC1,0xA7AD,0x0000, /* A7AB */
0xFBC1,0xA7AE,0x0000, 0xFBC1,0xA7AF,0x0000, 0xFBC1,0xA7B0,0x0000, /* A7AE */
0xFBC1,0xA7B1,0x0000, 0xFBC1,0xA7B2,0x0000, 0xFBC1,0xA7B3,0x0000, /* A7B1 */
0xFBC1,0xA7B4,0x0000, 0xFBC1,0xA7B5,0x0000, 0xFBC1,0xA7B6,0x0000, /* A7B4 */
0xFBC1,0xA7B7,0x0000, 0xFBC1,0xA7B8,0x0000, 0xFBC1,0xA7B9,0x0000, /* A7B7 */
0xFBC1,0xA7BA,0x0000, 0xFBC1,0xA7BB,0x0000, 0xFBC1,0xA7BC,0x0000, /* A7BA */
0xFBC1,0xA7BD,0x0000, 0xFBC1,0xA7BE,0x0000, 0xFBC1,0xA7BF,0x0000, /* A7BD */
0xFBC1,0xA7C0,0x0000, 0xFBC1,0xA7C1,0x0000, 0xFBC1,0xA7C2,0x0000, /* A7C0 */
0xFBC1,0xA7C3,0x0000, 0xFBC1,0xA7C4,0x0000, 0xFBC1,0xA7C5,0x0000, /* A7C3 */
0xFBC1,0xA7C6,0x0000, 0xFBC1,0xA7C7,0x0000, 0xFBC1,0xA7C8,0x0000, /* A7C6 */
0xFBC1,0xA7C9,0x0000, 0xFBC1,0xA7CA,0x0000, 0xFBC1,0xA7CB,0x0000, /* A7C9 */
0xFBC1,0xA7CC,0x0000, 0xFBC1,0xA7CD,0x0000, 0xFBC1,0xA7CE,0x0000, /* A7CC */
0xFBC1,0xA7CF,0x0000, 0xFBC1,0xA7D0,0x0000, 0xFBC1,0xA7D1,0x0000, /* A7CF */
0xFBC1,0xA7D2,0x0000, 0xFBC1,0xA7D3,0x0000, 0xFBC1,0xA7D4,0x0000, /* A7D2 */
0xFBC1,0xA7D5,0x0000, 0xFBC1,0xA7D6,0x0000, 0xFBC1,0xA7D7,0x0000, /* A7D5 */
0xFBC1,0xA7D8,0x0000, 0xFBC1,0xA7D9,0x0000, 0xFBC1,0xA7DA,0x0000, /* A7D8 */
0xFBC1,0xA7DB,0x0000, 0xFBC1,0xA7DC,0x0000, 0xFBC1,0xA7DD,0x0000, /* A7DB */
0xFBC1,0xA7DE,0x0000, 0xFBC1,0xA7DF,0x0000, 0xFBC1,0xA7E0,0x0000, /* A7DE */
0xFBC1,0xA7E1,0x0000, 0xFBC1,0xA7E2,0x0000, 0xFBC1,0xA7E3,0x0000, /* A7E1 */
0xFBC1,0xA7E4,0x0000, 0xFBC1,0xA7E5,0x0000, 0xFBC1,0xA7E6,0x0000, /* A7E4 */
0xFBC1,0xA7E7,0x0000, 0xFBC1,0xA7E8,0x0000, 0xFBC1,0xA7E9,0x0000, /* A7E7 */
0xFBC1,0xA7EA,0x0000, 0xFBC1,0xA7EB,0x0000, 0xFBC1,0xA7EC,0x0000, /* A7EA */
0xFBC1,0xA7ED,0x0000, 0xFBC1,0xA7EE,0x0000, 0xFBC1,0xA7EF,0x0000, /* A7ED */
0xFBC1,0xA7F0,0x0000, 0xFBC1,0xA7F1,0x0000, 0xFBC1,0xA7F2,0x0000, /* A7F0 */
0xFBC1,0xA7F3,0x0000, 0xFBC1,0xA7F4,0x0000, 0xFBC1,0xA7F5,0x0000, /* A7F3 */
0xFBC1,0xA7F6,0x0000, 0xFBC1,0xA7F7,0x0000, 0xFBC1,0xA7F8,0x0000, /* A7F6 */
0xFBC1,0xA7F9,0x0000, 0xFBC1,0xA7FA,0x0000, 0x12AF,0x0000,0x0000, /* A7F9 */
0x13C2,0x0000,0x0000, 0x136A,0x0000,0x0000, 0x12F8,0x0000,0x0000, /* A7FC */
0x136B,0x0000,0x0000  };

uint16 uca520_p0A8[]= { /* A800 (3 weights per char) */
0x1E7E,0x0000,0x0000, 0x1E7F,0x0000,0x0000, 0x1E80,0x0000,0x0000, /* A800 */
0x1E81,0x0000,0x0000, 0x1E82,0x0000,0x0000, 0x1E83,0x0000,0x0000, /* A803 */
0x1E84,0x0000,0x0000, 0x1E85,0x0000,0x0000, 0x1E86,0x0000,0x0000, /* A806 */
0x1E87,0x0000,0x0000, 0x1E88,0x0000,0x0000, 0x0000,0x0000,0x0000, /* A809 */
0x1E89,0x0000,0x0000, 0x1E8A,0x0000,0x0000, 0x1E8B,0x0000,0x0000, /* A80C */
0x1E8C,0x0000,0x0000, 0x1E8D,0x0000,0x0000, 0x1E8E,0x0000,0x0000, /* A80F */
0x1E8F,0x0000,0x0000, 0x1E90,0x0000,0x0000, 0x1E91,0x0000,0x0000, /* A812 */
0x1E92,0x0000,0x0000, 0x1E93,0x0000,0x0000, 0x1E94,0x0000,0x0000, /* A815 */
0x1E95,0x0000,0x0000, 0x1E96,0x0000,0x0000, 0x1E97,0x0000,0x0000, /* A818 */
0x1E98,0x0000,0x0000, 0x1E99,0x0000,0x0000, 0x1E9A,0x0000,0x0000, /* A81B */
0x1E9B,0x0000,0x0000, 0x1E9C,0x0000,0x0000, 0x1E9D,0x0000,0x0000, /* A81E */
0x1E9E,0x0000,0x0000, 0x1E9F,0x0000,0x0000, 0x1EA0,0x0000,0x0000, /* A821 */
0x1EA1,0x0000,0x0000, 0x1EA2,0x0000,0x0000, 0x1EA3,0x0000,0x0000, /* A824 */
0x1EA4,0x0000,0x0000, 0x0460,0x0000,0x0000, 0x0461,0x0000,0x0000, /* A827 */
0x0462,0x0000,0x0000, 0x0463,0x0000,0x0000, 0xFBC1,0xA82C,0x0000, /* A82A */
0xFBC1,0xA82D,0x0000, 0xFBC1,0xA82E,0x0000, 0xFBC1,0xA82F,0x0000, /* A82D */
0x1116,0x0000,0x0000, 0x1117,0x0000,0x0000, 0x1118,0x0000,0x0000, /* A830 */
0x1119,0x0000,0x0000, 0x111A,0x0000,0x0000, 0x111B,0x0000,0x0000, /* A833 */
0x0464,0x0000,0x0000, 0x0465,0x0000,0x0000, 0x11E9,0x0000,0x0000, /* A836 */
0x0466,0x0000,0x0000, 0xFBC1,0xA83A,0x0000, 0xFBC1,0xA83B,0x0000, /* A839 */
0xFBC1,0xA83C,0x0000, 0xFBC1,0xA83D,0x0000, 0xFBC1,0xA83E,0x0000, /* A83C */
0xFBC1,0xA83F,0x0000, 0x20B7,0x0000,0x0000, 0x20B8,0x0000,0x0000, /* A83F */
0x20B9,0x0000,0x0000, 0x20BA,0x0000,0x0000, 0x20BB,0x0000,0x0000, /* A842 */
0x20BC,0x0000,0x0000, 0x20BD,0x0000,0x0000, 0x20BE,0x0000,0x0000, /* A845 */
0x20C3,0x0000,0x0000, 0x20C4,0x0000,0x0000, 0x20C5,0x0000,0x0000, /* A848 */
0x20C6,0x0000,0x0000, 0x20C7,0x0000,0x0000, 0x20C8,0x0000,0x0000, /* A84B */
0x20C9,0x0000,0x0000, 0x20CA,0x0000,0x0000, 0x20CB,0x0000,0x0000, /* A84E */
0x20CC,0x0000,0x0000, 0x20CD,0x0000,0x0000, 0x20CE,0x0000,0x0000, /* A851 */
0x20D0,0x0000,0x0000, 0x20D1,0x0000,0x0000, 0x20D2,0x0000,0x0000, /* A854 */
0x20D3,0x0000,0x0000, 0x20D6,0x0000,0x0000, 0x20D9,0x0000,0x0000, /* A857 */
0x20DA,0x0000,0x0000, 0x20DC,0x0000,0x0000, 0x20DD,0x0000,0x0000, /* A85A */
0x20E0,0x0000,0x0000, 0x20E5,0x0000,0x0000, 0x20E6,0x0000,0x0000, /* A85D */
0x20E7,0x0000,0x0000, 0x20E8,0x0000,0x0000, 0x20E1,0x0000,0x0000, /* A860 */
0x20E2,0x0000,0x0000, 0x20E3,0x0000,0x0000, 0x20E4,0x0000,0x0000, /* A863 */
0x20E9,0x0000,0x0000, 0x20CF,0x0000,0x0000, 0x20D4,0x0000,0x0000, /* A866 */
0x20BF,0x0000,0x0000, 0x20C0,0x0000,0x0000, 0x20C1,0x0000,0x0000, /* A869 */
0x20C2,0x0000,0x0000, 0x20D5,0x0000,0x0000, 0x20DB,0x0000,0x0000, /* A86C */
0x20DE,0x0000,0x0000, 0x20DF,0x0000,0x0000, 0x20D7,0x0000,0x0000, /* A86F */
0x20D8,0x0000,0x0000, 0x20EA,0x0000,0x0000, 0x03D9,0x0000,0x0000, /* A872 */
0x03DA,0x0000,0x0000, 0x029A,0x0000,0x0000, 0x029B,0x0000,0x0000, /* A875 */
0xFBC1,0xA878,0x0000, 0xFBC1,0xA879,0x0000, 0xFBC1,0xA87A,0x0000, /* A878 */
0xFBC1,0xA87B,0x0000, 0xFBC1,0xA87C,0x0000, 0xFBC1,0xA87D,0x0000, /* A87B */
0xFBC1,0xA87E,0x0000, 0xFBC1,0xA87F,0x0000, 0x0000,0x0000,0x0000, /* A87E */
0x0000,0x0000,0x0000, 0x1EA5,0x0000,0x0000, 0x1EA6,0x0000,0x0000, /* A881 */
0x1EA7,0x0000,0x0000, 0x1EA8,0x0000,0x0000, 0x1EA9,0x0000,0x0000, /* A884 */
0x1EAA,0x0000,0x0000, 0x1EAB,0x0000,0x0000, 0x1EAC,0x0000,0x0000, /* A887 */
0x1EAD,0x0000,0x0000, 0x1EAE,0x0000,0x0000, 0x1EAF,0x0000,0x0000, /* A88A */
0x1EB0,0x0000,0x0000, 0x1EB1,0x0000,0x0000, 0x1EB2,0x0000,0x0000, /* A88D */
0x1EB3,0x0000,0x0000, 0x1EB4,0x0000,0x0000, 0x1EB5,0x0000,0x0000, /* A890 */
0x1EB6,0x0000,0x0000, 0x1EB7,0x0000,0x0000, 0x1EB8,0x0000,0x0000, /* A893 */
0x1EB9,0x0000,0x0000, 0x1EBA,0x0000,0x0000, 0x1EBB,0x0000,0x0000, /* A896 */
0x1EBC,0x0000,0x0000, 0x1EBD,0x0000,0x0000, 0x1EBE,0x0000,0x0000, /* A899 */
0x1EBF,0x0000,0x0000, 0x1EC0,0x0000,0x0000, 0x1EC1,0x0000,0x0000, /* A89C */
0x1EC2,0x0000,0x0000, 0x1EC3,0x0000,0x0000, 0x1EC4,0x0000,0x0000, /* A89F */
0x1EC5,0x0000,0x0000, 0x1EC6,0x0000,0x0000, 0x1EC7,0x0000,0x0000, /* A8A2 */
0x1EC8,0x0000,0x0000, 0x1EC9,0x0000,0x0000, 0x1ECA,0x0000,0x0000, /* A8A5 */
0x1ECB,0x0000,0x0000, 0x1ECC,0x0000,0x0000, 0x1ECD,0x0000,0x0000, /* A8A8 */
0x1ECE,0x0000,0x0000, 0x1ECF,0x0000,0x0000, 0x1ED0,0x0000,0x0000, /* A8AB */
0x1ED1,0x0000,0x0000, 0x1ED2,0x0000,0x0000, 0x1ED3,0x0000,0x0000, /* A8AE */
0x1ED4,0x0000,0x0000, 0x1ED5,0x0000,0x0000, 0x1ED6,0x0000,0x0000, /* A8B1 */
0x1ED7,0x0000,0x0000, 0x1ED8,0x0000,0x0000, 0x1ED9,0x0000,0x0000, /* A8B4 */
0x1EDA,0x0000,0x0000, 0x1EDB,0x0000,0x0000, 0x1EDC,0x0000,0x0000, /* A8B7 */
0x1EDD,0x0000,0x0000, 0x1EDE,0x0000,0x0000, 0x1EDF,0x0000,0x0000, /* A8BA */
0x1EE0,0x0000,0x0000, 0x1EE1,0x0000,0x0000, 0x1EE2,0x0000,0x0000, /* A8BD */
0x1EE3,0x0000,0x0000, 0x1EE4,0x0000,0x0000, 0x1EE5,0x0000,0x0000, /* A8C0 */
0x1EE6,0x0000,0x0000, 0x1EE7,0x0000,0x0000, 0xFBC1,0xA8C5,0x0000, /* A8C3 */
0xFBC1,0xA8C6,0x0000, 0xFBC1,0xA8C7,0x0000, 0xFBC1,0xA8C8,0x0000, /* A8C6 */
0xFBC1,0xA8C9,0x0000, 0xFBC1,0xA8CA,0x0000, 0xFBC1,0xA8CB,0x0000, /* A8C9 */
0xFBC1,0xA8CC,0x0000, 0xFBC1,0xA8CD,0x0000, 0x0296,0x0000,0x0000, /* A8CC */
0x0297,0x0000,0x0000, 0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, /* A8CF */
0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, /* A8D2 */
0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, /* A8D5 */
0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, 0xFBC1,0xA8DA,0x0000, /* A8D8 */
0xFBC1,0xA8DB,0x0000, 0xFBC1,0xA8DC,0x0000, 0xFBC1,0xA8DD,0x0000, /* A8DB */
0xFBC1,0xA8DE,0x0000, 0xFBC1,0xA8DF,0x0000, 0x0000,0x0000,0x0000, /* A8DE */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* A8E1 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* A8E4 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* A8E7 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* A8EA */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* A8ED */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x1BE8,0x0000,0x0000, /* A8F0 */
0x1BE8,0x0000,0x0000, 0x1BE8,0x0000,0x0000, 0x1BE8,0x0000,0x0000, /* A8F3 */
0x1BE8,0x0000,0x0000, 0x1BE8,0x0000,0x0000, 0x03A2,0x0000,0x0000, /* A8F6 */
0x03A3,0x0000,0x0000, 0x03A4,0x0000,0x0000, 0x1BE9,0x0000,0x0000, /* A8F9 */
0xFBC1,0xA8FC,0x0000, 0xFBC1,0xA8FD,0x0000, 0xFBC1,0xA8FE,0x0000, /* A8FC */
0xFBC1,0xA8FF,0x0000  };

uint16 uca520_p0A9[]= { /* A900 (3 weights per char) */
0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* A900 */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, /* A903 */
0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, /* A906 */
0x120E,0x0000,0x0000, 0x21AC,0x0000,0x0000, 0x21AD,0x0000,0x0000, /* A909 */
0x21AE,0x0000,0x0000, 0x21AF,0x0000,0x0000, 0x21B0,0x0000,0x0000, /* A90C */
0x21B1,0x0000,0x0000, 0x21B2,0x0000,0x0000, 0x21B3,0x0000,0x0000, /* A90F */
0x21B4,0x0000,0x0000, 0x21B5,0x0000,0x0000, 0x21B6,0x0000,0x0000, /* A912 */
0x21B7,0x0000,0x0000, 0x21B8,0x0000,0x0000, 0x21B9,0x0000,0x0000, /* A915 */
0x21BA,0x0000,0x0000, 0x21BB,0x0000,0x0000, 0x21BC,0x0000,0x0000, /* A918 */
0x21BD,0x0000,0x0000, 0x21BE,0x0000,0x0000, 0x21BF,0x0000,0x0000, /* A91B */
0x21C0,0x0000,0x0000, 0x21C1,0x0000,0x0000, 0x21C2,0x0000,0x0000, /* A91E */
0x21C3,0x0000,0x0000, 0x21C4,0x0000,0x0000, 0x21C5,0x0000,0x0000, /* A921 */
0x21C6,0x0000,0x0000, 0x21C7,0x0000,0x0000, 0x21C8,0x0000,0x0000, /* A924 */
0x21C9,0x0000,0x0000, 0x21CA,0x0000,0x0000, 0x21CB,0x0000,0x0000, /* A927 */
0x21CC,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* A92A */
0x0000,0x0000,0x0000, 0x03DB,0x0000,0x0000, 0x029E,0x0000,0x0000, /* A92D */
0x2188,0x0000,0x0000, 0x2189,0x0000,0x0000, 0x218A,0x0000,0x0000, /* A930 */
0x218B,0x0000,0x0000, 0x218C,0x0000,0x0000, 0x218D,0x0000,0x0000, /* A933 */
0x218E,0x0000,0x0000, 0x218F,0x0000,0x0000, 0x2190,0x0000,0x0000, /* A936 */
0x2191,0x0000,0x0000, 0x2192,0x0000,0x0000, 0x2193,0x0000,0x0000, /* A939 */
0x2194,0x0000,0x0000, 0x2195,0x0000,0x0000, 0x2196,0x0000,0x0000, /* A93C */
0x2197,0x0000,0x0000, 0x2198,0x0000,0x0000, 0x2199,0x0000,0x0000, /* A93F */
0x219A,0x0000,0x0000, 0x219B,0x0000,0x0000, 0x219C,0x0000,0x0000, /* A942 */
0x219D,0x0000,0x0000, 0x219E,0x0000,0x0000, 0x219F,0x0000,0x0000, /* A945 */
0x21A0,0x0000,0x0000, 0x21A1,0x0000,0x0000, 0x21A2,0x0000,0x0000, /* A948 */
0x21A3,0x0000,0x0000, 0x21A4,0x0000,0x0000, 0x21A5,0x0000,0x0000, /* A94B */
0x21A6,0x0000,0x0000, 0x21A7,0x0000,0x0000, 0x21A8,0x0000,0x0000, /* A94E */
0x21A9,0x0000,0x0000, 0x21AA,0x0000,0x0000, 0x21AB,0x0000,0x0000, /* A951 */
0xFBC1,0xA954,0x0000, 0xFBC1,0xA955,0x0000, 0xFBC1,0xA956,0x0000, /* A954 */
0xFBC1,0xA957,0x0000, 0xFBC1,0xA958,0x0000, 0xFBC1,0xA959,0x0000, /* A957 */
0xFBC1,0xA95A,0x0000, 0xFBC1,0xA95B,0x0000, 0xFBC1,0xA95C,0x0000, /* A95A */
0xFBC1,0xA95D,0x0000, 0xFBC1,0xA95E,0x0000, 0x02C9,0x0000,0x0000, /* A95D */
0x2A0F,0x0000,0x0000, 0x2A10,0x0000,0x0000, 0x2A11,0x0000,0x0000, /* A960 */
0x2A12,0x0000,0x0000, 0x2A13,0x0000,0x0000, 0x2A14,0x0000,0x0000, /* A963 */
0x2A15,0x0000,0x0000, 0x2A16,0x0000,0x0000, 0x2A17,0x0000,0x0000, /* A966 */
0x2A18,0x0000,0x0000, 0x2A19,0x0000,0x0000, 0x2A1A,0x0000,0x0000, /* A969 */
0x2A1B,0x0000,0x0000, 0x2A1C,0x0000,0x0000, 0x2A1D,0x0000,0x0000, /* A96C */
0x2A1E,0x0000,0x0000, 0x2A1F,0x0000,0x0000, 0x2A20,0x0000,0x0000, /* A96F */
0x2A21,0x0000,0x0000, 0x2A22,0x0000,0x0000, 0x2A23,0x0000,0x0000, /* A972 */
0x2A24,0x0000,0x0000, 0x2A25,0x0000,0x0000, 0x2A26,0x0000,0x0000, /* A975 */
0x2A27,0x0000,0x0000, 0x2A28,0x0000,0x0000, 0x2A29,0x0000,0x0000, /* A978 */
0x2A2A,0x0000,0x0000, 0x2A2B,0x0000,0x0000, 0xFBC1,0xA97D,0x0000, /* A97B */
0xFBC1,0xA97E,0x0000, 0xFBC1,0xA97F,0x0000, 0x0000,0x0000,0x0000, /* A97E */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* A981 */
0x23EC,0x0000,0x0000, 0x23ED,0x0000,0x0000, 0x23EE,0x0000,0x0000, /* A984 */
0x23EF,0x0000,0x0000, 0x23F0,0x0000,0x0000, 0x23F1,0x0000,0x0000, /* A987 */
0x23F2,0x0000,0x0000, 0x23F3,0x0000,0x0000, 0x23F4,0x0000,0x0000, /* A98A */
0x23F5,0x0000,0x0000, 0x23F6,0x0000,0x0000, 0x23F7,0x0000,0x0000, /* A98D */
0x23F8,0x0000,0x0000, 0x23F9,0x0000,0x0000, 0x23FA,0x0000,0x0000, /* A990 */
0x23FB,0x0000,0x0000, 0x23FC,0x0000,0x0000, 0x23FD,0x0000,0x0000, /* A993 */
0x23FE,0x0000,0x0000, 0x23FF,0x0000,0x0000, 0x2400,0x0000,0x0000, /* A996 */
0x2401,0x0000,0x0000, 0x2402,0x0000,0x0000, 0x2403,0x0000,0x0000, /* A999 */
0x2404,0x0000,0x0000, 0x2405,0x0000,0x0000, 0x2406,0x0000,0x0000, /* A99C */
0x2407,0x0000,0x0000, 0x2408,0x0000,0x0000, 0x2409,0x0000,0x0000, /* A99F */
0x240A,0x0000,0x0000, 0x240B,0x0000,0x0000, 0x240C,0x0000,0x0000, /* A9A2 */
0x240D,0x0000,0x0000, 0x240E,0x0000,0x0000, 0x240F,0x0000,0x0000, /* A9A5 */
0x2410,0x0000,0x0000, 0x2411,0x0000,0x0000, 0x2412,0x0000,0x0000, /* A9A8 */
0x2414,0x0000,0x0000, 0x2414,0x0000,0x0000, 0x2416,0x0000,0x0000, /* A9AB */
0x2417,0x0000,0x0000, 0x2418,0x0000,0x0000, 0x2419,0x0000,0x0000, /* A9AE */
0x241A,0x0000,0x0000, 0x241B,0x0000,0x0000, 0x0000,0x0000,0x0000, /* A9B1 */
0x241C,0x0000,0x0000, 0x2425,0x0000,0x0000, 0x241E,0x0000,0x0000, /* A9B4 */
0x241F,0x0000,0x0000, 0x2420,0x0000,0x0000, 0x2421,0x0000,0x0000, /* A9B7 */
0x2423,0x0000,0x0000, 0x2424,0x0000,0x0000, 0x241D,0x0000,0x0000, /* A9BA */
0x2422,0x0000,0x0000, 0x2413,0x0000,0x0000, 0x2415,0x0000,0x0000, /* A9BD */
0x2426,0x0000,0x0000, 0x02BE,0x0000,0x0000, 0x02BF,0x0000,0x0000, /* A9C0 */
0x02C0,0x0000,0x0000, 0x02C1,0x0000,0x0000, 0x02C2,0x0000,0x0000, /* A9C3 */
0x02C3,0x0000,0x0000, 0x0269,0x0000,0x0000, 0x02A9,0x0000,0x0000, /* A9C6 */
0x02AA,0x0000,0x0000, 0x02C4,0x0000,0x0000, 0x02C5,0x0000,0x0000, /* A9C9 */
0x02C6,0x0000,0x0000, 0x02C7,0x0000,0x0000, 0xFBC1,0xA9CE,0x0000, /* A9CC */
0x11D4,0x0000,0x0000, 0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, /* A9CF */
0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, /* A9D2 */
0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, /* A9D5 */
0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, 0xFBC1,0xA9DA,0x0000, /* A9D8 */
0xFBC1,0xA9DB,0x0000, 0xFBC1,0xA9DC,0x0000, 0xFBC1,0xA9DD,0x0000, /* A9DB */
0x03DC,0x0000,0x0000, 0x03DD,0x0000,0x0000, 0xFBC1,0xA9E0,0x0000, /* A9DE */
0xFBC1,0xA9E1,0x0000, 0xFBC1,0xA9E2,0x0000, 0xFBC1,0xA9E3,0x0000, /* A9E1 */
0xFBC1,0xA9E4,0x0000, 0xFBC1,0xA9E5,0x0000, 0xFBC1,0xA9E6,0x0000, /* A9E4 */
0xFBC1,0xA9E7,0x0000, 0xFBC1,0xA9E8,0x0000, 0xFBC1,0xA9E9,0x0000, /* A9E7 */
0xFBC1,0xA9EA,0x0000, 0xFBC1,0xA9EB,0x0000, 0xFBC1,0xA9EC,0x0000, /* A9EA */
0xFBC1,0xA9ED,0x0000, 0xFBC1,0xA9EE,0x0000, 0xFBC1,0xA9EF,0x0000, /* A9ED */
0xFBC1,0xA9F0,0x0000, 0xFBC1,0xA9F1,0x0000, 0xFBC1,0xA9F2,0x0000, /* A9F0 */
0xFBC1,0xA9F3,0x0000, 0xFBC1,0xA9F4,0x0000, 0xFBC1,0xA9F5,0x0000, /* A9F3 */
0xFBC1,0xA9F6,0x0000, 0xFBC1,0xA9F7,0x0000, 0xFBC1,0xA9F8,0x0000, /* A9F6 */
0xFBC1,0xA9F9,0x0000, 0xFBC1,0xA9FA,0x0000, 0xFBC1,0xA9FB,0x0000, /* A9F9 */
0xFBC1,0xA9FC,0x0000, 0xFBC1,0xA9FD,0x0000, 0xFBC1,0xA9FE,0x0000, /* A9FC */
0xFBC1,0xA9FF,0x0000  };

uint16 uca520_p0AA[]= { /* AA00 (3 weights per char) */
0x2361,0x0000,0x0000, 0x2362,0x0000,0x0000, 0x2363,0x0000,0x0000, /* AA00 */
0x2364,0x0000,0x0000, 0x2365,0x0000,0x0000, 0x2366,0x0000,0x0000, /* AA03 */
0x2367,0x0000,0x0000, 0x2368,0x0000,0x0000, 0x2369,0x0000,0x0000, /* AA06 */
0x236A,0x0000,0x0000, 0x236B,0x0000,0x0000, 0x236C,0x0000,0x0000, /* AA09 */
0x236D,0x0000,0x0000, 0x236E,0x0000,0x0000, 0x236F,0x0000,0x0000, /* AA0C */
0x2370,0x0000,0x0000, 0x2371,0x0000,0x0000, 0x2372,0x0000,0x0000, /* AA0F */
0x2373,0x0000,0x0000, 0x2374,0x0000,0x0000, 0x2375,0x0000,0x0000, /* AA12 */
0x2376,0x0000,0x0000, 0x2377,0x0000,0x0000, 0x2378,0x0000,0x0000, /* AA15 */
0x2379,0x0000,0x0000, 0x237A,0x0000,0x0000, 0x237B,0x0000,0x0000, /* AA18 */
0x237C,0x0000,0x0000, 0x237D,0x0000,0x0000, 0x237E,0x0000,0x0000, /* AA1B */
0x237F,0x0000,0x0000, 0x2380,0x0000,0x0000, 0x2381,0x0000,0x0000, /* AA1E */
0x2382,0x0000,0x0000, 0x2383,0x0000,0x0000, 0x2384,0x0000,0x0000, /* AA21 */
0x2385,0x0000,0x0000, 0x2386,0x0000,0x0000, 0x2387,0x0000,0x0000, /* AA24 */
0x2388,0x0000,0x0000, 0x2389,0x0000,0x0000, 0x238E,0x0000,0x0000, /* AA27 */
0x238F,0x0000,0x0000, 0x2390,0x0000,0x0000, 0x2391,0x0000,0x0000, /* AA2A */
0x2392,0x0000,0x0000, 0x2393,0x0000,0x0000, 0x2394,0x0000,0x0000, /* AA2D */
0x2395,0x0000,0x0000, 0x2396,0x0000,0x0000, 0x2397,0x0000,0x0000, /* AA30 */
0x238A,0x0000,0x0000, 0x238B,0x0000,0x0000, 0x238C,0x0000,0x0000, /* AA33 */
0x238D,0x0000,0x0000, 0xFBC1,0xAA37,0x0000, 0xFBC1,0xAA38,0x0000, /* AA36 */
0xFBC1,0xAA39,0x0000, 0xFBC1,0xAA3A,0x0000, 0xFBC1,0xAA3B,0x0000, /* AA39 */
0xFBC1,0xAA3C,0x0000, 0xFBC1,0xAA3D,0x0000, 0xFBC1,0xAA3E,0x0000, /* AA3C */
0xFBC1,0xAA3F,0x0000, 0x2398,0x0000,0x0000, 0x2399,0x0000,0x0000, /* AA3F */
0x239A,0x0000,0x0000, 0x239B,0x0000,0x0000, 0x239C,0x0000,0x0000, /* AA42 */
0x239D,0x0000,0x0000, 0x239E,0x0000,0x0000, 0x239F,0x0000,0x0000, /* AA45 */
0x23A0,0x0000,0x0000, 0x23A1,0x0000,0x0000, 0x23A2,0x0000,0x0000, /* AA48 */
0x23A3,0x0000,0x0000, 0x23A4,0x0000,0x0000, 0x23A5,0x0000,0x0000, /* AA4B */
0xFBC1,0xAA4E,0x0000, 0xFBC1,0xAA4F,0x0000, 0x1205,0x0000,0x0000, /* AA4E */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* AA51 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* AA54 */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* AA57 */
0xFBC1,0xAA5A,0x0000, 0xFBC1,0xAA5B,0x0000, 0x03DE,0x0000,0x0000, /* AA5A */
0x02AB,0x0000,0x0000, 0x02AC,0x0000,0x0000, 0x02AD,0x0000,0x0000, /* AA5D */
0x21D3,0x0000,0x0000, 0x21D9,0x0000,0x0000, 0x21DB,0x0000,0x0000, /* AA60 */
0x21DD,0x0000,0x0000, 0x21E2,0x0000,0x0000, 0x21E6,0x0000,0x0000, /* AA63 */
0x21E9,0x0000,0x0000, 0x21EB,0x0000,0x0000, 0x21ED,0x0000,0x0000, /* AA66 */
0x21EF,0x0000,0x0000, 0x21F7,0x0000,0x0000, 0x21FA,0x0000,0x0000, /* AA69 */
0x2217,0x0000,0x0000, 0x221A,0x0000,0x0000, 0x221C,0x0000,0x0000, /* AA6C */
0x2200,0x0000,0x0000, 0x11D5,0x0000,0x0000, 0x221D,0x0000,0x0000, /* AA6F */
0x21DF,0x0000,0x0000, 0x220A,0x0000,0x0000, 0x2260,0x0000,0x0000, /* AA72 */
0x2261,0x0000,0x0000, 0x2262,0x0000,0x0000, 0x03C8,0x0000,0x0000, /* AA75 */
0x03C9,0x0000,0x0000, 0x03CA,0x0000,0x0000, 0x220B,0x0000,0x0000, /* AA78 */
0x225F,0x0000,0x0000, 0xFBC1,0xAA7C,0x0000, 0xFBC1,0xAA7D,0x0000, /* AA7B */
0xFBC1,0xAA7E,0x0000, 0xFBC1,0xAA7F,0x0000, 0x1FDE,0x0000,0x0000, /* AA7E */
0x1FDF,0x0000,0x0000, 0x1FE0,0x0000,0x0000, 0x1FE1,0x0000,0x0000, /* AA81 */
0x1FE2,0x0000,0x0000, 0x1FE3,0x0000,0x0000, 0x1FE4,0x0000,0x0000, /* AA84 */
0x1FE5,0x0000,0x0000, 0x1FE6,0x0000,0x0000, 0x1FE7,0x0000,0x0000, /* AA87 */
0x1FE8,0x0000,0x0000, 0x1FE9,0x0000,0x0000, 0x1FEA,0x0000,0x0000, /* AA8A */
0x1FEB,0x0000,0x0000, 0x1FEC,0x0000,0x0000, 0x1FED,0x0000,0x0000, /* AA8D */
0x1FEE,0x0000,0x0000, 0x1FEF,0x0000,0x0000, 0x1FF0,0x0000,0x0000, /* AA90 */
0x1FF1,0x0000,0x0000, 0x1FF2,0x0000,0x0000, 0x1FF3,0x0000,0x0000, /* AA93 */
0x1FF4,0x0000,0x0000, 0x1FF5,0x0000,0x0000, 0x1FF6,0x0000,0x0000, /* AA96 */
0x1FF7,0x0000,0x0000, 0x1FF8,0x0000,0x0000, 0x1FF9,0x0000,0x0000, /* AA99 */
0x1FFA,0x0000,0x0000, 0x1FFB,0x0000,0x0000, 0x1FFC,0x0000,0x0000, /* AA9C */
0x1FFD,0x0000,0x0000, 0x1FFE,0x0000,0x0000, 0x1FFF,0x0000,0x0000, /* AA9F */
0x2000,0x0000,0x0000, 0x2001,0x0000,0x0000, 0x2002,0x0000,0x0000, /* AAA2 */
0x2003,0x0000,0x0000, 0x2004,0x0000,0x0000, 0x2005,0x0000,0x0000, /* AAA5 */
0x2006,0x0000,0x0000, 0x2007,0x0000,0x0000, 0x2008,0x0000,0x0000, /* AAA8 */
0x2009,0x0000,0x0000, 0x200A,0x0000,0x0000, 0x200B,0x0000,0x0000, /* AAAB */
0x200C,0x0000,0x0000, 0x200D,0x0000,0x0000, 0x200E,0x0000,0x0000, /* AAAE */
0x200F,0x0000,0x0000, 0x2010,0x0000,0x0000, 0x2011,0x0000,0x0000, /* AAB1 */
0x2012,0x0000,0x0000, 0x2013,0x0000,0x0000, 0x2014,0x0000,0x0000, /* AAB4 */
0x2015,0x0000,0x0000, 0x2016,0x0000,0x0000, 0x2017,0x0000,0x0000, /* AAB7 */
0x2018,0x0000,0x0000, 0x2019,0x0000,0x0000, 0x201A,0x0000,0x0000, /* AABA */
0x201B,0x0000,0x0000, 0x201C,0x0000,0x0000, 0x0000,0x0000,0x0000, /* AABD */
0x201D,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x201E,0x0000,0x0000, /* AAC0 */
0xFBC1,0xAAC3,0x0000, 0xFBC1,0xAAC4,0x0000, 0xFBC1,0xAAC5,0x0000, /* AAC3 */
0xFBC1,0xAAC6,0x0000, 0xFBC1,0xAAC7,0x0000, 0xFBC1,0xAAC8,0x0000, /* AAC6 */
0xFBC1,0xAAC9,0x0000, 0xFBC1,0xAACA,0x0000, 0xFBC1,0xAACB,0x0000, /* AAC9 */
0xFBC1,0xAACC,0x0000, 0xFBC1,0xAACD,0x0000, 0xFBC1,0xAACE,0x0000, /* AACC */
0xFBC1,0xAACF,0x0000, 0xFBC1,0xAAD0,0x0000, 0xFBC1,0xAAD1,0x0000, /* AACF */
0xFBC1,0xAAD2,0x0000, 0xFBC1,0xAAD3,0x0000, 0xFBC1,0xAAD4,0x0000, /* AAD2 */
0xFBC1,0xAAD5,0x0000, 0xFBC1,0xAAD6,0x0000, 0xFBC1,0xAAD7,0x0000, /* AAD5 */
0xFBC1,0xAAD8,0x0000, 0xFBC1,0xAAD9,0x0000, 0xFBC1,0xAADA,0x0000, /* AAD8 */
0x201F,0x0000,0x0000, 0x2020,0x0000,0x0000, 0x11D6,0x0000,0x0000, /* AADB */
0x03A8,0x0000,0x0000, 0x03A9,0x0000,0x0000, 0xFBC1,0xAAE0,0x0000, /* AADE */
0xFBC1,0xAAE1,0x0000, 0xFBC1,0xAAE2,0x0000, 0xFBC1,0xAAE3,0x0000, /* AAE1 */
0xFBC1,0xAAE4,0x0000, 0xFBC1,0xAAE5,0x0000, 0xFBC1,0xAAE6,0x0000, /* AAE4 */
0xFBC1,0xAAE7,0x0000, 0xFBC1,0xAAE8,0x0000, 0xFBC1,0xAAE9,0x0000, /* AAE7 */
0xFBC1,0xAAEA,0x0000, 0xFBC1,0xAAEB,0x0000, 0xFBC1,0xAAEC,0x0000, /* AAEA */
0xFBC1,0xAAED,0x0000, 0xFBC1,0xAAEE,0x0000, 0xFBC1,0xAAEF,0x0000, /* AAED */
0xFBC1,0xAAF0,0x0000, 0xFBC1,0xAAF1,0x0000, 0xFBC1,0xAAF2,0x0000, /* AAF0 */
0xFBC1,0xAAF3,0x0000, 0xFBC1,0xAAF4,0x0000, 0xFBC1,0xAAF5,0x0000, /* AAF3 */
0xFBC1,0xAAF6,0x0000, 0xFBC1,0xAAF7,0x0000, 0xFBC1,0xAAF8,0x0000, /* AAF6 */
0xFBC1,0xAAF9,0x0000, 0xFBC1,0xAAFA,0x0000, 0xFBC1,0xAAFB,0x0000, /* AAF9 */
0xFBC1,0xAAFC,0x0000, 0xFBC1,0xAAFD,0x0000, 0xFBC1,0xAAFE,0x0000, /* AAFC */
0xFBC1,0xAAFF,0x0000  };

uint16 uca520_p0AB[]= { /* AB00 (3 weights per char) */
0xFBC1,0xAB00,0x0000, 0xFBC1,0xAB01,0x0000, 0xFBC1,0xAB02,0x0000, /* AB00 */
0xFBC1,0xAB03,0x0000, 0xFBC1,0xAB04,0x0000, 0xFBC1,0xAB05,0x0000, /* AB03 */
0xFBC1,0xAB06,0x0000, 0xFBC1,0xAB07,0x0000, 0xFBC1,0xAB08,0x0000, /* AB06 */
0xFBC1,0xAB09,0x0000, 0xFBC1,0xAB0A,0x0000, 0xFBC1,0xAB0B,0x0000, /* AB09 */
0xFBC1,0xAB0C,0x0000, 0xFBC1,0xAB0D,0x0000, 0xFBC1,0xAB0E,0x0000, /* AB0C */
0xFBC1,0xAB0F,0x0000, 0xFBC1,0xAB10,0x0000, 0xFBC1,0xAB11,0x0000, /* AB0F */
0xFBC1,0xAB12,0x0000, 0xFBC1,0xAB13,0x0000, 0xFBC1,0xAB14,0x0000, /* AB12 */
0xFBC1,0xAB15,0x0000, 0xFBC1,0xAB16,0x0000, 0xFBC1,0xAB17,0x0000, /* AB15 */
0xFBC1,0xAB18,0x0000, 0xFBC1,0xAB19,0x0000, 0xFBC1,0xAB1A,0x0000, /* AB18 */
0xFBC1,0xAB1B,0x0000, 0xFBC1,0xAB1C,0x0000, 0xFBC1,0xAB1D,0x0000, /* AB1B */
0xFBC1,0xAB1E,0x0000, 0xFBC1,0xAB1F,0x0000, 0xFBC1,0xAB20,0x0000, /* AB1E */
0xFBC1,0xAB21,0x0000, 0xFBC1,0xAB22,0x0000, 0xFBC1,0xAB23,0x0000, /* AB21 */
0xFBC1,0xAB24,0x0000, 0xFBC1,0xAB25,0x0000, 0xFBC1,0xAB26,0x0000, /* AB24 */
0xFBC1,0xAB27,0x0000, 0xFBC1,0xAB28,0x0000, 0xFBC1,0xAB29,0x0000, /* AB27 */
0xFBC1,0xAB2A,0x0000, 0xFBC1,0xAB2B,0x0000, 0xFBC1,0xAB2C,0x0000, /* AB2A */
0xFBC1,0xAB2D,0x0000, 0xFBC1,0xAB2E,0x0000, 0xFBC1,0xAB2F,0x0000, /* AB2D */
0xFBC1,0xAB30,0x0000, 0xFBC1,0xAB31,0x0000, 0xFBC1,0xAB32,0x0000, /* AB30 */
0xFBC1,0xAB33,0x0000, 0xFBC1,0xAB34,0x0000, 0xFBC1,0xAB35,0x0000, /* AB33 */
0xFBC1,0xAB36,0x0000, 0xFBC1,0xAB37,0x0000, 0xFBC1,0xAB38,0x0000, /* AB36 */
0xFBC1,0xAB39,0x0000, 0xFBC1,0xAB3A,0x0000, 0xFBC1,0xAB3B,0x0000, /* AB39 */
0xFBC1,0xAB3C,0x0000, 0xFBC1,0xAB3D,0x0000, 0xFBC1,0xAB3E,0x0000, /* AB3C */
0xFBC1,0xAB3F,0x0000, 0xFBC1,0xAB40,0x0000, 0xFBC1,0xAB41,0x0000, /* AB3F */
0xFBC1,0xAB42,0x0000, 0xFBC1,0xAB43,0x0000, 0xFBC1,0xAB44,0x0000, /* AB42 */
0xFBC1,0xAB45,0x0000, 0xFBC1,0xAB46,0x0000, 0xFBC1,0xAB47,0x0000, /* AB45 */
0xFBC1,0xAB48,0x0000, 0xFBC1,0xAB49,0x0000, 0xFBC1,0xAB4A,0x0000, /* AB48 */
0xFBC1,0xAB4B,0x0000, 0xFBC1,0xAB4C,0x0000, 0xFBC1,0xAB4D,0x0000, /* AB4B */
0xFBC1,0xAB4E,0x0000, 0xFBC1,0xAB4F,0x0000, 0xFBC1,0xAB50,0x0000, /* AB4E */
0xFBC1,0xAB51,0x0000, 0xFBC1,0xAB52,0x0000, 0xFBC1,0xAB53,0x0000, /* AB51 */
0xFBC1,0xAB54,0x0000, 0xFBC1,0xAB55,0x0000, 0xFBC1,0xAB56,0x0000, /* AB54 */
0xFBC1,0xAB57,0x0000, 0xFBC1,0xAB58,0x0000, 0xFBC1,0xAB59,0x0000, /* AB57 */
0xFBC1,0xAB5A,0x0000, 0xFBC1,0xAB5B,0x0000, 0xFBC1,0xAB5C,0x0000, /* AB5A */
0xFBC1,0xAB5D,0x0000, 0xFBC1,0xAB5E,0x0000, 0xFBC1,0xAB5F,0x0000, /* AB5D */
0xFBC1,0xAB60,0x0000, 0xFBC1,0xAB61,0x0000, 0xFBC1,0xAB62,0x0000, /* AB60 */
0xFBC1,0xAB63,0x0000, 0xFBC1,0xAB64,0x0000, 0xFBC1,0xAB65,0x0000, /* AB63 */
0xFBC1,0xAB66,0x0000, 0xFBC1,0xAB67,0x0000, 0xFBC1,0xAB68,0x0000, /* AB66 */
0xFBC1,0xAB69,0x0000, 0xFBC1,0xAB6A,0x0000, 0xFBC1,0xAB6B,0x0000, /* AB69 */
0xFBC1,0xAB6C,0x0000, 0xFBC1,0xAB6D,0x0000, 0xFBC1,0xAB6E,0x0000, /* AB6C */
0xFBC1,0xAB6F,0x0000, 0xFBC1,0xAB70,0x0000, 0xFBC1,0xAB71,0x0000, /* AB6F */
0xFBC1,0xAB72,0x0000, 0xFBC1,0xAB73,0x0000, 0xFBC1,0xAB74,0x0000, /* AB72 */
0xFBC1,0xAB75,0x0000, 0xFBC1,0xAB76,0x0000, 0xFBC1,0xAB77,0x0000, /* AB75 */
0xFBC1,0xAB78,0x0000, 0xFBC1,0xAB79,0x0000, 0xFBC1,0xAB7A,0x0000, /* AB78 */
0xFBC1,0xAB7B,0x0000, 0xFBC1,0xAB7C,0x0000, 0xFBC1,0xAB7D,0x0000, /* AB7B */
0xFBC1,0xAB7E,0x0000, 0xFBC1,0xAB7F,0x0000, 0xFBC1,0xAB80,0x0000, /* AB7E */
0xFBC1,0xAB81,0x0000, 0xFBC1,0xAB82,0x0000, 0xFBC1,0xAB83,0x0000, /* AB81 */
0xFBC1,0xAB84,0x0000, 0xFBC1,0xAB85,0x0000, 0xFBC1,0xAB86,0x0000, /* AB84 */
0xFBC1,0xAB87,0x0000, 0xFBC1,0xAB88,0x0000, 0xFBC1,0xAB89,0x0000, /* AB87 */
0xFBC1,0xAB8A,0x0000, 0xFBC1,0xAB8B,0x0000, 0xFBC1,0xAB8C,0x0000, /* AB8A */
0xFBC1,0xAB8D,0x0000, 0xFBC1,0xAB8E,0x0000, 0xFBC1,0xAB8F,0x0000, /* AB8D */
0xFBC1,0xAB90,0x0000, 0xFBC1,0xAB91,0x0000, 0xFBC1,0xAB92,0x0000, /* AB90 */
0xFBC1,0xAB93,0x0000, 0xFBC1,0xAB94,0x0000, 0xFBC1,0xAB95,0x0000, /* AB93 */
0xFBC1,0xAB96,0x0000, 0xFBC1,0xAB97,0x0000, 0xFBC1,0xAB98,0x0000, /* AB96 */
0xFBC1,0xAB99,0x0000, 0xFBC1,0xAB9A,0x0000, 0xFBC1,0xAB9B,0x0000, /* AB99 */
0xFBC1,0xAB9C,0x0000, 0xFBC1,0xAB9D,0x0000, 0xFBC1,0xAB9E,0x0000, /* AB9C */
0xFBC1,0xAB9F,0x0000, 0xFBC1,0xABA0,0x0000, 0xFBC1,0xABA1,0x0000, /* AB9F */
0xFBC1,0xABA2,0x0000, 0xFBC1,0xABA3,0x0000, 0xFBC1,0xABA4,0x0000, /* ABA2 */
0xFBC1,0xABA5,0x0000, 0xFBC1,0xABA6,0x0000, 0xFBC1,0xABA7,0x0000, /* ABA5 */
0xFBC1,0xABA8,0x0000, 0xFBC1,0xABA9,0x0000, 0xFBC1,0xABAA,0x0000, /* ABA8 */
0xFBC1,0xABAB,0x0000, 0xFBC1,0xABAC,0x0000, 0xFBC1,0xABAD,0x0000, /* ABAB */
0xFBC1,0xABAE,0x0000, 0xFBC1,0xABAF,0x0000, 0xFBC1,0xABB0,0x0000, /* ABAE */
0xFBC1,0xABB1,0x0000, 0xFBC1,0xABB2,0x0000, 0xFBC1,0xABB3,0x0000, /* ABB1 */
0xFBC1,0xABB4,0x0000, 0xFBC1,0xABB5,0x0000, 0xFBC1,0xABB6,0x0000, /* ABB4 */
0xFBC1,0xABB7,0x0000, 0xFBC1,0xABB8,0x0000, 0xFBC1,0xABB9,0x0000, /* ABB7 */
0xFBC1,0xABBA,0x0000, 0xFBC1,0xABBB,0x0000, 0xFBC1,0xABBC,0x0000, /* ABBA */
0xFBC1,0xABBD,0x0000, 0xFBC1,0xABBE,0x0000, 0xFBC1,0xABBF,0x0000, /* ABBD */
0x1E52,0x0000,0x0000, 0x1E53,0x0000,0x0000, 0x1E54,0x0000,0x0000, /* ABC0 */
0x1E55,0x0000,0x0000, 0x1E56,0x0000,0x0000, 0x1E57,0x0000,0x0000, /* ABC3 */
0x1E58,0x0000,0x0000, 0x1E59,0x0000,0x0000, 0x1E5A,0x0000,0x0000, /* ABC6 */
0x1E5B,0x0000,0x0000, 0x1E5C,0x0000,0x0000, 0x1E5D,0x0000,0x0000, /* ABC9 */
0x1E5E,0x0000,0x0000, 0x1E5F,0x0000,0x0000, 0x1E60,0x0000,0x0000, /* ABCC */
0x1E61,0x0000,0x0000, 0x1E62,0x0000,0x0000, 0x1E63,0x0000,0x0000, /* ABCF */
0x1E64,0x0000,0x0000, 0x1E65,0x0000,0x0000, 0x1E66,0x0000,0x0000, /* ABD2 */
0x1E67,0x0000,0x0000, 0x1E68,0x0000,0x0000, 0x1E69,0x0000,0x0000, /* ABD5 */
0x1E6A,0x0000,0x0000, 0x1E6B,0x0000,0x0000, 0x1E6C,0x0000,0x0000, /* ABD8 */
0x1E75,0x0000,0x0000, 0x1E76,0x0000,0x0000, 0x1E77,0x0000,0x0000, /* ABDB */
0x1E78,0x0000,0x0000, 0x1E79,0x0000,0x0000, 0x1E7A,0x0000,0x0000, /* ABDE */
0x1E7B,0x0000,0x0000, 0x1E7C,0x0000,0x0000, 0x1E6D,0x0000,0x0000, /* ABE1 */
0x1E6E,0x0000,0x0000, 0x1E6F,0x0000,0x0000, 0x1E70,0x0000,0x0000, /* ABE4 */
0x1E71,0x0000,0x0000, 0x1E72,0x0000,0x0000, 0x1E73,0x0000,0x0000, /* ABE7 */
0x1E74,0x0000,0x0000, 0x02AE,0x0000,0x0000, 0x0000,0x0000,0x0000, /* ABEA */
0x1E7D,0x0000,0x0000, 0xFBC1,0xABEE,0x0000, 0xFBC1,0xABEF,0x0000, /* ABED */
0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* ABF0 */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, /* ABF3 */
0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, /* ABF6 */
0x120E,0x0000,0x0000, 0xFBC1,0xABFA,0x0000, 0xFBC1,0xABFB,0x0000, /* ABF9 */
0xFBC1,0xABFC,0x0000, 0xFBC1,0xABFD,0x0000, 0xFBC1,0xABFE,0x0000, /* ABFC */
0xFBC1,0xABFF,0x0000  };

uint16 uca520_p0D7[]= { /* D700 (3 weights per char) */
0xFBC1,0xD700,0x0000, 0xFBC1,0xD701,0x0000, 0xFBC1,0xD702,0x0000, /* D700 */
0xFBC1,0xD703,0x0000, 0xFBC1,0xD704,0x0000, 0xFBC1,0xD705,0x0000, /* D703 */
0xFBC1,0xD706,0x0000, 0xFBC1,0xD707,0x0000, 0xFBC1,0xD708,0x0000, /* D706 */
0xFBC1,0xD709,0x0000, 0xFBC1,0xD70A,0x0000, 0xFBC1,0xD70B,0x0000, /* D709 */
0xFBC1,0xD70C,0x0000, 0xFBC1,0xD70D,0x0000, 0xFBC1,0xD70E,0x0000, /* D70C */
0xFBC1,0xD70F,0x0000, 0xFBC1,0xD710,0x0000, 0xFBC1,0xD711,0x0000, /* D70F */
0xFBC1,0xD712,0x0000, 0xFBC1,0xD713,0x0000, 0xFBC1,0xD714,0x0000, /* D712 */
0xFBC1,0xD715,0x0000, 0xFBC1,0xD716,0x0000, 0xFBC1,0xD717,0x0000, /* D715 */
0xFBC1,0xD718,0x0000, 0xFBC1,0xD719,0x0000, 0xFBC1,0xD71A,0x0000, /* D718 */
0xFBC1,0xD71B,0x0000, 0xFBC1,0xD71C,0x0000, 0xFBC1,0xD71D,0x0000, /* D71B */
0xFBC1,0xD71E,0x0000, 0xFBC1,0xD71F,0x0000, 0xFBC1,0xD720,0x0000, /* D71E */
0xFBC1,0xD721,0x0000, 0xFBC1,0xD722,0x0000, 0xFBC1,0xD723,0x0000, /* D721 */
0xFBC1,0xD724,0x0000, 0xFBC1,0xD725,0x0000, 0xFBC1,0xD726,0x0000, /* D724 */
0xFBC1,0xD727,0x0000, 0xFBC1,0xD728,0x0000, 0xFBC1,0xD729,0x0000, /* D727 */
0xFBC1,0xD72A,0x0000, 0xFBC1,0xD72B,0x0000, 0xFBC1,0xD72C,0x0000, /* D72A */
0xFBC1,0xD72D,0x0000, 0xFBC1,0xD72E,0x0000, 0xFBC1,0xD72F,0x0000, /* D72D */
0xFBC1,0xD730,0x0000, 0xFBC1,0xD731,0x0000, 0xFBC1,0xD732,0x0000, /* D730 */
0xFBC1,0xD733,0x0000, 0xFBC1,0xD734,0x0000, 0xFBC1,0xD735,0x0000, /* D733 */
0xFBC1,0xD736,0x0000, 0xFBC1,0xD737,0x0000, 0xFBC1,0xD738,0x0000, /* D736 */
0xFBC1,0xD739,0x0000, 0xFBC1,0xD73A,0x0000, 0xFBC1,0xD73B,0x0000, /* D739 */
0xFBC1,0xD73C,0x0000, 0xFBC1,0xD73D,0x0000, 0xFBC1,0xD73E,0x0000, /* D73C */
0xFBC1,0xD73F,0x0000, 0xFBC1,0xD740,0x0000, 0xFBC1,0xD741,0x0000, /* D73F */
0xFBC1,0xD742,0x0000, 0xFBC1,0xD743,0x0000, 0xFBC1,0xD744,0x0000, /* D742 */
0xFBC1,0xD745,0x0000, 0xFBC1,0xD746,0x0000, 0xFBC1,0xD747,0x0000, /* D745 */
0xFBC1,0xD748,0x0000, 0xFBC1,0xD749,0x0000, 0xFBC1,0xD74A,0x0000, /* D748 */
0xFBC1,0xD74B,0x0000, 0xFBC1,0xD74C,0x0000, 0xFBC1,0xD74D,0x0000, /* D74B */
0xFBC1,0xD74E,0x0000, 0xFBC1,0xD74F,0x0000, 0xFBC1,0xD750,0x0000, /* D74E */
0xFBC1,0xD751,0x0000, 0xFBC1,0xD752,0x0000, 0xFBC1,0xD753,0x0000, /* D751 */
0xFBC1,0xD754,0x0000, 0xFBC1,0xD755,0x0000, 0xFBC1,0xD756,0x0000, /* D754 */
0xFBC1,0xD757,0x0000, 0xFBC1,0xD758,0x0000, 0xFBC1,0xD759,0x0000, /* D757 */
0xFBC1,0xD75A,0x0000, 0xFBC1,0xD75B,0x0000, 0xFBC1,0xD75C,0x0000, /* D75A */
0xFBC1,0xD75D,0x0000, 0xFBC1,0xD75E,0x0000, 0xFBC1,0xD75F,0x0000, /* D75D */
0xFBC1,0xD760,0x0000, 0xFBC1,0xD761,0x0000, 0xFBC1,0xD762,0x0000, /* D760 */
0xFBC1,0xD763,0x0000, 0xFBC1,0xD764,0x0000, 0xFBC1,0xD765,0x0000, /* D763 */
0xFBC1,0xD766,0x0000, 0xFBC1,0xD767,0x0000, 0xFBC1,0xD768,0x0000, /* D766 */
0xFBC1,0xD769,0x0000, 0xFBC1,0xD76A,0x0000, 0xFBC1,0xD76B,0x0000, /* D769 */
0xFBC1,0xD76C,0x0000, 0xFBC1,0xD76D,0x0000, 0xFBC1,0xD76E,0x0000, /* D76C */
0xFBC1,0xD76F,0x0000, 0xFBC1,0xD770,0x0000, 0xFBC1,0xD771,0x0000, /* D76F */
0xFBC1,0xD772,0x0000, 0xFBC1,0xD773,0x0000, 0xFBC1,0xD774,0x0000, /* D772 */
0xFBC1,0xD775,0x0000, 0xFBC1,0xD776,0x0000, 0xFBC1,0xD777,0x0000, /* D775 */
0xFBC1,0xD778,0x0000, 0xFBC1,0xD779,0x0000, 0xFBC1,0xD77A,0x0000, /* D778 */
0xFBC1,0xD77B,0x0000, 0xFBC1,0xD77C,0x0000, 0xFBC1,0xD77D,0x0000, /* D77B */
0xFBC1,0xD77E,0x0000, 0xFBC1,0xD77F,0x0000, 0xFBC1,0xD780,0x0000, /* D77E */
0xFBC1,0xD781,0x0000, 0xFBC1,0xD782,0x0000, 0xFBC1,0xD783,0x0000, /* D781 */
0xFBC1,0xD784,0x0000, 0xFBC1,0xD785,0x0000, 0xFBC1,0xD786,0x0000, /* D784 */
0xFBC1,0xD787,0x0000, 0xFBC1,0xD788,0x0000, 0xFBC1,0xD789,0x0000, /* D787 */
0xFBC1,0xD78A,0x0000, 0xFBC1,0xD78B,0x0000, 0xFBC1,0xD78C,0x0000, /* D78A */
0xFBC1,0xD78D,0x0000, 0xFBC1,0xD78E,0x0000, 0xFBC1,0xD78F,0x0000, /* D78D */
0xFBC1,0xD790,0x0000, 0xFBC1,0xD791,0x0000, 0xFBC1,0xD792,0x0000, /* D790 */
0xFBC1,0xD793,0x0000, 0xFBC1,0xD794,0x0000, 0xFBC1,0xD795,0x0000, /* D793 */
0xFBC1,0xD796,0x0000, 0xFBC1,0xD797,0x0000, 0xFBC1,0xD798,0x0000, /* D796 */
0xFBC1,0xD799,0x0000, 0xFBC1,0xD79A,0x0000, 0xFBC1,0xD79B,0x0000, /* D799 */
0xFBC1,0xD79C,0x0000, 0xFBC1,0xD79D,0x0000, 0xFBC1,0xD79E,0x0000, /* D79C */
0xFBC1,0xD79F,0x0000, 0xFBC1,0xD7A0,0x0000, 0xFBC1,0xD7A1,0x0000, /* D79F */
0xFBC1,0xD7A2,0x0000, 0xFBC1,0xD7A3,0x0000, 0xFBC1,0xD7A4,0x0000, /* D7A2 */
0xFBC1,0xD7A5,0x0000, 0xFBC1,0xD7A6,0x0000, 0xFBC1,0xD7A7,0x0000, /* D7A5 */
0xFBC1,0xD7A8,0x0000, 0xFBC1,0xD7A9,0x0000, 0xFBC1,0xD7AA,0x0000, /* D7A8 */
0xFBC1,0xD7AB,0x0000, 0xFBC1,0xD7AC,0x0000, 0xFBC1,0xD7AD,0x0000, /* D7AB */
0xFBC1,0xD7AE,0x0000, 0xFBC1,0xD7AF,0x0000, 0x2A75,0x0000,0x0000, /* D7AE */
0x2A76,0x0000,0x0000, 0x2A77,0x0000,0x0000, 0x2A78,0x0000,0x0000, /* D7B1 */
0x2A79,0x0000,0x0000, 0x2A7A,0x0000,0x0000, 0x2A7B,0x0000,0x0000, /* D7B4 */
0x2A7C,0x0000,0x0000, 0x2A7D,0x0000,0x0000, 0x2A7E,0x0000,0x0000, /* D7B7 */
0x2A7F,0x0000,0x0000, 0x2A80,0x0000,0x0000, 0x2A81,0x0000,0x0000, /* D7BA */
0x2A82,0x0000,0x0000, 0x2A83,0x0000,0x0000, 0x2A84,0x0000,0x0000, /* D7BD */
0x2A85,0x0000,0x0000, 0x2A86,0x0000,0x0000, 0x2A87,0x0000,0x0000, /* D7C0 */
0x2A88,0x0000,0x0000, 0x2A89,0x0000,0x0000, 0x2A8A,0x0000,0x0000, /* D7C3 */
0x2A8B,0x0000,0x0000, 0xFBC1,0xD7C7,0x0000, 0xFBC1,0xD7C8,0x0000, /* D7C6 */
0xFBC1,0xD7C9,0x0000, 0xFBC1,0xD7CA,0x0000, 0x2AE4,0x0000,0x0000, /* D7C9 */
0x2AE5,0x0000,0x0000, 0x2AE6,0x0000,0x0000, 0x2AE7,0x0000,0x0000, /* D7CC */
0x2AE8,0x0000,0x0000, 0x2AE9,0x0000,0x0000, 0x2AEA,0x0000,0x0000, /* D7CF */
0x2AEB,0x0000,0x0000, 0x2AEC,0x0000,0x0000, 0x2AED,0x0000,0x0000, /* D7D2 */
0x2AEE,0x0000,0x0000, 0x2AEF,0x0000,0x0000, 0x2AF0,0x0000,0x0000, /* D7D5 */
0x2AF1,0x0000,0x0000, 0x2AF2,0x0000,0x0000, 0x2AF3,0x0000,0x0000, /* D7D8 */
0x2AF4,0x0000,0x0000, 0x2AF5,0x0000,0x0000, 0x2AF6,0x0000,0x0000, /* D7DB */
0x2AF7,0x0000,0x0000, 0x2AF8,0x0000,0x0000, 0x2AF9,0x0000,0x0000, /* D7DE */
0x2AFA,0x0000,0x0000, 0x2AFB,0x0000,0x0000, 0x2AFC,0x0000,0x0000, /* D7E1 */
0x2AFD,0x0000,0x0000, 0x2AFE,0x0000,0x0000, 0x2AFF,0x0000,0x0000, /* D7E4 */
0x2B00,0x0000,0x0000, 0x2B01,0x0000,0x0000, 0x2B02,0x0000,0x0000, /* D7E7 */
0x2B03,0x0000,0x0000, 0x2B04,0x0000,0x0000, 0x2B05,0x0000,0x0000, /* D7EA */
0x2B06,0x0000,0x0000, 0x2B07,0x0000,0x0000, 0x2B08,0x0000,0x0000, /* D7ED */
0x2B09,0x0000,0x0000, 0x2B0A,0x0000,0x0000, 0x2B0B,0x0000,0x0000, /* D7F0 */
0x2B0C,0x0000,0x0000, 0x2B0D,0x0000,0x0000, 0x2B0E,0x0000,0x0000, /* D7F3 */
0x2B0F,0x0000,0x0000, 0x2B10,0x0000,0x0000, 0x2B11,0x0000,0x0000, /* D7F6 */
0x2B12,0x0000,0x0000, 0x2B13,0x0000,0x0000, 0x2B14,0x0000,0x0000, /* D7F9 */
0xFBC1,0xD7FC,0x0000, 0xFBC1,0xD7FD,0x0000, 0xFBC1,0xD7FE,0x0000, /* D7FC */
0xFBC1,0xD7FF,0x0000  };

uint16 uca520_p0F9[]= { /* F900 (3 weights per char) */
0xFB41,0x8C48,0x0000, 0xFB40,0xE6F4,0x0000, 0xFB41,0x8ECA,0x0000, /* F900 */
0xFB41,0x8CC8,0x0000, 0xFB40,0xEED1,0x0000, 0xFB40,0xCE32,0x0000, /* F903 */
0xFB40,0xD3E5,0x0000, 0xFB41,0x9F9C,0x0000, 0xFB41,0x9F9C,0x0000, /* F906 */
0xFB40,0xD951,0x0000, 0xFB41,0x91D1,0x0000, 0xFB40,0xD587,0x0000, /* F909 */
0xFB40,0xD948,0x0000, 0xFB40,0xE1F6,0x0000, 0xFB40,0xF669,0x0000, /* F90C */
0xFB40,0xFF85,0x0000, 0xFB41,0x863F,0x0000, 0xFB41,0x87BA,0x0000, /* F90F */
0xFB41,0x88F8,0x0000, 0xFB41,0x908F,0x0000, 0xFB40,0xEA02,0x0000, /* F912 */
0xFB40,0xED1B,0x0000, 0xFB40,0xF0D9,0x0000, 0xFB40,0xF3DE,0x0000, /* F915 */
0xFB41,0x843D,0x0000, 0xFB41,0x916A,0x0000, 0xFB41,0x99F1,0x0000, /* F918 */
0xFB40,0xCE82,0x0000, 0xFB40,0xD375,0x0000, 0xFB40,0xEB04,0x0000, /* F91B */
0xFB40,0xF21B,0x0000, 0xFB41,0x862D,0x0000, 0xFB41,0x9E1E,0x0000, /* F91E */
0xFB40,0xDD50,0x0000, 0xFB40,0xEFEB,0x0000, 0xFB41,0x85CD,0x0000, /* F921 */
0xFB41,0x8964,0x0000, 0xFB40,0xE2C9,0x0000, 0xFB41,0x81D8,0x0000, /* F924 */
0xFB41,0x881F,0x0000, 0xFB40,0xDECA,0x0000, 0xFB40,0xE717,0x0000, /* F927 */
0xFB40,0xED6A,0x0000, 0xFB40,0xF2FC,0x0000, 0xFB41,0x90CE,0x0000, /* F92A */
0xFB40,0xCF86,0x0000, 0xFB40,0xD1B7,0x0000, 0xFB40,0xD2DE,0x0000, /* F92D */
0xFB40,0xE4C4,0x0000, 0xFB40,0xEAD3,0x0000, 0xFB40,0xF210,0x0000, /* F930 */
0xFB40,0xF6E7,0x0000, 0xFB41,0x8001,0x0000, 0xFB41,0x8606,0x0000, /* F933 */
0xFB41,0x865C,0x0000, 0xFB41,0x8DEF,0x0000, 0xFB41,0x9732,0x0000, /* F936 */
0xFB41,0x9B6F,0x0000, 0xFB41,0x9DFA,0x0000, 0xFB40,0xF88C,0x0000, /* F939 */
0xFB40,0xF97F,0x0000, 0xFB40,0xFDA0,0x0000, 0xFB41,0x83C9,0x0000, /* F93C */
0xFB41,0x9304,0x0000, 0xFB41,0x9E7F,0x0000, 0xFB41,0x8AD6,0x0000, /* F93F */
0xFB40,0xD8DF,0x0000, 0xFB40,0xDF04,0x0000, 0xFB40,0xFC60,0x0000, /* F942 */
0xFB41,0x807E,0x0000, 0xFB40,0xF262,0x0000, 0xFB40,0xF8CA,0x0000, /* F945 */
0xFB41,0x8CC2,0x0000, 0xFB41,0x96F7,0x0000, 0xFB40,0xD8D8,0x0000, /* F948 */
0xFB40,0xDC62,0x0000, 0xFB40,0xEA13,0x0000, 0xFB40,0xEDDA,0x0000, /* F94B */
0xFB40,0xEF0F,0x0000, 0xFB40,0xFD2F,0x0000, 0xFB40,0xFE37,0x0000, /* F94E */
0xFB41,0x964B,0x0000, 0xFB40,0xD2D2,0x0000, 0xFB41,0x808B,0x0000, /* F951 */
0xFB40,0xD1DC,0x0000, 0xFB40,0xD1CC,0x0000, 0xFB40,0xFA1C,0x0000, /* F954 */
0xFB40,0xFDBE,0x0000, 0xFB41,0x83F1,0x0000, 0xFB41,0x9675,0x0000, /* F957 */
0xFB41,0x8B80,0x0000, 0xFB40,0xE2CF,0x0000, 0xFB40,0xEA02,0x0000, /* F95A */
0xFB41,0x8AFE,0x0000, 0xFB40,0xCE39,0x0000, 0xFB40,0xDBE7,0x0000, /* F95D */
0xFB40,0xE012,0x0000, 0xFB40,0xF387,0x0000, 0xFB40,0xF570,0x0000, /* F960 */
0xFB40,0xD317,0x0000, 0xFB40,0xF8FB,0x0000, 0xFB40,0xCFBF,0x0000, /* F963 */
0xFB40,0xDFA9,0x0000, 0xFB40,0xCE0D,0x0000, 0xFB40,0xECCC,0x0000, /* F966 */
0xFB40,0xE578,0x0000, 0xFB40,0xFD22,0x0000, 0xFB40,0xD3C3,0x0000, /* F969 */
0xFB40,0xD85E,0x0000, 0xFB40,0xF701,0x0000, 0xFB41,0x8449,0x0000, /* F96C */
0xFB41,0x8AAA,0x0000, 0xFB40,0xEBBA,0x0000, 0xFB41,0x8FB0,0x0000, /* F96F */
0xFB40,0xEC88,0x0000, 0xFB40,0xE2FE,0x0000, 0xFB41,0x82E5,0x0000, /* F972 */
0xFB40,0xE3A0,0x0000, 0xFB40,0xF565,0x0000, 0xFB40,0xCEAE,0x0000, /* F975 */
0xFB40,0xD169,0x0000, 0xFB40,0xD1C9,0x0000, 0xFB40,0xE881,0x0000, /* F978 */
0xFB40,0xFCE7,0x0000, 0xFB41,0x826F,0x0000, 0xFB41,0x8AD2,0x0000, /* F97B */
0xFB41,0x91CF,0x0000, 0xFB40,0xD2F5,0x0000, 0xFB40,0xD442,0x0000, /* F97E */
0xFB40,0xD973,0x0000, 0xFB40,0xDEEC,0x0000, 0xFB40,0xE5C5,0x0000, /* F981 */
0xFB40,0xEFFE,0x0000, 0xFB40,0xF92A,0x0000, 0xFB41,0x95AD,0x0000, /* F984 */
0xFB41,0x9A6A,0x0000, 0xFB41,0x9E97,0x0000, 0xFB41,0x9ECE,0x0000, /* F987 */
0xFB40,0xD29B,0x0000, 0xFB40,0xE6C6,0x0000, 0xFB40,0xEB77,0x0000, /* F98A */
0xFB41,0x8F62,0x0000, 0xFB40,0xDE74,0x0000, 0xFB40,0xE190,0x0000, /* F98D */
0xFB40,0xE200,0x0000, 0xFB40,0xE49A,0x0000, 0xFB40,0xEF23,0x0000, /* F990 */
0xFB40,0xF149,0x0000, 0xFB40,0xF489,0x0000, 0xFB40,0xF9CA,0x0000, /* F993 */
0xFB40,0xFDF4,0x0000, 0xFB41,0x806F,0x0000, 0xFB41,0x8F26,0x0000, /* F996 */
0xFB41,0x84EE,0x0000, 0xFB41,0x9023,0x0000, 0xFB41,0x934A,0x0000, /* F999 */
0xFB40,0xD217,0x0000, 0xFB40,0xD2A3,0x0000, 0xFB40,0xD4BD,0x0000, /* F99C */
0xFB40,0xF0C8,0x0000, 0xFB41,0x88C2,0x0000, 0xFB41,0x8AAA,0x0000, /* F99F */
0xFB40,0xDEC9,0x0000, 0xFB40,0xDFF5,0x0000, 0xFB40,0xE37B,0x0000, /* F9A2 */
0xFB40,0xEBAE,0x0000, 0xFB40,0xFC3E,0x0000, 0xFB40,0xF375,0x0000, /* F9A5 */
0xFB40,0xCEE4,0x0000, 0xFB40,0xD6F9,0x0000, 0xFB40,0xDBE7,0x0000, /* F9A8 */
0xFB40,0xDDBA,0x0000, 0xFB40,0xE01C,0x0000, 0xFB40,0xF3B2,0x0000, /* F9AB */
0xFB40,0xF469,0x0000, 0xFB40,0xFF9A,0x0000, 0xFB41,0x8046,0x0000, /* F9AE */
0xFB41,0x9234,0x0000, 0xFB41,0x96F6,0x0000, 0xFB41,0x9748,0x0000, /* F9B1 */
0xFB41,0x9818,0x0000, 0xFB40,0xCF8B,0x0000, 0xFB40,0xF9AE,0x0000, /* F9B4 */
0xFB41,0x91B4,0x0000, 0xFB41,0x96B8,0x0000, 0xFB40,0xE0E1,0x0000, /* F9B7 */
0xFB40,0xCE86,0x0000, 0xFB40,0xD0DA,0x0000, 0xFB40,0xDBEE,0x0000, /* F9BA */
0xFB40,0xDC3F,0x0000, 0xFB40,0xE599,0x0000, 0xFB40,0xEA02,0x0000, /* F9BD */
0xFB40,0xF1CE,0x0000, 0xFB40,0xF642,0x0000, 0xFB41,0x84FC,0x0000, /* F9C0 */
0xFB41,0x907C,0x0000, 0xFB41,0x9F8D,0x0000, 0xFB40,0xE688,0x0000, /* F9C3 */
0xFB41,0x962E,0x0000, 0xFB40,0xD289,0x0000, 0xFB40,0xE77B,0x0000, /* F9C6 */
0xFB40,0xE7F3,0x0000, 0xFB40,0xED41,0x0000, 0xFB40,0xEE9C,0x0000, /* F9C9 */
0xFB40,0xF409,0x0000, 0xFB40,0xF559,0x0000, 0xFB40,0xF86B,0x0000, /* F9CC */
0xFB40,0xFD10,0x0000, 0xFB41,0x985E,0x0000, 0xFB40,0xD16D,0x0000, /* F9CF */
0xFB40,0xE22E,0x0000, 0xFB41,0x9678,0x0000, 0xFB40,0xD02B,0x0000, /* F9D2 */
0xFB40,0xDD19,0x0000, 0xFB40,0xEDEA,0x0000, 0xFB41,0x8F2A,0x0000, /* F9D5 */
0xFB40,0xDF8B,0x0000, 0xFB40,0xE144,0x0000, 0xFB40,0xE817,0x0000, /* F9D8 */
0xFB40,0xF387,0x0000, 0xFB41,0x9686,0x0000, 0xFB40,0xD229,0x0000, /* F9DB */
0xFB40,0xD40F,0x0000, 0xFB40,0xDC65,0x0000, 0xFB40,0xE613,0x0000, /* F9DE */
0xFB40,0xE74E,0x0000, 0xFB40,0xE8A8,0x0000, 0xFB40,0xECE5,0x0000, /* F9E1 */
0xFB40,0xF406,0x0000, 0xFB40,0xF5E2,0x0000, 0xFB40,0xFF79,0x0000, /* F9E4 */
0xFB41,0x88CF,0x0000, 0xFB41,0x88E1,0x0000, 0xFB41,0x91CC,0x0000, /* F9E7 */
0xFB41,0x96E2,0x0000, 0xFB40,0xD33F,0x0000, 0xFB40,0xEEBA,0x0000, /* F9EA */
0xFB40,0xD41D,0x0000, 0xFB40,0xF1D0,0x0000, 0xFB40,0xF498,0x0000, /* F9ED */
0xFB41,0x85FA,0x0000, 0xFB41,0x96A3,0x0000, 0xFB41,0x9C57,0x0000, /* F9F0 */
0xFB41,0x9E9F,0x0000, 0xFB40,0xE797,0x0000, 0xFB40,0xEDCB,0x0000, /* F9F3 */
0xFB41,0x81E8,0x0000, 0xFB40,0xFACB,0x0000, 0xFB40,0xFB20,0x0000, /* F9F6 */
0xFB40,0xFC92,0x0000, 0xFB40,0xF2C0,0x0000, 0xFB40,0xF099,0x0000, /* F9F9 */
0xFB41,0x8B58,0x0000, 0xFB40,0xCEC0,0x0000, 0xFB41,0x8336,0x0000, /* F9FC */
0xFB40,0xD23A,0x0000  };

uint16 uca520_p0FA[]= { /* FA00 (3 weights per char) */
0xFB40,0xD207,0x0000, 0xFB40,0xDEA6,0x0000, 0xFB40,0xE2D3,0x0000, /* FA00 */
0xFB40,0xFCD6,0x0000, 0xFB40,0xDB85,0x0000, 0xFB40,0xED1E,0x0000, /* FA03 */
0xFB40,0xE6B4,0x0000, 0xFB41,0x8F3B,0x0000, 0xFB41,0x884C,0x0000, /* FA06 */
0xFB41,0x964D,0x0000, 0xFB41,0x898B,0x0000, 0xFB40,0xDED3,0x0000, /* FA09 */
0xFB40,0xD140,0x0000, 0xFB40,0xD5C0,0x0000, 0xFB41,0xFA0E,0x0000, /* FA0C */
0xFB41,0xFA0F,0x0000, 0xFB40,0xD85A,0x0000, 0xFB41,0xFA11,0x0000, /* FA0F */
0xFB40,0xE674,0x0000, 0xFB41,0xFA13,0x0000, 0xFB41,0xFA14,0x0000, /* FA12 */
0xFB40,0xD1DE,0x0000, 0xFB40,0xF32A,0x0000, 0xFB40,0xF6CA,0x0000, /* FA15 */
0xFB40,0xF93C,0x0000, 0xFB40,0xF95E,0x0000, 0xFB40,0xF965,0x0000, /* FA18 */
0xFB40,0xF98F,0x0000, 0xFB41,0x9756,0x0000, 0xFB40,0xFCBE,0x0000, /* FA1B */
0xFB40,0xFFBD,0x0000, 0xFB41,0xFA1F,0x0000, 0xFB41,0x8612,0x0000, /* FA1E */
0xFB41,0xFA21,0x0000, 0xFB41,0x8AF8,0x0000, 0xFB41,0xFA23,0x0000, /* FA21 */
0xFB41,0xFA24,0x0000, 0xFB41,0x9038,0x0000, 0xFB41,0x90FD,0x0000, /* FA24 */
0xFB41,0xFA27,0x0000, 0xFB41,0xFA28,0x0000, 0xFB41,0xFA29,0x0000, /* FA27 */
0xFB41,0x98EF,0x0000, 0xFB41,0x98FC,0x0000, 0xFB41,0x9928,0x0000, /* FA2A */
0xFB41,0x9DB4,0x0000, 0xFBC1,0xFA2E,0x0000, 0xFBC1,0xFA2F,0x0000, /* FA2D */
0xFB40,0xCFAE,0x0000, 0xFB40,0xD0E7,0x0000, 0xFB40,0xD14D,0x0000, /* FA30 */
0xFB40,0xD2C9,0x0000, 0xFB40,0xD2E4,0x0000, 0xFB40,0xD351,0x0000, /* FA33 */
0xFB40,0xD59D,0x0000, 0xFB40,0xD606,0x0000, 0xFB40,0xD668,0x0000, /* FA36 */
0xFB40,0xD840,0x0000, 0xFB40,0xD8A8,0x0000, 0xFB40,0xDC64,0x0000, /* FA39 */
0xFB40,0xDC6E,0x0000, 0xFB40,0xE094,0x0000, 0xFB40,0xE168,0x0000, /* FA3C */
0xFB40,0xE18E,0x0000, 0xFB40,0xE1F2,0x0000, 0xFB40,0xE54F,0x0000, /* FA3F */
0xFB40,0xE5E2,0x0000, 0xFB40,0xE691,0x0000, 0xFB40,0xE885,0x0000, /* FA42 */
0xFB40,0xED77,0x0000, 0xFB40,0xEE1A,0x0000, 0xFB40,0xEF22,0x0000, /* FA45 */
0xFB40,0xF16E,0x0000, 0xFB40,0xF22B,0x0000, 0xFB40,0xF422,0x0000, /* FA48 */
0xFB40,0xF891,0x0000, 0xFB40,0xF93E,0x0000, 0xFB40,0xF949,0x0000, /* FA4B */
0xFB40,0xF948,0x0000, 0xFB40,0xF950,0x0000, 0xFB40,0xF956,0x0000, /* FA4E */
0xFB40,0xF95D,0x0000, 0xFB40,0xF98D,0x0000, 0xFB40,0xF98E,0x0000, /* FA51 */
0xFB40,0xFA40,0x0000, 0xFB40,0xFA81,0x0000, 0xFB40,0xFBC0,0x0000, /* FA54 */
0xFB40,0xFDF4,0x0000, 0xFB40,0xFE09,0x0000, 0xFB40,0xFE41,0x0000, /* FA57 */
0xFB40,0xFF72,0x0000, 0xFB41,0x8005,0x0000, 0xFB41,0x81ED,0x0000, /* FA5A */
0xFB41,0x8279,0x0000, 0xFB41,0x8279,0x0000, 0xFB41,0x8457,0x0000, /* FA5D */
0xFB41,0x8910,0x0000, 0xFB41,0x8996,0x0000, 0xFB41,0x8B01,0x0000, /* FA60 */
0xFB41,0x8B39,0x0000, 0xFB41,0x8CD3,0x0000, 0xFB41,0x8D08,0x0000, /* FA63 */
0xFB41,0x8FB6,0x0000, 0xFB41,0x9038,0x0000, 0xFB41,0x96E3,0x0000, /* FA66 */
0xFB41,0x97FF,0x0000, 0xFB41,0x983B,0x0000, 0xFB40,0xE075,0x0000, /* FA69 */
0xFB84,0xC2EE,0x0000, 0xFB41,0x8218,0x0000, 0xFBC1,0xFA6E,0x0000, /* FA6C */
0xFBC1,0xFA6F,0x0000, 0xFB40,0xCE26,0x0000, 0xFB40,0xD1B5,0x0000, /* FA6F */
0xFB40,0xD168,0x0000, 0xFB40,0xCF80,0x0000, 0xFB40,0xD145,0x0000, /* FA72 */
0xFB40,0xD180,0x0000, 0xFB40,0xD2C7,0x0000, 0xFB40,0xD2FA,0x0000, /* FA75 */
0xFB40,0xD59D,0x0000, 0xFB40,0xD555,0x0000, 0xFB40,0xD599,0x0000, /* FA78 */
0xFB40,0xD5E2,0x0000, 0xFB40,0xD85A,0x0000, 0xFB40,0xD8B3,0x0000, /* FA7B */
0xFB40,0xD944,0x0000, 0xFB40,0xD954,0x0000, 0xFB40,0xDA62,0x0000, /* FA7E */
0xFB40,0xDB28,0x0000, 0xFB40,0xDED2,0x0000, 0xFB40,0xDED9,0x0000, /* FA81 */
0xFB40,0xDF69,0x0000, 0xFB40,0xDFAD,0x0000, 0xFB40,0xE0D8,0x0000, /* FA84 */
0xFB40,0xE14E,0x0000, 0xFB40,0xE108,0x0000, 0xFB40,0xE18E,0x0000, /* FA87 */
0xFB40,0xE160,0x0000, 0xFB40,0xE1F2,0x0000, 0xFB40,0xE234,0x0000, /* FA8A */
0xFB40,0xE3C4,0x0000, 0xFB40,0xE41C,0x0000, 0xFB40,0xE452,0x0000, /* FA8D */
0xFB40,0xE556,0x0000, 0xFB40,0xE674,0x0000, 0xFB40,0xE717,0x0000, /* FA90 */
0xFB40,0xE71B,0x0000, 0xFB40,0xE756,0x0000, 0xFB40,0xEB79,0x0000, /* FA93 */
0xFB40,0xEBBA,0x0000, 0xFB40,0xED41,0x0000, 0xFB40,0xEEDB,0x0000, /* FA96 */
0xFB40,0xEECB,0x0000, 0xFB40,0xEF22,0x0000, 0xFB40,0xF01E,0x0000, /* FA99 */
0xFB40,0xF16E,0x0000, 0xFB40,0xF7A7,0x0000, 0xFB40,0xF235,0x0000, /* FA9C */
0xFB40,0xF2AF,0x0000, 0xFB40,0xF32A,0x0000, 0xFB40,0xF471,0x0000, /* FA9F */
0xFB40,0xF506,0x0000, 0xFB40,0xF53B,0x0000, 0xFB40,0xF61D,0x0000, /* FAA2 */
0xFB40,0xF61F,0x0000, 0xFB40,0xF6CA,0x0000, 0xFB40,0xF6DB,0x0000, /* FAA5 */
0xFB40,0xF6F4,0x0000, 0xFB40,0xF74A,0x0000, 0xFB40,0xF740,0x0000, /* FAA8 */
0xFB40,0xF8CC,0x0000, 0xFB40,0xFAB1,0x0000, 0xFB40,0xFBC0,0x0000, /* FAAB */
0xFB40,0xFC7B,0x0000, 0xFB40,0xFD5B,0x0000, 0xFB40,0xFDF4,0x0000, /* FAAE */
0xFB40,0xFF3E,0x0000, 0xFB41,0x8005,0x0000, 0xFB41,0x8352,0x0000, /* FAB1 */
0xFB41,0x83EF,0x0000, 0xFB41,0x8779,0x0000, 0xFB41,0x8941,0x0000, /* FAB4 */
0xFB41,0x8986,0x0000, 0xFB41,0x8996,0x0000, 0xFB41,0x8ABF,0x0000, /* FAB7 */
0xFB41,0x8AF8,0x0000, 0xFB41,0x8ACB,0x0000, 0xFB41,0x8B01,0x0000, /* FABA */
0xFB41,0x8AFE,0x0000, 0xFB41,0x8AED,0x0000, 0xFB41,0x8B39,0x0000, /* FABD */
0xFB41,0x8B8A,0x0000, 0xFB41,0x8D08,0x0000, 0xFB41,0x8F38,0x0000, /* FAC0 */
0xFB41,0x9072,0x0000, 0xFB41,0x9199,0x0000, 0xFB41,0x9276,0x0000, /* FAC3 */
0xFB41,0x967C,0x0000, 0xFB41,0x96E3,0x0000, 0xFB41,0x9756,0x0000, /* FAC6 */
0xFB41,0x97DB,0x0000, 0xFB41,0x97FF,0x0000, 0xFB41,0x980B,0x0000, /* FAC9 */
0xFB41,0x983B,0x0000, 0xFB41,0x9B12,0x0000, 0xFB41,0x9F9C,0x0000, /* FACC */
0xFB84,0xA84A,0x0000, 0xFB84,0xA844,0x0000, 0xFB84,0xB3D5,0x0000, /* FACF */
0xFB80,0xBB9D,0x0000, 0xFB80,0xC018,0x0000, 0xFB80,0xC039,0x0000, /* FAD2 */
0xFB84,0xD249,0x0000, 0xFB84,0xDCD0,0x0000, 0xFB84,0xFED3,0x0000, /* FAD5 */
0xFB41,0x9F43,0x0000, 0xFB41,0x9F8E,0x0000, 0xFBC1,0xFADA,0x0000, /* FAD8 */
0xFBC1,0xFADB,0x0000, 0xFBC1,0xFADC,0x0000, 0xFBC1,0xFADD,0x0000, /* FADB */
0xFBC1,0xFADE,0x0000, 0xFBC1,0xFADF,0x0000, 0xFBC1,0xFAE0,0x0000, /* FADE */
0xFBC1,0xFAE1,0x0000, 0xFBC1,0xFAE2,0x0000, 0xFBC1,0xFAE3,0x0000, /* FAE1 */
0xFBC1,0xFAE4,0x0000, 0xFBC1,0xFAE5,0x0000, 0xFBC1,0xFAE6,0x0000, /* FAE4 */
0xFBC1,0xFAE7,0x0000, 0xFBC1,0xFAE8,0x0000, 0xFBC1,0xFAE9,0x0000, /* FAE7 */
0xFBC1,0xFAEA,0x0000, 0xFBC1,0xFAEB,0x0000, 0xFBC1,0xFAEC,0x0000, /* FAEA */
0xFBC1,0xFAED,0x0000, 0xFBC1,0xFAEE,0x0000, 0xFBC1,0xFAEF,0x0000, /* FAED */
0xFBC1,0xFAF0,0x0000, 0xFBC1,0xFAF1,0x0000, 0xFBC1,0xFAF2,0x0000, /* FAF0 */
0xFBC1,0xFAF3,0x0000, 0xFBC1,0xFAF4,0x0000, 0xFBC1,0xFAF5,0x0000, /* FAF3 */
0xFBC1,0xFAF6,0x0000, 0xFBC1,0xFAF7,0x0000, 0xFBC1,0xFAF8,0x0000, /* FAF6 */
0xFBC1,0xFAF9,0x0000, 0xFBC1,0xFAFA,0x0000, 0xFBC1,0xFAFB,0x0000, /* FAF9 */
0xFBC1,0xFAFC,0x0000, 0xFBC1,0xFAFD,0x0000, 0xFBC1,0xFAFE,0x0000, /* FAFC */
0xFBC1,0xFAFF,0x0000  };

uint16 uca520_p0FB[]= { /* FB00 (4 weights per char) */
0x12A3,0x12A3,0x0000,0x0000, 0x12A3,0x12EC,0x0000,0x0000, /* FB00 */
0x12A3,0x1330,0x0000,0x0000, 0x12A3,0x12A3,0x12EC,0x0000, /* FB02 */
0x12A3,0x12A3,0x1330,0x0000, 0x1410,0x1433,0x0000,0x0000, /* FB04 */
0x1410,0x1433,0x0000,0x0000, 0xFBC1,0xFB07,0x0000,0x0000, /* FB06 */
0xFBC1,0xFB08,0x0000,0x0000, 0xFBC1,0xFB09,0x0000,0x0000, /* FB08 */
0xFBC1,0xFB0A,0x0000,0x0000, 0xFBC1,0xFB0B,0x0000,0x0000, /* FB0A */
0xFBC1,0xFB0C,0x0000,0x0000, 0xFBC1,0xFB0D,0x0000,0x0000, /* FB0C */
0xFBC1,0xFB0E,0x0000,0x0000, 0xFBC1,0xFB0F,0x0000,0x0000, /* FB0E */
0xFBC1,0xFB10,0x0000,0x0000, 0xFBC1,0xFB11,0x0000,0x0000, /* FB10 */
0xFBC1,0xFB12,0x0000,0x0000, 0x1848,0x184A,0x0000,0x0000, /* FB12 */
0x1848,0x1839,0x0000,0x0000, 0x1848,0x183F,0x0000,0x0000, /* FB14 */
0x1852,0x184A,0x0000,0x0000, 0x1848,0x1841,0x0000,0x0000, /* FB16 */
0xFBC1,0xFB18,0x0000,0x0000, 0xFBC1,0xFB19,0x0000,0x0000, /* FB18 */
0xFBC1,0xFB1A,0x0000,0x0000, 0xFBC1,0xFB1B,0x0000,0x0000, /* FB1A */
0xFBC1,0xFB1C,0x0000,0x0000, 0x1865,0x0000,0x0000,0x0000, /* FB1C */
0x0000,0x0000,0x0000,0x0000, 0x1865,0x1865,0x0000,0x0000, /* FB1E */
0x186B,0x0000,0x0000,0x0000, 0x185C,0x0000,0x0000,0x0000, /* FB20 */
0x185F,0x0000,0x0000,0x0000, 0x1860,0x0000,0x0000,0x0000, /* FB22 */
0x1866,0x0000,0x0000,0x0000, 0x1867,0x0000,0x0000,0x0000, /* FB24 */
0x1868,0x0000,0x0000,0x0000, 0x186F,0x0000,0x0000,0x0000, /* FB26 */
0x1871,0x0000,0x0000,0x0000, 0x0550,0x0000,0x0000,0x0000, /* FB28 */
0x1870,0x0000,0x0000,0x0000, 0x1870,0x0000,0x0000,0x0000, /* FB2A */
0x1870,0x0000,0x0000,0x0000, 0x1870,0x0000,0x0000,0x0000, /* FB2C */
0x185C,0x0000,0x0000,0x0000, 0x185C,0x0000,0x0000,0x0000, /* FB2E */
0x185C,0x0000,0x0000,0x0000, 0x185D,0x0000,0x0000,0x0000, /* FB30 */
0x185E,0x0000,0x0000,0x0000, 0x185F,0x0000,0x0000,0x0000, /* FB32 */
0x1860,0x0000,0x0000,0x0000, 0x1861,0x0000,0x0000,0x0000, /* FB34 */
0x1862,0x0000,0x0000,0x0000, 0xFBC1,0xFB37,0x0000,0x0000, /* FB36 */
0x1864,0x0000,0x0000,0x0000, 0x1865,0x0000,0x0000,0x0000, /* FB38 */
0x1866,0x0000,0x0000,0x0000, 0x1866,0x0000,0x0000,0x0000, /* FB3A */
0x1867,0x0000,0x0000,0x0000, 0xFBC1,0xFB3D,0x0000,0x0000, /* FB3C */
0x1868,0x0000,0x0000,0x0000, 0xFBC1,0xFB3F,0x0000,0x0000, /* FB3E */
0x1869,0x0000,0x0000,0x0000, 0x186A,0x0000,0x0000,0x0000, /* FB40 */
0xFBC1,0xFB42,0x0000,0x0000, 0x186C,0x0000,0x0000,0x0000, /* FB42 */
0x186C,0x0000,0x0000,0x0000, 0xFBC1,0xFB45,0x0000,0x0000, /* FB44 */
0x186D,0x0000,0x0000,0x0000, 0x186E,0x0000,0x0000,0x0000, /* FB46 */
0x186F,0x0000,0x0000,0x0000, 0x1870,0x0000,0x0000,0x0000, /* FB48 */
0x1871,0x0000,0x0000,0x0000, 0x1861,0x0000,0x0000,0x0000, /* FB4A */
0x185D,0x0000,0x0000,0x0000, 0x1866,0x0000,0x0000,0x0000, /* FB4C */
0x186C,0x0000,0x0000,0x0000, 0x185C,0x1867,0x0000,0x0000, /* FB4E */
0x18A6,0x0000,0x0000,0x0000, 0x18A6,0x0000,0x0000,0x0000, /* FB50 */
0x18B0,0x0000,0x0000,0x0000, 0x18B0,0x0000,0x0000,0x0000, /* FB52 */
0x18B0,0x0000,0x0000,0x0000, 0x18B0,0x0000,0x0000,0x0000, /* FB54 */
0x18B1,0x0000,0x0000,0x0000, 0x18B1,0x0000,0x0000,0x0000, /* FB56 */
0x18B1,0x0000,0x0000,0x0000, 0x18B1,0x0000,0x0000,0x0000, /* FB58 */
0x18B2,0x0000,0x0000,0x0000, 0x18B2,0x0000,0x0000,0x0000, /* FB5A */
0x18B2,0x0000,0x0000,0x0000, 0x18B2,0x0000,0x0000,0x0000, /* FB5C */
0x18BE,0x0000,0x0000,0x0000, 0x18BE,0x0000,0x0000,0x0000, /* FB5E */
0x18BE,0x0000,0x0000,0x0000, 0x18BE,0x0000,0x0000,0x0000, /* FB60 */
0x18C1,0x0000,0x0000,0x0000, 0x18C1,0x0000,0x0000,0x0000, /* FB62 */
0x18C1,0x0000,0x0000,0x0000, 0x18C1,0x0000,0x0000,0x0000, /* FB64 */
0x18BD,0x0000,0x0000,0x0000, 0x18BD,0x0000,0x0000,0x0000, /* FB66 */
0x18BD,0x0000,0x0000,0x0000, 0x18BD,0x0000,0x0000,0x0000, /* FB68 */
0x190F,0x0000,0x0000,0x0000, 0x190F,0x0000,0x0000,0x0000, /* FB6A */
0x190F,0x0000,0x0000,0x0000, 0x190F,0x0000,0x0000,0x0000, /* FB6C */
0x1911,0x0000,0x0000,0x0000, 0x1911,0x0000,0x0000,0x0000, /* FB6E */
0x1911,0x0000,0x0000,0x0000, 0x1911,0x0000,0x0000,0x0000, /* FB70 */
0x18C4,0x0000,0x0000,0x0000, 0x18C4,0x0000,0x0000,0x0000, /* FB72 */
0x18C4,0x0000,0x0000,0x0000, 0x18C4,0x0000,0x0000,0x0000, /* FB74 */
0x18C3,0x0000,0x0000,0x0000, 0x18C3,0x0000,0x0000,0x0000, /* FB76 */
0x18C3,0x0000,0x0000,0x0000, 0x18C3,0x0000,0x0000,0x0000, /* FB78 */
0x18C5,0x0000,0x0000,0x0000, 0x18C5,0x0000,0x0000,0x0000, /* FB7A */
0x18C5,0x0000,0x0000,0x0000, 0x18C5,0x0000,0x0000,0x0000, /* FB7C */
0x18C7,0x0000,0x0000,0x0000, 0x18C7,0x0000,0x0000,0x0000, /* FB7E */
0x18C7,0x0000,0x0000,0x0000, 0x18C7,0x0000,0x0000,0x0000, /* FB80 */
0x18DA,0x0000,0x0000,0x0000, 0x18DA,0x0000,0x0000,0x0000, /* FB82 */
0x18D9,0x0000,0x0000,0x0000, 0x18D9,0x0000,0x0000,0x0000, /* FB84 */
0x18DB,0x0000,0x0000,0x0000, 0x18DB,0x0000,0x0000,0x0000, /* FB86 */
0x18D5,0x0000,0x0000,0x0000, 0x18D5,0x0000,0x0000,0x0000, /* FB88 */
0x18EA,0x0000,0x0000,0x0000, 0x18EA,0x0000,0x0000,0x0000, /* FB8A */
0x18E3,0x0000,0x0000,0x0000, 0x18E3,0x0000,0x0000,0x0000, /* FB8C */
0x1919,0x0000,0x0000,0x0000, 0x1919,0x0000,0x0000,0x0000, /* FB8E */
0x1919,0x0000,0x0000,0x0000, 0x1919,0x0000,0x0000,0x0000, /* FB90 */
0x1920,0x0000,0x0000,0x0000, 0x1920,0x0000,0x0000,0x0000, /* FB92 */
0x1920,0x0000,0x0000,0x0000, 0x1920,0x0000,0x0000,0x0000, /* FB94 */
0x1924,0x0000,0x0000,0x0000, 0x1924,0x0000,0x0000,0x0000, /* FB96 */
0x1924,0x0000,0x0000,0x0000, 0x1924,0x0000,0x0000,0x0000, /* FB98 */
0x1922,0x0000,0x0000,0x0000, 0x1922,0x0000,0x0000,0x0000, /* FB9A */
0x1922,0x0000,0x0000,0x0000, 0x1922,0x0000,0x0000,0x0000, /* FB9C */
0x1935,0x0000,0x0000,0x0000, 0x1935,0x0000,0x0000,0x0000, /* FB9E */
0x1936,0x0000,0x0000,0x0000, 0x1936,0x0000,0x0000,0x0000, /* FBA0 */
0x1936,0x0000,0x0000,0x0000, 0x1936,0x0000,0x0000,0x0000, /* FBA2 */
0x1942,0x0000,0x0000,0x0000, 0x1942,0x0000,0x0000,0x0000, /* FBA4 */
0x193F,0x0000,0x0000,0x0000, 0x193F,0x0000,0x0000,0x0000, /* FBA6 */
0x193F,0x0000,0x0000,0x0000, 0x193F,0x0000,0x0000,0x0000, /* FBA8 */
0x193E,0x0000,0x0000,0x0000, 0x193E,0x0000,0x0000,0x0000, /* FBAA */
0x193E,0x0000,0x0000,0x0000, 0x193E,0x0000,0x0000,0x0000, /* FBAC */
0x195C,0x0000,0x0000,0x0000, 0x195C,0x0000,0x0000,0x0000, /* FBAE */
0x195C,0x0000,0x0000,0x0000, 0x195C,0x0000,0x0000,0x0000, /* FBB0 */
0xFBC1,0xFBB2,0x0000,0x0000, 0xFBC1,0xFBB3,0x0000,0x0000, /* FBB2 */
0xFBC1,0xFBB4,0x0000,0x0000, 0xFBC1,0xFBB5,0x0000,0x0000, /* FBB4 */
0xFBC1,0xFBB6,0x0000,0x0000, 0xFBC1,0xFBB7,0x0000,0x0000, /* FBB6 */
0xFBC1,0xFBB8,0x0000,0x0000, 0xFBC1,0xFBB9,0x0000,0x0000, /* FBB8 */
0xFBC1,0xFBBA,0x0000,0x0000, 0xFBC1,0xFBBB,0x0000,0x0000, /* FBBA */
0xFBC1,0xFBBC,0x0000,0x0000, 0xFBC1,0xFBBD,0x0000,0x0000, /* FBBC */
0xFBC1,0xFBBE,0x0000,0x0000, 0xFBC1,0xFBBF,0x0000,0x0000, /* FBBE */
0xFBC1,0xFBC0,0x0000,0x0000, 0xFBC1,0xFBC1,0x0000,0x0000, /* FBC0 */
0xFBC1,0xFBC2,0x0000,0x0000, 0xFBC1,0xFBC3,0x0000,0x0000, /* FBC2 */
0xFBC1,0xFBC4,0x0000,0x0000, 0xFBC1,0xFBC5,0x0000,0x0000, /* FBC4 */
0xFBC1,0xFBC6,0x0000,0x0000, 0xFBC1,0xFBC7,0x0000,0x0000, /* FBC6 */
0xFBC1,0xFBC8,0x0000,0x0000, 0xFBC1,0xFBC9,0x0000,0x0000, /* FBC8 */
0xFBC1,0xFBCA,0x0000,0x0000, 0xFBC1,0xFBCB,0x0000,0x0000, /* FBCA */
0xFBC1,0xFBCC,0x0000,0x0000, 0xFBC1,0xFBCD,0x0000,0x0000, /* FBCC */
0xFBC1,0xFBCE,0x0000,0x0000, 0xFBC1,0xFBCF,0x0000,0x0000, /* FBCE */
0xFBC1,0xFBD0,0x0000,0x0000, 0xFBC1,0xFBD1,0x0000,0x0000, /* FBD0 */
0xFBC1,0xFBD2,0x0000,0x0000, 0x191E,0x0000,0x0000,0x0000, /* FBD2 */
0x191E,0x0000,0x0000,0x0000, 0x191E,0x0000,0x0000,0x0000, /* FBD4 */
0x191E,0x0000,0x0000,0x0000, 0x1947,0x0000,0x0000,0x0000, /* FBD6 */
0x1947,0x0000,0x0000,0x0000, 0x1946,0x0000,0x0000,0x0000, /* FBD8 */
0x1946,0x0000,0x0000,0x0000, 0x1948,0x0000,0x0000,0x0000, /* FBDA */
0x1948,0x0000,0x0000,0x0000, 0x1947,0x18A2,0x0000,0x0000, /* FBDC */
0x194B,0x0000,0x0000,0x0000, 0x194B,0x0000,0x0000,0x0000, /* FBDE */
0x1945,0x0000,0x0000,0x0000, 0x1945,0x0000,0x0000,0x0000, /* FBE0 */
0x1949,0x0000,0x0000,0x0000, 0x1949,0x0000,0x0000,0x0000, /* FBE2 */
0x1954,0x0000,0x0000,0x0000, 0x1954,0x0000,0x0000,0x0000, /* FBE4 */
0x1954,0x0000,0x0000,0x0000, 0x1954,0x0000,0x0000,0x0000, /* FBE6 */
0x194F,0x0000,0x0000,0x0000, 0x194F,0x0000,0x0000,0x0000, /* FBE8 */
0x18AC,0x18AD,0x0000,0x0000, 0x18AC,0x18AD,0x0000,0x0000, /* FBEA */
0x18AC,0x1942,0x0000,0x0000, 0x18AC,0x1942,0x0000,0x0000, /* FBEC */
0x18AC,0x1943,0x0000,0x0000, 0x18AC,0x1943,0x0000,0x0000, /* FBEE */
0x18AC,0x1947,0x0000,0x0000, 0x18AC,0x1947,0x0000,0x0000, /* FBF0 */
0x18AC,0x1946,0x0000,0x0000, 0x18AC,0x1946,0x0000,0x0000, /* FBF2 */
0x18AC,0x1948,0x0000,0x0000, 0x18AC,0x1948,0x0000,0x0000, /* FBF4 */
0x18AC,0x1954,0x0000,0x0000, 0x18AC,0x1954,0x0000,0x0000, /* FBF6 */
0x18AC,0x1954,0x0000,0x0000, 0x18AC,0x194F,0x0000,0x0000, /* FBF8 */
0x18AC,0x194F,0x0000,0x0000, 0x18AC,0x194F,0x0000,0x0000, /* FBFA */
0x1951,0x0000,0x0000,0x0000, 0x1951,0x0000,0x0000,0x0000, /* FBFC */
0x1951,0x0000,0x0000,0x0000, 0x1951,0x0000,0x0000,0x0000  /* FBFE */
};

uint16 uca520_p0FC[]= { /* FC00 (3 weights per char) */
0x18AC,0x18C2,0x0000, 0x18AC,0x18C8,0x0000, 0x18AC,0x1931,0x0000, /* FC00 */
0x18AC,0x194F,0x0000, 0x18AC,0x1950,0x0000, 0x18AF,0x18C2,0x0000, /* FC03 */
0x18AF,0x18C8,0x0000, 0x18AF,0x18C9,0x0000, 0x18AF,0x1931,0x0000, /* FC06 */
0x18AF,0x194F,0x0000, 0x18AF,0x1950,0x0000, 0x18BB,0x18C2,0x0000, /* FC09 */
0x18BB,0x18C8,0x0000, 0x18BB,0x18C9,0x0000, 0x18BB,0x1931,0x0000, /* FC0C */
0x18BB,0x194F,0x0000, 0x18BB,0x1950,0x0000, 0x18BC,0x18C2,0x0000, /* FC0F */
0x18BC,0x1931,0x0000, 0x18BC,0x194F,0x0000, 0x18BC,0x1950,0x0000, /* FC12 */
0x18C2,0x18C8,0x0000, 0x18C2,0x1931,0x0000, 0x18C8,0x18C2,0x0000, /* FC15 */
0x18C8,0x1931,0x0000, 0x18C9,0x18C2,0x0000, 0x18C9,0x18C8,0x0000, /* FC18 */
0x18C9,0x1931,0x0000, 0x18F1,0x18C2,0x0000, 0x18F1,0x18C8,0x0000, /* FC1B */
0x18F1,0x18C9,0x0000, 0x18F1,0x1931,0x0000, 0x18FC,0x18C8,0x0000, /* FC1E */
0x18FC,0x1931,0x0000, 0x18FD,0x18C2,0x0000, 0x18FD,0x18C8,0x0000, /* FC21 */
0x18FD,0x18C9,0x0000, 0x18FD,0x1931,0x0000, 0x1901,0x18C8,0x0000, /* FC24 */
0x1901,0x1931,0x0000, 0x1902,0x1931,0x0000, 0x1904,0x18C2,0x0000, /* FC27 */
0x1904,0x1931,0x0000, 0x1905,0x18C2,0x0000, 0x1905,0x1931,0x0000, /* FC2A */
0x190B,0x18C2,0x0000, 0x190B,0x18C8,0x0000, 0x190B,0x18C9,0x0000, /* FC2D */
0x190B,0x1931,0x0000, 0x190B,0x194F,0x0000, 0x190B,0x1950,0x0000, /* FC30 */
0x1915,0x18C8,0x0000, 0x1915,0x1931,0x0000, 0x1915,0x194F,0x0000, /* FC33 */
0x1915,0x1950,0x0000, 0x1918,0x18AD,0x0000, 0x1918,0x18C2,0x0000, /* FC36 */
0x1918,0x18C8,0x0000, 0x1918,0x18C9,0x0000, 0x1918,0x192B,0x0000, /* FC39 */
0x1918,0x1931,0x0000, 0x1918,0x194F,0x0000, 0x1918,0x1950,0x0000, /* FC3C */
0x192B,0x18C2,0x0000, 0x192B,0x18C8,0x0000, 0x192B,0x18C9,0x0000, /* FC3F */
0x192B,0x1931,0x0000, 0x192B,0x194F,0x0000, 0x192B,0x1950,0x0000, /* FC42 */
0x1931,0x18C2,0x0000, 0x1931,0x18C8,0x0000, 0x1931,0x18C9,0x0000, /* FC45 */
0x1931,0x1931,0x0000, 0x1931,0x194F,0x0000, 0x1931,0x1950,0x0000, /* FC48 */
0x1934,0x18C2,0x0000, 0x1934,0x18C8,0x0000, 0x1934,0x18C9,0x0000, /* FC4B */
0x1934,0x1931,0x0000, 0x1934,0x194F,0x0000, 0x1934,0x1950,0x0000, /* FC4E */
0x193D,0x18C2,0x0000, 0x193D,0x1931,0x0000, 0x193D,0x194F,0x0000, /* FC51 */
0x193D,0x1950,0x0000, 0x1950,0x18C2,0x0000, 0x1950,0x18C8,0x0000, /* FC54 */
0x1950,0x18C9,0x0000, 0x1950,0x1931,0x0000, 0x1950,0x194F,0x0000, /* FC57 */
0x1950,0x1950,0x0000, 0x18D4,0x0000,0x0000, 0x18E1,0x0000,0x0000, /* FC5A */
0x194F,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* FC5D */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* FC60 */
0x0000,0x0000,0x0000, 0x18AC,0x18E1,0x0000, 0x18AC,0x18E2,0x0000, /* FC63 */
0x18AC,0x1931,0x0000, 0x18AC,0x1934,0x0000, 0x18AC,0x194F,0x0000, /* FC66 */
0x18AC,0x1950,0x0000, 0x18AF,0x18E1,0x0000, 0x18AF,0x18E2,0x0000, /* FC69 */
0x18AF,0x1931,0x0000, 0x18AF,0x1934,0x0000, 0x18AF,0x194F,0x0000, /* FC6C */
0x18AF,0x1950,0x0000, 0x18BB,0x18E1,0x0000, 0x18BB,0x18E2,0x0000, /* FC6F */
0x18BB,0x1931,0x0000, 0x18BB,0x1934,0x0000, 0x18BB,0x194F,0x0000, /* FC72 */
0x18BB,0x1950,0x0000, 0x18BC,0x18E1,0x0000, 0x18BC,0x18E2,0x0000, /* FC75 */
0x18BC,0x1931,0x0000, 0x18BC,0x1934,0x0000, 0x18BC,0x194F,0x0000, /* FC78 */
0x18BC,0x1950,0x0000, 0x190B,0x194F,0x0000, 0x190B,0x1950,0x0000, /* FC7B */
0x1915,0x194F,0x0000, 0x1915,0x1950,0x0000, 0x1918,0x18AD,0x0000, /* FC7E */
0x1918,0x192B,0x0000, 0x1918,0x1931,0x0000, 0x1918,0x194F,0x0000, /* FC81 */
0x1918,0x1950,0x0000, 0x192B,0x1931,0x0000, 0x192B,0x194F,0x0000, /* FC84 */
0x192B,0x1950,0x0000, 0x1931,0x18AD,0x0000, 0x1931,0x1931,0x0000, /* FC87 */
0x1934,0x18E1,0x0000, 0x1934,0x18E2,0x0000, 0x1934,0x1931,0x0000, /* FC8A */
0x1934,0x1934,0x0000, 0x1934,0x194F,0x0000, 0x1934,0x1950,0x0000, /* FC8D */
0x194F,0x0000,0x0000, 0x1950,0x18E1,0x0000, 0x1950,0x18E2,0x0000, /* FC90 */
0x1950,0x1931,0x0000, 0x1950,0x1934,0x0000, 0x1950,0x194F,0x0000, /* FC93 */
0x1950,0x1950,0x0000, 0x18AC,0x18C2,0x0000, 0x18AC,0x18C8,0x0000, /* FC96 */
0x18AC,0x18C9,0x0000, 0x18AC,0x1931,0x0000, 0x18AC,0x193D,0x0000, /* FC99 */
0x18AF,0x18C2,0x0000, 0x18AF,0x18C8,0x0000, 0x18AF,0x18C9,0x0000, /* FC9C */
0x18AF,0x1931,0x0000, 0x18AF,0x193D,0x0000, 0x18BB,0x18C2,0x0000, /* FC9F */
0x18BB,0x18C8,0x0000, 0x18BB,0x18C9,0x0000, 0x18BB,0x1931,0x0000, /* FCA2 */
0x18BB,0x193D,0x0000, 0x18BC,0x1931,0x0000, 0x18C2,0x18C8,0x0000, /* FCA5 */
0x18C2,0x1931,0x0000, 0x18C8,0x18C2,0x0000, 0x18C8,0x1931,0x0000, /* FCA8 */
0x18C9,0x18C2,0x0000, 0x18C9,0x1931,0x0000, 0x18F1,0x18C2,0x0000, /* FCAB */
0x18F1,0x18C8,0x0000, 0x18F1,0x18C9,0x0000, 0x18F1,0x1931,0x0000, /* FCAE */
0x18FC,0x18C8,0x0000, 0x18FC,0x18C9,0x0000, 0x18FC,0x1931,0x0000, /* FCB1 */
0x18FD,0x18C2,0x0000, 0x18FD,0x18C8,0x0000, 0x18FD,0x18C9,0x0000, /* FCB4 */
0x18FD,0x1931,0x0000, 0x1901,0x18C8,0x0000, 0x1902,0x1931,0x0000, /* FCB7 */
0x1904,0x18C2,0x0000, 0x1904,0x1931,0x0000, 0x1905,0x18C2,0x0000, /* FCBA */
0x1905,0x1931,0x0000, 0x190B,0x18C2,0x0000, 0x190B,0x18C8,0x0000, /* FCBD */
0x190B,0x18C9,0x0000, 0x190B,0x1931,0x0000, 0x1915,0x18C8,0x0000, /* FCC0 */
0x1915,0x1931,0x0000, 0x1918,0x18C2,0x0000, 0x1918,0x18C8,0x0000, /* FCC3 */
0x1918,0x18C9,0x0000, 0x1918,0x192B,0x0000, 0x1918,0x1931,0x0000, /* FCC6 */
0x192B,0x18C2,0x0000, 0x192B,0x18C8,0x0000, 0x192B,0x18C9,0x0000, /* FCC9 */
0x192B,0x1931,0x0000, 0x192B,0x193D,0x0000, 0x1931,0x18C2,0x0000, /* FCCC */
0x1931,0x18C8,0x0000, 0x1931,0x18C9,0x0000, 0x1931,0x1931,0x0000, /* FCCF */
0x1934,0x18C2,0x0000, 0x1934,0x18C8,0x0000, 0x1934,0x18C9,0x0000, /* FCD2 */
0x1934,0x1931,0x0000, 0x1934,0x193D,0x0000, 0x193D,0x18C2,0x0000, /* FCD5 */
0x193D,0x1931,0x0000, 0x193D,0x0000,0x0000, 0x1950,0x18C2,0x0000, /* FCD8 */
0x1950,0x18C8,0x0000, 0x1950,0x18C9,0x0000, 0x1950,0x1931,0x0000, /* FCDB */
0x1950,0x193D,0x0000, 0x18AC,0x1931,0x0000, 0x18AC,0x193D,0x0000, /* FCDE */
0x18AF,0x1931,0x0000, 0x18AF,0x193D,0x0000, 0x18BB,0x1931,0x0000, /* FCE1 */
0x18BB,0x193D,0x0000, 0x18BC,0x1931,0x0000, 0x18BC,0x193D,0x0000, /* FCE4 */
0x18F1,0x1931,0x0000, 0x18F1,0x193D,0x0000, 0x18F2,0x1931,0x0000, /* FCE7 */
0x18F2,0x193D,0x0000, 0x1918,0x192B,0x0000, 0x1918,0x1931,0x0000, /* FCEA */
0x192B,0x1931,0x0000, 0x1934,0x1931,0x0000, 0x1934,0x193D,0x0000, /* FCED */
0x1950,0x1931,0x0000, 0x1950,0x193D,0x0000, 0x0000,0x0000,0x0000, /* FCF0 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x1901,0x194F,0x0000, /* FCF3 */
0x1901,0x1950,0x0000, 0x1904,0x194F,0x0000, 0x1904,0x1950,0x0000, /* FCF6 */
0x1905,0x194F,0x0000, 0x1905,0x1950,0x0000, 0x18F1,0x194F,0x0000, /* FCF9 */
0x18F1,0x1950,0x0000, 0x18F2,0x194F,0x0000, 0x18F2,0x1950,0x0000, /* FCFC */
0x18C8,0x194F,0x0000  };

uint16 uca520_p0FD[]= { /* FD00 (9 weights per char) */
0x18C8,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD00 */
0x18C2,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD01 */
0x18C2,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD02 */
0x18C9,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD03 */
0x18C9,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD04 */
0x18FC,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD05 */
0x18FC,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD06 */
0x18FD,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD07 */
0x18FD,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD08 */
0x18F2,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD09 */
0x18F2,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD0A */
0x18F2,0x18C9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD0B */
0x18F2,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD0C */
0x18F2,0x18E1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD0D */
0x18F1,0x18E1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD0E */
0x18FC,0x18E1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD0F */
0x18FD,0x18E1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD10 */
0x1901,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD11 */
0x1901,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD12 */
0x1904,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD13 */
0x1904,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD14 */
0x1905,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD15 */
0x1905,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD16 */
0x18F1,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD17 */
0x18F1,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD18 */
0x18F2,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD19 */
0x18F2,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD1A */
0x18C8,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD1B */
0x18C8,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD1C */
0x18C2,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD1D */
0x18C2,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD1E */
0x18C9,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD1F */
0x18C9,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD20 */
0x18FC,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD21 */
0x18FC,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD22 */
0x18FD,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD23 */
0x18FD,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD24 */
0x18F2,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD25 */
0x18F2,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD26 */
0x18F2,0x18C9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD27 */
0x18F2,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD28 */
0x18F2,0x18E1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD29 */
0x18F1,0x18E1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD2A */
0x18FC,0x18E1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD2B */
0x18FD,0x18E1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD2C */
0x18F2,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD2D */
0x18F2,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD2E */
0x18F2,0x18C9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD2F */
0x18F2,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD30 */
0x18F1,0x193D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD31 */
0x18F2,0x193D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD32 */
0x1901,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD33 */
0x18F1,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD34 */
0x18F1,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD35 */
0x18F1,0x18C9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD36 */
0x18F2,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD37 */
0x18F2,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD38 */
0x18F2,0x18C9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD39 */
0x1901,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD3A */
0x1902,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD3B */
0x18AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD3C */
0x18AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD3D */
0x034F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD3E */
0x0350,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD3F */
0xFBC1,0xFD40,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD40 */
0xFBC1,0xFD41,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD41 */
0xFBC1,0xFD42,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD42 */
0xFBC1,0xFD43,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD43 */
0xFBC1,0xFD44,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD44 */
0xFBC1,0xFD45,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD45 */
0xFBC1,0xFD46,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD46 */
0xFBC1,0xFD47,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD47 */
0xFBC1,0xFD48,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD48 */
0xFBC1,0xFD49,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD49 */
0xFBC1,0xFD4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD4A */
0xFBC1,0xFD4B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD4B */
0xFBC1,0xFD4C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD4C */
0xFBC1,0xFD4D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD4D */
0xFBC1,0xFD4E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD4E */
0xFBC1,0xFD4F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD4F */
0x18BB,0x18C2,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD50 */
0x18BB,0x18C8,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD51 */
0x18BB,0x18C8,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD52 */
0x18BB,0x18C8,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD53 */
0x18BB,0x18C9,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD54 */
0x18BB,0x1931,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD55 */
0x18BB,0x1931,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD56 */
0x18BB,0x1931,0x18C9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD57 */
0x18C2,0x1931,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD58 */
0x18C2,0x1931,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD59 */
0x18C8,0x1931,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD5A */
0x18C8,0x1931,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD5B */
0x18F1,0x18C8,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD5C */
0x18F1,0x18C2,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD5D */
0x18F1,0x18C2,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD5E */
0x18F1,0x1931,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD5F */
0x18F1,0x1931,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD60 */
0x18F1,0x1931,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD61 */
0x18F1,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD62 */
0x18F1,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD63 */
0x18FC,0x18C8,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD64 */
0x18FC,0x18C8,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD65 */
0x18FC,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD66 */
0x18F2,0x18C8,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD67 */
0x18F2,0x18C8,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD68 */
0x18F2,0x18C2,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD69 */
0x18F2,0x1931,0x18C9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD6A */
0x18F2,0x1931,0x18C9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD6B */
0x18F2,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD6C */
0x18F2,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD6D */
0x18FD,0x18C8,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD6E */
0x18FD,0x18C9,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD6F */
0x18FD,0x18C9,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD70 */
0x1901,0x1931,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD71 */
0x1901,0x1931,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD72 */
0x1901,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD73 */
0x1901,0x1931,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD74 */
0x1904,0x18C2,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD75 */
0x1904,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD76 */
0x1904,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD77 */
0x1904,0x1931,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD78 */
0x1905,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD79 */
0x1905,0x1931,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD7A */
0x1905,0x1931,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD7B */
0x190B,0x18C9,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD7C */
0x190B,0x18C9,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD7D */
0x1915,0x1931,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD7E */
0x1915,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD7F */
0x192B,0x18C8,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD80 */
0x192B,0x18C8,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD81 */
0x192B,0x18C8,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD82 */
0x192B,0x18C2,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD83 */
0x192B,0x18C2,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD84 */
0x192B,0x18C9,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD85 */
0x192B,0x18C9,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD86 */
0x192B,0x1931,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD87 */
0x192B,0x1931,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD88 */
0x1931,0x18C8,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD89 */
0x1931,0x18C8,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD8A */
0x1931,0x18C8,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD8B */
0x1931,0x18C2,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD8C */
0x1931,0x18C2,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD8D */
0x1931,0x18C9,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD8E */
0x1931,0x18C9,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD8F */
0xFBC1,0xFD90,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD90 */
0xFBC1,0xFD91,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD91 */
0x1931,0x18C2,0x18C9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD92 */
0x193D,0x1931,0x18C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD93 */
0x193D,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD94 */
0x1934,0x18C8,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD95 */
0x1934,0x18C8,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD96 */
0x1934,0x18C2,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD97 */
0x1934,0x18C2,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD98 */
0x1934,0x18C2,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD99 */
0x1934,0x1931,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD9A */
0x1934,0x1931,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD9B */
0x1950,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD9C */
0x1950,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD9D */
0x18AF,0x18C9,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD9E */
0x18BB,0x18C2,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FD9F */
0x18BB,0x18C2,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDA0 */
0x18BB,0x18C9,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDA1 */
0x18BB,0x18C9,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDA2 */
0x18BB,0x1931,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDA3 */
0x18BB,0x1931,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDA4 */
0x18C2,0x1931,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDA5 */
0x18C2,0x18C8,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDA6 */
0x18C2,0x1931,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDA7 */
0x18F1,0x18C9,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDA8 */
0x18FC,0x18C8,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDA9 */
0x18F2,0x18C8,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDAA */
0x18FD,0x18C8,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDAB */
0x192B,0x18C2,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDAC */
0x192B,0x1931,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDAD */
0x1950,0x18C8,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDAE */
0x1950,0x18C2,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDAF */
0x1950,0x1931,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDB0 */
0x1931,0x1931,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDB1 */
0x1915,0x1931,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDB2 */
0x1934,0x18C8,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDB3 */
0x1915,0x1931,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDB4 */
0x192B,0x18C8,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDB5 */
0x1904,0x1931,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDB6 */
0x1918,0x1931,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDB7 */
0x1934,0x18C2,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDB8 */
0x1931,0x18C9,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDB9 */
0x192B,0x18C2,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDBA */
0x1918,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDBB */
0x192B,0x18C2,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDBC */
0x1934,0x18C2,0x18C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDBD */
0x18C2,0x18C8,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDBE */
0x18C8,0x18C2,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDBF */
0x1931,0x18C2,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDC0 */
0x190B,0x1931,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDC1 */
0x18AF,0x18C8,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDC2 */
0x1918,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDC3 */
0x1904,0x18C2,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDC4 */
0x18FC,0x1931,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDC5 */
0x18F1,0x18C9,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDC6 */
0x1934,0x18C2,0x1950,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDC7 */
0xFBC1,0xFDC8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDC8 */
0xFBC1,0xFDC9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDC9 */
0xFBC1,0xFDCA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDCA */
0xFBC1,0xFDCB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDCB */
0xFBC1,0xFDCC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDCC */
0xFBC1,0xFDCD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDCD */
0xFBC1,0xFDCE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDCE */
0xFBC1,0xFDCF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDCF */
0xFBC1,0xFDD0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDD0 */
0xFBC1,0xFDD1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDD1 */
0xFBC1,0xFDD2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDD2 */
0xFBC1,0xFDD3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDD3 */
0xFBC1,0xFDD4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDD4 */
0xFBC1,0xFDD5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDD5 */
0xFBC1,0xFDD6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDD6 */
0xFBC1,0xFDD7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDD7 */
0xFBC1,0xFDD8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDD8 */
0xFBC1,0xFDD9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDD9 */
0xFBC1,0xFDDA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDDA */
0xFBC1,0xFDDB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDDB */
0xFBC1,0xFDDC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDDC */
0xFBC1,0xFDDD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDDD */
0xFBC1,0xFDDE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDDE */
0xFBC1,0xFDDF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDDF */
0xFBC1,0xFDE0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDE0 */
0xFBC1,0xFDE1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDE1 */
0xFBC1,0xFDE2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDE2 */
0xFBC1,0xFDE3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDE3 */
0xFBC1,0xFDE4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDE4 */
0xFBC1,0xFDE5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDE5 */
0xFBC1,0xFDE6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDE6 */
0xFBC1,0xFDE7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDE7 */
0xFBC1,0xFDE8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDE8 */
0xFBC1,0xFDE9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDE9 */
0xFBC1,0xFDEA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDEA */
0xFBC1,0xFDEB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDEB */
0xFBC1,0xFDEC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDEC */
0xFBC1,0xFDED,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDED */
0xFBC1,0xFDEE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDEE */
0xFBC1,0xFDEF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDEF */
0x18FC,0x192B,0x195C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDF0 */
0x1915,0x192B,0x195C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDF1 */
0x18AD,0x192B,0x192B,0x193D,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDF2 */
0x18AD,0x1918,0x18AF,0x18E1,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDF3 */
0x1931,0x18C8,0x1931,0x18D3,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDF4 */
0x18FC,0x192B,0x1904,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDF5 */
0x18E1,0x18F1,0x1943,0x192B,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDF6 */
0x1904,0x192B,0x1950,0x193D,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDF7 */
0x1943,0x18F1,0x192B,0x1931,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDF8 */
0x18FC,0x192B,0x194F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDF9 */
0x18FC,0x192B,0x194F,0x020A,0x18AD,0x192B,0x192B,0x193D,0x0000, /* FDFA */
0x18C2,0x192B,0x020A,0x18C2,0x192B,0x18AD,0x192B,0x193D,0x0000, /* FDFB */
0x18E1,0x1951,0x18AD,0x192B,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDFC */
0x0451,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDFD */
0xFBC1,0xFDFE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* FDFE */
0xFBC1,0xFDFF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000  /* FDFF */
};

uint16 uca520_p0FE[]= { /* FE00 (4 weights per char) */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE00 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE02 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE04 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE06 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE08 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE0A */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE0C */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE0E */
0x0234,0x0000,0x0000,0x0000, 0x0240,0x0000,0x0000,0x0000, /* FE10 */
0x0291,0x0000,0x0000,0x0000, 0x0247,0x0000,0x0000,0x0000, /* FE12 */
0x0243,0x0000,0x0000,0x0000, 0x026E,0x0000,0x0000,0x0000, /* FE14 */
0x0273,0x0000,0x0000,0x0000, 0x0349,0x0000,0x0000,0x0000, /* FE16 */
0x034A,0x0000,0x0000,0x0000, 0x0281,0x0281,0x0281,0x0000, /* FE18 */
0xFBC1,0xFE1A,0x0000,0x0000, 0xFBC1,0xFE1B,0x0000,0x0000, /* FE1A */
0xFBC1,0xFE1C,0x0000,0x0000, 0xFBC1,0xFE1D,0x0000,0x0000, /* FE1C */
0xFBC1,0xFE1E,0x0000,0x0000, 0xFBC1,0xFE1F,0x0000,0x0000, /* FE1E */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE20 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE22 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE24 */
0x0000,0x0000,0x0000,0x0000, 0xFBC1,0xFE27,0x0000,0x0000, /* FE26 */
0xFBC1,0xFE28,0x0000,0x0000, 0xFBC1,0xFE29,0x0000,0x0000, /* FE28 */
0xFBC1,0xFE2A,0x0000,0x0000, 0xFBC1,0xFE2B,0x0000,0x0000, /* FE2A */
0xFBC1,0xFE2C,0x0000,0x0000, 0xFBC1,0xFE2D,0x0000,0x0000, /* FE2C */
0xFBC1,0xFE2E,0x0000,0x0000, 0xFBC1,0xFE2F,0x0000,0x0000, /* FE2E */
0x0281,0x0281,0x0000,0x0000, 0x022C,0x0000,0x0000,0x0000, /* FE30 */
0x022B,0x0000,0x0000,0x0000, 0x021D,0x0000,0x0000,0x0000, /* FE32 */
0x021D,0x0000,0x0000,0x0000, 0x02FF,0x0000,0x0000,0x0000, /* FE34 */
0x0300,0x0000,0x0000,0x0000, 0x0303,0x0000,0x0000,0x0000, /* FE36 */
0x0304,0x0000,0x0000,0x0000, 0x0347,0x0000,0x0000,0x0000, /* FE38 */
0x0348,0x0000,0x0000,0x0000, 0x0345,0x0000,0x0000,0x0000, /* FE3A */
0x0346,0x0000,0x0000,0x0000, 0x033F,0x0000,0x0000,0x0000, /* FE3C */
0x0340,0x0000,0x0000,0x0000, 0x033D,0x0000,0x0000,0x0000, /* FE3E */
0x033E,0x0000,0x0000,0x0000, 0x0341,0x0000,0x0000,0x0000, /* FE40 */
0x0342,0x0000,0x0000,0x0000, 0x0343,0x0000,0x0000,0x0000, /* FE42 */
0x0344,0x0000,0x0000,0x0000, 0x0241,0x0000,0x0000,0x0000, /* FE44 */
0x0242,0x0000,0x0000,0x0000, 0x0301,0x0000,0x0000,0x0000, /* FE46 */
0x0302,0x0000,0x0000,0x0000, 0x0213,0x0000,0x0000,0x0000, /* FE48 */
0x0213,0x0000,0x0000,0x0000, 0x0213,0x0000,0x0000,0x0000, /* FE4A */
0x0213,0x0000,0x0000,0x0000, 0x021D,0x0000,0x0000,0x0000, /* FE4C */
0x021D,0x0000,0x0000,0x0000, 0x021D,0x0000,0x0000,0x0000, /* FE4E */
0x0234,0x0000,0x0000,0x0000, 0x0240,0x0000,0x0000,0x0000, /* FE50 */
0x0281,0x0000,0x0000,0x0000, 0xFBC1,0xFE53,0x0000,0x0000, /* FE52 */
0x0243,0x0000,0x0000,0x0000, 0x0247,0x0000,0x0000,0x0000, /* FE54 */
0x0273,0x0000,0x0000,0x0000, 0x026E,0x0000,0x0000,0x0000, /* FE56 */
0x022C,0x0000,0x0000,0x0000, 0x02FF,0x0000,0x0000,0x0000, /* FE58 */
0x0300,0x0000,0x0000,0x0000, 0x0303,0x0000,0x0000,0x0000, /* FE5A */
0x0304,0x0000,0x0000,0x0000, 0x0347,0x0000,0x0000,0x0000, /* FE5C */
0x0348,0x0000,0x0000,0x0000, 0x0362,0x0000,0x0000,0x0000, /* FE5E */
0x035F,0x0000,0x0000,0x0000, 0x0357,0x0000,0x0000,0x0000, /* FE60 */
0x0550,0x0000,0x0000,0x0000, 0x0223,0x0000,0x0000,0x0000, /* FE62 */
0x0554,0x0000,0x0000,0x0000, 0x0556,0x0000,0x0000,0x0000, /* FE64 */
0x0555,0x0000,0x0000,0x0000, 0xFBC1,0xFE67,0x0000,0x0000, /* FE66 */
0x035E,0x0000,0x0000,0x0000, 0x11E1,0x0000,0x0000,0x0000, /* FE68 */
0x0363,0x0000,0x0000,0x0000, 0x0356,0x0000,0x0000,0x0000, /* FE6A */
0xFBC1,0xFE6C,0x0000,0x0000, 0xFBC1,0xFE6D,0x0000,0x0000, /* FE6C */
0xFBC1,0xFE6E,0x0000,0x0000, 0xFBC1,0xFE6F,0x0000,0x0000, /* FE6E */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE70 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE72 */
0x0000,0x0000,0x0000,0x0000, 0xFBC1,0xFE75,0x0000,0x0000, /* FE74 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE76 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE78 */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE7A */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE7C */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000, /* FE7E */
0x18A2,0x0000,0x0000,0x0000, 0x18A3,0x0000,0x0000,0x0000, /* FE80 */
0x18A3,0x0000,0x0000,0x0000, 0x18A4,0x0000,0x0000,0x0000, /* FE82 */
0x18A4,0x0000,0x0000,0x0000, 0x18A7,0x0000,0x0000,0x0000, /* FE84 */
0x18A7,0x0000,0x0000,0x0000, 0x18A8,0x0000,0x0000,0x0000, /* FE86 */
0x18A8,0x0000,0x0000,0x0000, 0x18AC,0x0000,0x0000,0x0000, /* FE88 */
0x18AC,0x0000,0x0000,0x0000, 0x18AC,0x0000,0x0000,0x0000, /* FE8A */
0x18AC,0x0000,0x0000,0x0000, 0x18AD,0x0000,0x0000,0x0000, /* FE8C */
0x18AD,0x0000,0x0000,0x0000, 0x18AF,0x0000,0x0000,0x0000, /* FE8E */
0x18AF,0x0000,0x0000,0x0000, 0x18AF,0x0000,0x0000,0x0000, /* FE90 */
0x18AF,0x0000,0x0000,0x0000, 0x18BA,0x0000,0x0000,0x0000, /* FE92 */
0x18BA,0x0000,0x0000,0x0000, 0x18BB,0x0000,0x0000,0x0000, /* FE94 */
0x18BB,0x0000,0x0000,0x0000, 0x18BB,0x0000,0x0000,0x0000, /* FE96 */
0x18BB,0x0000,0x0000,0x0000, 0x18BC,0x0000,0x0000,0x0000, /* FE98 */
0x18BC,0x0000,0x0000,0x0000, 0x18BC,0x0000,0x0000,0x0000, /* FE9A */
0x18BC,0x0000,0x0000,0x0000, 0x18C2,0x0000,0x0000,0x0000, /* FE9C */
0x18C2,0x0000,0x0000,0x0000, 0x18C2,0x0000,0x0000,0x0000, /* FE9E */
0x18C2,0x0000,0x0000,0x0000, 0x18C8,0x0000,0x0000,0x0000, /* FEA0 */
0x18C8,0x0000,0x0000,0x0000, 0x18C8,0x0000,0x0000,0x0000, /* FEA2 */
0x18C8,0x0000,0x0000,0x0000, 0x18C9,0x0000,0x0000,0x0000, /* FEA4 */
0x18C9,0x0000,0x0000,0x0000, 0x18C9,0x0000,0x0000,0x0000, /* FEA6 */
0x18C9,0x0000,0x0000,0x0000, 0x18D3,0x0000,0x0000,0x0000, /* FEA8 */
0x18D3,0x0000,0x0000,0x0000, 0x18D4,0x0000,0x0000,0x0000, /* FEAA */
0x18D4,0x0000,0x0000,0x0000, 0x18E1,0x0000,0x0000,0x0000, /* FEAC */
0x18E1,0x0000,0x0000,0x0000, 0x18E2,0x0000,0x0000,0x0000, /* FEAE */
0x18E2,0x0000,0x0000,0x0000, 0x18F1,0x0000,0x0000,0x0000, /* FEB0 */
0x18F1,0x0000,0x0000,0x0000, 0x18F1,0x0000,0x0000,0x0000, /* FEB2 */
0x18F1,0x0000,0x0000,0x0000, 0x18F2,0x0000,0x0000,0x0000, /* FEB4 */
0x18F2,0x0000,0x0000,0x0000, 0x18F2,0x0000,0x0000,0x0000, /* FEB6 */
0x18F2,0x0000,0x0000,0x0000, 0x18FC,0x0000,0x0000,0x0000, /* FEB8 */
0x18FC,0x0000,0x0000,0x0000, 0x18FC,0x0000,0x0000,0x0000, /* FEBA */
0x18FC,0x0000,0x0000,0x0000, 0x18FD,0x0000,0x0000,0x0000, /* FEBC */
0x18FD,0x0000,0x0000,0x0000, 0x18FD,0x0000,0x0000,0x0000, /* FEBE */
0x18FD,0x0000,0x0000,0x0000, 0x1901,0x0000,0x0000,0x0000, /* FEC0 */
0x1901,0x0000,0x0000,0x0000, 0x1901,0x0000,0x0000,0x0000, /* FEC2 */
0x1901,0x0000,0x0000,0x0000, 0x1902,0x0000,0x0000,0x0000, /* FEC4 */
0x1902,0x0000,0x0000,0x0000, 0x1902,0x0000,0x0000,0x0000, /* FEC6 */
0x1902,0x0000,0x0000,0x0000, 0x1904,0x0000,0x0000,0x0000, /* FEC8 */
0x1904,0x0000,0x0000,0x0000, 0x1904,0x0000,0x0000,0x0000, /* FECA */
0x1904,0x0000,0x0000,0x0000, 0x1905,0x0000,0x0000,0x0000, /* FECC */
0x1905,0x0000,0x0000,0x0000, 0x1905,0x0000,0x0000,0x0000, /* FECE */
0x1905,0x0000,0x0000,0x0000, 0x190B,0x0000,0x0000,0x0000, /* FED0 */
0x190B,0x0000,0x0000,0x0000, 0x190B,0x0000,0x0000,0x0000, /* FED2 */
0x190B,0x0000,0x0000,0x0000, 0x1915,0x0000,0x0000,0x0000, /* FED4 */
0x1915,0x0000,0x0000,0x0000, 0x1915,0x0000,0x0000,0x0000, /* FED6 */
0x1915,0x0000,0x0000,0x0000, 0x1918,0x0000,0x0000,0x0000, /* FED8 */
0x1918,0x0000,0x0000,0x0000, 0x1918,0x0000,0x0000,0x0000, /* FEDA */
0x1918,0x0000,0x0000,0x0000, 0x192B,0x0000,0x0000,0x0000, /* FEDC */
0x192B,0x0000,0x0000,0x0000, 0x192B,0x0000,0x0000,0x0000, /* FEDE */
0x192B,0x0000,0x0000,0x0000, 0x1931,0x0000,0x0000,0x0000, /* FEE0 */
0x1931,0x0000,0x0000,0x0000, 0x1931,0x0000,0x0000,0x0000, /* FEE2 */
0x1931,0x0000,0x0000,0x0000, 0x1934,0x0000,0x0000,0x0000, /* FEE4 */
0x1934,0x0000,0x0000,0x0000, 0x1934,0x0000,0x0000,0x0000, /* FEE6 */
0x1934,0x0000,0x0000,0x0000, 0x193D,0x0000,0x0000,0x0000, /* FEE8 */
0x193D,0x0000,0x0000,0x0000, 0x193D,0x0000,0x0000,0x0000, /* FEEA */
0x193D,0x0000,0x0000,0x0000, 0x1943,0x0000,0x0000,0x0000, /* FEEC */
0x1943,0x0000,0x0000,0x0000, 0x194F,0x0000,0x0000,0x0000, /* FEEE */
0x194F,0x0000,0x0000,0x0000, 0x1950,0x0000,0x0000,0x0000, /* FEF0 */
0x1950,0x0000,0x0000,0x0000, 0x1950,0x0000,0x0000,0x0000, /* FEF2 */
0x1950,0x0000,0x0000,0x0000, 0x192B,0x18A3,0x0000,0x0000, /* FEF4 */
0x192B,0x18A3,0x0000,0x0000, 0x192B,0x18A4,0x0000,0x0000, /* FEF6 */
0x192B,0x18A4,0x0000,0x0000, 0x192B,0x18A8,0x0000,0x0000, /* FEF8 */
0x192B,0x18A8,0x0000,0x0000, 0x192B,0x18AD,0x0000,0x0000, /* FEFA */
0x192B,0x18AD,0x0000,0x0000, 0xFBC1,0xFEFD,0x0000,0x0000, /* FEFC */
0xFBC1,0xFEFE,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000  /* FEFE */
};

uint16 uca520_p0FF[]= { /* FF00 (3 weights per char) */
0xFBC1,0xFF00,0x0000, 0x026E,0x0000,0x0000, 0x02F5,0x0000,0x0000, /* FF00 */
0x0362,0x0000,0x0000, 0x11E1,0x0000,0x0000, 0x0363,0x0000,0x0000, /* FF03 */
0x035F,0x0000,0x0000, 0x02EE,0x0000,0x0000, 0x02FF,0x0000,0x0000, /* FF06 */
0x0300,0x0000,0x0000, 0x0357,0x0000,0x0000, 0x0550,0x0000,0x0000, /* FF09 */
0x0234,0x0000,0x0000, 0x0223,0x0000,0x0000, 0x0281,0x0000,0x0000, /* FF0C */
0x035C,0x0000,0x0000, 0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, /* FF0F */
0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, /* FF12 */
0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, /* FF15 */
0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, 0x0247,0x0000,0x0000, /* FF18 */
0x0243,0x0000,0x0000, 0x0554,0x0000,0x0000, 0x0555,0x0000,0x0000, /* FF1B */
0x0556,0x0000,0x0000, 0x0273,0x0000,0x0000, 0x0356,0x0000,0x0000, /* FF1E */
0x120F,0x0000,0x0000, 0x1225,0x0000,0x0000, 0x123D,0x0000,0x0000, /* FF21 */
0x1250,0x0000,0x0000, 0x126B,0x0000,0x0000, 0x12A3,0x0000,0x0000, /* FF24 */
0x12B0,0x0000,0x0000, 0x12D3,0x0000,0x0000, 0x12EC,0x0000,0x0000, /* FF27 */
0x1305,0x0000,0x0000, 0x131E,0x0000,0x0000, 0x1330,0x0000,0x0000, /* FF2A */
0x135F,0x0000,0x0000, 0x136D,0x0000,0x0000, 0x138E,0x0000,0x0000, /* FF2D */
0x13B3,0x0000,0x0000, 0x13C8,0x0000,0x0000, 0x13DA,0x0000,0x0000, /* FF30 */
0x1410,0x0000,0x0000, 0x1433,0x0000,0x0000, 0x1453,0x0000,0x0000, /* FF33 */
0x147B,0x0000,0x0000, 0x148D,0x0000,0x0000, 0x1497,0x0000,0x0000, /* FF36 */
0x149C,0x0000,0x0000, 0x14AD,0x0000,0x0000, 0x0301,0x0000,0x0000, /* FF39 */
0x035E,0x0000,0x0000, 0x0302,0x0000,0x0000, 0x0211,0x0000,0x0000, /* FF3C */
0x021D,0x0000,0x0000, 0x020E,0x0000,0x0000, 0x120F,0x0000,0x0000, /* FF3F */
0x1225,0x0000,0x0000, 0x123D,0x0000,0x0000, 0x1250,0x0000,0x0000, /* FF42 */
0x126B,0x0000,0x0000, 0x12A3,0x0000,0x0000, 0x12B0,0x0000,0x0000, /* FF45 */
0x12D3,0x0000,0x0000, 0x12EC,0x0000,0x0000, 0x1305,0x0000,0x0000, /* FF48 */
0x131E,0x0000,0x0000, 0x1330,0x0000,0x0000, 0x135F,0x0000,0x0000, /* FF4B */
0x136D,0x0000,0x0000, 0x138E,0x0000,0x0000, 0x13B3,0x0000,0x0000, /* FF4E */
0x13C8,0x0000,0x0000, 0x13DA,0x0000,0x0000, 0x1410,0x0000,0x0000, /* FF51 */
0x1433,0x0000,0x0000, 0x1453,0x0000,0x0000, 0x147B,0x0000,0x0000, /* FF54 */
0x148D,0x0000,0x0000, 0x1497,0x0000,0x0000, 0x149C,0x0000,0x0000, /* FF57 */
0x14AD,0x0000,0x0000, 0x0303,0x0000,0x0000, 0x0558,0x0000,0x0000, /* FF5A */
0x0304,0x0000,0x0000, 0x055B,0x0000,0x0000, 0x0311,0x0000,0x0000, /* FF5D */
0x0312,0x0000,0x0000, 0x0291,0x0000,0x0000, 0x0341,0x0000,0x0000, /* FF60 */
0x0342,0x0000,0x0000, 0x0240,0x0000,0x0000, 0x0233,0x0000,0x0000, /* FF63 */
0x2B43,0x0000,0x0000, 0x2B15,0x0000,0x0000, 0x2B16,0x0000,0x0000, /* FF66 */
0x2B17,0x0000,0x0000, 0x2B18,0x0000,0x0000, 0x2B19,0x0000,0x0000, /* FF69 */
0x2B38,0x0000,0x0000, 0x2B39,0x0000,0x0000, 0x2B3A,0x0000,0x0000, /* FF6C */
0x2B26,0x0000,0x0000, 0x11DD,0x0000,0x0000, 0x2B15,0x0000,0x0000, /* FF6F */
0x2B16,0x0000,0x0000, 0x2B17,0x0000,0x0000, 0x2B18,0x0000,0x0000, /* FF72 */
0x2B19,0x0000,0x0000, 0x2B1A,0x0000,0x0000, 0x2B1B,0x0000,0x0000, /* FF75 */
0x2B1C,0x0000,0x0000, 0x2B1D,0x0000,0x0000, 0x2B1E,0x0000,0x0000, /* FF78 */
0x2B1F,0x0000,0x0000, 0x2B20,0x0000,0x0000, 0x2B21,0x0000,0x0000, /* FF7B */
0x2B22,0x0000,0x0000, 0x2B23,0x0000,0x0000, 0x2B24,0x0000,0x0000, /* FF7E */
0x2B25,0x0000,0x0000, 0x2B26,0x0000,0x0000, 0x2B27,0x0000,0x0000, /* FF81 */
0x2B28,0x0000,0x0000, 0x2B29,0x0000,0x0000, 0x2B2A,0x0000,0x0000, /* FF84 */
0x2B2B,0x0000,0x0000, 0x2B2C,0x0000,0x0000, 0x2B2D,0x0000,0x0000, /* FF87 */
0x2B2E,0x0000,0x0000, 0x2B2F,0x0000,0x0000, 0x2B30,0x0000,0x0000, /* FF8A */
0x2B31,0x0000,0x0000, 0x2B32,0x0000,0x0000, 0x2B33,0x0000,0x0000, /* FF8D */
0x2B34,0x0000,0x0000, 0x2B35,0x0000,0x0000, 0x2B36,0x0000,0x0000, /* FF90 */
0x2B37,0x0000,0x0000, 0x2B38,0x0000,0x0000, 0x2B39,0x0000,0x0000, /* FF93 */
0x2B3A,0x0000,0x0000, 0x2B3B,0x0000,0x0000, 0x2B3C,0x0000,0x0000, /* FF96 */
0x2B3D,0x0000,0x0000, 0x2B3E,0x0000,0x0000, 0x2B3F,0x0000,0x0000, /* FF99 */
0x2B40,0x0000,0x0000, 0x2B44,0x0000,0x0000, 0x0000,0x0000,0x0000, /* FF9C */
0x0000,0x0000,0x0000, 0x2A2D,0x0000,0x0000, 0x29B0,0x0000,0x0000, /* FF9F */
0x29B1,0x0000,0x0000, 0x2A8E,0x0000,0x0000, 0x29B2,0x0000,0x0000, /* FFA2 */
0x2A90,0x0000,0x0000, 0x2A91,0x0000,0x0000, 0x29B3,0x0000,0x0000, /* FFA5 */
0x29B4,0x0000,0x0000, 0x29B5,0x0000,0x0000, 0x2A94,0x0000,0x0000, /* FFA8 */
0x2A95,0x0000,0x0000, 0x2A96,0x0000,0x0000, 0x2A97,0x0000,0x0000, /* FFAB */
0x2A98,0x0000,0x0000, 0x2A99,0x0000,0x0000, 0x29CA,0x0000,0x0000, /* FFAE */
0x29B6,0x0000,0x0000, 0x29B7,0x0000,0x0000, 0x29B8,0x0000,0x0000, /* FFB1 */
0x29D1,0x0000,0x0000, 0x29B9,0x0000,0x0000, 0x29BA,0x0000,0x0000, /* FFB4 */
0x29BB,0x0000,0x0000, 0x29BC,0x0000,0x0000, 0x29BD,0x0000,0x0000, /* FFB7 */
0x29BE,0x0000,0x0000, 0x29BF,0x0000,0x0000, 0x29C0,0x0000,0x0000, /* FFBA */
0x29C1,0x0000,0x0000, 0x29C2,0x0000,0x0000, 0xFBC1,0xFFBF,0x0000, /* FFBD */
0xFBC1,0xFFC0,0x0000, 0xFBC1,0xFFC1,0x0000, 0x2A2E,0x0000,0x0000, /* FFC0 */
0x2A2F,0x0000,0x0000, 0x2A30,0x0000,0x0000, 0x2A31,0x0000,0x0000, /* FFC3 */
0x2A32,0x0000,0x0000, 0x2A33,0x0000,0x0000, 0xFBC1,0xFFC8,0x0000, /* FFC6 */
0xFBC1,0xFFC9,0x0000, 0x2A34,0x0000,0x0000, 0x2A35,0x0000,0x0000, /* FFC9 */
0x2A36,0x0000,0x0000, 0x2A37,0x0000,0x0000, 0x2A38,0x0000,0x0000, /* FFCC */
0x2A39,0x0000,0x0000, 0xFBC1,0xFFD0,0x0000, 0xFBC1,0xFFD1,0x0000, /* FFCF */
0x2A3A,0x0000,0x0000, 0x2A3B,0x0000,0x0000, 0x2A3C,0x0000,0x0000, /* FFD2 */
0x2A3D,0x0000,0x0000, 0x2A3E,0x0000,0x0000, 0x2A3F,0x0000,0x0000, /* FFD5 */
0xFBC1,0xFFD8,0x0000, 0xFBC1,0xFFD9,0x0000, 0x2A40,0x0000,0x0000, /* FFD8 */
0x2A41,0x0000,0x0000, 0x2A42,0x0000,0x0000, 0xFBC1,0xFFDD,0x0000, /* FFDB */
0xFBC1,0xFFDE,0x0000, 0xFBC1,0xFFDF,0x0000, 0x11E0,0x0000,0x0000, /* FFDE */
0x11E2,0x0000,0x0000, 0x0557,0x0000,0x0000, 0x0212,0x0000,0x0000, /* FFE1 */
0x0559,0x0000,0x0000, 0x11E3,0x0000,0x0000, 0x11F5,0x0000,0x0000, /* FFE4 */
0xFBC1,0xFFE7,0x0000, 0x0740,0x0000,0x0000, 0x04D6,0x0000,0x0000, /* FFE7 */
0x04D8,0x0000,0x0000, 0x04D7,0x0000,0x0000, 0x04D9,0x0000,0x0000, /* FFEA */
0x07DE,0x0000,0x0000, 0x0809,0x0000,0x0000, 0xFBC1,0xFFEF,0x0000, /* FFED */
0xFBC1,0xFFF0,0x0000, 0xFBC1,0xFFF1,0x0000, 0xFBC1,0xFFF2,0x0000, /* FFF0 */
0xFBC1,0xFFF3,0x0000, 0xFBC1,0xFFF4,0x0000, 0xFBC1,0xFFF5,0x0000, /* FFF3 */
0xFBC1,0xFFF6,0x0000, 0xFBC1,0xFFF7,0x0000, 0xFBC1,0xFFF8,0x0000, /* FFF6 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* FFF9 */
0x110E,0x0000,0x0000, 0x110F,0x0000,0x0000, 0xFBC1,0xFFFE,0x0000, /* FFFC */
0xFBC1,0xFFFF,0x0000  };

uint16 uca520_p100[]= { /* 10000 (3 weights per char) */
0x3148,0x0000,0x0000, 0x3149,0x0000,0x0000, 0x314A,0x0000,0x0000, /* 10000 */
0x314B,0x0000,0x0000, 0x314C,0x0000,0x0000, 0x314D,0x0000,0x0000, /* 10003 */
0x314E,0x0000,0x0000, 0x314F,0x0000,0x0000, 0x3150,0x0000,0x0000, /* 10006 */
0x3151,0x0000,0x0000, 0x3152,0x0000,0x0000, 0x3153,0x0000,0x0000, /* 10009 */
0xFBC2,0x800C,0x0000, 0x3154,0x0000,0x0000, 0x3155,0x0000,0x0000, /* 1000C */
0x3156,0x0000,0x0000, 0x3157,0x0000,0x0000, 0x3158,0x0000,0x0000, /* 1000F */
0x3159,0x0000,0x0000, 0x315A,0x0000,0x0000, 0x315B,0x0000,0x0000, /* 10012 */
0x315C,0x0000,0x0000, 0x315D,0x0000,0x0000, 0x315E,0x0000,0x0000, /* 10015 */
0x315F,0x0000,0x0000, 0x3160,0x0000,0x0000, 0x3161,0x0000,0x0000, /* 10018 */
0x3162,0x0000,0x0000, 0x3163,0x0000,0x0000, 0x3164,0x0000,0x0000, /* 1001B */
0x3165,0x0000,0x0000, 0x3166,0x0000,0x0000, 0x3167,0x0000,0x0000, /* 1001E */
0x3168,0x0000,0x0000, 0x3169,0x0000,0x0000, 0x316A,0x0000,0x0000, /* 10021 */
0x316B,0x0000,0x0000, 0x316C,0x0000,0x0000, 0x316D,0x0000,0x0000, /* 10024 */
0xFBC2,0x8027,0x0000, 0x316E,0x0000,0x0000, 0x316F,0x0000,0x0000, /* 10027 */
0x3170,0x0000,0x0000, 0x3171,0x0000,0x0000, 0x3172,0x0000,0x0000, /* 1002A */
0x3173,0x0000,0x0000, 0x3174,0x0000,0x0000, 0x3175,0x0000,0x0000, /* 1002D */
0x3176,0x0000,0x0000, 0x3177,0x0000,0x0000, 0x3178,0x0000,0x0000, /* 10030 */
0x3179,0x0000,0x0000, 0x317A,0x0000,0x0000, 0x317B,0x0000,0x0000, /* 10033 */
0x317C,0x0000,0x0000, 0x317D,0x0000,0x0000, 0x317E,0x0000,0x0000, /* 10036 */
0x317F,0x0000,0x0000, 0x3180,0x0000,0x0000, 0xFBC2,0x803B,0x0000, /* 10039 */
0x3181,0x0000,0x0000, 0x3182,0x0000,0x0000, 0xFBC2,0x803E,0x0000, /* 1003C */
0x3183,0x0000,0x0000, 0x3184,0x0000,0x0000, 0x3185,0x0000,0x0000, /* 1003F */
0x3186,0x0000,0x0000, 0x3187,0x0000,0x0000, 0x3188,0x0000,0x0000, /* 10042 */
0x3189,0x0000,0x0000, 0x318A,0x0000,0x0000, 0x318B,0x0000,0x0000, /* 10045 */
0x318C,0x0000,0x0000, 0x318D,0x0000,0x0000, 0x318E,0x0000,0x0000, /* 10048 */
0x318F,0x0000,0x0000, 0x3190,0x0000,0x0000, 0x3191,0x0000,0x0000, /* 1004B */
0xFBC2,0x804E,0x0000, 0xFBC2,0x804F,0x0000, 0x3192,0x0000,0x0000, /* 1004E */
0x3193,0x0000,0x0000, 0x3194,0x0000,0x0000, 0x3195,0x0000,0x0000, /* 10051 */
0x3196,0x0000,0x0000, 0x3197,0x0000,0x0000, 0x3198,0x0000,0x0000, /* 10054 */
0x3199,0x0000,0x0000, 0x319A,0x0000,0x0000, 0x319B,0x0000,0x0000, /* 10057 */
0x319C,0x0000,0x0000, 0x319D,0x0000,0x0000, 0x319E,0x0000,0x0000, /* 1005A */
0x319F,0x0000,0x0000, 0xFBC2,0x805E,0x0000, 0xFBC2,0x805F,0x0000, /* 1005D */
0xFBC2,0x8060,0x0000, 0xFBC2,0x8061,0x0000, 0xFBC2,0x8062,0x0000, /* 10060 */
0xFBC2,0x8063,0x0000, 0xFBC2,0x8064,0x0000, 0xFBC2,0x8065,0x0000, /* 10063 */
0xFBC2,0x8066,0x0000, 0xFBC2,0x8067,0x0000, 0xFBC2,0x8068,0x0000, /* 10066 */
0xFBC2,0x8069,0x0000, 0xFBC2,0x806A,0x0000, 0xFBC2,0x806B,0x0000, /* 10069 */
0xFBC2,0x806C,0x0000, 0xFBC2,0x806D,0x0000, 0xFBC2,0x806E,0x0000, /* 1006C */
0xFBC2,0x806F,0x0000, 0xFBC2,0x8070,0x0000, 0xFBC2,0x8071,0x0000, /* 1006F */
0xFBC2,0x8072,0x0000, 0xFBC2,0x8073,0x0000, 0xFBC2,0x8074,0x0000, /* 10072 */
0xFBC2,0x8075,0x0000, 0xFBC2,0x8076,0x0000, 0xFBC2,0x8077,0x0000, /* 10075 */
0xFBC2,0x8078,0x0000, 0xFBC2,0x8079,0x0000, 0xFBC2,0x807A,0x0000, /* 10078 */
0xFBC2,0x807B,0x0000, 0xFBC2,0x807C,0x0000, 0xFBC2,0x807D,0x0000, /* 1007B */
0xFBC2,0x807E,0x0000, 0xFBC2,0x807F,0x0000, 0x31A0,0x0000,0x0000, /* 1007E */
0x31A1,0x0000,0x0000, 0x31A2,0x0000,0x0000, 0x31A3,0x0000,0x0000, /* 10081 */
0x31A4,0x0000,0x0000, 0x31A5,0x0000,0x0000, 0x31A6,0x0000,0x0000, /* 10084 */
0x31A7,0x0000,0x0000, 0x31A8,0x0000,0x0000, 0x31A9,0x0000,0x0000, /* 10087 */
0x31AA,0x0000,0x0000, 0x31AB,0x0000,0x0000, 0x31AC,0x0000,0x0000, /* 1008A */
0x31AD,0x0000,0x0000, 0x31AE,0x0000,0x0000, 0x31AF,0x0000,0x0000, /* 1008D */
0x31B0,0x0000,0x0000, 0x31B1,0x0000,0x0000, 0x31B2,0x0000,0x0000, /* 10090 */
0x31B3,0x0000,0x0000, 0x31B4,0x0000,0x0000, 0x31B5,0x0000,0x0000, /* 10093 */
0x31B6,0x0000,0x0000, 0x31B7,0x0000,0x0000, 0x31B8,0x0000,0x0000, /* 10096 */
0x31B9,0x0000,0x0000, 0x31BA,0x0000,0x0000, 0x31BB,0x0000,0x0000, /* 10099 */
0x31BC,0x0000,0x0000, 0x31BD,0x0000,0x0000, 0x31BE,0x0000,0x0000, /* 1009C */
0x31BF,0x0000,0x0000, 0x31C0,0x0000,0x0000, 0x31C1,0x0000,0x0000, /* 1009F */
0x31C2,0x0000,0x0000, 0x31C3,0x0000,0x0000, 0x31C4,0x0000,0x0000, /* 100A2 */
0x31C5,0x0000,0x0000, 0x31C6,0x0000,0x0000, 0x31C7,0x0000,0x0000, /* 100A5 */
0x31C8,0x0000,0x0000, 0x31C9,0x0000,0x0000, 0x31CA,0x0000,0x0000, /* 100A8 */
0x31CB,0x0000,0x0000, 0x31CC,0x0000,0x0000, 0x31CD,0x0000,0x0000, /* 100AB */
0x31CE,0x0000,0x0000, 0x31CF,0x0000,0x0000, 0x31D0,0x0000,0x0000, /* 100AE */
0x31D1,0x0000,0x0000, 0x31D2,0x0000,0x0000, 0x31D3,0x0000,0x0000, /* 100B1 */
0x31D4,0x0000,0x0000, 0x31D5,0x0000,0x0000, 0x31D6,0x0000,0x0000, /* 100B4 */
0x31D7,0x0000,0x0000, 0x31D8,0x0000,0x0000, 0x31D9,0x0000,0x0000, /* 100B7 */
0x31DA,0x0000,0x0000, 0x31DB,0x0000,0x0000, 0x31DC,0x0000,0x0000, /* 100BA */
0x31DD,0x0000,0x0000, 0x31DE,0x0000,0x0000, 0x31DF,0x0000,0x0000, /* 100BD */
0x31E0,0x0000,0x0000, 0x31E1,0x0000,0x0000, 0x31E2,0x0000,0x0000, /* 100C0 */
0x31E3,0x0000,0x0000, 0x31E4,0x0000,0x0000, 0x31E5,0x0000,0x0000, /* 100C3 */
0x31E6,0x0000,0x0000, 0x31E7,0x0000,0x0000, 0x31E8,0x0000,0x0000, /* 100C6 */
0x31E9,0x0000,0x0000, 0x31EA,0x0000,0x0000, 0x31EB,0x0000,0x0000, /* 100C9 */
0x31EC,0x0000,0x0000, 0x31ED,0x0000,0x0000, 0x31EE,0x0000,0x0000, /* 100CC */
0x31EF,0x0000,0x0000, 0x31F0,0x0000,0x0000, 0x31F1,0x0000,0x0000, /* 100CF */
0x31F2,0x0000,0x0000, 0x31F3,0x0000,0x0000, 0x31F4,0x0000,0x0000, /* 100D2 */
0x31F5,0x0000,0x0000, 0x31F6,0x0000,0x0000, 0x31F7,0x0000,0x0000, /* 100D5 */
0x31F8,0x0000,0x0000, 0x31F9,0x0000,0x0000, 0x31FA,0x0000,0x0000, /* 100D8 */
0x31FB,0x0000,0x0000, 0x31FC,0x0000,0x0000, 0x31FD,0x0000,0x0000, /* 100DB */
0x31FE,0x0000,0x0000, 0x31FF,0x0000,0x0000, 0x3200,0x0000,0x0000, /* 100DE */
0x3201,0x0000,0x0000, 0x3202,0x0000,0x0000, 0x3203,0x0000,0x0000, /* 100E1 */
0x3204,0x0000,0x0000, 0x3205,0x0000,0x0000, 0x3206,0x0000,0x0000, /* 100E4 */
0x3207,0x0000,0x0000, 0x3208,0x0000,0x0000, 0x3209,0x0000,0x0000, /* 100E7 */
0x320A,0x0000,0x0000, 0x320B,0x0000,0x0000, 0x320C,0x0000,0x0000, /* 100EA */
0x320D,0x0000,0x0000, 0x320E,0x0000,0x0000, 0x320F,0x0000,0x0000, /* 100ED */
0x3210,0x0000,0x0000, 0x3211,0x0000,0x0000, 0x3212,0x0000,0x0000, /* 100F0 */
0x3213,0x0000,0x0000, 0x3214,0x0000,0x0000, 0x3215,0x0000,0x0000, /* 100F3 */
0x3216,0x0000,0x0000, 0x3217,0x0000,0x0000, 0x3218,0x0000,0x0000, /* 100F6 */
0x3219,0x0000,0x0000, 0x321A,0x0000,0x0000, 0xFBC2,0x80FB,0x0000, /* 100F9 */
0xFBC2,0x80FC,0x0000, 0xFBC2,0x80FD,0x0000, 0xFBC2,0x80FE,0x0000, /* 100FC */
0xFBC2,0x80FF,0x0000  };

uint16 uca520_p101[]= { /* 10100 (3 weights per char) */
0x02E4,0x0000,0x0000, 0x02E5,0x0000,0x0000, 0x02E6,0x0000,0x0000, /* 10100 */
0xFBC2,0x8103,0x0000, 0xFBC2,0x8104,0x0000, 0xFBC2,0x8105,0x0000, /* 10103 */
0xFBC2,0x8106,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 10106 */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, /* 10109 */
0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, /* 1010C */
0x120E,0x0000,0x0000, 0x114F,0x0000,0x0000, 0x1150,0x0000,0x0000, /* 1010F */
0x1151,0x0000,0x0000, 0x1152,0x0000,0x0000, 0x1153,0x0000,0x0000, /* 10112 */
0x1154,0x0000,0x0000, 0x1155,0x0000,0x0000, 0x1156,0x0000,0x0000, /* 10115 */
0x1157,0x0000,0x0000, 0x1158,0x0000,0x0000, 0x1159,0x0000,0x0000, /* 10118 */
0x115A,0x0000,0x0000, 0x115B,0x0000,0x0000, 0x115C,0x0000,0x0000, /* 1011B */
0x115D,0x0000,0x0000, 0x115E,0x0000,0x0000, 0x115F,0x0000,0x0000, /* 1011E */
0x1160,0x0000,0x0000, 0x1161,0x0000,0x0000, 0x1162,0x0000,0x0000, /* 10121 */
0x1163,0x0000,0x0000, 0x1164,0x0000,0x0000, 0x1165,0x0000,0x0000, /* 10124 */
0x1166,0x0000,0x0000, 0x1167,0x0000,0x0000, 0x1168,0x0000,0x0000, /* 10127 */
0x1169,0x0000,0x0000, 0x116A,0x0000,0x0000, 0x116B,0x0000,0x0000, /* 1012A */
0x116C,0x0000,0x0000, 0x116D,0x0000,0x0000, 0x116E,0x0000,0x0000, /* 1012D */
0x116F,0x0000,0x0000, 0x1170,0x0000,0x0000, 0x1171,0x0000,0x0000, /* 10130 */
0x1172,0x0000,0x0000, 0xFBC2,0x8134,0x0000, 0xFBC2,0x8135,0x0000, /* 10133 */
0xFBC2,0x8136,0x0000, 0x0E0C,0x0000,0x0000, 0x0E0D,0x0000,0x0000, /* 10136 */
0x0E0E,0x0000,0x0000, 0x0E0F,0x0000,0x0000, 0x0E10,0x0000,0x0000, /* 10139 */
0x0E11,0x0000,0x0000, 0x0E12,0x0000,0x0000, 0x0E13,0x0000,0x0000, /* 1013C */
0x0E14,0x0000,0x0000, 0x1173,0x0000,0x0000, 0x1174,0x0000,0x0000, /* 1013F */
0x1206,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x1175,0x0000,0x0000, /* 10142 */
0x1176,0x0000,0x0000, 0x1177,0x0000,0x0000, 0x1178,0x0000,0x0000, /* 10145 */
0x120A,0x0000,0x0000, 0x1179,0x0000,0x0000, 0x117A,0x0000,0x0000, /* 10148 */
0x117B,0x0000,0x0000, 0x117C,0x0000,0x0000, 0x117D,0x0000,0x0000, /* 1014B */
0x117E,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x117F,0x0000,0x0000, /* 1014E */
0x1180,0x0000,0x0000, 0x1181,0x0000,0x0000, 0x1182,0x0000,0x0000, /* 10151 */
0x1183,0x0000,0x0000, 0x1184,0x0000,0x0000, 0x1185,0x0000,0x0000, /* 10154 */
0x1186,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1206,0x0000,0x0000, /* 10157 */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 1015A */
0x1207,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x120A,0x0000,0x0000, /* 1015D */
0x1187,0x0000,0x0000, 0x1188,0x0000,0x0000, 0x1189,0x0000,0x0000, /* 10160 */
0x118A,0x0000,0x0000, 0x118B,0x0000,0x0000, 0x118C,0x0000,0x0000, /* 10163 */
0x118D,0x0000,0x0000, 0x118E,0x0000,0x0000, 0x118F,0x0000,0x0000, /* 10166 */
0x1190,0x0000,0x0000, 0x1191,0x0000,0x0000, 0x1192,0x0000,0x0000, /* 10169 */
0x1193,0x0000,0x0000, 0x1194,0x0000,0x0000, 0x1195,0x0000,0x0000, /* 1016C */
0x1196,0x0000,0x0000, 0x1197,0x0000,0x0000, 0x1198,0x0000,0x0000, /* 1016F */
0x1199,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x119A,0x0000,0x0000, /* 10172 */
0x119B,0x0000,0x0000, 0x119C,0x0000,0x0000, 0x119D,0x0000,0x0000, /* 10175 */
0x119E,0x0000,0x0000, 0x0E15,0x0000,0x0000, 0x0E16,0x0000,0x0000, /* 10178 */
0x0E17,0x0000,0x0000, 0x0E18,0x0000,0x0000, 0x0E19,0x0000,0x0000, /* 1017B */
0x0E1A,0x0000,0x0000, 0x0E1B,0x0000,0x0000, 0x0E1C,0x0000,0x0000, /* 1017E */
0x0E1D,0x0000,0x0000, 0x0E1E,0x0000,0x0000, 0x0E1F,0x0000,0x0000, /* 10181 */
0x0E20,0x0000,0x0000, 0x0E21,0x0000,0x0000, 0x0E22,0x0000,0x0000, /* 10184 */
0x0E23,0x0000,0x0000, 0x0E24,0x0000,0x0000, 0x0E25,0x0000,0x0000, /* 10187 */
0x1205,0x0000,0x0000, 0xFBC2,0x818B,0x0000, 0xFBC2,0x818C,0x0000, /* 1018A */
0xFBC2,0x818D,0x0000, 0xFBC2,0x818E,0x0000, 0xFBC2,0x818F,0x0000, /* 1018D */
0x0E26,0x0000,0x0000, 0x0E27,0x0000,0x0000, 0x0E28,0x0000,0x0000, /* 10190 */
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, /* 10193 */
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, /* 10196 */
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, /* 10199 */
0xFBC2,0x819C,0x0000, 0xFBC2,0x819D,0x0000, 0xFBC2,0x819E,0x0000, /* 1019C */
0xFBC2,0x819F,0x0000, 0xFBC2,0x81A0,0x0000, 0xFBC2,0x81A1,0x0000, /* 1019F */
0xFBC2,0x81A2,0x0000, 0xFBC2,0x81A3,0x0000, 0xFBC2,0x81A4,0x0000, /* 101A2 */
0xFBC2,0x81A5,0x0000, 0xFBC2,0x81A6,0x0000, 0xFBC2,0x81A7,0x0000, /* 101A5 */
0xFBC2,0x81A8,0x0000, 0xFBC2,0x81A9,0x0000, 0xFBC2,0x81AA,0x0000, /* 101A8 */
0xFBC2,0x81AB,0x0000, 0xFBC2,0x81AC,0x0000, 0xFBC2,0x81AD,0x0000, /* 101AB */
0xFBC2,0x81AE,0x0000, 0xFBC2,0x81AF,0x0000, 0xFBC2,0x81B0,0x0000, /* 101AE */
0xFBC2,0x81B1,0x0000, 0xFBC2,0x81B2,0x0000, 0xFBC2,0x81B3,0x0000, /* 101B1 */
0xFBC2,0x81B4,0x0000, 0xFBC2,0x81B5,0x0000, 0xFBC2,0x81B6,0x0000, /* 101B4 */
0xFBC2,0x81B7,0x0000, 0xFBC2,0x81B8,0x0000, 0xFBC2,0x81B9,0x0000, /* 101B7 */
0xFBC2,0x81BA,0x0000, 0xFBC2,0x81BB,0x0000, 0xFBC2,0x81BC,0x0000, /* 101BA */
0xFBC2,0x81BD,0x0000, 0xFBC2,0x81BE,0x0000, 0xFBC2,0x81BF,0x0000, /* 101BD */
0xFBC2,0x81C0,0x0000, 0xFBC2,0x81C1,0x0000, 0xFBC2,0x81C2,0x0000, /* 101C0 */
0xFBC2,0x81C3,0x0000, 0xFBC2,0x81C4,0x0000, 0xFBC2,0x81C5,0x0000, /* 101C3 */
0xFBC2,0x81C6,0x0000, 0xFBC2,0x81C7,0x0000, 0xFBC2,0x81C8,0x0000, /* 101C6 */
0xFBC2,0x81C9,0x0000, 0xFBC2,0x81CA,0x0000, 0xFBC2,0x81CB,0x0000, /* 101C9 */
0xFBC2,0x81CC,0x0000, 0xFBC2,0x81CD,0x0000, 0xFBC2,0x81CE,0x0000, /* 101CC */
0xFBC2,0x81CF,0x0000, 0x0E32,0x0000,0x0000, 0x0E33,0x0000,0x0000, /* 101CF */
0x0E34,0x0000,0x0000, 0x0E35,0x0000,0x0000, 0x0E36,0x0000,0x0000, /* 101D2 */
0x0E37,0x0000,0x0000, 0x0E38,0x0000,0x0000, 0x0E39,0x0000,0x0000, /* 101D5 */
0x0E3A,0x0000,0x0000, 0x0E3B,0x0000,0x0000, 0x0E3C,0x0000,0x0000, /* 101D8 */
0x0E3D,0x0000,0x0000, 0x0E3E,0x0000,0x0000, 0x0E3F,0x0000,0x0000, /* 101DB */
0x0E40,0x0000,0x0000, 0x0E41,0x0000,0x0000, 0x0E42,0x0000,0x0000, /* 101DE */
0x0E43,0x0000,0x0000, 0x0E44,0x0000,0x0000, 0x0E45,0x0000,0x0000, /* 101E1 */
0x0E46,0x0000,0x0000, 0x0E47,0x0000,0x0000, 0x0E48,0x0000,0x0000, /* 101E4 */
0x0E49,0x0000,0x0000, 0x0E4A,0x0000,0x0000, 0x0E4B,0x0000,0x0000, /* 101E7 */
0x0E4C,0x0000,0x0000, 0x0E4D,0x0000,0x0000, 0x0E4E,0x0000,0x0000, /* 101EA */
0x0E4F,0x0000,0x0000, 0x0E50,0x0000,0x0000, 0x0E51,0x0000,0x0000, /* 101ED */
0x0E52,0x0000,0x0000, 0x0E53,0x0000,0x0000, 0x0E54,0x0000,0x0000, /* 101F0 */
0x0E55,0x0000,0x0000, 0x0E56,0x0000,0x0000, 0x0E57,0x0000,0x0000, /* 101F3 */
0x0E58,0x0000,0x0000, 0x0E59,0x0000,0x0000, 0x0E5A,0x0000,0x0000, /* 101F6 */
0x0E5B,0x0000,0x0000, 0x0E5C,0x0000,0x0000, 0x0E5D,0x0000,0x0000, /* 101F9 */
0x0E5E,0x0000,0x0000, 0x0000,0x0000,0x0000, 0xFBC2,0x81FE,0x0000, /* 101FC */
0xFBC2,0x81FF,0x0000  };

uint16 uca520_p102[]= { /* 10200 (3 weights per char) */
0xFBC2,0x8200,0x0000, 0xFBC2,0x8201,0x0000, 0xFBC2,0x8202,0x0000, /* 10200 */
0xFBC2,0x8203,0x0000, 0xFBC2,0x8204,0x0000, 0xFBC2,0x8205,0x0000, /* 10203 */
0xFBC2,0x8206,0x0000, 0xFBC2,0x8207,0x0000, 0xFBC2,0x8208,0x0000, /* 10206 */
0xFBC2,0x8209,0x0000, 0xFBC2,0x820A,0x0000, 0xFBC2,0x820B,0x0000, /* 10209 */
0xFBC2,0x820C,0x0000, 0xFBC2,0x820D,0x0000, 0xFBC2,0x820E,0x0000, /* 1020C */
0xFBC2,0x820F,0x0000, 0xFBC2,0x8210,0x0000, 0xFBC2,0x8211,0x0000, /* 1020F */
0xFBC2,0x8212,0x0000, 0xFBC2,0x8213,0x0000, 0xFBC2,0x8214,0x0000, /* 10212 */
0xFBC2,0x8215,0x0000, 0xFBC2,0x8216,0x0000, 0xFBC2,0x8217,0x0000, /* 10215 */
0xFBC2,0x8218,0x0000, 0xFBC2,0x8219,0x0000, 0xFBC2,0x821A,0x0000, /* 10218 */
0xFBC2,0x821B,0x0000, 0xFBC2,0x821C,0x0000, 0xFBC2,0x821D,0x0000, /* 1021B */
0xFBC2,0x821E,0x0000, 0xFBC2,0x821F,0x0000, 0xFBC2,0x8220,0x0000, /* 1021E */
0xFBC2,0x8221,0x0000, 0xFBC2,0x8222,0x0000, 0xFBC2,0x8223,0x0000, /* 10221 */
0xFBC2,0x8224,0x0000, 0xFBC2,0x8225,0x0000, 0xFBC2,0x8226,0x0000, /* 10224 */
0xFBC2,0x8227,0x0000, 0xFBC2,0x8228,0x0000, 0xFBC2,0x8229,0x0000, /* 10227 */
0xFBC2,0x822A,0x0000, 0xFBC2,0x822B,0x0000, 0xFBC2,0x822C,0x0000, /* 1022A */
0xFBC2,0x822D,0x0000, 0xFBC2,0x822E,0x0000, 0xFBC2,0x822F,0x0000, /* 1022D */
0xFBC2,0x8230,0x0000, 0xFBC2,0x8231,0x0000, 0xFBC2,0x8232,0x0000, /* 10230 */
0xFBC2,0x8233,0x0000, 0xFBC2,0x8234,0x0000, 0xFBC2,0x8235,0x0000, /* 10233 */
0xFBC2,0x8236,0x0000, 0xFBC2,0x8237,0x0000, 0xFBC2,0x8238,0x0000, /* 10236 */
0xFBC2,0x8239,0x0000, 0xFBC2,0x823A,0x0000, 0xFBC2,0x823B,0x0000, /* 10239 */
0xFBC2,0x823C,0x0000, 0xFBC2,0x823D,0x0000, 0xFBC2,0x823E,0x0000, /* 1023C */
0xFBC2,0x823F,0x0000, 0xFBC2,0x8240,0x0000, 0xFBC2,0x8241,0x0000, /* 1023F */
0xFBC2,0x8242,0x0000, 0xFBC2,0x8243,0x0000, 0xFBC2,0x8244,0x0000, /* 10242 */
0xFBC2,0x8245,0x0000, 0xFBC2,0x8246,0x0000, 0xFBC2,0x8247,0x0000, /* 10245 */
0xFBC2,0x8248,0x0000, 0xFBC2,0x8249,0x0000, 0xFBC2,0x824A,0x0000, /* 10248 */
0xFBC2,0x824B,0x0000, 0xFBC2,0x824C,0x0000, 0xFBC2,0x824D,0x0000, /* 1024B */
0xFBC2,0x824E,0x0000, 0xFBC2,0x824F,0x0000, 0xFBC2,0x8250,0x0000, /* 1024E */
0xFBC2,0x8251,0x0000, 0xFBC2,0x8252,0x0000, 0xFBC2,0x8253,0x0000, /* 10251 */
0xFBC2,0x8254,0x0000, 0xFBC2,0x8255,0x0000, 0xFBC2,0x8256,0x0000, /* 10254 */
0xFBC2,0x8257,0x0000, 0xFBC2,0x8258,0x0000, 0xFBC2,0x8259,0x0000, /* 10257 */
0xFBC2,0x825A,0x0000, 0xFBC2,0x825B,0x0000, 0xFBC2,0x825C,0x0000, /* 1025A */
0xFBC2,0x825D,0x0000, 0xFBC2,0x825E,0x0000, 0xFBC2,0x825F,0x0000, /* 1025D */
0xFBC2,0x8260,0x0000, 0xFBC2,0x8261,0x0000, 0xFBC2,0x8262,0x0000, /* 10260 */
0xFBC2,0x8263,0x0000, 0xFBC2,0x8264,0x0000, 0xFBC2,0x8265,0x0000, /* 10263 */
0xFBC2,0x8266,0x0000, 0xFBC2,0x8267,0x0000, 0xFBC2,0x8268,0x0000, /* 10266 */
0xFBC2,0x8269,0x0000, 0xFBC2,0x826A,0x0000, 0xFBC2,0x826B,0x0000, /* 10269 */
0xFBC2,0x826C,0x0000, 0xFBC2,0x826D,0x0000, 0xFBC2,0x826E,0x0000, /* 1026C */
0xFBC2,0x826F,0x0000, 0xFBC2,0x8270,0x0000, 0xFBC2,0x8271,0x0000, /* 1026F */
0xFBC2,0x8272,0x0000, 0xFBC2,0x8273,0x0000, 0xFBC2,0x8274,0x0000, /* 10272 */
0xFBC2,0x8275,0x0000, 0xFBC2,0x8276,0x0000, 0xFBC2,0x8277,0x0000, /* 10275 */
0xFBC2,0x8278,0x0000, 0xFBC2,0x8279,0x0000, 0xFBC2,0x827A,0x0000, /* 10278 */
0xFBC2,0x827B,0x0000, 0xFBC2,0x827C,0x0000, 0xFBC2,0x827D,0x0000, /* 1027B */
0xFBC2,0x827E,0x0000, 0xFBC2,0x827F,0x0000, 0x3030,0x0000,0x0000, /* 1027E */
0x3031,0x0000,0x0000, 0x3032,0x0000,0x0000, 0x3033,0x0000,0x0000, /* 10281 */
0x3034,0x0000,0x0000, 0x3035,0x0000,0x0000, 0x3036,0x0000,0x0000, /* 10284 */
0x3037,0x0000,0x0000, 0x3038,0x0000,0x0000, 0x3039,0x0000,0x0000, /* 10287 */
0x303A,0x0000,0x0000, 0x303B,0x0000,0x0000, 0x303C,0x0000,0x0000, /* 1028A */
0x303D,0x0000,0x0000, 0x303E,0x0000,0x0000, 0x303F,0x0000,0x0000, /* 1028D */
0x3040,0x0000,0x0000, 0x3041,0x0000,0x0000, 0x3042,0x0000,0x0000, /* 10290 */
0x3043,0x0000,0x0000, 0x3044,0x0000,0x0000, 0x3045,0x0000,0x0000, /* 10293 */
0x3046,0x0000,0x0000, 0x3047,0x0000,0x0000, 0x3048,0x0000,0x0000, /* 10296 */
0x3049,0x0000,0x0000, 0x304A,0x0000,0x0000, 0x304B,0x0000,0x0000, /* 10299 */
0x304C,0x0000,0x0000, 0xFBC2,0x829D,0x0000, 0xFBC2,0x829E,0x0000, /* 1029C */
0xFBC2,0x829F,0x0000, 0x304D,0x0000,0x0000, 0x304E,0x0000,0x0000, /* 1029F */
0x304F,0x0000,0x0000, 0x3050,0x0000,0x0000, 0x3051,0x0000,0x0000, /* 102A2 */
0x3052,0x0000,0x0000, 0x3053,0x0000,0x0000, 0x3054,0x0000,0x0000, /* 102A5 */
0x3055,0x0000,0x0000, 0x3056,0x0000,0x0000, 0x3057,0x0000,0x0000, /* 102A8 */
0x3058,0x0000,0x0000, 0x3059,0x0000,0x0000, 0x305A,0x0000,0x0000, /* 102AB */
0x305B,0x0000,0x0000, 0x305C,0x0000,0x0000, 0x305D,0x0000,0x0000, /* 102AE */
0x305E,0x0000,0x0000, 0x305F,0x0000,0x0000, 0x3060,0x0000,0x0000, /* 102B1 */
0x3061,0x0000,0x0000, 0x3062,0x0000,0x0000, 0x3063,0x0000,0x0000, /* 102B4 */
0x3064,0x0000,0x0000, 0x3065,0x0000,0x0000, 0x3066,0x0000,0x0000, /* 102B7 */
0x3067,0x0000,0x0000, 0x3068,0x0000,0x0000, 0x3069,0x0000,0x0000, /* 102BA */
0x306A,0x0000,0x0000, 0x306B,0x0000,0x0000, 0x306C,0x0000,0x0000, /* 102BD */
0x306D,0x0000,0x0000, 0x306E,0x0000,0x0000, 0x306F,0x0000,0x0000, /* 102C0 */
0x3070,0x0000,0x0000, 0x3071,0x0000,0x0000, 0x3072,0x0000,0x0000, /* 102C3 */
0x3073,0x0000,0x0000, 0x3074,0x0000,0x0000, 0x3075,0x0000,0x0000, /* 102C6 */
0x3076,0x0000,0x0000, 0x3077,0x0000,0x0000, 0x3078,0x0000,0x0000, /* 102C9 */
0x3079,0x0000,0x0000, 0x307A,0x0000,0x0000, 0x307B,0x0000,0x0000, /* 102CC */
0x307C,0x0000,0x0000, 0x307D,0x0000,0x0000, 0xFBC2,0x82D1,0x0000, /* 102CF */
0xFBC2,0x82D2,0x0000, 0xFBC2,0x82D3,0x0000, 0xFBC2,0x82D4,0x0000, /* 102D2 */
0xFBC2,0x82D5,0x0000, 0xFBC2,0x82D6,0x0000, 0xFBC2,0x82D7,0x0000, /* 102D5 */
0xFBC2,0x82D8,0x0000, 0xFBC2,0x82D9,0x0000, 0xFBC2,0x82DA,0x0000, /* 102D8 */
0xFBC2,0x82DB,0x0000, 0xFBC2,0x82DC,0x0000, 0xFBC2,0x82DD,0x0000, /* 102DB */
0xFBC2,0x82DE,0x0000, 0xFBC2,0x82DF,0x0000, 0xFBC2,0x82E0,0x0000, /* 102DE */
0xFBC2,0x82E1,0x0000, 0xFBC2,0x82E2,0x0000, 0xFBC2,0x82E3,0x0000, /* 102E1 */
0xFBC2,0x82E4,0x0000, 0xFBC2,0x82E5,0x0000, 0xFBC2,0x82E6,0x0000, /* 102E4 */
0xFBC2,0x82E7,0x0000, 0xFBC2,0x82E8,0x0000, 0xFBC2,0x82E9,0x0000, /* 102E7 */
0xFBC2,0x82EA,0x0000, 0xFBC2,0x82EB,0x0000, 0xFBC2,0x82EC,0x0000, /* 102EA */
0xFBC2,0x82ED,0x0000, 0xFBC2,0x82EE,0x0000, 0xFBC2,0x82EF,0x0000, /* 102ED */
0xFBC2,0x82F0,0x0000, 0xFBC2,0x82F1,0x0000, 0xFBC2,0x82F2,0x0000, /* 102F0 */
0xFBC2,0x82F3,0x0000, 0xFBC2,0x82F4,0x0000, 0xFBC2,0x82F5,0x0000, /* 102F3 */
0xFBC2,0x82F6,0x0000, 0xFBC2,0x82F7,0x0000, 0xFBC2,0x82F8,0x0000, /* 102F6 */
0xFBC2,0x82F9,0x0000, 0xFBC2,0x82FA,0x0000, 0xFBC2,0x82FB,0x0000, /* 102F9 */
0xFBC2,0x82FC,0x0000, 0xFBC2,0x82FD,0x0000, 0xFBC2,0x82FE,0x0000, /* 102FC */
0xFBC2,0x82FF,0x0000  };

uint16 uca520_p103[]= { /* 10300 (3 weights per char) */
0x3098,0x0000,0x0000, 0x3099,0x0000,0x0000, 0x309A,0x0000,0x0000, /* 10300 */
0x309B,0x0000,0x0000, 0x309C,0x0000,0x0000, 0x309D,0x0000,0x0000, /* 10303 */
0x309E,0x0000,0x0000, 0x309F,0x0000,0x0000, 0x30A0,0x0000,0x0000, /* 10306 */
0x30A1,0x0000,0x0000, 0x30A2,0x0000,0x0000, 0x30A3,0x0000,0x0000, /* 10309 */
0x30A4,0x0000,0x0000, 0x30A5,0x0000,0x0000, 0x30A6,0x0000,0x0000, /* 1030C */
0x30A7,0x0000,0x0000, 0x30A8,0x0000,0x0000, 0x30A9,0x0000,0x0000, /* 1030F */
0x30AA,0x0000,0x0000, 0x30AB,0x0000,0x0000, 0x30AC,0x0000,0x0000, /* 10312 */
0x30AD,0x0000,0x0000, 0x30AE,0x0000,0x0000, 0x30AF,0x0000,0x0000, /* 10315 */
0x30B0,0x0000,0x0000, 0x30B1,0x0000,0x0000, 0x30B2,0x0000,0x0000, /* 10318 */
0x30B3,0x0000,0x0000, 0x30B4,0x0000,0x0000, 0x30B5,0x0000,0x0000, /* 1031B */
0x30B6,0x0000,0x0000, 0xFBC2,0x831F,0x0000, 0x1206,0x0000,0x0000, /* 1031E */
0x120A,0x0000,0x0000, 0x114D,0x0000,0x0000, 0x114E,0x0000,0x0000, /* 10321 */
0xFBC2,0x8324,0x0000, 0xFBC2,0x8325,0x0000, 0xFBC2,0x8326,0x0000, /* 10324 */
0xFBC2,0x8327,0x0000, 0xFBC2,0x8328,0x0000, 0xFBC2,0x8329,0x0000, /* 10327 */
0xFBC2,0x832A,0x0000, 0xFBC2,0x832B,0x0000, 0xFBC2,0x832C,0x0000, /* 1032A */
0xFBC2,0x832D,0x0000, 0xFBC2,0x832E,0x0000, 0xFBC2,0x832F,0x0000, /* 1032D */
0x30B7,0x0000,0x0000, 0x30B8,0x0000,0x0000, 0x30B9,0x0000,0x0000, /* 10330 */
0x30BA,0x0000,0x0000, 0x30BB,0x0000,0x0000, 0x30BC,0x0000,0x0000, /* 10333 */
0x30BD,0x0000,0x0000, 0x30BE,0x0000,0x0000, 0x30BF,0x0000,0x0000, /* 10336 */
0x30C0,0x0000,0x0000, 0x30C1,0x0000,0x0000, 0x30C2,0x0000,0x0000, /* 10339 */
0x30C3,0x0000,0x0000, 0x30C4,0x0000,0x0000, 0x30C5,0x0000,0x0000, /* 1033C */
0x30C6,0x0000,0x0000, 0x30C7,0x0000,0x0000, 0x30C8,0x0000,0x0000, /* 1033F */
0x30C9,0x0000,0x0000, 0x30CA,0x0000,0x0000, 0x30CB,0x0000,0x0000, /* 10342 */
0x30CC,0x0000,0x0000, 0x30CD,0x0000,0x0000, 0x30CE,0x0000,0x0000, /* 10345 */
0x30CF,0x0000,0x0000, 0x30D0,0x0000,0x0000, 0x30D1,0x0000,0x0000, /* 10348 */
0xFBC2,0x834B,0x0000, 0xFBC2,0x834C,0x0000, 0xFBC2,0x834D,0x0000, /* 1034B */
0xFBC2,0x834E,0x0000, 0xFBC2,0x834F,0x0000, 0xFBC2,0x8350,0x0000, /* 1034E */
0xFBC2,0x8351,0x0000, 0xFBC2,0x8352,0x0000, 0xFBC2,0x8353,0x0000, /* 10351 */
0xFBC2,0x8354,0x0000, 0xFBC2,0x8355,0x0000, 0xFBC2,0x8356,0x0000, /* 10354 */
0xFBC2,0x8357,0x0000, 0xFBC2,0x8358,0x0000, 0xFBC2,0x8359,0x0000, /* 10357 */
0xFBC2,0x835A,0x0000, 0xFBC2,0x835B,0x0000, 0xFBC2,0x835C,0x0000, /* 1035A */
0xFBC2,0x835D,0x0000, 0xFBC2,0x835E,0x0000, 0xFBC2,0x835F,0x0000, /* 1035D */
0xFBC2,0x8360,0x0000, 0xFBC2,0x8361,0x0000, 0xFBC2,0x8362,0x0000, /* 10360 */
0xFBC2,0x8363,0x0000, 0xFBC2,0x8364,0x0000, 0xFBC2,0x8365,0x0000, /* 10363 */
0xFBC2,0x8366,0x0000, 0xFBC2,0x8367,0x0000, 0xFBC2,0x8368,0x0000, /* 10366 */
0xFBC2,0x8369,0x0000, 0xFBC2,0x836A,0x0000, 0xFBC2,0x836B,0x0000, /* 10369 */
0xFBC2,0x836C,0x0000, 0xFBC2,0x836D,0x0000, 0xFBC2,0x836E,0x0000, /* 1036C */
0xFBC2,0x836F,0x0000, 0xFBC2,0x8370,0x0000, 0xFBC2,0x8371,0x0000, /* 1036F */
0xFBC2,0x8372,0x0000, 0xFBC2,0x8373,0x0000, 0xFBC2,0x8374,0x0000, /* 10372 */
0xFBC2,0x8375,0x0000, 0xFBC2,0x8376,0x0000, 0xFBC2,0x8377,0x0000, /* 10375 */
0xFBC2,0x8378,0x0000, 0xFBC2,0x8379,0x0000, 0xFBC2,0x837A,0x0000, /* 10378 */
0xFBC2,0x837B,0x0000, 0xFBC2,0x837C,0x0000, 0xFBC2,0x837D,0x0000, /* 1037B */
0xFBC2,0x837E,0x0000, 0xFBC2,0x837F,0x0000, 0x32E3,0x0000,0x0000, /* 1037E */
0x32E4,0x0000,0x0000, 0x32E5,0x0000,0x0000, 0x32E6,0x0000,0x0000, /* 10381 */
0x32E7,0x0000,0x0000, 0x32E8,0x0000,0x0000, 0x32E9,0x0000,0x0000, /* 10384 */
0x32EA,0x0000,0x0000, 0x32EB,0x0000,0x0000, 0x32EC,0x0000,0x0000, /* 10387 */
0x32ED,0x0000,0x0000, 0x32EE,0x0000,0x0000, 0x32EF,0x0000,0x0000, /* 1038A */
0x32F0,0x0000,0x0000, 0x32F1,0x0000,0x0000, 0x32F2,0x0000,0x0000, /* 1038D */
0x32F3,0x0000,0x0000, 0x32F4,0x0000,0x0000, 0x32F5,0x0000,0x0000, /* 10390 */
0x32F6,0x0000,0x0000, 0x32F7,0x0000,0x0000, 0x32F8,0x0000,0x0000, /* 10393 */
0x32F9,0x0000,0x0000, 0x32FA,0x0000,0x0000, 0x32FB,0x0000,0x0000, /* 10396 */
0x32FC,0x0000,0x0000, 0x32FD,0x0000,0x0000, 0x32FE,0x0000,0x0000, /* 10399 */
0x32FF,0x0000,0x0000, 0x3300,0x0000,0x0000, 0xFBC2,0x839E,0x0000, /* 1039C */
0x02E7,0x0000,0x0000, 0x3301,0x0000,0x0000, 0x3302,0x0000,0x0000, /* 1039F */
0x3303,0x0000,0x0000, 0x3304,0x0000,0x0000, 0x3305,0x0000,0x0000, /* 103A2 */
0x3306,0x0000,0x0000, 0x3307,0x0000,0x0000, 0x3308,0x0000,0x0000, /* 103A5 */
0x3309,0x0000,0x0000, 0x330A,0x0000,0x0000, 0x330B,0x0000,0x0000, /* 103A8 */
0x330C,0x0000,0x0000, 0x330D,0x0000,0x0000, 0x330E,0x0000,0x0000, /* 103AB */
0x330F,0x0000,0x0000, 0x3310,0x0000,0x0000, 0x3311,0x0000,0x0000, /* 103AE */
0x3312,0x0000,0x0000, 0x3313,0x0000,0x0000, 0x3314,0x0000,0x0000, /* 103B1 */
0x3315,0x0000,0x0000, 0x3316,0x0000,0x0000, 0x3317,0x0000,0x0000, /* 103B4 */
0x3318,0x0000,0x0000, 0x3319,0x0000,0x0000, 0x331A,0x0000,0x0000, /* 103B7 */
0x331B,0x0000,0x0000, 0x331C,0x0000,0x0000, 0x331D,0x0000,0x0000, /* 103BA */
0x331E,0x0000,0x0000, 0x331F,0x0000,0x0000, 0x3320,0x0000,0x0000, /* 103BD */
0x3321,0x0000,0x0000, 0x3322,0x0000,0x0000, 0x3323,0x0000,0x0000, /* 103C0 */
0x3324,0x0000,0x0000, 0xFBC2,0x83C4,0x0000, 0xFBC2,0x83C5,0x0000, /* 103C3 */
0xFBC2,0x83C6,0x0000, 0xFBC2,0x83C7,0x0000, 0x3325,0x0000,0x0000, /* 103C6 */
0x3326,0x0000,0x0000, 0x3327,0x0000,0x0000, 0x3328,0x0000,0x0000, /* 103C9 */
0x3329,0x0000,0x0000, 0x332A,0x0000,0x0000, 0x332B,0x0000,0x0000, /* 103CC */
0x332C,0x0000,0x0000, 0x02E8,0x0000,0x0000, 0x1206,0x0000,0x0000, /* 103CF */
0x1207,0x0000,0x0000, 0x119F,0x0000,0x0000, 0x11A0,0x0000,0x0000, /* 103D2 */
0x11A1,0x0000,0x0000, 0xFBC2,0x83D6,0x0000, 0xFBC2,0x83D7,0x0000, /* 103D5 */
0xFBC2,0x83D8,0x0000, 0xFBC2,0x83D9,0x0000, 0xFBC2,0x83DA,0x0000, /* 103D8 */
0xFBC2,0x83DB,0x0000, 0xFBC2,0x83DC,0x0000, 0xFBC2,0x83DD,0x0000, /* 103DB */
0xFBC2,0x83DE,0x0000, 0xFBC2,0x83DF,0x0000, 0xFBC2,0x83E0,0x0000, /* 103DE */
0xFBC2,0x83E1,0x0000, 0xFBC2,0x83E2,0x0000, 0xFBC2,0x83E3,0x0000, /* 103E1 */
0xFBC2,0x83E4,0x0000, 0xFBC2,0x83E5,0x0000, 0xFBC2,0x83E6,0x0000, /* 103E4 */
0xFBC2,0x83E7,0x0000, 0xFBC2,0x83E8,0x0000, 0xFBC2,0x83E9,0x0000, /* 103E7 */
0xFBC2,0x83EA,0x0000, 0xFBC2,0x83EB,0x0000, 0xFBC2,0x83EC,0x0000, /* 103EA */
0xFBC2,0x83ED,0x0000, 0xFBC2,0x83EE,0x0000, 0xFBC2,0x83EF,0x0000, /* 103ED */
0xFBC2,0x83F0,0x0000, 0xFBC2,0x83F1,0x0000, 0xFBC2,0x83F2,0x0000, /* 103F0 */
0xFBC2,0x83F3,0x0000, 0xFBC2,0x83F4,0x0000, 0xFBC2,0x83F5,0x0000, /* 103F3 */
0xFBC2,0x83F6,0x0000, 0xFBC2,0x83F7,0x0000, 0xFBC2,0x83F8,0x0000, /* 103F6 */
0xFBC2,0x83F9,0x0000, 0xFBC2,0x83FA,0x0000, 0xFBC2,0x83FB,0x0000, /* 103F9 */
0xFBC2,0x83FC,0x0000, 0xFBC2,0x83FD,0x0000, 0xFBC2,0x83FE,0x0000, /* 103FC */
0xFBC2,0x83FF,0x0000  };

uint16 uca520_p104[]= { /* 10400 (3 weights per char) */
0x30D2,0x0000,0x0000, 0x30D3,0x0000,0x0000, 0x30D4,0x0000,0x0000, /* 10400 */
0x30D5,0x0000,0x0000, 0x30D6,0x0000,0x0000, 0x30D7,0x0000,0x0000, /* 10403 */
0x30D8,0x0000,0x0000, 0x30D9,0x0000,0x0000, 0x30DA,0x0000,0x0000, /* 10406 */
0x30DB,0x0000,0x0000, 0x30DC,0x0000,0x0000, 0x30DD,0x0000,0x0000, /* 10409 */
0x30DE,0x0000,0x0000, 0x30DF,0x0000,0x0000, 0x30E0,0x0000,0x0000, /* 1040C */
0x30E1,0x0000,0x0000, 0x30E2,0x0000,0x0000, 0x30E3,0x0000,0x0000, /* 1040F */
0x30E4,0x0000,0x0000, 0x30E5,0x0000,0x0000, 0x30E6,0x0000,0x0000, /* 10412 */
0x30E7,0x0000,0x0000, 0x30E8,0x0000,0x0000, 0x30E9,0x0000,0x0000, /* 10415 */
0x30EA,0x0000,0x0000, 0x30EB,0x0000,0x0000, 0x30EC,0x0000,0x0000, /* 10418 */
0x30ED,0x0000,0x0000, 0x30EE,0x0000,0x0000, 0x30EF,0x0000,0x0000, /* 1041B */
0x30F0,0x0000,0x0000, 0x30F1,0x0000,0x0000, 0x30F2,0x0000,0x0000, /* 1041E */
0x30F3,0x0000,0x0000, 0x30F4,0x0000,0x0000, 0x30F5,0x0000,0x0000, /* 10421 */
0x30F6,0x0000,0x0000, 0x30F7,0x0000,0x0000, 0x30F8,0x0000,0x0000, /* 10424 */
0x30F9,0x0000,0x0000, 0x30D2,0x0000,0x0000, 0x30D3,0x0000,0x0000, /* 10427 */
0x30D4,0x0000,0x0000, 0x30D5,0x0000,0x0000, 0x30D6,0x0000,0x0000, /* 1042A */
0x30D7,0x0000,0x0000, 0x30D8,0x0000,0x0000, 0x30D9,0x0000,0x0000, /* 1042D */
0x30DA,0x0000,0x0000, 0x30DB,0x0000,0x0000, 0x30DC,0x0000,0x0000, /* 10430 */
0x30DD,0x0000,0x0000, 0x30DE,0x0000,0x0000, 0x30DF,0x0000,0x0000, /* 10433 */
0x30E0,0x0000,0x0000, 0x30E1,0x0000,0x0000, 0x30E2,0x0000,0x0000, /* 10436 */
0x30E3,0x0000,0x0000, 0x30E4,0x0000,0x0000, 0x30E5,0x0000,0x0000, /* 10439 */
0x30E6,0x0000,0x0000, 0x30E7,0x0000,0x0000, 0x30E8,0x0000,0x0000, /* 1043C */
0x30E9,0x0000,0x0000, 0x30EA,0x0000,0x0000, 0x30EB,0x0000,0x0000, /* 1043F */
0x30EC,0x0000,0x0000, 0x30ED,0x0000,0x0000, 0x30EE,0x0000,0x0000, /* 10442 */
0x30EF,0x0000,0x0000, 0x30F0,0x0000,0x0000, 0x30F1,0x0000,0x0000, /* 10445 */
0x30F2,0x0000,0x0000, 0x30F3,0x0000,0x0000, 0x30F4,0x0000,0x0000, /* 10448 */
0x30F5,0x0000,0x0000, 0x30F6,0x0000,0x0000, 0x30F7,0x0000,0x0000, /* 1044B */
0x30F8,0x0000,0x0000, 0x30F9,0x0000,0x0000, 0x30FA,0x0000,0x0000, /* 1044E */
0x30FB,0x0000,0x0000, 0x30FC,0x0000,0x0000, 0x30FD,0x0000,0x0000, /* 10451 */
0x30FE,0x0000,0x0000, 0x30FF,0x0000,0x0000, 0x3100,0x0000,0x0000, /* 10454 */
0x3101,0x0000,0x0000, 0x3102,0x0000,0x0000, 0x3103,0x0000,0x0000, /* 10457 */
0x3104,0x0000,0x0000, 0x3105,0x0000,0x0000, 0x3106,0x0000,0x0000, /* 1045A */
0x3107,0x0000,0x0000, 0x3108,0x0000,0x0000, 0x3109,0x0000,0x0000, /* 1045D */
0x310A,0x0000,0x0000, 0x310B,0x0000,0x0000, 0x310C,0x0000,0x0000, /* 10460 */
0x310D,0x0000,0x0000, 0x310E,0x0000,0x0000, 0x310F,0x0000,0x0000, /* 10463 */
0x3110,0x0000,0x0000, 0x3111,0x0000,0x0000, 0x3112,0x0000,0x0000, /* 10466 */
0x3113,0x0000,0x0000, 0x3114,0x0000,0x0000, 0x3115,0x0000,0x0000, /* 10469 */
0x3116,0x0000,0x0000, 0x3117,0x0000,0x0000, 0x3118,0x0000,0x0000, /* 1046C */
0x3119,0x0000,0x0000, 0x311A,0x0000,0x0000, 0x311B,0x0000,0x0000, /* 1046F */
0x311C,0x0000,0x0000, 0x311D,0x0000,0x0000, 0x311E,0x0000,0x0000, /* 10472 */
0x311F,0x0000,0x0000, 0x3120,0x0000,0x0000, 0x3121,0x0000,0x0000, /* 10475 */
0x3122,0x0000,0x0000, 0x3123,0x0000,0x0000, 0x3124,0x0000,0x0000, /* 10478 */
0x3125,0x0000,0x0000, 0x3126,0x0000,0x0000, 0x3127,0x0000,0x0000, /* 1047B */
0x3128,0x0000,0x0000, 0x3129,0x0000,0x0000, 0x312A,0x0000,0x0000, /* 1047E */
0x312B,0x0000,0x0000, 0x312C,0x0000,0x0000, 0x312D,0x0000,0x0000, /* 10481 */
0x312E,0x0000,0x0000, 0x312F,0x0000,0x0000, 0x3130,0x0000,0x0000, /* 10484 */
0x3131,0x0000,0x0000, 0x3132,0x0000,0x0000, 0x3133,0x0000,0x0000, /* 10487 */
0x3134,0x0000,0x0000, 0x3135,0x0000,0x0000, 0x3136,0x0000,0x0000, /* 1048A */
0x3137,0x0000,0x0000, 0x3138,0x0000,0x0000, 0x3139,0x0000,0x0000, /* 1048D */
0x313A,0x0000,0x0000, 0x313B,0x0000,0x0000, 0x313C,0x0000,0x0000, /* 10490 */
0x313D,0x0000,0x0000, 0x313E,0x0000,0x0000, 0x313F,0x0000,0x0000, /* 10493 */
0x3140,0x0000,0x0000, 0x3141,0x0000,0x0000, 0x3142,0x0000,0x0000, /* 10496 */
0x3143,0x0000,0x0000, 0x3144,0x0000,0x0000, 0x3145,0x0000,0x0000, /* 10499 */
0x3146,0x0000,0x0000, 0x3147,0x0000,0x0000, 0xFBC2,0x849E,0x0000, /* 1049C */
0xFBC2,0x849F,0x0000, 0x1205,0x0000,0x0000, 0x1206,0x0000,0x0000, /* 1049F */
0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, /* 104A2 */
0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, 0x120C,0x0000,0x0000, /* 104A5 */
0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, 0xFBC2,0x84AA,0x0000, /* 104A8 */
0xFBC2,0x84AB,0x0000, 0xFBC2,0x84AC,0x0000, 0xFBC2,0x84AD,0x0000, /* 104AB */
0xFBC2,0x84AE,0x0000, 0xFBC2,0x84AF,0x0000, 0xFBC2,0x84B0,0x0000, /* 104AE */
0xFBC2,0x84B1,0x0000, 0xFBC2,0x84B2,0x0000, 0xFBC2,0x84B3,0x0000, /* 104B1 */
0xFBC2,0x84B4,0x0000, 0xFBC2,0x84B5,0x0000, 0xFBC2,0x84B6,0x0000, /* 104B4 */
0xFBC2,0x84B7,0x0000, 0xFBC2,0x84B8,0x0000, 0xFBC2,0x84B9,0x0000, /* 104B7 */
0xFBC2,0x84BA,0x0000, 0xFBC2,0x84BB,0x0000, 0xFBC2,0x84BC,0x0000, /* 104BA */
0xFBC2,0x84BD,0x0000, 0xFBC2,0x84BE,0x0000, 0xFBC2,0x84BF,0x0000, /* 104BD */
0xFBC2,0x84C0,0x0000, 0xFBC2,0x84C1,0x0000, 0xFBC2,0x84C2,0x0000, /* 104C0 */
0xFBC2,0x84C3,0x0000, 0xFBC2,0x84C4,0x0000, 0xFBC2,0x84C5,0x0000, /* 104C3 */
0xFBC2,0x84C6,0x0000, 0xFBC2,0x84C7,0x0000, 0xFBC2,0x84C8,0x0000, /* 104C6 */
0xFBC2,0x84C9,0x0000, 0xFBC2,0x84CA,0x0000, 0xFBC2,0x84CB,0x0000, /* 104C9 */
0xFBC2,0x84CC,0x0000, 0xFBC2,0x84CD,0x0000, 0xFBC2,0x84CE,0x0000, /* 104CC */
0xFBC2,0x84CF,0x0000, 0xFBC2,0x84D0,0x0000, 0xFBC2,0x84D1,0x0000, /* 104CF */
0xFBC2,0x84D2,0x0000, 0xFBC2,0x84D3,0x0000, 0xFBC2,0x84D4,0x0000, /* 104D2 */
0xFBC2,0x84D5,0x0000, 0xFBC2,0x84D6,0x0000, 0xFBC2,0x84D7,0x0000, /* 104D5 */
0xFBC2,0x84D8,0x0000, 0xFBC2,0x84D9,0x0000, 0xFBC2,0x84DA,0x0000, /* 104D8 */
0xFBC2,0x84DB,0x0000, 0xFBC2,0x84DC,0x0000, 0xFBC2,0x84DD,0x0000, /* 104DB */
0xFBC2,0x84DE,0x0000, 0xFBC2,0x84DF,0x0000, 0xFBC2,0x84E0,0x0000, /* 104DE */
0xFBC2,0x84E1,0x0000, 0xFBC2,0x84E2,0x0000, 0xFBC2,0x84E3,0x0000, /* 104E1 */
0xFBC2,0x84E4,0x0000, 0xFBC2,0x84E5,0x0000, 0xFBC2,0x84E6,0x0000, /* 104E4 */
0xFBC2,0x84E7,0x0000, 0xFBC2,0x84E8,0x0000, 0xFBC2,0x84E9,0x0000, /* 104E7 */
0xFBC2,0x84EA,0x0000, 0xFBC2,0x84EB,0x0000, 0xFBC2,0x84EC,0x0000, /* 104EA */
0xFBC2,0x84ED,0x0000, 0xFBC2,0x84EE,0x0000, 0xFBC2,0x84EF,0x0000, /* 104ED */
0xFBC2,0x84F0,0x0000, 0xFBC2,0x84F1,0x0000, 0xFBC2,0x84F2,0x0000, /* 104F0 */
0xFBC2,0x84F3,0x0000, 0xFBC2,0x84F4,0x0000, 0xFBC2,0x84F5,0x0000, /* 104F3 */
0xFBC2,0x84F6,0x0000, 0xFBC2,0x84F7,0x0000, 0xFBC2,0x84F8,0x0000, /* 104F6 */
0xFBC2,0x84F9,0x0000, 0xFBC2,0x84FA,0x0000, 0xFBC2,0x84FB,0x0000, /* 104F9 */
0xFBC2,0x84FC,0x0000, 0xFBC2,0x84FD,0x0000, 0xFBC2,0x84FE,0x0000, /* 104FC */
0xFBC2,0x84FF,0x0000  };

uint16 uca520_p108[]= { /* 10800 (3 weights per char) */
0x321B,0x0000,0x0000, 0x321C,0x0000,0x0000, 0x321D,0x0000,0x0000, /* 10800 */
0x321E,0x0000,0x0000, 0x321F,0x0000,0x0000, 0x3220,0x0000,0x0000, /* 10803 */
0xFBC2,0x8806,0x0000, 0xFBC2,0x8807,0x0000, 0x3221,0x0000,0x0000, /* 10806 */
0xFBC2,0x8809,0x0000, 0x3222,0x0000,0x0000, 0x3223,0x0000,0x0000, /* 10809 */
0x3224,0x0000,0x0000, 0x3225,0x0000,0x0000, 0x3226,0x0000,0x0000, /* 1080C */
0x3227,0x0000,0x0000, 0x3228,0x0000,0x0000, 0x3229,0x0000,0x0000, /* 1080F */
0x322A,0x0000,0x0000, 0x322B,0x0000,0x0000, 0x322C,0x0000,0x0000, /* 10812 */
0x322D,0x0000,0x0000, 0x322E,0x0000,0x0000, 0x322F,0x0000,0x0000, /* 10815 */
0x3230,0x0000,0x0000, 0x3231,0x0000,0x0000, 0x3232,0x0000,0x0000, /* 10818 */
0x3233,0x0000,0x0000, 0x3234,0x0000,0x0000, 0x3235,0x0000,0x0000, /* 1081B */
0x3236,0x0000,0x0000, 0x3237,0x0000,0x0000, 0x3238,0x0000,0x0000, /* 1081E */
0x3239,0x0000,0x0000, 0x323A,0x0000,0x0000, 0x323B,0x0000,0x0000, /* 10821 */
0x323C,0x0000,0x0000, 0x323D,0x0000,0x0000, 0x323E,0x0000,0x0000, /* 10824 */
0x323F,0x0000,0x0000, 0x3240,0x0000,0x0000, 0x3241,0x0000,0x0000, /* 10827 */
0x3242,0x0000,0x0000, 0x3243,0x0000,0x0000, 0x3244,0x0000,0x0000, /* 1082A */
0x3245,0x0000,0x0000, 0x3246,0x0000,0x0000, 0x3247,0x0000,0x0000, /* 1082D */
0x3248,0x0000,0x0000, 0x3249,0x0000,0x0000, 0x324A,0x0000,0x0000, /* 10830 */
0x324B,0x0000,0x0000, 0x324C,0x0000,0x0000, 0x324D,0x0000,0x0000, /* 10833 */
0xFBC2,0x8836,0x0000, 0x324E,0x0000,0x0000, 0x324F,0x0000,0x0000, /* 10836 */
0xFBC2,0x8839,0x0000, 0xFBC2,0x883A,0x0000, 0xFBC2,0x883B,0x0000, /* 10839 */
0x3250,0x0000,0x0000, 0xFBC2,0x883D,0x0000, 0xFBC2,0x883E,0x0000, /* 1083C */
0x3251,0x0000,0x0000, 0x32A4,0x0000,0x0000, 0x32A5,0x0000,0x0000, /* 1083F */
0x32A6,0x0000,0x0000, 0x32A7,0x0000,0x0000, 0x32A8,0x0000,0x0000, /* 10842 */
0x32A9,0x0000,0x0000, 0x32AA,0x0000,0x0000, 0x32AB,0x0000,0x0000, /* 10845 */
0x32AC,0x0000,0x0000, 0x32AD,0x0000,0x0000, 0x32AE,0x0000,0x0000, /* 10848 */
0x32AF,0x0000,0x0000, 0x32B0,0x0000,0x0000, 0x32B1,0x0000,0x0000, /* 1084B */
0x32B2,0x0000,0x0000, 0x32B3,0x0000,0x0000, 0x32B4,0x0000,0x0000, /* 1084E */
0x32B5,0x0000,0x0000, 0x32B6,0x0000,0x0000, 0x32B7,0x0000,0x0000, /* 10851 */
0x32B8,0x0000,0x0000, 0x32B9,0x0000,0x0000, 0xFBC2,0x8856,0x0000, /* 10854 */
0x02CA,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 10857 */
0x1208,0x0000,0x0000, 0x11A7,0x0000,0x0000, 0x11A8,0x0000,0x0000, /* 1085A */
0x11A9,0x0000,0x0000, 0x11AA,0x0000,0x0000, 0x11AB,0x0000,0x0000, /* 1085D */
0xFBC2,0x8860,0x0000, 0xFBC2,0x8861,0x0000, 0xFBC2,0x8862,0x0000, /* 10860 */
0xFBC2,0x8863,0x0000, 0xFBC2,0x8864,0x0000, 0xFBC2,0x8865,0x0000, /* 10863 */
0xFBC2,0x8866,0x0000, 0xFBC2,0x8867,0x0000, 0xFBC2,0x8868,0x0000, /* 10866 */
0xFBC2,0x8869,0x0000, 0xFBC2,0x886A,0x0000, 0xFBC2,0x886B,0x0000, /* 10869 */
0xFBC2,0x886C,0x0000, 0xFBC2,0x886D,0x0000, 0xFBC2,0x886E,0x0000, /* 1086C */
0xFBC2,0x886F,0x0000, 0xFBC2,0x8870,0x0000, 0xFBC2,0x8871,0x0000, /* 1086F */
0xFBC2,0x8872,0x0000, 0xFBC2,0x8873,0x0000, 0xFBC2,0x8874,0x0000, /* 10872 */
0xFBC2,0x8875,0x0000, 0xFBC2,0x8876,0x0000, 0xFBC2,0x8877,0x0000, /* 10875 */
0xFBC2,0x8878,0x0000, 0xFBC2,0x8879,0x0000, 0xFBC2,0x887A,0x0000, /* 10878 */
0xFBC2,0x887B,0x0000, 0xFBC2,0x887C,0x0000, 0xFBC2,0x887D,0x0000, /* 1087B */
0xFBC2,0x887E,0x0000, 0xFBC2,0x887F,0x0000, 0xFBC2,0x8880,0x0000, /* 1087E */
0xFBC2,0x8881,0x0000, 0xFBC2,0x8882,0x0000, 0xFBC2,0x8883,0x0000, /* 10881 */
0xFBC2,0x8884,0x0000, 0xFBC2,0x8885,0x0000, 0xFBC2,0x8886,0x0000, /* 10884 */
0xFBC2,0x8887,0x0000, 0xFBC2,0x8888,0x0000, 0xFBC2,0x8889,0x0000, /* 10887 */
0xFBC2,0x888A,0x0000, 0xFBC2,0x888B,0x0000, 0xFBC2,0x888C,0x0000, /* 1088A */
0xFBC2,0x888D,0x0000, 0xFBC2,0x888E,0x0000, 0xFBC2,0x888F,0x0000, /* 1088D */
0xFBC2,0x8890,0x0000, 0xFBC2,0x8891,0x0000, 0xFBC2,0x8892,0x0000, /* 10890 */
0xFBC2,0x8893,0x0000, 0xFBC2,0x8894,0x0000, 0xFBC2,0x8895,0x0000, /* 10893 */
0xFBC2,0x8896,0x0000, 0xFBC2,0x8897,0x0000, 0xFBC2,0x8898,0x0000, /* 10896 */
0xFBC2,0x8899,0x0000, 0xFBC2,0x889A,0x0000, 0xFBC2,0x889B,0x0000, /* 10899 */
0xFBC2,0x889C,0x0000, 0xFBC2,0x889D,0x0000, 0xFBC2,0x889E,0x0000, /* 1089C */
0xFBC2,0x889F,0x0000, 0xFBC2,0x88A0,0x0000, 0xFBC2,0x88A1,0x0000, /* 1089F */
0xFBC2,0x88A2,0x0000, 0xFBC2,0x88A3,0x0000, 0xFBC2,0x88A4,0x0000, /* 108A2 */
0xFBC2,0x88A5,0x0000, 0xFBC2,0x88A6,0x0000, 0xFBC2,0x88A7,0x0000, /* 108A5 */
0xFBC2,0x88A8,0x0000, 0xFBC2,0x88A9,0x0000, 0xFBC2,0x88AA,0x0000, /* 108A8 */
0xFBC2,0x88AB,0x0000, 0xFBC2,0x88AC,0x0000, 0xFBC2,0x88AD,0x0000, /* 108AB */
0xFBC2,0x88AE,0x0000, 0xFBC2,0x88AF,0x0000, 0xFBC2,0x88B0,0x0000, /* 108AE */
0xFBC2,0x88B1,0x0000, 0xFBC2,0x88B2,0x0000, 0xFBC2,0x88B3,0x0000, /* 108B1 */
0xFBC2,0x88B4,0x0000, 0xFBC2,0x88B5,0x0000, 0xFBC2,0x88B6,0x0000, /* 108B4 */
0xFBC2,0x88B7,0x0000, 0xFBC2,0x88B8,0x0000, 0xFBC2,0x88B9,0x0000, /* 108B7 */
0xFBC2,0x88BA,0x0000, 0xFBC2,0x88BB,0x0000, 0xFBC2,0x88BC,0x0000, /* 108BA */
0xFBC2,0x88BD,0x0000, 0xFBC2,0x88BE,0x0000, 0xFBC2,0x88BF,0x0000, /* 108BD */
0xFBC2,0x88C0,0x0000, 0xFBC2,0x88C1,0x0000, 0xFBC2,0x88C2,0x0000, /* 108C0 */
0xFBC2,0x88C3,0x0000, 0xFBC2,0x88C4,0x0000, 0xFBC2,0x88C5,0x0000, /* 108C3 */
0xFBC2,0x88C6,0x0000, 0xFBC2,0x88C7,0x0000, 0xFBC2,0x88C8,0x0000, /* 108C6 */
0xFBC2,0x88C9,0x0000, 0xFBC2,0x88CA,0x0000, 0xFBC2,0x88CB,0x0000, /* 108C9 */
0xFBC2,0x88CC,0x0000, 0xFBC2,0x88CD,0x0000, 0xFBC2,0x88CE,0x0000, /* 108CC */
0xFBC2,0x88CF,0x0000, 0xFBC2,0x88D0,0x0000, 0xFBC2,0x88D1,0x0000, /* 108CF */
0xFBC2,0x88D2,0x0000, 0xFBC2,0x88D3,0x0000, 0xFBC2,0x88D4,0x0000, /* 108D2 */
0xFBC2,0x88D5,0x0000, 0xFBC2,0x88D6,0x0000, 0xFBC2,0x88D7,0x0000, /* 108D5 */
0xFBC2,0x88D8,0x0000, 0xFBC2,0x88D9,0x0000, 0xFBC2,0x88DA,0x0000, /* 108D8 */
0xFBC2,0x88DB,0x0000, 0xFBC2,0x88DC,0x0000, 0xFBC2,0x88DD,0x0000, /* 108DB */
0xFBC2,0x88DE,0x0000, 0xFBC2,0x88DF,0x0000, 0xFBC2,0x88E0,0x0000, /* 108DE */
0xFBC2,0x88E1,0x0000, 0xFBC2,0x88E2,0x0000, 0xFBC2,0x88E3,0x0000, /* 108E1 */
0xFBC2,0x88E4,0x0000, 0xFBC2,0x88E5,0x0000, 0xFBC2,0x88E6,0x0000, /* 108E4 */
0xFBC2,0x88E7,0x0000, 0xFBC2,0x88E8,0x0000, 0xFBC2,0x88E9,0x0000, /* 108E7 */
0xFBC2,0x88EA,0x0000, 0xFBC2,0x88EB,0x0000, 0xFBC2,0x88EC,0x0000, /* 108EA */
0xFBC2,0x88ED,0x0000, 0xFBC2,0x88EE,0x0000, 0xFBC2,0x88EF,0x0000, /* 108ED */
0xFBC2,0x88F0,0x0000, 0xFBC2,0x88F1,0x0000, 0xFBC2,0x88F2,0x0000, /* 108F0 */
0xFBC2,0x88F3,0x0000, 0xFBC2,0x88F4,0x0000, 0xFBC2,0x88F5,0x0000, /* 108F3 */
0xFBC2,0x88F6,0x0000, 0xFBC2,0x88F7,0x0000, 0xFBC2,0x88F8,0x0000, /* 108F6 */
0xFBC2,0x88F9,0x0000, 0xFBC2,0x88FA,0x0000, 0xFBC2,0x88FB,0x0000, /* 108F9 */
0xFBC2,0x88FC,0x0000, 0xFBC2,0x88FD,0x0000, 0xFBC2,0x88FE,0x0000, /* 108FC */
0xFBC2,0x88FF,0x0000  };

uint16 uca520_p109[]= { /* 10900 (3 weights per char) */
0x1872,0x0000,0x0000, 0x1873,0x0000,0x0000, 0x1874,0x0000,0x0000, /* 10900 */
0x1875,0x0000,0x0000, 0x1876,0x0000,0x0000, 0x1877,0x0000,0x0000, /* 10903 */
0x1878,0x0000,0x0000, 0x1879,0x0000,0x0000, 0x187A,0x0000,0x0000, /* 10906 */
0x187B,0x0000,0x0000, 0x187C,0x0000,0x0000, 0x187D,0x0000,0x0000, /* 10909 */
0x187E,0x0000,0x0000, 0x187F,0x0000,0x0000, 0x1880,0x0000,0x0000, /* 1090C */
0x1881,0x0000,0x0000, 0x1882,0x0000,0x0000, 0x1883,0x0000,0x0000, /* 1090F */
0x1884,0x0000,0x0000, 0x1885,0x0000,0x0000, 0x1886,0x0000,0x0000, /* 10912 */
0x1887,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x11A4,0x0000,0x0000, /* 10915 */
0x11A5,0x0000,0x0000, 0x11A6,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 10918 */
0x1208,0x0000,0x0000, 0xFBC2,0x891C,0x0000, 0xFBC2,0x891D,0x0000, /* 1091B */
0xFBC2,0x891E,0x0000, 0x02E9,0x0000,0x0000, 0x307E,0x0000,0x0000, /* 1091E */
0x307F,0x0000,0x0000, 0x3080,0x0000,0x0000, 0x3081,0x0000,0x0000, /* 10921 */
0x3082,0x0000,0x0000, 0x3083,0x0000,0x0000, 0x3084,0x0000,0x0000, /* 10924 */
0x3085,0x0000,0x0000, 0x3086,0x0000,0x0000, 0x3087,0x0000,0x0000, /* 10927 */
0x3088,0x0000,0x0000, 0x3089,0x0000,0x0000, 0x308A,0x0000,0x0000, /* 1092A */
0x308B,0x0000,0x0000, 0x308C,0x0000,0x0000, 0x308D,0x0000,0x0000, /* 1092D */
0x308E,0x0000,0x0000, 0x308F,0x0000,0x0000, 0x3090,0x0000,0x0000, /* 10930 */
0x3091,0x0000,0x0000, 0x3092,0x0000,0x0000, 0x3093,0x0000,0x0000, /* 10933 */
0x3094,0x0000,0x0000, 0x3095,0x0000,0x0000, 0x3096,0x0000,0x0000, /* 10936 */
0x3097,0x0000,0x0000, 0xFBC2,0x893A,0x0000, 0xFBC2,0x893B,0x0000, /* 10939 */
0xFBC2,0x893C,0x0000, 0xFBC2,0x893D,0x0000, 0xFBC2,0x893E,0x0000, /* 1093C */
0x02E3,0x0000,0x0000, 0xFBC2,0x8940,0x0000, 0xFBC2,0x8941,0x0000, /* 1093F */
0xFBC2,0x8942,0x0000, 0xFBC2,0x8943,0x0000, 0xFBC2,0x8944,0x0000, /* 10942 */
0xFBC2,0x8945,0x0000, 0xFBC2,0x8946,0x0000, 0xFBC2,0x8947,0x0000, /* 10945 */
0xFBC2,0x8948,0x0000, 0xFBC2,0x8949,0x0000, 0xFBC2,0x894A,0x0000, /* 10948 */
0xFBC2,0x894B,0x0000, 0xFBC2,0x894C,0x0000, 0xFBC2,0x894D,0x0000, /* 1094B */
0xFBC2,0x894E,0x0000, 0xFBC2,0x894F,0x0000, 0xFBC2,0x8950,0x0000, /* 1094E */
0xFBC2,0x8951,0x0000, 0xFBC2,0x8952,0x0000, 0xFBC2,0x8953,0x0000, /* 10951 */
0xFBC2,0x8954,0x0000, 0xFBC2,0x8955,0x0000, 0xFBC2,0x8956,0x0000, /* 10954 */
0xFBC2,0x8957,0x0000, 0xFBC2,0x8958,0x0000, 0xFBC2,0x8959,0x0000, /* 10957 */
0xFBC2,0x895A,0x0000, 0xFBC2,0x895B,0x0000, 0xFBC2,0x895C,0x0000, /* 1095A */
0xFBC2,0x895D,0x0000, 0xFBC2,0x895E,0x0000, 0xFBC2,0x895F,0x0000, /* 1095D */
0xFBC2,0x8960,0x0000, 0xFBC2,0x8961,0x0000, 0xFBC2,0x8962,0x0000, /* 10960 */
0xFBC2,0x8963,0x0000, 0xFBC2,0x8964,0x0000, 0xFBC2,0x8965,0x0000, /* 10963 */
0xFBC2,0x8966,0x0000, 0xFBC2,0x8967,0x0000, 0xFBC2,0x8968,0x0000, /* 10966 */
0xFBC2,0x8969,0x0000, 0xFBC2,0x896A,0x0000, 0xFBC2,0x896B,0x0000, /* 10969 */
0xFBC2,0x896C,0x0000, 0xFBC2,0x896D,0x0000, 0xFBC2,0x896E,0x0000, /* 1096C */
0xFBC2,0x896F,0x0000, 0xFBC2,0x8970,0x0000, 0xFBC2,0x8971,0x0000, /* 1096F */
0xFBC2,0x8972,0x0000, 0xFBC2,0x8973,0x0000, 0xFBC2,0x8974,0x0000, /* 10972 */
0xFBC2,0x8975,0x0000, 0xFBC2,0x8976,0x0000, 0xFBC2,0x8977,0x0000, /* 10975 */
0xFBC2,0x8978,0x0000, 0xFBC2,0x8979,0x0000, 0xFBC2,0x897A,0x0000, /* 10978 */
0xFBC2,0x897B,0x0000, 0xFBC2,0x897C,0x0000, 0xFBC2,0x897D,0x0000, /* 1097B */
0xFBC2,0x897E,0x0000, 0xFBC2,0x897F,0x0000, 0xFBC2,0x8980,0x0000, /* 1097E */
0xFBC2,0x8981,0x0000, 0xFBC2,0x8982,0x0000, 0xFBC2,0x8983,0x0000, /* 10981 */
0xFBC2,0x8984,0x0000, 0xFBC2,0x8985,0x0000, 0xFBC2,0x8986,0x0000, /* 10984 */
0xFBC2,0x8987,0x0000, 0xFBC2,0x8988,0x0000, 0xFBC2,0x8989,0x0000, /* 10987 */
0xFBC2,0x898A,0x0000, 0xFBC2,0x898B,0x0000, 0xFBC2,0x898C,0x0000, /* 1098A */
0xFBC2,0x898D,0x0000, 0xFBC2,0x898E,0x0000, 0xFBC2,0x898F,0x0000, /* 1098D */
0xFBC2,0x8990,0x0000, 0xFBC2,0x8991,0x0000, 0xFBC2,0x8992,0x0000, /* 10990 */
0xFBC2,0x8993,0x0000, 0xFBC2,0x8994,0x0000, 0xFBC2,0x8995,0x0000, /* 10993 */
0xFBC2,0x8996,0x0000, 0xFBC2,0x8997,0x0000, 0xFBC2,0x8998,0x0000, /* 10996 */
0xFBC2,0x8999,0x0000, 0xFBC2,0x899A,0x0000, 0xFBC2,0x899B,0x0000, /* 10999 */
0xFBC2,0x899C,0x0000, 0xFBC2,0x899D,0x0000, 0xFBC2,0x899E,0x0000, /* 1099C */
0xFBC2,0x899F,0x0000, 0xFBC2,0x89A0,0x0000, 0xFBC2,0x89A1,0x0000, /* 1099F */
0xFBC2,0x89A2,0x0000, 0xFBC2,0x89A3,0x0000, 0xFBC2,0x89A4,0x0000, /* 109A2 */
0xFBC2,0x89A5,0x0000, 0xFBC2,0x89A6,0x0000, 0xFBC2,0x89A7,0x0000, /* 109A5 */
0xFBC2,0x89A8,0x0000, 0xFBC2,0x89A9,0x0000, 0xFBC2,0x89AA,0x0000, /* 109A8 */
0xFBC2,0x89AB,0x0000, 0xFBC2,0x89AC,0x0000, 0xFBC2,0x89AD,0x0000, /* 109AB */
0xFBC2,0x89AE,0x0000, 0xFBC2,0x89AF,0x0000, 0xFBC2,0x89B0,0x0000, /* 109AE */
0xFBC2,0x89B1,0x0000, 0xFBC2,0x89B2,0x0000, 0xFBC2,0x89B3,0x0000, /* 109B1 */
0xFBC2,0x89B4,0x0000, 0xFBC2,0x89B5,0x0000, 0xFBC2,0x89B6,0x0000, /* 109B4 */
0xFBC2,0x89B7,0x0000, 0xFBC2,0x89B8,0x0000, 0xFBC2,0x89B9,0x0000, /* 109B7 */
0xFBC2,0x89BA,0x0000, 0xFBC2,0x89BB,0x0000, 0xFBC2,0x89BC,0x0000, /* 109BA */
0xFBC2,0x89BD,0x0000, 0xFBC2,0x89BE,0x0000, 0xFBC2,0x89BF,0x0000, /* 109BD */
0xFBC2,0x89C0,0x0000, 0xFBC2,0x89C1,0x0000, 0xFBC2,0x89C2,0x0000, /* 109C0 */
0xFBC2,0x89C3,0x0000, 0xFBC2,0x89C4,0x0000, 0xFBC2,0x89C5,0x0000, /* 109C3 */
0xFBC2,0x89C6,0x0000, 0xFBC2,0x89C7,0x0000, 0xFBC2,0x89C8,0x0000, /* 109C6 */
0xFBC2,0x89C9,0x0000, 0xFBC2,0x89CA,0x0000, 0xFBC2,0x89CB,0x0000, /* 109C9 */
0xFBC2,0x89CC,0x0000, 0xFBC2,0x89CD,0x0000, 0xFBC2,0x89CE,0x0000, /* 109CC */
0xFBC2,0x89CF,0x0000, 0xFBC2,0x89D0,0x0000, 0xFBC2,0x89D1,0x0000, /* 109CF */
0xFBC2,0x89D2,0x0000, 0xFBC2,0x89D3,0x0000, 0xFBC2,0x89D4,0x0000, /* 109D2 */
0xFBC2,0x89D5,0x0000, 0xFBC2,0x89D6,0x0000, 0xFBC2,0x89D7,0x0000, /* 109D5 */
0xFBC2,0x89D8,0x0000, 0xFBC2,0x89D9,0x0000, 0xFBC2,0x89DA,0x0000, /* 109D8 */
0xFBC2,0x89DB,0x0000, 0xFBC2,0x89DC,0x0000, 0xFBC2,0x89DD,0x0000, /* 109DB */
0xFBC2,0x89DE,0x0000, 0xFBC2,0x89DF,0x0000, 0xFBC2,0x89E0,0x0000, /* 109DE */
0xFBC2,0x89E1,0x0000, 0xFBC2,0x89E2,0x0000, 0xFBC2,0x89E3,0x0000, /* 109E1 */
0xFBC2,0x89E4,0x0000, 0xFBC2,0x89E5,0x0000, 0xFBC2,0x89E6,0x0000, /* 109E4 */
0xFBC2,0x89E7,0x0000, 0xFBC2,0x89E8,0x0000, 0xFBC2,0x89E9,0x0000, /* 109E7 */
0xFBC2,0x89EA,0x0000, 0xFBC2,0x89EB,0x0000, 0xFBC2,0x89EC,0x0000, /* 109EA */
0xFBC2,0x89ED,0x0000, 0xFBC2,0x89EE,0x0000, 0xFBC2,0x89EF,0x0000, /* 109ED */
0xFBC2,0x89F0,0x0000, 0xFBC2,0x89F1,0x0000, 0xFBC2,0x89F2,0x0000, /* 109F0 */
0xFBC2,0x89F3,0x0000, 0xFBC2,0x89F4,0x0000, 0xFBC2,0x89F5,0x0000, /* 109F3 */
0xFBC2,0x89F6,0x0000, 0xFBC2,0x89F7,0x0000, 0xFBC2,0x89F8,0x0000, /* 109F6 */
0xFBC2,0x89F9,0x0000, 0xFBC2,0x89FA,0x0000, 0xFBC2,0x89FB,0x0000, /* 109F9 */
0xFBC2,0x89FC,0x0000, 0xFBC2,0x89FD,0x0000, 0xFBC2,0x89FE,0x0000, /* 109FC */
0xFBC2,0x89FF,0x0000  };

uint16 uca520_p10A[]= { /* 10A00 (3 weights per char) */
0x1F46,0x0000,0x0000, 0x1F47,0x0000,0x0000, 0x1F48,0x0000,0x0000, /* 10A00 */
0x1F49,0x0000,0x0000, 0xFBC2,0x8A04,0x0000, 0x1F4A,0x0000,0x0000, /* 10A03 */
0x1F4B,0x0000,0x0000, 0xFBC2,0x8A07,0x0000, 0xFBC2,0x8A08,0x0000, /* 10A06 */
0xFBC2,0x8A09,0x0000, 0xFBC2,0x8A0A,0x0000, 0xFBC2,0x8A0B,0x0000, /* 10A09 */
0x1F4C,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, /* 10A0C */
0x0000,0x0000,0x0000, 0x1F4D,0x0000,0x0000, 0x1F4E,0x0000,0x0000, /* 10A0F */
0x1F4F,0x0000,0x0000, 0x1F50,0x0000,0x0000, 0xFBC2,0x8A14,0x0000, /* 10A12 */
0x1F51,0x0000,0x0000, 0x1F52,0x0000,0x0000, 0x1F53,0x0000,0x0000, /* 10A15 */
0xFBC2,0x8A18,0x0000, 0x1F54,0x0000,0x0000, 0x1F55,0x0000,0x0000, /* 10A18 */
0x1F56,0x0000,0x0000, 0x1F57,0x0000,0x0000, 0x1F58,0x0000,0x0000, /* 10A1B */
0x1F59,0x0000,0x0000, 0x1F5A,0x0000,0x0000, 0x1F5B,0x0000,0x0000, /* 10A1E */
0x1F5C,0x0000,0x0000, 0x1F5D,0x0000,0x0000, 0x1F5E,0x0000,0x0000, /* 10A21 */
0x1F5F,0x0000,0x0000, 0x1F60,0x0000,0x0000, 0x1F61,0x0000,0x0000, /* 10A24 */
0x1F62,0x0000,0x0000, 0x1F63,0x0000,0x0000, 0x1F64,0x0000,0x0000, /* 10A27 */
0x1F65,0x0000,0x0000, 0x1F66,0x0000,0x0000, 0x1F67,0x0000,0x0000, /* 10A2A */
0x1F68,0x0000,0x0000, 0x1F69,0x0000,0x0000, 0x1F6A,0x0000,0x0000, /* 10A2D */
0x1F6B,0x0000,0x0000, 0x1F6C,0x0000,0x0000, 0x1F6D,0x0000,0x0000, /* 10A30 */
0x1F6E,0x0000,0x0000, 0xFBC2,0x8A34,0x0000, 0xFBC2,0x8A35,0x0000, /* 10A33 */
0xFBC2,0x8A36,0x0000, 0xFBC2,0x8A37,0x0000, 0x0000,0x0000,0x0000, /* 10A36 */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0xFBC2,0x8A3B,0x0000, /* 10A39 */
0xFBC2,0x8A3C,0x0000, 0xFBC2,0x8A3D,0x0000, 0xFBC2,0x8A3E,0x0000, /* 10A3C */
0x1F6F,0x0000,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 10A3F */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x11B4,0x0000,0x0000, /* 10A42 */
0x11B5,0x0000,0x0000, 0x11B6,0x0000,0x0000, 0x11B7,0x0000,0x0000, /* 10A45 */
0xFBC2,0x8A48,0x0000, 0xFBC2,0x8A49,0x0000, 0xFBC2,0x8A4A,0x0000, /* 10A48 */
0xFBC2,0x8A4B,0x0000, 0xFBC2,0x8A4C,0x0000, 0xFBC2,0x8A4D,0x0000, /* 10A4B */
0xFBC2,0x8A4E,0x0000, 0xFBC2,0x8A4F,0x0000, 0x03DF,0x0000,0x0000, /* 10A4E */
0x03E0,0x0000,0x0000, 0x03E1,0x0000,0x0000, 0x03E2,0x0000,0x0000, /* 10A51 */
0x03E3,0x0000,0x0000, 0x03E4,0x0000,0x0000, 0x02AF,0x0000,0x0000, /* 10A54 */
0x02B0,0x0000,0x0000, 0x03E5,0x0000,0x0000, 0xFBC2,0x8A59,0x0000, /* 10A57 */
0xFBC2,0x8A5A,0x0000, 0xFBC2,0x8A5B,0x0000, 0xFBC2,0x8A5C,0x0000, /* 10A5A */
0xFBC2,0x8A5D,0x0000, 0xFBC2,0x8A5E,0x0000, 0xFBC2,0x8A5F,0x0000, /* 10A5D */
0x3252,0x0000,0x0000, 0x3253,0x0000,0x0000, 0x3254,0x0000,0x0000, /* 10A60 */
0x3255,0x0000,0x0000, 0x3256,0x0000,0x0000, 0x3257,0x0000,0x0000, /* 10A63 */
0x3258,0x0000,0x0000, 0x3259,0x0000,0x0000, 0x325A,0x0000,0x0000, /* 10A66 */
0x325B,0x0000,0x0000, 0x325C,0x0000,0x0000, 0x325D,0x0000,0x0000, /* 10A69 */
0x325E,0x0000,0x0000, 0x325F,0x0000,0x0000, 0x3260,0x0000,0x0000, /* 10A6C */
0x3261,0x0000,0x0000, 0x3262,0x0000,0x0000, 0x3263,0x0000,0x0000, /* 10A6F */
0x3264,0x0000,0x0000, 0x3265,0x0000,0x0000, 0x3266,0x0000,0x0000, /* 10A72 */
0x3267,0x0000,0x0000, 0x3268,0x0000,0x0000, 0x3269,0x0000,0x0000, /* 10A75 */
0x326A,0x0000,0x0000, 0x326B,0x0000,0x0000, 0x326C,0x0000,0x0000, /* 10A78 */
0x326D,0x0000,0x0000, 0x326E,0x0000,0x0000, 0x1206,0x0000,0x0000, /* 10A7B */
0x11A2,0x0000,0x0000, 0x11A3,0x0000,0x0000, 0xFBC2,0x8A80,0x0000, /* 10A7E */
0xFBC2,0x8A81,0x0000, 0xFBC2,0x8A82,0x0000, 0xFBC2,0x8A83,0x0000, /* 10A81 */
0xFBC2,0x8A84,0x0000, 0xFBC2,0x8A85,0x0000, 0xFBC2,0x8A86,0x0000, /* 10A84 */
0xFBC2,0x8A87,0x0000, 0xFBC2,0x8A88,0x0000, 0xFBC2,0x8A89,0x0000, /* 10A87 */
0xFBC2,0x8A8A,0x0000, 0xFBC2,0x8A8B,0x0000, 0xFBC2,0x8A8C,0x0000, /* 10A8A */
0xFBC2,0x8A8D,0x0000, 0xFBC2,0x8A8E,0x0000, 0xFBC2,0x8A8F,0x0000, /* 10A8D */
0xFBC2,0x8A90,0x0000, 0xFBC2,0x8A91,0x0000, 0xFBC2,0x8A92,0x0000, /* 10A90 */
0xFBC2,0x8A93,0x0000, 0xFBC2,0x8A94,0x0000, 0xFBC2,0x8A95,0x0000, /* 10A93 */
0xFBC2,0x8A96,0x0000, 0xFBC2,0x8A97,0x0000, 0xFBC2,0x8A98,0x0000, /* 10A96 */
0xFBC2,0x8A99,0x0000, 0xFBC2,0x8A9A,0x0000, 0xFBC2,0x8A9B,0x0000, /* 10A99 */
0xFBC2,0x8A9C,0x0000, 0xFBC2,0x8A9D,0x0000, 0xFBC2,0x8A9E,0x0000, /* 10A9C */
0xFBC2,0x8A9F,0x0000, 0xFBC2,0x8AA0,0x0000, 0xFBC2,0x8AA1,0x0000, /* 10A9F */
0xFBC2,0x8AA2,0x0000, 0xFBC2,0x8AA3,0x0000, 0xFBC2,0x8AA4,0x0000, /* 10AA2 */
0xFBC2,0x8AA5,0x0000, 0xFBC2,0x8AA6,0x0000, 0xFBC2,0x8AA7,0x0000, /* 10AA5 */
0xFBC2,0x8AA8,0x0000, 0xFBC2,0x8AA9,0x0000, 0xFBC2,0x8AAA,0x0000, /* 10AA8 */
0xFBC2,0x8AAB,0x0000, 0xFBC2,0x8AAC,0x0000, 0xFBC2,0x8AAD,0x0000, /* 10AAB */
0xFBC2,0x8AAE,0x0000, 0xFBC2,0x8AAF,0x0000, 0xFBC2,0x8AB0,0x0000, /* 10AAE */
0xFBC2,0x8AB1,0x0000, 0xFBC2,0x8AB2,0x0000, 0xFBC2,0x8AB3,0x0000, /* 10AB1 */
0xFBC2,0x8AB4,0x0000, 0xFBC2,0x8AB5,0x0000, 0xFBC2,0x8AB6,0x0000, /* 10AB4 */
0xFBC2,0x8AB7,0x0000, 0xFBC2,0x8AB8,0x0000, 0xFBC2,0x8AB9,0x0000, /* 10AB7 */
0xFBC2,0x8ABA,0x0000, 0xFBC2,0x8ABB,0x0000, 0xFBC2,0x8ABC,0x0000, /* 10ABA */
0xFBC2,0x8ABD,0x0000, 0xFBC2,0x8ABE,0x0000, 0xFBC2,0x8ABF,0x0000, /* 10ABD */
0xFBC2,0x8AC0,0x0000, 0xFBC2,0x8AC1,0x0000, 0xFBC2,0x8AC2,0x0000, /* 10AC0 */
0xFBC2,0x8AC3,0x0000, 0xFBC2,0x8AC4,0x0000, 0xFBC2,0x8AC5,0x0000, /* 10AC3 */
0xFBC2,0x8AC6,0x0000, 0xFBC2,0x8AC7,0x0000, 0xFBC2,0x8AC8,0x0000, /* 10AC6 */
0xFBC2,0x8AC9,0x0000, 0xFBC2,0x8ACA,0x0000, 0xFBC2,0x8ACB,0x0000, /* 10AC9 */
0xFBC2,0x8ACC,0x0000, 0xFBC2,0x8ACD,0x0000, 0xFBC2,0x8ACE,0x0000, /* 10ACC */
0xFBC2,0x8ACF,0x0000, 0xFBC2,0x8AD0,0x0000, 0xFBC2,0x8AD1,0x0000, /* 10ACF */
0xFBC2,0x8AD2,0x0000, 0xFBC2,0x8AD3,0x0000, 0xFBC2,0x8AD4,0x0000, /* 10AD2 */
0xFBC2,0x8AD5,0x0000, 0xFBC2,0x8AD6,0x0000, 0xFBC2,0x8AD7,0x0000, /* 10AD5 */
0xFBC2,0x8AD8,0x0000, 0xFBC2,0x8AD9,0x0000, 0xFBC2,0x8ADA,0x0000, /* 10AD8 */
0xFBC2,0x8ADB,0x0000, 0xFBC2,0x8ADC,0x0000, 0xFBC2,0x8ADD,0x0000, /* 10ADB */
0xFBC2,0x8ADE,0x0000, 0xFBC2,0x8ADF,0x0000, 0xFBC2,0x8AE0,0x0000, /* 10ADE */
0xFBC2,0x8AE1,0x0000, 0xFBC2,0x8AE2,0x0000, 0xFBC2,0x8AE3,0x0000, /* 10AE1 */
0xFBC2,0x8AE4,0x0000, 0xFBC2,0x8AE5,0x0000, 0xFBC2,0x8AE6,0x0000, /* 10AE4 */
0xFBC2,0x8AE7,0x0000, 0xFBC2,0x8AE8,0x0000, 0xFBC2,0x8AE9,0x0000, /* 10AE7 */
0xFBC2,0x8AEA,0x0000, 0xFBC2,0x8AEB,0x0000, 0xFBC2,0x8AEC,0x0000, /* 10AEA */
0xFBC2,0x8AED,0x0000, 0xFBC2,0x8AEE,0x0000, 0xFBC2,0x8AEF,0x0000, /* 10AED */
0xFBC2,0x8AF0,0x0000, 0xFBC2,0x8AF1,0x0000, 0xFBC2,0x8AF2,0x0000, /* 10AF0 */
0xFBC2,0x8AF3,0x0000, 0xFBC2,0x8AF4,0x0000, 0xFBC2,0x8AF5,0x0000, /* 10AF3 */
0xFBC2,0x8AF6,0x0000, 0xFBC2,0x8AF7,0x0000, 0xFBC2,0x8AF8,0x0000, /* 10AF6 */
0xFBC2,0x8AF9,0x0000, 0xFBC2,0x8AFA,0x0000, 0xFBC2,0x8AFB,0x0000, /* 10AF9 */
0xFBC2,0x8AFC,0x0000, 0xFBC2,0x8AFD,0x0000, 0xFBC2,0x8AFE,0x0000, /* 10AFC */
0xFBC2,0x8AFF,0x0000  };

uint16 uca520_p10B[]= { /* 10B00 (3 weights per char) */
0x326F,0x0000,0x0000, 0x3270,0x0000,0x0000, 0x3271,0x0000,0x0000, /* 10B00 */
0x3272,0x0000,0x0000, 0x3273,0x0000,0x0000, 0x3274,0x0000,0x0000, /* 10B03 */
0x3275,0x0000,0x0000, 0x3276,0x0000,0x0000, 0x3277,0x0000,0x0000, /* 10B06 */
0x3278,0x0000,0x0000, 0x3279,0x0000,0x0000, 0x327A,0x0000,0x0000, /* 10B09 */
0x327B,0x0000,0x0000, 0x327C,0x0000,0x0000, 0x327D,0x0000,0x0000, /* 10B0C */
0x327E,0x0000,0x0000, 0x327F,0x0000,0x0000, 0x3280,0x0000,0x0000, /* 10B0F */
0x3281,0x0000,0x0000, 0x3282,0x0000,0x0000, 0x3283,0x0000,0x0000, /* 10B12 */
0x3284,0x0000,0x0000, 0x3285,0x0000,0x0000, 0x3286,0x0000,0x0000, /* 10B15 */
0x3287,0x0000,0x0000, 0x3288,0x0000,0x0000, 0x3289,0x0000,0x0000, /* 10B18 */
0x328A,0x0000,0x0000, 0x328B,0x0000,0x0000, 0x328C,0x0000,0x0000, /* 10B1B */
0x328D,0x0000,0x0000, 0x328E,0x0000,0x0000, 0x328F,0x0000,0x0000, /* 10B1E */
0x3290,0x0000,0x0000, 0x3291,0x0000,0x0000, 0x3292,0x0000,0x0000, /* 10B21 */
0x3293,0x0000,0x0000, 0x3294,0x0000,0x0000, 0x3295,0x0000,0x0000, /* 10B24 */
0x3296,0x0000,0x0000, 0x3297,0x0000,0x0000, 0x3298,0x0000,0x0000, /* 10B27 */
0x3299,0x0000,0x0000, 0x329A,0x0000,0x0000, 0x329B,0x0000,0x0000, /* 10B2A */
0x329C,0x0000,0x0000, 0x329C,0x0000,0x0000, 0x329D,0x0000,0x0000, /* 10B2D */
0x329E,0x0000,0x0000, 0x329F,0x0000,0x0000, 0x32A0,0x0000,0x0000, /* 10B30 */
0x32A1,0x0000,0x0000, 0x32A2,0x0000,0x0000, 0x32A3,0x0000,0x0000, /* 10B33 */
0xFBC2,0x8B36,0x0000, 0xFBC2,0x8B37,0x0000, 0xFBC2,0x8B38,0x0000, /* 10B36 */
0x03E6,0x0000,0x0000, 0x02CB,0x0000,0x0000, 0x02CC,0x0000,0x0000, /* 10B39 */
0x02CD,0x0000,0x0000, 0x02CE,0x0000,0x0000, 0x02CF,0x0000,0x0000, /* 10B3C */
0x02D0,0x0000,0x0000, 0x32BA,0x0000,0x0000, 0x32BB,0x0000,0x0000, /* 10B3F */
0x32BC,0x0000,0x0000, 0x32BD,0x0000,0x0000, 0x32BE,0x0000,0x0000, /* 10B42 */
0x32BF,0x0000,0x0000, 0x32C0,0x0000,0x0000, 0x32C1,0x0000,0x0000, /* 10B45 */
0x32C2,0x0000,0x0000, 0x32C3,0x0000,0x0000, 0x32C4,0x0000,0x0000, /* 10B48 */
0x32C5,0x0000,0x0000, 0x32C6,0x0000,0x0000, 0x32C7,0x0000,0x0000, /* 10B4B */
0x32C8,0x0000,0x0000, 0x32C9,0x0000,0x0000, 0x32CA,0x0000,0x0000, /* 10B4E */
0x32CB,0x0000,0x0000, 0x32CC,0x0000,0x0000, 0x32CD,0x0000,0x0000, /* 10B51 */
0x32CE,0x0000,0x0000, 0x32CF,0x0000,0x0000, 0xFBC2,0x8B56,0x0000, /* 10B54 */
0xFBC2,0x8B57,0x0000, 0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, /* 10B57 */
0x1208,0x0000,0x0000, 0x1209,0x0000,0x0000, 0x11AC,0x0000,0x0000, /* 10B5A */
0x11AD,0x0000,0x0000, 0x11AE,0x0000,0x0000, 0x11AF,0x0000,0x0000, /* 10B5D */
0x32D0,0x0000,0x0000, 0x32D1,0x0000,0x0000, 0x32D2,0x0000,0x0000, /* 10B60 */
0x32D3,0x0000,0x0000, 0x32D4,0x0000,0x0000, 0x32D5,0x0000,0x0000, /* 10B63 */
0x32D6,0x0000,0x0000, 0x32D7,0x0000,0x0000, 0x32D8,0x0000,0x0000, /* 10B66 */
0x32D9,0x0000,0x0000, 0x32DA,0x0000,0x0000, 0x32DB,0x0000,0x0000, /* 10B69 */
0x32DC,0x0000,0x0000, 0x32DD,0x0000,0x0000, 0x32DE,0x0000,0x0000, /* 10B6C */
0x32DF,0x0000,0x0000, 0x32E0,0x0000,0x0000, 0x32E1,0x0000,0x0000, /* 10B6F */
0x32E2,0x0000,0x0000, 0xFBC2,0x8B73,0x0000, 0xFBC2,0x8B74,0x0000, /* 10B72 */
0xFBC2,0x8B75,0x0000, 0xFBC2,0x8B76,0x0000, 0xFBC2,0x8B77,0x0000, /* 10B75 */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 10B78 */
0x1209,0x0000,0x0000, 0x11B0,0x0000,0x0000, 0x11B1,0x0000,0x0000, /* 10B7B */
0x11B2,0x0000,0x0000, 0x11B3,0x0000,0x0000, 0xFBC2,0x8B80,0x0000, /* 10B7E */
0xFBC2,0x8B81,0x0000, 0xFBC2,0x8B82,0x0000, 0xFBC2,0x8B83,0x0000, /* 10B81 */
0xFBC2,0x8B84,0x0000, 0xFBC2,0x8B85,0x0000, 0xFBC2,0x8B86,0x0000, /* 10B84 */
0xFBC2,0x8B87,0x0000, 0xFBC2,0x8B88,0x0000, 0xFBC2,0x8B89,0x0000, /* 10B87 */
0xFBC2,0x8B8A,0x0000, 0xFBC2,0x8B8B,0x0000, 0xFBC2,0x8B8C,0x0000, /* 10B8A */
0xFBC2,0x8B8D,0x0000, 0xFBC2,0x8B8E,0x0000, 0xFBC2,0x8B8F,0x0000, /* 10B8D */
0xFBC2,0x8B90,0x0000, 0xFBC2,0x8B91,0x0000, 0xFBC2,0x8B92,0x0000, /* 10B90 */
0xFBC2,0x8B93,0x0000, 0xFBC2,0x8B94,0x0000, 0xFBC2,0x8B95,0x0000, /* 10B93 */
0xFBC2,0x8B96,0x0000, 0xFBC2,0x8B97,0x0000, 0xFBC2,0x8B98,0x0000, /* 10B96 */
0xFBC2,0x8B99,0x0000, 0xFBC2,0x8B9A,0x0000, 0xFBC2,0x8B9B,0x0000, /* 10B99 */
0xFBC2,0x8B9C,0x0000, 0xFBC2,0x8B9D,0x0000, 0xFBC2,0x8B9E,0x0000, /* 10B9C */
0xFBC2,0x8B9F,0x0000, 0xFBC2,0x8BA0,0x0000, 0xFBC2,0x8BA1,0x0000, /* 10B9F */
0xFBC2,0x8BA2,0x0000, 0xFBC2,0x8BA3,0x0000, 0xFBC2,0x8BA4,0x0000, /* 10BA2 */
0xFBC2,0x8BA5,0x0000, 0xFBC2,0x8BA6,0x0000, 0xFBC2,0x8BA7,0x0000, /* 10BA5 */
0xFBC2,0x8BA8,0x0000, 0xFBC2,0x8BA9,0x0000, 0xFBC2,0x8BAA,0x0000, /* 10BA8 */
0xFBC2,0x8BAB,0x0000, 0xFBC2,0x8BAC,0x0000, 0xFBC2,0x8BAD,0x0000, /* 10BAB */
0xFBC2,0x8BAE,0x0000, 0xFBC2,0x8BAF,0x0000, 0xFBC2,0x8BB0,0x0000, /* 10BAE */
0xFBC2,0x8BB1,0x0000, 0xFBC2,0x8BB2,0x0000, 0xFBC2,0x8BB3,0x0000, /* 10BB1 */
0xFBC2,0x8BB4,0x0000, 0xFBC2,0x8BB5,0x0000, 0xFBC2,0x8BB6,0x0000, /* 10BB4 */
0xFBC2,0x8BB7,0x0000, 0xFBC2,0x8BB8,0x0000, 0xFBC2,0x8BB9,0x0000, /* 10BB7 */
0xFBC2,0x8BBA,0x0000, 0xFBC2,0x8BBB,0x0000, 0xFBC2,0x8BBC,0x0000, /* 10BBA */
0xFBC2,0x8BBD,0x0000, 0xFBC2,0x8BBE,0x0000, 0xFBC2,0x8BBF,0x0000, /* 10BBD */
0xFBC2,0x8BC0,0x0000, 0xFBC2,0x8BC1,0x0000, 0xFBC2,0x8BC2,0x0000, /* 10BC0 */
0xFBC2,0x8BC3,0x0000, 0xFBC2,0x8BC4,0x0000, 0xFBC2,0x8BC5,0x0000, /* 10BC3 */
0xFBC2,0x8BC6,0x0000, 0xFBC2,0x8BC7,0x0000, 0xFBC2,0x8BC8,0x0000, /* 10BC6 */
0xFBC2,0x8BC9,0x0000, 0xFBC2,0x8BCA,0x0000, 0xFBC2,0x8BCB,0x0000, /* 10BC9 */
0xFBC2,0x8BCC,0x0000, 0xFBC2,0x8BCD,0x0000, 0xFBC2,0x8BCE,0x0000, /* 10BCC */
0xFBC2,0x8BCF,0x0000, 0xFBC2,0x8BD0,0x0000, 0xFBC2,0x8BD1,0x0000, /* 10BCF */
0xFBC2,0x8BD2,0x0000, 0xFBC2,0x8BD3,0x0000, 0xFBC2,0x8BD4,0x0000, /* 10BD2 */
0xFBC2,0x8BD5,0x0000, 0xFBC2,0x8BD6,0x0000, 0xFBC2,0x8BD7,0x0000, /* 10BD5 */
0xFBC2,0x8BD8,0x0000, 0xFBC2,0x8BD9,0x0000, 0xFBC2,0x8BDA,0x0000, /* 10BD8 */
0xFBC2,0x8BDB,0x0000, 0xFBC2,0x8BDC,0x0000, 0xFBC2,0x8BDD,0x0000, /* 10BDB */
0xFBC2,0x8BDE,0x0000, 0xFBC2,0x8BDF,0x0000, 0xFBC2,0x8BE0,0x0000, /* 10BDE */
0xFBC2,0x8BE1,0x0000, 0xFBC2,0x8BE2,0x0000, 0xFBC2,0x8BE3,0x0000, /* 10BE1 */
0xFBC2,0x8BE4,0x0000, 0xFBC2,0x8BE5,0x0000, 0xFBC2,0x8BE6,0x0000, /* 10BE4 */
0xFBC2,0x8BE7,0x0000, 0xFBC2,0x8BE8,0x0000, 0xFBC2,0x8BE9,0x0000, /* 10BE7 */
0xFBC2,0x8BEA,0x0000, 0xFBC2,0x8BEB,0x0000, 0xFBC2,0x8BEC,0x0000, /* 10BEA */
0xFBC2,0x8BED,0x0000, 0xFBC2,0x8BEE,0x0000, 0xFBC2,0x8BEF,0x0000, /* 10BED */
0xFBC2,0x8BF0,0x0000, 0xFBC2,0x8BF1,0x0000, 0xFBC2,0x8BF2,0x0000, /* 10BF0 */
0xFBC2,0x8BF3,0x0000, 0xFBC2,0x8BF4,0x0000, 0xFBC2,0x8BF5,0x0000, /* 10BF3 */
0xFBC2,0x8BF6,0x0000, 0xFBC2,0x8BF7,0x0000, 0xFBC2,0x8BF8,0x0000, /* 10BF6 */
0xFBC2,0x8BF9,0x0000, 0xFBC2,0x8BFA,0x0000, 0xFBC2,0x8BFB,0x0000, /* 10BF9 */
0xFBC2,0x8BFC,0x0000, 0xFBC2,0x8BFD,0x0000, 0xFBC2,0x8BFE,0x0000, /* 10BFC */
0xFBC2,0x8BFF,0x0000  };

uint16 uca520_p10C[]= { /* 10C00 (3 weights per char) */
0x2826,0x0000,0x0000, 0x2826,0x0000,0x0000, 0x2827,0x0000,0x0000, /* 10C00 */
0x2828,0x0000,0x0000, 0x2828,0x0000,0x0000, 0x2829,0x0000,0x0000, /* 10C03 */
0x282A,0x0000,0x0000, 0x282B,0x0000,0x0000, 0x282B,0x0000,0x0000, /* 10C06 */
0x282C,0x0000,0x0000, 0x282C,0x0000,0x0000, 0x282D,0x0000,0x0000, /* 10C09 */
0x282D,0x0000,0x0000, 0x282E,0x0000,0x0000, 0x282E,0x0000,0x0000, /* 10C0C */
0x282F,0x0000,0x0000, 0x282F,0x0000,0x0000, 0x2830,0x0000,0x0000, /* 10C0F */
0x2830,0x0000,0x0000, 0x2831,0x0000,0x0000, 0x2832,0x0000,0x0000, /* 10C12 */
0x2832,0x0000,0x0000, 0x2833,0x0000,0x0000, 0x2833,0x0000,0x0000, /* 10C15 */
0x2834,0x0000,0x0000, 0x2834,0x0000,0x0000, 0x2835,0x0000,0x0000, /* 10C18 */
0x2835,0x0000,0x0000, 0x2836,0x0000,0x0000, 0x2836,0x0000,0x0000, /* 10C1B */
0x2837,0x0000,0x0000, 0x2837,0x0000,0x0000, 0x2838,0x0000,0x0000, /* 10C1E */
0x2839,0x0000,0x0000, 0x283A,0x0000,0x0000, 0x283B,0x0000,0x0000, /* 10C21 */
0x283C,0x0000,0x0000, 0x283C,0x0000,0x0000, 0x283D,0x0000,0x0000, /* 10C24 */
0x283D,0x0000,0x0000, 0x283E,0x0000,0x0000, 0x283E,0x0000,0x0000, /* 10C27 */
0x283F,0x0000,0x0000, 0x283F,0x0000,0x0000, 0x2840,0x0000,0x0000, /* 10C2A */
0x2841,0x0000,0x0000, 0x2841,0x0000,0x0000, 0x2842,0x0000,0x0000, /* 10C2D */
0x2843,0x0000,0x0000, 0x2844,0x0000,0x0000, 0x2845,0x0000,0x0000, /* 10C30 */
0x2845,0x0000,0x0000, 0x2846,0x0000,0x0000, 0x2846,0x0000,0x0000, /* 10C33 */
0x2847,0x0000,0x0000, 0x2847,0x0000,0x0000, 0x2848,0x0000,0x0000, /* 10C36 */
0x2848,0x0000,0x0000, 0x2849,0x0000,0x0000, 0x2849,0x0000,0x0000, /* 10C39 */
0x284A,0x0000,0x0000, 0x284B,0x0000,0x0000, 0x284C,0x0000,0x0000, /* 10C3C */
0x284D,0x0000,0x0000, 0x284D,0x0000,0x0000, 0x284E,0x0000,0x0000, /* 10C3F */
0x284E,0x0000,0x0000, 0x284F,0x0000,0x0000, 0x284F,0x0000,0x0000, /* 10C42 */
0x2850,0x0000,0x0000, 0x2850,0x0000,0x0000, 0x2851,0x0000,0x0000, /* 10C45 */
0x2852,0x0000,0x0000, 0xFBC2,0x8C49,0x0000, 0xFBC2,0x8C4A,0x0000, /* 10C48 */
0xFBC2,0x8C4B,0x0000, 0xFBC2,0x8C4C,0x0000, 0xFBC2,0x8C4D,0x0000, /* 10C4B */
0xFBC2,0x8C4E,0x0000, 0xFBC2,0x8C4F,0x0000, 0xFBC2,0x8C50,0x0000, /* 10C4E */
0xFBC2,0x8C51,0x0000, 0xFBC2,0x8C52,0x0000, 0xFBC2,0x8C53,0x0000, /* 10C51 */
0xFBC2,0x8C54,0x0000, 0xFBC2,0x8C55,0x0000, 0xFBC2,0x8C56,0x0000, /* 10C54 */
0xFBC2,0x8C57,0x0000, 0xFBC2,0x8C58,0x0000, 0xFBC2,0x8C59,0x0000, /* 10C57 */
0xFBC2,0x8C5A,0x0000, 0xFBC2,0x8C5B,0x0000, 0xFBC2,0x8C5C,0x0000, /* 10C5A */
0xFBC2,0x8C5D,0x0000, 0xFBC2,0x8C5E,0x0000, 0xFBC2,0x8C5F,0x0000, /* 10C5D */
0xFBC2,0x8C60,0x0000, 0xFBC2,0x8C61,0x0000, 0xFBC2,0x8C62,0x0000, /* 10C60 */
0xFBC2,0x8C63,0x0000, 0xFBC2,0x8C64,0x0000, 0xFBC2,0x8C65,0x0000, /* 10C63 */
0xFBC2,0x8C66,0x0000, 0xFBC2,0x8C67,0x0000, 0xFBC2,0x8C68,0x0000, /* 10C66 */
0xFBC2,0x8C69,0x0000, 0xFBC2,0x8C6A,0x0000, 0xFBC2,0x8C6B,0x0000, /* 10C69 */
0xFBC2,0x8C6C,0x0000, 0xFBC2,0x8C6D,0x0000, 0xFBC2,0x8C6E,0x0000, /* 10C6C */
0xFBC2,0x8C6F,0x0000, 0xFBC2,0x8C70,0x0000, 0xFBC2,0x8C71,0x0000, /* 10C6F */
0xFBC2,0x8C72,0x0000, 0xFBC2,0x8C73,0x0000, 0xFBC2,0x8C74,0x0000, /* 10C72 */
0xFBC2,0x8C75,0x0000, 0xFBC2,0x8C76,0x0000, 0xFBC2,0x8C77,0x0000, /* 10C75 */
0xFBC2,0x8C78,0x0000, 0xFBC2,0x8C79,0x0000, 0xFBC2,0x8C7A,0x0000, /* 10C78 */
0xFBC2,0x8C7B,0x0000, 0xFBC2,0x8C7C,0x0000, 0xFBC2,0x8C7D,0x0000, /* 10C7B */
0xFBC2,0x8C7E,0x0000, 0xFBC2,0x8C7F,0x0000, 0xFBC2,0x8C80,0x0000, /* 10C7E */
0xFBC2,0x8C81,0x0000, 0xFBC2,0x8C82,0x0000, 0xFBC2,0x8C83,0x0000, /* 10C81 */
0xFBC2,0x8C84,0x0000, 0xFBC2,0x8C85,0x0000, 0xFBC2,0x8C86,0x0000, /* 10C84 */
0xFBC2,0x8C87,0x0000, 0xFBC2,0x8C88,0x0000, 0xFBC2,0x8C89,0x0000, /* 10C87 */
0xFBC2,0x8C8A,0x0000, 0xFBC2,0x8C8B,0x0000, 0xFBC2,0x8C8C,0x0000, /* 10C8A */
0xFBC2,0x8C8D,0x0000, 0xFBC2,0x8C8E,0x0000, 0xFBC2,0x8C8F,0x0000, /* 10C8D */
0xFBC2,0x8C90,0x0000, 0xFBC2,0x8C91,0x0000, 0xFBC2,0x8C92,0x0000, /* 10C90 */
0xFBC2,0x8C93,0x0000, 0xFBC2,0x8C94,0x0000, 0xFBC2,0x8C95,0x0000, /* 10C93 */
0xFBC2,0x8C96,0x0000, 0xFBC2,0x8C97,0x0000, 0xFBC2,0x8C98,0x0000, /* 10C96 */
0xFBC2,0x8C99,0x0000, 0xFBC2,0x8C9A,0x0000, 0xFBC2,0x8C9B,0x0000, /* 10C99 */
0xFBC2,0x8C9C,0x0000, 0xFBC2,0x8C9D,0x0000, 0xFBC2,0x8C9E,0x0000, /* 10C9C */
0xFBC2,0x8C9F,0x0000, 0xFBC2,0x8CA0,0x0000, 0xFBC2,0x8CA1,0x0000, /* 10C9F */
0xFBC2,0x8CA2,0x0000, 0xFBC2,0x8CA3,0x0000, 0xFBC2,0x8CA4,0x0000, /* 10CA2 */
0xFBC2,0x8CA5,0x0000, 0xFBC2,0x8CA6,0x0000, 0xFBC2,0x8CA7,0x0000, /* 10CA5 */
0xFBC2,0x8CA8,0x0000, 0xFBC2,0x8CA9,0x0000, 0xFBC2,0x8CAA,0x0000, /* 10CA8 */
0xFBC2,0x8CAB,0x0000, 0xFBC2,0x8CAC,0x0000, 0xFBC2,0x8CAD,0x0000, /* 10CAB */
0xFBC2,0x8CAE,0x0000, 0xFBC2,0x8CAF,0x0000, 0xFBC2,0x8CB0,0x0000, /* 10CAE */
0xFBC2,0x8CB1,0x0000, 0xFBC2,0x8CB2,0x0000, 0xFBC2,0x8CB3,0x0000, /* 10CB1 */
0xFBC2,0x8CB4,0x0000, 0xFBC2,0x8CB5,0x0000, 0xFBC2,0x8CB6,0x0000, /* 10CB4 */
0xFBC2,0x8CB7,0x0000, 0xFBC2,0x8CB8,0x0000, 0xFBC2,0x8CB9,0x0000, /* 10CB7 */
0xFBC2,0x8CBA,0x0000, 0xFBC2,0x8CBB,0x0000, 0xFBC2,0x8CBC,0x0000, /* 10CBA */
0xFBC2,0x8CBD,0x0000, 0xFBC2,0x8CBE,0x0000, 0xFBC2,0x8CBF,0x0000, /* 10CBD */
0xFBC2,0x8CC0,0x0000, 0xFBC2,0x8CC1,0x0000, 0xFBC2,0x8CC2,0x0000, /* 10CC0 */
0xFBC2,0x8CC3,0x0000, 0xFBC2,0x8CC4,0x0000, 0xFBC2,0x8CC5,0x0000, /* 10CC3 */
0xFBC2,0x8CC6,0x0000, 0xFBC2,0x8CC7,0x0000, 0xFBC2,0x8CC8,0x0000, /* 10CC6 */
0xFBC2,0x8CC9,0x0000, 0xFBC2,0x8CCA,0x0000, 0xFBC2,0x8CCB,0x0000, /* 10CC9 */
0xFBC2,0x8CCC,0x0000, 0xFBC2,0x8CCD,0x0000, 0xFBC2,0x8CCE,0x0000, /* 10CCC */
0xFBC2,0x8CCF,0x0000, 0xFBC2,0x8CD0,0x0000, 0xFBC2,0x8CD1,0x0000, /* 10CCF */
0xFBC2,0x8CD2,0x0000, 0xFBC2,0x8CD3,0x0000, 0xFBC2,0x8CD4,0x0000, /* 10CD2 */
0xFBC2,0x8CD5,0x0000, 0xFBC2,0x8CD6,0x0000, 0xFBC2,0x8CD7,0x0000, /* 10CD5 */
0xFBC2,0x8CD8,0x0000, 0xFBC2,0x8CD9,0x0000, 0xFBC2,0x8CDA,0x0000, /* 10CD8 */
0xFBC2,0x8CDB,0x0000, 0xFBC2,0x8CDC,0x0000, 0xFBC2,0x8CDD,0x0000, /* 10CDB */
0xFBC2,0x8CDE,0x0000, 0xFBC2,0x8CDF,0x0000, 0xFBC2,0x8CE0,0x0000, /* 10CDE */
0xFBC2,0x8CE1,0x0000, 0xFBC2,0x8CE2,0x0000, 0xFBC2,0x8CE3,0x0000, /* 10CE1 */
0xFBC2,0x8CE4,0x0000, 0xFBC2,0x8CE5,0x0000, 0xFBC2,0x8CE6,0x0000, /* 10CE4 */
0xFBC2,0x8CE7,0x0000, 0xFBC2,0x8CE8,0x0000, 0xFBC2,0x8CE9,0x0000, /* 10CE7 */
0xFBC2,0x8CEA,0x0000, 0xFBC2,0x8CEB,0x0000, 0xFBC2,0x8CEC,0x0000, /* 10CEA */
0xFBC2,0x8CED,0x0000, 0xFBC2,0x8CEE,0x0000, 0xFBC2,0x8CEF,0x0000, /* 10CED */
0xFBC2,0x8CF0,0x0000, 0xFBC2,0x8CF1,0x0000, 0xFBC2,0x8CF2,0x0000, /* 10CF0 */
0xFBC2,0x8CF3,0x0000, 0xFBC2,0x8CF4,0x0000, 0xFBC2,0x8CF5,0x0000, /* 10CF3 */
0xFBC2,0x8CF6,0x0000, 0xFBC2,0x8CF7,0x0000, 0xFBC2,0x8CF8,0x0000, /* 10CF6 */
0xFBC2,0x8CF9,0x0000, 0xFBC2,0x8CFA,0x0000, 0xFBC2,0x8CFB,0x0000, /* 10CF9 */
0xFBC2,0x8CFC,0x0000, 0xFBC2,0x8CFD,0x0000, 0xFBC2,0x8CFE,0x0000, /* 10CFC */
0xFBC2,0x8CFF,0x0000  };

uint16 uca520_p10E[]= { /* 10E00 (3 weights per char) */
0xFBC2,0x8E00,0x0000, 0xFBC2,0x8E01,0x0000, 0xFBC2,0x8E02,0x0000, /* 10E00 */
0xFBC2,0x8E03,0x0000, 0xFBC2,0x8E04,0x0000, 0xFBC2,0x8E05,0x0000, /* 10E03 */
0xFBC2,0x8E06,0x0000, 0xFBC2,0x8E07,0x0000, 0xFBC2,0x8E08,0x0000, /* 10E06 */
0xFBC2,0x8E09,0x0000, 0xFBC2,0x8E0A,0x0000, 0xFBC2,0x8E0B,0x0000, /* 10E09 */
0xFBC2,0x8E0C,0x0000, 0xFBC2,0x8E0D,0x0000, 0xFBC2,0x8E0E,0x0000, /* 10E0C */
0xFBC2,0x8E0F,0x0000, 0xFBC2,0x8E10,0x0000, 0xFBC2,0x8E11,0x0000, /* 10E0F */
0xFBC2,0x8E12,0x0000, 0xFBC2,0x8E13,0x0000, 0xFBC2,0x8E14,0x0000, /* 10E12 */
0xFBC2,0x8E15,0x0000, 0xFBC2,0x8E16,0x0000, 0xFBC2,0x8E17,0x0000, /* 10E15 */
0xFBC2,0x8E18,0x0000, 0xFBC2,0x8E19,0x0000, 0xFBC2,0x8E1A,0x0000, /* 10E18 */
0xFBC2,0x8E1B,0x0000, 0xFBC2,0x8E1C,0x0000, 0xFBC2,0x8E1D,0x0000, /* 10E1B */
0xFBC2,0x8E1E,0x0000, 0xFBC2,0x8E1F,0x0000, 0xFBC2,0x8E20,0x0000, /* 10E1E */
0xFBC2,0x8E21,0x0000, 0xFBC2,0x8E22,0x0000, 0xFBC2,0x8E23,0x0000, /* 10E21 */
0xFBC2,0x8E24,0x0000, 0xFBC2,0x8E25,0x0000, 0xFBC2,0x8E26,0x0000, /* 10E24 */
0xFBC2,0x8E27,0x0000, 0xFBC2,0x8E28,0x0000, 0xFBC2,0x8E29,0x0000, /* 10E27 */
0xFBC2,0x8E2A,0x0000, 0xFBC2,0x8E2B,0x0000, 0xFBC2,0x8E2C,0x0000, /* 10E2A */
0xFBC2,0x8E2D,0x0000, 0xFBC2,0x8E2E,0x0000, 0xFBC2,0x8E2F,0x0000, /* 10E2D */
0xFBC2,0x8E30,0x0000, 0xFBC2,0x8E31,0x0000, 0xFBC2,0x8E32,0x0000, /* 10E30 */
0xFBC2,0x8E33,0x0000, 0xFBC2,0x8E34,0x0000, 0xFBC2,0x8E35,0x0000, /* 10E33 */
0xFBC2,0x8E36,0x0000, 0xFBC2,0x8E37,0x0000, 0xFBC2,0x8E38,0x0000, /* 10E36 */
0xFBC2,0x8E39,0x0000, 0xFBC2,0x8E3A,0x0000, 0xFBC2,0x8E3B,0x0000, /* 10E39 */
0xFBC2,0x8E3C,0x0000, 0xFBC2,0x8E3D,0x0000, 0xFBC2,0x8E3E,0x0000, /* 10E3C */
0xFBC2,0x8E3F,0x0000, 0xFBC2,0x8E40,0x0000, 0xFBC2,0x8E41,0x0000, /* 10E3F */
0xFBC2,0x8E42,0x0000, 0xFBC2,0x8E43,0x0000, 0xFBC2,0x8E44,0x0000, /* 10E42 */
0xFBC2,0x8E45,0x0000, 0xFBC2,0x8E46,0x0000, 0xFBC2,0x8E47,0x0000, /* 10E45 */
0xFBC2,0x8E48,0x0000, 0xFBC2,0x8E49,0x0000, 0xFBC2,0x8E4A,0x0000, /* 10E48 */
0xFBC2,0x8E4B,0x0000, 0xFBC2,0x8E4C,0x0000, 0xFBC2,0x8E4D,0x0000, /* 10E4B */
0xFBC2,0x8E4E,0x0000, 0xFBC2,0x8E4F,0x0000, 0xFBC2,0x8E50,0x0000, /* 10E4E */
0xFBC2,0x8E51,0x0000, 0xFBC2,0x8E52,0x0000, 0xFBC2,0x8E53,0x0000, /* 10E51 */
0xFBC2,0x8E54,0x0000, 0xFBC2,0x8E55,0x0000, 0xFBC2,0x8E56,0x0000, /* 10E54 */
0xFBC2,0x8E57,0x0000, 0xFBC2,0x8E58,0x0000, 0xFBC2,0x8E59,0x0000, /* 10E57 */
0xFBC2,0x8E5A,0x0000, 0xFBC2,0x8E5B,0x0000, 0xFBC2,0x8E5C,0x0000, /* 10E5A */
0xFBC2,0x8E5D,0x0000, 0xFBC2,0x8E5E,0x0000, 0xFBC2,0x8E5F,0x0000, /* 10E5D */
0x1206,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1208,0x0000,0x0000, /* 10E60 */
0x1209,0x0000,0x0000, 0x120A,0x0000,0x0000, 0x120B,0x0000,0x0000, /* 10E63 */
0x120C,0x0000,0x0000, 0x120D,0x0000,0x0000, 0x120E,0x0000,0x0000, /* 10E66 */
0x1136,0x0000,0x0000, 0x1137,0x0000,0x0000, 0x1138,0x0000,0x0000, /* 10E69 */
0x1139,0x0000,0x0000, 0x113A,0x0000,0x0000, 0x113B,0x0000,0x0000, /* 10E6C */
0x113C,0x0000,0x0000, 0x113D,0x0000,0x0000, 0x113E,0x0000,0x0000, /* 10E6F */
0x113F,0x0000,0x0000, 0x1140,0x0000,0x0000, 0x1141,0x0000,0x0000, /* 10E72 */
0x1142,0x0000,0x0000, 0x1143,0x0000,0x0000, 0x1144,0x0000,0x0000, /* 10E75 */
0x1145,0x0000,0x0000, 0x1146,0x0000,0x0000, 0x1147,0x0000,0x0000, /* 10E78 */
0x1148,0x0000,0x0000, 0x1149,0x0000,0x0000, 0x114A,0x0000,0x0000, /* 10E7B */
0x114B,0x0000,0x0000, 0xFBC2,0x8E7F,0x0000, 0xFBC2,0x8E80,0x0000, /* 10E7E */
0xFBC2,0x8E81,0x0000, 0xFBC2,0x8E82,0x0000, 0xFBC2,0x8E83,0x0000, /* 10E81 */
0xFBC2,0x8E84,0x0000, 0xFBC2,0x8E85,0x0000, 0xFBC2,0x8E86,0x0000, /* 10E84 */
0xFBC2,0x8E87,0x0000, 0xFBC2,0x8E88,0x0000, 0xFBC2,0x8E89,0x0000, /* 10E87 */
0xFBC2,0x8E8A,0x0000, 0xFBC2,0x8E8B,0x0000, 0xFBC2,0x8E8C,0x0000, /* 10E8A */
0xFBC2,0x8E8D,0x0000, 0xFBC2,0x8E8E,0x0000, 0xFBC2,0x8E8F,0x0000, /* 10E8D */
0xFBC2,0x8E90,0x0000, 0xFBC2,0x8E91,0x0000, 0xFBC2,0x8E92,0x0000, /* 10E90 */
0xFBC2,0x8E93,0x0000, 0xFBC2,0x8E94,0x0000, 0xFBC2,0x8E95,0x0000, /* 10E93 */
0xFBC2,0x8E96,0x0000, 0xFBC2,0x8E97,0x0000, 0xFBC2,0x8E98,0x0000, /* 10E96 */
0xFBC2,0x8E99,0x0000, 0xFBC2,0x8E9A,0x0000, 0xFBC2,0x8E9B,0x0000, /* 10E99 */
0xFBC2,0x8E9C,0x0000, 0xFBC2,0x8E9D,0x0000, 0xFBC2,0x8E9E,0x0000, /* 10E9C */
0xFBC2,0x8E9F,0x0000, 0xFBC2,0x8EA0,0x0000, 0xFBC2,0x8EA1,0x0000, /* 10E9F */
0xFBC2,0x8EA2,0x0000, 0xFBC2,0x8EA3,0x0000, 0xFBC2,0x8EA4,0x0000, /* 10EA2 */
0xFBC2,0x8EA5,0x0000, 0xFBC2,0x8EA6,0x0000, 0xFBC2,0x8EA7,0x0000, /* 10EA5 */
0xFBC2,0x8EA8,0x0000, 0xFBC2,0x8EA9,0x0000, 0xFBC2,0x8EAA,0x0000, /* 10EA8 */
0xFBC2,0x8EAB,0x0000, 0xFBC2,0x8EAC,0x0000, 0xFBC2,0x8EAD,0x0000, /* 10EAB */
0xFBC2,0x8EAE,0x0000, 0xFBC2,0x8EAF,0x0000, 0xFBC2,0x8EB0,0x0000, /* 10EAE */
0xFBC2,0x8EB1,0x0000, 0xFBC2,0x8EB2,0x0000, 0xFBC2,0x8EB3,0x0000, /* 10EB1 */
0xFBC2,0x8EB4,0x0000, 0xFBC2,0x8EB5,0x0000, 0xFBC2,0x8EB6,0x0000, /* 10EB4 */
0xFBC2,0x8EB7,0x0000, 0xFBC2,0x8EB8,0x0000, 0xFBC2,0x8EB9,0x0000, /* 10EB7 */
0xFBC2,0x8EBA,0x0000, 0xFBC2,0x8EBB,0x0000, 0xFBC2,0x8EBC,0x0000, /* 10EBA */
0xFBC2,0x8EBD,0x0000, 0xFBC2,0x8EBE,0x0000, 0xFBC2,0x8EBF,0x0000, /* 10EBD */
0xFBC2,0x8EC0,0x0000, 0xFBC2,0x8EC1,0x0000, 0xFBC2,0x8EC2,0x0000, /* 10EC0 */
0xFBC2,0x8EC3,0x0000, 0xFBC2,0x8EC4,0x0000, 0xFBC2,0x8EC5,0x0000, /* 10EC3 */
0xFBC2,0x8EC6,0x0000, 0xFBC2,0x8EC7,0x0000, 0xFBC2,0x8EC8,0x0000, /* 10EC6 */
0xFBC2,0x8EC9,0x0000, 0xFBC2,0x8ECA,0x0000, 0xFBC2,0x8ECB,0x0000, /* 10EC9 */
0xFBC2,0x8ECC,0x0000, 0xFBC2,0x8ECD,0x0000, 0xFBC2,0x8ECE,0x0000, /* 10ECC */
0xFBC2,0x8ECF,0x0000, 0xFBC2,0x8ED0,0x0000, 0xFBC2,0x8ED1,0x0000, /* 10ECF */
0xFBC2,0x8ED2,0x0000, 0xFBC2,0x8ED3,0x0000, 0xFBC2,0x8ED4,0x0000, /* 10ED2 */
0xFBC2,0x8ED5,0x0000, 0xFBC2,0x8ED6,0x0000, 0xFBC2,0x8ED7,0x0000, /* 10ED5 */
0xFBC2,0x8ED8,0x0000, 0xFBC2,0x8ED9,0x0000, 0xFBC2,0x8EDA,0x0000, /* 10ED8 */
0xFBC2,0x8EDB,0x0000, 0xFBC2,0x8EDC,0x0000, 0xFBC2,0x8EDD,0x0000, /* 10EDB */
0xFBC2,0x8EDE,0x0000, 0xFBC2,0x8EDF,0x0000, 0xFBC2,0x8EE0,0x0000, /* 10EDE */
0xFBC2,0x8EE1,0x0000, 0xFBC2,0x8EE2,0x0000, 0xFBC2,0x8EE3,0x0000, /* 10EE1 */
0xFBC2,0x8EE4,0x0000, 0xFBC2,0x8EE5,0x0000, 0xFBC2,0x8EE6,0x0000, /* 10EE4 */
0xFBC2,0x8EE7,0x0000, 0xFBC2,0x8EE8,0x0000, 0xFBC2,0x8EE9,0x0000, /* 10EE7 */
0xFBC2,0x8EEA,0x0000, 0xFBC2,0x8EEB,0x0000, 0xFBC2,0x8EEC,0x0000, /* 10EEA */
0xFBC2,0x8EED,0x0000, 0xFBC2,0x8EEE,0x0000, 0xFBC2,0x8EEF,0x0000, /* 10EED */
0xFBC2,0x8EF0,0x0000, 0xFBC2,0x8EF1,0x0000, 0xFBC2,0x8EF2,0x0000, /* 10EF0 */
0xFBC2,0x8EF3,0x0000, 0xFBC2,0x8EF4,0x0000, 0xFBC2,0x8EF5,0x0000, /* 10EF3 */
0xFBC2,0x8EF6,0x0000, 0xFBC2,0x8EF7,0x0000, 0xFBC2,0x8EF8,0x0000, /* 10EF6 */
0xFBC2,0x8EF9,0x0000, 0xFBC2,0x8EFA,0x0000, 0xFBC2,0x8EFB,0x0000, /* 10EF9 */
0xFBC2,0x8EFC,0x0000, 0xFBC2,0x8EFD,0x0000, 0xFBC2,0x8EFE,0x0000, /* 10EFC */
0xFBC2,0x8EFF,0x0000  };

uint16 uca520_p110[]= { /* 11000 (3 weights per char) */
0xFBC2,0x9000,0x0000, 0xFBC2,0x9001,0x0000, 0xFBC2,0x9002,0x0000, /* 11000 */
0xFBC2,0x9003,0x0000, 0xFBC2,0x9004,0x0000, 0xFBC2,0x9005,0x0000, /* 11003 */
0xFBC2,0x9006,0x0000, 0xFBC2,0x9007,0x0000, 0xFBC2,0x9008,0x0000, /* 11006 */
0xFBC2,0x9009,0x0000, 0xFBC2,0x900A,0x0000, 0xFBC2,0x900B,0x0000, /* 11009 */
0xFBC2,0x900C,0x0000, 0xFBC2,0x900D,0x0000, 0xFBC2,0x900E,0x0000, /* 1100C */
0xFBC2,0x900F,0x0000, 0xFBC2,0x9010,0x0000, 0xFBC2,0x9011,0x0000, /* 1100F */
0xFBC2,0x9012,0x0000, 0xFBC2,0x9013,0x0000, 0xFBC2,0x9014,0x0000, /* 11012 */
0xFBC2,0x9015,0x0000, 0xFBC2,0x9016,0x0000, 0xFBC2,0x9017,0x0000, /* 11015 */
0xFBC2,0x9018,0x0000, 0xFBC2,0x9019,0x0000, 0xFBC2,0x901A,0x0000, /* 11018 */
0xFBC2,0x901B,0x0000, 0xFBC2,0x901C,0x0000, 0xFBC2,0x901D,0x0000, /* 1101B */
0xFBC2,0x901E,0x0000, 0xFBC2,0x901F,0x0000, 0xFBC2,0x9020,0x0000, /* 1101E */
0xFBC2,0x9021,0x0000, 0xFBC2,0x9022,0x0000, 0xFBC2,0x9023,0x0000, /* 11021 */
0xFBC2,0x9024,0x0000, 0xFBC2,0x9025,0x0000, 0xFBC2,0x9026,0x0000, /* 11024 */
0xFBC2,0x9027,0x0000, 0xFBC2,0x9028,0x0000, 0xFBC2,0x9029,0x0000, /* 11027 */
0xFBC2,0x902A,0x0000, 0xFBC2,0x902B,0x0000, 0xFBC2,0x902C,0x0000, /* 1102A */
0xFBC2,0x902D,0x0000, 0xFBC2,0x902E,0x0000, 0xFBC2,0x902F,0x0000, /* 1102D */
0xFBC2,0x9030,0x0000, 0xFBC2,0x9031,0x0000, 0xFBC2,0x9032,0x0000, /* 11030 */
0xFBC2,0x9033,0x0000, 0xFBC2,0x9034,0x0000, 0xFBC2,0x9035,0x0000, /* 11033 */
0xFBC2,0x9036,0x0000, 0xFBC2,0x9037,0x0000, 0xFBC2,0x9038,0x0000, /* 11036 */
0xFBC2,0x9039,0x0000, 0xFBC2,0x903A,0x0000, 0xFBC2,0x903B,0x0000, /* 11039 */
0xFBC2,0x903C,0x0000, 0xFBC2,0x903D,0x0000, 0xFBC2,0x903E,0x0000, /* 1103C */
0xFBC2,0x903F,0x0000, 0xFBC2,0x9040,0x0000, 0xFBC2,0x9041,0x0000, /* 1103F */
0xFBC2,0x9042,0x0000, 0xFBC2,0x9043,0x0000, 0xFBC2,0x9044,0x0000, /* 11042 */
0xFBC2,0x9045,0x0000, 0xFBC2,0x9046,0x0000, 0xFBC2,0x9047,0x0000, /* 11045 */
0xFBC2,0x9048,0x0000, 0xFBC2,0x9049,0x0000, 0xFBC2,0x904A,0x0000, /* 11048 */
0xFBC2,0x904B,0x0000, 0xFBC2,0x904C,0x0000, 0xFBC2,0x904D,0x0000, /* 1104B */
0xFBC2,0x904E,0x0000, 0xFBC2,0x904F,0x0000, 0xFBC2,0x9050,0x0000, /* 1104E */
0xFBC2,0x9051,0x0000, 0xFBC2,0x9052,0x0000, 0xFBC2,0x9053,0x0000, /* 11051 */
0xFBC2,0x9054,0x0000, 0xFBC2,0x9055,0x0000, 0xFBC2,0x9056,0x0000, /* 11054 */
0xFBC2,0x9057,0x0000, 0xFBC2,0x9058,0x0000, 0xFBC2,0x9059,0x0000, /* 11057 */
0xFBC2,0x905A,0x0000, 0xFBC2,0x905B,0x0000, 0xFBC2,0x905C,0x0000, /* 1105A */
0xFBC2,0x905D,0x0000, 0xFBC2,0x905E,0x0000, 0xFBC2,0x905F,0x0000, /* 1105D */
0xFBC2,0x9060,0x0000, 0xFBC2,0x9061,0x0000, 0xFBC2,0x9062,0x0000, /* 11060 */
0xFBC2,0x9063,0x0000, 0xFBC2,0x9064,0x0000, 0xFBC2,0x9065,0x0000, /* 11063 */
0xFBC2,0x9066,0x0000, 0xFBC2,0x9067,0x0000, 0xFBC2,0x9068,0x0000, /* 11066 */
0xFBC2,0x9069,0x0000, 0xFBC2,0x906A,0x0000, 0xFBC2,0x906B,0x0000, /* 11069 */
0xFBC2,0x906C,0x0000, 0xFBC2,0x906D,0x0000, 0xFBC2,0x906E,0x0000, /* 1106C */
0xFBC2,0x906F,0x0000, 0xFBC2,0x9070,0x0000, 0xFBC2,0x9071,0x0000, /* 1106F */
0xFBC2,0x9072,0x0000, 0xFBC2,0x9073,0x0000, 0xFBC2,0x9074,0x0000, /* 11072 */
0xFBC2,0x9075,0x0000, 0xFBC2,0x9076,0x0000, 0xFBC2,0x9077,0x0000, /* 11075 */
0xFBC2,0x9078,0x0000, 0xFBC2,0x9079,0x0000, 0xFBC2,0x907A,0x0000, /* 11078 */
0xFBC2,0x907B,0x0000, 0xFBC2,0x907C,0x0000, 0xFBC2,0x907D,0x0000, /* 1107B */
0xFBC2,0x907E,0x0000, 0xFBC2,0x907F,0x0000, 0x0000,0x0000,0x0000, /* 1107E */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x1EE8,0x0000,0x0000, /* 11081 */
0x1EE9,0x0000,0x0000, 0x1EEA,0x0000,0x0000, 0x1EEB,0x0000,0x0000, /* 11084 */
0x1EEC,0x0000,0x0000, 0x1EED,0x0000,0x0000, 0x1EEE,0x0000,0x0000, /* 11087 */
0x1EEF,0x0000,0x0000, 0x1EF0,0x0000,0x0000, 0x1EF1,0x0000,0x0000, /* 1108A */
0x1EF2,0x0000,0x0000, 0x1EF3,0x0000,0x0000, 0x1EF4,0x0000,0x0000, /* 1108D */
0x1EF5,0x0000,0x0000, 0x1EF6,0x0000,0x0000, 0x1EF7,0x0000,0x0000, /* 11090 */
0x1EF8,0x0000,0x0000, 0x1EF9,0x0000,0x0000, 0x1EFA,0x0000,0x0000, /* 11093 */
0x1EFB,0x0000,0x0000, 0x1EFC,0x0000,0x0000, 0x1EFD,0x0000,0x0000, /* 11096 */
0x1EFE,0x0000,0x0000, 0x1EFE,0x0000,0x0000, 0x1EFF,0x0000,0x0000, /* 11099 */
0x1EFF,0x0000,0x0000, 0x1F00,0x0000,0x0000, 0x1F01,0x0000,0x0000, /* 1109C */
0x1F02,0x0000,0x0000, 0x1F03,0x0000,0x0000, 0x1F04,0x0000,0x0000, /* 1109F */
0x1F05,0x0000,0x0000, 0x1F06,0x0000,0x0000, 0x1F07,0x0000,0x0000, /* 110A2 */
0x1F08,0x0000,0x0000, 0x1F09,0x0000,0x0000, 0x1F0A,0x0000,0x0000, /* 110A5 */
0x1F0B,0x0000,0x0000, 0x1F0C,0x0000,0x0000, 0x1F0D,0x0000,0x0000, /* 110A8 */
0x1F08,0x0000,0x0000, 0x1F0E,0x0000,0x0000, 0x1F0F,0x0000,0x0000, /* 110AB */
0x1F10,0x0000,0x0000, 0x1F11,0x0000,0x0000, 0x1F12,0x0000,0x0000, /* 110AE */
0x1F13,0x0000,0x0000, 0x1F14,0x0000,0x0000, 0x1F15,0x0000,0x0000, /* 110B1 */
0x1F16,0x0000,0x0000, 0x1F17,0x0000,0x0000, 0x1F18,0x0000,0x0000, /* 110B4 */
0x1F19,0x0000,0x0000, 0x1F1A,0x0000,0x0000, 0x1F1B,0x0000,0x0000, /* 110B7 */
0x0000,0x0000,0x0000, 0x03E7,0x0000,0x0000, 0x03E8,0x0000,0x0000, /* 110BA */
0x0000,0x0000,0x0000, 0x02D1,0x0000,0x0000, 0x02D2,0x0000,0x0000, /* 110BD */
0x02B1,0x0000,0x0000, 0x02B2,0x0000,0x0000, 0xFBC2,0x90C2,0x0000, /* 110C0 */
0xFBC2,0x90C3,0x0000, 0xFBC2,0x90C4,0x0000, 0xFBC2,0x90C5,0x0000, /* 110C3 */
0xFBC2,0x90C6,0x0000, 0xFBC2,0x90C7,0x0000, 0xFBC2,0x90C8,0x0000, /* 110C6 */
0xFBC2,0x90C9,0x0000, 0xFBC2,0x90CA,0x0000, 0xFBC2,0x90CB,0x0000, /* 110C9 */
0xFBC2,0x90CC,0x0000, 0xFBC2,0x90CD,0x0000, 0xFBC2,0x90CE,0x0000, /* 110CC */
0xFBC2,0x90CF,0x0000, 0xFBC2,0x90D0,0x0000, 0xFBC2,0x90D1,0x0000, /* 110CF */
0xFBC2,0x90D2,0x0000, 0xFBC2,0x90D3,0x0000, 0xFBC2,0x90D4,0x0000, /* 110D2 */
0xFBC2,0x90D5,0x0000, 0xFBC2,0x90D6,0x0000, 0xFBC2,0x90D7,0x0000, /* 110D5 */
0xFBC2,0x90D8,0x0000, 0xFBC2,0x90D9,0x0000, 0xFBC2,0x90DA,0x0000, /* 110D8 */
0xFBC2,0x90DB,0x0000, 0xFBC2,0x90DC,0x0000, 0xFBC2,0x90DD,0x0000, /* 110DB */
0xFBC2,0x90DE,0x0000, 0xFBC2,0x90DF,0x0000, 0xFBC2,0x90E0,0x0000, /* 110DE */
0xFBC2,0x90E1,0x0000, 0xFBC2,0x90E2,0x0000, 0xFBC2,0x90E3,0x0000, /* 110E1 */
0xFBC2,0x90E4,0x0000, 0xFBC2,0x90E5,0x0000, 0xFBC2,0x90E6,0x0000, /* 110E4 */
0xFBC2,0x90E7,0x0000, 0xFBC2,0x90E8,0x0000, 0xFBC2,0x90E9,0x0000, /* 110E7 */
0xFBC2,0x90EA,0x0000, 0xFBC2,0x90EB,0x0000, 0xFBC2,0x90EC,0x0000, /* 110EA */
0xFBC2,0x90ED,0x0000, 0xFBC2,0x90EE,0x0000, 0xFBC2,0x90EF,0x0000, /* 110ED */
0xFBC2,0x90F0,0x0000, 0xFBC2,0x90F1,0x0000, 0xFBC2,0x90F2,0x0000, /* 110F0 */
0xFBC2,0x90F3,0x0000, 0xFBC2,0x90F4,0x0000, 0xFBC2,0x90F5,0x0000, /* 110F3 */
0xFBC2,0x90F6,0x0000, 0xFBC2,0x90F7,0x0000, 0xFBC2,0x90F8,0x0000, /* 110F6 */
0xFBC2,0x90F9,0x0000, 0xFBC2,0x90FA,0x0000, 0xFBC2,0x90FB,0x0000, /* 110F9 */
0xFBC2,0x90FC,0x0000, 0xFBC2,0x90FD,0x0000, 0xFBC2,0x90FE,0x0000, /* 110FC */
0xFBC2,0x90FF,0x0000  };

uint16 uca520_p120[]= { /* 12000 (2 weights per char) */
0x332D,0x0000, 0x332E,0x0000, 0x332F,0x0000, 0x3330,0x0000, /* 12000 */
0x3331,0x0000, 0x3332,0x0000, 0x3333,0x0000, 0x3334,0x0000, /* 12004 */
0x3335,0x0000, 0x3336,0x0000, 0x3337,0x0000, 0x3338,0x0000, /* 12008 */
0x3339,0x0000, 0x333A,0x0000, 0x333B,0x0000, 0x333C,0x0000, /* 1200C */
0x333D,0x0000, 0x333E,0x0000, 0x333F,0x0000, 0x3340,0x0000, /* 12010 */
0x3341,0x0000, 0x3342,0x0000, 0x3343,0x0000, 0x3344,0x0000, /* 12014 */
0x3345,0x0000, 0x3346,0x0000, 0x3347,0x0000, 0x3348,0x0000, /* 12018 */
0x3349,0x0000, 0x334A,0x0000, 0x334B,0x0000, 0x334C,0x0000, /* 1201C */
0x334D,0x0000, 0x334E,0x0000, 0x334F,0x0000, 0x3350,0x0000, /* 12020 */
0x3351,0x0000, 0x3352,0x0000, 0x3353,0x0000, 0x3354,0x0000, /* 12024 */
0x3355,0x0000, 0x3356,0x0000, 0x3357,0x0000, 0x3358,0x0000, /* 12028 */
0x3359,0x0000, 0x335A,0x0000, 0x335B,0x0000, 0x335C,0x0000, /* 1202C */
0x335D,0x0000, 0x335E,0x0000, 0x335F,0x0000, 0x3360,0x0000, /* 12030 */
0x3361,0x0000, 0x3362,0x0000, 0x3363,0x0000, 0x3364,0x0000, /* 12034 */
0x3365,0x0000, 0x3366,0x0000, 0x3367,0x0000, 0x3368,0x0000, /* 12038 */
0x3369,0x0000, 0x336A,0x0000, 0x336B,0x0000, 0x336C,0x0000, /* 1203C */
0x336D,0x0000, 0x336E,0x0000, 0x336F,0x0000, 0x3370,0x0000, /* 12040 */
0x3371,0x0000, 0x3372,0x0000, 0x3373,0x0000, 0x3374,0x0000, /* 12044 */
0x3375,0x0000, 0x3376,0x0000, 0x3377,0x0000, 0x3378,0x0000, /* 12048 */
0x3379,0x0000, 0x337A,0x0000, 0x337B,0x0000, 0x337C,0x0000, /* 1204C */
0x337D,0x0000, 0x337E,0x0000, 0x337F,0x0000, 0x3380,0x0000, /* 12050 */
0x3381,0x0000, 0x3382,0x0000, 0x3383,0x0000, 0x3384,0x0000, /* 12054 */
0x3385,0x0000, 0x3386,0x0000, 0x3387,0x0000, 0x3388,0x0000, /* 12058 */
0x3389,0x0000, 0x338A,0x0000, 