// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv64 -target-feature +xtheadbb -emit-llvm %s -o - \
// RUN:     | FileCheck %s  -check-prefix=RV64XTHEADBB

// RV64XTHEADBB-LABEL: @clz_32(
// RV64XTHEADBB-NEXT:  entry:
// RV64XTHEADBB-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// RV64XTHEADBB-NEXT:    store i32 [[A:%.*]], ptr [[A_ADDR]], align 4
// RV64XTHEADBB-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// RV64XTHEADBB-NEXT:    [[TMP1:%.*]] = call i32 @llvm.ctlz.i32(i32 [[TMP0]], i1 false)
// RV64XTHEADBB-NEXT:    ret i32 [[TMP1]]
//
int clz_32(int a) {
  return __builtin_riscv_clz_32(a);
}

// RV64XTHEADBB-LABEL: @clo_32(
// RV64XTHEADBB-NEXT:  entry:
// RV64XTHEADBB-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// RV64XTHEADBB-NEXT:    store i32 [[A:%.*]], ptr [[A_ADDR]], align 4
// RV64XTHEADBB-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// RV64XTHEADBB-NEXT:    [[NOT:%.*]] = xor i32 [[TMP0]], -1
// RV64XTHEADBB-NEXT:    [[TMP1:%.*]] = call i32 @llvm.ctlz.i32(i32 [[NOT]], i1 false)
// RV64XTHEADBB-NEXT:    ret i32 [[TMP1]]
//
int clo_32(int a) {
  return __builtin_riscv_clz_32(~a);
}

// RV64XTHEADBB-LABEL: @clz_64(
// RV64XTHEADBB-NEXT:  entry:
// RV64XTHEADBB-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// RV64XTHEADBB-NEXT:    store i64 [[A:%.*]], ptr [[A_ADDR]], align 8
// RV64XTHEADBB-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A_ADDR]], align 8
// RV64XTHEADBB-NEXT:    [[TMP1:%.*]] = call i64 @llvm.ctlz.i64(i64 [[TMP0]], i1 false)
// RV64XTHEADBB-NEXT:    ret i64 [[TMP1]]
//
long clz_64(long a) {
  return __builtin_riscv_clz_64(a);
}

// RV64XTHEADBB-LABEL: @clo_64(
// RV64XTHEADBB-NEXT:  entry:
// RV64XTHEADBB-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// RV64XTHEADBB-NEXT:    store i64 [[A:%.*]], ptr [[A_ADDR]], align 8
// RV64XTHEADBB-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A_ADDR]], align 8
// RV64XTHEADBB-NEXT:    [[NOT:%.*]] = xor i64 [[TMP0]], -1
// RV64XTHEADBB-NEXT:    [[TMP1:%.*]] = call i64 @llvm.ctlz.i64(i64 [[NOT]], i1 false)
// RV64XTHEADBB-NEXT:    ret i64 [[TMP1]]
//
long clo_64(long a) {
  return __builtin_riscv_clz_64(~a);
}
