# Testing Workloads

Workloads based on packages in `artifacts` can be installed, and used for testing.

- This is done by installing a specified SDK version (`$(SdkVersionForWorkloadTesting)`) in `artifacts/bin/dotnet-workload`.
- Then the manifest for the workload in `@(WorkloadIdForTesting)` is installed
    - Then workload packs are installed
    - packs, or manifests not generated by `runtime`, are restored from nuget

- The SDK is installed by `ProvisionSdkForWorkloadTesting` target
- and the workload is installed by `InstallWorkloadUsingArtifacts` target, using the `InstallWorkloadFromArtifacts` task

- `@(WorkloadIdForTesting)`:

Example for wasm:
```xml
    <WorkloadIdForTesting Include="wasm-tools"
                          Name="microsoft.net.workload.mono.toolchain"
                          ManifestName="Microsoft.NET.Workload.Mono.ToolChain"
                          Version="$(PackageVersion)"
                          VersionBand="$(SdkBandVersion)" />
```

- Currently, this is used only by `src/tests/BuildWasmApps/Wasm.Build.Tests`

## Limitations:

- The cross compiler package is built manually from the `InstallWorkloadUsingArtifacts` target
