// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.Arm
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["Abs.Vector64.Int16"] = Abs_Vector64_Int16,
                ["Abs.Vector64.Int32"] = Abs_Vector64_Int32,
                ["Abs.Vector64.SByte"] = Abs_Vector64_SByte,
                ["Abs.Vector64.Single"] = Abs_Vector64_Single,
                ["Abs.Vector128.Int16"] = Abs_Vector128_Int16,
                ["Abs.Vector128.Int32"] = Abs_Vector128_Int32,
                ["Abs.Vector128.SByte"] = Abs_Vector128_SByte,
                ["Abs.Vector128.Single"] = Abs_Vector128_Single,
                ["AbsSaturate.Vector64.Int16"] = AbsSaturate_Vector64_Int16,
                ["AbsSaturate.Vector64.Int32"] = AbsSaturate_Vector64_Int32,
                ["AbsSaturate.Vector64.SByte"] = AbsSaturate_Vector64_SByte,
                ["AbsSaturate.Vector128.Int16"] = AbsSaturate_Vector128_Int16,
                ["AbsSaturate.Vector128.Int32"] = AbsSaturate_Vector128_Int32,
                ["AbsSaturate.Vector128.SByte"] = AbsSaturate_Vector128_SByte,
                ["AbsScalar.Vector64.Double"] = AbsScalar_Vector64_Double,
                ["AbsScalar.Vector64.Single"] = AbsScalar_Vector64_Single,
                ["AbsoluteCompareGreaterThan.Vector64.Single"] = AbsoluteCompareGreaterThan_Vector64_Single,
                ["AbsoluteCompareGreaterThan.Vector128.Single"] = AbsoluteCompareGreaterThan_Vector128_Single,
                ["AbsoluteCompareGreaterThanOrEqual.Vector64.Single"] = AbsoluteCompareGreaterThanOrEqual_Vector64_Single,
                ["AbsoluteCompareGreaterThanOrEqual.Vector128.Single"] = AbsoluteCompareGreaterThanOrEqual_Vector128_Single,
                ["AbsoluteCompareLessThan.Vector64.Single"] = AbsoluteCompareLessThan_Vector64_Single,
                ["AbsoluteCompareLessThan.Vector128.Single"] = AbsoluteCompareLessThan_Vector128_Single,
                ["AbsoluteCompareLessThanOrEqual.Vector64.Single"] = AbsoluteCompareLessThanOrEqual_Vector64_Single,
                ["AbsoluteCompareLessThanOrEqual.Vector128.Single"] = AbsoluteCompareLessThanOrEqual_Vector128_Single,
                ["AbsoluteDifference.Vector64.Byte"] = AbsoluteDifference_Vector64_Byte,
                ["AbsoluteDifference.Vector64.Int16"] = AbsoluteDifference_Vector64_Int16,
                ["AbsoluteDifference.Vector64.Int32"] = AbsoluteDifference_Vector64_Int32,
                ["AbsoluteDifference.Vector64.SByte"] = AbsoluteDifference_Vector64_SByte,
                ["AbsoluteDifference.Vector64.Single"] = AbsoluteDifference_Vector64_Single,
                ["AbsoluteDifference.Vector64.UInt16"] = AbsoluteDifference_Vector64_UInt16,
                ["AbsoluteDifference.Vector64.UInt32"] = AbsoluteDifference_Vector64_UInt32,
                ["AbsoluteDifference.Vector128.Byte"] = AbsoluteDifference_Vector128_Byte,
                ["AbsoluteDifference.Vector128.Int16"] = AbsoluteDifference_Vector128_Int16,
                ["AbsoluteDifference.Vector128.Int32"] = AbsoluteDifference_Vector128_Int32,
                ["AbsoluteDifference.Vector128.SByte"] = AbsoluteDifference_Vector128_SByte,
                ["AbsoluteDifference.Vector128.Single"] = AbsoluteDifference_Vector128_Single,
                ["AbsoluteDifference.Vector128.UInt16"] = AbsoluteDifference_Vector128_UInt16,
                ["AbsoluteDifference.Vector128.UInt32"] = AbsoluteDifference_Vector128_UInt32,
                ["AbsoluteDifferenceAdd.Vector64.Byte"] = AbsoluteDifferenceAdd_Vector64_Byte,
                ["AbsoluteDifferenceAdd.Vector64.Int16"] = AbsoluteDifferenceAdd_Vector64_Int16,
                ["AbsoluteDifferenceAdd.Vector64.Int32"] = AbsoluteDifferenceAdd_Vector64_Int32,
                ["AbsoluteDifferenceAdd.Vector64.SByte"] = AbsoluteDifferenceAdd_Vector64_SByte,
                ["AbsoluteDifferenceAdd.Vector64.UInt16"] = AbsoluteDifferenceAdd_Vector64_UInt16,
                ["AbsoluteDifferenceAdd.Vector64.UInt32"] = AbsoluteDifferenceAdd_Vector64_UInt32,
                ["AbsoluteDifferenceAdd.Vector128.Byte"] = AbsoluteDifferenceAdd_Vector128_Byte,
                ["AbsoluteDifferenceAdd.Vector128.Int16"] = AbsoluteDifferenceAdd_Vector128_Int16,
                ["AbsoluteDifferenceAdd.Vector128.Int32"] = AbsoluteDifferenceAdd_Vector128_Int32,
                ["AbsoluteDifferenceAdd.Vector128.SByte"] = AbsoluteDifferenceAdd_Vector128_SByte,
                ["AbsoluteDifferenceAdd.Vector128.UInt16"] = AbsoluteDifferenceAdd_Vector128_UInt16,
                ["AbsoluteDifferenceAdd.Vector128.UInt32"] = AbsoluteDifferenceAdd_Vector128_UInt32,
                ["AbsoluteDifferenceWideningLower.Vector64.Byte"] = AbsoluteDifferenceWideningLower_Vector64_Byte,
                ["AbsoluteDifferenceWideningLower.Vector64.Int16"] = AbsoluteDifferenceWideningLower_Vector64_Int16,
                ["AbsoluteDifferenceWideningLower.Vector64.Int32"] = AbsoluteDifferenceWideningLower_Vector64_Int32,
                ["AbsoluteDifferenceWideningLower.Vector64.SByte"] = AbsoluteDifferenceWideningLower_Vector64_SByte,
                ["AbsoluteDifferenceWideningLower.Vector64.UInt16"] = AbsoluteDifferenceWideningLower_Vector64_UInt16,
                ["AbsoluteDifferenceWideningLower.Vector64.UInt32"] = AbsoluteDifferenceWideningLower_Vector64_UInt32,
                ["AbsoluteDifferenceWideningLowerAndAdd.Vector64.Byte"] = AbsoluteDifferenceWideningLowerAndAdd_Vector64_Byte,
                ["AbsoluteDifferenceWideningLowerAndAdd.Vector64.Int16"] = AbsoluteDifferenceWideningLowerAndAdd_Vector64_Int16,
                ["AbsoluteDifferenceWideningLowerAndAdd.Vector64.Int32"] = AbsoluteDifferenceWideningLowerAndAdd_Vector64_Int32,
                ["AbsoluteDifferenceWideningLowerAndAdd.Vector64.SByte"] = AbsoluteDifferenceWideningLowerAndAdd_Vector64_SByte,
                ["AbsoluteDifferenceWideningLowerAndAdd.Vector64.UInt16"] = AbsoluteDifferenceWideningLowerAndAdd_Vector64_UInt16,
                ["AbsoluteDifferenceWideningLowerAndAdd.Vector64.UInt32"] = AbsoluteDifferenceWideningLowerAndAdd_Vector64_UInt32,
                ["AbsoluteDifferenceWideningUpper.Vector128.Byte"] = AbsoluteDifferenceWideningUpper_Vector128_Byte,
                ["AbsoluteDifferenceWideningUpper.Vector128.Int16"] = AbsoluteDifferenceWideningUpper_Vector128_Int16,
                ["AbsoluteDifferenceWideningUpper.Vector128.Int32"] = AbsoluteDifferenceWideningUpper_Vector128_Int32,
                ["AbsoluteDifferenceWideningUpper.Vector128.SByte"] = AbsoluteDifferenceWideningUpper_Vector128_SByte,
                ["AbsoluteDifferenceWideningUpper.Vector128.UInt16"] = AbsoluteDifferenceWideningUpper_Vector128_UInt16,
                ["AbsoluteDifferenceWideningUpper.Vector128.UInt32"] = AbsoluteDifferenceWideningUpper_Vector128_UInt32,
                ["AbsoluteDifferenceWideningUpperAndAdd.Vector128.Byte"] = AbsoluteDifferenceWideningUpperAndAdd_Vector128_Byte,
                ["AbsoluteDifferenceWideningUpperAndAdd.Vector128.Int16"] = AbsoluteDifferenceWideningUpperAndAdd_Vector128_Int16,
                ["AbsoluteDifferenceWideningUpperAndAdd.Vector128.Int32"] = AbsoluteDifferenceWideningUpperAndAdd_Vector128_Int32,
                ["AbsoluteDifferenceWideningUpperAndAdd.Vector128.SByte"] = AbsoluteDifferenceWideningUpperAndAdd_Vector128_SByte,
                ["AbsoluteDifferenceWideningUpperAndAdd.Vector128.UInt16"] = AbsoluteDifferenceWideningUpperAndAdd_Vector128_UInt16,
                ["AbsoluteDifferenceWideningUpperAndAdd.Vector128.UInt32"] = AbsoluteDifferenceWideningUpperAndAdd_Vector128_UInt32,
                ["Add.Vector64.Byte"] = Add_Vector64_Byte,
                ["Add.Vector64.Int16"] = Add_Vector64_Int16,
                ["Add.Vector64.Int32"] = Add_Vector64_Int32,
                ["Add.Vector64.SByte"] = Add_Vector64_SByte,
                ["Add.Vector64.Single"] = Add_Vector64_Single,
                ["Add.Vector64.UInt16"] = Add_Vector64_UInt16,
                ["Add.Vector64.UInt32"] = Add_Vector64_UInt32,
                ["Add.Vector128.Byte"] = Add_Vector128_Byte,
                ["Add.Vector128.Int16"] = Add_Vector128_Int16,
                ["Add.Vector128.Int32"] = Add_Vector128_Int32,
                ["Add.Vector128.Int64"] = Add_Vector128_Int64,
                ["Add.Vector128.SByte"] = Add_Vector128_SByte,
                ["Add.Vector128.Single"] = Add_Vector128_Single,
                ["Add.Vector128.UInt16"] = Add_Vector128_UInt16,
                ["Add.Vector128.UInt32"] = Add_Vector128_UInt32,
                ["Add.Vector128.UInt64"] = Add_Vector128_UInt64,
                ["AddHighNarrowingLower.Vector64.Byte"] = AddHighNarrowingLower_Vector64_Byte,
                ["AddHighNarrowingLower.Vector64.Int16"] = AddHighNarrowingLower_Vector64_Int16,
                ["AddHighNarrowingLower.Vector64.Int32"] = AddHighNarrowingLower_Vector64_Int32,
                ["AddHighNarrowingLower.Vector64.SByte"] = AddHighNarrowingLower_Vector64_SByte,
                ["AddHighNarrowingLower.Vector64.UInt16"] = AddHighNarrowingLower_Vector64_UInt16,
                ["AddHighNarrowingLower.Vector64.UInt32"] = AddHighNarrowingLower_Vector64_UInt32,
                ["AddHighNarrowingUpper.Vector128.Byte"] = AddHighNarrowingUpper_Vector128_Byte,
                ["AddHighNarrowingUpper.Vector128.Int16"] = AddHighNarrowingUpper_Vector128_Int16,
                ["AddHighNarrowingUpper.Vector128.Int32"] = AddHighNarrowingUpper_Vector128_Int32,
                ["AddHighNarrowingUpper.Vector128.SByte"] = AddHighNarrowingUpper_Vector128_SByte,
            };
        }
    }
}
