// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.Arm
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["AddHighNarrowingUpper.Vector128.UInt16"] = AddHighNarrowingUpper_Vector128_UInt16,
                ["AddHighNarrowingUpper.Vector128.UInt32"] = AddHighNarrowingUpper_Vector128_UInt32,
                ["AddPairwise.Vector64.Byte"] = AddPairwise_Vector64_Byte,
                ["AddPairwise.Vector64.Int16"] = AddPairwise_Vector64_Int16,
                ["AddPairwise.Vector64.Int32"] = AddPairwise_Vector64_Int32,
                ["AddPairwise.Vector64.SByte"] = AddPairwise_Vector64_SByte,
                ["AddPairwise.Vector64.Single"] = AddPairwise_Vector64_Single,
                ["AddPairwise.Vector64.UInt16"] = AddPairwise_Vector64_UInt16,
                ["AddPairwise.Vector64.UInt32"] = AddPairwise_Vector64_UInt32,
                ["AddPairwiseWidening.Vector64.Byte"] = AddPairwiseWidening_Vector64_Byte,
                ["AddPairwiseWidening.Vector64.Int16"] = AddPairwiseWidening_Vector64_Int16,
                ["AddPairwiseWidening.Vector64.SByte"] = AddPairwiseWidening_Vector64_SByte,
                ["AddPairwiseWidening.Vector64.UInt16"] = AddPairwiseWidening_Vector64_UInt16,
                ["AddPairwiseWidening.Vector128.Byte"] = AddPairwiseWidening_Vector128_Byte,
                ["AddPairwiseWidening.Vector128.Int16"] = AddPairwiseWidening_Vector128_Int16,
                ["AddPairwiseWidening.Vector128.Int32"] = AddPairwiseWidening_Vector128_Int32,
                ["AddPairwiseWidening.Vector128.SByte"] = AddPairwiseWidening_Vector128_SByte,
                ["AddPairwiseWidening.Vector128.UInt16"] = AddPairwiseWidening_Vector128_UInt16,
                ["AddPairwiseWidening.Vector128.UInt32"] = AddPairwiseWidening_Vector128_UInt32,
                ["AddPairwiseWideningAndAdd.Vector64.Byte"] = AddPairwiseWideningAndAdd_Vector64_Byte,
                ["AddPairwiseWideningAndAdd.Vector64.Int16"] = AddPairwiseWideningAndAdd_Vector64_Int16,
                ["AddPairwiseWideningAndAdd.Vector64.SByte"] = AddPairwiseWideningAndAdd_Vector64_SByte,
                ["AddPairwiseWideningAndAdd.Vector64.UInt16"] = AddPairwiseWideningAndAdd_Vector64_UInt16,
                ["AddPairwiseWideningAndAdd.Vector128.Byte"] = AddPairwiseWideningAndAdd_Vector128_Byte,
                ["AddPairwiseWideningAndAdd.Vector128.Int16"] = AddPairwiseWideningAndAdd_Vector128_Int16,
                ["AddPairwiseWideningAndAdd.Vector128.Int32"] = AddPairwiseWideningAndAdd_Vector128_Int32,
                ["AddPairwiseWideningAndAdd.Vector128.SByte"] = AddPairwiseWideningAndAdd_Vector128_SByte,
                ["AddPairwiseWideningAndAdd.Vector128.UInt16"] = AddPairwiseWideningAndAdd_Vector128_UInt16,
                ["AddPairwiseWideningAndAdd.Vector128.UInt32"] = AddPairwiseWideningAndAdd_Vector128_UInt32,
                ["AddPairwiseWideningAndAddScalar.Vector64.Int32"] = AddPairwiseWideningAndAddScalar_Vector64_Int32,
                ["AddPairwiseWideningAndAddScalar.Vector64.UInt32"] = AddPairwiseWideningAndAddScalar_Vector64_UInt32,
                ["AddPairwiseWideningScalar.Vector64.Int32"] = AddPairwiseWideningScalar_Vector64_Int32,
                ["AddPairwiseWideningScalar.Vector64.UInt32"] = AddPairwiseWideningScalar_Vector64_UInt32,
                ["AddRoundedHighNarrowingLower.Vector64.Byte"] = AddRoundedHighNarrowingLower_Vector64_Byte,
                ["AddRoundedHighNarrowingLower.Vector64.Int16"] = AddRoundedHighNarrowingLower_Vector64_Int16,
                ["AddRoundedHighNarrowingLower.Vector64.Int32"] = AddRoundedHighNarrowingLower_Vector64_Int32,
                ["AddRoundedHighNarrowingLower.Vector64.SByte"] = AddRoundedHighNarrowingLower_Vector64_SByte,
                ["AddRoundedHighNarrowingLower.Vector64.UInt16"] = AddRoundedHighNarrowingLower_Vector64_UInt16,
                ["AddRoundedHighNarrowingLower.Vector64.UInt32"] = AddRoundedHighNarrowingLower_Vector64_UInt32,
                ["AddRoundedHighNarrowingUpper.Vector128.Byte"] = AddRoundedHighNarrowingUpper_Vector128_Byte,
                ["AddRoundedHighNarrowingUpper.Vector128.Int16"] = AddRoundedHighNarrowingUpper_Vector128_Int16,
                ["AddRoundedHighNarrowingUpper.Vector128.Int32"] = AddRoundedHighNarrowingUpper_Vector128_Int32,
                ["AddRoundedHighNarrowingUpper.Vector128.SByte"] = AddRoundedHighNarrowingUpper_Vector128_SByte,
                ["AddRoundedHighNarrowingUpper.Vector128.UInt16"] = AddRoundedHighNarrowingUpper_Vector128_UInt16,
                ["AddRoundedHighNarrowingUpper.Vector128.UInt32"] = AddRoundedHighNarrowingUpper_Vector128_UInt32,
                ["AddSaturate.Vector64.Byte.Vector64.Byte"] = AddSaturate_Vector64_Byte_Vector64_Byte,
                ["AddSaturate.Vector64.Int16.Vector64.Int16"] = AddSaturate_Vector64_Int16_Vector64_Int16,
                ["AddSaturate.Vector64.Int32.Vector64.Int32"] = AddSaturate_Vector64_Int32_Vector64_Int32,
                ["AddSaturate.Vector64.SByte.Vector64.SByte"] = AddSaturate_Vector64_SByte_Vector64_SByte,
                ["AddSaturate.Vector64.UInt16.Vector64.UInt16"] = AddSaturate_Vector64_UInt16_Vector64_UInt16,
                ["AddSaturate.Vector64.UInt32.Vector64.UInt32"] = AddSaturate_Vector64_UInt32_Vector64_UInt32,
                ["AddSaturate.Vector128.Byte.Vector128.Byte"] = AddSaturate_Vector128_Byte_Vector128_Byte,
                ["AddSaturate.Vector128.Int16.Vector128.Int16"] = AddSaturate_Vector128_Int16_Vector128_Int16,
                ["AddSaturate.Vector128.Int32.Vector128.Int32"] = AddSaturate_Vector128_Int32_Vector128_Int32,
                ["AddSaturate.Vector128.Int64.Vector128.Int64"] = AddSaturate_Vector128_Int64_Vector128_Int64,
                ["AddSaturate.Vector128.SByte.Vector128.SByte"] = AddSaturate_Vector128_SByte_Vector128_SByte,
                ["AddSaturate.Vector128.UInt16.Vector128.UInt16"] = AddSaturate_Vector128_UInt16_Vector128_UInt16,
                ["AddSaturate.Vector128.UInt32.Vector128.UInt32"] = AddSaturate_Vector128_UInt32_Vector128_UInt32,
                ["AddSaturate.Vector128.UInt64.Vector128.UInt64"] = AddSaturate_Vector128_UInt64_Vector128_UInt64,
                ["AddSaturateScalar.Vector64.Int64.Vector64.Int64"] = AddSaturateScalar_Vector64_Int64_Vector64_Int64,
                ["AddSaturateScalar.Vector64.UInt64.Vector64.UInt64"] = AddSaturateScalar_Vector64_UInt64_Vector64_UInt64,
                ["AddScalar.Vector64.Double"] = AddScalar_Vector64_Double,
                ["AddScalar.Vector64.Int64"] = AddScalar_Vector64_Int64,
                ["AddScalar.Vector64.Single"] = AddScalar_Vector64_Single,
                ["AddScalar.Vector64.UInt64"] = AddScalar_Vector64_UInt64,
                ["AddWideningLower.Vector64.Byte"] = AddWideningLower_Vector64_Byte,
                ["AddWideningLower.Vector64.Int16"] = AddWideningLower_Vector64_Int16,
                ["AddWideningLower.Vector64.Int32"] = AddWideningLower_Vector64_Int32,
                ["AddWideningLower.Vector64.SByte"] = AddWideningLower_Vector64_SByte,
                ["AddWideningLower.Vector64.UInt16"] = AddWideningLower_Vector64_UInt16,
                ["AddWideningLower.Vector64.UInt32"] = AddWideningLower_Vector64_UInt32,
                ["AddWideningLower.Vector128.Int16"] = AddWideningLower_Vector128_Int16,
                ["AddWideningLower.Vector128.Int32"] = AddWideningLower_Vector128_Int32,
                ["AddWideningLower.Vector128.Int64"] = AddWideningLower_Vector128_Int64,
                ["AddWideningLower.Vector128.UInt16"] = AddWideningLower_Vector128_UInt16,
                ["AddWideningLower.Vector128.UInt32"] = AddWideningLower_Vector128_UInt32,
                ["AddWideningLower.Vector128.UInt64"] = AddWideningLower_Vector128_UInt64,
                ["AddWideningUpper.Vector128.Byte.Vector128.Byte"] = AddWideningUpper_Vector128_Byte_Vector128_Byte,
                ["AddWideningUpper.Vector128.Int16.Vector128.Int16"] = AddWideningUpper_Vector128_Int16_Vector128_Int16,
                ["AddWideningUpper.Vector128.Int16.Vector128.SByte"] = AddWideningUpper_Vector128_Int16_Vector128_SByte,
                ["AddWideningUpper.Vector128.Int32.Vector128.Int16"] = AddWideningUpper_Vector128_Int32_Vector128_Int16,
                ["AddWideningUpper.Vector128.Int32.Vector128.Int32"] = AddWideningUpper_Vector128_Int32_Vector128_Int32,
                ["AddWideningUpper.Vector128.Int64.Vector128.Int32"] = AddWideningUpper_Vector128_Int64_Vector128_Int32,
                ["AddWideningUpper.Vector128.SByte.Vector128.SByte"] = AddWideningUpper_Vector128_SByte_Vector128_SByte,
                ["AddWideningUpper.Vector128.UInt16.Vector128.Byte"] = AddWideningUpper_Vector128_UInt16_Vector128_Byte,
                ["AddWideningUpper.Vector128.UInt16.Vector128.UInt16"] = AddWideningUpper_Vector128_UInt16_Vector128_UInt16,
                ["AddWideningUpper.Vector128.UInt32.Vector128.UInt16"] = AddWideningUpper_Vector128_UInt32_Vector128_UInt16,
                ["AddWideningUpper.Vector128.UInt32.Vector128.UInt32"] = AddWideningUpper_Vector128_UInt32_Vector128_UInt32,
                ["AddWideningUpper.Vector128.UInt64.Vector128.UInt32"] = AddWideningUpper_Vector128_UInt64_Vector128_UInt32,
                ["And.Vector64.Byte"] = And_Vector64_Byte,
                ["And.Vector64.Double"] = And_Vector64_Double,
                ["And.Vector64.Int16"] = And_Vector64_Int16,
                ["And.Vector64.Int32"] = And_Vector64_Int32,
                ["And.Vector64.Int64"] = And_Vector64_Int64,
                ["And.Vector64.SByte"] = And_Vector64_SByte,
                ["And.Vector64.Single"] = And_Vector64_Single,
                ["And.Vector64.UInt16"] = And_Vector64_UInt16,
                ["And.Vector64.UInt32"] = And_Vector64_UInt32,
                ["And.Vector64.UInt64"] = And_Vector64_UInt64,
                ["And.Vector128.Byte"] = And_Vector128_Byte,
            };
        }
    }
}
