// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.Arm
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["MultiplyBySelectedScalarWideningUpperAndAdd.Vector128.Int16.Vector64.Int16.3"] = MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_Int16_Vector64_Int16_3,
                ["MultiplyBySelectedScalarWideningUpperAndAdd.Vector128.Int16.Vector128.Int16.7"] = MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_Int16_Vector128_Int16_7,
                ["MultiplyBySelectedScalarWideningUpperAndAdd.Vector128.Int32.Vector64.Int32.1"] = MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_Int32_Vector64_Int32_1,
                ["MultiplyBySelectedScalarWideningUpperAndAdd.Vector128.Int32.Vector128.Int32.3"] = MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_Int32_Vector128_Int32_3,
                ["MultiplyBySelectedScalarWideningUpperAndAdd.Vector128.UInt16.Vector64.UInt16.3"] = MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_UInt16_Vector64_UInt16_3,
                ["MultiplyBySelectedScalarWideningUpperAndAdd.Vector128.UInt16.Vector128.UInt16.7"] = MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_UInt16_Vector128_UInt16_7,
                ["MultiplyBySelectedScalarWideningUpperAndAdd.Vector128.UInt32.Vector64.UInt32.1"] = MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_UInt32_Vector64_UInt32_1,
                ["MultiplyBySelectedScalarWideningUpperAndAdd.Vector128.UInt32.Vector128.UInt32.3"] = MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_UInt32_Vector128_UInt32_3,
                ["MultiplyBySelectedScalarWideningUpperAndSubtract.Vector128.Int16.Vector64.Int16.3"] = MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_Int16_Vector64_Int16_3,
                ["MultiplyBySelectedScalarWideningUpperAndSubtract.Vector128.Int16.Vector128.Int16.7"] = MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_Int16_Vector128_Int16_7,
                ["MultiplyBySelectedScalarWideningUpperAndSubtract.Vector128.Int32.Vector64.Int32.1"] = MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_Int32_Vector64_Int32_1,
                ["MultiplyBySelectedScalarWideningUpperAndSubtract.Vector128.Int32.Vector128.Int32.3"] = MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_Int32_Vector128_Int32_3,
                ["MultiplyBySelectedScalarWideningUpperAndSubtract.Vector128.UInt16.Vector64.UInt16.3"] = MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_UInt16_Vector64_UInt16_3,
                ["MultiplyBySelectedScalarWideningUpperAndSubtract.Vector128.UInt16.Vector128.UInt16.7"] = MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_UInt16_Vector128_UInt16_7,
                ["MultiplyBySelectedScalarWideningUpperAndSubtract.Vector128.UInt32.Vector64.UInt32.1"] = MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_UInt32_Vector64_UInt32_1,
                ["MultiplyBySelectedScalarWideningUpperAndSubtract.Vector128.UInt32.Vector128.UInt32.3"] = MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_UInt32_Vector128_UInt32_3,
                ["MultiplyDoublingByScalarSaturateHigh.Vector64.Int16"] = MultiplyDoublingByScalarSaturateHigh_Vector64_Int16,
                ["MultiplyDoublingByScalarSaturateHigh.Vector64.Int32"] = MultiplyDoublingByScalarSaturateHigh_Vector64_Int32,
                ["MultiplyDoublingByScalarSaturateHigh.Vector128.Int16"] = MultiplyDoublingByScalarSaturateHigh_Vector128_Int16,
                ["MultiplyDoublingByScalarSaturateHigh.Vector128.Int32"] = MultiplyDoublingByScalarSaturateHigh_Vector128_Int32,
                ["MultiplyDoublingBySelectedScalarSaturateHigh.Vector64.Int16.Vector64.Int16.3"] = MultiplyDoublingBySelectedScalarSaturateHigh_Vector64_Int16_Vector64_Int16_3,
                ["MultiplyDoublingBySelectedScalarSaturateHigh.Vector64.Int16.Vector128.Int16.7"] = MultiplyDoublingBySelectedScalarSaturateHigh_Vector64_Int16_Vector128_Int16_7,
                ["MultiplyDoublingBySelectedScalarSaturateHigh.Vector64.Int32.Vector64.Int32.1"] = MultiplyDoublingBySelectedScalarSaturateHigh_Vector64_Int32_Vector64_Int32_1,
                ["MultiplyDoublingBySelectedScalarSaturateHigh.Vector64.Int32.Vector128.Int32.3"] = MultiplyDoublingBySelectedScalarSaturateHigh_Vector64_Int32_Vector128_Int32_3,
                ["MultiplyDoublingBySelectedScalarSaturateHigh.Vector128.Int16.Vector64.Int16.3"] = MultiplyDoublingBySelectedScalarSaturateHigh_Vector128_Int16_Vector64_Int16_3,
                ["MultiplyDoublingBySelectedScalarSaturateHigh.Vector128.Int16.Vector128.Int16.7"] = MultiplyDoublingBySelectedScalarSaturateHigh_Vector128_Int16_Vector128_Int16_7,
                ["MultiplyDoublingBySelectedScalarSaturateHigh.Vector128.Int32.Vector64.Int32.1"] = MultiplyDoublingBySelectedScalarSaturateHigh_Vector128_Int32_Vector64_Int32_1,
                ["MultiplyDoublingBySelectedScalarSaturateHigh.Vector128.Int32.Vector128.Int32.3"] = MultiplyDoublingBySelectedScalarSaturateHigh_Vector128_Int32_Vector128_Int32_3,
                ["MultiplyDoublingSaturateHigh.Vector64.Int16"] = MultiplyDoublingSaturateHigh_Vector64_Int16,
                ["MultiplyDoublingSaturateHigh.Vector64.Int32"] = MultiplyDoublingSaturateHigh_Vector64_Int32,
                ["MultiplyDoublingSaturateHigh.Vector128.Int16"] = MultiplyDoublingSaturateHigh_Vector128_Int16,
                ["MultiplyDoublingSaturateHigh.Vector128.Int32"] = MultiplyDoublingSaturateHigh_Vector128_Int32,
                ["MultiplyDoublingWideningLowerAndAddSaturate.Vector64.Int16"] = MultiplyDoublingWideningLowerAndAddSaturate_Vector64_Int16,
                ["MultiplyDoublingWideningLowerAndAddSaturate.Vector64.Int32"] = MultiplyDoublingWideningLowerAndAddSaturate_Vector64_Int32,
                ["MultiplyDoublingWideningLowerAndSubtractSaturate.Vector64.Int16"] = MultiplyDoublingWideningLowerAndSubtractSaturate_Vector64_Int16,
                ["MultiplyDoublingWideningLowerAndSubtractSaturate.Vector64.Int32"] = MultiplyDoublingWideningLowerAndSubtractSaturate_Vector64_Int32,
                ["MultiplyDoublingWideningLowerByScalarAndAddSaturate.Vector64.Int16.Vector64.Int16"] = MultiplyDoublingWideningLowerByScalarAndAddSaturate_Vector64_Int16_Vector64_Int16,
                ["MultiplyDoublingWideningLowerByScalarAndAddSaturate.Vector64.Int32.Vector64.Int32"] = MultiplyDoublingWideningLowerByScalarAndAddSaturate_Vector64_Int32_Vector64_Int32,
                ["MultiplyDoublingWideningLowerByScalarAndSubtractSaturate.Vector64.Int16.Vector64.Int16"] = MultiplyDoublingWideningLowerByScalarAndSubtractSaturate_Vector64_Int16_Vector64_Int16,
                ["MultiplyDoublingWideningLowerByScalarAndSubtractSaturate.Vector64.Int32.Vector64.Int32"] = MultiplyDoublingWideningLowerByScalarAndSubtractSaturate_Vector64_Int32_Vector64_Int32,
                ["MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate.Vector64.Int16.Vector64.Int16.3"] = MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate_Vector64_Int16_Vector64_Int16_3,
                ["MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate.Vector64.Int16.Vector128.Int16.7"] = MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate_Vector64_Int16_Vector128_Int16_7,
                ["MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate.Vector64.Int32.Vector64.Int32.1"] = MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate_Vector64_Int32_Vector64_Int32_1,
                ["MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate.Vector64.Int32.Vector128.Int32.3"] = MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate_Vector64_Int32_Vector128_Int32_3,
                ["MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate.Vector64.Int16.Vector64.Int16.3"] = MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate_Vector64_Int16_Vector64_Int16_3,
                ["MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate.Vector64.Int16.Vector128.Int16.7"] = MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate_Vector64_Int16_Vector128_Int16_7,
                ["MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate.Vector64.Int32.Vector64.Int32.1"] = MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate_Vector64_Int32_Vector64_Int32_1,
                ["MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate.Vector64.Int32.Vector128.Int32.3"] = MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate_Vector64_Int32_Vector128_Int32_3,
                ["MultiplyDoublingWideningSaturateLower.Vector64.Int16"] = MultiplyDoublingWideningSaturateLower_Vector64_Int16,
                ["MultiplyDoublingWideningSaturateLower.Vector64.Int32"] = MultiplyDoublingWideningSaturateLower_Vector64_Int32,
                ["MultiplyDoublingWideningSaturateLowerByScalar.Vector64.Int16"] = MultiplyDoublingWideningSaturateLowerByScalar_Vector64_Int16,
                ["MultiplyDoublingWideningSaturateLowerByScalar.Vector64.Int32"] = MultiplyDoublingWideningSaturateLowerByScalar_Vector64_Int32,
                ["MultiplyDoublingWideningSaturateLowerBySelectedScalar.Vector64.Int16.Vector64.Int16.3"] = MultiplyDoublingWideningSaturateLowerBySelectedScalar_Vector64_Int16_Vector64_Int16_3,
                ["MultiplyDoublingWideningSaturateLowerBySelectedScalar.Vector64.Int16.Vector128.Int16.7"] = MultiplyDoublingWideningSaturateLowerBySelectedScalar_Vector64_Int16_Vector128_Int16_7,
                ["MultiplyDoublingWideningSaturateLowerBySelectedScalar.Vector64.Int32.Vector64.Int32.1"] = MultiplyDoublingWideningSaturateLowerBySelectedScalar_Vector64_Int32_Vector64_Int32_1,
                ["MultiplyDoublingWideningSaturateLowerBySelectedScalar.Vector64.Int32.Vector128.Int32.3"] = MultiplyDoublingWideningSaturateLowerBySelectedScalar_Vector64_Int32_Vector128_Int32_3,
                ["MultiplyDoublingWideningSaturateUpper.Vector128.Int16"] = MultiplyDoublingWideningSaturateUpper_Vector128_Int16,
                ["MultiplyDoublingWideningSaturateUpper.Vector128.Int32"] = MultiplyDoublingWideningSaturateUpper_Vector128_Int32,
                ["MultiplyDoublingWideningSaturateUpperByScalar.Vector128.Int16"] = MultiplyDoublingWideningSaturateUpperByScalar_Vector128_Int16,
                ["MultiplyDoublingWideningSaturateUpperByScalar.Vector128.Int32"] = MultiplyDoublingWideningSaturateUpperByScalar_Vector128_Int32,
                ["MultiplyDoublingWideningSaturateUpperBySelectedScalar.Vector128.Int16.Vector64.Int16.3"] = MultiplyDoublingWideningSaturateUpperBySelectedScalar_Vector128_Int16_Vector64_Int16_3,
                ["MultiplyDoublingWideningSaturateUpperBySelectedScalar.Vector128.Int16.Vector128.Int16.7"] = MultiplyDoublingWideningSaturateUpperBySelectedScalar_Vector128_Int16_Vector128_Int16_7,
                ["MultiplyDoublingWideningSaturateUpperBySelectedScalar.Vector128.Int32.Vector64.Int32.1"] = MultiplyDoublingWideningSaturateUpperBySelectedScalar_Vector128_Int32_Vector64_Int32_1,
                ["MultiplyDoublingWideningSaturateUpperBySelectedScalar.Vector128.Int32.Vector128.Int32.3"] = MultiplyDoublingWideningSaturateUpperBySelectedScalar_Vector128_Int32_Vector128_Int32_3,
                ["MultiplyDoublingWideningUpperAndAddSaturate.Vector128.Int16"] = MultiplyDoublingWideningUpperAndAddSaturate_Vector128_Int16,
                ["MultiplyDoublingWideningUpperAndAddSaturate.Vector128.Int32"] = MultiplyDoublingWideningUpperAndAddSaturate_Vector128_Int32,
                ["MultiplyDoublingWideningUpperAndSubtractSaturate.Vector128.Int16"] = MultiplyDoublingWideningUpperAndSubtractSaturate_Vector128_Int16,
                ["MultiplyDoublingWideningUpperAndSubtractSaturate.Vector128.Int32"] = MultiplyDoublingWideningUpperAndSubtractSaturate_Vector128_Int32,
                ["MultiplyDoublingWideningUpperByScalarAndAddSaturate.Vector128.Int16.Vector64.Int16"] = MultiplyDoublingWideningUpperByScalarAndAddSaturate_Vector128_Int16_Vector64_Int16,
                ["MultiplyDoublingWideningUpperByScalarAndAddSaturate.Vector128.Int32.Vector64.Int32"] = MultiplyDoublingWideningUpperByScalarAndAddSaturate_Vector128_Int32_Vector64_Int32,
                ["MultiplyDoublingWideningUpperByScalarAndSubtractSaturate.Vector128.Int16.Vector64.Int16"] = MultiplyDoublingWideningUpperByScalarAndSubtractSaturate_Vector128_Int16_Vector64_Int16,
                ["MultiplyDoublingWideningUpperByScalarAndSubtractSaturate.Vector128.Int32.Vector64.Int32"] = MultiplyDoublingWideningUpperByScalarAndSubtractSaturate_Vector128_Int32_Vector64_Int32,
                ["MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate.Vector128.Int16.Vector64.Int16.3"] = MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate_Vector128_Int16_Vector64_Int16_3,
                ["MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate.Vector128.Int16.Vector128.Int16.7"] = MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate_Vector128_Int16_Vector128_Int16_7,
                ["MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate.Vector128.Int32.Vector64.Int32.1"] = MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate_Vector128_Int32_Vector64_Int32_1,
                ["MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate.Vector128.Int32.Vector128.Int32.3"] = MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate_Vector128_Int32_Vector128_Int32_3,
                ["MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate.Vector128.Int16.Vector64.Int16.3"] = MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate_Vector128_Int16_Vector64_Int16_3,
                ["MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate.Vector128.Int16.Vector128.Int16.7"] = MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate_Vector128_Int16_Vector128_Int16_7,
                ["MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate.Vector128.Int32.Vector64.Int32.1"] = MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate_Vector128_Int32_Vector64_Int32_1,
                ["MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate.Vector128.Int32.Vector128.Int32.3"] = MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate_Vector128_Int32_Vector128_Int32_3,
                ["MultiplyRoundedDoublingByScalarSaturateHigh.Vector64.Int16"] = MultiplyRoundedDoublingByScalarSaturateHigh_Vector64_Int16,
                ["MultiplyRoundedDoublingByScalarSaturateHigh.Vector64.Int32"] = MultiplyRoundedDoublingByScalarSaturateHigh_Vector64_Int32,
                ["MultiplyRoundedDoublingByScalarSaturateHigh.Vector128.Int16"] = MultiplyRoundedDoublingByScalarSaturateHigh_Vector128_Int16,
                ["MultiplyRoundedDoublingByScalarSaturateHigh.Vector128.Int32"] = MultiplyRoundedDoublingByScalarSaturateHigh_Vector128_Int32,
                ["MultiplyRoundedDoublingBySelectedScalarSaturateHigh.Vector64.Int16.Vector64.Int16.3"] = MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector64_Int16_Vector64_Int16_3,
                ["MultiplyRoundedDoublingBySelectedScalarSaturateHigh.Vector64.Int16.Vector128.Int16.7"] = MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector64_Int16_Vector128_Int16_7,
                ["MultiplyRoundedDoublingBySelectedScalarSaturateHigh.Vector64.Int32.Vector64.Int32.1"] = MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector64_Int32_Vector64_Int32_1,
                ["MultiplyRoundedDoublingBySelectedScalarSaturateHigh.Vector64.Int32.Vector128.Int32.3"] = MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector64_Int32_Vector128_Int32_3,
                ["MultiplyRoundedDoublingBySelectedScalarSaturateHigh.Vector128.Int16.Vector64.Int16.2"] = MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector128_Int16_Vector64_Int16_2,
                ["MultiplyRoundedDoublingBySelectedScalarSaturateHigh.Vector128.Int16.Vector128.Int16.7"] = MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector128_Int16_Vector128_Int16_7,
                ["MultiplyRoundedDoublingBySelectedScalarSaturateHigh.Vector128.Int32.Vector64.Int32.1"] = MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector128_Int32_Vector64_Int32_1,
                ["MultiplyRoundedDoublingBySelectedScalarSaturateHigh.Vector128.Int32.Vector128.Int32.3"] = MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector128_Int32_Vector128_Int32_3,
                ["MultiplyRoundedDoublingSaturateHigh.Vector64.Int16"] = MultiplyRoundedDoublingSaturateHigh_Vector64_Int16,
                ["MultiplyRoundedDoublingSaturateHigh.Vector64.Int32"] = MultiplyRoundedDoublingSaturateHigh_Vector64_Int32,
                ["MultiplyRoundedDoublingSaturateHigh.Vector128.Int16"] = MultiplyRoundedDoublingSaturateHigh_Vector128_Int16,
                ["MultiplyRoundedDoublingSaturateHigh.Vector128.Int32"] = MultiplyRoundedDoublingSaturateHigh_Vector128_Int32,
                ["MultiplyScalarBySelectedScalar.Vector64.Single.Vector64.Single.1"] = MultiplyScalarBySelectedScalar_Vector64_Single_Vector64_Single_1,
                ["MultiplyScalarBySelectedScalar.Vector64.Single.Vector128.Single.3"] = MultiplyScalarBySelectedScalar_Vector64_Single_Vector128_Single_3,
                ["MultiplySubtract.Vector64.Byte"] = MultiplySubtract_Vector64_Byte,
                ["MultiplySubtract.Vector64.Int16"] = MultiplySubtract_Vector64_Int16,
            };
        }
    }
}
