import { TransportItemType } from '../../transports';
import { getCurrentTimestamp } from '../../utils';
import { defaultExceptionType } from './const';
export function initializeExceptions(transports, metas, tracesApi) {
  var pushException = function (value, _a) {
    var _b = _a === void 0 ? {} : _a,
      stackFrames = _b.stackFrames,
      type = _b.type;
    try {
      var item = {
        meta: metas.value,
        payload: {
          type: type !== null && type !== void 0 ? type : defaultExceptionType,
          value: value,
          timestamp: getCurrentTimestamp(),
          trace: tracesApi.getTraceContext(),
        },
        type: TransportItemType.EXCEPTION,
      };
      if (stackFrames === null || stackFrames === void 0 ? void 0 : stackFrames.length) {
        item.payload.stacktrace = {
          frames: stackFrames,
        };
      }
      transports.execute(item);
    } catch (err) {
      // TODO: Add proper logging when debug is enabled
    }
  };
  return {
    pushException: pushException,
  };
}
//# sourceMappingURL=initialize.js.map
