"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var metas_1 = require("../../metas");
var transports_1 = require("../../transports");
var tests_1 = require("../../utils/tests");
var traces_1 = require("../traces");
var initialize_1 = require("./initialize");
describe('api.exceptions', function () {
    function createAPI() {
        var transport = new tests_1.MockTransport();
        var config = (0, tests_1.mockConfig)({
            transports: [transport],
        });
        var transports = (0, transports_1.initializeTransports)(config);
        var metas = (0, metas_1.initializeMetas)(config);
        var tracesAPI = (0, traces_1.initializeTracesAPI)(transports, metas);
        var api = (0, initialize_1.initializeExceptionsAPI)(config, transports, metas, tracesAPI);
        return [api, transport];
    }
    describe('pushError', function () {
        it('error with overrides', function () {
            var _a = createAPI(), api = _a[0], transport = _a[1];
            var frames = [
                {
                    filename: 'foo.js',
                    function: 'FooFn',
                    colno: 4,
                    lineno: 23,
                },
                {
                    filename: 'bar.js',
                    function: 'BarFn',
                    colno: 6,
                    lineno: 52,
                },
            ];
            api.pushError(new Error('test exception'), {
                stackFrames: frames,
                type: 'TestError',
            });
            expect(transport.items).toHaveLength(1);
            var payload = transport.items[0];
            expect(payload === null || payload === void 0 ? void 0 : payload.payload).toBeTruthy();
            expect(payload === null || payload === void 0 ? void 0 : payload.type).toEqual(transports_1.TransportItemType.EXCEPTION);
            var event = payload === null || payload === void 0 ? void 0 : payload.payload;
            expect(event.type).toEqual('TestError');
            expect(event.value).toEqual('test exception');
            expect(event.stacktrace).toEqual({ frames: frames });
        });
        it('error without overrides', function () {
            var _a, _b;
            var _c = createAPI(), api = _c[0], transport = _c[1];
            var err = new Error('test');
            api.pushError(err);
            expect(transport.items).toHaveLength(1);
            var payload = transport.items[0];
            expect((_a = payload === null || payload === void 0 ? void 0 : payload.meta.app) === null || _a === void 0 ? void 0 : _a.name).toEqual('test');
            expect(payload === null || payload === void 0 ? void 0 : payload.payload).toBeTruthy();
            expect(payload === null || payload === void 0 ? void 0 : payload.type).toEqual(transports_1.TransportItemType.EXCEPTION);
            var event = payload === null || payload === void 0 ? void 0 : payload.payload;
            expect(event.type).toEqual('Error');
            expect(event.value).toEqual('test');
            expect(event.timestamp).toBeTruthy();
            var stacktrace = event.stacktrace;
            expect(stacktrace).toBeTruthy();
            expect(stacktrace === null || stacktrace === void 0 ? void 0 : stacktrace.frames.length).toBeGreaterThan(3);
            expect((_b = stacktrace === null || stacktrace === void 0 ? void 0 : stacktrace.frames[0]) === null || _b === void 0 ? void 0 : _b.filename).toEqual('Error: test');
        });
    });
});
//# sourceMappingURL=initialize.test.js.map