export class MockTransport {
    constructor(ignoreURLs = []) {
        this.ignoreURLs = ignoreURLs;
        this.items = [];
    }
    send(item) {
        this.items.push(item);
    }
    getIgnoreUrls() {
        return this.ignoreURLs;
    }
}
export function mockConfig(overrides = {}) {
    return Object.assign({ globalObjectKey: 'grafanaAgent', instrumentations: [], preventGlobalExposure: true, transports: [], metas: [], app: {
            name: 'test',
            version: '1.0.0',
        }, parseStacktrace: mockStacktraceParser, paused: false }, overrides);
}
export const mockStacktraceParser = (err) => {
    var _a;
    const frames = [];
    const stack = (_a = err.stack) !== null && _a !== void 0 ? _a : err.stacktrace;
    if (stack) {
        stack.split('\n').forEach((line) => {
            frames.push({
                filename: line,
                function: '',
            });
        });
    }
    return {
        frames,
    };
};
//# sourceMappingURL=tests.js.map