/**
 * This file is generated based on https://github.com/octokit/routes/ & "npm run build:ts".
 *
 * DO NOT EDIT MANUALLY.
 */

/**
 * This declaration file requires TypeScript 3.1 or above.
 */

/// <reference lib="esnext.asynciterable" />

import * as http from "http";

declare namespace Octokit {
  type json = any;
  type date = string;

  export interface Static {
    plugin(plugin: Plugin): Static;
    new (options?: Octokit.Options): Octokit;
  }

  export interface Response<T> {
    /** This is the data you would see in https://developer.github.com/v3/ */
    data: T;

    /** Response status number */
    status: number;

    /** Response headers */
    headers: {
      date: string;
      "x-ratelimit-limit": string;
      "x-ratelimit-remaining": string;
      "x-ratelimit-reset": string;
      "x-Octokit-request-id": string;
      "x-Octokit-media-type": string;
      link: string;
      "last-modified": string;
      etag: string;
      status: string;
    };

    [Symbol.iterator](): Iterator<any>;
  }

  export type AnyResponse = Response<any>;

  export interface EmptyParams {}

  export interface Options {
    authStrategy?: any;
    auth?:
      | string
      | { username: string; password: string; on2fa: () => Promise<string> }
      | { clientId: string; clientSecret: string }
      | { (): string | Promise<string> }
      | any;
    userAgent?: string;
    previews?: string[];
    baseUrl?: string;
    log?: {
      debug?: (message: string, info?: object) => void;
      info?: (message: string, info?: object) => void;
      warn?: (message: string, info?: object) => void;
      error?: (message: string, info?: object) => void;
    };
    request?: {
      agent?: http.Agent;
      timeout?: number;
    };
    /**
     * @deprecated Use {request: {timeout}} instead. See https://github.com/octokit/request.js#request
     */
    timeout?: number;
    /**
     * @deprecated Use {userAgent, previews} instead. See https://github.com/octokit/request.js#request
     */
    headers?: { [header: string]: any };
    /**
     * @deprecated Use {request: {agent}} instead. See https://github.com/octokit/request.js#request
     */
    agent?: http.Agent;
    [option: string]: any;
  }

  export type RequestMethod =
    | "DELETE"
    | "GET"
    | "HEAD"
    | "PATCH"
    | "POST"
    | "PUT";

  export interface EndpointOptions {
    baseUrl?: string;
    method?: RequestMethod;
    url?: string;
    headers?: { [header: string]: any };
    data?: any;
    request?: { [option: string]: any };
    [parameter: string]: any;
  }

  export interface RequestOptions {
    method?: RequestMethod;
    url?: string;
    headers?: RequestHeaders;
    body?: any;
    request?: OctokitRequestOptions;
    /**
     * Media type options, see {@link https://developer.github.com/v3/media/|GitHub Developer Guide}
     */
    mediaType?: {
      /**
       * `json` by default. Can be `raw`, `text`, `html`, `full`, `diff`, `patch`, `sha`, `base64`. Depending on endpoint
       */
      format?: string;

      /**
       * Custom media type names of {@link https://developer.github.com/v3/media/|API Previews} without the `-preview` suffix.
       * Example for single preview: `['squirrel-girl']`.
       * Example for multiple previews: `['squirrel-girl', 'mister-fantastic']`.
       */
      previews?: string[];
    };
  }

  export type RequestHeaders = {
    /**
     * Avoid setting `accept`, use `mediaFormat.{format|previews}` instead.
     */
    accept?: string;
    /**
     * Use `authorization` to send authenticated request, remember `token ` / `bearer ` prefixes. Example: `token 1234567890abcdef1234567890abcdef12345678`
     */
    authorization?: string;
    /**
     * `user-agent` is set do a default and can be overwritten as needed.
     */
    "user-agent"?: string;

    [header: string]: string | number | undefined;
  };

  export type OctokitRequestOptions = {
    /**
     * Node only. Useful for custom proxy, certificate, or dns lookup.
     */
    agent?: http.Agent;
    /**
     * Custom replacement for built-in fetch method. Useful for testing or request hooks.
     */
    fetch?: any;
    /**
     * Use an `AbortController` instance to cancel a request. In node you can only cancel streamed requests.
     */
    signal?: any;
    /**
     * Node only. Request/response timeout in ms, it resets on redirect. 0 to disable (OS limit applies). `options.request.signal` is recommended instead.
     */
    timeout?: number;

    [option: string]: any;
  };

  export interface Log {
    debug: (message: string, additionalInfo?: object) => void;
    info: (message: string, additionalInfo?: object) => void;
    warn: (message: string, additionalInfo?: object) => void;
    error: (message: string, additionalInfo?: object) => void;
  }

  export interface Endpoint {
    (
      Route: string,
      EndpointOptions?: Octokit.EndpointOptions
    ): Octokit.RequestOptions;
    (EndpointOptions: Octokit.EndpointOptions): Octokit.RequestOptions;
    /**
     * Current default options
     */
    DEFAULTS: Octokit.EndpointOptions;
    /**
     * Get the defaulted endpoint options, but without parsing them into request options:
     */
    merge(
      Route: string,
      EndpointOptions?: Octokit.EndpointOptions
    ): Octokit.RequestOptions;
    merge(EndpointOptions: Octokit.EndpointOptions): Octokit.RequestOptions;
    /**
     * Stateless method to turn endpoint options into request options. Calling endpoint(options) is the same as calling endpoint.parse(endpoint.merge(options)).
     */
    parse(EndpointOptions: Octokit.EndpointOptions): Octokit.RequestOptions;
    /**
     * Merges existing defaults with passed options and returns new endpoint() method with new defaults
     */
    defaults(EndpointOptions: Octokit.EndpointOptions): Octokit.Endpoint;
  }

  export interface Request {
    (Route: string, EndpointOptions?: Octokit.EndpointOptions): Promise<
      Octokit.AnyResponse
    >;
    (EndpointOptions: Octokit.EndpointOptions): Promise<Octokit.AnyResponse>;
    endpoint: Octokit.Endpoint;
  }

  export interface AuthBasic {
    type: "basic";
    username: string;
    password: string;
  }

  export interface AuthOAuthToken {
    type: "oauth";
    token: string;
  }

  export interface AuthOAuthSecret {
    type: "oauth";
    key: string;
    secret: string;
  }

  export interface AuthUserToken {
    type: "token";
    token: string;
  }

  export interface AuthJWT {
    type: "app";
    token: string;
  }

  export type Link = { link: string } | { headers: { link: string } } | string;

  export interface Callback<T> {
    (error: Error | null, result: T): any;
  }

  export type Plugin = (octokit: Octokit, options: Octokit.Options) => void;

  // See https://github.com/octokit/request.js#request
  export type HookOptions = {
    baseUrl: string;
    headers: { [header: string]: string };
    method: string;
    url: string;
    data: any;
    // See https://github.com/bitinn/node-fetch#options
    request: {
      follow?: number;
      timeout?: number;
      compress?: boolean;
      size?: number;
      agent?: string | null;
    };
    [index: string]: any;
  };

  export type HookError = Error & {
    status: number;
    headers: { [header: string]: string };
    documentation_url?: string;
    errors?: [
      {
        resource: string;
        field: string;
        code: string;
      }
    ];
  };

  export interface Paginate {
    (
      Route: string,
      EndpointOptions?: Octokit.EndpointOptions,
      callback?: (response: Octokit.AnyResponse, done: () => void) => any
    ): Promise<any[]>;
    (
      EndpointOptions: Octokit.EndpointOptions,
      callback?: (response: Octokit.AnyResponse, done: () => void) => any
    ): Promise<any[]>;
    iterator: (
      EndpointOptions: Octokit.EndpointOptions
    ) => AsyncIterableIterator<Octokit.AnyResponse>;
  }

  // response types
  type UsersUpdateAuthenticatedResponsePlan = {
    collaborators: number;
    name: string;
    private_repos: number;
    space: number;
  };
  type UsersUpdateAuthenticatedResponse = {
    avatar_url: string;
    bio: string;
    blog: string;
    collaborators: number;
    company: string;
    created_at: string;
    disk_usage: number;
    email: string;
    events_url: string;
    followers: number;
    followers_url: string;
    following: number;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    hireable: boolean;
    html_url: string;
    id: number;
    location: string;
    login: string;
    name: string;
    node_id: string;
    organizations_url: string;
    owned_private_repos: number;
    plan: UsersUpdateAuthenticatedResponsePlan;
    private_gists: number;
    public_gists: number;
    public_repos: number;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    total_private_repos: number;
    two_factor_authentication: boolean;
    type: string;
    updated_at: string;
    url: string;
  };
  type UsersTogglePrimaryEmailVisibilityResponseItem = {
    email: string;
    primary: boolean;
    verified: boolean;
    visibility: string;
  };
  type UsersListPublicKeysForUserResponseItem = { id: number; key: string };
  type UsersListPublicKeysResponseItem = { key: string; key_id: string };
  type UsersListPublicEmailsResponseItem = {
    email: string;
    primary: boolean;
    verified: boolean;
    visibility: string;
  };
  type UsersListGpgKeysForUserResponseItemSubkeysItem = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<any>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: number;
    public_key: string;
    subkeys: Array<any>;
  };
  type UsersListGpgKeysForUserResponseItemEmailsItem = {
    email: string;
    verified: boolean;
  };
  type UsersListGpgKeysForUserResponseItem = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<UsersListGpgKeysForUserResponseItemEmailsItem>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: null;
    public_key: string;
    subkeys: Array<UsersListGpgKeysForUserResponseItemSubkeysItem>;
  };
  type UsersListGpgKeysResponseItemSubkeysItem = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<any>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: number;
    public_key: string;
    subkeys: Array<any>;
  };
  type UsersListGpgKeysResponseItemEmailsItem = {
    email: string;
    verified: boolean;
  };
  type UsersListGpgKeysResponseItem = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<UsersListGpgKeysResponseItemEmailsItem>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: null;
    public_key: string;
    subkeys: Array<UsersListGpgKeysResponseItemSubkeysItem>;
  };
  type UsersListFollowingForUserResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type UsersListFollowingForAuthenticatedUserResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type UsersListFollowersForUserResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type UsersListFollowersForAuthenticatedUserResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type UsersListEmailsResponseItem = {
    email: string;
    primary: boolean;
    verified: boolean;
    visibility: string;
  };
  type UsersListBlockedResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type UsersListResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type UsersGetPublicKeyResponse = { key: string; key_id: string };
  type UsersGetGpgKeyResponseSubkeysItem = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<any>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: number;
    public_key: string;
    subkeys: Array<any>;
  };
  type UsersGetGpgKeyResponseEmailsItem = { email: string; verified: boolean };
  type UsersGetGpgKeyResponse = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<UsersGetGpgKeyResponseEmailsItem>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: null;
    public_key: string;
    subkeys: Array<UsersGetGpgKeyResponseSubkeysItem>;
  };
  type UsersGetContextForUserResponseContextsItem = {
    message: string;
    octicon: string;
  };
  type UsersGetContextForUserResponse = {
    contexts: Array<UsersGetContextForUserResponseContextsItem>;
  };
  type UsersGetByUsernameResponsePlan = {
    collaborators: number;
    name: string;
    private_repos: number;
    space: number;
  };
  type UsersGetByUsernameResponse = {
    avatar_url: string;
    bio: string;
    blog: string;
    company: string;
    created_at: string;
    email: string;
    events_url: string;
    followers: number;
    followers_url: string;
    following: number;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    hireable: boolean;
    html_url: string;
    id: number;
    location: string;
    login: string;
    name: string;
    node_id: string;
    organizations_url: string;
    public_gists: number;
    public_repos: number;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    updated_at: string;
    url: string;
    plan?: UsersGetByUsernameResponsePlan;
  };
  type UsersGetAuthenticatedResponsePlan = {
    collaborators: number;
    name: string;
    private_repos: number;
    space: number;
  };
  type UsersGetAuthenticatedResponse = {
    avatar_url: string;
    bio: string;
    blog: string;
    collaborators?: number;
    company: string;
    created_at: string;
    disk_usage?: number;
    email: string;
    events_url: string;
    followers: number;
    followers_url: string;
    following: number;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    hireable: boolean;
    html_url: string;
    id: number;
    location: string;
    login: string;
    name: string;
    node_id: string;
    organizations_url: string;
    owned_private_repos?: number;
    plan?: UsersGetAuthenticatedResponsePlan;
    private_gists?: number;
    public_gists: number;
    public_repos: number;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    total_private_repos?: number;
    two_factor_authentication?: boolean;
    type: string;
    updated_at: string;
    url: string;
  };
  type UsersCreatePublicKeyResponse = { key: string; key_id: string };
  type UsersCreateGpgKeyResponseSubkeysItem = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<any>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: number;
    public_key: string;
    subkeys: Array<any>;
  };
  type UsersCreateGpgKeyResponseEmailsItem = {
    email: string;
    verified: boolean;
  };
  type UsersCreateGpgKeyResponse = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<UsersCreateGpgKeyResponseEmailsItem>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: null;
    public_key: string;
    subkeys: Array<UsersCreateGpgKeyResponseSubkeysItem>;
  };
  type UsersAddEmailsResponseItem = {
    email: string;
    primary: boolean;
    verified: boolean;
    visibility: string | null;
  };
  type TeamsUpdateLegacyResponseOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
  };
  type TeamsUpdateLegacyResponse = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsUpdateLegacyResponseOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
  };
  type TeamsUpdateInOrgResponseOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
  };
  type TeamsUpdateInOrgResponse = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsUpdateInOrgResponseOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
  };
  type TeamsUpdateDiscussionLegacyResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsUpdateDiscussionLegacyResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsUpdateDiscussionLegacyResponse = {
    author: TeamsUpdateDiscussionLegacyResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: string;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsUpdateDiscussionLegacyResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type TeamsUpdateDiscussionInOrgResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsUpdateDiscussionInOrgResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsUpdateDiscussionInOrgResponse = {
    author: TeamsUpdateDiscussionInOrgResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: string;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsUpdateDiscussionInOrgResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type TeamsUpdateDiscussionCommentLegacyResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsUpdateDiscussionCommentLegacyResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsUpdateDiscussionCommentLegacyResponse = {
    author: TeamsUpdateDiscussionCommentLegacyResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: string;
    node_id: string;
    number: number;
    reactions: TeamsUpdateDiscussionCommentLegacyResponseReactions;
    updated_at: string;
    url: string;
  };
  type TeamsUpdateDiscussionCommentInOrgResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsUpdateDiscussionCommentInOrgResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsUpdateDiscussionCommentInOrgResponse = {
    author: TeamsUpdateDiscussionCommentInOrgResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: string;
    node_id: string;
    number: number;
    reactions: TeamsUpdateDiscussionCommentInOrgResponseReactions;
    updated_at: string;
    url: string;
  };
  type TeamsUpdateDiscussionCommentResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsUpdateDiscussionCommentResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsUpdateDiscussionCommentResponse = {
    author: TeamsUpdateDiscussionCommentResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: string;
    node_id: string;
    number: number;
    reactions: TeamsUpdateDiscussionCommentResponseReactions;
    updated_at: string;
    url: string;
  };
  type TeamsUpdateDiscussionResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsUpdateDiscussionResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsUpdateDiscussionResponse = {
    author: TeamsUpdateDiscussionResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: string;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsUpdateDiscussionResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type TeamsUpdateResponseOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
  };
  type TeamsUpdateResponse = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsUpdateResponseOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
  };
  type TeamsReviewProjectLegacyResponsePermissions = {
    admin: boolean;
    read: boolean;
    write: boolean;
  };
  type TeamsReviewProjectLegacyResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsReviewProjectLegacyResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: TeamsReviewProjectLegacyResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    organization_permission: string;
    owner_url: string;
    permissions: TeamsReviewProjectLegacyResponsePermissions;
    private: boolean;
    state: string;
    updated_at: string;
    url: string;
  };
  type TeamsReviewProjectInOrgResponsePermissions = {
    admin: boolean;
    read: boolean;
    write: boolean;
  };
  type TeamsReviewProjectInOrgResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsReviewProjectInOrgResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: TeamsReviewProjectInOrgResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    organization_permission: string;
    owner_url: string;
    permissions: TeamsReviewProjectInOrgResponsePermissions;
    private: boolean;
    state: string;
    updated_at: string;
    url: string;
  };
  type TeamsReviewProjectResponsePermissions = {
    admin: boolean;
    read: boolean;
    write: boolean;
  };
  type TeamsReviewProjectResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsReviewProjectResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: TeamsReviewProjectResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    organization_permission: string;
    owner_url: string;
    permissions: TeamsReviewProjectResponsePermissions;
    private: boolean;
    state: string;
    updated_at: string;
    url: string;
  };
  type TeamsListReposLegacyResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type TeamsListReposLegacyResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListReposLegacyResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
  };
  type TeamsListReposLegacyResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: TeamsListReposLegacyResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: TeamsListReposLegacyResponseItemOwner;
    permissions: TeamsListReposLegacyResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type TeamsListReposInOrgResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type TeamsListReposInOrgResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListReposInOrgResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
  };
  type TeamsListReposInOrgResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: TeamsListReposInOrgResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: TeamsListReposInOrgResponseItemOwner;
    permissions: TeamsListReposInOrgResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type TeamsListReposResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type TeamsListReposResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListReposResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
  };
  type TeamsListReposResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: TeamsListReposResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: TeamsListReposResponseItemOwner;
    permissions: TeamsListReposResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type TeamsListProjectsLegacyResponseItemPermissions = {
    admin: boolean;
    read: boolean;
    write: boolean;
  };
  type TeamsListProjectsLegacyResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListProjectsLegacyResponseItem = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: TeamsListProjectsLegacyResponseItemCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    organization_permission: string;
    owner_url: string;
    permissions: TeamsListProjectsLegacyResponseItemPermissions;
    private: boolean;
    state: string;
    updated_at: string;
    url: string;
  };
  type TeamsListProjectsInOrgResponseItemPermissions = {
    admin: boolean;
    read: boolean;
    write: boolean;
  };
  type TeamsListProjectsInOrgResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListProjectsInOrgResponseItem = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: TeamsListProjectsInOrgResponseItemCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    organization_permission: string;
    owner_url: string;
    permissions: TeamsListProjectsInOrgResponseItemPermissions;
    private: boolean;
    state: string;
    updated_at: string;
    url: string;
  };
  type TeamsListProjectsResponseItemPermissions = {
    admin: boolean;
    read: boolean;
    write: boolean;
  };
  type TeamsListProjectsResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListProjectsResponseItem = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: TeamsListProjectsResponseItemCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    organization_permission: string;
    owner_url: string;
    permissions: TeamsListProjectsResponseItemPermissions;
    private: boolean;
    state: string;
    updated_at: string;
    url: string;
  };
  type TeamsListPendingInvitationsLegacyResponseItemInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListPendingInvitationsLegacyResponseItem = {
    created_at: string;
    email: string;
    id: number;
    invitation_team_url: string;
    inviter: TeamsListPendingInvitationsLegacyResponseItemInviter;
    login: string;
    role: string;
    team_count: number;
  };
  type TeamsListPendingInvitationsInOrgResponseItemInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListPendingInvitationsInOrgResponseItem = {
    created_at: string;
    email: string;
    id: number;
    invitation_team_url: string;
    inviter: TeamsListPendingInvitationsInOrgResponseItemInviter;
    login: string;
    role: string;
    team_count: number;
  };
  type TeamsListPendingInvitationsResponseItemInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListPendingInvitationsResponseItem = {
    created_at: string;
    email: string;
    id: number;
    invitation_team_url: string;
    inviter: TeamsListPendingInvitationsResponseItemInviter;
    login: string;
    role: string;
    team_count: number;
  };
  type TeamsListMembersLegacyResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListMembersInOrgResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListMembersResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListForAuthenticatedUserResponseItemOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
  };
  type TeamsListForAuthenticatedUserResponseItem = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsListForAuthenticatedUserResponseItemOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
  };
  type TeamsListDiscussionsLegacyResponseItemReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsListDiscussionsLegacyResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListDiscussionsLegacyResponseItem = {
    author: TeamsListDiscussionsLegacyResponseItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsListDiscussionsLegacyResponseItemReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type TeamsListDiscussionsInOrgResponseItemReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsListDiscussionsInOrgResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListDiscussionsInOrgResponseItem = {
    author: TeamsListDiscussionsInOrgResponseItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsListDiscussionsInOrgResponseItemReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type TeamsListDiscussionsResponseItemReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsListDiscussionsResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListDiscussionsResponseItem = {
    author: TeamsListDiscussionsResponseItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsListDiscussionsResponseItemReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type TeamsListDiscussionCommentsLegacyResponseItemReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsListDiscussionCommentsLegacyResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListDiscussionCommentsLegacyResponseItem = {
    author: TeamsListDiscussionCommentsLegacyResponseItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsListDiscussionCommentsLegacyResponseItemReactions;
    updated_at: string;
    url: string;
  };
  type TeamsListDiscussionCommentsInOrgResponseItemReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsListDiscussionCommentsInOrgResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListDiscussionCommentsInOrgResponseItem = {
    author: TeamsListDiscussionCommentsInOrgResponseItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsListDiscussionCommentsInOrgResponseItemReactions;
    updated_at: string;
    url: string;
  };
  type TeamsListDiscussionCommentsResponseItemReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsListDiscussionCommentsResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsListDiscussionCommentsResponseItem = {
    author: TeamsListDiscussionCommentsResponseItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsListDiscussionCommentsResponseItemReactions;
    updated_at: string;
    url: string;
  };
  type TeamsListChildLegacyResponseItemParent = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type TeamsListChildLegacyResponseItem = {
    description: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: TeamsListChildLegacyResponseItemParent;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type TeamsListChildInOrgResponseItemParent = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type TeamsListChildInOrgResponseItem = {
    description: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: TeamsListChildInOrgResponseItemParent;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type TeamsListChildResponseItemParent = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type TeamsListChildResponseItem = {
    description: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: TeamsListChildResponseItemParent;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type TeamsListResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type TeamsGetMembershipLegacyResponse = {
    role: string;
    state: string;
    url: string;
  };
  type TeamsGetMembershipInOrgResponse = {
    role: string;
    state: string;
    url: string;
  };
  type TeamsGetMembershipResponse = {
    role: string;
    state: string;
    url: string;
  };
  type TeamsGetLegacyResponseOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
  };
  type TeamsGetLegacyResponse = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsGetLegacyResponseOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
  };
  type TeamsGetDiscussionLegacyResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsGetDiscussionLegacyResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsGetDiscussionLegacyResponse = {
    author: TeamsGetDiscussionLegacyResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsGetDiscussionLegacyResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type TeamsGetDiscussionInOrgResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsGetDiscussionInOrgResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsGetDiscussionInOrgResponse = {
    author: TeamsGetDiscussionInOrgResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsGetDiscussionInOrgResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type TeamsGetDiscussionCommentLegacyResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsGetDiscussionCommentLegacyResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsGetDiscussionCommentLegacyResponse = {
    author: TeamsGetDiscussionCommentLegacyResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsGetDiscussionCommentLegacyResponseReactions;
    updated_at: string;
    url: string;
  };
  type TeamsGetDiscussionCommentInOrgResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsGetDiscussionCommentInOrgResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsGetDiscussionCommentInOrgResponse = {
    author: TeamsGetDiscussionCommentInOrgResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsGetDiscussionCommentInOrgResponseReactions;
    updated_at: string;
    url: string;
  };
  type TeamsGetDiscussionCommentResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsGetDiscussionCommentResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsGetDiscussionCommentResponse = {
    author: TeamsGetDiscussionCommentResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsGetDiscussionCommentResponseReactions;
    updated_at: string;
    url: string;
  };
  type TeamsGetDiscussionResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsGetDiscussionResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsGetDiscussionResponse = {
    author: TeamsGetDiscussionResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsGetDiscussionResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type TeamsGetByNameResponseOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
  };
  type TeamsGetByNameResponse = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsGetByNameResponseOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
  };
  type TeamsGetResponseOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
  };
  type TeamsGetResponse = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsGetResponseOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
  };
  type TeamsCreateDiscussionLegacyResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsCreateDiscussionLegacyResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsCreateDiscussionLegacyResponse = {
    author: TeamsCreateDiscussionLegacyResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsCreateDiscussionLegacyResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type TeamsCreateDiscussionInOrgResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsCreateDiscussionInOrgResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsCreateDiscussionInOrgResponse = {
    author: TeamsCreateDiscussionInOrgResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsCreateDiscussionInOrgResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type TeamsCreateDiscussionCommentLegacyResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsCreateDiscussionCommentLegacyResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsCreateDiscussionCommentLegacyResponse = {
    author: TeamsCreateDiscussionCommentLegacyResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsCreateDiscussionCommentLegacyResponseReactions;
    updated_at: string;
    url: string;
  };
  type TeamsCreateDiscussionCommentInOrgResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsCreateDiscussionCommentInOrgResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsCreateDiscussionCommentInOrgResponse = {
    author: TeamsCreateDiscussionCommentInOrgResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsCreateDiscussionCommentInOrgResponseReactions;
    updated_at: string;
    url: string;
  };
  type TeamsCreateDiscussionCommentResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsCreateDiscussionCommentResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsCreateDiscussionCommentResponse = {
    author: TeamsCreateDiscussionCommentResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsCreateDiscussionCommentResponseReactions;
    updated_at: string;
    url: string;
  };
  type TeamsCreateDiscussionResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
  };
  type TeamsCreateDiscussionResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsCreateDiscussionResponse = {
    author: TeamsCreateDiscussionResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsCreateDiscussionResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type TeamsCreateResponseOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
  };
  type TeamsCreateResponse = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsCreateResponseOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
  };
  type TeamsCheckManagesRepoLegacyResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type TeamsCheckManagesRepoLegacyResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsCheckManagesRepoLegacyResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: TeamsCheckManagesRepoLegacyResponseOwner;
    permissions: TeamsCheckManagesRepoLegacyResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type TeamsCheckManagesRepoInOrgResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type TeamsCheckManagesRepoInOrgResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsCheckManagesRepoInOrgResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: TeamsCheckManagesRepoInOrgResponseOwner;
    permissions: TeamsCheckManagesRepoInOrgResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type TeamsCheckManagesRepoResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type TeamsCheckManagesRepoResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type TeamsCheckManagesRepoResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: TeamsCheckManagesRepoResponseOwner;
    permissions: TeamsCheckManagesRepoResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type TeamsAddOrUpdateProjectLegacyResponse = {
    documentation_url: string;
    message: string;
  };
  type TeamsAddOrUpdateProjectInOrgResponse = {
    documentation_url: string;
    message: string;
  };
  type TeamsAddOrUpdateProjectResponse = {
    documentation_url: string;
    message: string;
  };
  type TeamsAddOrUpdateMembershipLegacyResponse = {
    role: string;
    state: string;
    url: string;
  };
  type TeamsAddOrUpdateMembershipInOrgResponse = {
    role: string;
    state: string;
    url: string;
  };
  type TeamsAddOrUpdateMembershipResponse = {
    role: string;
    state: string;
    url: string;
  };
  type TeamsAddMemberLegacyResponseErrorsItem = {
    code: string;
    field: string;
    resource: string;
  };
  type TeamsAddMemberLegacyResponse = {
    errors: Array<TeamsAddMemberLegacyResponseErrorsItem>;
    message: string;
  };
  type TeamsAddMemberResponseErrorsItem = {
    code: string;
    field: string;
    resource: string;
  };
  type TeamsAddMemberResponse = {
    errors: Array<TeamsAddMemberResponseErrorsItem>;
    message: string;
  };
  type SearchUsersLegacyResponseUsersItem = {
    created: string;
    created_at: string;
    followers: number;
    followers_count: number;
    fullname: string;
    gravatar_id: string;
    id: string;
    language: string;
    location: string;
    login: string;
    name: string;
    public_repo_count: number;
    repos: number;
    score: number;
    type: string;
    username: string;
  };
  type SearchUsersLegacyResponse = {
    users: Array<SearchUsersLegacyResponseUsersItem>;
  };
  type SearchUsersResponseItemsItem = {
    avatar_url: string;
    followers_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    score: number;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type SearchUsersResponse = {
    incomplete_results: boolean;
    items: Array<SearchUsersResponseItemsItem>;
    total_count: number;
  };
  type SearchTopicsResponseItemsItem = {
    created_at: string;
    created_by: string;
    curated: boolean;
    description: string;
    display_name: string;
    featured: boolean;
    name: string;
    released: string;
    score: number;
    short_description: string;
    updated_at: string;
  };
  type SearchTopicsResponse = {
    incomplete_results: boolean;
    items: Array<SearchTopicsResponseItemsItem>;
    total_count: number;
  };
  type SearchReposLegacyResponseRepositoriesItem = {
    created: string;
    created_at: string;
    description: string;
    followers: number;
    fork: boolean;
    forks: number;
    has_downloads: boolean;
    has_issues: boolean;
    has_wiki: boolean;
    homepage: string;
    language: string;
    name: string;
    open_issues: number;
    owner: string;
    private: boolean;
    pushed: string;
    pushed_at: string;
    score: number;
    size: number;
    type: string;
    url: string;
    username: string;
    watchers: number;
  };
  type SearchReposLegacyResponse = {
    repositories: Array<SearchReposLegacyResponseRepositoriesItem>;
  };
  type SearchReposResponseItemsItemOwner = {
    avatar_url: string;
    gravatar_id: string;
    id: number;
    login: string;
    node_id: string;
    received_events_url: string;
    type: string;
    url: string;
  };
  type SearchReposResponseItemsItem = {
    created_at: string;
    default_branch: string;
    description: string;
    fork: boolean;
    forks_count: number;
    full_name: string;
    homepage: string;
    html_url: string;
    id: number;
    language: string;
    master_branch: string;
    name: string;
    node_id: string;
    open_issues_count: number;
    owner: SearchReposResponseItemsItemOwner;
    private: boolean;
    pushed_at: string;
    score: number;
    size: number;
    stargazers_count: number;
    updated_at: string;
    url: string;
    watchers_count: number;
  };
  type SearchReposResponse = {
    incomplete_results: boolean;
    items: Array<SearchReposResponseItemsItem>;
    total_count: number;
  };
  type SearchLabelsResponseItemsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    score: number;
    url: string;
  };
  type SearchLabelsResponse = {
    incomplete_results: boolean;
    items: Array<SearchLabelsResponseItemsItem>;
    total_count: number;
  };
  type SearchIssuesLegacyResponseIssuesItem = {
    body: string;
    comments: number;
    created_at: string;
    gravatar_id: string;
    html_url: string;
    labels: Array<string>;
    number: number;
    position: number;
    state: string;
    title: string;
    updated_at: string;
    user: string;
    votes: number;
  };
  type SearchIssuesLegacyResponse = {
    issues: Array<SearchIssuesLegacyResponseIssuesItem>;
  };
  type SearchIssuesAndPullRequestsResponseItemsItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type SearchIssuesAndPullRequestsResponseItemsItemPullRequest = {
    diff_url: null;
    html_url: null;
    patch_url: null;
  };
  type SearchIssuesAndPullRequestsResponseItemsItemLabelsItem = {
    color: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type SearchIssuesAndPullRequestsResponseItemsItem = {
    assignee: null;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<SearchIssuesAndPullRequestsResponseItemsItemLabelsItem>;
    labels_url: string;
    milestone: null;
    node_id: string;
    number: number;
    pull_request: SearchIssuesAndPullRequestsResponseItemsItemPullRequest;
    repository_url: string;
    score: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: SearchIssuesAndPullRequestsResponseItemsItemUser;
  };
  type SearchIssuesAndPullRequestsResponse = {
    incomplete_results: boolean;
    items: Array<SearchIssuesAndPullRequestsResponseItemsItem>;
    total_count: number;
  };
  type SearchIssuesResponseItemsItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type SearchIssuesResponseItemsItemPullRequest = {
    diff_url: null;
    html_url: null;
    patch_url: null;
  };
  type SearchIssuesResponseItemsItemLabelsItem = {
    color: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type SearchIssuesResponseItemsItem = {
    assignee: null;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<SearchIssuesResponseItemsItemLabelsItem>;
    labels_url: string;
    milestone: null;
    node_id: string;
    number: number;
    pull_request: SearchIssuesResponseItemsItemPullRequest;
    repository_url: string;
    score: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: SearchIssuesResponseItemsItemUser;
  };
  type SearchIssuesResponse = {
    incomplete_results: boolean;
    items: Array<SearchIssuesResponseItemsItem>;
    total_count: number;
  };
  type SearchEmailLegacyResponseUser = {
    blog: string;
    company: string;
    created: string;
    created_at: string;
    email: string;
    followers_count: number;
    following_count: number;
    gravatar_id: string;
    id: number;
    location: string;
    login: string;
    name: string;
    public_gist_count: number;
    public_repo_count: number;
    type: string;
  };
  type SearchEmailLegacyResponse = { user: SearchEmailLegacyResponseUser };
  type SearchCommitsResponseItemsItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type SearchCommitsResponseItemsItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    hooks_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: SearchCommitsResponseItemsItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type SearchCommitsResponseItemsItemParentsItem = {
    html_url: string;
    sha: string;
    url: string;
  };
  type SearchCommitsResponseItemsItemCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type SearchCommitsResponseItemsItemCommitTree = { sha: string; url: string };
  type SearchCommitsResponseItemsItemCommitCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type SearchCommitsResponseItemsItemCommitAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type SearchCommitsResponseItemsItemCommit = {
    author: SearchCommitsResponseItemsItemCommitAuthor;
    comment_count: number;
    committer: SearchCommitsResponseItemsItemCommitCommitter;
    message: string;
    tree: SearchCommitsResponseItemsItemCommitTree;
    url: string;
  };
  type SearchCommitsResponseItemsItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type SearchCommitsResponseItemsItem = {
    author: SearchCommitsResponseItemsItemAuthor;
    comments_url: string;
    commit: SearchCommitsResponseItemsItemCommit;
    committer: SearchCommitsResponseItemsItemCommitter;
    html_url: string;
    parents: Array<SearchCommitsResponseItemsItemParentsItem>;
    repository: SearchCommitsResponseItemsItemRepository;
    score: number;
    sha: string;
    url: string;
  };
  type SearchCommitsResponse = {
    incomplete_results: boolean;
    items: Array<SearchCommitsResponseItemsItem>;
    total_count: number;
  };
  type SearchCodeResponseItemsItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type SearchCodeResponseItemsItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    hooks_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: SearchCodeResponseItemsItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type SearchCodeResponseItemsItem = {
    git_url: string;
    html_url: string;
    name: string;
    path: string;
    repository: SearchCodeResponseItemsItemRepository;
    score: number;
    sha: string;
    url: string;
  };
  type SearchCodeResponse = {
    incomplete_results: boolean;
    items: Array<SearchCodeResponseItemsItem>;
    total_count: number;
  };
  type ReposUploadReleaseAssetResponseValueUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUploadReleaseAssetResponseValue = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposUploadReleaseAssetResponseValueUploader;
    url: string;
  };
  type ReposUploadReleaseAssetResponse = {
    value: ReposUploadReleaseAssetResponseValue;
  };
  type ReposUpdateReleaseAssetResponseUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUpdateReleaseAssetResponse = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposUpdateReleaseAssetResponseUploader;
    url: string;
  };
  type ReposUpdateReleaseResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUpdateReleaseResponseAssetsItemUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUpdateReleaseResponseAssetsItem = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposUpdateReleaseResponseAssetsItemUploader;
    url: string;
  };
  type ReposUpdateReleaseResponse = {
    assets: Array<ReposUpdateReleaseResponseAssetsItem>;
    assets_url: string;
    author: ReposUpdateReleaseResponseAuthor;
    body: string;
    created_at: string;
    draft: boolean;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    prerelease: boolean;
    published_at: string;
    tag_name: string;
    tarball_url: string;
    target_commitish: string;
    upload_url: string;
    url: string;
    zipball_url: string;
  };
  type ReposUpdateProtectedBranchRequiredStatusChecksResponse = {
    contexts: Array<string>;
    contexts_url: string;
    strict: boolean;
    url: string;
  };
  type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictions = {
    teams: Array<
      ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsTeamsItem
    >;
    teams_url: string;
    url: string;
    users: Array<
      ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsUsersItem
    >;
    users_url: string;
  };
  type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponse = {
    dismiss_stale_reviews: boolean;
    dismissal_restrictions: ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictions;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
    url: string;
  };
  type ReposUpdateInvitationResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUpdateInvitationResponseRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ReposUpdateInvitationResponseRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ReposUpdateInvitationResponseInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUpdateInvitationResponseInvitee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUpdateInvitationResponse = {
    created_at: string;
    html_url: string;
    id: number;
    invitee: ReposUpdateInvitationResponseInvitee;
    inviter: ReposUpdateInvitationResponseInviter;
    permissions: string;
    repository: ReposUpdateInvitationResponseRepository;
    url: string;
  };
  type ReposUpdateHookResponseLastResponse = {
    code: null;
    message: null;
    status: string;
  };
  type ReposUpdateHookResponseConfig = {
    content_type: string;
    insecure_ssl: string;
    url: string;
  };
  type ReposUpdateHookResponse = {
    active: boolean;
    config: ReposUpdateHookResponseConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    last_response: ReposUpdateHookResponseLastResponse;
    name: string;
    ping_url: string;
    test_url: string;
    type: string;
    updated_at: string;
    url: string;
  };
  type ReposUpdateFileResponseContentLinks = {
    git: string;
    html: string;
    self: string;
  };
  type ReposUpdateFileResponseContent = {
    _links: ReposUpdateFileResponseContentLinks;
    download_url: string;
    git_url: string;
    html_url: string;
    name: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
  };
  type ReposUpdateFileResponseCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type ReposUpdateFileResponseCommitTree = { sha: string; url: string };
  type ReposUpdateFileResponseCommitParentsItem = {
    html_url: string;
    sha: string;
    url: string;
  };
  type ReposUpdateFileResponseCommitCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type ReposUpdateFileResponseCommitAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type ReposUpdateFileResponseCommit = {
    author: ReposUpdateFileResponseCommitAuthor;
    committer: ReposUpdateFileResponseCommitCommitter;
    html_url: string;
    message: string;
    node_id: string;
    parents: Array<ReposUpdateFileResponseCommitParentsItem>;
    sha: string;
    tree: ReposUpdateFileResponseCommitTree;
    url: string;
    verification: ReposUpdateFileResponseCommitVerification;
  };
  type ReposUpdateFileResponse = {
    commit: ReposUpdateFileResponseCommit;
    content: ReposUpdateFileResponseContent;
  };
  type ReposUpdateCommitCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUpdateCommitCommentResponse = {
    body: string;
    commit_id: string;
    created_at: string;
    html_url: string;
    id: number;
    line: number;
    node_id: string;
    path: string;
    position: number;
    updated_at: string;
    url: string;
    user: ReposUpdateCommitCommentResponseUser;
  };
  type ReposUpdateBranchProtectionResponseRestrictionsUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUpdateBranchProtectionResponseRestrictionsTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposUpdateBranchProtectionResponseRestrictionsAppsItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ReposUpdateBranchProtectionResponseRestrictionsAppsItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ReposUpdateBranchProtectionResponseRestrictionsAppsItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposUpdateBranchProtectionResponseRestrictionsAppsItemOwner;
    permissions: ReposUpdateBranchProtectionResponseRestrictionsAppsItemPermissions;
    slug: string;
    updated_at: string;
  };
  type ReposUpdateBranchProtectionResponseRestrictions = {
    apps: Array<ReposUpdateBranchProtectionResponseRestrictionsAppsItem>;
    apps_url: string;
    teams: Array<ReposUpdateBranchProtectionResponseRestrictionsTeamsItem>;
    teams_url: string;
    url: string;
    users: Array<ReposUpdateBranchProtectionResponseRestrictionsUsersItem>;
    users_url: string;
  };
  type ReposUpdateBranchProtectionResponseRequiredStatusChecks = {
    contexts: Array<string>;
    contexts_url: string;
    strict: boolean;
    url: string;
  };
  type ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictions = {
    teams: Array<
      ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsTeamsItem
    >;
    teams_url: string;
    url: string;
    users: Array<
      ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsUsersItem
    >;
    users_url: string;
  };
  type ReposUpdateBranchProtectionResponseRequiredPullRequestReviews = {
    dismiss_stale_reviews: boolean;
    dismissal_restrictions: ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictions;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
    url: string;
  };
  type ReposUpdateBranchProtectionResponseRequiredLinearHistory = {
    enabled: boolean;
  };
  type ReposUpdateBranchProtectionResponseEnforceAdmins = {
    enabled: boolean;
    url: string;
  };
  type ReposUpdateBranchProtectionResponseAllowForcePushes = {
    enabled: boolean;
  };
  type ReposUpdateBranchProtectionResponseAllowDeletions = { enabled: boolean };
  type ReposUpdateBranchProtectionResponse = {
    allow_deletions: ReposUpdateBranchProtectionResponseAllowDeletions;
    allow_force_pushes: ReposUpdateBranchProtectionResponseAllowForcePushes;
    enforce_admins: ReposUpdateBranchProtectionResponseEnforceAdmins;
    required_linear_history: ReposUpdateBranchProtectionResponseRequiredLinearHistory;
    required_pull_request_reviews: ReposUpdateBranchProtectionResponseRequiredPullRequestReviews;
    required_status_checks: ReposUpdateBranchProtectionResponseRequiredStatusChecks;
    restrictions: ReposUpdateBranchProtectionResponseRestrictions;
    url: string;
  };
  type ReposUpdateResponseSourcePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposUpdateResponseSourceOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUpdateResponseSource = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposUpdateResponseSourceOwner;
    permissions: ReposUpdateResponseSourcePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposUpdateResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposUpdateResponseParentPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposUpdateResponseParentOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUpdateResponseParent = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposUpdateResponseParentOwner;
    permissions: ReposUpdateResponseParentPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposUpdateResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUpdateResponseOrganization = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposUpdateResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    organization: ReposUpdateResponseOrganization;
    owner: ReposUpdateResponseOwner;
    parent: ReposUpdateResponseParent;
    permissions: ReposUpdateResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    source: ReposUpdateResponseSource;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposTransferResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposTransferResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposTransferResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposTransferResponseOwner;
    permissions: ReposTransferResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposRetrieveCommunityProfileMetricsResponseFilesReadme = {
    html_url: string;
    url: string;
  };
  type ReposRetrieveCommunityProfileMetricsResponseFilesPullRequestTemplate = {
    html_url: string;
    url: string;
  };
  type ReposRetrieveCommunityProfileMetricsResponseFilesLicense = {
    html_url: string;
    key: string;
    name: string;
    spdx_id: string;
    url: string;
  };
  type ReposRetrieveCommunityProfileMetricsResponseFilesIssueTemplate = {
    html_url: string;
    url: string;
  };
  type ReposRetrieveCommunityProfileMetricsResponseFilesContributing = {
    html_url: string;
    url: string;
  };
  type ReposRetrieveCommunityProfileMetricsResponseFilesCodeOfConduct = {
    html_url: string;
    key: string;
    name: string;
    url: string;
  };
  type ReposRetrieveCommunityProfileMetricsResponseFiles = {
    code_of_conduct: ReposRetrieveCommunityProfileMetricsResponseFilesCodeOfConduct;
    contributing: ReposRetrieveCommunityProfileMetricsResponseFilesContributing;
    issue_template: ReposRetrieveCommunityProfileMetricsResponseFilesIssueTemplate;
    license: ReposRetrieveCommunityProfileMetricsResponseFilesLicense;
    pull_request_template: ReposRetrieveCommunityProfileMetricsResponseFilesPullRequestTemplate;
    readme: ReposRetrieveCommunityProfileMetricsResponseFilesReadme;
  };
  type ReposRetrieveCommunityProfileMetricsResponse = {
    description: string;
    documentation: boolean;
    files: ReposRetrieveCommunityProfileMetricsResponseFiles;
    health_percentage: number;
    updated_at: string;
  };
  type ReposRequestPageBuildResponse = { status: string; url: string };
  type ReposReplaceTopicsResponse = { names: Array<string> };
  type ReposReplaceProtectedBranchUserRestrictionsResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposReplaceProtectedBranchTeamRestrictionsResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposReplaceProtectedBranchAppRestrictionsResponseItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ReposReplaceProtectedBranchAppRestrictionsResponseItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ReposReplaceProtectedBranchAppRestrictionsResponseItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposReplaceProtectedBranchAppRestrictionsResponseItemOwner;
    permissions: ReposReplaceProtectedBranchAppRestrictionsResponseItemPermissions;
    slug: string;
    updated_at: string;
  };
  type ReposRemoveProtectedBranchUserRestrictionsResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposRemoveProtectedBranchTeamRestrictionsResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposRemoveProtectedBranchAppRestrictionsResponseItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ReposRemoveProtectedBranchAppRestrictionsResponseItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ReposRemoveProtectedBranchAppRestrictionsResponseItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposRemoveProtectedBranchAppRestrictionsResponseItemOwner;
    permissions: ReposRemoveProtectedBranchAppRestrictionsResponseItemPermissions;
    slug: string;
    updated_at: string;
  };
  type ReposMergeResponseParentsItem = { sha: string; url: string };
  type ReposMergeResponseCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposMergeResponseCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type ReposMergeResponseCommitTree = { sha: string; url: string };
  type ReposMergeResponseCommitCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type ReposMergeResponseCommitAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type ReposMergeResponseCommit = {
    author: ReposMergeResponseCommitAuthor;
    comment_count: number;
    committer: ReposMergeResponseCommitCommitter;
    message: string;
    tree: ReposMergeResponseCommitTree;
    url: string;
    verification: ReposMergeResponseCommitVerification;
  };
  type ReposMergeResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposMergeResponse = {
    author: ReposMergeResponseAuthor;
    comments_url: string;
    commit: ReposMergeResponseCommit;
    committer: ReposMergeResponseCommitter;
    html_url: string;
    node_id: string;
    parents: Array<ReposMergeResponseParentsItem>;
    sha: string;
    url: string;
  };
  type ReposListUsersWithAccessToProtectedBranchResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListTopicsResponse = { names: Array<string> };
  type ReposListTeamsWithAccessToProtectedBranchResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposListTeamsResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposListTagsResponseItemCommit = { sha: string; url: string };
  type ReposListTagsResponseItem = {
    commit: ReposListTagsResponseItemCommit;
    name: string;
    tarball_url: string;
    zipball_url: string;
  };
  type ReposListStatusesForRefResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListStatusesForRefResponseItem = {
    avatar_url: string;
    context: string;
    created_at: string;
    creator: ReposListStatusesForRefResponseItemCreator;
    description: string;
    id: number;
    node_id: string;
    state: string;
    target_url: string;
    updated_at: string;
    url: string;
  };
  type ReposListReleasesResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListReleasesResponseItemAssetsItemUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListReleasesResponseItemAssetsItem = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposListReleasesResponseItemAssetsItemUploader;
    url: string;
  };
  type ReposListReleasesResponseItem = {
    assets: Array<ReposListReleasesResponseItemAssetsItem>;
    assets_url: string;
    author: ReposListReleasesResponseItemAuthor;
    body: string;
    created_at: string;
    draft: boolean;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    prerelease: boolean;
    published_at: string;
    tag_name: string;
    tarball_url: string;
    target_commitish: string;
    upload_url: string;
    url: string;
    zipball_url: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemRequestedTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemRequestedReviewersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: ReposListPullRequestsAssociatedWithCommitResponseItemMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemHeadUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemHeadRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemHeadRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemHeadRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposListPullRequestsAssociatedWithCommitResponseItemHeadRepoOwner;
    permissions: ReposListPullRequestsAssociatedWithCommitResponseItemHeadRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemHead = {
    label: string;
    ref: string;
    repo: ReposListPullRequestsAssociatedWithCommitResponseItemHeadRepo;
    sha: string;
    user: ReposListPullRequestsAssociatedWithCommitResponseItemHeadUser;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemBaseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemBaseRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemBaseRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemBaseRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposListPullRequestsAssociatedWithCommitResponseItemBaseRepoOwner;
    permissions: ReposListPullRequestsAssociatedWithCommitResponseItemBaseRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemBase = {
    label: string;
    ref: string;
    repo: ReposListPullRequestsAssociatedWithCommitResponseItemBaseRepo;
    sha: string;
    user: ReposListPullRequestsAssociatedWithCommitResponseItemBaseUser;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemLinksStatuses = {
    href: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemLinksSelf = {
    href: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemLinksReviewComments = {
    href: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemLinksReviewComment = {
    href: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemLinksIssue = {
    href: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemLinksHtml = {
    href: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemLinksCommits = {
    href: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemLinksComments = {
    href: string;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItemLinks = {
    comments: ReposListPullRequestsAssociatedWithCommitResponseItemLinksComments;
    commits: ReposListPullRequestsAssociatedWithCommitResponseItemLinksCommits;
    html: ReposListPullRequestsAssociatedWithCommitResponseItemLinksHtml;
    issue: ReposListPullRequestsAssociatedWithCommitResponseItemLinksIssue;
    review_comment: ReposListPullRequestsAssociatedWithCommitResponseItemLinksReviewComment;
    review_comments: ReposListPullRequestsAssociatedWithCommitResponseItemLinksReviewComments;
    self: ReposListPullRequestsAssociatedWithCommitResponseItemLinksSelf;
    statuses: ReposListPullRequestsAssociatedWithCommitResponseItemLinksStatuses;
  };
  type ReposListPullRequestsAssociatedWithCommitResponseItem = {
    _links: ReposListPullRequestsAssociatedWithCommitResponseItemLinks;
    active_lock_reason: string;
    assignee: ReposListPullRequestsAssociatedWithCommitResponseItemAssignee;
    assignees: Array<
      ReposListPullRequestsAssociatedWithCommitResponseItemAssigneesItem
    >;
    author_association: string;
    base: ReposListPullRequestsAssociatedWithCommitResponseItemBase;
    body: string;
    closed_at: string;
    comments_url: string;
    commits_url: string;
    created_at: string;
    diff_url: string;
    draft: boolean;
    head: ReposListPullRequestsAssociatedWithCommitResponseItemHead;
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<
      ReposListPullRequestsAssociatedWithCommitResponseItemLabelsItem
    >;
    locked: boolean;
    merge_commit_sha: string;
    merged_at: string;
    milestone: ReposListPullRequestsAssociatedWithCommitResponseItemMilestone;
    node_id: string;
    number: number;
    patch_url: string;
    requested_reviewers: Array<
      ReposListPullRequestsAssociatedWithCommitResponseItemRequestedReviewersItem
    >;
    requested_teams: Array<
      ReposListPullRequestsAssociatedWithCommitResponseItemRequestedTeamsItem
    >;
    review_comment_url: string;
    review_comments_url: string;
    state: string;
    statuses_url: string;
    title: string;
    updated_at: string;
    url: string;
    user: ReposListPullRequestsAssociatedWithCommitResponseItemUser;
  };
  type ReposListPublicResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListPublicResponseItem = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ReposListPublicResponseItemOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ReposListProtectedBranchUserRestrictionsResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListProtectedBranchTeamRestrictionsResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposListPagesBuildsResponseItemPusher = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListPagesBuildsResponseItemError = { message: null };
  type ReposListPagesBuildsResponseItem = {
    commit: string;
    created_at: string;
    duration: number;
    error: ReposListPagesBuildsResponseItemError;
    pusher: ReposListPagesBuildsResponseItemPusher;
    status: string;
    updated_at: string;
    url: string;
  };
  type ReposListLanguagesResponse = { C: number; Python: number };
  type ReposListInvitationsForAuthenticatedUserResponseItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListInvitationsForAuthenticatedUserResponseItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ReposListInvitationsForAuthenticatedUserResponseItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ReposListInvitationsForAuthenticatedUserResponseItemInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListInvitationsForAuthenticatedUserResponseItemInvitee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListInvitationsForAuthenticatedUserResponseItem = {
    created_at: string;
    html_url: string;
    id: number;
    invitee: ReposListInvitationsForAuthenticatedUserResponseItemInvitee;
    inviter: ReposListInvitationsForAuthenticatedUserResponseItemInviter;
    permissions: string;
    repository: ReposListInvitationsForAuthenticatedUserResponseItemRepository;
    url: string;
  };
  type ReposListInvitationsResponseItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListInvitationsResponseItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ReposListInvitationsResponseItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ReposListInvitationsResponseItemInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListInvitationsResponseItemInvitee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListInvitationsResponseItem = {
    created_at: string;
    html_url: string;
    id: number;
    invitee: ReposListInvitationsResponseItemInvitee;
    inviter: ReposListInvitationsResponseItemInviter;
    permissions: string;
    repository: ReposListInvitationsResponseItemRepository;
    url: string;
  };
  type ReposListHooksResponseItemLastResponse = {
    code: null;
    message: null;
    status: string;
  };
  type ReposListHooksResponseItemConfig = {
    content_type: string;
    insecure_ssl: string;
    url: string;
  };
  type ReposListHooksResponseItem = {
    active: boolean;
    config: ReposListHooksResponseItemConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    last_response: ReposListHooksResponseItemLastResponse;
    name: string;
    ping_url: string;
    test_url: string;
    type: string;
    updated_at: string;
    url: string;
  };
  type ReposListForksResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposListForksResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListForksResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
  };
  type ReposListForksResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: ReposListForksResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposListForksResponseItemOwner;
    permissions: ReposListForksResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposListForOrgResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposListForOrgResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListForOrgResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
  };
  type ReposListForOrgResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: ReposListForOrgResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposListForOrgResponseItemOwner;
    permissions: ReposListForOrgResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposListDownloadsResponseItem = {
    content_type: string;
    description: string;
    download_count: number;
    html_url: string;
    id: number;
    name: string;
    size: number;
    url: string;
  };
  type ReposListDeploymentsResponseItemPayload = { deploy: string };
  type ReposListDeploymentsResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListDeploymentsResponseItem = {
    created_at: string;
    creator: ReposListDeploymentsResponseItemCreator;
    description: string;
    environment: string;
    id: number;
    node_id: string;
    original_environment: string;
    payload: ReposListDeploymentsResponseItemPayload;
    production_environment: boolean;
    ref: string;
    repository_url: string;
    sha: string;
    statuses_url: string;
    task: string;
    transient_environment: boolean;
    updated_at: string;
    url: string;
  };
  type ReposListDeploymentStatusesResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListDeploymentStatusesResponseItem = {
    created_at: string;
    creator: ReposListDeploymentStatusesResponseItemCreator;
    deployment_url: string;
    description: string;
    environment: string;
    environment_url: string;
    id: number;
    log_url: string;
    node_id: string;
    repository_url: string;
    state: string;
    target_url: string;
    updated_at: string;
    url: string;
  };
  type ReposListDeployKeysResponseItem = {
    created_at: string;
    id: number;
    key: string;
    read_only: boolean;
    title: string;
    url: string;
    verified: boolean;
  };
  type ReposListContributorsResponseItem = {
    avatar_url: string;
    contributions: number;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListCommitsResponseItemParentsItem = { sha: string; url: string };
  type ReposListCommitsResponseItemCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListCommitsResponseItemCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type ReposListCommitsResponseItemCommitTree = { sha: string; url: string };
  type ReposListCommitsResponseItemCommitCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type ReposListCommitsResponseItemCommitAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type ReposListCommitsResponseItemCommit = {
    author: ReposListCommitsResponseItemCommitAuthor;
    comment_count: number;
    committer: ReposListCommitsResponseItemCommitCommitter;
    message: string;
    tree: ReposListCommitsResponseItemCommitTree;
    url: string;
    verification: ReposListCommitsResponseItemCommitVerification;
  };
  type ReposListCommitsResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListCommitsResponseItem = {
    author: ReposListCommitsResponseItemAuthor;
    comments_url: string;
    commit: ReposListCommitsResponseItemCommit;
    committer: ReposListCommitsResponseItemCommitter;
    html_url: string;
    node_id: string;
    parents: Array<ReposListCommitsResponseItemParentsItem>;
    sha: string;
    url: string;
  };
  type ReposListCommitCommentsResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListCommitCommentsResponseItem = {
    body: string;
    commit_id: string;
    created_at: string;
    html_url: string;
    id: number;
    line: number;
    node_id: string;
    path: string;
    position: number;
    updated_at: string;
    url: string;
    user: ReposListCommitCommentsResponseItemUser;
  };
  type ReposListCommentsForCommitResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListCommentsForCommitResponseItem = {
    body: string;
    commit_id: string;
    created_at: string;
    html_url: string;
    id: number;
    line: number;
    node_id: string;
    path: string;
    position: number;
    updated_at: string;
    url: string;
    user: ReposListCommentsForCommitResponseItemUser;
  };
  type ReposListCollaboratorsResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposListCollaboratorsResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    permissions: ReposListCollaboratorsResponseItemPermissions;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListBranchesForHeadCommitResponseItemCommit = {
    sha: string;
    url: string;
  };
  type ReposListBranchesForHeadCommitResponseItem = {
    commit: ReposListBranchesForHeadCommitResponseItemCommit;
    name: string;
    protected: string;
  };
  type ReposListBranchesResponseItemProtectionRequiredStatusChecks = {
    contexts: Array<string>;
    enforcement_level: string;
  };
  type ReposListBranchesResponseItemProtection = {
    enabled: boolean;
    required_status_checks: ReposListBranchesResponseItemProtectionRequiredStatusChecks;
  };
  type ReposListBranchesResponseItemCommit = { sha: string; url: string };
  type ReposListBranchesResponseItem = {
    commit: ReposListBranchesResponseItemCommit;
    name: string;
    protected: boolean;
    protection: ReposListBranchesResponseItemProtection;
    protection_url: string;
  };
  type ReposListAssetsForReleaseResponseItemUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposListAssetsForReleaseResponseItem = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposListAssetsForReleaseResponseItemUploader;
    url: string;
  };
  type ReposListAppsWithAccessToProtectedBranchResponseItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ReposListAppsWithAccessToProtectedBranchResponseItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ReposListAppsWithAccessToProtectedBranchResponseItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposListAppsWithAccessToProtectedBranchResponseItemOwner;
    permissions: ReposListAppsWithAccessToProtectedBranchResponseItemPermissions;
    slug: string;
    updated_at: string;
  };
  type ReposGetViewsResponseViewsItem = {
    count: number;
    timestamp: string;
    uniques: number;
  };
  type ReposGetViewsResponse = {
    count: number;
    uniques: number;
    views: Array<ReposGetViewsResponseViewsItem>;
  };
  type ReposGetUsersWithAccessToProtectedBranchResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetTopReferrersResponseItem = {
    count: number;
    referrer: string;
    uniques: number;
  };
  type ReposGetTopPathsResponseItem = {
    count: number;
    path: string;
    title: string;
    uniques: number;
  };
  type ReposGetTeamsWithAccessToProtectedBranchResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposGetReleaseByTagResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetReleaseByTagResponseAssetsItemUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetReleaseByTagResponseAssetsItem = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposGetReleaseByTagResponseAssetsItemUploader;
    url: string;
  };
  type ReposGetReleaseByTagResponse = {
    assets: Array<ReposGetReleaseByTagResponseAssetsItem>;
    assets_url: string;
    author: ReposGetReleaseByTagResponseAuthor;
    body: string;
    created_at: string;
    draft: boolean;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    prerelease: boolean;
    published_at: string;
    tag_name: string;
    tarball_url: string;
    target_commitish: string;
    upload_url: string;
    url: string;
    zipball_url: string;
  };
  type ReposGetReleaseAssetResponseUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetReleaseAssetResponse = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposGetReleaseAssetResponseUploader;
    url: string;
  };
  type ReposGetReleaseResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetReleaseResponseAssetsItemUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetReleaseResponseAssetsItem = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposGetReleaseResponseAssetsItemUploader;
    url: string;
  };
  type ReposGetReleaseResponse = {
    assets: Array<ReposGetReleaseResponseAssetsItem>;
    assets_url: string;
    author: ReposGetReleaseResponseAuthor;
    body: string;
    created_at: string;
    draft: boolean;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    prerelease: boolean;
    published_at: string;
    tag_name: string;
    tarball_url: string;
    target_commitish: string;
    upload_url: string;
    url: string;
    zipball_url: string;
  };
  type ReposGetReadmeResponseLinks = {
    git: string;
    html: string;
    self: string;
  };
  type ReposGetReadmeResponse = {
    _links: ReposGetReadmeResponseLinks;
    content: string;
    download_url: string;
    encoding: string;
    git_url: string;
    html_url: string;
    name: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
  };
  type ReposGetProtectedBranchRestrictionsResponseUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetProtectedBranchRestrictionsResponseTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposGetProtectedBranchRestrictionsResponseAppsItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ReposGetProtectedBranchRestrictionsResponseAppsItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ReposGetProtectedBranchRestrictionsResponseAppsItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposGetProtectedBranchRestrictionsResponseAppsItemOwner;
    permissions: ReposGetProtectedBranchRestrictionsResponseAppsItemPermissions;
    slug: string;
    updated_at: string;
  };
  type ReposGetProtectedBranchRestrictionsResponse = {
    apps: Array<ReposGetProtectedBranchRestrictionsResponseAppsItem>;
    apps_url: string;
    teams: Array<ReposGetProtectedBranchRestrictionsResponseTeamsItem>;
    teams_url: string;
    url: string;
    users: Array<ReposGetProtectedBranchRestrictionsResponseUsersItem>;
    users_url: string;
  };
  type ReposGetProtectedBranchRequiredStatusChecksResponse = {
    contexts: Array<string>;
    contexts_url: string;
    strict: boolean;
    url: string;
  };
  type ReposGetProtectedBranchRequiredSignaturesResponse = {
    enabled: boolean;
    url: string;
  };
  type ReposGetProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposGetProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictions = {
    teams: Array<
      ReposGetProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsTeamsItem
    >;
    teams_url: string;
    url: string;
    users: Array<
      ReposGetProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsUsersItem
    >;
    users_url: string;
  };
  type ReposGetProtectedBranchPullRequestReviewEnforcementResponse = {
    dismiss_stale_reviews: boolean;
    dismissal_restrictions: ReposGetProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictions;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
    url: string;
  };
  type ReposGetProtectedBranchAdminEnforcementResponse = {
    enabled: boolean;
    url: string;
  };
  type ReposGetParticipationStatsResponse = {
    all: Array<number>;
    owner: Array<number>;
  };
  type ReposGetPagesBuildResponsePusher = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetPagesBuildResponseError = { message: null };
  type ReposGetPagesBuildResponse = {
    commit: string;
    created_at: string;
    duration: number;
    error: ReposGetPagesBuildResponseError;
    pusher: ReposGetPagesBuildResponsePusher;
    status: string;
    updated_at: string;
    url: string;
  };
  type ReposGetPagesResponseSource = { branch: string; directory: string };
  type ReposGetPagesResponse = {
    cname: string;
    custom_404: boolean;
    html_url: string;
    source: ReposGetPagesResponseSource;
    status: string;
    url: string;
  };
  type ReposGetLatestReleaseResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetLatestReleaseResponseAssetsItemUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetLatestReleaseResponseAssetsItem = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposGetLatestReleaseResponseAssetsItemUploader;
    url: string;
  };
  type ReposGetLatestReleaseResponse = {
    assets: Array<ReposGetLatestReleaseResponseAssetsItem>;
    assets_url: string;
    author: ReposGetLatestReleaseResponseAuthor;
    body: string;
    created_at: string;
    draft: boolean;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    prerelease: boolean;
    published_at: string;
    tag_name: string;
    tarball_url: string;
    target_commitish: string;
    upload_url: string;
    url: string;
    zipball_url: string;
  };
  type ReposGetLatestPagesBuildResponsePusher = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetLatestPagesBuildResponseError = { message: null };
  type ReposGetLatestPagesBuildResponse = {
    commit: string;
    created_at: string;
    duration: number;
    error: ReposGetLatestPagesBuildResponseError;
    pusher: ReposGetLatestPagesBuildResponsePusher;
    status: string;
    updated_at: string;
    url: string;
  };
  type ReposGetHookResponseLastResponse = {
    code: null;
    message: null;
    status: string;
  };
  type ReposGetHookResponseConfig = {
    content_type: string;
    insecure_ssl: string;
    url: string;
  };
  type ReposGetHookResponse = {
    active: boolean;
    config: ReposGetHookResponseConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    last_response: ReposGetHookResponseLastResponse;
    name: string;
    ping_url: string;
    test_url: string;
    type: string;
    updated_at: string;
    url: string;
  };
  type ReposGetDownloadResponse = {
    content_type: string;
    description: string;
    download_count: number;
    html_url: string;
    id: number;
    name: string;
    size: number;
    url: string;
  };
  type ReposGetDeploymentStatusResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetDeploymentStatusResponse = {
    created_at: string;
    creator: ReposGetDeploymentStatusResponseCreator;
    deployment_url: string;
    description: string;
    environment: string;
    environment_url: string;
    id: number;
    log_url: string;
    node_id: string;
    repository_url: string;
    state: string;
    target_url: string;
    updated_at: string;
    url: string;
  };
  type ReposGetDeploymentResponsePayload = { deploy: string };
  type ReposGetDeploymentResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetDeploymentResponse = {
    created_at: string;
    creator: ReposGetDeploymentResponseCreator;
    description: string;
    environment: string;
    id: number;
    node_id: string;
    original_environment: string;
    payload: ReposGetDeploymentResponsePayload;
    production_environment: boolean;
    ref: string;
    repository_url: string;
    sha: string;
    statuses_url: string;
    task: string;
    transient_environment: boolean;
    updated_at: string;
    url: string;
  };
  type ReposGetDeployKeyResponse = {
    created_at: string;
    id: number;
    key: string;
    read_only: boolean;
    title: string;
    url: string;
    verified: boolean;
  };
  type ReposGetContributorsStatsResponseItemWeeksItem = {
    a: number;
    c: number;
    d: number;
    w: string;
  };
  type ReposGetContributorsStatsResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetContributorsStatsResponseItem = {
    author: ReposGetContributorsStatsResponseItemAuthor;
    total: number;
    weeks: Array<ReposGetContributorsStatsResponseItemWeeksItem>;
  };
  type ReposGetContentsResponseItemLinks = {
    git: string;
    html: string;
    self: string;
  };
  type ReposGetContentsResponseItem = {
    _links: ReposGetContentsResponseItemLinks;
    download_url: string | null;
    git_url: string;
    html_url: string;
    name: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
  };
  type ReposGetContentsResponseLinks = {
    git: string;
    html: string;
    self: string;
  };
  type ReposGetContentsResponse =
    | {
        _links: ReposGetContentsResponseLinks;
        content?: string;
        download_url: string | null;
        encoding?: string;
        git_url: string;
        html_url: string;
        name: string;
        path: string;
        sha: string;
        size: number;
        type: string;
        url: string;
        target?: string;
        submodule_git_url?: string;
      }
    | Array<ReposGetContentsResponseItem>;
  type ReposGetCommitCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetCommitCommentResponse = {
    body: string;
    commit_id: string;
    created_at: string;
    html_url: string;
    id: number;
    line: number;
    node_id: string;
    path: string;
    position: number;
    updated_at: string;
    url: string;
    user: ReposGetCommitCommentResponseUser;
  };
  type ReposGetCommitActivityStatsResponseItem = {
    days: Array<number>;
    total: number;
    week: number;
  };
  type ReposGetCommitResponseStats = {
    additions: number;
    deletions: number;
    total: number;
  };
  type ReposGetCommitResponseParentsItem = { sha: string; url: string };
  type ReposGetCommitResponseFilesItem = {
    additions: number;
    blob_url: string;
    changes: number;
    deletions: number;
    filename: string;
    patch: string;
    raw_url: string;
    status: string;
  };
  type ReposGetCommitResponseCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetCommitResponseCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type ReposGetCommitResponseCommitTree = { sha: string; url: string };
  type ReposGetCommitResponseCommitCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type ReposGetCommitResponseCommitAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type ReposGetCommitResponseCommit = {
    author: ReposGetCommitResponseCommitAuthor;
    comment_count: number;
    committer: ReposGetCommitResponseCommitCommitter;
    message: string;
    tree: ReposGetCommitResponseCommitTree;
    url: string;
    verification: ReposGetCommitResponseCommitVerification;
  };
  type ReposGetCommitResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetCommitResponse = {
    author: ReposGetCommitResponseAuthor;
    comments_url: string;
    commit: ReposGetCommitResponseCommit;
    committer: ReposGetCommitResponseCommitter;
    files: Array<ReposGetCommitResponseFilesItem>;
    html_url: string;
    node_id: string;
    parents: Array<ReposGetCommitResponseParentsItem>;
    sha: string;
    stats: ReposGetCommitResponseStats;
    url: string;
  };
  type ReposGetCombinedStatusForRefResponseStatusesItem = {
    avatar_url: string;
    context: string;
    created_at: string;
    description: string;
    id: number;
    node_id: string;
    state: string;
    target_url: string;
    updated_at: string;
    url: string;
  };
  type ReposGetCombinedStatusForRefResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetCombinedStatusForRefResponseRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ReposGetCombinedStatusForRefResponseRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ReposGetCombinedStatusForRefResponse = {
    commit_url: string;
    repository: ReposGetCombinedStatusForRefResponseRepository;
    sha: string;
    state: string;
    statuses: Array<ReposGetCombinedStatusForRefResponseStatusesItem>;
    total_count: number;
    url: string;
  };
  type ReposGetCollaboratorPermissionLevelResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetCollaboratorPermissionLevelResponse = {
    permission: string;
    user: ReposGetCollaboratorPermissionLevelResponseUser;
  };
  type ReposGetClonesResponseClonesItem = {
    count: number;
    timestamp: string;
    uniques: number;
  };
  type ReposGetClonesResponse = {
    clones: Array<ReposGetClonesResponseClonesItem>;
    count: number;
    uniques: number;
  };
  type ReposGetBranchProtectionResponseRestrictionsUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetBranchProtectionResponseRestrictionsTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposGetBranchProtectionResponseRestrictionsAppsItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ReposGetBranchProtectionResponseRestrictionsAppsItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ReposGetBranchProtectionResponseRestrictionsAppsItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposGetBranchProtectionResponseRestrictionsAppsItemOwner;
    permissions: ReposGetBranchProtectionResponseRestrictionsAppsItemPermissions;
    slug: string;
    updated_at: string;
  };
  type ReposGetBranchProtectionResponseRestrictions = {
    apps: Array<ReposGetBranchProtectionResponseRestrictionsAppsItem>;
    apps_url: string;
    teams: Array<ReposGetBranchProtectionResponseRestrictionsTeamsItem>;
    teams_url: string;
    url: string;
    users: Array<ReposGetBranchProtectionResponseRestrictionsUsersItem>;
    users_url: string;
  };
  type ReposGetBranchProtectionResponseRequiredStatusChecks = {
    contexts: Array<string>;
    contexts_url: string;
    strict: boolean;
    url: string;
  };
  type ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictions = {
    teams: Array<
      ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsTeamsItem
    >;
    teams_url: string;
    url: string;
    users: Array<
      ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsUsersItem
    >;
    users_url: string;
  };
  type ReposGetBranchProtectionResponseRequiredPullRequestReviews = {
    dismiss_stale_reviews: boolean;
    dismissal_restrictions: ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictions;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
    url: string;
  };
  type ReposGetBranchProtectionResponseRequiredLinearHistory = {
    enabled: boolean;
  };
  type ReposGetBranchProtectionResponseEnforceAdmins = {
    enabled: boolean;
    url: string;
  };
  type ReposGetBranchProtectionResponseAllowForcePushes = { enabled: boolean };
  type ReposGetBranchProtectionResponseAllowDeletions = { enabled: boolean };
  type ReposGetBranchProtectionResponse = {
    allow_deletions: ReposGetBranchProtectionResponseAllowDeletions;
    allow_force_pushes: ReposGetBranchProtectionResponseAllowForcePushes;
    enforce_admins: ReposGetBranchProtectionResponseEnforceAdmins;
    required_linear_history: ReposGetBranchProtectionResponseRequiredLinearHistory;
    required_pull_request_reviews: ReposGetBranchProtectionResponseRequiredPullRequestReviews;
    required_status_checks: ReposGetBranchProtectionResponseRequiredStatusChecks;
    restrictions: ReposGetBranchProtectionResponseRestrictions;
    url: string;
  };
  type ReposGetBranchResponseProtectionRequiredStatusChecks = {
    contexts: Array<string>;
    enforcement_level: string;
  };
  type ReposGetBranchResponseProtection = {
    enabled: boolean;
    required_status_checks: ReposGetBranchResponseProtectionRequiredStatusChecks;
  };
  type ReposGetBranchResponseCommitParentsItem = { sha: string; url: string };
  type ReposGetBranchResponseCommitCommitter = {
    avatar_url: string;
    gravatar_id: string;
    id: number;
    login: string;
    url: string;
  };
  type ReposGetBranchResponseCommitCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type ReposGetBranchResponseCommitCommitTree = { sha: string; url: string };
  type ReposGetBranchResponseCommitCommitCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type ReposGetBranchResponseCommitCommitAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type ReposGetBranchResponseCommitCommit = {
    author: ReposGetBranchResponseCommitCommitAuthor;
    committer: ReposGetBranchResponseCommitCommitCommitter;
    message: string;
    tree: ReposGetBranchResponseCommitCommitTree;
    url: string;
    verification: ReposGetBranchResponseCommitCommitVerification;
  };
  type ReposGetBranchResponseCommitAuthor = {
    avatar_url: string;
    gravatar_id: string;
    id: number;
    login: string;
    url: string;
  };
  type ReposGetBranchResponseCommit = {
    author: ReposGetBranchResponseCommitAuthor;
    commit: ReposGetBranchResponseCommitCommit;
    committer: ReposGetBranchResponseCommitCommitter;
    node_id: string;
    parents: Array<ReposGetBranchResponseCommitParentsItem>;
    sha: string;
    url: string;
  };
  type ReposGetBranchResponseLinks = { html: string; self: string };
  type ReposGetBranchResponse = {
    _links: ReposGetBranchResponseLinks;
    commit: ReposGetBranchResponseCommit;
    name: string;
    protected: boolean;
    protection: ReposGetBranchResponseProtection;
    protection_url: string;
  };
  type ReposGetAppsWithAccessToProtectedBranchResponseItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ReposGetAppsWithAccessToProtectedBranchResponseItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ReposGetAppsWithAccessToProtectedBranchResponseItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposGetAppsWithAccessToProtectedBranchResponseItemOwner;
    permissions: ReposGetAppsWithAccessToProtectedBranchResponseItemPermissions;
    slug: string;
    updated_at: string;
  };
  type ReposGetResponseSourcePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposGetResponseSourceOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetResponseSource = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposGetResponseSourceOwner;
    permissions: ReposGetResponseSourcePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposGetResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposGetResponseParentPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposGetResponseParentOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetResponseParent = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposGetResponseParentOwner;
    permissions: ReposGetResponseParentPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposGetResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetResponseOrganization = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposGetResponseLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
  };
  type ReposGetResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: ReposGetResponseLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    organization: ReposGetResponseOrganization;
    owner: ReposGetResponseOwner;
    parent: ReposGetResponseParent;
    permissions: ReposGetResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    source: ReposGetResponseSource;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposEnablePagesSiteResponseSource = {
    branch: string;
    directory: string;
  };
  type ReposEnablePagesSiteResponse = {
    cname: string;
    custom_404: boolean;
    html_url: string;
    source: ReposEnablePagesSiteResponseSource;
    status: string;
    url: string;
  };
  type ReposDeleteFileResponseCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type ReposDeleteFileResponseCommitTree = { sha: string; url: string };
  type ReposDeleteFileResponseCommitParentsItem = {
    html_url: string;
    sha: string;
    url: string;
  };
  type ReposDeleteFileResponseCommitCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type ReposDeleteFileResponseCommitAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type ReposDeleteFileResponseCommit = {
    author: ReposDeleteFileResponseCommitAuthor;
    committer: ReposDeleteFileResponseCommitCommitter;
    html_url: string;
    message: string;
    node_id: string;
    parents: Array<ReposDeleteFileResponseCommitParentsItem>;
    sha: string;
    tree: ReposDeleteFileResponseCommitTree;
    url: string;
    verification: ReposDeleteFileResponseCommitVerification;
  };
  type ReposDeleteFileResponse = {
    commit: ReposDeleteFileResponseCommit;
    content: null;
  };
  type ReposDeleteResponse = { documentation_url: string; message: string };
  type ReposCreateUsingTemplateResponseTemplateRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposCreateUsingTemplateResponseTemplateRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCreateUsingTemplateResponseTemplateRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposCreateUsingTemplateResponseTemplateRepositoryOwner;
    permissions: ReposCreateUsingTemplateResponseTemplateRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposCreateUsingTemplateResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposCreateUsingTemplateResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCreateUsingTemplateResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposCreateUsingTemplateResponseOwner;
    permissions: ReposCreateUsingTemplateResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: ReposCreateUsingTemplateResponseTemplateRepository;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposCreateStatusResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCreateStatusResponse = {
    avatar_url: string;
    context: string;
    created_at: string;
    creator: ReposCreateStatusResponseCreator;
    description: string;
    id: number;
    node_id: string;
    state: string;
    target_url: string;
    updated_at: string;
    url: string;
  };
  type ReposCreateReleaseResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCreateReleaseResponse = {
    assets: Array<any>;
    assets_url: string;
    author: ReposCreateReleaseResponseAuthor;
    body: string;
    created_at: string;
    draft: boolean;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    prerelease: boolean;
    published_at: string;
    tag_name: string;
    tarball_url: string;
    target_commitish: string;
    upload_url: string;
    url: string;
    zipball_url: string;
  };
  type ReposCreateOrUpdateFileResponseContentLinks = {
    git: string;
    html: string;
    self: string;
  };
  type ReposCreateOrUpdateFileResponseContent = {
    _links: ReposCreateOrUpdateFileResponseContentLinks;
    download_url: string;
    git_url: string;
    html_url: string;
    name: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
  };
  type ReposCreateOrUpdateFileResponseCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type ReposCreateOrUpdateFileResponseCommitTree = { sha: string; url: string };
  type ReposCreateOrUpdateFileResponseCommitParentsItem = {
    html_url: string;
    sha: string;
    url: string;
  };
  type ReposCreateOrUpdateFileResponseCommitCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type ReposCreateOrUpdateFileResponseCommitAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type ReposCreateOrUpdateFileResponseCommit = {
    author: ReposCreateOrUpdateFileResponseCommitAuthor;
    committer: ReposCreateOrUpdateFileResponseCommitCommitter;
    html_url: string;
    message: string;
    node_id: string;
    parents: Array<ReposCreateOrUpdateFileResponseCommitParentsItem>;
    sha: string;
    tree: ReposCreateOrUpdateFileResponseCommitTree;
    url: string;
    verification: ReposCreateOrUpdateFileResponseCommitVerification;
  };
  type ReposCreateOrUpdateFileResponse = {
    commit: ReposCreateOrUpdateFileResponseCommit;
    content: ReposCreateOrUpdateFileResponseContent;
  };
  type ReposCreateInOrgResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposCreateInOrgResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCreateInOrgResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposCreateInOrgResponseOwner;
    permissions: ReposCreateInOrgResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposCreateHookResponseLastResponse = {
    code: null;
    message: null;
    status: string;
  };
  type ReposCreateHookResponseConfig = {
    content_type: string;
    insecure_ssl: string;
    url: string;
  };
  type ReposCreateHookResponse = {
    active: boolean;
    config: ReposCreateHookResponseConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    last_response: ReposCreateHookResponseLastResponse;
    name: string;
    ping_url: string;
    test_url: string;
    type: string;
    updated_at: string;
    url: string;
  };
  type ReposCreateForkResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposCreateForkResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCreateForkResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposCreateForkResponseOwner;
    permissions: ReposCreateForkResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposCreateForAuthenticatedUserResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ReposCreateForAuthenticatedUserResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCreateForAuthenticatedUserResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposCreateForAuthenticatedUserResponseOwner;
    permissions: ReposCreateForAuthenticatedUserResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ReposCreateFileResponseContentLinks = {
    git: string;
    html: string;
    self: string;
  };
  type ReposCreateFileResponseContent = {
    _links: ReposCreateFileResponseContentLinks;
    download_url: string;
    git_url: string;
    html_url: string;
    name: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
  };
  type ReposCreateFileResponseCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type ReposCreateFileResponseCommitTree = { sha: string; url: string };
  type ReposCreateFileResponseCommitParentsItem = {
    html_url: string;
    sha: string;
    url: string;
  };
  type ReposCreateFileResponseCommitCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type ReposCreateFileResponseCommitAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type ReposCreateFileResponseCommit = {
    author: ReposCreateFileResponseCommitAuthor;
    committer: ReposCreateFileResponseCommitCommitter;
    html_url: string;
    message: string;
    node_id: string;
    parents: Array<ReposCreateFileResponseCommitParentsItem>;
    sha: string;
    tree: ReposCreateFileResponseCommitTree;
    url: string;
    verification: ReposCreateFileResponseCommitVerification;
  };
  type ReposCreateFileResponse = {
    commit: ReposCreateFileResponseCommit;
    content: ReposCreateFileResponseContent;
  };
  type ReposCreateDeploymentStatusResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCreateDeploymentStatusResponse = {
    created_at: string;
    creator: ReposCreateDeploymentStatusResponseCreator;
    deployment_url: string;
    description: string;
    environment: string;
    environment_url: string;
    id: number;
    log_url: string;
    node_id: string;
    repository_url: string;
    state: string;
    target_url: string;
    updated_at: string;
    url: string;
  };
  type ReposCreateDeploymentResponsePayload = { deploy: string };
  type ReposCreateDeploymentResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCreateDeploymentResponse = {
    created_at: string;
    creator: ReposCreateDeploymentResponseCreator;
    description: string;
    environment: string;
    id: number;
    node_id: string;
    original_environment: string;
    payload: ReposCreateDeploymentResponsePayload;
    production_environment: boolean;
    ref: string;
    repository_url: string;
    sha: string;
    statuses_url: string;
    task: string;
    transient_environment: boolean;
    updated_at: string;
    url: string;
  };
  type ReposCreateCommitCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCreateCommitCommentResponse = {
    body: string;
    commit_id: string;
    created_at: string;
    html_url: string;
    id: number;
    line: number;
    node_id: string;
    path: string;
    position: number;
    updated_at: string;
    url: string;
    user: ReposCreateCommitCommentResponseUser;
  };
  type ReposCompareCommitsResponseMergeBaseCommitParentsItem = {
    sha: string;
    url: string;
  };
  type ReposCompareCommitsResponseMergeBaseCommitCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCompareCommitsResponseMergeBaseCommitCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type ReposCompareCommitsResponseMergeBaseCommitCommitTree = {
    sha: string;
    url: string;
  };
  type ReposCompareCommitsResponseMergeBaseCommitCommitCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type ReposCompareCommitsResponseMergeBaseCommitCommitAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type ReposCompareCommitsResponseMergeBaseCommitCommit = {
    author: ReposCompareCommitsResponseMergeBaseCommitCommitAuthor;
    comment_count: number;
    committer: ReposCompareCommitsResponseMergeBaseCommitCommitCommitter;
    message: string;
    tree: ReposCompareCommitsResponseMergeBaseCommitCommitTree;
    url: string;
    verification: ReposCompareCommitsResponseMergeBaseCommitCommitVerification;
  };
  type ReposCompareCommitsResponseMergeBaseCommitAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCompareCommitsResponseMergeBaseCommit = {
    author: ReposCompareCommitsResponseMergeBaseCommitAuthor;
    comments_url: string;
    commit: ReposCompareCommitsResponseMergeBaseCommitCommit;
    committer: ReposCompareCommitsResponseMergeBaseCommitCommitter;
    html_url: string;
    node_id: string;
    parents: Array<ReposCompareCommitsResponseMergeBaseCommitParentsItem>;
    sha: string;
    url: string;
  };
  type ReposCompareCommitsResponseFilesItem = {
    additions: number;
    blob_url: string;
    changes: number;
    contents_url: string;
    deletions: number;
    filename: string;
    patch: string;
    raw_url: string;
    sha: string;
    status: string;
  };
  type ReposCompareCommitsResponseCommitsItemParentsItem = {
    sha: string;
    url: string;
  };
  type ReposCompareCommitsResponseCommitsItemCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCompareCommitsResponseCommitsItemCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type ReposCompareCommitsResponseCommitsItemCommitTree = {
    sha: string;
    url: string;
  };
  type ReposCompareCommitsResponseCommitsItemCommitCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type ReposCompareCommitsResponseCommitsItemCommitAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type ReposCompareCommitsResponseCommitsItemCommit = {
    author: ReposCompareCommitsResponseCommitsItemCommitAuthor;
    comment_count: number;
    committer: ReposCompareCommitsResponseCommitsItemCommitCommitter;
    message: string;
    tree: ReposCompareCommitsResponseCommitsItemCommitTree;
    url: string;
    verification: ReposCompareCommitsResponseCommitsItemCommitVerification;
  };
  type ReposCompareCommitsResponseCommitsItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCompareCommitsResponseCommitsItem = {
    author: ReposCompareCommitsResponseCommitsItemAuthor;
    comments_url: string;
    commit: ReposCompareCommitsResponseCommitsItemCommit;
    committer: ReposCompareCommitsResponseCommitsItemCommitter;
    html_url: string;
    node_id: string;
    parents: Array<ReposCompareCommitsResponseCommitsItemParentsItem>;
    sha: string;
    url: string;
  };
  type ReposCompareCommitsResponseBaseCommitParentsItem = {
    sha: string;
    url: string;
  };
  type ReposCompareCommitsResponseBaseCommitCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCompareCommitsResponseBaseCommitCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type ReposCompareCommitsResponseBaseCommitCommitTree = {
    sha: string;
    url: string;
  };
  type ReposCompareCommitsResponseBaseCommitCommitCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type ReposCompareCommitsResponseBaseCommitCommitAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type ReposCompareCommitsResponseBaseCommitCommit = {
    author: ReposCompareCommitsResponseBaseCommitCommitAuthor;
    comment_count: number;
    committer: ReposCompareCommitsResponseBaseCommitCommitCommitter;
    message: string;
    tree: ReposCompareCommitsResponseBaseCommitCommitTree;
    url: string;
    verification: ReposCompareCommitsResponseBaseCommitCommitVerification;
  };
  type ReposCompareCommitsResponseBaseCommitAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposCompareCommitsResponseBaseCommit = {
    author: ReposCompareCommitsResponseBaseCommitAuthor;
    comments_url: string;
    commit: ReposCompareCommitsResponseBaseCommitCommit;
    committer: ReposCompareCommitsResponseBaseCommitCommitter;
    html_url: string;
    node_id: string;
    parents: Array<ReposCompareCommitsResponseBaseCommitParentsItem>;
    sha: string;
    url: string;
  };
  type ReposCompareCommitsResponse = {
    ahead_by: number;
    base_commit: ReposCompareCommitsResponseBaseCommit;
    behind_by: number;
    commits: Array<ReposCompareCommitsResponseCommitsItem>;
    diff_url: string;
    files: Array<ReposCompareCommitsResponseFilesItem>;
    html_url: string;
    merge_base_commit: ReposCompareCommitsResponseMergeBaseCommit;
    patch_url: string;
    permalink_url: string;
    status: string;
    total_commits: number;
    url: string;
  };
  type ReposAddProtectedBranchUserRestrictionsResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposAddProtectedBranchTeamRestrictionsResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type ReposAddProtectedBranchRequiredSignaturesResponse = {
    enabled: boolean;
    url: string;
  };
  type ReposAddProtectedBranchAppRestrictionsResponseItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ReposAddProtectedBranchAppRestrictionsResponseItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ReposAddProtectedBranchAppRestrictionsResponseItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposAddProtectedBranchAppRestrictionsResponseItemOwner;
    permissions: ReposAddProtectedBranchAppRestrictionsResponseItemPermissions;
    slug: string;
    updated_at: string;
  };
  type ReposAddProtectedBranchAdminEnforcementResponse = {
    enabled: boolean;
    url: string;
  };
  type ReposAddDeployKeyResponse = {
    created_at: string;
    id: number;
    key: string;
    read_only: boolean;
    title: string;
    url: string;
    verified: boolean;
  };
  type ReposAddCollaboratorResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposAddCollaboratorResponseRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ReposAddCollaboratorResponseRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ReposAddCollaboratorResponseInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposAddCollaboratorResponseInvitee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReposAddCollaboratorResponse = {
    created_at: string;
    html_url: string;
    id: number;
    invitee: ReposAddCollaboratorResponseInvitee;
    inviter: ReposAddCollaboratorResponseInviter;
    permissions: string;
    repository: ReposAddCollaboratorResponseRepository;
    url: string;
  };
  type ReactionsListForTeamDiscussionLegacyResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsListForTeamDiscussionLegacyResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionLegacyResponseItemUser;
  };
  type ReactionsListForTeamDiscussionInOrgResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsListForTeamDiscussionInOrgResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionInOrgResponseItemUser;
  };
  type ReactionsListForTeamDiscussionCommentLegacyResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsListForTeamDiscussionCommentLegacyResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionCommentLegacyResponseItemUser;
  };
  type ReactionsListForTeamDiscussionCommentInOrgResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsListForTeamDiscussionCommentInOrgResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionCommentInOrgResponseItemUser;
  };
  type ReactionsListForTeamDiscussionCommentResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsListForTeamDiscussionCommentResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionCommentResponseItemUser;
  };
  type ReactionsListForTeamDiscussionResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsListForTeamDiscussionResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionResponseItemUser;
  };
  type ReactionsListForPullRequestReviewCommentResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsListForPullRequestReviewCommentResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForPullRequestReviewCommentResponseItemUser;
  };
  type ReactionsListForIssueCommentResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsListForIssueCommentResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForIssueCommentResponseItemUser;
  };
  type ReactionsListForIssueResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsListForIssueResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForIssueResponseItemUser;
  };
  type ReactionsListForCommitCommentResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsListForCommitCommentResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForCommitCommentResponseItemUser;
  };
  type ReactionsCreateForTeamDiscussionLegacyResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsCreateForTeamDiscussionLegacyResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionLegacyResponseUser;
  };
  type ReactionsCreateForTeamDiscussionInOrgResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsCreateForTeamDiscussionInOrgResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionInOrgResponseUser;
  };
  type ReactionsCreateForTeamDiscussionCommentLegacyResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsCreateForTeamDiscussionCommentLegacyResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionCommentLegacyResponseUser;
  };
  type ReactionsCreateForTeamDiscussionCommentInOrgResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsCreateForTeamDiscussionCommentInOrgResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionCommentInOrgResponseUser;
  };
  type ReactionsCreateForTeamDiscussionCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsCreateForTeamDiscussionCommentResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionCommentResponseUser;
  };
  type ReactionsCreateForTeamDiscussionResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsCreateForTeamDiscussionResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionResponseUser;
  };
  type ReactionsCreateForPullRequestReviewCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsCreateForPullRequestReviewCommentResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForPullRequestReviewCommentResponseUser;
  };
  type ReactionsCreateForIssueCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsCreateForIssueCommentResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForIssueCommentResponseUser;
  };
  type ReactionsCreateForIssueResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsCreateForIssueResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForIssueResponseUser;
  };
  type ReactionsCreateForCommitCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ReactionsCreateForCommitCommentResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForCommitCommentResponseUser;
  };
  type RateLimitGetResponseResourcesSearch = {
    limit: number;
    remaining: number;
    reset: number;
  };
  type RateLimitGetResponseResourcesIntegrationManifest = {
    limit: number;
    remaining: number;
    reset: number;
  };
  type RateLimitGetResponseResourcesGraphql = {
    limit: number;
    remaining: number;
    reset: number;
  };
  type RateLimitGetResponseResourcesCore = {
    limit: number;
    remaining: number;
    reset: number;
  };
  type RateLimitGetResponseResources = {
    core: RateLimitGetResponseResourcesCore;
    graphql: RateLimitGetResponseResourcesGraphql;
    integration_manifest: RateLimitGetResponseResourcesIntegrationManifest;
    search: RateLimitGetResponseResourcesSearch;
  };
  type RateLimitGetResponseRate = {
    limit: number;
    remaining: number;
    reset: number;
  };
  type RateLimitGetResponse = {
    rate: RateLimitGetResponseRate;
    resources: RateLimitGetResponseResources;
  };
  type PullsUpdateReviewResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsUpdateReviewResponseLinksPullRequest = { href: string };
  type PullsUpdateReviewResponseLinksHtml = { href: string };
  type PullsUpdateReviewResponseLinks = {
    html: PullsUpdateReviewResponseLinksHtml;
    pull_request: PullsUpdateReviewResponseLinksPullRequest;
  };
  type PullsUpdateReviewResponse = {
    _links: PullsUpdateReviewResponseLinks;
    body: string;
    commit_id: string;
    html_url: string;
    id: number;
    node_id: string;
    pull_request_url: string;
    state: string;
    user: PullsUpdateReviewResponseUser;
  };
  type PullsUpdateCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsUpdateCommentResponseLinksSelf = { href: string };
  type PullsUpdateCommentResponseLinksPullRequest = { href: string };
  type PullsUpdateCommentResponseLinksHtml = { href: string };
  type PullsUpdateCommentResponseLinks = {
    html: PullsUpdateCommentResponseLinksHtml;
    pull_request: PullsUpdateCommentResponseLinksPullRequest;
    self: PullsUpdateCommentResponseLinksSelf;
  };
  type PullsUpdateCommentResponse = {
    _links: PullsUpdateCommentResponseLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    in_reply_to_id: number;
    line: number;
    node_id: string;
    original_commit_id: string;
    original_line: number;
    original_position: number;
    original_start_line: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    side: string;
    start_line: number;
    start_side: string;
    updated_at: string;
    url: string;
    user: PullsUpdateCommentResponseUser;
  };
  type PullsUpdateBranchResponse = { message: string; url: string };
  type PullsUpdateResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsUpdateResponseRequestedTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type PullsUpdateResponseRequestedReviewersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsUpdateResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsUpdateResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: PullsUpdateResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type PullsUpdateResponseMergedBy = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsUpdateResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type PullsUpdateResponseHeadUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsUpdateResponseHeadRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type PullsUpdateResponseHeadRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsUpdateResponseHeadRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsUpdateResponseHeadRepoOwner;
    permissions: PullsUpdateResponseHeadRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type PullsUpdateResponseHead = {
    label: string;
    ref: string;
    repo: PullsUpdateResponseHeadRepo;
    sha: string;
    user: PullsUpdateResponseHeadUser;
  };
  type PullsUpdateResponseBaseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsUpdateResponseBaseRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type PullsUpdateResponseBaseRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsUpdateResponseBaseRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsUpdateResponseBaseRepoOwner;
    permissions: PullsUpdateResponseBaseRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type PullsUpdateResponseBase = {
    label: string;
    ref: string;
    repo: PullsUpdateResponseBaseRepo;
    sha: string;
    user: PullsUpdateResponseBaseUser;
  };
  type PullsUpdateResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsUpdateResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsUpdateResponseLinksStatuses = { href: string };
  type PullsUpdateResponseLinksSelf = { href: string };
  type PullsUpdateResponseLinksReviewComments = { href: string };
  type PullsUpdateResponseLinksReviewComment = { href: string };
  type PullsUpdateResponseLinksIssue = { href: string };
  type PullsUpdateResponseLinksHtml = { href: string };
  type PullsUpdateResponseLinksCommits = { href: string };
  type PullsUpdateResponseLinksComments = { href: string };
  type PullsUpdateResponseLinks = {
    comments: PullsUpdateResponseLinksComments;
    commits: PullsUpdateResponseLinksCommits;
    html: PullsUpdateResponseLinksHtml;
    issue: PullsUpdateResponseLinksIssue;
    review_comment: PullsUpdateResponseLinksReviewComment;
    review_comments: PullsUpdateResponseLinksReviewComments;
    self: PullsUpdateResponseLinksSelf;
    statuses: PullsUpdateResponseLinksStatuses;
  };
  type PullsUpdateResponse = {
    _links: PullsUpdateResponseLinks;
    active_lock_reason: string;
    additions: number;
    assignee: PullsUpdateResponseAssignee;
    assignees: Array<PullsUpdateResponseAssigneesItem>;
    author_association: string;
    base: PullsUpdateResponseBase;
    body: string;
    changed_files: number;
    closed_at: string;
    comments: number;
    comments_url: string;
    commits: number;
    commits_url: string;
    created_at: string;
    deletions: number;
    diff_url: string;
    draft: boolean;
    head: PullsUpdateResponseHead;
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<PullsUpdateResponseLabelsItem>;
    locked: boolean;
    maintainer_can_modify: boolean;
    merge_commit_sha: string;
    mergeable: boolean;
    mergeable_state: string;
    merged: boolean;
    merged_at: string;
    merged_by: PullsUpdateResponseMergedBy;
    milestone: PullsUpdateResponseMilestone;
    node_id: string;
    number: number;
    patch_url: string;
    rebaseable: boolean;
    requested_reviewers: Array<PullsUpdateResponseRequestedReviewersItem>;
    requested_teams: Array<PullsUpdateResponseRequestedTeamsItem>;
    review_comment_url: string;
    review_comments: number;
    review_comments_url: string;
    state: string;
    statuses_url: string;
    title: string;
    updated_at: string;
    url: string;
    user: PullsUpdateResponseUser;
  };
  type PullsSubmitReviewResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsSubmitReviewResponseLinksPullRequest = { href: string };
  type PullsSubmitReviewResponseLinksHtml = { href: string };
  type PullsSubmitReviewResponseLinks = {
    html: PullsSubmitReviewResponseLinksHtml;
    pull_request: PullsSubmitReviewResponseLinksPullRequest;
  };
  type PullsSubmitReviewResponse = {
    _links: PullsSubmitReviewResponseLinks;
    body: string;
    commit_id: string;
    html_url: string;
    id: number;
    node_id: string;
    pull_request_url: string;
    state: string;
    submitted_at: string;
    user: PullsSubmitReviewResponseUser;
  };
  type PullsMergeResponse = { merged: boolean; message: string; sha: string };
  type PullsListReviewsResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListReviewsResponseItemLinksPullRequest = { href: string };
  type PullsListReviewsResponseItemLinksHtml = { href: string };
  type PullsListReviewsResponseItemLinks = {
    html: PullsListReviewsResponseItemLinksHtml;
    pull_request: PullsListReviewsResponseItemLinksPullRequest;
  };
  type PullsListReviewsResponseItem = {
    _links: PullsListReviewsResponseItemLinks;
    body: string;
    commit_id: string;
    html_url: string;
    id: number;
    node_id: string;
    pull_request_url: string;
    state: string;
    submitted_at: string;
    user: PullsListReviewsResponseItemUser;
  };
  type PullsListReviewRequestsResponseUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListReviewRequestsResponseTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type PullsListReviewRequestsResponse = {
    teams: Array<PullsListReviewRequestsResponseTeamsItem>;
    users: Array<PullsListReviewRequestsResponseUsersItem>;
  };
  type PullsListFilesResponseItem = {
    additions: number;
    blob_url: string;
    changes: number;
    contents_url: string;
    deletions: number;
    filename: string;
    patch: string;
    raw_url: string;
    sha: string;
    status: string;
  };
  type PullsListCommitsResponseItemParentsItem = { sha: string; url: string };
  type PullsListCommitsResponseItemCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListCommitsResponseItemCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type PullsListCommitsResponseItemCommitTree = { sha: string; url: string };
  type PullsListCommitsResponseItemCommitCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type PullsListCommitsResponseItemCommitAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type PullsListCommitsResponseItemCommit = {
    author: PullsListCommitsResponseItemCommitAuthor;
    comment_count: number;
    committer: PullsListCommitsResponseItemCommitCommitter;
    message: string;
    tree: PullsListCommitsResponseItemCommitTree;
    url: string;
    verification: PullsListCommitsResponseItemCommitVerification;
  };
  type PullsListCommitsResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListCommitsResponseItem = {
    author: PullsListCommitsResponseItemAuthor;
    comments_url: string;
    commit: PullsListCommitsResponseItemCommit;
    committer: PullsListCommitsResponseItemCommitter;
    html_url: string;
    node_id: string;
    parents: Array<PullsListCommitsResponseItemParentsItem>;
    sha: string;
    url: string;
  };
  type PullsListCommentsForRepoResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListCommentsForRepoResponseItemLinksSelf = { href: string };
  type PullsListCommentsForRepoResponseItemLinksPullRequest = { href: string };
  type PullsListCommentsForRepoResponseItemLinksHtml = { href: string };
  type PullsListCommentsForRepoResponseItemLinks = {
    html: PullsListCommentsForRepoResponseItemLinksHtml;
    pull_request: PullsListCommentsForRepoResponseItemLinksPullRequest;
    self: PullsListCommentsForRepoResponseItemLinksSelf;
  };
  type PullsListCommentsForRepoResponseItem = {
    _links: PullsListCommentsForRepoResponseItemLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    in_reply_to_id: number;
    line: number;
    node_id: string;
    original_commit_id: string;
    original_line: number;
    original_position: number;
    original_start_line: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    side: string;
    start_line: number;
    start_side: string;
    updated_at: string;
    url: string;
    user: PullsListCommentsForRepoResponseItemUser;
  };
  type PullsListCommentsResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListCommentsResponseItemLinksSelf = { href: string };
  type PullsListCommentsResponseItemLinksPullRequest = { href: string };
  type PullsListCommentsResponseItemLinksHtml = { href: string };
  type PullsListCommentsResponseItemLinks = {
    html: PullsListCommentsResponseItemLinksHtml;
    pull_request: PullsListCommentsResponseItemLinksPullRequest;
    self: PullsListCommentsResponseItemLinksSelf;
  };
  type PullsListCommentsResponseItem = {
    _links: PullsListCommentsResponseItemLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    in_reply_to_id: number;
    line: number;
    node_id: string;
    original_commit_id: string;
    original_line: number;
    original_position: number;
    original_start_line: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    side: string;
    start_line: number;
    start_side: string;
    updated_at: string;
    url: string;
    user: PullsListCommentsResponseItemUser;
  };
  type PullsListResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListResponseItemRequestedTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type PullsListResponseItemRequestedReviewersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListResponseItemMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListResponseItemMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: PullsListResponseItemMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type PullsListResponseItemLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type PullsListResponseItemHeadUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListResponseItemHeadRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type PullsListResponseItemHeadRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListResponseItemHeadRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsListResponseItemHeadRepoOwner;
    permissions: PullsListResponseItemHeadRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type PullsListResponseItemHead = {
    label: string;
    ref: string;
    repo: PullsListResponseItemHeadRepo;
    sha: string;
    user: PullsListResponseItemHeadUser;
  };
  type PullsListResponseItemBaseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListResponseItemBaseRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type PullsListResponseItemBaseRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListResponseItemBaseRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsListResponseItemBaseRepoOwner;
    permissions: PullsListResponseItemBaseRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type PullsListResponseItemBase = {
    label: string;
    ref: string;
    repo: PullsListResponseItemBaseRepo;
    sha: string;
    user: PullsListResponseItemBaseUser;
  };
  type PullsListResponseItemAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListResponseItemAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsListResponseItemLinksStatuses = { href: string };
  type PullsListResponseItemLinksSelf = { href: string };
  type PullsListResponseItemLinksReviewComments = { href: string };
  type PullsListResponseItemLinksReviewComment = { href: string };
  type PullsListResponseItemLinksIssue = { href: string };
  type PullsListResponseItemLinksHtml = { href: string };
  type PullsListResponseItemLinksCommits = { href: string };
  type PullsListResponseItemLinksComments = { href: string };
  type PullsListResponseItemLinks = {
    comments: PullsListResponseItemLinksComments;
    commits: PullsListResponseItemLinksCommits;
    html: PullsListResponseItemLinksHtml;
    issue: PullsListResponseItemLinksIssue;
    review_comment: PullsListResponseItemLinksReviewComment;
    review_comments: PullsListResponseItemLinksReviewComments;
    self: PullsListResponseItemLinksSelf;
    statuses: PullsListResponseItemLinksStatuses;
  };
  type PullsListResponseItem = {
    _links: PullsListResponseItemLinks;
    active_lock_reason: string;
    assignee: PullsListResponseItemAssignee;
    assignees: Array<PullsListResponseItemAssigneesItem>;
    author_association: string;
    base: PullsListResponseItemBase;
    body: string;
    closed_at: string;
    comments_url: string;
    commits_url: string;
    created_at: string;
    diff_url: string;
    draft: boolean;
    head: PullsListResponseItemHead;
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<PullsListResponseItemLabelsItem>;
    locked: boolean;
    merge_commit_sha: string;
    merged_at: string;
    milestone: PullsListResponseItemMilestone;
    node_id: string;
    number: number;
    patch_url: string;
    requested_reviewers: Array<PullsListResponseItemRequestedReviewersItem>;
    requested_teams: Array<PullsListResponseItemRequestedTeamsItem>;
    review_comment_url: string;
    review_comments_url: string;
    state: string;
    statuses_url: string;
    title: string;
    updated_at: string;
    url: string;
    user: PullsListResponseItemUser;
  };
  type PullsGetReviewResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsGetReviewResponseLinksPullRequest = { href: string };
  type PullsGetReviewResponseLinksHtml = { href: string };
  type PullsGetReviewResponseLinks = {
    html: PullsGetReviewResponseLinksHtml;
    pull_request: PullsGetReviewResponseLinksPullRequest;
  };
  type PullsGetReviewResponse = {
    _links: PullsGetReviewResponseLinks;
    body: string;
    commit_id: string;
    html_url: string;
    id: number;
    node_id: string;
    pull_request_url: string;
    state: string;
    submitted_at: string;
    user: PullsGetReviewResponseUser;
  };
  type PullsGetCommentsForReviewResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsGetCommentsForReviewResponseItemLinksSelf = { href: string };
  type PullsGetCommentsForReviewResponseItemLinksPullRequest = { href: string };
  type PullsGetCommentsForReviewResponseItemLinksHtml = { href: string };
  type PullsGetCommentsForReviewResponseItemLinks = {
    html: PullsGetCommentsForReviewResponseItemLinksHtml;
    pull_request: PullsGetCommentsForReviewResponseItemLinksPullRequest;
    self: PullsGetCommentsForReviewResponseItemLinksSelf;
  };
  type PullsGetCommentsForReviewResponseItem = {
    _links: PullsGetCommentsForReviewResponseItemLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    in_reply_to_id: number;
    node_id: string;
    original_commit_id: string;
    original_position: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    updated_at: string;
    url: string;
    user: PullsGetCommentsForReviewResponseItemUser;
  };
  type PullsGetCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsGetCommentResponseLinksSelf = { href: string };
  type PullsGetCommentResponseLinksPullRequest = { href: string };
  type PullsGetCommentResponseLinksHtml = { href: string };
  type PullsGetCommentResponseLinks = {
    html: PullsGetCommentResponseLinksHtml;
    pull_request: PullsGetCommentResponseLinksPullRequest;
    self: PullsGetCommentResponseLinksSelf;
  };
  type PullsGetCommentResponse = {
    _links: PullsGetCommentResponseLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    in_reply_to_id: number;
    line: number;
    node_id: string;
    original_commit_id: string;
    original_line: number;
    original_position: number;
    original_start_line: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    side: string;
    start_line: number;
    start_side: string;
    updated_at: string;
    url: string;
    user: PullsGetCommentResponseUser;
  };
  type PullsGetResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsGetResponseRequestedTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type PullsGetResponseRequestedReviewersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsGetResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsGetResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: PullsGetResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type PullsGetResponseMergedBy = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsGetResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type PullsGetResponseHeadUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsGetResponseHeadRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type PullsGetResponseHeadRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsGetResponseHeadRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsGetResponseHeadRepoOwner;
    permissions: PullsGetResponseHeadRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type PullsGetResponseHead = {
    label: string;
    ref: string;
    repo: PullsGetResponseHeadRepo;
    sha: string;
    user: PullsGetResponseHeadUser;
  };
  type PullsGetResponseBaseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsGetResponseBaseRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type PullsGetResponseBaseRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsGetResponseBaseRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsGetResponseBaseRepoOwner;
    permissions: PullsGetResponseBaseRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type PullsGetResponseBase = {
    label: string;
    ref: string;
    repo: PullsGetResponseBaseRepo;
    sha: string;
    user: PullsGetResponseBaseUser;
  };
  type PullsGetResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsGetResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsGetResponseLinksStatuses = { href: string };
  type PullsGetResponseLinksSelf = { href: string };
  type PullsGetResponseLinksReviewComments = { href: string };
  type PullsGetResponseLinksReviewComment = { href: string };
  type PullsGetResponseLinksIssue = { href: string };
  type PullsGetResponseLinksHtml = { href: string };
  type PullsGetResponseLinksCommits = { href: string };
  type PullsGetResponseLinksComments = { href: string };
  type PullsGetResponseLinks = {
    comments: PullsGetResponseLinksComments;
    commits: PullsGetResponseLinksCommits;
    html: PullsGetResponseLinksHtml;
    issue: PullsGetResponseLinksIssue;
    review_comment: PullsGetResponseLinksReviewComment;
    review_comments: PullsGetResponseLinksReviewComments;
    self: PullsGetResponseLinksSelf;
    statuses: PullsGetResponseLinksStatuses;
  };
  type PullsGetResponse = {
    _links: PullsGetResponseLinks;
    active_lock_reason: string;
    additions: number;
    assignee: PullsGetResponseAssignee;
    assignees: Array<PullsGetResponseAssigneesItem>;
    author_association: string;
    base: PullsGetResponseBase;
    body: string;
    changed_files: number;
    closed_at: string;
    comments: number;
    comments_url: string;
    commits: number;
    commits_url: string;
    created_at: string;
    deletions: number;
    diff_url: string;
    draft: boolean;
    head: PullsGetResponseHead;
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<PullsGetResponseLabelsItem>;
    locked: boolean;
    maintainer_can_modify: boolean;
    merge_commit_sha: string;
    mergeable: boolean;
    mergeable_state: string;
    merged: boolean;
    merged_at: string;
    merged_by: PullsGetResponseMergedBy;
    milestone: PullsGetResponseMilestone;
    node_id: string;
    number: number;
    patch_url: string;
    rebaseable: boolean;
    requested_reviewers: Array<PullsGetResponseRequestedReviewersItem>;
    requested_teams: Array<PullsGetResponseRequestedTeamsItem>;
    review_comment_url: string;
    review_comments: number;
    review_comments_url: string;
    state: string;
    statuses_url: string;
    title: string;
    updated_at: string;
    url: string;
    user: PullsGetResponseUser;
  };
  type PullsDismissReviewResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsDismissReviewResponseLinksPullRequest = { href: string };
  type PullsDismissReviewResponseLinksHtml = { href: string };
  type PullsDismissReviewResponseLinks = {
    html: PullsDismissReviewResponseLinksHtml;
    pull_request: PullsDismissReviewResponseLinksPullRequest;
  };
  type PullsDismissReviewResponse = {
    _links: PullsDismissReviewResponseLinks;
    body: string;
    commit_id: string;
    html_url: string;
    id: number;
    node_id: string;
    pull_request_url: string;
    state: string;
    user: PullsDismissReviewResponseUser;
  };
  type PullsDeletePendingReviewResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsDeletePendingReviewResponseLinksPullRequest = { href: string };
  type PullsDeletePendingReviewResponseLinksHtml = { href: string };
  type PullsDeletePendingReviewResponseLinks = {
    html: PullsDeletePendingReviewResponseLinksHtml;
    pull_request: PullsDeletePendingReviewResponseLinksPullRequest;
  };
  type PullsDeletePendingReviewResponse = {
    _links: PullsDeletePendingReviewResponseLinks;
    body: string;
    commit_id: string;
    html_url: string;
    id: number;
    node_id: string;
    pull_request_url: string;
    state: string;
    user: PullsDeletePendingReviewResponseUser;
  };
  type PullsCreateReviewRequestResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateReviewRequestResponseRequestedTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type PullsCreateReviewRequestResponseRequestedReviewersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateReviewRequestResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateReviewRequestResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: PullsCreateReviewRequestResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type PullsCreateReviewRequestResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type PullsCreateReviewRequestResponseHeadUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateReviewRequestResponseHeadRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type PullsCreateReviewRequestResponseHeadRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateReviewRequestResponseHeadRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsCreateReviewRequestResponseHeadRepoOwner;
    permissions: PullsCreateReviewRequestResponseHeadRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type PullsCreateReviewRequestResponseHead = {
    label: string;
    ref: string;
    repo: PullsCreateReviewRequestResponseHeadRepo;
    sha: string;
    user: PullsCreateReviewRequestResponseHeadUser;
  };
  type PullsCreateReviewRequestResponseBaseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateReviewRequestResponseBaseRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type PullsCreateReviewRequestResponseBaseRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateReviewRequestResponseBaseRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsCreateReviewRequestResponseBaseRepoOwner;
    permissions: PullsCreateReviewRequestResponseBaseRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type PullsCreateReviewRequestResponseBase = {
    label: string;
    ref: string;
    repo: PullsCreateReviewRequestResponseBaseRepo;
    sha: string;
    user: PullsCreateReviewRequestResponseBaseUser;
  };
  type PullsCreateReviewRequestResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateReviewRequestResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateReviewRequestResponseLinksStatuses = { href: string };
  type PullsCreateReviewRequestResponseLinksSelf = { href: string };
  type PullsCreateReviewRequestResponseLinksReviewComments = { href: string };
  type PullsCreateReviewRequestResponseLinksReviewComment = { href: string };
  type PullsCreateReviewRequestResponseLinksIssue = { href: string };
  type PullsCreateReviewRequestResponseLinksHtml = { href: string };
  type PullsCreateReviewRequestResponseLinksCommits = { href: string };
  type PullsCreateReviewRequestResponseLinksComments = { href: string };
  type PullsCreateReviewRequestResponseLinks = {
    comments: PullsCreateReviewRequestResponseLinksComments;
    commits: PullsCreateReviewRequestResponseLinksCommits;
    html: PullsCreateReviewRequestResponseLinksHtml;
    issue: PullsCreateReviewRequestResponseLinksIssue;
    review_comment: PullsCreateReviewRequestResponseLinksReviewComment;
    review_comments: PullsCreateReviewRequestResponseLinksReviewComments;
    self: PullsCreateReviewRequestResponseLinksSelf;
    statuses: PullsCreateReviewRequestResponseLinksStatuses;
  };
  type PullsCreateReviewRequestResponse = {
    _links: PullsCreateReviewRequestResponseLinks;
    active_lock_reason: string;
    assignee: PullsCreateReviewRequestResponseAssignee;
    assignees: Array<PullsCreateReviewRequestResponseAssigneesItem>;
    author_association: string;
    base: PullsCreateReviewRequestResponseBase;
    body: string;
    closed_at: string;
    comments_url: string;
    commits_url: string;
    created_at: string;
    diff_url: string;
    draft: boolean;
    head: PullsCreateReviewRequestResponseHead;
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<PullsCreateReviewRequestResponseLabelsItem>;
    locked: boolean;
    merge_commit_sha: string;
    merged_at: string;
    milestone: PullsCreateReviewRequestResponseMilestone;
    node_id: string;
    number: number;
    patch_url: string;
    requested_reviewers: Array<
      PullsCreateReviewRequestResponseRequestedReviewersItem
    >;
    requested_teams: Array<PullsCreateReviewRequestResponseRequestedTeamsItem>;
    review_comment_url: string;
    review_comments_url: string;
    state: string;
    statuses_url: string;
    title: string;
    updated_at: string;
    url: string;
    user: PullsCreateReviewRequestResponseUser;
  };
  type PullsCreateReviewCommentReplyResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateReviewCommentReplyResponseLinksSelf = { href: string };
  type PullsCreateReviewCommentReplyResponseLinksPullRequest = { href: string };
  type PullsCreateReviewCommentReplyResponseLinksHtml = { href: string };
  type PullsCreateReviewCommentReplyResponseLinks = {
    html: PullsCreateReviewCommentReplyResponseLinksHtml;
    pull_request: PullsCreateReviewCommentReplyResponseLinksPullRequest;
    self: PullsCreateReviewCommentReplyResponseLinksSelf;
  };
  type PullsCreateReviewCommentReplyResponse = {
    _links: PullsCreateReviewCommentReplyResponseLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    node_id: string;
    original_commit_id: string;
    original_position: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    updated_at: string;
    url: string;
    user: PullsCreateReviewCommentReplyResponseUser;
  };
  type PullsCreateReviewResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateReviewResponseLinksPullRequest = { href: string };
  type PullsCreateReviewResponseLinksHtml = { href: string };
  type PullsCreateReviewResponseLinks = {
    html: PullsCreateReviewResponseLinksHtml;
    pull_request: PullsCreateReviewResponseLinksPullRequest;
  };
  type PullsCreateReviewResponse = {
    _links: PullsCreateReviewResponseLinks;
    body: string;
    commit_id: string;
    html_url: string;
    id: number;
    node_id: string;
    pull_request_url: string;
    state: string;
    user: PullsCreateReviewResponseUser;
  };
  type PullsCreateFromIssueResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateFromIssueResponseRequestedTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type PullsCreateFromIssueResponseRequestedReviewersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateFromIssueResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateFromIssueResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: PullsCreateFromIssueResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type PullsCreateFromIssueResponseMergedBy = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateFromIssueResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type PullsCreateFromIssueResponseHeadUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateFromIssueResponseHeadRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type PullsCreateFromIssueResponseHeadRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateFromIssueResponseHeadRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsCreateFromIssueResponseHeadRepoOwner;
    permissions: PullsCreateFromIssueResponseHeadRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type PullsCreateFromIssueResponseHead = {
    label: string;
    ref: string;
    repo: PullsCreateFromIssueResponseHeadRepo;
    sha: string;
    user: PullsCreateFromIssueResponseHeadUser;
  };
  type PullsCreateFromIssueResponseBaseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateFromIssueResponseBaseRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type PullsCreateFromIssueResponseBaseRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateFromIssueResponseBaseRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsCreateFromIssueResponseBaseRepoOwner;
    permissions: PullsCreateFromIssueResponseBaseRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type PullsCreateFromIssueResponseBase = {
    label: string;
    ref: string;
    repo: PullsCreateFromIssueResponseBaseRepo;
    sha: string;
    user: PullsCreateFromIssueResponseBaseUser;
  };
  type PullsCreateFromIssueResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateFromIssueResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateFromIssueResponseLinksStatuses = { href: string };
  type PullsCreateFromIssueResponseLinksSelf = { href: string };
  type PullsCreateFromIssueResponseLinksReviewComments = { href: string };
  type PullsCreateFromIssueResponseLinksReviewComment = { href: string };
  type PullsCreateFromIssueResponseLinksIssue = { href: string };
  type PullsCreateFromIssueResponseLinksHtml = { href: string };
  type PullsCreateFromIssueResponseLinksCommits = { href: string };
  type PullsCreateFromIssueResponseLinksComments = { href: string };
  type PullsCreateFromIssueResponseLinks = {
    comments: PullsCreateFromIssueResponseLinksComments;
    commits: PullsCreateFromIssueResponseLinksCommits;
    html: PullsCreateFromIssueResponseLinksHtml;
    issue: PullsCreateFromIssueResponseLinksIssue;
    review_comment: PullsCreateFromIssueResponseLinksReviewComment;
    review_comments: PullsCreateFromIssueResponseLinksReviewComments;
    self: PullsCreateFromIssueResponseLinksSelf;
    statuses: PullsCreateFromIssueResponseLinksStatuses;
  };
  type PullsCreateFromIssueResponse = {
    _links: PullsCreateFromIssueResponseLinks;
    active_lock_reason: string;
    additions: number;
    assignee: PullsCreateFromIssueResponseAssignee;
    assignees: Array<PullsCreateFromIssueResponseAssigneesItem>;
    author_association: string;
    base: PullsCreateFromIssueResponseBase;
    body: string;
    changed_files: number;
    closed_at: string;
    comments: number;
    comments_url: string;
    commits: number;
    commits_url: string;
    created_at: string;
    deletions: number;
    diff_url: string;
    draft: boolean;
    head: PullsCreateFromIssueResponseHead;
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<PullsCreateFromIssueResponseLabelsItem>;
    locked: boolean;
    maintainer_can_modify: boolean;
    merge_commit_sha: string;
    mergeable: boolean;
    mergeable_state: string;
    merged: boolean;
    merged_at: string;
    merged_by: PullsCreateFromIssueResponseMergedBy;
    milestone: PullsCreateFromIssueResponseMilestone;
    node_id: string;
    number: number;
    patch_url: string;
    rebaseable: boolean;
    requested_reviewers: Array<
      PullsCreateFromIssueResponseRequestedReviewersItem
    >;
    requested_teams: Array<PullsCreateFromIssueResponseRequestedTeamsItem>;
    review_comment_url: string;
    review_comments: number;
    review_comments_url: string;
    state: string;
    statuses_url: string;
    title: string;
    updated_at: string;
    url: string;
    user: PullsCreateFromIssueResponseUser;
  };
  type PullsCreateCommentReplyResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateCommentReplyResponseLinksSelf = { href: string };
  type PullsCreateCommentReplyResponseLinksPullRequest = { href: string };
  type PullsCreateCommentReplyResponseLinksHtml = { href: string };
  type PullsCreateCommentReplyResponseLinks = {
    html: PullsCreateCommentReplyResponseLinksHtml;
    pull_request: PullsCreateCommentReplyResponseLinksPullRequest;
    self: PullsCreateCommentReplyResponseLinksSelf;
  };
  type PullsCreateCommentReplyResponse = {
    _links: PullsCreateCommentReplyResponseLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    in_reply_to_id: number;
    line: number;
    node_id: string;
    original_commit_id: string;
    original_line: number;
    original_position: number;
    original_start_line: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    side: string;
    start_line: number;
    start_side: string;
    updated_at: string;
    url: string;
    user: PullsCreateCommentReplyResponseUser;
  };
  type PullsCreateCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateCommentResponseLinksSelf = { href: string };
  type PullsCreateCommentResponseLinksPullRequest = { href: string };
  type PullsCreateCommentResponseLinksHtml = { href: string };
  type PullsCreateCommentResponseLinks = {
    html: PullsCreateCommentResponseLinksHtml;
    pull_request: PullsCreateCommentResponseLinksPullRequest;
    self: PullsCreateCommentResponseLinksSelf;
  };
  type PullsCreateCommentResponse = {
    _links: PullsCreateCommentResponseLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    in_reply_to_id: number;
    line: number;
    node_id: string;
    original_commit_id: string;
    original_line: number;
    original_position: number;
    original_start_line: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    side: string;
    start_line: number;
    start_side: string;
    updated_at: string;
    url: string;
    user: PullsCreateCommentResponseUser;
  };
  type PullsCreateResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateResponseRequestedTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type PullsCreateResponseRequestedReviewersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: PullsCreateResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type PullsCreateResponseMergedBy = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type PullsCreateResponseHeadUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateResponseHeadRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type PullsCreateResponseHeadRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateResponseHeadRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsCreateResponseHeadRepoOwner;
    permissions: PullsCreateResponseHeadRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type PullsCreateResponseHead = {
    label: string;
    ref: string;
    repo: PullsCreateResponseHeadRepo;
    sha: string;
    user: PullsCreateResponseHeadUser;
  };
  type PullsCreateResponseBaseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateResponseBaseRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type PullsCreateResponseBaseRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateResponseBaseRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsCreateResponseBaseRepoOwner;
    permissions: PullsCreateResponseBaseRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type PullsCreateResponseBase = {
    label: string;
    ref: string;
    repo: PullsCreateResponseBaseRepo;
    sha: string;
    user: PullsCreateResponseBaseUser;
  };
  type PullsCreateResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type PullsCreateResponseLinksStatuses = { href: string };
  type PullsCreateResponseLinksSelf = { href: string };
  type PullsCreateResponseLinksReviewComments = { href: string };
  type PullsCreateResponseLinksReviewComment = { href: string };
  type PullsCreateResponseLinksIssue = { href: string };
  type PullsCreateResponseLinksHtml = { href: string };
  type PullsCreateResponseLinksCommits = { href: string };
  type PullsCreateResponseLinksComments = { href: string };
  type PullsCreateResponseLinks = {
    comments: PullsCreateResponseLinksComments;
    commits: PullsCreateResponseLinksCommits;
    html: PullsCreateResponseLinksHtml;
    issue: PullsCreateResponseLinksIssue;
    review_comment: PullsCreateResponseLinksReviewComment;
    review_comments: PullsCreateResponseLinksReviewComments;
    self: PullsCreateResponseLinksSelf;
    statuses: PullsCreateResponseLinksStatuses;
  };
  type PullsCreateResponse = {
    _links: PullsCreateResponseLinks;
    active_lock_reason: string;
    additions: number;
    assignee: PullsCreateResponseAssignee;
    assignees: Array<PullsCreateResponseAssigneesItem>;
    author_association: string;
    base: PullsCreateResponseBase;
    body: string;
    changed_files: number;
    closed_at: string;
    comments: number;
    comments_url: string;
    commits: number;
    commits_url: string;
    created_at: string;
    deletions: number;
    diff_url: string;
    draft: boolean;
    head: PullsCreateResponseHead;
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<PullsCreateResponseLabelsItem>;
    locked: boolean;
    maintainer_can_modify: boolean;
    merge_commit_sha: string;
    mergeable: boolean;
    mergeable_state: string;
    merged: boolean;
    merged_at: string;
    merged_by: PullsCreateResponseMergedBy;
    milestone: PullsCreateResponseMilestone;
    node_id: string;
    number: number;
    patch_url: string;
    rebaseable: boolean;
    requested_reviewers: Array<PullsCreateResponseRequestedReviewersItem>;
    requested_teams: Array<PullsCreateResponseRequestedTeamsItem>;
    review_comment_url: string;
    review_comments: number;
    review_comments_url: string;
    state: string;
    statuses_url: string;
    title: string;
    updated_at: string;
    url: string;
    user: PullsCreateResponseUser;
  };
  type ProjectsUpdateColumnResponse = {
    cards_url: string;
    created_at: string;
    id: number;
    name: string;
    node_id: string;
    project_url: string;
    updated_at: string;
    url: string;
  };
  type ProjectsUpdateCardResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ProjectsUpdateCardResponse = {
    archived: boolean;
    column_url: string;
    content_url: string;
    created_at: string;
    creator: ProjectsUpdateCardResponseCreator;
    id: number;
    node_id: string;
    note: string;
    project_url: string;
    updated_at: string;
    url: string;
  };
  type ProjectsUpdateResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ProjectsUpdateResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsUpdateResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
  };
  type ProjectsReviewUserPermissionLevelResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ProjectsReviewUserPermissionLevelResponse = {
    permission: string;
    user: ProjectsReviewUserPermissionLevelResponseUser;
  };
  type ProjectsListForUserResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ProjectsListForUserResponseItem = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsListForUserResponseItemCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
  };
  type ProjectsListForRepoResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ProjectsListForRepoResponseItem = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsListForRepoResponseItemCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
  };
  type ProjectsListForOrgResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ProjectsListForOrgResponseItem = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsListForOrgResponseItemCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
  };
  type ProjectsListColumnsResponseItem = {
    cards_url: string;
    created_at: string;
    id: number;
    name: string;
    node_id: string;
    project_url: string;
    updated_at: string;
    url: string;
  };
  type ProjectsListCollaboratorsResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ProjectsListCardsResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ProjectsListCardsResponseItem = {
    archived: boolean;
    column_url: string;
    content_url: string;
    created_at: string;
    creator: ProjectsListCardsResponseItemCreator;
    id: number;
    node_id: string;
    note: string;
    project_url: string;
    updated_at: string;
    url: string;
  };
  type ProjectsGetColumnResponse = {
    cards_url: string;
    created_at: string;
    id: number;
    name: string;
    node_id: string;
    project_url: string;
    updated_at: string;
    url: string;
  };
  type ProjectsGetCardResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ProjectsGetCardResponse = {
    archived: boolean;
    column_url: string;
    content_url: string;
    created_at: string;
    creator: ProjectsGetCardResponseCreator;
    id: number;
    node_id: string;
    note: string;
    project_url: string;
    updated_at: string;
    url: string;
  };
  type ProjectsGetResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ProjectsGetResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsGetResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
  };
  type ProjectsCreateForRepoResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ProjectsCreateForRepoResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsCreateForRepoResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
  };
  type ProjectsCreateForOrgResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ProjectsCreateForOrgResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsCreateForOrgResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
  };
  type ProjectsCreateForAuthenticatedUserResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ProjectsCreateForAuthenticatedUserResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsCreateForAuthenticatedUserResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
  };
  type ProjectsCreateColumnResponse = {
    cards_url: string;
    created_at: string;
    id: number;
    name: string;
    node_id: string;
    project_url: string;
    updated_at: string;
    url: string;
  };
  type ProjectsCreateCardResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ProjectsCreateCardResponse = {
    archived: boolean;
    column_url: string;
    content_url: string;
    created_at: string;
    creator: ProjectsCreateCardResponseCreator;
    id: number;
    node_id: string;
    note: string;
    project_url: string;
    updated_at: string;
    url: string;
  };
  type OrgsUpdateMembershipResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type OrgsUpdateMembershipResponseOrganization = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type OrgsUpdateMembershipResponse = {
    organization: OrgsUpdateMembershipResponseOrganization;
    organization_url: string;
    role: string;
    state: string;
    url: string;
    user: OrgsUpdateMembershipResponseUser;
  };
  type OrgsUpdateHookResponseConfig = { content_type: string; url: string };
  type OrgsUpdateHookResponse = {
    active: boolean;
    config: OrgsUpdateHookResponseConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    name: string;
    ping_url: string;
    updated_at: string;
    url: string;
  };
  type OrgsUpdateResponsePlan = {
    name: string;
    private_repos: number;
    space: number;
  };
  type OrgsUpdateResponse = {
    avatar_url: string;
    billing_email: string;
    blog: string;
    collaborators: number;
    company: string;
    created_at: string;
    default_repository_permission: string;
    description: string;
    disk_usage: number;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_allowed_repository_creation_type: string;
    members_can_create_internal_repositories: boolean;
    members_can_create_private_repositories: boolean;
    members_can_create_public_repositories: boolean;
    members_can_create_repositories: boolean;
    members_url: string;
    name: string;
    node_id: string;
    owned_private_repos: number;
    plan: OrgsUpdateResponsePlan;
    private_gists: number;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    total_private_repos: number;
    two_factor_requirement_enabled: boolean;
    type: string;
    url: string;
  };
  type OrgsRemoveOutsideCollaboratorResponse = {
    documentation_url: string;
    message: string;
  };
  type OrgsListPublicMembersResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type OrgsListPendingInvitationsResponseItemInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type OrgsListPendingInvitationsResponseItem = {
    created_at: string;
    email: string;
    id: number;
    invitation_team_url: string;
    inviter: OrgsListPendingInvitationsResponseItemInviter;
    login: string;
    role: string;
    team_count: number;
  };
  type OrgsListOutsideCollaboratorsResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type OrgsListMembershipsResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type OrgsListMembershipsResponseItemOrganization = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type OrgsListMembershipsResponseItem = {
    organization: OrgsListMembershipsResponseItemOrganization;
    organization_url: string;
    role: string;
    state: string;
    url: string;
    user: OrgsListMembershipsResponseItemUser;
  };
  type OrgsListMembersResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type OrgsListInvitationTeamsResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
  };
  type OrgsListInstallationsResponseInstallationsItemPermissions = {
    deployments: string;
    metadata: string;
    pull_requests: string;
    statuses: string;
  };
  type OrgsListInstallationsResponseInstallationsItemAccount = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type OrgsListInstallationsResponseInstallationsItem = {
    access_tokens_url: string;
    account: OrgsListInstallationsResponseInstallationsItemAccount;
    app_id: number;
    created_at: string;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: OrgsListInstallationsResponseInstallationsItemPermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: null;
    target_id: number;
    target_type: string;
    updated_at: string;
  };
  type OrgsListInstallationsResponse = {
    installations: Array<OrgsListInstallationsResponseInstallationsItem>;
    total_count: number;
  };
  type OrgsListHooksResponseItemConfig = { content_type: string; url: string };
  type OrgsListHooksResponseItem = {
    active: boolean;
    config: OrgsListHooksResponseItemConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    name: string;
    ping_url: string;
    updated_at: string;
    url: string;
  };
  type OrgsListForUserResponseItem = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type OrgsListForAuthenticatedUserResponseItem = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type OrgsListBlockedUsersResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type OrgsListResponseItem = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type OrgsGetMembershipForAuthenticatedUserResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type OrgsGetMembershipForAuthenticatedUserResponseOrganization = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type OrgsGetMembershipForAuthenticatedUserResponse = {
    organization: OrgsGetMembershipForAuthenticatedUserResponseOrganization;
    organization_url: string;
    role: string;
    state: string;
    url: string;
    user: OrgsGetMembershipForAuthenticatedUserResponseUser;
  };
  type OrgsGetMembershipResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type OrgsGetMembershipResponseOrganization = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type OrgsGetMembershipResponse = {
    organization: OrgsGetMembershipResponseOrganization;
    organization_url: string;
    role: string;
    state: string;
    url: string;
    user: OrgsGetMembershipResponseUser;
  };
  type OrgsGetHookResponseConfig = { content_type: string; url: string };
  type OrgsGetHookResponse = {
    active: boolean;
    config: OrgsGetHookResponseConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    name: string;
    ping_url: string;
    updated_at: string;
    url: string;
  };
  type OrgsGetResponsePlan = {
    name: string;
    private_repos: number;
    space: number;
    filled_seats?: number;
    seats?: number;
  };
  type OrgsGetResponse = {
    avatar_url: string;
    billing_email?: string;
    blog: string;
    collaborators?: number;
    company: string;
    created_at: string;
    default_repository_permission?: string;
    description: string;
    disk_usage?: number;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_allowed_repository_creation_type?: string;
    members_can_create_internal_repositories?: boolean;
    members_can_create_private_repositories?: boolean;
    members_can_create_public_repositories?: boolean;
    members_can_create_repositories?: boolean;
    members_url: string;
    name: string;
    node_id: string;
    owned_private_repos?: number;
    plan: OrgsGetResponsePlan;
    private_gists?: number;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    total_private_repos?: number;
    two_factor_requirement_enabled?: boolean;
    type: string;
    url: string;
  };
  type OrgsCreateInvitationResponseInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type OrgsCreateInvitationResponse = {
    created_at: string;
    email: string;
    id: number;
    invitation_team_url: string;
    inviter: OrgsCreateInvitationResponseInviter;
    login: string;
    role: string;
    team_count: number;
  };
  type OrgsCreateHookResponseConfig = { content_type: string; url: string };
  type OrgsCreateHookResponse = {
    active: boolean;
    config: OrgsCreateHookResponseConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    name: string;
    ping_url: string;
    updated_at: string;
    url: string;
  };
  type OrgsConvertMemberToOutsideCollaboratorResponse = {
    documentation_url: string;
    message: string;
  };
  type OrgsAddOrUpdateMembershipResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type OrgsAddOrUpdateMembershipResponseOrganization = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type OrgsAddOrUpdateMembershipResponse = {
    organization: OrgsAddOrUpdateMembershipResponseOrganization;
    organization_url: string;
    role: string;
    state: string;
    url: string;
    user: OrgsAddOrUpdateMembershipResponseUser;
  };
  type OauthAuthorizationsUpdateAuthorizationResponseApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type OauthAuthorizationsUpdateAuthorizationResponse = {
    app: OauthAuthorizationsUpdateAuthorizationResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
  };
  type OauthAuthorizationsResetAuthorizationResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type OauthAuthorizationsResetAuthorizationResponseApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type OauthAuthorizationsResetAuthorizationResponse = {
    app: OauthAuthorizationsResetAuthorizationResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
    user: OauthAuthorizationsResetAuthorizationResponseUser;
  };
  type OauthAuthorizationsListGrantsResponseItemApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type OauthAuthorizationsListGrantsResponseItem = {
    app: OauthAuthorizationsListGrantsResponseItemApp;
    created_at: string;
    id: number;
    scopes: Array<string>;
    updated_at: string;
    url: string;
  };
  type OauthAuthorizationsListAuthorizationsResponseItemApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type OauthAuthorizationsListAuthorizationsResponseItem = {
    app: OauthAuthorizationsListAuthorizationsResponseItemApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
  };
  type OauthAuthorizationsGetOrCreateAuthorizationForAppFingerprintResponseApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type OauthAuthorizationsGetOrCreateAuthorizationForAppFingerprintResponse = {
    app: OauthAuthorizationsGetOrCreateAuthorizationForAppFingerprintResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
  };
  type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponseApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponse = {
    app: OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
  };
  type OauthAuthorizationsGetOrCreateAuthorizationForAppResponseApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type OauthAuthorizationsGetOrCreateAuthorizationForAppResponse = {
    app: OauthAuthorizationsGetOrCreateAuthorizationForAppResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
  };
  type OauthAuthorizationsGetGrantResponseApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type OauthAuthorizationsGetGrantResponse = {
    app: OauthAuthorizationsGetGrantResponseApp;
    created_at: string;
    id: number;
    scopes: Array<string>;
    updated_at: string;
    url: string;
  };
  type OauthAuthorizationsGetAuthorizationResponseApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type OauthAuthorizationsGetAuthorizationResponse = {
    app: OauthAuthorizationsGetAuthorizationResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
  };
  type OauthAuthorizationsCreateAuthorizationResponseApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type OauthAuthorizationsCreateAuthorizationResponse = {
    app: OauthAuthorizationsCreateAuthorizationResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
  };
  type OauthAuthorizationsCheckAuthorizationResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type OauthAuthorizationsCheckAuthorizationResponseApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type OauthAuthorizationsCheckAuthorizationResponse = {
    app: OauthAuthorizationsCheckAuthorizationResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
    user: OauthAuthorizationsCheckAuthorizationResponseUser;
  };
  type MigrationsUpdateImportResponse = {
    authors_url: string;
    html_url: string;
    repository_url: string;
    status: string;
    url: string;
    use_lfs: string;
    vcs: string;
    vcs_url: string;
    authors_count?: number;
    commit_count?: number;
    has_large_files?: boolean;
    large_files_count?: number;
    large_files_size?: number;
    percent?: number;
    status_text?: string;
    tfvc_project?: string;
  };
  type MigrationsStartImportResponse = {
    authors_count: number;
    authors_url: string;
    commit_count: number;
    has_large_files: boolean;
    html_url: string;
    large_files_count: number;
    large_files_size: number;
    percent: number;
    repository_url: string;
    status: string;
    status_text: string;
    url: string;
    use_lfs: string;
    vcs: string;
    vcs_url: string;
  };
  type MigrationsStartForOrgResponseRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type MigrationsStartForOrgResponseRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type MigrationsStartForOrgResponseRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsStartForOrgResponseRepositoriesItemOwner;
    permissions: MigrationsStartForOrgResponseRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type MigrationsStartForOrgResponseOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type MigrationsStartForOrgResponse = {
    created_at: string;
    exclude_attachments: boolean;
    guid: string;
    id: number;
    lock_repositories: boolean;
    owner: MigrationsStartForOrgResponseOwner;
    repositories: Array<MigrationsStartForOrgResponseRepositoriesItem>;
    state: string;
    updated_at: string;
    url: string;
  };
  type MigrationsStartForAuthenticatedUserResponseRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type MigrationsStartForAuthenticatedUserResponseRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type MigrationsStartForAuthenticatedUserResponseRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsStartForAuthenticatedUserResponseRepositoriesItemOwner;
    permissions: MigrationsStartForAuthenticatedUserResponseRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type MigrationsStartForAuthenticatedUserResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type MigrationsStartForAuthenticatedUserResponse = {
    created_at: string;
    exclude_attachments: boolean;
    guid: string;
    id: number;
    lock_repositories: boolean;
    owner: MigrationsStartForAuthenticatedUserResponseOwner;
    repositories: Array<
      MigrationsStartForAuthenticatedUserResponseRepositoriesItem
    >;
    state: string;
    updated_at: string;
    url: string;
  };
  type MigrationsSetLfsPreferenceResponse = {
    authors_count: number;
    authors_url: string;
    has_large_files: boolean;
    html_url: string;
    large_files_count: number;
    large_files_size: number;
    repository_url: string;
    status: string;
    status_text: string;
    url: string;
    use_lfs: string;
    vcs: string;
    vcs_url: string;
  };
  type MigrationsMapCommitAuthorResponse = {
    email: string;
    id: number;
    import_url: string;
    name: string;
    remote_id: string;
    remote_name: string;
    url: string;
  };
  type MigrationsListReposForUserResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type MigrationsListReposForUserResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type MigrationsListReposForUserResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
  };
  type MigrationsListReposForUserResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: MigrationsListReposForUserResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsListReposForUserResponseItemOwner;
    permissions: MigrationsListReposForUserResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type MigrationsListReposForOrgResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type MigrationsListReposForOrgResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type MigrationsListReposForOrgResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
  };
  type MigrationsListReposForOrgResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: MigrationsListReposForOrgResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsListReposForOrgResponseItemOwner;
    permissions: MigrationsListReposForOrgResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type MigrationsListForOrgResponseItemRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type MigrationsListForOrgResponseItemRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type MigrationsListForOrgResponseItemRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsListForOrgResponseItemRepositoriesItemOwner;
    permissions: MigrationsListForOrgResponseItemRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type MigrationsListForOrgResponseItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type MigrationsListForOrgResponseItem = {
    created_at: string;
    exclude_attachments: boolean;
    guid: string;
    id: number;
    lock_repositories: boolean;
    owner: MigrationsListForOrgResponseItemOwner;
    repositories: Array<MigrationsListForOrgResponseItemRepositoriesItem>;
    state: string;
    updated_at: string;
    url: string;
  };
  type MigrationsListForAuthenticatedUserResponseItemRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type MigrationsListForAuthenticatedUserResponseItemRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type MigrationsListForAuthenticatedUserResponseItemRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsListForAuthenticatedUserResponseItemRepositoriesItemOwner;
    permissions: MigrationsListForAuthenticatedUserResponseItemRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type MigrationsListForAuthenticatedUserResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type MigrationsListForAuthenticatedUserResponseItem = {
    created_at: string;
    exclude_attachments: boolean;
    guid: string;
    id: number;
    lock_repositories: boolean;
    owner: MigrationsListForAuthenticatedUserResponseItemOwner;
    repositories: Array<
      MigrationsListForAuthenticatedUserResponseItemRepositoriesItem
    >;
    state: string;
    updated_at: string;
    url: string;
  };
  type MigrationsGetStatusForOrgResponseRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type MigrationsGetStatusForOrgResponseRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type MigrationsGetStatusForOrgResponseRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsGetStatusForOrgResponseRepositoriesItemOwner;
    permissions: MigrationsGetStatusForOrgResponseRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type MigrationsGetStatusForOrgResponseOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type MigrationsGetStatusForOrgResponse = {
    created_at: string;
    exclude_attachments: boolean;
    guid: string;
    id: number;
    lock_repositories: boolean;
    owner: MigrationsGetStatusForOrgResponseOwner;
    repositories: Array<MigrationsGetStatusForOrgResponseRepositoriesItem>;
    state: string;
    updated_at: string;
    url: string;
  };
  type MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItemOwner;
    permissions: MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type MigrationsGetStatusForAuthenticatedUserResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type MigrationsGetStatusForAuthenticatedUserResponse = {
    created_at: string;
    exclude_attachments: boolean;
    guid: string;
    id: number;
    lock_repositories: boolean;
    owner: MigrationsGetStatusForAuthenticatedUserResponseOwner;
    repositories: Array<
      MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItem
    >;
    state: string;
    updated_at: string;
    url: string;
  };
  type MigrationsGetLargeFilesResponseItem = {
    oid: string;
    path: string;
    ref_name: string;
    size: number;
  };
  type MigrationsGetImportProgressResponse = {
    authors_count: number;
    authors_url: string;
    has_large_files: boolean;
    html_url: string;
    large_files_count: number;
    large_files_size: number;
    repository_url: string;
    status: string;
    status_text: string;
    url: string;
    use_lfs: string;
    vcs: string;
    vcs_url: string;
  };
  type MigrationsGetCommitAuthorsResponseItem = {
    email: string;
    id: number;
    import_url: string;
    name: string;
    remote_id: string;
    remote_name: string;
    url: string;
  };
  type MetaGetResponseSshKeyFingerprints = {
    MD5_DSA: string;
    MD5_RSA: string;
    SHA256_DSA: string;
    SHA256_RSA: string;
  };
  type MetaGetResponse = {
    api: Array<string>;
    git: Array<string>;
    hooks: Array<string>;
    importer: Array<string>;
    pages: Array<string>;
    ssh_key_fingerprints: MetaGetResponseSshKeyFingerprints;
    verifiable_password_authentication: boolean;
    web: Array<string>;
  };
  type LicensesListCommonlyUsedResponseItem = {
    key: string;
    name: string;
    node_id?: string;
    spdx_id: string;
    url: string;
  };
  type LicensesListResponseItem = {
    key: string;
    name: string;
    node_id?: string;
    spdx_id: string;
    url: string;
  };
  type LicensesGetForRepoResponseLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
  };
  type LicensesGetForRepoResponseLinks = {
    git: string;
    html: string;
    self: string;
  };
  type LicensesGetForRepoResponse = {
    _links: LicensesGetForRepoResponseLinks;
    content: string;
    download_url: string;
    encoding: string;
    git_url: string;
    html_url: string;
    license: LicensesGetForRepoResponseLicense;
    name: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
  };
  type LicensesGetResponse = {
    body: string;
    conditions: Array<string>;
    description: string;
    featured: boolean;
    html_url: string;
    implementation: string;
    key: string;
    limitations: Array<string>;
    name: string;
    node_id: string;
    permissions: Array<string>;
    spdx_id: string;
    url: string;
  };
  type IssuesUpdateMilestoneResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesUpdateMilestoneResponse = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesUpdateMilestoneResponseCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesUpdateLabelResponse = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesUpdateCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesUpdateCommentResponse = {
    body: string;
    created_at: string;
    html_url: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: IssuesUpdateCommentResponseUser;
  };
  type IssuesUpdateResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesUpdateResponsePullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
  };
  type IssuesUpdateResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesUpdateResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesUpdateResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesUpdateResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesUpdateResponseClosedBy = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesUpdateResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesUpdateResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesUpdateResponse = {
    active_lock_reason: string;
    assignee: IssuesUpdateResponseAssignee;
    assignees: Array<IssuesUpdateResponseAssigneesItem>;
    body: string;
    closed_at: null;
    closed_by: IssuesUpdateResponseClosedBy;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesUpdateResponseLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesUpdateResponseMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesUpdateResponsePullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesUpdateResponseUser;
  };
  type IssuesReplaceLabelsResponseItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesRemoveLabelResponseItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesRemoveAssigneesResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesRemoveAssigneesResponsePullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
  };
  type IssuesRemoveAssigneesResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesRemoveAssigneesResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesRemoveAssigneesResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesRemoveAssigneesResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesRemoveAssigneesResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesRemoveAssigneesResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesRemoveAssigneesResponse = {
    active_lock_reason: string;
    assignee: IssuesRemoveAssigneesResponseAssignee;
    assignees: Array<IssuesRemoveAssigneesResponseAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesRemoveAssigneesResponseLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesRemoveAssigneesResponseMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesRemoveAssigneesResponsePullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesRemoveAssigneesResponseUser;
  };
  type IssuesListMilestonesForRepoResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListMilestonesForRepoResponseItem = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesListMilestonesForRepoResponseItemCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesListLabelsOnIssueResponseItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesListLabelsForRepoResponseItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesListLabelsForMilestoneResponseItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesListForRepoResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListForRepoResponseItemPullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
  };
  type IssuesListForRepoResponseItemMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListForRepoResponseItemMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesListForRepoResponseItemMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesListForRepoResponseItemLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesListForRepoResponseItemAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListForRepoResponseItemAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListForRepoResponseItem = {
    active_lock_reason: string;
    assignee: IssuesListForRepoResponseItemAssignee;
    assignees: Array<IssuesListForRepoResponseItemAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesListForRepoResponseItemLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesListForRepoResponseItemMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesListForRepoResponseItemPullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesListForRepoResponseItemUser;
  };
  type IssuesListForOrgResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListForOrgResponseItemRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type IssuesListForOrgResponseItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListForOrgResponseItemRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: IssuesListForOrgResponseItemRepositoryOwner;
    permissions: IssuesListForOrgResponseItemRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type IssuesListForOrgResponseItemPullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
  };
  type IssuesListForOrgResponseItemMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListForOrgResponseItemMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesListForOrgResponseItemMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesListForOrgResponseItemLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesListForOrgResponseItemAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListForOrgResponseItemAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListForOrgResponseItem = {
    active_lock_reason: string;
    assignee: IssuesListForOrgResponseItemAssignee;
    assignees: Array<IssuesListForOrgResponseItemAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesListForOrgResponseItemLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesListForOrgResponseItemMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesListForOrgResponseItemPullRequest;
    repository: IssuesListForOrgResponseItemRepository;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesListForOrgResponseItemUser;
  };
  type IssuesListForAuthenticatedUserResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListForAuthenticatedUserResponseItemRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type IssuesListForAuthenticatedUserResponseItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListForAuthenticatedUserResponseItemRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: IssuesListForAuthenticatedUserResponseItemRepositoryOwner;
    permissions: IssuesListForAuthenticatedUserResponseItemRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type IssuesListForAuthenticatedUserResponseItemPullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
  };
  type IssuesListForAuthenticatedUserResponseItemMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListForAuthenticatedUserResponseItemMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesListForAuthenticatedUserResponseItemMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesListForAuthenticatedUserResponseItemLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesListForAuthenticatedUserResponseItemAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListForAuthenticatedUserResponseItemAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListForAuthenticatedUserResponseItem = {
    active_lock_reason: string;
    assignee: IssuesListForAuthenticatedUserResponseItemAssignee;
    assignees: Array<IssuesListForAuthenticatedUserResponseItemAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesListForAuthenticatedUserResponseItemLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesListForAuthenticatedUserResponseItemMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesListForAuthenticatedUserResponseItemPullRequest;
    repository: IssuesListForAuthenticatedUserResponseItemRepository;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesListForAuthenticatedUserResponseItemUser;
  };
  type IssuesListEventsForTimelineResponseItemActor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListEventsForTimelineResponseItem = {
    actor: IssuesListEventsForTimelineResponseItemActor;
    commit_id: string;
    commit_url: string;
    created_at: string;
    event: string;
    id: number;
    node_id: string;
    url: string;
  };
  type IssuesListEventsForRepoResponseItemIssueUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListEventsForRepoResponseItemIssuePullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
  };
  type IssuesListEventsForRepoResponseItemIssueMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListEventsForRepoResponseItemIssueMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesListEventsForRepoResponseItemIssueMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesListEventsForRepoResponseItemIssueLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesListEventsForRepoResponseItemIssueAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListEventsForRepoResponseItemIssueAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListEventsForRepoResponseItemIssue = {
    active_lock_reason: string;
    assignee: IssuesListEventsForRepoResponseItemIssueAssignee;
    assignees: Array<IssuesListEventsForRepoResponseItemIssueAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesListEventsForRepoResponseItemIssueLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesListEventsForRepoResponseItemIssueMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesListEventsForRepoResponseItemIssuePullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesListEventsForRepoResponseItemIssueUser;
  };
  type IssuesListEventsForRepoResponseItemActor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListEventsForRepoResponseItem = {
    actor: IssuesListEventsForRepoResponseItemActor;
    commit_id: string;
    commit_url: string;
    created_at: string;
    event: string;
    id: number;
    issue: IssuesListEventsForRepoResponseItemIssue;
    node_id: string;
    url: string;
  };
  type IssuesListEventsResponseItemActor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListEventsResponseItem = {
    actor: IssuesListEventsResponseItemActor;
    commit_id: string;
    commit_url: string;
    created_at: string;
    event: string;
    id: number;
    node_id: string;
    url: string;
  };
  type IssuesListCommentsForRepoResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListCommentsForRepoResponseItem = {
    body: string;
    created_at: string;
    html_url: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: IssuesListCommentsForRepoResponseItemUser;
  };
  type IssuesListCommentsResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListCommentsResponseItem = {
    body: string;
    created_at: string;
    html_url: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: IssuesListCommentsResponseItemUser;
  };
  type IssuesListAssigneesResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListResponseItemRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type IssuesListResponseItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListResponseItemRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: IssuesListResponseItemRepositoryOwner;
    permissions: IssuesListResponseItemRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type IssuesListResponseItemPullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
  };
  type IssuesListResponseItemMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListResponseItemMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesListResponseItemMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesListResponseItemLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesListResponseItemAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListResponseItemAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesListResponseItem = {
    active_lock_reason: string;
    assignee: IssuesListResponseItemAssignee;
    assignees: Array<IssuesListResponseItemAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesListResponseItemLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesListResponseItemMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesListResponseItemPullRequest;
    repository: IssuesListResponseItemRepository;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesListResponseItemUser;
  };
  type IssuesGetMilestoneResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesGetMilestoneResponse = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesGetMilestoneResponseCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesGetLabelResponse = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesGetEventResponseIssueUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesGetEventResponseIssuePullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
  };
  type IssuesGetEventResponseIssueMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesGetEventResponseIssueMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesGetEventResponseIssueMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesGetEventResponseIssueLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesGetEventResponseIssueAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesGetEventResponseIssueAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesGetEventResponseIssue = {
    active_lock_reason: string;
    assignee: IssuesGetEventResponseIssueAssignee;
    assignees: Array<IssuesGetEventResponseIssueAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesGetEventResponseIssueLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesGetEventResponseIssueMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesGetEventResponseIssuePullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesGetEventResponseIssueUser;
  };
  type IssuesGetEventResponseActor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesGetEventResponse = {
    actor: IssuesGetEventResponseActor;
    commit_id: string;
    commit_url: string;
    created_at: string;
    event: string;
    id: number;
    issue: IssuesGetEventResponseIssue;
    node_id: string;
    url: string;
  };
  type IssuesGetCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesGetCommentResponse = {
    body: string;
    created_at: string;
    html_url: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: IssuesGetCommentResponseUser;
  };
  type IssuesGetResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesGetResponsePullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
  };
  type IssuesGetResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesGetResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesGetResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesGetResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesGetResponseClosedBy = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesGetResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesGetResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesGetResponse = {
    active_lock_reason: string;
    assignee: IssuesGetResponseAssignee;
    assignees: Array<IssuesGetResponseAssigneesItem>;
    body: string;
    closed_at: null;
    closed_by: IssuesGetResponseClosedBy;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesGetResponseLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesGetResponseMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesGetResponsePullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesGetResponseUser;
  };
  type IssuesCreateMilestoneResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesCreateMilestoneResponse = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesCreateMilestoneResponseCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesCreateLabelResponse = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesCreateCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesCreateCommentResponse = {
    body: string;
    created_at: string;
    html_url: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: IssuesCreateCommentResponseUser;
  };
  type IssuesCreateResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesCreateResponsePullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
  };
  type IssuesCreateResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesCreateResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesCreateResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesCreateResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesCreateResponseClosedBy = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesCreateResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesCreateResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesCreateResponse = {
    active_lock_reason: string;
    assignee: IssuesCreateResponseAssignee;
    assignees: Array<IssuesCreateResponseAssigneesItem>;
    body: string;
    closed_at: null;
    closed_by: IssuesCreateResponseClosedBy;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesCreateResponseLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesCreateResponseMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesCreateResponsePullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesCreateResponseUser;
  };
  type IssuesAddLabelsResponseItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesAddAssigneesResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesAddAssigneesResponsePullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
  };
  type IssuesAddAssigneesResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesAddAssigneesResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesAddAssigneesResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
  };
  type IssuesAddAssigneesResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  };
  type IssuesAddAssigneesResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesAddAssigneesResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type IssuesAddAssigneesResponse = {
    active_lock_reason: string;
    assignee: IssuesAddAssigneesResponseAssignee;
    assignees: Array<IssuesAddAssigneesResponseAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesAddAssigneesResponseLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesAddAssigneesResponseMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesAddAssigneesResponsePullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesAddAssigneesResponseUser;
  };
  type InteractionsGetRestrictionsForRepoResponse = {
    expires_at: string;
    limit: string;
    origin: string;
  };
  type InteractionsGetRestrictionsForOrgResponse = {
    expires_at: string;
    limit: string;
    origin: string;
  };
  type InteractionsAddOrUpdateRestrictionsForRepoResponse = {
    expires_at: string;
    limit: string;
    origin: string;
  };
  type InteractionsAddOrUpdateRestrictionsForOrgResponse = {
    expires_at: string;
    limit: string;
    origin: string;
  };
  type GitignoreGetTemplateResponse = { name: string; source: string };
  type GitUpdateRefResponseObject = { sha: string; type: string; url: string };
  type GitUpdateRefResponse = {
    node_id: string;
    object: GitUpdateRefResponseObject;
    ref: string;
    url: string;
  };
  type GitListMatchingRefsResponseItemObject = {
    sha: string;
    type: string;
    url: string;
  };
  type GitListMatchingRefsResponseItem = {
    node_id: string;
    object: GitListMatchingRefsResponseItemObject;
    ref: string;
    url: string;
  };
  type GitGetTreeResponseTreeItem = {
    mode: string;
    path: string;
    sha: string;
    size?: number;
    type: string;
    url: string;
  };
  type GitGetTreeResponse = {
    sha: string;
    tree: Array<GitGetTreeResponseTreeItem>;
    truncated: boolean;
    url: string;
  };
  type GitGetTagResponseVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type GitGetTagResponseTagger = { date: string; email: string; name: string };
  type GitGetTagResponseObject = { sha: string; type: string; url: string };
  type GitGetTagResponse = {
    message: string;
    node_id: string;
    object: GitGetTagResponseObject;
    sha: string;
    tag: string;
    tagger: GitGetTagResponseTagger;
    url: string;
    verification: GitGetTagResponseVerification;
  };
  type GitGetRefResponseObject = { sha: string; type: string; url: string };
  type GitGetRefResponse = {
    node_id: string;
    object: GitGetRefResponseObject;
    ref: string;
    url: string;
  };
  type GitGetCommitResponseVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type GitGetCommitResponseTree = { sha: string; url: string };
  type GitGetCommitResponseParentsItem = { sha: string; url: string };
  type GitGetCommitResponseCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type GitGetCommitResponseAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type GitGetCommitResponse = {
    author: GitGetCommitResponseAuthor;
    committer: GitGetCommitResponseCommitter;
    message: string;
    parents: Array<GitGetCommitResponseParentsItem>;
    sha: string;
    tree: GitGetCommitResponseTree;
    url: string;
    verification: GitGetCommitResponseVerification;
  };
  type GitGetBlobResponse = {
    content: string;
    encoding: string;
    sha: string;
    size: number;
    url: string;
  };
  type GitCreateTreeResponseTreeItem = {
    mode: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
  };
  type GitCreateTreeResponse = {
    sha: string;
    tree: Array<GitCreateTreeResponseTreeItem>;
    url: string;
  };
  type GitCreateTagResponseVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type GitCreateTagResponseTagger = {
    date: string;
    email: string;
    name: string;
  };
  type GitCreateTagResponseObject = { sha: string; type: string; url: string };
  type GitCreateTagResponse = {
    message: string;
    node_id: string;
    object: GitCreateTagResponseObject;
    sha: string;
    tag: string;
    tagger: GitCreateTagResponseTagger;
    url: string;
    verification: GitCreateTagResponseVerification;
  };
  type GitCreateRefResponseObject = { sha: string; type: string; url: string };
  type GitCreateRefResponse = {
    node_id: string;
    object: GitCreateRefResponseObject;
    ref: string;
    url: string;
  };
  type GitCreateCommitResponseVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
  };
  type GitCreateCommitResponseTree = { sha: string; url: string };
  type GitCreateCommitResponseParentsItem = { sha: string; url: string };
  type GitCreateCommitResponseCommitter = {
    date: string;
    email: string;
    name: string;
  };
  type GitCreateCommitResponseAuthor = {
    date: string;
    email: string;
    name: string;
  };
  type GitCreateCommitResponse = {
    author: GitCreateCommitResponseAuthor;
    committer: GitCreateCommitResponseCommitter;
    message: string;
    node_id: string;
    parents: Array<GitCreateCommitResponseParentsItem>;
    sha: string;
    tree: GitCreateCommitResponseTree;
    url: string;
    verification: GitCreateCommitResponseVerification;
  };
  type GitCreateBlobResponse = { sha: string; url: string };
  type GistsUpdateCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsUpdateCommentResponse = {
    body: string;
    created_at: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: GistsUpdateCommentResponseUser;
  };
  type GistsUpdateResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsUpdateResponseHistoryItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsUpdateResponseHistoryItemChangeStatus = {
    additions: number;
    deletions: number;
    total: number;
  };
  type GistsUpdateResponseHistoryItem = {
    change_status: GistsUpdateResponseHistoryItemChangeStatus;
    committed_at: string;
    url: string;
    user: GistsUpdateResponseHistoryItemUser;
    version: string;
  };
  type GistsUpdateResponseForksItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsUpdateResponseForksItem = {
    created_at: string;
    id: string;
    updated_at: string;
    url: string;
    user: GistsUpdateResponseForksItemUser;
  };
  type GistsUpdateResponseFilesNewFileTxt = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsUpdateResponseFilesHelloWorldRb = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsUpdateResponseFilesHelloWorldPy = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsUpdateResponseFilesHelloWorldMd = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsUpdateResponseFiles = {
    "hello_world.md": GistsUpdateResponseFilesHelloWorldMd;
    "hello_world.py": GistsUpdateResponseFilesHelloWorldPy;
    "hello_world.rb": GistsUpdateResponseFilesHelloWorldRb;
    "new_file.txt": GistsUpdateResponseFilesNewFileTxt;
  };
  type GistsUpdateResponse = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsUpdateResponseFiles;
    forks: Array<GistsUpdateResponseForksItem>;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    history: Array<GistsUpdateResponseHistoryItem>;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsUpdateResponseOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
  };
  type GistsListStarredResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsListStarredResponseItemFilesHelloWorldRb = {
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    type: string;
  };
  type GistsListStarredResponseItemFiles = {
    "hello_world.rb": GistsListStarredResponseItemFilesHelloWorldRb;
  };
  type GistsListStarredResponseItem = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsListStarredResponseItemFiles;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsListStarredResponseItemOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
  };
  type GistsListPublicForUserResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsListPublicForUserResponseItemFilesHelloWorldRb = {
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    type: string;
  };
  type GistsListPublicForUserResponseItemFiles = {
    "hello_world.rb": GistsListPublicForUserResponseItemFilesHelloWorldRb;
  };
  type GistsListPublicForUserResponseItem = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsListPublicForUserResponseItemFiles;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsListPublicForUserResponseItemOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
  };
  type GistsListPublicResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsListPublicResponseItemFilesHelloWorldRb = {
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    type: string;
  };
  type GistsListPublicResponseItemFiles = {
    "hello_world.rb": GistsListPublicResponseItemFilesHelloWorldRb;
  };
  type GistsListPublicResponseItem = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsListPublicResponseItemFiles;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsListPublicResponseItemOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
  };
  type GistsListForksResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsListForksResponseItem = {
    created_at: string;
    id: string;
    updated_at: string;
    url: string;
    user: GistsListForksResponseItemUser;
  };
  type GistsListCommitsResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsListCommitsResponseItemChangeStatus = {
    additions: number;
    deletions: number;
    total: number;
  };
  type GistsListCommitsResponseItem = {
    change_status: GistsListCommitsResponseItemChangeStatus;
    committed_at: string;
    url: string;
    user: GistsListCommitsResponseItemUser;
    version: string;
  };
  type GistsListCommentsResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsListCommentsResponseItem = {
    body: string;
    created_at: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: GistsListCommentsResponseItemUser;
  };
  type GistsListResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsListResponseItemFilesHelloWorldRb = {
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    type: string;
  };
  type GistsListResponseItemFiles = {
    "hello_world.rb": GistsListResponseItemFilesHelloWorldRb;
  };
  type GistsListResponseItem = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsListResponseItemFiles;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsListResponseItemOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
  };
  type GistsGetRevisionResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsGetRevisionResponseHistoryItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsGetRevisionResponseHistoryItemChangeStatus = {
    additions: number;
    deletions: number;
    total: number;
  };
  type GistsGetRevisionResponseHistoryItem = {
    change_status: GistsGetRevisionResponseHistoryItemChangeStatus;
    committed_at: string;
    url: string;
    user: GistsGetRevisionResponseHistoryItemUser;
    version: string;
  };
  type GistsGetRevisionResponseForksItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsGetRevisionResponseForksItem = {
    created_at: string;
    id: string;
    updated_at: string;
    url: string;
    user: GistsGetRevisionResponseForksItemUser;
  };
  type GistsGetRevisionResponseFilesHelloWorldRubyTxt = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsGetRevisionResponseFilesHelloWorldPythonTxt = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsGetRevisionResponseFilesHelloWorldRb = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsGetRevisionResponseFilesHelloWorldPy = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsGetRevisionResponseFiles = {
    "hello_world.py": GistsGetRevisionResponseFilesHelloWorldPy;
    "hello_world.rb": GistsGetRevisionResponseFilesHelloWorldRb;
    "hello_world_python.txt": GistsGetRevisionResponseFilesHelloWorldPythonTxt;
    "hello_world_ruby.txt": GistsGetRevisionResponseFilesHelloWorldRubyTxt;
  };
  type GistsGetRevisionResponse = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsGetRevisionResponseFiles;
    forks: Array<GistsGetRevisionResponseForksItem>;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    history: Array<GistsGetRevisionResponseHistoryItem>;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsGetRevisionResponseOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
  };
  type GistsGetCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsGetCommentResponse = {
    body: string;
    created_at: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: GistsGetCommentResponseUser;
  };
  type GistsGetResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsGetResponseHistoryItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsGetResponseHistoryItemChangeStatus = {
    additions: number;
    deletions: number;
    total: number;
  };
  type GistsGetResponseHistoryItem = {
    change_status: GistsGetResponseHistoryItemChangeStatus;
    committed_at: string;
    url: string;
    user: GistsGetResponseHistoryItemUser;
    version: string;
  };
  type GistsGetResponseForksItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsGetResponseForksItem = {
    created_at: string;
    id: string;
    updated_at: string;
    url: string;
    user: GistsGetResponseForksItemUser;
  };
  type GistsGetResponseFilesHelloWorldRubyTxt = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsGetResponseFilesHelloWorldPythonTxt = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsGetResponseFilesHelloWorldRb = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsGetResponseFilesHelloWorldPy = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsGetResponseFiles = {
    "hello_world.py": GistsGetResponseFilesHelloWorldPy;
    "hello_world.rb": GistsGetResponseFilesHelloWorldRb;
    "hello_world_python.txt": GistsGetResponseFilesHelloWorldPythonTxt;
    "hello_world_ruby.txt": GistsGetResponseFilesHelloWorldRubyTxt;
  };
  type GistsGetResponse = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsGetResponseFiles;
    forks: Array<GistsGetResponseForksItem>;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    history: Array<GistsGetResponseHistoryItem>;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsGetResponseOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
  };
  type GistsForkResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsForkResponseFilesHelloWorldRb = {
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    type: string;
  };
  type GistsForkResponseFiles = {
    "hello_world.rb": GistsForkResponseFilesHelloWorldRb;
  };
  type GistsForkResponse = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsForkResponseFiles;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsForkResponseOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
  };
  type GistsCreateCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsCreateCommentResponse = {
    body: string;
    created_at: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: GistsCreateCommentResponseUser;
  };
  type GistsCreateResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsCreateResponseHistoryItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsCreateResponseHistoryItemChangeStatus = {
    additions: number;
    deletions: number;
    total: number;
  };
  type GistsCreateResponseHistoryItem = {
    change_status: GistsCreateResponseHistoryItemChangeStatus;
    committed_at: string;
    url: string;
    user: GistsCreateResponseHistoryItemUser;
    version: string;
  };
  type GistsCreateResponseForksItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type GistsCreateResponseForksItem = {
    created_at: string;
    id: string;
    updated_at: string;
    url: string;
    user: GistsCreateResponseForksItemUser;
  };
  type GistsCreateResponseFilesHelloWorldRubyTxt = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsCreateResponseFilesHelloWorldPythonTxt = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsCreateResponseFilesHelloWorldRb = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsCreateResponseFilesHelloWorldPy = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
  };
  type GistsCreateResponseFiles = {
    "hello_world.py": GistsCreateResponseFilesHelloWorldPy;
    "hello_world.rb": GistsCreateResponseFilesHelloWorldRb;
    "hello_world_python.txt": GistsCreateResponseFilesHelloWorldPythonTxt;
    "hello_world_ruby.txt": GistsCreateResponseFilesHelloWorldRubyTxt;
  };
  type GistsCreateResponse = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsCreateResponseFiles;
    forks: Array<GistsCreateResponseForksItem>;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    history: Array<GistsCreateResponseHistoryItem>;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsCreateResponseOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
  };
  type CodesOfConductListConductCodesResponseItem = {
    key: string;
    name: string;
    url: string;
  };
  type CodesOfConductGetForRepoResponse = {
    body: string;
    key: string;
    name: string;
    url: string;
  };
  type CodesOfConductGetConductCodeResponse = {
    body: string;
    key: string;
    name: string;
    url: string;
  };
  type ChecksUpdateResponsePullRequestsItemHeadRepo = {
    id: number;
    name: string;
    url: string;
  };
  type ChecksUpdateResponsePullRequestsItemHead = {
    ref: string;
    repo: ChecksUpdateResponsePullRequestsItemHeadRepo;
    sha: string;
  };
  type ChecksUpdateResponsePullRequestsItemBaseRepo = {
    id: number;
    name: string;
    url: string;
  };
  type ChecksUpdateResponsePullRequestsItemBase = {
    ref: string;
    repo: ChecksUpdateResponsePullRequestsItemBaseRepo;
    sha: string;
  };
  type ChecksUpdateResponsePullRequestsItem = {
    base: ChecksUpdateResponsePullRequestsItemBase;
    head: ChecksUpdateResponsePullRequestsItemHead;
    id: number;
    number: number;
    url: string;
  };
  type ChecksUpdateResponseOutput = {
    annotations_count: number;
    annotations_url: string;
    summary: string;
    text: string;
    title: string;
  };
  type ChecksUpdateResponseCheckSuite = { id: number };
  type ChecksUpdateResponseAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ChecksUpdateResponseAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ChecksUpdateResponseApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksUpdateResponseAppOwner;
    permissions: ChecksUpdateResponseAppPermissions;
    slug: string;
    updated_at: string;
  };
  type ChecksUpdateResponse = {
    app: ChecksUpdateResponseApp;
    check_suite: ChecksUpdateResponseCheckSuite;
    completed_at: string;
    conclusion: string;
    details_url: string;
    external_id: string;
    head_sha: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    output: ChecksUpdateResponseOutput;
    pull_requests: Array<ChecksUpdateResponsePullRequestsItem>;
    started_at: string;
    status: string;
    url: string;
  };
  type ChecksSetSuitesPreferencesResponseRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ChecksSetSuitesPreferencesResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ChecksSetSuitesPreferencesResponseRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ChecksSetSuitesPreferencesResponseRepositoryOwner;
    permissions: ChecksSetSuitesPreferencesResponseRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ChecksSetSuitesPreferencesResponsePreferencesAutoTriggerChecksItem = {
    app_id: number;
    setting: boolean;
  };
  type ChecksSetSuitesPreferencesResponsePreferences = {
    auto_trigger_checks: Array<
      ChecksSetSuitesPreferencesResponsePreferencesAutoTriggerChecksItem
    >;
  };
  type ChecksSetSuitesPreferencesResponse = {
    preferences: ChecksSetSuitesPreferencesResponsePreferences;
    repository: ChecksSetSuitesPreferencesResponseRepository;
  };
  type ChecksListSuitesForRefResponseCheckSuitesItemRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ChecksListSuitesForRefResponseCheckSuitesItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ChecksListSuitesForRefResponseCheckSuitesItemRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ChecksListSuitesForRefResponseCheckSuitesItemRepositoryOwner;
    permissions: ChecksListSuitesForRefResponseCheckSuitesItemRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ChecksListSuitesForRefResponseCheckSuitesItemAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ChecksListSuitesForRefResponseCheckSuitesItemAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ChecksListSuitesForRefResponseCheckSuitesItemApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksListSuitesForRefResponseCheckSuitesItemAppOwner;
    permissions: ChecksListSuitesForRefResponseCheckSuitesItemAppPermissions;
    slug: string;
    updated_at: string;
  };
  type ChecksListSuitesForRefResponseCheckSuitesItem = {
    after: string;
    app: ChecksListSuitesForRefResponseCheckSuitesItemApp;
    before: string;
    conclusion: string;
    head_branch: string;
    head_sha: string;
    id: number;
    node_id: string;
    pull_requests: Array<any>;
    repository: ChecksListSuitesForRefResponseCheckSuitesItemRepository;
    status: string;
    url: string;
  };
  type ChecksListSuitesForRefResponse = {
    check_suites: Array<ChecksListSuitesForRefResponseCheckSuitesItem>;
    total_count: number;
  };
  type ChecksListForSuiteResponseCheckRunsItemPullRequestsItemHeadRepo = {
    id: number;
    name: string;
    url: string;
  };
  type ChecksListForSuiteResponseCheckRunsItemPullRequestsItemHead = {
    ref: string;
    repo: ChecksListForSuiteResponseCheckRunsItemPullRequestsItemHeadRepo;
    sha: string;
  };
  type ChecksListForSuiteResponseCheckRunsItemPullRequestsItemBaseRepo = {
    id: number;
    name: string;
    url: string;
  };
  type ChecksListForSuiteResponseCheckRunsItemPullRequestsItemBase = {
    ref: string;
    repo: ChecksListForSuiteResponseCheckRunsItemPullRequestsItemBaseRepo;
    sha: string;
  };
  type ChecksListForSuiteResponseCheckRunsItemPullRequestsItem = {
    base: ChecksListForSuiteResponseCheckRunsItemPullRequestsItemBase;
    head: ChecksListForSuiteResponseCheckRunsItemPullRequestsItemHead;
    id: number;
    number: number;
    url: string;
  };
  type ChecksListForSuiteResponseCheckRunsItemOutput = {
    annotations_count: number;
    annotations_url: string;
    summary: string;
    text: string;
    title: string;
  };
  type ChecksListForSuiteResponseCheckRunsItemCheckSuite = { id: number };
  type ChecksListForSuiteResponseCheckRunsItemAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ChecksListForSuiteResponseCheckRunsItemAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ChecksListForSuiteResponseCheckRunsItemApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksListForSuiteResponseCheckRunsItemAppOwner;
    permissions: ChecksListForSuiteResponseCheckRunsItemAppPermissions;
    slug: string;
    updated_at: string;
  };
  type ChecksListForSuiteResponseCheckRunsItem = {
    app: ChecksListForSuiteResponseCheckRunsItemApp;
    check_suite: ChecksListForSuiteResponseCheckRunsItemCheckSuite;
    completed_at: string;
    conclusion: string;
    details_url: string;
    external_id: string;
    head_sha: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    output: ChecksListForSuiteResponseCheckRunsItemOutput;
    pull_requests: Array<
      ChecksListForSuiteResponseCheckRunsItemPullRequestsItem
    >;
    started_at: string;
    status: string;
    url: string;
  };
  type ChecksListForSuiteResponse = {
    check_runs: Array<ChecksListForSuiteResponseCheckRunsItem>;
    total_count: number;
  };
  type ChecksListForRefResponseCheckRunsItemPullRequestsItemHeadRepo = {
    id: number;
    name: string;
    url: string;
  };
  type ChecksListForRefResponseCheckRunsItemPullRequestsItemHead = {
    ref: string;
    repo: ChecksListForRefResponseCheckRunsItemPullRequestsItemHeadRepo;
    sha: string;
  };
  type ChecksListForRefResponseCheckRunsItemPullRequestsItemBaseRepo = {
    id: number;
    name: string;
    url: string;
  };
  type ChecksListForRefResponseCheckRunsItemPullRequestsItemBase = {
    ref: string;
    repo: ChecksListForRefResponseCheckRunsItemPullRequestsItemBaseRepo;
    sha: string;
  };
  type ChecksListForRefResponseCheckRunsItemPullRequestsItem = {
    base: ChecksListForRefResponseCheckRunsItemPullRequestsItemBase;
    head: ChecksListForRefResponseCheckRunsItemPullRequestsItemHead;
    id: number;
    number: number;
    url: string;
  };
  type ChecksListForRefResponseCheckRunsItemOutput = {
    annotations_count: number;
    annotations_url: string;
    summary: string;
    text: string;
    title: string;
  };
  type ChecksListForRefResponseCheckRunsItemCheckSuite = { id: number };
  type ChecksListForRefResponseCheckRunsItemAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ChecksListForRefResponseCheckRunsItemAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ChecksListForRefResponseCheckRunsItemApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksListForRefResponseCheckRunsItemAppOwner;
    permissions: ChecksListForRefResponseCheckRunsItemAppPermissions;
    slug: string;
    updated_at: string;
  };
  type ChecksListForRefResponseCheckRunsItem = {
    app: ChecksListForRefResponseCheckRunsItemApp;
    check_suite: ChecksListForRefResponseCheckRunsItemCheckSuite;
    completed_at: string;
    conclusion: string;
    details_url: string;
    external_id: string;
    head_sha: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    output: ChecksListForRefResponseCheckRunsItemOutput;
    pull_requests: Array<ChecksListForRefResponseCheckRunsItemPullRequestsItem>;
    started_at: string;
    status: string;
    url: string;
  };
  type ChecksListForRefResponse = {
    check_runs: Array<ChecksListForRefResponseCheckRunsItem>;
    total_count: number;
  };
  type ChecksListAnnotationsResponseItem = {
    annotation_level: string;
    end_column: number;
    end_line: number;
    message: string;
    path: string;
    raw_details: string;
    start_column: number;
    start_line: number;
    title: string;
  };
  type ChecksGetSuiteResponseRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ChecksGetSuiteResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ChecksGetSuiteResponseRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ChecksGetSuiteResponseRepositoryOwner;
    permissions: ChecksGetSuiteResponseRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ChecksGetSuiteResponseAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ChecksGetSuiteResponseAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ChecksGetSuiteResponseApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksGetSuiteResponseAppOwner;
    permissions: ChecksGetSuiteResponseAppPermissions;
    slug: string;
    updated_at: string;
  };
  type ChecksGetSuiteResponse = {
    after: string;
    app: ChecksGetSuiteResponseApp;
    before: string;
    conclusion: string;
    head_branch: string;
    head_sha: string;
    id: number;
    node_id: string;
    pull_requests: Array<any>;
    repository: ChecksGetSuiteResponseRepository;
    status: string;
    url: string;
  };
  type ChecksGetResponsePullRequestsItemHeadRepo = {
    id: number;
    name: string;
    url: string;
  };
  type ChecksGetResponsePullRequestsItemHead = {
    ref: string;
    repo: ChecksGetResponsePullRequestsItemHeadRepo;
    sha: string;
  };
  type ChecksGetResponsePullRequestsItemBaseRepo = {
    id: number;
    name: string;
    url: string;
  };
  type ChecksGetResponsePullRequestsItemBase = {
    ref: string;
    repo: ChecksGetResponsePullRequestsItemBaseRepo;
    sha: string;
  };
  type ChecksGetResponsePullRequestsItem = {
    base: ChecksGetResponsePullRequestsItemBase;
    head: ChecksGetResponsePullRequestsItemHead;
    id: number;
    number: number;
    url: string;
  };
  type ChecksGetResponseOutput = {
    annotations_count: number;
    annotations_url: string;
    summary: string;
    text: string;
    title: string;
  };
  type ChecksGetResponseCheckSuite = { id: number };
  type ChecksGetResponseAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ChecksGetResponseAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ChecksGetResponseApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksGetResponseAppOwner;
    permissions: ChecksGetResponseAppPermissions;
    slug: string;
    updated_at: string;
  };
  type ChecksGetResponse = {
    app: ChecksGetResponseApp;
    check_suite: ChecksGetResponseCheckSuite;
    completed_at: string;
    conclusion: string;
    details_url: string;
    external_id: string;
    head_sha: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    output: ChecksGetResponseOutput;
    pull_requests: Array<ChecksGetResponsePullRequestsItem>;
    started_at: string;
    status: string;
    url: string;
  };
  type ChecksCreateSuiteResponseRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ChecksCreateSuiteResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ChecksCreateSuiteResponseRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ChecksCreateSuiteResponseRepositoryOwner;
    permissions: ChecksCreateSuiteResponseRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ChecksCreateSuiteResponseAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ChecksCreateSuiteResponseAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ChecksCreateSuiteResponseApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksCreateSuiteResponseAppOwner;
    permissions: ChecksCreateSuiteResponseAppPermissions;
    slug: string;
    updated_at: string;
  };
  type ChecksCreateSuiteResponse = {
    after: string;
    app: ChecksCreateSuiteResponseApp;
    before: string;
    conclusion: string;
    head_branch: string;
    head_sha: string;
    id: number;
    node_id: string;
    pull_requests: Array<any>;
    repository: ChecksCreateSuiteResponseRepository;
    status: string;
    url: string;
  };
  type ChecksCreateResponsePullRequestsItemHeadRepo = {
    id: number;
    name: string;
    url: string;
  };
  type ChecksCreateResponsePullRequestsItemHead = {
    ref: string;
    repo: ChecksCreateResponsePullRequestsItemHeadRepo;
    sha: string;
  };
  type ChecksCreateResponsePullRequestsItemBaseRepo = {
    id: number;
    name: string;
    url: string;
  };
  type ChecksCreateResponsePullRequestsItemBase = {
    ref: string;
    repo: ChecksCreateResponsePullRequestsItemBaseRepo;
    sha: string;
  };
  type ChecksCreateResponsePullRequestsItem = {
    base: ChecksCreateResponsePullRequestsItemBase;
    head: ChecksCreateResponsePullRequestsItemHead;
    id: number;
    number: number;
    url: string;
  };
  type ChecksCreateResponseOutput = {
    summary: string;
    text: string;
    title: string;
    annotations_count?: number;
    annotations_url?: string;
  };
  type ChecksCreateResponseCheckSuite = { id: number };
  type ChecksCreateResponseAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type ChecksCreateResponseAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type ChecksCreateResponseApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksCreateResponseAppOwner;
    permissions: ChecksCreateResponseAppPermissions;
    slug: string;
    updated_at: string;
  };
  type ChecksCreateResponse = {
    app: ChecksCreateResponseApp;
    check_suite: ChecksCreateResponseCheckSuite;
    completed_at: null | string;
    conclusion: null | string;
    details_url: string;
    external_id: string;
    head_sha: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    output: ChecksCreateResponseOutput;
    pull_requests: Array<ChecksCreateResponsePullRequestsItem>;
    started_at: string;
    status: string;
    url: string;
  };
  type AppsResetTokenResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type AppsResetTokenResponseApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type AppsResetTokenResponse = {
    app: AppsResetTokenResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
    user: AppsResetTokenResponseUser;
  };
  type AppsResetAuthorizationResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type AppsResetAuthorizationResponseApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type AppsResetAuthorizationResponse = {
    app: AppsResetAuthorizationResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
    user: AppsResetAuthorizationResponseUser;
  };
  type AppsListReposResponseRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type AppsListReposResponseRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: AppsListReposResponseRepositoriesItemOwner;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type AppsListReposResponse = {
    repositories: Array<AppsListReposResponseRepositoriesItem>;
    total_count: number;
  };
  type AppsListPlansStubbedResponseItem = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
  };
  type AppsListPlansResponseItem = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
  };
  type AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItemPlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
  };
  type AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItemAccount = {
    email: null;
    id: number;
    login: string;
    organization_billing_email: string;
    type: string;
    url: string;
  };
  type AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItem = {
    account: AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItemAccount;
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date: string;
    on_free_trial: boolean;
    plan: AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItemPlan;
    unit_count: null;
    updated_at: string;
  };
  type AppsListMarketplacePurchasesForAuthenticatedUserResponseItemPlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
  };
  type AppsListMarketplacePurchasesForAuthenticatedUserResponseItemAccount = {
    email: null;
    id: number;
    login: string;
    organization_billing_email: string;
    type: string;
    url: string;
  };
  type AppsListMarketplacePurchasesForAuthenticatedUserResponseItem = {
    account: AppsListMarketplacePurchasesForAuthenticatedUserResponseItemAccount;
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date: string;
    on_free_trial: boolean;
    plan: AppsListMarketplacePurchasesForAuthenticatedUserResponseItemPlan;
    unit_count: null;
    updated_at: string;
  };
  type AppsListInstallationsForAuthenticatedUserResponseInstallationsItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type AppsListInstallationsForAuthenticatedUserResponseInstallationsItemAccount = {
    avatar_url: string;
    description?: string;
    events_url: string;
    hooks_url?: string;
    id: number;
    issues_url?: string;
    login: string;
    members_url?: string;
    node_id: string;
    public_members_url?: string;
    repos_url: string;
    url: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    organizations_url?: string;
    received_events_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: string;
  };
  type AppsListInstallationsForAuthenticatedUserResponseInstallationsItem = {
    access_tokens_url: string;
    account: AppsListInstallationsForAuthenticatedUserResponseInstallationsItemAccount;
    app_id: number;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsListInstallationsForAuthenticatedUserResponseInstallationsItemPermissions;
    repositories_url: string;
    single_file_name: string;
    target_id: number;
    target_type: string;
  };
  type AppsListInstallationsForAuthenticatedUserResponse = {
    installations: Array<
      AppsListInstallationsForAuthenticatedUserResponseInstallationsItem
    >;
    total_count: number;
  };
  type AppsListInstallationsResponseItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type AppsListInstallationsResponseItemAccount = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type AppsListInstallationsResponseItem = {
    access_tokens_url: string;
    account: AppsListInstallationsResponseItemAccount;
    app_id: number;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsListInstallationsResponseItemPermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: string;
    target_id: number;
    target_type: string;
  };
  type AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItemOwner;
    permissions: AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type AppsListInstallationReposForAuthenticatedUserResponse = {
    repositories: Array<
      AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItem
    >;
    total_count: number;
  };
  type AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePurchasePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
  };
  type AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePurchase = {
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date: string;
    on_free_trial: boolean;
    plan: AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePurchasePlan;
    unit_count: null;
    updated_at: string;
  };
  type AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePendingChangePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
  };
  type AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePendingChange = {
    effective_date: string;
    id: number;
    plan: AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePendingChangePlan;
    unit_count: null;
  };
  type AppsListAccountsUserOrOrgOnPlanStubbedResponseItem = {
    email: null;
    id: number;
    login: string;
    marketplace_pending_change: AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePendingChange;
    marketplace_purchase: AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePurchase;
    organization_billing_email: string;
    type: string;
    url: string;
  };
  type AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePurchasePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
  };
  type AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePurchase = {
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date: string;
    on_free_trial: boolean;
    plan: AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePurchasePlan;
    unit_count: null;
    updated_at: string;
  };
  type AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePendingChangePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
  };
  type AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePendingChange = {
    effective_date: string;
    id: number;
    plan: AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePendingChangePlan;
    unit_count: null;
  };
  type AppsListAccountsUserOrOrgOnPlanResponseItem = {
    email: null;
    id: number;
    login: string;
    marketplace_pending_change: AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePendingChange;
    marketplace_purchase: AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePurchase;
    organization_billing_email: string;
    type: string;
    url: string;
  };
  type AppsGetUserInstallationResponsePermissions = {
    checks: string;
    contents: string;
    metadata: string;
  };
  type AppsGetUserInstallationResponseAccount = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type AppsGetUserInstallationResponse = {
    access_tokens_url: string;
    account: AppsGetUserInstallationResponseAccount;
    app_id: number;
    created_at: string;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsGetUserInstallationResponsePermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: null;
    target_id: number;
    target_type: string;
    updated_at: string;
  };
  type AppsGetRepoInstallationResponsePermissions = {
    checks: string;
    contents: string;
    metadata: string;
  };
  type AppsGetRepoInstallationResponseAccount = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type AppsGetRepoInstallationResponse = {
    access_tokens_url: string;
    account: AppsGetRepoInstallationResponseAccount;
    app_id: number;
    created_at: string;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsGetRepoInstallationResponsePermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: null;
    target_id: number;
    target_type: string;
    updated_at: string;
  };
  type AppsGetOrgInstallationResponsePermissions = {
    checks: string;
    contents: string;
    metadata: string;
  };
  type AppsGetOrgInstallationResponseAccount = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type AppsGetOrgInstallationResponse = {
    access_tokens_url: string;
    account: AppsGetOrgInstallationResponseAccount;
    app_id: number;
    created_at: string;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsGetOrgInstallationResponsePermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: null;
    target_id: number;
    target_type: string;
    updated_at: string;
  };
  type AppsGetInstallationResponsePermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type AppsGetInstallationResponseAccount = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type AppsGetInstallationResponse = {
    access_tokens_url: string;
    account: AppsGetInstallationResponseAccount;
    app_id: number;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsGetInstallationResponsePermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: string;
    target_id: number;
    target_type: string;
  };
  type AppsGetBySlugResponsePermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type AppsGetBySlugResponseOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type AppsGetBySlugResponse = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: AppsGetBySlugResponseOwner;
    permissions: AppsGetBySlugResponsePermissions;
    slug: string;
    updated_at: string;
  };
  type AppsGetAuthenticatedResponsePermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
  };
  type AppsGetAuthenticatedResponseOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
  };
  type AppsGetAuthenticatedResponse = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    installations_count: number;
    name: string;
    node_id: string;
    owner: AppsGetAuthenticatedResponseOwner;
    permissions: AppsGetAuthenticatedResponsePermissions;
    slug: string;
    updated_at: string;
  };
  type AppsFindUserInstallationResponsePermissions = {
    checks: string;
    contents: string;
    metadata: string;
  };
  type AppsFindUserInstallationResponseAccount = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type AppsFindUserInstallationResponse = {
    access_tokens_url: string;
    account: AppsFindUserInstallationResponseAccount;
    app_id: number;
    created_at: string;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsFindUserInstallationResponsePermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: null;
    target_id: number;
    target_type: string;
    updated_at: string;
  };
  type AppsFindRepoInstallationResponsePermissions = {
    checks: string;
    contents: string;
    metadata: string;
  };
  type AppsFindRepoInstallationResponseAccount = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type AppsFindRepoInstallationResponse = {
    access_tokens_url: string;
    account: AppsFindRepoInstallationResponseAccount;
    app_id: number;
    created_at: string;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsFindRepoInstallationResponsePermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: null;
    target_id: number;
    target_type: string;
    updated_at: string;
  };
  type AppsFindOrgInstallationResponsePermissions = {
    checks: string;
    contents: string;
    metadata: string;
  };
  type AppsFindOrgInstallationResponseAccount = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type AppsFindOrgInstallationResponse = {
    access_tokens_url: string;
    account: AppsFindOrgInstallationResponseAccount;
    app_id: number;
    created_at: string;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsFindOrgInstallationResponsePermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: null;
    target_id: number;
    target_type: string;
    updated_at: string;
  };
  type AppsCreateInstallationTokenResponseRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type AppsCreateInstallationTokenResponseRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type AppsCreateInstallationTokenResponseRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: AppsCreateInstallationTokenResponseRepositoriesItemOwner;
    permissions: AppsCreateInstallationTokenResponseRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type AppsCreateInstallationTokenResponsePermissions = {
    contents: string;
    issues: string;
  };
  type AppsCreateInstallationTokenResponse = {
    expires_at: string;
    permissions: AppsCreateInstallationTokenResponsePermissions;
    repositories: Array<AppsCreateInstallationTokenResponseRepositoriesItem>;
    token: string;
  };
  type AppsCreateFromManifestResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type AppsCreateFromManifestResponse = {
    client_id: string;
    client_secret: string;
    created_at: string;
    description: null;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: AppsCreateFromManifestResponseOwner;
    pem: string;
    updated_at: string;
    webhook_secret: string;
  };
  type AppsCreateContentAttachmentResponse = {
    body: string;
    id: number;
    title: string;
  };
  type AppsCheckTokenResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type AppsCheckTokenResponseApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type AppsCheckTokenResponse = {
    app: AppsCheckTokenResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
    user: AppsCheckTokenResponseUser;
  };
  type AppsCheckAuthorizationResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type AppsCheckAuthorizationResponseApp = {
    client_id: string;
    name: string;
    url: string;
  };
  type AppsCheckAuthorizationResponse = {
    app: AppsCheckAuthorizationResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
    user: AppsCheckAuthorizationResponseUser;
  };
  type AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePurchasePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
  };
  type AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePurchase = {
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date: string;
    on_free_trial: boolean;
    plan: AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePurchasePlan;
    unit_count: null;
    updated_at: string;
  };
  type AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePendingChangePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
  };
  type AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePendingChange = {
    effective_date: string;
    id: number;
    plan: AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePendingChangePlan;
    unit_count: null;
  };
  type AppsCheckAccountIsAssociatedWithAnyStubbedResponse = {
    email: null;
    id: number;
    login: string;
    marketplace_pending_change: AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePendingChange;
    marketplace_purchase: AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePurchase;
    organization_billing_email: string;
    type: string;
    url: string;
  };
  type AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePurchasePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
  };
  type AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePurchase = {
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date: string;
    on_free_trial: boolean;
    plan: AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePurchasePlan;
    unit_count: null;
    updated_at: string;
  };
  type AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePendingChangePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
  };
  type AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePendingChange = {
    effective_date: string;
    id: number;
    plan: AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePendingChangePlan;
    unit_count: null;
  };
  type AppsCheckAccountIsAssociatedWithAnyResponse = {
    email: null;
    id: number;
    login: string;
    marketplace_pending_change: AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePendingChange;
    marketplace_purchase: AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePurchase;
    organization_billing_email: string;
    type: string;
    url: string;
  };
  type ActivitySetThreadSubscriptionResponse = {
    created_at: string;
    ignored: boolean;
    reason: null;
    subscribed: boolean;
    thread_url: string;
    url: string;
  };
  type ActivitySetRepoSubscriptionResponse = {
    created_at: string;
    ignored: boolean;
    reason: null;
    repository_url: string;
    subscribed: boolean;
    url: string;
  };
  type ActivityListWatchersForRepoResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActivityListWatchedReposForAuthenticatedUserResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ActivityListWatchedReposForAuthenticatedUserResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActivityListWatchedReposForAuthenticatedUserResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
  };
  type ActivityListWatchedReposForAuthenticatedUserResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: ActivityListWatchedReposForAuthenticatedUserResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ActivityListWatchedReposForAuthenticatedUserResponseItemOwner;
    permissions: ActivityListWatchedReposForAuthenticatedUserResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ActivityListStargazersForRepoResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActivityListReposWatchedByUserResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ActivityListReposWatchedByUserResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActivityListReposWatchedByUserResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
  };
  type ActivityListReposWatchedByUserResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: ActivityListReposWatchedByUserResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ActivityListReposWatchedByUserResponseItemOwner;
    permissions: ActivityListReposWatchedByUserResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ActivityListReposStarredByUserResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ActivityListReposStarredByUserResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActivityListReposStarredByUserResponseItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ActivityListReposStarredByUserResponseItemOwner;
    permissions: ActivityListReposStarredByUserResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ActivityListReposStarredByAuthenticatedUserResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
  };
  type ActivityListReposStarredByAuthenticatedUserResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActivityListReposStarredByAuthenticatedUserResponseItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ActivityListReposStarredByAuthenticatedUserResponseItemOwner;
    permissions: ActivityListReposStarredByAuthenticatedUserResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
  };
  type ActivityListNotificationsForRepoResponseItemSubject = {
    latest_comment_url: string;
    title: string;
    type: string;
    url: string;
  };
  type ActivityListNotificationsForRepoResponseItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActivityListNotificationsForRepoResponseItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActivityListNotificationsForRepoResponseItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ActivityListNotificationsForRepoResponseItem = {
    id: string;
    last_read_at: string;
    reason: string;
    repository: ActivityListNotificationsForRepoResponseItemRepository;
    subject: ActivityListNotificationsForRepoResponseItemSubject;
    unread: boolean;
    updated_at: string;
    url: string;
  };
  type ActivityListNotificationsResponseItemSubject = {
    latest_comment_url: string;
    title: string;
    type: string;
    url: string;
  };
  type ActivityListNotificationsResponseItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActivityListNotificationsResponseItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActivityListNotificationsResponseItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ActivityListNotificationsResponseItem = {
    id: string;
    last_read_at: string;
    reason: string;
    repository: ActivityListNotificationsResponseItemRepository;
    subject: ActivityListNotificationsResponseItemSubject;
    unread: boolean;
    updated_at: string;
    url: string;
  };
  type ActivityListFeedsResponseLinksUser = { href: string; type: string };
  type ActivityListFeedsResponseLinksTimeline = { href: string; type: string };
  type ActivityListFeedsResponseLinksSecurityAdvisories = {
    href: string;
    type: string;
  };
  type ActivityListFeedsResponseLinksCurrentUserPublic = {
    href: string;
    type: string;
  };
  type ActivityListFeedsResponseLinksCurrentUserOrganizationsItem = {
    href: string;
    type: string;
  };
  type ActivityListFeedsResponseLinksCurrentUserOrganization = {
    href: string;
    type: string;
  };
  type ActivityListFeedsResponseLinksCurrentUserActor = {
    href: string;
    type: string;
  };
  type ActivityListFeedsResponseLinksCurrentUser = {
    href: string;
    type: string;
  };
  type ActivityListFeedsResponseLinks = {
    current_user: ActivityListFeedsResponseLinksCurrentUser;
    current_user_actor: ActivityListFeedsResponseLinksCurrentUserActor;
    current_user_organization: ActivityListFeedsResponseLinksCurrentUserOrganization;
    current_user_organizations: Array<
      ActivityListFeedsResponseLinksCurrentUserOrganizationsItem
    >;
    current_user_public: ActivityListFeedsResponseLinksCurrentUserPublic;
    security_advisories: ActivityListFeedsResponseLinksSecurityAdvisories;
    timeline: ActivityListFeedsResponseLinksTimeline;
    user: ActivityListFeedsResponseLinksUser;
  };
  type ActivityListFeedsResponse = {
    _links: ActivityListFeedsResponseLinks;
    current_user_actor_url: string;
    current_user_organization_url: string;
    current_user_organization_urls: Array<string>;
    current_user_public_url: string;
    current_user_url: string;
    security_advisories_url: string;
    timeline_url: string;
    user_url: string;
  };
  type ActivityGetThreadSubscriptionResponse = {
    created_at: string;
    ignored: boolean;
    reason: null;
    subscribed: boolean;
    thread_url: string;
    url: string;
  };
  type ActivityGetThreadResponseSubject = {
    latest_comment_url: string;
    title: string;
    type: string;
    url: string;
  };
  type ActivityGetThreadResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActivityGetThreadResponseRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActivityGetThreadResponseRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ActivityGetThreadResponse = {
    id: string;
    last_read_at: string;
    reason: string;
    repository: ActivityGetThreadResponseRepository;
    subject: ActivityGetThreadResponseSubject;
    unread: boolean;
    updated_at: string;
    url: string;
  };
  type ActivityGetRepoSubscriptionResponse = {
    created_at: string;
    ignored: boolean;
    reason: null;
    repository_url: string;
    subscribed: boolean;
    url: string;
  };
  type ActionsListWorkflowRunsResponseWorkflowRunsItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActionsListWorkflowRunsResponseWorkflowRunsItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActionsListWorkflowRunsResponseWorkflowRunsItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ActionsListWorkflowRunsResponseWorkflowRunsItemHeadRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActionsListWorkflowRunsResponseWorkflowRunsItemHeadRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: null;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    hooks_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActionsListWorkflowRunsResponseWorkflowRunsItemHeadRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ActionsListWorkflowRunsResponseWorkflowRunsItemHeadCommitCommitter = {
    email: string;
    name: string;
  };
  type ActionsListWorkflowRunsResponseWorkflowRunsItemHeadCommitAuthor = {
    email: string;
    name: string;
  };
  type ActionsListWorkflowRunsResponseWorkflowRunsItemHeadCommit = {
    author: ActionsListWorkflowRunsResponseWorkflowRunsItemHeadCommitAuthor;
    committer: ActionsListWorkflowRunsResponseWorkflowRunsItemHeadCommitCommitter;
    id: string;
    message: string;
    timestamp: string;
    tree_id: string;
  };
  type ActionsListWorkflowRunsResponseWorkflowRunsItem = {
    artifacts_url: string;
    cancel_url: string;
    check_suite_id: number;
    conclusion: null;
    created_at: string;
    event: string;
    head_branch: string;
    head_commit: ActionsListWorkflowRunsResponseWorkflowRunsItemHeadCommit;
    head_repository: ActionsListWorkflowRunsResponseWorkflowRunsItemHeadRepository;
    head_sha: string;
    html_url: string;
    id: number;
    jobs_url: string;
    logs_url: string;
    node_id: string;
    pull_requests: Array<any>;
    repository: ActionsListWorkflowRunsResponseWorkflowRunsItemRepository;
    rerun_url: string;
    run_number: number;
    status: string;
    updated_at: string;
    url: string;
    workflow_url: string;
  };
  type ActionsListWorkflowRunsResponse = {
    total_count: number;
    workflow_runs: Array<ActionsListWorkflowRunsResponseWorkflowRunsItem>;
  };
  type ActionsListWorkflowRunArtifactsResponseArtifactsItem = {
    archive_download_url: string;
    created_at: string;
    expired: string;
    expires_at: string;
    id: number;
    name: string;
    node_id: string;
    size_in_bytes: number;
  };
  type ActionsListWorkflowRunArtifactsResponse = {
    artifacts: Array<ActionsListWorkflowRunArtifactsResponseArtifactsItem>;
    total_count: number;
  };
  type ActionsListSelfHostedRunnersForRepoResponseItemItem = {
    id: number;
    name: string;
    os: string;
    status: string;
  };
  type ActionsListSecretsForRepoResponseSecretsItem = {
    created_at: string;
    name: string;
    updated_at: string;
  };
  type ActionsListSecretsForRepoResponse = {
    secrets: Array<ActionsListSecretsForRepoResponseSecretsItem>;
    total_count: number;
  };
  type ActionsListRepoWorkflowsResponseWorkflowsItem = {
    badge_url: string;
    created_at: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    path: string;
    state: string;
    updated_at: string;
    url: string;
  };
  type ActionsListRepoWorkflowsResponse = {
    total_count: number;
    workflows: Array<ActionsListRepoWorkflowsResponseWorkflowsItem>;
  };
  type ActionsListRepoWorkflowRunsResponseWorkflowRunsItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActionsListRepoWorkflowRunsResponseWorkflowRunsItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActionsListRepoWorkflowRunsResponseWorkflowRunsItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: null;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    hooks_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadCommitCommitter = {
    email: string;
    name: string;
  };
  type ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadCommitAuthor = {
    email: string;
    name: string;
  };
  type ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadCommit = {
    author: ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadCommitAuthor;
    committer: ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadCommitCommitter;
    id: string;
    message: string;
    timestamp: string;
    tree_id: string;
  };
  type ActionsListRepoWorkflowRunsResponseWorkflowRunsItem = {
    artifacts_url: string;
    cancel_url: string;
    check_suite_id: number;
    conclusion: null;
    created_at: string;
    event: string;
    head_branch: string;
    head_commit: ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadCommit;
    head_repository: ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadRepository;
    head_sha: string;
    html_url: string;
    id: number;
    jobs_url: string;
    logs_url: string;
    node_id: string;
    pull_requests: Array<any>;
    repository: ActionsListRepoWorkflowRunsResponseWorkflowRunsItemRepository;
    rerun_url: string;
    run_number: number;
    status: string;
    updated_at: string;
    url: string;
    workflow_url: string;
  };
  type ActionsListRepoWorkflowRunsResponse = {
    total_count: number;
    workflow_runs: Array<ActionsListRepoWorkflowRunsResponseWorkflowRunsItem>;
  };
  type ActionsListJobsForWorkflowRunResponseJobsItemStepsItem = {
    completed_at: string;
    conclusion: string;
    name: string;
    number: number;
    started_at: string;
    status: string;
  };
  type ActionsListJobsForWorkflowRunResponseJobsItem = {
    check_run_url: string;
    completed_at: string;
    conclusion: string;
    head_sha: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    run_id: number;
    run_url: string;
    started_at: string;
    status: string;
    steps: Array<ActionsListJobsForWorkflowRunResponseJobsItemStepsItem>;
    url: string;
  };
  type ActionsListJobsForWorkflowRunResponse = {
    jobs: Array<ActionsListJobsForWorkflowRunResponseJobsItem>;
    total_count: number;
  };
  type ActionsListDownloadsForSelfHostedRunnerApplicationResponseItem = {
    architecture: string;
    download_url: string;
    filename: string;
    os: string;
  };
  type ActionsGetWorkflowRunResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActionsGetWorkflowRunResponseRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActionsGetWorkflowRunResponseRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ActionsGetWorkflowRunResponseHeadRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
  };
  type ActionsGetWorkflowRunResponseHeadRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: null;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    hooks_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActionsGetWorkflowRunResponseHeadRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
  };
  type ActionsGetWorkflowRunResponseHeadCommitCommitter = {
    email: string;
    name: string;
  };
  type ActionsGetWorkflowRunResponseHeadCommitAuthor = {
    email: string;
    name: string;
  };
  type ActionsGetWorkflowRunResponseHeadCommit = {
    author: ActionsGetWorkflowRunResponseHeadCommitAuthor;
    committer: ActionsGetWorkflowRunResponseHeadCommitCommitter;
    id: string;
    message: string;
    timestamp: string;
    tree_id: string;
  };
  type ActionsGetWorkflowRunResponse = {
    artifacts_url: string;
    cancel_url: string;
    check_suite_id: number;
    conclusion: null;
    created_at: string;
    event: string;
    head_branch: string;
    head_commit: ActionsGetWorkflowRunResponseHeadCommit;
    head_repository: ActionsGetWorkflowRunResponseHeadRepository;
    head_sha: string;
    html_url: string;
    id: number;
    jobs_url: string;
    logs_url: string;
    node_id: string;
    pull_requests: Array<any>;
    repository: ActionsGetWorkflowRunResponseRepository;
    rerun_url: string;
    run_number: number;
    status: string;
    updated_at: string;
    url: string;
    workflow_url: string;
  };
  type ActionsGetWorkflowJobResponseStepsItem = {
    completed_at: string;
    conclusion: string;
    name: string;
    number: number;
    started_at: string;
    status: string;
  };
  type ActionsGetWorkflowJobResponse = {
    check_run_url: string;
    completed_at: string;
    conclusion: string;
    head_sha: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    run_id: number;
    run_url: string;
    started_at: string;
    status: string;
    steps: Array<ActionsGetWorkflowJobResponseStepsItem>;
    url: string;
  };
  type ActionsGetWorkflowResponse = {
    badge_url: string;
    created_at: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    path: string;
    state: string;
    updated_at: string;
    url: string;
  };
  type ActionsGetSelfHostedRunnerResponse = {
    id: number;
    name: string;
    os: string;
    status: string;
  };
  type ActionsGetSecretResponse = {
    created_at: string;
    name: string;
    updated_at: string;
  };
  type ActionsGetPublicKeyResponse = { key: string; key_id: string };
  type ActionsGetArtifactResponse = {
    archive_download_url: string;
    created_at: string;
    expired: string;
    expires_at: string;
    id: number;
    name: string;
    node_id: string;
    size_in_bytes: number;
  };
  type ActionsCreateRemoveTokenResponse = { expires_at: string; token: string };
  type ActionsCreateRegistrationTokenResponse = {
    expires_at: string;
    token: string;
  };
  type ActionsListDownloadsForSelfHostedRunnerApplicationResponse = Array<
    ActionsListDownloadsForSelfHostedRunnerApplicationResponseItem
  >;
  type ActionsListSelfHostedRunnersForRepoResponse = Array<
    Array<ActionsListSelfHostedRunnersForRepoResponseItemItem>
  >;
  type ActivityListNotificationsResponse = Array<
    ActivityListNotificationsResponseItem
  >;
  type ActivityListNotificationsForRepoResponse = Array<
    ActivityListNotificationsForRepoResponseItem
  >;
  type ActivityListReposStarredByAuthenticatedUserResponse = Array<
    ActivityListReposStarredByAuthenticatedUserResponseItem
  >;
  type ActivityListReposStarredByUserResponse = Array<
    ActivityListReposStarredByUserResponseItem
  >;
  type ActivityListReposWatchedByUserResponse = Array<
    ActivityListReposWatchedByUserResponseItem
  >;
  type ActivityListStargazersForRepoResponse = Array<
    ActivityListStargazersForRepoResponseItem
  >;
  type ActivityListWatchedReposForAuthenticatedUserResponse = Array<
    ActivityListWatchedReposForAuthenticatedUserResponseItem
  >;
  type ActivityListWatchersForRepoResponse = Array<
    ActivityListWatchersForRepoResponseItem
  >;
  type AppsListAccountsUserOrOrgOnPlanResponse = Array<
    AppsListAccountsUserOrOrgOnPlanResponseItem
  >;
  type AppsListAccountsUserOrOrgOnPlanStubbedResponse = Array<
    AppsListAccountsUserOrOrgOnPlanStubbedResponseItem
  >;
  type AppsListInstallationsResponse = Array<AppsListInstallationsResponseItem>;
  type AppsListMarketplacePurchasesForAuthenticatedUserResponse = Array<
    AppsListMarketplacePurchasesForAuthenticatedUserResponseItem
  >;
  type AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponse = Array<
    AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItem
  >;
  type AppsListPlansResponse = Array<AppsListPlansResponseItem>;
  type AppsListPlansStubbedResponse = Array<AppsListPlansStubbedResponseItem>;
  type ChecksListAnnotationsResponse = Array<ChecksListAnnotationsResponseItem>;
  type CodesOfConductListConductCodesResponse = Array<
    CodesOfConductListConductCodesResponseItem
  >;
  type GistsListResponse = Array<GistsListResponseItem>;
  type GistsListCommentsResponse = Array<GistsListCommentsResponseItem>;
  type GistsListCommitsResponse = Array<GistsListCommitsResponseItem>;
  type GistsListForksResponse = Array<GistsListForksResponseItem>;
  type GistsListPublicResponse = Array<GistsListPublicResponseItem>;
  type GistsListPublicForUserResponse = Array<
    GistsListPublicForUserResponseItem
  >;
  type GistsListStarredResponse = Array<GistsListStarredResponseItem>;
  type GitListMatchingRefsResponse = Array<GitListMatchingRefsResponseItem>;
  type GitignoreListTemplatesResponse = Array<string>;
  type IssuesAddLabelsResponse = Array<IssuesAddLabelsResponseItem>;
  type IssuesListResponse = Array<IssuesListResponseItem>;
  type IssuesListAssigneesResponse = Array<IssuesListAssigneesResponseItem>;
  type IssuesListCommentsResponse = Array<IssuesListCommentsResponseItem>;
  type IssuesListCommentsForRepoResponse = Array<
    IssuesListCommentsForRepoResponseItem
  >;
  type IssuesListEventsResponse = Array<IssuesListEventsResponseItem>;
  type IssuesListEventsForRepoResponse = Array<
    IssuesListEventsForRepoResponseItem
  >;
  type IssuesListEventsForTimelineResponse = Array<
    IssuesListEventsForTimelineResponseItem
  >;
  type IssuesListForAuthenticatedUserResponse = Array<
    IssuesListForAuthenticatedUserResponseItem
  >;
  type IssuesListForOrgResponse = Array<IssuesListForOrgResponseItem>;
  type IssuesListForRepoResponse = Array<IssuesListForRepoResponseItem>;
  type IssuesListLabelsForMilestoneResponse = Array<
    IssuesListLabelsForMilestoneResponseItem
  >;
  type IssuesListLabelsForRepoResponse = Array<
    IssuesListLabelsForRepoResponseItem
  >;
  type IssuesListLabelsOnIssueResponse = Array<
    IssuesListLabelsOnIssueResponseItem
  >;
  type IssuesListMilestonesForRepoResponse = Array<
    IssuesListMilestonesForRepoResponseItem
  >;
  type IssuesRemoveLabelResponse = Array<IssuesRemoveLabelResponseItem>;
  type IssuesReplaceLabelsResponse = Array<IssuesReplaceLabelsResponseItem>;
  type LicensesListResponse = Array<LicensesListResponseItem>;
  type LicensesListCommonlyUsedResponse = Array<
    LicensesListCommonlyUsedResponseItem
  >;
  type MigrationsGetCommitAuthorsResponse = Array<
    MigrationsGetCommitAuthorsResponseItem
  >;
  type MigrationsGetLargeFilesResponse = Array<
    MigrationsGetLargeFilesResponseItem
  >;
  type MigrationsListForAuthenticatedUserResponse = Array<
    MigrationsListForAuthenticatedUserResponseItem
  >;
  type MigrationsListForOrgResponse = Array<MigrationsListForOrgResponseItem>;
  type MigrationsListReposForOrgResponse = Array<
    MigrationsListReposForOrgResponseItem
  >;
  type MigrationsListReposForUserResponse = Array<
    MigrationsListReposForUserResponseItem
  >;
  type OauthAuthorizationsListAuthorizationsResponse = Array<
    OauthAuthorizationsListAuthorizationsResponseItem
  >;
  type OauthAuthorizationsListGrantsResponse = Array<
    OauthAuthorizationsListGrantsResponseItem
  >;
  type OrgsListResponse = Array<OrgsListResponseItem>;
  type OrgsListBlockedUsersResponse = Array<OrgsListBlockedUsersResponseItem>;
  type OrgsListForAuthenticatedUserResponse = Array<
    OrgsListForAuthenticatedUserResponseItem
  >;
  type OrgsListForUserResponse = Array<OrgsListForUserResponseItem>;
  type OrgsListHooksResponse = Array<OrgsListHooksResponseItem>;
  type OrgsListInvitationTeamsResponse = Array<
    OrgsListInvitationTeamsResponseItem
  >;
  type OrgsListMembersResponse = Array<OrgsListMembersResponseItem>;
  type OrgsListMembershipsResponse = Array<OrgsListMembershipsResponseItem>;
  type OrgsListOutsideCollaboratorsResponse = Array<
    OrgsListOutsideCollaboratorsResponseItem
  >;
  type OrgsListPendingInvitationsResponse = Array<
    OrgsListPendingInvitationsResponseItem
  >;
  type OrgsListPublicMembersResponse = Array<OrgsListPublicMembersResponseItem>;
  type ProjectsListCardsResponse = Array<ProjectsListCardsResponseItem>;
  type ProjectsListCollaboratorsResponse = Array<
    ProjectsListCollaboratorsResponseItem
  >;
  type ProjectsListColumnsResponse = Array<ProjectsListColumnsResponseItem>;
  type ProjectsListForOrgResponse = Array<ProjectsListForOrgResponseItem>;
  type ProjectsListForRepoResponse = Array<ProjectsListForRepoResponseItem>;
  type ProjectsListForUserResponse = Array<ProjectsListForUserResponseItem>;
  type PullsGetCommentsForReviewResponse = Array<
    PullsGetCommentsForReviewResponseItem
  >;
  type PullsListResponse = Array<PullsListResponseItem>;
  type PullsListCommentsResponse = Array<PullsListCommentsResponseItem>;
  type PullsListCommentsForRepoResponse = Array<
    PullsListCommentsForRepoResponseItem
  >;
  type PullsListCommitsResponse = Array<PullsListCommitsResponseItem>;
  type PullsListFilesResponse = Array<PullsListFilesResponseItem>;
  type PullsListReviewsResponse = Array<PullsListReviewsResponseItem>;
  type ReactionsListForCommitCommentResponse = Array<
    ReactionsListForCommitCommentResponseItem
  >;
  type ReactionsListForIssueResponse = Array<ReactionsListForIssueResponseItem>;
  type ReactionsListForIssueCommentResponse = Array<
    ReactionsListForIssueCommentResponseItem
  >;
  type ReactionsListForPullRequestReviewCommentResponse = Array<
    ReactionsListForPullRequestReviewCommentResponseItem
  >;
  type ReactionsListForTeamDiscussionResponse = Array<
    ReactionsListForTeamDiscussionResponseItem
  >;
  type ReactionsListForTeamDiscussionCommentResponse = Array<
    ReactionsListForTeamDiscussionCommentResponseItem
  >;
  type ReactionsListForTeamDiscussionCommentInOrgResponse = Array<
    ReactionsListForTeamDiscussionCommentInOrgResponseItem
  >;
  type ReactionsListForTeamDiscussionCommentLegacyResponse = Array<
    ReactionsListForTeamDiscussionCommentLegacyResponseItem
  >;
  type ReactionsListForTeamDiscussionInOrgResponse = Array<
    ReactionsListForTeamDiscussionInOrgResponseItem
  >;
  type ReactionsListForTeamDiscussionLegacyResponse = Array<
    ReactionsListForTeamDiscussionLegacyResponseItem
  >;
  type ReposAddProtectedBranchAppRestrictionsResponse = Array<
    ReposAddProtectedBranchAppRestrictionsResponseItem
  >;
  type ReposAddProtectedBranchRequiredStatusChecksContextsResponse = Array<
    string
  >;
  type ReposAddProtectedBranchTeamRestrictionsResponse = Array<
    ReposAddProtectedBranchTeamRestrictionsResponseItem
  >;
  type ReposAddProtectedBranchUserRestrictionsResponse = Array<
    ReposAddProtectedBranchUserRestrictionsResponseItem
  >;
  type ReposGetAppsWithAccessToProtectedBranchResponse = Array<
    ReposGetAppsWithAccessToProtectedBranchResponseItem
  >;
  type ReposGetCodeFrequencyStatsResponse = Array<Array<number>>;
  type ReposGetCommitActivityStatsResponse = Array<
    ReposGetCommitActivityStatsResponseItem
  >;
  type ReposGetContributorsStatsResponse = Array<
    ReposGetContributorsStatsResponseItem
  >;
  type ReposGetPunchCardStatsResponse = Array<Array<number>>;
  type ReposGetTeamsWithAccessToProtectedBranchResponse = Array<
    ReposGetTeamsWithAccessToProtectedBranchResponseItem
  >;
  type ReposGetTopPathsResponse = Array<ReposGetTopPathsResponseItem>;
  type ReposGetTopReferrersResponse = Array<ReposGetTopReferrersResponseItem>;
  type ReposGetUsersWithAccessToProtectedBranchResponse = Array<
    ReposGetUsersWithAccessToProtectedBranchResponseItem
  >;
  type ReposListAppsWithAccessToProtectedBranchResponse = Array<
    ReposListAppsWithAccessToProtectedBranchResponseItem
  >;
  type ReposListAssetsForReleaseResponse = Array<
    ReposListAssetsForReleaseResponseItem
  >;
  type ReposListBranchesResponse = Array<ReposListBranchesResponseItem>;
  type ReposListBranchesForHeadCommitResponse = Array<
    ReposListBranchesForHeadCommitResponseItem
  >;
  type ReposListCollaboratorsResponse = Array<
    ReposListCollaboratorsResponseItem
  >;
  type ReposListCommentsForCommitResponse = Array<
    ReposListCommentsForCommitResponseItem
  >;
  type ReposListCommitCommentsResponse = Array<
    ReposListCommitCommentsResponseItem
  >;
  type ReposListCommitsResponse = Array<ReposListCommitsResponseItem>;
  type ReposListContributorsResponse = Array<ReposListContributorsResponseItem>;
  type ReposListDeployKeysResponse = Array<ReposListDeployKeysResponseItem>;
  type ReposListDeploymentStatusesResponse = Array<
    ReposListDeploymentStatusesResponseItem
  >;
  type ReposListDeploymentsResponse = Array<ReposListDeploymentsResponseItem>;
  type ReposListDownloadsResponse = Array<ReposListDownloadsResponseItem>;
  type ReposListForOrgResponse = Array<ReposListForOrgResponseItem>;
  type ReposListForksResponse = Array<ReposListForksResponseItem>;
  type ReposListHooksResponse = Array<ReposListHooksResponseItem>;
  type ReposListInvitationsResponse = Array<ReposListInvitationsResponseItem>;
  type ReposListInvitationsForAuthenticatedUserResponse = Array<
    ReposListInvitationsForAuthenticatedUserResponseItem
  >;
  type ReposListPagesBuildsResponse = Array<ReposListPagesBuildsResponseItem>;
  type ReposListProtectedBranchRequiredStatusChecksContextsResponse = Array<
    string
  >;
  type ReposListProtectedBranchTeamRestrictionsResponse = Array<
    ReposListProtectedBranchTeamRestrictionsResponseItem
  >;
  type ReposListProtectedBranchUserRestrictionsResponse = Array<
    ReposListProtectedBranchUserRestrictionsResponseItem
  >;
  type ReposListPublicResponse = Array<ReposListPublicResponseItem>;
  type ReposListPullRequestsAssociatedWithCommitResponse = Array<
    ReposListPullRequestsAssociatedWithCommitResponseItem
  >;
  type ReposListReleasesResponse = Array<ReposListReleasesResponseItem>;
  type ReposListStatusesForRefResponse = Array<
    ReposListStatusesForRefResponseItem
  >;
  type ReposListTagsResponse = Array<ReposListTagsResponseItem>;
  type ReposListTeamsResponse = Array<ReposListTeamsResponseItem>;
  type ReposListTeamsWithAccessToProtectedBranchResponse = Array<
    ReposListTeamsWithAccessToProtectedBranchResponseItem
  >;
  type ReposListUsersWithAccessToProtectedBranchResponse = Array<
    ReposListUsersWithAccessToProtectedBranchResponseItem
  >;
  type ReposRemoveProtectedBranchAppRestrictionsResponse = Array<
    ReposRemoveProtectedBranchAppRestrictionsResponseItem
  >;
  type ReposRemoveProtectedBranchRequiredStatusChecksContextsResponse = Array<
    string
  >;
  type ReposRemoveProtectedBranchTeamRestrictionsResponse = Array<
    ReposRemoveProtectedBranchTeamRestrictionsResponseItem
  >;
  type ReposRemoveProtectedBranchUserRestrictionsResponse = Array<
    ReposRemoveProtectedBranchUserRestrictionsResponseItem
  >;
  type ReposReplaceProtectedBranchAppRestrictionsResponse = Array<
    ReposReplaceProtectedBranchAppRestrictionsResponseItem
  >;
  type ReposReplaceProtectedBranchRequiredStatusChecksContextsResponse = Array<
    string
  >;
  type ReposReplaceProtectedBranchTeamRestrictionsResponse = Array<
    ReposReplaceProtectedBranchTeamRestrictionsResponseItem
  >;
  type ReposReplaceProtectedBranchUserRestrictionsResponse = Array<
    ReposReplaceProtectedBranchUserRestrictionsResponseItem
  >;
  type TeamsListResponse = Array<TeamsListResponseItem>;
  type TeamsListChildResponse = Array<TeamsListChildResponseItem>;
  type TeamsListChildInOrgResponse = Array<TeamsListChildInOrgResponseItem>;
  type TeamsListChildLegacyResponse = Array<TeamsListChildLegacyResponseItem>;
  type TeamsListDiscussionCommentsResponse = Array<
    TeamsListDiscussionCommentsResponseItem
  >;
  type TeamsListDiscussionCommentsInOrgResponse = Array<
    TeamsListDiscussionCommentsInOrgResponseItem
  >;
  type TeamsListDiscussionCommentsLegacyResponse = Array<
    TeamsListDiscussionCommentsLegacyResponseItem
  >;
  type TeamsListDiscussionsResponse = Array<TeamsListDiscussionsResponseItem>;
  type TeamsListDiscussionsInOrgResponse = Array<
    TeamsListDiscussionsInOrgResponseItem
  >;
  type TeamsListDiscussionsLegacyResponse = Array<
    TeamsListDiscussionsLegacyResponseItem
  >;
  type TeamsListForAuthenticatedUserResponse = Array<
    TeamsListForAuthenticatedUserResponseItem
  >;
  type TeamsListMembersResponse = Array<TeamsListMembersResponseItem>;
  type TeamsListMembersInOrgResponse = Array<TeamsListMembersInOrgResponseItem>;
  type TeamsListMembersLegacyResponse = Array<
    TeamsListMembersLegacyResponseItem
  >;
  type TeamsListPendingInvitationsResponse = Array<
    TeamsListPendingInvitationsResponseItem
  >;
  type TeamsListPendingInvitationsInOrgResponse = Array<
    TeamsListPendingInvitationsInOrgResponseItem
  >;
  type TeamsListPendingInvitationsLegacyResponse = Array<
    TeamsListPendingInvitationsLegacyResponseItem
  >;
  type TeamsListProjectsResponse = Array<TeamsListProjectsResponseItem>;
  type TeamsListProjectsInOrgResponse = Array<
    TeamsListProjectsInOrgResponseItem
  >;
  type TeamsListProjectsLegacyResponse = Array<
    TeamsListProjectsLegacyResponseItem
  >;
  type TeamsListReposResponse = Array<TeamsListReposResponseItem>;
  type TeamsListReposInOrgResponse = Array<TeamsListReposInOrgResponseItem>;
  type TeamsListReposLegacyResponse = Array<TeamsListReposLegacyResponseItem>;
  type UsersAddEmailsResponse = Array<UsersAddEmailsResponseItem>;
  type UsersListResponse = Array<UsersListResponseItem>;
  type UsersListBlockedResponse = Array<UsersListBlockedResponseItem>;
  type UsersListEmailsResponse = Array<UsersListEmailsResponseItem>;
  type UsersListFollowersForAuthenticatedUserResponse = Array<
    UsersListFollowersForAuthenticatedUserResponseItem
  >;
  type UsersListFollowersForUserResponse = Array<
    UsersListFollowersForUserResponseItem
  >;
  type UsersListFollowingForAuthenticatedUserResponse = Array<
    UsersListFollowingForAuthenticatedUserResponseItem
  >;
  type UsersListFollowingForUserResponse = Array<
    UsersListFollowingForUserResponseItem
  >;
  type UsersListGpgKeysResponse = Array<UsersListGpgKeysResponseItem>;
  type UsersListGpgKeysForUserResponse = Array<
    UsersListGpgKeysForUserResponseItem
  >;
  type UsersListPublicEmailsResponse = Array<UsersListPublicEmailsResponseItem>;
  type UsersListPublicKeysResponse = Array<UsersListPublicKeysResponseItem>;
  type UsersListPublicKeysForUserResponse = Array<
    UsersListPublicKeysForUserResponseItem
  >;
  type UsersTogglePrimaryEmailVisibilityResponse = Array<
    UsersTogglePrimaryEmailVisibilityResponseItem
  >;

  // param types
  export type ActionsCancelWorkflowRunParams = {
    owner: string;

    repo: string;

    run_id: number;
  };
  export type ActionsCreateOrUpdateSecretForRepoParams = {
    /**
     * Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get your public key](https://developer.github.com/v3/actions/secrets/#get-your-public-key) endpoint.
     */
    encrypted_value?: string;
    /**
     * ID of the key you used to encrypt the secret.
     */
    key_id?: string;

    name: string;

    owner: string;

    repo: string;
  };
  export type ActionsCreateRegistrationTokenParams = {
    owner: string;

    repo: string;
  };
  export type ActionsCreateRemoveTokenParams = {
    owner: string;

    repo: string;
  };
  export type ActionsDeleteArtifactParams = {
    artifact_id: number;

    owner: string;

    repo: string;
  };
  export type ActionsDeleteSecretFromRepoParams = {
    name: string;

    owner: string;

    repo: string;
  };
  export type ActionsDownloadArtifactParams = {
    archive_format: string;

    artifact_id: number;

    owner: string;

    repo: string;
  };
  export type ActionsGetArtifactParams = {
    artifact_id: number;

    owner: string;

    repo: string;
  };
  export type ActionsGetPublicKeyParams = {
    owner: string;

    repo: string;
  };
  export type ActionsGetSecretParams = {
    name: string;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ActionsGetSelfHostedRunnerParams = {
    owner: string;

    repo: string;

    runner_id: number;
  };
  export type ActionsGetWorkflowParams = {
    owner: string;

    repo: string;

    workflow_id: number;
  };
  export type ActionsGetWorkflowJobParams = {
    job_id: number;

    owner: string;

    repo: string;
  };
  export type ActionsGetWorkflowRunParams = {
    owner: string;

    repo: string;

    run_id: number;
  };
  export type ActionsListDownloadsForSelfHostedRunnerApplicationParams = {
    owner: string;

    repo: string;
  };
  export type ActionsListJobsForWorkflowRunParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;

    run_id: number;
  };
  export type ActionsListRepoWorkflowRunsParams = {
    /**
     * Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
     */
    actor?: string;
    /**
     * Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
     */
    branch?: string;
    /**
     * Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see "[Events that trigger workflows](https://help.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows)" in the GitHub Help documentation.
     */
    event?: string;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
    /**
     * Returns workflow runs associated with the check run `status` or `conclusion` you specify. For example, a conclusion can be `success` or a status can be `completed`. For more information, see the `status` and `conclusion` options available in "[Create a check run](https://developer.github.com/v3/checks/runs/#create-a-check-run)."
     */
    status?: "completed" | "status" | "conclusion";
  };
  export type ActionsListRepoWorkflowsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ActionsListSecretsForRepoParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ActionsListSelfHostedRunnersForRepoParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ActionsListWorkflowJobLogsParams = {
    job_id: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ActionsListWorkflowRunArtifactsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;

    run_id: number;
  };
  export type ActionsListWorkflowRunLogsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;

    run_id: number;
  };
  export type ActionsListWorkflowRunsParams = {
    /**
     * Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
     */
    actor?: string;
    /**
     * Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
     */
    branch?: string;
    /**
     * Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see "[Events that trigger workflows](https://help.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows)" in the GitHub Help documentation.
     */
    event?: string;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
    /**
     * Returns workflow runs associated with the check run `status` or `conclusion` you specify. For example, a conclusion can be `success` or a status can be `completed`. For more information, see the `status` and `conclusion` options available in "[Create a check run](https://developer.github.com/v3/checks/runs/#create-a-check-run)."
     */
    status?: "completed" | "status" | "conclusion";

    workflow_id: number;
  };
  export type ActionsReRunWorkflowParams = {
    owner: string;

    repo: string;

    run_id: number;
  };
  export type ActionsRemoveSelfHostedRunnerParams = {
    owner: string;

    repo: string;

    runner_id: number;
  };
  export type ActivityCheckStarringRepoParams = {
    owner: string;

    repo: string;
  };
  export type ActivityCheckWatchingRepoLegacyParams = {
    owner: string;

    repo: string;
  };
  export type ActivityDeleteRepoSubscriptionParams = {
    owner: string;

    repo: string;
  };
  export type ActivityDeleteThreadSubscriptionParams = {
    thread_id: number;
  };
  export type ActivityGetRepoSubscriptionParams = {
    owner: string;

    repo: string;
  };
  export type ActivityGetThreadParams = {
    thread_id: number;
  };
  export type ActivityGetThreadSubscriptionParams = {
    thread_id: number;
  };
  export type ActivityListEventsForOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    username: string;
  };
  export type ActivityListEventsForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    username: string;
  };
  export type ActivityListNotificationsParams = {
    /**
     * If `true`, show notifications marked as read.
     */
    all?: boolean;
    /**
     * Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    before?: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * If `true`, only shows notifications in which the user is directly participating or mentioned.
     */
    participating?: boolean;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
  };
  export type ActivityListNotificationsForRepoParams = {
    /**
     * If `true`, show notifications marked as read.
     */
    all?: boolean;
    /**
     * Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    before?: string;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * If `true`, only shows notifications in which the user is directly participating or mentioned.
     */
    participating?: boolean;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
    /**
     * Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
  };
  export type ActivityListPublicEventsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type ActivityListPublicEventsForOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type ActivityListPublicEventsForRepoNetworkParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ActivityListPublicEventsForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    username: string;
  };
  export type ActivityListReceivedEventsForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    username: string;
  };
  export type ActivityListReceivedPublicEventsForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    username: string;
  };
  export type ActivityListRepoEventsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ActivityListReposStarredByAuthenticatedUserParams = {
    /**
     * One of `asc` (ascending) or `desc` (descending).
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
     */
    sort?: "created" | "updated";
  };
  export type ActivityListReposStarredByUserParams = {
    /**
     * One of `asc` (ascending) or `desc` (descending).
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
     */
    sort?: "created" | "updated";

    username: string;
  };
  export type ActivityListReposWatchedByUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    username: string;
  };
  export type ActivityListStargazersForRepoParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ActivityListWatchedReposForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type ActivityListWatchersForRepoParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ActivityMarkAsReadParams = {
    /**
     * Describes the last point that notifications were checked. Anything updated since this time will not be updated. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
     */
    last_read_at?: string;
  };
  export type ActivityMarkNotificationsAsReadForRepoParams = {
    /**
     * Describes the last point that notifications were checked. Anything updated since this time will not be updated. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
     */
    last_read_at?: string;

    owner: string;

    repo: string;
  };
  export type ActivityMarkThreadAsReadParams = {
    thread_id: number;
  };
  export type ActivitySetRepoSubscriptionParams = {
    /**
     * Determines if all notifications should be blocked from this repository.
     */
    ignored?: boolean;

    owner: string;

    repo: string;
    /**
     * Determines if notifications should be received from this repository.
     */
    subscribed?: boolean;
  };
  export type ActivitySetThreadSubscriptionParams = {
    /**
     * Unsubscribes and subscribes you to a conversation. Set `ignored` to `true` to block all notifications from this thread.
     */
    ignored?: boolean;

    thread_id: number;
  };
  export type ActivityStarRepoParams = {
    owner: string;

    repo: string;
  };
  export type ActivityStopWatchingRepoLegacyParams = {
    owner: string;

    repo: string;
  };
  export type ActivityUnstarRepoParams = {
    owner: string;

    repo: string;
  };
  export type ActivityWatchRepoLegacyParams = {
    owner: string;

    repo: string;
  };
  export type AppsAddRepoToInstallationParams = {
    installation_id: number;

    repository_id: number;
  };
  export type AppsCheckAccountIsAssociatedWithAnyParams = {
    account_id: number;
  };
  export type AppsCheckAccountIsAssociatedWithAnyStubbedParams = {
    account_id: number;
  };
  export type AppsCheckAuthorizationParams = {
    access_token: string;

    client_id: string;
  };
  export type AppsCheckTokenParams = {
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;

    client_id: string;
  };
  export type AppsCreateContentAttachmentParams = {
    /**
     * The body text of the content attachment displayed in the body or comment of an issue or pull request. This parameter supports markdown.
     */
    body: string;

    content_reference_id: number;
    /**
     * The title of the content attachment displayed in the body or comment of an issue or pull request.
     */
    title: string;
  };
  export type AppsCreateFromManifestParams = {
    code: string;
  };
  export type AppsCreateInstallationTokenParams = {
    installation_id: number;
    /**
     * The permissions granted to the access token. The permissions object includes the permission names and their access type. For a complete list of permissions and allowable values, see "[GitHub App permissions](https://developer.github.com/apps/building-github-apps/creating-github-apps-using-url-parameters/#github-app-permissions)."
     */
    permissions?: AppsCreateInstallationTokenParamsPermissions;
    /**
     * The `id`s of the repositories that the installation token can access. Providing repository `id`s restricts the access of an installation token to specific repositories. You can use the "[List repositories](https://developer.github.com/v3/apps/installations/#list-repositories)" endpoint to get the `id` of all repositories that an installation can access. For example, you can select specific repositories when creating an installation token to restrict the number of repositories that can be cloned using the token.
     */
    repository_ids?: number[];
  };
  export type AppsDeleteAuthorizationParams = {
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;

    client_id: string;
  };
  export type AppsDeleteInstallationParams = {
    installation_id: number;
  };
  export type AppsDeleteTokenParams = {
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;

    client_id: string;
  };
  export type AppsFindOrgInstallationParams = {
    org: string;
  };
  export type AppsFindRepoInstallationParams = {
    owner: string;

    repo: string;
  };
  export type AppsFindUserInstallationParams = {
    username: string;
  };
  export type AppsGetBySlugParams = {
    app_slug: string;
  };
  export type AppsGetInstallationParams = {
    installation_id: number;
  };
  export type AppsGetOrgInstallationParams = {
    org: string;
  };
  export type AppsGetRepoInstallationParams = {
    owner: string;

    repo: string;
  };
  export type AppsGetUserInstallationParams = {
    username: string;
  };
  export type AppsListAccountsUserOrOrgOnPlanParams = {
    /**
     * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    plan_id: number;
    /**
     * Sorts the GitHub accounts by the date they were created or last updated. Can be one of `created` or `updated`.
     */
    sort?: "created" | "updated";
  };
  export type AppsListAccountsUserOrOrgOnPlanStubbedParams = {
    /**
     * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    plan_id: number;
    /**
     * Sorts the GitHub accounts by the date they were created or last updated. Can be one of `created` or `updated`.
     */
    sort?: "created" | "updated";
  };
  export type AppsListInstallationReposForAuthenticatedUserParams = {
    installation_id: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type AppsListInstallationsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type AppsListInstallationsForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type AppsListMarketplacePurchasesForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type AppsListMarketplacePurchasesForAuthenticatedUserStubbedParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type AppsListPlansParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type AppsListPlansStubbedParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type AppsListReposParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type AppsRemoveRepoFromInstallationParams = {
    installation_id: number;

    repository_id: number;
  };
  export type AppsResetAuthorizationParams = {
    access_token: string;

    client_id: string;
  };
  export type AppsResetTokenParams = {
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;

    client_id: string;
  };
  export type AppsRevokeAuthorizationForApplicationParams = {
    access_token: string;

    client_id: string;
  };
  export type AppsRevokeGrantForApplicationParams = {
    access_token: string;

    client_id: string;
  };
  export type ChecksCreateParams = {
    /**
     * Displays a button on GitHub that can be clicked to alert your app to do additional tasks. For example, a code linting app can display a button that automatically fixes detected errors. The button created in this object is displayed after the check run completes. When a user clicks the button, GitHub sends the [`check_run.requested_action` webhook](https://developer.github.com/v3/activity/events/types/#checkrunevent) to your app. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://developer.github.com/v3/checks/runs/#actions-object) description. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)." To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)."
     */
    actions?: ChecksCreateParamsActions[];
    /**
     * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    completed_at?: string;
    /**
     * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, or `action_required`. When the conclusion is `action_required`, additional details should be provided on the site specified by `details_url`.
     * **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. Only GitHub can change a check run conclusion to `stale`.
     */
    conclusion?:
      | "success"
      | "failure"
      | "neutral"
      | "cancelled"
      | "timed_out"
      | "action_required";
    /**
     * The URL of the integrator's site that has the full details of the check.
     */
    details_url?: string;
    /**
     * A reference for the run on the integrator's system.
     */
    external_id?: string;
    /**
     * The SHA of the commit.
     */
    head_sha: string;
    /**
     * The name of the check. For example, "code-coverage".
     */
    name: string;
    /**
     * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://developer.github.com/v3/checks/runs/#output-object) description.
     */
    output?: ChecksCreateParamsOutput;

    owner: string;

    repo: string;
    /**
     * The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at?: string;
    /**
     * The current status. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
  };
  export type ChecksCreateSuiteParams = {
    /**
     * The sha of the head commit.
     */
    head_sha: string;

    owner: string;

    repo: string;
  };
  export type ChecksGetParams = {
    check_run_id: number;

    owner: string;

    repo: string;
  };
  export type ChecksGetSuiteParams = {
    check_suite_id: number;

    owner: string;

    repo: string;
  };
  export type ChecksListAnnotationsParams = {
    check_run_id: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ChecksListForRefParams = {
    /**
     * Returns check runs with the specified `name`.
     */
    check_name?: string;
    /**
     * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
     */
    filter?: "latest" | "all";

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    ref: string;

    repo: string;
    /**
     * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
  };
  export type ChecksListForSuiteParams = {
    /**
     * Returns check runs with the specified `name`.
     */
    check_name?: string;

    check_suite_id: number;
    /**
     * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
     */
    filter?: "latest" | "all";

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
    /**
     * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
  };
  export type ChecksListSuitesForRefParams = {
    /**
     * Filters check suites by GitHub App `id`.
     */
    app_id?: number;
    /**
     * Filters checks suites by the name of the [check run](https://developer.github.com/v3/checks/runs/).
     */
    check_name?: string;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    ref: string;

    repo: string;
  };
  export type ChecksRerequestSuiteParams = {
    check_suite_id: number;

    owner: string;

    repo: string;
  };
  export type ChecksSetSuitesPreferencesParams = {
    /**
     * Enables or disables automatic creation of CheckSuite events upon pushes to the repository. Enabled by default. See the [`auto_trigger_checks` object](https://developer.github.com/v3/checks/suites/#auto_trigger_checks-object) description for details.
     */
    auto_trigger_checks?: ChecksSetSuitesPreferencesParamsAutoTriggerChecks[];

    owner: string;

    repo: string;
  };
  export type ChecksUpdateParams = {
    /**
     * Possible further actions the integrator can perform, which a user may trigger. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://developer.github.com/v3/checks/runs/#actions-object) description. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)."
     */
    actions?: ChecksUpdateParamsActions[];

    check_run_id: number;
    /**
     * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    completed_at?: string;
    /**
     * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, or `action_required`.
     * **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. Only GitHub can change a check run conclusion to `stale`.
     */
    conclusion?:
      | "success"
      | "failure"
      | "neutral"
      | "cancelled"
      | "timed_out"
      | "action_required";
    /**
     * The URL of the integrator's site that has the full details of the check.
     */
    details_url?: string;
    /**
     * A reference for the run on the integrator's system.
     */
    external_id?: string;
    /**
     * The name of the check. For example, "code-coverage".
     */
    name?: string;
    /**
     * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://developer.github.com/v3/checks/runs/#output-object-1) description.
     */
    output?: ChecksUpdateParamsOutput;

    owner: string;

    repo: string;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at?: string;
    /**
     * The current status. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
  };
  export type CodesOfConductGetConductCodeParams = {
    key: string;
  };
  export type CodesOfConductGetForRepoParams = {
    owner: string;

    repo: string;
  };
  export type GistsCheckIsStarredParams = {
    gist_id: string;
  };
  export type GistsCreateParams = {
    /**
     * A descriptive name for this gist.
     */
    description?: string;
    /**
     * The filenames and content of each file in the gist. The keys in the `files` object represent the filename and have the type `string`.
     */
    files: GistsCreateParamsFiles;
    /**
     * When `true`, the gist will be public and available for anyone to see.
     */
    public?: boolean;
  };
  export type GistsCreateCommentParams = {
    /**
     * The comment text.
     */
    body: string;

    gist_id: string;
  };
  export type GistsDeleteParams = {
    gist_id: string;
  };
  export type GistsDeleteCommentParams = {
    comment_id: number;

    gist_id: string;
  };
  export type GistsForkParams = {
    gist_id: string;
  };
  export type GistsGetParams = {
    gist_id: string;
  };
  export type GistsGetCommentParams = {
    comment_id: number;

    gist_id: string;
  };
  export type GistsGetRevisionParams = {
    gist_id: string;

    sha: string;
  };
  export type GistsListParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
  };
  export type GistsListCommentsParams = {
    gist_id: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type GistsListCommitsParams = {
    gist_id: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type GistsListForksParams = {
    gist_id: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type GistsListPublicParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
  };
  export type GistsListPublicForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;

    username: string;
  };
  export type GistsListStarredParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
  };
  export type GistsStarParams = {
    gist_id: string;
  };
  export type GistsUnstarParams = {
    gist_id: string;
  };
  export type GistsUpdateParams = {
    /**
     * A descriptive name for this gist.
     */
    description?: string;
    /**
     * The filenames and content that make up this gist.
     */
    files?: GistsUpdateParamsFiles;

    gist_id: string;
  };
  export type GistsUpdateCommentParams = {
    /**
     * The comment text.
     */
    body: string;

    comment_id: number;

    gist_id: string;
  };
  export type GitCreateBlobParams = {
    /**
     * The new blob's content.
     */
    content: string;
    /**
     * The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.
     */
    encoding?: string;

    owner: string;

    repo: string;
  };
  export type GitCreateCommitParams = {
    /**
     * Information about the author of the commit. By default, the `author` will be the authenticated user and the current date. See the `author` and `committer` object below for details.
     */
    author?: GitCreateCommitParamsAuthor;
    /**
     * Information about the person who is making the commit. By default, `committer` will use the information set in `author`. See the `author` and `committer` object below for details.
     */
    committer?: GitCreateCommitParamsCommitter;
    /**
     * The commit message
     */
    message: string;

    owner: string;
    /**
     * The SHAs of the commits that were the parents of this commit. If omitted or empty, the commit will be written as a root commit. For a single parent, an array of one SHA should be provided; for a merge commit, an array of more than one should be provided.
     */
    parents: string[];

    repo: string;
    /**
     * The [PGP signature](https://en.wikipedia.org/wiki/Pretty_Good_Privacy) of the commit. GitHub adds the signature to the `gpgsig` header of the created commit. For a commit signature to be verifiable by Git or GitHub, it must be an ASCII-armored detached PGP signature over the string commit as it would be written to the object database. To pass a `signature` parameter, you need to first manually create a valid PGP signature, which can be complicated. You may find it easier to [use the command line](https://git-scm.com/book/id/v2/Git-Tools-Signing-Your-Work) to create signed commits.
     */
    signature?: string;
    /**
     * The SHA of the tree object this commit points to
     */
    tree: string;
  };
  export type GitCreateRefParams = {
    owner: string;
    /**
     * The name of the fully qualified reference (ie: `refs/heads/master`). If it doesn't start with 'refs' and have at least two slashes, it will be rejected.
     */
    ref: string;

    repo: string;
    /**
     * The SHA1 value for this reference.
     */
    sha: string;
  };
  export type GitCreateTagParams = {
    /**
     * The tag message.
     */
    message: string;
    /**
     * The SHA of the git object this is tagging.
     */
    object: string;

    owner: string;

    repo: string;
    /**
     * The tag's name. This is typically a version (e.g., "v0.0.1").
     */
    tag: string;
    /**
     * An object with information about the individual creating the tag.
     */
    tagger?: GitCreateTagParamsTagger;
    /**
     * The type of the object we're tagging. Normally this is a `commit` but it can also be a `tree` or a `blob`.
     */
    type: "commit" | "tree" | "blob";
  };
  export type GitCreateTreeParams = {
    /**
     * The SHA1 of the tree you want to update with new data. If you don't set this, the commit will be created on top of everything; however, it will only contain your change, the rest of your files will show up as deleted.
     */
    base_tree?: string;

    owner: string;

    repo: string;
    /**
     * Objects (of `path`, `mode`, `type`, and `sha`) specifying a tree structure.
     */
    tree: GitCreateTreeParamsTree[];
  };
  export type GitDeleteRefParams = {
    owner: string;

    ref: string;

    repo: string;
  };
  export type GitGetBlobParams = {
    file_sha: string;

    owner: string;

    repo: string;
  };
  export type GitGetCommitParams = {
    commit_sha: string;

    owner: string;

    repo: string;
  };
  export type GitGetRefParams = {
    owner: string;

    ref: string;

    repo: string;
  };
  export type GitGetTagParams = {
    owner: string;

    repo: string;

    tag_sha: string;
  };
  export type GitGetTreeParams = {
    owner: string;

    recursive?: "1";

    repo: string;

    tree_sha: string;
  };
  export type GitListMatchingRefsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    ref: string;

    repo: string;
  };
  export type GitListRefsParams = {
    /**
     * Filter by sub-namespace (reference prefix). Most commen examples would be `'heads/'` and `'tags/'` to retrieve branches or tags
     */
    namespace?: string;

    owner: string;

    page?: number;

    per_page?: number;

    repo: string;
  };
  export type GitUpdateRefParams = {
    /**
     * Indicates whether to force the update or to make sure the update is a fast-forward update. Leaving this out or setting it to `false` will make sure you're not overwriting work.
     */
    force?: boolean;

    owner: string;

    ref: string;

    repo: string;
    /**
     * The SHA1 value to set this reference to
     */
    sha: string;
  };
  export type GitignoreGetTemplateParams = {
    name: string;
  };
  export type InteractionsAddOrUpdateRestrictionsForOrgParams = {
    /**
     * Specifies the group of GitHub users who can comment, open issues, or create pull requests in public repositories for the given organization. Must be one of: `existing_users`, `contributors_only`, or `collaborators_only`.
     */
    limit: "existing_users" | "contributors_only" | "collaborators_only";

    org: string;
  };
  export type InteractionsAddOrUpdateRestrictionsForRepoParams = {
    /**
     * Specifies the group of GitHub users who can comment, open issues, or create pull requests for the given repository. Must be one of: `existing_users`, `contributors_only`, or `collaborators_only`.
     */
    limit: "existing_users" | "contributors_only" | "collaborators_only";

    owner: string;

    repo: string;
  };
  export type InteractionsGetRestrictionsForOrgParams = {
    org: string;
  };
  export type InteractionsGetRestrictionsForRepoParams = {
    owner: string;

    repo: string;
  };
  export type InteractionsRemoveRestrictionsForOrgParams = {
    org: string;
  };
  export type InteractionsRemoveRestrictionsForRepoParams = {
    owner: string;

    repo: string;
  };
  export type IssuesAddAssigneesParamsDeprecatedNumber = {
    /**
     * Usernames of people to assign this issue to. _NOTE: Only users with push access can add assignees to an issue. Assignees are silently ignored otherwise._
     */
    assignees?: string[];
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type IssuesAddAssigneesParams = {
    /**
     * Usernames of people to assign this issue to. _NOTE: Only users with push access can add assignees to an issue. Assignees are silently ignored otherwise._
     */
    assignees?: string[];

    issue_number: number;

    owner: string;

    repo: string;
  };
  export type IssuesAddLabelsParamsDeprecatedNumber = {
    /**
     * The name of the label to add to the issue. Must contain at least one label. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
     */
    labels: string[];
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type IssuesAddLabelsParams = {
    issue_number: number;
    /**
     * The name of the label to add to the issue. Must contain at least one label. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
     */
    labels: string[];

    owner: string;

    repo: string;
  };
  export type IssuesCheckAssigneeParams = {
    assignee: string;

    owner: string;

    repo: string;
  };
  export type IssuesCreateParamsDeprecatedAssignee = {
    /**
     * Login for the user that this issue should be assigned to. _NOTE: Only users with push access can set the assignee for new issues. The assignee is silently dropped otherwise. **This field is deprecated.**_
     * @deprecated "assignee" parameter has been deprecated and will be removed in future
     */
    assignee?: string;
    /**
     * Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
    /**
     * The contents of the issue.
     */
    body?: string;
    /**
     * Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * The `number` of the milestone to associate this issue with. _NOTE: Only users with push access can set the milestone for new issues. The milestone is silently dropped otherwise._
     */
    milestone?: number;

    owner: string;

    repo: string;
    /**
     * The title of the issue.
     */
    title: string;
  };
  export type IssuesCreateParams = {
    /**
     * Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
    /**
     * The contents of the issue.
     */
    body?: string;
    /**
     * Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * The `number` of the milestone to associate this issue with. _NOTE: Only users with push access can set the milestone for new issues. The milestone is silently dropped otherwise._
     */
    milestone?: number;

    owner: string;

    repo: string;
    /**
     * The title of the issue.
     */
    title: string;
  };
  export type IssuesCreateCommentParamsDeprecatedNumber = {
    /**
     * The contents of the comment.
     */
    body: string;
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type IssuesCreateCommentParams = {
    /**
     * The contents of the comment.
     */
    body: string;

    issue_number: number;

    owner: string;

    repo: string;
  };
  export type IssuesCreateLabelParams = {
    /**
     * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
     */
    color: string;
    /**
     * A short description of the label.
     */
    description?: string;
    /**
     * The name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
     */
    name: string;

    owner: string;

    repo: string;
  };
  export type IssuesCreateMilestoneParams = {
    /**
     * A description of the milestone.
     */
    description?: string;
    /**
     * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    due_on?: string;

    owner: string;

    repo: string;
    /**
     * The state of the milestone. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the milestone.
     */
    title: string;
  };
  export type IssuesDeleteCommentParams = {
    comment_id: number;

    owner: string;

    repo: string;
  };
  export type IssuesDeleteLabelParams = {
    name: string;

    owner: string;

    repo: string;
  };
  export type IssuesDeleteMilestoneParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "milestone_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type IssuesDeleteMilestoneParams = {
    milestone_number: number;

    owner: string;

    repo: string;
  };
  export type IssuesGetParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type IssuesGetParams = {
    issue_number: number;

    owner: string;

    repo: string;
  };
  export type IssuesGetCommentParams = {
    comment_id: number;

    owner: string;

    repo: string;
  };
  export type IssuesGetEventParams = {
    event_id: number;

    owner: string;

    repo: string;
  };
  export type IssuesGetLabelParams = {
    name: string;

    owner: string;

    repo: string;
  };
  export type IssuesGetMilestoneParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "milestone_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type IssuesGetMilestoneParams = {
    milestone_number: number;

    owner: string;

    repo: string;
  };
  export type IssuesListParams = {
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Indicates which sorts of issues to return. Can be one of:
     * \* `assigned`: Issues assigned to you
     * \* `created`: Issues created by you
     * \* `mentioned`: Issues mentioning you
     * \* `subscribed`: Issues you're subscribed to updates for
     * \* `all`: All issues the authenticated user can see, regardless of participation or creation
     */
    filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
  };
  export type IssuesListAssigneesParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type IssuesListCommentsParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
    /**
     * Only comments updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
  };
  export type IssuesListCommentsParams = {
    issue_number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
    /**
     * Only comments updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
  };
  export type IssuesListCommentsForRepoParams = {
    /**
     * Either `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";

    owner: string;

    repo: string;
    /**
     * Only comments updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Either `created` or `updated`.
     */
    sort?: "created" | "updated";
  };
  export type IssuesListEventsParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type IssuesListEventsParams = {
    issue_number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type IssuesListEventsForRepoParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type IssuesListEventsForTimelineParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type IssuesListEventsForTimelineParams = {
    issue_number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type IssuesListForAuthenticatedUserParams = {
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Indicates which sorts of issues to return. Can be one of:
     * \* `assigned`: Issues assigned to you
     * \* `created`: Issues created by you
     * \* `mentioned`: Issues mentioning you
     * \* `subscribed`: Issues you're subscribed to updates for
     * \* `all`: All issues the authenticated user can see, regardless of participation or creation
     */
    filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
  };
  export type IssuesListForOrgParams = {
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Indicates which sorts of issues to return. Can be one of:
     * \* `assigned`: Issues assigned to you
     * \* `created`: Issues created by you
     * \* `mentioned`: Issues mentioning you
     * \* `subscribed`: Issues you're subscribed to updates for
     * \* `all`: All issues the authenticated user can see, regardless of participation or creation
     */
    filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;

    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
  };
  export type IssuesListForRepoParams = {
    /**
     * Can be the name of a user. Pass in `none` for issues with no assigned user, and `*` for issues assigned to any user.
     */
    assignee?: string;
    /**
     * The user that created the issue.
     */
    creator?: string;
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * A user that's mentioned in the issue.
     */
    mentioned?: string;
    /**
     * If an `integer` is passed, it should refer to a milestone by its `number` field. If the string `*` is passed, issues with any milestone are accepted. If the string `none` is passed, issues without milestones are returned.
     */
    milestone?: string;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
  };
  export type IssuesListLabelsForMilestoneParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "milestone_number"
     */
    number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type IssuesListLabelsForMilestoneParams = {
    milestone_number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type IssuesListLabelsForRepoParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type IssuesListLabelsOnIssueParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type IssuesListLabelsOnIssueParams = {
    issue_number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type IssuesListMilestonesForRepoParams = {
    /**
     * The direction of the sort. Either `asc` or `desc`.
     */
    direction?: "asc" | "desc";

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
    /**
     * What to sort results by. Either `due_on` or `completeness`.
     */
    sort?: "due_on" | "completeness";
    /**
     * The state of the milestone. Either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
  };
  export type IssuesLockParamsDeprecatedNumber = {
    /**
     * The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:
     * \* `off-topic`
     * \* `too heated`
     * \* `resolved`
     * \* `spam`
     */
    lock_reason?: "off-topic" | "too heated" | "resolved" | "spam";
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type IssuesLockParams = {
    issue_number: number;
    /**
     * The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:
     * \* `off-topic`
     * \* `too heated`
     * \* `resolved`
     * \* `spam`
     */
    lock_reason?: "off-topic" | "too heated" | "resolved" | "spam";

    owner: string;

    repo: string;
  };
  export type IssuesRemoveAssigneesParamsDeprecatedNumber = {
    /**
     * Usernames of assignees to remove from an issue. _NOTE: Only users with push access can remove assignees from an issue. Assignees are silently ignored otherwise._
     */
    assignees?: string[];
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type IssuesRemoveAssigneesParams = {
    /**
     * Usernames of assignees to remove from an issue. _NOTE: Only users with push access can remove assignees from an issue. Assignees are silently ignored otherwise._
     */
    assignees?: string[];

    issue_number: number;

    owner: string;

    repo: string;
  };
  export type IssuesRemoveLabelParamsDeprecatedNumber = {
    name: string;
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type IssuesRemoveLabelParams = {
    issue_number: number;

    name: string;

    owner: string;

    repo: string;
  };
  export type IssuesRemoveLabelsParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type IssuesRemoveLabelsParams = {
    issue_number: number;

    owner: string;

    repo: string;
  };
  export type IssuesReplaceLabelsParamsDeprecatedNumber = {
    /**
     * The names of the labels to add to the issue. You can pass an empty array to remove all labels. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
     */
    labels?: string[];
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type IssuesReplaceLabelsParams = {
    issue_number: number;
    /**
     * The names of the labels to add to the issue. You can pass an empty array to remove all labels. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
     */
    labels?: string[];

    owner: string;

    repo: string;
  };
  export type IssuesUnlockParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type IssuesUnlockParams = {
    issue_number: number;

    owner: string;

    repo: string;
  };
  export type IssuesUpdateParamsDeprecatedNumber = {
    /**
     * Logins for Users to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this Issue. Send an empty array (`[]`) to clear all assignees from the Issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
    /**
     * The contents of the issue.
     */
    body?: string;
    /**
     * Labels to associate with this issue. Pass one or more Labels to _replace_ the set of Labels on this Issue. Send an empty array (`[]`) to clear all Labels from the Issue. _NOTE: Only users with push access can set labels for issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * The `number` of the milestone to associate this issue with or `null` to remove current. _NOTE: Only users with push access can set the milestone for issues. The milestone is silently dropped otherwise._
     */
    milestone?: number | null;
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;

    repo: string;
    /**
     * State of the issue. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the issue.
     */
    title?: string;
  };
  export type IssuesUpdateParamsDeprecatedAssignee = {
    /**
     * Login for the user that this issue should be assigned to. **This field is deprecated.**
     * @deprecated "assignee" parameter has been deprecated and will be removed in future
     */
    assignee?: string;
    /**
     * Logins for Users to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this Issue. Send an empty array (`[]`) to clear all assignees from the Issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
    /**
     * The contents of the issue.
     */
    body?: string;

    issue_number: number;
    /**
     * Labels to associate with this issue. Pass one or more Labels to _replace_ the set of Labels on this Issue. Send an empty array (`[]`) to clear all Labels from the Issue. _NOTE: Only users with push access can set labels for issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * The `number` of the milestone to associate this issue with or `null` to remove current. _NOTE: Only users with push access can set the milestone for issues. The milestone is silently dropped otherwise._
     */
    milestone?: number | null;

    owner: string;

    repo: string;
    /**
     * State of the issue. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the issue.
     */
    title?: string;
  };
  export type IssuesUpdateParams = {
    /**
     * Logins for Users to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this Issue. Send an empty array (`[]`) to clear all assignees from the Issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
    /**
     * The contents of the issue.
     */
    body?: string;

    issue_number: number;
    /**
     * Labels to associate with this issue. Pass one or more Labels to _replace_ the set of Labels on this Issue. Send an empty array (`[]`) to clear all Labels from the Issue. _NOTE: Only users with push access can set labels for issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * The `number` of the milestone to associate this issue with or `null` to remove current. _NOTE: Only users with push access can set the milestone for issues. The milestone is silently dropped otherwise._
     */
    milestone?: number | null;

    owner: string;

    repo: string;
    /**
     * State of the issue. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the issue.
     */
    title?: string;
  };
  export type IssuesUpdateCommentParams = {
    /**
     * The contents of the comment.
     */
    body: string;

    comment_id: number;

    owner: string;

    repo: string;
  };
  export type IssuesUpdateLabelParams = {
    /**
     * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
     */
    color?: string;

    current_name: string;
    /**
     * A short description of the label.
     */
    description?: string;
    /**
     * The new name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
     */
    name?: string;

    owner: string;

    repo: string;
  };
  export type IssuesUpdateMilestoneParamsDeprecatedNumber = {
    /**
     * A description of the milestone.
     */
    description?: string;
    /**
     * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    due_on?: string;
    /**
     * @deprecated "number" parameter renamed to "milestone_number"
     */
    number: number;

    owner: string;

    repo: string;
    /**
     * The state of the milestone. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the milestone.
     */
    title?: string;
  };
  export type IssuesUpdateMilestoneParams = {
    /**
     * A description of the milestone.
     */
    description?: string;
    /**
     * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    due_on?: string;

    milestone_number: number;

    owner: string;

    repo: string;
    /**
     * The state of the milestone. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the milestone.
     */
    title?: string;
  };
  export type LicensesGetParams = {
    license: string;
  };
  export type LicensesGetForRepoParams = {
    owner: string;

    repo: string;
  };
  export type MarkdownRenderParams = {
    /**
     * The repository context to use when creating references in `gfm` mode. Omit this parameter when using `markdown` mode.
     */
    context?: string;
    /**
     * The rendering mode. Can be either:
     * \* `markdown` to render a document in plain Markdown, just like README.md files are rendered.
     * \* `gfm` to render a document in [GitHub Flavored Markdown](https://github.github.com/gfm/), which creates links for user mentions as well as references to SHA-1 hashes, issues, and pull requests.
     */
    mode?: "markdown" | "gfm";
    /**
     * The Markdown text to render in HTML. Markdown content must be 400 KB or less.
     */
    text: string;
  };
  export type MarkdownRenderRawParams = {
    data: string;
  };
  export type MigrationsCancelImportParams = {
    owner: string;

    repo: string;
  };
  export type MigrationsDeleteArchiveForAuthenticatedUserParams = {
    migration_id: number;
  };
  export type MigrationsDeleteArchiveForOrgParams = {
    migration_id: number;

    org: string;
  };
  export type MigrationsDownloadArchiveForOrgParams = {
    migration_id: number;

    org: string;
  };
  export type MigrationsGetArchiveForAuthenticatedUserParams = {
    migration_id: number;
  };
  export type MigrationsGetArchiveForOrgParams = {
    migration_id: number;

    org: string;
  };
  export type MigrationsGetCommitAuthorsParams = {
    owner: string;

    repo: string;
    /**
     * Only authors found after this id are returned. Provide the highest author ID you've seen so far. New authors may be added to the list at any point while the importer is performing the `raw` step.
     */
    since?: string;
  };
  export type MigrationsGetImportProgressParams = {
    owner: string;

    repo: string;
  };
  export type MigrationsGetLargeFilesParams = {
    owner: string;

    repo: string;
  };
  export type MigrationsGetStatusForAuthenticatedUserParams = {
    migration_id: number;
  };
  export type MigrationsGetStatusForOrgParams = {
    migration_id: number;

    org: string;
  };
  export type MigrationsListForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type MigrationsListForOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type MigrationsListReposForOrgParams = {
    migration_id: number;

    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type MigrationsListReposForUserParams = {
    migration_id: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type MigrationsMapCommitAuthorParams = {
    author_id: number;
    /**
     * The new Git author email.
     */
    email?: string;
    /**
     * The new Git author name.
     */
    name?: string;

    owner: string;

    repo: string;
  };
  export type MigrationsSetLfsPreferenceParams = {
    owner: string;

    repo: string;
    /**
     * Can be one of `opt_in` (large files will be stored using Git LFS) or `opt_out` (large files will be removed during the import).
     */
    use_lfs: "opt_in" | "opt_out";
  };
  export type MigrationsStartForAuthenticatedUserParams = {
    /**
     * Does not include attachments uploaded to GitHub.com in the migration data when set to `true`. Excluding attachments will reduce the migration archive file size.
     */
    exclude_attachments?: boolean;
    /**
     * Locks the `repositories` to prevent changes during the migration when set to `true`.
     */
    lock_repositories?: boolean;
    /**
     * An array of repositories to include in the migration.
     */
    repositories: string[];
  };
  export type MigrationsStartForOrgParams = {
    /**
     * Indicates whether attachments should be excluded from the migration (to reduce migration archive file size).
     */
    exclude_attachments?: boolean;
    /**
     * Indicates whether repositories should be locked (to prevent manipulation) while migrating data.
     */
    lock_repositories?: boolean;

    org: string;
    /**
     * A list of arrays indicating which repositories should be migrated.
     */
    repositories: string[];
  };
  export type MigrationsStartImportParams = {
    owner: string;

    repo: string;
    /**
     * For a tfvc import, the name of the project that is being imported.
     */
    tfvc_project?: string;
    /**
     * The originating VCS type. Can be one of `subversion`, `git`, `mercurial`, or `tfvc`. Please be aware that without this parameter, the import job will take additional time to detect the VCS type before beginning the import. This detection step will be reflected in the response.
     */
    vcs?: "subversion" | "git" | "mercurial" | "tfvc";
    /**
     * If authentication is required, the password to provide to `vcs_url`.
     */
    vcs_password?: string;
    /**
     * The URL of the originating repository.
     */
    vcs_url: string;
    /**
     * If authentication is required, the username to provide to `vcs_url`.
     */
    vcs_username?: string;
  };
  export type MigrationsUnlockRepoForAuthenticatedUserParams = {
    migration_id: number;

    repo_name: string;
  };
  export type MigrationsUnlockRepoForOrgParams = {
    migration_id: number;

    org: string;

    repo_name: string;
  };
  export type MigrationsUpdateImportParams = {
    owner: string;

    repo: string;
    /**
     * The password to provide to the originating repository.
     */
    vcs_password?: string;
    /**
     * The username to provide to the originating repository.
     */
    vcs_username?: string;
  };
  export type OauthAuthorizationsCheckAuthorizationParams = {
    access_token: string;

    client_id: string;
  };
  export type OauthAuthorizationsCreateAuthorizationParams = {
    /**
     * The 20 character OAuth app client key for which to create the token.
     */
    client_id?: string;
    /**
     * The 40 character OAuth app client secret for which to create the token.
     */
    client_secret?: string;
    /**
     * A unique string to distinguish an authorization from others created for the same client ID and user.
     */
    fingerprint?: string;
    /**
     * A note to remind you what the OAuth token is for. Tokens not associated with a specific OAuth application (i.e. personal access tokens) must have a unique note.
     */
    note: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
  };
  export type OauthAuthorizationsDeleteAuthorizationParams = {
    authorization_id: number;
  };
  export type OauthAuthorizationsDeleteGrantParams = {
    grant_id: number;
  };
  export type OauthAuthorizationsGetAuthorizationParams = {
    authorization_id: number;
  };
  export type OauthAuthorizationsGetGrantParams = {
    grant_id: number;
  };
  export type OauthAuthorizationsGetOrCreateAuthorizationForAppParams = {
    client_id: string;
    /**
     * The 40 character OAuth app client secret associated with the client ID specified in the URL.
     */
    client_secret: string;
    /**
     * A unique string to distinguish an authorization from others created for the same client and user. If provided, this API is functionally equivalent to [Get-or-create an authorization for a specific app and fingerprint](https://developer.github.com/v3/oauth_authorizations/#get-or-create-an-authorization-for-a-specific-app-and-fingerprint).
     */
    fingerprint?: string;
    /**
     * A note to remind you what the OAuth token is for.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
  };
  export type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintParams = {
    client_id: string;
    /**
     * The 40 character OAuth app client secret associated with the client ID specified in the URL.
     */
    client_secret: string;

    fingerprint: string;
    /**
     * A note to remind you what the OAuth token is for.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
  };
  export type OauthAuthorizationsGetOrCreateAuthorizationForAppFingerprintParams = {
    client_id: string;
    /**
     * The 40 character OAuth app client secret associated with the client ID specified in the URL.
     */
    client_secret: string;

    fingerprint: string;
    /**
     * A note to remind you what the OAuth token is for.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
  };
  export type OauthAuthorizationsListAuthorizationsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type OauthAuthorizationsListGrantsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type OauthAuthorizationsResetAuthorizationParams = {
    access_token: string;

    client_id: string;
  };
  export type OauthAuthorizationsRevokeAuthorizationForApplicationParams = {
    access_token: string;

    client_id: string;
  };
  export type OauthAuthorizationsRevokeGrantForApplicationParams = {
    access_token: string;

    client_id: string;
  };
  export type OauthAuthorizationsUpdateAuthorizationParams = {
    /**
     * A list of scopes to add to this authorization.
     */
    add_scopes?: string[];

    authorization_id: number;
    /**
     * A unique string to distinguish an authorization from others created for the same client ID and user.
     */
    fingerprint?: string;
    /**
     * A note to remind you what the OAuth token is for. Tokens not associated with a specific OAuth application (i.e. personal access tokens) must have a unique note.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A list of scopes to remove from this authorization.
     */
    remove_scopes?: string[];
    /**
     * Replaces the authorization scopes with these.
     */
    scopes?: string[];
  };
  export type OrgsAddOrUpdateMembershipParams = {
    org: string;
    /**
     * The role to give the user in the organization. Can be one of:
     * \* `admin` - The user will become an owner of the organization.
     * \* `member` - The user will become a non-owner member of the organization.
     */
    role?: "admin" | "member";

    username: string;
  };
  export type OrgsBlockUserParams = {
    org: string;

    username: string;
  };
  export type OrgsCheckBlockedUserParams = {
    org: string;

    username: string;
  };
  export type OrgsCheckMembershipParams = {
    org: string;

    username: string;
  };
  export type OrgsCheckPublicMembershipParams = {
    org: string;

    username: string;
  };
  export type OrgsConcealMembershipParams = {
    org: string;

    username: string;
  };
  export type OrgsConvertMemberToOutsideCollaboratorParams = {
    org: string;

    username: string;
  };
  export type OrgsCreateHookParams = {
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/orgs/hooks/#create-hook-config-params).
     */
    config: OrgsCreateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
     */
    events?: string[];
    /**
     * Must be passed as "web".
     */
    name: string;

    org: string;
  };
  export type OrgsCreateInvitationParams = {
    /**
     * **Required unless you provide `invitee_id`**. Email address of the person you are inviting, which can be an existing GitHub user.
     */
    email?: string;
    /**
     * **Required unless you provide `email`**. GitHub user ID for the person you are inviting.
     */
    invitee_id?: number;

    org: string;
    /**
     * Specify role for new member. Can be one of:
     * \* `admin` - Organization owners with full administrative rights to the organization and complete access to all repositories and teams.
     * \* `direct_member` - Non-owner organization members with ability to see other members and join teams by invitation.
     * \* `billing_manager` - Non-owner organization members with ability to manage the billing settings of your organization.
     */
    role?: "admin" | "direct_member" | "billing_manager";
    /**
     * Specify IDs for the teams you want to invite new members to.
     */
    team_ids?: number[];
  };
  export type OrgsDeleteHookParams = {
    hook_id: number;

    org: string;
  };
  export type OrgsGetParams = {
    org: string;
  };
  export type OrgsGetHookParams = {
    hook_id: number;

    org: string;
  };
  export type OrgsGetMembershipParams = {
    org: string;

    username: string;
  };
  export type OrgsGetMembershipForAuthenticatedUserParams = {
    org: string;
  };
  export type OrgsListParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The integer ID of the last organization that you've seen.
     */
    since?: number;
  };
  export type OrgsListBlockedUsersParams = {
    org: string;
  };
  export type OrgsListForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type OrgsListForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    username: string;
  };
  export type OrgsListHooksParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type OrgsListInstallationsParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type OrgsListInvitationTeamsParams = {
    invitation_id: number;

    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type OrgsListMembersParams = {
    /**
     * Filter members returned in the list. Can be one of:
     * \* `2fa_disabled` - Members without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled. Available for organization owners.
     * \* `all` - All members the authenticated user can see.
     */
    filter?: "2fa_disabled" | "all";

    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Filter members returned by their role. Can be one of:
     * \* `all` - All members of the organization, regardless of role.
     * \* `admin` - Organization owners.
     * \* `member` - Non-owner organization members.
     */
    role?: "all" | "admin" | "member";
  };
  export type OrgsListMembershipsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Indicates the state of the memberships to return. Can be either `active` or `pending`. If not specified, the API returns both active and pending memberships.
     */
    state?: "active" | "pending";
  };
  export type OrgsListOutsideCollaboratorsParams = {
    /**
     * Filter the list of outside collaborators. Can be one of:
     * \* `2fa_disabled`: Outside collaborators without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled.
     * \* `all`: All outside collaborators.
     */
    filter?: "2fa_disabled" | "all";

    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type OrgsListPendingInvitationsParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type OrgsListPublicMembersParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type OrgsPingHookParams = {
    hook_id: number;

    org: string;
  };
  export type OrgsPublicizeMembershipParams = {
    org: string;

    username: string;
  };
  export type OrgsRemoveMemberParams = {
    org: string;

    username: string;
  };
  export type OrgsRemoveMembershipParams = {
    org: string;

    username: string;
  };
  export type OrgsRemoveOutsideCollaboratorParams = {
    org: string;

    username: string;
  };
  export type OrgsUnblockUserParams = {
    org: string;

    username: string;
  };
  export type OrgsUpdateParamsDeprecatedMembersAllowedRepositoryCreationType = {
    /**
     * Billing email address. This address is not publicized.
     */
    billing_email?: string;
    /**
     * The company name.
     */
    company?: string;
    /**
     * Default permission level members have for organization repositories:
     * \* `read` - can pull, but not push to or administer this repository.
     * \* `write` - can pull and push, but not administer this repository.
     * \* `admin` - can pull, push, and administer this repository.
     * \* `none` - no permissions granted by default.
     */
    default_repository_permission?: "read" | "write" | "admin" | "none";
    /**
     * The description of the company.
     */
    description?: string;
    /**
     * The publicly visible email address.
     */
    email?: string;
    /**
     * Toggles whether an organization can use organization projects.
     */
    has_organization_projects?: boolean;
    /**
     * Toggles whether repositories that belong to the organization can use repository projects.
     */
    has_repository_projects?: boolean;
    /**
     * The location.
     */
    location?: string;
    /**
     * Specifies which types of repositories non-admin organization members can create. Can be one of:
     * \* `all` - all organization members can create public and private repositories.
     * \* `private` - members can create private repositories. This option is only available to repositories that are part of an organization on GitHub Enterprise Cloud.
     * \* `none` - only admin members can create repositories.
     * **Note:** This parameter is deprecated and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See [this note](https://developer.github.com/v3/orgs/#members_can_create_repositories) for details.
     * @deprecated "members_allowed_repository_creation_type" parameter has been deprecated and will be removed in future
     */
    members_allowed_repository_creation_type?: string;
    /**
     * Toggles whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud. Can be one of:
     * \* `true` - all organization members can create internal repositories.
     * \* `false` - only organization owners can create internal repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_internal_repositories?: boolean;
    /**
     * Toggles whether organization members can create private repositories, which are visible to organization members with permission. Can be one of:
     * \* `true` - all organization members can create private repositories.
     * \* `false` - only organization owners can create private repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_private_repositories?: boolean;
    /**
     * Toggles whether organization members can create public repositories, which are visible to anyone. Can be one of:
     * \* `true` - all organization members can create public repositories.
     * \* `false` - only organization owners can create public repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_public_repositories?: boolean;
    /**
     * Toggles the ability of non-admin organization members to create repositories. Can be one of:
     * \* `true` - all organization members can create repositories.
     * \* `false` - only organization owners can create repositories.
     * Default: `true`
     * **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.
     */
    members_can_create_repositories?: boolean;
    /**
     * The shorthand name of the company.
     */
    name?: string;

    org: string;
  };
  export type OrgsUpdateParams = {
    /**
     * Billing email address. This address is not publicized.
     */
    billing_email?: string;
    /**
     * The company name.
     */
    company?: string;
    /**
     * Default permission level members have for organization repositories:
     * \* `read` - can pull, but not push to or administer this repository.
     * \* `write` - can pull and push, but not administer this repository.
     * \* `admin` - can pull, push, and administer this repository.
     * \* `none` - no permissions granted by default.
     */
    default_repository_permission?: "read" | "write" | "admin" | "none";
    /**
     * The description of the company.
     */
    description?: string;
    /**
     * The publicly visible email address.
     */
    email?: string;
    /**
     * Toggles whether an organization can use organization projects.
     */
    has_organization_projects?: boolean;
    /**
     * Toggles whether repositories that belong to the organization can use repository projects.
     */
    has_repository_projects?: boolean;
    /**
     * The location.
     */
    location?: string;
    /**
     * Toggles whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud. Can be one of:
     * \* `true` - all organization members can create internal repositories.
     * \* `false` - only organization owners can create internal repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_internal_repositories?: boolean;
    /**
     * Toggles whether organization members can create private repositories, which are visible to organization members with permission. Can be one of:
     * \* `true` - all organization members can create private repositories.
     * \* `false` - only organization owners can create private repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_private_repositories?: boolean;
    /**
     * Toggles whether organization members can create public repositories, which are visible to anyone. Can be one of:
     * \* `true` - all organization members can create public repositories.
     * \* `false` - only organization owners can create public repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_public_repositories?: boolean;
    /**
     * Toggles the ability of non-admin organization members to create repositories. Can be one of:
     * \* `true` - all organization members can create repositories.
     * \* `false` - only organization owners can create repositories.
     * Default: `true`
     * **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.
     */
    members_can_create_repositories?: boolean;
    /**
     * The shorthand name of the company.
     */
    name?: string;

    org: string;
  };
  export type OrgsUpdateHookParams = {
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/orgs/hooks/#update-hook-config-params).
     */
    config?: OrgsUpdateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
     */
    events?: string[];

    hook_id: number;

    org: string;
  };
  export type OrgsUpdateMembershipParams = {
    org: string;
    /**
     * The state that the membership should be in. Only `"active"` will be accepted.
     */
    state: "active";
  };
  export type ProjectsAddCollaboratorParams = {
    /**
     * The permission to grant the collaborator. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)." Can be one of:
     * \* `read` - can read, but not write to or administer this project.
     * \* `write` - can read and write, but not administer this project.
     * \* `admin` - can read, write and administer this project.
     */
    permission?: "read" | "write" | "admin";

    project_id: number;

    username: string;
  };
  export type ProjectsCreateCardParams = {
    column_id: number;
    /**
     * The issue or pull request id you want to associate with this card. You can use the [List issues for a repository](https://developer.github.com/v3/issues/#list-issues-for-a-repository) and [List pull requests](https://developer.github.com/v3/pulls/#list-pull-requests) endpoints to find this id.
     * **Note:** Depending on whether you use the issue id or pull request id, you will need to specify `Issue` or `PullRequest` as the `content_type`.
     */
    content_id?: number;
    /**
     * **Required if you provide `content_id`**. The type of content you want to associate with this card. Use `Issue` when `content_id` is an issue id and use `PullRequest` when `content_id` is a pull request id.
     */
    content_type?: string;
    /**
     * The card's note content. Only valid for cards without another type of content, so you must omit when specifying `content_id` and `content_type`.
     */
    note?: string;
  };
  export type ProjectsCreateColumnParams = {
    /**
     * The name of the column.
     */
    name: string;

    project_id: number;
  };
  export type ProjectsCreateForAuthenticatedUserParams = {
    /**
     * The description of the project.
     */
    body?: string;
    /**
     * The name of the project.
     */
    name: string;
  };
  export type ProjectsCreateForOrgParams = {
    /**
     * The description of the project.
     */
    body?: string;
    /**
     * The name of the project.
     */
    name: string;

    org: string;
  };
  export type ProjectsCreateForRepoParams = {
    /**
     * The description of the project.
     */
    body?: string;
    /**
     * The name of the project.
     */
    name: string;

    owner: string;

    repo: string;
  };
  export type ProjectsDeleteParams = {
    project_id: number;
  };
  export type ProjectsDeleteCardParams = {
    card_id: number;
  };
  export type ProjectsDeleteColumnParams = {
    column_id: number;
  };
  export type ProjectsGetParams = {
    project_id: number;
  };
  export type ProjectsGetCardParams = {
    card_id: number;
  };
  export type ProjectsGetColumnParams = {
    column_id: number;
  };
  export type ProjectsListCardsParams = {
    /**
     * Filters the project cards that are returned by the card's state. Can be one of `all`,`archived`, or `not_archived`.
     */
    archived_state?: "all" | "archived" | "not_archived";

    column_id: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type ProjectsListCollaboratorsParams = {
    /**
     * Filters the collaborators by their affiliation. Can be one of:
     * \* `outside`: Outside collaborators of a project that are not a member of the project's organization.
     * \* `direct`: Collaborators with permissions to a project, regardless of organization membership status.
     * \* `all`: All collaborators the authenticated user can see.
     */
    affiliation?: "outside" | "direct" | "all";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    project_id: number;
  };
  export type ProjectsListColumnsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    project_id: number;
  };
  export type ProjectsListForOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
  };
  export type ProjectsListForRepoParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
    /**
     * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
  };
  export type ProjectsListForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";

    username: string;
  };
  export type ProjectsMoveCardParams = {
    card_id: number;
    /**
     * The `id` value of a column in the same project.
     */
    column_id?: number;
    /**
     * Can be one of `top`, `bottom`, or `after:<card_id>`, where `<card_id>` is the `id` value of a card in the same column, or in the new column specified by `column_id`.
     */
    position: string;
  };
  export type ProjectsMoveColumnParams = {
    column_id: number;
    /**
     * Can be one of `first`, `last`, or `after:<column_id>`, where `<column_id>` is the `id` value of a column in the same project.
     */
    position: string;
  };
  export type ProjectsRemoveCollaboratorParams = {
    project_id: number;

    username: string;
  };
  export type ProjectsReviewUserPermissionLevelParams = {
    project_id: number;

    username: string;
  };
  export type ProjectsUpdateParams = {
    /**
     * The description of the project.
     */
    body?: string;
    /**
     * The name of the project.
     */
    name?: string;
    /**
     * The permission level that determines whether all members of the project's organization can see and/or make changes to the project. Setting `organization_permission` is only available for organization projects. If an organization member belongs to a team with a higher level of access or is a collaborator with a higher level of access, their permission level is not lowered by `organization_permission`. For information on changing access for a team or collaborator, see [Add or update team project](https://developer.github.com/v3/teams/#add-or-update-team-project) or [Add user as a collaborator](https://developer.github.com/v3/projects/collaborators/#add-user-as-a-collaborator).
     *
     * **Note:** Updating a project's `organization_permission` requires `admin` access to the project.
     *
     * Can be one of:
     * \* `read` - Organization members can read, but not write to or administer this project.
     * \* `write` - Organization members can read and write, but not administer this project.
     * \* `admin` - Organization members can read, write and administer this project.
     * \* `none` - Organization members can only see this project if it is public.
     */
    organization_permission?: string;
    /**
     * Sets the visibility of a project board. Setting `private` is only available for organization and user projects. **Note:** Updating a project's visibility requires `admin` access to the project.
     *
     * Can be one of:
     * \* `false` - Anyone can see the project.
     * \* `true` - Only the user can view a project board created on a user account. Organization members with the appropriate `organization_permission` can see project boards in an organization account.
     */
    private?: boolean;

    project_id: number;
    /**
     * State of the project. Either `open` or `closed`.
     */
    state?: "open" | "closed";
  };
  export type ProjectsUpdateCardParams = {
    /**
     * Use `true` to archive a project card. Specify `false` if you need to restore a previously archived project card.
     */
    archived?: boolean;

    card_id: number;
    /**
     * The card's note content. Only valid for cards without another type of content, so this cannot be specified if the card already has a `content_id` and `content_type`.
     */
    note?: string;
  };
  export type ProjectsUpdateColumnParams = {
    column_id: number;
    /**
     * The new name of the column.
     */
    name: string;
  };
  export type PullsCheckIfMergedParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type PullsCheckIfMergedParams = {
    owner: string;

    pull_number: number;

    repo: string;
  };
  export type PullsCreateParams = {
    /**
     * The name of the branch you want the changes pulled into. This should be an existing branch on the current repository. You cannot submit a pull request to one repository that requests a merge to a base of another repository.
     */
    base: string;
    /**
     * The contents of the pull request.
     */
    body?: string;
    /**
     * Indicates whether the pull request is a draft. See "[Draft Pull Requests](https://help.github.com/en/articles/about-pull-requests#draft-pull-requests)" in the GitHub Help documentation to learn more.
     */
    draft?: boolean;
    /**
     * The name of the branch where your changes are implemented. For cross-repository pull requests in the same network, namespace `head` with a user like this: `username:branch`.
     */
    head: string;
    /**
     * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
     */
    maintainer_can_modify?: boolean;

    owner: string;

    repo: string;
    /**
     * The title of the new pull request.
     */
    title: string;
  };
  export type PullsCreateCommentParamsDeprecatedNumber = {
    /**
     * The text of the review comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
     */
    line?: number;
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
     */
    position?: number;

    repo: string;
    /**
     * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
     */
    side?: "LEFT" | "RIGHT";
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
     */
    start_line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
     */
    start_side?: "LEFT" | "RIGHT" | "side";
  };
  export type PullsCreateCommentParamsDeprecatedInReplyTo = {
    /**
     * The text of the review comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * The comment ID to reply to. **Note**: This must be the ID of a top-level comment, not a reply to that comment. Replies to replies are not supported.
     * @deprecated "in_reply_to" parameter has been deprecated and will be removed in future
     */
    in_reply_to?: number;
    /**
     * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
     */
    line?: number;

    owner: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
     */
    position?: number;

    pull_number: number;

    repo: string;
    /**
     * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
     */
    side?: "LEFT" | "RIGHT";
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
     */
    start_line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
     */
    start_side?: "LEFT" | "RIGHT" | "side";
  };
  export type PullsCreateCommentParams = {
    /**
     * The text of the review comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
     */
    line?: number;

    owner: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
     */
    position?: number;

    pull_number: number;

    repo: string;
    /**
     * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
     */
    side?: "LEFT" | "RIGHT";
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
     */
    start_line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
     */
    start_side?: "LEFT" | "RIGHT" | "side";
  };
  export type PullsCreateCommentReplyParamsDeprecatedNumber = {
    /**
     * The text of the review comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
     */
    line?: number;
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
     */
    position?: number;

    repo: string;
    /**
     * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
     */
    side?: "LEFT" | "RIGHT";
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
     */
    start_line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
     */
    start_side?: "LEFT" | "RIGHT" | "side";
  };
  export type PullsCreateCommentReplyParamsDeprecatedInReplyTo = {
    /**
     * The text of the review comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * The comment ID to reply to. **Note**: This must be the ID of a top-level comment, not a reply to that comment. Replies to replies are not supported.
     * @deprecated "in_reply_to" parameter has been deprecated and will be removed in future
     */
    in_reply_to?: number;
    /**
     * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
     */
    line?: number;

    owner: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
     */
    position?: number;

    pull_number: number;

    repo: string;
    /**
     * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
     */
    side?: "LEFT" | "RIGHT";
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
     */
    start_line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
     */
    start_side?: "LEFT" | "RIGHT" | "side";
  };
  export type PullsCreateCommentReplyParams = {
    /**
     * The text of the review comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
     */
    line?: number;

    owner: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
     */
    position?: number;

    pull_number: number;

    repo: string;
    /**
     * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
     */
    side?: "LEFT" | "RIGHT";
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
     */
    start_line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
     */
    start_side?: "LEFT" | "RIGHT" | "side";
  };
  export type PullsCreateFromIssueParams = {
    base: string;

    draft?: boolean;

    head: string;

    issue: number;

    maintainer_can_modify?: boolean;

    owner: string;

    repo: string;
  };
  export type PullsCreateReviewParamsDeprecatedNumber = {
    /**
     * **Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.
     */
    body?: string;
    /**
     * Use the following table to specify the location, destination, and contents of the draft review comment.
     */
    comments?: PullsCreateReviewParamsComments[];
    /**
     * The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.
     */
    commit_id?: string;
    /**
     * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://developer.github.com/v3/pulls/reviews/#submit-a-pull-request-review) when you are ready.
     */
    event?: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type PullsCreateReviewParams = {
    /**
     * **Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.
     */
    body?: string;
    /**
     * Use the following table to specify the location, destination, and contents of the draft review comment.
     */
    comments?: PullsCreateReviewParamsComments[];
    /**
     * The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.
     */
    commit_id?: string;
    /**
     * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://developer.github.com/v3/pulls/reviews/#submit-a-pull-request-review) when you are ready.
     */
    event?: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";

    owner: string;

    pull_number: number;

    repo: string;
  };
  export type PullsCreateReviewCommentReplyParams = {
    /**
     * The text of the review comment.
     */
    body: string;

    comment_id: number;

    owner: string;

    pull_number: number;

    repo: string;
  };
  export type PullsCreateReviewRequestParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;

    repo: string;
    /**
     * An array of user `login`s that will be requested.
     */
    reviewers?: string[];
    /**
     * An array of team `slug`s that will be requested.
     */
    team_reviewers?: string[];
  };
  export type PullsCreateReviewRequestParams = {
    owner: string;

    pull_number: number;

    repo: string;
    /**
     * An array of user `login`s that will be requested.
     */
    reviewers?: string[];
    /**
     * An array of team `slug`s that will be requested.
     */
    team_reviewers?: string[];
  };
  export type PullsDeleteCommentParams = {
    comment_id: number;

    owner: string;

    repo: string;
  };
  export type PullsDeletePendingReviewParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;

    repo: string;

    review_id: number;
  };
  export type PullsDeletePendingReviewParams = {
    owner: string;

    pull_number: number;

    repo: string;

    review_id: number;
  };
  export type PullsDeleteReviewRequestParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;

    repo: string;
    /**
     * An array of user `login`s that will be removed.
     */
    reviewers?: string[];
    /**
     * An array of team `slug`s that will be removed.
     */
    team_reviewers?: string[];
  };
  export type PullsDeleteReviewRequestParams = {
    owner: string;

    pull_number: number;

    repo: string;
    /**
     * An array of user `login`s that will be removed.
     */
    reviewers?: string[];
    /**
     * An array of team `slug`s that will be removed.
     */
    team_reviewers?: string[];
  };
  export type PullsDismissReviewParamsDeprecatedNumber = {
    /**
     * The message for the pull request review dismissal
     */
    message: string;
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;

    repo: string;

    review_id: number;
  };
  export type PullsDismissReviewParams = {
    /**
     * The message for the pull request review dismissal
     */
    message: string;

    owner: string;

    pull_number: number;

    repo: string;

    review_id: number;
  };
  export type PullsGetParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type PullsGetParams = {
    owner: string;

    pull_number: number;

    repo: string;
  };
  export type PullsGetCommentParams = {
    comment_id: number;

    owner: string;

    repo: string;
  };
  export type PullsGetCommentsForReviewParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;

    review_id: number;
  };
  export type PullsGetCommentsForReviewParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    pull_number: number;

    repo: string;

    review_id: number;
  };
  export type PullsGetReviewParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;

    repo: string;

    review_id: number;
  };
  export type PullsGetReviewParams = {
    owner: string;

    pull_number: number;

    repo: string;

    review_id: number;
  };
  export type PullsListParams = {
    /**
     * Filter pulls by base branch name. Example: `gh-pages`.
     */
    base?: string;
    /**
     * The direction of the sort. Can be either `asc` or `desc`. Default: `desc` when sort is `created` or sort is not specified, otherwise `asc`.
     */
    direction?: "asc" | "desc";
    /**
     * Filter pulls by head user or head organization and branch name in the format of `user:ref-name` or `organization:ref-name`. For example: `github:new-script-format` or `octocat:test-branch`.
     */
    head?: string;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `popularity` (comment count) or `long-running` (age, filtering by pulls updated in the last month).
     */
    sort?: "created" | "updated" | "popularity" | "long-running";
    /**
     * Either `open`, `closed`, or `all` to filter by state.
     */
    state?: "open" | "closed" | "all";
  };
  export type PullsListCommentsParamsDeprecatedNumber = {
    /**
     * Can be either `asc` or `desc`. Ignored without `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
     */
    since?: string;
    /**
     * Can be either `created` or `updated` comments.
     */
    sort?: "created" | "updated";
  };
  export type PullsListCommentsParams = {
    /**
     * Can be either `asc` or `desc`. Ignored without `sort` parameter.
     */
    direction?: "asc" | "desc";

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    pull_number: number;

    repo: string;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
     */
    since?: string;
    /**
     * Can be either `created` or `updated` comments.
     */
    sort?: "created" | "updated";
  };
  export type PullsListCommentsForRepoParams = {
    /**
     * Can be either `asc` or `desc`. Ignored without `sort` parameter.
     */
    direction?: "asc" | "desc";

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
     */
    since?: string;
    /**
     * Can be either `created` or `updated` comments.
     */
    sort?: "created" | "updated";
  };
  export type PullsListCommitsParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type PullsListCommitsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    pull_number: number;

    repo: string;
  };
  export type PullsListFilesParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type PullsListFilesParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    pull_number: number;

    repo: string;
  };
  export type PullsListReviewRequestsParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type PullsListReviewRequestsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    pull_number: number;

    repo: string;
  };
  export type PullsListReviewsParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type PullsListReviewsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    pull_number: number;

    repo: string;
  };
  export type PullsMergeParamsDeprecatedNumber = {
    /**
     * Extra detail to append to automatic commit message.
     */
    commit_message?: string;
    /**
     * Title for the automatic commit message.
     */
    commit_title?: string;
    /**
     * Merge method to use. Possible values are `merge`, `squash` or `rebase`. Default is `merge`.
     */
    merge_method?: "merge" | "squash" | "rebase";
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;

    repo: string;
    /**
     * SHA that pull request head must match to allow merge.
     */
    sha?: string;
  };
  export type PullsMergeParams = {
    /**
     * Extra detail to append to automatic commit message.
     */
    commit_message?: string;
    /**
     * Title for the automatic commit message.
     */
    commit_title?: string;
    /**
     * Merge method to use. Possible values are `merge`, `squash` or `rebase`. Default is `merge`.
     */
    merge_method?: "merge" | "squash" | "rebase";

    owner: string;

    pull_number: number;

    repo: string;
    /**
     * SHA that pull request head must match to allow merge.
     */
    sha?: string;
  };
  export type PullsSubmitReviewParamsDeprecatedNumber = {
    /**
     * The body text of the pull request review
     */
    body?: string;
    /**
     * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.
     */
    event: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;

    repo: string;

    review_id: number;
  };
  export type PullsSubmitReviewParams = {
    /**
     * The body text of the pull request review
     */
    body?: string;
    /**
     * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.
     */
    event: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";

    owner: string;

    pull_number: number;

    repo: string;

    review_id: number;
  };
  export type PullsUpdateParamsDeprecatedNumber = {
    /**
     * The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository.
     */
    base?: string;
    /**
     * The contents of the pull request.
     */
    body?: string;
    /**
     * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
     */
    maintainer_can_modify?: boolean;
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;

    repo: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the pull request.
     */
    title?: string;
  };
  export type PullsUpdateParams = {
    /**
     * The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository.
     */
    base?: string;
    /**
     * The contents of the pull request.
     */
    body?: string;
    /**
     * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
     */
    maintainer_can_modify?: boolean;

    owner: string;

    pull_number: number;

    repo: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the pull request.
     */
    title?: string;
  };
  export type PullsUpdateBranchParams = {
    /**
     * The expected SHA of the pull request's HEAD ref. This is the most recent commit on the pull request's branch. If the expected SHA does not match the pull request's HEAD, you will receive a `422 Unprocessable Entity` status. You can use the "[List commits on a repository](https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository)" endpoint to find the most recent commit SHA. Default: SHA of the pull request's current HEAD ref.
     */
    expected_head_sha?: string;

    owner: string;

    pull_number: number;

    repo: string;
  };
  export type PullsUpdateCommentParams = {
    /**
     * The text of the reply to the review comment.
     */
    body: string;

    comment_id: number;

    owner: string;

    repo: string;
  };
  export type PullsUpdateReviewParamsDeprecatedNumber = {
    /**
     * The body text of the pull request review.
     */
    body: string;
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;

    owner: string;

    repo: string;

    review_id: number;
  };
  export type PullsUpdateReviewParams = {
    /**
     * The body text of the pull request review.
     */
    body: string;

    owner: string;

    pull_number: number;

    repo: string;

    review_id: number;
  };
  export type ReactionsCreateForCommitCommentParams = {
    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the commit comment.
     */
    content:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    owner: string;

    repo: string;
  };
  export type ReactionsCreateForIssueParamsDeprecatedNumber = {
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue.
     */
    content:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;

    repo: string;
  };
  export type ReactionsCreateForIssueParams = {
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue.
     */
    content:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    issue_number: number;

    owner: string;

    repo: string;
  };
  export type ReactionsCreateForIssueCommentParams = {
    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue comment.
     */
    content:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    owner: string;

    repo: string;
  };
  export type ReactionsCreateForPullRequestReviewCommentParams = {
    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the pull request review comment.
     */
    content:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    owner: string;

    repo: string;
  };
  export type ReactionsCreateForTeamDiscussionParams = {
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
     */
    content:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    discussion_number: number;

    team_id: number;
  };
  export type ReactionsCreateForTeamDiscussionCommentParams = {
    comment_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
     */
    content:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    discussion_number: number;

    team_id: number;
  };
  export type ReactionsCreateForTeamDiscussionCommentInOrgParams = {
    comment_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
     */
    content:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    discussion_number: number;

    org: string;

    team_slug: string;
  };
  export type ReactionsCreateForTeamDiscussionCommentLegacyParams = {
    comment_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
     */
    content:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    discussion_number: number;

    team_id: number;
  };
  export type ReactionsCreateForTeamDiscussionInOrgParams = {
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
     */
    content:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    discussion_number: number;

    org: string;

    team_slug: string;
  };
  export type ReactionsCreateForTeamDiscussionLegacyParams = {
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
     */
    content:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    discussion_number: number;

    team_id: number;
  };
  export type ReactionsDeleteParams = {
    reaction_id: number;
  };
  export type ReactionsListForCommitCommentParams = {
    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a commit comment.
     */
    content?:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReactionsListForIssueParamsDeprecatedNumber = {
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue.
     */
    content?:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReactionsListForIssueParams = {
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue.
     */
    content?:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    issue_number: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReactionsListForIssueCommentParams = {
    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue comment.
     */
    content?:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReactionsListForPullRequestReviewCommentParams = {
    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a pull request review comment.
     */
    content?:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReactionsListForTeamDiscussionParams = {
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
     */
    content?:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    discussion_number: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type ReactionsListForTeamDiscussionCommentParams = {
    comment_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
     */
    content?:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    discussion_number: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type ReactionsListForTeamDiscussionCommentInOrgParams = {
    comment_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
     */
    content?:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    discussion_number: number;

    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_slug: string;
  };
  export type ReactionsListForTeamDiscussionCommentLegacyParams = {
    comment_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
     */
    content?:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    discussion_number: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type ReactionsListForTeamDiscussionInOrgParams = {
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
     */
    content?:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    discussion_number: number;

    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_slug: string;
  };
  export type ReactionsListForTeamDiscussionLegacyParams = {
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
     */
    content?:
      | "+1"
      | "-1"
      | "laugh"
      | "confused"
      | "heart"
      | "hooray"
      | "rocket"
      | "eyes";

    discussion_number: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type ReposAcceptInvitationParams = {
    invitation_id: number;
  };
  export type ReposAddCollaboratorParams = {
    owner: string;
    /**
     * The permission to grant the collaborator. **Only valid on organization-owned repositories.** Can be one of:
     * \* `pull` - can pull, but not push to or administer this repository.
     * \* `push` - can pull and push, but not administer this repository.
     * \* `admin` - can pull, push and administer this repository.
     */
    permission?: "pull" | "push" | "admin";

    repo: string;

    username: string;
  };
  export type ReposAddDeployKeyParams = {
    /**
     * The contents of the key.
     */
    key: string;

    owner: string;
    /**
     * If `true`, the key will only be able to read repository contents. Otherwise, the key will be able to read and write.
     *
     * Deploy keys with write access can perform the same actions as an organization member with admin access, or a collaborator on a personal repository. For more information, see "[Repository permission levels for an organization](https://help.github.com/articles/repository-permission-levels-for-an-organization/)" and "[Permission levels for a user account repository](https://help.github.com/articles/permission-levels-for-a-user-account-repository/)."
     */
    read_only?: boolean;

    repo: string;
    /**
     * A name for the key.
     */
    title?: string;
  };
  export type ReposAddProtectedBranchAdminEnforcementParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposAddProtectedBranchAppRestrictionsParams = {
    apps: string[];

    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposAddProtectedBranchRequiredSignaturesParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposAddProtectedBranchRequiredStatusChecksContextsParams = {
    branch: string;

    contexts: string[];

    owner: string;

    repo: string;
  };
  export type ReposAddProtectedBranchTeamRestrictionsParams = {
    branch: string;

    owner: string;

    repo: string;

    teams: string[];
  };
  export type ReposAddProtectedBranchUserRestrictionsParams = {
    branch: string;

    owner: string;

    repo: string;

    users: string[];
  };
  export type ReposCheckCollaboratorParams = {
    owner: string;

    repo: string;

    username: string;
  };
  export type ReposCheckVulnerabilityAlertsParams = {
    owner: string;

    repo: string;
  };
  export type ReposCompareCommitsParams = {
    base: string;

    head: string;

    owner: string;

    repo: string;
  };
  export type ReposCreateCommitCommentParamsDeprecatedSha = {
    /**
     * The contents of the comment.
     */
    body: string;

    owner: string;
    /**
     * Relative path of the file to comment on.
     */
    path?: string;
    /**
     * Line index in the diff to comment on.
     */
    position?: number;

    repo: string;
    /**
     * @deprecated "sha" parameter renamed to "commit_sha"
     */
    sha: string;
  };
  export type ReposCreateCommitCommentParamsDeprecatedLine = {
    /**
     * The contents of the comment.
     */
    body: string;

    commit_sha: string;
    /**
     * **Deprecated**. Use **position** parameter instead. Line number in the file to comment on.
     * @deprecated "line" parameter has been deprecated and will be removed in future
     */
    line?: number;

    owner: string;
    /**
     * Relative path of the file to comment on.
     */
    path?: string;
    /**
     * Line index in the diff to comment on.
     */
    position?: number;

    repo: string;
  };
  export type ReposCreateCommitCommentParams = {
    /**
     * The contents of the comment.
     */
    body: string;

    commit_sha: string;

    owner: string;
    /**
     * Relative path of the file to comment on.
     */
    path?: string;
    /**
     * Line index in the diff to comment on.
     */
    position?: number;

    repo: string;
  };
  export type ReposCreateDeploymentParams = {
    /**
     * Attempts to automatically merge the default branch into the requested ref, if it's behind the default branch.
     */
    auto_merge?: boolean;
    /**
     * Short description of the deployment.
     */
    description?: string;
    /**
     * Name for the target deployment environment (e.g., `production`, `staging`, `qa`).
     */
    environment?: string;

    owner: string;
    /**
     * JSON payload with extra information about the deployment.
     */
    payload?: string;
    /**
     * Specifies if the given environment is one that end-users directly interact with. Default: `true` when `environment` is `production` and `false` otherwise.
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    production_environment?: boolean;
    /**
     * The ref to deploy. This can be a branch, tag, or SHA.
     */
    ref: string;

    repo: string;
    /**
     * The [status](https://developer.github.com/v3/repos/statuses/) contexts to verify against commit status checks. If you omit this parameter, GitHub verifies all unique contexts before creating a deployment. To bypass checking entirely, pass an empty array. Defaults to all unique contexts.
     */
    required_contexts?: string[];
    /**
     * Specifies a task to execute (e.g., `deploy` or `deploy:migrations`).
     */
    task?: string;
    /**
     * Specifies if the given environment is specific to the deployment and will no longer exist at some point in the future. Default: `false`
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    transient_environment?: boolean;
  };
  export type ReposCreateDeploymentStatusParams = {
    /**
     * Adds a new `inactive` status to all prior non-transient, non-production environment deployments with the same repository and `environment` name as the created status's deployment. An `inactive` status is only added to deployments that had a `success` state. Default: `true`
     * **Note:** To add an `inactive` status to `production` environments, you must use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    auto_inactive?: boolean;

    deployment_id: number;
    /**
     * A short description of the status. The maximum description length is 140 characters.
     */
    description?: string;
    /**
     * Name for the target deployment environment, which can be changed when setting a deploy status. For example, `production`, `staging`, or `qa`. **Note:** This parameter requires you to use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
     */
    environment?: "production" | "staging" | "qa";
    /**
     * Sets the URL for accessing your environment. Default: `""`
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    environment_url?: string;
    /**
     * The full URL of the deployment's output. This parameter replaces `target_url`. We will continue to accept `target_url` to support legacy uses, but we recommend replacing `target_url` with `log_url`. Setting `log_url` will automatically set `target_url` to the same value. Default: `""`
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    log_url?: string;

    owner: string;

    repo: string;
    /**
     * The state of the status. Can be one of `error`, `failure`, `inactive`, `in_progress`, `queued` `pending`, or `success`. **Note:** To use the `inactive` state, you must provide the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. To use the `in_progress` and `queued` states, you must provide the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
     */
    state:
      | "error"
      | "failure"
      | "inactive"
      | "in_progress"
      | "queued"
      | "pending"
      | "success";
    /**
     * The target URL to associate with this status. This URL should contain output to keep the user updated while the task is running or serve as historical information for what happened in the deployment. **Note:** It's recommended to use the `log_url` parameter, which replaces `target_url`.
     */
    target_url?: string;
  };
  export type ReposCreateDispatchEventParams = {
    /**
     * JSON payload with extra information about the webhook event that your action or worklow may use.
     */
    client_payload?: ReposCreateDispatchEventParamsClientPayload;
    /**
     * **Required:** A custom webhook event name.
     */
    event_type?: string;

    owner: string;

    repo: string;
  };
  export type ReposCreateFileParams = {
    /**
     * The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.
     */
    author?: ReposCreateFileParamsAuthor;
    /**
     * The branch name. Default: the repository’s default branch (usually `master`)
     */
    branch?: string;
    /**
     * The person that committed the file. Default: the authenticated user.
     */
    committer?: ReposCreateFileParamsCommitter;
    /**
     * The new file content, using Base64 encoding.
     */
    content: string;
    /**
     * The commit message.
     */
    message: string;

    owner: string;

    path: string;

    repo: string;
    /**
     * **Required if you are updating a file**. The blob SHA of the file being replaced.
     */
    sha?: string;
  };
  export type ReposCreateForAuthenticatedUserParams = {
    /**
     * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
     */
    allow_merge_commit?: boolean;
    /**
     * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
     */
    allow_rebase_merge?: boolean;
    /**
     * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
     */
    allow_squash_merge?: boolean;
    /**
     * Pass `true` to create an initial commit with empty README.
     */
    auto_init?: boolean;
    /**
     * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
     */
    delete_branch_on_merge?: boolean;
    /**
     * A short description of the repository.
     */
    description?: string;
    /**
     * Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell".
     */
    gitignore_template?: string;
    /**
     * Either `true` to enable issues for this repository or `false` to disable them.
     */
    has_issues?: boolean;
    /**
     * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
     */
    has_projects?: boolean;
    /**
     * Either `true` to enable the wiki for this repository or `false` to disable it.
     */
    has_wiki?: boolean;
    /**
     * A URL with more information about the repository.
     */
    homepage?: string;
    /**
     * Either `true` to make this repo available as a template repository or `false` to prevent it.
     */
    is_template?: boolean;
    /**
     * Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://help.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0".
     */
    license_template?: string;
    /**
     * The name of the repository.
     */
    name: string;
    /**
     * Either `true` to create a private repository or `false` to create a public one. Creating private repositories requires a paid GitHub account.
     */
    private?: boolean;
    /**
     * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
     */
    team_id?: number;
    /**
     * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud, `visibility` can also be `internal`. For more information, see "[Creating an internal repository](https://help.github.com/github/creating-cloning-and-archiving-repositories/creating-an-internal-repository)" in the GitHub Help documentation.
     * The `visibility` parameter overrides the `private` parameter when you use both parameters with the `nebula-preview` preview header.
     */
    visibility?: "public" | "private" | "visibility" | "internal";
  };
  export type ReposCreateForkParams = {
    /**
     * Optional parameter to specify the organization name if forking into an organization.
     */
    organization?: string;

    owner: string;

    repo: string;
  };
  export type ReposCreateHookParams = {
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/repos/hooks/#create-hook-config-params).
     */
    config: ReposCreateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
     */
    events?: string[];
    /**
     * Use `web` to create a webhook. Default: `web`. This parameter only accepts the value `web`.
     */
    name?: string;

    owner: string;

    repo: string;
  };
  export type ReposCreateInOrgParams = {
    /**
     * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
     */
    allow_merge_commit?: boolean;
    /**
     * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
     */
    allow_rebase_merge?: boolean;
    /**
     * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
     */
    allow_squash_merge?: boolean;
    /**
     * Pass `true` to create an initial commit with empty README.
     */
    auto_init?: boolean;
    /**
     * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
     */
    delete_branch_on_merge?: boolean;
    /**
     * A short description of the repository.
     */
    description?: string;
    /**
     * Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell".
     */
    gitignore_template?: string;
    /**
     * Either `true` to enable issues for this repository or `false` to disable them.
     */
    has_issues?: boolean;
    /**
     * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
     */
    has_projects?: boolean;
    /**
     * Either `true` to enable the wiki for this repository or `false` to disable it.
     */
    has_wiki?: boolean;
    /**
     * A URL with more information about the repository.
     */
    homepage?: string;
    /**
     * Either `true` to make this repo available as a template repository or `false` to prevent it.
     */
    is_template?: boolean;
    /**
     * Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://help.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0".
     */
    license_template?: string;
    /**
     * The name of the repository.
     */
    name: string;

    org: string;
    /**
     * Either `true` to create a private repository or `false` to create a public one. Creating private repositories requires a paid GitHub account.
     */
    private?: boolean;
    /**
     * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
     */
    team_id?: number;
    /**
     * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud, `visibility` can also be `internal`. For more information, see "[Creating an internal repository](https://help.github.com/github/creating-cloning-and-archiving-repositories/creating-an-internal-repository)" in the GitHub Help documentation.
     * The `visibility` parameter overrides the `private` parameter when you use both parameters with the `nebula-preview` preview header.
     */
    visibility?: "public" | "private" | "visibility" | "internal";
  };
  export type ReposCreateOrUpdateFileParams = {
    /**
     * The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.
     */
    author?: ReposCreateOrUpdateFileParamsAuthor;
    /**
     * The branch name. Default: the repository’s default branch (usually `master`)
     */
    branch?: string;
    /**
     * The person that committed the file. Default: the authenticated user.
     */
    committer?: ReposCreateOrUpdateFileParamsCommitter;
    /**
     * The new file content, using Base64 encoding.
     */
    content: string;
    /**
     * The commit message.
     */
    message: string;

    owner: string;

    path: string;

    repo: string;
    /**
     * **Required if you are updating a file**. The blob SHA of the file being replaced.
     */
    sha?: string;
  };
  export type ReposCreateReleaseParams = {
    /**
     * Text describing the contents of the tag.
     */
    body?: string;
    /**
     * `true` to create a draft (unpublished) release, `false` to create a published one.
     */
    draft?: boolean;
    /**
     * The name of the release.
     */
    name?: string;

    owner: string;
    /**
     * `true` to identify the release as a prerelease. `false` to identify the release as a full release.
     */
    prerelease?: boolean;

    repo: string;
    /**
     * The name of the tag.
     */
    tag_name: string;
    /**
     * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
     */
    target_commitish?: string;
  };
  export type ReposCreateStatusParams = {
    /**
     * A string label to differentiate this status from the status of other systems.
     */
    context?: string;
    /**
     * A short description of the status.
     */
    description?: string;

    owner: string;

    repo: string;

    sha: string;
    /**
     * The state of the status. Can be one of `error`, `failure`, `pending`, or `success`.
     */
    state: "error" | "failure" | "pending" | "success";
    /**
     * The target URL to associate with this status. This URL will be linked from the GitHub UI to allow users to easily see the source of the status.
     * For example, if your continuous integration system is posting build status, you would want to provide the deep link for the build output for this specific SHA:
     * `http://ci.example.com/user/repo/build/sha`
     */
    target_url?: string;
  };
  export type ReposCreateUsingTemplateParams = {
    /**
     * A short description of the new repository.
     */
    description?: string;
    /**
     * The name of the new repository.
     */
    name: string;
    /**
     * The organization or person who will own the new repository. To create a new repository in an organization, the authenticated user must be a member of the specified organization.
     */
    owner?: string;
    /**
     * Either `true` to create a new private repository or `false` to create a new public one.
     */
    private?: boolean;

    template_owner: string;

    template_repo: string;
  };
  export type ReposDeclineInvitationParams = {
    invitation_id: number;
  };
  export type ReposDeleteParams = {
    owner: string;

    repo: string;
  };
  export type ReposDeleteCommitCommentParams = {
    comment_id: number;

    owner: string;

    repo: string;
  };
  export type ReposDeleteDownloadParams = {
    download_id: number;

    owner: string;

    repo: string;
  };
  export type ReposDeleteFileParams = {
    /**
     * object containing information about the author.
     */
    author?: ReposDeleteFileParamsAuthor;
    /**
     * The branch name. Default: the repository’s default branch (usually `master`)
     */
    branch?: string;
    /**
     * object containing information about the committer.
     */
    committer?: ReposDeleteFileParamsCommitter;
    /**
     * The commit message.
     */
    message: string;

    owner: string;

    path: string;

    repo: string;
    /**
     * The blob SHA of the file being replaced.
     */
    sha: string;
  };
  export type ReposDeleteHookParams = {
    hook_id: number;

    owner: string;

    repo: string;
  };
  export type ReposDeleteInvitationParams = {
    invitation_id: number;

    owner: string;

    repo: string;
  };
  export type ReposDeleteReleaseParams = {
    owner: string;

    release_id: number;

    repo: string;
  };
  export type ReposDeleteReleaseAssetParams = {
    asset_id: number;

    owner: string;

    repo: string;
  };
  export type ReposDisableAutomatedSecurityFixesParams = {
    owner: string;

    repo: string;
  };
  export type ReposDisablePagesSiteParams = {
    owner: string;

    repo: string;
  };
  export type ReposDisableVulnerabilityAlertsParams = {
    owner: string;

    repo: string;
  };
  export type ReposEnableAutomatedSecurityFixesParams = {
    owner: string;

    repo: string;
  };
  export type ReposEnablePagesSiteParams = {
    owner: string;

    repo: string;

    source?: ReposEnablePagesSiteParamsSource;
  };
  export type ReposEnableVulnerabilityAlertsParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetAppsWithAccessToProtectedBranchParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposGetArchiveLinkParams = {
    archive_format: string;

    owner: string;

    ref: string;

    repo: string;
  };
  export type ReposGetBranchParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposGetBranchProtectionParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposGetClonesParams = {
    owner: string;
    /**
     * Must be one of: `day`, `week`.
     */
    per?: "day" | "week";

    repo: string;
  };
  export type ReposGetCodeFrequencyStatsParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetCollaboratorPermissionLevelParams = {
    owner: string;

    repo: string;

    username: string;
  };
  export type ReposGetCombinedStatusForRefParams = {
    owner: string;

    ref: string;

    repo: string;
  };
  export type ReposGetCommitParamsDeprecatedSha = {
    owner: string;

    repo: string;
    /**
     * @deprecated "sha" parameter renamed to "ref"
     */
    sha: string;
  };
  export type ReposGetCommitParamsDeprecatedCommitSha = {
    /**
     * @deprecated "commit_sha" parameter renamed to "ref"
     */
    commit_sha: string;

    owner: string;

    repo: string;
  };
  export type ReposGetCommitParams = {
    owner: string;

    ref: string;

    repo: string;
  };
  export type ReposGetCommitActivityStatsParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetCommitCommentParams = {
    comment_id: number;

    owner: string;

    repo: string;
  };
  export type ReposGetCommitRefShaParams = {
    owner: string;

    ref: string;

    repo: string;
  };
  export type ReposGetContentsParams = {
    owner: string;

    path: string;
    /**
     * The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
     */
    ref?: string;

    repo: string;
  };
  export type ReposGetContributorsStatsParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetDeployKeyParams = {
    key_id: number;

    owner: string;

    repo: string;
  };
  export type ReposGetDeploymentParams = {
    deployment_id: number;

    owner: string;

    repo: string;
  };
  export type ReposGetDeploymentStatusParams = {
    deployment_id: number;

    owner: string;

    repo: string;

    status_id: number;
  };
  export type ReposGetDownloadParams = {
    download_id: number;

    owner: string;

    repo: string;
  };
  export type ReposGetHookParams = {
    hook_id: number;

    owner: string;

    repo: string;
  };
  export type ReposGetLatestPagesBuildParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetLatestReleaseParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetPagesParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetPagesBuildParams = {
    build_id: number;

    owner: string;

    repo: string;
  };
  export type ReposGetParticipationStatsParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetProtectedBranchAdminEnforcementParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposGetProtectedBranchPullRequestReviewEnforcementParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposGetProtectedBranchRequiredSignaturesParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposGetProtectedBranchRequiredStatusChecksParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposGetProtectedBranchRestrictionsParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposGetPunchCardStatsParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetReadmeParams = {
    owner: string;
    /**
     * The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
     */
    ref?: string;

    repo: string;
  };
  export type ReposGetReleaseParams = {
    owner: string;

    release_id: number;

    repo: string;
  };
  export type ReposGetReleaseAssetParams = {
    asset_id: number;

    owner: string;

    repo: string;
  };
  export type ReposGetReleaseByTagParams = {
    owner: string;

    repo: string;

    tag: string;
  };
  export type ReposGetTeamsWithAccessToProtectedBranchParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposGetTopPathsParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetTopReferrersParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetUsersWithAccessToProtectedBranchParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposGetViewsParams = {
    owner: string;
    /**
     * Must be one of: `day`, `week`.
     */
    per?: "day" | "week";

    repo: string;
  };
  export type ReposListParams = {
    /**
     * Comma-separated list of values. Can include:
     * \* `owner`: Repositories that are owned by the authenticated user.
     * \* `collaborator`: Repositories that the user has been added to as a collaborator.
     * \* `organization_member`: Repositories that the user has access to through being a member of an organization. This includes every repository on every team that the user is on.
     */
    affiliation?: string;
    /**
     * Can be one of `asc` or `desc`. Default: `asc` when using `full_name`, otherwise `desc`
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Can be one of `created`, `updated`, `pushed`, `full_name`.
     */
    sort?: "created" | "updated" | "pushed" | "full_name";
    /**
     * Can be one of `all`, `owner`, `public`, `private`, `member`. Default: `all`
     *
     * Will cause a `422` error if used in the same request as **visibility** or **affiliation**. Will cause a `422` error if used in the same request as **visibility** or **affiliation**.
     */
    type?: "all" | "owner" | "public" | "private" | "member";
    /**
     * Can be one of `all`, `public`, or `private`.
     */
    visibility?: "all" | "public" | "private";
  };
  export type ReposListAppsWithAccessToProtectedBranchParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposListAssetsForReleaseParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    release_id: number;

    repo: string;
  };
  export type ReposListBranchesParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Setting to `true` returns only protected branches. When set to `false`, only unprotected branches are returned. Omitting this parameter returns all branches.
     */
    protected?: boolean;

    repo: string;
  };
  export type ReposListBranchesForHeadCommitParams = {
    commit_sha: string;

    owner: string;

    repo: string;
  };
  export type ReposListCollaboratorsParams = {
    /**
     * Filter collaborators returned by their affiliation. Can be one of:
     * \* `outside`: All outside collaborators of an organization-owned repository.
     * \* `direct`: All collaborators with permissions to an organization-owned repository, regardless of organization membership status.
     * \* `all`: All collaborators the authenticated user can see.
     */
    affiliation?: "outside" | "direct" | "all";

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReposListCommentsForCommitParamsDeprecatedRef = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * @deprecated "ref" parameter renamed to "commit_sha"
     */
    ref: string;

    repo: string;
  };
  export type ReposListCommentsForCommitParams = {
    commit_sha: string;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReposListCommitCommentsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReposListCommitsParams = {
    /**
     * GitHub login or email address by which to filter by commit author.
     */
    author?: string;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Only commits containing this file path will be returned.
     */
    path?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
    /**
     * SHA or branch to start listing commits from. Default: the repository’s default branch (usually `master`).
     */
    sha?: string;
    /**
     * Only commits after this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Only commits before this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    until?: string;
  };
  export type ReposListContributorsParams = {
    /**
     * Set to `1` or `true` to include anonymous contributors in results.
     */
    anon?: string;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReposListDeployKeysParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReposListDeploymentStatusesParams = {
    deployment_id: number;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReposListDeploymentsParams = {
    /**
     * The name of the environment that was deployed to (e.g., `staging` or `production`).
     */
    environment?: string;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The name of the ref. This can be a branch, tag, or SHA.
     */
    ref?: string;

    repo: string;
    /**
     * The SHA recorded at creation time.
     */
    sha?: string;
    /**
     * The name of the task for the deployment (e.g., `deploy` or `deploy:migrations`).
     */
    task?: string;
  };
  export type ReposListDownloadsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReposListForOrgParams = {
    /**
     * Can be one of `asc` or `desc`. Default: when using `full_name`: `asc`, otherwise `desc`
     */
    direction?: "asc" | "desc";

    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Can be one of `created`, `updated`, `pushed`, `full_name`.
     */
    sort?: "created" | "updated" | "pushed" | "full_name";
    /**
     * Specifies the types of repositories you want returned. Can be one of `all`, `public`, `private`, `forks`, `sources`, `member`, `internal`. Default: `all`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud, `type` can also be `internal`.
     */
    type?:
      | "all"
      | "public"
      | "private"
      | "forks"
      | "sources"
      | "member"
      | "internal";
  };
  export type ReposListForUserParams = {
    /**
     * Can be one of `asc` or `desc`. Default: `asc` when using `full_name`, otherwise `desc`
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Can be one of `created`, `updated`, `pushed`, `full_name`.
     */
    sort?: "created" | "updated" | "pushed" | "full_name";
    /**
     * Can be one of `all`, `owner`, `member`.
     */
    type?: "all" | "owner" | "member";

    username: string;
  };
  export type ReposListForksParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
    /**
     * The sort order. Can be either `newest`, `oldest`, or `stargazers`.
     */
    sort?: "newest" | "oldest" | "stargazers";
  };
  export type ReposListHooksParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReposListInvitationsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReposListInvitationsForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type ReposListLanguagesParams = {
    owner: string;

    repo: string;
  };
  export type ReposListPagesBuildsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReposListProtectedBranchRequiredStatusChecksContextsParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposListProtectedBranchTeamRestrictionsParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposListProtectedBranchUserRestrictionsParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposListPublicParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The integer ID of the last repository that you've seen.
     */
    since?: number;
  };
  export type ReposListPullRequestsAssociatedWithCommitParams = {
    commit_sha: string;

    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReposListReleasesParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReposListStatusesForRefParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    ref: string;

    repo: string;
  };
  export type ReposListTagsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReposListTeamsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    repo: string;
  };
  export type ReposListTeamsWithAccessToProtectedBranchParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposListTopicsParams = {
    owner: string;

    repo: string;
  };
  export type ReposListUsersWithAccessToProtectedBranchParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposMergeParams = {
    /**
     * The name of the base branch that the head will be merged into.
     */
    base: string;
    /**
     * Commit message to use for the merge commit. If omitted, a default message will be used.
     */
    commit_message?: string;
    /**
     * The head to merge. This can be a branch name or a commit SHA1.
     */
    head: string;

    owner: string;

    repo: string;
  };
  export type ReposPingHookParams = {
    hook_id: number;

    owner: string;

    repo: string;
  };
  export type ReposRemoveBranchProtectionParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposRemoveCollaboratorParams = {
    owner: string;

    repo: string;

    username: string;
  };
  export type ReposRemoveDeployKeyParams = {
    key_id: number;

    owner: string;

    repo: string;
  };
  export type ReposRemoveProtectedBranchAdminEnforcementParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposRemoveProtectedBranchAppRestrictionsParams = {
    apps: string[];

    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposRemoveProtectedBranchPullRequestReviewEnforcementParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposRemoveProtectedBranchRequiredSignaturesParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposRemoveProtectedBranchRequiredStatusChecksParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposRemoveProtectedBranchRequiredStatusChecksContextsParams = {
    branch: string;

    contexts: string[];

    owner: string;

    repo: string;
  };
  export type ReposRemoveProtectedBranchRestrictionsParams = {
    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposRemoveProtectedBranchTeamRestrictionsParams = {
    branch: string;

    owner: string;

    repo: string;

    teams: string[];
  };
  export type ReposRemoveProtectedBranchUserRestrictionsParams = {
    branch: string;

    owner: string;

    repo: string;

    users: string[];
  };
  export type ReposReplaceProtectedBranchAppRestrictionsParams = {
    apps: string[];

    branch: string;

    owner: string;

    repo: string;
  };
  export type ReposReplaceProtectedBranchRequiredStatusChecksContextsParams = {
    branch: string;

    contexts: string[];

    owner: string;

    repo: string;
  };
  export type ReposReplaceProtectedBranchTeamRestrictionsParams = {
    branch: string;

    owner: string;

    repo: string;

    teams: string[];
  };
  export type ReposReplaceProtectedBranchUserRestrictionsParams = {
    branch: string;

    owner: string;

    repo: string;

    users: string[];
  };
  export type ReposReplaceTopicsParams = {
    /**
     * An array of topics to add to the repository. Pass one or more topics to _replace_ the set of existing topics. Send an empty array (`[]`) to clear all topics from the repository. **Note:** Topic `names` cannot contain uppercase letters.
     */
    names: string[];

    owner: string;

    repo: string;
  };
  export type ReposRequestPageBuildParams = {
    owner: string;

    repo: string;
  };
  export type ReposRetrieveCommunityProfileMetricsParams = {
    owner: string;

    repo: string;
  };
  export type ReposTestPushHookParams = {
    hook_id: number;

    owner: string;

    repo: string;
  };
  export type ReposTransferParams = {
    /**
     * **Required:** The username or organization name the repository will be transferred to.
     */
    new_owner?: string;

    owner: string;

    repo: string;
    /**
     * ID of the team or teams to add to the repository. Teams can only be added to organization-owned repositories.
     */
    team_ids?: number[];
  };
  export type ReposUpdateParams = {
    /**
     * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
     */
    allow_merge_commit?: boolean;
    /**
     * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
     */
    allow_rebase_merge?: boolean;
    /**
     * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
     */
    allow_squash_merge?: boolean;
    /**
     * `true` to archive this repository. **Note**: You cannot unarchive repositories through the API.
     */
    archived?: boolean;
    /**
     * Updates the default branch for this repository.
     */
    default_branch?: string;
    /**
     * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
     */
    delete_branch_on_merge?: boolean;
    /**
     * A short description of the repository.
     */
    description?: string;
    /**
     * Either `true` to enable issues for this repository or `false` to disable them.
     */
    has_issues?: boolean;
    /**
     * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
     */
    has_projects?: boolean;
    /**
     * Either `true` to enable the wiki for this repository or `false` to disable it.
     */
    has_wiki?: boolean;
    /**
     * A URL with more information about the repository.
     */
    homepage?: string;
    /**
     * Either `true` to make this repo available as a template repository or `false` to prevent it.
     */
    is_template?: boolean;
    /**
     * The name of the repository.
     */
    name?: string;

    owner: string;
    /**
     * Either `true` to make the repository private or `false` to make it public. Creating private repositories requires a paid GitHub account. Default: `false`.
     * **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private. **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private.
     */
    private?: boolean;

    repo: string;
    /**
     * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud, `visibility` can also be `internal`. The `visibility` parameter overrides the `private` parameter when you use both along with the `nebula-preview` preview header.
     */
    visibility?: "public" | "private" | "visibility" | "internal";
  };
  export type ReposUpdateBranchProtectionParams = {
    /**
     * Allows deletion of the protected branch by anyone with write access to the repository. Set to `false` to prevent deletion of the protected branch. Default: `false`. For more information, see "[Enabling force pushes to a protected branch](https://help.github.com/en/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)" in the GitHub Help documentation.
     */
    allow_deletions?: boolean;
    /**
     * Permits force pushes to the protected branch by anyone with write access to the repository. Set to `true` to allow force pushes. Set to `false` or `null` to block force pushes. Default: `false`. For more information, see "[Enabling force pushes to a protected branch](https://help.github.com/en/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)" in the GitHub Help documentation."
     */
    allow_force_pushes?: boolean | null;

    branch: string;
    /**
     * Enforce all configured restrictions for administrators. Set to `true` to enforce required status checks for repository administrators. Set to `null` to disable.
     */
    enforce_admins: boolean | null;

    owner: string;

    repo: string;
    /**
     * Enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch. Set to `true` to enforce a linear commit history. Set to `false` to disable a linear commit Git history. Your repository must allow squash merging or rebase merging before you can enable a linear commit history. Default: `false`. For more information, see "[Requiring a linear commit history](https://help.github.com/github/administering-a-repository/requiring-a-linear-commit-history)" in the GitHub Help documentation.
     */
    required_linear_history?: boolean;
    /**
     * Require at least one approving review on a pull request, before merging. Set to `null` to disable.
     */
    required_pull_request_reviews: ReposUpdateBranchProtectionParamsRequiredPullRequestReviews | null;
    /**
     * Require status checks to pass before merging. Set to `null` to disable.
     */
    required_status_checks: ReposUpdateBranchProtectionParamsRequiredStatusChecks | null;
    /**
     * Restrict who can push to the protected branch. User, app, and team `restrictions` are only available for organization-owned repositories. Set to `null` to disable.
     */
    restrictions: ReposUpdateBranchProtectionParamsRestrictions | null;
  };
  export type ReposUpdateCommitCommentParams = {
    /**
     * The contents of the comment
     */
    body: string;

    comment_id: number;

    owner: string;

    repo: string;
  };
  export type ReposUpdateFileParams = {
    /**
     * The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.
     */
    author?: ReposUpdateFileParamsAuthor;
    /**
     * The branch name. Default: the repository’s default branch (usually `master`)
     */
    branch?: string;
    /**
     * The person that committed the file. Default: the authenticated user.
     */
    committer?: ReposUpdateFileParamsCommitter;
    /**
     * The new file content, using Base64 encoding.
     */
    content: string;
    /**
     * The commit message.
     */
    message: string;

    owner: string;

    path: string;

    repo: string;
    /**
     * **Required if you are updating a file**. The blob SHA of the file being replaced.
     */
    sha?: string;
  };
  export type ReposUpdateHookParams = {
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
    /**
     * Determines a list of events to be added to the list of events that the Hook triggers for.
     */
    add_events?: string[];
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/repos/hooks/#create-hook-config-params).
     */
    config?: ReposUpdateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for. This replaces the entire array of events.
     */
    events?: string[];

    hook_id: number;

    owner: string;
    /**
     * Determines a list of events to be removed from the list of events that the Hook triggers for.
     */
    remove_events?: string[];

    repo: string;
  };
  export type ReposUpdateInformationAboutPagesSiteParams = {
    /**
     * Specify a custom domain for the repository. Sending a `null` value will remove the custom domain. For more about custom domains, see "[Using a custom domain with GitHub Pages](https://help.github.com/articles/using-a-custom-domain-with-github-pages/)."
     */
    cname?: string;

    owner: string;

    repo: string;
    /**
     * Update the source for the repository. Must include the branch name, and may optionally specify the subdirectory `/docs`. Possible values are `"gh-pages"`, `"master"`, and `"master /docs"`.
     */
    source?: '"gh-pages"' | '"master"' | '"master /docs"';
  };
  export type ReposUpdateInvitationParams = {
    invitation_id: number;

    owner: string;
    /**
     * The permissions that the associated user will have on the repository. Valid values are `read`, `write`, and `admin`.
     */
    permissions?: "read" | "write" | "admin";

    repo: string;
  };
  export type ReposUpdateProtectedBranchPullRequestReviewEnforcementParams = {
    branch: string;
    /**
     * Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.
     */
    dismiss_stale_reviews?: boolean;
    /**
     * Specify which users and teams can dismiss pull request reviews. Pass an empty `dismissal_restrictions` object to disable. User and team `dismissal_restrictions` are only available for organization-owned repositories. Omit this parameter for personal repositories.
     */
    dismissal_restrictions?: ReposUpdateProtectedBranchPullRequestReviewEnforcementParamsDismissalRestrictions;

    owner: string;

    repo: string;
    /**
     * Blocks merging pull requests until [code owners](https://help.github.com/articles/about-code-owners/) have reviewed.
     */
    require_code_owner_reviews?: boolean;
    /**
     * Specifies the number of reviewers required to approve pull requests. Use a number between 1 and 6.
     */
    required_approving_review_count?: number;
  };
  export type ReposUpdateProtectedBranchRequiredStatusChecksParams = {
    branch: string;
    /**
     * The list of status checks to require in order to merge into this branch
     */
    contexts?: string[];

    owner: string;

    repo: string;
    /**
     * Require branches to be up to date before merging.
     */
    strict?: boolean;
  };
  export type ReposUpdateReleaseParams = {
    /**
     * Text describing the contents of the tag.
     */
    body?: string;
    /**
     * `true` makes the release a draft, and `false` publishes the release.
     */
    draft?: boolean;
    /**
     * The name of the release.
     */
    name?: string;

    owner: string;
    /**
     * `true` to identify the release as a prerelease, `false` to identify the release as a full release.
     */
    prerelease?: boolean;

    release_id: number;

    repo: string;
    /**
     * The name of the tag.
     */
    tag_name?: string;
    /**
     * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
     */
    target_commitish?: string;
  };
  export type ReposUpdateReleaseAssetParams = {
    asset_id: number;
    /**
     * An alternate short description of the asset. Used in place of the filename.
     */
    label?: string;
    /**
     * The file name of the asset.
     */
    name?: string;

    owner: string;

    repo: string;
  };
  export type ReposUploadReleaseAssetParamsDeprecatedFile = {
    /**
     * @deprecated "file" parameter renamed to "data"
     */
    file: string | object;

    headers: ReposUploadReleaseAssetParamsHeaders;
    /**
     * An alternate short description of the asset. Used in place of the filename. This should be set in a URI query parameter.
     */
    label?: string;
    /**
     * The file name of the asset. This should be set in a URI query parameter.
     */
    name: string;
    /**
     * The `upload_url` key returned from creating or getting a release
     */
    url: string;
  };
  export type ReposUploadReleaseAssetParams = {
    data: string | object;

    headers: ReposUploadReleaseAssetParamsHeaders;
    /**
     * An alternate short description of the asset. Used in place of the filename. This should be set in a URI query parameter.
     */
    label?: string;
    /**
     * The file name of the asset. This should be set in a URI query parameter.
     */
    name: string;
    /**
     * The `upload_url` key returned from creating or getting a release
     */
    url: string;
  };
  export type SearchCodeParams = {
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order?: "desc" | "asc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching code](https://help.github.com/articles/searching-code/)" for a detailed list of qualifiers.
     */
    q: string;
    /**
     * Sorts the results of your query. Can only be `indexed`, which indicates how recently a file has been indexed by the GitHub search infrastructure. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
     */
    sort?: "indexed";
  };
  export type SearchCommitsParams = {
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order?: "desc" | "asc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching commits](https://help.github.com/articles/searching-commits/)" for a detailed list of qualifiers.
     */
    q: string;
    /**
     * Sorts the results of your query by `author-date` or `committer-date`. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
     */
    sort?: "author-date" | "committer-date";
  };
  export type SearchEmailLegacyParams = {
    /**
     * The email address.
     */
    email: string;
  };
  export type SearchIssuesParams = {
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order?: "desc" | "asc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching issues and pull requests](https://help.github.com/articles/searching-issues-and-pull-requests/)" for a detailed list of qualifiers.
     */
    q: string;
    /**
     * Sorts the results of your query by the number of `comments`, `reactions`, `reactions-+1`, `reactions--1`, `reactions-smile`, `reactions-thinking_face`, `reactions-heart`, `reactions-tada`, or `interactions`. You can also sort results by how recently the items were `created` or `updated`, Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
     */
    sort?:
      | "comments"
      | "reactions"
      | "reactions-+1"
      | "reactions--1"
      | "reactions-smile"
      | "reactions-thinking_face"
      | "reactions-heart"
      | "reactions-tada"
      | "interactions"
      | "created"
      | "updated";
  };
  export type SearchIssuesAndPullRequestsParams = {
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order?: "desc" | "asc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching issues and pull requests](https://help.github.com/articles/searching-issues-and-pull-requests/)" for a detailed list of qualifiers.
     */
    q: string;
    /**
     * Sorts the results of your query by the number of `comments`, `reactions`, `reactions-+1`, `reactions--1`, `reactions-smile`, `reactions-thinking_face`, `reactions-heart`, `reactions-tada`, or `interactions`. You can also sort results by how recently the items were `created` or `updated`, Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
     */
    sort?:
      | "comments"
      | "reactions"
      | "reactions-+1"
      | "reactions--1"
      | "reactions-smile"
      | "reactions-thinking_face"
      | "reactions-heart"
      | "reactions-tada"
      | "interactions"
      | "created"
      | "updated";
  };
  export type SearchIssuesLegacyParams = {
    /**
     * The search term.
     */
    keyword: string;

    owner: string;

    repository: string;
    /**
     * Indicates the state of the issues to return. Can be either `open` or `closed`.
     */
    state: "open" | "closed";
  };
  export type SearchLabelsParams = {
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order?: "desc" | "asc";
    /**
     * The search keywords. This endpoint does not accept qualifiers in the query. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query).
     */
    q: string;
    /**
     * The id of the repository.
     */
    repository_id: number;
    /**
     * Sorts the results of your query by when the label was `created` or `updated`. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
     */
    sort?: "created" | "updated";
  };
  export type SearchReposParams = {
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order?: "desc" | "asc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching for repositories](https://help.github.com/articles/searching-for-repositories/)" for a detailed list of qualifiers.
     */
    q: string;
    /**
     * Sorts the results of your query by number of `stars`, `forks`, or `help-wanted-issues` or how recently the items were `updated`. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
     */
    sort?: "stars" | "forks" | "help-wanted-issues" | "updated";
  };
  export type SearchReposLegacyParams = {
    /**
     * The search term.
     */
    keyword: string;
    /**
     * Filter results by language.
     */
    language?: string;
    /**
     * The sort field. if `sort` param is provided. Can be either `asc` or `desc`.
     */
    order?: "asc" | "desc";
    /**
     * The sort field. One of `stars`, `forks`, or `updated`. Default: results are sorted by best match.
     */
    sort?: "stars" | "forks" | "updated";
    /**
     * The page number to fetch.
     */
    start_page?: string;
  };
  export type SearchTopicsParams = {
    /**
     * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query).
     */
    q: string;
  };
  export type SearchUsersParams = {
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order?: "desc" | "asc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching users](https://help.github.com/articles/searching-users/)" for a detailed list of qualifiers.
     */
    q: string;
    /**
     * Sorts the results of your query by number of `followers` or `repositories`, or when the person `joined` GitHub. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
     */
    sort?: "followers" | "repositories" | "joined";
  };
  export type SearchUsersLegacyParams = {
    /**
     * The search term.
     */
    keyword: string;
    /**
     * The sort field. if `sort` param is provided. Can be either `asc` or `desc`.
     */
    order?: "asc" | "desc";
    /**
     * The sort field. One of `stars`, `forks`, or `updated`. Default: results are sorted by best match.
     */
    sort?: "stars" | "forks" | "updated";
    /**
     * The page number to fetch.
     */
    start_page?: string;
  };
  export type TeamsAddMemberParams = {
    team_id: number;

    username: string;
  };
  export type TeamsAddMemberLegacyParams = {
    team_id: number;

    username: string;
  };
  export type TeamsAddOrUpdateMembershipParams = {
    /**
     * The role that this user should have in the team. Can be one of:
     * \* `member` - a normal member of the team.
     * \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
     */
    role?: "member" | "maintainer";

    team_id: number;

    username: string;
  };
  export type TeamsAddOrUpdateMembershipInOrgParams = {
    org: string;
    /**
     * The role that this user should have in the team. Can be one of:
     * \* `member` - a normal member of the team.
     * \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
     */
    role?: "member" | "maintainer";

    team_slug: string;

    username: string;
  };
  export type TeamsAddOrUpdateMembershipLegacyParams = {
    /**
     * The role that this user should have in the team. Can be one of:
     * \* `member` - a normal member of the team.
     * \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
     */
    role?: "member" | "maintainer";

    team_id: number;

    username: string;
  };
  export type TeamsAddOrUpdateProjectParams = {
    /**
     * The permission to grant to the team for this project. Can be one of:
     * \* `read` - team members can read, but not write to or administer this project.
     * \* `write` - team members can read and write, but not administer this project.
     * \* `admin` - team members can read, write and administer this project.
     * Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
     */
    permission?: "read" | "write" | "admin";

    project_id: number;

    team_id: number;
  };
  export type TeamsAddOrUpdateProjectInOrgParams = {
    org: string;
    /**
     * The permission to grant to the team for this project. Can be one of:
     * \* `read` - team members can read, but not write to or administer this project.
     * \* `write` - team members can read and write, but not administer this project.
     * \* `admin` - team members can read, write and administer this project.
     * Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
     */
    permission?: "read" | "write" | "admin";

    project_id: number;

    team_slug: string;
  };
  export type TeamsAddOrUpdateProjectLegacyParams = {
    /**
     * The permission to grant to the team for this project. Can be one of:
     * \* `read` - team members can read, but not write to or administer this project.
     * \* `write` - team members can read and write, but not administer this project.
     * \* `admin` - team members can read, write and administer this project.
     * Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
     */
    permission?: "read" | "write" | "admin";

    project_id: number;

    team_id: number;
  };
  export type TeamsAddOrUpdateRepoParams = {
    owner: string;
    /**
     * The permission to grant the team on this repository. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer this repository.
     * \* `push` - team members can pull and push, but not administer this repository.
     * \* `admin` - team members can pull, push and administer this repository.
     *
     * If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
     */
    permission?: "pull" | "push" | "admin";

    repo: string;

    team_id: number;
  };
  export type TeamsAddOrUpdateRepoInOrgParams = {
    org: string;

    owner: string;
    /**
     * The permission to grant the team on this repository. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer this repository.
     * \* `push` - team members can pull and push, but not administer this repository.
     * \* `admin` - team members can pull, push and administer this repository.
     *
     * If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
     */
    permission?: "pull" | "push" | "admin";

    repo: string;

    team_slug: string;
  };
  export type TeamsAddOrUpdateRepoLegacyParams = {
    owner: string;
    /**
     * The permission to grant the team on this repository. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer this repository.
     * \* `push` - team members can pull and push, but not administer this repository.
     * \* `admin` - team members can pull, push and administer this repository.
     *
     * If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
     */
    permission?: "pull" | "push" | "admin";

    repo: string;

    team_id: number;
  };
  export type TeamsCheckManagesRepoParams = {
    owner: string;

    repo: string;

    team_id: number;
  };
  export type TeamsCheckManagesRepoInOrgParams = {
    org: string;

    owner: string;

    repo: string;

    team_slug: string;
  };
  export type TeamsCheckManagesRepoLegacyParams = {
    owner: string;

    repo: string;

    team_id: number;
  };
  export type TeamsCreateParamsDeprecatedPermission = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * List GitHub IDs for organization members who will become team maintainers.
     */
    maintainers?: string[];
    /**
     * The name of the team.
     */
    name: string;

    org: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
     * \* `push` - team members can pull and push, but not administer newly-added repositories.
     * \* `admin` - team members can pull, push and administer newly-added repositories.
     * @deprecated "permission" parameter has been deprecated and will be removed in future
     */
    permission?: string;
    /**
     * The level of privacy this team should have. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * Default: `secret`
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     * Default for child team: `closed`
     */
    privacy?: "secret" | "closed";
    /**
     * The full name (e.g., "organization-name/repository-name") of repositories to add the team to.
     */
    repo_names?: string[];
  };
  export type TeamsCreateParams = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * List GitHub IDs for organization members who will become team maintainers.
     */
    maintainers?: string[];
    /**
     * The name of the team.
     */
    name: string;

    org: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * The level of privacy this team should have. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * Default: `secret`
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     * Default for child team: `closed`
     */
    privacy?: "secret" | "closed";
    /**
     * The full name (e.g., "organization-name/repository-name") of repositories to add the team to.
     */
    repo_names?: string[];
  };
  export type TeamsCreateDiscussionParams = {
    /**
     * The discussion post's body text.
     */
    body: string;
    /**
     * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
     */
    private?: boolean;

    team_id: number;
    /**
     * The discussion post's title.
     */
    title: string;
  };
  export type TeamsCreateDiscussionCommentParams = {
    /**
     * The discussion comment's body text.
     */
    body: string;

    discussion_number: number;

    team_id: number;
  };
  export type TeamsCreateDiscussionCommentInOrgParams = {
    /**
     * The discussion comment's body text.
     */
    body: string;

    discussion_number: number;

    org: string;

    team_slug: string;
  };
  export type TeamsCreateDiscussionCommentLegacyParams = {
    /**
     * The discussion comment's body text.
     */
    body: string;

    discussion_number: number;

    team_id: number;
  };
  export type TeamsCreateDiscussionInOrgParams = {
    /**
     * The discussion post's body text.
     */
    body: string;

    org: string;
    /**
     * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
     */
    private?: boolean;

    team_slug: string;
    /**
     * The discussion post's title.
     */
    title: string;
  };
  export type TeamsCreateDiscussionLegacyParams = {
    /**
     * The discussion post's body text.
     */
    body: string;
    /**
     * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
     */
    private?: boolean;

    team_id: number;
    /**
     * The discussion post's title.
     */
    title: string;
  };
  export type TeamsDeleteParams = {
    team_id: number;
  };
  export type TeamsDeleteDiscussionParams = {
    discussion_number: number;

    team_id: number;
  };
  export type TeamsDeleteDiscussionCommentParams = {
    comment_number: number;

    discussion_number: number;

    team_id: number;
  };
  export type TeamsDeleteDiscussionCommentInOrgParams = {
    comment_number: number;

    discussion_number: number;

    org: string;

    team_slug: string;
  };
  export type TeamsDeleteDiscussionCommentLegacyParams = {
    comment_number: number;

    discussion_number: number;

    team_id: number;
  };
  export type TeamsDeleteDiscussionInOrgParams = {
    discussion_number: number;

    org: string;

    team_slug: string;
  };
  export type TeamsDeleteDiscussionLegacyParams = {
    discussion_number: number;

    team_id: number;
  };
  export type TeamsDeleteInOrgParams = {
    org: string;

    team_slug: string;
  };
  export type TeamsDeleteLegacyParams = {
    team_id: number;
  };
  export type TeamsGetParams = {
    team_id: number;
  };
  export type TeamsGetByNameParams = {
    org: string;

    team_slug: string;
  };
  export type TeamsGetDiscussionParams = {
    discussion_number: number;

    team_id: number;
  };
  export type TeamsGetDiscussionCommentParams = {
    comment_number: number;

    discussion_number: number;

    team_id: number;
  };
  export type TeamsGetDiscussionCommentInOrgParams = {
    comment_number: number;

    discussion_number: number;

    org: string;

    team_slug: string;
  };
  export type TeamsGetDiscussionCommentLegacyParams = {
    comment_number: number;

    discussion_number: number;

    team_id: number;
  };
  export type TeamsGetDiscussionInOrgParams = {
    discussion_number: number;

    org: string;

    team_slug: string;
  };
  export type TeamsGetDiscussionLegacyParams = {
    discussion_number: number;

    team_id: number;
  };
  export type TeamsGetLegacyParams = {
    team_id: number;
  };
  export type TeamsGetMemberParams = {
    team_id: number;

    username: string;
  };
  export type TeamsGetMemberLegacyParams = {
    team_id: number;

    username: string;
  };
  export type TeamsGetMembershipParams = {
    team_id: number;

    username: string;
  };
  export type TeamsGetMembershipInOrgParams = {
    org: string;

    team_slug: string;

    username: string;
  };
  export type TeamsGetMembershipLegacyParams = {
    team_id: number;

    username: string;
  };
  export type TeamsListParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type TeamsListChildParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type TeamsListChildInOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_slug: string;
  };
  export type TeamsListChildLegacyParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type TeamsListDiscussionCommentsParams = {
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";

    discussion_number: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type TeamsListDiscussionCommentsInOrgParams = {
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";

    discussion_number: number;

    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_slug: string;
  };
  export type TeamsListDiscussionCommentsLegacyParams = {
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";

    discussion_number: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type TeamsListDiscussionsParams = {
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type TeamsListDiscussionsInOrgParams = {
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";

    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_slug: string;
  };
  export type TeamsListDiscussionsLegacyParams = {
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type TeamsListForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type TeamsListMembersParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Filters members returned by their role in the team. Can be one of:
     * \* `member` - normal members of the team.
     * \* `maintainer` - team maintainers.
     * \* `all` - all members of the team.
     */
    role?: "member" | "maintainer" | "all";

    team_id: number;
  };
  export type TeamsListMembersInOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Filters members returned by their role in the team. Can be one of:
     * \* `member` - normal members of the team.
     * \* `maintainer` - team maintainers.
     * \* `all` - all members of the team.
     */
    role?: "member" | "maintainer" | "all";

    team_slug: string;
  };
  export type TeamsListMembersLegacyParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Filters members returned by their role in the team. Can be one of:
     * \* `member` - normal members of the team.
     * \* `maintainer` - team maintainers.
     * \* `all` - all members of the team.
     */
    role?: "member" | "maintainer" | "all";

    team_id: number;
  };
  export type TeamsListPendingInvitationsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type TeamsListPendingInvitationsInOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_slug: string;
  };
  export type TeamsListPendingInvitationsLegacyParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type TeamsListProjectsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type TeamsListProjectsInOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_slug: string;
  };
  export type TeamsListProjectsLegacyParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type TeamsListReposParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type TeamsListReposInOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_slug: string;
  };
  export type TeamsListReposLegacyParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    team_id: number;
  };
  export type TeamsRemoveMemberParams = {
    team_id: number;

    username: string;
  };
  export type TeamsRemoveMemberLegacyParams = {
    team_id: number;

    username: string;
  };
  export type TeamsRemoveMembershipParams = {
    team_id: number;

    username: string;
  };
  export type TeamsRemoveMembershipInOrgParams = {
    org: string;

    team_slug: string;

    username: string;
  };
  export type TeamsRemoveMembershipLegacyParams = {
    team_id: number;

    username: string;
  };
  export type TeamsRemoveProjectParams = {
    project_id: number;

    team_id: number;
  };
  export type TeamsRemoveProjectInOrgParams = {
    org: string;

    project_id: number;

    team_slug: string;
  };
  export type TeamsRemoveProjectLegacyParams = {
    project_id: number;

    team_id: number;
  };
  export type TeamsRemoveRepoParams = {
    owner: string;

    repo: string;

    team_id: number;
  };
  export type TeamsRemoveRepoInOrgParams = {
    org: string;

    owner: string;

    repo: string;

    team_slug: string;
  };
  export type TeamsRemoveRepoLegacyParams = {
    owner: string;

    repo: string;

    team_id: number;
  };
  export type TeamsReviewProjectParams = {
    project_id: number;

    team_id: number;
  };
  export type TeamsReviewProjectInOrgParams = {
    org: string;

    project_id: number;

    team_slug: string;
  };
  export type TeamsReviewProjectLegacyParams = {
    project_id: number;

    team_id: number;
  };
  export type TeamsUpdateParamsDeprecatedPermission = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The name of the team.
     */
    name: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
     * \* `push` - team members can pull and push, but not administer newly-added repositories.
     * \* `admin` - team members can pull, push and administer newly-added repositories.
     * @deprecated "permission" parameter has been deprecated and will be removed in future
     */
    permission?: string;
    /**
     * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     */
    privacy?: "secret" | "closed";

    team_id: number;
  };
  export type TeamsUpdateParams = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The name of the team.
     */
    name: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     */
    privacy?: "secret" | "closed";

    team_id: number;
  };
  export type TeamsUpdateDiscussionParams = {
    /**
     * The discussion post's body text.
     */
    body?: string;

    discussion_number: number;

    team_id: number;
    /**
     * The discussion post's title.
     */
    title?: string;
  };
  export type TeamsUpdateDiscussionCommentParams = {
    /**
     * The discussion comment's body text.
     */
    body: string;

    comment_number: number;

    discussion_number: number;

    team_id: number;
  };
  export type TeamsUpdateDiscussionCommentInOrgParams = {
    /**
     * The discussion comment's body text.
     */
    body: string;

    comment_number: number;

    discussion_number: number;

    org: string;

    team_slug: string;
  };
  export type TeamsUpdateDiscussionCommentLegacyParams = {
    /**
     * The discussion comment's body text.
     */
    body: string;

    comment_number: number;

    discussion_number: number;

    team_id: number;
  };
  export type TeamsUpdateDiscussionInOrgParams = {
    /**
     * The discussion post's body text.
     */
    body?: string;

    discussion_number: number;

    org: string;

    team_slug: string;
    /**
     * The discussion post's title.
     */
    title?: string;
  };
  export type TeamsUpdateDiscussionLegacyParams = {
    /**
     * The discussion post's body text.
     */
    body?: string;

    discussion_number: number;

    team_id: number;
    /**
     * The discussion post's title.
     */
    title?: string;
  };
  export type TeamsUpdateInOrgParamsDeprecatedPermission = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The name of the team.
     */
    name: string;

    org: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
     * \* `push` - team members can pull and push, but not administer newly-added repositories.
     * \* `admin` - team members can pull, push and administer newly-added repositories.
     * @deprecated "permission" parameter has been deprecated and will be removed in future
     */
    permission?: string;
    /**
     * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. When a team is nested, the `privacy` for parent teams cannot be `secret`. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     */
    privacy?: "secret" | "closed";

    team_slug: string;
  };
  export type TeamsUpdateInOrgParams = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The name of the team.
     */
    name: string;

    org: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. When a team is nested, the `privacy` for parent teams cannot be `secret`. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     */
    privacy?: "secret" | "closed";

    team_slug: string;
  };
  export type TeamsUpdateLegacyParamsDeprecatedPermission = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The name of the team.
     */
    name: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
     * \* `push` - team members can pull and push, but not administer newly-added repositories.
     * \* `admin` - team members can pull, push and administer newly-added repositories.
     * @deprecated "permission" parameter has been deprecated and will be removed in future
     */
    permission?: string;
    /**
     * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     */
    privacy?: "secret" | "closed";

    team_id: number;
  };
  export type TeamsUpdateLegacyParams = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The name of the team.
     */
    name: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     */
    privacy?: "secret" | "closed";

    team_id: number;
  };
  export type UsersAddEmailsParams = {
    /**
     * Adds one or more email addresses to your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.
     */
    emails: string[];
  };
  export type UsersBlockParams = {
    username: string;
  };
  export type UsersCheckBlockedParams = {
    username: string;
  };
  export type UsersCheckFollowingParams = {
    username: string;
  };
  export type UsersCheckFollowingForUserParams = {
    target_user: string;

    username: string;
  };
  export type UsersCreateGpgKeyParams = {
    /**
     * Your GPG key, generated in ASCII-armored format. See "[Generating a new GPG key](https://help.github.com/articles/generating-a-new-gpg-key/)" for help creating a GPG key.
     */
    armored_public_key?: string;
  };
  export type UsersCreatePublicKeyParams = {
    /**
     * The public SSH key to add to your GitHub account. See "[Generating a new SSH key](https://help.github.com/articles/generating-a-new-ssh-key-and-adding-it-to-the-ssh-agent/)" for guidance on how to create a public SSH key.
     */
    key?: string;
    /**
     * A descriptive name for the new key. Use a name that will help you recognize this key in your GitHub account. For example, if you're using a personal Mac, you might call this key "Personal MacBook Air".
     */
    title?: string;
  };
  export type UsersDeleteEmailsParams = {
    /**
     * Deletes one or more email addresses from your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.
     */
    emails: string[];
  };
  export type UsersDeleteGpgKeyParams = {
    gpg_key_id: number;
  };
  export type UsersDeletePublicKeyParams = {
    key_id: number;
  };
  export type UsersFollowParams = {
    username: string;
  };
  export type UsersGetByUsernameParams = {
    username: string;
  };
  export type UsersGetContextForUserParams = {
    /**
     * Uses the ID for the `subject_type` you specified. **Required** when using `subject_type`.
     */
    subject_id?: string;
    /**
     * Identifies which additional information you'd like to receive about the person's hovercard. Can be `organization`, `repository`, `issue`, `pull_request`. **Required** when using `subject_id`.
     */
    subject_type?: "organization" | "repository" | "issue" | "pull_request";

    username: string;
  };
  export type UsersGetGpgKeyParams = {
    gpg_key_id: number;
  };
  export type UsersGetPublicKeyParams = {
    key_id: number;
  };
  export type UsersListParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The integer ID of the last User that you've seen.
     */
    since?: string;
  };
  export type UsersListEmailsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type UsersListFollowersForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type UsersListFollowersForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    username: string;
  };
  export type UsersListFollowingForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type UsersListFollowingForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    username: string;
  };
  export type UsersListGpgKeysParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type UsersListGpgKeysForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    username: string;
  };
  export type UsersListPublicEmailsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type UsersListPublicKeysParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
  };
  export type UsersListPublicKeysForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;

    username: string;
  };
  export type UsersTogglePrimaryEmailVisibilityParams = {
    /**
     * Specify the _primary_ email address that needs a visibility change.
     */
    email: string;
    /**
     * Use `public` to enable an authenticated user to view the specified email address, or use `private` so this primary email address cannot be seen publicly.
     */
    visibility: string;
  };
  export type UsersUnblockParams = {
    username: string;
  };
  export type UsersUnfollowParams = {
    username: string;
  };
  export type UsersUpdateAuthenticatedParams = {
    /**
     * The new short biography of the user.
     */
    bio?: string;
    /**
     * The new blog URL of the user.
     */
    blog?: string;
    /**
     * The new company of the user.
     */
    company?: string;
    /**
     * The publicly visible email address of the user.
     */
    email?: string;
    /**
     * The new hiring availability of the user.
     */
    hireable?: boolean;
    /**
     * The new location of the user.
     */
    location?: string;
    /**
     * The new name of the user.
     */
    name?: string;
  };

  // child param types
  export type AppsCreateInstallationTokenParamsPermissions = {};
  export type ChecksCreateParamsActions = {
    description: string;
    identifier: string;
    label: string;
  };
  export type ChecksCreateParamsOutput = {
    annotations?: ChecksCreateParamsOutputAnnotations[];
    images?: ChecksCreateParamsOutputImages[];
    summary: string;
    text?: string;
    title: string;
  };
  export type ChecksCreateParamsOutputAnnotations = {
    annotation_level: "notice" | "warning" | "failure";
    end_column?: number;
    end_line: number;
    message: string;
    path: string;
    raw_details?: string;
    start_column?: number;
    start_line: number;
    title?: string;
  };
  export type ChecksCreateParamsOutputImages = {
    alt: string;
    caption?: string;
    image_url: string;
  };
  export type ChecksSetSuitesPreferencesParamsAutoTriggerChecks = {
    app_id: number;
    setting: boolean;
  };
  export type ChecksUpdateParamsActions = {
    description: string;
    identifier: string;
    label: string;
  };
  export type ChecksUpdateParamsOutput = {
    annotations?: ChecksUpdateParamsOutputAnnotations[];
    images?: ChecksUpdateParamsOutputImages[];
    summary: string;
    text?: string;
    title?: string;
  };
  export type ChecksUpdateParamsOutputAnnotations = {
    annotation_level: "notice" | "warning" | "failure";
    end_column?: number;
    end_line: number;
    message: string;
    path: string;
    raw_details?: string;
    start_column?: number;
    start_line: number;
    title?: string;
  };
  export type ChecksUpdateParamsOutputImages = {
    alt: string;
    caption?: string;
    image_url: string;
  };
  export type GistsCreateParamsFiles = {
    content?: string;
  };
  export type GistsUpdateParamsFiles = {
    content?: string;
    filename?: string;
  };
  export type GitCreateCommitParamsAuthor = {
    date?: string;
    email?: string;
    name?: string;
  };
  export type GitCreateCommitParamsCommitter = {
    date?: string;
    email?: string;
    name?: string;
  };
  export type GitCreateTagParamsTagger = {
    date?: string;
    email?: string;
    name?: string;
  };
  export type GitCreateTreeParamsTree = {
    content?: string;
    mode?: "100644" | "100755" | "040000" | "160000" | "120000";
    path?: string;
    sha?: string;
    type?: "blob" | "tree" | "commit";
  };
  export type OrgsCreateHookParamsConfig = {
    content_type?: string;
    insecure_ssl?: string;
    secret?: string;
    url: string;
  };
  export type OrgsUpdateHookParamsConfig = {
    content_type?: string;
    insecure_ssl?: string;
    secret?: string;
    url: string;
  };
  export type PullsCreateReviewParamsComments = {
    body: string;
    path: string;
    position: number;
  };
  export type ReposCreateDispatchEventParamsClientPayload = {};
  export type ReposCreateFileParamsAuthor = {
    email: string;
    name: string;
  };
  export type ReposCreateFileParamsCommitter = {
    email: string;
    name: string;
  };
  export type ReposCreateHookParamsConfig = {
    content_type?: string;
    insecure_ssl?: string;
    secret?: string;
    url: string;
  };
  export type ReposCreateOrUpdateFileParamsAuthor = {
    email: string;
    name: string;
  };
  export type ReposCreateOrUpdateFileParamsCommitter = {
    email: string;
    name: string;
  };
  export type ReposDeleteFileParamsAuthor = {
    email?: string;
    name?: string;
  };
  export type ReposDeleteFileParamsCommitter = {
    email?: string;
    name?: string;
  };
  export type ReposEnablePagesSiteParamsSource = {
    branch?: "master" | "gh-pages";
    path?: string;
  };
  export type ReposUpdateBranchProtectionParamsRequiredPullRequestReviews = {
    dismiss_stale_reviews?: boolean;
    dismissal_restrictions?: ReposUpdateBranchProtectionParamsRequiredPullRequestReviewsDismissalRestrictions;
    require_code_owner_reviews?: boolean;
    required_approving_review_count?: number;
  };
  export type ReposUpdateBranchProtectionParamsRequiredPullRequestReviewsDismissalRestrictions = {
    teams?: string[];
    users?: string[];
  };
  export type ReposUpdateBranchProtectionParamsRequiredStatusChecks = {
    contexts: string[];
    strict: boolean;
  };
  export type ReposUpdateBranchProtectionParamsRestrictions = {
    apps?: string[];
    teams: string[];
    users: string[];
  };
  export type ReposUpdateFileParamsAuthor = {
    email: string;
    name: string;
  };
  export type ReposUpdateFileParamsCommitter = {
    email: string;
    name: string;
  };
  export type ReposUpdateHookParamsConfig = {
    content_type?: string;
    insecure_ssl?: string;
    secret?: string;
    url: string;
  };
  export type ReposUpdateProtectedBranchPullRequestReviewEnforcementParamsDismissalRestrictions = {
    teams?: string[];
    users?: string[];
  };
  export type ReposUploadReleaseAssetParamsHeaders = {
    "content-length": number;
    "content-type": string;
  };
}

export class Octokit {
  constructor(options?: Octokit.Options);
  authenticate(auth: Octokit.AuthBasic): void;
  authenticate(auth: Octokit.AuthOAuthToken): void;
  authenticate(auth: Octokit.AuthOAuthSecret): void;
  authenticate(auth: Octokit.AuthUserToken): void;
  authenticate(auth: Octokit.AuthJWT): void;

  hook: {
    before(
      name: string,
      callback: (options: Octokit.HookOptions) => void
    ): void;
    after(
      name: string,
      callback: (
        response: Octokit.Response<any>,
        options: Octokit.HookOptions
      ) => void
    ): void;
    error(
      name: string,
      callback: (error: Octokit.HookError, options: Octokit.HookOptions) => void
    ): void;
    wrap(
      name: string,
      callback: (
        request: (
          options: Octokit.HookOptions
        ) => Promise<Octokit.Response<any>>,
        options: Octokit.HookOptions
      ) => Promise<Octokit.Response<any>>
    ): void;
  };

  static plugin(plugin: Octokit.Plugin | Octokit.Plugin[]): Octokit.Static;

  registerEndpoints(endpoints: {
    [scope: string]: Octokit.EndpointOptions;
  }): void;

  request: Octokit.Request;

  paginate: Octokit.Paginate;

  log: Octokit.Log;

  actions: {
    /**
     * Cancels a workflow run using its `id`. Anyone with write access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
     */
    cancelWorkflowRun: {
      (
        params?: Octokit.RequestOptions & Octokit.ActionsCancelWorkflowRunParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Creates or updates a secret with an encrypted value. Encrypt your secret using [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). Anyone with write access to the repository can use this endpoint. GitHub Apps must have the `secrets` permission to use this endpoint.
     *
     * Encrypt your secret using the [tweetsodium](https://github.com/mastahyeti/tweetsodium) library.
     *
     *
     *
     * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/stable/public/#nacl-public-sealedbox) with Python 3.
     *
     *
     *
     * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
     *
     *
     *
     * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
     */
    createOrUpdateSecretForRepo: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActionsCreateOrUpdateSecretForRepoParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Returns a token that you can pass to the `config` script. The token expires after one hour. Anyone with admin access to the repository can use this endpoint. GitHub Apps must have the `administration` permission to use this endpoint.
     *
     * Configure your self-hosted runner, replacing TOKEN with the registration token provided by this endpoint.
     */
    createRegistrationToken: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActionsCreateRegistrationTokenParams
      ): Promise<
        Octokit.Response<Octokit.ActionsCreateRegistrationTokenResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Returns a token that you can pass to remove a self-hosted runner from a repository. The token expires after one hour. Anyone with admin access to the repository can use this endpoint. GitHub Apps must have the `administration` permission to use this endpoint.
     *
     * Remove your self-hosted runner from a repository, replacing TOKEN with the remove token provided by this endpoint.
     */
    createRemoveToken: {
      (
        params?: Octokit.RequestOptions & Octokit.ActionsCreateRemoveTokenParams
      ): Promise<Octokit.Response<Octokit.ActionsCreateRemoveTokenResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Deletes an artifact for a workflow run. Anyone with write access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
     */
    deleteArtifact: {
      (
        params?: Octokit.RequestOptions & Octokit.ActionsDeleteArtifactParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Deletes a secret in a repository using the secret name. Anyone with write access to the repository can use this endpoint. GitHub Apps must have the `secrets` permission to use this endpoint.
     */
    deleteSecretFromRepo: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActionsDeleteSecretFromRepoParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Gets a redirect URL to download an archive for a repository. This URL expires after 1 minute. Look for `Location:` in the response header to find the URL for the download. The `:archive_format` must be `zip`. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
     *
     * Call this endpoint using the `-v` flag, which enables verbose output and allows you to see the download URL in the header. To download the file into the current working directory, specify the filename using the `-o` flag.
     */
    downloadArtifact: {
      (
        params?: Octokit.RequestOptions & Octokit.ActionsDownloadArtifactParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Gets a specific artifact for a workflow run. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
     */
    getArtifact: {
      (
        params?: Octokit.RequestOptions & Octokit.ActionsGetArtifactParams
      ): Promise<Octokit.Response<Octokit.ActionsGetArtifactResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Gets your public key, which you must store. You need your public key to use other secrets endpoints. Use the returned `key` to encrypt your secrets. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `secrets` permission to use this endpoint.
     */
    getPublicKey: {
      (
        params?: Octokit.RequestOptions & Octokit.ActionsGetPublicKeyParams
      ): Promise<Octokit.Response<Octokit.ActionsGetPublicKeyResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Gets a single secret without revealing its encrypted value. Anyone with write access to the repository can use this endpoint. GitHub Apps must have the `secrets` permission to use this endpoint.
     */
    getSecret: {
      (
        params?: Octokit.RequestOptions & Octokit.ActionsGetSecretParams
      ): Promise<Octokit.Response<Octokit.ActionsGetSecretResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Gets a specific self-hosted runner. Anyone with admin access to the repository can use this endpoint. GitHub Apps must have the `administration` permission to use this endpoint.
     */
    getSelfHostedRunner: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActionsGetSelfHostedRunnerParams
      ): Promise<Octokit.Response<Octokit.ActionsGetSelfHostedRunnerResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Gets a specific workflow. You can also replace `:workflow_id` with `:workflow_file_name`. For example, you could use `main.yml`. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
     */
    getWorkflow: {
      (
        params?: Octokit.RequestOptions & Octokit.ActionsGetWorkflowParams
      ): Promise<Octokit.Response<Octokit.ActionsGetWorkflowResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Gets a specific job in a workflow run. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
     */
    getWorkflowJob: {
      (
        params?: Octokit.RequestOptions & Octokit.ActionsGetWorkflowJobParams
      ): Promise<Octokit.Response<Octokit.ActionsGetWorkflowJobResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Gets a specific workflow run. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
     */
    getWorkflowRun: {
      (
        params?: Octokit.RequestOptions & Octokit.ActionsGetWorkflowRunParams
      ): Promise<Octokit.Response<Octokit.ActionsGetWorkflowRunResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Lists binaries for the self-hosted runner application that you can download and run. Anyone with admin access to the repository can use this endpoint. GitHub Apps must have the `administration` permission to use this endpoint.
     */
    listDownloadsForSelfHostedRunnerApplication: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActionsListDownloadsForSelfHostedRunnerApplicationParams
      ): Promise<
        Octokit.Response<
          Octokit.ActionsListDownloadsForSelfHostedRunnerApplicationResponse
        >
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Lists jobs for a workflow run. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
     */
    listJobsForWorkflowRun: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActionsListJobsForWorkflowRunParams
      ): Promise<
        Octokit.Response<Octokit.ActionsListJobsForWorkflowRunResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Lists all workflow runs for a repository. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://developer.github.com/v3/#parameters).
     *
     * Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
     */
    listRepoWorkflowRuns: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActionsListRepoWorkflowRunsParams
      ): Promise<Octokit.Response<Octokit.ActionsListRepoWorkflowRunsResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Lists the workflows in a repository. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
     */
    listRepoWorkflows: {
      (
        params?: Octokit.RequestOptions & Octokit.ActionsListRepoWorkflowsParams
      ): Promise<Octokit.Response<Octokit.ActionsListRepoWorkflowsResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Lists all secrets available in a repository without revealing their encrypted values. Anyone with write access to the repository can use this endpoint. GitHub Apps must have the `secrets` permission to use this endpoint.
     */
    listSecretsForRepo: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActionsListSecretsForRepoParams
      ): Promise<Octokit.Response<Octokit.ActionsListSecretsForRepoResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Lists all self-hosted runners for a repository. Anyone with admin access to the repository can use this endpoint. GitHub Apps must have the `administration` permission to use this endpoint.
     */
    listSelfHostedRunnersForRepo: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActionsListSelfHostedRunnersForRepoParams
      ): Promise<
        Octokit.Response<Octokit.ActionsListSelfHostedRunnersForRepoResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Gets a redirect URL to download a plain text file of logs for a workflow job. This link expires after 1 minute. Look for `Location:` in the response header to find the URL for the download. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
     *
     * Call this endpoint using the `-v` flag, which enables verbose output and allows you to see the download URL in the header. To download the file into the current working directory, specify the filename using the `-o` flag.
     */
    listWorkflowJobLogs: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActionsListWorkflowJobLogsParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Lists artifacts for a workflow run. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
     */
    listWorkflowRunArtifacts: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActionsListWorkflowRunArtifactsParams
      ): Promise<
        Octokit.Response<Octokit.ActionsListWorkflowRunArtifactsResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Gets a redirect URL to download an archive of log files for a workflow run. This link expires after 1 minute. Look for `Location:` in the response header to find the URL for the download. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
     *
     * Call this endpoint using the `-v` flag, which enables verbose output and allows you to see the download URL in the header. To download the file into the current working directory, specify the filename using the `-o` flag.
     */
    listWorkflowRunLogs: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActionsListWorkflowRunLogsParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * List all workflow runs for a workflow. You can also replace `:workflow_id` with `:workflow_file_name`. For example, you could use `main.yml`. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://developer.github.com/v3/#parameters).
     *
     * Anyone with read access to the repository can use this endpoint.
     */
    listWorkflowRuns: {
      (
        params?: Octokit.RequestOptions & Octokit.ActionsListWorkflowRunsParams
      ): Promise<Octokit.Response<Octokit.ActionsListWorkflowRunsResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Re-runs your workflow run using its `id`. Anyone with write access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
     */
    reRunWorkflow: {
      (
        params?: Octokit.RequestOptions & Octokit.ActionsReRunWorkflowParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Forces the removal of a self-hosted runner from a repository. You can use this endpoint to completely remove the runner when the machine you were using no longer exists. Anyone with admin access to the repository can use this endpoint. GitHub Apps must have the `administration` permission to use this endpoint.
     */
    removeSelfHostedRunner: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActionsRemoveSelfHostedRunnerParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
  };
  activity: {
    /**
     * Requires for the user to be authenticated.
     */
    checkStarringRepo: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityCheckStarringRepoParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Requires for the user to be authenticated.
     */
    checkWatchingRepoLegacy: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityCheckWatchingRepoLegacyParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * This endpoint should only be used to stop watching a repository. To control whether or not you wish to receive notifications from a repository, [set the repository's subscription manually](https://developer.github.com/v3/activity/watching/#set-a-repository-subscription).
     */
    deleteRepoSubscription: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityDeleteRepoSubscriptionParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Mutes all future notifications for a conversation until you comment on the thread or get **@mention**ed.
     */
    deleteThreadSubscription: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityDeleteThreadSubscriptionParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };

    getRepoSubscription: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityGetRepoSubscriptionParams
      ): Promise<Octokit.Response<Octokit.ActivityGetRepoSubscriptionResponse>>;

      endpoint: Octokit.Endpoint;
    };

    getThread: {
      (
        params?: Octokit.RequestOptions & Octokit.ActivityGetThreadParams
      ): Promise<Octokit.Response<Octokit.ActivityGetThreadResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://developer.github.com/v3/activity/watching/#get-a-repository-subscription).
     *
     * Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.
     */
    getThreadSubscription: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityGetThreadSubscriptionParams
      ): Promise<
        Octokit.Response<Octokit.ActivityGetThreadSubscriptionResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * This is the user's organization dashboard. You must be authenticated as the user to view this.
     */
    listEventsForOrg: {
      (
        params?: Octokit.RequestOptions & Octokit.ActivityListEventsForOrgParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * If you are authenticated as the given user, you will see your private events. Otherwise, you'll only see public events.
     */
    listEventsForUser: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityListEventsForUserParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * GitHub provides several timeline resources in [Atom](http://en.wikipedia.org/wiki/Atom_(standard)) format. The Feeds API lists all the feeds available to the authenticated user:
     *
     * *   **Timeline**: The GitHub global public timeline
     * *   **User**: The public timeline for any user, using [URI template](https://developer.github.com/v3/#hypermedia)
     * *   **Current user public**: The public timeline for the authenticated user
     * *   **Current user**: The private timeline for the authenticated user
     * *   **Current user actor**: The private timeline for activity created by the authenticated user
     * *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
     * *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub.
     *
     * **Note**: Private feeds are only returned when [authenticating via Basic Auth](https://developer.github.com/v3/#basic-authentication) since current feed URIs use the older, non revocable auth tokens.
     */
    listFeeds: {
      (params?: Octokit.RequestOptions & Octokit.EmptyParams): Promise<
        Octokit.Response<Octokit.ActivityListFeedsResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * List all notifications for the current user, sorted by most recently updated.
     *
     * The following example uses the `since` parameter to list notifications that have been updated after the specified time.
     */
    listNotifications: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityListNotificationsParams
      ): Promise<Octokit.Response<Octokit.ActivityListNotificationsResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * List all notifications for the current user.
     */
    listNotificationsForRepo: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityListNotificationsForRepoParams
      ): Promise<
        Octokit.Response<Octokit.ActivityListNotificationsForRepoResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * We delay the public events feed by five minutes, which means the most recent event returned by the public events API actually occurred at least five minutes ago.
     */
    listPublicEvents: {
      (
        params?: Octokit.RequestOptions & Octokit.ActivityListPublicEventsParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };

    listPublicEventsForOrg: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityListPublicEventsForOrgParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };

    listPublicEventsForRepoNetwork: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityListPublicEventsForRepoNetworkParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };

    listPublicEventsForUser: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityListPublicEventsForUserParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * These are events that you've received by watching repos and following users. If you are authenticated as the given user, you will see private events. Otherwise, you'll only see public events.
     */
    listReceivedEventsForUser: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityListReceivedEventsForUserParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };

    listReceivedPublicEventsForUser: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityListReceivedPublicEventsForUserParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };

    listRepoEvents: {
      (
        params?: Octokit.RequestOptions & Octokit.ActivityListRepoEventsParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * You can also find out _when_ stars were created by passing the following custom [media type](https://developer.github.com/v3/media/) via the `Accept` header:
     */
    listReposStarredByAuthenticatedUser: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityListReposStarredByAuthenticatedUserParams
      ): Promise<
        Octokit.Response<
          Octokit.ActivityListReposStarredByAuthenticatedUserResponse
        >
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * You can also find out _when_ stars were created by passing the following custom [media type](https://developer.github.com/v3/media/) via the `Accept` header:
     */
    listReposStarredByUser: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityListReposStarredByUserParams
      ): Promise<
        Octokit.Response<Octokit.ActivityListReposStarredByUserResponse>
      >;

      endpoint: Octokit.Endpoint;
    };

    listReposWatchedByUser: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityListReposWatchedByUserParams
      ): Promise<
        Octokit.Response<Octokit.ActivityListReposWatchedByUserResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * You can also find out _when_ stars were created by passing the following custom [media type](https://developer.github.com/v3/media/) via the `Accept` header:
     */
    listStargazersForRepo: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityListStargazersForRepoParams
      ): Promise<
        Octokit.Response<Octokit.ActivityListStargazersForRepoResponse>
      >;

      endpoint: Octokit.Endpoint;
    };

    listWatchedReposForAuthenticatedUser: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityListWatchedReposForAuthenticatedUserParams
      ): Promise<
        Octokit.Response<
          Octokit.ActivityListWatchedReposForAuthenticatedUserResponse
        >
      >;

      endpoint: Octokit.Endpoint;
    };

    listWatchersForRepo: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityListWatchersForRepoParams
      ): Promise<Octokit.Response<Octokit.ActivityListWatchersForRepoResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Marks a notification as "read" removes it from the [default view on GitHub](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List your notifications](https://developer.github.com/v3/activity/notifications/#list-your-notifications) endpoint and pass the query parameter `all=false`.
     */
    markAsRead: {
      (
        params?: Octokit.RequestOptions & Octokit.ActivityMarkAsReadParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Marks all notifications in a repository as "read" removes them from the [default view on GitHub](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List your notifications in a repository](https://developer.github.com/v3/activity/notifications/#list-your-notifications-in-a-repository) endpoint and pass the query parameter `all=false`.
     */
    markNotificationsAsReadForRepo: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityMarkNotificationsAsReadForRepoParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };

    markThreadAsRead: {
      (
        params?: Octokit.RequestOptions & Octokit.ActivityMarkThreadAsReadParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * If you would like to watch a repository, set `subscribed` to `true`. If you would like to ignore notifications made within a repository, set `ignored` to `true`. If you would like to stop watching a repository, [delete the repository's subscription](https://developer.github.com/v3/activity/watching/#delete-a-repository-subscription) completely.
     */
    setRepoSubscription: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivitySetRepoSubscriptionParams
      ): Promise<Octokit.Response<Octokit.ActivitySetRepoSubscriptionResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * This lets you subscribe or unsubscribe from a conversation.
     */
    setThreadSubscription: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivitySetThreadSubscriptionParams
      ): Promise<
        Octokit.Response<Octokit.ActivitySetThreadSubscriptionResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Requires for the user to be authenticated.
     *
     * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
     */
    starRepo: {
      (
        params?: Octokit.RequestOptions & Octokit.ActivityStarRepoParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Requires for the user to be authenticated.
     */
    stopWatchingRepoLegacy: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ActivityStopWatchingRepoLegacyParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Requires for the user to be authenticated.
     */
    unstarRepo: {
      (
        params?: Octokit.RequestOptions & Octokit.ActivityUnstarRepoParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Requires the user to be authenticated.
     *
     * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
     */
    watchRepoLegacy: {
      (
        params?: Octokit.RequestOptions & Octokit.ActivityWatchRepoLegacyParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
  };
  apps: {
    /**
     * Add a single repository to an installation. The authenticated user must have admin access to the repository.
     *
     * You must use a personal access token (which you can create via the [command line](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or the [OAuth Authorizations API](https://developer.github.com/v3/oauth_authorizations/#create-a-new-authorization)) or [Basic Authentication](https://developer.github.com/v3/auth/#basic-authentication) to access this endpoint.
     */
    addRepoToInstallation: {
      (
        params?: Octokit.RequestOptions &
          Octokit.AppsAddRepoToInstallationParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
     *
     * GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    checkAccountIsAssociatedWithAny: {
      (
        params?: Octokit.RequestOptions &
          Octokit.AppsCheckAccountIsAssociatedWithAnyParams
      ): Promise<
        Octokit.Response<Octokit.AppsCheckAccountIsAssociatedWithAnyResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
     *
     * GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    checkAccountIsAssociatedWithAnyStubbed: {
      (
        params?: Octokit.RequestOptions &
          Octokit.AppsCheckAccountIsAssociatedWithAnyStubbedParams
      ): Promise<
        Octokit.Response<
          Octokit.AppsCheckAccountIsAssociatedWithAnyStubbedResponse
        >
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * **Deprecation Notice:** GitHub will replace and discontinue OAuth endpoints containing `access_token` in the path parameter. We are introducing new endpoints that allow you to securely manage tokens for OAuth Apps by using `access_token` as an input parameter. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
     *
     * OAuth applications can use a special API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
     * @deprecated octokit.apps.checkAuthorization() is deprecated, see https://developer.github.com/v3/apps/oauth_applications/#check-an-authorization
     */
    checkAuthorization: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsCheckAuthorizationParams
      ): Promise<Octokit.Response<Octokit.AppsCheckAuthorizationResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * OAuth applications can use a special API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) to use this endpoint, where the username is the OAuth application `client_id` and the password is its `client_secret`. Invalid tokens will return `404 NOT FOUND`.
     */
    checkToken: {
      (params?: Octokit.RequestOptions & Octokit.AppsCheckTokenParams): Promise<
        Octokit.Response<Octokit.AppsCheckTokenResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Creates an attachment under a content reference URL in the body or comment of an issue or pull request. Use the `id` of the content reference from the [`content_reference` event](https://developer.github.com/v3/activity/events/types/#contentreferenceevent) to create an attachment.
     *
     * The app must create a content attachment within six hours of the content reference URL being posted. See "[Using content attachments](https://developer.github.com/apps/using-content-attachments/)" for details about content attachments.
     *
     * You must use an [installation access token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
     *
     * This example creates a content attachment for the domain `https://errors.ai/`.
     */
    createContentAttachment: {
      (
        params?: Octokit.RequestOptions &
          Octokit.AppsCreateContentAttachmentParams
      ): Promise<Octokit.Response<Octokit.AppsCreateContentAttachmentResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Use this endpoint to complete the handshake necessary when implementing the [GitHub App Manifest flow](https://developer.github.com/apps/building-github-apps/creating-github-apps-from-a-manifest/). When you create a GitHub App with the manifest flow, you receive a temporary `code` used to retrieve the GitHub App's `id`, `pem` (private key), and `webhook_secret`.
     */
    createFromManifest: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsCreateFromManifestParams
      ): Promise<Octokit.Response<Octokit.AppsCreateFromManifestResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Creates an installation access token that enables a GitHub App to make authenticated API requests for the app's installation on an organization or individual account. Installation tokens expire one hour from the time you create them. Using an expired token produces a status code of `401 - Unauthorized`, and requires creating a new installation token. By default the installation token has access to all repositories that the installation can access. To restrict the access to specific repositories, you can provide the `repository_ids` when creating the token. When you omit `repository_ids`, the response does not contain the `repositories` key.
     *
     * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     *
     * This example grants the token "Read and write" permission to `issues` and "Read" permission to `contents`, and restricts the token's access to the repository with an `id` of 1296269.
     */
    createInstallationToken: {
      (
        params?: Octokit.RequestOptions &
          Octokit.AppsCreateInstallationTokenParams
      ): Promise<Octokit.Response<Octokit.AppsCreateInstallationTokenResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid OAuth `access_token` as an input parameter and the grant for the token's owner will be deleted.
     *
     * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
     */
    deleteAuthorization: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsDeleteAuthorizationParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Uninstalls a GitHub App on a user, organization, or business account.
     *
     * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    deleteInstallation: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsDeleteInstallationParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password.
     */
    deleteToken: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsDeleteTokenParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Enables an authenticated GitHub App to find the organization's installation information.
     *
     * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     * @deprecated octokit.apps.findOrgInstallation() has been renamed to octokit.apps.getOrgInstallation() (2019-04-10)
     */
    findOrgInstallation: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsFindOrgInstallationParams
      ): Promise<Octokit.Response<Octokit.AppsFindOrgInstallationResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Enables an authenticated GitHub App to find the repository's installation information. The installation's account type will be either an organization or a user account, depending which account the repository belongs to.
     *
     * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     * @deprecated octokit.apps.findRepoInstallation() has been renamed to octokit.apps.getRepoInstallation() (2019-04-10)
     */
    findRepoInstallation: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsFindRepoInstallationParams
      ): Promise<Octokit.Response<Octokit.AppsFindRepoInstallationResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Enables an authenticated GitHub App to find the user’s installation information.
     *
     * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     * @deprecated octokit.apps.findUserInstallation() has been renamed to octokit.apps.getUserInstallation() (2019-04-10)
     */
    findUserInstallation: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsFindUserInstallationParams
      ): Promise<Octokit.Response<Octokit.AppsFindUserInstallationResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Returns the GitHub App associated with the authentication credentials used. To see how many app installations are associated with this GitHub App, see the `installations_count` in the response. For more details about your app's installations, see the "[List installations](https://developer.github.com/v3/apps/#list-installations)" endpoint.
     *
     * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    getAuthenticated: {
      (params?: Octokit.RequestOptions & Octokit.EmptyParams): Promise<
        Octokit.Response<Octokit.AppsGetAuthenticatedResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * **Note**: The `:app_slug` is just the URL-friendly name of your GitHub App. You can find this on the settings page for your GitHub App (e.g., `https://github.com/settings/apps/:app_slug`).
     *
     * If the GitHub App you specify is public, you can access this endpoint without authenticating. If the GitHub App you specify is private, you must authenticate with a [personal access token](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or an [installation access token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
     */
    getBySlug: {
      (params?: Octokit.RequestOptions & Octokit.AppsGetBySlugParams): Promise<
        Octokit.Response<Octokit.AppsGetBySlugResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    getInstallation: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsGetInstallationParams
      ): Promise<Octokit.Response<Octokit.AppsGetInstallationResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Enables an authenticated GitHub App to find the organization's installation information.
     *
     * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    getOrgInstallation: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsGetOrgInstallationParams
      ): Promise<Octokit.Response<Octokit.AppsGetOrgInstallationResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Enables an authenticated GitHub App to find the repository's installation information. The installation's account type will be either an organization or a user account, depending which account the repository belongs to.
     *
     * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    getRepoInstallation: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsGetRepoInstallationParams
      ): Promise<Octokit.Response<Octokit.AppsGetRepoInstallationResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Enables an authenticated GitHub App to find the user’s installation information.
     *
     * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    getUserInstallation: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsGetUserInstallationParams
      ): Promise<Octokit.Response<Octokit.AppsGetUserInstallationResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Returns any accounts associated with a plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
     *
     * GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    listAccountsUserOrOrgOnPlan: {
      (
        params?: Octokit.RequestOptions &
          Octokit.AppsListAccountsUserOrOrgOnPlanParams
      ): Promise<
        Octokit.Response<Octokit.AppsListAccountsUserOrOrgOnPlanResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Returns any accounts associated with a plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
     *
     * GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    listAccountsUserOrOrgOnPlanStubbed: {
      (
        params?: Octokit.RequestOptions &
          Octokit.AppsListAccountsUserOrOrgOnPlanStubbedParams
      ): Promise<
        Octokit.Response<Octokit.AppsListAccountsUserOrOrgOnPlanStubbedResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * List repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access for an installation.
     *
     * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
     *
     * You must use a [user-to-server OAuth access token](https://developer.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.
     *
     * The access the user has to each repository is included in the hash under the `permissions` key.
     */
    listInstallationReposForAuthenticatedUser: {
      (
        params?: Octokit.RequestOptions &
          Octokit.AppsListInstallationReposForAuthenticatedUserParams
      ): Promise<
        Octokit.Response<
          Octokit.AppsListInstallationReposForAuthenticatedUserResponse
        >
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     *
     * The permissions the installation has are included under the `permissions` key.
     */
    listInstallations: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsListInstallationsParams
      ): Promise<Octokit.Response<Octokit.AppsListInstallationsResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Lists installations of your GitHub App that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
     *
     * You must use a [user-to-server OAuth access token](https://developer.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.
     *
     * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
     *
     * You can find the permissions for the installation under the `permissions` key.
     */
    listInstallationsForAuthenticatedUser: {
      (
        params?: Octokit.RequestOptions &
          Octokit.AppsListInstallationsForAuthenticatedUserParams
      ): Promise<
        Octokit.Response<
          Octokit.AppsListInstallationsForAuthenticatedUserResponse
        >
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Returns only active subscriptions. You must use a [user-to-server OAuth access token](https://developer.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint. . OAuth Apps must authenticate using an [OAuth token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/).
     */
    listMarketplacePurchasesForAuthenticatedUser: {
      (
        params?: Octokit.RequestOptions &
          Octokit.AppsListMarketplacePurchasesForAuthenticatedUserParams
      ): Promise<
        Octokit.Response<
          Octokit.AppsListMarketplacePurchasesForAuthenticatedUserResponse
        >
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Returns only active subscriptions. You must use a [user-to-server OAuth access token](https://developer.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint. . OAuth Apps must authenticate using an [OAuth token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/).
     */
    listMarketplacePurchasesForAuthenticatedUserStubbed: {
      (
        params?: Octokit.RequestOptions &
          Octokit.AppsListMarketplacePurchasesForAuthenticatedUserStubbedParams
      ): Promise<
        Octokit.Response<
          Octokit.AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponse
        >
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    listPlans: {
      (params?: Octokit.RequestOptions & Octokit.AppsListPlansParams): Promise<
        Octokit.Response<Octokit.AppsListPlansResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    listPlansStubbed: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsListPlansStubbedParams
      ): Promise<Octokit.Response<Octokit.AppsListPlansStubbedResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * List repositories that an installation can access.
     *
     * You must use an [installation access token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
     */
    listRepos: {
      (params?: Octokit.RequestOptions & Octokit.AppsListReposParams): Promise<
        Octokit.Response<Octokit.AppsListReposResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Remove a single repository from an installation. The authenticated user must have admin access to the repository.
     *
     * You must use a personal access token (which you can create via the [command line](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or the [OAuth Authorizations API](https://developer.github.com/v3/oauth_authorizations/#create-a-new-authorization)) or [Basic Authentication](https://developer.github.com/v3/auth/#basic-authentication) to access this endpoint.
     */
    removeRepoFromInstallation: {
      (
        params?: Octokit.RequestOptions &
          Octokit.AppsRemoveRepoFromInstallationParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * **Deprecation Notice:** GitHub will replace and discontinue OAuth endpoints containing `access_token` in the path parameter. We are introducing new endpoints that allow you to securely manage tokens for OAuth Apps by using `access_token` as an input parameter. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
     *
     * OAuth applications can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
     * @deprecated octokit.apps.resetAuthorization() is deprecated, see https://developer.github.com/v3/apps/oauth_applications/#reset-an-authorization
     */
    resetAuthorization: {
      (
        params?: Octokit.RequestOptions & Octokit.AppsResetAuthorizationParams
      ): Promise<Octokit.Response<Octokit.AppsResetAuthorizationResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * OAuth applications can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
     */
    resetToken: {
      (params?: Octokit.RequestOptions & Octokit.AppsResetTokenParams): Promise<
        Octokit.Response<Octokit.AppsResetTokenResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * **Deprecation Notice:** GitHub will replace and discontinue OAuth endpoints containing `access_token` in the path parameter. We are introducing new endpoints that allow you to securely manage tokens for OAuth Apps by using `access_token` as an input parameter. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
     *
     * OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password.
     * @deprecated octokit.apps.revokeAuthorizationForApplication() is deprecated, see https://developer.github.com/v3/apps/oauth_applications/#revoke-an-authorization-for-an-application
     */
    revokeAuthorizationForApplication: {
      (
        params?: Octokit.RequestOptions &
          Octokit.AppsRevokeAuthorizationForApplicationParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * **Deprecation Notice:** GitHub will replace and discontinue OAuth endpoints containing `access_token` in the path parameter. We are introducing new endpoints that allow you to securely manage tokens for OAuth Apps by using `access_token` as an input parameter. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
     *
     * OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid token as `:access_token` and the grant for the token's owner will be deleted.
     *
     * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the Applications settings page under "Authorized OAuth Apps" on GitHub](https://github.com/settings/applications#authorized).
     * @deprecated octokit.apps.revokeGrantForApplication() is deprecated, see https://developer.github.com/v3/apps/oauth_applications/#revoke-a-grant-for-an-application
     */
    revokeGrantForApplication: {
      (
        params?: Octokit.RequestOptions &
          Octokit.AppsRevokeGrantForApplicationParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Revokes the installation token you're using to authenticate as an installation and access this endpoint.
     *
     * Once an installation token is revoked, the token is invalidated and cannot be used. Other endpoints that require the revoked installation token must have a new installation token to work. You can create a new token using the "[Create a new installation token](https://developer.github.com/v3/apps/#create-a-new-installation-token)" endpoint.
     *
     * You must use an [installation access token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
     */
    revokeInstallationToken: {
      (params?: Octokit.RequestOptions & Octokit.EmptyParams): Promise<
        Octokit.AnyResponse
      >;

      endpoint: Octokit.Endpoint;
    };
  };
  checks: {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Creates a new check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to create check runs.
     */
    create: {
      (params?: Octokit.RequestOptions & Octokit.ChecksCreateParams): Promise<
        Octokit.Response<Octokit.ChecksCreateResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     *
     * By default, check suites are automatically created when you create a [check run](https://developer.github.com/v3/checks/runs/). You only need to use this endpoint for manually creating check suites when you've disabled automatic creation using "[Set preferences for check suites on a repository](https://developer.github.com/v3/checks/suites/#set-preferences-for-check-suites-on-a-repository)". Your GitHub App must have the `checks:write` permission to create check suites.
     */
    createSuite: {
      (
        params?: Octokit.RequestOptions & Octokit.ChecksCreateSuiteParams
      ): Promise<Octokit.Response<Octokit.ChecksCreateSuiteResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Gets a single check run using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
     */
    get: {
      (params?: Octokit.RequestOptions & Octokit.ChecksGetParams): Promise<
        Octokit.Response<Octokit.ChecksGetResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     *
     * Gets a single check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
     */
    getSuite: {
      (params?: Octokit.RequestOptions & Octokit.ChecksGetSuiteParams): Promise<
        Octokit.Response<Octokit.ChecksGetSuiteResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Lists annotations for a check run using the annotation `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get annotations for a check run. OAuth Apps and authenticated users must have the `repo` scope to get annotations for a check run in a private repository.
     */
    listAnnotations: {
      (
        params?: Octokit.RequestOptions & Octokit.ChecksListAnnotationsParams
      ): Promise<Octokit.Response<Octokit.ChecksListAnnotationsResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Lists check runs for a commit ref. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
     */
    listForRef: {
      (
        params?: Octokit.RequestOptions & Octokit.ChecksListForRefParams
      ): Promise<Octokit.Response<Octokit.ChecksListForRefResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Lists check runs for a check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
     */
    listForSuite: {
      (
        params?: Octokit.RequestOptions & Octokit.ChecksListForSuiteParams
      ): Promise<Octokit.Response<Octokit.ChecksListForSuiteResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     *
     * Lists check suites for a commit `ref`. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to list check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
     */
    listSuitesForRef: {
      (
        params?: Octokit.RequestOptions & Octokit.ChecksListSuitesForRefParams
      ): Promise<Octokit.Response<Octokit.ChecksListSuitesForRefResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Triggers GitHub to rerequest an existing check suite, without pushing new code to a repository. This endpoint will trigger the [`check_suite` webhook](https://developer.github.com/v3/activity/events/types/#checksuiteevent) event with the action `rerequested`. When a check suite is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.
     *
     * To rerequest a check suite, your GitHub App must have the `checks:read` permission on a private repository or pull access to a public repository.
     */
    rerequestSuite: {
      (
        params?: Octokit.RequestOptions & Octokit.ChecksRerequestSuiteParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Changes the default automatic flow when creating check suites. By default, the CheckSuiteEvent is automatically created each time code is pushed to a repository. When you disable the automatic creation of check suites, you can manually [Create a check suite](https://developer.github.com/v3/checks/suites/#create-a-check-suite). You must have admin permissions in the repository to set preferences for check suites.
     */
    setSuitesPreferences: {
      (
        params?: Octokit.RequestOptions &
          Octokit.ChecksSetSuitesPreferencesParams
      ): Promise<Octokit.Response<Octokit.ChecksSetSuitesPreferencesResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Updates a check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to edit check runs.
     */
    update: {
      (params?: Octokit.RequestOptions & Octokit.ChecksUpdateParams): Promise<
        Octokit.Response<Octokit.ChecksUpdateResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
  };
  codesOfConduct: {
    getConductCode: {
      (
        params?: Octokit.RequestOptions &
          Octokit.CodesOfConductGetConductCodeParams
      ): Promise<
        Octokit.Response<Octokit.CodesOfConductGetConductCodeResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * This method returns the contents of the repository's code of conduct file, if one is detected.
     */
    getForRepo: {
      (
        params?: Octokit.RequestOptions & Octokit.CodesOfConductGetForRepoParams
      ): Promise<Octokit.Response<Octokit.CodesOfConductGetForRepoResponse>>;

      endpoint: Octokit.Endpoint;
    };

    listConductCodes: {
      (params?: Octokit.RequestOptions & Octokit.EmptyParams): Promise<
        Octokit.Response<Octokit.CodesOfConductListConductCodesResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
  };
  emojis: {
    /**
     * Lists all the emojis available to use on GitHub.
     */
    get: {
      (params?: Octokit.RequestOptions & Octokit.EmptyParams): Promise<
        Octokit.AnyResponse
      >;

      endpoint: Octokit.Endpoint;
    };
  };
  gists: {
    checkIsStarred: {
      (
        params?: Octokit.RequestOptions & Octokit.GistsCheckIsStarredParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Allows you to add a new gist with one or more files.
     *
     * **Note:** Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.
     */
    create: {
      (params?: Octokit.RequestOptions & Octokit.GistsCreateParams): Promise<
        Octokit.Response<Octokit.GistsCreateResponse>
      >;

      endpoint: Octokit.Endpoint;
    };

    createComment: {
      (
        params?: Octokit.RequestOptions & Octokit.GistsCreateCommentParams
      ): Promise<Octokit.Response<Octokit.GistsCreateCommentResponse>>;

      endpoint: Octokit.Endpoint;
    };

    delete: {
      (params?: Octokit.RequestOptions & Octokit.GistsDeleteParams): Promise<
        Octokit.AnyResponse
      >;

      endpoint: Octokit.Endpoint;
    };

    deleteComment: {
      (
        params?: Octokit.RequestOptions & Octokit.GistsDeleteCommentParams
      ): Promise<Octokit.AnyResponse>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * **Note**: This was previously `/gists/:gist_id/fork`.
     */
    fork: {
      (params?: Octokit.RequestOptions & Octokit.GistsForkParams): Promise<
        Octokit.Response<Octokit.GistsForkResponse>
      >;

      endpoint: Octokit.Endpoint;
    };

    get: {
      (params?: Octokit.RequestOptions & Octokit.GistsGetParams): Promise<
        Octokit.Response<Octokit.GistsGetResponse>
      >;

      endpoint: Octokit.Endpoint;
    };

    getComment: {
      (
        params?: Octokit.RequestOptions & Octokit.GistsGetCommentParams
      ): Promise<Octokit.Response<Octokit.GistsGetCommentResponse>>;

      endpoint: Octokit.Endpoint;
    };

    getRevision: {
      (
        params?: Octokit.RequestOptions & Octokit.GistsGetRevisionParams
      ): Promise<Octokit.Response<Octokit.GistsGetRevisionResponse>>;

      endpoint: Octokit.Endpoint;
    };

    list: {
      (params?: Octokit.RequestOptions & Octokit.GistsListParams): Promise<
        Octokit.Response<Octokit.GistsListResponse>
      >;

      endpoint: Octokit.Endpoint;
    };

    listComments: {
      (
        params?: Octokit.RequestOptions & Octokit.GistsListCommentsParams
      ): Promise<Octokit.Response<Octokit.GistsListCommentsResponse>>;

      endpoint: Octokit.Endpoint;
    };

    listCommits: {
      (
        params?: Octokit.RequestOptions & Octokit.GistsListCommitsParams
      ): Promise<Octokit.Response<Octokit.GistsListCommitsResponse>>;

      endpoint: Octokit.Endpoint;
    };

    listForks: {
      (params?: Octokit.RequestOptions & Octokit.GistsListForksParams): Promise<
        Octokit.Response<Octokit.GistsListForksResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * List all public gists sorted by most recently updated to least recently updated.
     *
     * Note: With [pagination](https://developer.github.com/v3/#pagination), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.
     */
    listPublic: {
      (
        params?: Octokit.RequestOptions & Octokit.GistsListPublicParams
      ): Promise<Octokit.Response<Octokit.GistsListPublicResponse>>;

      endpoint: Octokit.Endpoint;
    };

    listPublicForUser: {
      (
        params?: Octokit.RequestOptions & Octokit.GistsListPublicForUserParams
      ): Promise<Octokit.Response<Octokit.GistsListPublicForUserResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * List the authenticated user's starred gists:
     */
    listStarred: {
      (
        params?: Octokit.RequestOptions & Octokit.GistsListStarredParams
      ): Promise<Octokit.Response<Octokit.GistsListStarredResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
     */
    star: {
      (params?: Octokit.RequestOptions & Octokit.GistsStarParams): Promise<
        Octokit.AnyResponse
      >;

      endpoint: Octokit.Endpoint;
    };

    unstar: {
      (params?: Octokit.RequestOptions & Octokit.GistsUnstarParams): Promise<
        Octokit.AnyResponse
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Allows you to update or delete a gist file and rename gist files. Files from the previous version of the gist that aren't explicitly changed during an edit are unchanged.
     */
    update: {
      (params?: Octokit.RequestOptions & Octokit.GistsUpdateParams): Promise<
        Octokit.Response<Octokit.GistsUpdateResponse>
      >;

      endpoint: Octokit.Endpoint;
    };

    updateComment: {
      (
        params?: Octokit.RequestOptions & Octokit.GistsUpdateCommentParams
      ): Promise<Octokit.Response<Octokit.GistsUpdateCommentResponse>>;

      endpoint: Octokit.Endpoint;
    };
  };
  git: {
    createBlob: {
      (params?: Octokit.RequestOptions & Octokit.GitCreateBlobParams): Promise<
        Octokit.Response<Octokit.GitCreateBlobResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Creates a new Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).
     *
     * In this example, the payload of the signature would be:
     *
     *
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value                    | Description                                                                                                                       |
     * | ------------------------ | --------------------------------------------------------------------------------------------------------------------------------- |
     * | `expired_key`            | The key that made the signature is expired.                                                                                       |
     * | `not_signing_key`        | The "signing" flag is not among the usage flags in the GPG key that made the signature.                                           |
     * | `gpgverify_error`        | There was an error communicating with the signature verification service.                                                         |
     * | `gpgverify_unavailable`  | The signature verification service is currently unavailable.                                                                      |
     * | `unsigned`               | The object does not include a signature.                                                                                          |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit.                                                                                      |
     * | `no_user`                | No user was associated with the `committer` email address in the commit.                                                          |
     * | `unverified_email`       | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email`              | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature.             |
     * | `unknown_key`            | The key that made the signature has not been registered with any user's account.                                                  |
     * | `malformed_signature`    | There was an error parsing the signature.                                                                                         |
     * | `invalid`                | The signature could not be cryptographically verified using the key whose key-id was found in the signature.                      |
     * | `valid`                  | None of the above errors applied, so the signature is considered to be verified.                                                  |
     */
    createCommit: {
      (
        params?: Octokit.RequestOptions & Octokit.GitCreateCommitParams
      ): Promise<Octokit.Response<Octokit.GitCreateCommitResponse>>;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Creates a reference for your repository. You are unable to create new references for empty repositories, even if the commit SHA-1 hash used exists. Empty repositories are repositories without branches.
     */
    createRef: {
      (params?: Octokit.RequestOptions & Octokit.GitCreateRefParams): Promise<
        Octokit.Response<Octokit.GitCreateRefResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Note that creating a tag object does not create the reference that makes a tag in Git. If you want to create an annotated tag in Git, you have to do this call to create the tag object, and then [create](https://developer.github.com/v3/git/refs/#create-a-reference) the `refs/tags/[tag]` reference. If you want to create a lightweight tag, you only have to [create](https://developer.github.com/v3/git/refs/#create-a-reference) the tag reference - this call would be unnecessary.
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value                    | Description                                                                                                                       |
     * | ------------------------ | --------------------------------------------------------------------------------------------------------------------------------- |
     * | `expired_key`            | The key that made the signature is expired.                                                                                       |
     * | `not_signing_key`        | The "signing" flag is not among the usage flags in the GPG key that made the signature.                                           |
     * | `gpgverify_error`        | There was an error communicating with the signature verification service.                                                         |
     * | `gpgverify_unavailable`  | The signature verification service is currently unavailable.                                                                      |
     * | `unsigned`               | The object does not include a signature.                                                                                          |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit.                                                                                      |
     * | `no_user`                | No user was associated with the `committer` email address in the commit.                                                          |
     * | `unverified_email`       | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email`              | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature.             |
     * | `unknown_key`            | The key that made the signature has not been registered with any user's account.                                                  |
     * | `malformed_signature`    | There was an error parsing the signature.                                                                                         |
     * | `invalid`                | The signature could not be cryptographically verified using the key whose key-id was found in the signature.                      |
     * | `valid`                  | None of the above errors applied, so the signature is considered to be verified.                                                  |
     */
    createTag: {
      (params?: Octokit.RequestOptions & Octokit.GitCreateTagParams): Promise<
        Octokit.Response<Octokit.GitCreateTagResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * The tree creation API accepts nested entries. If you specify both a tree and a nested path modifying that tree, this endpoint will overwrite the contents of the tree with the new path contents, and create a new tree structure.
     *
     * If you use this endpoint to add, delete, or modify the file contents in a tree, you will need to commit the tree and then update a branch to point to the commit. For more information see "[Create a commit](https://developer.github.com/v3/git/commits/#create-a-commit)" and "[Update a reference](https://developer.github.com/v3/git/refs/#update-a-reference)."
     */
    createTree: {
      (params?: Octokit.RequestOptions & Octokit.GitCreateTreeParams): Promise<
        Octokit.Response<Octokit.GitCreateTreeResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * ```
     * DELETE /repos/octocat/Hello-World/git/refs/heads/feature-a
     * ```
     *
     * ```
     * DELETE /repos/octocat/Hello-World/git/refs/tags/v1.0
     * ```
     */
    deleteRef: {
      (params?: Octokit.RequestOptions & Octokit.GitDeleteRefParams): Promise<
        Octokit.AnyResponse
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * The `content` in the response will always be Base64 encoded.
     *
     * _Note_: This API supports blobs up to 100 megabytes in size.
     */
    getBlob: {
      (params?: Octokit.RequestOptions & Octokit.GitGetBlobParams): Promise<
        Octokit.Response<Octokit.GitGetBlobResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Gets a Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value                    | Description                                                                                                                       |
     * | ------------------------ | --------------------------------------------------------------------------------------------------------------------------------- |
     * | `expired_key`            | The key that made the signature is expired.                                                                                       |
     * | `not_signing_key`        | The "signing" flag is not among the usage flags in the GPG key that made the signature.                                           |
     * | `gpgverify_error`        | There was an error communicating with the signature verification service.                                                         |
     * | `gpgverify_unavailable`  | The signature verification service is currently unavailable.                                                                      |
     * | `unsigned`               | The object does not include a signature.                                                                                          |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit.                                                                                      |
     * | `no_user`                | No user was associated with the `committer` email address in the commit.                                                          |
     * | `unverified_email`       | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email`              | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature.             |
     * | `unknown_key`            | The key that made the signature has not been registered with any user's account.                                                  |
     * | `malformed_signature`    | There was an error parsing the signature.                                                                                         |
     * | `invalid`                | The signature could not be cryptographically verified using the key whose key-id was found in the signature.                      |
     * | `valid`                  | None of the above errors applied, so the signature is considered to be verified.                                                  |
     */
    getCommit: {
      (params?: Octokit.RequestOptions & Octokit.GitGetCommitParams): Promise<
        Octokit.Response<Octokit.GitGetCommitResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * Returns a single reference from your Git database. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't match an existing ref, a `404` is returned.
     *
     * **Note:** You need to explicitly [request a pull request](https://developer.github.com/v3/pulls/#get-a-single-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://developer.github.com/v3/git/#checking-mergeability-of-pull-requests)".
     *
     * To get the reference for a branch named `skunkworkz/featureA`, the endpoint route is:
     */
    getRef: {
      (params?: Octokit.RequestOptions & Octokit.GitGetRefParams): Promise<
        Octokit.Response<Octokit.GitGetRefResponse>
      >;

      endpoint: Octokit.Endpoint;
    };
    /**
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value                    | Description                                                                                                                       |
     * | ------------------------ | --------------------------------------------------------------------------------------------------------------------------------- |
     * | `expired_key`            | The key that made the signature is expired.                                                                                       |
     * | `not_signing_key`        | The "signing" flag is not among the usage flags in the GPG key that made the signature.                                           |
     * | `gpgverify_error`        | There was an error communicating with the signature verification service.                                                         |
     * | `gpgverify_unavailable`  | The signature verification service is currently unavailable.                                                                      |
     * | `unsigned`               | The object does not include a signature.                                                                                          |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit.                                                                                      |
     * | `no_user`                | No user was associated with the `committer` email address in the commit.                                                          |
     * | `unverified_email`     