"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useControls = void 0;
const render_1 = require("@betterer/render");
function useControls(context) {
    const { isRawModeSupported } = (0, render_1.useStdin)();
    const [editing, setEditing] = (0, render_1.useState)(null);
    const canEdit = isRawModeSupported;
    const useEdit = canEdit ? render_1.useInput : () => void 0;
    isRawModeSupported &&
        useEdit((input, key) => {
            if (key.return) {
                setEditing(null);
                return;
            }
            if (key.escape) {
                void context.stop();
                return;
            }
            if (editing != null) {
                return;
            }
            // Don't exit on 'q' if the user is editing filters or ignores:
            if (input === 'q') {
                void context.stop();
            }
            if (input === 'f') {
                setEditing('filters');
            }
            if (input === 'i') {
                setEditing('ignores');
            }
        });
    return editing;
}
exports.useControls = useControls;
//# sourceMappingURL=useControls.js.map