import { FieldValues } from './fields';
import { NestedValue } from './form';
export declare type Primitive = null | undefined | string | number | boolean | symbol | bigint;
export declare type EmptyObject = {
    [K in string | number]: never;
};
export declare type NonUndefined<T> = T extends undefined ? never : T;
export declare type LiteralUnion<T extends U, U extends Primitive> = T | (U & {
    _?: never;
});
export declare type DeepPartial<T> = T extends Array<infer U> ? Array<DeepPartial<U>> : T extends ReadonlyArray<infer U> ? ReadonlyArray<DeepPartial<U>> : T extends {
    [key in keyof T]: T[key];
} ? {
    [K in keyof T]?: DeepPartial<T[K]>;
} : T;
export declare type IsAny<T> = boolean extends (T extends never ? true : false) ? true : false;
export declare type DeepMap<T, TValue> = {
    [K in keyof T]?: IsAny<T[K]> extends true ? any : NonUndefined<T[K]> extends NestedValue | Date | FileList ? TValue : NonUndefined<T[K]> extends object ? DeepMap<T[K], TValue> : NonUndefined<T[K]> extends Array<infer U> ? IsAny<U> extends true ? Array<any> : U extends NestedValue | Date | FileList ? Array<TValue> : U extends object ? Array<DeepMap<U, TValue>> : Array<TValue> : TValue;
};
export declare type IsFlatObject<T extends object> = Extract<Exclude<T[keyof T], NestedValue | Date | FileList>, any[] | object> extends never ? true : false;
declare type IsTuple<T extends ReadonlyArray<any>> = number extends T['length'] ? false : true;
declare type TupleKey<T extends ReadonlyArray<any>> = Exclude<keyof T, keyof any[]>;
declare type ArrayKey = number;
declare type PathImpl<K extends string | number, V> = V extends Primitive ? `${K}` : `${K}` | `${K}.${Path<V>}`;
export declare type Path<T> = T extends ReadonlyArray<infer V> ? IsTuple<T> extends true ? {
    [K in TupleKey<T>]-?: PathImpl<K & string, T[K]>;
}[TupleKey<T>] : PathImpl<ArrayKey, V> : {
    [K in keyof T]-?: PathImpl<K & string, T[K]>;
}[keyof T];
export declare type FieldPath<TFieldValues extends FieldValues> = Path<TFieldValues>;
declare type ArrayPathImpl<K extends string | number, V> = V extends Primitive ? never : V extends ReadonlyArray<infer U> ? U extends Primitive ? never : `${K}` | `${K}.${ArrayPath<V>}` : `${K}.${ArrayPath<V>}`;
export declare type ArrayPath<T> = T extends ReadonlyArray<infer V> ? IsTuple<T> extends true ? {
    [K in TupleKey<T>]-?: ArrayPathImpl<K & string, T[K]>;
}[TupleKey<T>] : ArrayPathImpl<ArrayKey, V> : {
    [K in keyof T]-?: ArrayPathImpl<K & string, T[K]>;
}[keyof T];
export declare type FieldArrayPath<TFieldValues extends FieldValues> = ArrayPath<TFieldValues>;
export declare type PathValue<T, P extends Path<T> | ArrayPath<T>> = P extends `${infer K}.${infer R}` ? K extends keyof T ? R extends Path<T[K]> ? PathValue<T[K], R> : never : K extends `${ArrayKey}` ? T extends ReadonlyArray<infer V> ? PathValue<V, R & Path<V>> : never : never : P extends keyof T ? T[P] : P extends `${ArrayKey}` ? T extends ReadonlyArray<infer V> ? V : never : never;
export declare type FieldPathValue<TFieldValues extends FieldValues, TFieldPath extends FieldPath<TFieldValues>> = PathValue<TFieldValues, TFieldPath>;
export declare type FieldArrayPathValue<TFieldValues extends FieldValues, TFieldArrayPath extends FieldArrayPath<TFieldValues>> = PathValue<TFieldValues, TFieldArrayPath>;
export declare type FieldPathValues<TFieldValues extends FieldValues, TPath extends FieldPath<TFieldValues>[]> = {} & {
    [K in keyof TPath]: FieldPathValue<TFieldValues, TPath[K] & FieldPath<TFieldValues>>;
};
export {};
