import { BettererErrorDetails } from './types';
/**
 * @public A custom Error for use in **Betterer**. It attaches some extra details to a standard
 * JavaScript error for better logging and debugging.
 *
 * @param message - The error message.
 * @param details - Extra details for the error.
 */
export declare class BettererError extends Error {
    /**
     * Extra details for the error.
     */
    details: BettererErrorDetails;
    /**
     * Used by {@link @betterer/errors#isBettererError | `isBettererError()`} to detect that an
     * object is an instance of `BettererError`.
     */
    isBettererError: boolean;
    constructor(message: string, ...details: BettererErrorDetails);
}
/**
 * @public Check if an object is a {@link BettererError | `BettererError`}.
 *
 * @example
 * ```typescript
 * import { BettererError, isBettererError } from '@betterer/errors';
 *
 * isBettererError(new Error()); // false
 * isBettererError(new BettererError()); // true
 * ```
 */
export declare function isBettererError(err: unknown): err is BettererError;
//# sourceMappingURL=error.d.ts.map