import { SynchronousPromise } from 'synchronous-promise';
import { Channel } from '@storybook/addons';
import { AnyFramework, StoryId, ProjectAnnotations, Args, Globals, ViewMode } from '@storybook/csf';
import { ModuleImportFn, Selection, Story, RenderContext, StoryStore, StorySpecifier, StoryIndex } from '@storybook/store';
import { WebProjectAnnotations } from './types';
import { UrlStore } from './UrlStore';
import { WebView } from './WebView';
export declare type RenderPhase = 'loading' | 'rendering' | 'playing' | 'played' | 'completed' | 'aborted' | 'errored';
declare type PromiseLike<T> = Promise<T> | SynchronousPromise<T>;
declare type MaybePromise<T> = Promise<T> | T;
declare type StoryCleanupFn = () => MaybePromise<void>;
export declare class PreviewWeb<TFramework extends AnyFramework> {
    channel: Channel;
    serverChannel?: Channel;
    urlStore: UrlStore;
    storyStore: StoryStore<TFramework>;
    view: WebView;
    getStoryIndex?: () => StoryIndex;
    importFn?: ModuleImportFn;
    renderToDOM: WebProjectAnnotations<TFramework>['renderToDOM'];
    previewEntryError?: Error;
    previousSelection: Selection;
    previousStory: Story<TFramework>;
    previousCleanup: StoryCleanupFn;
    abortController: AbortController;
    disableKeyListeners: boolean;
    constructor();
    initialize({ getStoryIndex, importFn, getProjectAnnotations, }: {
        getStoryIndex?: () => StoryIndex;
        importFn: ModuleImportFn;
        getProjectAnnotations: () => MaybePromise<WebProjectAnnotations<TFramework>>;
    }): Promise<Promise<void>>;
    setupListeners(): void;
    getProjectAnnotationsOrRenderError(getProjectAnnotations: () => MaybePromise<WebProjectAnnotations<TFramework>>): PromiseLike<ProjectAnnotations<TFramework>>;
    initializeWithProjectAnnotations(projectAnnotations: WebProjectAnnotations<TFramework>): Promise<Promise<void>>;
    setInitialGlobals(): Promise<void>;
    emitGlobals(): void;
    getStoryIndexFromServer(): Promise<StoryIndex>;
    initializeWithStoryIndex(storyIndex: StoryIndex): globalThis.PromiseLike<Promise<void>>;
    selectSpecifiedStory(): Promise<void>;
    onGetProjectAnnotationsChanged({ getProjectAnnotations, }: {
        getProjectAnnotations: () => MaybePromise<ProjectAnnotations<TFramework>>;
    }): Promise<void>;
    onStoryIndexChanged(): Promise<void>;
    onStoriesChanged({ importFn, storyIndex, }: {
        importFn?: ModuleImportFn;
        storyIndex?: StoryIndex;
    }): Promise<void>;
    onKeydown(event: KeyboardEvent): void;
    onSetCurrentStory(selection: Selection): void;
    onUpdateQueryParams(queryParams: any): void;
    onUpdateGlobals({ globals }: {
        globals: Globals;
    }): void;
    onUpdateArgs({ storyId, updatedArgs }: {
        storyId: StoryId;
        updatedArgs: Args;
    }): void;
    onResetArgs({ storyId, argNames }: {
        storyId: string;
        argNames?: string[];
    }): Promise<void>;
    renderSelection({ persistedArgs }?: {
        persistedArgs?: Args;
    }): Promise<void>;
    renderDocs({ story }: {
        story: Story<TFramework>;
    }): Promise<() => Promise<void>>;
    renderStory({ story }: {
        story: Story<TFramework>;
    }): StoryCleanupFn;
    renderStoryToElement({ story, renderContext: renderContextWithoutStoryContext, element: canvasElement, viewMode, }: {
        story: Story<TFramework>;
        renderContext: Pick<RenderContext<TFramework>, Exclude<keyof RenderContext<TFramework>, 'storyContext' | 'storyFn' | 'unboundStoryFn' | 'forceRemount'>>;
        element: HTMLElement;
        viewMode: ViewMode;
    }): StoryCleanupFn;
    extract(options?: {
        includeDocsOnly: boolean;
    }): Promise<Record<string, import("@storybook/csf").StoryContextForEnhancers<TFramework, Args>>>;
    cleanupPreviousRender({ unmountDocs }?: {
        unmountDocs?: boolean;
    }): Promise<void>;
    renderPreviewEntryError(reason: string, err: Error): void;
    renderMissingStory(): void;
    renderStoryLoadingException(storySpecifier: StorySpecifier, err: Error): void;
    renderException(storyId: StoryId, err: Error): void;
    renderError(storyId: StoryId, { title, description }: {
        title: string;
        description: string;
    }): void;
}
export {};
