"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BettererErrorLog = void 0;
const errors_1 = require("@betterer/errors");
const render_1 = require("@betterer/render");
/**
 * @public Ink component for rendering a {@link @betterer/errors#BettererError | `BettererError` }
 * and all its additional information. The `message`, `stack` and `details` of the `error` will be
 * printed. If any `detail` is an `Error` or  {@link @betterer/errors#BettererError | `BettererError`},
 * the component will be rendered recursively.
 */
const BettererErrorLog = function BettererErrorLog({ error }) {
    let errors = [];
    let details = [];
    if ((0, errors_1.isBettererError)(error)) {
        errors = error.details.filter((detail) => isError(detail));
        details = error.details.filter((detail) => !isError(detail));
    }
    return (render_1.React.createElement(render_1.React.Fragment, null,
        render_1.React.createElement(render_1.Box, { flexDirection: "column", paddingTop: 1 },
            render_1.React.createElement(render_1.Box, null,
                render_1.React.createElement(render_1.Text, { color: "redBright" }, "Error: "),
                render_1.React.createElement(render_1.Text, null, error.message)),
            error.stack ? (render_1.React.createElement(render_1.Box, { paddingLeft: 2 },
                render_1.React.createElement(render_1.Text, null, processStack(error.stack)))) : null,
            details.map((detail, index) => (render_1.React.createElement(render_1.Box, { key: index, paddingTop: 1 },
                render_1.React.createElement(render_1.Text, null, detail.trim()))))),
        errors.map((error, index) => (render_1.React.createElement(BettererErrorLog, { key: index, error: error })))));
};
exports.BettererErrorLog = BettererErrorLog;
function isError(value) {
    return value.message != null && value.stack !== null;
}
function processStack(stack) {
    const [, ...stackLines] = stack.split('\n');
    return stackLines.slice(0, 10).join('\n');
}
//# sourceMappingURL=error-log.js.map